##############################################################################
#
# Copyright (c) 2006 Zope Foundation and Contributors.
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#
##############################################################################
"""Buildout package
"""

class UserError(Exception):
    """Errors made by a user 
    """

    def __str__(self):
        return " ".join(map(str, self.args))

# Used for Python 2-3 compatibility
if str is bytes:
    bytes2str = str2bytes = lambda s: s
    def unicode2str(s):
        return s.encode('utf-8')
else:
    def bytes2str(s):
        return s.decode()
    def str2bytes(s):
        return s.encode()
    def unicode2str(s):
        return s
