import configparser
import hashlib
import logging
import os

import requests

urls = []
session = requests.Session()
timeout = 30
logger = logging.getLogger()
logging.basicConfig(level=logging.DEBUG)

for plugin_and_version in '''\
    vscode/bat/latest
    vscode/clojure/latest
    vscode/coffeescript/latest
    vscode/configuration-editing/latest
    vscode/cpp/latest
    vscode/csharp/latest
    vscode/css/latest
    vscode/css-language-features/latest
    vscode/debug-auto-launch/latest
    vscode/docker/latest
    vscode/emmet/latest
    vscode/fsharp/latest
    vscode/git-base/latest
    vscode/git/latest
    vscode/go/latest
    vscode/groovy/latest
    vscode/grunt/latest
    vscode/gulp/latest
    vscode/handlebars/latest
    vscode/hlsl/latest
    vscode/html/latest
    vscode/html-language-features/latest
    vscode/ini/latest
    vscode/jake/latest
    vscode/java/latest
    vscode/javascript/latest
# js-debug 1.66.1 was starting OK with previous theia version, but since 1.27.0:
# Activating extension 'JavaScript Debugger' failed: a.window.registerTerminalProfileProvider is not a function
# (which is curious because registerTerminalProfileProvider was never supported in Theia)
    ms-vscode/js-debug/1.51.0
    vscode/json/latest
    vscode/json-language-features/latest
    vscode/less/latest
    vscode/log/latest
    vscode/lua/latest
    vscode/make/latest
    vscode/markdown/latest
# Activating extension 'Markdown Language Features (built-in)' failed:
# i.workspace.onWillDropOnTextEditor is not a function
    vscode/markdown-language-features/1.64.2
    vscode/merge-conflict/latest
    vscode/npm/latest
    ms-vscode/node-debug/latest
    ms-vscode/node-debug2/latest
    vscode/objective-c/latest
    vscode/perl/latest
    vscode/powershell/latest
    vscode/pug/latest
    vscode/python/latest
    vscode/r/latest
    vscode/razor/latest
    vscode/ruby/latest
    vscode/rust/latest
    vscode/scss/latest
    vscode/shaderlab/latest
    vscode/shellscript/latest
    vscode/sql/latest
    vscode/swift/latest
    vscode/theme-abyss/latest
    vscode/theme-defaults/latest
    vscode/theme-kimbie-dark/latest
    vscode/theme-monokai/latest
    vscode/theme-monokai-dimmed/latest
    vscode/theme-quietlight/latest
    vscode/theme-red/latest
    vscode/theme-solarized-dark/latest
    vscode/theme-tomorrow-night-blue/latest
    vscode/typescript/latest
    vscode/typescript-language-features/1.62.3
    vscode/vb/latest
    vscode/vscode-theme-seti/latest
    vscode/xml/latest
    vscode/yaml/latest
    EditorConfig/EditorConfig/latest
    dbaeumer/vscode-eslint/latest
    ms-vscode/references-view/latest
    ms-python/python/2022.4.1
    perrinjerome/vscode-zc-buildout/latest
    jebbs/plantuml/2.14.0
    rafaelmaiolla/diff/latest
    perrinjerome/git-commit-syntax/latest
    perrinjerome/git-rebase-syntax/latest
'''.splitlines():
  plugin_and_version = plugin_and_version.strip()
  if not plugin_and_version or plugin_and_version.startswith('#'):
    continue
  publisher, extension_name, version = plugin_and_version.split('/')

  api_url = f'https://open-vsx.org/api/{publisher}/{extension_name}/{version}'
  logger.info(plugin_and_version)
  download_url = session.get(api_url, timeout=timeout).json()['files']['download']
  md5sum = hashlib.md5(session.get(download_url, timeout=timeout).content).hexdigest()
  urls.append(f'{publisher}-{extension_name} {download_url} {md5sum}')

cfg = configparser.ConfigParser()
cfg.add_section('theia-download-plugins')
cfg.set('theia-download-plugins', 'urls', '\n'.join(urls))

with open('download-plugins.cfg', 'w') as f:
  f.write(f"""\
# This file is automatically generated from {os.path.basename(__file__)}
# Do not edit directly.
""")
  cfg.write(f)
