#! /usr/bin/env python
# -*- coding: utf-8 -*-

import MyRedis2410 as redis
import time
import socket
import UserDict
import os
import sys
import time
import select
from struct import *
from signal import SIGTERM
import subprocess
import ast
#Parser and logging import
import ConfigParser
import logging
import logging.handlers
from optparse import OptionParser, Option

logger = logging.getLogger("BonjourGRID")

class Parser(OptionParser):
  """
  Parse all arguments.
  """
  def __init__(self, usage=None, version=None):
    """
    Initialize all possible options.
    """
    OptionParser.__init__(self, usage=usage, version=version,
                          option_list=[
                            Option("-l", "--log_file",
                                   help="The path to the log file used by the script.",
                                   type=str),
                            Option('-i', "--pid_file",
                                   help="The path to the pid file used by the script.",
                                   default="",
                                   type=str),
                            Option("-t", "--install_directory",
                                   help="The path to use as bonjourGrid source directory.",
                                   default="",
                                   type=str),
                            Option("-d", "--directory",
                                   help="The path to use as Current work directory.",
                                   default="",
                                   type=str),
                            Option("-o", "--boinc_wrapper",
                                   help="The path to BOINC Workers launcher script.",
                                   default="",
                                   type=str),
                            Option("-r", "--condor_wrapper",
                                   help="The path to Condor Workers launcher script.",
                                   default="",
                                   type=str),
                            Option("-v", "--verbose",
                                   default=False,
                                   action="store_true",
                                   help="Verbose output."),
                            Option("-c", "--console",
                                   default=False,
                                   action="store_true",
                                   help="Console output."),
                            Option("-s", "--server",
                                   action="store", dest='server',
                                   help="Redis-Server hostname or IP address."),
                            Option("-p", "--port",
                                   default=6379,
                                   action="store", dest='port',
                                   type=int, help="Server port."),
                          ])

  def check_args(self):
    """
    Check arguments
    """
    (options, args) = self.parse_args()
    if not options.server:
      self.error("Wrong arguments: Provide Redis-Server hostname or IP. Try -h option to display help")
    if not options.condor_wrapper:
      self.error("Wrong arguments: Missing Condor wrapper file. Try -h option to display help")
    if not options.boinc_wrapper:
      self.error("Wrong arguments: Missing BOINC wrapper file. Try -h option to display help")
    return options

def setArguments():
  usage = "usage: %s [options]" % sys.argv[0]
  parser = Parser(usage=usage).check_args()
  logger.setLevel(logging.INFO)
  if parser.console:
    console_handler = logging.StreamHandler()
    console_handler.setFormatter(logging.Formatter("%(name)s - %(levelname)s - %(message)s"))
    logger.addHandler(console_handler)
  if parser.log_file:
    if not os.path.isdir(os.path.dirname(parser.log_file)):
      # fallback to console only if directory for logs does not exists and
      # continue to run
      raise ValueError('Please create directory %r to store %r log file' % (
        os.path.dirname(parser.log_file), parser.log_file))
    else:
      file_handler = logging.FileHandler(parser.log_file)
      file_handler.setFormatter(logging.Formatter("%(asctime)s - %(name)s - %(levelname)s - %(message)s"))
      logger.addHandler(file_handler)
      logger.info('Configured logging to file %r' % parser.log_file)
  if parser.pid_file:
    if not os.path.isdir(os.path.dirname(parser.pid_file)):
      raise ValueError('Please create directory %r to store %r pid file' % (
        os.path.dirname(parser.pid_file), parser.pid_file))
    else:
      open(parser.pid_file, 'w').write(str(os.getpid()))
  if not os.path.exists(parser.condor_wrapper):
    raise ValueError('File not found: Cannot open file "%s"' %
                     parser.condor_wrapper)
  if not os.path.exists(parser.boinc_wrapper):
    raise ValueError('File not found: Cannot open file "%s"' %
                     parser.boinc_wrapper)
  if parser.directory:
    if not os.path.isdir(parser.directory):
      raise ValueError('Please create directory %r to store local files' % (
        parser.directory))
    else:
      os.chdir(parser.directory)
  if not parser.install_directory:
    parser.install_directory = os.getcwd()
  return parser

#-------------------------------------------------------------------------------
def MyConvert(i):
  return pack('h', i)[0]
#------------------------------------------------------------------------------
def fileExists(fichier):
  try:
    file(fichier)
    return True
  except:
    return False
#---------------------------------------------------------------------------
def DeleteFile(fichier):
  #os.system("tput setaf 1")
  if fileExists(fichier):
    os.system('rm -f '+fichier)
    logger.info("[BG:SYS] The file --" + fichier + "-- is deleted")
  else:
    logger.info("[BG:SYS] The file --" + fichier + "-- does not exist")
  #os.system("tput setaf 0")
#-------------------------------------------------------------------------------
def SetMypidInFile(fichier):
  pfile = open(fichier,"w")
  mypid=os.getpid()
  strpid=str(mypid)
  pfile.write(strpid)
  pfile.flush()
  pfile.close()
#------------------------------------------------------------------------------
def ConvertHostname(name):
  list=name.split('.')
  type=''
  for i in range(len(list)):
    type=type+list[i]
  return '_'+type+'._tcp'

#------------------------------------------------------------------------------
def DeletePoints(name):
  list=name.split('.')
  type=''
  for i in range(len(list)):
    type=type+list[i]
  return type
#------------------------------------------------------------------------------
def ReadFile(name):
  fd = open(name,"rb")
  data = fd.read().strip()
  fd.close()
  return data


#-----------------------------------------------------------------------
def Browse(servicetype,coordfile):
  #r = redis.Redis(host='grid6.cck.rnu.tn') 
  r = redis.Redis(connection_pool=pool)
  rr=r.pubsub()
  rr.subscribe(servicetype)
  for msg in rr.listen():
    #print msg
    #master = msg['data']
    #print master
     break
  mydict={}
  try:
    logger.info("I discovred a Coordinator...")
    txtrecord=msg['data']
    #print txtrecord,"*********",len(txtrecord),"\n"
    mydict = UserDict.UserDict(ast.literal_eval(txtrecord)) # I record the master machine in my dict
  except:
    logger.error("PB in ResolveCallback, it is not a dictionary")

  #Writing Machine discovery in the file CoordinatorFile (Necessary to pass this info to the main function)
  cfile=open(coordfile,"w")
  strmydict=str(mydict)
  cfile.write(strmydict)
  cfile.flush()
  cfile.close()

#-----------------------------------------------------------------------
def BrowseCoordinator(servicetype, pidfile, coordfile):
  Browse(servicetype,coordfile)
  while 1:
    if fileExists(coordfile):
      time.sleep(1)
      break
#-----------------------------------------------------------------------
def SetStatus(hostname, data, pidfile, servicetype):
  SetMypidInFile(pidfile)
  r = redis.Redis(connection_pool=pool)
  r.publish(servicetype,data)

#--------------------------------------------------------------------------
if __name__ == '__main__':
  parser = setArguments()
  logger.info("Automatic generation of the machine features")
  os.system('sh %s' % 'machineinfo.worker.sh')
  hostname = socket.gethostname()

  logger.info("Establishing connection to redis server at: %s" % parser.server)
  pool = redis.ConnectionPool(host=parser.server, port=parser.port, db=0)

  # On lit le fichier des caracteristiques:
  data=ReadFile(hostname)
  rep=DeletePoints(hostname)
  if 1==1:
  
    logger.info("Deleting the old files")
    MyCoordinatordict={}
    DeleteFile("CoordinatorIsDiscovered")
    DeleteFile("pidfileidle")
    DeleteFile("pidfileworker")
    DeleteFile("CoordinatorHasGone")
    master=''
    servicetype=DeletePoints(hostname)
    pid=os.fork()
    if pid==0:
      logger.info("Search master for working...")
      BrowseCoordinator(servicetype, "pidfileidle", "CoordinatorIsDiscovered")
    else:
      logger.info("(STATUS=IDLE) I'm Idle and I'm waiting for new calls")
      SetStatus(hostname,data,"pidfileidle", "idle")
      try:
        os.waitpid(pid, 0)
      except:
        pass
      logger.info("Found BonjourGrid Master Node, continue...")
      try:
        datacoord=ReadFile("CoordinatorIsDiscovered")
        logger.info("Save discovred coordinator into a dict")
        MyCoordinatordict= UserDict.UserDict(ast.literal_eval(datacoord))
        logger.info("The new master %s calls me to work for the project at '%s'" %
              (MyCoordinatordict["HOST"], MyCoordinatordict["PROJECT"]))

      except:
        logger.error("Ce n'est pas un dictionnaire")
      #time.sleep(5)
      if len(MyCoordinatordict) > 0:
       pid=os.fork()
       if pid==0:
        logger.info("Send confirmation to the master...")
        servicetype=DeletePoints(MyCoordinatordict["HOST"])+'-master'
        #time.sleep(5)
        SetStatus(hostname,data,"pidfileworker", servicetype) # changer data
       else:
        os.waitpid(pid, 0)
        pid=os.fork()
        if pid==0:
          #le worker est tue si la machine coordinateur est arrete... cad si le coordinateur publie un nouveau service indiquant la fin de l'application
          servicetype=MyCoordinatordict["HOST"]+"app-finished"
          BrowseCoordinator(servicetype, "pidfileworker", "CoordinatorHasGone")
          logger.info("The master " + master + " has gone")
          logger.info("Stopping the BOINC worker...")
          sys.exit(0)
        else:
          logger.info("Starting the BOINC worker...")
          logger.info("(STATUS=WORKER) I will work for this Master --> " + master)
          tmp_file = os.path.join(os.getcwd(), 'occupied')
          os.system("echo 'worker' > %r" % tmp_file)
          middleware = MyCoordinatordict["MIDDLEWARE"]
          if middleware == "boinc":
            #XXX : Use full URL provide by Bonjourgrid Master here!!
              wrapper = [parser.boinc_wrapper, MyCoordinatordict["PROJECT"]]
          else:
              wrapper = [parser.condor_wrapper, MyCoordinatordict["PROJECT"]]
          process = subprocess.Popen(wrapper, stdout=subprocess.PIPE,
                                     stderr=subprocess.STDOUT)
                
          result = process.communicate()[0]
          if process.returncode is None or process.returncode != 0:
            print "Failed to lauch %s.\nThe error was: %s" % (middleware, result)
            logger.error("BonjourGrid Client has Failed with result: %s \nStopping...Send SIGTERM" % result)
            try:
              os.kill(pid, SIGTERM)
            except:
              pass
            sys.exit(1)
          logger.info("MIDDLEWARE: " + result)
          try:
            os.waitpid(pid)
          except:
            pass
          sys.exit(0)
