extern "C" {
#include "jit.common.h"
}

#include <math.h>


typedef struct _slitz_off 
{
	t_object				ob;

	float offset;
	} t_slitz_off;

void *_slitz_off_class;

t_slitz_off *slitz_off_new(void);
void slitz_off_free(t_slitz_off *x);
t_jit_err slitz_off_matrix_calc(t_slitz_off *x, void *inputs, void *outputs);


t_jit_err slitz_off_init(void) 
{
	long attrflags=0;
	t_jit_object *attr, *mop;
	
	_slitz_off_class = jit_class_new("slitz.off",(method)slitz_off_new,(method)slitz_off_free,
		sizeof(t_slitz_off),A_CANT,0L); //A_CANT = untyped

	//add mop
	mop = (t_jit_object *)jit_object_new(_jit_sym_jit_mop,1,1); //#inputs,#outputs
	jit_mop_single_type(mop,_jit_sym_float32);	
	jit_mop_single_planecount(mop,2);	

	jit_class_addadornment(_slitz_off_class,mop);

	//add methods
	jit_class_addmethod(_slitz_off_class, (method)slitz_off_matrix_calc, "matrix_calc", A_CANT, 0L);

	//add attributes	
	attrflags = JIT_ATTR_GET_DEFER_LOW | JIT_ATTR_SET_USURP_LOW;

	attr = (object *)jit_object_new(_jit_sym_jit_attr_offset,"offset",_jit_sym_float32,attrflags,(method)0L,(method)0L,calcoffset(t_slitz_off,offset));
	jit_class_addattr(_slitz_off_class,attr);

	jit_class_register(_slitz_off_class);

	return JIT_ERR_NONE;
}


inline double sqr(double x) { return x*x; }
inline float sqr(float x) { return x*x; }

static double dist(double ax,double ay,double bx,double by)
{
	return sqrt(sqr(ax-bx)+sqr(ay-by));
}

static void OffsetPoints(const t_jit_matrix_info &in_minfo,float *in_bp,const t_jit_matrix_info &out_minfo,float *out_bp,float offset)
{
	int istr = in_minfo.dimstride[0]/sizeof(*in_bp);
	int ostr = out_minfo.dimstride[0]/sizeof(*out_bp);
	int i,points = in_minfo.dim[0]-1,id = (points-1)*istr,od;
	double cx,cy,vx,vy,vl,wx,wy,wl,mx,my,ml,nx,ny;


	float lx = in_bp[id],ly = in_bp[id+1];

	float sgn = 0.;
	for(i = id = 0; i < points; ++i,id += istr) {
		cx = in_bp[id],cy = in_bp[id+1];
		vx = lx-cx,vy = ly-cy,vl = sqrt(sqr(vx)+sqr(vy));
		vx /= vl,vy /= vl;
		wx = in_bp[id+istr]-cx,wy = in_bp[id+istr+1]-cy,wl = sqrt(sqr(wx)+sqr(wy));
		wx /= wl,wy /= wl;
		mx = vx+wx,my = vy+wy,ml = sqrt(sqr(mx)+sqr(my));
		
		if(ml) sgn += (wx*my-wy*mx)/ml;
		lx = cx,ly = cy;
	}
	sgn /= fabs(sgn);
	
	id = (points-1)*istr;
	lx = in_bp[id],ly = in_bp[id+1];
	for(i = id = od = 0; i < points; ++i,id += istr,od += ostr) {
		cx = in_bp[id],cy = in_bp[id+1];
		vx = lx-cx,vy = ly-cy,vl = sqrt(sqr(vx)+sqr(vy));
		vx /= vl,vy /= vl;
		wx = in_bp[id+istr]-cx,wy = in_bp[id+istr+1]-cy,wl = sqrt(sqr(wx)+sqr(wy));
		wx /= wl,wy /= wl;
		mx = vx+wx,my = vy+wy,ml = sqrt(sqr(mx)+sqr(my));
		
		if(ml) {
			mx /= ml,my /= ml;
			double sn = sgn*(wx*my-wy*mx);  // cross product
			nx = cx+mx*offset/sn,ny = cy+my*offset/sn;
		}
		else {
			nx = cx-sgn*wy*offset,ny = cy+sgn*wx*offset;
		}
		
		lx = cx,ly = cy;
		out_bp[od] = nx,out_bp[od+1] = ny;
	}

	// set last point to first one
	out_bp[od] = out_bp[0],out_bp[od+1] = out_bp[1];
}

t_jit_err slitz_off_matrix_calc(t_slitz_off *x, void *inputs, void *outputs)
{
//	post("CALC");

	t_jit_err err=JIT_ERR_NONE;
	long in_savelock,out_savelock;
	t_jit_matrix_info in_minfo,out_minfo;
	float *in_bp,*out_bp;
	long i;
	void *in_matrix, *out_matrix;
	
	in_matrix = jit_object_method(inputs, _jit_sym_getindex, 0);
	out_matrix = jit_object_method(outputs, _jit_sym_getindex, 0);

	if(x && in_matrix && out_matrix) {
		
		in_savelock = (long) jit_object_method(in_matrix,_jit_sym_lock,1);
		out_savelock = (long) jit_object_method(out_matrix,_jit_sym_lock,1);
		
		jit_object_method(in_matrix,_jit_sym_getinfo,&in_minfo);
		
		jit_object_method(in_matrix,_jit_sym_getdata,&in_bp);		
		if (!in_bp) { err=JIT_ERR_GENERIC; goto out;}

		// compatible types?
		if (in_minfo.type != _jit_sym_float32 || in_minfo.dimcount != 1 || in_minfo.planecount != 2) { 
			err=JIT_ERR_MISMATCH_TYPE; 
			goto out;
		}		
		
		jit_object_method(out_matrix,_jit_sym_getinfo,&out_minfo);
		
		if(out_minfo.type != _jit_sym_float32 || out_minfo.dimcount != 1 || out_minfo.planecount != 2 ||  in_minfo.dim[0] != out_minfo.dim[0]) {
			// set out matrix format
		
			out_minfo.planecount = 2;
			out_minfo.type = _jit_sym_float32;
			out_minfo.dimcount = 1;
			out_minfo.dim[0] = in_minfo.dim[0];	

			jit_object_method(out_matrix,_jit_sym_setinfo,&out_minfo);
			jit_object_method(out_matrix,_jit_sym_getinfo,&out_minfo);
		}

		jit_object_method(out_matrix,_jit_sym_getdata,&out_bp);
		if (!out_bp) { err=JIT_ERR_GENERIC; goto out;}
		
		OffsetPoints(in_minfo,in_bp,out_minfo,out_bp,x->offset);
		
out:
		jit_object_method(in_matrix,_jit_sym_lock,in_savelock);
		jit_object_method(out_matrix,_jit_sym_lock,out_savelock);
	} 
	else {
		err = JIT_ERR_INVALID_PTR;
	}
	
	return err;
}


t_slitz_off *slitz_off_new(void)
{
	t_slitz_off *x;
	short i;
		
	if (x=(t_slitz_off *)jit_object_alloc(_slitz_off_class)) {
		x->offset = 0;
	} else {
		x = NULL;
	}	
	return x;
}

void slitz_off_free(t_slitz_off *x)
{
	//nada
}

