# Purr Data 2.20.1 Linux (20250606-rev.3ca3b637)

Pd is a real-time, graphical programming language for media processing created by Miller S. Puckette. It provides an environment for audio analysis, synthesis, and processing, with a rich set of multimedia capabilities. You can get Pd for Linux, Windows, Mac OSX, and BSD.

Purr Data was created by Jonathan Wilkes as a portable version of Ico Bukvic's Pd-l2ork, which in turn was based on Hans-Christoph Steiner's popular Pd-extended, a distribution of Pd which included a lot of externals. Purr Data is a modern successor of Pd-extended which features many enhancements, especially in the user interface which was rewritten from scratch using modern web technologies. It is available for Linux, Mac, and Windows.

- If you're new to Purr Data, you may first want to read our little tutorial introduction "[Meet the Cat](https://agraef.github.io/purr-data-intro)".

- More information about Purr Data can be found on the [GitHub mirror](https://agraef.github.io/purr-data/) maintained by Albert Gräf.

- Jonathan Wilkes' source code repository is available on [GitLab](https://git.purrdata.net/jwilkes/purr-data); this is where you should go for submitting bug reports and pull requests.

- Information about Ico Bukvic's Pd-l2ork version (which has been updated in 2021 and is now based on an earlier Purr Data version) can be found on the [Pd-l2ork website](https://l2ork.music.vt.edu/main/make-your-own-l2ork/software/).

- General information about Pd is available at <https://puredata.info>.

This is the Linux build of the Purr Data package.
Purr Data is available for a variety of different platforms, and you can also compile it from source if you have the necessary development tools. Please check the [wiki](https://github.com/agraef/purr-data/wiki/Installation) for detailed installation instructions.

## Installation

The [JGU Packages](https://build.opensuse.org/project/show/home:aggraef:purr-data-jgu) are a complete collection of Purr Data packages for Arch Linux, Fedora, and recent Debian, Raspbian and Ubuntu releases. They are maintained by Albert Gräf from the Johannes Gutenberg University (JGU) and hosted at the OBS (Open Build Service) by openSUSE. Installation instructions can be found in the [wiki](https://github.com/agraef/purr-data/wiki/Installation#linux).

## Usage

If you installed Purr Data from the JGU repositories, then the executable will be named `purr-data`, and your desktop menus should contain an entry for `Purr-Data`. Use the former to launch Purr Data from the shell, and the latter to run the program from your desktop environment as usual.

## Installing Externals, Objects, and Help files

If you would like to install other externals, objects, help files, etc., there are special folders that Purr Data uses, which are listed below. If the folder does not exist, you should create it. You can find out more details about this by reading this FAQ: [How do I install externals and help files?](https://puredata.info/docs/faq/how-do-i-install-externals-and-help-files)

- Only for the current user account: ~/pd-l2ork-externals
- For all user accounts on the computer: /usr/local/lib/pd-l2ork-externals

## Configuration

By default, most of the included libraries are loaded at startup. To change this, set your own preferences in the **Startup** tab of the Preferences dialog.

On Linux, configuration data (user preferences, help index, completions) lives in ~/.purr-data. You can remove this directory (`rm -rf ~/.purr-data`) to reset Purr Data to its defaults. This will also reset the help index and completion data (they will be re-created automatically).

## License

This package is released under the [GNU GPL](https://www.gnu.org/copyleft/gpl.html). The Pd core and some other included code is available under a [BSD license](https://github.com/pure-data/pure-data/blob/master/LICENSE.txt) from the Pd source code repository on [GitHub](https://github.com/pure-data/pure-data).

## Patented Algorithms

This package may contain software that is covered by patents in certain countries, like the U.S. and Germany. In order to use this software you must have the proper license. Known software packages that are covered by patents in some countries are [MP3](https://en.wikipedia.org/wiki/MP3) (a.k.a. MPEG-1 Layer 3), [MPEG-2](https://en.wikipedia.org/wiki/MPEG-2), [MPEG-4](https://en.wikipedia.org/wiki/MPEG-4). (Note that many of the MPEG-related patents have now expired in most countries; please check the linked Wikipedia articles for details.)

Please consider trying to get rid of software patents in your country:
<https://www.nosoftwarepatents.com>

This document was created Fri Jun  6 05:57:03 PM UTC 2025.
