"""registry of Max/MSP and Jitter

also provides some utility functions

- open the current documentation page for a symbol in a browser tab


"""

import webbrowser

descriptions = {
     0: 'A collection of messages to send remotely',
     1: 'A matrix-friendly MSP buffer~',
     2: 'A set of matrices for storage/resequencing',
     3: 'ADSR envelope generator for signals',
     4: 'AIFF saving and playing',
     5: 'ASCII number for each character in a string',
     6: 'ASCII number, convert to text character',
     7: 'ASCII numbers, convert symbol to',
     8: 'Absolute to relative path conversion',
     9: 'Absolute value',
     10: 'Accelerate Max timing in objects',
     11: 'Accelerate, control clock speed of Max timing objects',
     12: 'Access all pattr objects in a patcher',
     13: 'Access audio driver output channels',
     14: 'Accumulator',
     15: 'Active sensing, MIDI system message',
     16: 'Add',
     17: 'Additive synthesis',
     18: 'Address elements in an array by index number',
     19: 'Adjust image brightness/contrast/saturation',
     20: 'Afterpressure, polyphonic',
     21: 'Aftertouch (monophonic) MIDI message',
     22: 'Alert',
     23: 'Aliasing',
     24: 'All notes off (MIDI Mode message)',
     25: 'Allocate notes to different voices',
     26: 'Allpass filter',
     27: 'Amplitude',
     28: 'Analog-to-digital converter',
     29: 'Analysis of a signal',
     30: 'Analyze a signal',
     31: 'Analyzing video',
     32: 'And, true if both statements are true (logical intersection)',
     33: 'Animation of shapes or pictures',
     34: 'Animation, control a laser videodisc player',
     35: 'Animation, play a QuickTime movie',
     36: 'Antialiased oscillators',
     37: 'Append or prepend text to a message',
     38: 'Apply binary or unary operators',
     39: 'Apply common string operations',
     40: 'Apply single force to particles',
     41: 'Arbitrary rectangular resampling',
     42: 'Arc- functions for numbers, matrices and signals',
     43: 'Arithmetic operators',
     44: 'Array of arbitrary messages',
     45: 'Array of numbers',
     46: 'Ascii to integers',
     47: 'Ask',
     48: 'Assign one of several inputs to an outlet',
     49: 'Assistance, attach an assistance message to an inlet or outlet in a '
     'subpatch',
     50: 'Atoms of a list, break up into individual messages',
     51: 'Audio driver settings, reporting and controlling',
     52: 'Audio I/O',
     53: 'Audio processing system utilities',
     54: 'Average a running stream of numbers',
     55: 'Background colour',
     56: 'Background panel',
     57: 'Background, notify objects when patcher window is moved to background',
     58: 'Backward sample playback',
     59: 'Band-limited random signal',
     60: 'Bandpass filter',
     61: 'the bang message',
     62: 'Binary, display numbers as',
     63: 'Bit shifting',
     64: 'Bitwise ones complement operation',
     65: 'Bitwise operators',
     66: 'Boolean logic operations',
     67: 'Break up a list',
     68: 'Breakpoint line segment function generation and storage',
     69: 'Breath control',
     70: 'Broadcast a message to all instances of the same class in a patcher',
     71: 'Broadcast video using RTSP (Macintosh only)',
     72: 'Brownian motion simulator',
     73: 'Bubble sort',
     74: 'Buffer-based audio',
     75: 'Buffer-based FIR filter',
     76: 'Buffer viewer and editor',
     77: 'Build',
     78: 'Button for user Interface',
     79: 'Bypassing a signal',
     80: 'C language expression solving',
     81: 'Calculate',
     82: 'Capture and display a series of numbers',
     83: 'Cartesian to Polar coordinate conversion',
     84: 'Cascaded series of biquad filters',
     85: 'Cellwise envelope follower for matrices',
     86: 'Chance operations using pseudo-random numbers',
     87: 'Change background colour',
     88: 'Characters in a string of text, convert to ASCII numbers',
     89: 'Check box user interface object',
     90: 'Choke chromakey 3 sources',
     91: 'Chorusing',
     92: 'Clipping',
     93: 'Clock for reporting time elapsed',
     94: 'Clock speed of Max timing objects, control',
     95: 'Clock, MIDI system message',
     96: 'Close a patcher window automatically',
     97: 'Closing a patcher window, send a bang when window is closed',
     98: 'Coerce a matrix into different types/planecount',
     99: 'Collect',
     100: 'Collection of messages, store and recall',
     101: 'Color screen with threshold',
     102: 'Color selection using a modal dialog',
     103: 'Color swatch for RGB color selection and display',
     104: 'Colored button area',
     105: 'Comb filter with feedforward and feedback delay control',
     106: 'Comb filter',
     107: 'Combinatorics, produce random orderings of a set',
     108: 'Combine',
     109: 'Commands, place your own commands in the menu bar',
     110: 'Commenting a patch',
     111: 'Compare',
     112: 'Compress a signal',
     113: 'Compute',
     114: 'Computer keyboard events, detect',
     115: 'Concatenate',
     116: 'Concatenate two messages',
     117: 'Conditional statements',
     118: 'Conform file paths',
     119: 'Connect patch cords to an inlet or outlet of a subpatch',
     120: 'Connect',
     121: 'Constant signal of a number',
     122: 'Constrained random movement',
     123: 'Construct MIDI messages for transmission or recording',
     124: 'Construct a list out of individual items',
     125: 'Continue, MIDI system message',
     126: 'Continuous controllers',
     127: 'Control',
     128: 'Controller, picture-based',
     129: 'Convert',
     130: 'Convert colorspaces',
     131: 'Convert Max data types',
     132: 'Convolve two matrices',
     133: "Conway's game of life (cellular automata)",
     134: 'Copy the screen contents into a Jitter matrix',
     135: 'Cosine functions for numbers, matrices and signals',
     136: 'Count how many bang messages or numbers have been received',
     137: 'Count the occurrences of numbers',
     138: 'Count, send a series of numbers as fast as possible',
     139: 'Count',
     140: 'Create',
     141: 'Crossfade between 2 matrices',
     142: 'Crosshatch filter',
     143: 'Crossover filter',
     144: 'Cumulative total of a series of numbers',
     145: 'Cut up a matrix into evenly spaced sub matrices',
     146: 'Cycle a number from outlet to outlet',
     147: 'Cycle messages through outputs',
     148: 'DC offset',
     149: 'Data arriving at different times gets synched',
     150: 'Data smoothing',
     151: 'Data storage',
     152: 'Data structures, arbitrarily ordered array of arbitrary messages',
     153: 'Date and time of day',
     154: 'Decibels',
     155: 'Decrement or increment a value',
     156: 'Defer the execution of a message',
     157: 'Define',
     158: 'Delay',
     159: 'Delta time, report time interval between onsets of MIDI notes',
     160: 'Demultiplex (deinterleave) a single matrix into two',
     161: 'Deprioritize a message',
     162: 'Detect',
     163: 'Devices, drive external devices',
     164: 'Devices, get a list of MIDI devices and ports currently available',
     165: 'Dial user interface',
     166: 'Difference',
     167: 'Digital-to-analog converter',
     168: 'Digitize video from an external source',
     169: 'Disk-based audio playback',
     170: 'Disable signal processing in a subpatch',
     171: 'Disabling part of a signal network',
     172: 'Discrete values from a continuous stream of data',
     173: 'Displace points based on luminance',
     174: 'Display',
     175: 'Distort a sawtooth waveform',
     176: 'Distribute',
     177: 'Divide',
     178: 'Downsampling',
     179: 'Drag and drop',
     180: 'Draw',
     181: 'Duration',
     182: 'Duty cycle of a pulse wave',
     183: 'Edit an audio sample',
     184: 'Eliminate noise in a muted subpatcher',
     185: 'Eliminate number repetitions',
     186: 'Embed a visible subpatcher inside a box',
     187: 'Emboss image',
     188: 'Enable or disable MIDI objects in a patcher automatically',
     189: 'End of a message, add items to',
     190: 'Enter numerical data into a patcher from the computer keyboard',
     191: 'Enter text typed in by the user',
     192: 'Envelope',
     193: 'Equalization',
     194: 'Error messages',
     195: 'Evaluate',
     196: 'Event number, assign to each MIDI note',
     197: 'Event-driven, multi-segment line object',
     198: 'Exclusive or, bitwise XOR operation',
     199: 'Execute Javascript commands sequentially',
     200: 'Execute Javascript',
     201: 'Exponential curve function',
     202: 'Exponential scaling volume slider',
     203: 'Export MIDI file',
     204: 'Expose multiple objects to the pattr system',
     205: 'Expressions, solve mathematical',
     206: 'External clock source, synchronize Max to',
     207: 'Extra precision MIDI pitchbend messages',
     208: 'Extract indexed elements of a list',
     209: 'FIR filter, buffer-based',
     210: 'Fader for displaying or generating numerical data',
     211: 'Fake queue status',
     212: 'Fast Fourier transform',
     213: 'Fast chord detection',
     214: 'Fast fixed filter bank',
     215: 'Feedback a delayed signal',
     216: 'Feedback',
     217: 'File menu, add your own items to',
     218: 'File',
     219: 'Fill a matrix with a list',
     220: 'Film or video, synchronize Max to',
     221: 'Filter (audio)',
     222: 'Filter MIDI',
     223: 'Filter a continuous stream of messages',
     224: 'Filter a signal logarithmically',
     225: 'Filter',
     226: 'Find',
     227: 'FireWire VTR control',
     228: 'Fix file paths and conform',
     229: 'Flanging',
     230: 'Flash on a message',
     231: 'Floating-point data visualization',
     232: 'Floating-point numbers, store numbers with a fractional part',
     233: 'Folder content listings',
     234: 'Follow a performance, comparing it to a pre-recorded sequence',
     235: 'Foreground, move a patcher window automatically to the front',
     236: 'Foreground, notify objects when patcher window is brought to foreground',
     237: 'Format',
     238: 'Forward messages to receive objects',
     239: 'Fourier analysis and synthesis',
     240: 'Fourteen-bit precision MIDI pitchbend messages',
     241: 'FreeFrame Effects for Jitter matrices',
     242: 'Frequency domain',
     243: 'Frequency modulation',
     244: 'Frequency shifter',
     245: 'Frequency-to-pitch conversion',
     246: 'Frequency, keep track of how many times a number has occurred',
     247: 'Full pathname to filename conversion',
     248: 'Function generator',
     249: 'Gating and switching',
     250: 'Gather together a collection of numbers',
     251: 'Generate a bang message',
     252: 'Generate graphics',
     253: 'Generate numbers',
     254: 'Generate MIDI',
     255: 'Generate numbers with the mouse',
     256: 'Generate',
     257: 'Get',
     258: 'Global message-sending',
     259: 'Global signal values',
     260: 'Global variables',
     261: 'Glue many matrices into one',
     262: 'Graph filter poles and zeros on the Z-plane',
     263: 'Graphic display of an array of numbers, editable with the mouse',
     264: 'Graphical',
     265: 'Graphics',
     266: 'Greater than',
     267: 'Greater than, report when all numbers in a list surpass specific '
          'thresholds',
     268: 'Held MIDI notes, provide note-off messages for',
     269: 'Hertz equivalent of a MIDI key number',
     270: 'Hexadecimal display of integer values',
     271: 'Hierarchical on/off switch',
     272: 'Hint, pop-up menu',
     273: 'Histogram of how many times a number has occurred',
     274: 'Hold (store)',
     275: 'Host',
     276: 'Host-synchronized sawtooth wave',
     277: 'Human interface (gaming) device input',
     278: 'Hyperbolic functions for numbers, matrices and signals',
     279: 'IIR filter',
     280: 'Idiosyncratic downsampling/upsampling',
     281: 'If-then-else control structure',
     282: 'Ignore certain messages',
     283: 'Image keying based on distance from a luminance value',
     284: 'Import MIDI file',
     285: 'Impulse generator',
     286: 'In-Patcher Window',
     287: 'Incoming MIDI messages, parse',
     288: 'Increment a value',
     289: 'Index elements of a list and output them individually',
     290: 'Index number, prepend to a number or a list',
     291: 'Indexed list of numerical values',
     292: 'Indicate the zero/non-zero status of a number',
     293: 'Indicator flashes when a message is received',
     294: 'Information about current operating system and hardware',
     295: 'Initialize values automatically when a patch is loaded',
     296: 'Inlet',
     297: 'Input received from MIDI devices, raw',
     298: 'Input received in audio input jack',
     299: 'Input to a delay line',
     300: 'Input to output matrix mapping (256-point char data)',
     301: 'Integer number, store',
     302: 'Integers',
     303: 'Inter-onset interval, measure the time elapsed between two events',
     304: 'Intercept and redirect the output of an object',
     305: 'Interpolate between two numerical values',
     306: 'Interpolating oscillator bank',
     307: 'Interpret',
     308: 'Introduce spatial noise',
     309: 'Inverse fast Fourier transform',
     310: 'Invert the color of a rectangular area of a patcher window over a '
          'picture or a comment',
     311: 'Invert a signal',
     312: 'Invisible button',
     313: 'Invisible patcher',
     314: 'Is equal to, less than, greater than, comparison of numbers, matrices, '
          'or signals',
     315: 'Items of a list, break up into individual messages',
     316: 'Iterate a matrix as a series of Max lists/values',
     317: 'Java',
     318: 'Javascript',
     319: 'Join',
     320: 'Keyboard style slider for displaying and generating numbers',
     321: 'Keyboard, detect computer keyboard events',
     322: 'Keydown event on computer keyboard, detect',
     323: 'Keying based on chromatic distance',
     324: 'Keyup event on computer keyboard, detect',
     325: 'Knob, picture-based',
     326: 'Label objects in a patcher window',
     327: 'Laser disc player, control via the serial port',
     328: 'Last (few) of a series of numbers are retained and sent out separate '
          'outlets',
     329: 'Launch html object reference',
     330: 'Less than/greater than comparisons, redirect numbers based on',
     331: 'Less than - find the lesser of two numbers',
     332: 'Level (audio)',
     333: 'Limit',
     334: 'Limiter',
     335: 'Lindenmayer string expansion (L-systems)',
     336: 'Linear algebra for matrices',
     337: 'Linear ramp generator',
     338: 'Linked list function editor',
     339: 'List processing',
     340: 'List',
     341: 'Lists, array of',
     342: 'Load a patcher automatically',
     343: 'Local variable',
     344: 'Logarithm',
     345: 'Logical expressions',
     346: 'Logical operations using signal values',
     347: 'Look',
     348: 'Lookup table',
     349: 'Loop points in a sound file',
     350: 'Looping a sample',
     351: 'Loops, count repeated events',
     352: 'Loops, repeated series of actions',
     353: 'Lowpass filter',
     354: 'Make',
     355: 'Map-based crossfader',
     356: 'Map',
     357: 'Mark data with number identifying its inlet',
     358: 'Markov chain',
     359: 'Masking, bitwise "and" (intersection) and bitwise "or" (union) '
          'operations',
     360: 'Match',
     361: 'Mathematical expression solving',
     362: 'Matrix utilities',
     363: 'Matrix-style switch control',
     364: 'Matrixctrl-compatible Max message router',
     365: 'Max messages',
     366: 'Max search path information',
     367: 'Maximum and minimum limit for a range of numerical values, specify and '
          'display',
     368: 'Maximum',
     369: 'Measure',
     370: 'Menu bar, customize or alter menus or menu items',
     371: 'Menu, pop-up menu in a patcher',
     372: 'Message',
     373: 'Message symbol substitution',
     374: 'Messages',
     375: 'Meta-imaging',
     376: 'Metronome of timed events',
     377: 'MIDI',
     378: 'Millisecond calculations',
     379: 'Minimum and maximum limit for a range of numerical values, specify and '
          'display',
     380: 'Minimum, find the lesser of two numbers',
     381: 'Minimum, find the minimum value of a group of numbers',
     382: 'Minus, subtract one number from another',
     383: 'Mixing signals',
     384: 'Mixing video',
     385: 'Modem communication, transmit and receive non-MIDI data',
     386: 'Modification date of a file',
     387: 'Modify a signal',
     388: 'Modulation wheel',
     389: 'Modulus operation',
     390: 'Monitor size',
     391: 'Monophonic aftertouch MIDI message',
     392: 'Mouse',
     393: 'Movie, play QuickTime',
     394: 'Multi-media programming',
     395: 'Multi-mode signal average',
     396: 'Multi-purpose list processor',
     397: 'Multi-segment line object, event-driven',
     398: 'Multi-track sequencer of MIDI messages or numbers',
     399: 'Multiplex(interleave) two matrices into one matrix',
     400: 'Multiply',
     401: 'Name user interface objects in a patcher window',
     402: 'Negative number, convert to positive number',
     403: 'Neon glow',
     404: 'Nibble, examine selected bits of a number’s binary representation',
     405: 'Noise gate',
     406: 'Noise',
     407: 'Non-interpolating oscillator bank',
     408: 'Non-zero numbers',
     409: 'Normalize',
     410: 'Not equal to',
     411: 'Not',
     412: 'Note data',
     413: 'Notes in a patch',
     414: 'Note-off messages',
     415: 'Notify Max of a file change',
     416: 'Notify objects when patcher window is moved to foreground or background',
     417: 'Notify user when an event has occurred',
     418: 'Numbers',
     419: 'OMNI Mode On/Off (MIDI Mode message)',
     420: 'Object within an object',
     421: 'Occurrences',
     422: 'Octal, display numbers in Roland octal format',
     423: 'OctiMax dynamics processors',
     424: 'On/Off switch',
     425: 'Only pass different frames',
     426: 'OpenGL',
     427: 'Open',
     428: 'Operating system and hardware information',
     429: 'Optimized blur/sharpen',
     430: 'Or, bitwise exclusive or (XOR) operation',
     431: 'Or, true if one statement or the other is true (logical union)',
     432: 'Order',
     433: 'Oscillators (audio)',
     434: 'Oscilloscope',
     435: 'Outlet',
     436: 'Outlet, send items of an incoming list out individual outlets',
     437: 'Output MIDI data byte by byte',
     438: 'Output a combined list when any element changes',
     439: 'Output audio jack',
     440: 'Output messages',
     441: 'Output numbers',
     442: 'Output the monitor size',
     443: 'Output video',
     444: 'Pack numbers and symbols into a list',
     445: 'Panel',
     446: 'Panic, turn off held MIDI notes',
     447: 'Panning',
     448: 'Parameter change to a MIDI device',
     449: 'Parse MIDI messages',
     450: 'Pass',
     451: 'Patch change MIDI message',
     452: 'Patch cords, connect to an inlet or outlet of a subpatch',
     453: 'Patcher-specific data wrapper',
     454: 'Patcher within a patcher, the contents of which are visible',
     455: 'Peak Limiter',
     456: 'Peak amplitude',
     457: 'Peak hold, keep track of the greatest in a series of numbers',
     458: 'Peek at values in other objects',
     459: 'Perform a GL accelerated grid-based evaluation',
     460: 'Permute a set in random order',
     461: 'Phase distortion synthesis',
     462: 'Phase quadrature filter',
     463: 'Phase shifter',
     464: 'Pick a colour using a dialog box',
     465: 'Picture-based uiser interface object',
     466: 'Pink noise generator',
     467: 'Pitch bend',
     468: 'Pitch shifter for pfft~',
     469: 'Pitch-to-frequency conversion',
     470: 'Pitchbend, report incoming MIDI pitchbend data',
     471: 'Pitchbend, transmit MIDI pitchbend messages',
     472: 'Play a QuickTime movie',
     473: 'Play audio',
     474: 'Play audio file from disk',
     475: 'Play or edit a QuickTime movie',
     476: 'Play sequences of past messages or numbers',
     477: 'Play samples',
     478: 'Plug-in in VST format used in MSP',
     479: 'Point to elements in array by index',
     480: 'Polar to Cartesian coordinate conversion',
     481: 'Poly mode, assign a unique voice number to each note being played',
     482: 'Polyphonic afterpressure',
     483: 'Polyphony management',
     484: 'Pop-up menu in a patcher',
     485: 'Pop-up style hint text',
     486: 'Portamento',
     487: 'Ports, get a list of MIDI devices and ports currently available',
     488: 'Position-based sample playback',
     489: 'Positive version of a negative number',
     490: 'Postpone',
     491: 'Potentiometer-like dial for sending numbers',
     492: 'Power, one number to the power of another',
     493: 'Precise "real-world" time measurements',
     494: 'Prepare',
     495: 'Prepend or append text to a message',
     496: 'Preset, store and recall values for all user interface objects',
     497: 'Prevent multiples of patcher from being opened',
     498: 'Print a matrix as text in the Max window',
     499: 'Print any message in the Max window',
     500: 'Probabilistic (stochastic) decision making',
     501: 'Probability lines',
     502: 'Probability, keep track of how many times a number has occurred',
     503: 'Product of multiplying two numbers',
     504: 'Program change MIDI message',
     505: 'Progress bar, graphic display',
     506: 'Pulse train generator',
     507: 'Pulse wave',
     508: 'Put a visible subpatcher inside a box',
     509: 'Queue-based',
     510: 'QuickDraw graphic commands, draw with',
     511: 'QuickDraw',
     512: 'QuickTime video',
     513: 'QuickTime movie, play',
     514: 'RGB color selection and display swatch',
     515: 'Radio button user interface object',
     516: 'Ramp function, generate',
     517: 'Ramp signal',
     518: 'Random walk',
     519: 'Randomly',
     520: 'Range of numerical values, specify and display minimum and maximum '
          'limits',
     521: 'Rate at which messages are sent, limit',
     522: 'Rate, combine numbers into a single list if received faster than a '
          'certain speed',
     523: 'Rate, control clock speed of Max timing objects',
     524: 'Rate, send out beat numbers at a metronomic tempo',
     525: 'Raw MIDI data, receive and transmit',
     526: 'Raw data from a file, read byte by byte',
     527: 'ReWire device hosting',
     528: 'Read a binary file',
     529: 'Read and draw Wavefront .obj models',
     530: 'Read and write a matrix as an ASCII text file',
     531: 'Read and write a single matrix as a formatted text file',
     532: 'Read and write',
     533: 'Read in a file of binary data',
     534: 'Read matrix data as an audio signal',
     535: 'Read or write an OpenEXR image.',
     536: 'Real-world time measurement',
     537: 'Recall sequences of past messages or numbers',
     538: 'Receive MIDI',
     539: 'Receive any message from any window',
     540: 'Receive matrices from a jit.net.send object via TCP/IP',
     541: 'Receive messages',
     542: 'Receive only specific MIDI messages',
     543: 'Recently received values are stored and recalled',
     544: 'Record',
     545: 'Recording audio samples',
     546: 'Redirect messages to a specific destination',
     547: 'Reference a sub-region of a matrix',
     548: 'Release velocity, detecting and formatting note-off messages with',
     549: 'Remainder',
     550: 'Remap and/or invert matrix dimensions',
     551: 'Remote connection of objects, without patch cords',
     552: 'Remove redundant dimensions of size 1',
     553: 'Render OpenGL',
     554: 'Reorder grid of rectangles',
     555: 'Repeatedly send bang messages as fast as possible',
     556: 'Repeatedly send output at a certain rate',
     557: 'Repetition at sub-audio rates',
     558: 'Repetitions, count',
     559: 'Repetitions, suppress repeated numbers',
     560: 'Replace NaN and infinite signal values with 0',
     561: 'Report',
     562: 'Reposition spatially',
     563: 'Reproduce a single bang to different places in immediate succession',
     564: 'Resample by scanline wrapping',
     565: 'Resample spatially',
     566: 'Resonant filter',
     567: 'Restrict numbers to a certain range',
     568: 'Reverberation',
     569: 'Reverse output with respect to input',
     570: 'Reverse the order of two number messages',
     571: 'ReWire',
     572: 'Reverse',
     573: 'Reversed sample playback',
     574: 'Ring modulation',
     575: 'Ritardando, control clock speed of Max timing objects',
     576: "Robert's Cross edge detection",
     577: 'Rotate elements of a set of numbers, out successive outlets',
     578: 'Rotate hue',
     579: 'Rotate',
     580: 'Rotate a Video image',
     581: 'Round an input signal value',
     582: 'Route',
     583: 'Route a signal',
     584: 'Run a Javascript',
     585: 'SMPTE time code, synchronize to an external source via MIDI Manager',
     586: 'Sample and hold',
     587: 'Sample index in a buffer',
     588: 'Sample playback without interpolation',
     589: 'Sample playback',
     590: 'Sampler, receive and transmit sound data via MIDI Sample Dump',
     591: 'Sampling and audio buffers',
     592: 'Sampling rate',
     593: 'Save, move to the foreground, or close a patcher window automatically',
     594: 'Save',
     595: 'Sawtooth oscillator',
     596: 'Sawtooth wave generator',
     597: 'Scale on the basis of maximum amplitude',
     598: 'Scale/rotate an inage in 2D',
     599: 'Scale',
     600: 'Schedule a number or list to be sent at a future time',
     601: 'Schedule an event for a future time',
     602: 'Score-following',
     603: 'Screen size',
     604: 'Scroll through a list of messages',
     605: 'Search path information',
     606: 'See the maximum amplitude of a signal',
     607: 'Select',
     608: 'Selectively pass an input to an outlet',
     609: 'Send a bang',
     610: 'Send matrices to a jit.net.recv object via TCP/IP',
     611: 'Send message(s)',
     612: 'Send MIDI',
     613: 'Send numbers',
     614: 'Send',
     615: 'Separate a list into its constituent elements',
     616: 'Sequence of numbers, detect a specific ordered set of numbers',
     617: 'Sequence of numbers, generate automatically',
     618: 'Sequencer',
     619: 'Serial port, transmit and receive non-MIDI data',
     620: 'Series of numbers, break a list up into individual messages',
     621: 'Series of numbers, combine into a single list',
     622: 'Set (of fixed order and size) of integers; output all whenever one is '
          'modified',
     623: 'Set background color',
     624: 'Set values automatically when a patch is loaded',
     625: 'Set/query monitor attributes',
     626: 'Set, produce a random ordering of a set',
     627: 'Set, store an unordered set of numbers',
     628: 'Set',
     629: 'Share variables',
     630: 'Shift bits to left or right',
     631: 'Shift sequential input from one outlet to another',
     632: 'Show',
     633: 'Signal analysis',
     634: 'Signal averaging',
     635: 'Signal capture and granular oscillator',
     636: 'Signal folding, variable range',
     637: 'Signal monitor and constant generator',
     638: 'Signal spectrogram or sonogram',
     639: 'Signal-driven sequencers',
     640: 'Signal-rate filter coefficient generator',
     641: 'Signal routing',
     642: 'Simultaneity, send a series of bang messages or numbers in a single '
          'tick of Max’s clock',
     643: 'Sine functions',
     644: 'Sine functions for numbers, matrices and signals',
     645: 'Single-pole lowpass filter',
     646: 'Slider to display or generate numerical data',
     647: 'Smooth an incoming signal',
     648: 'Snapshot, store and recall instantaneous values of all user interface '
          'objects',
     649: 'Sobel and Prewitt gradient edge detector',
     650: 'Soft-clipping signal distortion',
     651: 'Solve',
     652: 'Sonogram',
     653: 'Sound sample data, receive and transmit via MIDI Sample Dump',
     654: 'Sound, play in a QuickTime movie',
     655: 'Sparse array of numbers',
     656: 'Spatial transform using 3x3 matrix',
     657: 'Spearate numbers into ranges',
     658: 'Spectral domain processing',
     659: 'Spectral processing manager for patchers',
     660: 'Spectrogram',
     661: 'Spectrum measurement',
     662: 'Speed, combine numbers into a single list if received faster than a '
          'certain rate',
     663: 'Speed, limit the rate at which messages are sent',
     664: 'Split a matrix into two matrices',
     665: 'Split a stream of data between individual outlets',
     666: 'Sprites, pictures and geometric shapes',
     667: 'Square root',
     668: 'Start a process by sending the bang message',
     669: 'Start activity automatically when a patch is loaded',
     670: 'Start and end point of a sample',
     671: 'Start, MIDI system message',
     672: 'State-variable filter with simultaneous outputs',
     673: 'Steal voices, turn off old notes if too many new ones arrive',
     674: 'Stochastic (probabilistic) decision making',
     675: 'Stop or alter the flow of messages',
     676: 'Stop, MIDI system message',
     677: 'Store',
     678: 'String of text combining numbers, ASCII bytes, and symbols into a '
          'single message',
     679: 'String/matrix utilities',
     680: 'Stuck MIDI notes, avoid or turn off',
     681: 'Subpatch control',
     682: 'Subpatch in a box, visible from the patcher that contains it',
     683: 'Subpatch object (subroutine)',
     684: 'Subpatch object, create an inlet or outlet in',
     685: 'Substitute a symbol for another symbol in a message',
     686: 'Substitute',
     687: 'Subtract',
     688: 'Subtractive synthesis',
     689: 'Sum of a set of numbers',
     690: 'Suppress note-off messages',
     691: 'Suppress the flow of certain messages',
     692: 'Sustain notes by holding note-off messages until a specific event '
          'occurs',
     693: 'Sustain pedal',
     694: 'Swap',
     695: 'Switch a process on and off',
     696: 'Switch between zero and one',
     697: 'Switch control matrix',
     698: 'Switch the flow of messages on or off',
     699: 'Switching signal flow on and off',
     700: 'Symbol to message conversion',
     701: 'Synchronize MSP with an external source',
     702: 'Synchronize Max to an external clock source',
     703: 'Synchronize asynchronously arriving inputs, send them out together',
     704: 'Synchronize',
     705: 'System Reset, MIDI system message',
     706: 'System exclusive messages, construct and transmit',
     707: 'System exclusive messages, receive',
     708: 'Table lookup',
     709: 'Tag data with number identifying its inlet',
     710: 'Tag messages with a unique index number',
     711: 'Tangent functions for numbers, matrices and signals',
     712: 'Tempo, control clock speed of Max timing objects',
     713: 'Tempo, send out beat numbers at a metronomic tempo',
     714: 'Test the equality of two numbers',
     715: 'Test the zero/non-zero status of a number or expression',
     716: 'Test whether one number is greater than another',
     717: 'Test whether one number is less than another',
     718: 'Text file of signal samples',
     719: 'Text file, load, play, and save a MIDI file as plain text',
     720: 'Text file, open and save',
     721: 'Text input by the user, obtain',
     722: 'Text, convert to ASCII numbers',
     723: 'Text, display automatically in a patcher',
     724: 'Text, display in a patcher',
     725: 'Text, format numbers, ASCII bytes, and symbols into a single message',
     726: 'Text, print any message in the Max window',
     727: 'The Jitter Matrix!',
     728: 'Third-order crossover filter',
     729: 'Threshold, report when numbers surpass',
     730: 'Timbre change on a MIDI synthesizer',
     731: 'Time code, receive from an external source',
     732: 'Time elapsed between events, check',
     733: 'Time measurement in cpu cycles',
     734: 'Time of day and date',
     735: 'Time-domain frequency shifter',
     736: 'Time-domain frequency shifter',
     737: 'Time-scale the output of a phasor~',
     738: 'Times, multiply two numbers',
     739: 'Toggle a process on and off',
     740: 'Toggle',
     741: 'Track, record and play back a multi-track sequence of messages or '
          'numbers',
     742: 'Traffic control for bang messages',
     743: 'Transfer function lookup tables',
     744: 'Transform symbol(s) into messages and numbers',
     745: 'Transforms matrix data into signals',
     746: 'Transforms signal data into matrices',
     747: 'Transient detector',
     748: 'Transition probabilities, Markov chain',
     749: 'Transmit MIDI',
     750: 'Transmit a specific MIDI message type',
     751: 'Transmit signals without patch cords',
     752: 'Trap',
     753: 'Trapezoidal wavetable',
     754: 'Triangle/ramp wavetable',
     755: 'Trigger',
     756: 'Trigonometric functions',
     757: 'Trigonometric operators',
     758: 'True matrix multiplication',
     759: 'True/false testing',
     760: 'Truncate the fractional part of a signal',
     761: 'Turn',
     762: 'turtle graphics interpreter in 2d',
     763: 'Two-dimensional storage and viewing',
     764: 'Two-dimensional wavetable',
     765: 'Two-pole, two-zero filter',
     766: 'Type numerical data into a patcher',
     767: 'Type text into a locked patcher',
     768: 'Unroll a matrix into a list',
     769: 'Use PERL-compatible regular expressions on Jitter matrices',
     770: 'Use mouse movement to control position/rotation',
     771: 'Use the alpha channel of one image to blend two images together',
     772: 'Use PERL-style regular expressions to process input',
     773: 'User input, ask for',
     774: 'User input',
     775: 'User interface: dial',
     776: 'Uses a 1-dimensional matrix to offset scanlines',
     777: 'Uses matrices to draw multiple instances of a jit.gl object efficiently',
     778: 'Variable',
     779: 'Variable range signal folding',
     780: 'Variable size wavetable',
     781: 'Variable-rate looping sample playback',
     782: 'Varispeed sample playback',
     783: 'Vector math, evaluate an expression multiple times using lists of '
          'numbers as input',
     784: 'Vector size',
     785: 'Vector-based envelope follower',
     786: 'Velocity (MIDI) control of a signal',
     787: 'Velocity of incoming MIDI note-on messages, obtain',
     788: 'Velocity, detecting and formatting note-off messages with release '
          'velocity',
     789: 'Video or film, synchronize Max to',
     790: 'Video display',
     791: 'Videodisc player, control via the serial port',
     792: 'Video image filters',
     793: 'Video mixing and compositing',
     794: 'View a signal',
     795: 'Virtual connection of objects, without patch cords',
     796: 'Visual RMS level indicator',
     797: 'Visual peak level indicator',
     798: 'Voice number, assign a unique number to each note being played',
     799: 'Voice stealing, turn off old notes if too many new ones arrive',
     800: 'Volume control MIDI message',
     801: 'Volume control of a QuickTime movie',
     802: 'Wait before allowing a number to pass',
     803: 'Wait before doing something',
     804: 'Wait for input in both inlets, then send out both numbers',
     805: 'Watch for file change and report',
     806: 'Waveshaping',
     807: 'Wavetable synthesis',
     808: 'Wavetables',
     809: 'Webcam input',
     810: 'Weighted probabilities',
     811: 'White noise generator',
     812: 'Window being closed sends a bang',
     813: 'Window moving to foreground or background sends 1 or 0',
     814: 'Window on a subpatch seen within the patcher that contains that '
          'subpatch',
     815: 'Window, enable or disable MIDI automatically',
     816: 'Window, open and close automatically',
     817: 'Windowing a portion of a signal',
     818: 'Windows, communicate between',
     819: 'Wrap a signal between -π and π',
     820: 'Write a comment in the patch',
     821: 'Write an audio signal into a matrix',
     822: 'Write bitmap text',
     823: 'Write sample values by index',
     824: 'Write vector text',
     825: 'XOR, bitwise "exclusive or" operation',
     826: 'X-Y plotting of a two-plane matrix',
     827: 'Zero and non-zero numbers, notify when input changes from one to the '
          'other',
     828: 'Zero-cross counter',
     829: 'Zero, test if a number or expression is equal to',
     830: 'Zooming/cropping a Video image'
}
 


objects = {
    "|": 418,
    "||": 829,
    "!-": 687,
    "!-~": 687,
    "!/": 177,
    "!/~": 177,
    "!=": 829,
    "!=~": 66,
    "%": 651,
    "%~": 549,
    "&": 418,
    "&&": 829,
    "*": 738,
    "*~": 574,
    "+": 689,
    "+=~": 14,
    "+~": 243,
    "-": 687,
    "-~": 687,
    "/": 651,
    "/~": 409,
    "2d.wave~": 807,
    "<": 759,
    "<<": 630,
    "<=": 759,
    "<=~": 66,
    "<~": 507,
    "==": 829,
    "==~": 346,
    ">": 759,
    ">=": 759,
    ">=~": 66,
    ">>": 630,
    ">~": 507,
    "abs": 489,
    "absolutepath": 129,
    "abs~": 9,
    "accum": 738,
    "acos": 757,
    "acosh": 757,
    "acosh~": 757,
    "acos~": 757,
    "active": 813,
    "adc~": 784,
    "adoutput~": 52,
    "adsr~": 786,
    "adstatus": 561,
    "allpass~": 688,
    "anal": 354,
    "append": 495,
    "asin": 757,
    "asinh": 757,
    "asinh~": 757,
    "asin~": 757,
    "atan": 757,
    "atan2": 757,
    "atan2~": 757,
    "atanh": 757,
    "atanh~": 757,
    "atan~": 757,
    "atodb": 154,
    "atodb~": 129,
    "atoi": 302,
    "autopattr": 204,
    "average~": 395,
    "avg~": 634,
    "bag": 677,
    "bangbang": 609,
    "begin~": 641,
    "bendin": 542,
    "bendout": 750,
    "bgcolor": 628,
    "biquad~": 765,
    "bitand": 65,
    "bitand~": 65,
    "bitnot~": 65,
    "bitor": 65,
    "bitor~": 65,
    "bitsafe~": 560,
    "bitshift~": 63,
    "bitxor~": 65,
    "bline": 397,
    "bondo": 704,
    "borax": 798,
    "bpatcher": 814,
    "bucket": 677,
    "buddy": 804,
    "buffer~": 807,
    "buffir~": 221,
    "button": 755,
    "capture": 677,
    "capture~": 794,
    "cartopol": 129,
    "cartopol~": 658,
    "cascade~": 221,
    "change": 829,
    "change~": 633,
    "click~": 285,
    "clip": 567,
    "clip~": 507,
    "clocker": 732,
    "closebang": 812,
    "coll": 677,
    "colorpicker": 607,
    "comb~": 688,
    "comment": 820,
    "conformpath": 228,
    "cos": 757,
    "cosh": 757,
    "cosh~": 757,
    "cosx~": 757,
    "cos~": 757,
    "counter": 617,
    "count~": 633,
    "cpuclock": 733,
    "cross~": 728,
    "ctlin": 800,
    "ctlout": 800,
    "curve~": 786,
    "cycle": 665,
    "cycle~": 817,
    "dac~": 784,
    "date": 734,
    "dbtoa": 154,
    "dbtoa~": 129,
    "decide": 519,
    "decode": 424,
    "defer": 161,
    "deferlow": 158,
    "degrade~": 387,
    "delay": 803,
    "delay~": 158,
    "deltaclip~": 387,
    "delta~": 387,
    "detonate": 264,
    "dial": 775,
    "dialog": 773,
    "downsamp~": 387,
    "dropfile": 179,
    "drunk": 810,
    "dspstate~": 784,
    "dsptime~": 561,
    "edge~": 755,
    "error": 761,
    "expr": 825,
    "ezadc~": 545,
    "ezdac~": 473,
    "fbinshift~": 244,
    "fffb~": 221,
    "fftinfo~": 658,
    "fftin~": 658,
    "fftout~": 658,
    "fft~": 661,
    "filedate": 561,
    "filein": 533,
    "filepath": 605,
    "filewatch": 805,
    "filtercoeff~": 640,
    "filtergraph~": 264,
    "float": 818,
    "flush": 761,
    "folder": 427,
    "follow": 755,
    "fontlist": 340,
    "forward": 818,
    "fpic": 724,
    "frameaccum~": 658,
    "framedelta~": 658,
    "freqshift~": 736,
    "fromsymbol": 744,
    "fswap": 694,
    "ftom": 377,
    "ftom~": 129,
    "funbuff": 677,
    "function": 708,
    "funnel": 710,
    "gain~": 786,
    "gate": 698,
    "gate~": 817,
    "gestalt": 428,
    "ggate": 740,
    "gizmo~": 468,
    "grab": 818,
    "groove~": 782,
    "gswitch": 740,
    "hi": 774,
    "hilbert~": 462,
    "hint": 485,
    "histo": 502,
    "hostcontrol~": 127,
    "hostphasor~": 571,
    "hostsync~": 571,
    "if": 829,
    "ifft~": 661,
    "imovie": 752,
    "in": 483,
    "incdec": 288,
    "index~": 817,
    "info~": 591,
    "inlet": 818,
    "int": 818,
    "in~": 483,
    "ioscbank~": 433,
    "iter": 620,
    "itoa": 129,
    "jit.3m": 561,
    "jit.alphablend": 793,
    "jit.altern": 101,
    "jit.ameba": 792,
    "jit.argb2ayuv": 130,
    "jit.argb2grgb": 130,
    "jit.argb2uyvy": 130,
    "jit.avc": 227,
    "jit.avg4": 792,
    "jit.ayuv2argb": 130,
    "jit.ayuv2luma": 130,
    "jit.ayuv2uyvy": 130,
    "jit.bfg": 195,
    "jit.brass": 792,
    "jit.brcosa": 793,
    "jit.bsort": 792,
    "jit.buffer~": 131,
    "jit.catch~": 746,
    "jit.cellblock": 763,
    "jit.change": 425,
    "jit.charmap": 792,
    "jit.chromakey": 323,
    "jit.clip": 792,
    "jit.coerce": 362,
    "jit.colorspace": 129,
    "jit.concat": 115,
    "jit.convolve": 792,
    "jit.conway": 792,
    "jit.cycle": 147,
    "jit.demultiplex": 792,
    "jit.desktop": 134,
    "jit.dimmap": 550,
    "jit.displays": 625,
    "jit.dx.grab": 809,
    "jit.dx.videoout": 443,
    "jit.eclipse": 792,
    "jit.expr": 687,
    "jit.fastblur": 792,
    "jit.fft": 212,
    "jit.fill": 679,
    "jit.findbounds": 81,
    "jit.fluoride": 792,
    "jit.fprint": 531,
    "jit.fpsgui": 790,
    "jit.freeframe": 241,
    "jit.gencoord": 195,
    "jit.gl.graph": 426,
    "jit.gl.gridshape": 426,
    "jit.gl.handle": 770,
    "jit.gl.imageunit": 553,
    "jit.gl.isosurf": 252,
    "jit.gl.mesh": 252,
    "jit.gl.model": 529,
    "jit.gl.multiple": 777,
    "jit.gl.nurbs": 426,
    "jit.gl.plato": 426,
    "jit.gl.render": 553,
    "jit.gl.sketch": 426,
    "jit.gl.slab": 459,
    "jit.gl.text2d": 822,
    "jit.gl.text3d": 824,
    "jit.gl.videoplane": 830,
    "jit.gl.volume": 140,
    "jit.glop": 792,
    "jit.glue": 261,
    "jit.gradient": 252,
    "jit.graph": 231,
    "jit.grgb2argb": 130,
    "jit.hatch": 792,
    "jit.histogram": 81,
    "jit.hsl2rgb": 130,
    "jit.hue": 793,
    "jit.iter": 316,
    "jit.keyscreen": 792,
    "jit.la.determinant": 336,
    "jit.la.diagproduct": 336,
    "jit.la.inverse": 336,
    "jit.la.mult": 758,
    "jit.la.trace": 336,
    "jit.la.uppertri": 336,
    "jit.lcd": 793,
    "jit.linden": 679,
    "jit.luma2ayuv": 130,
    "jit.luma2uyvy": 130,
    "jit.lumakey": 792,
    "jit.map": 356,
    "jit.matrix": 830,
    "jit.matrixinfo": 561,
    "jit.matrixset": 677,
    "jit.multiplex": 792,
    "jit.mxform2d": 793,
    "jit.net.recv": 540,
    "jit.net.send": 610,
    "jit.noise": 811,
    "jit.normalize": 409,
    "jit.obref": 329,
    "jit.op": 793,
    "jit.openexr": 535,
    "jit.p.bounds": 333,
    "jit.p.shiva": 252,
    "jit.p.vishnu": 252,
    "jit.pack": 354,
    "jit.peek~": 534,
    "jit.plot": 826,
    "jit.plume": 792,
    "jit.plur": 792,
    "jit.poke~": 821,
    "jit.print": 498,
    "jit.pwindow": 790,
    "jit.qball": 129,
    "jit.qfaker": 211,
    "jit.qt.broadcast": 71,
    "jit.qt.effect": 512,
    "jit.qt.grab": 809,
    "jit.qt.movie": 512,
    "jit.qt.record": 544,
    "jit.qt.videoout": 512,
    "jit.release~": 745,
    "jit.repos": 792,
    "jit.resamp": 792,
    "jit.reverse": 569,
    "jit.rgb2luma": 130,
    "jit.robcross": 792,
    "jit.rota": 830,
    "jit.roy": 792,
    "jit.rubix": 792,
    "jit.scalebias": 793,
    "jit.scanoffset": 792,
    "jit.scanslide": 792,
    "jit.scanwrap": 792,
    "jit.scissors": 145,
    "jit.shade": 355,
    "jit.slide": 792,
    "jit.sobel": 792,
    "jit.spill": 768,
    "jit.split": 664,
    "jit.sprinkle": 792,
    "jit.str.fromsymbol": 679,
    "jit.str.op": 679,
    "jit.str.regexp": 769,
    "jit.str.tosymbol": 679,
    "jit.streak": 792,
    "jit.submatrix": 547,
    "jit.textfile": 530,
    "jit.thin": 552,
    "jit.tiffany": 792,
    "jit.traffic": 792,
    "jit.transpose": 792,
    "jit.turtle": 762,
    "jit.unpack": 354,
    "jit.uyvy2argb": 130,
    "jit.uyvy2ayuv": 130,
    "jit.uyvy2luma": 130,
    "jit.vcr": 544,
    "jit.wake": 792,
    "jit.window": 790,
    "jit.xfade": 384,
    "js": 584,
    "jstrigger": 584,
    "jsui": 426,
    "key": 774,
    "keyup": 774,
    "kink~": 461,
    "kslider": 646,
    "lcd": 752,
    "led": 829,
    "levelmeter~": 796,
    "line": 617,
    "linedrive": 599,
    "line~": 786,
    "listfunnel": 289,
    "loadbang": 755,
    "loadmess": 611,
    "log~": 344,
    "lookup~": 817,
    "lores~": 688,
    "makenote": 680,
    "match": 759,
    "matrixctrl": 697,
    "matrix~": 641,
    "maximum": 716,
    "maximum~": 633,
    "mean": 226,
    "menubar": 374,
    "message": 818,
    "meter~": 797,
    "metro": 609,
    "midiflush": 680,
    "midiformat": 494,
    "midiin": 707,
    "midiinfo": 487,
    "midiout": 749,
    "midiparse": 787,
    "minimum": 717,
    "minimum~": 633,
    "minmax~": 633,
    "modifiers": 774,
    "mousefilter": 691,
    "mousestate": 774,
    "movie": 654,
    "mstosamps~": 592,
    "mtof": 469,
    "mtof~": 129,
    "mtr": 741,
    "multislider": 646,
    "mute~": 699,
    "mxj": 318,
    "mxj~": 317,
    "next": 162,
    "noise~": 811,
    "normalize~": 597,
    "notein": 787,
    "noteout": 750,
    "nslider": 441,
    "number": 778,
    "number~": 794,
    "numkey": 766,
    "offer": 677,
    "omx.4band~": 423,
    "omx.5band~": 423,
    "omx.comp~": 423,
    "omx.peaklim~": 455,
    "onebang": 742,
    "onecopy": 497,
    "onepole~": 645,
    "opendialog": 427,
    "oscbank~": 433,
    "out": 483,
    "outlet": 818,
    "out~": 483,
    "overdrive~": 650,
    "pack": 444,
    "pak": 444,
    "panel": 445,
    "pass~": 699,
    "past": 729,
    "patcher": 683,
    "patcherargs": 257,
    "pattr": 453,
    "pattrforward": 611,
    "pattrhub": 12,
    "pattrstorage": 677,
    "pcontrol": 816,
    "peak": 716,
    "peakamp~": 633,
    "peek~": 708,
    "pfft~": 661,
    "pgmin": 542,
    "pgmout": 750,
    "phaseshift~": 463,
    "phasewrap~": 819,
    "phasor~": 596,
    "pictctrl": 465,
    "pictslider": 646,
    "pink~": 688,
    "pipe": 802,
    "playbar": 801,
    "play~": 782,
    "plugphasor~": 276,
    "plugsync~": 561,
    "poke~": 823,
    "poltocar": 480,
    "poltocar~": 658,
    "poly": 799,
    "polyin": 542,
    "polyout": 750,
    "poly~": 483,
    "pong~": 779,
    "pow": 113,
    "pow~": 344,
    "prepend": 495,
    "preset": 677,
    "print": 726,
    "prob": 748,
    "pv": 795,
    "pvar": 151,
    "qlim": 509,
    "qlist": 611,
    "qmetro": 509,
    "quickthresh": 213,
    "radiogroup": 515,
    "rampsmooth~": 647,
    "random": 810,
    "rand~": 688,
    "rate~": 737,
    "receive": 818,
    "receive~": 681,
    "record~": 591,
    "rect~": 688,
    "regexp": 772,
    "relativepath": 129,
    "reson~": 688,
    "rewire~": 527,
    "round~": 581,
    "route": 755,
    "router": 582,
    "rslider": 646,
    "rtin": 705,
    "s": 611,
    "sah~": 586,
    "sampstoms~": 592,
    "savedialog": 594,
    "saw~": 688,
    "scale": 599,
    "scope~": 794,
    "screensize": 603,
    "select": 829,
    "selector~": 699,
    "send": 818,
    "send~": 751,
    "seq": 719,
    "seq~": 639,
    "serial": 791,
    "setclock": 789,
    "sfinfo~": 561,
    "sflist~": 677,
    "sfplay~": 589,
    "sfrecord~": 545,
    "sig~": 786,
    "sin": 43,
    "sinh": 757,
    "sinh~": 757,
    "sinx~": 757,
    "slide": 225,
    "slider": 646,
    "slide~": 224,
    "snapshot~": 794,
    "spectroscope~": 660,
    "speedlim": 802,
    "spell": 722,
    "spigot~": 582,
    "spike~": 633,
    "split": 829,
    "spray": 620,
    "sprintf": 725,
    "sqrt": 667,
    "sqrt~": 667,
    "standalone": 354,
    "stripnote": 690,
    "strippath": 257,
    "stutter~": 635,
    "substitute": 686,
    "suckah": 257,
    "suspend": 561,
    "sustain": 693,
    "svf~": 672,
    "swap": 694,
    "swatch": 514,
    "switch": 698,
    "sxformat": 706,
    "sync~": 701,
    "sysexin": 707,
    "table": 810,
    "tan": 43,
    "tanh": 757,
    "tanh~": 757,
    "tanx~": 757,
    "tapin~": 568,
    "tapout~": 568,
    "techno~": 817,
    "teeth~": 221,
    "tempo": 713,
    "text": 720,
    "thispatcher": 816,
    "thispoly~": 483,
    "thresh": 802,
    "thresh~": 755,
    "timer": 732,
    "togedge": 829,
    "toggle": 829,
    "tosymbol": 129,
    "touchin": 542,
    "touchout": 750,
    "train~": 557,
    "trapezoid~": 808,
    "triangle~": 808,
    "trigger": 609,
    "tri~": 688,
    "trough": 717,
    "trunc~": 760,
    "ubutton": 755,
    "udpreceive": 541,
    "udpsend": 614,
    "umenu": 723,
    "universal": 611,
    "unpack": 620,
    "urn": 810,
    "uzi": 642,
    "value": 818,
    "vdp": 791,
    "vectral~": 785,
    "vexpr": 783,
    "vst~": 478,
    "waveform~": 264,
    "wave~": 817,
    "xbendin": 538,
    "xbendin2": 538,
    "xbendout": 612,
    "xbendout2": 612,
    "xnotein": 788,
    "xnoteout": 788,
    "zerox~": 828,
    "zigzag~": 338,
    "zl": 396,
    "zmap": 356,
    "zplane~": 262,
}

mapping = {
     '|': 'bitor',
     '||': 'logor',
     '!-': 'rminus',
     '!-~': 'rminus~',
     '!/': 'rdiv',
     '!/~': 'rdiv',
     '!=': 'notequals',
     '!=~': 'notequals~',
     '%': 'modulo',
     '%~': 'modulo~',
     '&': 'bitand',
     '&&': 'logand',
     '*': 'times',
     '*~': 'times~',
     '+': 'plus',
     '+=~': 'plusequals~',
     '+~': 'plus~',
     '-': 'minus',
     '-~': 'minus~',
     '/': 'div',
     '/~': 'div~',
     '<': 'lessthan',
     '<<': 'shiftleft',
     '<=': 'lessthaneq',
     '<=~': 'lessthaneq~',
     '<~': 'lessthan~',
     '==': 'equals',
     '==~': 'equals~',
     '>': 'greaterthan',
     '>=': 'greaterthaneq',
     '>=~': 'greaterthaneq~',
     '>>': 'shiftright',
     '>~': 'greaterthan~',
     'ggate': 'gswitch2',
     's': 'send',
     'r': 'receive',
     'xbendin2': 'xbendin',
     'xbendout2': 'xbendout',
}


def get_ref(symbol):
     code = objects[symbol]
     desc = descriptions[code]
     # deal with the exception of symbols mapping to words
     # in the documentation refpages
     name = mapping[symbol] if symbol in mapping else symbol
     ref_url = f'https://docs.cycling74.com/max8/refpages/{name}'
     return (desc, ref_url)

def open_browser_tab_for_ref(symbol):
     desc, ref_url = get_ref(symbol)
     webbrowser.open_new_tab(ref_url)
