#!/bin/sh

IEMBINAMBI_H=iem_bin_ambi_sources.h
IEMBINAMBI_C=iem_bin_ambi_sources.c

EGREP=egrep
SED=sed
LS=ls

#################################
## functions

function head_h() {
 echo "/* iem_bin_ambi-setup autogenerated header-file"
 echo " * generated by \"$0\""
 echo " * !! DO NOT MANUALLY EDIT  !!"
 echo " */"
 echo
 echo "#ifndef IEMBINAMBI_SOURCES_H__"
 echo "#define IEMBINAMBI_SOURCES_H__"
}

function foot_h() {
 echo "#endif /* IEMBINAMBI_SOURCES_H__ */"
 echo ""
}

function head_c() {
 echo "/* iem_bin_ambi-setup autogenerated setup-file"
 echo " * generated by \"$0\""
 echo " * !! DO NOT MANUALLY EDIT  !!"
 echo " */"
 echo 
 echo "#include \"$IEMBINAMBI_H\""
 echo
 echo "void iem_bin_ambi_sources_setup(void)"
 echo "{"
}

function foot_c() {
 echo "}"
 echo
}


##################################
## body

head_h > $IEMBINAMBI_H
head_c > $IEMBINAMBI_C

for i in $(${LS} *.c | ${EGREP} -v "iem_bin_ambi.*\.c")
do
## each c-file in iem_bin_ambi needs to have an <file>_setup()-function
## that calls all needed setup-functions
## any non-alpha-numeric-character is replaced by "_"
## e.g. "bla~.c" -> "bla__setup()"
  SETUPNAME=$(echo ${i%.c} | ${SED} -e 's/[^[:alnum:]]/_/g')_setup
  echo "void ${SETUPNAME}(void); /* $i */" >> $IEMBINAMBI_H
  echo "	${SETUPNAME}(); /* $i */" >> $IEMBINAMBI_C
done

foot_h >> $IEMBINAMBI_H
foot_c >> $IEMBINAMBI_C

