/*__________________________________________________________________________

	strchr           strchr c-string function
						
    Copyright (C) 2003 jan schacher

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
    
    initial build 20030507
    
____________________________________________________________________________*/

#include "m_pd.h"
#include <string.h>

typedef struct strchr 		
{
	t_object		ob;		
	void 			*s_outlet;	
	char 			s_tempstring[4096];
} t_strchr;

void *strchr_class;
void *strchr_new(t_symbol *s, long argc, t_atom *argv);
void strchr_free(t_strchr *x);
void strchr_anything(t_strchr *x, t_symbol *s, long argc, t_atom *argv);
void strchr_set(t_strchr *x, t_symbol *s, long argc, t_atom *argv);

void strchr_setup(void)
{	
	strchr_class = class_new(gensym("strchr"), (t_newmethod)strchr_new, 0L, sizeof(t_strchr), 0, A_GIMME, 0);
	class_addsymbol(strchr_class, (t_method)strchr_anything);	
	class_addmethod(strchr_class, (t_method)strchr_set,		gensym("set"),	A_GIMME, 0);
	post(".    strchr    .    jasch    .    "__DATE__"",0);
}

void *strchr_new(t_symbol *s, long argc, t_atom *argv)
{
	short i;
	t_strchr	*x;
	x = (t_strchr *)pd_new(strchr_class);
	x->s_outlet = outlet_new(&x->ob, gensym("float"));	
	strcpy(x->s_tempstring, "/");
	for(i=0; i<argc; i++){
		switch(argv[i].a_type){
			case A_SYMBOL:
				if(i == 0){
					strncpy(x->s_tempstring, argv[0].a_w.w_symbol->s_name, 1);
				}
			break;
		}
	}
	return (x);									
}

void strchr_assist(t_strchr *x, void *b, long msg, long arg, char *dst)
{
	if(msg==1) 	
		switch(arg){
			case 0: strcpy(dst, "string in (symbol)"); break;
			}
	else if(msg==2){ 				
		 strcpy(dst, "matched position (int)");	
 	}		
}

void strchr_anything(t_strchr *x, t_symbol *s, long argc, t_atom *argv)
{
	char	*ptr;
	char	local[4096];
	long	pos;
	strcpy(local, s->s_name);
	ptr = strchr(local, (char)x->s_tempstring[0]);
	if(ptr != NULL){
   		pos = (long)(ptr-local+1);
   			outlet_float(x->s_outlet, pos); 
   		}else{
   			outlet_float(x->s_outlet, -1); 
   		}
	return;
}

void strchr_set(t_strchr *x, t_symbol *s, long argc, t_atom *argv)
{
		{
	switch (argv[0].a_type) {
		case A_FLOAT: error("strchr: wrong argument type for set");break;
		case A_SYMBOL:
			strncpy(x->s_tempstring, argv[0].a_w.w_symbol->s_name, 1);
			x->s_tempstring[1] = 0;
		break;
		}
}
		
}

void strchr_free(t_strchr *x)
{
		// notify_free((t_object *)x);
}