/* Copyright 2008-2012, University of Illinois at Urbana-Champaign          */
/* distributed under the Apache License, Version (2.0)                      */
/* http://www.apache.org/licenses/LICENSE-2.0                               */
/* Original table developed by Richard Sproat and Kyoung-young Kim          */
/* Ported for Festvox by Gopala Anumachipalli gopalakr@cs.cmu.edu Sep 2012  */
/* Then converted to C for CMU Flite (cmuflite.org)                         */
#include <flite.h>
const int num_unicode_sampa_mapping = 16885;
const char * const unicode_sampa_mapping[16886][5] =
{
   {"let_a", "A", NULL, NULL, NULL},
   {"let_b", "b", NULL, NULL, NULL},
   {"let_c", "ch", NULL, NULL, NULL},
   {"let_d", "d", NULL, NULL, NULL},
   {"let_e", "e", NULL, NULL, NULL},
   {"let_f", "f", NULL, NULL, NULL},
   {"let_g", "g", NULL, NULL, NULL},
   {"let_h", "h", NULL, NULL, NULL},
   {"let_i", "i", NULL, NULL, NULL},
   {"let_j", "dZ", NULL, NULL, NULL},
   {"let_k", "k", NULL, NULL, NULL},
   {"let_l", "l", NULL, NULL, NULL},
   {"let_m", "m", NULL, NULL, NULL},
   {"let_n", "n", NULL, NULL, NULL},
   {"let_o", "o", NULL, NULL, NULL},
   {"let_p", "p", NULL, NULL, NULL},
   {"let_q", "QM", NULL, NULL, NULL},
   {"let_r", "r", NULL, NULL, NULL},
   {"let_s", "s", NULL, NULL, NULL},
   {"let_t", "t", NULL, NULL, NULL},
   {"let_u", "u", NULL, NULL, NULL},
   {"let_v", "v", NULL, NULL, NULL},
   {"let_w", "w", NULL, NULL, NULL},
   {"let_x", "k", "s", NULL, NULL},
   {"let_y", "j", NULL, NULL, NULL},
   {"let_z", "z", NULL, NULL, NULL},
   {"space", NULL, NULL, NULL, NULL},
   {"comma", NULL, NULL, NULL, NULL},
   {"u003Fp", NULL, NULL, NULL, NULL},
   {"u0021p", NULL, NULL, NULL, NULL},
   {"u003Ap", NULL, NULL, NULL, NULL},
   {"u003Bp", NULL, NULL, NULL, NULL},
   {"u0093p", NULL, NULL, NULL, NULL},
   {"u0094p", NULL, NULL, NULL, NULL},
   {"u0092p", NULL, NULL, NULL, NULL},
   {"u0091p", NULL, NULL, NULL, NULL},
   {"u0097p", NULL, NULL, NULL, NULL},
   {"u00BFp", NULL, NULL, NULL, NULL},
   {"u00E8p", "e", NULL, NULL, NULL},
   {"u014Bp", "N", NULL, NULL, NULL},
   {"u00A1p", NULL, NULL, NULL, NULL},
   {"u00BBp", NULL, NULL, NULL, NULL},
   {"u00ABp", NULL, NULL, NULL, NULL},
   {"u025Bp", "e", NULL, NULL, NULL},
   {"u014Ap", "N", NULL, NULL, NULL},
   {"u0254p", "dZ", NULL, NULL, NULL},
   {"u0301p", NULL, NULL, NULL, NULL},
   {"u0190p", "e", NULL, NULL, NULL},
   {"u0186p", "dZ", NULL, NULL, NULL},
   {"u0096p", NULL, NULL, NULL, NULL},
   {"u0300p", NULL, NULL, NULL, NULL},
   {"u0303p", NULL, NULL, NULL, NULL},
   {"u008Bp", NULL, NULL, NULL, NULL},
   {"u009Bp", NULL, NULL, NULL, NULL},
   {"u0268p", "i", NULL, NULL, NULL},
   {"u0253p", "b", NULL, NULL, NULL},
   {"u0331p", NULL, NULL, NULL, NULL},
   {"u00C3p", "A", "n", NULL, NULL},
   {"u0181p", "b", NULL, NULL, NULL},
   {"u0259p", "@", NULL, NULL, NULL},
   {"u0257p", "d", NULL, NULL, NULL},
   {"u007Cp", NULL, NULL, NULL, NULL},
   {"u2015p", NULL, NULL, NULL, NULL},
   {"u018Ap", "d", NULL, NULL, NULL},
   {"u0302p", NULL, NULL, NULL, NULL},
   {"u028Bp", "u", NULL, NULL, NULL},
   {"u0269p", "i", NULL, NULL, NULL},
   {"u0197p", "i", NULL, NULL, NULL},
   {"u2011p", NULL, NULL, NULL, NULL},
   {"u01B2p", "u", NULL, NULL, NULL},
   {"u0196p", "i", NULL, NULL, NULL},
   {"u0308p", NULL, NULL, NULL, NULL},
   {"u0128p", "i", "n", NULL, NULL},
   {"u0060p", NULL, NULL, NULL, NULL},
   {"u0026p", NULL, NULL, NULL, NULL},
   {"u030Cp", NULL, NULL, NULL, NULL},
   {"u0289p", "u", NULL, NULL, NULL},
   {"u0144p", "n", NULL, NULL, NULL},
   {"u0101p", "a:", NULL, NULL, NULL},
   {"u016Bp", "u:", NULL, NULL, NULL},
   {"u0084p", NULL, NULL, NULL, NULL},
   {"u018Fp", "@", NULL, NULL, NULL},
   {"u00CBp", "e", NULL, NULL, NULL},
   {"uFFFDp", NULL, NULL, NULL, NULL},
   {"u014Dp", "o:", NULL, NULL, NULL},
   {"u202Fp", NULL, NULL, NULL, NULL},
   {"u202Fp", NULL, NULL, NULL, NULL},
   {"u012Bp", "i:", NULL, NULL, NULL},
   {"u0113p", "e:", NULL, NULL, NULL},
   {"u1E3Fp", "m", NULL, NULL, NULL},
   {"u0272p", "n", NULL, NULL, NULL},
   {"u0168p", "u", "n", NULL, NULL},
   {"u0143p", "n", NULL, NULL, NULL},
   {"u0085p", NULL, NULL, NULL, NULL},
   {"u0263p", "a", NULL, NULL, NULL},
   {"u0244p", "u", NULL, NULL, NULL},
   {"u01F9p", "n", NULL, NULL, NULL},
   {"u01CEp", "a", NULL, NULL, NULL},
   {"u019Dp", "n", NULL, NULL, NULL},
   {"u00D5p", "o", "n", NULL, NULL},
   {"u00ADp", NULL, NULL, NULL, NULL},
   {"u2184p", "dZ", NULL, NULL, NULL},
   {"u0256p", "d", NULL, NULL, NULL},
   {"u011Bp", "e", NULL, NULL, NULL},
   {"u00CAp", "e", NULL, NULL, NULL},
   {"u1EBCp", "e", NULL, NULL, NULL},
   {"u1E8Dp", "X", NULL, NULL, NULL},
   {"u1E3Ep", NULL, NULL, NULL, NULL},
   {"let_u_umlaut", "y:", NULL, NULL, NULL},
   {"let_u_umlaut", "y:", NULL, NULL, NULL},
   {"let_a_umlaut", "OY", NULL, NULL, NULL},
   {"let_o_umlaut", "2:", NULL, NULL, NULL},
   {"let_sharp_s", "s", NULL, NULL, NULL},
   {"let_single_quote", NULL, NULL, NULL, NULL},
   {"let_double_quote", NULL, NULL, NULL, NULL},
   {"let_asterisk", NULL, NULL, NULL, NULL},
   {"let_underscore", NULL, NULL, NULL, NULL},
   {"let_tilde", NULL, NULL, NULL, NULL},
   {"let_hyphen", NULL, NULL, NULL, NULL},
   {"let_period", NULL, NULL, NULL, NULL},
   {"let_period", NULL, NULL, NULL, NULL},
   {"let_slash", NULL, NULL, NULL, NULL},
   {"let_less_than", NULL, NULL, NULL, NULL},
   {"let_greater_than", NULL, NULL, NULL, NULL},
   {"let_left_brace", NULL, NULL, NULL, NULL},
   {"let_right_brace", NULL, NULL, NULL, NULL},
   {"let_left_paren", NULL, NULL, NULL, NULL},
   {"let_right_paren", NULL, NULL, NULL, NULL},
   {"let_left_bracket", NULL, NULL, NULL, NULL},
   {"let_right_bracket", NULL, NULL, NULL, NULL},
   {"let_close_apostrophe", NULL, NULL, NULL, NULL},
   {"let_close_single_quote", NULL, NULL, NULL, NULL},
   {"let_a_dot", "a:", NULL, NULL, NULL},
   {"let_a_hook", "E", NULL, NULL, NULL},
   {"let_a_grave", "a:", NULL, NULL, NULL},
   {"let_a_hat_grave", "@", NULL, NULL, NULL},
   {"let_a_hat_grave", "@", NULL, NULL, NULL},
   {"let_a_hat_acute", "@", NULL, NULL, NULL},
   {"let_a_hat_hook", "@", NULL, NULL, NULL},
   {"let_a_hat_tilde", "@", NULL, NULL, NULL},
   {"let_a_hat_dot", "@", NULL, NULL, NULL},
   {"let_a_breve_acute", "a", NULL, NULL, NULL},
   {"let_a_breve_grave", "a", NULL, NULL, NULL},
   {"let_a_breve_hook", "a", NULL, NULL, NULL},
   {"let_a_breve_tilde", "a", NULL, NULL, NULL},
   {"let_a_breve_dot", "a", NULL, NULL, NULL},
   {"let_e_dot", "E", NULL, NULL, NULL},
   {"let_a_hook", "E", NULL, NULL, NULL},
   {"let_a_tilde", "E", NULL, NULL, NULL},
   {"let_a_hat_acute", "i@", NULL, NULL, NULL},
   {"let_a_hat_grave", "e", NULL, NULL, NULL},
   {"let_a_hat_hook", "n", NULL, NULL, NULL},
   {"let_a_hat_tilde", "e", NULL, NULL, NULL},
   {"let_a_hat_dot", "i@", NULL, NULL, NULL},
   {"let_i_hook", "i", NULL, NULL, NULL},
   {"let_i_dot", "i", NULL, NULL, NULL},
   {"let_o_dot", "O", NULL, NULL, NULL},
   {"let_o_hook", "O", NULL, NULL, NULL},
   {"let_o_hat_acute", "o", NULL, NULL, NULL},
   {"let_o_hat_acute", "o", NULL, NULL, NULL},
   {"let_o_hat_grave", "o", NULL, NULL, NULL},
   {"let_o_hat_hook", "o", NULL, NULL, NULL},
   {"let_o_hat_tilde", "o", NULL, NULL, NULL},
   {"let_o_hat_dot", "o", NULL, NULL, NULL},
   {"let_o_horn_acute", "@:", NULL, NULL, NULL},
   {"let_o_horn_grave", "@:", NULL, NULL, NULL},
   {"let_o_horn_hook", "@:", NULL, NULL, NULL},
   {"let_o_horn_tilde", "@:", NULL, NULL, NULL},
   {"let_o_horn_dot", "@:", NULL, NULL, NULL},
   {"let_u_dot", "u", NULL, NULL, NULL},
   {"let_u_hook", "ui:", NULL, NULL, NULL},
   {"let_u_hook", "u", NULL, NULL, NULL},
   {"let_u_horn_acute", "1", NULL, NULL, NULL},
   {"let_u_horn_acute", "1", NULL, NULL, NULL},
   {"let_u_horn_grave", "1", NULL, NULL, NULL},
   {"let_u_horn_hook", "1", NULL, NULL, NULL},
   {"let_u_horn_tilde", "1", NULL, NULL, NULL},
   {"let_u_horn_dot", "1", NULL, NULL, NULL},
   {"let_u_grave", "i", NULL, NULL, NULL},
   {"let_y_dot", "i", NULL, NULL, NULL},
   {"let_y_hook", "i", NULL, NULL, NULL},
   {"let_y_tilde", "i", NULL, NULL, NULL},
   {"let_a_acute", "A", NULL, NULL, NULL},
   {"let_e_acute", "e", NULL, NULL, NULL},
   {"let_i_acute", "i", NULL, NULL, NULL},
   {"let_o_acute", "o", NULL, NULL, NULL},
   {"let_u_acute", "u", NULL, NULL, NULL},
   {"let_n_tilde", "J", NULL, NULL, NULL},
   {"let_a_grave", "A", NULL, NULL, NULL},
   {"let_e_grave", "E", NULL, NULL, NULL},
   {"let_i_grave", "i", NULL, NULL, NULL},
   {"let_o_grave", "O", NULL, NULL, NULL},
   {"let_u_grave", "u", NULL, NULL, NULL},
   {"let_e_circumflex", "E", NULL, NULL, NULL},
   {"let_o_circumflex", "o", NULL, NULL, NULL},
   {"let_o_slashed", "o", NULL, NULL, NULL},
   {"let_ae", "A", NULL, NULL, NULL},
   {"let_a_ring", "A", NULL, NULL, NULL},
   {"let_i_dotless", "i", NULL, NULL, NULL},
   {"let_i_dotted_cap", "i", NULL, NULL, NULL},
   {"let_g_breve", "g", NULL, NULL, NULL},
   {"let_s_cedilla", "S", NULL, NULL, NULL},
   {"u00C1p", "a:I", NULL, NULL, NULL},
   {"u00C2p", "@", NULL, NULL, NULL},
   {"u00C7p", "s", NULL, NULL, NULL},
   {"u00D4p", "o", NULL, NULL, NULL},
   {"u00DAp", "u", NULL, NULL, NULL},
   {"u00DDp", "i", NULL, NULL, NULL},
   {"u00E1p", "A", NULL, NULL, NULL},
   {"u00E2p", "A", NULL, NULL, NULL},
   {"u00E3p", "a", NULL, NULL, NULL},
   {"u00E7p", "s", NULL, NULL, NULL},
   {"u00EBp", "9", NULL, NULL, NULL},
   {"u00EDp", "a", NULL, NULL, NULL},
   {"u00EEp", "E", NULL, NULL, NULL},
   {"u00EFp", "i", NULL, NULL, NULL},
   {"u00F1p", "J", NULL, NULL, NULL},
   {"u00F3p", "o", NULL, NULL, NULL},
   {"u00F5p", "o", NULL, NULL, NULL},
   {"u00FAp", "y", NULL, NULL, NULL},
   {"u00FBp", "u", NULL, NULL, NULL},
   {"u00FDp", "i", NULL, NULL, NULL},
   {"u0111p", "6", NULL, NULL, NULL},
   {"u01B0p", "1@", NULL, NULL, NULL},
   {"u01A1p", "@:", NULL, NULL, NULL},
   {"u0103p", "a", NULL, NULL, NULL},
   {"u0110p", "d_LT", NULL, NULL, NULL},
   {"u0169p", "u", NULL, NULL, NULL},
   {"u0129p", "i", NULL, NULL, NULL},
   {"u01AFp", "1@", NULL, NULL, NULL},
   {"u200Cp", NULL, NULL, NULL, NULL},
   {"u200Dp", NULL, NULL, NULL, NULL},
   {"u0600p", "NUMBERSIGN", NULL, NULL, NULL},
   {"u0601p", "SANAH", NULL, NULL, NULL},
   {"u0602p", "FOOTNOTEMARKER", NULL, NULL, NULL},
   {"u0603p", "SAPHA", NULL, NULL, NULL},
   {"u060Bp", "AFGHANISIGN", NULL, NULL, NULL},
   {"u060Cp", "COMMA", NULL, NULL, NULL},
   {"u060Dp", "DATESEPARATOR", NULL, NULL, NULL},
   {"u060Ep", "POETICVERSESIGN", NULL, NULL, NULL},
   {"u060Fp", "SIGNMISRA", NULL, NULL, NULL},
   {"u061Bp", "SEMICOLON", NULL, NULL, NULL},
   {"u061Ep", "TRIPLEDOT", NULL, NULL, NULL},
   {"u061Fp", "QUESTIONMARK", NULL, NULL, NULL},
   {"u0621p", "HAMZA", NULL, NULL, NULL},
   {"u0622p", "QM", "@:", NULL, NULL},
   {"u0623p", "QM", NULL, NULL, NULL},
   {"u0624p", "QM", NULL, NULL, NULL},
   {"u0625p", "QM", NULL, NULL, NULL},
   {"u0626p", "QM", NULL, NULL, NULL},
   {"u0627p", "@:", NULL, NULL, NULL},
   {"u0628p", "b", NULL, NULL, NULL},
   {"u0629p", "t", NULL, NULL, NULL},
   {"u062Ap", "t", NULL, NULL, NULL},
   {"u062Bp", "T", NULL, NULL, NULL},
   {"u062Cp", "dZ", NULL, NULL, NULL},
   {"u062Dp", "H", NULL, NULL, NULL},
   {"u062Ep", "x", NULL, NULL, NULL},
   {"u062Fp", "d", NULL, NULL, NULL},
   {"u0630p", "D", NULL, NULL, NULL},
   {"u0631p", "r", NULL, NULL, NULL},
   {"u0632p", "z", NULL, NULL, NULL},
   {"u0633p", "s", NULL, NULL, NULL},
   {"u0634p", "S", NULL, NULL, NULL},
   {"u0635p", "s~", NULL, NULL, NULL},
   {"u0636p", "d~", NULL, NULL, NULL},
   {"u0637p", "t~", NULL, NULL, NULL},
   {"u0638p", "z~", NULL, NULL, NULL},
   {"u0639p", "hv", NULL, NULL, NULL},
   {"u063Ap", "G", NULL, NULL, NULL},
   {"u0640p", "TATWEEL", NULL, NULL, NULL},
   {"u0641p", "f", NULL, NULL, NULL},
   {"u0642p", "q", NULL, NULL, NULL},
   {"u0643p", "k", NULL, NULL, NULL},
   {"u0644p", "l", NULL, NULL, NULL},
   {"u0645p", "m", NULL, NULL, NULL},
   {"u0646p", "n", NULL, NULL, NULL},
   {"u0647p", "h", NULL, NULL, NULL},
   {"u0648p", "u:", NULL, NULL, NULL},
   {"u0649p", "a:", NULL, NULL, NULL},
   {"u064Ap", "i:", NULL, NULL, NULL},
   {"u064Bp", "FATHATAN", NULL, NULL, NULL},
   {"u064Cp", "DAMMATAN", NULL, NULL, NULL},
   {"u064Dp", "KASRATAN", NULL, NULL, NULL},
   {"u064Ep", "E", NULL, NULL, NULL},
   {"u064Fp", "U", NULL, NULL, NULL},
   {"u0650p", "I", NULL, NULL, NULL},
   {"u0651p", "SHADDA", NULL, NULL, NULL},
   {"u0652p", "a~", NULL, NULL, NULL},
   {"u0653p", "MADDAHABOVE", NULL, NULL, NULL},
   {"u0654p", "HAMZAABOVE", NULL, NULL, NULL},
   {"u0655p", "HAMZEBELOW", NULL, NULL, NULL},
   {"u0656p", "SUBSCRIPTALEF", NULL, NULL, NULL},
   {"u0657p", "INVERTEDDAMMA", NULL, NULL, NULL},
   {"u0658p", "NOONGHUNNA", NULL, NULL, NULL},
   {"u0659p", "ZWARAKAY", NULL, NULL, NULL},
   {"u065Ap", "SMALLVABOVE", NULL, NULL, NULL},
   {"u065Bp", "INVERTEDSMALLV", NULL, NULL, NULL},
   {"u065Cp", "DOTBELOW", NULL, NULL, NULL},
   {"u065Dp", "REVERSEDDAMMA", NULL, NULL, NULL},
   {"u065Ep", "FATHAWITHTWODOTS", NULL, NULL, NULL},
   {"u0660p", "ZERO", NULL, NULL, NULL},
   {"u0661p", "ONE", NULL, NULL, NULL},
   {"u0662p", "TWO", NULL, NULL, NULL},
   {"u0663p", "THREE", NULL, NULL, NULL},
   {"u0664p", "FOUR", NULL, NULL, NULL},
   {"u0665p", "FIVE", NULL, NULL, NULL},
   {"u0666p", "SIX", NULL, NULL, NULL},
   {"u0667p", "SEVEN", NULL, NULL, NULL},
   {"u0668p", "EIGHT", NULL, NULL, NULL},
   {"u0669p", "NINE", NULL, NULL, NULL},
   {"u066Ap", "PERCENTSIGN", NULL, NULL, NULL},
   {"u066Bp", "DECIMMALSEPARATOR", NULL, NULL, NULL},
   {"u066Cp", "THOUSANDSEPARATOR", NULL, NULL, NULL},
   {"u066Dp", "ASTERISK", NULL, NULL, NULL},
   {"u066Ep", "b", NULL, NULL, NULL},
   {"u066Fp", "q", NULL, NULL, NULL},
   {"u0670p", "a~", NULL, NULL, NULL},
   {"u0671p", "QM", NULL, NULL, NULL},
   {"u0672p", "QM", NULL, NULL, NULL},
   {"u0673p", "QM", NULL, NULL, NULL},
   {"u0674p", "HIGHHAMZA", NULL, NULL, NULL},
   {"u0675p", "QM", NULL, NULL, NULL},
   {"u0676p", "w", NULL, NULL, NULL},
   {"u0677p", "w", NULL, NULL, NULL},
   {"u0678p", "j", NULL, NULL, NULL},
   {"u0679p", "tr", NULL, NULL, NULL},
   {"u067Ap", "T", NULL, NULL, NULL},
   {"u067Bp", "tB", NULL, NULL, NULL},
   {"u067Cp", "tB", NULL, NULL, NULL},
   {"u067Ep", "p", NULL, NULL, NULL},
   {"u0681p", "dZ", NULL, NULL, NULL},
   {"u0685p", "tS", NULL, NULL, NULL},
   {"u0686p", "tS", NULL, NULL, NULL},
   {"u0688p", "dr", NULL, NULL, NULL},
   {"u0689p", "dr", NULL, NULL, NULL},
   {"u0691p", "r", NULL, NULL, NULL},
   {"u0693p", "r", "e:", NULL, NULL},
   {"u0696p", "Z", "e:", NULL, NULL},
   {"u0698p", "Z", NULL, NULL, NULL},
   {"u069Ap", "S", NULL, NULL, NULL},
   {"u06A9p", "k", NULL, NULL, NULL},
   {"u06ABp", "g", NULL, NULL, NULL},
   {"u06ADp", "N", NULL, NULL, NULL},
   {"u06AFp", "g", NULL, NULL, NULL},
   {"u06BAp", "n", NULL, NULL, NULL},
   {"u06BDp", "N", NULL, NULL, NULL},
   {"u06BEp", "ASPIRATED", NULL, NULL, NULL},
   {"u06C0p", "h", NULL, NULL, NULL},
   {"u06C1p", "h", NULL, NULL, NULL},
   {"u06C2p", "h", NULL, NULL, NULL},
   {"u06C3p", "h", NULL, NULL, NULL},
   {"u06C6p", "9", NULL, NULL, NULL},
   {"u06C7p", "u", NULL, NULL, NULL},
   {"u06C8p", "u", NULL, NULL, NULL},
   {"u06CBp", "v", NULL, NULL, NULL},
   {"u06CCp", "j", NULL, NULL, NULL},
   {"u06CDp", "aI", NULL, NULL, NULL},
   {"u06D0p", "e:", NULL, NULL, NULL},
   {"u06D2p", "e:", NULL, NULL, NULL},
   {"u06D3p", "e:", NULL, NULL, NULL},
   {"u06D5p", "@:", NULL, NULL, NULL},
   {"u06D4p", "FULLSTOP", NULL, NULL, NULL},
   {"u06F0p", "ZERO", NULL, NULL, NULL},
   {"u06F1p", "ONE", NULL, NULL, NULL},
   {"u06F2p", "TWO", NULL, NULL, NULL},
   {"u06F3p", "THREE", NULL, NULL, NULL},
   {"u06F4p", "FOUR", NULL, NULL, NULL},
   {"u06F5p", "FIVE", NULL, NULL, NULL},
   {"u06F6p", "SIX", NULL, NULL, NULL},
   {"u06F7p", "SEVEN", NULL, NULL, NULL},
   {"u06F8p", "EIGHT", NULL, NULL, NULL},
   {"u06F9p", "NINE", NULL, NULL, NULL},
   {"u0531p", "A", NULL, NULL, NULL},
   {"u0532p", "b", NULL, NULL, NULL},
   {"u0533p", "g", NULL, NULL, NULL},
   {"u0534p", "d", NULL, NULL, NULL},
   {"u0535p", "E", NULL, NULL, NULL},
   {"u0536p", "z", NULL, NULL, NULL},
   {"u0537p", "e", NULL, NULL, NULL},
   {"u0538p", "GT", NULL, NULL, NULL},
   {"u0539p", "th", NULL, NULL, NULL},
   {"u053Ap", "Z", NULL, NULL, NULL},
   {"u053Bp", "i", NULL, NULL, NULL},
   {"u053Cp", "l", NULL, NULL, NULL},
   {"u053Dp", "z", NULL, NULL, NULL},
   {"u053Ep", "ts", NULL, NULL, NULL},
   {"u053Fp", "k", NULL, NULL, NULL},
   {"u0540p", "h", NULL, NULL, NULL},
   {"u0541p", "dz", NULL, NULL, NULL},
   {"u0542p", "G", NULL, NULL, NULL},
   {"u0543p", "tS", NULL, NULL, NULL},
   {"u0544p", "m", NULL, NULL, NULL},
   {"u0545p", "h", NULL, NULL, NULL},
   {"u0546p", "n", NULL, NULL, NULL},
   {"u0547p", "S", NULL, NULL, NULL},
   {"u0548p", "o", NULL, NULL, NULL},
   {"u0549p", "tSh", NULL, NULL, NULL},
   {"u054Ap", "p", NULL, NULL, NULL},
   {"u054Bp", "dZ", NULL, NULL, NULL},
   {"u054Cp", "r", NULL, NULL, NULL},
   {"u054Dp", "s", NULL, NULL, NULL},
   {"u054Ep", "v", NULL, NULL, NULL},
   {"u054Fp", "t", NULL, NULL, NULL},
   {"u0550p", "9", NULL, NULL, NULL},
   {"u0551p", "tsh", NULL, NULL, NULL},
   {"u0552p", "v", NULL, NULL, NULL},
   {"u0553p", "ph", NULL, NULL, NULL},
   {"u0554p", "kh", NULL, NULL, NULL},
   {"u0555p", "o", NULL, NULL, NULL},
   {"u0556p", "f", NULL, NULL, NULL},
   {"u0559p", "ML", NULL, NULL, NULL},
   {"u055Ap", "APOSTROPHE", NULL, NULL, NULL},
   {"u055Bp", "EMPHASISMARK", NULL, NULL, NULL},
   {"u055Cp", "EXCLAMATIONMARK", NULL, NULL, NULL},
   {"u055Dp", "COMMA", NULL, NULL, NULL},
   {"u055Ep", "QUESTIONMARK", NULL, NULL, NULL},
   {"u055Fp", "ABBREVIATIONMARK", NULL, NULL, NULL},
   {"u0561p", "A", NULL, NULL, NULL},
   {"u0562p", "b", NULL, NULL, NULL},
   {"u0563p", "g", NULL, NULL, NULL},
   {"u0564p", "d", NULL, NULL, NULL},
   {"u0565p", "j", "E", NULL, NULL},
   {"u0566p", "z", NULL, NULL, NULL},
   {"u0567p", "e", NULL, NULL, NULL},
   {"u0568p", "GT", NULL, NULL, NULL},
   {"u0569p", "th", NULL, NULL, NULL},
   {"u056Ap", "Z", NULL, NULL, NULL},
   {"u056Bp", "i", NULL, NULL, NULL},
   {"u056Cp", "l", NULL, NULL, NULL},
   {"u056Dp", "x", NULL, NULL, NULL},
   {"u056Ep", "ts", NULL, NULL, NULL},
   {"u056Fp", "k", NULL, NULL, NULL},
   {"u0570p", "h", NULL, NULL, NULL},
   {"u0571p", "dz", NULL, NULL, NULL},
   {"u0572p", "G", NULL, NULL, NULL},
   {"u0573p", "tS", NULL, NULL, NULL},
   {"u0574p", "m", NULL, NULL, NULL},
   {"u0575p", "h", NULL, NULL, NULL},
   {"u0576p", "n", NULL, NULL, NULL},
   {"u0577p", "S", NULL, NULL, NULL},
   {"u0578p", "o", NULL, NULL, NULL},
   {"u0579p", "tSh", NULL, NULL, NULL},
   {"u057Ap", "p", NULL, NULL, NULL},
   {"u057Bp", "dZ", NULL, NULL, NULL},
   {"u057Cp", "r", NULL, NULL, NULL},
   {"u057Dp", "s", NULL, NULL, NULL},
   {"u057Ep", "v", NULL, NULL, NULL},
   {"u057Fp", "t", NULL, NULL, NULL},
   {"u0580p", "9", NULL, NULL, NULL},
   {"u0581p", "tsh", NULL, NULL, NULL},
   {"u0582p", "w", NULL, NULL, NULL},
   {"u0583p", "ph", NULL, NULL, NULL},
   {"u0584p", "kh", NULL, NULL, NULL},
   {"u0585p", "o", NULL, NULL, NULL},
   {"u0586p", "f", NULL, NULL, NULL},
   {"u0587p", "E", "w", NULL, NULL},
   {"u0589p", "FULLSTOP", NULL, NULL, NULL},
   {"u058Ap", "HYPHEN", NULL, NULL, NULL},
   {"u0981p", "CD", NULL, NULL, NULL},
   {"u0982p", "M", NULL, NULL, NULL},
   {"u0983p", "H", NULL, NULL, NULL},
   {"u0985p", "GT", NULL, NULL, NULL},
   {"u0986p", "A", NULL, NULL, NULL},
   {"u0987p", "i", NULL, NULL, NULL},
   {"u0988p", "i:", NULL, NULL, NULL},
   {"u0989p", "u", NULL, NULL, NULL},
   {"u098Ap", "u:", NULL, NULL, NULL},
   {"u098Bp", "9r", "i", NULL, NULL},
   {"u098Cp", "l=", NULL, NULL, NULL},
   {"u098Dp", "R:098D", NULL, NULL, NULL},
   {"u098Ep", "R:098E", NULL, NULL, NULL},
   {"u098Fp", "@", NULL, NULL, NULL},
   {"u0990p", "oI", NULL, NULL, NULL},
   {"u0991p", "R:0991", NULL, NULL, NULL},
   {"u0992p", "R:0992", NULL, NULL, NULL},
   {"u0993p", "o", NULL, NULL, NULL},
   {"u0994p", "oU", NULL, NULL, NULL},
   {"u0995p", "k", "A", NULL, NULL},
   {"u0996p", "kh", "A", NULL, NULL},
   {"u0997p", "g", "A", NULL, NULL},
   {"u0998p", "gh", "A", NULL, NULL},
   {"u0999p", "N", "A", NULL, NULL},
   {"u099Ap", "c", "A", NULL, NULL},
   {"u099Bp", "ch", "A", NULL, NULL},
   {"u099Cp", "J", "A", NULL, NULL},
   {"u099Dp", "Jh", "A", NULL, NULL},
   {"u099Ep", "n~", "A", NULL, NULL},
   {"u099Fp", "tr", "A", NULL, NULL},
   {"u09A0p", "tR", "A", NULL, NULL},
   {"u09A1p", "dr", "A", NULL, NULL},
   {"u09A2p", "dR", "A", NULL, NULL},
   {"u09A3p", "nr", "A", NULL, NULL},
   {"u09A4p", "tB", "A", NULL, NULL},
   {"u09A5p", "tBh", "A", NULL, NULL},
   {"u09A6p", "dB", "A", NULL, NULL},
   {"u09A7p", "dBh", "A", NULL, NULL},
   {"u09A8p", "nB", "A", NULL, NULL},
   {"u09A9p", "R:09A9", NULL, NULL, NULL},
   {"u09AAp", "p", "A", NULL, NULL},
   {"u09ABp", "ph", "A", NULL, NULL},
   {"u09ACp", "b", "A", NULL, NULL},
   {"u09ADp", "bh", "A", NULL, NULL},
   {"u09AEp", "m", "A", NULL, NULL},
   {"u09AFp", "j", "A", NULL, NULL},
   {"u09B0p", "9r", "A", NULL, NULL},
   {"u09B1p", "R:09B1", NULL, NULL, NULL},
   {"u09B2p", "l", "A", NULL, NULL},
   {"u09B3p", "R:09B3", NULL, NULL, NULL},
   {"u09B4p", "R:09B4", NULL, NULL, NULL},
   {"u09B5p", "R:09B5", NULL, NULL, NULL},
   {"u09B6p", "S", "A", NULL, NULL},
   {"u09B7p", "S", "A", NULL, NULL},
   {"u09B8p", "s", "A", NULL, NULL},
   {"u09B9p", "hv", "A", NULL, NULL},
   {"u09BCp", "NUKTA", NULL, NULL, NULL},
   {"u09BDp", "AVAGRAHA", NULL, NULL, NULL},
   {"u09BEp", "A", NULL, NULL, NULL},
   {"u09BFp", "i", NULL, NULL, NULL},
   {"u09C0p", "i:", NULL, NULL, NULL},
   {"u09C1p", "u", NULL, NULL, NULL},
   {"u09C2p", "u:", NULL, NULL, NULL},
   {"u09C3p", "9r=", NULL, NULL, NULL},
   {"u09C4p", "rr=", NULL, NULL, NULL},
   {"u09C5p", "R:09C5", NULL, NULL, NULL},
   {"u09C6p", "R:09C6", NULL, NULL, NULL},
   {"u09C7p", "e", NULL, NULL, NULL},
   {"u09C8p", "oI", NULL, NULL, NULL},
   {"u09C9p", "R:09C9", NULL, NULL, NULL},
   {"u09CAp", "R:09CA", NULL, NULL, NULL},
   {"u09CBp", "o", NULL, NULL, NULL},
   {"u09CCp", "oU", NULL, NULL, NULL},
   {"u09CDp", "P", NULL, NULL, NULL},
   {"u09CEp", "t", "A", NULL, NULL},
   {"u09D7p", "oULENGTHMARK", NULL, NULL, NULL},
   {"u09DCp", "rr", "A", NULL, NULL},
   {"u09DDp", "rh", "A", NULL, NULL},
   {"u09DEp", "t", "A", NULL, NULL},
   {"u09DFp", "jr", "A", NULL, NULL},
   {"u09E0p", "rr=", NULL, NULL, NULL},
   {"u09E1p", "l=", NULL, NULL, NULL},
   {"u09E2p", "l=", NULL, NULL, NULL},
   {"u09E3p", "l=", NULL, NULL, NULL},
   {"u09E4p", "ASTERISK", NULL, NULL, NULL},
   {"u09E5p", "(**)", NULL, NULL, NULL},
   {"u09E6p", "ZERO", NULL, NULL, NULL},
   {"u09E7p", "ONE", NULL, NULL, NULL},
   {"u09E8p", "TWO", NULL, NULL, NULL},
   {"u09E9p", "THREE", NULL, NULL, NULL},
   {"u09EAp", "FOUR", NULL, NULL, NULL},
   {"u09EBp", "FIVE", NULL, NULL, NULL},
   {"u09ECp", "SIX", NULL, NULL, NULL},
   {"u09EDp", "SEVEN", NULL, NULL, NULL},
   {"u09EEp", "EIGHT", NULL, NULL, NULL},
   {"u09EFp", "NINE", NULL, NULL, NULL},
   {"u09F0p", "9r", "A", NULL, NULL},
   {"u09F1p", "9r", "A", NULL, NULL},
   {"u09F2p", "RUPEEMARK", NULL, NULL, NULL},
   {"u09F3p", "RUPEESIGN", NULL, NULL, NULL},
   {"u09F4p", "CURRENCYNUMERATOR1", NULL, NULL, NULL},
   {"u09F5p", "CURRENCYNUMERATOR2", NULL, NULL, NULL},
   {"u09F6p", "CURRENCYNUMERATOR3", NULL, NULL, NULL},
   {"u09F7p", "CURRENCYNUMERATOR4", NULL, NULL, NULL},
   {"u09F8p", "CURRENCYNUMERATOR1LESSTHANTHEDENOMINATOR", NULL, NULL, NULL},
   {"u09F9p", "CURRENCYNUMERATOR16", NULL, NULL, NULL},
   {"u09FAp", "ISSHAR", NULL, NULL, NULL},
   {"u1740p", "A", NULL, NULL, NULL},
   {"u1741p", "i", NULL, NULL, NULL},
   {"u1742p", "u", NULL, NULL, NULL},
   {"u1743p", "k", "A", NULL, NULL},
   {"u1744p", "g", "A", NULL, NULL},
   {"u1745p", "N", "A", NULL, NULL},
   {"u1746p", "t", "A", NULL, NULL},
   {"u1747p", "d", "A", NULL, NULL},
   {"u1748p", "n", "A", NULL, NULL},
   {"u1749p", "p", "A", NULL, NULL},
   {"u174Ap", "b", "A", NULL, NULL},
   {"u174Bp", "m", "A", NULL, NULL},
   {"u174Cp", "j", "A", NULL, NULL},
   {"u174Dp", "r", "A", NULL, NULL},
   {"u174Ep", "l", "A", NULL, NULL},
   {"u174Fp", "w", "A", NULL, NULL},
   {"u1750p", "s", "A", NULL, NULL},
   {"u1751p", "h", "A", NULL, NULL},
   {"u1752p", "i", NULL, NULL, NULL},
   {"u1753p", "u", NULL, NULL, NULL},
   {"u13A0p", "A", NULL, NULL, NULL},
   {"u13A1p", "e", NULL, NULL, NULL},
   {"u13A2p", "i", NULL, NULL, NULL},
   {"u13A3p", "o", NULL, NULL, NULL},
   {"u13A4p", "u", NULL, NULL, NULL},
   {"u13A5p", "AMP~", NULL, NULL, NULL},
   {"u13A6p", "k", "A", NULL, NULL},
   {"u13A7p", "kh", "A", NULL, NULL},
   {"u13A8p", "k", "e", NULL, NULL},
   {"u13A9p", "k", "i", NULL, NULL},
   {"u13AAp", "k", "o", NULL, NULL},
   {"u13ABp", "k", "u", NULL, NULL},
   {"u13ACp", "k", "AMP~", NULL, NULL},
   {"u13ADp", "h", "A", NULL, NULL},
   {"u13AEp", "h", "e", NULL, NULL},
   {"u13AFp", "h", "i", NULL, NULL},
   {"u13B0p", "h", "o", NULL, NULL},
   {"u13B1p", "h", "u", NULL, NULL},
   {"u13B2p", "h", "AMP~", NULL, NULL},
   {"u13B3p", "l", "A", NULL, NULL},
   {"u13B4p", "l", "e", NULL, NULL},
   {"u13B5p", "l", "i", NULL, NULL},
   {"u13B6p", "l", "o", NULL, NULL},
   {"u13B7p", "l", "u", NULL, NULL},
   {"u13B8p", "l", "AMP~", NULL, NULL},
   {"u13B9p", "m", "A", NULL, NULL},
   {"u13BAp", "m", "e", NULL, NULL},
   {"u13BBp", "m", "i", NULL, NULL},
   {"u13BCp", "m", "o", NULL, NULL},
   {"u13BDp", "m", "u", NULL, NULL},
   {"u13BEp", "n", "A", NULL, NULL},
   {"u13BFp", "h", "n", "A", NULL},
   {"u13C0p", "nh", "A", NULL, NULL},
   {"u13C1p", "n", "e", NULL, NULL},
   {"u13C2p", "n", "i", NULL, NULL},
   {"u13C3p", "n", "o", NULL, NULL},
   {"u13C4p", "n", "u", NULL, NULL},
   {"u13C5p", "n", "AMP~", NULL, NULL},
   {"u13C6p", "kw", "A", NULL, NULL},
   {"u13C7p", "kw", "e", NULL, NULL},
   {"u13C8p", "kw", "i", NULL, NULL},
   {"u13C9p", "kw", "o", NULL, NULL},
   {"u13CAp", "kw", "u", NULL, NULL},
   {"u13CBp", "kw", "AMP~", NULL, NULL},
   {"u13CCp", "s", "A", NULL, NULL},
   {"u13CDp", "s", NULL, NULL, NULL},
   {"u13CEp", "s", "e", NULL, NULL},
   {"u13CFp", "s", "i", NULL, NULL},
   {"u13D0p", "s", "o", NULL, NULL},
   {"u13D1p", "s", "u", NULL, NULL},
   {"u13D2p", "s", "AMP~", NULL, NULL},
   {"u13D3p", "t", "A", NULL, NULL},
   {"u13D4p", "th", "A", NULL, NULL},
   {"u13D5p", "t", "e", NULL, NULL},
   {"u13D6p", "th", "e", NULL, NULL},
   {"u13D7p", "t", "i", NULL, NULL},
   {"u13D8p", "th", "i", NULL, NULL},
   {"u13D9p", "t", "o", NULL, NULL},
   {"u13DAp", "t", "u", NULL, NULL},
   {"u13DBp", "t", "AMP~", NULL, NULL},
   {"u13DCp", "tl", "A", NULL, NULL},
   {"u13DDp", "thl", "A", NULL, NULL},
   {"u13DEp", "thl", "e", NULL, NULL},
   {"u13DFp", "thl", "i", NULL, NULL},
   {"u13E0p", "thl", "o", NULL, NULL},
   {"u13E1p", "thl", "u", NULL, NULL},
   {"u13E2p", "thl", "AMP~", NULL, NULL},
   {"u13E3p", "ts", "A", NULL, NULL},
   {"u13E4p", "ts", "e", NULL, NULL},
   {"u13E5p", "ts", "i", NULL, NULL},
   {"u13E6p", "ts", "o", NULL, NULL},
   {"u13E7p", "ts", "u", NULL, NULL},
   {"u13E8p", "ts", "AMP~", NULL, NULL},
   {"u13E9p", "w", "A", NULL, NULL},
   {"u13EAp", "w", "e", NULL, NULL},
   {"u13EBp", "w", "i", NULL, NULL},
   {"u13ECp", "w", "o", NULL, NULL},
   {"u13EDp", "w", "u", NULL, NULL},
   {"u13EEp", "w", "AMP~", NULL, NULL},
   {"u13EFp", "j", "A", NULL, NULL},
   {"u13F0p", "j", "e", NULL, NULL},
   {"u13F1p", "j", "i", NULL, NULL},
   {"u13F2p", "j", "o", NULL, NULL},
   {"u13F3p", "j", "u", NULL, NULL},
   {"u13F4p", "j", "AMP~", NULL, NULL},
   {"u2C80p", "A", NULL, NULL, NULL},
   {"u2C81p", "A", NULL, NULL, NULL},
   {"u2C82p", "v", NULL, NULL, NULL},
   {"u2C83p", "v", NULL, NULL, NULL},
   {"u2C84p", "k", NULL, NULL, NULL},
   {"u2C85p", "k", NULL, NULL, NULL},
   {"u2C86p", "t", NULL, NULL, NULL},
   {"u2C87p", "t", NULL, NULL, NULL},
   {"u2C88p", "e", NULL, NULL, NULL},
   {"u2C89p", "e", NULL, NULL, NULL},
   {"u2C8Ap", "SIX", NULL, NULL, NULL},
   {"u2C8Bp", "SIX", NULL, NULL, NULL},
   {"u2C8Cp", "s", NULL, NULL, NULL},
   {"u2C8Dp", "s", NULL, NULL, NULL},
   {"u2C8Ep", "e:", NULL, NULL, NULL},
   {"u2C8Fp", "e:", NULL, NULL, NULL},
   {"u2C90p", "th", NULL, NULL, NULL},
   {"u2C91p", "th", NULL, NULL, NULL},
   {"u2C92p", "i", NULL, NULL, NULL},
   {"u2C93p", "i", NULL, NULL, NULL},
   {"u2C94p", "k", NULL, NULL, NULL},
   {"u2C95p", "k", NULL, NULL, NULL},
   {"u2C96p", "l", NULL, NULL, NULL},
   {"u2C97p", "l", NULL, NULL, NULL},
   {"u2C98p", "m", NULL, NULL, NULL},
   {"u2C99p", "m", NULL, NULL, NULL},
   {"u2C9Ap", "n", NULL, NULL, NULL},
   {"u2C9Bp", "n", NULL, NULL, NULL},
   {"u2C9Cp", "k", "s", NULL, NULL},
   {"u2C9Dp", "k", "s", NULL, NULL},
   {"u2C9Ep", "o", NULL, NULL, NULL},
   {"u2C9Fp", "o", NULL, NULL, NULL},
   {"u2CA0p", "p", NULL, NULL, NULL},
   {"u2CA1p", "p", NULL, NULL, NULL},
   {"u2CA2p", "r", NULL, NULL, NULL},
   {"u2CA3p", "r", NULL, NULL, NULL},
   {"u2CA4p", "s", NULL, NULL, NULL},
   {"u2CA5p", "s", NULL, NULL, NULL},
   {"u2CA6p", "t", NULL, NULL, NULL},
   {"u2CA7p", "t", NULL, NULL, NULL},
   {"u2CA8p", "u", NULL, NULL, NULL},
   {"u2CA9p", "u", NULL, NULL, NULL},
   {"u2CAAp", "ph", NULL, NULL, NULL},
   {"u2CABp", "ph", NULL, NULL, NULL},
   {"u2CACp", "kh", NULL, NULL, NULL},
   {"u2CADp", "kh", NULL, NULL, NULL},
   {"u2CAEp", "p", "s", NULL, NULL},
   {"u2CAFp", "p", "s", NULL, NULL},
   {"u2CB0p", "o:", NULL, NULL, NULL},
   {"u2CB1p", "o:", NULL, NULL, NULL},
   {"u2CB2p", "A", NULL, NULL, NULL},
   {"u2CB3p", "A", NULL, NULL, NULL},
   {"u2CB4p", "i", NULL, NULL, NULL},
   {"u2CB5p", "i", NULL, NULL, NULL},
   {"u2CB6p", "e", NULL, NULL, NULL},
   {"u2CB7p", "e", NULL, NULL, NULL},
   {"u2CB8p", "k", NULL, NULL, NULL},
   {"u2CB9p", "k", NULL, NULL, NULL},
   {"u2CBAp", "n", NULL, NULL, NULL},
   {"u2CBBp", "n", NULL, NULL, NULL},
   {"u2CBCp", "n", NULL, NULL, NULL},
   {"u2CBDp", "n", NULL, NULL, NULL},
   {"u2CBEp", "o:", NULL, NULL, NULL},
   {"u2CBFp", "o:", NULL, NULL, NULL},
   {"u2CC0p", "s", NULL, NULL, NULL},
   {"u2CC1p", "s", NULL, NULL, NULL},
   {"u2CC2p", "S", NULL, NULL, NULL},
   {"u2CC3p", "S", NULL, NULL, NULL},
   {"u2CC4p", "S", NULL, NULL, NULL},
   {"u2CC5p", "S", NULL, NULL, NULL},
   {"u2CC6p", "s", NULL, NULL, NULL},
   {"u2CC7p", "s", NULL, NULL, NULL},
   {"u2CC8p", "f", NULL, NULL, NULL},
   {"u2CC9p", "f", NULL, NULL, NULL},
   {"u2CCAp", "h", NULL, NULL, NULL},
   {"u2CCBp", "h", NULL, NULL, NULL},
   {"u2CCCp", "h", NULL, NULL, NULL},
   {"u2CCDp", "h", NULL, NULL, NULL},
   {"u2CCEp", "h", NULL, NULL, NULL},
   {"u2CCFp", "h", NULL, NULL, NULL},
   {"u2CD0p", "h", NULL, NULL, NULL},
   {"u2CD1p", "h", NULL, NULL, NULL},
   {"u2CD2p", "ei", NULL, NULL, NULL},
   {"u2CD3p", "ei", NULL, NULL, NULL},
   {"u2CD4p", "h", NULL, NULL, NULL},
   {"u2CD5p", "h", NULL, NULL, NULL},
   {"u2CD6p", "dZ", NULL, NULL, NULL},
   {"u2CD7p", "dZ", NULL, NULL, NULL},
   {"u2CD8p", "dZ", NULL, NULL, NULL},
   {"u2CD9p", "dZ", NULL, NULL, NULL},
   {"u2CDAp", "s", "h", NULL, NULL},
   {"u2CDBp", "s", "h", NULL, NULL},
   {"u2CDCp", "s", "h", NULL, NULL},
   {"u2CDDp", "s", "h", NULL, NULL},
   {"u2CDEp", "N", "i", NULL, NULL},
   {"u2CDFp", "N", "i", NULL, NULL},
   {"u2CE0p", "nj", NULL, NULL, NULL},
   {"u2CE1p", "nj", NULL, NULL, NULL},
   {"u2CE2p", "w", "au", NULL, NULL},
   {"u2CE3p", "w", "au", NULL, NULL},
   {"u2CE4p", "KAI", NULL, NULL, NULL},
   {"u2CE5p", "MI_RO", NULL, NULL, NULL},
   {"u2CE6p", "PI_RO", NULL, NULL, NULL},
   {"u2CE7p", "STAUROS", NULL, NULL, NULL},
   {"u2CE8p", "TAU_RO", NULL, NULL, NULL},
   {"u2CE9p", "KHI_RO", NULL, NULL, NULL},
   {"u2CEAp", "SHIMA_SIMA", NULL, NULL, NULL},
   {"u2CF9p", "FULLSTOP", NULL, NULL, NULL},
   {"u2CFAp", "DIRECT_QUESTIONMARK", NULL, NULL, NULL},
   {"u2CFBp", "INDIRECT_QUESTIONMARK", NULL, NULL, NULL},
   {"u2CFCp", "VERSE_DIVIDER", NULL, NULL, NULL},
   {"u2CFDp", "FRACTION_ONE_HALF", NULL, NULL, NULL},
   {"u2CFEp", "FULLSTOP", NULL, NULL, NULL},
   {"u0400p", "ie", NULL, NULL, NULL},
   {"u0401p", "io", NULL, NULL, NULL},
   {"u0402p", "d", "z}", NULL, NULL},
   {"u0403p", "d", "z}", NULL, NULL},
   {"u0404p", "ie", NULL, NULL, NULL},
   {"u0405p", "dz", NULL, NULL, NULL},
   {"u0406p", "i", NULL, NULL, NULL},
   {"u0407p", "j", NULL, NULL, NULL},
   {"u0408p", "j", NULL, NULL, NULL},
   {"u0409p", "lj", NULL, NULL, NULL},
   {"u040Ap", "n~", NULL, NULL, NULL},
   {"u040Bp", "tSj", NULL, NULL, NULL},
   {"u040Cp", "kj", NULL, NULL, NULL},
   {"u040Dp", "i", NULL, NULL, NULL},
   {"u040Ep", "u", NULL, NULL, NULL},
   {"u040Fp", "dZ", NULL, NULL, NULL},
   {"u0410p", "A", NULL, NULL, NULL},
   {"u0411p", "b", NULL, NULL, NULL},
   {"u0412p", "v", NULL, NULL, NULL},
   {"u0413p", "g", NULL, NULL, NULL},
   {"u0414p", "d", NULL, NULL, NULL},
   {"u0415p", "ie", NULL, NULL, NULL},
   {"u0416p", "Z", NULL, NULL, NULL},
   {"u0417p", "z", NULL, NULL, NULL},
   {"u0418p", "i", NULL, NULL, NULL},
   {"u0419p", "j", NULL, NULL, NULL},
   {"u041Ap", "k", NULL, NULL, NULL},
   {"u041Bp", "l", NULL, NULL, NULL},
   {"u041Cp", "m", NULL, NULL, NULL},
   {"u041Dp", "n", NULL, NULL, NULL},
   {"u041Ep", "GT", NULL, NULL, NULL},
   {"u041Fp", "p", NULL, NULL, NULL},
   {"u0420p", "r", NULL, NULL, NULL},
   {"u0421p", "s", NULL, NULL, NULL},
   {"u0422p", "t", NULL, NULL, NULL},
   {"u0423p", "u", NULL, NULL, NULL},
   {"u0424p", "f", NULL, NULL, NULL},
   {"u0425p", "x", NULL, NULL, NULL},
   {"u0426p", "ts", NULL, NULL, NULL},
   {"u0427p", "tSj", NULL, NULL, NULL},
   {"u0428p", "S", NULL, NULL, NULL},
   {"u0429p", "Sj", NULL, NULL, NULL},
   {"u042Ap", "HARDSIGN", NULL, NULL, NULL},
   {"u042Bp", "ix", NULL, NULL, NULL},
   {"u042Cp", "SOFTSIGN", NULL, NULL, NULL},
   {"u042Dp", "E", NULL, NULL, NULL},
   {"u042Ep", "u", NULL, NULL, NULL},
   {"u042Fp", "A", NULL, NULL, NULL},
   {"u0430p", "A", NULL, NULL, NULL},
   {"u0431p", "b", NULL, NULL, NULL},
   {"u0432p", "v", NULL, NULL, NULL},
   {"u0433p", "g", NULL, NULL, NULL},
   {"u0434p", "d", NULL, NULL, NULL},
   {"u0435p", "ie", NULL, NULL, NULL},
   {"u0436p", "Z", NULL, NULL, NULL},
   {"u0437p", "z", NULL, NULL, NULL},
   {"u0438p", "i", NULL, NULL, NULL},
   {"u0439p", "j", NULL, NULL, NULL},
   {"u043Ap", "k", NULL, NULL, NULL},
   {"u043Bp", "l", NULL, NULL, NULL},
   {"u043Cp", "m", NULL, NULL, NULL},
   {"u043Dp", "n", NULL, NULL, NULL},
   {"u043Ep", "GT", NULL, NULL, NULL},
   {"u043Fp", "p", NULL, NULL, NULL},
   {"u0440p", "r", NULL, NULL, NULL},
   {"u0441p", "s", NULL, NULL, NULL},
   {"u0442p", "t", NULL, NULL, NULL},
   {"u0443p", "u", NULL, NULL, NULL},
   {"u0444p", "f", NULL, NULL, NULL},
   {"u0445p", "x", NULL, NULL, NULL},
   {"u0446p", "ts", NULL, NULL, NULL},
   {"u0447p", "tSj", NULL, NULL, NULL},
   {"u0448p", "S", NULL, NULL, NULL},
   {"u0449p", "Sj", NULL, NULL, NULL},
   {"u044Ap", "HARDSIGN", NULL, NULL, NULL},
   {"u044Bp", "ix", NULL, NULL, NULL},
   {"u044Cp", "SOFTSIGN", NULL, NULL, NULL},
   {"u044Dp", "E", NULL, NULL, NULL},
   {"u044Ep", "u", NULL, NULL, NULL},
   {"u044Fp", "A", NULL, NULL, NULL},
   {"u0450p", "E", NULL, NULL, NULL},
   {"u0451p", "io", NULL, NULL, NULL},
   {"u0452p", "d", "Z}", NULL, NULL},
   {"u0453p", "d", "z}", NULL, NULL},
   {"u0454p", "ie", NULL, NULL, NULL},
   {"u0455p", "dz", NULL, NULL, NULL},
   {"u0456p", "i", NULL, NULL, NULL},
   {"u0457p", "j", NULL, NULL, NULL},
   {"u0458p", "j", NULL, NULL, NULL},
   {"u0459p", "lj", NULL, NULL, NULL},
   {"u045Ap", "n~", NULL, NULL, NULL},
   {"u045Bp", "tSj", NULL, NULL, NULL},
   {"u045Cp", "kj", NULL, NULL, NULL},
   {"u045Dp", "i", NULL, NULL, NULL},
   {"u045Ep", "u", NULL, NULL, NULL},
   {"u045Fp", "dZ", NULL, NULL, NULL},
   {"u0460p", "o", NULL, NULL, NULL},
   {"u0461p", "o", NULL, NULL, NULL},
   {"u0462p", "@", NULL, NULL, NULL},
   {"u0463p", "@", NULL, NULL, NULL},
   {"u0464p", "E", NULL, NULL, NULL},
   {"u0465p", "E", NULL, NULL, NULL},
   {"u0466p", "E~", NULL, NULL, NULL},
   {"u0467p", "E~", NULL, NULL, NULL},
   {"u0468p", "GT~", NULL, NULL, NULL},
   {"u0469p", "GT~", NULL, NULL, NULL},
   {"u046Ap", "E~", NULL, NULL, NULL},
   {"u046Bp", "E~", NULL, NULL, NULL},
   {"u046Cp", "GT~", NULL, NULL, NULL},
   {"u046Dp", "GT~", NULL, NULL, NULL},
   {"u046Ep", "INFORMALABBREVIATIONFOR1000PSI", NULL, NULL, NULL},
   {"u046Fp", "INFORMALABBREVIATIONFOR1000PSI", NULL, NULL, NULL},
   {"u0470p", "p", "s", NULL, NULL},
   {"u0471p", "p", "s", NULL, NULL},
   {"u0472p", "f", NULL, NULL, NULL},
   {"u0473p", "f", NULL, NULL, NULL},
   {"u0474p", "i", NULL, NULL, NULL},
   {"u0475p", "i", NULL, NULL, NULL},
   {"u0476p", "i", NULL, NULL, NULL},
   {"u0477p", "i", NULL, NULL, NULL},
   {"u0478p", "u", NULL, NULL, NULL},
   {"u0479p", "u", NULL, NULL, NULL},
   {"u047Ap", "o", NULL, NULL, NULL},
   {"u047Bp", "o", NULL, NULL, NULL},
   {"u047Cp", "o", NULL, NULL, NULL},
   {"u047Dp", "o", NULL, NULL, NULL},
   {"u047Ep", "o", "t]", NULL, NULL},
   {"u047Fp", "o", "t]", NULL, NULL},
   {"u0480p", "NINETY", NULL, NULL, NULL},
   {"u0481p", "NINETY", NULL, NULL, NULL},
   {"u0482p", "THOUSANDSIGN", NULL, NULL, NULL},
   {"u0483p", "TITLO", NULL, NULL, NULL},
   {"u0484p", "PALATALIZATION", NULL, NULL, NULL},
   {"u0485p", "DASIAPNEUMATA", NULL, NULL, NULL},
   {"u0486p", "PSILIPNEUMATA", NULL, NULL, NULL},
   {"u0488p", "HUNDREDTHOUSANDSIGN", NULL, NULL, NULL},
   {"u0489p", "MILLIONSIGN", NULL, NULL, NULL},
   {"u048Ap", "i", NULL, NULL, NULL},
   {"u048Bp", "i", NULL, NULL, NULL},
   {"u048Cp", "SEMISOFTSIGN", NULL, NULL, NULL},
   {"u048Dp", "SEMISOFTSIGN", NULL, NULL, NULL},
   {"u048Ep", "r", NULL, NULL, NULL},
   {"u048Fp", "r", NULL, NULL, NULL},
   {"u0490p", "g", NULL, NULL, NULL},
   {"u0491p", "g", NULL, NULL, NULL},
   {"u0492p", "g", NULL, NULL, NULL},
   {"u0493p", "g", NULL, NULL, NULL},
   {"u0494p", "g", NULL, NULL, NULL},
   {"u0495p", "g", NULL, NULL, NULL},
   {"u0496p", "Z", NULL, NULL, NULL},
   {"u0497p", "Z", NULL, NULL, NULL},
   {"u0498p", "z", NULL, NULL, NULL},
   {"u0499p", "z", NULL, NULL, NULL},
   {"u049Ap", "k", NULL, NULL, NULL},
   {"u049Bp", "k", NULL, NULL, NULL},
   {"u049Cp", "k", NULL, NULL, NULL},
   {"u049Dp", "k", NULL, NULL, NULL},
   {"u049Ep", "k", NULL, NULL, NULL},
   {"u049Fp", "k", NULL, NULL, NULL},
   {"u04A0p", "k", NULL, NULL, NULL},
   {"u04A1p", "k", NULL, NULL, NULL},
   {"u04A2p", "n", NULL, NULL, NULL},
   {"u04A3p", "n", NULL, NULL, NULL},
   {"u04A4p", "n", "g", NULL, NULL},
   {"u04A5p", "n", "g", NULL, NULL},
   {"u04A6p", "p", NULL, NULL, NULL},
   {"u04A7p", "p", NULL, NULL, NULL},
   {"u04A8p", "x", NULL, NULL, NULL},
   {"u04A9p", "x", NULL, NULL, NULL},
   {"u04AAp", "s", NULL, NULL, NULL},
   {"u04ABp", "s", NULL, NULL, NULL},
   {"u04ACp", "t", NULL, NULL, NULL},
   {"u04ADp", "t", NULL, NULL, NULL},
   {"u04AEp", "u", NULL, NULL, NULL},
   {"u04AFp", "u", NULL, NULL, NULL},
   {"u04B0p", "u", NULL, NULL, NULL},
   {"u04B1p", "u", NULL, NULL, NULL},
   {"u04B2p", "x", NULL, NULL, NULL},
   {"u04B3p", "x", NULL, NULL, NULL},
   {"u04B4p", "t", "t", "s", NULL},
   {"u04B5p", "t", "t", "s", NULL},
   {"u04B6p", "tSj", NULL, NULL, NULL},
   {"u04B7p", "tSj", NULL, NULL, NULL},
   {"u04B8p", "tSj", NULL, NULL, NULL},
   {"u04B9p", "tSj", NULL, NULL, NULL},
   {"u04BAp", "h", NULL, NULL, NULL},
   {"u04BBp", "h", NULL, NULL, NULL},
   {"u04BCp", "tSj", NULL, NULL, NULL},
   {"u04BDp", "tSj", NULL, NULL, NULL},
   {"u04BEp", "tSj", NULL, NULL, NULL},
   {"u04BFp", "tSj", NULL, NULL, NULL},
   {"u04C0p", "ASPIRATIONSIGN", NULL, NULL, NULL},
   {"u04C1p", "Z", NULL, NULL, NULL},
   {"u04C2p", "Z", NULL, NULL, NULL},
   {"u04C3p", "k", NULL, NULL, NULL},
   {"u04C4p", "k", NULL, NULL, NULL},
   {"u04C5p", "l", NULL, NULL, NULL},
   {"u04C6p", "l", NULL, NULL, NULL},
   {"u04C7p", "n", NULL, NULL, NULL},
   {"u04C8p", "n", NULL, NULL, NULL},
   {"u04C9p", "n", NULL, NULL, NULL},
   {"u04CAp", "n", NULL, NULL, NULL},
   {"u04CBp", "tSj", NULL, NULL, NULL},
   {"u04CCp", "tSj", NULL, NULL, NULL},
   {"u04CDp", "m", NULL, NULL, NULL},
   {"u04CEp", "m", NULL, NULL, NULL},
   {"u04D0p", "A", NULL, NULL, NULL},
   {"u04D1p", "A", NULL, NULL, NULL},
   {"u04D2p", "A", NULL, NULL, NULL},
   {"u04D3p", "A", NULL, NULL, NULL},
   {"u04D4p", "A", "ie", NULL, NULL},
   {"u04D5p", "A", "ie", NULL, NULL},
   {"u04D6p", "ie", NULL, NULL, NULL},
   {"u04D7p", "ie", NULL, NULL, NULL},
   {"u04D8p", "AMP", NULL, NULL, NULL},
   {"u04D9p", "AMP", NULL, NULL, NULL},
   {"u04DAp", "AMP", NULL, NULL, NULL},
   {"u04DBp", "AMP", NULL, NULL, NULL},
   {"u04DCp", "Z", NULL, NULL, NULL},
   {"u04DDp", "Z", NULL, NULL, NULL},
   {"u04DEp", "z", NULL, NULL, NULL},
   {"u04DFp", "z", NULL, NULL, NULL},
   {"u04E0p", "dz", NULL, NULL, NULL},
   {"u04E1p", "dz", NULL, NULL, NULL},
   {"u04E2p", "i:", NULL, NULL, NULL},
   {"u04E3p", "i:", NULL, NULL, NULL},
   {"u04E4p", "i", NULL, NULL, NULL},
   {"u04E5p", "i", NULL, NULL, NULL},
   {"u04E6p", "o", NULL, NULL, NULL},
   {"u04E7p", "o", NULL, NULL, NULL},
   {"u04E8p", "o", NULL, NULL, NULL},
   {"u04E9p", "o", NULL, NULL, NULL},
   {"u04EAp", "o", NULL, NULL, NULL},
   {"u04EBp", "o", NULL, NULL, NULL},
   {"u04ECp", "E", NULL, NULL, NULL},
   {"u04EDp", "E", NULL, NULL, NULL},
   {"u04EEp", "u:", NULL, NULL, NULL},
   {"u04EFp", "u:", NULL, NULL, NULL},
   {"u04F0p", "u", NULL, NULL, NULL},
   {"u04F1p", "u", NULL, NULL, NULL},
   {"u04F2p", "u", NULL, NULL, NULL},
   {"u04F3p", "u", NULL, NULL, NULL},
   {"u04F4p", "tSj", NULL, NULL, NULL},
   {"u04F5p", "tSj", NULL, NULL, NULL},
   {"u04F6p", "g", NULL, NULL, NULL},
   {"u04F7p", "g", NULL, NULL, NULL},
   {"u04F8p", "ix", NULL, NULL, NULL},
   {"u04F9p", "ix", NULL, NULL, NULL},
   {"u0901p", "CD", NULL, NULL, NULL},
   {"u0902p", "M", NULL, NULL, NULL},
   {"u0903p", "H", NULL, NULL, NULL},
   {"u0904p", "A", NULL, NULL, NULL},
   {"u0905p", "A", NULL, NULL, NULL},
   {"u0906p", "A:", NULL, NULL, NULL},
   {"u0907p", "i", NULL, NULL, NULL},
   {"u0908p", "i:", NULL, NULL, NULL},
   {"u0909p", "u", NULL, NULL, NULL},
   {"u090Ap", "u:", NULL, NULL, NULL},
   {"u090Bp", "9r=", NULL, NULL, NULL},
   {"u090Cp", "l=", NULL, NULL, NULL},
   {"u090Dp", "e", NULL, NULL, NULL},
   {"u090Ep", "e", NULL, NULL, NULL},
   {"u090Fp", "e", NULL, NULL, NULL},
   {"u0910p", "aI", NULL, NULL, NULL},
   {"u0911p", "o", NULL, NULL, NULL},
   {"u0912p", "o", NULL, NULL, NULL},
   {"u0913p", "o", NULL, NULL, NULL},
   {"u0914p", "aU", NULL, NULL, NULL},
   {"u0915p", "k", "A", NULL, NULL},
   {"u0916p", "kh", "A", NULL, NULL},
   {"u0917p", "g", "A", NULL, NULL},
   {"u0918p", "gh", "A", NULL, NULL},
   {"u0919p", "N", "A", NULL, NULL},
   {"u091Ap", "c", "A", NULL, NULL},
   {"u091Bp", "ch", "A", NULL, NULL},
   {"u091Cp", "J", "A", NULL, NULL},
   {"u091Dp", "Jh", "A", NULL, NULL},
   {"u091Ep", "n~", "A", NULL, NULL},
   {"u091Fp", "tr", "A", NULL, NULL},
   {"u0920p", "tR", "A", NULL, NULL},
   {"u0921p", "dr", "A", NULL, NULL},
   {"u0922p", "dR", "A", NULL, NULL},
   {"u0923p", "nr", "A", NULL, NULL},
   {"u0924p", "tB", "A", NULL, NULL},
   {"u0925p", "tBh", "A", NULL, NULL},
   {"u0926p", "dB", "A", NULL, NULL},
   {"u0927p", "dBh", "A", NULL, NULL},
   {"u0928p", "nB", "A", NULL, NULL},
   {"u0929p", "n", "A", NULL, NULL},
   {"u092Ap", "p", "A", NULL, NULL},
   {"u092Bp", "ph", "A", NULL, NULL},
   {"u092Cp", "b", "A", NULL, NULL},
   {"u092Dp", "bh", "A", NULL, NULL},
   {"u092Ep", "m", "A", NULL, NULL},
   {"u092Fp", "j", "A", NULL, NULL},
   {"u0930p", "9r", "A", NULL, NULL},
   {"u0931p", "9r", "A", NULL, NULL},
   {"u0932p", "l", "A", NULL, NULL},
   {"u0933p", "lr", "A", NULL, NULL},
   {"u0934p", "l", "A", NULL, NULL},
   {"u0935p", "v", "A", NULL, NULL},
   {"u0936p", "c}", "A", NULL, NULL},
   {"u0937p", "sr", "A", NULL, NULL},
   {"u0938p", "s", "A", NULL, NULL},
   {"u0939p", "hv", "A", NULL, NULL},
   {"u093Cp", "NUKTA", NULL, NULL, NULL},
   {"u093Dp", "AVAGRAHA", NULL, NULL, NULL},
   {"u093Ep", "A:", NULL, NULL, NULL},
   {"u093Fp", "i", NULL, NULL, NULL},
   {"u0940p", "i:", NULL, NULL, NULL},
   {"u0941p", "u", NULL, NULL, NULL},
   {"u0942p", "u:", NULL, NULL, NULL},
   {"u0943p", "9r=", NULL, NULL, NULL},
   {"u0944p", "rr=", NULL, NULL, NULL},
   {"u0945p", "e", NULL, NULL, NULL},
   {"u0946p", "e", NULL, NULL, NULL},
   {"u0947p", "e", NULL, NULL, NULL},
   {"u0948p", "aI", NULL, NULL, NULL},
   {"u0949p", "o", NULL, NULL, NULL},
   {"u094Ap", "o", NULL, NULL, NULL},
   {"u094Bp", "o", NULL, NULL, NULL},
   {"u094Cp", "aU", NULL, NULL, NULL},
   {"u094Dp", "P", NULL, NULL, NULL},
   {"u0950p", "OM", NULL, NULL, NULL},
   {"u0951p", "UDATTA", NULL, NULL, NULL},
   {"u0952p", "ADUDATTA", NULL, NULL, NULL},
   {"u0953p", "GRAVEACCENT", NULL, NULL, NULL},
   {"u0954p", "ACUTEACCENT", NULL, NULL, NULL},
   {"u0958p", "q", "A", NULL, NULL},
   {"u0959p", "x", "A", NULL, NULL},
   {"u095Ap", "G", "A", NULL, NULL},
   {"u095Bp", "z", "A", NULL, NULL},
   {"u095Cp", "rr", "A", NULL, NULL},
   {"u095Dp", "rrh", "A", NULL, NULL},
   {"u095Ep", "f", "A", NULL, NULL},
   {"u095Fp", "j", NULL, NULL, NULL},
   {"u0960p", "rr=", NULL, NULL, NULL},
   {"u0961p", "lr=", NULL, NULL, NULL},
   {"u0962p", "l=", NULL, NULL, NULL},
   {"u0963p", "l=", NULL, NULL, NULL},
   {"u0964p", "ASTERISK", NULL, NULL, NULL},
   {"u0965p", "**", NULL, NULL, NULL},
   {"u0966p", "ZERO", NULL, NULL, NULL},
   {"u0967p", "ONE", NULL, NULL, NULL},
   {"u0968p", "TWO", NULL, NULL, NULL},
   {"u0969p", "THREE", NULL, NULL, NULL},
   {"u096Ap", "FOUR", NULL, NULL, NULL},
   {"u096Bp", "FIVE", NULL, NULL, NULL},
   {"u096Cp", "SIX", NULL, NULL, NULL},
   {"u096Dp", "SEVEN", NULL, NULL, NULL},
   {"u096Ep", "EIGHT", NULL, NULL, NULL},
   {"u096Fp", "NINE", NULL, NULL, NULL},
   {"u0970p", "ABBREVIATION", NULL, NULL, NULL},
   {"u097Dp", "QM", NULL, NULL, NULL},
   {"u1200p", "h", "3", NULL, NULL},
   {"u1201p", "h", "u", NULL, NULL},
   {"u1202p", "h", "i", NULL, NULL},
   {"u1203p", "h", "A", NULL, NULL},
   {"u1204p", "h", "e", NULL, NULL},
   {"u1205p", "h", "AMP", NULL, NULL},
   {"u1206p", "h", "o", NULL, NULL},
   {"u1207p", "h", "o", "3", NULL},
   {"u1208p", "l", "3", NULL, NULL},
   {"u1209p", "l", "u", NULL, NULL},
   {"u120Ap", "l", "i", NULL, NULL},
   {"u120Bp", "l", "A", NULL, NULL},
   {"u120Cp", "l", "e", NULL, NULL},
   {"u120Dp", "l", "AMP", NULL, NULL},
   {"u120Ep", "l", "o", NULL, NULL},
   {"u120Fp", "l", "u", "3", NULL},
   {"u1210p", "h", "3", NULL, NULL},
   {"u1211p", "h", "u", NULL, NULL},
   {"u1212p", "h", "i", NULL, NULL},
   {"u1213p", "h", "A", NULL, NULL},
   {"u1214p", "h", "e", NULL, NULL},
   {"u1215p", "h", "AMP", NULL, NULL},
   {"u1216p", "h", "o", NULL, NULL},
   {"u1217p", "h", "u", "3", NULL},
   {"u1218p", "m", "3", NULL, NULL},
   {"u1219p", "m", "u", NULL, NULL},
   {"u121Ap", "m", "i", NULL, NULL},
   {"u121Bp", "m", "A", NULL, NULL},
   {"u121Cp", "m", "e", NULL, NULL},
   {"u121Dp", "m", "AMP", NULL, NULL},
   {"u121Ep", "m", "o", NULL, NULL},
   {"u121Fp", "m", "u", "3", NULL},
   {"u1220p", "s", "3", NULL, NULL},
   {"u1221p", "s", "u", NULL, NULL},
   {"u1222p", "s", "i", NULL, NULL},
   {"u1223p", "s", "A", NULL, NULL},
   {"u1224p", "s", "e", NULL, NULL},
   {"u1225p", "s", "AMP", NULL, NULL},
   {"u1226p", "s", "o", NULL, NULL},
   {"u1227p", "s", "u", "3", NULL},
   {"u1228p", "9r", "3", NULL, NULL},
   {"u1229p", "9r", "u", NULL, NULL},
   {"u122Ap", "9r", "i", NULL, NULL},
   {"u122Bp", "9r", "A", NULL, NULL},
   {"u122Cp", "9r", "e", NULL, NULL},
   {"u122Dp", "9r", "AMP", NULL, NULL},
   {"u122Ep", "9r", "o", NULL, NULL},
   {"u122Fp", "9r", "u", "3", NULL},
   {"u1230p", "s", "3", NULL, NULL},
   {"u1231p", "s", "u", NULL, NULL},
   {"u1232p", "s", "i", NULL, NULL},
   {"u1233p", "s", "A", NULL, NULL},
   {"u1234p", "s", "e", NULL, NULL},
   {"u1235p", "s", "AMP", NULL, NULL},
   {"u1236p", "s", "o", NULL, NULL},
   {"u1237p", "s", "u", "3", NULL},
   {"u1238p", "S", "3", NULL, NULL},
   {"u1239p", "S", "u", NULL, NULL},
   {"u123Ap", "S", "i", NULL, NULL},
   {"u123Bp", "S", "A", NULL, NULL},
   {"u123Cp", "S", "e", NULL, NULL},
   {"u123Dp", "S", "AMP", NULL, NULL},
   {"u123Ep", "S", "o", NULL, NULL},
   {"u123Fp", "S", "u", "3", NULL},
   {"u1240p", "kGT", "3", NULL, NULL},
   {"u1241p", "kGT", "u", NULL, NULL},
   {"u1242p", "kGT", "i", NULL, NULL},
   {"u1243p", "kGT", "A", NULL, NULL},
   {"u1244p", "kGT", "e", NULL, NULL},
   {"u1245p", "kGT", "AMP", NULL, NULL},
   {"u1246p", "kGT", "o", NULL, NULL},
   {"u1247p", "kGT", "o", "3", NULL},
   {"u1248p", "kGT", "u", "3", NULL},
   {"u124Ap", "kGT", "ui", NULL, NULL},
   {"u124Bp", "kGT", "ua", NULL, NULL},
   {"u124Cp", "kGT", "u", "e", NULL},
   {"u124Dp", "kGT", "uAMP", NULL, NULL},
   {"u1250p", "kGT", "h", "3", NULL},
   {"u1251p", "kGT", "h", "u", NULL},
   {"u1252p", "kGT", "h", "i", NULL},
   {"u1253p", "kGT", "h", "A", NULL},
   {"u1254p", "kGT", "h", "e", NULL},
   {"u1255p", "kGT", "h", "AMP", NULL},
   {"u1256p", "kGT", "h", "o", NULL},
   {"u125Ap", "kGT", "h", "ui", NULL},
   {"u125Bp", "kGT", "h", "ua", NULL},
   {"u125Cp", "kGT", "h", "u", NULL},
   {"u125Dp", "kGT", "h", "uAMP", NULL},
   {"u1260p", "b", "3", NULL, NULL},
   {"u1261p", "b", "u", NULL, NULL},
   {"u1262p", "b", "i", NULL, NULL},
   {"u1263p", "b", "A", NULL, NULL},
   {"u1264p", "b", "e", NULL, NULL},
   {"u1265p", "b", "AMP", NULL, NULL},
   {"u1266p", "b", "o", NULL, NULL},
   {"u1267p", "b", "u", "3", NULL},
   {"u1268p", "v", "3", NULL, NULL},
   {"u1269p", "v", "u", NULL, NULL},
   {"u126Ap", "v", "i", NULL, NULL},
   {"u126Bp", "v", "A", NULL, NULL},
   {"u126Cp", "v", "e", NULL, NULL},
   {"u126Dp", "v", "AMP", NULL, NULL},
   {"u126Ep", "v", "o", NULL, NULL},
   {"u126Fp", "v", "u", "3", NULL},
   {"u1270p", "t]", "3", NULL, NULL},
   {"u1271p", "t]", "u", NULL, NULL},
   {"u1272p", "t]", "i", NULL, NULL},
   {"u1273p", "t]", "A", NULL, NULL},
   {"u1274p", "t]", "e", NULL, NULL},
   {"u1275p", "t]", "AMP", NULL, NULL},
   {"u1276p", "t]", "o", NULL, NULL},
   {"u1277p", "t]", "u", "3", NULL},
   {"u1278p", "tS", "3", NULL, NULL},
   {"u1279p", "tS", "u", NULL, NULL},
   {"u127Ap", "tS", "i", NULL, NULL},
   {"u127Bp", "tS", "A", NULL, NULL},
   {"u127Cp", "tS", "e", NULL, NULL},
   {"u127Dp", "tS", "AMP", NULL, NULL},
   {"u127Ep", "tS", "o", NULL, NULL},
   {"u127Fp", "tS", "u", "3", NULL},
   {"u1280p", "h", "3", NULL, NULL},
   {"u1281p", "h", "u", NULL, NULL},
   {"u1282p", "h", "i", NULL, NULL},
   {"u1283p", "h", "A", NULL, NULL},
   {"u1284p", "h", "e", NULL, NULL},
   {"u1285p", "h", "AMP", NULL, NULL},
   {"u1286p", "h", "o", NULL, NULL},
   {"u1287p", "h", "o", "3", NULL},
   {"u1288p", "h", "u", "3", NULL},
   {"u128Ap", "h", "ui", NULL, NULL},
   {"u128Bp", "h", "ua", NULL, NULL},
   {"u128Cp", "h", "u", "e", NULL},
   {"u128Dp", "h", "uAMP", NULL, NULL},
   {"u1290p", "n", "3", NULL, NULL},
   {"u1291p", "n", "u", NULL, NULL},
   {"u1292p", "n", "i", NULL, NULL},
   {"u1293p", "n", "A", NULL, NULL},
   {"u1294p", "n", "e", NULL, NULL},
   {"u1295p", "n", "AMP", NULL, NULL},
   {"u1296p", "n", "o", NULL, NULL},
   {"u1297p", "n", "u", "3", NULL},
   {"u1298p", "n~", "3", NULL, NULL},
   {"u1299p", "n~", "u", NULL, NULL},
   {"u129Ap", "n~", "i", NULL, NULL},
   {"u129Bp", "n~", "A", NULL, NULL},
   {"u129Cp", "n~", "e", NULL, NULL},
   {"u129Dp", "n~", "AMP", NULL, NULL},
   {"u129Ep", "n~", "o", NULL, NULL},
   {"u129Fp", "n~", "u", "3", NULL},
   {"u12A0p", "QM", "3", NULL, NULL},
   {"u12A1p", "QM", "u", NULL, NULL},
   {"u12A2p", "QM", "i", NULL, NULL},
   {"u12A3p", "QM", "A", NULL, NULL},
   {"u12A4p", "QM", "e", NULL, NULL},
   {"u12A5p", "QM", "AMP", NULL, NULL},
   {"u12A6p", "QM", "o", NULL, NULL},
   {"u12A7p", "QM", "u", "3", NULL},
   {"u12A8p", "k", "3", NULL, NULL},
   {"u12A9p", "k", "u", NULL, NULL},
   {"u12AAp", "k", "i", NULL, NULL},
   {"u12ABp", "k", "A", NULL, NULL},
   {"u12ACp", "k", "e", NULL, NULL},
   {"u12ADp", "k", "AMP", NULL, NULL},
   {"u12AEp", "k", "o", NULL, NULL},
   {"u12AFp", "k", "o", "3", NULL},
   {"u12B0p", "k", "u", "3", NULL},
   {"u12B2p", "k", "ui", NULL, NULL},
   {"u12B3p", "k", "ua", NULL, NULL},
   {"u12B4p", "k", "u", "e", NULL},
   {"u12B5p", "k", "uAMP", NULL, NULL},
   {"u12B8p", "h", "3", NULL, NULL},
   {"u12B9p", "h", "u", NULL, NULL},
   {"u12BAp", "h", "i", NULL, NULL},
   {"u12BBp", "h", "A", NULL, NULL},
   {"u12BCp", "h", "e", NULL, NULL},
   {"u12BDp", "h", "AMP", NULL, NULL},
   {"u12BEp", "h", "o", NULL, NULL},
   {"u12C0p", "h", "u", "3", NULL},
   {"u12C2p", "h", "ui", NULL, NULL},
   {"u12C3p", "h", "ua", NULL, NULL},
   {"u12C4p", "h", "u", "e", NULL},
   {"u12C5p", "h", "uAMP", NULL, NULL},
   {"u12C8p", "w", "3", NULL, NULL},
   {"u12C9p", "w", "u", NULL, NULL},
   {"u12CAp", "w", "i", NULL, NULL},
   {"u12CBp", "w", "A", NULL, NULL},
   {"u12CCp", "w", "e", NULL, NULL},
   {"u12CDp", "w", "AMP", NULL, NULL},
   {"u12CEp", "w", "o", NULL, NULL},
   {"u12CFp", "w", "o", "3", NULL},
   {"u12D0p", "QM", "3", NULL, NULL},
   {"u12D1p", "QM", "u", NULL, NULL},
   {"u12D2p", "QM", "i", NULL, NULL},
   {"u12D3p", "QM", "A", NULL, NULL},
   {"u12D4p", "QM", "e", NULL, NULL},
   {"u12D5p", "QM", "AMP", NULL, NULL},
   {"u12D6p", "QM", "o", NULL, NULL},
   {"u12D8p", "z", "3", NULL, NULL},
   {"u12D9p", "z", "u", NULL, NULL},
   {"u12DAp", "z", "i", NULL, NULL},
   {"u12DBp", "z", "A", NULL, NULL},
   {"u12DCp", "z", "e", NULL, NULL},
   {"u12DDp", "z", "AMP", NULL, NULL},
   {"u12DEp", "z", "o", NULL, NULL},
   {"u12DFp", "z", "u", "3", NULL},
   {"u12E0p", "Z", "3", NULL, NULL},
   {"u12E1p", "Z", "u", NULL, NULL},
   {"u12E2p", "Z", "i", NULL, NULL},
   {"u12E3p", "Z", "A", NULL, NULL},
   {"u12E4p", "Z", "e", NULL, NULL},
   {"u12E5p", "Z", "AMP", NULL, NULL},
   {"u12E6p", "Z", "o", NULL, NULL},
   {"u12E7p", "Z", "u", "3", NULL},
   {"u12E8p", "j", "3", NULL, NULL},
   {"u12E9p", "j", "u", NULL, NULL},
   {"u12EAp", "j", "i", NULL, NULL},
   {"u12EBp", "j", "A", NULL, NULL},
   {"u12ECp", "j", "e", NULL, NULL},
   {"u12EDp", "j", "AMP", NULL, NULL},
   {"u12EEp", "j", "o", NULL, NULL},
   {"u12EFp", "j", "o", "3", NULL},
   {"u12F0p", "d", "3", NULL, NULL},
   {"u12F1p", "d]", "u", NULL, NULL},
   {"u12F2p", "d]", "i", NULL, NULL},
   {"u12F3p", "d]", "A", NULL, NULL},
   {"u12F4p", "d]", "e", NULL, NULL},
   {"u12F5p", "d]", "AMP", NULL, NULL},
   {"u12F6p", "d]", "o", NULL, NULL},
   {"u12F7p", "d]", "u", "3", NULL},
   {"u12F8p", "d", "d", "3", NULL},
   {"u12F9p", "d", "d", "u", NULL},
   {"u12FAp", "d", "d", "i", NULL},
   {"u12FBp", "d", "d", "A", NULL},
   {"u12FCp", "d", "d", "e", NULL},
   {"u12FDp", "d", "d", "AMP", NULL},
   {"u12FEp", "d", "d", "o", NULL},
   {"u12FFp", "d", "d", "u", NULL},
   {"u1300p", "dZ", "3", NULL, NULL},
   {"u1301p", "dZ", "u", NULL, NULL},
   {"u1302p", "dZ", "i", NULL, NULL},
   {"u1303p", "dZ", "A", NULL, NULL},
   {"u1304p", "dZ", "e", NULL, NULL},
   {"u1305p", "dZ", "AMP", NULL, NULL},
   {"u1306p", "dZ", "o", NULL, NULL},
   {"u1307p", "dZ", "u", "3", NULL},
   {"u1308p", "g", "3", NULL, NULL},
   {"u1309p", "g", "u", NULL, NULL},
   {"u130Ap", "g", "i", NULL, NULL},
   {"u130Bp", "g", "A", NULL, NULL},
   {"u130Cp", "g", "e", NULL, NULL},
   {"u130Dp", "g", "AMP", NULL, NULL},
   {"u130Ep", "g", "o", NULL, NULL},
   {"u130Fp", "g", "o", "3", NULL},
   {"u1310p", "g", "u", "3", NULL},
   {"u1312p", "g", "ui", NULL, NULL},
   {"u1313p", "g", "ua", NULL, NULL},
   {"u1314p", "g", "u", "e", NULL},
   {"u1315p", "g", "uAMP", NULL, NULL},
   {"u1318p", "g", "g", "3", NULL},
   {"u1319p", "g", "g", "u", NULL},
   {"u131Ap", "g", "g", "i", NULL},
   {"u131Bp", "g", "g", "A", NULL},
   {"u131Cp", "g", "g", "e", NULL},
   {"u131Dp", "g", "g", "AMP", NULL},
   {"u131Ep", "g", "g", "o", NULL},
   {"u131Fp", "g", "g", "ua", NULL},
   {"u1320p", "tBGT", "3", NULL, NULL},
   {"u1321p", "tBGT", "u", NULL, NULL},
   {"u1322p", "tBGT", "i", NULL, NULL},
   {"u1323p", "tBGT", "A", NULL, NULL},
   {"u1324p", "tBGT", "e", NULL, NULL},
   {"u1325p", "tBGT", "AMP", NULL, NULL},
   {"u1326p", "tBGT", "o", NULL, NULL},
   {"u1327p", "tBGT", "u", "3", NULL},
   {"u1328p", "tSGT", "3", NULL, NULL},
   {"u1329p", "tSGT", "u", NULL, NULL},
   {"u132Ap", "tSGT", "i", NULL, NULL},
   {"u132Bp", "tSGT", "A", NULL, NULL},
   {"u132Cp", "tSGT", "e", NULL, NULL},
   {"u132Dp", "tSGT", "AMP", NULL, NULL},
   {"u132Ep", "tSGT", "o", NULL, NULL},
   {"u132Fp", "tSGT", "u", "3", NULL},
   {"u1330p", "pGT", "3", NULL, NULL},
   {"u1331p", "pGT", "u", NULL, NULL},
   {"u1332p", "pGT", "i", NULL, NULL},
   {"u1333p", "pGT", "A", NULL, NULL},
   {"u1334p", "pGT", "e", NULL, NULL},
   {"u1335p", "pGT", "AMP", NULL, NULL},
   {"u1336p", "pGT", "o", NULL, NULL},
   {"u1337p", "pGT", "u", "3", NULL},
   {"u1338p", "ts", "3", NULL, NULL},
   {"u1339p", "ts", "u", NULL, NULL},
   {"u133Ap", "ts", "i", NULL, NULL},
   {"u133Bp", "ts", "A", NULL, NULL},
   {"u133Cp", "ts", "e", NULL, NULL},
   {"u133Dp", "ts", "AMP", NULL, NULL},
   {"u133Ep", "ts", "o", NULL, NULL},
   {"u133Fp", "ts", "u", "3", NULL},
   {"u1340p", "ts", "3", NULL, NULL},
   {"u1341p", "ts", "u", NULL, NULL},
   {"u1342p", "ts", "i", NULL, NULL},
   {"u1343p", "ts", "A", NULL, NULL},
   {"u1344p", "ts", "e", NULL, NULL},
   {"u1345p", "ts", "AMP", NULL, NULL},
   {"u1346p", "ts", "o", NULL, NULL},
   {"u1347p", "ts", "u", "3", NULL},
   {"u1348p", "f", "3", NULL, NULL},
   {"u1349p", "f", "u", NULL, NULL},
   {"u134Ap", "f", "i", NULL, NULL},
   {"u134Bp", "f", "A", NULL, NULL},
   {"u134Cp", "f", "e", NULL, NULL},
   {"u134Dp", "f", "AMP", NULL, NULL},
   {"u134Ep", "f", "o", NULL, NULL},
   {"u134Fp", "f", "u", "3", NULL},
   {"u1350p", "p", "3", NULL, NULL},
   {"u1351p", "p", "u", NULL, NULL},
   {"u1352p", "p", "i", NULL, NULL},
   {"u1353p", "p", "A", NULL, NULL},
   {"u1354p", "p", "e", NULL, NULL},
   {"u1355p", "p", "AMP", NULL, NULL},
   {"u1356p", "p", "o", NULL, NULL},
   {"u1357p", "p", "u", "3", NULL},
   {"u1358p", "9rj", "a", NULL, NULL},
   {"u1359p", "mj", "a", NULL, NULL},
   {"u135Ap", "fj", "a", NULL, NULL},
   {"u135Fp", "GEMINATIONMARK", NULL, NULL, NULL},
   {"u1360p", "SECTIONMARK", NULL, NULL, NULL},
   {"u1361p", "WORDSPACE", NULL, NULL, NULL},
   {"u1362p", "FULLSTOP", NULL, NULL, NULL},
   {"u1363p", "COMMA", NULL, NULL, NULL},
   {"u1364p", "SEMICOLON", NULL, NULL, NULL},
   {"u1365p", "COLON", NULL, NULL, NULL},
   {"u1366p", "PREFACECOLON", NULL, NULL, NULL},
   {"u1367p", "QUESTIONMARK", NULL, NULL, NULL},
   {"u1368p", "PARAGRAPHSEPARATOR", NULL, NULL, NULL},
   {"u1369p", "ONE", NULL, NULL, NULL},
   {"u136Ap", "TWO", NULL, NULL, NULL},
   {"u136Bp", "THREE", NULL, NULL, NULL},
   {"u136Cp", "FOUR", NULL, NULL, NULL},
   {"u136Dp", "FIVE", NULL, NULL, NULL},
   {"u136Ep", "SIX", NULL, NULL, NULL},
   {"u136Fp", "SEVEN", NULL, NULL, NULL},
   {"u1370p", "EIGHT", NULL, NULL, NULL},
   {"u1371p", "NINE", NULL, NULL, NULL},
   {"u1372p", "TEN", NULL, NULL, NULL},
   {"u1373p", "TWENTY", NULL, NULL, NULL},
   {"u1374p", "THIRTY", NULL, NULL, NULL},
   {"u1375p", "FORTY", NULL, NULL, NULL},
   {"u1376p", "FIFTY", NULL, NULL, NULL},
   {"u1377p", "SIXTY", NULL, NULL, NULL},
   {"u1378p", "SEVENTY", NULL, NULL, NULL},
   {"u1379p", "EIGHT", NULL, NULL, NULL},
   {"u137Ap", "NINETY", NULL, NULL, NULL},
   {"u137Bp", "HUNDRED", NULL, NULL, NULL},
   {"u137Cp", "TENTHOUSAND", NULL, NULL, NULL},
   {"u1380p", "mw", "3", NULL, NULL},
   {"u1381p", "mw", "i", NULL, NULL},
   {"u1382p", "mw", "3", NULL, NULL},
   {"u1383p", "mw", "AMP", NULL, NULL},
   {"u1384p", "bw", "3", NULL, NULL},
   {"u1385p", "bw", "i", NULL, NULL},
   {"u1386p", "bw", "e", NULL, NULL},
   {"u1387p", "bw", "AMP", NULL, NULL},
   {"u1388p", "fw", "3", NULL, NULL},
   {"u1389p", "fw", "i", NULL, NULL},
   {"u138Ap", "fw", "e", NULL, NULL},
   {"u138Bp", "fw", "AMP", NULL, NULL},
   {"u138Cp", "pw", "3", NULL, NULL},
   {"u138Dp", "pw", "i", NULL, NULL},
   {"u138Ep", "pw", "e", NULL, NULL},
   {"u138Fp", "pw", "AMP", NULL, NULL},
   {"u1390p", "YIZET", NULL, NULL, NULL},
   {"u1391p", "DERET", NULL, NULL, NULL},
   {"u1392p", "RIKRIK", NULL, NULL, NULL},
   {"u1393p", "SHORTRIKRIK", NULL, NULL, NULL},
   {"u1394p", "DIFAT", NULL, NULL, NULL},
   {"u1395p", "KENAT", NULL, NULL, NULL},
   {"u1396p", "CHIRET", NULL, NULL, NULL},
   {"u1397p", "HIDET", NULL, NULL, NULL},
   {"u1398p", "DERET-HIDET", NULL, NULL, NULL},
   {"u1399p", "HURT", NULL, NULL, NULL},
   {"u2D80p", "l", "o", "3", NULL},
   {"u2D81p", "m", "o", "3", NULL},
   {"u2D82p", "9r", "o", "3", NULL},
   {"u2D83p", "s", "o", "3", NULL},
   {"u2D84p", "S", "o", "3", NULL},
   {"u2D85p", "b", "o", "3", NULL},
   {"u2D86p", "tB", "o", "3", NULL},
   {"u2D87p", "tS", "o", "3", NULL},
   {"u2D88p", "n", "o", "3", NULL},
   {"u2D89p", "n~", "o", "3", NULL},
   {"u2D8Ap", "QM", "o", "3", NULL},
   {"u2D8Bp", "z", "o", "3", NULL},
   {"u2D8Cp", "dB", "o", "3", NULL},
   {"u2D8Dp", "dr", "o", "3", NULL},
   {"u2D8Ep", "j", "o", "3", NULL},
   {"u2D8Fp", "tGT", "o", "3", NULL},
   {"u2D90p", "tSGT", "o", "3", NULL},
   {"u2D91p", "pGT", "o", "3", NULL},
   {"u2D92p", "p", "o", "3", NULL},
   {"u2D93p", "gr", "u", "3", NULL},
   {"u2D94p", "gr", "ui", NULL, NULL},
   {"u2D95p", "gr", "u", "e", NULL},
   {"u2D96p", "gr", "uAMP", NULL, NULL},
   {"u2DA0p", "s", "s", "3", NULL},
   {"u2DA1p", "s", "s", "u", NULL},
   {"u2DA2p", "s", "s", "i", NULL},
   {"u2DA3p", "s", "s", "A", NULL},
   {"u2DA4p", "s", "s", "e", NULL},
   {"u2DA5p", "s", "s", "AMP", NULL},
   {"u2DA6p", "s", "s", "o", NULL},
   {"u2DA8p", "tS", "tS", "3", NULL},
   {"u2DA9p", "tS", "tS", "u", NULL},
   {"u2DAAp", "tS", "tS", "i", NULL},
   {"u2DABp", "tS", "tS", "A", NULL},
   {"u2DACp", "tS", "tS", "e", NULL},
   {"u2DADp", "tS", "tS", "AMP", NULL},
   {"u2DAEp", "tS", "tS", "o", NULL},
   {"u2DB0p", "z", "z", "3", NULL},
   {"u2DB1p", "z", "z", "u", NULL},
   {"u2DB2p", "z", "z", "i", NULL},
   {"u2DB3p", "z", "z", "A", NULL},
   {"u2DB4p", "z", "z", "e", NULL},
   {"u2DB5p", "z", "z", "AMP", NULL},
   {"u2DB6p", "z", "z", "o", NULL},
   {"u2DB8p", "tS", "tSh", "3", NULL},
   {"u2DB9p", "tS", "tSh", "u", NULL},
   {"u2DBAp", "tS", "tSh", "i", NULL},
   {"u2DBBp", "tS", "tSh", "A", NULL},
   {"u2DBCp", "tS", "tSh", "e", NULL},
   {"u2DBDp", "tS", "tSh", "AMP", NULL},
   {"u2DBEp", "tS", "tSh", "o", NULL},
   {"u2DC0p", "kGTj", "3", NULL, NULL},
   {"u2DC1p", "kGTj", "u", NULL, NULL},
   {"u2DC2p", "kGTj", "i", NULL, NULL},
   {"u2DC3p", "kGTj", "A", NULL, NULL},
   {"u2DC4p", "kGTj", "e", NULL, NULL},
   {"u2DC5p", "kGTj", "AMP", NULL, NULL},
   {"u2DC6p", "kGTj", "o", NULL, NULL},
   {"u2DC8p", "kj", "3", NULL, NULL},
   {"u2DC9p", "kj", "u", NULL, NULL},
   {"u2DCAp", "kj", "i", NULL, NULL},
   {"u2DCBp", "kj", "A", NULL, NULL},
   {"u2DCCp", "kj", "e", NULL, NULL},
   {"u2DCEp", "kj", "AMP", NULL, NULL},
   {"u2DD0p", "kj", "o", NULL, NULL},
   {"u2DD1p", "sj", "3", NULL, NULL},
   {"u2DD2p", "sj", "u", NULL, NULL},
   {"u2DD3p", "sj", "i", NULL, NULL},
   {"u2DD4p", "sj", "A", NULL, NULL},
   {"u2DD5p", "sj", "AMP", NULL, NULL},
   {"u2DD6p", "sj", "o", NULL, NULL},
   {"u2DD8p", "gj", "3", NULL, NULL},
   {"u2DD9p", "gj", "u", NULL, NULL},
   {"u2DDAp", "gj", "i", NULL, NULL},
   {"u2DDBp", "gj", "A", NULL, NULL},
   {"u2DDCp", "gj", "3", NULL, NULL},
   {"u2DDDp", "gj", "AMP", NULL, NULL},
   {"u2DDEp", "gj", "o", NULL, NULL},
   {"u10A0p", "A", NULL, NULL, NULL},
   {"u10A1p", "b", NULL, NULL, NULL},
   {"u10A2p", "g", NULL, NULL, NULL},
   {"u10A3p", "d", NULL, NULL, NULL},
   {"u10A4p", "E", NULL, NULL, NULL},
   {"u10A5p", "v", NULL, NULL, NULL},
   {"u10A6p", "z", NULL, NULL, NULL},
   {"u10A7p", "th", NULL, NULL, NULL},
   {"u10A8p", "i", NULL, NULL, NULL},
   {"u10A9p", "kGT", NULL, NULL, NULL},
   {"u10AAp", "l", NULL, NULL, NULL},
   {"u10ABp", "m", NULL, NULL, NULL},
   {"u10ACp", "n", NULL, NULL, NULL},
   {"u10ADp", "o", NULL, NULL, NULL},
   {"u10AEp", "pGT", NULL, NULL, NULL},
   {"u10AFp", "Z", NULL, NULL, NULL},
   {"u10B0p", "v", NULL, NULL, NULL},
   {"u10B1p", "s", NULL, NULL, NULL},
   {"u10B2p", "tGT", NULL, NULL, NULL},
   {"u10B3p", "u", NULL, NULL, NULL},
   {"u10B4p", "ph", NULL, NULL, NULL},
   {"u10B5p", "kh", NULL, NULL, NULL},
   {"u10B6p", "G", NULL, NULL, NULL},
   {"u10B7p", "qGT", NULL, NULL, NULL},
   {"u10B8p", "S", NULL, NULL, NULL},
   {"u10B9p", "tS", NULL, NULL, NULL},
   {"u10BAp", "k", NULL, NULL, NULL},
   {"u10BBp", "dz", NULL, NULL, NULL},
   {"u10BCp", "tsGT", NULL, NULL, NULL},
   {"u10BDp", "tSGT", NULL, NULL, NULL},
   {"u10BEp", "x", NULL, NULL, NULL},
   {"u10BFp", "dZ", NULL, NULL, NULL},
   {"u10C0p", "h", NULL, NULL, NULL},
   {"u10C1p", "ej", NULL, NULL, NULL},
   {"u10C2p", "j", NULL, NULL, NULL},
   {"u10C3p", "w", "i", NULL, NULL},
   {"u10C4p", "q", NULL, NULL, NULL},
   {"u10C5p", "oU", NULL, NULL, NULL},
   {"u10D0p", "A", NULL, NULL, NULL},
   {"u10D1p", "b", NULL, NULL, NULL},
   {"u10D2p", "g", NULL, NULL, NULL},
   {"u10D3p", "d", NULL, NULL, NULL},
   {"u10D4p", "E", NULL, NULL, NULL},
   {"u10D5p", "v", NULL, NULL, NULL},
   {"u10D6p", "z", NULL, NULL, NULL},
   {"u10D7p", "th", NULL, NULL, NULL},
   {"u10D8p", "i", NULL, NULL, NULL},
   {"u10D9p", "kGT", NULL, NULL, NULL},
   {"u10DAp", "l", NULL, NULL, NULL},
   {"u10DBp", "m", NULL, NULL, NULL},
   {"u10DCp", "n", NULL, NULL, NULL},
   {"u10DDp", "o", NULL, NULL, NULL},
   {"u10DEp", "pGT", NULL, NULL, NULL},
   {"u10DFp", "Z", NULL, NULL, NULL},
   {"u10E0p", "v", NULL, NULL, NULL},
   {"u10E1p", "s", NULL, NULL, NULL},
   {"u10E2p", "tGT", NULL, NULL, NULL},
   {"u10E3p", "u", NULL, NULL, NULL},
   {"u10E4p", "ph", NULL, NULL, NULL},
   {"u10E5p", "kh", NULL, NULL, NULL},
   {"u10E6p", "G", NULL, NULL, NULL},
   {"u10E7p", "qGT", NULL, NULL, NULL},
   {"u10E8p", "S", NULL, NULL, NULL},
   {"u10E9p", "tS", NULL, NULL, NULL},
   {"u10EAp", "k", NULL, NULL, NULL},
   {"u10EBp", "dz", NULL, NULL, NULL},
   {"u10ECp", "tsGT", NULL, NULL, NULL},
   {"u10EDp", "tSGT", NULL, NULL, NULL},
   {"u10EEp", "x", NULL, NULL, NULL},
   {"u10EFp", "dZ", NULL, NULL, NULL},
   {"u10F0p", "h", NULL, NULL, NULL},
   {"u10F1p", "ej", NULL, NULL, NULL},
   {"u10F2p", "j", NULL, NULL, NULL},
   {"u10F3p", "w", "i", NULL, NULL},
   {"u10F4p", "q", NULL, NULL, NULL},
   {"u10F5p", "oU", NULL, NULL, NULL},
   {"u10F6p", "f", NULL, NULL, NULL},
   {"u10F7p", "YN", NULL, NULL, NULL},
   {"u10F8p", "ELIFI", NULL, NULL, NULL},
   {"u10F9p", "TURNEDGAN", NULL, NULL, NULL},
   {"u10FAp", "AIN", NULL, NULL, NULL},
   {"u10FBp", "PARAGRAPHSEPARATOR", NULL, NULL, NULL},
   {"u10FCp", "MODIFIERLETTERGEORGIANNAR", NULL, NULL, NULL},
   {"u2D00p", "A", NULL, NULL, NULL},
   {"u2D01p", "b", NULL, NULL, NULL},
   {"u2D02p", "g", NULL, NULL, NULL},
   {"u2D03p", "d", NULL, NULL, NULL},
   {"u2D04p", "E", NULL, NULL, NULL},
   {"u2D05p", "v", NULL, NULL, NULL},
   {"u2D06p", "z", NULL, NULL, NULL},
   {"u2D07p", "th", NULL, NULL, NULL},
   {"u2D08p", "i", NULL, NULL, NULL},
   {"u2D09p", "kGT", NULL, NULL, NULL},
   {"u2D0Ap", "l", NULL, NULL, NULL},
   {"u2D0Bp", "m", NULL, NULL, NULL},
   {"u2D0Cp", "n", NULL, NULL, NULL},
   {"u2D0Dp", "o", NULL, NULL, NULL},
   {"u2D0Ep", "pGT", NULL, NULL, NULL},
   {"u2D0Fp", "z", NULL, NULL, NULL},
   {"u2D10p", "v", NULL, NULL, NULL},
   {"u2D11p", "s", NULL, NULL, NULL},
   {"u2D12p", "tGT", NULL, NULL, NULL},
   {"u2D13p", "u", NULL, NULL, NULL},
   {"u2D14p", "ph", NULL, NULL, NULL},
   {"u2D15p", "kh", NULL, NULL, NULL},
   {"u2D16p", "G", NULL, NULL, NULL},
   {"u2D17p", "qGT", NULL, NULL, NULL},
   {"u2D18p", "S", NULL, NULL, NULL},
   {"u2D19p", "tS", NULL, NULL, NULL},
   {"u2D1Ap", "k", NULL, NULL, NULL},
   {"u2D1Bp", "dz", NULL, NULL, NULL},
   {"u2D1Cp", "tsGT", NULL, NULL, NULL},
   {"u2D1Dp", "tSGT", NULL, NULL, NULL},
   {"u2D1Ep", "x", NULL, NULL, NULL},
   {"u2D1Fp", "dZ", NULL, NULL, NULL},
   {"u2D20p", "h", NULL, NULL, NULL},
   {"u2D21p", "ej", NULL, NULL, NULL},
   {"u2D22p", "j", NULL, NULL, NULL},
   {"u2D23p", "w", "i", NULL, NULL},
   {"u2D24p", "q", NULL, NULL, NULL},
   {"u2D25p", "oU", NULL, NULL, NULL},
   {"u0374p", "NUMERAL_SIGN", NULL, NULL, NULL},
   {"u0375p", "LOWER_NUMERAL_SIGN", NULL, NULL, NULL},
   {"u037Ap", "YPOGEGRAMMENI", NULL, NULL, NULL},
   {"u037Ep", "QUESTIONMARK", NULL, NULL, NULL},
   {"u0384p", "TONOS", NULL, NULL, NULL},
   {"u0385p", "DIALYTIKA_TONOS", NULL, NULL, NULL},
   {"u0386p", "A", NULL, NULL, NULL},
   {"u0387p", "TELEIA", NULL, NULL, NULL},
   {"u0388p", "e", NULL, NULL, NULL},
   {"u0389p", "E:", NULL, NULL, NULL},
   {"u038Ap", "i", NULL, NULL, NULL},
   {"u038Cp", "o", NULL, NULL, NULL},
   {"u038Ep", "i", NULL, NULL, NULL},
   {"u038Fp", "o", NULL, NULL, NULL},
   {"u0390p", "i", NULL, NULL, NULL},
   {"u0391p", "A", NULL, NULL, NULL},
   {"u0392p", "b", NULL, NULL, NULL},
   {"u0393p", "g", NULL, NULL, NULL},
   {"u0394p", "d", NULL, NULL, NULL},
   {"u0395p", "e", NULL, NULL, NULL},
   {"u0396p", "z", NULL, NULL, NULL},
   {"u0397p", "E:", NULL, NULL, NULL},
   {"u0398p", "th", NULL, NULL, NULL},
   {"u0399p", "i", NULL, NULL, NULL},
   {"u039Ap", "k", NULL, NULL, NULL},
   {"u039Bp", "l", NULL, NULL, NULL},
   {"u039Cp", "m", NULL, NULL, NULL},
   {"u039Dp", "n", NULL, NULL, NULL},
   {"u039Ep", "k", "s", NULL, NULL},
   {"u039Fp", "o", NULL, NULL, NULL},
   {"u03A0p", "p", NULL, NULL, NULL},
   {"u03A1p", "r", NULL, NULL, NULL},
   {"u03A3p", "s", NULL, NULL, NULL},
   {"u03A4p", "t", NULL, NULL, NULL},
   {"u03A5p", "i", NULL, NULL, NULL},
   {"u03A6p", "f", NULL, NULL, NULL},
   {"u03A7p", "X", NULL, NULL, NULL},
   {"u03A8p", "p", "s", NULL, NULL},
   {"u03A9p", "o", NULL, NULL, NULL},
   {"u03AAp", "i", NULL, NULL, NULL},
   {"u03ABp", "i", NULL, NULL, NULL},
   {"u03ACp", "A", NULL, NULL, NULL},
   {"u03ADp", "e", NULL, NULL, NULL},
   {"u03AEp", "E:", NULL, NULL, NULL},
   {"u03AFp", "i", NULL, NULL, NULL},
   {"u03B0p", "i", NULL, NULL, NULL},
   {"u03B1p", "A", NULL, NULL, NULL},
   {"u03B2p", "b", NULL, NULL, NULL},
   {"u03B3p", "g", NULL, NULL, NULL},
   {"u03B4p", "d", NULL, NULL, NULL},
   {"u03B5p", "e", NULL, NULL, NULL},
   {"u03B6p", "z", NULL, NULL, NULL},
   {"u03B7p", "E:", NULL, NULL, NULL},
   {"u03B8p", "th", NULL, NULL, NULL},
   {"u03B9p", "i", NULL, NULL, NULL},
   {"u03BAp", "k", NULL, NULL, NULL},
   {"u03BBp", "l", NULL, NULL, NULL},
   {"u03BCp", "m", NULL, NULL, NULL},
   {"u03BDp", "n", NULL, NULL, NULL},
   {"u03BEp", "k", "s", NULL, NULL},
   {"u03BFp", "o", NULL, NULL, NULL},
   {"u03C0p", "p", NULL, NULL, NULL},
   {"u03C1p", "r", NULL, NULL, NULL},
   {"u03C2p", "s", NULL, NULL, NULL},
   {"u03C3p", "s", NULL, NULL, NULL},
   {"u03C4p", "t", NULL, NULL, NULL},
   {"u03C5p", "i", NULL, NULL, NULL},
   {"u03C6p", "f", NULL, NULL, NULL},
   {"u03C7p", "X", NULL, NULL, NULL},
   {"u03C8p", "p", "s", NULL, NULL},
   {"u03C9p", "o", NULL, NULL, NULL},
   {"u03CAp", "i", NULL, NULL, NULL},
   {"u03CBp", "i", NULL, NULL, NULL},
   {"u03CCp", "o", NULL, NULL, NULL},
   {"u03CDp", "i", NULL, NULL, NULL},
   {"u03CEp", "o", NULL, NULL, NULL},
   {"u03D0p", "b", NULL, NULL, NULL},
   {"u03D1p", "th", NULL, NULL, NULL},
   {"u03D2p", "i", NULL, NULL, NULL},
   {"u03D3p", "i", NULL, NULL, NULL},
   {"u03D4p", "i", NULL, NULL, NULL},
   {"u03D5p", "f", NULL, NULL, NULL},
   {"u03D6p", "p", NULL, NULL, NULL},
   {"u03D7p", "KAI", NULL, NULL, NULL},
   {"u03D8p", "q", NULL, NULL, NULL},
   {"u03D9p", "q", NULL, NULL, NULL},
   {"u03DAp", "s", NULL, NULL, NULL},
   {"u03DBp", "s", NULL, NULL, NULL},
   {"u03DCp", "w", NULL, NULL, NULL},
   {"u03DDp", "w", NULL, NULL, NULL},
   {"u03DEp", "q", NULL, NULL, NULL},
   {"u03DFp", "q", NULL, NULL, NULL},
   {"u03E0p", "NINE", "HUNDREDS", NULL, NULL},
   {"u03E1p", "NINE", "HUNDREDS", NULL, NULL},
   {"u03E2p", "S", NULL, NULL, NULL},
   {"u03E3p", "S", NULL, NULL, NULL},
   {"u03E4p", "f", NULL, NULL, NULL},
   {"u03E5p", "f", NULL, NULL, NULL},
   {"u03E6p", "h", NULL, NULL, NULL},
   {"u03E7p", "h", NULL, NULL, NULL},
   {"u03E8p", "h", NULL, NULL, NULL},
   {"u03E9p", "h", NULL, NULL, NULL},
   {"u03EAp", "dZ", NULL, NULL, NULL},
   {"u03EBp", "dZ", NULL, NULL, NULL},
   {"u03ECp", "q", NULL, NULL, NULL},
   {"u03EDp", "q", NULL, NULL, NULL},
   {"u03EEp", "t", "i", NULL, NULL},
   {"u03EFp", "t", "i", NULL, NULL},
   {"u03F0p", "k", NULL, NULL, NULL},
   {"u03F1p", "r", NULL, NULL, NULL},
   {"u03F2p", "s", NULL, NULL, NULL},
   {"u03F3p", "YOT", NULL, NULL, NULL},
   {"u03F4p", "th", NULL, NULL, NULL},
   {"u03F5p", "e", NULL, NULL, NULL},
   {"u03F6p", "e", NULL, NULL, NULL},
   {"u03F7p", "S", NULL, NULL, NULL},
   {"u03F8p", "S", NULL, NULL, NULL},
   {"u03F9p", "s", NULL, NULL, NULL},
   {"u03FAp", "SAN", NULL, NULL, NULL},
   {"u03FBp", "SAN", NULL, NULL, NULL},
   {"u03FCp", "r", NULL, NULL, NULL},
   {"u03FDp", "s", NULL, NULL, NULL},
   {"u03FEp", "s", NULL, NULL, NULL},
   {"u03FFp", "s", NULL, NULL, NULL},
   {"u0A81p", "CD", NULL, NULL, NULL},
   {"u0A82p", "M", NULL, NULL, NULL},
   {"u0A83p", "H", NULL, NULL, NULL},
   {"u0A85p", "A", NULL, NULL, NULL},
   {"u0A86p", "A:", NULL, NULL, NULL},
   {"u0A87p", "i", NULL, NULL, NULL},
   {"u0A88p", "i:", NULL, NULL, NULL},
   {"u0A89p", "u", NULL, NULL, NULL},
   {"u0A8Ap", "u:", NULL, NULL, NULL},
   {"u0A8Bp", "9r", "u", NULL, NULL},
   {"u0A8Cp", "l=", NULL, NULL, NULL},
   {"u0A8Dp", "e", NULL, NULL, NULL},
   {"u0A8Fp", "e", NULL, NULL, NULL},
   {"u0A90p", "aI", NULL, NULL, NULL},
   {"u0A91p", "o", NULL, NULL, NULL},
   {"u0A93p", "o", NULL, NULL, NULL},
   {"u0A94p", "aU", NULL, NULL, NULL},
   {"u0A95p", "k", "A", NULL, NULL},
   {"u0A96p", "kh", "A", NULL, NULL},
   {"u0A97p", "g", "A", NULL, NULL},
   {"u0A98p", "gh", "A", NULL, NULL},
   {"u0A99p", "N", "A", NULL, NULL},
   {"u0A9Ap", "c", "A", NULL, NULL},
   {"u0A9Bp", "ch", "A", NULL, NULL},
   {"u0A9Cp", "J", "A", NULL, NULL},
   {"u0A9Dp", "Jh", "A", NULL, NULL},
   {"u0A9Ep", "n~", "A", NULL, NULL},
   {"u0A9Fp", "tr", "A", NULL, NULL},
   {"u0AA0p", "tR", "A", NULL, NULL},
   {"u0AA1p", "dr", "A", NULL, NULL},
   {"u0AA2p", "dR", "A", NULL, NULL},
   {"u0AA3p", "nr", "A", NULL, NULL},
   {"u0AA4p", "tB", "A", NULL, NULL},
   {"u0AA5p", "tBh", "A", NULL, NULL},
   {"u0AA6p", "dB", "A", NULL, NULL},
   {"u0AA7p", "dBh", "A", NULL, NULL},
   {"u0AA8p", "nB", "A", NULL, NULL},
   {"u0AAAp", "p", "A", NULL, NULL},
   {"u0AABp", "ph", "A", NULL, NULL},
   {"u0AACp", "b", "A", NULL, NULL},
   {"u0AADp", "bh", "A", NULL, NULL},
   {"u0AAEp", "m", "A", NULL, NULL},
   {"u0AAFp", "j", "A", NULL, NULL},
   {"u0AB0p", "9r", "A", NULL, NULL},
   {"u0AB2p", "l", "A", NULL, NULL},
   {"u0AB3p", "lr", "A", NULL, NULL},
   {"u0AB5p", "v", "A", NULL, NULL},
   {"u0AB6p", "S", "A", NULL, NULL},
   {"u0AB7p", "S", "A", NULL, NULL},
   {"u0AB8p", "s", "A", NULL, NULL},
   {"u0AB9p", "hv", "A", NULL, NULL},
   {"u0ABCp", "NUKTA", NULL, NULL, NULL},
   {"u0ABDp", "AVAGRAHA", NULL, NULL, NULL},
   {"u0ABEp", "A:", NULL, NULL, NULL},
   {"u0ABFp", "i", NULL, NULL, NULL},
   {"u0AC0p", "i:", NULL, NULL, NULL},
   {"u0AC1p", "u", NULL, NULL, NULL},
   {"u0AC2p", "u:", NULL, NULL, NULL},
   {"u0AC3p", "9r=", NULL, NULL, NULL},
   {"u0AC4p", "rr=", NULL, NULL, NULL},
   {"u0AC5p", "e", NULL, NULL, NULL},
   {"u0AC7p", "e", NULL, NULL, NULL},
   {"u0AC8p", "aI", NULL, NULL, NULL},
   {"u0AC9p", "o", NULL, NULL, NULL},
   {"u0ACBp", "o", NULL, NULL, NULL},
   {"u0ACCp", "aU", NULL, NULL, NULL},
   {"u0ACDp", "P", NULL, NULL, NULL},
   {"u0AD0p", "OM", NULL, NULL, NULL},
   {"u0AE0p", "rr=", NULL, NULL, NULL},
   {"u0AE1p", "lr=", NULL, NULL, NULL},
   {"u0AE2p", "l=", NULL, NULL, NULL},
   {"u0AE3p", "lr=", NULL, NULL, NULL},
   {"u0AE6p", "ZERO", NULL, NULL, NULL},
   {"u0AE7p", "ONE", NULL, NULL, NULL},
   {"u0AE8p", "TWO", NULL, NULL, NULL},
   {"u0AE9p", "THREE", NULL, NULL, NULL},
   {"u0AEAp", "FOUR", NULL, NULL, NULL},
   {"u0AEBp", "FIVE", NULL, NULL, NULL},
   {"u0AECp", "SIX", NULL, NULL, NULL},
   {"u0AEDp", "SEVEN", NULL, NULL, NULL},
   {"u0AEEp", "EIGHT", NULL, NULL, NULL},
   {"u0AEFp", "NINE", NULL, NULL, NULL},
   {"u0A0Ap", "CD", NULL, NULL, NULL},
   {"u0A01p", "R:0A01", NULL, NULL, NULL},
   {"u0A02p", "M", NULL, NULL, NULL},
   {"u0A03p", "H", NULL, NULL, NULL},
   {"u0A05p", "AMP", NULL, NULL, NULL},
   {"u0A06p", "A", NULL, NULL, NULL},
   {"u0A07p", "I", NULL, NULL, NULL},
   {"u0A08p", "i", NULL, NULL, NULL},
   {"u0A09p", "U", NULL, NULL, NULL},
   {"u0A0Ap", "u", NULL, NULL, NULL},
   {"u0A0Bp", "R:0A0B", NULL, NULL, NULL},
   {"u0A0Dp", "R:0A0D", NULL, NULL, NULL},
   {"u0A0Ep", "R:0A0E", NULL, NULL, NULL},
   {"u0A0Fp", "e", NULL, NULL, NULL},
   {"u0A10p", "aI", NULL, NULL, NULL},
   {"u0A11p", "R:0A11", NULL, NULL, NULL},
   {"u0A12p", "R:0A12", NULL, NULL, NULL},
   {"u0A13p", "o", NULL, NULL, NULL},
   {"u0A14p", "aU", NULL, NULL, NULL},
   {"u0A15p", "k", "A", NULL, NULL},
   {"u0A16p", "kh", "A", NULL, NULL},
   {"u0A17p", "g", "A", NULL, NULL},
   {"u0A18p", "gh", "A", NULL, NULL},
   {"u0A19p", "N", "A", NULL, NULL},
   {"u0A1Ap", "c", "A", NULL, NULL},
   {"u0A1Bp", "ch", "A", NULL, NULL},
   {"u0A1Cp", "J", "A", NULL, NULL},
   {"u0A1Dp", "Jh", "A", NULL, NULL},
   {"u0A1Ep", "n~", "A", NULL, NULL},
   {"u0A1Fp", "tr", "A", NULL, NULL},
   {"u0A20p", "tR", "A", NULL, NULL},
   {"u0A21p", "dr", "A", NULL, NULL},
   {"u0A22p", "dR", "A", NULL, NULL},
   {"u0A23p", "nr", "A", NULL, NULL},
   {"u0A24p", "tB", "A", NULL, NULL},
   {"u0A25p", "tBh", "A", NULL, NULL},
   {"u0A26p", "dB", NULL, NULL, NULL},
   {"u0A27p", "dBh", "A", NULL, NULL},
   {"u0A28p", "nB", NULL, NULL, NULL},
   {"u0A29p", "R:0A29", NULL, NULL, NULL},
   {"u0A2Ap", "p", "A", NULL, NULL},
   {"u0A2Bp", "ph", "A", NULL, NULL},
   {"u0A2Cp", "b", "A", NULL, NULL},
   {"u0A2Dp", "bh", "A", NULL, NULL},
   {"u0A2Ep", "m", "A", NULL, NULL},
   {"u0A2Fp", "j", "A", NULL, NULL},
   {"u0A30p", "r", "A", NULL, NULL},
   {"u0A31p", "R:0A31", NULL, NULL, NULL},
   {"u0A32p", "l", "A", NULL, NULL},
   {"u0A33p", "lr", "A", NULL, NULL},
   {"u0A34p", "R:0A34", NULL, NULL, NULL},
   {"u0A35p", "v", "A", NULL, NULL},
   {"u0A36p", "S", "A", NULL, NULL},
   {"u0A37p", "R:0A37", NULL, NULL, NULL},
   {"u0A38p", "s", "A", NULL, NULL},
   {"u0A39p", "hv", "A", NULL, NULL},
   {"u0A3Cp", "NUKTA", NULL, NULL, NULL},
   {"u0A3Ep", "A", NULL, NULL, NULL},
   {"u0A3Fp", "I", NULL, NULL, NULL},
   {"u0A40p", "i", NULL, NULL, NULL},
   {"u0A41p", "U", NULL, NULL, NULL},
   {"u0A42p", "u", NULL, NULL, NULL},
   {"u0A43p", "R:0A43", NULL, NULL, NULL},
   {"u0A45p", "R:0A45", NULL, NULL, NULL},
   {"u0A46p", "R:0A46", NULL, NULL, NULL},
   {"u0A47p", "e", NULL, NULL, NULL},
   {"u0A48p", "aI", NULL, NULL, NULL},
   {"u0A49p", "R:0A49", NULL, NULL, NULL},
   {"u0A4Ap", "R:0A4A", NULL, NULL, NULL},
   {"u0A4Bp", "o", NULL, NULL, NULL},
   {"u0A4Cp", "aU", NULL, NULL, NULL},
   {"u0A4Dp", "P", NULL, NULL, NULL},
   {"u0A59p", "x", "A", NULL, NULL},
   {"u0A5Ap", "G", "A", NULL, NULL},
   {"u0A5Bp", "z", "A", NULL, NULL},
   {"u0A5Cp", "rr", "A", NULL, NULL},
   {"u0A5Ep", "f", "A", NULL, NULL},
   {"u0A5Fp", "R:0A5F", NULL, NULL, NULL},
   {"u0A64p", "R:0A64", NULL, NULL, NULL},
   {"u0A66p", "ZERO", NULL, NULL, NULL},
   {"u0A67p", "ONE", NULL, NULL, NULL},
   {"u0A68p", "TWO", NULL, NULL, NULL},
   {"u0A69p", "THREE", NULL, NULL, NULL},
   {"u0A6Ap", "FOUR", NULL, NULL, NULL},
   {"u0A6Bp", "FIVE", NULL, NULL, NULL},
   {"u0A6Cp", "SIX", NULL, NULL, NULL},
   {"u0A6Dp", "SEVEN", NULL, NULL, NULL},
   {"u0A6Ep", "EIGHT", NULL, NULL, NULL},
   {"u0A6Fp", "NINE", NULL, NULL, NULL},
   {"u0A70p", "TIPPI", NULL, NULL, NULL},
   {"u0A71p", "ADDAK", NULL, NULL, NULL},
   {"u0A72p", "IRI", NULL, NULL, NULL},
   {"u0A73p", "URA", NULL, NULL, NULL},
   {"u1720p", "A", NULL, NULL, NULL},
   {"u1721p", "i", NULL, NULL, NULL},
   {"u1722p", "u", NULL, NULL, NULL},
   {"u1723p", "k", "A", NULL, NULL},
   {"u1724p", "g", "A", NULL, NULL},
   {"u1725p", "N", "A", NULL, NULL},
   {"u1726p", "t", "A", NULL, NULL},
   {"u1727p", "d", "A", NULL, NULL},
   {"u1728p", "n", "A", NULL, NULL},
   {"u1729p", "p", "A", NULL, NULL},
   {"u172Ap", "b", "A", NULL, NULL},
   {"u172Bp", "m", "A", NULL, NULL},
   {"u172Cp", "j", "A", NULL, NULL},
   {"u172Dp", "r", "A", NULL, NULL},
   {"u172Ep", "l", "A", NULL, NULL},
   {"u172Fp", "w", "A", NULL, NULL},
   {"u1730p", "s", "A", NULL, NULL},
   {"u1731p", "h", "A", NULL, NULL},
   {"u1732p", "i", NULL, NULL, NULL},
   {"u1733p", "u", NULL, NULL, NULL},
   {"u1734p", "P", NULL, NULL, NULL},
   {"u1735p", "SINGLE_PUNCTUATION", NULL, NULL, NULL},
   {"u1736p", "DOUBLE_PUNCTUATION", NULL, NULL, NULL},
   {"u05D0p", "QM", NULL, NULL, NULL},
   {"u05D1p", "b", NULL, NULL, NULL},
   {"u05D2p", "g", NULL, NULL, NULL},
   {"u05D3p", "d", NULL, NULL, NULL},
   {"u05D4p", "h", NULL, NULL, NULL},
   {"u05D5p", "v", NULL, NULL, NULL},
   {"u05D6p", "z", NULL, NULL, NULL},
   {"u05D7p", "x", NULL, NULL, NULL},
   {"u05D8p", "t", NULL, NULL, NULL},
   {"u05D9p", "j", NULL, NULL, NULL},
   {"u05DAp", "k", NULL, NULL, NULL},
   {"u05DBp", "k", NULL, NULL, NULL},
   {"u05DCp", "l", NULL, NULL, NULL},
   {"u05DDp", "m", NULL, NULL, NULL},
   {"u05DEp", "m", NULL, NULL, NULL},
   {"u05DFp", "n", NULL, NULL, NULL},
   {"u05E0p", "n", NULL, NULL, NULL},
   {"u05E1p", "s", NULL, NULL, NULL},
   {"u05E2p", "QM", NULL, NULL, NULL},
   {"u05E3p", "p", NULL, NULL, NULL},
   {"u05E4p", "p", NULL, NULL, NULL},
   {"u05E5p", "ts", NULL, NULL, NULL},
   {"u05E6p", "ts", NULL, NULL, NULL},
   {"u05E7p", "k", NULL, NULL, NULL},
   {"u05E8p", "k", NULL, NULL, NULL},
   {"u05E9p", "s", NULL, NULL, NULL},
   {"u05EAp", "t", NULL, NULL, NULL},
   {"u05F0p", "v", NULL, NULL, NULL},
   {"u05F1p", "GTj", NULL, NULL, NULL},
   {"u05F2p", "Ej", NULL, NULL, NULL},
   {"uFB00p", "f", "f", NULL, NULL},
   {"uFB01p", "f", "i", NULL, NULL},
   {"uFB02p", "f", "l", NULL, NULL},
   {"uFB03p", "f", "f", "i", NULL},
   {"uFB04p", "f", "f", "l", NULL},
   {"uFB05p", "s", "t", NULL, NULL},
   {"uFB06p", "s", "t", NULL, NULL},
   {"uFB13p", "m", "n", NULL, NULL},
   {"uFB14p", "m", "h", NULL, NULL},
   {"uFB15p", "m", "dZ", NULL, NULL},
   {"uFB16p", "m", "n", NULL, NULL},
   {"uFB17p", "m", "x", NULL, NULL},
   {"uFB1Dp", "j", NULL, NULL, NULL},
   {"uFB1Ep", "HEBREWPOINTJUDEO-SPANISHVARIKA", NULL, NULL, NULL},
   {"uFB1Fp", "GTj", NULL, NULL, NULL},
   {"uFB20p", "QM", NULL, NULL, NULL},
   {"uFB21p", "QM", NULL, NULL, NULL},
   {"uFB22p", "d", NULL, NULL, NULL},
   {"uFB23p", "h", NULL, NULL, NULL},
   {"uFB24p", "k", NULL, NULL, NULL},
   {"uFB25p", "l", NULL, NULL, NULL},
   {"uFB26p", "m", NULL, NULL, NULL},
   {"uFB27p", "k", NULL, NULL, NULL},
   {"uFB28p", "t", NULL, NULL, NULL},
   {"uFB29p", "ALTERNATIVEPLUSSIGN", NULL, NULL, NULL},
   {"uFB2Ap", "s", NULL, NULL, NULL},
   {"uFB2Bp", "s", NULL, NULL, NULL},
   {"uFB2Cp", "s", NULL, NULL, NULL},
   {"uFB2Dp", "s", NULL, NULL, NULL},
   {"uFB2Ep", "QM", NULL, NULL, NULL},
   {"uFB2Fp", "QM", NULL, NULL, NULL},
   {"uFB30p", "QM", NULL, NULL, NULL},
   {"uFB31p", "b", NULL, NULL, NULL},
   {"uFB32p", "g", NULL, NULL, NULL},
   {"uFB33p", "d", NULL, NULL, NULL},
   {"uFB34p", "h", NULL, NULL, NULL},
   {"uFB35p", "v", NULL, NULL, NULL},
   {"uFB36p", "z", NULL, NULL, NULL},
   {"uFB38p", "t", NULL, NULL, NULL},
   {"uFB39p", "j", NULL, NULL, NULL},
   {"uFB3Ap", "k", NULL, NULL, NULL},
   {"uFB3Bp", "k", NULL, NULL, NULL},
   {"uFB3Cp", "l", NULL, NULL, NULL},
   {"uFB3Ep", "m", NULL, NULL, NULL},
   {"uFB40p", "n", NULL, NULL, NULL},
   {"uFB41p", "s", NULL, NULL, NULL},
   {"uFB43p", "p", NULL, NULL, NULL},
   {"uFB44p", "p", NULL, NULL, NULL},
   {"uFB46p", "ts", NULL, NULL, NULL},
   {"uFB47p", "k", NULL, NULL, NULL},
   {"uFB48p", "k", NULL, NULL, NULL},
   {"uFB49p", "s", NULL, NULL, NULL},
   {"uFB4Ap", "t", NULL, NULL, NULL},
   {"uFB4Bp", "v", NULL, NULL, NULL},
   {"uFB4Cp", "b", NULL, NULL, NULL},
   {"uFB4Dp", "k", NULL, NULL, NULL},
   {"uFB4Ep", "p", NULL, NULL, NULL},
   {"uFB4Fp", "QM", NULL, NULL, NULL},
   {"u3041p", "A", NULL, NULL, NULL},
   {"u3042p", "A", NULL, NULL, NULL},
   {"u3043p", "i", NULL, NULL, NULL},
   {"u3044p", "i", NULL, NULL, NULL},
   {"u3045p", "u", NULL, NULL, NULL},
   {"u3046p", "u", NULL, NULL, NULL},
   {"u3047p", "e", NULL, NULL, NULL},
   {"u3048p", "e", NULL, NULL, NULL},
   {"u3049p", "o", NULL, NULL, NULL},
   {"u304Ap", "o", NULL, NULL, NULL},
   {"u304Bp", "k", "A", NULL, NULL},
   {"u304Cp", "g", "A", NULL, NULL},
   {"u304Dp", "k", "i", NULL, NULL},
   {"u304Ep", "g", "i", NULL, NULL},
   {"u304Fp", "k", "u", NULL, NULL},
   {"u3050p", "g", "u", NULL, NULL},
   {"u3051p", "k", "e", NULL, NULL},
   {"u3052p", "g", "e", NULL, NULL},
   {"u3053p", "k", "o", NULL, NULL},
   {"u3054p", "g", "o", NULL, NULL},
   {"u3055p", "s", "A", NULL, NULL},
   {"u3056p", "z", "A", NULL, NULL},
   {"u3057p", "s", "i", NULL, NULL},
   {"u3058p", "z", "i", NULL, NULL},
   {"u3059p", "s", "u", NULL, NULL},
   {"u305Ap", "z", "u", NULL, NULL},
   {"u305Bp", "s", "e", NULL, NULL},
   {"u305Cp", "z", "e", NULL, NULL},
   {"u305Dp", "s", "o", NULL, NULL},
   {"u305Ep", "z", "o", NULL, NULL},
   {"u305Fp", "t", "A", NULL, NULL},
   {"u3060p", "d", "A", NULL, NULL},
   {"u3061p", "tS", "i", NULL, NULL},
   {"u3062p", "z", "i", NULL, NULL},
   {"u3063p", "ts", "u", NULL, NULL},
   {"u3064p", "ts", "u", NULL, NULL},
   {"u3065p", "z", "u", NULL, NULL},
   {"u3066p", "t", "e", NULL, NULL},
   {"u3067p", "d", "e", NULL, NULL},
   {"u3068p", "t", "o", NULL, NULL},
   {"u3069p", "d", "o", NULL, NULL},
   {"u306Ap", "n", "A", NULL, NULL},
   {"u306Bp", "n", "i", NULL, NULL},
   {"u306Cp", "n", "u", NULL, NULL},
   {"u306Dp", "n", "e", NULL, NULL},
   {"u306Ep", "n", "o", NULL, NULL},
   {"u306Fp", "h", "A", NULL, NULL},
   {"u3070p", "b", "A", NULL, NULL},
   {"u3071p", "p", "A", NULL, NULL},
   {"u3072p", "h", "i", NULL, NULL},
   {"u3073p", "b", "i", NULL, NULL},
   {"u3074p", "p", "i", NULL, NULL},
   {"u3075p", "h", "u", NULL, NULL},
   {"u3076p", "b", "u", NULL, NULL},
   {"u3077p", "p", "u", NULL, NULL},
   {"u3078p", "h", "e", NULL, NULL},
   {"u3079p", "b", "e", NULL, NULL},
   {"u307Ap", "p", "e", NULL, NULL},
   {"u307Bp", "h", "o", NULL, NULL},
   {"u307Cp", "b", "o", NULL, NULL},
   {"u307Dp", "p", "o", NULL, NULL},
   {"u307Ep", "m", "A", NULL, NULL},
   {"u307Fp", "m", "i", NULL, NULL},
   {"u3080p", "m", "u", NULL, NULL},
   {"u3081p", "m", "e", NULL, NULL},
   {"u3082p", "m", "o", NULL, NULL},
   {"u3083p", "j", "a", NULL, NULL},
   {"u3084p", "j", "a", NULL, NULL},
   {"u3085p", "yu", NULL, NULL, NULL},
   {"u3086p", "yu", NULL, NULL, NULL},
   {"u3087p", "j", "o", NULL, NULL},
   {"u3088p", "j", "o", NULL, NULL},
   {"u3089p", "r", "A", NULL, NULL},
   {"u308Ap", "r", "i", NULL, NULL},
   {"u308Bp", "r", "u", NULL, NULL},
   {"u308Cp", "r", "e", NULL, NULL},
   {"u308Dp", "r", "o", NULL, NULL},
   {"u308Ep", "w", "A", NULL, NULL},
   {"u308Fp", "w", "A", NULL, NULL},
   {"u3090p", "w", "i", NULL, NULL},
   {"u3091p", "w", "e", NULL, NULL},
   {"u3092p", "w", "o", NULL, NULL},
   {"u3093p", "N", NULL, NULL, NULL},
   {"u3094p", "v", "u", NULL, NULL},
   {"u3095p", "k", "A", NULL, NULL},
   {"u3096p", "k", "e", NULL, NULL},
   {"u3099p", "VOICED", NULL, NULL, NULL},
   {"u309Ap", "SEMIVOICED", NULL, NULL, NULL},
   {"u309Bp", "VOICED", NULL, NULL, NULL},
   {"u309Cp", "SEMIVOICED", NULL, NULL, NULL},
   {"u309Dp", "ITERATIONMARK", NULL, NULL, NULL},
   {"u309Ep", "VOICEDITERATIONMARK", NULL, NULL, NULL},
   {"u309Fp", "YORI", NULL, NULL, NULL},
   {"u30A0p", "EQUALSIGN", NULL, NULL, NULL},
   {"u30A1p", "A", NULL, NULL, NULL},
   {"u30A2p", "A", NULL, NULL, NULL},
   {"u30A3p", "i", NULL, NULL, NULL},
   {"u30A4p", "i", NULL, NULL, NULL},
   {"u30A5p", "u", NULL, NULL, NULL},
   {"u30A6p", "u", NULL, NULL, NULL},
   {"u30A7p", "e", NULL, NULL, NULL},
   {"u30A8p", "e", NULL, NULL, NULL},
   {"u30A9p", "o", NULL, NULL, NULL},
   {"u30AAp", "o", NULL, NULL, NULL},
   {"u30ABp", "k", "A", NULL, NULL},
   {"u30ACp", "g", "A", NULL, NULL},
   {"u30ADp", "k", "i", NULL, NULL},
   {"u30AEp", "g", "i", NULL, NULL},
   {"u30AFp", "k", "u", NULL, NULL},
   {"u30B0p", "g", "u", NULL, NULL},
   {"u30B1p", "k", "e", NULL, NULL},
   {"u30B2p", "g", "e", NULL, NULL},
   {"u30B3p", "k", "o", NULL, NULL},
   {"u30B4p", "g", "o", NULL, NULL},
   {"u30B5p", "s", "A", NULL, NULL},
   {"u30B6p", "z", "A", NULL, NULL},
   {"u30B7p", "s", "i", NULL, NULL},
   {"u30B8p", "z", "i", NULL, NULL},
   {"u30B9p", "s", "u", NULL, NULL},
   {"u30BAp", "z", "u", NULL, NULL},
   {"u30BBp", "s", "e", NULL, NULL},
   {"u30BCp", "z", "e", NULL, NULL},
   {"u30BDp", "s", "o", NULL, NULL},
   {"u30BEp", "z", "o", NULL, NULL},
   {"u30BFp", "t", "A", NULL, NULL},
   {"u30C0p", "d", "A", NULL, NULL},
   {"u30C1p", "tS", "i", NULL, NULL},
   {"u30C2p", "z", "i", NULL, NULL},
   {"u30C3p", "ts", "u", NULL, NULL},
   {"u30C4p", "ts", "u", NULL, NULL},
   {"u30C5p", "z", "u", NULL, NULL},
   {"u30C6p", "t", "e", NULL, NULL},
   {"u30C7p", "d", "e", NULL, NULL},
   {"u30C8p", "t", "o", NULL, NULL},
   {"u30C9p", "d", "o", NULL, NULL},
   {"u30CAp", "n", "A", NULL, NULL},
   {"u30CBp", "n", "i", NULL, NULL},
   {"u30CCp", "n", "u", NULL, NULL},
   {"u30CDp", "n", "e", NULL, NULL},
   {"u30CEp", "n", "o", NULL, NULL},
   {"u30CFp", "h", "A", NULL, NULL},
   {"u30D0p", "b", "A", NULL, NULL},
   {"u30D1p", "p", "A", NULL, NULL},
   {"u30D2p", "h", "i", NULL, NULL},
   {"u30D3p", "b", "i", NULL, NULL},
   {"u30D4p", "p", "i", NULL, NULL},
   {"u30D5p", "h", "u", NULL, NULL},
   {"u30D6p", "b", "u", NULL, NULL},
   {"u30D7p", "p", "u", NULL, NULL},
   {"u30D8p", "h", "e", NULL, NULL},
   {"u30D9p", "b", "e", NULL, NULL},
   {"u30DAp", "p", "e", NULL, NULL},
   {"u30DBp", "h", "o", NULL, NULL},
   {"u30DCp", "b", "o", NULL, NULL},
   {"u30DDp", "p", "o", NULL, NULL},
   {"u30DEp", "m", "A", NULL, NULL},
   {"u30DFp", "m", "i", NULL, NULL},
   {"u30E0p", "m", "u", NULL, NULL},
   {"u30E1p", "m", "e", NULL, NULL},
   {"u30E2p", "m", "o", NULL, NULL},
   {"u30E3p", "j", "a", NULL, NULL},
   {"u30E4p", "j", "a", NULL, NULL},
   {"u30E5p", "yu", NULL, NULL, NULL},
   {"u30E6p", "yu", NULL, NULL, NULL},
   {"u30E7p", "j", "o", NULL, NULL},
   {"u30E8p", "j", "o", NULL, NULL},
   {"u30E9p", "r", "A", NULL, NULL},
   {"u30EAp", "r", "i", NULL, NULL},
   {"u30EBp", "r", "u", NULL, NULL},
   {"u30ECp", "r", "e", NULL, NULL},
   {"u30EDp", "r", "o", NULL, NULL},
   {"u30EEp", "w", "A", NULL, NULL},
   {"u30EFp", "w", "A", NULL, NULL},
   {"u30F0p", "w", "i", NULL, NULL},
   {"u30F1p", "w", "e", NULL, NULL},
   {"u30F2p", "w", "o", NULL, NULL},
   {"u30F3p", "N", NULL, NULL, NULL},
   {"u30F4p", "v", "u", NULL, NULL},
   {"u30F5p", "k", "A", NULL, NULL},
   {"u30F6p", "k", "e", NULL, NULL},
   {"u30F7p", "v", "A", NULL, NULL},
   {"u30F8p", "v", "i", NULL, NULL},
   {"u30F9p", "v", "e", NULL, NULL},
   {"u30FAp", "v", "o", NULL, NULL},
   {"u30FBp", "MIDDLEDOT", NULL, NULL, NULL},
   {"u30FCp", "PROLONGEDSOUNDMARK", NULL, NULL, NULL},
   {"u30FDp", "ITERATIONMARK", NULL, NULL, NULL},
   {"u30FEp", "VOICEDITERATIONMARK", NULL, NULL, NULL},
   {"u0C81p", "R:0C81", NULL, NULL, NULL},
   {"u0C82p", "M", NULL, NULL, NULL},
   {"u0C83p", "H", NULL, NULL, NULL},
   {"u0C85p", "GT", NULL, NULL, NULL},
   {"u0C86p", "GT:", NULL, NULL, NULL},
   {"u0C87p", "i", NULL, NULL, NULL},
   {"u0C88p", "i:", NULL, NULL, NULL},
   {"u0C89p", "u", NULL, NULL, NULL},
   {"u0C8Ap", "u:", NULL, NULL, NULL},
   {"u0C8Bp", "9r", "i", NULL, NULL},
   {"u0C8Cp", "l=", NULL, NULL, NULL},
   {"u0C8Dp", "R:0C8D", NULL, NULL, NULL},
   {"u0C8Ep", "e", NULL, NULL, NULL},
   {"u0C8Fp", "e:", NULL, NULL, NULL},
   {"u0C90p", "aI", NULL, NULL, NULL},
   {"u0C91p", "R:0C91", NULL, NULL, NULL},
   {"u0C92p", "o", NULL, NULL, NULL},
   {"u0C93p", "o:", NULL, NULL, NULL},
   {"u0C94p", "aU", NULL, NULL, NULL},
   {"u0C95p", "k", "A", NULL, NULL},
   {"u0C96p", "kh", "A", NULL, NULL},
   {"u0C97p", "g", "A", NULL, NULL},
   {"u0C98p", "gh", "A", NULL, NULL},
   {"u0C99p", "N", "A", NULL, NULL},
   {"u0C9Ap", "c", "A", NULL, NULL},
   {"u0C9Bp", "ch", "A", NULL, NULL},
   {"u0C9Cp", "J", "A", NULL, NULL},
   {"u0C9Dp", "Jh", "A", NULL, NULL},
   {"u0C9Ep", "n~", "A", NULL, NULL},
   {"u0C9Fp", "tr", "A", NULL, NULL},
   {"u0CA0p", "tR", "A", NULL, NULL},
   {"u0CA1p", "dr", "A", NULL, NULL},
   {"u0CA2p", "dR", "A", NULL, NULL},
   {"u0CA3p", "nr", "A", NULL, NULL},
   {"u0CA4p", "tB", "A", NULL, NULL},
   {"u0CA5p", "tBh", "A", NULL, NULL},
   {"u0CA6p", "dB", "A", NULL, NULL},
   {"u0CA7p", "dBh", "A", NULL, NULL},
   {"u0CA8p", "nB", "A", NULL, NULL},
   {"u0CA9p", "R:0CA9", NULL, NULL, NULL},
   {"u0CAAp", "p", "A", NULL, NULL},
   {"u0CABp", "ph", "A", NULL, NULL},
   {"u0CACp", "b", "A", NULL, NULL},
   {"u0CADp", "bh", "A", NULL, NULL},
   {"u0CAEp", "m", "A", NULL, NULL},
   {"u0CAFp", "j", "A", NULL, NULL},
   {"u0CB0p", "9r", "A", NULL, NULL},
   {"u0CB1p", "rr", "A", NULL, NULL},
   {"u0CB2p", "l", "A", NULL, NULL},
   {"u0CB3p", "lr", "A", NULL, NULL},
   {"u0CB4p", "R:0CB4", NULL, NULL, NULL},
   {"u0CB5p", "v", "A", NULL, NULL},
   {"u0CB6p", "S", "A", NULL, NULL},
   {"u0CB7p", "S", "A", NULL, NULL},
   {"u0CB8p", "s", "A", NULL, NULL},
   {"u0CB9p", "hv", "A", NULL, NULL},
   {"u0CBCp", "NUKTA", NULL, NULL, NULL},
   {"u0CBDp", "AVAGRAHA", NULL, NULL, NULL},
   {"u0CBEp", "GT:", NULL, NULL, NULL},
   {"u0CBFp", "i", NULL, NULL, NULL},
   {"u0CC0p", "i:", NULL, NULL, NULL},
   {"u0CC1p", "u", NULL, NULL, NULL},
   {"u0CC2p", "u:", NULL, NULL, NULL},
   {"u0CC3p", "9r=", NULL, NULL, NULL},
   {"u0CC4p", "rr=", NULL, NULL, NULL},
   {"u0CC5p", "R:0CC5", NULL, NULL, NULL},
   {"u0CC6p", "e", NULL, NULL, NULL},
   {"u0CC7p", "e:", NULL, NULL, NULL},
   {"u0CC8p", "aI", NULL, NULL, NULL},
   {"u0CC9p", "R:0CC9", NULL, NULL, NULL},
   {"u0CCAp", "o", NULL, NULL, NULL},
   {"u0CCBp", "o:", NULL, NULL, NULL},
   {"u0CCCp", "aU", NULL, NULL, NULL},
   {"u0CCDp", "P", NULL, NULL, NULL},
   {"u0CD5p", "LENGTHMARK", NULL, NULL, NULL},
   {"u0DC6p", "aILENGTHMARK", NULL, NULL, NULL},
   {"u0CDEp", "f", "A", NULL, NULL},
   {"u0CDFp", "R:0CDF", NULL, NULL, NULL},
   {"u0CE0p", "rr=", NULL, NULL, NULL},
   {"u0CE1p", "l=", NULL, NULL, NULL},
   {"u0CE4p", "R:0CE4", NULL, NULL, NULL},
   {"u0CE6p", "(ZERO)", NULL, NULL, NULL},
   {"u0CE7p", "(ONE)", NULL, NULL, NULL},
   {"u0CE8p", "(TWO)", NULL, NULL, NULL},
   {"u0CE9p", "(THREE)", NULL, NULL, NULL},
   {"u0CEAp", "(FOUR)", NULL, NULL, NULL},
   {"u0CEBp", "(FIVE)", NULL, NULL, NULL},
   {"u0CECp", "(SIX)", NULL, NULL, NULL},
   {"u0CEDp", "(SEVEN)", NULL, NULL, NULL},
   {"u0CEEp", "(EIGHT)", NULL, NULL, NULL},
   {"u0CEFp", "(NINE)", NULL, NULL, NULL},
   {"uAC00p", "k", "a", NULL, NULL},
   {"uAC01p", "k", "a", "k", NULL},
   {"uAC02p", "k", "a", "kGT", NULL},
   {"uAC03p", "k", "a", "k", NULL},
   {"uAC04p", "k", "a", "n", NULL},
   {"uAC05p", "k", "a", "n", NULL},
   {"uAC06p", "k", "a", "n", NULL},
   {"uAC07p", "k", "a", "t", NULL},
   {"uAC08p", "k", "a", "l", NULL},
   {"uAC09p", "k", "a", "l", NULL},
   {"uAC0Ap", "k", "a", "l", NULL},
   {"uAC0Bp", "k", "a", "l", NULL},
   {"uAC0Cp", "k", "a", "l", NULL},
   {"uAC0Dp", "k", "a", "l", NULL},
   {"uAC0Ep", "k", "a", "l", NULL},
   {"uAC0Fp", "k", "a", "l", NULL},
   {"uAC10p", "k", "a", "m", NULL},
   {"uAC11p", "k", "a", "p", NULL},
   {"uAC12p", "k", "a", "p", NULL},
   {"uAC13p", "k", "a", "sh", NULL},
   {"uAC14p", "k", "a", "s", NULL},
   {"uAC15p", "k", "a", "N", NULL},
   {"uAC16p", "k", "a", "tS", NULL},
   {"uAC17p", "k", "a", "tSh", NULL},
   {"uAC18p", "k", "a", "kh", NULL},
   {"uAC19p", "k", "a", "th", NULL},
   {"uAC1Ap", "k", "a", "ph", NULL},
   {"uAC1Bp", "k", "a", "h", NULL},
   {"uAC1Cp", "k", "@", NULL, NULL},
   {"uAC1Dp", "k", "@", "k", NULL},
   {"uAC1Ep", "k", "@", "kGT", NULL},
   {"uAC1Fp", "k", "@", "k", NULL},
   {"uAC20p", "k", "@", "n", NULL},
   {"uAC21p", "k", "@", "n", NULL},
   {"uAC22p", "k", "@", "n", NULL},
   {"uAC23p", "k", "@", "t", NULL},
   {"uAC24p", "k", "@", "l", NULL},
   {"uAC25p", "k", "@", "l", NULL},
   {"uAC26p", "k", "@", "l", NULL},
   {"uAC27p", "k", "@", "l", NULL},
   {"uAC28p", "k", "@", "l", NULL},
   {"uAC29p", "k", "@", "l", NULL},
   {"uAC2Ap", "k", "@", "l", NULL},
   {"uAC2Bp", "k", "@", "l", NULL},
   {"uAC2Cp", "k", "@", "m", NULL},
   {"uAC2Dp", "k", "@", "p", NULL},
   {"uAC2Ep", "k", "@", "p", NULL},
   {"uAC2Fp", "k", "@", "sh", NULL},
   {"uAC30p", "k", "@", "s", NULL},
   {"uAC31p", "k", "@", "N", NULL},
   {"uAC32p", "k", "@", "tS", NULL},
   {"uAC33p", "k", "@", "tSh", NULL},
   {"uAC34p", "k", "@", "kh", NULL},
   {"uAC35p", "k", "@", "th", NULL},
   {"uAC36p", "k", "@", "ph", NULL},
   {"uAC37p", "k", "@", "h", NULL},
   {"uAC38p", "k", "j", "a", NULL},
   {"uAC39p", "k", "j", "a", NULL},
   {"uAC3Ap", "k", "j", "a", NULL},
   {"uAC3Bp", "k", "j", "a", NULL},
   {"uAC3Cp", "k", "j", "a", NULL},
   {"uAC3Dp", "k", "j", "a", NULL},
   {"uAC3Ep", "k", "j", "a", NULL},
   {"uAC3Fp", "k", "j", "a", NULL},
   {"uAC40p", "k", "j", "a", NULL},
   {"uAC41p", "k", "j", "a", NULL},
   {"uAC42p", "k", "j", "a", NULL},
   {"uAC43p", "k", "j", "a", NULL},
   {"uAC44p", "k", "j", "a", NULL},
   {"uAC45p", "k", "j", "a", NULL},
   {"uAC46p", "k", "j", "a", NULL},
   {"uAC47p", "k", "j", "a", NULL},
   {"uAC48p", "k", "j", "a", NULL},
   {"uAC49p", "k", "j", "a", NULL},
   {"uAC4Ap", "k", "j", "a", NULL},
   {"uAC4Bp", "k", "j", "a", NULL},
   {"uAC4Cp", "k", "j", "a", NULL},
   {"uAC4Dp", "k", "j", "a", NULL},
   {"uAC4Ep", "k", "j", "a", NULL},
   {"uAC4Fp", "k", "j", "a", NULL},
   {"uAC50p", "k", "j", "a", NULL},
   {"uAC51p", "k", "j", "a", NULL},
   {"uAC52p", "k", "j", "a", NULL},
   {"uAC53p", "k", "j", "a", NULL},
   {"uAC54p", "k", "j", "@", NULL},
   {"uAC55p", "k", "j", "@", NULL},
   {"uAC56p", "k", "j", "@", NULL},
   {"uAC57p", "k", "j", "@", NULL},
   {"uAC58p", "k", "j", "@", NULL},
   {"uAC59p", "k", "j", "@", NULL},
   {"uAC5Ap", "k", "j", "@", NULL},
   {"uAC5Bp", "k", "j", "@", NULL},
   {"uAC5Cp", "k", "j", "@", NULL},
   {"uAC5Dp", "k", "j", "@", NULL},
   {"uAC5Ep", "k", "j", "@", NULL},
   {"uAC5Fp", "k", "j", "@", NULL},
   {"uAC60p", "k", "j", "@", NULL},
   {"uAC61p", "k", "j", "@", NULL},
   {"uAC62p", "k", "j", "@", NULL},
   {"uAC63p", "k", "j", "@", NULL},
   {"uAC64p", "k", "j", "@", NULL},
   {"uAC65p", "k", "j", "@", NULL},
   {"uAC66p", "k", "j", "@", NULL},
   {"uAC67p", "k", "j", "@", NULL},
   {"uAC68p", "k", "j", "@", NULL},
   {"uAC69p", "k", "j", "@", NULL},
   {"uAC6Ap", "k", "j", "@", NULL},
   {"uAC6Bp", "k", "j", "@", NULL},
   {"uAC6Cp", "k", "j", "@", NULL},
   {"uAC6Dp", "k", "j", "@", NULL},
   {"uAC6Ep", "k", "j", "@", NULL},
   {"uAC6Fp", "k", "j", "@", NULL},
   {"uAC70p", "k", "^", NULL, NULL},
   {"uAC71p", "k", "^", "k", NULL},
   {"uAC72p", "k", "^", "kGT", NULL},
   {"uAC73p", "k", "^", "k", NULL},
   {"uAC74p", "k", "^", "n", NULL},
   {"uAC75p", "k", "^", "n", NULL},
   {"uAC76p", "k", "^", "n", NULL},
   {"uAC77p", "k", "^", "t", NULL},
   {"uAC78p", "k", "^", "l", NULL},
   {"uAC79p", "k", "^", "l", NULL},
   {"uAC7Ap", "k", "^", "l", NULL},
   {"uAC7Bp", "k", "^", "l", NULL},
   {"uAC7Cp", "k", "^", "l", NULL},
   {"uAC7Dp", "k", "^", "l", NULL},
   {"uAC7Ep", "k", "^", "l", NULL},
   {"uAC7Fp", "k", "^", "l", NULL},
   {"uAC80p", "k", "^", "m", NULL},
   {"uAC81p", "k", "^", "p", NULL},
   {"uAC82p", "k", "^", "p", NULL},
   {"uAC83p", "k", "^", "sh", NULL},
   {"uAC84p", "k", "^", "s", NULL},
   {"uAC85p", "k", "^", "N", NULL},
   {"uAC86p", "k", "^", "tS", NULL},
   {"uAC87p", "k", "^", "tSh", NULL},
   {"uAC88p", "k", "^", "kh", NULL},
   {"uAC89p", "k", "^", "th", NULL},
   {"uAC8Ap", "k", "^", "ph", NULL},
   {"uAC8Bp", "k", "^", "h", NULL},
   {"uAC8Cp", "k", "e", NULL, NULL},
   {"uAC8Dp", "k", "e", "k", NULL},
   {"uAC8Ep", "k", "e", "kGT", NULL},
   {"uAC8Fp", "k", "e", "k", NULL},
   {"uAC90p", "k", "e", "n", NULL},
   {"uAC91p", "k", "e", "n", NULL},
   {"uAC92p", "k", "e", "n", NULL},
   {"uAC93p", "k", "e", "t", NULL},
   {"uAC94p", "k", "e", "l", NULL},
   {"uAC95p", "k", "e", "l", NULL},
   {"uAC96p", "k", "e", "l", NULL},
   {"uAC97p", "k", "e", "l", NULL},
   {"uAC98p", "k", "e", "l", NULL},
   {"uAC99p", "k", "e", "l", NULL},
   {"uAC9Ap", "k", "e", "l", NULL},
   {"uAC9Bp", "k", "e", "l", NULL},
   {"uAC9Cp", "k", "e", "m", NULL},
   {"uAC9Dp", "k", "e", "p", NULL},
   {"uAC9Ep", "k", "e", "p", NULL},
   {"uAC9Fp", "k", "e", "sh", NULL},
   {"uACA0p", "k", "e", "s", NULL},
   {"uACA1p", "k", "e", "N", NULL},
   {"uACA2p", "k", "e", "tS", NULL},
   {"uACA3p", "k", "e", "tSh", NULL},
   {"uACA4p", "k", "e", "kh", NULL},
   {"uACA5p", "k", "e", "th", NULL},
   {"uACA6p", "k", "e", "ph", NULL},
   {"uACA7p", "k", "e", "h", NULL},
   {"uACA8p", "k", "j", "^", NULL},
   {"uACA9p", "k", "j", "^", NULL},
   {"uACAAp", "k", "j", "^", NULL},
   {"uACABp", "k", "j", "^", NULL},
   {"uACACp", "k", "j", "^", NULL},
   {"uACADp", "k", "j", "^", NULL},
   {"uACAEp", "k", "j", "^", NULL},
   {"uACAFp", "k", "j", "^", NULL},
   {"uACB0p", "k", "j", "^", NULL},
   {"uACB1p", "k", "j", "^", NULL},
   {"uACB2p", "k", "j", "^", NULL},
   {"uACB3p", "k", "j", "^", NULL},
   {"uACB4p", "k", "j", "^", NULL},
   {"uACB5p", "k", "j", "^", NULL},
   {"uACB6p", "k", "j", "^", NULL},
   {"uACB7p", "k", "j", "^", NULL},
   {"uACB8p", "k", "j", "^", NULL},
   {"uACB9p", "k", "j", "^", NULL},
   {"uACBAp", "k", "j", "^", NULL},
   {"uACBBp", "k", "j", "^", NULL},
   {"uACBCp", "k", "j", "^", NULL},
   {"uACBDp", "k", "j", "^", NULL},
   {"uACBEp", "k", "j", "^", NULL},
   {"uACBFp", "k", "j", "^", NULL},
   {"uACC1p", "k", "j", "^", NULL},
   {"uACC2p", "k", "j", "^", NULL},
   {"uACC3p", "k", "j", "^", NULL},
   {"uACC4p", "k", "j", "e", NULL},
   {"uACC5p", "k", "j", "e", NULL},
   {"uACC6p", "k", "j", "e", NULL},
   {"uACC7p", "k", "j", "e", NULL},
   {"uACC8p", "k", "j", "e", NULL},
   {"uACC9p", "k", "j", "e", NULL},
   {"uACCAp", "k", "j", "e", NULL},
   {"uACCBp", "k", "j", "e", NULL},
   {"uACCCp", "k", "j", "e", NULL},
   {"uACCDp", "k", "j", "e", NULL},
   {"uACCEp", "k", "j", "e", NULL},
   {"uACCFp", "k", "j", "e", NULL},
   {"uACD1p", "k", "j", "e", NULL},
   {"uACD2p", "k", "j", "e", NULL},
   {"uACD3p", "k", "j", "e", NULL},
   {"uACD4p", "k", "j", "e", NULL},
   {"uACD5p", "k", "j", "e", NULL},
   {"uACD6p", "k", "j", "e", NULL},
   {"uACD7p", "k", "j", "e", NULL},
   {"uACD8p", "k", "j", "e", NULL},
   {"uACD9p", "k", "j", "e", NULL},
   {"uACDAp", "k", "j", "e", NULL},
   {"uACDBp", "k", "j", "e", NULL},
   {"uACDCp", "k", "j", "e", NULL},
   {"uACDDp", "k", "j", "e", NULL},
   {"uACDEp", "k", "j", "e", NULL},
   {"uACDFp", "k", "j", "e", NULL},
   {"uACE0p", "k", "o", NULL, NULL},
   {"uACE1p", "k", "o", "k", NULL},
   {"uACE2p", "k", "o", "kGT", NULL},
   {"uACE3p", "k", "o", "k", NULL},
   {"uACE4p", "k", "o", "n", NULL},
   {"uACE5p", "k", "o", "n", NULL},
   {"uACE6p", "k", "o", "n", NULL},
   {"uACE7p", "k", "o", "t", NULL},
   {"uACE8p", "k", "o", "l", NULL},
   {"uACE9p", "k", "o", "l", NULL},
   {"uACEAp", "k", "o", "l", NULL},
   {"uACEBp", "k", "o", "l", NULL},
   {"uACECp", "k", "o", "l", NULL},
   {"uACEDp", "k", "o", "l", NULL},
   {"uACEEp", "k", "o", "l", NULL},
   {"uACEFp", "k", "o", "l", NULL},
   {"uACF0p", "k", "o", "m", NULL},
   {"uACF1p", "k", "o", "p", NULL},
   {"uACF2p", "k", "o", "p", NULL},
   {"uACF3p", "k", "o", "sh", NULL},
   {"uACF4p", "k", "o", "s", NULL},
   {"uACF5p", "k", "o", "N", NULL},
   {"uACF6p", "k", "o", "tS", NULL},
   {"uACF7p", "k", "o", "tSh", NULL},
   {"uACF8p", "k", "o", "kh", NULL},
   {"uACF9p", "k", "o", "th", NULL},
   {"uACFAp", "k", "o", "ph", NULL},
   {"uACFBp", "k", "o", "h", NULL},
   {"uACFCp", "k", "w", "a", NULL},
   {"uACFDp", "k", "w", "a", NULL},
   {"uACFEp", "k", "w", "a", NULL},
   {"uACFFp", "k", "w", "a", NULL},
   {"uAD00p", "k", "w", "a", NULL},
   {"uAD01p", "k", "w", "a", NULL},
   {"uAD02p", "k", "w", "a", NULL},
   {"uAD03p", "k", "w", "a", NULL},
   {"uAD04p", "k", "w", "a", NULL},
   {"uAD05p", "k", "w", "a", NULL},
   {"uAD06p", "k", "w", "a", NULL},
   {"uAD07p", "k", "w", "a", NULL},
   {"uAD08p", "k", "w", "a", NULL},
   {"uAD09p", "k", "w", "a", NULL},
   {"uAD0Ap", "k", "w", "a", NULL},
   {"uAD0Bp", "k", "w", "a", NULL},
   {"uAD0Cp", "k", "w", "a", NULL},
   {"uAD0Dp", "k", "w", "a", NULL},
   {"uAD0Ep", "k", "w", "a", NULL},
   {"uAD0Fp", "k", "w", "a", NULL},
   {"uAD10p", "k", "w", "a", NULL},
   {"uAD11p", "k", "w", "a", NULL},
   {"uAD12p", "k", "w", "a", NULL},
   {"uAD13p", "k", "w", "a", NULL},
   {"uAD14p", "k", "w", "a", NULL},
   {"uAD15p", "k", "w", "a", NULL},
   {"uAD16p", "k", "w", "a", NULL},
   {"uAD17p", "k", "w", "a", NULL},
   {"uAD18p", "k", "w", "@", NULL},
   {"uAD19p", "k", "w", "@", NULL},
   {"uAD1Ap", "k", "w", "@", NULL},
   {"uAD1Bp", "k", "w", "@", NULL},
   {"uAC1Cp", "k", "w", "@", NULL},
   {"uAD1Dp", "k", "w", "@", NULL},
   {"uAD1Ep", "k", "w", "@", NULL},
   {"uAD1Fp", "k", "w", "@", NULL},
   {"uAD20p", "k", "w", "@", NULL},
   {"uAD21p", "k", "w", "@", NULL},
   {"uAD22p", "k", "w", "@", NULL},
   {"uAD23p", "k", "w", "@", NULL},
   {"uAD24p", "k", "w", "@", NULL},
   {"uAD25p", "k", "w", "@", NULL},
   {"uAD26p", "k", "w", "@", NULL},
   {"uAD27p", "k", "w", "@", NULL},
   {"uAD28p", "k", "w", "@", NULL},
   {"uAD29p", "k", "w", "@", NULL},
   {"uAD2Ap", "k", "w", "@", NULL},
   {"uAD2Bp", "k", "w", "@", NULL},
   {"uAD2Cp", "k", "w", "@", NULL},
   {"uAD2Dp", "k", "w", "@", NULL},
   {"uAD2Ep", "k", "w", "@", NULL},
   {"uAD2Fp", "k", "w", "@", NULL},
   {"uAD30p", "k", "w", "@", NULL},
   {"uAD31p", "k", "w", "@", NULL},
   {"uAD32p", "k", "w", "@", NULL},
   {"uAD33p", "k", "w", "@", NULL},
   {"uAD34p", "k", "w", "e", NULL},
   {"uAD35p", "k", "w", "e", NULL},
   {"uAD36p", "k", "w", "e", NULL},
   {"uAD37p", "k", "w", "e", NULL},
   {"uAD38p", "k", "w", "e", NULL},
   {"uAD39p", "k", "w", "e", NULL},
   {"uAD3Ap", "k", "w", "e", NULL},
   {"uAD3Bp", "k", "w", "e", NULL},
   {"uAD3Cp", "k", "w", "e", NULL},
   {"uAD3Dp", "k", "w", "e", NULL},
   {"uAD3Ep", "k", "w", "e", NULL},
   {"uAD3Fp", "k", "w", "e", NULL},
   {"uAD40p", "k", "w", "e", NULL},
   {"uAD41p", "k", "w", "e", NULL},
   {"uAD42p", "k", "w", "e", NULL},
   {"uAD43p", "k", "w", "e", NULL},
   {"uAD44p", "k", "w", "e", NULL},
   {"uAD45p", "k", "w", "e", NULL},
   {"uAD46p", "k", "w", "e", NULL},
   {"uAD47p", "k", "w", "e", NULL},
   {"uAD48p", "k", "w", "e", NULL},
   {"uAD49p", "k", "w", "e", NULL},
   {"uAD4Ap", "k", "w", "e", NULL},
   {"uAD4Bp", "k", "w", "e", NULL},
   {"uAD4Cp", "k", "w", "e", NULL},
   {"uAD4Dp", "k", "w", "e", NULL},
   {"uAD4Ep", "k", "w", "e", NULL},
   {"uAD4Fp", "k", "w", "e", NULL},
   {"uAD50p", "k", "j", "o", NULL},
   {"uAD51p", "k", "j", "o", NULL},
   {"uAD52p", "k", "j", "o", NULL},
   {"uAD53p", "k", "j", "o", NULL},
   {"uAD54p", "k", "j", "o", NULL},
   {"uAD55p", "k", "j", "o", NULL},
   {"uAD56p", "k", "j", "o", NULL},
   {"uAD57p", "k", "j", "o", NULL},
   {"uAD58p", "k", "j", "o", NULL},
   {"uAD59p", "k", "j", "o", NULL},
   {"uAD5Ap", "k", "j", "o", NULL},
   {"uAD5Bp", "k", "j", "o", NULL},
   {"uAD5Cp", "k", "j", "o", NULL},
   {"uAD5Dp", "k", "j", "o", NULL},
   {"uAD5Ep", "k", "j", "o", NULL},
   {"uAD5Fp", "k", "j", "o", NULL},
   {"uAD60p", "k", "j", "o", NULL},
   {"uAD61p", "k", "j", "o", NULL},
   {"uAD62p", "k", "j", "o", NULL},
   {"uAD63p", "k", "j", "o", NULL},
   {"uAD64p", "k", "j", "o", NULL},
   {"uAD65p", "k", "j", "o", NULL},
   {"uAD66p", "k", "j", "o", NULL},
   {"uAD67p", "k", "j", "o", NULL},
   {"uAD68p", "k", "j", "o", NULL},
   {"uAD69p", "k", "j", "o", NULL},
   {"uAD6Ap", "k", "j", "o", NULL},
   {"uAD6Bp", "k", "j", "o", NULL},
   {"uAD6Cp", "k", "u", NULL, NULL},
   {"uAD6Dp", "k", "u", "k", NULL},
   {"uAD6Ep", "k", "u", "kGT", NULL},
   {"uAD6Fp", "k", "u", "k", NULL},
   {"uAD70p", "k", "u", "n", NULL},
   {"uAD71p", "k", "u", "n", NULL},
   {"uAD72p", "k", "u", "n", NULL},
   {"uAD73p", "k", "u", "t", NULL},
   {"uAD74p", "k", "u", "l", NULL},
   {"uAD75p", "k", "u", "l", NULL},
   {"uAD76p", "k", "u", "l", NULL},
   {"uAD77p", "k", "u", "l", NULL},
   {"uAD78p", "k", "u", "l", NULL},
   {"uAD79p", "k", "u", "l", NULL},
   {"uAD7Ap", "k", "u", "l", NULL},
   {"uAD7Bp", "k", "u", "l", NULL},
   {"uAD7Cp", "k", "u", "m", NULL},
   {"uAD7Dp", "k", "u", "p", NULL},
   {"uAD7Ep", "k", "u", "p", NULL},
   {"uAD7Fp", "k", "u", "sh", NULL},
   {"uAD80p", "k", "u", "s", NULL},
   {"uAD81p", "k", "u", "N", NULL},
   {"uAD82p", "k", "u", "tS", NULL},
   {"uAD83p", "k", "u", "tSh", NULL},
   {"uAD84p", "k", "u", "kh", NULL},
   {"uAD85p", "k", "u", "th", NULL},
   {"uAD86p", "k", "u", "ph", NULL},
   {"uAD87p", "k", "u", "h", NULL},
   {"uAD88p", "k", "w", "^", NULL},
   {"uAD89p", "k", "w", "^", NULL},
   {"uAD8Ap", "k", "w", "^", NULL},
   {"uAD8Bp", "k", "w", "^", NULL},
   {"uAD8Cp", "k", "w", "^", NULL},
   {"uAD8Dp", "k", "w", "^", NULL},
   {"uAD8Ep", "k", "w", "^", NULL},
   {"uAD8Fp", "k", "w", "^", NULL},
   {"uAD90p", "k", "w", "^", NULL},
   {"uAD91p", "k", "w", "^", NULL},
   {"uAD92p", "k", "w", "^", NULL},
   {"uAD93p", "k", "w", "^", NULL},
   {"uAD94p", "k", "w", "^", NULL},
   {"uAD95p", "k", "w", "^", NULL},
   {"uAD96p", "k", "w", "^", NULL},
   {"uAD97p", "k", "w", "^", NULL},
   {"uAD98p", "k", "w", "^", NULL},
   {"uAD99p", "k", "w", "^", NULL},
   {"uAD9Ap", "k", "w", "^", NULL},
   {"uAD9Bp", "k", "w", "^", NULL},
   {"uAD9Cp", "k", "w", "^", NULL},
   {"uAD9Dp", "k", "w", "^", NULL},
   {"uAD9Ep", "k", "w", "^", NULL},
   {"uAD9Fp", "k", "w", "^", NULL},
   {"uADA0p", "k", "w", "^", NULL},
   {"uADA1p", "k", "w", "^", NULL},
   {"uADA2p", "k", "w", "^", NULL},
   {"uADA3p", "k", "w", "^", NULL},
   {"uADA4p", "k", "w", "e", NULL},
   {"uADA5p", "k", "w", "e", NULL},
   {"uADA6p", "k", "w", "e", NULL},
   {"uADA7p", "k", "w", "e", NULL},
   {"uADA8p", "k", "w", "e", NULL},
   {"uADA9p", "k", "w", "e", NULL},
   {"uADAAp", "k", "w", "e", NULL},
   {"uADABp", "k", "w", "e", NULL},
   {"uADACp", "k", "w", "e", NULL},
   {"uADADp", "k", "w", "e", NULL},
   {"uADAEp", "k", "w", "e", NULL},
   {"uADAFp", "k", "w", "e", NULL},
   {"uADB0p", "k", "w", "e", NULL},
   {"uADB1p", "k", "w", "e", NULL},
   {"uADB2p", "k", "w", "e", NULL},
   {"uADB3p", "k", "w", "e", NULL},
   {"uADB4p", "k", "w", "e", NULL},
   {"uADB5p", "k", "w", "e", NULL},
   {"uADB6p", "k", "w", "e", NULL},
   {"uADB7p", "k", "w", "e", NULL},
   {"uADB8p", "k", "w", "e", NULL},
   {"uADB9p", "k", "w", "e", NULL},
   {"uADBAp", "k", "w", "e", NULL},
   {"uADBBp", "k", "w", "e", NULL},
   {"uADBCp", "k", "w", "e", NULL},
   {"uADBDp", "k", "w", "e", NULL},
   {"uADBEp", "k", "w", "e", NULL},
   {"uADBFp", "k", "w", "e", NULL},
   {"uADC0p", "k", "7", NULL, NULL},
   {"uADC1p", "k", "7", "k", NULL},
   {"uADC2p", "k", "7", "kGT", NULL},
   {"uADC3p", "k", "7", "k", NULL},
   {"uADC4p", "k", "7", "n", NULL},
   {"uADC5p", "k", "7", "n", NULL},
   {"uADC6p", "k", "7", "n", NULL},
   {"uADC7p", "k", "7", "t", NULL},
   {"uADC8p", "k", "7", "l", NULL},
   {"uADC9p", "k", "7", "l", NULL},
   {"uADCAp", "k", "7", "l", NULL},
   {"uADCBp", "k", "7", "l", NULL},
   {"uADCCp", "k", "7", "l", NULL},
   {"uADCDp", "k", "7", "l", NULL},
   {"uADCEp", "k", "7", "l", NULL},
   {"uADCFp", "k", "7", "l", NULL},
   {"uADD0p", "k", "7", "m", NULL},
   {"uADD1p", "k", "7", "p", NULL},
   {"uADD2p", "k", "7", "p", NULL},
   {"uADD3p", "k", "7", "sh", NULL},
   {"uADD4p", "k", "7", "s", NULL},
   {"uADD5p", "k", "7", "N", NULL},
   {"uADD6p", "k", "7", "tS", NULL},
   {"uADD7p", "k", "7", "tSh", NULL},
   {"uADD8p", "k", "7", "kh", NULL},
   {"uADD9p", "k", "7", "th", NULL},
   {"uADDAp", "k", "7", "ph", NULL},
   {"uADDBp", "k", "7", "h", NULL},
   {"uADDCp", "k", "j", "u", NULL},
   {"uADDDp", "k", "j", "u", NULL},
   {"uADDEp", "k", "j", "u", NULL},
   {"uADDFp", "k", "j", "u", NULL},
   {"uADE0p", "k", "j", "u", NULL},
   {"uADE1p", "k", "j", "u", NULL},
   {"uADE2p", "k", "j", "u", NULL},
   {"uADE3p", "k", "j", "u", NULL},
   {"uADE4p", "k", "j", "u", NULL},
   {"uADE5p", "k", "j", "u", NULL},
   {"uADE6p", "k", "j", "u", NULL},
   {"uADE7p", "k", "j", "u", NULL},
   {"uADE8p", "k", "j", "u", NULL},
   {"uADE9p", "k", "j", "u", NULL},
   {"uADEAp", "k", "j", "u", NULL},
   {"uADEBp", "k", "j", "u", NULL},
   {"uADECp", "k", "j", "u", NULL},
   {"uADEDp", "k", "j", "u", NULL},
   {"uADEEp", "k", "j", "u", NULL},
   {"uADEFp", "k", "j", "u", NULL},
   {"uADF0p", "k", "j", "u", NULL},
   {"uADF1p", "k", "j", "u", NULL},
   {"uADF2p", "k", "j", "u", NULL},
   {"uADF3p", "k", "j", "u", NULL},
   {"uADF4p", "k", "j", "u", NULL},
   {"uADF5p", "k", "j", "u", NULL},
   {"uADF6p", "k", "j", "u", NULL},
   {"uADF7p", "k", "j", "u", NULL},
   {"uADF8p", "k", "4", NULL, NULL},
   {"uADF9p", "k", "4", "k", NULL},
   {"uADFAp", "k", "4", "kGT", NULL},
   {"uADFBp", "k", "4", "k", NULL},
   {"uADFCp", "k", "4", "n", NULL},
   {"uADFDp", "k", "4", "n", NULL},
   {"uADFEp", "k", "4", "n", NULL},
   {"uADFFp", "k", "4", "t", NULL},
   {"uAE00p", "k", "4", "l", NULL},
   {"uAE01p", "k", "4", "l", NULL},
   {"uAE02p", "k", "4", "l", NULL},
   {"uAE03p", "k", "4", "l", NULL},
   {"uAE04p", "k", "4", "l", NULL},
   {"uAE05p", "k", "4", "l", NULL},
   {"uAE06p", "k", "4", "l", NULL},
   {"uAE07p", "k", "4", "l", NULL},
   {"uAE08p", "k", "4", "m", NULL},
   {"uAE09p", "k", "4", "p", NULL},
   {"uAE0Ap", "k", "4", "p", NULL},
   {"uAE0Bp", "k", "4", "sh", NULL},
   {"uAE0Cp", "k", "4", "s", NULL},
   {"uAE0Dp", "k", "4", "N", NULL},
   {"uAE0Ep", "k", "4", "tS", NULL},
   {"uAE0Fp", "k", "4", "tSh", NULL},
   {"uAE10p", "k", "4", "kh", NULL},
   {"uAE11p", "k", "4", "th", NULL},
   {"uAE12p", "k", "4", "ph", NULL},
   {"uAE13p", "k", "4", "h", NULL},
   {"uAE14p", "k", "4", "j", NULL},
   {"uAE15p", "k", "4", "j", NULL},
   {"uAE16p", "k", "4", "j", NULL},
   {"uAE17p", "k", "4", "j", NULL},
   {"uAE18p", "k", "4", "j", NULL},
   {"uAE19p", "k", "4", "j", NULL},
   {"uAE1Ap", "k", "4", "j", NULL},
   {"uAE1Bp", "k", "4", "j", NULL},
   {"uAE1Cp", "k", "4", "j", NULL},
   {"uAE1Dp", "k", "4", "j", NULL},
   {"uAE1Ep", "k", "4", "j", NULL},
   {"uAE1Fp", "k", "4", "j", NULL},
   {"uAE20p", "k", "4", "j", NULL},
   {"uAE21p", "k", "4", "j", NULL},
   {"uAE22p", "k", "4", "j", NULL},
   {"uAE23p", "k", "4", "j", NULL},
   {"uAE24p", "k", "4", "j", NULL},
   {"uAE25p", "k", "4", "j", NULL},
   {"uAE26p", "k", "4", "j", NULL},
   {"uAE27p", "k", "4", "j", NULL},
   {"uAE28p", "k", "4", "j", NULL},
   {"uAE29p", "k", "4", "j", NULL},
   {"uAE2Ap", "k", "4", "j", NULL},
   {"uAE2Bp", "k", "4", "j", NULL},
   {"uAE2Cp", "k", "4", "j", NULL},
   {"uAE2Dp", "k", "4", "j", NULL},
   {"uAE2Ep", "k", "4", "j", NULL},
   {"uAE2Fp", "k", "4", "j", NULL},
   {"uAE30p", "k", "i", NULL, NULL},
   {"uAE31p", "k", "i", "k", NULL},
   {"uAE32p", "k", "i", "kGT", NULL},
   {"uAE33p", "k", "i", "k", NULL},
   {"uAE34p", "k", "i", "n", NULL},
   {"uAE35p", "k", "i", "n", NULL},
   {"uAE36p", "k", "i", "n", NULL},
   {"uAE37p", "k", "i", "t", NULL},
   {"uAE38p", "k", "i", "l", NULL},
   {"uAE39p", "k", "i", "l", NULL},
   {"uAE3Ap", "k", "i", "l", NULL},
   {"uAE3Bp", "k", "i", "l", NULL},
   {"uAE3Cp", "k", "i", "l", NULL},
   {"uAE3Dp", "k", "i", "l", NULL},
   {"uAE3Ep", "k", "i", "ph", NULL},
   {"uAE3Fp", "k", "i", "l", NULL},
   {"uAE40p", "k", "i", "m", NULL},
   {"uAE41p", "k", "i", "p", NULL},
   {"uAE42p", "k", "i", "p", NULL},
   {"uAE43p", "k", "i", "sh", NULL},
   {"uAE44p", "k", "i", "s", NULL},
   {"uAE45p", "k", "i", "N", NULL},
   {"uAE46p", "k", "i", "tS", NULL},
   {"uAE47p", "k", "i", "tSh", NULL},
   {"uAE48p", "k", "i", "kh", NULL},
   {"uAE49p", "k", "i", "th", NULL},
   {"uAE4Ap", "k", "i", "ph", NULL},
   {"uAE4Bp", "k", "i", "h", NULL},
   {"uAE4Cp", "kGT", "a", NULL, NULL},
   {"uAE4Dp", "kGT", "a", "k", NULL},
   {"uAE4Ep", "kGT", "a", "kGT", NULL},
   {"uAE4Fp", "kGT", "a", "k", NULL},
   {"uAE50p", "kGT", "a", "n", NULL},
   {"uAE51p", "kGT", "a", "n", NULL},
   {"uAE52p", "kGT", "a", "n", NULL},
   {"uAE53p", "kGT", "a", "t", NULL},
   {"uAE54p", "kGT", "a", "l", NULL},
   {"uAE55p", "kGT", "a", "l", NULL},
   {"uAE56p", "kGT", "a", "l", NULL},
   {"uAE57p", "kGT", "a", "l", NULL},
   {"uAE58p", "kGT", "a", "l", NULL},
   {"uAE59p", "kGT", "a", "l", NULL},
   {"uAE5Ap", "kGT", "a", "l", NULL},
   {"uAE5Bp", "kGT", "a", "l", NULL},
   {"uAE5Cp", "kGT", "a", "m", NULL},
   {"uAE5Dp", "kGT", "a", "p", NULL},
   {"uAE5Ep", "kGT", "a", "p", NULL},
   {"uAE5Fp", "kGT", "a", "sh", NULL},
   {"uAE60p", "kGT", "a", "s", NULL},
   {"uAE61p", "kGT", "a", "N", NULL},
   {"uAE62p", "kGT", "a", "tS", NULL},
   {"uAE63p", "kGT", "a", "tSh", NULL},
   {"uAE64p", "kGT", "a", "kh", NULL},
   {"uAE65p", "kGT", "a", "th", NULL},
   {"uAE66p", "kGT", "a", "ph", NULL},
   {"uAE67p", "kGT", "a", "h", NULL},
   {"uAE68p", "kGT", "@", NULL, NULL},
   {"uAE69p", "kGT", "@", "k", NULL},
   {"uAE6Ap", "kGT", "@", "kGT", NULL},
   {"uAE6Bp", "kGT", "@", "k", NULL},
   {"uAE6Cp", "kGT", "@", "n", NULL},
   {"uAE6Dp", "kGT", "@", "n", NULL},
   {"uAE6Ep", "kGT", "@", "n", NULL},
   {"uAE6Fp", "kGT", "@", "t", NULL},
   {"uAE70p", "kGT", "@", "l", NULL},
   {"uAE71p", "kGT", "@", "l", NULL},
   {"uAE72p", "kGT", "@", "l", NULL},
   {"uAE73p", "kGT", "@", "l", NULL},
   {"uAE74p", "kGT", "@", "l", NULL},
   {"uAE75p", "kGT", "@", "l", NULL},
   {"uAE76p", "kGT", "@", "l", NULL},
   {"uAE77p", "kGT", "@", "l", NULL},
   {"uAE78p", "kGT", "@", "m", NULL},
   {"uAE79p", "kGT", "@", "p", NULL},
   {"uAE7Ap", "kGT", "@", "p", NULL},
   {"uAE7Bp", "kGT", "@", "sh", NULL},
   {"uAE7Cp", "kGT", "@", "s", NULL},
   {"uAE7Dp", "kGT", "@", "N", NULL},
   {"uAE7Ep", "kGT", "@", "tS", NULL},
   {"uAE7Fp", "kGT", "@", "tSh", NULL},
   {"uAE80p", "kGT", "@", "kh", NULL},
   {"uAE81p", "kGT", "@", "th", NULL},
   {"uAE82p", "kGT", "@", "ph", NULL},
   {"uAE83p", "kGT", "@", "h", NULL},
   {"uAE84p", "kGT", "j", "a", NULL},
   {"uAE85p", "kGT", "j", "a", NULL},
   {"uAE86p", "kGT", "j", "a", NULL},
   {"uAE87p", "kGT", "j", "a", NULL},
   {"uAE88p", "kGT", "j", "a", NULL},
   {"uAE89p", "kGT", "j", "a", NULL},
   {"uAE8Ap", "kGT", "j", "a", NULL},
   {"uAE8Bp", "kGT", "j", "a", NULL},
   {"uAE8Cp", "kGT", "j", "a", NULL},
   {"uAE8Dp", "kGT", "j", "a", NULL},
   {"uAE8Ep", "kGT", "j", "a", NULL},
   {"uAE8Fp", "kGT", "j", "a", NULL},
   {"uAE90p", "kGT", "j", "a", NULL},
   {"uAE91p", "kGT", "j", "a", NULL},
   {"uAE92p", "kGT", "j", "a", NULL},
   {"uAE93p", "kGT", "j", "a", NULL},
   {"uAE94p", "kGT", "j", "a", NULL},
   {"uAE95p", "kGT", "j", "a", NULL},
   {"uAE96p", "kGT", "j", "a", NULL},
   {"uAE97p", "kGT", "j", "a", NULL},
   {"uAE98p", "kGT", "j", "a", NULL},
   {"uAE99p", "kGT", "j", "a", NULL},
   {"uAE9Ap", "kGT", "j", "a", NULL},
   {"uAE9Bp", "kGT", "j", "a", NULL},
   {"uAE9Cp", "kGT", "j", "a", NULL},
   {"uAE9Dp", "kGT", "j", "a", NULL},
   {"uAE9Ep", "kGT", "j", "a", NULL},
   {"uAE9Fp", "kGT", "j", "a", NULL},
   {"uAEA0p", "kGT", "j", "@", NULL},
   {"uAEA1p", "kGT", "j", "@", NULL},
   {"uAEA2p", "kGT", "j", "@", NULL},
   {"uAEA3p", "kGT", "j", "@", NULL},
   {"uAEA4p", "kGT", "j", "@", NULL},
   {"uAEA5p", "kGT", "j", "@", NULL},
   {"uAEA6p", "kGT", "j", "@", NULL},
   {"uAEA7p", "kGT", "j", "@", NULL},
   {"uAEA8p", "kGT", "j", "@", NULL},
   {"uAEA9p", "kGT", "j", "@", NULL},
   {"uAEAAp", "kGT", "j", "@", NULL},
   {"uAEABp", "kGT", "j", "@", NULL},
   {"uAEACp", "kGT", "j", "@", NULL},
   {"uAEADp", "kGT", "j", "@", NULL},
   {"uAEAEp", "kGT", "j", "@", NULL},
   {"uAEAFp", "kGT", "j", "@", NULL},
   {"uAEB0p", "kGT", "j", "@", NULL},
   {"uAEB1p", "kGT", "j", "@", NULL},
   {"uAEB2p", "kGT", "j", "@", NULL},
   {"uAEB3p", "kGT", "j", "@", NULL},
   {"uAEB4p", "kGT", "j", "@", NULL},
   {"uAEB5p", "kGT", "j", "@", NULL},
   {"uAEB6p", "kGT", "j", "@", NULL},
   {"uAEB7p", "kGT", "j", "@", NULL},
   {"uAEB8p", "kGT", "j", "@", NULL},
   {"uAEB9p", "kGT", "j", "@", NULL},
   {"uAEBAp", "kGT", "j", "@", NULL},
   {"uAEBBp", "kGT", "j", "@", NULL},
   {"uAEBCp", "kGT", "^", NULL, NULL},
   {"uAEBDp", "kGT", "^", "k", NULL},
   {"uAEBEp", "kGT", "^", "kGT", NULL},
   {"uAEBFp", "kGT", "^", "k", NULL},
   {"uAEC0p", "kGT", "^", "n", NULL},
   {"uAEC1p", "kGT", "^", "n", NULL},
   {"uAEC2p", "kGT", "^", "n", NULL},
   {"uAEC3p", "kGT", "^", "t", NULL},
   {"uAEC4p", "kGT", "^", "l", NULL},
   {"uAEC5p", "kGT", "^", "l", NULL},
   {"uAEC6p", "kGT", "^", "l", NULL},
   {"uAEC7p", "kGT", "^", "l", NULL},
   {"uAEC8p", "kGT", "^", "l", NULL},
   {"uAEC9p", "kGT", "^", "l", NULL},
   {"uAECAp", "kGT", "^", "l", NULL},
   {"uAECBp", "kGT", "^", "h", NULL},
   {"uAECCp", "kGT", "^", "m", NULL},
   {"uAECDp", "kGT", "^", "p", NULL},
   {"uAECEp", "kGT", "^", "p", NULL},
   {"uAECFp", "kGT", "^", "sh", NULL},
   {"uAED0p", "kGT", "^", "s", NULL},
   {"uAED1p", "kGT", "^", "N", NULL},
   {"uAED2p", "kGT", "^", "tS", NULL},
   {"uAED3p", "kGT", "^", "tSh", NULL},
   {"uAED4p", "kGT", "^", "kh", NULL},
   {"uAED5p", "kGT", "^", "th", NULL},
   {"uAED6p", "kGT", "^", "ph", NULL},
   {"uAED7p", "kGT", "^", "h", NULL},
   {"uAED8p", "kGT", "e", NULL, NULL},
   {"uAED9p", "kGT", "e", "k", NULL},
   {"uAEDAp", "kGT", "e", "kGT", NULL},
   {"uAEDBp", "kGT", "e", "k", NULL},
   {"uAEDCp", "kGT", "e", "n", NULL},
   {"uAEDDp", "kGT", "e", "n", NULL},
   {"uAEDEp", "kGT", "e", "n", NULL},
   {"uAEDFp", "kGT", "e", "t", NULL},
   {"uAEE0p", "kGT", "e", "l", NULL},
   {"uAEE1p", "kGT", "e", "l", NULL},
   {"uAEE2p", "kGT", "e", "l", NULL},
   {"uAEE3p", "kGT", "e", "l", NULL},
   {"uAEE4p", "kGT", "e", "l", NULL},
   {"uAEE5p", "kGT", "e", "l", NULL},
   {"uAEE6p", "kGT", "e", "l", NULL},
   {"uAEE7p", "kGT", "e", "l", NULL},
   {"uAEE8p", "kGT", "e", "m", NULL},
   {"uAEE9p", "kGT", "e", "p", NULL},
   {"uAEEAp", "kGT", "e", "p", NULL},
   {"uAEEBp", "kGT", "e", "sh", NULL},
   {"uAEECp", "kGT", "e", "s", NULL},
   {"uAEEDp", "kGT", "e", "N", NULL},
   {"uAEEEp", "kGT", "e", "tS", NULL},
   {"uAEEFp", "kGT", "e", "tSh", NULL},
   {"uAEF0p", "kGT", "e", "kh", NULL},
   {"uAEF1p", "kGT", "e", "th", NULL},
   {"uAEF2p", "kGT", "e", "ph", NULL},
   {"uAEF3p", "kGT", "e", "h", NULL},
   {"uAEF4p", "kGT", "j", "^", NULL},
   {"uAEF5p", "kGT", "j", "^", NULL},
   {"uAEF6p", "kGT", "j", "^", NULL},
   {"uAEF7p", "kGT", "j", "^", NULL},
   {"uAEF8p", "kGT", "j", "^", NULL},
   {"uAEF9p", "kGT", "j", "^", NULL},
   {"uAEFAp", "kGT", "j", "^", NULL},
   {"uAEFBp", "kGT", "j", "^", NULL},
   {"uAEFCp", "kGT", "j", "^", NULL},
   {"uAEFDp", "kGT", "j", "^", NULL},
   {"uAEFEp", "kGT", "j", "^", NULL},
   {"uAEFFp", "kGT", "j", "^", NULL},
   {"uAF00p", "kGT", "j", "^", NULL},
   {"uAF01p", "kGT", "j", "^", NULL},
   {"uAF02p", "kGT", "j", "^", NULL},
   {"uAF03p", "kGT", "j", "^", NULL},
   {"uAF04p", "kGT", "j", "^", NULL},
   {"uAF05p", "kGT", "j", "^", NULL},
   {"uAF06p", "kGT", "j", "^", NULL},
   {"uAF07p", "kGT", "j", "@", NULL},
   {"uAF08p", "kGT", "j", "@", NULL},
   {"uAF09p", "kGT", "j", "@", NULL},
   {"uAF0Ap", "kGT", "j", "@", NULL},
   {"uAF0Bp", "kGT", "j", "@", NULL},
   {"uAF0Cp", "kGT", "j", "@", NULL},
   {"uAF0Dp", "kGT", "j", "@", NULL},
   {"uAF0Ep", "kGT", "j", "@", NULL},
   {"uAF0Fp", "kGT", "j", "^", NULL},
   {"uAF10p", "kGT", "j", "e", NULL},
   {"uAF11p", "kGT", "j", "e", NULL},
   {"uAF12p", "kGT", "j", "e", NULL},
   {"uAF13p", "kGT", "j", "e", NULL},
   {"uAF14p", "kGT", "j", "e", NULL},
   {"uAF15p", "kGT", "j", "e", NULL},
   {"uAF16p", "kGT", "j", "e", NULL},
   {"uAF17p", "kGT", "j", "e", NULL},
   {"uAF18p", "kGT", "j", "e", NULL},
   {"uAF19p", "kGT", "j", "e", NULL},
   {"uAF1Ap", "kGT", "j", "e", NULL},
   {"uAF1Bp", "kGT", "j", "e", NULL},
   {"uAF1Cp", "kGT", "j", "e", NULL},
   {"uAF1Dp", "kGT", "j", "e", NULL},
   {"uAF1Ep", "kGT", "j", "e", NULL},
   {"uAF1Fp", "kGT", "j", "e", NULL},
   {"uAF20p", "kGT", "j", "e", NULL},
   {"uAF21p", "kGT", "j", "e", NULL},
   {"uAF22p", "kGT", "j", "e", NULL},
   {"uAF23p", "kGT", "j", "e", NULL},
   {"uAF24p", "kGT", "j", "e", NULL},
   {"uAF25p", "kGT", "j", "e", NULL},
   {"uAF26p", "kGT", "j", "e", NULL},
   {"uAF27p", "kGT", "j", "e", NULL},
   {"uAF28p", "kGT", "j", "e", NULL},
   {"uAF29p", "kGT", "j", "e", NULL},
   {"uAF2Ap", "kGT", "j", "e", NULL},
   {"uAF2Bp", "kGT", "j", "e", NULL},
   {"uAF2Cp", "kGT", "o", NULL, NULL},
   {"uAF2Dp", "kGT", "o", "k", NULL},
   {"uAF2Ep", "kGT", "o", "kGT", NULL},
   {"uAF2Fp", "kGT", "o", "k", NULL},
   {"uAF30p", "kGT", "o", "n", NULL},
   {"uAF31p", "kGT", "o", "n", NULL},
   {"uAF32p", "kGT", "o", "n", NULL},
   {"uAF33p", "kGT", "o", "t", NULL},
   {"uAF34p", "kGT", "o", "l", NULL},
   {"uAF35p", "kGT", "o", "l", NULL},
   {"uAF36p", "kGT", "o", "l", NULL},
   {"uAF37p", "kGT", "o", "l", NULL},
   {"uAF38p", "kGT", "o", "l", NULL},
   {"uAF39p", "kGT", "o", "l", NULL},
   {"uAF3Ap", "kGT", "o", "l", NULL},
   {"uAF3Bp", "kGT", "o", "l", NULL},
   {"uAF3Cp", "kGT", "o", "m", NULL},
   {"uAF3Dp", "kGT", "o", "p", NULL},
   {"uAF3Ep", "kGT", "o", "p", NULL},
   {"uAF3Fp", "kGT", "o", "sh", NULL},
   {"uAF40p", "kGT", "o", "s", NULL},
   {"uAF41p", "kGT", "o", "N", NULL},
   {"uAF42p", "kGT", "o", "tS", NULL},
   {"uAF43p", "kGT", "o", "tSh", NULL},
   {"uAF44p", "kGT", "o", "kh", NULL},
   {"uAF45p", "kGT", "o", "th", NULL},
   {"uAF46p", "kGT", "o", "ph", NULL},
   {"uAF47p", "kGT", "o", "h", NULL},
   {"uAF48p", "kGT", "w", "a", NULL},
   {"uAF49p", "kGT", "w", "a", NULL},
   {"uAF4Ap", "kGT", "w", "a", NULL},
   {"uAF4Bp", "kGT", "w", "a", NULL},
   {"uAF4Cp", "kGT", "w", "a", NULL},
   {"uAF4Dp", "kGT", "w", "a", NULL},
   {"uAF4Ep", "kGT", "w", "a", NULL},
   {"uAF4Fp", "kGT", "w", "a", NULL},
   {"uAF50p", "kGT", "w", "a", NULL},
   {"uAF51p", "kGT", "w", "a", NULL},
   {"uAF52p", "kGT", "w", "a", NULL},
   {"uAF53p", "kGT", "w", "a", NULL},
   {"uAF54p", "kGT", "w", "a", NULL},
   {"uAF55p", "kGT", "w", "a", NULL},
   {"uAF56p", "kGT", "w", "a", NULL},
   {"uAF57p", "kGT", "w", "a", NULL},
   {"uAF58p", "kGT", "w", "a", NULL},
   {"uAF59p", "kGT", "w", "a", NULL},
   {"uAF5Ap", "kGT", "w", "a", NULL},
   {"uAF5Bp", "kGT", "w", "a", NULL},
   {"uAF5Cp", "kGT", "w", "a", NULL},
   {"uAF5Dp", "kGT", "w", "a", NULL},
   {"uAF5Ep", "kGT", "w", "a", NULL},
   {"uAF5Fp", "kGT", "w", "a", NULL},
   {"uAF60p", "kGT", "w", "a", NULL},
   {"uAF61p", "kGT", "w", "a", NULL},
   {"uAF62p", "kGT", "w", "a", NULL},
   {"uAF63p", "kGT", "w", "a", NULL},
   {"uAF64p", "kGT", "w", "@", NULL},
   {"uAF65p", "kGT", "w", "@", NULL},
   {"uAF66p", "kGT", "w", "@", NULL},
   {"uAF67p", "kGT", "w", "@", NULL},
   {"uAF68p", "kGT", "w", "@", NULL},
   {"uAF69p", "kGT", "w", "@", NULL},
   {"uAF6Ap", "kGT", "w", "@", NULL},
   {"uAF6Bp", "kGT", "w", "a", NULL},
   {"uAF6Cp", "kGT", "w", "a", NULL},
   {"uAF6Dp", "kGT", "w", "@", NULL},
   {"uAF6Ep", "kGT", "w", "@", NULL},
   {"uAF6Fp", "kGT", "w", "@", NULL},
   {"uAF70p", "kGT", "w", "@", NULL},
   {"uAF71p", "kGT", "w", "@", NULL},
   {"uAF72p", "kGT", "w", "@", NULL},
   {"uAF73p", "kGT", "w", "@", NULL},
   {"uAF74p", "kGT", "w", "a", NULL},
   {"uAF75p", "kGT", "w", "a", NULL},
   {"uAF76p", "kGT", "w", "@", NULL},
   {"uAF77p", "kGT", "w", "a", NULL},
   {"uAF78p", "kGT", "w", "a", NULL},
   {"uAF79p", "kGT", "w", "a", NULL},
   {"uAF7Ap", "kGT", "w", "a", NULL},
   {"uAF7Bp", "kGT", "w", "@", NULL},
   {"uAF7Cp", "kGT", "w", "@", NULL},
   {"uAF7Dp", "kGT", "w", "@", NULL},
   {"uAF7Ep", "kGT", "w", "@", NULL},
   {"uAF7Fp", "kGT", "w", "@", NULL},
   {"uAF80p", "kGT", "w", "e", NULL},
   {"uAF81p", "kGT", "w", "e", NULL},
   {"uAF82p", "kGT", "w", "e", NULL},
   {"uAF83p", "kGT", "w", "e", NULL},
   {"uAF84p", "kGT", "w", "e", NULL},
   {"uAF85p", "kGT", "w", "e", NULL},
   {"uAF86p", "kGT", "w", "e", NULL},
   {"uAF87p", "kGT", "w", "e", NULL},
   {"uAF88p", "kGT", "w", "e", NULL},
   {"uAF89p", "kGT", "w", "e", NULL},
   {"uAF8Ap", "kGT", "w", "e", NULL},
   {"uAF8Bp", "kGT", "w", "e", NULL},
   {"uAF8Cp", "kGT", "w", "e", NULL},
   {"uAF8Dp", "kGT", "w", "e", NULL},
   {"uAF8Ep", "kGT", "w", "e", NULL},
   {"uAF8Fp", "kGT", "w", "e", NULL},
   {"uAF90p", "kGT", "w", "e", NULL},
   {"uAF91p", "kGT", "w", "e", NULL},
   {"uAF92p", "kGT", "w", "e", NULL},
   {"uAF93p", "kGT", "w", "e", NULL},
   {"uAF94p", "kGT", "w", "e", NULL},
   {"uAF95p", "kGT", "w", "e", NULL},
   {"uAF96p", "kGT", "w", "e", NULL},
   {"uAF97p", "kGT", "w", "e", NULL},
   {"uAF98p", "kGT", "w", "e", NULL},
   {"uAF99p", "kGT", "w", "e", NULL},
   {"uAF9Ap", "kGT", "w", "e", NULL},
   {"uAF9Bp", "kGT", "w", "e", NULL},
   {"uAF9Cp", "kGT", "j", "o", NULL},
   {"uAF9Dp", "kGT", "j", "o", NULL},
   {"uAF9Ep", "kGT", "j", "o", NULL},
   {"uAF9Fp", "kGT", "j", "o", NULL},
   {"uAFA0p", "kGT", "j", "o", NULL},
   {"uAFA1p", "kGT", "j", "o", NULL},
   {"uAFA2p", "kGT", "j", "o", NULL},
   {"uAFA3p", "kGT", "j", "o", NULL},
   {"uAFA4p", "kGT", "j", "o", NULL},
   {"uAFA5p", "kGT", "j", "o", NULL},
   {"uAFA6p", "kGT", "j", "o", NULL},
   {"uAFA7p", "kGT", "j", "o", NULL},
   {"uAFA8p", "kGT", "j", "o", NULL},
   {"uAFA9p", "kGT", "j", "o", NULL},
   {"uAFAAp", "kGT", "j", "o", NULL},
   {"uAFABp", "kGT", "j", "o", NULL},
   {"uAFACp", "kGT", "j", "o", NULL},
   {"uAFADp", "kGT", "j", "o", NULL},
   {"uAFAEp", "kGT", "j", "o", NULL},
   {"uAFAFp", "kGT", "j", "o", NULL},
   {"uAFB0p", "kGT", "j", "o", NULL},
   {"uAFB1p", "kGT", "j", "o", NULL},
   {"uAFB2p", "kGT", "j", "o", NULL},
   {"uAFB3p", "kGT", "j", "o", NULL},
   {"uAFB4p", "kGT", "j", "o", NULL},
   {"uAFB5p", "kGT", "j", "o", NULL},
   {"uAFB6p", "kGT", "j", "o", NULL},
   {"uAFB7p", "kGT", "j", "o", NULL},
   {"uAFB8p", "kGT", "u", NULL, NULL},
   {"uAFB9p", "kGT", "u", "k", NULL},
   {"uAFBAp", "kGT", "u", "kGT", NULL},
   {"uAFBBp", "kGT", "u", "k", NULL},
   {"uAFBCp", "kGT", "u", "n", NULL},
   {"uAFBDp", "kGT", "u", "n", NULL},
   {"uAFBEp", "kGT", "u", "n", NULL},
   {"uAFBFp", "kGT", "u", "t", NULL},
   {"uAFC0p", "kGT", "u", "l", NULL},
   {"uAFC1p", "kGT", "u", "l", NULL},
   {"uAFC2p", "kGT", "u", "l", NULL},
   {"uAFC3p", "kGT", "u", "l", NULL},
   {"uAFC4p", "kGT", "u", "l", NULL},
   {"uAFC5p", "kGT", "u", "l", NULL},
   {"uAFC6p", "kGT", "u", "l", NULL},
   {"uAFC7p", "kGT", "u", "l", NULL},
   {"uAFC8p", "kGT", "u", "m", NULL},
   {"uAFC9p", "kGT", "u", "p", NULL},
   {"uAFCAp", "kGT", "u", "p", NULL},
   {"uAFCBp", "kGT", "u", "sh", NULL},
   {"uAFCCp", "kGT", "u", "s", NULL},
   {"uAFCDp", "kGT", "u", "d", NULL},
   {"uAFCEp", "kGT", "u", "tS", NULL},
   {"uAFCFp", "kGT", "u", "tSh", NULL},
   {"uAFD0p", "kGT", "u", "kh", NULL},
   {"uAFD1p", "kGT", "u", "th", NULL},
   {"uAFD2p", "kGT", "u", "ph", NULL},
   {"uAFD3p", "kGT", "u", "h", NULL},
   {"uAFD4p", "kGT", "w", "^", NULL},
   {"uAFD5p", "kGT", "w", "^", NULL},
   {"uAFD6p", "kGT", "w", "^", NULL},
   {"uAFD7p", "kGT", "w", "^", NULL},
   {"uAFD8p", "kGT", "w", "^", NULL},
   {"uAFD9p", "kGT", "w", "^", NULL},
   {"uAFDAp", "kGT", "w", "^", NULL},
   {"uAFDBp", "kGT", "w", "^", NULL},
   {"uAFDCp", "kGT", "w", "^", NULL},
   {"uAFDDp", "kGT", "w", "^", NULL},
   {"uAFDEp", "kGT", "w", "^", NULL},
   {"uAFDFp", "kGT", "w", "^", NULL},
   {"uAFE0p", "kGT", "w", "^", NULL},
   {"uAFE1p", "kGT", "w", "^", NULL},
   {"uAFE2p", "kGT", "w", "^", NULL},
   {"uAFE3p", "kGT", "w", "^", NULL},
   {"uAFE4p", "kGT", "w", "^", NULL},
   {"uAFE5p", "kGT", "w", "^", NULL},
   {"uAFE6p", "kGT", "w", "^", NULL},
   {"uAFE7p", "kGT", "w", "^", NULL},
   {"uAFE8p", "kGT", "w", "^", NULL},
   {"uAFE9p", "kGT", "w", "^", NULL},
   {"uAFEAp", "kGT", "w", "^", NULL},
   {"uAFEBp", "kGT", "w", "^", NULL},
   {"uAFECp", "kGT", "w", "^", NULL},
   {"uAFEDp", "kGT", "w", "^", NULL},
   {"uAFEEp", "kGT", "w", "^", NULL},
   {"uAFEFp", "kGT", "w", "^", NULL},
   {"uAFF0p", "kGT", "w", "e", NULL},
   {"uAFF1p", "kGT", "w", "e", NULL},
   {"uAFF2p", "kGT", "w", "e", NULL},
   {"uAFF3p", "kGT", "w", "e", NULL},
   {"uAFF4p", "kGT", "w", "e", NULL},
   {"uAFF5p", "kGT", "w", "e", NULL},
   {"uAFF6p", "kGT", "w", "e", NULL},
   {"uAFF7p", "kGT", "w", "e", NULL},
   {"uAFF8p", "kGT", "w", "e", NULL},
   {"uAFF9p", "kGT", "w", "e", NULL},
   {"uAFFAp", "kGT", "w", "e", NULL},
   {"uAFFBp", "kGT", "w", "e", NULL},
   {"uAFFCp", "kGT", "w", "e", NULL},
   {"uAFFDp", "kGT", "w", "e", NULL},
   {"uAFFEp", "kGT", "w", "e", NULL},
   {"uAFFFp", "kGT", "w", "e", NULL},
   {"uB000p", "kGT", "w", "e", NULL},
   {"uB001p", "kGT", "w", "e", NULL},
   {"uB002p", "kGT", "w", "e", NULL},
   {"uB003p", "kGT", "w", "e", NULL},
   {"uB004p", "kGT", "w", "e", NULL},
   {"uB005p", "kGT", "w", "e", NULL},
   {"uB006p", "kGT", "w", "e", NULL},
   {"uB007p", "kGT", "w", "e", NULL},
   {"uB008p", "kGT", "w", "e", NULL},
   {"uB009p", "kGT", "w", "e", NULL},
   {"uB00Ap", "kGT", "w", "e", NULL},
   {"uB00Bp", "kGT", "w", "e", NULL},
   {"uB00Cp", "kGT", "7", NULL, NULL},
   {"uB00Dp", "kGT", "7", "k", NULL},
   {"uB00Ep", "kGT", "7", "kGT", NULL},
   {"uB00Fp", "kGT", "7", "k", NULL},
   {"uB010p", "kGT", "7", "n", NULL},
   {"uB011p", "kGT", "7", "n", NULL},
   {"uB012p", "kGT", "7", "n", NULL},
   {"uB013p", "kGT", "7", "t", NULL},
   {"uB014p", "kGT", "7", "l", NULL},
   {"uB015p", "kGT", "7", "l", NULL},
   {"uB016p", "kGT", "7", "l", NULL},
   {"uB017p", "kGT", "7", "l", NULL},
   {"uB018p", "kGT", "7", "l", NULL},
   {"uB019p", "kGT", "7", "l", NULL},
   {"uB01Ap", "kGT", "7", "l", NULL},
   {"uB01Bp", "kGT", "7", "l", NULL},
   {"uB01Cp", "kGT", "7", "m", NULL},
   {"uB01Dp", "kGT", "7", "p", NULL},
   {"uB01Ep", "kGT", "7", "p", NULL},
   {"uB01Fp", "kGT", "7", "sh", NULL},
   {"uB020p", "kGT", "7", "s", NULL},
   {"uB021p", "kGT", "7", "N", NULL},
   {"uB022p", "kGT", "7", "tS", NULL},
   {"uB023p", "kGT", "7", "tSh", NULL},
   {"uB024p", "kGT", "7", "kh", NULL},
   {"uB025p", "kGT", "7", "th", NULL},
   {"uB026p", "kGT", "7", "ph", NULL},
   {"uB027p", "kGT", "7", "h", NULL},
   {"uB028p", "kGT", "j", "u", NULL},
   {"uB029p", "kGT", "j", "u", NULL},
   {"uB02Ap", "kGT", "j", "u", NULL},
   {"uB02Bp", "kGT", "j", "u", NULL},
   {"uB02Cp", "kGT", "j", "u", NULL},
   {"uB02Dp", "kGT", "j", "u", NULL},
   {"uB02Ep", "kGT", "j", "u", NULL},
   {"uB02Fp", "kGT", "j", "u", NULL},
   {"uB030p", "kGT", "j", "u", NULL},
   {"uB031p", "kGT", "j", "u", NULL},
   {"uB032p", "kGT", "j", "u", NULL},
   {"uB033p", "kGT", "j", "u", NULL},
   {"uB034p", "kGT", "j", "u", NULL},
   {"uB035p", "kGT", "j", "u", NULL},
   {"uB036p", "kGT", "j", "u", NULL},
   {"uB037p", "kGT", "j", "u", NULL},
   {"uB038p", "kGT", "j", "u", NULL},
   {"uB039p", "kGT", "j", "u", NULL},
   {"uB03Ap", "kGT", "j", "u", NULL},
   {"uB03Bp", "kGT", "j", "u", NULL},
   {"uB03Cp", "kGT", "j", "u", NULL},
   {"uB03Dp", "kGT", "j", "u", NULL},
   {"uB03Ep", "kGT", "j", "u", NULL},
   {"uB03Fp", "kGT", "j", "u", NULL},
   {"uB040p", "kGT", "j", "u", NULL},
   {"uB041p", "kGT", "j", "u", NULL},
   {"uB042p", "kGT", "j", "u", NULL},
   {"uB043p", "kGT", "j", "u", NULL},
   {"uB044p", "kGT", "4", NULL, NULL},
   {"uB045p", "kGT", "4", "k", NULL},
   {"uB046p", "kGT", "4", "kGT", NULL},
   {"uB047p", "kGT", "4", "k", NULL},
   {"uB048p", "kGT", "4", "n", NULL},
   {"uB049p", "kGT", "4", "n", NULL},
   {"uB04Ap", "kGT", "4", "n", NULL},
   {"uB04Bp", "kGT", "4", "t", NULL},
   {"uB04Cp", "kGT", "4", "l", NULL},
   {"uB04Dp", "kGT", "4", "l", NULL},
   {"uB04Ep", "kGT", "4", "l", NULL},
   {"uB04Fp", "kGT", "4", "l", NULL},
   {"uB050p", "kGT", "4", "l", NULL},
   {"uB051p", "kGT", "4", "l", NULL},
   {"uB052p", "kGT", "4", "l", NULL},
   {"uB053p", "kGT", "4", "l", NULL},
   {"uB054p", "kGT", "4", "m", NULL},
   {"uB055p", "kGT", "4", "p", NULL},
   {"uB056p", "kGT", "4", "p", NULL},
   {"uB057p", "kGT", "4", "sh", NULL},
   {"uB058p", "kGT", "4", "s", NULL},
   {"uB059p", "kGT", "4", "N", NULL},
   {"uB05Ap", "kGT", "4", "tS", NULL},
   {"uB05Bp", "kGT", "4", "tSh", NULL},
   {"uB05Cp", "kGT", "4", "kh", NULL},
   {"uB05Dp", "kGT", "4", "th", NULL},
   {"uB05Ep", "kGT", "4", "ph", NULL},
   {"uB05Fp", "kGT", "4", "h", NULL},
   {"uB060p", "kGT", "4", "j", NULL},
   {"uB061p", "kGT", "4", "j", NULL},
   {"uB062p", "kGT", "4", "j", NULL},
   {"uB063p", "kGT", "4", "j", NULL},
   {"uB064p", "kGT", "4", "j", NULL},
   {"uB065p", "kGT", "4", "j", NULL},
   {"uB066p", "kGT", "4", "j", NULL},
   {"uB067p", "kGT", "4", "j", NULL},
   {"uB068p", "kGT", "4", "j", NULL},
   {"uB069p", "kGT", "4", "j", NULL},
   {"uB06Ap", "kGT", "4", "j", NULL},
   {"uB06Bp", "kGT", "4", "j", NULL},
   {"uB06Cp", "kGT", "4", "j", NULL},
   {"uB06Dp", "kGT", "4", "j", NULL},
   {"uB06Ep", "kGT", "4", "j", NULL},
   {"uB06Fp", "kGT", "4", "j", NULL},
   {"uB070p", "kGT", "4", "j", NULL},
   {"uB071p", "kGT", "4", "j", NULL},
   {"uB072p", "kGT", "4", "j", NULL},
   {"uB073p", "kGT", "4", "j", NULL},
   {"uB074p", "kGT", "4", "j", NULL},
   {"uB075p", "kGT", "4", "j", NULL},
   {"uB076p", "kGT", "4", "j", NULL},
   {"uB077p", "kGT", "4", "j", NULL},
   {"uB078p", "kGT", "4", "j", NULL},
   {"uB079p", "kGT", "4", "j", NULL},
   {"uB07Ap", "kGT", "4", "j", NULL},
   {"uB07Bp", "kGT", "4", "j", NULL},
   {"uB07Cp", "kGT", "i", NULL, NULL},
   {"uB07Dp", "kGT", "i", "k", NULL},
   {"uB07Ep", "kGT", "i", "kGT", NULL},
   {"uB07Fp", "kGT", "i", "k", NULL},
   {"uB080p", "kGT", "i", "n", NULL},
   {"uB081p", "kGT", "i", "n", NULL},
   {"uB082p", "kGT", "i", "n", NULL},
   {"uB083p", "kGT", "i", "t", NULL},
   {"uB084p", "kGT", "i", "l", NULL},
   {"uB085p", "kGT", "i", "l", NULL},
   {"uB086p", "kGT", "i", "l", NULL},
   {"uB087p", "kGT", "i", "l", NULL},
   {"uB088p", "kGT", "i", "l", NULL},
   {"uB089p", "kGT", "i", "l", NULL},
   {"uB08Ap", "kGT", "i", "l", NULL},
   {"uB08Bp", "kGT", "i", "h", NULL},
   {"uB08Cp", "kGT", "i", "m", NULL},
   {"uB08Dp", "kGT", "i", "p", NULL},
   {"uB08Ep", "kGT", "i", "p", NULL},
   {"uB08Fp", "kGT", "i", "sh", NULL},
   {"uB090p", "kGT", "i", "s", NULL},
   {"uB091p", "kGT", "i", "N", NULL},
   {"uB092p", "kGT", "i", "tS", NULL},
   {"uB093p", "kGT", "i", "tSh", NULL},
   {"uB094p", "kGT", "i", "kh", NULL},
   {"uB095p", "kGT", "i", "th", NULL},
   {"uB096p", "kGT", "i", "ph", NULL},
   {"uB097p", "kGT", "i", "h", NULL},
   {"uB098p", "n", "a", NULL, NULL},
   {"uB099p", "n", "a", "k", NULL},
   {"uB09Ap", "n", "a", "kGT", NULL},
   {"uB09Bp", "n", "a", "k", NULL},
   {"uB09Cp", "n", "a", "n", NULL},
   {"uB09Dp", "n", "a", "n", NULL},
   {"uB09Ep", "n", "a", "n", NULL},
   {"uB09Fp", "n", "a", "t", NULL},
   {"uB0A0p", "n", "a", "l", NULL},
   {"uB0A1p", "n", "a", "l", NULL},
   {"uB0A2p", "n", "a", "l", NULL},
   {"uB0A3p", "n", "a", "l", NULL},
   {"uB0A4p", "n", "a", "l", NULL},
   {"uB0A5p", "n", "a", "l", NULL},
   {"uB0A6p", "n", "a", "l", NULL},
   {"uB0A7p", "n", "a", "l", NULL},
   {"uB0A8p", "n", "a", "m", NULL},
   {"uB0A9p", "n", "a", "p", NULL},
   {"uB0AAp", "n", "a", "p", NULL},
   {"uB0ABp", "n", "a", "sh", NULL},
   {"uB0ACp", "n", "a", "s", NULL},
   {"uB0ADp", "n", "a", "N", NULL},
   {"uB0AEp", "n", "a", "tS", NULL},
   {"uB0AFp", "n", "a", "tSh", NULL},
   {"uB0B0p", "n", "a", "kh", NULL},
   {"uB0B1p", "n", "a", "th", NULL},
   {"uB0B2p", "n", "a", "ph", NULL},
   {"uB0B3p", "n", "a", "h", NULL},
   {"uB0B4p", "n", "@", NULL, NULL},
   {"uB0B5p", "n", "@", "k", NULL},
   {"uB0B6p", "n", "@", "kGT", NULL},
   {"uB0B7p", "n", "@", "k", NULL},
   {"uB0B8p", "n", "@", "n", NULL},
   {"uB0B9p", "n", "@", "n", NULL},
   {"uB0BAp", "n", "@", "n", NULL},
   {"uB0BBp", "n", "@", "t", NULL},
   {"uB0BCp", "n", "@", "l", NULL},
   {"uB0BDp", "n", "@", "l", NULL},
   {"uB0BEp", "n", "@", "l", NULL},
   {"uB0BFp", "n", "@", "l", NULL},
   {"uB0C0p", "n", "@", "l", NULL},
   {"uB0C1p", "n", "@", "l", NULL},
   {"uB0C2p", "n", "@", "l", NULL},
   {"uB0C3p", "n", "@", "l", NULL},
   {"uB0C4p", "n", "@", "m", NULL},
   {"uB0C5p", "n", "@", "p", NULL},
   {"uB0C6p", "n", "@", "p", NULL},
   {"uB0C7p", "n", "@", "sh", NULL},
   {"uB0C8p", "n", "@", "s", NULL},
   {"uB0C9p", "n", "@", "N", NULL},
   {"uB0CAp", "n", "@", "tS", NULL},
   {"uB0CBp", "n", "@", "tSh", NULL},
   {"uB0CCp", "n", "@", "kh", NULL},
   {"uB0CDp", "n", "@", "th", NULL},
   {"uB0CEp", "n", "@", "ph", NULL},
   {"uB0CFp", "n", "@", "h", NULL},
   {"uB0D0p", "n", "j", "a", NULL},
   {"uB0D1p", "n", "j", "a", NULL},
   {"uB0D2p", "n", "j", "a", NULL},
   {"uB0D3p", "n", "j", "a", NULL},
   {"uB0D4p", "n", "j", "a", NULL},
   {"uB0D5p", "n", "j", "a", NULL},
   {"uB0D6p", "n", "j", "a", NULL},
   {"uB0D7p", "n", "j", "a", NULL},
   {"uB0D8p", "n", "j", "a", NULL},
   {"uB0D9p", "n", "j", "a", NULL},
   {"uB0DAp", "n", "j", "a", NULL},
   {"uB0DBp", "n", "j", "a", NULL},
   {"uB0DCp", "n", "j", "a", NULL},
   {"uB0DDp", "n", "j", "a", NULL},
   {"uB0DEp", "n", "j", "a", NULL},
   {"uB0DFp", "n", "j", "a", NULL},
   {"uB0E0p", "n", "j", "a", NULL},
   {"uB0E1p", "n", "j", "a", NULL},
   {"uB0E2p", "n", "j", "a", NULL},
   {"uB0E3p", "n", "j", "a", NULL},
   {"uB0E4p", "n", "j", "a", NULL},
   {"uB0E5p", "n", "j", "a", NULL},
   {"uB0E6p", "n", "j", "a", NULL},
   {"uB0E7p", "n", "j", "a", NULL},
   {"uB0E8p", "n", "j", "a", NULL},
   {"uB0E9p", "n", "j", "a", NULL},
   {"uB0EAp", "n", "j", "a", NULL},
   {"uB0EBp", "n", "j", "a", NULL},
   {"uB0ECp", "n", "j", "@", NULL},
   {"uB0EDp", "n", "j", "@", NULL},
   {"uB0EEp", "n", "j", "@", NULL},
   {"uB0EFp", "n", "j", "@", NULL},
   {"uB0F0p", "n", "j", "@", NULL},
   {"uB0F1p", "n", "j", "@", NULL},
   {"uB0F2p", "n", "j", "@", NULL},
   {"uB0F3p", "n", "j", "@", NULL},
   {"uB0F4p", "n", "j", "@", NULL},
   {"uB0F5p", "n", "j", "@", NULL},
   {"uB0F6p", "n", "j", "@", NULL},
   {"uB0F7p", "n", "j", "@", NULL},
   {"uB0F8p", "n", "j", "@", NULL},
   {"uB0F9p", "n", "j", "@", NULL},
   {"uB0FAp", "n", "j", "@", NULL},
   {"uB0FBp", "n", "j", "@", NULL},
   {"uB0FCp", "n", "j", "@", NULL},
   {"uB0FDp", "n", "j", "@", NULL},
   {"uB0FEp", "n", "j", "@", NULL},
   {"uB0FFp", "n", "j", "@", NULL},
   {"uB100p", "n", "j", "@", NULL},
   {"uB101p", "n", "j", "@", NULL},
   {"uB102p", "n", "j", "@", NULL},
   {"uB103p", "n", "j", "@", NULL},
   {"uB104p", "n", "j", "@", NULL},
   {"uB105p", "n", "j", "@", NULL},
   {"uB106p", "n", "j", "@", NULL},
   {"uB107p", "n", "j", "@", NULL},
   {"uB108p", "n", "^", NULL, NULL},
   {"uB109p", "n", "^", "k", NULL},
   {"uB10Ap", "n", "^", "kGT", NULL},
   {"uB10Bp", "n", "^", "k", NULL},
   {"uB10Cp", "n", "^", "n", NULL},
   {"uB10Dp", "n", "^", "n", NULL},
   {"uB10Ep", "n", "^", "n", NULL},
   {"uB10Fp", "n", "^", "t", NULL},
   {"uB110p", "n", "^", "l", NULL},
   {"uB111p", "n", "^", "l", NULL},
   {"uB112p", "n", "^", "l", NULL},
   {"uB113p", "n", "^", "l", NULL},
   {"uB114p", "n", "^", "l", NULL},
   {"uB115p", "n", "^", "l", NULL},
   {"uB116p", "n", "^", "l", NULL},
   {"uB117p", "n", "^", "h", NULL},
   {"uB118p", "n", "^", "m", NULL},
   {"uB119p", "n", "^", "p", NULL},
   {"uB11Ap", "n", "^", "p", NULL},
   {"uB11Bp", "n", "^", "sh", NULL},
   {"uB11Cp", "n", "^", "s", NULL},
   {"uB11Dp", "n", "^", "N", NULL},
   {"uB11Ep", "n", "^", "tS", NULL},
   {"uB11Fp", "n", "^", "tSh", NULL},
   {"uB120p", "n", "^", "kh", NULL},
   {"uB121p", "n", "^", "th", NULL},
   {"uB122p", "n", "^", "ph", NULL},
   {"uB123p", "n", "^", "h", NULL},
   {"uB124p", "n", "e", NULL, NULL},
   {"uB125p", "n", "e", "k", NULL},
   {"uB126p", "n", "e", "kGT", NULL},
   {"uB127p", "n", "e", "k", NULL},
   {"uB128p", "n", "e", "n", NULL},
   {"uB129p", "n", "e", "n", NULL},
   {"uB12Ap", "n", "e", "n", NULL},
   {"uB12Bp", "n", "e", "t", NULL},
   {"uB12Cp", "n", "e", "l", NULL},
   {"uB12Dp", "n", "e", "l", NULL},
   {"uB12Ep", "n", "e", "l", NULL},
   {"uB12Fp", "n", "e", "l", NULL},
   {"uB130p", "n", "e", "l", NULL},
   {"uB131p", "n", "e", "l", NULL},
   {"uB132p", "n", "e", "l", NULL},
   {"uB133p", "n", "e", "l", NULL},
   {"uB134p", "n", "e", "m", NULL},
   {"uB135p", "n", "e", "p", NULL},
   {"uB136p", "n", "e", "p", NULL},
   {"uB137p", "n", "e", "sh", NULL},
   {"uB138p", "n", "e", "s", NULL},
   {"uB139p", "n", "e", "N", NULL},
   {"uB13Ap", "n", "e", "tS", NULL},
   {"uB13Bp", "n", "e", "tSh", NULL},
   {"uB13Cp", "n", "e", "kh", NULL},
   {"uB13Dp", "n", "e", "th", NULL},
   {"uB13Ep", "n", "e", "ph", NULL},
   {"uB13Fp", "n", "e", "h", NULL},
   {"uB140p", "n", "j", "^", NULL},
   {"uB141p", "n", "j", "^", NULL},
   {"uB142p", "n", "j", "^", NULL},
   {"uB143p", "n", "j", "^", NULL},
   {"uB144p", "n", "j", "^", NULL},
   {"uB145p", "n", "j", "^", NULL},
   {"uB146p", "n", "j", "^", NULL},
   {"uB147p", "n", "j", "^", NULL},
   {"uB148p", "n", "j", "^", NULL},
   {"uB149p", "n", "j", "^", NULL},
   {"uB14Ap", "n", "j", "^", NULL},
   {"uB14Bp", "n", "j", "^", NULL},
   {"uB14Cp", "n", "j", "^", NULL},
   {"uB14Dp", "n", "j", "^", NULL},
   {"uB14Ep", "n", "j", "^", NULL},
   {"uB14Fp", "n", "j", "^", NULL},
   {"uB150p", "n", "j", "^", NULL},
   {"uB151p", "n", "j", "^", NULL},
   {"uB152p", "n", "j", "^", NULL},
   {"uB153p", "n", "j", "^", NULL},
   {"uB154p", "n", "j", "^", NULL},
   {"uB155p", "n", "j", "^", NULL},
   {"uB156p", "n", "j", "^", NULL},
   {"uB157p", "n", "j", "^", NULL},
   {"uB158p", "n", "j", "^", NULL},
   {"uB159p", "n", "j", "^", NULL},
   {"uB15Ap", "n", "j", "^", NULL},
   {"uB15Bp", "n", "j", "^", NULL},
   {"uB15Cp", "n", "j", "e", NULL},
   {"uB15Dp", "n", "j", "e", NULL},
   {"uB15Ep", "n", "j", "e", NULL},
   {"uB15Fp", "n", "j", "e", NULL},
   {"uB160p", "n", "j", "e", NULL},
   {"uB161p", "n", "j", "e", NULL},
   {"uB162p", "n", "j", "e", NULL},
   {"uB163p", "n", "j", "e", NULL},
   {"uB164p", "n", "j", "e", NULL},
   {"uB165p", "n", "j", "e", NULL},
   {"uB166p", "n", "j", "e", NULL},
   {"uB167p", "n", "j", "e", NULL},
   {"uB168p", "n", "j", "e", NULL},
   {"uB169p", "n", "j", "e", NULL},
   {"uB16Ap", "n", "j", "e", NULL},
   {"uB16Bp", "n", "j", "e", NULL},
   {"uB16Cp", "n", "j", "e", NULL},
   {"uB16Dp", "n", "j", "e", NULL},
   {"uB16Ep", "n", "j", "e", NULL},
   {"uB16Fp", "n", "j", "e", NULL},
   {"uB170p", "n", "j", "e", NULL},
   {"uB171p", "n", "j", "e", NULL},
   {"uB172p", "n", "j", "e", NULL},
   {"uB173p", "n", "j", "e", NULL},
   {"uB174p", "n", "j", "e", NULL},
   {"uB175p", "n", "j", "e", NULL},
   {"uB176p", "n", "j", "e", NULL},
   {"uB177p", "n", "j", "e", NULL},
   {"uB178p", "n", "o", NULL, NULL},
   {"uB179p", "n", "o", "k", NULL},
   {"uB17Ap", "n", "o", "kGT", NULL},
   {"uB17Bp", "n", "o", "k", NULL},
   {"uB17Cp", "n", "o", "n", NULL},
   {"uB17Dp", "n", "o", "n", NULL},
   {"uB17Ep", "n", "o", "n", NULL},
   {"uB17Fp", "n", "o", "t", NULL},
   {"uB180p", "n", "o", "l", NULL},
   {"uB181p", "n", "o", "l", NULL},
   {"uB182p", "n", "o", "l", NULL},
   {"uB183p", "n", "o", "l", NULL},
   {"uB184p", "n", "o", "l", NULL},
   {"uB185p", "n", "o", "l", NULL},
   {"uB186p", "n", "o", "l", NULL},
   {"uB187p", "n", "o", "l", NULL},
   {"uB188p", "n", "o", "m", NULL},
   {"uB189p", "n", "o", "p", NULL},
   {"uB18Ap", "n", "o", "p", NULL},
   {"uB18Bp", "n", "o", "sh", NULL},
   {"uB18Cp", "n", "o", "s", NULL},
   {"uB18Dp", "n", "o", "N", NULL},
   {"uB18Ep", "n", "o", "tS", NULL},
   {"uB18Fp", "n", "o", "tSh", NULL},
   {"uB190p", "n", "o", "kh", NULL},
   {"uB191p", "n", "o", "th", NULL},
   {"uB192p", "n", "o", "ph", NULL},
   {"uB193p", "n", "o", "h", NULL},
   {"uB194p", "n", "w", "a", NULL},
   {"uB195p", "n", "w", "a", NULL},
   {"uB196p", "n", "w", "a", NULL},
   {"uB197p", "n", "w", "a", NULL},
   {"uB198p", "n", "w", "a", NULL},
   {"uB199p", "n", "w", "a", NULL},
   {"uB19Ap", "n", "w", "a", NULL},
   {"uB19Bp", "n", "w", "a", NULL},
   {"uB19Cp", "n", "w", "a", NULL},
   {"uB19Dp", "n", "w", "a", NULL},
   {"uB19Ep", "n", "w", "a", NULL},
   {"uB19Fp", "n", "w", "a", NULL},
   {"uB1A0p", "n", "w", "a", NULL},
   {"uB1A1p", "n", "w", "a", NULL},
   {"uB1A2p", "n", "w", "a", NULL},
   {"uB1A3p", "n", "w", "a", NULL},
   {"uB1A4p", "n", "w", "a", NULL},
   {"uB1A5p", "n", "w", "a", NULL},
   {"uB1A6p", "n", "w", "a", NULL},
   {"uB1A7p", "n", "w", "a", NULL},
   {"uB1A8p", "n", "w", "a", NULL},
   {"uB1A9p", "n", "w", "a", NULL},
   {"uB1AAp", "n", "w", "a", NULL},
   {"uB1ABp", "n", "w", "a", NULL},
   {"uB1ACp", "n", "w", "a", NULL},
   {"uB1ADp", "n", "w", "a", NULL},
   {"uB1AEp", "n", "w", "a", NULL},
   {"uB1AFp", "n", "w", "a", NULL},
   {"uB1B0p", "n", "w", "@", NULL},
   {"uB1B1p", "n", "w", "@", NULL},
   {"uB1B2p", "n", "w", "@", NULL},
   {"uB1B3p", "n", "w", "@", NULL},
   {"uB1B4p", "n", "w", "@", NULL},
   {"uB1B5p", "n", "w", "@", NULL},
   {"uB1B6p", "n", "w", "@", NULL},
   {"uB1B7p", "n", "w", "@", NULL},
   {"uB1B8p", "n", "w", "@", NULL},
   {"uB1B9p", "n", "w", "@", NULL},
   {"uB1BAp", "n", "w", "@", NULL},
   {"uB1BBp", "n", "w", "@", NULL},
   {"uB1BCp", "n", "w", "@", NULL},
   {"uB1BDp", "n", "w", "@", NULL},
   {"uB1BEp", "n", "w", "@", NULL},
   {"uB1BFp", "n", "w", "@", NULL},
   {"uB1C0p", "n", "w", "@", NULL},
   {"uB1C1p", "n", "w", "@", NULL},
   {"uB1C2p", "n", "w", "@", NULL},
   {"uB1C3p", "n", "w", "@", NULL},
   {"uB1C4p", "n", "w", "@", NULL},
   {"uB1C5p", "n", "w", "@", NULL},
   {"uB1C6p", "n", "w", "@", NULL},
   {"uB1C7p", "n", "w", "@", NULL},
   {"uB1C8p", "n", "w", "@", NULL},
   {"uB1C9p", "n", "w", "@", NULL},
   {"uB1CAp", "n", "w", "@", NULL},
   {"uB1CBp", "n", "w", "@", NULL},
   {"uB1CCp", "n", "w", "e", NULL},
   {"uB1CDp", "n", "w", "e", NULL},
   {"uB1CEp", "n", "w", "e", NULL},
   {"uB1CFp", "n", "w", "e", NULL},
   {"uB1D0p", "n", "w", "e", NULL},
   {"uB1D1p", "n", "w", "e", NULL},
   {"uB1D2p", "n", "w", "e", NULL},
   {"uB1D3p", "n", "w", "e", NULL},
   {"uB1D4p", "n", "w", "e", NULL},
   {"uB1D5p", "n", "w", "e", NULL},
   {"uB1D6p", "n", "w", "e", NULL},
   {"uB1D7p", "n", "w", "e", NULL},
   {"uB1D8p", "n", "w", "e", NULL},
   {"uB1D9p", "n", "w", "e", NULL},
   {"uB1DAp", "n", "w", "e", NULL},
   {"uB1DBp", "n", "w", "e", NULL},
   {"uB1DCp", "n", "w", "e", NULL},
   {"uB1DDp", "n", "w", "e", NULL},
   {"uB1DEp", "n", "w", "e", NULL},
   {"uB1DFp", "n", "w", "e", NULL},
   {"uB1E0p", "n", "w", "e", NULL},
   {"uB1E1p", "n", "w", "e", NULL},
   {"uB1E2p", "n", "w", "e", NULL},
   {"uB1E3p", "n", "w", "e", NULL},
   {"uB1E4p", "n", "w", "e", NULL},
   {"uB1E5p", "n", "w", "e", NULL},
   {"uB1E6p", "n", "w", "e", NULL},
   {"uB1E7p", "n", "w", "e", NULL},
   {"uB1E8p", "n", "j", "o", NULL},
   {"uB1E9p", "n", "j", "o", NULL},
   {"uB1EAp", "n", "j", "o", NULL},
   {"uB1EBp", "n", "j", "o", NULL},
   {"uB1ECp", "n", "j", "o", NULL},
   {"uB1EDp", "n", "j", "o", NULL},
   {"uB1EEp", "n", "j", "o", NULL},
   {"uB1EFp", "n", "j", "o", NULL},
   {"uB1F0p", "n", "j", "o", NULL},
   {"uB1F1p", "n", "j", "o", NULL},
   {"uB1F2p", "n", "j", "o", NULL},
   {"uB1F3p", "n", "j", "o", NULL},
   {"uB1F4p", "n", "j", "o", NULL},
   {"uB1F5p", "n", "j", "o", NULL},
   {"uB1F6p", "n", "j", "o", NULL},
   {"uB1F7p", "n", "j", "o", NULL},
   {"uB1F8p", "n", "j", "o", NULL},
   {"uB1F9p", "n", "j", "o", NULL},
   {"uB1FAp", "n", "j", "o", NULL},
   {"uB1FBp", "n", "j", "o", NULL},
   {"uB1FCp", "n", "j", "o", NULL},
   {"uB1FDp", "n", "j", "o", NULL},
   {"uB1FEp", "n", "j", "o", NULL},
   {"uB1FFp", "n", "j", "o", NULL},
   {"uB200p", "n", "j", "o", NULL},
   {"uB201p", "n", "j", "o", NULL},
   {"uB202p", "n", "j", "o", NULL},
   {"uB203p", "n", "j", "o", NULL},
   {"uB204p", "n", "u", NULL, NULL},
   {"uB205p", "n", "u", "k", NULL},
   {"uB206p", "n", "u", "kGT", NULL},
   {"uB207p", "n", "u", "k", NULL},
   {"uB208p", "n", "u", "n", NULL},
   {"uB209p", "n", "u", "n", NULL},
   {"uB20Ap", "n", "u", "n", NULL},
   {"uB20Bp", "n", "u", "t", NULL},
   {"uB20Cp", "n", "u", "l", NULL},
   {"uB20Dp", "n", "u", "l", NULL},
   {"uB20Ep", "n", "u", "l", NULL},
   {"uB20Fp", "n", "u", "l", NULL},
   {"uB210p", "n", "u", "l", NULL},
   {"uB211p", "n", "u", "l", NULL},
   {"uB212p", "n", "u", "l", NULL},
   {"uB213p", "n", "u", "l", NULL},
   {"uB214p", "n", "u", "m", NULL},
   {"uB215p", "n", "u", "p", NULL},
   {"uB216p", "n", "u", "p", NULL},
   {"uB217p", "n", "u", "sh", NULL},
   {"uB218p", "n", "u", "s", NULL},
   {"uB219p", "n", "u", "N", NULL},
   {"uB21Ap", "n", "u", "tS", NULL},
   {"uB21Bp", "n", "u", "tSh", NULL},
   {"uB21Cp", "n", "u", "kh", NULL},
   {"uB21Dp", "n", "u", "th", NULL},
   {"uB21Ep", "n", "u", "ph", NULL},
   {"uB21Fp", "n", "u", "h", NULL},
   {"uB220p", "n", "w", "^", NULL},
   {"uB221p", "n", "w", "^", NULL},
   {"uB222p", "n", "w", "^", NULL},
   {"uB223p", "n", "w", "^", NULL},
   {"uB224p", "n", "w", "^", NULL},
   {"uB225p", "n", "w", "^", NULL},
   {"uB226p", "n", "w", "^", NULL},
   {"uB227p", "n", "w", "^", NULL},
   {"uB228p", "n", "w", "^", NULL},
   {"uB229p", "n", "w", "^", NULL},
   {"uB22Ap", "n", "w", "^", NULL},
   {"uB22Bp", "n", "w", "^", NULL},
   {"uB22Cp", "n", "w", "^", NULL},
   {"uB22Dp", "n", "w", "^", NULL},
   {"uB22Ep", "n", "w", "^", NULL},
   {"uB22Fp", "n", "w", "^", NULL},
   {"uB230p", "n", "w", "^", NULL},
   {"uB231p", "n", "w", "^", NULL},
   {"uB232p", "n", "w", "^", NULL},
   {"uB233p", "n", "w", "^", NULL},
   {"uB234p", "n", "w", "^", NULL},
   {"uB235p", "n", "w", "^", NULL},
   {"uB236p", "n", "w", "^", NULL},
   {"uB237p", "n", "w", "^", NULL},
   {"uB238p", "n", "w", "^", NULL},
   {"uB239p", "n", "w", "^", NULL},
   {"uB23Ap", "n", "w", "^", NULL},
   {"uB23Bp", "n", "w", "^", NULL},
   {"uB23Cp", "n", "w", "e", NULL},
   {"uB23Dp", "n", "w", "e", NULL},
   {"uB23Ep", "n", "w", "e", NULL},
   {"uB23Fp", "n", "w", "e", NULL},
   {"uB240p", "n", "w", "e", NULL},
   {"uB241p", "n", "w", "e", NULL},
   {"uB242p", "n", "w", "e", NULL},
   {"uB243p", "n", "w", "e", NULL},
   {"uB244p", "n", "w", "e", NULL},
   {"uB245p", "n", "w", "e", NULL},
   {"uB246p", "n", "w", "e", NULL},
   {"uB247p", "n", "w", "e", NULL},
   {"uB248p", "n", "w", "e", NULL},
   {"uB249p", "n", "w", "e", NULL},
   {"uB24Ap", "n", "w", "e", NULL},
   {"uB24Bp", "n", "w", "e", NULL},
   {"uB24Cp", "n", "w", "e", NULL},
   {"uB24Dp", "n", "w", "e", NULL},
   {"uB24Ep", "n", "w", "e", NULL},
   {"uB24Fp", "n", "w", "e", NULL},
   {"uB250p", "n", "w", "e", NULL},
   {"uB251p", "n", "w", "e", NULL},
   {"uB252p", "n", "w", "e", NULL},
   {"uB253p", "n", "w", "e", NULL},
   {"uB254p", "n", "w", "e", NULL},
   {"uB255p", "n", "w", "e", NULL},
   {"uB256p", "n", "w", "e", NULL},
   {"uB257p", "n", "w", "e", NULL},
   {"uB258p", "n", "7", NULL, NULL},
   {"uB259p", "n", "7", "k", NULL},
   {"uB25Ap", "n", "7", "kGT", NULL},
   {"uB25Bp", "n", "7", "k", NULL},
   {"uB25Cp", "n", "7", "n", NULL},
   {"uB25Dp", "n", "7", "n", NULL},
   {"uB25Ep", "n", "7", "n", NULL},
   {"uB25Fp", "n", "7", "t", NULL},
   {"uB260p", "n", "7", "l", NULL},
   {"uB261p", "n", "7", "l", NULL},
   {"uB262p", "n", "7", "l", NULL},
   {"uB263p", "n", "7", "l", NULL},
   {"uB264p", "n", "7", "l", NULL},
   {"uB265p", "n", "7", "l", NULL},
   {"uB266p", "n", "7", "l", NULL},
   {"uB267p", "n", "7", "h", NULL},
   {"uB268p", "n", "7", "m", NULL},
   {"uB269p", "n", "7", "p", NULL},
   {"uB26Ap", "n", "7", "p", NULL},
   {"uB26Bp", "n", "7", "sh", NULL},
   {"uB26Cp", "n", "7", "s", NULL},
   {"uB26Dp", "n", "7", "N", NULL},
   {"uB26Ep", "n", "7", "tS", NULL},
   {"uB26Fp", "n", "7", "tSh", NULL},
   {"uB270p", "n", "7", "kh", NULL},
   {"uB271p", "n", "7", "th", NULL},
   {"uB272p", "n", "7", "ph", NULL},
   {"uB273p", "n", "7", "h", NULL},
   {"uB274p", "n", "j", "u", NULL},
   {"uB275p", "n", "j", "u", NULL},
   {"uB276p", "n", "j", "u", NULL},
   {"uB277p", "n", "j", "u", NULL},
   {"uB278p", "n", "j", "u", NULL},
   {"uB279p", "n", "j", "u", NULL},
   {"uB27Ap", "n", "j", "u", NULL},
   {"uB27Bp", "n", "j", "u", NULL},
   {"uB27Cp", "n", "j", "u", NULL},
   {"uB27Dp", "n", "j", "u", NULL},
   {"uB27Ep", "n", "j", "u", NULL},
   {"uB27Fp", "n", "j", "u", NULL},
   {"uB280p", "n", "j", "u", NULL},
   {"uB281p", "n", "j", "u", NULL},
   {"uB282p", "n", "j", "u", NULL},
   {"uB283p", "n", "j", "u", NULL},
   {"uB284p", "n", "j", "u", NULL},
   {"uB285p", "n", "j", "u", NULL},
   {"uB286p", "n", "j", "u", NULL},
   {"uB287p", "n", "j", "u", NULL},
   {"uB288p", "n", "j", "u", NULL},
   {"uB289p", "n", "j", "u", NULL},
   {"uB28Ap", "n", "j", "u", NULL},
   {"uB28Bp", "n", "j", "u", NULL},
   {"uB28Cp", "n", "j", "u", NULL},
   {"uB28Dp", "n", "j", "u", NULL},
   {"uB28Ep", "n", "j", "u", NULL},
   {"uB28Fp", "n", "j", "u", NULL},
   {"uB290p", "n", "4", NULL, NULL},
   {"uB291p", "n", "4", "k", NULL},
   {"uB292p", "n", "4", "kGT", NULL},
   {"uB293p", "n", "4", "k", NULL},
   {"uB294p", "n", "4", "n", NULL},
   {"uB295p", "n", "4", "n", NULL},
   {"uB296p", "n", "4", "nh", NULL},
   {"uB297p", "n", "4", "t", NULL},
   {"uB298p", "n", "4", "l", NULL},
   {"uB299p", "n", "4", "l", NULL},
   {"uB29Ap", "n", "4", "l", NULL},
   {"uB29Bp", "n", "4", "l", NULL},
   {"uB29Cp", "n", "4", "l", NULL},
   {"uB29Dp", "n", "4", "l", NULL},
   {"uB29Ep", "n", "4", "l", NULL},
   {"uB29Fp", "n", "4", "l", NULL},
   {"uB2A0p", "n", "4", "m", NULL},
   {"uB2A1p", "n", "4", "p", NULL},
   {"uB2A2p", "n", "4", "p", NULL},
   {"uB2A3p", "n", "4", "sh", NULL},
   {"uB2A4p", "n", "4", "s", NULL},
   {"uB2A5p", "n", "4", "N", NULL},
   {"uB2A6p", "n", "4", "tS", NULL},
   {"uB2A7p", "n", "4", "tSh", NULL},
   {"uB2A8p", "n", "4", "kh", NULL},
   {"uB2A9p", "n", "4", "th", NULL},
   {"uB2AAp", "n", "4", "ph", NULL},
   {"uB2ABp", "n", "4", "h", NULL},
   {"uB2ACp", "n", "4", "j", NULL},
   {"uB2ADp", "n", "4", "j", NULL},
   {"uB2AEp", "n", "4", "j", NULL},
   {"uB2AFp", "n", "4", "j", NULL},
   {"uB2B0p", "n", "4", "j", NULL},
   {"uB2B1p", "n", "4", "j", NULL},
   {"uB2B2p", "n", "4", "j", NULL},
   {"uB2B3p", "n", "4", "j", NULL},
   {"uB2B4p", "n", "4", "j", NULL},
   {"uB2B5p", "n", "4", "j", NULL},
   {"uB2B6p", "n", "4", "j", NULL},
   {"uB2B7p", "n", "4", "j", NULL},
   {"uB2B8p", "n", "4", "j", NULL},
   {"uB2B9p", "n", "4", "j", NULL},
   {"uB2BAp", "n", "4", "j", NULL},
   {"uB2BBp", "n", "4", "j", NULL},
   {"uB2BCp", "n", "4", "j", NULL},
   {"uB2BDp", "n", "4", "j", NULL},
   {"uB2BEp", "n", "4", "j", NULL},
   {"uB2BFp", "n", "4", "j", NULL},
   {"uB2C0p", "n", "4", "j", NULL},
   {"uB2C1p", "n", "4", "j", NULL},
   {"uB2C2p", "n", "4", "j", NULL},
   {"uB2C3p", "n", "4", "j", NULL},
   {"uB2C4p", "n", "4", "j", NULL},
   {"uB2C5p", "n", "4", "j", NULL},
   {"uB2C6p", "n", "4", "j", NULL},
   {"uB2C7p", "n", "4", "j", NULL},
   {"uB2C8p", "n", "i", NULL, NULL},
   {"uB2C9p", "n", "i", "k", NULL},
   {"uB2CAp", "n", "i", "kGT", NULL},
   {"uB2CBp", "n", "i", "k", NULL},
   {"uB2CCp", "n", "i", "n", NULL},
   {"uB2CDp", "n", "i", "n", NULL},
   {"uB2CEp", "n", "i", "n", NULL},
   {"uB2CFp", "n", "i", "t", NULL},
   {"uB2D0p", "n", "i", "l", NULL},
   {"uB2D1p", "n", "i", "l", NULL},
   {"uB2D2p", "n", "i", "l", NULL},
   {"uB2D3p", "n", "i", "l", NULL},
   {"uB2D4p", "n", "i", "l", NULL},
   {"uB2D5p", "n", "i", "l", NULL},
   {"uB2D6p", "n", "i", "l", NULL},
   {"uB2D7p", "n", "i", "l", NULL},
   {"uB2D8p", "n", "i", "m", NULL},
   {"uB2D9p", "n", "i", "p", NULL},
   {"uB2DAp", "n", "i", "p", NULL},
   {"uB2DBp", "n", "i", "sh", NULL},
   {"uB2DCp", "n", "i", "s", NULL},
   {"uB2DDp", "n", "i", "N", NULL},
   {"uB2DEp", "n", "i", "tS", NULL},
   {"uB2DFp", "n", "i", "tSh", NULL},
   {"uB2E0p", "n", "i", "kh", NULL},
   {"uB2E1p", "n", "i", "th", NULL},
   {"uB2E2p", "n", "i", "ph", NULL},
   {"uB2E3p", "n", "i", "h", NULL},
   {"uB2E4p", "t", "a", NULL, NULL},
   {"uB2E5p", "t", "a", "k", NULL},
   {"uB2E6p", "t", "a", "kGT", NULL},
   {"uB2E7p", "t", "a", "k", NULL},
   {"uB2E8p", "t", "a", "n", NULL},
   {"uB2E9p", "t", "a", "n", NULL},
   {"uB2EAp", "t", "a", "n", NULL},
   {"uB2EBp", "t", "a", "t", NULL},
   {"uB2ECp", "t", "a", "l", NULL},
   {"uB2EDp", "t", "a", "l", NULL},
   {"uB2EEp", "t", "a", "l", NULL},
   {"uB2EFp", "t", "a", "l", NULL},
   {"uB2F0p", "t", "a", "l", NULL},
   {"uB2F1p", "t", "a", "l", NULL},
   {"uB2F2p", "t", "a", "l", NULL},
   {"uB2F3p", "t", "a", "l", NULL},
   {"uB2F4p", "t", "a", "m", NULL},
   {"uB2F5p", "t", "a", "p", NULL},
   {"uB2F6p", "t", "a", "p", NULL},
   {"uB2F7p", "t", "a", "sh", NULL},
   {"uB2F8p", "t", "a", "s", NULL},
   {"uB2F9p", "t", "a", "N", NULL},
   {"uB2FAp", "t", "a", "tS", NULL},
   {"uB2FBp", "t", "a", "tSh", NULL},
   {"uB2FCp", "t", "a", "kh", NULL},
   {"uB2FDp", "t", "a", "th", NULL},
   {"uB2FEp", "t", "a", "ph", NULL},
   {"uB2FFp", "t", "a", "h", NULL},
   {"uB300p", "t", "@", NULL, NULL},
   {"uB201p", "t", "@", "k", NULL},
   {"uB302p", "t", "@", "kGT", NULL},
   {"uB303p", "t", "@", "k", NULL},
   {"uB304p", "t", "@", "n", NULL},
   {"uB305p", "t", "@", "n", NULL},
   {"uB306p", "t", "@", "n", NULL},
   {"uB307p", "t", "@", "t", NULL},
   {"uB308p", "t", "@", "l", NULL},
   {"uB309p", "t", "@", "l", NULL},
   {"uB30Ap", "t", "@", "l", NULL},
   {"uB30Bp", "t", "@", "l", NULL},
   {"uB30Cp", "t", "@", "l", NULL},
   {"uB30Dp", "t", "@", "l", NULL},
   {"uB30Ep", "t", "@", "l", NULL},
   {"uB30Fp", "t", "@", "l", NULL},
   {"uB310p", "t", "@", "m", NULL},
   {"uB311p", "t", "@", "p", NULL},
   {"uB312p", "t", "@", "p", NULL},
   {"uB313p", "t", "@", "sh", NULL},
   {"uB314p", "t", "@", "s", NULL},
   {"uB315p", "t", "@", "N", NULL},
   {"uB316p", "t", "@", "tS", NULL},
   {"uB317p", "t", "@", "tSh", NULL},
   {"uB318p", "t", "@", "kh", NULL},
   {"uB319p", "t", "@", "th", NULL},
   {"uB31Ap", "t", "@", "ph", NULL},
   {"uB31Bp", "t", "@", "h", NULL},
   {"uB31Cp", "t", "j", "a", NULL},
   {"uB31Dp", "t", "j", "a", NULL},
   {"uB31Ep", "t", "j", "a", NULL},
   {"uB31Fp", "t", "j", "a", NULL},
   {"uB320p", "t", "j", "a", NULL},
   {"uB321p", "t", "j", "a", NULL},
   {"uB322p", "t", "j", "a", NULL},
   {"uB323p", "t", "j", "a", NULL},
   {"uB324p", "t", "j", "a", NULL},
   {"uB325p", "t", "j", "a", NULL},
   {"uB326p", "t", "j", "a", NULL},
   {"uB327p", "t", "j", "a", NULL},
   {"uB328p", "t", "j", "a", NULL},
   {"uB329p", "t", "j", "a", NULL},
   {"uB32Ap", "t", "j", "a", NULL},
   {"uB32Bp", "t", "j", "a", NULL},
   {"uB32Cp", "t", "j", "a", NULL},
   {"uB32Dp", "t", "j", "a", NULL},
   {"uB32Ep", "t", "j", "a", NULL},
   {"uB32Fp", "t", "j", "a", NULL},
   {"uB330p", "t", "j", "a", NULL},
   {"uB331p", "t", "j", "a", NULL},
   {"uB332p", "t", "j", "a", NULL},
   {"uB333p", "t", "j", "a", NULL},
   {"uB334p", "t", "j", "a", NULL},
   {"uB335p", "t", "j", "a", NULL},
   {"uB336p", "t", "j", "a", NULL},
   {"uB337p", "t", "j", "a", NULL},
   {"uB338p", "t", "j", "@", NULL},
   {"uB339p", "t", "j", "@", NULL},
   {"uB33Ap", "t", "j", "@", NULL},
   {"uB33Bp", "t", "j", "@", NULL},
   {"uB33Cp", "t", "j", "@", NULL},
   {"uB33Dp", "t", "j", "@", NULL},
   {"uB33Ep", "t", "j", "@", NULL},
   {"uB33Fp", "t", "j", "@", NULL},
   {"uB340p", "t", "j", "@", NULL},
   {"uB341p", "t", "j", "@", NULL},
   {"uB342p", "t", "j", "@", NULL},
   {"uB343p", "t", "j", "@", NULL},
   {"uB344p", "t", "j", "@", NULL},
   {"uB345p", "t", "j", "@", NULL},
   {"uB346p", "t", "j", "@", NULL},
   {"uB347p", "t", "j", "@", NULL},
   {"uB348p", "t", "j", "@", NULL},
   {"uB349p", "t", "j", "@", NULL},
   {"uB34Ap", "t", "j", "@", NULL},
   {"uB34Bp", "t", "j", "@", NULL},
   {"uB34Cp", "t", "j", "@", NULL},
   {"uB34Dp", "t", "j", "@", NULL},
   {"uB34Ep", "t", "j", "@", NULL},
   {"uB34Fp", "t", "j", "@", NULL},
   {"uB350p", "t", "j", "@", NULL},
   {"uB351p", "t", "j", "@", NULL},
   {"uB352p", "t", "j", "@", NULL},
   {"uB353p", "t", "j", "@", NULL},
   {"uB354p", "t", "^", NULL, NULL},
   {"uB355p", "t", "^", "k", NULL},
   {"uB356p", "t", "^", "kGT", NULL},
   {"uB357p", "t", "^", "k", NULL},
   {"uB358p", "t", "^", "n", NULL},
   {"uB359p", "t", "^", "n", NULL},
   {"uB35Ap", "t", "^", "n", NULL},
   {"uB35Bp", "t", "^", "t", NULL},
   {"uB35Cp", "t", "^", "l", NULL},
   {"uB35Dp", "t", "^", "l", NULL},
   {"uB35Ep", "t", "^", "l", NULL},
   {"uB35Fp", "t", "^", "l", NULL},
   {"uB360p", "t", "^", "l", NULL},
   {"uB361p", "t", "^", "l", NULL},
   {"uB362p", "t", "^", "l", NULL},
   {"uB363p", "t", "^", "l", NULL},
   {"uB364p", "t", "^", "m", NULL},
   {"uB365p", "t", "^", "p", NULL},
   {"uB366p", "t", "^", "p", NULL},
   {"uB367p", "t", "^", "sh", NULL},
   {"uB368p", "t", "^", "s", NULL},
   {"uB369p", "t", "^", "N", NULL},
   {"uB36Ap", "t", "^", "tS", NULL},
   {"uB36Bp", "t", "^", "tSh", NULL},
   {"uB36Cp", "t", "^", "kh", NULL},
   {"uB36Dp", "t", "^", "th", NULL},
   {"uB36Ep", "t", "^", "ph", NULL},
   {"uB36Fp", "t", "^", "h", NULL},
   {"uB370p", "t", "e", NULL, NULL},
   {"uB371p", "t", "e", "k", NULL},
   {"uB372p", "t", "e", "kGT", NULL},
   {"uB373p", "t", "e", "k", NULL},
   {"uB374p", "t", "e", "n", NULL},
   {"uB375p", "t", "e", "n", NULL},
   {"uB376p", "t", "e", "n", NULL},
   {"uB377p", "t", "e", "t", NULL},
   {"uB378p", "t", "e", "l", NULL},
   {"uB379p", "t", "e", "l", NULL},
   {"uB37Ap", "t", "e", "l", NULL},
   {"uB37Bp", "t", "e", "l", NULL},
   {"uB37Cp", "t", "e", "l", NULL},
   {"uB37Dp", "t", "e", "l", NULL},
   {"uB37Ep", "t", "e", "l", NULL},
   {"uB37Fp", "t", "e", "l", NULL},
   {"uB380p", "t", "e", "m", NULL},
   {"uB381p", "t", "e", "p", NULL},
   {"uB382p", "t", "e", "p", NULL},
   {"uB383p", "t", "e", "sh", NULL},
   {"uB384p", "t", "e", "s", NULL},
   {"uB385p", "t", "e", "N", NULL},
   {"uB386p", "t", "e", "tS", NULL},
   {"uB387p", "t", "e", "tSh", NULL},
   {"uB388p", "t", "e", "kh", NULL},
   {"uB389p", "t", "e", "th", NULL},
   {"uB38Ap", "t", "e", "ph", NULL},
   {"uB38Bp", "t", "e", "h", NULL},
   {"uB38Cp", "t", "j", "^", NULL},
   {"uB38Dp", "t", "j", "^", NULL},
   {"uB38Ep", "t", "j", "^", NULL},
   {"uB38Fp", "t", "j", "^", NULL},
   {"uB390p", "t", "j", "^", NULL},
   {"uB391p", "t", "j", "^", NULL},
   {"uB392p", "t", "j", "^", NULL},
   {"uB393p", "t", "j", "^", NULL},
   {"uB394p", "t", "j", "^", NULL},
   {"uB395p", "t", "j", "^", NULL},
   {"uB396p", "t", "j", "^", NULL},
   {"uB397p", "t", "j", "^", NULL},
   {"uB398p", "t", "j", "^", NULL},
   {"uB399p", "t", "j", "^", NULL},
   {"uB39Ap", "t", "j", "^", NULL},
   {"uB39Bp", "t", "j", "^", NULL},
   {"uB39Cp", "t", "j", "^", NULL},
   {"uB39Dp", "t", "j", "^", NULL},
   {"uB39Ep", "t", "j", "^", NULL},
   {"uB39Fp", "t", "j", "^", NULL},
   {"uB3A0p", "t", "j", "^", NULL},
   {"uB3A1p", "t", "j", "^", NULL},
   {"uB3A2p", "t", "j", "^", NULL},
   {"uB3A3p", "t", "j", "^", NULL},
   {"uB3A4p", "t", "j", "^", NULL},
   {"uB3A5p", "t", "j", "^", NULL},
   {"uB3A6p", "t", "j", "^", NULL},
   {"uB3A7p", "t", "j", "^", NULL},
   {"uB3A8p", "t", "j", "e", NULL},
   {"uB3A9p", "t", "j", "e", NULL},
   {"uB3AAp", "t", "j", "e", NULL},
   {"uB3ABp", "t", "j", "e", NULL},
   {"uB3ACp", "t", "j", "e", NULL},
   {"uB3ADp", "t", "j", "e", NULL},
   {"uB3AEp", "t", "j", "e", NULL},
   {"uB3AFp", "t", "j", "e", NULL},
   {"uB3B0p", "t", "j", "e", NULL},
   {"uB3B1p", "t", "j", "e", NULL},
   {"uB3B2p", "t", "j", "e", NULL},
   {"uB3B3p", "t", "j", "e", NULL},
   {"uB3B4p", "t", "j", "e", NULL},
   {"uB3B5p", "t", "j", "e", NULL},
   {"uB3B6p", "t", "j", "e", NULL},
   {"uB3B7p", "t", "j", "e", NULL},
   {"uB3B8p", "t", "j", "e", NULL},
   {"uB3B9p", "t", "j", "e", NULL},
   {"uB3BAp", "t", "j", "e", NULL},
   {"uB3BBp", "t", "j", "e", NULL},
   {"uB3BCp", "t", "j", "e", NULL},
   {"uB3BDp", "t", "j", "e", NULL},
   {"uB3BEp", "t", "j", "e", NULL},
   {"uB3BFp", "t", "j", "e", NULL},
   {"uB3C0p", "t", "j", "e", NULL},
   {"uB3C1p", "t", "j", "e", NULL},
   {"uB3C2p", "t", "j", "e", NULL},
   {"uB3C3p", "t", "j", "e", NULL},
   {"uB3C4p", "t", "o", NULL, NULL},
   {"uB3C5p", "t", "o", "k", NULL},
   {"uB3C6p", "t", "o", "kGT", NULL},
   {"uB3C7p", "t", "o", "k", NULL},
   {"uB3C8p", "t", "o", "n", NULL},
   {"uB3C9p", "t", "o", "n", NULL},
   {"uB3CAp", "t", "o", "n", NULL},
   {"uB3CBp", "t", "o", "t", NULL},
   {"uB3CCp", "t", "o", "l", NULL},
   {"uB3CDp", "t", "o", "l", NULL},
   {"uB3CEp", "t", "o", "l", NULL},
   {"uB3CFp", "t", "o", "l", NULL},
   {"uB3D0p", "t", "o", "l", NULL},
   {"uB3D1p", "t", "o", "l", NULL},
   {"uB3D2p", "t", "o", "l", NULL},
   {"uB3D3p", "t", "o", "l", NULL},
   {"uB3D4p", "t", "o", "m", NULL},
   {"uB3D5p", "t", "o", "p", NULL},
   {"uB3D6p", "t", "o", "p", NULL},
   {"uB3D7p", "t", "o", "sh", NULL},
   {"uB3D8p", "t", "o", "s", NULL},
   {"uB3D9p", "t", "o", "N", NULL},
   {"uB3DAp", "t", "o", "tS", NULL},
   {"uB3DBp", "t", "o", "tSh", NULL},
   {"uB3DCp", "t", "o", "kh", NULL},
   {"uB3DDp", "t", "o", "th", NULL},
   {"uB3DEp", "t", "o", "ph", NULL},
   {"uB3DFp", "t", "o", "h", NULL},
   {"uB3E0p", "t", "w", "a", NULL},
   {"uB3E1p", "t", "w", "a", NULL},
   {"uB3E2p", "t", "w", "a", NULL},
   {"uB3E3p", "t", "w", "a", NULL},
   {"uB3E4p", "t", "w", "a", NULL},
   {"uB3E5p", "t", "w", "a", NULL},
   {"uB3E6p", "t", "w", "a", NULL},
   {"uB3E7p", "t", "w", "a", NULL},
   {"uB3E8p", "t", "w", "a", NULL},
   {"uB3E9p", "t", "w", "a", NULL},
   {"uB3EAp", "t", "w", "a", NULL},
   {"uB3EBp", "t", "w", "a", NULL},
   {"uB3ECp", "t", "w", "a", NULL},
   {"uB3EDp", "t", "w", "a", NULL},
   {"uB3EEp", "t", "w", "a", NULL},
   {"uB3EFp", "t", "w", "a", NULL},
   {"uB3F0p", "t", "w", "a", NULL},
   {"uB3F1p", "t", "w", "a", NULL},
   {"uB3F2p", "t", "w", "a", NULL},
   {"uB3F3p", "t", "w", "a", NULL},
   {"uB3F4p", "t", "w", "a", NULL},
   {"uB3F5p", "t", "w", "a", NULL},
   {"uB3F6p", "t", "w", "a", NULL},
   {"uB3F7p", "t", "w", "a", NULL},
   {"uB3F8p", "t", "w", "a", NULL},
   {"uB3F9p", "t", "w", "a", NULL},
   {"uB3FAp", "t", "w", "a", NULL},
   {"uB3FBp", "t", "w", "a", NULL},
   {"uB3FCp", "t", "w", "@", NULL},
   {"uB3FDp", "t", "w", "@", NULL},
   {"uB3FEp", "t", "w", "@", NULL},
   {"uB3FFp", "t", "w", "@", NULL},
   {"uB400p", "t", "w", "@", NULL},
   {"uB401p", "t", "w", "@", NULL},
   {"uB402p", "t", "w", "@", NULL},
   {"uB403p", "t", "w", "@", NULL},
   {"uB404p", "t", "w", "@", NULL},
   {"uB405p", "t", "w", "@", NULL},
   {"uB406p", "t", "w", "@", NULL},
   {"uB407p", "t", "w", "@", NULL},
   {"uB408p", "t", "w", "@", NULL},
   {"uB409p", "t", "w", "@", NULL},
   {"uB40Ap", "t", "w", "@", NULL},
   {"uB40Bp", "t", "w", "@", NULL},
   {"uB40Cp", "t", "w", "@", NULL},
   {"uB40Dp", "t", "w", "@", NULL},
   {"uB40Ep", "t", "w", "@", NULL},
   {"uB40Fp", "t", "w", "@", NULL},
   {"uB410p", "t", "w", "@", NULL},
   {"uB411p", "t", "w", "@", NULL},
   {"uB412p", "t", "w", "@", NULL},
   {"uB413p", "t", "w", "@", NULL},
   {"uB414p", "t", "w", "@", NULL},
   {"uB415p", "t", "w", "@", NULL},
   {"uB416p", "t", "w", "@", NULL},
   {"uB417p", "t", "w", "@", NULL},
   {"uB418p", "t", "w", "e", NULL},
   {"uB419p", "t", "w", "e", NULL},
   {"uB41Ap", "t", "w", "e", NULL},
   {"uB41Bp", "t", "w", "e", NULL},
   {"uB41Cp", "t", "w", "e", NULL},
   {"uB41Dp", "t", "w", "e", NULL},
   {"uB41Ep", "t", "w", "e", NULL},
   {"uB41Fp", "t", "w", "e", NULL},
   {"uB420p", "t", "w", "e", NULL},
   {"uB421p", "t", "w", "e", NULL},
   {"uB422p", "t", "w", "e", NULL},
   {"uB423p", "t", "w", "e", NULL},
   {"uB424p", "t", "w", "e", NULL},
   {"uB425p", "t", "w", "e", NULL},
   {"uB426p", "t", "w", "e", NULL},
   {"uB427p", "t", "w", "e", NULL},
   {"uB428p", "t", "w", "e", NULL},
   {"uB429p", "t", "w", "e", NULL},
   {"uB42Ap", "t", "w", "e", NULL},
   {"uB42Bp", "t", "w", "e", NULL},
   {"uB42Cp", "t", "w", "e", NULL},
   {"uB42Dp", "t", "w", "e", NULL},
   {"uB42Ep", "t", "w", "e", NULL},
   {"uB42Fp", "t", "w", "e", NULL},
   {"uB430p", "t", "w", "e", NULL},
   {"uB431p", "t", "w", "e", NULL},
   {"uB432p", "t", "w", "e", NULL},
   {"uB433p", "t", "w", "e", NULL},
   {"uB434p", "t", "j", "o", NULL},
   {"uB435p", "t", "j", "o", NULL},
   {"uB436p", "t", "j", "o", NULL},
   {"uB437p", "t", "j", "o", NULL},
   {"uB438p", "t", "j", "o", NULL},
   {"uB439p", "t", "j", "o", NULL},
   {"uB43Ap", "t", "j", "o", NULL},
   {"uB43Bp", "t", "j", "o", NULL},
   {"uB43Cp", "t", "j", "o", NULL},
   {"uB43Dp", "t", "j", "o", NULL},
   {"uB43Ep", "t", "j", "o", NULL},
   {"uB43Fp", "t", "j", "o", NULL},
   {"uB440p", "t", "j", "o", NULL},
   {"uB441p", "t", "j", "o", NULL},
   {"uB442p", "t", "j", "o", NULL},
   {"uB443p", "t", "j", "o", NULL},
   {"uB444p", "t", "j", "o", NULL},
   {"uB445p", "t", "j", "o", NULL},
   {"uB446p", "t", "j", "o", NULL},
   {"uB447p", "t", "j", "o", NULL},
   {"uB448p", "t", "j", "o", NULL},
   {"uB449p", "t", "j", "o", NULL},
   {"uB44Ap", "t", "j", "o", NULL},
   {"uB44Bp", "t", "j", "o", NULL},
   {"uB44Cp", "t", "j", "o", NULL},
   {"uB44Dp", "t", "j", "o", NULL},
   {"uB44Ep", "t", "j", "o", NULL},
   {"uB44Fp", "t", "j", "o", NULL},
   {"uB450p", "t", "u", NULL, NULL},
   {"uB451p", "t", "u", "k", NULL},
   {"uB452p", "t", "u", "kGT", NULL},
   {"uB453p", "t", "u", "k", NULL},
   {"uB454p", "t", "u", "n", NULL},
   {"uB455p", "t", "u", "n", NULL},
   {"uB456p", "t", "u", "n", NULL},
   {"uB457p", "t", "u", "t", NULL},
   {"uB458p", "t", "u", "l", NULL},
   {"uB459p", "t", "u", "l", NULL},
   {"uB45Ap", "t", "u", "l", NULL},
   {"uB45Bp", "t", "u", "l", NULL},
   {"uB45Cp", "t", "u", "l", NULL},
   {"uB45Dp", "t", "u", "l", NULL},
   {"uB45Ep", "t", "u", "l", NULL},
   {"uB45Fp", "t", "u", "l", NULL},
   {"uB460p", "t", "u", "m", NULL},
   {"uB461p", "t", "u", "p", NULL},
   {"uB462p", "t", "u", "p", NULL},
   {"uB463p", "t", "u", "sh", NULL},
   {"uB464p", "t", "u", "s", NULL},
   {"uB465p", "t", "u", "N", NULL},
   {"uB466p", "t", "u", "tS", NULL},
   {"uB467p", "t", "u", "tSh", NULL},
   {"uB468p", "t", "u", "kh", NULL},
   {"uB469p", "t", "u", "th", NULL},
   {"uB46Ap", "t", "u", "ph", NULL},
   {"uB46Bp", "t", "u", "h", NULL},
   {"uB46Cp", "t", "w", "^", NULL},
   {"uB46Dp", "t", "w", "^", NULL},
   {"uB46Ep", "t", "w", "^", NULL},
   {"uB46Fp", "t", "w", "^", NULL},
   {"uB470p", "t", "w", "^", NULL},
   {"uB471p", "t", "w", "^", NULL},
   {"uB472p", "t", "w", "^", NULL},
   {"uB473p", "t", "w", "^", NULL},
   {"uB474p", "t", "w", "^", NULL},
   {"uB475p", "t", "w", "^", NULL},
   {"uB476p", "t", "w", "^", NULL},
   {"uB477p", "t", "w", "^", NULL},
   {"uB478p", "t", "w", "^", NULL},
   {"uB479p", "t", "w", "^", NULL},
   {"uB47Ap", "t", "w", "^", NULL},
   {"uB47Bp", "t", "w", "^", NULL},
   {"uB47Cp", "t", "w", "^", NULL},
   {"uB47Dp", "t", "w", "^", NULL},
   {"uB47Ep", "t", "w", "^", NULL},
   {"uB47Fp", "t", "w", "^", NULL},
   {"uB480p", "t", "w", "^", NULL},
   {"uB481p", "t", "w", "^", NULL},
   {"uB482p", "t", "w", "^", NULL},
   {"uB483p", "t", "w", "^", NULL},
   {"uB484p", "t", "w", "^", NULL},
   {"uB485p", "t", "w", "^", NULL},
   {"uB486p", "t", "w", "^", NULL},
   {"uB487p", "t", "w", "^", NULL},
   {"uB488p", "t", "w", "e", NULL},
   {"uB489p", "t", "w", "e", NULL},
   {"uB48Ap", "t", "w", "e", NULL},
   {"uB48Bp", "t", "w", "e", NULL},
   {"uB48Cp", "t", "w", "e", NULL},
   {"uB48Dp", "t", "w", "e", NULL},
   {"uB48Ep", "t", "w", "e", NULL},
   {"uB48Fp", "t", "w", "e", NULL},
   {"uB490p", "t", "w", "e", NULL},
   {"uB491p", "t", "w", "e", NULL},
   {"uB492p", "t", "w", "e", NULL},
   {"uB493p", "t", "w", "e", NULL},
   {"uB494p", "t", "w", "e", NULL},
   {"uB495p", "t", "w", "e", NULL},
   {"uB496p", "t", "w", "e", NULL},
   {"uB497p", "t", "w", "e", NULL},
   {"uB498p", "t", "w", "e", NULL},
   {"uB499p", "t", "w", "e", NULL},
   {"uB49Ap", "t", "w", "e", NULL},
   {"uB49Bp", "t", "w", "e", NULL},
   {"uB49Cp", "t", "w", "e", NULL},
   {"uB49Dp", "t", "w", "e", NULL},
   {"uB49Ep", "t", "w", "e", NULL},
   {"uB49Fp", "t", "w", "e", NULL},
   {"uB4A0p", "t", "w", "e", NULL},
   {"uB4A1p", "t", "w", "e", NULL},
   {"uB4A2p", "t", "w", "e", NULL},
   {"uB4A3p", "t", "w", "e", NULL},
   {"uB4A4p", "t", "7", NULL, NULL},
   {"uB4A5p", "t", "7", "k", NULL},
   {"uB4A6p", "t", "7", "kGT", NULL},
   {"uB4A7p", "t", "7", "k", NULL},
   {"uB4A8p", "t", "7", "n", NULL},
   {"uB4A9p", "t", "7", "n", NULL},
   {"uB4AAp", "t", "7", "n", NULL},
   {"uB4ABp", "t", "7", "t", NULL},
   {"uB4ACp", "t", "7", "l", NULL},
   {"uB4ADp", "t", "7", "l", NULL},
   {"uB4AEp", "t", "7", "l", NULL},
   {"uB4AFp", "t", "7", "l", NULL},
   {"uB4B0p", "t", "7", "l", NULL},
   {"uB4B1p", "t", "7", "l", NULL},
   {"uB4B2p", "t", "7", "l", NULL},
   {"uB4B3p", "t", "7", "l", NULL},
   {"uB4B4p", "t", "7", "m", NULL},
   {"uB4B5p", "t", "7", "p", NULL},
   {"uB4B6p", "t", "7", "p", NULL},
   {"uB4B7p", "t", "7", "sh", NULL},
   {"uB4B8p", "t", "7", "s", NULL},
   {"uB4B9p", "t", "7", "N", NULL},
   {"uB4BAp", "t", "7", "tS", NULL},
   {"uB4BBp", "t", "7", "tSh", NULL},
   {"uB4BCp", "t", "7", "kh", NULL},
   {"uB4BDp", "t", "7", "th", NULL},
   {"uB4BEp", "t", "7", "ph", NULL},
   {"uB4BFp", "t", "7", "h", NULL},
   {"uB4C0p", "t", "j", "u", NULL},
   {"uB4C1p", "t", "j", "u", NULL},
   {"uB4C2p", "t", "j", "u", NULL},
   {"uB4C3p", "t", "j", "u", NULL},
   {"uB4C4p", "t", "j", "u", NULL},
   {"uB4C5p", "t", "j", "u", NULL},
   {"uB4C6p", "t", "j", "u", NULL},
   {"uB4C7p", "t", "j", "u", NULL},
   {"uB4C8p", "t", "j", "u", NULL},
   {"uB4C9p", "t", "j", "u", NULL},
   {"uB4CAp", "t", "j", "u", NULL},
   {"uB4CBp", "t", "j", "u", NULL},
   {"uB4CCp", "t", "j", "u", NULL},
   {"uB4CDp", "t", "j", "u", NULL},
   {"uB4CEp", "t", "j", "u", NULL},
   {"uB4CFp", "t", "j", "u", NULL},
   {"uB4D0p", "t", "j", "u", NULL},
   {"uB4D1p", "t", "j", "u", NULL},
   {"uB4D2p", "t", "j", "u", NULL},
   {"uB4B3p", "t", "j", "u", NULL},
   {"uB4D4p", "t", "j", "u", NULL},
   {"uB4D5p", "t", "j", "u", NULL},
   {"uB4D6p", "t", "j", "u", NULL},
   {"uB4D7p", "t", "j", "u", NULL},
   {"uB4D8p", "t", "j", "u", NULL},
   {"uB4D9p", "t", "j", "u", NULL},
   {"uB4DAp", "t", "j", "u", NULL},
   {"uB4DBp", "t", "j", "u", NULL},
   {"uB4DCp", "t", "4", NULL, NULL},
   {"uB4DDp", "t", "4", "k", NULL},
   {"uB4DEp", "t", "4", "kGT", NULL},
   {"uB4DFp", "t", "4", "k", NULL},
   {"uB4E0p", "t", "4", "n", NULL},
   {"uB4E1p", "t", "4", "n", NULL},
   {"uB4E2p", "t", "4", "n", NULL},
   {"uB4E3p", "t", "4", "t", NULL},
   {"uB4E4p", "t", "4", "l", NULL},
   {"uB4E5p", "t", "4", "l", NULL},
   {"uB4E6p", "t", "4", "l", NULL},
   {"uB4E7p", "t", "4", "l", NULL},
   {"uB4E8p", "t", "4", "l", NULL},
   {"uB4E9p", "t", "4", "l", NULL},
   {"uB4EAp", "t", "4", "l", NULL},
   {"uB4EBp", "t", "4", "l", NULL},
   {"uB4ECp", "t", "4", "m", NULL},
   {"uB4EDp", "t", "4", "p", NULL},
   {"uB4EEp", "t", "4", "p", NULL},
   {"uB4EFp", "t", "4", "sh", NULL},
   {"uB4F0p", "t", "4", "s", NULL},
   {"uB4F1p", "t", "4", "N", NULL},
   {"uB4F2p", "t", "4", "tS", NULL},
   {"uB4F3p", "t", "4", "tSh", NULL},
   {"uB4F4p", "t", "4", "kh", NULL},
   {"uB4F5p", "t", "4", "th", NULL},
   {"uB4F6p", "t", "4", "ph", NULL},
   {"uB4F7p", "t", "4", "h", NULL},
   {"uB4F8p", "t", "4", "j", NULL},
   {"uB4F9p", "t", "4", "j", NULL},
   {"uB4FAp", "t", "4", "j", NULL},
   {"uB4FBp", "t", "4", "j", NULL},
   {"uB4FCp", "t", "4", "j", NULL},
   {"uB4FDp", "t", "4", "j", NULL},
   {"uB4FEp", "t", "4", "j", NULL},
   {"uB4FFp", "t", "4", "j", NULL},
   {"uB500p", "t", "4", "j", NULL},
   {"uB501p", "t", "4", "j", NULL},
   {"uB502p", "t", "4", "j", NULL},
   {"uB503p", "t", "4", "j", NULL},
   {"uB504p", "t", "4", "j", NULL},
   {"uB505p", "t", "4", "j", NULL},
   {"uB506p", "t", "4", "j", NULL},
   {"uB507p", "t", "4", "j", NULL},
   {"uB508p", "t", "4", "j", NULL},
   {"uB509p", "t", "4", "j", NULL},
   {"uB50Ap", "t", "4", "j", NULL},
   {"uB50Bp", "t", "4", "j", NULL},
   {"uB50Cp", "t", "4", "j", NULL},
   {"uB50Dp", "t", "4", "j", NULL},
   {"uB50Ep", "t", "4", "j", NULL},
   {"uB50Fp", "t", "4", "j", NULL},
   {"uB510p", "t", "4", "j", NULL},
   {"uB511p", "t", "4", "j", NULL},
   {"uB512p", "t", "4", "j", NULL},
   {"uB513p", "t", "4", "j", NULL},
   {"uB514p", "t", "i", NULL, NULL},
   {"uB515p", "t", "i", "k", NULL},
   {"uB516p", "t", "i", "kGT", NULL},
   {"uB517p", "t", "i", "k", NULL},
   {"uB518p", "t", "i", "n", NULL},
   {"uB519p", "t", "i", "n", NULL},
   {"uB51Ap", "t", "i", "n", NULL},
   {"uB51Bp", "t", "i", "t", NULL},
   {"uB51Cp", "t", "i", "l", NULL},
   {"uB51Dp", "t", "i", "l", NULL},
   {"uB51Ep", "t", "i", "l", NULL},
   {"uB51Fp", "t", "i", "l", NULL},
   {"uB520p", "t", "i", "l", NULL},
   {"uB521p", "t", "i", "l", NULL},
   {"uB522p", "t", "i", "l", NULL},
   {"uB523p", "t", "i", "l", NULL},
   {"uB524p", "t", "i", "m", NULL},
   {"uB525p", "t", "i", "p", NULL},
   {"uB526p", "t", "i", "p", NULL},
   {"uB527p", "t", "i", "sh", NULL},
   {"uB528p", "t", "i", "s", NULL},
   {"uB529p", "t", "i", "N", NULL},
   {"uB52Ap", "t", "i", "tS", NULL},
   {"uB52Bp", "t", "i", "tSh", NULL},
   {"uB52Cp", "t", "i", "kh", NULL},
   {"uB52Dp", "t", "i", "th", NULL},
   {"uB52Ep", "t", "i", "ph", NULL},
   {"uB52Fp", "t", "i", "h", NULL},
   {"uB530p", "tGT", "a", NULL, NULL},
   {"uB531p", "tGT", "a", "k", NULL},
   {"uB532p", "tGT", "a", "kGT", NULL},
   {"uB533p", "tGT", "a", "k", NULL},
   {"uB534p", "tGT", "a", "n", NULL},
   {"uB535p", "tGT", "a", "n", NULL},
   {"uB536p", "tGT", "a", "n", NULL},
   {"uB537p", "tGT", "a", "t", NULL},
   {"uB538p", "tGT", "a", "l", NULL},
   {"uB539p", "tGT", "a", "l", NULL},
   {"uB53Ap", "tGT", "a", "l", NULL},
   {"uB53Bp", "tGT", "a", "l", NULL},
   {"uB53Cp", "tGT", "a", "l", NULL},
   {"uB53Dp", "tGT", "a", "l", NULL},
   {"uB53Ep", "tGT", "a", "l", NULL},
   {"uB53Fp", "tGT", "a", "l", NULL},
   {"uB540p", "tGT", "a", "m", NULL},
   {"uB541p", "tGT", "a", "p", NULL},
   {"uB542p", "tGT", "a", "p", NULL},
   {"uB543p", "tGT", "a", "sh", NULL},
   {"uB544p", "tGT", "a", "s", NULL},
   {"uB545p", "tGT", "a", "N", NULL},
   {"uB546p", "tGT", "a", "tS", NULL},
   {"uB547p", "tGT", "a", "tSh", NULL},
   {"uB548p", "tGT", "a", "kh", NULL},
   {"uB549p", "tGT", "a", "th", NULL},
   {"uB54Ap", "tGT", "a", "ph", NULL},
   {"uB54Bp", "tGT", "a", "h", NULL},
   {"uB54Cp", "tGT", "@", NULL, NULL},
   {"uB54Dp", "tGT", "@", "k", NULL},
   {"uB54Ep", "tGT", "@", "kGT", NULL},
   {"uB54Fp", "tGT", "@", "k", NULL},
   {"uB550p", "tGT", "@", "n", NULL},
   {"uB551p", "tGT", "@", "n", NULL},
   {"uB552p", "tGT", "@", "n", NULL},
   {"uB553p", "tGT", "@", "t", NULL},
   {"uB554p", "tGT", "@", "l", NULL},
   {"uB555p", "tGT", "@", "l", NULL},
   {"uB556p", "tGT", "@", "l", NULL},
   {"uB557p", "tGT", "@", "l", NULL},
   {"uB558p", "tGT", "@", "l", NULL},
   {"uB559p", "tGT", "@", "l", NULL},
   {"uB55Ap", "tGT", "@", "l", NULL},
   {"uB55Bp", "tGT", "@", "l", NULL},
   {"uB55Cp", "tGT", "@", "m", NULL},
   {"uB55Dp", "tGT", "@", "p", NULL},
   {"uB55Ep", "tGT", "@", "p", NULL},
   {"uB55Fp", "tGT", "@", "sh", NULL},
   {"uB560p", "tGT", "@", "s", NULL},
   {"uB561p", "tGT", "@", "N", NULL},
   {"uB562p", "tGT", "@", "tS", NULL},
   {"uB563p", "tGT", "@", "tSh", NULL},
   {"uB564p", "tGT", "@", "kh", NULL},
   {"uB565p", "tGT", "@", "th", NULL},
   {"uB566p", "tGT", "@", "ph", NULL},
   {"uB567p", "tGT", "@", "h", NULL},
   {"uB568p", "tGT", "j", "a", NULL},
   {"uB569p", "tGT", "j", "a", NULL},
   {"uB56Ap", "tGT", "j", "a", NULL},
   {"uB56Bp", "tGT", "j", "a", NULL},
   {"uB56Cp", "tGT", "j", "a", NULL},
   {"uB56Dp", "tGT", "j", "a", NULL},
   {"uB56Ep", "tGT", "j", "a", NULL},
   {"uB56Fp", "tGT", "j", "a", NULL},
   {"uB570p", "tGT", "j", "a", NULL},
   {"uB571p", "tGT", "j", "a", NULL},
   {"uB572p", "tGT", "j", "a", NULL},
   {"uB573p", "tGT", "j", "a", NULL},
   {"uB574p", "tGT", "j", "a", NULL},
   {"uB575p", "tGT", "j", "a", NULL},
   {"uB576p", "tGT", "j", "a", NULL},
   {"uB577p", "tGT", "j", "a", NULL},
   {"uB578p", "tGT", "j", "a", NULL},
   {"uB579p", "tGT", "j", "a", NULL},
   {"uB57Ap", "tGT", "j", "a", NULL},
   {"uB57Bp", "tGT", "j", "a", NULL},
   {"uB57Cp", "tGT", "j", "a", NULL},
   {"uB57Dp", "tGT", "j", "a", NULL},
   {"uB57Ep", "tGT", "j", "a", NULL},
   {"uB57Fp", "tGT", "j", "a", NULL},
   {"uB580p", "tGT", "j", "a", NULL},
   {"uB581p", "tGT", "j", "a", NULL},
   {"uB582p", "tGT", "j", "a", NULL},
   {"uB583p", "tGT", "j", "a", NULL},
   {"uB584p", "tGT", "j", "@", NULL},
   {"uB585p", "tGT", "j", "@", NULL},
   {"uB586p", "tGT", "j", "@", NULL},
   {"uB587p", "tGT", "j", "@", NULL},
   {"uB588p", "tGT", "j", "@", NULL},
   {"uB589p", "tGT", "j", "@", NULL},
   {"uB58Ap", "tGT", "j", "@", NULL},
   {"uB58Bp", "tGT", "j", "@", NULL},
   {"uB58Cp", "tGT", "j", "@", NULL},
   {"uB58Dp", "tGT", "j", "@", NULL},
   {"uB58Ep", "tGT", "j", "@", NULL},
   {"uB58Fp", "tGT", "j", "@", NULL},
   {"uB590p", "tGT", "j", "@", NULL},
   {"uB591p", "tGT", "j", "@", NULL},
   {"uB592p", "tGT", "j", "@", NULL},
   {"uB593p", "tGT", "j", "@", NULL},
   {"uB594p", "tGT", "j", "@", NULL},
   {"uB595p", "tGT", "j", "@", NULL},
   {"uB596p", "tGT", "j", "@", NULL},
   {"uB597p", "tGT", "j", "@", NULL},
   {"uB598p", "tGT", "j", "@", NULL},
   {"uB599p", "tGT", "j", "@", NULL},
   {"uB59Ap", "tGT", "j", "@", NULL},
   {"uB59Bp", "tGT", "j", "@", NULL},
   {"uB59Cp", "tGT", "j", "@", NULL},
   {"uB59Dp", "tGT", "j", "@", NULL},
   {"uB59Ep", "tGT", "j", "@", NULL},
   {"uB59Fp", "tGT", "j", "@", NULL},
   {"uB5A0p", "tGT", "^", NULL, NULL},
   {"uB5A1p", "tGT", "^", "k", NULL},
   {"uB5A2p", "tGT", "^", "kGT", NULL},
   {"uB5A3p", "tGT", "^", "k", NULL},
   {"uB5A4p", "tGT", "^", "n", NULL},
   {"uB5A5p", "tGT", "^", "n", NULL},
   {"uB5A6p", "tGT", "^", "n", NULL},
   {"uB5A7p", "tGT", "^", "t", NULL},
   {"uB5A8p", "tGT", "^", "l", NULL},
   {"uB5A9p", "tGT", "^", "l", NULL},
   {"uB5AAp", "tGT", "^", "l", NULL},
   {"uB5ABp", "tGT", "^", "l", NULL},
   {"uB5ACp", "tGT", "^", "l", NULL},
   {"uB5ADp", "tGT", "^", "l", NULL},
   {"uB5AEp", "tGT", "^", "l", NULL},
   {"uB5AFp", "tGT", "^", "l", NULL},
   {"uB5B0p", "tGT", "^", "m", NULL},
   {"uB5B1p", "tGT", "^", "p", NULL},
   {"uB5B2p", "tGT", "^", "p", NULL},
   {"uB5B3p", "tGT", "^", "sh", NULL},
   {"uB5B4p", "tGT", "^", "s", NULL},
   {"uB5B5p", "tGT", "^", "N", NULL},
   {"uB5B6p", "tGT", "^", "tS", NULL},
   {"uB5B7p", "tGT", "^", "tSh", NULL},
   {"uB5B8p", "tGT", "^", "kh", NULL},
   {"uB5B9p", "tGT", "^", "th", NULL},
   {"uB5BAp", "tGT", "^", "ph", NULL},
   {"uB5BBp", "tGT", "^", "h", NULL},
   {"uB5BCp", "tGT", "e", NULL, NULL},
   {"uB5BDp", "tGT", "e", "k", NULL},
   {"uB5BEp", "tGT", "e", "kGT", NULL},
   {"uB5BFp", "tGT", "e", "k", NULL},
   {"uB5C0p", "tGT", "e", "n", NULL},
   {"uB5C1p", "tGT", "e", "n", NULL},
   {"uB5C2p", "tGT", "e", "n", NULL},
   {"uB5C3p", "tGT", "e", "t", NULL},
   {"uB5C4p", "tGT", "e", "l", NULL},
   {"uB5C5p", "tGT", "e", "l", NULL},
   {"uB5C6p", "tGT", "e", "l", NULL},
   {"uB5C7p", "tGT", "e", "l", NULL},
   {"uB5C8p", "tGT", "e", "l", NULL},
   {"uB5C9p", "tGT", "e", "l", NULL},
   {"uB5CAp", "tGT", "e", "l", NULL},
   {"uB5CBp", "tGT", "e", "l", NULL},
   {"uB5CCp", "tGT", "e", "m", NULL},
   {"uB5CDp", "tGT", "e", "p", NULL},
   {"uB5CEp", "tGT", "e", "p", NULL},
   {"uB5CFp", "tGT", "e", "sh", NULL},
   {"uB5D0p", "tGT", "e", "s", NULL},
   {"uB5D1p", "tGT", "e", "N", NULL},
   {"uB5D2p", "tGT", "e", "tS", NULL},
   {"uB5D3p", "tGT", "e", "tSh", NULL},
   {"uB5D4p", "tGT", "e", "kh", NULL},
   {"uB5D5p", "tGT", "e", "th", NULL},
   {"uB5D6p", "tGT", "e", "ph", NULL},
   {"uB5D7p", "tGT", "e", "h", NULL},
   {"uB5D8p", "tGT", "j", "^", NULL},
   {"uB5D9p", "tGT", "j", "^", NULL},
   {"uB5DAp", "tGT", "j", "^", NULL},
   {"uB5DBp", "tGT", "j", "^", NULL},
   {"uB5DCp", "tGT", "j", "^", NULL},
   {"uB5DDp", "tGT", "j", "^", NULL},
   {"uB5DEp", "tGT", "j", "^", NULL},
   {"uB5DFp", "tGT", "j", "^", NULL},
   {"uB5E0p", "tGT", "j", "^", NULL},
   {"uB5E1p", "tGT", "j", "^", NULL},
   {"uB5E2p", "tGT", "j", "^", NULL},
   {"uB5E3p", "tGT", "j", "^", NULL},
   {"uB5E4p", "tGT", "j", "^", NULL},
   {"uB5E5p", "tGT", "j", "^", NULL},
   {"uB5E6p", "tGT", "j", "^", NULL},
   {"uB5E7p", "tGT", "j", "^", NULL},
   {"uB5E8p", "tGT", "j", "^", NULL},
   {"uB5E9p", "tGT", "j", "^", NULL},
   {"uB5EAp", "tGT", "j", "^", NULL},
   {"uB5EBp", "tGT", "j", "^", NULL},
   {"uB5ECp", "tGT", "j", "^", NULL},
   {"uB5EDp", "tGT", "j", "^", NULL},
   {"uB5EEp", "tGT", "j", "^", NULL},
   {"uB5EFp", "tGT", "j", "^", NULL},
   {"uB5F0p", "tGT", "j", "^", NULL},
   {"uB5F1p", "tGT", "j", "^", NULL},
   {"uB5F2p", "tGT", "j", "^", NULL},
   {"uB5F3p", "tGT", "j", "^", NULL},
   {"uB5F4p", "tGT", "j", "e", NULL},
   {"uB5F5p", "tGT", "j", "e", NULL},
   {"uB5F6p", "tGT", "j", "e", NULL},
   {"uB5F7p", "tGT", "j", "e", NULL},
   {"uB5F8p", "tGT", "j", "e", NULL},
   {"uB5F9p", "tGT", "j", "e", NULL},
   {"uB5FAp", "tGT", "j", "e", NULL},
   {"uB5FBp", "tGT", "j", "e", NULL},
   {"uB5FCp", "tGT", "j", "e", NULL},
   {"uB5FDp", "tGT", "j", "e", NULL},
   {"uB5FEp", "tGT", "j", "e", NULL},
   {"uB5FFp", "tGT", "j", "e", NULL},
   {"uB600p", "tGT", "j", "e", NULL},
   {"uB601p", "tGT", "j", "e", NULL},
   {"uB602p", "tGT", "j", "e", NULL},
   {"uB603p", "tGT", "j", "e", NULL},
   {"uB604p", "tGT", "j", "e", NULL},
   {"uB605p", "tGT", "j", "e", NULL},
   {"uB606p", "tGT", "j", "e", NULL},
   {"uB607p", "tGT", "j", "e", NULL},
   {"uB608p", "tGT", "j", "e", NULL},
   {"uB609p", "tGT", "j", "e", NULL},
   {"uB60Ap", "tGT", "j", "e", NULL},
   {"uB60Bp", "tGT", "j", "e", NULL},
   {"uB60Cp", "tGT", "j", "e", NULL},
   {"uB60Dp", "tGT", "j", "e", NULL},
   {"uB60Ep", "tGT", "j", "e", NULL},
   {"uB60Fp", "tGT", "j", "e", NULL},
   {"uB610p", "tGT", "o", NULL, NULL},
   {"uB611p", "tGT", "o", "k", NULL},
   {"uB612p", "tGT", "o", "kGT", NULL},
   {"uB613p", "tGT", "o", "k", NULL},
   {"uB614p", "tGT", "o", "n", NULL},
   {"uB615p", "tGT", "o", "n", NULL},
   {"uB616p", "tGT", "o", "n", NULL},
   {"uB617p", "tGT", "o", "t", NULL},
   {"uB618p", "tGT", "o", "l", NULL},
   {"uB619p", "tGT", "o", "l", NULL},
   {"uB61Ap", "tGT", "o", "l", NULL},
   {"uB61Bp", "tGT", "o", "l", NULL},
   {"uB61Cp", "tGT", "o", "l", NULL},
   {"uB61Dp", "tGT", "o", "l", NULL},
   {"uB61Ep", "tGT", "o", "l", NULL},
   {"uB61Fp", "tGT", "o", "l", NULL},
   {"uB620p", "tGT", "o", "m", NULL},
   {"uB621p", "tGT", "o", "p", NULL},
   {"uB622p", "tGT", "o", "p", NULL},
   {"uB623p", "tGT", "o", "sh", NULL},
   {"uB624p", "tGT", "o", "s", NULL},
   {"uB625p", "tGT", "o", "N", NULL},
   {"uB626p", "tGT", "o", "tS", NULL},
   {"uB627p", "tGT", "o", "tSh", NULL},
   {"uB628p", "tGT", "o", "kh", NULL},
   {"uB629p", "tGT", "o", "th", NULL},
   {"uB62Ap", "tGT", "o", "ph", NULL},
   {"uB62Bp", "tGT", "o", "h", NULL},
   {"uB62Cp", "tGT", "w", "a", NULL},
   {"uB62Dp", "tGT", "w", "a", NULL},
   {"uB62Ep", "tGT", "w", "a", NULL},
   {"uB62Fp", "tGT", "w", "a", NULL},
   {"uB630p", "tGT", "w", "a", NULL},
   {"uB631p", "tGT", "w", "a", NULL},
   {"uB632p", "tGT", "w", "a", NULL},
   {"uB633p", "tGT", "w", "a", NULL},
   {"uB634p", "tGT", "w", "a", NULL},
   {"uB635p", "tGT", "w", "a", NULL},
   {"uB636p", "tGT", "w", "a", NULL},
   {"uB637p", "tGT", "w", "a", NULL},
   {"uB638p", "tGT", "w", "a", NULL},
   {"uB639p", "tGT", "w", "a", NULL},
   {"uB63Ap", "tGT", "w", "a", NULL},
   {"uB63Bp", "tGT", "w", "a", NULL},
   {"uB63Cp", "tGT", "w", "a", NULL},
   {"uB63Dp", "tGT", "w", "a", NULL},
   {"uB63Ep", "tGT", "w", "a", NULL},
   {"uB63Fp", "tGT", "w", "a", NULL},
   {"uB640p", "tGT", "w", "a", NULL},
   {"uB641p", "tGT", "w", "a", NULL},
   {"uB642p", "tGT", "w", "a", NULL},
   {"uB643p", "tGT", "w", "a", NULL},
   {"uB644p", "tGT", "w", "a", NULL},
   {"uB645p", "tGT", "w", "a", NULL},
   {"uB646p", "tGT", "w", "a", NULL},
   {"uB647p", "tGT", "w", "a", NULL},
   {"uB648p", "tGT", "w", "@", NULL},
   {"uB649p", "tGT", "w", "@", NULL},
   {"uB64Ap", "tGT", "w", "@", NULL},
   {"uB64Bp", "tGT", "w", "@", NULL},
   {"uB64Cp", "tGT", "w", "@", NULL},
   {"uB64Dp", "tGT", "w", "@", NULL},
   {"uB64Ep", "tGT", "w", "@", NULL},
   {"uB64Fp", "tGT", "w", "@", NULL},
   {"uB650p", "tGT", "w", "@", NULL},
   {"uB651p", "tGT", "w", "@", NULL},
   {"uB652p", "tGT", "w", "@", NULL},
   {"uB653p", "tGT", "w", "@", NULL},
   {"uB654p", "tGT", "w", "@", NULL},
   {"uB655p", "tGT", "w", "@", NULL},
   {"uB656p", "tGT", "w", "@", NULL},
   {"uB657p", "tGT", "w", "@", NULL},
   {"uB658p", "tGT", "w", "@", NULL},
   {"uB659p", "tGT", "w", "@", NULL},
   {"uB65Ap", "tGT", "w", "@", NULL},
   {"uB65Bp", "tGT", "w", "@", NULL},
   {"uB65Cp", "tGT", "w", "@", NULL},
   {"uB65Dp", "tGT", "w", "@", NULL},
   {"uB65Ep", "tGT", "w", "@", NULL},
   {"uB65Fp", "tGT", "w", "@", NULL},
   {"uB660p", "tGT", "w", "@", NULL},
   {"uB661p", "tGT", "w", "@", NULL},
   {"uB662p", "tGT", "w", "@", NULL},
   {"uB663p", "tGT", "w", "@", NULL},
   {"uB664p", "tGT", "w", "e", NULL},
   {"uB665p", "tGT", "w", "e", NULL},
   {"uB666p", "tGT", "w", "e", NULL},
   {"uB667p", "tGT", "w", "e", NULL},
   {"uB668p", "tGT", "w", "e", NULL},
   {"uB669p", "tGT", "w", "e", NULL},
   {"uB66Ap", "tGT", "w", "e", NULL},
   {"uB66Bp", "tGT", "w", "e", NULL},
   {"uB66Cp", "tGT", "w", "e", NULL},
   {"uB66Dp", "tGT", "w", "e", NULL},
   {"uB66Ep", "tGT", "w", "e", NULL},
   {"uB66Fp", "tGT", "w", "e", NULL},
   {"uB670p", "tGT", "w", "e", NULL},
   {"uB671p", "tGT", "w", "e", NULL},
   {"uB672p", "tGT", "w", "e", NULL},
   {"uB673p", "tGT", "w", "e", NULL},
   {"uB674p", "tGT", "w", "e", NULL},
   {"uB675p", "tGT", "w", "e", NULL},
   {"uB676p", "tGT", "w", "e", NULL},
   {"uB677p", "tGT", "w", "e", NULL},
   {"uB678p", "tGT", "w", "e", NULL},
   {"uB679p", "tGT", "w", "e", NULL},
   {"uB67Ap", "tGT", "w", "e", NULL},
   {"uB67Bp", "tGT", "w", "e", NULL},
   {"uB67Cp", "tGT", "w", "e", NULL},
   {"uB67Dp", "tGT", "w", "e", NULL},
   {"uB67Ep", "tGT", "w", "e", NULL},
   {"uB67Fp", "tGT", "w", "e", NULL},
   {"uB680p", "tGT", "j", "o", NULL},
   {"uB681p", "tGT", "j", "o", NULL},
   {"uB682p", "tGT", "j", "o", NULL},
   {"uB683p", "tGT", "j", "o", NULL},
   {"uB684p", "tGT", "j", "o", NULL},
   {"uB685p", "tGT", "j", "o", NULL},
   {"uB686p", "tGT", "j", "o", NULL},
   {"uB687p", "tGT", "j", "o", NULL},
   {"uB688p", "tGT", "j", "o", NULL},
   {"uB689p", "tGT", "j", "o", NULL},
   {"uB68Ap", "tGT", "j", "o", NULL},
   {"uB68Bp", "tGT", "j", "o", NULL},
   {"uB68Cp", "tGT", "j", "o", NULL},
   {"uB68Dp", "tGT", "j", "o", NULL},
   {"uB68Ep", "tGT", "j", "o", NULL},
   {"uB68Fp", "tGT", "j", "o", NULL},
   {"uB690p", "tGT", "j", "o", NULL},
   {"uB691p", "tGT", "j", "o", NULL},
   {"uB692p", "tGT", "j", "o", NULL},
   {"uB693p", "tGT", "j", "o", NULL},
   {"uB694p", "tGT", "j", "o", NULL},
   {"uB695p", "tGT", "j", "o", NULL},
   {"uB696p", "tGT", "j", "o", NULL},
   {"uB697p", "tGT", "j", "o", NULL},
   {"uB698p", "tGT", "j", "o", NULL},
   {"uB699p", "tGT", "j", "o", NULL},
   {"uB69Ap", "tGT", "j", "o", NULL},
   {"uB69Bp", "tGT", "j", "o", NULL},
   {"uB69Cp", "tGT", "u", NULL, NULL},
   {"uB69Dp", "tGT", "u", "k", NULL},
   {"uB69Ep", "tGT", "u", "kGT", NULL},
   {"uB69Fp", "tGT", "u", "k", NULL},
   {"uB6A0p", "tGT", "u", "n", NULL},
   {"uB6A1p", "tGT", "u", "n", NULL},
   {"uB6A2p", "tGT", "u", "n", NULL},
   {"uB6A3p", "tGT", "u", "t", NULL},
   {"uB6A4p", "tGT", "u", "l", NULL},
   {"uB6A5p", "tGT", "u", "l", NULL},
   {"uB6A6p", "tGT", "u", "l", NULL},
   {"uB6A7p", "tGT", "u", "l", NULL},
   {"uB6A8p", "tGT", "u", "l", NULL},
   {"uB6A9p", "tGT", "u", "l", NULL},
   {"uB6AAp", "tGT", "u", "l", NULL},
   {"uB6ABp", "tGT", "u", "l", NULL},
   {"uB6ACp", "tGT", "u", "m", NULL},
   {"uB6ADp", "tGT", "u", "p", NULL},
   {"uB6AEp", "tGT", "u", "p", NULL},
   {"uB6AFp", "tGT", "u", "sh", NULL},
   {"uB6B0p", "tGT", "u", "s", NULL},
   {"uB6B1p", "tGT", "u", "N", NULL},
   {"uB6B2p", "tGT", "u", "tS", NULL},
   {"uB6B3p", "tGT", "u", "tSh", NULL},
   {"uB6B4p", "tGT", "u", "kh", NULL},
   {"uB6B5p", "tGT", "u", "th", NULL},
   {"uB6B6p", "tGT", "u", "ph", NULL},
   {"uB6B7p", "tGT", "u", "h", NULL},
   {"uB6B8p", "tGT", "w", "^", NULL},
   {"uB6B9p", "tGT", "w", "^", NULL},
   {"uB6BAp", "tGT", "w", "^", NULL},
   {"uB6BBp", "tGT", "w", "^", NULL},
   {"uB6BCp", "tGT", "w", "^", NULL},
   {"uB6BDp", "tGT", "w", "^", NULL},
   {"uB6BEp", "tGT", "w", "^", NULL},
   {"uB6BFp", "tGT", "w", "^", NULL},
   {"uB6C0p", "tGT", "w", "^", NULL},
   {"uB6C1p", "tGT", "w", "^", NULL},
   {"uB6C2p", "tGT", "w", "^", NULL},
   {"uB6C3p", "tGT", "w", "^", NULL},
   {"uB6C4p", "tGT", "w", "^", NULL},
   {"uB6C5p", "tGT", "w", "^", NULL},
   {"uB6C6p", "tGT", "w", "^", NULL},
   {"uB6C7p", "tGT", "w", "^", NULL},
   {"uB6C8p", "tGT", "w", "^", NULL},
   {"uB6C9p", "tGT", "w", "^", NULL},
   {"uB6CAp", "tGT", "w", "^", NULL},
   {"uB6CBp", "tGT", "w", "^", NULL},
   {"uB6CCp", "tGT", "w", "^", NULL},
   {"uB6CDp", "tGT", "w", "^", NULL},
   {"uB6CEp", "tGT", "w", "^", NULL},
   {"uB6CFp", "tGT", "w", "^", NULL},
   {"uB6D0p", "tGT", "w", "^", NULL},
   {"uB6D1p", "tGT", "w", "^", NULL},
   {"uB6D2p", "tGT", "w", "^", NULL},
   {"uB6D3p", "tGT", "w", "^", NULL},
   {"uB6D4p", "tGT", "w", "e", NULL},
   {"uB6D5p", "tGT", "w", "e", NULL},
   {"uB6D6p", "tGT", "w", "e", NULL},
   {"uB6D7p", "tGT", "w", "e", NULL},
   {"uB6D8p", "tGT", "w", "e", NULL},
   {"uB6D9p", "tGT", "w", "e", NULL},
   {"uB6DAp", "tGT", "w", "e", NULL},
   {"uB6DBp", "tGT", "w", "e", NULL},
   {"uB6DCp", "tGT", "w", "e", NULL},
   {"uB6DDp", "tGT", "w", "e", NULL},
   {"uB6DEp", "tGT", "w", "e", NULL},
   {"uB6DFp", "tGT", "w", "e", NULL},
   {"uB6E0p", "tGT", "w", "e", NULL},
   {"uB6E1p", "tGT", "w", "e", NULL},
   {"uB6E2p", "tGT", "w", "e", NULL},
   {"uB6E3p", "tGT", "w", "e", NULL},
   {"uB6E4p", "tGT", "w", "e", NULL},
   {"uB6E5p", "tGT", "w", "e", NULL},
   {"uB6E6p", "tGT", "w", "e", NULL},
   {"uB6E7p", "tGT", "w", "e", NULL},
   {"uB6E8p", "tGT", "w", "e", NULL},
   {"uB6E9p", "tGT", "w", "e", NULL},
   {"uB6EAp", "tGT", "w", "e", NULL},
   {"uB6EBp", "tGT", "w", "e", NULL},
   {"uB6ECp", "tGT", "w", "e", NULL},
   {"uB6EDp", "tGT", "w", "e", NULL},
   {"uB6EEp", "tGT", "w", "e", NULL},
   {"uB6EFp", "tGT", "w", "e", NULL},
   {"uB6F0p", "tGT", "7", NULL, NULL},
   {"uB6F1p", "tGT", "7", "k", NULL},
   {"uB6F2p", "tGT", "7", "kGT", NULL},
   {"uB6F3p", "tGT", "7", "k", NULL},
   {"uB6F4p", "tGT", "7", "n", NULL},
   {"uB6F5p", "tGT", "7", "n", NULL},
   {"uB6F6p", "tGT", "7", "n", NULL},
   {"uB6F7p", "tGT", "7", "t", NULL},
   {"uB6F8p", "tGT", "7", "l", NULL},
   {"uB6F9p", "tGT", "7", "l", NULL},
   {"uB6FAp", "tGT", "7", "l", NULL},
   {"uB6FBp", "tGT", "7", "l", NULL},
   {"uB6FCp", "tGT", "7", "l", NULL},
   {"uB6FDp", "tGT", "7", "l", NULL},
   {"uB6FEp", "tGT", "7", "l", NULL},
   {"uB6FFp", "tGT", "7", "lh", NULL},
   {"uB700p", "tGT", "7", "m", NULL},
   {"uB701p", "tGT", "7", "p", NULL},
   {"uB702p", "tGT", "7", "p", NULL},
   {"uB703p", "tGT", "7", "sh", NULL},
   {"uB704p", "tGT", "7", "s", NULL},
   {"uB705p", "tGT", "7", "N", NULL},
   {"uB706p", "tGT", "7", "tS", NULL},
   {"uB707p", "tGT", "7", "tSh", NULL},
   {"uB708p", "tGT", "7", "kh", NULL},
   {"uB709p", "tGT", "7", "th", NULL},
   {"uB70Ap", "tGT", "7", "ph", NULL},
   {"uB70Bp", "tGT", "7", "h", NULL},
   {"uB70Cp", "tGT", "j", "u", NULL},
   {"uB70Dp", "tGT", "j", "u", NULL},
   {"uB70Ep", "tGT", "j", "u", NULL},
   {"uB70Fp", "tGT", "j", "u", NULL},
   {"uB710p", "tGT", "j", "u", NULL},
   {"uB711p", "tGT", "j", "u", NULL},
   {"uB712p", "tGT", "j", "u", NULL},
   {"uB713p", "tGT", "j", "u", NULL},
   {"uB714p", "tGT", "j", "u", NULL},
   {"uB715p", "tGT", "j", "u", NULL},
   {"uB716p", "tGT", "j", "u", NULL},
   {"uB717p", "tGT", "j", "u", NULL},
   {"uB718p", "tGT", "j", "u", NULL},
   {"uB719p", "tGT", "j", "u", NULL},
   {"uB71Ap", "tGT", "j", "u", NULL},
   {"uB71Bp", "tGT", "j", "u", NULL},
   {"uB71Cp", "tGT", "j", "u", NULL},
   {"uB71Dp", "tGT", "j", "u", NULL},
   {"uB71Ep", "tGT", "j", "u", NULL},
   {"uB71Fp", "tGT", "j", "u", NULL},
   {"uB720p", "tGT", "j", "u", NULL},
   {"uB721p", "tGT", "j", "u", NULL},
   {"uB722p", "tGT", "j", "u", NULL},
   {"uB723p", "tGT", "j", "u", NULL},
   {"uB724p", "tGT", "j", "u", NULL},
   {"uB725p", "tGT", "j", "u", NULL},
   {"uB726p", "tGT", "j", "u", NULL},
   {"uB727p", "tGT", "j", "u", NULL},
   {"uB728p", "tGT", "4", NULL, NULL},
   {"uB719p", "tGT", "4", "k", NULL},
   {"uB72Ap", "tGT", "4", "kGT", NULL},
   {"uB72Bp", "tGT", "4", "k", NULL},
   {"uB72Cp", "tGT", "4", "n", NULL},
   {"uB72Dp", "tGT", "4", "n", NULL},
   {"uB72Ep", "tGT", "4", "n", NULL},
   {"uB72Fp", "tGT", "4", "t", NULL},
   {"uB730p", "tGT", "4", "l", NULL},
   {"uB731p", "tGT", "4", "l", NULL},
   {"uB732p", "tGT", "4", "l", NULL},
   {"uB733p", "tGT", "4", "l", NULL},
   {"uB734p", "tGT", "4", "l", NULL},
   {"uB735p", "tGT", "4", "l", NULL},
   {"uB736p", "tGT", "4", "l", NULL},
   {"uB737p", "tGT", "4", "l", NULL},
   {"uB738p", "tGT", "4", "m", NULL},
   {"uB739p", "tGT", "4", "p", NULL},
   {"uB73Ap", "tGT", "4", "p", NULL},
   {"uB73Bp", "tGT", "4", "sh", NULL},
   {"uB73Cp", "tGT", "4", "s", NULL},
   {"uB73Dp", "tGT", "4", "N", NULL},
   {"uB73Ep", "tGT", "4", "tS", NULL},
   {"uB73Fp", "tGT", "4", "tSh", NULL},
   {"uB740p", "tGT", "4", "kh", NULL},
   {"uB741p", "tGT", "4", "th", NULL},
   {"uB742p", "tGT", "4", "ph", NULL},
   {"uB743p", "tGT", "4", "h", NULL},
   {"uB744p", "tGT", "4", "j", NULL},
   {"uB745p", "tGT", "4", "j", NULL},
   {"uB746p", "tGT", "4", "j", NULL},
   {"uB747p", "tGT", "4", "j", NULL},
   {"uB748p", "tGT", "4", "j", NULL},
   {"uB749p", "tGT", "4", "j", NULL},
   {"uB74Ap", "tGT", "4", "j", NULL},
   {"uB74Bp", "tGT", "4", "j", NULL},
   {"uB74Cp", "tGT", "4", "j", NULL},
   {"uB74Dp", "tGT", "4", "j", NULL},
   {"uB74Ep", "tGT", "4", "j", NULL},
   {"uB74Fp", "tGT", "4", "j", NULL},
   {"uB750p", "tGT", "4", "j", NULL},
   {"uB751p", "tGT", "4", "j", NULL},
   {"uB752p", "tGT", "4", "j", NULL},
   {"uB753p", "tGT", "4", "j", NULL},
   {"uB754p", "tGT", "4", "j", NULL},
   {"uB755p", "tGT", "4", "j", NULL},
   {"uB756p", "tGT", "4", "j", NULL},
   {"uB757p", "tGT", "4", "j", NULL},
   {"uB758p", "tGT", "4", "j", NULL},
   {"uB759p", "tGT", "4", "j", NULL},
   {"uB75Ap", "tGT", "4", "j", NULL},
   {"uB75Bp", "tGT", "4", "j", NULL},
   {"uB75Cp", "tGT", "4", "j", NULL},
   {"uB75Dp", "tGT", "4", "j", NULL},
   {"uB75Ep", "tGT", "4", "j", NULL},
   {"uB75Fp", "tGT", "4", "j", NULL},
   {"uB760p", "tGT", "i", NULL, NULL},
   {"uB761p", "tGT", "i", "k", NULL},
   {"uB762p", "tGT", "i", "kGT", NULL},
   {"uB763p", "tGT", "i", "k", NULL},
   {"uB764p", "tGT", "i", "n", NULL},
   {"uB765p", "tGT", "i", "n", NULL},
   {"uB766p", "tGT", "i", "n", NULL},
   {"uB767p", "tGT", "i", "t", NULL},
   {"uB768p", "tGT", "i", "l", NULL},
   {"uB769p", "tGT", "i", "l", NULL},
   {"uB76Ap", "tGT", "i", "l", NULL},
   {"uB76Bp", "tGT", "i", "l", NULL},
   {"uB76Cp", "tGT", "i", "l", NULL},
   {"uB76Dp", "tGT", "i", "l", NULL},
   {"uB76Ep", "tGT", "i", "l", NULL},
   {"uB76Fp", "tGT", "i", "l", NULL},
   {"uB770p", "tGT", "i", "m", NULL},
   {"uB771p", "tGT", "i", "p", NULL},
   {"uB772p", "tGT", "i", "p", NULL},
   {"uB773p", "tGT", "i", "sh", NULL},
   {"uB774p", "tGT", "i", "s", NULL},
   {"uB775p", "tGT", "i", "N", NULL},
   {"uB776p", "tGT", "i", "tS", NULL},
   {"uB777p", "tGT", "i", "tSh", NULL},
   {"uB778p", "tGT", "i", "kh", NULL},
   {"uB779p", "tGT", "i", "th", NULL},
   {"uB77Ap", "tGT", "i", "ph", NULL},
   {"uB77Bp", "tGT", "i", "h", NULL},
   {"uB77Cp", "r", "a", NULL, NULL},
   {"uB77Dp", "r", "a", "k", NULL},
   {"uB77Ep", "r", "a", "kGT", NULL},
   {"uB77Fp", "r", "a", "k", NULL},
   {"uB780p", "r", "a", "n", NULL},
   {"uB781p", "r", "a", "n", NULL},
   {"uB782p", "r", "a", "n", NULL},
   {"uB783p", "r", "a", "t", NULL},
   {"uB784p", "r", "a", "l", NULL},
   {"uB785p", "r", "a", "l", NULL},
   {"uB786p", "r", "a", "l", NULL},
   {"uB787p", "r", "a", "l", NULL},
   {"uB788p", "r", "a", "l", NULL},
   {"uB789p", "r", "a", "l", NULL},
   {"uB78Ap", "r", "a", "l", NULL},
   {"uB78Bp", "r", "a", "l", NULL},
   {"uB78Cp", "r", "a", "m", NULL},
   {"uB78Dp", "r", "a", "p", NULL},
   {"uB78Ep", "r", "a", "p", NULL},
   {"uB78Fp", "r", "a", "sh", NULL},
   {"uB790p", "r", "a", "s", NULL},
   {"uB791p", "r", "a", "N", NULL},
   {"uB792p", "r", "a", "tS", NULL},
   {"uB793p", "r", "a", "tSh", NULL},
   {"uB794p", "r", "a", "kh", NULL},
   {"uB795p", "r", "a", "th", NULL},
   {"uB796p", "r", "a", "ph", NULL},
   {"uB797p", "r", "a", "h", NULL},
   {"uB798p", "r", "@", NULL, NULL},
   {"uB799p", "r", "@", "k", NULL},
   {"uB79Ap", "r", "@", "kGT", NULL},
   {"uB79Bp", "r", "@", "k", NULL},
   {"uB79Cp", "r", "@", "n", NULL},
   {"uB79Dp", "r", "@", "n", NULL},
   {"uB79Ep", "r", "@", "n", NULL},
   {"uB79Fp", "r", "@", "t", NULL},
   {"uB7A0p", "r", "@", "l", NULL},
   {"uB7A1p", "r", "@", "l", NULL},
   {"uB7A2p", "r", "@", "l", NULL},
   {"uB7A3p", "r", "@", "l", NULL},
   {"uB7A4p", "r", "@", "l", NULL},
   {"uB7A5p", "r", "@", "l", NULL},
   {"uB7A6p", "r", "@", "l", NULL},
   {"uB7A7p", "r", "@", "lh", NULL},
   {"uB7A8p", "r", "@", "m", NULL},
   {"uB7A9p", "r", "@", "p", NULL},
   {"uB7AAp", "r", "@", "p", NULL},
   {"uB7ABp", "r", "@", "sh", NULL},
   {"uB7ACp", "r", "@", "s", NULL},
   {"uB7ADp", "r", "@", "N", NULL},
   {"uB7AEp", "r", "@", "tS", NULL},
   {"uB7AFp", "r", "@", "tSh", NULL},
   {"uB7B0p", "r", "@", "kh", NULL},
   {"uB7B1p", "r", "@", "th", NULL},
   {"uB7B2p", "r", "@", "ph", NULL},
   {"uB7B3p", "r", "@", "h", NULL},
   {"uB7B4p", "r", "j", "a", NULL},
   {"uB7B5p", "r", "j", "a", NULL},
   {"uB7B6p", "r", "j", "a", NULL},
   {"uB7B7p", "r", "j", "a", NULL},
   {"uB7B8p", "r", "j", "a", NULL},
   {"uB7B9p", "r", "j", "a", NULL},
   {"uB7BAp", "r", "j", "a", NULL},
   {"uB7BBp", "r", "j", "a", NULL},
   {"uB7BCp", "r", "j", "a", NULL},
   {"uB7BDp", "r", "j", "a", NULL},
   {"uB7BEp", "r", "j", "a", NULL},
   {"uB7BFp", "r", "j", "a", NULL},
   {"uB7C0p", "r", "j", "a", NULL},
   {"uB7C1p", "r", "j", "a", NULL},
   {"uB7C2p", "r", "j", "a", NULL},
   {"uB7C3p", "r", "j", "a", NULL},
   {"uB7C4p", "r", "j", "a", NULL},
   {"uB7C5p", "r", "j", "a", NULL},
   {"uB7C6p", "r", "j", "a", NULL},
   {"uB7C7p", "r", "j", "a", NULL},
   {"uB7C8p", "r", "j", "a", NULL},
   {"uB7C9p", "r", "j", "a", NULL},
   {"uB7CAp", "r", "j", "a", NULL},
   {"uB7CBp", "r", "j", "a", NULL},
   {"uB7CCp", "r", "j", "a", NULL},
   {"uB7CDp", "r", "j", "a", NULL},
   {"uB7CEp", "r", "j", "a", NULL},
   {"uB7CFp", "r", "j", "a", NULL},
   {"uB7D0p", "r", "j", "@", NULL},
   {"uB7D1p", "r", "j", "@", NULL},
   {"uB7D2p", "r", "j", "@", NULL},
   {"uB7D3p", "r", "j", "@", NULL},
   {"uB7D4p", "r", "j", "@", NULL},
   {"uB7D5p", "r", "j", "@", NULL},
   {"uB7D6p", "r", "j", "@", NULL},
   {"uB7D7p", "r", "j", "@", NULL},
   {"uB7D8p", "r", "j", "@", NULL},
   {"uB7D9p", "r", "j", "@", NULL},
   {"uB7DAp", "r", "j", "@", NULL},
   {"uB7DBp", "r", "j", "@", NULL},
   {"uB7DCp", "r", "j", "@", NULL},
   {"uB7DDp", "r", "j", "@", NULL},
   {"uB7DEp", "r", "j", "@", NULL},
   {"uB7DFp", "r", "j", "@", NULL},
   {"uB7E0p", "r", "j", "@", NULL},
   {"uB7E1p", "r", "j", "@", NULL},
   {"uB7E2p", "r", "j", "@", NULL},
   {"uB7E3p", "r", "j", "@", NULL},
   {"uB7E4p", "r", "j", "@", NULL},
   {"uB7E5p", "r", "j", "@", NULL},
   {"uB7E6p", "r", "j", "@", NULL},
   {"uB7E7p", "r", "j", "@", NULL},
   {"uB7E8p", "r", "j", "@", NULL},
   {"uB7E9p", "r", "j", "@", NULL},
   {"uB7EAp", "r", "j", "@", NULL},
   {"uB7EBp", "r", "j", "@", NULL},
   {"uB7ECp", "r", "^", NULL, NULL},
   {"uB7EDp", "r", "^", "k", NULL},
   {"uB7EEp", "r", "^", "kGT", NULL},
   {"uB7EFp", "r", "^", "k", NULL},
   {"uB7F0p", "r", "^", "n", NULL},
   {"uB7F1p", "r", "^", "n", NULL},
   {"uB7F2p", "r", "^", "n", NULL},
   {"uB7F3p", "r", "^", "t", NULL},
   {"uB7F4p", "r", "^", "l", NULL},
   {"uB7F5p", "r", "^", "l", NULL},
   {"uB7F6p", "r", "^", "l", NULL},
   {"uB7F7p", "r", "^", "l", NULL},
   {"uB7F8p", "r", "^", "l", NULL},
   {"uB7F9p", "r", "^", "l", NULL},
   {"uB7FAp", "r", "^", "l", NULL},
   {"uB7FBp", "r", "^", "l", NULL},
   {"uB7FCp", "r", "^", "m", NULL},
   {"uB7FDp", "r", "^", "p", NULL},
   {"uB7FEp", "r", "^", "p", NULL},
   {"uB7FFp", "r", "^", "sh", NULL},
   {"uB800p", "r", "^", "s", NULL},
   {"uB801p", "r", "^", "N", NULL},
   {"uB802p", "r", "^", "tS", NULL},
   {"uB803p", "r", "^", "tSh", NULL},
   {"uB804p", "r", "^", "kh", NULL},
   {"uB805p", "r", "^", "th", NULL},
   {"uB806p", "r", "^", "ph", NULL},
   {"uB807p", "r", "^", "h", NULL},
   {"uB808p", "r", "e", NULL, NULL},
   {"uB809p", "r", "e", "k", NULL},
   {"uB80Ap", "r", "e", "kGT", NULL},
   {"uB80Bp", "r", "e", "k", NULL},
   {"uB80Cp", "r", "e", "n", NULL},
   {"uB80Dp", "r", "e", "n", NULL},
   {"uB80Ep", "r", "e", "n", NULL},
   {"uB80Fp", "r", "e", "t", NULL},
   {"uB810p", "r", "e", "l", NULL},
   {"uB811p", "r", "e", "l", NULL},
   {"uB812p", "r", "e", "l", NULL},
   {"uB813p", "r", "e", "l", NULL},
   {"uB814p", "r", "e", "l", NULL},
   {"uB815p", "r", "e", "l", NULL},
   {"uB816p", "r", "e", "l", NULL},
   {"uB817p", "r", "e", "l", NULL},
   {"uB818p", "r", "e", "m", NULL},
   {"uB819p", "r", "e", "p", NULL},
   {"uB81Ap", "r", "e", "p", NULL},
   {"uB81Bp", "r", "e", "sh", NULL},
   {"uB81Cp", "r", "e", "s", NULL},
   {"uB81Dp", "r", "e", "N", NULL},
   {"uB81Ep", "r", "e", "tS", NULL},
   {"uB81Fp", "r", "e", "tSh", NULL},
   {"uB820p", "r", "e", "kh", NULL},
   {"uB821p", "r", "e", "th", NULL},
   {"uB822p", "r", "e", "ph", NULL},
   {"uB823p", "r", "e", "h", NULL},
   {"uB824p", "r", "j", "^", NULL},
   {"uB825p", "r", "j", "^", NULL},
   {"uB826p", "r", "j", "^", NULL},
   {"uB827p", "r", "j", "^", NULL},
   {"uB828p", "r", "j", "^", NULL},
   {"uB829p", "r", "j", "^", NULL},
   {"uB82Ap", "r", "j", "^", NULL},
   {"uB82Bp", "r", "j", "^", NULL},
   {"uB82Cp", "r", "j", "^", NULL},
   {"uB82Dp", "r", "j", "^", NULL},
   {"uB82Ep", "r", "j", "^", NULL},
   {"uB82Fp", "r", "j", "^", NULL},
   {"uB830p", "r", "j", "^", NULL},
   {"uB831p", "r", "j", "^", NULL},
   {"uB832p", "r", "j", "^", NULL},
   {"uB833p", "r", "j", "^", NULL},
   {"uB834p", "r", "j", "^", NULL},
   {"uB835p", "r", "j", "^", NULL},
   {"uB836p", "r", "j", "^", NULL},
   {"uB837p", "r", "j", "^", NULL},
   {"uB828p", "r", "j", "^", NULL},
   {"uB839p", "r", "j", "^", NULL},
   {"uB83Ap", "r", "j", "^", NULL},
   {"uB83Bp", "r", "j", "^", NULL},
   {"uB83Cp", "r", "j", "^", NULL},
   {"uB83Dp", "r", "j", "^", NULL},
   {"uB83Ep", "r", "j", "^", NULL},
   {"uB83Fp", "r", "j", "^", NULL},
   {"uB840p", "r", "j", "e", NULL},
   {"uB841p", "r", "j", "e", NULL},
   {"uB842p", "r", "j", "e", NULL},
   {"uB843p", "r", "j", "e", NULL},
   {"uB844p", "r", "j", "e", NULL},
   {"uB845p", "r", "j", "e", NULL},
   {"uB846p", "r", "j", "e", NULL},
   {"uB847p", "r", "j", "e", NULL},
   {"uB848p", "r", "j", "e", NULL},
   {"uB849p", "r", "j", "e", NULL},
   {"uB84Ap", "r", "j", "e", NULL},
   {"uB84Bp", "r", "j", "e", NULL},
   {"uB84Cp", "r", "j", "e", NULL},
   {"uB84Dp", "r", "j", "e", NULL},
   {"uB84Ep", "r", "j", "e", NULL},
   {"uB84Fp", "r", "j", "e", NULL},
   {"uB850p", "r", "j", "e", NULL},
   {"uB851p", "r", "j", "e", NULL},
   {"uB852p", "r", "j", "e", NULL},
   {"uB853p", "r", "j", "e", NULL},
   {"uB854p", "r", "j", "e", NULL},
   {"uB855p", "r", "j", "e", NULL},
   {"uB856p", "r", "j", "e", NULL},
   {"uB857p", "r", "j", "e", NULL},
   {"uB858p", "r", "j", "e", NULL},
   {"uB859p", "r", "j", "e", NULL},
   {"uB85Ap", "r", "j", "e", NULL},
   {"uB85Bp", "r", "j", "e", NULL},
   {"uB85Cp", "r", "o", NULL, NULL},
   {"uB85Dp", "r", "o", "k", NULL},
   {"uB85Ep", "r", "o", "kGT", NULL},
   {"uB85Fp", "r", "o", "k", NULL},
   {"uB860p", "r", "o", "n", NULL},
   {"uB861p", "r", "o", "n", NULL},
   {"uB862p", "r", "o", "n", NULL},
   {"uB863p", "r", "o", "t", NULL},
   {"uB864p", "r", "o", "l", NULL},
   {"uB865p", "r", "o", "l", NULL},
   {"uB866p", "r", "o", "l", NULL},
   {"uB867p", "r", "o", "l", NULL},
   {"uB868p", "r", "o", "l", NULL},
   {"uB869p", "r", "o", "l", NULL},
   {"uB86Ap", "r", "o", "l", NULL},
   {"uB86Bp", "r", "o", "l", NULL},
   {"uB86Cp", "r", "o", "m", NULL},
   {"uB86Dp", "r", "o", "p", NULL},
   {"uB86Ep", "r", "o", "p", NULL},
   {"uB86Fp", "r", "o", "sh", NULL},
   {"uB870p", "r", "o", "s", NULL},
   {"uB871p", "r", "o", "N", NULL},
   {"uB872p", "r", "o", "tS", NULL},
   {"uB873p", "r", "o", "tSh", NULL},
   {"uB874p", "r", "o", "kh", NULL},
   {"uB875p", "r", "o", "th", NULL},
   {"uB876p", "r", "o", "ph", NULL},
   {"uB877p", "r", "o", "h", NULL},
   {"uB878p", "r", "w", "a", NULL},
   {"uB879p", "r", "w", "a", NULL},
   {"uB87Ap", "r", "w", "a", NULL},
   {"uB87Bp", "r", "w", "a", NULL},
   {"uB87Cp", "r", "w", "a", NULL},
   {"uB87Dp", "r", "w", "a", NULL},
   {"uB87Ep", "r", "w", "a", NULL},
   {"uB87Fp", "r", "w", "a", NULL},
   {"uB880p", "r", "w", "a", NULL},
   {"uB881p", "r", "w", "a", NULL},
   {"uB882p", "r", "w", "a", NULL},
   {"uB883p", "r", "w", "a", NULL},
   {"uB884p", "r", "w", "a", NULL},
   {"uB885p", "r", "w", "a", NULL},
   {"uB886p", "r", "w", "a", NULL},
   {"uB887p", "r", "w", "a", NULL},
   {"uB888p", "r", "w", "a", NULL},
   {"uB889p", "r", "w", "a", NULL},
   {"uB88Ap", "r", "w", "a", NULL},
   {"uB88Bp", "r", "w", "a", NULL},
   {"uB88Cp", "r", "w", "a", NULL},
   {"uB88Dp", "r", "w", "a", NULL},
   {"uB88Ep", "r", "w", "a", NULL},
   {"uB88Fp", "r", "w", "a", NULL},
   {"uB890p", "r", "w", "a", NULL},
   {"uB891p", "r", "w", "a", NULL},
   {"uB892p", "r", "w", "a", NULL},
   {"uB893p", "r", "w", "a", NULL},
   {"uB894p", "r", "w", "@", NULL},
   {"uB895p", "r", "w", "@", NULL},
   {"uB896p", "r", "w", "@", NULL},
   {"uB897p", "r", "w", "@", NULL},
   {"uB898p", "r", "w", "@", NULL},
   {"uB899p", "r", "w", "@", NULL},
   {"uB89Ap", "r", "w", "@", NULL},
   {"uB89Bp", "r", "w", "@", NULL},
   {"uB89Cp", "r", "w", "@", NULL},
   {"uB89Dp", "r", "w", "@", NULL},
   {"uB89Ep", "r", "w", "@", NULL},
   {"uB89Fp", "r", "w", "@", NULL},
   {"uB8A0p", "r", "w", "@", NULL},
   {"uB8A1p", "r", "w", "@", NULL},
   {"uB8A2p", "r", "w", "@", NULL},
   {"uB8A3p", "r", "w", "@", NULL},
   {"uB8A4p", "r", "w", "@", NULL},
   {"uB8A5p", "r", "w", "@", NULL},
   {"uB8A6p", "r", "w", "@", NULL},
   {"uB8A7p", "r", "w", "@", NULL},
   {"uB8A8p", "r", "w", "@", NULL},
   {"uB8A9p", "r", "w", "@", NULL},
   {"uB8AAp", "r", "w", "@", NULL},
   {"uB8ABp", "r", "w", "@", NULL},
   {"uB8ACp", "r", "w", "@", NULL},
   {"uB8ADp", "r", "w", "@", NULL},
   {"uB8AEp", "r", "w", "@", NULL},
   {"uB8AFp", "r", "w", "@", NULL},
   {"uB8B0p", "r", "w", "e", NULL},
   {"uB8B1p", "r", "w", "e", NULL},
   {"uB8B2p", "r", "w", "e", NULL},
   {"uB8B3p", "r", "w", "e", NULL},
   {"uB8B4p", "r", "w", "e", NULL},
   {"uB8B5p", "r", "w", "e", NULL},
   {"uB8B6p", "r", "w", "e", NULL},
   {"uB8B7p", "r", "w", "e", NULL},
   {"uB8B8p", "r", "w", "e", NULL},
   {"uB8B9p", "r", "w", "e", NULL},
   {"uB8BAp", "r", "w", "e", NULL},
   {"uB8BBp", "r", "w", "e", NULL},
   {"uB8BCp", "r", "w", "e", NULL},
   {"uB8BDp", "r", "w", "e", NULL},
   {"uB8BEp", "r", "w", "e", NULL},
   {"uB8BFp", "r", "w", "e", NULL},
   {"uB8C0p", "r", "w", "e", NULL},
   {"uB8C1p", "r", "w", "e", NULL},
   {"uB8C2p", "r", "w", "e", NULL},
   {"uB8C3p", "r", "w", "e", NULL},
   {"uB8C4p", "r", "w", "e", NULL},
   {"uB8C5p", "r", "w", "e", NULL},
   {"uB8C6p", "r", "w", "e", NULL},
   {"uB8C7p", "r", "w", "e", NULL},
   {"uB8C8p", "r", "w", "e", NULL},
   {"uB8C9p", "r", "w", "e", NULL},
   {"uB8CAp", "r", "w", "e", NULL},
   {"uB8CBp", "r", "w", "e", NULL},
   {"uB8CCp", "r", "j", "o", NULL},
   {"uB8CDp", "r", "j", "o", NULL},
   {"uB8CEp", "r", "j", "o", NULL},
   {"uB8CFp", "r", "j", "o", NULL},
   {"uB8D0p", "r", "j", "o", NULL},
   {"uB8D1p", "r", "j", "o", NULL},
   {"uB8D2p", "r", "j", "o", NULL},
   {"uB8D3p", "r", "j", "o", NULL},
   {"uB8D4p", "r", "j", "o", NULL},
   {"uB8D5p", "r", "j", "o", NULL},
   {"uB8D6p", "r", "j", "o", NULL},
   {"uB8D7p", "r", "j", "o", NULL},
   {"uB8D8p", "r", "j", "o", NULL},
   {"uB8D9p", "r", "j", "o", NULL},
   {"uB8DAp", "r", "j", "o", NULL},
   {"uB8DBp", "r", "j", "o", NULL},
   {"uB8DCp", "r", "j", "o", NULL},
   {"uB8DDp", "r", "j", "o", NULL},
   {"uB8DEp", "r", "j", "o", NULL},
   {"uB8DFp", "r", "j", "o", NULL},
   {"uB8E0p", "r", "j", "o", NULL},
   {"uB8E1p", "r", "j", "o", NULL},
   {"uB8E2p", "r", "j", "o", NULL},
   {"uB8E3p", "r", "j", "o", NULL},
   {"uB8E4p", "r", "j", "o", NULL},
   {"uB8E5p", "r", "j", "o", NULL},
   {"uB8E6p", "r", "j", "o", NULL},
   {"uB8E7p", "r", "j", "o", NULL},
   {"uB8E8p", "r", "u", NULL, NULL},
   {"uB8E9p", "r", "u", "k", NULL},
   {"uB8EAp", "r", "u", "kGT", NULL},
   {"uB8EBp", "r", "u", "k", NULL},
   {"uB8ECp", "r", "u", "n", NULL},
   {"uB8EDp", "r", "u", "n", NULL},
   {"uB8EEp", "r", "u", "n", NULL},
   {"uB8EFp", "r", "u", "t", NULL},
   {"uB8F0p", "r", "u", "l", NULL},
   {"uB8F1p", "r", "u", "l", NULL},
   {"uB8F2p", "r", "u", "l", NULL},
   {"uB8F3p", "r", "u", "l", NULL},
   {"uB8F4p", "r", "u", "l", NULL},
   {"uB8F5p", "r", "u", "l", NULL},
   {"uB8F6p", "r", "u", "l", NULL},
   {"uB8F7p", "r", "u", "l", NULL},
   {"uB8F8p", "r", "u", "m", NULL},
   {"uB8F9p", "r", "u", "p", NULL},
   {"uB8FAp", "r", "u", "p", NULL},
   {"uB8FBp", "r", "u", "sh", NULL},
   {"uB8FCp", "r", "u", "s", NULL},
   {"uB8FDp", "r", "u", "N", NULL},
   {"uB8FEp", "r", "u", "tS", NULL},
   {"uB8FFp", "r", "u", "tSh", NULL},
   {"uB900p", "r", "u", "kh", NULL},
   {"uB901p", "r", "u", "th", NULL},
   {"uB902p", "r", "u", "ph", NULL},
   {"uB903p", "r", "u", "h", NULL},
   {"uB904p", "r", "w", "^", NULL},
   {"uB905p", "r", "w", "^", NULL},
   {"uB906p", "r", "w", "^", NULL},
   {"uB907p", "r", "w", "^", NULL},
   {"uB908p", "r", "w", "^", NULL},
   {"uB909p", "r", "w", "^", NULL},
   {"uB90Ap", "r", "w", "^", NULL},
   {"uB90Bp", "r", "w", "^", NULL},
   {"uB90Cp", "r", "w", "^", NULL},
   {"uB90Dp", "r", "w", "^", NULL},
   {"uB90Ep", "r", "w", "^", NULL},
   {"uB90Fp", "r", "w", "^", NULL},
   {"uB910p", "r", "w", "^", NULL},
   {"uB911p", "r", "w", "^", NULL},
   {"uB912p", "r", "w", "^", NULL},
   {"uB913p", "r", "w", "^", NULL},
   {"uB914p", "r", "w", "^", NULL},
   {"uB915p", "r", "w", "^", NULL},
   {"uB916p", "r", "w", "^", NULL},
   {"uB917p", "r", "w", "^", NULL},
   {"uB918p", "r", "w", "^", NULL},
   {"uB919p", "r", "w", "^", NULL},
   {"uB91Ap", "r", "w", "^", NULL},
   {"uB91Bp", "r", "w", "^", NULL},
   {"uB91Cp", "r", "w", "^", NULL},
   {"uB91Dp", "r", "w", "^", NULL},
   {"uB91Ep", "r", "w", "^", NULL},
   {"uB91Fp", "r", "w", "^", NULL},
   {"uB920p", "r", "w", "e", NULL},
   {"uB921p", "r", "w", "e", NULL},
   {"uB922p", "r", "w", "e", NULL},
   {"uB923p", "r", "w", "e", NULL},
   {"uB924p", "r", "w", "e", NULL},
   {"uB925p", "r", "w", "e", NULL},
   {"uB926p", "r", "w", "e", NULL},
   {"uB927p", "r", "w", "e", NULL},
   {"uB928p", "r", "w", "e", NULL},
   {"uB929p", "r", "w", "e", NULL},
   {"uB92Ap", "r", "w", "e", NULL},
   {"uB92Bp", "r", "w", "e", NULL},
   {"uB92Cp", "r", "w", "e", NULL},
   {"uB92Dp", "r", "w", "e", NULL},
   {"uB92Ep", "r", "w", "e", NULL},
   {"uB92Fp", "r", "w", "e", NULL},
   {"uB930p", "r", "w", "e", NULL},
   {"uB931p", "r", "w", "e", NULL},
   {"uB932p", "r", "w", "e", NULL},
   {"uB933p", "r", "w", "e", NULL},
   {"uB934p", "r", "w", "e", NULL},
   {"uB935p", "r", "w", "e", NULL},
   {"uB936p", "r", "w", "e", NULL},
   {"uB937p", "r", "w", "e", NULL},
   {"uB938p", "r", "w", "e", NULL},
   {"uB939p", "r", "w", "e", NULL},
   {"uB93Ap", "r", "w", "e", NULL},
   {"uB93Bp", "r", "w", "e", NULL},
   {"uB93Cp", "r", "7", NULL, NULL},
   {"uB93Dp", "r", "7", "k", NULL},
   {"uB93Ep", "r", "7", "kGT", NULL},
   {"uB93Fp", "r", "7", "k", NULL},
   {"uB940p", "r", "7", "n", NULL},
   {"uB941p", "r", "7", "n", NULL},
   {"uB942p", "r", "7", "n", NULL},
   {"uB943p", "r", "7", "t", NULL},
   {"uB944p", "r", "7", "l", NULL},
   {"uB945p", "r", "7", "l", NULL},
   {"uB946p", "r", "7", "l", NULL},
   {"uB947p", "r", "7", "l", NULL},
   {"uB948p", "r", "7", "l", NULL},
   {"uB949p", "r", "7", "l", NULL},
   {"uB94Ap", "r", "7", "l", NULL},
   {"uB94Bp", "r", "7", "l", NULL},
   {"uB94Cp", "r", "7", "m", NULL},
   {"uB94Dp", "r", "7", "p", NULL},
   {"uB94Ep", "r", "7", "p", NULL},
   {"uB94Fp", "r", "7", "sh", NULL},
   {"uB950p", "r", "7", "s", NULL},
   {"uB951p", "r", "7", "N", NULL},
   {"uB952p", "r", "7", "tS", NULL},
   {"uB953p", "r", "7", "tSh", NULL},
   {"uB954p", "r", "7", "kh", NULL},
   {"uB955p", "r", "7", "th", NULL},
   {"uB956p", "r", "7", "ph", NULL},
   {"uB957p", "r", "7", "h", NULL},
   {"uB958p", "r", "j", "u", NULL},
   {"uB959p", "r", "j", "u", NULL},
   {"uB95Ap", "r", "j", "u", NULL},
   {"uB95Bp", "r", "j", "u", NULL},
   {"uB95Cp", "r", "j", "u", NULL},
   {"uB95Dp", "r", "j", "u", NULL},
   {"uB95Ep", "r", "j", "u", NULL},
   {"uB95Fp", "r", "j", "u", NULL},
   {"uB960p", "r", "j", "u", NULL},
   {"uB961p", "r", "j", "u", NULL},
   {"uB962p", "r", "j", "u", NULL},
   {"uB963p", "r", "j", "u", NULL},
   {"uB964p", "r", "j", "u", NULL},
   {"uB965p", "r", "j", "u", NULL},
   {"uB966p", "r", "j", "u", NULL},
   {"uB967p", "r", "j", "u", NULL},
   {"uB968p", "r", "j", "u", NULL},
   {"uB969p", "r", "j", "u", NULL},
   {"uB96Ap", "r", "j", "u", NULL},
   {"uB96Bp", "r", "j", "u", NULL},
   {"uB96Cp", "r", "j", "u", NULL},
   {"uB96Dp", "r", "j", "u", NULL},
   {"uB96Ep", "r", "j", "u", NULL},
   {"uB96Fp", "r", "j", "u", NULL},
   {"uB970p", "r", "j", "u", NULL},
   {"uB971p", "r", "j", "u", NULL},
   {"uB972p", "r", "j", "u", NULL},
   {"uB973p", "r", "j", "u", NULL},
   {"uB974p", "r", "4", NULL, NULL},
   {"uB975p", "r", "4", "k", NULL},
   {"uB976p", "r", "4", "kGT", NULL},
   {"uB977p", "r", "4", "k", NULL},
   {"uB978p", "r", "4", "n", NULL},
   {"uB979p", "r", "4", "n", NULL},
   {"uB97Ap", "r", "4", "n", NULL},
   {"uB97Bp", "r", "4", "t", NULL},
   {"uB97Cp", "r", "4", "l", NULL},
   {"uB97Dp", "r", "4", "l", NULL},
   {"uB97Ep", "r", "4", "l", NULL},
   {"uB97Fp", "r", "4", "l", NULL},
   {"uB980p", "r", "4", "l", NULL},
   {"uB981p", "r", "4", "l", NULL},
   {"uB982p", "r", "4", "l", NULL},
   {"uB983p", "r", "4", "l", NULL},
   {"uB984p", "r", "4", "m", NULL},
   {"uB985p", "r", "4", "p", NULL},
   {"uB986p", "r", "4", "p", NULL},
   {"uB987p", "r", "4", "sh", NULL},
   {"uB988p", "r", "4", "s", NULL},
   {"uB989p", "r", "4", "N", NULL},
   {"uB98Ap", "r", "4", "tS", NULL},
   {"uB98Bp", "r", "4", "tSh", NULL},
   {"uB98Cp", "r", "4", "kh", NULL},
   {"uB98Dp", "r", "4", "th", NULL},
   {"uB98Ep", "r", "4", "ph", NULL},
   {"uB98Fp", "r", "4", "h", NULL},
   {"uB990p", "r", "4", "j", NULL},
   {"uB991p", "r", "4", "j", NULL},
   {"uB992p", "r", "4", "j", NULL},
   {"uB993p", "r", "4", "j", NULL},
   {"uB994p", "r", "4", "j", NULL},
   {"uB995p", "r", "4", "j", NULL},
   {"uB996p", "r", "4", "j", NULL},
   {"uB997p", "r", "4", "j", NULL},
   {"uB998p", "r", "4", "j", NULL},
   {"uB999p", "r", "4", "j", NULL},
   {"uB99Ap", "r", "4", "j", NULL},
   {"uB99Bp", "r", "4", "j", NULL},
   {"uB99Cp", "r", "4", "j", NULL},
   {"uB99Dp", "r", "4", "j", NULL},
   {"uB99Ep", "r", "4", "j", NULL},
   {"uB99Fp", "r", "4", "j", NULL},
   {"uB9A0p", "r", "4", "j", NULL},
   {"uB9A1p", "r", "4", "j", NULL},
   {"uB9A2p", "r", "4", "j", NULL},
   {"uB9A3p", "r", "4", "j", NULL},
   {"uB9A4p", "r", "4", "j", NULL},
   {"uB9A5p", "r", "4", "j", NULL},
   {"uB9A6p", "r", "4", "j", NULL},
   {"uB9A7p", "r", "4", "j", NULL},
   {"uB9A8p", "r", "4", "j", NULL},
   {"uB9A9p", "r", "4", "j", NULL},
   {"uB9AAp", "r", "4", "j", NULL},
   {"uB9ABp", "r", "4", "j", NULL},
   {"uB9ACp", "r", "i", NULL, NULL},
   {"uB9ADp", "r", "i", "k", NULL},
   {"uB9AEp", "r", "i", "kGT", NULL},
   {"uB9AFp", "r", "i", "k", NULL},
   {"uB9B0p", "r", "i", "n", NULL},
   {"uB9B1p", "r", "i", "n", NULL},
   {"uB9B2p", "r", "i", "n", NULL},
   {"uB9B3p", "r", "i", "t", NULL},
   {"uB9B4p", "r", "i", "l", NULL},
   {"uB9B5p", "r", "i", "l", NULL},
   {"uB9B6p", "r", "i", "l", NULL},
   {"uB9B7p", "r", "i", "l", NULL},
   {"uB9B8p", "r", "i", "l", NULL},
   {"uB9B9p", "r", "i", "l", NULL},
   {"uB9BAp", "r", "i", "l", NULL},
   {"uB9BBp", "r", "i", "l", NULL},
   {"uB9BCp", "r", "i", "m", NULL},
   {"uB9BDp", "r", "i", "p", NULL},
   {"uB9BEp", "r", "i", "p", NULL},
   {"uB9BFp", "r", "i", "sh", NULL},
   {"uB9C0p", "r", "i", "s", NULL},
   {"uB9C1p", "r", "i", "N", NULL},
   {"uB9C2p", "r", "i", "tS", NULL},
   {"uB9C3p", "r", "i", "tSh", NULL},
   {"uB9C4p", "r", "i", "kh", NULL},
   {"uB9C5p", "r", "i", "th", NULL},
   {"uB9C6p", "r", "i", "ph", NULL},
   {"uB9C7p", "r", "i", "h", NULL},
   {"uB9C8p", "m", "a", NULL, NULL},
   {"uB9C9p", "m", "a", "k", NULL},
   {"uB9CAp", "m", "a", "kGT", NULL},
   {"uB9CBp", "m", "a", "k", NULL},
   {"uB9CCp", "m", "a", "n", NULL},
   {"uB9CDp", "m", "a", "n", NULL},
   {"uB9CEp", "m", "a", "n", NULL},
   {"uB9CFp", "m", "a", "t", NULL},
   {"uB9D0p", "m", "a", "l", NULL},
   {"uB9D1p", "m", "a", "l", NULL},
   {"uB9D2p", "m", "a", "l", NULL},
   {"uB9D3p", "m", "a", "l", NULL},
   {"uB9D4p", "m", "a", "l", NULL},
   {"uB9D5p", "m", "a", "l", NULL},
   {"uB9D6p", "m", "a", "l", NULL},
   {"uB9D7p", "m", "a", "l", NULL},
   {"uB9D8p", "m", "a", "m", NULL},
   {"uB9D9p", "m", "a", "p", NULL},
   {"uB9DAp", "m", "a", "p", NULL},
   {"uB9DBp", "m", "a", "sh", NULL},
   {"uB9DCp", "m", "a", "s", NULL},
   {"uB9DDp", "m", "a", "N", NULL},
   {"uB9DEp", "m", "a", "tS", NULL},
   {"uB9DFp", "m", "a", "tSh", NULL},
   {"uB9E0p", "m", "a", "kh", NULL},
   {"uB9E1p", "m", "a", "th", NULL},
   {"uB9E2p", "m", "a", "ph", NULL},
   {"uB9E3p", "m", "a", "h", NULL},
   {"uB9E4p", "m", "@", NULL, NULL},
   {"uB9E5p", "m", "@", "k", NULL},
   {"uB9E6p", "m", "@", "kGT", NULL},
   {"uB9E7p", "m", "@", "k", NULL},
   {"uB9E8p", "m", "@", "n", NULL},
   {"uB9E9p", "m", "@", "n", NULL},
   {"uB9EAp", "m", "@", "n", NULL},
   {"uB9EBp", "m", "@", "t", NULL},
   {"uB9ECp", "m", "@", "l", NULL},
   {"uB9EDp", "m", "@", "l", NULL},
   {"uB9EEp", "m", "@", "l", NULL},
   {"uB9EFp", "m", "@", "l", NULL},
   {"uB9F0p", "m", "@", "l", NULL},
   {"uB9F1p", "m", "@", "l", NULL},
   {"uB9F2p", "m", "@", "l", NULL},
   {"uB9F3p", "m", "@", "l", NULL},
   {"uB9F4p", "m", "@", "m", NULL},
   {"uB9F5p", "m", "@", "p", NULL},
   {"uB9F6p", "m", "@", "p", NULL},
   {"uB9F7p", "m", "@", "sh", NULL},
   {"uB9F8p", "m", "@", "s", NULL},
   {"uB9F9p", "m", "@", "N", NULL},
   {"uB9FAp", "m", "@", "tS", NULL},
   {"uB9FBp", "m", "@", "tSh", NULL},
   {"uB9FCp", "m", "@", "kh", NULL},
   {"uB9FDp", "m", "@", "th", NULL},
   {"uB9FEp", "m", "@", "ph", NULL},
   {"uB9FFp", "m", "@", "h", NULL},
   {"uBA00p", "m", "j", "a", NULL},
   {"uBA01p", "m", "j", "a", NULL},
   {"uBA02p", "m", "j", "a", NULL},
   {"uBA03p", "m", "j", "a", NULL},
   {"uBA04p", "m", "j", "a", NULL},
   {"uBA05p", "m", "j", "a", NULL},
   {"uBA06p", "m", "j", "a", NULL},
   {"uBA07p", "m", "j", "a", NULL},
   {"uBA08p", "m", "j", "a", NULL},
   {"uBA09p", "m", "j", "a", NULL},
   {"uBA0Ap", "m", "j", "a", NULL},
   {"uBA0Bp", "m", "j", "a", NULL},
   {"uBA0Cp", "m", "j", "a", NULL},
   {"uBA0Dp", "m", "j", "a", NULL},
   {"uBA0Ep", "m", "j", "a", NULL},
   {"uBA0Fp", "m", "j", "a", NULL},
   {"uBA10p", "m", "j", "a", NULL},
   {"uBA11p", "m", "j", "a", NULL},
   {"uBA12p", "m", "j", "a", NULL},
   {"uBA13p", "m", "j", "a", NULL},
   {"uBA14p", "m", "j", "a", NULL},
   {"uBA15p", "m", "j", "a", NULL},
   {"uBA16p", "m", "j", "a", NULL},
   {"uBA17p", "m", "j", "a", NULL},
   {"uBA18p", "m", "j", "a", NULL},
   {"uBA19p", "m", "j", "a", NULL},
   {"uBA1Ap", "m", "j", "a", NULL},
   {"uBA1Bp", "m", "j", "a", NULL},
   {"uBA1Cp", "m", "j", "@", NULL},
   {"uBA1Dp", "m", "j", "@", NULL},
   {"uBA1Ep", "m", "j", "@", NULL},
   {"uBA1Fp", "m", "j", "@", NULL},
   {"uBA20p", "m", "j", "@", NULL},
   {"uBA21p", "m", "j", "@", NULL},
   {"uBA22p", "m", "j", "@", NULL},
   {"uBA23p", "m", "j", "@", NULL},
   {"uBA24p", "m", "j", "@", NULL},
   {"uBA25p", "m", "j", "@", NULL},
   {"uBA26p", "m", "j", "@", NULL},
   {"uBA27p", "m", "j", "@", NULL},
   {"uBA28p", "m", "j", "@", NULL},
   {"uBA29p", "m", "j", "@", NULL},
   {"uBA2Ap", "m", "j", "@", NULL},
   {"uBA2Bp", "m", "j", "@", NULL},
   {"uBA2Cp", "m", "j", "@", NULL},
   {"uBA2Dp", "m", "j", "@", NULL},
   {"uBA2Ep", "m", "j", "@", NULL},
   {"uBA2Fp", "m", "j", "@", NULL},
   {"uBA30p", "m", "j", "@", NULL},
   {"uBA31p", "m", "j", "@", NULL},
   {"uBA32p", "m", "j", "@", NULL},
   {"uBA33p", "m", "j", "@", NULL},
   {"uBA34p", "m", "j", "@", NULL},
   {"uBA35p", "m", "j", "@", NULL},
   {"uBA36p", "m", "j", "@", NULL},
   {"uBA37p", "m", "j", "@", NULL},
   {"uBA38p", "m", "^", NULL, NULL},
   {"uBA39p", "m", "^", "k", NULL},
   {"uBA3Ap", "m", "^", "kGT", NULL},
   {"uBA3Bp", "m", "^", "k", NULL},
   {"uBA3Cp", "m", "^", "n", NULL},
   {"uBA3Dp", "m", "^", "n", NULL},
   {"uBA3Ep", "m", "^", "n", NULL},
   {"uBA3Fp", "m", "^", "t", NULL},
   {"uBA40p", "m", "^", "l", NULL},
   {"uBA41p", "m", "^", "l", NULL},
   {"uBA42p", "m", "^", "l", NULL},
   {"uBA43p", "m", "^", "l", NULL},
   {"uBA44p", "m", "^", "l", NULL},
   {"uBA45p", "m", "^", "l", NULL},
   {"uBA46p", "m", "^", "l", NULL},
   {"uBA47p", "m", "^", "l", NULL},
   {"uBA48p", "m", "^", "m", NULL},
   {"uBA49p", "m", "^", "p", NULL},
   {"uBA4Ap", "m", "^", "p", NULL},
   {"uBA4Bp", "m", "^", "sh", NULL},
   {"uBA4Cp", "m", "^", "s", NULL},
   {"uBA4Dp", "m", "^", "N", NULL},
   {"uBA4Ep", "m", "^", "tS", NULL},
   {"uBA4Fp", "m", "^", "tSh", NULL},
   {"uBA50p", "m", "^", "kh", NULL},
   {"uBA51p", "m", "^", "th", NULL},
   {"uBA52p", "m", "^", "ph", NULL},
   {"uBA53p", "m", "^", "h", NULL},
   {"uBA54p", "m", "e", NULL, NULL},
   {"uBA55p", "m", "e", "k", NULL},
   {"uBA56p", "m", "e", "kGT", NULL},
   {"uBA57p", "m", "e", "k", NULL},
   {"uBA58p", "m", "e", "n", NULL},
   {"uBA59p", "m", "e", "n", NULL},
   {"uBA5Ap", "m", "e", "n", NULL},
   {"uBA5Bp", "m", "e", "t", NULL},
   {"uBA5Cp", "m", "e", "l", NULL},
   {"uBA5Dp", "m", "e", "l", NULL},
   {"uBA5Ep", "m", "e", "l", NULL},
   {"uBA5Fp", "m", "e", "l", NULL},
   {"uBA60p", "m", "e", "l", NULL},
   {"uBA61p", "m", "e", "l", NULL},
   {"uBA62p", "m", "e", "l", NULL},
   {"uBA63p", "m", "e", "l", NULL},
   {"uBA64p", "m", "e", "m", NULL},
   {"uBA65p", "m", "e", "p", NULL},
   {"uBA66p", "m", "e", "p", NULL},
   {"uBA67p", "m", "e", "sh", NULL},
   {"uBA68p", "m", "e", "s", NULL},
   {"uBA69p", "m", "e", "N", NULL},
   {"uBA6Ap", "m", "e", "tS", NULL},
   {"uBA6Bp", "m", "e", "tSh", NULL},
   {"uBA6Cp", "m", "e", "kh", NULL},
   {"uBA6Dp", "m", "e", "th", NULL},
   {"uBA6Ep", "m", "e", "ph", NULL},
   {"uBA6Fp", "m", "e", "h", NULL},
   {"uBA70p", "m", "j", "^", NULL},
   {"uBA71p", "m", "j", "^", NULL},
   {"uBA72p", "m", "j", "^", NULL},
   {"uBA73p", "m", "j", "^", NULL},
   {"uBA74p", "m", "j", "^", NULL},
   {"uBA75p", "m", "j", "^", NULL},
   {"uBA76p", "m", "j", "^", NULL},
   {"uBA77p", "m", "j", "^", NULL},
   {"uBA78p", "m", "j", "^", NULL},
   {"uBA79p", "m", "j", "^", NULL},
   {"uBA7Ap", "m", "j", "^", NULL},
   {"uBA7Bp", "m", "j", "^", NULL},
   {"uBA7Cp", "m", "j", "^", NULL},
   {"uBA7Dp", "m", "j", "^", NULL},
   {"uBA7Ep", "m", "j", "^", NULL},
   {"uBA7Fp", "m", "j", "^", NULL},
   {"uBA80p", "m", "j", "^", NULL},
   {"uBA81p", "m", "j", "^", NULL},
   {"uBA82p", "m", "j", "^", NULL},
   {"uBA83p", "m", "j", "^", NULL},
   {"uBA84p", "m", "j", "^", NULL},
   {"uBA85p", "m", "j", "^", NULL},
   {"uBA86p", "m", "j", "^", NULL},
   {"uBA87p", "m", "j", "^", NULL},
   {"uBA88p", "m", "j", "^", NULL},
   {"uBA89p", "m", "j", "^", NULL},
   {"uBA8Ap", "m", "j", "^", NULL},
   {"uBA8Bp", "m", "j", "^", NULL},
   {"uBA8Cp", "m", "j", "e", NULL},
   {"uBA8Dp", "m", "j", "e", NULL},
   {"uBA8Ep", "m", "j", "e", NULL},
   {"uBA8Fp", "m", "j", "e", NULL},
   {"uBA90p", "m", "j", "e", NULL},
   {"uBA91p", "m", "j", "e", NULL},
   {"uBA92p", "m", "j", "e", NULL},
   {"uBA93p", "m", "j", "e", NULL},
   {"uBA94p", "m", "j", "e", NULL},
   {"uBA95p", "m", "j", "e", NULL},
   {"uBA96p", "m", "j", "e", NULL},
   {"uBA97p", "m", "j", "e", NULL},
   {"uBA98p", "m", "j", "e", NULL},
   {"uBA99p", "m", "j", "e", NULL},
   {"uBA9Ap", "m", "j", "e", NULL},
   {"uBA9Bp", "m", "j", "e", NULL},
   {"uBA9Cp", "m", "j", "e", NULL},
   {"uBA9Dp", "m", "j", "e", NULL},
   {"uBA9Ep", "m", "j", "e", NULL},
   {"uBA9Fp", "m", "j", "e", NULL},
   {"uBAA0p", "m", "j", "e", NULL},
   {"uBAA1p", "m", "j", "e", NULL},
   {"uBAA2p", "m", "j", "e", NULL},
   {"uBAA3p", "m", "j", "e", NULL},
   {"uBAA4p", "m", "j", "e", NULL},
   {"uBAA5p", "m", "j", "e", NULL},
   {"uBAA6p", "m", "j", "e", NULL},
   {"uBAA7p", "m", "j", "e", NULL},
   {"uBAA8p", "m", "o", NULL, NULL},
   {"uBAA9p", "m", "o", "k", NULL},
   {"uBAAAp", "m", "o", "kGT", NULL},
   {"uBAABp", "m", "o", "k", NULL},
   {"uBAACp", "m", "o", "n", NULL},
   {"uBAADp", "m", "o", "n", NULL},
   {"uBAAEp", "m", "o", "n", NULL},
   {"uBAAFp", "m", "o", "t", NULL},
   {"uBAB0p", "m", "o", "l", NULL},
   {"uBAB1p", "m", "o", "l", NULL},
   {"uBAB2p", "m", "o", "l", NULL},
   {"uBAB3p", "m", "o", "l", NULL},
   {"uBAB4p", "m", "o", "l", NULL},
   {"uBAB5p", "m", "o", "l", NULL},
   {"uBAB6p", "m", "o", "l", NULL},
   {"uBAB7p", "m", "o", "l", NULL},
   {"uBAB8p", "m", "o", "m", NULL},
   {"uBAB9p", "m", "o", "p", NULL},
   {"uBABAp", "m", "o", "p", NULL},
   {"uBABBp", "m", "o", "sh", NULL},
   {"uBABCp", "m", "o", "s", NULL},
   {"uBABDp", "m", "o", "N", NULL},
   {"uBABEp", "m", "o", "tS", NULL},
   {"uBABFp", "m", "o", "tSh", NULL},
   {"uBAC0p", "m", "o", "kh", NULL},
   {"uBAC1p", "m", "o", "th", NULL},
   {"uBAC2p", "m", "o", "ph", NULL},
   {"uBAC3p", "m", "o", "h", NULL},
   {"uBAC4p", "m", "w", "a", NULL},
   {"uBAC5p", "m", "w", "a", NULL},
   {"uBAC6p", "m", "w", "a", NULL},
   {"uBAC7p", "m", "w", "a", NULL},
   {"uBAC8p", "m", "w", "a", NULL},
   {"uBAC9p", "m", "w", "a", NULL},
   {"uBACAp", "m", "w", "a", NULL},
   {"uBACBp", "m", "w", "a", NULL},
   {"uBACCp", "m", "w", "a", NULL},
   {"uBACDp", "m", "w", "a", NULL},
   {"uBACEp", "m", "w", "a", NULL},
   {"uBACFp", "m", "w", "a", NULL},
   {"uBAD0p", "m", "w", "a", NULL},
   {"uBADAp", "m", "w", "a", NULL},
   {"uBAD2p", "m", "w", "a", NULL},
   {"uBAD3p", "m", "w", "a", NULL},
   {"uBAD4p", "m", "w", "a", NULL},
   {"uBAD5p", "m", "w", "a", NULL},
   {"uBAD6p", "m", "w", "a", NULL},
   {"uBAD7p", "m", "w", "a", NULL},
   {"uBAD8p", "m", "w", "a", NULL},
   {"uBAD9p", "m", "w", "a", NULL},
   {"uBADAp", "m", "w", "a", NULL},
   {"uBADBp", "m", "w", "a", NULL},
   {"uBADCp", "m", "w", "a", NULL},
   {"uBADDp", "m", "w", "a", NULL},
   {"uBADEp", "m", "w", "a", NULL},
   {"uBADFp", "m", "w", "a", NULL},
   {"uBAE0p", "m", "w", "@", NULL},
   {"uBAE1p", "m", "w", "@", NULL},
   {"uBAE2p", "m", "w", "@", NULL},
   {"uBAE3p", "m", "w", "@", NULL},
   {"uBAE4p", "m", "w", "@", NULL},
   {"uBAE5p", "m", "w", "@", NULL},
   {"uBAE6p", "m", "w", "@", NULL},
   {"uBAE7p", "m", "w", "@", NULL},
   {"uBAE8p", "m", "w", "@", NULL},
   {"uBAE9p", "m", "w", "@", NULL},
   {"uBAEAp", "m", "w", "@", NULL},
   {"uBAEBp", "m", "w", "@", NULL},
   {"uBAECp", "m", "w", "@", NULL},
   {"uBAEDp", "m", "w", "@", NULL},
   {"uBAEEp", "m", "w", "@", NULL},
   {"uBAEFp", "m", "w", "@", NULL},
   {"uBAF0p", "m", "w", "@", NULL},
   {"uBAF1p", "m", "w", "@", NULL},
   {"uBAF2p", "m", "w", "@", NULL},
   {"uBAF3p", "m", "w", "@", NULL},
   {"uBAF4p", "m", "w", "@", NULL},
   {"uBAF5p", "m", "w", "@", NULL},
   {"uBAF6p", "m", "w", "@", NULL},
   {"uBAF7p", "m", "w", "@", NULL},
   {"uBAF8p", "m", "w", "@", NULL},
   {"uBAF9p", "m", "w", "@", NULL},
   {"uBAFAp", "m", "w", "@", NULL},
   {"uBAFBp", "m", "w", "@", NULL},
   {"uBAFCp", "m", "w", "e", NULL},
   {"uBAFDp", "m", "w", "e", NULL},
   {"uBAFEp", "m", "w", "e", NULL},
   {"uBAFFp", "m", "w", "e", NULL},
   {"uBB00p", "m", "w", "e", NULL},
   {"uBB01p", "m", "w", "e", NULL},
   {"uBB02p", "m", "w", "e", NULL},
   {"uBB03p", "m", "w", "e", NULL},
   {"uBB04p", "m", "w", "e", NULL},
   {"uBB05p", "m", "w", "e", NULL},
   {"uBB06p", "m", "w", "e", NULL},
   {"uBB07p", "m", "w", "e", NULL},
   {"uBB08p", "m", "w", "e", NULL},
   {"uBB09p", "m", "w", "e", NULL},
   {"uBB0Ap", "m", "w", "e", NULL},
   {"uBB0Bp", "m", "w", "e", NULL},
   {"uBB0Cp", "m", "w", "e", NULL},
   {"uBB0Dp", "m", "w", "e", NULL},
   {"uBB0Ep", "m", "w", "e", NULL},
   {"uBB0Fp", "m", "w", "e", NULL},
   {"uBB10p", "m", "w", "e", NULL},
   {"uBB11p", "m", "w", "e", NULL},
   {"uBB12p", "m", "w", "e", NULL},
   {"uBB13p", "m", "w", "e", NULL},
   {"uBB14p", "m", "w", "e", NULL},
   {"uBB15p", "m", "w", "e", NULL},
   {"uBB16p", "m", "w", "e", NULL},
   {"uBB17p", "m", "w", "e", NULL},
   {"uBB18p", "m", "j", "o", NULL},
   {"uBB19p", "m", "j", "o", NULL},
   {"uBB1Ap", "m", "j", "o", NULL},
   {"uBB1Bp", "m", "j", "o", NULL},
   {"uBB1Cp", "m", "j", "o", NULL},
   {"uBB1Dp", "m", "j", "o", NULL},
   {"uBB1Ep", "m", "j", "o", NULL},
   {"uBB1Fp", "m", "j", "o", NULL},
   {"uBB20p", "m", "j", "o", NULL},
   {"uBB21p", "m", "j", "o", NULL},
   {"uBB22p", "m", "j", "o", NULL},
   {"uBB23p", "m", "j", "o", NULL},
   {"uBB24p", "m", "j", "o", NULL},
   {"uBB25p", "m", "j", "o", NULL},
   {"uBB26p", "m", "j", "o", NULL},
   {"uBB27p", "m", "j", "o", NULL},
   {"uBB28p", "m", "j", "o", NULL},
   {"uBB29p", "m", "j", "o", NULL},
   {"uBB2Ap", "m", "j", "o", NULL},
   {"uBB2Bp", "m", "j", "o", NULL},
   {"uBB2Cp", "m", "j", "o", NULL},
   {"uBB2Dp", "m", "j", "o", NULL},
   {"uBB2Ep", "m", "j", "o", NULL},
   {"uBB2Fp", "m", "j", "o", NULL},
   {"uBB30p", "m", "j", "o", NULL},
   {"uBB31p", "m", "j", "o", NULL},
   {"uBB32p", "m", "j", "o", NULL},
   {"uBB33p", "m", "j", "o", NULL},
   {"uBB34p", "m", "u", NULL, NULL},
   {"uBB35p", "m", "u", "k", NULL},
   {"uBB36p", "m", "u", "kGT", NULL},
   {"uBB37p", "m", "u", "k", NULL},
   {"uBB38p", "m", "u", "n", NULL},
   {"uBB39p", "m", "u", "n", NULL},
   {"uBB3Ap", "m", "u", "n", NULL},
   {"uBB3Bp", "m", "u", "t", NULL},
   {"uBB3Cp", "m", "u", "l", NULL},
   {"uBB3Dp", "m", "u", "l", NULL},
   {"uBB3Ep", "m", "u", "l", NULL},
   {"uBB3Fp", "m", "u", "l", NULL},
   {"uBB40p", "m", "u", "l", NULL},
   {"uBB41p", "m", "u", "l", NULL},
   {"uBB42p", "m", "u", "l", NULL},
   {"uBB43p", "m", "u", "l", NULL},
   {"uBB44p", "m", "u", "m", NULL},
   {"uBB45p", "m", "u", "p", NULL},
   {"uBB46p", "m", "u", "p", NULL},
   {"uBB47p", "m", "u", "sh", NULL},
   {"uBB48p", "m", "u", "s", NULL},
   {"uBB49p", "m", "u", "N", NULL},
   {"uBB4Ap", "m", "u", "tS", NULL},
   {"uBB4Bp", "m", "u", "tSh", NULL},
   {"uBB4Cp", "m", "u", "kh", NULL},
   {"uBB4Dp", "m", "u", "th", NULL},
   {"uBB4Ep", "m", "u", "ph", NULL},
   {"uBB4Fp", "m", "u", "h", NULL},
   {"uBB50p", "m", "w", "^", NULL},
   {"uBB51p", "m", "w", "^", NULL},
   {"uBB52p", "m", "w", "^", NULL},
   {"uBB53p", "m", "w", "^", NULL},
   {"uBB54p", "m", "w", "^", NULL},
   {"uBB55p", "m", "w", "^", NULL},
   {"uBB56p", "m", "w", "^", NULL},
   {"uBB57p", "m", "w", "^", NULL},
   {"uBB58p", "m", "w", "^", NULL},
   {"uBB59p", "m", "w", "^", NULL},
   {"uBB5Ap", "m", "w", "^", NULL},
   {"uBB5Bp", "m", "w", "^", NULL},
   {"uBB5Cp", "m", "w", "^", NULL},
   {"uBB5Dp", "m", "w", "^", NULL},
   {"uBB5Ep", "m", "w", "^", NULL},
   {"uBB5Fp", "m", "w", "^", NULL},
   {"uBB60p", "m", "w", "^", NULL},
   {"uBB61p", "m", "w", "^", NULL},
   {"uBB62p", "m", "w", "^", NULL},
   {"uBB63p", "m", "w", "^", NULL},
   {"uBB64p", "m", "w", "^", NULL},
   {"uBB65p", "m", "w", "^", NULL},
   {"uBB66p", "m", "w", "^", NULL},
   {"uBB67p", "m", "w", "^", NULL},
   {"uBB68p", "m", "w", "^", NULL},
   {"uBB69p", "m", "w", "^", NULL},
   {"uBB6Ap", "m", "w", "^", NULL},
   {"uBB6Bp", "m", "w", "^", NULL},
   {"uBB6Cp", "m", "w", "e", NULL},
   {"uBB6Dp", "m", "w", "e", NULL},
   {"uBB6Ep", "m", "w", "e", NULL},
   {"uBB6Fp", "m", "w", "e", NULL},
   {"uBB70p", "m", "w", "e", NULL},
   {"uBB71p", "m", "w", "e", NULL},
   {"uBB72p", "m", "w", "e", NULL},
   {"uBB73p", "m", "w", "e", NULL},
   {"uBB74p", "m", "w", "e", NULL},
   {"uBB75p", "m", "w", "e", NULL},
   {"uBB76p", "m", "w", "e", NULL},
   {"uBB77p", "m", "w", "e", NULL},
   {"uBB78p", "m", "w", "e", NULL},
   {"uBB79p", "m", "w", "e", NULL},
   {"uBB7Ap", "m", "w", "e", NULL},
   {"uBB7Bp", "m", "w", "e", NULL},
   {"uBB7Cp", "m", "w", "e", NULL},
   {"uBB7Dp", "m", "w", "e", NULL},
   {"uBB7Ep", "m", "w", "e", NULL},
   {"uBB7Fp", "m", "w", "e", NULL},
   {"uBB80p", "m", "w", "e", NULL},
   {"uBB81p", "m", "w", "e", NULL},
   {"uBB82p", "m", "w", "e", NULL},
   {"uBB83p", "m", "w", "e", NULL},
   {"uBB84p", "m", "w", "e", NULL},
   {"uBB85p", "m", "w", "e", NULL},
   {"uBB86p", "m", "w", "e", NULL},
   {"uBB87p", "m", "w", "e", NULL},
   {"uBB88p", "m", "7", NULL, NULL},
   {"uBB89p", "m", "7", "k", NULL},
   {"uBB8Ap", "m", "7", "kGT", NULL},
   {"uBB8Bp", "m", "7", "k", NULL},
   {"uBB8Cp", "m", "7", "n", NULL},
   {"uBB8Dp", "m", "7", "n", NULL},
   {"uBB8Ep", "m", "7", "n", NULL},
   {"uBB8Fp", "m", "7", "t", NULL},
   {"uBB90p", "m", "7", "l", NULL},
   {"uBB91p", "m", "7", "l", NULL},
   {"uBB92p", "m", "7", "l", NULL},
   {"uBB93p", "m", "7", "l", NULL},
   {"uBB94p", "m", "7", "l", NULL},
   {"uBB95p", "m", "7", "l", NULL},
   {"uBB96p", "m", "7", "l", NULL},
   {"uBB97p", "m", "7", "l", NULL},
   {"uBB98p", "m", "7", "m", NULL},
   {"uBB99p", "m", "7", "p", NULL},
   {"uBB9Ap", "m", "7", "p", NULL},
   {"uBB9Bp", "m", "7", "sh", NULL},
   {"uBB9Cp", "m", "7", "s", NULL},
   {"uBB9Dp", "m", "7", "N", NULL},
   {"uBB9Ep", "m", "7", "tS", NULL},
   {"uBB9Fp", "m", "7", "tSh", NULL},
   {"uBBA0p", "m", "7", "kh", NULL},
   {"uBBA1p", "m", "7", "th", NULL},
   {"uBBA2p", "m", "7", "ph", NULL},
   {"uBBA3p", "m", "7", "h", NULL},
   {"uBBA4p", "m", "j", "u", NULL},
   {"uBBA5p", "m", "j", "u", NULL},
   {"uBBA6p", "m", "j", "u", NULL},
   {"uBBA7p", "m", "j", "u", NULL},
   {"uBBA8p", "m", "j", "u", NULL},
   {"uBBA9p", "m", "j", "u", NULL},
   {"uBBAAp", "m", "j", "u", NULL},
   {"uBBABp", "m", "j", "u", NULL},
   {"uBBACp", "m", "j", "u", NULL},
   {"uBBADp", "m", "j", "u", NULL},
   {"uBBAEp", "m", "j", "u", NULL},
   {"uBBAFp", "m", "j", "u", NULL},
   {"uBBB0p", "m", "j", "u", NULL},
   {"uBBB1p", "m", "j", "u", NULL},
   {"uBBB2p", "m", "j", "u", NULL},
   {"uBBB3p", "m", "j", "u", NULL},
   {"uBBB4p", "m", "j", "u", NULL},
   {"uBBB5p", "m", "j", "u", NULL},
   {"uBBB6p", "m", "j", "u", NULL},
   {"uBBB7p", "m", "j", "u", NULL},
   {"uBBB8p", "m", "j", "u", NULL},
   {"uBBB9p", "m", "j", "u", NULL},
   {"uBBBAp", "m", "j", "u", NULL},
   {"uBBBBp", "m", "j", "u", NULL},
   {"uBBBCp", "m", "j", "u", NULL},
   {"uBBBDp", "m", "j", "u", NULL},
   {"uBBBEp", "m", "j", "u", NULL},
   {"uBBBFp", "m", "j", "u", NULL},
   {"uBBC0p", "m", "4", NULL, NULL},
   {"uBBC1p", "m", "4", "k", NULL},
   {"uBBC2p", "m", "4", "kGT", NULL},
   {"uBBC3p", "m", "4", "k", NULL},
   {"uBBC4p", "m", "4", "n", NULL},
   {"uBBC5p", "m", "4", "n", NULL},
   {"uBBC6p", "m", "4", "n", NULL},
   {"uBBC7p", "m", "4", "t", NULL},
   {"uBBC8p", "m", "4", "l", NULL},
   {"uBBC9p", "m", "4", "l", NULL},
   {"uBBCAp", "m", "4", "l", NULL},
   {"uBBCBp", "m", "4", "l", NULL},
   {"uBBCCp", "m", "4", "l", NULL},
   {"uBBCDp", "m", "4", "l", NULL},
   {"uBBCEp", "m", "4", "l", NULL},
   {"uBBCFp", "m", "4", "l", NULL},
   {"uBBD0p", "m", "4", "m", NULL},
   {"uBBD1p", "m", "4", "p", NULL},
   {"uBBD2p", "m", "4", "p", NULL},
   {"uBBD3p", "m", "4", "sh", NULL},
   {"uBBD4p", "m", "4", "s", NULL},
   {"uBBD5p", "m", "4", "N", NULL},
   {"uBBD6p", "m", "4", "tS", NULL},
   {"uBBD7p", "m", "4", "tSh", NULL},
   {"uBBD8p", "m", "4", "kh", NULL},
   {"uBBD9p", "m", "4", "th", NULL},
   {"uBBDAp", "m", "4", "ph", NULL},
   {"uBBDBp", "m", "4", "h", NULL},
   {"uBBDCp", "m", "4", "j", NULL},
   {"uBBDDp", "m", "4", "j", NULL},
   {"uBBDEp", "m", "4", "j", NULL},
   {"uBBDFp", "m", "4", "j", NULL},
   {"uBBE0p", "m", "4", "j", NULL},
   {"uBBE1p", "m", "4", "j", NULL},
   {"uBBE2p", "m", "4", "j", NULL},
   {"uBBE3p", "m", "4", "j", NULL},
   {"uBBE4p", "m", "4", "j", NULL},
   {"uBBE5p", "m", "4", "j", NULL},
   {"uBBE6p", "m", "4", "j", NULL},
   {"uBBE7p", "m", "4", "j", NULL},
   {"uBBE8p", "m", "4", "j", NULL},
   {"uBBE9p", "m", "4", "j", NULL},
   {"uBBEAp", "m", "4", "j", NULL},
   {"uBBEBp", "m", "4", "j", NULL},
   {"uBBECp", "m", "4", "j", NULL},
   {"uBBEDp", "m", "4", "j", NULL},
   {"uBBEEp", "m", "4", "j", NULL},
   {"uBBEFp", "m", "4", "j", NULL},
   {"uBBF0p", "m", "4", "j", NULL},
   {"uBBF1p", "m", "4", "j", NULL},
   {"uBBF2p", "m", "4", "j", NULL},
   {"uBBF3p", "m", "4", "j", NULL},
   {"uBBF4p", "m", "4", "j", NULL},
   {"uBBF5p", "m", "4", "j", NULL},
   {"uBBF6p", "m", "4", "j", NULL},
   {"uBBF7p", "m", "4", "j", NULL},
   {"uBBF8p", "m", "i", NULL, NULL},
   {"uBBF9p", "m", "i", "k", NULL},
   {"uBBFAp", "m", "i", "kGT", NULL},
   {"uBBFBp", "m", "i", "k", NULL},
   {"uBBFCp", "m", "i", "n", NULL},
   {"uBBFDp", "m", "i", "n", NULL},
   {"uBBFEp", "m", "i", "n", NULL},
   {"uBBFFp", "m", "i", "t", NULL},
   {"uBC00p", "m", "i", "l", NULL},
   {"uBC01p", "m", "i", "l", NULL},
   {"uBC02p", "m", "i", "l", NULL},
   {"uBC03p", "m", "i", "l", NULL},
   {"uBC04p", "m", "i", "l", NULL},
   {"uBC05p", "m", "i", "l", NULL},
   {"uBC06p", "m", "i", "l", NULL},
   {"uBC07p", "m", "i", "l", NULL},
   {"uBC08p", "m", "i", "m", NULL},
   {"uBC09p", "m", "i", "p", NULL},
   {"uBC0Ap", "m", "i", "p", NULL},
   {"uBC0Bp", "m", "i", "sh", NULL},
   {"uBC0Cp", "m", "i", "s", NULL},
   {"uBC0Dp", "m", "i", "N", NULL},
   {"uBC0Ep", "m", "i", "tS", NULL},
   {"uBC0Fp", "m", "i", "tSh", NULL},
   {"uBC10p", "m", "i", "kh", NULL},
   {"uBC11p", "m", "i", "th", NULL},
   {"uBC12p", "m", "i", "ph", NULL},
   {"uBC13p", "m", "i", "h", NULL},
   {"uBC14p", "p", "a", NULL, NULL},
   {"uBC15p", "p", "a", "k", NULL},
   {"uBC16p", "p", "a", "kGT", NULL},
   {"uBC17p", "p", "a", "k", NULL},
   {"uBC18p", "p", "a", "n", NULL},
   {"uBC19p", "p", "a", "n", NULL},
   {"uBC1Ap", "p", "a", "n", NULL},
   {"uBC1Bp", "p", "a", "t", NULL},
   {"uBC1Cp", "p", "a", "l", NULL},
   {"uBC1Dp", "p", "a", "l", NULL},
   {"uBC1Ep", "p", "a", "l", NULL},
   {"uBC1Fp", "p", "a", "l", NULL},
   {"uBC20p", "p", "a", "l", NULL},
   {"uBC21p", "p", "a", "l", NULL},
   {"uBC22p", "p", "a", "l", NULL},
   {"uBC23p", "p", "a", "l", NULL},
   {"uBC24p", "p", "a", "m", NULL},
   {"uBC25p", "p", "a", "p", NULL},
   {"uBC26p", "p", "a", "p", NULL},
   {"uBC27p", "p", "a", "k", NULL},
   {"uBC28p", "p", "a", "s", NULL},
   {"uBC29p", "p", "a", "N", NULL},
   {"uBC2Ap", "p", "a", "tS", NULL},
   {"uBC2Bp", "p", "a", "tSh", NULL},
   {"uBC2Cp", "p", "a", "kh", NULL},
   {"uBC2Dp", "p", "a", "th", NULL},
   {"uBC2Ep", "p", "a", "ph", NULL},
   {"uBC2Fp", "p", "a", "h", NULL},
   {"uBC30p", "p", "@", NULL, NULL},
   {"uBC31p", "p", "@", "k", NULL},
   {"uBC32p", "p", "@", "kGT", NULL},
   {"uBC33p", "p", "@", "k", NULL},
   {"uBC34p", "p", "@", "n", NULL},
   {"uBC35p", "p", "@", "n", NULL},
   {"uBC36p", "p", "@", "n", NULL},
   {"uBC37p", "p", "@", "t", NULL},
   {"uBC38p", "p", "@", "l", NULL},
   {"uBC39p", "p", "@", "l", NULL},
   {"uBC3Ap", "p", "@", "l", NULL},
   {"uBC3Bp", "p", "@", "l", NULL},
   {"uBC3Cp", "p", "@", "l", NULL},
   {"uBC3Dp", "p", "@", "l", NULL},
   {"uBC3Ep", "p", "@", "l", NULL},
   {"uBC3Fp", "p", "@", "l", NULL},
   {"uBC40p", "p", "@", "m", NULL},
   {"uBC41p", "p", "@", "p", NULL},
   {"uBC42p", "p", "@", "p", NULL},
   {"uBC43p", "p", "@", "sh", NULL},
   {"uBC44p", "p", "@", "s", NULL},
   {"uBC45p", "p", "@", "N", NULL},
   {"uBC46p", "p", "@", "tS", NULL},
   {"uBC47p", "p", "@", "tSh", NULL},
   {"uBC48p", "p", "@", "kh", NULL},
   {"uBC49p", "p", "@", "th", NULL},
   {"uBC4Ap", "p", "@", "ph", NULL},
   {"uBC4Bp", "p", "@", "h", NULL},
   {"uBC4Cp", "p", "j", "a", NULL},
   {"uBC4Dp", "p", "j", "a", NULL},
   {"uBC4Ep", "p", "j", "a", NULL},
   {"uBC4Fp", "p", "j", "a", NULL},
   {"uBC50p", "p", "j", "a", NULL},
   {"uBC51p", "p", "j", "a", NULL},
   {"uBC52p", "p", "j", "a", NULL},
   {"uBC53p", "p", "j", "a", NULL},
   {"uBC54p", "p", "j", "a", NULL},
   {"uBC55p", "p", "j", "a", NULL},
   {"uBC56p", "p", "j", "a", NULL},
   {"uBC57p", "p", "j", "a", NULL},
   {"uBC58p", "p", "j", "a", NULL},
   {"uBC59p", "p", "j", "a", NULL},
   {"uBC5Ap", "p", "j", "a", NULL},
   {"uBC5Bp", "p", "j", "a", NULL},
   {"uBC5Cp", "p", "j", "a", NULL},
   {"uBC5Dp", "p", "j", "a", NULL},
   {"uBC5Ep", "p", "j", "a", NULL},
   {"uBC5Fp", "p", "j", "a", NULL},
   {"uBC60p", "p", "j", "a", NULL},
   {"uBC61p", "p", "j", "a", NULL},
   {"uBC62p", "p", "j", "a", NULL},
   {"uBC63p", "p", "j", "a", NULL},
   {"uBC64p", "p", "j", "a", NULL},
   {"uBC65p", "p", "j", "a", NULL},
   {"uBC66p", "p", "j", "a", NULL},
   {"uBC67p", "p", "j", "a", NULL},
   {"uBC68p", "p", "j", "@", NULL},
   {"uBC69p", "p", "j", "@", NULL},
   {"uBC6Ap", "p", "j", "@", NULL},
   {"uBC6Bp", "p", "j", "@", NULL},
   {"uBC6Cp", "p", "j", "@", NULL},
   {"uBC6Dp", "p", "j", "@", NULL},
   {"uBC6Ep", "p", "j", "@", NULL},
   {"uBC6Fp", "p", "j", "@", NULL},
   {"uBC70p", "p", "j", "@", NULL},
   {"uBC71p", "p", "j", "@", NULL},
   {"uBC72p", "p", "j", "@", NULL},
   {"uBC73p", "p", "j", "@", NULL},
   {"uBC74p", "p", "j", "@", NULL},
   {"uBC75p", "p", "j", "@", NULL},
   {"uBC76p", "p", "j", "@", NULL},
   {"uBC77p", "p", "j", "@", NULL},
   {"uBC78p", "p", "j", "@", NULL},
   {"uBC79p", "p", "j", "@", NULL},
   {"uBC7Ap", "p", "j", "@", NULL},
   {"uBC7Bp", "p", "j", "@", NULL},
   {"uBC7Cp", "p", "j", "@", NULL},
   {"uBC7Dp", "p", "j", "@", NULL},
   {"uBC7Ep", "p", "j", "@", NULL},
   {"uBC7Fp", "p", "j", "@", NULL},
   {"uBC80p", "p", "j", "@", NULL},
   {"uBC81p", "p", "j", "@", NULL},
   {"uBC82p", "p", "j", "@", NULL},
   {"uBC83p", "p", "j", "@", NULL},
   {"uBC84p", "p", "^", NULL, NULL},
   {"uBC85p", "p", "^", "k", NULL},
   {"uBC86p", "p", "^", "kGT", NULL},
   {"uBC87p", "p", "^", "k", NULL},
   {"uBC88p", "p", "^", "n", NULL},
   {"uBC89p", "p", "^", "n", NULL},
   {"uBC8Ap", "p", "^", "n", NULL},
   {"uBC8Bp", "p", "^", "t", NULL},
   {"uBC8Cp", "p", "^", "l", NULL},
   {"uBC8Dp", "p", "^", "l", NULL},
   {"uBC8Ep", "p", "^", "l", NULL},
   {"uBC8Fp", "p", "^", "l", NULL},
   {"uBC90p", "p", "^", "l", NULL},
   {"uBC91p", "p", "^", "l", NULL},
   {"uBC92p", "p", "^", "l", NULL},
   {"uBC93p", "p", "^", "l", NULL},
   {"uBC94p", "p", "^", "m", NULL},
   {"uBC95p", "p", "^", "p", NULL},
   {"uBC96p", "p", "^", "p", NULL},
   {"uBC97p", "p", "^", "sh", NULL},
   {"uBC98p", "p", "^", "s", NULL},
   {"uBC99p", "p", "^", "N", NULL},
   {"uBC9Ap", "p", "^", "tS", NULL},
   {"uBC9Bp", "p", "^", "tSh", NULL},
   {"uBC9Cp", "p", "^", "kh", NULL},
   {"uBC9Dp", "p", "^", "th", NULL},
   {"uBC9Ep", "p", "^", "ph", NULL},
   {"uBC9Fp", "p", "^", "h", NULL},
   {"uBCA0p", "p", "e", NULL, NULL},
   {"uBCA1p", "p", "e", "k", NULL},
   {"uBCA2p", "p", "e", "kGT", NULL},
   {"uBCA3p", "p", "e", "k", NULL},
   {"uBCA4p", "p", "e", "n", NULL},
   {"uBCA5p", "p", "e", "n", NULL},
   {"uBCA6p", "p", "e", "n", NULL},
   {"uBCA7p", "p", "e", "t", NULL},
   {"uBCA8p", "p", "e", "l", NULL},
   {"uBCA9p", "p", "e", "l", NULL},
   {"uBCAAp", "p", "e", "l", NULL},
   {"uBCABp", "p", "e", "l", NULL},
   {"uBCACp", "p", "e", "l", NULL},
   {"uBCADp", "p", "e", "l", NULL},
   {"uBCAEp", "p", "e", "l", NULL},
   {"uBCAFp", "p", "e", "l", NULL},
   {"uBCB0p", "p", "e", "m", NULL},
   {"uBCB1p", "p", "e", "p", NULL},
   {"uBCB2p", "p", "e", "p", NULL},
   {"uBCB3p", "p", "e", "sh", NULL},
   {"uBCB4p", "p", "e", "s", NULL},
   {"uBCB5p", "p", "e", "N", NULL},
   {"uBCB6p", "p", "e", "tS", NULL},
   {"uBCB7p", "p", "e", "tSh", NULL},
   {"uBCB8p", "p", "e", "kh", NULL},
   {"uBCB9p", "p", "e", "th", NULL},
   {"uBCBAp", "p", "e", "ph", NULL},
   {"uBCBBp", "p", "e", "h", NULL},
   {"uBCBCp", "p", "j", "^", NULL},
   {"uBCBDp", "p", "j", "^", NULL},
   {"uBCBEp", "p", "j", "^", NULL},
   {"uBCBFp", "p", "j", "^", NULL},
   {"uBCC0p", "p", "j", "^", NULL},
   {"uBCC1p", "p", "j", "^", NULL},
   {"uBCC2p", "p", "j", "^", NULL},
   {"uBCC3p", "p", "j", "^", NULL},
   {"uBCC4p", "p", "j", "^", NULL},
   {"uBCC5p", "p", "j", "^", NULL},
   {"uBCC6p", "p", "j", "^", NULL},
   {"uBCC7p", "p", "j", "^", NULL},
   {"uBCC8p", "p", "j", "^", NULL},
   {"uBCC9p", "p", "j", "^", NULL},
   {"uBCCAp", "p", "j", "^", NULL},
   {"uBCCBp", "p", "j", "^", NULL},
   {"uBCCCp", "p", "j", "^", NULL},
   {"uBCCDp", "p", "j", "^", NULL},
   {"uBCCEp", "p", "j", "^", NULL},
   {"uBCCFp", "p", "j", "^", NULL},
   {"uBCD0p", "p", "j", "^", NULL},
   {"uBCD1p", "p", "j", "^", NULL},
   {"uBCD2p", "p", "j", "^", NULL},
   {"uBCD3p", "p", "j", "^", NULL},
   {"uBCD4p", "p", "j", "^", NULL},
   {"uBCD5p", "p", "j", "^", NULL},
   {"uBCD6p", "p", "j", "^", NULL},
   {"uBCD7p", "p", "j", "^", NULL},
   {"uBCD8p", "p", "j", "e", NULL},
   {"uBCD9p", "p", "j", "e", NULL},
   {"uBCDAp", "p", "j", "e", NULL},
   {"uBCDBp", "p", "j", "e", NULL},
   {"uBCDCp", "p", "j", "e", NULL},
   {"uBCDDp", "p", "j", "e", NULL},
   {"uBCDEp", "p", "j", "e", NULL},
   {"uBCDFp", "p", "j", "e", NULL},
   {"uBCE0p", "p", "j", "e", NULL},
   {"uBCE1p", "p", "j", "e", NULL},
   {"uBCE2p", "p", "j", "e", NULL},
   {"uBCE3p", "p", "j", "e", NULL},
   {"uBCE4p", "p", "j", "e", NULL},
   {"uBCE5p", "p", "j", "e", NULL},
   {"uBCE6p", "p", "j", "e", NULL},
   {"uBCE7p", "p", "j", "e", NULL},
   {"uBCE8p", "p", "j", "e", NULL},
   {"uBCE9p", "p", "j", "e", NULL},
   {"uBCEAp", "p", "j", "e", NULL},
   {"uBCEBp", "p", "j", "e", NULL},
   {"uBCECp", "p", "j", "e", NULL},
   {"uBCEDp", "p", "j", "e", NULL},
   {"uBCEEp", "p", "j", "e", NULL},
   {"uBCEFp", "p", "j", "e", NULL},
   {"uBCF0p", "p", "j", "e", NULL},
   {"uBCF1p", "p", "j", "e", NULL},
   {"uBCF2p", "p", "j", "e", NULL},
   {"uBCF3p", "p", "j", "e", NULL},
   {"uBCF4p", "p", "o", NULL, NULL},
   {"uBCF5p", "p", "o", "k", NULL},
   {"uBCF6p", "p", "o", "kGT", NULL},
   {"uBCF7p", "p", "o", "k", NULL},
   {"uBCF8p", "p", "o", "n", NULL},
   {"uBCF9p", "p", "o", "n", NULL},
   {"uBCFAp", "p", "o", "n", NULL},
   {"uBCFBp", "p", "o", "t", NULL},
   {"uBCFCp", "p", "o", "l", NULL},
   {"uBCFDp", "p", "o", "l", NULL},
   {"uBCFEp", "p", "o", "l", NULL},
   {"uBCFFp", "p", "o", "l", NULL},
   {"uBD00p", "p", "o", "l", NULL},
   {"uBD01p", "p", "o", "l", NULL},
   {"uBD02p", "p", "o", "l", NULL},
   {"uBD03p", "p", "o", "l", NULL},
   {"uBD04p", "p", "o", "m", NULL},
   {"uBD05p", "p", "o", "p", NULL},
   {"uBD06p", "p", "o", "p", NULL},
   {"uBD07p", "p", "o", "sh", NULL},
   {"uBD08p", "p", "o", "s", NULL},
   {"uBD09p", "p", "o", "N", NULL},
   {"uBD0Ap", "p", "o", "tS", NULL},
   {"uBD0Bp", "p", "o", "tSh", NULL},
   {"uBD0Cp", "p", "o", "kh", NULL},
   {"uBD0Dp", "p", "o", "th", NULL},
   {"uBD0Ep", "p", "o", "ph", NULL},
   {"uBD0Fp", "p", "o", "h", NULL},
   {"uBD10p", "p", "w", "a", NULL},
   {"uBD11p", "p", "w", "a", NULL},
   {"uBD12p", "p", "w", "a", NULL},
   {"uBD13p", "p", "w", "a", NULL},
   {"uBD14p", "p", "w", "a", NULL},
   {"uBD15p", "p", "w", "a", NULL},
   {"uBD16p", "p", "w", "a", NULL},
   {"uBD17p", "p", "w", "a", NULL},
   {"uBD18p", "p", "w", "a", NULL},
   {"uBD19p", "p", "w", "a", NULL},
   {"uBD1Ap", "p", "w", "a", NULL},
   {"uBD1Bp", "p", "w", "a", NULL},
   {"uBD1Cp", "p", "w", "a", NULL},
   {"uBD1Dp", "p", "w", "a", NULL},
   {"uBD1Ep", "p", "w", "a", NULL},
   {"uBD1Fp", "p", "w", "a", NULL},
   {"uBD20p", "p", "w", "a", NULL},
   {"uBD21p", "p", "w", "a", NULL},
   {"uBD22p", "p", "w", "a", NULL},
   {"uBD23p", "p", "w", "a", NULL},
   {"uBD24p", "p", "w", "a", NULL},
   {"uBD25p", "p", "w", "a", NULL},
   {"uBD26p", "p", "w", "a", NULL},
   {"uBD27p", "p", "w", "a", NULL},
   {"uBD28p", "p", "w", "a", NULL},
   {"uBD29p", "p", "w", "a", NULL},
   {"uBD2Ap", "p", "w", "a", NULL},
   {"uBD2Bp", "p", "w", "a", NULL},
   {"uBD2Cp", "p", "w", "@", NULL},
   {"uBD2Dp", "p", "w", "@", NULL},
   {"uBD2Ep", "p", "w", "@", NULL},
   {"uBD2Fp", "p", "w", "@", NULL},
   {"uBD30p", "p", "w", "@", NULL},
   {"uBD31p", "p", "w", "@", NULL},
   {"uBD32p", "p", "w", "@", NULL},
   {"uBD33p", "p", "w", "@", NULL},
   {"uBD34p", "p", "w", "@", NULL},
   {"uBD35p", "p", "w", "@", NULL},
   {"uBD36p", "p", "w", "@", NULL},
   {"uBD37p", "p", "w", "@", NULL},
   {"uBD38p", "p", "w", "@", NULL},
   {"uBD39p", "p", "w", "@", NULL},
   {"uBD3Ap", "p", "w", "@", NULL},
   {"uBD3Bp", "p", "w", "@", NULL},
   {"uBD3Cp", "p", "w", "@", NULL},
   {"uBD3Dp", "p", "w", "@", NULL},
   {"uBD3Ep", "p", "w", "@", NULL},
   {"uBD3Fp", "p", "w", "@", NULL},
   {"uBD40p", "p", "w", "@", NULL},
   {"uBD41p", "p", "w", "@", NULL},
   {"uBD42p", "p", "w", "@", NULL},
   {"uBD43p", "p", "w", "@", NULL},
   {"uBD44p", "p", "w", "@", NULL},
   {"uBD45p", "p", "w", "@", NULL},
   {"uBD46p", "p", "w", "@", NULL},
   {"uBD47p", "p", "w", "@", NULL},
   {"uBD48p", "p", "w", "e", NULL},
   {"uBD49p", "p", "w", "e", NULL},
   {"uBD4Ap", "p", "w", "e", NULL},
   {"uBD4Bp", "p", "w", "e", NULL},
   {"uBD4Cp", "p", "w", "e", NULL},
   {"uBD4Dp", "p", "w", "e", NULL},
   {"uBD4Ep", "p", "w", "e", NULL},
   {"uBD4Fp", "p", "w", "e", NULL},
   {"uBD50p", "p", "w", "e", NULL},
   {"uBD51p", "p", "w", "e", NULL},
   {"uBD52p", "p", "w", "e", NULL},
   {"uBD53p", "p", "w", "e", NULL},
   {"uBD54p", "p", "w", "e", NULL},
   {"uBD55p", "p", "w", "e", NULL},
   {"uBD56p", "p", "w", "e", NULL},
   {"uBD57p", "p", "w", "e", NULL},
   {"uBD58p", "p", "w", "e", NULL},
   {"uBD59p", "p", "w", "e", NULL},
   {"uBD5Ap", "p", "w", "e", NULL},
   {"uBD5Bp", "p", "w", "e", NULL},
   {"uBD5Cp", "p", "w", "e", NULL},
   {"uBD5Dp", "p", "w", "e", NULL},
   {"uBD5Ep", "p", "w", "e", NULL},
   {"uBD5Fp", "p", "w", "e", NULL},
   {"uBD60p", "p", "w", "e", NULL},
   {"uBD61p", "p", "w", "e", NULL},
   {"uBD62p", "p", "w", "e", NULL},
   {"uBD63p", "p", "w", "e", NULL},
   {"uBD64p", "p", "j", "o", NULL},
   {"uBD65p", "p", "j", "o", NULL},
   {"uBD66p", "p", "j", "o", NULL},
   {"uBD67p", "p", "j", "o", NULL},
   {"uBD68p", "p", "j", "o", NULL},
   {"uBD69p", "p", "j", "o", NULL},
   {"uBD6Ap", "p", "j", "o", NULL},
   {"uBD6Bp", "p", "j", "o", NULL},
   {"uBD6Cp", "p", "j", "o", NULL},
   {"uBD6Dp", "p", "j", "o", NULL},
   {"uBD6Ep", "p", "j", "o", NULL},
   {"uBD6Fp", "p", "j", "o", NULL},
   {"uBD70p", "p", "j", "o", NULL},
   {"uBD71p", "p", "j", "o", NULL},
   {"uBD72p", "p", "j", "o", NULL},
   {"uBD73p", "p", "j", "o", NULL},
   {"uBD74p", "p", "j", "o", NULL},
   {"uBD75p", "p", "j", "o", NULL},
   {"uBD76p", "p", "j", "o", NULL},
   {"uBD77p", "p", "j", "o", NULL},
   {"uBD78p", "p", "j", "o", NULL},
   {"uBD79p", "p", "j", "o", NULL},
   {"uBD7Ap", "p", "j", "o", NULL},
   {"uBD7Bp", "p", "j", "o", NULL},
   {"uBD7Cp", "p", "j", "o", NULL},
   {"uBD7Dp", "p", "j", "o", NULL},
   {"uBD7Ep", "p", "j", "o", NULL},
   {"uBD7Fp", "p", "j", "o", NULL},
   {"uBD80p", "p", "u", NULL, NULL},
   {"uBD81p", "p", "u", "k", NULL},
   {"uBD82p", "p", "u", "kGT", NULL},
   {"uBD83p", "p", "u", "k", NULL},
   {"uBD84p", "p", "u", "n", NULL},
   {"uBD85p", "p", "u", "n", NULL},
   {"uBD86p", "p", "u", "n", NULL},
   {"uBD87p", "p", "u", "t", NULL},
   {"uBD88p", "p", "u", "l", NULL},
   {"uBD89p", "p", "u", "l", NULL},
   {"uBD8Ap", "p", "u", "l", NULL},
   {"uBD8Bp", "p", "u", "l", NULL},
   {"uBD8Cp", "p", "u", "l", NULL},
   {"uBD8Dp", "p", "u", "l", NULL},
   {"uBD8Ep", "p", "u", "l", NULL},
   {"uBD8Fp", "p", "u", "l", NULL},
   {"uBD90p", "p", "u", "m", NULL},
   {"uBD91p", "p", "u", "p", NULL},
   {"uBD92p", "p", "u", "p", NULL},
   {"uBD93p", "p", "u", "sh", NULL},
   {"uBD94p", "p", "u", "s", NULL},
   {"uBD95p", "p", "u", "N", NULL},
   {"uBD96p", "p", "u", "tS", NULL},
   {"uBD97p", "p", "u", "tSh", NULL},
   {"uBD98p", "p", "u", "kh", NULL},
   {"uBD99p", "p", "u", "th", NULL},
   {"uBD9Ap", "p", "u", "ph", NULL},
   {"uBD9Bp", "p", "u", "h", NULL},
   {"uBD9Cp", "p", "w", "^", NULL},
   {"uBD9Dp", "p", "w", "^", NULL},
   {"uBD9Ep", "p", "w", "^", NULL},
   {"uBD9Fp", "p", "w", "^", NULL},
   {"uBDA0p", "p", "w", "^", NULL},
   {"uBDA1p", "p", "w", "^", NULL},
   {"uBDA2p", "p", "w", "^", NULL},
   {"uBDA3p", "p", "w", "^", NULL},
   {"uBDA4p", "p", "w", "^", NULL},
   {"uBDA5p", "p", "w", "^", NULL},
   {"uBDA6p", "p", "w", "^", NULL},
   {"uBDA7p", "p", "w", "^", NULL},
   {"uBDA8p", "p", "w", "^", NULL},
   {"uBDA9p", "p", "w", "^", NULL},
   {"uBDAAp", "p", "w", "^", NULL},
   {"uBDABp", "p", "w", "^", NULL},
   {"uBDACp", "p", "w", "^", NULL},
   {"uBDADp", "p", "w", "^", NULL},
   {"uBDAEp", "p", "w", "^", NULL},
   {"uBDAFp", "p", "w", "^", NULL},
   {"uBDB0p", "p", "w", "^", NULL},
   {"uBDB1p", "p", "w", "^", NULL},
   {"uBDB2p", "p", "w", "^", NULL},
   {"uBDB3p", "p", "w", "^", NULL},
   {"uBDB4p", "p", "w", "^", NULL},
   {"uBDB5p", "p", "w", "^", NULL},
   {"uBDB6p", "p", "w", "^", NULL},
   {"uBDB7p", "p", "w", "^", NULL},
   {"uBDB8p", "p", "w", "e", NULL},
   {"uBDB9p", "p", "w", "e", NULL},
   {"uBDBAp", "p", "w", "e", NULL},
   {"uBDBBp", "p", "w", "e", NULL},
   {"uBDBCp", "p", "w", "e", NULL},
   {"uBDBDp", "p", "w", "e", NULL},
   {"uBDBEp", "p", "w", "e", NULL},
   {"uBDBFp", "p", "w", "e", NULL},
   {"uBDC0p", "p", "w", "e", NULL},
   {"uBDC1p", "p", "w", "e", NULL},
   {"uBDC2p", "p", "w", "e", NULL},
   {"uBDC3p", "p", "w", "e", NULL},
   {"uBDC4p", "p", "w", "e", NULL},
   {"uBDC5p", "p", "w", "e", NULL},
   {"uBDC6p", "p", "w", "e", NULL},
   {"uBDC7p", "p", "w", "e", NULL},
   {"uBDC8p", "p", "w", "e", NULL},
   {"uBDC9p", "p", "w", "e", NULL},
   {"uBDCAp", "p", "w", "e", NULL},
   {"uBDCBp", "p", "w", "e", NULL},
   {"uBDCCp", "p", "w", "e", NULL},
   {"uBDCDp", "p", "w", "e", NULL},
   {"uBDCEp", "p", "w", "e", NULL},
   {"uBDCFp", "p", "w", "e", NULL},
   {"uBDD0p", "p", "w", "e", NULL},
   {"uBDD1p", "p", "w", "e", NULL},
   {"uBDD2p", "p", "w", "e", NULL},
   {"uBDD3p", "p", "w", "e", NULL},
   {"uBDD4p", "p", "7", NULL, NULL},
   {"uBDD5p", "p", "7", "k", NULL},
   {"uBDD6p", "p", "7", "kGT", NULL},
   {"uBDD7p", "p", "7", "k", NULL},
   {"uBDD8p", "p", "7", "n", NULL},
   {"uBDD9p", "p", "7", "n", NULL},
   {"uBDDAp", "p", "7", "n", NULL},
   {"uBDDBp", "p", "7", "t", NULL},
   {"uBDDCp", "p", "7", "l", NULL},
   {"uBDDDp", "p", "7", "l", NULL},
   {"uBDDEp", "p", "7", "l", NULL},
   {"uBDDFp", "p", "7", "l", NULL},
   {"uBDE0p", "p", "7", "l", NULL},
   {"uBDE1p", "p", "7", "l", NULL},
   {"uBDE2p", "p", "7", "l", NULL},
   {"uBDE3p", "p", "7", "l", NULL},
   {"uBDE4p", "p", "7", "m", NULL},
   {"uBDE5p", "p", "7", "p", NULL},
   {"uBDE6p", "p", "7", "p", NULL},
   {"uBDE7p", "p", "7", "sh", NULL},
   {"uBDE8p", "p", "7", "s", NULL},
   {"uBDE9p", "p", "7", "N", NULL},
   {"uBDEAp", "p", "7", "tS", NULL},
   {"uBDEBp", "p", "7", "tSh", NULL},
   {"uBDECp", "p", "7", "kh", NULL},
   {"uBDEDp", "p", "7", "th", NULL},
   {"uBDEEp", "p", "7", "ph", NULL},
   {"uBDEFp", "p", "7", "h", NULL},
   {"uBDF0p", "p", "j", "u", NULL},
   {"uBDF1p", "p", "j", "u", NULL},
   {"uBDF2p", "p", "j", "u", NULL},
   {"uBDF3p", "p", "j", "u", NULL},
   {"uBDF4p", "p", "j", "u", NULL},
   {"uBDF5p", "p", "j", "u", NULL},
   {"uBDF6p", "p", "j", "u", NULL},
   {"uBDF7p", "p", "j", "u", NULL},
   {"uBDF8p", "p", "j", "u", NULL},
   {"uBDF9p", "p", "j", "u", NULL},
   {"uBDFAp", "p", "j", "u", NULL},
   {"uBDFBp", "p", "j", "u", NULL},
   {"uBDFCp", "p", "j", "u", NULL},
   {"uBDFDp", "p", "j", "u", NULL},
   {"uBDFEp", "p", "j", "u", NULL},
   {"uBDFFp", "p", "j", "u", NULL},
   {"uBE00p", "p", "j", "u", NULL},
   {"uBE01p", "p", "j", "u", NULL},
   {"uBE02p", "p", "j", "u", NULL},
   {"uBE03p", "p", "j", "u", NULL},
   {"uBE04p", "p", "j", "u", NULL},
   {"uBE05p", "p", "j", "u", NULL},
   {"uBE06p", "p", "j", "u", NULL},
   {"uBE07p", "p", "j", "u", NULL},
   {"uBE08p", "p", "j", "u", NULL},
   {"uBE09p", "p", "j", "u", NULL},
   {"uBE0Ap", "p", "j", "u", NULL},
   {"uBE0Bp", "p", "j", "u", NULL},
   {"uBE0Cp", "p", "4", NULL, NULL},
   {"uBE0Dp", "p", "4", "k", NULL},
   {"uBE0Ep", "p", "4", "kGT", NULL},
   {"uBE0Fp", "p", "4", "k", NULL},
   {"uBE10p", "p", "4", "n", NULL},
   {"uBE11p", "p", "4", "n", NULL},
   {"uBE12p", "p", "4", "n", NULL},
   {"uBE13p", "p", "4", "t", NULL},
   {"uBE14p", "p", "4", "l", NULL},
   {"uBE15p", "p", "4", "l", NULL},
   {"uBE16p", "p", "4", "l", NULL},
   {"uBE17p", "p", "4", "l", NULL},
   {"uBE18p", "p", "4", "l", NULL},
   {"uBE19p", "p", "4", "l", NULL},
   {"uBE1Ap", "p", "4", "l", NULL},
   {"uBE1Bp", "p", "4", "l", NULL},
   {"uBE1Cp", "p", "4", "m", NULL},
   {"uBE1Dp", "p", "4", "p", NULL},
   {"uBE1Ep", "p", "4", "p", NULL},
   {"uBE1Fp", "p", "4", "sh", NULL},
   {"uBE20p", "p", "4", "s", NULL},
   {"uBE21p", "p", "4", "N", NULL},
   {"uBE22p", "p", "4", "tS", NULL},
   {"uBE23p", "p", "4", "tSh", NULL},
   {"uBE24p", "p", "4", "kh", NULL},
   {"uBE25p", "p", "4", "th", NULL},
   {"uBE26p", "p", "4", "ph", NULL},
   {"uBE27p", "p", "4", "h", NULL},
   {"uBE28p", "p", "4", "j", NULL},
   {"uBE29p", "p", "4", "j", NULL},
   {"uBE2Ap", "p", "4", "j", NULL},
   {"uBE2Bp", "p", "4", "j", NULL},
   {"uBE2Cp", "p", "4", "j", NULL},
   {"uBE2Dp", "p", "4", "j", NULL},
   {"uBE2Ep", "p", "4", "j", NULL},
   {"uBE2Fp", "p", "4", "j", NULL},
   {"uBE30p", "p", "4", "j", NULL},
   {"uBE31p", "p", "4", "j", NULL},
   {"uBE32p", "p", "4", "j", NULL},
   {"uBE33p", "p", "4", "j", NULL},
   {"uBE34p", "p", "4", "j", NULL},
   {"uBE35p", "p", "4", "j", NULL},
   {"uBE36p", "p", "4", "j", NULL},
   {"uBE37p", "p", "4", "j", NULL},
   {"uBE38p", "p", "4", "j", NULL},
   {"uBE39p", "p", "4", "j", NULL},
   {"uBE3Ap", "p", "4", "j", NULL},
   {"uBE3Bp", "p", "4", "j", NULL},
   {"uBE3Cp", "p", "4", "j", NULL},
   {"uBE3Dp", "p", "4", "j", NULL},
   {"uBE3Ep", "p", "4", "j", NULL},
   {"uBE3Fp", "p", "4", "j", NULL},
   {"uBE40p", "p", "4", "j", NULL},
   {"uBE41p", "p", "4", "j", NULL},
   {"uBE42p", "p", "4", "j", NULL},
   {"uBE43p", "p", "4", "j", NULL},
   {"uBE44p", "p", "i", NULL, NULL},
   {"uBE45p", "p", "i", "k", NULL},
   {"uBE46p", "p", "i", "kGT", NULL},
   {"uBE47p", "p", "i", "k", NULL},
   {"uBE48p", "p", "i", "n", NULL},
   {"uBE49p", "p", "i", "n", NULL},
   {"uBE4Ap", "p", "i", "n", NULL},
   {"uBE4Bp", "p", "i", "t", NULL},
   {"uBE4Cp", "p", "i", "l", NULL},
   {"uBE4Dp", "p", "i", "l", NULL},
   {"uBE4Ep", "p", "i", "l", NULL},
   {"uBE4Fp", "p", "i", "l", NULL},
   {"uBE50p", "p", "i", "l", NULL},
   {"uBE51p", "p", "i", "l", NULL},
   {"uBE52p", "p", "i", "l", NULL},
   {"uBE53p", "p", "i", "l", NULL},
   {"uBE54p", "p", "i", "m", NULL},
   {"uBE55p", "p", "i", "p", NULL},
   {"uBE56p", "p", "i", "p", NULL},
   {"uBE57p", "p", "i", "sh", NULL},
   {"uBE58p", "p", "i", "s", NULL},
   {"uBE59p", "p", "i", "N", NULL},
   {"uBE5Ap", "p", "i", "tS", NULL},
   {"uBE5Bp", "p", "i", "tSh", NULL},
   {"uBE5Cp", "p", "i", "kh", NULL},
   {"uBE5Dp", "p", "i", "th", NULL},
   {"uBE5Ep", "p", "i", "ph", NULL},
   {"uBE5Fp", "p", "i", "h", NULL},
   {"uBE60p", "pGT", "a", NULL, NULL},
   {"uBE61p", "pGT", "a", "k", NULL},
   {"uBE62p", "pGT", "a", "kGT", NULL},
   {"uBE63p", "pGT", "a", "k", NULL},
   {"uBE64p", "pGT", "a", "n", NULL},
   {"uBE65p", "pGT", "a", "n", NULL},
   {"uBE66p", "pGT", "a", "n", NULL},
   {"uBE67p", "pGT", "a", "t", NULL},
   {"uBE68p", "pGT", "a", "l", NULL},
   {"uBE69p", "pGT", "a", "l", NULL},
   {"uBE6Ap", "pGT", "a", "l", NULL},
   {"uBE6Bp", "pGT", "a", "l", NULL},
   {"uBE6Cp", "pGT", "a", "l", NULL},
   {"uBE6Dp", "pGT", "a", "l", NULL},
   {"uBE6Ep", "pGT", "a", "l", NULL},
   {"uBE6Fp", "pGT", "a", "l", NULL},
   {"uBE70p", "pGT", "a", "m", NULL},
   {"uBE71p", "pGT", "a", "p", NULL},
   {"uBE72p", "pGT", "a", "p", NULL},
   {"uBE73p", "pGT", "a", "sh", NULL},
   {"uBE74p", "pGT", "a", "s", NULL},
   {"uBE75p", "pGT", "a", "N", NULL},
   {"uBE76p", "pGT", "a", "tS", NULL},
   {"uBE77p", "pGT", "a", "tSh", NULL},
   {"uBE78p", "pGT", "a", "kh", NULL},
   {"uBE79p", "pGT", "a", "th", NULL},
   {"uBE7Ap", "pGT", "a", "ph", NULL},
   {"uBE7Bp", "pGT", "a", "h", NULL},
   {"uBE7Cp", "pGT", "@", NULL, NULL},
   {"uBE7Dp", "pGT", "@", "k", NULL},
   {"uBE7Ep", "pGT", "@", "kGT", NULL},
   {"uBE7Fp", "pGT", "@", "k", NULL},
   {"uBE80p", "pGT", "@", "n", NULL},
   {"uBE81p", "pGT", "@", "n", NULL},
   {"uBE82p", "pGT", "@", "n", NULL},
   {"uBE83p", "pGT", "@", "t", NULL},
   {"uBE84p", "pGT", "@", "l", NULL},
   {"uBE85p", "pGT", "@", "l", NULL},
   {"uBE86p", "pGT", "@", "l", NULL},
   {"uBE87p", "pGT", "@", "l", NULL},
   {"uBE88p", "pGT", "@", "l", NULL},
   {"uBE89p", "pGT", "@", "l", NULL},
   {"uBE8Ap", "pGT", "@", "l", NULL},
   {"uBE8Bp", "pGT", "@", "l", NULL},
   {"uBE8Cp", "pGT", "@", "m", NULL},
   {"uBE8Dp", "pGT", "@", "p", NULL},
   {"uBE8Ep", "pGT", "@", "p", NULL},
   {"uBE8Fp", "pGT", "@", "sh", NULL},
   {"uBE90p", "pGT", "@", "s", NULL},
   {"uBE91p", "pGT", "@", "N", NULL},
   {"uBE92p", "pGT", "@", "tS", NULL},
   {"uBE93p", "pGT", "@", "tSh", NULL},
   {"uBE94p", "pGT", "@", "kh", NULL},
   {"uBE95p", "pGT", "@", "th", NULL},
   {"uBE96p", "pGT", "@", "ph", NULL},
   {"uBE97p", "pGT", "@", "h", NULL},
   {"uBE98p", "pGT", "j", "a", NULL},
   {"uBE99p", "pGT", "j", "a", NULL},
   {"uBE9Ap", "pGT", "j", "a", NULL},
   {"uBE9Bp", "pGT", "j", "a", NULL},
   {"uBE9Cp", "pGT", "j", "a", NULL},
   {"uBE9Dp", "pGT", "j", "a", NULL},
   {"uBE9Ep", "pGT", "j", "a", NULL},
   {"uBE9Fp", "pGT", "j", "a", NULL},
   {"uBEA0p", "pGT", "j", "a", NULL},
   {"uBEA1p", "pGT", "j", "a", NULL},
   {"uBEA2p", "pGT", "j", "a", NULL},
   {"uBEA3p", "pGT", "j", "a", NULL},
   {"uBEA4p", "pGT", "j", "a", NULL},
   {"uBEA5p", "pGT", "j", "a", NULL},
   {"uBEA6p", "pGT", "j", "a", NULL},
   {"uBEA7p", "pGT", "j", "a", NULL},
   {"uBEA8p", "pGT", "j", "a", NULL},
   {"uBEA9p", "pGT", "j", "a", NULL},
   {"uBEAAp", "pGT", "j", "a", NULL},
   {"uBEABp", "pGT", "j", "a", NULL},
   {"uBEACp", "pGT", "j", "a", NULL},
   {"uBEADp", "pGT", "j", "a", NULL},
   {"uBEAEp", "pGT", "j", "a", NULL},
   {"uBEAFp", "pGT", "j", "a", NULL},
   {"uBEB0p", "pGT", "j", "a", NULL},
   {"uBEB1p", "pGT", "j", "a", NULL},
   {"uBEB2p", "pGT", "j", "a", NULL},
   {"uBEB3p", "pGT", "j", "a", NULL},
   {"uBEB4p", "pGT", "j", "@", NULL},
   {"uBEB5p", "pGT", "j", "@", NULL},
   {"uBEB6p", "pGT", "j", "@", NULL},
   {"uBEB7p", "pGT", "j", "@", NULL},
   {"uBEB8p", "pGT", "j", "@", NULL},
   {"uBEB9p", "pGT", "j", "@", NULL},
   {"uBEBAp", "pGT", "j", "@", NULL},
   {"uBEBBp", "pGT", "j", "@", NULL},
   {"uBEBCp", "pGT", "j", "@", NULL},
   {"uBEBDp", "pGT", "j", "@", NULL},
   {"uBEBEp", "pGT", "j", "@", NULL},
   {"uBEBFp", "pGT", "j", "@", NULL},
   {"uBEC0p", "pGT", "j", "@", NULL},
   {"uBEC1p", "pGT", "j", "@", NULL},
   {"uBEC2p", "pGT", "j", "@", NULL},
   {"uBEC3p", "pGT", "j", "@", NULL},
   {"uBEC4p", "pGT", "j", "@", NULL},
   {"uBEC5p", "pGT", "j", "@", NULL},
   {"uBEC6p", "pGT", "j", "@", NULL},
   {"uBEC7p", "pGT", "j", "@", NULL},
   {"uBEC8p", "pGT", "j", "@", NULL},
   {"uBEC9p", "pGT", "j", "@", NULL},
   {"uBECAp", "pGT", "j", "@", NULL},
   {"uBECBp", "pGT", "j", "@", NULL},
   {"uBECCp", "pGT", "j", "@", NULL},
   {"uBECDp", "pGT", "j", "@", NULL},
   {"uBECEp", "pGT", "j", "@", NULL},
   {"uBECFp", "pGT", "j", "@", NULL},
   {"uBED0p", "pGT", "^", NULL, NULL},
   {"uBED1p", "pGT", "^", "k", NULL},
   {"uBED2p", "pGT", "^", "kGT", NULL},
   {"uBED3p", "pGT", "^", "k", NULL},
   {"uBED4p", "pGT", "^", "n", NULL},
   {"uBED5p", "pGT", "^", "n", NULL},
   {"uBED6p", "pGT", "^", "n", NULL},
   {"uBED7p", "pGT", "^", "t", NULL},
   {"uBED8p", "pGT", "^", "l", NULL},
   {"uBED9p", "pGT", "^", "l", NULL},
   {"uBEDAp", "pGT", "^", "l", NULL},
   {"uBEDBp", "pGT", "^", "l", NULL},
   {"uBEDCp", "pGT", "^", "l", NULL},
   {"uBEDDp", "pGT", "^", "l", NULL},
   {"uBEDEp", "pGT", "^", "l", NULL},
   {"uBEDFp", "pGT", "^", "l", NULL},
   {"uBEE0p", "pGT", "^", "m", NULL},
   {"uBEE1p", "pGT", "^", "p", NULL},
   {"uBEE2p", "pGT", "^", "p", NULL},
   {"uBEE3p", "pGT", "^", "sh", NULL},
   {"uBEE4p", "pGT", "^", "s", NULL},
   {"uBEE5p", "pGT", "^", "N", NULL},
   {"uBEE6p", "pGT", "^", "tS", NULL},
   {"uBEE7p", "pGT", "^", "tSh", NULL},
   {"uBEE8p", "pGT", "^", "kh", NULL},
   {"uBEE9p", "pGT", "^", "th", NULL},
   {"uBEEAp", "pGT", "^", "ph", NULL},
   {"uBEEBp", "pGT", "^", "h", NULL},
   {"uBEECp", "pGT", "e", NULL, NULL},
   {"uBEEDp", "pGT", "e", "k", NULL},
   {"uBEEEp", "pGT", "e", "kGT", NULL},
   {"uBEEFp", "pGT", "e", "k", NULL},
   {"uBEF0p", "pGT", "e", "n", NULL},
   {"uBEF1p", "pGT", "e", "n", NULL},
   {"uBEF2p", "pGT", "e", "n", NULL},
   {"uBEF3p", "pGT", "e", "t", NULL},
   {"uBEF4p", "pGT", "e", "l", NULL},
   {"uBEF5p", "pGT", "e", "l", NULL},
   {"uBEF6p", "pGT", "e", "l", NULL},
   {"uBEF7p", "pGT", "e", "l", NULL},
   {"uBEF8p", "pGT", "e", "l", NULL},
   {"uBEF9p", "pGT", "e", "l", NULL},
   {"uBEFAp", "pGT", "e", "l", NULL},
   {"uBEFBp", "pGT", "e", "l", NULL},
   {"uBEFCp", "pGT", "e", "m", NULL},
   {"uBEFDp", "pGT", "e", "p", NULL},
   {"uBEFEp", "pGT", "e", "p", NULL},
   {"uBEFFp", "pGT", "e", "sh", NULL},
   {"uBF00p", "pGT", "e", "s", NULL},
   {"uBF01p", "pGT", "e", "N", NULL},
   {"uBF02p", "pGT", "e", "tS", NULL},
   {"uBF03p", "pGT", "e", "tSh", NULL},
   {"uBF04p", "pGT", "e", "kh", NULL},
   {"uBF05p", "pGT", "e", "th", NULL},
   {"uBF06p", "pGT", "e", "ph", NULL},
   {"uBF07p", "pGT", "e", "h", NULL},
   {"uBF08p", "pGT", "j", "^", NULL},
   {"uBF09p", "pGT", "j", "^", NULL},
   {"uBF0Ap", "pGT", "j", "^", NULL},
   {"uBF0Bp", "pGT", "j", "^", NULL},
   {"uBF0Cp", "pGT", "j", "^", NULL},
   {"uBF0Dp", "pGT", "j", "^", NULL},
   {"uBF0Ep", "pGT", "j", "^", NULL},
   {"uBF0Fp", "pGT", "j", "^", NULL},
   {"uBF10p", "pGT", "j", "^", NULL},
   {"uBF11p", "pGT", "j", "^", NULL},
   {"uBF12p", "pGT", "j", "^", NULL},
   {"uBF13p", "pGT", "j", "^", NULL},
   {"uBF14p", "pGT", "j", "^", NULL},
   {"uBF15p", "pGT", "j", "^", NULL},
   {"uBF16p", "pGT", "j", "^", NULL},
   {"uBF17p", "pGT", "j", "^", NULL},
   {"uBF18p", "pGT", "j", "^", NULL},
   {"uBF19p", "pGT", "j", "^", NULL},
   {"uBF1Ap", "pGT", "j", "^", NULL},
   {"uBF1Bp", "pGT", "j", "^", NULL},
   {"uBF1Cp", "pGT", "j", "^", NULL},
   {"uBF1Dp", "pGT", "j", "^", NULL},
   {"uBF1Ep", "pGT", "j", "^", NULL},
   {"uBF1Fp", "pGT", "j", "^", NULL},
   {"uBF20p", "pGT", "j", "^", NULL},
   {"uBF21p", "pGT", "j", "^", NULL},
   {"uBF22p", "pGT", "j", "^", NULL},
   {"uBF23p", "pGT", "j", "^", NULL},
   {"uBF24p", "pGT", "j", "e", NULL},
   {"uBF25p", "pGT", "j", "e", NULL},
   {"uBF26p", "pGT", "j", "e", NULL},
   {"uBF27p", "pGT", "j", "e", NULL},
   {"uBF28p", "pGT", "j", "e", NULL},
   {"uBF29p", "pGT", "j", "e", NULL},
   {"uBF2Ap", "pGT", "j", "e", NULL},
   {"uBF2Bp", "pGT", "j", "e", NULL},
   {"uBF2Cp", "pGT", "j", "e", NULL},
   {"uBF2Dp", "pGT", "j", "e", NULL},
   {"uBF2Ep", "pGT", "j", "e", NULL},
   {"uBF2Fp", "pGT", "j", "e", NULL},
   {"uBF30p", "pGT", "j", "e", NULL},
   {"uBF31p", "pGT", "j", "e", NULL},
   {"uBF32p", "pGT", "j", "e", NULL},
   {"uBF33p", "pGT", "j", "e", NULL},
   {"uBF34p", "pGT", "j", "e", NULL},
   {"uBF35p", "pGT", "j", "e", NULL},
   {"uBF36p", "pGT", "j", "e", NULL},
   {"uBF37p", "pGT", "j", "e", NULL},
   {"uBF38p", "pGT", "j", "e", NULL},
   {"uBF39p", "pGT", "j", "e", NULL},
   {"uBF3Ap", "pGT", "j", "e", NULL},
   {"uBF3Bp", "pGT", "j", "e", NULL},
   {"uBF3Cp", "pGT", "j", "e", NULL},
   {"uBF3Dp", "pGT", "j", "e", NULL},
   {"uBF3Ep", "pGT", "j", "e", NULL},
   {"uBF3Fp", "pGT", "j", "e", NULL},
   {"uBF40p", "pGT", "o", NULL, NULL},
   {"uBF41p", "pGT", "o", "k", NULL},
   {"uBF42p", "pGT", "o", "kGT", NULL},
   {"uBF43p", "pGT", "o", "k", NULL},
   {"uBF44p", "pGT", "o", "n", NULL},
   {"uBF45p", "pGT", "o", "n", NULL},
   {"uBF46p", "pGT", "o", "n", NULL},
   {"uBF47p", "pGT", "o", "t", NULL},
   {"uBF48p", "pGT", "o", "l", NULL},
   {"uBF49p", "pGT", "o", "l", NULL},
   {"uBF4Ap", "pGT", "o", "l", NULL},
   {"uBF4Bp", "pGT", "o", "l", NULL},
   {"uBF4Cp", "pGT", "o", "l", NULL},
   {"uBF4Dp", "pGT", "o", "l", NULL},
   {"uBF4Ep", "pGT", "o", "l", NULL},
   {"uBF4Fp", "pGT", "o", "l", NULL},
   {"uBF50p", "pGT", "o", "m", NULL},
   {"uBF51p", "pGT", "o", "p", NULL},
   {"uBF52p", "pGT", "o", "p", NULL},
   {"uBF53p", "pGT", "o", "sh", NULL},
   {"uBF54p", "pGT", "o", "s", NULL},
   {"uBF55p", "pGT", "o", "N", NULL},
   {"uBF56p", "pGT", "o", "tS", NULL},
   {"uBF57p", "pGT", "o", "tSh", NULL},
   {"uBF58p", "pGT", "o", "kh", NULL},
   {"uBF59p", "pGT", "o", "th", NULL},
   {"uBF5Ap", "pGT", "o", "ph", NULL},
   {"uBF5Bp", "pGT", "o", "h", NULL},
   {"uBF5Cp", "pGT", "w", "a", NULL},
   {"uBF5Dp", "pGT", "w", "a", NULL},
   {"uBF5Ep", "pGT", "w", "a", NULL},
   {"uBF5Fp", "pGT", "w", "a", NULL},
   {"uBF60p", "pGT", "w", "a", NULL},
   {"uBF61p", "pGT", "w", "a", NULL},
   {"uBF62p", "pGT", "w", "a", NULL},
   {"uBF63p", "pGT", "w", "a", NULL},
   {"uBF64p", "pGT", "w", "a", NULL},
   {"uBF65p", "pGT", "w", "a", NULL},
   {"uBF66p", "pGT", "w", "a", NULL},
   {"uBF67p", "pGT", "w", "a", NULL},
   {"uBF68p", "pGT", "w", "a", NULL},
   {"uBF69p", "pGT", "w", "a", NULL},
   {"uBF6Ap", "pGT", "w", "a", NULL},
   {"uBF6Bp", "pGT", "w", "a", NULL},
   {"uBF6Cp", "pGT", "w", "a", NULL},
   {"uBF6Dp", "pGT", "w", "a", NULL},
   {"uBF6Ep", "pGT", "w", "a", NULL},
   {"uBF6Fp", "pGT", "w", "a", NULL},
   {"uBF70p", "pGT", "w", "a", NULL},
   {"uBF71p", "pGT", "w", "a", NULL},
   {"uBF72p", "pGT", "w", "a", NULL},
   {"uBF73p", "pGT", "w", "a", NULL},
   {"uBF74p", "pGT", "w", "a", NULL},
   {"uBF75p", "pGT", "w", "a", NULL},
   {"uBF76p", "pGT", "w", "a", NULL},
   {"uBF77p", "pGT", "w", "a", NULL},
   {"uBF78p", "pGT", "w", "@", NULL},
   {"uBF79p", "pGT", "w", "@", NULL},
   {"uBF7Ap", "pGT", "w", "@", NULL},
   {"uBF7Bp", "pGT", "w", "@", NULL},
   {"uBF7Cp", "pGT", "w", "@", NULL},
   {"uBF7Dp", "pGT", "w", "@", NULL},
   {"uBF7Ep", "pGT", "w", "@", NULL},
   {"uBF7Fp", "pGT", "w", "@", NULL},
   {"uBF80p", "pGT", "w", "@", NULL},
   {"uBF81p", "pGT", "w", "@", NULL},
   {"uBF82p", "pGT", "w", "@", NULL},
   {"uBF83p", "pGT", "w", "@", NULL},
   {"uBF84p", "pGT", "w", "@", NULL},
   {"uBF85p", "pGT", "w", "@", NULL},
   {"uBF86p", "pGT", "w", "@", NULL},
   {"uBF87p", "pGT", "w", "@", NULL},
   {"uBF88p", "pGT", "w", "@", NULL},
   {"uBF89p", "pGT", "w", "@", NULL},
   {"uBF8Ap", "pGT", "w", "@", NULL},
   {"uBF8Bp", "pGT", "w", "@", NULL},
   {"uBF8Cp", "pGT", "w", "@", NULL},
   {"uBF8Dp", "pGT", "w", "@", NULL},
   {"uBF8Ep", "pGT", "w", "@", NULL},
   {"uBF8Fp", "pGT", "w", "@", NULL},
   {"uBF90p", "pGT", "w", "@", NULL},
   {"uBF91p", "pGT", "w", "@", NULL},
   {"uBF92p", "pGT", "w", "@", NULL},
   {"uBF93p", "pGT", "w", "@", NULL},
   {"uBF94p", "pGT", "w", "e", NULL},
   {"uBF95p", "pGT", "w", "e", NULL},
   {"uBF96p", "pGT", "w", "e", NULL},
   {"uBF97p", "pGT", "w", "e", NULL},
   {"uBF98p", "pGT", "w", "e", NULL},
   {"uBF99p", "pGT", "w", "e", NULL},
   {"uBF9Ap", "pGT", "w", "e", NULL},
   {"uBF9Bp", "pGT", "w", "e", NULL},
   {"uBF9Cp", "pGT", "w", "e", NULL},
   {"uBF9Dp", "pGT", "w", "e", NULL},
   {"uBF9Ep", "pGT", "w", "e", NULL},
   {"uBF9Fp", "pGT", "w", "e", NULL},
   {"uBFA0p", "pGT", "w", "e", NULL},
   {"uBFA1p", "pGT", "w", "e", NULL},
   {"uBFA2p", "pGT", "w", "e", NULL},
   {"uBFA3p", "pGT", "w", "e", NULL},
   {"uBFA4p", "pGT", "w", "e", NULL},
   {"uBFA5p", "pGT", "w", "e", NULL},
   {"uBFA6p", "pGT", "w", "e", NULL},
   {"uBFA7p", "pGT", "w", "e", NULL},
   {"uBFA8p", "pGT", "w", "e", NULL},
   {"uBFA9p", "pGT", "w", "e", NULL},
   {"uBFAAp", "pGT", "w", "e", NULL},
   {"uBFABp", "pGT", "w", "e", NULL},
   {"uBFACp", "pGT", "w", "e", NULL},
   {"uBFADp", "pGT", "w", "e", NULL},
   {"uBFAEp", "pGT", "w", "e", NULL},
   {"uBFAFp", "pGT", "w", "e", NULL},
   {"uBFB0p", "pGT", "j", "o", NULL},
   {"uBFB1p", "pGT", "j", "o", NULL},
   {"uBFB2p", "pGT", "j", "o", NULL},
   {"uBFB3p", "pGT", "j", "o", NULL},
   {"uBFB4p", "pGT", "j", "o", NULL},
   {"uBFB5p", "pGT", "j", "o", NULL},
   {"uBFB6p", "pGT", "j", "o", NULL},
   {"uBFB7p", "pGT", "j", "o", NULL},
   {"uBFB8p", "pGT", "j", "o", NULL},
   {"uBFB9p", "pGT", "j", "o", NULL},
   {"uBFBAp", "pGT", "j", "o", NULL},
   {"uBFBBp", "pGT", "j", "o", NULL},
   {"uBFBCp", "pGT", "j", "o", NULL},
   {"uBFBDp", "pGT", "j", "o", NULL},
   {"uBFBEp", "pGT", "j", "o", NULL},
   {"uBFBFp", "pGT", "j", "o", NULL},
   {"uBFC0p", "pGT", "j", "o", NULL},
   {"uBFC1p", "pGT", "j", "o", NULL},
   {"uBFC2p", "pGT", "j", "o", NULL},
   {"uBFC3p", "pGT", "j", "o", NULL},
   {"uBFC4p", "pGT", "j", "o", NULL},
   {"uBFC5p", "pGT", "j", "o", NULL},
   {"uBFC6p", "pGT", "j", "o", NULL},
   {"uBFC7p", "pGT", "j", "o", NULL},
   {"uBFC8p", "pGT", "j", "o", NULL},
   {"uBFC9p", "pGT", "j", "o", NULL},
   {"uBFCAp", "pGT", "j", "o", NULL},
   {"uBFCBp", "pGT", "j", "o", NULL},
   {"uBFCCp", "pGT", "u", NULL, NULL},
   {"uBFCDp", "pGT", "u", "k", NULL},
   {"uBFCEp", "pGT", "u", "kGT", NULL},
   {"uBFCFp", "pGT", "u", "k", NULL},
   {"uBFD0p", "pGT", "u", "n", NULL},
   {"uBFD1p", "pGT", "u", "n", NULL},
   {"uBFD2p", "pGT", "u", "n", NULL},
   {"uBFD3p", "pGT", "u", "t", NULL},
   {"uBFD4p", "pGT", "u", "l", NULL},
   {"uBFD5p", "pGT", "u", "l", NULL},
   {"uBFD6p", "pGT", "u", "l", NULL},
   {"uBFD7p", "pGT", "u", "l", NULL},
   {"uBFD8p", "pGT", "u", "l", NULL},
   {"uBFD9p", "pGT", "u", "l", NULL},
   {"uBFDAp", "pGT", "u", "l", NULL},
   {"uBFDBp", "pGT", "u", "l", NULL},
   {"uBFDCp", "pGT", "u", "m", NULL},
   {"uBFDDp", "pGT", "u", "p", NULL},
   {"uBFDEp", "pGT", "u", "p", NULL},
   {"uBFDFp", "pGT", "u", "sh", NULL},
   {"uBFE0p", "pGT", "u", "s", NULL},
   {"uBFE1p", "pGT", "u", "N", NULL},
   {"uBFE2p", "pGT", "u", "tS", NULL},
   {"uBFE3p", "pGT", "u", "tSh", NULL},
   {"uBFE4p", "pGT", "u", "kh", NULL},
   {"uBFE5p", "pGT", "u", "th", NULL},
   {"uBFE6p", "pGT", "u", "ph", NULL},
   {"uBFE7p", "pGT", "u", "h", NULL},
   {"uBFE8p", "pGT", "w", "^", NULL},
   {"uBFE9p", "pGT", "w", "^", NULL},
   {"uBFEAp", "pGT", "w", "^", NULL},
   {"uBFEBp", "pGT", "w", "^", NULL},
   {"uBFECp", "pGT", "w", "^", NULL},
   {"uBFEDp", "pGT", "w", "^", NULL},
   {"uBFEEp", "pGT", "w", "^", NULL},
   {"uBFEFp", "pGT", "w", "^", NULL},
   {"uBFF0p", "pGT", "w", "^", NULL},
   {"uBFF1p", "pGT", "w", "^", NULL},
   {"uBFF2p", "pGT", "w", "^", NULL},
   {"uBFF3p", "pGT", "w", "^", NULL},
   {"uBFF4p", "pGT", "w", "^", NULL},
   {"uBFF5p", "pGT", "w", "^", NULL},
   {"uBFF6p", "pGT", "w", "^", NULL},
   {"uBFF7p", "pGT", "w", "^", NULL},
   {"uBFF8p", "pGT", "w", "^", NULL},
   {"uBFF9p", "pGT", "w", "^", NULL},
   {"uBFFAp", "pGT", "w", "^", NULL},
   {"uBFFBp", "pGT", "w", "^", NULL},
   {"uBFFCp", "pGT", "w", "^", NULL},
   {"uBFFDp", "pGT", "w", "^", NULL},
   {"uBFFEp", "pGT", "w", "^", NULL},
   {"uBFFFp", "pGT", "w", "^", NULL},
   {"uC000p", "pGT", "w", "^", NULL},
   {"uC001p", "pGT", "w", "^", NULL},
   {"uC002p", "pGT", "w", "^", NULL},
   {"uC003p", "pGT", "w", "^", NULL},
   {"uC004p", "pGT", "w", "e", NULL},
   {"uC005p", "pGT", "w", "e", NULL},
   {"uC006p", "pGT", "w", "e", NULL},
   {"uC007p", "pGT", "w", "e", NULL},
   {"uC008p", "pGT", "w", "e", NULL},
   {"uC009p", "pGT", "w", "e", NULL},
   {"uC00Ap", "pGT", "w", "e", NULL},
   {"uC00Bp", "pGT", "w", "e", NULL},
   {"uC00Cp", "pGT", "w", "e", NULL},
   {"uC00Dp", "pGT", "w", "e", NULL},
   {"uC00Ep", "pGT", "w", "e", NULL},
   {"uC00Fp", "pGT", "w", "e", NULL},
   {"uC010p", "pGT", "w", "e", NULL},
   {"uC011p", "pGT", "w", "e", NULL},
   {"uC012p", "pGT", "w", "e", NULL},
   {"uC013p", "pGT", "w", "e", NULL},
   {"uC014p", "pGT", "w", "e", NULL},
   {"uC015p", "pGT", "w", "e", NULL},
   {"uC016p", "pGT", "w", "e", NULL},
   {"uC017p", "pGT", "w", "e", NULL},
   {"uC018p", "pGT", "w", "e", NULL},
   {"uC019p", "pGT", "w", "e", NULL},
   {"uC01Ap", "pGT", "w", "e", NULL},
   {"uC01Bp", "pGT", "w", "e", NULL},
   {"uC01Cp", "pGT", "w", "e", NULL},
   {"uC01Dp", "pGT", "w", "e", NULL},
   {"uC01Ep", "pGT", "w", "e", NULL},
   {"uC01Fp", "pGT", "w", "e", NULL},
   {"uC020p", "pGT", "7", NULL, NULL},
   {"uC021p", "pGT", "7", "k", NULL},
   {"uC022p", "pGT", "7", "kGT", NULL},
   {"uC023p", "pGT", "7", "k", NULL},
   {"uC024p", "pGT", "7", "n", NULL},
   {"uC025p", "pGT", "7", "n", NULL},
   {"uC026p", "pGT", "7", "n", NULL},
   {"uC027p", "pGT", "7", "t", NULL},
   {"uC028p", "pGT", "7", "l", NULL},
   {"uC029p", "pGT", "7", "l", NULL},
   {"uC02Ap", "pGT", "7", "l", NULL},
   {"uC02Bp", "pGT", "7", "l", NULL},
   {"uC02Cp", "pGT", "7", "l", NULL},
   {"uC02Dp", "pGT", "7", "l", NULL},
   {"uC02Ep", "pGT", "7", "l", NULL},
   {"uC02Fp", "pGT", "7", "l", NULL},
   {"uC030p", "pGT", "7", "m", NULL},
   {"uC031p", "pGT", "7", "p", NULL},
   {"uC032p", "pGT", "7", "p", NULL},
   {"uC033p", "pGT", "7", "sh", NULL},
   {"uC034p", "pGT", "7", "s", NULL},
   {"uC035p", "pGT", "7", "N", NULL},
   {"uC036p", "pGT", "7", "tS", NULL},
   {"uC037p", "pGT", "7", "tSh", NULL},
   {"uC038p", "pGT", "7", "kh", NULL},
   {"uC039p", "pGT", "7", "th", NULL},
   {"uC03Ap", "pGT", "7", "ph", NULL},
   {"uC03Bp", "pGT", "7", "h", NULL},
   {"uC03Cp", "pGT", "j", "u", NULL},
   {"uC03Dp", "pGT", "j", "u", NULL},
   {"uC03Ep", "pGT", "j", "u", NULL},
   {"uC03Fp", "pGT", "j", "u", NULL},
   {"uC040p", "pGT", "j", "u", NULL},
   {"uC041p", "pGT", "j", "u", NULL},
   {"uC042p", "pGT", "j", "u", NULL},
   {"uC043p", "pGT", "j", "u", NULL},
   {"uC044p", "pGT", "j", "u", NULL},
   {"uC045p", "pGT", "j", "u", NULL},
   {"uC046p", "pGT", "j", "u", NULL},
   {"uC047p", "pGT", "j", "u", NULL},
   {"uC048p", "pGT", "j", "u", NULL},
   {"uC049p", "pGT", "j", "u", NULL},
   {"uC04Ap", "pGT", "j", "u", NULL},
   {"uC04Bp", "pGT", "j", "u", NULL},
   {"uC04Cp", "pGT", "j", "u", NULL},
   {"uC04Dp", "pGT", "j", "u", NULL},
   {"uC04Ep", "pGT", "j", "u", NULL},
   {"uC04Fp", "pGT", "j", "u", NULL},
   {"uC050p", "pGT", "j", "u", NULL},
   {"uC051p", "pGT", "j", "u", NULL},
   {"uC052p", "pGT", "j", "u", NULL},
   {"uC053p", "pGT", "j", "u", NULL},
   {"uC054p", "pGT", "j", "u", NULL},
   {"uC055p", "pGT", "j", "u", NULL},
   {"uC056p", "pGT", "j", "u", NULL},
   {"uC057p", "pGT", "j", "u", NULL},
   {"uC058p", "pGT", "4", NULL, NULL},
   {"uC059p", "pGT", "4", "k", NULL},
   {"uC05Ap", "pGT", "4", "kGT", NULL},
   {"uC05Bp", "pGT", "4", "k", NULL},
   {"uC05Cp", "pGT", "4", "n", NULL},
   {"uC05Dp", "pGT", "4", "n", NULL},
   {"uC05Ep", "pGT", "4", "n", NULL},
   {"uC05Fp", "pGT", "4", "t", NULL},
   {"uC060p", "pGT", "4", "l", NULL},
   {"uC061p", "pGT", "4", "l", NULL},
   {"uC062p", "pGT", "4", "l", NULL},
   {"uC063p", "pGT", "4", "l", NULL},
   {"uC064p", "pGT", "4", "l", NULL},
   {"uC065p", "pGT", "4", "l", NULL},
   {"uC066p", "pGT", "4", "l", NULL},
   {"uC067p", "pGT", "4", "l", NULL},
   {"uC068p", "pGT", "4", "m", NULL},
   {"uC069p", "pGT", "4", "p", NULL},
   {"uC06Ap", "pGT", "4", "p", NULL},
   {"uC06Bp", "pGT", "4", "sh", NULL},
   {"uC06Cp", "pGT", "4", "s", NULL},
   {"uC06Dp", "pGT", "4", "N", NULL},
   {"uC06Ep", "pGT", "4", "tS", NULL},
   {"uC06Fp", "pGT", "4", "tSh", NULL},
   {"uC070p", "pGT", "4", "kh", NULL},
   {"uC071p", "pGT", "4", "th", NULL},
   {"uC072p", "pGT", "4", "ph", NULL},
   {"uC073p", "pGT", "4", "h", NULL},
   {"uC074p", "pGT", "4", "j", NULL},
   {"uC075p", "pGT", "4", "j", NULL},
   {"uC076p", "pGT", "4", "j", NULL},
   {"uC077p", "pGT", "4", "j", NULL},
   {"uC078p", "pGT", "4", "j", NULL},
   {"uC079p", "pGT", "4", "j", NULL},
   {"uC07Ap", "pGT", "4", "j", NULL},
   {"uC07Bp", "pGT", "4", "j", NULL},
   {"uC07Cp", "pGT", "4", "j", NULL},
   {"uC07Dp", "pGT", "4", "j", NULL},
   {"uC07Ep", "pGT", "4", "j", NULL},
   {"uC07Fp", "pGT", "4", "j", NULL},
   {"uC080p", "pGT", "4", "j", NULL},
   {"uC081p", "pGT", "4", "j", NULL},
   {"uC082p", "pGT", "4", "j", NULL},
   {"uC083p", "pGT", "4", "j", NULL},
   {"uC084p", "pGT", "4", "j", NULL},
   {"uC085p", "pGT", "4", "j", NULL},
   {"uC086p", "pGT", "4", "j", NULL},
   {"uC087p", "pGT", "4", "j", NULL},
   {"uC088p", "pGT", "4", "j", NULL},
   {"uC089p", "pGT", "4", "j", NULL},
   {"uC08Ap", "pGT", "4", "j", NULL},
   {"uC08Bp", "pGT", "4", "j", NULL},
   {"uC08Cp", "pGT", "4", "j", NULL},
   {"uC08Dp", "pGT", "4", "j", NULL},
   {"uC08Ep", "pGT", "4", "j", NULL},
   {"uC08Fp", "pGT", "4", "j", NULL},
   {"uC090p", "pGT", "i", NULL, NULL},
   {"uC091p", "pGT", "i", "k", NULL},
   {"uC092p", "pGT", "i", "kGT", NULL},
   {"uC093p", "pGT", "i", "k", NULL},
   {"uC094p", "pGT", "i", "n", NULL},
   {"uC095p", "pGT", "i", "n", NULL},
   {"uC096p", "pGT", "i", "n", NULL},
   {"uC097p", "pGT", "i", "t", NULL},
   {"uC098p", "pGT", "i", "l", NULL},
   {"uC099p", "pGT", "i", "l", NULL},
   {"uC09Ap", "pGT", "i", "l", NULL},
   {"uC09Bp", "pGT", "i", "l", NULL},
   {"uC09Cp", "pGT", "i", "l", NULL},
   {"uC09Dp", "pGT", "i", "l", NULL},
   {"uC09Ep", "pGT", "i", "l", NULL},
   {"uC09Fp", "pGT", "i", "l", NULL},
   {"uC0A0p", "pGT", "i", "m", NULL},
   {"uC0A1p", "pGT", "i", "p", NULL},
   {"uC0A2p", "pGT", "i", "p", NULL},
   {"uC0A3p", "pGT", "i", "sh", NULL},
   {"uC0A4p", "pGT", "i", "s", NULL},
   {"uC0A5p", "pGT", "i", "N", NULL},
   {"uC0A6p", "pGT", "i", "tS", NULL},
   {"uC0A7p", "pGT", "i", "tSh", NULL},
   {"uC0A8p", "pGT", "i", "kh", NULL},
   {"uC0A9p", "pGT", "i", "th", NULL},
   {"uC0AAp", "pGT", "i", "ph", NULL},
   {"uC0ABp", "pGT", "i", "h", NULL},
   {"uC0ACp", "sh", "a", NULL, NULL},
   {"uC0ADp", "sh", "a", "k", NULL},
   {"uC0AEp", "sh", "a", "kGT", NULL},
   {"uC0AFp", "sh", "a", "k", NULL},
   {"uC0B0p", "sh", "a", "n", NULL},
   {"uC0B1p", "sh", "a", "n", NULL},
   {"uC0B2p", "sh", "a", "n", NULL},
   {"uC0B3p", "sh", "a", "t", NULL},
   {"uC0B4p", "sh", "a", "l", NULL},
   {"uC0B5p", "sh", "a", "l", NULL},
   {"uC0B6p", "sh", "a", "l", NULL},
   {"uC0B7p", "sh", "a", "l", NULL},
   {"uC0B8p", "sh", "a", "l", NULL},
   {"uC0B9p", "sh", "a", "l", NULL},
   {"uC0BAp", "sh", "a", "l", NULL},
   {"uC0BBp", "sh", "a", "l", NULL},
   {"uC0BCp", "sh", "a", "m", NULL},
   {"uC0BDp", "sh", "a", "p", NULL},
   {"uC0BEp", "sh", "a", "p", NULL},
   {"uC0BFp", "sh", "a", "sh", NULL},
   {"uC0C0p", "sh", "a", "s", NULL},
   {"uC0C1p", "sh", "a", "N", NULL},
   {"uC0C2p", "sh", "a", "tS", NULL},
   {"uC0C3p", "sh", "a", "tSh", NULL},
   {"uC0C4p", "sh", "a", "kh", NULL},
   {"uC0C5p", "sh", "a", "th", NULL},
   {"uC0C6p", "sh", "a", "ph", NULL},
   {"uC0C7p", "sh", "a", "h", NULL},
   {"uC0C8p", "sh", "@", NULL, NULL},
   {"uC0C9p", "sh", "@", "k", NULL},
   {"uC0CAp", "sh", "@", "kGT", NULL},
   {"uC0CBp", "sh", "@", "k", NULL},
   {"uC0CCp", "sh", "@", "n", NULL},
   {"uC0CDp", "sh", "@", "n", NULL},
   {"uC0CEp", "sh", "@", "n", NULL},
   {"uC0CFp", "sh", "@", "t", NULL},
   {"uC0D0p", "sh", "@", "l", NULL},
   {"uC0D1p", "sh", "@", "l", NULL},
   {"uC0D2p", "sh", "@", "l", NULL},
   {"uC0D3p", "sh", "@", "l", NULL},
   {"uC0D4p", "sh", "@", "l", NULL},
   {"uC0D5p", "sh", "@", "l", NULL},
   {"uC0D6p", "sh", "@", "l", NULL},
   {"uC0D7p", "sh", "@", "l", NULL},
   {"uC0D8p", "sh", "@", "m", NULL},
   {"uC0D9p", "sh", "@", "p", NULL},
   {"uC0DAp", "sh", "@", "p", NULL},
   {"uC0DBp", "sh", "@", "sh", NULL},
   {"uC0DCp", "sh", "@", "s", NULL},
   {"uC0DDp", "sh", "@", "N", NULL},
   {"uC0DEp", "sh", "@", "tS", NULL},
   {"uC0DFp", "sh", "@", "tSh", NULL},
   {"uC0E0p", "sh", "@", "kh", NULL},
   {"uC0E1p", "sh", "@", "th", NULL},
   {"uC0E2p", "sh", "@", "ph", NULL},
   {"uC0E3p", "sh", "@", "h", NULL},
   {"uC0E4p", "sh", "j", "a", NULL},
   {"uC0E5p", "sh", "j", "a", NULL},
   {"uC0E6p", "sh", "j", "a", NULL},
   {"uC0E7p", "sh", "j", "a", NULL},
   {"uC0E8p", "sh", "j", "a", NULL},
   {"uC0E9p", "sh", "j", "a", NULL},
   {"uC0EAp", "sh", "j", "a", NULL},
   {"uC0EBp", "sh", "j", "a", NULL},
   {"uC0ECp", "sh", "j", "a", NULL},
   {"uC0EDp", "sh", "j", "a", NULL},
   {"uC0EEp", "sh", "j", "a", NULL},
   {"uC0EFp", "sh", "j", "a", NULL},
   {"uC0F0p", "sh", "j", "a", NULL},
   {"uC0F1p", "sh", "j", "a", NULL},
   {"uC0F2p", "sh", "j", "a", NULL},
   {"uC0F3p", "sh", "j", "a", NULL},
   {"uC0F4p", "sh", "j", "a", NULL},
   {"uC0F5p", "sh", "j", "a", NULL},
   {"uC0F6p", "sh", "j", "a", NULL},
   {"uC0F7p", "sh", "j", "a", NULL},
   {"uC0F8p", "sh", "j", "a", NULL},
   {"uC0F9p", "sh", "j", "a", NULL},
   {"uC0FAp", "sh", "j", "a", NULL},
   {"uC0FBp", "sh", "j", "a", NULL},
   {"uC0FCp", "sh", "j", "a", NULL},
   {"uC0FDp", "sh", "j", "a", NULL},
   {"uC0FEp", "sh", "j", "a", NULL},
   {"uC0FFp", "sh", "j", "a", NULL},
   {"uC100p", "sh", "j", "@", NULL},
   {"uC101p", "sh", "j", "@", NULL},
   {"uC102p", "sh", "j", "@", NULL},
   {"uC103p", "sh", "j", "@", NULL},
   {"uC104p", "sh", "j", "@", NULL},
   {"uC105p", "sh", "j", "@", NULL},
   {"uC106p", "sh", "j", "@", NULL},
   {"uC107p", "sh", "j", "@", NULL},
   {"uC108p", "sh", "j", "@", NULL},
   {"uC109p", "sh", "j", "@", NULL},
   {"uC10Ap", "sh", "j", "@", NULL},
   {"uC10Bp", "sh", "j", "@", NULL},
   {"uC10Cp", "sh", "j", "@", NULL},
   {"uC10Dp", "sh", "j", "@", NULL},
   {"uC10Ep", "sh", "j", "@", NULL},
   {"uC10Fp", "sh", "j", "@", NULL},
   {"uC110p", "sh", "j", "@", NULL},
   {"uC111p", "sh", "j", "@", NULL},
   {"uC112p", "sh", "j", "@", NULL},
   {"uC113p", "sh", "j", "@", NULL},
   {"uC114p", "sh", "j", "@", NULL},
   {"uC115p", "sh", "j", "@", NULL},
   {"uC116p", "sh", "j", "@", NULL},
   {"uC117p", "sh", "j", "@", NULL},
   {"uC118p", "sh", "j", "@", NULL},
   {"uC119p", "sh", "j", "@", NULL},
   {"uC11Ap", "sh", "j", "@", NULL},
   {"uC11Bp", "sh", "j", "@", NULL},
   {"uC11Cp", "sh", "^", NULL, NULL},
   {"uC11Dp", "sh", "^", "k", NULL},
   {"uC11Ep", "sh", "^", "kh", NULL},
   {"uC11Fp", "sh", "^", "k", NULL},
   {"uC120p", "sh", "^", "n", NULL},
   {"uC121p", "sh", "^", "n", NULL},
   {"uC122p", "sh", "^", "n", NULL},
   {"uC123p", "sh", "^", "t", NULL},
   {"uC124p", "sh", "^", "l", NULL},
   {"uC125p", "sh", "^", "l", NULL},
   {"uC126p", "sh", "^", "l", NULL},
   {"uC127p", "sh", "^", "l", NULL},
   {"uC128p", "sh", "^", "l", NULL},
   {"uC129p", "sh", "^", "l", NULL},
   {"uC12Ap", "sh", "^", "l", NULL},
   {"uC12Bp", "sh", "^", "l", NULL},
   {"uC12Cp", "sh", "^", "m", NULL},
   {"uC12Dp", "sh", "^", "p", NULL},
   {"uC12Ep", "sh", "^", "p", NULL},
   {"uC12Fp", "sh", "^", "sh", NULL},
   {"uC130p", "sh", "^", "s", NULL},
   {"uC131p", "sh", "^", "N", NULL},
   {"uC132p", "sh", "^", "tS", NULL},
   {"uC133p", "sh", "^", "tSh", NULL},
   {"uC134p", "sh", "^", "kh", NULL},
   {"uC135p", "sh", "^", "th", NULL},
   {"uC136p", "sh", "^", "ph", NULL},
   {"uC137p", "sh", "^", "h", NULL},
   {"uC138p", "sh", "e", NULL, NULL},
   {"uC139p", "sh", "e", "k", NULL},
   {"uC13Ap", "sh", "e", "kGT", NULL},
   {"uC13Bp", "sh", "e", "k", NULL},
   {"uC13Cp", "sh", "e", "n", NULL},
   {"uC13Dp", "sh", "e", "n", NULL},
   {"uC13Ep", "sh", "e", "n", NULL},
   {"uC13Fp", "sh", "e", "t", NULL},
   {"uC140p", "sh", "e", "l", NULL},
   {"uC141p", "sh", "e", "l", NULL},
   {"uC142p", "sh", "e", "l", NULL},
   {"uC143p", "sh", "e", "l", NULL},
   {"uC144p", "sh", "e", "l", NULL},
   {"uC145p", "sh", "e", "l", NULL},
   {"uC146p", "sh", "e", "l", NULL},
   {"uC147p", "sh", "e", "l", NULL},
   {"uC148p", "sh", "e", "m", NULL},
   {"uC149p", "sh", "e", "p", NULL},
   {"uC14Ap", "sh", "e", "p", NULL},
   {"uC14Bp", "sh", "e", "sh", NULL},
   {"uC14Cp", "sh", "e", "s", NULL},
   {"uC14Dp", "sh", "e", "N", NULL},
   {"uC14Ep", "sh", "e", "tS", NULL},
   {"uC14Fp", "sh", "e", "tSh", NULL},
   {"uC150p", "sh", "e", "kh", NULL},
   {"uC151p", "sh", "e", "th", NULL},
   {"uC152p", "sh", "e", "ph", NULL},
   {"uC153p", "sh", "e", "h", NULL},
   {"uC154p", "sh", "j", "^", NULL},
   {"uC155p", "sh", "j", "^", NULL},
   {"uC156p", "sh", "j", "^", NULL},
   {"uC157p", "sh", "j", "^", NULL},
   {"uC158p", "sh", "j", "^", NULL},
   {"uC159p", "sh", "j", "^", NULL},
   {"uC15Ap", "sh", "j", "^", NULL},
   {"uC15Bp", "sh", "j", "^", NULL},
   {"uC15Cp", "sh", "j", "^", NULL},
   {"uC15Dp", "sh", "j", "^", NULL},
   {"uC15Ep", "sh", "j", "^", NULL},
   {"uC15Fp", "sh", "j", "^", NULL},
   {"uC160p", "sh", "j", "^", NULL},
   {"uC161p", "sh", "j", "^", NULL},
   {"uC162p", "sh", "j", "^", NULL},
   {"uC163p", "sh", "j", "^", NULL},
   {"uC164p", "sh", "j", "^", NULL},
   {"uC165p", "sh", "j", "^", NULL},
   {"uC166p", "sh", "j", "^", NULL},
   {"uC167p", "sh", "j", "^", NULL},
   {"uC168p", "sh", "j", "^", NULL},
   {"uC169p", "sh", "j", "^", NULL},
   {"uC16Ap", "sh", "j", "^", NULL},
   {"uC16Bp", "sh", "j", "^", NULL},
   {"uC16Cp", "sh", "j", "^", NULL},
   {"uC16Dp", "sh", "j", "^", NULL},
   {"uC16Ep", "sh", "j", "^", NULL},
   {"uC16Fp", "sh", "j", "^", NULL},
   {"uC170p", "sh", "j", "e", NULL},
   {"uC171p", "sh", "j", "e", NULL},
   {"uC172p", "sh", "j", "e", NULL},
   {"uC173p", "sh", "j", "e", NULL},
   {"uC174p", "sh", "j", "e", NULL},
   {"uC175p", "sh", "j", "e", NULL},
   {"uC176p", "sh", "j", "e", NULL},
   {"uC177p", "sh", "j", "e", NULL},
   {"uC178p", "sh", "j", "e", NULL},
   {"uC179p", "sh", "j", "e", NULL},
   {"uC17Ap", "sh", "j", "e", NULL},
   {"uC17Bp", "sh", "j", "e", NULL},
   {"uC17Cp", "sh", "j", "e", NULL},
   {"uC17Dp", "sh", "j", "e", NULL},
   {"uC17Ep", "sh", "j", "e", NULL},
   {"uC17Fp", "sh", "j", "e", NULL},
   {"uC180p", "sh", "j", "e", NULL},
   {"uC181p", "sh", "j", "e", NULL},
   {"uC182p", "sh", "j", "e", NULL},
   {"uC183p", "sh", "j", "e", NULL},
   {"uC184p", "sh", "j", "e", NULL},
   {"uC185p", "sh", "j", "e", NULL},
   {"uC186p", "sh", "j", "e", NULL},
   {"uC187p", "sh", "j", "e", NULL},
   {"uC188p", "sh", "j", "e", NULL},
   {"uC189p", "sh", "j", "e", NULL},
   {"uC18Ap", "sh", "j", "e", NULL},
   {"uC18Bp", "sh", "j", "e", NULL},
   {"uC18Cp", "sh", "o", NULL, NULL},
   {"uC18Dp", "sh", "o", "k", NULL},
   {"uC18Ep", "sh", "o", "kGT", NULL},
   {"uC18Fp", "sh", "o", "k", NULL},
   {"uC190p", "sh", "o", "n", NULL},
   {"uC191p", "sh", "o", "n", NULL},
   {"uC192p", "sh", "o", "n", NULL},
   {"uC193p", "sh", "o", "t", NULL},
   {"uC194p", "sh", "o", "l", NULL},
   {"uC195p", "sh", "o", "l", NULL},
   {"uC196p", "sh", "o", "l", NULL},
   {"uC197p", "sh", "o", "l", NULL},
   {"uC198p", "sh", "o", "l", NULL},
   {"uC199p", "sh", "o", "l", NULL},
   {"uC19Ap", "sh", "o", "l", NULL},
   {"uC19Bp", "sh", "o", "l", NULL},
   {"uC19Cp", "sh", "o", "m", NULL},
   {"uC19Dp", "sh", "o", "p", NULL},
   {"uC19Ep", "sh", "o", "p", NULL},
   {"uC19Fp", "sh", "o", "sh", NULL},
   {"uC1A0p", "sh", "o", "s", NULL},
   {"uC1A1p", "sh", "o", "N", NULL},
   {"uC1A2p", "sh", "o", "tS", NULL},
   {"uC1A3p", "sh", "o", "tSh", NULL},
   {"uC1A4p", "sh", "o", "kh", NULL},
   {"uC1A5p", "sh", "o", "th", NULL},
   {"uC1A6p", "sh", "o", "ph", NULL},
   {"uC1A7p", "sh", "o", "h", NULL},
   {"uC1A8p", "sh", "w", "a", NULL},
   {"uC1A9p", "sh", "w", "a", NULL},
   {"uC1AAp", "sh", "w", "a", NULL},
   {"uC1ABp", "sh", "w", "a", NULL},
   {"uC1ACp", "sh", "w", "a", NULL},
   {"uC1ADp", "sh", "w", "a", NULL},
   {"uC1AEp", "sh", "w", "a", NULL},
   {"uC1AFp", "sh", "w", "a", NULL},
   {"uC1B0p", "sh", "w", "a", NULL},
   {"uC1B1p", "sh", "w", "a", NULL},
   {"uC1B2p", "sh", "w", "a", NULL},
   {"uC1B3p", "sh", "w", "a", NULL},
   {"uC1B4p", "sh", "w", "a", NULL},
   {"uC1B5p", "sh", "w", "a", NULL},
   {"uC1B6p", "sh", "w", "a", NULL},
   {"uC1B7p", "sh", "w", "a", NULL},
   {"uC1B8p", "sh", "w", "a", NULL},
   {"uC1B9p", "sh", "w", "a", NULL},
   {"uC1BAp", "sh", "w", "a", NULL},
   {"uC1BBp", "sh", "w", "a", NULL},
   {"uC1BCp", "sh", "w", "a", NULL},
   {"uC1BDp", "sh", "w", "a", NULL},
   {"uC1BEp", "sh", "w", "a", NULL},
   {"uC1BFp", "sh", "w", "a", NULL},
   {"uC1C0p", "sh", "w", "a", NULL},
   {"uC1C1p", "sh", "w", "a", NULL},
   {"uC1C2p", "sh", "w", "a", NULL},
   {"uC1C3p", "sh", "w", "a", NULL},
   {"uC1C4p", "sh", "w", "@", NULL},
   {"uC1C5p", "sh", "w", "@", NULL},
   {"uC1C6p", "sh", "w", "@", NULL},
   {"uC1C7p", "sh", "w", "@", NULL},
   {"uC1C8p", "sh", "w", "@", NULL},
   {"uC1C9p", "sh", "w", "@", NULL},
   {"uC1CAp", "sh", "w", "@", NULL},
   {"uC1CBp", "sh", "w", "@", NULL},
   {"uC1CCp", "sh", "w", "@", NULL},
   {"uC1CDp", "sh", "w", "@", NULL},
   {"uC1CEp", "sh", "w", "@", NULL},
   {"uC1CFp", "sh", "w", "@", NULL},
   {"uC1D0p", "sh", "w", "@", NULL},
   {"uC1D1p", "sh", "w", "@", NULL},
   {"uC1D2p", "sh", "w", "@", NULL},
   {"uC1D3p", "sh", "w", "@", NULL},
   {"uC1D4p", "sh", "w", "@", NULL},
   {"uC1D5p", "sh", "w", "@", NULL},
   {"uC1D6p", "sh", "w", "@", NULL},
   {"uC1D7p", "sh", "w", "@", NULL},
   {"uC1D8p", "sh", "w", "@", NULL},
   {"uC1D9p", "sh", "w", "@", NULL},
   {"uC1DAp", "sh", "w", "@", NULL},
   {"uC1DBp", "sh", "w", "@", NULL},
   {"uC1DCp", "sh", "w", "@", NULL},
   {"uC1DDp", "sh", "w", "@", NULL},
   {"uC1DEp", "sh", "w", "@", NULL},
   {"uC1DFp", "sh", "w", "@", NULL},
   {"uC1E0p", "sh", "w", "e", NULL},
   {"uC1E1p", "sh", "w", "e", NULL},
   {"uC1E2p", "sh", "w", "e", NULL},
   {"uC1E3p", "sh", "w", "e", NULL},
   {"uC1E4p", "sh", "w", "e", NULL},
   {"uC1E5p", "sh", "w", "e", NULL},
   {"uC1E6p", "sh", "w", "e", NULL},
   {"uC1E7p", "sh", "w", "e", NULL},
   {"uC1E8p", "sh", "w", "e", NULL},
   {"uC1E9p", "sh", "w", "e", NULL},
   {"uC1EAp", "sh", "w", "e", NULL},
   {"uC1EBp", "sh", "w", "e", NULL},
   {"uC1ECp", "sh", "w", "e", NULL},
   {"uC1EDp", "sh", "w", "e", NULL},
   {"uC1EEp", "sh", "w", "e", NULL},
   {"uC1EFp", "sh", "w", "e", NULL},
   {"uC1F0p", "sh", "w", "e", NULL},
   {"uC1F1p", "sh", "w", "e", NULL},
   {"uC1F2p", "sh", "w", "e", NULL},
   {"uC1F3p", "sh", "w", "e", NULL},
   {"uC1F4p", "sh", "w", "e", NULL},
   {"uC1F5p", "sh", "w", "e", NULL},
   {"uC1F6p", "sh", "w", "e", NULL},
   {"uC1F7p", "sh", "w", "e", NULL},
   {"uC1F8p", "sh", "w", "e", NULL},
   {"uC1F9p", "sh", "w", "e", NULL},
   {"uC1FAp", "sh", "w", "e", NULL},
   {"uC1FBp", "sh", "w", "e", NULL},
   {"uC1FCp", "sh", "j", "o", NULL},
   {"uC1FDp", "sh", "j", "o", NULL},
   {"uC1FEp", "sh", "j", "o", NULL},
   {"uC1FFp", "sh", "j", "o", NULL},
   {"uC200p", "sh", "j", "o", NULL},
   {"uC201p", "sh", "j", "o", NULL},
   {"uC202p", "sh", "j", "o", NULL},
   {"uC203p", "sh", "j", "o", NULL},
   {"uC204p", "sh", "j", "o", NULL},
   {"uC205p", "sh", "j", "o", NULL},
   {"uC206p", "sh", "j", "o", NULL},
   {"uC207p", "sh", "j", "o", NULL},
   {"uC208p", "sh", "j", "o", NULL},
   {"uC209p", "sh", "j", "o", NULL},
   {"uC20Ap", "sh", "j", "o", NULL},
   {"uC20Bp", "sh", "j", "o", NULL},
   {"uC20Cp", "sh", "j", "o", NULL},
   {"uC20Dp", "sh", "j", "o", NULL},
   {"uC20Ep", "sh", "j", "o", NULL},
   {"uC20Fp", "sh", "j", "o", NULL},
   {"uC210p", "sh", "j", "o", NULL},
   {"uC211p", "sh", "j", "o", NULL},
   {"uC212p", "sh", "j", "o", NULL},
   {"uC213p", "sh", "j", "o", NULL},
   {"uC214p", "sh", "j", "o", NULL},
   {"uC215p", "sh", "j", "o", NULL},
   {"uC216p", "sh", "j", "o", NULL},
   {"uC217p", "sh", "j", "o", NULL},
   {"uC218p", "sh", "u", NULL, NULL},
   {"uC219p", "sh", "u", "k", NULL},
   {"uC21Ap", "sh", "u", "kGT", NULL},
   {"uC21Bp", "sh", "u", "k", NULL},
   {"uC21Cp", "sh", "u", "n", NULL},
   {"uC21Dp", "sh", "u", "n", NULL},
   {"uC21Ep", "sh", "u", "n", NULL},
   {"uC21Fp", "sh", "u", "t", NULL},
   {"uC220p", "sh", "u", "l", NULL},
   {"uC221p", "sh", "u", "l", NULL},
   {"uC222p", "sh", "u", "l", NULL},
   {"uC223p", "sh", "u", "l", NULL},
   {"uC224p", "sh", "u", "l", NULL},
   {"uC225p", "sh", "u", "l", NULL},
   {"uC226p", "sh", "u", "l", NULL},
   {"uC227p", "sh", "u", "l", NULL},
   {"uC228p", "sh", "u", "m", NULL},
   {"uC229p", "sh", "u", "p", NULL},
   {"uC22Ap", "sh", "u", "p", NULL},
   {"uC22Bp", "sh", "u", "sh", NULL},
   {"uC22Cp", "sh", "u", "s", NULL},
   {"uC22Dp", "sh", "u", "N", NULL},
   {"uC22Ep", "sh", "u", "tS", NULL},
   {"uC22Fp", "sh", "u", "tSh", NULL},
   {"uC230p", "sh", "u", "kh", NULL},
   {"uC231p", "sh", "u", "th", NULL},
   {"uC232p", "sh", "u", "ph", NULL},
   {"uC233p", "sh", "u", "h", NULL},
   {"uC234p", "sh", "w", "^", NULL},
   {"uC235p", "sh", "w", "^", NULL},
   {"uC236p", "sh", "w", "^", NULL},
   {"uC237p", "sh", "w", "^", NULL},
   {"uC238p", "sh", "w", "^", NULL},
   {"uC239p", "sh", "w", "^", NULL},
   {"uC23Ap", "sh", "w", "^", NULL},
   {"uC23Bp", "sh", "w", "^", NULL},
   {"uC23Cp", "sh", "w", "^", NULL},
   {"uC23Dp", "sh", "w", "^", NULL},
   {"uC23Ep", "sh", "w", "^", NULL},
   {"uC23Fp", "sh", "w", "^", NULL},
   {"uC240p", "sh", "w", "^", NULL},
   {"uC241p", "sh", "w", "^", NULL},
   {"uC242p", "sh", "w", "^", NULL},
   {"uC243p", "sh", "w", "^", NULL},
   {"uC244p", "sh", "w", "^", NULL},
   {"uC245p", "sh", "w", "^", NULL},
   {"uC246p", "sh", "w", "^", NULL},
   {"uC247p", "sh", "w", "^", NULL},
   {"uC248p", "sh", "w", "^", NULL},
   {"uC249p", "sh", "w", "^", NULL},
   {"uC24Ap", "sh", "w", "^", NULL},
   {"uC24Bp", "sh", "w", "^", NULL},
   {"uC24Cp", "sh", "w", "^", NULL},
   {"uC24Dp", "sh", "w", "^", NULL},
   {"uC24Ep", "sh", "w", "^", NULL},
   {"uC24Fp", "sh", "w", "^", NULL},
   {"uC250p", "sh", "w", "e", NULL},
   {"uC251p", "sh", "w", "e", NULL},
   {"uC252p", "sh", "w", "e", NULL},
   {"uC253p", "sh", "w", "e", NULL},
   {"uC254p", "sh", "w", "e", NULL},
   {"uC255p", "sh", "w", "e", NULL},
   {"uC256p", "sh", "w", "e", NULL},
   {"uC257p", "sh", "w", "e", NULL},
   {"uC258p", "sh", "w", "e", NULL},
   {"uC259p", "sh", "w", "e", NULL},
   {"uC25Ap", "sh", "w", "e", NULL},
   {"uC25Bp", "sh", "w", "e", NULL},
   {"uC25Cp", "sh", "w", "e", NULL},
   {"uC25Dp", "sh", "w", "e", NULL},
   {"uC25Ep", "sh", "w", "e", NULL},
   {"uC25Fp", "sh", "w", "e", NULL},
   {"uC260p", "sh", "w", "e", NULL},
   {"uC261p", "sh", "w", "e", NULL},
   {"uC262p", "sh", "w", "e", NULL},
   {"uC263p", "sh", "w", "e", NULL},
   {"uC264p", "sh", "w", "e", NULL},
   {"uC265p", "sh", "w", "e", NULL},
   {"uC266p", "sh", "w", "e", NULL},
   {"uC267p", "sh", "w", "e", NULL},
   {"uC268p", "sh", "w", "e", NULL},
   {"uC269p", "sh", "w", "e", NULL},
   {"uC26Ap", "sh", "w", "e", NULL},
   {"uC26Bp", "sh", "w", "e", NULL},
   {"uC26Cp", "sh", "7", NULL, NULL},
   {"uC26Dp", "sh", "7", "k", NULL},
   {"uC26Ep", "sh", "7", "kGT", NULL},
   {"uC26Fp", "sh", "7", "k", NULL},
   {"uC270p", "sh", "7", "n", NULL},
   {"uC271p", "sh", "7", "n", NULL},
   {"uC272p", "sh", "7", "n", NULL},
   {"uC273p", "sh", "7", "t", NULL},
   {"uC274p", "sh", "7", "l", NULL},
   {"uC275p", "sh", "7", "l", NULL},
   {"uC276p", "sh", "7", "l", NULL},
   {"uC277p", "sh", "7", "l", NULL},
   {"uC278p", "sh", "7", "l", NULL},
   {"uC279p", "sh", "7", "l", NULL},
   {"uC27Ap", "sh", "7", "l", NULL},
   {"uC27Bp", "sh", "7", "l", NULL},
   {"uC27Cp", "sh", "7", "m", NULL},
   {"uC27Dp", "sh", "7", "p", NULL},
   {"uC27Ep", "sh", "7", "p", NULL},
   {"uC27Fp", "sh", "7", "sh", NULL},
   {"uC280p", "sh", "7", "s", NULL},
   {"uC281p", "sh", "7", "N", NULL},
   {"uC282p", "sh", "7", "tS", NULL},
   {"uC283p", "sh", "7", "tSh", NULL},
   {"uC284p", "sh", "7", "kh", NULL},
   {"uC285p", "sh", "7", "th", NULL},
   {"uC286p", "sh", "7", "ph", NULL},
   {"uC287p", "sh", "7", "h", NULL},
   {"uC288p", "sh", "j", "u", NULL},
   {"uC289p", "sh", "j", "u", NULL},
   {"uC28Ap", "sh", "j", "u", NULL},
   {"uC28Bp", "sh", "j", "u", NULL},
   {"uC28Cp", "sh", "j", "u", NULL},
   {"uC28Dp", "sh", "j", "u", NULL},
   {"uC28Ep", "sh", "j", "u", NULL},
   {"uC28Fp", "sh", "j", "u", NULL},
   {"uC290p", "sh", "j", "u", NULL},
   {"uC291p", "sh", "j", "u", NULL},
   {"uC292p", "sh", "j", "u", NULL},
   {"uC293p", "sh", "j", "u", NULL},
   {"uC294p", "sh", "j", "u", NULL},
   {"uC295p", "sh", "j", "u", NULL},
   {"uC296p", "sh", "j", "u", NULL},
   {"uC297p", "sh", "j", "u", NULL},
   {"uC298p", "sh", "j", "u", NULL},
   {"uC299p", "sh", "j", "u", NULL},
   {"uC29Ap", "sh", "j", "u", NULL},
   {"uC29Bp", "sh", "j", "u", NULL},
   {"uC29Cp", "sh", "j", "u", NULL},
   {"uC29Dp", "sh", "j", "u", NULL},
   {"uC29Ep", "sh", "j", "u", NULL},
   {"uC29Fp", "sh", "j", "u", NULL},
   {"uC2A0p", "sh", "j", "u", NULL},
   {"uC2A1p", "sh", "j", "u", NULL},
   {"uC2A2p", "sh", "j", "u", NULL},
   {"uC2A3p", "sh", "j", "u", NULL},
   {"uC2A4p", "sh", "4", NULL, NULL},
   {"uC2A5p", "sh", "4", "k", NULL},
   {"uC2A6p", "sh", "4", "kGT", NULL},
   {"uC2A7p", "sh", "4", "k", NULL},
   {"uC2A8p", "sh", "4", "n", NULL},
   {"uC2A9p", "sh", "4", "n", NULL},
   {"uC2AAp", "sh", "4", "n", NULL},
   {"uC2ABp", "sh", "4", "t", NULL},
   {"uC2ACp", "sh", "4", "l", NULL},
   {"uC2ADp", "sh", "4", "l", NULL},
   {"uC2AEp", "sh", "4", "l", NULL},
   {"uC2AFp", "sh", "4", "l", NULL},
   {"uC2B0p", "sh", "4", "l", NULL},
   {"uC2B1p", "sh", "4", "l", NULL},
   {"uC2B2p", "sh", "4", "l", NULL},
   {"uC2B3p", "sh", "4", "l", NULL},
   {"uC2B4p", "sh", "4", "m", NULL},
   {"uC2B5p", "sh", "4", "p", NULL},
   {"uC2B6p", "sh", "4", "p", NULL},
   {"uC2B7p", "sh", "4", "sh", NULL},
   {"uC2B8p", "sh", "4", "s", NULL},
   {"uC2B9p", "sh", "4", "N", NULL},
   {"uC2BAp", "sh", "4", "tS", NULL},
   {"uC2BBp", "sh", "4", "tSh", NULL},
   {"uC2BCp", "sh", "4", "kh", NULL},
   {"uC2BDp", "sh", "4", "th", NULL},
   {"uC2BEp", "sh", "4", "ph", NULL},
   {"uC2BFp", "sh", "4", "h", NULL},
   {"uC2C0p", "sh", "4", "j", NULL},
   {"uC2C1p", "sh", "4", "j", NULL},
   {"uC2C2p", "sh", "4", "j", NULL},
   {"uC2C3p", "sh", "4", "j", NULL},
   {"uC2C4p", "sh", "4", "j", NULL},
   {"uC2C5p", "sh", "4", "j", NULL},
   {"uC2C6p", "sh", "4", "j", NULL},
   {"uC2C7p", "sh", "4", "j", NULL},
   {"uC2C8p", "sh", "4", "j", NULL},
   {"uC2C9p", "sh", "4", "j", NULL},
   {"uC2CAp", "sh", "4", "j", NULL},
   {"uC2CBp", "sh", "4", "j", NULL},
   {"uC2CCp", "sh", "4", "j", NULL},
   {"uC2CDp", "sh", "4", "j", NULL},
   {"uC2CEp", "sh", "4", "j", NULL},
   {"uC2CFp", "sh", "4", "j", NULL},
   {"uC2D0p", "sh", "4", "j", NULL},
   {"uC2D1p", "sh", "4", "j", NULL},
   {"uC2D2p", "sh", "4", "j", NULL},
   {"uC2D3p", "sh", "4", "j", NULL},
   {"uC2D4p", "sh", "4", "j", NULL},
   {"uC2D5p", "sh", "4", "j", NULL},
   {"uC2D6p", "sh", "4", "j", NULL},
   {"uC2D7p", "sh", "4", "j", NULL},
   {"uC2D8p", "sh", "4", "j", NULL},
   {"uC2D9p", "sh", "4", "j", NULL},
   {"uC2DAp", "sh", "4", "j", NULL},
   {"uC2DBp", "sh", "4", "j", NULL},
   {"uC2DCp", "sh", "i", NULL, NULL},
   {"uC2DDp", "sh", "i", "k", NULL},
   {"uC2DEp", "sh", "i", "kGT", NULL},
   {"uC2DFp", "sh", "i", "k", NULL},
   {"uC2E0p", "sh", "i", "n", NULL},
   {"uC2E1p", "sh", "i", "n", NULL},
   {"uC2E2p", "sh", "i", "n", NULL},
   {"uC2E3p", "sh", "i", "t", NULL},
   {"uC2E4p", "sh", "i", "l", NULL},
   {"uC2E5p", "sh", "i", "l", NULL},
   {"uC2E6p", "sh", "i", "l", NULL},
   {"uC2E7p", "sh", "i", "l", NULL},
   {"uC2E8p", "sh", "i", "l", NULL},
   {"uC2E9p", "sh", "i", "l", NULL},
   {"uC2EAp", "sh", "i", "l", NULL},
   {"uC2EBp", "sh", "i", "l", NULL},
   {"uC2ECp", "sh", "i", "m", NULL},
   {"uC2EDp", "sh", "i", "p", NULL},
   {"uC2EEp", "sh", "i", "p", NULL},
   {"uC2EFp", "sh", "i", "sh", NULL},
   {"uC2F0p", "sh", "i", "s", NULL},
   {"uC2F1p", "sh", "i", "N", NULL},
   {"uC2F2p", "sh", "i", "tS", NULL},
   {"uC2F3p", "sh", "i", "tSh", NULL},
   {"uC2F4p", "sh", "i", "kh", NULL},
   {"uC2F5p", "sh", "i", "th", NULL},
   {"uC2F6p", "sh", "i", "ph", NULL},
   {"uC2F7p", "sh", "i", "h", NULL},
   {"uC2F8p", "s", "a", NULL, NULL},
   {"uC2F9p", "s", "a", "k", NULL},
   {"uC2FAp", "s", "a", "kGT", NULL},
   {"uC2FBp", "s", "a", "k", NULL},
   {"uC2FCp", "s", "a", "n", NULL},
   {"uC2FDp", "s", "a", "n", NULL},
   {"uC2FEp", "s", "a", "n", NULL},
   {"uC2FFp", "s", "a", "t", NULL},
   {"uC300p", "s", "a", "l", NULL},
   {"uC301p", "s", "a", "l", NULL},
   {"uC302p", "s", "a", "l", NULL},
   {"uC303p", "s", "a", "l", NULL},
   {"uC304p", "s", "a", "l", NULL},
   {"uC305p", "s", "a", "l", NULL},
   {"uC306p", "s", "a", "l", NULL},
   {"uC307p", "s", "a", "l", NULL},
   {"uC308p", "s", "a", "m", NULL},
   {"uC309p", "s", "a", "p", NULL},
   {"uC30Ap", "s", "a", "p", NULL},
   {"uC30Bp", "s", "a", "sh", NULL},
   {"uC30Cp", "s", "a", "s", NULL},
   {"uC30Dp", "s", "a", "N", NULL},
   {"uC30Ep", "s", "a", "tS", NULL},
   {"uC30Fp", "s", "a", "tSh", NULL},
   {"uC310p", "s", "a", "kh", NULL},
   {"uC311p", "s", "a", "th", NULL},
   {"uC312p", "s", "a", "ph", NULL},
   {"uC313p", "s", "a", "h", NULL},
   {"uC314p", "s", "@", NULL, NULL},
   {"uC315p", "s", "@", "k", NULL},
   {"uC316p", "s", "@", "kGT", NULL},
   {"uC317p", "s", "@", "k", NULL},
   {"uC318p", "s", "@", "n", NULL},
   {"uC319p", "s", "@", "n", NULL},
   {"uC31Ap", "s", "@", "n", NULL},
   {"uC31Bp", "s", "@", "t", NULL},
   {"uC31Cp", "s", "@", "l", NULL},
   {"uC31Dp", "s", "@", "l", NULL},
   {"uC31Ep", "s", "@", "l", NULL},
   {"uC31Fp", "s", "@", "l", NULL},
   {"uC320p", "s", "@", "l", NULL},
   {"uC321p", "s", "@", "l", NULL},
   {"uC322p", "s", "@", "l", NULL},
   {"uC323p", "s", "@", "l", NULL},
   {"uC324p", "s", "@", "m", NULL},
   {"uC325p", "s", "@", "p", NULL},
   {"uC326p", "s", "@", "p", NULL},
   {"uC327p", "s", "@", "sh", NULL},
   {"uC328p", "s", "@", "s", NULL},
   {"uC329p", "s", "@", "N", NULL},
   {"uC32Ap", "s", "@", "tS", NULL},
   {"uC32Bp", "s", "@", "tSh", NULL},
   {"uC32Cp", "s", "@", "kh", NULL},
   {"uC32Dp", "s", "@", "th", NULL},
   {"uC32Ep", "s", "@", "ph", NULL},
   {"uC32Fp", "s", "@", "h", NULL},
   {"uC330p", "s", "j", "a", NULL},
   {"uC331p", "s", "j", "a", NULL},
   {"uC332p", "s", "j", "a", NULL},
   {"uC333p", "s", "j", "a", NULL},
   {"uC334p", "s", "j", "a", NULL},
   {"uC335p", "s", "j", "a", NULL},
   {"uC336p", "s", "j", "a", NULL},
   {"uC337p", "s", "j", "a", NULL},
   {"uC338p", "s", "j", "a", NULL},
   {"uC339p", "s", "j", "a", NULL},
   {"uC33Ap", "s", "j", "a", NULL},
   {"uC33Bp", "s", "j", "a", NULL},
   {"uC33Cp", "s", "j", "a", NULL},
   {"uC33Dp", "s", "j", "a", NULL},
   {"uC33Ep", "s", "j", "a", NULL},
   {"uC33Fp", "s", "j", "a", NULL},
   {"uC340p", "s", "j", "a", NULL},
   {"uC341p", "s", "j", "a", NULL},
   {"uC342p", "s", "j", "a", NULL},
   {"uC343p", "s", "j", "a", NULL},
   {"uC344p", "s", "j", "a", NULL},
   {"uC345p", "s", "j", "a", NULL},
   {"uC346p", "s", "j", "a", NULL},
   {"uC347p", "s", "j", "a", NULL},
   {"uC348p", "s", "j", "a", NULL},
   {"uC349p", "s", "j", "a", NULL},
   {"uC34Ap", "s", "j", "a", NULL},
   {"uC34Bp", "s", "j", "a", NULL},
   {"uC34Cp", "s", "j", "@", NULL},
   {"uC34Dp", "s", "j", "@", NULL},
   {"uC34Ep", "s", "j", "@", NULL},
   {"uC34Fp", "s", "j", "@", NULL},
   {"uC350p", "s", "j", "@", NULL},
   {"uC351p", "s", "j", "@", NULL},
   {"uC352p", "s", "j", "@", NULL},
   {"uC353p", "s", "j", "@", NULL},
   {"uC354p", "s", "j", "@", NULL},
   {"uC355p", "s", "j", "@", NULL},
   {"uC356p", "s", "j", "@", NULL},
   {"uC357p", "s", "j", "@", NULL},
   {"uC358p", "s", "j", "@", NULL},
   {"uC359p", "s", "j", "@", NULL},
   {"uC35Ap", "s", "j", "@", NULL},
   {"uC35Bp", "s", "j", "@", NULL},
   {"uC35Cp", "s", "j", "@", NULL},
   {"uC35Dp", "s", "j", "@", NULL},
   {"uC35Ep", "s", "j", "@", NULL},
   {"uC35Fp", "s", "j", "@", NULL},
   {"uC360p", "s", "j", "@", NULL},
   {"uC361p", "s", "j", "@", NULL},
   {"uC362p", "s", "j", "@", NULL},
   {"uC363p", "s", "j", "@", NULL},
   {"uC364p", "s", "j", "@", NULL},
   {"uC365p", "s", "j", "@", NULL},
   {"uC366p", "s", "j", "@", NULL},
   {"uC367p", "s", "j", "@", NULL},
   {"uC368p", "s", "^", NULL, NULL},
   {"uC369p", "s", "^", "k", NULL},
   {"uC36Ap", "s", "^", "kGT", NULL},
   {"uC36Bp", "s", "^", "k", NULL},
   {"uC36Cp", "s", "^", "n", NULL},
   {"uC36Dp", "s", "^", "n", NULL},
   {"uC36Ep", "s", "^", "n", NULL},
   {"uC36Fp", "s", "^", "t", NULL},
   {"uC370p", "s", "^", "l", NULL},
   {"uC371p", "s", "^", "l", NULL},
   {"uC372p", "s", "^", "l", NULL},
   {"uC373p", "s", "^", "l", NULL},
   {"uC374p", "s", "^", "l", NULL},
   {"uC375p", "s", "^", "l", NULL},
   {"uC376p", "s", "^", "l", NULL},
   {"uC377p", "s", "^", "l", NULL},
   {"uC378p", "s", "^", "m", NULL},
   {"uC379p", "s", "^", "p", NULL},
   {"uC37Ap", "s", "^", "p", NULL},
   {"uC37Bp", "s", "^", "sh", NULL},
   {"uC37Cp", "s", "^", "s", NULL},
   {"uC37Dp", "s", "^", "N", NULL},
   {"uC37Ep", "s", "^", "tS", NULL},
   {"uC37Fp", "s", "^", "tSh", NULL},
   {"uC380p", "s", "^", "kh", NULL},
   {"uC381p", "s", "^", "th", NULL},
   {"uC382p", "s", "^", "ph", NULL},
   {"uC383p", "s", "^", "h", NULL},
   {"uC384p", "s", "e", NULL, NULL},
   {"uC385p", "s", "e", "k", NULL},
   {"uC386p", "s", "e", "kGT", NULL},
   {"uC387p", "s", "e", "k", NULL},
   {"uC388p", "s", "e", "n", NULL},
   {"uC389p", "s", "e", "n", NULL},
   {"uC38Ap", "s", "e", "n", NULL},
   {"uC38Bp", "s", "e", "t", NULL},
   {"uC38Cp", "s", "e", "l", NULL},
   {"uC38Dp", "s", "e", "l", NULL},
   {"uC38Ep", "s", "e", "l", NULL},
   {"uC38Fp", "s", "e", "l", NULL},
   {"uC390p", "s", "e", "l", NULL},
   {"uC391p", "s", "e", "l", NULL},
   {"uC392p", "s", "e", "l", NULL},
   {"uC393p", "s", "e", "l", NULL},
   {"uC394p", "s", "e", "m", NULL},
   {"uC395p", "s", "e", "p", NULL},
   {"uC396p", "s", "e", "p", NULL},
   {"uC397p", "s", "e", "sh", NULL},
   {"uC398p", "s", "e", "s", NULL},
   {"uC399p", "s", "e", "N", NULL},
   {"uC39Ap", "s", "e", "tS", NULL},
   {"uC39Bp", "s", "e", "tSh", NULL},
   {"uC39Cp", "s", "e", "kh", NULL},
   {"uC39Dp", "s", "e", "th", NULL},
   {"uC39Ep", "s", "e", "ph", NULL},
   {"uC39Fp", "s", "e", "h", NULL},
   {"uC3A0p", "s", "j", "^", NULL},
   {"uC3A1p", "s", "j", "^", NULL},
   {"uC3A2p", "s", "j", "^", NULL},
   {"uC3A3p", "s", "j", "^", NULL},
   {"uC3A4p", "s", "j", "^", NULL},
   {"uC3A5p", "s", "j", "^", NULL},
   {"uC3A6p", "s", "j", "^", NULL},
   {"uC3A7p", "s", "j", "^", NULL},
   {"uC3A8p", "s", "j", "^", NULL},
   {"uC3A9p", "s", "j", "^", NULL},
   {"uC3AAp", "s", "j", "^", NULL},
   {"uC3ABp", "s", "j", "^", NULL},
   {"uC3ACp", "s", "j", "^", NULL},
   {"uC3ADp", "s", "j", "^", NULL},
   {"uC3AEp", "s", "j", "^", NULL},
   {"uC3AFp", "s", "j", "^", NULL},
   {"uC3B0p", "s", "j", "^", NULL},
   {"uC3B1p", "s", "j", "^", NULL},
   {"uC3B2p", "s", "j", "^", NULL},
   {"uC3B3p", "s", "j", "^", NULL},
   {"uC3B4p", "s", "j", "^", NULL},
   {"uC3B5p", "s", "j", "^", NULL},
   {"uC3B6p", "s", "j", "^", NULL},
   {"uC3B7p", "s", "j", "^", NULL},
   {"uC3B8p", "s", "j", "^", NULL},
   {"uC3B9p", "s", "j", "^", NULL},
   {"uC3BAp", "s", "j", "^", NULL},
   {"uC3BBp", "s", "j", "^", NULL},
   {"uC3BCp", "s", "j", "e", NULL},
   {"uC3BDp", "s", "j", "e", NULL},
   {"uC3BEp", "s", "j", "e", NULL},
   {"uC3BFp", "s", "j", "e", NULL},
   {"uC3C0p", "s", "j", "e", NULL},
   {"uC3C1p", "s", "j", "e", NULL},
   {"uC3C2p", "s", "j", "e", NULL},
   {"uC3C3p", "s", "j", "e", NULL},
   {"uC3C4p", "s", "j", "e", NULL},
   {"uC3C5p", "s", "j", "e", NULL},
   {"uC3C6p", "s", "j", "e", NULL},
   {"uC3C7p", "s", "j", "e", NULL},
   {"uC3C8p", "s", "j", "e", NULL},
   {"uC3C9p", "s", "j", "e", NULL},
   {"uC3CAp", "s", "j", "e", NULL},
   {"uC3CBp", "s", "j", "e", NULL},
   {"uC3CCp", "s", "j", "e", NULL},
   {"uC3CDp", "s", "j", "e", NULL},
   {"uC3CEp", "s", "j", "e", NULL},
   {"uC3CFp", "s", "j", "e", NULL},
   {"uC3D0p", "s", "j", "e", NULL},
   {"uC3D1p", "s", "j", "e", NULL},
   {"uC3D2p", "s", "j", "e", NULL},
   {"uC3D3p", "s", "j", "e", NULL},
   {"uC3D4p", "s", "j", "e", NULL},
   {"uC3D5p", "s", "j", "e", NULL},
   {"uC3D6p", "s", "j", "e", NULL},
   {"uC3D7p", "s", "j", "e", NULL},
   {"uC3D8p", "s", "o", NULL, NULL},
   {"uC3D9p", "s", "o", "k", NULL},
   {"uC3DAp", "s", "o", "kGT", NULL},
   {"uC3DBp", "s", "o", "k", NULL},
   {"uC3DCp", "s", "o", "n", NULL},
   {"uC3DDp", "s", "o", "n", NULL},
   {"uC3DEp", "s", "o", "n", NULL},
   {"uC3DFp", "s", "o", "t", NULL},
   {"uD3E0p", "s", "o", "l", NULL},
   {"uC3E1p", "s", "o", "l", NULL},
   {"uC3E2p", "s", "o", "l", NULL},
   {"uC3E3p", "s", "o", "l", NULL},
   {"uC3E4p", "s", "o", "l", NULL},
   {"uC3E5p", "s", "o", "l", NULL},
   {"uC3E6p", "s", "o", "l", NULL},
   {"uC3E7p", "s", "o", "l", NULL},
   {"uC3E8p", "s", "o", "m", NULL},
   {"uC3E9p", "s", "o", "p", NULL},
   {"uC3EAp", "s", "o", "p", NULL},
   {"uC3EBp", "s", "o", "sh", NULL},
   {"uC3ECp", "s", "o", "s", NULL},
   {"uC3EDp", "s", "o", "N", NULL},
   {"uC3EEp", "s", "o", "tS", NULL},
   {"uC3EFp", "s", "o", "tSh", NULL},
   {"uC3F0p", "s", "o", "kh", NULL},
   {"uC3F1p", "s", "o", "th", NULL},
   {"uC3F2p", "s", "o", "ph", NULL},
   {"uC3F3p", "s", "o", "h", NULL},
   {"uC3F4p", "s", "w", "a", NULL},
   {"uC3F5p", "s", "w", "a", NULL},
   {"uC3F6p", "s", "w", "a", NULL},
   {"uC3F7p", "s", "w", "a", NULL},
   {"uC3F8p", "s", "w", "a", NULL},
   {"uC3F9p", "s", "w", "a", NULL},
   {"uC3FAp", "s", "w", "a", NULL},
   {"uC3FBp", "s", "w", "a", NULL},
   {"uC3FCp", "s", "w", "a", NULL},
   {"uC3FDp", "s", "w", "a", NULL},
   {"uC3FEp", "s", "w", "a", NULL},
   {"uC3FFp", "s", "w", "a", NULL},
   {"uC400p", "s", "w", "a", NULL},
   {"uC401p", "s", "w", "a", NULL},
   {"uC402p", "s", "w", "a", NULL},
   {"uC403p", "s", "w", "a", NULL},
   {"uC404p", "s", "w", "a", NULL},
   {"uC405p", "s", "w", "a", NULL},
   {"uC406p", "s", "w", "a", NULL},
   {"uC407p", "s", "w", "a", NULL},
   {"uC408p", "s", "w", "a", NULL},
   {"uC409p", "s", "w", "a", NULL},
   {"uC40Ap", "s", "w", "a", NULL},
   {"uC40Bp", "s", "w", "a", NULL},
   {"uC40Cp", "s", "w", "a", NULL},
   {"uC40Dp", "s", "w", "a", NULL},
   {"uC40Ep", "s", "w", "a", NULL},
   {"uC40Fp", "s", "w", "a", NULL},
   {"uC410p", "s", "w", "@", NULL},
   {"uC411p", "s", "w", "@", NULL},
   {"uC412p", "s", "w", "@", NULL},
   {"uC413p", "s", "w", "@", NULL},
   {"uC414p", "s", "w", "@", NULL},
   {"uC415p", "s", "w", "@", NULL},
   {"uC416p", "s", "w", "@", NULL},
   {"uC417p", "s", "w", "@", NULL},
   {"uC418p", "s", "w", "@", NULL},
   {"uC419p", "s", "w", "@", NULL},
   {"uC41Ap", "s", "w", "@", NULL},
   {"uC41Bp", "s", "w", "@", NULL},
   {"uC41Cp", "s", "w", "@", NULL},
   {"uC41Dp", "s", "w", "@", NULL},
   {"uC41Ep", "s", "w", "@", NULL},
   {"uC41Fp", "s", "w", "@", NULL},
   {"uC420p", "s", "w", "@", NULL},
   {"uC421p", "s", "w", "@", NULL},
   {"uC422p", "s", "w", "@", NULL},
   {"uC423p", "s", "w", "@", NULL},
   {"uC424p", "s", "w", "@", NULL},
   {"uC425p", "s", "w", "@", NULL},
   {"uC426p", "s", "w", "@", NULL},
   {"uC427p", "s", "w", "@", NULL},
   {"uC428p", "s", "w", "@", NULL},
   {"uC429p", "s", "w", "@", NULL},
   {"uC42Ap", "s", "w", "@", NULL},
   {"uC42Bp", "s", "w", "@", NULL},
   {"uC42Cp", "s", "w", "e", NULL},
   {"uC42Dp", "s", "w", "e", NULL},
   {"uC42Ep", "s", "w", "e", NULL},
   {"uC42Fp", "s", "w", "e", NULL},
   {"uC430p", "s", "w", "e", NULL},
   {"uC431p", "s", "w", "e", NULL},
   {"uC432p", "s", "w", "e", NULL},
   {"uC433p", "s", "w", "e", NULL},
   {"uC434p", "s", "w", "e", NULL},
   {"uC435p", "s", "w", "e", NULL},
   {"uC436p", "s", "w", "e", NULL},
   {"uC437p", "s", "w", "e", NULL},
   {"uC438p", "s", "w", "e", NULL},
   {"uC439p", "s", "w", "e", NULL},
   {"uC43Ap", "s", "w", "e", NULL},
   {"uC43Bp", "s", "w", "e", NULL},
   {"uC43Cp", "s", "w", "e", NULL},
   {"uC43Dp", "s", "w", "e", NULL},
   {"uC43Ep", "s", "w", "e", NULL},
   {"uC43Fp", "s", "w", "e", NULL},
   {"uC440p", "s", "w", "e", NULL},
   {"uC441p", "s", "w", "e", NULL},
   {"uC442p", "s", "w", "e", NULL},
   {"uC443p", "s", "w", "e", NULL},
   {"uC444p", "s", "w", "e", NULL},
   {"uC445p", "s", "w", "e", NULL},
   {"uC446p", "s", "w", "e", NULL},
   {"uC447p", "s", "w", "e", NULL},
   {"uC448p", "s", "j", "o", NULL},
   {"uC449p", "s", "j", "o", NULL},
   {"uC44Ap", "s", "j", "o", NULL},
   {"uC44Bp", "s", "j", "o", NULL},
   {"uC44Cp", "s", "j", "o", NULL},
   {"uC44Dp", "s", "j", "o", NULL},
   {"uC44Ep", "s", "j", "o", NULL},
   {"uC44Fp", "s", "j", "o", NULL},
   {"uC450p", "s", "j", "o", NULL},
   {"uC451p", "s", "j", "o", NULL},
   {"uC452p", "s", "j", "o", NULL},
   {"uC453p", "s", "j", "o", NULL},
   {"uC454p", "s", "j", "o", NULL},
   {"uC455p", "s", "j", "o", NULL},
   {"uC456p", "s", "j", "o", NULL},
   {"uC457p", "s", "j", "o", NULL},
   {"uC458p", "s", "j", "o", NULL},
   {"uC459p", "s", "j", "o", NULL},
   {"uC45Ap", "s", "j", "o", NULL},
   {"uC45Bp", "s", "j", "o", NULL},
   {"uC45Cp", "s", "j", "o", NULL},
   {"uC45Dp", "s", "j", "o", NULL},
   {"uC45Ep", "s", "j", "o", NULL},
   {"uC45Fp", "s", "j", "o", NULL},
   {"uC460p", "s", "j", "o", NULL},
   {"uC461p", "s", "j", "o", NULL},
   {"uC462p", "s", "j", "o", NULL},
   {"uC463p", "s", "j", "o", NULL},
   {"uC464p", "s", "u", NULL, NULL},
   {"uC465p", "s", "u", "k", NULL},
   {"uC466p", "s", "u", "kGT", NULL},
   {"uC467p", "s", "u", "k", NULL},
   {"uC468p", "s", "u", "n", NULL},
   {"uC469p", "s", "u", "n", NULL},
   {"uC46Ap", "s", "u", "n", NULL},
   {"uC46Bp", "s", "u", "t", NULL},
   {"uC46Cp", "s", "u", "l", NULL},
   {"uC46Dp", "s", "u", "l", NULL},
   {"uC46Ep", "s", "u", "l", NULL},
   {"uC46Fp", "s", "u", "l", NULL},
   {"uC470p", "s", "u", "l", NULL},
   {"uC471p", "s", "u", "l", NULL},
   {"uC472p", "s", "u", "l", NULL},
   {"uC473p", "s", "u", "l", NULL},
   {"uC474p", "s", "u", "m", NULL},
   {"uC475p", "s", "u", "p", NULL},
   {"uC476p", "s", "u", "p", NULL},
   {"uC477p", "s", "u", "sh", NULL},
   {"uC478p", "s", "u", "s", NULL},
   {"uC479p", "s", "u", "N", NULL},
   {"uC47Ap", "s", "u", "tS", NULL},
   {"uC47Bp", "s", "u", "tSh", NULL},
   {"uC47Cp", "s", "u", "kh", NULL},
   {"uC47Dp", "s", "u", "th", NULL},
   {"uC47Ep", "s", "u", "ph", NULL},
   {"uC47Fp", "s", "u", "h", NULL},
   {"uC480p", "s", "w", "^", NULL},
   {"uC481p", "s", "w", "^", NULL},
   {"uC482p", "s", "w", "^", NULL},
   {"uC483p", "s", "w", "^", NULL},
   {"uC484p", "s", "w", "^", NULL},
   {"uC485p", "s", "w", "^", NULL},
   {"uC486p", "s", "w", "^", NULL},
   {"uC487p", "s", "w", "^", NULL},
   {"uC488p", "s", "w", "^", NULL},
   {"uC489p", "s", "w", "^", NULL},
   {"uC48Ap", "s", "w", "^", NULL},
   {"uC48Bp", "s", "w", "^", NULL},
   {"uC48Cp", "s", "w", "^", NULL},
   {"uC48Dp", "s", "w", "^", NULL},
   {"uC48Ep", "s", "w", "^", NULL},
   {"uC48Fp", "s", "w", "^", NULL},
   {"uC490p", "s", "w", "^", NULL},
   {"uC491p", "s", "w", "^", NULL},
   {"uC492p", "s", "w", "^", NULL},
   {"uC493p", "s", "w", "^", NULL},
   {"uC494p", "s", "w", "^", NULL},
   {"uC495p", "s", "w", "^", NULL},
   {"uC496p", "s", "w", "^", NULL},
   {"uC497p", "s", "w", "^", NULL},
   {"uC498p", "s", "w", "^", NULL},
   {"uC499p", "s", "w", "^", NULL},
   {"uC49Ap", "s", "w", "^", NULL},
   {"uC49Bp", "s", "w", "^", NULL},
   {"uC49Cp", "s", "w", "e", NULL},
   {"uC49Dp", "s", "w", "e", NULL},
   {"uC49Ep", "s", "w", "e", NULL},
   {"uC49Fp", "s", "w", "e", NULL},
   {"uC4A0p", "s", "w", "e", NULL},
   {"uC4A1p", "s", "w", "e", NULL},
   {"uC4A2p", "s", "w", "e", NULL},
   {"uC4A3p", "s", "w", "e", NULL},
   {"uC4A4p", "s", "w", "e", NULL},
   {"uC4A5p", "s", "w", "e", NULL},
   {"uC4A6p", "s", "w", "e", NULL},
   {"uC4A7p", "s", "w", "e", NULL},
   {"uC4A8p", "s", "w", "e", NULL},
   {"uC4A9p", "s", "w", "e", NULL},
   {"uC4AAp", "s", "w", "e", NULL},
   {"uC4ABp", "s", "w", "e", NULL},
   {"uC4ACp", "s", "w", "e", NULL},
   {"uC4ADp", "s", "w", "e", NULL},
   {"uC4AEp", "s", "w", "e", NULL},
   {"uC4AFp", "s", "w", "e", NULL},
   {"uC4B0p", "s", "w", "e", NULL},
   {"uC4B1p", "s", "w", "e", NULL},
   {"uC4B2p", "s", "w", "e", NULL},
   {"uC4B3p", "s", "w", "e", NULL},
   {"uC4B4p", "s", "w", "e", NULL},
   {"uC4B5p", "s", "w", "e", NULL},
   {"uC4B6p", "s", "w", "e", NULL},
   {"uC4B7p", "s", "w", "e", NULL},
   {"uC4B8p", "s", "7", NULL, NULL},
   {"uC4B9p", "s", "7", "k", NULL},
   {"uC4BAp", "s", "7", "kGT", NULL},
   {"uC4BBp", "s", "7", "k", NULL},
   {"uC4BCp", "s", "7", "n", NULL},
   {"uC4BDp", "s", "7", "n", NULL},
   {"uC4BEp", "s", "7", "n", NULL},
   {"uC4BFp", "s", "7", "t", NULL},
   {"uC4C0p", "s", "7", "l", NULL},
   {"uC4C1p", "s", "7", "l", NULL},
   {"uC4C2p", "s", "7", "l", NULL},
   {"uC4C3p", "s", "7", "l", NULL},
   {"uC4C4p", "s", "7", "l", NULL},
   {"uC4C5p", "s", "7", "l", NULL},
   {"uC4C6p", "s", "7", "l", NULL},
   {"uC4C7p", "s", "7", "l", NULL},
   {"uC4C8p", "s", "7", "m", NULL},
   {"uC4C9p", "s", "7", "p", NULL},
   {"uC4CAp", "s", "7", "p", NULL},
   {"uC4CBp", "s", "7", "sh", NULL},
   {"uC4CCp", "s", "7", "s", NULL},
   {"uC4CDp", "s", "7", "N", NULL},
   {"uC4CEp", "s", "7", "tS", NULL},
   {"uC4CFp", "s", "7", "tSh", NULL},
   {"uC4D0p", "s", "7", "kh", NULL},
   {"uC4D1p", "s", "7", "th", NULL},
   {"uC4D2p", "s", "7", "ph", NULL},
   {"uC4D3p", "s", "7", "h", NULL},
   {"uC4D4p", "s", "j", "u", NULL},
   {"uC4D5p", "s", "j", "u", NULL},
   {"uC4D6p", "s", "j", "u", NULL},
   {"uC4D7p", "s", "j", "u", NULL},
   {"uC4D8p", "s", "j", "u", NULL},
   {"uC4D9p", "s", "j", "u", NULL},
   {"uC4DAp", "s", "j", "u", NULL},
   {"uC4DBp", "s", "j", "u", NULL},
   {"uC4DCp", "s", "j", "u", NULL},
   {"uC4DDp", "s", "j", "u", NULL},
   {"uC4DEp", "s", "j", "u", NULL},
   {"uC4DFp", "s", "j", "u", NULL},
   {"uC4E0p", "s", "j", "u", NULL},
   {"uC4E1p", "s", "j", "u", NULL},
   {"uC4E2p", "s", "j", "u", NULL},
   {"uC4E3p", "s", "j", "u", NULL},
   {"uC4E4p", "s", "j", "u", NULL},
   {"uC4E5p", "s", "j", "u", NULL},
   {"uC4E7p", "s", "j", "u", NULL},
   {"uC4E8p", "s", "j", "u", NULL},
   {"uC4E9p", "s", "j", "u", NULL},
   {"uC4EAp", "s", "j", "u", NULL},
   {"uC4EBp", "s", "j", "u", NULL},
   {"uC4ECp", "s", "j", "u", NULL},
   {"uC4EDp", "s", "j", "u", NULL},
   {"uC4EEp", "s", "j", "u", NULL},
   {"uC4EFp", "s", "j", "u", NULL},
   {"uC4F0p", "s", "4", NULL, NULL},
   {"uC4F1p", "s", "4", "k", NULL},
   {"uC4F2p", "s", "4", "kGT", NULL},
   {"uC4F3p", "s", "4", "k", NULL},
   {"uC4F4p", "s", "4", "n", NULL},
   {"uC4F5p", "s", "4", "n", NULL},
   {"uC4F6p", "s", "4", "n", NULL},
   {"uC4F7p", "s", "4", "t", NULL},
   {"uC4F8p", "s", "4", "l", NULL},
   {"uC4F9p", "s", "4", "l", NULL},
   {"uC4FAp", "s", "4", "l", NULL},
   {"uC4FBp", "s", "4", "l", NULL},
   {"uC4FCp", "s", "4", "l", NULL},
   {"uC4FDp", "s", "4", "l", NULL},
   {"uC4FEp", "s", "4", "l", NULL},
   {"uC4FFp", "s", "4", "l", NULL},
   {"uC500p", "s", "4", "m", NULL},
   {"uC501p", "s", "4", "p", NULL},
   {"uC502p", "s", "4", "p", NULL},
   {"uC503p", "s", "4", "sh", NULL},
   {"uC504p", "s", "4", "s", NULL},
   {"uC505p", "s", "4", "N", NULL},
   {"uC506p", "s", "4", "tS", NULL},
   {"uC507p", "s", "4", "tSh", NULL},
   {"uC508p", "s", "4", "kh", NULL},
   {"uC509p", "s", "4", "th", NULL},
   {"uC50Ap", "s", "4", "ph", NULL},
   {"uC50Bp", "s", "4", "h", NULL},
   {"uC50Cp", "s", "4", "j", NULL},
   {"uC50Dp", "s", "4", "j", NULL},
   {"uC50Ep", "s", "4", "j", NULL},
   {"uC50Fp", "s", "4", "j", NULL},
   {"uC510p", "s", "4", "j", NULL},
   {"uC511p", "s", "4", "j", NULL},
   {"uC512p", "s", "4", "j", NULL},
   {"uC513p", "s", "4", "j", NULL},
   {"uC514p", "s", "4", "j", NULL},
   {"uC515p", "s", "4", "j", NULL},
   {"uC516p", "s", "4", "j", NULL},
   {"uC517p", "s", "4", "j", NULL},
   {"uC518p", "s", "4", "j", NULL},
   {"uC519p", "s", "4", "j", NULL},
   {"uC51Ap", "s", "4", "j", NULL},
   {"uC51Bp", "s", "4", "j", NULL},
   {"uC51Cp", "s", "4", "j", NULL},
   {"uC51Dp", "s", "4", "j", NULL},
   {"uC51Ep", "s", "4", "j", NULL},
   {"uC51Fp", "s", "4", "j", NULL},
   {"uC520p", "s", "4", "j", NULL},
   {"uC521p", "s", "4", "j", NULL},
   {"uC522p", "s", "4", "j", NULL},
   {"uC523p", "s", "4", "j", NULL},
   {"uC524p", "s", "4", "j", NULL},
   {"uC525p", "s", "4", "j", NULL},
   {"uC526p", "s", "4", "j", NULL},
   {"uC527p", "s", "4", "j", NULL},
   {"uC528p", "s", "i", NULL, NULL},
   {"uC529p", "s", "i", "k", NULL},
   {"uC52Ap", "s", "i", "kGT", NULL},
   {"uC52Bp", "s", "i", "k", NULL},
   {"uC52Cp", "s", "i", "n", NULL},
   {"uC52Dp", "s", "i", "n", NULL},
   {"uC52Ep", "s", "i", "n", NULL},
   {"uC52Fp", "s", "i", "t", NULL},
   {"uC530p", "s", "i", "l", NULL},
   {"uC531p", "s", "i", "l", NULL},
   {"uC532p", "s", "i", "l", NULL},
   {"uC533p", "s", "i", "l", NULL},
   {"uC534p", "s", "i", "l", NULL},
   {"uC535p", "s", "i", "l", NULL},
   {"uC536p", "s", "i", "l", NULL},
   {"uC537p", "s", "i", "l", NULL},
   {"uC538p", "s", "i", "m", NULL},
   {"uC539p", "s", "i", "p", NULL},
   {"uC53Ap", "s", "i", "p", NULL},
   {"uC53Bp", "s", "i", "sh", NULL},
   {"uC53Cp", "s", "i", "s", NULL},
   {"uC53Dp", "s", "i", "N", NULL},
   {"uC53Ep", "s", "i", "tS", NULL},
   {"uC53Fp", "s", "i", "tSh", NULL},
   {"uC540p", "s", "i", "kh", NULL},
   {"uC541p", "s", "i", "th", NULL},
   {"uC542p", "s", "i", "ph", NULL},
   {"uC543p", "s", "i", "h", NULL},
   {"uC544p", "a", NULL, NULL, NULL},
   {"uC545p", "a", "k", NULL, NULL},
   {"uC546p", "a", "kGT", NULL, NULL},
   {"uC547p", "a", "k", "sh", NULL},
   {"uC548p", "a", "n", NULL, NULL},
   {"uC549p", "a", "n", "tS", NULL},
   {"uC54Ap", "a", "n", "h", NULL},
   {"uC54Bp", "a", "t", NULL, NULL},
   {"uC54Cp", "a", "l", NULL, NULL},
   {"uC54Dp", "a", "l", "k", NULL},
   {"uC54Ep", "a", "l", "m", NULL},
   {"uC54Fp", "a", "l", "p", NULL},
   {"uC550p", "a", "l", "sh", NULL},
   {"uC551p", "a", "l", "th", NULL},
   {"uC552p", "a", "l", "ph", NULL},
   {"uC553p", "a", "l", "h", NULL},
   {"uC554p", "a", "m", NULL, NULL},
   {"uC555p", "a", "p", NULL, NULL},
   {"uC556p", "a", "p", "sh", NULL},
   {"uC557p", "a", "sh", NULL, NULL},
   {"uC558p", "a", "s", NULL, NULL},
   {"uC559p", "a", "N", NULL, NULL},
   {"uC55Ap", "a", "tS", NULL, NULL},
   {"uC55Bp", "a", "tSh", NULL, NULL},
   {"uC55Cp", "a", "kh", NULL, NULL},
   {"uC55Dp", "a", "th", NULL, NULL},
   {"uC55Ep", "a", "ph", NULL, NULL},
   {"uC55Fp", "a", "h", NULL, NULL},
   {"uC560p", "@", NULL, NULL, NULL},
   {"uC561p", "@", "k", NULL, NULL},
   {"uC562p", "@", "kGT", NULL, NULL},
   {"uC563p", "@", "k", "sh", NULL},
   {"uC564p", "@", "n", NULL, NULL},
   {"uC565p", "@", "n", "tS", NULL},
   {"uC566p", "@", "n", "h", NULL},
   {"uC567p", "@", "t", NULL, NULL},
   {"uC568p", "@", "l", NULL, NULL},
   {"uC569p", "@", "l", "k", NULL},
   {"uC56Ap", "@", "l", "m", NULL},
   {"uC56Bp", "@", "l", "p", NULL},
   {"uC56Cp", "@", "l", "sh", NULL},
   {"uC56Dp", "@", "l", "th", NULL},
   {"uC56Ep", "@", "l", "ph", NULL},
   {"uC56Fp", "@", "l", "h", NULL},
   {"uC570p", "@", "m", NULL, NULL},
   {"uC571p", "@", "p", NULL, NULL},
   {"uC572p", "@", "p", "sh", NULL},
   {"uC573p", "@", "sh", NULL, NULL},
   {"uC574p", "@", "s", NULL, NULL},
   {"uC575p", "@", "N", NULL, NULL},
   {"uC576p", "@", "tS", NULL, NULL},
   {"uC577p", "@", "tSh", NULL, NULL},
   {"uC578p", "@", "kh", NULL, NULL},
   {"uC579p", "@", "th", NULL, NULL},
   {"uC57Ap", "@", "ph", NULL, NULL},
   {"uC57Bp", "@", "h", NULL, NULL},
   {"uC57Cp", "j", "a", NULL, NULL},
   {"uC57Dp", "j", "a", "k", NULL},
   {"uC57Ep", "j", "a", "kGT", NULL},
   {"uC57Fp", "j", "a", "k", NULL},
   {"uC580p", "j", "a", "n", NULL},
   {"uC581p", "j", "a", "n", NULL},
   {"uC582p", "j", "a", "n", NULL},
   {"uC583p", "j", "a", "t", NULL},
   {"uC584p", "j", "a", "l", NULL},
   {"uC585p", "j", "a", "l", NULL},
   {"uC586p", "j", "a", "l", NULL},
   {"uC587p", "j", "a", "l", NULL},
   {"uC588p", "j", "a", "l", NULL},
   {"uC589p", "j", "a", "l", NULL},
   {"uC58Ap", "j", "a", "l", NULL},
   {"uC58Bp", "j", "a", "l", NULL},
   {"uC58Cp", "j", "a", "m", NULL},
   {"uC58Dp", "j", "a", "p", NULL},
   {"uC58Ep", "j", "a", "p", NULL},
   {"uC58Fp", "j", "a", "sh", NULL},
   {"uC590p", "j", "a", "s", NULL},
   {"uC591p", "j", "a", "N", NULL},
   {"uC592p", "j", "a", "tS", NULL},
   {"uC593p", "j", "a", "tSh", NULL},
   {"uC594p", "j", "a", "kh", NULL},
   {"uC595p", "j", "a", "th", NULL},
   {"uC596p", "j", "a", "ph", NULL},
   {"uC597p", "j", "a", "h", NULL},
   {"uC598p", "j", "@", NULL, NULL},
   {"uC599p", "j", "@", "k", NULL},
   {"uC59Ap", "j", "@", "kGT", NULL},
   {"uC59Bp", "j", "@", "k", NULL},
   {"uC59Cp", "j", "@", "n", NULL},
   {"uC59Dp", "j", "@", "n", NULL},
   {"uC59Ep", "j", "@", "n", NULL},
   {"uC59Fp", "j", "@", "t", NULL},
   {"uC5A0p", "j", "@", "l", NULL},
   {"uC5A1p", "j", "@", "l", NULL},
   {"uC5A2p", "j", "@", "l", NULL},
   {"uC5A3p", "j", "@", "l", NULL},
   {"uC5A4p", "j", "@", "l", NULL},
   {"uC5A5p", "j", "@", "l", NULL},
   {"uC5A6p", "j", "@", "l", NULL},
   {"uC5A7p", "j", "@", "l", NULL},
   {"uC5A8p", "j", "@", "m", NULL},
   {"uC5A9p", "j", "@", "p", NULL},
   {"uC5AAp", "j", "@", "p", NULL},
   {"uC5ABp", "j", "@", "sh", NULL},
   {"uC5ACp", "j", "@", "s", NULL},
   {"uC5ADp", "j", "@", "N", NULL},
   {"uC5AEp", "j", "@", "tS", NULL},
   {"uC5AFp", "j", "@", "tSh", NULL},
   {"uC5B0p", "j", "@", "kh", NULL},
   {"uC5B1p", "j", "@", "th", NULL},
   {"uC5B2p", "j", "@", "ph", NULL},
   {"uC5B3p", "j", "@", "h", NULL},
   {"uC5B4p", "^", NULL, NULL, NULL},
   {"uC5B5p", "^", "k", NULL, NULL},
   {"uC586p", "^", "kGT", NULL, NULL},
   {"uC5B7p", "^", "k", "sh", NULL},
   {"uC5B8p", "^", "n", NULL, NULL},
   {"uC5B9p", "^", "n", "tS", NULL},
   {"uC5BAp", "^", "n", "h", NULL},
   {"uC5BBp", "^", "t", NULL, NULL},
   {"uC5BCp", "^", "l", NULL, NULL},
   {"uC5BDp", "^", "l", "k", NULL},
   {"uC5BEp", "^", "l", "m", NULL},
   {"uC5BFp", "^", "l", "p", NULL},
   {"uC5C0p", "^", "l", "sh", NULL},
   {"uC5C1p", "^", "l", "th", NULL},
   {"uC5C2p", "^", "l", "ph", NULL},
   {"uC5C3p", "^", "l", "h", NULL},
   {"uC5C4p", "^", "m", NULL, NULL},
   {"uC5C5p", "^", "p", NULL, NULL},
   {"uC5C6p", "^", "p", "sh", NULL},
   {"uC5C7p", "^", "sh", NULL, NULL},
   {"uC5C8p", "^", "s", NULL, NULL},
   {"uC5C9p", "^", "N", NULL, NULL},
   {"uC5CAp", "^", "tS", NULL, NULL},
   {"uC5CBp", "^", "tSh", NULL, NULL},
   {"uC5CCp", "^", "kh", NULL, NULL},
   {"uC5CDp", "^", "th", NULL, NULL},
   {"uC5CEp", "^", "ph", NULL, NULL},
   {"uC5CFp", "^", "h", NULL, NULL},
   {"uC5D0p", "e", NULL, NULL, NULL},
   {"uC5D1p", "e", "k", NULL, NULL},
   {"uC5D2p", "e", "kGT", NULL, NULL},
   {"uC5D3p", "e", "k", "sh", NULL},
   {"uC5D4p", "e", "n", NULL, NULL},
   {"uC5D5p", "e", "n", "tS", NULL},
   {"uC5D6p", "e", "n", "h", NULL},
   {"uC5D7p", "e", "t", NULL, NULL},
   {"uC5D8p", "e", "l", NULL, NULL},
   {"uC5D9p", "e", "l", "k", NULL},
   {"uC5DAp", "e", "l", "m", NULL},
   {"uC5DBp", "e", "l", "p", NULL},
   {"uC5DCp", "e", "l", "sh", NULL},
   {"uC5DDp", "e", "l", "th", NULL},
   {"uC5DEp", "e", "l", "ph", NULL},
   {"uC5DFp", "e", "l", "h", NULL},
   {"uC5E0p", "e", "m", NULL, NULL},
   {"uC5E1p", "e", "p", NULL, NULL},
   {"uC5E2p", "e", "p", "sh", NULL},
   {"uC5E3p", "e", "sh", NULL, NULL},
   {"uC5E4p", "e", "s", NULL, NULL},
   {"uC5E5p", "e", "N", NULL, NULL},
   {"uC5E6p", "e", "tS", NULL, NULL},
   {"uC5E7p", "e", "tSh", NULL, NULL},
   {"uC5E8p", "e", "kh", NULL, NULL},
   {"uC5E9p", "e", "th", NULL, NULL},
   {"uC5EAp", "e", "ph", NULL, NULL},
   {"uC5EBp", "e", "h", NULL, NULL},
   {"uC5ECp", "j", "^", NULL, NULL},
   {"uC5EDp", "j", "^", "k", NULL},
   {"uC5EEp", "j", "^", "kGT", NULL},
   {"uC5EFp", "j", "^", "k", NULL},
   {"uC5F0p", "j", "^", "n", NULL},
   {"uC5F1p", "j", "^", "n", NULL},
   {"uC5F2p", "j", "^", "n", NULL},
   {"uC5F3p", "j", "^", "t", NULL},
   {"uC5F4p", "j", "^", "l", NULL},
   {"uC5F5p", "j", "^", "l", NULL},
   {"uC5F6p", "j", "^", "l", NULL},
   {"uC5F7p", "j", "^", "l", NULL},
   {"uC5F8p", "j", "^", "l", NULL},
   {"uC5F9p", "j", "^", "l", NULL},
   {"uC5FAp", "j", "^", "l", NULL},
   {"uC5FBp", "j", "^", "l", NULL},
   {"uC5FCp", "j", "^", "m", NULL},
   {"uC5FDp", "j", "^", "p", NULL},
   {"uC5FEp", "j", "^", "p", NULL},
   {"uC5FFp", "j", "^", "sh", NULL},
   {"uC600p", "j", "^", "s", NULL},
   {"uC601p", "j", "^", "N", NULL},
   {"uC602p", "j", "^", "tS", NULL},
   {"uC603p", "j", "^", "tSh", NULL},
   {"uC604p", "j", "^", "kh", NULL},
   {"uC605p", "j", "^", "th", NULL},
   {"uC606p", "j", "^", "ph", NULL},
   {"uC607p", "j", "^", "h", NULL},
   {"uC608p", "j", "e", NULL, NULL},
   {"uC609p", "j", "e", "k", NULL},
   {"uC60Ap", "j", "e", "kGT", NULL},
   {"uC60Bp", "j", "e", "k", NULL},
   {"uC60Cp", "j", "e", "n", NULL},
   {"uC60Dp", "j", "e", "n", NULL},
   {"uC60Ep", "j", "e", "n", NULL},
   {"uC60Fp", "j", "e", "t", NULL},
   {"uC610p", "j", "e", "l", NULL},
   {"uC611p", "j", "e", "l", NULL},
   {"uC612p", "j", "e", "l", NULL},
   {"uC613p", "j", "e", "l", NULL},
   {"uC614p", "j", "e", "l", NULL},
   {"uC615p", "j", "e", "l", NULL},
   {"uC616p", "j", "e", "l", NULL},
   {"uC617p", "j", "e", "l", NULL},
   {"uC618p", "j", "e", "m", NULL},
   {"uC619p", "j", "e", "p", NULL},
   {"uC61Ap", "j", "e", "p", NULL},
   {"uC61Bp", "j", "e", "sh", NULL},
   {"uC61Cp", "j", "e", "s", NULL},
   {"uC61Dp", "j", "e", "N", NULL},
   {"uC61Ep", "j", "e", "tS", NULL},
   {"uC61Fp", "j", "e", "tSh", NULL},
   {"uC620p", "j", "e", "kh", NULL},
   {"uC621p", "j", "e", "th", NULL},
   {"uC622p", "j", "e", "ph", NULL},
   {"uC623p", "j", "e", "h", NULL},
   {"uC624p", "o", NULL, NULL, NULL},
   {"uC625p", "o", "k", NULL, NULL},
   {"uC626p", "o", "kGT", NULL, NULL},
   {"uC627p", "o", "k", "sh", NULL},
   {"uC628p", "o", "n", NULL, NULL},
   {"uC629p", "o", "n", "tS", NULL},
   {"uC62Ap", "o", "n", "h", NULL},
   {"uC62Bp", "o", "t", NULL, NULL},
   {"uC62Cp", "o", "l", NULL, NULL},
   {"uC62Dp", "o", "l", "k", NULL},
   {"uC62Ep", "o", "l", "m", NULL},
   {"uC62Fp", "o", "l", "p", NULL},
   {"uC630p", "o", "l", "sh", NULL},
   {"uC631p", "o", "l", "th", NULL},
   {"uC632p", "o", "l", "ph", NULL},
   {"uC633p", "o", "l", "h", NULL},
   {"uC634p", "o", "m", NULL, NULL},
   {"uC635p", "o", "p", NULL, NULL},
   {"uC636p", "o", "p", "sh", NULL},
   {"uC637p", "o", "sh", NULL, NULL},
   {"uC638p", "o", "s", NULL, NULL},
   {"uC639p", "o", "N", NULL, NULL},
   {"uC63Ap", "o", "tS", NULL, NULL},
   {"uC63Bp", "o", "tSh", NULL, NULL},
   {"uC63Cp", "o", "kh", NULL, NULL},
   {"uC63Dp", "o", "th", NULL, NULL},
   {"uC63Ep", "o", "ph", NULL, NULL},
   {"uC63Fp", "o", "h", NULL, NULL},
   {"uC640p", "w", "a", NULL, NULL},
   {"uC641p", "w", "a", "k", NULL},
   {"uC642p", "w", "a", "kGT", NULL},
   {"uC643p", "w", "a", "k", NULL},
   {"uC644p", "w", "a", "n", NULL},
   {"uC645p", "w", "a", "n", NULL},
   {"uC646p", "w", "a", "n", NULL},
   {"uC647p", "w", "a", "t", NULL},
   {"uC648p", "w", "a", "l", NULL},
   {"uC649p", "w", "a", "l", NULL},
   {"uC64Ap", "w", "a", "l", NULL},
   {"uC64Bp", "w", "a", "l", NULL},
   {"uC64Cp", "w", "a", "l", NULL},
   {"uC64Dp", "w", "a", "l", NULL},
   {"uC64Ep", "w", "a", "l", NULL},
   {"uC64Fp", "w", "a", "l", NULL},
   {"uC650p", "w", "a", "m", NULL},
   {"uC651p", "w", "a", "p", NULL},
   {"uC652p", "w", "a", "p", NULL},
   {"uC653p", "w", "a", "sh", NULL},
   {"uC654p", "w", "a", "s", NULL},
   {"uC655p", "w", "a", "N", NULL},
   {"uC656p", "w", "a", "tS", NULL},
   {"uC657p", "w", "a", "tSh", NULL},
   {"uC658p", "w", "a", "kh", NULL},
   {"uC659p", "w", "a", "th", NULL},
   {"uC65Ap", "w", "a", "ph", NULL},
   {"uC65Bp", "w", "a", "h", NULL},
   {"uC65Cp", "w", "@", NULL, NULL},
   {"uC65Dp", "w", "@", "k", NULL},
   {"uC65Ep", "w", "@", "kGT", NULL},
   {"uC65Fp", "w", "@", "k", NULL},
   {"uC660p", "w", "@", "n", NULL},
   {"uC661p", "w", "@", "n", NULL},
   {"uC662p", "w", "@", "n", NULL},
   {"uC663p", "w", "@", "t", NULL},
   {"uC664p", "w", "@", "l", NULL},
   {"uC665p", "w", "@", "l", NULL},
   {"uC666p", "w", "@", "l", NULL},
   {"uC667p", "w", "@", "l", NULL},
   {"uC668p", "w", "@", "l", NULL},
   {"uC669p", "w", "@", "l", NULL},
   {"uC66Ap", "w", "@", "l", NULL},
   {"uC66Bp", "w", "@", "l", NULL},
   {"uC66Cp", "w", "@", "m", NULL},
   {"uC66Dp", "w", "@", "p", NULL},
   {"uC66Ep", "w", "@", "p", NULL},
   {"uC66Fp", "w", "@", "sh", NULL},
   {"uC670p", "w", "@", "s", NULL},
   {"uC671p", "w", "@", "N", NULL},
   {"uC672p", "w", "@", "tS", NULL},
   {"uC673p", "w", "@", "tSh", NULL},
   {"uC674p", "w", "@", "kh", NULL},
   {"uC675p", "w", "@", "th", NULL},
   {"uC676p", "w", "@", "ph", NULL},
   {"uC677p", "w", "@", "h", NULL},
   {"uC678p", "w", "e", NULL, NULL},
   {"uC679p", "w", "e", "k", NULL},
   {"uC67Ap", "w", "e", "kGT", NULL},
   {"uC67Bp", "w", "e", "k", NULL},
   {"uC67Cp", "w", "e", "n", NULL},
   {"uC67Dp", "w", "e", "n", NULL},
   {"uC67Ep", "w", "e", "n", NULL},
   {"uC67Fp", "w", "e", "t", NULL},
   {"uC680p", "w", "e", "l", NULL},
   {"uC681p", "w", "e", "l", NULL},
   {"uC682p", "w", "e", "l", NULL},
   {"uC683p", "w", "e", "l", NULL},
   {"uC684p", "w", "e", "l", NULL},
   {"uC685p", "w", "e", "l", NULL},
   {"uC686p", "w", "e", "l", NULL},
   {"uC687p", "w", "e", "l", NULL},
   {"uC688p", "w", "e", "m", NULL},
   {"uC689p", "w", "e", "p", NULL},
   {"uC68Ap", "w", "e", "p", NULL},
   {"uC68Bp", "w", "e", "sh", NULL},
   {"uC68Cp", "w", "e", "s", NULL},
   {"uC68Dp", "w", "e", "N", NULL},
   {"uC68Ep", "w", "e", "tS", NULL},
   {"uC68Fp", "w", "e", "tSh", NULL},
   {"uC690p", "w", "e", "kh", NULL},
   {"uC691p", "w", "e", "th", NULL},
   {"uC692p", "w", "e", "ph", NULL},
   {"uC693p", "w", "e", "h", NULL},
   {"uC694p", "j", "o", NULL, NULL},
   {"uC695p", "j", "o", "k", NULL},
   {"uC696p", "j", "o", "kGT", NULL},
   {"uC697p", "j", "o", "k", NULL},
   {"uC698p", "j", "o", "n", NULL},
   {"uC699p", "j", "o", "n", NULL},
   {"uC69Ap", "j", "o", "n", NULL},
   {"uC69Bp", "j", "o", "t", NULL},
   {"uC69Cp", "j", "o", "l", NULL},
   {"uC69Dp", "j", "o", "l", NULL},
   {"uC69Ep", "j", "o", "l", NULL},
   {"uC69Fp", "j", "o", "l", NULL},
   {"uC6A0p", "j", "o", "l", NULL},
   {"uC6A1p", "j", "o", "l", NULL},
   {"uC6A2p", "j", "o", "l", NULL},
   {"uC6A3p", "j", "o", "l", NULL},
   {"uC6A4p", "j", "o", "m", NULL},
   {"uC6A5p", "j", "o", "p", NULL},
   {"uC6A6p", "j", "o", "p", NULL},
   {"uC6A7p", "j", "o", "sh", NULL},
   {"uC6A8p", "j", "o", "s", NULL},
   {"uC6A9p", "j", "o", "N", NULL},
   {"uC6AAp", "j", "o", "tS", NULL},
   {"uC6ABp", "j", "o", "tSh", NULL},
   {"uC6ACp", "j", "o", "kh", NULL},
   {"uC6ADp", "j", "o", "th", NULL},
   {"uC6AEp", "j", "o", "ph", NULL},
   {"uC6AFp", "j", "o", "h", NULL},
   {"uC6B0p", "u", NULL, NULL, NULL},
   {"uC6B1p", "u", "k", NULL, NULL},
   {"uC6B2p", "u", "kGT", NULL, NULL},
   {"uC6B3p", "u", "k", "sh", NULL},
   {"uC6B4p", "u", "n", NULL, NULL},
   {"uC6B5p", "u", "n", "tS", NULL},
   {"uC6B6p", "u", "n", "h", NULL},
   {"uC6B7p", "u", "t", NULL, NULL},
   {"uC6B8p", "u", "l", NULL, NULL},
   {"uC6B9p", "u", "l", "k", NULL},
   {"uC6BAp", "u", "l", "m", NULL},
   {"uC6BBp", "u", "l", "p", NULL},
   {"uC6BCp", "u", "l", "sh", NULL},
   {"uC6BDp", "u", "l", "th", NULL},
   {"uC6BEp", "u", "l", "ph", NULL},
   {"uC6BFp", "u", "l", "h", NULL},
   {"uC6C0p", "u", "m", NULL, NULL},
   {"uC6C1p", "u", "p", NULL, NULL},
   {"uC6C2p", "u", "p", "sh", NULL},
   {"uC6C3p", "u", "sh", NULL, NULL},
   {"uC6C4p", "u", "s", NULL, NULL},
   {"uC6C5p", "u", "N", NULL, NULL},
   {"uC6C6p", "u", "tS", NULL, NULL},
   {"uC6C7p", "u", "tSh", NULL, NULL},
   {"uC6C8p", "u", "kh", NULL, NULL},
   {"uC6C9p", "u", "th", NULL, NULL},
   {"uC6CAp", "u", "ph", NULL, NULL},
   {"uC6CBp", "u", "h", NULL, NULL},
   {"uC6CCp", "w", "^", NULL, NULL},
   {"uC6CDp", "w", "^", "k", NULL},
   {"uC6CEp", "w", "^", "kGT", NULL},
   {"uC6CFp", "w", "^", "k", NULL},
   {"uC6D0p", "w", "^", "n", NULL},
   {"uC6D1p", "w", "^", "n", NULL},
   {"uC6D2p", "w", "^", "n", NULL},
   {"uC6D3p", "w", "^", "t", NULL},
   {"uC6D4p", "w", "^", "l", NULL},
   {"uC6D5p", "w", "^", "l", NULL},
   {"uC6D6p", "w", "^", "l", NULL},
   {"uC6D7p", "w", "^", "l", NULL},
   {"uC6D8p", "w", "^", "l", NULL},
   {"uC6D9p", "w", "^", "l", NULL},
   {"uC6DAp", "w", "^", "l", NULL},
   {"uC6DBp", "w", "^", "l", NULL},
   {"uC6DCp", "w", "^", "m", NULL},
   {"uC6DDp", "w", "^", "p", NULL},
   {"uC6DEp", "w", "^", "p", NULL},
   {"uC6DFp", "w", "^", "sh", NULL},
   {"uC6E0p", "w", "^", "s", NULL},
   {"uC6E1p", "w", "^", "N", NULL},
   {"uC6E2p", "w", "^", "tS", NULL},
   {"uC6E3p", "w", "^", "tSh", NULL},
   {"uC6E4p", "w", "^", "kh", NULL},
   {"uC6E5p", "w", "^", "th", NULL},
   {"uC6E6p", "w", "^", "ph", NULL},
   {"uC6E7p", "w", "^", "h", NULL},
   {"uC6E8p", "w", "e", NULL, NULL},
   {"uC6E9p", "w", "e", "k", NULL},
   {"uC6EAp", "w", "e", "kGT", NULL},
   {"uC6EBp", "w", "e", "k", NULL},
   {"uC6ECp", "w", "e", "n", NULL},
   {"uC6EDp", "w", "e", "n", NULL},
   {"uC6EEp", "w", "e", "n", NULL},
   {"uC6EFp", "w", "e", "t", NULL},
   {"uC6F0p", "w", "e", "l", NULL},
   {"uC6F1p", "w", "e", "l", NULL},
   {"uC6F2p", "w", "e", "l", NULL},
   {"uC6F3p", "w", "e", "l", NULL},
   {"uC6F4p", "w", "e", "l", NULL},
   {"uC6F5p", "w", "e", "l", NULL},
   {"uC6F6p", "w", "e", "l", NULL},
   {"uC6F7p", "w", "e", "l", NULL},
   {"uC6F8p", "w", "e", "m", NULL},
   {"uC6F9p", "w", "e", "p", NULL},
   {"uC6FAp", "w", "e", "p", NULL},
   {"uC6FBp", "w", "e", "sh", NULL},
   {"uC6FCp", "w", "e", "s", NULL},
   {"uC6FDp", "w", "e", "N", NULL},
   {"uC6FEp", "w", "e", "tS", NULL},
   {"uC6FFp", "w", "e", "tSh", NULL},
   {"uC700p", "w", "e", "kh", NULL},
   {"uC701p", "w", "e", "th", NULL},
   {"uC702p", "w", "e", "ph", NULL},
   {"uC703p", "w", "e", "h", NULL},
   {"uC704p", "7", NULL, NULL, NULL},
   {"uC705p", "7", "k", NULL, NULL},
   {"uC706p", "7", "kGT", NULL, NULL},
   {"uC707p", "7", "k", "sh", NULL},
   {"uC708p", "7", "n", NULL, NULL},
   {"uC709p", "7", "n", "tS", NULL},
   {"uC70Ap", "7", "n", "h", NULL},
   {"uC70Bp", "7", "t", NULL, NULL},
   {"uC70Cp", "7", "l", NULL, NULL},
   {"uC70Dp", "7", "l", "k", NULL},
   {"uC70Ep", "7", "l", "m", NULL},
   {"uC70Fp", "7", "l", "p", NULL},
   {"uC710p", "7", "l", "sh", NULL},
   {"uC711p", "7", "l", "th", NULL},
   {"uC712p", "7", "l", "ph", NULL},
   {"uC713p", "7", "l", "h", NULL},
   {"uC714p", "7", "m", NULL, NULL},
   {"uC715p", "7", "p", NULL, NULL},
   {"uC716p", "7", "p", "sh", NULL},
   {"uC717p", "7", "sh", NULL, NULL},
   {"uC718p", "7", "s", NULL, NULL},
   {"uC719p", "7", "N", NULL, NULL},
   {"uC71Ap", "7", "tS", NULL, NULL},
   {"uC71Bp", "7", "tSh", NULL, NULL},
   {"uC71Cp", "7", "kh", NULL, NULL},
   {"uC71Dp", "7", "th", NULL, NULL},
   {"uC71Ep", "7", "ph", NULL, NULL},
   {"uC71Fp", "7", "h", NULL, NULL},
   {"uC720p", "j", "u", NULL, NULL},
   {"uC721p", "j", "u", "k", NULL},
   {"uC722p", "j", "u", "kGT", NULL},
   {"uC723p", "j", "u", "k", NULL},
   {"uC724p", "j", "u", "n", NULL},
   {"uC725p", "j", "u", "n", NULL},
   {"uC726p", "j", "u", "n", NULL},
   {"uC727p", "j", "u", "t", NULL},
   {"uC728p", "j", "u", "l", NULL},
   {"uC729p", "j", "u", "l", NULL},
   {"uC72Ap", "j", "u", "l", NULL},
   {"uC72Bp", "j", "u", "l", NULL},
   {"uC72Cp", "j", "u", "l", NULL},
   {"uC72Dp", "j", "u", "l", NULL},
   {"uC72Ep", "j", "u", "l", NULL},
   {"uC72Fp", "j", "u", "l", NULL},
   {"uC730p", "j", "u", "m", NULL},
   {"uC731p", "j", "u", "p", NULL},
   {"uC732p", "j", "u", "p", NULL},
   {"uC733p", "j", "u", "sh", NULL},
   {"uC734p", "j", "u", "s", NULL},
   {"uC735p", "j", "u", "N", NULL},
   {"uC736p", "j", "u", "tS", NULL},
   {"uC737p", "j", "u", "tSh", NULL},
   {"uC738p", "j", "u", "kh", NULL},
   {"uC739p", "j", "u", "th", NULL},
   {"uC73Ap", "j", "u", "ph", NULL},
   {"uC73Bp", "j", "u", "h", NULL},
   {"uC73Cp", "4", NULL, NULL, NULL},
   {"uC73Dp", "4", "k", NULL, NULL},
   {"uC73Ep", "4", "kGT", NULL, NULL},
   {"uC73Fp", "4", "k", "sh", NULL},
   {"uC740p", "4", "n", NULL, NULL},
   {"uC741p", "4", "n", "tS", NULL},
   {"uC742p", "4", "nh", NULL, NULL},
   {"uC743p", "4", "t", NULL, NULL},
   {"uC744p", "4", "l", NULL, NULL},
   {"uC745p", "4", "l", "k", NULL},
   {"uC746p", "4", "l", "m", NULL},
   {"uC747p", "4", "l", "p", NULL},
   {"uC748p", "4", "l", "sh", NULL},
   {"uC749p", "4", "l", "th", NULL},
   {"uC74Ap", "4", "l", "ph", NULL},
   {"uC74Bp", "4", "l", "h", NULL},
   {"uC74Cp", "4", "m", NULL, NULL},
   {"uC74Dp", "4", "p", NULL, NULL},
   {"uC74Ep", "4", "p", "sh", NULL},
   {"uC74Fp", "4", "sh", NULL, NULL},
   {"uC750p", "4", "s", NULL, NULL},
   {"uC751p", "4", "N", NULL, NULL},
   {"uC752p", "4", "tS", NULL, NULL},
   {"uC753p", "4", "tSh", NULL, NULL},
   {"uC754p", "4", "kh", NULL, NULL},
   {"uC755p", "4", "th", NULL, NULL},
   {"uC756p", "4", "ph", NULL, NULL},
   {"uC757p", "4", "h", NULL, NULL},
   {"uC758p", "4", "j", NULL, NULL},
   {"uC759p", "4", "j", "k", NULL},
   {"uC75Ap", "4", "j", "kGT", NULL},
   {"uC75Bp", "4", "j", "k", NULL},
   {"uC75Cp", "4", "j", "n", NULL},
   {"uC75Dp", "4", "j", "n", NULL},
   {"uC75Ep", "4", "j", "n", NULL},
   {"uC75Fp", "4", "j", "t", NULL},
   {"uC760p", "4", "j", "l", NULL},
   {"uC761p", "4", "j", "l", NULL},
   {"uC762p", "4", "j", "l", NULL},
   {"uC763p", "4", "j", "l", NULL},
   {"uC764p", "4", "j", "l", NULL},
   {"uC765p", "4", "j", "l", NULL},
   {"uC766p", "4", "j", "l", NULL},
   {"uC767p", "4", "j", "l", NULL},
   {"uC768p", "4", "j", "m", NULL},
   {"uC769p", "4", "j", "p", NULL},
   {"uC76Ap", "4", "j", "p", NULL},
   {"uC76Bp", "4", "j", "sh", NULL},
   {"uC76Cp", "4", "j", "s", NULL},
   {"uC76Dp", "4", "j", "N", NULL},
   {"uC76Ep", "4", "j", "tS", NULL},
   {"uC76Fp", "4", "j", "tSh", NULL},
   {"uC770p", "4", "j", "kh", NULL},
   {"uC771p", "4", "j", "th", NULL},
   {"uC772p", "4", "j", "ph", NULL},
   {"uC773p", "4", "j", "h", NULL},
   {"uC774p", "i", NULL, NULL, NULL},
   {"uC775p", "i", "k", NULL, NULL},
   {"uC776p", "i", "kGT", NULL, NULL},
   {"uC777p", "i", "k", "sh", NULL},
   {"uC778p", "i", "n", NULL, NULL},
   {"uC779p", "i", "n", "tS", NULL},
   {"uC77Ap", "i", "n", "h", NULL},
   {"uC77Bp", "i", "t", NULL, NULL},
   {"uC77Cp", "i", "l", NULL, NULL},
   {"uC77Dp", "i", "l", "k", NULL},
   {"uC77Ep", "i", "l", "m", NULL},
   {"uC77Fp", "i", "l", "p", NULL},
   {"uC780p", "i", "l", "sh", NULL},
   {"uC781p", "i", "l", "th", NULL},
   {"uC782p", "i", "l", "ph", NULL},
   {"uC783p", "i", "l", "h", NULL},
   {"uC784p", "i", "m", NULL, NULL},
   {"uC785p", "i", "p", NULL, NULL},
   {"uC786p", "i", "p", "sh", NULL},
   {"uC787p", "i", "sh", NULL, NULL},
   {"uC788p", "i", "s", NULL, NULL},
   {"uC789p", "i", "N", NULL, NULL},
   {"uC78Ap", "i", "tS", NULL, NULL},
   {"uC78Bp", "i", "tSh", NULL, NULL},
   {"uC78Cp", "i", "kh", NULL, NULL},
   {"uC78Dp", "i", "th", NULL, NULL},
   {"uC78Ep", "i", "ph", NULL, NULL},
   {"uC78Fp", "i", "h", NULL, NULL},
   {"uC790p", "tS", "a", NULL, NULL},
   {"uC791p", "tS", "a", "k", NULL},
   {"uC792p", "tS", "a", "kGT", NULL},
   {"uC793p", "tS", "a", "k", NULL},
   {"uC794p", "tS", "a", "n", NULL},
   {"uC795p", "tS", "a", "n", NULL},
   {"uC796p", "tS", "a", "n", NULL},
   {"uC797p", "tS", "a", "t", NULL},
   {"uC798p", "tS", "a", "l", NULL},
   {"uC799p", "tS", "a", "l", NULL},
   {"uC79Ap", "tS", "a", "l", NULL},
   {"uC79Bp", "tS", "a", "l", NULL},
   {"uC79Cp", "tS", "a", "l", NULL},
   {"uC79Dp", "tS", "a", "l", NULL},
   {"uC79Ep", "tS", "a", "l", NULL},
   {"uC79Fp", "tS", "a", "l", NULL},
   {"uC7A0p", "tS", "a", "m", NULL},
   {"uC7A1p", "tS", "a", "p", NULL},
   {"uC7A2p", "tS", "a", "p", NULL},
   {"uC7A3p", "tS", "a", "sh", NULL},
   {"uC7A4p", "tS", "a", "s", NULL},
   {"uC7A5p", "tS", "a", "N", NULL},
   {"uC7A6p", "tS", "a", "tS", NULL},
   {"uC7A7p", "tS", "a", "tSh", NULL},
   {"uC7A8p", "tS", "a", "kh", NULL},
   {"uC7A9p", "tS", "a", "th", NULL},
   {"uC7AAp", "tS", "a", "ph", NULL},
   {"uC7ABp", "tS", "a", "h", NULL},
   {"uC7ACp", "tS", "@", NULL, NULL},
   {"uC7ADp", "tS", "@", "k", NULL},
   {"uC7AEp", "tS", "@", "kGT", NULL},
   {"uC7AFp", "tS", "@", "k", NULL},
   {"uC7B0p", "tS", "@", "n", NULL},
   {"uC7B1p", "tS", "@", "n", NULL},
   {"uC7B2p", "tS", "@", "n", NULL},
   {"uC7B3p", "tS", "@", "t", NULL},
   {"uC7C4p", "tS", "@", "l", NULL},
   {"uC7B5p", "tS", "@", "l", NULL},
   {"uC7C6p", "tS", "@", "l", NULL},
   {"uC7B7p", "tS", "@", "l", NULL},
   {"uC7B8p", "tS", "@", "l", NULL},
   {"uC7B9p", "tS", "@", "l", NULL},
   {"uC7BAp", "tS", "@", "l", NULL},
   {"uC7BBp", "tS", "@", "l", NULL},
   {"uC7BCp", "tS", "@", "m", NULL},
   {"uC7BDp", "tS", "@", "p", NULL},
   {"uC7BEp", "tS", "@", "p", NULL},
   {"uC7BFp", "tS", "@", "sh", NULL},
   {"uC7C0p", "tS", "@", "s", NULL},
   {"uC7C1p", "tS", "@", "N", NULL},
   {"uC7C2p", "tS", "@", "tS", NULL},
   {"uC7C3p", "tS", "@", "tSh", NULL},
   {"uC7C4p", "tS", "@", "kh", NULL},
   {"uC7C5p", "tS", "@", "th", NULL},
   {"uC7C6p", "tS", "@", "ph", NULL},
   {"uC7C7p", "tS", "@", "h", NULL},
   {"uC7C8p", "tS", "j", "a", NULL},
   {"uC7C9p", "tS", "j", "a", NULL},
   {"uC7CAp", "tS", "j", "a", NULL},
   {"uC7CBp", "tS", "j", "a", NULL},
   {"uC7CCp", "tS", "j", "a", NULL},
   {"uC7CDp", "tS", "j", "a", NULL},
   {"uC7CEp", "tS", "j", "a", NULL},
   {"uC7CFp", "tS", "j", "a", NULL},
   {"uC7D0p", "tS", "j", "a", NULL},
   {"uC7D1p", "tS", "j", "a", NULL},
   {"uC7D2p", "tS", "j", "a", NULL},
   {"uC7D3p", "tS", "j", "a", NULL},
   {"uC7D4p", "tS", "j", "a", NULL},
   {"uC7D5p", "tS", "j", "a", NULL},
   {"uC7D6p", "tS", "j", "a", NULL},
   {"uC7D7p", "tS", "j", "a", NULL},
   {"uC7D8p", "tS", "j", "a", NULL},
   {"uC7D9p", "tS", "j", "a", NULL},
   {"uC7DAp", "tS", "j", "a", NULL},
   {"uC7DBp", "tS", "j", "a", NULL},
   {"uC7DCp", "tS", "j", "a", NULL},
   {"uC7DDp", "tS", "j", "a", NULL},
   {"uC7DEp", "tS", "j", "a", NULL},
   {"uC7DFp", "tS", "j", "a", NULL},
   {"uC7E0p", "tS", "j", "a", NULL},
   {"uC7E1p", "tS", "j", "a", NULL},
   {"uC7E2p", "tS", "j", "a", NULL},
   {"uC7E3p", "tS", "j", "a", NULL},
   {"uC7E4p", "tS", "j", "@", NULL},
   {"uC7E5p", "tS", "j", "@", NULL},
   {"uC7E6p", "tS", "j", "@", NULL},
   {"uC7E7p", "tS", "j", "@", NULL},
   {"uC7E8p", "tS", "j", "@", NULL},
   {"uC7E9p", "tS", "j", "@", NULL},
   {"uC7EAp", "tS", "j", "@", NULL},
   {"uC7EBp", "tS", "j", "@", NULL},
   {"uC7ECp", "tS", "j", "@", NULL},
   {"uC7EDp", "tS", "j", "@", NULL},
   {"uC7EEp", "tS", "j", "@", NULL},
   {"uC7EFp", "tS", "j", "@", NULL},
   {"uC7F0p", "tS", "j", "@", NULL},
   {"uC7F1p", "tS", "j", "@", NULL},
   {"uC7F2p", "tS", "j", "@", NULL},
   {"uC7F3p", "tS", "j", "@", NULL},
   {"uC7F4p", "tS", "j", "@", NULL},
   {"uC7F5p", "tS", "j", "@", NULL},
   {"uC7F6p", "tS", "j", "@", NULL},
   {"uC7F7p", "tS", "j", "@", NULL},
   {"uC7F8p", "tS", "j", "@", NULL},
   {"uC7F9p", "tS", "j", "@", NULL},
   {"uC7FAp", "tS", "j", "@", NULL},
   {"uC7FBp", "tS", "j", "@", NULL},
   {"uC7FCp", "tS", "j", "@", NULL},
   {"uC7FDp", "tS", "j", "@", NULL},
   {"uC7FEp", "tS", "j", "@", NULL},
   {"uC7FFp", "tS", "j", "@", NULL},
   {"uC800p", "tS", "^", NULL, NULL},
   {"uC801p", "tS", "^", "k", NULL},
   {"uC802p", "tS", "^", "kGT", NULL},
   {"uC803p", "tS", "^", "k", NULL},
   {"uC804p", "tS", "^", "n", NULL},
   {"uC805p", "tS", "^", "n", NULL},
   {"uC806p", "tS", "^", "n", NULL},
   {"uC807p", "tS", "^", "t", NULL},
   {"uC808p", "tS", "^", "l", NULL},
   {"uC809p", "tS", "^", "l", NULL},
   {"uC80Ap", "tS", "^", "l", NULL},
   {"uC80Bp", "tS", "^", "l", NULL},
   {"uC80Cp", "tS", "^", "l", NULL},
   {"uC80Dp", "tS", "^", "l", NULL},
   {"uC80Ep", "tS", "^", "l", NULL},
   {"uC80Fp", "tS", "^", "l", NULL},
   {"uC810p", "tS", "^", "m", NULL},
   {"uC811p", "tS", "^", "p", NULL},
   {"uC812p", "tS", "^", "p", NULL},
   {"uC813p", "tS", "^", "sh", NULL},
   {"uC814p", "tS", "^", "s", NULL},
   {"uC815p", "tS", "^", "N", NULL},
   {"uC816p", "tS", "^", "tS", NULL},
   {"uC817p", "tS", "^", "tSh", NULL},
   {"uC818p", "tS", "^", "kh", NULL},
   {"uC819p", "tS", "^", "th", NULL},
   {"uC81Ap", "tS", "^", "ph", NULL},
   {"uC81Bp", "tS", "^", "h", NULL},
   {"uC81Cp", "tS", "e", NULL, NULL},
   {"uC81Dp", "tS", "e", "k", NULL},
   {"uC81Ep", "tS", "e", "kGT", NULL},
   {"uC81Fp", "tS", "e", "k", NULL},
   {"uC820p", "tS", "e", "n", NULL},
   {"uC821p", "tS", "e", "n", NULL},
   {"uC822p", "tS", "e", "n", NULL},
   {"uC823p", "tS", "e", "t", NULL},
   {"uC824p", "tS", "e", "l", NULL},
   {"uC825p", "tS", "e", "l", NULL},
   {"uC826p", "tS", "e", "l", NULL},
   {"uC827p", "tS", "e", "l", NULL},
   {"uC828p", "tS", "e", "l", NULL},
   {"uC829p", "tS", "e", "l", NULL},
   {"uC82Ap", "tS", "e", "l", NULL},
   {"uC82Bp", "tS", "e", "l", NULL},
   {"uC82Cp", "tS", "e", "m", NULL},
   {"uC82Dp", "tS", "e", "p", NULL},
   {"uC82Ep", "tS", "e", "p", NULL},
   {"uC82Fp", "tS", "e", "sh", NULL},
   {"uC830p", "tS", "e", "s", NULL},
   {"uC831p", "tS", "e", "N", NULL},
   {"uC832p", "tS", "e", "tS", NULL},
   {"uC833p", "tS", "e", "tSh", NULL},
   {"uC834p", "tS", "e", "kh", NULL},
   {"uC835p", "tS", "e", "th", NULL},
   {"uC836p", "tS", "e", "ph", NULL},
   {"uC837p", "tS", "e", "h", NULL},
   {"uC838p", "tS", "j", "^", NULL},
   {"uC839p", "tS", "j", "^", NULL},
   {"uC83Ap", "tS", "j", "^", NULL},
   {"uC83Bp", "tS", "j", "^", NULL},
   {"uC83Cp", "tS", "j", "^", NULL},
   {"uC83Dp", "tS", "j", "^", NULL},
   {"uC83Ep", "tS", "j", "^", NULL},
   {"uC83Fp", "tS", "j", "^", NULL},
   {"uC840p", "tS", "j", "^", NULL},
   {"uC841p", "tS", "j", "^", NULL},
   {"uC842p", "tS", "j", "^", NULL},
   {"uC843p", "tS", "j", "^", NULL},
   {"uC844p", "tS", "j", "^", NULL},
   {"uC845p", "tS", "j", "^", NULL},
   {"uC846p", "tS", "j", "^", NULL},
   {"uC847p", "tS", "j", "^", NULL},
   {"uC848p", "tS", "j", "^", NULL},
   {"uC849p", "tS", "j", "^", NULL},
   {"uC84Ap", "tS", "j", "^", NULL},
   {"uC84Bp", "tS", "j", "^", NULL},
   {"uC84Cp", "tS", "j", "^", NULL},
   {"uC84Dp", "tS", "j", "^", NULL},
   {"uC84Ep", "tS", "j", "^", NULL},
   {"uC84Fp", "tS", "j", "^", NULL},
   {"uC850p", "tS", "j", "^", NULL},
   {"uC851p", "tS", "j", "^", NULL},
   {"uC852p", "tS", "j", "^", NULL},
   {"uC853p", "tS", "j", "^", NULL},
   {"uC854p", "tS", "j", "e", NULL},
   {"uC855p", "tS", "j", "e", NULL},
   {"uC856p", "tS", "j", "e", NULL},
   {"uC857p", "tS", "j", "e", NULL},
   {"uC858p", "tS", "j", "e", NULL},
   {"uC859p", "tS", "j", "e", NULL},
   {"uC85Ap", "tS", "j", "e", NULL},
   {"uC85Bp", "tS", "j", "e", NULL},
   {"uC85Cp", "tS", "j", "e", NULL},
   {"uC85Dp", "tS", "j", "e", NULL},
   {"uC85Ep", "tS", "j", "e", NULL},
   {"uC85Fp", "tS", "j", "e", NULL},
   {"uC860p", "tS", "j", "e", NULL},
   {"uC861p", "tS", "j", "e", NULL},
   {"uC862p", "tS", "j", "e", NULL},
   {"uC863p", "tS", "j", "e", NULL},
   {"uC864p", "tS", "j", "e", NULL},
   {"uC865p", "tS", "j", "e", NULL},
   {"uC866p", "tS", "j", "e", NULL},
   {"uC867p", "tS", "j", "e", NULL},
   {"uC868p", "tS", "j", "e", NULL},
   {"uC869p", "tS", "j", "e", NULL},
   {"uC86Ap", "tS", "j", "e", NULL},
   {"uC86Bp", "tS", "j", "e", NULL},
   {"uC86Cp", "tS", "j", "e", NULL},
   {"uC86Dp", "tS", "j", "e", NULL},
   {"uC86Ep", "tS", "j", "e", NULL},
   {"uC86Fp", "tS", "j", "e", NULL},
   {"uC870p", "tS", "o", NULL, NULL},
   {"uC871p", "tS", "o", "k", NULL},
   {"uC872p", "tS", "o", "kGT", NULL},
   {"uC873p", "tS", "o", "k", NULL},
   {"uC874p", "tS", "o", "n", NULL},
   {"uC875p", "tS", "o", "n", NULL},
   {"uC876p", "tS", "o", "n", NULL},
   {"uC877p", "tS", "o", "t", NULL},
   {"uC878p", "tS", "o", "l", NULL},
   {"uC879p", "tS", "o", "l", NULL},
   {"uC87Ap", "tS", "o", "l", NULL},
   {"uC87Bp", "tS", "o", "l", NULL},
   {"uC87Cp", "tS", "o", "l", NULL},
   {"uC87Dp", "tS", "o", "l", NULL},
   {"uC87Ep", "tS", "o", "l", NULL},
   {"uC87Fp", "tS", "o", "l", NULL},
   {"uC880p", "tS", "o", "m", NULL},
   {"uC881p", "tS", "o", "p", NULL},
   {"uC882p", "tS", "o", "p", NULL},
   {"uC883p", "tS", "o", "sh", NULL},
   {"uC884p", "tS", "o", "s", NULL},
   {"uC885p", "tS", "o", "N", NULL},
   {"uC886p", "tS", "o", "tS", NULL},
   {"uC887p", "tS", "o", "tSh", NULL},
   {"uC888p", "tS", "o", "kh", NULL},
   {"uC889p", "tS", "o", "th", NULL},
   {"uC88Ap", "tS", "o", "ph", NULL},
   {"uC88Bp", "tS", "o", "h", NULL},
   {"uC88Cp", "tS", "w", "a", NULL},
   {"uC88Dp", "tS", "w", "a", NULL},
   {"uC88Ep", "tS", "w", "a", NULL},
   {"uC88Fp", "tS", "w", "a", NULL},
   {"uC890p", "tS", "w", "a", NULL},
   {"uC891p", "tS", "w", "a", NULL},
   {"uC892p", "tS", "w", "a", NULL},
   {"uC893p", "tS", "w", "a", NULL},
   {"uC894p", "tS", "w", "a", NULL},
   {"uC895p", "tS", "w", "a", NULL},
   {"uC896p", "tS", "w", "a", NULL},
   {"uC897p", "tS", "w", "a", NULL},
   {"uC898p", "tS", "w", "a", NULL},
   {"uC899p", "tS", "w", "a", NULL},
   {"uC89Ap", "tS", "w", "a", NULL},
   {"uC89Bp", "tS", "w", "a", NULL},
   {"uC89Cp", "tS", "w", "a", NULL},
   {"uC89Dp", "tS", "w", "a", NULL},
   {"uC89Ep", "tS", "w", "a", NULL},
   {"uC89Fp", "tS", "w", "a", NULL},
   {"uC8A0p", "tS", "w", "a", NULL},
   {"uC8A1p", "tS", "w", "a", NULL},
   {"uC8A2p", "tS", "w", "a", NULL},
   {"uC8A3p", "tS", "w", "a", NULL},
   {"uC8A4p", "tS", "w", "a", NULL},
   {"uC8A5p", "tS", "w", "a", NULL},
   {"uC8A6p", "tS", "w", "a", NULL},
   {"uC8A7p", "tS", "w", "a", NULL},
   {"uC8A8p", "tS", "w", "@", NULL},
   {"uC8A9p", "tS", "w", "@", NULL},
   {"uC8AAp", "tS", "w", "@", NULL},
   {"uC8ABp", "tS", "w", "@", NULL},
   {"uC8ACp", "tS", "w", "@", NULL},
   {"uC8ADp", "tS", "w", "@", NULL},
   {"uC8AEp", "tS", "w", "@", NULL},
   {"uC8AFp", "tS", "w", "@", NULL},
   {"uC8B0p", "tS", "w", "@", NULL},
   {"uC8B1p", "tS", "w", "@", NULL},
   {"uC8B2p", "tS", "w", "@", NULL},
   {"uC8B3p", "tS", "w", "@", NULL},
   {"uC8B4p", "tS", "w", "@", NULL},
   {"uC8B5p", "tS", "w", "@", NULL},
   {"uC8B6p", "tS", "w", "@", NULL},
   {"uC8B7p", "tS", "w", "@", NULL},
   {"uC8B8p", "tS", "w", "@", NULL},
   {"uC8B9p", "tS", "w", "@", NULL},
   {"uC8BAp", "tS", "w", "@", NULL},
   {"uC8BBp", "tS", "w", "@", NULL},
   {"uC8BCp", "tS", "w", "@", NULL},
   {"uC8BDp", "tS", "w", "@", NULL},
   {"uC8BEp", "tS", "w", "@", NULL},
   {"uC8BFp", "tS", "w", "@", NULL},
   {"uC8C0p", "tS", "w", "@", NULL},
   {"uC8C1p", "tS", "w", "@", NULL},
   {"uC8C2p", "tS", "w", "@", NULL},
   {"uC8C3p", "tS", "w", "@", NULL},
   {"uC8C4p", "tS", "w", "e", NULL},
   {"uC8C5p", "tS", "w", "e", NULL},
   {"uC8C6p", "tS", "w", "e", NULL},
   {"uC8C7p", "tS", "w", "e", NULL},
   {"uC8C8p", "tS", "w", "e", NULL},
   {"uC8C9p", "tS", "w", "e", NULL},
   {"uC8CAp", "tS", "w", "e", NULL},
   {"uC8CBp", "tS", "w", "e", NULL},
   {"uC8CCp", "tS", "w", "e", NULL},
   {"uC8CDp", "tS", "w", "e", NULL},
   {"uC8CEp", "tS", "w", "e", NULL},
   {"uC8CFp", "tS", "w", "e", NULL},
   {"uC8D0p", "tS", "w", "e", NULL},
   {"uC8D1p", "tS", "w", "e", NULL},
   {"uC8D2p", "tS", "w", "e", NULL},
   {"uC8D3p", "tS", "w", "e", NULL},
   {"uC8D4p", "tS", "w", "e", NULL},
   {"uC8D5p", "tS", "w", "e", NULL},
   {"uC8D6p", "tS", "w", "e", NULL},
   {"uC8D7p", "tS", "w", "e", NULL},
   {"uC8D8p", "tS", "w", "e", NULL},
   {"uC8D9p", "tS", "w", "e", NULL},
   {"uC8DAp", "tS", "w", "e", NULL},
   {"uC8DBp", "tS", "w", "e", NULL},
   {"uC8DCp", "tS", "w", "e", NULL},
   {"uC8DDp", "tS", "w", "e", NULL},
   {"uC8DEp", "tS", "w", "e", NULL},
   {"uC8DFp", "tS", "w", "e", NULL},
   {"uC8E0p", "tS", "j", "o", NULL},
   {"uC8E1p", "tS", "j", "o", NULL},
   {"uC8E2p", "tS", "j", "o", NULL},
   {"uC8E3p", "tS", "j", "o", NULL},
   {"uC8E4p", "tS", "j", "o", NULL},
   {"uC8E5p", "tS", "j", "o", NULL},
   {"uC8E6p", "tS", "j", "o", NULL},
   {"uC8E7p", "tS", "j", "o", NULL},
   {"uC8E8p", "tS", "j", "o", NULL},
   {"uC8E9p", "tS", "j", "o", NULL},
   {"uC8EAp", "tS", "j", "o", NULL},
   {"uC8EBp", "tS", "j", "o", NULL},
   {"uC8ECp", "tS", "j", "o", NULL},
   {"uC8EDp", "tS", "j", "o", NULL},
   {"uC8EEp", "tS", "j", "o", NULL},
   {"uC8EFp", "tS", "j", "o", NULL},
   {"uC8F0p", "tS", "j", "o", NULL},
   {"uC8F1p", "tS", "j", "o", NULL},
   {"uC8F2p", "tS", "j", "o", NULL},
   {"uC8F3p", "tS", "j", "o", NULL},
   {"uC8F4p", "tS", "j", "o", NULL},
   {"uC8F5p", "tS", "j", "o", NULL},
   {"uC8F6p", "tS", "j", "o", NULL},
   {"uC8F7p", "tS", "j", "o", NULL},
   {"uC8F8p", "tS", "j", "o", NULL},
   {"uC8F9p", "tS", "j", "o", NULL},
   {"uC8FAp", "tS", "j", "o", NULL},
   {"uC8FBp", "tS", "j", "o", NULL},
   {"uC8FCp", "tS", "u", NULL, NULL},
   {"uC8FDp", "tS", "u", "k", NULL},
   {"uC8FEp", "tS", "u", "kGT", NULL},
   {"uC8FFp", "tS", "u", "k", NULL},
   {"uC900p", "tS", "u", "n", NULL},
   {"uC901p", "tS", "u", "n", NULL},
   {"uC902p", "tS", "u", "n", NULL},
   {"uC903p", "tS", "u", "t", NULL},
   {"uC904p", "tS", "u", "l", NULL},
   {"uC905p", "tS", "u", "l", NULL},
   {"uC906p", "tS", "u", "l", NULL},
   {"uC907p", "tS", "u", "l", NULL},
   {"uC908p", "tS", "u", "l", NULL},
   {"uC909p", "tS", "u", "l", NULL},
   {"uC90Ap", "tS", "u", "l", NULL},
   {"uC90Bp", "tS", "u", "l", NULL},
   {"uC90Cp", "tS", "u", "m", NULL},
   {"uC90Dp", "tS", "u", "p", NULL},
   {"uC90Ep", "tS", "u", "p", NULL},
   {"uC90Fp", "tS", "u", "sh", NULL},
   {"uC910p", "tS", "u", "s", NULL},
   {"uC911p", "tS", "u", "N", NULL},
   {"uC912p", "tS", "u", "tS", NULL},
   {"uC913p", "tS", "u", "tSh", NULL},
   {"uC914p", "tS", "u", "kh", NULL},
   {"uC915p", "tS", "u", "th", NULL},
   {"uC916p", "tS", "u", "ph", NULL},
   {"uC917p", "tS", "u", "h", NULL},
   {"uC918p", "tS", "w", "^", NULL},
   {"uC919p", "tS", "w", "^", NULL},
   {"uC91Ap", "tS", "w", "^", NULL},
   {"uC91Bp", "tS", "w", "^", NULL},
   {"uC91Cp", "tS", "w", "^", NULL},
   {"uC91Dp", "tS", "w", "^", NULL},
   {"uC91Ep", "tS", "w", "^", NULL},
   {"uC91Fp", "tS", "w", "^", NULL},
   {"uC920p", "tS", "w", "^", NULL},
   {"uC921p", "tS", "w", "^", NULL},
   {"uC922p", "tS", "w", "^", NULL},
   {"uC923p", "tS", "w", "^", NULL},
   {"uC924p", "tS", "w", "^", NULL},
   {"uC925p", "tS", "w", "^", NULL},
   {"uC926p", "tS", "w", "^", NULL},
   {"uC927p", "tS", "w", "^", NULL},
   {"uC928p", "tS", "w", "^", NULL},
   {"uC929p", "tS", "w", "^", NULL},
   {"uC92Ap", "tS", "w", "^", NULL},
   {"uC92Bp", "tS", "w", "^", NULL},
   {"uC92Cp", "tS", "w", "^", NULL},
   {"uC92Dp", "tS", "w", "^", NULL},
   {"uC92Ep", "tS", "w", "^", NULL},
   {"uC92Fp", "tS", "w", "^", NULL},
   {"uC930p", "tS", "w", "^", NULL},
   {"uC931p", "tS", "w", "^", NULL},
   {"uC932p", "tS", "w", "^", NULL},
   {"uC933p", "tS", "w", "^", NULL},
   {"uC934p", "tS", "w", "e", NULL},
   {"uC935p", "tS", "w", "e", NULL},
   {"uC936p", "tS", "w", "e", NULL},
   {"uC937p", "tS", "w", "e", NULL},
   {"uC938p", "tS", "w", "e", NULL},
   {"uC939p", "tS", "w", "e", NULL},
   {"uC93Ap", "tS", "w", "e", NULL},
   {"uC93Bp", "tS", "w", "e", NULL},
   {"uC93Cp", "tS", "w", "e", NULL},
   {"uC93Dp", "tS", "w", "e", NULL},
   {"uC93Ep", "tS", "w", "e", NULL},
   {"uC93Fp", "tS", "w", "e", NULL},
   {"uC940p", "tS", "w", "e", NULL},
   {"uC941p", "tS", "w", "e", NULL},
   {"uC942p", "tS", "w", "e", NULL},
   {"uC943p", "tS", "w", "e", NULL},
   {"uC944p", "tS", "w", "e", NULL},
   {"uC945p", "tS", "w", "e", NULL},
   {"uC946p", "tS", "w", "e", NULL},
   {"uC947p", "tS", "w", "e", NULL},
   {"uC948p", "tS", "w", "e", NULL},
   {"uC949p", "tS", "w", "e", NULL},
   {"uC94Ap", "tS", "w", "e", NULL},
   {"uC94Bp", "tS", "w", "e", NULL},
   {"uC94Cp", "tS", "w", "e", NULL},
   {"uC94Dp", "tS", "w", "e", NULL},
   {"uC94Ep", "tS", "w", "e", NULL},
   {"uC94Fp", "tS", "w", "e", NULL},
   {"uC950p", "tS", "7", NULL, NULL},
   {"uC951p", "tS", "7", "k", NULL},
   {"uC952p", "tS", "7", "kGT", NULL},
   {"uC953p", "tS", "7", "k", NULL},
   {"uC954p", "tS", "7", "n", NULL},
   {"uC955p", "tS", "7", "n", NULL},
   {"uC956p", "tS", "7", "n", NULL},
   {"uC957p", "tS", "7", "t", NULL},
   {"uC958p", "tS", "7", "l", NULL},
   {"uC959p", "tS", "7", "l", NULL},
   {"uC95Ap", "tS", "7", "l", NULL},
   {"uC95Bp", "tS", "7", "l", NULL},
   {"uC95Cp", "tS", "7", "l", NULL},
   {"uC95Dp", "tS", "7", "l", NULL},
   {"uC95Ep", "tS", "7", "l", NULL},
   {"uC95Fp", "tS", "7", "l", NULL},
   {"uC960p", "tS", "7", "m", NULL},
   {"uC961p", "tS", "7", "p", NULL},
   {"uC962p", "tS", "7", "p", NULL},
   {"uC963p", "tS", "7", "sh", NULL},
   {"uC964p", "tS", "7", "s", NULL},
   {"uC965p", "tS", "7", "N", NULL},
   {"uC966p", "tS", "7", "tS", NULL},
   {"uC967p", "tS", "7", "tSh", NULL},
   {"uC968p", "tS", "7", "kh", NULL},
   {"uC969p", "tS", "7", "th", NULL},
   {"uC96Ap", "tS", "7", "ph", NULL},
   {"uC96Bp", "tS", "7", "h", NULL},
   {"uC96Cp", "tS", "j", "u", NULL},
   {"uC96Dp", "tS", "j", "u", NULL},
   {"uC96Ep", "tS", "j", "u", NULL},
   {"uC96Fp", "tS", "j", "u", NULL},
   {"uC970p", "tS", "j", "u", NULL},
   {"uC971p", "tS", "j", "u", NULL},
   {"uC972p", "tS", "j", "u", NULL},
   {"uC973p", "tS", "j", "u", NULL},
   {"uC974p", "tS", "j", "u", NULL},
   {"uC975p", "tS", "j", "u", NULL},
   {"uC976p", "tS", "j", "u", NULL},
   {"uC977p", "tS", "j", "u", NULL},
   {"uC978p", "tS", "j", "u", NULL},
   {"uC979p", "tS", "j", "u", NULL},
   {"uC97Ap", "tS", "j", "u", NULL},
   {"uC97Bp", "tS", "j", "u", NULL},
   {"uC97Cp", "tS", "j", "u", NULL},
   {"uC97Dp", "tS", "j", "u", NULL},
   {"uC97Ep", "tS", "j", "u", NULL},
   {"uC97Fp", "tS", "j", "u", NULL},
   {"uC980p", "tS", "j", "u", NULL},
   {"uC981p", "tS", "j", "u", NULL},
   {"uC982p", "tS", "j", "u", NULL},
   {"uC983p", "tS", "j", "u", NULL},
   {"uC984p", "tS", "j", "u", NULL},
   {"uC985p", "tS", "j", "u", NULL},
   {"uC986p", "tS", "j", "u", NULL},
   {"uC987p", "tS", "j", "u", NULL},
   {"uC988p", "tS", "4", NULL, NULL},
   {"uC989p", "tS", "4", "k", NULL},
   {"uC98Ap", "tS", "4", "kGT", NULL},
   {"uC98Bp", "tS", "4", "k", NULL},
   {"uC98Cp", "tS", "4", "n", NULL},
   {"uC98Dp", "tS", "4", "n", NULL},
   {"uC98Ep", "tS", "4", "n", NULL},
   {"uC98Fp", "tS", "4", "t", NULL},
   {"uC990p", "tS", "4", "l", NULL},
   {"uC991p", "tS", "4", "l", NULL},
   {"uC992p", "tS", "4", "l", NULL},
   {"uC993p", "tS", "4", "l", NULL},
   {"uC994p", "tS", "4", "l", NULL},
   {"uC995p", "tS", "4", "l", NULL},
   {"uC996p", "tS", "4", "l", NULL},
   {"uC997p", "tS", "4", "l", NULL},
   {"uC998p", "tS", "4", "m", NULL},
   {"uC999p", "tS", "4", "p", NULL},
   {"uC99Ap", "tS", "4", "p", NULL},
   {"uC99Bp", "tS", "4", "sh", NULL},
   {"uC99Cp", "tS", "4", "s", NULL},
   {"uC99Dp", "tS", "4", "N", NULL},
   {"uC99Ep", "tS", "4", "tS", NULL},
   {"uC99Fp", "tS", "4", "tSh", NULL},
   {"uC9A0p", "tS", "4", "kh", NULL},
   {"uC9A1p", "tS", "4", "th", NULL},
   {"uC9A2p", "tS", "4", "ph", NULL},
   {"uC9A3p", "tS", "4", "h", NULL},
   {"uC9A4p", "tS", "4", "j", NULL},
   {"uC9A5p", "tS", "4", "j", NULL},
   {"uC9A6p", "tS", "4", "j", NULL},
   {"uC9A7p", "tS", "4", "j", NULL},
   {"uC9A8p", "tS", "4", "j", NULL},
   {"uC9A9p", "tS", "4", "j", NULL},
   {"uC9AAp", "tS", "4", "j", NULL},
   {"uC9ABp", "tS", "4", "j", NULL},
   {"uC9ACp", "tS", "4", "j", NULL},
   {"uC9ADp", "tS", "4", "j", NULL},
   {"uC9AEp", "tS", "4", "j", NULL},
   {"uC9AFp", "tS", "4", "j", NULL},
   {"uC9B0p", "tS", "4", "j", NULL},
   {"uC9B1p", "tS", "4", "j", NULL},
   {"uC9B2p", "tS", "4", "j", NULL},
   {"uC9B3p", "tS", "4", "j", NULL},
   {"uC9B4p", "tS", "4", "j", NULL},
   {"uC9B5p", "tS", "4", "j", NULL},
   {"uC9B6p", "tS", "4", "j", NULL},
   {"uC9B7p", "tS", "4", "j", NULL},
   {"uC9B8p", "tS", "4", "j", NULL},
   {"uC9B9p", "tS", "4", "j", NULL},
   {"uC9BAp", "tS", "4", "j", NULL},
   {"uC9BBp", "tS", "4", "j", NULL},
   {"uC9BCp", "tS", "4", "j", NULL},
   {"uC9BDp", "tS", "4", "j", NULL},
   {"uC9BEp", "tS", "4", "j", NULL},
   {"uC9BFp", "tS", "4", "j", NULL},
   {"uC9C0p", "tS", "i", NULL, NULL},
   {"uC9C1p", "tS", "i", "k", NULL},
   {"uC9C2p", "tS", "i", "kGT", NULL},
   {"uC9C3p", "tS", "i", "k", NULL},
   {"uC9C4p", "tS", "i", "n", NULL},
   {"uC9C5p", "tS", "i", "n", NULL},
   {"uC9C6p", "tS", "i", "n", NULL},
   {"uC9C7p", "tS", "i", "t", NULL},
   {"uC9C8p", "tS", "i", "l", NULL},
   {"uC9C9p", "tS", "i", "l", NULL},
   {"uC9CAp", "tS", "i", "l", NULL},
   {"uC9CBp", "tS", "i", "l", NULL},
   {"uC9CCp", "tS", "i", "l", NULL},
   {"uC9CDp", "tS", "i", "l", NULL},
   {"uC9CEp", "tS", "i", "l", NULL},
   {"uC9CFp", "tS", "i", "l", NULL},
   {"uC9D0p", "tS", "i", "m", NULL},
   {"uC9D1p", "tS", "i", "p", NULL},
   {"uC9D2p", "tS", "i", "p", NULL},
   {"uC9D3p", "tS", "i", "sh", NULL},
   {"uC9D4p", "tS", "i", "s", NULL},
   {"uC9D5p", "tS", "i", "N", NULL},
   {"uC9D6p", "tS", "i", "tS", NULL},
   {"uC9D7p", "tS", "i", "tSh", NULL},
   {"uC9D8p", "tS", "i", "kh", NULL},
   {"uC9D9p", "tS", "i", "th", NULL},
   {"uC9DAp", "tS", "i", "ph", NULL},
   {"uC9DBp", "tS", "i", "h", NULL},
   {"uC9DCp", "tSGT", "a", NULL, NULL},
   {"uC9DDp", "tSGT", "a", "k", NULL},
   {"uC9DEp", "tSGT", "a", "kGT", NULL},
   {"uC9DFp", "tSGT", "a", "k", NULL},
   {"uC9E0p", "tSGT", "a", "n", NULL},
   {"uC9E1p", "tSGT", "a", "n", NULL},
   {"uC9E2p", "tSGT", "a", "n", NULL},
   {"uC9E3p", "tSGT", "a", "t", NULL},
   {"uC9E4p", "tSGT", "a", "l", NULL},
   {"uC9E5p", "tSGT", "a", "l", NULL},
   {"uC9E6p", "tSGT", "a", "l", NULL},
   {"uC9E7p", "tSGT", "a", "l", NULL},
   {"uC9E8p", "tSGT", "a", "l", NULL},
   {"uC9E9p", "tSGT", "a", "l", NULL},
   {"uC9EAp", "tSGT", "a", "l", NULL},
   {"uC9EBp", "tSGT", "a", "l", NULL},
   {"uC9ECp", "tSGT", "a", "m", NULL},
   {"uC9EDp", "tSGT", "a", "p", NULL},
   {"uC9EEp", "tSGT", "a", "p", NULL},
   {"uC9EFp", "tSGT", "a", "sh", NULL},
   {"uC9F0p", "tSGT", "a", "s", NULL},
   {"uC9F1p", "tSGT", "a", "N", NULL},
   {"uC9F2p", "tSGT", "a", "tS", NULL},
   {"uC9F3p", "tSGT", "a", "tSh", NULL},
   {"uC9F4p", "tSGT", "a", "kh", NULL},
   {"uC9F5p", "tSGT", "a", "th", NULL},
   {"uC9F6p", "tSGT", "a", "ph", NULL},
   {"uC9F7p", "tSGT", "a", "h", NULL},
   {"uC9F8p", "tSGT", "@", NULL, NULL},
   {"uC9F9p", "tSGT", "@", "k", NULL},
   {"uC9FAp", "tSGT", "@", "kGT", NULL},
   {"uC9FBp", "tSGT", "@", "k", NULL},
   {"uC9FCp", "tSGT", "@", "n", NULL},
   {"uC9FDp", "tSGT", "@", "n", NULL},
   {"uC9FEp", "tSGT", "@", "n", NULL},
   {"uC9FFp", "tSGT", "@", "t", NULL},
   {"uCA00p", "tSGT", "@", "l", NULL},
   {"uCA01p", "tSGT", "@", "l", NULL},
   {"uCA02p", "tSGT", "@", "l", NULL},
   {"uCA03p", "tSGT", "@", "l", NULL},
   {"uCA04p", "tSGT", "@", "l", NULL},
   {"uCA05p", "tSGT", "@", "l", NULL},
   {"uCA06p", "tSGT", "@", "l", NULL},
   {"uCA07p", "tSGT", "@", "l", NULL},
   {"uCA08p", "tSGT", "@", "m", NULL},
   {"uCA09p", "tSGT", "@", "p", NULL},
   {"uCA0Ap", "tSGT", "@", "p", NULL},
   {"uCA0Bp", "tSGT", "@", "sh", NULL},
   {"uCA0Cp", "tSGT", "@", "s", NULL},
   {"uCA0Dp", "tSGT", "@", "N", NULL},
   {"uCA0Ep", "tSGT", "@", "tS", NULL},
   {"uCA0Fp", "tSGT", "@", "tSh", NULL},
   {"uCA10p", "tSGT", "@", "kh", NULL},
   {"uCA11p", "tSGT", "@", "th", NULL},
   {"uCA12p", "tSGT", "@", "ph", NULL},
   {"uCA13p", "tSGT", "@", "h", NULL},
   {"uCA14p", "tSGT", "j", "a", NULL},
   {"uCA15p", "tSGT", "j", "a", NULL},
   {"uCA16p", "tSGT", "j", "a", NULL},
   {"uCA17p", "tSGT", "j", "a", NULL},
   {"uCA18p", "tSGT", "j", "a", NULL},
   {"uCA19p", "tSGT", "j", "a", NULL},
   {"uCA1Ap", "tSGT", "j", "a", NULL},
   {"uCA1Bp", "tSGT", "j", "a", NULL},
   {"uCA1Cp", "tSGT", "j", "a", NULL},
   {"uCA1Dp", "tSGT", "j", "a", NULL},
   {"uCA1Ep", "tSGT", "j", "a", NULL},
   {"uCA1Fp", "tSGT", "j", "a", NULL},
   {"uCA20p", "tSGT", "j", "a", NULL},
   {"uCA21p", "tSGT", "j", "a", NULL},
   {"uCA22p", "tSGT", "j", "a", NULL},
   {"uCA23p", "tSGT", "j", "a", NULL},
   {"uCA24p", "tSGT", "j", "a", NULL},
   {"uCA25p", "tSGT", "j", "a", NULL},
   {"uCA26p", "tSGT", "j", "a", NULL},
   {"uCA27p", "tSGT", "j", "a", NULL},
   {"uCA28p", "tSGT", "j", "a", NULL},
   {"uCA29p", "tSGT", "j", "a", NULL},
   {"uCA2Ap", "tSGT", "j", "a", NULL},
   {"uCA2Bp", "tSGT", "j", "a", NULL},
   {"uCA2Cp", "tSGT", "j", "a", NULL},
   {"uCA2Dp", "tSGT", "j", "a", NULL},
   {"uCA2Ep", "tSGT", "j", "a", NULL},
   {"uCA2Fp", "tSGT", "j", "a", NULL},
   {"uCA30p", "tSGT", "j", "@", NULL},
   {"uCA31p", "tSGT", "j", "@", NULL},
   {"uCA32p", "tSGT", "j", "@", NULL},
   {"uCA33p", "tSGT", "j", "@", NULL},
   {"uCA34p", "tSGT", "j", "@", NULL},
   {"uCA35p", "tSGT", "j", "@", NULL},
   {"uCA36p", "tSGT", "j", "@", NULL},
   {"uCA37p", "tSGT", "j", "@", NULL},
   {"uCA38p", "tSGT", "j", "@", NULL},
   {"uCA39p", "tSGT", "j", "@", NULL},
   {"uCA3Ap", "tSGT", "j", "@", NULL},
   {"uCA3Bp", "tSGT", "j", "@", NULL},
   {"uCA3Cp", "tSGT", "j", "@", NULL},
   {"uCA3Dp", "tSGT", "j", "@", NULL},
   {"uCA3Ep", "tSGT", "j", "@", NULL},
   {"uCA3Fp", "tSGT", "j", "@", NULL},
   {"uCA40p", "tSGT", "j", "@", NULL},
   {"uCA41p", "tSGT", "j", "@", NULL},
   {"uCA42p", "tSGT", "j", "@", NULL},
   {"uCA43p", "tSGT", "j", "@", NULL},
   {"uCA44p", "tSGT", "j", "@", NULL},
   {"uCA45p", "tSGT", "j", "@", NULL},
   {"uCA46p", "tSGT", "j", "@", NULL},
   {"uCA47p", "tSGT", "j", "@", NULL},
   {"uCA48p", "tSGT", "j", "@", NULL},
   {"uCA49p", "tSGT", "j", "@", NULL},
   {"uCA4Ap", "tSGT", "j", "@", NULL},
   {"uCA4Bp", "tSGT", "j", "@", NULL},
   {"uCA4Cp", "tSGT", "^", NULL, NULL},
   {"uCA4Dp", "tSGT", "^", "k", NULL},
   {"uCA4Ep", "tSGT", "^", "kGT", NULL},
   {"uCA4Fp", "tSGT", "^", "k", NULL},
   {"uCA50p", "tSGT", "^", "n", NULL},
   {"uCA51p", "tSGT", "^", "n", NULL},
   {"uCA52p", "tSGT", "^", "n", NULL},
   {"uCA53p", "tSGT", "^", "t", NULL},
   {"uCA54p", "tSGT", "^", "l", NULL},
   {"uCA55p", "tSGT", "^", "l", NULL},
   {"uCA56p", "tSGT", "^", "l", NULL},
   {"uCA57p", "tSGT", "^", "l", NULL},
   {"uCA58p", "tSGT", "^", "l", NULL},
   {"uCA59p", "tSGT", "^", "l", NULL},
   {"uCA5Ap", "tSGT", "^", "l", NULL},
   {"uCA5Bp", "tSGT", "^", "l", NULL},
   {"uCA5Cp", "tSGT", "^", "m", NULL},
   {"uCA5Dp", "tSGT", "^", "p", NULL},
   {"uCA5Ep", "tSGT", "^", "p", NULL},
   {"uCA5Fp", "tSGT", "^", "sh", NULL},
   {"uCA60p", "tSGT", "^", "s", NULL},
   {"uCA61p", "tSGT", "^", "N", NULL},
   {"uCA62p", "tSGT", "^", "tS", NULL},
   {"uCA63p", "tSGT", "^", "tSh", NULL},
   {"uCA64p", "tSGT", "^", "kh", NULL},
   {"uCA65p", "tSGT", "^", "th", NULL},
   {"uCA66p", "tSGT", "^", "ph", NULL},
   {"uCA67p", "tSGT", "^", "h", NULL},
   {"uCA68p", "tSGT", "e", NULL, NULL},
   {"uCA69p", "tSGT", "e", "k", NULL},
   {"uCA6Ap", "tSGT", "e", "kGT", NULL},
   {"uCA6Bp", "tSGT", "e", "k", NULL},
   {"uCA6Cp", "tSGT", "e", "n", NULL},
   {"uCA6Dp", "tSGT", "e", "n", NULL},
   {"uCA6Ep", "tSGT", "e", "n", NULL},
   {"uCA6Fp", "tSGT", "e", "t", NULL},
   {"uCA70p", "tSGT", "e", "l", NULL},
   {"uCA71p", "tSGT", "e", "l", NULL},
   {"uCA72p", "tSGT", "e", "l", NULL},
   {"uCA73p", "tSGT", "e", "l", NULL},
   {"uCA74p", "tSGT", "e", "l", NULL},
   {"uCA75p", "tSGT", "e", "l", NULL},
   {"uCA76p", "tSGT", "e", "l", NULL},
   {"uCA77p", "tSGT", "e", "l", NULL},
   {"uCA78p", "tSGT", "e", "m", NULL},
   {"uCA79p", "tSGT", "e", "p", NULL},
   {"uCA7Ap", "tSGT", "e", "p", NULL},
   {"uCA7Bp", "tSGT", "e", "sh", NULL},
   {"uCA7Cp", "tSGT", "e", "s", NULL},
   {"uCA7Dp", "tSGT", "e", "N", NULL},
   {"uCA7Ep", "tSGT", "e", "tS", NULL},
   {"uCA7Fp", "tSGT", "e", "tSh", NULL},
   {"uCA80p", "tSGT", "e", "kh", NULL},
   {"uCA81p", "tSGT", "e", "th", NULL},
   {"uCA82p", "tSGT", "e", "ph", NULL},
   {"uCA83p", "tSGT", "e", "h", NULL},
   {"uCA84p", "tSGT", "j", "^", NULL},
   {"uCA85p", "tSGT", "j", "^", NULL},
   {"uCA86p", "tSGT", "j", "^", NULL},
   {"uCA87p", "tSGT", "j", "^", NULL},
   {"uCA88p", "tSGT", "j", "^", NULL},
   {"uCA89p", "tSGT", "j", "^", NULL},
   {"uCA8Ap", "tSGT", "j", "^", NULL},
   {"uCA8Bp", "tSGT", "j", "^", NULL},
   {"uCA8Cp", "tSGT", "j", "^", NULL},
   {"uCA8Dp", "tSGT", "j", "^", NULL},
   {"uCA8Ep", "tSGT", "j", "^", NULL},
   {"uCA8Fp", "tSGT", "j", "^", NULL},
   {"uCA90p", "tSGT", "j", "^", NULL},
   {"uCA91p", "tSGT", "j", "^", NULL},
   {"uCA92p", "tSGT", "j", "^", NULL},
   {"uCA93p", "tSGT", "j", "^", NULL},
   {"uCA94p", "tSGT", "j", "^", NULL},
   {"uCA95p", "tSGT", "j", "^", NULL},
   {"uCA96p", "tSGT", "j", "^", NULL},
   {"uCA97p", "tSGT", "j", "^", NULL},
   {"uCA98p", "tSGT", "j", "^", NULL},
   {"uCA99p", "tSGT", "j", "^", NULL},
   {"uCA9Ap", "tSGT", "j", "^", NULL},
   {"uCA9Bp", "tSGT", "j", "^", NULL},
   {"uCA9Cp", "tSGT", "j", "^", NULL},
   {"uCA9Dp", "tSGT", "j", "^", NULL},
   {"uCA9Ep", "tSGT", "j", "^", NULL},
   {"uCA9Fp", "tSGT", "j", "^", NULL},
   {"uCAA0p", "tSGT", "j", "e", NULL},
   {"uCAA1p", "tSGT", "j", "e", NULL},
   {"uCAA2p", "tSGT", "j", "e", NULL},
   {"uCAA3p", "tSGT", "j", "e", NULL},
   {"uCAA4p", "tSGT", "j", "e", NULL},
   {"uCAA5p", "tSGT", "j", "e", NULL},
   {"uCAA6p", "tSGT", "j", "e", NULL},
   {"uCAA7p", "tSGT", "j", "e", NULL},
   {"uCAA8p", "tSGT", "j", "e", NULL},
   {"uCAA9p", "tSGT", "j", "e", NULL},
   {"uCAAAp", "tSGT", "j", "e", NULL},
   {"uCAABp", "tSGT", "j", "e", NULL},
   {"uCAACp", "tSGT", "j", "e", NULL},
   {"uCAADp", "tSGT", "j", "e", NULL},
   {"uCAAEp", "tSGT", "j", "e", NULL},
   {"uCAAFp", "tSGT", "j", "e", NULL},
   {"uCAB0p", "tSGT", "j", "e", NULL},
   {"uCAB1p", "tSGT", "j", "e", NULL},
   {"uCAB2p", "tSGT", "j", "e", NULL},
   {"uCAB3p", "tSGT", "j", "e", NULL},
   {"uCAB4p", "tSGT", "j", "e", NULL},
   {"uCAB5p", "tSGT", "j", "e", NULL},
   {"uCAB6p", "tSGT", "j", "e", NULL},
   {"uCAB7p", "tSGT", "j", "e", NULL},
   {"uCAB8p", "tSGT", "j", "e", NULL},
   {"uCAB9p", "tSGT", "j", "e", NULL},
   {"uCABAp", "tSGT", "j", "e", NULL},
   {"uCABBp", "tSGT", "j", "e", NULL},
   {"uCABCp", "tSGT", "o", NULL, NULL},
   {"uCABDp", "tSGT", "o", "k", NULL},
   {"uCABEp", "tSGT", "o", "kGT", NULL},
   {"uCABFp", "tSGT", "o", "k", NULL},
   {"uCAC0p", "tSGT", "o", "n", NULL},
   {"uCAC1p", "tSGT", "o", "n", NULL},
   {"uCAC2p", "tSGT", "o", "n", NULL},
   {"uCAC3p", "tSGT", "o", "t", NULL},
   {"uCAC4p", "tSGT", "o", "l", NULL},
   {"uCAC5p", "tSGT", "o", "l", NULL},
   {"uCAC6p", "tSGT", "o", "l", NULL},
   {"uCAC7p", "tSGT", "o", "l", NULL},
   {"uCAC8p", "tSGT", "o", "l", NULL},
   {"uCAC9p", "tSGT", "o", "l", NULL},
   {"uCACAp", "tSGT", "o", "l", NULL},
   {"uCACBp", "tSGT", "o", "l", NULL},
   {"uCACCp", "tSGT", "o", "m", NULL},
   {"uCACDp", "tSGT", "o", "p", NULL},
   {"uCACEp", "tSGT", "o", "p", NULL},
   {"uCACFp", "tSGT", "o", "sh", NULL},
   {"uCAC0p", "tSGT", "o", "s", NULL},
   {"uCAD1p", "tSGT", "o", "N", NULL},
   {"uCAD2p", "tSGT", "o", "tS", NULL},
   {"uCAD3p", "tSGT", "o", "tSh", NULL},
   {"uCAD4p", "tSGT", "o", "kh", NULL},
   {"uCAD5p", "tSGT", "o", "th", NULL},
   {"uCAD6p", "tSGT", "o", "ph", NULL},
   {"uCAD7p", "tSGT", "o", "h", NULL},
   {"uCAD8p", "tSGT", "w", "a", NULL},
   {"uCAD9p", "tSGT", "w", "a", NULL},
   {"uCADAp", "tSGT", "w", "a", NULL},
   {"uCADBp", "tSGT", "w", "a", NULL},
   {"uCADCp", "tSGT", "w", "a", NULL},
   {"uCADDp", "tSGT", "w", "a", NULL},
   {"uCADEp", "tSGT", "w", "a", NULL},
   {"uCADFp", "tSGT", "w", "a", NULL},
   {"uCAE0p", "tSGT", "w", "a", NULL},
   {"uCAE1p", "tSGT", "w", "a", NULL},
   {"uCAE2p", "tSGT", "w", "a", NULL},
   {"uCAE3p", "tSGT", "w", "a", NULL},
   {"uCAE4p", "tSGT", "w", "a", NULL},
   {"uCAE5p", "tSGT", "w", "a", NULL},
   {"uCAE6p", "tSGT", "w", "a", NULL},
   {"uCAE7p", "tSGT", "w", "a", NULL},
   {"uCAE8p", "tSGT", "w", "a", NULL},
   {"uCAE9p", "tSGT", "w", "a", NULL},
   {"uCAEAp", "tSGT", "w", "a", NULL},
   {"uCAEBp", "tSGT", "w", "a", NULL},
   {"uCAECp", "tSGT", "w", "a", NULL},
   {"uCAEDp", "tSGT", "w", "a", NULL},
   {"uCAEEp", "tSGT", "w", "a", NULL},
   {"uCAEFp", "tSGT", "w", "a", NULL},
   {"uCAF0p", "tSGT", "w", "a", NULL},
   {"uCAF1p", "tSGT", "w", "a", NULL},
   {"uCAF2p", "tSGT", "w", "a", NULL},
   {"uCAF3p", "tSGT", "w", "a", NULL},
   {"uCAF4p", "tSGT", "w", "@", NULL},
   {"uCAF5p", "tSGT", "w", "@", NULL},
   {"uCAF6p", "tSGT", "w", "@", NULL},
   {"uCAF7p", "tSGT", "w", "@", NULL},
   {"uCAF8p", "tSGT", "w", "@", NULL},
   {"uCAF9p", "tSGT", "w", "@", NULL},
   {"uCAFAp", "tSGT", "w", "@", NULL},
   {"uCAFBp", "tSGT", "w", "@", NULL},
   {"uCAFCp", "tSGT", "w", "@", NULL},
   {"uCAFDp", "tSGT", "w", "@", NULL},
   {"uCAFEp", "tSGT", "w", "@", NULL},
   {"uCAFFp", "tSGT", "w", "@", NULL},
   {"uCB00p", "tSGT", "w", "@", NULL},
   {"uCB0Ap", "tSGT", "w", "@", NULL},
   {"uCB02p", "tSGT", "w", "@", NULL},
   {"uCB03p", "tSGT", "w", "@", NULL},
   {"uCB04p", "tSGT", "w", "@", NULL},
   {"uCB05p", "tSGT", "w", "@", NULL},
   {"uCB06p", "tSGT", "w", "@", NULL},
   {"uCB07p", "tSGT", "w", "@", NULL},
   {"uCB08p", "tSGT", "w", "@", NULL},
   {"uCB09p", "tSGT", "w", "@", NULL},
   {"uCB0Ap", "tSGT", "w", "@", NULL},
   {"uCB0Bp", "tSGT", "w", "@", NULL},
   {"uCB0Cp", "tSGT", "w", "@", NULL},
   {"uCB0Dp", "tSGT", "w", "@", NULL},
   {"uCB0Ep", "tSGT", "w", "@", NULL},
   {"uCB0Fp", "tSGT", "w", "@", NULL},
   {"uCB10p", "tSGT", "w", "e", NULL},
   {"uCB11p", "tSGT", "w", "e", NULL},
   {"uCB12p", "tSGT", "w", "e", NULL},
   {"uCB13p", "tSGT", "w", "e", NULL},
   {"uCB14p", "tSGT", "w", "e", NULL},
   {"uCB15p", "tSGT", "w", "e", NULL},
   {"uCB16p", "tSGT", "w", "e", NULL},
   {"uCB17p", "tSGT", "w", "e", NULL},
   {"uCB18p", "tSGT", "w", "e", NULL},
   {"uCB19p", "tSGT", "w", "e", NULL},
   {"uCB1Ap", "tSGT", "w", "e", NULL},
   {"uCB1Bp", "tSGT", "w", "e", NULL},
   {"uCB1Cp", "tSGT", "w", "e", NULL},
   {"uCB1Dp", "tSGT", "w", "e", NULL},
   {"uCB1Ep", "tSGT", "w", "e", NULL},
   {"uCB1Fp", "tSGT", "w", "e", NULL},
   {"uCB20p", "tSGT", "w", "e", NULL},
   {"uCB21p", "tSGT", "w", "e", NULL},
   {"uCB22p", "tSGT", "w", "e", NULL},
   {"uCB23p", "tSGT", "w", "e", NULL},
   {"uCB24p", "tSGT", "w", "e", NULL},
   {"uCB25p", "tSGT", "w", "e", NULL},
   {"uCB26p", "tSGT", "w", "e", NULL},
   {"uCB27p", "tSGT", "w", "e", NULL},
   {"uCB28p", "tSGT", "w", "e", NULL},
   {"uCB29p", "tSGT", "w", "e", NULL},
   {"uCB2Ap", "tSGT", "w", "e", NULL},
   {"uCB2Bp", "tSGT", "w", "e", NULL},
   {"uCB2Cp", "tSGT", "j", "o", NULL},
   {"uCB2Dp", "tSGT", "j", "o", NULL},
   {"uCB2Ep", "tSGT", "j", "o", NULL},
   {"uCB2Fp", "tSGT", "j", "o", NULL},
   {"uCB30p", "tSGT", "j", "o", NULL},
   {"uCB31p", "tSGT", "j", "o", NULL},
   {"uCB32p", "tSGT", "j", "o", NULL},
   {"uCB33p", "tSGT", "j", "o", NULL},
   {"uCB34p", "tSGT", "j", "o", NULL},
   {"uCB35p", "tSGT", "j", "o", NULL},
   {"uCB36p", "tSGT", "j", "o", NULL},
   {"uCB37p", "tSGT", "j", "o", NULL},
   {"uCB38p", "tSGT", "j", "o", NULL},
   {"uCB39p", "tSGT", "j", "o", NULL},
   {"uCB3Ap", "tSGT", "j", "o", NULL},
   {"uCB3Bp", "tSGT", "j", "o", NULL},
   {"uCB3Cp", "tSGT", "j", "o", NULL},
   {"uCB3Dp", "tSGT", "j", "o", NULL},
   {"uCB3Ep", "tSGT", "j", "o", NULL},
   {"uCB3Fp", "tSGT", "j", "o", NULL},
   {"uCB40p", "tSGT", "j", "o", NULL},
   {"uCB41p", "tSGT", "j", "o", NULL},
   {"uCB42p", "tSGT", "j", "o", NULL},
   {"uCB43p", "tSGT", "j", "o", NULL},
   {"uCB44p", "tSGT", "j", "o", NULL},
   {"uCB45p", "tSGT", "j", "o", NULL},
   {"uCB46p", "tSGT", "j", "o", NULL},
   {"uCB47p", "tSGT", "j", "o", NULL},
   {"uCB48p", "tSGT", "u", NULL, NULL},
   {"uCB49p", "tSGT", "u", "k", NULL},
   {"uCB4Ap", "tSGT", "u", "kGT", NULL},
   {"uCB4Bp", "tSGT", "u", "k", NULL},
   {"uCB4Cp", "tSGT", "u", "n", NULL},
   {"uCB4Dp", "tSGT", "u", "n", NULL},
   {"uCB4Ep", "tSGT", "u", "n", NULL},
   {"uCB4Fp", "tSGT", "u", "t", NULL},
   {"uCB50p", "tSGT", "u", "l", NULL},
   {"uCB51p", "tSGT", "u", "l", NULL},
   {"uCB52p", "tSGT", "u", "l", NULL},
   {"uCB53p", "tSGT", "u", "l", NULL},
   {"uCB54p", "tSGT", "u", "l", NULL},
   {"uCB55p", "tSGT", "u", "l", NULL},
   {"uCB56p", "tSGT", "u", "l", NULL},
   {"uCB57p", "tSGT", "u", "l", NULL},
   {"uCB58p", "tSGT", "u", "m", NULL},
   {"uCB59p", "tSGT", "u", "p", NULL},
   {"uCB5Ap", "tSGT", "u", "p", NULL},
   {"uCB5Bp", "tSGT", "u", "sh", NULL},
   {"uCB5Cp", "tSGT", "u", "s", NULL},
   {"uCB5Dp", "tSGT", "u", "N", NULL},
   {"uCB5Ep", "tSGT", "u", "tS", NULL},
   {"uCB5Fp", "tSGT", "u", "tSh", NULL},
   {"uCB60p", "tSGT", "u", "kh", NULL},
   {"uCB61p", "tSGT", "u", "th", NULL},
   {"uCB62p", "tSGT", "u", "ph", NULL},
   {"uCB63p", "tSGT", "u", "h", NULL},
   {"uCB64p", "tSGT", "w", "^", NULL},
   {"uCB65p", "tSGT", "w", "^", NULL},
   {"uCB66p", "tSGT", "w", "^", NULL},
   {"uCB67p", "tSGT", "w", "^", NULL},
   {"uCB68p", "tSGT", "w", "^", NULL},
   {"uCB69p", "tSGT", "w", "^", NULL},
   {"uCB6Ap", "tSGT", "w", "^", NULL},
   {"uCB6Bp", "tSGT", "w", "^", NULL},
   {"uCB6Cp", "tSGT", "w", "^", NULL},
   {"uCB6Dp", "tSGT", "w", "^", NULL},
   {"uCB6Ep", "tSGT", "w", "^", NULL},
   {"uCB6Fp", "tSGT", "w", "^", NULL},
   {"uCB70p", "tSGT", "w", "^", NULL},
   {"uCB71p", "tSGT", "w", "^", NULL},
   {"uCB72p", "tSGT", "w", "^", NULL},
   {"uCB73p", "tSGT", "w", "^", NULL},
   {"uCB74p", "tSGT", "w", "^", NULL},
   {"uCB75p", "tSGT", "w", "^", NULL},
   {"uCB76p", "tSGT", "w", "^", NULL},
   {"uCB77p", "tSGT", "w", "^", NULL},
   {"uCB78p", "tSGT", "w", "^", NULL},
   {"uCB79p", "tSGT", "w", "^", NULL},
   {"uCB7Ap", "tSGT", "w", "^", NULL},
   {"uCB7Bp", "tSGT", "w", "^", NULL},
   {"uCB7Cp", "tSGT", "w", "^", NULL},
   {"uCB7Dp", "tSGT", "w", "^", NULL},
   {"uCB7Ep", "tSGT", "w", "^", NULL},
   {"uCB7Fp", "tSGT", "w", "^", NULL},
   {"uCB80p", "tSGT", "w", "e", NULL},
   {"uCB81p", "tSGT", "w", "e", NULL},
   {"uCB82p", "tSGT", "w", "e", NULL},
   {"uCB83p", "tSGT", "w", "e", NULL},
   {"uCB84p", "tSGT", "w", "e", NULL},
   {"uCB85p", "tSGT", "w", "e", NULL},
   {"uCB86p", "tSGT", "w", "e", NULL},
   {"uCB87p", "tSGT", "w", "e", NULL},
   {"uCB88p", "tSGT", "w", "e", NULL},
   {"uCB89p", "tSGT", "w", "e", NULL},
   {"uCB8Ap", "tSGT", "w", "e", NULL},
   {"uCB8Bp", "tSGT", "w", "e", NULL},
   {"uCB8Cp", "tSGT", "w", "e", NULL},
   {"uCB8Dp", "tSGT", "w", "e", NULL},
   {"uCB8Ep", "tSGT", "w", "e", NULL},
   {"uCB8Fp", "tSGT", "w", "e", NULL},
   {"uCB90p", "tSGT", "w", "e", NULL},
   {"uCB91p", "tSGT", "w", "e", NULL},
   {"uCB92p", "tSGT", "w", "e", NULL},
   {"uCB93p", "tSGT", "w", "e", NULL},
   {"uCB94p", "tSGT", "w", "e", NULL},
   {"uCB95p", "tSGT", "w", "e", NULL},
   {"uCB96p", "tSGT", "w", "e", NULL},
   {"uCB97p", "tSGT", "w", "e", NULL},
   {"uCB98p", "tSGT", "w", "e", NULL},
   {"uCB99p", "tSGT", "w", "e", NULL},
   {"uCB9Ap", "tSGT", "w", "e", NULL},
   {"uCB9Bp", "tSGT", "w", "e", NULL},
   {"uCB9Cp", "tSGT", "7", NULL, NULL},
   {"uCB9Dp", "tSGT", "7", "k", NULL},
   {"uCB9Ep", "tSGT", "7", "kGT", NULL},
   {"uCB9Fp", "tSGT", "7", "k", NULL},
   {"uCBA0p", "tSGT", "7", "n", NULL},
   {"uCBA1p", "tSGT", "7", "n", NULL},
   {"uCBA2p", "tSGT", "7", "n", NULL},
   {"uCBA3p", "tSGT", "7", "t", NULL},
   {"uCBA4p", "tSGT", "7", "l", NULL},
   {"uCBA5p", "tSGT", "7", "l", NULL},
   {"uCBA6p", "tSGT", "7", "l", NULL},
   {"uCBA7p", "tSGT", "7", "l", NULL},
   {"uCBA8p", "tSGT", "7", "l", NULL},
   {"uCBA9p", "tSGT", "7", "l", NULL},
   {"uCBAAp", "tSGT", "7", "l", NULL},
   {"uCBABp", "tSGT", "7", "l", NULL},
   {"uCBACp", "tSGT", "7", "m", NULL},
   {"uCBADp", "tSGT", "7", "p", NULL},
   {"uCBAEp", "tSGT", "7", "p", NULL},
   {"uCBAFp", "tSGT", "7", "sh", NULL},
   {"uCBB0p", "tSGT", "7", "s", NULL},
   {"uCBB1p", "tSGT", "7", "N", NULL},
   {"uCBB2p", "tSGT", "7", "tS", NULL},
   {"uCBB3p", "tSGT", "7", "tSh", NULL},
   {"uCBB4p", "tSGT", "7", "kh", NULL},
   {"uCBB5p", "tSGT", "7", "th", NULL},
   {"uCBB6p", "tSGT", "7", "ph", NULL},
   {"uCBB7p", "tSGT", "7", "h", NULL},
   {"uCBB8p", "tSGT", "j", "u", NULL},
   {"uCBB9p", "tSGT", "j", "u", NULL},
   {"uCBBAp", "tSGT", "j", "u", NULL},
   {"uCBBBp", "tSGT", "j", "u", NULL},
   {"uCBBCp", "tSGT", "j", "u", NULL},
   {"uCBBDp", "tSGT", "j", "u", NULL},
   {"uCBBEp", "tSGT", "j", "u", NULL},
   {"uCBBFp", "tSGT", "j", "u", NULL},
   {"uCBC0p", "tSGT", "j", "u", NULL},
   {"uCBC1p", "tSGT", "j", "u", NULL},
   {"uCBC2p", "tSGT", "j", "u", NULL},
   {"uCBC3p", "tSGT", "j", "u", NULL},
   {"uCBC4p", "tSGT", "j", "u", NULL},
   {"uCBC5p", "tSGT", "j", "u", NULL},
   {"uCBC6p", "tSGT", "j", "u", NULL},
   {"uCBC7p", "tSGT", "j", "u", NULL},
   {"uCBC8p", "tSGT", "j", "u", NULL},
   {"uCBC9p", "tSGT", "j", "u", NULL},
   {"uCBCAp", "tSGT", "j", "u", NULL},
   {"uCBCBp", "tSGT", "j", "u", NULL},
   {"uCBCCp", "tSGT", "j", "u", NULL},
   {"uCBCDp", "tSGT", "j", "u", NULL},
   {"uCBCEp", "tSGT", "j", "u", NULL},
   {"uCBCFp", "tSGT", "j", "u", NULL},
   {"uCBD0p", "tSGT", "j", "u", NULL},
   {"uCBD1p", "tSGT", "j", "u", NULL},
   {"uCBD2p", "tSGT", "j", "u", NULL},
   {"uCBD3p", "tSGT", "j", "u", NULL},
   {"uCBD4p", "tSGT", "4", NULL, NULL},
   {"uCBD5p", "tSGT", "4", "k", NULL},
   {"uCBD6p", "tSGT", "4", "kGT", NULL},
   {"uCBD7p", "tSGT", "4", "k", NULL},
   {"uCBD8p", "tSGT", "4", "n", NULL},
   {"uCBD9p", "tSGT", "4", "n", NULL},
   {"uCBDAp", "tSGT", "4", "n", NULL},
   {"uCBDBp", "tSGT", "4", "t", NULL},
   {"uCBDCp", "tSGT", "4", "l", NULL},
   {"uCBDDp", "tSGT", "4", "l", NULL},
   {"uCBDEp", "tSGT", "4", "l", NULL},
   {"uCBDFp", "tSGT", "4", "l", NULL},
   {"uCBE0p", "tSGT", "4", "l", NULL},
   {"uCBE1p", "tSGT", "4", "l", NULL},
   {"uCBE2p", "tSGT", "4", "l", NULL},
   {"uCBE3p", "tSGT", "4", "l", NULL},
   {"uCBE4p", "tSGT", "4", "m", NULL},
   {"uCBE5p", "tSGT", "4", "p", NULL},
   {"uCBE6p", "tSGT", "4", "p", NULL},
   {"uCBE7p", "tSGT", "4", "sh", NULL},
   {"uCBE8p", "tSGT", "4", "s", NULL},
   {"uCBE9p", "tSGT", "4", "N", NULL},
   {"uCBEAp", "tSGT", "4", "tS", NULL},
   {"uCBEBp", "tSGT", "4", "tSh", NULL},
   {"uCBECp", "tSGT", "4", "kh", NULL},
   {"uCBEDp", "tSGT", "4", "th", NULL},
   {"uCBEEp", "tSGT", "4", "ph", NULL},
   {"uCBEFp", "tSGT", "4", "h", NULL},
   {"uCBF0p", "tSGT", "4", "j", NULL},
   {"uCBF1p", "tSGT", "4", "j", NULL},
   {"uCBF2p", "tSGT", "4", "j", NULL},
   {"uCBF3p", "tSGT", "4", "j", NULL},
   {"uCBF4p", "tSGT", "4", "j", NULL},
   {"uCBF5p", "tSGT", "4", "j", NULL},
   {"uCBF6p", "tSGT", "4", "j", NULL},
   {"uCBF7p", "tSGT", "4", "j", NULL},
   {"uCBF8p", "tSGT", "4", "j", NULL},
   {"uCBF9p", "tSGT", "4", "j", NULL},
   {"uCBFAp", "tSGT", "4", "j", NULL},
   {"uCBFBp", "tSGT", "4", "j", NULL},
   {"uCBFCp", "tSGT", "4", "j", NULL},
   {"uCBFDp", "tSGT", "4", "j", NULL},
   {"uCBFEp", "tSGT", "4", "j", NULL},
   {"uCBFFp", "tSGT", "4", "j", NULL},
   {"uCC00p", "tSGT", "4", "j", NULL},
   {"uCC01p", "tSGT", "4", "j", NULL},
   {"uCC02p", "tSGT", "4", "j", NULL},
   {"uCC03p", "tSGT", "4", "j", NULL},
   {"uCC04p", "tSGT", "4", "j", NULL},
   {"uCC05p", "tSGT", "4", "j", NULL},
   {"uCC06p", "tSGT", "4", "j", NULL},
   {"uCC07p", "tSGT", "4", "j", NULL},
   {"uCC08p", "tSGT", "4", "j", NULL},
   {"uCC09p", "tSGT", "4", "j", NULL},
   {"uCC0Ap", "tSGT", "4", "j", NULL},
   {"uCC0Bp", "tSGT", "4", "j", NULL},
   {"uCC0Cp", "tSGT", "i", NULL, NULL},
   {"uCC0Dp", "tSGT", "i", "k", NULL},
   {"uCC0Ep", "tSGT", "i", "kGT", NULL},
   {"uCC0Fp", "tSGT", "i", "k", NULL},
   {"uCC10p", "tSGT", "i", "n", NULL},
   {"uCC11p", "tSGT", "i", "n", NULL},
   {"uCC12p", "tSGT", "i", "n", NULL},
   {"uCC13p", "tSGT", "i", "t", NULL},
   {"uCC14p", "tSGT", "i", "l", NULL},
   {"uCC15p", "tSGT", "i", "l", NULL},
   {"uCC16p", "tSGT", "i", "l", NULL},
   {"uCC17p", "tSGT", "i", "l", NULL},
   {"uCC18p", "tSGT", "i", "l", NULL},
   {"uCC19p", "tSGT", "i", "l", NULL},
   {"uCC1Ap", "tSGT", "i", "l", NULL},
   {"uCC1Bp", "tSGT", "i", "l", NULL},
   {"uCC1Cp", "tSGT", "i", "m", NULL},
   {"uCC1Dp", "tSGT", "i", "p", NULL},
   {"uCC1Ep", "tSGT", "i", "p", NULL},
   {"uCC1Fp", "tSGT", "i", "sh", NULL},
   {"uCC20p", "tSGT", "i", "s", NULL},
   {"uCC21p", "tSGT", "i", "N", NULL},
   {"uCC22p", "tSGT", "i", "tS", NULL},
   {"uCC23p", "tSGT", "i", "tSh", NULL},
   {"uCC24p", "tSGT", "i", "kh", NULL},
   {"uCC25p", "tSGT", "i", "th", NULL},
   {"uCC26p", "tSGT", "i", "ph", NULL},
   {"uCC27p", "tSGT", "i", "h", NULL},
   {"uCC28p", "tSh", "a", NULL, NULL},
   {"uCC29p", "tSh", "a", "k", NULL},
   {"uCC2Ap", "tSh", "a", "kGT", NULL},
   {"uCC2Bp", "tSh", "a", "k", NULL},
   {"uCC2Cp", "tSh", "a", "n", NULL},
   {"uCC2Dp", "tSh", "a", "n", NULL},
   {"uCC2Ep", "tSh", "a", "n", NULL},
   {"uCC2Fp", "tSh", "a", "t", NULL},
   {"uCC30p", "tSh", "a", "l", NULL},
   {"uCC31p", "tSh", "a", "l", NULL},
   {"uCC32p", "tSh", "a", "l", NULL},
   {"uCC33p", "tSh", "a", "l", NULL},
   {"uCC34p", "tSh", "a", "l", NULL},
   {"uCC35p", "tSh", "a", "l", NULL},
   {"uCC36p", "tSh", "a", "l", NULL},
   {"uCC37p", "tSh", "a", "l", NULL},
   {"uCC38p", "tSh", "a", "m", NULL},
   {"uCC39p", "tSh", "a", "p", NULL},
   {"uCC3Ap", "tSh", "a", "p", NULL},
   {"uCC3Bp", "tSh", "a", "sh", NULL},
   {"uCC3Cp", "tSh", "a", "s", NULL},
   {"uCC3Dp", "tSh", "a", "N", NULL},
   {"uCC3Ep", "tSh", "a", "tS", NULL},
   {"uCC3Fp", "tSh", "a", "tSh", NULL},
   {"uCC40p", "tSh", "a", "kh", NULL},
   {"uCC41p", "tSh", "a", "th", NULL},
   {"uCC42p", "tSh", "a", "ph", NULL},
   {"uCC43p", "tSh", "a", "h", NULL},
   {"uCC44p", "tSh", "@", NULL, NULL},
   {"uCC45p", "tSh", "@", "k", NULL},
   {"uCC46p", "tSh", "@", "kGT", NULL},
   {"uCC47p", "tSh", "@", "k", NULL},
   {"uCC48p", "tSh", "@", "n", NULL},
   {"uCC49p", "tSh", "@", "n", NULL},
   {"uCC4Ap", "tSh", "@", "n", NULL},
   {"uCC4Bp", "tSh", "@", "t", NULL},
   {"uCC4Cp", "tSh", "@", "l", NULL},
   {"uCC4Dp", "tSh", "@", "l", NULL},
   {"uCC4Ep", "tSh", "@", "l", NULL},
   {"uCC4Fp", "tSh", "@", "l", NULL},
   {"uCC50p", "tSh", "@", "l", NULL},
   {"uCC51p", "tSh", "@", "l", NULL},
   {"uCC52p", "tSh", "@", "l", NULL},
   {"uCC53p", "tSh", "@", "l", NULL},
   {"uCC54p", "tSh", "@", "m", NULL},
   {"uCC55p", "tSh", "@", "p", NULL},
   {"uCC56p", "tSh", "@", "p", NULL},
   {"uCC57p", "tSh", "@", "sh", NULL},
   {"uCC58p", "tSh", "@", "s", NULL},
   {"uCC59p", "tSh", "@", "N", NULL},
   {"uCC5Ap", "tSh", "@", "tS", NULL},
   {"uCC5Bp", "tSh", "@", "tSh", NULL},
   {"uCC5Cp", "tSh", "@", "kh", NULL},
   {"uCC5Dp", "tSh", "@", "th", NULL},
   {"uCC5Ep", "tSh", "@", "ph", NULL},
   {"uCC5Fp", "tSh", "@", "h", NULL},
   {"uCC60p", "tSh", "j", "a", NULL},
   {"uCC61p", "tSh", "j", "a", NULL},
   {"uCC62p", "tSh", "j", "a", NULL},
   {"uCC63p", "tSh", "j", "a", NULL},
   {"uCC64p", "tSh", "j", "a", NULL},
   {"uCC65p", "tSh", "j", "a", NULL},
   {"uCC66p", "tSh", "j", "a", NULL},
   {"uCC67p", "tSh", "j", "a", NULL},
   {"uCC68p", "tSh", "j", "a", NULL},
   {"uCC69p", "tSh", "j", "a", NULL},
   {"uCC6Ap", "tSh", "j", "a", NULL},
   {"uCC6Bp", "tSh", "j", "a", NULL},
   {"uCC6Cp", "tSh", "j", "a", NULL},
   {"uCC6Dp", "tSh", "j", "a", NULL},
   {"uCC6Ep", "tSh", "j", "a", NULL},
   {"uCC6Fp", "tSh", "j", "a", NULL},
   {"uCC70p", "tSh", "j", "a", NULL},
   {"uCC71p", "tSh", "j", "a", NULL},
   {"uCC72p", "tSh", "j", "a", NULL},
   {"uCC73p", "tSh", "j", "a", NULL},
   {"uCC74p", "tSh", "j", "a", NULL},
   {"uCC75p", "tSh", "j", "a", NULL},
   {"uCC76p", "tSh", "j", "a", NULL},
   {"uCC77p", "tSh", "j", "a", NULL},
   {"uCC78p", "tSh", "j", "a", NULL},
   {"uCC79p", "tSh", "j", "a", NULL},
   {"uCC7Ap", "tSh", "j", "a", NULL},
   {"uCC7Bp", "tSh", "j", "a", NULL},
   {"uCC7Cp", "tSh", "j", "@", NULL},
   {"uCC7Dp", "tSh", "j", "@", NULL},
   {"uCC7Ep", "tSh", "j", "@", NULL},
   {"uCC7Fp", "tSh", "j", "@", NULL},
   {"uCC80p", "tSh", "j", "@", NULL},
   {"uCC81p", "tSh", "j", "@", NULL},
   {"uCC82p", "tSh", "j", "@", NULL},
   {"uCC83p", "tSh", "j", "@", NULL},
   {"uCC84p", "tSh", "j", "@", NULL},
   {"uCC85p", "tSh", "j", "@", NULL},
   {"uCC86p", "tSh", "j", "@", NULL},
   {"uCC87p", "tSh", "j", "@", NULL},
   {"uCC88p", "tSh", "j", "@", NULL},
   {"uCC89p", "tSh", "j", "@", NULL},
   {"uCC8Ap", "tSh", "j", "@", NULL},
   {"uCC8Bp", "tSh", "j", "@", NULL},
   {"uCC8Cp", "tSh", "j", "@", NULL},
   {"uCC8Dp", "tSh", "j", "@", NULL},
   {"uCC8Ep", "tSh", "j", "@", NULL},
   {"uCC8Fp", "tSh", "j", "@", NULL},
   {"uCC90p", "tSh", "j", "@", NULL},
   {"uCC91p", "tSh", "j", "@", NULL},
   {"uCC92p", "tSh", "j", "@", NULL},
   {"uCC93p", "tSh", "j", "@", NULL},
   {"uCC94p", "tSh", "j", "@", NULL},
   {"uCC95p", "tSh", "j", "@", NULL},
   {"uCC96p", "tSh", "j", "@", NULL},
   {"uCC97p", "tSh", "j", "@", NULL},
   {"uCC98p", "tSh", "^", NULL, NULL},
   {"uCC99p", "tSh", "^", "k", NULL},
   {"uCC9Ap", "tSh", "^", "kGT", NULL},
   {"uCC9Bp", "tSh", "^", "k", NULL},
   {"uCC9Cp", "tSh", "^", "n", NULL},
   {"uCC9Dp", "tSh", "^", "n", NULL},
   {"uCC9Ep", "tSh", "^", "n", NULL},
   {"uCC9Fp", "tSh", "^", "t", NULL},
   {"uCCA0p", "tSh", "^", "l", NULL},
   {"uCCA1p", "tSh", "^", "l", NULL},
   {"uCCA2p", "tSh", "^", "l", NULL},
   {"uCCA3p", "tSh", "^", "l", NULL},
   {"uCCA4p", "tSh", "^", "l", NULL},
   {"uCCA5p", "tSh", "^", "l", NULL},
   {"uCCA6p", "tSh", "^", "l", NULL},
   {"uCCA7p", "tSh", "^", "l", NULL},
   {"uCCA8p", "tSh", "^", "m", NULL},
   {"uCCA9p", "tSh", "^", "p", NULL},
   {"uCCAAp", "tSh", "^", "p", NULL},
   {"uCCABp", "tSh", "^", "sh", NULL},
   {"uCCACp", "tSh", "^", "s", NULL},
   {"uCCADp", "tSh", "^", "N", NULL},
   {"uCCAEp", "tSh", "^", "tS", NULL},
   {"uCCAFp", "tSh", "^", "tSh", NULL},
   {"uCCB0p", "tSh", "^", "kh", NULL},
   {"uCCB1p", "tSh", "^", "th", NULL},
   {"uCCB2p", "tSh", "^", "ph", NULL},
   {"uCCB3p", "tSh", "^", "h", NULL},
   {"uCCB4p", "tSh", "e", NULL, NULL},
   {"uCCB5p", "tSh", "e", "k", NULL},
   {"uCCB6p", "tSh", "e", "kGT", NULL},
   {"uCCB7p", "tSh", "e", "k", NULL},
   {"uCCB8p", "tSh", "e", "n", NULL},
   {"uCCB9p", "tSh", "e", "n", NULL},
   {"uCCBAp", "tSh", "e", "n", NULL},
   {"uCCBBp", "tSh", "e", "t", NULL},
   {"uCCBCp", "tSh", "e", "l", NULL},
   {"uCCBDp", "tSh", "e", "l", NULL},
   {"uCCBEp", "tSh", "e", "l", NULL},
   {"uCCBFp", "tSh", "e", "l", NULL},
   {"uCCC0p", "tSh", "e", "l", NULL},
   {"uCCC1p", "tSh", "e", "l", NULL},
   {"uCCC2p", "tSh", "e", "l", NULL},
   {"uCCC3p", "tSh", "e", "l", NULL},
   {"uCCC4p", "tSh", "e", "m", NULL},
   {"uCCC5p", "tSh", "e", "p", NULL},
   {"uCCC6p", "tSh", "e", "p", NULL},
   {"uCCC7p", "tSh", "e", "sh", NULL},
   {"uCCC8p", "tSh", "e", "s", NULL},
   {"uCCC9p", "tSh", "e", "N", NULL},
   {"uCCCAp", "tSh", "e", "tS", NULL},
   {"uCCCBp", "tSh", "e", "tSh", NULL},
   {"uCCCCp", "tSh", "e", "kh", NULL},
   {"uCCCDp", "tSh", "e", "th", NULL},
   {"uCCCEp", "tSh", "e", "ph", NULL},
   {"uCCCFp", "tSh", "e", "h", NULL},
   {"uCCD0p", "tSh", "j", "^", NULL},
   {"uCCD1p", "tSh", "j", "^", NULL},
   {"uCCD2p", "tSh", "j", "^", NULL},
   {"uCCD3p", "tSh", "j", "^", NULL},
   {"uCCD4p", "tSh", "j", "^", NULL},
   {"uCCD5p", "tSh", "j", "^", NULL},
   {"uCCD6p", "tSh", "j", "^", NULL},
   {"uCCD7p", "tSh", "j", "^", NULL},
   {"uCCD8p", "tSh", "j", "^", NULL},
   {"uCCD9p", "tSh", "j", "^", NULL},
   {"uCCDAp", "tSh", "j", "^", NULL},
   {"uCCDBp", "tSh", "j", "^", NULL},
   {"uCCDCp", "tSh", "j", "^", NULL},
   {"uCCDDp", "tSh", "j", "^", NULL},
   {"uCCDEp", "tSh", "j", "^", NULL},
   {"uCCDFp", "tSh", "j", "^", NULL},
   {"uCCE0p", "tSh", "j", "^", NULL},
   {"uCCE1p", "tSh", "j", "^", NULL},
   {"uCCE2p", "tSh", "j", "^", NULL},
   {"uCCE3p", "tSh", "j", "^", NULL},
   {"uCCE4p", "tSh", "j", "^", NULL},
   {"uCCE5p", "tSh", "j", "^", NULL},
   {"uCCE6p", "tSh", "j", "^", NULL},
   {"uCCE7p", "tSh", "j", "^", NULL},
   {"uCCE8p", "tSh", "j", "^", NULL},
   {"uCCE9p", "tSh", "j", "^", NULL},
   {"uCCEAp", "tSh", "j", "^", NULL},
   {"uCCEBp", "tSh", "j", "^", NULL},
   {"uCCECp", "tSh", "j", "e", NULL},
   {"uCCEDp", "tSh", "j", "e", NULL},
   {"uCCEEp", "tSh", "j", "e", NULL},
   {"uCCEFp", "tSh", "j", "e", NULL},
   {"uCCF0p", "tSh", "j", "e", NULL},
   {"uCCF1p", "tSh", "j", "e", NULL},
   {"uCCF2p", "tSh", "j", "e", NULL},
   {"uCCF3p", "tSh", "j", "e", NULL},
   {"uCCF4p", "tSh", "j", "e", NULL},
   {"uCCF5p", "tSh", "j", "e", NULL},
   {"uCCF6p", "tSh", "j", "e", NULL},
   {"uCCF7p", "tSh", "j", "e", NULL},
   {"uCCF8p", "tSh", "j", "e", NULL},
   {"uCCF9p", "tSh", "j", "e", NULL},
   {"uCCFAp", "tSh", "j", "e", NULL},
   {"uCCFBp", "tSh", "j", "e", NULL},
   {"uCCFCp", "tSh", "j", "e", NULL},
   {"uCCFDp", "tSh", "j", "e", NULL},
   {"uCCFEp", "tSh", "j", "e", NULL},
   {"uCCFFp", "tSh", "j", "e", NULL},
   {"uCD00p", "tSh", "j", "e", NULL},
   {"uCD01p", "tSh", "j", "e", NULL},
   {"uCD02p", "tSh", "j", "e", NULL},
   {"uCD03p", "tSh", "j", "e", NULL},
   {"uCD04p", "tSh", "j", "e", NULL},
   {"uCD05p", "tSh", "j", "e", NULL},
   {"uCD06p", "tSh", "j", "e", NULL},
   {"uCD07p", "tSh", "j", "e", NULL},
   {"uCD08p", "tSh", "o", NULL, NULL},
   {"uCD09p", "tSh", "o", "k", NULL},
   {"uCD0Ap", "tSh", "o", "kGT", NULL},
   {"uCD0Bp", "tSh", "o", "k", NULL},
   {"uCD0Cp", "tSh", "o", "n", NULL},
   {"uCD0Dp", "tSh", "o", "n", NULL},
   {"uCD0Ep", "tSh", "o", "n", NULL},
   {"uCD0Fp", "tSh", "o", "t", NULL},
   {"uCD10p", "tSh", "o", "l", NULL},
   {"uCD11p", "tSh", "o", "l", NULL},
   {"uCD12p", "tSh", "o", "l", NULL},
   {"uCD13p", "tSh", "o", "l", NULL},
   {"uCD14p", "tSh", "o", "l", NULL},
   {"uCD15p", "tSh", "o", "l", NULL},
   {"uCD16p", "tSh", "o", "l", NULL},
   {"uCD17p", "tSh", "o", "l", NULL},
   {"uCD18p", "tSh", "o", "m", NULL},
   {"uCD19p", "tSh", "o", "p", NULL},
   {"uCD1Ap", "tSh", "o", "p", NULL},
   {"uCD1Bp", "tSh", "o", "sh", NULL},
   {"uCD1Cp", "tSh", "o", "s", NULL},
   {"uCD1Dp", "tSh", "o", "N", NULL},
   {"uCD1Ep", "tSh", "o", "tS", NULL},
   {"uCD1Fp", "tSh", "o", "tSh", NULL},
   {"uCD20p", "tSh", "o", "kh", NULL},
   {"uCD21p", "tSh", "o", "th", NULL},
   {"uCD22p", "tSh", "o", "ph", NULL},
   {"uCD23p", "tSh", "o", "h", NULL},
   {"uCD24p", "tSh", "w", "a", NULL},
   {"uCD25p", "tSh", "w", "a", NULL},
   {"uCD26p", "tSh", "w", "a", NULL},
   {"uCD27p", "tSh", "w", "a", NULL},
   {"uCD28p", "tSh", "w", "a", NULL},
   {"uCD29p", "tSh", "w", "a", NULL},
   {"uCD2Ap", "tSh", "w", "a", NULL},
   {"uCD2Bp", "tSh", "w", "a", NULL},
   {"uCD2Cp", "tSh", "w", "a", NULL},
   {"uCD2Dp", "tSh", "w", "a", NULL},
   {"uCD2Ep", "tSh", "w", "a", NULL},
   {"uCD2Fp", "tSh", "w", "a", NULL},
   {"uCD30p", "tSh", "w", "a", NULL},
   {"uCD31p", "tSh", "w", "a", NULL},
   {"uCD32p", "tSh", "w", "a", NULL},
   {"uCD33p", "tSh", "w", "a", NULL},
   {"uCD34p", "tSh", "w", "a", NULL},
   {"uCD35p", "tSh", "w", "a", NULL},
   {"uCD36p", "tSh", "w", "a", NULL},
   {"uCD37p", "tSh", "w", "a", NULL},
   {"uCD38p", "tSh", "w", "a", NULL},
   {"uCD39p", "tSh", "w", "a", NULL},
   {"uCD3Ap", "tSh", "w", "a", NULL},
   {"uCD3Bp", "tSh", "w", "a", NULL},
   {"uCD3Cp", "tSh", "w", "a", NULL},
   {"uCD3Dp", "tSh", "w", "a", NULL},
   {"uCD3Ep", "tSh", "w", "a", NULL},
   {"uCD3Fp", "tSh", "w", "a", NULL},
   {"uCD40p", "tSh", "w", "@", NULL},
   {"uCD41p", "tSh", "w", "@", NULL},
   {"uCD42p", "tSh", "w", "@", NULL},
   {"uCD43p", "tSh", "w", "@", NULL},
   {"uCD44p", "tSh", "w", "@", NULL},
   {"uCD45p", "tSh", "w", "@", NULL},
   {"uCD46p", "tSh", "w", "@", NULL},
   {"uCD47p", "tSh", "w", "@", NULL},
   {"uCD48p", "tSh", "w", "@", NULL},
   {"uCD49p", "tSh", "w", "@", NULL},
   {"uCD4Ap", "tSh", "w", "@", NULL},
   {"uCD4Bp", "tSh", "w", "@", NULL},
   {"uCD4Cp", "tSh", "w", "@", NULL},
   {"uCD4Dp", "tSh", "w", "@", NULL},
   {"uCD4Ep", "tSh", "w", "@", NULL},
   {"uCD4Fp", "tSh", "w", "@", NULL},
   {"uCD50p", "tSh", "w", "@", NULL},
   {"uCD51p", "tSh", "w", "@", NULL},
   {"uCD52p", "tSh", "w", "@", NULL},
   {"uCD53p", "tSh", "w", "@", NULL},
   {"uCD54p", "tSh", "w", "@", NULL},
   {"uCD55p", "tSh", "w", "@", NULL},
   {"uCD56p", "tSh", "w", "@", NULL},
   {"uCD57p", "tSh", "w", "@", NULL},
   {"uCD58p", "tSh", "w", "@", NULL},
   {"uCD59p", "tSh", "w", "@", NULL},
   {"uCD5Ap", "tSh", "w", "@", NULL},
   {"uCD5Bp", "tSh", "w", "@", NULL},
   {"uCD5Cp", "tSh", "w", "e", NULL},
   {"uCD5Dp", "tSh", "w", "e", NULL},
   {"uCD5Ep", "tSh", "w", "e", NULL},
   {"uCD5Fp", "tSh", "w", "e", NULL},
   {"uCD60p", "tSh", "w", "e", NULL},
   {"uCD61p", "tSh", "w", "e", NULL},
   {"uCD62p", "tSh", "w", "e", NULL},
   {"uCD63p", "tSh", "w", "e", NULL},
   {"uCD64p", "tSh", "w", "e", NULL},
   {"uCD65p", "tSh", "w", "e", NULL},
   {"uCD66p", "tSh", "w", "e", NULL},
   {"uCD67p", "tSh", "w", "e", NULL},
   {"uCD68p", "tSh", "w", "e", NULL},
   {"uCD69p", "tSh", "w", "e", NULL},
   {"uCD6Ap", "tSh", "w", "e", NULL},
   {"uCD6Bp", "tSh", "w", "e", NULL},
   {"uCD6Cp", "tSh", "w", "e", NULL},
   {"uCD6Dp", "tSh", "w", "e", NULL},
   {"uCD6Ep", "tSh", "w", "e", NULL},
   {"uCD6Fp", "tSh", "w", "e", NULL},
   {"uCD70p", "tSh", "w", "e", NULL},
   {"uCD71p", "tSh", "w", "e", NULL},
   {"uCD72p", "tSh", "w", "e", NULL},
   {"uCD73p", "tSh", "w", "e", NULL},
   {"uCD74p", "tSh", "w", "e", NULL},
   {"uCD75p", "tSh", "w", "e", NULL},
   {"uCD76p", "tSh", "w", "e", NULL},
   {"uCD77p", "tSh", "w", "e", NULL},
   {"uCD78p", "tSh", "j", "o", NULL},
   {"uCD79p", "tSh", "j", "o", NULL},
   {"uCD7Ap", "tSh", "j", "o", NULL},
   {"uCD7Bp", "tSh", "j", "o", NULL},
   {"uCD7Cp", "tSh", "j", "o", NULL},
   {"uCD7Dp", "tSh", "j", "o", NULL},
   {"uCD7Ep", "tSh", "j", "o", NULL},
   {"uCD7Fp", "tSh", "j", "o", NULL},
   {"uCD80p", "tSh", "j", "o", NULL},
   {"uCD81p", "tSh", "j", "o", NULL},
   {"uCD82p", "tSh", "j", "o", NULL},
   {"uCD83p", "tSh", "j", "o", NULL},
   {"uCD84p", "tSh", "j", "o", NULL},
   {"uCD85p", "tSh", "j", "o", NULL},
   {"uCD86p", "tSh", "j", "o", NULL},
   {"uCD87p", "tSh", "j", "o", NULL},
   {"uCD88p", "tSh", "j", "o", NULL},
   {"uCD89p", "tSh", "j", "o", NULL},
   {"uCD8Ap", "tSh", "j", "o", NULL},
   {"uCD8Bp", "tSh", "j", "o", NULL},
   {"uCD8Cp", "tSh", "j", "o", NULL},
   {"uCD8Dp", "tSh", "j", "o", NULL},
   {"uCD8Ep", "tSh", "j", "o", NULL},
   {"uCD8Fp", "tSh", "j", "o", NULL},
   {"uCD90p", "tSh", "j", "o", NULL},
   {"uCD91p", "tSh", "j", "o", NULL},
   {"uCD92p", "tSh", "j", "o", NULL},
   {"uCD93p", "tSh", "j", "o", NULL},
   {"uCD94p", "tSh", "u", NULL, NULL},
   {"uCD95p", "tSh", "u", "k", NULL},
   {"uCD96p", "tSh", "u", "kGT", NULL},
   {"uCD97p", "tSh", "u", "k", NULL},
   {"uCD98p", "tSh", "u", "n", NULL},
   {"uCD99p", "tSh", "u", "n", NULL},
   {"uCD9Ap", "tSh", "u", "n", NULL},
   {"uCD9Bp", "tSh", "u", "t", NULL},
   {"uCD9Cp", "tSh", "u", "l", NULL},
   {"uCD9Dp", "tSh", "u", "l", NULL},
   {"uCD9Ep", "tSh", "u", "l", NULL},
   {"uCD9Fp", "tSh", "u", "l", NULL},
   {"uCDA0p", "tSh", "u", "l", NULL},
   {"uCDA1p", "tSh", "u", "l", NULL},
   {"uCDA2p", "tSh", "u", "l", NULL},
   {"uCDA3p", "tSh", "u", "l", NULL},
   {"uCDA4p", "tSh", "u", "m", NULL},
   {"uCDA5p", "tSh", "u", "p", NULL},
   {"uCDA6p", "tSh", "u", "p", NULL},
   {"uCDA7p", "tSh", "u", "sh", NULL},
   {"uCDA8p", "tSh", "u", "s", NULL},
   {"uCDA9p", "tSh", "u", "N", NULL},
   {"uCDAAp", "tSh", "u", "tS", NULL},
   {"uCDABp", "tSh", "u", "tSh", NULL},
   {"uCDACp", "tSh", "u", "kh", NULL},
   {"uCDADp", "tSh", "u", "th", NULL},
   {"uCDAEp", "tSh", "u", "ph", NULL},
   {"uCDAFp", "tSh", "u", "h", NULL},
   {"uCDB0p", "tSh", "w", "^", NULL},
   {"uCDB1p", "tSh", "w", "^", NULL},
   {"uCDB2p", "tSh", "w", "^", NULL},
   {"uCDB3p", "tSh", "w", "^", NULL},
   {"uCDB4p", "tSh", "w", "^", NULL},
   {"uCDB5p", "tSh", "w", "^", NULL},
   {"uCDB6p", "tSh", "w", "^", NULL},
   {"uCDB7p", "tSh", "w", "^", NULL},
   {"uCDB8p", "tSh", "w", "^", NULL},
   {"uCDB9p", "tSh", "w", "^", NULL},
   {"uCDBAp", "tSh", "w", "^", NULL},
   {"uCDBBp", "tSh", "w", "^", NULL},
   {"uCDBCp", "tSh", "w", "^", NULL},
   {"uCDBDp", "tSh", "w", "^", NULL},
   {"uCDBEp", "tSh", "w", "^", NULL},
   {"uCDBFp", "tSh", "w", "^", NULL},
   {"uCDC0p", "tSh", "w", "^", NULL},
   {"uCDC1p", "tSh", "w", "^", NULL},
   {"uCDC2p", "tSh", "w", "^", NULL},
   {"uCDC3p", "tSh", "w", "^", NULL},
   {"uCDC4p", "tSh", "w", "^", NULL},
   {"uCDC5p", "tSh", "w", "^", NULL},
   {"uCDC6p", "tSh", "w", "^", NULL},
   {"uCDC7p", "tSh", "w", "^", NULL},
   {"uCDC8p", "tSh", "w", "^", NULL},
   {"uCDC9p", "tSh", "w", "^", NULL},
   {"uCDCAp", "tSh", "w", "^", NULL},
   {"uCDCBp", "tSh", "w", "^", NULL},
   {"uCDCCp", "tSh", "w", "e", NULL},
   {"uCDCDp", "tSh", "w", "e", NULL},
   {"uCDCEp", "tSh", "w", "e", NULL},
   {"uCDCFp", "tSh", "w", "e", NULL},
   {"uCDD0p", "tSh", "w", "e", NULL},
   {"uCDD1p", "tSh", "w", "e", NULL},
   {"uCDD2p", "tSh", "w", "e", NULL},
   {"uCDD3p", "tSh", "w", "e", NULL},
   {"uCDD4p", "tSh", "w", "e", NULL},
   {"uCDD5p", "tSh", "w", "e", NULL},
   {"uCDD6p", "tSh", "w", "e", NULL},
   {"uCDD7p", "tSh", "w", "e", NULL},
   {"uCDD8p", "tSh", "w", "e", NULL},
   {"uCDD9p", "tSh", "w", "e", NULL},
   {"uCDDAp", "tSh", "w", "e", NULL},
   {"uCDDBp", "tSh", "w", "e", NULL},
   {"uCDDCp", "tSh", "w", "e", NULL},
   {"uCDDDp", "tSh", "w", "e", NULL},
   {"uCDDEp", "tSh", "w", "e", NULL},
   {"uCDDFp", "tSh", "w", "e", NULL},
   {"uCD70p", "tSh", "w", "e", NULL},
   {"uCD71p", "tSh", "w", "e", NULL},
   {"uCD72p", "tSh", "w", "e", NULL},
   {"uCD73p", "tSh", "w", "e", NULL},
   {"uCD74p", "tSh", "w", "e", NULL},
   {"uCD75p", "tSh", "w", "e", NULL},
   {"uCD76p", "tSh", "w", "e", NULL},
   {"uCD77p", "tSh", "w", "e", NULL},
   {"uCD78p", "tSh", "j", "o", NULL},
   {"uCD79p", "tSh", "j", "o", NULL},
   {"uCD7Ap", "tSh", "j", "o", NULL},
   {"uCD7Bp", "tSh", "j", "o", NULL},
   {"uCD7Cp", "tSh", "j", "o", NULL},
   {"uCD7Dp", "tSh", "j", "o", NULL},
   {"uCD7Ep", "tSh", "j", "o", NULL},
   {"uCD7Fp", "tSh", "j", "o", NULL},
   {"uCD80p", "tSh", "j", "o", NULL},
   {"uCD81p", "tSh", "j", "o", NULL},
   {"uCD82p", "tSh", "j", "o", NULL},
   {"uCD83p", "tSh", "j", "o", NULL},
   {"uCD84p", "tSh", "j", "o", NULL},
   {"uCD85p", "tSh", "j", "o", NULL},
   {"uCD86p", "tSh", "j", "o", NULL},
   {"uCD87p", "tSh", "j", "o", NULL},
   {"uCD88p", "tSh", "j", "o", NULL},
   {"uCD89p", "tSh", "j", "o", NULL},
   {"uCD8Ap", "tSh", "j", "o", NULL},
   {"uCD8Bp", "tSh", "j", "o", NULL},
   {"uCD8Cp", "tSh", "j", "o", NULL},
   {"uCD8Dp", "tSh", "j", "o", NULL},
   {"uCD8Ep", "tSh", "j", "o", NULL},
   {"uCD8Fp", "tSh", "j", "o", NULL},
   {"uCD90p", "tSh", "j", "o", NULL},
   {"uCD91p", "tSh", "j", "o", NULL},
   {"uCD92p", "tSh", "j", "o", NULL},
   {"uCD93p", "tSh", "j", "o", NULL},
   {"uCD94p", "tSh", "u", NULL, NULL},
   {"uCD95p", "tSh", "u", "k", NULL},
   {"uCD96p", "tSh", "u", "kGT", NULL},
   {"uCD97p", "tSh", "u", "k", NULL},
   {"uCD98p", "tSh", "u", "n", NULL},
   {"uCD99p", "tSh", "u", "n", NULL},
   {"uCD9Ap", "tSh", "u", "n", NULL},
   {"uCD9Bp", "tSh", "u", "t", NULL},
   {"uCD9Cp", "tSh", "u", "l", NULL},
   {"uCD9Dp", "tSh", "u", "l", NULL},
   {"uCD9Ep", "tSh", "u", "l", NULL},
   {"uCD9Fp", "tSh", "u", "l", NULL},
   {"uCDA0p", "tSh", "u", "l", NULL},
   {"uCDA1p", "tSh", "u", "l", NULL},
   {"uCDA2p", "tSh", "u", "l", NULL},
   {"uCDA3p", "tSh", "u", "h", NULL},
   {"uCDA4p", "tSh", "u", "m", NULL},
   {"uCDA5p", "tSh", "u", "p", NULL},
   {"uCDA6p", "tSh", "u", "p", NULL},
   {"uCDA7p", "tSh", "u", "sh", NULL},
   {"uCDA8p", "tSh", "u", "s", NULL},
   {"uCDA9p", "tSh", "u", "N", NULL},
   {"uCDAAp", "tSh", "u", "tS", NULL},
   {"uCDABp", "tSh", "u", "tSh", NULL},
   {"uCDACp", "tSh", "u", "kh", NULL},
   {"uCDADp", "tSh", "u", "th", NULL},
   {"uCDAEp", "tSh", "u", "ph", NULL},
   {"uCDAFp", "tSh", "u", "h", NULL},
   {"uCDB0p", "tSh", "w", "^", NULL},
   {"uCDB1p", "tSh", "w", "^", NULL},
   {"uCDB2p", "tSh", "w", "^", NULL},
   {"uCDB3p", "tSh", "w", "^", NULL},
   {"uCDB4p", "tSh", "w", "^", NULL},
   {"uCDB5p", "tSh", "w", "^", NULL},
   {"uCDB6p", "tSh", "w", "^", NULL},
   {"uCDB7p", "tSh", "w", "^", NULL},
   {"uCDB8p", "tSh", "w", "^", NULL},
   {"uCDB9p", "tSh", "w", "^", NULL},
   {"uCDBAp", "tSh", "w", "^", NULL},
   {"uCDBBp", "tSh", "w", "^", NULL},
   {"uCDBCp", "tSh", "w", "^", NULL},
   {"uCDBDp", "tSh", "w", "^", NULL},
   {"uCDBEp", "tSh", "w", "^", NULL},
   {"uCDBFp", "tSh", "w", "^", NULL},
   {"uCDC0p", "tSh", "w", "^", NULL},
   {"uCDC1p", "tSh", "w", "^", NULL},
   {"uCDC2p", "tSh", "w", "^", NULL},
   {"uCDC3p", "tSh", "w", "^", NULL},
   {"uCDC4p", "tSh", "w", "^", NULL},
   {"uCDC5p", "tSh", "w", "^", NULL},
   {"uCDC6p", "tSh", "w", "^", NULL},
   {"uCDC7p", "tSh", "w", "^", NULL},
   {"uCDC8p", "tSh", "w", "^", NULL},
   {"uCDC9p", "tSh", "w", "^", NULL},
   {"uCDCAp", "tSh", "w", "^", NULL},
   {"uCDCBp", "tSh", "w", "^", NULL},
   {"uCDCCp", "tSh", "w", "e", NULL},
   {"uCDCDp", "tSh", "w", "e", NULL},
   {"uCDCEp", "tSh", "w", "e", NULL},
   {"uCDCFp", "tSh", "w", "e", NULL},
   {"uCDD0p", "tSh", "w", "e", NULL},
   {"uCDD1p", "tSh", "w", "e", NULL},
   {"uCDD2p", "tSh", "w", "e", NULL},
   {"uCDD3p", "tSh", "w", "e", NULL},
   {"uCDD4p", "tSh", "w", "e", NULL},
   {"uCDD5p", "tSh", "w", "e", NULL},
   {"uCDD6p", "tSh", "w", "e", NULL},
   {"uCDD7p", "tSh", "w", "e", NULL},
   {"uCDD8p", "tSh", "w", "e", NULL},
   {"uCDD9p", "tSh", "w", "e", NULL},
   {"uCDDAp", "tSh", "w", "e", NULL},
   {"uCDDBp", "tSh", "w", "e", NULL},
   {"uCDDCp", "tSh", "w", "e", NULL},
   {"uCDDDp", "tSh", "w", "e", NULL},
   {"uCDDEp", "tSh", "w", "e", NULL},
   {"uCDDFp", "tSh", "w", "e", NULL},
   {"uCDE0p", "tSh", "w", "e", NULL},
   {"uCDE1p", "tSh", "w", "e", NULL},
   {"uCDE2p", "tSh", "w", "e", NULL},
   {"uCDE3p", "tSh", "w", "e", NULL},
   {"uCDE4p", "tSh", "w", "e", NULL},
   {"uCDE5p", "tSh", "w", "e", NULL},
   {"uCDE6p", "tSh", "w", "e", NULL},
   {"uCDE7p", "tSh", "w", "e", NULL},
   {"uCDE8p", "tSh", "7", NULL, NULL},
   {"uCDE9p", "tSh", "7", "k", NULL},
   {"uCDEAp", "tSh", "7", "kGT", NULL},
   {"uCDEBp", "tSh", "7", "k", NULL},
   {"uCDECp", "tSh", "7", "n", NULL},
   {"uCDEDp", "tSh", "7", "n", NULL},
   {"uCDEEp", "tSh", "7", "n", NULL},
   {"uCDEFp", "tSh", "7", "t", NULL},
   {"uCDF0p", "tSh", "7", "l", NULL},
   {"uCDF1p", "tSh", "7", "l", NULL},
   {"uCDF2p", "tSh", "7", "l", NULL},
   {"uCDF3p", "tSh", "7", "l", NULL},
   {"uCDF4p", "tSh", "7", "l", NULL},
   {"uCDF5p", "tSh", "7", "l", NULL},
   {"uCDF6p", "tSh", "7", "l", NULL},
   {"uCDF7p", "tSh", "7", "l", NULL},
   {"uCDF8p", "tSh", "7", "m", NULL},
   {"uCDF9p", "tSh", "7", "p", NULL},
   {"uCDFAp", "tSh", "7", "p", NULL},
   {"uCDFBp", "tSh", "7", "sh", NULL},
   {"uCDFCp", "tSh", "7", "s", NULL},
   {"uCDFDp", "tSh", "7", "N", NULL},
   {"uCDFEp", "tSh", "7", "tS", NULL},
   {"uCDFFp", "tSh", "7", "tSh", NULL},
   {"uCE00p", "tSh", "7", "kh", NULL},
   {"uCE01p", "tSh", "7", "th", NULL},
   {"uCE02p", "tSh", "7", "ph", NULL},
   {"uCE03p", "tSh", "7", "h", NULL},
   {"uCE04p", "tSh", "j", "u", NULL},
   {"uCE05p", "tSh", "j", "u", NULL},
   {"uCE06p", "tSh", "j", "u", NULL},
   {"uCE07p", "tSh", "j", "u", NULL},
   {"uCE08p", "tSh", "j", "u", NULL},
   {"uCE09p", "tSh", "j", "u", NULL},
   {"uCE0Ap", "tSh", "j", "u", NULL},
   {"uCE0Bp", "tSh", "j", "u", NULL},
   {"uCE0Cp", "tSh", "j", "u", NULL},
   {"uCE0Dp", "tSh", "j", "u", NULL},
   {"uCE0Ep", "tSh", "j", "u", NULL},
   {"uCE0Fp", "tSh", "j", "u", NULL},
   {"uCE10p", "tSh", "j", "u", NULL},
   {"uCE11p", "tSh", "j", "u", NULL},
   {"uCE12p", "tSh", "j", "u", NULL},
   {"uCE13p", "tSh", "j", "u", NULL},
   {"uCE14p", "tSh", "j", "u", NULL},
   {"uCE15p", "tSh", "j", "u", NULL},
   {"uCE16p", "tSh", "j", "u", NULL},
   {"uCE17p", "tSh", "j", "u", NULL},
   {"uCE18p", "tSh", "j", "u", NULL},
   {"uCE19p", "tSh", "j", "u", NULL},
   {"uCE1Ap", "tSh", "j", "u", NULL},
   {"uCE1Bp", "tSh", "j", "u", NULL},
   {"uCE1Cp", "tSh", "j", "u", NULL},
   {"uCE1Dp", "tSh", "j", "u", NULL},
   {"uCE1Ep", "tSh", "j", "u", NULL},
   {"uCE1Fp", "tSh", "j", "u", NULL},
   {"uCE20p", "tSh", "4", NULL, NULL},
   {"uCE21p", "tSh", "4", "k", NULL},
   {"uCE22p", "tSh", "4", "kGT", NULL},
   {"uCE23p", "tSh", "4", "k", NULL},
   {"uCE24p", "tSh", "4", "n", NULL},
   {"uCE25p", "tSh", "4", "n", NULL},
   {"uCE26p", "tSh", "4", "n", NULL},
   {"uCE27p", "tSh", "4", "t", NULL},
   {"uCE28p", "tSh", "4", "l", NULL},
   {"uCE29p", "tSh", "4", "l", NULL},
   {"uCE2Ap", "tSh", "4", "l", NULL},
   {"uCE2Bp", "tSh", "4", "l", NULL},
   {"uCE2Cp", "tSh", "4", "l", NULL},
   {"uCE2Dp", "tSh", "4", "l", NULL},
   {"uCE2Ep", "tSh", "4", "l", NULL},
   {"uCE2Fp", "tSh", "4", "l", NULL},
   {"uCE30p", "tSh", "4", "m", NULL},
   {"uCE31p", "tSh", "4", "p", NULL},
   {"uCE32p", "tSh", "4", "p", NULL},
   {"uCE33p", "tSh", "4", "sh", NULL},
   {"uCE34p", "tSh", "4", "s", NULL},
   {"uCE35p", "tSh", "4", "N", NULL},
   {"uCE36p", "tSh", "4", "tS", NULL},
   {"uCE37p", "tSh", "4", "tSh", NULL},
   {"uCE38p", "tSh", "4", "kh", NULL},
   {"uCE39p", "tSh", "4", "th", NULL},
   {"uCE3Ap", "tSh", "4", "ph", NULL},
   {"uCE3Bp", "tSh", "4", "h", NULL},
   {"uCE3Cp", "tSh", "4", "j", NULL},
   {"uCE3Dp", "tSh", "4", "j", NULL},
   {"uCE3Ep", "tSh", "4", "j", NULL},
   {"uCE3Fp", "tSh", "4", "j", NULL},
   {"uCE40p", "tSh", "4", "j", NULL},
   {"uCE41p", "tSh", "4", "j", NULL},
   {"uCE42p", "tSh", "4", "j", NULL},
   {"uCE43p", "tSh", "4", "j", NULL},
   {"uCE44p", "tSh", "4", "j", NULL},
   {"uCE45p", "tSh", "4", "j", NULL},
   {"uCE46p", "tSh", "4", "j", NULL},
   {"uCE47p", "tSh", "4", "j", NULL},
   {"uCE48p", "tSh", "4", "j", NULL},
   {"uCE49p", "tSh", "4", "j", NULL},
   {"uCE4Ap", "tSh", "4", "j", NULL},
   {"uCE4Bp", "tSh", "4", "j", NULL},
   {"uCE4Cp", "tSh", "4", "j", NULL},
   {"uCE4Dp", "tSh", "4", "j", NULL},
   {"uCE4Ep", "tSh", "4", "j", NULL},
   {"uCE4Fp", "tSh", "4", "j", NULL},
   {"uCE50p", "tSh", "4", "j", NULL},
   {"uCE51p", "tSh", "4", "j", NULL},
   {"uCE52p", "tSh", "4", "j", NULL},
   {"uCE53p", "tSh", "4", "j", NULL},
   {"uCE54p", "tSh", "4", "j", NULL},
   {"uCE55p", "tSh", "4", "j", NULL},
   {"uCE56p", "tSh", "4", "j", NULL},
   {"uCE57p", "tSh", "4", "j", NULL},
   {"uCE58p", "tSh", "i", NULL, NULL},
   {"uCE59p", "tSh", "i", "k", NULL},
   {"uCE5Ap", "tSh", "i", "kGT", NULL},
   {"uCE5Bp", "tSh", "i", "k", NULL},
   {"uCE5Cp", "tSh", "i", "n", NULL},
   {"uCE5Dp", "tSh", "i", "n", NULL},
   {"uCE5Ep", "tSh", "i", "n", NULL},
   {"uCE5Fp", "tSh", "i", "t", NULL},
   {"uCE60p", "tSh", "i", "l", NULL},
   {"uCE61p", "tSh", "i", "l", NULL},
   {"uCE62p", "tSh", "i", "l", NULL},
   {"uCE63p", "tSh", "i", "l", NULL},
   {"uCE64p", "tSh", "i", "l", NULL},
   {"uCE65p", "tSh", "i", "l", NULL},
   {"uCE66p", "tSh", "i", "l", NULL},
   {"uCE67p", "tSh", "i", "l", NULL},
   {"uCE68p", "tSh", "i", "m", NULL},
   {"uCE69p", "tSh", "i", "p", NULL},
   {"uCE6Ap", "tSh", "i", "p", NULL},
   {"uCE6Bp", "tSh", "i", "sh", NULL},
   {"uCE6Cp", "tSh", "i", "s", NULL},
   {"uCE6Dp", "tSh", "i", "N", NULL},
   {"uCE6Ep", "tSh", "i", "tS", NULL},
   {"uCE6Fp", "tSh", "i", "tSh", NULL},
   {"uCE70p", "tSh", "i", "kh", NULL},
   {"uCE71p", "tSh", "i", "th", NULL},
   {"uCE72p", "tSh", "i", "ph", NULL},
   {"uCE73p", "tSh", "i", "h", NULL},
   {"uCE74p", "kh", "a", NULL, NULL},
   {"uCE75p", "kh", "a", "k", NULL},
   {"uCE76p", "kh", "a", "kGT", NULL},
   {"uCE77p", "kh", "a", "k", NULL},
   {"uCE78p", "kh", "a", "n", NULL},
   {"uCE79p", "kh", "a", "n", NULL},
   {"uCE7Ap", "kh", "a", "n", NULL},
   {"uCE7Bp", "kh", "a", "t", NULL},
   {"uCE7Cp", "kh", "a", "l", NULL},
   {"uCE7Dp", "kh", "a", "l", NULL},
   {"uCE7Ep", "kh", "a", "l", NULL},
   {"uCE7Fp", "kh", "a", "l", NULL},
   {"uCE80p", "kh", "a", "l", NULL},
   {"uCE81p", "kh", "a", "l", NULL},
   {"uCE82p", "kh", "a", "l", NULL},
   {"uCE83p", "kh", "a", "l", NULL},
   {"uCE84p", "kh", "a", "m", NULL},
   {"uCE85p", "kh", "a", "p", NULL},
   {"uC386p", "kh", "a", "p", NULL},
   {"uCE87p", "kh", "a", "sh", NULL},
   {"uCE88p", "kh", "a", "s", NULL},
   {"uCE89p", "kh", "a", "N", NULL},
   {"uCE8Ap", "kh", "a", "tS", NULL},
   {"uCE8Bp", "kh", "a", "tSh", NULL},
   {"uCE8Cp", "kh", "a", "kh", NULL},
   {"uCE8Dp", "kh", "a", "th", NULL},
   {"uCE8Ep", "kh", "a", "ph", NULL},
   {"uCE8Fp", "kh", "a", "h", NULL},
   {"uCE90p", "kh", "@", NULL, NULL},
   {"uCE91p", "kh", "@", "k", NULL},
   {"uCE92p", "kh", "@", "kGT", NULL},
   {"uCE93p", "kh", "@", "k", NULL},
   {"uCE94p", "kh", "@", "n", NULL},
   {"uCE95p", "kh", "@", "n", NULL},
   {"uCE96p", "kh", "@", "n", NULL},
   {"uCE97p", "kh", "@", "t", NULL},
   {"uCE98p", "kh", "@", "l", NULL},
   {"uCE99p", "kh", "@", "l", NULL},
   {"uCE9Ap", "kh", "@", "l", NULL},
   {"uCE9Bp", "kh", "@", "l", NULL},
   {"uCE9Cp", "kh", "@", "l", NULL},
   {"uCE9Dp", "kh", "@", "l", NULL},
   {"uCE9Ep", "kh", "@", "l", NULL},
   {"uCE9Fp", "kh", "@", "l", NULL},
   {"uCEA0p", "kh", "@", "m", NULL},
   {"uCEA1p", "kh", "@", "p", NULL},
   {"uCEA2p", "kh", "@", "p", NULL},
   {"uCEA3p", "kh", "@", "sh", NULL},
   {"uCEA4p", "kh", "@", "s", NULL},
   {"uCEA5p", "kh", "@", "N", NULL},
   {"uCEA6p", "kh", "@", "tS", NULL},
   {"uCEA7p", "kh", "@", "tSh", NULL},
   {"uCEA8p", "kh", "@", "kh", NULL},
   {"uCEA9p", "kh", "@", "th", NULL},
   {"uCEAAp", "kh", "@", "ph", NULL},
   {"uCEABp", "kh", "@", "h", NULL},
   {"uCEACp", "kh", "j", "a", NULL},
   {"uCEADp", "kh", "j", "a", NULL},
   {"uCEAEp", "kh", "j", "a", NULL},
   {"uCEAFp", "kh", "j", "a", NULL},
   {"uCEB0p", "kh", "j", "a", NULL},
   {"uCEB1p", "kh", "j", "a", NULL},
   {"uCEB2p", "kh", "j", "a", NULL},
   {"uCEB3p", "kh", "j", "a", NULL},
   {"uCEB4p", "kh", "j", "a", NULL},
   {"uCEB5p", "kh", "j", "a", NULL},
   {"uCEB6p", "kh", "j", "a", NULL},
   {"uCEB7p", "kh", "j", "a", NULL},
   {"uCEB8p", "kh", "j", "a", NULL},
   {"uCEB9p", "kh", "j", "a", NULL},
   {"uCEBAp", "kh", "j", "a", NULL},
   {"uCEBBp", "kh", "j", "a", NULL},
   {"uCEBCp", "kh", "j", "a", NULL},
   {"uCEBDp", "kh", "j", "a", NULL},
   {"uCEBEp", "kh", "j", "a", NULL},
   {"uCEBFp", "kh", "j", "a", NULL},
   {"uCEC0p", "kh", "j", "a", NULL},
   {"uCEC1p", "kh", "j", "a", NULL},
   {"uCEC2p", "kh", "j", "a", NULL},
   {"uCEC3p", "kh", "j", "a", NULL},
   {"uCEC4p", "kh", "j", "a", NULL},
   {"uCEC5p", "kh", "j", "a", NULL},
   {"uCEC6p", "kh", "j", "a", NULL},
   {"uCEC7p", "kh", "j", "a", NULL},
   {"uCEC8p", "kh", "j", "@", NULL},
   {"uCEC9p", "kh", "j", "@", NULL},
   {"uCECAp", "kh", "j", "@", NULL},
   {"uCECBp", "kh", "j", "@", NULL},
   {"uCECCp", "kh", "j", "@", NULL},
   {"uCECDp", "kh", "j", "@", NULL},
   {"uCECEp", "kh", "j", "@", NULL},
   {"uCECFp", "kh", "j", "@", NULL},
   {"uCED0p", "kh", "j", "@", NULL},
   {"uCED1p", "kh", "j", "@", NULL},
   {"uCED2p", "kh", "j", "@", NULL},
   {"uCED3p", "kh", "j", "@", NULL},
   {"uCED4p", "kh", "j", "@", NULL},
   {"uCED5p", "kh", "j", "@", NULL},
   {"uCED6p", "kh", "j", "@", NULL},
   {"uCED7p", "kh", "j", "@", NULL},
   {"uCED8p", "kh", "j", "@", NULL},
   {"uCED9p", "kh", "j", "@", NULL},
   {"uCDEAp", "kh", "j", "@", NULL},
   {"uCEDBp", "kh", "j", "@", NULL},
   {"uCEDCp", "kh", "j", "@", NULL},
   {"uCEDDp", "kh", "j", "@", NULL},
   {"uCEDEp", "kh", "j", "@", NULL},
   {"uCEDFp", "kh", "j", "@", NULL},
   {"uCEE0p", "kh", "j", "@", NULL},
   {"uCEE1p", "kh", "j", "@", NULL},
   {"uCEE2p", "kh", "j", "@", NULL},
   {"uCEE3p", "kh", "j", "@", NULL},
   {"uCEE4p", "kh", "^", NULL, NULL},
   {"uCEE5p", "kh", "^", "k", NULL},
   {"uCEE6p", "kh", "^", "kGT", NULL},
   {"uCEE7p", "kh", "^", "k", NULL},
   {"uCEE8p", "kh", "^", "n", NULL},
   {"uCEE9p", "kh", "^", "n", NULL},
   {"uCEEAp", "kh", "^", "n", NULL},
   {"uCEEBp", "kh", "^", "t", NULL},
   {"uCEECp", "kh", "^", "l", NULL},
   {"uCEEDp", "kh", "^", "l", NULL},
   {"uCEEEp", "kh", "^", "l", NULL},
   {"uCEEFp", "kh", "^", "l", NULL},
   {"uCEF0p", "kh", "^", "l", NULL},
   {"uCEF1p", "kh", "^", "l", NULL},
   {"uCEF2p", "kh", "^", "l", NULL},
   {"uCEF3p", "kh", "^", "l", NULL},
   {"uCEF4p", "kh", "^", "m", NULL},
   {"uCEF5p", "kh", "^", "p", NULL},
   {"uC3F6p", "kh", "^", "p", NULL},
   {"uCEF7p", "kh", "^", "sh", NULL},
   {"uCEF8p", "kh", "^", "s", NULL},
   {"uCEF9p", "kh", "^", "N", NULL},
   {"uCEFAp", "kh", "^", "tS", NULL},
   {"uCEFBp", "kh", "^", "tSh", NULL},
   {"uCEFCp", "kh", "^", "kh", NULL},
   {"uCEFDp", "kh", "^", "th", NULL},
   {"uCEFEp", "kh", "^", "ph", NULL},
   {"uCEFFp", "kh", "^", "h", NULL},
   {"uCF00p", "kh", "e", NULL, NULL},
   {"uCF01p", "kh", "e", "k", NULL},
   {"uCF02p", "kh", "e", "kGT", NULL},
   {"uCF03p", "kh", "e", "k", NULL},
   {"uCF04p", "kh", "e", "n", NULL},
   {"uCF05p", "kh", "e", "n", NULL},
   {"uCF06p", "kh", "e", "n", NULL},
   {"uCF07p", "kh", "e", "t", NULL},
   {"uCF08p", "kh", "e", "l", NULL},
   {"uCF09p", "kh", "e", "l", NULL},
   {"uCF0Ap", "kh", "e", "l", NULL},
   {"uCF0Bp", "kh", "e", "l", NULL},
   {"uCF0Cp", "kh", "e", "l", NULL},
   {"uCF0Dp", "kh", "e", "l", NULL},
   {"uCF0Ep", "kh", "e", "l", NULL},
   {"uCF0Fp", "kh", "e", "l", NULL},
   {"uCF10p", "kh", "e", "m", NULL},
   {"uCF11p", "kh", "e", "p", NULL},
   {"uCF12p", "kh", "e", "p", NULL},
   {"uCF13p", "kh", "e", "sh", NULL},
   {"uCF14p", "kh", "e", "s", NULL},
   {"uCF15p", "kh", "e", "N", NULL},
   {"uCF16p", "kh", "e", "tS", NULL},
   {"uCF17p", "kh", "e", "tSh", NULL},
   {"uCF18p", "kh", "e", "kh", NULL},
   {"uCF19p", "kh", "e", "th", NULL},
   {"uCF1Ap", "kh", "e", "ph", NULL},
   {"uCF1Bp", "kh", "e", "h", NULL},
   {"uCF1Cp", "kh", "j", "^", NULL},
   {"uCF1Dp", "kh", "j", "^", NULL},
   {"uCF1Ep", "kh", "j", "^", NULL},
   {"uCF1Fp", "kh", "j", "^", NULL},
   {"uCF20p", "kh", "j", "^", NULL},
   {"uCF21p", "kh", "j", "^", NULL},
   {"uCF22p", "kh", "j", "^", NULL},
   {"uCF23p", "kh", "j", "^", NULL},
   {"uCF24p", "kh", "j", "^", NULL},
   {"uCF25p", "kh", "j", "^", NULL},
   {"uCF26p", "kh", "j", "^", NULL},
   {"uCF27p", "kh", "j", "^", NULL},
   {"uCF28p", "kh", "j", "^", NULL},
   {"uCF29p", "kh", "j", "^", NULL},
   {"uCF2Ap", "kh", "j", "^", NULL},
   {"uCF2Bp", "kh", "j", "^", NULL},
   {"uCF2Cp", "kh", "j", "^", NULL},
   {"uCF2Dp", "kh", "j", "^", NULL},
   {"uCF2Ep", "kh", "j", "^", NULL},
   {"uCF2Fp", "kh", "j", "^", NULL},
   {"uCF30p", "kh", "j", "^", NULL},
   {"uCF31p", "kh", "j", "^", NULL},
   {"uCF32p", "kh", "j", "^", NULL},
   {"uCF33p", "kh", "j", "^", NULL},
   {"uCF34p", "kh", "j", "^", NULL},
   {"uCF35p", "kh", "j", "^", NULL},
   {"uCF36p", "kh", "j", "^", NULL},
   {"uCF37p", "kh", "j", "^", NULL},
   {"uCF38p", "kh", "j", "e", NULL},
   {"uCF39p", "kh", "j", "e", NULL},
   {"uCF3Ap", "kh", "j", "e", NULL},
   {"uCF3Bp", "kh", "j", "e", NULL},
   {"uCF3Cp", "kh", "j", "e", NULL},
   {"uCF3Dp", "kh", "j", "e", NULL},
   {"uCF3Ep", "kh", "j", "e", NULL},
   {"uCF3Fp", "kh", "j", "e", NULL},
   {"uCF40p", "kh", "j", "e", NULL},
   {"uCF41p", "kh", "j", "e", NULL},
   {"uCF42p", "kh", "j", "e", NULL},
   {"uCF43p", "kh", "j", "e", NULL},
   {"uCF44p", "kh", "j", "e", NULL},
   {"uCF45p", "kh", "j", "e", NULL},
   {"uCF46p", "kh", "j", "e", NULL},
   {"uCF47p", "kh", "j", "e", NULL},
   {"uCF48p", "kh", "j", "e", NULL},
   {"uCF49p", "kh", "j", "e", NULL},
   {"uCF4Ap", "kh", "j", "e", NULL},
   {"uCF4Bp", "kh", "j", "e", NULL},
   {"uCF4Cp", "kh", "j", "e", NULL},
   {"uCF4Dp", "kh", "j", "e", NULL},
   {"uCF4Ep", "kh", "j", "e", NULL},
   {"uCF4Fp", "kh", "j", "e", NULL},
   {"uCF50p", "kh", "j", "e", NULL},
   {"uCF51p", "kh", "j", "e", NULL},
   {"uCF52p", "kh", "j", "e", NULL},
   {"uCF53p", "kh", "j", "e", NULL},
   {"uCF54p", "kh", "o", NULL, NULL},
   {"uCF55p", "kh", "o", "k", NULL},
   {"uCF56p", "kh", "o", "kGT", NULL},
   {"uCF57p", "kh", "o", "k", NULL},
   {"uCF58p", "kh", "o", "n", NULL},
   {"uCF59p", "kh", "o", "n", NULL},
   {"uCF5Ap", "kh", "o", "n", NULL},
   {"uCF5Bp", "kh", "o", "t", NULL},
   {"uCF5Cp", "kh", "o", "l", NULL},
   {"uCF5Dp", "kh", "o", "l", NULL},
   {"uCF5Ep", "kh", "o", "l", NULL},
   {"uCF5Fp", "kh", "o", "l", NULL},
   {"uCF60p", "kh", "o", "l", NULL},
   {"uCF61p", "kh", "o", "l", NULL},
   {"uCF62p", "kh", "o", "l", NULL},
   {"uCF63p", "kh", "o", "l", NULL},
   {"uCF64p", "kh", "o", "m", NULL},
   {"uCF65p", "kh", "o", "p", NULL},
   {"uCF66p", "kh", "o", "p", NULL},
   {"uCF67p", "kh", "o", "sh", NULL},
   {"uCF68p", "kh", "o", "s", NULL},
   {"uCF69p", "kh", "o", "N", NULL},
   {"uCF6Ap", "kh", "o", "tS", NULL},
   {"uCF6Bp", "kh", "o", "tSh", NULL},
   {"uCF6Cp", "kh", "o", "kh", NULL},
   {"uCF6Dp", "kh", "o", "th", NULL},
   {"uCF6Ep", "kh", "o", "ph", NULL},
   {"uCF6Fp", "kh", "o", "h", NULL},
   {"uCF70p", "kh", "w", "a", NULL},
   {"uCF71p", "kh", "w", "a", NULL},
   {"uCF72p", "kh", "w", "a", NULL},
   {"uCF73p", "kh", "w", "a", NULL},
   {"uCF74p", "kh", "w", "a", NULL},
   {"uCF75p", "kh", "w", "a", NULL},
   {"uCF76p", "kh", "w", "a", NULL},
   {"uCF77p", "kh", "w", "a", NULL},
   {"uCF78p", "kh", "w", "a", NULL},
   {"uCF79p", "kh", "w", "a", NULL},
   {"uCF7Ap", "kh", "w", "a", NULL},
   {"uCF7Bp", "kh", "w", "a", NULL},
   {"uCF7Cp", "kh", "w", "a", NULL},
   {"uCF7Dp", "kh", "w", "a", NULL},
   {"uCF7Ep", "kh", "w", "a", NULL},
   {"uCF7Fp", "kh", "w", "a", NULL},
   {"uCF80p", "kh", "w", "a", NULL},
   {"uCF81p", "kh", "w", "a", NULL},
   {"uCF82p", "kh", "w", "a", NULL},
   {"uCF83p", "kh", "w", "a", NULL},
   {"uCF84p", "kh", "w", "a", NULL},
   {"uCF85p", "kh", "w", "a", NULL},
   {"uCF86p", "kh", "w", "a", NULL},
   {"uCF87p", "kh", "w", "a", NULL},
   {"uCF88p", "kh", "w", "a", NULL},
   {"uCF89p", "kh", "w", "a", NULL},
   {"uCF8Ap", "kh", "w", "a", NULL},
   {"uCF8Bp", "kh", "w", "a", NULL},
   {"uCF8Cp", "kh", "w", "@", NULL},
   {"uCF8Dp", "kh", "w", "@", NULL},
   {"uCF8Ep", "kh", "w", "@", NULL},
   {"uCF8Fp", "kh", "w", "@", NULL},
   {"uCF90p", "kh", "w", "@", NULL},
   {"uCF91p", "kh", "w", "@", NULL},
   {"uCF92p", "kh", "w", "@", NULL},
   {"uCF93p", "kh", "w", "@", NULL},
   {"uCF94p", "kh", "w", "@", NULL},
   {"uCF95p", "kh", "w", "@", NULL},
   {"uCF96p", "kh", "w", "@", NULL},
   {"uCF97p", "kh", "w", "@", NULL},
   {"uCF98p", "kh", "w", "@", NULL},
   {"uCF99p", "kh", "w", "@", NULL},
   {"uCF9Ap", "kh", "w", "@", NULL},
   {"uCF9Bp", "kh", "w", "@", NULL},
   {"uCF9Cp", "kh", "w", "@", NULL},
   {"uCF9Dp", "kh", "w", "@", NULL},
   {"uCF9Ep", "kh", "w", "@", NULL},
   {"uCF9Fp", "kh", "w", "@", NULL},
   {"uCFA0p", "kh", "w", "@", NULL},
   {"uCFA1p", "kh", "w", "@", NULL},
   {"uCFA2p", "kh", "w", "@", NULL},
   {"uCFA3p", "kh", "w", "@", NULL},
   {"uCFA4p", "kh", "w", "@", NULL},
   {"uCFA5p", "kh", "w", "@", NULL},
   {"uCFA6p", "kh", "w", "@", NULL},
   {"uCFA7p", "kh", "w", "@", NULL},
   {"uCFA8p", "kh", "w", "e", NULL},
   {"uCFA9p", "kh", "w", "e", NULL},
   {"uCFAAp", "kh", "w", "e", NULL},
   {"uCFABp", "kh", "w", "e", NULL},
   {"uCFACp", "kh", "w", "e", NULL},
   {"uCFADp", "kh", "w", "e", NULL},
   {"uCFAEp", "kh", "w", "e", NULL},
   {"uCFAFp", "kh", "w", "e", NULL},
   {"uCFB0p", "kh", "w", "e", NULL},
   {"uCFB1p", "kh", "w", "e", NULL},
   {"uCFB2p", "kh", "w", "e", NULL},
   {"uCFB3p", "kh", "w", "e", NULL},
   {"uCFB4p", "kh", "w", "e", NULL},
   {"uCFB5p", "kh", "w", "e", NULL},
   {"uCFB6p", "kh", "w", "e", NULL},
   {"uCFB7p", "kh", "w", "e", NULL},
   {"uCFB8p", "kh", "w", "e", NULL},
   {"uCFB9p", "kh", "w", "e", NULL},
   {"uCFBAp", "kh", "w", "e", NULL},
   {"uCFBBp", "kh", "w", "e", NULL},
   {"uCFBCp", "kh", "w", "e", NULL},
   {"uCFBDp", "kh", "w", "e", NULL},
   {"uCFBEp", "kh", "w", "e", NULL},
   {"uCFBFp", "kh", "w", "e", NULL},
   {"uCFC0p", "kh", "w", "e", NULL},
   {"uCFC1p", "kh", "w", "e", NULL},
   {"uCFC2p", "kh", "w", "e", NULL},
   {"uCFC3p", "kh", "w", "e", NULL},
   {"uCFC4p", "kh", "j", "o", NULL},
   {"uCFC5p", "kh", "j", "o", NULL},
   {"uCFC6p", "kh", "j", "o", NULL},
   {"uCFC7p", "kh", "j", "o", NULL},
   {"uCFC8p", "kh", "j", "o", NULL},
   {"uCFC9p", "kh", "j", "o", NULL},
   {"uCFCAp", "kh", "j", "o", NULL},
   {"uCFCBp", "kh", "j", "o", NULL},
   {"uCFCCp", "kh", "j", "o", NULL},
   {"uCFCDp", "kh", "j", "o", NULL},
   {"uCFCEp", "kh", "j", "o", NULL},
   {"uCFCFp", "kh", "j", "o", NULL},
   {"uCFD0p", "kh", "j", "o", NULL},
   {"uCFD1p", "kh", "j", "o", NULL},
   {"uCFD2p", "kh", "j", "o", NULL},
   {"uCFD3p", "kh", "j", "o", NULL},
   {"uCFD4p", "kh", "j", "o", NULL},
   {"uCFD5p", "kh", "j", "o", NULL},
   {"uCFD6p", "kh", "j", "o", NULL},
   {"uCFD7p", "kh", "j", "o", NULL},
   {"uCFD8p", "kh", "j", "o", NULL},
   {"uCFD9p", "kh", "j", "o", NULL},
   {"uCFDAp", "kh", "j", "o", NULL},
   {"uCFDBp", "kh", "j", "o", NULL},
   {"uCFDCp", "kh", "j", "o", NULL},
   {"uCFDDp", "kh", "j", "o", NULL},
   {"uCFDEp", "kh", "j", "o", NULL},
   {"uCFDFp", "kh", "j", "o", NULL},
   {"uCFE0p", "kh", "u", NULL, NULL},
   {"uCFE1p", "kh", "u", "k", NULL},
   {"uCFE2p", "kh", "u", "kGT", NULL},
   {"uCFE3p", "kh", "u", "k", NULL},
   {"uCFE4p", "kh", "u", "n", NULL},
   {"uCFE5p", "kh", "u", "n", NULL},
   {"uCFE6p", "kh", "u", "n", NULL},
   {"uCFE7p", "kh", "u", "t", NULL},
   {"uCFE8p", "kh", "u", "l", NULL},
   {"uCFE9p", "kh", "u", "l", NULL},
   {"uCFEAp", "kh", "u", "l", NULL},
   {"uCFEBp", "kh", "u", "l", NULL},
   {"uCFECp", "kh", "u", "l", NULL},
   {"uCFEDp", "kh", "u", "l", NULL},
   {"uCFEEp", "kh", "u", "l", NULL},
   {"uCFEFp", "kh", "u", "l", NULL},
   {"uCFF0p", "kh", "u", "m", NULL},
   {"uCFF1p", "kh", "u", "p", NULL},
   {"uCFF2p", "kh", "u", "p", NULL},
   {"uCFF3p", "kh", "u", "sh", NULL},
   {"uCFF4p", "kh", "u", "s", NULL},
   {"uCFF5p", "kh", "u", "N", NULL},
   {"uCFF6p", "kh", "u", "tS", NULL},
   {"uCFF7p", "kh", "u", "tSh", NULL},
   {"uCFF8p", "kh", "u", "kh", NULL},
   {"uCFF9p", "kh", "u", "th", NULL},
   {"uCFFAp", "kh", "u", "ph", NULL},
   {"uCFFBp", "kh", "u", "h", NULL},
   {"uCFFCp", "kh", "w", "^", NULL},
   {"uCFFDp", "kh", "w", "^", NULL},
   {"uCFFEp", "kh", "w", "^", NULL},
   {"uCFFFp", "kh", "w", "^", NULL},
   {"uD000p", "kh", "w", "^", NULL},
   {"uD001p", "kh", "w", "^", NULL},
   {"uD002p", "kh", "w", "^", NULL},
   {"uD003p", "kh", "w", "^", NULL},
   {"uD004p", "kh", "w", "^", NULL},
   {"uD005p", "kh", "w", "^", NULL},
   {"uD006p", "kh", "w", "^", NULL},
   {"uD007p", "kh", "w", "^", NULL},
   {"uD008p", "kh", "w", "^", NULL},
   {"uD009p", "kh", "w", "^", NULL},
   {"uD00Ap", "kh", "w", "^", NULL},
   {"uD00Bp", "kh", "w", "^", NULL},
   {"uD00Cp", "kh", "w", "^", NULL},
   {"uD00Dp", "kh", "w", "^", NULL},
   {"uD00Ep", "kh", "w", "^", NULL},
   {"uD00Fp", "kh", "w", "^", NULL},
   {"uD010p", "kh", "w", "^", NULL},
   {"uD011p", "kh", "w", "^", NULL},
   {"uD012p", "kh", "w", "^", NULL},
   {"uD013p", "kh", "w", "^", NULL},
   {"uD014p", "kh", "w", "^", NULL},
   {"uD015p", "kh", "w", "^", NULL},
   {"uD016p", "kh", "w", "^", NULL},
   {"uD017p", "kh", "w", "^", NULL},
   {"uD018p", "kh", "w", "e", NULL},
   {"uD019p", "kh", "w", "e", NULL},
   {"uD01Ap", "kh", "w", "e", NULL},
   {"uD01Bp", "kh", "w", "e", NULL},
   {"uD01Cp", "kh", "w", "e", NULL},
   {"uD01Dp", "kh", "w", "e", NULL},
   {"uD01Ep", "kh", "w", "e", NULL},
   {"uD01Fp", "kh", "w", "e", NULL},
   {"uD020p", "kh", "w", "e", NULL},
   {"uD021p", "kh", "w", "e", NULL},
   {"uD022p", "kh", "w", "e", NULL},
   {"uD023p", "kh", "w", "e", NULL},
   {"uD024p", "kh", "w", "e", NULL},
   {"uD025p", "kh", "w", "e", NULL},
   {"uD026p", "kh", "w", "e", NULL},
   {"uD027p", "kh", "w", "e", NULL},
   {"uD028p", "kh", "w", "e", NULL},
   {"uD029p", "kh", "w", "e", NULL},
   {"uD02Ap", "kh", "w", "e", NULL},
   {"uD02Bp", "kh", "w", "e", NULL},
   {"uD02Cp", "kh", "w", "e", NULL},
   {"uD02Dp", "kh", "w", "e", NULL},
   {"uD02Ep", "kh", "w", "e", NULL},
   {"uD02Fp", "kh", "w", "e", NULL},
   {"uD030p", "kh", "w", "e", NULL},
   {"uD031p", "kh", "w", "e", NULL},
   {"uD032p", "kh", "w", "e", NULL},
   {"uD033p", "kh", "w", "e", NULL},
   {"uD034p", "kh", "7", NULL, NULL},
   {"uD035p", "kh", "7", "k", NULL},
   {"uD036p", "kh", "7", "kGT", NULL},
   {"uD037p", "kh", "7", "k", NULL},
   {"uD038p", "kh", "7", "n", NULL},
   {"uD039p", "kh", "7", "n", NULL},
   {"uD03Ap", "kh", "7", "n", NULL},
   {"uD03Bp", "kh", "7", "t", NULL},
   {"uD03Cp", "kh", "7", "l", NULL},
   {"uD03Dp", "kh", "7", "l", NULL},
   {"uD03Ep", "kh", "7", "l", NULL},
   {"uD03Fp", "kh", "7", "l", NULL},
   {"uD040p", "kh", "7", "l", NULL},
   {"uD041p", "kh", "7", "l", NULL},
   {"uD042p", "kh", "7", "l", NULL},
   {"uD043p", "kh", "7", "l", NULL},
   {"uD044p", "kh", "7", "m", NULL},
   {"uD045p", "kh", "7", "p", NULL},
   {"uD046p", "kh", "7", "p", NULL},
   {"uD047p", "kh", "7", "sh", NULL},
   {"uD048p", "kh", "7", "s", NULL},
   {"uD049p", "kh", "7", "N", NULL},
   {"uD04Ap", "kh", "7", "tS", NULL},
   {"uD04Bp", "kh", "7", "tSh", NULL},
   {"uD04Cp", "kh", "7", "kh", NULL},
   {"uD04Dp", "kh", "7", "th", NULL},
   {"uD04Ep", "kh", "7", "ph", NULL},
   {"uD04Fp", "kh", "7", "h", NULL},
   {"uD050p", "kh", "j", "u", NULL},
   {"uD051p", "kh", "j", "u", NULL},
   {"uD052p", "kh", "j", "u", NULL},
   {"uD053p", "kh", "j", "u", NULL},
   {"uD054p", "kh", "j", "u", NULL},
   {"uD055p", "kh", "j", "u", NULL},
   {"uD056p", "kh", "j", "u", NULL},
   {"uD057p", "kh", "j", "u", NULL},
   {"uD058p", "kh", "j", "u", NULL},
   {"uD059p", "kh", "j", "u", NULL},
   {"uD05Ap", "kh", "j", "u", NULL},
   {"uD05Bp", "kh", "j", "u", NULL},
   {"uD05Cp", "kh", "j", "u", NULL},
   {"uD05Dp", "kh", "j", "u", NULL},
   {"uD05Ep", "kh", "j", "u", NULL},
   {"uD05Fp", "kh", "j", "u", NULL},
   {"uD060p", "kh", "j", "u", NULL},
   {"uD061p", "kh", "j", "u", NULL},
   {"uD062p", "kh", "j", "u", NULL},
   {"uD063p", "kh", "j", "u", NULL},
   {"uD064p", "kh", "j", "u", NULL},
   {"uD065p", "kh", "j", "u", NULL},
   {"uD066p", "kh", "j", "u", NULL},
   {"uD067p", "kh", "j", "u", NULL},
   {"uD068p", "kh", "j", "u", NULL},
   {"uD069p", "kh", "j", "u", NULL},
   {"uD06Ap", "kh", "j", "u", NULL},
   {"uD06Bp", "kh", "j", "u", NULL},
   {"uD06Cp", "kh", "4", NULL, NULL},
   {"uD06Dp", "kh", "4", "k", NULL},
   {"uD06Ep", "kh", "4", "kGT", NULL},
   {"uD06Fp", "kh", "4", "k", NULL},
   {"uD070p", "kh", "4", "n", NULL},
   {"uD071p", "kh", "4", "n", NULL},
   {"uD072p", "kh", "4", "n", NULL},
   {"uD073p", "kh", "4", "t", NULL},
   {"uD074p", "kh", "4", "l", NULL},
   {"uD075p", "kh", "4", "l", NULL},
   {"uD076p", "kh", "4", "l", NULL},
   {"uD077p", "kh", "4", "l", NULL},
   {"uD078p", "kh", "4", "l", NULL},
   {"uD079p", "kh", "4", "l", NULL},
   {"uD07Ap", "kh", "4", "l", NULL},
   {"uD07Bp", "kh", "4", "l", NULL},
   {"uD07Cp", "kh", "4", "m", NULL},
   {"uD07Dp", "kh", "4", "p", NULL},
   {"uD07Ep", "kh", "4", "p", NULL},
   {"uD07Fp", "kh", "4", "sh", NULL},
   {"uD080p", "kh", "4", "s", NULL},
   {"uD081p", "kh", "4", "N", NULL},
   {"uD082p", "kh", "4", "tS", NULL},
   {"uD083p", "kh", "4", "tSh", NULL},
   {"uD084p", "kh", "4", "kh", NULL},
   {"uD085p", "kh", "4", "th", NULL},
   {"uD086p", "kh", "4", "ph", NULL},
   {"uD087p", "kh", "4", "h", NULL},
   {"uD088p", "kh", "4", "j", NULL},
   {"uD089p", "kh", "4", "j", NULL},
   {"uD08Ap", "kh", "4", "j", NULL},
   {"uD08Bp", "kh", "4", "j", NULL},
   {"uD08Cp", "kh", "4", "j", NULL},
   {"uD08Dp", "kh", "4", "j", NULL},
   {"uD08Ep", "kh", "4", "j", NULL},
   {"uD08Fp", "kh", "4", "j", NULL},
   {"uD090p", "kh", "4", "j", NULL},
   {"uD091p", "kh", "4", "j", NULL},
   {"uD092p", "kh", "4", "j", NULL},
   {"uD093p", "kh", "4", "j", NULL},
   {"uD094p", "kh", "4", "j", NULL},
   {"uD095p", "kh", "4", "j", NULL},
   {"uD096p", "kh", "4", "j", NULL},
   {"uD097p", "kh", "4", "j", NULL},
   {"uD098p", "kh", "4", "j", NULL},
   {"uD099p", "kh", "4", "j", NULL},
   {"uD09Ap", "kh", "4", "j", NULL},
   {"uD09Bp", "kh", "4", "j", NULL},
   {"uD09Cp", "kh", "4", "j", NULL},
   {"uD09Dp", "kh", "4", "j", NULL},
   {"uD09Ep", "kh", "4", "j", NULL},
   {"uD09Fp", "kh", "4", "j", NULL},
   {"uD0A0p", "kh", "4", "j", NULL},
   {"uD0A1p", "kh", "4", "j", NULL},
   {"uD0A2p", "kh", "4", "j", NULL},
   {"uD0A3p", "kh", "4", "j", NULL},
   {"uD0A4p", "kh", "i", NULL, NULL},
   {"uD0A5p", "kh", "i", "k", NULL},
   {"uD0A6p", "kh", "i", "kGT", NULL},
   {"uD0A7p", "kh", "i", "k", NULL},
   {"uD0A8p", "kh", "i", "n", NULL},
   {"uD0A9p", "kh", "i", "n", NULL},
   {"uD0AAp", "kh", "i", "n", NULL},
   {"uD0ABp", "kh", "i", "t", NULL},
   {"uD0ACp", "kh", "i", "l", NULL},
   {"uD0ADp", "kh", "i", "l", NULL},
   {"uD0AEp", "kh", "i", "l", NULL},
   {"uD0AFp", "kh", "i", "l", NULL},
   {"uD0B0p", "kh", "i", "l", NULL},
   {"uD0B1p", "kh", "i", "l", NULL},
   {"uD0B2p", "kh", "i", "l", NULL},
   {"uD0B3p", "kh", "i", "l", NULL},
   {"uD0B4p", "kh", "i", "m", NULL},
   {"uD0B5p", "kh", "i", "p", NULL},
   {"uD0B6p", "kh", "i", "p", NULL},
   {"uD0B7p", "kh", "i", "sh", NULL},
   {"uD0B8p", "kh", "i", "s", NULL},
   {"uD0B9p", "kh", "i", "N", NULL},
   {"uD0BAp", "kh", "i", "tS", NULL},
   {"uD0BBp", "kh", "i", "tSh", NULL},
   {"uD0BCp", "kh", "i", "kh", NULL},
   {"uD0BDp", "kh", "i", "th", NULL},
   {"uD0BEp", "kh", "i", "ph", NULL},
   {"uD0BFp", "kh", "i", "h", NULL},
   {"uD0C0p", "th", "a", NULL, NULL},
   {"uD0C1p", "th", "a", "k", NULL},
   {"uD0C2p", "th", "a", "kGT", NULL},
   {"uD0C3p", "th", "a", "k", NULL},
   {"uD0C4p", "th", "a", "n", NULL},
   {"uD0C5p", "th", "a", "n", NULL},
   {"uD0C6p", "th", "a", "n", NULL},
   {"uD0C7p", "th", "a", "t", NULL},
   {"uD0C8p", "th", "a", "l", NULL},
   {"uD0C9p", "th", "a", "l", NULL},
   {"uD0CAp", "th", "a", "l", NULL},
   {"uD0CBp", "th", "a", "l", NULL},
   {"uD0CCp", "th", "a", "l", NULL},
   {"uD0CDp", "th", "a", "l", NULL},
   {"uD0CEp", "th", "a", "l", NULL},
   {"uD0CFp", "th", "a", "l", NULL},
   {"uD0D0p", "th", "a", "m", NULL},
   {"uD0D1p", "th", "a", "p", NULL},
   {"uD0D2p", "th", "a", "p", NULL},
   {"uD0D3p", "th", "a", "sh", NULL},
   {"uD0D4p", "th", "a", "s", NULL},
   {"uD0D5p", "th", "a", "N", NULL},
   {"uD0D6p", "th", "a", "tS", NULL},
   {"uD0D7p", "th", "a", "tSh", NULL},
   {"uD0D8p", "th", "a", "kh", NULL},
   {"uD0D9p", "th", "a", "th", NULL},
   {"uD0DAp", "th", "a", "ph", NULL},
   {"uD0DBp", "th", "a", "h", NULL},
   {"uD0DCp", "th", "@", NULL, NULL},
   {"uD0DDp", "th", "@", "k", NULL},
   {"uD0DEp", "th", "@", "kGT", NULL},
   {"uD0DFp", "th", "@", "k", NULL},
   {"uD0E0p", "th", "@", "n", NULL},
   {"uD0E1p", "th", "@", "n", NULL},
   {"uD0E2p", "th", "@", "n", NULL},
   {"uD0E3p", "th", "@", "t", NULL},
   {"uD0E4p", "th", "@", "l", NULL},
   {"uD0E5p", "th", "@", "l", NULL},
   {"uD0E6p", "th", "@", "l", NULL},
   {"uD0E7p", "th", "@", "l", NULL},
   {"uD0E8p", "th", "@", "l", NULL},
   {"uD0E9p", "th", "@", "l", NULL},
   {"uD0EAp", "th", "@", "l", NULL},
   {"uD0EBp", "th", "@", "l", NULL},
   {"uD0ECp", "th", "@", "m", NULL},
   {"uD0EDp", "th", "@", "p", NULL},
   {"uD0EEp", "th", "@", "p", NULL},
   {"uD0EFp", "th", "@", "sh", NULL},
   {"uD0F0p", "th", "@", "s", NULL},
   {"uD0F1p", "th", "@", "N", NULL},
   {"uD0F2p", "th", "@", "tS", NULL},
   {"uD0F3p", "th", "@", "tSh", NULL},
   {"uD0F4p", "th", "@", "kh", NULL},
   {"uD0F5p", "th", "@", "th", NULL},
   {"uD0F6p", "th", "@", "ph", NULL},
   {"uD0F7p", "th", "@", "h", NULL},
   {"uD0F8p", "th", "j", "a", NULL},
   {"uD0F9p", "th", "j", "a", NULL},
   {"uD0FAp", "th", "j", "a", NULL},
   {"uD0FBp", "th", "j", "a", NULL},
   {"uD0FCp", "th", "j", "a", NULL},
   {"uD0FDp", "th", "j", "a", NULL},
   {"uD0FEp", "th", "j", "a", NULL},
   {"uD0FFp", "th", "j", "a", NULL},
   {"uD100p", "th", "j", "a", NULL},
   {"uD101p", "th", "j", "a", NULL},
   {"uD102p", "th", "j", "a", NULL},
   {"uD103p", "th", "j", "a", NULL},
   {"uD104p", "th", "j", "a", NULL},
   {"uD105p", "th", "j", "a", NULL},
   {"uD106p", "th", "j", "a", NULL},
   {"uD107p", "th", "j", "a", NULL},
   {"uD108p", "th", "j", "a", NULL},
   {"uD109p", "th", "j", "a", NULL},
   {"uD10Ap", "th", "j", "a", NULL},
   {"uD10Bp", "th", "j", "a", NULL},
   {"uD10Cp", "th", "j", "a", NULL},
   {"uD10Dp", "th", "j", "a", NULL},
   {"uD10Ep", "th", "j", "a", NULL},
   {"uD10Fp", "th", "j", "a", NULL},
   {"uD110p", "th", "j", "a", NULL},
   {"uD111p", "th", "j", "a", NULL},
   {"uD112p", "th", "j", "a", NULL},
   {"uD113p", "th", "j", "a", NULL},
   {"uD114p", "th", "j", "@", NULL},
   {"uD115p", "th", "j", "@", NULL},
   {"uD116p", "th", "j", "@", NULL},
   {"uD117p", "th", "j", "@", NULL},
   {"uD118p", "th", "j", "@", NULL},
   {"uD119p", "th", "j", "@", NULL},
   {"uD11Ap", "th", "j", "@", NULL},
   {"uD11Bp", "th", "j", "@", NULL},
   {"uD11Cp", "th", "j", "@", NULL},
   {"uD11Dp", "th", "j", "@", NULL},
   {"uD11Ep", "th", "j", "@", NULL},
   {"uD11Fp", "th", "j", "@", NULL},
   {"uD120p", "th", "j", "@", NULL},
   {"uD121p", "th", "j", "@", NULL},
   {"uD122p", "th", "j", "@", NULL},
   {"uD123p", "th", "j", "@", NULL},
   {"uD124p", "th", "j", "@", NULL},
   {"uD125p", "th", "j", "@", NULL},
   {"uD126p", "th", "j", "@", NULL},
   {"uD127p", "th", "j", "@", NULL},
   {"uD128p", "th", "j", "@", NULL},
   {"uD129p", "th", "j", "@", NULL},
   {"uD12Ap", "th", "j", "@", NULL},
   {"uD12Bp", "th", "j", "@", NULL},
   {"uD12Cp", "th", "j", "@", NULL},
   {"uD12Dp", "th", "j", "@", NULL},
   {"uD12Ep", "th", "j", "@", NULL},
   {"uD12Fp", "th", "j", "@", NULL},
   {"uD130p", "th", "^", NULL, NULL},
   {"uD131p", "th", "^", "k", NULL},
   {"uD132p", "th", "^", "kGT", NULL},
   {"uD133p", "th", "^", "k", NULL},
   {"uD134p", "th", "^", "n", NULL},
   {"uD135p", "th", "^", "n", NULL},
   {"uD136p", "th", "^", "n", NULL},
   {"uD137p", "th", "^", "t", NULL},
   {"uD138p", "th", "^", "l", NULL},
   {"uD139p", "th", "^", "l", NULL},
   {"uD13Ap", "th", "^", "l", NULL},
   {"uD13Bp", "th", "^", "l", NULL},
   {"uD13Cp", "th", "^", "l", NULL},
   {"uD13Dp", "th", "^", "l", NULL},
   {"uD13Ep", "th", "^", "l", NULL},
   {"uD13Fp", "th", "^", "l", NULL},
   {"uD140p", "th", "^", "m", NULL},
   {"uD141p", "th", "^", "p", NULL},
   {"uD142p", "th", "^", "p", NULL},
   {"uD143p", "th", "^", "sh", NULL},
   {"uD144p", "th", "^", "s", NULL},
   {"uD145p", "th", "^", "N", NULL},
   {"uD146p", "th", "^", "tS", NULL},
   {"uD147p", "th", "^", "tSh", NULL},
   {"uD148p", "th", "^", "kh", NULL},
   {"uD149p", "th", "^", "th", NULL},
   {"uD14Ap", "th", "^", "ph", NULL},
   {"uD14Bp", "th", "^", "h", NULL},
   {"uD14Cp", "th", "e", NULL, NULL},
   {"uD14Dp", "th", "e", "k", NULL},
   {"uD14Ep", "th", "e", "kGT", NULL},
   {"uD14Fp", "th", "e", "k", NULL},
   {"uD150p", "th", "e", "n", NULL},
   {"uD151p", "th", "e", "n", NULL},
   {"uD152p", "th", "e", "n", NULL},
   {"uD153p", "th", "e", "t", NULL},
   {"uD154p", "th", "e", "l", NULL},
   {"uD155p", "th", "e", "l", NULL},
   {"uD156p", "th", "e", "l", NULL},
   {"uD157p", "th", "e", "l", NULL},
   {"uD158p", "th", "e", "l", NULL},
   {"uD159p", "th", "e", "l", NULL},
   {"uD15Ap", "th", "e", "l", NULL},
   {"uD15Bp", "th", "e", "l", NULL},
   {"uD15Cp", "th", "e", "m", NULL},
   {"uD15Dp", "th", "e", "p", NULL},
   {"uD15Ep", "th", "e", "p", NULL},
   {"uD15Fp", "th", "e", "sh", NULL},
   {"uD160p", "th", "e", "s", NULL},
   {"uD161p", "th", "e", "N", NULL},
   {"uD162p", "th", "e", "tS", NULL},
   {"uD163p", "th", "e", "tSh", NULL},
   {"uD164p", "th", "e", "kh", NULL},
   {"uD165p", "th", "e", "th", NULL},
   {"uD166p", "th", "e", "ph", NULL},
   {"uD167p", "th", "e", "h", NULL},
   {"uD168p", "th", "j", "^", NULL},
   {"uD169p", "th", "j", "^", NULL},
   {"uD16Ap", "th", "j", "^", NULL},
   {"uD16Bp", "th", "j", "^", NULL},
   {"uD16Cp", "th", "j", "^", NULL},
   {"uD16Dp", "th", "j", "^", NULL},
   {"uD16Ep", "th", "j", "^", NULL},
   {"uD16Fp", "th", "j", "^", NULL},
   {"uD170p", "th", "j", "^", NULL},
   {"uD171p", "th", "j", "^", NULL},
   {"uD172p", "th", "j", "^", NULL},
   {"uD173p", "th", "j", "^", NULL},
   {"uD174p", "th", "j", "^", NULL},
   {"uD175p", "th", "j", "^", NULL},
   {"uD176p", "th", "j", "^", NULL},
   {"uD177p", "th", "j", "^", NULL},
   {"uD178p", "th", "j", "^", NULL},
   {"uD179p", "th", "j", "^", NULL},
   {"uD17Ap", "th", "j", "^", NULL},
   {"uD17Bp", "th", "j", "^", NULL},
   {"uD17Cp", "th", "j", "^", NULL},
   {"uD17Dp", "th", "j", "^", NULL},
   {"uD17Ep", "th", "j", "^", NULL},
   {"uD17Fp", "th", "j", "^", NULL},
   {"uD180p", "th", "j", "^", NULL},
   {"uD181p", "th", "j", "^", NULL},
   {"uD182p", "th", "j", "^", NULL},
   {"uD183p", "th", "j", "^", NULL},
   {"uD184p", "th", "j", "e", NULL},
   {"uD185p", "th", "j", "e", NULL},
   {"uD186p", "th", "j", "e", NULL},
   {"uD187p", "th", "j", "e", NULL},
   {"uD188p", "th", "j", "e", NULL},
   {"uD189p", "th", "j", "e", NULL},
   {"uD18Ap", "th", "j", "e", NULL},
   {"uD18Bp", "th", "j", "e", NULL},
   {"uD18Cp", "th", "j", "e", NULL},
   {"uD18Dp", "th", "j", "e", NULL},
   {"uD18Ep", "th", "j", "e", NULL},
   {"uD18Fp", "th", "j", "e", NULL},
   {"uD190p", "th", "j", "e", NULL},
   {"uD191p", "th", "j", "e", NULL},
   {"uD192p", "th", "j", "e", NULL},
   {"uD193p", "th", "j", "e", NULL},
   {"uD194p", "th", "j", "e", NULL},
   {"uD195p", "th", "j", "e", NULL},
   {"uD196p", "th", "j", "e", NULL},
   {"uD197p", "th", "j", "e", NULL},
   {"uD198p", "th", "j", "e", NULL},
   {"uD199p", "th", "j", "e", NULL},
   {"uD19Ap", "th", "j", "e", NULL},
   {"uD19Bp", "th", "j", "e", NULL},
   {"uD19Cp", "th", "j", "e", NULL},
   {"uD19Dp", "th", "j", "e", NULL},
   {"uD19Ep", "th", "j", "e", NULL},
   {"uD19Fp", "th", "j", "e", NULL},
   {"uD1A0p", "th", "o", NULL, NULL},
   {"uD1A1p", "th", "o", "k", NULL},
   {"uD1A2p", "th", "o", "kGT", NULL},
   {"uD1A3p", "th", "o", "k", NULL},
   {"uD1A4p", "th", "o", "n", NULL},
   {"uD1A5p", "th", "o", "n", NULL},
   {"uD1A6p", "th", "o", "n", NULL},
   {"uD1A7p", "th", "o", "t", NULL},
   {"uD1A8p", "th", "o", "l", NULL},
   {"uD1A9p", "th", "o", "l", NULL},
   {"uD1AAp", "th", "o", "l", NULL},
   {"uD1ABp", "th", "o", "l", NULL},
   {"uD1ACp", "th", "o", "l", NULL},
   {"uD1ADp", "th", "o", "l", NULL},
   {"uD1AEp", "th", "o", "l", NULL},
   {"uD1AFp", "th", "o", "l", NULL},
   {"uD1B0p", "th", "o", "m", NULL},
   {"uD1B1p", "th", "o", "p", NULL},
   {"uD1B2p", "th", "o", "p", NULL},
   {"uD1B3p", "th", "o", "sh", NULL},
   {"uD1B4p", "th", "o", "s", NULL},
   {"uD1B5p", "th", "o", "N", NULL},
   {"uD1B6p", "th", "o", "tS", NULL},
   {"uD1B7p", "th", "o", "tSh", NULL},
   {"uD1B8p", "th", "o", "kh", NULL},
   {"uD1B9p", "th", "o", "th", NULL},
   {"uD1BAp", "th", "o", "ph", NULL},
   {"uD1BBp", "th", "o", "h", NULL},
   {"uD1BCp", "th", "w", "a", NULL},
   {"uD1BDp", "th", "w", "a", NULL},
   {"uD1BEp", "th", "w", "a", NULL},
   {"uD1BFp", "th", "w", "a", NULL},
   {"uD1C0p", "th", "w", "a", NULL},
   {"uD1C1p", "th", "w", "a", NULL},
   {"uD1C2p", "th", "w", "a", NULL},
   {"uD1C3p", "th", "w", "a", NULL},
   {"uD1C4p", "th", "w", "a", NULL},
   {"uD1C5p", "th", "w", "a", NULL},
   {"uD1C6p", "th", "w", "a", NULL},
   {"uD1C7p", "th", "w", "a", NULL},
   {"uD1C8p", "th", "w", "a", NULL},
   {"uD1C9p", "th", "w", "a", NULL},
   {"uD1CAp", "th", "w", "a", NULL},
   {"uD1CBp", "th", "w", "a", NULL},
   {"uD1CCp", "th", "w", "a", NULL},
   {"uD1CDp", "th", "w", "a", NULL},
   {"uD1CEp", "th", "w", "a", NULL},
   {"uD1CFp", "th", "w", "a", NULL},
   {"uD1D0p", "th", "w", "a", NULL},
   {"uD1D1p", "th", "w", "a", NULL},
   {"uD1D2p", "th", "w", "a", NULL},
   {"uD1D3p", "th", "w", "a", NULL},
   {"uD1D4p", "th", "w", "a", NULL},
   {"uD1D5p", "th", "w", "a", NULL},
   {"uD1D6p", "th", "w", "a", NULL},
   {"uD1D7p", "th", "w", "a", NULL},
   {"uD1D8p", "th", "w", "@", NULL},
   {"uD1D9p", "th", "w", "@", NULL},
   {"uD1DAp", "th", "w", "@", NULL},
   {"uD1DBp", "th", "w", "@", NULL},
   {"uD1DCp", "th", "w", "@", NULL},
   {"uD1DDp", "th", "w", "@", NULL},
   {"uD1DEp", "th", "w", "@", NULL},
   {"uD1DFp", "th", "w", "@", NULL},
   {"uD1E0p", "th", "w", "@", NULL},
   {"uD1E1p", "th", "w", "@", NULL},
   {"uD1E2p", "th", "w", "@", NULL},
   {"uD1E3p", "th", "w", "@", NULL},
   {"uD1E4p", "th", "w", "@", NULL},
   {"uD1E5p", "th", "w", "@", NULL},
   {"uD1E6p", "th", "w", "@", NULL},
   {"uD1E7p", "th", "w", "@", NULL},
   {"uD1E8p", "th", "w", "@", NULL},
   {"uD1E9p", "th", "w", "@", NULL},
   {"uD1EAp", "th", "w", "@", NULL},
   {"uD1EBp", "th", "w", "@", NULL},
   {"uD1ECp", "th", "w", "@", NULL},
   {"uD1EDp", "th", "w", "@", NULL},
   {"uD1EEp", "th", "w", "@", NULL},
   {"uD1EFp", "th", "w", "@", NULL},
   {"uD1F0p", "th", "w", "@", NULL},
   {"uD1F1p", "th", "w", "@", NULL},
   {"uD1F2p", "th", "w", "@", NULL},
   {"uD1F3p", "th", "w", "@", NULL},
   {"uD1F4p", "th", "w", "e", NULL},
   {"uD1F5p", "th", "w", "e", NULL},
   {"uD1F6p", "th", "w", "e", NULL},
   {"uD1F7p", "th", "w", "e", NULL},
   {"uD1F8p", "th", "w", "e", NULL},
   {"uD1F9p", "th", "w", "e", NULL},
   {"uD1FAp", "th", "w", "e", NULL},
   {"uD1FBp", "th", "w", "e", NULL},
   {"uD1FCp", "th", "w", "e", NULL},
   {"uD1FDp", "th", "w", "e", NULL},
   {"uD1FEp", "th", "w", "e", NULL},
   {"uD1FFp", "th", "w", "e", NULL},
   {"uD200p", "th", "w", "e", NULL},
   {"uD201p", "th", "w", "e", NULL},
   {"uD202p", "th", "w", "e", NULL},
   {"uD203p", "th", "w", "e", NULL},
   {"uD204p", "th", "w", "e", NULL},
   {"uD205p", "th", "w", "e", NULL},
   {"uD206p", "th", "w", "e", NULL},
   {"uD207p", "th", "w", "e", NULL},
   {"uD208p", "th", "w", "e", NULL},
   {"uD209p", "th", "w", "e", NULL},
   {"uD20Ap", "th", "w", "e", NULL},
   {"uD20Bp", "th", "w", "e", NULL},
   {"uD20Cp", "th", "w", "e", NULL},
   {"uD20Dp", "th", "w", "e", NULL},
   {"uD20Ep", "th", "w", "e", NULL},
   {"uD20Fp", "th", "w", "e", NULL},
   {"uD210p", "th", "j", "o", NULL},
   {"uD211p", "th", "j", "o", NULL},
   {"uD212p", "th", "j", "o", NULL},
   {"uD213p", "th", "j", "o", NULL},
   {"uD214p", "th", "j", "o", NULL},
   {"uD215p", "th", "j", "o", NULL},
   {"uD216p", "th", "j", "o", NULL},
   {"uD217p", "th", "j", "o", NULL},
   {"uD218p", "th", "j", "o", NULL},
   {"uD219p", "th", "j", "o", NULL},
   {"uD21Ap", "th", "j", "o", NULL},
   {"uD21Bp", "th", "j", "o", NULL},
   {"uD21Cp", "th", "j", "o", NULL},
   {"uD21Dp", "th", "j", "o", NULL},
   {"uD21Ep", "th", "j", "o", NULL},
   {"uD21Fp", "th", "j", "o", NULL},
   {"uD220p", "th", "j", "o", NULL},
   {"uD221p", "th", "j", "o", NULL},
   {"uD222p", "th", "j", "o", NULL},
   {"uD223p", "th", "j", "o", NULL},
   {"uD224p", "th", "j", "o", NULL},
   {"uD225p", "th", "j", "o", NULL},
   {"uD226p", "th", "j", "o", NULL},
   {"uD227p", "th", "j", "o", NULL},
   {"uD228p", "th", "j", "o", NULL},
   {"uD229p", "th", "j", "o", NULL},
   {"uD22Ap", "th", "j", "o", NULL},
   {"uD22Bp", "th", "j", "o", NULL},
   {"uD22Cp", "th", "u", NULL, NULL},
   {"uD22Dp", "th", "u", "k", NULL},
   {"uD22Ep", "th", "u", "kGT", NULL},
   {"uD22Fp", "th", "u", "k", NULL},
   {"uD230p", "th", "u", "n", NULL},
   {"uD231p", "th", "u", "n", NULL},
   {"uD232p", "th", "u", "n", NULL},
   {"uD233p", "th", "u", "t", NULL},
   {"uD234p", "th", "u", "l", NULL},
   {"uD235p", "th", "u", "l", NULL},
   {"uD236p", "th", "u", "l", NULL},
   {"uD237p", "th", "u", "l", NULL},
   {"uD238p", "th", "u", "l", NULL},
   {"uD239p", "th", "u", "l", NULL},
   {"uD23Ap", "th", "u", "l", NULL},
   {"uD23Bp", "th", "u", "l", NULL},
   {"uD23Cp", "th", "u", "m", NULL},
   {"uD23Dp", "th", "u", "p", NULL},
   {"uD23Ep", "th", "u", "p", NULL},
   {"uD23Fp", "th", "u", "sh", NULL},
   {"uD240p", "th", "u", "s", NULL},
   {"uD241p", "th", "u", "N", NULL},
   {"uD242p", "th", "u", "tS", NULL},
   {"uD243p", "th", "u", "tSh", NULL},
   {"uD244p", "th", "u", "kh", NULL},
   {"uD245p", "th", "u", "th", NULL},
   {"uD246p", "th", "u", "ph", NULL},
   {"uD247p", "th", "u", "h", NULL},
   {"uD248p", "th", "w", "^", NULL},
   {"uD249p", "th", "w", "^", NULL},
   {"uD24Ap", "th", "w", "^", NULL},
   {"uD24Bp", "th", "w", "^", NULL},
   {"uD24Cp", "th", "w", "^", NULL},
   {"uD24Dp", "th", "w", "^", NULL},
   {"uD24Ep", "th", "w", "^", NULL},
   {"uD24Fp", "th", "w", "^", NULL},
   {"uD250p", "th", "w", "^", NULL},
   {"uD251p", "th", "w", "^", NULL},
   {"uD252p", "th", "w", "^", NULL},
   {"uD253p", "th", "w", "^", NULL},
   {"uD254p", "th", "w", "^", NULL},
   {"uD255p", "th", "w", "^", NULL},
   {"uD256p", "th", "w", "^", NULL},
   {"uD257p", "th", "w", "^", NULL},
   {"uD258p", "th", "w", "^", NULL},
   {"uD259p", "th", "w", "^", NULL},
   {"uD25Ap", "th", "w", "^", NULL},
   {"uD25Bp", "th", "w", "^", NULL},
   {"uD25Cp", "th", "w", "^", NULL},
   {"uD25Dp", "th", "w", "^", NULL},
   {"uD25Ep", "th", "w", "^", NULL},
   {"uD25Fp", "th", "w", "^", NULL},
   {"uD260p", "th", "w", "^", NULL},
   {"uD261p", "th", "w", "^", NULL},
   {"uD262p", "th", "w", "^", NULL},
   {"uD263p", "th", "w", "^", NULL},
   {"uD264p", "th", "w", "e", NULL},
   {"uD265p", "th", "w", "e", NULL},
   {"uD266p", "th", "w", "e", NULL},
   {"uD267p", "th", "w", "e", NULL},
   {"uD268p", "th", "w", "e", NULL},
   {"uD269p", "th", "w", "e", NULL},
   {"uD26Ap", "th", "w", "e", NULL},
   {"uD26Bp", "th", "w", "e", NULL},
   {"uD26Cp", "th", "w", "e", NULL},
   {"uD26Dp", "th", "w", "e", NULL},
   {"uD26Ep", "th", "w", "e", NULL},
   {"uD26Fp", "th", "w", "e", NULL},
   {"uD270p", "th", "w", "e", NULL},
   {"uD271p", "th", "w", "e", NULL},
   {"uD272p", "th", "w", "e", NULL},
   {"uD273p", "th", "w", "e", NULL},
   {"uD274p", "th", "w", "e", NULL},
   {"uD275p", "th", "w", "e", NULL},
   {"uD276p", "th", "w", "e", NULL},
   {"uD277p", "th", "w", "e", NULL},
   {"uD278p", "th", "w", "e", NULL},
   {"uD279p", "th", "w", "e", NULL},
   {"uD27Ap", "th", "w", "e", NULL},
   {"uD27Bp", "th", "w", "e", NULL},
   {"uD27Cp", "th", "w", "e", NULL},
   {"uD27Dp", "th", "w", "e", NULL},
   {"uD27Ep", "th", "w", "e", NULL},
   {"uD27Fp", "th", "w", "e", NULL},
   {"uD280p", "th", "7", NULL, NULL},
   {"uD281p", "th", "7", "k", NULL},
   {"uD282p", "th", "7", "kGT", NULL},
   {"uD283p", "th", "7", "k", NULL},
   {"uD284p", "th", "7", "n", NULL},
   {"uD285p", "th", "7", "n", NULL},
   {"uD286p", "th", "7", "n", NULL},
   {"uD287p", "th", "7", "t", NULL},
   {"uD288p", "th", "7", "l", NULL},
   {"uD289p", "th", "7", "l", NULL},
   {"uD28Ap", "th", "7", "l", NULL},
   {"uD28Bp", "th", "7", "l", NULL},
   {"uD28Cp", "th", "7", "l", NULL},
   {"uD28Dp", "th", "7", "l", NULL},
   {"uD28Ep", "th", "7", "l", NULL},
   {"uD28Fp", "th", "7", "l", NULL},
   {"uD290p", "th", "7", "m", NULL},
   {"uD291p", "th", "7", "p", NULL},
   {"uD292p", "th", "7", "p", NULL},
   {"uD293p", "th", "7", "sh", NULL},
   {"uD294p", "th", "7", "s", NULL},
   {"uD295p", "th", "7", "N", NULL},
   {"uD296p", "th", "7", "tS", NULL},
   {"uD297p", "th", "7", "tSh", NULL},
   {"uD298p", "th", "7", "kh", NULL},
   {"uD299p", "th", "7", "th", NULL},
   {"uD29Ap", "th", "7", "ph", NULL},
   {"uD29Bp", "th", "7", "h", NULL},
   {"uD29Cp", "th", "j", "u", NULL},
   {"uD29Dp", "th", "j", "u", NULL},
   {"uD29Ep", "th", "j", "u", NULL},
   {"uD29Fp", "th", "j", "u", NULL},
   {"uD2A0p", "th", "j", "u", NULL},
   {"uD2A1p", "th", "j", "u", NULL},
   {"uD2A2p", "th", "j", "u", NULL},
   {"uD2A3p", "th", "j", "u", NULL},
   {"uD2A4p", "th", "j", "u", NULL},
   {"uD2A5p", "th", "j", "u", NULL},
   {"uD2A6p", "th", "j", "u", NULL},
   {"uD2A7p", "th", "j", "u", NULL},
   {"uD2A8p", "th", "j", "u", NULL},
   {"uD2A9p", "th", "j", "u", NULL},
   {"uD2AAp", "th", "j", "u", NULL},
   {"uD2ABp", "th", "j", "u", NULL},
   {"uD2ACp", "th", "j", "u", NULL},
   {"uD2ADp", "th", "j", "u", NULL},
   {"uD2AEp", "th", "j", "u", NULL},
   {"uD2AFp", "th", "j", "u", NULL},
   {"uD2B0p", "th", "j", "u", NULL},
   {"uD2B1p", "th", "j", "u", NULL},
   {"uD2B2p", "th", "j", "u", NULL},
   {"uD2B3p", "th", "j", "u", NULL},
   {"uD2B4p", "th", "j", "u", NULL},
   {"uD2B5p", "th", "j", "u", NULL},
   {"uD2B6p", "th", "j", "u", NULL},
   {"uD2B7p", "th", "j", "u", NULL},
   {"uD2B8p", "th", "4", NULL, NULL},
   {"uD2B9p", "th", "4", "k", NULL},
   {"uD2BAp", "th", "4", "kGT", NULL},
   {"uD2BBp", "th", "4", "k", NULL},
   {"uD2BCp", "th", "4", "n", NULL},
   {"uD2BDp", "th", "4", "n", NULL},
   {"uD2BEp", "th", "4", "n", NULL},
   {"uD2BFp", "th", "4", "t", NULL},
   {"uD2C0p", "th", "4", "l", NULL},
   {"uD2C1p", "th", "4", "l", NULL},
   {"uD2C2p", "th", "4", "l", NULL},
   {"uD2C3p", "th", "4", "l", NULL},
   {"uD2C4p", "th", "4", "l", NULL},
   {"uD2C5p", "th", "4", "l", NULL},
   {"uD2C6p", "th", "4", "l", NULL},
   {"uD2C7p", "th", "4", "l", NULL},
   {"uD2C8p", "th", "4", "m", NULL},
   {"uD2C9p", "th", "4", "p", NULL},
   {"uD2CAp", "th", "4", "p", NULL},
   {"uD2CBp", "th", "4", "sh", NULL},
   {"uD2CCp", "th", "4", "s", NULL},
   {"uD2CDp", "th", "4", "N", NULL},
   {"uD2CEp", "th", "4", "tS", NULL},
   {"uD2CFp", "th", "4", "tSh", NULL},
   {"uD2D0p", "th", "4", "kh", NULL},
   {"uD2D1p", "th", "4", "th", NULL},
   {"uD2D2p", "th", "4", "ph", NULL},
   {"uD2D3p", "th", "4", "h", NULL},
   {"uD2D4p", "th", "4", "j", NULL},
   {"uD2D5p", "th", "4", "j", NULL},
   {"uD2D6p", "th", "4", "j", NULL},
   {"uD2D7p", "th", "4", "j", NULL},
   {"uD2D8p", "th", "4", "j", NULL},
   {"uD2D9p", "th", "4", "j", NULL},
   {"uD2DAp", "th", "4", "j", NULL},
   {"uD2DBp", "th", "4", "j", NULL},
   {"uD2DCp", "th", "4", "j", NULL},
   {"uD2DDp", "th", "4", "j", NULL},
   {"uD2DEp", "th", "4", "j", NULL},
   {"uD2DFp", "th", "4", "j", NULL},
   {"uD2E0p", "th", "4", "j", NULL},
   {"uD2E1p", "th", "4", "j", NULL},
   {"uD2E2p", "th", "4", "j", NULL},
   {"uD2E3p", "th", "4", "j", NULL},
   {"uD2E4p", "th", "4", "j", NULL},
   {"uD2E5p", "th", "4", "j", NULL},
   {"uD2E6p", "th", "4", "j", NULL},
   {"uD2E7p", "th", "4", "j", NULL},
   {"uD2E8p", "th", "4", "j", NULL},
   {"uD2E9p", "th", "4", "j", NULL},
   {"uD2EAp", "th", "4", "j", NULL},
   {"uD2EBp", "th", "4", "j", NULL},
   {"uD2ECp", "th", "4", "j", NULL},
   {"uD2EDp", "th", "4", "j", NULL},
   {"uD2EEp", "th", "4", "j", NULL},
   {"uD2EFp", "th", "4", "j", NULL},
   {"uD2F0p", "th", "i", NULL, NULL},
   {"uD2F1p", "th", "i", "k", NULL},
   {"uD2F2p", "th", "i", "kGT", NULL},
   {"uD2F3p", "th", "i", "k", NULL},
   {"uD2F4p", "th", "i", "n", NULL},
   {"uD2F5p", "th", "i", "n", NULL},
   {"uD2F6p", "th", "i", "n", NULL},
   {"uD2F7p", "th", "i", "t", NULL},
   {"uD2F8p", "th", "i", "l", NULL},
   {"uD2F9p", "th", "i", "l", NULL},
   {"uD2FAp", "th", "i", "l", NULL},
   {"uD2FBp", "th", "i", "l", NULL},
   {"uD2FCp", "th", "i", "l", NULL},
   {"uD2FDp", "th", "i", "l", NULL},
   {"uD2FEp", "th", "i", "l", NULL},
   {"uD2FFp", "th", "i", "l", NULL},
   {"uD300p", "th", "i", "m", NULL},
   {"uD301p", "th", "i", "p", NULL},
   {"uD302p", "th", "i", "p", NULL},
   {"uD303p", "th", "i", "sh", NULL},
   {"uD304p", "th", "i", "s", NULL},
   {"uD305p", "th", "i", "N", NULL},
   {"uD306p", "th", "i", "tS", NULL},
   {"uD307p", "th", "i", "tSh", NULL},
   {"uD308p", "th", "i", "kh", NULL},
   {"uD309p", "th", "i", "th", NULL},
   {"uD30Ap", "th", "i", "ph", NULL},
   {"uD30Bp", "th", "i", "h", NULL},
   {"uD30Cp", "ph", "a", NULL, NULL},
   {"uD30Dp", "ph", "a", "k", NULL},
   {"uD30Ep", "ph", "a", "kGT", NULL},
   {"uD30Fp", "ph", "a", "k", NULL},
   {"uD310p", "ph", "a", "n", NULL},
   {"uD311p", "ph", "a", "n", NULL},
   {"uD312p", "ph", "a", "n", NULL},
   {"uD313p", "ph", "a", "t", NULL},
   {"uD314p", "ph", "a", "l", NULL},
   {"uD315p", "ph", "a", "l", NULL},
   {"uD316p", "ph", "a", "l", NULL},
   {"uD317p", "ph", "a", "l", NULL},
   {"uD318p", "ph", "a", "l", NULL},
   {"uD319p", "ph", "a", "l", NULL},
   {"uD31Ap", "ph", "a", "l", NULL},
   {"uD31Bp", "ph", "a", "l", NULL},
   {"uD31Cp", "ph", "a", "m", NULL},
   {"uD31Dp", "ph", "a", "p", NULL},
   {"uD31Ep", "ph", "a", "p", NULL},
   {"uD31Fp", "ph", "a", "sh", NULL},
   {"uD320p", "ph", "a", "s", NULL},
   {"uD321p", "ph", "a", "N", NULL},
   {"uD322p", "ph", "a", "tS", NULL},
   {"uD323p", "ph", "a", "tSh", NULL},
   {"uD324p", "ph", "a", "kh", NULL},
   {"uD325p", "ph", "a", "th", NULL},
   {"uD326p", "ph", "a", "ph", NULL},
   {"uD327p", "ph", "a", "h", NULL},
   {"uD328p", "ph", "@", NULL, NULL},
   {"uD329p", "ph", "@", "k", NULL},
   {"uD32Ap", "ph", "@", "kGT", NULL},
   {"uD32Bp", "ph", "@", "k", NULL},
   {"uD32Cp", "ph", "@", "n", NULL},
   {"uD32Dp", "ph", "@", "n", NULL},
   {"uD32Ep", "ph", "@", "n", NULL},
   {"uD32Fp", "ph", "@", "t", NULL},
   {"uD330p", "ph", "@", "l", NULL},
   {"uD331p", "ph", "@", "l", NULL},
   {"uD332p", "ph", "@", "l", NULL},
   {"uD333p", "ph", "@", "l", NULL},
   {"uD334p", "ph", "@", "l", NULL},
   {"uD335p", "ph", "@", "l", NULL},
   {"uD336p", "ph", "@", "l", NULL},
   {"uD337p", "ph", "@", "l", NULL},
   {"uD338p", "ph", "@", "m", NULL},
   {"uD339p", "ph", "@", "p", NULL},
   {"uD33Ap", "ph", "@", "p", NULL},
   {"uD33Bp", "ph", "@", "sh", NULL},
   {"uD33Cp", "ph", "@", "s", NULL},
   {"uD33Dp", "ph", "@", "N", NULL},
   {"uD33Ep", "ph", "@", "tS", NULL},
   {"uD33Fp", "ph", "@", "tSh", NULL},
   {"uD340p", "ph", "@", "kh", NULL},
   {"uD341p", "ph", "@", "th", NULL},
   {"uD342p", "ph", "@", "ph", NULL},
   {"uD343p", "ph", "@", "h", NULL},
   {"uD344p", "ph", "j", "a", NULL},
   {"uD345p", "ph", "j", "a", NULL},
   {"uD346p", "ph", "j", "a", NULL},
   {"uD347p", "ph", "j", "a", NULL},
   {"uD348p", "ph", "j", "a", NULL},
   {"uD349p", "ph", "j", "a", NULL},
   {"uD34Ap", "ph", "j", "a", NULL},
   {"uD34Bp", "ph", "j", "a", NULL},
   {"uD34Cp", "ph", "j", "a", NULL},
   {"uD34Dp", "ph", "j", "a", NULL},
   {"uD34Ep", "ph", "j", "a", NULL},
   {"uD34Fp", "ph", "j", "a", NULL},
   {"uD350p", "ph", "j", "a", NULL},
   {"uD351p", "ph", "j", "a", NULL},
   {"uD352p", "ph", "j", "a", NULL},
   {"uD353p", "ph", "j", "a", NULL},
   {"uD354p", "ph", "j", "a", NULL},
   {"uD355p", "ph", "j", "a", NULL},
   {"uD356p", "ph", "j", "a", NULL},
   {"uD357p", "ph", "j", "a", NULL},
   {"uD358p", "ph", "j", "a", NULL},
   {"uD359p", "ph", "j", "a", NULL},
   {"uD35Ap", "ph", "j", "a", NULL},
   {"uD35Bp", "ph", "j", "a", NULL},
   {"uD35Cp", "ph", "j", "a", NULL},
   {"uD35Dp", "ph", "j", "a", NULL},
   {"uD35Ep", "ph", "j", "a", NULL},
   {"uD35Fp", "ph", "j", "a", NULL},
   {"uD360p", "ph", "j", "@", NULL},
   {"uD361p", "ph", "j", "@", NULL},
   {"uD362p", "ph", "j", "@", NULL},
   {"uD363p", "ph", "j", "@", NULL},
   {"uD364p", "ph", "j", "@", NULL},
   {"uD365p", "ph", "j", "@", NULL},
   {"uD366p", "ph", "j", "@", NULL},
   {"uD367p", "ph", "j", "@", NULL},
   {"uD368p", "ph", "j", "@", NULL},
   {"uD369p", "ph", "j", "@", NULL},
   {"uD36Ap", "ph", "j", "@", NULL},
   {"uD36Bp", "ph", "j", "@", NULL},
   {"uD36Cp", "ph", "j", "@", NULL},
   {"uD36Dp", "ph", "j", "@", NULL},
   {"uD36Ep", "ph", "j", "@", NULL},
   {"uD36Fp", "ph", "j", "@", NULL},
   {"uD370p", "ph", "j", "@", NULL},
   {"uD371p", "ph", "j", "@", NULL},
   {"uD372p", "ph", "j", "@", NULL},
   {"uD373p", "ph", "j", "@", NULL},
   {"uD374p", "ph", "j", "@", NULL},
   {"uD375p", "ph", "j", "@", NULL},
   {"uD376p", "ph", "j", "@", NULL},
   {"uD377p", "ph", "j", "@", NULL},
   {"uD378p", "ph", "j", "@", NULL},
   {"uD379p", "ph", "j", "@", NULL},
   {"uD37Ap", "ph", "j", "@", NULL},
   {"uD37Bp", "ph", "j", "@", NULL},
   {"uD37Cp", "ph", "^", NULL, NULL},
   {"uD37Dp", "ph", "^", "k", NULL},
   {"uD37Ep", "ph", "^", "kGT", NULL},
   {"uD37Fp", "ph", "^", "k", NULL},
   {"uD380p", "ph", "^", "n", NULL},
   {"uD381p", "ph", "^", "n", NULL},
   {"uD382p", "ph", "^", "n", NULL},
   {"uD383p", "ph", "^", "t", NULL},
   {"uD384p", "ph", "^", "l", NULL},
   {"uD385p", "ph", "^", "l", NULL},
   {"uD386p", "ph", "^", "l", NULL},
   {"uD387p", "ph", "^", "l", NULL},
   {"uD388p", "ph", "^", "l", NULL},
   {"uD389p", "ph", "^", "l", NULL},
   {"uD38Ap", "ph", "^", "l", NULL},
   {"uD38Bp", "ph", "^", "l", NULL},
   {"uD38Cp", "ph", "^", "m", NULL},
   {"uD38Dp", "ph", "^", "p", NULL},
   {"uD38Ep", "ph", "^", "p", NULL},
   {"uD38Fp", "ph", "^", "sh", NULL},
   {"uD390p", "ph", "^", "s", NULL},
   {"uD391p", "ph", "^", "N", NULL},
   {"uD392p", "ph", "^", "tS", NULL},
   {"uD393p", "ph", "^", "tSh", NULL},
   {"uD394p", "ph", "^", "kh", NULL},
   {"uD395p", "ph", "^", "th", NULL},
   {"uD396p", "ph", "^", "ph", NULL},
   {"uD397p", "ph", "^", "h", NULL},
   {"uD398p", "ph", "e", NULL, NULL},
   {"uD399p", "ph", "e", "k", NULL},
   {"uD39Ap", "ph", "e", "kGT", NULL},
   {"uD39Bp", "ph", "e", "k", NULL},
   {"uD39Cp", "ph", "e", "n", NULL},
   {"uD39Dp", "ph", "e", "n", NULL},
   {"uD39Ep", "ph", "e", "n", NULL},
   {"uD39Fp", "ph", "e", "t", NULL},
   {"uD3A0p", "ph", "e", "l", NULL},
   {"uD3A1p", "ph", "e", "l", NULL},
   {"uD3A2p", "ph", "e", "l", NULL},
   {"uD3A3p", "ph", "e", "l", NULL},
   {"uD3A4p", "ph", "e", "l", NULL},
   {"uD3A5p", "ph", "e", "l", NULL},
   {"uD3A6p", "ph", "e", "l", NULL},
   {"uD3A7p", "ph", "e", "l", NULL},
   {"uD3A8p", "ph", "e", "m", NULL},
   {"uD3A9p", "ph", "e", "p", NULL},
   {"uD3AAp", "ph", "e", "p", NULL},
   {"uD3ABp", "ph", "e", "sh", NULL},
   {"uD3ACp", "ph", "e", "s", NULL},
   {"uD3ADp", "ph", "e", "N", NULL},
   {"uD3AEp", "ph", "e", "tS", NULL},
   {"uD3AFp", "ph", "e", "tSh", NULL},
   {"uD3B0p", "ph", "e", "kh", NULL},
   {"uD3B1p", "ph", "e", "th", NULL},
   {"uD3B2p", "ph", "e", "ph", NULL},
   {"uD3B3p", "ph", "e", "h", NULL},
   {"uD3B4p", "ph", "j", "^", NULL},
   {"uD3B5p", "ph", "j", "^", NULL},
   {"uD3B6p", "ph", "j", "^", NULL},
   {"uD3B7p", "ph", "j", "^", NULL},
   {"uD3B8p", "ph", "j", "^", NULL},
   {"uD3B9p", "ph", "j", "^", NULL},
   {"uD3BAp", "ph", "j", "^", NULL},
   {"uD3BBp", "ph", "j", "^", NULL},
   {"uD3BCp", "ph", "j", "^", NULL},
   {"uD3BDp", "ph", "j", "^", NULL},
   {"uD3BEp", "ph", "j", "^", NULL},
   {"uD3BFp", "ph", "j", "^", NULL},
   {"uD3C0p", "ph", "j", "^", NULL},
   {"uD3C1p", "ph", "j", "^", NULL},
   {"uD3C2p", "ph", "j", "^", NULL},
   {"uD3C3p", "ph", "j", "^", NULL},
   {"uD3C4p", "ph", "j", "^", NULL},
   {"uD3C5p", "ph", "j", "^", NULL},
   {"uD3C6p", "ph", "j", "^", NULL},
   {"uD3C7p", "ph", "j", "^", NULL},
   {"uD3C8p", "ph", "j", "^", NULL},
   {"uD3C9p", "ph", "j", "^", NULL},
   {"uD3CAp", "ph", "j", "^", NULL},
   {"uD3CBp", "ph", "j", "^", NULL},
   {"uD3CCp", "ph", "j", "^", NULL},
   {"uD3CDp", "ph", "j", "^", NULL},
   {"uD3CEp", "ph", "j", "^", NULL},
   {"uD3CFp", "ph", "j", "^", NULL},
   {"uD3D0p", "ph", "j", "e", NULL},
   {"uD3D1p", "ph", "j", "e", NULL},
   {"uD3D2p", "ph", "j", "e", NULL},
   {"uD3D3p", "ph", "j", "e", NULL},
   {"uD3D4p", "ph", "j", "e", NULL},
   {"uD3D5p", "ph", "j", "e", NULL},
   {"uD3D6p", "ph", "j", "e", NULL},
   {"uD3D7p", "ph", "j", "e", NULL},
   {"uD3D8p", "ph", "j", "e", NULL},
   {"uD3D9p", "ph", "j", "e", NULL},
   {"uD3DAp", "ph", "j", "e", NULL},
   {"uD3DBp", "ph", "j", "e", NULL},
   {"uD3DCp", "ph", "j", "e", NULL},
   {"uD3DDp", "ph", "j", "e", NULL},
   {"uD3DEp", "ph", "j", "e", NULL},
   {"uD3DFp", "ph", "j", "e", NULL},
   {"uD3E0p", "ph", "j", "e", NULL},
   {"uD3E1p", "ph", "j", "e", NULL},
   {"uD3E2p", "ph", "j", "e", NULL},
   {"uD3E3p", "ph", "j", "e", NULL},
   {"uD3E4p", "ph", "j", "e", NULL},
   {"uD3E5p", "ph", "j", "e", NULL},
   {"uD3E6p", "ph", "j", "e", NULL},
   {"uD3E7p", "ph", "j", "e", NULL},
   {"uD3E8p", "ph", "j", "e", NULL},
   {"uD3E9p", "ph", "j", "e", NULL},
   {"uD3EAp", "ph", "j", "e", NULL},
   {"uD3EBp", "ph", "j", "e", NULL},
   {"uD3ECp", "ph", "o", NULL, NULL},
   {"uD3EDp", "ph", "o", "k", NULL},
   {"uD3EEp", "ph", "o", "kGT", NULL},
   {"uD3EFp", "ph", "o", "k", NULL},
   {"uD3F0p", "ph", "o", "n", NULL},
   {"uD3F1p", "ph", "o", "n", NULL},
   {"uD3F2p", "ph", "o", "n", NULL},
   {"uD3F3p", "ph", "o", "t", NULL},
   {"uD3F4p", "ph", "o", "l", NULL},
   {"uD3F5p", "ph", "o", "l", NULL},
   {"uD3F6p", "ph", "o", "l", NULL},
   {"uD3F7p", "ph", "o", "l", NULL},
   {"uD3F8p", "ph", "o", "l", NULL},
   {"uD3F9p", "ph", "o", "l", NULL},
   {"uD3FAp", "ph", "o", "l", NULL},
   {"uD3FBp", "ph", "o", "l", NULL},
   {"uD3FCp", "ph", "o", "m", NULL},
   {"uD3FDp", "ph", "o", "p", NULL},
   {"uD3FEp", "ph", "o", "p", NULL},
   {"uD3FFp", "ph", "o", "sh", NULL},
   {"uD400p", "ph", "o", "s", NULL},
   {"uD401p", "ph", "o", "N", NULL},
   {"uD402p", "ph", "o", "tS", NULL},
   {"uD403p", "ph", "o", "tSh", NULL},
   {"uD404p", "ph", "o", "kh", NULL},
   {"uD405p", "ph", "o", "th", NULL},
   {"uD406p", "ph", "o", "ph", NULL},
   {"uD407p", "ph", "o", "h", NULL},
   {"uD408p", "ph", "w", "a", NULL},
   {"uD409p", "ph", "w", "a", NULL},
   {"uD40Ap", "ph", "w", "a", NULL},
   {"uD40Bp", "ph", "w", "a", NULL},
   {"uD40Cp", "ph", "w", "a", NULL},
   {"uD40Dp", "ph", "w", "a", NULL},
   {"uD40Ep", "ph", "w", "a", NULL},
   {"uD40Fp", "ph", "w", "a", NULL},
   {"uD410p", "ph", "w", "a", NULL},
   {"uD411p", "ph", "w", "a", NULL},
   {"uD412p", "ph", "w", "a", NULL},
   {"uD413p", "ph", "w", "a", NULL},
   {"uD414p", "ph", "w", "a", NULL},
   {"uD415p", "ph", "w", "a", NULL},
   {"uD416p", "ph", "w", "a", NULL},
   {"uD417p", "ph", "w", "a", NULL},
   {"uD418p", "ph", "w", "a", NULL},
   {"uD419p", "ph", "w", "a", NULL},
   {"uD41Ap", "ph", "w", "a", NULL},
   {"uD41Bp", "ph", "w", "a", NULL},
   {"uD41Cp", "ph", "w", "a", NULL},
   {"uD41Dp", "ph", "w", "a", NULL},
   {"uD41Ep", "ph", "w", "a", NULL},
   {"uD41Fp", "ph", "w", "a", NULL},
   {"uD420p", "ph", "w", "a", NULL},
   {"uD421p", "ph", "w", "a", NULL},
   {"uD422p", "ph", "w", "a", NULL},
   {"uD423p", "ph", "w", "a", NULL},
   {"uD424p", "ph", "w", "@", NULL},
   {"uD425p", "ph", "w", "@", NULL},
   {"uD426p", "ph", "w", "@", NULL},
   {"uD427p", "ph", "w", "@", NULL},
   {"uD428p", "ph", "w", "@", NULL},
   {"uD429p", "ph", "w", "@", NULL},
   {"uD42Ap", "ph", "w", "@", NULL},
   {"uD42Bp", "ph", "w", "@", NULL},
   {"uD42Cp", "ph", "w", "@", NULL},
   {"uD42Dp", "ph", "w", "@", NULL},
   {"uD42Ep", "ph", "w", "@", NULL},
   {"uD42Fp", "ph", "w", "@", NULL},
   {"uD430p", "ph", "w", "@", NULL},
   {"uD431p", "ph", "w", "@", NULL},
   {"uD432p", "ph", "w", "@", NULL},
   {"uD433p", "ph", "w", "@", NULL},
   {"uD434p", "ph", "w", "@", NULL},
   {"uD435p", "ph", "w", "@", NULL},
   {"uD436p", "ph", "w", "@", NULL},
   {"uD437p", "ph", "w", "@", NULL},
   {"uD438p", "ph", "w", "@", NULL},
   {"uD439p", "ph", "w", "@", NULL},
   {"uD43Ap", "ph", "w", "@", NULL},
   {"uD43Bp", "ph", "w", "@", NULL},
   {"uD43Cp", "ph", "w", "@", NULL},
   {"uD43Dp", "ph", "w", "@", NULL},
   {"uD43Ep", "ph", "w", "@", NULL},
   {"uD43Fp", "ph", "w", "@", NULL},
   {"uD440p", "ph", "w", "e", NULL},
   {"uD441p", "ph", "w", "e", NULL},
   {"uD442p", "ph", "w", "e", NULL},
   {"uD443p", "ph", "w", "e", NULL},
   {"uD444p", "ph", "w", "e", NULL},
   {"uD445p", "ph", "w", "e", NULL},
   {"uD446p", "ph", "w", "e", NULL},
   {"uD447p", "ph", "w", "e", NULL},
   {"uD448p", "ph", "w", "e", NULL},
   {"uD449p", "ph", "w", "e", NULL},
   {"uD44Ap", "ph", "w", "e", NULL},
   {"uD44Bp", "ph", "w", "e", NULL},
   {"uD44Cp", "ph", "w", "e", NULL},
   {"uD44Dp", "ph", "w", "e", NULL},
   {"uD44Ep", "ph", "w", "e", NULL},
   {"uD44Fp", "ph", "w", "e", NULL},
   {"uD450p", "ph", "w", "e", NULL},
   {"uD451p", "ph", "w", "e", NULL},
   {"uD452p", "ph", "w", "e", NULL},
   {"uD453p", "ph", "w", "e", NULL},
   {"uD454p", "ph", "w", "e", NULL},
   {"uD455p", "ph", "w", "e", NULL},
   {"uD456p", "ph", "w", "e", NULL},
   {"uD457p", "ph", "w", "e", NULL},
   {"uD458p", "ph", "w", "e", NULL},
   {"uD459p", "ph", "w", "e", NULL},
   {"uD45Ap", "ph", "w", "e", NULL},
   {"uD45Bp", "ph", "w", "e", NULL},
   {"uD45Cp", "ph", "j", "o", NULL},
   {"uD45Dp", "ph", "j", "o", NULL},
   {"uD45Ep", "ph", "j", "o", NULL},
   {"uD45Fp", "ph", "j", "o", NULL},
   {"uD460p", "ph", "j", "o", NULL},
   {"uD461p", "ph", "j", "o", NULL},
   {"uD462p", "ph", "j", "o", NULL},
   {"uD463p", "ph", "j", "o", NULL},
   {"uD464p", "ph", "j", "o", NULL},
   {"uD465p", "ph", "j", "o", NULL},
   {"uD466p", "ph", "j", "o", NULL},
   {"uD467p", "ph", "j", "o", NULL},
   {"uD468p", "ph", "j", "o", NULL},
   {"uD469p", "ph", "j", "o", NULL},
   {"uD46Ap", "ph", "j", "o", NULL},
   {"uD46Bp", "ph", "j", "o", NULL},
   {"uD46Cp", "ph", "j", "o", NULL},
   {"uD46Dp", "ph", "j", "o", NULL},
   {"uD46Ep", "ph", "j", "o", NULL},
   {"uD46Fp", "ph", "j", "o", NULL},
   {"uD470p", "ph", "j", "o", NULL},
   {"uD471p", "ph", "j", "o", NULL},
   {"uD472p", "ph", "j", "o", NULL},
   {"uD473p", "ph", "j", "o", NULL},
   {"uD474p", "ph", "j", "o", NULL},
   {"uD475p", "ph", "j", "o", NULL},
   {"uD476p", "ph", "j", "o", NULL},
   {"uD477p", "ph", "j", "o", NULL},
   {"uD478p", "ph", "u", NULL, NULL},
   {"uD479p", "ph", "u", "k", NULL},
   {"uD47Ap", "ph", "u", "kGT", NULL},
   {"uD47Bp", "ph", "u", "k", NULL},
   {"uD47Cp", "ph", "u", "n", NULL},
   {"uD47Dp", "ph", "u", "n", NULL},
   {"uD47Ep", "ph", "u", "n", NULL},
   {"uD47Fp", "ph", "u", "t", NULL},
   {"uD480p", "ph", "u", "l", NULL},
   {"uD481p", "ph", "u", "l", NULL},
   {"uD482p", "ph", "u", "l", NULL},
   {"uD483p", "ph", "u", "l", NULL},
   {"uD484p", "ph", "u", "l", NULL},
   {"uD485p", "ph", "u", "l", NULL},
   {"uD486p", "ph", "u", "l", NULL},
   {"uD487p", "ph", "u", "l", NULL},
   {"uD488p", "ph", "u", "m", NULL},
   {"uD489p", "ph", "u", "p", NULL},
   {"uD48Ap", "ph", "u", "p", NULL},
   {"uD48Bp", "ph", "u", "sh", NULL},
   {"uD48Cp", "ph", "u", "s", NULL},
   {"uD48Dp", "ph", "u", "N", NULL},
   {"uD48Ep", "ph", "u", "tS", NULL},
   {"uD48Fp", "ph", "u", "tSh", NULL},
   {"uD490p", "ph", "u", "kh", NULL},
   {"uD491p", "ph", "u", "th", NULL},
   {"uD492p", "ph", "u", "ph", NULL},
   {"uD493p", "ph", "u", "h", NULL},
   {"uD494p", "ph", "w", "^", NULL},
   {"uD495p", "ph", "w", "^", NULL},
   {"uD496p", "ph", "w", "^", NULL},
   {"uD497p", "ph", "w", "^", NULL},
   {"uD498p", "ph", "w", "^", NULL},
   {"uD499p", "ph", "w", "^", NULL},
   {"uD49Ap", "ph", "w", "^", NULL},
   {"uD49Bp", "ph", "w", "^", NULL},
   {"uD49Cp", "ph", "w", "^", NULL},
   {"uD49Dp", "ph", "w", "^", NULL},
   {"uD49Ep", "ph", "w", "^", NULL},
   {"uD49Fp", "ph", "w", "^", NULL},
   {"uD4A0p", "ph", "w", "^", NULL},
   {"uD4A1p", "ph", "w", "^", NULL},
   {"uD4A2p", "ph", "w", "^", NULL},
   {"uD4A3p", "ph", "w", "^", NULL},
   {"uD4A4p", "ph", "w", "^", NULL},
   {"uD4A5p", "ph", "w", "^", NULL},
   {"uD4A6p", "ph", "w", "^", NULL},
   {"uD4A7p", "ph", "w", "^", NULL},
   {"uD4A8p", "ph", "w", "^", NULL},
   {"uD4A9p", "ph", "w", "^", NULL},
   {"uD4AAp", "ph", "w", "^", NULL},
   {"uD4ABp", "ph", "w", "^", NULL},
   {"uD4ACp", "ph", "w", "^", NULL},
   {"uD4ADp", "ph", "w", "^", NULL},
   {"uD4AEp", "ph", "w", "^", NULL},
   {"uD4AFp", "ph", "w", "^", NULL},
   {"uD4B0p", "ph", "w", "e", NULL},
   {"uD4B1p", "ph", "w", "e", NULL},
   {"uD4B2p", "ph", "w", "e", NULL},
   {"uD4B3p", "ph", "w", "e", NULL},
   {"uD4B4p", "ph", "w", "e", NULL},
   {"uD4B5p", "ph", "w", "e", NULL},
   {"uD4B6p", "ph", "w", "e", NULL},
   {"uD4B7p", "ph", "w", "e", NULL},
   {"uD4B8p", "ph", "w", "e", NULL},
   {"uD4B9p", "ph", "w", "e", NULL},
   {"uD4BAp", "ph", "w", "e", NULL},
   {"uD4BBp", "ph", "w", "e", NULL},
   {"uD4BCp", "ph", "w", "e", NULL},
   {"uD4BDp", "ph", "w", "e", NULL},
   {"uD4BEp", "ph", "w", "e", NULL},
   {"uD4BFp", "ph", "w", "e", NULL},
   {"uD4C0p", "ph", "w", "e", NULL},
   {"uD4C1p", "ph", "w", "e", NULL},
   {"uD4C2p", "ph", "w", "e", NULL},
   {"uD4C3p", "ph", "w", "e", NULL},
   {"uD4C4p", "ph", "w", "e", NULL},
   {"uD4C5p", "ph", "w", "e", NULL},
   {"uD4C6p", "ph", "w", "e", NULL},
   {"uD4C7p", "ph", "w", "e", NULL},
   {"uD4C8p", "ph", "w", "e", NULL},
   {"uD4C9p", "ph", "w", "e", NULL},
   {"uD4CAp", "ph", "w", "e", NULL},
   {"uD4CBp", "ph", "w", "e", NULL},
   {"uD4CCp", "ph", "7", NULL, NULL},
   {"uD4CDp", "ph", "7", "k", NULL},
   {"uD4CEp", "ph", "7", "kGT", NULL},
   {"uD4CFp", "ph", "7", "k", NULL},
   {"uD4D0p", "ph", "7", "n", NULL},
   {"uD4D1p", "ph", "7", "n", NULL},
   {"uD4D2p", "ph", "7", "n", NULL},
   {"uD4D3p", "ph", "7", "t", NULL},
   {"uD4D4p", "ph", "7", "l", NULL},
   {"uD4D5p", "ph", "7", "l", NULL},
   {"uD4D6p", "ph", "7", "l", NULL},
   {"uD4D7p", "ph", "7", "l", NULL},
   {"uD4D8p", "ph", "7", "l", NULL},
   {"uD4D9p", "ph", "7", "l", NULL},
   {"uD4DAp", "ph", "7", "l", NULL},
   {"uD4DBp", "ph", "7", "l", NULL},
   {"uD4DCp", "ph", "7", "m", NULL},
   {"uD4DDp", "ph", "7", "p", NULL},
   {"uD4DEp", "ph", "7", "p", NULL},
   {"uD4DFp", "ph", "7", "sh", NULL},
   {"uD4E0p", "ph", "7", "s", NULL},
   {"uD4E1p", "ph", "7", "N", NULL},
   {"uD4E2p", "ph", "7", "tS", NULL},
   {"uD4E3p", "ph", "7", "tSh", NULL},
   {"uD4E4p", "ph", "7", "kh", NULL},
   {"uD4E5p", "ph", "7", "th", NULL},
   {"uD4E6p", "ph", "7", "ph", NULL},
   {"uD4E7p", "ph", "7", "h", NULL},
   {"uD4E8p", "ph", "j", "u", NULL},
   {"uD4E9p", "ph", "j", "u", NULL},
   {"uD4EAp", "ph", "j", "u", NULL},
   {"uD4EBp", "ph", "j", "u", NULL},
   {"uD4ECp", "ph", "j", "u", NULL},
   {"uD4EDp", "ph", "j", "u", NULL},
   {"uD4EEp", "ph", "j", "u", NULL},
   {"uD4EFp", "ph", "j", "u", NULL},
   {"uD4F0p", "ph", "j", "u", NULL},
   {"uD4F1p", "ph", "j", "u", NULL},
   {"uD4F2p", "ph", "j", "u", NULL},
   {"uD4F3p", "ph", "j", "u", NULL},
   {"uD4F4p", "ph", "j", "u", NULL},
   {"uD4F5p", "ph", "j", "u", NULL},
   {"uD4F6p", "ph", "j", "u", NULL},
   {"uD4F7p", "ph", "j", "u", NULL},
   {"uD4F8p", "ph", "j", "u", NULL},
   {"uD4F9p", "ph", "j", "u", NULL},
   {"uD4FAp", "ph", "j", "u", NULL},
   {"uD4FBp", "ph", "j", "u", NULL},
   {"uD4FCp", "ph", "j", "u", NULL},
   {"uD4FDp", "ph", "j", "u", NULL},
   {"uD4FEp", "ph", "j", "u", NULL},
   {"uD4FFp", "ph", "j", "u", NULL},
   {"uD500p", "ph", "j", "u", NULL},
   {"uD501p", "ph", "j", "u", NULL},
   {"uD502p", "ph", "j", "u", NULL},
   {"uD503p", "ph", "j", "u", NULL},
   {"uD504p", "ph", "4", NULL, NULL},
   {"uD505p", "ph", "4", "k", NULL},
   {"uD506p", "ph", "4", "kGT", NULL},
   {"uD507p", "ph", "4", "k", NULL},
   {"uD508p", "ph", "4", "n", NULL},
   {"uD509p", "ph", "4", "n", NULL},
   {"uD50Ap", "ph", "4", "n", NULL},
   {"uD50Bp", "ph", "4", "t", NULL},
   {"uD50Cp", "ph", "4", "l", NULL},
   {"uD50Dp", "ph", "4", "l", NULL},
   {"uD50Ep", "ph", "4", "l", NULL},
   {"uD50Fp", "ph", "4", "l", NULL},
   {"uD510p", "ph", "4", "l", NULL},
   {"uD511p", "ph", "4", "l", NULL},
   {"uD512p", "ph", "4", "l", NULL},
   {"uD513p", "ph", "4", "l", NULL},
   {"uD514p", "ph", "4", "m", NULL},
   {"uD515p", "ph", "4", "p", NULL},
   {"uD516p", "ph", "4", "p", NULL},
   {"uD517p", "ph", "4", "sh", NULL},
   {"uD518p", "ph", "4", "s", NULL},
   {"uD519p", "ph", "4", "N", NULL},
   {"uD51Ap", "ph", "4", "tS", NULL},
   {"uD51Bp", "ph", "4", "tSh", NULL},
   {"uD51Cp", "ph", "4", "kh", NULL},
   {"uD51Dp", "ph", "4", "th", NULL},
   {"uD51Ep", "ph", "4", "ph", NULL},
   {"uD51Fp", "ph", "4", "h", NULL},
   {"uD520p", "ph", "4", "j", NULL},
   {"uD521p", "ph", "4", "j", NULL},
   {"uD522p", "ph", "4", "j", NULL},
   {"uD523p", "ph", "4", "j", NULL},
   {"uD524p", "ph", "4", "j", NULL},
   {"uD525p", "ph", "4", "j", NULL},
   {"uD526p", "ph", "4", "j", NULL},
   {"uD527p", "ph", "4", "j", NULL},
   {"uD528p", "ph", "4", "j", NULL},
   {"uD529p", "ph", "4", "j", NULL},
   {"uD52Ap", "ph", "4", "j", NULL},
   {"uD52Bp", "ph", "4", "j", NULL},
   {"uD52Cp", "ph", "4", "j", NULL},
   {"uD52Dp", "ph", "4", "j", NULL},
   {"uD52Ep", "ph", "4", "j", NULL},
   {"uD52Fp", "ph", "4", "j", NULL},
   {"uD530p", "ph", "4", "j", NULL},
   {"uD531p", "ph", "4", "j", NULL},
   {"uD532p", "ph", "4", "j", NULL},
   {"uD533p", "ph", "4", "j", NULL},
   {"uD534p", "ph", "4", "j", NULL},
   {"uD535p", "ph", "4", "j", NULL},
   {"uD536p", "ph", "4", "j", NULL},
   {"uD537p", "ph", "4", "j", NULL},
   {"uD538p", "ph", "4", "j", NULL},
   {"uD539p", "ph", "4", "j", NULL},
   {"uD53Ap", "ph", "4", "j", NULL},
   {"uD53Bp", "ph", "4", "j", NULL},
   {"uD53Cp", "ph", "i", NULL, NULL},
   {"uD53Dp", "ph", "i", "k", NULL},
   {"uD53Ep", "ph", "i", "kGT", NULL},
   {"uD53Fp", "ph", "i", "k", NULL},
   {"uD540p", "ph", "i", "n", NULL},
   {"uD541p", "ph", "i", "n", NULL},
   {"uD542p", "ph", "i", "n", NULL},
   {"uD543p", "ph", "i", "t", NULL},
   {"uD544p", "ph", "i", "l", NULL},
   {"uD545p", "ph", "i", "l", NULL},
   {"uD546p", "ph", "i", "l", NULL},
   {"uD547p", "ph", "i", "l", NULL},
   {"uD548p", "ph", "i", "l", NULL},
   {"uD549p", "ph", "i", "l", NULL},
   {"uD54Ap", "ph", "i", "l", NULL},
   {"uD54Bp", "ph", "i", "l", NULL},
   {"uD54Cp", "ph", "i", "m", NULL},
   {"uD54Dp", "ph", "i", "p", NULL},
   {"uD54Ep", "ph", "i", "p", NULL},
   {"uD54Fp", "ph", "i", "sh", NULL},
   {"uD550p", "ph", "i", "s", NULL},
   {"uD551p", "ph", "i", "N", NULL},
   {"uD552p", "ph", "i", "tS", NULL},
   {"uD553p", "ph", "i", "tSh", NULL},
   {"uD554p", "ph", "i", "kh", NULL},
   {"uD555p", "ph", "i", "th", NULL},
   {"uD556p", "ph", "i", "ph", NULL},
   {"uD557p", "ph", "i", "h", NULL},
   {"uD558p", "h", "a", NULL, NULL},
   {"uD559p", "h", "a", "k", NULL},
   {"uD55Ap", "h", "a", "kGT", NULL},
   {"uD55Bp", "h", "a", "k", NULL},
   {"uD55Cp", "h", "a", "n", NULL},
   {"uD55Dp", "h", "a", "n", NULL},
   {"uD55Ep", "h", "a", "n", NULL},
   {"uD55Fp", "h", "a", "t", NULL},
   {"uD560p", "h", "a", "l", NULL},
   {"uD561p", "h", "a", "l", NULL},
   {"uD562p", "h", "a", "l", NULL},
   {"uD563p", "h", "a", "l", NULL},
   {"uD564p", "h", "a", "l", NULL},
   {"uD565p", "h", "a", "l", NULL},
   {"uD566p", "h", "a", "l", NULL},
   {"uD567p", "h", "a", "l", NULL},
   {"uD568p", "h", "a", "m", NULL},
   {"uD569p", "h", "a", "p", NULL},
   {"uD56Ap", "h", "a", "p", NULL},
   {"uD56Bp", "h", "a", "sh", NULL},
   {"uD56Cp", "h", "a", "s", NULL},
   {"uD56Dp", "h", "a", "N", NULL},
   {"uD56Ep", "h", "a", "tS", NULL},
   {"uD56Fp", "h", "a", "tSh", NULL},
   {"uD570p", "h", "a", "kh", NULL},
   {"uD571p", "h", "a", "th", NULL},
   {"uD572p", "h", "a", "ph", NULL},
   {"uD573p", "h", "a", "h", NULL},
   {"uD574p", "h", "@", NULL, NULL},
   {"uD575p", "h", "@", "k", NULL},
   {"uD576p", "h", "@", "kGT", NULL},
   {"uD577p", "h", "@", "k", NULL},
   {"uD578p", "h", "@", "n", NULL},
   {"uD579p", "h", "@", "n", NULL},
   {"uD57Ap", "h", "@", "n", NULL},
   {"uD57Bp", "h", "@", "t", NULL},
   {"uD57Cp", "h", "@", "l", NULL},
   {"uD57Dp", "h", "@", "l", NULL},
   {"uD57Ep", "h", "@", "l", NULL},
   {"uD57Fp", "h", "@", "l", NULL},
   {"uD580p", "h", "@", "l", NULL},
   {"uD581p", "h", "@", "l", NULL},
   {"uD582p", "h", "@", "l", NULL},
   {"uD583p", "h", "@", "l", NULL},
   {"uD584p", "h", "@", "m", NULL},
   {"uD585p", "h", "@", "p", NULL},
   {"uD586p", "h", "@", "p", NULL},
   {"uD587p", "h", "@", "sh", NULL},
   {"uD588p", "h", "@", "s", NULL},
   {"uD589p", "h", "@", "N", NULL},
   {"uD58Ap", "h", "@", "tS", NULL},
   {"uD58Bp", "h", "@", "tSh", NULL},
   {"uD58Cp", "h", "@", "kh", NULL},
   {"uD58Dp", "h", "@", "th", NULL},
   {"uD58Ep", "h", "@", "ph", NULL},
   {"uD58Fp", "h", "@", "h", NULL},
   {"uD590p", "h", "j", "a", NULL},
   {"uD591p", "h", "j", "a", NULL},
   {"uD592p", "h", "j", "a", NULL},
   {"uD593p", "h", "j", "a", NULL},
   {"uD594p", "h", "j", "a", NULL},
   {"uD595p", "h", "j", "a", NULL},
   {"uD596p", "h", "j", "a", NULL},
   {"uD597p", "h", "j", "a", NULL},
   {"uD598p", "h", "j", "a", NULL},
   {"uD599p", "h", "j", "a", NULL},
   {"uD59Ap", "h", "j", "a", NULL},
   {"uD59Bp", "h", "j", "a", NULL},
   {"uD59Cp", "h", "j", "a", NULL},
   {"uD59Dp", "h", "j", "a", NULL},
   {"uD59Ep", "h", "j", "a", NULL},
   {"uD59Fp", "h", "j", "a", NULL},
   {"uD5A0p", "h", "j", "a", NULL},
   {"uD5A1p", "h", "j", "a", NULL},
   {"uD5A2p", "h", "j", "a", NULL},
   {"uD5A3p", "h", "j", "a", NULL},
   {"uD5A4p", "h", "j", "a", NULL},
   {"uD5A5p", "h", "j", "a", NULL},
   {"uD5A6p", "h", "j", "a", NULL},
   {"uD5A7p", "h", "j", "a", NULL},
   {"uD5A8p", "h", "j", "a", NULL},
   {"uD5A9p", "h", "j", "a", NULL},
   {"uD5AAp", "h", "j", "a", NULL},
   {"uD5ABp", "h", "j", "a", NULL},
   {"uD5ACp", "h", "j", "@", NULL},
   {"uD5ADp", "h", "j", "@", NULL},
   {"uD5AEp", "h", "j", "@", NULL},
   {"uD5AFp", "h", "j", "@", NULL},
   {"uD5B0p", "h", "j", "@", NULL},
   {"uD5B1p", "h", "j", "@", NULL},
   {"uD5B2p", "h", "j", "@", NULL},
   {"uD5B3p", "h", "j", "@", NULL},
   {"uD5B4p", "h", "j", "@", NULL},
   {"uD5B5p", "h", "j", "@", NULL},
   {"uD5B6p", "h", "j", "@", NULL},
   {"uD5B7p", "h", "j", "@", NULL},
   {"uD5B8p", "h", "j", "@", NULL},
   {"uD5B9p", "h", "j", "@", NULL},
   {"uD5BAp", "h", "j", "@", NULL},
   {"uD5BBp", "h", "j", "@", NULL},
   {"uD5BCp", "h", "j", "@", NULL},
   {"uD5BDp", "h", "j", "@", NULL},
   {"uD5BEp", "h", "j", "@", NULL},
   {"uD5BFp", "h", "j", "@", NULL},
   {"uD5C0p", "h", "j", "@", NULL},
   {"uD5C1p", "h", "j", "@", NULL},
   {"uD5C2p", "h", "j", "@", NULL},
   {"uD5C3p", "h", "j", "@", NULL},
   {"uD5C4p", "h", "j", "@", NULL},
   {"uD5C5p", "h", "j", "@", NULL},
   {"uD5C6p", "h", "j", "@", NULL},
   {"uD5C7p", "h", "j", "@", NULL},
   {"uD5C8p", "h", "^", NULL, NULL},
   {"uD5C9p", "h", "^", "k", NULL},
   {"uD5CAp", "h", "^", "kGT", NULL},
   {"uD5CBp", "h", "^", "k", NULL},
   {"uD5CCp", "h", "^", "n", NULL},
   {"uD5CDp", "h", "^", "n", NULL},
   {"uD5CEp", "h", "^", "n", NULL},
   {"uD5CFp", "h", "^", "t", NULL},
   {"uD5D0p", "h", "^", "l", NULL},
   {"uD5D1p", "h", "^", "l", NULL},
   {"uD5D2p", "h", "^", "l", NULL},
   {"uD5D3p", "h", "^", "l", NULL},
   {"uD5D4p", "h", "^", "l", NULL},
   {"uD5D5p", "h", "^", "l", NULL},
   {"uD5D6p", "h", "^", "l", NULL},
   {"uD5D7p", "h", "^", "l", NULL},
   {"uD5D8p", "h", "^", "m", NULL},
   {"uD5D9p", "h", "^", "p", NULL},
   {"uD5DAp", "h", "^", "p", NULL},
   {"uD5DBp", "h", "^", "sh", NULL},
   {"uD5DCp", "h", "^", "s", NULL},
   {"uD5DDp", "h", "^", "N", NULL},
   {"uD5DEp", "h", "^", "tS", NULL},
   {"uD5DFp", "h", "^", "tSh", NULL},
   {"uD5E0p", "h", "^", "kh", NULL},
   {"uD5E1p", "h", "^", "th", NULL},
   {"uD5E2p", "h", "^", "ph", NULL},
   {"uD5E3p", "h", "^", "h", NULL},
   {"uD5E4p", "h", "e", NULL, NULL},
   {"uD5E5p", "h", "e", "k", NULL},
   {"uD5E6p", "h", "e", "kGT", NULL},
   {"uD5E7p", "h", "e", "k", NULL},
   {"uD5E8p", "h", "e", "n", NULL},
   {"uD5E9p", "h", "e", "n", NULL},
   {"uD5EAp", "h", "e", "n", NULL},
   {"uD5EBp", "h", "e", "t", NULL},
   {"uD5ECp", "h", "e", "l", NULL},
   {"uD5EDp", "h", "e", "l", NULL},
   {"uD5EEp", "h", "e", "l", NULL},
   {"uD5EFp", "h", "e", "l", NULL},
   {"uD5F0p", "h", "e", "l", NULL},
   {"uD5F1p", "h", "e", "l", NULL},
   {"uD5F2p", "h", "e", "l", NULL},
   {"uD5F3p", "h", "e", "l", NULL},
   {"uD5F4p", "h", "e", "m", NULL},
   {"uD5F5p", "h", "e", "p", NULL},
   {"uD5F6p", "h", "e", "p", NULL},
   {"uD5F7p", "h", "e", "sh", NULL},
   {"uD5F8p", "h", "e", "s", NULL},
   {"uD5F9p", "h", "e", "N", NULL},
   {"uD5FAp", "h", "e", "tS", NULL},
   {"uD5FBp", "h", "e", "tSh", NULL},
   {"uD5FCp", "h", "e", "kh", NULL},
   {"uD5FDp", "h", "e", "th", NULL},
   {"uD5FEp", "h", "e", "ph", NULL},
   {"uD5FFp", "h", "e", "h", NULL},
   {"uD600p", "h", "j", "^", NULL},
   {"uD601p", "h", "j", "^", NULL},
   {"uD602p", "h", "j", "^", NULL},
   {"uD603p", "h", "j", "^", NULL},
   {"uD604p", "h", "j", "^", NULL},
   {"uD605p", "h", "j", "^", NULL},
   {"uD606p", "h", "j", "^", NULL},
   {"uD607p", "h", "j", "^", NULL},
   {"uD608p", "h", "j", "^", NULL},
   {"uD609p", "h", "j", "^", NULL},
   {"uD60Ap", "h", "j", "^", NULL},
   {"uD60Bp", "h", "j", "^", NULL},
   {"uD60Cp", "h", "j", "^", NULL},
   {"uD60Dp", "h", "j", "^", NULL},
   {"uD60Ep", "h", "j", "^", NULL},
   {"uD60Fp", "h", "j", "^", NULL},
   {"uD610p", "h", "j", "^", NULL},
   {"uD611p", "h", "j", "^", NULL},
   {"uD612p", "h", "j", "^", NULL},
   {"uD613p", "h", "j", "^", NULL},
   {"uD614p", "h", "j", "^", NULL},
   {"uD615p", "h", "j", "^", NULL},
   {"uD616p", "h", "j", "^", NULL},
   {"uD617p", "h", "j", "^", NULL},
   {"uD618p", "h", "j", "^", NULL},
   {"uD619p", "h", "j", "^", NULL},
   {"uD61Ap", "h", "j", "^", NULL},
   {"uD61Bp", "h", "j", "^", NULL},
   {"uD61Cp", "h", "j", "e", NULL},
   {"uD61Dp", "h", "j", "e", NULL},
   {"uD61Ep", "h", "j", "e", NULL},
   {"uD61Fp", "h", "j", "e", NULL},
   {"uD620p", "h", "j", "e", NULL},
   {"uD621p", "h", "j", "e", NULL},
   {"uD622p", "h", "j", "e", NULL},
   {"uD623p", "h", "j", "e", NULL},
   {"uD624p", "h", "j", "e", NULL},
   {"uD625p", "h", "j", "e", NULL},
   {"uD626p", "h", "j", "e", NULL},
   {"uD627p", "h", "j", "e", NULL},
   {"uD628p", "h", "j", "e", NULL},
   {"uD629p", "h", "j", "e", NULL},
   {"uD62Ap", "h", "j", "e", NULL},
   {"uD62Bp", "h", "j", "e", NULL},
   {"uD62Cp", "h", "j", "e", NULL},
   {"uD62Dp", "h", "j", "e", NULL},
   {"uD62Ep", "h", "j", "e", NULL},
   {"uD62Fp", "h", "j", "e", NULL},
   {"uD630p", "h", "j", "e", NULL},
   {"uD631p", "h", "j", "e", NULL},
   {"uD632p", "h", "j", "e", NULL},
   {"uD633p", "h", "j", "e", NULL},
   {"uD634p", "h", "j", "e", NULL},
   {"uD635p", "h", "j", "e", NULL},
   {"uD636p", "h", "j", "e", NULL},
   {"uD637p", "h", "j", "e", NULL},
   {"uD638p", "h", "o", NULL, NULL},
   {"uD639p", "h", "o", "k", NULL},
   {"uD63Ap", "h", "o", "kGT", NULL},
   {"uD63Bp", "h", "o", "k", NULL},
   {"uD63Cp", "h", "o", "n", NULL},
   {"uD63Dp", "h", "o", "n", NULL},
   {"uD63Ep", "h", "o", "n", NULL},
   {"uD63Fp", "h", "o", "t", NULL},
   {"uD640p", "h", "o", "l", NULL},
   {"uD641p", "h", "o", "l", NULL},
   {"uD642p", "h", "o", "l", NULL},
   {"uD643p", "h", "o", "l", NULL},
   {"uD644p", "h", "o", "l", NULL},
   {"uD645p", "h", "o", "l", NULL},
   {"uD646p", "h", "o", "l", NULL},
   {"uD647p", "h", "o", "l", NULL},
   {"uD648p", "h", "o", "m", NULL},
   {"uD649p", "h", "o", "p", NULL},
   {"uD64Ap", "h", "o", "p", NULL},
   {"uD64Bp", "h", "o", "sh", NULL},
   {"uD64Cp", "h", "o", "s", NULL},
   {"uD64Dp", "h", "o", "N", NULL},
   {"uD64Ep", "h", "o", "tS", NULL},
   {"uD64Fp", "h", "o", "tSh", NULL},
   {"uD650p", "h", "o", "kh", NULL},
   {"uD651p", "h", "o", "th", NULL},
   {"uD652p", "h", "o", "ph", NULL},
   {"uD653p", "h", "o", "h", NULL},
   {"uD654p", "h", "w", "a", NULL},
   {"uD655p", "h", "w", "a", NULL},
   {"uD656p", "h", "w", "a", NULL},
   {"uD657p", "h", "w", "a", NULL},
   {"uD658p", "h", "w", "a", NULL},
   {"uD659p", "h", "w", "a", NULL},
   {"uD65Ap", "h", "w", "a", NULL},
   {"uD65Bp", "h", "w", "a", NULL},
   {"uD65Cp", "h", "w", "a", NULL},
   {"uD65Dp", "h", "w", "a", NULL},
   {"uD65Ep", "h", "w", "a", NULL},
   {"uD65Fp", "h", "w", "a", NULL},
   {"uD660p", "h", "w", "a", NULL},
   {"uD661p", "h", "w", "a", NULL},
   {"uD662p", "h", "w", "a", NULL},
   {"uD663p", "h", "w", "a", NULL},
   {"uD664p", "h", "w", "a", NULL},
   {"uD665p", "h", "w", "a", NULL},
   {"uD666p", "h", "w", "a", NULL},
   {"uD667p", "h", "w", "a", NULL},
   {"uD668p", "h", "w", "a", NULL},
   {"uD669p", "h", "w", "a", NULL},
   {"uD66Ap", "h", "w", "a", NULL},
   {"uD66Bp", "h", "w", "a", NULL},
   {"uD66Cp", "h", "w", "a", NULL},
   {"uD66Dp", "h", "w", "a", NULL},
   {"uD66Ep", "h", "w", "a", NULL},
   {"uD66Fp", "h", "w", "a", NULL},
   {"uD670p", "h", "w", "@", NULL},
   {"uD671p", "h", "w", "@", NULL},
   {"uD672p", "h", "w", "@", NULL},
   {"uD673p", "h", "w", "@", NULL},
   {"uD674p", "h", "w", "@", NULL},
   {"uD675p", "h", "w", "@", NULL},
   {"uD676p", "h", "w", "@", NULL},
   {"uD677p", "h", "w", "@", NULL},
   {"uD678p", "h", "w", "@", NULL},
   {"uD679p", "h", "w", "@", NULL},
   {"uD67Ap", "h", "w", "@", NULL},
   {"uD67Bp", "h", "w", "@", NULL},
   {"uD67Cp", "h", "w", "@", NULL},
   {"uD67Dp", "h", "w", "@", NULL},
   {"uD67Ep", "h", "w", "@", NULL},
   {"uD67Fp", "h", "w", "@", NULL},
   {"uD680p", "h", "w", "@", NULL},
   {"uD681p", "h", "w", "@", NULL},
   {"uD682p", "h", "w", "@", NULL},
   {"uD683p", "h", "w", "@", NULL},
   {"uD684p", "h", "w", "@", NULL},
   {"uD685p", "h", "w", "@", NULL},
   {"uD686p", "h", "w", "@", NULL},
   {"uD687p", "h", "w", "@", NULL},
   {"uD688p", "h", "w", "@", NULL},
   {"uD689p", "h", "w", "@", NULL},
   {"uD68Ap", "h", "w", "@", NULL},
   {"uD68Bp", "h", "w", "@", NULL},
   {"uD68Cp", "h", "w", "e", NULL},
   {"uD68Dp", "h", "w", "e", NULL},
   {"uD68Ep", "h", "w", "e", NULL},
   {"uD68Fp", "h", "w", "e", NULL},
   {"uD690p", "h", "w", "e", NULL},
   {"uD691p", "h", "w", "e", NULL},
   {"uD692p", "h", "w", "e", NULL},
   {"uD693p", "h", "w", "e", NULL},
   {"uD694p", "h", "w", "e", NULL},
   {"uD695p", "h", "w", "e", NULL},
   {"uD696p", "h", "w", "e", NULL},
   {"uD697p", "h", "w", "e", NULL},
   {"uD698p", "h", "w", "e", NULL},
   {"uD699p", "h", "w", "e", NULL},
   {"uD69Ap", "h", "w", "e", NULL},
   {"uD69Bp", "h", "w", "e", NULL},
   {"uD69Cp", "h", "w", "e", NULL},
   {"uD69Dp", "h", "w", "e", NULL},
   {"uD69Ep", "h", "w", "e", NULL},
   {"uD69Fp", "h", "w", "e", NULL},
   {"uD6A0p", "h", "w", "e", NULL},
   {"uD6A1p", "h", "w", "e", NULL},
   {"uD6A2p", "h", "w", "e", NULL},
   {"uD6A3p", "h", "w", "e", NULL},
   {"uD6A4p", "h", "w", "e", NULL},
   {"uD6A5p", "h", "w", "e", NULL},
   {"uD6A6p", "h", "w", "e", NULL},
   {"uD6A7p", "h", "w", "e", NULL},
   {"uD6A8p", "h", "j", "o", NULL},
   {"uD6A9p", "h", "j", "o", NULL},
   {"uD6AAp", "h", "j", "o", NULL},
   {"uD6ABp", "h", "j", "o", NULL},
   {"uD6ACp", "h", "j", "o", NULL},
   {"uD6ADp", "h", "j", "o", NULL},
   {"uD6AEp", "h", "j", "o", NULL},
   {"uD6AFp", "h", "j", "o", NULL},
   {"uD6B0p", "h", "j", "o", NULL},
   {"uD6B1p", "h", "j", "o", NULL},
   {"uD6B2p", "h", "j", "o", NULL},
   {"uD6B3p", "h", "j", "o", NULL},
   {"uD6B4p", "h", "j", "o", NULL},
   {"uD6B5p", "h", "j", "o", NULL},
   {"uD6B6p", "h", "j", "o", NULL},
   {"uD6B7p", "h", "j", "o", NULL},
   {"uD6B8p", "h", "j", "o", NULL},
   {"uD6B9p", "h", "j", "o", NULL},
   {"uD6BAp", "h", "j", "o", NULL},
   {"uD6BBp", "h", "j", "o", NULL},
   {"uD6BCp", "h", "j", "o", NULL},
   {"uD6BDp", "h", "j", "o", NULL},
   {"uD6BEp", "h", "j", "o", NULL},
   {"uD6BFp", "h", "j", "o", NULL},
   {"uD6C0p", "h", "j", "o", NULL},
   {"uD6C1p", "h", "j", "o", NULL},
   {"uD6C2p", "h", "j", "o", NULL},
   {"uD6C3p", "h", "j", "o", NULL},
   {"uD6C4p", "h", "u", NULL, NULL},
   {"uD6C5p", "h", "u", "k", NULL},
   {"uD6C6p", "h", "u", "kGT", NULL},
   {"uD6C7p", "h", "u", "k", NULL},
   {"uD6C8p", "h", "u", "n", NULL},
   {"uD6C9p", "h", "u", "n", NULL},
   {"uD6CAp", "h", "u", "n", NULL},
   {"uD6CBp", "h", "u", "t", NULL},
   {"uD6CCp", "h", "u", "l", NULL},
   {"uD6CDp", "h", "u", "l", NULL},
   {"uD6CEp", "h", "u", "l", NULL},
   {"uD6CFp", "h", "u", "l", NULL},
   {"uD6D0p", "h", "u", "l", NULL},
   {"uD6D1p", "h", "u", "l", NULL},
   {"uD6D2p", "h", "u", "l", NULL},
   {"uD6D3p", "h", "u", "l", NULL},
   {"uD6D4p", "h", "u", "m", NULL},
   {"uD6D5p", "h", "u", "p", NULL},
   {"uD6D6p", "h", "u", "p", NULL},
   {"uD6D7p", "h", "u", "sh", NULL},
   {"uD6D8p", "h", "u", "s", NULL},
   {"uD6D9p", "h", "u", "N", NULL},
   {"uD6DAp", "h", "u", "tS", NULL},
   {"uD6DBp", "h", "u", "tSh", NULL},
   {"uD6DCp", "h", "u", "kh", NULL},
   {"uD6DDp", "h", "u", "th", NULL},
   {"uD6DEp", "h", "u", "ph", NULL},
   {"uD6DFp", "h", "u", "h", NULL},
   {"uD6E0p", "h", "w", "^", NULL},
   {"uD6E1p", "h", "w", "^", NULL},
   {"uD6E2p", "h", "w", "^", NULL},
   {"uD6E3p", "h", "w", "^", NULL},
   {"uD6E4p", "h", "w", "^", NULL},
   {"uD6E5p", "h", "w", "^", NULL},
   {"uD6E6p", "h", "w", "^", NULL},
   {"uD6E7p", "h", "w", "^", NULL},
   {"uD6E8p", "h", "w", "^", NULL},
   {"uD6E9p", "h", "w", "^", NULL},
   {"uD6EAp", "h", "w", "^", NULL},
   {"uD6EBp", "h", "w", "^", NULL},
   {"uD6ECp", "h", "w", "^", NULL},
   {"uD6EDp", "h", "w", "^", NULL},
   {"uD6EEp", "h", "w", "^", NULL},
   {"uD6EFp", "h", "w", "^", NULL},
   {"uD6F0p", "h", "w", "^", NULL},
   {"uD6F1p", "h", "w", "^", NULL},
   {"uD6F2p", "h", "w", "^", NULL},
   {"uD6F3p", "h", "w", "^", NULL},
   {"uD6F4p", "h", "w", "^", NULL},
   {"uD6F5p", "h", "w", "^", NULL},
   {"uD6F6p", "h", "w", "^", NULL},
   {"uD6F7p", "h", "w", "^", NULL},
   {"uD6F8p", "h", "w", "^", NULL},
   {"uD6F9p", "h", "w", "^", NULL},
   {"uD6FAp", "h", "w", "^", NULL},
   {"uD6FBp", "h", "w", "^", NULL},
   {"uD6FCp", "h", "w", "e", NULL},
   {"uD6FDp", "h", "w", "e", NULL},
   {"uD6FEp", "h", "w", "e", NULL},
   {"uD6FFp", "h", "w", "e", NULL},
   {"uD700p", "h", "w", "e", NULL},
   {"uD701p", "h", "w", "e", NULL},
   {"uD702p", "h", "w", "e", NULL},
   {"uD703p", "h", "w", "e", NULL},
   {"uD704p", "h", "w", "e", NULL},
   {"uD705p", "h", "w", "e", NULL},
   {"uD706p", "h", "w", "e", NULL},
   {"uD707p", "h", "w", "e", NULL},
   {"uD708p", "h", "w", "e", NULL},
   {"uD709p", "h", "w", "e", NULL},
   {"uD70Ap", "h", "w", "e", NULL},
   {"uD70Bp", "h", "w", "e", NULL},
   {"uD70Cp", "h", "w", "e", NULL},
   {"uD70Dp", "h", "w", "e", NULL},
   {"uD70Ep", "h", "w", "e", NULL},
   {"uD70Fp", "h", "w", "e", NULL},
   {"uD710p", "h", "w", "e", NULL},
   {"uD711p", "h", "w", "e", NULL},
   {"uD712p", "h", "w", "e", NULL},
   {"uD713p", "h", "w", "e", NULL},
   {"uD714p", "h", "w", "e", NULL},
   {"uD715p", "h", "w", "e", NULL},
   {"uD716p", "h", "w", "e", NULL},
   {"uD717p", "h", "w", "e", NULL},
   {"uD718p", "h", "7", NULL, NULL},
   {"uD719p", "h", "7", "k", NULL},
   {"uD71Ap", "h", "7", "kGT", NULL},
   {"uD71Bp", "h", "7", "k", NULL},
   {"uD71Cp", "h", "7", "n", NULL},
   {"uD71Dp", "h", "7", "n", NULL},
   {"uD71Ep", "h", "7", "n", NULL},
   {"uD71Fp", "h", "7", "t", NULL},
   {"uD720p", "h", "7", "l", NULL},
   {"uD721p", "h", "7", "l", NULL},
   {"uD722p", "h", "7", "l", NULL},
   {"uD723p", "h", "7", "l", NULL},
   {"uD724p", "h", "7", "l", NULL},
   {"uD725p", "h", "7", "l", NULL},
   {"uD726p", "h", "7", "l", NULL},
   {"uD727p", "h", "7", "l", NULL},
   {"uD728p", "h", "7", "m", NULL},
   {"uD729p", "h", "7", "p", NULL},
   {"uD72Ap", "h", "7", "p", NULL},
   {"uD72Bp", "h", "7", "sh", NULL},
   {"uD72Cp", "h", "7", "s", NULL},
   {"uD72Dp", "h", "7", "N", NULL},
   {"uD72Ep", "h", "7", "tS", NULL},
   {"uD72Fp", "h", "7", "tSh", NULL},
   {"uD730p", "h", "7", "kh", NULL},
   {"uD731p", "h", "7", "th", NULL},
   {"uD732p", "h", "7", "ph", NULL},
   {"uD733p", "h", "7", "h", NULL},
   {"uD734p", "h", "j", "u", NULL},
   {"uD735p", "h", "j", "u", NULL},
   {"uD736p", "h", "j", "u", NULL},
   {"uD737p", "h", "j", "u", NULL},
   {"uD738p", "h", "j", "u", NULL},
   {"uD739p", "h", "j", "u", NULL},
   {"uD73Ap", "h", "j", "u", NULL},
   {"uD73Bp", "h", "j", "u", NULL},
   {"uD73Cp", "h", "j", "u", NULL},
   {"uD73Dp", "h", "j", "u", NULL},
   {"uD73Ep", "h", "j", "u", NULL},
   {"uD73Fp", "h", "j", "u", NULL},
   {"uD740p", "h", "j", "u", NULL},
   {"uD741p", "h", "j", "u", NULL},
   {"uD742p", "h", "j", "u", NULL},
   {"uD743p", "h", "j", "u", NULL},
   {"uD744p", "h", "j", "u", NULL},
   {"uD745p", "h", "j", "u", NULL},
   {"uD746p", "h", "j", "u", NULL},
   {"uD747p", "h", "j", "u", NULL},
   {"uD748p", "h", "j", "u", NULL},
   {"uD749p", "h", "j", "u", NULL},
   {"uD74Ap", "h", "j", "u", NULL},
   {"uD74Bp", "h", "j", "u", NULL},
   {"uD74Cp", "h", "j", "u", NULL},
   {"uD74Dp", "h", "j", "u", NULL},
   {"uD74Ep", "h", "j", "u", NULL},
   {"uD74Fp", "h", "j", "u", NULL},
   {"uD750p", "h", "4", NULL, NULL},
   {"uD751p", "h", "4", "k", NULL},
   {"uD752p", "h", "4", "kGT", NULL},
   {"uD753p", "h", "4", "k", NULL},
   {"uD754p", "h", "4", "n", NULL},
   {"uD755p", "h", "4", "n", NULL},
   {"uD756p", "h", "4", "n", NULL},
   {"uD757p", "h", "4", "t", NULL},
   {"uD758p", "h", "4", "l", NULL},
   {"uD759p", "h", "4", "l", NULL},
   {"uD75Ap", "h", "4", "l", NULL},
   {"uD75Bp", "h", "4", "l", NULL},
   {"uD75Cp", "h", "4", "l", NULL},
   {"uD75Dp", "h", "4", "l", NULL},
   {"uD75Ep", "h", "4", "l", NULL},
   {"uD75Fp", "h", "4", "l", NULL},
   {"uD750p", "h", "4", "m", NULL},
   {"uD761p", "h", "4", "p", NULL},
   {"uD762p", "h", "4", "p", NULL},
   {"uD763p", "h", "4", "sh", NULL},
   {"uD764p", "h", "4", "s", NULL},
   {"uD765p", "h", "4", "N", NULL},
   {"uD766p", "h", "4", "tS", NULL},
   {"uD767p", "h", "4", "tSh", NULL},
   {"uD768p", "h", "4", "kh", NULL},
   {"uD769p", "h", "4", "th", NULL},
   {"uD76Ap", "h", "4", "ph", NULL},
   {"uD76Bp", "h", "4", "h", NULL},
   {"uD76Cp", "h", "4", "j", NULL},
   {"uD76Dp", "h", "4", "j", NULL},
   {"uD76Ep", "h", "4", "j", NULL},
   {"uD76Fp", "h", "4", "j", NULL},
   {"uD770p", "h", "4", "j", NULL},
   {"uD771p", "h", "4", "j", NULL},
   {"uD772p", "h", "4", "j", NULL},
   {"uD773p", "h", "4", "j", NULL},
   {"uD774p", "h", "4", "j", NULL},
   {"uD775p", "h", "4", "j", NULL},
   {"uD776p", "h", "4", "j", NULL},
   {"uD777p", "h", "4", "j", NULL},
   {"uD778p", "h", "4", "j", NULL},
   {"uD779p", "h", "4", "j", NULL},
   {"uD77Ap", "h", "4", "j", NULL},
   {"uD77Bp", "h", "4", "j", NULL},
   {"uD77Cp", "h", "4", "j", NULL},
   {"uD77Dp", "h", "4", "j", NULL},
   {"uD77Ep", "h", "4", "j", NULL},
   {"uD77Fp", "h", "4", "j", NULL},
   {"uD780p", "h", "4", "j", NULL},
   {"uD781p", "h", "4", "j", NULL},
   {"uD782p", "h", "4", "j", NULL},
   {"uD783p", "h", "4", "j", NULL},
   {"uD784p", "h", "4", "j", NULL},
   {"uD785p", "h", "4", "j", NULL},
   {"uD786p", "h", "4", "j", NULL},
   {"uD787p", "h", "4", "j", NULL},
   {"uD788p", "h", "i", NULL, NULL},
   {"uD789p", "h", "i", "k", NULL},
   {"uD78Ap", "h", "i", "kGT", NULL},
   {"uD78Bp", "h", "i", "k", NULL},
   {"uD78Cp", "h", "i", "n", NULL},
   {"uD78Dp", "h", "i", "n", NULL},
   {"uD78Ep", "h", "i", "n", NULL},
   {"uD78Fp", "h", "i", "t", NULL},
   {"uD790p", "h", "i", "l", NULL},
   {"uD791p", "h", "i", "l", NULL},
   {"uD792p", "h", "i", "l", NULL},
   {"uD793p", "h", "i", "l", NULL},
   {"uD794p", "h", "i", "l", NULL},
   {"uD795p", "h", "i", "l", NULL},
   {"uD796p", "h", "i", "l", NULL},
   {"uD797p", "h", "i", "l", NULL},
   {"uD798p", "h", "i", "m", NULL},
   {"uD799p", "h", "i", "p", NULL},
   {"uD79Ap", "h", "i", "p", NULL},
   {"uD79Bp", "h", "i", "sh", NULL},
   {"uD79Cp", "h", "i", "s", NULL},
   {"uD79Dp", "h", "i", "N", NULL},
   {"uD79Ep", "h", "i", "tS", NULL},
   {"uD79Fp", "h", "i", "tSh", NULL},
   {"uD7A0p", "h", "i", "kh", NULL},
   {"uD7A1p", "h", "i", "th", NULL},
   {"uD7A2p", "h", "i", "ph", NULL},
   {"uD7A3p", "h", "i", "h", NULL},
   {"u1100p", "k", NULL, NULL, NULL},
   {"u1101p", "kGT", NULL, NULL, NULL},
   {"u1102p", "n", NULL, NULL, NULL},
   {"u1103p", "t", NULL, NULL, NULL},
   {"u1104p", "tGT", NULL, NULL, NULL},
   {"u1105p", "r", NULL, NULL, NULL},
   {"u1106p", "m", NULL, NULL, NULL},
   {"u1107p", "p", NULL, NULL, NULL},
   {"u1108p", "pGT", NULL, NULL, NULL},
   {"u1109p", "sh", NULL, NULL, NULL},
   {"u110Ap", "s", NULL, NULL, NULL},
   {"u110Bp", NULL, NULL, NULL, NULL},
   {"u110Cp", "tS", NULL, NULL, NULL},
   {"u110Dp", "tSGT", NULL, NULL, NULL},
   {"u110Ep", "tSh", NULL, NULL, NULL},
   {"u110Fp", "kh", NULL, NULL, NULL},
   {"u1110p", "th", NULL, NULL, NULL},
   {"u1112p", "h", NULL, NULL, NULL},
   {"u113Cp", "sh", NULL, NULL, NULL},
   {"u113Dp", "s", NULL, NULL, NULL},
   {"u113Ep", "sh", NULL, NULL, NULL},
   {"u113Fp", "s", NULL, NULL, NULL},
   {"u114Cp", NULL, NULL, NULL, NULL},
   {"u114Ep", "tS", NULL, NULL, NULL},
   {"u114Fp", "tSGT", NULL, NULL, NULL},
   {"u1150p", "tS", NULL, NULL, NULL},
   {"u1151p", "tSGT", NULL, NULL, NULL},
   {"u1154p", "tSh", NULL, NULL, NULL},
   {"u1155p", "tSh", NULL, NULL, NULL},
   {"u115Fp", "(CHOSEONG FILLER)", NULL, NULL, NULL},
   {"u1160p", "(JUNGSEONG FILLER)", NULL, NULL, NULL},
   {"u1161p", "a", NULL, NULL, NULL},
   {"u1162p", "@", NULL, NULL, NULL},
   {"u1163p", "j", "a", NULL, NULL},
   {"u1164p", "j", "@", NULL, NULL},
   {"u1165p", "^", NULL, NULL, NULL},
   {"u1166p", "e", NULL, NULL, NULL},
   {"u1167p", "j", "^", NULL, NULL},
   {"u1168p", "j", "e", NULL, NULL},
   {"u1169p", "o", NULL, NULL, NULL},
   {"u116Ap", "w", "a", NULL, NULL},
   {"u116Bp", "w", "@", NULL, NULL},
   {"u116Cp", "w", "e", NULL, NULL},
   {"u116Dp", "j", "o", NULL, NULL},
   {"u116Ep", "u", NULL, NULL, NULL},
   {"u116Fp", "w", "^", NULL, NULL},
   {"u1170p", "w", "e", NULL, NULL},
   {"u1171p", "7", NULL, NULL, NULL},
   {"u1172p", "j", "u", NULL, NULL},
   {"u1173p", "4", NULL, NULL, NULL},
   {"u1174p", "4", "j", NULL, NULL},
   {"u1175p", "i", NULL, NULL, NULL},
   {"u11A8p", "k", NULL, NULL, NULL},
   {"u11A9p", "kGT", NULL, NULL, NULL},
   {"u11AAp", "k", "sh", NULL, NULL},
   {"u11ABp", "n", NULL, NULL, NULL},
   {"u11ACp", "n", "tS", NULL, NULL},
   {"u11ADp", "n", "h", NULL, NULL},
   {"u11AEp", "t", NULL, NULL, NULL},
   {"u11AFp", "l", NULL, NULL, NULL},
   {"u11B0p", "l", "k", NULL, NULL},
   {"u11B1p", "l", "m", NULL, NULL},
   {"u11B2p", "l", "p", NULL, NULL},
   {"u11B3p", "l", "sh", NULL, NULL},
   {"u11B4p", "l", "th", NULL, NULL},
   {"u11B5p", "l", "ph", NULL, NULL},
   {"u11B6p", "l", "h", NULL, NULL},
   {"u11B7p", "m", NULL, NULL, NULL},
   {"u11B8p", "p", NULL, NULL, NULL},
   {"u11B9p", "p", "sh", NULL, NULL},
   {"u11BAp", "sh", NULL, NULL, NULL},
   {"u11BBp", "s", NULL, NULL, NULL},
   {"u11BCp", "N", NULL, NULL, NULL},
   {"u11BDp", "tS", NULL, NULL, NULL},
   {"u11BEp", "tSh", NULL, NULL, NULL},
   {"u11BFp", "kh", NULL, NULL, NULL},
   {"u11C0p", "th", NULL, NULL, NULL},
   {"u11C1p", "ph", NULL, NULL, NULL},
   {"u11C2p", "h", NULL, NULL, NULL},
   {"u11F0p", "N", NULL, NULL, NULL},
   {"u3131p", "k", NULL, NULL, NULL},
   {"u3132p", "kGT", NULL, NULL, NULL},
   {"u3133p", "k", "sh", NULL, NULL},
   {"u3134p", "n", NULL, NULL, NULL},
   {"u3135p", "n", "tS", NULL, NULL},
   {"u3136p", "n", "h", NULL, NULL},
   {"u3137p", "t", NULL, NULL, NULL},
   {"u3138p", "tGT", NULL, NULL, NULL},
   {"u3139p", "r", NULL, NULL, NULL},
   {"u313Ap", "l", "k", NULL, NULL},
   {"u313Bp", "l", "m", NULL, NULL},
   {"u313Cp", "l", "b", NULL, NULL},
   {"u313Dp", "l", "sh", NULL, NULL},
   {"u313Ep", "l", "th", NULL, NULL},
   {"u313Fp", "l", "ph", NULL, NULL},
   {"u3140p", "l", "h", NULL, NULL},
   {"u3141p", "m", NULL, NULL, NULL},
   {"u3142p", "p", NULL, NULL, NULL},
   {"u3143p", "pGT", NULL, NULL, NULL},
   {"u3144p", "b", "sh", NULL, NULL},
   {"u3145p", "sh", NULL, NULL, NULL},
   {"u3146p", "s", NULL, NULL, NULL},
   {"u3147p", NULL, NULL, NULL, NULL},
   {"u3148p", "tS", NULL, NULL, NULL},
   {"u3149p", "tSGT", NULL, NULL, NULL},
   {"u314Ap", "tSh", NULL, NULL, NULL},
   {"u314Bp", "kh", NULL, NULL, NULL},
   {"u314Cp", "th", NULL, NULL, NULL},
   {"u314Dp", "ph", NULL, NULL, NULL},
   {"u314Ep", "h", NULL, NULL, NULL},
   {"u314Fp", "a", NULL, NULL, NULL},
   {"u3150p", "@", NULL, NULL, NULL},
   {"u3151p", "j", "a", NULL, NULL},
   {"u3152p", "J", "@", NULL, NULL},
   {"u3153p", "^", NULL, NULL, NULL},
   {"u3154p", "e", NULL, NULL, NULL},
   {"u3155p", "j", "^", NULL, NULL},
   {"u3156p", "j", "e", NULL, NULL},
   {"u3157p", "o", NULL, NULL, NULL},
   {"u3158p", "w", "a", NULL, NULL},
   {"u3159p", "w", "@", NULL, NULL},
   {"u315Ap", "w", "e", NULL, NULL},
   {"u315Bp", "j", "o", NULL, NULL},
   {"u315Cp", "u", NULL, NULL, NULL},
   {"u315Dp", "w", "^", NULL, NULL},
   {"u315Ep", "w", "e", NULL, NULL},
   {"u315Fp", "7", NULL, NULL, NULL},
   {"u3160p", "j", "u", NULL, NULL},
   {"u3161p", "4", NULL, NULL, NULL},
   {"u3162p", "4", "j", NULL, NULL},
   {"u3163p", "i", NULL, NULL, NULL},
   {"u3164p", "(HANGUL FILLER)", NULL, NULL, NULL},
   {"u0E81p", "k", NULL, NULL, NULL},
   {"u0E82p", "kh", NULL, NULL, NULL},
   {"u0E84p", "kh", NULL, NULL, NULL},
   {"u0E87p", "N", NULL, NULL, NULL},
   {"u0E88p", "c", NULL, NULL, NULL},
   {"u0E8Ap", "s", NULL, NULL, NULL},
   {"u0E8Dp", "j", NULL, NULL, NULL},
   {"u0E94p", "d", NULL, NULL, NULL},
   {"u0E95p", "t", NULL, NULL, NULL},
   {"u0E96p", "th", NULL, NULL, NULL},
   {"u0E97p", "th", NULL, NULL, NULL},
   {"u0E99p", "n", NULL, NULL, NULL},
   {"u0E9Ap", "b", NULL, NULL, NULL},
   {"u0E9Bp", "p", NULL, NULL, NULL},
   {"u0E9Cp", "ph", NULL, NULL, NULL},
   {"u0E9Dp", "f", NULL, NULL, NULL},
   {"u0E9Ep", "ph", NULL, NULL, NULL},
   {"u0E9Fp", "f", NULL, NULL, NULL},
   {"u0EA1p", "m", NULL, NULL, NULL},
   {"u0EA2p", "n~", NULL, NULL, NULL},
   {"u0EA3p", "h", NULL, NULL, NULL},
   {"u0EA5p", "l", NULL, NULL, NULL},
   {"u0EA7p", "w", NULL, NULL, NULL},
   {"u0EAAp", "s", NULL, NULL, NULL},
   {"u0EABp", "h", NULL, NULL, NULL},
   {"u0EADp", NULL, NULL, NULL, NULL},
   {"u0EAEp", "h", NULL, NULL, NULL},
   {"u0EAFp", "(ELLIPSIS)", NULL, NULL, NULL},
   {"u0EB0p", "A", NULL, NULL, NULL},
   {"u0EB1p", "A", NULL, NULL, NULL},
   {"u0EB2p", "A:", NULL, NULL, NULL},
   {"u0EB3p", "A", "m", NULL, NULL},
   {"u0EB4p", "i", NULL, NULL, NULL},
   {"u0EB5p", "i:", NULL, NULL, NULL},
   {"u0EB6p", "4", NULL, NULL, NULL},
   {"u0EB7p", "4:", NULL, NULL, NULL},
   {"u0EB8p", "u", NULL, NULL, NULL},
   {"u0EB9p", "u:", NULL, NULL, NULL},
   {"u0EBBp", "MAIKON", NULL, NULL, NULL},
   {"u0EBCp", "LO", NULL, NULL, NULL},
   {"u0EBDp", "NYO", NULL, NULL, NULL},
   {"u0EC0p", "e:", NULL, NULL, NULL},
   {"u0EC1p", "@", NULL, NULL, NULL},
   {"u0EC2p", "o", NULL, NULL, NULL},
   {"u0EC3p", "aI", NULL, NULL, NULL},
   {"u0EC4p", "aI", NULL, NULL, NULL},
   {"u0EC6p", "KOLA", NULL, NULL, NULL},
   {"u0EC8p", "MAIEK", NULL, NULL, NULL},
   {"u0EC9p", "MAITHO", NULL, NULL, NULL},
   {"u0ECAp", "MAITI", NULL, NULL, NULL},
   {"u0ECBp", "MAICATAWA", NULL, NULL, NULL},
   {"u0ECCp", "(CANCELLATION MARK)", NULL, NULL, NULL},
   {"u0ECDp", "NIGGAHITA", NULL, NULL, NULL},
   {"u0ED0p", "(ZERO)", NULL, NULL, NULL},
   {"u0ED1p", "(ONE)", NULL, NULL, NULL},
   {"u0ED2p", "(TWO)", NULL, NULL, NULL},
   {"u0ED3p", "(THREE)", NULL, NULL, NULL},
   {"u0ED4p", "(FOUR)", NULL, NULL, NULL},
   {"u0ED5p", "(FIVE)", NULL, NULL, NULL},
   {"u0ED6p", "(SIX)", NULL, NULL, NULL},
   {"u0ED7p", "(SEVEN)", NULL, NULL, NULL},
   {"u0ED8p", "(EIGHT)", NULL, NULL, NULL},
   {"u0ED9p", "(NINE)", NULL, NULL, NULL},
   {"u0EDCp", "h", "n", NULL, NULL},
   {"u0EDDp", "h", "m", NULL, NULL},
   {"u1900p", "(VOWEL CARRIER)", NULL, NULL, NULL},
   {"u1901p", "k", "A", NULL, NULL},
   {"u1902p", "kh", "A", NULL, NULL},
   {"u1903p", "g", "A", NULL, NULL},
   {"u1904p", "gh", "A", NULL, NULL},
   {"u1905p", "N", "A", NULL, NULL},
   {"u1906p", "c", "A", NULL, NULL},
   {"u1907p", "ch", "A", NULL, NULL},
   {"u1908p", "J", "A", NULL, NULL},
   {"u1909p", "Jh", "a", NULL, NULL},
   {"u190Ap", "j", "Ar", NULL, NULL},
   {"u190Bp", "tB", "A", NULL, NULL},
   {"u190Cp", "tBh", "A", NULL, NULL},
   {"u190Dp", "dB", "A", NULL, NULL},
   {"u190Ep", "dBh", "A", NULL, NULL},
   {"u190Fp", "nB", "A", NULL, NULL},
   {"u1910p", "p", "A", NULL, NULL},
   {"u1911p", "ph", "A", NULL, NULL},
   {"u1912p", "b", "A", NULL, NULL},
   {"u1913p", "bh", "A", NULL, NULL},
   {"u1914p", "m", "A", NULL, NULL},
   {"u1915p", "j", "A", NULL, NULL},
   {"u1916p", "9r", "A", NULL, NULL},
   {"u1917p", "l", "A", NULL, NULL},
   {"u1918p", "w", "A", NULL, NULL},
   {"u1919p", "S", "A", NULL, NULL},
   {"u191Ap", "S", "A", NULL, NULL},
   {"u191Bp", "s", "A", NULL, NULL},
   {"u191Cp", "h", "A", NULL, NULL},
   {"u1920p", "A", NULL, NULL, NULL},
   {"u1921p", "i", NULL, NULL, NULL},
   {"u1922p", "u", NULL, NULL, NULL},
   {"u1923p", "e:", NULL, NULL, NULL},
   {"u1924p", "aI", NULL, NULL, NULL},
   {"u1925p", "o:", NULL, NULL, NULL},
   {"u1926p", "aU", NULL, NULL, NULL},
   {"u1927p", "e", NULL, NULL, NULL},
   {"u1928p", "o", NULL, NULL, NULL},
   {"u1929p", "j", "A", NULL, NULL},
   {"u192Ap", "9r", "A", NULL, NULL},
   {"u192Bp", "w", "A", NULL, NULL},
   {"u1930p", "k", "A", NULL, NULL},
   {"u1931p", "N", "A", NULL, NULL},
   {"u1932p", "M", "A", NULL, NULL},
   {"u1933p", "tB", "A", NULL, NULL},
   {"u1934p", "nB", "A", NULL, NULL},
   {"u1935p", "p", "A", NULL, NULL},
   {"u1936p", "m", "A", NULL, NULL},
   {"u1937p", "9r", "A", NULL, NULL},
   {"u1938p", "l", "A", NULL, NULL},
   {"u1939p", "(MUKPHRENG)", NULL, NULL, NULL},
   {"u193Ap", "(KEMPHRENG)", NULL, NULL, NULL},
   {"u193Bp", "P", NULL, NULL, NULL},
   {"u1940p", "(LOO)", NULL, NULL, NULL},
   {"u1944p", "(EXCLAMATION MARK)", NULL, NULL, NULL},
   {"u1945p", "(QUESTION MARK)", NULL, NULL, NULL},
   {"u1946p", "(ZERO)", NULL, NULL, NULL},
   {"u1947p", "(ONE)", NULL, NULL, NULL},
   {"u1948p", "(TWO)", NULL, NULL, NULL},
   {"u1949p", "(THREE)", NULL, NULL, NULL},
   {"u194Ap", "(FOUR)", NULL, NULL, NULL},
   {"u194Bp", "(FIVE)", NULL, NULL, NULL},
   {"u194Cp", "(SIX)", NULL, NULL, NULL},
   {"u194Dp", "(SEVEN)", NULL, NULL, NULL},
   {"u194Ep", "(EIGHT)", NULL, NULL, NULL},
   {"u194Fp", "(NINE)", NULL, NULL, NULL},
   {"u0D01p", "R:0D01", NULL, NULL, NULL},
   {"u0D02p", "M", NULL, NULL, NULL},
   {"u0D03p", "H", NULL, NULL, NULL},
   {"u0D05p", "A", NULL, NULL, NULL},
   {"u0D06p", "A:", NULL, NULL, NULL},
   {"u0D07p", "i", NULL, NULL, NULL},
   {"u0D08p", "i:", NULL, NULL, NULL},
   {"u0D09p", "u", NULL, NULL, NULL},
   {"u0D0Ap", "u:", NULL, NULL, NULL},
   {"u0D0Bp", "9r", "ix", NULL, NULL},
   {"u0D0Cp", "l=", NULL, NULL, NULL},
   {"u0D0Dp", "R:0D0D", NULL, NULL, NULL},
   {"u0D0Ep", "e", NULL, NULL, NULL},
   {"u0D0Fp", "e:", NULL, NULL, NULL},
   {"u0D10p", "aI", NULL, NULL, NULL},
   {"u0D11p", "R:0D11", NULL, NULL, NULL},
   {"u0D12p", "o", NULL, NULL, NULL},
   {"u0D13p", "o:", NULL, NULL, NULL},
   {"u0D14p", "aU", NULL, NULL, NULL},
   {"u0D15p", "k", "A", NULL, NULL},
   {"u0D16p", "kh", "A", NULL, NULL},
   {"u0D17p", "g", "A", NULL, NULL},
   {"u0D18p", "gh", "A", NULL, NULL},
   {"u0D19p", "N", "A", NULL, NULL},
   {"u0D1Ap", "c", "A", NULL, NULL},
   {"u0D1Bp", "ch", "A", NULL, NULL},
   {"u0D1Cp", "J", "A", NULL, NULL},
   {"u0D1Dp", "Jh", "A", NULL, NULL},
   {"u0D1Ep", "n~", "A", NULL, NULL},
   {"u0D1Fp", "tr", "A", NULL, NULL},
   {"u0D20p", "tR", "A", NULL, NULL},
   {"u0D21p", "dr", "A", NULL, NULL},
   {"u0D22p", "dR", "A", NULL, NULL},
   {"u0D23p", "nr", "A", NULL, NULL},
   {"u0D24p", "tB", "A", NULL, NULL},
   {"u0D25p", "tBh", "A", NULL, NULL},
   {"u0D26p", "dB", "A", NULL, NULL},
   {"u0D27p", "dBh", "A", NULL, NULL},
   {"u0D28p", "nB", "A", NULL, NULL},
   {"u0D29p", "R:0D29", NULL, NULL, NULL},
   {"u0D2Ap", "p", "A", NULL, NULL},
   {"u0D2Bp", "ph", "A", NULL, NULL},
   {"u0D2Cp", "b", "A", NULL, NULL},
   {"u0D2Dp", "bh", "A", NULL, NULL},
   {"u0D2Ep", "m", "A", NULL, NULL},
   {"u0D2Fp", "j", "A", NULL, NULL},
   {"u0D30p", "9rB", "A", NULL, NULL},
   {"u0D31p", "9r", "A", NULL, NULL},
   {"u0D32p", "l", "A", NULL, NULL},
   {"u0D33p", "lr", "A", NULL, NULL},
   {"u0D34p", "l", "A", NULL, NULL},
   {"u0D35p", "v", "A", NULL, NULL},
   {"u0D36p", "c}", "A", NULL, NULL},
   {"u0D37p", "S", "A", NULL, NULL},
   {"u0D38p", "s", "A", NULL, NULL},
   {"u0D39p", "hv", "A", NULL, NULL},
   {"u0D3Ep", "A:", NULL, NULL, NULL},
   {"u0D3Fp", "i", NULL, NULL, NULL},
   {"u0D40p", "i:", NULL, NULL, NULL},
   {"u0D41p", "u", NULL, NULL, NULL},
   {"u0D42p", "u:", NULL, NULL, NULL},
   {"u0D43p", "9r=", NULL, NULL, NULL},
   {"u0D45p", "R:0D45", NULL, NULL, NULL},
   {"u0D46p", "e", NULL, NULL, NULL},
   {"u0D47p", "e:", NULL, NULL, NULL},
   {"u0D48p", "aI", NULL, NULL, NULL},
   {"u0D49p", "R:0D49", NULL, NULL, NULL},
   {"u0D4Ap", "o", NULL, NULL, NULL},
   {"u0D4Bp", "o:", NULL, NULL, NULL},
   {"u0D4Cp", "aU", NULL, NULL, NULL},
   {"u0D4Dp", "P", NULL, NULL, NULL},
   {"u0D57p", "(aU LENGTH MARK)", NULL, NULL, NULL},
   {"u0D5Fp", "R:0D5F", NULL, NULL, NULL},
   {"u0D60p", "rr=", NULL, NULL, NULL},
   {"u0D61p", "lr=", NULL, NULL, NULL},
   {"u0D64p", "R:0D64", NULL, NULL, NULL},
   {"u0D66p", "(ZERO)", NULL, NULL, NULL},
   {"u0D67p", "(ONE)", NULL, NULL, NULL},
   {"u0D68p", "(TWO)", NULL, NULL, NULL},
   {"u0D69p", "(THREE)", NULL, NULL, NULL},
   {"u0D6Ap", "(FOUR)", NULL, NULL, NULL},
   {"u0D6Bp", "(FIVE)", NULL, NULL, NULL},
   {"u0D6Cp", "(SIX)", NULL, NULL, NULL},
   {"u0D6Dp", "(SEVEN)", NULL, NULL, NULL},
   {"u0D6Ep", "(EIGHT)", NULL, NULL, NULL},
   {"u0D6Fp", "(NINE)", NULL, NULL, NULL},
   {"uFEFFp", "(BOM)", NULL, NULL, NULL},
   {"u1810p", "(ZERO)", NULL, NULL, NULL},
   {"u1811p", "(ONE)", NULL, NULL, NULL},
   {"u1812p", "(TWO)", NULL, NULL, NULL},
   {"u1813p", "(THREE)", NULL, NULL, NULL},
   {"u1814p", "(FOUR)", NULL, NULL, NULL},
   {"u1815p", "(FIVE)", NULL, NULL, NULL},
   {"u1816p", "(SIX)", NULL, NULL, NULL},
   {"u1817p", "(SEVEN)", NULL, NULL, NULL},
   {"u1818p", "(EIGHT)", NULL, NULL, NULL},
   {"u1819p", "(NINE)", NULL, NULL, NULL},
   {"u1820p", "A", NULL, NULL, NULL},
   {"u1821p", "E", NULL, NULL, NULL},
   {"u1822p", "i", NULL, NULL, NULL},
   {"u1823p", "GT", NULL, NULL, NULL},
   {"u1824p", "u", NULL, NULL, NULL},
   {"u1825p", "o", NULL, NULL, NULL},
   {"u1826p", "u", NULL, NULL, NULL},
   {"u1827p", "E:", NULL, NULL, NULL},
   {"u1828p", "n", "A", NULL, NULL},
   {"u1829p", "N", NULL, NULL, NULL},
   {"u182Ap", "b", "A", NULL, NULL},
   {"u182Bp", "p", "A", NULL, NULL},
   {"u182Cp", "x", "A", NULL, NULL},
   {"u182Dp", "g", "A", NULL, NULL},
   {"u182Ep", "m", "A", NULL, NULL},
   {"u182Fp", "l", "A", NULL, NULL},
   {"u1830p", "s", "A", NULL, NULL},
   {"u1831p", "S", "A", NULL, NULL},
   {"u1832p", "t", "A", NULL, NULL},
   {"u1833p", "d", "A", NULL, NULL},
   {"u1834p", "tSj", "A", NULL, NULL},
   {"u1835p", "Z", "A", NULL, NULL},
   {"u1836p", "j", "A", NULL, NULL},
   {"u1837p", "r", "A", NULL, NULL},
   {"u1838p", "v", "A", NULL, NULL},
   {"u1839p", "f", "A", NULL, NULL},
   {"u183Ap", "x", "A", NULL, NULL},
   {"u183Bp", "k", "A", NULL, NULL},
   {"u183Cp", "ts", "A", NULL, NULL},
   {"u183Dp", "z", "A", NULL, NULL},
   {"u183Ep", "x", "A:", NULL, NULL},
   {"u183Fp", "Z", "A", NULL, NULL},
   {"u1840p", "hl", "A", NULL, NULL},
   {"u1841p", "S", "A", NULL, NULL},
   {"u1842p", "tS", "j", NULL, NULL},
   {"u1843p", "(:)", NULL, NULL, NULL},
   {"u1844p", "E", NULL, NULL, NULL},
   {"u1845p", "i", NULL, NULL, NULL},
   {"u1846p", "o", NULL, NULL, NULL},
   {"u1847p", "u", NULL, NULL, NULL},
   {"u1848p", "o", NULL, NULL, NULL},
   {"u1849p", "u", NULL, NULL, NULL},
   {"u184Ap", "N", NULL, NULL, NULL},
   {"u184Bp", "b", "A", NULL, NULL},
   {"u184Cp", "p", "A", NULL, NULL},
   {"u184Dp", "x", "A", NULL, NULL},
   {"u184Ep", "g", "A", NULL, NULL},
   {"u184Fp", "m", "A", NULL, NULL},
   {"u1850p", "t", "A", NULL, NULL},
   {"u1851p", "d", "A", NULL, NULL},
   {"u1852p", "tSj", "A", NULL, NULL},
   {"u1853p", "Z", "A", NULL, NULL},
   {"u1854p", "ts", "A", NULL, NULL},
   {"u1855p", "j", "A", NULL, NULL},
   {"u1856p", "w", "A", NULL, NULL},
   {"u1857p", "k", "A", NULL, NULL},
   {"u1858p", "g", "A:", NULL, NULL},
   {"u1859p", "x", "A:", NULL, NULL},
   {"u185Ap", "Z", "A", NULL, NULL},
   {"u185Bp", "n", "A", NULL, NULL},
   {"u185Cp", "dz", "A", NULL, NULL},
   {"u185Dp", "E", NULL, NULL, NULL},
   {"u185Ep", "i", NULL, NULL, NULL},
   {"u185Fp", "j", NULL, NULL, NULL},
   {"u1860p", "u", NULL, NULL, NULL},
   {"u1861p", "u", NULL, NULL, NULL},
   {"u1862p", "N", NULL, NULL, NULL},
   {"u1863p", "k", "A", NULL, NULL},
   {"u1864p", "g", "A", NULL, NULL},
   {"u1865p", "x", "A", NULL, NULL},
   {"u1866p", "p", "A", NULL, NULL},
   {"u1867p", "S", "A", NULL, NULL},
   {"u1868p", "t", "A", NULL, NULL},
   {"u1869p", "d", "A", NULL, NULL},
   {"u186Ap", "Z", "A", NULL, NULL},
   {"u186Bp", "f", "A", NULL, NULL},
   {"u186Cp", "g", "A:", NULL, NULL},
   {"u186Dp", "x", "A:", NULL, NULL},
   {"u186Ep", "ts", "A", NULL, NULL},
   {"u186Fp", "z", "A", NULL, NULL},
   {"u1870p", "r", "A:", NULL, NULL},
   {"u1871p", "tSj", "A", NULL, NULL},
   {"u1872p", "S", "A", NULL, NULL},
   {"u1873p", "i", NULL, NULL, NULL},
   {"u1874p", "k", "A", NULL, NULL},
   {"u1875p", "f", "A", NULL, NULL},
   {"u1876p", "S", "A", NULL, NULL},
   {"u1887p", "A", NULL, NULL, NULL},
   {"u1888p", "i", NULL, NULL, NULL},
   {"u1889p", "k", "A", NULL, NULL},
   {"u188Ap", "N", "A", NULL, NULL},
   {"u188Bp", "tS", "A", NULL, NULL},
   {"u188Cp", "t", "t", "A", NULL},
   {"u188Dp", "t", "th", "A", NULL},
   {"u188Ep", "t", "t", "A", NULL},
   {"u188Fp", "n", "n", "A", NULL},
   {"u1890p", "t", "A", NULL, NULL},
   {"u1891p", "t", "A", NULL, NULL},
   {"u1892p", "p", "A", NULL, NULL},
   {"u1893p", "ph", "A", NULL, NULL},
   {"u1894p", "S", "S", "A", NULL},
   {"u1895p", "S", "A", NULL, NULL},
   {"u1896p", "z", "A", NULL, NULL},
   {"u1897p", "Ah", NULL, NULL, NULL},
   {"u1898p", "t", "A", NULL, NULL},
   {"u1899p", "S", "A", NULL, NULL},
   {"u189Ap", "Gh", "A", NULL, NULL},
   {"u189Bp", "N", "A", NULL, NULL},
   {"u189Cp", "tS", "A", NULL, NULL},
   {"u189Dp", "zh", "A", NULL, NULL},
   {"u189Ep", "t", "t", "A", NULL},
   {"u189Fp", "th", "A", NULL, NULL},
   {"u18A0p", "t", "A", NULL, NULL},
   {"u18A1p", "th", "A", NULL, NULL},
   {"u18A2p", "S", "S", "A", NULL},
   {"u18A3p", "tSj", "A", NULL, NULL},
   {"u18A4p", "S", "A", NULL, NULL},
   {"u18A5p", "s", "A", NULL, NULL},
   {"u18A6p", "u", NULL, NULL, NULL},
   {"u18A7p", "j", "A", NULL, NULL},
   {"u18A8p", "(BHA)", NULL, NULL, NULL},
   {"u18A9p", "(DAGALGA)", NULL, NULL, NULL},
   {"u1000p", "k", "A", NULL, NULL},
   {"u1001p", "kh", "A", NULL, NULL},
   {"u1002p", "g", "A", NULL, NULL},
   {"u1003p", "g", "A", NULL, NULL},
   {"u1004p", "N", "A", NULL, NULL},
   {"u1005p", "s", "A", NULL, NULL},
   {"u1006p", "sh", "A", NULL, NULL},
   {"u1007p", "z", "A", NULL, NULL},
   {"u1008p", "z", "A", NULL, NULL},
   {"u1009p", "n~", "A", NULL, NULL},
   {"u100Ap", "n~", "A", NULL, NULL},
   {"u100Bp", "tr", "A", NULL, NULL},
   {"u100Cp", "trh", "A", NULL, NULL},
   {"u100Dp", "d", "A", NULL, NULL},
   {"u100Ep", "d", "A", NULL, NULL},
   {"u100Fp", "n", "A", NULL, NULL},
   {"u1010p", "tr", "A", NULL, NULL},
   {"u1011p", "trh", "A", NULL, NULL},
   {"u1012p", "d", "A", NULL, NULL},
   {"u1013p", "d", "A", NULL, NULL},
   {"u1014p", "n", "A", NULL, NULL},
   {"u1015p", "p", "A", NULL, NULL},
   {"u1016p", "ph", "A", NULL, NULL},
   {"u1017p", "b", "A", NULL, NULL},
   {"u1018p", "bh", "A", NULL, NULL},
   {"u1019p", "m", "A", NULL, NULL},
   {"u101Ap", "j", "A", NULL, NULL},
   {"u101Bp", "j", "A", NULL, NULL},
   {"u101Cp", "l", "A", NULL, NULL},
   {"u101Dp", "w", "A", NULL, NULL},
   {"u101Ep", "T", "A", NULL, NULL},
   {"u101Fp", "h", "A", NULL, NULL},
   {"u1020p", "l", "A", NULL, NULL},
   {"u1021p", "A", NULL, NULL, NULL},
   {"u1023p", "i", NULL, NULL, NULL},
   {"u1024p", "i", NULL, NULL, NULL},
   {"u1025p", "u", NULL, NULL, NULL},
   {"u1026p", "u", NULL, NULL, NULL},
   {"u1027p", "e", NULL, NULL, NULL},
   {"u1029p", "o", NULL, NULL, NULL},
   {"u102Ap", "GT", NULL, NULL, NULL},
   {"u102Cp", "A", NULL, NULL, NULL},
   {"u102Dp", "i", NULL, NULL, NULL},
   {"u102Ep", "i", NULL, NULL, NULL},
   {"u102Fp", "u", NULL, NULL, NULL},
   {"u1030p", "u", NULL, NULL, NULL},
   {"u1031p", "e", NULL, NULL, NULL},
   {"u1032p", "E", NULL, NULL, NULL},
   {"u1036p", "M", NULL, NULL, NULL},
   {"u1037p", "(TONE MARK)", NULL, NULL, NULL},
   {"u1038p", "H", NULL, NULL, NULL},
   {"u1039p", "P", NULL, NULL, NULL},
   {"u1040p", "(ZERO)", NULL, NULL, NULL},
   {"u1041p", "(ONE)", NULL, NULL, NULL},
   {"u1042p", "(TWO)", NULL, NULL, NULL},
   {"u1043p", "(THREE)", NULL, NULL, NULL},
   {"u1044p", "(FOUR)", NULL, NULL, NULL},
   {"u1045p", "(FIVE)", NULL, NULL, NULL},
   {"u1046p", "(SIX)", NULL, NULL, NULL},
   {"u1047p", "(SEVEN)", NULL, NULL, NULL},
   {"u1048p", "(EIGHT)", NULL, NULL, NULL},
   {"u1049p", "(NINE)", NULL, NULL, NULL},
   {"u104Ap", "(DANDA)", NULL, NULL, NULL},
   {"u104Bp", "(DOUBLE DANDA)", NULL, NULL, NULL},
   {"u104Cp", "(LOCATIVE)", NULL, NULL, NULL},
   {"u104Dp", "(COMPLETED)", NULL, NULL, NULL},
   {"u104Ep", "(AFOREMENTIONED)", NULL, NULL, NULL},
   {"u104Fp", "(GENETIVE)", NULL, NULL, NULL},
   {"u1050p", "sh", NULL, NULL, NULL},
   {"u1051p", "sr", NULL, NULL, NULL},
   {"u1052p", "r=", NULL, NULL, NULL},
   {"u1053p", "rr=", NULL, NULL, NULL},
   {"u1054p", "l=", NULL, NULL, NULL},
   {"u1055p", "l=", NULL, NULL, NULL},
   {"u1056p", "r=", NULL, NULL, NULL},
   {"u1057p", "rr=", NULL, NULL, NULL},
   {"u1058p", "l=", NULL, NULL, NULL},
   {"u1059p", "l=", NULL, NULL, NULL},
   {"u0B01p", "CD", NULL, NULL, NULL},
   {"u0B02p", "M", NULL, NULL, NULL},
   {"u0B03p", "H", NULL, NULL, NULL},
   {"u0B05p", "GT", NULL, NULL, NULL},
   {"u0B06p", "A", NULL, NULL, NULL},
   {"u0B07p", "i", NULL, NULL, NULL},
   {"u0B08p", "i:", NULL, NULL, NULL},
   {"u0B09p", "u", NULL, NULL, NULL},
   {"u0B0Ap", "u:", NULL, NULL, NULL},
   {"u0B0Bp", "9r=", NULL, NULL, NULL},
   {"u0B0Cp", "l=", NULL, NULL, NULL},
   {"u0B0Ep", "R:0B0E", NULL, NULL, NULL},
   {"u0B0Fp", "e", NULL, NULL, NULL},
   {"u0B10p", "GTI", NULL, NULL, NULL},
   {"u0B13p", "o", NULL, NULL, NULL},
   {"u0B14p", "aU", NULL, NULL, NULL},
   {"u0B15p", "k", "A", NULL, NULL},
   {"u0B16p", "kh", "A", NULL, NULL},
   {"u0B17p", "g", "A", NULL, NULL},
   {"u0B18p", "gh", "A", NULL, NULL},
   {"u0B19p", "N", "A", NULL, NULL},
   {"u0B1Ap", "c", "A", NULL, NULL},
   {"u0B1Bp", "ch", "A", NULL, NULL},
   {"u0B1Cp", "J", "A", NULL, NULL},
   {"u0B1Dp", "Jh", "A", NULL, NULL},
   {"u0B1Ep", "n~", "A", NULL, NULL},
   {"u0B1Fp", "tr", "A", NULL, NULL},
   {"u0B20p", "tR", "A", NULL, NULL},
   {"u0B21p", "dr", "A", NULL, NULL},
   {"u0B22p", "dR", "A", NULL, NULL},
   {"u0B23p", "nr", "A", NULL, NULL},
   {"u0B24p", "tB", "A", NULL, NULL},
   {"u0B25p", "tBh", "A", NULL, NULL},
   {"u0B26p", "dB", "A", NULL, NULL},
   {"u0B27p", "dBh", "A", NULL, NULL},
   {"u0B28p", "nB", "A", NULL, NULL},
   {"u0B29p", "R:0B29", NULL, NULL, NULL},
   {"u0B2Ap", "p", "A", NULL, NULL},
   {"u0B2Bp", "ph", "A", NULL, NULL},
   {"u0B2Cp", "b", "A", NULL, NULL},
   {"u0B2Dp", "bh", "A", NULL, NULL},
   {"u0B2Ep", "m", "A", NULL, NULL},
   {"u0B2Fp", "j", "A", NULL, NULL},
   {"u0B30p", "9r", "A", NULL, NULL},
   {"u0B31p", "R:0B31", NULL, NULL, NULL},
   {"u0B32p", "l", "A", NULL, NULL},
   {"u0B33p", "lr", "A", NULL, NULL},
   {"u0B34p", "R:0B34", NULL, NULL, NULL},
   {"u0B35p", "v", "A", NULL, NULL},
   {"u0B36p", "S", "A", NULL, NULL},
   {"u0B37p", "sr", "A", NULL, NULL},
   {"u0B38p", "s", "A", NULL, NULL},
   {"u0B39p", "hv", "A", NULL, NULL},
   {"u0B3Cp", "NUKTA", NULL, NULL, NULL},
   {"u0B3Dp", "(AVAGRAHA)", NULL, NULL, NULL},
   {"u0B3Ep", "A", NULL, NULL, NULL},
   {"u0B3Fp", "i", NULL, NULL, NULL},
   {"u0B40p", "i:", NULL, NULL, NULL},
   {"u0B41p", "u", NULL, NULL, NULL},
   {"u0B42p", "u:", NULL, NULL, NULL},
   {"u0B43p", "9r=", NULL, NULL, NULL},
   {"u0B45p", "R:0B45", NULL, NULL, NULL},
   {"u0B46p", "R:0B46", NULL, NULL, NULL},
   {"u0B47p", "e", NULL, NULL, NULL},
   {"u0B48p", "GTI", NULL, NULL, NULL},
   {"u0B49p", "R:0B49", NULL, NULL, NULL},
   {"u0B4Bp", "o", NULL, NULL, NULL},
   {"u0B4Cp", "aU", NULL, NULL, NULL},
   {"u0B4Dp", "P", NULL, NULL, NULL},
   {"u0B56p", "(GTI LENGTH MARK)", NULL, NULL, NULL},
   {"u0B57p", "(aU LENGTH MARK)", NULL, NULL, NULL},
   {"u0B5Cp", "9r:", "A", NULL, NULL},
   {"u0B5Dp", "9rh", "A", NULL, NULL},
   {"u0B5Fp", "j", "A", NULL, NULL},
   {"u0B60p", "rr=", NULL, NULL, NULL},
   {"u0B61p", "lr=", NULL, NULL, NULL},
   {"u0B64p", "ASTERISK", NULL, NULL, NULL},
   {"u0B65p", "(**)", NULL, NULL, NULL},
   {"u0B66p", "(ZERO)", NULL, NULL, NULL},
   {"u0B67p", "(ONE)", NULL, NULL, NULL},
   {"u0B68p", "(TWO)", NULL, NULL, NULL},
   {"u0B69p", "(THREE)", NULL, NULL, NULL},
   {"u0B6Ap", "(FOUR)", NULL, NULL, NULL},
   {"u0B6Bp", "(FIVE)", NULL, NULL, NULL},
   {"u0B6Cp", "(SIX)", NULL, NULL, NULL},
   {"u0B6Dp", "(SEVEN)", NULL, NULL, NULL},
   {"u0B6Ep", "(EIGHT)", NULL, NULL, NULL},
   {"u0B6Fp", "(NINE)", NULL, NULL, NULL},
   {"u0B70p", "(ISSHAR)", NULL, NULL, NULL},
   {"u0B71p", "w", "A", NULL, NULL},
   {"u0D82p", "M", NULL, NULL, NULL},
   {"u0D83p", "H", NULL, NULL, NULL},
   {"u0D85p", "A", NULL, NULL, NULL},
   {"u0D86p", "A:", NULL, NULL, NULL},
   {"u0D87p", "@", NULL, NULL, NULL},
   {"u0D88p", "@:", NULL, NULL, NULL},
   {"u0D89p", "i", NULL, NULL, NULL},
   {"u0D8Ap", "i:", NULL, NULL, NULL},
   {"u0D8Bp", "u", NULL, NULL, NULL},
   {"u0D8Cp", "u:", NULL, NULL, NULL},
   {"u0D8Dp", "9r", "i", NULL, NULL},
   {"u0D8Ep", "9r", "i:", NULL, NULL},
   {"u0D8Fp", "l=", NULL, NULL, NULL},
   {"u0D90p", "l=", NULL, NULL, NULL},
   {"u0D91p", "e", NULL, NULL, NULL},
   {"u0D92p", "e:", NULL, NULL, NULL},
   {"u0D93p", "aI", NULL, NULL, NULL},
   {"u0D94p", "o", NULL, NULL, NULL},
   {"u0D95p", "o:", NULL, NULL, NULL},
   {"u0D96p", "aU", NULL, NULL, NULL},
   {"u0D9Ap", "k", "A", NULL, NULL},
   {"u0D9Bp", "kh", "A", NULL, NULL},
   {"u0D9Cp", "g", "A", NULL, NULL},
   {"u0D9Dp", "gh", "A", NULL, NULL},
   {"u0D9Ep", "N", "A", NULL, NULL},
   {"u0D9Fp", "N", "A", NULL, NULL},
   {"u0DA0p", "c", "A", NULL, NULL},
   {"u0DA1p", "ch", "A", NULL, NULL},
   {"u0DA2p", "J", "A", NULL, NULL},
   {"u0DA3p", "Jh", "A", NULL, NULL},
   {"u0DA4p", "n~", "A", NULL, NULL},
   {"u0DA5p", "J", "n~", "A", NULL},
   {"u0DA6p", "n~", "J", "A", NULL},
   {"u0DA7p", "tr", "A", NULL, NULL},
   {"u0DA8p", "tR", "A", NULL, NULL},
   {"u0DA9p", "dr", "A", NULL, NULL},
   {"u0DAAp", "dR", "A", NULL, NULL},
   {"u0DABp", "nr", "A", NULL, NULL},
   {"u0DACp", "nr", "dr", "A", NULL},
   {"u0DADp", "tB", "A", NULL, NULL},
   {"u0DAEp", "tBh", "A", NULL, NULL},
   {"u0DAFp", "dB", "A", NULL, NULL},
   {"u0DB0p", "dBh", "A", NULL, NULL},
   {"u0DB1p", "nB", "A", NULL, NULL},
   {"u0DB3p", "n", "d", "A", NULL},
   {"u0DB4p", "p", "A", NULL, NULL},
   {"u0DB5p", "ph", "A", NULL, NULL},
   {"u0DB6p", "b", "A", NULL, NULL},
   {"u0DB7p", "bh", "A", NULL, NULL},
   {"u0DB8p", "m", "A", NULL, NULL},
   {"u0DB9p", "m", "b", "A", NULL},
   {"u0DBAp", "j", "A", NULL, NULL},
   {"u0DBBp", "9r", "A", NULL, NULL},
   {"u0DBDp", "l", "A", NULL, NULL},
   {"u0DC0p", "v", "A", NULL, NULL},
   {"u0DC1p", "S", "A", NULL, NULL},
   {"u0DC2p", "S", "A", NULL, NULL},
   {"u0DC3p", "s", "A", NULL, NULL},
   {"u0DC4p", "hv", "A", NULL, NULL},
   {"u0DC5p", "lr", "A", NULL, NULL},
   {"u0DC6p", "f", "A", NULL, NULL},
   {"u0DCAp", "P", NULL, NULL, NULL},
   {"u0DCFp", "A:", NULL, NULL, NULL},
   {"u0DD0p", "@", NULL, NULL, NULL},
   {"u0DD1p", "@:", NULL, NULL, NULL},
   {"u0DD2p", "i", NULL, NULL, NULL},
   {"u0DD3p", "i:", NULL, NULL, NULL},
   {"u0DD4p", "u", NULL, NULL, NULL},
   {"u0DD6p", "u:", NULL, NULL, NULL},
   {"u0DD8p", "9r=", NULL, NULL, NULL},
   {"u0DD9p", "e", NULL, NULL, NULL},
   {"u0DDAp", "e:", NULL, NULL, NULL},
   {"u0DDBp", "aI", NULL, NULL, NULL},
   {"u0DDCp", "o", NULL, NULL, NULL},
   {"u0DDDp", "o:", NULL, NULL, NULL},
   {"u0DDEp", "aU", NULL, NULL, NULL},
   {"u0DDFp", "l=", NULL, NULL, NULL},
   {"u0DF2p", "rr=", NULL, NULL, NULL},
   {"u0DF3p", "l=", NULL, NULL, NULL},
   {"u0DF4p", "(PUNCTUATION)", NULL, NULL, NULL},
   {"uA800p", "A", NULL, NULL, NULL},
   {"uA801p", "i", NULL, NULL, NULL},
   {"uA802p", "(DVIAVARA)", NULL, NULL, NULL},
   {"uA803p", "u", NULL, NULL, NULL},
   {"uA804p", "e", NULL, NULL, NULL},
   {"uA805p", "o", NULL, NULL, NULL},
   {"uA806p", "(HASANTA)", NULL, NULL, NULL},
   {"uA807p", "k", "A", NULL, NULL},
   {"uA808p", "kh", "A", NULL, NULL},
   {"uA809p", "g", "A", NULL, NULL},
   {"uA80Ap", "gh", "A", NULL, NULL},
   {"uA80Bp", "m", "A", NULL, NULL},
   {"uA80Cp", "c", "A", NULL, NULL},
   {"uA80Dp", "ch", "A", NULL, NULL},
   {"uA80Ep", "J", "A", NULL, NULL},
   {"uA80Fp", "Jh", "A", NULL, NULL},
   {"uA810p", "tr", "A", NULL, NULL},
   {"uA811p", "tR", "A", NULL, NULL},
   {"uA812p", "dr", "A", NULL, NULL},
   {"uA813p", "dR", "A", NULL, NULL},
   {"uA814p", "tB", "A", NULL, NULL},
   {"uA815p", "tBh", "A", NULL, NULL},
   {"uA816p", "dB", "A", NULL, NULL},
   {"uA817p", "dBh", "A", NULL, NULL},
   {"uA818p", "nB", "A", NULL, NULL},
   {"uA819p", "p", "A", NULL, NULL},
   {"uA81Ap", "ph", "A", NULL, NULL},
   {"uA81Bp", "b", "A", NULL, NULL},
   {"uA81Cp", "bh", "A", NULL, NULL},
   {"uA81Dp", "m", "A", NULL, NULL},
   {"uA81Ep", "9r", "A", NULL, NULL},
   {"uA81Fp", "l", "A", NULL, NULL},
   {"uA820p", "9r:", "A", NULL, NULL},
   {"uA821p", "s", "A", NULL, NULL},
   {"uA822p", "h", "A", NULL, NULL},
   {"uA823p", "A", NULL, NULL, NULL},
   {"uA824p", "i", NULL, NULL, NULL},
   {"uA825p", "u", NULL, NULL, NULL},
   {"uA826p", "e", NULL, NULL, NULL},
   {"uA827p", "o:", NULL, NULL, NULL},
   {"uA828p", "(POETRY MARK1)", NULL, NULL, NULL},
   {"uA829p", "(POETRY MARK2)", NULL, NULL, NULL},
   {"uA82Ap", "(POETRY MARK3)", NULL, NULL, NULL},
   {"u0710p", "QM", NULL, NULL, NULL},
   {"u0711p", "QM", NULL, NULL, NULL},
   {"u0712p", "b", NULL, NULL, NULL},
   {"u0713p", "g", NULL, NULL, NULL},
   {"u0714p", "g", NULL, NULL, NULL},
   {"u0715p", "d", NULL, NULL, NULL},
   {"u0716p", "d", NULL, NULL, NULL},
   {"u0717p", "h", NULL, NULL, NULL},
   {"u0718p", "w", NULL, NULL, NULL},
   {"u0719p", "z", NULL, NULL, NULL},
   {"u071Ap", "HH", NULL, NULL, NULL},
   {"u071Bp", "t~", NULL, NULL, NULL},
   {"u071Cp", "t~", NULL, NULL, NULL},
   {"u071Dp", "j", NULL, NULL, NULL},
   {"u071Ep", "j", "h", NULL, NULL},
   {"u071Fp", "k", NULL, NULL, NULL},
   {"u0720p", "l", NULL, NULL, NULL},
   {"u0721p", "m", NULL, NULL, NULL},
   {"u0722p", "n", NULL, NULL, NULL},
   {"u0723p", "s", NULL, NULL, NULL},
   {"u0724p", "s", NULL, NULL, NULL},
   {"u0725p", "HHv", NULL, NULL, NULL},
   {"u0726p", "p", NULL, NULL, NULL},
   {"u0727p", "p", NULL, NULL, NULL},
   {"u0728p", "s~", NULL, NULL, NULL},
   {"u0729p", "q", NULL, NULL, NULL},
   {"u072Ap", "r", NULL, NULL, NULL},
   {"u072Bp", "S", NULL, NULL, NULL},
   {"u072Cp", "t", NULL, NULL, NULL},
   {"u072Dp", "b", NULL, NULL, NULL},
   {"u072Ep", "g", NULL, NULL, NULL},
   {"u072Fp", "d", NULL, NULL, NULL},
   {"u074Dp", "zh", NULL, NULL, NULL},
   {"u074Ep", "kh", NULL, NULL, NULL},
   {"u074Fp", "f", "e", NULL, NULL},
   {"u1700p", "A", NULL, NULL, NULL},
   {"u1701p", "e", NULL, NULL, NULL},
   {"u1702p", "o", NULL, NULL, NULL},
   {"u1703p", "k", "A", NULL, NULL},
   {"u1704p", "g", "A", NULL, NULL},
   {"u1705p", "N", "A", NULL, NULL},
   {"u1706p", "t", "A", NULL, NULL},
   {"u1707p", "d", "A", NULL, NULL},
   {"u1708p", "n", "A", NULL, NULL},
   {"u1709p", "p", "A", NULL, NULL},
   {"u170Ap", "b", "A", NULL, NULL},
   {"u170Bp", "m", "A", NULL, NULL},
   {"u170Cp", "j", "A", NULL, NULL},
   {"u170Ep", "l", "A", NULL, NULL},
   {"u170Fp", "w", "A", NULL, NULL},
   {"u1710p", "s", "A", NULL, NULL},
   {"u1711p", "n", "A", NULL, NULL},
   {"u1712p", "i", NULL, NULL, NULL},
   {"u1713p", "u", NULL, NULL, NULL},
   {"u1714p", "P", NULL, NULL, NULL},
   {"u1760p", "A", NULL, NULL, NULL},
   {"u1761p", "i", NULL, NULL, NULL},
   {"u1762p", "u", NULL, NULL, NULL},
   {"u1763p", "k", "A", NULL, NULL},
   {"u1764p", "g", "A", NULL, NULL},
   {"u1765p", "N", "A", NULL, NULL},
   {"u1766p", "t", "A", NULL, NULL},
   {"u1767p", "d", "A", NULL, NULL},
   {"u1768p", "n", "A", NULL, NULL},
   {"u1769p", "p", "A", NULL, NULL},
   {"u176Ap", "b", "A", NULL, NULL},
   {"u176Bp", "m", "A", NULL, NULL},
   {"u176Cp", "j", "A", NULL, NULL},
   {"u176Ep", "l", "A", NULL, NULL},
   {"u176Fp", "w", "A", NULL, NULL},
   {"u1770p", "s", "A", NULL, NULL},
   {"u1772p", "i", NULL, NULL, NULL},
   {"u1773p", "u", NULL, NULL, NULL},
   {"u0B81p", "R:0B81", NULL, NULL, NULL},
   {"u0B82p", "M", NULL, NULL, NULL},
   {"u0B83p", "H", NULL, NULL, NULL},
   {"u0B85p", "GT", NULL, NULL, NULL},
   {"u0B86p", "A:", NULL, NULL, NULL},
   {"u0B87p", "i", NULL, NULL, NULL},
   {"u0B88p", "i:", NULL, NULL, NULL},
   {"u0B89p", "u", NULL, NULL, NULL},
   {"u0B8Ap", "u:", NULL, NULL, NULL},
   {"u0B8Bp", "R:0B8B", NULL, NULL, NULL},
   {"u0B8Dp", "R:0B8D", NULL, NULL, NULL},
   {"u0B8Ep", "e", NULL, NULL, NULL},
   {"u0B8Fp", "e:", NULL, NULL, NULL},
   {"u0B90p", "GTI", NULL, NULL, NULL},
   {"u0B91p", "R:0B91", NULL, NULL, NULL},
   {"u0B92p", "o", NULL, NULL, NULL},
   {"u0B93p", "o:", NULL, NULL, NULL},
   {"u0B94p", "aU", NULL, NULL, NULL},
   {"u0B95p", "k", "A", NULL, NULL},
   {"u0B96p", "R:0B96", NULL, NULL, NULL},
   {"u0B97p", "R:0B97", NULL, NULL, NULL},
   {"u0B98p", "R:0B98", NULL, NULL, NULL},
   {"u0B99p", "N", "A", NULL, NULL},
   {"u0B9Ap", "c", "A", NULL, NULL},
   {"u0B9Bp", "R:0B9B", NULL, NULL, NULL},
   {"u0B9Cp", "J", "A", NULL, NULL},
   {"u0B9Dp", "R:0B9D", NULL, NULL, NULL},
   {"u0B9Ep", "n~", "A", NULL, NULL},
   {"u0B9Fp", "tr", "A", NULL, NULL},
   {"u0BA0p", "R:0BA0", NULL, NULL, NULL},
   {"u0BA1p", "R:0BA1", NULL, NULL, NULL},
   {"u0BA2p", "R:0BA2", NULL, NULL, NULL},
   {"u0BA3p", "nr", "A", NULL, NULL},
   {"u0BA4p", "tB", "A", NULL, NULL},
   {"u0BA5p", "R:0BA5", NULL, NULL, NULL},
   {"u0BA6p", "R:0BA6", NULL, NULL, NULL},
   {"u0BA7p", "R:0BA7", NULL, NULL, NULL},
   {"u0BA8p", "nB", "A", NULL, NULL},
   {"u0BA9p", "n", "A", NULL, NULL},
   {"u0BAAp", "p", "A", NULL, NULL},
   {"u0BABp", "R:0BAB", NULL, NULL, NULL},
   {"u0BACp", "R:0BAC", NULL, NULL, NULL},
   {"u0BAEp", "m", "A", NULL, NULL},
   {"u0BAFp", "j", "A", NULL, NULL},
   {"u0BB0p", "9rB", "A", NULL, NULL},
   {"u0BB1p", "9r", "A", NULL, NULL},
   {"u0BB2p", "l", "A", NULL, NULL},
   {"u0BB3p", "l", "A", NULL, NULL},
   {"u0BB4p", "lr", "A", NULL, NULL},
   {"u0BB5p", "v", "A", NULL, NULL},
   {"u0BB6p", "S", "A", NULL, NULL},
   {"u0BB7p", "sr", "A", NULL, NULL},
   {"u0BB8p", "s", "A", NULL, NULL},
   {"u0BB9p", "h", "A", NULL, NULL},
   {"u0BBEp", "A:", NULL, NULL, NULL},
   {"u0BBFp", "i", NULL, NULL, NULL},
   {"u0BC0p", "i:", NULL, NULL, NULL},
   {"u0BC1p", "u", NULL, NULL, NULL},
   {"u0BC2p", "u:", NULL, NULL, NULL},
   {"u0BC3p", "R:0BC3", NULL, NULL, NULL},
   {"u0BC5p", "R:0BC5", NULL, NULL, NULL},
   {"u0BC6p", "e", NULL, NULL, NULL},
   {"u0BC7p", "e:", NULL, NULL, NULL},
   {"u0BC8p", "GTI", NULL, NULL, NULL},
   {"u0BC9p", "R:0BC9", NULL, NULL, NULL},
   {"u0BCAp", "o", NULL, NULL, NULL},
   {"u0BCBp", "o:", NULL, NULL, NULL},
   {"u0BCCp", "aU", NULL, NULL, NULL},
   {"u0BCDp", "P", NULL, NULL, NULL},
   {"u0BD7p", "(GTI LENGTH MARK)", NULL, NULL, NULL},
   {"u0BDFp", "R:0BDF", NULL, NULL, NULL},
   {"u0BE4p", "R:0BE4", NULL, NULL, NULL},
   {"u0BE6p", "(ZERO)", NULL, NULL, NULL},
   {"u0BE7p", "(ONE)", NULL, NULL, NULL},
   {"u0BE8p", "(TWO)", NULL, NULL, NULL},
   {"u0BE9p", "(THREE)", NULL, NULL, NULL},
   {"u0BEAp", "(FOUR)", NULL, NULL, NULL},
   {"u0BEBp", "(FIVE)", NULL, NULL, NULL},
   {"u0BECp", "(SIX)", NULL, NULL, NULL},
   {"u0BEDp", "(SEVEN)", NULL, NULL, NULL},
   {"u0BEEp", "(EIGHT)", NULL, NULL, NULL},
   {"u0BEFp", "(NINE)", NULL, NULL, NULL},
   {"u0BF0p", "(TEN)", NULL, NULL, NULL},
   {"u0BF1p", "(HUNDREAD)", NULL, NULL, NULL},
   {"u0BF2p", "(THOUSAND)", NULL, NULL, NULL},
   {"u0BF3p", "(DAY)", NULL, NULL, NULL},
   {"u0BF4p", "(MONTH)", NULL, NULL, NULL},
   {"u0BF5p", "(YEAR)", NULL, NULL, NULL},
   {"u0BF6p", "(DEBIT)", NULL, NULL, NULL},
   {"u0BF7p", "(CREDIT)", NULL, NULL, NULL},
   {"u0BF8p", "(AS ABOVE)", NULL, NULL, NULL},
   {"u0BF9p", "(RUPEE)", NULL, NULL, NULL},
   {"u0BFAp", "(NUMBER)", NULL, NULL, NULL},
   {"u0C01p", "CD", NULL, NULL, NULL},
   {"u0C02p", "M", NULL, NULL, NULL},
   {"u0C03p", "H", NULL, NULL, NULL},
   {"u0C05p", "GT", NULL, NULL, NULL},
   {"u0C06p", "GT:", NULL, NULL, NULL},
   {"u0C07p", "i", NULL, NULL, NULL},
   {"u0C08p", "i:", NULL, NULL, NULL},
   {"u0C09p", "u", NULL, NULL, NULL},
   {"u0C0Ap", "u:", NULL, NULL, NULL},
   {"u0C0Bp", "9r", "i", NULL, NULL},
   {"u0C0Cp", "l=", NULL, NULL, NULL},
   {"u0C0Dp", "R:0C0D", NULL, NULL, NULL},
   {"u0C0Ep", "e", NULL, NULL, NULL},
   {"u0C0Fp", "e:", NULL, NULL, NULL},
   {"u0C10p", "aI", NULL, NULL, NULL},
   {"u0C12p", "o", NULL, NULL, NULL},
   {"u0C13p", "o:", NULL, NULL, NULL},
   {"u0C14p", "aU", NULL, NULL, NULL},
   {"u0C15p", "k", "A", NULL, NULL},
   {"u0C16p", "kh", "A", NULL, NULL},
   {"u0C17p", "g", "A", NULL, NULL},
   {"u0C18p", "gh", "A", NULL, NULL},
   {"u0C19p", "N", "A", NULL, NULL},
   {"u0C1Ap", "c", "A", NULL, NULL},
   {"u0C1Bp", "ch", "A", NULL, NULL},
   {"u0C1Cp", "J", "A", NULL, NULL},
   {"u0C1Dp", "Jh", "A", NULL, NULL},
   {"u0C1Ep", "n~", "A", NULL, NULL},
   {"u0C1Fp", "tr", "A", NULL, NULL},
   {"u0C20p", "tR", "A", NULL, NULL},
   {"u0C21p", "dr", "A", NULL, NULL},
   {"u0C22p", "dR", "A", NULL, NULL},
   {"u0C23p", "nr", "A", NULL, NULL},
   {"u0C24p", "tB", "A", NULL, NULL},
   {"u0C25p", "tBh", "A", NULL, NULL},
   {"u0C26p", "dB", "A", NULL, NULL},
   {"u0C27p", "dBh", "A", NULL, NULL},
   {"u0C28p", "nB", "A", NULL, NULL},
   {"u0C29p", "R:0C29", NULL, NULL, NULL},
   {"u0C2Ap", "p", "A", NULL, NULL},
   {"u0C2Bp", "ph", "A", NULL, NULL},
   {"u0C2Cp", "b", "A", NULL, NULL},
   {"u0C2Dp", "bh", "A", NULL, NULL},
   {"u0C2Ep", "m", "A", NULL, NULL},
   {"u0C2Fp", "j", "A", NULL, NULL},
   {"u0C30p", "9r", "A", NULL, NULL},
   {"u0C31p", "9r:", "A", NULL, NULL},
   {"u0C32p", "l", "A", NULL, NULL},
   {"u0C33p", "lr", "A", NULL, NULL},
   {"u0C34p", "R:0C34", NULL, NULL, NULL},
   {"u0C35p", "v", "A", NULL, NULL},
   {"u0C36p", "S", "A", NULL, NULL},
   {"u0C37p", "S", "A", NULL, NULL},
   {"u0C38p", "s", "A", NULL, NULL},
   {"u0C39p", "hv", "A", NULL, NULL},
   {"u0C3Ep", "GT:", NULL, NULL, NULL},
   {"u0C3Fp", "i", NULL, NULL, NULL},
   {"u0C40p", "i:", NULL, NULL, NULL},
   {"u0C41p", "u", NULL, NULL, NULL},
   {"u0C42p", "u:", NULL, NULL, NULL},
   {"u0C43p", "9r=", NULL, NULL, NULL},
   {"u0C44p", "rr=", NULL, NULL, NULL},
   {"u0C45p", "R:0C45", NULL, NULL, NULL},
   {"u0C46p", "e", NULL, NULL, NULL},
   {"u0C47p", "e:", NULL, NULL, NULL},
   {"u0C48p", "aI", NULL, NULL, NULL},
   {"u0C49p", "R:0C49", NULL, NULL, NULL},
   {"u0C4Ap", "o", NULL, NULL, NULL},
   {"u0C4Bp", "o:", NULL, NULL, NULL},
   {"u0C4Cp", "aU", NULL, NULL, NULL},
   {"u0C4Dp", "P", NULL, NULL, NULL},
   {"u0C55p", "(LENGTH MARK)", NULL, NULL, NULL},
   {"u0C56p", "(aI LENGTH MARK)", NULL, NULL, NULL},
   {"u0C5Fp", "R:0C5F", NULL, NULL, NULL},
   {"u0C60p", "rr=", NULL, NULL, NULL},
   {"u0C61p", "lr=", NULL, NULL, NULL},
   {"u0C66p", "(ZERO)", NULL, NULL, NULL},
   {"u0C67p", "(ONE)", NULL, NULL, NULL},
   {"u0C68p", "(TWO)", NULL, NULL, NULL},
   {"u0C69p", "(THREE)", NULL, NULL, NULL},
   {"u0C6Ap", "(FOUR)", NULL, NULL, NULL},
   {"u0C6Bp", "(FIVE)", NULL, NULL, NULL},
   {"u0C6Cp", "(SIX)", NULL, NULL, NULL},
   {"u0C6Dp", "(SEVEN)", NULL, NULL, NULL},
   {"u0C6Ep", "(EIGHT)", NULL, NULL, NULL},
   {"u0C6Fp", "(NINE)", NULL, NULL, NULL},
   {"u0780p", "h", NULL, NULL, NULL},
   {"u0781p", "sr", NULL, NULL, NULL},
   {"u0782p", "n", NULL, NULL, NULL},
   {"u0783p", "r", NULL, NULL, NULL},
   {"u0784p", "b", NULL, NULL, NULL},
   {"u0785p", "lr", NULL, NULL, NULL},
   {"u0786p", "k", NULL, NULL, NULL},
   {"u0787p", NULL, NULL, NULL, NULL},
   {"u0788p", "v", NULL, NULL, NULL},
   {"u0789p", "m", NULL, NULL, NULL},
   {"u078Ap", "f", NULL, NULL, NULL},
   {"u078Bp", "d", NULL, NULL, NULL},
   {"u078Cp", "t", NULL, NULL, NULL},
   {"u078Dp", "l", NULL, NULL, NULL},
   {"u078Ep", "g", NULL, NULL, NULL},
   {"u078Fp", "n~", NULL, NULL, NULL},
   {"u0790p", "s", NULL, NULL, NULL},
   {"u0791p", "dr", NULL, NULL, NULL},
   {"u0792p", "z", NULL, NULL, NULL},
   {"u0793p", "tr", NULL, NULL, NULL},
   {"u0794p", "j", NULL, NULL, NULL},
   {"u0795p", "p", NULL, NULL, NULL},
   {"u0796p", "j-", NULL, NULL, NULL},
   {"u0797p", "c", NULL, NULL, NULL},
   {"u0798p", "T", NULL, NULL, NULL},
   {"u0799p", "D", NULL, NULL, NULL},
   {"u079Ap", "HH", NULL, NULL, NULL},
   {"u079Bp", "x", NULL, NULL, NULL},
   {"u079Cp", "z", NULL, NULL, NULL},
   {"u079Dp", "S", NULL, NULL, NULL},
   {"u079Ep", "sr", NULL, NULL, NULL},
   {"u079Fp", "dr", NULL, NULL, NULL},
   {"u07A0p", "tr", NULL, NULL, NULL},
   {"u07A1p", "zr", NULL, NULL, NULL},
   {"u07A2p", "HHv", NULL, NULL, NULL},
   {"u07A3p", "G", NULL, NULL, NULL},
   {"u07A4p", "q", NULL, NULL, NULL},
   {"u07A5p", "w", NULL, NULL, NULL},
   {"u07A6p", "A", NULL, NULL, NULL},
   {"u07A7p", "A:", NULL, NULL, NULL},
   {"u07A8p", "i", NULL, NULL, NULL},
   {"u07A9p", "i:", NULL, NULL, NULL},
   {"u07AAp", "u", NULL, NULL, NULL},
   {"u07ABp", "u:", NULL, NULL, NULL},
   {"u07ACp", "e", NULL, NULL, NULL},
   {"u07ADp", "e:", NULL, NULL, NULL},
   {"u07AEp", "o", NULL, NULL, NULL},
   {"u07AFp", "o:", NULL, NULL, NULL},
   {"u07B0p", "QM", NULL, NULL, NULL},
   {"u07B1p", "n", NULL, NULL, NULL},
   {"u0E01p", "k", NULL, NULL, NULL},
   {"u0E02p", "kh", NULL, NULL, NULL},
   {"u0E03p", "kh", NULL, NULL, NULL},
   {"u0E04p", "kh", NULL, NULL, NULL},
   {"u0E05p", "kh", NULL, NULL, NULL},
   {"u0E06p", "kh", NULL, NULL, NULL},
   {"u0E07p", "N", NULL, NULL, NULL},
   {"u0E08p", "c", NULL, NULL, NULL},
   {"u0E09p", "ch", NULL, NULL, NULL},
   {"u0E0Ap", "ch", NULL, NULL, NULL},
   {"u0E0Bp", "s", NULL, NULL, NULL},
   {"u0E0Cp", "ch", NULL, NULL, NULL},
   {"u0E0Dp", "j", NULL, NULL, NULL},
   {"u0E0Ep", "d", NULL, NULL, NULL},
   {"u0E0Fp", "t", NULL, NULL, NULL},
   {"u0E10p", "th", NULL, NULL, NULL},
   {"u0E11p", "th", NULL, NULL, NULL},
   {"u0E12p", "th", NULL, NULL, NULL},
   {"u0E13p", "n", NULL, NULL, NULL},
   {"u0E14p", "d", NULL, NULL, NULL},
   {"u0E15p", "t", NULL, NULL, NULL},
   {"u0E16p", "th", NULL, NULL, NULL},
   {"u0E17p", "th", NULL, NULL, NULL},
   {"u0E18p", "th", NULL, NULL, NULL},
   {"u0E19p", "n", NULL, NULL, NULL},
   {"u0E1Ap", "b", NULL, NULL, NULL},
   {"u0E1Bp", "p", NULL, NULL, NULL},
   {"u0E1Cp", "ph", NULL, NULL, NULL},
   {"u0E1Dp", "f", NULL, NULL, NULL},
   {"u0E1Ep", "ph", NULL, NULL, NULL},
   {"u0E1Fp", "f", NULL, NULL, NULL},
   {"u0E20p", "ph", NULL, NULL, NULL},
   {"u0E21p", "m", NULL, NULL, NULL},
   {"u0E22p", "j", NULL, NULL, NULL},
   {"u0E23p", "r", NULL, NULL, NULL},
   {"u0E24p", "r", "4", NULL, NULL},
   {"u0E25p", "l", NULL, NULL, NULL},
   {"u0E26p", "l", "4", NULL, NULL},
   {"u0E27p", "w", NULL, NULL, NULL},
   {"u0E28p", "s", NULL, NULL, NULL},
   {"u0E29p", "s", NULL, NULL, NULL},
   {"u0E2Ap", "s", NULL, NULL, NULL},
   {"u0E2Bp", "h", NULL, NULL, NULL},
   {"u0E2Cp", "l", NULL, NULL, NULL},
   {"u0E2Dp", "QM", NULL, NULL, NULL},
   {"u0E2Ep", "h", NULL, NULL, NULL},
   {"u0E2Fp", "(ELLIPSIS)", "(ABBREVIATION)", NULL, NULL},
   {"u0E30p", "A", NULL, NULL, NULL},
   {"u0E31p", "A", NULL, NULL, NULL},
   {"u0E32p", "A:", NULL, NULL, NULL},
   {"u0E33p", "A", "m", NULL, NULL},
   {"u0E34p", "i", NULL, NULL, NULL},
   {"u0E35p", "i:", NULL, NULL, NULL},
   {"u0E36p", "4", NULL, NULL, NULL},
   {"u0E37p", "4:", NULL, NULL, NULL},
   {"u0E38p", "u", NULL, NULL, NULL},
   {"u0E39p", "u:", NULL, NULL, NULL},
   {"u0E3Ap", "P", NULL, NULL, NULL},
   {"u0E3Fp", "(CURRENCY SYMBOL BAHT)", NULL, NULL, NULL},
   {"u0E40p", "e:", NULL, NULL, NULL},
   {"u0E41p", "@", NULL, NULL, NULL},
   {"u0E42p", "o", NULL, NULL, NULL},
   {"u0E43p", "aI", NULL, NULL, NULL},
   {"u0E44p", "aI", NULL, NULL, NULL},
   {"u0E45p", "PHINTHU", NULL, NULL, NULL},
   {"u0E46p", "MAIYAMOK", NULL, NULL, NULL},
   {"u0E47p", "MAITAIKHU", NULL, NULL, NULL},
   {"u0E48p", "MAIEK", NULL, NULL, NULL},
   {"u0E49p", "MAITHO", NULL, NULL, NULL},
   {"u0E4Ap", "MAITRI", NULL, NULL, NULL},
   {"u0E4Bp", "MAICHATTAWA", NULL, NULL, NULL},
   {"u0E4Cp", "THANTHAKHAT", NULL, NULL, NULL},
   {"u0E4Dp", "(NIKHHIT)", NULL, NULL, NULL},
   {"u0E4Ep", "(YAMAKKAN)", NULL, NULL, NULL},
   {"u0E4Fp", "(FONGMAN)", NULL, NULL, NULL},
   {"u0E50p", "(ZERO)", NULL, NULL, NULL},
   {"u0E51p", "(ONE)", NULL, NULL, NULL},
   {"u0E52p", "(TWO)", NULL, NULL, NULL},
   {"u0E53p", "(THREE)", NULL, NULL, NULL},
   {"u0E54p", "(FOUR)", NULL, NULL, NULL},
   {"u0E55p", "(FIVE)", NULL, NULL, NULL},
   {"u0E56p", "(SIX)", NULL, NULL, NULL},
   {"u0E57p", "(SEVEN)", NULL, NULL, NULL},
   {"u0E58p", "(EIGHT)", NULL, NULL, NULL},
   {"u0E59p", "(NINE)", NULL, NULL, NULL},
   {"u0E5Ap", "(ANGKHANKHU)", NULL, NULL, NULL},
   {"u0E5Bp", "(KHOMUT)", NULL, NULL, NULL},
   {"u0F00p", "(OM)", NULL, NULL, NULL},
   {"u0F20p", "(ZERO)", NULL, NULL, NULL},
   {"u0F21p", "(ONE)", NULL, NULL, NULL},
   {"u0F22p", "(TWO)", NULL, NULL, NULL},
   {"u0F23p", "(THREE)", NULL, NULL, NULL},
   {"u0F24p", "(FOUR)", NULL, NULL, NULL},
   {"u0F25p", "(FIVE)", NULL, NULL, NULL},
   {"u0F26p", "(SIX)", NULL, NULL, NULL},
   {"u0F27p", "(SEVEN)", NULL, NULL, NULL},
   {"u0F28p", "(EIGHT)", NULL, NULL, NULL},
   {"u0F29p", "(NINE)", NULL, NULL, NULL},
   {"u0F2Ap", "(HALF ONE)", NULL, NULL, NULL},
   {"u0F2Bp", "(HALF TWO)", NULL, NULL, NULL},
   {"u0F2Cp", "(HALF THREE)", NULL, NULL, NULL},
   {"u0F2Dp", "(HALF FOUR)", NULL, NULL, NULL},
   {"u0F2Ep", "(HALF FIVE)", NULL, NULL, NULL},
   {"u0F2Fp", "(HALF SIX)", NULL, NULL, NULL},
   {"u0F30p", "(HALF SEVEN)", NULL, NULL, NULL},
   {"u0F31p", "(HALF EIGHT)", NULL, NULL, NULL},
   {"u0F32p", "(HALF NINE)", NULL, NULL, NULL},
   {"u0F33p", "(HALF ZERO)", NULL, NULL, NULL},
   {"u0F40p", "k", "A", NULL, NULL},
   {"u0F41p", "kh", "A", NULL, NULL},
   {"u0F42p", "k", "A", NULL, NULL},
   {"u0F43p", "kh", "A", NULL, NULL},
   {"u0F44p", "N", "A", NULL, NULL},
   {"u0F45p", "tS", "A", NULL, NULL},
   {"u0F46p", "tSh", "A", NULL, NULL},
   {"u0F47p", "tS", "A", NULL, NULL},
   {"u0F49p", "n~", "A", NULL, NULL},
   {"u0F4Ap", "t", "t", "A", NULL},
   {"u0F4Bp", "t", "th", "A", NULL},
   {"u0F4Cp", "t", "t", "A", NULL},
   {"u0F4Dp", "t", "th", "A", NULL},
   {"u0F4Ep", "n", "n", "A", NULL},
   {"u0F4Fp", "t", "A", NULL, NULL},
   {"u0F50p", "th", "A", NULL, NULL},
   {"u0F51p", "t", "A", NULL, NULL},
   {"u0F52p", "th", "A", NULL, NULL},
   {"u0F53p", "n", "A", NULL, NULL},
   {"u0F54p", "p", "A", NULL, NULL},
   {"u0F55p", "ph", "A", NULL, NULL},
   {"u0F56p", "p", "A", NULL, NULL},
   {"u0F57p", "ph", "A", NULL, NULL},
   {"u0F58p", "m", "A", NULL, NULL},
   {"u0F59p", "ts", "A", NULL, NULL},
   {"u0F5Ap", "tsh", "A", NULL, NULL},
   {"u0F5Bp", "ts", "A", NULL, NULL},
   {"u0F5Cp", "tsh", "A", NULL, NULL},
   {"u0F5Dp", "w", "A", NULL, NULL},
   {"u0F5Ep", "S", "A", NULL, NULL},
   {"u0F5Fp", "s", "A", NULL, NULL},
   {"u0F60p", "A", NULL, NULL, NULL},
   {"u0F61p", "j", "A", NULL, NULL},
   {"u0F62p", "r", "A", NULL, NULL},
   {"u0F63p", "l", "A", NULL, NULL},
   {"u0F64p", "S", "A", NULL, NULL},
   {"u0F65p", "S", "S", "A", NULL},
   {"u0F66p", "s", "A", NULL, NULL},
   {"u0F67p", "h", "A", NULL, NULL},
   {"u0F68p", "A", NULL, NULL, NULL},
   {"u0F69p", "k", "S", "S", NULL},
   {"u0F6Ap", "r", "A", NULL, NULL},
   {"u0F71p", "A:", NULL, NULL, NULL},
   {"u0F72p", "i", NULL, NULL, NULL},
   {"u0F73p", "i:", NULL, NULL, NULL},
   {"u0F74p", "u", NULL, NULL, NULL},
   {"u0F75p", "u:", NULL, NULL, NULL},
   {"u0F76p", "r=", NULL, NULL, NULL},
   {"u0F77p", "rr=", NULL, NULL, NULL},
   {"u0F78p", "l=", NULL, NULL, NULL},
   {"u0F79p", "l=", NULL, NULL, NULL},
   {"u0F7Ap", "e", NULL, NULL, NULL},
   {"u0F7Bp", "e:", NULL, NULL, NULL},
   {"u0F7Cp", "o", NULL, NULL, NULL},
   {"u0F7Dp", "o:", NULL, NULL, NULL},
   {"u0F7Ep", "M", NULL, NULL, NULL},
   {"u0F7Fp", "H", NULL, NULL, NULL},
   {"u0F80p", "i", NULL, NULL, NULL},
   {"u0F81p", "i:", NULL, NULL, NULL},
   {"u0F90p", "k", "A", NULL, NULL},
   {"u0F91p", "kh", "A", NULL, NULL},
   {"u0F92p", "k", "A", NULL, NULL},
   {"u0F93p", "kh", "A", NULL, NULL},
   {"u0F94p", "N", "A", NULL, NULL},
   {"u0F95p", "tS", "A", NULL, NULL},
   {"u0F96p", "tSh", "A", NULL, NULL},
   {"u0F97p", "tS", "A", NULL, NULL},
   {"u0F99p", "n~", "A", NULL, NULL},
   {"u0F9Ap", "t", "t", "A", NULL},
   {"u0F9Bp", "t", "th", "A", NULL},
   {"u0F9Cp", "t", "t", "A", NULL},
   {"u0F9Dp", "t", "th", "A", NULL},
   {"u0F9Ep", "n", "n", "A", NULL},
   {"u0F9Fp", "t", "A", NULL, NULL},
   {"u0FA0p", "th", "A", NULL, NULL},
   {"u0FA1p", "t", "A", NULL, NULL},
   {"u0FA2p", "th", "A", NULL, NULL},
   {"u0FA3p", "n", "A", NULL, NULL},
   {"u0FA4p", "p", "A", NULL, NULL},
   {"u0FA5p", "ph", "A", NULL, NULL},
   {"u0FA6p", "p", "A", NULL, NULL},
   {"u0FA7p", "ph", "A", NULL, NULL},
   {"u0FA8p", "m", "A", NULL, NULL},
   {"u0FA9p", "ts", "A", NULL, NULL},
   {"u0FAAp", "tsh", "A", NULL, NULL},
   {"u0FABp", "ts", "A", NULL, NULL},
   {"u0FACp", "tsh", "A", NULL, NULL},
   {"u0FADp", "w", "A", NULL, NULL},
   {"u0FAEp", "S", "A", NULL, NULL},
   {"u0FAFp", "s", "A", NULL, NULL},
   {"u0FB0p", "A", NULL, NULL, NULL},
   {"u0FB1p", "j", "A", NULL, NULL},
   {"u0FB2p", "r", "A", NULL, NULL},
   {"u0FB3p", "l", "A", NULL, NULL},
   {"u0FB4p", "S", "A", NULL, NULL},
   {"u0FB5p", "S", "S", "A", NULL},
   {"u0FB6p", "s", "A", NULL, NULL},
   {"u0FB7p", "h", "A", NULL, NULL},
   {"u0FB8p", "A", NULL, NULL, NULL},
   {"u0FB9p", "k", "S", "S", NULL},
   {"u0FBAp", "w", "A", NULL, NULL},
   {"u0FBBp", "j", "A", NULL, NULL},
   {"u0FBCp", "r", "A", NULL, NULL},
   {"u0FBEp", "(REFRAIN)", NULL, NULL, NULL},
   {"u0FBFp", "(REFERENCE MARK)", NULL, NULL, NULL},
   {"u0FC0p", "(HEAVY DRUM BEAT)", NULL, NULL, NULL},
   {"u0FC1p", "(LIGHT DRUM BEAT)", NULL, NULL, NULL},
   {"u0FC2p", "(SMALL TIBETAN HAND DRUM)", NULL, NULL, NULL},
   {"u0FC3p", "(TIBETAN CYMBAL)", NULL, NULL, NULL},
   {"u2D30p", "a", NULL, NULL, NULL},
   {"u2D31p", "b", NULL, NULL, NULL},
   {"u2D32p", "bh", NULL, NULL, NULL},
   {"u2D33p", "g", NULL, NULL, NULL},
   {"u2D34p", "gh", NULL, NULL, NULL},
   {"u2D35p", "dj", NULL, NULL, NULL},
   {"u2D36p", "dj", NULL, NULL, NULL},
   {"u2D37p", "d", NULL, NULL, NULL},
   {"u2D38p", "dh", NULL, NULL, NULL},
   {"u2D39p", "d", "d", NULL, NULL},
   {"u2D3Ap", "d", "dh", NULL, NULL},
   {"u2D3Bp", "e", NULL, NULL, NULL},
   {"u2D3Cp", "f", NULL, NULL, NULL},
   {"u2D3Dp", "k", NULL, NULL, NULL},
   {"u2D3Ep", "k", NULL, NULL, NULL},
   {"u2D3Fp", "kh", NULL, NULL, NULL},
   {"u2D40p", "b", NULL, NULL, NULL},
   {"u2D41p", "h", NULL, NULL, NULL},
   {"u2D42p", "h", NULL, NULL, NULL},
   {"u2D43p", "h", NULL, NULL, NULL},
   {"u2D44p", "@", NULL, NULL, NULL},
   {"u2D45p", "kh", NULL, NULL, NULL},
   {"u2D46p", "q", NULL, NULL, NULL},
   {"u2D47p", "q", NULL, NULL, NULL},
   {"u2D48p", "i", NULL, NULL, NULL},
   {"u2D49p", "z", NULL, NULL, NULL},
   {"u2D4Ap", "z", NULL, NULL, NULL},
   {"u2D4Bp", "z", NULL, NULL, NULL},
   {"u2D4Cp", "z", NULL, NULL, NULL},
   {"u2D4Dp", "l", NULL, NULL, NULL},
   {"u2D4Ep", "m", NULL, NULL, NULL},
   {"u2D4Fp", "n", NULL, NULL, NULL},
   {"u2D50p", "nj", NULL, NULL, NULL},
   {"u2D51p", "N", NULL, NULL, NULL},
   {"u2D52p", "p", NULL, NULL, NULL},
   {"u2D53p", "u", NULL, NULL, NULL},
   {"u2D54p", "r", NULL, NULL, NULL},
   {"u2D55p", "rr", NULL, NULL, NULL},
   {"u2D56p", "gh", NULL, NULL, NULL},
   {"u2D57p", "gh", NULL, NULL, NULL},
   {"u2D58p", "gh", NULL, NULL, NULL},
   {"u2D59p", "s", NULL, NULL, NULL},
   {"u2D5Ap", "s", "s", NULL, NULL},
   {"u2D5Bp", "sh", NULL, NULL, NULL},
   {"u2D5Cp", "t", NULL, NULL, NULL},
   {"u2D5Dp", "th", NULL, NULL, NULL},
   {"u2D5Ep", "ch", NULL, NULL, NULL},
   {"u2D5Fp", "t", "t", NULL, NULL},
   {"u2D60p", "v", NULL, NULL, NULL},
   {"u2D61p", "w", NULL, NULL, NULL},
   {"u2D62p", "j", NULL, NULL, NULL},
   {"u2D63p", "z", NULL, NULL, NULL},
   {"u2D64p", "z", NULL, NULL, NULL},
   {"u2D65p", "z", "z", NULL, NULL},
   {"u2D6Fp", "w", NULL, NULL, NULL},
   {"u1401p", "aI", NULL, NULL, NULL},
   {"u1402p", "A:", "i", NULL, NULL},
   {"u1403p", "i", NULL, NULL, NULL},
   {"u1404p", "i:", NULL, NULL, NULL},
   {"u1405p", "u", NULL, NULL, NULL},
   {"u1406p", "u:", NULL, NULL, NULL},
   {"u1407p", "o:", NULL, NULL, NULL},
   {"u1408p", "e:", NULL, NULL, NULL},
   {"u1409p", "i", NULL, NULL, NULL},
   {"u140Ap", "A", NULL, NULL, NULL},
   {"u140Bp", "A:", NULL, NULL, NULL},
   {"u140Cp", "w", "e", NULL, NULL},
   {"u140Dp", "w", "e", NULL, NULL},
   {"u140Ep", "w", "i", NULL, NULL},
   {"u140Fp", "w", "i", NULL, NULL},
   {"u1410p", "w", "i:", NULL, NULL},
   {"u1411p", "w", "i:", NULL, NULL},
   {"u1412p", "w", "o", NULL, NULL},
   {"u1413p", "w", "o", NULL, NULL},
   {"u1414p", "w", "o:", NULL, NULL},
   {"u1415p", "w", "o:", NULL, NULL},
   {"u1416p", "w", "o:", NULL, NULL},
   {"u1417p", "w", "A", NULL, NULL},
   {"u1418p", "w", "A", NULL, NULL},
   {"u1419p", "w", "A:", NULL, NULL},
   {"u141Ap", "w", "A:", NULL, NULL},
   {"u141Bp", "w", "A:", NULL, NULL},
   {"u141Cp", "A:", NULL, NULL, NULL},
   {"u141Dp", "w", NULL, NULL, NULL},
   {"u141Ep", "QM", NULL, NULL, NULL},
   {"u141Fp", "QM", NULL, NULL, NULL},
   {"u1420p", "k", NULL, NULL, NULL},
   {"u1421p", "S", NULL, NULL, NULL},
   {"u1422p", "s", NULL, NULL, NULL},
   {"u1423p", "n", NULL, NULL, NULL},
   {"u1424p", "w", NULL, NULL, NULL},
   {"u1425p", "t", "t", NULL, NULL},
   {"u1426p", "h", NULL, NULL, NULL},
   {"u1427p", "w", NULL, NULL, NULL},
   {"u1428p", "G", NULL, NULL, NULL},
   {"u1429p", "n", NULL, NULL, NULL},
   {"u142Ap", "l", NULL, NULL, NULL},
   {"u142Bp", "e", "n", NULL, NULL},
   {"u142Cp", "i", "n", NULL, NULL},
   {"u142Dp", "o", "n", NULL, NULL},
   {"u142Ep", "a", "n", NULL, NULL},
   {"u142Fp", "p", "aI", NULL, NULL},
   {"u1430p", "p", "A:", "i", NULL},
   {"u1431p", "p", "i", NULL, NULL},
   {"u1432p", "p", "i:", NULL, NULL},
   {"u1433p", "p", "u", NULL, NULL},
   {"u1434p", "p", "u:", NULL, NULL},
   {"u1435p", "p", "o:", NULL, NULL},
   {"u1436p", "h", "e:", NULL, NULL},
   {"u1437p", "h", "i", NULL, NULL},
   {"u1438p", "p", "A", NULL, NULL},
   {"u1439p", "p", "A:", NULL, NULL},
   {"u143Ap", "pw", "e", NULL, NULL},
   {"u143Bp", "pw", "e", NULL, NULL},
   {"u143Cp", "pw", "i", NULL, NULL},
   {"u143Dp", "pw", "i", NULL, NULL},
   {"u143Ep", "pw", "i:", NULL, NULL},
   {"u143Fp", "pw", "i:", NULL, NULL},
   {"u1440p", "pw", "o", NULL, NULL},
   {"u1441p", "pw", "o", NULL, NULL},
   {"u1442p", "pw", "o:", NULL, NULL},
   {"u1443p", "pw", "o:", NULL, NULL},
   {"u1444p", "pw", "A", NULL, NULL},
   {"u1445p", "pw", "A", NULL, NULL},
   {"u1446p", "pw", "A:", NULL, NULL},
   {"u1447p", "pw", "A:", NULL, NULL},
   {"u1448p", "pw", "A:", NULL, NULL},
   {"u1449p", "p", NULL, NULL, NULL},
   {"u144Ap", "h", NULL, NULL, NULL},
   {"u144Bp", "t", "aI", NULL, NULL},
   {"u144Cp", "t", "A:", "i", NULL},
   {"u144Dp", "t", "i", NULL, NULL},
   {"u144Ep", "t", "i", NULL, NULL},
   {"u144Fp", "t", "i:", NULL, NULL},
   {"u1450p", "t", "u", NULL, NULL},
   {"u1451p", "t", "u:", NULL, NULL},
   {"u1452p", "t", "o:", NULL, NULL},
   {"u1453p", "d", "e:", NULL, NULL},
   {"u1454p", "d", "i", NULL, NULL},
   {"u1455p", "t", "A", NULL, NULL},
   {"u1456p", "t", "A:", NULL, NULL},
   {"u1457p", "tw", "e", NULL, NULL},
   {"u1458p", "tw", "i", NULL, NULL},
   {"u1459p", "tw", "i", NULL, NULL},
   {"u145Ap", "tw", "i:", NULL, NULL},
   {"u145Bp", "tw", "i:", NULL, NULL},
   {"u145Cp", "tw", "i:", NULL, NULL},
   {"u145Dp", "tw", "o", NULL, NULL},
   {"u145Ep", "tw", "o", NULL, NULL},
   {"u145Fp", "tw", "o:", NULL, NULL},
   {"u1460p", "tw", "o:", NULL, NULL},
   {"u1461p", "tw", "A", NULL, NULL},
   {"u1462p", "tw", "A", NULL, NULL},
   {"u1463p", "tw", "A:", NULL, NULL},
   {"u1464p", "tw", "A:", NULL, NULL},
   {"u1465p", "tw", "A:", NULL, NULL},
   {"u1466p", "t", NULL, NULL, NULL},
   {"u1467p", "t", "t", "e", NULL},
   {"u1468p", "t", "t", "i", NULL},
   {"u1469p", "t", "t", "o", NULL},
   {"u146Ap", "t", "t", "A", NULL},
   {"u146Bp", "k", "aI", NULL, NULL},
   {"u146Cp", "k", "A:", "i", NULL},
   {"u146Dp", "k", "i", NULL, NULL},
   {"u146Ep", "k", "i:", NULL, NULL},
   {"u146Fp", "k", "u", NULL, NULL},
   {"u1470p", "k", "u:", NULL, NULL},
   {"u1471p", "k", "o:", NULL, NULL},
   {"u1472p", "k", "A", NULL, NULL},
   {"u1473p", "k", "A:", NULL, NULL},
   {"u1474p", "kw", "e", NULL, NULL},
   {"u1475p", "kw", "e", NULL, NULL},
   {"u1476p", "kw", "i", NULL, NULL},
   {"u1477p", "kw", "i", NULL, NULL},
   {"u1478p", "kw", "i:", NULL, NULL},
   {"u1479p", "kw", "i:", NULL, NULL},
   {"u147Ap", "kw", "o", NULL, NULL},
   {"u147Bp", "kw", "o", NULL, NULL},
   {"u147Cp", "kw", "o:", NULL, NULL},
   {"u147Dp", "kw", "o:", NULL, NULL},
   {"u147Ep", "kw", "A", NULL, NULL},
   {"u147Fp", "kw", "A", NULL, NULL},
   {"u1480p", "kw", "A", NULL, NULL},
   {"u1481p", "kw", "A:", NULL, NULL},
   {"u1482p", "kw", "A:", NULL, NULL},
   {"u1483p", "k", NULL, NULL, NULL},
   {"u1484p", "kw", NULL, NULL, NULL},
   {"u1485p", "k", "eh", NULL, NULL},
   {"u1486p", "k", "ih", NULL, NULL},
   {"u1487p", "k", "oh", NULL, NULL},
   {"u1488p", "k", "ah", NULL, NULL},
   {"u1489p", "G", "aI", NULL, NULL},
   {"u148Ap", "G", "A:", "i", NULL},
   {"u148Bp", "G", "i", NULL, NULL},
   {"u148Cp", "G", "i:", NULL, NULL},
   {"u148Dp", "G", "u", NULL, NULL},
   {"u148Ep", "G", "u:", NULL, NULL},
   {"u148Fp", "G", "o:", NULL, NULL},
   {"u1490p", "G", "A", NULL, NULL},
   {"u1491p", "G", "A:", NULL, NULL},
   {"u1492p", "Gw", "e", NULL, NULL},
   {"u1493p", "Gw", "e", NULL, NULL},
   {"u1494p", "Gw", "i", NULL, NULL},
   {"u1495p", "Gw", "i", NULL, NULL},
   {"u1496p", "Gw", "i:", NULL, NULL},
   {"u1497p", "Gw", "i:", NULL, NULL},
   {"u1498p", "Gw", "o", NULL, NULL},
   {"u1499p", "Gw", "o", NULL, NULL},
   {"u149Ap", "Gw", "o:", NULL, NULL},
   {"u149Bp", "Gw", "o:", NULL, NULL},
   {"u149Cp", "Gw", "A", NULL, NULL},
   {"u149Dp", "Gw", "A", NULL, NULL},
   {"u149Ep", "Gw", "A:", NULL, NULL},
   {"u149Fp", "Gw", "A:", NULL, NULL},
   {"u14A0p", "Gw", "A:", NULL, NULL},
   {"u14A1p", "G", NULL, NULL, NULL},
   {"u14A2p", "D", NULL, NULL, NULL},
   {"u14A3p", "m", "aI", NULL, NULL},
   {"u14A4p", "m", "A:", "i", NULL},
   {"u14A5p", "m", "i", NULL, NULL},
   {"u14A6p", "m", "i:", NULL, NULL},
   {"u14A7p", "m", "u", NULL, NULL},
   {"u14A8p", "m", "u:", NULL, NULL},
   {"u14A9p", "m", "o:", NULL, NULL},
   {"u14AAp", "m", "A", NULL, NULL},
   {"u14ABp", "m", "A:", NULL, NULL},
   {"u14ACp", "mw", "e", NULL, NULL},
   {"u14ADp", "mw", "e", NULL, NULL},
   {"u14AEp", "mw", "i", NULL, NULL},
   {"u14AFp", "mw", "i", NULL, NULL},
   {"u14B0p", "mw", "i:", NULL, NULL},
   {"u14B1p", "mw", "i:", NULL, NULL},
   {"u14B2p", "mw", "o", NULL, NULL},
   {"u14B3p", "mw", "o", NULL, NULL},
   {"u14B4p", "mw", "o:", NULL, NULL},
   {"u14B5p", "mw", "o:", NULL, NULL},
   {"u14B6p", "mw", "A", NULL, NULL},
   {"u14B7p", "mw", "A", NULL, NULL},
   {"u14B8p", "mw", "A:", NULL, NULL},
   {"u14B9p", "mw", "A:", NULL, NULL},
   {"u14BAp", "mw", "A:", NULL, NULL},
   {"u14BBp", "m", NULL, NULL, NULL},
   {"u14BCp", "m", NULL, NULL, NULL},
   {"u14BDp", "mh", NULL, NULL, NULL},
   {"u14BEp", "m", NULL, NULL, NULL},
   {"u14BFp", "m", NULL, NULL, NULL},
   {"u14C0p", "n", "aI", NULL, NULL},
   {"u14C1p", "n", "A:", "i", NULL},
   {"u14C2p", "n", "i", NULL, NULL},
   {"u14C3p", "n", "i:", NULL, NULL},
   {"u14C4p", "n", "u", NULL, NULL},
   {"u14C5p", "n", "u:", NULL, NULL},
   {"u14C6p", "n", "o:", NULL, NULL},
   {"u14C7p", "n", "A", NULL, NULL},
   {"u14C8p", "n", "A:", NULL, NULL},
   {"u14C9p", "nw", "e", NULL, NULL},
   {"u14CAp", "nw", "e", NULL, NULL},
   {"u14CBp", "nw", "A", NULL, NULL},
   {"u14CCp", "nw", "A", NULL, NULL},
   {"u14CDp", "nw", "A:", NULL, NULL},
   {"u14CEp", "nw", "A:", NULL, NULL},
   {"u14CFp", "nw", "A:", NULL, NULL},
   {"u14D0p", "n", NULL, NULL, NULL},
   {"u14D1p", "N", NULL, NULL, NULL},
   {"u14D2p", "nh", NULL, NULL, NULL},
   {"u14D3p", "l", "aI", NULL, NULL},
   {"u14D4p", "l", "A:", "i", NULL},
   {"u14D5p", "l", "i", NULL, NULL},
   {"u14D6p", "l", "i:", NULL, NULL},
   {"u14D7p", "l", "u", NULL, NULL},
   {"u14D8p", "l", "u:", NULL, NULL},
   {"u14D9p", "l", "o:", NULL, NULL},
   {"u14DAp", "l", "A", NULL, NULL},
   {"u14DBp", "l", "A:", NULL, NULL},
   {"u14DCp", "lw", "e", NULL, NULL},
   {"u14DDp", "lw", "e", NULL, NULL},
   {"u14DEp", "lw", "i", NULL, NULL},
   {"u14DFp", "lw", "i", NULL, NULL},
   {"u14E0p", "lw", "i:", NULL, NULL},
   {"u14E1p", "lw", "i:", NULL, NULL},
   {"u14E2p", "lw", "o", NULL, NULL},
   {"u14E3p", "lw", "o", NULL, NULL},
   {"u14E4p", "lw", "o:", NULL, NULL},
   {"u14E5p", "lw", "o:", NULL, NULL},
   {"u14E6p", "lw", "A", NULL, NULL},
   {"u14E7p", "lw", "A", NULL, NULL},
   {"u14E8p", "lw", "A:", NULL, NULL},
   {"u14E9p", "lw", "A:", NULL, NULL},
   {"u14EAp", "l", NULL, NULL, NULL},
   {"u14EBp", "l", NULL, NULL, NULL},
   {"u14ECp", "l", NULL, NULL, NULL},
   {"u14EDp", "s", "aI", NULL, NULL},
   {"u14EEp", "s", "A:", "i", NULL},
   {"u14EFp", "s", "i", NULL, NULL},
   {"u14F0p", "s", "i:", NULL, NULL},
   {"u14F1p", "s", "u", NULL, NULL},
   {"u14F2p", "s", "u:", NULL, NULL},
   {"u14F3p", "s", "o:", NULL, NULL},
   {"u14F4p", "s", "A", NULL, NULL},
   {"u14F5p", "s", "A:", NULL, NULL},
   {"u14F6p", "sw", "e", NULL, NULL},
   {"u14F7p", "sw", "e", NULL, NULL},
   {"u14F8p", "sw", "i", NULL, NULL},
   {"u14F9p", "sw", "i", NULL, NULL},
   {"u14FAp", "sw", "i:", NULL, NULL},
   {"u14FBp", "sw", "i:", NULL, NULL},
   {"u14FCp", "sw", "o", NULL, NULL},
   {"u14FDp", "sw", "o", NULL, NULL},
   {"u14FEp", "sw", "o:", NULL, NULL},
   {"u14FFp", "sw", "o:", NULL, NULL},
   {"u1500p", "sw", "A", NULL, NULL},
   {"u1501p", "sw", "A", NULL, NULL},
   {"u1502p", "sw", "A:", NULL, NULL},
   {"u1503p", "sw", "A:", NULL, NULL},
   {"u1504p", "sw", "A:", NULL, NULL},
   {"u1505p", "s", NULL, NULL, NULL},
   {"u1506p", "s", NULL, NULL, NULL},
   {"u1507p", "sw", NULL, NULL, NULL},
   {"u1508p", "s", NULL, NULL, NULL},
   {"u1509p", "s", "k", NULL, NULL},
   {"u150Ap", "s", "kw", NULL, NULL},
   {"u150Bp", "s", "w", NULL, NULL},
   {"u150Cp", "s", "pw", "A", NULL},
   {"u150Dp", "s", "tw", "A", NULL},
   {"u150Ep", "s", "kw", "A", NULL},
   {"u150Fp", "s", "cw", "A", NULL},
   {"u1510p", "S", "e", NULL, NULL},
   {"u1511p", "S", "i", NULL, NULL},
   {"u1512p", "S", "i:", NULL, NULL},
   {"u1513p", "S", "o", NULL, NULL},
   {"u1514p", "S", "o:", NULL, NULL},
   {"u1515p", "S", "A", NULL, NULL},
   {"u1516p", "S", "A:", NULL, NULL},
   {"u1517p", "Sw", "e", NULL, NULL},
   {"u1518p", "Sw", "e", NULL, NULL},
   {"u1519p", "Sw", "i", NULL, NULL},
   {"u151Ap", "Sw", "i", NULL, NULL},
   {"u151Bp", "Sw", "i:", NULL, NULL},
   {"u151Cp", "Sw", "i:", NULL, NULL},
   {"u151Dp", "Sw", "o", NULL, NULL},
   {"u151Ep", "Sw", "o", NULL, NULL},
   {"u151Fp", "Sw", "o:", NULL, NULL},
   {"u1520p", "Sw", "o:", NULL, NULL},
   {"u1521p", "Sw", "A", NULL, NULL},
   {"u1522p", "Sw", "A", NULL, NULL},
   {"u1523p", "Sw", "A:", NULL, NULL},
   {"u1524p", "Sw", "A:", NULL, NULL},
   {"u1525p", "S", NULL, NULL, NULL},
   {"u1526p", "j", "aI", NULL, NULL},
   {"u1527p", "j", "A:", "i", NULL},
   {"u1528p", "j", "i", NULL, NULL},
   {"u1529p", "j", "i:", NULL, NULL},
   {"u152Ap", "j", "u", NULL, NULL},
   {"u152Bp", "j", "u:", NULL, NULL},
   {"u152Cp", "j", "o:", NULL, NULL},
   {"u152Dp", "j", "A", NULL, NULL},
   {"u152Ep", "j", "A:", NULL, NULL},
   {"u152Fp", "jw", "e", NULL, NULL},
   {"u1530p", "jw", "e", NULL, NULL},
   {"u1531p", "jw", "i", NULL, NULL},
   {"u1532p", "jw", "i", NULL, NULL},
   {"u1533p", "jw", "i:", NULL, NULL},
   {"u1534p", "jw", "i:", NULL, NULL},
   {"u1535p", "jw", "o", NULL, NULL},
   {"u1536p", "jw", "o", NULL, NULL},
   {"u1537p", "jw", "o:", NULL, NULL},
   {"u1538p", "jw", "o:", NULL, NULL},
   {"u1539p", "jw", "A", NULL, NULL},
   {"u153Ap", "jw", "A", NULL, NULL},
   {"u153Bp", "jw", "A:", NULL, NULL},
   {"u153Cp", "jw", "A:", NULL, NULL},
   {"u153Dp", "jw", "A:", NULL, NULL},
   {"u153Ep", "j", NULL, NULL, NULL},
   {"u153Fp", "j", NULL, NULL, NULL},
   {"u1540p", "j", NULL, NULL, NULL},
   {"u1541p", "j", "i", NULL, NULL},
   {"u1542p", "r", "aI", NULL, NULL},
   {"u1543p", "r", "e", NULL, NULL},
   {"u1544p", "l", "e", NULL, NULL},
   {"u1545p", "r", "A:", "i", NULL},
   {"u1546p", "r", "i", NULL, NULL},
   {"u1547p", "r", "i:", NULL, NULL},
   {"u1548p", "r", "u", NULL, NULL},
   {"u1549p", "r", "u:", NULL, NULL},
   {"u154Ap", "l", "o", NULL, NULL},
   {"u154Bp", "r", "A", NULL, NULL},
   {"u154Cp", "r", "A:", NULL, NULL},
   {"u154Dp", "l", "a", NULL, NULL},
   {"u154Ep", "rw", "A:", NULL, NULL},
   {"u154Fp", "rw", "A:", NULL, NULL},
   {"u1550p", "r", NULL, NULL, NULL},
   {"u1551p", "r", NULL, NULL, NULL},
   {"u1552p", "r", NULL, NULL, NULL},
   {"u1553p", "v", "aI", NULL, NULL},
   {"u1554p", "v", "A:", "i", NULL},
   {"u1555p", "v", "i", NULL, NULL},
   {"u1556p", "v", "i:", NULL, NULL},
   {"u1557p", "v", "o", NULL, NULL},
   {"u1558p", "v", "o:", NULL, NULL},
   {"u1559p", "v", "A", NULL, NULL},
   {"u155Ap", "v", "A:", NULL, NULL},
   {"u155Bp", "vw", "A:", NULL, NULL},
   {"u155Cp", "vw", "A:", NULL, NULL},
   {"u155Dp", "v", NULL, NULL, NULL},
   {"u155Ep", "D", "e", NULL, NULL},
   {"u155Fp", "D", "e", NULL, NULL},
   {"u1560p", "D", "i", NULL, NULL},
   {"u1561p", "D", "i", NULL, NULL},
   {"u1562p", "D", "i:", NULL, NULL},
   {"u1563p", "D", "i:", NULL, NULL},
   {"u1564p", "D", "o", NULL, NULL},
   {"u1565p", "D", "o:", NULL, NULL},
   {"u1566p", "D", "A", NULL, NULL},
   {"u1567p", "D", "A:", NULL, NULL},
   {"u1568p", "Dw", "A:", NULL, NULL},
   {"u1569p", "Dw", "A:", NULL, NULL},
   {"u156Ap", "D", NULL, NULL, NULL},
   {"u156Bp", "D", "e", NULL, NULL},
   {"u156Cp", "D", "i", NULL, NULL},
   {"u156Dp", "D", "o", NULL, NULL},
   {"u156Ep", "D", "A", NULL, NULL},
   {"u156Fp", "D", NULL, NULL, NULL},
   {"u1570p", "tj", "e", NULL, NULL},
   {"u1571p", "tj", "i", NULL, NULL},
   {"u1572p", "tj", "o", NULL, NULL},
   {"u1573p", "tj", "A", NULL, NULL},
   {"u1574p", "h", "e", NULL, NULL},
   {"u1575p", "h", "i", NULL, NULL},
   {"u1576p", "h", "i:", NULL, NULL},
   {"u1577p", "h", "o", NULL, NULL},
   {"u1578p", "h", "o:", NULL, NULL},
   {"u1579p", "h", "A", NULL, NULL},
   {"u157Ap", "h", "A:", NULL, NULL},
   {"u157Bp", "h", NULL, NULL, NULL},
   {"u157Cp", "h", NULL, NULL, NULL},
   {"u157Dp", "h", "k", NULL, NULL},
   {"u157Ep", "q", "A:", "i", NULL},
   {"u157Fp", "q", "i", NULL, NULL},
   {"u1580p", "q", "i:", NULL, NULL},
   {"u1581p", "q", "u", NULL, NULL},
   {"u1582p", "q", "u:", NULL, NULL},
   {"u1583p", "q", "A", NULL, NULL},
   {"u1584p", "q", "A:", NULL, NULL},
   {"u1585p", "q", NULL, NULL, NULL},
   {"u1586p", "th", "l", "e", NULL},
   {"u1587p", "th", "l", "i", NULL},
   {"u1588p", "th", "l", "o", NULL},
   {"u1589p", "th", "l", "A", NULL},
   {"u158Ap", "r", "e", NULL, NULL},
   {"u158Bp", "r", "i", NULL, NULL},
   {"u158Cp", "r", "o", NULL, NULL},
   {"u158Dp", "r", "A", NULL, NULL},
   {"u158Ep", "N", "aI", NULL, NULL},
   {"u158Fp", "N", "i", NULL, NULL},
   {"u1590p", "N", "i:", NULL, NULL},
   {"u1591p", "N", "u", NULL, NULL},
   {"u1592p", "N", "u:", NULL, NULL},
   {"u1593p", "N", "A", NULL, NULL},
   {"u1594p", "N", "A:", NULL, NULL},
   {"u1595p", "N", NULL, NULL, NULL},
   {"u1596p", "N", NULL, NULL, NULL},
   {"u1597p", "S", "e", NULL, NULL},
   {"u1598p", "S", "i", NULL, NULL},
   {"u1599p", "S", "o", NULL, NULL},
   {"u159Ap", "S", "A", NULL, NULL},
   {"u159Bp", "D", "e", NULL, NULL},
   {"u159Cp", "D", "i", NULL, NULL},
   {"u159Dp", "D", "o", NULL, NULL},
   {"u159Ep", "D", "A", NULL, NULL},
   {"u159Fp", "D", NULL, NULL, NULL},
   {"u15A0p", "hl", "i", NULL, NULL},
   {"u15A1p", "hl", "i:", NULL, NULL},
   {"u15A2p", "hl", "u", NULL, NULL},
   {"u15A3p", "hl", "u:", NULL, NULL},
   {"u15A4p", "hl", "A", NULL, NULL},
   {"u15A5p", "hl", "A:", NULL, NULL},
   {"u15A6p", "hl", NULL, NULL, NULL},
   {"u15A7p", "D", "e", NULL, NULL},
   {"u15A8p", "D", "i", NULL, NULL},
   {"u15A9p", "D", "i:", NULL, NULL},
   {"u15AAp", "D", "o", NULL, NULL},
   {"u15ABp", "D", "o:", NULL, NULL},
   {"u15ACp", "D", "A", NULL, NULL},
   {"u15ADp", "D", "A:", NULL, NULL},
   {"u15AEp", "D", NULL, NULL, NULL},
   {"u15AFp", "b", NULL, NULL, NULL},
   {"u15B0p", "e", NULL, NULL, NULL},
   {"u15B1p", "i", NULL, NULL, NULL},
   {"u15B2p", "o", NULL, NULL, NULL},
   {"u15B3p", "A", NULL, NULL, NULL},
   {"u15B4p", "w", "e", NULL, NULL},
   {"u15B5p", "w", "i", NULL, NULL},
   {"u15B6p", "w", "o", NULL, NULL},
   {"u15B7p", "w", "A", NULL, NULL},
   {"u15B8p", "n", "e", NULL, NULL},
   {"u15B9p", "n", "i", NULL, NULL},
   {"u15BAp", "n", "o", NULL, NULL},
   {"u15BBp", "n", "A", NULL, NULL},
   {"u15BCp", "k", "e", NULL, NULL},
   {"u15BDp", "k", "i", NULL, NULL},
   {"u15BEp", "k", "o", NULL, NULL},
   {"u15BFp", "k", "A", NULL, NULL},
   {"u15C0p", "h", "e", NULL, NULL},
   {"u15C1p", "h", "i", NULL, NULL},
   {"u15C2p", "h", "o", NULL, NULL},
   {"u15C3p", "h", "A", NULL, NULL},
   {"u15C4p", "Gh", "u", NULL, NULL},
   {"u15C5p", "Gh", "o", NULL, NULL},
   {"u15C6p", "Gh", "e", NULL, NULL},
   {"u15C7p", "Gh", "e:", NULL, NULL},
   {"u15C8p", "Gh", "i", NULL, NULL},
   {"u15C9p", "Gh", "A", NULL, NULL},
   {"u15CAp", "r", "u", NULL, NULL},
   {"u15CBp", "r", "o", NULL, NULL},
   {"u15CCp", "r", "e", NULL, NULL},
   {"u15CDp", "r", "e:", NULL, NULL},
   {"u15CEp", "r", "i", NULL, NULL},
   {"u15CFp", "r", "A", NULL, NULL},
   {"u15D0p", "w", "u", NULL, NULL},
   {"u15D1p", "w", "o", NULL, NULL},
   {"u15D2p", "w", "e", NULL, NULL},
   {"u15D3p", "w", "e:", NULL, NULL},
   {"u15D4p", "w", "i", NULL, NULL},
   {"u15D5p", "w", "A", NULL, NULL},
   {"u15D6p", "hw", "u", NULL, NULL},
   {"u15D7p", "hw", "o", NULL, NULL},
   {"u15D8p", "hw", "e", NULL, NULL},
   {"u15D9p", "hw", "e:", NULL, NULL},
   {"u15DAp", "hw", "i", NULL, NULL},
   {"u15DBp", "hw", "A", NULL, NULL},
   {"u15DCp", "D", "u", NULL, NULL},
   {"u15DDp", "D", "o", NULL, NULL},
   {"u15DEp", "D", "e", NULL, NULL},
   {"u15DFp", "D", "e:", NULL, NULL},
   {"u15E0p", "D", "i", NULL, NULL},
   {"u15E1p", "D", "A", NULL, NULL},
   {"u15E2p", "t", "t", "u", NULL},
   {"u15E3p", "t", "t", "o", NULL},
   {"u15E4p", "t", "t", "e", NULL},
   {"u15E5p", "t", "t", "e:", NULL},
   {"u15E6p", "t", "t", "i", NULL},
   {"u15E7p", "t", "t", "A", NULL},
   {"u15E8p", "p", "u", NULL, NULL},
   {"u15E9p", "p", "o", NULL, NULL},
   {"u15EAp", "p", "e", NULL, NULL},
   {"u15EBp", "p", "e:", NULL, NULL},
   {"u15ECp", "p", "i", NULL, NULL},
   {"u15EDp", "p", "A", NULL, NULL},
   {"u15EEp", "p", NULL, NULL, NULL},
   {"u15EFp", "G", "u", NULL, NULL},
   {"u15F0p", "G", "o", NULL, NULL},
   {"u15F1p", "G", "e", NULL, NULL},
   {"u15F2p", "G", "e:", NULL, NULL},
   {"u15F3p", "G", "i", NULL, NULL},
   {"u15F4p", "G", "A", NULL, NULL},
   {"u15F5p", "kh", "u", NULL, NULL},
   {"u15F6p", "kh", "o", NULL, NULL},
   {"u15F7p", "kh", "e", NULL, NULL},
   {"u15F8p", "kh", "e:", NULL, NULL},
   {"u15F9p", "kh", "i", NULL, NULL},
   {"u15FAp", "kh", "A", NULL, NULL},
   {"u15FBp", "k", "k", "u", NULL},
   {"u15FCp", "k", "k", "o", NULL},
   {"u15FDp", "k", "k", "e", NULL},
   {"u15FEp", "k", "k", "e:", NULL},
   {"u15FFp", "k", "k", "i", NULL},
   {"u1600p", "k", "k", "A", NULL},
   {"u1601p", "k", "k", NULL, NULL},
   {"u1602p", "n", "u", NULL, NULL},
   {"u1603p", "n", "o", NULL, NULL},
   {"u1604p", "n", "e", NULL, NULL},
   {"u1605p", "n", "e:", NULL, NULL},
   {"u1606p", "n", "i", NULL, NULL},
   {"u1607p", "n", "A", NULL, NULL},
   {"u1608p", "m", "u", NULL, NULL},
   {"u1609p", "m", "o", NULL, NULL},
   {"u160Ap", "m", "e", NULL, NULL},
   {"u160Bp", "m", "e:", NULL, NULL},
   {"u160Cp", "m", "i", NULL, NULL},
   {"u160Dp", "m", "A", NULL, NULL},
   {"u160Ep", "j", "u", NULL, NULL},
   {"u160Fp", "j", "o", NULL, NULL},
   {"u1610p", "j", "e", NULL, NULL},
   {"u1611p", "j", "e:", NULL, NULL},
   {"u1612p", "j", "i", NULL, NULL},
   {"u1613p", "j", "A", NULL, NULL},
   {"u1614p", "z", "u", NULL, NULL},
   {"u1615p", "z", "u", NULL, NULL},
   {"u1616p", "z", "o", NULL, NULL},
   {"u1617p", "z", "e", NULL, NULL},
   {"u1618p", "z", "e:", NULL, NULL},
   {"u1619p", "z", "i", NULL, NULL},
   {"u161Ap", "z", "i", NULL, NULL},
   {"u161Bp", "z", "A", NULL, NULL},
   {"u161Cp", "z", "z", "u", NULL},
   {"u161Dp", "z", "z", "o", NULL},
   {"u161Ep", "z", "z", "e", NULL},
   {"u161Fp", "z", "z", "e:", NULL},
   {"u1620p", "z", "z", "i", NULL},
   {"u1621p", "z", "z", "A", NULL},
   {"u1622p", "l", "u", NULL, NULL},
   {"u1623p", "l", "o", NULL, NULL},
   {"u1624p", "l", "e", NULL, NULL},
   {"u1625p", "l", "e:", NULL, NULL},
   {"u1626p", "l", "i", NULL, NULL},
   {"u1627p", "l", "A", NULL, NULL},
   {"u1628p", "d", "l", "u", NULL},
   {"u1629p", "d", "l", "o", NULL},
   {"u162Ap", "d", "l", "e", NULL},
   {"u162Bp", "d", "l", "e:", NULL},
   {"u162Cp", "d", "l", "i", NULL},
   {"u162Dp", "d", "l", "A", NULL},
   {"u162Ep", "hl", "u", NULL, NULL},
   {"u162Fp", "hl", "o", NULL, NULL},
   {"u1630p", "hl", "e", NULL, NULL},
   {"u1631p", "hl", "e:", NULL, NULL},
   {"u1632p", "hl", "i", NULL, NULL},
   {"u1633p", "hl", "A", NULL, NULL},
   {"u1634p", "th", "l", "u", NULL},
   {"u1635p", "th", "l", "o", NULL},
   {"u1636p", "th", "l", "e", NULL},
   {"u1637p", "th", "l", "e:", NULL},
   {"u1638p", "th", "l", "i", NULL},
   {"u1639p", "th", "l", "A", NULL},
   {"u163Ap", "t", "l", "u", NULL},
   {"u163Bp", "t", "l", "o", NULL},
   {"u163Cp", "t", "l", "e", NULL},
   {"u163Dp", "t", "l", "e:", NULL},
   {"u163Ep", "t", "l", "i", NULL},
   {"u163Fp", "t", "l", "A", NULL},
   {"u1640p", "z", "u", NULL, NULL},
   {"u1641p", "z", "o", NULL, NULL},
   {"u1642p", "z", "e", NULL, NULL},
   {"u1643p", "z", "e:", NULL, NULL},
   {"u1644p", "z", "i", NULL, NULL},
   {"u1645p", "z", "A", NULL, NULL},
   {"u1646p", "z", NULL, NULL, NULL},
   {"u1647p", "z", NULL, NULL, NULL},
   {"u1648p", "dz", "u", NULL, NULL},
   {"u1649p", "dz", "o", NULL, NULL},
   {"u164Ap", "dz", "e", NULL, NULL},
   {"u164Bp", "dz", "e:", NULL, NULL},
   {"u164Cp", "dz", "i", NULL, NULL},
   {"u164Dp", "dz", "A", NULL, NULL},
   {"u164Ep", "s", "u", NULL, NULL},
   {"u164Fp", "s", "o", NULL, NULL},
   {"u1650p", "s", "e", NULL, NULL},
   {"u1651p", "s", "e:", NULL, NULL},
   {"u1652p", "s", "i", NULL, NULL},
   {"u1653p", "s", "A", NULL, NULL},
   {"u1654p", "S", "u", NULL, NULL},
   {"u1655p", "S", "o", NULL, NULL},
   {"u1656p", "S", "e", NULL, NULL},
   {"u1657p", "S", "e:", NULL, NULL},
   {"u1658p", "S", "i", NULL, NULL},
   {"u1659p", "S", "A", NULL, NULL},
   {"u165Ap", "S", NULL, NULL, NULL},
   {"u165Bp", "ts", "u", NULL, NULL},
   {"u165Cp", "ts", "o", NULL, NULL},
   {"u165Dp", "ts", "e", NULL, NULL},
   {"u165Ep", "ts", "e:", NULL, NULL},
   {"u165Fp", "ts", "i", NULL, NULL},
   {"u1660p", "ts", "A", NULL, NULL},
   {"u1661p", "Gh", "u", NULL, NULL},
   {"u1662p", "Gh", "o", NULL, NULL},
   {"u1663p", "Gh", "e", NULL, NULL},
   {"u1664p", "Gh", "e:", NULL, NULL},
   {"u1665p", "Gh", "i", NULL, NULL},
   {"u1666p", "Gh", "A", NULL, NULL},
   {"u1667p", "ts", "u", NULL, NULL},
   {"u1668p", "ts", "o", NULL, NULL},
   {"u1669p", "ts", "e", NULL, NULL},
   {"u166Ap", "ts", "e:", NULL, NULL},
   {"u166Bp", "ts", "i", NULL, NULL},
   {"u166Cp", "ts", "A", NULL, NULL},
   {"u166Dp", "(SYMBOL TO DENOTE CHRIST)", NULL, NULL, NULL},
   {"u166Ep", "(FULL STOP)", NULL, NULL, NULL},
   {"u166Fp", "q", "aI", NULL, NULL},
   {"u1670p", "N", "aI", NULL, NULL},
   {"u1671p", "N", "i", NULL, NULL},
   {"u1672p", "N", "i:", NULL, NULL},
   {"u1673p", "N", "o", NULL, NULL},
   {"u1674p", "N", "o:", NULL, NULL},
   {"u1675p", "N", "A", NULL, NULL},
   {"u1676p", "N", "A:", NULL, NULL},
   {"uA000p", "i", NULL, NULL, NULL},
   {"uA001p", "i", NULL, NULL, NULL},
   {"uA002p", "i", NULL, NULL, NULL},
   {"uA003p", "i", NULL, NULL, NULL},
   {"uA004p", "e", NULL, NULL, NULL},
   {"uA005p", "e", NULL, NULL, NULL},
   {"uA006p", "e", NULL, NULL, NULL},
   {"uA007p", "e", NULL, NULL, NULL},
   {"uA008p", "A", NULL, NULL, NULL},
   {"uA009p", "A", NULL, NULL, NULL},
   {"uA00Ap", "A", NULL, NULL, NULL},
   {"uA00Bp", "A", NULL, NULL, NULL},
   {"uA00Cp", "GT", NULL, NULL, NULL},
   {"uA00Dp", "GT", NULL, NULL, NULL},
   {"uA00Ep", "GT", NULL, NULL, NULL},
   {"uA00Fp", "o", NULL, NULL, NULL},
   {"uA010p", "o", NULL, NULL, NULL},
   {"uA011p", "o", NULL, NULL, NULL},
   {"uA012p", "o", NULL, NULL, NULL},
   {"uA013p", "AMP", NULL, NULL, NULL},
   {"uA014p", "AMP", NULL, NULL, NULL},
   {"uA015p", "G", "u", NULL, NULL},
   {"uA016p", "p", "i", NULL, NULL},
   {"uA017p", "p", "i", NULL, NULL},
   {"uA018p", "p", "i", NULL, NULL},
   {"uA019p", "p", "i", NULL, NULL},
   {"uA01Ap", "p", "e", NULL, NULL},
   {"uA01Bp", "p", "e", NULL, NULL},
   {"uA01Cp", "p", "e", NULL, NULL},
   {"uA01Dp", "p", "e", NULL, NULL},
   {"uA01Ep", "p", "A", NULL, NULL},
   {"uA01Fp", "p", "A", NULL, NULL},
   {"uA020p", "p", "A", NULL, NULL},
   {"uA021p", "p", "A", NULL, NULL},
   {"uA022p", "p", "GT", NULL, NULL},
   {"uA023p", "p", "GT", NULL, NULL},
   {"uA024p", "p", "GT", NULL, NULL},
   {"uA025p", "p", "o", NULL, NULL},
   {"uA026p", "p", "o", NULL, NULL},
   {"uA027p", "p", "o", NULL, NULL},
   {"uA028p", "p", "o", NULL, NULL},
   {"uA029p", "p", "AMP", NULL, NULL},
   {"uA02Ap", "p", "AMP", NULL, NULL},
   {"uA02Bp", "p", "AMP", NULL, NULL},
   {"uA02Cp", "p", "u", NULL, NULL},
   {"uA02Dp", "p", "u", NULL, NULL},
   {"uA02Ep", "p", "u", NULL, NULL},
   {"uA02Fp", "p", "u", NULL, NULL},
   {"uA030p", "p", "u", NULL, NULL},
   {"uA031p", "p", "u", NULL, NULL},
   {"uA032p", "p", "l", NULL, NULL},
   {"uA033p", "p", "l", NULL, NULL},
   {"uA034p", "p", "l", NULL, NULL},
   {"uA035p", "p", "l", NULL, NULL},
   {"uA036p", "p", "i", NULL, NULL},
   {"uA037p", "p", "i", NULL, NULL},
   {"uA038p", "ph", "i", NULL, NULL},
   {"uA039p", "ph", "i", NULL, NULL},
   {"uA03Ap", "ph", "i", NULL, NULL},
   {"uA03Bp", "ph", "i", NULL, NULL},
   {"uA03Cp", "ph", "e", NULL, NULL},
   {"uA03Dp", "ph", "e", NULL, NULL},
   {"uA03Ep", "ph", "e", NULL, NULL},
   {"uA03Fp", "ph", "A", NULL, NULL},
   {"uA040p", "ph", "A", NULL, NULL},
   {"uA041p", "ph", "A", NULL, NULL},
   {"uA042p", "ph", "A", NULL, NULL},
   {"uA043p", "ph", "GT", NULL, NULL},
   {"uA044p", "ph", "GT", NULL, NULL},
   {"uA045p", "ph", "GT", NULL, NULL},
   {"uA046p", "ph", "o", NULL, NULL},
   {"uA047p", "ph", "o", NULL, NULL},
   {"uA048p", "ph", "o", NULL, NULL},
   {"uA049p", "ph", "o", NULL, NULL},
   {"uA04Ap", "ph", "u", NULL, NULL},
   {"uA04Bp", "ph", "u", NULL, NULL},
   {"uA04Cp", "ph", "u", NULL, NULL},
   {"uA04Dp", "ph", "u", NULL, NULL},
   {"uA04Ep", "ph", "u", NULL, NULL},
   {"uA04Fp", "ph", "u", NULL, NULL},
   {"uA050p", "ph", "l", NULL, NULL},
   {"uA051p", "ph", "l", NULL, NULL},
   {"uA052p", "ph", "l", NULL, NULL},
   {"uA053p", "ph", "l", NULL, NULL},
   {"uA054p", "ph", "i", NULL, NULL},
   {"uA055p", "ph", "i", NULL, NULL},
   {"uA056p", "b", "i", NULL, NULL},
   {"uA057p", "b", "i", NULL, NULL},
   {"uA058p", "b", "i", NULL, NULL},
   {"uA059p", "b", "i", NULL, NULL},
   {"uA05Ap", "b", "e", NULL, NULL},
   {"uA05Bp", "b", "e", NULL, NULL},
   {"uA05Cp", "b", "e", NULL, NULL},
   {"uA05Dp", "b", "e", NULL, NULL},
   {"uA05Ep", "b", "A", NULL, NULL},
   {"uA05Fp", "b", "A", NULL, NULL},
   {"uA060p", "b", "A", NULL, NULL},
   {"uA061p", "b", "A", NULL, NULL},
   {"uA062p", "b", "GT", NULL, NULL},
   {"uA063p", "b", "GT", NULL, NULL},
   {"uA064p", "b", "GT", NULL, NULL},
   {"uA065p", "b", "o", NULL, NULL},
   {"uA066p", "b", "o", NULL, NULL},
   {"uA067p", "b", "o", NULL, NULL},
   {"uA068p", "b", "o", NULL, NULL},
   {"uA069p", "b", "AMP", NULL, NULL},
   {"uA06Ap", "b", "AMP", NULL, NULL},
   {"uA06Bp", "b", "AMP", NULL, NULL},
   {"uA06Cp", "b", "u", NULL, NULL},
   {"uA06Dp", "b", "u", NULL, NULL},
   {"uA06Ep", "b", "u", NULL, NULL},
   {"uA06Fp", "b", "u", NULL, NULL},
   {"uA070p", "b", "u", NULL, NULL},
   {"uA071p", "b", "u", NULL, NULL},
   {"uA072p", "b", "l", NULL, NULL},
   {"uA073p", "b", "l", NULL, NULL},
   {"uA074p", "b", "l", NULL, NULL},
   {"uA075p", "b", "l", NULL, NULL},
   {"uA076p", "m", "b", "i", NULL},
   {"uA077p", "m", "b", "i", NULL},
   {"uA078p", "m", "b", "i", NULL},
   {"uA079p", "m", "b", "i", NULL},
   {"uA07Ap", "m", "b", "e", NULL},
   {"uA07Bp", "m", "b", "e", NULL},
   {"uA07Cp", "m", "b", "e", NULL},
   {"uA07Dp", "m", "b", "A", NULL},
   {"uA07Ep", "m", "b", "A", NULL},
   {"uA07Fp", "m", "b", "A", NULL},
   {"uA080p", "m", "b", "A", NULL},
   {"uA081p", "m", "b", "o", NULL},
   {"uA082p", "m", "b", "o", NULL},
   {"uA083p", "m", "b", "o", NULL},
   {"uA084p", "m", "b", "o", NULL},
   {"uA085p", "m", "b", "u", NULL},
   {"uA086p", "m", "b", "u", NULL},
   {"uA087p", "m", "b", "u", NULL},
   {"uA088p", "m", "b", "u", NULL},
   {"uA089p", "m", "b", "u", NULL},
   {"uA08Ap", "m", "b", "u", NULL},
   {"uA08Bp", "m", "b", "l", NULL},
   {"uA08Cp", "m", "b", "l", NULL},
   {"uA08Dp", "m", "b", "l", NULL},
   {"uA08Ep", "m", "b", "l", NULL},
   {"uA08Fp", "m", "b", "i", NULL},
   {"uA090p", "m", "b", "i", NULL},
   {"uA091p", "m0", "i", NULL, NULL},
   {"uA092p", "m0", "i", NULL, NULL},
   {"uA093p", "m0", "i", NULL, NULL},
   {"uA094p", "m0", "i", NULL, NULL},
   {"uA095p", "m0", "e", NULL, NULL},
   {"uA096p", "m0", "e", NULL, NULL},
   {"uA097p", "m0", "e", NULL, NULL},
   {"uA098p", "m0", "A", NULL, NULL},
   {"uA099p", "m0", "A", NULL, NULL},
   {"uA09Ap", "m0", "A", NULL, NULL},
   {"uA09Bp", "m0", "A", NULL, NULL},
   {"uA09Cp", "m0", "GT", NULL, NULL},
   {"uA09Dp", "m0", "GT", NULL, NULL},
   {"uA09Ep", "m0", "GT", NULL, NULL},
   {"uA09Fp", "m0", "o", NULL, NULL},
   {"uA0A0p", "m0", "o", NULL, NULL},
   {"uA0A1p", "m0", "o", NULL, NULL},
   {"uA0A2p", "m0", "o", NULL, NULL},
   {"uA0A3p", "m0", "u", NULL, NULL},
   {"uA0A4p", "m0", "u", NULL, NULL},
   {"uA0A5p", "m0", "u", NULL, NULL},
   {"uA0A6p", "m0", "u", NULL, NULL},
   {"uA0A7p", "m0", "u", NULL, NULL},
   {"uA0A8p", "m0", "u", NULL, NULL},
   {"uA0A9p", "m0", "l", NULL, NULL},
   {"uA0AAp", "m0", "l", NULL, NULL},
   {"uA0ABp", "m0", "l", NULL, NULL},
   {"uA0ACp", "m0", "i", NULL, NULL},
   {"uA0ADp", "m0", "i", NULL, NULL},
   {"uA0AEp", "m", "i", NULL, NULL},
   {"uA0AFp", "m", "i", NULL, NULL},
   {"uA0B0p", "m", "i", NULL, NULL},
   {"uA0B1p", "m", "i", NULL, NULL},
   {"uA0B2p", "m", "e", NULL, NULL},
   {"uA0B3p", "m", "e", NULL, NULL},
   {"uA0B4p", "m", "e", NULL, NULL},
   {"uA0B5p", "m", "A", NULL, NULL},
   {"uA0B6p", "m", "A", NULL, NULL},
   {"uA0B7p", "m", "A", NULL, NULL},
   {"uA0B8p", "m", "A", NULL, NULL},
   {"uA0B9p", "m", "GT", NULL, NULL},
   {"uA0BAp", "m", "GT", NULL, NULL},
   {"uA0BBp", "m", "GT", NULL, NULL},
   {"uA0BCp", "m", "GT", NULL, NULL},
   {"uA0BDp", "m", "o", NULL, NULL},
   {"uA0BEp", "m", "o", NULL, NULL},
   {"uA0BFp", "m", "o", NULL, NULL},
   {"uA0C0p", "m", "o", NULL, NULL},
   {"uA0C1p", "m", "AMP", NULL, NULL},
   {"uA0C2p", "m", "AMP", NULL, NULL},
   {"uA0C3p", "m", "u", NULL, NULL},
   {"uA0C4p", "m", "u", NULL, NULL},
   {"uA0C5p", "m", "u", NULL, NULL},
   {"uA0C6p", "m", "u", NULL, NULL},
   {"uA0C7p", "m", "u", NULL, NULL},
   {"uA0C8p", "m", "u", NULL, NULL},
   {"uA0C9p", "m", "l", NULL, NULL},
   {"uA0CAp", "m", "l", NULL, NULL},
   {"uA0CBp", "m", "l", NULL, NULL},
   {"uA0CCp", "m", "l", NULL, NULL},
   {"uA0CDp", "f", "i", NULL, NULL},
   {"uA0CEp", "f", "i", NULL, NULL},
   {"uA0CFp", "f", "i", NULL, NULL},
   {"uA0D0p", "f", "i", NULL, NULL},
   {"uA0D1p", "f", "A", NULL, NULL},
   {"uA0D2p", "f", "A", NULL, NULL},
   {"uA0D3p", "f", "A", NULL, NULL},
   {"uA0D4p", "f", "A", NULL, NULL},
   {"uA0D5p", "f", "o", NULL, NULL},
   {"uA0D6p", "f", "o", NULL, NULL},
   {"uA0D7p", "f", "o", NULL, NULL},
   {"uA0D8p", "f", "u", NULL, NULL},
   {"uA0D9p", "f", "u", NULL, NULL},
   {"uA0DAp", "f", "u", NULL, NULL},
   {"uA0DBp", "f", "u", NULL, NULL},
   {"uA0DCp", "f", "u", NULL, NULL},
   {"uA0DDp", "f", "u", NULL, NULL},
   {"uA0DEp", "f", "l", NULL, NULL},
   {"uA0DFp", "f", "l", NULL, NULL},
   {"uA0E0p", "f", "l", NULL, NULL},
   {"uA0E1p", "f", "l", NULL, NULL},
   {"uA0E2p", "v", "i", NULL, NULL},
   {"uA0E3p", "v", "i", NULL, NULL},
   {"uA0E4p", "v", "i", NULL, NULL},
   {"uA0E5p", "v", "i", NULL, NULL},
   {"uA0E6p", "v", "e", NULL, NULL},
   {"uA0E7p", "v", "e", NULL, NULL},
   {"uA0E8p", "v", "e", NULL, NULL},
   {"uA0E9p", "v", "e", NULL, NULL},
   {"uA0EAp", "v", "A", NULL, NULL},
   {"uA0EBp", "v", "A", NULL, NULL},
   {"uA0ECp", "v", "A", NULL, NULL},
   {"uA0EDp", "v", "A", NULL, NULL},
   {"uA0EEp", "v", "o", NULL, NULL},
   {"uA0EFp", "v", "o", NULL, NULL},
   {"uA0F0p", "v", "o", NULL, NULL},
   {"uA0F1p", "v", "o", NULL, NULL},
   {"uA0F2p", "v", "AMP", NULL, NULL},
   {"uA0F3p", "v", "AMP", NULL, NULL},
   {"uA0F4p", "v", "u", NULL, NULL},
   {"uA0F5p", "v", "u", NULL, NULL},
   {"uA0F6p", "v", "u", NULL, NULL},
   {"uA0F7p", "v", "u", NULL, NULL},
   {"uA0F8p", "v", "u", NULL, NULL},
   {"uA0F9p", "v", "u", NULL, NULL},
   {"uA0FAp", "v", "l", NULL, NULL},
   {"uA0FBp", "v", "l", NULL, NULL},
   {"uA0FCp", "v", "l", NULL, NULL},
   {"uA0FDp", "v", "l", NULL, NULL},
   {"uA0FEp", "v", "i", NULL, NULL},
   {"uA0FFp", "v", "i", NULL, NULL},
   {"uA100p", "t", "i", NULL, NULL},
   {"uA101p", "t", "i", NULL, NULL},
   {"uA102p", "t", "i", NULL, NULL},
   {"uA103p", "t", "i", NULL, NULL},
   {"uA104p", "t", "e", NULL, NULL},
   {"uA105p", "t", "e", NULL, NULL},
   {"uA106p", "t", "e", NULL, NULL},
   {"uA107p", "t", "A", NULL, NULL},
   {"uA108p", "t", "A", NULL, NULL},
   {"uA109p", "t", "A", NULL, NULL},
   {"uA10Ap", "t", "A", NULL, NULL},
   {"uA10Bp", "t", "GT", NULL, NULL},
   {"uA10Cp", "t", "GT", NULL, NULL},
   {"uA10Dp", "t", "o", NULL, NULL},
   {"uA10Ep", "t", "o", NULL, NULL},
   {"uA10Fp", "t", "o", NULL, NULL},
   {"uA110p", "t", "o", NULL, NULL},
   {"uA111p", "t", "AMP", NULL, NULL},
   {"uA112p", "t", "AMP", NULL, NULL},
   {"uA113p", "t", "AMP", NULL, NULL},
   {"uA114p", "t", "u", NULL, NULL},
   {"uA115p", "t", "u", NULL, NULL},
   {"uA116p", "t", "u", NULL, NULL},
   {"uA117p", "t", "u", NULL, NULL},
   {"uA118p", "t", "u", NULL, NULL},
   {"uA119p", "t", "u", NULL, NULL},
   {"uA11Ap", "th", "i", NULL, NULL},
   {"uA11Bp", "th", "i", NULL, NULL},
   {"uA11Cp", "th", "i", NULL, NULL},
   {"uA11Dp", "th", "i", NULL, NULL},
   {"uA11Ep", "th", "e", NULL, NULL},
   {"uA11Fp", "th", "e", NULL, NULL},
   {"uA120p", "th", "e", NULL, NULL},
   {"uA121p", "th", "A", NULL, NULL},
   {"uA122p", "th", "A", NULL, NULL},
   {"uA123p", "th", "A", NULL, NULL},
   {"uA124p", "th", "A", NULL, NULL},
   {"uA125p", "th", "GT", NULL, NULL},
   {"uA126p", "th", "GT", NULL, NULL},
   {"uA127p", "th", "GT", NULL, NULL},
   {"uA128p", "th", "GT", NULL, NULL},
   {"uA129p", "th", "o", NULL, NULL},
   {"uA12Ap", "th", "o", NULL, NULL},
   {"uA12Bp", "th", "o", NULL, NULL},
   {"uA12Cp", "th", "o", NULL, NULL},
   {"uA12Dp", "th", "AMP", NULL, NULL},
   {"uA12Ep", "th", "AMP", NULL, NULL},
   {"uA12Fp", "th", "AMP", NULL, NULL},
   {"uA130p", "th", "u", NULL, NULL},
   {"uA131p", "th", "u", NULL, NULL},
   {"uA132p", "th", "u", NULL, NULL},
   {"uA133p", "th", "u", NULL, NULL},
   {"uA134p", "th", "u", NULL, NULL},
   {"uA135p", "th", "u", NULL, NULL},
   {"uA136p", "d", "i", NULL, NULL},
   {"uA137p", "d", "i", NULL, NULL},
   {"uA138p", "d", "i", NULL, NULL},
   {"uA139p", "d", "i", NULL, NULL},
   {"uA13Ap", "d", "e", NULL, NULL},
   {"uA13Bp", "d", "e", NULL, NULL},
   {"uA13Cp", "d", "e", NULL, NULL},
   {"uA13Dp", "d", "A", NULL, NULL},
   {"uA13Ep", "d", "A", NULL, NULL},
   {"uA13Fp", "d", "A", NULL, NULL},
   {"uA140p", "d", "A", NULL, NULL},
   {"uA141p", "d", "GT", NULL, NULL},
   {"uA142p", "d", "GT", NULL, NULL},
   {"uA143p", "d", "GT", NULL, NULL},
   {"uA144p", "d", "o", NULL, NULL},
   {"uA145p", "d", "o", NULL, NULL},
   {"uA146p", "d", "o", NULL, NULL},
   {"uA147p", "d", "o", NULL, NULL},
   {"uA148p", "d", "AMP", NULL, NULL},
   {"uA149p", "d", "AMP", NULL, NULL},
   {"uA14Ap", "d", "AMP", NULL, NULL},
   {"uA14Bp", "d", "u", NULL, NULL},
   {"uA14Cp", "d", "u", NULL, NULL},
   {"uA14Dp", "d", "u", NULL, NULL},
   {"uA14Ep", "d", "u", NULL, NULL},
   {"uA14Fp", "d", "u", NULL, NULL},
   {"uA150p", "d", "u", NULL, NULL},
   {"uA151p", "n", "d", "i", NULL},
   {"uA152p", "n", "d", "i", NULL},
   {"uA153p", "n", "d", "i", NULL},
   {"uA154p", "n", "d", "i", NULL},
   {"uA155p", "n", "d", "e", NULL},
   {"uA156p", "n", "d", "e", NULL},
   {"uA157p", "n", "d", "A", NULL},
   {"uA158p", "n", "d", "A", NULL},
   {"uA159p", "n", "d", "A", NULL},
   {"uA15Ap", "n", "d", "A", NULL},
   {"uA15Bp", "n", "d", "o", NULL},
   {"uA15Cp", "n", "d", "o", NULL},
   {"uA15Dp", "n", "d", "o", NULL},
   {"uA15Ep", "n", "d", "o", NULL},
   {"uA15Fp", "n", "d", "AMP", NULL},
   {"uA160p", "n", "d", "AMP", NULL},
   {"uA161p", "n", "d", "AMP", NULL},
   {"uA162p", "n", "d", "u", NULL},
   {"uA163p", "n", "d", "u", NULL},
   {"uA164p", "n", "d", "u", NULL},
   {"uA165p", "n", "d", "u", NULL},
   {"uA166p", "n", "d", "u", NULL},
   {"uA167p", "n", "d", "u", NULL},
   {"uA168p", "n0", "i", NULL, NULL},
   {"uA169p", "n0", "i", NULL, NULL},
   {"uA16Ap", "n0", "i", NULL, NULL},
   {"uA16Bp", "n0", "i", NULL, NULL},
   {"uA16Cp", "n0", "e", NULL, NULL},
   {"uA16Dp", "n0", "e", NULL, NULL},
   {"uA16Ep", "n0", "e", NULL, NULL},
   {"uA16Fp", "n0", "e", NULL, NULL},
   {"uA170p", "n0", "A", NULL, NULL},
   {"uA171p", "n0", "A", NULL, NULL},
   {"uA172p", "n0", "A", NULL, NULL},
   {"uA173p", "n0", "A", NULL, NULL},
   {"uA174p", "n0", "GT", NULL, NULL},
   {"uA175p", "n0", "GT", NULL, NULL},
   {"uA176p", "n0", "o", NULL, NULL},
   {"uA177p", "n0", "o", NULL, NULL},
   {"uA178p", "n0", "o", NULL, NULL},
   {"uA179p", "n0", "AMP", NULL, NULL},
   {"uA17Ap", "n0", "AMP", NULL, NULL},
   {"uA17Bp", "n0", "AMP", NULL, NULL},
   {"uA17Cp", "n0", "u", NULL, NULL},
   {"uA17Dp", "n", "i", NULL, NULL},
   {"uA17Ep", "n", "i", NULL, NULL},
   {"uA17Fp", "n", "i", NULL, NULL},
   {"uA180p", "n", "i", NULL, NULL},
   {"uA181p", "n", "e", NULL, NULL},
   {"uA182p", "n", "e", NULL, NULL},
   {"uA183p", "n", "e", NULL, NULL},
   {"uA184p", "n", "A", NULL, NULL},
   {"uA185p", "n", "A", NULL, NULL},
   {"uA186p", "n", "A", NULL, NULL},
   {"uA187p", "n", "GT", NULL, NULL},
   {"uA188p", "n", "GT", NULL, NULL},
   {"uA189p", "n", "GT", NULL, NULL},
   {"uA18Ap", "n", "o", NULL, NULL},
   {"uA18Bp", "n", "o", NULL, NULL},
   {"uA18Cp", "n", "o", NULL, NULL},
   {"uA18Dp", "n", "o", NULL, NULL},
   {"uA18Ep", "n", "AMP", NULL, NULL},
   {"uA18Fp", "n", "AMP", NULL, NULL},
   {"uA190p", "n", "AMP", NULL, NULL},
   {"uA191p", "n", "u", NULL, NULL},
   {"uA192p", "n", "u", NULL, NULL},
   {"uA193p", "n", "u", NULL, NULL},
   {"uA194p", "n", "u", NULL, NULL},
   {"uA195p", "n", "u", NULL, NULL},
   {"uA196p", "n", "u", NULL, NULL},
   {"uA197p", "hl", "i", NULL, NULL},
   {"uA198p", "hl", "i", NULL, NULL},
   {"uA199p", "hl", "i", NULL, NULL},
   {"uA19Ap", "hl", "i", NULL, NULL},
   {"uA19Bp", "hl", "e", NULL, NULL},
   {"uA19Cp", "hl", "e", NULL, NULL},
   {"uA19Dp", "hl", "e", NULL, NULL},
   {"uA19Ep", "hl", "A", NULL, NULL},
   {"uA19Fp", "hl", "A", NULL, NULL},
   {"uA1A0p", "hl", "A", NULL, NULL},
   {"uA1A1p", "hl", "A", NULL, NULL},
   {"uA1A2p", "hl", "GT", NULL, NULL},
   {"uA1A3p", "hl", "GT", NULL, NULL},
   {"uA1A4p", "hl", "GT", NULL, NULL},
   {"uA1A5p", "hl", "o", NULL, NULL},
   {"uA1A6p", "hl", "o", NULL, NULL},
   {"uA1A7p", "hl", "o", NULL, NULL},
   {"uA1A8p", "hl", "AMP", NULL, NULL},
   {"uA1A9p", "hl", "AMP", NULL, NULL},
   {"uA1AAp", "hl", "AMP", NULL, NULL},
   {"uA1ABp", "hl", "u", NULL, NULL},
   {"uA1ACp", "hl", "u", NULL, NULL},
   {"uA1ADp", "hl", "u", NULL, NULL},
   {"uA1AEp", "hl", "u", NULL, NULL},
   {"uA1AFp", "hl", "u", NULL, NULL},
   {"uA1B0p", "hl", "u", NULL, NULL},
   {"uA1B1p", "hl", "l", NULL, NULL},
   {"uA1B2p", "hl", "l", NULL, NULL},
   {"uA1B3p", "hl", "l", NULL, NULL},
   {"uA1B4p", "hl", "l", NULL, NULL},
   {"uA1B5p", "hl", "i", NULL, NULL},
   {"uA1B6p", "hl", "i", NULL, NULL},
   {"uA1B7p", "l", "i", NULL, NULL},
   {"uA1B8p", "l", "i", NULL, NULL},
   {"uA1B9p", "l", "i", NULL, NULL},
   {"uA1BAp", "l", "i", NULL, NULL},
   {"uA1BBp", "l", "e", NULL, NULL},
   {"uA1BCp", "l", "e", NULL, NULL},
   {"uA1BDp", "l", "e", NULL, NULL},
   {"uA1BEp", "l", "e", NULL, NULL},
   {"uA1BFp", "l", "A", NULL, NULL},
   {"uA1C0p", "l", "A", NULL, NULL},
   {"uA1C1p", "l", "A", NULL, NULL},
   {"uA1C2p", "l", "A", NULL, NULL},
   {"uA1C3p", "l", "GT", NULL, NULL},
   {"uA1C4p", "l", "GT", NULL, NULL},
   {"uA1C5p", "l", "GT", NULL, NULL},
   {"uA1C6p", "l", "GT", NULL, NULL},
   {"uA1C7p", "l", "o", NULL, NULL},
   {"uA1C8p", "l", "o", NULL, NULL},
   {"uA1C9p", "l", "o", NULL, NULL},
   {"uA1CAp", "l", "o", NULL, NULL},
   {"uA1CBp", "l", "AMP", NULL, NULL},
   {"uA1CCp", "l", "AMP", NULL, NULL},
   {"uA1CDp", "l", "AMP", NULL, NULL},
   {"uA1CEp", "l", "u", NULL, NULL},
   {"uA1CFp", "l", "u", NULL, NULL},
   {"uA1D0p", "l", "u", NULL, NULL},
   {"uA1D1p", "l", "u", NULL, NULL},
   {"uA1D2p", "l", "u", NULL, NULL},
   {"uA1D3p", "l", "u", NULL, NULL},
   {"uA1D4p", "l", "l", NULL, NULL},
   {"uA1D5p", "l", "l", NULL, NULL},
   {"uA1D6p", "l", "l", NULL, NULL},
   {"uA1D7p", "l", "l", NULL, NULL},
   {"uA1D8p", "l", "i", NULL, NULL},
   {"uA1D9p", "l", "i", NULL, NULL},
   {"uA1DAp", "k", "i", NULL, NULL},
   {"uA1DBp", "k", "i", NULL, NULL},
   {"uA1DCp", "k", "i", NULL, NULL},
   {"uA1DDp", "k", "i", NULL, NULL},
   {"uA1DEp", "k", "e", NULL, NULL},
   {"uA1DFp", "k", "e", NULL, NULL},
   {"uA1E0p", "k", "e", NULL, NULL},
   {"uA1E1p", "k", "e", NULL, NULL},
   {"uA1E2p", "k", "A", NULL, NULL},
   {"uA1E3p", "k", "A", NULL, NULL},
   {"uA1E4p", "k", "A", NULL, NULL},
   {"uA1E5p", "k", "A", NULL, NULL},
   {"uA1E6p", "k", "GT", NULL, NULL},
   {"uA1E7p", "k", "GT", NULL, NULL},
   {"uA1E8p", "k", "GT", NULL, NULL},
   {"uA1E9p", "k", "GT", NULL, NULL},
   {"uA1EAp", "k", "o", NULL, NULL},
   {"uA1EBp", "k", "o", NULL, NULL},
   {"uA1ECp", "k", "o", NULL, NULL},
   {"uA1EDp", "k", "o", NULL, NULL},
   {"uA1EEp", "k", "AMP", NULL, NULL},
   {"uA1EFp", "k", "AMP", NULL, NULL},
   {"uA1F0p", "k", "AMP", NULL, NULL},
   {"uA1F1p", "k", "AMP", NULL, NULL},
   {"uA1F2p", "k", "u", NULL, NULL},
   {"uA1F3p", "k", "u", NULL, NULL},
   {"uA1F4p", "k", "u", NULL, NULL},
   {"uA1F5p", "k", "u", NULL, NULL},
   {"uA1F6p", "k", "u", NULL, NULL},
   {"uA1F7p", "k", "u", NULL, NULL},
   {"uA1F8p", "kh", "i", NULL, NULL},
   {"uA1F9p", "kh", "i", NULL, NULL},
   {"uA1FAp", "kh", "i", NULL, NULL},
   {"uA1FBp", "kh", "i", NULL, NULL},
   {"uA1FCp", "kh", "e", NULL, NULL},
   {"uA1FDp", "kh", "e", NULL, NULL},
   {"uA1FEp", "kh", "e", NULL, NULL},
   {"uA1FFp", "kh", "A", NULL, NULL},
   {"uA200p", "kh", "A", NULL, NULL},
   {"uA201p", "kh", "A", NULL, NULL},
   {"uA202p", "kh", "A", NULL, NULL},
   {"uA203p", "kh", "GT", NULL, NULL},
   {"uA204p", "kh", "GT", NULL, NULL},
   {"uA205p", "kh", "GT", NULL, NULL},
   {"uA206p", "kh", "o", NULL, NULL},
   {"uA207p", "kh", "o", NULL, NULL},
   {"uA208p", "kh", "o", NULL, NULL},
   {"uA209p", "kh", "o", NULL, NULL},
   {"uA20Ap", "kh", "AMP", NULL, NULL},
   {"uA20Bp", "kh", "AMP", NULL, NULL},
   {"uA20Cp", "kh", "AMP", NULL, NULL},
   {"uA20Dp", "kh", "AMP", NULL, NULL},
   {"uA20Ep", "kh", "u", NULL, NULL},
   {"uA20Fp", "kh", "u", NULL, NULL},
   {"uA210p", "kh", "u", NULL, NULL},
   {"uA211p", "kh", "u", NULL, NULL},
   {"uA212p", "kh", "u", NULL, NULL},
   {"uA213p", "kh", "u", NULL, NULL},
   {"uA214p", "g", "i", NULL, NULL},
   {"uA215p", "g", "i", NULL, NULL},
   {"uA216p", "g", "i", NULL, NULL},
   {"uA217p", "g", "e", NULL, NULL},
   {"uA218p", "g", "e", NULL, NULL},
   {"uA219p", "g", "e", NULL, NULL},
   {"uA21Ap", "g", "A", NULL, NULL},
   {"uA21Bp", "g", "A", NULL, NULL},
   {"uA21Cp", "g", "A", NULL, NULL},
   {"uA21Dp", "g", "A", NULL, NULL},
   {"uA21Ep", "g", "GT", NULL, NULL},
   {"uA21Fp", "g", "GT", NULL, NULL},
   {"uA220p", "g", "GT", NULL, NULL},
   {"uA221p", "g", "GT", NULL, NULL},
   {"uA222p", "g", "o", NULL, NULL},
   {"uA223p", "g", "o", NULL, NULL},
   {"uA224p", "g", "o", NULL, NULL},
   {"uA225p", "g", "o", NULL, NULL},
   {"uA226p", "g", "AMP", NULL, NULL},
   {"uA227p", "g", "AMP", NULL, NULL},
   {"uA228p", "g", "AMP", NULL, NULL},
   {"uA229p", "g", "AMP", NULL, NULL},
   {"uA22Ap", "g", "u", NULL, NULL},
   {"uA22Bp", "g", "u", NULL, NULL},
   {"uA22Cp", "g", "u", NULL, NULL},
   {"uA22Dp", "g", "u", NULL, NULL},
   {"uA22Ep", "g", "u", NULL, NULL},
   {"uA22Fp", "g", "u", NULL, NULL},
   {"uA230p", "N", "g", "e", NULL},
   {"uA231p", "N", "g", "e", NULL},
   {"uA232p", "N", "g", "A", NULL},
   {"uA233p", "N", "g", "A", NULL},
   {"uA234p", "N", "g", "A", NULL},
   {"uA235p", "N", "g", "A", NULL},
   {"uA236p", "N", "g", "GT", NULL},
   {"uA237p", "N", "g", "GT", NULL},
   {"uA238p", "N", "g", "GT", NULL},
   {"uA239p", "N", "g", "o", NULL},
   {"uA23Ap", "N", "g", "o", NULL},
   {"uA23Bp", "N", "g", "o", NULL},
   {"uA23Cp", "N", "g", "o", NULL},
   {"uA23Dp", "N", "g", "AMP", NULL},
   {"uA23Ep", "N", "g", "AMP", NULL},
   {"uA23Fp", "N", "g", "AMP", NULL},
   {"uA240p", "N", "g", "u", NULL},
   {"uA241p", "N", "g", "u", NULL},
   {"uA242p", "N", "g", "u", NULL},
   {"uA243p", "N", "g", "u", NULL},
   {"uA244p", "N", "g", "u", NULL},
   {"uA245p", "N", "g", "u", NULL},
   {"uA246p", "h", "i", NULL, NULL},
   {"uA247p", "h", "i", NULL, NULL},
   {"uA248p", "h", "i", NULL, NULL},
   {"uA249p", "h", "i", NULL, NULL},
   {"uA24Ap", "h", "e", NULL, NULL},
   {"uA24Bp", "h", "e", NULL, NULL},
   {"uA24Cp", "h", "e", NULL, NULL},
   {"uA24Dp", "h", "e", NULL, NULL},
   {"uA24Ep", "h", "A", NULL, NULL},
   {"uA24Fp", "h", "A", NULL, NULL},
   {"uA250p", "h", "A", NULL, NULL},
   {"uA251p", "h", "A", NULL, NULL},
   {"uA252p", "h", "GT", NULL, NULL},
   {"uA253p", "h", "GT", NULL, NULL},
   {"uA254p", "h", "GT", NULL, NULL},
   {"uA255p", "h", "GT", NULL, NULL},
   {"uA256p", "h", "o", NULL, NULL},
   {"uA257p", "h", "o", NULL, NULL},
   {"uA258p", "h", "o", NULL, NULL},
   {"uA259p", "h", "o", NULL, NULL},
   {"uA25Ap", "h", "AMP", NULL, NULL},
   {"uA25Bp", "h", "AMP", NULL, NULL},
   {"uA25Cp", "h", "AMP", NULL, NULL},
   {"uA25Dp", "N", "e", NULL, NULL},
   {"uA25Ep", "N", "e", NULL, NULL},
   {"uA25Fp", "N", "e", NULL, NULL},
   {"uA260p", "N", "A", NULL, NULL},
   {"uA261p", "N", "A", NULL, NULL},
   {"uA262p", "N", "A", NULL, NULL},
   {"uA263p", "N", "A", NULL, NULL},
   {"uA264p", "N", "GT", NULL, NULL},
   {"uA265p", "N", "GT", NULL, NULL},
   {"uA266p", "N", "GT", NULL, NULL},
   {"uA267p", "N", "o", NULL, NULL},
   {"uA268p", "N", "o", NULL, NULL},
   {"uA269p", "N", "o", NULL, NULL},
   {"uA26Ap", "N", "o", NULL, NULL},
   {"uA26Bp", "N", "AMP", NULL, NULL},
   {"uA26Cp", "N", "AMP", NULL, NULL},
   {"uA26Dp", "N", "AMP", NULL, NULL},
   {"uA26Ep", "x", "i", NULL, NULL},
   {"uA26Fp", "X", "e", NULL, NULL},
   {"uA270p", "x", "e", NULL, NULL},
   {"uA271p", "x", "A", NULL, NULL},
   {"uA272p", "x", "A", NULL, NULL},
   {"uA273p", "x", "A", NULL, NULL},
   {"uA274p", "x", "A", NULL, NULL},
   {"uA275p", "x", "GT", NULL, NULL},
   {"uA276p", "x", "GT", NULL, NULL},
   {"uA277p", "x", "GT", NULL, NULL},
   {"uA278p", "x", "GT", NULL, NULL},
   {"uA279p", "x", "o", NULL, NULL},
   {"uA27Ap", "x", "o", NULL, NULL},
   {"uA27Bp", "x", "o", NULL, NULL},
   {"uA27Cp", "x", "o", NULL, NULL},
   {"uA27Dp", "x", "AMP", NULL, NULL},
   {"uA27Ep", "x", "AMP", NULL, NULL},
   {"uA27Fp", "x", "AMP", NULL, NULL},
   {"uA280p", "G", "A", NULL, NULL},
   {"uA281p", "G", "A", NULL, NULL},
   {"uA282p", "G", "A", NULL, NULL},
   {"uA283p", "G", "A", NULL, NULL},
   {"uA284p", "G", "GT", NULL, NULL},
   {"uA285p", "G", "GT", NULL, NULL},
   {"uA286p", "G", "GT", NULL, NULL},
   {"uA287p", "G", "o", NULL, NULL},
   {"uA288p", "G", "o", NULL, NULL},
   {"uA289p", "G", "o", NULL, NULL},
   {"uA28Ap", "G", "AMP", NULL, NULL},
   {"uA28Bp", "G", "AMP", NULL, NULL},
   {"uA28Cp", "G", "AMP", NULL, NULL},
   {"uA28Dp", "ts", "i", NULL, NULL},
   {"uA28Ep", "ts", "i", NULL, NULL},
   {"uA28Fp", "ts", "i", NULL, NULL},
   {"uA290p", "ts", "i", NULL, NULL},
   {"uA291p", "ts", "e", NULL, NULL},
   {"uA292p", "ts", "e", NULL, NULL},
   {"uA293p", "ts", "e", NULL, NULL},
   {"uA294p", "ts", "A", NULL, NULL},
   {"uA295p", "ts", "A", NULL, NULL},
   {"uA296p", "ts", "A", NULL, NULL},
   {"uA297p", "ts", "A", NULL, NULL},
   {"uA298p", "ts", "GT", NULL, NULL},
   {"uA299p", "ts", "GT", NULL, NULL},
   {"uA29Ap", "ts", "GT", NULL, NULL},
   {"uA29Bp", "ts", "o", NULL, NULL},
   {"uA29Cp", "ts", "o", NULL, NULL},
   {"uA29Dp", "ts", "o", NULL, NULL},
   {"uA29Ep", "ts", "o", NULL, NULL},
   {"uA29Fp", "ts", "AMP", NULL, NULL},
   {"uA2A0p", "ts", "AMP", NULL, NULL},
   {"uA2A1p", "ts", "AMP", NULL, NULL},
   {"uA2A2p", "ts", "u", NULL, NULL},
   {"uA2A3p", "ts", "u", NULL, NULL},
   {"uA2A4p", "ts", "u", NULL, NULL},
   {"uA2A5p", "ts", "u", NULL, NULL},
   {"uA2A6p", "ts", "u", NULL, NULL},
   {"uA2A7p", "ts", "u", NULL, NULL},
   {"uA2A8p", "ts", "l", NULL, NULL},
   {"uA2A9p", "ts", "l", NULL, NULL},
   {"uA2AAp", "ts", "l", NULL, NULL},
   {"uA2ABp", "ts", "l", NULL, NULL},
   {"uA2ACp", "ts", "i", NULL, NULL},
   {"uA2ADp", "ts", "i", NULL, NULL},
   {"uA2AEp", "tsh", "i", NULL, NULL},
   {"uA2AFp", "tsh", "i", NULL, NULL},
   {"uA2B0p", "tsh", "i", NULL, NULL},
   {"uA2B1p", "tsh", "i", NULL, NULL},
   {"uA2B2p", "tsh", "e", NULL, NULL},
   {"uA2B3p", "tsh", "e", NULL, NULL},
   {"uA2B4p", "tsh", "e", NULL, NULL},
   {"uA2B5p", "tsh", "e", NULL, NULL},
   {"uA2B6p", "tsh", "A", NULL, NULL},
   {"uA2B7p", "tsh", "A", NULL, NULL},
   {"uA2B8p", "tsh", "A", NULL, NULL},
   {"uA2B9p", "tsh", "A", NULL, NULL},
   {"uA2BAp", "tsh", "GT", NULL, NULL},
   {"uA2BBp", "tsh", "GT", NULL, NULL},
   {"uA2BCp", "tsh", "GT", NULL, NULL},
   {"uA2BDp", "tsh", "o", NULL, NULL},
   {"uA2BEp", "tsh", "o", NULL, NULL},
   {"uA2BFp", "tsh", "o", NULL, NULL},
   {"uA2C0p", "tsh", "o", NULL, NULL},
   {"uA2C1p", "tsh", "AMP", NULL, NULL},
   {"uA2C2p", "tsh", "AMP", NULL, NULL},
   {"uA2C3p", "tsh", "AMP", NULL, NULL},
   {"uA2C4p", "tsh", "u", NULL, NULL},
   {"uA2C5p", "tsh", "u", NULL, NULL},
   {"uA2C6p", "tsh", "u", NULL, NULL},
   {"uA2C7p", "tsh", "u", NULL, NULL},
   {"uA2C8p", "tsh", "u", NULL, NULL},
   {"uA2C9p", "tsh", "u", NULL, NULL},
   {"uA2CAp", "tsh", "l", NULL, NULL},
   {"uA2CBp", "tsh", "l", NULL, NULL},
   {"uA2CCp", "tsh", "l", NULL, NULL},
   {"uA2CDp", "tsh", "l", NULL, NULL},
   {"uA2CEp", "tsh", "i", NULL, NULL},
   {"uA2CFp", "tsh", "i", NULL, NULL},
   {"uA2D0p", "dz", "i", NULL, NULL},
   {"uA2D1p", "dz", "i", NULL, NULL},
   {"uA2D2p", "dz", "i", NULL, NULL},
   {"uA2D3p", "dz", "i", NULL, NULL},
   {"uA2D4p", "dz", "e", NULL, NULL},
   {"uA2D5p", "dz", "e", NULL, NULL},
   {"uA2D6p", "dz", "e", NULL, NULL},
   {"uA2D7p", "dz", "e", NULL, NULL},
   {"uA2D8p", "dz", "A", NULL, NULL},
   {"uA2D9p", "dz", "A", NULL, NULL},
   {"uA2DAp", "dz", "A", NULL, NULL},
   {"uA2DBp", "dz", "A", NULL, NULL},
   {"uA2DCp", "dz", "o", NULL, NULL},
   {"uA2DDp", "dz", "o", NULL, NULL},
   {"uA2DEp", "dz", "o", NULL, NULL},
   {"uA2DFp", "dz", "AMP", NULL, NULL},
   {"uA2E0p", "dz", "AMP", NULL, NULL},
   {"uA2E1p", "dz", "AMP", NULL, NULL},
   {"uA2E2p", "dz", "u", NULL, NULL},
   {"uA2E3p", "dz", "u", NULL, NULL},
   {"uA2E4p", "dz", "u", NULL, NULL},
   {"uA2E5p", "dz", "u", NULL, NULL},
   {"uA2E6p", "dz", "u", NULL, NULL},
   {"uA2E7p", "dz", "l", NULL, NULL},
   {"uA2E8p", "dz", "l", NULL, NULL},
   {"uA2E9p", "dz", "l", NULL, NULL},
   {"uA2EAp", "dz", "l", NULL, NULL},
   {"uA2EBp", "dz", "i", NULL, NULL},
   {"uA2ECp", "dz", "i", NULL, NULL},
   {"uA2EDp", "n", "dz", "i", NULL},
   {"uA2EEp", "n", "dz", "i", NULL},
   {"uA2EFp", "n", "dz", "i", NULL},
   {"uA2F0p", "n", "dz", "i", NULL},
   {"uA2F1p", "n", "dz", "e", NULL},
   {"uA2F2p", "n", "dz", "e", NULL},
   {"uA2F3p", "n", "dz", "e", NULL},
   {"uA2F4p", "n", "dz", "A", NULL},
   {"uA2F5p", "n", "dz", "A", NULL},
   {"uA2F6p", "n", "dz", "A", NULL},
   {"uA2F7p", "n", "dz", "A", NULL},
   {"uA2F8p", "n", "dz", "GT", NULL},
   {"uA2F9p", "n", "dz", "GT", NULL},
   {"uA2FAp", "n", "dz", "o", NULL},
   {"uA2FBp", "n", "dz", "o", NULL},
   {"uA2FCp", "n", "dz", "AMP", NULL},
   {"uA2FDp", "n", "dz", "AMP", NULL},
   {"uA2FEp", "n", "dz", "u", NULL},
   {"uA2FFp", "n", "dz", "u", NULL},
   {"uA300p", "n", "dz", "u", NULL},
   {"uA301p", "n", "dz", "u", NULL},
   {"uA302p", "n", "dz", "u", NULL},
   {"uA303p", "n", "dz", "l", NULL},
   {"uA304p", "n", "dz", "l", NULL},
   {"uA305p", "n", "dz", "l", NULL},
   {"uA306p", "n", "dz", "l", NULL},
   {"uA307p", "n", "dz", "i", NULL},
   {"uA308p", "n", "dz", "i", NULL},
   {"uA309p", "s", "i", NULL, NULL},
   {"uA30Ap", "s", "i", NULL, NULL},
   {"uA30Bp", "s", "i", NULL, NULL},
   {"uA30Cp", "s", "i", NULL, NULL},
   {"uA30Dp", "s", "e", NULL, NULL},
   {"uA30Ep", "s", "e", NULL, NULL},
   {"uA30Fp", "s", "e", NULL, NULL},
   {"uA310p", "s", "A", NULL, NULL},
   {"uA311p", "s", "A", NULL, NULL},
   {"uA312p", "s", "A", NULL, NULL},
   {"uA313p", "s", "A", NULL, NULL},
   {"uA314p", "s", "GT", NULL, NULL},
   {"uA315p", "s", "GT", NULL, NULL},
   {"uA316p", "s", "GT", NULL, NULL},
   {"uA317p", "s", "o", NULL, NULL},
   {"uA318p", "s", "o", NULL, NULL},
   {"uA319p", "s", "o", NULL, NULL},
   {"uA31Ap", "s", "o", NULL, NULL},
   {"uA31Bp", "s", "AMP", NULL, NULL},
   {"uA31Cp", "s", "AMP", NULL, NULL},
   {"uA31Dp", "s", "AMP", NULL, NULL},
   {"uA31Ep", "s", "u", NULL, NULL},
   {"uA31Fp", "s", "u", NULL, NULL},
   {"uA320p", "s", "u", NULL, NULL},
   {"uA321p", "s", "u", NULL, NULL},
   {"uA322p", "s", "u", NULL, NULL},
   {"uA323p", "s", "u", NULL, NULL},
   {"uA324p", "s", "l", NULL, NULL},
   {"uA325p", "s", "l", NULL, NULL},
   {"uA326p", "s", "l", NULL, NULL},
   {"uA327p", "s", "l", NULL, NULL},
   {"uA328p", "s", "i", NULL, NULL},
   {"uA329p", "s", "i", NULL, NULL},
   {"uA32Ap", "z", "i", NULL, NULL},
   {"uA32Bp", "z", "i", NULL, NULL},
   {"uA32Cp", "z", "i", NULL, NULL},
   {"uA32Dp", "z", "i", NULL, NULL},
   {"uA32Ep", "z", "e", NULL, NULL},
   {"uA32Fp", "z", "e", NULL, NULL},
   {"uA330p", "z", "e", NULL, NULL},
   {"uA331p", "z", "A", NULL, NULL},
   {"uA332p", "z", "A", NULL, NULL},
   {"uA333p", "z", "A", NULL, NULL},
   {"uA334p", "z", "A", NULL, NULL},
   {"uA335p", "z", "o", NULL, NULL},
   {"uA336p", "z", "o", NULL, NULL},
   {"uA337p", "z", "o", NULL, NULL},
   {"uA338p", "z", "o", NULL, NULL},
   {"uA339p", "z", "AMP", NULL, NULL},
   {"uA33Ap", "z", "AMP", NULL, NULL},
   {"uA33Bp", "z", "AMP", NULL, NULL},
   {"uA33Cp", "z", "u", NULL, NULL},
   {"uA33Dp", "z", "u", NULL, NULL},
   {"uA33Ep", "z", "u", NULL, NULL},
   {"uA33Fp", "z", "u", NULL, NULL},
   {"uA340p", "z", "l", NULL, NULL},
   {"uA341p", "z", "l", NULL, NULL},
   {"uA342p", "z", "l", NULL, NULL},
   {"uA343p", "z", "l", NULL, NULL},
   {"uA344p", "z", "i", NULL, NULL},
   {"uA345p", "z", "i", NULL, NULL},
   {"uA346p", "tsr", "A", NULL, NULL},
   {"uA347p", "tsr", "A", NULL, NULL},
   {"uA348p", "tsr", "A", NULL, NULL},
   {"uA349p", "tsr", "A", NULL, NULL},
   {"uA34Ap", "tsr", "GT", NULL, NULL},
   {"uA34Bp", "tsr", "GT", NULL, NULL},
   {"uA34Cp", "tsr", "GT", NULL, NULL},
   {"uA34Dp", "tsr", "o", NULL, NULL},
   {"uA34Ep", "tsr", "o", NULL, NULL},
   {"uA34Fp", "tsr", "o", NULL, NULL},
   {"uA350p", "tsr", "o", NULL, NULL},
   {"uA351p", "tsr", "AMP", NULL, NULL},
   {"uA352p", "tsr", "AMP", NULL, NULL},
   {"uA353p", "tsr", "AMP", NULL, NULL},
   {"uA354p", "tsr", "AMP", NULL, NULL},
   {"uA355p", "tsr", "u", NULL, NULL},
   {"uA356p", "tsr", "u", NULL, NULL},
   {"uA357p", "tsr", "u", NULL, NULL},
   {"uA358p", "tsr", "u", NULL, NULL},
   {"uA359p", "tsr", "u", NULL, NULL},
   {"uA35Ap", "tsr", "u", NULL, NULL},
   {"uA35Bp", "tsr", "l", NULL, NULL},
   {"uA35Cp", "tsr", "l", NULL, NULL},
   {"uA35Dp", "tsr", "l", NULL, NULL},
   {"uA35Ep", "tsr", "l", NULL, NULL},
   {"uA35Fp", "tsr", "i", NULL, NULL},
   {"uA360p", "tsr", "i", NULL, NULL},
   {"uA361p", "tsrh", "A", NULL, NULL},
   {"uA362p", "tsrh", "A", NULL, NULL},
   {"uA363p", "tsrh", "A", NULL, NULL},
   {"uA364p", "tsrh", "A", NULL, NULL},
   {"uA365p", "tsrh", "GT", NULL, NULL},
   {"uA366p", "tsrh", "GT", NULL, NULL},
   {"uA367p", "tsrh", "GT", NULL, NULL},
   {"uA368p", "tsrh", "GT", NULL, NULL},
   {"uA369p", "tsrh", "o", NULL, NULL},
   {"uA36Ap", "tsrh", "o", NULL, NULL},
   {"uA36Bp", "tsrh", "o", NULL, NULL},
   {"uA36Cp", "tsrh", "o", NULL, NULL},
   {"uA36Dp", "tsrh", "AMP", NULL, NULL},
   {"uA36Ep", "tsrh", "AMP", NULL, NULL},
   {"uA36Fp", "tsrh", "AMP", NULL, NULL},
   {"uA370p", "tsrh", "AMP", NULL, NULL},
   {"uA371p", "tsrh", "u", NULL, NULL},
   {"uA372p", "tsrh", "u", NULL, NULL},
   {"uA373p", "tsrh", "u", NULL, NULL},
   {"uA374p", "tsrh", "u", NULL, NULL},
   {"uA375p", "tsrh", "u", NULL, NULL},
   {"uA376p", "tsrh", "l", NULL, NULL},
   {"uA377p", "tsrh", "l", NULL, NULL},
   {"uA378p", "tsrh", "l", NULL, NULL},
   {"uA379p", "tsrh", "l", NULL, NULL},
   {"uA37Ap", "tsrh", "i", NULL, NULL},
   {"uA37Bp", "tsrh", "i", NULL, NULL},
   {"uA37Cp", "dzr", "A", NULL, NULL},
   {"uA37Dp", "dzr", "A", NULL, NULL},
   {"uA37Ep", "dzr", "GT", NULL, NULL},
   {"uA37Fp", "dzr", "GT", NULL, NULL},
   {"uA380p", "dzr", "o", NULL, NULL},
   {"uA381p", "dzr", "o", NULL, NULL},
   {"uA382p", "dzr", "o", NULL, NULL},
   {"uA383p", "dzr", "o", NULL, NULL},
   {"uA384p", "dzr", "AMP", NULL, NULL},
   {"uA385p", "dzr", "AMP", NULL, NULL},
   {"uA386p", "dzr", "AMP", NULL, NULL},
   {"uA387p", "dzr", "AMP", NULL, NULL},
   {"uA388p", "dzr", "u", NULL, NULL},
   {"uA389p", "dzr", "u", NULL, NULL},
   {"uA38Ap", "dzr", "u", NULL, NULL},
   {"uA38Bp", "dzr", "u", NULL, NULL},
   {"uA38Cp", "dzr", "u", NULL, NULL},
   {"uA38Dp", "dzr", "u", NULL, NULL},
   {"uA38Ep", "dzr", "l", NULL, NULL},
   {"uA38Fp", "dzr", "l", NULL, NULL},
   {"uA390p", "dzr", "l", NULL, NULL},
   {"uA391p", "dzr", "l", NULL, NULL},
   {"uA392p", "dzr", "i", NULL, NULL},
   {"uA393p", "dzr", "i", NULL, NULL},
   {"uA394p", "n", "dzr", "A", NULL},
   {"uA395p", "n", "dzr", "A", NULL},
   {"uA396p", "n", "dzr", "A", NULL},
   {"uA397p", "n", "dzr", "A", NULL},
   {"uA398p", "n", "dzr", "o", NULL},
   {"uA399p", "n", "dzr", "o", NULL},
   {"uA39Ap", "n", "dzr", "o", NULL},
   {"uA39Bp", "n", "dzr", "AMP", NULL},
   {"uA39Cp", "n", "dzr", "AMP", NULL},
   {"uA39Dp", "n", "dzr", "AMP", NULL},
   {"uA39Ep", "n", "dzr", "AMP", NULL},
   {"uA39Fp", "n", "dzr", "u", NULL},
   {"uA3A0p", "n", "dzr", "u", NULL},
   {"uA3A1p", "n", "dzr", "u", NULL},
   {"uA3A2p", "n", "dzr", "u", NULL},
   {"uA3A3p", "n", "dzr", "u", NULL},
   {"uA3A4p", "n", "dzr", "u", NULL},
   {"uA3A5p", "n", "dzr", "l", NULL},
   {"uA3A6p", "n", "dzr", "l", NULL},
   {"uA3A7p", "n", "dzr", "l", NULL},
   {"uA3A8p", "n", "dzr", "l", NULL},
   {"uA3A9p", "n", "dzr", "i", NULL},
   {"uA3AAp", "n", "dzr", "i", NULL},
   {"uA3ABp", "sr", "A", NULL, NULL},
   {"uA3ACp", "sr", "A", NULL, NULL},
   {"uA3ADp", "sr", "A", NULL, NULL},
   {"uA3AEp", "sr", "A", NULL, NULL},
   {"uA3AFp", "sr", "GT", NULL, NULL},
   {"uA3B0p", "sr", "GT", NULL, NULL},
   {"uA3B1p", "sr", "GT", NULL, NULL},
   {"uA3B2p", "sr", "o", NULL, NULL},
   {"uA3B3p", "sr", "o", NULL, NULL},
   {"uA3B4p", "sr", "o", NULL, NULL},
   {"uA3B5p", "sr", "o", NULL, NULL},
   {"uA3B6p", "sr", "AMP", NULL, NULL},
   {"uA3B7p", "sr", "AMP", NULL, NULL},
   {"uA3B8p", "sr", "AMP", NULL, NULL},
   {"uA3B9p", "sr", "AMP", NULL, NULL},
   {"uA3BAp", "sr", "u", NULL, NULL},
   {"uA3BBp", "sr", "u", NULL, NULL},
   {"uA3BCp", "sr", "u", NULL, NULL},
   {"uA3BDp", "sr", "u", NULL, NULL},
   {"uA3BEp", "sr", "u", NULL, NULL},
   {"uA3BFp", "sr", "u", NULL, NULL},
   {"uA3C0p", "sr", "l", NULL, NULL},
   {"uA3C1p", "sr", "l", NULL, NULL},
   {"uA3C2p", "sr", "l", NULL, NULL},
   {"uA3C3p", "sr", "l", NULL, NULL},
   {"uA3C4p", "sr", "i", NULL, NULL},
   {"uA3C5p", "sr", "i", NULL, NULL},
   {"uA3C6p", "zr", "A", NULL, NULL},
   {"uA3C7p", "zr", "A", NULL, NULL},
   {"uA3C8p", "zr", "A", NULL, NULL},
   {"uA3C9p", "zr", "A", NULL, NULL},
   {"uA3CAp", "zr", "GT", NULL, NULL},
   {"uA3CBp", "zr", "GT", NULL, NULL},
   {"uA3CCp", "zr", "GT", NULL, NULL},
   {"uA3CDp", "zr", "o", NULL, NULL},
   {"uA3CEp", "zr", "o", NULL, NULL},
   {"uA3CFp", "zr", "o", NULL, NULL},
   {"uA3D0p", "zr", "o", NULL, NULL},
   {"uA3D1p", "zr", "AMP", NULL, NULL},
   {"uA3D2p", "zr", "AMP", NULL, NULL},
   {"uA3D3p", "zr", "AMP", NULL, NULL},
   {"uA3D4p", "zr", "u", NULL, NULL},
   {"uA3D5p", "zr", "u", NULL, NULL},
   {"uA3D6p", "zr", "u", NULL, NULL},
   {"uA3D7p", "zr", "u", NULL, NULL},
   {"uA3D8p", "zr", "u", NULL, NULL},
   {"uA3D9p", "zr", "u", NULL, NULL},
   {"uA3DAp", "zr", "l", NULL, NULL},
   {"uA3DBp", "zr", "l", NULL, NULL},
   {"uA3DCp", "zr", "l", NULL, NULL},
   {"uA3DDp", "zr", "l", NULL, NULL},
   {"uA3DEp", "zr", "i", NULL, NULL},
   {"uA3DFp", "zr", "i", NULL, NULL},
   {"uA3E0p", "t", "c}", "i", NULL},
   {"uA3E1p", "t", "c}", "i", NULL},
   {"uA3E2p", "t", "c}", "i", NULL},
   {"uA3E3p", "t", "c}", "i", NULL},
   {"uA3E4p", "t", "c}", "e", NULL},
   {"uA3E5p", "t", "c}", "e", NULL},
   {"uA3E6p", "t", "c}", "e", NULL},
   {"uA3E7p", "t", "c}", "e", NULL},
   {"uA3E8p", "t", "c}", "GT", NULL},
   {"uA3E9p", "t", "c}", "GT", NULL},
   {"uA3EAp", "t", "c}", "GT", NULL},
   {"uA3EBp", "t", "c}", "GT", NULL},
   {"uA3ECp", "t", "c}", "o", NULL},
   {"uA3EDp", "t", "c}", "o", NULL},
   {"uA3EEp", "t", "c}", "o", NULL},
   {"uA3EFp", "t", "c}", "o", NULL},
   {"uA3F0p", "t", "c}", "u", NULL},
   {"uA3F1p", "t", "c}", "u", NULL},
   {"uA3F2p", "t", "c}", "u", NULL},
   {"uA3F3p", "t", "c}", "u", NULL},
   {"uA3F4p", "t", "c}", "u", NULL},
   {"uA3F5p", "t", "c}", "u", NULL},
   {"uA3F6p", "t", "c}", "l", NULL},
   {"uA3F7p", "t", "c}", "l", NULL},
   {"uA3F8p", "t", "c}", "l", NULL},
   {"uA3F9p", "t", "c}", "l", NULL},
   {"uA3FAp", "t", "c}", "i", NULL},
   {"uA3FBp", "t", "c}", "i", NULL},
   {"uA3FCp", "t", "c}h", "i", NULL},
   {"uA3FDp", "t", "c}h", "i", NULL},
   {"uA3FEp", "t", "c}h", "i", NULL},
   {"uA3FFp", "t", "c}h", "i", NULL},
   {"uA400p", "t", "c}h", "e", NULL},
   {"uA401p", "t", "c}h", "e", NULL},
   {"uA402p", "t", "c}h", "e", NULL},
   {"uA403p", "t", "c}h", "e", NULL},
   {"uA404p", "t", "c}h", "GT", NULL},
   {"uA405p", "t", "c}h", "GT", NULL},
   {"uA406p", "t", "c}h", "GT", NULL},
   {"uA407p", "t", "c}h", "GT", NULL},
   {"uA408p", "t", "c}h", "o", NULL},
   {"uA409p", "t", "c}h", "o", NULL},
   {"uA40Ap", "t", "c}h", "o", NULL},
   {"uA40Bp", "t", "c}h", "o", NULL},
   {"uA40Cp", "t", "c}h", "u", NULL},
   {"uA40Dp", "t", "c}h", "u", NULL},
   {"uA40Ep", "t", "c}h", "u", NULL},
   {"uA40Fp", "t", "c}h", "u", NULL},
   {"uA410p", "t", "c}h", "u", NULL},
   {"uA411p", "t", "c}h", "u", NULL},
   {"uA412p", "t", "c}h", "l", NULL},
   {"uA413p", "t", "c}h", "l", NULL},
   {"uA414p", "t", "c}h", "l", NULL},
   {"uA415p", "t", "c}h", "l", NULL},
   {"uA416p", "t", "c}h", "i", NULL},
   {"uA417p", "t", "c}h", "i", NULL},
   {"uA418p", "d", "z}", "i", NULL},
   {"uA419p", "d", "z}", "i", NULL},
   {"uA41Ap", "d", "z}", "i", NULL},
   {"uA41Bp", "d", "z}", "i", NULL},
   {"uA41Cp", "d", "z}", "e", NULL},
   {"uA41Dp", "d", "z}", "e", NULL},
   {"uA41Ep", "d", "z}", "e", NULL},
   {"uA41Fp", "d", "z}", "e", NULL},
   {"uA420p", "d", "z}", "GT", NULL},
   {"uA421p", "d", "z}", "GT", NULL},
   {"uA422p", "d", "z}", "GT", NULL},
   {"uA423p", "d", "z}", "o", NULL},
   {"uA424p", "d", "z}", "o", NULL},
   {"uA425p", "d", "z}", "o", NULL},
   {"uA426p", "d", "z}", "o", NULL},
   {"uA427p", "d", "z}", "u", NULL},
   {"uA428p", "d", "z}", "u", NULL},
   {"uA429p", "d", "z}", "u", NULL},
   {"uA42Ap", "d", "z}", "u", NULL},
   {"uA42Bp", "d", "z}", "u", NULL},
   {"uA42Cp", "d", "z}", "u", NULL},
   {"uA42Dp", "d", "z}", "l", NULL},
   {"uA42Ep", "d", "z}", "l", NULL},
   {"uA42Fp", "d", "z}", "l", NULL},
   {"uA430p", "d", "z}", "l", NULL},
   {"uA431p", "n", "d", "z}", NULL},
   {"uA432p", "n", "d", "z}", NULL},
   {"uA433p", "n", "d", "z}", NULL},
   {"uA434p", "n", "d", "z}", NULL},
   {"uA435p", "n", "d", "z}", NULL},
   {"uA436p", "n", "d", "z}", NULL},
   {"uA437p", "n", "d", "z}", NULL},
   {"uA438p", "n", "d", "z}", NULL},
   {"uA439p", "n", "d", "z}", NULL},
   {"uA43Ap", "n", "d", "z}", NULL},
   {"uA43Bp", "n", "d", "z}", NULL},
   {"uA43Cp", "n", "d", "z}", NULL},
   {"uA43Dp", "n", "d", "z}", NULL},
   {"uA43Ep", "n", "d", "z}", NULL},
   {"uA43Fp", "n", "d", "z}", NULL},
   {"uA440p", "n", "d", "z}", NULL},
   {"uA441p", "n", "d", "z}", NULL},
   {"uA442p", "n", "d", "z}", NULL},
   {"uA443p", "n", "d", "z}", NULL},
   {"uA444p", "n", "d", "z}", NULL},
   {"uA445p", "n", "d", "z}", NULL},
   {"uA446p", "n", "d", "z}", NULL},
   {"uA447p", "n", "d", "z}", NULL},
   {"uA448p", "n", "d", "z}", NULL},
   {"uA449p", "n", "d", "z}", NULL},
   {"uA44Ap", "nr", "i", NULL, NULL},
   {"uA44Bp", "nr", "i", NULL, NULL},
   {"uA44Cp", "nr", "i", NULL, NULL},
   {"uA44Dp", "nr", "i", NULL, NULL},
   {"uA44Ep", "nr", "e", NULL, NULL},
   {"uA44Fp", "nr", "e", NULL, NULL},
   {"uA450p", "nr", "e", NULL, NULL},
   {"uA451p", "nr", "e", NULL, NULL},
   {"uA452p", "nr", "GT", NULL, NULL},
   {"uA453p", "nr", "GT", NULL, NULL},
   {"uA454p", "nr", "GT", NULL, NULL},
   {"uA455p", "nr", "o", NULL, NULL},
   {"uA456p", "nr", "o", NULL, NULL},
   {"uA457p", "nr", "o", NULL, NULL},
   {"uA458p", "nr", "o", NULL, NULL},
   {"uA459p", "nr", "u", NULL, NULL},
   {"uA45Ap", "nr", "u", NULL, NULL},
   {"uA45Bp", "nr", "u", NULL, NULL},
   {"uA45Cp", "nr", "u", NULL, NULL},
   {"uA45Dp", "c}", "i", NULL, NULL},
   {"uA45Ep", "c}", "i", NULL, NULL},
   {"uA45Fp", "c}", "i", NULL, NULL},
   {"uA460p", "c}", "i", NULL, NULL},
   {"uA461p", "c}", "e", NULL, NULL},
   {"uA462p", "c}", "e", NULL, NULL},
   {"uA463p", "c}", "e", NULL, NULL},
   {"uA464p", "c}", "e", NULL, NULL},
   {"uA465p", "c}", "GT", NULL, NULL},
   {"uA466p", "c}", "GT", NULL, NULL},
   {"uA467p", "c}", "o", NULL, NULL},
   {"uA468p", "c}", "o", NULL, NULL},
   {"uA469p", "c}", "o", NULL, NULL},
   {"uA46Ap", "c}", "o", NULL, NULL},
   {"uA46Bp", "c}", "l", NULL, NULL},
   {"uA46Cp", "c}", "l", NULL, NULL},
   {"uA46Dp", "c}", "l", NULL, NULL},
   {"uA46Ep", "c}", "l", NULL, NULL},
   {"uA46Fp", "c}", "i", NULL, NULL},
   {"uA470p", "c}", "i", NULL, NULL},
   {"uA471p", "z}", "i", NULL, NULL},
   {"uA472p", "z}", "i", NULL, NULL},
   {"uA473p", "z}", "i", NULL, NULL},
   {"uA474p", "z}", "i", NULL, NULL},
   {"uA475p", "z}", "e", NULL, NULL},
   {"uA476p", "z}", "e", NULL, NULL},
   {"uA477p", "z}", "e", NULL, NULL},
   {"uA478p", "z}", "e", NULL, NULL},
   {"uA479p", "z}", "GT", NULL, NULL},
   {"uA47Ap", "z}", "GT", NULL, NULL},
   {"uA47Bp", "z}", "GT", NULL, NULL},
   {"uA47Cp", "z}", "GT", NULL, NULL},
   {"uA47Dp", "z}", "o", NULL, NULL},
   {"uA47Ep", "z}", "o", NULL, NULL},
   {"uA47Fp", "z}", "o", NULL, NULL},
   {"uA480p", "z}", "o", NULL, NULL},
   {"uA481p", "z}", "u", NULL, NULL},
   {"uA482p", "z}", "u", NULL, NULL},
   {"uA483p", "z}", "u", NULL, NULL},
   {"uA484p", "z}", "u", NULL, NULL},
   {"uA485p", "z}", "u", NULL, NULL},
   {"uA486p", "z}", "u", NULL, NULL},
   {"uA487p", "z}", "l", NULL, NULL},
   {"uA488p", "z}", "l", NULL, NULL},
   {"uA489p", "z}", "l", NULL, NULL},
   {"uA48Ap", "z}", "l", NULL, NULL},
   {"uA48Bp", "z}", "i", NULL, NULL},
   {"uA48Cp", "z}", "i", NULL, NULL},
   {"uA490p", "t", "c}h", "o", NULL},
   {"uA491p", "l", "i", NULL, NULL},
   {"uA492p", "kh", "i", NULL, NULL},
   {"uA493p", "nr", "i", NULL, NULL},
   {"uA494p", "tsh", "l", NULL, NULL},
   {"uA495p", "z", "i", NULL, NULL},
   {"uA496p", "g", "o", NULL, NULL},
   {"uA497p", "k", "e", NULL, NULL},
   {"uA498p", "m", "i", NULL, NULL},
   {"uA499p", "h", "i", NULL, NULL},
   {"uA49Ap", "l", "l", NULL, NULL},
   {"uA49Bp", "b", "u", NULL, NULL},
   {"uA49Cp", "m", "o", NULL, NULL},
   {"uA49Dp", "z}", "o", NULL, NULL},
   {"uA49Ep", "ph", "u", NULL, NULL},
   {"uA49Fp", "h", "GT", NULL, NULL},
   {"uA4A0p", "th", "A", NULL, NULL},
   {"uA4A1p", "k", "A", NULL, NULL},
   {"uA4A2p", "ts", "u", NULL, NULL},
   {"uA4A3p", "tsh", "l", NULL, NULL},
   {"uA4A4p", "d", "u", NULL, NULL},
   {"uA4A5p", "p", "u", NULL, NULL},
   {"uA4A6p", "g", "u", NULL, NULL},
   {"uA4A7p", "nr", "o", NULL, NULL},
   {"uA4A8p", "th", "u", NULL, NULL},
   {"uA4A9p", "o", NULL, NULL, NULL},
   {"uA4AAp", "d", "z}", "u", NULL},
   {"uA4ABp", "ts", "o", NULL, NULL},
   {"uA4ACp", "p", "l", NULL, NULL},
   {"uA4ADp", "m0", "o", NULL, NULL},
   {"uA4AEp", "z}", "i", NULL, NULL},
   {"uA4AFp", "v", "u", NULL, NULL},
   {"uA4B0p", "sr", "l", NULL, NULL},
   {"uA4B1p", "v", "e", NULL, NULL},
   {"uA4B2p", "ts", "A", NULL, NULL},
   {"uA4B3p", "t", "c}", "o", NULL},
   {"uA4B4p", "n", "dz", "u", NULL},
   {"uA4B5p", "d", "z}", "l", NULL},
   {"uA4B6p", "k", "o", NULL, NULL},
   {"uA4B7p", "d", "z}", "e", NULL},
   {"uA4B8p", "G", "o", NULL, NULL},
   {"uA4B9p", "t", "u", NULL, NULL},
   {"uA4BAp", "sr", "u", NULL, NULL},
   {"uA4BBp", "l", "e", NULL, NULL},
   {"uA4BCp", "tsh", "l", NULL, NULL},
   {"uA4BDp", "tsh", "GT", NULL, NULL},
   {"uA4BEp", "tsh", "i", NULL, NULL},
   {"uA4BFp", "h", "o", NULL, NULL},
   {"uA4C0p", "sr", "A", NULL, NULL},
   {"uA4C1p", "ts", "u", NULL, NULL},
   {"uA4C2p", "sr", "o", NULL, NULL},
   {"uA4C3p", "tsrh", "e", NULL, NULL},
   {"uA4C4p", "dz", "e", NULL, NULL},
   {"uA4C5p", "m", "b", "e", NULL},
   {"uA4C6p", "kh", "e", NULL, NULL},
   { NULL, NULL, NULL, NULL }
};

