extern "C" {
#include "jit.common.h"
}

#include <math.h>
//#include <stdio.h>
//#include <string.h>

//using namespace std;

typedef struct _slitz_exp 
{
	t_object				ob;

	t_symbol *file;
	} t_slitz_exp;

void *_slitz_exp_class;

t_slitz_exp *slitz_exp_new(void);
void slitz_exp_free(t_slitz_exp *x);
t_jit_err slitz_exp_matrix_calc(t_slitz_exp *x, void *inputs, void *outputs);


t_jit_err slitz_exp_init(void) 
{
	long attrflags=0;
	t_jit_object *attr, *mop;
	
	_slitz_exp_class = jit_class_new("slitz.exp",(method)slitz_exp_new,(method)slitz_exp_free,
		sizeof(t_slitz_exp),A_CANT,0L); //A_CANT = untyped

	//add mop
	mop = (t_jit_object *)jit_object_new(_jit_sym_jit_mop,1,0);
	jit_mop_single_type(mop,_jit_sym_float32);	

	jit_class_addadornment(_slitz_exp_class,mop);

	//add methods
	jit_class_addmethod(_slitz_exp_class, (method)slitz_exp_matrix_calc, "matrix_calc", A_CANT, 0L);

	//add attributes	
	attrflags = JIT_ATTR_GET_DEFER_LOW | JIT_ATTR_SET_USURP_LOW;

	attr = (object *)jit_object_new(_jit_sym_jit_attr_offset,"file",_jit_sym_symbol,attrflags,(method)0L,(method)0L,calcoffset(t_slitz_exp,file));
	jit_class_addattr(_slitz_exp_class,attr);

	jit_class_register(_slitz_exp_class);

	return JIT_ERR_NONE;
}

inline void fwrite(FILE_REF fr,const char *c)
{
	long l = strlen(c);
	FSWrite(fr,&l,c);
}

static void ExpPoints(FILE_REF f,const float *mat,int points,int str0,bool tex)
{
	char tmp[256];
	for(int i = 0; i < points; ++i) {
		const float *v = mat+i*str0;
		
		sprintf(tmp,"v %f %f %f\n",v[0],v[1],v[2]);
		fwrite(f,tmp);
		if(tex) {
			sprintf(tmp,"vt %f %f\n",v[3],v[4]);
			fwrite(f,tmp);
		}
	}
}

static void ExpFaces(FILE_REF f,int fr,int points,bool tex)
{
	char tmp[256];
	for(int i = 0; i < points-1; ++i) {
		int b = 1+fr*points+i;
		if(tex)
			sprintf(tmp,"f %i/%i %i/%i %i/%i %i/%i\n",b,b,b+1,b+1,b-points+1,b-points+1,b-points,b-points);
		else
			sprintf(tmp,"f %i %i %i %i\n",b,b,b+1,b-points+1,b-points);
		fwrite(f,tmp);
	}
}


t_jit_err slitz_exp_matrix_calc(t_slitz_exp *x, void *inputs, void *outputs)
{
	t_jit_err err=JIT_ERR_NONE;
	long in_savelock;
	t_jit_matrix_info in_minfo;
	float *in_bp;
	long i;
	int ret;
	void *in_matrix;
	char tmp[256];
	
	in_matrix = jit_object_method(inputs, _jit_sym_getindex, 0);

	if(x && in_matrix) {
		
		in_savelock = (long) jit_object_method(in_matrix,_jit_sym_lock,1);
		
		jit_object_method(in_matrix,_jit_sym_getinfo,&in_minfo);
		
		jit_object_method(in_matrix,_jit_sym_getdata,&in_bp);		
		if (!in_bp) { err=JIT_ERR_INVALID_PTR; goto out;}

		// compatible types?
		if (in_minfo.type != _jit_sym_float32 || in_minfo.dimcount != 2 || (in_minfo.planecount != 3 && in_minfo.planecount != 5)) { 
			err=JIT_ERR_MISMATCH_TYPE; 
			goto out;
		}		

		int istr0 = in_minfo.dimstride[0]/sizeof(float);
		int istr1 = in_minfo.dimstride[1]/sizeof(float);
		bool tex = in_minfo.planecount == 5;

		FILE_REF fr;
//		ret = path_openfile(x->file->s_name,0,&fr,1);
		ret = path_createfile(x->file->s_name,0,0,&fr);
		if(ret) { 
			post("slitz.exp: Could not open file"); goto out; 
		}		
		else {
			fwrite(fr,"# Slitzer export\n");
			for(i = 0; i < in_minfo.dim[1]; ++i) {
				sprintf(tmp,"# Frame %i\n",i);
				fwrite(fr,tmp);

				ExpPoints(fr,in_bp+i*istr1,in_minfo.dim[0],istr0,tex);
				if(i) ExpFaces(fr,i,in_minfo.dim[0],tex);
			}			
			
			FSClose(fr);
		}
		
out:
		jit_object_method(in_matrix,_jit_sym_lock,in_savelock);
	} 
	else {
		err = JIT_ERR_INVALID_PTR;
	}
	
	return err;
}


t_slitz_exp *slitz_exp_new(void)
{
	t_slitz_exp *x;
	short i;
		
	if (x=(t_slitz_exp *)jit_object_alloc(_slitz_exp_class)) {
		x->file = gensym("");
	} else {
		x = NULL;
	}	
	return x;
}

void slitz_exp_free(t_slitz_exp *x)
{
	//nada
}

