#include <stdlib.h>
#include <stdio.h>

// lib: libgssapi_krb5.so
// SONAME: libgssapi_krb5.so.2

#define SHARED_LIB_NAME "libgssapi_krb5-stub.so"

void __attribute__ ((constructor)) _so_stub_init(void)
{
    fprintf(stderr, "%s cannot be used for process executing. Exiting... ", SHARED_LIB_NAME);
    exit(1);
}

#define _stub_code(name) void name(){}

typedef struct _stub_data_desc_struct {
    void *value;
} _stub_data_desc, *_stub_data_t;

static _stub_data_desc _stub_const = {"_stub_const"};

#define _stub_data(name) _stub_data_t  name = &_stub_const;

_stub_data(GSS_C_ATTR_LOCAL_LOGIN_USER);
_stub_data(GSS_C_INQ_NEGOEX_KEY);
_stub_data(GSS_C_INQ_NEGOEX_VERIFY_KEY);
_stub_data(GSS_C_INQ_SSPI_SESSION_KEY);
_stub_data(GSS_C_MA_AUTH_INIT);
_stub_data(GSS_C_MA_AUTH_INIT_ANON);
_stub_data(GSS_C_MA_AUTH_INIT_INIT);
_stub_data(GSS_C_MA_AUTH_TARG);
_stub_data(GSS_C_MA_AUTH_TARG_ANON);
_stub_data(GSS_C_MA_AUTH_TARG_INIT);
_stub_data(GSS_C_MA_CBINDINGS);
_stub_data(GSS_C_MA_COMPRESS);
_stub_data(GSS_C_MA_CONF_PROT);
_stub_data(GSS_C_MA_CTX_TRANS);
_stub_data(GSS_C_MA_DELEG_CRED);
_stub_data(GSS_C_MA_DEPRECATED);
_stub_data(GSS_C_MA_INTEG_PROT);
_stub_data(GSS_C_MA_ITOK_FRAMED);
_stub_data(GSS_C_MA_MECH_COMPOSITE);
_stub_data(GSS_C_MA_MECH_CONCRETE);
_stub_data(GSS_C_MA_MECH_GLUE);
_stub_data(GSS_C_MA_MECH_NEGO);
_stub_data(GSS_C_MA_MECH_PSEUDO);
_stub_data(GSS_C_MA_MIC);
_stub_data(GSS_C_MA_NEGOEX_AND_SPNEGO);
_stub_data(GSS_C_MA_NOT_DFLT_MECH);
_stub_data(GSS_C_MA_NOT_MECH);
_stub_data(GSS_C_MA_OOS_DET);
_stub_data(GSS_C_MA_PFS);
_stub_data(GSS_C_MA_PROT_READY);
_stub_data(GSS_C_MA_REPLAY_DET);
_stub_data(GSS_C_MA_WRAP);
_stub_data(GSS_C_NT_ANONYMOUS);
_stub_data(GSS_C_NT_COMPOSITE_EXPORT);
_stub_data(GSS_C_NT_EXPORT_NAME);
_stub_data(GSS_C_NT_HOSTBASED_SERVICE);
_stub_data(GSS_C_NT_HOSTBASED_SERVICE_X);
_stub_data(GSS_C_NT_MACHINE_UID_NAME);
_stub_data(GSS_C_NT_STRING_UID_NAME);
_stub_data(GSS_C_NT_USER_NAME);
_stub_data(GSS_C_SEC_CONTEXT_SASL_SSF);
_stub_data(GSS_KRB5_CRED_NO_CI_FLAGS_X);
_stub_data(GSS_KRB5_GET_CRED_IMPERSONATOR);
_stub_data(GSS_KRB5_NT_ENTERPRISE_NAME);
_stub_data(GSS_KRB5_NT_PRINCIPAL_NAME);
_stub_data(GSS_KRB5_NT_X509_CERT);
_stub_code(gss_accept_sec_context);
_stub_code(gss_acquire_cred);
_stub_code(gss_acquire_cred_from);
_stub_code(gss_acquire_cred_impersonate_name);
_stub_code(gss_acquire_cred_with_password);
_stub_code(gss_add_buffer_set_member);
_stub_code(gss_add_cred);
_stub_code(gss_add_cred_from);
_stub_code(gss_add_cred_impersonate_name);
_stub_code(gss_add_cred_with_password);
_stub_code(gss_add_oid_set_member);
_stub_code(gss_authorize_localname);
_stub_code(gss_canonicalize_name);
_stub_code(gss_compare_name);
_stub_code(gss_complete_auth_token);
_stub_code(gss_context_time);
_stub_code(gss_create_empty_buffer_set);
_stub_code(gss_create_empty_oid_set);
_stub_code(gss_decapsulate_token);
_stub_code(gss_delete_name_attribute);
_stub_code(gss_delete_sec_context);
_stub_code(gss_display_mech_attr);
_stub_code(gss_display_name);
_stub_code(gss_display_name_ext);
_stub_code(gss_display_status);
_stub_code(gss_duplicate_name);
_stub_code(gss_encapsulate_token);
_stub_code(gss_export_cred);
_stub_code(gss_export_name);
_stub_code(gss_export_name_composite);
_stub_code(gss_export_sec_context);
_stub_code(gss_get_mic);
_stub_code(gss_get_mic_iov);
_stub_code(gss_get_mic_iov_length);
_stub_code(gss_get_name_attribute);
_stub_code(gss_import_cred);
_stub_code(gss_import_name);
_stub_code(gss_import_sec_context);
_stub_code(gss_indicate_mechs);
_stub_code(gss_indicate_mechs_by_attrs);
_stub_code(gss_init_sec_context);
_stub_code(gss_inquire_attrs_for_mech);
_stub_code(gss_inquire_context);
_stub_code(gss_inquire_cred);
_stub_code(gss_inquire_cred_by_mech);
_stub_code(gss_inquire_cred_by_oid);
_stub_code(gss_inquire_mech_for_saslname);
_stub_code(gss_inquire_mechs_for_name);
_stub_code(gss_inquire_name);
_stub_code(gss_inquire_names_for_mech);
_stub_code(gss_inquire_saslname_for_mech);
_stub_code(gss_inquire_sec_context_by_oid);
_stub_code(gss_krb5_ccache_name);
_stub_code(gss_krb5_copy_ccache);
_stub_code(gss_krb5_export_lucid_sec_context);
_stub_code(gss_krb5_free_lucid_sec_context);
_stub_code(gss_krb5_get_tkt_flags);
_stub_code(gss_krb5_import_cred);
_stub_code(gss_krb5_set_allowable_enctypes);
_stub_code(gss_krb5_set_cred_rcache);
_stub_code(gss_krb5int_make_seal_token_v3);
_stub_code(gss_krb5int_unseal_token_v3);
_stub_code(gss_localname);
_stub_code(gss_map_name_to_any);
_stub_data(gss_mech_iakerb);
_stub_data(gss_mech_krb5);
_stub_data(gss_mech_krb5_old);
_stub_data(gss_mech_krb5_wrong);
_stub_data(gss_mech_set_krb5);
_stub_data(gss_mech_set_krb5_both);
_stub_data(gss_mech_set_krb5_old);
_stub_data(gss_nt_exported_name);
_stub_data(gss_nt_krb5_name);
_stub_data(gss_nt_krb5_principal);
_stub_data(gss_nt_machine_uid_name);
_stub_data(gss_nt_service_name);
_stub_data(gss_nt_service_name_v2);
_stub_data(gss_nt_string_uid_name);
_stub_data(gss_nt_user_name);
_stub_code(gss_oid_equal);
_stub_code(gss_oid_to_str);
_stub_code(gss_pname_to_uid);
_stub_code(gss_process_context_token);
_stub_code(gss_pseudo_random);
_stub_code(gss_release_any_name_mapping);
_stub_code(gss_release_buffer);
_stub_code(gss_release_buffer_set);
_stub_code(gss_release_cred);
_stub_code(gss_release_iov_buffer);
_stub_code(gss_release_name);
_stub_code(gss_release_oid);
_stub_code(gss_release_oid_set);
_stub_code(gss_seal);
_stub_code(gss_set_cred_option);
_stub_code(gss_set_name_attribute);
_stub_code(gss_set_neg_mechs);
_stub_code(gss_set_sec_context_option);
_stub_code(gss_sign);
_stub_code(gss_store_cred);
_stub_code(gss_store_cred_into);
_stub_code(gss_str_to_oid);
_stub_code(gss_test_oid_set_member);
_stub_code(gss_unseal);
_stub_code(gss_unwrap);
_stub_code(gss_unwrap_aead);
_stub_code(gss_unwrap_iov);
_stub_code(gss_userok);
_stub_code(gss_verify);
_stub_code(gss_verify_mic);
_stub_code(gss_verify_mic_iov);
_stub_code(gss_wrap);
_stub_code(gss_wrap_aead);
_stub_code(gss_wrap_iov);
_stub_code(gss_wrap_iov_length);
_stub_code(gss_wrap_size_limit);
_stub_code(gssint_g_seqstate_init);
_stub_code(gsskrb5_extract_authtime_from_sec_context);
_stub_code(gsskrb5_extract_authz_data_from_sec_context);
_stub_code(gssspi_mech_invoke);
_stub_code(gssspi_set_cred_option);
_stub_code(krb5_gss_register_acceptor_identity);
_stub_code(krb5_gss_use_kdc_context);
