/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.CommandLineArgument;
import org.parosproxy.paros.extension.CommandLineListener;
import org.zaproxy.zap.ZAP;

public class CommandLine {
    private static final Logger LOGGER = LogManager.getLogger(CommandLine.class);
    public static final String SESSION = "-session";
    public static final String NEW_SESSION = "-newsession";
    public static final String DAEMON = "-daemon";
    public static final String HELP = "-help";
    public static final String HELP2 = "-h";
    public static final String DIR = "-dir";
    public static final String VERSION = "-version";
    @Deprecated
    public static final String PORT = "-port";
    @Deprecated
    public static final String HOST = "-host";
    public static final String CMD = "-cmd";
    public static final String INSTALL_DIR = "-installdir";
    public static final String CONFIG = "-config";
    public static final String CONFIG_FILE = "-configfile";
    public static final String LOWMEM = "-lowmem";
    public static final String EXPERIMENTALDB = "-experimentaldb";
    public static final String SUPPORT_INFO = "-suppinfo";
    public static final String SBOM_ZIP = "-sbomzip";
    public static final String SILENT = "-silent";
    static final String SILENT_ENV_VAR = "ZAP_SILENT";
    public static final String NOSTDOUT = "-nostdout";
    public static final String DEV_MODE = "-dev";
    private boolean GUI = true;
    private boolean daemon = false;
    private boolean reportVersion = false;
    private boolean displaySupportInfo = false;
    private boolean lowMem = false;
    private boolean experimentalDb = false;
    private boolean silent = false;
    private File saveSbomZip;
    private String[] args;
    private String[] argsBackup;
    private final Map<String, String> configs = new LinkedHashMap<String, String>();
    private final Hashtable<String, String> keywords = new Hashtable();
    private List<CommandLineArgument[]> commandList = null;
    private boolean noStdOutLog;
    private boolean devMode;

    public CommandLine(String[] args) throws Exception {
        this(args, System::getenv);
    }

    CommandLine(String[] args, UnaryOperator<String> env) throws Exception {
        this.args = args == null ? new String[]{} : args;
        this.argsBackup = new String[this.args.length];
        System.arraycopy(this.args, 0, this.argsBackup, 0, this.args.length);
        this.parseFirst(this.args);
        this.readEnv(env);
        if (this.isEnabled(CMD) && this.isEnabled(DAEMON)) {
            throw new IllegalArgumentException("Command line arguments -cmd and -daemon cannot be used at the same time.");
        }
    }

    private void readEnv(UnaryOperator<String> env) {
        if (env.apply(SILENT_ENV_VAR) != null) {
            this.setSilent();
        }
    }

    private void setSilent() {
        this.silent = true;
        Constant.setSilent(true);
    }

    private boolean checkPair(String[] args, String paramName, int i) throws Exception {
        String key = args[i];
        String value = null;
        if (key == null) {
            return false;
        }
        if (key.equalsIgnoreCase(paramName)) {
            value = args[i + 1];
            if (value == null) {
                throw new Exception("Missing parameter for keyword '" + paramName + "'.");
            }
            this.keywords.put(paramName, value);
            args[i] = null;
            args[i + 1] = null;
            return true;
        }
        return false;
    }

    private boolean checkSwitch(String[] args, String paramName, int i) throws Exception {
        String key = args[i];
        if (key == null) {
            return false;
        }
        if (key.equalsIgnoreCase(paramName)) {
            this.keywords.put(paramName, "");
            args[i] = null;
            return true;
        }
        return false;
    }

    private void parseFirst(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (!this.parseSwitchs(args, i) && !this.parseKeywords(args, i)) continue;
        }
    }

    public void parse(List<CommandLineArgument[]> commandList, Map<String, CommandLineListener> extMap) throws Exception {
        this.parse(commandList, extMap, true);
    }

    public void parse(List<CommandLineArgument[]> commandList, Map<String, CommandLineListener> extMap, boolean reportUnsupported) throws Exception {
        int i;
        this.commandList = commandList;
        CommandLineArgument lastArg = null;
        boolean found = false;
        int remainingValueCount = 0;
        boolean installingAddons = false;
        for (i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            found = false;
            for (int j = 0; j < commandList.size() && !found; ++j) {
                CommandLineArgument[] extArg = commandList.get(j);
                for (int k = 0; k < extArg.length && !found; ++k) {
                    if (this.args[i].compareToIgnoreCase(extArg[k].getName()) != 0) continue;
                    if (remainingValueCount > 0) {
                        throw new Exception("Missing parameters for keyword '" + lastArg.getName() + "'.");
                    }
                    lastArg = extArg[k];
                    lastArg.setEnabled(true);
                    found = true;
                    if ("-addoninstall".equals(this.args[i]) || "-addoninstallall".equals(this.args[i])) {
                        installingAddons = true;
                    }
                    this.args[i] = null;
                    remainingValueCount = lastArg.getNumOfArguments();
                }
            }
            if (this.args[i] != null && this.args[i].startsWith("-") || lastArg != null && remainingValueCount == 0 || found || lastArg == null) continue;
            if (lastArg.getPattern() == null || lastArg.getPattern().matcher(this.args[i]).find()) {
                lastArg.getArguments().add(this.args[i]);
                if (remainingValueCount > 0) {
                    --remainingValueCount;
                }
                this.args[i] = null;
                continue;
            }
            throw new Exception(lastArg.getErrorMessage());
        }
        if (lastArg != null && remainingValueCount > 0) {
            throw new Exception("Missing parameters for keyword '" + lastArg.getName() + "'.");
        }
        for (i = 0; i < this.args.length; ++i) {
            String ext;
            CommandLineListener cll;
            File file;
            int dotIndex;
            if (this.args[i] == null || (dotIndex = this.args[i].lastIndexOf(".")) < 0 || !(file = new File(this.args[i])).exists() || !file.canRead() || (cll = extMap.get(ext = this.args[i].substring(dotIndex + 1))) == null || !cll.handleFile(file)) continue;
            found = true;
            this.args[i] = null;
        }
        if (reportUnsupported && !installingAddons) {
            for (String arg : this.args) {
                if (arg == null) continue;
                if (arg.startsWith("-")) {
                    throw new Exception(Constant.messages.getString("start.cmdline.badparam", arg));
                }
                File f = new File(arg);
                if (!f.exists()) {
                    throw new Exception(Constant.messages.getString("start.cmdline.nofile", arg));
                }
                if (!f.canRead()) {
                    throw new Exception(Constant.messages.getString("start.cmdline.noread", arg));
                }
                throw new Exception(Constant.messages.getString("start.cmdline.badfile", arg));
            }
        }
    }

    private boolean parseSwitchs(String[] args, int i) throws Exception {
        boolean result = false;
        if (this.checkSwitch(args, CMD, i)) {
            this.setDaemon(false);
            this.setGUI(false);
        } else if (this.checkSwitch(args, DAEMON, i)) {
            this.setDaemon(true);
            this.setGUI(false);
        } else if (this.checkSwitch(args, LOWMEM, i)) {
            this.setLowMem(true);
        } else if (this.checkSwitch(args, EXPERIMENTALDB, i)) {
            this.setExperimentalDb(true);
        } else if (this.checkSwitch(args, HELP, i)) {
            result = true;
            this.setGUI(false);
        } else if (this.checkSwitch(args, HELP2, i)) {
            result = true;
            this.setGUI(false);
        } else if (this.checkSwitch(args, VERSION, i)) {
            this.reportVersion = true;
            this.setDaemon(false);
            this.setGUI(false);
        } else if (this.checkSwitch(args, NOSTDOUT, i)) {
            this.noStdOutLog = true;
        } else if (this.checkSwitch(args, SUPPORT_INFO, i)) {
            this.displaySupportInfo = true;
            this.setDaemon(false);
            this.setGUI(false);
        } else if (this.checkSwitch(args, DEV_MODE, i)) {
            this.devMode = true;
            Constant.setDevMode(true);
        } else if (this.checkSwitch(args, SILENT, i)) {
            this.setSilent();
        }
        return result;
    }

    private boolean parseKeywords(String[] args, int i) throws Exception {
        boolean result = false;
        if (this.checkPair(args, NEW_SESSION, i)) {
            result = true;
        } else if (this.checkPair(args, SESSION, i)) {
            result = true;
        } else if (this.checkPair(args, DIR, i)) {
            Constant.setZapHome(this.keywords.get(DIR));
            result = true;
        } else if (this.checkPair(args, INSTALL_DIR, i)) {
            Constant.setZapInstall(this.keywords.get(INSTALL_DIR));
            result = true;
        } else if (this.checkPair(args, SBOM_ZIP, i)) {
            String zipName = this.keywords.get(SBOM_ZIP);
            this.saveSbomZip = new File(zipName);
            this.setDaemon(false);
            this.setGUI(false);
            result = true;
        } else if (this.checkPair(args, CONFIG, i)) {
            String pair = this.keywords.get(CONFIG);
            if (pair != null && pair.indexOf("=") > 0) {
                int eqIndex = pair.indexOf("=");
                this.configs.put(pair.substring(0, eqIndex), pair.substring(eqIndex + 1));
                result = true;
            }
        } else if (this.checkPair(args, CONFIG_FILE, i)) {
            String conf = this.keywords.get(CONFIG_FILE);
            File confFile = new File(conf);
            if (!confFile.isFile()) {
                throw new Exception("No such file: " + confFile.getAbsolutePath());
            }
            if (!confFile.canRead()) {
                throw new Exception("File not readable: " + confFile.getAbsolutePath());
            }
            Properties prop = new Properties(){
                List<Object> orderedKeys = new ArrayList<Object>();
                private static final long serialVersionUID = 1L;

                @Override
                public synchronized Object put(Object key, Object value) {
                    this.orderedKeys.add(key);
                    return super.put(key, value);
                }

                @Override
                public synchronized Enumeration<Object> keys() {
                    return Collections.enumeration(this.orderedKeys);
                }
            };
            try (FileInputStream inStream = new FileInputStream(confFile);){
                prop.load(inStream);
            }
            Enumeration<Object> keyEnum = prop.keys();
            while (keyEnum.hasMoreElements()) {
                String key = (String)keyEnum.nextElement();
                this.configs.put(key, prop.getProperty(key));
            }
        }
        return result;
    }

    public boolean isGUI() {
        return this.GUI;
    }

    public void setGUI(boolean GUI) {
        this.GUI = GUI;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public boolean isLowMem() {
        return this.lowMem;
    }

    public void setLowMem(boolean lowMem) {
        this.lowMem = lowMem;
    }

    public boolean isExperimentalDb() {
        return this.experimentalDb;
    }

    public void setExperimentalDb(boolean experimentalDb) {
        this.experimentalDb = experimentalDb;
    }

    public boolean isReportVersion() {
        return this.reportVersion;
    }

    public boolean isDisplaySupportInfo() {
        return this.displaySupportInfo;
    }

    public File getSaveSbomZip() {
        return this.saveSbomZip;
    }

    @Deprecated
    public int getPort() {
        return -1;
    }

    @Deprecated
    public String getHost() {
        return null;
    }

    public Map<String, String> getOrderedConfigs() {
        return this.configs;
    }

    public String getArgument(String keyword) {
        return this.keywords.get(keyword);
    }

    public String getHelp() {
        return CommandLine.getHelp(this.commandList);
    }

    public boolean isNoStdOutLog() {
        return this.noStdOutLog;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public static String getHelp(List<CommandLineArgument[]> cmdList) {
        String zap = Constant.isWindows() ? "zap.bat" : "zap.sh";
        StringBuilder sb = new StringBuilder();
        sb.append(Constant.messages.getString("cmdline.help", zap));
        if (cmdList != null) {
            for (CommandLineArgument[] extArgs : cmdList) {
                for (CommandLineArgument extArg : extArgs) {
                    sb.append("\t");
                    sb.append(extArg.getHelpMessage()).append("\n");
                }
            }
        }
        return sb.toString();
    }

    public boolean isEnabled(String keyword) {
        String obj = this.keywords.get(keyword);
        return obj != null && obj instanceof String;
    }

    public void resetArgs() {
        System.arraycopy(this.argsBackup, 0, this.args, 0, this.argsBackup.length);
    }

    public static void info(String str) {
        switch (ZAP.getProcessType()) {
            case cmdline: {
                System.out.println(str);
                break;
            }
        }
        LOGGER.info(str);
    }

    public static void error(String str) {
        switch (ZAP.getProcessType()) {
            case cmdline: {
                System.err.println(str);
                break;
            }
        }
        LOGGER.error(str);
    }

    public static void error(String str, Throwable e) {
        switch (ZAP.getProcessType()) {
            case cmdline: {
                System.err.println(str);
                break;
            }
        }
        LOGGER.error(str, e);
    }
}

