/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.core.scanner.Plugin;
import org.zaproxy.zap.control.CoreFunctionality;
import org.zaproxy.zap.control.ExtensionFactory;

public class PluginFactory {
    private static final Logger LOGGER = LogManager.getLogger(PluginFactory.class);
    private static List<AbstractPlugin> loadedPlugins = null;
    private static Map<Integer, Plugin> mapLoadedPlugins;
    private List<Plugin> listAllPlugin = new ArrayList<Plugin>();
    private LinkedHashMap<Integer, Plugin> mapAllPlugin = new LinkedHashMap();
    private LinkedHashMap<String, Plugin> mapAllPluginOrderCodeName = new LinkedHashMap();
    private List<Plugin> listPending = new ArrayList<Plugin>();
    private List<Plugin> listRunning = new ArrayList<Plugin>();
    private List<Plugin> listCompleted = new ArrayList<Plugin>();
    private int totalPluginToRun = 0;
    private boolean init = false;
    private Configuration config;
    private static final Comparator<AbstractPlugin> riskComparator;

    public PluginFactory() {
        HierarchicalConfiguration configuration = new HierarchicalConfiguration();
        configuration.setDelimiterParsingDisabled(true);
        this.config = configuration;
    }

    private static synchronized void initPlugins() {
        if (loadedPlugins == null) {
            PluginFactory.init(true);
        }
    }

    static void init(boolean includeAddOns) {
        loadedPlugins = new ArrayList<AbstractPlugin>(CoreFunctionality.getBuiltInActiveScanRules());
        if (includeAddOns) {
            loadedPlugins.addAll(ExtensionFactory.getAddOnLoader().getActiveScanRules());
        }
        Collections.sort(loadedPlugins, riskComparator);
        mapLoadedPlugins = new HashMap<Integer, Plugin>();
        for (Plugin plugin : loadedPlugins) {
            PluginFactory.checkPluginId(plugin);
            mapLoadedPlugins.put(plugin.getId(), plugin);
        }
    }

    private static void checkPluginId(Plugin plugin) {
        if (plugin.getId() == -1) {
            LOGGER.error("The active scan rule [{}] does not have a defined ID.", (Object)plugin.getClass().getCanonicalName());
        }
    }

    public static Plugin getLoadedPlugin(int id) {
        PluginFactory.initPlugins();
        return mapLoadedPlugins.get(id);
    }

    private static List<AbstractPlugin> getLoadedPlugins() {
        if (loadedPlugins == null) {
            PluginFactory.initPlugins();
        }
        return loadedPlugins;
    }

    public static boolean isPluginLoaded(AbstractPlugin plugin) {
        if (loadedPlugins == null) {
            return false;
        }
        return PluginFactory.isPluginLoadedImpl(plugin);
    }

    private static boolean isPluginLoadedImpl(AbstractPlugin plugin) {
        for (AbstractPlugin otherPlugin : PluginFactory.getLoadedPlugins()) {
            if (otherPlugin != plugin) continue;
            return true;
        }
        return false;
    }

    public static void loadedPlugin(AbstractPlugin plugin) {
        if (!PluginFactory.isPluginLoadedImpl(plugin)) {
            PluginFactory.checkPluginId(plugin);
            PluginFactory.getLoadedPlugins().add(plugin);
            mapLoadedPlugins.put(plugin.getId(), plugin);
            Collections.sort(loadedPlugins, riskComparator);
        }
    }

    public static void unloadedPlugin(AbstractPlugin plugin) {
        if (loadedPlugins == null) {
            return;
        }
        Iterator<AbstractPlugin> it = PluginFactory.getLoadedPlugins().iterator();
        while (it.hasNext()) {
            if (it.next() != plugin) continue;
            it.remove();
            mapLoadedPlugins.remove(plugin.getId());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        LinkedHashMap<Integer, Plugin> linkedHashMap = this.mapAllPlugin;
        synchronized (linkedHashMap) {
            this.listPending.clear();
            this.listRunning.clear();
            this.listCompleted.clear();
            for (Plugin plugin : this.mapAllPlugin.values()) {
                if (!plugin.isEnabled()) continue;
                this.enableDependency(plugin);
            }
            for (Plugin plugin : this.mapAllPlugin.values()) {
                if (!plugin.isEnabled()) continue;
                this.addAllDependencies(plugin, this.listPending);
                if (this.listPending.contains(plugin)) continue;
                this.listPending.add(plugin);
            }
            this.totalPluginToRun = this.listPending.size();
        }
        this.init = true;
    }

    private void enableDependency(Plugin plugin) {
        String[] dependency = plugin.getDependency();
        if (dependency == null || dependency.length == 0) {
            return;
        }
        ArrayList<Plugin> dependencies = new ArrayList<Plugin>(dependency.length);
        if (this.addAllDependencies(plugin, dependencies)) {
            for (Plugin dep : dependencies) {
                if (dep.isEnabled()) continue;
                dep.setEnabled(true);
            }
        } else {
            plugin.setEnabled(false);
            plugin.setAlertThreshold(Plugin.AlertThreshold.OFF);
            LOGGER.warn("Disabled scanner '{}' because of unfulfilled dependencies.", (Object)plugin.getName());
        }
    }

    public boolean hasAllDependenciesAvailable(Plugin plugin) {
        ArrayList<Plugin> deps = new ArrayList<Plugin>();
        return this.addAllDependencies(plugin, deps);
    }

    public boolean addAllDependencies(Plugin plugin, List<Plugin> to) {
        String[] dependencies = plugin.getDependency();
        if (dependencies == null || dependencies.length == 0) {
            return true;
        }
        boolean allDepsAvailable = true;
        ArrayList<String> deps = new ArrayList<String>(Arrays.asList(dependencies));
        for (String dependency : deps) {
            Plugin pluginDep = this.mapAllPluginOrderCodeName.get(dependency);
            if (pluginDep == null) {
                allDepsAvailable = false;
                continue;
            }
            if (to.contains(pluginDep)) continue;
            allDepsAvailable &= this.addAllDependencies(pluginDep, to);
            to.add(pluginDep);
        }
        return allDepsAvailable;
    }

    public List<Plugin> getDependentPlugins(Plugin plugin) {
        ArrayList<Plugin> dependentPlugins = new ArrayList<Plugin>();
        this.addDependentPlugins(plugin.getCodeName(), dependentPlugins);
        return dependentPlugins;
    }

    private void addDependentPlugins(String pluginName, List<Plugin> to) {
        for (Plugin plugin : this.listAllPlugin) {
            String[] dependencies = plugin.getDependency();
            if (dependencies == null || dependencies.length == 0 || !Arrays.asList(dependencies).contains(pluginName) || to.contains(plugin)) continue;
            to.add(plugin);
            this.addDependentPlugins(plugin.getCodeName(), to);
        }
    }

    public List<Plugin> getDependencies(Plugin plugin) {
        String[] dependencies = plugin.getDependency();
        if (dependencies == null || dependencies.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> deps = new ArrayList<String>(Arrays.asList(dependencies));
        ArrayList<Plugin> depsPlugins = new ArrayList<Plugin>(deps.size());
        for (String dependency : deps) {
            Plugin pluginDep = this.mapAllPluginOrderCodeName.get(dependency);
            if (pluginDep == null) continue;
            depsPlugins.add(pluginDep);
        }
        return depsPlugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadAllPlugin(Configuration config) {
        LOGGER.debug("loadAllPlugin");
        this.config = config;
        LinkedHashMap<Integer, Plugin> linkedHashMap = this.mapAllPlugin;
        synchronized (linkedHashMap) {
            this.mapAllPlugin.clear();
            this.listAllPlugin.clear();
            this.mapAllPluginOrderCodeName.clear();
            for (int i = 0; i < PluginFactory.getLoadedPlugins().size(); ++i) {
                try {
                    Plugin loadedPlugin = PluginFactory.getLoadedPlugins().get(i);
                    if (!loadedPlugin.isVisible()) {
                        LOGGER.info("Plugin {} not visible", (Object)loadedPlugin.getName());
                        continue;
                    }
                    if (loadedPlugin.isDepreciated()) {
                        LOGGER.info("Plugin {} deprecated", (Object)loadedPlugin.getName());
                        continue;
                    }
                    if (!PluginFactory.canAddPlugin(this.mapAllPlugin, loadedPlugin)) continue;
                    Plugin plugin = PluginFactory.createNewPlugin(loadedPlugin, config);
                    LOGGER.debug("loaded plugin {} with: Threshold={} Strength={}", (Object)plugin.getName(), (Object)plugin.getAlertThreshold().name(), (Object)plugin.getAttackStrength());
                    this.mapAllPlugin.put(plugin.getId(), plugin);
                    this.mapAllPluginOrderCodeName.put(plugin.getCodeName(), plugin);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            Iterator<Plugin> iterator = this.mapAllPlugin.values().iterator();
            while (iterator.hasNext()) {
                this.listAllPlugin.add(iterator.next());
            }
        }
    }

    private static Plugin createNewPlugin(Plugin plugin, Configuration config) throws ReflectiveOperationException {
        Plugin newPlugin = (Plugin)plugin.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        newPlugin.setConfig((Configuration)new BaseConfiguration());
        plugin.cloneInto(newPlugin);
        newPlugin.setConfig(config);
        newPlugin.createParamIfNotExist();
        newPlugin.loadFrom(config);
        return newPlugin;
    }

    private static boolean canAddPlugin(Map<Integer, Plugin> plugins, Plugin plugin) {
        Plugin existingPlugin = plugins.get(plugin.getId());
        if (existingPlugin == null) {
            return true;
        }
        if (existingPlugin.getName().equals(plugin.getName())) {
            if (existingPlugin.getStatus().compareTo(plugin.getStatus()) > 0) {
                LOGGER.info("Ignoring (apparently) less stable scanner version, id={}, ExistingPlugin[Status={}, Class={}], LessStablePlugin[Status={}, Class={}]", (Object)plugin.getId(), (Object)existingPlugin.getStatus(), (Object)existingPlugin.getClass().getCanonicalName(), (Object)plugin.getStatus(), (Object)plugin.getClass().getCanonicalName());
                return false;
            }
            if (existingPlugin.getStatus() != plugin.getStatus()) {
                LOGGER.info("Replacing existing scanner with (apparently) stabler version, id={}, ExistingPlugin[Status={}, Class={}], StablerPlugin[Status={}, Class={}]", (Object)plugin.getId(), (Object)existingPlugin.getStatus(), (Object)existingPlugin.getClass().getCanonicalName(), (Object)plugin.getStatus(), (Object)plugin.getClass().getCanonicalName());
                return true;
            }
        }
        LOGGER.error("Duplicate id {} {} {}", (Object)plugin.getId(), (Object)plugin.getClass().getCanonicalName(), (Object)existingPlugin.getClass().getCanonicalName());
        return true;
    }

    public synchronized void loadFrom(PluginFactory pf) {
        LOGGER.debug("loadFrom {}", (Object)pf.listAllPlugin.size());
        for (Plugin plugin : pf.listAllPlugin) {
            Plugin p = this.mapAllPlugin.get(plugin.getId());
            if (p == null) continue;
            plugin.cloneInto(p);
        }
    }

    public List<Plugin> getAllPlugin() {
        return this.listAllPlugin;
    }

    public PluginFactory clone() {
        PluginFactory clone = new PluginFactory();
        for (Plugin plugin : this.listAllPlugin) {
            try {
                Plugin pluginCopy = (Plugin)plugin.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                pluginCopy.setConfig(clone.config);
                plugin.cloneInto(pluginCopy);
                clone.addPlugin(pluginCopy);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return clone;
    }

    public boolean addPlugin(String name) {
        try {
            boolean duplicatedId;
            Class<?> c = ExtensionFactory.getAddOnLoader().loadClass(name);
            AbstractPlugin plugin = (AbstractPlugin)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            boolean bl = duplicatedId = this.mapAllPlugin.get(plugin.getId()) != null;
            if (this.addPlugin(plugin)) {
                LOGGER.info("loaded plugin {}", (Object)plugin.getName());
                if (duplicatedId) {
                    LOGGER.error("Duplicate id {} {}", (Object)plugin.getName(), (Object)this.mapAllPlugin.get(plugin.getId()).getName());
                }
                return true;
            }
            if (!plugin.isVisible()) {
                LOGGER.info("Plugin {} not visible", (Object)plugin.getName());
                return false;
            }
            if (plugin.isDepreciated()) {
                LOGGER.info("Plugin {} deprecated", (Object)plugin.getName());
                return false;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean addPlugin(Plugin plugin) {
        this.listAllPlugin.add(plugin);
        plugin.setConfig(this.config);
        plugin.createParamIfNotExist();
        if (!plugin.isVisible()) {
            return false;
        }
        if (plugin.isDepreciated()) {
            return false;
        }
        this.mapAllPlugin.put(plugin.getId(), plugin);
        this.mapAllPluginOrderCodeName.put(plugin.getCodeName(), plugin);
        return true;
    }

    public boolean removePlugin(String className) {
        for (int i = 0; i < this.listAllPlugin.size(); ++i) {
            Plugin plugin = this.listAllPlugin.get(i);
            if (!plugin.getClass().getName().equals(className)) continue;
            this.listAllPlugin.remove(plugin);
            this.mapAllPlugin.remove(plugin.getId());
            this.mapAllPluginOrderCodeName.remove(plugin.getCodeName());
            return true;
        }
        return false;
    }

    public Plugin getPlugin(int id) {
        return this.mapAllPlugin.get(id);
    }

    public void setAllPluginEnabled(boolean enabled) {
        for (int i = 0; i < this.listAllPlugin.size(); ++i) {
            Plugin plugin = this.listAllPlugin.get(i);
            plugin.setEnabled(enabled);
        }
    }

    synchronized boolean existPluginToRun() {
        if (!this.init) {
            this.reset();
        }
        if (this.probeNextPlugin() != null) {
            return true;
        }
        return !this.listPending.isEmpty() || !this.listRunning.isEmpty();
    }

    private Plugin probeNextPlugin() {
        Plugin plugin = null;
        for (int i = 0; i < this.listPending.size(); ++i) {
            plugin = this.listPending.get(i);
            if (!this.isAllDependencyCompleted(plugin)) continue;
            return plugin;
        }
        return null;
    }

    synchronized Plugin nextPlugin() {
        Plugin plugin;
        if (!this.init) {
            this.reset();
        }
        if ((plugin = this.probeNextPlugin()) == null) {
            return null;
        }
        this.listPending.remove(plugin);
        plugin.setTimeStarted();
        this.listRunning.add(plugin);
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAllDependencyCompleted(Plugin plugin) {
        String[] dependency = plugin.getDependency();
        if (dependency == null || dependency.length == 0) {
            return true;
        }
        List<Plugin> list = this.listCompleted;
        synchronized (list) {
            for (int i = 0; i < dependency.length; ++i) {
                boolean isFound = false;
                for (int j = 0; j < this.listCompleted.size() && !isFound; ++j) {
                    Plugin completed = this.listCompleted.get(j);
                    if (!completed.getCodeName().equalsIgnoreCase(dependency[i])) continue;
                    isFound = true;
                }
                if (isFound) continue;
                return false;
            }
        }
        return true;
    }

    public void saveTo(Configuration conf) throws ConfigurationException {
        for (Plugin plugin : this.listAllPlugin) {
            plugin.saveTo(conf);
        }
    }

    public void loadFrom(Configuration config) throws ConfigurationException {
        for (Plugin plugin : this.listAllPlugin) {
            plugin.loadFrom(config);
        }
    }

    synchronized void setRunningPluginCompleted(Plugin plugin) {
        if (this.listRunning.remove(plugin)) {
            Plugin completedPlugin = this.mapAllPlugin.get(plugin.getId());
            this.listCompleted.add(completedPlugin);
            completedPlugin.setTimeFinished();
        }
    }

    boolean isRunning(Plugin plugin) {
        return this.listRunning.contains(plugin);
    }

    int totalPluginToRun() {
        return this.totalPluginToRun;
    }

    int totalPluginCompleted() {
        return this.listCompleted.size();
    }

    List<Plugin> getPending() {
        return this.listPending;
    }

    List<Plugin> getRunning() {
        return this.listRunning;
    }

    List<Plugin> getCompleted() {
        return this.listCompleted;
    }

    public int getEnabledPluginCount() {
        int count = 0;
        for (Plugin plugin : this.listAllPlugin) {
            if (!plugin.isEnabled()) continue;
            ++count;
        }
        return count;
    }

    static {
        riskComparator = new Comparator<AbstractPlugin>(){

            @Override
            public int compare(AbstractPlugin e1, AbstractPlugin e2) {
                int res = e1.getStatus().compareTo(e2.getStatus());
                if (res != 0) {
                    return -res;
                }
                if (e1.getRisk() > e2.getRisk()) {
                    return -1;
                }
                if (e1.getRisk() < e2.getRisk()) {
                    return 1;
                }
                if (e1.getId() < e2.getId()) {
                    return -1;
                }
                if (e1.getId() > e2.getId()) {
                    return 1;
                }
                return 0;
            }
        };
    }
}

