/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension;

import java.awt.Component;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.control.Proxy;
import org.parosproxy.paros.core.proxy.ConnectRequestProxyListener;
import org.parosproxy.paros.core.proxy.OverrideMessageProxyListener;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.core.proxy.ProxyServer;
import org.parosproxy.paros.core.scanner.Scanner;
import org.parosproxy.paros.core.scanner.ScannerHook;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.db.Database;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DatabaseUnsupportedException;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.extension.CommandLineArgument;
import org.parosproxy.paros.extension.CommandLineListener;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionHookMenu;
import org.parosproxy.paros.extension.ExtensionHookView;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.extension.OptionsChangedListener;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.view.AbstractParamDialog;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.MainMenuBar;
import org.parosproxy.paros.view.SiteMapPanel;
import org.parosproxy.paros.view.View;
import org.parosproxy.paros.view.WorkbenchPanel;
import org.zaproxy.zap.PersistentConnectionListener;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.extension.AddOnInstallationStatusListener;
import org.zaproxy.zap.extension.AddonFilesChangedListener;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.httppanel.DisplayedMessageChangedListener;
import org.zaproxy.zap.model.ContextDataFactory;
import org.zaproxy.zap.network.HttpSenderListener;
import org.zaproxy.zap.view.ContextPanelFactory;
import org.zaproxy.zap.view.HrefTypeInfo;
import org.zaproxy.zap.view.MainToolbarPanel;
import org.zaproxy.zap.view.SiteMapListener;

public class ExtensionLoader {
    private final List<Extension> extensionList = new ArrayList<Extension>();
    private final Map<Class<? extends Extension>, Extension> extensionsMap = new HashMap<Class<? extends Extension>, Extension>();
    private final Map<Extension, ExtensionHook> extensionHooks = new HashMap<Extension, ExtensionHook>();
    private Model model = null;
    private View view = null;
    private CommandLine cmdLine;
    private static final Logger LOGGER = LogManager.getLogger(ExtensionLoader.class);
    private List<ProxyServer> proxyServers;

    public ExtensionLoader(Model model, View view) {
        this.model = model;
        this.view = view;
        this.proxyServers = new ArrayList<ProxyServer>();
    }

    public void addExtension(Extension extension) {
        this.extensionList.add(extension);
        this.extensionsMap.put(extension.getClass(), extension);
    }

    public void destroyAllExtension() {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            try {
                this.getExtension(i).destroy();
                continue;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public Extension getExtension(int i) {
        return this.extensionList.get(i);
    }

    public Extension getExtension(String name) {
        if (name != null) {
            for (int i = 0; i < this.extensionList.size(); ++i) {
                Extension p = this.getExtension(i);
                if (!p.getName().equalsIgnoreCase(name)) continue;
                return p;
            }
        }
        return null;
    }

    public Extension getExtensionByClassName(String name) {
        if (name != null) {
            for (int i = 0; i < this.extensionList.size(); ++i) {
                Extension p = this.getExtension(i);
                if (!p.getClass().getName().equals(name)) continue;
                return p;
            }
        }
        return null;
    }

    public <T extends Extension> T getExtension(Class<T> clazz) {
        Extension extension;
        if (clazz != null && (extension = this.extensionsMap.get(clazz)) != null) {
            return (T)((Extension)clazz.cast(extension));
        }
        return null;
    }

    public boolean isExtensionEnabled(String extensionName) {
        if (extensionName == null) {
            throw new IllegalArgumentException("Parameter extensionName must not be null.");
        }
        Extension extension = this.getExtension(extensionName);
        if (extension == null) {
            return false;
        }
        return extension.isEnabled();
    }

    public int getExtensionCount() {
        return this.extensionList.size();
    }

    @Deprecated(since="2.13.0", forRemoval=true)
    public void addProxyServer(ProxyServer proxyServer) {
        this.proxyServers.add(proxyServer);
        this.extensionHooks.values().forEach(extHook -> ExtensionLoader.hookProxyServer(extHook, proxyServer));
    }

    private static void hookProxyServer(ExtensionHook extHook, ProxyServer proxyServer) {
        ExtensionLoader.process(extHook.getProxyListenerList(), proxyServer::addProxyListener);
        ExtensionLoader.process(extHook.getOverrideMessageProxyListenerList(), proxyServer::addOverrideMessageProxyListener);
        ExtensionLoader.process(extHook.getPersistentConnectionListener(), proxyServer::addPersistentConnectionListener);
        ExtensionLoader.process(extHook.getConnectRequestProxyListeners(), proxyServer::addConnectRequestProxyListener);
    }

    private static <T> void process(List<T> elements, Consumer<T> action) {
        try {
            elements.stream().filter(Objects::nonNull).forEach(action);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void hookProxies(ExtensionHook extHook) {
        for (ProxyServer proxyServer : this.proxyServers) {
            ExtensionLoader.hookProxyServer(extHook, proxyServer);
        }
    }

    @Deprecated(since="2.13.0", forRemoval=true)
    public void removeProxyServer(ProxyServer proxyServer) {
        this.proxyServers.remove(proxyServer);
        this.extensionHooks.values().forEach(extHook -> this.unhookProxyServer((ExtensionHook)extHook, proxyServer));
    }

    private void unhookProxyServer(ExtensionHook extHook, ProxyServer proxyServer) {
        ExtensionLoader.process(extHook.getProxyListenerList(), proxyServer::removeProxyListener);
        ExtensionLoader.process(extHook.getOverrideMessageProxyListenerList(), proxyServer::removeOverrideMessageProxyListener);
        ExtensionLoader.process(extHook.getPersistentConnectionListener(), proxyServer::removePersistentConnectionListener);
        ExtensionLoader.process(extHook.getConnectRequestProxyListeners(), proxyServer::removeConnectRequestProxyListener);
    }

    private void unhookProxies(ExtensionHook extHook) {
        for (ProxyServer proxyServer : this.proxyServers) {
            this.unhookProxyServer(extHook, proxyServer);
        }
    }

    @Deprecated(since="2.13.0", forRemoval=true)
    public void hookProxyListener(Proxy proxy) {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            ExtensionLoader.hookProxyListeners(proxy, hook.getProxyListenerList());
        }
    }

    private static void hookProxyListeners(Proxy proxy, List<ProxyListener> listeners) {
        for (ProxyListener listener : listeners) {
            try {
                if (listener == null) continue;
                proxy.addProxyListener(listener);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Deprecated(since="2.13.0", forRemoval=true)
    public void hookOverrideMessageProxyListener(Proxy proxy) {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            ExtensionLoader.hookOverrideMessageProxyListeners(proxy, hook.getOverrideMessageProxyListenerList());
        }
    }

    private static void hookOverrideMessageProxyListeners(Proxy proxy, List<OverrideMessageProxyListener> listeners) {
        for (OverrideMessageProxyListener listener : listeners) {
            try {
                if (listener == null) continue;
                proxy.addOverrideMessageProxyListener(listener);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Deprecated(since="2.13.0", forRemoval=true)
    public void hookConnectRequestProxyListeners(Proxy proxy) {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            ExtensionLoader.hookConnectRequestProxyListeners(proxy, hook.getConnectRequestProxyListeners());
        }
    }

    private static void hookConnectRequestProxyListeners(Proxy proxy, List<ConnectRequestProxyListener> listeners) {
        for (ConnectRequestProxyListener listener : listeners) {
            proxy.addConnectRequestProxyListener(listener);
        }
    }

    @Deprecated(since="2.13.0", forRemoval=true)
    public void hookPersistentConnectionListener(Proxy proxy) {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            ExtensionLoader.hookPersistentConnectionListeners(proxy, hook.getPersistentConnectionListener());
        }
    }

    private static void hookPersistentConnectionListeners(Proxy proxy, List<PersistentConnectionListener> listeners) {
        for (PersistentConnectionListener listener : listeners) {
            try {
                if (listener == null) continue;
                proxy.addPersistentConnectionListener(listener);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void hookSiteMapListener(SiteMapPanel siteMapPanel) {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            ExtensionLoader.hookSiteMapListeners(siteMapPanel, hook.getSiteMapListenerList());
        }
    }

    private static void hookSiteMapListeners(SiteMapPanel siteMapPanel, List<SiteMapListener> listeners) {
        for (SiteMapListener listener : listeners) {
            try {
                if (listener == null) continue;
                siteMapPanel.addSiteMapListener(listener);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void removeSiteMapListener(ExtensionHook hook) {
        if (!this.hasView()) {
            return;
        }
        SiteMapPanel siteMapPanel = this.view.getSiteTreePanel();
        Vector<SiteMapListener> listenerList = hook.getSiteMapListenerList();
        for (SiteMapListener listener : listenerList) {
            try {
                if (listener == null) continue;
                siteMapPanel.removeSiteMapListener(listener);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean hasView() {
        return this.view != null;
    }

    public void hookScannerHook(Scanner scan) {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            if (hook == null) continue;
            Vector<ScannerHook> scannerHookList = hook.getScannerHookList();
            for (ScannerHook scannerHook : scannerHookList) {
                try {
                    scan.addScannerHook(scannerHook);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void optionsChangedAllPlugin(OptionsParam options) {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            Vector<OptionsChangedListener> listenerList = hook.getOptionsChangedListenerList();
            for (OptionsChangedListener listener : listenerList) {
                try {
                    if (listener == null) continue;
                    listener.optionsChanged(options);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void runCommandLine() {
        CommandLineListener listener;
        Extension ext;
        int i;
        for (i = 0; i < this.getExtensionCount(); ++i) {
            ext = this.getExtension(i);
            if (!(ext instanceof CommandLineListener)) continue;
            listener = (CommandLineListener)((Object)ext);
            listener.preExecute(this.extensionHooks.get(ext).getCommandLineArgument());
        }
        for (i = 0; i < this.getExtensionCount(); ++i) {
            ext = this.getExtension(i);
            if (!(ext instanceof CommandLineListener)) continue;
            listener = (CommandLineListener)((Object)ext);
            listener.execute(this.extensionHooks.get(ext).getCommandLineArgument());
        }
    }

    public void sessionChangedAllPlugin(Session session) {
        LOGGER.debug("sessionChangedAllPlugin");
        for (ExtensionHook hook : this.extensionHooks.values()) {
            Vector<SessionChangedListener> listenerList = hook.getSessionListenerList();
            for (SessionChangedListener listener : listenerList) {
                try {
                    if (listener == null) continue;
                    listener.sessionChanged(session);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void databaseOpen(Database db) {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            Extension ext = this.getExtension(i);
            try {
                ext.databaseOpen(db);
                continue;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void sessionAboutToChangeAllPlugin(Session session) {
        LOGGER.debug("sessionAboutToChangeAllPlugin");
        for (ExtensionHook hook : this.extensionHooks.values()) {
            Vector<SessionChangedListener> listenerList = hook.getSessionListenerList();
            for (SessionChangedListener listener : listenerList) {
                try {
                    if (listener == null) continue;
                    listener.sessionAboutToChange(session);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void sessionScopeChangedAllPlugin(Session session) {
        LOGGER.debug("sessionScopeChangedAllPlugin");
        for (ExtensionHook hook : this.extensionHooks.values()) {
            Vector<SessionChangedListener> listenerList = hook.getSessionListenerList();
            for (SessionChangedListener listener : listenerList) {
                try {
                    if (listener == null) continue;
                    listener.sessionScopeChanged(session);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void sessionModeChangedAllPlugin(Control.Mode mode) {
        LOGGER.debug("sessionModeChangedAllPlugin");
        for (ExtensionHook hook : this.extensionHooks.values()) {
            Vector<SessionChangedListener> listenerList = hook.getSessionListenerList();
            for (SessionChangedListener listener : listenerList) {
                try {
                    if (listener == null) continue;
                    listener.sessionModeChanged(mode);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void sessionPropertiesChangedAllPlugin(Session session) {
        LOGGER.debug("sessionPropertiesChangedAllPlugin");
        for (ExtensionHook hook : this.extensionHooks.values()) {
            for (SessionChangedListener listener : hook.getSessionListenerList()) {
                try {
                    if (listener == null) continue;
                    listener.sessionPropertiesChanged(session);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void addonFilesAdded() {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            List<AddonFilesChangedListener> listenerList = hook.getAddonFilesChangedListener();
            for (AddonFilesChangedListener listener : listenerList) {
                try {
                    listener.filesAdded();
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void addonFilesRemoved() {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            List<AddonFilesChangedListener> listenerList = hook.getAddonFilesChangedListener();
            for (AddonFilesChangedListener listener : listenerList) {
                try {
                    listener.filesRemoved();
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void addOnInstalled(AddOn addOn) {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            for (AddOnInstallationStatusListener listener : hook.getAddOnInstallationStatusListeners()) {
                try {
                    listener.addOnInstalled(addOn);
                }
                catch (Exception e) {
                    LOGGER.error("An error occurred while notifying: {}", (Object)listener.getClass().getCanonicalName(), (Object)e);
                }
            }
        }
    }

    public void addOnSoftUninstalled(AddOn addOn, boolean successfully) {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            for (AddOnInstallationStatusListener listener : hook.getAddOnInstallationStatusListeners()) {
                try {
                    listener.addOnSoftUninstalled(addOn, successfully);
                }
                catch (Exception e) {
                    LOGGER.error("An error occurred while notifying: {}", (Object)listener.getClass().getCanonicalName(), (Object)e);
                }
            }
        }
    }

    public void addOnUninstalled(AddOn addOn, boolean successfully) {
        for (ExtensionHook hook : this.extensionHooks.values()) {
            for (AddOnInstallationStatusListener listener : hook.getAddOnInstallationStatusListeners()) {
                try {
                    listener.addOnUninstalled(addOn, successfully);
                }
                catch (Exception e) {
                    LOGGER.error("An error occurred while notifying: {}", (Object)listener.getClass().getCanonicalName(), (Object)e);
                }
            }
        }
    }

    public void startAllExtension(double progressFactor) {
        double factorPerc = progressFactor / (double)this.getExtensionCount();
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            Extension extension = this.getExtension(i);
            try {
                extension.start();
                if (!this.hasView()) continue;
                this.view.addSplashScreenLoadingCompletion(factorPerc);
                continue;
            }
            catch (Exception e) {
                ExtensionLoader.logExtensionInitError(extension, e);
            }
        }
    }

    public void startLifeCycle() {
        if (this.hasView()) {
            this.view.setSplashScreenLoadingCompletion(0.0);
        }
        this.initAllExtension(5.0);
        this.initModelAllExtension(this.model, 0.0);
        this.initXMLAllExtension(this.model.getSession(), this.model.getOptionsParam(), 0.0);
        this.initViewAllExtension(this.view, 10.0);
        this.hookAllExtension(75.0);
        this.startAllExtension(10.0);
        this.cmdLine = null;
    }

    public void startLifeCycle(Extension ext) throws DatabaseException, DatabaseUnsupportedException {
        this.setExtensionAdaptorView(ext);
        ext.init();
        ext.databaseOpen(this.model.getDb());
        ext.initModel(this.model);
        ext.initXML(this.model.getSession(), this.model.getOptionsParam());
        if (this.hasView()) {
            ext.initView(this.view);
        }
        ExtensionHook extHook = new ExtensionHook(this.model, this.view);
        this.extensionHooks.put(ext, extHook);
        try {
            CommandLineArgument[] arg;
            ext.hook(extHook);
            if (this.cmdLine != null && (arg = extHook.getCommandLineArgument()).length > 0 && ext instanceof CommandLineListener) {
                ArrayList<CommandLineArgument[]> allCommandLineList = new ArrayList<CommandLineArgument[]>();
                HashMap<String, CommandLineListener> extMap = new HashMap<String, CommandLineListener>();
                allCommandLineList.add(arg);
                CommandLineListener cli = (CommandLineListener)((Object)ext);
                List<String> extensions = cli.getHandledExtensions();
                if (extensions != null) {
                    for (String extension : extensions) {
                        extMap.put(extension, cli);
                    }
                }
                this.cmdLine.resetArgs();
                this.cmdLine.parse(allCommandLineList, extMap, false);
            }
            this.hookContextDataFactories(ext, extHook);
            this.hookApiImplementors(ext, extHook);
            this.hookHttpSenderListeners(ext, extHook);
            this.hookVariant(ext, extHook);
            this.hookHrefTypeInfo(ext, extHook);
            if (this.hasView()) {
                this.hookView(ext, this.view, extHook);
                this.hookMenu(this.view, extHook);
            }
            this.hookOptions(extHook);
            this.hookProxies(extHook);
            ext.optionsLoaded();
            ext.postInit();
        }
        catch (Exception e) {
            ExtensionLoader.logExtensionInitError(ext, e);
        }
        ext.start();
        if (this.hasView()) {
            ExtensionLoader.hookSiteMapListeners(this.view.getSiteTreePanel(), extHook.getSiteMapListenerList());
        }
    }

    private void setExtensionAdaptorView(Extension extension) {
        if (this.hasView() && extension instanceof ExtensionAdaptor) {
            ((ExtensionAdaptor)extension).setView(this.view);
        }
    }

    public void stopAllExtension() {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            try {
                this.getExtension(i).stop();
                continue;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void addParamPanel(List<AbstractParamPanel> panelList, AbstractParamDialog dialog) {
        String[] ROOT = new String[]{};
        for (AbstractParamPanel panel : panelList) {
            try {
                dialog.addParamPanel(ROOT, panel, true);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void removeParamPanel(List<AbstractParamPanel> panelList, AbstractParamDialog dialog) {
        for (AbstractParamPanel panel : panelList) {
            try {
                dialog.removeParamPanel(panel);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        dialog.revalidate();
    }

    private void hookAllExtension(double progressFactor) {
        int i;
        double factorPerc = progressFactor / (double)this.getExtensionCount();
        for (i = 0; i < this.getExtensionCount(); ++i) {
            Extension ext = this.getExtension(i);
            try {
                LOGGER.info("Initializing {} - {}", (Object)ext.getUIName(), (Object)ext.getDescription());
                ExtensionHook extHook = new ExtensionHook(this.model, this.view);
                this.extensionHooks.put(ext, extHook);
                ext.hook(extHook);
                this.hookContextDataFactories(ext, extHook);
                this.hookApiImplementors(ext, extHook);
                this.hookHttpSenderListeners(ext, extHook);
                this.hookVariant(ext, extHook);
                this.hookHrefTypeInfo(ext, extHook);
                if (this.hasView()) {
                    EventQueue.invokeAndWait(() -> {
                        this.hookView(ext, this.view, extHook);
                        this.hookMenu(this.view, extHook);
                        this.view.addSplashScreenLoadingCompletion(factorPerc);
                    });
                }
                this.hookOptions(extHook);
                this.hookProxies(extHook);
                ext.optionsLoaded();
                continue;
            }
            catch (Throwable e) {
                ExtensionLoader.logExtensionInitError(ext, e);
            }
        }
        for (i = 0; i < this.getExtensionCount(); ++i) {
            Extension extension = this.getExtension(i);
            try {
                extension.postInit();
                continue;
            }
            catch (Throwable e) {
                ExtensionLoader.logExtensionInitError(extension, e);
            }
        }
        if (this.hasView()) {
            try {
                EventQueue.invokeAndWait(() -> {
                    this.view.getMainFrame().getMainMenuBar().validate();
                    this.view.getMainFrame().validate();
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOGGER.warn("An error occurred while updating the UI:", (Throwable)e);
            }
        }
    }

    private static void logExtensionInitError(Extension extension, Throwable e) {
        StringBuilder strBuilder = new StringBuilder(150);
        strBuilder.append("Failed to initialise extension ");
        strBuilder.append(extension.getClass().getCanonicalName());
        AddOn addOn = extension.getAddOn();
        if (addOn != null) {
            strBuilder.append(" (from add-on ").append(addOn).append(')');
        }
        strBuilder.append(", cause: ");
        strBuilder.append(ExceptionUtils.getRootCauseMessage((Throwable)e));
        LOGGER.error((CharSequence)strBuilder, e);
    }

    private void hookContextDataFactories(Extension extension, ExtensionHook extHook) {
        for (ContextDataFactory contextDataFactory : extHook.getContextDataFactories()) {
            try {
                this.model.addContextDataFactory(contextDataFactory);
            }
            catch (Exception e) {
                LOGGER.error("Error while adding a ContextDataFactory from {}", (Object)extension.getClass().getCanonicalName(), (Object)e);
            }
        }
    }

    private void hookApiImplementors(Extension extension, ExtensionHook extHook) {
        for (ApiImplementor apiImplementor : extHook.getApiImplementors()) {
            try {
                API.getInstance().registerApiImplementor(apiImplementor);
            }
            catch (Exception e) {
                LOGGER.error("Error while adding an ApiImplementor from {}", (Object)extension.getClass().getCanonicalName(), (Object)e);
            }
        }
    }

    private void hookHttpSenderListeners(Extension extension, ExtensionHook extHook) {
        for (HttpSenderListener httpSenderListener : extHook.getHttpSenderListeners()) {
            try {
                HttpSender.addListener(httpSenderListener);
            }
            catch (Exception e) {
                LOGGER.error("Error while adding an HttpSenderListener from {}", (Object)extension.getClass().getCanonicalName(), (Object)e);
            }
        }
    }

    private void hookVariant(Extension extension, ExtensionHook extHook) {
        for (Class<? extends Variant> variant : extHook.getVariants()) {
            try {
                variant.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Model.getSingleton().getVariantFactory().addVariant(variant);
            }
            catch (Exception e) {
                LOGGER.error("Error while adding a Variant from {}", (Object)extension.getClass().getCanonicalName(), (Object)e);
            }
        }
    }

    private void hookHrefTypeInfo(Extension extension, ExtensionHook extHook) {
        for (HrefTypeInfo hrefTypeInfo : extHook.getHrefsTypeInfo()) {
            try {
                HrefTypeInfo.addType(hrefTypeInfo);
            }
            catch (Exception e) {
                LOGGER.error("Error while adding a HrefTypeInfo from {}", (Object)extension.getClass().getCanonicalName(), (Object)e);
            }
        }
    }

    public void hookCommandLineListener(CommandLine cmdLine) throws Exception {
        this.cmdLine = cmdLine;
        ArrayList<CommandLineArgument[]> allCommandLineList = new ArrayList<CommandLineArgument[]>();
        HashMap<String, CommandLineListener> extMap = new HashMap<String, CommandLineListener>();
        for (Map.Entry<Extension, ExtensionHook> entry : this.extensionHooks.entrySet()) {
            CommandLineListener cli;
            List<String> exts;
            Extension extension;
            ExtensionHook hook = entry.getValue();
            CommandLineArgument[] arg = hook.getCommandLineArgument();
            if (arg.length > 0) {
                allCommandLineList.add(arg);
            }
            if (!((extension = entry.getKey()) instanceof CommandLineListener) || (exts = (cli = (CommandLineListener)((Object)extension)).getHandledExtensions()) == null) continue;
            for (String ext : exts) {
                extMap.put(ext, cli);
            }
        }
        cmdLine.parse(allCommandLineList, extMap);
    }

    private void hookMenu(View view, ExtensionHook hook) {
        if (!this.hasView()) {
            return;
        }
        ExtensionHookMenu hookMenu = hook.getHookMenuNoInit();
        if (hookMenu == null) {
            return;
        }
        MainMenuBar menuBar = view.getMainFrame().getMainMenuBar();
        this.addMenuHelper(menuBar, hookMenu.getNewMenus(), 2);
        this.addMenuHelper(menuBar.getMenuFile(), hookMenu.getFile(), 2);
        this.addMenuHelper(menuBar.getMenuTools(), hookMenu.getTools(), 2);
        this.addMenuHelper(menuBar.getMenuEdit(), hookMenu.getEdit());
        this.addMenuHelper(menuBar.getMenuView(), hookMenu.getView());
        this.addMenuHelper(menuBar.getMenuAnalyse(), hookMenu.getAnalyse());
        this.addMenuHelper(menuBar.getMenuHelp(), hookMenu.getHelpMenus());
        this.addMenuHelper(menuBar.getMenuReport(), hookMenu.getReportMenus());
        this.addMenuHelper(menuBar.getMenuOnline(), hookMenu.getOnlineMenus());
        this.addMenuHelper(menuBar.getMenuImport(), hookMenu.getImport());
        this.addMenuHelper(view.getPopupList(), hookMenu.getPopupMenus());
    }

    private void addMenuHelper(JMenu menu, List<JMenuItem> items) {
        this.addMenuHelper(menu, items, 0);
    }

    private void addMenuHelper(JMenuBar menuBar, List<JMenuItem> items, int existingCount) {
        for (JMenuItem item : items) {
            if (item == null) continue;
            menuBar.add((Component)item, menuBar.getMenuCount() - existingCount);
        }
        menuBar.revalidate();
    }

    private void addMenuHelper(JMenu menu, List<JMenuItem> items, int existingCount) {
        for (JMenuItem item : items) {
            if (item == null) continue;
            if (item == ExtensionHookMenu.MENU_SEPARATOR) {
                menu.addSeparator();
                continue;
            }
            menu.add((Component)item, menu.getItemCount() - existingCount);
        }
        menu.revalidate();
    }

    private void addMenuHelper(List<JMenuItem> menuList, List<JMenuItem> items) {
        for (JMenuItem item : items) {
            if (item == null) continue;
            menuList.add(item);
        }
    }

    private void removeMenu(View view, ExtensionHook hook) {
        if (!this.hasView()) {
            return;
        }
        ExtensionHookMenu hookMenu = hook.getHookMenuNoInit();
        if (hookMenu == null) {
            return;
        }
        MainMenuBar menuBar = view.getMainFrame().getMainMenuBar();
        this.removeMenuHelper(menuBar, hookMenu.getNewMenus());
        this.removeMenuHelper(menuBar.getMenuFile(), hookMenu.getFile());
        this.removeMenuHelper(menuBar.getMenuTools(), hookMenu.getTools());
        this.removeMenuHelper(menuBar.getMenuEdit(), hookMenu.getEdit());
        this.removeMenuHelper(menuBar.getMenuView(), hookMenu.getView());
        this.removeMenuHelper(menuBar.getMenuAnalyse(), hookMenu.getAnalyse());
        this.removeMenuHelper(menuBar.getMenuHelp(), hookMenu.getHelpMenus());
        this.removeMenuHelper(menuBar.getMenuReport(), hookMenu.getReportMenus());
        this.removeMenuHelper(menuBar.getMenuOnline(), hookMenu.getOnlineMenus());
        this.removeMenuHelper(menuBar.getMenuImport(), hookMenu.getImport());
        this.removeMenuHelper(view.getPopupList(), hookMenu.getPopupMenus());
    }

    private void removeMenuHelper(JMenuBar menuBar, List<JMenuItem> items) {
        for (JMenuItem item : items) {
            if (item == null) continue;
            menuBar.remove(item);
        }
        menuBar.revalidate();
    }

    private void removeMenuHelper(JMenu menu, List<JMenuItem> items) {
        for (JMenuItem item : items) {
            if (item == null) continue;
            menu.remove(item);
        }
        menu.revalidate();
    }

    private void removeMenuHelper(List<JMenuItem> menuList, List<JMenuItem> items) {
        for (JMenuItem item : items) {
            if (item == null) continue;
            menuList.remove(item);
        }
    }

    private void hookOptions(ExtensionHook hook) {
        Vector<AbstractParam> list = hook.getOptionsParamSetList();
        for (AbstractParam paramSet : list) {
            try {
                this.model.getOptionsParam().addParamSet(paramSet);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void unloadOptions(ExtensionHook hook) {
        Vector<AbstractParam> list = hook.getOptionsParamSetList();
        for (AbstractParam paramSet : list) {
            try {
                this.model.getOptionsParam().removeParamSet(paramSet);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void hookView(Extension extension, View view, ExtensionHook hook) {
        if (!this.hasView()) {
            return;
        }
        ExtensionHookView pv = hook.getHookViewNoInit();
        if (pv == null) {
            return;
        }
        for (ContextPanelFactory contextPanelFactory : pv.getContextPanelFactories()) {
            try {
                view.addContextPanelFactory(contextPanelFactory);
            }
            catch (Exception e) {
                LOGGER.error("Error while adding a ContextPanelFactory from {}", (Object)extension.getClass().getCanonicalName(), (Object)e);
            }
        }
        MainToolbarPanel mainToolBarPanel = view.getMainFrame().getMainToolbarPanel();
        for (Component component : pv.getMainToolBarComponents()) {
            try {
                mainToolBarPanel.addToolBarComponent(component);
            }
            catch (Exception e) {
                LOGGER.error("Error while adding a component to the main tool bar panel, from {}", (Object)extension.getClass().getCanonicalName(), (Object)e);
            }
        }
        view.getWorkbench().addPanels(pv.getSelectPanel(), WorkbenchPanel.PanelType.SELECT);
        view.getWorkbench().addPanels(pv.getWorkPanel(), WorkbenchPanel.PanelType.WORK);
        view.getWorkbench().addPanels(pv.getStatusPanel(), WorkbenchPanel.PanelType.STATUS);
        this.addParamPanel(pv.getSessionPanel(), view.getSessionDialog());
        this.addParamPanel(pv.getOptionsPanel(), view.getOptionsDialog(""));
        for (DisplayedMessageChangedListener changedListener : pv.getRequestPanelDisplayedMessageChangedListeners()) {
            view.getRequestPanel().addDisplayedMessageChangedListener(changedListener);
        }
        for (DisplayedMessageChangedListener changedListener : pv.getResponsePanelDisplayedMessageChangedListeners()) {
            view.getResponsePanel().addDisplayedMessageChangedListener(changedListener);
        }
    }

    private void removeView(Extension extension, View view, ExtensionHook hook) {
        if (!this.hasView()) {
            return;
        }
        ExtensionHookView pv = hook.getHookViewNoInit();
        if (pv == null) {
            return;
        }
        for (ContextPanelFactory contextPanelFactory : pv.getContextPanelFactories()) {
            try {
                view.removeContextPanelFactory(contextPanelFactory);
            }
            catch (Exception e) {
                LOGGER.error("Error while removing a ContextPanelFactory from {}", (Object)extension.getClass().getCanonicalName(), (Object)e);
            }
        }
        MainToolbarPanel mainToolBarPanel = view.getMainFrame().getMainToolbarPanel();
        for (Component component : pv.getMainToolBarComponents()) {
            try {
                mainToolBarPanel.removeToolBarComponent(component);
            }
            catch (Exception e) {
                LOGGER.error("Error while removing a component from the main tool bar panel, from {}", (Object)extension.getClass().getCanonicalName(), (Object)e);
            }
        }
        view.getWorkbench().removePanels(pv.getSelectPanel(), WorkbenchPanel.PanelType.SELECT);
        view.getWorkbench().removePanels(pv.getWorkPanel(), WorkbenchPanel.PanelType.WORK);
        view.getWorkbench().removePanels(pv.getStatusPanel(), WorkbenchPanel.PanelType.STATUS);
        if (!(pv.getSelectPanel().isEmpty() && pv.getWorkPanel().isEmpty() && pv.getStatusPanel().isEmpty())) {
            view.refreshTabViewMenus();
        }
        this.removeParamPanel(pv.getSessionPanel(), view.getSessionDialog());
        this.removeParamPanel(pv.getOptionsPanel(), view.getOptionsDialog(""));
        for (DisplayedMessageChangedListener changedListener : pv.getRequestPanelDisplayedMessageChangedListeners()) {
            view.getRequestPanel().removeDisplayedMessageChangedListener(changedListener);
        }
        for (DisplayedMessageChangedListener changedListener : pv.getResponsePanelDisplayedMessageChangedListeners()) {
            view.getResponsePanel().removeDisplayedMessageChangedListener(changedListener);
        }
    }

    public void removeStatusPanel(AbstractPanel panel) {
        if (!this.hasView()) {
            return;
        }
        this.view.getWorkbench().removePanel(panel, WorkbenchPanel.PanelType.STATUS);
    }

    public void removeOptionsPanel(AbstractParamPanel panel) {
        if (!this.hasView()) {
            return;
        }
        this.view.getOptionsDialog("").removeParamPanel(panel);
    }

    public void removeOptionsParamSet(AbstractParam params) {
        this.model.getOptionsParam().removeParamSet(params);
    }

    public void removeWorkPanel(AbstractPanel panel) {
        if (!this.hasView()) {
            return;
        }
        this.view.getWorkbench().removePanel(panel, WorkbenchPanel.PanelType.WORK);
    }

    public void removePopupMenuItem(ExtensionPopupMenuItem popupMenuItem) {
        if (!this.hasView()) {
            return;
        }
        this.view.getPopupList().remove(popupMenuItem);
    }

    public void removeFileMenuItem(JMenuItem menuItem) {
        if (!this.hasView()) {
            return;
        }
        this.view.getMainFrame().getMainMenuBar().getMenuFile().remove(menuItem);
    }

    public void removeEditMenuItem(JMenuItem menuItem) {
        if (!this.hasView()) {
            return;
        }
        this.view.getMainFrame().getMainMenuBar().getMenuEdit().remove(menuItem);
    }

    public void removeViewMenuItem(JMenuItem menuItem) {
        if (!this.hasView()) {
            return;
        }
        this.view.getMainFrame().getMainMenuBar().getMenuView().remove(menuItem);
    }

    public void removeToolsMenuItem(JMenuItem menuItem) {
        if (!this.hasView()) {
            return;
        }
        this.view.getMainFrame().getMainMenuBar().getMenuTools().remove(menuItem);
    }

    public void removeHelpMenuItem(JMenuItem menuItem) {
        if (!this.hasView()) {
            return;
        }
        this.view.getMainFrame().getMainMenuBar().getMenuHelp().remove(menuItem);
    }

    public void removeReportMenuItem(JMenuItem menuItem) {
        if (!this.hasView()) {
            return;
        }
        this.view.getMainFrame().getMainMenuBar().getMenuReport().remove(menuItem);
    }

    private void initAllExtension(double progressFactor) {
        double factorPerc = progressFactor / (double)this.getExtensionCount();
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            Extension extension = this.getExtension(i);
            try {
                this.setExtensionAdaptorView(extension);
                extension.init();
                extension.databaseOpen(Model.getSingleton().getDb());
                if (!this.hasView()) continue;
                this.view.addSplashScreenLoadingCompletion(factorPerc);
                continue;
            }
            catch (Throwable e) {
                ExtensionLoader.logExtensionInitError(extension, e);
            }
        }
    }

    private void initModelAllExtension(Model model, double progressFactor) {
        double factorPerc = progressFactor / (double)this.getExtensionCount();
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            Extension extension = this.getExtension(i);
            try {
                extension.initModel(model);
                if (!this.hasView()) continue;
                this.view.addSplashScreenLoadingCompletion(factorPerc);
                continue;
            }
            catch (Exception e) {
                ExtensionLoader.logExtensionInitError(extension, e);
            }
        }
    }

    private void initViewAllExtension(View view, double progressFactor) {
        if (!this.hasView()) {
            return;
        }
        double factorPerc = progressFactor / (double)this.getExtensionCount();
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            Extension extension = this.getExtension(i);
            try {
                EventQueue.invokeAndWait(() -> {
                    extension.initView(view);
                    view.addSplashScreenLoadingCompletion(factorPerc);
                });
                continue;
            }
            catch (Exception e) {
                ExtensionLoader.logExtensionInitError(extension, e);
            }
        }
    }

    private void initXMLAllExtension(Session session, OptionsParam options, double progressFactor) {
        double factorPerc = progressFactor / (double)this.getExtensionCount();
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            Extension extension = this.getExtension(i);
            try {
                extension.initXML(session, options);
                if (!this.hasView()) continue;
                this.view.addSplashScreenLoadingCompletion(factorPerc);
                continue;
            }
            catch (Exception e) {
                ExtensionLoader.logExtensionInitError(extension, e);
            }
        }
    }

    public void removeExtension(Extension extension) {
        this.extensionList.remove(extension);
        this.extensionsMap.remove(extension.getClass());
        extension.stop();
        this.unhook(extension);
        extension.destroy();
    }

    private void unhook(Extension extension) {
        ExtensionHook hook = this.extensionHooks.remove(extension);
        if (hook == null) {
            LOGGER.error("ExtensionHook not found for: {}", (Object)extension.getClass().getCanonicalName());
            return;
        }
        this.unloadOptions(hook);
        this.unhookProxies(hook);
        this.removeSiteMapListener(hook);
        for (ContextDataFactory contextDataFactory : hook.getContextDataFactories()) {
            try {
                this.model.removeContextDataFactory(contextDataFactory);
            }
            catch (Exception e) {
                LOGGER.error("Error while removing a ContextDataFactory from {}", (Object)extension.getClass().getCanonicalName(), (Object)e);
            }
        }
        for (ApiImplementor apiImplementor : hook.getApiImplementors()) {
            try {
                API.getInstance().removeApiImplementor(apiImplementor);
            }
            catch (Exception e) {
                LOGGER.error("Error while removing an ApiImplementor from {}", (Object)extension.getClass().getCanonicalName(), (Object)e);
            }
        }
        for (HttpSenderListener httpSenderListener : hook.getHttpSenderListeners()) {
            try {
                HttpSender.removeListener(httpSenderListener);
            }
            catch (Exception e) {
                LOGGER.error("Error while removing an HttpSenderListener from {}", (Object)extension.getClass().getCanonicalName(), (Object)e);
            }
        }
        for (Class clazz : hook.getVariants()) {
            try {
                this.model.getVariantFactory().removeVariant(clazz);
            }
            catch (Exception e) {
                LOGGER.error("Error while removing a Variant from {}", (Object)extension.getClass().getCanonicalName(), (Object)e);
            }
        }
        for (HrefTypeInfo hrefTypeInfo : hook.getHrefsTypeInfo()) {
            try {
                HrefTypeInfo.removeType(hrefTypeInfo);
            }
            catch (Exception e) {
                LOGGER.error("Error while removing a HrefTypeInfo from {}", (Object)extension.getClass().getCanonicalName(), (Object)e);
            }
        }
        this.removeViewInEDT(extension, hook);
    }

    private void removeViewInEDT(Extension extension, ExtensionHook hook) {
        if (!this.hasView()) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.removeView(extension, this.view, hook);
            this.removeMenu(this.view, hook);
        } else {
            EventQueue.invokeLater(() -> this.removeViewInEDT(extension, hook));
        }
    }

    public List<String> getUnsavedResources() {
        return this.collectMessages(Extension::getUnsavedResources);
    }

    private List<String> collectMessages(Function<Extension, List<String>> function) {
        return this.extensionList.stream().map(e -> {
            try {
                List messages = (List)function.apply((Extension)e);
                if (messages != null) {
                    return messages;
                }
            }
            catch (Throwable ex) {
                LOGGER.error("Error while getting messages from {}", (Object)e.getClass().getCanonicalName(), (Object)ex);
            }
            return Collections.emptyList();
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<String> getActiveActions() {
        return this.collectMessages(Extension::getActiveActions);
    }
}

