/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.extension.help.ExtensionHelp;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.panelsearch.ComponentHighlighterProvider;
import org.zaproxy.zap.view.panelsearch.ComponentSearchProvider;
import org.zaproxy.zap.view.panelsearch.SearchAndHighlight;
import org.zaproxy.zap.view.panelsearch.items.AbstractComponentSearch;
import org.zaproxy.zap.view.panelsearch.items.TreeNodeElement;
import org.zaproxy.zap.view.panelsearch.items.TreeUtils;

public class AbstractParamContainerPanel
extends JSplitPane {
    public static final String DEFAULT_ROOT_NODE_NAME = "Root";
    private static final long serialVersionUID = -5223178126156052670L;
    protected Object paramObject = null;
    private int panelIdCounter;
    private List<AbstractParamPanel> panels = new ArrayList<AbstractParamPanel>();
    private Map<AbstractParamPanel, ParamTreeNode> panelsToTreeNodes = new HashMap<AbstractParamPanel, ParamTreeNode>();
    private JButton btnHelp = null;
    private JPanel jPanel = null;
    private JTree treeParam = null;
    private JPanel jPanel1 = null;
    private JPanel panelParam = null;
    private JPanel panelHeadline = null;
    private ZapTextField txtHeadline = null;
    private DefaultTreeModel treeModel = null;
    private ParamTreeNode rootNode;
    private JScrollPane jScrollPane = null;
    private JScrollPane jScrollPane1 = null;
    private JPanel leftPanel;
    private ZapTextField searchTextField;
    private JButton btnSearch;
    private JButton btnClearSearch;
    private JToolBar searchToolBar;
    private SearchAndHighlight searchAndHighlight;
    private ParamTreeNode nodeLastSelectedPanel;
    private AbstractParamPanel currentShownPanel;
    private ShowHelpAction showHelpAction = null;
    private static final Logger LOGGER = LogManager.getLogger(AbstractParamContainerPanel.class);

    public AbstractParamContainerPanel() {
        this.initialize();
    }

    public AbstractParamContainerPanel(String rootName) {
        this.initialize();
        this.getRootNode().setUserObject(rootName);
    }

    private void initialize() {
        this.setContinuousLayout(true);
        this.setRightComponent(this.getJPanel1());
        this.setDividerLocation(DisplayUtils.getScaledSize(200));
        this.setDividerSize(DisplayUtils.getScaledSize(3));
        this.setResizeWeight(0.3);
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.setLeftComponent(this.getLeftPanel());
        this.searchAndHighlight = new SearchAndHighlight(this);
        this.searchAndHighlight.registerComponentSearch(new AbstractParamContainerPanelComponentSearch());
        this.searchAndHighlight.registerComponentHighlighter(new AbstractParamContainerPanelComponentSearch());
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridwidth = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setName("jPanel");
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.ipadx = 0;
            gridBagConstraints5.ipady = 0;
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.insets = new Insets(2, 5, 5, 0);
            gridBagConstraints5.anchor = 18;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.insets = new Insets(2, 5, 5, 0);
            this.jPanel.add((Component)this.getPanelHeadline(), gridBagConstraints7);
            this.jPanel.add((Component)this.getPanelParam(), gridBagConstraints5);
            GridBagConstraints gbc_button = new GridBagConstraints();
            gbc_button.insets = new Insets(0, 5, 0, 5);
            gbc_button.gridx = 1;
            gbc_button.gridy = 0;
            this.jPanel.add((Component)this.getHelpButton(), gbc_button);
        }
        return this.jPanel;
    }

    private JTree getTreeParam() {
        if (this.treeParam == null) {
            this.treeParam = new JTree();
            this.treeParam.setModel(this.getTreeModel());
            this.treeParam.setShowsRootHandles(true);
            this.treeParam.setRootVisible(true);
            this.treeParam.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    ParamTreeNode node = (ParamTreeNode)AbstractParamContainerPanel.this.getTreeParam().getLastSelectedPathComponent();
                    if (node == null) {
                        return;
                    }
                    if (node.getParamPanel() == null) {
                        if (node.getChildCount() == 0) {
                            return;
                        }
                        node = (ParamTreeNode)node.getFirstChild();
                    }
                    AbstractParamContainerPanel.this.showParamPanel(node);
                }
            });
            DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
            renderer.setLeafIcon(null);
            renderer.setOpenIcon(null);
            renderer.setClosedIcon(null);
            this.treeParam.setCellRenderer(renderer);
            this.treeParam.setRowHeight(DisplayUtils.getScaledSize(18));
            this.treeParam.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    TreePath path = AbstractParamContainerPanel.this.treeParam.getClosestPathForLocation(e.getX(), e.getY());
                    if (path != null && !AbstractParamContainerPanel.this.treeParam.isPathSelected(path)) {
                        AbstractParamContainerPanel.this.treeParam.setSelectionPath(path);
                    }
                }
            });
        }
        return this.treeParam;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new CardLayout());
            this.jPanel1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.jPanel1.add((Component)this.getJScrollPane1(), this.getJScrollPane1().getName());
        }
        return this.jPanel1;
    }

    private JPanel getPanelParam() {
        if (this.panelParam == null) {
            this.panelParam = new JPanel();
            this.panelParam.setLayout(new CardLayout());
            this.panelParam.setPreferredSize(new Dimension(300, 300));
            this.panelParam.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        return this.panelParam;
    }

    private JPanel getPanelHeadline() {
        if (this.panelHeadline == null) {
            this.panelHeadline = new JPanel();
            this.panelHeadline.setLayout(new BorderLayout(0, 0));
            this.txtHeadline = this.getTxtHeadline();
            this.panelHeadline.add((Component)this.txtHeadline, "Center");
            JButton button = this.getHelpButton();
            this.panelHeadline.add((Component)button, "East");
        }
        return this.panelHeadline;
    }

    private ZapTextField getTxtHeadline() {
        if (this.txtHeadline == null) {
            this.txtHeadline = new ZapTextField();
            this.txtHeadline.setBorder(BorderFactory.createEtchedBorder(0));
            this.txtHeadline.setEditable(false);
            this.txtHeadline.setEnabled(false);
            this.txtHeadline.setFont(FontUtils.getFont(1));
        }
        return this.txtHeadline;
    }

    private DefaultTreeModel getTreeModel() {
        if (this.treeModel == null) {
            this.treeModel = new DefaultTreeModel(this.getRootNode());
            this.treeModel.setRoot(this.getRootNode());
        }
        return this.treeModel;
    }

    protected DefaultMutableTreeNode getRootNode() {
        if (this.rootNode == null) {
            this.rootNode = new ParamTreeNode(this.panelIdCounter++, DEFAULT_ROOT_NODE_NAME);
        }
        return this.rootNode;
    }

    private ParamTreeNode addParamNode(String[] paramSeq, boolean sort) {
        String param = null;
        ParamTreeNode parent = (ParamTreeNode)this.getRootNode();
        ParamTreeNode child = null;
        ParamTreeNode result = null;
        for (int i = 0; i < paramSeq.length; ++i) {
            param = paramSeq[i];
            result = null;
            for (int j = 0; j < parent.getChildCount(); ++j) {
                child = (ParamTreeNode)parent.getChildAt(j);
                if (!child.toString().equalsIgnoreCase(param)) continue;
                result = child;
                break;
            }
            if (result == null) {
                result = new ParamTreeNode(this.panelIdCounter++, param);
                this.addNewNode(parent, result, sort);
            }
            parent = result;
        }
        return parent;
    }

    private void addNewNode(ParamTreeNode parent, ParamTreeNode node, boolean sort) {
        int pos;
        if (!sort) {
            this.getTreeModel().insertNodeInto(node, parent, parent.getChildCount());
            return;
        }
        String name = node.toString();
        for (pos = 0; pos < parent.getChildCount() && name.compareToIgnoreCase(parent.getChildAt(pos).toString()) >= 0; ++pos) {
        }
        this.getTreeModel().insertNodeInto(node, parent, pos);
    }

    public void addParamPanel(String[] parentParams, String name, AbstractParamPanel panel, boolean sort) {
        ParamTreeNode node;
        if (parentParams != null) {
            node = new ParamTreeNode(this.panelIdCounter++, name, panel);
            this.addNewNode(this.addParamNode(parentParams, sort), node, sort);
        } else {
            node = (ParamTreeNode)this.getRootNode();
            node.setParamPanel(panel);
        }
        panel.setName(name);
        this.getPanelParam().add((Component)panel, node.getPanelId());
        this.panels.add(panel);
        this.panelsToTreeNodes.put(node.getParamPanel(), node);
        this.registerSearchAndHighlightComponents(panel);
    }

    private void registerSearchAndHighlightComponents(AbstractParamPanel panel) {
        if (panel instanceof ComponentSearchProvider) {
            this.searchAndHighlight.registerComponentSearch((ComponentSearchProvider)((Object)panel));
        }
        if (panel instanceof ComponentHighlighterProvider) {
            this.searchAndHighlight.registerComponentHighlighter((ComponentHighlighterProvider)((Object)panel));
        }
        this.searchAndHighlight.clearHighlight();
    }

    public void addParamPanel(String[] parentParams, AbstractParamPanel panel, boolean sort) {
        this.addParamPanel(parentParams, panel.getName(), panel, sort);
    }

    public void removeParamPanel(AbstractParamPanel panel) {
        ParamTreeNode node;
        if (this.currentShownPanel == panel) {
            this.currentShownPanel = null;
            this.nodeLastSelectedPanel = null;
            if (this.isShowing()) {
                if (this.panels.isEmpty()) {
                    this.getTxtHeadline().setText("");
                    this.getHelpButton().setVisible(false);
                } else {
                    this.getTreeParam().setSelectionPath(new TreePath(this.getFirstAvailableNode().getPath()));
                }
            }
        }
        if ((node = this.panelsToTreeNodes.remove(panel)) != null) {
            this.removeNode(node);
        }
        this.removeSearchAndHighlightComponents(panel);
        this.getPanelParam().remove(panel);
        this.panels.remove(panel);
    }

    private void removeNode(ParamTreeNode node) {
        ParamTreeNode parent = (ParamTreeNode)node.getParent();
        this.getTreeModel().removeNodeFromParent(node);
        if (!parent.isRoot() && parent.getChildCount() == 0 && this.getParamPanel((String)parent.getUserObject()) == null) {
            this.removeNode(parent);
        }
    }

    private void removeSearchAndHighlightComponents(AbstractParamPanel panel) {
        if (panel instanceof ComponentSearchProvider) {
            this.searchAndHighlight.removeComponentSearch((ComponentSearchProvider)((Object)panel));
        }
        if (panel instanceof ComponentHighlighterProvider) {
            this.searchAndHighlight.removeComponentHighlighter((ComponentHighlighterProvider)((Object)panel));
        }
        this.searchAndHighlight.clearHighlight();
    }

    private ParamTreeNode getFirstAvailableNode() {
        if (((ParamTreeNode)this.getTreeModel().getRoot()).getChildCount() > 0) {
            return (ParamTreeNode)((ParamTreeNode)this.getTreeModel().getRoot()).getChildAt(0);
        }
        return this.panelsToTreeNodes.get(this.panels.get(0));
    }

    public void showParamPanel(String parent, String child) {
        if (parent == null || child == null) {
            return;
        }
        AbstractParamPanel panel = this.getParamPanel(parent);
        if (panel == null) {
            return;
        }
        this.showParamPanel(panel);
    }

    public void showParamPanel(String name) {
        if (name == null || name.equals("")) {
            return;
        }
        AbstractParamPanel panel = this.getParamPanel(name);
        if (panel == null) {
            return;
        }
        this.showParamPanel(panel);
    }

    private AbstractParamPanel getParamPanel(String name) {
        return this.panels.stream().filter(e -> name.equals(e.getName())).findFirst().orElse(null);
    }

    public void showParamPanel(AbstractParamPanel panel, String name) {
        this.showParamPanel(panel);
    }

    private void showParamPanel(AbstractParamPanel panel) {
        this.showParamPanel(this.panelsToTreeNodes.get(panel));
    }

    private void showParamPanel(ParamTreeNode node) {
        if (node == null) {
            return;
        }
        AbstractParamPanel panel = node.getParamPanel();
        if (this.currentShownPanel == panel) {
            return;
        }
        if (this.currentShownPanel != null) {
            this.currentShownPanel.onHide();
        }
        this.nodeLastSelectedPanel = node;
        this.currentShownPanel = panel;
        TreePath nodePath = new TreePath(node.getPath());
        this.getTreeParam().setSelectionPath(nodePath);
        this.ensureNodeVisible(nodePath);
        this.getPanelHeadline();
        this.getTxtHeadline().setText(panel.getName());
        this.getHelpButton().setVisible(panel.getHelpIndex() != null);
        this.getShowHelpAction().setHelpIndex(panel.getHelpIndex());
        CardLayout card = (CardLayout)this.getPanelParam().getLayout();
        card.show(this.getPanelParam(), node.getPanelId());
        panel.onShow();
    }

    private void ensureNodeVisible(TreePath nodePath) {
        Rectangle bounds = this.getTreeParam().getPathBounds(nodePath);
        if (!this.getTreeParam().getVisibleRect().contains(bounds)) {
            bounds.x = 0;
            this.getTreeParam().scrollRectToVisible(bounds);
        }
    }

    public void initParam(Object obj) {
        this.paramObject = obj;
        this.panels.forEach(e -> e.initParam(obj));
    }

    public void validateParam() throws Exception {
        for (AbstractParamPanel panel : this.panels) {
            try {
                panel.validateParam(this.paramObject);
            }
            catch (NullPointerException e) {
                LOGGER.error("Failed to validate the panel: ", (Throwable)e);
                AbstractParamContainerPanel.showInternalError(e);
            }
            catch (Exception e) {
                this.showParamPanel(panel);
                throw e;
            }
        }
    }

    private static void showInternalError(Exception e) {
        ErrorInfo errorInfo = new ErrorInfo(Constant.messages.getString("generic.error.internal.title"), Constant.messages.getString("generic.error.internal.msg"), null, null, (Throwable)e, null, null);
        JXErrorPane.showDialog(null, (ErrorInfo)errorInfo);
    }

    public void saveParam() throws Exception {
        for (AbstractParamPanel panel : this.panels) {
            try {
                panel.saveParam(this.paramObject);
            }
            catch (NullPointerException e) {
                LOGGER.error("Failed to save the panel: ", (Throwable)e);
                AbstractParamContainerPanel.showInternalError(e);
            }
        }
    }

    public void expandRoot() {
        this.getTreeParam().expandPath(new TreePath(this.getRootNode()));
    }

    public void expandParamPanelNode(String panelName) {
        ParamTreeNode node = this.getTreeNodeFromPanelName(panelName);
        if (node != null) {
            this.getTreeParam().expandPath(new TreePath(node.getPath()));
        }
    }

    public boolean isParamPanelSelected(String panelName) {
        ParamTreeNode node = this.getTreeNodeFromPanelName(panelName);
        if (node != null) {
            return this.getTreeParam().isPathSelected(new TreePath(node.getPath()));
        }
        return false;
    }

    public boolean isParamPanelOrChildSelected(String panelName) {
        ParamTreeNode node = this.getTreeNodeFromPanelName(panelName);
        if (node != null) {
            TreePath panelPath = new TreePath(node.getPath());
            if (this.getTreeParam().isPathSelected(panelPath)) {
                return true;
            }
            TreePath selectedPath = this.getTreeParam().getSelectionPath();
            return selectedPath != null && panelPath.equals(selectedPath.getParentPath());
        }
        return false;
    }

    public void showDialog(boolean showRoot) {
        this.showDialog(showRoot, null);
    }

    public void showDialog(boolean showRoot, String panel) {
        this.expandRoot();
        try {
            ParamTreeNode node = null;
            if (panel != null) {
                node = this.getTreeNodeFromPanelName(panel);
            }
            if (node == null) {
                if (this.nodeLastSelectedPanel != null) {
                    node = this.nodeLastSelectedPanel;
                } else if (showRoot) {
                    node = (ParamTreeNode)this.getRootNode();
                } else if (((ParamTreeNode)this.getRootNode()).getChildCount() > 0) {
                    node = (ParamTreeNode)((ParamTreeNode)this.getRootNode()).getChildAt(0);
                }
            }
            if (node != null) {
                this.showParamPanel(node);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    protected Collection<AbstractParamPanel> getPanels() {
        return this.panels;
    }

    private ParamTreeNode getTreeNodeFromPanelName(String panel) {
        return this.getTreeNodeFromPanelName((ParamTreeNode)this.getTreeModel().getRoot(), panel);
    }

    private ParamTreeNode getTreeNodeFromPanelName(ParamTreeNode parent, String panel) {
        if (panel.equals(parent.toString())) {
            return parent;
        }
        ParamTreeNode node = null;
        Enumeration<TreeNode> children = parent.children();
        while (children.hasMoreElements()) {
            ParamTreeNode child = (ParamTreeNode)children.nextElement();
            if (panel.equals(child.toString())) {
                node = child;
                break;
            }
            node = this.getTreeNodeFromPanelName(child, panel);
            if (node == null) continue;
            break;
        }
        return node;
    }

    public void printTree() {
        this.printTree((ParamTreeNode)this.getTreeModel().getRoot(), 0);
    }

    private void printTree(ParamTreeNode parent, int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print(" ");
        }
        System.out.print(parent.toString());
        AbstractParamPanel panel = parent.getParamPanel();
        if (panel != null) {
            System.out.print(" (" + panel.hashCode() + ")");
        }
        System.out.println();
        Enumeration<TreeNode> children = parent.children();
        while (children.hasMoreElements()) {
            ParamTreeNode child = (ParamTreeNode)children.nextElement();
            this.printTree(child, level + 1);
        }
    }

    public void renamePanel(AbstractParamPanel panel, String newPanelName) {
        ParamTreeNode node = this.panelsToTreeNodes.get(panel);
        ParamTreeNode newNode = this.getTreeNodeFromPanelName(newPanelName);
        if (node != null && newNode == null) {
            node.setUserObject(newPanelName);
            panel.setName(newPanelName);
            this.getTreeModel().nodeChanged(node);
        }
    }

    private JPanel getLeftPanel() {
        if (this.leftPanel == null) {
            this.leftPanel = new JPanel();
            this.leftPanel.setLayout(new BorderLayout());
            this.leftPanel.add((Component)this.getSearchToolbar(), "First");
            this.leftPanel.add((Component)this.getJScrollPane(), "Center");
        }
        return this.leftPanel;
    }

    private JToolBar getSearchToolbar() {
        if (this.searchToolBar == null) {
            this.searchToolBar = new JToolBar();
            this.searchToolBar.setLayout(new GridBagLayout());
            this.searchToolBar.setEnabled(true);
            this.searchToolBar.setFloatable(false);
            this.searchToolBar.setRollover(true);
            this.searchToolBar.setName("SearchToolbar");
            GridBagConstraints cons = new GridBagConstraints();
            cons.fill = 2;
            cons.insets = new Insets(0, 0, 0, 0);
            cons.weightx = 1.0;
            cons.gridx = 0;
            this.searchToolBar.add((Component)this.getSearchTextField(), cons);
            cons.weightx = 0.0;
            cons.gridx = 1;
            this.searchToolBar.add((Component)this.getSearchButton(), cons);
            cons.weightx = 0.0;
            cons.gridx = 2;
            this.searchToolBar.add((Component)this.getClearSearchButton(), cons);
        }
        return this.searchToolBar;
    }

    private ZapTextField getSearchTextField() {
        if (this.searchTextField == null) {
            this.searchTextField = new ZapTextField();
            this.searchTextField.setPrompt(Constant.messages.getString("paramcontainer.panel.searchbar.prompt"));
            this.searchTextField.setToolTipText(Constant.messages.getString("paramcontainer.panel.searchbar.tooltip"));
            this.searchTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        AbstractParamContainerPanel.this.searchAndHighlight.searchAndHighlight(AbstractParamContainerPanel.this.searchTextField.getText());
                    }
                }
            });
        }
        return this.searchTextField;
    }

    private JButton getSearchButton() {
        if (this.btnSearch == null) {
            this.btnSearch = new JButton();
            this.btnSearch.setIcon(new ImageIcon(AbstractParamContainerPanel.class.getResource("/resource/icon/16/049.png")));
            this.btnSearch.setToolTipText(Constant.messages.getString("paramcontainer.panel.search.tooltip"));
            this.btnSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractParamContainerPanel.this.searchAndHighlight.searchAndHighlight(AbstractParamContainerPanel.this.searchTextField.getText());
                }
            });
        }
        return this.btnSearch;
    }

    private JButton getClearSearchButton() {
        if (this.btnClearSearch == null) {
            this.btnClearSearch = new JButton();
            this.btnClearSearch.setIcon(new ImageIcon(AbstractParamContainerPanel.class.getResource("/resource/icon/16/101.png")));
            this.btnClearSearch.setToolTipText(Constant.messages.getString("paramcontainer.panel.clear.tooltip"));
            this.btnClearSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractParamContainerPanel.this.searchTextField.setText("");
                    AbstractParamContainerPanel.this.searchAndHighlight.clearHighlight();
                }
            });
        }
        return this.btnClearSearch;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTreeParam());
            this.jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        return this.jScrollPane;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setName("jScrollPane1");
            this.jScrollPane1.setViewportView(this.getJPanel());
            this.jScrollPane1.setHorizontalScrollBarPolicy(31);
            this.jScrollPane1.setVerticalScrollBarPolicy(21);
        }
        return this.jScrollPane1;
    }

    private JButton getHelpButton() {
        if (this.btnHelp == null) {
            this.btnHelp = new JButton();
            this.btnHelp.setBorder(BorderFactory.createEmptyBorder());
            this.btnHelp.setIcon(ExtensionHelp.getHelpIcon());
            this.btnHelp.addActionListener(this.getShowHelpAction());
            this.btnHelp.setToolTipText(Constant.messages.getString("menu.help"));
        }
        return this.btnHelp;
    }

    private ShowHelpAction getShowHelpAction() {
        if (this.showHelpAction == null) {
            this.showHelpAction = new ShowHelpAction();
        }
        return this.showHelpAction;
    }

    static class AbstractParamContainerPanelComponentSearch
    extends AbstractComponentSearch<AbstractParamContainerPanel> {
        AbstractParamContainerPanelComponentSearch() {
        }

        @Override
        protected Object[] getComponentsInternal(AbstractParamContainerPanel component) {
            ArrayList<TreeNodeElement> treeNodeElements = TreeUtils.getTreeNodeElement(component.getTreeParam());
            for (TreeNodeElement treeNodeElement : treeNodeElements) {
                AbstractParamPanel panel = component.getParamPanel(treeNodeElement.getNode().toString());
                treeNodeElement.addFakeObjectModelChildren(panel);
            }
            return treeNodeElements.toArray();
        }
    }

    private static class ParamTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        private final String panelId;
        private AbstractParamPanel paramPanel;

        ParamTreeNode(int panelId, String name) {
            this(panelId, name, null);
        }

        ParamTreeNode(int panelId, String name, AbstractParamPanel paramPanel) {
            this.panelId = String.valueOf(panelId);
            this.setUserObject(name);
            this.setParamPanel(paramPanel);
        }

        void setParamPanel(AbstractParamPanel paramPanel) {
            this.paramPanel = paramPanel;
        }

        String getPanelId() {
            return this.panelId;
        }

        AbstractParamPanel getParamPanel() {
            return this.paramPanel;
        }
    }

    private static final class ShowHelpAction
    implements ActionListener {
        private String helpIndex = null;

        private ShowHelpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.helpIndex != null) {
                ExtensionHelp.showHelp(this.helpIndex);
            }
        }

        public void setHelpIndex(String helpIndex) {
            this.helpIndex = helpIndex;
        }
    }
}

