/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.parosproxy.paros.CommandLine;
import org.zaproxy.zap.CommandLineBootstrap;
import org.zaproxy.zap.DaemonBootstrap;
import org.zaproxy.zap.GuiBootstrap;
import org.zaproxy.zap.ZapBootstrap;
import org.zaproxy.zap.eventBus.EventBus;
import org.zaproxy.zap.eventBus.SimpleEventBus;

public class ZAP {
    private static ProcessType processType;
    private static final EventBus eventBus;
    private static final Logger LOGGER;

    public static void main(String[] args) throws Exception {
        ZAP.setCustomErrStream();
        CommandLine cmdLine = null;
        try {
            cmdLine = new CommandLine(args != null ? Arrays.copyOf(args, args.length) : null);
        }
        catch (Exception e) {
            System.out.println("Failed due to invalid parameters: " + Arrays.toString(args));
            System.out.println(e.getMessage());
            System.out.println("Use '-h' for more details.");
            System.exit(1);
        }
        ZapBootstrap bootstrap = ZAP.createZapBootstrap(cmdLine);
        try {
            int rc = bootstrap.start();
            if (rc != 0) {
                System.exit(rc);
            }
        }
        catch (Exception e) {
            LOGGER.fatal(e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    private static void setCustomErrStream() {
        System.setErr(new DelegatorPrintStream(System.err){

            @Override
            public void println(String x) {
                if ("Warning: Nashorn engine is planned to be removed from a future JDK release".equals(x)) {
                    return;
                }
                if (x.startsWith("Multiplexing LAF")) {
                    return;
                }
                super.println(x);
            }
        });
    }

    private static ZapBootstrap createZapBootstrap(CommandLine cmdLineArgs) {
        ZapBootstrap bootstrap;
        if (cmdLineArgs.isGUI()) {
            processType = ProcessType.desktop;
            bootstrap = new GuiBootstrap(cmdLineArgs);
        } else if (cmdLineArgs.isDaemon()) {
            processType = ProcessType.daemon;
            bootstrap = new DaemonBootstrap(cmdLineArgs);
        } else {
            processType = ProcessType.cmdline;
            bootstrap = new CommandLineBootstrap(cmdLineArgs);
        }
        return bootstrap;
    }

    public static ProcessType getProcessType() {
        return processType;
    }

    public static EventBus getEventBus() {
        return eventBus;
    }

    static {
        System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
        eventBus = new SimpleEventBus();
        LOGGER = LogManager.getLogger(ZAP.class);
        try {
            URLConnection.class.getDeclaredMethod("setDefaultUseCaches", String.class, Boolean.TYPE).invoke(null, "jar", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtExceptionLogger());
    }

    private static class DelegatorPrintStream
    extends PrintStream {
        private final PrintStream delegatee;

        public DelegatorPrintStream(PrintStream delegatee) {
            super((OutputStream)NullOutputStream.INSTANCE);
            this.delegatee = delegatee;
        }

        @Override
        public void flush() {
            this.delegatee.flush();
        }

        @Override
        public void close() {
            this.delegatee.close();
        }

        @Override
        public boolean checkError() {
            return this.delegatee.checkError();
        }

        @Override
        protected void setError() {
        }

        @Override
        protected void clearError() {
        }

        @Override
        public void write(int b) {
            this.delegatee.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegatee.write(b);
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            this.delegatee.write(buf, off, len);
        }

        @Override
        public void print(boolean b) {
            this.delegatee.print(b);
        }

        @Override
        public void print(char c) {
            this.delegatee.print(c);
        }

        @Override
        public void print(int i) {
            this.delegatee.print(i);
        }

        @Override
        public void print(long l) {
            this.delegatee.print(l);
        }

        @Override
        public void print(float f) {
            this.delegatee.print(f);
        }

        @Override
        public void print(double d) {
            this.delegatee.print(d);
        }

        @Override
        public void print(char[] s) {
            this.delegatee.print(s);
        }

        @Override
        public void print(String s) {
            this.delegatee.print(s);
        }

        @Override
        public void print(Object obj) {
            this.delegatee.print(obj);
        }

        @Override
        public void println() {
            this.delegatee.println();
        }

        @Override
        public void println(boolean x) {
            this.delegatee.println(x);
        }

        @Override
        public void println(char x) {
            this.delegatee.println(x);
        }

        @Override
        public void println(int x) {
            this.delegatee.println(x);
        }

        @Override
        public void println(long x) {
            this.delegatee.println(x);
        }

        @Override
        public void println(float x) {
            this.delegatee.println(x);
        }

        @Override
        public void println(double x) {
            this.delegatee.println(x);
        }

        @Override
        public void println(char[] x) {
            this.delegatee.println(x);
        }

        @Override
        public void println(String x) {
            this.delegatee.println(x);
        }

        @Override
        public void println(Object x) {
            this.delegatee.println(x);
        }

        @Override
        public PrintStream printf(String format, Object ... args) {
            return this.delegatee.printf(format, args);
        }

        @Override
        public PrintStream printf(Locale l, String format, Object ... args) {
            return this.delegatee.printf(l, format, args);
        }

        @Override
        public PrintStream format(String format, Object ... args) {
            this.delegatee.format(format, args);
            return this;
        }

        @Override
        public PrintStream format(Locale l, String format, Object ... args) {
            this.delegatee.format(l, format, args);
            return this;
        }

        @Override
        public PrintStream append(CharSequence csq) {
            this.delegatee.append(csq);
            return this;
        }

        @Override
        public PrintStream append(CharSequence csq, int start, int end) {
            this.delegatee.append(csq, start, end);
            return this;
        }

        @Override
        public PrintStream append(char c) {
            this.delegatee.append(c);
            return this;
        }
    }

    static final class UncaughtExceptionLogger
    implements Thread.UncaughtExceptionHandler {
        private static final Logger LOGGER = LogManager.getLogger(UncaughtExceptionLogger.class);
        private boolean loggerConfigured = false;

        UncaughtExceptionLogger() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (!(e instanceof ThreadDeath)) {
                if (this.loggerConfigured || this.isLoggerConfigured()) {
                    LOGGER.error("Exception in thread \"{}\"", (Object)t.getName(), (Object)e);
                } else {
                    System.err.println("Exception in thread \"" + t.getName() + "\"");
                    e.printStackTrace();
                }
            }
        }

        private boolean isLoggerConfigured() {
            if (this.loggerConfigured) {
                return true;
            }
            LoggerContext context = LoggerContext.getContext();
            if (!context.getRootLogger().getAppenders().isEmpty()) {
                this.loggerConfigured = true;
            } else {
                for (LoggerConfig config : context.getConfiguration().getLoggers().values()) {
                    if (config.getAppenders().isEmpty()) continue;
                    this.loggerConfigured = true;
                    break;
                }
            }
            return this.loggerConfigured;
        }
    }

    public static enum ProcessType {
        cmdline,
        daemon,
        desktop,
        zaas;

    }
}

