/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.core.LoggerContext;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.control.ControlOverrides;
import org.zaproxy.zap.utils.Stats;

abstract class ZapBootstrap {
    private final CommandLine args;
    private final ControlOverrides controlOverrides;

    public ZapBootstrap(CommandLine args) {
        this.args = args;
        this.controlOverrides = new ControlOverrides();
        this.controlOverrides.setOrderedConfigs(this.getArgs().getOrderedConfigs());
        this.controlOverrides.setExperimentalDb(this.getArgs().isExperimentalDb());
    }

    public int start() {
        try {
            Constant.createInstance(this.controlOverrides);
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            return 1;
        }
        Constant.setLowMemoryOption(this.getArgs().isLowMem());
        if (this.getArgs().isNoStdOutLog()) {
            ZapBootstrap.disableStdOutLog();
        }
        return 0;
    }

    protected static void disableStdOutLog() {
        LoggerContext.getContext().getConfiguration().getRootLogger().removeAppender("stdout");
    }

    protected void initModel() throws Exception {
        Model.getSingleton().init(this.getControlOverrides());
        Model.getSingleton().getOptionsParam().setGUI(this.getArgs().isGUI());
    }

    protected CommandLine getArgs() {
        return this.args;
    }

    protected ControlOverrides getControlOverrides() {
        return this.controlOverrides;
    }

    protected static String getStartingMessage() {
        DateFormat dateFormat = SimpleDateFormat.getDateTimeInstance(3, 2);
        StringBuilder strBuilder = new StringBuilder(200);
        strBuilder.append("ZAP").append(' ').append(Constant.PROGRAM_VERSION);
        strBuilder.append(" started ");
        strBuilder.append(dateFormat.format(new Date()));
        strBuilder.append(" with home ").append(Constant.getZapHome());
        return strBuilder.toString();
    }

    protected void recordStartStats() {
        this.getControlOverrides().getOrderedConfigs().keySet().forEach(k -> Stats.incCounter("stats.config." + k));
    }
}

