/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.apache.commons.lang.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXTree;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnCollection;

public final class AddOnRunIssuesUtils {
    private static final Logger LOGGER = LogManager.getLogger(AddOnRunIssuesUtils.class);

    private AddOnRunIssuesUtils() {
    }

    public static void showWarningMessageAddOnsNotRunnable(String message, AddOnCollection availableAddOns, Collection<AddOn> addOnsNotRunnable) {
        Object[] msgs = new Object[]{message, AddOnRunIssuesUtils.createScrollableTreeAddOnsNotRunnable(availableAddOns, addOnsNotRunnable.toArray(new AddOn[addOnsNotRunnable.size()]))};
        JOptionPane.showMessageDialog(View.getSingleton().getMainFrame(), msgs, "ZAP", 2);
    }

    private static JScrollPane createScrollableTreeAddOnsNotRunnable(final AddOnCollection availableAddOns, AddOn ... addOnsNotRunnable) {
        AddOnSearcher addOnSearcher = new AddOnSearcher(){

            @Override
            public AddOn searchAddOn(String id) {
                return availableAddOns.getAddOn(id);
            }
        };
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("");
        for (AddOn addOn : addOnsNotRunnable) {
            DefaultMutableTreeNode addOnNode = new DefaultMutableTreeNode(addOn.getName());
            AddOn.AddOnRunRequirements requirements = addOn.calculateRunRequirements(availableAddOns.getAddOns());
            List<String> issues = AddOnRunIssuesUtils.getUiRunningIssues(requirements, addOnSearcher);
            if (issues.isEmpty()) {
                issues.addAll(AddOnRunIssuesUtils.getUiExtensionsRunningIssues(requirements, addOnSearcher));
            }
            for (String issue : issues) {
                addOnNode.add(new DefaultMutableTreeNode(issue));
            }
            rootNode.add(addOnNode);
        }
        JXTree tree = new JXTree((TreeModel)new DefaultTreeModel(rootNode));
        tree.setVisibleRowCount(5);
        tree.setEditable(false);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.expandAll();
        return new JScrollPane((Component)tree);
    }

    public static boolean askConfirmationAddOnNotRunnable(String message, String question, AddOnCollection availableAddOns, AddOn addOnNotRunnable) {
        Object[] msgs = new Object[]{message, AddOnRunIssuesUtils.createScrollableTreeAddOnsNotRunnable(availableAddOns, addOnNotRunnable), question};
        return JOptionPane.showConfirmDialog(View.getSingleton().getMainFrame(), msgs, "ZAP", 0, 3) == 0;
    }

    public static List<String> getUiRunningIssues(AddOn.BaseRunRequirements requirements, AddOnSearcher addOnSearcher) {
        ArrayList<String> issues = new ArrayList<String>(3);
        if (requirements.hasMissingLibs()) {
            if (requirements.getAddOn() != requirements.getAddOnMissingLibs()) {
                issues.add(Constant.messages.getString("cfu.warn.addon.with.missing.requirements.libs.dependency", requirements.getAddOnMissingLibs().getName()));
            } else {
                issues.add(Constant.messages.getString("cfu.warn.addon.with.missing.requirements.libs"));
            }
        }
        if (requirements.isNewerJavaVersionRequired()) {
            if (requirements.getAddOn() != requirements.getAddOnMinimumJavaVersion()) {
                issues.add(Constant.messages.getString("cfu.warn.addon.with.missing.requirements.javaversion.dependency", requirements.getMinimumJavaVersion(), SystemUtils.JAVA_VERSION == null ? Constant.messages.getString("cfu.warn.unknownJavaVersion") : SystemUtils.JAVA_VERSION, requirements.getAddOnMinimumJavaVersion().getName()));
            } else {
                issues.add(Constant.messages.getString("cfu.warn.addon.with.missing.requirements.javaversion", requirements.getMinimumJavaVersion(), SystemUtils.JAVA_VERSION == null ? Constant.messages.getString("cfu.warn.unknownJavaVersion") : SystemUtils.JAVA_VERSION));
            }
        }
        if (requirements.hasDependencyIssue()) {
            List<Object> issueDetails = requirements.getDependencyIssueDetails();
            String message = null;
            switch (requirements.getDependencyIssue()) {
                case CYCLIC: {
                    message = Constant.messages.getString("cfu.warn.addon.with.missing.requirements.addon.cyclic");
                    break;
                }
                case OLDER_VERSION: {
                    break;
                }
                case MISSING: {
                    String addOnId = (String)issueDetails.get(0);
                    AddOn addOn = addOnSearcher != null ? addOnSearcher.searchAddOn(addOnId) : null;
                    if (addOn == null) {
                        message = Constant.messages.getString("cfu.warn.addon.with.missing.requirements.addon.id", addOnId);
                        break;
                    }
                    message = Constant.messages.getString("cfu.warn.addon.with.missing.requirements.addon", addOn.getName());
                    break;
                }
                case VERSION: {
                    AddOn addOn = (AddOn)issueDetails.get(0);
                    message = Constant.messages.getString("cfu.warn.addon.with.missing.requirements.addon.version", addOn.getName(), issueDetails.get(1), addOn.getSemVer() != null ? addOn.getSemVer() : addOn.getVersion());
                    break;
                }
                default: {
                    message = Constant.messages.getString("cfu.warn.addon.with.missing.requirements.unknown");
                    LOGGER.warn("Failed to handle dependency issue with name \"{}\" and details: {}", (Object)requirements.getDependencyIssue().name(), issueDetails);
                }
            }
            if (message != null) {
                issues.add(message);
            }
        }
        return issues;
    }

    public static List<String> getUiExtensionsRunningIssues(AddOn.AddOnRunRequirements requirements, AddOnSearcher addOnSearcher) {
        if (!requirements.hasExtensionsWithRunningIssues()) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> issues = new ArrayList<String>(10);
        for (AddOn.ExtensionRunRequirements extReqs : requirements.getExtensionRequirements()) {
            issues.addAll(AddOnRunIssuesUtils.getUiRunningIssues(extReqs, addOnSearcher));
        }
        return issues;
    }

    public static List<String> getRunningIssues(AddOn.BaseRunRequirements requirements) {
        ArrayList<String> issues = new ArrayList<String>(3);
        String issue = AddOnRunIssuesUtils.getMissingLibsIssue(requirements);
        if (issue != null) {
            issues.add(issue);
        }
        if ((issue = AddOnRunIssuesUtils.getJavaVersionIssue(requirements)) != null) {
            issues.add(issue);
        }
        if ((issue = AddOnRunIssuesUtils.getDependencyIssue(requirements)) != null) {
            issues.add(issue);
        }
        return issues;
    }

    public static List<String> getExtensionsRunningIssues(AddOn.AddOnRunRequirements requirements) {
        if (!requirements.hasExtensionsWithRunningIssues()) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> issues = new ArrayList<String>(10);
        for (AddOn.ExtensionRunRequirements extReqs : requirements.getExtensionRequirements()) {
            issues.addAll(AddOnRunIssuesUtils.getRunningIssues(extReqs));
        }
        return issues;
    }

    public static String getJavaVersionIssue(AddOn.BaseRunRequirements requirements) {
        if (!requirements.isNewerJavaVersionRequired()) {
            return null;
        }
        if (requirements.getAddOn() != requirements.getAddOnMinimumJavaVersion()) {
            return MessageFormat.format("Minimum Java version: {0} (\"{1}\" add-on)", requirements.getMinimumJavaVersion(), requirements.getAddOnMinimumJavaVersion().getName());
        }
        return MessageFormat.format("Minimum Java version: {0}", requirements.getMinimumJavaVersion());
    }

    public static String getMissingLibsIssue(AddOn.BaseRunRequirements requirements) {
        if (!requirements.hasMissingLibs()) {
            return null;
        }
        if (requirements.getAddOn() != requirements.getAddOnMissingLibs()) {
            return MessageFormat.format("Bundled libraries of dependency: {0}", requirements.getAddOnMissingLibs().getName());
        }
        return "Bundled libraries.";
    }

    public static String getDependencyIssue(AddOn.BaseRunRequirements requirements) {
        if (!requirements.hasDependencyIssue()) {
            return null;
        }
        List<Object> issueDetails = requirements.getDependencyIssueDetails();
        switch (requirements.getDependencyIssue()) {
            case CYCLIC: {
                return "Cyclic dependency with: " + issueDetails.get(0);
            }
            case OLDER_VERSION: {
                return "Older version still installed: " + issueDetails.get(0);
            }
            case MISSING: {
                String addOnId = (String)issueDetails.get(0);
                return MessageFormat.format("Add-On with ID \"{0}\"", addOnId);
            }
            case VERSION: {
                AddOn addOn = (AddOn)issueDetails.get(0);
                return MessageFormat.format("Add-on \"{0}\" with version matching {1} (found version {2})", addOn.getName(), issueDetails.get(1), addOn.getSemVer() != null ? addOn.getSemVer() : addOn.getVersion());
            }
        }
        LOGGER.warn("Failed to handle dependency issue with name \"{}\" and details: {}", (Object)requirements.getDependencyIssue().name(), issueDetails);
        return null;
    }

    public static interface AddOnSearcher {
        public AddOn searchAddOn(String var1);
    }
}

