/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JMenu;
import org.parosproxy.paros.control.Control;
import org.zaproxy.zap.view.messagecontainer.MessageContainer;
import org.zaproxy.zap.view.popup.ExtensionPopupMenuComponent;
import org.zaproxy.zap.view.popup.PopupMenuUtils;

public class ExtensionPopupMenu
extends JMenu
implements ExtensionPopupMenuComponent {
    private static final long serialVersionUID = 1925623776527543421L;
    private boolean orderChildren;

    public ExtensionPopupMenu() {
    }

    public ExtensionPopupMenu(String text) {
        super(text);
    }

    public void setOrderChildren(boolean orderChildren) {
        this.orderChildren = orderChildren;
    }

    public boolean isOrderChildren() {
        return this.orderChildren;
    }

    @Override
    public boolean isEnableForComponent(Component invoker) {
        return this.processExtensionPopupChildren(PopupMenuUtils.getPopupMenuInvokerWrapper(invoker));
    }

    protected boolean processExtensionPopupChildren(PopupMenuUtils.PopupMenuInvokerWrapper invokerWrapper) {
        if (this.isOrderChildren()) {
            Object component;
            int i;
            PopupMenuUtils.removeAllSeparators(this);
            ArrayList<ExtensionPopupMenuComponent> components = new ArrayList<ExtensionPopupMenuComponent>();
            for (i = 0; i < this.getMenuComponentCount(); ++i) {
                ExtensionPopupMenuComponent menuComponent;
                component = this.getMenuComponent(i);
                if (!PopupMenuUtils.isExtensionPopupMenuComponent((Component)component) || (menuComponent = (ExtensionPopupMenuComponent)component).getMenuIndex() < 0) continue;
                components.add(menuComponent);
                this.remove(i);
                --i;
            }
            Collections.sort(components, new Comparator<ExtensionPopupMenuComponent>(){

                @Override
                public int compare(ExtensionPopupMenuComponent component, ExtensionPopupMenuComponent otherComponent) {
                    if (component.getMenuIndex() > otherComponent.getMenuIndex()) {
                        return 1;
                    }
                    if (component.getMenuIndex() < otherComponent.getMenuIndex()) {
                        return -1;
                    }
                    return 0;
                }
            });
            for (i = 0; i < components.size(); ++i) {
                component = (ExtensionPopupMenuComponent)components.get(i);
                int index = Math.max(component.getMenuIndex(), i);
                if (index >= this.getMenuComponentCount()) {
                    this.add((Component)component);
                    continue;
                }
                this.getPopupMenu().insert((Component)component, index);
            }
        }
        boolean childEnable = false;
        Control.Mode mode = Control.getSingleton().getMode();
        for (int i = 0; i < this.getMenuComponentCount(); ++i) {
            Component menuComponent = this.getMenuComponent(i);
            if (!PopupMenuUtils.isExtensionPopupMenuComponent(menuComponent)) continue;
            ExtensionPopupMenuComponent extensionMenuComponent = (ExtensionPopupMenuComponent)((Object)menuComponent);
            boolean enable = invokerWrapper.isEnable(extensionMenuComponent);
            if (enable && !extensionMenuComponent.isSafe() && mode.equals((Object)Control.Mode.safe)) {
                menuComponent.setEnabled(false);
                continue;
            }
            if (enable) {
                childEnable = true;
                if (extensionMenuComponent.precedeWithSeparator() && PopupMenuUtils.insertSeparatorIfNeeded(this, i)) {
                    ++i;
                }
            }
            menuComponent.setVisible(enable);
            if (!enable || !extensionMenuComponent.succeedWithSeparator() || !PopupMenuUtils.insertSeparatorIfNeeded(this, i + 1)) continue;
            ++i;
        }
        PopupMenuUtils.removeTopAndBottomSeparators(this);
        return childEnable;
    }

    @Override
    public boolean isEnableForMessageContainer(MessageContainer<?> invoker) {
        return this.isEnableForComponent(invoker.getComponent());
    }

    public String getParentMenuName() {
        return null;
    }

    @Override
    public int getMenuIndex() {
        return -1;
    }

    public int getParentMenuIndex() {
        return -1;
    }

    public boolean isSubMenu() {
        return false;
    }

    @Override
    public boolean precedeWithSeparator() {
        return false;
    }

    @Override
    public boolean succeedWithSeparator() {
        return false;
    }

    @Override
    public boolean isSafe() {
        return true;
    }

    @Override
    public void dismissed(ExtensionPopupMenuComponent selectedMenuComponent) {
        for (int i = 0; i < this.getMenuComponentCount(); ++i) {
            Component menuComponent = this.getMenuComponent(i);
            if (!PopupMenuUtils.isExtensionPopupMenuComponent(menuComponent)) continue;
            ((ExtensionPopupMenuComponent)((Object)menuComponent)).dismissed(selectedMenuComponent);
        }
    }
}

