/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.PatternSyntaxException;
import net.sf.json.JSON;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Category;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.core.scanner.ScannerParamFilter;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.ascan.ActiveScan;
import org.zaproxy.zap.extension.ascan.ExtensionActiveScan;
import org.zaproxy.zap.extension.ascan.ScanPolicy;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;
import org.zaproxy.zap.utils.XMLStringUtil;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public class ActiveScanAPI
extends ApiImplementor {
    private static final Logger LOGGER = LogManager.getLogger(ActiveScanAPI.class);
    private static final String PREFIX = "ascan";
    private static final String ACTION_SCAN = "scan";
    private static final String ACTION_SCAN_AS_USER = "scanAsUser";
    private static final String ACTION_PAUSE_SCAN = "pause";
    private static final String ACTION_RESUME_SCAN = "resume";
    private static final String ACTION_STOP_SCAN = "stop";
    private static final String ACTION_PAUSE_ALL_SCANS = "pauseAllScans";
    private static final String ACTION_RESUME_ALL_SCANS = "resumeAllScans";
    private static final String ACTION_STOP_ALL_SCANS = "stopAllScans";
    private static final String ACTION_REMOVE_SCAN = "removeScan";
    private static final String ACTION_REMOVE_ALL_SCANS = "removeAllScans";
    private static final String ACTION_EXCLUDE_FROM_SCAN = "excludeFromScan";
    private static final String ACTION_CLEAR_EXCLUDED_FROM_SCAN = "clearExcludedFromScan";
    private static final String ACTION_ENABLE_ALL_SCANNERS = "enableAllScanners";
    private static final String ACTION_DISABLE_ALL_SCANNERS = "disableAllScanners";
    private static final String ACTION_ENABLE_SCANNERS = "enableScanners";
    private static final String ACTION_DISABLE_SCANNERS = "disableScanners";
    private static final String ACTION_SET_ENABLED_POLICIES = "setEnabledPolicies";
    private static final String ACTION_SET_POLICY_ATTACK_STRENGTH = "setPolicyAttackStrength";
    private static final String ACTION_SET_POLICY_ALERT_THRESHOLD = "setPolicyAlertThreshold";
    private static final String ACTION_SET_SCANNER_ATTACK_STRENGTH = "setScannerAttackStrength";
    private static final String ACTION_SET_SCANNER_ALERT_THRESHOLD = "setScannerAlertThreshold";
    private static final String ACTION_ADD_SCAN_POLICY = "addScanPolicy";
    private static final String ACTION_REMOVE_SCAN_POLICY = "removeScanPolicy";
    private static final String ACTION_UPDATE_SCAN_POLICY = "updateScanPolicy";
    private static final String ACTION_IMPORT_SCAN_POLICY = "importScanPolicy";
    private static final String ACTION_ADD_EXCLUDED_PARAM = "addExcludedParam";
    private static final String ACTION_MODIFY_EXCLUDED_PARAM = "modifyExcludedParam";
    private static final String ACTION_REMOVE_EXCLUDED_PARAM = "removeExcludedParam";
    private static final String ACTION_SKIP_SCANNER = "skipScanner";
    private static final String VIEW_STATUS = "status";
    private static final String VIEW_SCANS = "scans";
    private static final String VIEW_MESSAGES_IDS = "messagesIds";
    private static final String VIEW_ALERTS_IDS = "alertsIds";
    private static final String VIEW_EXCLUDED_FROM_SCAN = "excludedFromScan";
    private static final String VIEW_SCANNERS = "scanners";
    private static final String VIEW_POLICIES = "policies";
    private static final String VIEW_SCAN_POLICY_NAMES = "scanPolicyNames";
    private static final String VIEW_ATTACK_MODE_QUEUE = "attackModeQueue";
    private static final String VIEW_SCAN_PROGRESS = "scanProgress";
    private static final String VIEW_EXCLUDED_PARAMS = "excludedParams";
    private static final String VIEW_OPTION_EXCLUDED_PARAM_LIST = "optionExcludedParamList";
    private static final String VIEW_EXCLUDED_PARAM_TYPES = "excludedParamTypes";
    private static final String PARAM_URL = "url";
    private static final String PARAM_CONTEXT_ID = "contextId";
    private static final String PARAM_USER_ID = "userId";
    private static final String PARAM_REGEX = "regex";
    private static final String PARAM_RECURSE = "recurse";
    private static final String PARAM_JUST_IN_SCOPE = "inScopeOnly";
    private static final String PARAM_IDS = "ids";
    private static final String PARAM_ID = "id";
    private static final String PARAM_ATTACK_STRENGTH = "attackStrength";
    private static final String PARAM_ALERT_THRESHOLD = "alertThreshold";
    private static final String PARAM_SCAN_POLICY_NAME = "scanPolicyName";
    private static final String PARAM_PATH = "path";
    private static final String PARAM_CATEGORY_ID = "policyId";
    private static final String PARAM_SCAN_ID = "scanId";
    private static final String PARAM_SCANNER_ID = "scannerId";
    private static final String PARAM_METHOD = "method";
    private static final String PARAM_POST_DATA = "postData";
    private static final String PARAM_IDX = "idx";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_NAME = "name";
    private ExtensionActiveScan controller = null;

    public ActiveScanAPI(ExtensionActiveScan controller) {
        this.controller = controller;
        this.addApiAction(new ApiAction(ACTION_SCAN, null, new String[]{PARAM_URL, PARAM_RECURSE, PARAM_JUST_IN_SCOPE, PARAM_SCAN_POLICY_NAME, PARAM_METHOD, PARAM_POST_DATA, PARAM_CONTEXT_ID}));
        this.addApiAction(new ApiAction(ACTION_SCAN_AS_USER, null, new String[]{PARAM_URL, PARAM_CONTEXT_ID, PARAM_USER_ID, PARAM_RECURSE, PARAM_SCAN_POLICY_NAME, PARAM_METHOD, PARAM_POST_DATA}));
        this.addApiAction(new ApiAction(ACTION_PAUSE_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_RESUME_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_STOP_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_REMOVE_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_PAUSE_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_RESUME_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_STOP_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_REMOVE_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_CLEAR_EXCLUDED_FROM_SCAN));
        this.addApiAction(new ApiAction(ACTION_EXCLUDE_FROM_SCAN, new String[]{PARAM_REGEX}));
        this.addApiAction(new ApiAction(ACTION_ENABLE_ALL_SCANNERS, null, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_DISABLE_ALL_SCANNERS, null, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_ENABLE_SCANNERS, new String[]{PARAM_IDS}, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_DISABLE_SCANNERS, new String[]{PARAM_IDS}, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_SET_ENABLED_POLICIES, new String[]{PARAM_IDS}, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_SET_POLICY_ATTACK_STRENGTH, new String[]{PARAM_ID, PARAM_ATTACK_STRENGTH}, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_SET_POLICY_ALERT_THRESHOLD, new String[]{PARAM_ID, PARAM_ALERT_THRESHOLD}, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_SET_SCANNER_ATTACK_STRENGTH, new String[]{PARAM_ID, PARAM_ATTACK_STRENGTH}, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_SET_SCANNER_ALERT_THRESHOLD, new String[]{PARAM_ID, PARAM_ALERT_THRESHOLD}, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_ADD_SCAN_POLICY, new String[]{PARAM_SCAN_POLICY_NAME}, new String[]{PARAM_ALERT_THRESHOLD, PARAM_ATTACK_STRENGTH}));
        this.addApiAction(new ApiAction(ACTION_REMOVE_SCAN_POLICY, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_UPDATE_SCAN_POLICY, new String[]{PARAM_SCAN_POLICY_NAME}, new String[]{PARAM_ALERT_THRESHOLD, PARAM_ATTACK_STRENGTH}));
        this.addApiAction(new ApiAction(ACTION_IMPORT_SCAN_POLICY, new String[]{PARAM_PATH}));
        this.addApiAction(new ApiAction(ACTION_ADD_EXCLUDED_PARAM, new String[]{PARAM_NAME}, new String[]{PARAM_TYPE, PARAM_URL}));
        this.addApiAction(new ApiAction(ACTION_MODIFY_EXCLUDED_PARAM, new String[]{PARAM_IDX}, new String[]{PARAM_NAME, PARAM_TYPE, PARAM_URL}));
        this.addApiAction(new ApiAction(ACTION_REMOVE_EXCLUDED_PARAM, new String[]{PARAM_IDX}));
        this.addApiAction(new ApiAction(ACTION_SKIP_SCANNER, new String[]{PARAM_SCAN_ID, PARAM_SCANNER_ID}));
        this.addApiView(new ApiView(VIEW_STATUS, null, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_SCAN_PROGRESS, null, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_MESSAGES_IDS, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_ALERTS_IDS, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_SCANS));
        this.addApiView(new ApiView(VIEW_SCAN_POLICY_NAMES));
        this.addApiView(new ApiView(VIEW_EXCLUDED_FROM_SCAN));
        this.addApiView(new ApiView(VIEW_SCANNERS, null, new String[]{PARAM_SCAN_POLICY_NAME, PARAM_CATEGORY_ID}));
        this.addApiView(new ApiView(VIEW_POLICIES, null, new String[]{PARAM_SCAN_POLICY_NAME, PARAM_CATEGORY_ID}));
        this.addApiView(new ApiView(VIEW_ATTACK_MODE_QUEUE));
        this.addApiView(new ApiView(VIEW_EXCLUDED_PARAMS));
        ApiView view = new ApiView(VIEW_OPTION_EXCLUDED_PARAM_LIST);
        view.setDeprecated(true);
        this.addApiView(view);
        this.addApiView(new ApiView(VIEW_EXCLUDED_PARAM_TYPES));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        LOGGER.debug("handleApiAction {} {}", (Object)name, (Object)params);
        User user = null;
        Context context = null;
        try {
            switch (name) {
                case "scanAsUser": {
                    this.validateParamExists(params, PARAM_CONTEXT_ID);
                    this.validateParamExists(params, PARAM_USER_ID);
                    int userID = ApiUtils.getIntParam(params, PARAM_USER_ID);
                    ExtensionUserManagement usersExtension = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class);
                    if (usersExtension == null) {
                        throw new ApiException(ApiException.Type.NO_IMPLEMENTOR, "ExtensionUserManagement");
                    }
                    context = ApiUtils.getContextByParamId(params, PARAM_CONTEXT_ID);
                    user = usersExtension.getContextUserAuthManager(context.getId()).getUserById(userID);
                    if (user == null) {
                        throw new ApiException(ApiException.Type.USER_NOT_FOUND, PARAM_USER_ID);
                    }
                }
                case "scan": {
                    String url = ApiUtils.getOptionalStringParam(params, PARAM_URL);
                    if (context == null && params.has(PARAM_CONTEXT_ID) && !params.getString(PARAM_CONTEXT_ID).isEmpty()) {
                        context = ApiUtils.getContextByParamId(params, PARAM_CONTEXT_ID);
                    }
                    boolean scanJustInScope = context != null ? false : this.getParam(params, PARAM_JUST_IN_SCOPE, false);
                    String policyName = null;
                    ScanPolicy policy = null;
                    try {
                        policyName = params.getString(PARAM_SCAN_POLICY_NAME);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (policyName != null && policyName.length() > 0) {
                            LOGGER.debug("handleApiAction scan policy ={}", (Object)policyName);
                            policy = this.controller.getPolicyManager().getPolicy(policyName);
                        }
                    }
                    catch (ConfigurationException e) {
                        throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_POLICY_NAME);
                    }
                    String method = this.getParam(params, PARAM_METHOD, "GET");
                    if (method.trim().length() == 0) {
                        method = "GET";
                    }
                    if (!Arrays.asList(HttpRequestHeader.METHODS).contains(method)) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_METHOD);
                    }
                    int scanId = this.scanURL(url, user, this.getParam(params, PARAM_RECURSE, true), scanJustInScope, method, this.getParam(params, PARAM_POST_DATA, ""), policy, context);
                    return new ApiResponseElement(name, Integer.toString(scanId));
                }
                case "pause": {
                    this.getActiveScan(params).pauseScan();
                    break;
                }
                case "resume": {
                    this.getActiveScan(params).resumeScan();
                    break;
                }
                case "stop": {
                    this.getActiveScan(params).stopScan();
                    break;
                }
                case "removeScan": {
                    ActiveScan activeScan = this.controller.removeScan(params.getInt(PARAM_SCAN_ID));
                    if (activeScan == null) {
                        throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
                    }
                    break;
                }
                case "pauseAllScans": {
                    this.controller.pauseAllScans();
                    break;
                }
                case "resumeAllScans": {
                    this.controller.resumeAllScans();
                    break;
                }
                case "stopAllScans": {
                    this.controller.stopAllScans();
                    break;
                }
                case "removeAllScans": {
                    this.controller.removeAllScans();
                    break;
                }
                case "clearExcludedFromScan": {
                    try {
                        Session session = Model.getSingleton().getSession();
                        session.setExcludeFromScanRegexs(new ArrayList<String>());
                        break;
                    }
                    catch (DatabaseException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                        throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                    }
                }
                case "excludeFromScan": {
                    String regex = params.getString(PARAM_REGEX);
                    try {
                        Session session = Model.getSingleton().getSession();
                        session.addExcludeFromScanRegexs(regex);
                        break;
                    }
                    catch (DatabaseException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                        throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                    }
                    catch (PatternSyntaxException e) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_REGEX);
                    }
                }
                case "enableAllScanners": {
                    ScanPolicy policy = this.getScanPolicyFromParams(params);
                    policy.getPluginFactory().setAllPluginEnabled(true);
                    policy.save();
                    break;
                }
                case "disableAllScanners": {
                    ScanPolicy policy = this.getScanPolicyFromParams(params);
                    policy.getPluginFactory().setAllPluginEnabled(false);
                    policy.save();
                    break;
                }
                case "enableScanners": {
                    ScanPolicy policy = this.getScanPolicyFromParams(params);
                    this.setScannersEnabled(policy, this.getParam(params, PARAM_IDS, "").split(","), true);
                    policy.save();
                    break;
                }
                case "disableScanners": {
                    ScanPolicy policy = this.getScanPolicyFromParams(params);
                    this.setScannersEnabled(policy, this.getParam(params, PARAM_IDS, "").split(","), false);
                    policy.save();
                    break;
                }
                case "setEnabledPolicies": {
                    ScanPolicy policy = this.getScanPolicyFromParams(params);
                    this.setEnabledCategories(policy, this.getParam(params, PARAM_IDS, "").split(","));
                    policy.save();
                    break;
                }
                case "setPolicyAttackStrength": {
                    int categoryId = this.getParam(params, PARAM_ID, -1);
                    ActiveScanAPI.verifyCategoryId(categoryId, PARAM_ID);
                    ScanPolicy policy = this.getScanPolicyFromParams(params);
                    Plugin.AttackStrength attackStrength = this.getAttackStrengthFromParamAttack(params);
                    this.updateRulesOfCategoryInPolicy(categoryId, policy, s -> s.setAttackStrength(attackStrength));
                    break;
                }
                case "setPolicyAlertThreshold": {
                    int categoryId = this.getParam(params, PARAM_ID, -1);
                    ActiveScanAPI.verifyCategoryId(categoryId, PARAM_ID);
                    ScanPolicy policy = this.getScanPolicyFromParams(params);
                    Plugin.AlertThreshold alertThreshold1 = this.getAlertThresholdFromParamAlertThreshold(params);
                    this.updateRulesOfCategoryInPolicy(categoryId, policy, s -> s.setAlertThreshold(alertThreshold1));
                    break;
                }
                case "setScannerAttackStrength": {
                    ScanPolicy policy = this.getScanPolicyFromParams(params);
                    Plugin scanner = this.getScannerFromId(policy, this.getParam(params, PARAM_ID, -1), PARAM_ID);
                    scanner.setAttackStrength(this.getAttackStrengthFromParamAttack(params));
                    policy.save();
                    break;
                }
                case "setScannerAlertThreshold": {
                    ScanPolicy policy = this.getScanPolicyFromParams(params);
                    Plugin.AlertThreshold alertThreshold2 = this.getAlertThresholdFromParamAlertThreshold(params);
                    this.getScannerFromId(policy, this.getParam(params, PARAM_ID, -1), PARAM_ID).setAlertThreshold(alertThreshold2);
                    policy.save();
                    break;
                }
                case "addScanPolicy": {
                    String newPolicyName = params.getString(PARAM_SCAN_POLICY_NAME);
                    if (this.controller.getPolicyManager().getAllPolicyNames().contains(newPolicyName)) {
                        throw new ApiException(ApiException.Type.ALREADY_EXISTS, PARAM_SCAN_POLICY_NAME);
                    }
                    if (!this.controller.getPolicyManager().isLegalPolicyName(newPolicyName)) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_SCAN_POLICY_NAME);
                    }
                    ScanPolicy policy = this.controller.getPolicyManager().getTemplatePolicy();
                    policy.setName(newPolicyName);
                    this.setAlertThreshold(policy, params);
                    this.setAttackStrength(policy, params);
                    this.controller.getPolicyManager().savePolicy(policy);
                    break;
                }
                case "removeScanPolicy": {
                    ScanPolicy policy = this.getScanPolicyFromParams(params);
                    if (this.controller.getPolicyManager().getAllPolicyNames().size() == 1) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "You are not allowed to remove the last scan policy");
                    }
                    this.controller.getPolicyManager().deletePolicy(policy.getName());
                    break;
                }
                case "updateScanPolicy": {
                    ScanPolicy policy = this.getScanPolicyFromParams(params);
                    if (!this.isParamsChanged(policy, params)) break;
                    this.updateAlertThreshold(policy, params);
                    this.updateAttackStrength(policy, params);
                    this.controller.getPolicyManager().savePolicy(policy);
                    break;
                }
                case "importScanPolicy": {
                    ScanPolicy scanPolicy;
                    File file = new File(params.getString(PARAM_PATH));
                    if (!file.exists()) {
                        throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_PATH);
                    }
                    if (!file.isFile()) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_PATH);
                    }
                    try {
                        scanPolicy = new ScanPolicy(new ZapXmlConfiguration(file));
                    }
                    catch (IllegalArgumentException | ConfigurationException e) {
                        throw new ApiException(ApiException.Type.BAD_EXTERNAL_DATA, file.toString(), e);
                    }
                    String scanPolicyName = scanPolicy.getName();
                    if (scanPolicyName.isEmpty()) {
                        scanPolicyName = file.getName();
                    }
                    if (this.controller.getPolicyManager().getAllPolicyNames().contains(scanPolicyName)) {
                        throw new ApiException(ApiException.Type.ALREADY_EXISTS, scanPolicyName);
                    }
                    if (!this.controller.getPolicyManager().isLegalPolicyName(scanPolicyName)) {
                        throw new ApiException(ApiException.Type.BAD_EXTERNAL_DATA, scanPolicyName);
                    }
                    try {
                        this.controller.getPolicyManager().savePolicy(scanPolicy);
                        break;
                    }
                    catch (ConfigurationException e) {
                        throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)e);
                    }
                }
                case "addExcludedParam": {
                    int type = this.getParam(params, PARAM_TYPE, -1);
                    if (!ScannerParamFilter.getTypes().containsKey(type)) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_TYPE);
                    }
                    String url = this.getParam(params, PARAM_URL, "*");
                    if (url.isEmpty()) {
                        url = "*";
                    }
                    ScannerParamFilter excludedParam = new ScannerParamFilter(params.getString(PARAM_NAME), type, url);
                    ArrayList<ScannerParamFilter> excludedParams = new ArrayList<ScannerParamFilter>(this.controller.getScannerParam().getExcludedParamList());
                    excludedParams.add(excludedParam);
                    this.controller.getScannerParam().setExcludedParamList(excludedParams);
                    break;
                }
                case "modifyExcludedParam": {
                    try {
                        ScannerParamFilter newExcludedParam;
                        int idx = params.getInt(PARAM_IDX);
                        if (idx < 0 || idx >= this.controller.getScannerParam().getExcludedParamList().size()) {
                            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX);
                        }
                        ScannerParamFilter oldExcludedParam = this.controller.getScannerParam().getExcludedParamList().get(idx);
                        String epName = this.getParam(params, PARAM_NAME, oldExcludedParam.getParamName());
                        if (epName.isEmpty()) {
                            epName = oldExcludedParam.getParamName();
                        }
                        int type = this.getParam(params, PARAM_TYPE, oldExcludedParam.getType());
                        if (!ScannerParamFilter.getTypes().containsKey(type)) {
                            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_TYPE);
                        }
                        String url = this.getParam(params, PARAM_URL, oldExcludedParam.getWildcardedUrl());
                        if (url.isEmpty()) {
                            url = "*";
                        }
                        if (oldExcludedParam.equals(newExcludedParam = new ScannerParamFilter(epName, type, url))) break;
                        ArrayList<ScannerParamFilter> excludedParams = new ArrayList<ScannerParamFilter>(this.controller.getScannerParam().getExcludedParamList());
                        excludedParams.set(idx, newExcludedParam);
                        this.controller.getScannerParam().setExcludedParamList(excludedParams);
                        break;
                    }
                    catch (JSONException e) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX, e);
                    }
                }
                case "removeExcludedParam": {
                    try {
                        int idx = params.getInt(PARAM_IDX);
                        if (idx < 0 || idx >= this.controller.getScannerParam().getExcludedParamList().size()) {
                            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX);
                        }
                        ArrayList<ScannerParamFilter> excludedParams = new ArrayList<ScannerParamFilter>(this.controller.getScannerParam().getExcludedParamList());
                        excludedParams.remove(idx);
                        this.controller.getScannerParam().setExcludedParamList(excludedParams);
                        break;
                    }
                    catch (JSONException e) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX, e);
                    }
                }
                case "skipScanner": {
                    int pluginId = this.getParam(params, PARAM_SCANNER_ID, -1);
                    if (pluginId == -1) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_SCANNER_ID);
                    }
                    String reason = Constant.messages.getString("ascan.progress.label.skipped.reason.user");
                    this.getActiveScan(params).getHostProcesses().forEach(hp -> hp.pluginSkipped(pluginId, reason));
                    break;
                }
                default: {
                    throw new ApiException(ApiException.Type.BAD_ACTION);
                }
            }
        }
        catch (ConfigurationException e) {
            throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
        }
        return ApiResponseElement.OK;
    }

    private void setAlertThreshold(ScanPolicy policy, JSONObject params) throws ApiException {
        if (this.isParamExists(params, PARAM_ALERT_THRESHOLD)) {
            try {
                policy.setDefaultThreshold(this.getAlertThresholdFromParamAlertThreshold(params));
            }
            catch (IllegalArgumentException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, e.getMessage(), e);
            }
        }
    }

    private void setAttackStrength(ScanPolicy policy, JSONObject params) throws ApiException {
        if (this.isParamExists(params, PARAM_ATTACK_STRENGTH)) {
            try {
                policy.setDefaultStrength(this.getAttackStrengthFromParamAttack(params));
            }
            catch (IllegalArgumentException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, e.getMessage(), e);
            }
        }
    }

    private boolean isParamsChanged(ScanPolicy policy, JSONObject params) throws ApiException {
        return this.isAlertThresholdChanged(policy, params) || this.isAttackStrengthChanged(policy, params);
    }

    private boolean isAlertThresholdChanged(ScanPolicy policy, JSONObject params) throws ApiException {
        if (!this.isParamExists(params, PARAM_ALERT_THRESHOLD)) {
            return false;
        }
        Plugin.AlertThreshold updatedAlertThreshold = this.getAlertThresholdFromParamAlertThreshold(params);
        Plugin.AlertThreshold currentThreshold = policy.getDefaultThreshold();
        return !currentThreshold.equals((Object)updatedAlertThreshold);
    }

    private boolean isAttackStrengthChanged(ScanPolicy policy, JSONObject params) throws ApiException {
        if (!this.isParamExists(params, PARAM_ATTACK_STRENGTH)) {
            return false;
        }
        Plugin.AttackStrength updatedAttackStrength = this.getAttackStrengthFromParamAttack(params);
        Plugin.AttackStrength currentAttackStrength = policy.getDefaultStrength();
        return !currentAttackStrength.equals((Object)updatedAttackStrength);
    }

    private void updateAlertThreshold(ScanPolicy policy, JSONObject params) throws ApiException {
        if (this.isAlertThresholdChanged(policy, params)) {
            policy.setDefaultThreshold(this.getAlertThresholdFromParamAlertThreshold(params));
        }
    }

    private void updateAttackStrength(ScanPolicy policy, JSONObject params) throws ApiException {
        if (this.isAttackStrengthChanged(policy, params)) {
            policy.setDefaultStrength(this.getAttackStrengthFromParamAttack(params));
        }
    }

    private boolean isParamExists(JSONObject params, String key) {
        return params.has(key) && StringUtils.isNotBlank((String)params.getString(key));
    }

    private ScanPolicy getScanPolicyFromParams(JSONObject params) throws ApiException {
        String policyName = null;
        try {
            policyName = params.getString(PARAM_SCAN_POLICY_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (policyName == null || policyName.length() == 0) {
            return this.controller.getPolicyManager().getDefaultScanPolicy();
        }
        try {
            return this.controller.getPolicyManager().getPolicy(policyName);
        }
        catch (ConfigurationException e) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_POLICY_NAME);
        }
    }

    private ActiveScan getActiveScan(JSONObject params) throws ApiException {
        int id = this.getParam(params, PARAM_SCAN_ID, -1);
        ActiveScan activeScan = null;
        activeScan = id == -1 ? this.controller.getLastScan() : this.controller.getScan(id);
        if (activeScan == null) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
        }
        return activeScan;
    }

    private void setScannersEnabled(ScanPolicy policy, String[] ids, boolean enabled) throws ApiException {
        ArrayList<String> unknownIds = null;
        try {
            for (String idString : ids) {
                String idTrimmed = idString.trim();
                int id = Integer.parseInt(idTrimmed);
                Plugin scanner = policy.getPluginFactory().getPlugin(id);
                if (scanner != null) {
                    scanner.setEnabled(enabled);
                    continue;
                }
                if (unknownIds == null) {
                    unknownIds = new ArrayList<String>();
                }
                unknownIds.add(idTrimmed);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Failed to parse scanner ID: ", (Throwable)e);
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, e.getMessage(), e);
        }
        if (unknownIds != null) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, "IDs: " + unknownIds);
        }
    }

    private void setEnabledCategories(ScanPolicy policy, String[] ids) throws ApiException, ConfigurationException {
        try {
            policy.getPluginFactory().setAllPluginEnabled(false);
            for (String id : ids) {
                int categoryId = Integer.parseInt(id.trim());
                ActiveScanAPI.verifyCategoryId(categoryId, id.trim());
                this.updateRulesOfCategoryInPolicy(categoryId, policy, s -> s.setEnabled(true));
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Failed to parse category ID: ", (Throwable)e);
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, e.getMessage(), e);
        }
    }

    private static void verifyCategoryId(int categoryId, String paramName) throws ApiException {
        if (categoryId < 0) {
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, paramName);
        }
        if (!Arrays.asList(Category.getAllNames()).contains(Category.getName(categoryId))) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, Integer.toString(categoryId));
        }
    }

    private void updateRulesOfCategoryInPolicy(int categoryId, ScanPolicy policy, Consumer<Plugin> consumer) throws ConfigurationException {
        for (Plugin scanner : policy.getPluginFactory().getAllPlugin()) {
            if (scanner.getCategory() != categoryId) continue;
            consumer.accept(scanner);
        }
        policy.save();
    }

    private Plugin.AttackStrength getAttackStrengthFromParamAttack(JSONObject params) throws ApiException {
        String paramAttackStrength = params.getString(PARAM_ATTACK_STRENGTH).trim().toUpperCase();
        try {
            return Plugin.AttackStrength.valueOf(paramAttackStrength);
        }
        catch (IllegalArgumentException e) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_ATTACK_STRENGTH);
        }
    }

    private Plugin.AlertThreshold getAlertThresholdFromParamAlertThreshold(JSONObject params) throws ApiException {
        String paramAlertThreshold = params.getString(PARAM_ALERT_THRESHOLD).trim().toUpperCase();
        try {
            return Plugin.AlertThreshold.valueOf(paramAlertThreshold);
        }
        catch (IllegalArgumentException e) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_ALERT_THRESHOLD);
        }
    }

    private Plugin getScannerFromId(ScanPolicy policy, int id, String paramName) throws ApiException {
        if (id < 0) {
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, paramName);
        }
        Plugin scanner = policy.getPluginFactory().getPlugin(id);
        if (scanner == null) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, Integer.toString(id));
        }
        return scanner;
    }

    private int scanURL(String url, User user, boolean scanChildren, boolean scanJustInScope, String method, String postData, ScanPolicy policy, Context context) throws ApiException {
        Target target;
        boolean useUrl = true;
        if (url == null || url.isEmpty()) {
            if (context == null || !context.hasNodesInContextFromSiteTree()) {
                throw new ApiException(ApiException.Type.MISSING_PARAMETER, PARAM_URL);
            }
            useUrl = false;
        } else if (context != null && !context.isInContext(url)) {
            throw new ApiException(ApiException.Type.URL_NOT_IN_CONTEXT, PARAM_URL);
        }
        StructuralNode node = null;
        if (useUrl) {
            URI startURI;
            try {
                if (scanChildren && url.endsWith("/")) {
                    url = url.substring(0, url.length() - 1);
                }
                startURI = new URI(url, true);
            }
            catch (URIException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL, e);
            }
            String scheme = startURI.getScheme();
            if (scheme == null || !scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "url does not have a scheme.");
            }
            try {
                Model model = Model.getSingleton();
                node = SessionStructure.find(model, startURI, method, postData);
                if (node == null && "GET".equalsIgnoreCase(method)) {
                    node = SessionStructure.find(model, startURI, null, postData);
                }
            }
            catch (Exception e) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)e);
            }
            if (node == null) {
                throw new ApiException(ApiException.Type.URL_NOT_FOUND);
            }
        }
        if (useUrl) {
            target = new Target(node);
            target.setContext(context);
        } else {
            target = new Target(context);
        }
        target.setRecurse(scanChildren);
        target.setInScopeOnly(scanJustInScope);
        switch (Control.getSingleton().getMode()) {
            case safe: {
                throw new ApiException(ApiException.Type.MODE_VIOLATION);
            }
            case protect: {
                if ((!useUrl || Model.getSingleton().getSession().isInScope(url)) && (context == null || context.isInScope())) break;
                throw new ApiException(ApiException.Type.MODE_VIOLATION);
            }
            case standard: {
                break;
            }
        }
        Object[] objs = new Object[]{};
        if (policy != null) {
            objs = new Object[]{policy};
        }
        return this.controller.startScan(null, target, user, objs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        ApiResponse result;
        ActiveScan activeScan = null;
        switch (name) {
            case "status": {
                activeScan = this.getActiveScan(params);
                int progress = 0;
                progress = activeScan.isStopped() ? 100 : activeScan.getProgress();
                result = new ApiResponseElement(name, String.valueOf(progress));
                break;
            }
            case "scans": {
                ApiResponseList resultList = new ApiResponseList(name);
                for (ActiveScan scan : this.controller.getAllScans()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(PARAM_ID, Integer.toString(scan.getScanId()));
                    map.put("progress", Integer.toString(scan.getProgress()));
                    map.put("state", scan.getState().name());
                    map.put("reqCount", Integer.toString(scan.getTotalRequests()));
                    map.put("alertCount", Integer.toString(scan.getAlertsIds().size()));
                    map.put("newAlertCount", Integer.toString(scan.getTotalNewAlerts()));
                    resultList.addItem(new ApiResponseSet(ACTION_SCAN, map));
                }
                result = resultList;
                break;
            }
            case "scanProgress": {
                ApiResponseList resultList = new ApiResponseList(name);
                activeScan = this.getActiveScan(params);
                for (HostProcess hp : activeScan.getHostProcesses()) {
                    ApiResponseList hpList = new ApiResponseList("HostProcess");
                    resultList.addItem(new ApiResponseElement(PARAM_ID, hp.getHostAndPort()));
                    for (Plugin plugin : hp.getCompleted()) {
                        long timeTaken = plugin.getTimeFinished().getTime() - plugin.getTimeStarted().getTime();
                        int reqs = hp.getPluginRequestCount(plugin.getId());
                        int alertCount = hp.getPluginStats(plugin.getId()).getAlertCount();
                        hpList.addItem(ActiveScanAPI.createPluginProgressEntry(plugin, ActiveScanAPI.getStatus(hp, plugin, "Complete"), timeTaken, reqs, alertCount));
                    }
                    for (Plugin plugin : hp.getRunning()) {
                        int pc = hp.getTestCurrentCount(plugin) * 100 / hp.getTestTotalCount();
                        if (pc >= 100) {
                            pc = 99;
                        }
                        long timeTaken = new Date().getTime() - plugin.getTimeStarted().getTime();
                        int reqs = hp.getPluginRequestCount(plugin.getId());
                        int alertCount = hp.getPluginStats(plugin.getId()).getAlertCount();
                        hpList.addItem(ActiveScanAPI.createPluginProgressEntry(plugin, pc + "%", timeTaken, reqs, alertCount));
                    }
                    for (Plugin plugin : hp.getPending()) {
                        hpList.addItem(ActiveScanAPI.createPluginProgressEntry(plugin, ActiveScanAPI.getStatus(hp, plugin, "Pending"), 0L, 0, 0));
                    }
                    resultList.addItem(hpList);
                }
                result = resultList;
                break;
            }
            case "messagesIds": {
                ApiResponseList resultList = new ApiResponseList(name);
                activeScan = this.getActiveScan(params);
                List<Integer> list = activeScan.getMessagesIds();
                synchronized (list) {
                    for (Integer id : activeScan.getMessagesIds()) {
                        resultList.addItem(new ApiResponseElement(PARAM_ID, id.toString()));
                    }
                }
                result = resultList;
                break;
            }
            case "alertsIds": {
                ApiResponseList resultList = new ApiResponseList(name);
                activeScan = this.getActiveScan(params);
                List<Integer> list = activeScan.getAlertsIds();
                synchronized (list) {
                    for (Integer id : activeScan.getAlertsIds()) {
                        resultList.addItem(new ApiResponseElement(PARAM_ID, id.toString()));
                    }
                }
                result = resultList;
                break;
            }
            case "excludedFromScan": {
                result = new ApiResponseList(name);
                Session session = Model.getSingleton().getSession();
                List<String> regexs = session.getExcludeFromScanRegexs();
                for (String regex : regexs) {
                    ((ApiResponseList)result).addItem(new ApiResponseElement(PARAM_REGEX, regex));
                }
                break;
            }
            case "scanners": {
                ScanPolicy policy = this.getScanPolicyFromParams(params);
                List<Plugin> scanners = policy.getPluginFactory().getAllPlugin();
                int categoryId = this.getParam(params, PARAM_CATEGORY_ID, -1);
                if (categoryId != -1) {
                    ActiveScanAPI.verifyCategoryId(categoryId, PARAM_CATEGORY_ID);
                }
                ApiResponseList resultList = new ApiResponseList(name);
                for (Plugin scanner : scanners) {
                    if (categoryId != -1 && categoryId != scanner.getCategory()) continue;
                    resultList.addItem(new ScannerApiResponse(policy, scanner));
                }
                result = resultList;
                break;
            }
            case "policies": {
                ScanPolicy policy = this.getScanPolicyFromParams(params);
                String[] policies = Category.getAllNames();
                ApiResponseList resultList = new ApiResponseList(name);
                for (String pluginName : policies) {
                    int categoryId = Category.getCategory(pluginName);
                    Plugin.AttackStrength attackStrength = this.getPolicyAttackStrength(policy, categoryId);
                    Plugin.AlertThreshold alertThreshold = this.getPolicyAlertThreshold(policy, categoryId);
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(PARAM_ID, String.valueOf(categoryId));
                    map.put(PARAM_NAME, pluginName);
                    map.put(PARAM_ATTACK_STRENGTH, attackStrength == null ? "" : String.valueOf((Object)attackStrength));
                    map.put(PARAM_ALERT_THRESHOLD, alertThreshold == null ? "" : String.valueOf((Object)alertThreshold));
                    map.put("enabled", String.valueOf(this.isPolicyEnabled(policy, categoryId)));
                    resultList.addItem(new ApiResponseSet("policy", map));
                }
                result = resultList;
                break;
            }
            case "scanPolicyNames": {
                ApiResponseList resultList = new ApiResponseList(name);
                for (String policyName : this.controller.getPolicyManager().getAllPolicyNames()) {
                    resultList.addItem(new ApiResponseElement("policy", policyName));
                }
                result = resultList;
                break;
            }
            case "attackModeQueue": {
                result = new ApiResponseElement(name, String.valueOf(this.controller.getAttackModeStackSize()));
                break;
            }
            case "optionExcludedParamList": 
            case "excludedParams": {
                ApiResponseList resultList = new ApiResponseList(name);
                List<ScannerParamFilter> excludedParams = this.controller.getScannerParam().getExcludedParamList();
                for (int i = 0; i < excludedParams.size(); ++i) {
                    resultList.addItem(new ExcludedParamApiResponse(excludedParams.get(i), i));
                }
                result = resultList;
                break;
            }
            case "excludedParamTypes": {
                ApiResponseList resultList = new ApiResponseList(name);
                for (Map.Entry<Integer, String> type : ScannerParamFilter.getTypes().entrySet()) {
                    HashMap<String, String> typeData = new HashMap<String, String>();
                    typeData.put(PARAM_ID, Integer.toString(type.getKey()));
                    typeData.put(PARAM_NAME, type.getValue());
                    resultList.addItem(new ApiResponseSet(PARAM_TYPE, typeData));
                }
                result = resultList;
                break;
            }
            default: {
                throw new ApiException(ApiException.Type.BAD_VIEW);
            }
        }
        return result;
    }

    private static ApiResponseList createPluginProgressEntry(Plugin plugin, String status, long timeTaken, int requestCount, int alertCount) {
        ApiResponseList pList = new ApiResponseList("Plugin");
        pList.addItem(new ApiResponseElement(PARAM_NAME, plugin.getName()));
        pList.addItem(new ApiResponseElement(PARAM_ID, Integer.toString(plugin.getId())));
        pList.addItem(new ApiResponseElement("quality", plugin.getStatus().toString()));
        pList.addItem(new ApiResponseElement(VIEW_STATUS, status));
        pList.addItem(new ApiResponseElement("timeInMs", Long.toString(timeTaken)));
        pList.addItem(new ApiResponseElement("reqCount", Integer.toString(requestCount)));
        pList.addItem(new ApiResponseElement("alertCount", Integer.toString(alertCount)));
        return pList;
    }

    private boolean isPolicyEnabled(ScanPolicy policy, int category) {
        for (Plugin scanner : policy.getPluginFactory().getAllPlugin()) {
            if (scanner.getCategory() != category || scanner.isEnabled()) continue;
            return false;
        }
        return true;
    }

    private Plugin.AttackStrength getPolicyAttackStrength(ScanPolicy policy, int categoryd) {
        Plugin.AttackStrength attackStrength = null;
        for (Plugin scanner : policy.getPluginFactory().getAllPlugin()) {
            if (scanner.getCategory() != categoryd) continue;
            if (attackStrength == null) {
                attackStrength = scanner.getAttackStrength(true);
                continue;
            }
            if (attackStrength.equals((Object)scanner.getAttackStrength(true))) continue;
            return null;
        }
        return attackStrength;
    }

    private Plugin.AlertThreshold getPolicyAlertThreshold(ScanPolicy policy, int categoryId) {
        Plugin.AlertThreshold alertThreshold = null;
        for (Plugin scanner : policy.getPluginFactory().getAllPlugin()) {
            if (scanner.getCategory() != categoryId) continue;
            if (alertThreshold == null) {
                alertThreshold = scanner.getAlertThreshold(true);
                continue;
            }
            if (alertThreshold.equals((Object)scanner.getAlertThreshold(true))) continue;
            return null;
        }
        return alertThreshold;
    }

    private static String getStatus(HostProcess hp, Plugin plugin, String defaultStatus) {
        if (!hp.isSkipped(plugin)) {
            return defaultStatus;
        }
        String skippedReason = hp.getSkippedReason(plugin);
        if (skippedReason == null) {
            return Constant.messages.getString("ascan.progress.label.skipped");
        }
        return Constant.messages.getString("ascan.progress.label.skippedWithReason", skippedReason);
    }

    private class ScannerApiResponse
    extends ApiResponse {
        final Map<String, String> scannerData;
        final ApiResponseList dependencies;

        public ScannerApiResponse(ScanPolicy policy, Plugin scanner) {
            super("scanner");
            this.scannerData = new HashMap<String, String>();
            this.scannerData.put(ActiveScanAPI.PARAM_ID, String.valueOf(scanner.getId()));
            this.scannerData.put(ActiveScanAPI.PARAM_NAME, scanner.getName());
            this.scannerData.put("cweId", String.valueOf(scanner.getCweId()));
            this.scannerData.put("wascId", String.valueOf(scanner.getWascId()));
            this.scannerData.put(ActiveScanAPI.PARAM_ATTACK_STRENGTH, String.valueOf((Object)scanner.getAttackStrength(true)));
            this.scannerData.put(ActiveScanAPI.PARAM_ALERT_THRESHOLD, String.valueOf((Object)scanner.getAlertThreshold(true)));
            this.scannerData.put(ActiveScanAPI.PARAM_CATEGORY_ID, String.valueOf(scanner.getCategory()));
            this.scannerData.put("enabled", String.valueOf(scanner.isEnabled()));
            this.scannerData.put("quality", scanner.getStatus().toString());
            this.scannerData.put(ActiveScanAPI.VIEW_STATUS, scanner.getStatus().toString());
            boolean allDepsAvailable = policy.getPluginFactory().hasAllDependenciesAvailable(scanner);
            this.scannerData.put("allDependenciesAvailable", Boolean.toString(allDepsAvailable));
            this.dependencies = new ApiResponseList("dependencies");
            for (Plugin dependency : policy.getPluginFactory().getDependencies(scanner)) {
                this.dependencies.addItem(new ApiResponseElement("dependency", Integer.toString(dependency.getId())));
            }
        }

        @Override
        public void toXML(Document doc, Element parent) {
            parent.setAttribute(ActiveScanAPI.PARAM_TYPE, "set");
            for (Map.Entry<String, String> val : this.scannerData.entrySet()) {
                Element el = doc.createElement(val.getKey());
                el.appendChild(doc.createTextNode(XMLStringUtil.escapeControlChrs(val.getValue())));
                parent.appendChild(el);
            }
            Element el = doc.createElement(this.dependencies.getName());
            this.dependencies.toXML(doc, el);
            parent.appendChild(el);
        }

        @Override
        public JSON toJSON() {
            JSONObject jo = new JSONObject();
            for (Map.Entry<String, String> val : this.scannerData.entrySet()) {
                jo.put((Object)val.getKey(), (Object)val.getValue());
            }
            jo.put((Object)this.dependencies.getName(), (Object)((JSONObject)this.dependencies.toJSON()).getJSONArray(this.dependencies.getName()));
            return jo;
        }

        @Override
        public void toHTML(StringBuilder sb) {
            sb.append("<h2>" + this.getName() + "</h2>\n");
            sb.append("<table border=\"1\">\n");
            for (Map.Entry<String, String> val : this.scannerData.entrySet()) {
                sb.append("<tr><td>\n");
                sb.append(val.getKey());
                sb.append("</td><td>\n");
                sb.append(StringEscapeUtils.escapeHtml((String)val.getValue()));
                sb.append("</td></tr>\n");
            }
            sb.append("<tr><td>\n");
            sb.append(this.dependencies.getName());
            sb.append("</td><td>\n");
            sb.append("<table border=\"1\">\n");
            for (ApiResponse resp : this.dependencies.getItems()) {
                sb.append("<tr><td>\n");
                resp.toHTML(sb);
                sb.append("</td></tr>\n");
            }
            sb.append("</table>\n");
            sb.append("</td></tr>\n");
            sb.append("</table>\n");
        }

        @Override
        public String toString(int indent) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < indent; ++i) {
                sb.append("\t");
            }
            sb.append("ScannerApiResponse ");
            sb.append(this.getName());
            sb.append(" : [\n");
            for (Map.Entry<String, String> val : this.scannerData.entrySet()) {
                for (int i = 0; i < indent + 1; ++i) {
                    sb.append("\t");
                }
                sb.append(val.getKey());
                sb.append(" = ");
                sb.append(val.getValue());
                sb.append("\n");
            }
            this.dependencies.toString(indent + 1);
            for (int i = 0; i < indent; ++i) {
                sb.append("\t");
            }
            sb.append("]\n");
            return sb.toString();
        }
    }

    private static class ExcludedParamApiResponse
    extends ApiResponse {
        private final Map<String, String> excludedParamData = new HashMap<String, String>();
        private final ApiResponseSet<String> type;
        private final Map<String, String> typeData;

        public ExcludedParamApiResponse(ScannerParamFilter param, int idx) {
            super("excludedParam");
            this.excludedParamData.put(ActiveScanAPI.PARAM_IDX, Integer.toString(idx));
            this.excludedParamData.put("parameter", param.getParamName());
            this.excludedParamData.put(ActiveScanAPI.PARAM_URL, param.getWildcardedUrl());
            this.typeData = new HashMap<String, String>();
            this.typeData.put(ActiveScanAPI.PARAM_ID, Integer.toString(param.getType()));
            this.typeData.put(ActiveScanAPI.PARAM_NAME, param.getTypeString());
            this.type = new ApiResponseSet<String>(ActiveScanAPI.PARAM_TYPE, this.typeData);
        }

        @Override
        public void toXML(Document doc, Element parent) {
            parent.setAttribute(ActiveScanAPI.PARAM_TYPE, "set");
            for (Map.Entry<String, String> val : this.excludedParamData.entrySet()) {
                Element el = doc.createElement(val.getKey());
                el.appendChild(doc.createTextNode(XMLStringUtil.escapeControlChrs(val.getValue())));
                parent.appendChild(el);
            }
            Element el = doc.createElement(this.type.getName());
            this.type.toXML(doc, el);
            parent.appendChild(el);
        }

        @Override
        public JSON toJSON() {
            JSONObject jo = new JSONObject();
            for (Map.Entry<String, String> val : this.excludedParamData.entrySet()) {
                jo.put((Object)val.getKey(), (Object)val.getValue());
            }
            jo.put((Object)this.type.getName(), (Object)this.type.toJSON());
            return jo;
        }

        @Override
        public void toHTML(StringBuilder sb) {
            sb.append("<h2>" + this.getName() + "</h2>\n");
            sb.append("<table border=\"1\">\n");
            for (Map.Entry<String, String> val : this.excludedParamData.entrySet()) {
                sb.append("<tr><td>\n");
                sb.append(val.getKey());
                sb.append("</td><td>\n");
                sb.append(StringEscapeUtils.escapeHtml((String)val.getValue()));
                sb.append("</td></tr>\n");
            }
            sb.append("<tr><td>\n");
            sb.append(this.type.getName());
            sb.append("</td><td>\n");
            sb.append("<table border=\"1\">\n");
            for (Map.Entry<String, String> val : this.typeData.entrySet()) {
                sb.append("<tr><td>\n");
                sb.append(StringEscapeUtils.escapeHtml((String)val.getKey()));
                sb.append("</td><td>\n");
                String value = val.getValue();
                if (value != null) {
                    sb.append(StringEscapeUtils.escapeHtml((String)value.toString()));
                }
                sb.append("</td></tr>\n");
            }
            sb.append("</table>\n");
            sb.append("</td></tr>\n");
            sb.append("</table>\n");
        }

        @Override
        public String toString(int indent) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < indent; ++i) {
                sb.append("\t");
            }
            sb.append("ApiResponseSet ");
            sb.append(this.getName());
            sb.append(" : [\n");
            for (Map.Entry<String, String> val : this.excludedParamData.entrySet()) {
                for (int i = 0; i < indent + 1; ++i) {
                    sb.append("\t");
                }
                sb.append(val.getKey());
                sb.append(" = ");
                sb.append(val.getValue());
                sb.append("\n");
            }
            sb.append(this.type.toString(indent + 1));
            for (int i = 0; i < indent; ++i) {
                sb.append("\t");
            }
            sb.append("]\n");
            return sb.toString();
        }
    }
}

