/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionLoader;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.control.CoreFunctionality;
import org.zaproxy.zap.control.ExtensionFactory;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.pscan.OptionsPassiveScan;
import org.zaproxy.zap.extension.pscan.PassiveScanAPI;
import org.zaproxy.zap.extension.pscan.PassiveScanController;
import org.zaproxy.zap.extension.pscan.PassiveScanParam;
import org.zaproxy.zap.extension.pscan.PassiveScanTask;
import org.zaproxy.zap.extension.pscan.PassiveScanner;
import org.zaproxy.zap.extension.pscan.PassiveScannerList;
import org.zaproxy.zap.extension.pscan.PassiveScannerOptionsPanel;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;
import org.zaproxy.zap.extension.pscan.PolicyPassiveScanPanel;
import org.zaproxy.zap.extension.pscan.scanner.RegexAutoTagScanner;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptType;
import org.zaproxy.zap.view.ScanStatus;

public class ExtensionPassiveScan
extends ExtensionAdaptor
implements SessionChangedListener {
    public static final String NAME = "ExtensionPassiveScan";
    public static final String SCRIPT_TYPE_PASSIVE = "passive";
    public static final int PROXY_LISTENER_ORDER = 5001;
    private static final Logger LOGGER = LogManager.getLogger(ExtensionPassiveScan.class);
    private PassiveScannerList scannerList;
    private OptionsPassiveScan optionsPassiveScan = null;
    private PolicyPassiveScanPanel policyPanel = null;
    private PassiveScanController psc = null;
    private boolean passiveScanEnabled;
    private PassiveScanParam passiveScanParam;
    private static final List<Class<? extends Extension>> DEPENDENCIES;
    private ScanStatus scanStatus = null;
    private PassiveScannerOptionsPanel passiveScannerOptionsPanel;

    public ExtensionPassiveScan() {
        this.setOrder(26);
        this.setName(NAME);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("pscan.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        ExtensionScript extScript;
        super.hook(extensionHook);
        extensionHook.addOptionsParamSet(this.getPassiveScanParam());
        extensionHook.addProxyListener(new PassiveScanProxyListener());
        extensionHook.addSessionListener(this);
        if (this.getView() != null) {
            extensionHook.getHookView().addOptionPanel(this.getPassiveScannerOptionsPanel());
            extensionHook.getHookView().addOptionPanel(this.getOptionsPassiveScan());
            extensionHook.getHookView().addOptionPanel(this.getPolicyPanel());
            this.getView().getMainFrame().getMainFooterPanel().addFooterToolbarRightLabel(this.getScanStatus().getCountLabel());
        }
        if ((extScript = Control.getSingleton().getExtensionLoader().getExtension(ExtensionScript.class)) != null) {
            extScript.registerScriptType(new ScriptType(SCRIPT_TYPE_PASSIVE, "pscan.scripts.type.passive", this.createScriptIcon(), true));
        }
        extensionHook.addApiImplementor(new PassiveScanAPI(this));
    }

    private ImageIcon createScriptIcon() {
        if (this.getView() == null) {
            return null;
        }
        return new ImageIcon(ExtensionPassiveScan.class.getResource("/resource/icon/16/script-pscan.png"));
    }

    @Override
    public void optionsLoaded() {
        this.getPassiveScannerList().setAutoTagScanners(this.getPassiveScanParam().getAutoTagScanners());
        this.passiveScanEnabled = true;
        this.getPassiveScanController();
    }

    @Override
    public List<String> getActiveActions() {
        int recordsToScan = this.getRecordsToScan();
        if (recordsToScan == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> activeActions = new ArrayList<String>(1);
        activeActions.add(Constant.messages.getString("pscan.activeAction", recordsToScan));
        return activeActions;
    }

    public boolean removePassiveScanner(String className) {
        PassiveScanner scanner = this.getPassiveScannerList().removeScanner(className);
        if (scanner != null && this.hasView() && scanner instanceof PluginPassiveScanner) {
            this.getPolicyPanel().getPassiveScanTableModel().removeScanner((PluginPassiveScanner)scanner);
        }
        return scanner != null;
    }

    public boolean addPassiveScanner(PassiveScanner passiveScanner) {
        if (passiveScanner == null) {
            throw new IllegalArgumentException("Parameter passiveScanner must not be null.");
        }
        if (passiveScanner instanceof PluginPassiveScanner) {
            return this.addPluginPassiveScannerImpl((PluginPassiveScanner)passiveScanner);
        }
        return this.addPassiveScannerImpl(passiveScanner);
    }

    public boolean removePassiveScanner(PassiveScanner passiveScanner) {
        if (passiveScanner == null) {
            throw new IllegalArgumentException("Parameter passiveScanner must not be null.");
        }
        return this.removePassiveScanner(passiveScanner.getClass().getName());
    }

    public boolean addPluginPassiveScanner(PluginPassiveScanner pluginPassiveScanner) {
        if (pluginPassiveScanner == null) {
            throw new IllegalArgumentException("Parameter pluginPassiveScanner must not be null.");
        }
        return this.addPluginPassiveScannerImpl(pluginPassiveScanner);
    }

    public boolean removePluginPassiveScanner(PluginPassiveScanner pluginPassiveScanner) {
        if (pluginPassiveScanner == null) {
            throw new IllegalArgumentException("Parameter pluginPassiveScanner must not be null.");
        }
        return this.removePassiveScanner(pluginPassiveScanner.getClass().getName());
    }

    private boolean addPassiveScannerImpl(PassiveScanner passiveScanner) {
        return this.getPassiveScannerList().add(passiveScanner);
    }

    private boolean addPluginPassiveScannerImpl(PluginPassiveScanner scanner) {
        if (scanner instanceof RegexAutoTagScanner) {
            return false;
        }
        boolean added = false;
        try {
            FileConfiguration config = this.getModel().getOptionsParam().getConfig();
            scanner.setConfig((Configuration)config);
            added = this.addPassiveScannerImpl(scanner);
            if (this.hasView()) {
                this.getPolicyPanel().getPassiveScanTableModel().addScanner(scanner);
            }
            LOGGER.info("loaded passive scan rule: {}", (Object)scanner.getName());
            if (scanner.getPluginId() == -1) {
                LOGGER.error("The passive scan rule \"{}\" [{}] does not have a defined ID.", (Object)scanner.getName(), (Object)scanner.getClass().getCanonicalName());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load passive scan rule {}", (Object)scanner.getName(), (Object)e);
        }
        return added;
    }

    protected PassiveScannerList getPassiveScannerList() {
        if (this.scannerList == null) {
            this.scannerList = new PassiveScannerList();
            this.scannerList.setAutoTagScanners(this.getPassiveScanParam().getAutoTagScanners());
            ArrayList<PluginPassiveScanner> listTest = new ArrayList<PluginPassiveScanner>(CoreFunctionality.getBuiltInPassiveScanRules());
            listTest.addAll(ExtensionFactory.getAddOnLoader().getPassiveScanRules());
            for (PluginPassiveScanner scanner : listTest) {
                this.addPluginPassiveScannerImpl(scanner);
            }
        }
        return this.scannerList;
    }

    public List<PluginPassiveScanner> getPluginPassiveScanners() {
        ArrayList<PluginPassiveScanner> pluginPassiveScanners = new ArrayList<PluginPassiveScanner>();
        for (PassiveScanner scanner : this.getPassiveScannerList().list()) {
            if (!(scanner instanceof PluginPassiveScanner) || scanner instanceof RegexAutoTagScanner) continue;
            pluginPassiveScanners.add((PluginPassiveScanner)scanner);
        }
        return pluginPassiveScanners;
    }

    void setAllPluginPassiveScannersEnabled(boolean enabled) {
        for (PluginPassiveScanner scanner : this.getPluginPassiveScanners()) {
            scanner.setEnabled(enabled);
            scanner.save();
        }
    }

    void setPluginPassiveScannerEnabled(int pluginId, boolean enabled) {
        PluginPassiveScanner scanner = this.getPluginPassiveScanner(pluginId);
        if (scanner != null) {
            scanner.setEnabled(enabled);
            scanner.save();
        }
    }

    public PluginPassiveScanner getPluginPassiveScanner(int id) {
        for (PluginPassiveScanner scanner : this.getPluginPassiveScanners()) {
            if (id != scanner.getPluginId()) continue;
            return scanner;
        }
        return null;
    }

    boolean hasPluginPassiveScanner(int pluginId) {
        return this.getPluginPassiveScanner(pluginId) != null;
    }

    void setPluginPassiveScannerAlertThreshold(int pluginId, Plugin.AlertThreshold alertThreshold) {
        PluginPassiveScanner scanner = this.getPluginPassiveScanner(pluginId);
        if (scanner != null) {
            scanner.setAlertThreshold(alertThreshold);
            scanner.setEnabled(!Plugin.AlertThreshold.OFF.equals((Object)alertThreshold));
            scanner.save();
        }
    }

    public void setAllScannerThreshold(Plugin.AlertThreshold at) {
        for (PluginPassiveScanner test : this.getPluginPassiveScanners()) {
            test.setAlertThreshold(at);
            test.setEnabled(!Plugin.AlertThreshold.OFF.equals((Object)at));
            test.save();
        }
    }

    public Plugin.AlertThreshold getAllScannerThreshold() {
        Plugin.AlertThreshold at = null;
        for (PluginPassiveScanner test : this.getPluginPassiveScanners()) {
            if (at == null) {
                at = test.getAlertThreshold();
                continue;
            }
            if (at.equals((Object)test.getAlertThreshold())) continue;
            return null;
        }
        return at;
    }

    protected PolicyPassiveScanPanel getPolicyPanel() {
        if (this.policyPanel == null) {
            this.policyPanel = new PolicyPassiveScanPanel();
        }
        return this.policyPanel;
    }

    public int getRecordsToScan() {
        if (this.passiveScanEnabled) {
            return this.getPassiveScanController().getRecordsToScan();
        }
        return 0;
    }

    private PassiveScanController getPassiveScanController() {
        if (this.passiveScanEnabled && this.psc == null) {
            ExtensionLoader extensionLoader = Control.getSingleton().getExtensionLoader();
            this.psc = new PassiveScanController(this, extensionLoader.getExtension(ExtensionHistory.class), extensionLoader.getExtension(ExtensionAlert.class), this.getPassiveScanParam(), this.hasView() ? this.getScanStatus() : null);
            this.psc.setSession(Model.getSingleton().getSession());
            this.psc.start();
        }
        return this.psc;
    }

    public void clearQueue() {
        if (this.passiveScanEnabled) {
            this.getPassiveScanController().clearQueue();
        }
    }

    PassiveScanParam getPassiveScanParam() {
        if (this.passiveScanParam == null) {
            this.passiveScanParam = new PassiveScanParam();
        }
        return this.passiveScanParam;
    }

    private PassiveScannerOptionsPanel getPassiveScannerOptionsPanel() {
        if (this.passiveScannerOptionsPanel == null) {
            this.passiveScannerOptionsPanel = new PassiveScannerOptionsPanel(this, Constant.messages);
        }
        return this.passiveScannerOptionsPanel;
    }

    private OptionsPassiveScan getOptionsPassiveScan() {
        if (this.optionsPassiveScan == null) {
            this.optionsPassiveScan = new OptionsPassiveScan(this.getPassiveScannerList());
        }
        return this.optionsPassiveScan;
    }

    @Override
    public void sessionAboutToChange(Session session) {
        this.stopPassiveScanController();
    }

    @Override
    public void sessionChanged(Session session) {
        if (this.passiveScanEnabled) {
            this.getPassiveScanController().setSession(session);
        }
    }

    private void stopPassiveScanController() {
        if (this.psc != null) {
            this.psc.shutdown();
            this.psc = null;
        }
    }

    @Deprecated
    public String getCurrentRuleName() {
        PassiveScanTask task;
        if (this.passiveScanEnabled && (task = this.getPassiveScanController().getOldestRunningTask()) != null) {
            return task.getCurrentScanner().getName();
        }
        return null;
    }

    @Deprecated
    public String getCurrentUrl() {
        PassiveScanTask task;
        if (this.passiveScanEnabled && (task = this.getPassiveScanController().getOldestRunningTask()) != null) {
            return task.getURI().toString();
        }
        return null;
    }

    @Deprecated
    public long getCurrentRuleStartTime() {
        PassiveScanTask task;
        if (this.passiveScanEnabled && (task = this.getPassiveScanController().getOldestRunningTask()) != null) {
            return task.getStartTime();
        }
        return 0L;
    }

    public PassiveScanTask getOldestRunningTask() {
        if (this.passiveScanEnabled) {
            return this.getPassiveScanController().getOldestRunningTask();
        }
        return null;
    }

    public List<PassiveScanTask> getRunningTasks() {
        if (this.passiveScanEnabled) {
            return this.getPassiveScanController().getRunningTasks();
        }
        return null;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.stopPassiveScanController();
    }

    @Override
    public List<Class<? extends Extension>> getDependencies() {
        return DEPENDENCIES;
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("pscan.desc");
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    void setPassiveScanEnabled(boolean enabled) {
        if (this.passiveScanEnabled != enabled) {
            this.passiveScanEnabled = enabled;
            if (enabled) {
                this.getPassiveScanController();
            } else {
                this.stopPassiveScanController();
            }
        }
    }

    public void saveTo(Configuration conf) {
        for (PassiveScanner scanner : this.getPassiveScannerList().list()) {
            if (!(scanner instanceof PluginPassiveScanner) || scanner instanceof RegexAutoTagScanner) continue;
            ((PluginPassiveScanner)scanner).saveTo(conf);
        }
    }

    public void loadFrom(Configuration conf) {
        for (PassiveScanner scanner : this.getPassiveScannerList().list()) {
            if (!(scanner instanceof PluginPassiveScanner) || scanner instanceof RegexAutoTagScanner) continue;
            ((PluginPassiveScanner)scanner).loadFrom(conf);
        }
    }

    protected ScanStatus getScanStatus() {
        if (this.scanStatus == null) {
            this.scanStatus = new ScanStatus(new ImageIcon(ExtensionPassiveScan.class.getResource("/resource/icon/16/pscan.png")), Constant.messages.getString("pscan.footer.label"));
        }
        return this.scanStatus;
    }

    @Override
    public boolean supportsLowMemory() {
        return true;
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    static {
        ArrayList<Class<ExtensionAlert>> dep = new ArrayList<Class<ExtensionAlert>>(1);
        dep.add(ExtensionAlert.class);
        DEPENDENCIES = Collections.unmodifiableList(dep);
    }

    private class PassiveScanProxyListener
    implements ProxyListener {
        private PassiveScanProxyListener() {
        }

        @Override
        public int getArrangeableListenerOrder() {
            return 5001;
        }

        @Override
        public boolean onHttpRequestSend(HttpMessage msg) {
            if (ExtensionPassiveScan.this.psc != null) {
                ExtensionPassiveScan.this.psc.onHttpRequestSend(msg);
            }
            return true;
        }

        @Override
        public boolean onHttpResponseReceive(HttpMessage msg) {
            if (ExtensionPassiveScan.this.psc != null) {
                ExtensionPassiveScan.this.psc.onHttpResponseReceive(msg);
            }
            return true;
        }
    }
}

