/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.search;

import edu.umass.cs.benchlab.har.HarEntries;
import edu.umass.cs.benchlab.har.HarEntry;
import edu.umass.cs.benchlab.har.HarLog;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiOther;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseConversionUtils;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.search.ExtensionSearch;
import org.zaproxy.zap.extension.search.SearchListenner;
import org.zaproxy.zap.extension.search.SearchResult;
import org.zaproxy.zap.utils.HarUtils;

public class SearchAPI
extends ApiImplementor {
    private static final Logger LOGGER = LogManager.getLogger(SearchAPI.class);
    private static final String PREFIX = "search";
    private static final String VIEW_URLS_BY_URL_REGEX = "urlsByUrlRegex";
    private static final String VIEW_URLS_BY_REQUEST_REGEX = "urlsByRequestRegex";
    private static final String VIEW_URLS_BY_RESPONSE_REGEX = "urlsByResponseRegex";
    private static final String VIEW_URLS_BY_HEADER_REGEX = "urlsByHeaderRegex";
    private static final String VIEW_MESSAGES_BY_URL_REGEX = "messagesByUrlRegex";
    private static final String VIEW_MESSAGES_BY_REQUEST_REGEX = "messagesByRequestRegex";
    private static final String VIEW_MESSAGES_BY_RESPONSE_REGEX = "messagesByResponseRegex";
    private static final String VIEW_MESSAGES_BY_HEADER_REGEX = "messagesByHeaderRegex";
    private static final String OTHER_HAR_BY_URL_REGEX = "harByUrlRegex";
    private static final String OTHER_HAR_BY_REQUEST_REGEX = "harByRequestRegex";
    private static final String OTHER_HAR_BY_RESPONSE_REGEX = "harByResponseRegex";
    private static final String OTHER_HAR_BY_HEADER_REGEX = "harByHeaderRegex";
    private static final String PARAM_BASE_URL = "baseurl";
    private static final String PARAM_COUNT = "count";
    private static final String PARAM_REGEX = "regex";
    private static final String PARAM_START = "start";
    private ExtensionSearch extension;

    public SearchAPI(ExtensionSearch extension) {
        this.extension = extension;
        String[] searchMandatoryParams = new String[]{PARAM_REGEX};
        String[] searchOptionalParams = new String[]{PARAM_BASE_URL, PARAM_START, PARAM_COUNT};
        this.addApiView(new ApiView(VIEW_URLS_BY_URL_REGEX, searchMandatoryParams, searchOptionalParams));
        this.addApiView(new ApiView(VIEW_URLS_BY_REQUEST_REGEX, searchMandatoryParams, searchOptionalParams));
        this.addApiView(new ApiView(VIEW_URLS_BY_RESPONSE_REGEX, searchMandatoryParams, searchOptionalParams));
        this.addApiView(new ApiView(VIEW_URLS_BY_HEADER_REGEX, searchMandatoryParams, searchOptionalParams));
        this.addApiView(new ApiView(VIEW_MESSAGES_BY_URL_REGEX, searchMandatoryParams, searchOptionalParams));
        this.addApiView(new ApiView(VIEW_MESSAGES_BY_REQUEST_REGEX, searchMandatoryParams, searchOptionalParams));
        this.addApiView(new ApiView(VIEW_MESSAGES_BY_RESPONSE_REGEX, searchMandatoryParams, searchOptionalParams));
        this.addApiView(new ApiView(VIEW_MESSAGES_BY_HEADER_REGEX, searchMandatoryParams, searchOptionalParams));
        this.addApiOthers(new ApiOther(OTHER_HAR_BY_URL_REGEX, searchMandatoryParams, searchOptionalParams));
        this.addApiOthers(new ApiOther(OTHER_HAR_BY_REQUEST_REGEX, searchMandatoryParams, searchOptionalParams));
        this.addApiOthers(new ApiOther(OTHER_HAR_BY_RESPONSE_REGEX, searchMandatoryParams, searchOptionalParams));
        this.addApiOthers(new ApiOther(OTHER_HAR_BY_HEADER_REGEX, searchMandatoryParams, searchOptionalParams));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiView(final String name, JSONObject params) throws ApiException {
        SearchViewResponseType responseType;
        ExtensionSearch.Type searchType;
        final ApiResponseList result = new ApiResponseList(name);
        switch (name) {
            case "urlsByUrlRegex": {
                searchType = ExtensionSearch.Type.URL;
                responseType = SearchViewResponseType.URL;
                break;
            }
            case "messagesByUrlRegex": {
                searchType = ExtensionSearch.Type.URL;
                responseType = SearchViewResponseType.MESSAGE;
                break;
            }
            case "urlsByRequestRegex": {
                searchType = ExtensionSearch.Type.Request;
                responseType = SearchViewResponseType.URL;
                break;
            }
            case "messagesByRequestRegex": {
                searchType = ExtensionSearch.Type.Request;
                responseType = SearchViewResponseType.MESSAGE;
                break;
            }
            case "urlsByResponseRegex": {
                searchType = ExtensionSearch.Type.Response;
                responseType = SearchViewResponseType.URL;
                break;
            }
            case "messagesByResponseRegex": {
                searchType = ExtensionSearch.Type.Response;
                responseType = SearchViewResponseType.MESSAGE;
                break;
            }
            case "urlsByHeaderRegex": {
                searchType = ExtensionSearch.Type.Header;
                responseType = SearchViewResponseType.URL;
                break;
            }
            case "messagesByHeaderRegex": {
                searchType = ExtensionSearch.Type.Header;
                responseType = SearchViewResponseType.MESSAGE;
                break;
            }
            default: {
                throw new ApiException(ApiException.Type.BAD_VIEW);
            }
        }
        SearchAPI.validateRegex(params);
        try {
            SearchResultsProcessor processor = SearchViewResponseType.MESSAGE == responseType ? new SearchResultsProcessor(){

                @Override
                public void processRecordHistory(RecordHistory recordHistory) {
                    result.addItem(ApiResponseConversionUtils.httpMessageToSet(recordHistory.getHistoryId(), recordHistory.getHistoryType(), recordHistory.getHttpMessage()));
                }
            } : new SearchResultsProcessor(){

                @Override
                public void processRecordHistory(RecordHistory recordHistory) {
                    HttpMessage msg = recordHistory.getHttpMessage();
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", String.valueOf(recordHistory.getHistoryId()));
                    map.put("type", String.valueOf(recordHistory.getHistoryType()));
                    map.put("method", msg.getRequestHeader().getMethod());
                    map.put("url", msg.getRequestHeader().getURI().toString());
                    map.put("code", String.valueOf(msg.getResponseHeader().getStatusCode()));
                    map.put("time", String.valueOf(msg.getTimeElapsedMillis()));
                    result.addItem(new ApiResponseSet(name, map));
                }
            };
            this.search(params, searchType, processor);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
        }
        return result;
    }

    private static void validateRegex(JSONObject params) throws ApiException {
        try {
            Pattern.compile(params.getString(PARAM_REGEX));
        }
        catch (NullPointerException | PatternSyntaxException e) {
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_REGEX, e);
        }
    }

    @Override
    public HttpMessage handleApiOther(HttpMessage msg, String name, JSONObject params) throws ApiException {
        ExtensionSearch.Type searchType;
        byte[] responseBody = new byte[]{};
        switch (name) {
            case "harByUrlRegex": {
                searchType = ExtensionSearch.Type.URL;
                break;
            }
            case "harByRequestRegex": {
                searchType = ExtensionSearch.Type.Request;
                break;
            }
            case "harByResponseRegex": {
                searchType = ExtensionSearch.Type.Response;
                break;
            }
            case "harByHeaderRegex": {
                searchType = ExtensionSearch.Type.Header;
                break;
            }
            default: {
                throw new ApiException(ApiException.Type.BAD_OTHER);
            }
        }
        SearchAPI.validateRegex(params);
        try {
            HarEntries entries = new HarEntries();
            this.search(params, searchType, rh -> {
                HarEntry entry = HarUtils.createHarEntry(rh.getHistoryId(), rh.getHistoryType(), rh.getHttpMessage());
                entries.addEntry(entry);
            });
            HarLog harLog = HarUtils.createZapHarLog();
            harLog.setEntries(entries);
            responseBody = HarUtils.harLogToByteArray(harLog);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ApiException apiException = new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
            responseBody = apiException.toString(API.Format.JSON, this.incErrorDetails()).getBytes(StandardCharsets.UTF_8);
        }
        try {
            msg.setResponseHeader(API.getDefaultResponseHeader("application/json; charset=UTF-8", responseBody.length));
        }
        catch (HttpMalformedHeaderException e) {
            LOGGER.error("Failed to create response header: {}", (Object)e.getMessage(), (Object)e);
        }
        msg.setResponseBody(responseBody);
        return msg;
    }

    private boolean incErrorDetails() {
        return Model.getSingleton().getOptionsParam().getApiParam().isIncErrorDetails();
    }

    private void search(JSONObject params, ExtensionSearch.Type searchType, SearchResultsProcessor processor) throws InterruptedException {
        ApiSearchListener searchListener = new ApiSearchListener();
        this.extension.search(params.getString(PARAM_REGEX), searchListener, searchType, false, false, this.getParam(params, PARAM_BASE_URL, null), this.getParam(params, PARAM_START, -1), this.getParam(params, PARAM_COUNT, -1), false);
        while (!searchListener.isSearchComplete()) {
            Thread.sleep(100L);
        }
        TableHistory tableHistory = Model.getSingleton().getDb().getTableHistory();
        for (Integer hRefId : searchListener.getHistoryReferencesIds()) {
            try {
                processor.processRecordHistory(tableHistory.read(hRefId));
            }
            catch (DatabaseException | HttpMalformedHeaderException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static class ApiSearchListener
    implements SearchListenner {
        private boolean searchComplete = false;
        private List<Integer> historyReferencesIds = new LinkedList<Integer>();

        @Override
        public void addSearchResult(SearchResult sr) {
            this.historyReferencesIds.add(sr.getMessage().getHistoryRef().getHistoryId());
        }

        @Override
        public void searchComplete() {
            this.searchComplete = true;
        }

        public boolean isSearchComplete() {
            return this.searchComplete;
        }

        public List<Integer> getHistoryReferencesIds() {
            return this.historyReferencesIds;
        }
    }

    private static interface SearchResultsProcessor {
        public void processRecordHistory(RecordHistory var1);
    }

    private static enum SearchViewResponseType {
        URL,
        MESSAGE;

    }
}

