/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.users;

import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.authentication.AuthenticationCredentials;
import org.zaproxy.zap.authentication.AuthenticationMethod;
import org.zaproxy.zap.extension.authentication.ExtensionAuthentication;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.session.WebSession;
import org.zaproxy.zap.users.AuthenticationState;
import org.zaproxy.zap.users.Role;
import org.zaproxy.zap.utils.Enableable;

public class User
extends Enableable {
    private static final Logger LOGGER = LogManager.getLogger(User.class);
    private static int ID_SOURCE = 0;
    private static final String FIELD_SEPARATOR = ";";
    private int id;
    private String name;
    private int contextId;
    private List<Role> roles;
    private WebSession authenticatedSession;
    private AuthenticationCredentials authenticationCredentials;
    private static ExtensionAuthentication extensionAuth;
    private Context context;
    private AuthenticationState authenticationState = new AuthenticationState();

    public User(int contextId, String name) {
        this.id = ID_SOURCE++;
        this.contextId = contextId;
        this.name = name;
    }

    public User(int contextId, String name, int id) {
        this.id = id;
        if (this.id >= ID_SOURCE) {
            ID_SOURCE = this.id + 1;
        }
        this.contextId = contextId;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getContextId() {
        return this.contextId;
    }

    public String toString() {
        return "User [id=" + this.id + ", name=" + this.name + ", contextId=" + this.contextId + ", enabled=" + this.isEnabled() + "]";
    }

    public Context getContext() {
        if (this.context == null) {
            this.context = Model.getSingleton().getSession().getContext(this.contextId);
        }
        return this.context;
    }

    public int getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessageToMatchUser(HttpMessage message) {
        User user = this;
        synchronized (user) {
            if (this.requiresAuthentication()) {
                this.authenticate();
                if (this.requiresAuthentication()) {
                    LOGGER.info("Authentication failed for user: {}", (Object)this.name);
                    return;
                }
            }
        }
        this.processMessageToMatchAuthenticatedSession(message);
    }

    public void processMessageToMatchAuthenticatedSession(HttpMessage message) {
        this.getContext().getSessionManagementMethod().processMessageToMatchSession(message, this.authenticatedSession);
    }

    public AuthenticationCredentials getAuthenticationCredentials() {
        return this.authenticationCredentials;
    }

    public void setAuthenticationCredentials(AuthenticationCredentials authenticationCredentials) {
        this.authenticationCredentials = authenticationCredentials;
    }

    public boolean requiresAuthentication() {
        return this.authenticatedSession == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueAuthentication(HttpMessage unauthenticatedMessage) {
        User user = this;
        synchronized (user) {
            if (unauthenticatedMessage.getTimeSentMillis() >= this.getAuthenticationState().getLastSuccessfulAuthTime()) {
                this.authenticatedSession = null;
            }
        }
    }

    @Deprecated
    protected long getLastSuccessfulAuthTime() {
        return this.getAuthenticationState().getLastSuccessfulAuthTime();
    }

    public boolean isAuthenticated(HttpMessage msg) {
        return this.getContext().getAuthenticationMethod().isAuthenticated(msg, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate() {
        LOGGER.info("Authenticating user: {}", (Object)this.name);
        WebSession result = null;
        try {
            result = this.getContext().getAuthenticationMethod().authenticate(this.getContext().getSessionManagementMethod(), this.authenticationCredentials, this);
        }
        catch (AuthenticationMethod.UnsupportedAuthenticationCredentialsException e) {
            LOGGER.error("User does not have the expected type of credentials:", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while authenticating:", (Throwable)e);
            return;
        }
        User user = this;
        synchronized (user) {
            this.getAuthenticationState().setLastSuccessfulAuthTime(System.currentTimeMillis());
            this.authenticatedSession = result;
        }
    }

    private static ExtensionAuthentication getAuthenticationExtension() {
        if (extensionAuth == null) {
            extensionAuth = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAuthentication.class);
        }
        return extensionAuth;
    }

    public static String encode(User user) {
        StringBuilder out = new StringBuilder();
        out.append(user.id).append(FIELD_SEPARATOR);
        out.append(user.isEnabled()).append(FIELD_SEPARATOR);
        out.append(Base64.encodeBase64String(user.name.getBytes())).append(FIELD_SEPARATOR);
        out.append(user.getContext().getAuthenticationMethod().getType().getUniqueIdentifier()).append(FIELD_SEPARATOR);
        out.append(user.authenticationCredentials.encode(FIELD_SEPARATOR));
        LOGGER.debug("Encoded user: {}", (Object)out);
        return out.toString();
    }

    public static User decode(int contextId, String encodedString) {
        return User.decode(contextId, encodedString, User.getAuthenticationExtension());
    }

    protected static User decode(int contextId, String encodedString, ExtensionAuthentication authenticationExtension) {
        String[] pieces = encodedString.split(FIELD_SEPARATOR, -1);
        User user = null;
        try {
            int id = Integer.parseInt(pieces[0]);
            if (id >= ID_SOURCE) {
                ID_SOURCE = id + 1;
            }
            boolean enabled = pieces[1].equals("true");
            String name = new String(Base64.decodeBase64(pieces[2]));
            int authTypeId = Integer.parseInt(pieces[3]);
            user = new User(contextId, name, id);
            user.setEnabled(enabled);
            AuthenticationCredentials cred = authenticationExtension.getAuthenticationMethodTypeForIdentifier(authTypeId).createAuthenticationCredentials();
            cred.decode(pieces[4]);
            user.setAuthenticationCredentials(cred);
        }
        catch (Exception ex) {
            LOGGER.error("An error occured while decoding user from: {}", (Object)encodedString, (Object)ex);
            return null;
        }
        LOGGER.debug("Decoded user: {}", (Object)user);
        return user;
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return this.id == other.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HttpState getCorrespondingHttpState() {
        if (this.authenticatedSession != null) {
            return this.authenticatedSession.getHttpState();
        }
        return null;
    }

    public WebSession getAuthenticatedSession() {
        return this.authenticatedSession;
    }

    public void setAuthenticatedSession(WebSession session) {
        this.authenticatedSession = session;
    }

    public AuthenticationState getAuthenticationState() {
        return this.authenticationState;
    }
}

