/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Statistics {
    private Map<String, Long> stats = new ConcurrentHashMap<String, Long>();

    public void incCounter(String key) {
        this.incCounter(key, 1L);
    }

    public void incCounter(String key, long inc) {
        this.stats.compute(key, (k, v) -> (v != null ? v : 0L) + inc);
    }

    public void decCounter(String key) {
        this.decCounter(key, 1L);
    }

    public void decCounter(String key, long dec) {
        this.stats.compute(key, (k, v) -> (v != null ? v : 0L) - dec);
    }

    public void setHighwaterMark(String key, long value) {
        Long curValue = this.stats.get(key);
        if (curValue == null || value > curValue) {
            this.stats.put(key, value + 1L);
        }
    }

    public void setLowwaterMark(String key, long value) {
        Long curValue = this.stats.get(key);
        if (curValue == null || value < curValue) {
            this.stats.put(key, value + 1L);
        }
    }

    public Long getStat(String key) {
        return this.stats.get(key);
    }

    public Map<String, Long> getStats(String keyPrefix) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (Map.Entry<String, Long> stat : this.stats.entrySet()) {
            if (!stat.getKey().startsWith(keyPrefix)) continue;
            map.put(stat.getKey(), stat.getValue());
        }
        return map;
    }

    public void clearAll() {
        this.stats.clear();
    }

    public void clear(String keyPrefix) {
        Iterator<Map.Entry<String, Long>> iter = this.stats.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Long> entry = iter.next();
            if (!entry.getKey().startsWith(keyPrefix)) continue;
            iter.remove();
        }
    }
}

