/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.WordUtils;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnLoader;
import org.zaproxy.zap.control.ExtensionFactory;

public final class ZapSupportUtils {
    private static final String NEWLINE = System.lineSeparator();

    private ZapSupportUtils() {
    }

    public static String getProductName() {
        return "ZAP";
    }

    public static String getVersion() {
        return Constant.messages.getString("support.version.label") + " " + Constant.PROGRAM_VERSION;
    }

    public static String getZapHomeDirectory() {
        return Constant.messages.getString("support.home.directory.label") + " " + Constant.getZapHome();
    }

    public static String getZapInstallDirectory() {
        return Constant.messages.getString("support.install.directory.label") + " " + Constant.getZapInstall();
    }

    public static String getOperatingSystem() {
        return Constant.messages.getString("support.operating.system.label") + " " + System.getProperty("os.name");
    }

    public static String getArch() {
        return Constant.messages.getString("support.arch.label") + " " + System.getProperty("os.arch");
    }

    public static String getJavaVersionVendor() {
        String javaVersion = System.getProperty("java.version");
        String javaVendor = System.getProperty("java.vendor");
        return Constant.messages.getString("support.java.version.label") + " " + javaVendor + " " + javaVersion;
    }

    public static String getLocaleDisplay() {
        return Constant.messages.getString("support.locale.display.label") + " " + Locale.getDefault(Locale.Category.DISPLAY);
    }

    public static String getLocaleFormat() {
        return Constant.messages.getString("support.locale.format.label") + " " + Locale.getDefault(Locale.Category.FORMAT);
    }

    public static String getLocaleSystem() {
        return Constant.messages.getString("support.locale.system.label") + " " + Constant.getSystemsLocale();
    }

    public static String getLookAndFeel() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        Object strLaf = laf != null ? laf.getName() + " (" + laf.getClass().getCanonicalName() + ")" : "[null]";
        return Constant.messages.getString("support.laf.label") + " " + (String)strLaf;
    }

    public static String getInstalledAddons() {
        AddOnLoader addOnLoader = ExtensionFactory.getAddOnLoader();
        ArrayList<AddOn> sortedAddOns = new ArrayList<AddOn>(addOnLoader.getAddOnCollection().getInstalledAddOns());
        Collections.sort(sortedAddOns, new Comparator<AddOn>(){

            @Override
            public int compare(AddOn addOn, AddOn otherAddOn) {
                return addOn.getId().compareTo(otherAddOn.getId());
            }
        });
        return Constant.messages.getString("support.installed.addons.label") + " " + sortedAddOns;
    }

    public static String getDefaultCharset() {
        return Constant.messages.getString("support.charset.default.label") + " " + Charset.defaultCharset();
    }

    public static String getAll(boolean formatted) {
        StringBuilder installedAddons = new StringBuilder(200);
        if (formatted) {
            installedAddons.append(NEWLINE);
            installedAddons.append(WordUtils.wrap((String)ZapSupportUtils.getInstalledAddons(), (int)60)).append(NEWLINE);
            installedAddons.append(NEWLINE);
        } else {
            installedAddons.append(ZapSupportUtils.getInstalledAddons()).append(NEWLINE);
        }
        StringBuilder supportDetailsBuilder = new StringBuilder(300);
        supportDetailsBuilder.append(ZapSupportUtils.getProductName()).append(NEWLINE);
        supportDetailsBuilder.append(ZapSupportUtils.getVersion()).append(NEWLINE);
        supportDetailsBuilder.append((CharSequence)installedAddons);
        supportDetailsBuilder.append(ZapSupportUtils.getOperatingSystem()).append(NEWLINE);
        supportDetailsBuilder.append(ZapSupportUtils.getArch()).append(NEWLINE);
        supportDetailsBuilder.append(ZapSupportUtils.getJavaVersionVendor()).append(NEWLINE);
        supportDetailsBuilder.append(ZapSupportUtils.getLocaleSystem()).append(NEWLINE);
        supportDetailsBuilder.append(ZapSupportUtils.getLocaleDisplay()).append(NEWLINE);
        supportDetailsBuilder.append(ZapSupportUtils.getLocaleFormat()).append(NEWLINE);
        supportDetailsBuilder.append(ZapSupportUtils.getDefaultCharset()).append(NEWLINE);
        supportDetailsBuilder.append(ZapSupportUtils.getZapHomeDirectory()).append(NEWLINE);
        supportDetailsBuilder.append(ZapSupportUtils.getZapInstallDirectory()).append(NEWLINE);
        supportDetailsBuilder.append(ZapSupportUtils.getLookAndFeel()).append(NEWLINE);
        return supportDetailsBuilder.toString();
    }

    private static void addFileToZip(ZipOutputStream zipOut, String name, String contents) throws IOException {
        ZipEntry zipEntry = new ZipEntry(name);
        zipOut.putNextEntry(zipEntry);
        zipOut.write(contents.getBytes());
    }

    public static int saveSbomZip(File file) throws IOException {
        int count = 0;
        try (FileOutputStream fos = new FileOutputStream(file);
             ZipOutputStream zipOut = new ZipOutputStream(fos);){
            try (InputStream is = ZAP.class.getResourceAsStream("/bom.json");){
                if (is != null) {
                    ZapSupportUtils.addFileToZip(zipOut, "zap-core-bom.json", IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
                    ++count;
                }
            }
            List<AddOn> addOns = ExtensionFactory.getAddOnLoader().getAddOnCollection().getInstalledAddOns();
            for (AddOn addOn : addOns) {
                String sbom = addOn.getSbom();
                if (sbom == null) continue;
                ZapSupportUtils.addFileToZip(zipOut, addOn.getId() + "-bom.json", sbom);
                ++count;
            }
        }
        return count;
    }
}

