Cosanta Core staging tree 18.0
===========================

https://www.cosanta.net/


What is Cosanta?
-------------

Cosanta is an experimental digital ecosystem for provide services B2B, private
payments to anyone, anywhere in the world. Cosanta uses peer-to-peer technology
to operate with no central authority: managing transactions and issuing money
are carried out collectively by the network. Cosanta Core is the name of the open
source software which enables the use of this currency.

For more information, as well as an immediately useable, binary version of
the Cosanta Core software, see https://www.cosanta.net/.


## Pow / PoS Rewards Breakdown

| Block                 | Reward              | Masternodes | Miners / Stakers   | Expected Time       |
|---------------------- |:------------------- |:----------- |:------------------ |:--------------------|
| <11111                | 0.01  COSA + fees   |             |                    | 2021-07-17 18:28:33 |
| <22222                | 0.02  COSA + fees   |             |                    | 2021-08-06 22:02:05 |
| <33333                | 0.03  COSA + fees   |             |                    | 2021-08-27 05:25:21 |
| <44444                | 0.04  COSA + fees   |             |                    | 2021-09-16 11:44:17 |
| <55555                | 0.05  COSA + fees   |             |                    | 2021-10-06 17:57:52 |
| <66666                | 0.06  COSA + fees   |             |                    | 2021-10-27 00:47:10 |
| <77777                | 0.07  COSA + fees   |             |                    | 2021-10-27 00:47:10 |
| <88888                | 0.08  COSA + fees   |             |                    | 2021-12-06 12:37:27 |
| <99999                | 0.09  COSA + fees   |             |                    | 2021-12-26 18:42:32 |
| <111111               | 0.10  COSA + fees   |             |                    | 2022-01-16 00:56:07 |
| <222222               | 0.20  COSA + fees   |             |                    | 2022-02-05 07:15:28 |
| <333333               | 0.30  COSA + fees   |             |                    | 2022-08-26 23:26:51 |
| <444444               | 0.40  COSA + fees   |             |                    | 2023-03-16 20:07:18 |
| <555555               | 0.50  COSA + fees   |             |                    | 2023-10-04 18:47:45 |
| <666666               | 0.60  COSA + fees   |             |                    | 2024-04-23 16:28:12 |
| <700000               | 0.70  COSA + fees   |             |                    | 2024-11-11 13:08:39 |
| <800000               | 0.80  COSA + fees   | 0.1%        | 99.9%              | 2025-01-11 02:52:37 |
| <900000               | 0.90  COSA + fees   | 0.1%        | 99.9%              | 2025-07-11 20:59:17 |
| <910000               |  1    COSA + fees   | 0.1%        | 99.9%              | 2026-01-09 13:05:57 |
| <920000               |  2    COSA + fees   | 0.1%        | 99.9%              | 2026-01-27 17:12:37 |
| <930000               |  3    COSA + fees   | 0.1%        | 99.9%              | 2026-02-14 21:19:17 |
| <940000               |  4    COSA + fees   | 0.1%        | 99.9%              | 2026-03-05 01:25:57 |
| <950000               |  5    COSA + fees   | 0.1%        | 99.9%              | 2026-03-23 05:32:37 |
| <960000               |  6    COSA + fees   | 0.1%        | 99.9%              | 2026-04-10 10:39:17 |
| <970000               |  7    COSA + fees   | 0.1%        | 99.9%              | 2026-04-28 14:45:57 |
| <980000               |  8    COSA + fees   | 0.1%        | 99.9%              | 2026-05-16 18:52:37 |
| <990000               |  9    COSA + fees   | 0.1%        | 99.9%              | 2026-06-03 22:59:17 |
| <991000               | 10    COSA + fees   | 0.1%        | 99.9%              | 2026-06-22 03:05:57 |
| <992000               | 15    COSA + fees   | 0.1%        | 99.9%              | 2026-06-23 22:42:37 |
| <993000               | 20    COSA + fees   | 0.1%        | 99.9%              | 2026-06-25 18:19:17 |
| <994000               | 25    COSA + fees   | 0.1%        | 99.9%              | 2026-06-27 13:55:57 |
| <995000               | 30    COSA + fees   | 0.1%        | 99.9%              | 2026-06-29 09:32:37 |
| <996000               | 35    COSA + fees   | 0.1%        | 99.9%              | 2026-07-01 05:09:17 |
| <997000               | 40    COSA + fees   | 0.1%        | 99.9%              | 2026-07-03 00:45:57 |
| <998000               | 42.5  COSA + fees   | 0.1%        | 99.9%              | 2026-07-04 20:22:37 |
| <999000               | 45    COSA + fees   | 0.1%        | 99.9%              | 2026-07-06 15:59:17 |
| <1048576              | 50    COSA + fees   | 0.1%        | 99.9%              | 2026-07-08 11:35:57 |
| 1048576 (0x100000)    | 25    COSA + fees   | 0.1%        | 99.9%              | 2026-10-06 13:47:40 |
| 2097152 (0x200000)    | 12.5  COSA + fees   | 0.1%        | 99.9%              | 2031-12-24 22:24:09 |
| 3145728 (0x300000)    | 6.25  COSA + fees   | 0.1%        | 99.9%              | 2037-03-13 08:00:38 |
| 4194304 (0x400000)    | 3.125 COSA + fees   | 0.1%        | 99.9%              | 2042-05-31 18:37:07 |
| ...                   | ...                 | 0.1%        | 99.9%              |                     |
| 34603008 (0x2100000)  | ~0    COSA + fees   | 0.1%        | 99.9%              | 2188-06-25 23:38:39 |

For more information, as well as an immediately usable, binary version of
the Cosanta Core software, see https://cosanta.net/en/download/.

License
-------

Cosanta Core is released under the terms of the MIT license. See [COPYING](COPYING) for more
information or see https://opensource.org/licenses/MIT.

Development Process
-------------------

The `master` branch is meant to be stable. Development is normally done in separate branches.
[Tags](https://github.com/cosanta/cosanta-core/tags) are created to indicate new official,
stable release versions of Cosanta Core.

The contribution workflow is described in [CONTRIBUTING.md](CONTRIBUTING.md).

Testing
-------

Testing and code review is the bottleneck for development; we get more pull
requests than we can review and test on short notice. Please be patient and help out by testing
other people's pull requests, and remember this is a security-critical project where any mistake might cost people
lots of money.

### Automated Testing

Developers are strongly encouraged to write [unit tests](src/test/README.md) for new code, and to
submit new unit tests for old code. Unit tests can be compiled and run
(assuming they weren't disabled in configure) with: `make check`. Further details on running
and extending unit tests can be found in [/src/test/README.md](/src/test/README.md).

There are also [regression and integration tests](/test), written
in Python, that are run automatically on the build server.
These tests can be run (if the [test dependencies](/test) are installed) with: `test/functional/test_runner.py`

The Travis CI system makes sure that every pull request is built for Windows, Linux, and macOS, and that unit/sanity tests are run automatically.

### Manual Quality Assurance (QA) Testing

Changes should be tested by somebody other than the developer who wrote the
code. This is especially important for large or high-risk changes. It is useful
to add a test plan to the pull request description if testing the changes is
not straightforward.

Translations
------------

Changes to translations as well as new translations can be submitted to
[Cosanta Core's Transifex page](https://www.transifex.com/projects/p/cosanta/).

Translations are periodically pulled from Transifex and merged into the git repository. See the
[translation process](doc/translation_process.md) for details on how this works.

**Important**: We do not accept translation changes as GitHub pull requests because the next
pull from Transifex would automatically overwrite them again.

