# GStreamer Debian 10 (Buster) backports

This repository provides the packages for the latest GStreamer stable
release, backported to Debian 10

In order to be able to pull in the packages; add the following to a file
in /etc/apt/sources.list.d/

```
deb http://download.opensuse.org/repositories/home:/den_erpel/Debian_10/ ./
```

Save the public key (click open the "show more") in a file and import it with

```
$ cat _pubkey
-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: GnuPG v2.0.15 (GNU/Linux)

mQENBF+3hvEBCACmnyUXVkF1pyZVPGOXCBmHOL8KDpU5RV5C9vArRIA/Hf7cDiCy
HY4DNcT2tgz5QL3y9C0KMqDTkSaLLOYeSFEIl4ZtwXoVdfag36ji3+yKdGryHD8K
ziZ7m9IvSUh/8BxsJuTQcJsJFOd+VesfrVX4GlDjmyu0X4EA0GWoDQsDQKDrddHn
uDv6YD31sg61/TWDzP879wskUp5iB7vR7WtgcREmTwReEJxUm+nCMOftIm7ftrYC
Sk97NY7VHysya1YJB7D6Gt7/yIhqMDJf9UpFVp661dr68eO0WAH8PIL7hHrbNh0s
SHeQWsivjcCx2MPUuM7zd4lvzbK+HQVGgfFBABEBAAG0PmhvbWU6ZGVuX2VycGVs
IE9CUyBQcm9qZWN0IDxob21lOmRlbl9lcnBlbEBidWlsZC5vcGVuc3VzZS5vcmc+
iQE+BBMBCAAoBQJft4bxAhsDBQkEHrAABgsJCAcDAgYVCAIJCgsEFgIDAQIeAQIX
gAAKCRDAmcqN/RWohQrlB/0XRUMaNi2pB7xCAKEvBNfKmeb9YlhPJoyPML64K+iz
mkFZMHK76NJTwen7qP0UiXkrOEAe5YE+OWwmgmcM7QUuc/rANR79I/6WgWx1sb0D
m4uhXNDqrbreIlg7KJLtWKSbEDKHjZl4Y6UqnNMkIf4y/mSliqvqaqOlN91MabaY
K2Vv3eTERomPeNpjKCXspD91dy8t9RtZbjMv8Pf6ud8O6+cFjhj+v1i0Zys5ZNOo
7Ex5ODUGDUimcI4rhnzxe1iMDnFJJyWSTZqRBqcEwK3CryCXtDJ7kAJR1O7+xjlS
+VMM9gcNXjuyG6/QhU6hvi2PobclbPgYZmsCR4dIqCg3iEYEExECAAYFAl+3hvEA
CgkQOzARt2udZSORWACeIkxGLmrwy4JWpI7rVL6VpxKobM0An2nmhi+3hWJ0z+ab
Zfx4pJj1WTgm
=j4BC
-----END PGP PUBLIC KEY BLOCK-----
$ sudo apt-key add _pubkey
Warning: apt-key is deprecated. Manage keyring files in trusted.gpg.d instead (see apt-key(8)).
OK
```

Finally, you can increase the pinning value to prefer packages from this
repository over the ones from the official GNU/Debian repositories.

```
$ cat /etc/apt/preferences.d/99buster-erpel
Package: *
Pin: origin download.opensuse.org
Pin-Priority: 800
```

## APT "sources.list" library

This package also includes::

	/usr/share/opensuse-den-erpel-archive-keyring/sources.list.d/

which has one file for any APT line available in this
repository, using this::

	CODENAME_ARCHIVE_REPOSITORY_SUITE[_src].list

naming scheme.

This means you can easily select any available APT source via
symlinks in "/etc/apt/sources.list.d/".

.. note::

	 These sources will only work out of the box if you
	 have network access to archive "download.opensuse.org".

	 I.e., you will still need to fiddle your own in case you are
	 using a mirror.

