/* config-service.c generated by valac 0.48.17, the Vala compiler
 * generated from config-service.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gstdio.h>

#define SYNAPSE_TYPE_CONFIG_OBJECT (synapse_config_object_get_type ())
#define SYNAPSE_CONFIG_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_CONFIG_OBJECT, SynapseConfigObject))
#define SYNAPSE_CONFIG_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_CONFIG_OBJECT, SynapseConfigObjectClass))
#define SYNAPSE_IS_CONFIG_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_CONFIG_OBJECT))
#define SYNAPSE_IS_CONFIG_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_CONFIG_OBJECT))
#define SYNAPSE_CONFIG_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_CONFIG_OBJECT, SynapseConfigObjectClass))

typedef struct _SynapseConfigObject SynapseConfigObject;
typedef struct _SynapseConfigObjectClass SynapseConfigObjectClass;
typedef struct _SynapseConfigObjectPrivate SynapseConfigObjectPrivate;
enum  {
	SYNAPSE_CONFIG_OBJECT_0_PROPERTY,
	SYNAPSE_CONFIG_OBJECT_NUM_PROPERTIES
};
static GParamSpec* synapse_config_object_properties[SYNAPSE_CONFIG_OBJECT_NUM_PROPERTIES];

#define SYNAPSE_TYPE_CONFIG_SERVICE (synapse_config_service_get_type ())
#define SYNAPSE_CONFIG_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_CONFIG_SERVICE, SynapseConfigService))
#define SYNAPSE_CONFIG_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_CONFIG_SERVICE, SynapseConfigServiceClass))
#define SYNAPSE_IS_CONFIG_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_CONFIG_SERVICE))
#define SYNAPSE_IS_CONFIG_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_CONFIG_SERVICE))
#define SYNAPSE_CONFIG_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_CONFIG_SERVICE, SynapseConfigServiceClass))

typedef struct _SynapseConfigService SynapseConfigService;
typedef struct _SynapseConfigServiceClass SynapseConfigServiceClass;
typedef struct _SynapseConfigServicePrivate SynapseConfigServicePrivate;
enum  {
	SYNAPSE_CONFIG_SERVICE_0_PROPERTY,
	SYNAPSE_CONFIG_SERVICE_NUM_PROPERTIES
};
static GParamSpec* synapse_config_service_properties[SYNAPSE_CONFIG_SERVICE_NUM_PROPERTIES];
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SynapseConfigObject {
	GObject parent_instance;
	SynapseConfigObjectPrivate * priv;
};

struct _SynapseConfigObjectClass {
	GObjectClass parent_class;
};

struct _SynapseConfigService {
	GObject parent_instance;
	SynapseConfigServicePrivate * priv;
};

struct _SynapseConfigServiceClass {
	GObjectClass parent_class;
};

struct _SynapseConfigServicePrivate {
	JsonNode* root_node;
	gchar* config_file_name;
	guint save_timer_id;
};

struct _Block1Data {
	int _ref_count_;
	SynapseConfigService* self;
	SynapseConfigObject* co;
	gchar* group;
	gchar* key;
};

static gpointer synapse_config_object_parent_class = NULL;
static gint SynapseConfigService_private_offset;
static gpointer synapse_config_service_parent_class = NULL;
static SynapseConfigService* synapse_config_service_instance;
static SynapseConfigService* synapse_config_service_instance = NULL;

GType synapse_config_object_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseConfigObject, g_object_unref)
SynapseConfigObject* synapse_config_object_construct (GType object_type);
static GType synapse_config_object_get_type_once (void);
GType synapse_config_service_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseConfigService, g_object_unref)
void synapse_config_service_save (SynapseConfigService* self);
static void _vala_JsonNode_free (JsonNode* self);
SynapseConfigService* synapse_config_service_get_default (void);
static SynapseConfigService* synapse_config_service_new (void);
static SynapseConfigService* synapse_config_service_construct (GType object_type);
SynapseConfigObject* synapse_config_service_get_config (SynapseConfigService* self,
                                                        const gchar* group,
                                                        const gchar* key,
                                                        GType config_type);
SynapseConfigObject* synapse_config_service_bind_config (SynapseConfigService* self,
                                                         const gchar* group,
                                                         const gchar* key,
                                                         GType config_type);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda9_ (Block1Data* _data1_);
void synapse_config_service_set_config (SynapseConfigService* self,
                                        const gchar* group,
                                        const gchar* key,
                                        SynapseConfigObject* cfg_obj);
static void ___lambda9__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static gboolean synapse_config_service_save_timeout (SynapseConfigService* self);
static gboolean _synapse_config_service_save_timeout_gsource_func (gpointer self);
static GObject * synapse_config_service_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void synapse_config_service_finalize (GObject * obj);
static GType synapse_config_service_get_type_once (void);

SynapseConfigObject*
synapse_config_object_construct (GType object_type)
{
	SynapseConfigObject * self = NULL;
#line 23 "../../../src/core/config-service.vala"
	self = (SynapseConfigObject*) g_object_new (object_type, NULL);
#line 23 "../../../src/core/config-service.vala"
	return self;
#line 152 "config-service.c"
}

static void
synapse_config_object_class_init (SynapseConfigObjectClass * klass,
                                  gpointer klass_data)
{
#line 23 "../../../src/core/config-service.vala"
	synapse_config_object_parent_class = g_type_class_peek_parent (klass);
#line 161 "config-service.c"
}

static void
synapse_config_object_instance_init (SynapseConfigObject * self,
                                     gpointer klass)
{
}

static GType
synapse_config_object_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseConfigObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_config_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseConfigObject), 0, (GInstanceInitFunc) synapse_config_object_instance_init, NULL };
	GType synapse_config_object_type_id;
	synapse_config_object_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseConfigObject", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return synapse_config_object_type_id;
}

GType
synapse_config_object_get_type (void)
{
	static volatile gsize synapse_config_object_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_config_object_type_id__volatile)) {
		GType synapse_config_object_type_id;
		synapse_config_object_type_id = synapse_config_object_get_type_once ();
		g_once_init_leave (&synapse_config_object_type_id__volatile, synapse_config_object_type_id);
	}
	return synapse_config_object_type_id__volatile;
}

static inline gpointer
synapse_config_service_get_instance_private (SynapseConfigService* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseConfigService_private_offset);
}

static void
_vala_JsonNode_free (JsonNode* self)
{
#line 47 "../../../src/core/config-service.vala"
	g_boxed_free (json_node_get_type (), self);
#line 202 "config-service.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 33 "../../../src/core/config-service.vala"
	return self ? g_object_ref (self) : NULL;
#line 210 "config-service.c"
}

SynapseConfigService*
synapse_config_service_get_default (void)
{
	SynapseConfigService* _tmp0_ = NULL;
	SynapseConfigService* _tmp1_;
	SynapseConfigService* _tmp2_;
	SynapseConfigService* _tmp4_;
	SynapseConfigService* result = NULL;
#line 33 "../../../src/core/config-service.vala"
	_tmp1_ = synapse_config_service_instance;
#line 33 "../../../src/core/config-service.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 33 "../../../src/core/config-service.vala"
	_tmp0_ = _tmp2_;
#line 33 "../../../src/core/config-service.vala"
	if (_tmp0_ == NULL) {
#line 229 "config-service.c"
		SynapseConfigService* _tmp3_;
#line 33 "../../../src/core/config-service.vala"
		_tmp3_ = synapse_config_service_new ();
#line 33 "../../../src/core/config-service.vala"
		_g_object_unref0 (_tmp0_);
#line 33 "../../../src/core/config-service.vala"
		_tmp0_ = _tmp3_;
#line 237 "config-service.c"
	}
#line 33 "../../../src/core/config-service.vala"
	_tmp4_ = _tmp0_;
#line 33 "../../../src/core/config-service.vala"
	_tmp0_ = NULL;
#line 33 "../../../src/core/config-service.vala"
	result = _tmp4_;
#line 33 "../../../src/core/config-service.vala"
	_g_object_unref0 (_tmp0_);
#line 33 "../../../src/core/config-service.vala"
	return result;
#line 249 "config-service.c"
}

static SynapseConfigService*
synapse_config_service_construct (GType object_type)
{
	SynapseConfigService * self = NULL;
#line 36 "../../../src/core/config-service.vala"
	self = (SynapseConfigService*) g_object_new (object_type, NULL);
#line 36 "../../../src/core/config-service.vala"
	return self;
#line 260 "config-service.c"
}

static SynapseConfigService*
synapse_config_service_new (void)
{
#line 36 "../../../src/core/config-service.vala"
	return synapse_config_service_construct (SYNAPSE_TYPE_CONFIG_SERVICE);
#line 268 "config-service.c"
}

/**
     * Creates an instance of an object derived from ConfigObject class, which
     * will have its public properties set to values stored in config file, or
     * to the default values if this object wasn't yet stored.
     *
     * @param group A group name.
     * @param key A key name.
     * @param config_type Type of the object (must be subclass of ConfigObject)
     * @return An instance of config_type.
     */
SynapseConfigObject*
synapse_config_service_get_config (SynapseConfigService* self,
                                   const gchar* group,
                                   const gchar* key,
                                   GType config_type)
{
	JsonObject* obj = NULL;
	JsonNode* _tmp0_;
	JsonObject* _tmp1_;
	JsonNode* group_node = NULL;
	JsonObject* _tmp2_;
	JsonNode* _tmp3_;
	JsonNode* _tmp4_;
	GObject* _tmp17_;
	GObject* _tmp18_;
	SynapseConfigObject* _tmp19_;
	SynapseConfigObject* result = NULL;
#line 86 "../../../src/core/config-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 86 "../../../src/core/config-service.vala"
	g_return_val_if_fail (group != NULL, NULL);
#line 86 "../../../src/core/config-service.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 88 "../../../src/core/config-service.vala"
	_tmp0_ = self->priv->root_node;
#line 88 "../../../src/core/config-service.vala"
	_tmp1_ = json_node_get_object (_tmp0_);
#line 88 "../../../src/core/config-service.vala"
	obj = _tmp1_;
#line 89 "../../../src/core/config-service.vala"
	_tmp2_ = obj;
#line 89 "../../../src/core/config-service.vala"
	_tmp3_ = json_object_get_member (_tmp2_, group);
#line 89 "../../../src/core/config-service.vala"
	group_node = _tmp3_;
#line 90 "../../../src/core/config-service.vala"
	_tmp4_ = group_node;
#line 90 "../../../src/core/config-service.vala"
	if (_tmp4_ != NULL) {
#line 320 "config-service.c"
		JsonNode* _tmp5_;
#line 92 "../../../src/core/config-service.vala"
		_tmp5_ = group_node;
#line 92 "../../../src/core/config-service.vala"
		if (json_node_get_node_type (_tmp5_) == JSON_NODE_OBJECT) {
#line 326 "config-service.c"
			JsonObject* group_obj = NULL;
			JsonNode* _tmp6_;
			JsonObject* _tmp7_;
			JsonNode* key_node = NULL;
			JsonObject* _tmp8_;
			JsonNode* _tmp9_;
			gboolean _tmp10_ = FALSE;
			JsonNode* _tmp11_;
#line 94 "../../../src/core/config-service.vala"
			_tmp6_ = group_node;
#line 94 "../../../src/core/config-service.vala"
			_tmp7_ = json_node_get_object (_tmp6_);
#line 94 "../../../src/core/config-service.vala"
			group_obj = _tmp7_;
#line 95 "../../../src/core/config-service.vala"
			_tmp8_ = group_obj;
#line 95 "../../../src/core/config-service.vala"
			_tmp9_ = json_object_get_member (_tmp8_, key);
#line 95 "../../../src/core/config-service.vala"
			key_node = _tmp9_;
#line 96 "../../../src/core/config-service.vala"
			_tmp11_ = key_node;
#line 96 "../../../src/core/config-service.vala"
			if (_tmp11_ != NULL) {
#line 351 "config-service.c"
				JsonNode* _tmp12_;
#line 96 "../../../src/core/config-service.vala"
				_tmp12_ = key_node;
#line 96 "../../../src/core/config-service.vala"
				_tmp10_ = json_node_get_node_type (_tmp12_) == JSON_NODE_OBJECT;
#line 357 "config-service.c"
			} else {
#line 96 "../../../src/core/config-service.vala"
				_tmp10_ = FALSE;
#line 361 "config-service.c"
			}
#line 96 "../../../src/core/config-service.vala"
			if (_tmp10_) {
#line 365 "config-service.c"
				GObject* _result_ = NULL;
				JsonNode* _tmp13_;
				GObject* _tmp14_;
				GObject* _tmp15_;
				SynapseConfigObject* _tmp16_;
#line 98 "../../../src/core/config-service.vala"
				_tmp13_ = key_node;
#line 98 "../../../src/core/config-service.vala"
				_tmp14_ = json_gobject_deserialize (config_type, _tmp13_);
#line 98 "../../../src/core/config-service.vala"
				_result_ = _tmp14_;
#line 99 "../../../src/core/config-service.vala"
				_tmp15_ = _result_;
#line 99 "../../../src/core/config-service.vala"
				_tmp16_ = _g_object_ref0 (SYNAPSE_IS_CONFIG_OBJECT (_tmp15_) ? ((SynapseConfigObject*) _tmp15_) : NULL);
#line 99 "../../../src/core/config-service.vala"
				result = _tmp16_;
#line 99 "../../../src/core/config-service.vala"
				_g_object_unref0 (_result_);
#line 99 "../../../src/core/config-service.vala"
				return result;
#line 387 "config-service.c"
			}
		}
	}
#line 104 "../../../src/core/config-service.vala"
	_tmp17_ = g_object_new (config_type, NULL);
#line 104 "../../../src/core/config-service.vala"
	_tmp18_ = G_IS_INITIALLY_UNOWNED (_tmp17_) ? g_object_ref_sink (_tmp17_) : _tmp17_;
#line 104 "../../../src/core/config-service.vala"
	_tmp19_ = SYNAPSE_IS_CONFIG_OBJECT (_tmp18_) ? ((SynapseConfigObject*) _tmp18_) : NULL;
#line 104 "../../../src/core/config-service.vala"
	if (_tmp19_ == NULL) {
#line 104 "../../../src/core/config-service.vala"
		_g_object_unref0 (_tmp18_);
#line 401 "config-service.c"
	}
#line 104 "../../../src/core/config-service.vala"
	result = _tmp19_;
#line 104 "../../../src/core/config-service.vala"
	return result;
#line 407 "config-service.c"
}

/**
     * Behaves in a similar way to get_config, but it also watches for changes
     * in the returned config object and saves them back to the config file
     * (without the need of calling set_config).
     *
     * @param group A group name.
     * @param key A key name.
     * @param config_type Type of the object (must be subclass of ConfigObject)
     */
static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
#line 116 "../../../src/core/config-service.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 116 "../../../src/core/config-service.vala"
	return _data1_;
#line 426 "config-service.c"
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 116 "../../../src/core/config-service.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 436 "config-service.c"
		SynapseConfigService* self;
#line 116 "../../../src/core/config-service.vala"
		self = _data1_->self;
#line 116 "../../../src/core/config-service.vala"
		_g_free0 (_data1_->group);
#line 116 "../../../src/core/config-service.vala"
		_g_free0 (_data1_->key);
#line 116 "../../../src/core/config-service.vala"
		_g_object_unref0 (self);
#line 116 "../../../src/core/config-service.vala"
		g_slice_free (Block1Data, _data1_);
#line 448 "config-service.c"
	}
}

static void
__lambda9_ (Block1Data* _data1_)
{
	SynapseConfigService* self;
#line 121 "../../../src/core/config-service.vala"
	self = _data1_->self;
#line 122 "../../../src/core/config-service.vala"
	synapse_config_service_set_config (self, _data1_->group, _data1_->key, _data1_->co);
#line 460 "config-service.c"
}

static void
___lambda9__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
#line 121 "../../../src/core/config-service.vala"
	__lambda9_ (self);
#line 470 "config-service.c"
}

SynapseConfigObject*
synapse_config_service_bind_config (SynapseConfigService* self,
                                    const gchar* group,
                                    const gchar* key,
                                    GType config_type)
{
	Block1Data* _data1_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	SynapseConfigObject* config_object = NULL;
	SynapseConfigObject* _tmp2_;
	SynapseConfigObject* result = NULL;
#line 116 "../../../src/core/config-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 116 "../../../src/core/config-service.vala"
	g_return_val_if_fail (group != NULL, NULL);
#line 116 "../../../src/core/config-service.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 116 "../../../src/core/config-service.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 116 "../../../src/core/config-service.vala"
	_data1_->_ref_count_ = 1;
#line 116 "../../../src/core/config-service.vala"
	_data1_->self = g_object_ref (self);
#line 116 "../../../src/core/config-service.vala"
	_tmp0_ = g_strdup (group);
#line 116 "../../../src/core/config-service.vala"
	_g_free0 (_data1_->group);
#line 116 "../../../src/core/config-service.vala"
	_data1_->group = _tmp0_;
#line 116 "../../../src/core/config-service.vala"
	_tmp1_ = g_strdup (key);
#line 116 "../../../src/core/config-service.vala"
	_g_free0 (_data1_->key);
#line 116 "../../../src/core/config-service.vala"
	_data1_->key = _tmp1_;
#line 118 "../../../src/core/config-service.vala"
	_tmp2_ = synapse_config_service_get_config (self, _data1_->group, _data1_->key, config_type);
#line 118 "../../../src/core/config-service.vala"
	config_object = _tmp2_;
#line 120 "../../../src/core/config-service.vala"
	_data1_->co = config_object;
#line 121 "../../../src/core/config-service.vala"
	g_signal_connect_data ((GObject*) _data1_->co, "notify", (GCallback) ___lambda9__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 124 "../../../src/core/config-service.vala"
	result = config_object;
#line 124 "../../../src/core/config-service.vala"
	block1_data_unref (_data1_);
#line 124 "../../../src/core/config-service.vala"
	_data1_ = NULL;
#line 124 "../../../src/core/config-service.vala"
	return result;
#line 525 "config-service.c"
}

/**
     * Stores all public properties of the object to the config file under
     * specified group and key names.
     *
     * @param group A group name.
     * @param key A key name.
     * @param cfg_obj ConfigObject instance.
     */
static gpointer
_json_object_ref0 (gpointer self)
{
#line 150 "../../../src/core/config-service.vala"
	return self ? json_object_ref (self) : NULL;
#line 541 "config-service.c"
}

static gboolean
_synapse_config_service_save_timeout_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_config_service_save_timeout ((SynapseConfigService*) self);
#line 154 "../../../src/core/config-service.vala"
	return result;
#line 551 "config-service.c"
}

void
synapse_config_service_set_config (SynapseConfigService* self,
                                   const gchar* group,
                                   const gchar* key,
                                   SynapseConfigObject* cfg_obj)
{
	JsonObject* obj = NULL;
	JsonNode* _tmp0_;
	JsonObject* _tmp1_;
	gboolean _tmp2_ = FALSE;
	JsonObject* _tmp3_;
	JsonObject* group_obj = NULL;
	JsonObject* _tmp8_;
	JsonObject* _tmp9_;
	JsonObject* _tmp10_;
	JsonNode* node = NULL;
	JsonNode* _tmp12_;
	JsonObject* _tmp13_;
	JsonNode* _tmp14_;
	JsonObject* _tmp15_;
	JsonObject* _tmp16_;
#line 135 "../../../src/core/config-service.vala"
	g_return_if_fail (self != NULL);
#line 135 "../../../src/core/config-service.vala"
	g_return_if_fail (group != NULL);
#line 135 "../../../src/core/config-service.vala"
	g_return_if_fail (key != NULL);
#line 135 "../../../src/core/config-service.vala"
	g_return_if_fail (cfg_obj != NULL);
#line 137 "../../../src/core/config-service.vala"
	_tmp0_ = self->priv->root_node;
#line 137 "../../../src/core/config-service.vala"
	_tmp1_ = json_node_get_object (_tmp0_);
#line 137 "../../../src/core/config-service.vala"
	obj = _tmp1_;
#line 138 "../../../src/core/config-service.vala"
	_tmp3_ = obj;
#line 138 "../../../src/core/config-service.vala"
	if (!json_object_has_member (_tmp3_, group)) {
#line 138 "../../../src/core/config-service.vala"
		_tmp2_ = TRUE;
#line 595 "config-service.c"
	} else {
		JsonObject* _tmp4_;
		JsonNode* _tmp5_;
#line 139 "../../../src/core/config-service.vala"
		_tmp4_ = obj;
#line 139 "../../../src/core/config-service.vala"
		_tmp5_ = json_object_get_member (_tmp4_, group);
#line 139 "../../../src/core/config-service.vala"
		_tmp2_ = json_node_get_node_type (_tmp5_) != JSON_NODE_OBJECT;
#line 605 "config-service.c"
	}
#line 138 "../../../src/core/config-service.vala"
	if (_tmp2_) {
#line 609 "config-service.c"
		JsonObject* _tmp6_;
		JsonObject* _tmp7_;
#line 142 "../../../src/core/config-service.vala"
		_tmp6_ = obj;
#line 142 "../../../src/core/config-service.vala"
		_tmp7_ = json_object_new ();
#line 142 "../../../src/core/config-service.vala"
		json_object_set_object_member (_tmp6_, group, _tmp7_);
#line 618 "config-service.c"
	}
#line 145 "../../../src/core/config-service.vala"
	_tmp8_ = obj;
#line 145 "../../../src/core/config-service.vala"
	_tmp9_ = json_object_get_object_member (_tmp8_, group);
#line 145 "../../../src/core/config-service.vala"
	group_obj = _tmp9_;
#line 147 "../../../src/core/config-service.vala"
	_tmp10_ = group_obj;
#line 147 "../../../src/core/config-service.vala"
	if (json_object_has_member (_tmp10_, key)) {
#line 630 "config-service.c"
		JsonObject* _tmp11_;
#line 147 "../../../src/core/config-service.vala"
		_tmp11_ = group_obj;
#line 147 "../../../src/core/config-service.vala"
		json_object_remove_member (_tmp11_, key);
#line 636 "config-service.c"
	}
#line 149 "../../../src/core/config-service.vala"
	_tmp12_ = json_gobject_serialize ((GObject*) cfg_obj);
#line 149 "../../../src/core/config-service.vala"
	node = _tmp12_;
#line 150 "../../../src/core/config-service.vala"
	_tmp13_ = group_obj;
#line 150 "../../../src/core/config-service.vala"
	_tmp14_ = node;
#line 150 "../../../src/core/config-service.vala"
	_tmp15_ = json_node_get_object (_tmp14_);
#line 150 "../../../src/core/config-service.vala"
	_tmp16_ = _json_object_ref0 (_tmp15_);
#line 150 "../../../src/core/config-service.vala"
	json_object_set_object_member (_tmp13_, key, _tmp16_);
#line 152 "../../../src/core/config-service.vala"
	if (self->priv->save_timer_id != ((guint) 0)) {
#line 152 "../../../src/core/config-service.vala"
		g_source_remove (self->priv->save_timer_id);
#line 656 "config-service.c"
	}
#line 154 "../../../src/core/config-service.vala"
	self->priv->save_timer_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 30000, _synapse_config_service_save_timeout_gsource_func, g_object_ref (self), g_object_unref);
#line 135 "../../../src/core/config-service.vala"
	__vala_JsonNode_free0 (node);
#line 662 "config-service.c"
}

static gboolean
synapse_config_service_save_timeout (SynapseConfigService* self)
{
	gboolean result = FALSE;
#line 157 "../../../src/core/config-service.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 159 "../../../src/core/config-service.vala"
	self->priv->save_timer_id = (guint) 0;
#line 160 "../../../src/core/config-service.vala"
	synapse_config_service_save (self);
#line 162 "../../../src/core/config-service.vala"
	result = FALSE;
#line 162 "../../../src/core/config-service.vala"
	return result;
#line 679 "config-service.c"
}

/**
     * Forces immediate saving of the configuration file to the filesystem.
     */
void
synapse_config_service_save (SynapseConfigService* self)
{
	JsonGenerator* generator = NULL;
	JsonGenerator* _tmp0_;
	JsonNode* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
#line 168 "../../../src/core/config-service.vala"
	g_return_if_fail (self != NULL);
#line 170 "../../../src/core/config-service.vala"
	if (self->priv->save_timer_id != ((guint) 0)) {
#line 172 "../../../src/core/config-service.vala"
		g_source_remove (self->priv->save_timer_id);
#line 173 "../../../src/core/config-service.vala"
		self->priv->save_timer_id = (guint) 0;
#line 703 "config-service.c"
	}
#line 176 "../../../src/core/config-service.vala"
	_tmp0_ = json_generator_new ();
#line 176 "../../../src/core/config-service.vala"
	generator = _tmp0_;
#line 177 "../../../src/core/config-service.vala"
	json_generator_set_pretty (generator, TRUE);
#line 178 "../../../src/core/config-service.vala"
	_tmp1_ = self->priv->root_node;
#line 178 "../../../src/core/config-service.vala"
	json_generator_set_root (generator, _tmp1_);
#line 180 "../../../src/core/config-service.vala"
	_tmp2_ = self->priv->config_file_name;
#line 180 "../../../src/core/config-service.vala"
	_tmp3_ = g_path_get_dirname (_tmp2_);
#line 180 "../../../src/core/config-service.vala"
	_tmp4_ = _tmp3_;
#line 180 "../../../src/core/config-service.vala"
	g_mkdir_with_parents (_tmp4_, 0755);
#line 180 "../../../src/core/config-service.vala"
	_g_free0 (_tmp4_);
#line 725 "config-service.c"
	{
		const gchar* _tmp5_;
#line 183 "../../../src/core/config-service.vala"
		_tmp5_ = self->priv->config_file_name;
#line 183 "../../../src/core/config-service.vala"
		json_generator_to_file (generator, _tmp5_, &_inner_error0_);
#line 183 "../../../src/core/config-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 734 "config-service.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 181 "../../../src/core/config-service.vala"
		err = _inner_error0_;
#line 181 "../../../src/core/config-service.vala"
		_inner_error0_ = NULL;
#line 187 "../../../src/core/config-service.vala"
		_tmp6_ = err;
#line 187 "../../../src/core/config-service.vala"
		_tmp7_ = _tmp6_->message;
#line 187 "../../../src/core/config-service.vala"
		g_warning ("config-service.vala:187: %s", _tmp7_);
#line 181 "../../../src/core/config-service.vala"
		_g_error_free0 (err);
#line 756 "config-service.c"
	}
	__finally0:
#line 181 "../../../src/core/config-service.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 181 "../../../src/core/config-service.vala"
		_g_object_unref0 (generator);
#line 181 "../../../src/core/config-service.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 181 "../../../src/core/config-service.vala"
		g_clear_error (&_inner_error0_);
#line 181 "../../../src/core/config-service.vala"
		return;
#line 769 "config-service.c"
	}
#line 168 "../../../src/core/config-service.vala"
	_g_object_unref0 (generator);
#line 773 "config-service.c"
}

static GObject *
synapse_config_service_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseConfigService * self;
	JsonParser* parser = NULL;
	JsonParser* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
#line 51 "../../../src/core/config-service.vala"
	parent_class = G_OBJECT_CLASS (synapse_config_service_parent_class);
#line 51 "../../../src/core/config-service.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 51 "../../../src/core/config-service.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_CONFIG_SERVICE, SynapseConfigService);
#line 53 "../../../src/core/config-service.vala"
	synapse_config_service_instance = self;
#line 55 "../../../src/core/config-service.vala"
	_tmp0_ = json_parser_new ();
#line 55 "../../../src/core/config-service.vala"
	parser = _tmp0_;
#line 56 "../../../src/core/config-service.vala"
	_tmp1_ = g_get_user_config_dir ();
#line 56 "../../../src/core/config-service.vala"
	_tmp2_ = g_build_filename (_tmp1_, "synapse", "config.json", NULL);
#line 56 "../../../src/core/config-service.vala"
	_g_free0 (self->priv->config_file_name);
#line 56 "../../../src/core/config-service.vala"
	self->priv->config_file_name = _tmp2_;
#line 809 "config-service.c"
	{
		JsonParser* _tmp3_;
		const gchar* _tmp4_;
		JsonParser* _tmp5_;
		JsonNode* _tmp6_;
		JsonNode* _tmp7_;
		JsonNode* _tmp8_;
#line 61 "../../../src/core/config-service.vala"
		_tmp3_ = parser;
#line 61 "../../../src/core/config-service.vala"
		_tmp4_ = self->priv->config_file_name;
#line 61 "../../../src/core/config-service.vala"
		json_parser_load_from_file (_tmp3_, _tmp4_, &_inner_error0_);
#line 61 "../../../src/core/config-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 825 "config-service.c"
			goto __catch0_g_error;
		}
#line 62 "../../../src/core/config-service.vala"
		_tmp5_ = parser;
#line 62 "../../../src/core/config-service.vala"
		_tmp6_ = json_parser_get_root (_tmp5_);
#line 62 "../../../src/core/config-service.vala"
		_tmp7_ = json_node_copy (_tmp6_);
#line 62 "../../../src/core/config-service.vala"
		__vala_JsonNode_free0 (self->priv->root_node);
#line 62 "../../../src/core/config-service.vala"
		self->priv->root_node = _tmp7_;
#line 63 "../../../src/core/config-service.vala"
		_tmp8_ = self->priv->root_node;
#line 63 "../../../src/core/config-service.vala"
		if (json_node_get_node_type (_tmp8_) != JSON_NODE_OBJECT) {
#line 842 "config-service.c"
			JsonNode* _tmp9_;
			JsonNode* _tmp10_;
			JsonObject* _tmp11_;
#line 65 "../../../src/core/config-service.vala"
			_tmp9_ = json_node_new (JSON_NODE_OBJECT);
#line 65 "../../../src/core/config-service.vala"
			__vala_JsonNode_free0 (self->priv->root_node);
#line 65 "../../../src/core/config-service.vala"
			self->priv->root_node = _tmp9_;
#line 66 "../../../src/core/config-service.vala"
			_tmp10_ = self->priv->root_node;
#line 66 "../../../src/core/config-service.vala"
			_tmp11_ = json_object_new ();
#line 66 "../../../src/core/config-service.vala"
			json_node_take_object (_tmp10_, _tmp11_);
#line 858 "config-service.c"
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		JsonNode* _tmp12_;
		JsonNode* _tmp13_;
		JsonObject* _tmp14_;
#line 59 "../../../src/core/config-service.vala"
		g_clear_error (&_inner_error0_);
#line 71 "../../../src/core/config-service.vala"
		_tmp12_ = json_node_new (JSON_NODE_OBJECT);
#line 71 "../../../src/core/config-service.vala"
		__vala_JsonNode_free0 (self->priv->root_node);
#line 71 "../../../src/core/config-service.vala"
		self->priv->root_node = _tmp12_;
#line 72 "../../../src/core/config-service.vala"
		_tmp13_ = self->priv->root_node;
#line 72 "../../../src/core/config-service.vala"
		_tmp14_ = json_object_new ();
#line 72 "../../../src/core/config-service.vala"
		json_node_take_object (_tmp13_, _tmp14_);
#line 881 "config-service.c"
	}
	__finally0:
#line 59 "../../../src/core/config-service.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 59 "../../../src/core/config-service.vala"
		_g_object_unref0 (parser);
#line 59 "../../../src/core/config-service.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 59 "../../../src/core/config-service.vala"
		g_clear_error (&_inner_error0_);
#line 892 "config-service.c"
	}
#line 51 "../../../src/core/config-service.vala"
	_g_object_unref0 (parser);
#line 51 "../../../src/core/config-service.vala"
	return obj;
#line 898 "config-service.c"
}

static void
synapse_config_service_class_init (SynapseConfigServiceClass * klass,
                                   gpointer klass_data)
{
#line 27 "../../../src/core/config-service.vala"
	synapse_config_service_parent_class = g_type_class_peek_parent (klass);
#line 27 "../../../src/core/config-service.vala"
	g_type_class_adjust_private_offset (klass, &SynapseConfigService_private_offset);
#line 27 "../../../src/core/config-service.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_config_service_constructor;
#line 27 "../../../src/core/config-service.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_config_service_finalize;
#line 913 "config-service.c"
}

static void
synapse_config_service_instance_init (SynapseConfigService * self,
                                      gpointer klass)
{
#line 27 "../../../src/core/config-service.vala"
	self->priv = synapse_config_service_get_instance_private (self);
#line 49 "../../../src/core/config-service.vala"
	self->priv->save_timer_id = (guint) 0;
#line 924 "config-service.c"
}

static void
synapse_config_service_finalize (GObject * obj)
{
	SynapseConfigService * self;
#line 27 "../../../src/core/config-service.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_CONFIG_SERVICE, SynapseConfigService);
#line 43 "../../../src/core/config-service.vala"
	if (self->priv->save_timer_id != ((guint) 0)) {
#line 43 "../../../src/core/config-service.vala"
		synapse_config_service_save (self);
#line 937 "config-service.c"
	}
#line 44 "../../../src/core/config-service.vala"
	synapse_config_service_instance = NULL;
#line 47 "../../../src/core/config-service.vala"
	__vala_JsonNode_free0 (self->priv->root_node);
#line 48 "../../../src/core/config-service.vala"
	_g_free0 (self->priv->config_file_name);
#line 86 "../../../src/core/config-service.vala"
	G_OBJECT_CLASS (synapse_config_service_parent_class)->finalize (obj);
#line 947 "config-service.c"
}

static GType
synapse_config_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseConfigServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_config_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseConfigService), 0, (GInstanceInitFunc) synapse_config_service_instance_init, NULL };
	GType synapse_config_service_type_id;
	synapse_config_service_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseConfigService", &g_define_type_info, 0);
	SynapseConfigService_private_offset = g_type_add_instance_private (synapse_config_service_type_id, sizeof (SynapseConfigServicePrivate));
	return synapse_config_service_type_id;
}

GType
synapse_config_service_get_type (void)
{
	static volatile gsize synapse_config_service_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_config_service_type_id__volatile)) {
		GType synapse_config_service_type_id;
		synapse_config_service_type_id = synapse_config_service_get_type_once ();
		g_once_init_leave (&synapse_config_service_type_id__volatile, synapse_config_service_type_id);
	}
	return synapse_config_service_type_id__volatile;
}

