/* plugin.c generated by valac 0.48.17, the Vala compiler
 * generated from plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>
#include <gee.h>

#define SYNAPSE_TYPE_ACTIVATABLE (synapse_activatable_get_type ())
#define SYNAPSE_ACTIVATABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatable))
#define SYNAPSE_IS_ACTIVATABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTIVATABLE))
#define SYNAPSE_ACTIVATABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatableIface))

typedef struct _SynapseActivatable SynapseActivatable;
typedef struct _SynapseActivatableIface SynapseActivatableIface;

#define SYNAPSE_TYPE_CONFIGURABLE (synapse_configurable_get_type ())
#define SYNAPSE_CONFIGURABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_CONFIGURABLE, SynapseConfigurable))
#define SYNAPSE_IS_CONFIGURABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_CONFIGURABLE))
#define SYNAPSE_CONFIGURABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_CONFIGURABLE, SynapseConfigurableIface))

typedef struct _SynapseConfigurable SynapseConfigurable;
typedef struct _SynapseConfigurableIface SynapseConfigurableIface;

#define SYNAPSE_TYPE_ITEM_PROVIDER (synapse_item_provider_get_type ())
#define SYNAPSE_ITEM_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ITEM_PROVIDER, SynapseItemProvider))
#define SYNAPSE_IS_ITEM_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ITEM_PROVIDER))
#define SYNAPSE_ITEM_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ITEM_PROVIDER, SynapseItemProviderIface))

typedef struct _SynapseItemProvider SynapseItemProvider;
typedef struct _SynapseItemProviderIface SynapseItemProviderIface;

#define SYNAPSE_TYPE_QUERY (synapse_query_get_type ())
typedef struct _SynapseQuery SynapseQuery;
typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;

#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())

#define SYNAPSE_TYPE_RESULT_SET (synapse_result_set_get_type ())
#define SYNAPSE_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSet))
#define SYNAPSE_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))
#define SYNAPSE_IS_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_IS_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_RESULT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))

typedef struct _SynapseResultSet SynapseResultSet;
typedef struct _SynapseResultSetClass SynapseResultSetClass;

#define SYNAPSE_TYPE_ACTION_PROVIDER (synapse_action_provider_get_type ())
#define SYNAPSE_ACTION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTION_PROVIDER, SynapseActionProvider))
#define SYNAPSE_IS_ACTION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTION_PROVIDER))
#define SYNAPSE_ACTION_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ACTION_PROVIDER, SynapseActionProviderIface))

typedef struct _SynapseActionProvider SynapseActionProvider;
typedef struct _SynapseActionProviderIface SynapseActionProviderIface;

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_MATCH, SynapseMatchClass))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_IS_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchClass))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchClass SynapseMatchClass;
typedef void (*SynapsePluginRegisterFunc) (void);

#define SYNAPSE_TYPE_PLUGIN_INFO (synapse_plugin_info_get_type ())
#define SYNAPSE_PLUGIN_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_PLUGIN_INFO, SynapsePluginInfo))
#define SYNAPSE_PLUGIN_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_PLUGIN_INFO, SynapsePluginInfoClass))
#define SYNAPSE_IS_PLUGIN_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_PLUGIN_INFO))
#define SYNAPSE_IS_PLUGIN_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_PLUGIN_INFO))
#define SYNAPSE_PLUGIN_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_PLUGIN_INFO, SynapsePluginInfoClass))

typedef struct _SynapsePluginInfo SynapsePluginInfo;
typedef struct _SynapsePluginInfoClass SynapsePluginInfoClass;
typedef struct _SynapsePluginInfoPrivate SynapsePluginInfoPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SynapseParamSpecPluginInfo SynapseParamSpecPluginInfo;

#define SYNAPSE_TYPE_PLUGIN_REGISTRY (synapse_plugin_registry_get_type ())
#define SYNAPSE_PLUGIN_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_PLUGIN_REGISTRY, SynapsePluginRegistry))
#define SYNAPSE_PLUGIN_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_PLUGIN_REGISTRY, SynapsePluginRegistryClass))
#define SYNAPSE_IS_PLUGIN_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_PLUGIN_REGISTRY))
#define SYNAPSE_IS_PLUGIN_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_PLUGIN_REGISTRY))
#define SYNAPSE_PLUGIN_REGISTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_PLUGIN_REGISTRY, SynapsePluginRegistryClass))

typedef struct _SynapsePluginRegistry SynapsePluginRegistry;
typedef struct _SynapsePluginRegistryClass SynapsePluginRegistryClass;
typedef struct _SynapsePluginRegistryPrivate SynapsePluginRegistryPrivate;
enum  {
	SYNAPSE_PLUGIN_REGISTRY_0_PROPERTY,
	SYNAPSE_PLUGIN_REGISTRY_NUM_PROPERTIES
};
static GParamSpec* synapse_plugin_registry_properties[SYNAPSE_PLUGIN_REGISTRY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _synapse_plugin_info_unref0(var) ((var == NULL) ? NULL : (var = (synapse_plugin_info_unref (var), NULL)))

struct _SynapseActivatableIface {
	GTypeInterface parent_iface;
	void (*activate) (SynapseActivatable* self);
	void (*deactivate) (SynapseActivatable* self);
	gboolean (*get_enabled) (SynapseActivatable* self);
	void (*set_enabled) (SynapseActivatable* self, gboolean value);
};

struct _SynapseConfigurableIface {
	GTypeInterface parent_iface;
	GtkWidget* (*create_config_widget) (SynapseConfigurable* self);
};

struct _SynapseQuery {
	gchar* query_string;
	gchar* query_string_folded;
	GCancellable* cancellable;
	SynapseQueryFlags query_type;
	guint max_results;
	guint query_id;
};

typedef enum  {
	SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED,
	SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR
} SynapseSearchError;
#define SYNAPSE_SEARCH_ERROR synapse_search_error_quark ()
struct _SynapseItemProviderIface {
	GTypeInterface parent_iface;
	void (*search) (SynapseItemProvider* self, SynapseQuery* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	SynapseResultSet* (*search_finish) (SynapseItemProvider* self, GAsyncResult* _res_, GError** error);
	gboolean (*handles_query) (SynapseItemProvider* self, SynapseQuery* query);
	gboolean (*handles_empty_query) (SynapseItemProvider* self);
};

struct _SynapseActionProviderIface {
	GTypeInterface parent_iface;
	SynapseResultSet* (*find_for_match) (SynapseActionProvider* self, SynapseQuery* query, SynapseMatch* match);
	gboolean (*handles_unknown) (SynapseActionProvider* self);
};

struct _SynapsePluginInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapsePluginInfoPrivate * priv;
	GType plugin_type;
	gchar* title;
	gchar* description;
	gchar* icon_name;
	SynapsePluginRegisterFunc register_func;
	gboolean runnable;
	gchar* runnable_error;
};

struct _SynapsePluginInfoClass {
	GTypeClass parent_class;
	void (*finalize) (SynapsePluginInfo *self);
};

struct _SynapseParamSpecPluginInfo {
	GParamSpec parent_instance;
};

struct _SynapsePluginRegistry {
	GObject parent_instance;
	SynapsePluginRegistryPrivate * priv;
};

struct _SynapsePluginRegistryClass {
	GObjectClass parent_class;
};

struct _SynapsePluginRegistryPrivate {
	GeeList* plugins;
};

static gpointer synapse_plugin_info_parent_class = NULL;
static gint SynapsePluginRegistry_private_offset;
static gpointer synapse_plugin_registry_parent_class = NULL;
extern SynapsePluginRegistry* synapse_plugin_registry_instance;
SynapsePluginRegistry* synapse_plugin_registry_instance = NULL;

GType synapse_activatable_get_type (void) G_GNUC_CONST;
void synapse_activatable_activate (SynapseActivatable* self);
void synapse_activatable_deactivate (SynapseActivatable* self);
gboolean synapse_activatable_get_enabled (SynapseActivatable* self);
void synapse_activatable_set_enabled (SynapseActivatable* self,
                                      gboolean value);
static GType synapse_activatable_get_type_once (void);
GType synapse_configurable_get_type (void) G_GNUC_CONST;
GtkWidget* synapse_configurable_create_config_widget (SynapseConfigurable* self);
static GType synapse_configurable_get_type_once (void);
GType synapse_query_get_type (void) G_GNUC_CONST;
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
SynapseQuery* synapse_query_dup (const SynapseQuery* self);
void synapse_query_free (SynapseQuery* self);
void synapse_query_copy (const SynapseQuery* self,
                         SynapseQuery* dest);
void synapse_query_destroy (SynapseQuery* self);
GType synapse_result_set_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseResultSet, g_object_unref)
GQuark synapse_search_error_quark (void);
GType synapse_item_provider_get_type (void) G_GNUC_CONST;
void synapse_item_provider_search (SynapseItemProvider* self,
                                   SynapseQuery* query,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
SynapseResultSet* synapse_item_provider_search_finish (SynapseItemProvider* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
gboolean synapse_item_provider_handles_query (SynapseItemProvider* self,
                                              SynapseQuery* query);
static gboolean synapse_item_provider_real_handles_query (SynapseItemProvider* self,
                                                   SynapseQuery* query);
gboolean synapse_item_provider_handles_empty_query (SynapseItemProvider* self);
static gboolean synapse_item_provider_real_handles_empty_query (SynapseItemProvider* self);
static GType synapse_item_provider_get_type_once (void);
GType synapse_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseMatch, g_object_unref)
GType synapse_action_provider_get_type (void) G_GNUC_CONST;
SynapseResultSet* synapse_action_provider_find_for_match (SynapseActionProvider* self,
                                                          SynapseQuery* query,
                                                          SynapseMatch* match);
gboolean synapse_action_provider_handles_unknown (SynapseActionProvider* self);
static gboolean synapse_action_provider_real_handles_unknown (SynapseActionProvider* self);
static GType synapse_action_provider_get_type_once (void);
gpointer synapse_plugin_info_ref (gpointer instance);
void synapse_plugin_info_unref (gpointer instance);
GParamSpec* synapse_param_spec_plugin_info (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
void synapse_value_set_plugin_info (GValue* value,
                                    gpointer v_object);
void synapse_value_take_plugin_info (GValue* value,
                                     gpointer v_object);
gpointer synapse_value_get_plugin_info (const GValue* value);
GType synapse_plugin_info_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapsePluginInfo, synapse_plugin_info_unref)
SynapsePluginInfo* synapse_plugin_info_new (GType type,
                                            const gchar* title,
                                            const gchar* desc,
                                            const gchar* icon_name,
                                            SynapsePluginRegisterFunc reg_func,
                                            gboolean runnable,
                                            const gchar* runnable_error);
SynapsePluginInfo* synapse_plugin_info_construct (GType object_type,
                                                  GType type,
                                                  const gchar* title,
                                                  const gchar* desc,
                                                  const gchar* icon_name,
                                                  SynapsePluginRegisterFunc reg_func,
                                                  gboolean runnable,
                                                  const gchar* runnable_error);
static void synapse_plugin_info_finalize (SynapsePluginInfo * obj);
static GType synapse_plugin_info_get_type_once (void);
GType synapse_plugin_registry_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapsePluginRegistry, g_object_unref)
SynapsePluginRegistry* synapse_plugin_registry_get_default (void);
SynapsePluginRegistry* synapse_plugin_registry_new (void);
SynapsePluginRegistry* synapse_plugin_registry_construct (GType object_type);
void synapse_plugin_registry_register_plugin (SynapsePluginRegistry* self,
                                              GType plugin_type,
                                              const gchar* title,
                                              const gchar* description,
                                              const gchar* icon_name,
                                              SynapsePluginRegisterFunc reg_func,
                                              gboolean runnable,
                                              const gchar* runnable_error);
GeeList* synapse_plugin_registry_get_plugins (SynapsePluginRegistry* self);
SynapsePluginInfo* synapse_plugin_registry_get_plugin_info_for_type (SynapsePluginRegistry* self,
                                                                     GType plugin_type);
static GObject * synapse_plugin_registry_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void synapse_plugin_registry_finalize (GObject * obj);
static GType synapse_plugin_registry_get_type_once (void);

void
synapse_activatable_activate (SynapseActivatable* self)
{
#line 28 "../../../src/core/plugin.vala"
	g_return_if_fail (self != NULL);
#line 28 "../../../src/core/plugin.vala"
	SYNAPSE_ACTIVATABLE_GET_INTERFACE (self)->activate (self);
#line 326 "plugin.c"
}

void
synapse_activatable_deactivate (SynapseActivatable* self)
{
#line 29 "../../../src/core/plugin.vala"
	g_return_if_fail (self != NULL);
#line 29 "../../../src/core/plugin.vala"
	SYNAPSE_ACTIVATABLE_GET_INTERFACE (self)->deactivate (self);
#line 336 "plugin.c"
}

gboolean
synapse_activatable_get_enabled (SynapseActivatable* self)
{
#line 26 "../../../src/core/plugin.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 26 "../../../src/core/plugin.vala"
	return SYNAPSE_ACTIVATABLE_GET_INTERFACE (self)->get_enabled (self);
#line 346 "plugin.c"
}

void
synapse_activatable_set_enabled (SynapseActivatable* self,
                                 gboolean value)
{
#line 26 "../../../src/core/plugin.vala"
	g_return_if_fail (self != NULL);
#line 26 "../../../src/core/plugin.vala"
	SYNAPSE_ACTIVATABLE_GET_INTERFACE (self)->set_enabled (self, value);
#line 357 "plugin.c"
}

static void
synapse_activatable_default_init (SynapseActivatableIface * iface,
                                  gpointer iface_data)
{
#line 23 "../../../src/core/plugin.vala"
	g_object_interface_install_property (iface, g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 366 "plugin.c"
}

static GType
synapse_activatable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseActivatableIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_activatable_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType synapse_activatable_type_id;
	synapse_activatable_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseActivatable", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (synapse_activatable_type_id, G_TYPE_OBJECT);
	return synapse_activatable_type_id;
}

GType
synapse_activatable_get_type (void)
{
	static volatile gsize synapse_activatable_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_activatable_type_id__volatile)) {
		GType synapse_activatable_type_id;
		synapse_activatable_type_id = synapse_activatable_get_type_once ();
		g_once_init_leave (&synapse_activatable_type_id__volatile, synapse_activatable_type_id);
	}
	return synapse_activatable_type_id__volatile;
}

GtkWidget*
synapse_configurable_create_config_widget (SynapseConfigurable* self)
{
#line 34 "../../../src/core/plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 34 "../../../src/core/plugin.vala"
	return SYNAPSE_CONFIGURABLE_GET_INTERFACE (self)->create_config_widget (self);
#line 398 "plugin.c"
}

static void
synapse_configurable_default_init (SynapseConfigurableIface * iface,
                                   gpointer iface_data)
{
}

static GType
synapse_configurable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseConfigurableIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_configurable_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType synapse_configurable_type_id;
	synapse_configurable_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseConfigurable", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (synapse_configurable_type_id, G_TYPE_OBJECT);
	return synapse_configurable_type_id;
}

GType
synapse_configurable_get_type (void)
{
	static volatile gsize synapse_configurable_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_configurable_type_id__volatile)) {
		GType synapse_configurable_type_id;
		synapse_configurable_type_id = synapse_configurable_get_type_once ();
		g_once_init_leave (&synapse_configurable_type_id__volatile, synapse_configurable_type_id);
	}
	return synapse_configurable_type_id__volatile;
}

void
synapse_item_provider_search (SynapseItemProvider* self,
                              SynapseQuery* query,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
#line 37 "../../../src/core/plugin.vala"
	SYNAPSE_ITEM_PROVIDER_GET_INTERFACE (self)->search (self, query, _callback_, _user_data_);
#line 437 "plugin.c"
}

SynapseResultSet*
synapse_item_provider_search_finish (SynapseItemProvider* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
#line 37 "../../../src/core/plugin.vala"
	return SYNAPSE_ITEM_PROVIDER_GET_INTERFACE (self)->search_finish (self, _res_, error);
#line 447 "plugin.c"
}

static gboolean
synapse_item_provider_real_handles_query (SynapseItemProvider* self,
                                          SynapseQuery* query)
{
	gboolean result = FALSE;
#line 40 "../../../src/core/plugin.vala"
	g_return_val_if_fail (query != NULL, FALSE);
#line 42 "../../../src/core/plugin.vala"
	result = TRUE;
#line 42 "../../../src/core/plugin.vala"
	return result;
#line 461 "plugin.c"
}

gboolean
synapse_item_provider_handles_query (SynapseItemProvider* self,
                                     SynapseQuery* query)
{
#line 40 "../../../src/core/plugin.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 40 "../../../src/core/plugin.vala"
	return SYNAPSE_ITEM_PROVIDER_GET_INTERFACE (self)->handles_query (self, query);
#line 472 "plugin.c"
}

static gboolean
synapse_item_provider_real_handles_empty_query (SynapseItemProvider* self)
{
	gboolean result = FALSE;
#line 46 "../../../src/core/plugin.vala"
	result = FALSE;
#line 46 "../../../src/core/plugin.vala"
	return result;
#line 483 "plugin.c"
}

gboolean
synapse_item_provider_handles_empty_query (SynapseItemProvider* self)
{
#line 44 "../../../src/core/plugin.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 44 "../../../src/core/plugin.vala"
	return SYNAPSE_ITEM_PROVIDER_GET_INTERFACE (self)->handles_empty_query (self);
#line 493 "plugin.c"
}

static void
synapse_item_provider_default_init (SynapseItemProviderIface * iface,
                                    gpointer iface_data)
{
#line 37 "../../../src/core/plugin.vala"
	iface->handles_query = synapse_item_provider_real_handles_query;
#line 37 "../../../src/core/plugin.vala"
	iface->handles_empty_query = synapse_item_provider_real_handles_empty_query;
#line 504 "plugin.c"
}

static GType
synapse_item_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseItemProviderIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_item_provider_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType synapse_item_provider_type_id;
	synapse_item_provider_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseItemProvider", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (synapse_item_provider_type_id, SYNAPSE_TYPE_ACTIVATABLE);
	return synapse_item_provider_type_id;
}

GType
synapse_item_provider_get_type (void)
{
	static volatile gsize synapse_item_provider_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_item_provider_type_id__volatile)) {
		GType synapse_item_provider_type_id;
		synapse_item_provider_type_id = synapse_item_provider_get_type_once ();
		g_once_init_leave (&synapse_item_provider_type_id__volatile, synapse_item_provider_type_id);
	}
	return synapse_item_provider_type_id__volatile;
}

SynapseResultSet*
synapse_action_provider_find_for_match (SynapseActionProvider* self,
                                        SynapseQuery* query,
                                        SynapseMatch* match)
{
#line 52 "../../../src/core/plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 52 "../../../src/core/plugin.vala"
	return SYNAPSE_ACTION_PROVIDER_GET_INTERFACE (self)->find_for_match (self, query, match);
#line 538 "plugin.c"
}

static gboolean
synapse_action_provider_real_handles_unknown (SynapseActionProvider* self)
{
	gboolean result = FALSE;
#line 55 "../../../src/core/plugin.vala"
	result = FALSE;
#line 55 "../../../src/core/plugin.vala"
	return result;
#line 549 "plugin.c"
}

gboolean
synapse_action_provider_handles_unknown (SynapseActionProvider* self)
{
#line 53 "../../../src/core/plugin.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 53 "../../../src/core/plugin.vala"
	return SYNAPSE_ACTION_PROVIDER_GET_INTERFACE (self)->handles_unknown (self);
#line 559 "plugin.c"
}

static void
synapse_action_provider_default_init (SynapseActionProviderIface * iface,
                                      gpointer iface_data)
{
#line 50 "../../../src/core/plugin.vala"
	iface->handles_unknown = synapse_action_provider_real_handles_unknown;
#line 568 "plugin.c"
}

static GType
synapse_action_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseActionProviderIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_action_provider_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType synapse_action_provider_type_id;
	synapse_action_provider_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseActionProvider", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (synapse_action_provider_type_id, SYNAPSE_TYPE_ACTIVATABLE);
	return synapse_action_provider_type_id;
}

GType
synapse_action_provider_get_type (void)
{
	static volatile gsize synapse_action_provider_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_action_provider_type_id__volatile)) {
		GType synapse_action_provider_type_id;
		synapse_action_provider_type_id = synapse_action_provider_get_type_once ();
		g_once_init_leave (&synapse_action_provider_type_id__volatile, synapse_action_provider_type_id);
	}
	return synapse_action_provider_type_id__volatile;
}

SynapsePluginInfo*
synapse_plugin_info_construct (GType object_type,
                               GType type,
                               const gchar* title,
                               const gchar* desc,
                               const gchar* icon_name,
                               SynapsePluginRegisterFunc reg_func,
                               gboolean runnable,
                               const gchar* runnable_error)
{
	SynapsePluginInfo* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 72 "../../../src/core/plugin.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 72 "../../../src/core/plugin.vala"
	g_return_val_if_fail (desc != NULL, NULL);
#line 72 "../../../src/core/plugin.vala"
	g_return_val_if_fail (icon_name != NULL, NULL);
#line 72 "../../../src/core/plugin.vala"
	g_return_val_if_fail (runnable_error != NULL, NULL);
#line 72 "../../../src/core/plugin.vala"
	self = (SynapsePluginInfo*) g_type_create_instance (object_type);
#line 76 "../../../src/core/plugin.vala"
	self->plugin_type = type;
#line 77 "../../../src/core/plugin.vala"
	_tmp0_ = g_strdup (title);
#line 77 "../../../src/core/plugin.vala"
	_g_free0 (self->title);
#line 77 "../../../src/core/plugin.vala"
	self->title = _tmp0_;
#line 78 "../../../src/core/plugin.vala"
	_tmp1_ = g_strdup (desc);
#line 78 "../../../src/core/plugin.vala"
	_g_free0 (self->description);
#line 78 "../../../src/core/plugin.vala"
	self->description = _tmp1_;
#line 79 "../../../src/core/plugin.vala"
	_tmp2_ = g_strdup (icon_name);
#line 79 "../../../src/core/plugin.vala"
	_g_free0 (self->icon_name);
#line 79 "../../../src/core/plugin.vala"
	self->icon_name = _tmp2_;
#line 80 "../../../src/core/plugin.vala"
	self->register_func = reg_func;
#line 81 "../../../src/core/plugin.vala"
	self->runnable = runnable;
#line 82 "../../../src/core/plugin.vala"
	_tmp3_ = g_strdup (runnable_error);
#line 82 "../../../src/core/plugin.vala"
	_g_free0 (self->runnable_error);
#line 82 "../../../src/core/plugin.vala"
	self->runnable_error = _tmp3_;
#line 72 "../../../src/core/plugin.vala"
	return self;
#line 650 "plugin.c"
}

SynapsePluginInfo*
synapse_plugin_info_new (GType type,
                         const gchar* title,
                         const gchar* desc,
                         const gchar* icon_name,
                         SynapsePluginRegisterFunc reg_func,
                         gboolean runnable,
                         const gchar* runnable_error)
{
#line 72 "../../../src/core/plugin.vala"
	return synapse_plugin_info_construct (SYNAPSE_TYPE_PLUGIN_INFO, type, title, desc, icon_name, reg_func, runnable, runnable_error);
#line 664 "plugin.c"
}

static void
synapse_value_plugin_info_init (GValue* value)
{
#line 63 "../../../src/core/plugin.vala"
	value->data[0].v_pointer = NULL;
#line 672 "plugin.c"
}

static void
synapse_value_plugin_info_free_value (GValue* value)
{
#line 63 "../../../src/core/plugin.vala"
	if (value->data[0].v_pointer) {
#line 63 "../../../src/core/plugin.vala"
		synapse_plugin_info_unref (value->data[0].v_pointer);
#line 682 "plugin.c"
	}
}

static void
synapse_value_plugin_info_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
#line 63 "../../../src/core/plugin.vala"
	if (src_value->data[0].v_pointer) {
#line 63 "../../../src/core/plugin.vala"
		dest_value->data[0].v_pointer = synapse_plugin_info_ref (src_value->data[0].v_pointer);
#line 694 "plugin.c"
	} else {
#line 63 "../../../src/core/plugin.vala"
		dest_value->data[0].v_pointer = NULL;
#line 698 "plugin.c"
	}
}

static gpointer
synapse_value_plugin_info_peek_pointer (const GValue* value)
{
#line 63 "../../../src/core/plugin.vala"
	return value->data[0].v_pointer;
#line 707 "plugin.c"
}

static gchar*
synapse_value_plugin_info_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
#line 63 "../../../src/core/plugin.vala"
	if (collect_values[0].v_pointer) {
#line 718 "plugin.c"
		SynapsePluginInfo * object;
		object = collect_values[0].v_pointer;
#line 63 "../../../src/core/plugin.vala"
		if (object->parent_instance.g_class == NULL) {
#line 63 "../../../src/core/plugin.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 725 "plugin.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 63 "../../../src/core/plugin.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 729 "plugin.c"
		}
#line 63 "../../../src/core/plugin.vala"
		value->data[0].v_pointer = synapse_plugin_info_ref (object);
#line 733 "plugin.c"
	} else {
#line 63 "../../../src/core/plugin.vala"
		value->data[0].v_pointer = NULL;
#line 737 "plugin.c"
	}
#line 63 "../../../src/core/plugin.vala"
	return NULL;
#line 741 "plugin.c"
}

static gchar*
synapse_value_plugin_info_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	SynapsePluginInfo ** object_p;
	object_p = collect_values[0].v_pointer;
#line 63 "../../../src/core/plugin.vala"
	if (!object_p) {
#line 63 "../../../src/core/plugin.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 756 "plugin.c"
	}
#line 63 "../../../src/core/plugin.vala"
	if (!value->data[0].v_pointer) {
#line 63 "../../../src/core/plugin.vala"
		*object_p = NULL;
#line 762 "plugin.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 63 "../../../src/core/plugin.vala"
		*object_p = value->data[0].v_pointer;
#line 766 "plugin.c"
	} else {
#line 63 "../../../src/core/plugin.vala"
		*object_p = synapse_plugin_info_ref (value->data[0].v_pointer);
#line 770 "plugin.c"
	}
#line 63 "../../../src/core/plugin.vala"
	return NULL;
#line 774 "plugin.c"
}

GParamSpec*
synapse_param_spec_plugin_info (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	SynapseParamSpecPluginInfo* spec;
#line 63 "../../../src/core/plugin.vala"
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_TYPE_PLUGIN_INFO), NULL);
#line 63 "../../../src/core/plugin.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 63 "../../../src/core/plugin.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 63 "../../../src/core/plugin.vala"
	return G_PARAM_SPEC (spec);
#line 793 "plugin.c"
}

gpointer
synapse_value_get_plugin_info (const GValue* value)
{
#line 63 "../../../src/core/plugin.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_TYPE_PLUGIN_INFO), NULL);
#line 63 "../../../src/core/plugin.vala"
	return value->data[0].v_pointer;
#line 803 "plugin.c"
}

void
synapse_value_set_plugin_info (GValue* value,
                               gpointer v_object)
{
	SynapsePluginInfo * old;
#line 63 "../../../src/core/plugin.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_TYPE_PLUGIN_INFO));
#line 63 "../../../src/core/plugin.vala"
	old = value->data[0].v_pointer;
#line 63 "../../../src/core/plugin.vala"
	if (v_object) {
#line 63 "../../../src/core/plugin.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_TYPE_PLUGIN_INFO));
#line 63 "../../../src/core/plugin.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 63 "../../../src/core/plugin.vala"
		value->data[0].v_pointer = v_object;
#line 63 "../../../src/core/plugin.vala"
		synapse_plugin_info_ref (value->data[0].v_pointer);
#line 825 "plugin.c"
	} else {
#line 63 "../../../src/core/plugin.vala"
		value->data[0].v_pointer = NULL;
#line 829 "plugin.c"
	}
#line 63 "../../../src/core/plugin.vala"
	if (old) {
#line 63 "../../../src/core/plugin.vala"
		synapse_plugin_info_unref (old);
#line 835 "plugin.c"
	}
}

void
synapse_value_take_plugin_info (GValue* value,
                                gpointer v_object)
{
	SynapsePluginInfo * old;
#line 63 "../../../src/core/plugin.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_TYPE_PLUGIN_INFO));
#line 63 "../../../src/core/plugin.vala"
	old = value->data[0].v_pointer;
#line 63 "../../../src/core/plugin.vala"
	if (v_object) {
#line 63 "../../../src/core/plugin.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_TYPE_PLUGIN_INFO));
#line 63 "../../../src/core/plugin.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 63 "../../../src/core/plugin.vala"
		value->data[0].v_pointer = v_object;
#line 856 "plugin.c"
	} else {
#line 63 "../../../src/core/plugin.vala"
		value->data[0].v_pointer = NULL;
#line 860 "plugin.c"
	}
#line 63 "../../../src/core/plugin.vala"
	if (old) {
#line 63 "../../../src/core/plugin.vala"
		synapse_plugin_info_unref (old);
#line 866 "plugin.c"
	}
}

static void
synapse_plugin_info_class_init (SynapsePluginInfoClass * klass,
                                gpointer klass_data)
{
#line 63 "../../../src/core/plugin.vala"
	synapse_plugin_info_parent_class = g_type_class_peek_parent (klass);
#line 63 "../../../src/core/plugin.vala"
	((SynapsePluginInfoClass *) klass)->finalize = synapse_plugin_info_finalize;
#line 878 "plugin.c"
}

static void
synapse_plugin_info_instance_init (SynapsePluginInfo * self,
                                   gpointer klass)
{
#line 63 "../../../src/core/plugin.vala"
	self->ref_count = 1;
#line 887 "plugin.c"
}

static void
synapse_plugin_info_finalize (SynapsePluginInfo * obj)
{
	SynapsePluginInfo * self;
#line 63 "../../../src/core/plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_PLUGIN_INFO, SynapsePluginInfo);
#line 63 "../../../src/core/plugin.vala"
	g_signal_handlers_destroy (self);
#line 66 "../../../src/core/plugin.vala"
	_g_free0 (self->title);
#line 67 "../../../src/core/plugin.vala"
	_g_free0 (self->description);
#line 68 "../../../src/core/plugin.vala"
	_g_free0 (self->icon_name);
#line 71 "../../../src/core/plugin.vala"
	_g_free0 (self->runnable_error);
#line 906 "plugin.c"
}

static GType
synapse_plugin_info_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { synapse_value_plugin_info_init, synapse_value_plugin_info_free_value, synapse_value_plugin_info_copy_value, synapse_value_plugin_info_peek_pointer, "p", synapse_value_plugin_info_collect_value, "p", synapse_value_plugin_info_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SynapsePluginInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_plugin_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapsePluginInfo), 0, (GInstanceInitFunc) synapse_plugin_info_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType synapse_plugin_info_type_id;
	synapse_plugin_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapsePluginInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return synapse_plugin_info_type_id;
}

GType
synapse_plugin_info_get_type (void)
{
	static volatile gsize synapse_plugin_info_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_plugin_info_type_id__volatile)) {
		GType synapse_plugin_info_type_id;
		synapse_plugin_info_type_id = synapse_plugin_info_get_type_once ();
		g_once_init_leave (&synapse_plugin_info_type_id__volatile, synapse_plugin_info_type_id);
	}
	return synapse_plugin_info_type_id__volatile;
}

gpointer
synapse_plugin_info_ref (gpointer instance)
{
	SynapsePluginInfo * self;
	self = instance;
#line 63 "../../../src/core/plugin.vala"
	g_atomic_int_inc (&self->ref_count);
#line 63 "../../../src/core/plugin.vala"
	return instance;
#line 941 "plugin.c"
}

void
synapse_plugin_info_unref (gpointer instance)
{
	SynapsePluginInfo * self;
	self = instance;
#line 63 "../../../src/core/plugin.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 63 "../../../src/core/plugin.vala"
		SYNAPSE_PLUGIN_INFO_GET_CLASS (self)->finalize (self);
#line 63 "../../../src/core/plugin.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 955 "plugin.c"
	}
}

static inline gpointer
synapse_plugin_registry_get_instance_private (SynapsePluginRegistry* self)
{
	return G_STRUCT_MEMBER_P (self, SynapsePluginRegistry_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 105 "../../../src/core/plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 970 "plugin.c"
}

SynapsePluginRegistry*
synapse_plugin_registry_get_default (void)
{
	SynapsePluginRegistry* _tmp0_ = NULL;
	SynapsePluginRegistry* _tmp1_;
	SynapsePluginRegistry* _tmp2_;
	SynapsePluginRegistry* _tmp4_;
	SynapsePluginRegistry* result = NULL;
#line 105 "../../../src/core/plugin.vala"
	_tmp1_ = synapse_plugin_registry_instance;
#line 105 "../../../src/core/plugin.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 105 "../../../src/core/plugin.vala"
	_tmp0_ = _tmp2_;
#line 105 "../../../src/core/plugin.vala"
	if (_tmp0_ == NULL) {
#line 989 "plugin.c"
		SynapsePluginRegistry* _tmp3_;
#line 105 "../../../src/core/plugin.vala"
		_tmp3_ = synapse_plugin_registry_new ();
#line 105 "../../../src/core/plugin.vala"
		_g_object_unref0 (_tmp0_);
#line 105 "../../../src/core/plugin.vala"
		_tmp0_ = _tmp3_;
#line 997 "plugin.c"
	}
#line 105 "../../../src/core/plugin.vala"
	_tmp4_ = _tmp0_;
#line 105 "../../../src/core/plugin.vala"
	_tmp0_ = NULL;
#line 105 "../../../src/core/plugin.vala"
	result = _tmp4_;
#line 105 "../../../src/core/plugin.vala"
	_g_object_unref0 (_tmp0_);
#line 105 "../../../src/core/plugin.vala"
	return result;
#line 1009 "plugin.c"
}

void
synapse_plugin_registry_register_plugin (SynapsePluginRegistry* self,
                                         GType plugin_type,
                                         const gchar* title,
                                         const gchar* description,
                                         const gchar* icon_name,
                                         SynapsePluginRegisterFunc reg_func,
                                         gboolean runnable,
                                         const gchar* runnable_error)
{
	gint index = 0;
	SynapsePluginInfo* p = NULL;
	SynapsePluginInfo* _tmp12_;
	GeeList* _tmp13_;
#line 108 "../../../src/core/plugin.vala"
	g_return_if_fail (self != NULL);
#line 108 "../../../src/core/plugin.vala"
	g_return_if_fail (title != NULL);
#line 108 "../../../src/core/plugin.vala"
	g_return_if_fail (description != NULL);
#line 108 "../../../src/core/plugin.vala"
	g_return_if_fail (icon_name != NULL);
#line 108 "../../../src/core/plugin.vala"
	g_return_if_fail (runnable_error != NULL);
#line 117 "../../../src/core/plugin.vala"
	index = -1;
#line 1038 "plugin.c"
	{
		gint i = 0;
#line 118 "../../../src/core/plugin.vala"
		i = 0;
#line 1043 "plugin.c"
		{
			gboolean _tmp0_ = FALSE;
#line 118 "../../../src/core/plugin.vala"
			_tmp0_ = TRUE;
#line 118 "../../../src/core/plugin.vala"
			while (TRUE) {
#line 1050 "plugin.c"
				GeeList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				GeeList* _tmp5_;
				gpointer _tmp6_;
				SynapsePluginInfo* _tmp7_;
				gboolean _tmp8_;
#line 118 "../../../src/core/plugin.vala"
				if (!_tmp0_) {
#line 1060 "plugin.c"
					gint _tmp1_;
#line 118 "../../../src/core/plugin.vala"
					_tmp1_ = i;
#line 118 "../../../src/core/plugin.vala"
					i = _tmp1_ + 1;
#line 1066 "plugin.c"
				}
#line 118 "../../../src/core/plugin.vala"
				_tmp0_ = FALSE;
#line 118 "../../../src/core/plugin.vala"
				_tmp2_ = self->priv->plugins;
#line 118 "../../../src/core/plugin.vala"
				_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 118 "../../../src/core/plugin.vala"
				_tmp4_ = _tmp3_;
#line 118 "../../../src/core/plugin.vala"
				if (!(i < _tmp4_)) {
#line 118 "../../../src/core/plugin.vala"
					break;
#line 1080 "plugin.c"
				}
#line 120 "../../../src/core/plugin.vala"
				_tmp5_ = self->priv->plugins;
#line 120 "../../../src/core/plugin.vala"
				_tmp6_ = gee_list_get (_tmp5_, i);
#line 120 "../../../src/core/plugin.vala"
				_tmp7_ = (SynapsePluginInfo*) _tmp6_;
#line 120 "../../../src/core/plugin.vala"
				_tmp8_ = _tmp7_->plugin_type == plugin_type;
#line 120 "../../../src/core/plugin.vala"
				_synapse_plugin_info_unref0 (_tmp7_);
#line 120 "../../../src/core/plugin.vala"
				if (_tmp8_) {
#line 122 "../../../src/core/plugin.vala"
					index = i;
#line 123 "../../../src/core/plugin.vala"
					break;
#line 1098 "plugin.c"
				}
			}
		}
	}
#line 126 "../../../src/core/plugin.vala"
	if (index >= 0) {
#line 1105 "plugin.c"
		GeeList* _tmp9_;
		gpointer _tmp10_;
		SynapsePluginInfo* _tmp11_;
#line 126 "../../../src/core/plugin.vala"
		_tmp9_ = self->priv->plugins;
#line 126 "../../../src/core/plugin.vala"
		_tmp10_ = gee_list_remove_at (_tmp9_, index);
#line 126 "../../../src/core/plugin.vala"
		_tmp11_ = (SynapsePluginInfo*) _tmp10_;
#line 126 "../../../src/core/plugin.vala"
		_synapse_plugin_info_unref0 (_tmp11_);
#line 1117 "plugin.c"
	}
#line 128 "../../../src/core/plugin.vala"
	_tmp12_ = synapse_plugin_info_new (plugin_type, title, description, icon_name, reg_func, runnable, runnable_error);
#line 128 "../../../src/core/plugin.vala"
	p = _tmp12_;
#line 130 "../../../src/core/plugin.vala"
	_tmp13_ = self->priv->plugins;
#line 130 "../../../src/core/plugin.vala"
	gee_collection_add ((GeeCollection*) _tmp13_, p);
#line 108 "../../../src/core/plugin.vala"
	_synapse_plugin_info_unref0 (p);
#line 1129 "plugin.c"
}

GeeList*
synapse_plugin_registry_get_plugins (SynapsePluginRegistry* self)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* result = NULL;
#line 133 "../../../src/core/plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 135 "../../../src/core/plugin.vala"
	_tmp0_ = self->priv->plugins;
#line 135 "../../../src/core/plugin.vala"
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
#line 135 "../../../src/core/plugin.vala"
	_tmp2_ = _tmp1_;
#line 135 "../../../src/core/plugin.vala"
	result = _tmp2_;
#line 135 "../../../src/core/plugin.vala"
	return result;
#line 1151 "plugin.c"
}

SynapsePluginInfo*
synapse_plugin_registry_get_plugin_info_for_type (SynapsePluginRegistry* self,
                                                  GType plugin_type)
{
	SynapsePluginInfo* result = NULL;
#line 138 "../../../src/core/plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1161 "plugin.c"
	{
		GeeList* _pi_list = NULL;
		GeeList* _tmp0_;
		GeeList* _tmp1_;
		gint _pi_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _pi_index = 0;
#line 140 "../../../src/core/plugin.vala"
		_tmp0_ = self->priv->plugins;
#line 140 "../../../src/core/plugin.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 140 "../../../src/core/plugin.vala"
		_pi_list = _tmp1_;
#line 140 "../../../src/core/plugin.vala"
		_tmp2_ = _pi_list;
#line 140 "../../../src/core/plugin.vala"
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 140 "../../../src/core/plugin.vala"
		_tmp4_ = _tmp3_;
#line 140 "../../../src/core/plugin.vala"
		_pi_size = _tmp4_;
#line 140 "../../../src/core/plugin.vala"
		_pi_index = -1;
#line 140 "../../../src/core/plugin.vala"
		while (TRUE) {
#line 1189 "plugin.c"
			gint _tmp5_;
			gint _tmp6_;
			SynapsePluginInfo* pi = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			SynapsePluginInfo* _tmp9_;
#line 140 "../../../src/core/plugin.vala"
			_pi_index = _pi_index + 1;
#line 140 "../../../src/core/plugin.vala"
			_tmp5_ = _pi_index;
#line 140 "../../../src/core/plugin.vala"
			_tmp6_ = _pi_size;
#line 140 "../../../src/core/plugin.vala"
			if (!(_tmp5_ < _tmp6_)) {
#line 140 "../../../src/core/plugin.vala"
				break;
#line 1206 "plugin.c"
			}
#line 140 "../../../src/core/plugin.vala"
			_tmp7_ = _pi_list;
#line 140 "../../../src/core/plugin.vala"
			_tmp8_ = gee_list_get (_tmp7_, _pi_index);
#line 140 "../../../src/core/plugin.vala"
			pi = (SynapsePluginInfo*) _tmp8_;
#line 142 "../../../src/core/plugin.vala"
			_tmp9_ = pi;
#line 142 "../../../src/core/plugin.vala"
			if (_tmp9_->plugin_type == plugin_type) {
#line 142 "../../../src/core/plugin.vala"
				result = pi;
#line 142 "../../../src/core/plugin.vala"
				_g_object_unref0 (_pi_list);
#line 142 "../../../src/core/plugin.vala"
				return result;
#line 1224 "plugin.c"
			}
#line 140 "../../../src/core/plugin.vala"
			_synapse_plugin_info_unref0 (pi);
#line 1228 "plugin.c"
		}
#line 140 "../../../src/core/plugin.vala"
		_g_object_unref0 (_pi_list);
#line 1232 "plugin.c"
	}
#line 145 "../../../src/core/plugin.vala"
	result = NULL;
#line 145 "../../../src/core/plugin.vala"
	return result;
#line 1238 "plugin.c"
}

SynapsePluginRegistry*
synapse_plugin_registry_construct (GType object_type)
{
	SynapsePluginRegistry * self = NULL;
#line 86 "../../../src/core/plugin.vala"
	self = (SynapsePluginRegistry*) g_object_new (object_type, NULL);
#line 86 "../../../src/core/plugin.vala"
	return self;
#line 1249 "plugin.c"
}

SynapsePluginRegistry*
synapse_plugin_registry_new (void)
{
#line 86 "../../../src/core/plugin.vala"
	return synapse_plugin_registry_construct (SYNAPSE_TYPE_PLUGIN_REGISTRY);
#line 1257 "plugin.c"
}

static GObject *
synapse_plugin_registry_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapsePluginRegistry * self;
	GeeArrayList* _tmp0_;
#line 92 "../../../src/core/plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_plugin_registry_parent_class);
#line 92 "../../../src/core/plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 92 "../../../src/core/plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_PLUGIN_REGISTRY, SynapsePluginRegistry);
#line 94 "../../../src/core/plugin.vala"
	synapse_plugin_registry_instance = self;
#line 95 "../../../src/core/plugin.vala"
	_tmp0_ = gee_array_list_new (SYNAPSE_TYPE_PLUGIN_INFO, (GBoxedCopyFunc) synapse_plugin_info_ref, (GDestroyNotify) synapse_plugin_info_unref, NULL, NULL, NULL);
#line 95 "../../../src/core/plugin.vala"
	_g_object_unref0 (self->priv->plugins);
#line 95 "../../../src/core/plugin.vala"
	self->priv->plugins = (GeeList*) _tmp0_;
#line 92 "../../../src/core/plugin.vala"
	return obj;
#line 1285 "plugin.c"
}

static void
synapse_plugin_registry_class_init (SynapsePluginRegistryClass * klass,
                                    gpointer klass_data)
{
#line 86 "../../../src/core/plugin.vala"
	synapse_plugin_registry_parent_class = g_type_class_peek_parent (klass);
#line 86 "../../../src/core/plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapsePluginRegistry_private_offset);
#line 86 "../../../src/core/plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_plugin_registry_constructor;
#line 86 "../../../src/core/plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_plugin_registry_finalize;
#line 1300 "plugin.c"
}

static void
synapse_plugin_registry_instance_init (SynapsePluginRegistry * self,
                                       gpointer klass)
{
#line 86 "../../../src/core/plugin.vala"
	self->priv = synapse_plugin_registry_get_instance_private (self);
#line 1309 "plugin.c"
}

static void
synapse_plugin_registry_finalize (GObject * obj)
{
	SynapsePluginRegistry * self;
#line 86 "../../../src/core/plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_PLUGIN_REGISTRY, SynapsePluginRegistry);
#line 100 "../../../src/core/plugin.vala"
	synapse_plugin_registry_instance = NULL;
#line 90 "../../../src/core/plugin.vala"
	_g_object_unref0 (self->priv->plugins);
#line 86 "../../../src/core/plugin.vala"
	G_OBJECT_CLASS (synapse_plugin_registry_parent_class)->finalize (obj);
#line 1324 "plugin.c"
}

static GType
synapse_plugin_registry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapsePluginRegistryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_plugin_registry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapsePluginRegistry), 0, (GInstanceInitFunc) synapse_plugin_registry_instance_init, NULL };
	GType synapse_plugin_registry_type_id;
	synapse_plugin_registry_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapsePluginRegistry", &g_define_type_info, 0);
	SynapsePluginRegistry_private_offset = g_type_add_instance_private (synapse_plugin_registry_type_id, sizeof (SynapsePluginRegistryPrivate));
	return synapse_plugin_registry_type_id;
}

GType
synapse_plugin_registry_get_type (void)
{
	static volatile gsize synapse_plugin_registry_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_plugin_registry_type_id__volatile)) {
		GType synapse_plugin_registry_type_id;
		synapse_plugin_registry_type_id = synapse_plugin_registry_get_type_once ();
		g_once_init_leave (&synapse_plugin_registry_type_id__volatile, synapse_plugin_registry_type_id);
	}
	return synapse_plugin_registry_type_id__volatile;
}

