/* synapse-core.h generated by valac 0.48.17, the Vala compiler, do not modify */

#ifndef __SYNAPSE_CORE_H__
#define __SYNAPSE_CORE_H__

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>

G_BEGIN_DECLS

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_MATCH, SynapseMatchClass))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_IS_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchClass))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchClass SynapseMatchClass;
typedef struct _SynapseMatchPrivate SynapseMatchPrivate;
typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;

#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())

#define SYNAPSE_TYPE_ACTION (synapse_action_get_type ())
#define SYNAPSE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTION, SynapseAction))
#define SYNAPSE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_ACTION, SynapseActionClass))
#define SYNAPSE_IS_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTION))
#define SYNAPSE_IS_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_ACTION))
#define SYNAPSE_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_ACTION, SynapseActionClass))

typedef struct _SynapseAction SynapseAction;
typedef struct _SynapseActionClass SynapseActionClass;
typedef struct _SynapseActionPrivate SynapseActionPrivate;

#define SYNAPSE_TYPE_ACTIVATABLE (synapse_activatable_get_type ())
#define SYNAPSE_ACTIVATABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatable))
#define SYNAPSE_IS_ACTIVATABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTIVATABLE))
#define SYNAPSE_ACTIVATABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatableIface))

typedef struct _SynapseActivatable SynapseActivatable;
typedef struct _SynapseActivatableIface SynapseActivatableIface;

#define SYNAPSE_TYPE_ACTION_PROVIDER (synapse_action_provider_get_type ())
#define SYNAPSE_ACTION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTION_PROVIDER, SynapseActionProvider))
#define SYNAPSE_IS_ACTION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTION_PROVIDER))
#define SYNAPSE_ACTION_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ACTION_PROVIDER, SynapseActionProviderIface))

typedef struct _SynapseActionProvider SynapseActionProvider;
typedef struct _SynapseActionProviderIface SynapseActionProviderIface;

#define SYNAPSE_TYPE_QUERY (synapse_query_get_type ())
typedef struct _SynapseQuery SynapseQuery;

#define SYNAPSE_TYPE_RESULT_SET (synapse_result_set_get_type ())
#define SYNAPSE_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSet))
#define SYNAPSE_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))
#define SYNAPSE_IS_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_IS_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_RESULT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))

typedef struct _SynapseResultSet SynapseResultSet;
typedef struct _SynapseResultSetClass SynapseResultSetClass;

#define SYNAPSE_TYPE_COMMON_ACTIONS (synapse_common_actions_get_type ())
#define SYNAPSE_COMMON_ACTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions))
#define SYNAPSE_COMMON_ACTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActionsClass))
#define SYNAPSE_IS_COMMON_ACTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_COMMON_ACTIONS))
#define SYNAPSE_IS_COMMON_ACTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_COMMON_ACTIONS))
#define SYNAPSE_COMMON_ACTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActionsClass))

typedef struct _SynapseCommonActions SynapseCommonActions;
typedef struct _SynapseCommonActionsClass SynapseCommonActionsClass;
typedef struct _SynapseCommonActionsPrivate SynapseCommonActionsPrivate;

#define SYNAPSE_TYPE_CONFIG_OBJECT (synapse_config_object_get_type ())
#define SYNAPSE_CONFIG_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_CONFIG_OBJECT, SynapseConfigObject))
#define SYNAPSE_CONFIG_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_CONFIG_OBJECT, SynapseConfigObjectClass))
#define SYNAPSE_IS_CONFIG_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_CONFIG_OBJECT))
#define SYNAPSE_IS_CONFIG_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_CONFIG_OBJECT))
#define SYNAPSE_CONFIG_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_CONFIG_OBJECT, SynapseConfigObjectClass))

typedef struct _SynapseConfigObject SynapseConfigObject;
typedef struct _SynapseConfigObjectClass SynapseConfigObjectClass;
typedef struct _SynapseConfigObjectPrivate SynapseConfigObjectPrivate;

#define SYNAPSE_TYPE_CONFIG_SERVICE (synapse_config_service_get_type ())
#define SYNAPSE_CONFIG_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_CONFIG_SERVICE, SynapseConfigService))
#define SYNAPSE_CONFIG_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_CONFIG_SERVICE, SynapseConfigServiceClass))
#define SYNAPSE_IS_CONFIG_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_CONFIG_SERVICE))
#define SYNAPSE_IS_CONFIG_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_CONFIG_SERVICE))
#define SYNAPSE_CONFIG_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_CONFIG_SERVICE, SynapseConfigServiceClass))

typedef struct _SynapseConfigService SynapseConfigService;
typedef struct _SynapseConfigServiceClass SynapseConfigServiceClass;
typedef struct _SynapseConfigServicePrivate SynapseConfigServicePrivate;

#define SYNAPSE_TYPE_SEARCH_PROVIDER (synapse_search_provider_get_type ())
#define SYNAPSE_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER, SynapseSearchProvider))
#define SYNAPSE_IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER))
#define SYNAPSE_SEARCH_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER, SynapseSearchProviderIface))

typedef struct _SynapseSearchProvider SynapseSearchProvider;
typedef struct _SynapseSearchProviderIface SynapseSearchProviderIface;

#define SYNAPSE_TYPE_DATA_SINK (synapse_data_sink_get_type ())
#define SYNAPSE_DATA_SINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DATA_SINK, SynapseDataSink))
#define SYNAPSE_DATA_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DATA_SINK, SynapseDataSinkClass))
#define SYNAPSE_IS_DATA_SINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DATA_SINK))
#define SYNAPSE_IS_DATA_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DATA_SINK))
#define SYNAPSE_DATA_SINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DATA_SINK, SynapseDataSinkClass))

typedef struct _SynapseDataSink SynapseDataSink;
typedef struct _SynapseDataSinkClass SynapseDataSinkClass;
typedef struct _SynapseDataSinkPrivate SynapseDataSinkPrivate;

#define SYNAPSE_TYPE_FREE_DESKTOP_DBUS (synapse_free_desktop_dbus_get_type ())
#define SYNAPSE_FREE_DESKTOP_DBUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_FREE_DESKTOP_DBUS, SynapseFreeDesktopDBus))
#define SYNAPSE_IS_FREE_DESKTOP_DBUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_FREE_DESKTOP_DBUS))
#define SYNAPSE_FREE_DESKTOP_DBUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_FREE_DESKTOP_DBUS, SynapseFreeDesktopDBusIface))

typedef struct _SynapseFreeDesktopDBus SynapseFreeDesktopDBus;
typedef struct _SynapseFreeDesktopDBusIface SynapseFreeDesktopDBusIface;

#define SYNAPSE_TYPE_FREE_DESKTOP_DBUS_PROXY (synapse_free_desktop_dbus_proxy_get_type ())

#define SYNAPSE_TYPE_DBUS_SERVICE (synapse_dbus_service_get_type ())
#define SYNAPSE_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DBUS_SERVICE, SynapseDBusService))
#define SYNAPSE_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DBUS_SERVICE, SynapseDBusServiceClass))
#define SYNAPSE_IS_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DBUS_SERVICE))
#define SYNAPSE_IS_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DBUS_SERVICE))
#define SYNAPSE_DBUS_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DBUS_SERVICE, SynapseDBusServiceClass))

typedef struct _SynapseDBusService SynapseDBusService;
typedef struct _SynapseDBusServiceClass SynapseDBusServiceClass;
typedef struct _SynapseDBusServicePrivate SynapseDBusServicePrivate;
typedef enum  {
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME = 1 << 0,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_KDE = 1 << 1,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_LXDE = 1 << 2,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_MATE = 1 << 3,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_RAZOR = 1 << 4,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_ROX = 1 << 5,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_TDE = 1 << 6,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_UNITY = 1 << 7,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_XFCE = 1 << 8,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_EDE = 1 << 9,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_CINNAMON = 1 << 10,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_PANTHEON = 1 << 11,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_OLD = 1 << 12,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_ALL = 0xFFF
} SynapseDesktopEnvironmentType;

#define SYNAPSE_TYPE_DESKTOP_ENVIRONMENT_TYPE (synapse_desktop_environment_type_get_type ())

#define SYNAPSE_TYPE_DESKTOP_FILE_INFO (synapse_desktop_file_info_get_type ())
#define SYNAPSE_DESKTOP_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo))
#define SYNAPSE_DESKTOP_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfoClass))
#define SYNAPSE_IS_DESKTOP_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO))
#define SYNAPSE_IS_DESKTOP_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_INFO))
#define SYNAPSE_DESKTOP_FILE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfoClass))

typedef struct _SynapseDesktopFileInfo SynapseDesktopFileInfo;
typedef struct _SynapseDesktopFileInfoClass SynapseDesktopFileInfoClass;
typedef struct _SynapseDesktopFileInfoPrivate SynapseDesktopFileInfoPrivate;

#define SYNAPSE_TYPE_DESKTOP_FILE_SERVICE (synapse_desktop_file_service_get_type ())
#define SYNAPSE_DESKTOP_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileService))
#define SYNAPSE_DESKTOP_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileServiceClass))
#define SYNAPSE_IS_DESKTOP_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE))
#define SYNAPSE_IS_DESKTOP_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE))
#define SYNAPSE_DESKTOP_FILE_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileServiceClass))

typedef struct _SynapseDesktopFileService SynapseDesktopFileService;
typedef struct _SynapseDesktopFileServiceClass SynapseDesktopFileServiceClass;
typedef struct _SynapseDesktopFileServicePrivate SynapseDesktopFileServicePrivate;
typedef enum  {
	SYNAPSE_MATCH_SCORE_INCREMENT_MINOR = 2000,
	SYNAPSE_MATCH_SCORE_INCREMENT_SMALL = 5000,
	SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM = 10000,
	SYNAPSE_MATCH_SCORE_INCREMENT_LARGE = 20000,
	SYNAPSE_MATCH_SCORE_URI_PENALTY = 15000,
	SYNAPSE_MATCH_SCORE_POOR = 50000,
	SYNAPSE_MATCH_SCORE_BELOW_AVERAGE = 60000,
	SYNAPSE_MATCH_SCORE_AVERAGE = 70000,
	SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE = 75000,
	SYNAPSE_MATCH_SCORE_GOOD = 80000,
	SYNAPSE_MATCH_SCORE_VERY_GOOD = 85000,
	SYNAPSE_MATCH_SCORE_EXCELLENT = 90000,
	SYNAPSE_MATCH_SCORE_HIGHEST = 100000
} SynapseMatchScore;

#define SYNAPSE_TYPE_MATCH_SCORE (synapse_match_score_get_type ())

#define SYNAPSE_TYPE_ACTION_MATCH (synapse_action_match_get_type ())
#define SYNAPSE_ACTION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTION_MATCH, SynapseActionMatch))
#define SYNAPSE_ACTION_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_ACTION_MATCH, SynapseActionMatchClass))
#define SYNAPSE_IS_ACTION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTION_MATCH))
#define SYNAPSE_IS_ACTION_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_ACTION_MATCH))
#define SYNAPSE_ACTION_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_ACTION_MATCH, SynapseActionMatchClass))

typedef struct _SynapseActionMatch SynapseActionMatch;
typedef struct _SynapseActionMatchClass SynapseActionMatchClass;
typedef struct _SynapseActionMatchPrivate SynapseActionMatchPrivate;

#define SYNAPSE_TYPE_APPLICATION_MATCH (synapse_application_match_get_type ())
#define SYNAPSE_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch))
#define SYNAPSE_APPLICATION_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatchClass))
#define SYNAPSE_IS_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_APPLICATION_MATCH))
#define SYNAPSE_IS_APPLICATION_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_APPLICATION_MATCH))
#define SYNAPSE_APPLICATION_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatchClass))

typedef struct _SynapseApplicationMatch SynapseApplicationMatch;
typedef struct _SynapseApplicationMatchClass SynapseApplicationMatchClass;
typedef struct _SynapseApplicationMatchPrivate SynapseApplicationMatchPrivate;

#define SYNAPSE_TYPE_URI_MATCH (synapse_uri_match_get_type ())
#define SYNAPSE_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch))
#define SYNAPSE_URI_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchClass))
#define SYNAPSE_IS_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_IS_URI_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_URI_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchClass))

typedef struct _SynapseUriMatch SynapseUriMatch;
typedef struct _SynapseUriMatchClass SynapseUriMatchClass;
typedef struct _SynapseUriMatchPrivate SynapseUriMatchPrivate;

#define SYNAPSE_TYPE_CONTACT_MATCH (synapse_contact_match_get_type ())
#define SYNAPSE_CONTACT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_CONTACT_MATCH, SynapseContactMatch))
#define SYNAPSE_CONTACT_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_CONTACT_MATCH, SynapseContactMatchClass))
#define SYNAPSE_IS_CONTACT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_CONTACT_MATCH))
#define SYNAPSE_IS_CONTACT_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_CONTACT_MATCH))
#define SYNAPSE_CONTACT_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_CONTACT_MATCH, SynapseContactMatchClass))

typedef struct _SynapseContactMatch SynapseContactMatch;
typedef struct _SynapseContactMatchClass SynapseContactMatchClass;
typedef struct _SynapseContactMatchPrivate SynapseContactMatchPrivate;

#define SYNAPSE_TYPE_EXTENDED_INFO (synapse_extended_info_get_type ())
#define SYNAPSE_EXTENDED_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_EXTENDED_INFO, SynapseExtendedInfo))
#define SYNAPSE_IS_EXTENDED_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_EXTENDED_INFO))
#define SYNAPSE_EXTENDED_INFO_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_EXTENDED_INFO, SynapseExtendedInfoIface))

typedef struct _SynapseExtendedInfo SynapseExtendedInfo;
typedef struct _SynapseExtendedInfoIface SynapseExtendedInfoIface;
typedef enum  {
	SYNAPSE_TEXT_ORIGIN_UNKNOWN,
	SYNAPSE_TEXT_ORIGIN_CLIPBOARD
} SynapseTextOrigin;

#define SYNAPSE_TYPE_TEXT_ORIGIN (synapse_text_origin_get_type ())

#define SYNAPSE_TYPE_TEXT_MATCH (synapse_text_match_get_type ())
#define SYNAPSE_TEXT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatch))
#define SYNAPSE_TEXT_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatchClass))
#define SYNAPSE_IS_TEXT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_TEXT_MATCH))
#define SYNAPSE_IS_TEXT_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_TEXT_MATCH))
#define SYNAPSE_TEXT_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatchClass))

typedef struct _SynapseTextMatch SynapseTextMatch;
typedef struct _SynapseTextMatchClass SynapseTextMatchClass;
typedef struct _SynapseTextMatchPrivate SynapseTextMatchPrivate;

#define SYNAPSE_TYPE_SEARCH_MATCH (synapse_search_match_get_type ())
#define SYNAPSE_SEARCH_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatch))
#define SYNAPSE_SEARCH_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatchClass))
#define SYNAPSE_IS_SEARCH_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_SEARCH_MATCH))
#define SYNAPSE_IS_SEARCH_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_SEARCH_MATCH))
#define SYNAPSE_SEARCH_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatchClass))

typedef struct _SynapseSearchMatch SynapseSearchMatch;
typedef struct _SynapseSearchMatchClass SynapseSearchMatchClass;
typedef struct _SynapseSearchMatchPrivate SynapseSearchMatchPrivate;

#define SYNAPSE_TYPE_UNKNOWN_MATCH (synapse_unknown_match_get_type ())
#define SYNAPSE_UNKNOWN_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_UNKNOWN_MATCH, SynapseUnknownMatch))
#define SYNAPSE_UNKNOWN_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_UNKNOWN_MATCH, SynapseUnknownMatchClass))
#define SYNAPSE_IS_UNKNOWN_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_UNKNOWN_MATCH))
#define SYNAPSE_IS_UNKNOWN_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_UNKNOWN_MATCH))
#define SYNAPSE_UNKNOWN_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_UNKNOWN_MATCH, SynapseUnknownMatchClass))

typedef struct _SynapseUnknownMatch SynapseUnknownMatch;
typedef struct _SynapseUnknownMatchClass SynapseUnknownMatchClass;
typedef struct _SynapseUnknownMatchPrivate SynapseUnknownMatchPrivate;

#define SYNAPSE_TYPE_CONFIGURABLE (synapse_configurable_get_type ())
#define SYNAPSE_CONFIGURABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_CONFIGURABLE, SynapseConfigurable))
#define SYNAPSE_IS_CONFIGURABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_CONFIGURABLE))
#define SYNAPSE_CONFIGURABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_CONFIGURABLE, SynapseConfigurableIface))

typedef struct _SynapseConfigurable SynapseConfigurable;
typedef struct _SynapseConfigurableIface SynapseConfigurableIface;

#define SYNAPSE_TYPE_ITEM_PROVIDER (synapse_item_provider_get_type ())
#define SYNAPSE_ITEM_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ITEM_PROVIDER, SynapseItemProvider))
#define SYNAPSE_IS_ITEM_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ITEM_PROVIDER))
#define SYNAPSE_ITEM_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ITEM_PROVIDER, SynapseItemProviderIface))

typedef struct _SynapseItemProvider SynapseItemProvider;
typedef struct _SynapseItemProviderIface SynapseItemProviderIface;
typedef void (*SynapsePluginRegisterFunc) (void);

#define SYNAPSE_TYPE_PLUGIN_INFO (synapse_plugin_info_get_type ())
#define SYNAPSE_PLUGIN_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_PLUGIN_INFO, SynapsePluginInfo))
#define SYNAPSE_PLUGIN_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_PLUGIN_INFO, SynapsePluginInfoClass))
#define SYNAPSE_IS_PLUGIN_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_PLUGIN_INFO))
#define SYNAPSE_IS_PLUGIN_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_PLUGIN_INFO))
#define SYNAPSE_PLUGIN_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_PLUGIN_INFO, SynapsePluginInfoClass))

typedef struct _SynapsePluginInfo SynapsePluginInfo;
typedef struct _SynapsePluginInfoClass SynapsePluginInfoClass;
typedef struct _SynapsePluginInfoPrivate SynapsePluginInfoPrivate;

#define SYNAPSE_TYPE_PLUGIN_REGISTRY (synapse_plugin_registry_get_type ())
#define SYNAPSE_PLUGIN_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_PLUGIN_REGISTRY, SynapsePluginRegistry))
#define SYNAPSE_PLUGIN_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_PLUGIN_REGISTRY, SynapsePluginRegistryClass))
#define SYNAPSE_IS_PLUGIN_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_PLUGIN_REGISTRY))
#define SYNAPSE_IS_PLUGIN_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_PLUGIN_REGISTRY))
#define SYNAPSE_PLUGIN_REGISTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_PLUGIN_REGISTRY, SynapsePluginRegistryClass))

typedef struct _SynapsePluginRegistry SynapsePluginRegistry;
typedef struct _SynapsePluginRegistryClass SynapsePluginRegistryClass;
typedef struct _SynapsePluginRegistryPrivate SynapsePluginRegistryPrivate;
typedef enum  {
	SYNAPSE_MATCHER_FLAGS_NO_REVERSED = 1 << 0,
	SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING = 1 << 1,
	SYNAPSE_MATCHER_FLAGS_NO_PARTIAL = 1 << 2,
	SYNAPSE_MATCHER_FLAGS_NO_FUZZY = 1 << 3
} SynapseMatcherFlags;

#define SYNAPSE_TYPE_MATCHER_FLAGS (synapse_matcher_flags_get_type ())

#define SYNAPSE_TYPE_RELEVANCY_BACKEND (synapse_relevancy_backend_get_type ())
#define SYNAPSE_RELEVANCY_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RELEVANCY_BACKEND, SynapseRelevancyBackend))
#define SYNAPSE_IS_RELEVANCY_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RELEVANCY_BACKEND))
#define SYNAPSE_RELEVANCY_BACKEND_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_RELEVANCY_BACKEND, SynapseRelevancyBackendIface))

typedef struct _SynapseRelevancyBackend SynapseRelevancyBackend;
typedef struct _SynapseRelevancyBackendIface SynapseRelevancyBackendIface;

#define SYNAPSE_TYPE_RELEVANCY_SERVICE (synapse_relevancy_service_get_type ())
#define SYNAPSE_RELEVANCY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyService))
#define SYNAPSE_RELEVANCY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyServiceClass))
#define SYNAPSE_IS_RELEVANCY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE))
#define SYNAPSE_IS_RELEVANCY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RELEVANCY_SERVICE))
#define SYNAPSE_RELEVANCY_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyServiceClass))

typedef struct _SynapseRelevancyService SynapseRelevancyService;
typedef struct _SynapseRelevancyServiceClass SynapseRelevancyServiceClass;
typedef struct _SynapseRelevancyServicePrivate SynapseRelevancyServicePrivate;
typedef struct _SynapseResultSetPrivate SynapseResultSetPrivate;

#define SYNAPSE_UTILS_TYPE_LOGGER (synapse_utils_logger_get_type ())
#define SYNAPSE_UTILS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_UTILS_TYPE_LOGGER, SynapseUtilsLogger))
#define SYNAPSE_UTILS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_UTILS_TYPE_LOGGER, SynapseUtilsLoggerClass))
#define SYNAPSE_UTILS_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_UTILS_TYPE_LOGGER))
#define SYNAPSE_UTILS_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_UTILS_TYPE_LOGGER))
#define SYNAPSE_UTILS_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_UTILS_TYPE_LOGGER, SynapseUtilsLoggerClass))

typedef struct _SynapseUtilsLogger SynapseUtilsLogger;
typedef struct _SynapseUtilsLoggerClass SynapseUtilsLoggerClass;
typedef struct _SynapseUtilsLoggerPrivate SynapseUtilsLoggerPrivate;
typedef enum  {
	SYNAPSE_UTILS_LOGGER_LOG_LEVEL_DEBUG,
	SYNAPSE_UTILS_LOGGER_LOG_LEVEL_INFO,
	SYNAPSE_UTILS_LOGGER_LOG_LEVEL_WARN,
	SYNAPSE_UTILS_LOGGER_LOG_LEVEL_ERROR,
	SYNAPSE_UTILS_LOGGER_LOG_LEVEL_FATAL
} SynapseUtilsLoggerLogLevel;

#define SYNAPSE_UTILS_LOGGER_TYPE_LOG_LEVEL (synapse_utils_logger_log_level_get_type ())

#define SYNAPSE_UTILS_TYPE_ASYNC_ONCE (synapse_utils_async_once_get_type ())
#define SYNAPSE_UTILS_ASYNC_ONCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnce))
#define SYNAPSE_UTILS_ASYNC_ONCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnceClass))
#define SYNAPSE_UTILS_IS_ASYNC_ONCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_UTILS_TYPE_ASYNC_ONCE))
#define SYNAPSE_UTILS_IS_ASYNC_ONCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_UTILS_TYPE_ASYNC_ONCE))
#define SYNAPSE_UTILS_ASYNC_ONCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnceClass))

typedef struct _SynapseUtilsAsyncOnce SynapseUtilsAsyncOnce;
typedef struct _SynapseUtilsAsyncOnceClass SynapseUtilsAsyncOnceClass;
typedef struct _SynapseUtilsAsyncOncePrivate SynapseUtilsAsyncOncePrivate;

#define SYNAPSE_UTILS_TYPE_FILE_INFO (synapse_utils_file_info_get_type ())
#define SYNAPSE_UTILS_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_UTILS_TYPE_FILE_INFO, SynapseUtilsFileInfo))
#define SYNAPSE_UTILS_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_UTILS_TYPE_FILE_INFO, SynapseUtilsFileInfoClass))
#define SYNAPSE_UTILS_IS_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_UTILS_TYPE_FILE_INFO))
#define SYNAPSE_UTILS_IS_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_UTILS_TYPE_FILE_INFO))
#define SYNAPSE_UTILS_FILE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_UTILS_TYPE_FILE_INFO, SynapseUtilsFileInfoClass))

typedef struct _SynapseUtilsFileInfo SynapseUtilsFileInfo;
typedef struct _SynapseUtilsFileInfoClass SynapseUtilsFileInfoClass;
typedef struct _SynapseUtilsFileInfoPrivate SynapseUtilsFileInfoPrivate;

#define SYNAPSE_TYPE_VOLUME_SERVICE (synapse_volume_service_get_type ())
#define SYNAPSE_VOLUME_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_VOLUME_SERVICE, SynapseVolumeService))
#define SYNAPSE_VOLUME_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_VOLUME_SERVICE, SynapseVolumeServiceClass))
#define SYNAPSE_IS_VOLUME_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_VOLUME_SERVICE))
#define SYNAPSE_IS_VOLUME_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_VOLUME_SERVICE))
#define SYNAPSE_VOLUME_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_VOLUME_SERVICE, SynapseVolumeServiceClass))

typedef struct _SynapseVolumeService SynapseVolumeService;
typedef struct _SynapseVolumeServiceClass SynapseVolumeServiceClass;
typedef struct _SynapseVolumeServicePrivate SynapseVolumeServicePrivate;

#define SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT (synapse_volume_service_volume_object_get_type ())
#define SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, SynapseVolumeServiceVolumeObject))
#define SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, SynapseVolumeServiceVolumeObjectClass))
#define SYNAPSE_VOLUME_SERVICE_IS_VOLUME_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT))
#define SYNAPSE_VOLUME_SERVICE_IS_VOLUME_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT))
#define SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, SynapseVolumeServiceVolumeObjectClass))

typedef struct _SynapseVolumeServiceVolumeObject SynapseVolumeServiceVolumeObject;
typedef struct _SynapseVolumeServiceVolumeObjectClass SynapseVolumeServiceVolumeObjectClass;
typedef struct _SynapseVolumeServiceVolumeObjectPrivate SynapseVolumeServiceVolumeObjectPrivate;

struct _SynapseMatch {
	GObject parent_instance;
	SynapseMatchPrivate * priv;
};

struct _SynapseMatchClass {
	GObjectClass parent_class;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	void (*execute_with_target) (SynapseMatch* self, SynapseMatch* source, SynapseMatch* target);
	gboolean (*needs_target) (SynapseMatch* self);
	SynapseQueryFlags (*target_flags) (SynapseMatch* self);
};

struct _SynapseAction {
	SynapseMatch parent_instance;
	SynapseActionPrivate * priv;
};

struct _SynapseActionClass {
	SynapseMatchClass parent_class;
	gboolean (*valid_for_match) (SynapseAction* self, SynapseMatch* match);
	gint (*get_relevancy_for_match) (SynapseAction* self, SynapseMatch* match);
	void (*do_execute) (SynapseAction* self, SynapseMatch* source, SynapseMatch* target);
};

struct _SynapseActivatableIface {
	GTypeInterface parent_iface;
	void (*activate) (SynapseActivatable* self);
	void (*deactivate) (SynapseActivatable* self);
	gboolean (*get_enabled) (SynapseActivatable* self);
	void (*set_enabled) (SynapseActivatable* self, gboolean value);
};

struct _SynapseQuery {
	gchar* query_string;
	gchar* query_string_folded;
	GCancellable* cancellable;
	SynapseQueryFlags query_type;
	guint max_results;
	guint query_id;
};

struct _SynapseActionProviderIface {
	GTypeInterface parent_iface;
	SynapseResultSet* (*find_for_match) (SynapseActionProvider* self, SynapseQuery* query, SynapseMatch* match);
	gboolean (*handles_unknown) (SynapseActionProvider* self);
};

struct _SynapseCommonActions {
	GObject parent_instance;
	SynapseCommonActionsPrivate * priv;
};

struct _SynapseCommonActionsClass {
	GObjectClass parent_class;
};

struct _SynapseConfigObject {
	GObject parent_instance;
	SynapseConfigObjectPrivate * priv;
};

struct _SynapseConfigObjectClass {
	GObjectClass parent_class;
};

struct _SynapseConfigService {
	GObject parent_instance;
	SynapseConfigServicePrivate * priv;
};

struct _SynapseConfigServiceClass {
	GObjectClass parent_class;
};

typedef enum  {
	SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED,
	SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR
} SynapseSearchError;
#define SYNAPSE_SEARCH_ERROR synapse_search_error_quark ()
struct _SynapseSearchProviderIface {
	GTypeInterface parent_iface;
	void (*search) (SynapseSearchProvider* self, const gchar* query, SynapseQueryFlags flags, SynapseResultSet* dest_result_set, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeList* (*search_finish) (SynapseSearchProvider* self, GAsyncResult* _res_, GError** error);
};

struct _SynapseDataSink {
	GObject parent_instance;
	SynapseDataSinkPrivate * priv;
};

struct _SynapseDataSinkClass {
	GObjectClass parent_class;
};

struct _SynapseFreeDesktopDBusIface {
	GTypeInterface parent_iface;
	void (*list_queued_owners) (SynapseFreeDesktopDBus* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_queued_owners_finish) (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, gint* result_length1, GError** error);
	void (*list_names) (SynapseFreeDesktopDBus* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_names_finish) (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, gint* result_length1, GError** error);
	void (*list_activatable_names) (SynapseFreeDesktopDBus* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_activatable_names_finish) (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, gint* result_length1, GError** error);
	void (*name_has_owner) (SynapseFreeDesktopDBus* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*name_has_owner_finish) (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, GError** error);
	void (*start_service_by_name) (SynapseFreeDesktopDBus* self, const gchar* name, guint32 flags, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint32 (*start_service_by_name_finish) (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, GError** error);
	void (*get_name_owner) (SynapseFreeDesktopDBus* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*get_name_owner_finish) (SynapseFreeDesktopDBus* self, GAsyncResult* _res_, GError** error);
};

struct _SynapseDBusService {
	GObject parent_instance;
	SynapseDBusServicePrivate * priv;
};

struct _SynapseDBusServiceClass {
	GObjectClass parent_class;
};

struct _SynapseDesktopFileInfo {
	GObject parent_instance;
	SynapseDesktopFileInfoPrivate * priv;
	gchar** actions;
	gint actions_length1;
	gchar** mime_types;
	gint mime_types_length1;
};

struct _SynapseDesktopFileInfoClass {
	GObjectClass parent_class;
};

struct _SynapseDesktopFileService {
	GObject parent_instance;
	SynapseDesktopFileServicePrivate * priv;
};

struct _SynapseDesktopFileServiceClass {
	GObjectClass parent_class;
};

struct _SynapseActionMatch {
	SynapseMatch parent_instance;
	SynapseActionMatchPrivate * priv;
};

struct _SynapseActionMatchClass {
	SynapseMatchClass parent_class;
	void (*do_action) (SynapseActionMatch* self);
};

struct _SynapseApplicationMatch {
	SynapseMatch parent_instance;
	SynapseApplicationMatchPrivate * priv;
};

struct _SynapseApplicationMatchClass {
	SynapseMatchClass parent_class;
};

struct _SynapseUriMatch {
	SynapseMatch parent_instance;
	SynapseUriMatchPrivate * priv;
};

struct _SynapseUriMatchClass {
	SynapseMatchClass parent_class;
};

struct _SynapseContactMatch {
	SynapseMatch parent_instance;
	SynapseContactMatchPrivate * priv;
};

struct _SynapseContactMatchClass {
	SynapseMatchClass parent_class;
	void (*send_message) (SynapseContactMatch* self, const gchar* message, gboolean present);
	void (*open_chat) (SynapseContactMatch* self);
};

struct _SynapseExtendedInfoIface {
	GTypeInterface parent_iface;
	const gchar* (*get_extended_info) (SynapseExtendedInfo* self);
	void (*set_extended_info) (SynapseExtendedInfo* self, const gchar* value);
};

struct _SynapseTextMatch {
	SynapseMatch parent_instance;
	SynapseTextMatchPrivate * priv;
};

struct _SynapseTextMatchClass {
	SynapseMatchClass parent_class;
	gchar* (*get_text) (SynapseTextMatch* self);
};

struct _SynapseSearchMatch {
	SynapseMatch parent_instance;
	SynapseSearchMatchPrivate * priv;
};

struct _SynapseSearchMatchClass {
	SynapseMatchClass parent_class;
	void (*search) (SynapseSearchMatch* self, const gchar* query, SynapseQueryFlags flags, SynapseResultSet* dest_result_set, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeList* (*search_finish) (SynapseSearchMatch* self, GAsyncResult* _res_, GError** error);
};

struct _SynapseUnknownMatch {
	SynapseMatch parent_instance;
	SynapseUnknownMatchPrivate * priv;
};

struct _SynapseUnknownMatchClass {
	SynapseMatchClass parent_class;
};

struct _SynapseConfigurableIface {
	GTypeInterface parent_iface;
	GtkWidget* (*create_config_widget) (SynapseConfigurable* self);
};

struct _SynapseItemProviderIface {
	GTypeInterface parent_iface;
	void (*search) (SynapseItemProvider* self, SynapseQuery* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	SynapseResultSet* (*search_finish) (SynapseItemProvider* self, GAsyncResult* _res_, GError** error);
	gboolean (*handles_query) (SynapseItemProvider* self, SynapseQuery* query);
	gboolean (*handles_empty_query) (SynapseItemProvider* self);
};

struct _SynapsePluginInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapsePluginInfoPrivate * priv;
	GType plugin_type;
	gchar* title;
	gchar* description;
	gchar* icon_name;
	SynapsePluginRegisterFunc register_func;
	gboolean runnable;
	gchar* runnable_error;
};

struct _SynapsePluginInfoClass {
	GTypeClass parent_class;
	void (*finalize) (SynapsePluginInfo *self);
};

struct _SynapsePluginRegistry {
	GObject parent_instance;
	SynapsePluginRegistryPrivate * priv;
};

struct _SynapsePluginRegistryClass {
	GObjectClass parent_class;
};

struct _SynapseRelevancyBackendIface {
	GTypeInterface parent_iface;
	gfloat (*get_application_popularity) (SynapseRelevancyBackend* self, const gchar* desktop_id);
	gfloat (*get_uri_popularity) (SynapseRelevancyBackend* self, const gchar* uri);
	void (*application_launched) (SynapseRelevancyBackend* self, GAppInfo* app_info);
};

struct _SynapseRelevancyService {
	GObject parent_instance;
	SynapseRelevancyServicePrivate * priv;
};

struct _SynapseRelevancyServiceClass {
	GObjectClass parent_class;
};

struct _SynapseResultSet {
	GObject parent_instance;
	SynapseResultSetPrivate * priv;
};

struct _SynapseResultSetClass {
	GObjectClass parent_class;
};

struct _SynapseUtilsLogger {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseUtilsLoggerPrivate * priv;
};

struct _SynapseUtilsLoggerClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseUtilsLogger *self);
};

struct _SynapseUtilsAsyncOnce {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseUtilsAsyncOncePrivate * priv;
};

struct _SynapseUtilsAsyncOnceClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseUtilsAsyncOnce *self);
};

struct _SynapseUtilsFileInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseUtilsFileInfoPrivate * priv;
	gchar* uri;
	gchar* parse_name;
	SynapseQueryFlags file_type;
	SynapseUriMatch* match_obj;
};

struct _SynapseUtilsFileInfoClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseUtilsFileInfo *self);
};

struct _SynapseVolumeService {
	GObject parent_instance;
	SynapseVolumeServicePrivate * priv;
};

struct _SynapseVolumeServiceClass {
	GObjectClass parent_class;
};

struct _SynapseVolumeServiceVolumeObject {
	SynapseUriMatch parent_instance;
	SynapseVolumeServiceVolumeObjectPrivate * priv;
};

struct _SynapseVolumeServiceVolumeObjectClass {
	SynapseUriMatchClass parent_class;
};

GType synapse_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseMatch, g_object_unref)
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
GType synapse_action_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseAction, g_object_unref)
gboolean synapse_action_valid_for_match (SynapseAction* self,
                                         SynapseMatch* match);
gint synapse_action_get_relevancy_for_match (SynapseAction* self,
                                             SynapseMatch* match);
void synapse_action_do_execute (SynapseAction* self,
                                SynapseMatch* source,
                                SynapseMatch* target);
SynapseAction* synapse_action_construct (GType object_type);
gint synapse_action_get_default_relevancy (SynapseAction* self);
void synapse_action_set_default_relevancy (SynapseAction* self,
                                           gint value);
gboolean synapse_action_get_notify_match (SynapseAction* self);
void synapse_action_set_notify_match (SynapseAction* self,
                                      gboolean value);
GType synapse_activatable_get_type (void) G_GNUC_CONST;
GType synapse_query_get_type (void) G_GNUC_CONST;
SynapseQuery* synapse_query_dup (const SynapseQuery* self);
void synapse_query_free (SynapseQuery* self);
void synapse_query_copy (const SynapseQuery* self,
                         SynapseQuery* dest);
void synapse_query_destroy (SynapseQuery* self);
GType synapse_result_set_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseResultSet, g_object_unref)
GType synapse_action_provider_get_type (void) G_GNUC_CONST;
GType synapse_common_actions_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseCommonActions, g_object_unref)
SynapseCommonActions* synapse_common_actions_new (void);
SynapseCommonActions* synapse_common_actions_construct (GType object_type);
GType synapse_config_object_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseConfigObject, g_object_unref)
SynapseConfigObject* synapse_config_object_construct (GType object_type);
GType synapse_config_service_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseConfigService, g_object_unref)
SynapseConfigService* synapse_config_service_get_default (void);
SynapseConfigObject* synapse_config_service_get_config (SynapseConfigService* self,
                                                        const gchar* group,
                                                        const gchar* key,
                                                        GType config_type);
SynapseConfigObject* synapse_config_service_bind_config (SynapseConfigService* self,
                                                         const gchar* group,
                                                         const gchar* key,
                                                         GType config_type);
void synapse_config_service_set_config (SynapseConfigService* self,
                                        const gchar* group,
                                        const gchar* key,
                                        SynapseConfigObject* cfg_obj);
void synapse_config_service_save (SynapseConfigService* self);
GQuark synapse_search_error_quark (void);
GType synapse_search_provider_get_type (void) G_GNUC_CONST;
void synapse_search_provider_search (SynapseSearchProvider* self,
                                     const gchar* query,
                                     SynapseQueryFlags flags,
                                     SynapseResultSet* dest_result_set,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
GeeList* synapse_search_provider_search_finish (SynapseSearchProvider* self,
                                                GAsyncResult* _res_,
                                                GError** error);
GType synapse_data_sink_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDataSink, g_object_unref)
SynapseDataSink* synapse_data_sink_new (void);
SynapseDataSink* synapse_data_sink_construct (GType object_type);
void synapse_data_sink_register_plugin (SynapseDataSink* self,
                                        GObject* plugin);
void synapse_data_sink_register_static_plugin (SynapseDataSink* self,
                                               GType plugin_type);
GObject* synapse_data_sink_get_plugin (SynapseDataSink* self,
                                       const gchar* name);
gboolean synapse_data_sink_is_plugin_enabled (SynapseDataSink* self,
                                              GType plugin_type);
void synapse_data_sink_set_plugin_enabled (SynapseDataSink* self,
                                           GType plugin_type,
                                           gboolean enabled);
GeeList* synapse_data_sink_find_actions_for_unknown_match (SynapseDataSink* self,
                                                           SynapseMatch* match,
                                                           SynapseQueryFlags flags);
GeeList* synapse_data_sink_find_actions_for_match (SynapseDataSink* self,
                                                   SynapseMatch* match,
                                                   const gchar* query,
                                                   SynapseQueryFlags flags);
gboolean synapse_data_sink_get_has_empty_handlers (SynapseDataSink* self);
void synapse_data_sink_set_has_empty_handlers (SynapseDataSink* self,
                                               gboolean value);
gboolean synapse_data_sink_get_has_unknown_handlers (SynapseDataSink* self);
void synapse_data_sink_set_has_unknown_handlers (SynapseDataSink* self,
                                                 gboolean value);
GType synapse_free_desktop_dbus_proxy_get_type (void) G_GNUC_CONST;
guint synapse_free_desktop_dbus_register_object (void* object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error);
GType synapse_free_desktop_dbus_get_type (void) G_GNUC_CONST;
#define SYNAPSE_FREE_DESKTOP_DBUS_UNIQUE_NAME "org.freedesktop.DBus"
#define SYNAPSE_FREE_DESKTOP_DBUS_OBJECT_PATH "/org/freedesktop/DBus"
void synapse_free_desktop_dbus_list_queued_owners (SynapseFreeDesktopDBus* self,
                                                   const gchar* name,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
gchar** synapse_free_desktop_dbus_list_queued_owners_finish (SynapseFreeDesktopDBus* self,
                                                             GAsyncResult* _res_,
                                                             gint* result_length1,
                                                             GError** error);
void synapse_free_desktop_dbus_list_names (SynapseFreeDesktopDBus* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
gchar** synapse_free_desktop_dbus_list_names_finish (SynapseFreeDesktopDBus* self,
                                                     GAsyncResult* _res_,
                                                     gint* result_length1,
                                                     GError** error);
void synapse_free_desktop_dbus_list_activatable_names (SynapseFreeDesktopDBus* self,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
gchar** synapse_free_desktop_dbus_list_activatable_names_finish (SynapseFreeDesktopDBus* self,
                                                                 GAsyncResult* _res_,
                                                                 gint* result_length1,
                                                                 GError** error);
void synapse_free_desktop_dbus_name_has_owner (SynapseFreeDesktopDBus* self,
                                               const gchar* name,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
gboolean synapse_free_desktop_dbus_name_has_owner_finish (SynapseFreeDesktopDBus* self,
                                                          GAsyncResult* _res_,
                                                          GError** error);
void synapse_free_desktop_dbus_start_service_by_name (SynapseFreeDesktopDBus* self,
                                                      const gchar* name,
                                                      guint32 flags,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
guint32 synapse_free_desktop_dbus_start_service_by_name_finish (SynapseFreeDesktopDBus* self,
                                                                GAsyncResult* _res_,
                                                                GError** error);
void synapse_free_desktop_dbus_get_name_owner (SynapseFreeDesktopDBus* self,
                                               const gchar* name,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
gchar* synapse_free_desktop_dbus_get_name_owner_finish (SynapseFreeDesktopDBus* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
GType synapse_dbus_service_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDBusService, g_object_unref)
SynapseDBusService* synapse_dbus_service_get_default (void);
gboolean synapse_dbus_service_name_has_owner (SynapseDBusService* self,
                                              const gchar* name);
gboolean synapse_dbus_service_name_is_activatable (SynapseDBusService* self,
                                                   const gchar* name);
gboolean synapse_dbus_service_service_is_available (SynapseDBusService* self,
                                                    const gchar* name);
void synapse_dbus_service_initialize (SynapseDBusService* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
void synapse_dbus_service_initialize_finish (SynapseDBusService* self,
                                             GAsyncResult* _res_);
GType synapse_desktop_environment_type_get_type (void) G_GNUC_CONST;
SynapseDesktopEnvironmentType synapse_desktop_environment_type_from_strings (gchar** environments,
                                                                             gint environments_length1);
GType synapse_desktop_file_info_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDesktopFileInfo, g_object_unref)
const gchar* synapse_desktop_file_info_get_name_folded (SynapseDesktopFileInfo* self);
SynapseDesktopFileInfo* synapse_desktop_file_info_new_for_keyfile (const gchar* path,
                                                                   GKeyFile* keyfile,
                                                                   const gchar* desktop_id);
SynapseDesktopFileInfo* synapse_desktop_file_info_construct_for_keyfile (GType object_type,
                                                                         const gchar* path,
                                                                         GKeyFile* keyfile,
                                                                         const gchar* desktop_id);
SynapseDesktopFileInfo* synapse_desktop_file_info_new (void);
SynapseDesktopFileInfo* synapse_desktop_file_info_construct (GType object_type);
const gchar* synapse_desktop_file_info_get_desktop_id (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_desktop_id (SynapseDesktopFileInfo* self,
                                               const gchar* value);
const gchar* synapse_desktop_file_info_get_name (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_name (SynapseDesktopFileInfo* self,
                                         const gchar* value);
const gchar* synapse_desktop_file_info_get_comment (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_comment (SynapseDesktopFileInfo* self,
                                            const gchar* value);
const gchar* synapse_desktop_file_info_get_icon_name (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_icon_name (SynapseDesktopFileInfo* self,
                                              const gchar* value);
gboolean synapse_desktop_file_info_get_needs_terminal (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_needs_terminal (SynapseDesktopFileInfo* self,
                                                   gboolean value);
const gchar* synapse_desktop_file_info_get_filename (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_filename (SynapseDesktopFileInfo* self,
                                             const gchar* value);
const gchar* synapse_desktop_file_info_get_exec (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_exec (SynapseDesktopFileInfo* self,
                                         const gchar* value);
gboolean synapse_desktop_file_info_get_is_hidden (SynapseDesktopFileInfo* self);
gboolean synapse_desktop_file_info_get_is_valid (SynapseDesktopFileInfo* self);
SynapseDesktopEnvironmentType synapse_desktop_file_info_get_show_in (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_show_in (SynapseDesktopFileInfo* self,
                                            SynapseDesktopEnvironmentType value);
GType synapse_desktop_file_service_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDesktopFileService, g_object_unref)
SynapseDesktopFileService* synapse_desktop_file_service_get_default (void);
void synapse_desktop_file_service_initialize (SynapseDesktopFileService* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
void synapse_desktop_file_service_initialize_finish (SynapseDesktopFileService* self,
                                                     GAsyncResult* _res_);
SynapseDesktopEnvironmentType synapse_desktop_file_service_get_environment (SynapseDesktopFileService* self);
GeeList* synapse_desktop_file_service_get_desktop_files (SynapseDesktopFileService* self);
GeeList* synapse_desktop_file_service_get_all_desktop_files (SynapseDesktopFileService* self);
GeeList* synapse_desktop_file_service_get_desktop_files_for_type (SynapseDesktopFileService* self,
                                                                  const gchar* mime_type);
GeeList* synapse_desktop_file_service_get_desktop_files_for_exec (SynapseDesktopFileService* self,
                                                                  const gchar* exec);
SynapseDesktopFileInfo* synapse_desktop_file_service_get_desktop_file_for_id (SynapseDesktopFileService* self,
                                                                              const gchar* desktop_id);
GType synapse_match_score_get_type (void) G_GNUC_CONST;
void synapse_match_execute (SynapseMatch* self,
                            SynapseMatch* match);
void synapse_match_execute_with_target (SynapseMatch* self,
                                        SynapseMatch* source,
                                        SynapseMatch* target);
gboolean synapse_match_needs_target (SynapseMatch* self);
SynapseQueryFlags synapse_match_target_flags (SynapseMatch* self);
SynapseMatch* synapse_match_construct (GType object_type);
const gchar* synapse_match_get_title (SynapseMatch* self);
void synapse_match_set_title (SynapseMatch* self,
                              const gchar* value);
const gchar* synapse_match_get_description (SynapseMatch* self);
void synapse_match_set_description (SynapseMatch* self,
                                    const gchar* value);
const gchar* synapse_match_get_icon_name (SynapseMatch* self);
void synapse_match_set_icon_name (SynapseMatch* self,
                                  const gchar* value);
gboolean synapse_match_get_has_thumbnail (SynapseMatch* self);
void synapse_match_set_has_thumbnail (SynapseMatch* self,
                                      gboolean value);
const gchar* synapse_match_get_thumbnail_path (SynapseMatch* self);
void synapse_match_set_thumbnail_path (SynapseMatch* self,
                                       const gchar* value);
GType synapse_action_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseActionMatch, g_object_unref)
void synapse_action_match_do_action (SynapseActionMatch* self);
SynapseActionMatch* synapse_action_match_construct (GType object_type);
GType synapse_application_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseApplicationMatch, g_object_unref)
SynapseApplicationMatch* synapse_application_match_new (void);
SynapseApplicationMatch* synapse_application_match_construct (GType object_type);
GAppInfo* synapse_application_match_get_app_info (SynapseApplicationMatch* self);
void synapse_application_match_set_app_info (SynapseApplicationMatch* self,
                                             GAppInfo* value);
gboolean synapse_application_match_get_needs_terminal (SynapseApplicationMatch* self);
void synapse_application_match_set_needs_terminal (SynapseApplicationMatch* self,
                                                   gboolean value);
const gchar* synapse_application_match_get_filename (SynapseApplicationMatch* self);
void synapse_application_match_set_filename (SynapseApplicationMatch* self,
                                             const gchar* value);
GType synapse_uri_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseUriMatch, g_object_unref)
SynapseUriMatch* synapse_uri_match_new (void);
SynapseUriMatch* synapse_uri_match_construct (GType object_type);
const gchar* synapse_uri_match_get_uri (SynapseUriMatch* self);
void synapse_uri_match_set_uri (SynapseUriMatch* self,
                                const gchar* value);
SynapseQueryFlags synapse_uri_match_get_file_type (SynapseUriMatch* self);
void synapse_uri_match_set_file_type (SynapseUriMatch* self,
                                      SynapseQueryFlags value);
const gchar* synapse_uri_match_get_mime_type (SynapseUriMatch* self);
void synapse_uri_match_set_mime_type (SynapseUriMatch* self,
                                      const gchar* value);
GType synapse_contact_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseContactMatch, g_object_unref)
void synapse_contact_match_send_message (SynapseContactMatch* self,
                                         const gchar* message,
                                         gboolean present);
void synapse_contact_match_open_chat (SynapseContactMatch* self);
SynapseContactMatch* synapse_contact_match_construct (GType object_type);
GType synapse_extended_info_get_type (void) G_GNUC_CONST;
const gchar* synapse_extended_info_get_extended_info (SynapseExtendedInfo* self);
void synapse_extended_info_set_extended_info (SynapseExtendedInfo* self,
                                              const gchar* value);
GType synapse_text_origin_get_type (void) G_GNUC_CONST;
GType synapse_text_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseTextMatch, g_object_unref)
gchar* synapse_text_match_get_text (SynapseTextMatch* self);
SynapseTextMatch* synapse_text_match_construct (GType object_type);
SynapseTextOrigin synapse_text_match_get_text_origin (SynapseTextMatch* self);
GType synapse_search_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseSearchMatch, g_object_unref)
void synapse_search_match_search (SynapseSearchMatch* self,
                                  const gchar* query,
                                  SynapseQueryFlags flags,
                                  SynapseResultSet* dest_result_set,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
GeeList* synapse_search_match_search_finish (SynapseSearchMatch* self,
                                             GAsyncResult* _res_,
                                             GError** error);
SynapseSearchMatch* synapse_search_match_construct (GType object_type);
SynapseMatch* synapse_search_match_get_search_source (SynapseSearchMatch* self);
void synapse_search_match_set_search_source (SynapseSearchMatch* self,
                                             SynapseMatch* value);
GType synapse_unknown_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseUnknownMatch, g_object_unref)
SynapseUnknownMatch* synapse_unknown_match_new (const gchar* query_string);
SynapseUnknownMatch* synapse_unknown_match_construct (GType object_type,
                                                      const gchar* query_string);
void synapse_activatable_activate (SynapseActivatable* self);
void synapse_activatable_deactivate (SynapseActivatable* self);
gboolean synapse_activatable_get_enabled (SynapseActivatable* self);
void synapse_activatable_set_enabled (SynapseActivatable* self,
                                      gboolean value);
GType synapse_configurable_get_type (void) G_GNUC_CONST;
GtkWidget* synapse_configurable_create_config_widget (SynapseConfigurable* self);
GType synapse_item_provider_get_type (void) G_GNUC_CONST;
void synapse_item_provider_search (SynapseItemProvider* self,
                                   SynapseQuery* query,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
SynapseResultSet* synapse_item_provider_search_finish (SynapseItemProvider* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
gboolean synapse_item_provider_handles_query (SynapseItemProvider* self,
                                              SynapseQuery* query);
gboolean synapse_item_provider_handles_empty_query (SynapseItemProvider* self);
SynapseResultSet* synapse_action_provider_find_for_match (SynapseActionProvider* self,
                                                          SynapseQuery* query,
                                                          SynapseMatch* match);
gboolean synapse_action_provider_handles_unknown (SynapseActionProvider* self);
gpointer synapse_plugin_info_ref (gpointer instance);
void synapse_plugin_info_unref (gpointer instance);
GParamSpec* synapse_param_spec_plugin_info (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
void synapse_value_set_plugin_info (GValue* value,
                                    gpointer v_object);
void synapse_value_take_plugin_info (GValue* value,
                                     gpointer v_object);
gpointer synapse_value_get_plugin_info (const GValue* value);
GType synapse_plugin_info_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapsePluginInfo, synapse_plugin_info_unref)
SynapsePluginInfo* synapse_plugin_info_new (GType type,
                                            const gchar* title,
                                            const gchar* desc,
                                            const gchar* icon_name,
                                            SynapsePluginRegisterFunc reg_func,
                                            gboolean runnable,
                                            const gchar* runnable_error);
SynapsePluginInfo* synapse_plugin_info_construct (GType object_type,
                                                  GType type,
                                                  const gchar* title,
                                                  const gchar* desc,
                                                  const gchar* icon_name,
                                                  SynapsePluginRegisterFunc reg_func,
                                                  gboolean runnable,
                                                  const gchar* runnable_error);
GType synapse_plugin_registry_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapsePluginRegistry, g_object_unref)
extern SynapsePluginRegistry* synapse_plugin_registry_instance;
SynapsePluginRegistry* synapse_plugin_registry_get_default (void);
void synapse_plugin_registry_register_plugin (SynapsePluginRegistry* self,
                                              GType plugin_type,
                                              const gchar* title,
                                              const gchar* description,
                                              const gchar* icon_name,
                                              SynapsePluginRegisterFunc reg_func,
                                              gboolean runnable,
                                              const gchar* runnable_error);
GeeList* synapse_plugin_registry_get_plugins (SynapsePluginRegistry* self);
SynapsePluginInfo* synapse_plugin_registry_get_plugin_info_for_type (SynapsePluginRegistry* self,
                                                                     GType plugin_type);
SynapsePluginRegistry* synapse_plugin_registry_new (void);
SynapsePluginRegistry* synapse_plugin_registry_construct (GType object_type);
GType synapse_matcher_flags_get_type (void) G_GNUC_CONST;
void synapse_query_init (SynapseQuery *self,
                         guint query_id,
                         const gchar* query,
                         SynapseQueryFlags flags,
                         guint num_results);
gboolean synapse_query_is_cancelled (SynapseQuery *self);
void synapse_query_check_cancellable (SynapseQuery *self,
                                      GError** error);
GeeList* synapse_query_get_matchers_for_query (const gchar* query,
                                               SynapseMatcherFlags match_flags,
                                               GRegexCompileFlags flags);
GType synapse_relevancy_backend_get_type (void) G_GNUC_CONST;
gfloat synapse_relevancy_backend_get_application_popularity (SynapseRelevancyBackend* self,
                                                             const gchar* desktop_id);
gfloat synapse_relevancy_backend_get_uri_popularity (SynapseRelevancyBackend* self,
                                                     const gchar* uri);
void synapse_relevancy_backend_application_launched (SynapseRelevancyBackend* self,
                                                     GAppInfo* app_info);
GType synapse_relevancy_service_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseRelevancyService, g_object_unref)
SynapseRelevancyService* synapse_relevancy_service_get_default (void);
gfloat synapse_relevancy_service_get_application_popularity (SynapseRelevancyService* self,
                                                             const gchar* desktop_id);
gfloat synapse_relevancy_service_get_uri_popularity (SynapseRelevancyService* self,
                                                     const gchar* uri);
void synapse_relevancy_service_application_launched (SynapseRelevancyService* self,
                                                     GAppInfo* app_info);
gint synapse_relevancy_service_compute_relevancy (gint base_relevancy,
                                                  gfloat modifier);
SynapseResultSet* synapse_result_set_new (void);
SynapseResultSet* synapse_result_set_construct (GType object_type);
void synapse_result_set_add (SynapseResultSet* self,
                             SynapseMatch* match,
                             gint relevancy);
void synapse_result_set_add_all (SynapseResultSet* self,
                                 SynapseResultSet* rs);
gboolean synapse_result_set_contains_uri (SynapseResultSet* self,
                                          const gchar* uri);
GeeList* synapse_result_set_get_sorted_list (SynapseResultSet* self);
gint synapse_result_set_get_size (SynapseResultSet* self);
GeeSet* synapse_result_set_get_keys (SynapseResultSet* self);
GeeSet* synapse_result_set_get_entries (SynapseResultSet* self);
gchar* synapse_utils_remove_accents (const gchar* input);
gchar* synapse_utils_remove_last_unichar (const gchar* input);
gchar* synapse_utils_remove_last_word (const gchar* input);
void synapse_utils_query_exists_async (GFile* f,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
gboolean synapse_utils_query_exists_finish (GAsyncResult* _res_);
void synapse_utils_open_uri (const gchar* uri);
void synapse_utils_open_command_line (const gchar* command,
                                      const gchar* app_name,
                                      gboolean needs_terminal);
gchar* synapse_utils_extract_type_name (GType obj_type);
gpointer synapse_utils_logger_ref (gpointer instance);
void synapse_utils_logger_unref (gpointer instance);
GParamSpec* synapse_utils_param_spec_logger (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
void synapse_utils_value_set_logger (GValue* value,
                                     gpointer v_object);
void synapse_utils_value_take_logger (GValue* value,
                                      gpointer v_object);
gpointer synapse_utils_value_get_logger (const GValue* value);
GType synapse_utils_logger_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseUtilsLogger, synapse_utils_logger_unref)
GType synapse_utils_logger_log_level_get_type (void) G_GNUC_CONST;
void synapse_utils_logger_initialize (void);
SynapseUtilsLoggerLogLevel synapse_utils_logger_get_DisplayLevel (void);
void synapse_utils_logger_set_DisplayLevel (SynapseUtilsLoggerLogLevel value);
gpointer synapse_utils_async_once_ref (gpointer instance);
void synapse_utils_async_once_unref (gpointer instance);
GParamSpec* synapse_utils_param_spec_async_once (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags);
void synapse_utils_value_set_async_once (GValue* value,
                                         gpointer v_object);
void synapse_utils_value_take_async_once (GValue* value,
                                          gpointer v_object);
gpointer synapse_utils_value_get_async_once (const GValue* value);
GType synapse_utils_async_once_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseUtilsAsyncOnce, synapse_utils_async_once_unref)
SynapseUtilsAsyncOnce* synapse_utils_async_once_new (GType g_type,
                                                     GBoxedCopyFunc g_dup_func,
                                                     GDestroyNotify g_destroy_func);
SynapseUtilsAsyncOnce* synapse_utils_async_once_construct (GType object_type,
                                                           GType g_type,
                                                           GBoxedCopyFunc g_dup_func,
                                                           GDestroyNotify g_destroy_func);
gconstpointer synapse_utils_async_once_get_data (SynapseUtilsAsyncOnce* self);
gboolean synapse_utils_async_once_is_initialized (SynapseUtilsAsyncOnce* self);
void synapse_utils_async_once_enter (SynapseUtilsAsyncOnce* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
gboolean synapse_utils_async_once_enter_finish (SynapseUtilsAsyncOnce* self,
                                                GAsyncResult* _res_);
void synapse_utils_async_once_leave (SynapseUtilsAsyncOnce* self,
                                     gconstpointer _result_);
void synapse_utils_async_once_reset (SynapseUtilsAsyncOnce* self);
gpointer synapse_utils_file_info_ref (gpointer instance);
void synapse_utils_file_info_unref (gpointer instance);
GParamSpec* synapse_utils_param_spec_file_info (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
void synapse_utils_value_set_file_info (GValue* value,
                                        gpointer v_object);
void synapse_utils_value_take_file_info (GValue* value,
                                         gpointer v_object);
gpointer synapse_utils_value_get_file_info (const GValue* value);
GType synapse_utils_file_info_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseUtilsFileInfo, synapse_utils_file_info_unref)
SynapseUtilsFileInfo* synapse_utils_file_info_new (const gchar* uri,
                                                   GType obj_type);
SynapseUtilsFileInfo* synapse_utils_file_info_construct (GType object_type,
                                                         const gchar* uri,
                                                         GType obj_type);
gboolean synapse_utils_file_info_is_initialized (SynapseUtilsFileInfo* self);
void synapse_utils_file_info_initialize (SynapseUtilsFileInfo* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
void synapse_utils_file_info_initialize_finish (SynapseUtilsFileInfo* self,
                                                GAsyncResult* _res_);
void synapse_utils_file_info_exists (SynapseUtilsFileInfo* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
gboolean synapse_utils_file_info_exists_finish (SynapseUtilsFileInfo* self,
                                                GAsyncResult* _res_);
GType synapse_volume_service_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseVolumeService, g_object_unref)
SynapseVolumeService* synapse_volume_service_get_default (void);
void synapse_volume_service_initialize (SynapseVolumeService* self);
GType synapse_volume_service_volume_object_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseVolumeServiceVolumeObject, g_object_unref)
GeeCollection* synapse_volume_service_get_volumes (SynapseVolumeService* self);
gchar* synapse_volume_service_uri_to_volume_name (SynapseVolumeService* self,
                                                  const gchar* uri,
                                                  gchar* * volume_path);
void synapse_volume_service_volume_object_update_state (SynapseVolumeServiceVolumeObject* self);
gboolean synapse_volume_service_volume_object_is_mounted (SynapseVolumeServiceVolumeObject* self);
SynapseVolumeServiceVolumeObject* synapse_volume_service_volume_object_new (GVolume* volume);
SynapseVolumeServiceVolumeObject* synapse_volume_service_volume_object_construct (GType object_type,
                                                                                  GVolume* volume);
GVolume* synapse_volume_service_volume_object_get_volume (SynapseVolumeServiceVolumeObject* self);
void synapse_volume_service_volume_object_set_volume (SynapseVolumeServiceVolumeObject* self,
                                                      GVolume* value);

G_END_DECLS

#endif
