/* volume-service.c generated by valac 0.48.17, the Vala compiler
 * generated from volume-service.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define SYNAPSE_TYPE_VOLUME_SERVICE (synapse_volume_service_get_type ())
#define SYNAPSE_VOLUME_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_VOLUME_SERVICE, SynapseVolumeService))
#define SYNAPSE_VOLUME_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_VOLUME_SERVICE, SynapseVolumeServiceClass))
#define SYNAPSE_IS_VOLUME_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_VOLUME_SERVICE))
#define SYNAPSE_IS_VOLUME_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_VOLUME_SERVICE))
#define SYNAPSE_VOLUME_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_VOLUME_SERVICE, SynapseVolumeServiceClass))

typedef struct _SynapseVolumeService SynapseVolumeService;
typedef struct _SynapseVolumeServiceClass SynapseVolumeServiceClass;
typedef struct _SynapseVolumeServicePrivate SynapseVolumeServicePrivate;

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_MATCH, SynapseMatchClass))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_IS_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchClass))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchClass SynapseMatchClass;

#define SYNAPSE_TYPE_URI_MATCH (synapse_uri_match_get_type ())
#define SYNAPSE_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch))
#define SYNAPSE_URI_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchClass))
#define SYNAPSE_IS_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_IS_URI_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_URI_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchClass))

typedef struct _SynapseUriMatch SynapseUriMatch;
typedef struct _SynapseUriMatchClass SynapseUriMatchClass;

#define SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT (synapse_volume_service_volume_object_get_type ())
#define SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, SynapseVolumeServiceVolumeObject))
#define SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, SynapseVolumeServiceVolumeObjectClass))
#define SYNAPSE_VOLUME_SERVICE_IS_VOLUME_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT))
#define SYNAPSE_VOLUME_SERVICE_IS_VOLUME_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT))
#define SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, SynapseVolumeServiceVolumeObjectClass))

typedef struct _SynapseVolumeServiceVolumeObject SynapseVolumeServiceVolumeObject;
typedef struct _SynapseVolumeServiceVolumeObjectClass SynapseVolumeServiceVolumeObjectClass;
enum  {
	SYNAPSE_VOLUME_SERVICE_0_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_NUM_PROPERTIES
};
static GParamSpec* synapse_volume_service_properties[SYNAPSE_VOLUME_SERVICE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SynapseMatchPrivate SynapseMatchPrivate;
typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;

#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())
typedef struct _SynapseUriMatchPrivate SynapseUriMatchPrivate;
typedef struct _SynapseVolumeServiceVolumeObjectPrivate SynapseVolumeServiceVolumeObjectPrivate;
enum  {
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_0_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_VOLUME_PROPERTY,
	SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_NUM_PROPERTIES
};
static GParamSpec* synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_NUM_PROPERTIES];

struct _SynapseVolumeService {
	GObject parent_instance;
	SynapseVolumeServicePrivate * priv;
};

struct _SynapseVolumeServiceClass {
	GObjectClass parent_class;
};

struct _SynapseVolumeServicePrivate {
	GVolumeMonitor* vm;
	GeeMap* volumes;
};

struct _SynapseMatch {
	GObject parent_instance;
	SynapseMatchPrivate * priv;
};

struct _SynapseMatchClass {
	GObjectClass parent_class;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	void (*execute_with_target) (SynapseMatch* self, SynapseMatch* source, SynapseMatch* target);
	gboolean (*needs_target) (SynapseMatch* self);
	SynapseQueryFlags (*target_flags) (SynapseMatch* self);
};

struct _SynapseUriMatch {
	SynapseMatch parent_instance;
	SynapseUriMatchPrivate * priv;
};

struct _SynapseUriMatchClass {
	SynapseMatchClass parent_class;
};

struct _SynapseVolumeServiceVolumeObject {
	SynapseUriMatch parent_instance;
	SynapseVolumeServiceVolumeObjectPrivate * priv;
};

struct _SynapseVolumeServiceVolumeObjectClass {
	SynapseUriMatchClass parent_class;
};

struct _SynapseVolumeServiceVolumeObjectPrivate {
	gulong changed_signal_id;
	GVolume* _volume;
};

static gint SynapseVolumeService_private_offset;
static gpointer synapse_volume_service_parent_class = NULL;
static SynapseVolumeService* synapse_volume_service_instance;
static SynapseVolumeService* synapse_volume_service_instance = NULL;
static gint SynapseVolumeServiceVolumeObject_private_offset;
static gpointer synapse_volume_service_volume_object_parent_class = NULL;

GType synapse_volume_service_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseVolumeService, g_object_unref)
GType synapse_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseMatch, g_object_unref)
GType synapse_uri_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseUriMatch, g_object_unref)
GType synapse_volume_service_volume_object_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseVolumeServiceVolumeObject, g_object_unref)
SynapseVolumeService* synapse_volume_service_get_default (void);
static SynapseVolumeService* synapse_volume_service_new (void);
static SynapseVolumeService* synapse_volume_service_construct (GType object_type);
void synapse_volume_service_initialize (SynapseVolumeService* self);
static void __lambda10_ (SynapseVolumeService* self,
                  GVolume* volume);
SynapseVolumeServiceVolumeObject* synapse_volume_service_volume_object_new (GVolume* volume);
SynapseVolumeServiceVolumeObject* synapse_volume_service_volume_object_construct (GType object_type,
                                                                                  GVolume* volume);
static void ___lambda10__g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                 GVolume* volume,
                                                 gpointer self);
static void __lambda11_ (SynapseVolumeService* self,
                  GVolume* volume);
static void ___lambda11__g_volume_monitor_volume_removed (GVolumeMonitor* _sender,
                                                   GVolume* volume,
                                                   gpointer self);
static void __lambda12_ (SynapseVolumeService* self,
                  GMount* mount);
void synapse_volume_service_volume_object_update_state (SynapseVolumeServiceVolumeObject* self);
static void ___lambda12__g_volume_monitor_mount_added (GVolumeMonitor* _sender,
                                                GMount* mount,
                                                gpointer self);
static void synapse_volume_service_process_volume_list (SynapseVolumeService* self,
                                                 GList* volume_list);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
GeeCollection* synapse_volume_service_get_volumes (SynapseVolumeService* self);
gchar* synapse_volume_service_uri_to_volume_name (SynapseVolumeService* self,
                                                  const gchar* uri,
                                                  gchar* * volume_path);
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
void synapse_volume_service_volume_object_set_volume (SynapseVolumeServiceVolumeObject* self,
                                                      GVolume* value);
gboolean synapse_volume_service_volume_object_is_mounted (SynapseVolumeServiceVolumeObject* self);
GVolume* synapse_volume_service_volume_object_get_volume (SynapseVolumeServiceVolumeObject* self);
void synapse_match_set_title (SynapseMatch* self,
                              const gchar* value);
void synapse_match_set_description (SynapseMatch* self,
                                    const gchar* value);
void synapse_match_set_icon_name (SynapseMatch* self,
                                  const gchar* value);
void synapse_match_set_has_thumbnail (SynapseMatch* self,
                                      gboolean value);
void synapse_uri_match_set_uri (SynapseUriMatch* self,
                                const gchar* value);
void synapse_uri_match_set_file_type (SynapseUriMatch* self,
                                      SynapseQueryFlags value);
void synapse_uri_match_set_mime_type (SynapseUriMatch* self,
                                      const gchar* value);
static void _synapse_volume_service_volume_object_update_state_g_volume_changed (GVolume* _sender,
                                                                          gpointer self);
const gchar* synapse_match_get_title (SynapseMatch* self);
const gchar* synapse_match_get_icon_name (SynapseMatch* self);
const gchar* synapse_uri_match_get_uri (SynapseUriMatch* self);
static void synapse_volume_service_volume_object_finalize (GObject * obj);
static GType synapse_volume_service_volume_object_get_type_once (void);
static void _vala_synapse_volume_service_volume_object_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec);
static void _vala_synapse_volume_service_volume_object_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec);
static GObject * synapse_volume_service_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void synapse_volume_service_finalize (GObject * obj);
static GType synapse_volume_service_get_type_once (void);

static inline gpointer
synapse_volume_service_get_instance_private (SynapseVolumeService* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseVolumeService_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 29 "../../../src/core/volume-service.vala"
	return self ? g_object_ref (self) : NULL;
#line 255 "volume-service.c"
}

SynapseVolumeService*
synapse_volume_service_get_default (void)
{
	SynapseVolumeService* _tmp0_ = NULL;
	SynapseVolumeService* _tmp1_;
	SynapseVolumeService* _tmp2_;
	SynapseVolumeService* _tmp4_;
	SynapseVolumeService* result = NULL;
#line 29 "../../../src/core/volume-service.vala"
	_tmp1_ = synapse_volume_service_instance;
#line 29 "../../../src/core/volume-service.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 29 "../../../src/core/volume-service.vala"
	_tmp0_ = _tmp2_;
#line 29 "../../../src/core/volume-service.vala"
	if (_tmp0_ == NULL) {
#line 274 "volume-service.c"
		SynapseVolumeService* _tmp3_;
#line 29 "../../../src/core/volume-service.vala"
		_tmp3_ = synapse_volume_service_new ();
#line 29 "../../../src/core/volume-service.vala"
		_g_object_unref0 (_tmp0_);
#line 29 "../../../src/core/volume-service.vala"
		_tmp0_ = _tmp3_;
#line 282 "volume-service.c"
	}
#line 29 "../../../src/core/volume-service.vala"
	_tmp4_ = _tmp0_;
#line 29 "../../../src/core/volume-service.vala"
	_tmp0_ = NULL;
#line 29 "../../../src/core/volume-service.vala"
	result = _tmp4_;
#line 29 "../../../src/core/volume-service.vala"
	_g_object_unref0 (_tmp0_);
#line 29 "../../../src/core/volume-service.vala"
	return result;
#line 294 "volume-service.c"
}

static SynapseVolumeService*
synapse_volume_service_construct (GType object_type)
{
	SynapseVolumeService * self = NULL;
#line 32 "../../../src/core/volume-service.vala"
	self = (SynapseVolumeService*) g_object_new (object_type, NULL);
#line 32 "../../../src/core/volume-service.vala"
	return self;
#line 305 "volume-service.c"
}

static SynapseVolumeService*
synapse_volume_service_new (void)
{
#line 32 "../../../src/core/volume-service.vala"
	return synapse_volume_service_construct (SYNAPSE_TYPE_VOLUME_SERVICE);
#line 313 "volume-service.c"
}

static void
__lambda10_ (SynapseVolumeService* self,
             GVolume* volume)
{
	GeeMap* _tmp0_;
	SynapseVolumeServiceVolumeObject* _tmp1_;
	SynapseVolumeServiceVolumeObject* _tmp2_;
#line 56 "../../../src/core/volume-service.vala"
	g_return_if_fail (volume != NULL);
#line 57 "../../../src/core/volume-service.vala"
	_tmp0_ = self->priv->volumes;
#line 57 "../../../src/core/volume-service.vala"
	_tmp1_ = synapse_volume_service_volume_object_new (volume);
#line 57 "../../../src/core/volume-service.vala"
	_tmp2_ = _tmp1_;
#line 57 "../../../src/core/volume-service.vala"
	gee_map_set (_tmp0_, volume, _tmp2_);
#line 57 "../../../src/core/volume-service.vala"
	_g_object_unref0 (_tmp2_);
#line 335 "volume-service.c"
}

static void
___lambda10__g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                            GVolume* volume,
                                            gpointer self)
{
#line 56 "../../../src/core/volume-service.vala"
	__lambda10_ ((SynapseVolumeService*) self, volume);
#line 345 "volume-service.c"
}

static void
__lambda11_ (SynapseVolumeService* self,
             GVolume* volume)
{
	GeeMap* _tmp0_;
#line 59 "../../../src/core/volume-service.vala"
	g_return_if_fail (volume != NULL);
#line 60 "../../../src/core/volume-service.vala"
	_tmp0_ = self->priv->volumes;
#line 60 "../../../src/core/volume-service.vala"
	gee_map_unset (_tmp0_, volume, NULL);
#line 359 "volume-service.c"
}

static void
___lambda11__g_volume_monitor_volume_removed (GVolumeMonitor* _sender,
                                              GVolume* volume,
                                              gpointer self)
{
#line 59 "../../../src/core/volume-service.vala"
	__lambda11_ ((SynapseVolumeService*) self, volume);
#line 369 "volume-service.c"
}

static void
__lambda12_ (SynapseVolumeService* self,
             GMount* mount)
{
	GVolume* volume = NULL;
	GVolume* _tmp0_;
	GVolume* _tmp1_;
	GeeMap* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	GVolume* _tmp6_;
	gboolean _tmp7_;
#line 62 "../../../src/core/volume-service.vala"
	g_return_if_fail (mount != NULL);
#line 63 "../../../src/core/volume-service.vala"
	_tmp0_ = g_mount_get_volume (mount);
#line 63 "../../../src/core/volume-service.vala"
	volume = _tmp0_;
#line 64 "../../../src/core/volume-service.vala"
	_tmp1_ = volume;
#line 64 "../../../src/core/volume-service.vala"
	if (_tmp1_ == NULL) {
#line 64 "../../../src/core/volume-service.vala"
		_g_object_unref0 (volume);
#line 64 "../../../src/core/volume-service.vala"
		return;
#line 399 "volume-service.c"
	}
#line 66 "../../../src/core/volume-service.vala"
	_tmp2_ = self->priv->volumes;
#line 66 "../../../src/core/volume-service.vala"
	_tmp3_ = gee_map_get_keys (_tmp2_);
#line 66 "../../../src/core/volume-service.vala"
	_tmp4_ = _tmp3_;
#line 66 "../../../src/core/volume-service.vala"
	_tmp5_ = _tmp4_;
#line 66 "../../../src/core/volume-service.vala"
	_tmp6_ = volume;
#line 66 "../../../src/core/volume-service.vala"
	_tmp7_ = gee_collection_contains ((GeeCollection*) _tmp5_, _tmp6_);
#line 66 "../../../src/core/volume-service.vala"
	_g_object_unref0 (_tmp5_);
#line 66 "../../../src/core/volume-service.vala"
	if (_tmp7_) {
#line 417 "volume-service.c"
		GeeMap* _tmp8_;
		GVolume* _tmp9_;
		gpointer _tmp10_;
		SynapseVolumeServiceVolumeObject* _tmp11_;
#line 66 "../../../src/core/volume-service.vala"
		_tmp8_ = self->priv->volumes;
#line 66 "../../../src/core/volume-service.vala"
		_tmp9_ = volume;
#line 66 "../../../src/core/volume-service.vala"
		_tmp10_ = gee_map_get (_tmp8_, _tmp9_);
#line 66 "../../../src/core/volume-service.vala"
		_tmp11_ = (SynapseVolumeServiceVolumeObject*) _tmp10_;
#line 66 "../../../src/core/volume-service.vala"
		synapse_volume_service_volume_object_update_state (_tmp11_);
#line 66 "../../../src/core/volume-service.vala"
		_g_object_unref0 (_tmp11_);
#line 434 "volume-service.c"
	}
#line 62 "../../../src/core/volume-service.vala"
	_g_object_unref0 (volume);
#line 438 "volume-service.c"
}

static void
___lambda12__g_volume_monitor_mount_added (GVolumeMonitor* _sender,
                                           GMount* mount,
                                           gpointer self)
{
#line 62 "../../../src/core/volume-service.vala"
	__lambda12_ ((SynapseVolumeService*) self, mount);
#line 448 "volume-service.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 52 "../../../src/core/volume-service.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 456 "volume-service.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 52 "../../../src/core/volume-service.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 464 "volume-service.c"
}

void
synapse_volume_service_initialize (SynapseVolumeService* self)
{
	GVolumeMonitor* _tmp0_;
	GVolumeMonitor* _tmp1_;
	GVolumeMonitor* _tmp2_;
	GVolumeMonitor* _tmp3_;
	GList* volume_list = NULL;
	GVolumeMonitor* _tmp4_;
	GList* _tmp5_;
#line 52 "../../../src/core/volume-service.vala"
	g_return_if_fail (self != NULL);
#line 54 "../../../src/core/volume-service.vala"
	_tmp0_ = g_volume_monitor_get ();
#line 54 "../../../src/core/volume-service.vala"
	_g_object_unref0 (self->priv->vm);
#line 54 "../../../src/core/volume-service.vala"
	self->priv->vm = _tmp0_;
#line 56 "../../../src/core/volume-service.vala"
	_tmp1_ = self->priv->vm;
#line 56 "../../../src/core/volume-service.vala"
	g_signal_connect_object (_tmp1_, "volume-added", (GCallback) ___lambda10__g_volume_monitor_volume_added, self, 0);
#line 59 "../../../src/core/volume-service.vala"
	_tmp2_ = self->priv->vm;
#line 59 "../../../src/core/volume-service.vala"
	g_signal_connect_object (_tmp2_, "volume-removed", (GCallback) ___lambda11__g_volume_monitor_volume_removed, self, 0);
#line 62 "../../../src/core/volume-service.vala"
	_tmp3_ = self->priv->vm;
#line 62 "../../../src/core/volume-service.vala"
	g_signal_connect_object (_tmp3_, "mount-added", (GCallback) ___lambda12__g_volume_monitor_mount_added, self, 0);
#line 70 "../../../src/core/volume-service.vala"
	_tmp4_ = self->priv->vm;
#line 70 "../../../src/core/volume-service.vala"
	_tmp5_ = g_volume_monitor_get_volumes (_tmp4_);
#line 70 "../../../src/core/volume-service.vala"
	volume_list = _tmp5_;
#line 71 "../../../src/core/volume-service.vala"
	synapse_volume_service_process_volume_list (self, volume_list);
#line 52 "../../../src/core/volume-service.vala"
	(volume_list == NULL) ? NULL : (volume_list = (_g_list_free__g_object_unref0_ (volume_list), NULL));
#line 507 "volume-service.c"
}

static void
synapse_volume_service_process_volume_list (SynapseVolumeService* self,
                                            GList* volume_list)
{
#line 74 "../../../src/core/volume-service.vala"
	g_return_if_fail (self != NULL);
#line 516 "volume-service.c"
	{
		GList* volume_collection = NULL;
		GList* volume_it = NULL;
#line 76 "../../../src/core/volume-service.vala"
		volume_collection = volume_list;
#line 76 "../../../src/core/volume-service.vala"
		for (volume_it = volume_collection; volume_it != NULL; volume_it = volume_it->next) {
#line 524 "volume-service.c"
			GVolume* volume = NULL;
#line 76 "../../../src/core/volume-service.vala"
			volume = (GVolume*) volume_it->data;
#line 528 "volume-service.c"
			{
				GeeMap* _tmp0_;
				GVolume* _tmp1_;
				GVolume* _tmp2_;
				SynapseVolumeServiceVolumeObject* _tmp3_;
				SynapseVolumeServiceVolumeObject* _tmp4_;
#line 78 "../../../src/core/volume-service.vala"
				_tmp0_ = self->priv->volumes;
#line 78 "../../../src/core/volume-service.vala"
				_tmp1_ = volume;
#line 78 "../../../src/core/volume-service.vala"
				_tmp2_ = volume;
#line 78 "../../../src/core/volume-service.vala"
				_tmp3_ = synapse_volume_service_volume_object_new (_tmp2_);
#line 78 "../../../src/core/volume-service.vala"
				_tmp4_ = _tmp3_;
#line 78 "../../../src/core/volume-service.vala"
				gee_map_set (_tmp0_, _tmp1_, _tmp4_);
#line 78 "../../../src/core/volume-service.vala"
				_g_object_unref0 (_tmp4_);
#line 549 "volume-service.c"
			}
		}
	}
}

GeeCollection*
synapse_volume_service_get_volumes (SynapseVolumeService* self)
{
	GeeMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* result = NULL;
#line 82 "../../../src/core/volume-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 84 "../../../src/core/volume-service.vala"
	_tmp0_ = self->priv->volumes;
#line 84 "../../../src/core/volume-service.vala"
	_tmp1_ = gee_map_get_values (_tmp0_);
#line 84 "../../../src/core/volume-service.vala"
	_tmp2_ = _tmp1_;
#line 84 "../../../src/core/volume-service.vala"
	result = _tmp2_;
#line 84 "../../../src/core/volume-service.vala"
	return result;
#line 574 "volume-service.c"
}

gchar*
synapse_volume_service_uri_to_volume_name (SynapseVolumeService* self,
                                           const gchar* uri,
                                           gchar* * volume_path)
{
	gchar* _vala_volume_path = NULL;
	GeeSet* g_volumes = NULL;
	GeeMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GFile* f = NULL;
	GFile* _tmp3_;
	gchar* result = NULL;
#line 87 "../../../src/core/volume-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 87 "../../../src/core/volume-service.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 89 "../../../src/core/volume-service.vala"
	_g_free0 (_vala_volume_path);
#line 89 "../../../src/core/volume-service.vala"
	_vala_volume_path = NULL;
#line 90 "../../../src/core/volume-service.vala"
	_tmp0_ = self->priv->volumes;
#line 90 "../../../src/core/volume-service.vala"
	_tmp1_ = gee_map_get_keys (_tmp0_);
#line 90 "../../../src/core/volume-service.vala"
	_tmp2_ = _tmp1_;
#line 90 "../../../src/core/volume-service.vala"
	g_volumes = _tmp2_;
#line 92 "../../../src/core/volume-service.vala"
	_tmp3_ = g_file_new_for_uri (uri);
#line 92 "../../../src/core/volume-service.vala"
	f = _tmp3_;
#line 610 "volume-service.c"
	{
		GeeIterator* _volume_it = NULL;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_;
#line 94 "../../../src/core/volume-service.vala"
		_tmp4_ = g_volumes;
#line 94 "../../../src/core/volume-service.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 94 "../../../src/core/volume-service.vala"
		_volume_it = _tmp5_;
#line 94 "../../../src/core/volume-service.vala"
		while (TRUE) {
#line 623 "volume-service.c"
			GeeIterator* _tmp6_;
			GVolume* volume = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GFile* root = NULL;
			GVolume* _tmp9_;
			GFile* _tmp10_;
			GFile* _tmp11_;
			GFile* _tmp17_;
			GFile* _tmp18_;
#line 94 "../../../src/core/volume-service.vala"
			_tmp6_ = _volume_it;
#line 94 "../../../src/core/volume-service.vala"
			if (!gee_iterator_next (_tmp6_)) {
#line 94 "../../../src/core/volume-service.vala"
				break;
#line 640 "volume-service.c"
			}
#line 94 "../../../src/core/volume-service.vala"
			_tmp7_ = _volume_it;
#line 94 "../../../src/core/volume-service.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 94 "../../../src/core/volume-service.vala"
			volume = (GVolume*) _tmp8_;
#line 96 "../../../src/core/volume-service.vala"
			_tmp9_ = volume;
#line 96 "../../../src/core/volume-service.vala"
			_tmp10_ = g_volume_get_activation_root (_tmp9_);
#line 96 "../../../src/core/volume-service.vala"
			root = _tmp10_;
#line 97 "../../../src/core/volume-service.vala"
			_tmp11_ = root;
#line 97 "../../../src/core/volume-service.vala"
			if (_tmp11_ == NULL) {
#line 658 "volume-service.c"
				GMount* mount = NULL;
				GVolume* _tmp12_;
				GMount* _tmp13_;
				GMount* _tmp14_;
				GMount* _tmp15_;
				GFile* _tmp16_;
#line 99 "../../../src/core/volume-service.vala"
				_tmp12_ = volume;
#line 99 "../../../src/core/volume-service.vala"
				_tmp13_ = g_volume_get_mount (_tmp12_);
#line 99 "../../../src/core/volume-service.vala"
				mount = _tmp13_;
#line 100 "../../../src/core/volume-service.vala"
				_tmp14_ = mount;
#line 100 "../../../src/core/volume-service.vala"
				if (_tmp14_ == NULL) {
#line 100 "../../../src/core/volume-service.vala"
					_g_object_unref0 (mount);
#line 100 "../../../src/core/volume-service.vala"
					_g_object_unref0 (root);
#line 100 "../../../src/core/volume-service.vala"
					_g_object_unref0 (volume);
#line 100 "../../../src/core/volume-service.vala"
					continue;
#line 683 "volume-service.c"
				}
#line 101 "../../../src/core/volume-service.vala"
				_tmp15_ = mount;
#line 101 "../../../src/core/volume-service.vala"
				_tmp16_ = g_mount_get_root (_tmp15_);
#line 101 "../../../src/core/volume-service.vala"
				_g_object_unref0 (root);
#line 101 "../../../src/core/volume-service.vala"
				root = _tmp16_;
#line 97 "../../../src/core/volume-service.vala"
				_g_object_unref0 (mount);
#line 695 "volume-service.c"
			}
#line 104 "../../../src/core/volume-service.vala"
			_tmp17_ = f;
#line 104 "../../../src/core/volume-service.vala"
			_tmp18_ = root;
#line 104 "../../../src/core/volume-service.vala"
			if (g_file_has_prefix (_tmp17_, _tmp18_)) {
#line 703 "volume-service.c"
				GFile* _tmp19_;
				gchar* _tmp20_;
				GVolume* _tmp21_;
				gchar* _tmp22_;
#line 106 "../../../src/core/volume-service.vala"
				_tmp19_ = root;
#line 106 "../../../src/core/volume-service.vala"
				_tmp20_ = g_file_get_path (_tmp19_);
#line 106 "../../../src/core/volume-service.vala"
				_g_free0 (_vala_volume_path);
#line 106 "../../../src/core/volume-service.vala"
				_vala_volume_path = _tmp20_;
#line 107 "../../../src/core/volume-service.vala"
				_tmp21_ = volume;
#line 107 "../../../src/core/volume-service.vala"
				_tmp22_ = g_volume_get_name (_tmp21_);
#line 107 "../../../src/core/volume-service.vala"
				result = _tmp22_;
#line 107 "../../../src/core/volume-service.vala"
				_g_object_unref0 (root);
#line 107 "../../../src/core/volume-service.vala"
				_g_object_unref0 (volume);
#line 107 "../../../src/core/volume-service.vala"
				_g_object_unref0 (_volume_it);
#line 107 "../../../src/core/volume-service.vala"
				_g_object_unref0 (f);
#line 107 "../../../src/core/volume-service.vala"
				_g_object_unref0 (g_volumes);
#line 107 "../../../src/core/volume-service.vala"
				if (volume_path) {
#line 107 "../../../src/core/volume-service.vala"
					*volume_path = _vala_volume_path;
#line 736 "volume-service.c"
				} else {
#line 107 "../../../src/core/volume-service.vala"
					_g_free0 (_vala_volume_path);
#line 740 "volume-service.c"
				}
#line 107 "../../../src/core/volume-service.vala"
				return result;
#line 744 "volume-service.c"
			}
#line 94 "../../../src/core/volume-service.vala"
			_g_object_unref0 (root);
#line 94 "../../../src/core/volume-service.vala"
			_g_object_unref0 (volume);
#line 750 "volume-service.c"
		}
#line 94 "../../../src/core/volume-service.vala"
		_g_object_unref0 (_volume_it);
#line 754 "volume-service.c"
	}
#line 111 "../../../src/core/volume-service.vala"
	result = NULL;
#line 111 "../../../src/core/volume-service.vala"
	_g_object_unref0 (f);
#line 111 "../../../src/core/volume-service.vala"
	_g_object_unref0 (g_volumes);
#line 111 "../../../src/core/volume-service.vala"
	if (volume_path) {
#line 111 "../../../src/core/volume-service.vala"
		*volume_path = _vala_volume_path;
#line 766 "volume-service.c"
	} else {
#line 111 "../../../src/core/volume-service.vala"
		_g_free0 (_vala_volume_path);
#line 770 "volume-service.c"
	}
#line 111 "../../../src/core/volume-service.vala"
	return result;
#line 774 "volume-service.c"
}

static inline gpointer
synapse_volume_service_volume_object_get_instance_private (SynapseVolumeServiceVolumeObject* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseVolumeServiceVolumeObject_private_offset);
}

void
synapse_volume_service_volume_object_update_state (SynapseVolumeServiceVolumeObject* self)
{
	GVolume* _tmp0_;
#line 154 "../../../src/core/volume-service.vala"
	g_return_if_fail (self != NULL);
#line 156 "../../../src/core/volume-service.vala"
	_tmp0_ = self->priv->_volume;
#line 156 "../../../src/core/volume-service.vala"
	synapse_volume_service_volume_object_set_volume (self, _tmp0_);
#line 793 "volume-service.c"
}

gboolean
synapse_volume_service_volume_object_is_mounted (SynapseVolumeServiceVolumeObject* self)
{
	GVolume* _tmp0_;
	GMount* _tmp1_;
	GMount* _tmp2_;
	gboolean _tmp3_;
	gboolean result = FALSE;
#line 159 "../../../src/core/volume-service.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 161 "../../../src/core/volume-service.vala"
	_tmp0_ = self->priv->_volume;
#line 161 "../../../src/core/volume-service.vala"
	_tmp1_ = g_volume_get_mount (_tmp0_);
#line 161 "../../../src/core/volume-service.vala"
	_tmp2_ = _tmp1_;
#line 161 "../../../src/core/volume-service.vala"
	_tmp3_ = _tmp2_ != NULL;
#line 161 "../../../src/core/volume-service.vala"
	_g_object_unref0 (_tmp2_);
#line 161 "../../../src/core/volume-service.vala"
	result = _tmp3_;
#line 161 "../../../src/core/volume-service.vala"
	return result;
#line 820 "volume-service.c"
}

SynapseVolumeServiceVolumeObject*
synapse_volume_service_volume_object_construct (GType object_type,
                                                GVolume* volume)
{
	SynapseVolumeServiceVolumeObject * self = NULL;
#line 164 "../../../src/core/volume-service.vala"
	g_return_val_if_fail (volume != NULL, NULL);
#line 166 "../../../src/core/volume-service.vala"
	self = (SynapseVolumeServiceVolumeObject*) g_object_new (object_type, "volume", volume, NULL);
#line 164 "../../../src/core/volume-service.vala"
	return self;
#line 834 "volume-service.c"
}

SynapseVolumeServiceVolumeObject*
synapse_volume_service_volume_object_new (GVolume* volume)
{
#line 164 "../../../src/core/volume-service.vala"
	return synapse_volume_service_volume_object_construct (SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, volume);
#line 842 "volume-service.c"
}

GVolume*
synapse_volume_service_volume_object_get_volume (SynapseVolumeServiceVolumeObject* self)
{
	GVolume* result;
	GVolume* _tmp0_;
#line 121 "../../../src/core/volume-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 121 "../../../src/core/volume-service.vala"
	_tmp0_ = self->priv->_volume;
#line 121 "../../../src/core/volume-service.vala"
	result = _tmp0_;
#line 121 "../../../src/core/volume-service.vala"
	return result;
#line 858 "volume-service.c"
}

static void
_synapse_volume_service_volume_object_update_state_g_volume_changed (GVolume* _sender,
                                                                     gpointer self)
{
#line 147 "../../../src/core/volume-service.vala"
	synapse_volume_service_volume_object_update_state ((SynapseVolumeServiceVolumeObject*) self);
#line 867 "volume-service.c"
}

void
synapse_volume_service_volume_object_set_volume (SynapseVolumeServiceVolumeObject* self,
                                                 GVolume* value)
{
	GVolume* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GIcon* _tmp3_;
	GIcon* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GMount* _tmp7_;
	GMount* _tmp8_;
	gboolean _tmp9_;
	gint _tmp18_ = 0;
	GMount* _tmp19_;
	GMount* _tmp20_;
	gboolean _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
#line 122 "../../../src/core/volume-service.vala"
	g_return_if_fail (self != NULL);
#line 124 "../../../src/core/volume-service.vala"
	_tmp0_ = _g_object_ref0 (value);
#line 124 "../../../src/core/volume-service.vala"
	_g_object_unref0 (self->priv->_volume);
#line 124 "../../../src/core/volume-service.vala"
	self->priv->_volume = _tmp0_;
#line 125 "../../../src/core/volume-service.vala"
	_tmp1_ = g_volume_get_name (value);
#line 125 "../../../src/core/volume-service.vala"
	_tmp2_ = _tmp1_;
#line 125 "../../../src/core/volume-service.vala"
	synapse_match_set_title ((SynapseMatch*) self, _tmp2_);
#line 125 "../../../src/core/volume-service.vala"
	_g_free0 (_tmp2_);
#line 126 "../../../src/core/volume-service.vala"
	synapse_match_set_description ((SynapseMatch*) self, "");
#line 127 "../../../src/core/volume-service.vala"
	_tmp3_ = g_volume_get_icon (value);
#line 127 "../../../src/core/volume-service.vala"
	_tmp4_ = _tmp3_;
#line 127 "../../../src/core/volume-service.vala"
	_tmp5_ = g_icon_to_string (_tmp4_);
#line 127 "../../../src/core/volume-service.vala"
	_tmp6_ = _tmp5_;
#line 127 "../../../src/core/volume-service.vala"
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp6_);
#line 127 "../../../src/core/volume-service.vala"
	_g_free0 (_tmp6_);
#line 127 "../../../src/core/volume-service.vala"
	_g_object_unref0 (_tmp4_);
#line 128 "../../../src/core/volume-service.vala"
	synapse_match_set_has_thumbnail ((SynapseMatch*) self, FALSE);
#line 134 "../../../src/core/volume-service.vala"
	_tmp7_ = g_volume_get_mount (value);
#line 134 "../../../src/core/volume-service.vala"
	_tmp8_ = _tmp7_;
#line 134 "../../../src/core/volume-service.vala"
	_tmp9_ = _tmp8_ != NULL;
#line 134 "../../../src/core/volume-service.vala"
	_g_object_unref0 (_tmp8_);
#line 134 "../../../src/core/volume-service.vala"
	if (_tmp9_) {
#line 938 "volume-service.c"
		GMount* _tmp10_;
		GMount* _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
#line 136 "../../../src/core/volume-service.vala"
		_tmp10_ = g_volume_get_mount (value);
#line 136 "../../../src/core/volume-service.vala"
		_tmp11_ = _tmp10_;
#line 136 "../../../src/core/volume-service.vala"
		_tmp12_ = g_mount_get_root (_tmp11_);
#line 136 "../../../src/core/volume-service.vala"
		_tmp13_ = _tmp12_;
#line 136 "../../../src/core/volume-service.vala"
		_tmp14_ = g_file_get_uri (_tmp13_);
#line 136 "../../../src/core/volume-service.vala"
		_tmp15_ = _tmp14_;
#line 136 "../../../src/core/volume-service.vala"
		synapse_uri_match_set_uri ((SynapseUriMatch*) self, _tmp15_);
#line 136 "../../../src/core/volume-service.vala"
		_g_free0 (_tmp15_);
#line 136 "../../../src/core/volume-service.vala"
		_g_object_unref0 (_tmp13_);
#line 136 "../../../src/core/volume-service.vala"
		_g_object_unref0 (_tmp11_);
#line 137 "../../../src/core/volume-service.vala"
		synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_PLACES);
#line 138 "../../../src/core/volume-service.vala"
		synapse_uri_match_set_mime_type ((SynapseUriMatch*) self, "");
#line 969 "volume-service.c"
	} else {
#line 142 "../../../src/core/volume-service.vala"
		synapse_uri_match_set_uri ((SynapseUriMatch*) self, NULL);
#line 973 "volume-service.c"
	}
#line 145 "../../../src/core/volume-service.vala"
	if (self->priv->changed_signal_id == ((gulong) 0)) {
#line 977 "volume-service.c"
		GVolume* _tmp16_;
		gulong _tmp17_;
#line 147 "../../../src/core/volume-service.vala"
		_tmp16_ = self->priv->_volume;
#line 147 "../../../src/core/volume-service.vala"
		_tmp17_ = g_signal_connect_object (_tmp16_, "changed", (GCallback) _synapse_volume_service_volume_object_update_state_g_volume_changed, self, 0);
#line 147 "../../../src/core/volume-service.vala"
		self->priv->changed_signal_id = _tmp17_;
#line 986 "volume-service.c"
	}
#line 150 "../../../src/core/volume-service.vala"
	_tmp19_ = g_volume_get_mount (value);
#line 150 "../../../src/core/volume-service.vala"
	_tmp20_ = _tmp19_;
#line 150 "../../../src/core/volume-service.vala"
	_tmp21_ = _tmp20_ != NULL;
#line 150 "../../../src/core/volume-service.vala"
	_g_object_unref0 (_tmp20_);
#line 150 "../../../src/core/volume-service.vala"
	if (_tmp21_) {
#line 150 "../../../src/core/volume-service.vala"
		_tmp18_ = 1;
#line 1000 "volume-service.c"
	} else {
#line 150 "../../../src/core/volume-service.vala"
		_tmp18_ = 0;
#line 1004 "volume-service.c"
	}
#line 150 "../../../src/core/volume-service.vala"
	_tmp22_ = synapse_match_get_title ((SynapseMatch*) self);
#line 150 "../../../src/core/volume-service.vala"
	_tmp23_ = _tmp22_;
#line 150 "../../../src/core/volume-service.vala"
	_tmp24_ = synapse_match_get_icon_name ((SynapseMatch*) self);
#line 150 "../../../src/core/volume-service.vala"
	_tmp25_ = _tmp24_;
#line 150 "../../../src/core/volume-service.vala"
	_tmp26_ = synapse_uri_match_get_uri ((SynapseUriMatch*) self);
#line 150 "../../../src/core/volume-service.vala"
	_tmp27_ = _tmp26_;
#line 150 "../../../src/core/volume-service.vala"
	g_debug ("volume-service.vala:150: vo[%p]: %s [%s], has_mount: %d, uri: %s", self, _tmp23_, _tmp25_, _tmp18_, _tmp27_);
#line 122 "../../../src/core/volume-service.vala"
	g_object_notify_by_pspec ((GObject *) self, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_VOLUME_PROPERTY]);
#line 1022 "volume-service.c"
}

static void
synapse_volume_service_volume_object_class_init (SynapseVolumeServiceVolumeObjectClass * klass,
                                                 gpointer klass_data)
{
#line 114 "../../../src/core/volume-service.vala"
	synapse_volume_service_volume_object_parent_class = g_type_class_peek_parent (klass);
#line 114 "../../../src/core/volume-service.vala"
	g_type_class_adjust_private_offset (klass, &SynapseVolumeServiceVolumeObject_private_offset);
#line 114 "../../../src/core/volume-service.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_volume_service_volume_object_get_property;
#line 114 "../../../src/core/volume-service.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_volume_service_volume_object_set_property;
#line 114 "../../../src/core/volume-service.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_volume_service_volume_object_finalize;
#line 114 "../../../src/core/volume-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_VOLUME_PROPERTY, synapse_volume_service_volume_object_properties[SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_VOLUME_PROPERTY] = g_param_spec_object ("volume", "volume", "volume", g_volume_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1041 "volume-service.c"
}

static void
synapse_volume_service_volume_object_instance_init (SynapseVolumeServiceVolumeObject * self,
                                                    gpointer klass)
{
#line 114 "../../../src/core/volume-service.vala"
	self->priv = synapse_volume_service_volume_object_get_instance_private (self);
#line 1050 "volume-service.c"
}

static void
synapse_volume_service_volume_object_finalize (GObject * obj)
{
	SynapseVolumeServiceVolumeObject * self;
#line 114 "../../../src/core/volume-service.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, SynapseVolumeServiceVolumeObject);
#line 171 "../../../src/core/volume-service.vala"
	if (self->priv->changed_signal_id != ((gulong) 0)) {
#line 175 "../../../src/core/volume-service.vala"
		self->priv->changed_signal_id = (gulong) 0;
#line 1063 "volume-service.c"
	}
#line 118 "../../../src/core/volume-service.vala"
	_g_object_unref0 (self->priv->_volume);
#line 114 "../../../src/core/volume-service.vala"
	G_OBJECT_CLASS (synapse_volume_service_volume_object_parent_class)->finalize (obj);
#line 1069 "volume-service.c"
}

static GType
synapse_volume_service_volume_object_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseVolumeServiceVolumeObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_volume_service_volume_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseVolumeServiceVolumeObject), 0, (GInstanceInitFunc) synapse_volume_service_volume_object_instance_init, NULL };
	GType synapse_volume_service_volume_object_type_id;
	synapse_volume_service_volume_object_type_id = g_type_register_static (SYNAPSE_TYPE_URI_MATCH, "SynapseVolumeServiceVolumeObject", &g_define_type_info, 0);
	SynapseVolumeServiceVolumeObject_private_offset = g_type_add_instance_private (synapse_volume_service_volume_object_type_id, sizeof (SynapseVolumeServiceVolumeObjectPrivate));
	return synapse_volume_service_volume_object_type_id;
}

GType
synapse_volume_service_volume_object_get_type (void)
{
	static volatile gsize synapse_volume_service_volume_object_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_volume_service_volume_object_type_id__volatile)) {
		GType synapse_volume_service_volume_object_type_id;
		synapse_volume_service_volume_object_type_id = synapse_volume_service_volume_object_get_type_once ();
		g_once_init_leave (&synapse_volume_service_volume_object_type_id__volatile, synapse_volume_service_volume_object_type_id);
	}
	return synapse_volume_service_volume_object_type_id__volatile;
}

static void
_vala_synapse_volume_service_volume_object_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec)
{
	SynapseVolumeServiceVolumeObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, SynapseVolumeServiceVolumeObject);
#line 114 "../../../src/core/volume-service.vala"
	switch (property_id) {
#line 114 "../../../src/core/volume-service.vala"
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_VOLUME_PROPERTY:
#line 114 "../../../src/core/volume-service.vala"
		g_value_set_object (value, synapse_volume_service_volume_object_get_volume (self));
#line 114 "../../../src/core/volume-service.vala"
		break;
#line 1110 "volume-service.c"
		default:
#line 114 "../../../src/core/volume-service.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 114 "../../../src/core/volume-service.vala"
		break;
#line 1116 "volume-service.c"
	}
}

static void
_vala_synapse_volume_service_volume_object_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec)
{
	SynapseVolumeServiceVolumeObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, SynapseVolumeServiceVolumeObject);
#line 114 "../../../src/core/volume-service.vala"
	switch (property_id) {
#line 114 "../../../src/core/volume-service.vala"
		case SYNAPSE_VOLUME_SERVICE_VOLUME_OBJECT_VOLUME_PROPERTY:
#line 114 "../../../src/core/volume-service.vala"
		synapse_volume_service_volume_object_set_volume (self, g_value_get_object (value));
#line 114 "../../../src/core/volume-service.vala"
		break;
#line 1136 "volume-service.c"
		default:
#line 114 "../../../src/core/volume-service.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 114 "../../../src/core/volume-service.vala"
		break;
#line 1142 "volume-service.c"
	}
}

static GObject *
synapse_volume_service_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseVolumeService * self;
	GeeHashMap* _tmp0_;
#line 44 "../../../src/core/volume-service.vala"
	parent_class = G_OBJECT_CLASS (synapse_volume_service_parent_class);
#line 44 "../../../src/core/volume-service.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 44 "../../../src/core/volume-service.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_VOLUME_SERVICE, SynapseVolumeService);
#line 46 "../../../src/core/volume-service.vala"
	synapse_volume_service_instance = self;
#line 48 "../../../src/core/volume-service.vala"
	_tmp0_ = gee_hash_map_new (g_volume_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, SYNAPSE_VOLUME_SERVICE_TYPE_VOLUME_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 48 "../../../src/core/volume-service.vala"
	_g_object_unref0 (self->priv->volumes);
#line 48 "../../../src/core/volume-service.vala"
	self->priv->volumes = (GeeMap*) _tmp0_;
#line 49 "../../../src/core/volume-service.vala"
	synapse_volume_service_initialize (self);
#line 44 "../../../src/core/volume-service.vala"
	return obj;
#line 1173 "volume-service.c"
}

static void
synapse_volume_service_class_init (SynapseVolumeServiceClass * klass,
                                   gpointer klass_data)
{
#line 23 "../../../src/core/volume-service.vala"
	synapse_volume_service_parent_class = g_type_class_peek_parent (klass);
#line 23 "../../../src/core/volume-service.vala"
	g_type_class_adjust_private_offset (klass, &SynapseVolumeService_private_offset);
#line 23 "../../../src/core/volume-service.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_volume_service_constructor;
#line 23 "../../../src/core/volume-service.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_volume_service_finalize;
#line 1188 "volume-service.c"
}

static void
synapse_volume_service_instance_init (SynapseVolumeService * self,
                                      gpointer klass)
{
#line 23 "../../../src/core/volume-service.vala"
	self->priv = synapse_volume_service_get_instance_private (self);
#line 1197 "volume-service.c"
}

static void
synapse_volume_service_finalize (GObject * obj)
{
	SynapseVolumeService * self;
#line 23 "../../../src/core/volume-service.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_VOLUME_SERVICE, SynapseVolumeService);
#line 38 "../../../src/core/volume-service.vala"
	synapse_volume_service_instance = NULL;
#line 41 "../../../src/core/volume-service.vala"
	_g_object_unref0 (self->priv->vm);
#line 42 "../../../src/core/volume-service.vala"
	_g_object_unref0 (self->priv->volumes);
#line 23 "../../../src/core/volume-service.vala"
	G_OBJECT_CLASS (synapse_volume_service_parent_class)->finalize (obj);
#line 1214 "volume-service.c"
}

static GType
synapse_volume_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseVolumeServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_volume_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseVolumeService), 0, (GInstanceInitFunc) synapse_volume_service_instance_init, NULL };
	GType synapse_volume_service_type_id;
	synapse_volume_service_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseVolumeService", &g_define_type_info, 0);
	SynapseVolumeService_private_offset = g_type_add_instance_private (synapse_volume_service_type_id, sizeof (SynapseVolumeServicePrivate));
	return synapse_volume_service_type_id;
}

GType
synapse_volume_service_get_type (void)
{
	static volatile gsize synapse_volume_service_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_volume_service_type_id__volatile)) {
		GType synapse_volume_service_type_id;
		synapse_volume_service_type_id = synapse_volume_service_get_type_once ();
		g_once_init_leave (&synapse_volume_service_type_id__volatile, synapse_volume_service_type_id);
	}
	return synapse_volume_service_type_id__volatile;
}

