/* chromium-plugin.c generated by valac 0.48.17, the Vala compiler
 * generated from chromium-plugin.vala, do not modify */

/*
 * Copyright (C) 2013 Jan Hrdina <jan.hrdka@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <synapse-core.h>
#include <glib.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <json-glib/json-glib.h>

#define SYNAPSE_TYPE_CHROMIUM_PLUGIN (synapse_chromium_plugin_get_type ())
#define SYNAPSE_CHROMIUM_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_CHROMIUM_PLUGIN, SynapseChromiumPlugin))
#define SYNAPSE_CHROMIUM_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_CHROMIUM_PLUGIN, SynapseChromiumPluginClass))
#define SYNAPSE_IS_CHROMIUM_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_CHROMIUM_PLUGIN))
#define SYNAPSE_IS_CHROMIUM_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_CHROMIUM_PLUGIN))
#define SYNAPSE_CHROMIUM_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_CHROMIUM_PLUGIN, SynapseChromiumPluginClass))

typedef struct _SynapseChromiumPlugin SynapseChromiumPlugin;
typedef struct _SynapseChromiumPluginClass SynapseChromiumPluginClass;
typedef struct _SynapseChromiumPluginPrivate SynapseChromiumPluginPrivate;

#define SYNAPSE_CHROMIUM_PLUGIN_TYPE_BOOKMARK_MATCH (synapse_chromium_plugin_bookmark_match_get_type ())
#define SYNAPSE_CHROMIUM_PLUGIN_BOOKMARK_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_CHROMIUM_PLUGIN_TYPE_BOOKMARK_MATCH, SynapseChromiumPluginBookmarkMatch))
#define SYNAPSE_CHROMIUM_PLUGIN_BOOKMARK_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_CHROMIUM_PLUGIN_TYPE_BOOKMARK_MATCH, SynapseChromiumPluginBookmarkMatchClass))
#define SYNAPSE_CHROMIUM_PLUGIN_IS_BOOKMARK_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_CHROMIUM_PLUGIN_TYPE_BOOKMARK_MATCH))
#define SYNAPSE_CHROMIUM_PLUGIN_IS_BOOKMARK_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_CHROMIUM_PLUGIN_TYPE_BOOKMARK_MATCH))
#define SYNAPSE_CHROMIUM_PLUGIN_BOOKMARK_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_CHROMIUM_PLUGIN_TYPE_BOOKMARK_MATCH, SynapseChromiumPluginBookmarkMatchClass))

typedef struct _SynapseChromiumPluginBookmarkMatch SynapseChromiumPluginBookmarkMatch;
typedef struct _SynapseChromiumPluginBookmarkMatchClass SynapseChromiumPluginBookmarkMatchClass;
enum  {
	SYNAPSE_CHROMIUM_PLUGIN_0_PROPERTY,
	SYNAPSE_CHROMIUM_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_CHROMIUM_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_chromium_plugin_properties[SYNAPSE_CHROMIUM_PLUGIN_NUM_PROPERTIES];
#define _synapse_utils_async_once_unref0(var) ((var == NULL) ? NULL : (var = (synapse_utils_async_once_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SynapseChromiumPluginSearchData SynapseChromiumPluginSearchData;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseChromiumPluginParseBookmarksData SynapseChromiumPluginParseBookmarksData;
typedef struct _SynapseChromiumPluginBookmarkMatchPrivate SynapseChromiumPluginBookmarkMatchPrivate;
enum  {
	SYNAPSE_CHROMIUM_PLUGIN_BOOKMARK_MATCH_0_PROPERTY,
	SYNAPSE_CHROMIUM_PLUGIN_BOOKMARK_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_chromium_plugin_bookmark_match_properties[SYNAPSE_CHROMIUM_PLUGIN_BOOKMARK_MATCH_NUM_PROPERTIES];

struct _SynapseChromiumPlugin {
	GObject parent_instance;
	SynapseChromiumPluginPrivate * priv;
};

struct _SynapseChromiumPluginClass {
	GObjectClass parent_class;
};

struct _SynapseChromiumPluginPrivate {
	gboolean _enabled;
	SynapseUtilsAsyncOnce* bookmarks_once;
};

struct _SynapseChromiumPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseChromiumPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	SynapseResultSet* _result_;
	SynapseResultSet* _tmp0_;
	SynapseUtilsAsyncOnce* _tmp1_;
	SynapseQuery _tmp2_;
	const gchar* _tmp3_;
	SynapseMatcherFlags flags;
	SynapseQuery _tmp4_;
	SynapseResultSet* _tmp5_;
	SynapseMatcherFlags _tmp6_;
	SynapseQuery _tmp7_;
	SynapseResultSet* _tmp8_;
	GError* _inner_error0_;
};

struct _SynapseChromiumPluginParseBookmarksData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseChromiumPlugin* self;
	gboolean is_locked;
	SynapseUtilsAsyncOnce* _tmp0_;
	GeeArrayList* bookmarks;
	GeeArrayList* _tmp1_;
	JsonParser* parser;
	JsonParser* _tmp2_;
	gchar* fpath;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* CONTAINER;
	gchar* _tmp5_;
	GeeHashSet* UNWANTED_SCHEME;
	GeeHashSet* _tmp6_;
	GeeHashSet* _tmp7_;
	GeeHashSet* _tmp8_;
	GeeHashSet* _tmp9_;
	GList* folders;
	GFile* f;
	const gchar* _tmp10_;
	GFile* _tmp11_;
	GFileInputStream* input_stream;
	GFile* _tmp12_;
	GFileInputStream* _tmp13_;
	JsonParser* _tmp14_;
	GFileInputStream* _tmp15_;
	JsonObject* root_object;
	JsonParser* _tmp16_;
	JsonNode* _tmp17_;
	JsonObject* _tmp18_;
	JsonObject* _tmp19_;
	JsonObject* _tmp20_;
	JsonNode* _tmp21_;
	JsonObject* _tmp22_;
	JsonNode* _tmp23_;
	JsonObject* _tmp24_;
	JsonArray* _tmp25_;
	GList* _tmp26_;
	JsonObject* _tmp27_;
	JsonNode* _tmp28_;
	JsonObject* _tmp29_;
	JsonNode* _tmp30_;
	JsonObject* _tmp31_;
	JsonArray* _tmp32_;
	GList* _tmp33_;
	JsonObject* o;
	GList* _tmp34_;
	GList* item_collection;
	GList* item_it;
	JsonNode* item;
	JsonNode* _tmp35_;
	JsonObject* _tmp36_;
	JsonObject* _tmp37_;
	gboolean _tmp38_;
	JsonObject* _tmp39_;
	JsonObject* _tmp40_;
	GeeHashSet* _tmp41_;
	GeeArrayList* _tmp42_;
	JsonObject* _tmp43_;
	const gchar* _tmp44_;
	JsonObject* _tmp45_;
	const gchar* _tmp46_;
	SynapseChromiumPluginBookmarkMatch* _tmp47_;
	SynapseChromiumPluginBookmarkMatch* _tmp48_;
	JsonObject* _tmp49_;
	const gchar* _tmp50_;
	JsonObject* _tmp51_;
	JsonArray* _tmp52_;
	GList* _tmp53_;
	GError* err;
	GError* _tmp54_;
	const gchar* _tmp55_;
	SynapseUtilsAsyncOnce* _tmp56_;
	GeeArrayList* _tmp57_;
	GError* _inner_error0_;
};

struct _SynapseChromiumPluginBookmarkMatch {
	SynapseUriMatch parent_instance;
	SynapseChromiumPluginBookmarkMatchPrivate * priv;
};

struct _SynapseChromiumPluginBookmarkMatchClass {
	SynapseUriMatchClass parent_class;
};

struct _SynapseChromiumPluginBookmarkMatchPrivate {
	gchar* title_folded;
	gchar* uri_folded;
};

static gint SynapseChromiumPlugin_private_offset;
static gpointer synapse_chromium_plugin_parent_class = NULL;
static gint SynapseChromiumPluginBookmarkMatch_private_offset;
static gpointer synapse_chromium_plugin_bookmark_match_parent_class = NULL;
static SynapseActivatableIface * synapse_chromium_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_chromium_plugin_synapse_item_provider_parent_iface = NULL;

GType synapse_chromium_plugin_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseChromiumPlugin, g_object_unref)
static GType synapse_chromium_plugin_bookmark_match_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseChromiumPluginBookmarkMatch, g_object_unref)
static void synapse_chromium_plugin_real_activate (SynapseActivatable* base);
static void synapse_chromium_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_chromium_plugin_register_plugin (void);
static void _synapse_chromium_plugin_register_plugin_synapse_plugin_register_func (void);
static void synapse_chromium_plugin_full_search (SynapseChromiumPlugin* self,
                                          SynapseQuery* q,
                                          SynapseResultSet* results,
                                          SynapseMatcherFlags flags);
static const gchar* synapse_chromium_plugin_bookmark_match_get_title_folded (SynapseChromiumPluginBookmarkMatch* self);
static const gchar* synapse_chromium_plugin_bookmark_match_get_uri_folded (SynapseChromiumPluginBookmarkMatch* self);
static gboolean synapse_chromium_plugin_real_handles_query (SynapseItemProvider* base,
                                                     SynapseQuery* query);
static void synapse_chromium_plugin_real_search_data_free (gpointer _data);
static void synapse_chromium_plugin_real_search (SynapseItemProvider* base,
                                          SynapseQuery* q,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static gboolean synapse_chromium_plugin_real_search_co (SynapseChromiumPluginSearchData* _data_);
static void synapse_chromium_plugin_parse_bookmarks (SynapseChromiumPlugin* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static void synapse_chromium_plugin_parse_bookmarks_finish (SynapseChromiumPlugin* self,
                                                     GAsyncResult* _res_);
static void synapse_chromium_plugin_search_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static gboolean synapse_chromium_plugin_is_container (JsonObject* o,
                                               const gchar* container_string);
static gboolean synapse_chromium_plugin_is_bookmark (JsonObject* o);
static gboolean synapse_chromium_plugin_is_good (JsonObject* o,
                                          GeeHashSet* unwanted_scheme);
static void synapse_chromium_plugin_parse_bookmarks_data_free (gpointer _data);
static gboolean synapse_chromium_plugin_parse_bookmarks_co (SynapseChromiumPluginParseBookmarksData* _data_);
static void synapse_chromium_plugin_parse_bookmarks_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static SynapseChromiumPluginBookmarkMatch* synapse_chromium_plugin_bookmark_match_new_with_content (const gchar* name,
                                                                                             const gchar* url);
static SynapseChromiumPluginBookmarkMatch* synapse_chromium_plugin_bookmark_match_construct_with_content (GType object_type,
                                                                                                   const gchar* name,
                                                                                                   const gchar* url);
SynapseChromiumPlugin* synapse_chromium_plugin_new (void);
SynapseChromiumPlugin* synapse_chromium_plugin_construct (GType object_type);
static SynapseChromiumPluginBookmarkMatch* synapse_chromium_plugin_bookmark_match_new (void);
static SynapseChromiumPluginBookmarkMatch* synapse_chromium_plugin_bookmark_match_construct (GType object_type);
static void synapse_chromium_plugin_bookmark_match_finalize (GObject * obj);
static GType synapse_chromium_plugin_bookmark_match_get_type_once (void);
static GObject * synapse_chromium_plugin_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void synapse_chromium_plugin_finalize (GObject * obj);
static GType synapse_chromium_plugin_get_type_once (void);
static void _vala_synapse_chromium_plugin_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_synapse_chromium_plugin_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
synapse_chromium_plugin_get_instance_private (SynapseChromiumPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseChromiumPlugin_private_offset);
}

static void
synapse_chromium_plugin_real_activate (SynapseActivatable* base)
{
	SynapseChromiumPlugin * self;
#line 25 "../../../src/plugins/chromium-plugin.vala"
	self = (SynapseChromiumPlugin*) base;
#line 295 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseChromiumPlugin * self;
#line 30 "../../../src/plugins/chromium-plugin.vala"
	self = (SynapseChromiumPlugin*) base;
#line 304 "chromium-plugin.c"
}

static void
_synapse_chromium_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 64 "../../../src/plugins/chromium-plugin.vala"
	synapse_chromium_plugin_register_plugin ();
#line 312 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_register_plugin (void)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	SynapsePluginRegistry* _tmp6_;
	SynapsePluginRegistry* _tmp7_;
#line 70 "../../../src/plugins/chromium-plugin.vala"
	_tmp1_ = g_find_program_in_path ("chromium");
#line 70 "../../../src/plugins/chromium-plugin.vala"
	_tmp2_ = _tmp1_;
#line 70 "../../../src/plugins/chromium-plugin.vala"
	_tmp3_ = _tmp2_ != NULL;
#line 70 "../../../src/plugins/chromium-plugin.vala"
	_g_free0 (_tmp2_);
#line 70 "../../../src/plugins/chromium-plugin.vala"
	if (_tmp3_) {
#line 70 "../../../src/plugins/chromium-plugin.vala"
		_tmp0_ = TRUE;
#line 336 "chromium-plugin.c"
	} else {
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 70 "../../../src/plugins/chromium-plugin.vala"
		_tmp4_ = g_find_program_in_path ("chromium-browser");
#line 70 "../../../src/plugins/chromium-plugin.vala"
		_tmp5_ = _tmp4_;
#line 70 "../../../src/plugins/chromium-plugin.vala"
		_tmp0_ = _tmp5_ != NULL;
#line 70 "../../../src/plugins/chromium-plugin.vala"
		_g_free0 (_tmp5_);
#line 348 "chromium-plugin.c"
	}
#line 64 "../../../src/plugins/chromium-plugin.vala"
	_tmp6_ = synapse_plugin_registry_get_default ();
#line 64 "../../../src/plugins/chromium-plugin.vala"
	_tmp7_ = _tmp6_;
#line 64 "../../../src/plugins/chromium-plugin.vala"
	synapse_plugin_registry_register_plugin (_tmp7_, SYNAPSE_TYPE_CHROMIUM_PLUGIN, _ ("Chromium Plugin"), _ ("Browse and open Chromium bookmarks."), "chromium", _synapse_chromium_plugin_register_plugin_synapse_plugin_register_func, _tmp0_, _ ("Chromium is not installed"));
#line 64 "../../../src/plugins/chromium-plugin.vala"
	_g_object_unref0 (_tmp7_);
#line 358 "chromium-plugin.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 93 "../../../src/plugins/chromium-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 366 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_full_search (SynapseChromiumPlugin* self,
                                     SynapseQuery* q,
                                     SynapseResultSet* results,
                                     SynapseMatcherFlags flags)
{
	GeeList* matchers = NULL;
	SynapseQuery _tmp0_;
	const gchar* _tmp1_;
	GeeList* _tmp2_;
#line 87 "../../../src/plugins/chromium-plugin.vala"
	g_return_if_fail (self != NULL);
#line 87 "../../../src/plugins/chromium-plugin.vala"
	g_return_if_fail (q != NULL);
#line 87 "../../../src/plugins/chromium-plugin.vala"
	g_return_if_fail (results != NULL);
#line 91 "../../../src/plugins/chromium-plugin.vala"
	_tmp0_ = *q;
#line 91 "../../../src/plugins/chromium-plugin.vala"
	_tmp1_ = _tmp0_.query_string_folded;
#line 91 "../../../src/plugins/chromium-plugin.vala"
	_tmp2_ = synapse_query_get_matchers_for_query (_tmp1_, flags, G_REGEX_OPTIMIZE);
#line 91 "../../../src/plugins/chromium-plugin.vala"
	matchers = _tmp2_;
#line 393 "chromium-plugin.c"
	{
		GeeList* _bmk_list = NULL;
		SynapseUtilsAsyncOnce* _tmp3_;
		gconstpointer _tmp4_;
		GeeList* _tmp5_;
		gint _bmk_size = 0;
		GeeList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _bmk_index = 0;
#line 93 "../../../src/plugins/chromium-plugin.vala"
		_tmp3_ = self->priv->bookmarks_once;
#line 93 "../../../src/plugins/chromium-plugin.vala"
		_tmp4_ = synapse_utils_async_once_get_data (_tmp3_);
#line 93 "../../../src/plugins/chromium-plugin.vala"
		_tmp5_ = _g_object_ref0 ((GeeList*) _tmp4_);
#line 93 "../../../src/plugins/chromium-plugin.vala"
		_bmk_list = _tmp5_;
#line 93 "../../../src/plugins/chromium-plugin.vala"
		_tmp6_ = _bmk_list;
#line 93 "../../../src/plugins/chromium-plugin.vala"
		_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
#line 93 "../../../src/plugins/chromium-plugin.vala"
		_tmp8_ = _tmp7_;
#line 93 "../../../src/plugins/chromium-plugin.vala"
		_bmk_size = _tmp8_;
#line 93 "../../../src/plugins/chromium-plugin.vala"
		_bmk_index = -1;
#line 93 "../../../src/plugins/chromium-plugin.vala"
		while (TRUE) {
#line 424 "chromium-plugin.c"
			gint _tmp9_;
			gint _tmp10_;
			SynapseChromiumPluginBookmarkMatch* bmk = NULL;
			GeeList* _tmp11_;
			gpointer _tmp12_;
			const gchar* name = NULL;
			SynapseChromiumPluginBookmarkMatch* _tmp13_;
			const gchar* _tmp14_;
			const gchar* url = NULL;
			SynapseChromiumPluginBookmarkMatch* _tmp15_;
			const gchar* _tmp16_;
#line 93 "../../../src/plugins/chromium-plugin.vala"
			_bmk_index = _bmk_index + 1;
#line 93 "../../../src/plugins/chromium-plugin.vala"
			_tmp9_ = _bmk_index;
#line 93 "../../../src/plugins/chromium-plugin.vala"
			_tmp10_ = _bmk_size;
#line 93 "../../../src/plugins/chromium-plugin.vala"
			if (!(_tmp9_ < _tmp10_)) {
#line 93 "../../../src/plugins/chromium-plugin.vala"
				break;
#line 446 "chromium-plugin.c"
			}
#line 93 "../../../src/plugins/chromium-plugin.vala"
			_tmp11_ = _bmk_list;
#line 93 "../../../src/plugins/chromium-plugin.vala"
			_tmp12_ = gee_list_get (_tmp11_, _bmk_index);
#line 93 "../../../src/plugins/chromium-plugin.vala"
			bmk = (SynapseChromiumPluginBookmarkMatch*) _tmp12_;
#line 95 "../../../src/plugins/chromium-plugin.vala"
			_tmp13_ = bmk;
#line 95 "../../../src/plugins/chromium-plugin.vala"
			_tmp14_ = synapse_chromium_plugin_bookmark_match_get_title_folded (_tmp13_);
#line 95 "../../../src/plugins/chromium-plugin.vala"
			name = _tmp14_;
#line 96 "../../../src/plugins/chromium-plugin.vala"
			_tmp15_ = bmk;
#line 96 "../../../src/plugins/chromium-plugin.vala"
			_tmp16_ = synapse_chromium_plugin_bookmark_match_get_uri_folded (_tmp15_);
#line 96 "../../../src/plugins/chromium-plugin.vala"
			url = _tmp16_;
#line 466 "chromium-plugin.c"
			{
				GeeList* _matcher_list = NULL;
				GeeList* _tmp17_;
				GeeList* _tmp18_;
				gint _matcher_size = 0;
				GeeList* _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				gint _matcher_index = 0;
#line 98 "../../../src/plugins/chromium-plugin.vala"
				_tmp17_ = matchers;
#line 98 "../../../src/plugins/chromium-plugin.vala"
				_tmp18_ = _g_object_ref0 (_tmp17_);
#line 98 "../../../src/plugins/chromium-plugin.vala"
				_matcher_list = _tmp18_;
#line 98 "../../../src/plugins/chromium-plugin.vala"
				_tmp19_ = _matcher_list;
#line 98 "../../../src/plugins/chromium-plugin.vala"
				_tmp20_ = gee_collection_get_size ((GeeCollection*) _tmp19_);
#line 98 "../../../src/plugins/chromium-plugin.vala"
				_tmp21_ = _tmp20_;
#line 98 "../../../src/plugins/chromium-plugin.vala"
				_matcher_size = _tmp21_;
#line 98 "../../../src/plugins/chromium-plugin.vala"
				_matcher_index = -1;
#line 98 "../../../src/plugins/chromium-plugin.vala"
				while (TRUE) {
#line 494 "chromium-plugin.c"
					gint _tmp22_;
					gint _tmp23_;
					GeeMapEntry* matcher = NULL;
					GeeList* _tmp24_;
					gpointer _tmp25_;
					GeeMapEntry* _tmp26_;
					gconstpointer _tmp27_;
					gconstpointer _tmp28_;
					const gchar* _tmp29_;
					gboolean _tmp34_ = FALSE;
					const gchar* _tmp35_;
#line 98 "../../../src/plugins/chromium-plugin.vala"
					_matcher_index = _matcher_index + 1;
#line 98 "../../../src/plugins/chromium-plugin.vala"
					_tmp22_ = _matcher_index;
#line 98 "../../../src/plugins/chromium-plugin.vala"
					_tmp23_ = _matcher_size;
#line 98 "../../../src/plugins/chromium-plugin.vala"
					if (!(_tmp22_ < _tmp23_)) {
#line 98 "../../../src/plugins/chromium-plugin.vala"
						break;
#line 516 "chromium-plugin.c"
					}
#line 98 "../../../src/plugins/chromium-plugin.vala"
					_tmp24_ = _matcher_list;
#line 98 "../../../src/plugins/chromium-plugin.vala"
					_tmp25_ = gee_list_get (_tmp24_, _matcher_index);
#line 98 "../../../src/plugins/chromium-plugin.vala"
					matcher = (GeeMapEntry*) _tmp25_;
#line 100 "../../../src/plugins/chromium-plugin.vala"
					_tmp26_ = matcher;
#line 100 "../../../src/plugins/chromium-plugin.vala"
					_tmp27_ = gee_map_entry_get_key (_tmp26_);
#line 100 "../../../src/plugins/chromium-plugin.vala"
					_tmp28_ = _tmp27_;
#line 100 "../../../src/plugins/chromium-plugin.vala"
					_tmp29_ = name;
#line 100 "../../../src/plugins/chromium-plugin.vala"
					if (g_regex_match ((GRegex*) _tmp28_, _tmp29_, 0, NULL)) {
#line 534 "chromium-plugin.c"
						SynapseChromiumPluginBookmarkMatch* _tmp30_;
						GeeMapEntry* _tmp31_;
						gconstpointer _tmp32_;
						gconstpointer _tmp33_;
#line 102 "../../../src/plugins/chromium-plugin.vala"
						_tmp30_ = bmk;
#line 102 "../../../src/plugins/chromium-plugin.vala"
						_tmp31_ = matcher;
#line 102 "../../../src/plugins/chromium-plugin.vala"
						_tmp32_ = gee_map_entry_get_value (_tmp31_);
#line 102 "../../../src/plugins/chromium-plugin.vala"
						_tmp33_ = _tmp32_;
#line 102 "../../../src/plugins/chromium-plugin.vala"
						synapse_result_set_add (results, (SynapseMatch*) _tmp30_, (gint) ((gintptr) _tmp33_));
#line 103 "../../../src/plugins/chromium-plugin.vala"
						_g_object_unref0 (matcher);
#line 103 "../../../src/plugins/chromium-plugin.vala"
						break;
#line 553 "chromium-plugin.c"
					}
#line 105 "../../../src/plugins/chromium-plugin.vala"
					_tmp35_ = url;
#line 105 "../../../src/plugins/chromium-plugin.vala"
					if (_tmp35_ != NULL) {
#line 559 "chromium-plugin.c"
						GeeMapEntry* _tmp36_;
						gconstpointer _tmp37_;
						gconstpointer _tmp38_;
						const gchar* _tmp39_;
#line 105 "../../../src/plugins/chromium-plugin.vala"
						_tmp36_ = matcher;
#line 105 "../../../src/plugins/chromium-plugin.vala"
						_tmp37_ = gee_map_entry_get_key (_tmp36_);
#line 105 "../../../src/plugins/chromium-plugin.vala"
						_tmp38_ = _tmp37_;
#line 105 "../../../src/plugins/chromium-plugin.vala"
						_tmp39_ = url;
#line 105 "../../../src/plugins/chromium-plugin.vala"
						_tmp34_ = g_regex_match ((GRegex*) _tmp38_, _tmp39_, 0, NULL);
#line 574 "chromium-plugin.c"
					} else {
#line 105 "../../../src/plugins/chromium-plugin.vala"
						_tmp34_ = FALSE;
#line 578 "chromium-plugin.c"
					}
#line 105 "../../../src/plugins/chromium-plugin.vala"
					if (_tmp34_) {
#line 582 "chromium-plugin.c"
						SynapseChromiumPluginBookmarkMatch* _tmp40_;
						GeeMapEntry* _tmp41_;
						gconstpointer _tmp42_;
						gconstpointer _tmp43_;
#line 107 "../../../src/plugins/chromium-plugin.vala"
						_tmp40_ = bmk;
#line 107 "../../../src/plugins/chromium-plugin.vala"
						_tmp41_ = matcher;
#line 107 "../../../src/plugins/chromium-plugin.vala"
						_tmp42_ = gee_map_entry_get_value (_tmp41_);
#line 107 "../../../src/plugins/chromium-plugin.vala"
						_tmp43_ = _tmp42_;
#line 107 "../../../src/plugins/chromium-plugin.vala"
						synapse_result_set_add (results, (SynapseMatch*) _tmp40_, (gint) ((gintptr) _tmp43_));
#line 108 "../../../src/plugins/chromium-plugin.vala"
						_g_object_unref0 (matcher);
#line 108 "../../../src/plugins/chromium-plugin.vala"
						break;
#line 601 "chromium-plugin.c"
					}
#line 98 "../../../src/plugins/chromium-plugin.vala"
					_g_object_unref0 (matcher);
#line 605 "chromium-plugin.c"
				}
#line 98 "../../../src/plugins/chromium-plugin.vala"
				_g_object_unref0 (_matcher_list);
#line 609 "chromium-plugin.c"
			}
#line 93 "../../../src/plugins/chromium-plugin.vala"
			_g_object_unref0 (bmk);
#line 613 "chromium-plugin.c"
		}
#line 93 "../../../src/plugins/chromium-plugin.vala"
		_g_object_unref0 (_bmk_list);
#line 617 "chromium-plugin.c"
	}
#line 87 "../../../src/plugins/chromium-plugin.vala"
	_g_object_unref0 (matchers);
#line 621 "chromium-plugin.c"
}

static gboolean
synapse_chromium_plugin_real_handles_query (SynapseItemProvider* base,
                                            SynapseQuery* query)
{
	SynapseChromiumPlugin * self;
	SynapseQuery _tmp0_;
	SynapseQueryFlags _tmp1_;
	gboolean result = FALSE;
#line 114 "../../../src/plugins/chromium-plugin.vala"
	self = (SynapseChromiumPlugin*) base;
#line 114 "../../../src/plugins/chromium-plugin.vala"
	g_return_val_if_fail (query != NULL, FALSE);
#line 116 "../../../src/plugins/chromium-plugin.vala"
	_tmp0_ = *query;
#line 116 "../../../src/plugins/chromium-plugin.vala"
	_tmp1_ = _tmp0_.query_type;
#line 116 "../../../src/plugins/chromium-plugin.vala"
	result = (_tmp1_ & SYNAPSE_QUERY_FLAGS_INTERNET) == SYNAPSE_QUERY_FLAGS_INTERNET;
#line 116 "../../../src/plugins/chromium-plugin.vala"
	return result;
#line 644 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_real_search_data_free (gpointer _data)
{
	SynapseChromiumPluginSearchData* _data_;
	_data_ = _data;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 21 "../../../src/plugins/chromium-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 21 "../../../src/plugins/chromium-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 21 "../../../src/plugins/chromium-plugin.vala"
	g_slice_free (SynapseChromiumPluginSearchData, _data_);
#line 660 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_real_search (SynapseItemProvider* base,
                                     SynapseQuery* q,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	SynapseChromiumPlugin * self;
	SynapseChromiumPluginSearchData* _data_;
	SynapseChromiumPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
#line 21 "../../../src/plugins/chromium-plugin.vala"
	self = (SynapseChromiumPlugin*) base;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	_data_ = g_slice_new0 (SynapseChromiumPluginSearchData);
#line 21 "../../../src/plugins/chromium-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 21 "../../../src/plugins/chromium-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_chromium_plugin_real_search_data_free);
#line 21 "../../../src/plugins/chromium-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 21 "../../../src/plugins/chromium-plugin.vala"
	_data_->self = _tmp0_;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	_tmp1_ = *q;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	_tmp2_ = _tmp1_;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 21 "../../../src/plugins/chromium-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 21 "../../../src/plugins/chromium-plugin.vala"
	_data_->q = _tmp3_;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	synapse_chromium_plugin_real_search_co (_data_);
#line 699 "chromium-plugin.c"
}

static SynapseResultSet*
synapse_chromium_plugin_search_finish (SynapseItemProvider* base,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	SynapseResultSet* result;
	SynapseChromiumPluginSearchData* _data_;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 21 "../../../src/plugins/chromium-plugin.vala"
	if (NULL == _data_) {
#line 21 "../../../src/plugins/chromium-plugin.vala"
		return NULL;
#line 715 "chromium-plugin.c"
	}
#line 21 "../../../src/plugins/chromium-plugin.vala"
	result = _data_->result;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	_data_->result = NULL;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	return result;
#line 723 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_search_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	SynapseChromiumPluginSearchData* _data_;
#line 125 "../../../src/plugins/chromium-plugin.vala"
	_data_ = _user_data_;
#line 125 "../../../src/plugins/chromium-plugin.vala"
	_data_->_source_object_ = source_object;
#line 125 "../../../src/plugins/chromium-plugin.vala"
	_data_->_res_ = _res_;
#line 125 "../../../src/plugins/chromium-plugin.vala"
	synapse_chromium_plugin_real_search_co (_data_);
#line 740 "chromium-plugin.c"
}

static gboolean
synapse_chromium_plugin_real_search_co (SynapseChromiumPluginSearchData* _data_)
{
#line 119 "../../../src/plugins/chromium-plugin.vala"
	switch (_data_->_state_) {
#line 119 "../../../src/plugins/chromium-plugin.vala"
		case 0:
#line 750 "chromium-plugin.c"
		goto _state_0;
#line 119 "../../../src/plugins/chromium-plugin.vala"
		case 1:
#line 754 "chromium-plugin.c"
		goto _state_1;
		default:
#line 119 "../../../src/plugins/chromium-plugin.vala"
		g_assert_not_reached ();
#line 759 "chromium-plugin.c"
	}
	_state_0:
#line 121 "../../../src/plugins/chromium-plugin.vala"
	_data_->_tmp0_ = synapse_result_set_new ();
#line 121 "../../../src/plugins/chromium-plugin.vala"
	_data_->_result_ = _data_->_tmp0_;
#line 123 "../../../src/plugins/chromium-plugin.vala"
	_data_->_tmp1_ = _data_->self->priv->bookmarks_once;
#line 123 "../../../src/plugins/chromium-plugin.vala"
	if (!synapse_utils_async_once_is_initialized (_data_->_tmp1_)) {
#line 125 "../../../src/plugins/chromium-plugin.vala"
		_data_->_state_ = 1;
#line 125 "../../../src/plugins/chromium-plugin.vala"
		synapse_chromium_plugin_parse_bookmarks (_data_->self, synapse_chromium_plugin_search_ready, _data_);
#line 125 "../../../src/plugins/chromium-plugin.vala"
		return FALSE;
#line 776 "chromium-plugin.c"
		_state_1:
#line 125 "../../../src/plugins/chromium-plugin.vala"
		synapse_chromium_plugin_parse_bookmarks_finish (_data_->self, _data_->_res_);
#line 780 "chromium-plugin.c"
	}
#line 128 "../../../src/plugins/chromium-plugin.vala"
	_data_->_tmp2_ = _data_->q;
#line 128 "../../../src/plugins/chromium-plugin.vala"
	_data_->_tmp3_ = _data_->_tmp2_.query_string;
#line 128 "../../../src/plugins/chromium-plugin.vala"
	if (g_utf8_strlen (_data_->_tmp3_, (gssize) -1) == 1) {
#line 130 "../../../src/plugins/chromium-plugin.vala"
		_data_->flags = (SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING | SYNAPSE_MATCHER_FLAGS_NO_PARTIAL) | SYNAPSE_MATCHER_FLAGS_NO_FUZZY;
#line 132 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp4_ = _data_->q;
#line 132 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp5_ = _data_->_result_;
#line 132 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp6_ = _data_->flags;
#line 132 "../../../src/plugins/chromium-plugin.vala"
		synapse_chromium_plugin_full_search (_data_->self, &_data_->_tmp4_, _data_->_tmp5_, _data_->_tmp6_);
#line 798 "chromium-plugin.c"
	} else {
#line 136 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp7_ = _data_->q;
#line 136 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp8_ = _data_->_result_;
#line 136 "../../../src/plugins/chromium-plugin.vala"
		synapse_chromium_plugin_full_search (_data_->self, &_data_->_tmp7_, _data_->_tmp8_, 0);
#line 806 "chromium-plugin.c"
	}
#line 139 "../../../src/plugins/chromium-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 139 "../../../src/plugins/chromium-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 139 "../../../src/plugins/chromium-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 139 "../../../src/plugins/chromium-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 139 "../../../src/plugins/chromium-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 139 "../../../src/plugins/chromium-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 139 "../../../src/plugins/chromium-plugin.vala"
			return FALSE;
#line 822 "chromium-plugin.c"
		} else {
#line 139 "../../../src/plugins/chromium-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 139 "../../../src/plugins/chromium-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 139 "../../../src/plugins/chromium-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 139 "../../../src/plugins/chromium-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 139 "../../../src/plugins/chromium-plugin.vala"
			return FALSE;
#line 834 "chromium-plugin.c"
		}
	}
#line 141 "../../../src/plugins/chromium-plugin.vala"
	_data_->result = _data_->_result_;
#line 141 "../../../src/plugins/chromium-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 141 "../../../src/plugins/chromium-plugin.vala"
	if (_data_->_state_ != 0) {
#line 141 "../../../src/plugins/chromium-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 141 "../../../src/plugins/chromium-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 847 "chromium-plugin.c"
		}
	}
#line 141 "../../../src/plugins/chromium-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 141 "../../../src/plugins/chromium-plugin.vala"
	return FALSE;
#line 854 "chromium-plugin.c"
}

static gboolean
synapse_chromium_plugin_is_container (JsonObject* o,
                                      const gchar* container_string)
{
	const gchar* _tmp0_;
	gboolean result = FALSE;
#line 147 "../../../src/plugins/chromium-plugin.vala"
	g_return_val_if_fail (o != NULL, FALSE);
#line 147 "../../../src/plugins/chromium-plugin.vala"
	g_return_val_if_fail (container_string != NULL, FALSE);
#line 149 "../../../src/plugins/chromium-plugin.vala"
	_tmp0_ = json_object_get_string_member (o, "type");
#line 149 "../../../src/plugins/chromium-plugin.vala"
	result = g_strcmp0 (_tmp0_, container_string) == 0;
#line 149 "../../../src/plugins/chromium-plugin.vala"
	return result;
#line 873 "chromium-plugin.c"
}

static gboolean
synapse_chromium_plugin_is_bookmark (JsonObject* o)
{
	gboolean result = FALSE;
#line 152 "../../../src/plugins/chromium-plugin.vala"
	g_return_val_if_fail (o != NULL, FALSE);
#line 154 "../../../src/plugins/chromium-plugin.vala"
	result = json_object_has_member (o, "url");
#line 154 "../../../src/plugins/chromium-plugin.vala"
	return result;
#line 886 "chromium-plugin.c"
}

static gboolean
synapse_chromium_plugin_is_good (JsonObject* o,
                                 GeeHashSet* unwanted_scheme)
{
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean result = FALSE;
#line 157 "../../../src/plugins/chromium-plugin.vala"
	g_return_val_if_fail (o != NULL, FALSE);
#line 157 "../../../src/plugins/chromium-plugin.vala"
	g_return_val_if_fail (unwanted_scheme != NULL, FALSE);
#line 159 "../../../src/plugins/chromium-plugin.vala"
	_tmp0_ = json_object_get_string_member (o, "url");
#line 159 "../../../src/plugins/chromium-plugin.vala"
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ":", 1);
#line 159 "../../../src/plugins/chromium-plugin.vala"
	_tmp3_ = _tmp2_;
#line 159 "../../../src/plugins/chromium-plugin.vala"
	_tmp3__length1 = _vala_array_length (_tmp1_);
#line 159 "../../../src/plugins/chromium-plugin.vala"
	_tmp4_ = _tmp3_[0];
#line 159 "../../../src/plugins/chromium-plugin.vala"
	_tmp5_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) unwanted_scheme, _tmp4_);
#line 159 "../../../src/plugins/chromium-plugin.vala"
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
#line 159 "../../../src/plugins/chromium-plugin.vala"
	result = _tmp5_;
#line 159 "../../../src/plugins/chromium-plugin.vala"
	return result;
#line 923 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_parse_bookmarks_data_free (gpointer _data)
{
	SynapseChromiumPluginParseBookmarksData* _data_;
	_data_ = _data;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 21 "../../../src/plugins/chromium-plugin.vala"
	g_slice_free (SynapseChromiumPluginParseBookmarksData, _data_);
#line 935 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_parse_bookmarks (SynapseChromiumPlugin* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	SynapseChromiumPluginParseBookmarksData* _data_;
	SynapseChromiumPlugin* _tmp0_;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	_data_ = g_slice_new0 (SynapseChromiumPluginParseBookmarksData);
#line 21 "../../../src/plugins/chromium-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 21 "../../../src/plugins/chromium-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_chromium_plugin_parse_bookmarks_data_free);
#line 21 "../../../src/plugins/chromium-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 21 "../../../src/plugins/chromium-plugin.vala"
	_data_->self = _tmp0_;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	synapse_chromium_plugin_parse_bookmarks_co (_data_);
#line 957 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_parse_bookmarks_finish (SynapseChromiumPlugin* self,
                                                GAsyncResult* _res_)
{
	SynapseChromiumPluginParseBookmarksData* _data_;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 967 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_parse_bookmarks_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	SynapseChromiumPluginParseBookmarksData* _data_;
#line 165 "../../../src/plugins/chromium-plugin.vala"
	_data_ = _user_data_;
#line 165 "../../../src/plugins/chromium-plugin.vala"
	_data_->_source_object_ = source_object;
#line 165 "../../../src/plugins/chromium-plugin.vala"
	_data_->_res_ = _res_;
#line 165 "../../../src/plugins/chromium-plugin.vala"
	synapse_chromium_plugin_parse_bookmarks_co (_data_);
#line 984 "chromium-plugin.c"
}

static gpointer
_json_object_ref0 (gpointer self)
{
#line 187 "../../../src/plugins/chromium-plugin.vala"
	return self ? json_object_ref (self) : NULL;
#line 992 "chromium-plugin.c"
}

static gboolean
synapse_chromium_plugin_parse_bookmarks_co (SynapseChromiumPluginParseBookmarksData* _data_)
{
#line 163 "../../../src/plugins/chromium-plugin.vala"
	switch (_data_->_state_) {
#line 163 "../../../src/plugins/chromium-plugin.vala"
		case 0:
#line 1002 "chromium-plugin.c"
		goto _state_0;
#line 163 "../../../src/plugins/chromium-plugin.vala"
		case 1:
#line 1006 "chromium-plugin.c"
		goto _state_1;
#line 163 "../../../src/plugins/chromium-plugin.vala"
		case 2:
#line 1010 "chromium-plugin.c"
		goto _state_2;
#line 163 "../../../src/plugins/chromium-plugin.vala"
		case 3:
#line 1014 "chromium-plugin.c"
		goto _state_3;
		default:
#line 163 "../../../src/plugins/chromium-plugin.vala"
		g_assert_not_reached ();
#line 1019 "chromium-plugin.c"
	}
	_state_0:
#line 165 "../../../src/plugins/chromium-plugin.vala"
	_data_->_tmp0_ = _data_->self->priv->bookmarks_once;
#line 165 "../../../src/plugins/chromium-plugin.vala"
	_data_->_state_ = 1;
#line 165 "../../../src/plugins/chromium-plugin.vala"
	synapse_utils_async_once_enter (_data_->_tmp0_, synapse_chromium_plugin_parse_bookmarks_ready, _data_);
#line 165 "../../../src/plugins/chromium-plugin.vala"
	return FALSE;
#line 1030 "chromium-plugin.c"
	_state_1:
#line 165 "../../../src/plugins/chromium-plugin.vala"
	_data_->is_locked = synapse_utils_async_once_enter_finish (_data_->_tmp0_, _data_->_res_);
#line 166 "../../../src/plugins/chromium-plugin.vala"
	if (!_data_->is_locked) {
#line 166 "../../../src/plugins/chromium-plugin.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 166 "../../../src/plugins/chromium-plugin.vala"
		if (_data_->_state_ != 0) {
#line 166 "../../../src/plugins/chromium-plugin.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 166 "../../../src/plugins/chromium-plugin.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1044 "chromium-plugin.c"
			}
		}
#line 166 "../../../src/plugins/chromium-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 166 "../../../src/plugins/chromium-plugin.vala"
		return FALSE;
#line 1051 "chromium-plugin.c"
	}
#line 168 "../../../src/plugins/chromium-plugin.vala"
	_data_->_tmp1_ = gee_array_list_new (SYNAPSE_CHROMIUM_PLUGIN_TYPE_BOOKMARK_MATCH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 168 "../../../src/plugins/chromium-plugin.vala"
	_data_->bookmarks = _data_->_tmp1_;
#line 169 "../../../src/plugins/chromium-plugin.vala"
	_data_->_tmp2_ = json_parser_new ();
#line 169 "../../../src/plugins/chromium-plugin.vala"
	_data_->parser = _data_->_tmp2_;
#line 170 "../../../src/plugins/chromium-plugin.vala"
	_data_->_tmp3_ = g_get_user_config_dir ();
#line 170 "../../../src/plugins/chromium-plugin.vala"
	_data_->_tmp4_ = g_build_filename (_data_->_tmp3_, "chromium", "Default", "Bookmarks", NULL);
#line 170 "../../../src/plugins/chromium-plugin.vala"
	_data_->fpath = _data_->_tmp4_;
#line 173 "../../../src/plugins/chromium-plugin.vala"
	_data_->_tmp5_ = g_strdup ("folder");
#line 173 "../../../src/plugins/chromium-plugin.vala"
	_data_->CONTAINER = _data_->_tmp5_;
#line 174 "../../../src/plugins/chromium-plugin.vala"
	_data_->_tmp6_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 174 "../../../src/plugins/chromium-plugin.vala"
	_data_->UNWANTED_SCHEME = _data_->_tmp6_;
#line 175 "../../../src/plugins/chromium-plugin.vala"
	_data_->_tmp7_ = _data_->UNWANTED_SCHEME;
#line 175 "../../../src/plugins/chromium-plugin.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp7_, "data");
#line 176 "../../../src/plugins/chromium-plugin.vala"
	_data_->_tmp8_ = _data_->UNWANTED_SCHEME;
#line 176 "../../../src/plugins/chromium-plugin.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp8_, "place");
#line 177 "../../../src/plugins/chromium-plugin.vala"
	_data_->_tmp9_ = _data_->UNWANTED_SCHEME;
#line 177 "../../../src/plugins/chromium-plugin.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp9_, "javascript");
#line 179 "../../../src/plugins/chromium-plugin.vala"
	_data_->folders = NULL;
#line 1089 "chromium-plugin.c"
	{
#line 183 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp10_ = _data_->fpath;
#line 183 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp11_ = g_file_new_for_path (_data_->_tmp10_);
#line 183 "../../../src/plugins/chromium-plugin.vala"
		_data_->f = _data_->_tmp11_;
#line 184 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp12_ = _data_->f;
#line 184 "../../../src/plugins/chromium-plugin.vala"
		_data_->_state_ = 2;
#line 184 "../../../src/plugins/chromium-plugin.vala"
		g_file_read_async (_data_->_tmp12_, G_PRIORITY_DEFAULT, NULL, synapse_chromium_plugin_parse_bookmarks_ready, _data_);
#line 184 "../../../src/plugins/chromium-plugin.vala"
		return FALSE;
#line 1105 "chromium-plugin.c"
		_state_2:
#line 184 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp13_ = g_file_read_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error0_);
#line 184 "../../../src/plugins/chromium-plugin.vala"
		_data_->input_stream = _data_->_tmp13_;
#line 184 "../../../src/plugins/chromium-plugin.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 184 "../../../src/plugins/chromium-plugin.vala"
			_g_object_unref0 (_data_->f);
#line 1115 "chromium-plugin.c"
			goto __catch0_g_error;
		}
#line 185 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp14_ = _data_->parser;
#line 185 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp15_ = _data_->input_stream;
#line 185 "../../../src/plugins/chromium-plugin.vala"
		_data_->_state_ = 3;
#line 185 "../../../src/plugins/chromium-plugin.vala"
		json_parser_load_from_stream_async (_data_->_tmp14_, (GInputStream*) _data_->_tmp15_, NULL, synapse_chromium_plugin_parse_bookmarks_ready, _data_);
#line 185 "../../../src/plugins/chromium-plugin.vala"
		return FALSE;
#line 1128 "chromium-plugin.c"
		_state_3:
#line 185 "../../../src/plugins/chromium-plugin.vala"
		json_parser_load_from_stream_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error0_);
#line 185 "../../../src/plugins/chromium-plugin.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 185 "../../../src/plugins/chromium-plugin.vala"
			_g_object_unref0 (_data_->input_stream);
#line 185 "../../../src/plugins/chromium-plugin.vala"
			_g_object_unref0 (_data_->f);
#line 1138 "chromium-plugin.c"
			goto __catch0_g_error;
		}
#line 187 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp16_ = _data_->parser;
#line 187 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp17_ = json_parser_get_root (_data_->_tmp16_);
#line 187 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp18_ = json_node_get_object (_data_->_tmp17_);
#line 187 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp19_ = _json_object_ref0 (_data_->_tmp18_);
#line 187 "../../../src/plugins/chromium-plugin.vala"
		_data_->root_object = _data_->_tmp19_;
#line 188 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp20_ = _data_->root_object;
#line 188 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp21_ = json_object_get_member (_data_->_tmp20_, "roots");
#line 188 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp22_ = json_node_get_object (_data_->_tmp21_);
#line 188 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp23_ = json_object_get_member (_data_->_tmp22_, "bookmark_bar");
#line 188 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp24_ = json_node_get_object (_data_->_tmp23_);
#line 188 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp25_ = json_object_get_array_member (_data_->_tmp24_, "children");
#line 188 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp26_ = json_array_get_elements (_data_->_tmp25_);
#line 188 "../../../src/plugins/chromium-plugin.vala"
		_data_->folders = g_list_concat (_data_->folders, _data_->_tmp26_);
#line 191 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp27_ = _data_->root_object;
#line 191 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp28_ = json_object_get_member (_data_->_tmp27_, "roots");
#line 191 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp29_ = json_node_get_object (_data_->_tmp28_);
#line 191 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp30_ = json_object_get_member (_data_->_tmp29_, "other");
#line 191 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp31_ = json_node_get_object (_data_->_tmp30_);
#line 191 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp32_ = json_object_get_array_member (_data_->_tmp31_, "children");
#line 191 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp33_ = json_array_get_elements (_data_->_tmp32_);
#line 191 "../../../src/plugins/chromium-plugin.vala"
		_data_->folders = g_list_concat (_data_->folders, _data_->_tmp33_);
#line 196 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp34_ = _data_->folders;
#line 1185 "chromium-plugin.c"
		{
#line 196 "../../../src/plugins/chromium-plugin.vala"
			_data_->item_collection = _data_->_tmp34_;
#line 196 "../../../src/plugins/chromium-plugin.vala"
			for (_data_->item_it = _data_->item_collection; _data_->item_it != NULL; _data_->item_it = _data_->item_it->next) {
#line 196 "../../../src/plugins/chromium-plugin.vala"
				_data_->item = (JsonNode*) _data_->item_it->data;
#line 1193 "chromium-plugin.c"
				{
#line 198 "../../../src/plugins/chromium-plugin.vala"
					_data_->_tmp35_ = _data_->item;
#line 198 "../../../src/plugins/chromium-plugin.vala"
					_data_->_tmp36_ = json_node_get_object (_data_->_tmp35_);
#line 198 "../../../src/plugins/chromium-plugin.vala"
					_data_->_tmp37_ = _json_object_ref0 (_data_->_tmp36_);
#line 198 "../../../src/plugins/chromium-plugin.vala"
					_json_object_unref0 (_data_->o);
#line 198 "../../../src/plugins/chromium-plugin.vala"
					_data_->o = _data_->_tmp37_;
#line 199 "../../../src/plugins/chromium-plugin.vala"
					_data_->_tmp39_ = _data_->o;
#line 199 "../../../src/plugins/chromium-plugin.vala"
					if (synapse_chromium_plugin_is_bookmark (_data_->_tmp39_)) {
#line 199 "../../../src/plugins/chromium-plugin.vala"
						_data_->_tmp40_ = _data_->o;
#line 199 "../../../src/plugins/chromium-plugin.vala"
						_data_->_tmp41_ = _data_->UNWANTED_SCHEME;
#line 199 "../../../src/plugins/chromium-plugin.vala"
						_data_->_tmp38_ = synapse_chromium_plugin_is_good (_data_->_tmp40_, _data_->_tmp41_);
#line 1215 "chromium-plugin.c"
					} else {
#line 199 "../../../src/plugins/chromium-plugin.vala"
						_data_->_tmp38_ = FALSE;
#line 1219 "chromium-plugin.c"
					}
#line 199 "../../../src/plugins/chromium-plugin.vala"
					if (_data_->_tmp38_) {
#line 201 "../../../src/plugins/chromium-plugin.vala"
						_data_->_tmp42_ = _data_->bookmarks;
#line 201 "../../../src/plugins/chromium-plugin.vala"
						_data_->_tmp43_ = _data_->o;
#line 201 "../../../src/plugins/chromium-plugin.vala"
						_data_->_tmp44_ = json_object_get_string_member (_data_->_tmp43_, "name");
#line 201 "../../../src/plugins/chromium-plugin.vala"
						_data_->_tmp45_ = _data_->o;
#line 201 "../../../src/plugins/chromium-plugin.vala"
						_data_->_tmp46_ = json_object_get_string_member (_data_->_tmp45_, "url");
#line 201 "../../../src/plugins/chromium-plugin.vala"
						_data_->_tmp47_ = synapse_chromium_plugin_bookmark_match_new_with_content (_data_->_tmp44_, _data_->_tmp46_);
#line 201 "../../../src/plugins/chromium-plugin.vala"
						_data_->_tmp48_ = _data_->_tmp47_;
#line 201 "../../../src/plugins/chromium-plugin.vala"
						gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp42_, _data_->_tmp48_);
#line 201 "../../../src/plugins/chromium-plugin.vala"
						_g_object_unref0 (_data_->_tmp48_);
#line 1241 "chromium-plugin.c"
					}
#line 205 "../../../src/plugins/chromium-plugin.vala"
					_data_->_tmp49_ = _data_->o;
#line 205 "../../../src/plugins/chromium-plugin.vala"
					_data_->_tmp50_ = _data_->CONTAINER;
#line 205 "../../../src/plugins/chromium-plugin.vala"
					if (synapse_chromium_plugin_is_container (_data_->_tmp49_, _data_->_tmp50_)) {
#line 207 "../../../src/plugins/chromium-plugin.vala"
						_data_->_tmp51_ = _data_->o;
#line 207 "../../../src/plugins/chromium-plugin.vala"
						_data_->_tmp52_ = json_object_get_array_member (_data_->_tmp51_, "children");
#line 207 "../../../src/plugins/chromium-plugin.vala"
						_data_->_tmp53_ = json_array_get_elements (_data_->_tmp52_);
#line 207 "../../../src/plugins/chromium-plugin.vala"
						_data_->folders = g_list_concat (_data_->folders, _data_->_tmp53_);
#line 1257 "chromium-plugin.c"
					}
				}
			}
		}
#line 181 "../../../src/plugins/chromium-plugin.vala"
		_json_object_unref0 (_data_->o);
#line 181 "../../../src/plugins/chromium-plugin.vala"
		_json_object_unref0 (_data_->root_object);
#line 181 "../../../src/plugins/chromium-plugin.vala"
		_g_object_unref0 (_data_->input_stream);
#line 181 "../../../src/plugins/chromium-plugin.vala"
		_g_object_unref0 (_data_->f);
#line 1270 "chromium-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 181 "../../../src/plugins/chromium-plugin.vala"
		_data_->err = _data_->_inner_error0_;
#line 181 "../../../src/plugins/chromium-plugin.vala"
		_data_->_inner_error0_ = NULL;
#line 213 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp54_ = _data_->err;
#line 213 "../../../src/plugins/chromium-plugin.vala"
		_data_->_tmp55_ = _data_->_tmp54_->message;
#line 213 "../../../src/plugins/chromium-plugin.vala"
		g_warning ("chromium-plugin.vala:213: %s", _data_->_tmp55_);
#line 181 "../../../src/plugins/chromium-plugin.vala"
		_g_error_free0 (_data_->err);
#line 1287 "chromium-plugin.c"
	}
	__finally0:
#line 181 "../../../src/plugins/chromium-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 181 "../../../src/plugins/chromium-plugin.vala"
		(_data_->folders == NULL) ? NULL : (_data_->folders = (g_list_free (_data_->folders), NULL));
#line 181 "../../../src/plugins/chromium-plugin.vala"
		_g_object_unref0 (_data_->UNWANTED_SCHEME);
#line 181 "../../../src/plugins/chromium-plugin.vala"
		_g_free0 (_data_->CONTAINER);
#line 181 "../../../src/plugins/chromium-plugin.vala"
		_g_free0 (_data_->fpath);
#line 181 "../../../src/plugins/chromium-plugin.vala"
		_g_object_unref0 (_data_->parser);
#line 181 "../../../src/plugins/chromium-plugin.vala"
		_g_object_unref0 (_data_->bookmarks);
#line 181 "../../../src/plugins/chromium-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 181 "../../../src/plugins/chromium-plugin.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 181 "../../../src/plugins/chromium-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 181 "../../../src/plugins/chromium-plugin.vala"
		return FALSE;
#line 1312 "chromium-plugin.c"
	}
#line 215 "../../../src/plugins/chromium-plugin.vala"
	_data_->_tmp56_ = _data_->self->priv->bookmarks_once;
#line 215 "../../../src/plugins/chromium-plugin.vala"
	_data_->_tmp57_ = _data_->bookmarks;
#line 215 "../../../src/plugins/chromium-plugin.vala"
	synapse_utils_async_once_leave (_data_->_tmp56_, (GeeList*) _data_->_tmp57_);
#line 163 "../../../src/plugins/chromium-plugin.vala"
	(_data_->folders == NULL) ? NULL : (_data_->folders = (g_list_free (_data_->folders), NULL));
#line 163 "../../../src/plugins/chromium-plugin.vala"
	_g_object_unref0 (_data_->UNWANTED_SCHEME);
#line 163 "../../../src/plugins/chromium-plugin.vala"
	_g_free0 (_data_->CONTAINER);
#line 163 "../../../src/plugins/chromium-plugin.vala"
	_g_free0 (_data_->fpath);
#line 163 "../../../src/plugins/chromium-plugin.vala"
	_g_object_unref0 (_data_->parser);
#line 163 "../../../src/plugins/chromium-plugin.vala"
	_g_object_unref0 (_data_->bookmarks);
#line 163 "../../../src/plugins/chromium-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 163 "../../../src/plugins/chromium-plugin.vala"
	if (_data_->_state_ != 0) {
#line 163 "../../../src/plugins/chromium-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 163 "../../../src/plugins/chromium-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1340 "chromium-plugin.c"
		}
	}
#line 163 "../../../src/plugins/chromium-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 163 "../../../src/plugins/chromium-plugin.vala"
	return FALSE;
#line 1347 "chromium-plugin.c"
}

SynapseChromiumPlugin*
synapse_chromium_plugin_construct (GType object_type)
{
	SynapseChromiumPlugin * self = NULL;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	self = (SynapseChromiumPlugin*) g_object_new (object_type, NULL);
#line 21 "../../../src/plugins/chromium-plugin.vala"
	return self;
#line 1358 "chromium-plugin.c"
}

SynapseChromiumPlugin*
synapse_chromium_plugin_new (void)
{
#line 21 "../../../src/plugins/chromium-plugin.vala"
	return synapse_chromium_plugin_construct (SYNAPSE_TYPE_CHROMIUM_PLUGIN);
#line 1366 "chromium-plugin.c"
}

static gboolean
synapse_chromium_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseChromiumPlugin* self;
#line 23 "../../../src/plugins/chromium-plugin.vala"
	self = (SynapseChromiumPlugin*) base;
#line 23 "../../../src/plugins/chromium-plugin.vala"
	result = self->priv->_enabled;
#line 23 "../../../src/plugins/chromium-plugin.vala"
	return result;
#line 1380 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_real_set_enabled (SynapseActivatable* base,
                                          gboolean value)
{
	SynapseChromiumPlugin* self;
	gboolean old_value;
#line 23 "../../../src/plugins/chromium-plugin.vala"
	self = (SynapseChromiumPlugin*) base;
#line 23 "../../../src/plugins/chromium-plugin.vala"
	old_value = synapse_chromium_plugin_real_get_enabled (base);
#line 23 "../../../src/plugins/chromium-plugin.vala"
	if (old_value != value) {
#line 23 "../../../src/plugins/chromium-plugin.vala"
		self->priv->_enabled = value;
#line 23 "../../../src/plugins/chromium-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_chromium_plugin_properties[SYNAPSE_CHROMIUM_PLUGIN_ENABLED_PROPERTY]);
#line 1399 "chromium-plugin.c"
	}
}

static inline gpointer
synapse_chromium_plugin_bookmark_match_get_instance_private (SynapseChromiumPluginBookmarkMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseChromiumPluginBookmarkMatch_private_offset);
}

static const gchar*
synapse_chromium_plugin_bookmark_match_get_title_folded (SynapseChromiumPluginBookmarkMatch* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	const gchar* result = NULL;
#line 40 "../../../src/plugins/chromium-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "../../../src/plugins/chromium-plugin.vala"
	_tmp0_ = self->priv->title_folded;
#line 42 "../../../src/plugins/chromium-plugin.vala"
	if (_tmp0_ == NULL) {
#line 1421 "chromium-plugin.c"
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 42 "../../../src/plugins/chromium-plugin.vala"
		_tmp1_ = synapse_match_get_title ((SynapseMatch*) self);
#line 42 "../../../src/plugins/chromium-plugin.vala"
		_tmp2_ = _tmp1_;
#line 42 "../../../src/plugins/chromium-plugin.vala"
		_tmp3_ = g_utf8_casefold (_tmp2_, (gssize) -1);
#line 42 "../../../src/plugins/chromium-plugin.vala"
		_g_free0 (self->priv->title_folded);
#line 42 "../../../src/plugins/chromium-plugin.vala"
		self->priv->title_folded = _tmp3_;
#line 1435 "chromium-plugin.c"
	}
#line 43 "../../../src/plugins/chromium-plugin.vala"
	_tmp4_ = self->priv->title_folded;
#line 43 "../../../src/plugins/chromium-plugin.vala"
	result = _tmp4_;
#line 43 "../../../src/plugins/chromium-plugin.vala"
	return result;
#line 1443 "chromium-plugin.c"
}

static const gchar*
synapse_chromium_plugin_bookmark_match_get_uri_folded (SynapseChromiumPluginBookmarkMatch* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	const gchar* result = NULL;
#line 46 "../../../src/plugins/chromium-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 48 "../../../src/plugins/chromium-plugin.vala"
	_tmp0_ = self->priv->uri_folded;
#line 48 "../../../src/plugins/chromium-plugin.vala"
	if (_tmp0_ == NULL) {
#line 1458 "chromium-plugin.c"
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 48 "../../../src/plugins/chromium-plugin.vala"
		_tmp1_ = synapse_uri_match_get_uri ((SynapseUriMatch*) self);
#line 48 "../../../src/plugins/chromium-plugin.vala"
		_tmp2_ = _tmp1_;
#line 48 "../../../src/plugins/chromium-plugin.vala"
		_tmp3_ = g_utf8_casefold (_tmp2_, (gssize) -1);
#line 48 "../../../src/plugins/chromium-plugin.vala"
		_g_free0 (self->priv->uri_folded);
#line 48 "../../../src/plugins/chromium-plugin.vala"
		self->priv->uri_folded = _tmp3_;
#line 1472 "chromium-plugin.c"
	}
#line 49 "../../../src/plugins/chromium-plugin.vala"
	_tmp4_ = self->priv->uri_folded;
#line 49 "../../../src/plugins/chromium-plugin.vala"
	result = _tmp4_;
#line 49 "../../../src/plugins/chromium-plugin.vala"
	return result;
#line 1480 "chromium-plugin.c"
}

static SynapseChromiumPluginBookmarkMatch*
synapse_chromium_plugin_bookmark_match_construct_with_content (GType object_type,
                                                               const gchar* name,
                                                               const gchar* url)
{
	SynapseChromiumPluginBookmarkMatch * self = NULL;
#line 52 "../../../src/plugins/chromium-plugin.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 52 "../../../src/plugins/chromium-plugin.vala"
	g_return_val_if_fail (url != NULL, NULL);
#line 54 "../../../src/plugins/chromium-plugin.vala"
	self = (SynapseChromiumPluginBookmarkMatch*) g_object_new (object_type, "title", name, "description", url, "uri", url, "mime-type", "text/html", "has-thumbnail", FALSE, "icon-name", "text-html", NULL);
#line 52 "../../../src/plugins/chromium-plugin.vala"
	return self;
#line 1497 "chromium-plugin.c"
}

static SynapseChromiumPluginBookmarkMatch*
synapse_chromium_plugin_bookmark_match_new_with_content (const gchar* name,
                                                         const gchar* url)
{
#line 52 "../../../src/plugins/chromium-plugin.vala"
	return synapse_chromium_plugin_bookmark_match_construct_with_content (SYNAPSE_CHROMIUM_PLUGIN_TYPE_BOOKMARK_MATCH, name, url);
#line 1506 "chromium-plugin.c"
}

static SynapseChromiumPluginBookmarkMatch*
synapse_chromium_plugin_bookmark_match_construct (GType object_type)
{
	SynapseChromiumPluginBookmarkMatch * self = NULL;
#line 35 "../../../src/plugins/chromium-plugin.vala"
	self = (SynapseChromiumPluginBookmarkMatch*) synapse_uri_match_construct (object_type);
#line 35 "../../../src/plugins/chromium-plugin.vala"
	return self;
#line 1517 "chromium-plugin.c"
}

static SynapseChromiumPluginBookmarkMatch*
synapse_chromium_plugin_bookmark_match_new (void)
{
#line 35 "../../../src/plugins/chromium-plugin.vala"
	return synapse_chromium_plugin_bookmark_match_construct (SYNAPSE_CHROMIUM_PLUGIN_TYPE_BOOKMARK_MATCH);
#line 1525 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_bookmark_match_class_init (SynapseChromiumPluginBookmarkMatchClass * klass,
                                                   gpointer klass_data)
{
#line 35 "../../../src/plugins/chromium-plugin.vala"
	synapse_chromium_plugin_bookmark_match_parent_class = g_type_class_peek_parent (klass);
#line 35 "../../../src/plugins/chromium-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseChromiumPluginBookmarkMatch_private_offset);
#line 35 "../../../src/plugins/chromium-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_chromium_plugin_bookmark_match_finalize;
#line 1538 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_bookmark_match_instance_init (SynapseChromiumPluginBookmarkMatch * self,
                                                      gpointer klass)
{
#line 35 "../../../src/plugins/chromium-plugin.vala"
	self->priv = synapse_chromium_plugin_bookmark_match_get_instance_private (self);
#line 37 "../../../src/plugins/chromium-plugin.vala"
	self->priv->title_folded = NULL;
#line 38 "../../../src/plugins/chromium-plugin.vala"
	self->priv->uri_folded = NULL;
#line 1551 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_bookmark_match_finalize (GObject * obj)
{
	SynapseChromiumPluginBookmarkMatch * self;
#line 35 "../../../src/plugins/chromium-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_CHROMIUM_PLUGIN_TYPE_BOOKMARK_MATCH, SynapseChromiumPluginBookmarkMatch);
#line 37 "../../../src/plugins/chromium-plugin.vala"
	_g_free0 (self->priv->title_folded);
#line 38 "../../../src/plugins/chromium-plugin.vala"
	_g_free0 (self->priv->uri_folded);
#line 35 "../../../src/plugins/chromium-plugin.vala"
	G_OBJECT_CLASS (synapse_chromium_plugin_bookmark_match_parent_class)->finalize (obj);
#line 1566 "chromium-plugin.c"
}

static GType
synapse_chromium_plugin_bookmark_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseChromiumPluginBookmarkMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_chromium_plugin_bookmark_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseChromiumPluginBookmarkMatch), 0, (GInstanceInitFunc) synapse_chromium_plugin_bookmark_match_instance_init, NULL };
	GType synapse_chromium_plugin_bookmark_match_type_id;
	synapse_chromium_plugin_bookmark_match_type_id = g_type_register_static (SYNAPSE_TYPE_URI_MATCH, "SynapseChromiumPluginBookmarkMatch", &g_define_type_info, 0);
	SynapseChromiumPluginBookmarkMatch_private_offset = g_type_add_instance_private (synapse_chromium_plugin_bookmark_match_type_id, sizeof (SynapseChromiumPluginBookmarkMatchPrivate));
	return synapse_chromium_plugin_bookmark_match_type_id;
}

static GType
synapse_chromium_plugin_bookmark_match_get_type (void)
{
	static volatile gsize synapse_chromium_plugin_bookmark_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_chromium_plugin_bookmark_match_type_id__volatile)) {
		GType synapse_chromium_plugin_bookmark_match_type_id;
		synapse_chromium_plugin_bookmark_match_type_id = synapse_chromium_plugin_bookmark_match_get_type_once ();
		g_once_init_leave (&synapse_chromium_plugin_bookmark_match_type_id__volatile, synapse_chromium_plugin_bookmark_match_type_id);
	}
	return synapse_chromium_plugin_bookmark_match_type_id__volatile;
}

static GObject *
synapse_chromium_plugin_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseChromiumPlugin * self;
	SynapseUtilsAsyncOnce* _tmp0_;
#line 82 "../../../src/plugins/chromium-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_chromium_plugin_parent_class);
#line 82 "../../../src/plugins/chromium-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 82 "../../../src/plugins/chromium-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_CHROMIUM_PLUGIN, SynapseChromiumPlugin);
#line 84 "../../../src/plugins/chromium-plugin.vala"
	_tmp0_ = synapse_utils_async_once_new (GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref);
#line 84 "../../../src/plugins/chromium-plugin.vala"
	_synapse_utils_async_once_unref0 (self->priv->bookmarks_once);
#line 84 "../../../src/plugins/chromium-plugin.vala"
	self->priv->bookmarks_once = _tmp0_;
#line 82 "../../../src/plugins/chromium-plugin.vala"
	return obj;
#line 1614 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_class_init (SynapseChromiumPluginClass * klass,
                                    gpointer klass_data)
{
#line 21 "../../../src/plugins/chromium-plugin.vala"
	synapse_chromium_plugin_parent_class = g_type_class_peek_parent (klass);
#line 21 "../../../src/plugins/chromium-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseChromiumPlugin_private_offset);
#line 21 "../../../src/plugins/chromium-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_chromium_plugin_get_property;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_chromium_plugin_set_property;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_chromium_plugin_constructor;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_chromium_plugin_finalize;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_CHROMIUM_PLUGIN_ENABLED_PROPERTY, synapse_chromium_plugin_properties[SYNAPSE_CHROMIUM_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 77 "../../../src/plugins/chromium-plugin.vala"
	synapse_chromium_plugin_register_plugin ();
#line 1637 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                            gpointer iface_data)
{
#line 21 "../../../src/plugins/chromium-plugin.vala"
	synapse_chromium_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 21 "../../../src/plugins/chromium-plugin.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_chromium_plugin_real_activate;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_chromium_plugin_real_deactivate;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	iface->get_enabled = synapse_chromium_plugin_real_get_enabled;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	iface->set_enabled = synapse_chromium_plugin_real_set_enabled;
#line 1654 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                              gpointer iface_data)
{
#line 21 "../../../src/plugins/chromium-plugin.vala"
	synapse_chromium_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 21 "../../../src/plugins/chromium-plugin.vala"
	iface->handles_query = (gboolean (*) (SynapseItemProvider*, SynapseQuery*)) synapse_chromium_plugin_real_handles_query;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_chromium_plugin_real_search;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_chromium_plugin_search_finish;
#line 1669 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_instance_init (SynapseChromiumPlugin * self,
                                       gpointer klass)
{
#line 21 "../../../src/plugins/chromium-plugin.vala"
	self->priv = synapse_chromium_plugin_get_instance_private (self);
#line 23 "../../../src/plugins/chromium-plugin.vala"
	self->priv->_enabled = TRUE;
#line 1680 "chromium-plugin.c"
}

static void
synapse_chromium_plugin_finalize (GObject * obj)
{
	SynapseChromiumPlugin * self;
#line 21 "../../../src/plugins/chromium-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_CHROMIUM_PLUGIN, SynapseChromiumPlugin);
#line 80 "../../../src/plugins/chromium-plugin.vala"
	_synapse_utils_async_once_unref0 (self->priv->bookmarks_once);
#line 21 "../../../src/plugins/chromium-plugin.vala"
	G_OBJECT_CLASS (synapse_chromium_plugin_parent_class)->finalize (obj);
#line 1693 "chromium-plugin.c"
}

static GType
synapse_chromium_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseChromiumPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_chromium_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseChromiumPlugin), 0, (GInstanceInitFunc) synapse_chromium_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_chromium_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_chromium_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_chromium_plugin_type_id;
	synapse_chromium_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseChromiumPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_chromium_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_chromium_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseChromiumPlugin_private_offset = g_type_add_instance_private (synapse_chromium_plugin_type_id, sizeof (SynapseChromiumPluginPrivate));
	return synapse_chromium_plugin_type_id;
}

GType
synapse_chromium_plugin_get_type (void)
{
	static volatile gsize synapse_chromium_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_chromium_plugin_type_id__volatile)) {
		GType synapse_chromium_plugin_type_id;
		synapse_chromium_plugin_type_id = synapse_chromium_plugin_get_type_once ();
		g_once_init_leave (&synapse_chromium_plugin_type_id__volatile, synapse_chromium_plugin_type_id);
	}
	return synapse_chromium_plugin_type_id__volatile;
}

static void
_vala_synapse_chromium_plugin_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	SynapseChromiumPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_CHROMIUM_PLUGIN, SynapseChromiumPlugin);
#line 21 "../../../src/plugins/chromium-plugin.vala"
	switch (property_id) {
#line 21 "../../../src/plugins/chromium-plugin.vala"
		case SYNAPSE_CHROMIUM_PLUGIN_ENABLED_PROPERTY:
#line 21 "../../../src/plugins/chromium-plugin.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 21 "../../../src/plugins/chromium-plugin.vala"
		break;
#line 1738 "chromium-plugin.c"
		default:
#line 21 "../../../src/plugins/chromium-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "../../../src/plugins/chromium-plugin.vala"
		break;
#line 1744 "chromium-plugin.c"
	}
}

static void
_vala_synapse_chromium_plugin_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	SynapseChromiumPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_CHROMIUM_PLUGIN, SynapseChromiumPlugin);
#line 21 "../../../src/plugins/chromium-plugin.vala"
	switch (property_id) {
#line 21 "../../../src/plugins/chromium-plugin.vala"
		case SYNAPSE_CHROMIUM_PLUGIN_ENABLED_PROPERTY:
#line 21 "../../../src/plugins/chromium-plugin.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 21 "../../../src/plugins/chromium-plugin.vala"
		break;
#line 1764 "chromium-plugin.c"
		default:
#line 21 "../../../src/plugins/chromium-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "../../../src/plugins/chromium-plugin.vala"
		break;
#line 1770 "chromium-plugin.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

