/* command-plugin.c generated by valac 0.48.17, the Vala compiler
 * generated from command-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib-object.h>
#include <synapse-core.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

#define SYNAPSE_TYPE_COMMAND_PLUGIN (synapse_command_plugin_get_type ())
#define SYNAPSE_COMMAND_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin))
#define SYNAPSE_COMMAND_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPluginClass))
#define SYNAPSE_IS_COMMAND_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_COMMAND_PLUGIN))
#define SYNAPSE_IS_COMMAND_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_COMMAND_PLUGIN))
#define SYNAPSE_COMMAND_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPluginClass))

typedef struct _SynapseCommandPlugin SynapseCommandPlugin;
typedef struct _SynapseCommandPluginClass SynapseCommandPluginClass;
typedef struct _SynapseCommandPluginPrivate SynapseCommandPluginPrivate;
enum  {
	SYNAPSE_COMMAND_PLUGIN_0_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_command_plugin_properties[SYNAPSE_COMMAND_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT (synapse_command_plugin_command_object_get_type ())
#define SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObject))
#define SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObjectClass))
#define SYNAPSE_COMMAND_PLUGIN_IS_COMMAND_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT))
#define SYNAPSE_COMMAND_PLUGIN_IS_COMMAND_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT))
#define SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObjectClass))

typedef struct _SynapseCommandPluginCommandObject SynapseCommandPluginCommandObject;
typedef struct _SynapseCommandPluginCommandObjectClass SynapseCommandPluginCommandObjectClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SynapseCommandPluginSearchData SynapseCommandPluginSearchData;
typedef struct _SynapseCommandPluginCommandObjectPrivate SynapseCommandPluginCommandObjectPrivate;
enum  {
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_0_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NUM_PROPERTIES
};
static GParamSpec* synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SynapseCommandPlugin {
	GObject parent_instance;
	SynapseCommandPluginPrivate * priv;
};

struct _SynapseCommandPluginClass {
	GObjectClass parent_class;
};

struct _SynapseCommandPluginPrivate {
	gboolean _enabled;
	GeeSet* past_commands;
	GRegex* split_regex;
};

struct _SynapseCommandPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseCommandPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	SynapseQuery _tmp0_;
	SynapseQueryFlags _tmp1_;
	SynapseResultSet* _result_;
	SynapseResultSet* _tmp2_;
	gchar* stripped;
	SynapseQuery _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GeeSet* _tmp11_;
	const gchar* _tmp12_;
	GeeIterator* _command_it;
	GeeSet* _tmp13_;
	GeeIterator* _tmp14_;
	GeeIterator* _tmp15_;
	gchar* command;
	GeeIterator* _tmp16_;
	gpointer _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	SynapseResultSet* _tmp20_;
	const gchar* _tmp21_;
	SynapseCommandPluginCommandObject* _tmp22_;
	SynapseCommandPluginCommandObject* _tmp23_;
	gchar** args;
	GRegex* _tmp24_;
	const gchar* _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gint args_length1;
	gint _args_size_;
	gchar* valid_cmd;
	gchar** _tmp28_;
	gint _tmp28__length1;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length1;
	const gchar* _tmp33_;
	SynapseCommandPluginCommandObject* co;
	const gchar* _tmp34_;
	SynapseCommandPluginCommandObject* _tmp35_;
	SynapseCommandPluginCommandObject* _tmp36_;
	SynapseResultSet* _tmp37_;
	SynapseCommandPluginCommandObject* _tmp38_;
	SynapseCommandPluginCommandObject* _tmp39_;
	SynapseResultSet* _tmp40_;
	const gchar* _tmp41_;
	SynapseCommandPluginCommandObject* _tmp42_;
	SynapseCommandPluginCommandObject* _tmp43_;
	GError* _inner_error0_;
};

struct _SynapseCommandPluginCommandObject {
	SynapseApplicationMatch parent_instance;
	SynapseCommandPluginCommandObjectPrivate * priv;
};

struct _SynapseCommandPluginCommandObjectClass {
	SynapseApplicationMatchClass parent_class;
};

struct _SynapseCommandPluginCommandObjectPrivate {
	gchar* _command;
};

static gint SynapseCommandPlugin_private_offset;
static gpointer synapse_command_plugin_parent_class = NULL;
static gint SynapseCommandPluginCommandObject_private_offset;
static gpointer synapse_command_plugin_command_object_parent_class = NULL;
static SynapseActivatableIface * synapse_command_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_command_plugin_synapse_item_provider_parent_iface = NULL;

GType synapse_command_plugin_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseCommandPlugin, g_object_unref)
static void synapse_command_plugin_real_activate (SynapseActivatable* base);
static void synapse_command_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_command_plugin_register_plugin (void);
static void _synapse_command_plugin_register_plugin_synapse_plugin_register_func (void);
static GType synapse_command_plugin_command_object_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseCommandPluginCommandObject, g_object_unref)
static SynapseCommandPluginCommandObject* synapse_command_plugin_create_co (SynapseCommandPlugin* self,
                                                                     const gchar* exec);
static SynapseCommandPluginCommandObject* synapse_command_plugin_command_object_new (const gchar* cmd);
static SynapseCommandPluginCommandObject* synapse_command_plugin_command_object_construct (GType object_type,
                                                                                    const gchar* cmd);
static void synapse_command_plugin_command_executed (SynapseCommandPlugin* self,
                                              SynapseMatch* match);
static const gchar* synapse_command_plugin_command_object_get_command (SynapseCommandPluginCommandObject* self);
static void synapse_command_plugin_real_search_data_free (gpointer _data);
static void synapse_command_plugin_real_search (SynapseItemProvider* base,
                                         SynapseQuery* q,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static gboolean synapse_command_plugin_real_search_co (SynapseCommandPluginSearchData* _data_);
static gboolean _synapse_command_plugin_real_search_co_gsource_func (gpointer self);
static void _synapse_command_plugin_command_executed_synapse_match_executed (SynapseMatch* _sender,
                                                                      gpointer self);
SynapseCommandPlugin* synapse_command_plugin_new (void);
SynapseCommandPlugin* synapse_command_plugin_construct (GType object_type);
static void synapse_command_plugin_command_object_set_command (SynapseCommandPluginCommandObject* self,
                                                        const gchar* value);
static void synapse_command_plugin_command_object_finalize (GObject * obj);
static GType synapse_command_plugin_command_object_get_type_once (void);
static void _vala_synapse_command_plugin_command_object_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec);
static void _vala_synapse_command_plugin_command_object_set_property (GObject * object,
                                                               guint property_id,
                                                               const GValue * value,
                                                               GParamSpec * pspec);
static GObject * synapse_command_plugin_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void synapse_command_plugin_finalize (GObject * obj);
static GType synapse_command_plugin_get_type_once (void);
static void _vala_synapse_command_plugin_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_synapse_command_plugin_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
synapse_command_plugin_get_instance_private (SynapseCommandPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCommandPlugin_private_offset);
}

static void
synapse_command_plugin_real_activate (SynapseActivatable* base)
{
	SynapseCommandPlugin * self;
#line 28 "../../../src/plugins/command-plugin.vala"
	self = (SynapseCommandPlugin*) base;
#line 247 "command-plugin.c"
}

static void
synapse_command_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseCommandPlugin * self;
#line 33 "../../../src/plugins/command-plugin.vala"
	self = (SynapseCommandPlugin*) base;
#line 256 "command-plugin.c"
}

static void
_synapse_command_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 61 "../../../src/plugins/command-plugin.vala"
	synapse_command_plugin_register_plugin ();
#line 264 "command-plugin.c"
}

static void
synapse_command_plugin_register_plugin (void)
{
	SynapsePluginRegistry* _tmp0_;
	SynapsePluginRegistry* _tmp1_;
#line 61 "../../../src/plugins/command-plugin.vala"
	_tmp0_ = synapse_plugin_registry_get_default ();
#line 61 "../../../src/plugins/command-plugin.vala"
	_tmp1_ = _tmp0_;
#line 61 "../../../src/plugins/command-plugin.vala"
	synapse_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_COMMAND_PLUGIN, "Command Search", _ ("Find and execute arbitrary commands."), "system-run", _synapse_command_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
#line 61 "../../../src/plugins/command-plugin.vala"
	_g_object_unref0 (_tmp1_);
#line 280 "command-plugin.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 100 "../../../src/plugins/command-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 288 "command-plugin.c"
}

static SynapseCommandPluginCommandObject*
synapse_command_plugin_create_co (SynapseCommandPlugin* self,
                                  const gchar* exec)
{
	SynapseDesktopFileService* dfs = NULL;
	SynapseDesktopFileService* _tmp0_;
	GeeList* df_list = NULL;
	SynapseDesktopFileService* _tmp1_;
	GeeList* _tmp2_;
	SynapseDesktopFileInfo* dfi = NULL;
	SynapseCommandPluginCommandObject* co = NULL;
	SynapseCommandPluginCommandObject* _tmp17_;
	SynapseDesktopFileInfo* _tmp18_;
	SynapseCommandPluginCommandObject* result = NULL;
#line 92 "../../../src/plugins/command-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 92 "../../../src/plugins/command-plugin.vala"
	g_return_val_if_fail (exec != NULL, NULL);
#line 97 "../../../src/plugins/command-plugin.vala"
	_tmp0_ = synapse_desktop_file_service_get_default ();
#line 97 "../../../src/plugins/command-plugin.vala"
	dfs = _tmp0_;
#line 98 "../../../src/plugins/command-plugin.vala"
	_tmp1_ = dfs;
#line 98 "../../../src/plugins/command-plugin.vala"
	_tmp2_ = synapse_desktop_file_service_get_desktop_files_for_exec (_tmp1_, exec);
#line 98 "../../../src/plugins/command-plugin.vala"
	df_list = _tmp2_;
#line 99 "../../../src/plugins/command-plugin.vala"
	dfi = NULL;
#line 321 "command-plugin.c"
	{
		GeeList* _df_list = NULL;
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		gint _df_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _df_index = 0;
#line 100 "../../../src/plugins/command-plugin.vala"
		_tmp3_ = df_list;
#line 100 "../../../src/plugins/command-plugin.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 100 "../../../src/plugins/command-plugin.vala"
		_df_list = _tmp4_;
#line 100 "../../../src/plugins/command-plugin.vala"
		_tmp5_ = _df_list;
#line 100 "../../../src/plugins/command-plugin.vala"
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
#line 100 "../../../src/plugins/command-plugin.vala"
		_tmp7_ = _tmp6_;
#line 100 "../../../src/plugins/command-plugin.vala"
		_df_size = _tmp7_;
#line 100 "../../../src/plugins/command-plugin.vala"
		_df_index = -1;
#line 100 "../../../src/plugins/command-plugin.vala"
		while (TRUE) {
#line 349 "command-plugin.c"
			gint _tmp8_;
			gint _tmp9_;
			SynapseDesktopFileInfo* df = NULL;
			GeeList* _tmp10_;
			gpointer _tmp11_;
			SynapseDesktopFileInfo* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_;
			SynapseDesktopFileInfo* _tmp15_;
			SynapseDesktopFileInfo* _tmp16_;
#line 100 "../../../src/plugins/command-plugin.vala"
			_df_index = _df_index + 1;
#line 100 "../../../src/plugins/command-plugin.vala"
			_tmp8_ = _df_index;
#line 100 "../../../src/plugins/command-plugin.vala"
			_tmp9_ = _df_size;
#line 100 "../../../src/plugins/command-plugin.vala"
			if (!(_tmp8_ < _tmp9_)) {
#line 100 "../../../src/plugins/command-plugin.vala"
				break;
#line 370 "command-plugin.c"
			}
#line 100 "../../../src/plugins/command-plugin.vala"
			_tmp10_ = _df_list;
#line 100 "../../../src/plugins/command-plugin.vala"
			_tmp11_ = gee_list_get (_tmp10_, _df_index);
#line 100 "../../../src/plugins/command-plugin.vala"
			df = (SynapseDesktopFileInfo*) _tmp11_;
#line 102 "../../../src/plugins/command-plugin.vala"
			_tmp12_ = df;
#line 102 "../../../src/plugins/command-plugin.vala"
			_tmp13_ = synapse_desktop_file_info_get_is_hidden (_tmp12_);
#line 102 "../../../src/plugins/command-plugin.vala"
			_tmp14_ = _tmp13_;
#line 102 "../../../src/plugins/command-plugin.vala"
			if (!_tmp14_) {
#line 102 "../../../src/plugins/command-plugin.vala"
				result = NULL;
#line 102 "../../../src/plugins/command-plugin.vala"
				_g_object_unref0 (df);
#line 102 "../../../src/plugins/command-plugin.vala"
				_g_object_unref0 (_df_list);
#line 102 "../../../src/plugins/command-plugin.vala"
				_g_object_unref0 (dfi);
#line 102 "../../../src/plugins/command-plugin.vala"
				_g_object_unref0 (df_list);
#line 102 "../../../src/plugins/command-plugin.vala"
				_g_object_unref0 (dfs);
#line 102 "../../../src/plugins/command-plugin.vala"
				return result;
#line 400 "command-plugin.c"
			}
#line 103 "../../../src/plugins/command-plugin.vala"
			_tmp15_ = df;
#line 103 "../../../src/plugins/command-plugin.vala"
			_tmp16_ = _g_object_ref0 (_tmp15_);
#line 103 "../../../src/plugins/command-plugin.vala"
			_g_object_unref0 (dfi);
#line 103 "../../../src/plugins/command-plugin.vala"
			dfi = _tmp16_;
#line 100 "../../../src/plugins/command-plugin.vala"
			_g_object_unref0 (df);
#line 412 "command-plugin.c"
		}
#line 100 "../../../src/plugins/command-plugin.vala"
		_g_object_unref0 (_df_list);
#line 416 "command-plugin.c"
	}
#line 106 "../../../src/plugins/command-plugin.vala"
	_tmp17_ = synapse_command_plugin_command_object_new (exec);
#line 106 "../../../src/plugins/command-plugin.vala"
	co = _tmp17_;
#line 107 "../../../src/plugins/command-plugin.vala"
	_tmp18_ = dfi;
#line 107 "../../../src/plugins/command-plugin.vala"
	if (_tmp18_ != NULL) {
#line 426 "command-plugin.c"
		SynapseCommandPluginCommandObject* _tmp19_;
		SynapseDesktopFileInfo* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		SynapseDesktopFileInfo* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gboolean _tmp30_ = FALSE;
		SynapseDesktopFileInfo* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
#line 109 "../../../src/plugins/command-plugin.vala"
		_tmp19_ = co;
#line 109 "../../../src/plugins/command-plugin.vala"
		_tmp20_ = dfi;
#line 109 "../../../src/plugins/command-plugin.vala"
		_tmp21_ = synapse_desktop_file_info_get_name (_tmp20_);
#line 109 "../../../src/plugins/command-plugin.vala"
		_tmp22_ = _tmp21_;
#line 109 "../../../src/plugins/command-plugin.vala"
		synapse_match_set_title ((SynapseMatch*) _tmp19_, _tmp22_);
#line 110 "../../../src/plugins/command-plugin.vala"
		_tmp23_ = dfi;
#line 110 "../../../src/plugins/command-plugin.vala"
		_tmp24_ = synapse_desktop_file_info_get_comment (_tmp23_);
#line 110 "../../../src/plugins/command-plugin.vala"
		_tmp25_ = _tmp24_;
#line 110 "../../../src/plugins/command-plugin.vala"
		if (g_strcmp0 (_tmp25_, "") != 0) {
#line 456 "command-plugin.c"
			SynapseCommandPluginCommandObject* _tmp26_;
			SynapseDesktopFileInfo* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
#line 110 "../../../src/plugins/command-plugin.vala"
			_tmp26_ = co;
#line 110 "../../../src/plugins/command-plugin.vala"
			_tmp27_ = dfi;
#line 110 "../../../src/plugins/command-plugin.vala"
			_tmp28_ = synapse_desktop_file_info_get_comment (_tmp27_);
#line 110 "../../../src/plugins/command-plugin.vala"
			_tmp29_ = _tmp28_;
#line 110 "../../../src/plugins/command-plugin.vala"
			synapse_match_set_description ((SynapseMatch*) _tmp26_, _tmp29_);
#line 471 "command-plugin.c"
		}
#line 111 "../../../src/plugins/command-plugin.vala"
		_tmp31_ = dfi;
#line 111 "../../../src/plugins/command-plugin.vala"
		_tmp32_ = synapse_desktop_file_info_get_icon_name (_tmp31_);
#line 111 "../../../src/plugins/command-plugin.vala"
		_tmp33_ = _tmp32_;
#line 111 "../../../src/plugins/command-plugin.vala"
		if (_tmp33_ != NULL) {
#line 481 "command-plugin.c"
			SynapseDesktopFileInfo* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
#line 111 "../../../src/plugins/command-plugin.vala"
			_tmp34_ = dfi;
#line 111 "../../../src/plugins/command-plugin.vala"
			_tmp35_ = synapse_desktop_file_info_get_icon_name (_tmp34_);
#line 111 "../../../src/plugins/command-plugin.vala"
			_tmp36_ = _tmp35_;
#line 111 "../../../src/plugins/command-plugin.vala"
			_tmp30_ = g_strcmp0 (_tmp36_, "") != 0;
#line 493 "command-plugin.c"
		} else {
#line 111 "../../../src/plugins/command-plugin.vala"
			_tmp30_ = FALSE;
#line 497 "command-plugin.c"
		}
#line 111 "../../../src/plugins/command-plugin.vala"
		if (_tmp30_) {
#line 501 "command-plugin.c"
			SynapseCommandPluginCommandObject* _tmp37_;
			SynapseDesktopFileInfo* _tmp38_;
			const gchar* _tmp39_;
			const gchar* _tmp40_;
#line 111 "../../../src/plugins/command-plugin.vala"
			_tmp37_ = co;
#line 111 "../../../src/plugins/command-plugin.vala"
			_tmp38_ = dfi;
#line 111 "../../../src/plugins/command-plugin.vala"
			_tmp39_ = synapse_desktop_file_info_get_icon_name (_tmp38_);
#line 111 "../../../src/plugins/command-plugin.vala"
			_tmp40_ = _tmp39_;
#line 111 "../../../src/plugins/command-plugin.vala"
			synapse_match_set_icon_name ((SynapseMatch*) _tmp37_, _tmp40_);
#line 516 "command-plugin.c"
		}
	}
#line 114 "../../../src/plugins/command-plugin.vala"
	result = co;
#line 114 "../../../src/plugins/command-plugin.vala"
	_g_object_unref0 (dfi);
#line 114 "../../../src/plugins/command-plugin.vala"
	_g_object_unref0 (df_list);
#line 114 "../../../src/plugins/command-plugin.vala"
	_g_object_unref0 (dfs);
#line 114 "../../../src/plugins/command-plugin.vala"
	return result;
#line 529 "command-plugin.c"
}

static void
synapse_command_plugin_command_executed (SynapseCommandPlugin* self,
                                         SynapseMatch* match)
{
	SynapseCommandPluginCommandObject* co = NULL;
	SynapseCommandPluginCommandObject* _tmp0_;
	GeeSet* _tmp1_;
	SynapseCommandPluginCommandObject* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
#line 117 "../../../src/plugins/command-plugin.vala"
	g_return_if_fail (self != NULL);
#line 117 "../../../src/plugins/command-plugin.vala"
	g_return_if_fail (match != NULL);
#line 119 "../../../src/plugins/command-plugin.vala"
	co = SYNAPSE_COMMAND_PLUGIN_IS_COMMAND_OBJECT (match) ? ((SynapseCommandPluginCommandObject*) match) : NULL;
#line 120 "../../../src/plugins/command-plugin.vala"
	_tmp0_ = co;
#line 120 "../../../src/plugins/command-plugin.vala"
	if (_tmp0_ == NULL) {
#line 120 "../../../src/plugins/command-plugin.vala"
		return;
#line 554 "command-plugin.c"
	}
#line 122 "../../../src/plugins/command-plugin.vala"
	_tmp1_ = self->priv->past_commands;
#line 122 "../../../src/plugins/command-plugin.vala"
	_tmp2_ = co;
#line 122 "../../../src/plugins/command-plugin.vala"
	_tmp3_ = synapse_command_plugin_command_object_get_command (_tmp2_);
#line 122 "../../../src/plugins/command-plugin.vala"
	_tmp4_ = _tmp3_;
#line 122 "../../../src/plugins/command-plugin.vala"
	gee_collection_add ((GeeCollection*) _tmp1_, _tmp4_);
#line 566 "command-plugin.c"
}

static void
synapse_command_plugin_real_search_data_free (gpointer _data)
{
	SynapseCommandPluginSearchData* _data_;
	_data_ = _data;
#line 24 "../../../src/plugins/command-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "../../../src/plugins/command-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 24 "../../../src/plugins/command-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 24 "../../../src/plugins/command-plugin.vala"
	g_slice_free (SynapseCommandPluginSearchData, _data_);
#line 582 "command-plugin.c"
}

static void
synapse_command_plugin_real_search (SynapseItemProvider* base,
                                    SynapseQuery* q,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	SynapseCommandPlugin * self;
	SynapseCommandPluginSearchData* _data_;
	SynapseCommandPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
#line 24 "../../../src/plugins/command-plugin.vala"
	self = (SynapseCommandPlugin*) base;
#line 24 "../../../src/plugins/command-plugin.vala"
	_data_ = g_slice_new0 (SynapseCommandPluginSearchData);
#line 24 "../../../src/plugins/command-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "../../../src/plugins/command-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_command_plugin_real_search_data_free);
#line 24 "../../../src/plugins/command-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "../../../src/plugins/command-plugin.vala"
	_data_->self = _tmp0_;
#line 24 "../../../src/plugins/command-plugin.vala"
	_tmp1_ = *q;
#line 24 "../../../src/plugins/command-plugin.vala"
	_tmp2_ = _tmp1_;
#line 24 "../../../src/plugins/command-plugin.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 24 "../../../src/plugins/command-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "../../../src/plugins/command-plugin.vala"
	_data_->q = _tmp3_;
#line 24 "../../../src/plugins/command-plugin.vala"
	synapse_command_plugin_real_search_co (_data_);
#line 621 "command-plugin.c"
}

static SynapseResultSet*
synapse_command_plugin_search_finish (SynapseItemProvider* base,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	SynapseResultSet* result;
	SynapseCommandPluginSearchData* _data_;
#line 24 "../../../src/plugins/command-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 24 "../../../src/plugins/command-plugin.vala"
	if (NULL == _data_) {
#line 24 "../../../src/plugins/command-plugin.vala"
		return NULL;
#line 637 "command-plugin.c"
	}
#line 24 "../../../src/plugins/command-plugin.vala"
	result = _data_->result;
#line 24 "../../../src/plugins/command-plugin.vala"
	_data_->result = NULL;
#line 24 "../../../src/plugins/command-plugin.vala"
	return result;
#line 645 "command-plugin.c"
}

static gboolean
_synapse_command_plugin_real_search_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_command_plugin_real_search_co (self);
#line 130 "../../../src/plugins/command-plugin.vala"
	return result;
#line 655 "command-plugin.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
#line 1359 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1360 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1360 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1361 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1362 "glib-2.0.vapi"
	result = _result_;
#line 1362 "glib-2.0.vapi"
	return result;
#line 676 "command-plugin.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1535 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 698 "command-plugin.c"
	} else {
#line 1535 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 702 "command-plugin.c"
	}
#line 1535 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1535 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 708 "command-plugin.c"
	} else {
#line 1535 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 712 "command-plugin.c"
	}
#line 1535 "glib-2.0.vapi"
	if (_tmp0_) {
#line 716 "command-plugin.c"
		gchar* _tmp2_;
#line 1536 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1536 "glib-2.0.vapi"
		result = _tmp2_;
#line 1536 "glib-2.0.vapi"
		return result;
#line 724 "command-plugin.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1539 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1539 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1539 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1539 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1539 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1539 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1539 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1539 "glib-2.0.vapi"
			_g_free0 (_tmp7_);
#line 1539 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1539 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 756 "command-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 1539 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1539 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1539 "glib-2.0.vapi"
			return NULL;
#line 765 "command-plugin.c"
		}
#line 1540 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1540 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1540 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1540 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1540 "glib-2.0.vapi"
			_g_free0 (_tmp7_);
#line 1540 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1540 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 781 "command-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 1540 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1540 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1540 "glib-2.0.vapi"
			return NULL;
#line 790 "command-plugin.c"
		}
#line 1540 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1540 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1540 "glib-2.0.vapi"
		result = _tmp10_;
#line 1540 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1540 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1540 "glib-2.0.vapi"
		return result;
#line 804 "command-plugin.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1538 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1542 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 813 "command-plugin.c"
	}
	__finally0:
#line 1538 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1538 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1538 "glib-2.0.vapi"
	return NULL;
#line 822 "command-plugin.c"
}

static void
_synapse_command_plugin_command_executed_synapse_match_executed (SynapseMatch* _sender,
                                                                 gpointer self)
{
#line 162 "../../../src/plugins/command-plugin.vala"
	synapse_command_plugin_command_executed ((SynapseCommandPlugin*) self, _sender);
#line 831 "command-plugin.c"
}

static gboolean
synapse_command_plugin_real_search_co (SynapseCommandPluginSearchData* _data_)
{
#line 125 "../../../src/plugins/command-plugin.vala"
	switch (_data_->_state_) {
#line 125 "../../../src/plugins/command-plugin.vala"
		case 0:
#line 841 "command-plugin.c"
		goto _state_0;
#line 125 "../../../src/plugins/command-plugin.vala"
		case 1:
#line 845 "command-plugin.c"
		goto _state_1;
		default:
#line 125 "../../../src/plugins/command-plugin.vala"
		g_assert_not_reached ();
#line 850 "command-plugin.c"
	}
	_state_0:
#line 128 "../../../src/plugins/command-plugin.vala"
	_data_->_tmp0_ = _data_->q;
#line 128 "../../../src/plugins/command-plugin.vala"
	_data_->_tmp1_ = _data_->_tmp0_.query_type;
#line 128 "../../../src/plugins/command-plugin.vala"
	if (!((_data_->_tmp1_ & SYNAPSE_QUERY_FLAGS_APPLICATIONS) == SYNAPSE_QUERY_FLAGS_APPLICATIONS)) {
#line 128 "../../../src/plugins/command-plugin.vala"
		_data_->result = NULL;
#line 128 "../../../src/plugins/command-plugin.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 128 "../../../src/plugins/command-plugin.vala"
		if (_data_->_state_ != 0) {
#line 128 "../../../src/plugins/command-plugin.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 128 "../../../src/plugins/command-plugin.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 869 "command-plugin.c"
			}
		}
#line 128 "../../../src/plugins/command-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 128 "../../../src/plugins/command-plugin.vala"
		return FALSE;
#line 876 "command-plugin.c"
	}
#line 130 "../../../src/plugins/command-plugin.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _synapse_command_plugin_real_search_co_gsource_func, _data_, NULL);
#line 131 "../../../src/plugins/command-plugin.vala"
	_data_->_state_ = 1;
#line 131 "../../../src/plugins/command-plugin.vala"
	return FALSE;
#line 884 "command-plugin.c"
	_state_1:
	;
#line 133 "../../../src/plugins/command-plugin.vala"
	_data_->_tmp2_ = synapse_result_set_new ();
#line 133 "../../../src/plugins/command-plugin.vala"
	_data_->_result_ = _data_->_tmp2_;
#line 135 "../../../src/plugins/command-plugin.vala"
	_data_->_tmp3_ = _data_->q;
#line 135 "../../../src/plugins/command-plugin.vala"
	_data_->_tmp4_ = _data_->_tmp3_.query_string;
#line 135 "../../../src/plugins/command-plugin.vala"
	_data_->_tmp5_ = string_strip (_data_->_tmp4_);
#line 135 "../../../src/plugins/command-plugin.vala"
	_data_->stripped = _data_->_tmp5_;
#line 136 "../../../src/plugins/command-plugin.vala"
	_data_->_tmp6_ = _data_->stripped;
#line 136 "../../../src/plugins/command-plugin.vala"
	if (g_strcmp0 (_data_->_tmp6_, "") == 0) {
#line 136 "../../../src/plugins/command-plugin.vala"
		_data_->result = NULL;
#line 136 "../../../src/plugins/command-plugin.vala"
		_g_free0 (_data_->stripped);
#line 136 "../../../src/plugins/command-plugin.vala"
		_g_object_unref0 (_data_->_result_);
#line 136 "../../../src/plugins/command-plugin.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 136 "../../../src/plugins/command-plugin.vala"
		if (_data_->_state_ != 0) {
#line 136 "../../../src/plugins/command-plugin.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 136 "../../../src/plugins/command-plugin.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 917 "command-plugin.c"
			}
		}
#line 136 "../../../src/plugins/command-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 136 "../../../src/plugins/command-plugin.vala"
		return FALSE;
#line 924 "command-plugin.c"
	}
#line 137 "../../../src/plugins/command-plugin.vala"
	_data_->_tmp7_ = _data_->stripped;
#line 137 "../../../src/plugins/command-plugin.vala"
	if (g_str_has_prefix (_data_->_tmp7_, "~/")) {
#line 139 "../../../src/plugins/command-plugin.vala"
		_data_->_tmp8_ = _data_->stripped;
#line 139 "../../../src/plugins/command-plugin.vala"
		_data_->_tmp9_ = g_get_home_dir ();
#line 139 "../../../src/plugins/command-plugin.vala"
		_data_->_tmp10_ = string_replace (_data_->_tmp8_, "~", _data_->_tmp9_);
#line 139 "../../../src/plugins/command-plugin.vala"
		_g_free0 (_data_->stripped);
#line 139 "../../../src/plugins/command-plugin.vala"
		_data_->stripped = _data_->_tmp10_;
#line 940 "command-plugin.c"
	}
#line 142 "../../../src/plugins/command-plugin.vala"
	_data_->_tmp11_ = _data_->self->priv->past_commands;
#line 142 "../../../src/plugins/command-plugin.vala"
	_data_->_tmp12_ = _data_->stripped;
#line 142 "../../../src/plugins/command-plugin.vala"
	if (!gee_collection_contains ((GeeCollection*) _data_->_tmp11_, _data_->_tmp12_)) {
#line 948 "command-plugin.c"
		{
#line 144 "../../../src/plugins/command-plugin.vala"
			_data_->_tmp13_ = _data_->self->priv->past_commands;
#line 144 "../../../src/plugins/command-plugin.vala"
			_data_->_tmp14_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp13_);
#line 144 "../../../src/plugins/command-plugin.vala"
			_data_->_command_it = _data_->_tmp14_;
#line 144 "../../../src/plugins/command-plugin.vala"
			while (TRUE) {
#line 144 "../../../src/plugins/command-plugin.vala"
				_data_->_tmp15_ = _data_->_command_it;
#line 144 "../../../src/plugins/command-plugin.vala"
				if (!gee_iterator_next (_data_->_tmp15_)) {
#line 144 "../../../src/plugins/command-plugin.vala"
					break;
#line 964 "command-plugin.c"
				}
#line 144 "../../../src/plugins/command-plugin.vala"
				_data_->_tmp16_ = _data_->_command_it;
#line 144 "../../../src/plugins/command-plugin.vala"
				_data_->_tmp17_ = gee_iterator_get (_data_->_tmp16_);
#line 144 "../../../src/plugins/command-plugin.vala"
				_data_->command = (gchar*) _data_->_tmp17_;
#line 146 "../../../src/plugins/command-plugin.vala"
				_data_->_tmp18_ = _data_->command;
#line 146 "../../../src/plugins/command-plugin.vala"
				_data_->_tmp19_ = _data_->stripped;
#line 146 "../../../src/plugins/command-plugin.vala"
				if (g_str_has_prefix (_data_->_tmp18_, _data_->_tmp19_)) {
#line 148 "../../../src/plugins/command-plugin.vala"
					_data_->_tmp20_ = _data_->_result_;
#line 148 "../../../src/plugins/command-plugin.vala"
					_data_->_tmp21_ = _data_->command;
#line 148 "../../../src/plugins/command-plugin.vala"
					_data_->_tmp22_ = synapse_command_plugin_create_co (_data_->self, _data_->_tmp21_);
#line 148 "../../../src/plugins/command-plugin.vala"
					_data_->_tmp23_ = _data_->_tmp22_;
#line 148 "../../../src/plugins/command-plugin.vala"
					synapse_result_set_add (_data_->_tmp20_, (SynapseMatch*) _data_->_tmp23_, (gint) SYNAPSE_MATCH_SCORE_AVERAGE);
#line 148 "../../../src/plugins/command-plugin.vala"
					_g_object_unref0 (_data_->_tmp23_);
#line 990 "command-plugin.c"
				}
#line 144 "../../../src/plugins/command-plugin.vala"
				_g_free0 (_data_->command);
#line 994 "command-plugin.c"
			}
#line 144 "../../../src/plugins/command-plugin.vala"
			_g_object_unref0 (_data_->_command_it);
#line 998 "command-plugin.c"
		}
#line 152 "../../../src/plugins/command-plugin.vala"
		_data_->_tmp24_ = _data_->self->priv->split_regex;
#line 152 "../../../src/plugins/command-plugin.vala"
		_data_->_tmp25_ = _data_->stripped;
#line 152 "../../../src/plugins/command-plugin.vala"
		_data_->_tmp27_ = _data_->_tmp26_ = g_regex_split (_data_->_tmp24_, _data_->_tmp25_, 0);
#line 152 "../../../src/plugins/command-plugin.vala"
		_data_->args = _data_->_tmp27_;
#line 152 "../../../src/plugins/command-plugin.vala"
		_data_->args_length1 = _vala_array_length (_data_->_tmp26_);
#line 152 "../../../src/plugins/command-plugin.vala"
		_data_->_args_size_ = _data_->args_length1;
#line 153 "../../../src/plugins/command-plugin.vala"
		_data_->_tmp28_ = _data_->args;
#line 153 "../../../src/plugins/command-plugin.vala"
		_data_->_tmp28__length1 = _data_->args_length1;
#line 153 "../../../src/plugins/command-plugin.vala"
		_data_->_tmp29_ = _data_->_tmp28_[0];
#line 153 "../../../src/plugins/command-plugin.vala"
		_data_->_tmp30_ = g_find_program_in_path (_data_->_tmp29_);
#line 153 "../../../src/plugins/command-plugin.vala"
		_data_->valid_cmd = _data_->_tmp30_;
#line 155 "../../../src/plugins/command-plugin.vala"
		_data_->_tmp31_ = _data_->valid_cmd;
#line 155 "../../../src/plugins/command-plugin.vala"
		if (_data_->_tmp31_ != NULL) {
#line 158 "../../../src/plugins/command-plugin.vala"
			_data_->_tmp32_ = _data_->args;
#line 158 "../../../src/plugins/command-plugin.vala"
			_data_->_tmp32__length1 = _data_->args_length1;
#line 158 "../../../src/plugins/command-plugin.vala"
			_data_->_tmp33_ = _data_->_tmp32_[0];
#line 158 "../../../src/plugins/command-plugin.vala"
			if (g_strcmp0 (_data_->_tmp33_, "rm") == 0) {
#line 158 "../../../src/plugins/command-plugin.vala"
				_data_->result = NULL;
#line 158 "../../../src/plugins/command-plugin.vala"
				_g_free0 (_data_->valid_cmd);
#line 158 "../../../src/plugins/command-plugin.vala"
				_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
#line 158 "../../../src/plugins/command-plugin.vala"
				_g_free0 (_data_->stripped);
#line 158 "../../../src/plugins/command-plugin.vala"
				_g_object_unref0 (_data_->_result_);
#line 158 "../../../src/plugins/command-plugin.vala"
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 158 "../../../src/plugins/command-plugin.vala"
				if (_data_->_state_ != 0) {
#line 158 "../../../src/plugins/command-plugin.vala"
					while (!g_task_get_completed (_data_->_async_result)) {
#line 158 "../../../src/plugins/command-plugin.vala"
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1052 "command-plugin.c"
					}
				}
#line 158 "../../../src/plugins/command-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 158 "../../../src/plugins/command-plugin.vala"
				return FALSE;
#line 1059 "command-plugin.c"
			}
#line 159 "../../../src/plugins/command-plugin.vala"
			_data_->_tmp34_ = _data_->stripped;
#line 159 "../../../src/plugins/command-plugin.vala"
			_data_->_tmp35_ = synapse_command_plugin_create_co (_data_->self, _data_->_tmp34_);
#line 159 "../../../src/plugins/command-plugin.vala"
			_data_->co = _data_->_tmp35_;
#line 160 "../../../src/plugins/command-plugin.vala"
			_data_->_tmp36_ = _data_->co;
#line 160 "../../../src/plugins/command-plugin.vala"
			if (_data_->_tmp36_ == NULL) {
#line 160 "../../../src/plugins/command-plugin.vala"
				_data_->result = NULL;
#line 160 "../../../src/plugins/command-plugin.vala"
				_g_object_unref0 (_data_->co);
#line 160 "../../../src/plugins/command-plugin.vala"
				_g_free0 (_data_->valid_cmd);
#line 160 "../../../src/plugins/command-plugin.vala"
				_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
#line 160 "../../../src/plugins/command-plugin.vala"
				_g_free0 (_data_->stripped);
#line 160 "../../../src/plugins/command-plugin.vala"
				_g_object_unref0 (_data_->_result_);
#line 160 "../../../src/plugins/command-plugin.vala"
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 160 "../../../src/plugins/command-plugin.vala"
				if (_data_->_state_ != 0) {
#line 160 "../../../src/plugins/command-plugin.vala"
					while (!g_task_get_completed (_data_->_async_result)) {
#line 160 "../../../src/plugins/command-plugin.vala"
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1091 "command-plugin.c"
					}
				}
#line 160 "../../../src/plugins/command-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 160 "../../../src/plugins/command-plugin.vala"
				return FALSE;
#line 1098 "command-plugin.c"
			}
#line 161 "../../../src/plugins/command-plugin.vala"
			_data_->_tmp37_ = _data_->_result_;
#line 161 "../../../src/plugins/command-plugin.vala"
			_data_->_tmp38_ = _data_->co;
#line 161 "../../../src/plugins/command-plugin.vala"
			synapse_result_set_add (_data_->_tmp37_, (SynapseMatch*) _data_->_tmp38_, (gint) SYNAPSE_MATCH_SCORE_POOR);
#line 162 "../../../src/plugins/command-plugin.vala"
			_data_->_tmp39_ = _data_->co;
#line 162 "../../../src/plugins/command-plugin.vala"
			g_signal_connect_object ((SynapseMatch*) _data_->_tmp39_, "executed", (GCallback) _synapse_command_plugin_command_executed_synapse_match_executed, _data_->self, 0);
#line 155 "../../../src/plugins/command-plugin.vala"
			_g_object_unref0 (_data_->co);
#line 1112 "command-plugin.c"
		}
#line 142 "../../../src/plugins/command-plugin.vala"
		_g_free0 (_data_->valid_cmd);
#line 142 "../../../src/plugins/command-plugin.vala"
		_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
#line 1118 "command-plugin.c"
	} else {
#line 167 "../../../src/plugins/command-plugin.vala"
		_data_->_tmp40_ = _data_->_result_;
#line 167 "../../../src/plugins/command-plugin.vala"
		_data_->_tmp41_ = _data_->stripped;
#line 167 "../../../src/plugins/command-plugin.vala"
		_data_->_tmp42_ = synapse_command_plugin_create_co (_data_->self, _data_->_tmp41_);
#line 167 "../../../src/plugins/command-plugin.vala"
		_data_->_tmp43_ = _data_->_tmp42_;
#line 167 "../../../src/plugins/command-plugin.vala"
		synapse_result_set_add (_data_->_tmp40_, (SynapseMatch*) _data_->_tmp43_, (gint) SYNAPSE_MATCH_SCORE_VERY_GOOD);
#line 167 "../../../src/plugins/command-plugin.vala"
		_g_object_unref0 (_data_->_tmp43_);
#line 1132 "command-plugin.c"
	}
#line 170 "../../../src/plugins/command-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 170 "../../../src/plugins/command-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 170 "../../../src/plugins/command-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 170 "../../../src/plugins/command-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 170 "../../../src/plugins/command-plugin.vala"
			_g_free0 (_data_->stripped);
#line 170 "../../../src/plugins/command-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 170 "../../../src/plugins/command-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 170 "../../../src/plugins/command-plugin.vala"
			return FALSE;
#line 1150 "command-plugin.c"
		} else {
#line 170 "../../../src/plugins/command-plugin.vala"
			_g_free0 (_data_->stripped);
#line 170 "../../../src/plugins/command-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 170 "../../../src/plugins/command-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 170 "../../../src/plugins/command-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 170 "../../../src/plugins/command-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 170 "../../../src/plugins/command-plugin.vala"
			return FALSE;
#line 1164 "command-plugin.c"
		}
	}
#line 172 "../../../src/plugins/command-plugin.vala"
	_data_->result = _data_->_result_;
#line 172 "../../../src/plugins/command-plugin.vala"
	_g_free0 (_data_->stripped);
#line 172 "../../../src/plugins/command-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 172 "../../../src/plugins/command-plugin.vala"
	if (_data_->_state_ != 0) {
#line 172 "../../../src/plugins/command-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 172 "../../../src/plugins/command-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1179 "command-plugin.c"
		}
	}
#line 172 "../../../src/plugins/command-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 172 "../../../src/plugins/command-plugin.vala"
	return FALSE;
#line 1186 "command-plugin.c"
}

SynapseCommandPlugin*
synapse_command_plugin_construct (GType object_type)
{
	SynapseCommandPlugin * self = NULL;
#line 24 "../../../src/plugins/command-plugin.vala"
	self = (SynapseCommandPlugin*) g_object_new (object_type, NULL);
#line 24 "../../../src/plugins/command-plugin.vala"
	return self;
#line 1197 "command-plugin.c"
}

SynapseCommandPlugin*
synapse_command_plugin_new (void)
{
#line 24 "../../../src/plugins/command-plugin.vala"
	return synapse_command_plugin_construct (SYNAPSE_TYPE_COMMAND_PLUGIN);
#line 1205 "command-plugin.c"
}

static gboolean
synapse_command_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseCommandPlugin* self;
#line 26 "../../../src/plugins/command-plugin.vala"
	self = (SynapseCommandPlugin*) base;
#line 26 "../../../src/plugins/command-plugin.vala"
	result = self->priv->_enabled;
#line 26 "../../../src/plugins/command-plugin.vala"
	return result;
#line 1219 "command-plugin.c"
}

static void
synapse_command_plugin_real_set_enabled (SynapseActivatable* base,
                                         gboolean value)
{
	SynapseCommandPlugin* self;
	gboolean old_value;
#line 26 "../../../src/plugins/command-plugin.vala"
	self = (SynapseCommandPlugin*) base;
#line 26 "../../../src/plugins/command-plugin.vala"
	old_value = synapse_command_plugin_real_get_enabled (base);
#line 26 "../../../src/plugins/command-plugin.vala"
	if (old_value != value) {
#line 26 "../../../src/plugins/command-plugin.vala"
		self->priv->_enabled = value;
#line 26 "../../../src/plugins/command-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_properties[SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY]);
#line 1238 "command-plugin.c"
	}
}

static inline gpointer
synapse_command_plugin_command_object_get_instance_private (SynapseCommandPluginCommandObject* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCommandPluginCommandObject_private_offset);
}

static SynapseCommandPluginCommandObject*
synapse_command_plugin_command_object_construct (GType object_type,
                                                 const gchar* cmd)
{
	SynapseCommandPluginCommandObject * self = NULL;
	GError* _inner_error0_ = NULL;
#line 42 "../../../src/plugins/command-plugin.vala"
	g_return_val_if_fail (cmd != NULL, NULL);
#line 44 "../../../src/plugins/command-plugin.vala"
	self = (SynapseCommandPluginCommandObject*) g_object_new (object_type, "title", cmd, "description", _ ("Run command"), "command", cmd, "icon-name", "application-x-executable", "needs-terminal", g_str_has_prefix (cmd, "sudo "), NULL);
#line 1258 "command-plugin.c"
	{
		GAppInfo* _tmp0_ = NULL;
		GAppInfo* _tmp1_;
#line 50 "../../../src/plugins/command-plugin.vala"
		_tmp1_ = g_app_info_create_from_commandline (cmd, NULL, 0, &_inner_error0_);
#line 50 "../../../src/plugins/command-plugin.vala"
		_tmp0_ = _tmp1_;
#line 50 "../../../src/plugins/command-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1268 "command-plugin.c"
			goto __catch0_g_error;
		}
#line 50 "../../../src/plugins/command-plugin.vala"
		synapse_application_match_set_app_info ((SynapseApplicationMatch*) self, _tmp0_);
#line 48 "../../../src/plugins/command-plugin.vala"
		_g_object_unref0 (_tmp0_);
#line 1275 "command-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 48 "../../../src/plugins/command-plugin.vala"
		err = _inner_error0_;
#line 48 "../../../src/plugins/command-plugin.vala"
		_inner_error0_ = NULL;
#line 54 "../../../src/plugins/command-plugin.vala"
		_tmp2_ = err;
#line 54 "../../../src/plugins/command-plugin.vala"
		_tmp3_ = _tmp2_->message;
#line 54 "../../../src/plugins/command-plugin.vala"
		g_warning ("command-plugin.vala:54: %s", _tmp3_);
#line 48 "../../../src/plugins/command-plugin.vala"
		_g_error_free0 (err);
#line 1295 "command-plugin.c"
	}
	__finally0:
#line 48 "../../../src/plugins/command-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 48 "../../../src/plugins/command-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 48 "../../../src/plugins/command-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 48 "../../../src/plugins/command-plugin.vala"
		return NULL;
#line 1306 "command-plugin.c"
	}
#line 42 "../../../src/plugins/command-plugin.vala"
	return self;
#line 1310 "command-plugin.c"
}

static SynapseCommandPluginCommandObject*
synapse_command_plugin_command_object_new (const gchar* cmd)
{
#line 42 "../../../src/plugins/command-plugin.vala"
	return synapse_command_plugin_command_object_construct (SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, cmd);
#line 1318 "command-plugin.c"
}

static const gchar*
synapse_command_plugin_command_object_get_command (SynapseCommandPluginCommandObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 40 "../../../src/plugins/command-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 40 "../../../src/plugins/command-plugin.vala"
	_tmp0_ = self->priv->_command;
#line 40 "../../../src/plugins/command-plugin.vala"
	result = _tmp0_;
#line 40 "../../../src/plugins/command-plugin.vala"
	return result;
#line 1334 "command-plugin.c"
}

static void
synapse_command_plugin_command_object_set_command (SynapseCommandPluginCommandObject* self,
                                                   const gchar* value)
{
	gchar* old_value;
#line 40 "../../../src/plugins/command-plugin.vala"
	g_return_if_fail (self != NULL);
#line 40 "../../../src/plugins/command-plugin.vala"
	old_value = synapse_command_plugin_command_object_get_command (self);
#line 40 "../../../src/plugins/command-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1348 "command-plugin.c"
		gchar* _tmp0_;
#line 40 "../../../src/plugins/command-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 40 "../../../src/plugins/command-plugin.vala"
		_g_free0 (self->priv->_command);
#line 40 "../../../src/plugins/command-plugin.vala"
		self->priv->_command = _tmp0_;
#line 40 "../../../src/plugins/command-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY]);
#line 1358 "command-plugin.c"
	}
}

static void
synapse_command_plugin_command_object_class_init (SynapseCommandPluginCommandObjectClass * klass,
                                                  gpointer klass_data)
{
#line 38 "../../../src/plugins/command-plugin.vala"
	synapse_command_plugin_command_object_parent_class = g_type_class_peek_parent (klass);
#line 38 "../../../src/plugins/command-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseCommandPluginCommandObject_private_offset);
#line 38 "../../../src/plugins/command-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_command_plugin_command_object_get_property;
#line 38 "../../../src/plugins/command-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_command_plugin_command_object_set_property;
#line 38 "../../../src/plugins/command-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_command_plugin_command_object_finalize;
#line 38 "../../../src/plugins/command-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY] = g_param_spec_string ("command", "command", "command", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 1378 "command-plugin.c"
}

static void
synapse_command_plugin_command_object_instance_init (SynapseCommandPluginCommandObject * self,
                                                     gpointer klass)
{
#line 38 "../../../src/plugins/command-plugin.vala"
	self->priv = synapse_command_plugin_command_object_get_instance_private (self);
#line 1387 "command-plugin.c"
}

static void
synapse_command_plugin_command_object_finalize (GObject * obj)
{
	SynapseCommandPluginCommandObject * self;
#line 38 "../../../src/plugins/command-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObject);
#line 40 "../../../src/plugins/command-plugin.vala"
	_g_free0 (self->priv->_command);
#line 38 "../../../src/plugins/command-plugin.vala"
	G_OBJECT_CLASS (synapse_command_plugin_command_object_parent_class)->finalize (obj);
#line 1400 "command-plugin.c"
}

static GType
synapse_command_plugin_command_object_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommandPluginCommandObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_command_plugin_command_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommandPluginCommandObject), 0, (GInstanceInitFunc) synapse_command_plugin_command_object_instance_init, NULL };
	GType synapse_command_plugin_command_object_type_id;
	synapse_command_plugin_command_object_type_id = g_type_register_static (SYNAPSE_TYPE_APPLICATION_MATCH, "SynapseCommandPluginCommandObject", &g_define_type_info, 0);
	SynapseCommandPluginCommandObject_private_offset = g_type_add_instance_private (synapse_command_plugin_command_object_type_id, sizeof (SynapseCommandPluginCommandObjectPrivate));
	return synapse_command_plugin_command_object_type_id;
}

static GType
synapse_command_plugin_command_object_get_type (void)
{
	static volatile gsize synapse_command_plugin_command_object_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_command_plugin_command_object_type_id__volatile)) {
		GType synapse_command_plugin_command_object_type_id;
		synapse_command_plugin_command_object_type_id = synapse_command_plugin_command_object_get_type_once ();
		g_once_init_leave (&synapse_command_plugin_command_object_type_id__volatile, synapse_command_plugin_command_object_type_id);
	}
	return synapse_command_plugin_command_object_type_id__volatile;
}

static void
_vala_synapse_command_plugin_command_object_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec)
{
	SynapseCommandPluginCommandObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObject);
#line 38 "../../../src/plugins/command-plugin.vala"
	switch (property_id) {
#line 38 "../../../src/plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY:
#line 38 "../../../src/plugins/command-plugin.vala"
		g_value_set_string (value, synapse_command_plugin_command_object_get_command (self));
#line 38 "../../../src/plugins/command-plugin.vala"
		break;
#line 1441 "command-plugin.c"
		default:
#line 38 "../../../src/plugins/command-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "../../../src/plugins/command-plugin.vala"
		break;
#line 1447 "command-plugin.c"
	}
}

static void
_vala_synapse_command_plugin_command_object_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec)
{
	SynapseCommandPluginCommandObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObject);
#line 38 "../../../src/plugins/command-plugin.vala"
	switch (property_id) {
#line 38 "../../../src/plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY:
#line 38 "../../../src/plugins/command-plugin.vala"
		synapse_command_plugin_command_object_set_command (self, g_value_get_string (value));
#line 38 "../../../src/plugins/command-plugin.vala"
		break;
#line 1467 "command-plugin.c"
		default:
#line 38 "../../../src/plugins/command-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "../../../src/plugins/command-plugin.vala"
		break;
#line 1473 "command-plugin.c"
	}
}

static GObject *
synapse_command_plugin_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseCommandPlugin * self;
	GeeHashSet* _tmp0_;
	GError* _inner_error0_ = NULL;
#line 78 "../../../src/plugins/command-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_command_plugin_parent_class);
#line 78 "../../../src/plugins/command-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 78 "../../../src/plugins/command-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin);
#line 81 "../../../src/plugins/command-plugin.vala"
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 81 "../../../src/plugins/command-plugin.vala"
	_g_object_unref0 (self->priv->past_commands);
#line 81 "../../../src/plugins/command-plugin.vala"
	self->priv->past_commands = (GeeSet*) _tmp0_;
#line 1499 "command-plugin.c"
	{
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_;
		GRegex* _tmp3_;
#line 84 "../../../src/plugins/command-plugin.vala"
		_tmp2_ = g_regex_new ("\\s+", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
#line 84 "../../../src/plugins/command-plugin.vala"
		_tmp1_ = _tmp2_;
#line 84 "../../../src/plugins/command-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 84 "../../../src/plugins/command-plugin.vala"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1512 "command-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 84 "../../../src/plugins/command-plugin.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 84 "../../../src/plugins/command-plugin.vala"
			g_clear_error (&_inner_error0_);
#line 1519 "command-plugin.c"
		}
#line 84 "../../../src/plugins/command-plugin.vala"
		_tmp3_ = _tmp1_;
#line 84 "../../../src/plugins/command-plugin.vala"
		_tmp1_ = NULL;
#line 84 "../../../src/plugins/command-plugin.vala"
		_g_regex_unref0 (self->priv->split_regex);
#line 84 "../../../src/plugins/command-plugin.vala"
		self->priv->split_regex = _tmp3_;
#line 82 "../../../src/plugins/command-plugin.vala"
		_g_regex_unref0 (_tmp1_);
#line 1531 "command-plugin.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 82 "../../../src/plugins/command-plugin.vala"
		err = _inner_error0_;
#line 82 "../../../src/plugins/command-plugin.vala"
		_inner_error0_ = NULL;
#line 88 "../../../src/plugins/command-plugin.vala"
		_tmp4_ = err;
#line 88 "../../../src/plugins/command-plugin.vala"
		_tmp5_ = _tmp4_->message;
#line 88 "../../../src/plugins/command-plugin.vala"
		g_critical ("command-plugin.vala:88: %s", _tmp5_);
#line 82 "../../../src/plugins/command-plugin.vala"
		_g_error_free0 (err);
#line 1551 "command-plugin.c"
	}
	__finally0:
#line 82 "../../../src/plugins/command-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 82 "../../../src/plugins/command-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 82 "../../../src/plugins/command-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 1560 "command-plugin.c"
	}
#line 78 "../../../src/plugins/command-plugin.vala"
	return obj;
#line 1564 "command-plugin.c"
}

static void
synapse_command_plugin_class_init (SynapseCommandPluginClass * klass,
                                   gpointer klass_data)
{
#line 24 "../../../src/plugins/command-plugin.vala"
	synapse_command_plugin_parent_class = g_type_class_peek_parent (klass);
#line 24 "../../../src/plugins/command-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseCommandPlugin_private_offset);
#line 24 "../../../src/plugins/command-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_command_plugin_get_property;
#line 24 "../../../src/plugins/command-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_command_plugin_set_property;
#line 24 "../../../src/plugins/command-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_command_plugin_constructor;
#line 24 "../../../src/plugins/command-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_command_plugin_finalize;
#line 24 "../../../src/plugins/command-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY, synapse_command_plugin_properties[SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 72 "../../../src/plugins/command-plugin.vala"
	synapse_command_plugin_register_plugin ();
#line 1587 "command-plugin.c"
}

static void
synapse_command_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                           gpointer iface_data)
{
#line 24 "../../../src/plugins/command-plugin.vala"
	synapse_command_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../../../src/plugins/command-plugin.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_command_plugin_real_activate;
#line 24 "../../../src/plugins/command-plugin.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_command_plugin_real_deactivate;
#line 24 "../../../src/plugins/command-plugin.vala"
	iface->get_enabled = synapse_command_plugin_real_get_enabled;
#line 24 "../../../src/plugins/command-plugin.vala"
	iface->set_enabled = synapse_command_plugin_real_set_enabled;
#line 1604 "command-plugin.c"
}

static void
synapse_command_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                             gpointer iface_data)
{
#line 24 "../../../src/plugins/command-plugin.vala"
	synapse_command_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../../../src/plugins/command-plugin.vala"
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_command_plugin_real_search;
#line 24 "../../../src/plugins/command-plugin.vala"
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_command_plugin_search_finish;
#line 1617 "command-plugin.c"
}

static void
synapse_command_plugin_instance_init (SynapseCommandPlugin * self,
                                      gpointer klass)
{
#line 24 "../../../src/plugins/command-plugin.vala"
	self->priv = synapse_command_plugin_get_instance_private (self);
#line 26 "../../../src/plugins/command-plugin.vala"
	self->priv->_enabled = TRUE;
#line 1628 "command-plugin.c"
}

static void
synapse_command_plugin_finalize (GObject * obj)
{
	SynapseCommandPlugin * self;
#line 24 "../../../src/plugins/command-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin);
#line 75 "../../../src/plugins/command-plugin.vala"
	_g_object_unref0 (self->priv->past_commands);
#line 76 "../../../src/plugins/command-plugin.vala"
	_g_regex_unref0 (self->priv->split_regex);
#line 24 "../../../src/plugins/command-plugin.vala"
	G_OBJECT_CLASS (synapse_command_plugin_parent_class)->finalize (obj);
#line 1643 "command-plugin.c"
}

static GType
synapse_command_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommandPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_command_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommandPlugin), 0, (GInstanceInitFunc) synapse_command_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_command_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_command_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_command_plugin_type_id;
	synapse_command_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseCommandPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_command_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_command_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseCommandPlugin_private_offset = g_type_add_instance_private (synapse_command_plugin_type_id, sizeof (SynapseCommandPluginPrivate));
	return synapse_command_plugin_type_id;
}

GType
synapse_command_plugin_get_type (void)
{
	static volatile gsize synapse_command_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_command_plugin_type_id__volatile)) {
		GType synapse_command_plugin_type_id;
		synapse_command_plugin_type_id = synapse_command_plugin_get_type_once ();
		g_once_init_leave (&synapse_command_plugin_type_id__volatile, synapse_command_plugin_type_id);
	}
	return synapse_command_plugin_type_id__volatile;
}

static void
_vala_synapse_command_plugin_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SynapseCommandPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin);
#line 24 "../../../src/plugins/command-plugin.vala"
	switch (property_id) {
#line 24 "../../../src/plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY:
#line 24 "../../../src/plugins/command-plugin.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 24 "../../../src/plugins/command-plugin.vala"
		break;
#line 1688 "command-plugin.c"
		default:
#line 24 "../../../src/plugins/command-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../../../src/plugins/command-plugin.vala"
		break;
#line 1694 "command-plugin.c"
	}
}

static void
_vala_synapse_command_plugin_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	SynapseCommandPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin);
#line 24 "../../../src/plugins/command-plugin.vala"
	switch (property_id) {
#line 24 "../../../src/plugins/command-plugin.vala"
		case SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY:
#line 24 "../../../src/plugins/command-plugin.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 24 "../../../src/plugins/command-plugin.vala"
		break;
#line 1714 "command-plugin.c"
		default:
#line 24 "../../../src/plugins/command-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../../../src/plugins/command-plugin.vala"
		break;
#line 1720 "command-plugin.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

