/* desktop-file-plugin.c generated by valac 0.48.17, the Vala compiler
 * generated from desktop-file-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib-object.h>
#include <synapse-core.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gio/gdesktopappinfo.h>
#include <gdk/gdk.h>

#define SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN (synapse_desktop_file_plugin_get_type ())
#define SYNAPSE_DESKTOP_FILE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePluginClass))
#define SYNAPSE_IS_DESKTOP_FILE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN))
#define SYNAPSE_IS_DESKTOP_FILE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePluginClass))

typedef struct _SynapseDesktopFilePlugin SynapseDesktopFilePlugin;
typedef struct _SynapseDesktopFilePluginClass SynapseDesktopFilePluginClass;
typedef struct _SynapseDesktopFilePluginPrivate SynapseDesktopFilePluginPrivate;

#define SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH (synapse_desktop_file_plugin_desktop_file_match_get_type ())
#define SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatch))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatchClass))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_DESKTOP_FILE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_DESKTOP_FILE_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatchClass))

typedef struct _SynapseDesktopFilePluginDesktopFileMatch SynapseDesktopFilePluginDesktopFileMatch;
typedef struct _SynapseDesktopFilePluginDesktopFileMatchClass SynapseDesktopFilePluginDesktopFileMatchClass;

#define SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION (synapse_desktop_file_plugin_open_with_action_get_type ())
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithAction))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithActionClass))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_OPEN_WITH_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_OPEN_WITH_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithActionClass))

typedef struct _SynapseDesktopFilePluginOpenWithAction SynapseDesktopFilePluginOpenWithAction;
typedef struct _SynapseDesktopFilePluginOpenWithActionClass SynapseDesktopFilePluginOpenWithActionClass;

#define SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION (synapse_desktop_file_plugin_open_app_action_get_type ())
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION, SynapseDesktopFilePluginOpenAppAction))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION, SynapseDesktopFilePluginOpenAppActionClass))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_OPEN_APP_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_OPEN_APP_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION, SynapseDesktopFilePluginOpenAppActionClass))

typedef struct _SynapseDesktopFilePluginOpenAppAction SynapseDesktopFilePluginOpenAppAction;
typedef struct _SynapseDesktopFilePluginOpenAppActionClass SynapseDesktopFilePluginOpenAppActionClass;
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_plugin_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SynapseDesktopFilePluginLoadAllDesktopFilesData SynapseDesktopFilePluginLoadAllDesktopFilesData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _SynapseDesktopFilePluginSearchData SynapseDesktopFilePluginSearchData;
typedef struct _SynapseDesktopFilePluginDesktopFileMatchPrivate SynapseDesktopFilePluginDesktopFileMatchPrivate;
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_INFO_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_FOLDED_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NUM_PROPERTIES];
typedef struct _SynapseDesktopFilePluginOpenWithActionPrivate SynapseDesktopFilePluginOpenWithActionPrivate;
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseDesktopFilePluginOpenAppActionPrivate SynapseDesktopFilePluginOpenAppActionPrivate;
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_DESKTOP_INFO_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_ACTION_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_plugin_open_app_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_NUM_PROPERTIES];
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_LOAD_COMPLETE_SIGNAL,
	SYNAPSE_DESKTOP_FILE_PLUGIN_NUM_SIGNALS
};
static guint synapse_desktop_file_plugin_signals[SYNAPSE_DESKTOP_FILE_PLUGIN_NUM_SIGNALS] = {0};

struct _SynapseDesktopFilePlugin {
	GObject parent_instance;
	SynapseDesktopFilePluginPrivate * priv;
};

struct _SynapseDesktopFilePluginClass {
	GObjectClass parent_class;
};

struct _SynapseDesktopFilePluginPrivate {
	gboolean _enabled;
	GeeList* desktop_files;
	gboolean loading_in_progress;
	GeeMap* mimetype_map;
	GeeMap* actions_map;
};

struct _SynapseDesktopFilePluginLoadAllDesktopFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFilePlugin* self;
	SynapseDesktopFileService* dfs;
	SynapseDesktopFileService* _tmp0_;
	GeeList* _dfi_list;
	SynapseDesktopFileService* _tmp1_;
	GeeList* _tmp2_;
	gint _dfi_size;
	GeeList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _dfi_index;
	gint _tmp6_;
	gint _tmp7_;
	SynapseDesktopFileInfo* dfi;
	GeeList* _tmp8_;
	gpointer _tmp9_;
	GeeList* _tmp10_;
	SynapseDesktopFileInfo* _tmp11_;
	SynapseDesktopFilePluginDesktopFileMatch* _tmp12_;
	SynapseDesktopFilePluginDesktopFileMatch* _tmp13_;
};

struct _Block1Data {
	int _ref_count_;
	SynapseDesktopFilePlugin* self;
	gpointer _async_data_;
};

struct _SynapseDesktopFilePluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFilePlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	Block1Data* _data1_;
	gulong signal_id;
	gulong _tmp0_;
	SynapseResultSet* _result_;
	SynapseResultSet* _tmp1_;
	SynapseQuery _tmp2_;
	const gchar* _tmp3_;
	SynapseMatcherFlags flags;
	SynapseQuery _tmp4_;
	SynapseResultSet* _tmp5_;
	SynapseMatcherFlags _tmp6_;
	SynapseQuery _tmp7_;
	SynapseResultSet* _tmp8_;
	GError* _inner_error0_;
};

struct _SynapseDesktopFilePluginDesktopFileMatch {
	SynapseApplicationMatch parent_instance;
	SynapseDesktopFilePluginDesktopFileMatchPrivate * priv;
};

struct _SynapseDesktopFilePluginDesktopFileMatchClass {
	SynapseApplicationMatchClass parent_class;
};

struct _SynapseDesktopFilePluginDesktopFileMatchPrivate {
	SynapseDesktopFileInfo* _desktop_info;
	gchar* _title_folded;
	gchar* _title_unaccented;
	gchar* _desktop_id;
	gchar* _exec;
};

struct _SynapseDesktopFilePluginOpenWithAction {
	SynapseAction parent_instance;
	SynapseDesktopFilePluginOpenWithActionPrivate * priv;
};

struct _SynapseDesktopFilePluginOpenWithActionClass {
	SynapseActionClass parent_class;
};

struct _SynapseDesktopFilePluginOpenWithActionPrivate {
	SynapseDesktopFileInfo* _desktop_info;
};

struct _SynapseDesktopFilePluginOpenAppAction {
	SynapseAction parent_instance;
	SynapseDesktopFilePluginOpenAppActionPrivate * priv;
};

struct _SynapseDesktopFilePluginOpenAppActionClass {
	SynapseActionClass parent_class;
};

struct _SynapseDesktopFilePluginOpenAppActionPrivate {
	SynapseDesktopFileInfo* _desktop_info;
	gchar* _action;
	GDesktopAppInfo* app_info;
};

static gint SynapseDesktopFilePlugin_private_offset;
static gpointer synapse_desktop_file_plugin_parent_class = NULL;
static gint SynapseDesktopFilePluginDesktopFileMatch_private_offset;
static gpointer synapse_desktop_file_plugin_desktop_file_match_parent_class = NULL;
static gint SynapseDesktopFilePluginOpenWithAction_private_offset;
static gpointer synapse_desktop_file_plugin_open_with_action_parent_class = NULL;
static gint SynapseDesktopFilePluginOpenAppAction_private_offset;
static gpointer synapse_desktop_file_plugin_open_app_action_parent_class = NULL;
static SynapseActivatableIface * synapse_desktop_file_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_desktop_file_plugin_synapse_item_provider_parent_iface = NULL;
static SynapseActionProviderIface * synapse_desktop_file_plugin_synapse_action_provider_parent_iface = NULL;

GType synapse_desktop_file_plugin_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDesktopFilePlugin, g_object_unref)
static GType synapse_desktop_file_plugin_desktop_file_match_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDesktopFilePluginDesktopFileMatch, g_object_unref)
static GType synapse_desktop_file_plugin_open_with_action_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDesktopFilePluginOpenWithAction, g_object_unref)
static GType synapse_desktop_file_plugin_open_app_action_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDesktopFilePluginOpenAppAction, g_object_unref)
static void synapse_desktop_file_plugin_real_activate (SynapseActivatable* base);
static void synapse_desktop_file_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_desktop_file_plugin_register_plugin (void);
static void _synapse_desktop_file_plugin_register_plugin_synapse_plugin_register_func (void);
static void synapse_desktop_file_plugin_load_all_desktop_files_data_free (gpointer _data);
static void synapse_desktop_file_plugin_load_all_desktop_files (SynapseDesktopFilePlugin* self,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
static void synapse_desktop_file_plugin_load_all_desktop_files_finish (SynapseDesktopFilePlugin* self,
                                                                GAsyncResult* _res_);
static gboolean synapse_desktop_file_plugin_load_all_desktop_files_co (SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_);
static gboolean _synapse_desktop_file_plugin_load_all_desktop_files_co_gsource_func (gpointer self);
static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_new (SynapseDesktopFileInfo* info);
static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_construct (GType object_type,
                                                                                                    SynapseDesktopFileInfo* info);
static gint synapse_desktop_file_plugin_compute_relevancy (SynapseDesktopFilePlugin* self,
                                                    SynapseDesktopFilePluginDesktopFileMatch* dfm,
                                                    gint base_relevancy);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self);
static void synapse_desktop_file_plugin_full_search (SynapseDesktopFilePlugin* self,
                                              SynapseQuery* q,
                                              SynapseResultSet* results,
                                              SynapseMatcherFlags flags);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_title_folded (SynapseDesktopFilePluginDesktopFileMatch* self);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_exec (SynapseDesktopFilePluginDesktopFileMatch* self);
static gboolean synapse_desktop_file_plugin_real_handles_query (SynapseItemProvider* base,
                                                         SynapseQuery* q);
static void synapse_desktop_file_plugin_real_search_data_free (gpointer _data);
static void synapse_desktop_file_plugin_real_search (SynapseItemProvider* base,
                                              SynapseQuery* q,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean synapse_desktop_file_plugin_real_search_co (SynapseDesktopFilePluginSearchData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda4_ (Block1Data* _data1_);
static void ____lambda4__synapse_desktop_file_plugin_load_complete (SynapseDesktopFilePlugin* _sender,
                                                             gpointer self);
static gboolean _synapse_desktop_file_plugin_real_search_co_gsource_func (gpointer self);
static SynapseResultSet* synapse_desktop_file_plugin_real_find_for_match (SynapseActionProvider* base,
                                                                   SynapseQuery* query,
                                                                   SynapseMatch* match);
static SynapseDesktopFilePluginOpenWithAction* synapse_desktop_file_plugin_open_with_action_new (SynapseDesktopFileInfo* info);
static SynapseDesktopFilePluginOpenWithAction* synapse_desktop_file_plugin_open_with_action_construct (GType object_type,
                                                                                                SynapseDesktopFileInfo* info);
static SynapseDesktopFilePluginOpenAppAction* synapse_desktop_file_plugin_open_app_action_new (SynapseDesktopFileInfo* info,
                                                                                        const gchar* action);
static SynapseDesktopFilePluginOpenAppAction* synapse_desktop_file_plugin_open_app_action_construct (GType object_type,
                                                                                              SynapseDesktopFileInfo* info,
                                                                                              const gchar* action);
SynapseDesktopFilePlugin* synapse_desktop_file_plugin_new (void);
SynapseDesktopFilePlugin* synapse_desktop_file_plugin_construct (GType object_type);
static SynapseDesktopFileInfo* synapse_desktop_file_plugin_desktop_file_match_get_desktop_info (SynapseDesktopFilePluginDesktopFileMatch* self);
static void synapse_desktop_file_plugin_desktop_file_match_set_desktop_info (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                      SynapseDesktopFileInfo* value);
static void synapse_desktop_file_plugin_desktop_file_match_set_title_folded (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                      const gchar* value);
static void synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                          const gchar* value);
static void synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                    const gchar* value);
static void synapse_desktop_file_plugin_desktop_file_match_set_exec (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                              const gchar* value);
static GObject * synapse_desktop_file_plugin_desktop_file_match_constructor (GType type,
                                                                      guint n_construct_properties,
                                                                      GObjectConstructParam * construct_properties);
static void synapse_desktop_file_plugin_desktop_file_match_finalize (GObject * obj);
static GType synapse_desktop_file_plugin_desktop_file_match_get_type_once (void);
static void _vala_synapse_desktop_file_plugin_desktop_file_match_get_property (GObject * object,
                                                                        guint property_id,
                                                                        GValue * value,
                                                                        GParamSpec * pspec);
static void _vala_synapse_desktop_file_plugin_desktop_file_match_set_property (GObject * object,
                                                                        guint property_id,
                                                                        const GValue * value,
                                                                        GParamSpec * pspec);
static void synapse_desktop_file_plugin_open_with_action_real_do_execute (SynapseAction* base,
                                                                   SynapseMatch* match,
                                                                   SynapseMatch* target);
static SynapseDesktopFileInfo* synapse_desktop_file_plugin_open_with_action_get_desktop_info (SynapseDesktopFilePluginOpenWithAction* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gboolean synapse_desktop_file_plugin_open_with_action_real_valid_for_match (SynapseAction* base,
                                                                            SynapseMatch* match);
static void synapse_desktop_file_plugin_open_with_action_set_desktop_info (SynapseDesktopFilePluginOpenWithAction* self,
                                                                    SynapseDesktopFileInfo* value);
static GObject * synapse_desktop_file_plugin_open_with_action_constructor (GType type,
                                                                    guint n_construct_properties,
                                                                    GObjectConstructParam * construct_properties);
static void synapse_desktop_file_plugin_open_with_action_finalize (GObject * obj);
static GType synapse_desktop_file_plugin_open_with_action_get_type_once (void);
static void _vala_synapse_desktop_file_plugin_open_with_action_get_property (GObject * object,
                                                                      guint property_id,
                                                                      GValue * value,
                                                                      GParamSpec * pspec);
static void _vala_synapse_desktop_file_plugin_open_with_action_set_property (GObject * object,
                                                                      guint property_id,
                                                                      const GValue * value,
                                                                      GParamSpec * pspec);
static void synapse_desktop_file_plugin_open_app_action_real_do_execute (SynapseAction* base,
                                                                  SynapseMatch* match,
                                                                  SynapseMatch* target);
static const gchar* synapse_desktop_file_plugin_open_app_action_get_action (SynapseDesktopFilePluginOpenAppAction* self);
static gboolean synapse_desktop_file_plugin_open_app_action_real_valid_for_match (SynapseAction* base,
                                                                           SynapseMatch* match);
static SynapseDesktopFileInfo* synapse_desktop_file_plugin_open_app_action_get_desktop_info (SynapseDesktopFilePluginOpenAppAction* self);
static void synapse_desktop_file_plugin_open_app_action_set_desktop_info (SynapseDesktopFilePluginOpenAppAction* self,
                                                                   SynapseDesktopFileInfo* value);
static void synapse_desktop_file_plugin_open_app_action_set_action (SynapseDesktopFilePluginOpenAppAction* self,
                                                             const gchar* value);
static GObject * synapse_desktop_file_plugin_open_app_action_constructor (GType type,
                                                                   guint n_construct_properties,
                                                                   GObjectConstructParam * construct_properties);
static void synapse_desktop_file_plugin_open_app_action_finalize (GObject * obj);
static GType synapse_desktop_file_plugin_open_app_action_get_type_once (void);
static void _vala_synapse_desktop_file_plugin_open_app_action_get_property (GObject * object,
                                                                     guint property_id,
                                                                     GValue * value,
                                                                     GParamSpec * pspec);
static void _vala_synapse_desktop_file_plugin_open_app_action_set_property (GObject * object,
                                                                     guint property_id,
                                                                     const GValue * value,
                                                                     GParamSpec * pspec);
static GObject * synapse_desktop_file_plugin_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _synapse_desktop_file_plugin___lambda5_ (SynapseDesktopFilePlugin* self);
static void __synapse_desktop_file_plugin___lambda5__synapse_desktop_file_service_reload_started (SynapseDesktopFileService* _sender,
                                                                                           gpointer self);
static void _synapse_desktop_file_plugin___lambda6_ (SynapseDesktopFilePlugin* self);
static void __synapse_desktop_file_plugin___lambda6__synapse_desktop_file_service_reload_done (SynapseDesktopFileService* _sender,
                                                                                        gpointer self);
static void synapse_desktop_file_plugin_finalize (GObject * obj);
static GType synapse_desktop_file_plugin_get_type_once (void);
static void _vala_synapse_desktop_file_plugin_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_synapse_desktop_file_plugin_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);

static inline gpointer
synapse_desktop_file_plugin_get_instance_private (SynapseDesktopFilePlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFilePlugin_private_offset);
}

static void
synapse_desktop_file_plugin_real_activate (SynapseActivatable* base)
{
	SynapseDesktopFilePlugin * self;
#line 28 "../../../src/plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) base;
#line 418 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseDesktopFilePlugin * self;
#line 33 "../../../src/plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) base;
#line 427 "desktop-file-plugin.c"
}

static void
_synapse_desktop_file_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 67 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_register_plugin ();
#line 435 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_register_plugin (void)
{
	SynapsePluginRegistry* _tmp0_;
	SynapsePluginRegistry* _tmp1_;
#line 67 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp0_ = synapse_plugin_registry_get_default ();
#line 67 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp1_ = _tmp0_;
#line 67 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, "Application Search", _ ("Search for and run applications on your computer."), "system-run", _synapse_desktop_file_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
#line 67 "../../../src/plugins/desktop-file-plugin.vala"
	_g_object_unref0 (_tmp1_);
#line 451 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_load_all_desktop_files_data_free (gpointer _data)
{
	SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_;
	_data_ = _data;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	g_slice_free (SynapseDesktopFilePluginLoadAllDesktopFilesData, _data_);
#line 463 "desktop-file-plugin.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 471 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_load_all_desktop_files (SynapseDesktopFilePlugin* self,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_;
	SynapseDesktopFilePlugin* _tmp0_;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	_data_ = g_slice_new0 (SynapseDesktopFilePluginLoadAllDesktopFilesData);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_plugin_load_all_desktop_files_data_free);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	_data_->self = _tmp0_;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_load_all_desktop_files_co (_data_);
#line 493 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_load_all_desktop_files_finish (SynapseDesktopFilePlugin* self,
                                                           GAsyncResult* _res_)
{
	SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 503 "desktop-file-plugin.c"
}

static gboolean
_synapse_desktop_file_plugin_load_all_desktop_files_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_desktop_file_plugin_load_all_desktop_files_co (self);
#line 108 "../../../src/plugins/desktop-file-plugin.vala"
	return result;
#line 513 "desktop-file-plugin.c"
}

static gboolean
synapse_desktop_file_plugin_load_all_desktop_files_co (SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_)
{
#line 105 "../../../src/plugins/desktop-file-plugin.vala"
	switch (_data_->_state_) {
#line 105 "../../../src/plugins/desktop-file-plugin.vala"
		case 0:
#line 523 "desktop-file-plugin.c"
		goto _state_0;
#line 105 "../../../src/plugins/desktop-file-plugin.vala"
		case 1:
#line 527 "desktop-file-plugin.c"
		goto _state_1;
		default:
#line 105 "../../../src/plugins/desktop-file-plugin.vala"
		g_assert_not_reached ();
#line 532 "desktop-file-plugin.c"
	}
	_state_0:
#line 107 "../../../src/plugins/desktop-file-plugin.vala"
	_data_->self->priv->loading_in_progress = TRUE;
#line 108 "../../../src/plugins/desktop-file-plugin.vala"
	g_idle_add_full (G_PRIORITY_LOW, _synapse_desktop_file_plugin_load_all_desktop_files_co_gsource_func, _data_, NULL);
#line 109 "../../../src/plugins/desktop-file-plugin.vala"
	_data_->_state_ = 1;
#line 109 "../../../src/plugins/desktop-file-plugin.vala"
	return FALSE;
#line 543 "desktop-file-plugin.c"
	_state_1:
	;
#line 111 "../../../src/plugins/desktop-file-plugin.vala"
	_data_->_tmp0_ = synapse_desktop_file_service_get_default ();
#line 111 "../../../src/plugins/desktop-file-plugin.vala"
	_data_->dfs = _data_->_tmp0_;
#line 550 "desktop-file-plugin.c"
	{
#line 113 "../../../src/plugins/desktop-file-plugin.vala"
		_data_->_tmp1_ = _data_->dfs;
#line 113 "../../../src/plugins/desktop-file-plugin.vala"
		_data_->_tmp2_ = synapse_desktop_file_service_get_desktop_files (_data_->_tmp1_);
#line 113 "../../../src/plugins/desktop-file-plugin.vala"
		_data_->_dfi_list = _data_->_tmp2_;
#line 113 "../../../src/plugins/desktop-file-plugin.vala"
		_data_->_tmp3_ = _data_->_dfi_list;
#line 113 "../../../src/plugins/desktop-file-plugin.vala"
		_data_->_tmp4_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp3_);
#line 113 "../../../src/plugins/desktop-file-plugin.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 113 "../../../src/plugins/desktop-file-plugin.vala"
		_data_->_dfi_size = _data_->_tmp5_;
#line 113 "../../../src/plugins/desktop-file-plugin.vala"
		_data_->_dfi_index = -1;
#line 113 "../../../src/plugins/desktop-file-plugin.vala"
		while (TRUE) {
#line 113 "../../../src/plugins/desktop-file-plugin.vala"
			_data_->_dfi_index = _data_->_dfi_index + 1;
#line 113 "../../../src/plugins/desktop-file-plugin.vala"
			_data_->_tmp6_ = _data_->_dfi_index;
#line 113 "../../../src/plugins/desktop-file-plugin.vala"
			_data_->_tmp7_ = _data_->_dfi_size;
#line 113 "../../../src/plugins/desktop-file-plugin.vala"
			if (!(_data_->_tmp6_ < _data_->_tmp7_)) {
#line 113 "../../../src/plugins/desktop-file-plugin.vala"
				break;
#line 580 "desktop-file-plugin.c"
			}
#line 113 "../../../src/plugins/desktop-file-plugin.vala"
			_data_->_tmp8_ = _data_->_dfi_list;
#line 113 "../../../src/plugins/desktop-file-plugin.vala"
			_data_->_tmp9_ = gee_list_get (_data_->_tmp8_, _data_->_dfi_index);
#line 113 "../../../src/plugins/desktop-file-plugin.vala"
			_data_->dfi = (SynapseDesktopFileInfo*) _data_->_tmp9_;
#line 115 "../../../src/plugins/desktop-file-plugin.vala"
			_data_->_tmp10_ = _data_->self->priv->desktop_files;
#line 115 "../../../src/plugins/desktop-file-plugin.vala"
			_data_->_tmp11_ = _data_->dfi;
#line 115 "../../../src/plugins/desktop-file-plugin.vala"
			_data_->_tmp12_ = synapse_desktop_file_plugin_desktop_file_match_new (_data_->_tmp11_);
#line 115 "../../../src/plugins/desktop-file-plugin.vala"
			_data_->_tmp13_ = _data_->_tmp12_;
#line 115 "../../../src/plugins/desktop-file-plugin.vala"
			gee_collection_add ((GeeCollection*) _data_->_tmp10_, _data_->_tmp13_);
#line 115 "../../../src/plugins/desktop-file-plugin.vala"
			_g_object_unref0 (_data_->_tmp13_);
#line 113 "../../../src/plugins/desktop-file-plugin.vala"
			_g_object_unref0 (_data_->dfi);
#line 602 "desktop-file-plugin.c"
		}
#line 113 "../../../src/plugins/desktop-file-plugin.vala"
		_g_object_unref0 (_data_->_dfi_list);
#line 606 "desktop-file-plugin.c"
	}
#line 118 "../../../src/plugins/desktop-file-plugin.vala"
	_data_->self->priv->loading_in_progress = FALSE;
#line 119 "../../../src/plugins/desktop-file-plugin.vala"
	g_signal_emit (_data_->self, synapse_desktop_file_plugin_signals[SYNAPSE_DESKTOP_FILE_PLUGIN_LOAD_COMPLETE_SIGNAL], 0);
#line 105 "../../../src/plugins/desktop-file-plugin.vala"
	_g_object_unref0 (_data_->dfs);
#line 105 "../../../src/plugins/desktop-file-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 105 "../../../src/plugins/desktop-file-plugin.vala"
	if (_data_->_state_ != 0) {
#line 105 "../../../src/plugins/desktop-file-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 105 "../../../src/plugins/desktop-file-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 622 "desktop-file-plugin.c"
		}
	}
#line 105 "../../../src/plugins/desktop-file-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 105 "../../../src/plugins/desktop-file-plugin.vala"
	return FALSE;
#line 629 "desktop-file-plugin.c"
}

static gint
synapse_desktop_file_plugin_compute_relevancy (SynapseDesktopFilePlugin* self,
                                               SynapseDesktopFilePluginDesktopFileMatch* dfm,
                                               gint base_relevancy)
{
	SynapseRelevancyService* rs = NULL;
	SynapseRelevancyService* _tmp0_;
	gfloat popularity = 0.0F;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint r = 0;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint result = 0;
#line 122 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 122 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (dfm != NULL, 0);
#line 124 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp0_ = synapse_relevancy_service_get_default ();
#line 124 "../../../src/plugins/desktop-file-plugin.vala"
	rs = _tmp0_;
#line 125 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp1_ = synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (dfm);
#line 125 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp2_ = _tmp1_;
#line 125 "../../../src/plugins/desktop-file-plugin.vala"
	popularity = synapse_relevancy_service_get_application_popularity (rs, _tmp2_);
#line 127 "../../../src/plugins/desktop-file-plugin.vala"
	r = synapse_relevancy_service_compute_relevancy (base_relevancy, popularity);
#line 128 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp3_ = synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (dfm);
#line 128 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp4_ = _tmp3_;
#line 128 "../../../src/plugins/desktop-file-plugin.vala"
	g_debug ("desktop-file-plugin.vala:128: relevancy for %s: %d", _tmp4_, r);
#line 130 "../../../src/plugins/desktop-file-plugin.vala"
	result = r;
#line 130 "../../../src/plugins/desktop-file-plugin.vala"
	_g_object_unref0 (rs);
#line 130 "../../../src/plugins/desktop-file-plugin.vala"
	return result;
#line 674 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_full_search (SynapseDesktopFilePlugin* self,
                                         SynapseQuery* q,
                                         SynapseResultSet* results,
                                         SynapseMatcherFlags flags)
{
	GeeList* matchers = NULL;
	SynapseQuery _tmp0_;
	const gchar* _tmp1_;
	GeeList* _tmp2_;
#line 133 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 133 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_if_fail (q != NULL);
#line 133 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_if_fail (results != NULL);
#line 137 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp0_ = *q;
#line 137 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp1_ = _tmp0_.query_string_folded;
#line 137 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp2_ = synapse_query_get_matchers_for_query (_tmp1_, flags, G_REGEX_OPTIMIZE);
#line 137 "../../../src/plugins/desktop-file-plugin.vala"
	matchers = _tmp2_;
#line 701 "desktop-file-plugin.c"
	{
		GeeList* _dfm_list = NULL;
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		gint _dfm_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _dfm_index = 0;
#line 140 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp3_ = self->priv->desktop_files;
#line 140 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 140 "../../../src/plugins/desktop-file-plugin.vala"
		_dfm_list = _tmp4_;
#line 140 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp5_ = _dfm_list;
#line 140 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
#line 140 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp7_ = _tmp6_;
#line 140 "../../../src/plugins/desktop-file-plugin.vala"
		_dfm_size = _tmp7_;
#line 140 "../../../src/plugins/desktop-file-plugin.vala"
		_dfm_index = -1;
#line 140 "../../../src/plugins/desktop-file-plugin.vala"
		while (TRUE) {
#line 729 "desktop-file-plugin.c"
			gint _tmp8_;
			gint _tmp9_;
			SynapseDesktopFilePluginDesktopFileMatch* dfm = NULL;
			GeeList* _tmp10_;
			gpointer _tmp11_;
			const gchar* folded_title = NULL;
			SynapseDesktopFilePluginDesktopFileMatch* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			const gchar* unaccented_title = NULL;
			SynapseDesktopFilePluginDesktopFileMatch* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gboolean matched = FALSE;
			gboolean _tmp47_ = FALSE;
#line 140 "../../../src/plugins/desktop-file-plugin.vala"
			_dfm_index = _dfm_index + 1;
#line 140 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp8_ = _dfm_index;
#line 140 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp9_ = _dfm_size;
#line 140 "../../../src/plugins/desktop-file-plugin.vala"
			if (!(_tmp8_ < _tmp9_)) {
#line 140 "../../../src/plugins/desktop-file-plugin.vala"
				break;
#line 755 "desktop-file-plugin.c"
			}
#line 140 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp10_ = _dfm_list;
#line 140 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp11_ = gee_list_get (_tmp10_, _dfm_index);
#line 140 "../../../src/plugins/desktop-file-plugin.vala"
			dfm = (SynapseDesktopFilePluginDesktopFileMatch*) _tmp11_;
#line 142 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp12_ = dfm;
#line 142 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp13_ = synapse_desktop_file_plugin_desktop_file_match_get_title_folded (_tmp12_);
#line 142 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp14_ = _tmp13_;
#line 142 "../../../src/plugins/desktop-file-plugin.vala"
			folded_title = _tmp14_;
#line 143 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp15_ = dfm;
#line 143 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp16_ = synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (_tmp15_);
#line 143 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp17_ = _tmp16_;
#line 143 "../../../src/plugins/desktop-file-plugin.vala"
			unaccented_title = _tmp17_;
#line 144 "../../../src/plugins/desktop-file-plugin.vala"
			matched = FALSE;
#line 781 "desktop-file-plugin.c"
			{
				GeeList* _matcher_list = NULL;
				GeeList* _tmp18_;
				GeeList* _tmp19_;
				gint _matcher_size = 0;
				GeeList* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				gint _matcher_index = 0;
#line 148 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp18_ = matchers;
#line 148 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp19_ = _g_object_ref0 (_tmp18_);
#line 148 "../../../src/plugins/desktop-file-plugin.vala"
				_matcher_list = _tmp19_;
#line 148 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp20_ = _matcher_list;
#line 148 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp21_ = gee_collection_get_size ((GeeCollection*) _tmp20_);
#line 148 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp22_ = _tmp21_;
#line 148 "../../../src/plugins/desktop-file-plugin.vala"
				_matcher_size = _tmp22_;
#line 148 "../../../src/plugins/desktop-file-plugin.vala"
				_matcher_index = -1;
#line 148 "../../../src/plugins/desktop-file-plugin.vala"
				while (TRUE) {
#line 809 "desktop-file-plugin.c"
					gint _tmp23_;
					gint _tmp24_;
					GeeMapEntry* matcher = NULL;
					GeeList* _tmp25_;
					gpointer _tmp26_;
					GeeMapEntry* _tmp27_;
					gconstpointer _tmp28_;
					gconstpointer _tmp29_;
					const gchar* _tmp30_;
#line 148 "../../../src/plugins/desktop-file-plugin.vala"
					_matcher_index = _matcher_index + 1;
#line 148 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp23_ = _matcher_index;
#line 148 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp24_ = _matcher_size;
#line 148 "../../../src/plugins/desktop-file-plugin.vala"
					if (!(_tmp23_ < _tmp24_)) {
#line 148 "../../../src/plugins/desktop-file-plugin.vala"
						break;
#line 829 "desktop-file-plugin.c"
					}
#line 148 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp25_ = _matcher_list;
#line 148 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp26_ = gee_list_get (_tmp25_, _matcher_index);
#line 148 "../../../src/plugins/desktop-file-plugin.vala"
					matcher = (GeeMapEntry*) _tmp26_;
#line 150 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp27_ = matcher;
#line 150 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp28_ = gee_map_entry_get_key (_tmp27_);
#line 150 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp29_ = _tmp28_;
#line 150 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp30_ = folded_title;
#line 150 "../../../src/plugins/desktop-file-plugin.vala"
					if (g_regex_match ((GRegex*) _tmp29_, _tmp30_, 0, NULL)) {
#line 847 "desktop-file-plugin.c"
						SynapseDesktopFilePluginDesktopFileMatch* _tmp31_;
						SynapseDesktopFilePluginDesktopFileMatch* _tmp32_;
						GeeMapEntry* _tmp33_;
						gconstpointer _tmp34_;
						gconstpointer _tmp35_;
#line 152 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp31_ = dfm;
#line 152 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp32_ = dfm;
#line 152 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp33_ = matcher;
#line 152 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp34_ = gee_map_entry_get_value (_tmp33_);
#line 152 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp35_ = _tmp34_;
#line 152 "../../../src/plugins/desktop-file-plugin.vala"
						synapse_result_set_add (results, (SynapseMatch*) _tmp31_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp32_, (gint) ((gintptr) _tmp35_)));
#line 153 "../../../src/plugins/desktop-file-plugin.vala"
						matched = TRUE;
#line 154 "../../../src/plugins/desktop-file-plugin.vala"
						_g_object_unref0 (matcher);
#line 154 "../../../src/plugins/desktop-file-plugin.vala"
						break;
#line 871 "desktop-file-plugin.c"
					} else {
						gboolean _tmp36_ = FALSE;
						const gchar* _tmp37_;
#line 156 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp37_ = unaccented_title;
#line 156 "../../../src/plugins/desktop-file-plugin.vala"
						if (_tmp37_ != NULL) {
#line 879 "desktop-file-plugin.c"
							GeeMapEntry* _tmp38_;
							gconstpointer _tmp39_;
							gconstpointer _tmp40_;
							const gchar* _tmp41_;
#line 156 "../../../src/plugins/desktop-file-plugin.vala"
							_tmp38_ = matcher;
#line 156 "../../../src/plugins/desktop-file-plugin.vala"
							_tmp39_ = gee_map_entry_get_key (_tmp38_);
#line 156 "../../../src/plugins/desktop-file-plugin.vala"
							_tmp40_ = _tmp39_;
#line 156 "../../../src/plugins/desktop-file-plugin.vala"
							_tmp41_ = unaccented_title;
#line 156 "../../../src/plugins/desktop-file-plugin.vala"
							_tmp36_ = g_regex_match ((GRegex*) _tmp40_, _tmp41_, 0, NULL);
#line 894 "desktop-file-plugin.c"
						} else {
#line 156 "../../../src/plugins/desktop-file-plugin.vala"
							_tmp36_ = FALSE;
#line 898 "desktop-file-plugin.c"
						}
#line 156 "../../../src/plugins/desktop-file-plugin.vala"
						if (_tmp36_) {
#line 902 "desktop-file-plugin.c"
							SynapseDesktopFilePluginDesktopFileMatch* _tmp42_;
							SynapseDesktopFilePluginDesktopFileMatch* _tmp43_;
							GeeMapEntry* _tmp44_;
							gconstpointer _tmp45_;
							gconstpointer _tmp46_;
#line 158 "../../../src/plugins/desktop-file-plugin.vala"
							_tmp42_ = dfm;
#line 158 "../../../src/plugins/desktop-file-plugin.vala"
							_tmp43_ = dfm;
#line 158 "../../../src/plugins/desktop-file-plugin.vala"
							_tmp44_ = matcher;
#line 158 "../../../src/plugins/desktop-file-plugin.vala"
							_tmp45_ = gee_map_entry_get_value (_tmp44_);
#line 158 "../../../src/plugins/desktop-file-plugin.vala"
							_tmp46_ = _tmp45_;
#line 158 "../../../src/plugins/desktop-file-plugin.vala"
							synapse_result_set_add (results, (SynapseMatch*) _tmp42_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp43_, ((gint) ((gintptr) _tmp46_)) - SYNAPSE_MATCH_SCORE_INCREMENT_SMALL));
#line 159 "../../../src/plugins/desktop-file-plugin.vala"
							matched = TRUE;
#line 160 "../../../src/plugins/desktop-file-plugin.vala"
							_g_object_unref0 (matcher);
#line 160 "../../../src/plugins/desktop-file-plugin.vala"
							break;
#line 926 "desktop-file-plugin.c"
						}
					}
#line 148 "../../../src/plugins/desktop-file-plugin.vala"
					_g_object_unref0 (matcher);
#line 931 "desktop-file-plugin.c"
				}
#line 148 "../../../src/plugins/desktop-file-plugin.vala"
				_g_object_unref0 (_matcher_list);
#line 935 "desktop-file-plugin.c"
			}
#line 163 "../../../src/plugins/desktop-file-plugin.vala"
			if (!matched) {
#line 939 "desktop-file-plugin.c"
				SynapseDesktopFilePluginDesktopFileMatch* _tmp48_;
				const gchar* _tmp49_;
				const gchar* _tmp50_;
				SynapseQuery _tmp51_;
				const gchar* _tmp52_;
#line 163 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp48_ = dfm;
#line 163 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp49_ = synapse_desktop_file_plugin_desktop_file_match_get_exec (_tmp48_);
#line 163 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp50_ = _tmp49_;
#line 163 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp51_ = *q;
#line 163 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp52_ = _tmp51_.query_string;
#line 163 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp47_ = g_str_has_prefix (_tmp50_, _tmp52_);
#line 957 "desktop-file-plugin.c"
			} else {
#line 163 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp47_ = FALSE;
#line 961 "desktop-file-plugin.c"
			}
#line 163 "../../../src/plugins/desktop-file-plugin.vala"
			if (_tmp47_) {
#line 965 "desktop-file-plugin.c"
				SynapseMatchScore _tmp53_ = 0;
				SynapseDesktopFilePluginDesktopFileMatch* _tmp54_;
				const gchar* _tmp55_;
				const gchar* _tmp56_;
				SynapseQuery _tmp57_;
				const gchar* _tmp58_;
				SynapseDesktopFilePluginDesktopFileMatch* _tmp59_;
				SynapseDesktopFilePluginDesktopFileMatch* _tmp60_;
#line 165 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp54_ = dfm;
#line 165 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp55_ = synapse_desktop_file_plugin_desktop_file_match_get_exec (_tmp54_);
#line 165 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp56_ = _tmp55_;
#line 165 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp57_ = *q;
#line 165 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp58_ = _tmp57_.query_string;
#line 165 "../../../src/plugins/desktop-file-plugin.vala"
				if (g_strcmp0 (_tmp56_, _tmp58_) == 0) {
#line 166 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp53_ = SYNAPSE_MATCH_SCORE_VERY_GOOD;
#line 988 "desktop-file-plugin.c"
				} else {
#line 166 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp53_ = SYNAPSE_MATCH_SCORE_AVERAGE - SYNAPSE_MATCH_SCORE_INCREMENT_SMALL;
#line 992 "desktop-file-plugin.c"
				}
#line 165 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp59_ = dfm;
#line 165 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp60_ = dfm;
#line 165 "../../../src/plugins/desktop-file-plugin.vala"
				synapse_result_set_add (results, (SynapseMatch*) _tmp59_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp60_, (gint) _tmp53_));
#line 1000 "desktop-file-plugin.c"
			}
#line 140 "../../../src/plugins/desktop-file-plugin.vala"
			_g_object_unref0 (dfm);
#line 1004 "desktop-file-plugin.c"
		}
#line 140 "../../../src/plugins/desktop-file-plugin.vala"
		_g_object_unref0 (_dfm_list);
#line 1008 "desktop-file-plugin.c"
	}
#line 133 "../../../src/plugins/desktop-file-plugin.vala"
	_g_object_unref0 (matchers);
#line 1012 "desktop-file-plugin.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
#line 1359 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1360 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1360 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1361 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1362 "glib-2.0.vapi"
	result = _result_;
#line 1362 "glib-2.0.vapi"
	return result;
#line 1033 "desktop-file-plugin.c"
}

static gboolean
synapse_desktop_file_plugin_real_handles_query (SynapseItemProvider* base,
                                                SynapseQuery* q)
{
	SynapseDesktopFilePlugin * self;
	SynapseQuery _tmp0_;
	SynapseQueryFlags _tmp1_;
	SynapseQuery _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean result = FALSE;
#line 171 "../../../src/plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) base;
#line 171 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (q != NULL, FALSE);
#line 174 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp0_ = *q;
#line 174 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp1_ = _tmp0_.query_type;
#line 174 "../../../src/plugins/desktop-file-plugin.vala"
	if (!((_tmp1_ & SYNAPSE_QUERY_FLAGS_APPLICATIONS) == SYNAPSE_QUERY_FLAGS_APPLICATIONS)) {
#line 174 "../../../src/plugins/desktop-file-plugin.vala"
		result = FALSE;
#line 174 "../../../src/plugins/desktop-file-plugin.vala"
		return result;
#line 1063 "desktop-file-plugin.c"
	}
#line 175 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp2_ = *q;
#line 175 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp3_ = _tmp2_.query_string;
#line 175 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp4_ = string_strip (_tmp3_);
#line 175 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp5_ = _tmp4_;
#line 175 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp6_ = g_strcmp0 (_tmp5_, "") == 0;
#line 175 "../../../src/plugins/desktop-file-plugin.vala"
	_g_free0 (_tmp5_);
#line 175 "../../../src/plugins/desktop-file-plugin.vala"
	if (_tmp6_) {
#line 175 "../../../src/plugins/desktop-file-plugin.vala"
		result = FALSE;
#line 175 "../../../src/plugins/desktop-file-plugin.vala"
		return result;
#line 1083 "desktop-file-plugin.c"
	}
#line 177 "../../../src/plugins/desktop-file-plugin.vala"
	result = TRUE;
#line 177 "../../../src/plugins/desktop-file-plugin.vala"
	return result;
#line 1089 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_real_search_data_free (gpointer _data)
{
	SynapseDesktopFilePluginSearchData* _data_;
	_data_ = _data;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	g_slice_free (SynapseDesktopFilePluginSearchData, _data_);
#line 1105 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_real_search (SynapseItemProvider* base,
                                         SynapseQuery* q,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	SynapseDesktopFilePlugin * self;
	SynapseDesktopFilePluginSearchData* _data_;
	SynapseDesktopFilePlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) base;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	_data_ = g_slice_new0 (SynapseDesktopFilePluginSearchData);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_plugin_real_search_data_free);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	_data_->self = _tmp0_;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp1_ = *q;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp2_ = _tmp1_;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	_data_->q = _tmp3_;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_real_search_co (_data_);
#line 1144 "desktop-file-plugin.c"
}

static SynapseResultSet*
synapse_desktop_file_plugin_search_finish (SynapseItemProvider* base,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	SynapseResultSet* result;
	SynapseDesktopFilePluginSearchData* _data_;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	if (NULL == _data_) {
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
		return NULL;
#line 1160 "desktop-file-plugin.c"
	}
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	result = _data_->result;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	_data_->result = NULL;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	return result;
#line 1168 "desktop-file-plugin.c"
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
#line 180 "../../../src/plugins/desktop-file-plugin.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 180 "../../../src/plugins/desktop-file-plugin.vala"
	return _data1_;
#line 1178 "desktop-file-plugin.c"
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 180 "../../../src/plugins/desktop-file-plugin.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 1188 "desktop-file-plugin.c"
		SynapseDesktopFilePlugin* self;
#line 180 "../../../src/plugins/desktop-file-plugin.vala"
		self = _data1_->self;
#line 180 "../../../src/plugins/desktop-file-plugin.vala"
		_g_object_unref0 (self);
#line 180 "../../../src/plugins/desktop-file-plugin.vala"
		g_slice_free (Block1Data, _data1_);
#line 1196 "desktop-file-plugin.c"
	}
}

static void
___lambda4_ (Block1Data* _data1_)
{
	SynapseDesktopFilePlugin* self;
#line 185 "../../../src/plugins/desktop-file-plugin.vala"
	self = _data1_->self;
#line 186 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_real_search_co (_data1_->_async_data_);
#line 1208 "desktop-file-plugin.c"
}

static void
____lambda4__synapse_desktop_file_plugin_load_complete (SynapseDesktopFilePlugin* _sender,
                                                        gpointer self)
{
#line 185 "../../../src/plugins/desktop-file-plugin.vala"
	___lambda4_ (self);
#line 1217 "desktop-file-plugin.c"
}

static gboolean
_synapse_desktop_file_plugin_real_search_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_desktop_file_plugin_real_search_co (self);
#line 196 "../../../src/plugins/desktop-file-plugin.vala"
	return result;
#line 1227 "desktop-file-plugin.c"
}

static gboolean
synapse_desktop_file_plugin_real_search_co (SynapseDesktopFilePluginSearchData* _data_)
{
#line 180 "../../../src/plugins/desktop-file-plugin.vala"
	switch (_data_->_state_) {
#line 180 "../../../src/plugins/desktop-file-plugin.vala"
		case 0:
#line 1237 "desktop-file-plugin.c"
		goto _state_0;
#line 180 "../../../src/plugins/desktop-file-plugin.vala"
		case 1:
#line 1241 "desktop-file-plugin.c"
		goto _state_1;
#line 180 "../../../src/plugins/desktop-file-plugin.vala"
		case 2:
#line 1245 "desktop-file-plugin.c"
		goto _state_2;
		default:
#line 180 "../../../src/plugins/desktop-file-plugin.vala"
		g_assert_not_reached ();
#line 1250 "desktop-file-plugin.c"
	}
	_state_0:
#line 180 "../../../src/plugins/desktop-file-plugin.vala"
	_data_->_data1_ = g_slice_new0 (Block1Data);
#line 180 "../../../src/plugins/desktop-file-plugin.vala"
	_data_->_data1_->_ref_count_ = 1;
#line 180 "../../../src/plugins/desktop-file-plugin.vala"
	_data_->_data1_->self = g_object_ref (_data_->self);
#line 180 "../../../src/plugins/desktop-file-plugin.vala"
	_data_->_data1_->_async_data_ = _data_;
#line 182 "../../../src/plugins/desktop-file-plugin.vala"
	if (_data_->self->priv->loading_in_progress) {
#line 185 "../../../src/plugins/desktop-file-plugin.vala"
		_data_->_tmp0_ = g_signal_connect_data (_data_->self, "load-complete", (GCallback) ____lambda4__synapse_desktop_file_plugin_load_complete, block1_data_ref (_data_->_data1_), (GClosureNotify) block1_data_unref, 0);
#line 185 "../../../src/plugins/desktop-file-plugin.vala"
		_data_->signal_id = _data_->_tmp0_;
#line 188 "../../../src/plugins/desktop-file-plugin.vala"
		_data_->_state_ = 1;
#line 188 "../../../src/plugins/desktop-file-plugin.vala"
		return FALSE;
#line 1271 "desktop-file-plugin.c"
		_state_1:
		;
#line 189 "../../../src/plugins/desktop-file-plugin.vala"
		g_signal_handler_disconnect (_data_->self, _data_->signal_id);
#line 1276 "desktop-file-plugin.c"
	} else {
#line 196 "../../../src/plugins/desktop-file-plugin.vala"
		g_idle_add_full (G_PRIORITY_HIGH_IDLE, _synapse_desktop_file_plugin_real_search_co_gsource_func, _data_, NULL);
#line 197 "../../../src/plugins/desktop-file-plugin.vala"
		_data_->_state_ = 2;
#line 197 "../../../src/plugins/desktop-file-plugin.vala"
		return FALSE;
#line 1284 "desktop-file-plugin.c"
		_state_2:
		;
	}
#line 200 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 200 "../../../src/plugins/desktop-file-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 200 "../../../src/plugins/desktop-file-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 200 "../../../src/plugins/desktop-file-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 200 "../../../src/plugins/desktop-file-plugin.vala"
			block1_data_unref (_data_->_data1_);
#line 200 "../../../src/plugins/desktop-file-plugin.vala"
			_data_->_data1_ = NULL;
#line 200 "../../../src/plugins/desktop-file-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 200 "../../../src/plugins/desktop-file-plugin.vala"
			return FALSE;
#line 1304 "desktop-file-plugin.c"
		} else {
#line 200 "../../../src/plugins/desktop-file-plugin.vala"
			block1_data_unref (_data_->_data1_);
#line 200 "../../../src/plugins/desktop-file-plugin.vala"
			_data_->_data1_ = NULL;
#line 200 "../../../src/plugins/desktop-file-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 200 "../../../src/plugins/desktop-file-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 200 "../../../src/plugins/desktop-file-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 200 "../../../src/plugins/desktop-file-plugin.vala"
			return FALSE;
#line 1318 "desktop-file-plugin.c"
		}
	}
#line 203 "../../../src/plugins/desktop-file-plugin.vala"
	_data_->_tmp1_ = synapse_result_set_new ();
#line 203 "../../../src/plugins/desktop-file-plugin.vala"
	_data_->_result_ = _data_->_tmp1_;
#line 205 "../../../src/plugins/desktop-file-plugin.vala"
	_data_->_tmp2_ = _data_->q;
#line 205 "../../../src/plugins/desktop-file-plugin.vala"
	_data_->_tmp3_ = _data_->_tmp2_.query_string;
#line 205 "../../../src/plugins/desktop-file-plugin.vala"
	if (g_utf8_strlen (_data_->_tmp3_, (gssize) -1) == 1) {
#line 207 "../../../src/plugins/desktop-file-plugin.vala"
		_data_->flags = (SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING | SYNAPSE_MATCHER_FLAGS_NO_PARTIAL) | SYNAPSE_MATCHER_FLAGS_NO_FUZZY;
#line 209 "../../../src/plugins/desktop-file-plugin.vala"
		_data_->_tmp4_ = _data_->q;
#line 209 "../../../src/plugins/desktop-file-plugin.vala"
		_data_->_tmp5_ = _data_->_result_;
#line 209 "../../../src/plugins/desktop-file-plugin.vala"
		_data_->_tmp6_ = _data_->flags;
#line 209 "../../../src/plugins/desktop-file-plugin.vala"
		synapse_desktop_file_plugin_full_search (_data_->self, &_data_->_tmp4_, _data_->_tmp5_, _data_->_tmp6_);
#line 1341 "desktop-file-plugin.c"
	} else {
#line 213 "../../../src/plugins/desktop-file-plugin.vala"
		_data_->_tmp7_ = _data_->q;
#line 213 "../../../src/plugins/desktop-file-plugin.vala"
		_data_->_tmp8_ = _data_->_result_;
#line 213 "../../../src/plugins/desktop-file-plugin.vala"
		synapse_desktop_file_plugin_full_search (_data_->self, &_data_->_tmp7_, _data_->_tmp8_, 0);
#line 1349 "desktop-file-plugin.c"
	}
#line 216 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 216 "../../../src/plugins/desktop-file-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 216 "../../../src/plugins/desktop-file-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 216 "../../../src/plugins/desktop-file-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 216 "../../../src/plugins/desktop-file-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 216 "../../../src/plugins/desktop-file-plugin.vala"
			block1_data_unref (_data_->_data1_);
#line 216 "../../../src/plugins/desktop-file-plugin.vala"
			_data_->_data1_ = NULL;
#line 216 "../../../src/plugins/desktop-file-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 216 "../../../src/plugins/desktop-file-plugin.vala"
			return FALSE;
#line 1369 "desktop-file-plugin.c"
		} else {
#line 216 "../../../src/plugins/desktop-file-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 216 "../../../src/plugins/desktop-file-plugin.vala"
			block1_data_unref (_data_->_data1_);
#line 216 "../../../src/plugins/desktop-file-plugin.vala"
			_data_->_data1_ = NULL;
#line 216 "../../../src/plugins/desktop-file-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 216 "../../../src/plugins/desktop-file-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 216 "../../../src/plugins/desktop-file-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 216 "../../../src/plugins/desktop-file-plugin.vala"
			return FALSE;
#line 1385 "desktop-file-plugin.c"
		}
	}
#line 218 "../../../src/plugins/desktop-file-plugin.vala"
	_data_->result = _data_->_result_;
#line 218 "../../../src/plugins/desktop-file-plugin.vala"
	block1_data_unref (_data_->_data1_);
#line 218 "../../../src/plugins/desktop-file-plugin.vala"
	_data_->_data1_ = NULL;
#line 218 "../../../src/plugins/desktop-file-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 218 "../../../src/plugins/desktop-file-plugin.vala"
	if (_data_->_state_ != 0) {
#line 218 "../../../src/plugins/desktop-file-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 218 "../../../src/plugins/desktop-file-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1402 "desktop-file-plugin.c"
		}
	}
#line 218 "../../../src/plugins/desktop-file-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 218 "../../../src/plugins/desktop-file-plugin.vala"
	return FALSE;
#line 1409 "desktop-file-plugin.c"
}

static SynapseResultSet*
synapse_desktop_file_plugin_real_find_for_match (SynapseActionProvider* base,
                                                 SynapseQuery* query,
                                                 SynapseMatch* match)
{
	SynapseDesktopFilePlugin * self;
	SynapseUriMatch* uri_match = NULL;
	SynapseDesktopFilePluginDesktopFileMatch* app_match = NULL;
	GeeList* any_list = NULL;
	SynapseUriMatch* _tmp0_;
	gboolean _tmp73_ = FALSE;
	GeeList* _tmp74_;
	SynapseResultSet* rs = NULL;
	SynapseResultSet* _tmp78_;
	SynapseQuery _tmp79_;
	const gchar* _tmp80_;
	SynapseResultSet* result = NULL;
#line 298 "../../../src/plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) base;
#line 298 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 298 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (match != NULL, NULL);
#line 300 "../../../src/plugins/desktop-file-plugin.vala"
	uri_match = NULL;
#line 301 "../../../src/plugins/desktop-file-plugin.vala"
	app_match = NULL;
#line 302 "../../../src/plugins/desktop-file-plugin.vala"
	any_list = NULL;
#line 304 "../../../src/plugins/desktop-file-plugin.vala"
	uri_match = G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_URI_MATCH) ? ((SynapseUriMatch*) match) : NULL;
#line 304 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp0_ = uri_match;
#line 304 "../../../src/plugins/desktop-file-plugin.vala"
	if (_tmp0_ != NULL) {
#line 1447 "desktop-file-plugin.c"
		SynapseDesktopFileService* dfs = NULL;
		SynapseDesktopFileService* _tmp1_;
		GeeList* list_for_mimetype = NULL;
		SynapseDesktopFileService* _tmp2_;
		SynapseUriMatch* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GeeList* _tmp6_;
		GeeList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
#line 306 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp1_ = synapse_desktop_file_service_get_default ();
#line 306 "../../../src/plugins/desktop-file-plugin.vala"
		dfs = _tmp1_;
#line 307 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp2_ = dfs;
#line 307 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp3_ = uri_match;
#line 307 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp4_ = synapse_uri_match_get_mime_type (_tmp3_);
#line 307 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp5_ = _tmp4_;
#line 307 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp6_ = synapse_desktop_file_service_get_desktop_files_for_type (_tmp2_, _tmp5_);
#line 307 "../../../src/plugins/desktop-file-plugin.vala"
		list_for_mimetype = _tmp6_;
#line 309 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp7_ = list_for_mimetype;
#line 309 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
#line 309 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp9_ = _tmp8_;
#line 309 "../../../src/plugins/desktop-file-plugin.vala"
		if (_tmp9_ > 1) {
#line 1483 "desktop-file-plugin.c"
			GeeList* ow_list = NULL;
			GeeMap* _tmp10_;
			SynapseUriMatch* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gpointer _tmp14_;
			GeeList* _tmp15_;
			GeeList* _tmp35_;
			GeeList* _tmp36_;
#line 312 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp10_ = self->priv->mimetype_map;
#line 312 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp11_ = uri_match;
#line 312 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp12_ = synapse_uri_match_get_mime_type (_tmp11_);
#line 312 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp13_ = _tmp12_;
#line 312 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp14_ = gee_map_get (_tmp10_, _tmp13_);
#line 312 "../../../src/plugins/desktop-file-plugin.vala"
			ow_list = (GeeList*) _tmp14_;
#line 313 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp15_ = ow_list;
#line 313 "../../../src/plugins/desktop-file-plugin.vala"
			if (_tmp15_ == NULL) {
#line 1509 "desktop-file-plugin.c"
				GeeLinkedList* _tmp16_;
				GeeMap* _tmp17_;
				SynapseUriMatch* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				GeeList* _tmp21_;
#line 315 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp16_ = gee_linked_list_new (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 315 "../../../src/plugins/desktop-file-plugin.vala"
				_g_object_unref0 (ow_list);
#line 315 "../../../src/plugins/desktop-file-plugin.vala"
				ow_list = (GeeList*) _tmp16_;
#line 316 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp17_ = self->priv->mimetype_map;
#line 316 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp18_ = uri_match;
#line 316 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp19_ = synapse_uri_match_get_mime_type (_tmp18_);
#line 316 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp20_ = _tmp19_;
#line 316 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp21_ = ow_list;
#line 316 "../../../src/plugins/desktop-file-plugin.vala"
				gee_map_set (_tmp17_, _tmp20_, _tmp21_);
#line 1534 "desktop-file-plugin.c"
				{
					GeeList* _entry_list = NULL;
					GeeList* _tmp22_;
					GeeList* _tmp23_;
					gint _entry_size = 0;
					GeeList* _tmp24_;
					gint _tmp25_;
					gint _tmp26_;
					gint _entry_index = 0;
#line 318 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp22_ = list_for_mimetype;
#line 318 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp23_ = _g_object_ref0 (_tmp22_);
#line 318 "../../../src/plugins/desktop-file-plugin.vala"
					_entry_list = _tmp23_;
#line 318 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp24_ = _entry_list;
#line 318 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp25_ = gee_collection_get_size ((GeeCollection*) _tmp24_);
#line 318 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp26_ = _tmp25_;
#line 318 "../../../src/plugins/desktop-file-plugin.vala"
					_entry_size = _tmp26_;
#line 318 "../../../src/plugins/desktop-file-plugin.vala"
					_entry_index = -1;
#line 318 "../../../src/plugins/desktop-file-plugin.vala"
					while (TRUE) {
#line 1562 "desktop-file-plugin.c"
						gint _tmp27_;
						gint _tmp28_;
						SynapseDesktopFileInfo* entry = NULL;
						GeeList* _tmp29_;
						gpointer _tmp30_;
						GeeList* _tmp31_;
						SynapseDesktopFileInfo* _tmp32_;
						SynapseDesktopFilePluginOpenWithAction* _tmp33_;
						SynapseDesktopFilePluginOpenWithAction* _tmp34_;
#line 318 "../../../src/plugins/desktop-file-plugin.vala"
						_entry_index = _entry_index + 1;
#line 318 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp27_ = _entry_index;
#line 318 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp28_ = _entry_size;
#line 318 "../../../src/plugins/desktop-file-plugin.vala"
						if (!(_tmp27_ < _tmp28_)) {
#line 318 "../../../src/plugins/desktop-file-plugin.vala"
							break;
#line 1582 "desktop-file-plugin.c"
						}
#line 318 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp29_ = _entry_list;
#line 318 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp30_ = gee_list_get (_tmp29_, _entry_index);
#line 318 "../../../src/plugins/desktop-file-plugin.vala"
						entry = (SynapseDesktopFileInfo*) _tmp30_;
#line 320 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp31_ = ow_list;
#line 320 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp32_ = entry;
#line 320 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp33_ = synapse_desktop_file_plugin_open_with_action_new (_tmp32_);
#line 320 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp34_ = _tmp33_;
#line 320 "../../../src/plugins/desktop-file-plugin.vala"
						gee_collection_add ((GeeCollection*) _tmp31_, _tmp34_);
#line 320 "../../../src/plugins/desktop-file-plugin.vala"
						_g_object_unref0 (_tmp34_);
#line 318 "../../../src/plugins/desktop-file-plugin.vala"
						_g_object_unref0 (entry);
#line 1604 "desktop-file-plugin.c"
					}
#line 318 "../../../src/plugins/desktop-file-plugin.vala"
					_g_object_unref0 (_entry_list);
#line 1608 "desktop-file-plugin.c"
				}
			}
#line 324 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp35_ = ow_list;
#line 324 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp36_ = _g_object_ref0 (_tmp35_);
#line 324 "../../../src/plugins/desktop-file-plugin.vala"
			_g_object_unref0 (any_list);
#line 324 "../../../src/plugins/desktop-file-plugin.vala"
			any_list = _tmp36_;
#line 309 "../../../src/plugins/desktop-file-plugin.vala"
			_g_object_unref0 (ow_list);
#line 1621 "desktop-file-plugin.c"
		}
#line 304 "../../../src/plugins/desktop-file-plugin.vala"
		_g_object_unref0 (list_for_mimetype);
#line 304 "../../../src/plugins/desktop-file-plugin.vala"
		_g_object_unref0 (dfs);
#line 1627 "desktop-file-plugin.c"
	} else {
		SynapseDesktopFilePluginDesktopFileMatch* _tmp37_;
#line 327 "../../../src/plugins/desktop-file-plugin.vala"
		app_match = SYNAPSE_DESKTOP_FILE_PLUGIN_IS_DESKTOP_FILE_MATCH (match) ? ((SynapseDesktopFilePluginDesktopFileMatch*) match) : NULL;
#line 327 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp37_ = app_match;
#line 327 "../../../src/plugins/desktop-file-plugin.vala"
		if (_tmp37_ != NULL) {
#line 1636 "desktop-file-plugin.c"
			GeeList* oa_list = NULL;
			GeeMap* _tmp38_;
			SynapseDesktopFilePluginDesktopFileMatch* _tmp39_;
			const gchar* _tmp40_;
			const gchar* _tmp41_;
			gpointer _tmp42_;
			GeeList* _tmp43_;
			GeeList* _tmp71_;
			GeeList* _tmp72_;
#line 329 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp38_ = self->priv->actions_map;
#line 329 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp39_ = app_match;
#line 329 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp40_ = synapse_application_match_get_filename ((SynapseApplicationMatch*) _tmp39_);
#line 329 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp41_ = _tmp40_;
#line 329 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp42_ = gee_map_get (_tmp38_, _tmp41_);
#line 329 "../../../src/plugins/desktop-file-plugin.vala"
			oa_list = (GeeList*) _tmp42_;
#line 330 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp43_ = oa_list;
#line 330 "../../../src/plugins/desktop-file-plugin.vala"
			if (_tmp43_ == NULL) {
#line 1662 "desktop-file-plugin.c"
				GeeLinkedList* _tmp44_;
				GeeMap* _tmp45_;
				SynapseDesktopFilePluginDesktopFileMatch* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				GeeList* _tmp49_;
				SynapseDesktopFileService* dfs = NULL;
				SynapseDesktopFileService* _tmp50_;
				SynapseDesktopFileInfo* desktop_file_info = NULL;
				SynapseDesktopFileService* _tmp51_;
				SynapseDesktopFilePluginDesktopFileMatch* _tmp52_;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
				SynapseDesktopFileInfo* _tmp57_;
				SynapseDesktopFileInfo* _tmp58_;
				SynapseDesktopFileInfo* _tmp59_;
#line 332 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp44_ = gee_linked_list_new (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 332 "../../../src/plugins/desktop-file-plugin.vala"
				_g_object_unref0 (oa_list);
#line 332 "../../../src/plugins/desktop-file-plugin.vala"
				oa_list = (GeeList*) _tmp44_;
#line 333 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp45_ = self->priv->actions_map;
#line 333 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp46_ = app_match;
#line 333 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp47_ = synapse_application_match_get_filename ((SynapseApplicationMatch*) _tmp46_);
#line 333 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp48_ = _tmp47_;
#line 333 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp49_ = oa_list;
#line 333 "../../../src/plugins/desktop-file-plugin.vala"
				gee_map_set (_tmp45_, _tmp48_, _tmp49_);
#line 335 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp50_ = synapse_desktop_file_service_get_default ();
#line 335 "../../../src/plugins/desktop-file-plugin.vala"
				dfs = _tmp50_;
#line 336 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp51_ = dfs;
#line 336 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp52_ = app_match;
#line 336 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp53_ = synapse_application_match_get_filename ((SynapseApplicationMatch*) _tmp52_);
#line 336 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp54_ = _tmp53_;
#line 336 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp55_ = g_path_get_basename (_tmp54_);
#line 336 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp56_ = _tmp55_;
#line 336 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp57_ = synapse_desktop_file_service_get_desktop_file_for_id (_tmp51_, _tmp56_);
#line 336 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp58_ = _tmp57_;
#line 336 "../../../src/plugins/desktop-file-plugin.vala"
				_g_free0 (_tmp56_);
#line 336 "../../../src/plugins/desktop-file-plugin.vala"
				desktop_file_info = _tmp58_;
#line 339 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp59_ = desktop_file_info;
#line 339 "../../../src/plugins/desktop-file-plugin.vala"
				if (_tmp59_ != NULL) {
#line 1727 "desktop-file-plugin.c"
					SynapseDesktopFileInfo* _tmp60_;
					gchar** _tmp61_;
					gint _tmp61__length1;
#line 341 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp60_ = desktop_file_info;
#line 341 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp61_ = _tmp60_->actions;
#line 341 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp61__length1 = _tmp60_->actions_length1;
#line 1737 "desktop-file-plugin.c"
					{
						gchar** action_collection = NULL;
						gint action_collection_length1 = 0;
						gint _action_collection_size_ = 0;
						gint action_it = 0;
#line 341 "../../../src/plugins/desktop-file-plugin.vala"
						action_collection = _tmp61_;
#line 341 "../../../src/plugins/desktop-file-plugin.vala"
						action_collection_length1 = _tmp61__length1;
#line 341 "../../../src/plugins/desktop-file-plugin.vala"
						for (action_it = 0; action_it < action_collection_length1; action_it = action_it + 1) {
#line 1749 "desktop-file-plugin.c"
							gchar* _tmp62_;
							gchar* action = NULL;
#line 341 "../../../src/plugins/desktop-file-plugin.vala"
							_tmp62_ = g_strdup (action_collection[action_it]);
#line 341 "../../../src/plugins/desktop-file-plugin.vala"
							action = _tmp62_;
#line 1756 "desktop-file-plugin.c"
							{
								GeeList* _tmp63_;
								SynapseDesktopFileInfo* _tmp64_;
								const gchar* _tmp65_;
								SynapseDesktopFilePluginOpenAppAction* _tmp66_;
								SynapseDesktopFilePluginOpenAppAction* _tmp67_;
#line 343 "../../../src/plugins/desktop-file-plugin.vala"
								_tmp63_ = oa_list;
#line 343 "../../../src/plugins/desktop-file-plugin.vala"
								_tmp64_ = desktop_file_info;
#line 343 "../../../src/plugins/desktop-file-plugin.vala"
								_tmp65_ = action;
#line 343 "../../../src/plugins/desktop-file-plugin.vala"
								_tmp66_ = synapse_desktop_file_plugin_open_app_action_new (_tmp64_, _tmp65_);
#line 343 "../../../src/plugins/desktop-file-plugin.vala"
								_tmp67_ = _tmp66_;
#line 343 "../../../src/plugins/desktop-file-plugin.vala"
								gee_collection_add ((GeeCollection*) _tmp63_, _tmp67_);
#line 343 "../../../src/plugins/desktop-file-plugin.vala"
								_g_object_unref0 (_tmp67_);
#line 341 "../../../src/plugins/desktop-file-plugin.vala"
								_g_free0 (action);
#line 1779 "desktop-file-plugin.c"
							}
						}
					}
				} else {
					SynapseDesktopFilePluginDesktopFileMatch* _tmp68_;
					const gchar* _tmp69_;
					const gchar* _tmp70_;
#line 348 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp68_ = app_match;
#line 348 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp69_ = synapse_application_match_get_filename ((SynapseApplicationMatch*) _tmp68_);
#line 348 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp70_ = _tmp69_;
#line 348 "../../../src/plugins/desktop-file-plugin.vala"
					g_warning ("desktop-file-plugin.vala:348: No DesktopInfoFile for %s", _tmp70_);
#line 1795 "desktop-file-plugin.c"
				}
#line 330 "../../../src/plugins/desktop-file-plugin.vala"
				_g_object_unref0 (desktop_file_info);
#line 330 "../../../src/plugins/desktop-file-plugin.vala"
				_g_object_unref0 (dfs);
#line 1801 "desktop-file-plugin.c"
			}
#line 352 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp71_ = oa_list;
#line 352 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp72_ = _g_object_ref0 (_tmp71_);
#line 352 "../../../src/plugins/desktop-file-plugin.vala"
			_g_object_unref0 (any_list);
#line 352 "../../../src/plugins/desktop-file-plugin.vala"
			any_list = _tmp72_;
#line 327 "../../../src/plugins/desktop-file-plugin.vala"
			_g_object_unref0 (oa_list);
#line 1813 "desktop-file-plugin.c"
		}
	}
#line 355 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp74_ = any_list;
#line 355 "../../../src/plugins/desktop-file-plugin.vala"
	if (_tmp74_ == NULL) {
#line 355 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp73_ = TRUE;
#line 1822 "desktop-file-plugin.c"
	} else {
		GeeList* _tmp75_;
		gint _tmp76_;
		gint _tmp77_;
#line 355 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp75_ = any_list;
#line 355 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp76_ = gee_collection_get_size ((GeeCollection*) _tmp75_);
#line 355 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp77_ = _tmp76_;
#line 355 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp73_ = _tmp77_ == 0;
#line 1835 "desktop-file-plugin.c"
	}
#line 355 "../../../src/plugins/desktop-file-plugin.vala"
	if (_tmp73_) {
#line 355 "../../../src/plugins/desktop-file-plugin.vala"
		result = NULL;
#line 355 "../../../src/plugins/desktop-file-plugin.vala"
		_g_object_unref0 (any_list);
#line 355 "../../../src/plugins/desktop-file-plugin.vala"
		return result;
#line 1845 "desktop-file-plugin.c"
	}
#line 357 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp78_ = synapse_result_set_new ();
#line 357 "../../../src/plugins/desktop-file-plugin.vala"
	rs = _tmp78_;
#line 359 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp79_ = *query;
#line 359 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp80_ = _tmp79_.query_string;
#line 359 "../../../src/plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (_tmp80_, "") == 0) {
#line 1857 "desktop-file-plugin.c"
		{
			GeeList* _action_list = NULL;
			GeeList* _tmp81_;
			GeeList* _tmp82_;
			gint _action_size = 0;
			GeeList* _tmp83_;
			gint _tmp84_;
			gint _tmp85_;
			gint _action_index = 0;
#line 361 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp81_ = any_list;
#line 361 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp82_ = _g_object_ref0 (_tmp81_);
#line 361 "../../../src/plugins/desktop-file-plugin.vala"
			_action_list = _tmp82_;
#line 361 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp83_ = _action_list;
#line 361 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp84_ = gee_collection_get_size ((GeeCollection*) _tmp83_);
#line 361 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp85_ = _tmp84_;
#line 361 "../../../src/plugins/desktop-file-plugin.vala"
			_action_size = _tmp85_;
#line 361 "../../../src/plugins/desktop-file-plugin.vala"
			_action_index = -1;
#line 361 "../../../src/plugins/desktop-file-plugin.vala"
			while (TRUE) {
#line 1885 "desktop-file-plugin.c"
				gint _tmp86_;
				gint _tmp87_;
				SynapseAction* action = NULL;
				GeeList* _tmp88_;
				gpointer _tmp89_;
				SynapseResultSet* _tmp90_;
				SynapseAction* _tmp91_;
#line 361 "../../../src/plugins/desktop-file-plugin.vala"
				_action_index = _action_index + 1;
#line 361 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp86_ = _action_index;
#line 361 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp87_ = _action_size;
#line 361 "../../../src/plugins/desktop-file-plugin.vala"
				if (!(_tmp86_ < _tmp87_)) {
#line 361 "../../../src/plugins/desktop-file-plugin.vala"
					break;
#line 1903 "desktop-file-plugin.c"
				}
#line 361 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp88_ = _action_list;
#line 361 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp89_ = gee_list_get (_tmp88_, _action_index);
#line 361 "../../../src/plugins/desktop-file-plugin.vala"
				action = (SynapseAction*) _tmp89_;
#line 363 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp90_ = rs;
#line 363 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp91_ = action;
#line 363 "../../../src/plugins/desktop-file-plugin.vala"
				synapse_result_set_add (_tmp90_, (SynapseMatch*) _tmp91_, (gint) SYNAPSE_MATCH_SCORE_POOR);
#line 361 "../../../src/plugins/desktop-file-plugin.vala"
				_g_object_unref0 (action);
#line 1919 "desktop-file-plugin.c"
			}
#line 361 "../../../src/plugins/desktop-file-plugin.vala"
			_g_object_unref0 (_action_list);
#line 1923 "desktop-file-plugin.c"
		}
	} else {
		GeeList* matchers = NULL;
		SynapseQuery _tmp92_;
		const gchar* _tmp93_;
		GeeList* _tmp94_;
#line 368 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp92_ = *query;
#line 368 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp93_ = _tmp92_.query_string;
#line 368 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp94_ = synapse_query_get_matchers_for_query (_tmp93_, 0, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
#line 368 "../../../src/plugins/desktop-file-plugin.vala"
		matchers = _tmp94_;
#line 1938 "desktop-file-plugin.c"
		{
			GeeList* _action_list = NULL;
			GeeList* _tmp95_;
			GeeList* _tmp96_;
			gint _action_size = 0;
			GeeList* _tmp97_;
			gint _tmp98_;
			gint _tmp99_;
			gint _action_index = 0;
#line 370 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp95_ = any_list;
#line 370 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp96_ = _g_object_ref0 (_tmp95_);
#line 370 "../../../src/plugins/desktop-file-plugin.vala"
			_action_list = _tmp96_;
#line 370 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp97_ = _action_list;
#line 370 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp98_ = gee_collection_get_size ((GeeCollection*) _tmp97_);
#line 370 "../../../src/plugins/desktop-file-plugin.vala"
			_tmp99_ = _tmp98_;
#line 370 "../../../src/plugins/desktop-file-plugin.vala"
			_action_size = _tmp99_;
#line 370 "../../../src/plugins/desktop-file-plugin.vala"
			_action_index = -1;
#line 370 "../../../src/plugins/desktop-file-plugin.vala"
			while (TRUE) {
#line 1966 "desktop-file-plugin.c"
				gint _tmp100_;
				gint _tmp101_;
				SynapseAction* action = NULL;
				GeeList* _tmp102_;
				gpointer _tmp103_;
#line 370 "../../../src/plugins/desktop-file-plugin.vala"
				_action_index = _action_index + 1;
#line 370 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp100_ = _action_index;
#line 370 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp101_ = _action_size;
#line 370 "../../../src/plugins/desktop-file-plugin.vala"
				if (!(_tmp100_ < _tmp101_)) {
#line 370 "../../../src/plugins/desktop-file-plugin.vala"
					break;
#line 1982 "desktop-file-plugin.c"
				}
#line 370 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp102_ = _action_list;
#line 370 "../../../src/plugins/desktop-file-plugin.vala"
				_tmp103_ = gee_list_get (_tmp102_, _action_index);
#line 370 "../../../src/plugins/desktop-file-plugin.vala"
				action = (SynapseAction*) _tmp103_;
#line 1990 "desktop-file-plugin.c"
				{
					GeeList* _matcher_list = NULL;
					GeeList* _tmp104_;
					GeeList* _tmp105_;
					gint _matcher_size = 0;
					GeeList* _tmp106_;
					gint _tmp107_;
					gint _tmp108_;
					gint _matcher_index = 0;
#line 372 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp104_ = matchers;
#line 372 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp105_ = _g_object_ref0 (_tmp104_);
#line 372 "../../../src/plugins/desktop-file-plugin.vala"
					_matcher_list = _tmp105_;
#line 372 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp106_ = _matcher_list;
#line 372 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp107_ = gee_collection_get_size ((GeeCollection*) _tmp106_);
#line 372 "../../../src/plugins/desktop-file-plugin.vala"
					_tmp108_ = _tmp107_;
#line 372 "../../../src/plugins/desktop-file-plugin.vala"
					_matcher_size = _tmp108_;
#line 372 "../../../src/plugins/desktop-file-plugin.vala"
					_matcher_index = -1;
#line 372 "../../../src/plugins/desktop-file-plugin.vala"
					while (TRUE) {
#line 2018 "desktop-file-plugin.c"
						gint _tmp109_;
						gint _tmp110_;
						GeeMapEntry* matcher = NULL;
						GeeList* _tmp111_;
						gpointer _tmp112_;
						GeeMapEntry* _tmp113_;
						gconstpointer _tmp114_;
						gconstpointer _tmp115_;
						SynapseAction* _tmp116_;
						const gchar* _tmp117_;
						const gchar* _tmp118_;
#line 372 "../../../src/plugins/desktop-file-plugin.vala"
						_matcher_index = _matcher_index + 1;
#line 372 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp109_ = _matcher_index;
#line 372 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp110_ = _matcher_size;
#line 372 "../../../src/plugins/desktop-file-plugin.vala"
						if (!(_tmp109_ < _tmp110_)) {
#line 372 "../../../src/plugins/desktop-file-plugin.vala"
							break;
#line 2040 "desktop-file-plugin.c"
						}
#line 372 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp111_ = _matcher_list;
#line 372 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp112_ = gee_list_get (_tmp111_, _matcher_index);
#line 372 "../../../src/plugins/desktop-file-plugin.vala"
						matcher = (GeeMapEntry*) _tmp112_;
#line 374 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp113_ = matcher;
#line 374 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp114_ = gee_map_entry_get_key (_tmp113_);
#line 374 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp115_ = _tmp114_;
#line 374 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp116_ = action;
#line 374 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp117_ = synapse_match_get_title ((SynapseMatch*) _tmp116_);
#line 374 "../../../src/plugins/desktop-file-plugin.vala"
						_tmp118_ = _tmp117_;
#line 374 "../../../src/plugins/desktop-file-plugin.vala"
						if (g_regex_match ((GRegex*) _tmp115_, _tmp118_, 0, NULL)) {
#line 2062 "desktop-file-plugin.c"
							SynapseResultSet* _tmp119_;
							SynapseAction* _tmp120_;
							GeeMapEntry* _tmp121_;
							gconstpointer _tmp122_;
							gconstpointer _tmp123_;
#line 376 "../../../src/plugins/desktop-file-plugin.vala"
							_tmp119_ = rs;
#line 376 "../../../src/plugins/desktop-file-plugin.vala"
							_tmp120_ = action;
#line 376 "../../../src/plugins/desktop-file-plugin.vala"
							_tmp121_ = matcher;
#line 376 "../../../src/plugins/desktop-file-plugin.vala"
							_tmp122_ = gee_map_entry_get_value (_tmp121_);
#line 376 "../../../src/plugins/desktop-file-plugin.vala"
							_tmp123_ = _tmp122_;
#line 376 "../../../src/plugins/desktop-file-plugin.vala"
							synapse_result_set_add (_tmp119_, (SynapseMatch*) _tmp120_, (gint) ((gintptr) _tmp123_));
#line 377 "../../../src/plugins/desktop-file-plugin.vala"
							_g_object_unref0 (matcher);
#line 377 "../../../src/plugins/desktop-file-plugin.vala"
							break;
#line 2084 "desktop-file-plugin.c"
						}
#line 372 "../../../src/plugins/desktop-file-plugin.vala"
						_g_object_unref0 (matcher);
#line 2088 "desktop-file-plugin.c"
					}
#line 372 "../../../src/plugins/desktop-file-plugin.vala"
					_g_object_unref0 (_matcher_list);
#line 2092 "desktop-file-plugin.c"
				}
#line 370 "../../../src/plugins/desktop-file-plugin.vala"
				_g_object_unref0 (action);
#line 2096 "desktop-file-plugin.c"
			}
#line 370 "../../../src/plugins/desktop-file-plugin.vala"
			_g_object_unref0 (_action_list);
#line 2100 "desktop-file-plugin.c"
		}
#line 359 "../../../src/plugins/desktop-file-plugin.vala"
		_g_object_unref0 (matchers);
#line 2104 "desktop-file-plugin.c"
	}
#line 383 "../../../src/plugins/desktop-file-plugin.vala"
	result = rs;
#line 383 "../../../src/plugins/desktop-file-plugin.vala"
	_g_object_unref0 (any_list);
#line 383 "../../../src/plugins/desktop-file-plugin.vala"
	return result;
#line 2112 "desktop-file-plugin.c"
}

SynapseDesktopFilePlugin*
synapse_desktop_file_plugin_construct (GType object_type)
{
	SynapseDesktopFilePlugin * self = NULL;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) g_object_new (object_type, NULL);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	return self;
#line 2123 "desktop-file-plugin.c"
}

SynapseDesktopFilePlugin*
synapse_desktop_file_plugin_new (void)
{
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	return synapse_desktop_file_plugin_construct (SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN);
#line 2131 "desktop-file-plugin.c"
}

static gboolean
synapse_desktop_file_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseDesktopFilePlugin* self;
#line 26 "../../../src/plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) base;
#line 26 "../../../src/plugins/desktop-file-plugin.vala"
	result = self->priv->_enabled;
#line 26 "../../../src/plugins/desktop-file-plugin.vala"
	return result;
#line 2145 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_real_set_enabled (SynapseActivatable* base,
                                              gboolean value)
{
	SynapseDesktopFilePlugin* self;
	gboolean old_value;
#line 26 "../../../src/plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) base;
#line 26 "../../../src/plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_real_get_enabled (base);
#line 26 "../../../src/plugins/desktop-file-plugin.vala"
	if (old_value != value) {
#line 26 "../../../src/plugins/desktop-file-plugin.vala"
		self->priv->_enabled = value;
#line 26 "../../../src/plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY]);
#line 2164 "desktop-file-plugin.c"
	}
}

static inline gpointer
synapse_desktop_file_plugin_desktop_file_match_get_instance_private (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFilePluginDesktopFileMatch_private_offset);
}

static SynapseDesktopFilePluginDesktopFileMatch*
synapse_desktop_file_plugin_desktop_file_match_construct (GType object_type,
                                                          SynapseDesktopFileInfo* info)
{
	SynapseDesktopFilePluginDesktopFileMatch * self = NULL;
#line 46 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (info != NULL, NULL);
#line 48 "../../../src/plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginDesktopFileMatch*) g_object_new (object_type, "desktop-info", info, NULL);
#line 46 "../../../src/plugins/desktop-file-plugin.vala"
	return self;
#line 2185 "desktop-file-plugin.c"
}

static SynapseDesktopFilePluginDesktopFileMatch*
synapse_desktop_file_plugin_desktop_file_match_new (SynapseDesktopFileInfo* info)
{
#line 46 "../../../src/plugins/desktop-file-plugin.vala"
	return synapse_desktop_file_plugin_desktop_file_match_construct (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, info);
#line 2193 "desktop-file-plugin.c"
}

static SynapseDesktopFileInfo*
synapse_desktop_file_plugin_desktop_file_match_get_desktop_info (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	SynapseDesktopFileInfo* result;
	SynapseDesktopFileInfo* _tmp0_;
#line 40 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 40 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_desktop_info;
#line 40 "../../../src/plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 40 "../../../src/plugins/desktop-file-plugin.vala"
	return result;
#line 2209 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_set_desktop_info (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                 SynapseDesktopFileInfo* value)
{
	SynapseDesktopFileInfo* old_value;
#line 40 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 40 "../../../src/plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_get_desktop_info (self);
#line 40 "../../../src/plugins/desktop-file-plugin.vala"
	if (old_value != value) {
#line 2223 "desktop-file-plugin.c"
		SynapseDesktopFileInfo* _tmp0_;
#line 40 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 40 "../../../src/plugins/desktop-file-plugin.vala"
		_g_object_unref0 (self->priv->_desktop_info);
#line 40 "../../../src/plugins/desktop-file-plugin.vala"
		self->priv->_desktop_info = _tmp0_;
#line 40 "../../../src/plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_INFO_PROPERTY]);
#line 2233 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_title_folded (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 41 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 41 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_title_folded;
#line 41 "../../../src/plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 41 "../../../src/plugins/desktop-file-plugin.vala"
	return result;
#line 2250 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_set_title_folded (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                 const gchar* value)
{
	gchar* old_value;
#line 41 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 41 "../../../src/plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_get_title_folded (self);
#line 41 "../../../src/plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2264 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 41 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 41 "../../../src/plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_title_folded);
#line 41 "../../../src/plugins/desktop-file-plugin.vala"
		self->priv->_title_folded = _tmp0_;
#line 41 "../../../src/plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_FOLDED_PROPERTY]);
#line 2274 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 42 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_title_unaccented;
#line 42 "../../../src/plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 42 "../../../src/plugins/desktop-file-plugin.vala"
	return result;
#line 2291 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                     const gchar* value)
{
	gchar* old_value;
#line 42 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 42 "../../../src/plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (self);
#line 42 "../../../src/plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2305 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 42 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 42 "../../../src/plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_title_unaccented);
#line 42 "../../../src/plugins/desktop-file-plugin.vala"
		self->priv->_title_unaccented = _tmp0_;
#line 42 "../../../src/plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY]);
#line 2315 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 43 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 43 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_desktop_id;
#line 43 "../../../src/plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 43 "../../../src/plugins/desktop-file-plugin.vala"
	return result;
#line 2332 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                               const gchar* value)
{
	gchar* old_value;
#line 43 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 43 "../../../src/plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (self);
#line 43 "../../../src/plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2346 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 43 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 43 "../../../src/plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_desktop_id);
#line 43 "../../../src/plugins/desktop-file-plugin.vala"
		self->priv->_desktop_id = _tmp0_;
#line 43 "../../../src/plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY]);
#line 2356 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_exec (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 44 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 44 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_exec;
#line 44 "../../../src/plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 44 "../../../src/plugins/desktop-file-plugin.vala"
	return result;
#line 2373 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_set_exec (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                         const gchar* value)
{
	gchar* old_value;
#line 44 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 44 "../../../src/plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_get_exec (self);
#line 44 "../../../src/plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2387 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 44 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 44 "../../../src/plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_exec);
#line 44 "../../../src/plugins/desktop-file-plugin.vala"
		self->priv->_exec = _tmp0_;
#line 44 "../../../src/plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY]);
#line 2397 "desktop-file-plugin.c"
	}
}

static GObject *
synapse_desktop_file_plugin_desktop_file_match_constructor (GType type,
                                                            guint n_construct_properties,
                                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDesktopFilePluginDesktopFileMatch * self;
	SynapseDesktopFileInfo* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	SynapseDesktopFileInfo* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	SynapseDesktopFileInfo* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	SynapseDesktopFileInfo* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	SynapseDesktopFileInfo* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	SynapseDesktopFileInfo* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	gchar* _tmp18_ = NULL;
	SynapseDesktopFileInfo* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	SynapseDesktopFileInfo* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
#line 51 "../../../src/plugins/desktop-file-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_desktop_file_plugin_desktop_file_match_parent_class);
#line 51 "../../../src/plugins/desktop-file-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 51 "../../../src/plugins/desktop-file-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatch);
#line 53 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_desktop_info;
#line 53 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp1_ = synapse_desktop_file_info_get_filename (_tmp0_);
#line 53 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp2_ = _tmp1_;
#line 53 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_application_match_set_filename ((SynapseApplicationMatch*) self, _tmp2_);
#line 54 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp3_ = self->priv->_desktop_info;
#line 54 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp4_ = synapse_desktop_file_info_get_name (_tmp3_);
#line 54 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp5_ = _tmp4_;
#line 54 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_match_set_title ((SynapseMatch*) self, _tmp5_);
#line 55 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp6_ = self->priv->_desktop_info;
#line 55 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp7_ = synapse_desktop_file_info_get_comment (_tmp6_);
#line 55 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp8_ = _tmp7_;
#line 55 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_match_set_description ((SynapseMatch*) self, _tmp8_);
#line 56 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp9_ = self->priv->_desktop_info;
#line 56 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp10_ = synapse_desktop_file_info_get_icon_name (_tmp9_);
#line 56 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp11_ = _tmp10_;
#line 56 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp11_);
#line 57 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp12_ = self->priv->_desktop_info;
#line 57 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp13_ = synapse_desktop_file_info_get_exec (_tmp12_);
#line 57 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp14_ = _tmp13_;
#line 57 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_desktop_file_match_set_exec (self, _tmp14_);
#line 58 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp15_ = self->priv->_desktop_info;
#line 58 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp16_ = synapse_desktop_file_info_get_needs_terminal (_tmp15_);
#line 58 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp17_ = _tmp16_;
#line 58 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_application_match_set_needs_terminal ((SynapseApplicationMatch*) self, _tmp17_);
#line 59 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp19_ = self->priv->_desktop_info;
#line 59 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp20_ = synapse_desktop_file_info_get_name_folded (_tmp19_);
#line 59 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp21_ = g_strdup (_tmp20_);
#line 59 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp18_ = _tmp21_;
#line 59 "../../../src/plugins/desktop-file-plugin.vala"
	if (_tmp18_ == NULL) {
#line 2503 "desktop-file-plugin.c"
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
#line 59 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp22_ = synapse_match_get_title ((SynapseMatch*) self);
#line 59 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp23_ = _tmp22_;
#line 59 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp24_ = g_utf8_casefold (_tmp23_, (gssize) -1);
#line 59 "../../../src/plugins/desktop-file-plugin.vala"
		_g_free0 (_tmp18_);
#line 59 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp18_ = _tmp24_;
#line 2517 "desktop-file-plugin.c"
	}
#line 59 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_desktop_file_match_set_title_folded (self, _tmp18_);
#line 60 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp25_ = self->priv->_title_folded;
#line 60 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp26_ = synapse_utils_remove_accents (_tmp25_);
#line 60 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp27_ = _tmp26_;
#line 60 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (self, _tmp27_);
#line 60 "../../../src/plugins/desktop-file-plugin.vala"
	_g_free0 (_tmp27_);
#line 61 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp28_ = self->priv->_desktop_info;
#line 61 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp29_ = synapse_desktop_file_info_get_desktop_id (_tmp28_);
#line 61 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp30_ = _tmp29_;
#line 61 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp31_ = g_strconcat ("application://", _tmp30_, NULL);
#line 61 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp32_ = _tmp31_;
#line 61 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (self, _tmp32_);
#line 61 "../../../src/plugins/desktop-file-plugin.vala"
	_g_free0 (_tmp32_);
#line 51 "../../../src/plugins/desktop-file-plugin.vala"
	_g_free0 (_tmp18_);
#line 51 "../../../src/plugins/desktop-file-plugin.vala"
	return obj;
#line 2549 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_class_init (SynapseDesktopFilePluginDesktopFileMatchClass * klass,
                                                           gpointer klass_data)
{
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_desktop_file_match_parent_class = g_type_class_peek_parent (klass);
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFilePluginDesktopFileMatch_private_offset);
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_plugin_desktop_file_match_get_property;
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_plugin_desktop_file_match_set_property;
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_desktop_file_plugin_desktop_file_match_constructor;
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_plugin_desktop_file_match_finalize;
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_INFO_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_INFO_PROPERTY] = g_param_spec_object ("desktop-info", "desktop-info", "desktop-info", SYNAPSE_TYPE_DESKTOP_FILE_INFO, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_FOLDED_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_FOLDED_PROPERTY] = g_param_spec_string ("title-folded", "title-folded", "title-folded", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY] = g_param_spec_string ("title-unaccented", "title-unaccented", "title-unaccented", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY] = g_param_spec_string ("desktop-id", "desktop-id", "desktop-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY] = g_param_spec_string ("exec", "exec", "exec", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 2578 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_instance_init (SynapseDesktopFilePluginDesktopFileMatch * self,
                                                              gpointer klass)
{
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
	self->priv = synapse_desktop_file_plugin_desktop_file_match_get_instance_private (self);
#line 2587 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_finalize (GObject * obj)
{
	SynapseDesktopFilePluginDesktopFileMatch * self;
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatch);
#line 40 "../../../src/plugins/desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->_desktop_info);
#line 41 "../../../src/plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_title_folded);
#line 42 "../../../src/plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_title_unaccented);
#line 43 "../../../src/plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_desktop_id);
#line 44 "../../../src/plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_exec);
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (synapse_desktop_file_plugin_desktop_file_match_parent_class)->finalize (obj);
#line 2608 "desktop-file-plugin.c"
}

static GType
synapse_desktop_file_plugin_desktop_file_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFilePluginDesktopFileMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_plugin_desktop_file_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFilePluginDesktopFileMatch), 0, (GInstanceInitFunc) synapse_desktop_file_plugin_desktop_file_match_instance_init, NULL };
	GType synapse_desktop_file_plugin_desktop_file_match_type_id;
	synapse_desktop_file_plugin_desktop_file_match_type_id = g_type_register_static (SYNAPSE_TYPE_APPLICATION_MATCH, "SynapseDesktopFilePluginDesktopFileMatch", &g_define_type_info, 0);
	SynapseDesktopFilePluginDesktopFileMatch_private_offset = g_type_add_instance_private (synapse_desktop_file_plugin_desktop_file_match_type_id, sizeof (SynapseDesktopFilePluginDesktopFileMatchPrivate));
	return synapse_desktop_file_plugin_desktop_file_match_type_id;
}

static GType
synapse_desktop_file_plugin_desktop_file_match_get_type (void)
{
	static volatile gsize synapse_desktop_file_plugin_desktop_file_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_plugin_desktop_file_match_type_id__volatile)) {
		GType synapse_desktop_file_plugin_desktop_file_match_type_id;
		synapse_desktop_file_plugin_desktop_file_match_type_id = synapse_desktop_file_plugin_desktop_file_match_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_plugin_desktop_file_match_type_id__volatile, synapse_desktop_file_plugin_desktop_file_match_type_id);
	}
	return synapse_desktop_file_plugin_desktop_file_match_type_id__volatile;
}

static void
_vala_synapse_desktop_file_plugin_desktop_file_match_get_property (GObject * object,
                                                                   guint property_id,
                                                                   GValue * value,
                                                                   GParamSpec * pspec)
{
	SynapseDesktopFilePluginDesktopFileMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatch);
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
	switch (property_id) {
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_INFO_PROPERTY:
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		g_value_set_object (value, synapse_desktop_file_plugin_desktop_file_match_get_desktop_info (self));
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_FOLDED_PROPERTY:
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_title_folded (self));
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY:
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (self));
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY:
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (self));
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY:
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_exec (self));
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 2673 "desktop-file-plugin.c"
		default:
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 2679 "desktop-file-plugin.c"
	}
}

static void
_vala_synapse_desktop_file_plugin_desktop_file_match_set_property (GObject * object,
                                                                   guint property_id,
                                                                   const GValue * value,
                                                                   GParamSpec * pspec)
{
	SynapseDesktopFilePluginDesktopFileMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatch);
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
	switch (property_id) {
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_INFO_PROPERTY:
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		synapse_desktop_file_plugin_desktop_file_match_set_desktop_info (self, g_value_get_object (value));
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_FOLDED_PROPERTY:
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		synapse_desktop_file_plugin_desktop_file_match_set_title_folded (self, g_value_get_string (value));
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY:
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (self, g_value_get_string (value));
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY:
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (self, g_value_get_string (value));
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY:
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		synapse_desktop_file_plugin_desktop_file_match_set_exec (self, g_value_get_string (value));
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 2723 "desktop-file-plugin.c"
		default:
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 2729 "desktop-file-plugin.c"
	}
}

static inline gpointer
synapse_desktop_file_plugin_open_with_action_get_instance_private (SynapseDesktopFilePluginOpenWithAction* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFilePluginOpenWithAction_private_offset);
}

static SynapseDesktopFilePluginOpenWithAction*
synapse_desktop_file_plugin_open_with_action_construct (GType object_type,
                                                        SynapseDesktopFileInfo* info)
{
	SynapseDesktopFilePluginOpenWithAction * self = NULL;
#line 225 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (info != NULL, NULL);
#line 227 "../../../src/plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenWithAction*) g_object_new (object_type, "desktop-info", info, NULL);
#line 225 "../../../src/plugins/desktop-file-plugin.vala"
	return self;
#line 2750 "desktop-file-plugin.c"
}

static SynapseDesktopFilePluginOpenWithAction*
synapse_desktop_file_plugin_open_with_action_new (SynapseDesktopFileInfo* info)
{
#line 225 "../../../src/plugins/desktop-file-plugin.vala"
	return synapse_desktop_file_plugin_open_with_action_construct (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, info);
#line 2758 "desktop-file-plugin.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 248 "../../../src/plugins/desktop-file-plugin.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 2766 "desktop-file-plugin.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 248 "../../../src/plugins/desktop-file-plugin.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 2774 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_with_action_real_do_execute (SynapseAction* base,
                                                              SynapseMatch* match,
                                                              SynapseMatch* target)
{
	SynapseDesktopFilePluginOpenWithAction * self;
	SynapseUriMatch* uri_match = NULL;
	GFile* f = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GError* _inner_error0_ = NULL;
#line 237 "../../../src/plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
#line 237 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_if_fail (match != NULL);
#line 239 "../../../src/plugins/desktop-file-plugin.vala"
	uri_match = G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_URI_MATCH) ? ((SynapseUriMatch*) match) : NULL;
#line 240 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_if_fail (uri_match != NULL);
#line 242 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp0_ = synapse_uri_match_get_uri (uri_match);
#line 242 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp1_ = _tmp0_;
#line 242 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp2_ = g_file_new_for_uri (_tmp1_);
#line 242 "../../../src/plugins/desktop-file-plugin.vala"
	f = _tmp2_;
#line 2805 "desktop-file-plugin.c"
	{
		GDesktopAppInfo* app_info = NULL;
		SynapseDesktopFileInfo* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GDesktopAppInfo* _tmp6_;
		GList* files = NULL;
		GFile* _tmp7_;
		GdkDisplay* _tmp8_;
		GdkAppLaunchContext* _tmp9_;
		GdkAppLaunchContext* _tmp10_;
#line 245 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp3_ = self->priv->_desktop_info;
#line 245 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp4_ = synapse_desktop_file_info_get_filename (_tmp3_);
#line 245 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp5_ = _tmp4_;
#line 245 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp6_ = g_desktop_app_info_new_from_filename (_tmp5_);
#line 245 "../../../src/plugins/desktop-file-plugin.vala"
		app_info = _tmp6_;
#line 246 "../../../src/plugins/desktop-file-plugin.vala"
		files = NULL;
#line 247 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp7_ = _g_object_ref0 (f);
#line 247 "../../../src/plugins/desktop-file-plugin.vala"
		files = g_list_prepend (files, _tmp7_);
#line 248 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp8_ = gdk_display_get_default ();
#line 248 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp9_ = gdk_display_get_app_launch_context (_tmp8_);
#line 248 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp10_ = _tmp9_;
#line 248 "../../../src/plugins/desktop-file-plugin.vala"
		g_app_info_launch ((GAppInfo*) app_info, files, (GAppLaunchContext*) _tmp10_, &_inner_error0_);
#line 248 "../../../src/plugins/desktop-file-plugin.vala"
		_g_object_unref0 (_tmp10_);
#line 248 "../../../src/plugins/desktop-file-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 248 "../../../src/plugins/desktop-file-plugin.vala"
			(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
#line 248 "../../../src/plugins/desktop-file-plugin.vala"
			_g_object_unref0 (app_info);
#line 2849 "desktop-file-plugin.c"
			goto __catch0_g_error;
		}
#line 243 "../../../src/plugins/desktop-file-plugin.vala"
		(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
#line 243 "../../../src/plugins/desktop-file-plugin.vala"
		_g_object_unref0 (app_info);
#line 2856 "desktop-file-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
#line 243 "../../../src/plugins/desktop-file-plugin.vala"
		err = _inner_error0_;
#line 243 "../../../src/plugins/desktop-file-plugin.vala"
		_inner_error0_ = NULL;
#line 252 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp11_ = err;
#line 252 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp12_ = _tmp11_->message;
#line 252 "../../../src/plugins/desktop-file-plugin.vala"
		g_warning ("desktop-file-plugin.vala:252: %s", _tmp12_);
#line 243 "../../../src/plugins/desktop-file-plugin.vala"
		_g_error_free0 (err);
#line 2876 "desktop-file-plugin.c"
	}
	__finally0:
#line 243 "../../../src/plugins/desktop-file-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 243 "../../../src/plugins/desktop-file-plugin.vala"
		_g_object_unref0 (f);
#line 243 "../../../src/plugins/desktop-file-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 243 "../../../src/plugins/desktop-file-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 243 "../../../src/plugins/desktop-file-plugin.vala"
		return;
#line 2889 "desktop-file-plugin.c"
	}
#line 237 "../../../src/plugins/desktop-file-plugin.vala"
	_g_object_unref0 (f);
#line 2893 "desktop-file-plugin.c"
}

static gboolean
synapse_desktop_file_plugin_open_with_action_real_valid_for_match (SynapseAction* base,
                                                                   SynapseMatch* match)
{
	SynapseDesktopFilePluginOpenWithAction * self;
	gboolean result = FALSE;
#line 256 "../../../src/plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
#line 256 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (match != NULL, FALSE);
#line 258 "../../../src/plugins/desktop-file-plugin.vala"
	result = G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_URI_MATCH);
#line 258 "../../../src/plugins/desktop-file-plugin.vala"
	return result;
#line 2910 "desktop-file-plugin.c"
}

static SynapseDesktopFileInfo*
synapse_desktop_file_plugin_open_with_action_get_desktop_info (SynapseDesktopFilePluginOpenWithAction* self)
{
	SynapseDesktopFileInfo* result;
	SynapseDesktopFileInfo* _tmp0_;
#line 223 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 223 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_desktop_info;
#line 223 "../../../src/plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 223 "../../../src/plugins/desktop-file-plugin.vala"
	return result;
#line 2926 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_with_action_set_desktop_info (SynapseDesktopFilePluginOpenWithAction* self,
                                                               SynapseDesktopFileInfo* value)
{
	SynapseDesktopFileInfo* old_value;
#line 223 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 223 "../../../src/plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_open_with_action_get_desktop_info (self);
#line 223 "../../../src/plugins/desktop-file-plugin.vala"
	if (old_value != value) {
#line 2940 "desktop-file-plugin.c"
		SynapseDesktopFileInfo* _tmp0_;
#line 223 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 223 "../../../src/plugins/desktop-file-plugin.vala"
		_g_object_unref0 (self->priv->_desktop_info);
#line 223 "../../../src/plugins/desktop-file-plugin.vala"
		self->priv->_desktop_info = _tmp0_;
#line 223 "../../../src/plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY]);
#line 2950 "desktop-file-plugin.c"
	}
}

static GObject *
synapse_desktop_file_plugin_open_with_action_constructor (GType type,
                                                          guint n_construct_properties,
                                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDesktopFilePluginOpenWithAction * self;
	SynapseDesktopFileInfo* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	SynapseDesktopFileInfo* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	SynapseDesktopFileInfo* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
#line 230 "../../../src/plugins/desktop-file-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_desktop_file_plugin_open_with_action_parent_class);
#line 230 "../../../src/plugins/desktop-file-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 230 "../../../src/plugins/desktop-file-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithAction);
#line 232 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_desktop_info;
#line 232 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp1_ = synapse_desktop_file_info_get_name (_tmp0_);
#line 232 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp2_ = _tmp1_;
#line 232 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp3_ = g_strdup_printf (_ ("Open with %s"), _tmp2_);
#line 232 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp4_ = _tmp3_;
#line 232 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_match_set_title ((SynapseMatch*) self, _tmp4_);
#line 232 "../../../src/plugins/desktop-file-plugin.vala"
	_g_free0 (_tmp4_);
#line 233 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp5_ = self->priv->_desktop_info;
#line 233 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp6_ = synapse_desktop_file_info_get_icon_name (_tmp5_);
#line 233 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp7_ = _tmp6_;
#line 233 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp7_);
#line 234 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp8_ = self->priv->_desktop_info;
#line 234 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp9_ = synapse_desktop_file_info_get_name (_tmp8_);
#line 234 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp10_ = _tmp9_;
#line 234 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp11_ = g_strdup_printf (_ ("Opens current selection using %s"), _tmp10_);
#line 234 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp12_ = _tmp11_;
#line 234 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_match_set_description ((SynapseMatch*) self, _tmp12_);
#line 234 "../../../src/plugins/desktop-file-plugin.vala"
	_g_free0 (_tmp12_);
#line 230 "../../../src/plugins/desktop-file-plugin.vala"
	return obj;
#line 3019 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_with_action_class_init (SynapseDesktopFilePluginOpenWithActionClass * klass,
                                                         gpointer klass_data)
{
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_open_with_action_parent_class = g_type_class_peek_parent (klass);
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFilePluginOpenWithAction_private_offset);
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
	((SynapseActionClass *) klass)->do_execute = (void (*) (SynapseAction*, SynapseMatch*, SynapseMatch*)) synapse_desktop_file_plugin_open_with_action_real_do_execute;
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
	((SynapseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseAction*, SynapseMatch*)) synapse_desktop_file_plugin_open_with_action_real_valid_for_match;
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_plugin_open_with_action_get_property;
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_plugin_open_with_action_set_property;
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_desktop_file_plugin_open_with_action_constructor;
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_plugin_open_with_action_finalize;
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY] = g_param_spec_object ("desktop-info", "desktop-info", "desktop-info", SYNAPSE_TYPE_DESKTOP_FILE_INFO, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 3044 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_with_action_instance_init (SynapseDesktopFilePluginOpenWithAction * self,
                                                            gpointer klass)
{
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
	self->priv = synapse_desktop_file_plugin_open_with_action_get_instance_private (self);
#line 3053 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_with_action_finalize (GObject * obj)
{
	SynapseDesktopFilePluginOpenWithAction * self;
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithAction);
#line 223 "../../../src/plugins/desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->_desktop_info);
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (synapse_desktop_file_plugin_open_with_action_parent_class)->finalize (obj);
#line 3066 "desktop-file-plugin.c"
}

static GType
synapse_desktop_file_plugin_open_with_action_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFilePluginOpenWithActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_plugin_open_with_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFilePluginOpenWithAction), 0, (GInstanceInitFunc) synapse_desktop_file_plugin_open_with_action_instance_init, NULL };
	GType synapse_desktop_file_plugin_open_with_action_type_id;
	synapse_desktop_file_plugin_open_with_action_type_id = g_type_register_static (SYNAPSE_TYPE_ACTION, "SynapseDesktopFilePluginOpenWithAction", &g_define_type_info, 0);
	SynapseDesktopFilePluginOpenWithAction_private_offset = g_type_add_instance_private (synapse_desktop_file_plugin_open_with_action_type_id, sizeof (SynapseDesktopFilePluginOpenWithActionPrivate));
	return synapse_desktop_file_plugin_open_with_action_type_id;
}

static GType
synapse_desktop_file_plugin_open_with_action_get_type (void)
{
	static volatile gsize synapse_desktop_file_plugin_open_with_action_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_plugin_open_with_action_type_id__volatile)) {
		GType synapse_desktop_file_plugin_open_with_action_type_id;
		synapse_desktop_file_plugin_open_with_action_type_id = synapse_desktop_file_plugin_open_with_action_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_plugin_open_with_action_type_id__volatile, synapse_desktop_file_plugin_open_with_action_type_id);
	}
	return synapse_desktop_file_plugin_open_with_action_type_id__volatile;
}

static void
_vala_synapse_desktop_file_plugin_open_with_action_get_property (GObject * object,
                                                                 guint property_id,
                                                                 GValue * value,
                                                                 GParamSpec * pspec)
{
	SynapseDesktopFilePluginOpenWithAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithAction);
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
	switch (property_id) {
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY:
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
		g_value_set_object (value, synapse_desktop_file_plugin_open_with_action_get_desktop_info (self));
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 3107 "desktop-file-plugin.c"
		default:
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 3113 "desktop-file-plugin.c"
	}
}

static void
_vala_synapse_desktop_file_plugin_open_with_action_set_property (GObject * object,
                                                                 guint property_id,
                                                                 const GValue * value,
                                                                 GParamSpec * pspec)
{
	SynapseDesktopFilePluginOpenWithAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithAction);
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
	switch (property_id) {
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY:
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
		synapse_desktop_file_plugin_open_with_action_set_desktop_info (self, g_value_get_object (value));
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 3133 "desktop-file-plugin.c"
		default:
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 221 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 3139 "desktop-file-plugin.c"
	}
}

static inline gpointer
synapse_desktop_file_plugin_open_app_action_get_instance_private (SynapseDesktopFilePluginOpenAppAction* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFilePluginOpenAppAction_private_offset);
}

static SynapseDesktopFilePluginOpenAppAction*
synapse_desktop_file_plugin_open_app_action_construct (GType object_type,
                                                       SynapseDesktopFileInfo* info,
                                                       const gchar* action)
{
	SynapseDesktopFilePluginOpenAppAction * self = NULL;
#line 269 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (info != NULL, NULL);
#line 269 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 271 "../../../src/plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenAppAction*) g_object_new (object_type, "desktop-info", info, "action", action, NULL);
#line 269 "../../../src/plugins/desktop-file-plugin.vala"
	return self;
#line 3163 "desktop-file-plugin.c"
}

static SynapseDesktopFilePluginOpenAppAction*
synapse_desktop_file_plugin_open_app_action_new (SynapseDesktopFileInfo* info,
                                                 const gchar* action)
{
#line 269 "../../../src/plugins/desktop-file-plugin.vala"
	return synapse_desktop_file_plugin_open_app_action_construct (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION, info, action);
#line 3172 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_app_action_real_do_execute (SynapseAction* base,
                                                             SynapseMatch* match,
                                                             SynapseMatch* target)
{
	SynapseDesktopFilePluginOpenAppAction * self;
	GDesktopAppInfo* _tmp0_;
	const gchar* _tmp1_;
	GdkDisplay* _tmp2_;
	GdkAppLaunchContext* _tmp3_;
	GdkAppLaunchContext* _tmp4_;
	SynapseRelevancyService* _tmp5_;
	SynapseRelevancyService* _tmp6_;
	GDesktopAppInfo* _tmp7_;
#line 283 "../../../src/plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenAppAction*) base;
#line 283 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_if_fail (match != NULL);
#line 285 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->app_info;
#line 285 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp1_ = self->priv->_action;
#line 285 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp2_ = gdk_display_get_default ();
#line 285 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp3_ = gdk_display_get_app_launch_context (_tmp2_);
#line 285 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp4_ = _tmp3_;
#line 285 "../../../src/plugins/desktop-file-plugin.vala"
	g_desktop_app_info_launch_action (_tmp0_, _tmp1_, (GAppLaunchContext*) _tmp4_);
#line 285 "../../../src/plugins/desktop-file-plugin.vala"
	_g_object_unref0 (_tmp4_);
#line 286 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp5_ = synapse_relevancy_service_get_default ();
#line 286 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp6_ = _tmp5_;
#line 286 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp7_ = self->priv->app_info;
#line 286 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_relevancy_service_application_launched (_tmp6_, (GAppInfo*) _tmp7_);
#line 286 "../../../src/plugins/desktop-file-plugin.vala"
	_g_object_unref0 (_tmp6_);
#line 3217 "desktop-file-plugin.c"
}

static gboolean
synapse_desktop_file_plugin_open_app_action_real_valid_for_match (SynapseAction* base,
                                                                  SynapseMatch* match)
{
	SynapseDesktopFilePluginOpenAppAction * self;
	gboolean result = FALSE;
#line 289 "../../../src/plugins/desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenAppAction*) base;
#line 289 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (match != NULL, FALSE);
#line 291 "../../../src/plugins/desktop-file-plugin.vala"
	result = SYNAPSE_DESKTOP_FILE_PLUGIN_IS_DESKTOP_FILE_MATCH (match);
#line 291 "../../../src/plugins/desktop-file-plugin.vala"
	return result;
#line 3234 "desktop-file-plugin.c"
}

static SynapseDesktopFileInfo*
synapse_desktop_file_plugin_open_app_action_get_desktop_info (SynapseDesktopFilePluginOpenAppAction* self)
{
	SynapseDesktopFileInfo* result;
	SynapseDesktopFileInfo* _tmp0_;
#line 264 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 264 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_desktop_info;
#line 264 "../../../src/plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 264 "../../../src/plugins/desktop-file-plugin.vala"
	return result;
#line 3250 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_app_action_set_desktop_info (SynapseDesktopFilePluginOpenAppAction* self,
                                                              SynapseDesktopFileInfo* value)
{
	SynapseDesktopFileInfo* old_value;
#line 264 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 264 "../../../src/plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_open_app_action_get_desktop_info (self);
#line 264 "../../../src/plugins/desktop-file-plugin.vala"
	if (old_value != value) {
#line 3264 "desktop-file-plugin.c"
		SynapseDesktopFileInfo* _tmp0_;
#line 264 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 264 "../../../src/plugins/desktop-file-plugin.vala"
		_g_object_unref0 (self->priv->_desktop_info);
#line 264 "../../../src/plugins/desktop-file-plugin.vala"
		self->priv->_desktop_info = _tmp0_;
#line 264 "../../../src/plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_open_app_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_DESKTOP_INFO_PROPERTY]);
#line 3274 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_open_app_action_get_action (SynapseDesktopFilePluginOpenAppAction* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 265 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 265 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_action;
#line 265 "../../../src/plugins/desktop-file-plugin.vala"
	result = _tmp0_;
#line 265 "../../../src/plugins/desktop-file-plugin.vala"
	return result;
#line 3291 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_app_action_set_action (SynapseDesktopFilePluginOpenAppAction* self,
                                                        const gchar* value)
{
	gchar* old_value;
#line 265 "../../../src/plugins/desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 265 "../../../src/plugins/desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_open_app_action_get_action (self);
#line 265 "../../../src/plugins/desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 3305 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 265 "../../../src/plugins/desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 265 "../../../src/plugins/desktop-file-plugin.vala"
		_g_free0 (self->priv->_action);
#line 265 "../../../src/plugins/desktop-file-plugin.vala"
		self->priv->_action = _tmp0_;
#line 265 "../../../src/plugins/desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_open_app_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_ACTION_PROPERTY]);
#line 3315 "desktop-file-plugin.c"
	}
}

static GObject *
synapse_desktop_file_plugin_open_app_action_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDesktopFilePluginOpenAppAction * self;
	SynapseDesktopFileInfo* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GDesktopAppInfo* _tmp3_;
	gchar* display_action = NULL;
	GDesktopAppInfo* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	SynapseDesktopFileInfo* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
#line 274 "../../../src/plugins/desktop-file-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_desktop_file_plugin_open_app_action_parent_class);
#line 274 "../../../src/plugins/desktop-file-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 274 "../../../src/plugins/desktop-file-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION, SynapseDesktopFilePluginOpenAppAction);
#line 276 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->_desktop_info;
#line 276 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp1_ = synapse_desktop_file_info_get_filename (_tmp0_);
#line 276 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp2_ = _tmp1_;
#line 276 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp3_ = g_desktop_app_info_new_from_filename (_tmp2_);
#line 276 "../../../src/plugins/desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->app_info);
#line 276 "../../../src/plugins/desktop-file-plugin.vala"
	self->priv->app_info = _tmp3_;
#line 277 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp4_ = self->priv->app_info;
#line 277 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp5_ = self->priv->_action;
#line 277 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp6_ = g_desktop_app_info_get_action_name (_tmp4_, _tmp5_);
#line 277 "../../../src/plugins/desktop-file-plugin.vala"
	display_action = _tmp6_;
#line 278 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp7_ = display_action;
#line 278 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_match_set_title ((SynapseMatch*) self, _tmp7_);
#line 279 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp8_ = self->priv->_desktop_info;
#line 279 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp9_ = synapse_desktop_file_info_get_icon_name (_tmp8_);
#line 279 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp10_ = _tmp9_;
#line 279 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp10_);
#line 280 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp11_ = display_action;
#line 280 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp12_ = g_strdup_printf (_ ("Launch action '%s'"), _tmp11_);
#line 280 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp13_ = _tmp12_;
#line 280 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_match_set_description ((SynapseMatch*) self, _tmp13_);
#line 280 "../../../src/plugins/desktop-file-plugin.vala"
	_g_free0 (_tmp13_);
#line 274 "../../../src/plugins/desktop-file-plugin.vala"
	_g_free0 (display_action);
#line 274 "../../../src/plugins/desktop-file-plugin.vala"
	return obj;
#line 3394 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_app_action_class_init (SynapseDesktopFilePluginOpenAppActionClass * klass,
                                                        gpointer klass_data)
{
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_open_app_action_parent_class = g_type_class_peek_parent (klass);
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFilePluginOpenAppAction_private_offset);
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
	((SynapseActionClass *) klass)->do_execute = (void (*) (SynapseAction*, SynapseMatch*, SynapseMatch*)) synapse_desktop_file_plugin_open_app_action_real_do_execute;
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
	((SynapseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseAction*, SynapseMatch*)) synapse_desktop_file_plugin_open_app_action_real_valid_for_match;
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_plugin_open_app_action_get_property;
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_plugin_open_app_action_set_property;
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_desktop_file_plugin_open_app_action_constructor;
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_plugin_open_app_action_finalize;
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_DESKTOP_INFO_PROPERTY, synapse_desktop_file_plugin_open_app_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_DESKTOP_INFO_PROPERTY] = g_param_spec_object ("desktop-info", "desktop-info", "desktop-info", SYNAPSE_TYPE_DESKTOP_FILE_INFO, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_ACTION_PROPERTY, synapse_desktop_file_plugin_open_app_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_ACTION_PROPERTY] = g_param_spec_string ("action", "action", "action", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 3421 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_app_action_instance_init (SynapseDesktopFilePluginOpenAppAction * self,
                                                           gpointer klass)
{
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
	self->priv = synapse_desktop_file_plugin_open_app_action_get_instance_private (self);
#line 3430 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_app_action_finalize (GObject * obj)
{
	SynapseDesktopFilePluginOpenAppAction * self;
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION, SynapseDesktopFilePluginOpenAppAction);
#line 264 "../../../src/plugins/desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->_desktop_info);
#line 265 "../../../src/plugins/desktop-file-plugin.vala"
	_g_free0 (self->priv->_action);
#line 267 "../../../src/plugins/desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->app_info);
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (synapse_desktop_file_plugin_open_app_action_parent_class)->finalize (obj);
#line 3447 "desktop-file-plugin.c"
}

static GType
synapse_desktop_file_plugin_open_app_action_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFilePluginOpenAppActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_plugin_open_app_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFilePluginOpenAppAction), 0, (GInstanceInitFunc) synapse_desktop_file_plugin_open_app_action_instance_init, NULL };
	GType synapse_desktop_file_plugin_open_app_action_type_id;
	synapse_desktop_file_plugin_open_app_action_type_id = g_type_register_static (SYNAPSE_TYPE_ACTION, "SynapseDesktopFilePluginOpenAppAction", &g_define_type_info, 0);
	SynapseDesktopFilePluginOpenAppAction_private_offset = g_type_add_instance_private (synapse_desktop_file_plugin_open_app_action_type_id, sizeof (SynapseDesktopFilePluginOpenAppActionPrivate));
	return synapse_desktop_file_plugin_open_app_action_type_id;
}

static GType
synapse_desktop_file_plugin_open_app_action_get_type (void)
{
	static volatile gsize synapse_desktop_file_plugin_open_app_action_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_plugin_open_app_action_type_id__volatile)) {
		GType synapse_desktop_file_plugin_open_app_action_type_id;
		synapse_desktop_file_plugin_open_app_action_type_id = synapse_desktop_file_plugin_open_app_action_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_plugin_open_app_action_type_id__volatile, synapse_desktop_file_plugin_open_app_action_type_id);
	}
	return synapse_desktop_file_plugin_open_app_action_type_id__volatile;
}

static void
_vala_synapse_desktop_file_plugin_open_app_action_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec)
{
	SynapseDesktopFilePluginOpenAppAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION, SynapseDesktopFilePluginOpenAppAction);
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
	switch (property_id) {
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_DESKTOP_INFO_PROPERTY:
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
		g_value_set_object (value, synapse_desktop_file_plugin_open_app_action_get_desktop_info (self));
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_ACTION_PROPERTY:
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
		g_value_set_string (value, synapse_desktop_file_plugin_open_app_action_get_action (self));
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 3494 "desktop-file-plugin.c"
		default:
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 3500 "desktop-file-plugin.c"
	}
}

static void
_vala_synapse_desktop_file_plugin_open_app_action_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec)
{
	SynapseDesktopFilePluginOpenAppAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION, SynapseDesktopFilePluginOpenAppAction);
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
	switch (property_id) {
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_DESKTOP_INFO_PROPERTY:
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
		synapse_desktop_file_plugin_open_app_action_set_desktop_info (self, g_value_get_object (value));
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_ACTION_PROPERTY:
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
		synapse_desktop_file_plugin_open_app_action_set_action (self, g_value_get_string (value));
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 3526 "desktop-file-plugin.c"
		default:
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 262 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 3532 "desktop-file-plugin.c"
	}
}

static void
_synapse_desktop_file_plugin___lambda5_ (SynapseDesktopFilePlugin* self)
{
#line 91 "../../../src/plugins/desktop-file-plugin.vala"
	self->priv->loading_in_progress = TRUE;
#line 3541 "desktop-file-plugin.c"
}

static void
__synapse_desktop_file_plugin___lambda5__synapse_desktop_file_service_reload_started (SynapseDesktopFileService* _sender,
                                                                                      gpointer self)
{
#line 90 "../../../src/plugins/desktop-file-plugin.vala"
	_synapse_desktop_file_plugin___lambda5_ ((SynapseDesktopFilePlugin*) self);
#line 3550 "desktop-file-plugin.c"
}

static void
_synapse_desktop_file_plugin___lambda6_ (SynapseDesktopFilePlugin* self)
{
	GeeMap* _tmp0_;
	GeeList* _tmp1_;
#line 94 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp0_ = self->priv->mimetype_map;
#line 94 "../../../src/plugins/desktop-file-plugin.vala"
	gee_map_clear (_tmp0_);
#line 95 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp1_ = self->priv->desktop_files;
#line 95 "../../../src/plugins/desktop-file-plugin.vala"
	gee_collection_clear ((GeeCollection*) _tmp1_);
#line 96 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_load_all_desktop_files (self, NULL, NULL);
#line 3568 "desktop-file-plugin.c"
}

static void
__synapse_desktop_file_plugin___lambda6__synapse_desktop_file_service_reload_done (SynapseDesktopFileService* _sender,
                                                                                   gpointer self)
{
#line 93 "../../../src/plugins/desktop-file-plugin.vala"
	_synapse_desktop_file_plugin___lambda6_ ((SynapseDesktopFilePlugin*) self);
#line 3577 "desktop-file-plugin.c"
}

static GObject *
synapse_desktop_file_plugin_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDesktopFilePlugin * self;
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	SynapseDesktopFileService* dfs = NULL;
	SynapseDesktopFileService* _tmp3_;
	SynapseDesktopFileService* _tmp4_;
	SynapseDesktopFileService* _tmp5_;
#line 83 "../../../src/plugins/desktop-file-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_desktop_file_plugin_parent_class);
#line 83 "../../../src/plugins/desktop-file-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 83 "../../../src/plugins/desktop-file-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin);
#line 85 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp0_ = gee_array_list_new (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 85 "../../../src/plugins/desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->desktop_files);
#line 85 "../../../src/plugins/desktop-file-plugin.vala"
	self->priv->desktop_files = (GeeList*) _tmp0_;
#line 86 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 86 "../../../src/plugins/desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->mimetype_map);
#line 86 "../../../src/plugins/desktop-file-plugin.vala"
	self->priv->mimetype_map = (GeeMap*) _tmp1_;
#line 87 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 87 "../../../src/plugins/desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->actions_map);
#line 87 "../../../src/plugins/desktop-file-plugin.vala"
	self->priv->actions_map = (GeeMap*) _tmp2_;
#line 89 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp3_ = synapse_desktop_file_service_get_default ();
#line 89 "../../../src/plugins/desktop-file-plugin.vala"
	dfs = _tmp3_;
#line 90 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp4_ = dfs;
#line 90 "../../../src/plugins/desktop-file-plugin.vala"
	g_signal_connect_object (_tmp4_, "reload-started", (GCallback) __synapse_desktop_file_plugin___lambda5__synapse_desktop_file_service_reload_started, self, 0);
#line 93 "../../../src/plugins/desktop-file-plugin.vala"
	_tmp5_ = dfs;
#line 93 "../../../src/plugins/desktop-file-plugin.vala"
	g_signal_connect_object (_tmp5_, "reload-done", (GCallback) __synapse_desktop_file_plugin___lambda6__synapse_desktop_file_service_reload_done, self, 0);
#line 99 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_load_all_desktop_files (self, NULL, NULL);
#line 83 "../../../src/plugins/desktop-file-plugin.vala"
	_g_object_unref0 (dfs);
#line 83 "../../../src/plugins/desktop-file-plugin.vala"
	return obj;
#line 3637 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_class_init (SynapseDesktopFilePluginClass * klass,
                                        gpointer klass_data)
{
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_parent_class = g_type_class_peek_parent (klass);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFilePlugin_private_offset);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_plugin_get_property;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_plugin_set_property;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_desktop_file_plugin_constructor;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_plugin_finalize;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY, synapse_desktop_file_plugin_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_signals[SYNAPSE_DESKTOP_FILE_PLUGIN_LOAD_COMPLETE_SIGNAL] = g_signal_new ("load-complete", SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 78 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_register_plugin ();
#line 3662 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                                gpointer iface_data)
{
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_desktop_file_plugin_real_activate;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_desktop_file_plugin_real_deactivate;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	iface->get_enabled = synapse_desktop_file_plugin_real_get_enabled;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	iface->set_enabled = synapse_desktop_file_plugin_real_set_enabled;
#line 3679 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                                  gpointer iface_data)
{
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	iface->handles_query = (gboolean (*) (SynapseItemProvider*, SynapseQuery*)) synapse_desktop_file_plugin_real_handles_query;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_desktop_file_plugin_real_search;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_desktop_file_plugin_search_finish;
#line 3694 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_synapse_action_provider_interface_init (SynapseActionProviderIface * iface,
                                                                    gpointer iface_data)
{
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	synapse_desktop_file_plugin_synapse_action_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	iface->find_for_match = (SynapseResultSet* (*) (SynapseActionProvider*, SynapseQuery*, SynapseMatch*)) synapse_desktop_file_plugin_real_find_for_match;
#line 3705 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_instance_init (SynapseDesktopFilePlugin * self,
                                           gpointer klass)
{
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	self->priv = synapse_desktop_file_plugin_get_instance_private (self);
#line 26 "../../../src/plugins/desktop-file-plugin.vala"
	self->priv->_enabled = TRUE;
#line 103 "../../../src/plugins/desktop-file-plugin.vala"
	self->priv->loading_in_progress = FALSE;
#line 3718 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_finalize (GObject * obj)
{
	SynapseDesktopFilePlugin * self;
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin);
#line 81 "../../../src/plugins/desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->desktop_files);
#line 295 "../../../src/plugins/desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->mimetype_map);
#line 296 "../../../src/plugins/desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->actions_map);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	G_OBJECT_CLASS (synapse_desktop_file_plugin_parent_class)->finalize (obj);
#line 3735 "desktop-file-plugin.c"
}

static GType
synapse_desktop_file_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFilePluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFilePlugin), 0, (GInstanceInitFunc) synapse_desktop_file_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_action_provider_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_synapse_action_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_desktop_file_plugin_type_id;
	synapse_desktop_file_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFilePlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_desktop_file_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_desktop_file_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	g_type_add_interface_static (synapse_desktop_file_plugin_type_id, SYNAPSE_TYPE_ACTION_PROVIDER, &synapse_action_provider_info);
	SynapseDesktopFilePlugin_private_offset = g_type_add_instance_private (synapse_desktop_file_plugin_type_id, sizeof (SynapseDesktopFilePluginPrivate));
	return synapse_desktop_file_plugin_type_id;
}

GType
synapse_desktop_file_plugin_get_type (void)
{
	static volatile gsize synapse_desktop_file_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_plugin_type_id__volatile)) {
		GType synapse_desktop_file_plugin_type_id;
		synapse_desktop_file_plugin_type_id = synapse_desktop_file_plugin_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_plugin_type_id__volatile, synapse_desktop_file_plugin_type_id);
	}
	return synapse_desktop_file_plugin_type_id__volatile;
}

static void
_vala_synapse_desktop_file_plugin_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	SynapseDesktopFilePlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	switch (property_id) {
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY:
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 3782 "desktop-file-plugin.c"
		default:
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 3788 "desktop-file-plugin.c"
	}
}

static void
_vala_synapse_desktop_file_plugin_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	SynapseDesktopFilePlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
	switch (property_id) {
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY:
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 3808 "desktop-file-plugin.c"
		default:
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../../../src/plugins/desktop-file-plugin.vala"
		break;
#line 3814 "desktop-file-plugin.c"
	}
}

