/* hybrid-search-plugin.c generated by valac 0.48.17, the Vala compiler
 * generated from hybrid-search-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */
/*
 * This plugin keeps a cache of file names for directories that are commonly
 * used.
 */

#include <glib-object.h>
#include <synapse-core.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>

#define SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN (synapse_hybrid_search_plugin_get_type ())
#define SYNAPSE_HYBRID_SEARCH_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN, SynapseHybridSearchPlugin))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN, SynapseHybridSearchPluginClass))
#define SYNAPSE_IS_HYBRID_SEARCH_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN))
#define SYNAPSE_IS_HYBRID_SEARCH_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN, SynapseHybridSearchPluginClass))

typedef struct _SynapseHybridSearchPlugin SynapseHybridSearchPlugin;
typedef struct _SynapseHybridSearchPluginClass SynapseHybridSearchPluginClass;
typedef struct _SynapseHybridSearchPluginPrivate SynapseHybridSearchPluginPrivate;

#define SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO (synapse_hybrid_search_plugin_directory_info_get_type ())
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_DIRECTORY_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO, SynapseHybridSearchPluginDirectoryInfo))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_DIRECTORY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO, SynapseHybridSearchPluginDirectoryInfoClass))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_IS_DIRECTORY_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_IS_DIRECTORY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO))
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_DIRECTORY_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO, SynapseHybridSearchPluginDirectoryInfoClass))

typedef struct _SynapseHybridSearchPluginDirectoryInfo SynapseHybridSearchPluginDirectoryInfo;
typedef struct _SynapseHybridSearchPluginDirectoryInfoClass SynapseHybridSearchPluginDirectoryInfoClass;
enum  {
	SYNAPSE_HYBRID_SEARCH_PLUGIN_0_PROPERTY,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_DATA_SINK_PROPERTY,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_PROCESSING_QUERY_PROPERTY,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_hybrid_search_plugin_properties[SYNAPSE_HYBRID_SEARCH_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_bookmark_file_free0(var) ((var == NULL) ? NULL : (var = (g_bookmark_file_free (var), NULL)))
typedef struct _SynapseHybridSearchPluginDirectoryInfoPrivate SynapseHybridSearchPluginDirectoryInfoPrivate;
typedef struct _SynapseHybridSearchPluginAnalyzeRecentDocumentsData SynapseHybridSearchPluginAnalyzeRecentDocumentsData;
typedef struct _SynapseHybridSearchPluginProcessUrisData SynapseHybridSearchPluginProcessUrisData;
#define _synapse_utils_file_info_unref0(var) ((var == NULL) ? NULL : (var = (synapse_utils_file_info_unref (var), NULL)))
#define _synapse_hybrid_search_plugin_directory_info_unref0(var) ((var == NULL) ? NULL : (var = (synapse_hybrid_search_plugin_directory_info_unref (var), NULL)))
typedef struct _SynapseHybridSearchPluginUpdateDirectoryContentsData SynapseHybridSearchPluginUpdateDirectoryContentsData;
typedef struct _SynapseHybridSearchPluginProcessDirectoriesData SynapseHybridSearchPluginProcessDirectoriesData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseHybridSearchPluginGetExtraResultsData SynapseHybridSearchPluginGetExtraResultsData;
typedef struct _Block3Data Block3Data;
typedef struct _SynapseHybridSearchPluginWaitForProcessingFinishedData SynapseHybridSearchPluginWaitForProcessingFinishedData;
typedef struct _Block4Data Block4Data;
typedef struct _SynapseHybridSearchPluginSearchData SynapseHybridSearchPluginSearchData;
typedef struct _SynapseHybridSearchPluginParamSpecDirectoryInfo SynapseHybridSearchPluginParamSpecDirectoryInfo;
enum  {
	SYNAPSE_HYBRID_SEARCH_PLUGIN_ZEITGEIST_SEARCH_COMPLETE_SIGNAL,
	SYNAPSE_HYBRID_SEARCH_PLUGIN_NUM_SIGNALS
};
static guint synapse_hybrid_search_plugin_signals[SYNAPSE_HYBRID_SEARCH_PLUGIN_NUM_SIGNALS] = {0};

struct _SynapseHybridSearchPlugin {
	GObject parent_instance;
	SynapseHybridSearchPluginPrivate * priv;
};

struct _SynapseHybridSearchPluginClass {
	GObjectClass parent_class;
};

struct _SynapseHybridSearchPluginPrivate {
	SynapseDataSink* _data_sink;
	gboolean _enabled;
	gboolean initialization_done;
	GeeMap* directory_hits;
	gint hit_level;
	gint current_level_uris;
	GeeMap* directory_contents;
	gchar* current_query;
	gboolean _processing_query;
};

struct _SynapseHybridSearchPluginDirectoryInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseHybridSearchPluginDirectoryInfoPrivate * priv;
	gchar* path;
	GTimeVal last_update;
	GeeMap* files;
};

struct _SynapseHybridSearchPluginDirectoryInfoClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseHybridSearchPluginDirectoryInfo *self);
};

struct _SynapseHybridSearchPluginAnalyzeRecentDocumentsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseHybridSearchPlugin* self;
	GFile* recent;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	guint8* file_contents;
	gint file_contents_length1;
	gint _file_contents_size_;
	gchar* contents;
	gsize len;
	gboolean load_ok;
	gboolean _tmp5_;
	GFile* _tmp6_;
	guint8* _tmp7_;
	gsize _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GFile* _tmp13_;
	gboolean _tmp14_;
	GFile* _tmp15_;
	guint8* _tmp16_;
	gsize _tmp17_;
	gboolean _tmp18_;
	guint8* _tmp19_;
	gint _tmp19__length1;
	gchar* _tmp20_;
	guint8* _tmp21_;
	gint _tmp21__length1;
	GBookmarkFile* bf;
	GBookmarkFile* _tmp22_;
	GBookmarkFile* _tmp23_;
	const gchar* _tmp24_;
	gchar** uris;
	GBookmarkFile* _tmp25_;
	gsize _tmp26_;
	gchar** _tmp27_;
	gint uris_length1;
	gint _uris_size_;
	GeeMap* dir_hits;
	GeeHashMap* _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	gchar** uri_collection;
	gint uri_collection_length1;
	gint _uri_collection_size_;
	gint uri_it;
	const gchar* uri;
	GFile* f;
	const gchar* _tmp30_;
	GFile* _tmp31_;
	GFile* parent;
	GFile* _tmp32_;
	GFile* _tmp33_;
	GFile* _tmp34_;
	gchar* parent_path;
	GFile* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	GeeMap* _tmp38_;
	const gchar* _tmp39_;
	GeeMap* _tmp40_;
	const gchar* _tmp41_;
	gpointer _tmp42_;
	GeeList* sorted_dirs;
	GeeArrayList* _tmp43_;
	GeeList* _tmp44_;
	GeeMap* _tmp45_;
	GeeSet* _tmp46_;
	GeeSet* _tmp47_;
	GeeSet* _tmp48_;
	GeeList* _tmp49_;
	GeeList* directories;
	GeeArrayList* _tmp50_;
	gint i;
	gboolean _tmp51_;
	gint _tmp52_;
	gboolean _tmp53_;
	GeeList* _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	GeeList* _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
	gchar* dir_path;
	GeeList* _tmp60_;
	gpointer _tmp61_;
	GeeMapEntry* _tmp62_;
	gconstpointer _tmp63_;
	gconstpointer _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	const gchar* _tmp67_;
	GFile* dir_f;
	const gchar* _tmp68_;
	GFile* _tmp69_;
	GFile* _tmp70_;
	gboolean exists;
	GFile* _tmp71_;
	GeeList* _tmp72_;
	const gchar* _tmp73_;
	GeeList* _tmp74_;
	gint z;
	GeeIterator* _x_it;
	GeeMap* _tmp75_;
	GeeSet* _tmp76_;
	GeeSet* _tmp77_;
	GeeSet* _tmp78_;
	GeeIterator* _tmp79_;
	GeeIterator* _tmp80_;
	GeeIterator* _tmp81_;
	GeeMapEntry* x;
	GeeIterator* _tmp82_;
	gpointer _tmp83_;
	GeeMapEntry* _tmp84_;
	gconstpointer _tmp85_;
	gconstpointer _tmp86_;
	GeeMap* _tmp87_;
	gint _tmp88_;
	gint _tmp89_;
	GFile* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	GError* _inner_error0_;
};

struct _SynapseHybridSearchPluginProcessUrisData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseHybridSearchPlugin* self;
	GeeCollection* uris;
	GeeSet* dirs;
	GeeHashSet* _tmp0_;
	GeeIterator* _uri_it;
	GeeIterator* _tmp1_;
	GeeIterator* _tmp2_;
	gchar* uri;
	GeeIterator* _tmp3_;
	gpointer _tmp4_;
	GFile* f;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFileInfo* fi;
	GFile* _tmp8_;
	GFileInfo* _tmp9_;
	GFileInfo* _tmp10_;
	gchar* parent_path;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	GeeSet* _tmp17_;
	const gchar* _tmp18_;
	gint _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gint q_len;
	GeeIterator* _dir_it;
	GeeSet* _tmp22_;
	GeeIterator* _tmp23_;
	GeeIterator* _tmp24_;
	gchar* dir;
	GeeIterator* _tmp25_;
	gpointer _tmp26_;
	GeeMap* _tmp27_;
	const gchar* _tmp28_;
	gint hit_count;
	GeeMap* _tmp29_;
	const gchar* _tmp30_;
	gpointer _tmp31_;
	GeeMap* _tmp32_;
	const gchar* _tmp33_;
	GeeMap* _tmp34_;
	const gchar* _tmp35_;
	GError* _inner_error0_;
};

struct _SynapseHybridSearchPluginUpdateDirectoryContentsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseHybridSearchPlugin* self;
	GFile* directory;
	SynapseHybridSearchPluginDirectoryInfo* di;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFileEnumerator* enumerator;
	GFileEnumerator* _tmp2_;
	GList* files;
	GFileEnumerator* _tmp3_;
	GList* _tmp4_;
	GeeMap* _tmp5_;
	GList* _tmp6_;
	GError* _inner_error0_;
};

struct _SynapseHybridSearchPluginProcessDirectoriesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseHybridSearchPlugin* self;
	GeeCollection* directories;
	GeeIterator* _dir_path_it;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	gchar* dir_path;
	GeeIterator* _tmp2_;
	gpointer _tmp3_;
	GFile* directory;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	SynapseHybridSearchPluginDirectoryInfo* di;
	GeeMap* _tmp6_;
	const gchar* _tmp7_;
	GTimeVal cur_time;
	GeeMap* _tmp8_;
	const gchar* _tmp9_;
	gpointer _tmp10_;
	GTimeVal _tmp11_;
	SynapseHybridSearchPluginDirectoryInfo* _tmp12_;
	GTimeVal _tmp13_;
	const gchar* _tmp14_;
	SynapseHybridSearchPluginDirectoryInfo* _tmp15_;
	GeeMap* _tmp16_;
	const gchar* _tmp17_;
	SynapseHybridSearchPluginDirectoryInfo* _tmp18_;
	GFile* _tmp19_;
	SynapseHybridSearchPluginDirectoryInfo* _tmp20_;
	GError* _inner_error0_;
};

struct _SynapseHybridSearchPluginGetExtraResultsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseHybridSearchPlugin* self;
	SynapseQuery q;
	SynapseResultSet* original_rs;
	GeeCollection* dirs;
	SynapseResultSet* result;
	guint num_results;
	gboolean enough_results;
	SynapseResultSet* results;
	SynapseResultSet* _tmp0_;
	GRegexCompileFlags flags;
	GeeList* matchers;
	SynapseQuery _tmp1_;
	const gchar* _tmp2_;
	GRegexCompileFlags _tmp3_;
	GeeList* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	GeeMap* _tmp7_;
	GeeSet* _tmp8_;
	GeeSet* _tmp9_;
	GeeCollection* directories;
	GeeCollection* _tmp10_;
	GeeIterator* _directory_it;
	GeeCollection* _tmp11_;
	GeeIterator* _tmp12_;
	GeeIterator* _tmp13_;
	gchar* directory;
	GeeIterator* _tmp14_;
	gpointer _tmp15_;
	SynapseHybridSearchPluginDirectoryInfo* di;
	GeeMap* _tmp16_;
	const gchar* _tmp17_;
	gpointer _tmp18_;
	GFile* dir;
	const gchar* _tmp19_;
	GFile* _tmp20_;
	GFileInfo* dir_info;
	GFile* _tmp21_;
	GFileInfo* _tmp22_;
	GTimeVal t;
	GFileInfo* _tmp23_;
	GTimeVal _tmp24_;
	GTimeVal _tmp25_;
	SynapseHybridSearchPluginDirectoryInfo* _tmp26_;
	GTimeVal _tmp27_;
	GFile* _tmp28_;
	SynapseHybridSearchPluginDirectoryInfo* _tmp29_;
	GError* err;
	GError* _tmp30_;
	const gchar* _tmp31_;
	SynapseRelevancyService* rel_srv;
	SynapseRelevancyService* _tmp32_;
	GeeIterator* _entry_it;
	SynapseHybridSearchPluginDirectoryInfo* _tmp33_;
	GeeMap* _tmp34_;
	GeeSet* _tmp35_;
	GeeSet* _tmp36_;
	GeeSet* _tmp37_;
	GeeIterator* _tmp38_;
	GeeIterator* _tmp39_;
	GeeIterator* _tmp40_;
	GeeMapEntry* entry;
	GeeIterator* _tmp41_;
	gpointer _tmp42_;
	GeeList* _matcher_list;
	GeeList* _tmp43_;
	GeeList* _tmp44_;
	gint _matcher_size;
	GeeList* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	gint _matcher_index;
	gint _tmp48_;
	gint _tmp49_;
	GeeMapEntry* matcher;
	GeeList* _tmp50_;
	gpointer _tmp51_;
	SynapseUtilsFileInfo* fi;
	GeeMapEntry* _tmp52_;
	gconstpointer _tmp53_;
	gconstpointer _tmp54_;
	SynapseUtilsFileInfo* _tmp55_;
	GeeMapEntry* _tmp56_;
	gconstpointer _tmp57_;
	gconstpointer _tmp58_;
	SynapseUtilsFileInfo* _tmp59_;
	const gchar* _tmp60_;
	gboolean _tmp61_;
	SynapseUtilsFileInfo* _tmp62_;
	const gchar* _tmp63_;
	gboolean done_io;
	SynapseUtilsFileInfo* _tmp64_;
	SynapseUtilsFileInfo* _tmp65_;
	gboolean _tmp66_;
	SynapseUtilsFileInfo* _tmp67_;
	SynapseUriMatch* _tmp68_;
	SynapseUtilsFileInfo* _tmp69_;
	SynapseQueryFlags _tmp70_;
	SynapseQuery _tmp71_;
	SynapseQueryFlags _tmp72_;
	gboolean exists;
	SynapseUtilsFileInfo* _tmp73_;
	gboolean _tmp74_;
	SynapseUtilsFileInfo* _tmp75_;
	SynapseUriMatch* _tmp76_;
	SynapseUtilsFileInfo* _tmp77_;
	SynapseQueryFlags _tmp78_;
	SynapseQuery _tmp79_;
	SynapseQueryFlags _tmp80_;
	gint base_relevancy;
	GeeMapEntry* _tmp81_;
	gconstpointer _tmp82_;
	gconstpointer _tmp83_;
	SynapseUtilsFileInfo* _tmp84_;
	SynapseUriMatch* _tmp85_;
	const gchar* _tmp86_;
	const gchar* _tmp87_;
	GeeMapEntry* _tmp88_;
	gconstpointer _tmp89_;
	gconstpointer _tmp90_;
	gfloat pop;
	SynapseRelevancyService* _tmp91_;
	SynapseUtilsFileInfo* _tmp92_;
	const gchar* _tmp93_;
	SynapseResultSet* _tmp94_;
	SynapseUtilsFileInfo* _tmp95_;
	SynapseUriMatch* _tmp96_;
	guint _tmp97_;
	SynapseQuery _tmp98_;
	GeeCollection* _tmp99_;
	gint _tmp100_;
	gint _tmp101_;
	gint _tmp102_;
	gint _tmp103_;
	gint _tmp104_;
	SynapseResultSet* _tmp105_;
	gint _tmp106_;
	gint _tmp107_;
	GError* _inner_error0_;
};

struct _Block3Data {
	int _ref_count_;
	SynapseHybridSearchPlugin* self;
	gpointer _async_data_;
};

struct _SynapseHybridSearchPluginWaitForProcessingFinishedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseHybridSearchPlugin* self;
	Block3Data* _data3_;
	gboolean _tmp0_;
	gulong sig_id;
	gulong _tmp1_;
};

struct _Block4Data {
	int _ref_count_;
	SynapseHybridSearchPlugin* self;
	guint query_id;
	SynapseResultSet* original_rs;
	GeeSet* uris;
	gulong sig_id;
	gpointer _async_data_;
};

struct _SynapseHybridSearchPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseHybridSearchPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	Block4Data* _data4_;
	SynapseQuery _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	SynapseQuery _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GeeMap* _tmp7_;
	SynapseQuery _tmp8_;
	SynapseQuery _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gint last_level_uris;
	GeeHashSet* _tmp12_;
	gulong _tmp13_;
	gulong canc_sig_id;
	SynapseQuery _tmp14_;
	GCancellable* _tmp15_;
	SynapseDataSink* _tmp16_;
	SynapseQuery _tmp17_;
	GCancellable* _tmp18_;
	gboolean _tmp19_;
	GeeSet* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GeeSet* _tmp23_;
	gint _tmp24_;
	gboolean _tmp25_;
	SynapseQuery _tmp26_;
	const gchar* _tmp27_;
	GeeList* directories;
	GeeList* _tmp28_;
	GeeList* _tmp29_;
	SynapseResultSet* _result_;
	SynapseQuery _tmp30_;
	SynapseResultSet* _tmp31_;
	SynapseResultSet* _tmp32_;
	GError* _inner_error1_;
	GError* _inner_error0_;
};

struct _SynapseHybridSearchPluginParamSpecDirectoryInfo {
	GParamSpec parent_instance;
};

static gint SynapseHybridSearchPlugin_private_offset;
static gpointer synapse_hybrid_search_plugin_parent_class = NULL;
static gpointer synapse_hybrid_search_plugin_directory_info_parent_class = NULL;
static SynapseActivatableIface * synapse_hybrid_search_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_hybrid_search_plugin_synapse_item_provider_parent_iface = NULL;

GType synapse_hybrid_search_plugin_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseHybridSearchPlugin, g_object_unref)
static gpointer synapse_hybrid_search_plugin_directory_info_ref (gpointer instance);
static void synapse_hybrid_search_plugin_directory_info_unref (gpointer instance);
static GParamSpec* synapse_hybrid_search_plugin_param_spec_directory_info (const gchar* name,
                                                                    const gchar* nick,
                                                                    const gchar* blurb,
                                                                    GType object_type,
                                                                    GParamFlags flags) G_GNUC_UNUSED;
static void synapse_hybrid_search_plugin_value_set_directory_info (GValue* value,
                                                            gpointer v_object) G_GNUC_UNUSED;
static void synapse_hybrid_search_plugin_value_take_directory_info (GValue* value,
                                                             gpointer v_object) G_GNUC_UNUSED;
static gpointer synapse_hybrid_search_plugin_value_get_directory_info (const GValue* value) G_GNUC_UNUSED;
static GType synapse_hybrid_search_plugin_directory_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseHybridSearchPluginDirectoryInfo, synapse_hybrid_search_plugin_directory_info_unref)
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_RECENT_XML_NAME "recently-used.xbel"
#define SYNAPSE_HYBRID_SEARCH_PLUGIN_MAX_RECENT_DIRS 10
static void synapse_hybrid_search_plugin_real_activate (SynapseActivatable* base);
static void synapse_hybrid_search_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_hybrid_search_plugin_register_plugin (void);
static void _synapse_hybrid_search_plugin_register_plugin_synapse_plugin_register_func (void);
static void synapse_hybrid_search_plugin_real_constructed (GObject* base);
SynapseDataSink* synapse_hybrid_search_plugin_get_data_sink (SynapseHybridSearchPlugin* self);
static void synapse_hybrid_search_plugin_zg_plugin_search_done (SynapseHybridSearchPlugin* self,
                                                         SynapseResultSet* rs,
                                                         guint query_id);
static void _synapse_hybrid_search_plugin_zg_plugin_search_done_synapse_data_sink_search_done (SynapseDataSink* _sender,
                                                                                        SynapseResultSet* rs,
                                                                                        guint query_id,
                                                                                        gpointer self);
static void synapse_hybrid_search_plugin_analyze_recent_documents_data_free (gpointer _data);
static void synapse_hybrid_search_plugin_analyze_recent_documents (SynapseHybridSearchPlugin* self,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_);
static void synapse_hybrid_search_plugin_analyze_recent_documents_finish (SynapseHybridSearchPlugin* self,
                                                                   GAsyncResult* _res_);
static gboolean synapse_hybrid_search_plugin_analyze_recent_documents_co (SynapseHybridSearchPluginAnalyzeRecentDocumentsData* _data_);
static void synapse_hybrid_search_plugin_analyze_recent_documents_ready (GObject* source_object,
                                                                  GAsyncResult* _res_,
                                                                  gpointer _user_data_);
static gint ____lambda9_ (SynapseHybridSearchPlugin* self,
                   GeeMapEntry* a,
                   GeeMapEntry* b);
static gint _____lambda9__gcompare_data_func (gconstpointer a,
                                       gconstpointer b,
                                       gpointer self);
static void synapse_hybrid_search_plugin_process_directories (SynapseHybridSearchPlugin* self,
                                                       GeeCollection* directories,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static void synapse_hybrid_search_plugin_process_directories_finish (SynapseHybridSearchPlugin* self,
                                                              GAsyncResult* _res_);
static void synapse_hybrid_search_plugin_process_uris_data_free (gpointer _data);
static void synapse_hybrid_search_plugin_process_uris (SynapseHybridSearchPlugin* self,
                                                GeeCollection* uris,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void synapse_hybrid_search_plugin_process_uris_finish (SynapseHybridSearchPlugin* self,
                                                       GAsyncResult* _res_);
static gboolean synapse_hybrid_search_plugin_process_uris_co (SynapseHybridSearchPluginProcessUrisData* _data_);
static void synapse_hybrid_search_plugin_process_uris_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static GeeList* synapse_hybrid_search_plugin_get_most_likely_dirs (SynapseHybridSearchPlugin* self);
static gint ___lambda10_ (SynapseHybridSearchPlugin* self,
                   GeeMapEntry* a,
                   GeeMapEntry* b);
static gint ____lambda10__gcompare_data_func (gconstpointer a,
                                       gconstpointer b,
                                       gpointer self);
static void synapse_hybrid_search_plugin_process_directory_contents (SynapseHybridSearchPlugin* self,
                                                              SynapseHybridSearchPluginDirectoryInfo* di,
                                                              GFile* directory,
                                                              GList* files);
static void synapse_hybrid_search_plugin_update_directory_contents_data_free (gpointer _data);
static void synapse_hybrid_search_plugin_update_directory_contents (SynapseHybridSearchPlugin* self,
                                                             GFile* directory,
                                                             SynapseHybridSearchPluginDirectoryInfo* di,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static void synapse_hybrid_search_plugin_update_directory_contents_finish (SynapseHybridSearchPlugin* self,
                                                                    GAsyncResult* _res_,
                                                                    GError** error);
static gboolean synapse_hybrid_search_plugin_update_directory_contents_co (SynapseHybridSearchPluginUpdateDirectoryContentsData* _data_);
static void synapse_hybrid_search_plugin_update_directory_contents_ready (GObject* source_object,
                                                                   GAsyncResult* _res_,
                                                                   gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void synapse_hybrid_search_plugin_process_directories_data_free (gpointer _data);
static gboolean synapse_hybrid_search_plugin_process_directories_co (SynapseHybridSearchPluginProcessDirectoriesData* _data_);
static SynapseHybridSearchPluginDirectoryInfo* synapse_hybrid_search_plugin_directory_info_new (const gchar* path);
static SynapseHybridSearchPluginDirectoryInfo* synapse_hybrid_search_plugin_directory_info_construct (GType object_type,
                                                                                               const gchar* path);
static void synapse_hybrid_search_plugin_process_directories_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static void synapse_hybrid_search_plugin_get_extra_results_data_free (gpointer _data);
static void synapse_hybrid_search_plugin_get_extra_results (SynapseHybridSearchPlugin* self,
                                                     SynapseQuery* q,
                                                     SynapseResultSet* original_rs,
                                                     GeeCollection* dirs,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static SynapseResultSet* synapse_hybrid_search_plugin_get_extra_results_finish (SynapseHybridSearchPlugin* self,
                                                                         GAsyncResult* _res_,
                                                                         GError** error);
static gboolean synapse_hybrid_search_plugin_get_extra_results_co (SynapseHybridSearchPluginGetExtraResultsData* _data_);
static void synapse_hybrid_search_plugin_get_extra_results_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static gboolean synapse_hybrid_search_plugin_real_handles_query (SynapseItemProvider* base,
                                                          SynapseQuery* query);
static void synapse_hybrid_search_plugin_wait_for_processing_finished_data_free (gpointer _data);
static void synapse_hybrid_search_plugin_wait_for_processing_finished (SynapseHybridSearchPlugin* self,
                                                                GAsyncReadyCallback _callback_,
                                                                gpointer _user_data_);
static void synapse_hybrid_search_plugin_wait_for_processing_finished_finish (SynapseHybridSearchPlugin* self,
                                                                       GAsyncResult* _res_);
static gboolean synapse_hybrid_search_plugin_wait_for_processing_finished_co (SynapseHybridSearchPluginWaitForProcessingFinishedData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
gboolean synapse_hybrid_search_plugin_get_processing_query (SynapseHybridSearchPlugin* self);
static void ___lambda11_ (Block3Data* _data3_);
static void ____lambda11__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void synapse_hybrid_search_plugin_real_search_data_free (gpointer _data);
static void synapse_hybrid_search_plugin_real_search (SynapseItemProvider* base,
                                               SynapseQuery* q,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean synapse_hybrid_search_plugin_real_search_co (SynapseHybridSearchPluginSearchData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda12_ (Block4Data* _data4_,
                  SynapseResultSet* rs,
                  guint q_id);
static void ___lambda12__synapse_hybrid_search_plugin_zeitgeist_search_complete (SynapseHybridSearchPlugin* _sender,
                                                                          SynapseResultSet* rs,
                                                                          guint query_id,
                                                                          gpointer self);
static void __lambda13_ (Block4Data* _data4_);
static gboolean _synapse_hybrid_search_plugin_real_search_co_gsource_func (gpointer self);
static void ___lambda13__gfunc (gconstpointer data,
                         gpointer self);
static void synapse_hybrid_search_plugin_search_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void synapse_hybrid_search_plugin_set_processing_query (SynapseHybridSearchPlugin* self,
                                                        gboolean value);
SynapseHybridSearchPlugin* synapse_hybrid_search_plugin_new (void);
SynapseHybridSearchPlugin* synapse_hybrid_search_plugin_construct (GType object_type);
static void synapse_hybrid_search_plugin_set_data_sink (SynapseHybridSearchPlugin* self,
                                                 SynapseDataSink* value);
static void g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void synapse_hybrid_search_plugin_directory_info_finalize (SynapseHybridSearchPluginDirectoryInfo * obj);
static GType synapse_hybrid_search_plugin_directory_info_get_type_once (void);
static GObject * synapse_hybrid_search_plugin_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void synapse_hybrid_search_plugin_finalize (GObject * obj);
static GType synapse_hybrid_search_plugin_get_type_once (void);
static void _vala_synapse_hybrid_search_plugin_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_synapse_hybrid_search_plugin_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
synapse_hybrid_search_plugin_get_instance_private (SynapseHybridSearchPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseHybridSearchPlugin_private_offset);
}

static void
synapse_hybrid_search_plugin_real_activate (SynapseActivatable* base)
{
	SynapseHybridSearchPlugin * self;
#line 34 "../../../src/plugins/hybrid-search-plugin.vala"
	self = (SynapseHybridSearchPlugin*) base;
#line 804 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseHybridSearchPlugin * self;
#line 39 "../../../src/plugins/hybrid-search-plugin.vala"
	self = (SynapseHybridSearchPlugin*) base;
#line 813 "hybrid-search-plugin.c"
}

static void
_synapse_hybrid_search_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 59 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_register_plugin ();
#line 821 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_register_plugin (void)
{
	SynapsePluginRegistry* _tmp0_;
	SynapsePluginRegistry* _tmp1_;
#line 59 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp0_ = synapse_plugin_registry_get_default ();
#line 59 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp1_ = _tmp0_;
#line 59 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN, "Hybrid Search", _ ("Improve results returned by the Zeitgeist plugin by looking " "for similar files on the filesystem."), "search", _synapse_hybrid_search_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
#line 59 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_tmp1_);
#line 837 "hybrid-search-plugin.c"
}

static void
_synapse_hybrid_search_plugin_zg_plugin_search_done_synapse_data_sink_search_done (SynapseDataSink* _sender,
                                                                                   SynapseResultSet* rs,
                                                                                   guint query_id,
                                                                                   gpointer self)
{
#line 86 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_zg_plugin_search_done ((SynapseHybridSearchPlugin*) self, rs, query_id);
#line 848 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_real_constructed (GObject* base)
{
	SynapseHybridSearchPlugin * self;
	SynapseDataSink* _tmp0_;
#line 84 "../../../src/plugins/hybrid-search-plugin.vala"
	self = (SynapseHybridSearchPlugin*) base;
#line 86 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp0_ = self->priv->_data_sink;
#line 86 "../../../src/plugins/hybrid-search-plugin.vala"
	g_signal_connect_object (_tmp0_, "search-done::SynapseZeitgeistPlugin", (GCallback) _synapse_hybrid_search_plugin_zg_plugin_search_done_synapse_data_sink_search_done, self, 0);
#line 862 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_analyze_recent_documents_data_free (gpointer _data)
{
	SynapseHybridSearchPluginAnalyzeRecentDocumentsData* _data_;
	_data_ = _data;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	g_slice_free (SynapseHybridSearchPluginAnalyzeRecentDocumentsData, _data_);
#line 874 "hybrid-search-plugin.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 882 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_analyze_recent_documents (SynapseHybridSearchPlugin* self,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_)
{
	SynapseHybridSearchPluginAnalyzeRecentDocumentsData* _data_;
	SynapseHybridSearchPlugin* _tmp0_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_ = g_slice_new0 (SynapseHybridSearchPluginAnalyzeRecentDocumentsData);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_hybrid_search_plugin_analyze_recent_documents_data_free);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->self = _tmp0_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_analyze_recent_documents_co (_data_);
#line 904 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_analyze_recent_documents_finish (SynapseHybridSearchPlugin* self,
                                                              GAsyncResult* _res_)
{
	SynapseHybridSearchPluginAnalyzeRecentDocumentsData* _data_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 914 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_analyze_recent_documents_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_)
{
	SynapseHybridSearchPluginAnalyzeRecentDocumentsData* _data_;
#line 107 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_ = _user_data_;
#line 107 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_source_object_ = source_object;
#line 107 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_res_ = _res_;
#line 107 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_analyze_recent_documents_co (_data_);
#line 931 "hybrid-search-plugin.c"
}

static gint
____lambda9_ (SynapseHybridSearchPlugin* self,
              GeeMapEntry* a,
              GeeMapEntry* b)
{
	GeeMapEntry* e1 = NULL;
	GeeMapEntry* e2 = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	gconstpointer _tmp2_;
	gconstpointer _tmp3_;
	gint result = 0;
#line 150 "../../../src/plugins/hybrid-search-plugin.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 150 "../../../src/plugins/hybrid-search-plugin.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 151 "../../../src/plugins/hybrid-search-plugin.vala"
	e1 = G_TYPE_CHECK_INSTANCE_CAST (a, GEE_MAP_TYPE_ENTRY, GeeMapEntry);
#line 152 "../../../src/plugins/hybrid-search-plugin.vala"
	e2 = G_TYPE_CHECK_INSTANCE_CAST (b, GEE_MAP_TYPE_ENTRY, GeeMapEntry);
#line 153 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp0_ = gee_map_entry_get_value (e2);
#line 153 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp1_ = _tmp0_;
#line 153 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp2_ = gee_map_entry_get_value (e1);
#line 153 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp3_ = _tmp2_;
#line 153 "../../../src/plugins/hybrid-search-plugin.vala"
	result = ((gint) ((gintptr) _tmp1_)) - ((gint) ((gintptr) _tmp3_));
#line 153 "../../../src/plugins/hybrid-search-plugin.vala"
	return result;
#line 966 "hybrid-search-plugin.c"
}

static gint
_____lambda9__gcompare_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gint result;
	result = ____lambda9_ ((SynapseHybridSearchPlugin*) self, (GeeMapEntry*) a, (GeeMapEntry*) b);
#line 150 "../../../src/plugins/hybrid-search-plugin.vala"
	return result;
#line 978 "hybrid-search-plugin.c"
}

static gboolean
synapse_hybrid_search_plugin_analyze_recent_documents_co (SynapseHybridSearchPluginAnalyzeRecentDocumentsData* _data_)
{
#line 92 "../../../src/plugins/hybrid-search-plugin.vala"
	switch (_data_->_state_) {
#line 92 "../../../src/plugins/hybrid-search-plugin.vala"
		case 0:
#line 988 "hybrid-search-plugin.c"
		goto _state_0;
#line 92 "../../../src/plugins/hybrid-search-plugin.vala"
		case 1:
#line 992 "hybrid-search-plugin.c"
		goto _state_1;
#line 92 "../../../src/plugins/hybrid-search-plugin.vala"
		case 2:
#line 996 "hybrid-search-plugin.c"
		goto _state_2;
#line 92 "../../../src/plugins/hybrid-search-plugin.vala"
		case 3:
#line 1000 "hybrid-search-plugin.c"
		goto _state_3;
#line 92 "../../../src/plugins/hybrid-search-plugin.vala"
		case 4:
#line 1004 "hybrid-search-plugin.c"
		goto _state_4;
		default:
#line 92 "../../../src/plugins/hybrid-search-plugin.vala"
		g_assert_not_reached ();
#line 1009 "hybrid-search-plugin.c"
	}
	_state_0:
#line 94 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp0_ = g_get_home_dir ();
#line 94 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp1_ = g_build_filename (_data_->_tmp0_, "." SYNAPSE_HYBRID_SEARCH_PLUGIN_RECENT_XML_NAME, NULL, NULL);
#line 94 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 94 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp3_ = g_file_new_for_path (_data_->_tmp2_);
#line 94 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 94 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_free0 (_data_->_tmp2_);
#line 94 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->recent = _data_->_tmp4_;
#line 1026 "hybrid-search-plugin.c"
	{
#line 99 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->file_contents_length1 = 0;
#line 99 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_file_contents_size_ = 0;
#line 1032 "hybrid-search-plugin.c"
		{
#line 107 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp6_ = _data_->recent;
#line 107 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp7_ = NULL;
#line 107 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp8_ = 0;
#line 107 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_state_ = 1;
#line 107 "../../../src/plugins/hybrid-search-plugin.vala"
			g_file_load_contents_async (_data_->_tmp6_, NULL, synapse_hybrid_search_plugin_analyze_recent_documents_ready, _data_);
#line 107 "../../../src/plugins/hybrid-search-plugin.vala"
			return FALSE;
#line 1046 "hybrid-search-plugin.c"
			_state_1:
#line 107 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp9_ = g_file_load_contents_finish (_data_->_tmp6_, _data_->_res_, &_data_->_tmp7_, &_data_->_tmp8_, NULL, &_data_->_inner_error0_);
#line 107 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->file_contents = (g_free (_data_->file_contents), NULL);
#line 107 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->file_contents = _data_->_tmp7_;
#line 107 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->file_contents_length1 = _data_->_tmp8_;
#line 107 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_file_contents_size_ = _data_->file_contents_length1;
#line 107 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp5_ = _data_->_tmp9_;
#line 107 "../../../src/plugins/hybrid-search-plugin.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 1062 "hybrid-search-plugin.c"
				goto __catch1_g_error;
			}
#line 107 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->load_ok = _data_->_tmp5_;
#line 1067 "hybrid-search-plugin.c"
		}
		goto __finally1;
		__catch1_g_error:
		{
#line 105 "../../../src/plugins/hybrid-search-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 112 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->load_ok = FALSE;
#line 1076 "hybrid-search-plugin.c"
		}
		__finally1:
#line 105 "../../../src/plugins/hybrid-search-plugin.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 105 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_free0 (_data_->contents);
#line 105 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->file_contents = (g_free (_data_->file_contents), NULL);
#line 1085 "hybrid-search-plugin.c"
			goto __catch0_g_error;
		}
#line 116 "../../../src/plugins/hybrid-search-plugin.vala"
		if (!_data_->load_ok) {
#line 118 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp10_ = g_get_user_data_dir ();
#line 118 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp11_ = g_build_filename (_data_->_tmp10_, SYNAPSE_HYBRID_SEARCH_PLUGIN_RECENT_XML_NAME, NULL, NULL);
#line 118 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp12_ = _data_->_tmp11_;
#line 118 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp13_ = g_file_new_for_path (_data_->_tmp12_);
#line 118 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_object_unref0 (_data_->recent);
#line 118 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->recent = _data_->_tmp13_;
#line 118 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_free0 (_data_->_tmp12_);
#line 120 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp15_ = _data_->recent;
#line 120 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp16_ = NULL;
#line 120 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp17_ = 0;
#line 120 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_state_ = 2;
#line 120 "../../../src/plugins/hybrid-search-plugin.vala"
			g_file_load_contents_async (_data_->_tmp15_, NULL, synapse_hybrid_search_plugin_analyze_recent_documents_ready, _data_);
#line 120 "../../../src/plugins/hybrid-search-plugin.vala"
			return FALSE;
#line 1116 "hybrid-search-plugin.c"
			_state_2:
#line 120 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp18_ = g_file_load_contents_finish (_data_->_tmp15_, _data_->_res_, &_data_->_tmp16_, &_data_->_tmp17_, NULL, &_data_->_inner_error0_);
#line 120 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->file_contents = (g_free (_data_->file_contents), NULL);
#line 120 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->file_contents = _data_->_tmp16_;
#line 120 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->file_contents_length1 = _data_->_tmp17_;
#line 120 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_file_contents_size_ = _data_->file_contents_length1;
#line 120 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp14_ = _data_->_tmp18_;
#line 120 "../../../src/plugins/hybrid-search-plugin.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 120 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_free0 (_data_->contents);
#line 120 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->file_contents = (g_free (_data_->file_contents), NULL);
#line 1136 "hybrid-search-plugin.c"
				goto __catch0_g_error;
			}
#line 120 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->load_ok = _data_->_tmp14_;
#line 1141 "hybrid-search-plugin.c"
		}
#line 124 "../../../src/plugins/hybrid-search-plugin.vala"
		if (_data_->load_ok) {
#line 126 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp19_ = _data_->file_contents;
#line 126 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp19__length1 = _data_->file_contents_length1;
#line 126 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp20_ = g_strdup ((const gchar*) _data_->_tmp19_);
#line 126 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_free0 (_data_->contents);
#line 126 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->contents = _data_->_tmp20_;
#line 127 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp21_ = _data_->file_contents;
#line 127 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp21__length1 = _data_->file_contents_length1;
#line 127 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->len = (gsize) _data_->_tmp21__length1;
#line 130 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp22_ = g_bookmark_file_new ();
#line 130 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->bf = _data_->_tmp22_;
#line 131 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp23_ = _data_->bf;
#line 131 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp24_ = _data_->contents;
#line 131 "../../../src/plugins/hybrid-search-plugin.vala"
			g_bookmark_file_load_from_data (_data_->_tmp23_, _data_->_tmp24_, _data_->len, &_data_->_inner_error0_);
#line 131 "../../../src/plugins/hybrid-search-plugin.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 131 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_bookmark_file_free0 (_data_->bf);
#line 131 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_free0 (_data_->contents);
#line 131 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->file_contents = (g_free (_data_->file_contents), NULL);
#line 1179 "hybrid-search-plugin.c"
				goto __catch0_g_error;
			}
#line 132 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp25_ = _data_->bf;
#line 132 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp26_ = 0;
#line 132 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp27_ = g_bookmark_file_get_uris (_data_->_tmp25_, &_data_->_tmp26_);
#line 132 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->uris = _data_->_tmp27_;
#line 132 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->uris_length1 = _data_->_tmp26_;
#line 132 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_uris_size_ = _data_->uris_length1;
#line 135 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp28_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 135 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->dir_hits = (GeeMap*) _data_->_tmp28_;
#line 137 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp29_ = _data_->uris;
#line 137 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp29__length1 = _data_->uris_length1;
#line 1202 "hybrid-search-plugin.c"
			{
#line 137 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->uri_collection_length1 = 0;
#line 137 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_uri_collection_size_ = 0;
#line 137 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->uri_collection = _data_->_tmp29_;
#line 137 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->uri_collection_length1 = _data_->_tmp29__length1;
#line 137 "../../../src/plugins/hybrid-search-plugin.vala"
				for (_data_->uri_it = 0; _data_->uri_it < _data_->uri_collection_length1; _data_->uri_it = _data_->uri_it + 1) {
#line 137 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->uri = _data_->uri_collection[_data_->uri_it];
#line 1216 "hybrid-search-plugin.c"
					{
#line 139 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp30_ = _data_->uri;
#line 139 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp31_ = g_file_new_for_uri (_data_->_tmp30_);
#line 139 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->f = _data_->_tmp31_;
#line 140 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp32_ = _data_->f;
#line 140 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp33_ = g_file_get_parent (_data_->_tmp32_);
#line 140 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->parent = _data_->_tmp33_;
#line 141 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp34_ = _data_->parent;
#line 141 "../../../src/plugins/hybrid-search-plugin.vala"
						if (_data_->_tmp34_ == NULL) {
#line 141 "../../../src/plugins/hybrid-search-plugin.vala"
							_g_object_unref0 (_data_->parent);
#line 141 "../../../src/plugins/hybrid-search-plugin.vala"
							_g_object_unref0 (_data_->f);
#line 141 "../../../src/plugins/hybrid-search-plugin.vala"
							continue;
#line 1240 "hybrid-search-plugin.c"
						}
#line 142 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp35_ = _data_->parent;
#line 142 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp36_ = g_file_get_path (_data_->_tmp35_);
#line 142 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->parent_path = _data_->_tmp36_;
#line 143 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp37_ = _data_->parent_path;
#line 143 "../../../src/plugins/hybrid-search-plugin.vala"
						if (_data_->_tmp37_ == NULL) {
#line 143 "../../../src/plugins/hybrid-search-plugin.vala"
							_g_free0 (_data_->parent_path);
#line 143 "../../../src/plugins/hybrid-search-plugin.vala"
							_g_object_unref0 (_data_->parent);
#line 143 "../../../src/plugins/hybrid-search-plugin.vala"
							_g_object_unref0 (_data_->f);
#line 143 "../../../src/plugins/hybrid-search-plugin.vala"
							continue;
#line 1260 "hybrid-search-plugin.c"
						}
#line 144 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp38_ = _data_->dir_hits;
#line 144 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp39_ = _data_->parent_path;
#line 144 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp40_ = _data_->dir_hits;
#line 144 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp41_ = _data_->parent_path;
#line 144 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp42_ = gee_map_get (_data_->_tmp40_, _data_->_tmp41_);
#line 144 "../../../src/plugins/hybrid-search-plugin.vala"
						gee_map_set (_data_->_tmp38_, _data_->_tmp39_, (gpointer) ((gintptr) (((gint) ((gintptr) _data_->_tmp42_)) + 1)));
#line 137 "../../../src/plugins/hybrid-search-plugin.vala"
						_g_free0 (_data_->parent_path);
#line 137 "../../../src/plugins/hybrid-search-plugin.vala"
						_g_object_unref0 (_data_->parent);
#line 137 "../../../src/plugins/hybrid-search-plugin.vala"
						_g_object_unref0 (_data_->f);
#line 1280 "hybrid-search-plugin.c"
					}
				}
			}
#line 148 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp43_ = gee_array_list_new (GEE_MAP_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 148 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->sorted_dirs = (GeeList*) _data_->_tmp43_;
#line 149 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp44_ = _data_->sorted_dirs;
#line 149 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp45_ = _data_->dir_hits;
#line 149 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp46_ = gee_map_get_entries (_data_->_tmp45_);
#line 149 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp47_ = _data_->_tmp46_;
#line 149 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp48_ = _data_->_tmp47_;
#line 149 "../../../src/plugins/hybrid-search-plugin.vala"
			gee_collection_add_all ((GeeCollection*) _data_->_tmp44_, (GeeCollection*) _data_->_tmp48_);
#line 149 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_object_unref0 (_data_->_tmp48_);
#line 150 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp49_ = _data_->sorted_dirs;
#line 150 "../../../src/plugins/hybrid-search-plugin.vala"
			gee_list_sort (_data_->_tmp49_, _____lambda9__gcompare_data_func, g_object_ref (_data_->self), g_object_unref);
#line 157 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp50_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 157 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->directories = (GeeList*) _data_->_tmp50_;
#line 1310 "hybrid-search-plugin.c"
			{
#line 158 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->i = 0;
#line 1314 "hybrid-search-plugin.c"
				{
#line 158 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp51_ = TRUE;
#line 158 "../../../src/plugins/hybrid-search-plugin.vala"
					while (TRUE) {
#line 158 "../../../src/plugins/hybrid-search-plugin.vala"
						if (!_data_->_tmp51_) {
#line 159 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_tmp52_ = _data_->i;
#line 159 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->i = _data_->_tmp52_ + 1;
#line 1326 "hybrid-search-plugin.c"
						}
#line 158 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp51_ = FALSE;
#line 159 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp54_ = _data_->sorted_dirs;
#line 159 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp55_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp54_);
#line 159 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp56_ = _data_->_tmp55_;
#line 159 "../../../src/plugins/hybrid-search-plugin.vala"
						if (_data_->i < _data_->_tmp56_) {
#line 159 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_tmp57_ = _data_->directories;
#line 159 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_tmp58_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp57_);
#line 159 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_tmp59_ = _data_->_tmp58_;
#line 159 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_tmp53_ = _data_->_tmp59_ < SYNAPSE_HYBRID_SEARCH_PLUGIN_MAX_RECENT_DIRS;
#line 1346 "hybrid-search-plugin.c"
						} else {
#line 159 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_tmp53_ = FALSE;
#line 1350 "hybrid-search-plugin.c"
						}
#line 159 "../../../src/plugins/hybrid-search-plugin.vala"
						if (!_data_->_tmp53_) {
#line 159 "../../../src/plugins/hybrid-search-plugin.vala"
							break;
#line 1356 "hybrid-search-plugin.c"
						}
#line 161 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp60_ = _data_->sorted_dirs;
#line 161 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp61_ = gee_list_get (_data_->_tmp60_, _data_->i);
#line 161 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp62_ = (GeeMapEntry*) _data_->_tmp61_;
#line 161 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp63_ = gee_map_entry_get_key (_data_->_tmp62_);
#line 161 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp64_ = _data_->_tmp63_;
#line 161 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp65_ = g_strdup ((const gchar*) _data_->_tmp64_);
#line 161 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp66_ = _data_->_tmp65_;
#line 161 "../../../src/plugins/hybrid-search-plugin.vala"
						_g_object_unref0 (_data_->_tmp62_);
#line 161 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->dir_path = _data_->_tmp66_;
#line 162 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp67_ = _data_->dir_path;
#line 162 "../../../src/plugins/hybrid-search-plugin.vala"
						if (g_str_has_prefix (_data_->_tmp67_, "/tmp")) {
#line 162 "../../../src/plugins/hybrid-search-plugin.vala"
							_g_free0 (_data_->dir_path);
#line 162 "../../../src/plugins/hybrid-search-plugin.vala"
							continue;
#line 1384 "hybrid-search-plugin.c"
						}
#line 163 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp68_ = _data_->dir_path;
#line 163 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp69_ = g_file_new_for_path (_data_->_tmp68_);
#line 163 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->dir_f = _data_->_tmp69_;
#line 164 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp70_ = _data_->dir_f;
#line 164 "../../../src/plugins/hybrid-search-plugin.vala"
						if (g_file_is_native (_data_->_tmp70_)) {
#line 167 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_tmp71_ = _data_->dir_f;
#line 167 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_state_ = 3;
#line 167 "../../../src/plugins/hybrid-search-plugin.vala"
							synapse_utils_query_exists_async (_data_->_tmp71_, synapse_hybrid_search_plugin_analyze_recent_documents_ready, _data_);
#line 167 "../../../src/plugins/hybrid-search-plugin.vala"
							return FALSE;
#line 1404 "hybrid-search-plugin.c"
							_state_3:
#line 167 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->exists = synapse_utils_query_exists_finish (_data_->_res_);
#line 168 "../../../src/plugins/hybrid-search-plugin.vala"
							if (_data_->exists) {
#line 168 "../../../src/plugins/hybrid-search-plugin.vala"
								_data_->_tmp72_ = _data_->directories;
#line 168 "../../../src/plugins/hybrid-search-plugin.vala"
								_data_->_tmp73_ = _data_->dir_path;
#line 168 "../../../src/plugins/hybrid-search-plugin.vala"
								gee_collection_add ((GeeCollection*) _data_->_tmp72_, _data_->_tmp73_);
#line 1416 "hybrid-search-plugin.c"
							}
						}
#line 158 "../../../src/plugins/hybrid-search-plugin.vala"
						_g_object_unref0 (_data_->dir_f);
#line 158 "../../../src/plugins/hybrid-search-plugin.vala"
						_g_free0 (_data_->dir_path);
#line 1423 "hybrid-search-plugin.c"
					}
				}
			}
#line 172 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp74_ = _data_->directories;
#line 172 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_state_ = 4;
#line 172 "../../../src/plugins/hybrid-search-plugin.vala"
			synapse_hybrid_search_plugin_process_directories (_data_->self, (GeeCollection*) _data_->_tmp74_, synapse_hybrid_search_plugin_analyze_recent_documents_ready, _data_);
#line 172 "../../../src/plugins/hybrid-search-plugin.vala"
			return FALSE;
#line 1435 "hybrid-search-plugin.c"
			_state_4:
#line 172 "../../../src/plugins/hybrid-search-plugin.vala"
			synapse_hybrid_search_plugin_process_directories_finish (_data_->self, _data_->_res_);
#line 174 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->z = 0;
#line 1441 "hybrid-search-plugin.c"
			{
#line 175 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp75_ = _data_->self->priv->directory_contents;
#line 175 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp76_ = gee_map_get_entries (_data_->_tmp75_);
#line 175 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp77_ = _data_->_tmp76_;
#line 175 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp78_ = _data_->_tmp77_;
#line 175 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp79_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp78_);
#line 175 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp80_ = _data_->_tmp79_;
#line 175 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (_data_->_tmp78_);
#line 175 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_x_it = _data_->_tmp80_;
#line 175 "../../../src/plugins/hybrid-search-plugin.vala"
				while (TRUE) {
#line 175 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp81_ = _data_->_x_it;
#line 175 "../../../src/plugins/hybrid-search-plugin.vala"
					if (!gee_iterator_next (_data_->_tmp81_)) {
#line 175 "../../../src/plugins/hybrid-search-plugin.vala"
						break;
#line 1467 "hybrid-search-plugin.c"
					}
#line 175 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp82_ = _data_->_x_it;
#line 175 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp83_ = gee_iterator_get (_data_->_tmp82_);
#line 175 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->x = (GeeMapEntry*) _data_->_tmp83_;
#line 177 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp84_ = _data_->x;
#line 177 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp85_ = gee_map_entry_get_value (_data_->_tmp84_);
#line 177 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp86_ = _data_->_tmp85_;
#line 177 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp87_ = ((SynapseHybridSearchPluginDirectoryInfo*) _data_->_tmp86_)->files;
#line 177 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp88_ = gee_map_get_size (_data_->_tmp87_);
#line 177 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp89_ = _data_->_tmp88_;
#line 177 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->z += _data_->_tmp89_;
#line 175 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->x);
#line 1491 "hybrid-search-plugin.c"
				}
#line 175 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (_data_->_x_it);
#line 1495 "hybrid-search-plugin.c"
			}
#line 179 "../../../src/plugins/hybrid-search-plugin.vala"
			g_message ("hybrid-search-plugin.vala:179: keeps in cache now %d file names", _data_->z);
#line 124 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_object_unref0 (_data_->directories);
#line 124 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_object_unref0 (_data_->sorted_dirs);
#line 124 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_object_unref0 (_data_->dir_hits);
#line 124 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->uris = (_vala_array_free (_data_->uris, _data_->uris_length1, (GDestroyNotify) g_free), NULL);
#line 124 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_bookmark_file_free0 (_data_->bf);
#line 1509 "hybrid-search-plugin.c"
		}
#line 97 "../../../src/plugins/hybrid-search-plugin.vala"
		_g_free0 (_data_->contents);
#line 97 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->file_contents = (g_free (_data_->file_contents), NULL);
#line 1515 "hybrid-search-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 97 "../../../src/plugins/hybrid-search-plugin.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 184 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp90_ = _data_->recent;
#line 184 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp91_ = g_file_get_path (_data_->_tmp90_);
#line 184 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp92_ = _data_->_tmp91_;
#line 184 "../../../src/plugins/hybrid-search-plugin.vala"
		g_warning ("hybrid-search-plugin.vala:184: Unable to parse %s", _data_->_tmp92_);
#line 184 "../../../src/plugins/hybrid-search-plugin.vala"
		_g_free0 (_data_->_tmp92_);
#line 1532 "hybrid-search-plugin.c"
	}
	__finally0:
#line 97 "../../../src/plugins/hybrid-search-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 97 "../../../src/plugins/hybrid-search-plugin.vala"
		_g_object_unref0 (_data_->recent);
#line 97 "../../../src/plugins/hybrid-search-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 97 "../../../src/plugins/hybrid-search-plugin.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 97 "../../../src/plugins/hybrid-search-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 97 "../../../src/plugins/hybrid-search-plugin.vala"
		return FALSE;
#line 1547 "hybrid-search-plugin.c"
	}
#line 187 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->self->priv->initialization_done = TRUE;
#line 92 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->recent);
#line 92 "../../../src/plugins/hybrid-search-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 92 "../../../src/plugins/hybrid-search-plugin.vala"
	if (_data_->_state_ != 0) {
#line 92 "../../../src/plugins/hybrid-search-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 92 "../../../src/plugins/hybrid-search-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1561 "hybrid-search-plugin.c"
		}
	}
#line 92 "../../../src/plugins/hybrid-search-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 92 "../../../src/plugins/hybrid-search-plugin.vala"
	return FALSE;
#line 1568 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_zg_plugin_search_done (SynapseHybridSearchPlugin* self,
                                                    SynapseResultSet* rs,
                                                    guint query_id)
{
#line 192 "../../../src/plugins/hybrid-search-plugin.vala"
	g_return_if_fail (self != NULL);
#line 194 "../../../src/plugins/hybrid-search-plugin.vala"
	g_signal_emit (self, synapse_hybrid_search_plugin_signals[SYNAPSE_HYBRID_SEARCH_PLUGIN_ZEITGEIST_SEARCH_COMPLETE_SIGNAL], 0, rs, query_id);
#line 1580 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_process_uris_data_free (gpointer _data)
{
	SynapseHybridSearchPluginProcessUrisData* _data_;
	_data_ = _data;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->uris);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	g_slice_free (SynapseHybridSearchPluginProcessUrisData, _data_);
#line 1594 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_process_uris (SynapseHybridSearchPlugin* self,
                                           GeeCollection* uris,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	SynapseHybridSearchPluginProcessUrisData* _data_;
	SynapseHybridSearchPlugin* _tmp0_;
	GeeCollection* _tmp1_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_ = g_slice_new0 (SynapseHybridSearchPluginProcessUrisData);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_hybrid_search_plugin_process_uris_data_free);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->self = _tmp0_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp1_ = _g_object_ref0 (uris);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->uris);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->uris = _tmp1_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_process_uris_co (_data_);
#line 1624 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_process_uris_finish (SynapseHybridSearchPlugin* self,
                                                  GAsyncResult* _res_)
{
	SynapseHybridSearchPluginProcessUrisData* _data_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 1634 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_process_uris_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	SynapseHybridSearchPluginProcessUrisData* _data_;
#line 212 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_ = _user_data_;
#line 212 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_source_object_ = source_object;
#line 212 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_res_ = _res_;
#line 212 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_process_uris_co (_data_);
#line 1651 "hybrid-search-plugin.c"
}

static gboolean
synapse_hybrid_search_plugin_process_uris_co (SynapseHybridSearchPluginProcessUrisData* _data_)
{
#line 201 "../../../src/plugins/hybrid-search-plugin.vala"
	switch (_data_->_state_) {
#line 201 "../../../src/plugins/hybrid-search-plugin.vala"
		case 0:
#line 1661 "hybrid-search-plugin.c"
		goto _state_0;
#line 201 "../../../src/plugins/hybrid-search-plugin.vala"
		case 1:
#line 1665 "hybrid-search-plugin.c"
		goto _state_1;
		default:
#line 201 "../../../src/plugins/hybrid-search-plugin.vala"
		g_assert_not_reached ();
#line 1670 "hybrid-search-plugin.c"
	}
	_state_0:
#line 203 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 203 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->dirs = (GeeSet*) _data_->_tmp0_;
#line 1677 "hybrid-search-plugin.c"
	{
#line 205 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp1_ = gee_iterable_iterator ((GeeIterable*) _data_->uris);
#line 205 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_uri_it = _data_->_tmp1_;
#line 205 "../../../src/plugins/hybrid-search-plugin.vala"
		while (TRUE) {
#line 205 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp2_ = _data_->_uri_it;
#line 205 "../../../src/plugins/hybrid-search-plugin.vala"
			if (!gee_iterator_next (_data_->_tmp2_)) {
#line 205 "../../../src/plugins/hybrid-search-plugin.vala"
				break;
#line 1691 "hybrid-search-plugin.c"
			}
#line 205 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp3_ = _data_->_uri_it;
#line 205 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp4_ = gee_iterator_get (_data_->_tmp3_);
#line 205 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->uri = (gchar*) _data_->_tmp4_;
#line 207 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp5_ = _data_->uri;
#line 207 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp6_ = g_file_new_for_uri (_data_->_tmp5_);
#line 207 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->f = _data_->_tmp6_;
#line 1705 "hybrid-search-plugin.c"
			{
#line 210 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp7_ = _data_->f;
#line 210 "../../../src/plugins/hybrid-search-plugin.vala"
				if (g_file_is_native (_data_->_tmp7_)) {
#line 212 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp8_ = _data_->f;
#line 212 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_state_ = 1;
#line 212 "../../../src/plugins/hybrid-search-plugin.vala"
					g_file_query_info_async (_data_->_tmp8_, G_FILE_ATTRIBUTE_STANDARD_TYPE, 0, 0, NULL, synapse_hybrid_search_plugin_process_uris_ready, _data_);
#line 212 "../../../src/plugins/hybrid-search-plugin.vala"
					return FALSE;
#line 1719 "hybrid-search-plugin.c"
					_state_1:
#line 212 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp9_ = g_file_query_info_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error0_);
#line 212 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->fi = _data_->_tmp9_;
#line 212 "../../../src/plugins/hybrid-search-plugin.vala"
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 1727 "hybrid-search-plugin.c"
						goto __catch0_g_error;
					}
#line 214 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp10_ = _data_->fi;
#line 214 "../../../src/plugins/hybrid-search-plugin.vala"
					if (g_file_info_get_file_type (_data_->_tmp10_) == G_FILE_TYPE_REGULAR) {
#line 216 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp11_ = _data_->f;
#line 216 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp12_ = g_file_get_parent (_data_->_tmp11_);
#line 216 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp13_ = _data_->_tmp12_;
#line 216 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp14_ = g_file_get_path (_data_->_tmp13_);
#line 216 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp15_ = _data_->_tmp14_;
#line 216 "../../../src/plugins/hybrid-search-plugin.vala"
						_g_object_unref0 (_data_->_tmp13_);
#line 216 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->parent_path = _data_->_tmp15_;
#line 217 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp16_ = _data_->parent_path;
#line 217 "../../../src/plugins/hybrid-search-plugin.vala"
						if (_data_->_tmp16_ != NULL) {
#line 217 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_tmp17_ = _data_->dirs;
#line 217 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_tmp18_ = _data_->parent_path;
#line 217 "../../../src/plugins/hybrid-search-plugin.vala"
							gee_collection_add ((GeeCollection*) _data_->_tmp17_, _data_->_tmp18_);
#line 1758 "hybrid-search-plugin.c"
						}
#line 214 "../../../src/plugins/hybrid-search-plugin.vala"
						_g_free0 (_data_->parent_path);
#line 1762 "hybrid-search-plugin.c"
					}
#line 210 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->fi);
#line 1766 "hybrid-search-plugin.c"
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
#line 208 "../../../src/plugins/hybrid-search-plugin.vala"
				g_clear_error (&_data_->_inner_error0_);
#line 223 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (_data_->f);
#line 223 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_free0 (_data_->uri);
#line 223 "../../../src/plugins/hybrid-search-plugin.vala"
				continue;
#line 1780 "hybrid-search-plugin.c"
			}
			__finally0:
#line 208 "../../../src/plugins/hybrid-search-plugin.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 208 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (_data_->f);
#line 208 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_free0 (_data_->uri);
#line 208 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (_data_->_uri_it);
#line 208 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (_data_->dirs);
#line 208 "../../../src/plugins/hybrid-search-plugin.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 208 "../../../src/plugins/hybrid-search-plugin.vala"
				g_clear_error (&_data_->_inner_error0_);
#line 208 "../../../src/plugins/hybrid-search-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 208 "../../../src/plugins/hybrid-search-plugin.vala"
				return FALSE;
#line 1801 "hybrid-search-plugin.c"
			}
#line 205 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_object_unref0 (_data_->f);
#line 205 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_free0 (_data_->uri);
#line 1807 "hybrid-search-plugin.c"
		}
#line 205 "../../../src/plugins/hybrid-search-plugin.vala"
		_g_object_unref0 (_data_->_uri_it);
#line 1811 "hybrid-search-plugin.c"
	}
#line 227 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp20_ = _data_->self->priv->current_query;
#line 227 "../../../src/plugins/hybrid-search-plugin.vala"
	if (_data_->_tmp20_ == NULL) {
#line 227 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp19_ = 1;
#line 1819 "hybrid-search-plugin.c"
	} else {
#line 227 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp21_ = _data_->self->priv->current_query;
#line 227 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp19_ = g_utf8_strlen (_data_->_tmp21_, (gssize) -1);
#line 1825 "hybrid-search-plugin.c"
	}
#line 227 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->q_len = _data_->_tmp19_;
#line 1829 "hybrid-search-plugin.c"
	{
#line 228 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp22_ = _data_->dirs;
#line 228 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp23_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp22_);
#line 228 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_dir_it = _data_->_tmp23_;
#line 228 "../../../src/plugins/hybrid-search-plugin.vala"
		while (TRUE) {
#line 228 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp24_ = _data_->_dir_it;
#line 228 "../../../src/plugins/hybrid-search-plugin.vala"
			if (!gee_iterator_next (_data_->_tmp24_)) {
#line 228 "../../../src/plugins/hybrid-search-plugin.vala"
				break;
#line 1845 "hybrid-search-plugin.c"
			}
#line 228 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp25_ = _data_->_dir_it;
#line 228 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp26_ = gee_iterator_get (_data_->_tmp25_);
#line 228 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->dir = (gchar*) _data_->_tmp26_;
#line 230 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp27_ = _data_->self->priv->directory_hits;
#line 230 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp28_ = _data_->dir;
#line 230 "../../../src/plugins/hybrid-search-plugin.vala"
			if (gee_map_has_key (_data_->_tmp27_, _data_->_tmp28_)) {
#line 232 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp29_ = _data_->self->priv->directory_hits;
#line 232 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp30_ = _data_->dir;
#line 232 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp31_ = gee_map_get (_data_->_tmp29_, _data_->_tmp30_);
#line 232 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->hit_count = (gint) ((gintptr) _data_->_tmp31_);
#line 233 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp32_ = _data_->self->priv->directory_hits;
#line 233 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp33_ = _data_->dir;
#line 233 "../../../src/plugins/hybrid-search-plugin.vala"
				gee_map_set (_data_->_tmp32_, _data_->_tmp33_, (gpointer) ((gintptr) (_data_->hit_count + _data_->q_len)));
#line 1873 "hybrid-search-plugin.c"
			} else {
#line 237 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp34_ = _data_->self->priv->directory_hits;
#line 237 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp35_ = _data_->dir;
#line 237 "../../../src/plugins/hybrid-search-plugin.vala"
				gee_map_set (_data_->_tmp34_, _data_->_tmp35_, (gpointer) ((gintptr) _data_->q_len));
#line 1881 "hybrid-search-plugin.c"
			}
#line 228 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_free0 (_data_->dir);
#line 1885 "hybrid-search-plugin.c"
		}
#line 228 "../../../src/plugins/hybrid-search-plugin.vala"
		_g_object_unref0 (_data_->_dir_it);
#line 1889 "hybrid-search-plugin.c"
	}
#line 201 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->dirs);
#line 201 "../../../src/plugins/hybrid-search-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 201 "../../../src/plugins/hybrid-search-plugin.vala"
	if (_data_->_state_ != 0) {
#line 201 "../../../src/plugins/hybrid-search-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 201 "../../../src/plugins/hybrid-search-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1901 "hybrid-search-plugin.c"
		}
	}
#line 201 "../../../src/plugins/hybrid-search-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 201 "../../../src/plugins/hybrid-search-plugin.vala"
	return FALSE;
#line 1908 "hybrid-search-plugin.c"
}

static gint
___lambda10_ (SynapseHybridSearchPlugin* self,
              GeeMapEntry* a,
              GeeMapEntry* b)
{
	GeeMapEntry* e1 = NULL;
	GeeMapEntry* e2 = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	gconstpointer _tmp2_;
	gconstpointer _tmp3_;
	gint result = 0;
#line 264 "../../../src/plugins/hybrid-search-plugin.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 264 "../../../src/plugins/hybrid-search-plugin.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 265 "../../../src/plugins/hybrid-search-plugin.vala"
	e1 = G_TYPE_CHECK_INSTANCE_CAST (a, GEE_MAP_TYPE_ENTRY, GeeMapEntry);
#line 266 "../../../src/plugins/hybrid-search-plugin.vala"
	e2 = G_TYPE_CHECK_INSTANCE_CAST (b, GEE_MAP_TYPE_ENTRY, GeeMapEntry);
#line 267 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp0_ = gee_map_entry_get_value (e2);
#line 267 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp1_ = _tmp0_;
#line 267 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp2_ = gee_map_entry_get_value (e1);
#line 267 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp3_ = _tmp2_;
#line 267 "../../../src/plugins/hybrid-search-plugin.vala"
	result = ((gint) ((gintptr) _tmp1_)) - ((gint) ((gintptr) _tmp3_));
#line 267 "../../../src/plugins/hybrid-search-plugin.vala"
	return result;
#line 1943 "hybrid-search-plugin.c"
}

static gint
____lambda10__gcompare_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gint result;
	result = ___lambda10_ ((SynapseHybridSearchPlugin*) self, (GeeMapEntry*) a, (GeeMapEntry*) b);
#line 264 "../../../src/plugins/hybrid-search-plugin.vala"
	return result;
#line 1955 "hybrid-search-plugin.c"
}

static GeeList*
synapse_hybrid_search_plugin_get_most_likely_dirs (SynapseHybridSearchPlugin* self)
{
	gint MAX_ITEMS = 0;
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp0_;
	GeeMap* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeList* result = NULL;
#line 242 "../../../src/plugins/hybrid-search-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 244 "../../../src/plugins/hybrid-search-plugin.vala"
	MAX_ITEMS = 2;
#line 245 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 245 "../../../src/plugins/hybrid-search-plugin.vala"
	_result_ = _tmp0_;
#line 247 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp1_ = self->priv->directory_hits;
#line 247 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp2_ = gee_map_get_size (_tmp1_);
#line 247 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp3_ = _tmp2_;
#line 247 "../../../src/plugins/hybrid-search-plugin.vala"
	if (_tmp3_ <= MAX_ITEMS) {
#line 1984 "hybrid-search-plugin.c"
		{
			GeeIterator* _dir_it = NULL;
			GeeMap* _tmp4_;
			GeeSet* _tmp5_;
			GeeSet* _tmp6_;
			GeeSet* _tmp7_;
			GeeIterator* _tmp8_;
			GeeIterator* _tmp9_;
#line 250 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp4_ = self->priv->directory_hits;
#line 250 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp5_ = gee_map_get_keys (_tmp4_);
#line 250 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp6_ = _tmp5_;
#line 250 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp7_ = _tmp6_;
#line 250 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
#line 250 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp9_ = _tmp8_;
#line 250 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_object_unref0 (_tmp7_);
#line 250 "../../../src/plugins/hybrid-search-plugin.vala"
			_dir_it = _tmp9_;
#line 250 "../../../src/plugins/hybrid-search-plugin.vala"
			while (TRUE) {
#line 2011 "hybrid-search-plugin.c"
				GeeIterator* _tmp10_;
				gchar* dir = NULL;
				GeeIterator* _tmp11_;
				gpointer _tmp12_;
				GeeArrayList* _tmp13_;
				const gchar* _tmp14_;
#line 250 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp10_ = _dir_it;
#line 250 "../../../src/plugins/hybrid-search-plugin.vala"
				if (!gee_iterator_next (_tmp10_)) {
#line 250 "../../../src/plugins/hybrid-search-plugin.vala"
					break;
#line 2024 "hybrid-search-plugin.c"
				}
#line 250 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp11_ = _dir_it;
#line 250 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp12_ = gee_iterator_get (_tmp11_);
#line 250 "../../../src/plugins/hybrid-search-plugin.vala"
				dir = (gchar*) _tmp12_;
#line 250 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp13_ = _result_;
#line 250 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp14_ = dir;
#line 250 "../../../src/plugins/hybrid-search-plugin.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
#line 250 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_free0 (dir);
#line 2040 "hybrid-search-plugin.c"
			}
#line 250 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_object_unref0 (_dir_it);
#line 2044 "hybrid-search-plugin.c"
		}
	} else {
		GeeArrayList* sort_array = NULL;
		GeeArrayList* _tmp15_;
		gint min_hit = 0;
		GeeArrayList* _tmp45_;
		gint count = 0;
#line 254 "../../../src/plugins/hybrid-search-plugin.vala"
		_tmp15_ = gee_array_list_new (GEE_MAP_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 254 "../../../src/plugins/hybrid-search-plugin.vala"
		sort_array = _tmp15_;
#line 255 "../../../src/plugins/hybrid-search-plugin.vala"
		min_hit = G_MAXINT;
#line 2058 "hybrid-search-plugin.c"
		{
			GeeIterator* _entry_it = NULL;
			GeeMap* _tmp16_;
			GeeSet* _tmp17_;
			GeeSet* _tmp18_;
			GeeSet* _tmp19_;
			GeeIterator* _tmp20_;
			GeeIterator* _tmp21_;
#line 256 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp16_ = self->priv->directory_hits;
#line 256 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp17_ = gee_map_get_entries (_tmp16_);
#line 256 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp18_ = _tmp17_;
#line 256 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp19_ = _tmp18_;
#line 256 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp20_ = gee_iterable_iterator ((GeeIterable*) _tmp19_);
#line 256 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp21_ = _tmp20_;
#line 256 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_object_unref0 (_tmp19_);
#line 256 "../../../src/plugins/hybrid-search-plugin.vala"
			_entry_it = _tmp21_;
#line 256 "../../../src/plugins/hybrid-search-plugin.vala"
			while (TRUE) {
#line 2085 "hybrid-search-plugin.c"
				GeeIterator* _tmp22_;
				GeeMapEntry* entry = NULL;
				GeeIterator* _tmp23_;
				gpointer _tmp24_;
				GeeMapEntry* _tmp25_;
				gconstpointer _tmp26_;
				gconstpointer _tmp27_;
#line 256 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp22_ = _entry_it;
#line 256 "../../../src/plugins/hybrid-search-plugin.vala"
				if (!gee_iterator_next (_tmp22_)) {
#line 256 "../../../src/plugins/hybrid-search-plugin.vala"
					break;
#line 2099 "hybrid-search-plugin.c"
				}
#line 256 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp23_ = _entry_it;
#line 256 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp24_ = gee_iterator_get (_tmp23_);
#line 256 "../../../src/plugins/hybrid-search-plugin.vala"
				entry = (GeeMapEntry*) _tmp24_;
#line 258 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp25_ = entry;
#line 258 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp26_ = gee_map_entry_get_value (_tmp25_);
#line 258 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp27_ = _tmp26_;
#line 258 "../../../src/plugins/hybrid-search-plugin.vala"
				if (((gint) ((gintptr) _tmp27_)) < min_hit) {
#line 2115 "hybrid-search-plugin.c"
					GeeMapEntry* _tmp28_;
					gconstpointer _tmp29_;
					gconstpointer _tmp30_;
#line 258 "../../../src/plugins/hybrid-search-plugin.vala"
					_tmp28_ = entry;
#line 258 "../../../src/plugins/hybrid-search-plugin.vala"
					_tmp29_ = gee_map_entry_get_value (_tmp28_);
#line 258 "../../../src/plugins/hybrid-search-plugin.vala"
					_tmp30_ = _tmp29_;
#line 258 "../../../src/plugins/hybrid-search-plugin.vala"
					min_hit = (gint) ((gintptr) _tmp30_);
#line 2127 "hybrid-search-plugin.c"
				}
#line 256 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (entry);
#line 2131 "hybrid-search-plugin.c"
			}
#line 256 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_object_unref0 (_entry_it);
#line 2135 "hybrid-search-plugin.c"
		}
		{
			GeeIterator* _entry_it = NULL;
			GeeMap* _tmp31_;
			GeeSet* _tmp32_;
			GeeSet* _tmp33_;
			GeeSet* _tmp34_;
			GeeIterator* _tmp35_;
			GeeIterator* _tmp36_;
#line 260 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp31_ = self->priv->directory_hits;
#line 260 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp32_ = gee_map_get_entries (_tmp31_);
#line 260 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp33_ = _tmp32_;
#line 260 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp34_ = _tmp33_;
#line 260 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp35_ = gee_iterable_iterator ((GeeIterable*) _tmp34_);
#line 260 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp36_ = _tmp35_;
#line 260 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_object_unref0 (_tmp34_);
#line 260 "../../../src/plugins/hybrid-search-plugin.vala"
			_entry_it = _tmp36_;
#line 260 "../../../src/plugins/hybrid-search-plugin.vala"
			while (TRUE) {
#line 2163 "hybrid-search-plugin.c"
				GeeIterator* _tmp37_;
				GeeMapEntry* entry = NULL;
				GeeIterator* _tmp38_;
				gpointer _tmp39_;
				GeeMapEntry* _tmp40_;
				gconstpointer _tmp41_;
				gconstpointer _tmp42_;
#line 260 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp37_ = _entry_it;
#line 260 "../../../src/plugins/hybrid-search-plugin.vala"
				if (!gee_iterator_next (_tmp37_)) {
#line 260 "../../../src/plugins/hybrid-search-plugin.vala"
					break;
#line 2177 "hybrid-search-plugin.c"
				}
#line 260 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp38_ = _entry_it;
#line 260 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp39_ = gee_iterator_get (_tmp38_);
#line 260 "../../../src/plugins/hybrid-search-plugin.vala"
				entry = (GeeMapEntry*) _tmp39_;
#line 262 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp40_ = entry;
#line 262 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp41_ = gee_map_entry_get_value (_tmp40_);
#line 262 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp42_ = _tmp41_;
#line 262 "../../../src/plugins/hybrid-search-plugin.vala"
				if (((gint) ((gintptr) _tmp42_)) > min_hit) {
#line 2193 "hybrid-search-plugin.c"
					GeeArrayList* _tmp43_;
					GeeMapEntry* _tmp44_;
#line 262 "../../../src/plugins/hybrid-search-plugin.vala"
					_tmp43_ = sort_array;
#line 262 "../../../src/plugins/hybrid-search-plugin.vala"
					_tmp44_ = entry;
#line 262 "../../../src/plugins/hybrid-search-plugin.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp43_, _tmp44_);
#line 2202 "hybrid-search-plugin.c"
				}
#line 260 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (entry);
#line 2206 "hybrid-search-plugin.c"
			}
#line 260 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_object_unref0 (_entry_it);
#line 2210 "hybrid-search-plugin.c"
		}
#line 264 "../../../src/plugins/hybrid-search-plugin.vala"
		_tmp45_ = sort_array;
#line 264 "../../../src/plugins/hybrid-search-plugin.vala"
		gee_list_sort ((GeeList*) _tmp45_, ____lambda10__gcompare_data_func, g_object_ref (self), g_object_unref);
#line 270 "../../../src/plugins/hybrid-search-plugin.vala"
		count = 0;
#line 2218 "hybrid-search-plugin.c"
		{
			GeeArrayList* _entry_list = NULL;
			GeeArrayList* _tmp46_;
			GeeArrayList* _tmp47_;
			gint _entry_size = 0;
			GeeArrayList* _tmp48_;
			gint _tmp49_;
			gint _tmp50_;
			gint _entry_index = 0;
#line 271 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp46_ = sort_array;
#line 271 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp47_ = _g_object_ref0 (_tmp46_);
#line 271 "../../../src/plugins/hybrid-search-plugin.vala"
			_entry_list = _tmp47_;
#line 271 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp48_ = _entry_list;
#line 271 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp49_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp48_);
#line 271 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp50_ = _tmp49_;
#line 271 "../../../src/plugins/hybrid-search-plugin.vala"
			_entry_size = _tmp50_;
#line 271 "../../../src/plugins/hybrid-search-plugin.vala"
			_entry_index = -1;
#line 271 "../../../src/plugins/hybrid-search-plugin.vala"
			while (TRUE) {
#line 2246 "hybrid-search-plugin.c"
				gint _tmp51_;
				gint _tmp52_;
				GeeMapEntry* entry = NULL;
				GeeArrayList* _tmp53_;
				gpointer _tmp54_;
				GeeArrayList* _tmp55_;
				GeeMapEntry* _tmp56_;
				gconstpointer _tmp57_;
				gconstpointer _tmp58_;
				gint _tmp59_;
				gint _tmp60_;
#line 271 "../../../src/plugins/hybrid-search-plugin.vala"
				_entry_index = _entry_index + 1;
#line 271 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp51_ = _entry_index;
#line 271 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp52_ = _entry_size;
#line 271 "../../../src/plugins/hybrid-search-plugin.vala"
				if (!(_tmp51_ < _tmp52_)) {
#line 271 "../../../src/plugins/hybrid-search-plugin.vala"
					break;
#line 2268 "hybrid-search-plugin.c"
				}
#line 271 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp53_ = _entry_list;
#line 271 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp54_ = gee_abstract_list_get ((GeeAbstractList*) _tmp53_, _entry_index);
#line 271 "../../../src/plugins/hybrid-search-plugin.vala"
				entry = (GeeMapEntry*) _tmp54_;
#line 273 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp55_ = _result_;
#line 273 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp56_ = entry;
#line 273 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp57_ = gee_map_entry_get_key (_tmp56_);
#line 273 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp58_ = _tmp57_;
#line 273 "../../../src/plugins/hybrid-search-plugin.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp55_, (const gchar*) _tmp58_);
#line 274 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp59_ = count;
#line 274 "../../../src/plugins/hybrid-search-plugin.vala"
				count = _tmp59_ + 1;
#line 274 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp60_ = MAX_ITEMS;
#line 274 "../../../src/plugins/hybrid-search-plugin.vala"
				if (_tmp59_ >= (_tmp60_ - 1)) {
#line 274 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (entry);
#line 274 "../../../src/plugins/hybrid-search-plugin.vala"
					break;
#line 2298 "hybrid-search-plugin.c"
				}
#line 271 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (entry);
#line 2302 "hybrid-search-plugin.c"
			}
#line 271 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_object_unref0 (_entry_list);
#line 2306 "hybrid-search-plugin.c"
		}
#line 247 "../../../src/plugins/hybrid-search-plugin.vala"
		_g_object_unref0 (sort_array);
#line 2310 "hybrid-search-plugin.c"
	}
#line 278 "../../../src/plugins/hybrid-search-plugin.vala"
	result = (GeeList*) _result_;
#line 278 "../../../src/plugins/hybrid-search-plugin.vala"
	return result;
#line 2316 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_process_directory_contents (SynapseHybridSearchPlugin* self,
                                                         SynapseHybridSearchPluginDirectoryInfo* di,
                                                         GFile* directory,
                                                         GList* files)
{
#line 283 "../../../src/plugins/hybrid-search-plugin.vala"
	g_return_if_fail (self != NULL);
#line 283 "../../../src/plugins/hybrid-search-plugin.vala"
	g_return_if_fail (di != NULL);
#line 283 "../../../src/plugins/hybrid-search-plugin.vala"
	g_return_if_fail (directory != NULL);
#line 287 "../../../src/plugins/hybrid-search-plugin.vala"
	g_get_current_time (&di->last_update);
#line 2333 "hybrid-search-plugin.c"
	{
		GList* f_collection = NULL;
		GList* f_it = NULL;
#line 288 "../../../src/plugins/hybrid-search-plugin.vala"
		f_collection = files;
#line 288 "../../../src/plugins/hybrid-search-plugin.vala"
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
#line 2341 "hybrid-search-plugin.c"
			GFileInfo* _tmp0_;
			GFileInfo* f = NULL;
#line 288 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp0_ = _g_object_ref0 ((GFileInfo*) f_it->data);
#line 288 "../../../src/plugins/hybrid-search-plugin.vala"
			f = _tmp0_;
#line 2348 "hybrid-search-plugin.c"
			{
				const gchar* name = NULL;
				GFileInfo* _tmp1_;
				const gchar* _tmp2_;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				const gchar* _tmp6_;
				GFile* child = NULL;
				const gchar* _tmp10_;
				GFile* _tmp11_;
				SynapseUtilsFileInfo* file_info = NULL;
				GFile* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				SynapseUtilsFileInfo* _tmp15_;
				SynapseUtilsFileInfo* _tmp16_;
				GeeMap* _tmp17_;
				SynapseUtilsFileInfo* _tmp18_;
				const gchar* _tmp19_;
				SynapseUtilsFileInfo* _tmp20_;
#line 290 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp1_ = f;
#line 290 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp2_ = g_file_info_get_name (_tmp1_);
#line 290 "../../../src/plugins/hybrid-search-plugin.vala"
				name = _tmp2_;
#line 292 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp6_ = name;
#line 292 "../../../src/plugins/hybrid-search-plugin.vala"
				if (g_str_has_suffix (_tmp6_, ".o")) {
#line 292 "../../../src/plugins/hybrid-search-plugin.vala"
					_tmp5_ = TRUE;
#line 2382 "hybrid-search-plugin.c"
				} else {
					const gchar* _tmp7_;
#line 292 "../../../src/plugins/hybrid-search-plugin.vala"
					_tmp7_ = name;
#line 292 "../../../src/plugins/hybrid-search-plugin.vala"
					_tmp5_ = g_str_has_suffix (_tmp7_, ".lo");
#line 2389 "hybrid-search-plugin.c"
				}
#line 292 "../../../src/plugins/hybrid-search-plugin.vala"
				if (_tmp5_) {
#line 292 "../../../src/plugins/hybrid-search-plugin.vala"
					_tmp4_ = TRUE;
#line 2395 "hybrid-search-plugin.c"
				} else {
					const gchar* _tmp8_;
#line 293 "../../../src/plugins/hybrid-search-plugin.vala"
					_tmp8_ = name;
#line 293 "../../../src/plugins/hybrid-search-plugin.vala"
					_tmp4_ = g_str_has_suffix (_tmp8_, ".mo");
#line 2402 "hybrid-search-plugin.c"
				}
#line 292 "../../../src/plugins/hybrid-search-plugin.vala"
				if (_tmp4_) {
#line 292 "../../../src/plugins/hybrid-search-plugin.vala"
					_tmp3_ = TRUE;
#line 2408 "hybrid-search-plugin.c"
				} else {
					const gchar* _tmp9_;
#line 293 "../../../src/plugins/hybrid-search-plugin.vala"
					_tmp9_ = name;
#line 293 "../../../src/plugins/hybrid-search-plugin.vala"
					_tmp3_ = g_str_has_suffix (_tmp9_, ".gmo");
#line 2415 "hybrid-search-plugin.c"
				}
#line 292 "../../../src/plugins/hybrid-search-plugin.vala"
				if (_tmp3_) {
#line 295 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (f);
#line 295 "../../../src/plugins/hybrid-search-plugin.vala"
					continue;
#line 2423 "hybrid-search-plugin.c"
				}
#line 297 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp10_ = name;
#line 297 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp11_ = g_file_get_child (directory, _tmp10_);
#line 297 "../../../src/plugins/hybrid-search-plugin.vala"
				child = _tmp11_;
#line 298 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp12_ = child;
#line 298 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp13_ = g_file_get_uri (_tmp12_);
#line 298 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp14_ = _tmp13_;
#line 298 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp15_ = synapse_utils_file_info_new (_tmp14_, SYNAPSE_TYPE_URI_MATCH);
#line 298 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp16_ = _tmp15_;
#line 298 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_free0 (_tmp14_);
#line 298 "../../../src/plugins/hybrid-search-plugin.vala"
				file_info = _tmp16_;
#line 299 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp17_ = di->files;
#line 299 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp18_ = file_info;
#line 299 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp19_ = _tmp18_->uri;
#line 299 "../../../src/plugins/hybrid-search-plugin.vala"
				_tmp20_ = file_info;
#line 299 "../../../src/plugins/hybrid-search-plugin.vala"
				gee_map_set (_tmp17_, _tmp19_, _tmp20_);
#line 288 "../../../src/plugins/hybrid-search-plugin.vala"
				_synapse_utils_file_info_unref0 (file_info);
#line 288 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (child);
#line 288 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (f);
#line 2461 "hybrid-search-plugin.c"
			}
		}
	}
}

static void
synapse_hybrid_search_plugin_update_directory_contents_data_free (gpointer _data)
{
	SynapseHybridSearchPluginUpdateDirectoryContentsData* _data_;
	_data_ = _data;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->directory);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_synapse_hybrid_search_plugin_directory_info_unref0 (_data_->di);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	g_slice_free (SynapseHybridSearchPluginUpdateDirectoryContentsData, _data_);
#line 2480 "hybrid-search-plugin.c"
}

static gpointer
_synapse_hybrid_search_plugin_directory_info_ref0 (gpointer self)
{
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	return self ? synapse_hybrid_search_plugin_directory_info_ref (self) : NULL;
#line 2488 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_update_directory_contents (SynapseHybridSearchPlugin* self,
                                                        GFile* directory,
                                                        SynapseHybridSearchPluginDirectoryInfo* di,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	SynapseHybridSearchPluginUpdateDirectoryContentsData* _data_;
	SynapseHybridSearchPlugin* _tmp0_;
	GFile* _tmp1_;
	SynapseHybridSearchPluginDirectoryInfo* _tmp2_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_ = g_slice_new0 (SynapseHybridSearchPluginUpdateDirectoryContentsData);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_hybrid_search_plugin_update_directory_contents_data_free);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->self = _tmp0_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp1_ = _g_object_ref0 (directory);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->directory);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->directory = _tmp1_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp2_ = _synapse_hybrid_search_plugin_directory_info_ref0 (di);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_synapse_hybrid_search_plugin_directory_info_unref0 (_data_->di);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->di = _tmp2_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_update_directory_contents_co (_data_);
#line 2526 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_update_directory_contents_finish (SynapseHybridSearchPlugin* self,
                                                               GAsyncResult* _res_,
                                                               GError** error)
{
	SynapseHybridSearchPluginUpdateDirectoryContentsData* _data_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	if (NULL == _data_) {
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		return;
#line 2541 "hybrid-search-plugin.c"
	}
}

static void
synapse_hybrid_search_plugin_update_directory_contents_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_)
{
	SynapseHybridSearchPluginUpdateDirectoryContentsData* _data_;
#line 307 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_ = _user_data_;
#line 307 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_source_object_ = source_object;
#line 307 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_res_ = _res_;
#line 307 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_update_directory_contents_co (_data_);
#line 2559 "hybrid-search-plugin.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 303 "../../../src/plugins/hybrid-search-plugin.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 2567 "hybrid-search-plugin.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 303 "../../../src/plugins/hybrid-search-plugin.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 2575 "hybrid-search-plugin.c"
}

static gboolean
synapse_hybrid_search_plugin_update_directory_contents_co (SynapseHybridSearchPluginUpdateDirectoryContentsData* _data_)
{
#line 303 "../../../src/plugins/hybrid-search-plugin.vala"
	switch (_data_->_state_) {
#line 303 "../../../src/plugins/hybrid-search-plugin.vala"
		case 0:
#line 2585 "hybrid-search-plugin.c"
		goto _state_0;
#line 303 "../../../src/plugins/hybrid-search-plugin.vala"
		case 1:
#line 2589 "hybrid-search-plugin.c"
		goto _state_1;
#line 303 "../../../src/plugins/hybrid-search-plugin.vala"
		case 2:
#line 2593 "hybrid-search-plugin.c"
		goto _state_2;
		default:
#line 303 "../../../src/plugins/hybrid-search-plugin.vala"
		g_assert_not_reached ();
#line 2598 "hybrid-search-plugin.c"
	}
	_state_0:
#line 306 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp0_ = g_file_get_path (_data_->directory);
#line 306 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp1_ = _data_->_tmp0_;
#line 306 "../../../src/plugins/hybrid-search-plugin.vala"
	g_debug ("hybrid-search-plugin.vala:306: Scanning %s", _data_->_tmp1_);
#line 306 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_free0 (_data_->_tmp1_);
#line 307 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_state_ = 1;
#line 307 "../../../src/plugins/hybrid-search-plugin.vala"
	g_file_enumerate_children_async (_data_->directory, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, 0, NULL, synapse_hybrid_search_plugin_update_directory_contents_ready, _data_);
#line 307 "../../../src/plugins/hybrid-search-plugin.vala"
	return FALSE;
#line 2615 "hybrid-search-plugin.c"
	_state_1:
#line 307 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp2_ = g_file_enumerate_children_finish (_data_->directory, _data_->_res_, &_data_->_inner_error0_);
#line 307 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->enumerator = _data_->_tmp2_;
#line 307 "../../../src/plugins/hybrid-search-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 307 "../../../src/plugins/hybrid-search-plugin.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 307 "../../../src/plugins/hybrid-search-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 307 "../../../src/plugins/hybrid-search-plugin.vala"
		return FALSE;
#line 2629 "hybrid-search-plugin.c"
	}
#line 309 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp3_ = _data_->enumerator;
#line 309 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_state_ = 2;
#line 309 "../../../src/plugins/hybrid-search-plugin.vala"
	g_file_enumerator_next_files_async (_data_->_tmp3_, 1024, 0, NULL, synapse_hybrid_search_plugin_update_directory_contents_ready, _data_);
#line 309 "../../../src/plugins/hybrid-search-plugin.vala"
	return FALSE;
#line 2639 "hybrid-search-plugin.c"
	_state_2:
#line 309 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp4_ = g_file_enumerator_next_files_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
#line 309 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->files = _data_->_tmp4_;
#line 309 "../../../src/plugins/hybrid-search-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 309 "../../../src/plugins/hybrid-search-plugin.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 309 "../../../src/plugins/hybrid-search-plugin.vala"
		_g_object_unref0 (_data_->enumerator);
#line 309 "../../../src/plugins/hybrid-search-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 309 "../../../src/plugins/hybrid-search-plugin.vala"
		return FALSE;
#line 2655 "hybrid-search-plugin.c"
	}
#line 311 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp5_ = _data_->di->files;
#line 311 "../../../src/plugins/hybrid-search-plugin.vala"
	gee_map_clear (_data_->_tmp5_);
#line 312 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp6_ = _data_->files;
#line 312 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_process_directory_contents (_data_->self, _data_->di, _data_->directory, _data_->_tmp6_);
#line 303 "../../../src/plugins/hybrid-search-plugin.vala"
	(_data_->files == NULL) ? NULL : (_data_->files = (_g_list_free__g_object_unref0_ (_data_->files), NULL));
#line 303 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->enumerator);
#line 303 "../../../src/plugins/hybrid-search-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 303 "../../../src/plugins/hybrid-search-plugin.vala"
	if (_data_->_state_ != 0) {
#line 303 "../../../src/plugins/hybrid-search-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 303 "../../../src/plugins/hybrid-search-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2677 "hybrid-search-plugin.c"
		}
	}
#line 303 "../../../src/plugins/hybrid-search-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 303 "../../../src/plugins/hybrid-search-plugin.vala"
	return FALSE;
#line 2684 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_process_directories_data_free (gpointer _data)
{
	SynapseHybridSearchPluginProcessDirectoriesData* _data_;
	_data_ = _data;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->directories);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	g_slice_free (SynapseHybridSearchPluginProcessDirectoriesData, _data_);
#line 2698 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_process_directories (SynapseHybridSearchPlugin* self,
                                                  GeeCollection* directories,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	SynapseHybridSearchPluginProcessDirectoriesData* _data_;
	SynapseHybridSearchPlugin* _tmp0_;
	GeeCollection* _tmp1_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_ = g_slice_new0 (SynapseHybridSearchPluginProcessDirectoriesData);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_hybrid_search_plugin_process_directories_data_free);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->self = _tmp0_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp1_ = _g_object_ref0 (directories);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->directories);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->directories = _tmp1_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_process_directories_co (_data_);
#line 2728 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_process_directories_finish (SynapseHybridSearchPlugin* self,
                                                         GAsyncResult* _res_)
{
	SynapseHybridSearchPluginProcessDirectoriesData* _data_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 2738 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_process_directories_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	SynapseHybridSearchPluginProcessDirectoriesData* _data_;
#line 339 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_ = _user_data_;
#line 339 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_source_object_ = source_object;
#line 339 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_res_ = _res_;
#line 339 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_process_directories_co (_data_);
#line 2755 "hybrid-search-plugin.c"
}

static gboolean
synapse_hybrid_search_plugin_process_directories_co (SynapseHybridSearchPluginProcessDirectoriesData* _data_)
{
#line 315 "../../../src/plugins/hybrid-search-plugin.vala"
	switch (_data_->_state_) {
#line 315 "../../../src/plugins/hybrid-search-plugin.vala"
		case 0:
#line 2765 "hybrid-search-plugin.c"
		goto _state_0;
#line 315 "../../../src/plugins/hybrid-search-plugin.vala"
		case 1:
#line 2769 "hybrid-search-plugin.c"
		goto _state_1;
		default:
#line 315 "../../../src/plugins/hybrid-search-plugin.vala"
		g_assert_not_reached ();
#line 2774 "hybrid-search-plugin.c"
	}
	_state_0:
	{
#line 317 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp0_ = gee_iterable_iterator ((GeeIterable*) _data_->directories);
#line 317 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_dir_path_it = _data_->_tmp0_;
#line 317 "../../../src/plugins/hybrid-search-plugin.vala"
		while (TRUE) {
#line 317 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp1_ = _data_->_dir_path_it;
#line 317 "../../../src/plugins/hybrid-search-plugin.vala"
			if (!gee_iterator_next (_data_->_tmp1_)) {
#line 317 "../../../src/plugins/hybrid-search-plugin.vala"
				break;
#line 2790 "hybrid-search-plugin.c"
			}
#line 317 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp2_ = _data_->_dir_path_it;
#line 317 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp3_ = gee_iterator_get (_data_->_tmp2_);
#line 317 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->dir_path = (gchar*) _data_->_tmp3_;
#line 319 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp4_ = _data_->dir_path;
#line 319 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp5_ = g_file_new_for_path (_data_->_tmp4_);
#line 319 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->directory = _data_->_tmp5_;
#line 2804 "hybrid-search-plugin.c"
			{
#line 323 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp6_ = _data_->self->priv->directory_contents;
#line 323 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp7_ = _data_->dir_path;
#line 323 "../../../src/plugins/hybrid-search-plugin.vala"
				if (gee_map_has_key (_data_->_tmp6_, _data_->_tmp7_)) {
#line 325 "../../../src/plugins/hybrid-search-plugin.vala"
					g_get_current_time (&_data_->cur_time);
#line 326 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp8_ = _data_->self->priv->directory_contents;
#line 326 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp9_ = _data_->dir_path;
#line 326 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp10_ = gee_map_get (_data_->_tmp8_, _data_->_tmp9_);
#line 326 "../../../src/plugins/hybrid-search-plugin.vala"
					_synapse_hybrid_search_plugin_directory_info_unref0 (_data_->di);
#line 326 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->di = (SynapseHybridSearchPluginDirectoryInfo*) _data_->_tmp10_;
#line 327 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp11_ = _data_->cur_time;
#line 327 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp12_ = _data_->di;
#line 327 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp13_ = _data_->_tmp12_->last_update;
#line 327 "../../../src/plugins/hybrid-search-plugin.vala"
					if ((_data_->_tmp11_.tv_sec - _data_->_tmp13_.tv_sec) <= ((glong) (5 * 60))) {
#line 330 "../../../src/plugins/hybrid-search-plugin.vala"
						_synapse_hybrid_search_plugin_directory_info_unref0 (_data_->di);
#line 330 "../../../src/plugins/hybrid-search-plugin.vala"
						_g_object_unref0 (_data_->directory);
#line 330 "../../../src/plugins/hybrid-search-plugin.vala"
						_g_free0 (_data_->dir_path);
#line 330 "../../../src/plugins/hybrid-search-plugin.vala"
						continue;
#line 2840 "hybrid-search-plugin.c"
					}
				} else {
#line 335 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp14_ = _data_->dir_path;
#line 335 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp15_ = synapse_hybrid_search_plugin_directory_info_new (_data_->_tmp14_);
#line 335 "../../../src/plugins/hybrid-search-plugin.vala"
					_synapse_hybrid_search_plugin_directory_info_unref0 (_data_->di);
#line 335 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->di = _data_->_tmp15_;
#line 336 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp16_ = _data_->self->priv->directory_contents;
#line 336 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp17_ = _data_->dir_path;
#line 336 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp18_ = _data_->di;
#line 336 "../../../src/plugins/hybrid-search-plugin.vala"
					gee_map_set (_data_->_tmp16_, _data_->_tmp17_, _data_->_tmp18_);
#line 2859 "hybrid-search-plugin.c"
				}
#line 339 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp19_ = _data_->directory;
#line 339 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp20_ = _data_->di;
#line 339 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_state_ = 1;
#line 339 "../../../src/plugins/hybrid-search-plugin.vala"
				synapse_hybrid_search_plugin_update_directory_contents (_data_->self, _data_->_tmp19_, _data_->_tmp20_, synapse_hybrid_search_plugin_process_directories_ready, _data_);
#line 339 "../../../src/plugins/hybrid-search-plugin.vala"
				return FALSE;
#line 2871 "hybrid-search-plugin.c"
				_state_1:
#line 339 "../../../src/plugins/hybrid-search-plugin.vala"
				synapse_hybrid_search_plugin_update_directory_contents_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
#line 339 "../../../src/plugins/hybrid-search-plugin.vala"
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 339 "../../../src/plugins/hybrid-search-plugin.vala"
					_synapse_hybrid_search_plugin_directory_info_unref0 (_data_->di);
#line 2879 "hybrid-search-plugin.c"
					goto __catch0_g_error;
				}
#line 320 "../../../src/plugins/hybrid-search-plugin.vala"
				_synapse_hybrid_search_plugin_directory_info_unref0 (_data_->di);
#line 2884 "hybrid-search-plugin.c"
			}
			goto __finally0;
			__catch0_g_error:
			{
#line 320 "../../../src/plugins/hybrid-search-plugin.vala"
				g_clear_error (&_data_->_inner_error0_);
#line 2891 "hybrid-search-plugin.c"
			}
			__finally0:
#line 320 "../../../src/plugins/hybrid-search-plugin.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 320 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (_data_->directory);
#line 320 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_free0 (_data_->dir_path);
#line 320 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (_data_->_dir_path_it);
#line 320 "../../../src/plugins/hybrid-search-plugin.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 320 "../../../src/plugins/hybrid-search-plugin.vala"
				g_clear_error (&_data_->_inner_error0_);
#line 320 "../../../src/plugins/hybrid-search-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 320 "../../../src/plugins/hybrid-search-plugin.vala"
				return FALSE;
#line 2910 "hybrid-search-plugin.c"
			}
#line 317 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_object_unref0 (_data_->directory);
#line 317 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_free0 (_data_->dir_path);
#line 2916 "hybrid-search-plugin.c"
		}
#line 317 "../../../src/plugins/hybrid-search-plugin.vala"
		_g_object_unref0 (_data_->_dir_path_it);
#line 2920 "hybrid-search-plugin.c"
	}
#line 315 "../../../src/plugins/hybrid-search-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 315 "../../../src/plugins/hybrid-search-plugin.vala"
	if (_data_->_state_ != 0) {
#line 315 "../../../src/plugins/hybrid-search-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 315 "../../../src/plugins/hybrid-search-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2930 "hybrid-search-plugin.c"
		}
	}
#line 315 "../../../src/plugins/hybrid-search-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 315 "../../../src/plugins/hybrid-search-plugin.vala"
	return FALSE;
#line 2937 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_get_extra_results_data_free (gpointer _data)
{
	SynapseHybridSearchPluginGetExtraResultsData* _data_;
	_data_ = _data;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->original_rs);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->dirs);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	g_slice_free (SynapseHybridSearchPluginGetExtraResultsData, _data_);
#line 2957 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_get_extra_results (SynapseHybridSearchPlugin* self,
                                                SynapseQuery* q,
                                                SynapseResultSet* original_rs,
                                                GeeCollection* dirs,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	SynapseHybridSearchPluginGetExtraResultsData* _data_;
	SynapseHybridSearchPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
	SynapseResultSet* _tmp4_;
	GeeCollection* _tmp5_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_ = g_slice_new0 (SynapseHybridSearchPluginGetExtraResultsData);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_hybrid_search_plugin_get_extra_results_data_free);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->self = _tmp0_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp1_ = *q;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp2_ = _tmp1_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->q = _tmp3_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp4_ = _g_object_ref0 (original_rs);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->original_rs);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->original_rs = _tmp4_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp5_ = _g_object_ref0 (dirs);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->dirs);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->dirs = _tmp5_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_get_extra_results_co (_data_);
#line 3009 "hybrid-search-plugin.c"
}

static SynapseResultSet*
synapse_hybrid_search_plugin_get_extra_results_finish (SynapseHybridSearchPlugin* self,
                                                       GAsyncResult* _res_,
                                                       GError** error)
{
	SynapseResultSet* result;
	SynapseHybridSearchPluginGetExtraResultsData* _data_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	if (NULL == _data_) {
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		return NULL;
#line 3025 "hybrid-search-plugin.c"
	}
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	result = _data_->result;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->result = NULL;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	return result;
#line 3033 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_get_extra_results_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	SynapseHybridSearchPluginGetExtraResultsData* _data_;
#line 370 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_ = _user_data_;
#line 370 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_source_object_ = source_object;
#line 370 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_res_ = _res_;
#line 370 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_get_extra_results_co (_data_);
#line 3050 "hybrid-search-plugin.c"
}

static gpointer
_synapse_utils_file_info_ref0 (gpointer self)
{
#line 390 "../../../src/plugins/hybrid-search-plugin.vala"
	return self ? synapse_utils_file_info_ref (self) : NULL;
#line 3058 "hybrid-search-plugin.c"
}

static gboolean
synapse_hybrid_search_plugin_get_extra_results_co (SynapseHybridSearchPluginGetExtraResultsData* _data_)
{
#line 347 "../../../src/plugins/hybrid-search-plugin.vala"
	switch (_data_->_state_) {
#line 347 "../../../src/plugins/hybrid-search-plugin.vala"
		case 0:
#line 3068 "hybrid-search-plugin.c"
		goto _state_0;
#line 347 "../../../src/plugins/hybrid-search-plugin.vala"
		case 1:
#line 3072 "hybrid-search-plugin.c"
		goto _state_1;
#line 347 "../../../src/plugins/hybrid-search-plugin.vala"
		case 2:
#line 3076 "hybrid-search-plugin.c"
		goto _state_2;
#line 347 "../../../src/plugins/hybrid-search-plugin.vala"
		case 3:
#line 3080 "hybrid-search-plugin.c"
		goto _state_3;
#line 347 "../../../src/plugins/hybrid-search-plugin.vala"
		case 4:
#line 3084 "hybrid-search-plugin.c"
		goto _state_4;
		default:
#line 347 "../../../src/plugins/hybrid-search-plugin.vala"
		g_assert_not_reached ();
#line 3089 "hybrid-search-plugin.c"
	}
	_state_0:
#line 352 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->num_results = (guint) 0;
#line 353 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->enough_results = FALSE;
#line 354 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp0_ = synapse_result_set_new ();
#line 354 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->results = _data_->_tmp0_;
#line 358 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->flags = G_REGEX_OPTIMIZE | G_REGEX_CASELESS;
#line 359 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp1_ = _data_->q;
#line 359 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp2_ = _data_->_tmp1_.query_string;
#line 359 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp3_ = _data_->flags;
#line 359 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp4_ = synapse_query_get_matchers_for_query (_data_->_tmp2_, SYNAPSE_MATCHER_FLAGS_NO_FUZZY | SYNAPSE_MATCHER_FLAGS_NO_PARTIAL, _data_->_tmp3_);
#line 359 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->matchers = _data_->_tmp4_;
#line 362 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp6_ = _g_object_ref0 (_data_->dirs);
#line 362 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp5_ = _data_->_tmp6_;
#line 362 "../../../src/plugins/hybrid-search-plugin.vala"
	if (_data_->_tmp5_ == NULL) {
#line 362 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp7_ = _data_->self->priv->directory_contents;
#line 362 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp8_ = gee_map_get_keys (_data_->_tmp7_);
#line 362 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp9_ = _data_->_tmp8_;
#line 362 "../../../src/plugins/hybrid-search-plugin.vala"
		_g_object_unref0 (_data_->_tmp5_);
#line 362 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp5_ = (GeeCollection*) _data_->_tmp9_;
#line 3128 "hybrid-search-plugin.c"
	}
#line 362 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp10_ = _data_->_tmp5_;
#line 362 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp5_ = NULL;
#line 362 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->directories = _data_->_tmp10_;
#line 3136 "hybrid-search-plugin.c"
	{
#line 363 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp11_ = _data_->directories;
#line 363 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp12_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp11_);
#line 363 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_directory_it = _data_->_tmp12_;
#line 363 "../../../src/plugins/hybrid-search-plugin.vala"
		while (TRUE) {
#line 363 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp13_ = _data_->_directory_it;
#line 363 "../../../src/plugins/hybrid-search-plugin.vala"
			if (!gee_iterator_next (_data_->_tmp13_)) {
#line 363 "../../../src/plugins/hybrid-search-plugin.vala"
				break;
#line 3152 "hybrid-search-plugin.c"
			}
#line 363 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp14_ = _data_->_directory_it;
#line 363 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp15_ = gee_iterator_get (_data_->_tmp14_);
#line 363 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->directory = (gchar*) _data_->_tmp15_;
#line 365 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp16_ = _data_->self->priv->directory_contents;
#line 365 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp17_ = _data_->directory;
#line 365 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp18_ = gee_map_get (_data_->_tmp16_, _data_->_tmp17_);
#line 365 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->di = (SynapseHybridSearchPluginDirectoryInfo*) _data_->_tmp18_;
#line 367 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp19_ = _data_->directory;
#line 367 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp20_ = g_file_new_for_path (_data_->_tmp19_);
#line 367 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->dir = _data_->_tmp20_;
#line 3174 "hybrid-search-plugin.c"
			{
#line 370 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp21_ = _data_->dir;
#line 370 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_state_ = 1;
#line 370 "../../../src/plugins/hybrid-search-plugin.vala"
				g_file_query_info_async (_data_->_tmp21_, "time::*", 0, 0, NULL, synapse_hybrid_search_plugin_get_extra_results_ready, _data_);
#line 370 "../../../src/plugins/hybrid-search-plugin.vala"
				return FALSE;
#line 3184 "hybrid-search-plugin.c"
				_state_1:
#line 370 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp22_ = g_file_query_info_finish (_data_->_tmp21_, _data_->_res_, &_data_->_inner_error0_);
#line 370 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->dir_info = _data_->_tmp22_;
#line 370 "../../../src/plugins/hybrid-search-plugin.vala"
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 3192 "hybrid-search-plugin.c"
					goto __catch0_g_error;
				}
#line 371 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp23_ = _data_->dir_info;
#line 371 "../../../src/plugins/hybrid-search-plugin.vala"
				memset (&_data_->_tmp24_, 0, sizeof (GTimeVal));
#line 371 "../../../src/plugins/hybrid-search-plugin.vala"
				g_file_info_get_modification_time (_data_->_tmp23_, &_data_->_tmp24_);
#line 371 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->t = _data_->_tmp24_;
#line 372 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp25_ = _data_->t;
#line 372 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp26_ = _data_->di;
#line 372 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp27_ = _data_->_tmp26_->last_update;
#line 372 "../../../src/plugins/hybrid-search-plugin.vala"
				if (_data_->_tmp25_.tv_sec > _data_->_tmp27_.tv_sec) {
#line 375 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp28_ = _data_->dir;
#line 375 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp29_ = _data_->di;
#line 375 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_state_ = 2;
#line 375 "../../../src/plugins/hybrid-search-plugin.vala"
					synapse_hybrid_search_plugin_update_directory_contents (_data_->self, _data_->_tmp28_, _data_->_tmp29_, synapse_hybrid_search_plugin_get_extra_results_ready, _data_);
#line 375 "../../../src/plugins/hybrid-search-plugin.vala"
					return FALSE;
#line 3221 "hybrid-search-plugin.c"
					_state_2:
#line 375 "../../../src/plugins/hybrid-search-plugin.vala"
					synapse_hybrid_search_plugin_update_directory_contents_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
#line 375 "../../../src/plugins/hybrid-search-plugin.vala"
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 375 "../../../src/plugins/hybrid-search-plugin.vala"
						_g_object_unref0 (_data_->dir_info);
#line 3229 "hybrid-search-plugin.c"
						goto __catch0_g_error;
					}
				}
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (_data_->dir_info);
#line 3235 "hybrid-search-plugin.c"
			}
			goto __finally0;
			__catch0_g_error:
			{
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->err = _data_->_inner_error0_;
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_inner_error0_ = NULL;
#line 380 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp30_ = _data_->err;
#line 380 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp31_ = _data_->_tmp30_->message;
#line 380 "../../../src/plugins/hybrid-search-plugin.vala"
				g_warning ("hybrid-search-plugin.vala:380: %s", _data_->_tmp31_);
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_error_free0 (_data_->err);
#line 3252 "hybrid-search-plugin.c"
			}
			__finally0:
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
				if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->dir);
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
					_synapse_hybrid_search_plugin_directory_info_unref0 (_data_->di);
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_free0 (_data_->directory);
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->_directory_it);
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->directories);
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->_tmp5_);
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->matchers);
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->results);
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
					g_object_unref (_data_->_async_result);
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
					return FALSE;
#line 3281 "hybrid-search-plugin.c"
				} else {
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->dir);
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
					_synapse_hybrid_search_plugin_directory_info_unref0 (_data_->di);
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_free0 (_data_->directory);
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->_directory_it);
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->directories);
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->_tmp5_);
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->matchers);
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->results);
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
					g_clear_error (&_data_->_inner_error0_);
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
					g_object_unref (_data_->_async_result);
#line 368 "../../../src/plugins/hybrid-search-plugin.vala"
					return FALSE;
#line 3307 "hybrid-search-plugin.c"
				}
			}
#line 383 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp32_ = synapse_relevancy_service_get_default ();
#line 383 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->rel_srv = _data_->_tmp32_;
#line 3314 "hybrid-search-plugin.c"
			{
#line 386 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp33_ = _data_->di;
#line 386 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp34_ = _data_->_tmp33_->files;
#line 386 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp35_ = gee_map_get_entries (_data_->_tmp34_);
#line 386 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp36_ = _data_->_tmp35_;
#line 386 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp37_ = _data_->_tmp36_;
#line 386 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp38_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp37_);
#line 386 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp39_ = _data_->_tmp38_;
#line 386 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (_data_->_tmp37_);
#line 386 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_entry_it = _data_->_tmp39_;
#line 386 "../../../src/plugins/hybrid-search-plugin.vala"
				while (TRUE) {
#line 386 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp40_ = _data_->_entry_it;
#line 386 "../../../src/plugins/hybrid-search-plugin.vala"
					if (!gee_iterator_next (_data_->_tmp40_)) {
#line 386 "../../../src/plugins/hybrid-search-plugin.vala"
						break;
#line 3342 "hybrid-search-plugin.c"
					}
#line 386 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp41_ = _data_->_entry_it;
#line 386 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp42_ = gee_iterator_get (_data_->_tmp41_);
#line 386 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->entry = (GeeMapEntry*) _data_->_tmp42_;
#line 3350 "hybrid-search-plugin.c"
					{
#line 388 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp43_ = _data_->matchers;
#line 388 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp44_ = _g_object_ref0 (_data_->_tmp43_);
#line 388 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_matcher_list = _data_->_tmp44_;
#line 388 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp45_ = _data_->_matcher_list;
#line 388 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp46_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp45_);
#line 388 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_tmp47_ = _data_->_tmp46_;
#line 388 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_matcher_size = _data_->_tmp47_;
#line 388 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->_matcher_index = -1;
#line 388 "../../../src/plugins/hybrid-search-plugin.vala"
						while (TRUE) {
#line 388 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_matcher_index = _data_->_matcher_index + 1;
#line 388 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_tmp48_ = _data_->_matcher_index;
#line 388 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_tmp49_ = _data_->_matcher_size;
#line 388 "../../../src/plugins/hybrid-search-plugin.vala"
							if (!(_data_->_tmp48_ < _data_->_tmp49_)) {
#line 388 "../../../src/plugins/hybrid-search-plugin.vala"
								break;
#line 3380 "hybrid-search-plugin.c"
							}
#line 388 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_tmp50_ = _data_->_matcher_list;
#line 388 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_tmp51_ = gee_list_get (_data_->_tmp50_, _data_->_matcher_index);
#line 388 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->matcher = (GeeMapEntry*) _data_->_tmp51_;
#line 390 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_tmp52_ = _data_->entry;
#line 390 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_tmp53_ = gee_map_entry_get_value (_data_->_tmp52_);
#line 390 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_tmp54_ = _data_->_tmp53_;
#line 390 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_tmp55_ = _synapse_utils_file_info_ref0 ((SynapseUtilsFileInfo*) _data_->_tmp54_);
#line 390 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->fi = _data_->_tmp55_;
#line 391 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_tmp56_ = _data_->matcher;
#line 391 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_tmp57_ = gee_map_entry_get_key (_data_->_tmp56_);
#line 391 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_tmp58_ = _data_->_tmp57_;
#line 391 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_tmp59_ = _data_->fi;
#line 391 "../../../src/plugins/hybrid-search-plugin.vala"
							_data_->_tmp60_ = _data_->_tmp59_->parse_name;
#line 391 "../../../src/plugins/hybrid-search-plugin.vala"
							if (g_regex_match ((GRegex*) _data_->_tmp58_, _data_->_tmp60_, 0, NULL)) {
#line 393 "../../../src/plugins/hybrid-search-plugin.vala"
								if (_data_->original_rs == NULL) {
#line 393 "../../../src/plugins/hybrid-search-plugin.vala"
									_data_->_tmp61_ = TRUE;
#line 3414 "hybrid-search-plugin.c"
								} else {
#line 393 "../../../src/plugins/hybrid-search-plugin.vala"
									_data_->_tmp62_ = _data_->fi;
#line 393 "../../../src/plugins/hybrid-search-plugin.vala"
									_data_->_tmp63_ = _data_->_tmp62_->uri;
#line 393 "../../../src/plugins/hybrid-search-plugin.vala"
									_data_->_tmp61_ = !synapse_result_set_contains_uri (_data_->original_rs, _data_->_tmp63_);
#line 3422 "hybrid-search-plugin.c"
								}
#line 393 "../../../src/plugins/hybrid-search-plugin.vala"
								if (_data_->_tmp61_) {
#line 395 "../../../src/plugins/hybrid-search-plugin.vala"
									_data_->done_io = FALSE;
#line 396 "../../../src/plugins/hybrid-search-plugin.vala"
									_data_->_tmp64_ = _data_->fi;
#line 396 "../../../src/plugins/hybrid-search-plugin.vala"
									if (!synapse_utils_file_info_is_initialized (_data_->_tmp64_)) {
#line 398 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_tmp65_ = _data_->fi;
#line 398 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_state_ = 3;
#line 398 "../../../src/plugins/hybrid-search-plugin.vala"
										synapse_utils_file_info_initialize (_data_->_tmp65_, synapse_hybrid_search_plugin_get_extra_results_ready, _data_);
#line 398 "../../../src/plugins/hybrid-search-plugin.vala"
										return FALSE;
#line 3440 "hybrid-search-plugin.c"
										_state_3:
#line 398 "../../../src/plugins/hybrid-search-plugin.vala"
										synapse_utils_file_info_initialize_finish (_data_->_tmp65_, _data_->_res_);
#line 399 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->done_io = TRUE;
#line 3446 "hybrid-search-plugin.c"
									} else {
#line 401 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_tmp67_ = _data_->fi;
#line 401 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_tmp68_ = _data_->_tmp67_->match_obj;
#line 401 "../../../src/plugins/hybrid-search-plugin.vala"
										if (_data_->_tmp68_ != NULL) {
#line 401 "../../../src/plugins/hybrid-search-plugin.vala"
											_data_->_tmp69_ = _data_->fi;
#line 401 "../../../src/plugins/hybrid-search-plugin.vala"
											_data_->_tmp70_ = _data_->_tmp69_->file_type;
#line 401 "../../../src/plugins/hybrid-search-plugin.vala"
											_data_->_tmp71_ = _data_->q;
#line 401 "../../../src/plugins/hybrid-search-plugin.vala"
											_data_->_tmp72_ = _data_->_tmp71_.query_type;
#line 401 "../../../src/plugins/hybrid-search-plugin.vala"
											_data_->_tmp66_ = (_data_->_tmp72_ & _data_->_tmp70_) == _data_->_tmp70_;
#line 3464 "hybrid-search-plugin.c"
										} else {
#line 401 "../../../src/plugins/hybrid-search-plugin.vala"
											_data_->_tmp66_ = FALSE;
#line 3468 "hybrid-search-plugin.c"
										}
#line 401 "../../../src/plugins/hybrid-search-plugin.vala"
										if (_data_->_tmp66_) {
#line 404 "../../../src/plugins/hybrid-search-plugin.vala"
											_data_->_tmp73_ = _data_->fi;
#line 404 "../../../src/plugins/hybrid-search-plugin.vala"
											_data_->_state_ = 4;
#line 404 "../../../src/plugins/hybrid-search-plugin.vala"
											synapse_utils_file_info_exists (_data_->_tmp73_, synapse_hybrid_search_plugin_get_extra_results_ready, _data_);
#line 404 "../../../src/plugins/hybrid-search-plugin.vala"
											return FALSE;
#line 3480 "hybrid-search-plugin.c"
											_state_4:
#line 404 "../../../src/plugins/hybrid-search-plugin.vala"
											_data_->exists = synapse_utils_file_info_exists_finish (_data_->_tmp73_, _data_->_res_);
#line 405 "../../../src/plugins/hybrid-search-plugin.vala"
											if (!_data_->exists) {
#line 405 "../../../src/plugins/hybrid-search-plugin.vala"
												_synapse_utils_file_info_unref0 (_data_->fi);
#line 405 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_object_unref0 (_data_->matcher);
#line 405 "../../../src/plugins/hybrid-search-plugin.vala"
												break;
#line 3492 "hybrid-search-plugin.c"
											}
#line 406 "../../../src/plugins/hybrid-search-plugin.vala"
											_data_->done_io = TRUE;
#line 3496 "hybrid-search-plugin.c"
										}
									}
#line 409 "../../../src/plugins/hybrid-search-plugin.vala"
									_data_->_tmp75_ = _data_->fi;
#line 409 "../../../src/plugins/hybrid-search-plugin.vala"
									_data_->_tmp76_ = _data_->_tmp75_->match_obj;
#line 409 "../../../src/plugins/hybrid-search-plugin.vala"
									if (_data_->_tmp76_ != NULL) {
#line 409 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_tmp77_ = _data_->fi;
#line 409 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_tmp78_ = _data_->_tmp77_->file_type;
#line 409 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_tmp79_ = _data_->q;
#line 409 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_tmp80_ = _data_->_tmp79_.query_type;
#line 409 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_tmp74_ = (_data_->_tmp80_ & _data_->_tmp78_) == _data_->_tmp78_;
#line 3515 "hybrid-search-plugin.c"
									} else {
#line 409 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_tmp74_ = FALSE;
#line 3519 "hybrid-search-plugin.c"
									}
#line 409 "../../../src/plugins/hybrid-search-plugin.vala"
									if (_data_->_tmp74_) {
#line 412 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->base_relevancy = (gint) (SYNAPSE_MATCH_SCORE_POOR + SYNAPSE_MATCH_SCORE_INCREMENT_MINOR);
#line 413 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_tmp81_ = _data_->matcher;
#line 413 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_tmp82_ = gee_map_entry_get_key (_data_->_tmp81_);
#line 413 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_tmp83_ = _data_->_tmp82_;
#line 413 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_tmp84_ = _data_->fi;
#line 413 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_tmp85_ = _data_->_tmp84_->match_obj;
#line 413 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_tmp86_ = synapse_match_get_title ((SynapseMatch*) _data_->_tmp85_);
#line 413 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_tmp87_ = _data_->_tmp86_;
#line 413 "../../../src/plugins/hybrid-search-plugin.vala"
										if (g_regex_match ((GRegex*) _data_->_tmp83_, _data_->_tmp87_, 0, NULL)) {
#line 416 "../../../src/plugins/hybrid-search-plugin.vala"
											_data_->_tmp88_ = _data_->matcher;
#line 416 "../../../src/plugins/hybrid-search-plugin.vala"
											_data_->_tmp89_ = gee_map_entry_get_value (_data_->_tmp88_);
#line 416 "../../../src/plugins/hybrid-search-plugin.vala"
											_data_->_tmp90_ = _data_->_tmp89_;
#line 416 "../../../src/plugins/hybrid-search-plugin.vala"
											_data_->base_relevancy = ((gint) ((gintptr) _data_->_tmp90_)) - SYNAPSE_MATCH_SCORE_URI_PENALTY;
#line 3549 "hybrid-search-plugin.c"
										}
#line 418 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_tmp91_ = _data_->rel_srv;
#line 418 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_tmp92_ = _data_->fi;
#line 418 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_tmp93_ = _data_->_tmp92_->uri;
#line 418 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->pop = synapse_relevancy_service_get_uri_popularity (_data_->_tmp91_, _data_->_tmp93_);
#line 419 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_tmp94_ = _data_->results;
#line 419 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_tmp95_ = _data_->fi;
#line 419 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_tmp96_ = _data_->_tmp95_->match_obj;
#line 419 "../../../src/plugins/hybrid-search-plugin.vala"
										synapse_result_set_add (_data_->_tmp94_, (SynapseMatch*) _data_->_tmp96_, synapse_relevancy_service_compute_relevancy (_data_->base_relevancy, _data_->pop));
#line 421 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->_tmp97_ = _data_->num_results;
#line 421 "../../../src/plugins/hybrid-search-plugin.vala"
										_data_->num_results = _data_->_tmp97_ + 1;
#line 3571 "hybrid-search-plugin.c"
									}
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
									if (_data_->done_io) {
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
										synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
										if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
											if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_synapse_utils_file_info_unref0 (_data_->fi);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_object_unref0 (_data_->matcher);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_object_unref0 (_data_->_matcher_list);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_object_unref0 (_data_->entry);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_object_unref0 (_data_->_entry_it);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_object_unref0 (_data_->rel_srv);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_object_unref0 (_data_->dir);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_synapse_hybrid_search_plugin_directory_info_unref0 (_data_->di);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_free0 (_data_->directory);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_object_unref0 (_data_->_directory_it);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_object_unref0 (_data_->directories);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_object_unref0 (_data_->_tmp5_);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_object_unref0 (_data_->matchers);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_object_unref0 (_data_->results);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												g_object_unref (_data_->_async_result);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												return FALSE;
#line 3615 "hybrid-search-plugin.c"
											} else {
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_synapse_utils_file_info_unref0 (_data_->fi);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_object_unref0 (_data_->matcher);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_object_unref0 (_data_->_matcher_list);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_object_unref0 (_data_->entry);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_object_unref0 (_data_->_entry_it);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_object_unref0 (_data_->rel_srv);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_object_unref0 (_data_->dir);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_synapse_hybrid_search_plugin_directory_info_unref0 (_data_->di);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_free0 (_data_->directory);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_object_unref0 (_data_->_directory_it);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_object_unref0 (_data_->directories);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_object_unref0 (_data_->_tmp5_);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_object_unref0 (_data_->matchers);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												_g_object_unref0 (_data_->results);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												g_clear_error (&_data_->_inner_error0_);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												g_object_unref (_data_->_async_result);
#line 427 "../../../src/plugins/hybrid-search-plugin.vala"
												return FALSE;
#line 3653 "hybrid-search-plugin.c"
											}
										}
									}
								}
#line 429 "../../../src/plugins/hybrid-search-plugin.vala"
								_synapse_utils_file_info_unref0 (_data_->fi);
#line 429 "../../../src/plugins/hybrid-search-plugin.vala"
								_g_object_unref0 (_data_->matcher);
#line 429 "../../../src/plugins/hybrid-search-plugin.vala"
								break;
#line 3664 "hybrid-search-plugin.c"
							}
#line 388 "../../../src/plugins/hybrid-search-plugin.vala"
							_synapse_utils_file_info_unref0 (_data_->fi);
#line 388 "../../../src/plugins/hybrid-search-plugin.vala"
							_g_object_unref0 (_data_->matcher);
#line 3670 "hybrid-search-plugin.c"
						}
#line 388 "../../../src/plugins/hybrid-search-plugin.vala"
						_g_object_unref0 (_data_->_matcher_list);
#line 3674 "hybrid-search-plugin.c"
					}
#line 432 "../../../src/plugins/hybrid-search-plugin.vala"
					_data_->_tmp98_ = _data_->q;
#line 432 "../../../src/plugins/hybrid-search-plugin.vala"
					if (_data_->num_results >= _data_->_tmp98_.max_results) {
#line 434 "../../../src/plugins/hybrid-search-plugin.vala"
						_data_->enough_results = TRUE;
#line 435 "../../../src/plugins/hybrid-search-plugin.vala"
						_g_object_unref0 (_data_->entry);
#line 435 "../../../src/plugins/hybrid-search-plugin.vala"
						break;
#line 3686 "hybrid-search-plugin.c"
					}
#line 386 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->entry);
#line 3690 "hybrid-search-plugin.c"
				}
#line 386 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (_data_->_entry_it);
#line 3694 "hybrid-search-plugin.c"
			}
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
			synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
				if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->rel_srv);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->dir);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					_synapse_hybrid_search_plugin_directory_info_unref0 (_data_->di);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_free0 (_data_->directory);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->_directory_it);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->directories);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->_tmp5_);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->matchers);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->results);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					g_object_unref (_data_->_async_result);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					return FALSE;
#line 3726 "hybrid-search-plugin.c"
				} else {
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->rel_srv);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->dir);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					_synapse_hybrid_search_plugin_directory_info_unref0 (_data_->di);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_free0 (_data_->directory);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->_directory_it);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->directories);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->_tmp5_);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->matchers);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->results);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					g_clear_error (&_data_->_inner_error0_);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					g_object_unref (_data_->_async_result);
#line 439 "../../../src/plugins/hybrid-search-plugin.vala"
					return FALSE;
#line 3754 "hybrid-search-plugin.c"
				}
			}
#line 440 "../../../src/plugins/hybrid-search-plugin.vala"
			if (_data_->enough_results) {
#line 440 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (_data_->rel_srv);
#line 440 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (_data_->dir);
#line 440 "../../../src/plugins/hybrid-search-plugin.vala"
				_synapse_hybrid_search_plugin_directory_info_unref0 (_data_->di);
#line 440 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_free0 (_data_->directory);
#line 440 "../../../src/plugins/hybrid-search-plugin.vala"
				break;
#line 3769 "hybrid-search-plugin.c"
			}
#line 363 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_object_unref0 (_data_->rel_srv);
#line 363 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_object_unref0 (_data_->dir);
#line 363 "../../../src/plugins/hybrid-search-plugin.vala"
			_synapse_hybrid_search_plugin_directory_info_unref0 (_data_->di);
#line 363 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_free0 (_data_->directory);
#line 3779 "hybrid-search-plugin.c"
		}
#line 363 "../../../src/plugins/hybrid-search-plugin.vala"
		_g_object_unref0 (_data_->_directory_it);
#line 3783 "hybrid-search-plugin.c"
	}
#line 443 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp99_ = _data_->directories;
#line 443 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp100_ = gee_collection_get_size (_data_->_tmp99_);
#line 443 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp101_ = _data_->_tmp100_;
#line 443 "../../../src/plugins/hybrid-search-plugin.vala"
	if (_data_->_tmp101_ == 0) {
#line 443 "../../../src/plugins/hybrid-search-plugin.vala"
		synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 443 "../../../src/plugins/hybrid-search-plugin.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 443 "../../../src/plugins/hybrid-search-plugin.vala"
			if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 443 "../../../src/plugins/hybrid-search-plugin.vala"
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 443 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (_data_->directories);
#line 443 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (_data_->_tmp5_);
#line 443 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (_data_->matchers);
#line 443 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (_data_->results);
#line 443 "../../../src/plugins/hybrid-search-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 443 "../../../src/plugins/hybrid-search-plugin.vala"
				return FALSE;
#line 3813 "hybrid-search-plugin.c"
			} else {
#line 443 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (_data_->directories);
#line 443 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (_data_->_tmp5_);
#line 443 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (_data_->matchers);
#line 443 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (_data_->results);
#line 443 "../../../src/plugins/hybrid-search-plugin.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 443 "../../../src/plugins/hybrid-search-plugin.vala"
				g_clear_error (&_data_->_inner_error0_);
#line 443 "../../../src/plugins/hybrid-search-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 443 "../../../src/plugins/hybrid-search-plugin.vala"
				return FALSE;
#line 3831 "hybrid-search-plugin.c"
			}
		}
	}
#line 446 "../../../src/plugins/hybrid-search-plugin.vala"
	if (_data_->original_rs == NULL) {
#line 446 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp102_ = 0;
#line 3839 "hybrid-search-plugin.c"
	} else {
#line 446 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp103_ = synapse_result_set_get_size (_data_->original_rs);
#line 446 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp104_ = _data_->_tmp103_;
#line 446 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp102_ = _data_->_tmp104_;
#line 3847 "hybrid-search-plugin.c"
	}
#line 445 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp105_ = _data_->results;
#line 445 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp106_ = synapse_result_set_get_size (_data_->_tmp105_);
#line 445 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp107_ = _data_->_tmp106_;
#line 445 "../../../src/plugins/hybrid-search-plugin.vala"
	g_debug ("hybrid-search-plugin.vala:445: found %d extra uris (ZG returned %d)", _data_->_tmp107_, _data_->_tmp102_);
#line 448 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->result = _data_->results;
#line 448 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->directories);
#line 448 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->_tmp5_);
#line 448 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->matchers);
#line 448 "../../../src/plugins/hybrid-search-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 448 "../../../src/plugins/hybrid-search-plugin.vala"
	if (_data_->_state_ != 0) {
#line 448 "../../../src/plugins/hybrid-search-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 448 "../../../src/plugins/hybrid-search-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3873 "hybrid-search-plugin.c"
		}
	}
#line 448 "../../../src/plugins/hybrid-search-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 448 "../../../src/plugins/hybrid-search-plugin.vala"
	return FALSE;
#line 3880 "hybrid-search-plugin.c"
}

static gboolean
synapse_hybrid_search_plugin_real_handles_query (SynapseItemProvider* base,
                                                 SynapseQuery* query)
{
	SynapseHybridSearchPlugin * self;
	SynapseQueryFlags our_results = 0U;
	SynapseQueryFlags common_flags = 0U;
	SynapseQuery _tmp0_;
	SynapseQueryFlags _tmp1_;
	gboolean result = FALSE;
#line 453 "../../../src/plugins/hybrid-search-plugin.vala"
	self = (SynapseHybridSearchPlugin*) base;
#line 453 "../../../src/plugins/hybrid-search-plugin.vala"
	g_return_val_if_fail (query != NULL, FALSE);
#line 456 "../../../src/plugins/hybrid-search-plugin.vala"
	our_results = (((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES) | SYNAPSE_QUERY_FLAGS_UNCATEGORIZED) | SYNAPSE_QUERY_FLAGS_VIDEO;
#line 459 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp0_ = *query;
#line 459 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp1_ = _tmp0_.query_type;
#line 459 "../../../src/plugins/hybrid-search-plugin.vala"
	common_flags = _tmp1_ & our_results;
#line 461 "../../../src/plugins/hybrid-search-plugin.vala"
	result = common_flags != 0;
#line 461 "../../../src/plugins/hybrid-search-plugin.vala"
	return result;
#line 3909 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_wait_for_processing_finished_data_free (gpointer _data)
{
	SynapseHybridSearchPluginWaitForProcessingFinishedData* _data_;
	_data_ = _data;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	g_slice_free (SynapseHybridSearchPluginWaitForProcessingFinishedData, _data_);
#line 3921 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_wait_for_processing_finished (SynapseHybridSearchPlugin* self,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_)
{
	SynapseHybridSearchPluginWaitForProcessingFinishedData* _data_;
	SynapseHybridSearchPlugin* _tmp0_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_ = g_slice_new0 (SynapseHybridSearchPluginWaitForProcessingFinishedData);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_hybrid_search_plugin_wait_for_processing_finished_data_free);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->self = _tmp0_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_wait_for_processing_finished_co (_data_);
#line 3943 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_wait_for_processing_finished_finish (SynapseHybridSearchPlugin* self,
                                                                  GAsyncResult* _res_)
{
	SynapseHybridSearchPluginWaitForProcessingFinishedData* _data_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3953 "hybrid-search-plugin.c"
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
#line 466 "../../../src/plugins/hybrid-search-plugin.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 466 "../../../src/plugins/hybrid-search-plugin.vala"
	return _data3_;
#line 3963 "hybrid-search-plugin.c"
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 466 "../../../src/plugins/hybrid-search-plugin.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 3973 "hybrid-search-plugin.c"
		SynapseHybridSearchPlugin* self;
#line 466 "../../../src/plugins/hybrid-search-plugin.vala"
		self = _data3_->self;
#line 466 "../../../src/plugins/hybrid-search-plugin.vala"
		_g_object_unref0 (self);
#line 466 "../../../src/plugins/hybrid-search-plugin.vala"
		g_slice_free (Block3Data, _data3_);
#line 3981 "hybrid-search-plugin.c"
	}
}

static void
___lambda11_ (Block3Data* _data3_)
{
	SynapseHybridSearchPlugin* self;
	gboolean _tmp0_;
#line 471 "../../../src/plugins/hybrid-search-plugin.vala"
	self = _data3_->self;
#line 472 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp0_ = self->priv->_processing_query;
#line 472 "../../../src/plugins/hybrid-search-plugin.vala"
	if (_tmp0_) {
#line 472 "../../../src/plugins/hybrid-search-plugin.vala"
		return;
#line 3998 "hybrid-search-plugin.c"
	}
#line 473 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_wait_for_processing_finished_co (_data3_->_async_data_);
#line 4002 "hybrid-search-plugin.c"
}

static void
____lambda11__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
#line 471 "../../../src/plugins/hybrid-search-plugin.vala"
	___lambda11_ (self);
#line 4012 "hybrid-search-plugin.c"
}

static gboolean
synapse_hybrid_search_plugin_wait_for_processing_finished_co (SynapseHybridSearchPluginWaitForProcessingFinishedData* _data_)
{
#line 466 "../../../src/plugins/hybrid-search-plugin.vala"
	switch (_data_->_state_) {
#line 466 "../../../src/plugins/hybrid-search-plugin.vala"
		case 0:
#line 4022 "hybrid-search-plugin.c"
		goto _state_0;
#line 466 "../../../src/plugins/hybrid-search-plugin.vala"
		case 1:
#line 4026 "hybrid-search-plugin.c"
		goto _state_1;
		default:
#line 466 "../../../src/plugins/hybrid-search-plugin.vala"
		g_assert_not_reached ();
#line 4031 "hybrid-search-plugin.c"
	}
	_state_0:
#line 466 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_data3_ = g_slice_new0 (Block3Data);
#line 466 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_data3_->_ref_count_ = 1;
#line 466 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_data3_->self = g_object_ref (_data_->self);
#line 466 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_data3_->_async_data_ = _data_;
#line 468 "../../../src/plugins/hybrid-search-plugin.vala"
	while (TRUE) {
#line 468 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp0_ = _data_->self->priv->_processing_query;
#line 468 "../../../src/plugins/hybrid-search-plugin.vala"
		if (!_data_->_tmp0_) {
#line 468 "../../../src/plugins/hybrid-search-plugin.vala"
			break;
#line 4050 "hybrid-search-plugin.c"
		}
#line 471 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp1_ = g_signal_connect_data ((GObject*) _data_->self, "notify::processing-query", (GCallback) ____lambda11__g_object_notify, block3_data_ref (_data_->_data3_), (GClosureNotify) block3_data_unref, 0);
#line 471 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->sig_id = _data_->_tmp1_;
#line 475 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_state_ = 1;
#line 475 "../../../src/plugins/hybrid-search-plugin.vala"
		return FALSE;
#line 4060 "hybrid-search-plugin.c"
		_state_1:
		;
#line 477 "../../../src/plugins/hybrid-search-plugin.vala"
		g_signal_handler_disconnect (_data_->self, _data_->sig_id);
#line 4065 "hybrid-search-plugin.c"
	}
#line 466 "../../../src/plugins/hybrid-search-plugin.vala"
	block3_data_unref (_data_->_data3_);
#line 466 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_data3_ = NULL;
#line 466 "../../../src/plugins/hybrid-search-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 466 "../../../src/plugins/hybrid-search-plugin.vala"
	if (_data_->_state_ != 0) {
#line 466 "../../../src/plugins/hybrid-search-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 466 "../../../src/plugins/hybrid-search-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4079 "hybrid-search-plugin.c"
		}
	}
#line 466 "../../../src/plugins/hybrid-search-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 466 "../../../src/plugins/hybrid-search-plugin.vala"
	return FALSE;
#line 4086 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_real_search_data_free (gpointer _data)
{
	SynapseHybridSearchPluginSearchData* _data_;
	_data_ = _data;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	g_slice_free (SynapseHybridSearchPluginSearchData, _data_);
#line 4102 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_real_search (SynapseItemProvider* base,
                                          SynapseQuery* q,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	SynapseHybridSearchPlugin * self;
	SynapseHybridSearchPluginSearchData* _data_;
	SynapseHybridSearchPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	self = (SynapseHybridSearchPlugin*) base;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_ = g_slice_new0 (SynapseHybridSearchPluginSearchData);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_hybrid_search_plugin_real_search_data_free);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->self = _tmp0_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp1_ = *q;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp2_ = _tmp1_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->q = _tmp3_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_real_search_co (_data_);
#line 4141 "hybrid-search-plugin.c"
}

static SynapseResultSet*
synapse_hybrid_search_plugin_search_finish (SynapseItemProvider* base,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	SynapseResultSet* result;
	SynapseHybridSearchPluginSearchData* _data_;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	if (NULL == _data_) {
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		return NULL;
#line 4157 "hybrid-search-plugin.c"
	}
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	result = _data_->result;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->result = NULL;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	return result;
#line 4165 "hybrid-search-plugin.c"
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
#line 481 "../../../src/plugins/hybrid-search-plugin.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 481 "../../../src/plugins/hybrid-search-plugin.vala"
	return _data4_;
#line 4175 "hybrid-search-plugin.c"
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 481 "../../../src/plugins/hybrid-search-plugin.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 4185 "hybrid-search-plugin.c"
		SynapseHybridSearchPlugin* self;
#line 481 "../../../src/plugins/hybrid-search-plugin.vala"
		self = _data4_->self;
#line 481 "../../../src/plugins/hybrid-search-plugin.vala"
		_g_object_unref0 (_data4_->uris);
#line 481 "../../../src/plugins/hybrid-search-plugin.vala"
		_g_object_unref0 (_data4_->original_rs);
#line 481 "../../../src/plugins/hybrid-search-plugin.vala"
		_g_object_unref0 (self);
#line 481 "../../../src/plugins/hybrid-search-plugin.vala"
		g_slice_free (Block4Data, _data4_);
#line 4197 "hybrid-search-plugin.c"
	}
}

static void
__lambda12_ (Block4Data* _data4_,
             SynapseResultSet* rs,
             guint q_id)
{
	SynapseHybridSearchPlugin* self;
	SynapseResultSet* _tmp13_;
#line 501 "../../../src/plugins/hybrid-search-plugin.vala"
	self = _data4_->self;
#line 502 "../../../src/plugins/hybrid-search-plugin.vala"
	if (q_id != _data4_->query_id) {
#line 502 "../../../src/plugins/hybrid-search-plugin.vala"
		return;
#line 4214 "hybrid-search-plugin.c"
	}
	{
		GeeIterator* _match_it = NULL;
		GeeIterator* _tmp0_;
#line 504 "../../../src/plugins/hybrid-search-plugin.vala"
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) rs);
#line 504 "../../../src/plugins/hybrid-search-plugin.vala"
		_match_it = _tmp0_;
#line 504 "../../../src/plugins/hybrid-search-plugin.vala"
		while (TRUE) {
#line 4225 "hybrid-search-plugin.c"
			GeeIterator* _tmp1_;
			GeeMapEntry* match = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			SynapseUriMatch* uri_match = NULL;
			GeeMapEntry* _tmp4_;
			gconstpointer _tmp5_;
			gconstpointer _tmp6_;
			SynapseMatch* _tmp7_;
			SynapseUriMatch* _tmp8_;
			GeeSet* _tmp9_;
			SynapseUriMatch* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
#line 504 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp1_ = _match_it;
#line 504 "../../../src/plugins/hybrid-search-plugin.vala"
			if (!gee_iterator_next (_tmp1_)) {
#line 504 "../../../src/plugins/hybrid-search-plugin.vala"
				break;
#line 4246 "hybrid-search-plugin.c"
			}
#line 504 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp2_ = _match_it;
#line 504 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp3_ = gee_iterator_get (_tmp2_);
#line 504 "../../../src/plugins/hybrid-search-plugin.vala"
			match = (GeeMapEntry*) _tmp3_;
#line 506 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp4_ = match;
#line 506 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp5_ = gee_map_entry_get_key (_tmp4_);
#line 506 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp6_ = _tmp5_;
#line 506 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp7_ = (SynapseMatch*) _tmp6_;
#line 506 "../../../src/plugins/hybrid-search-plugin.vala"
			uri_match = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, SYNAPSE_TYPE_URI_MATCH) ? ((SynapseUriMatch*) _tmp7_) : NULL;
#line 507 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp8_ = uri_match;
#line 507 "../../../src/plugins/hybrid-search-plugin.vala"
			if (_tmp8_ == NULL) {
#line 507 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (match);
#line 507 "../../../src/plugins/hybrid-search-plugin.vala"
				continue;
#line 4272 "hybrid-search-plugin.c"
			}
#line 508 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp9_ = _data4_->uris;
#line 508 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp10_ = uri_match;
#line 508 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp11_ = synapse_uri_match_get_uri (_tmp10_);
#line 508 "../../../src/plugins/hybrid-search-plugin.vala"
			_tmp12_ = _tmp11_;
#line 508 "../../../src/plugins/hybrid-search-plugin.vala"
			gee_collection_add ((GeeCollection*) _tmp9_, _tmp12_);
#line 504 "../../../src/plugins/hybrid-search-plugin.vala"
			_g_object_unref0 (match);
#line 4286 "hybrid-search-plugin.c"
		}
#line 504 "../../../src/plugins/hybrid-search-plugin.vala"
		_g_object_unref0 (_match_it);
#line 4290 "hybrid-search-plugin.c"
	}
#line 510 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp13_ = _g_object_ref0 (rs);
#line 510 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (_data4_->original_rs);
#line 510 "../../../src/plugins/hybrid-search-plugin.vala"
	_data4_->original_rs = _tmp13_;
#line 511 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_real_search_co (_data4_->_async_data_);
#line 4300 "hybrid-search-plugin.c"
}

static void
___lambda12__synapse_hybrid_search_plugin_zeitgeist_search_complete (SynapseHybridSearchPlugin* _sender,
                                                                     SynapseResultSet* rs,
                                                                     guint query_id,
                                                                     gpointer self)
{
#line 501 "../../../src/plugins/hybrid-search-plugin.vala"
	__lambda12_ (self, rs, query_id);
#line 4311 "hybrid-search-plugin.c"
}

static gboolean
_synapse_hybrid_search_plugin_real_search_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_hybrid_search_plugin_real_search_co (self);
#line 516 "../../../src/plugins/hybrid-search-plugin.vala"
	return result;
#line 4321 "hybrid-search-plugin.c"
}

static void
__lambda13_ (Block4Data* _data4_)
{
	SynapseHybridSearchPlugin* self;
#line 513 "../../../src/plugins/hybrid-search-plugin.vala"
	self = _data4_->self;
#line 515 "../../../src/plugins/hybrid-search-plugin.vala"
	g_signal_handler_block (self, _data4_->sig_id);
#line 516 "../../../src/plugins/hybrid-search-plugin.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _synapse_hybrid_search_plugin_real_search_co_gsource_func, _data4_->_async_data_, NULL);
#line 4334 "hybrid-search-plugin.c"
}

static void
___lambda13__gfunc (gconstpointer data,
                    gpointer self)
{
#line 513 "../../../src/plugins/hybrid-search-plugin.vala"
	__lambda13_ (self);
#line 4343 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_search_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	SynapseHybridSearchPluginSearchData* _data_;
#line 543 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_ = _user_data_;
#line 543 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_source_object_ = source_object;
#line 543 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_res_ = _res_;
#line 543 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_real_search_co (_data_);
#line 4360 "hybrid-search-plugin.c"
}

static gboolean
synapse_hybrid_search_plugin_real_search_co (SynapseHybridSearchPluginSearchData* _data_)
{
#line 481 "../../../src/plugins/hybrid-search-plugin.vala"
	switch (_data_->_state_) {
#line 481 "../../../src/plugins/hybrid-search-plugin.vala"
		case 0:
#line 4370 "hybrid-search-plugin.c"
		goto _state_0;
#line 481 "../../../src/plugins/hybrid-search-plugin.vala"
		case 1:
#line 4374 "hybrid-search-plugin.c"
		goto _state_1;
#line 481 "../../../src/plugins/hybrid-search-plugin.vala"
		case 2:
#line 4378 "hybrid-search-plugin.c"
		goto _state_2;
#line 481 "../../../src/plugins/hybrid-search-plugin.vala"
		case 3:
#line 4382 "hybrid-search-plugin.c"
		goto _state_3;
#line 481 "../../../src/plugins/hybrid-search-plugin.vala"
		case 4:
#line 4386 "hybrid-search-plugin.c"
		goto _state_4;
#line 481 "../../../src/plugins/hybrid-search-plugin.vala"
		case 5:
#line 4390 "hybrid-search-plugin.c"
		goto _state_5;
#line 481 "../../../src/plugins/hybrid-search-plugin.vala"
		case 6:
#line 4394 "hybrid-search-plugin.c"
		goto _state_6;
		default:
#line 481 "../../../src/plugins/hybrid-search-plugin.vala"
		g_assert_not_reached ();
#line 4399 "hybrid-search-plugin.c"
	}
	_state_0:
#line 481 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_data4_ = g_slice_new0 (Block4Data);
#line 481 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_data4_->_ref_count_ = 1;
#line 481 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_data4_->self = g_object_ref (_data_->self);
#line 481 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_data4_->_async_data_ = _data_;
#line 484 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp0_ = _data_->q;
#line 484 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp1_ = _data_->_tmp0_.query_string;
#line 484 "../../../src/plugins/hybrid-search-plugin.vala"
	if (g_utf8_strlen (_data_->_tmp1_, (gssize) -1) <= 1) {
#line 484 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->result = NULL;
#line 484 "../../../src/plugins/hybrid-search-plugin.vala"
		block4_data_unref (_data_->_data4_);
#line 484 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_data4_ = NULL;
#line 484 "../../../src/plugins/hybrid-search-plugin.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 484 "../../../src/plugins/hybrid-search-plugin.vala"
		if (_data_->_state_ != 0) {
#line 484 "../../../src/plugins/hybrid-search-plugin.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 484 "../../../src/plugins/hybrid-search-plugin.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4430 "hybrid-search-plugin.c"
			}
		}
#line 484 "../../../src/plugins/hybrid-search-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 484 "../../../src/plugins/hybrid-search-plugin.vala"
		return FALSE;
#line 4437 "hybrid-search-plugin.c"
	}
#line 487 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp3_ = _data_->self->priv->current_query;
#line 487 "../../../src/plugins/hybrid-search-plugin.vala"
	if (_data_->_tmp3_ != NULL) {
#line 487 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp4_ = _data_->q;
#line 487 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp5_ = _data_->_tmp4_.query_string;
#line 487 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp6_ = _data_->self->priv->current_query;
#line 487 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp2_ = !g_str_has_prefix (_data_->_tmp5_, _data_->_tmp6_);
#line 4451 "hybrid-search-plugin.c"
	} else {
#line 487 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp2_ = FALSE;
#line 4455 "hybrid-search-plugin.c"
	}
#line 487 "../../../src/plugins/hybrid-search-plugin.vala"
	if (_data_->_tmp2_) {
#line 489 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->self->priv->hit_level = 0;
#line 490 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->self->priv->current_level_uris = 0;
#line 491 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp7_ = _data_->self->priv->directory_hits;
#line 491 "../../../src/plugins/hybrid-search-plugin.vala"
		gee_map_clear (_data_->_tmp7_);
#line 4467 "hybrid-search-plugin.c"
	}
#line 494 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp8_ = _data_->q;
#line 494 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_data4_->query_id = _data_->_tmp8_.query_id;
#line 495 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp9_ = _data_->q;
#line 495 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp10_ = _data_->_tmp9_.query_string;
#line 495 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp11_ = g_strdup (_data_->_tmp10_);
#line 495 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_free0 (_data_->self->priv->current_query);
#line 495 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->self->priv->current_query = _data_->_tmp11_;
#line 496 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->last_level_uris = _data_->self->priv->current_level_uris;
#line 497 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_data4_->original_rs = NULL;
#line 498 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp12_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 498 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_data4_->uris = (GeeSet*) _data_->_tmp12_;
#line 501 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp13_ = g_signal_connect_data (_data_->self, "zeitgeist-search-complete", (GCallback) ___lambda12__synapse_hybrid_search_plugin_zeitgeist_search_complete, block4_data_ref (_data_->_data4_), (GClosureNotify) block4_data_unref, 0);
#line 501 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_data4_->sig_id = _data_->_tmp13_;
#line 513 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp14_ = _data_->q;
#line 513 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp15_ = _data_->_tmp14_.cancellable;
#line 513 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->canc_sig_id = g_cancellable_connect (_data_->_tmp15_, (GCallback) ___lambda13__gfunc, block4_data_ref (_data_->_data4_), block4_data_unref);
#line 519 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp16_ = _data_->self->priv->_data_sink;
#line 519 "../../../src/plugins/hybrid-search-plugin.vala"
	if (synapse_data_sink_is_plugin_enabled (_data_->_tmp16_, g_type_from_name ("SynapseZeitgeistPlugin"))) {
#line 522 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_state_ = 1;
#line 522 "../../../src/plugins/hybrid-search-plugin.vala"
		return FALSE;
#line 4509 "hybrid-search-plugin.c"
		_state_1:
		;
	}
#line 525 "../../../src/plugins/hybrid-search-plugin.vala"
	g_signal_handler_disconnect (_data_->self, _data_->_data4_->sig_id);
#line 526 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp17_ = _data_->q;
#line 526 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_tmp18_ = _data_->_tmp17_.cancellable;
#line 526 "../../../src/plugins/hybrid-search-plugin.vala"
	g_cancellable_disconnect (_data_->_tmp18_, _data_->canc_sig_id);
#line 528 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 528 "../../../src/plugins/hybrid-search-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 528 "../../../src/plugins/hybrid-search-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 528 "../../../src/plugins/hybrid-search-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 528 "../../../src/plugins/hybrid-search-plugin.vala"
			block4_data_unref (_data_->_data4_);
#line 528 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_data4_ = NULL;
#line 528 "../../../src/plugins/hybrid-search-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 528 "../../../src/plugins/hybrid-search-plugin.vala"
			return FALSE;
#line 4537 "hybrid-search-plugin.c"
		} else {
#line 528 "../../../src/plugins/hybrid-search-plugin.vala"
			block4_data_unref (_data_->_data4_);
#line 528 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_data4_ = NULL;
#line 528 "../../../src/plugins/hybrid-search-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 528 "../../../src/plugins/hybrid-search-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 528 "../../../src/plugins/hybrid-search-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 528 "../../../src/plugins/hybrid-search-plugin.vala"
			return FALSE;
#line 4551 "hybrid-search-plugin.c"
		}
	}
#line 531 "../../../src/plugins/hybrid-search-plugin.vala"
	while (TRUE) {
#line 531 "../../../src/plugins/hybrid-search-plugin.vala"
		if (!(!_data_->self->priv->initialization_done)) {
#line 531 "../../../src/plugins/hybrid-search-plugin.vala"
			break;
#line 4560 "hybrid-search-plugin.c"
		}
#line 533 "../../../src/plugins/hybrid-search-plugin.vala"
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, _synapse_hybrid_search_plugin_real_search_co_gsource_func, _data_, NULL);
#line 534 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_state_ = 2;
#line 534 "../../../src/plugins/hybrid-search-plugin.vala"
		return FALSE;
#line 4568 "hybrid-search-plugin.c"
		_state_2:
		;
#line 535 "../../../src/plugins/hybrid-search-plugin.vala"
		synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 535 "../../../src/plugins/hybrid-search-plugin.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 535 "../../../src/plugins/hybrid-search-plugin.vala"
			if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 535 "../../../src/plugins/hybrid-search-plugin.vala"
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 535 "../../../src/plugins/hybrid-search-plugin.vala"
				block4_data_unref (_data_->_data4_);
#line 535 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_data4_ = NULL;
#line 535 "../../../src/plugins/hybrid-search-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 535 "../../../src/plugins/hybrid-search-plugin.vala"
				return FALSE;
#line 4587 "hybrid-search-plugin.c"
			} else {
#line 535 "../../../src/plugins/hybrid-search-plugin.vala"
				block4_data_unref (_data_->_data4_);
#line 535 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_data4_ = NULL;
#line 535 "../../../src/plugins/hybrid-search-plugin.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 535 "../../../src/plugins/hybrid-search-plugin.vala"
				g_clear_error (&_data_->_inner_error0_);
#line 535 "../../../src/plugins/hybrid-search-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 535 "../../../src/plugins/hybrid-search-plugin.vala"
				return FALSE;
#line 4601 "hybrid-search-plugin.c"
			}
		}
	}
#line 540 "../../../src/plugins/hybrid-search-plugin.vala"
	while (TRUE) {
#line 540 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp19_ = _data_->self->priv->_processing_query;
#line 540 "../../../src/plugins/hybrid-search-plugin.vala"
		if (!_data_->_tmp19_) {
#line 540 "../../../src/plugins/hybrid-search-plugin.vala"
			break;
#line 4613 "hybrid-search-plugin.c"
		}
#line 543 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_state_ = 3;
#line 543 "../../../src/plugins/hybrid-search-plugin.vala"
		synapse_hybrid_search_plugin_wait_for_processing_finished (_data_->self, synapse_hybrid_search_plugin_search_ready, _data_);
#line 543 "../../../src/plugins/hybrid-search-plugin.vala"
		return FALSE;
#line 4621 "hybrid-search-plugin.c"
		_state_3:
#line 543 "../../../src/plugins/hybrid-search-plugin.vala"
		synapse_hybrid_search_plugin_wait_for_processing_finished_finish (_data_->self, _data_->_res_);
#line 544 "../../../src/plugins/hybrid-search-plugin.vala"
		synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 544 "../../../src/plugins/hybrid-search-plugin.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 544 "../../../src/plugins/hybrid-search-plugin.vala"
			if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 544 "../../../src/plugins/hybrid-search-plugin.vala"
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 544 "../../../src/plugins/hybrid-search-plugin.vala"
				block4_data_unref (_data_->_data4_);
#line 544 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_data4_ = NULL;
#line 544 "../../../src/plugins/hybrid-search-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 544 "../../../src/plugins/hybrid-search-plugin.vala"
				return FALSE;
#line 4641 "hybrid-search-plugin.c"
			} else {
#line 544 "../../../src/plugins/hybrid-search-plugin.vala"
				block4_data_unref (_data_->_data4_);
#line 544 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_data4_ = NULL;
#line 544 "../../../src/plugins/hybrid-search-plugin.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 544 "../../../src/plugins/hybrid-search-plugin.vala"
				g_clear_error (&_data_->_inner_error0_);
#line 544 "../../../src/plugins/hybrid-search-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 544 "../../../src/plugins/hybrid-search-plugin.vala"
				return FALSE;
#line 4655 "hybrid-search-plugin.c"
			}
		}
	}
#line 546 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_set_processing_query (_data_->self, TRUE);
#line 4661 "hybrid-search-plugin.c"
	{
#line 551 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp20_ = _data_->_data4_->uris;
#line 551 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp21_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp20_);
#line 551 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp22_ = _data_->_tmp21_;
#line 551 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->self->priv->current_level_uris = _data_->_tmp22_;
#line 552 "../../../src/plugins/hybrid-search-plugin.vala"
		if (_data_->self->priv->current_level_uris > 0) {
#line 555 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp23_ = _data_->_data4_->uris;
#line 555 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_state_ = 4;
#line 555 "../../../src/plugins/hybrid-search-plugin.vala"
			synapse_hybrid_search_plugin_process_uris (_data_->self, (GeeCollection*) _data_->_tmp23_, synapse_hybrid_search_plugin_search_ready, _data_);
#line 555 "../../../src/plugins/hybrid-search-plugin.vala"
			return FALSE;
#line 4681 "hybrid-search-plugin.c"
			_state_4:
#line 555 "../../../src/plugins/hybrid-search-plugin.vala"
			synapse_hybrid_search_plugin_process_uris_finish (_data_->self, _data_->_res_);
#line 556 "../../../src/plugins/hybrid-search-plugin.vala"
			synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 556 "../../../src/plugins/hybrid-search-plugin.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 4689 "hybrid-search-plugin.c"
				goto __finally0;
			}
		}
#line 558 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp24_ = _data_->self->priv->hit_level;
#line 558 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->self->priv->hit_level = _data_->_tmp24_ + 1;
#line 561 "../../../src/plugins/hybrid-search-plugin.vala"
		if (_data_->self->priv->hit_level > 1) {
#line 561 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp26_ = _data_->q;
#line 561 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp27_ = _data_->_tmp26_.query_string;
#line 561 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp25_ = g_utf8_strlen (_data_->_tmp27_, (gssize) -1) >= 3;
#line 4705 "hybrid-search-plugin.c"
		} else {
#line 561 "../../../src/plugins/hybrid-search-plugin.vala"
			_data_->_tmp25_ = FALSE;
#line 4709 "hybrid-search-plugin.c"
		}
#line 561 "../../../src/plugins/hybrid-search-plugin.vala"
		if (_data_->_tmp25_) {
#line 564 "../../../src/plugins/hybrid-search-plugin.vala"
			if ((_data_->self->priv->current_level_uris * 3) > (2 * _data_->last_level_uris)) {
#line 566 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp28_ = synapse_hybrid_search_plugin_get_most_likely_dirs (_data_->self);
#line 566 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->directories = _data_->_tmp28_;
#line 572 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_tmp29_ = _data_->directories;
#line 572 "../../../src/plugins/hybrid-search-plugin.vala"
				_data_->_state_ = 5;
#line 572 "../../../src/plugins/hybrid-search-plugin.vala"
				synapse_hybrid_search_plugin_process_directories (_data_->self, (GeeCollection*) _data_->_tmp29_, synapse_hybrid_search_plugin_search_ready, _data_);
#line 572 "../../../src/plugins/hybrid-search-plugin.vala"
				return FALSE;
#line 4727 "hybrid-search-plugin.c"
				_state_5:
#line 572 "../../../src/plugins/hybrid-search-plugin.vala"
				synapse_hybrid_search_plugin_process_directories_finish (_data_->self, _data_->_res_);
#line 573 "../../../src/plugins/hybrid-search-plugin.vala"
				synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 573 "../../../src/plugins/hybrid-search-plugin.vala"
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 573 "../../../src/plugins/hybrid-search-plugin.vala"
					_g_object_unref0 (_data_->directories);
#line 4737 "hybrid-search-plugin.c"
					goto __finally0;
				}
#line 564 "../../../src/plugins/hybrid-search-plugin.vala"
				_g_object_unref0 (_data_->directories);
#line 4742 "hybrid-search-plugin.c"
			}
		}
#line 581 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp30_ = _data_->q;
#line 581 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp31_ = _data_->_data4_->original_rs;
#line 581 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_state_ = 6;
#line 581 "../../../src/plugins/hybrid-search-plugin.vala"
		synapse_hybrid_search_plugin_get_extra_results (_data_->self, &_data_->_tmp30_, _data_->_tmp31_, NULL, synapse_hybrid_search_plugin_search_ready, _data_);
#line 581 "../../../src/plugins/hybrid-search-plugin.vala"
		return FALSE;
#line 4755 "hybrid-search-plugin.c"
		_state_6:
#line 581 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_tmp32_ = synapse_hybrid_search_plugin_get_extra_results_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
#line 581 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_result_ = _data_->_tmp32_;
#line 581 "../../../src/plugins/hybrid-search-plugin.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 4763 "hybrid-search-plugin.c"
			goto __finally0;
		}
#line 582 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->result = _data_->_result_;
#line 4768 "hybrid-search-plugin.c"
		{
#line 586 "../../../src/plugins/hybrid-search-plugin.vala"
			synapse_hybrid_search_plugin_set_processing_query (_data_->self, FALSE);
#line 4772 "hybrid-search-plugin.c"
		}
#line 582 "../../../src/plugins/hybrid-search-plugin.vala"
		block4_data_unref (_data_->_data4_);
#line 582 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_data4_ = NULL;
#line 582 "../../../src/plugins/hybrid-search-plugin.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 582 "../../../src/plugins/hybrid-search-plugin.vala"
		if (_data_->_state_ != 0) {
#line 582 "../../../src/plugins/hybrid-search-plugin.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 582 "../../../src/plugins/hybrid-search-plugin.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4786 "hybrid-search-plugin.c"
			}
		}
#line 582 "../../../src/plugins/hybrid-search-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 582 "../../../src/plugins/hybrid-search-plugin.vala"
		return FALSE;
#line 4793 "hybrid-search-plugin.c"
	}
	__finally0:
	{
#line 586 "../../../src/plugins/hybrid-search-plugin.vala"
		synapse_hybrid_search_plugin_set_processing_query (_data_->self, FALSE);
#line 4799 "hybrid-search-plugin.c"
	}
#line 548 "../../../src/plugins/hybrid-search-plugin.vala"
	if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 548 "../../../src/plugins/hybrid-search-plugin.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 548 "../../../src/plugins/hybrid-search-plugin.vala"
		block4_data_unref (_data_->_data4_);
#line 548 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_data4_ = NULL;
#line 548 "../../../src/plugins/hybrid-search-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 548 "../../../src/plugins/hybrid-search-plugin.vala"
		return FALSE;
#line 4813 "hybrid-search-plugin.c"
	} else {
#line 548 "../../../src/plugins/hybrid-search-plugin.vala"
		block4_data_unref (_data_->_data4_);
#line 548 "../../../src/plugins/hybrid-search-plugin.vala"
		_data_->_data4_ = NULL;
#line 548 "../../../src/plugins/hybrid-search-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 548 "../../../src/plugins/hybrid-search-plugin.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 548 "../../../src/plugins/hybrid-search-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 548 "../../../src/plugins/hybrid-search-plugin.vala"
		return FALSE;
#line 4827 "hybrid-search-plugin.c"
	}
#line 481 "../../../src/plugins/hybrid-search-plugin.vala"
	block4_data_unref (_data_->_data4_);
#line 481 "../../../src/plugins/hybrid-search-plugin.vala"
	_data_->_data4_ = NULL;
#line 4833 "hybrid-search-plugin.c"
}

SynapseHybridSearchPlugin*
synapse_hybrid_search_plugin_construct (GType object_type)
{
	SynapseHybridSearchPlugin * self = NULL;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	self = (SynapseHybridSearchPlugin*) g_object_new (object_type, NULL);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	return self;
#line 4844 "hybrid-search-plugin.c"
}

SynapseHybridSearchPlugin*
synapse_hybrid_search_plugin_new (void)
{
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	return synapse_hybrid_search_plugin_construct (SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN);
#line 4852 "hybrid-search-plugin.c"
}

SynapseDataSink*
synapse_hybrid_search_plugin_get_data_sink (SynapseHybridSearchPlugin* self)
{
	SynapseDataSink* result;
	SynapseDataSink* _tmp0_;
#line 31 "../../../src/plugins/hybrid-search-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 31 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp0_ = self->priv->_data_sink;
#line 31 "../../../src/plugins/hybrid-search-plugin.vala"
	result = _tmp0_;
#line 31 "../../../src/plugins/hybrid-search-plugin.vala"
	return result;
#line 4868 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_set_data_sink (SynapseHybridSearchPlugin* self,
                                            SynapseDataSink* value)
{
	SynapseDataSink* old_value;
#line 31 "../../../src/plugins/hybrid-search-plugin.vala"
	g_return_if_fail (self != NULL);
#line 31 "../../../src/plugins/hybrid-search-plugin.vala"
	old_value = synapse_hybrid_search_plugin_get_data_sink (self);
#line 31 "../../../src/plugins/hybrid-search-plugin.vala"
	if (old_value != value) {
#line 31 "../../../src/plugins/hybrid-search-plugin.vala"
		self->priv->_data_sink = value;
#line 31 "../../../src/plugins/hybrid-search-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_hybrid_search_plugin_properties[SYNAPSE_HYBRID_SEARCH_PLUGIN_DATA_SINK_PROPERTY]);
#line 4886 "hybrid-search-plugin.c"
	}
}

static gboolean
synapse_hybrid_search_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseHybridSearchPlugin* self;
#line 32 "../../../src/plugins/hybrid-search-plugin.vala"
	self = (SynapseHybridSearchPlugin*) base;
#line 32 "../../../src/plugins/hybrid-search-plugin.vala"
	result = self->priv->_enabled;
#line 32 "../../../src/plugins/hybrid-search-plugin.vala"
	return result;
#line 4901 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_real_set_enabled (SynapseActivatable* base,
                                               gboolean value)
{
	SynapseHybridSearchPlugin* self;
	gboolean old_value;
#line 32 "../../../src/plugins/hybrid-search-plugin.vala"
	self = (SynapseHybridSearchPlugin*) base;
#line 32 "../../../src/plugins/hybrid-search-plugin.vala"
	old_value = synapse_hybrid_search_plugin_real_get_enabled (base);
#line 32 "../../../src/plugins/hybrid-search-plugin.vala"
	if (old_value != value) {
#line 32 "../../../src/plugins/hybrid-search-plugin.vala"
		self->priv->_enabled = value;
#line 32 "../../../src/plugins/hybrid-search-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_hybrid_search_plugin_properties[SYNAPSE_HYBRID_SEARCH_PLUGIN_ENABLED_PROPERTY]);
#line 4920 "hybrid-search-plugin.c"
	}
}

gboolean
synapse_hybrid_search_plugin_get_processing_query (SynapseHybridSearchPlugin* self)
{
	gboolean result;
#line 464 "../../../src/plugins/hybrid-search-plugin.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 464 "../../../src/plugins/hybrid-search-plugin.vala"
	result = self->priv->_processing_query;
#line 464 "../../../src/plugins/hybrid-search-plugin.vala"
	return result;
#line 4934 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_set_processing_query (SynapseHybridSearchPlugin* self,
                                                   gboolean value)
{
	gboolean old_value;
#line 464 "../../../src/plugins/hybrid-search-plugin.vala"
	g_return_if_fail (self != NULL);
#line 464 "../../../src/plugins/hybrid-search-plugin.vala"
	old_value = synapse_hybrid_search_plugin_get_processing_query (self);
#line 464 "../../../src/plugins/hybrid-search-plugin.vala"
	if (old_value != value) {
#line 464 "../../../src/plugins/hybrid-search-plugin.vala"
		self->priv->_processing_query = value;
#line 464 "../../../src/plugins/hybrid-search-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_hybrid_search_plugin_properties[SYNAPSE_HYBRID_SEARCH_PLUGIN_PROCESSING_QUERY_PROPERTY]);
#line 4952 "hybrid-search-plugin.c"
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_UINT) (gpointer data1, gpointer arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	g_return_if_fail (n_param_values == 3);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		data1 = closure->data;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		data2 = param_values->data[0].v_pointer;
#line 4978 "hybrid-search-plugin.c"
	} else {
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		data1 = param_values->data[0].v_pointer;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		data2 = closure->data;
#line 4984 "hybrid-search-plugin.c"
	}
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	callback = (GMarshalFunc_VOID__OBJECT_UINT) (marshal_data ? marshal_data : cc->callback);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_uint (param_values + 2), data2);
#line 4990 "hybrid-search-plugin.c"
}

static SynapseHybridSearchPluginDirectoryInfo*
synapse_hybrid_search_plugin_directory_info_construct (GType object_type,
                                                       const gchar* path)
{
	SynapseHybridSearchPluginDirectoryInfo* self = NULL;
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
#line 50 "../../../src/plugins/hybrid-search-plugin.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 50 "../../../src/plugins/hybrid-search-plugin.vala"
	self = (SynapseHybridSearchPluginDirectoryInfo*) g_type_create_instance (object_type);
#line 52 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, NULL, NULL, SYNAPSE_UTILS_TYPE_FILE_INFO, (GBoxedCopyFunc) synapse_utils_file_info_ref, (GDestroyNotify) synapse_utils_file_info_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 52 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (self->files);
#line 52 "../../../src/plugins/hybrid-search-plugin.vala"
	self->files = (GeeMap*) _tmp0_;
#line 53 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp1_ = g_strdup (path);
#line 53 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_free0 (self->path);
#line 53 "../../../src/plugins/hybrid-search-plugin.vala"
	self->path = _tmp1_;
#line 50 "../../../src/plugins/hybrid-search-plugin.vala"
	return self;
#line 5018 "hybrid-search-plugin.c"
}

static SynapseHybridSearchPluginDirectoryInfo*
synapse_hybrid_search_plugin_directory_info_new (const gchar* path)
{
#line 50 "../../../src/plugins/hybrid-search-plugin.vala"
	return synapse_hybrid_search_plugin_directory_info_construct (SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO, path);
#line 5026 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_value_directory_info_init (GValue* value)
{
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	value->data[0].v_pointer = NULL;
#line 5034 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_value_directory_info_free_value (GValue* value)
{
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	if (value->data[0].v_pointer) {
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
		synapse_hybrid_search_plugin_directory_info_unref (value->data[0].v_pointer);
#line 5044 "hybrid-search-plugin.c"
	}
}

static void
synapse_hybrid_search_plugin_value_directory_info_copy_value (const GValue* src_value,
                                                              GValue* dest_value)
{
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	if (src_value->data[0].v_pointer) {
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
		dest_value->data[0].v_pointer = synapse_hybrid_search_plugin_directory_info_ref (src_value->data[0].v_pointer);
#line 5056 "hybrid-search-plugin.c"
	} else {
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5060 "hybrid-search-plugin.c"
	}
}

static gpointer
synapse_hybrid_search_plugin_value_directory_info_peek_pointer (const GValue* value)
{
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	return value->data[0].v_pointer;
#line 5069 "hybrid-search-plugin.c"
}

static gchar*
synapse_hybrid_search_plugin_value_directory_info_collect_value (GValue* value,
                                                                 guint n_collect_values,
                                                                 GTypeCValue* collect_values,
                                                                 guint collect_flags)
{
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	if (collect_values[0].v_pointer) {
#line 5080 "hybrid-search-plugin.c"
		SynapseHybridSearchPluginDirectoryInfo * object;
		object = collect_values[0].v_pointer;
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
		if (object->parent_instance.g_class == NULL) {
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5087 "hybrid-search-plugin.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5091 "hybrid-search-plugin.c"
		}
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
		value->data[0].v_pointer = synapse_hybrid_search_plugin_directory_info_ref (object);
#line 5095 "hybrid-search-plugin.c"
	} else {
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
		value->data[0].v_pointer = NULL;
#line 5099 "hybrid-search-plugin.c"
	}
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	return NULL;
#line 5103 "hybrid-search-plugin.c"
}

static gchar*
synapse_hybrid_search_plugin_value_directory_info_lcopy_value (const GValue* value,
                                                               guint n_collect_values,
                                                               GTypeCValue* collect_values,
                                                               guint collect_flags)
{
	SynapseHybridSearchPluginDirectoryInfo ** object_p;
	object_p = collect_values[0].v_pointer;
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	if (!object_p) {
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5118 "hybrid-search-plugin.c"
	}
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	if (!value->data[0].v_pointer) {
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
		*object_p = NULL;
#line 5124 "hybrid-search-plugin.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
		*object_p = value->data[0].v_pointer;
#line 5128 "hybrid-search-plugin.c"
	} else {
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
		*object_p = synapse_hybrid_search_plugin_directory_info_ref (value->data[0].v_pointer);
#line 5132 "hybrid-search-plugin.c"
	}
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	return NULL;
#line 5136 "hybrid-search-plugin.c"
}

static GParamSpec*
synapse_hybrid_search_plugin_param_spec_directory_info (const gchar* name,
                                                        const gchar* nick,
                                                        const gchar* blurb,
                                                        GType object_type,
                                                        GParamFlags flags)
{
	SynapseHybridSearchPluginParamSpecDirectoryInfo* spec;
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO), NULL);
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	return G_PARAM_SPEC (spec);
#line 5155 "hybrid-search-plugin.c"
}

static gpointer
synapse_hybrid_search_plugin_value_get_directory_info (const GValue* value)
{
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO), NULL);
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	return value->data[0].v_pointer;
#line 5165 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_value_set_directory_info (GValue* value,
                                                       gpointer v_object)
{
	SynapseHybridSearchPluginDirectoryInfo * old;
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO));
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	old = value->data[0].v_pointer;
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	if (v_object) {
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO));
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
		value->data[0].v_pointer = v_object;
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
		synapse_hybrid_search_plugin_directory_info_ref (value->data[0].v_pointer);
#line 5187 "hybrid-search-plugin.c"
	} else {
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
		value->data[0].v_pointer = NULL;
#line 5191 "hybrid-search-plugin.c"
	}
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	if (old) {
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
		synapse_hybrid_search_plugin_directory_info_unref (old);
#line 5197 "hybrid-search-plugin.c"
	}
}

static void
synapse_hybrid_search_plugin_value_take_directory_info (GValue* value,
                                                        gpointer v_object)
{
	SynapseHybridSearchPluginDirectoryInfo * old;
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO));
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	old = value->data[0].v_pointer;
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	if (v_object) {
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO));
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
		value->data[0].v_pointer = v_object;
#line 5218 "hybrid-search-plugin.c"
	} else {
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
		value->data[0].v_pointer = NULL;
#line 5222 "hybrid-search-plugin.c"
	}
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	if (old) {
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
		synapse_hybrid_search_plugin_directory_info_unref (old);
#line 5228 "hybrid-search-plugin.c"
	}
}

static void
synapse_hybrid_search_plugin_directory_info_class_init (SynapseHybridSearchPluginDirectoryInfoClass * klass,
                                                        gpointer klass_data)
{
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_directory_info_parent_class = g_type_class_peek_parent (klass);
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	((SynapseHybridSearchPluginDirectoryInfoClass *) klass)->finalize = synapse_hybrid_search_plugin_directory_info_finalize;
#line 5240 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_directory_info_instance_init (SynapseHybridSearchPluginDirectoryInfo * self,
                                                           gpointer klass)
{
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	self->ref_count = 1;
#line 5249 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_directory_info_finalize (SynapseHybridSearchPluginDirectoryInfo * obj)
{
	SynapseHybridSearchPluginDirectoryInfo * self;
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO, SynapseHybridSearchPluginDirectoryInfo);
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	g_signal_handlers_destroy (self);
#line 46 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_free0 (self->path);
#line 48 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (self->files);
#line 5264 "hybrid-search-plugin.c"
}

static GType
synapse_hybrid_search_plugin_directory_info_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { synapse_hybrid_search_plugin_value_directory_info_init, synapse_hybrid_search_plugin_value_directory_info_free_value, synapse_hybrid_search_plugin_value_directory_info_copy_value, synapse_hybrid_search_plugin_value_directory_info_peek_pointer, "p", synapse_hybrid_search_plugin_value_directory_info_collect_value, "p", synapse_hybrid_search_plugin_value_directory_info_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SynapseHybridSearchPluginDirectoryInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_hybrid_search_plugin_directory_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseHybridSearchPluginDirectoryInfo), 0, (GInstanceInitFunc) synapse_hybrid_search_plugin_directory_info_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType synapse_hybrid_search_plugin_directory_info_type_id;
	synapse_hybrid_search_plugin_directory_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseHybridSearchPluginDirectoryInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return synapse_hybrid_search_plugin_directory_info_type_id;
}

static GType
synapse_hybrid_search_plugin_directory_info_get_type (void)
{
	static volatile gsize synapse_hybrid_search_plugin_directory_info_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_hybrid_search_plugin_directory_info_type_id__volatile)) {
		GType synapse_hybrid_search_plugin_directory_info_type_id;
		synapse_hybrid_search_plugin_directory_info_type_id = synapse_hybrid_search_plugin_directory_info_get_type_once ();
		g_once_init_leave (&synapse_hybrid_search_plugin_directory_info_type_id__volatile, synapse_hybrid_search_plugin_directory_info_type_id);
	}
	return synapse_hybrid_search_plugin_directory_info_type_id__volatile;
}

static gpointer
synapse_hybrid_search_plugin_directory_info_ref (gpointer instance)
{
	SynapseHybridSearchPluginDirectoryInfo * self;
	self = instance;
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	g_atomic_int_inc (&self->ref_count);
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	return instance;
#line 5299 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_directory_info_unref (gpointer instance)
{
	SynapseHybridSearchPluginDirectoryInfo * self;
	self = instance;
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
		SYNAPSE_HYBRID_SEARCH_PLUGIN_DIRECTORY_INFO_GET_CLASS (self)->finalize (self);
#line 44 "../../../src/plugins/hybrid-search-plugin.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5313 "hybrid-search-plugin.c"
	}
}

static GObject *
synapse_hybrid_search_plugin_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseHybridSearchPlugin * self;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
#line 74 "../../../src/plugins/hybrid-search-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_hybrid_search_plugin_parent_class);
#line 74 "../../../src/plugins/hybrid-search-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 74 "../../../src/plugins/hybrid-search-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN, SynapseHybridSearchPlugin);
#line 76 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 76 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (self->priv->directory_hits);
#line 76 "../../../src/plugins/hybrid-search-plugin.vala"
	self->priv->directory_hits = (GeeMap*) _tmp0_;
#line 77 "../../../src/plugins/hybrid-search-plugin.vala"
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SYNAPSE_HYBRID_SEARCH_PLUGIN_TYPE_DIRECTORY_INFO, (GBoxedCopyFunc) synapse_hybrid_search_plugin_directory_info_ref, (GDestroyNotify) synapse_hybrid_search_plugin_directory_info_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 77 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (self->priv->directory_contents);
#line 77 "../../../src/plugins/hybrid-search-plugin.vala"
	self->priv->directory_contents = (GeeMap*) _tmp1_;
#line 79 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_analyze_recent_documents (self, NULL, NULL);
#line 74 "../../../src/plugins/hybrid-search-plugin.vala"
	return obj;
#line 5349 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_class_init (SynapseHybridSearchPluginClass * klass,
                                         gpointer klass_data)
{
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_parent_class = g_type_class_peek_parent (klass);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseHybridSearchPlugin_private_offset);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) synapse_hybrid_search_plugin_real_constructed;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_hybrid_search_plugin_get_property;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_hybrid_search_plugin_set_property;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_hybrid_search_plugin_constructor;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_hybrid_search_plugin_finalize;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_DATA_SINK_PROPERTY, synapse_hybrid_search_plugin_properties[SYNAPSE_HYBRID_SEARCH_PLUGIN_DATA_SINK_PROPERTY] = g_param_spec_object ("data-sink", "data-sink", "data-sink", SYNAPSE_TYPE_DATA_SINK, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_ENABLED_PROPERTY, synapse_hybrid_search_plugin_properties[SYNAPSE_HYBRID_SEARCH_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_HYBRID_SEARCH_PLUGIN_PROCESSING_QUERY_PROPERTY, synapse_hybrid_search_plugin_properties[SYNAPSE_HYBRID_SEARCH_PLUGIN_PROCESSING_QUERY_PROPERTY] = g_param_spec_boolean ("processing-query", "processing-query", "processing-query", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_signals[SYNAPSE_HYBRID_SEARCH_PLUGIN_ZEITGEIST_SEARCH_COMPLETE_SIGNAL] = g_signal_new ("zeitgeist-search-complete", SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_UINT, G_TYPE_NONE, 2, SYNAPSE_TYPE_RESULT_SET, G_TYPE_UINT);
#line 71 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_register_plugin ();
#line 5380 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                                 gpointer iface_data)
{
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_hybrid_search_plugin_real_activate;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_hybrid_search_plugin_real_deactivate;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	iface->get_enabled = synapse_hybrid_search_plugin_real_get_enabled;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	iface->set_enabled = synapse_hybrid_search_plugin_real_set_enabled;
#line 5397 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                                   gpointer iface_data)
{
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	synapse_hybrid_search_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	iface->handles_query = (gboolean (*) (SynapseItemProvider*, SynapseQuery*)) synapse_hybrid_search_plugin_real_handles_query;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_hybrid_search_plugin_real_search;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_hybrid_search_plugin_search_finish;
#line 5412 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_instance_init (SynapseHybridSearchPlugin * self,
                                            gpointer klass)
{
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	self->priv = synapse_hybrid_search_plugin_get_instance_private (self);
#line 32 "../../../src/plugins/hybrid-search-plugin.vala"
	self->priv->_enabled = TRUE;
#line 82 "../../../src/plugins/hybrid-search-plugin.vala"
	self->priv->initialization_done = FALSE;
#line 198 "../../../src/plugins/hybrid-search-plugin.vala"
	self->priv->hit_level = 0;
#line 199 "../../../src/plugins/hybrid-search-plugin.vala"
	self->priv->current_level_uris = 0;
#line 451 "../../../src/plugins/hybrid-search-plugin.vala"
	self->priv->current_query = NULL;
#line 464 "../../../src/plugins/hybrid-search-plugin.vala"
	self->priv->_processing_query = FALSE;
#line 5433 "hybrid-search-plugin.c"
}

static void
synapse_hybrid_search_plugin_finalize (GObject * obj)
{
	SynapseHybridSearchPlugin * self;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN, SynapseHybridSearchPlugin);
#line 197 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (self->priv->directory_hits);
#line 281 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_object_unref0 (self->priv->directory_contents);
#line 451 "../../../src/plugins/hybrid-search-plugin.vala"
	_g_free0 (self->priv->current_query);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	G_OBJECT_CLASS (synapse_hybrid_search_plugin_parent_class)->finalize (obj);
#line 5450 "hybrid-search-plugin.c"
}

static GType
synapse_hybrid_search_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseHybridSearchPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_hybrid_search_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseHybridSearchPlugin), 0, (GInstanceInitFunc) synapse_hybrid_search_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_hybrid_search_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_hybrid_search_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_hybrid_search_plugin_type_id;
	synapse_hybrid_search_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseHybridSearchPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_hybrid_search_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_hybrid_search_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseHybridSearchPlugin_private_offset = g_type_add_instance_private (synapse_hybrid_search_plugin_type_id, sizeof (SynapseHybridSearchPluginPrivate));
	return synapse_hybrid_search_plugin_type_id;
}

GType
synapse_hybrid_search_plugin_get_type (void)
{
	static volatile gsize synapse_hybrid_search_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_hybrid_search_plugin_type_id__volatile)) {
		GType synapse_hybrid_search_plugin_type_id;
		synapse_hybrid_search_plugin_type_id = synapse_hybrid_search_plugin_get_type_once ();
		g_once_init_leave (&synapse_hybrid_search_plugin_type_id__volatile, synapse_hybrid_search_plugin_type_id);
	}
	return synapse_hybrid_search_plugin_type_id__volatile;
}

static void
_vala_synapse_hybrid_search_plugin_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	SynapseHybridSearchPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN, SynapseHybridSearchPlugin);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	switch (property_id) {
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_DATA_SINK_PROPERTY:
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		g_value_set_object (value, synapse_hybrid_search_plugin_get_data_sink (self));
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		break;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_ENABLED_PROPERTY:
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		break;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_PROCESSING_QUERY_PROPERTY:
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		g_value_set_boolean (value, synapse_hybrid_search_plugin_get_processing_query (self));
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		break;
#line 5507 "hybrid-search-plugin.c"
		default:
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		break;
#line 5513 "hybrid-search-plugin.c"
	}
}

static void
_vala_synapse_hybrid_search_plugin_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	SynapseHybridSearchPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_HYBRID_SEARCH_PLUGIN, SynapseHybridSearchPlugin);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
	switch (property_id) {
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_DATA_SINK_PROPERTY:
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		synapse_hybrid_search_plugin_set_data_sink (self, g_value_get_object (value));
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		break;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_ENABLED_PROPERTY:
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		break;
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		case SYNAPSE_HYBRID_SEARCH_PLUGIN_PROCESSING_QUERY_PROPERTY:
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		synapse_hybrid_search_plugin_set_processing_query (self, g_value_get_boolean (value));
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		break;
#line 5545 "hybrid-search-plugin.c"
		default:
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "../../../src/plugins/hybrid-search-plugin.vala"
		break;
#line 5551 "hybrid-search-plugin.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

