/* pass-plugin.c generated by valac 0.48.17, the Vala compiler
 * generated from pass-plugin.vala, do not modify */

/*
 * Copyright (C) 2015 Michael Aquilina <michaelaquilina@gmail.com>

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michael Aquilina <michaelaquilina@gmail.com>
 *
 */

#include <glib-object.h>
#include <synapse-core.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <libnotify/notify.h>

#define SYNAPSE_TYPE_PASS_PLUGIN (synapse_pass_plugin_get_type ())
#define SYNAPSE_PASS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_PASS_PLUGIN, SynapsePassPlugin))
#define SYNAPSE_PASS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_PASS_PLUGIN, SynapsePassPluginClass))
#define SYNAPSE_IS_PASS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_PASS_PLUGIN))
#define SYNAPSE_IS_PASS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_PASS_PLUGIN))
#define SYNAPSE_PASS_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_PASS_PLUGIN, SynapsePassPluginClass))

typedef struct _SynapsePassPlugin SynapsePassPlugin;
typedef struct _SynapsePassPluginClass SynapsePassPluginClass;
typedef struct _SynapsePassPluginPrivate SynapsePassPluginPrivate;
enum  {
	SYNAPSE_PASS_PLUGIN_0_PROPERTY,
	SYNAPSE_PASS_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_PASS_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_pass_plugin_properties[SYNAPSE_PASS_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define SYNAPSE_PASS_PLUGIN_TYPE_PASS_MATCH (synapse_pass_plugin_pass_match_get_type ())
#define SYNAPSE_PASS_PLUGIN_PASS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_PASS_PLUGIN_TYPE_PASS_MATCH, SynapsePassPluginPassMatch))
#define SYNAPSE_PASS_PLUGIN_PASS_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_PASS_PLUGIN_TYPE_PASS_MATCH, SynapsePassPluginPassMatchClass))
#define SYNAPSE_PASS_PLUGIN_IS_PASS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_PASS_PLUGIN_TYPE_PASS_MATCH))
#define SYNAPSE_PASS_PLUGIN_IS_PASS_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_PASS_PLUGIN_TYPE_PASS_MATCH))
#define SYNAPSE_PASS_PLUGIN_PASS_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_PASS_PLUGIN_TYPE_PASS_MATCH, SynapsePassPluginPassMatchClass))

typedef struct _SynapsePassPluginPassMatch SynapsePassPluginPassMatch;
typedef struct _SynapsePassPluginPassMatchClass SynapsePassPluginPassMatchClass;
typedef struct _SynapsePassPluginSearchData SynapsePassPluginSearchData;
typedef struct _SynapsePassPluginPassMatchPrivate SynapsePassPluginPassMatchPrivate;
enum  {
	SYNAPSE_PASS_PLUGIN_PASS_MATCH_0_PROPERTY,
	SYNAPSE_PASS_PLUGIN_PASS_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_pass_plugin_pass_match_properties[SYNAPSE_PASS_PLUGIN_PASS_MATCH_NUM_PROPERTIES];

struct _SynapsePassPlugin {
	GObject parent_instance;
	SynapsePassPluginPrivate * priv;
};

struct _SynapsePassPluginClass {
	GObjectClass parent_class;
};

struct _SynapsePassPluginPrivate {
	gboolean _enabled;
	GFile* password_store;
	GList* passwords;
	GList* monitors;
};

struct _SynapsePassPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapsePassPlugin* self;
	SynapseQuery query;
	SynapseResultSet* result;
	GeeList* matchers;
	SynapseQuery _tmp0_;
	const gchar* _tmp1_;
	GeeList* _tmp2_;
	SynapseResultSet* results;
	SynapseResultSet* _tmp3_;
	GList* _tmp4_;
	GList* password_collection;
	GList* password_it;
	const gchar* password;
	GeeList* _matcher_list;
	GeeList* _tmp5_;
	GeeList* _tmp6_;
	gint _matcher_size;
	GeeList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _matcher_index;
	gint _tmp10_;
	gint _tmp11_;
	GeeMapEntry* matcher;
	GeeList* _tmp12_;
	gpointer _tmp13_;
	GeeMapEntry* _tmp14_;
	gconstpointer _tmp15_;
	gconstpointer _tmp16_;
	const gchar* _tmp17_;
	SynapseResultSet* _tmp18_;
	const gchar* _tmp19_;
	SynapsePassPluginPassMatch* _tmp20_;
	SynapsePassPluginPassMatch* _tmp21_;
	SynapseResultSet* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	GError* _inner_error0_;
};

struct _SynapsePassPluginPassMatch {
	SynapseActionMatch parent_instance;
	SynapsePassPluginPassMatchPrivate * priv;
};

struct _SynapsePassPluginPassMatchClass {
	SynapseActionMatchClass parent_class;
};

static gint SynapsePassPlugin_private_offset;
static gpointer synapse_pass_plugin_parent_class = NULL;
static gpointer synapse_pass_plugin_pass_match_parent_class = NULL;
static SynapseActivatableIface * synapse_pass_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_pass_plugin_synapse_item_provider_parent_iface = NULL;

GType synapse_pass_plugin_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapsePassPlugin, g_object_unref)
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void synapse_pass_plugin_real_activate (SynapseActivatable* base);
static void synapse_pass_plugin_update_passwords (SynapsePassPlugin* self);
static void synapse_pass_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_pass_plugin_register_plugin (void);
static void _synapse_pass_plugin_register_plugin_synapse_plugin_register_func (void);
static gboolean synapse_pass_plugin_real_handles_query (SynapseItemProvider* base,
                                                 SynapseQuery* query);
static GList* synapse_pass_plugin_activate_monitors (SynapsePassPlugin* self,
                                              GFile* directory,
                                              GError** error);
static GList* synapse_pass_plugin_list_passwords (SynapsePassPlugin* self,
                                           GFile* root,
                                           GFile* directory,
                                           GError** error);
static void __lambda14_ (SynapsePassPlugin* self,
                  GFile* src,
                  GFile* dest,
                  GFileMonitorEvent event);
static void ___lambda14__g_file_monitor_changed (GFileMonitor* _sender,
                                          GFile* file,
                                          GFile* other_file,
                                          GFileMonitorEvent event_type,
                                          gpointer self);
static void synapse_pass_plugin_real_search_data_free (gpointer _data);
static void synapse_pass_plugin_real_search (SynapseItemProvider* base,
                                      SynapseQuery* query,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static gboolean synapse_pass_plugin_real_search_co (SynapsePassPluginSearchData* _data_);
static SynapsePassPluginPassMatch* synapse_pass_plugin_pass_match_new (const gchar* password_name);
static SynapsePassPluginPassMatch* synapse_pass_plugin_pass_match_construct (GType object_type,
                                                                      const gchar* password_name);
static GType synapse_pass_plugin_pass_match_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapsePassPluginPassMatch, g_object_unref)
SynapsePassPlugin* synapse_pass_plugin_new (void);
SynapsePassPlugin* synapse_pass_plugin_construct (GType object_type);
static void synapse_pass_plugin_pass_match_real_do_action (SynapseActionMatch* base);
static void ___lambda15_ (SynapsePassPluginPassMatch* self,
                   GPid pid,
                   gint status);
static void ____lambda15__gchild_watch_func (GPid pid,
                                      gint status,
                                      gpointer self);
static GType synapse_pass_plugin_pass_match_get_type_once (void);
static void synapse_pass_plugin_finalize (GObject * obj);
static GType synapse_pass_plugin_get_type_once (void);
static void _vala_synapse_pass_plugin_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_synapse_pass_plugin_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
synapse_pass_plugin_get_instance_private (SynapsePassPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapsePassPlugin_private_offset);
}

static void
_g_free0_ (gpointer var)
{
#line 86 "../../../src/plugins/pass-plugin.vala"
	var = (g_free (var), NULL);
#line 228 "pass-plugin.c"
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
#line 86 "../../../src/plugins/pass-plugin.vala"
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
#line 236 "pass-plugin.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 87 "../../../src/plugins/pass-plugin.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 244 "pass-plugin.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 87 "../../../src/plugins/pass-plugin.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 252 "pass-plugin.c"
}

static void
synapse_pass_plugin_real_activate (SynapseActivatable* base)
{
	SynapsePassPlugin * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
#line 89 "../../../src/plugins/pass-plugin.vala"
	self = (SynapsePassPlugin*) base;
#line 91 "../../../src/plugins/pass-plugin.vala"
	_tmp0_ = g_get_home_dir ();
#line 91 "../../../src/plugins/pass-plugin.vala"
	_tmp1_ = g_strdup_printf ("%s/.password-store", _tmp0_);
#line 91 "../../../src/plugins/pass-plugin.vala"
	_tmp2_ = _tmp1_;
#line 91 "../../../src/plugins/pass-plugin.vala"
	_tmp3_ = g_file_new_for_path (_tmp2_);
#line 91 "../../../src/plugins/pass-plugin.vala"
	_g_object_unref0 (self->priv->password_store);
#line 91 "../../../src/plugins/pass-plugin.vala"
	self->priv->password_store = _tmp3_;
#line 91 "../../../src/plugins/pass-plugin.vala"
	_g_free0 (_tmp2_);
#line 94 "../../../src/plugins/pass-plugin.vala"
	synapse_pass_plugin_update_passwords (self);
#line 281 "pass-plugin.c"
}

static void
synapse_pass_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapsePassPlugin * self;
#line 97 "../../../src/plugins/pass-plugin.vala"
	self = (SynapsePassPlugin*) base;
#line 290 "pass-plugin.c"
}

static void
_synapse_pass_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 103 "../../../src/plugins/pass-plugin.vala"
	synapse_pass_plugin_register_plugin ();
#line 298 "pass-plugin.c"
}

static void
synapse_pass_plugin_register_plugin (void)
{
	SynapsePluginRegistry* _tmp0_;
	SynapsePluginRegistry* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 103 "../../../src/plugins/pass-plugin.vala"
	_tmp0_ = synapse_plugin_registry_get_default ();
#line 103 "../../../src/plugins/pass-plugin.vala"
	_tmp1_ = _tmp0_;
#line 103 "../../../src/plugins/pass-plugin.vala"
	_tmp2_ = g_find_program_in_path ("pass");
#line 103 "../../../src/plugins/pass-plugin.vala"
	_tmp3_ = _tmp2_;
#line 103 "../../../src/plugins/pass-plugin.vala"
	synapse_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_PASS_PLUGIN, _ ("Pass Integration"), _ ("Quickly place passwords from your password store in the clipboard."), "dialog-password", _synapse_pass_plugin_register_plugin_synapse_plugin_register_func, _tmp3_ != NULL, _ ("pass is not installed"));
#line 103 "../../../src/plugins/pass-plugin.vala"
	_g_free0 (_tmp3_);
#line 103 "../../../src/plugins/pass-plugin.vala"
	_g_object_unref0 (_tmp1_);
#line 322 "pass-plugin.c"
}

static gboolean
synapse_pass_plugin_real_handles_query (SynapseItemProvider* base,
                                        SynapseQuery* query)
{
	SynapsePassPlugin * self;
	SynapseQuery _tmp0_;
	SynapseQueryFlags _tmp1_;
	gboolean result = FALSE;
#line 119 "../../../src/plugins/pass-plugin.vala"
	self = (SynapsePassPlugin*) base;
#line 119 "../../../src/plugins/pass-plugin.vala"
	g_return_val_if_fail (query != NULL, FALSE);
#line 121 "../../../src/plugins/pass-plugin.vala"
	_tmp0_ = *query;
#line 121 "../../../src/plugins/pass-plugin.vala"
	_tmp1_ = _tmp0_.query_type;
#line 121 "../../../src/plugins/pass-plugin.vala"
	result = (_tmp1_ & SYNAPSE_QUERY_FLAGS_ACTIONS) == SYNAPSE_QUERY_FLAGS_ACTIONS;
#line 121 "../../../src/plugins/pass-plugin.vala"
	return result;
#line 345 "pass-plugin.c"
}

static void
synapse_pass_plugin_update_passwords (SynapsePassPlugin* self)
{
	GList* _tmp0_;
	GError* _inner_error0_ = NULL;
#line 124 "../../../src/plugins/pass-plugin.vala"
	g_return_if_fail (self != NULL);
#line 125 "../../../src/plugins/pass-plugin.vala"
	_tmp0_ = self->priv->monitors;
#line 357 "pass-plugin.c"
	{
		GList* monitor_collection = NULL;
		GList* monitor_it = NULL;
#line 125 "../../../src/plugins/pass-plugin.vala"
		monitor_collection = _tmp0_;
#line 125 "../../../src/plugins/pass-plugin.vala"
		for (monitor_it = monitor_collection; monitor_it != NULL; monitor_it = monitor_it->next) {
#line 365 "pass-plugin.c"
			GFileMonitor* monitor = NULL;
#line 125 "../../../src/plugins/pass-plugin.vala"
			monitor = (GFileMonitor*) monitor_it->data;
#line 369 "pass-plugin.c"
			{
				GFileMonitor* _tmp1_;
#line 126 "../../../src/plugins/pass-plugin.vala"
				_tmp1_ = monitor;
#line 126 "../../../src/plugins/pass-plugin.vala"
				g_file_monitor_cancel (_tmp1_);
#line 376 "pass-plugin.c"
			}
		}
	}
#line 128 "../../../src/plugins/pass-plugin.vala"
	(self->priv->monitors == NULL) ? NULL : (self->priv->monitors = (_g_list_free__g_object_unref0_ (self->priv->monitors), NULL));
#line 128 "../../../src/plugins/pass-plugin.vala"
	self->priv->monitors = NULL;
#line 384 "pass-plugin.c"
	{
		GList* _tmp2_ = NULL;
		GFile* _tmp3_;
		GList* _tmp4_;
		GList* _tmp5_;
#line 131 "../../../src/plugins/pass-plugin.vala"
		_tmp3_ = self->priv->password_store;
#line 131 "../../../src/plugins/pass-plugin.vala"
		_tmp4_ = synapse_pass_plugin_activate_monitors (self, _tmp3_, &_inner_error0_);
#line 131 "../../../src/plugins/pass-plugin.vala"
		_tmp2_ = _tmp4_;
#line 131 "../../../src/plugins/pass-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 398 "pass-plugin.c"
			goto __catch0_g_error;
		}
#line 131 "../../../src/plugins/pass-plugin.vala"
		_tmp5_ = _tmp2_;
#line 131 "../../../src/plugins/pass-plugin.vala"
		_tmp2_ = NULL;
#line 131 "../../../src/plugins/pass-plugin.vala"
		(self->priv->monitors == NULL) ? NULL : (self->priv->monitors = (_g_list_free__g_object_unref0_ (self->priv->monitors), NULL));
#line 131 "../../../src/plugins/pass-plugin.vala"
		self->priv->monitors = _tmp5_;
#line 130 "../../../src/plugins/pass-plugin.vala"
		(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
#line 411 "pass-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 130 "../../../src/plugins/pass-plugin.vala"
		err = _inner_error0_;
#line 130 "../../../src/plugins/pass-plugin.vala"
		_inner_error0_ = NULL;
#line 133 "../../../src/plugins/pass-plugin.vala"
		_tmp6_ = err;
#line 133 "../../../src/plugins/pass-plugin.vala"
		_tmp7_ = _tmp6_->message;
#line 133 "../../../src/plugins/pass-plugin.vala"
		g_warning ("pass-plugin.vala:133: Unable to monitor password directory: %s", _tmp7_);
#line 130 "../../../src/plugins/pass-plugin.vala"
		_g_error_free0 (err);
#line 431 "pass-plugin.c"
	}
	__finally0:
#line 130 "../../../src/plugins/pass-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 130 "../../../src/plugins/pass-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 130 "../../../src/plugins/pass-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 130 "../../../src/plugins/pass-plugin.vala"
		return;
#line 442 "pass-plugin.c"
	}
	{
		GList* _tmp8_ = NULL;
		GFile* _tmp9_;
		GFile* _tmp10_;
		GList* _tmp11_;
		GList* _tmp12_;
#line 136 "../../../src/plugins/pass-plugin.vala"
		_tmp9_ = self->priv->password_store;
#line 136 "../../../src/plugins/pass-plugin.vala"
		_tmp10_ = self->priv->password_store;
#line 136 "../../../src/plugins/pass-plugin.vala"
		_tmp11_ = synapse_pass_plugin_list_passwords (self, _tmp9_, _tmp10_, &_inner_error0_);
#line 136 "../../../src/plugins/pass-plugin.vala"
		_tmp8_ = _tmp11_;
#line 136 "../../../src/plugins/pass-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 460 "pass-plugin.c"
			goto __catch1_g_error;
		}
#line 136 "../../../src/plugins/pass-plugin.vala"
		_tmp12_ = _tmp8_;
#line 136 "../../../src/plugins/pass-plugin.vala"
		_tmp8_ = NULL;
#line 136 "../../../src/plugins/pass-plugin.vala"
		(self->priv->passwords == NULL) ? NULL : (self->priv->passwords = (_g_list_free__g_free0_ (self->priv->passwords), NULL));
#line 136 "../../../src/plugins/pass-plugin.vala"
		self->priv->passwords = _tmp12_;
#line 135 "../../../src/plugins/pass-plugin.vala"
		(_tmp8_ == NULL) ? NULL : (_tmp8_ = (_g_list_free__g_free0_ (_tmp8_), NULL));
#line 473 "pass-plugin.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* err = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
#line 135 "../../../src/plugins/pass-plugin.vala"
		err = _inner_error0_;
#line 135 "../../../src/plugins/pass-plugin.vala"
		_inner_error0_ = NULL;
#line 138 "../../../src/plugins/pass-plugin.vala"
		_tmp13_ = err;
#line 138 "../../../src/plugins/pass-plugin.vala"
		_tmp14_ = _tmp13_->message;
#line 138 "../../../src/plugins/pass-plugin.vala"
		g_warning ("pass-plugin.vala:138: Unable to list passwords: %s", _tmp14_);
#line 135 "../../../src/plugins/pass-plugin.vala"
		_g_error_free0 (err);
#line 493 "pass-plugin.c"
	}
	__finally1:
#line 135 "../../../src/plugins/pass-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 135 "../../../src/plugins/pass-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 135 "../../../src/plugins/pass-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 135 "../../../src/plugins/pass-plugin.vala"
		return;
#line 504 "pass-plugin.c"
	}
}

static void
__lambda14_ (SynapsePassPlugin* self,
             GFile* src,
             GFile* dest,
             GFileMonitorEvent event)
{
	GEnumValue* _tmp0_;
#line 155 "../../../src/plugins/pass-plugin.vala"
	g_return_if_fail (src != NULL);
#line 156 "../../../src/plugins/pass-plugin.vala"
	_tmp0_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), event);
#line 156 "../../../src/plugins/pass-plugin.vala"
	g_message ("pass-plugin.vala:156: Detected a change (%s) in password store. Reload" \
"ing", (_tmp0_ != NULL) ? _tmp0_->value_name : NULL);
#line 157 "../../../src/plugins/pass-plugin.vala"
	synapse_pass_plugin_update_passwords (self);
#line 523 "pass-plugin.c"
}

static void
___lambda14__g_file_monitor_changed (GFileMonitor* _sender,
                                     GFile* file,
                                     GFile* other_file,
                                     GFileMonitorEvent event_type,
                                     gpointer self)
{
#line 155 "../../../src/plugins/pass-plugin.vala"
	__lambda14_ ((SynapsePassPlugin*) self, file, other_file, event_type);
#line 535 "pass-plugin.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 159 "../../../src/plugins/pass-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 543 "pass-plugin.c"
}

static GList*
synapse_pass_plugin_activate_monitors (SynapsePassPlugin* self,
                                       GFile* directory,
                                       GError** error)
{
	GList* _result_ = NULL;
	GFileEnumerator* enumerator = NULL;
	GFileEnumerator* _tmp0_;
	GFileMonitor* monitor = NULL;
	GFileMonitor* _tmp1_;
	GFileMonitor* _tmp2_;
	GFileMonitor* _tmp3_;
	GFileMonitor* _tmp4_;
	GFileMonitor* _tmp5_;
	GFileInfo* info = NULL;
	GError* _inner_error0_ = NULL;
	GList* result = NULL;
#line 142 "../../../src/plugins/pass-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 142 "../../../src/plugins/pass-plugin.vala"
	g_return_val_if_fail (directory != NULL, NULL);
#line 143 "../../../src/plugins/pass-plugin.vala"
	_result_ = NULL;
#line 145 "../../../src/plugins/pass-plugin.vala"
	_tmp0_ = g_file_enumerate_children (directory, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
#line 145 "../../../src/plugins/pass-plugin.vala"
	enumerator = _tmp0_;
#line 145 "../../../src/plugins/pass-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 145 "../../../src/plugins/pass-plugin.vala"
		g_propagate_error (error, _inner_error0_);
#line 145 "../../../src/plugins/pass-plugin.vala"
		(_result_ == NULL) ? NULL : (_result_ = (_g_list_free__g_object_unref0_ (_result_), NULL));
#line 145 "../../../src/plugins/pass-plugin.vala"
		return NULL;
#line 581 "pass-plugin.c"
	}
#line 153 "../../../src/plugins/pass-plugin.vala"
	_tmp1_ = g_file_monitor_directory (directory, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
#line 153 "../../../src/plugins/pass-plugin.vala"
	monitor = _tmp1_;
#line 153 "../../../src/plugins/pass-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 153 "../../../src/plugins/pass-plugin.vala"
		g_propagate_error (error, _inner_error0_);
#line 153 "../../../src/plugins/pass-plugin.vala"
		_g_object_unref0 (enumerator);
#line 153 "../../../src/plugins/pass-plugin.vala"
		(_result_ == NULL) ? NULL : (_result_ = (_g_list_free__g_object_unref0_ (_result_), NULL));
#line 153 "../../../src/plugins/pass-plugin.vala"
		return NULL;
#line 597 "pass-plugin.c"
	}
#line 154 "../../../src/plugins/pass-plugin.vala"
	_tmp2_ = monitor;
#line 154 "../../../src/plugins/pass-plugin.vala"
	g_file_monitor_set_rate_limit (_tmp2_, 500);
#line 155 "../../../src/plugins/pass-plugin.vala"
	_tmp3_ = monitor;
#line 155 "../../../src/plugins/pass-plugin.vala"
	g_signal_connect_object (_tmp3_, "changed", (GCallback) ___lambda14__g_file_monitor_changed, self, 0);
#line 159 "../../../src/plugins/pass-plugin.vala"
	_tmp4_ = monitor;
#line 159 "../../../src/plugins/pass-plugin.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 159 "../../../src/plugins/pass-plugin.vala"
	_result_ = g_list_append (_result_, _tmp5_);
#line 161 "../../../src/plugins/pass-plugin.vala"
	info = NULL;
#line 162 "../../../src/plugins/pass-plugin.vala"
	while (TRUE) {
#line 617 "pass-plugin.c"
		GFileInfo* _tmp6_ = NULL;
		GFileEnumerator* _tmp7_;
		GFileInfo* _tmp8_;
		GFileInfo* _tmp9_;
		GFileInfo* _tmp10_;
		GFileInfo* _tmp11_;
		GFile* target_file = NULL;
		GFileInfo* _tmp12_;
		const gchar* _tmp13_;
		GFile* _tmp14_;
		GFileInfo* _tmp15_;
#line 162 "../../../src/plugins/pass-plugin.vala"
		_tmp7_ = enumerator;
#line 162 "../../../src/plugins/pass-plugin.vala"
		_tmp8_ = g_file_enumerator_next_file (_tmp7_, NULL, &_inner_error0_);
#line 162 "../../../src/plugins/pass-plugin.vala"
		_tmp6_ = _tmp8_;
#line 162 "../../../src/plugins/pass-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 162 "../../../src/plugins/pass-plugin.vala"
			g_propagate_error (error, _inner_error0_);
#line 162 "../../../src/plugins/pass-plugin.vala"
			_g_object_unref0 (info);
#line 162 "../../../src/plugins/pass-plugin.vala"
			_g_object_unref0 (monitor);
#line 162 "../../../src/plugins/pass-plugin.vala"
			_g_object_unref0 (enumerator);
#line 162 "../../../src/plugins/pass-plugin.vala"
			(_result_ == NULL) ? NULL : (_result_ = (_g_list_free__g_object_unref0_ (_result_), NULL));
#line 162 "../../../src/plugins/pass-plugin.vala"
			return NULL;
#line 649 "pass-plugin.c"
		}
#line 162 "../../../src/plugins/pass-plugin.vala"
		_tmp9_ = _tmp6_;
#line 162 "../../../src/plugins/pass-plugin.vala"
		_tmp6_ = NULL;
#line 162 "../../../src/plugins/pass-plugin.vala"
		_g_object_unref0 (info);
#line 162 "../../../src/plugins/pass-plugin.vala"
		info = _tmp9_;
#line 162 "../../../src/plugins/pass-plugin.vala"
		_tmp10_ = info;
#line 162 "../../../src/plugins/pass-plugin.vala"
		if (!(_tmp10_ != NULL)) {
#line 162 "../../../src/plugins/pass-plugin.vala"
			_g_object_unref0 (_tmp6_);
#line 162 "../../../src/plugins/pass-plugin.vala"
			break;
#line 667 "pass-plugin.c"
		}
#line 163 "../../../src/plugins/pass-plugin.vala"
		_tmp11_ = info;
#line 163 "../../../src/plugins/pass-plugin.vala"
		if (g_file_info_get_is_hidden (_tmp11_)) {
#line 163 "../../../src/plugins/pass-plugin.vala"
			_g_object_unref0 (_tmp6_);
#line 163 "../../../src/plugins/pass-plugin.vala"
			continue;
#line 677 "pass-plugin.c"
		}
#line 165 "../../../src/plugins/pass-plugin.vala"
		_tmp12_ = info;
#line 165 "../../../src/plugins/pass-plugin.vala"
		_tmp13_ = g_file_info_get_name (_tmp12_);
#line 165 "../../../src/plugins/pass-plugin.vala"
		_tmp14_ = g_file_get_child (directory, _tmp13_);
#line 165 "../../../src/plugins/pass-plugin.vala"
		target_file = _tmp14_;
#line 166 "../../../src/plugins/pass-plugin.vala"
		_tmp15_ = info;
#line 166 "../../../src/plugins/pass-plugin.vala"
		if (g_file_info_get_file_type (_tmp15_) == G_FILE_TYPE_DIRECTORY) {
#line 691 "pass-plugin.c"
			GList* _tmp16_ = NULL;
			GFile* _tmp17_;
			GList* _tmp18_;
			GList* _tmp19_;
#line 167 "../../../src/plugins/pass-plugin.vala"
			_tmp17_ = target_file;
#line 167 "../../../src/plugins/pass-plugin.vala"
			_tmp18_ = synapse_pass_plugin_activate_monitors (self, _tmp17_, &_inner_error0_);
#line 167 "../../../src/plugins/pass-plugin.vala"
			_tmp16_ = _tmp18_;
#line 167 "../../../src/plugins/pass-plugin.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 167 "../../../src/plugins/pass-plugin.vala"
				g_propagate_error (error, _inner_error0_);
#line 167 "../../../src/plugins/pass-plugin.vala"
				_g_object_unref0 (target_file);
#line 167 "../../../src/plugins/pass-plugin.vala"
				_g_object_unref0 (_tmp6_);
#line 167 "../../../src/plugins/pass-plugin.vala"
				_g_object_unref0 (info);
#line 167 "../../../src/plugins/pass-plugin.vala"
				_g_object_unref0 (monitor);
#line 167 "../../../src/plugins/pass-plugin.vala"
				_g_object_unref0 (enumerator);
#line 167 "../../../src/plugins/pass-plugin.vala"
				(_result_ == NULL) ? NULL : (_result_ = (_g_list_free__g_object_unref0_ (_result_), NULL));
#line 167 "../../../src/plugins/pass-plugin.vala"
				return NULL;
#line 720 "pass-plugin.c"
			}
#line 167 "../../../src/plugins/pass-plugin.vala"
			_tmp19_ = _tmp16_;
#line 167 "../../../src/plugins/pass-plugin.vala"
			_tmp16_ = NULL;
#line 167 "../../../src/plugins/pass-plugin.vala"
			_result_ = g_list_concat (_result_, _tmp19_);
#line 166 "../../../src/plugins/pass-plugin.vala"
			(_tmp16_ == NULL) ? NULL : (_tmp16_ = (_g_list_free__g_object_unref0_ (_tmp16_), NULL));
#line 730 "pass-plugin.c"
		}
#line 162 "../../../src/plugins/pass-plugin.vala"
		_g_object_unref0 (target_file);
#line 162 "../../../src/plugins/pass-plugin.vala"
		_g_object_unref0 (_tmp6_);
#line 736 "pass-plugin.c"
	}
#line 171 "../../../src/plugins/pass-plugin.vala"
	result = _result_;
#line 171 "../../../src/plugins/pass-plugin.vala"
	_g_object_unref0 (info);
#line 171 "../../../src/plugins/pass-plugin.vala"
	_g_object_unref0 (monitor);
#line 171 "../../../src/plugins/pass-plugin.vala"
	_g_object_unref0 (enumerator);
#line 171 "../../../src/plugins/pass-plugin.vala"
	return result;
#line 748 "pass-plugin.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1535 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 770 "pass-plugin.c"
	} else {
#line 1535 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 774 "pass-plugin.c"
	}
#line 1535 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1535 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 780 "pass-plugin.c"
	} else {
#line 1535 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 784 "pass-plugin.c"
	}
#line 1535 "glib-2.0.vapi"
	if (_tmp0_) {
#line 788 "pass-plugin.c"
		gchar* _tmp2_;
#line 1536 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1536 "glib-2.0.vapi"
		result = _tmp2_;
#line 1536 "glib-2.0.vapi"
		return result;
#line 796 "pass-plugin.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1539 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1539 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1539 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1539 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1539 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1539 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1539 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1539 "glib-2.0.vapi"
			_g_free0 (_tmp7_);
#line 1539 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1539 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 828 "pass-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 1539 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1539 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1539 "glib-2.0.vapi"
			return NULL;
#line 837 "pass-plugin.c"
		}
#line 1540 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1540 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1540 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1540 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1540 "glib-2.0.vapi"
			_g_free0 (_tmp7_);
#line 1540 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1540 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 853 "pass-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 1540 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1540 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1540 "glib-2.0.vapi"
			return NULL;
#line 862 "pass-plugin.c"
		}
#line 1540 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1540 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1540 "glib-2.0.vapi"
		result = _tmp10_;
#line 1540 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1540 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1540 "glib-2.0.vapi"
		return result;
#line 876 "pass-plugin.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1538 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1542 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 885 "pass-plugin.c"
	}
	__finally0:
#line 1538 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1538 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1538 "glib-2.0.vapi"
	return NULL;
#line 894 "pass-plugin.c"
}

static GList*
synapse_pass_plugin_list_passwords (SynapsePassPlugin* self,
                                    GFile* root,
                                    GFile* directory,
                                    GError** error)
{
	GList* _result_ = NULL;
	GFileEnumerator* enumerator = NULL;
	GFileEnumerator* _tmp0_;
	GFileInfo* info = NULL;
	GError* _inner_error0_ = NULL;
	GList* result = NULL;
#line 174 "../../../src/plugins/pass-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 174 "../../../src/plugins/pass-plugin.vala"
	g_return_val_if_fail (root != NULL, NULL);
#line 174 "../../../src/plugins/pass-plugin.vala"
	g_return_val_if_fail (directory != NULL, NULL);
#line 175 "../../../src/plugins/pass-plugin.vala"
	_result_ = NULL;
#line 177 "../../../src/plugins/pass-plugin.vala"
	_tmp0_ = g_file_enumerate_children (directory, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
#line 177 "../../../src/plugins/pass-plugin.vala"
	enumerator = _tmp0_;
#line 177 "../../../src/plugins/pass-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 177 "../../../src/plugins/pass-plugin.vala"
		g_propagate_error (error, _inner_error0_);
#line 177 "../../../src/plugins/pass-plugin.vala"
		(_result_ == NULL) ? NULL : (_result_ = (_g_list_free__g_free0_ (_result_), NULL));
#line 177 "../../../src/plugins/pass-plugin.vala"
		return NULL;
#line 929 "pass-plugin.c"
	}
#line 185 "../../../src/plugins/pass-plugin.vala"
	info = NULL;
#line 186 "../../../src/plugins/pass-plugin.vala"
	while (TRUE) {
#line 935 "pass-plugin.c"
		GFileInfo* _tmp1_ = NULL;
		GFileEnumerator* _tmp2_;
		GFileInfo* _tmp3_;
		GFileInfo* _tmp4_;
		GFileInfo* _tmp5_;
		GFile* target_file = NULL;
		GFileInfo* _tmp6_;
		const gchar* _tmp7_;
		GFile* _tmp8_;
		GFileInfo* _tmp9_;
#line 186 "../../../src/plugins/pass-plugin.vala"
		_tmp2_ = enumerator;
#line 186 "../../../src/plugins/pass-plugin.vala"
		_tmp3_ = g_file_enumerator_next_file (_tmp2_, NULL, &_inner_error0_);
#line 186 "../../../src/plugins/pass-plugin.vala"
		_tmp1_ = _tmp3_;
#line 186 "../../../src/plugins/pass-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 186 "../../../src/plugins/pass-plugin.vala"
			g_propagate_error (error, _inner_error0_);
#line 186 "../../../src/plugins/pass-plugin.vala"
			_g_object_unref0 (info);
#line 186 "../../../src/plugins/pass-plugin.vala"
			_g_object_unref0 (enumerator);
#line 186 "../../../src/plugins/pass-plugin.vala"
			(_result_ == NULL) ? NULL : (_result_ = (_g_list_free__g_free0_ (_result_), NULL));
#line 186 "../../../src/plugins/pass-plugin.vala"
			return NULL;
#line 964 "pass-plugin.c"
		}
#line 186 "../../../src/plugins/pass-plugin.vala"
		_tmp4_ = _tmp1_;
#line 186 "../../../src/plugins/pass-plugin.vala"
		_tmp1_ = NULL;
#line 186 "../../../src/plugins/pass-plugin.vala"
		_g_object_unref0 (info);
#line 186 "../../../src/plugins/pass-plugin.vala"
		info = _tmp4_;
#line 186 "../../../src/plugins/pass-plugin.vala"
		_tmp5_ = info;
#line 186 "../../../src/plugins/pass-plugin.vala"
		if (!(_tmp5_ != NULL)) {
#line 186 "../../../src/plugins/pass-plugin.vala"
			_g_object_unref0 (_tmp1_);
#line 186 "../../../src/plugins/pass-plugin.vala"
			break;
#line 982 "pass-plugin.c"
		}
#line 187 "../../../src/plugins/pass-plugin.vala"
		_tmp6_ = info;
#line 187 "../../../src/plugins/pass-plugin.vala"
		_tmp7_ = g_file_info_get_name (_tmp6_);
#line 187 "../../../src/plugins/pass-plugin.vala"
		_tmp8_ = g_file_get_child (directory, _tmp7_);
#line 187 "../../../src/plugins/pass-plugin.vala"
		target_file = _tmp8_;
#line 188 "../../../src/plugins/pass-plugin.vala"
		_tmp9_ = info;
#line 188 "../../../src/plugins/pass-plugin.vala"
		if (g_file_info_get_file_type (_tmp9_) == G_FILE_TYPE_DIRECTORY) {
#line 996 "pass-plugin.c"
			GList* _tmp10_ = NULL;
			GFile* _tmp11_;
			GList* _tmp12_;
			GList* _tmp13_;
#line 189 "../../../src/plugins/pass-plugin.vala"
			_tmp11_ = target_file;
#line 189 "../../../src/plugins/pass-plugin.vala"
			_tmp12_ = synapse_pass_plugin_list_passwords (self, root, _tmp11_, &_inner_error0_);
#line 189 "../../../src/plugins/pass-plugin.vala"
			_tmp10_ = _tmp12_;
#line 189 "../../../src/plugins/pass-plugin.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 189 "../../../src/plugins/pass-plugin.vala"
				g_propagate_error (error, _inner_error0_);
#line 189 "../../../src/plugins/pass-plugin.vala"
				_g_object_unref0 (target_file);
#line 189 "../../../src/plugins/pass-plugin.vala"
				_g_object_unref0 (_tmp1_);
#line 189 "../../../src/plugins/pass-plugin.vala"
				_g_object_unref0 (info);
#line 189 "../../../src/plugins/pass-plugin.vala"
				_g_object_unref0 (enumerator);
#line 189 "../../../src/plugins/pass-plugin.vala"
				(_result_ == NULL) ? NULL : (_result_ = (_g_list_free__g_free0_ (_result_), NULL));
#line 189 "../../../src/plugins/pass-plugin.vala"
				return NULL;
#line 1023 "pass-plugin.c"
			}
#line 189 "../../../src/plugins/pass-plugin.vala"
			_tmp13_ = _tmp10_;
#line 189 "../../../src/plugins/pass-plugin.vala"
			_tmp10_ = NULL;
#line 189 "../../../src/plugins/pass-plugin.vala"
			_result_ = g_list_concat (_result_, _tmp13_);
#line 188 "../../../src/plugins/pass-plugin.vala"
			(_tmp10_ == NULL) ? NULL : (_tmp10_ = (_g_list_free__g_free0_ (_tmp10_), NULL));
#line 1033 "pass-plugin.c"
		} else {
			GFileInfo* _tmp14_;
			const gchar* _tmp15_;
#line 191 "../../../src/plugins/pass-plugin.vala"
			_tmp14_ = info;
#line 191 "../../../src/plugins/pass-plugin.vala"
			_tmp15_ = g_file_info_get_content_type (_tmp14_);
#line 191 "../../../src/plugins/pass-plugin.vala"
			if (g_strcmp0 (_tmp15_, "application/pgp-encrypted") == 0) {
#line 1043 "pass-plugin.c"
				gchar* path = NULL;
				GFile* _tmp16_;
				gchar* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
#line 192 "../../../src/plugins/pass-plugin.vala"
				_tmp16_ = target_file;
#line 192 "../../../src/plugins/pass-plugin.vala"
				_tmp17_ = g_file_get_relative_path (root, _tmp16_);
#line 192 "../../../src/plugins/pass-plugin.vala"
				path = _tmp17_;
#line 193 "../../../src/plugins/pass-plugin.vala"
				_tmp18_ = path;
#line 193 "../../../src/plugins/pass-plugin.vala"
				_tmp19_ = string_replace (_tmp18_, ".gpg", "");
#line 193 "../../../src/plugins/pass-plugin.vala"
				_result_ = g_list_prepend (_result_, _tmp19_);
#line 191 "../../../src/plugins/pass-plugin.vala"
				_g_free0 (path);
#line 1063 "pass-plugin.c"
			}
		}
#line 186 "../../../src/plugins/pass-plugin.vala"
		_g_object_unref0 (target_file);
#line 186 "../../../src/plugins/pass-plugin.vala"
		_g_object_unref0 (_tmp1_);
#line 1070 "pass-plugin.c"
	}
#line 196 "../../../src/plugins/pass-plugin.vala"
	result = _result_;
#line 196 "../../../src/plugins/pass-plugin.vala"
	_g_object_unref0 (info);
#line 196 "../../../src/plugins/pass-plugin.vala"
	_g_object_unref0 (enumerator);
#line 196 "../../../src/plugins/pass-plugin.vala"
	return result;
#line 1080 "pass-plugin.c"
}

static void
synapse_pass_plugin_real_search_data_free (gpointer _data)
{
	SynapsePassPluginSearchData* _data_;
	_data_ = _data;
#line 24 "../../../src/plugins/pass-plugin.vala"
	synapse_query_destroy (&_data_->query);
#line 24 "../../../src/plugins/pass-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 24 "../../../src/plugins/pass-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 24 "../../../src/plugins/pass-plugin.vala"
	g_slice_free (SynapsePassPluginSearchData, _data_);
#line 1096 "pass-plugin.c"
}

static void
synapse_pass_plugin_real_search (SynapseItemProvider* base,
                                 SynapseQuery* query,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	SynapsePassPlugin * self;
	SynapsePassPluginSearchData* _data_;
	SynapsePassPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
#line 24 "../../../src/plugins/pass-plugin.vala"
	self = (SynapsePassPlugin*) base;
#line 24 "../../../src/plugins/pass-plugin.vala"
	_data_ = g_slice_new0 (SynapsePassPluginSearchData);
#line 24 "../../../src/plugins/pass-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "../../../src/plugins/pass-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_pass_plugin_real_search_data_free);
#line 24 "../../../src/plugins/pass-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "../../../src/plugins/pass-plugin.vala"
	_data_->self = _tmp0_;
#line 24 "../../../src/plugins/pass-plugin.vala"
	_tmp1_ = *query;
#line 24 "../../../src/plugins/pass-plugin.vala"
	_tmp2_ = _tmp1_;
#line 24 "../../../src/plugins/pass-plugin.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 24 "../../../src/plugins/pass-plugin.vala"
	synapse_query_destroy (&_data_->query);
#line 24 "../../../src/plugins/pass-plugin.vala"
	_data_->query = _tmp3_;
#line 24 "../../../src/plugins/pass-plugin.vala"
	synapse_pass_plugin_real_search_co (_data_);
#line 1135 "pass-plugin.c"
}

static SynapseResultSet*
synapse_pass_plugin_search_finish (SynapseItemProvider* base,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	SynapseResultSet* result;
	SynapsePassPluginSearchData* _data_;
#line 24 "../../../src/plugins/pass-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 24 "../../../src/plugins/pass-plugin.vala"
	if (NULL == _data_) {
#line 24 "../../../src/plugins/pass-plugin.vala"
		return NULL;
#line 1151 "pass-plugin.c"
	}
#line 24 "../../../src/plugins/pass-plugin.vala"
	result = _data_->result;
#line 24 "../../../src/plugins/pass-plugin.vala"
	_data_->result = NULL;
#line 24 "../../../src/plugins/pass-plugin.vala"
	return result;
#line 1159 "pass-plugin.c"
}

static gboolean
synapse_pass_plugin_real_search_co (SynapsePassPluginSearchData* _data_)
{
#line 199 "../../../src/plugins/pass-plugin.vala"
	switch (_data_->_state_) {
#line 199 "../../../src/plugins/pass-plugin.vala"
		case 0:
#line 1169 "pass-plugin.c"
		goto _state_0;
		default:
#line 199 "../../../src/plugins/pass-plugin.vala"
		g_assert_not_reached ();
#line 1174 "pass-plugin.c"
	}
	_state_0:
#line 201 "../../../src/plugins/pass-plugin.vala"
	_data_->_tmp0_ = _data_->query;
#line 201 "../../../src/plugins/pass-plugin.vala"
	_data_->_tmp1_ = _data_->_tmp0_.query_string;
#line 201 "../../../src/plugins/pass-plugin.vala"
	_data_->_tmp2_ = synapse_query_get_matchers_for_query (_data_->_tmp1_, 0, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
#line 201 "../../../src/plugins/pass-plugin.vala"
	_data_->matchers = _data_->_tmp2_;
#line 206 "../../../src/plugins/pass-plugin.vala"
	_data_->_tmp3_ = synapse_result_set_new ();
#line 206 "../../../src/plugins/pass-plugin.vala"
	_data_->results = _data_->_tmp3_;
#line 207 "../../../src/plugins/pass-plugin.vala"
	_data_->_tmp4_ = _data_->self->priv->passwords;
#line 1191 "pass-plugin.c"
	{
#line 207 "../../../src/plugins/pass-plugin.vala"
		_data_->password_collection = _data_->_tmp4_;
#line 207 "../../../src/plugins/pass-plugin.vala"
		for (_data_->password_it = _data_->password_collection; _data_->password_it != NULL; _data_->password_it = _data_->password_it->next) {
#line 207 "../../../src/plugins/pass-plugin.vala"
			_data_->password = (const gchar*) _data_->password_it->data;
#line 1199 "pass-plugin.c"
			{
				{
#line 209 "../../../src/plugins/pass-plugin.vala"
					_data_->_tmp5_ = _data_->matchers;
#line 209 "../../../src/plugins/pass-plugin.vala"
					_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp5_);
#line 209 "../../../src/plugins/pass-plugin.vala"
					_data_->_matcher_list = _data_->_tmp6_;
#line 209 "../../../src/plugins/pass-plugin.vala"
					_data_->_tmp7_ = _data_->_matcher_list;
#line 209 "../../../src/plugins/pass-plugin.vala"
					_data_->_tmp8_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp7_);
#line 209 "../../../src/plugins/pass-plugin.vala"
					_data_->_tmp9_ = _data_->_tmp8_;
#line 209 "../../../src/plugins/pass-plugin.vala"
					_data_->_matcher_size = _data_->_tmp9_;
#line 209 "../../../src/plugins/pass-plugin.vala"
					_data_->_matcher_index = -1;
#line 209 "../../../src/plugins/pass-plugin.vala"
					while (TRUE) {
#line 209 "../../../src/plugins/pass-plugin.vala"
						_data_->_matcher_index = _data_->_matcher_index + 1;
#line 209 "../../../src/plugins/pass-plugin.vala"
						_data_->_tmp10_ = _data_->_matcher_index;
#line 209 "../../../src/plugins/pass-plugin.vala"
						_data_->_tmp11_ = _data_->_matcher_size;
#line 209 "../../../src/plugins/pass-plugin.vala"
						if (!(_data_->_tmp10_ < _data_->_tmp11_)) {
#line 209 "../../../src/plugins/pass-plugin.vala"
							break;
#line 1230 "pass-plugin.c"
						}
#line 209 "../../../src/plugins/pass-plugin.vala"
						_data_->_tmp12_ = _data_->_matcher_list;
#line 209 "../../../src/plugins/pass-plugin.vala"
						_data_->_tmp13_ = gee_list_get (_data_->_tmp12_, _data_->_matcher_index);
#line 209 "../../../src/plugins/pass-plugin.vala"
						_data_->matcher = (GeeMapEntry*) _data_->_tmp13_;
#line 211 "../../../src/plugins/pass-plugin.vala"
						_data_->_tmp14_ = _data_->matcher;
#line 211 "../../../src/plugins/pass-plugin.vala"
						_data_->_tmp15_ = gee_map_entry_get_key (_data_->_tmp14_);
#line 211 "../../../src/plugins/pass-plugin.vala"
						_data_->_tmp16_ = _data_->_tmp15_;
#line 211 "../../../src/plugins/pass-plugin.vala"
						_data_->_tmp17_ = _data_->password;
#line 211 "../../../src/plugins/pass-plugin.vala"
						if (g_regex_match ((GRegex*) _data_->_tmp16_, _data_->_tmp17_, 0, NULL)) {
#line 212 "../../../src/plugins/pass-plugin.vala"
							_data_->_tmp18_ = _data_->results;
#line 212 "../../../src/plugins/pass-plugin.vala"
							_data_->_tmp19_ = _data_->password;
#line 212 "../../../src/plugins/pass-plugin.vala"
							_data_->_tmp20_ = synapse_pass_plugin_pass_match_new (_data_->_tmp19_);
#line 212 "../../../src/plugins/pass-plugin.vala"
							_data_->_tmp21_ = _data_->_tmp20_;
#line 212 "../../../src/plugins/pass-plugin.vala"
							synapse_result_set_add (_data_->_tmp18_, (SynapseMatch*) _data_->_tmp21_, (gint) SYNAPSE_MATCH_SCORE_GOOD);
#line 212 "../../../src/plugins/pass-plugin.vala"
							_g_object_unref0 (_data_->_tmp21_);
#line 213 "../../../src/plugins/pass-plugin.vala"
							_g_object_unref0 (_data_->matcher);
#line 213 "../../../src/plugins/pass-plugin.vala"
							break;
#line 1264 "pass-plugin.c"
						}
#line 209 "../../../src/plugins/pass-plugin.vala"
						_g_object_unref0 (_data_->matcher);
#line 1268 "pass-plugin.c"
					}
#line 209 "../../../src/plugins/pass-plugin.vala"
					_g_object_unref0 (_data_->_matcher_list);
#line 1272 "pass-plugin.c"
				}
			}
		}
	}
#line 219 "../../../src/plugins/pass-plugin.vala"
	synapse_query_check_cancellable (&_data_->query, &_data_->_inner_error0_);
#line 219 "../../../src/plugins/pass-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 219 "../../../src/plugins/pass-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 219 "../../../src/plugins/pass-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 219 "../../../src/plugins/pass-plugin.vala"
			_g_object_unref0 (_data_->results);
#line 219 "../../../src/plugins/pass-plugin.vala"
			_g_object_unref0 (_data_->matchers);
#line 219 "../../../src/plugins/pass-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 219 "../../../src/plugins/pass-plugin.vala"
			return FALSE;
#line 1293 "pass-plugin.c"
		} else {
#line 219 "../../../src/plugins/pass-plugin.vala"
			_g_object_unref0 (_data_->results);
#line 219 "../../../src/plugins/pass-plugin.vala"
			_g_object_unref0 (_data_->matchers);
#line 219 "../../../src/plugins/pass-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 219 "../../../src/plugins/pass-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 219 "../../../src/plugins/pass-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 219 "../../../src/plugins/pass-plugin.vala"
			return FALSE;
#line 1307 "pass-plugin.c"
		}
	}
#line 220 "../../../src/plugins/pass-plugin.vala"
	_data_->_tmp22_ = _data_->results;
#line 220 "../../../src/plugins/pass-plugin.vala"
	_data_->_tmp23_ = synapse_result_set_get_size (_data_->_tmp22_);
#line 220 "../../../src/plugins/pass-plugin.vala"
	_data_->_tmp24_ = _data_->_tmp23_;
#line 220 "../../../src/plugins/pass-plugin.vala"
	if (_data_->_tmp24_ > 0) {
#line 221 "../../../src/plugins/pass-plugin.vala"
		_data_->result = _data_->results;
#line 221 "../../../src/plugins/pass-plugin.vala"
		_g_object_unref0 (_data_->matchers);
#line 221 "../../../src/plugins/pass-plugin.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 221 "../../../src/plugins/pass-plugin.vala"
		if (_data_->_state_ != 0) {
#line 221 "../../../src/plugins/pass-plugin.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 221 "../../../src/plugins/pass-plugin.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1330 "pass-plugin.c"
			}
		}
#line 221 "../../../src/plugins/pass-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 221 "../../../src/plugins/pass-plugin.vala"
		return FALSE;
#line 1337 "pass-plugin.c"
	} else {
#line 223 "../../../src/plugins/pass-plugin.vala"
		_data_->result = NULL;
#line 223 "../../../src/plugins/pass-plugin.vala"
		_g_object_unref0 (_data_->results);
#line 223 "../../../src/plugins/pass-plugin.vala"
		_g_object_unref0 (_data_->matchers);
#line 223 "../../../src/plugins/pass-plugin.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 223 "../../../src/plugins/pass-plugin.vala"
		if (_data_->_state_ != 0) {
#line 223 "../../../src/plugins/pass-plugin.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 223 "../../../src/plugins/pass-plugin.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1353 "pass-plugin.c"
			}
		}
#line 223 "../../../src/plugins/pass-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 223 "../../../src/plugins/pass-plugin.vala"
		return FALSE;
#line 1360 "pass-plugin.c"
	}
#line 199 "../../../src/plugins/pass-plugin.vala"
	_g_object_unref0 (_data_->results);
#line 199 "../../../src/plugins/pass-plugin.vala"
	_g_object_unref0 (_data_->matchers);
#line 1366 "pass-plugin.c"
}

SynapsePassPlugin*
synapse_pass_plugin_construct (GType object_type)
{
	SynapsePassPlugin * self = NULL;
#line 24 "../../../src/plugins/pass-plugin.vala"
	self = (SynapsePassPlugin*) g_object_new (object_type, NULL);
#line 24 "../../../src/plugins/pass-plugin.vala"
	return self;
#line 1377 "pass-plugin.c"
}

SynapsePassPlugin*
synapse_pass_plugin_new (void)
{
#line 24 "../../../src/plugins/pass-plugin.vala"
	return synapse_pass_plugin_construct (SYNAPSE_TYPE_PASS_PLUGIN);
#line 1385 "pass-plugin.c"
}

static gboolean
synapse_pass_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapsePassPlugin* self;
#line 83 "../../../src/plugins/pass-plugin.vala"
	self = (SynapsePassPlugin*) base;
#line 83 "../../../src/plugins/pass-plugin.vala"
	result = self->priv->_enabled;
#line 83 "../../../src/plugins/pass-plugin.vala"
	return result;
#line 1399 "pass-plugin.c"
}

static void
synapse_pass_plugin_real_set_enabled (SynapseActivatable* base,
                                      gboolean value)
{
	SynapsePassPlugin* self;
	gboolean old_value;
#line 83 "../../../src/plugins/pass-plugin.vala"
	self = (SynapsePassPlugin*) base;
#line 83 "../../../src/plugins/pass-plugin.vala"
	old_value = synapse_pass_plugin_real_get_enabled (base);
#line 83 "../../../src/plugins/pass-plugin.vala"
	if (old_value != value) {
#line 83 "../../../src/plugins/pass-plugin.vala"
		self->priv->_enabled = value;
#line 83 "../../../src/plugins/pass-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_pass_plugin_properties[SYNAPSE_PASS_PLUGIN_ENABLED_PROPERTY]);
#line 1418 "pass-plugin.c"
	}
}

static SynapsePassPluginPassMatch*
synapse_pass_plugin_pass_match_construct (GType object_type,
                                          const gchar* password_name)
{
	SynapsePassPluginPassMatch * self = NULL;
#line 28 "../../../src/plugins/pass-plugin.vala"
	g_return_val_if_fail (password_name != NULL, NULL);
#line 30 "../../../src/plugins/pass-plugin.vala"
	self = (SynapsePassPluginPassMatch*) g_object_new (object_type, "title", password_name, "description", _ ("Copy decrypted PGP password to clipboard"), "has-thumbnail", FALSE, "icon-name", "dialog-password", NULL);
#line 28 "../../../src/plugins/pass-plugin.vala"
	return self;
#line 1433 "pass-plugin.c"
}

static SynapsePassPluginPassMatch*
synapse_pass_plugin_pass_match_new (const gchar* password_name)
{
#line 28 "../../../src/plugins/pass-plugin.vala"
	return synapse_pass_plugin_pass_match_construct (SYNAPSE_PASS_PLUGIN_TYPE_PASS_MATCH, password_name);
#line 1441 "pass-plugin.c"
}

static void
___lambda15_ (SynapsePassPluginPassMatch* self,
              GPid pid,
              gint status)
{
	GError* _inner_error0_ = NULL;
#line 50 "../../../src/plugins/pass-plugin.vala"
	g_spawn_close_pid (pid);
#line 1452 "pass-plugin.c"
	{
		gchar* message = NULL;
		gchar* icon_name = NULL;
		NotifyNotification* notification = NULL;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		GObject* _tmp10_;
		GObject* _tmp11_;
#line 55 "../../../src/plugins/pass-plugin.vala"
		if (status == 0) {
#line 1463 "pass-plugin.c"
			const gchar* _tmp0_;
			const gchar* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
#line 56 "../../../src/plugins/pass-plugin.vala"
			_tmp0_ = synapse_match_get_title ((SynapseMatch*) self);
#line 56 "../../../src/plugins/pass-plugin.vala"
			_tmp1_ = _tmp0_;
#line 56 "../../../src/plugins/pass-plugin.vala"
			_tmp2_ = g_strdup_printf (_ ("Copied %s password to clipboard"), _tmp1_);
#line 56 "../../../src/plugins/pass-plugin.vala"
			_g_free0 (message);
#line 56 "../../../src/plugins/pass-plugin.vala"
			message = _tmp2_;
#line 57 "../../../src/plugins/pass-plugin.vala"
			_tmp3_ = g_strdup ("dialog-password");
#line 57 "../../../src/plugins/pass-plugin.vala"
			_g_free0 (icon_name);
#line 57 "../../../src/plugins/pass-plugin.vala"
			icon_name = _tmp3_;
#line 1484 "pass-plugin.c"
		} else {
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
#line 59 "../../../src/plugins/pass-plugin.vala"
			_tmp4_ = synapse_match_get_title ((SynapseMatch*) self);
#line 59 "../../../src/plugins/pass-plugin.vala"
			_tmp5_ = _tmp4_;
#line 59 "../../../src/plugins/pass-plugin.vala"
			_tmp6_ = g_strdup_printf (_ ("Unable to decrypt %s password"), _tmp5_);
#line 59 "../../../src/plugins/pass-plugin.vala"
			_g_free0 (message);
#line 59 "../../../src/plugins/pass-plugin.vala"
			message = _tmp6_;
#line 60 "../../../src/plugins/pass-plugin.vala"
			_tmp7_ = g_strdup ("dialog-error");
#line 60 "../../../src/plugins/pass-plugin.vala"
			_g_free0 (icon_name);
#line 60 "../../../src/plugins/pass-plugin.vala"
			icon_name = _tmp7_;
#line 1506 "pass-plugin.c"
		}
#line 63 "../../../src/plugins/pass-plugin.vala"
		_tmp8_ = message;
#line 63 "../../../src/plugins/pass-plugin.vala"
		_tmp9_ = icon_name;
#line 63 "../../../src/plugins/pass-plugin.vala"
		_tmp10_ = g_object_new (notify_notification_get_type (), "summary", _ ("Synapse - Pass"), "body", _tmp8_, "icon-name", _tmp9_, NULL, NULL);
#line 63 "../../../src/plugins/pass-plugin.vala"
		_tmp11_ = G_IS_INITIALLY_UNOWNED (_tmp10_) ? g_object_ref_sink (_tmp10_) : _tmp10_;
#line 63 "../../../src/plugins/pass-plugin.vala"
		notification = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, notify_notification_get_type (), NotifyNotification);
#line 70 "../../../src/plugins/pass-plugin.vala"
		notify_notification_show (notification, &_inner_error0_);
#line 70 "../../../src/plugins/pass-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 70 "../../../src/plugins/pass-plugin.vala"
			_g_object_unref0 (notification);
#line 70 "../../../src/plugins/pass-plugin.vala"
			_g_free0 (icon_name);
#line 70 "../../../src/plugins/pass-plugin.vala"
			_g_free0 (message);
#line 1528 "pass-plugin.c"
			goto __catch0_g_error;
		}
#line 63 "../../../src/plugins/pass-plugin.vala"
		_g_object_unref0 (notification);
#line 63 "../../../src/plugins/pass-plugin.vala"
		_g_free0 (icon_name);
#line 63 "../../../src/plugins/pass-plugin.vala"
		_g_free0 (message);
#line 1537 "pass-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
#line 63 "../../../src/plugins/pass-plugin.vala"
		err = _inner_error0_;
#line 63 "../../../src/plugins/pass-plugin.vala"
		_inner_error0_ = NULL;
#line 73 "../../../src/plugins/pass-plugin.vala"
		_tmp12_ = err;
#line 73 "../../../src/plugins/pass-plugin.vala"
		_tmp13_ = _tmp12_->message;
#line 73 "../../../src/plugins/pass-plugin.vala"
		g_warning ("pass-plugin.vala:73: %s", _tmp13_);
#line 63 "../../../src/plugins/pass-plugin.vala"
		_g_error_free0 (err);
#line 1557 "pass-plugin.c"
	}
	__finally0:
#line 63 "../../../src/plugins/pass-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 63 "../../../src/plugins/pass-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 63 "../../../src/plugins/pass-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 63 "../../../src/plugins/pass-plugin.vala"
		return;
#line 1568 "pass-plugin.c"
	}
}

static void
____lambda15__gchild_watch_func (GPid pid,
                                 gint status,
                                 gpointer self)
{
#line 49 "../../../src/plugins/pass-plugin.vala"
	___lambda15_ ((SynapsePassPluginPassMatch*) self, pid, status);
#line 1579 "pass-plugin.c"
}

static void
synapse_pass_plugin_pass_match_real_do_action (SynapseActionMatch* base)
{
	SynapsePassPluginPassMatch * self;
	GPid child_pid = 0;
	gint standard_output = 0;
	gint standard_error = 0;
	GError* _inner_error0_ = NULL;
#line 35 "../../../src/plugins/pass-plugin.vala"
	self = (SynapsePassPluginPassMatch*) base;
#line 1592 "pass-plugin.c"
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar** _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		GPid _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
#line 43 "../../../src/plugins/pass-plugin.vala"
		_tmp0_ = g_strdup ("pass");
#line 43 "../../../src/plugins/pass-plugin.vala"
		_tmp1_ = g_strdup ("-c");
#line 43 "../../../src/plugins/pass-plugin.vala"
		_tmp2_ = synapse_match_get_title ((SynapseMatch*) self);
#line 43 "../../../src/plugins/pass-plugin.vala"
		_tmp3_ = _tmp2_;
#line 43 "../../../src/plugins/pass-plugin.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 43 "../../../src/plugins/pass-plugin.vala"
		_tmp5_ = g_new0 (gchar*, 3 + 1);
#line 43 "../../../src/plugins/pass-plugin.vala"
		_tmp5_[0] = _tmp0_;
#line 43 "../../../src/plugins/pass-plugin.vala"
		_tmp5_[1] = _tmp1_;
#line 43 "../../../src/plugins/pass-plugin.vala"
		_tmp5_[2] = _tmp4_;
#line 43 "../../../src/plugins/pass-plugin.vala"
		_tmp6_ = _tmp5_;
#line 43 "../../../src/plugins/pass-plugin.vala"
		_tmp6__length1 = 3;
#line 43 "../../../src/plugins/pass-plugin.vala"
		g_spawn_async_with_pipes (NULL, _tmp6_, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp7_, NULL, &_tmp8_, &_tmp9_, &_inner_error0_);
#line 43 "../../../src/plugins/pass-plugin.vala"
		child_pid = _tmp7_;
#line 43 "../../../src/plugins/pass-plugin.vala"
		standard_output = _tmp8_;
#line 43 "../../../src/plugins/pass-plugin.vala"
		standard_error = _tmp9_;
#line 43 "../../../src/plugins/pass-plugin.vala"
		_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
#line 43 "../../../src/plugins/pass-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 43 "../../../src/plugins/pass-plugin.vala"
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
#line 1641 "pass-plugin.c"
				goto __catch0_g_spawn_error;
			}
#line 43 "../../../src/plugins/pass-plugin.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 43 "../../../src/plugins/pass-plugin.vala"
			g_clear_error (&_inner_error0_);
#line 43 "../../../src/plugins/pass-plugin.vala"
			return;
#line 1650 "pass-plugin.c"
		}
#line 49 "../../../src/plugins/pass-plugin.vala"
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, child_pid, ____lambda15__gchild_watch_func, g_object_ref (self), g_object_unref);
#line 1654 "pass-plugin.c"
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* err = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
#line 49 "../../../src/plugins/pass-plugin.vala"
		err = _inner_error0_;
#line 49 "../../../src/plugins/pass-plugin.vala"
		_inner_error0_ = NULL;
#line 78 "../../../src/plugins/pass-plugin.vala"
		_tmp10_ = err;
#line 78 "../../../src/plugins/pass-plugin.vala"
		_tmp11_ = _tmp10_->message;
#line 78 "../../../src/plugins/pass-plugin.vala"
		g_warning ("pass-plugin.vala:78: %s", _tmp11_);
#line 49 "../../../src/plugins/pass-plugin.vala"
		_g_error_free0 (err);
#line 1674 "pass-plugin.c"
	}
	__finally0:
#line 49 "../../../src/plugins/pass-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 49 "../../../src/plugins/pass-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 49 "../../../src/plugins/pass-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 49 "../../../src/plugins/pass-plugin.vala"
		return;
#line 1685 "pass-plugin.c"
	}
}

static void
synapse_pass_plugin_pass_match_class_init (SynapsePassPluginPassMatchClass * klass,
                                           gpointer klass_data)
{
#line 26 "../../../src/plugins/pass-plugin.vala"
	synapse_pass_plugin_pass_match_parent_class = g_type_class_peek_parent (klass);
#line 26 "../../../src/plugins/pass-plugin.vala"
	((SynapseActionMatchClass *) klass)->do_action = (void (*) (SynapseActionMatch*)) synapse_pass_plugin_pass_match_real_do_action;
#line 1697 "pass-plugin.c"
}

static void
synapse_pass_plugin_pass_match_instance_init (SynapsePassPluginPassMatch * self,
                                              gpointer klass)
{
}

static GType
synapse_pass_plugin_pass_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapsePassPluginPassMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_pass_plugin_pass_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapsePassPluginPassMatch), 0, (GInstanceInitFunc) synapse_pass_plugin_pass_match_instance_init, NULL };
	GType synapse_pass_plugin_pass_match_type_id;
	synapse_pass_plugin_pass_match_type_id = g_type_register_static (SYNAPSE_TYPE_ACTION_MATCH, "SynapsePassPluginPassMatch", &g_define_type_info, 0);
	return synapse_pass_plugin_pass_match_type_id;
}

static GType
synapse_pass_plugin_pass_match_get_type (void)
{
	static volatile gsize synapse_pass_plugin_pass_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_pass_plugin_pass_match_type_id__volatile)) {
		GType synapse_pass_plugin_pass_match_type_id;
		synapse_pass_plugin_pass_match_type_id = synapse_pass_plugin_pass_match_get_type_once ();
		g_once_init_leave (&synapse_pass_plugin_pass_match_type_id__volatile, synapse_pass_plugin_pass_match_type_id);
	}
	return synapse_pass_plugin_pass_match_type_id__volatile;
}

static void
synapse_pass_plugin_class_init (SynapsePassPluginClass * klass,
                                gpointer klass_data)
{
#line 24 "../../../src/plugins/pass-plugin.vala"
	synapse_pass_plugin_parent_class = g_type_class_peek_parent (klass);
#line 24 "../../../src/plugins/pass-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapsePassPlugin_private_offset);
#line 24 "../../../src/plugins/pass-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_pass_plugin_get_property;
#line 24 "../../../src/plugins/pass-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_pass_plugin_set_property;
#line 24 "../../../src/plugins/pass-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_pass_plugin_finalize;
#line 24 "../../../src/plugins/pass-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_PASS_PLUGIN_ENABLED_PROPERTY, synapse_pass_plugin_properties[SYNAPSE_PASS_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 116 "../../../src/plugins/pass-plugin.vala"
	synapse_pass_plugin_register_plugin ();
#line 1745 "pass-plugin.c"
}

static void
synapse_pass_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                        gpointer iface_data)
{
#line 26 "../../../src/plugins/pass-plugin.vala"
	synapse_pass_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 26 "../../../src/plugins/pass-plugin.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_pass_plugin_real_activate;
#line 26 "../../../src/plugins/pass-plugin.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_pass_plugin_real_deactivate;
#line 26 "../../../src/plugins/pass-plugin.vala"
	iface->get_enabled = synapse_pass_plugin_real_get_enabled;
#line 26 "../../../src/plugins/pass-plugin.vala"
	iface->set_enabled = synapse_pass_plugin_real_set_enabled;
#line 1762 "pass-plugin.c"
}

static void
synapse_pass_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                          gpointer iface_data)
{
#line 26 "../../../src/plugins/pass-plugin.vala"
	synapse_pass_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 26 "../../../src/plugins/pass-plugin.vala"
	iface->handles_query = (gboolean (*) (SynapseItemProvider*, SynapseQuery*)) synapse_pass_plugin_real_handles_query;
#line 26 "../../../src/plugins/pass-plugin.vala"
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_pass_plugin_real_search;
#line 26 "../../../src/plugins/pass-plugin.vala"
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_pass_plugin_search_finish;
#line 1777 "pass-plugin.c"
}

static void
synapse_pass_plugin_instance_init (SynapsePassPlugin * self,
                                   gpointer klass)
{
#line 24 "../../../src/plugins/pass-plugin.vala"
	self->priv = synapse_pass_plugin_get_instance_private (self);
#line 83 "../../../src/plugins/pass-plugin.vala"
	self->priv->_enabled = TRUE;
#line 1788 "pass-plugin.c"
}

static void
synapse_pass_plugin_finalize (GObject * obj)
{
	SynapsePassPlugin * self;
#line 24 "../../../src/plugins/pass-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_PASS_PLUGIN, SynapsePassPlugin);
#line 85 "../../../src/plugins/pass-plugin.vala"
	_g_object_unref0 (self->priv->password_store);
#line 86 "../../../src/plugins/pass-plugin.vala"
	(self->priv->passwords == NULL) ? NULL : (self->priv->passwords = (_g_list_free__g_free0_ (self->priv->passwords), NULL));
#line 87 "../../../src/plugins/pass-plugin.vala"
	(self->priv->monitors == NULL) ? NULL : (self->priv->monitors = (_g_list_free__g_object_unref0_ (self->priv->monitors), NULL));
#line 26 "../../../src/plugins/pass-plugin.vala"
	G_OBJECT_CLASS (synapse_pass_plugin_parent_class)->finalize (obj);
#line 1805 "pass-plugin.c"
}

static GType
synapse_pass_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapsePassPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_pass_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapsePassPlugin), 0, (GInstanceInitFunc) synapse_pass_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_pass_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_pass_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_pass_plugin_type_id;
	synapse_pass_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapsePassPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_pass_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_pass_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapsePassPlugin_private_offset = g_type_add_instance_private (synapse_pass_plugin_type_id, sizeof (SynapsePassPluginPrivate));
	return synapse_pass_plugin_type_id;
}

GType
synapse_pass_plugin_get_type (void)
{
	static volatile gsize synapse_pass_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_pass_plugin_type_id__volatile)) {
		GType synapse_pass_plugin_type_id;
		synapse_pass_plugin_type_id = synapse_pass_plugin_get_type_once ();
		g_once_init_leave (&synapse_pass_plugin_type_id__volatile, synapse_pass_plugin_type_id);
	}
	return synapse_pass_plugin_type_id__volatile;
}

static void
_vala_synapse_pass_plugin_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	SynapsePassPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_PASS_PLUGIN, SynapsePassPlugin);
#line 24 "../../../src/plugins/pass-plugin.vala"
	switch (property_id) {
#line 24 "../../../src/plugins/pass-plugin.vala"
		case SYNAPSE_PASS_PLUGIN_ENABLED_PROPERTY:
#line 24 "../../../src/plugins/pass-plugin.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 24 "../../../src/plugins/pass-plugin.vala"
		break;
#line 1850 "pass-plugin.c"
		default:
#line 24 "../../../src/plugins/pass-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../../../src/plugins/pass-plugin.vala"
		break;
#line 1856 "pass-plugin.c"
	}
}

static void
_vala_synapse_pass_plugin_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	SynapsePassPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_PASS_PLUGIN, SynapsePassPlugin);
#line 24 "../../../src/plugins/pass-plugin.vala"
	switch (property_id) {
#line 24 "../../../src/plugins/pass-plugin.vala"
		case SYNAPSE_PASS_PLUGIN_ENABLED_PROPERTY:
#line 24 "../../../src/plugins/pass-plugin.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 24 "../../../src/plugins/pass-plugin.vala"
		break;
#line 1876 "pass-plugin.c"
		default:
#line 24 "../../../src/plugins/pass-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../../../src/plugins/pass-plugin.vala"
		break;
#line 1882 "pass-plugin.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 24 "../../../src/plugins/pass-plugin.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 1893 "pass-plugin.c"
		gint i;
#line 24 "../../../src/plugins/pass-plugin.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 24 "../../../src/plugins/pass-plugin.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 24 "../../../src/plugins/pass-plugin.vala"
				destroy_func (((gpointer*) array)[i]);
#line 1901 "pass-plugin.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 24 "../../../src/plugins/pass-plugin.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 24 "../../../src/plugins/pass-plugin.vala"
	g_free (array);
#line 1916 "pass-plugin.c"
}

