/* zeitgeist-plugin.c generated by valac 0.48.17, the Vala compiler
 * generated from zeitgeist-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib-object.h>
#include <synapse-core.h>
#include <glib.h>
#include <zeitgeist.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <zeitgeist-datamodel.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>

#define SYNAPSE_TYPE_ZEITGEIST_PLUGIN (synapse_zeitgeist_plugin_get_type ())
#define SYNAPSE_ZEITGEIST_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ZEITGEIST_PLUGIN, SynapseZeitgeistPlugin))
#define SYNAPSE_ZEITGEIST_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_ZEITGEIST_PLUGIN, SynapseZeitgeistPluginClass))
#define SYNAPSE_IS_ZEITGEIST_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ZEITGEIST_PLUGIN))
#define SYNAPSE_IS_ZEITGEIST_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_ZEITGEIST_PLUGIN))
#define SYNAPSE_ZEITGEIST_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_ZEITGEIST_PLUGIN, SynapseZeitgeistPluginClass))

typedef struct _SynapseZeitgeistPlugin SynapseZeitgeistPlugin;
typedef struct _SynapseZeitgeistPluginClass SynapseZeitgeistPluginClass;
typedef struct _SynapseZeitgeistPluginPrivate SynapseZeitgeistPluginPrivate;
enum  {
	SYNAPSE_ZEITGEIST_PLUGIN_0_PROPERTY,
	SYNAPSE_ZEITGEIST_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_ZEITGEIST_PLUGIN_DATA_SINK_PROPERTY,
	SYNAPSE_ZEITGEIST_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_zeitgeist_plugin_properties[SYNAPSE_ZEITGEIST_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_URI_MATCH (synapse_zeitgeist_plugin_zeitgeist_uri_match_get_type ())
#define SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_URI_MATCH, SynapseZeitgeistPluginZeitgeistUriMatch))
#define SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_URI_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_URI_MATCH, SynapseZeitgeistPluginZeitgeistUriMatchClass))
#define SYNAPSE_ZEITGEIST_PLUGIN_IS_ZEITGEIST_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_URI_MATCH))
#define SYNAPSE_ZEITGEIST_PLUGIN_IS_ZEITGEIST_URI_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_URI_MATCH))
#define SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_URI_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_URI_MATCH, SynapseZeitgeistPluginZeitgeistUriMatchClass))

typedef struct _SynapseZeitgeistPluginZeitgeistUriMatch SynapseZeitgeistPluginZeitgeistUriMatch;
typedef struct _SynapseZeitgeistPluginZeitgeistUriMatchClass SynapseZeitgeistPluginZeitgeistUriMatchClass;
typedef struct _SynapseZeitgeistPluginProcessResultsData SynapseZeitgeistPluginProcessResultsData;
typedef struct _SynapseZeitgeistPluginProcessRecentResultsData SynapseZeitgeistPluginProcessRecentResultsData;
typedef struct _Block9Data Block9Data;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseZeitgeistPluginSearchData SynapseZeitgeistPluginSearchData;

#define SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_APPLICATION_MATCH (synapse_zeitgeist_plugin_zeitgeist_application_match_get_type ())
#define SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_APPLICATION_MATCH, SynapseZeitgeistPluginZeitgeistApplicationMatch))
#define SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_APPLICATION_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_APPLICATION_MATCH, SynapseZeitgeistPluginZeitgeistApplicationMatchClass))
#define SYNAPSE_ZEITGEIST_PLUGIN_IS_ZEITGEIST_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_APPLICATION_MATCH))
#define SYNAPSE_ZEITGEIST_PLUGIN_IS_ZEITGEIST_APPLICATION_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_APPLICATION_MATCH))
#define SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_APPLICATION_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_APPLICATION_MATCH, SynapseZeitgeistPluginZeitgeistApplicationMatchClass))

typedef struct _SynapseZeitgeistPluginZeitgeistApplicationMatch SynapseZeitgeistPluginZeitgeistApplicationMatch;
typedef struct _SynapseZeitgeistPluginZeitgeistApplicationMatchClass SynapseZeitgeistPluginZeitgeistApplicationMatchClass;
typedef struct _SynapseZeitgeistPluginZeitgeistApplicationMatchPrivate SynapseZeitgeistPluginZeitgeistApplicationMatchPrivate;
enum  {
	SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_APPLICATION_MATCH_0_PROPERTY,
	SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_APPLICATION_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_zeitgeist_plugin_zeitgeist_application_match_properties[SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_APPLICATION_MATCH_NUM_PROPERTIES];
typedef struct _SynapseZeitgeistPluginZeitgeistUriMatchPrivate SynapseZeitgeistPluginZeitgeistUriMatchPrivate;
enum  {
	SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_URI_MATCH_0_PROPERTY,
	SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_URI_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_zeitgeist_plugin_zeitgeist_uri_match_properties[SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_URI_MATCH_NUM_PROPERTIES];

#define SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY (synapse_zeitgeist_plugin_zeitgeist_match_factory_get_type ())
#define SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_MATCH_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY, SynapseZeitgeistPluginZeitgeistMatchFactory))
#define SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_MATCH_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY, SynapseZeitgeistPluginZeitgeistMatchFactoryClass))
#define SYNAPSE_ZEITGEIST_PLUGIN_IS_ZEITGEIST_MATCH_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY))
#define SYNAPSE_ZEITGEIST_PLUGIN_IS_ZEITGEIST_MATCH_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY))
#define SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_MATCH_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY, SynapseZeitgeistPluginZeitgeistMatchFactoryClass))

typedef struct _SynapseZeitgeistPluginZeitgeistMatchFactory SynapseZeitgeistPluginZeitgeistMatchFactory;
typedef struct _SynapseZeitgeistPluginZeitgeistMatchFactoryClass SynapseZeitgeistPluginZeitgeistMatchFactoryClass;
typedef struct _SynapseZeitgeistPluginZeitgeistMatchFactoryPrivate SynapseZeitgeistPluginZeitgeistMatchFactoryPrivate;
typedef struct _SynapseZeitgeistPluginParamSpecZeitgeistMatchFactory SynapseZeitgeistPluginParamSpecZeitgeistMatchFactory;

struct _SynapseZeitgeistPlugin {
	GObject parent_instance;
	SynapseZeitgeistPluginPrivate * priv;
};

struct _SynapseZeitgeistPluginClass {
	GObjectClass parent_class;
};

struct _SynapseZeitgeistPluginPrivate {
	gboolean _enabled;
	SynapseDataSink* _data_sink;
	ZeitgeistIndex* zg_index;
	ZeitgeistLog* zg_log;
	gboolean search_in_progress;
};

struct _SynapseZeitgeistPluginProcessResultsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* query;
	ZeitgeistResultSet* events;
	GCancellable* cancellable;
	SynapseResultSet* real_results;
	gboolean local_only;
	gboolean places_search;
	GeeSet* uris;
	GeeHashSet* _tmp0_;
	GeeList* matchers;
	GeeList* _tmp1_;
	SynapseResultSet* results;
	SynapseResultSet* _tmp2_;
	glong minimum;
	glong maximum;
	ZeitgeistResultSet* _event_it;
	ZeitgeistResultSet* _tmp3_;
	ZeitgeistEvent* event;
	ZeitgeistResultSet* _tmp4_;
	ZeitgeistEvent* _tmp5_;
	ZeitgeistEvent* _tmp6_;
	ZeitgeistEvent* _tmp7_;
	ZeitgeistSubject* subject;
	ZeitgeistEvent* _tmp8_;
	GPtrArray* _tmp9_;
	GPtrArray* _tmp10_;
	gconstpointer _tmp11_;
	ZeitgeistSubject* _tmp12_;
	const gchar* _tmp13_;
	ZeitgeistSubject* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	ZeitgeistSubject* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* uri;
	gboolean _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GeeSet* _tmp23_;
	const gchar* _tmp24_;
	gboolean is_application;
	const gchar* _tmp25_;
	gint relevancy_penalty;
	gchar* thumbnail_path;
	gchar* icon;
	GeeSet* _tmp26_;
	const gchar* _tmp27_;
	GFile* f;
	const gchar* _tmp28_;
	GFile* _tmp29_;
	GFile* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gboolean _tmp33_;
	GFile* _tmp34_;
	GFileInfo* fi;
	GFile* _tmp35_;
	const gchar* _tmp36_;
	GFileInfo* _tmp37_;
	GFileInfo* _tmp38_;
	GIcon* _tmp39_;
	gchar* _tmp40_;
	GFileInfo* _tmp41_;
	GFileInfo* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	GFileInfo* _tmp45_;
	const gchar* _tmp46_;
	gchar* note_filename;
	const gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* note_path;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	GFile* note_f;
	const gchar* _tmp55_;
	GFile* _tmp56_;
	gboolean exists;
	GFile* _tmp57_;
	GIcon* _tmp58_;
	GIcon* _tmp59_;
	gchar* _tmp60_;
	gboolean _tmp61_;
	SynapseDesktopFileService* dfs;
	SynapseDesktopFileService* _tmp62_;
	SynapseDesktopFileService* _tmp63_;
	const gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	SynapseDesktopFileInfo* _tmp67_;
	SynapseDesktopFileInfo* _tmp68_;
	gboolean _tmp69_;
	const gchar* mimetype;
	ZeitgeistSubject* _tmp70_;
	const gchar* _tmp71_;
	const gchar* _tmp72_;
	gboolean _tmp73_;
	const gchar* _tmp74_;
	const gchar* _tmp75_;
	const gchar* _tmp76_;
	GIcon* _tmp77_;
	GIcon* _tmp78_;
	gchar* _tmp79_;
	const gchar* _tmp80_;
	const gchar* _tmp81_;
	SynapseQueryFlags _tmp82_;
	SynapseQueryFlags _tmp83_;
	SynapseQueryFlags query_type;
	SynapseMatch* match_obj;
	ZeitgeistEvent* _tmp84_;
	const gchar* _tmp85_;
	const gchar* _tmp86_;
	SynapseQueryFlags _tmp87_;
	SynapseMatch* _tmp88_;
	gboolean match_found;
	GeeList* _matcher_list;
	GeeList* _tmp89_;
	GeeList* _tmp90_;
	gint _matcher_size;
	GeeList* _tmp91_;
	gint _tmp92_;
	gint _tmp93_;
	gint _matcher_index;
	gint _tmp94_;
	gint _tmp95_;
	GeeMapEntry* matcher;
	GeeList* _tmp96_;
	gpointer _tmp97_;
	gchar* adjusted_title;
	const gchar* _tmp98_;
	SynapseMatch* _tmp99_;
	const gchar* _tmp100_;
	const gchar* _tmp101_;
	const gchar* _tmp102_;
	gchar* _tmp103_;
	const gchar* _tmp104_;
	const gchar* _tmp105_;
	SynapseMatch* _tmp106_;
	const gchar* _tmp107_;
	const gchar* _tmp108_;
	GeeMapEntry* _tmp109_;
	gconstpointer _tmp110_;
	gconstpointer _tmp111_;
	gint relevancy;
	const gchar* _tmp112_;
	GeeMapEntry* _tmp113_;
	gconstpointer _tmp114_;
	gconstpointer _tmp115_;
	SynapseResultSet* _tmp116_;
	SynapseMatch* _tmp117_;
	SynapseResultSet* _tmp118_;
	SynapseMatch* _tmp119_;
	GeeIterator* _entry_it;
	SynapseResultSet* _tmp120_;
	GeeSet* _tmp121_;
	GeeSet* _tmp122_;
	GeeSet* _tmp123_;
	GeeIterator* _tmp124_;
	GeeIterator* _tmp125_;
	GeeIterator* _tmp126_;
	GeeMapEntry* entry;
	GeeIterator* _tmp127_;
	gpointer _tmp128_;
	SynapseZeitgeistPluginZeitgeistUriMatch* mo;
	GeeMapEntry* _tmp129_;
	gconstpointer _tmp130_;
	gconstpointer _tmp131_;
	SynapseMatch* _tmp132_;
	gboolean _tmp133_;
	gboolean _tmp134_;
	SynapseZeitgeistPluginZeitgeistUriMatch* _tmp135_;
	const gchar* _tmp136_;
	const gchar* _tmp137_;
	SynapseZeitgeistPluginZeitgeistUriMatch* _tmp138_;
	const gchar* _tmp139_;
	const gchar* _tmp140_;
	glong len;
	SynapseZeitgeistPluginZeitgeistUriMatch* _tmp141_;
	const gchar* _tmp142_;
	const gchar* _tmp143_;
	gint _tmp144_;
	gint _tmp145_;
	gfloat mult;
	gint adjusted_relevancy;
	GeeMapEntry* _tmp146_;
	gconstpointer _tmp147_;
	gconstpointer _tmp148_;
	SynapseZeitgeistPluginZeitgeistUriMatch* _tmp149_;
	const gchar* _tmp150_;
	const gchar* _tmp151_;
	SynapseZeitgeistPluginZeitgeistUriMatch* _tmp152_;
	SynapseZeitgeistPluginZeitgeistUriMatch* _tmp153_;
	GeeMapEntry* _tmp154_;
	gconstpointer _tmp155_;
	gconstpointer _tmp156_;
	GError* _inner_error0_;
};

struct _SynapseZeitgeistPluginProcessRecentResultsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseZeitgeistPlugin* self;
	ZeitgeistResultSet* events;
	GCancellable* cancellable;
	SynapseResultSet* results;
	gboolean local_only;
	gboolean places_search;
	GeeSet* uris;
	GeeHashSet* _tmp0_;
	guint events_size;
	guint event_index;
	ZeitgeistResultSet* _event_it;
	ZeitgeistResultSet* _tmp1_;
	ZeitgeistEvent* event;
	ZeitgeistResultSet* _tmp2_;
	ZeitgeistEvent* _tmp3_;
	ZeitgeistEvent* _tmp4_;
	guint _tmp5_;
	ZeitgeistEvent* _tmp6_;
	ZeitgeistSubject* subject;
	ZeitgeistEvent* _tmp7_;
	ZeitgeistSubject* _tmp8_;
	const gchar* _tmp9_;
	ZeitgeistSubject* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	ZeitgeistSubject* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* uri;
	gboolean _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GeeSet* _tmp19_;
	const gchar* _tmp20_;
	gboolean is_application;
	const gchar* _tmp21_;
	gint relevancy_penalty;
	gchar* thumbnail_path;
	gchar* icon;
	GeeSet* _tmp22_;
	const gchar* _tmp23_;
	GFile* f;
	const gchar* _tmp24_;
	GFile* _tmp25_;
	GFile* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gboolean _tmp29_;
	GFile* _tmp30_;
	GFileInfo* fi;
	GFile* _tmp31_;
	const gchar* _tmp32_;
	GFileInfo* _tmp33_;
	GFileInfo* _tmp34_;
	GIcon* _tmp35_;
	gchar* _tmp36_;
	GFileInfo* _tmp37_;
	GFileInfo* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	GFileInfo* _tmp41_;
	gboolean _tmp42_;
	SynapseDesktopFileService* dfs;
	SynapseDesktopFileService* _tmp43_;
	SynapseDesktopFileService* _tmp44_;
	const gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	SynapseDesktopFileInfo* _tmp48_;
	SynapseDesktopFileInfo* _tmp49_;
	gboolean _tmp50_;
	const gchar* mimetype;
	ZeitgeistSubject* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	gboolean _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	GIcon* _tmp58_;
	GIcon* _tmp59_;
	gchar* _tmp60_;
	SynapseQueryFlags _tmp61_;
	SynapseQueryFlags _tmp62_;
	SynapseQueryFlags query_type;
	SynapseMatch* match_obj;
	ZeitgeistEvent* _tmp63_;
	const gchar* _tmp64_;
	const gchar* _tmp65_;
	SynapseQueryFlags _tmp66_;
	SynapseMatch* _tmp67_;
	SynapseMatch* _tmp68_;
	ZeitgeistEvent* _tmp69_;
	gint relevancy;
	SynapseMatch* _tmp70_;
	GError* _inner_error0_;
};

struct _Block9Data {
	int _ref_count_;
	SynapseZeitgeistPlugin* self;
	gpointer _async_data_;
};

struct _SynapseZeitgeistPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseZeitgeistPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	Block9Data* _data9_;
	gchar* search_query;
	SynapseQuery _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean empty_query;
	const gchar* _tmp3_;
	SynapseQuery _tmp4_;
	SynapseQueryFlags _tmp5_;
	GTimer* timer;
	GTimer* _tmp6_;
	GPtrArray* templates;
	GPtrArray* _tmp7_;
	GPtrArray* event_templates;
	SynapseQuery _tmp8_;
	SynapseQueryFlags _tmp9_;
	GPtrArray* _tmp10_;
	GPtrArray* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint i;
	gboolean _tmp14_;
	gint _tmp15_;
	GPtrArray* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GPtrArray* _tmp19_;
	GPtrArray* _tmp20_;
	gconstpointer _tmp21_;
	ZeitgeistEvent* _tmp22_;
	SynapseResultSet* _result_;
	SynapseResultSet* _tmp23_;
	gulong sig_id;
	gulong _tmp24_;
	ZeitgeistResultSet* rs;
	gboolean only_local;
	SynapseQuery _tmp25_;
	SynapseQueryFlags _tmp26_;
	gboolean places_search;
	SynapseQuery _tmp27_;
	SynapseQueryFlags _tmp28_;
	ZeitgeistResultType _tmp29_;
	ZeitgeistResultType rt;
	gint64 start_ts;
	GDateTime* _tmp30_;
	GDateTime* _tmp31_;
	gint64 _tmp32_;
	ZeitgeistResultSet* _tmp33_;
	ZeitgeistLog* _tmp34_;
	ZeitgeistTimeRange* _tmp35_;
	ZeitgeistTimeRange* _tmp36_;
	GPtrArray* _tmp37_;
	SynapseQuery _tmp38_;
	ZeitgeistResultType _tmp39_;
	ZeitgeistResultSet* _tmp40_;
	ZeitgeistResultSet* _tmp41_;
	ZeitgeistResultSet* _tmp42_;
	ZeitgeistResultSet* _tmp43_;
	SynapseQuery _tmp44_;
	GCancellable* _tmp45_;
	SynapseResultSet* _tmp46_;
	gchar** words;
	const gchar* _tmp47_;
	gchar** _tmp48_;
	gchar** _tmp49_;
	gint words_length1;
	gint _words_size_;
	gchar** _tmp50_;
	gint _tmp50__length1;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	ZeitgeistResultSet* _tmp54_;
	ZeitgeistIndex* _tmp55_;
	const gchar* _tmp56_;
	ZeitgeistTimeRange* _tmp57_;
	ZeitgeistTimeRange* _tmp58_;
	GPtrArray* _tmp59_;
	SynapseQuery _tmp60_;
	ZeitgeistResultType _tmp61_;
	ZeitgeistResultSet* _tmp62_;
	ZeitgeistResultSet* _tmp63_;
	ZeitgeistResultSet* _tmp64_;
	SynapseQuery _tmp65_;
	const gchar* _tmp66_;
	ZeitgeistResultSet* _tmp67_;
	SynapseQuery _tmp68_;
	GCancellable* _tmp69_;
	SynapseResultSet* _tmp70_;
	GError* err;
	GError* _tmp71_;
	const gchar* _tmp72_;
	GTimer* _tmp73_;
	GError* _inner_error0_;
};

struct _SynapseZeitgeistPluginZeitgeistApplicationMatch {
	SynapseApplicationMatch parent_instance;
	SynapseZeitgeistPluginZeitgeistApplicationMatchPrivate * priv;
};

struct _SynapseZeitgeistPluginZeitgeistApplicationMatchClass {
	SynapseApplicationMatchClass parent_class;
};

struct _SynapseZeitgeistPluginZeitgeistApplicationMatchPrivate {
	gchar* _extended_info;
};

struct _SynapseZeitgeistPluginZeitgeistUriMatch {
	SynapseUriMatch parent_instance;
	SynapseZeitgeistPluginZeitgeistUriMatchPrivate * priv;
};

struct _SynapseZeitgeistPluginZeitgeistUriMatchClass {
	SynapseUriMatchClass parent_class;
};

struct _SynapseZeitgeistPluginZeitgeistUriMatchPrivate {
	gchar* _extended_info;
};

struct _SynapseZeitgeistPluginZeitgeistMatchFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SynapseZeitgeistPluginZeitgeistMatchFactoryPrivate * priv;
};

struct _SynapseZeitgeistPluginZeitgeistMatchFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (SynapseZeitgeistPluginZeitgeistMatchFactory *self);
};

struct _SynapseZeitgeistPluginParamSpecZeitgeistMatchFactory {
	GParamSpec parent_instance;
};

static gint SynapseZeitgeistPlugin_private_offset;
static gpointer synapse_zeitgeist_plugin_parent_class = NULL;
static gchar* synapse_zeitgeist_plugin_interesting_attributes;
static gchar* synapse_zeitgeist_plugin_interesting_attributes = NULL;
static gint SynapseZeitgeistPluginZeitgeistApplicationMatch_private_offset;
static gpointer synapse_zeitgeist_plugin_zeitgeist_application_match_parent_class = NULL;
static SynapseExtendedInfoIface * synapse_zeitgeist_plugin_zeitgeist_application_match_synapse_extended_info_parent_iface = NULL;
static gint SynapseZeitgeistPluginZeitgeistUriMatch_private_offset;
static gpointer synapse_zeitgeist_plugin_zeitgeist_uri_match_parent_class = NULL;
static SynapseExtendedInfoIface * synapse_zeitgeist_plugin_zeitgeist_uri_match_synapse_extended_info_parent_iface = NULL;
static gpointer synapse_zeitgeist_plugin_zeitgeist_match_factory_parent_class = NULL;
static SynapseActivatableIface * synapse_zeitgeist_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_zeitgeist_plugin_synapse_item_provider_parent_iface = NULL;

GType synapse_zeitgeist_plugin_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseZeitgeistPlugin, g_object_unref)
#define SYNAPSE_ZEITGEIST_PLUGIN_UNIQUE_NAME "org.gnome.zeitgeist.Engine"
static void synapse_zeitgeist_plugin_real_activate (SynapseActivatable* base);
static void synapse_zeitgeist_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_zeitgeist_plugin_register_plugin (void);
static void _synapse_zeitgeist_plugin_register_plugin_synapse_plugin_register_func (void);
static gint synapse_zeitgeist_plugin_compute_relevancy (const gchar* uri,
                                                 gint base_relevancy);
static void synapse_zeitgeist_plugin_update_min_max (const gchar* uri,
                                              glong* minimum,
                                              glong* maximum);
static void synapse_zeitgeist_plugin_process_results_data_free (gpointer _data);
void synapse_zeitgeist_plugin_process_results (const gchar* query,
                                               ZeitgeistResultSet* events,
                                               GCancellable* cancellable,
                                               SynapseResultSet* real_results,
                                               gboolean local_only,
                                               gboolean places_search,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
void synapse_zeitgeist_plugin_process_results_finish (GAsyncResult* _res_);
static gboolean synapse_zeitgeist_plugin_process_results_co (SynapseZeitgeistPluginProcessResultsData* _data_);
static void synapse_zeitgeist_plugin_process_results_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static SynapseMatch* synapse_zeitgeist_plugin_zeitgeist_match_factory_get_match_for_event (ZeitgeistEvent* event,
                                                                                    const gchar* thumbnail_path,
                                                                                    const gchar* icon,
                                                                                    SynapseQueryFlags obj_type);
static GType synapse_zeitgeist_plugin_zeitgeist_uri_match_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseZeitgeistPluginZeitgeistUriMatch, g_object_unref)
static void synapse_zeitgeist_plugin_process_recent_results_data_free (gpointer _data);
static void synapse_zeitgeist_plugin_process_recent_results (SynapseZeitgeistPlugin* self,
                                                      ZeitgeistResultSet* events,
                                                      GCancellable* cancellable,
                                                      SynapseResultSet* results,
                                                      gboolean local_only,
                                                      gboolean places_search,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static void synapse_zeitgeist_plugin_process_recent_results_finish (SynapseZeitgeistPlugin* self,
                                                             GAsyncResult* _res_);
static gboolean synapse_zeitgeist_plugin_process_recent_results_co (SynapseZeitgeistPluginProcessRecentResultsData* _data_);
static void synapse_zeitgeist_plugin_process_recent_results_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_);
static void synapse_zeitgeist_plugin_zeitgeist_match_factory_init_extended_info_from_event (SynapseExtendedInfo* match,
                                                                                     ZeitgeistEvent* event);
GPtrArray* synapse_zeitgeist_plugin_create_templates (SynapseQueryFlags flags);
static void _g_object_unref0_ (gpointer var);
static gboolean synapse_zeitgeist_plugin_real_handles_empty_query (SynapseItemProvider* base);
static void synapse_zeitgeist_plugin_real_search_data_free (gpointer _data);
static void synapse_zeitgeist_plugin_real_search (SynapseItemProvider* base,
                                           SynapseQuery* q,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean synapse_zeitgeist_plugin_real_search_co (SynapseZeitgeistPluginSearchData* _data_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void ___lambda31_ (Block9Data* _data9_);
static void ____lambda31__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void synapse_zeitgeist_plugin_search_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
SynapseZeitgeistPlugin* synapse_zeitgeist_plugin_new (void);
SynapseZeitgeistPlugin* synapse_zeitgeist_plugin_construct (GType object_type);
SynapseDataSink* synapse_zeitgeist_plugin_get_data_sink (SynapseZeitgeistPlugin* self);
void synapse_zeitgeist_plugin_set_data_sink (SynapseZeitgeistPlugin* self,
                                             SynapseDataSink* value);
static GType synapse_zeitgeist_plugin_zeitgeist_application_match_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseZeitgeistPluginZeitgeistApplicationMatch, g_object_unref)
static SynapseZeitgeistPluginZeitgeistApplicationMatch* synapse_zeitgeist_plugin_zeitgeist_application_match_new (ZeitgeistEvent* event,
                                                                                                           const gchar* thumbnail_path,
                                                                                                           const gchar* icon);
static SynapseZeitgeistPluginZeitgeistApplicationMatch* synapse_zeitgeist_plugin_zeitgeist_application_match_construct (GType object_type,
                                                                                                                 ZeitgeistEvent* event,
                                                                                                                 const gchar* thumbnail_path,
                                                                                                                 const gchar* icon);
static void synapse_zeitgeist_plugin_zeitgeist_application_match_finalize (GObject * obj);
static GType synapse_zeitgeist_plugin_zeitgeist_application_match_get_type_once (void);
static void _vala_synapse_zeitgeist_plugin_zeitgeist_application_match_get_property (GObject * object,
                                                                              guint property_id,
                                                                              GValue * value,
                                                                              GParamSpec * pspec);
static void _vala_synapse_zeitgeist_plugin_zeitgeist_application_match_set_property (GObject * object,
                                                                              guint property_id,
                                                                              const GValue * value,
                                                                              GParamSpec * pspec);
static SynapseZeitgeistPluginZeitgeistUriMatch* synapse_zeitgeist_plugin_zeitgeist_uri_match_new (ZeitgeistEvent* event,
                                                                                           const gchar* thumbnail_path,
                                                                                           const gchar* icon,
                                                                                           gboolean use_origin);
static SynapseZeitgeistPluginZeitgeistUriMatch* synapse_zeitgeist_plugin_zeitgeist_uri_match_construct (GType object_type,
                                                                                                 ZeitgeistEvent* event,
                                                                                                 const gchar* thumbnail_path,
                                                                                                 const gchar* icon,
                                                                                                 gboolean use_origin);
static void synapse_zeitgeist_plugin_zeitgeist_uri_match_init_from_event (SynapseZeitgeistPluginZeitgeistUriMatch* self,
                                                                   ZeitgeistEvent* event,
                                                                   gboolean use_origin);
static void synapse_zeitgeist_plugin_zeitgeist_uri_match_finalize (GObject * obj);
static GType synapse_zeitgeist_plugin_zeitgeist_uri_match_get_type_once (void);
static void _vala_synapse_zeitgeist_plugin_zeitgeist_uri_match_get_property (GObject * object,
                                                                      guint property_id,
                                                                      GValue * value,
                                                                      GParamSpec * pspec);
static void _vala_synapse_zeitgeist_plugin_zeitgeist_uri_match_set_property (GObject * object,
                                                                      guint property_id,
                                                                      const GValue * value,
                                                                      GParamSpec * pspec);
static gpointer synapse_zeitgeist_plugin_zeitgeist_match_factory_ref (gpointer instance);
static void synapse_zeitgeist_plugin_zeitgeist_match_factory_unref (gpointer instance);
static GParamSpec* synapse_zeitgeist_plugin_param_spec_zeitgeist_match_factory (const gchar* name,
                                                                         const gchar* nick,
                                                                         const gchar* blurb,
                                                                         GType object_type,
                                                                         GParamFlags flags) G_GNUC_UNUSED;
static void synapse_zeitgeist_plugin_value_set_zeitgeist_match_factory (GValue* value,
                                                                 gpointer v_object) G_GNUC_UNUSED;
static void synapse_zeitgeist_plugin_value_take_zeitgeist_match_factory (GValue* value,
                                                                  gpointer v_object) G_GNUC_UNUSED;
static gpointer synapse_zeitgeist_plugin_value_get_zeitgeist_match_factory (const GValue* value) G_GNUC_UNUSED;
static GType synapse_zeitgeist_plugin_zeitgeist_match_factory_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseZeitgeistPluginZeitgeistMatchFactory, synapse_zeitgeist_plugin_zeitgeist_match_factory_unref)
static SynapseZeitgeistPluginZeitgeistMatchFactory* synapse_zeitgeist_plugin_zeitgeist_match_factory_new (void);
static SynapseZeitgeistPluginZeitgeistMatchFactory* synapse_zeitgeist_plugin_zeitgeist_match_factory_construct (GType object_type);
static void synapse_zeitgeist_plugin_zeitgeist_match_factory_finalize (SynapseZeitgeistPluginZeitgeistMatchFactory * obj);
static GType synapse_zeitgeist_plugin_zeitgeist_match_factory_get_type_once (void);
static GObject * synapse_zeitgeist_plugin_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void synapse_zeitgeist_plugin_finalize (GObject * obj);
static GType synapse_zeitgeist_plugin_get_type_once (void);
static void _vala_synapse_zeitgeist_plugin_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_synapse_zeitgeist_plugin_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
synapse_zeitgeist_plugin_get_instance_private (SynapseZeitgeistPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseZeitgeistPlugin_private_offset);
}

static void
synapse_zeitgeist_plugin_real_activate (SynapseActivatable* base)
{
	SynapseZeitgeistPlugin * self;
	ZeitgeistLog* _tmp0_;
	ZeitgeistIndex* _tmp1_;
#line 28 "../../../src/plugins/zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPlugin*) base;
#line 30 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp0_ = zeitgeist_log_new ();
#line 30 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (self->priv->zg_log);
#line 30 "../../../src/plugins/zeitgeist-plugin.vala"
	self->priv->zg_log = _tmp0_;
#line 31 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp1_ = zeitgeist_index_new ();
#line 31 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (self->priv->zg_index);
#line 31 "../../../src/plugins/zeitgeist-plugin.vala"
	self->priv->zg_index = _tmp1_;
#line 782 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseZeitgeistPlugin * self;
#line 34 "../../../src/plugins/zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPlugin*) base;
#line 791 "zeitgeist-plugin.c"
}

static void
_synapse_zeitgeist_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 193 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_register_plugin ();
#line 799 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_register_plugin (void)
{
	SynapsePluginRegistry* _tmp0_;
	SynapsePluginRegistry* _tmp1_;
	SynapseDBusService* _tmp2_;
	SynapseDBusService* _tmp3_;
#line 193 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp0_ = synapse_plugin_registry_get_default ();
#line 193 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp1_ = _tmp0_;
#line 193 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp2_ = synapse_dbus_service_get_default ();
#line 193 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp3_ = _tmp2_;
#line 193 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_ZEITGEIST_PLUGIN, "Zeitgeist", _ ("Search various items logged by Zeitgeist."), "zeitgeist", _synapse_zeitgeist_plugin_register_plugin_synapse_plugin_register_func, synapse_dbus_service_name_is_activatable (_tmp3_, SYNAPSE_ZEITGEIST_PLUGIN_UNIQUE_NAME), _ ("Zeitgeist is not installed"));
#line 193 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (_tmp3_);
#line 193 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (_tmp1_);
#line 823 "zeitgeist-plugin.c"
}

static gint
synapse_zeitgeist_plugin_compute_relevancy (const gchar* uri,
                                            gint base_relevancy)
{
	SynapseRelevancyService* rs = NULL;
	SynapseRelevancyService* _tmp0_;
	gfloat pop = 0.0F;
	gint result = 0;
#line 216 "../../../src/plugins/zeitgeist-plugin.vala"
	g_return_val_if_fail (uri != NULL, 0);
#line 218 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp0_ = synapse_relevancy_service_get_default ();
#line 218 "../../../src/plugins/zeitgeist-plugin.vala"
	rs = _tmp0_;
#line 219 "../../../src/plugins/zeitgeist-plugin.vala"
	pop = synapse_relevancy_service_get_uri_popularity (rs, uri);
#line 221 "../../../src/plugins/zeitgeist-plugin.vala"
	result = synapse_relevancy_service_compute_relevancy (base_relevancy, pop);
#line 221 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (rs);
#line 221 "../../../src/plugins/zeitgeist-plugin.vala"
	return result;
#line 848 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_update_min_max (const gchar* uri,
                                         glong* minimum,
                                         glong* maximum)
{
	glong len = 0L;
	gint _tmp0_;
	gint _tmp1_;
#line 224 "../../../src/plugins/zeitgeist-plugin.vala"
	g_return_if_fail (uri != NULL);
#line 227 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp0_ = strlen (uri);
#line 227 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp1_ = _tmp0_;
#line 227 "../../../src/plugins/zeitgeist-plugin.vala"
	len = (glong) _tmp1_;
#line 229 "../../../src/plugins/zeitgeist-plugin.vala"
	if (len > (*maximum)) {
#line 229 "../../../src/plugins/zeitgeist-plugin.vala"
		*maximum = len;
#line 871 "zeitgeist-plugin.c"
	}
#line 230 "../../../src/plugins/zeitgeist-plugin.vala"
	if (len < (*minimum)) {
#line 230 "../../../src/plugins/zeitgeist-plugin.vala"
		*minimum = len;
#line 877 "zeitgeist-plugin.c"
	}
}

static void
synapse_zeitgeist_plugin_process_results_data_free (gpointer _data)
{
	SynapseZeitgeistPluginProcessResultsData* _data_;
	_data_ = _data;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_free0 (_data_->query);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->events);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->cancellable);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->real_results);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	g_slice_free (SynapseZeitgeistPluginProcessResultsData, _data_);
#line 896 "zeitgeist-plugin.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 904 "zeitgeist-plugin.c"
}

void
synapse_zeitgeist_plugin_process_results (const gchar* query,
                                          ZeitgeistResultSet* events,
                                          GCancellable* cancellable,
                                          SynapseResultSet* real_results,
                                          gboolean local_only,
                                          gboolean places_search,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	SynapseZeitgeistPluginProcessResultsData* _data_;
	gchar* _tmp0_;
	ZeitgeistResultSet* _tmp1_;
	GCancellable* _tmp2_;
	SynapseResultSet* _tmp3_;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_ = g_slice_new0 (SynapseZeitgeistPluginProcessResultsData);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_zeitgeist_plugin_process_results_data_free);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp0_ = g_strdup (query);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_free0 (_data_->query);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->query = _tmp0_;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp1_ = _g_object_ref0 (events);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->events);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->events = _tmp1_;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->cancellable);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->cancellable = _tmp2_;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp3_ = _g_object_ref0 (real_results);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->real_results);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->real_results = _tmp3_;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->local_only = local_only;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->places_search = places_search;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_process_results_co (_data_);
#line 958 "zeitgeist-plugin.c"
}

void
synapse_zeitgeist_plugin_process_results_finish (GAsyncResult* _res_)
{
	SynapseZeitgeistPluginProcessResultsData* _data_;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	if (NULL == _data_) {
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
		return;
#line 971 "zeitgeist-plugin.c"
	}
}

static void
synapse_zeitgeist_plugin_process_results_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	SynapseZeitgeistPluginProcessResultsData* _data_;
#line 279 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_ = _user_data_;
#line 279 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_source_object_ = source_object;
#line 279 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_res_ = _res_;
#line 279 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_process_results_co (_data_);
#line 989 "zeitgeist-plugin.c"
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
#line 1447 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1447 "glib-2.0.vapi"
	end = _tmp0_;
#line 1448 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1448 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1449 "glib-2.0.vapi"
		result = maxlen;
#line 1449 "glib-2.0.vapi"
		return result;
#line 1012 "zeitgeist-plugin.c"
	} else {
		gchar* _tmp2_;
#line 1451 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1451 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1451 "glib-2.0.vapi"
		return result;
#line 1021 "zeitgeist-plugin.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
#line 1458 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1460 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 1040 "zeitgeist-plugin.c"
	} else {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1044 "zeitgeist-plugin.c"
	}
#line 1460 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1462 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 1050 "zeitgeist-plugin.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1464 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1464 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1464 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 1060 "zeitgeist-plugin.c"
	}
#line 1467 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1468 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1469 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 1068 "zeitgeist-plugin.c"
	} else {
#line 1471 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 1072 "zeitgeist-plugin.c"
	}
#line 1473 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1474 "glib-2.0.vapi"
		len = string_length - offset;
#line 1078 "zeitgeist-plugin.c"
	}
#line 1476 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1477 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1477 "glib-2.0.vapi"
	result = _tmp3_;
#line 1477 "glib-2.0.vapi"
	return result;
#line 1088 "zeitgeist-plugin.c"
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
#line 1133 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1133 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1134 "glib-2.0.vapi"
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1134 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1136 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1136 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 1112 "zeitgeist-plugin.c"
		gchar* _tmp2_;
#line 1137 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1137 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1137 "glib-2.0.vapi"
		return result;
#line 1120 "zeitgeist-plugin.c"
	} else {
#line 1139 "glib-2.0.vapi"
		result = -1;
#line 1139 "glib-2.0.vapi"
		return result;
#line 1126 "zeitgeist-plugin.c"
	}
}

static gboolean
synapse_zeitgeist_plugin_process_results_co (SynapseZeitgeistPluginProcessResultsData* _data_)
{
#line 240 "../../../src/plugins/zeitgeist-plugin.vala"
	switch (_data_->_state_) {
#line 240 "../../../src/plugins/zeitgeist-plugin.vala"
		case 0:
#line 1137 "zeitgeist-plugin.c"
		goto _state_0;
#line 240 "../../../src/plugins/zeitgeist-plugin.vala"
		case 1:
#line 1141 "zeitgeist-plugin.c"
		goto _state_1;
#line 240 "../../../src/plugins/zeitgeist-plugin.vala"
		case 2:
#line 1145 "zeitgeist-plugin.c"
		goto _state_2;
		default:
#line 240 "../../../src/plugins/zeitgeist-plugin.vala"
		g_assert_not_reached ();
#line 1150 "zeitgeist-plugin.c"
	}
	_state_0:
#line 244 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 244 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->uris = (GeeSet*) _data_->_tmp0_;
#line 246 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_tmp1_ = synapse_query_get_matchers_for_query (_data_->query, SYNAPSE_MATCHER_FLAGS_NO_FUZZY | SYNAPSE_MATCHER_FLAGS_NO_PARTIAL, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
#line 246 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->matchers = _data_->_tmp1_;
#line 252 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_tmp2_ = synapse_result_set_new ();
#line 252 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->results = _data_->_tmp2_;
#line 253 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->minimum = G_MAXLONG;
#line 254 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->maximum = (glong) 0;
#line 1169 "zeitgeist-plugin.c"
	{
#line 256 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->_tmp3_ = zeitgeist_result_set_iterator (_data_->events);
#line 256 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->_event_it = _data_->_tmp3_;
#line 256 "../../../src/plugins/zeitgeist-plugin.vala"
		while (TRUE) {
#line 256 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp4_ = _data_->_event_it;
#line 256 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp5_ = zeitgeist_result_set_next_value (_data_->_tmp4_);
#line 256 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->event);
#line 256 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->event = _data_->_tmp5_;
#line 256 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp6_ = _data_->event;
#line 256 "../../../src/plugins/zeitgeist-plugin.vala"
			if (!(_data_->_tmp6_ != NULL)) {
#line 256 "../../../src/plugins/zeitgeist-plugin.vala"
				break;
#line 1191 "zeitgeist-plugin.c"
			}
#line 258 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp7_ = _data_->event;
#line 258 "../../../src/plugins/zeitgeist-plugin.vala"
			if (zeitgeist_event_num_subjects (_data_->_tmp7_) <= 0) {
#line 258 "../../../src/plugins/zeitgeist-plugin.vala"
				continue;
#line 1199 "zeitgeist-plugin.c"
			}
#line 259 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp8_ = _data_->event;
#line 259 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp9_ = zeitgeist_event_get_subjects (_data_->_tmp8_);
#line 259 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp10_ = _data_->_tmp9_;
#line 259 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp11_ = g_ptr_array_index (_data_->_tmp10_, (guint) 0);
#line 259 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp12_ = _g_object_ref0 ((ZeitgeistSubject*) _data_->_tmp11_);
#line 259 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->subject = _data_->_tmp12_;
#line 260 "../../../src/plugins/zeitgeist-plugin.vala"
			if (_data_->places_search) {
#line 261 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp14_ = _data_->subject;
#line 261 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp15_ = zeitgeist_subject_get_origin (_data_->_tmp14_);
#line 261 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp16_ = _data_->_tmp15_;
#line 261 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp13_ = _data_->_tmp16_;
#line 1223 "zeitgeist-plugin.c"
			} else {
#line 261 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp17_ = _data_->subject;
#line 261 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp18_ = zeitgeist_subject_get_current_uri (_data_->_tmp17_);
#line 261 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp19_ = _data_->_tmp18_;
#line 261 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp13_ = _data_->_tmp19_;
#line 1233 "zeitgeist-plugin.c"
			}
#line 260 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->uri = _data_->_tmp13_;
#line 262 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp21_ = _data_->uri;
#line 262 "../../../src/plugins/zeitgeist-plugin.vala"
			if (_data_->_tmp21_ == NULL) {
#line 262 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp20_ = TRUE;
#line 1243 "zeitgeist-plugin.c"
			} else {
#line 262 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp22_ = _data_->uri;
#line 262 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp20_ = g_strcmp0 (_data_->_tmp22_, "") == 0;
#line 1249 "zeitgeist-plugin.c"
			}
#line 262 "../../../src/plugins/zeitgeist-plugin.vala"
			if (_data_->_tmp20_) {
#line 262 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_object_unref0 (_data_->subject);
#line 262 "../../../src/plugins/zeitgeist-plugin.vala"
				continue;
#line 1257 "zeitgeist-plugin.c"
			}
#line 264 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp23_ = _data_->uris;
#line 264 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp24_ = _data_->uri;
#line 264 "../../../src/plugins/zeitgeist-plugin.vala"
			if (!gee_collection_contains ((GeeCollection*) _data_->_tmp23_, _data_->_tmp24_)) {
#line 266 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp25_ = _data_->uri;
#line 266 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->is_application = g_str_has_prefix (_data_->_tmp25_, "application://");
#line 267 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->relevancy_penalty = (gint) SYNAPSE_MATCH_SCORE_URI_PENALTY;
#line 268 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->thumbnail_path = NULL;
#line 269 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->icon = NULL;
#line 270 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp26_ = _data_->uris;
#line 270 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp27_ = _data_->uri;
#line 270 "../../../src/plugins/zeitgeist-plugin.vala"
				gee_collection_add ((GeeCollection*) _data_->_tmp26_, _data_->_tmp27_);
#line 271 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp28_ = _data_->uri;
#line 271 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp29_ = g_file_new_for_uri (_data_->_tmp28_);
#line 271 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->f = _data_->_tmp29_;
#line 273 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp30_ = _data_->f;
#line 273 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp31_ = g_file_get_uri_scheme (_data_->_tmp30_);
#line 273 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp32_ = _data_->_tmp31_;
#line 273 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp33_ = g_strcmp0 (_data_->_tmp32_, "data") == 0;
#line 273 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_free0 (_data_->_tmp32_);
#line 273 "../../../src/plugins/zeitgeist-plugin.vala"
				if (_data_->_tmp33_) {
#line 273 "../../../src/plugins/zeitgeist-plugin.vala"
					_g_object_unref0 (_data_->f);
#line 273 "../../../src/plugins/zeitgeist-plugin.vala"
					_g_free0 (_data_->icon);
#line 273 "../../../src/plugins/zeitgeist-plugin.vala"
					_g_free0 (_data_->thumbnail_path);
#line 273 "../../../src/plugins/zeitgeist-plugin.vala"
					_g_object_unref0 (_data_->subject);
#line 273 "../../../src/plugins/zeitgeist-plugin.vala"
					continue;
#line 1309 "zeitgeist-plugin.c"
				}
#line 274 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp34_ = _data_->f;
#line 274 "../../../src/plugins/zeitgeist-plugin.vala"
				if (g_file_is_native (_data_->_tmp34_)) {
#line 1315 "zeitgeist-plugin.c"
					{
#line 279 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp35_ = _data_->f;
#line 279 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp36_ = synapse_zeitgeist_plugin_interesting_attributes;
#line 279 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_state_ = 1;
#line 279 "../../../src/plugins/zeitgeist-plugin.vala"
						g_file_query_info_async (_data_->_tmp35_, _data_->_tmp36_, 0, 0, _data_->cancellable, synapse_zeitgeist_plugin_process_results_ready, _data_);
#line 279 "../../../src/plugins/zeitgeist-plugin.vala"
						return FALSE;
#line 1327 "zeitgeist-plugin.c"
						_state_1:
#line 279 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp37_ = g_file_query_info_finish (_data_->_tmp35_, _data_->_res_, &_data_->_inner_error0_);
#line 279 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->fi = _data_->_tmp37_;
#line 279 "../../../src/plugins/zeitgeist-plugin.vala"
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 1335 "zeitgeist-plugin.c"
							goto __catch0_g_error;
						}
#line 283 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp38_ = _data_->fi;
#line 283 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp39_ = g_file_info_get_icon (_data_->_tmp38_);
#line 283 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp40_ = g_icon_to_string (_data_->_tmp39_);
#line 283 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_free0 (_data_->icon);
#line 283 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->icon = _data_->_tmp40_;
#line 284 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp41_ = _data_->fi;
#line 284 "../../../src/plugins/zeitgeist-plugin.vala"
						if (g_file_info_has_attribute (_data_->_tmp41_, G_FILE_ATTRIBUTE_THUMBNAIL_PATH)) {
#line 286 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp42_ = _data_->fi;
#line 286 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp43_ = g_file_info_get_attribute_byte_string (_data_->_tmp42_, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
#line 286 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp44_ = g_strdup (_data_->_tmp43_);
#line 286 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_free0 (_data_->thumbnail_path);
#line 286 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->thumbnail_path = _data_->_tmp44_;
#line 1362 "zeitgeist-plugin.c"
						}
#line 290 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp45_ = _data_->fi;
#line 290 "../../../src/plugins/zeitgeist-plugin.vala"
						if (g_file_info_get_is_hidden (_data_->_tmp45_)) {
#line 292 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->relevancy_penalty += (gint) SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM;
#line 1370 "zeitgeist-plugin.c"
						}
#line 276 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->fi);
#line 1374 "zeitgeist-plugin.c"
					}
					goto __finally0;
					__catch0_g_error:
					{
#line 276 "../../../src/plugins/zeitgeist-plugin.vala"
						g_clear_error (&_data_->_inner_error0_);
#line 297 "../../../src/plugins/zeitgeist-plugin.vala"
						if (g_cancellable_is_cancelled (_data_->cancellable)) {
#line 297 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->f);
#line 297 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_free0 (_data_->icon);
#line 297 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_free0 (_data_->thumbnail_path);
#line 297 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->subject);
#line 297 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->event);
#line 297 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->_event_it);
#line 297 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->results);
#line 297 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->matchers);
#line 297 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->uris);
#line 297 "../../../src/plugins/zeitgeist-plugin.vala"
							g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 297 "../../../src/plugins/zeitgeist-plugin.vala"
							if (_data_->_state_ != 0) {
#line 297 "../../../src/plugins/zeitgeist-plugin.vala"
								while (!g_task_get_completed (_data_->_async_result)) {
#line 297 "../../../src/plugins/zeitgeist-plugin.vala"
									g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1409 "zeitgeist-plugin.c"
								}
							}
#line 297 "../../../src/plugins/zeitgeist-plugin.vala"
							g_object_unref (_data_->_async_result);
#line 297 "../../../src/plugins/zeitgeist-plugin.vala"
							return FALSE;
#line 1416 "zeitgeist-plugin.c"
						} else {
#line 298 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->f);
#line 298 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_free0 (_data_->icon);
#line 298 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_free0 (_data_->thumbnail_path);
#line 298 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->subject);
#line 298 "../../../src/plugins/zeitgeist-plugin.vala"
							continue;
#line 1428 "zeitgeist-plugin.c"
						}
					}
					__finally0:
#line 276 "../../../src/plugins/zeitgeist-plugin.vala"
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 276 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->f);
#line 276 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_free0 (_data_->icon);
#line 276 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_free0 (_data_->thumbnail_path);
#line 276 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->subject);
#line 276 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->event);
#line 276 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->_event_it);
#line 276 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->results);
#line 276 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->matchers);
#line 276 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->uris);
#line 276 "../../../src/plugins/zeitgeist-plugin.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 276 "../../../src/plugins/zeitgeist-plugin.vala"
						g_clear_error (&_data_->_inner_error0_);
#line 276 "../../../src/plugins/zeitgeist-plugin.vala"
						g_object_unref (_data_->_async_result);
#line 276 "../../../src/plugins/zeitgeist-plugin.vala"
						return FALSE;
#line 1460 "zeitgeist-plugin.c"
					}
				} else {
#line 301 "../../../src/plugins/zeitgeist-plugin.vala"
					_data_->_tmp46_ = _data_->uri;
#line 301 "../../../src/plugins/zeitgeist-plugin.vala"
					if (g_str_has_prefix (_data_->_tmp46_, "note://tomboy/")) {
#line 304 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp47_ = _data_->uri;
#line 304 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp48_ = string_substring (_data_->_tmp47_, (glong) 14, (glong) -1);
#line 304 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp49_ = _data_->_tmp48_;
#line 304 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp50_ = g_strconcat (_data_->_tmp49_, ".note", NULL);
#line 304 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp51_ = _data_->_tmp50_;
#line 304 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_free0 (_data_->_tmp49_);
#line 304 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->note_filename = _data_->_tmp51_;
#line 305 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp52_ = g_get_user_data_dir ();
#line 305 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp53_ = _data_->note_filename;
#line 305 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp54_ = g_build_filename (_data_->_tmp52_, "tomboy", _data_->_tmp53_, NULL);
#line 305 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->note_path = _data_->_tmp54_;
#line 307 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp55_ = _data_->note_path;
#line 307 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp56_ = g_file_new_for_path (_data_->_tmp55_);
#line 307 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->note_f = _data_->_tmp56_;
#line 308 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp57_ = _data_->note_f;
#line 308 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_state_ = 2;
#line 308 "../../../src/plugins/zeitgeist-plugin.vala"
						synapse_utils_query_exists_async (_data_->_tmp57_, synapse_zeitgeist_plugin_process_results_ready, _data_);
#line 308 "../../../src/plugins/zeitgeist-plugin.vala"
						return FALSE;
#line 1503 "zeitgeist-plugin.c"
						_state_2:
#line 308 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->exists = synapse_utils_query_exists_finish (_data_->_res_);
#line 310 "../../../src/plugins/zeitgeist-plugin.vala"
						if (g_cancellable_is_cancelled (_data_->cancellable)) {
#line 310 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->note_f);
#line 310 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_free0 (_data_->note_path);
#line 310 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_free0 (_data_->note_filename);
#line 310 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->f);
#line 310 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_free0 (_data_->icon);
#line 310 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_free0 (_data_->thumbnail_path);
#line 310 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->subject);
#line 310 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->event);
#line 310 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->_event_it);
#line 310 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->results);
#line 310 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->matchers);
#line 310 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->uris);
#line 310 "../../../src/plugins/zeitgeist-plugin.vala"
							g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 310 "../../../src/plugins/zeitgeist-plugin.vala"
							if (_data_->_state_ != 0) {
#line 310 "../../../src/plugins/zeitgeist-plugin.vala"
								while (!g_task_get_completed (_data_->_async_result)) {
#line 310 "../../../src/plugins/zeitgeist-plugin.vala"
									g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1541 "zeitgeist-plugin.c"
								}
							}
#line 310 "../../../src/plugins/zeitgeist-plugin.vala"
							g_object_unref (_data_->_async_result);
#line 310 "../../../src/plugins/zeitgeist-plugin.vala"
							return FALSE;
#line 1548 "zeitgeist-plugin.c"
						} else {
#line 311 "../../../src/plugins/zeitgeist-plugin.vala"
							if (!_data_->exists) {
#line 311 "../../../src/plugins/zeitgeist-plugin.vala"
								_g_object_unref0 (_data_->note_f);
#line 311 "../../../src/plugins/zeitgeist-plugin.vala"
								_g_free0 (_data_->note_path);
#line 311 "../../../src/plugins/zeitgeist-plugin.vala"
								_g_free0 (_data_->note_filename);
#line 311 "../../../src/plugins/zeitgeist-plugin.vala"
								_g_object_unref0 (_data_->f);
#line 311 "../../../src/plugins/zeitgeist-plugin.vala"
								_g_free0 (_data_->icon);
#line 311 "../../../src/plugins/zeitgeist-plugin.vala"
								_g_free0 (_data_->thumbnail_path);
#line 311 "../../../src/plugins/zeitgeist-plugin.vala"
								_g_object_unref0 (_data_->subject);
#line 311 "../../../src/plugins/zeitgeist-plugin.vala"
								continue;
#line 1568 "zeitgeist-plugin.c"
							}
						}
#line 313 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp58_ = g_content_type_get_icon ("application/x-note");
#line 313 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp59_ = _data_->_tmp58_;
#line 313 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp60_ = g_icon_to_string (_data_->_tmp59_);
#line 313 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_free0 (_data_->icon);
#line 313 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->icon = _data_->_tmp60_;
#line 313 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->_tmp59_);
#line 301 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->note_f);
#line 301 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_free0 (_data_->note_path);
#line 301 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_free0 (_data_->note_filename);
#line 1589 "zeitgeist-plugin.c"
					} else {
#line 315 "../../../src/plugins/zeitgeist-plugin.vala"
						if (_data_->local_only) {
#line 315 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp61_ = !_data_->is_application;
#line 1595 "zeitgeist-plugin.c"
						} else {
#line 315 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp61_ = FALSE;
#line 1599 "zeitgeist-plugin.c"
						}
#line 315 "../../../src/plugins/zeitgeist-plugin.vala"
						if (_data_->_tmp61_) {
#line 317 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->f);
#line 317 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_free0 (_data_->icon);
#line 317 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_free0 (_data_->thumbnail_path);
#line 317 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->subject);
#line 317 "../../../src/plugins/zeitgeist-plugin.vala"
							continue;
#line 1613 "zeitgeist-plugin.c"
						} else {
#line 319 "../../../src/plugins/zeitgeist-plugin.vala"
							if (_data_->is_application) {
#line 321 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->_tmp62_ = synapse_desktop_file_service_get_default ();
#line 321 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->dfs = _data_->_tmp62_;
#line 322 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->_tmp63_ = _data_->dfs;
#line 322 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->_tmp64_ = _data_->uri;
#line 322 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->_tmp65_ = string_substring (_data_->_tmp64_, (glong) 14, (glong) -1);
#line 322 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->_tmp66_ = _data_->_tmp65_;
#line 322 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->_tmp67_ = synapse_desktop_file_service_get_desktop_file_for_id (_data_->_tmp63_, _data_->_tmp66_);
#line 322 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->_tmp68_ = _data_->_tmp67_;
#line 322 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->_tmp69_ = _data_->_tmp68_ == NULL;
#line 322 "../../../src/plugins/zeitgeist-plugin.vala"
								_g_object_unref0 (_data_->_tmp68_);
#line 322 "../../../src/plugins/zeitgeist-plugin.vala"
								_g_free0 (_data_->_tmp66_);
#line 322 "../../../src/plugins/zeitgeist-plugin.vala"
								if (_data_->_tmp69_) {
#line 322 "../../../src/plugins/zeitgeist-plugin.vala"
									_g_object_unref0 (_data_->dfs);
#line 322 "../../../src/plugins/zeitgeist-plugin.vala"
									_g_object_unref0 (_data_->f);
#line 322 "../../../src/plugins/zeitgeist-plugin.vala"
									_g_free0 (_data_->icon);
#line 322 "../../../src/plugins/zeitgeist-plugin.vala"
									_g_free0 (_data_->thumbnail_path);
#line 322 "../../../src/plugins/zeitgeist-plugin.vala"
									_g_object_unref0 (_data_->subject);
#line 322 "../../../src/plugins/zeitgeist-plugin.vala"
									continue;
#line 1653 "zeitgeist-plugin.c"
								}
#line 319 "../../../src/plugins/zeitgeist-plugin.vala"
								_g_object_unref0 (_data_->dfs);
#line 1657 "zeitgeist-plugin.c"
							} else {
#line 326 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->relevancy_penalty += (gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL;
#line 327 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->_tmp70_ = _data_->subject;
#line 327 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->_tmp71_ = zeitgeist_subject_get_mimetype (_data_->_tmp70_);
#line 327 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->_tmp72_ = _data_->_tmp71_;
#line 327 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->mimetype = _data_->_tmp72_;
#line 328 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->_tmp74_ = _data_->mimetype;
#line 328 "../../../src/plugins/zeitgeist-plugin.vala"
								if (_data_->_tmp74_ != NULL) {
#line 328 "../../../src/plugins/zeitgeist-plugin.vala"
									_data_->_tmp75_ = _data_->mimetype;
#line 328 "../../../src/plugins/zeitgeist-plugin.vala"
									_data_->_tmp73_ = g_strcmp0 (_data_->_tmp75_, "") != 0;
#line 1677 "zeitgeist-plugin.c"
								} else {
#line 328 "../../../src/plugins/zeitgeist-plugin.vala"
									_data_->_tmp73_ = FALSE;
#line 1681 "zeitgeist-plugin.c"
								}
#line 328 "../../../src/plugins/zeitgeist-plugin.vala"
								if (_data_->_tmp73_) {
#line 330 "../../../src/plugins/zeitgeist-plugin.vala"
									_data_->_tmp76_ = _data_->mimetype;
#line 330 "../../../src/plugins/zeitgeist-plugin.vala"
									_data_->_tmp77_ = g_content_type_get_icon (_data_->_tmp76_);
#line 330 "../../../src/plugins/zeitgeist-plugin.vala"
									_data_->_tmp78_ = _data_->_tmp77_;
#line 330 "../../../src/plugins/zeitgeist-plugin.vala"
									_data_->_tmp79_ = g_icon_to_string (_data_->_tmp78_);
#line 330 "../../../src/plugins/zeitgeist-plugin.vala"
									_g_free0 (_data_->icon);
#line 330 "../../../src/plugins/zeitgeist-plugin.vala"
									_data_->icon = _data_->_tmp79_;
#line 330 "../../../src/plugins/zeitgeist-plugin.vala"
									_g_object_unref0 (_data_->_tmp78_);
#line 1699 "zeitgeist-plugin.c"
								}
#line 333 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->_tmp80_ = _data_->uri;
#line 333 "../../../src/plugins/zeitgeist-plugin.vala"
								if (g_str_has_prefix (_data_->_tmp80_, "http")) {
#line 335 "../../../src/plugins/zeitgeist-plugin.vala"
									_data_->_tmp81_ = _data_->uri;
#line 335 "../../../src/plugins/zeitgeist-plugin.vala"
									synapse_zeitgeist_plugin_update_min_max (_data_->_tmp81_, &_data_->minimum, &_data_->maximum);
#line 1709 "zeitgeist-plugin.c"
								}
							}
						}
					}
				}
#line 339 "../../../src/plugins/zeitgeist-plugin.vala"
				if (_data_->is_application) {
#line 340 "../../../src/plugins/zeitgeist-plugin.vala"
					_data_->_tmp82_ = SYNAPSE_QUERY_FLAGS_APPLICATIONS;
#line 1719 "zeitgeist-plugin.c"
				} else {
#line 340 "../../../src/plugins/zeitgeist-plugin.vala"
					if (_data_->places_search) {
#line 341 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp83_ = SYNAPSE_QUERY_FLAGS_PLACES;
#line 1725 "zeitgeist-plugin.c"
					} else {
#line 341 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp83_ = SYNAPSE_QUERY_FLAGS_FILES;
#line 1729 "zeitgeist-plugin.c"
					}
#line 340 "../../../src/plugins/zeitgeist-plugin.vala"
					_data_->_tmp82_ = _data_->_tmp83_;
#line 1733 "zeitgeist-plugin.c"
				}
#line 339 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->query_type = _data_->_tmp82_;
#line 343 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp84_ = _data_->event;
#line 343 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp85_ = _data_->thumbnail_path;
#line 343 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp86_ = _data_->icon;
#line 343 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp87_ = _data_->query_type;
#line 343 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp88_ = synapse_zeitgeist_plugin_zeitgeist_match_factory_get_match_for_event (_data_->_tmp84_, _data_->_tmp85_, _data_->_tmp86_, _data_->_tmp87_);
#line 343 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->match_obj = _data_->_tmp88_;
#line 347 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->match_found = FALSE;
#line 1751 "zeitgeist-plugin.c"
				{
#line 348 "../../../src/plugins/zeitgeist-plugin.vala"
					_data_->_tmp89_ = _data_->matchers;
#line 348 "../../../src/plugins/zeitgeist-plugin.vala"
					_data_->_tmp90_ = _g_object_ref0 (_data_->_tmp89_);
#line 348 "../../../src/plugins/zeitgeist-plugin.vala"
					_data_->_matcher_list = _data_->_tmp90_;
#line 348 "../../../src/plugins/zeitgeist-plugin.vala"
					_data_->_tmp91_ = _data_->_matcher_list;
#line 348 "../../../src/plugins/zeitgeist-plugin.vala"
					_data_->_tmp92_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp91_);
#line 348 "../../../src/plugins/zeitgeist-plugin.vala"
					_data_->_tmp93_ = _data_->_tmp92_;
#line 348 "../../../src/plugins/zeitgeist-plugin.vala"
					_data_->_matcher_size = _data_->_tmp93_;
#line 348 "../../../src/plugins/zeitgeist-plugin.vala"
					_data_->_matcher_index = -1;
#line 348 "../../../src/plugins/zeitgeist-plugin.vala"
					while (TRUE) {
#line 348 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_matcher_index = _data_->_matcher_index + 1;
#line 348 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp94_ = _data_->_matcher_index;
#line 348 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp95_ = _data_->_matcher_size;
#line 348 "../../../src/plugins/zeitgeist-plugin.vala"
						if (!(_data_->_tmp94_ < _data_->_tmp95_)) {
#line 348 "../../../src/plugins/zeitgeist-plugin.vala"
							break;
#line 1781 "zeitgeist-plugin.c"
						}
#line 348 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp96_ = _data_->_matcher_list;
#line 348 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp97_ = gee_list_get (_data_->_tmp96_, _data_->_matcher_index);
#line 348 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->matcher = (GeeMapEntry*) _data_->_tmp97_;
#line 350 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->adjusted_title = NULL;
#line 351 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp98_ = _data_->uri;
#line 351 "../../../src/plugins/zeitgeist-plugin.vala"
						if (g_str_has_prefix (_data_->_tmp98_, "http")) {
#line 354 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp99_ = _data_->match_obj;
#line 354 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp100_ = synapse_match_get_title (_data_->_tmp99_);
#line 354 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp101_ = _data_->_tmp100_;
#line 354 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp102_ = _data_->uri;
#line 354 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp103_ = g_strdup_printf ("%s (%s)", _data_->_tmp101_, _data_->_tmp102_);
#line 354 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_free0 (_data_->adjusted_title);
#line 354 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->adjusted_title = _data_->_tmp103_;
#line 1809 "zeitgeist-plugin.c"
						}
#line 357 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp105_ = _data_->adjusted_title;
#line 357 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp104_ = _data_->_tmp105_;
#line 357 "../../../src/plugins/zeitgeist-plugin.vala"
						if (_data_->_tmp104_ == NULL) {
#line 357 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp106_ = _data_->match_obj;
#line 357 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp107_ = synapse_match_get_title (_data_->_tmp106_);
#line 357 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp108_ = _data_->_tmp107_;
#line 357 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp104_ = _data_->_tmp108_;
#line 1825 "zeitgeist-plugin.c"
						}
#line 357 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp109_ = _data_->matcher;
#line 357 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp110_ = gee_map_entry_get_key (_data_->_tmp109_);
#line 357 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp111_ = _data_->_tmp110_;
#line 357 "../../../src/plugins/zeitgeist-plugin.vala"
						if (g_regex_match ((GRegex*) _data_->_tmp111_, _data_->_tmp104_, 0, NULL)) {
#line 359 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp112_ = _data_->uri;
#line 359 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp113_ = _data_->matcher;
#line 359 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp114_ = gee_map_entry_get_value (_data_->_tmp113_);
#line 359 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp115_ = _data_->_tmp114_;
#line 359 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->relevancy = synapse_zeitgeist_plugin_compute_relevancy (_data_->_tmp112_, ((gint) ((gintptr) _data_->_tmp115_)) - _data_->relevancy_penalty);
#line 360 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp116_ = _data_->results;
#line 360 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp117_ = _data_->match_obj;
#line 360 "../../../src/plugins/zeitgeist-plugin.vala"
							synapse_result_set_add (_data_->_tmp116_, _data_->_tmp117_, _data_->relevancy);
#line 361 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->match_found = TRUE;
#line 362 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_free0 (_data_->adjusted_title);
#line 362 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->matcher);
#line 362 "../../../src/plugins/zeitgeist-plugin.vala"
							break;
#line 1859 "zeitgeist-plugin.c"
						}
#line 348 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_free0 (_data_->adjusted_title);
#line 348 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->matcher);
#line 1865 "zeitgeist-plugin.c"
					}
#line 348 "../../../src/plugins/zeitgeist-plugin.vala"
					_g_object_unref0 (_data_->_matcher_list);
#line 1869 "zeitgeist-plugin.c"
				}
#line 365 "../../../src/plugins/zeitgeist-plugin.vala"
				if (!_data_->match_found) {
#line 365 "../../../src/plugins/zeitgeist-plugin.vala"
					_data_->_tmp118_ = _data_->results;
#line 365 "../../../src/plugins/zeitgeist-plugin.vala"
					_data_->_tmp119_ = _data_->match_obj;
#line 365 "../../../src/plugins/zeitgeist-plugin.vala"
					synapse_result_set_add (_data_->_tmp118_, _data_->_tmp119_, (gint) (SYNAPSE_MATCH_SCORE_POOR + SYNAPSE_MATCH_SCORE_INCREMENT_MINOR));
#line 1879 "zeitgeist-plugin.c"
				}
#line 264 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_object_unref0 (_data_->match_obj);
#line 264 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_object_unref0 (_data_->f);
#line 264 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_free0 (_data_->icon);
#line 264 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_free0 (_data_->thumbnail_path);
#line 1889 "zeitgeist-plugin.c"
			}
#line 256 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->subject);
#line 1893 "zeitgeist-plugin.c"
		}
#line 256 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (_data_->event);
#line 256 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (_data_->_event_it);
#line 1899 "zeitgeist-plugin.c"
	}
	{
#line 369 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->_tmp120_ = _data_->results;
#line 369 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->_tmp121_ = synapse_result_set_get_entries (_data_->_tmp120_);
#line 369 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->_tmp122_ = _data_->_tmp121_;
#line 369 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->_tmp123_ = _data_->_tmp122_;
#line 369 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->_tmp124_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp123_);
#line 369 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->_tmp125_ = _data_->_tmp124_;
#line 369 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (_data_->_tmp123_);
#line 369 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->_entry_it = _data_->_tmp125_;
#line 369 "../../../src/plugins/zeitgeist-plugin.vala"
		while (TRUE) {
#line 369 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp126_ = _data_->_entry_it;
#line 369 "../../../src/plugins/zeitgeist-plugin.vala"
			if (!gee_iterator_next (_data_->_tmp126_)) {
#line 369 "../../../src/plugins/zeitgeist-plugin.vala"
				break;
#line 1926 "zeitgeist-plugin.c"
			}
#line 369 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp127_ = _data_->_entry_it;
#line 369 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp128_ = gee_iterator_get (_data_->_tmp127_);
#line 369 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->entry = (GeeMapEntry*) _data_->_tmp128_;
#line 371 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp129_ = _data_->entry;
#line 371 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp130_ = gee_map_entry_get_key (_data_->_tmp129_);
#line 371 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp131_ = _data_->_tmp130_;
#line 371 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp132_ = (SynapseMatch*) _data_->_tmp131_;
#line 371 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->mo = SYNAPSE_ZEITGEIST_PLUGIN_IS_ZEITGEIST_URI_MATCH (_data_->_tmp132_) ? ((SynapseZeitgeistPluginZeitgeistUriMatch*) _data_->_tmp132_) : NULL;
#line 372 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp135_ = _data_->mo;
#line 372 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp136_ = synapse_uri_match_get_uri ((SynapseUriMatch*) _data_->_tmp135_);
#line 372 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp137_ = _data_->_tmp136_;
#line 372 "../../../src/plugins/zeitgeist-plugin.vala"
			if (_data_->_tmp137_ != NULL) {
#line 372 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp138_ = _data_->mo;
#line 372 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp139_ = synapse_uri_match_get_uri ((SynapseUriMatch*) _data_->_tmp138_);
#line 372 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp140_ = _data_->_tmp139_;
#line 372 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp134_ = g_str_has_prefix (_data_->_tmp140_, "http");
#line 1960 "zeitgeist-plugin.c"
			} else {
#line 372 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp134_ = FALSE;
#line 1964 "zeitgeist-plugin.c"
			}
#line 372 "../../../src/plugins/zeitgeist-plugin.vala"
			if (_data_->_tmp134_) {
#line 372 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp133_ = _data_->minimum != _data_->maximum;
#line 1970 "zeitgeist-plugin.c"
			} else {
#line 372 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp133_ = FALSE;
#line 1974 "zeitgeist-plugin.c"
			}
#line 372 "../../../src/plugins/zeitgeist-plugin.vala"
			if (_data_->_tmp133_) {
#line 374 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp141_ = _data_->mo;
#line 374 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp142_ = synapse_uri_match_get_uri ((SynapseUriMatch*) _data_->_tmp141_);
#line 374 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp143_ = _data_->_tmp142_;
#line 374 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp144_ = strlen (_data_->_tmp143_);
#line 374 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp145_ = _data_->_tmp144_;
#line 374 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->len = (glong) _data_->_tmp145_;
#line 376 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->mult = (_data_->len - _data_->minimum) / ((gfloat) (_data_->maximum - _data_->minimum));
#line 377 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp146_ = _data_->entry;
#line 377 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp147_ = gee_map_entry_get_value (_data_->_tmp146_);
#line 377 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp148_ = _data_->_tmp147_;
#line 377 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->adjusted_relevancy = ((gint) ((gintptr) _data_->_tmp148_)) - ((gint) (_data_->mult * SYNAPSE_MATCH_SCORE_INCREMENT_MINOR));
#line 378 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp149_ = _data_->mo;
#line 378 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp150_ = synapse_uri_match_get_uri ((SynapseUriMatch*) _data_->_tmp149_);
#line 378 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp151_ = _data_->_tmp150_;
#line 378 "../../../src/plugins/zeitgeist-plugin.vala"
				if (string_index_of (_data_->_tmp151_, "?", 0) != -1) {
#line 378 "../../../src/plugins/zeitgeist-plugin.vala"
					_data_->adjusted_relevancy -= (gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL;
#line 2010 "zeitgeist-plugin.c"
				}
#line 379 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp152_ = _data_->mo;
#line 379 "../../../src/plugins/zeitgeist-plugin.vala"
				synapse_result_set_add (_data_->real_results, (SynapseMatch*) _data_->_tmp152_, _data_->adjusted_relevancy);
#line 2016 "zeitgeist-plugin.c"
			} else {
#line 383 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp153_ = _data_->mo;
#line 383 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp154_ = _data_->entry;
#line 383 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp155_ = gee_map_entry_get_value (_data_->_tmp154_);
#line 383 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp156_ = _data_->_tmp155_;
#line 383 "../../../src/plugins/zeitgeist-plugin.vala"
				synapse_result_set_add (_data_->real_results, (SynapseMatch*) _data_->_tmp153_, (gint) ((gintptr) _data_->_tmp156_));
#line 2028 "zeitgeist-plugin.c"
			}
#line 369 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->entry);
#line 2032 "zeitgeist-plugin.c"
		}
#line 369 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (_data_->_entry_it);
#line 2036 "zeitgeist-plugin.c"
	}
#line 240 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->results);
#line 240 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->matchers);
#line 240 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->uris);
#line 240 "../../../src/plugins/zeitgeist-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 240 "../../../src/plugins/zeitgeist-plugin.vala"
	if (_data_->_state_ != 0) {
#line 240 "../../../src/plugins/zeitgeist-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 240 "../../../src/plugins/zeitgeist-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2052 "zeitgeist-plugin.c"
		}
	}
#line 240 "../../../src/plugins/zeitgeist-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 240 "../../../src/plugins/zeitgeist-plugin.vala"
	return FALSE;
#line 2059 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_process_recent_results_data_free (gpointer _data)
{
	SynapseZeitgeistPluginProcessRecentResultsData* _data_;
	_data_ = _data;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->events);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->cancellable);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->results);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	g_slice_free (SynapseZeitgeistPluginProcessRecentResultsData, _data_);
#line 2077 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_process_recent_results (SynapseZeitgeistPlugin* self,
                                                 ZeitgeistResultSet* events,
                                                 GCancellable* cancellable,
                                                 SynapseResultSet* results,
                                                 gboolean local_only,
                                                 gboolean places_search,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	SynapseZeitgeistPluginProcessRecentResultsData* _data_;
	SynapseZeitgeistPlugin* _tmp0_;
	ZeitgeistResultSet* _tmp1_;
	GCancellable* _tmp2_;
	SynapseResultSet* _tmp3_;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_ = g_slice_new0 (SynapseZeitgeistPluginProcessRecentResultsData);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_zeitgeist_plugin_process_recent_results_data_free);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->self = _tmp0_;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp1_ = _g_object_ref0 (events);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->events);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->events = _tmp1_;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->cancellable);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->cancellable = _tmp2_;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp3_ = _g_object_ref0 (results);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->results);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->results = _tmp3_;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->local_only = local_only;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->places_search = places_search;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_process_recent_results_co (_data_);
#line 2129 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_process_recent_results_finish (SynapseZeitgeistPlugin* self,
                                                        GAsyncResult* _res_)
{
	SynapseZeitgeistPluginProcessRecentResultsData* _data_;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	if (NULL == _data_) {
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
		return;
#line 2143 "zeitgeist-plugin.c"
	}
}

static void
synapse_zeitgeist_plugin_process_recent_results_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_)
{
	SynapseZeitgeistPluginProcessRecentResultsData* _data_;
#line 423 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_ = _user_data_;
#line 423 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_source_object_ = source_object;
#line 423 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_res_ = _res_;
#line 423 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_process_recent_results_co (_data_);
#line 2161 "zeitgeist-plugin.c"
}

static gboolean
synapse_zeitgeist_plugin_process_recent_results_co (SynapseZeitgeistPluginProcessRecentResultsData* _data_)
{
#line 388 "../../../src/plugins/zeitgeist-plugin.vala"
	switch (_data_->_state_) {
#line 388 "../../../src/plugins/zeitgeist-plugin.vala"
		case 0:
#line 2171 "zeitgeist-plugin.c"
		goto _state_0;
#line 388 "../../../src/plugins/zeitgeist-plugin.vala"
		case 1:
#line 2175 "zeitgeist-plugin.c"
		goto _state_1;
		default:
#line 388 "../../../src/plugins/zeitgeist-plugin.vala"
		g_assert_not_reached ();
#line 2180 "zeitgeist-plugin.c"
	}
	_state_0:
#line 394 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 394 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->uris = (GeeSet*) _data_->_tmp0_;
#line 396 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->events_size = zeitgeist_result_set_size (_data_->events);
#line 397 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->event_index = (guint) 0;
#line 2191 "zeitgeist-plugin.c"
	{
#line 399 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->_tmp1_ = zeitgeist_result_set_iterator (_data_->events);
#line 399 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->_event_it = _data_->_tmp1_;
#line 399 "../../../src/plugins/zeitgeist-plugin.vala"
		while (TRUE) {
#line 399 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp2_ = _data_->_event_it;
#line 399 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp3_ = zeitgeist_result_set_next_value (_data_->_tmp2_);
#line 399 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->event);
#line 399 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->event = _data_->_tmp3_;
#line 399 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp4_ = _data_->event;
#line 399 "../../../src/plugins/zeitgeist-plugin.vala"
			if (!(_data_->_tmp4_ != NULL)) {
#line 399 "../../../src/plugins/zeitgeist-plugin.vala"
				break;
#line 2213 "zeitgeist-plugin.c"
			}
#line 401 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp5_ = _data_->event_index;
#line 401 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->event_index = _data_->_tmp5_ + 1;
#line 402 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp6_ = _data_->event;
#line 402 "../../../src/plugins/zeitgeist-plugin.vala"
			if (zeitgeist_event_num_subjects (_data_->_tmp6_) <= 0) {
#line 402 "../../../src/plugins/zeitgeist-plugin.vala"
				continue;
#line 2225 "zeitgeist-plugin.c"
			}
#line 403 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp7_ = _data_->event;
#line 403 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp8_ = zeitgeist_event_get_subject (_data_->_tmp7_, 0);
#line 403 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->subject = _data_->_tmp8_;
#line 404 "../../../src/plugins/zeitgeist-plugin.vala"
			if (_data_->places_search) {
#line 405 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp10_ = _data_->subject;
#line 405 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp11_ = zeitgeist_subject_get_origin (_data_->_tmp10_);
#line 405 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp12_ = _data_->_tmp11_;
#line 405 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp9_ = _data_->_tmp12_;
#line 2243 "zeitgeist-plugin.c"
			} else {
#line 405 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp13_ = _data_->subject;
#line 405 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp14_ = zeitgeist_subject_get_current_uri (_data_->_tmp13_);
#line 405 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp15_ = _data_->_tmp14_;
#line 405 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp9_ = _data_->_tmp15_;
#line 2253 "zeitgeist-plugin.c"
			}
#line 404 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->uri = _data_->_tmp9_;
#line 406 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp17_ = _data_->uri;
#line 406 "../../../src/plugins/zeitgeist-plugin.vala"
			if (_data_->_tmp17_ == NULL) {
#line 406 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp16_ = TRUE;
#line 2263 "zeitgeist-plugin.c"
			} else {
#line 406 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp18_ = _data_->uri;
#line 406 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp16_ = g_strcmp0 (_data_->_tmp18_, "") == 0;
#line 2269 "zeitgeist-plugin.c"
			}
#line 406 "../../../src/plugins/zeitgeist-plugin.vala"
			if (_data_->_tmp16_) {
#line 406 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_object_unref0 (_data_->subject);
#line 406 "../../../src/plugins/zeitgeist-plugin.vala"
				continue;
#line 2277 "zeitgeist-plugin.c"
			}
#line 408 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp19_ = _data_->uris;
#line 408 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp20_ = _data_->uri;
#line 408 "../../../src/plugins/zeitgeist-plugin.vala"
			if (!gee_collection_contains ((GeeCollection*) _data_->_tmp19_, _data_->_tmp20_)) {
#line 410 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp21_ = _data_->uri;
#line 410 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->is_application = g_str_has_prefix (_data_->_tmp21_, "application://");
#line 411 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->relevancy_penalty = (gint) SYNAPSE_MATCH_SCORE_URI_PENALTY;
#line 412 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->thumbnail_path = NULL;
#line 413 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->icon = NULL;
#line 414 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp22_ = _data_->uris;
#line 414 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp23_ = _data_->uri;
#line 414 "../../../src/plugins/zeitgeist-plugin.vala"
				gee_collection_add ((GeeCollection*) _data_->_tmp22_, _data_->_tmp23_);
#line 415 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp24_ = _data_->uri;
#line 415 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp25_ = g_file_new_for_uri (_data_->_tmp24_);
#line 415 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->f = _data_->_tmp25_;
#line 417 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp26_ = _data_->f;
#line 417 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp27_ = g_file_get_uri_scheme (_data_->_tmp26_);
#line 417 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp28_ = _data_->_tmp27_;
#line 417 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp29_ = g_strcmp0 (_data_->_tmp28_, "data") == 0;
#line 417 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_free0 (_data_->_tmp28_);
#line 417 "../../../src/plugins/zeitgeist-plugin.vala"
				if (_data_->_tmp29_) {
#line 417 "../../../src/plugins/zeitgeist-plugin.vala"
					_g_object_unref0 (_data_->f);
#line 417 "../../../src/plugins/zeitgeist-plugin.vala"
					_g_free0 (_data_->icon);
#line 417 "../../../src/plugins/zeitgeist-plugin.vala"
					_g_free0 (_data_->thumbnail_path);
#line 417 "../../../src/plugins/zeitgeist-plugin.vala"
					_g_object_unref0 (_data_->subject);
#line 417 "../../../src/plugins/zeitgeist-plugin.vala"
					continue;
#line 2329 "zeitgeist-plugin.c"
				}
#line 418 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp30_ = _data_->f;
#line 418 "../../../src/plugins/zeitgeist-plugin.vala"
				if (g_file_is_native (_data_->_tmp30_)) {
#line 2335 "zeitgeist-plugin.c"
					{
#line 423 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp31_ = _data_->f;
#line 423 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp32_ = synapse_zeitgeist_plugin_interesting_attributes;
#line 423 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_state_ = 1;
#line 423 "../../../src/plugins/zeitgeist-plugin.vala"
						g_file_query_info_async (_data_->_tmp31_, _data_->_tmp32_, 0, 0, _data_->cancellable, synapse_zeitgeist_plugin_process_recent_results_ready, _data_);
#line 423 "../../../src/plugins/zeitgeist-plugin.vala"
						return FALSE;
#line 2347 "zeitgeist-plugin.c"
						_state_1:
#line 423 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp33_ = g_file_query_info_finish (_data_->_tmp31_, _data_->_res_, &_data_->_inner_error0_);
#line 423 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->fi = _data_->_tmp33_;
#line 423 "../../../src/plugins/zeitgeist-plugin.vala"
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 2355 "zeitgeist-plugin.c"
							goto __catch0_g_error;
						}
#line 427 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp34_ = _data_->fi;
#line 427 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp35_ = g_file_info_get_icon (_data_->_tmp34_);
#line 427 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp36_ = g_icon_to_string (_data_->_tmp35_);
#line 427 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_free0 (_data_->icon);
#line 427 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->icon = _data_->_tmp36_;
#line 428 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp37_ = _data_->fi;
#line 428 "../../../src/plugins/zeitgeist-plugin.vala"
						if (g_file_info_has_attribute (_data_->_tmp37_, G_FILE_ATTRIBUTE_THUMBNAIL_PATH)) {
#line 430 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp38_ = _data_->fi;
#line 430 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp39_ = g_file_info_get_attribute_byte_string (_data_->_tmp38_, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
#line 430 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp40_ = g_strdup (_data_->_tmp39_);
#line 430 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_free0 (_data_->thumbnail_path);
#line 430 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->thumbnail_path = _data_->_tmp40_;
#line 2382 "zeitgeist-plugin.c"
						}
#line 434 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp41_ = _data_->fi;
#line 434 "../../../src/plugins/zeitgeist-plugin.vala"
						if (g_file_info_get_is_hidden (_data_->_tmp41_)) {
#line 436 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->relevancy_penalty += (gint) SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM;
#line 2390 "zeitgeist-plugin.c"
						}
#line 420 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->fi);
#line 2394 "zeitgeist-plugin.c"
					}
					goto __finally0;
					__catch0_g_error:
					{
#line 420 "../../../src/plugins/zeitgeist-plugin.vala"
						g_clear_error (&_data_->_inner_error0_);
#line 441 "../../../src/plugins/zeitgeist-plugin.vala"
						if (g_cancellable_is_cancelled (_data_->cancellable)) {
#line 441 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->f);
#line 441 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_free0 (_data_->icon);
#line 441 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_free0 (_data_->thumbnail_path);
#line 441 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->subject);
#line 441 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->event);
#line 441 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->_event_it);
#line 441 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->uris);
#line 441 "../../../src/plugins/zeitgeist-plugin.vala"
							g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 441 "../../../src/plugins/zeitgeist-plugin.vala"
							if (_data_->_state_ != 0) {
#line 441 "../../../src/plugins/zeitgeist-plugin.vala"
								while (!g_task_get_completed (_data_->_async_result)) {
#line 441 "../../../src/plugins/zeitgeist-plugin.vala"
									g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2425 "zeitgeist-plugin.c"
								}
							}
#line 441 "../../../src/plugins/zeitgeist-plugin.vala"
							g_object_unref (_data_->_async_result);
#line 441 "../../../src/plugins/zeitgeist-plugin.vala"
							return FALSE;
#line 2432 "zeitgeist-plugin.c"
						} else {
#line 442 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->f);
#line 442 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_free0 (_data_->icon);
#line 442 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_free0 (_data_->thumbnail_path);
#line 442 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->subject);
#line 442 "../../../src/plugins/zeitgeist-plugin.vala"
							continue;
#line 2444 "zeitgeist-plugin.c"
						}
					}
					__finally0:
#line 420 "../../../src/plugins/zeitgeist-plugin.vala"
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 420 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->f);
#line 420 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_free0 (_data_->icon);
#line 420 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_free0 (_data_->thumbnail_path);
#line 420 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->subject);
#line 420 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->event);
#line 420 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->_event_it);
#line 420 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->uris);
#line 420 "../../../src/plugins/zeitgeist-plugin.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 420 "../../../src/plugins/zeitgeist-plugin.vala"
						g_clear_error (&_data_->_inner_error0_);
#line 420 "../../../src/plugins/zeitgeist-plugin.vala"
						g_object_unref (_data_->_async_result);
#line 420 "../../../src/plugins/zeitgeist-plugin.vala"
						return FALSE;
#line 2472 "zeitgeist-plugin.c"
					}
				} else {
#line 445 "../../../src/plugins/zeitgeist-plugin.vala"
					if (_data_->local_only) {
#line 445 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp42_ = !_data_->is_application;
#line 2479 "zeitgeist-plugin.c"
					} else {
#line 445 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp42_ = FALSE;
#line 2483 "zeitgeist-plugin.c"
					}
#line 445 "../../../src/plugins/zeitgeist-plugin.vala"
					if (_data_->_tmp42_) {
#line 447 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->f);
#line 447 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_free0 (_data_->icon);
#line 447 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_free0 (_data_->thumbnail_path);
#line 447 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_object_unref0 (_data_->subject);
#line 447 "../../../src/plugins/zeitgeist-plugin.vala"
						continue;
#line 2497 "zeitgeist-plugin.c"
					} else {
#line 449 "../../../src/plugins/zeitgeist-plugin.vala"
						if (_data_->is_application) {
#line 451 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp43_ = synapse_desktop_file_service_get_default ();
#line 451 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->dfs = _data_->_tmp43_;
#line 452 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp44_ = _data_->dfs;
#line 452 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp45_ = _data_->uri;
#line 452 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp46_ = string_substring (_data_->_tmp45_, (glong) 14, (glong) -1);
#line 452 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp47_ = _data_->_tmp46_;
#line 452 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp48_ = synapse_desktop_file_service_get_desktop_file_for_id (_data_->_tmp44_, _data_->_tmp47_);
#line 452 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp49_ = _data_->_tmp48_;
#line 452 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp50_ = _data_->_tmp49_ == NULL;
#line 452 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->_tmp49_);
#line 452 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_free0 (_data_->_tmp47_);
#line 452 "../../../src/plugins/zeitgeist-plugin.vala"
							if (_data_->_tmp50_) {
#line 452 "../../../src/plugins/zeitgeist-plugin.vala"
								_g_object_unref0 (_data_->dfs);
#line 452 "../../../src/plugins/zeitgeist-plugin.vala"
								_g_object_unref0 (_data_->f);
#line 452 "../../../src/plugins/zeitgeist-plugin.vala"
								_g_free0 (_data_->icon);
#line 452 "../../../src/plugins/zeitgeist-plugin.vala"
								_g_free0 (_data_->thumbnail_path);
#line 452 "../../../src/plugins/zeitgeist-plugin.vala"
								_g_object_unref0 (_data_->subject);
#line 452 "../../../src/plugins/zeitgeist-plugin.vala"
								continue;
#line 2537 "zeitgeist-plugin.c"
							}
#line 449 "../../../src/plugins/zeitgeist-plugin.vala"
							_g_object_unref0 (_data_->dfs);
#line 2541 "zeitgeist-plugin.c"
						} else {
#line 456 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->relevancy_penalty += (gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL;
#line 457 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp51_ = _data_->subject;
#line 457 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp52_ = zeitgeist_subject_get_mimetype (_data_->_tmp51_);
#line 457 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp53_ = _data_->_tmp52_;
#line 457 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->mimetype = _data_->_tmp53_;
#line 458 "../../../src/plugins/zeitgeist-plugin.vala"
							_data_->_tmp55_ = _data_->mimetype;
#line 458 "../../../src/plugins/zeitgeist-plugin.vala"
							if (_data_->_tmp55_ != NULL) {
#line 458 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->_tmp56_ = _data_->mimetype;
#line 458 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->_tmp54_ = g_strcmp0 (_data_->_tmp56_, "") != 0;
#line 2561 "zeitgeist-plugin.c"
							} else {
#line 458 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->_tmp54_ = FALSE;
#line 2565 "zeitgeist-plugin.c"
							}
#line 458 "../../../src/plugins/zeitgeist-plugin.vala"
							if (_data_->_tmp54_) {
#line 460 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->_tmp57_ = _data_->mimetype;
#line 460 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->_tmp58_ = g_content_type_get_icon (_data_->_tmp57_);
#line 460 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->_tmp59_ = _data_->_tmp58_;
#line 460 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->_tmp60_ = g_icon_to_string (_data_->_tmp59_);
#line 460 "../../../src/plugins/zeitgeist-plugin.vala"
								_g_free0 (_data_->icon);
#line 460 "../../../src/plugins/zeitgeist-plugin.vala"
								_data_->icon = _data_->_tmp60_;
#line 460 "../../../src/plugins/zeitgeist-plugin.vala"
								_g_object_unref0 (_data_->_tmp59_);
#line 2583 "zeitgeist-plugin.c"
							}
						}
					}
				}
#line 464 "../../../src/plugins/zeitgeist-plugin.vala"
				if (_data_->is_application) {
#line 465 "../../../src/plugins/zeitgeist-plugin.vala"
					_data_->_tmp61_ = SYNAPSE_QUERY_FLAGS_APPLICATIONS;
#line 2592 "zeitgeist-plugin.c"
				} else {
#line 465 "../../../src/plugins/zeitgeist-plugin.vala"
					if (_data_->places_search) {
#line 466 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp62_ = SYNAPSE_QUERY_FLAGS_PLACES;
#line 2598 "zeitgeist-plugin.c"
					} else {
#line 466 "../../../src/plugins/zeitgeist-plugin.vala"
						_data_->_tmp62_ = SYNAPSE_QUERY_FLAGS_FILES;
#line 2602 "zeitgeist-plugin.c"
					}
#line 465 "../../../src/plugins/zeitgeist-plugin.vala"
					_data_->_tmp61_ = _data_->_tmp62_;
#line 2606 "zeitgeist-plugin.c"
				}
#line 464 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->query_type = _data_->_tmp61_;
#line 467 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp63_ = _data_->event;
#line 467 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp64_ = _data_->thumbnail_path;
#line 467 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp65_ = _data_->icon;
#line 467 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp66_ = _data_->query_type;
#line 467 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp67_ = synapse_zeitgeist_plugin_zeitgeist_match_factory_get_match_for_event (_data_->_tmp63_, _data_->_tmp64_, _data_->_tmp65_, _data_->_tmp66_);
#line 467 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->match_obj = _data_->_tmp67_;
#line 471 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp68_ = _data_->match_obj;
#line 471 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp69_ = _data_->event;
#line 471 "../../../src/plugins/zeitgeist-plugin.vala"
				synapse_zeitgeist_plugin_zeitgeist_match_factory_init_extended_info_from_event (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp68_, SYNAPSE_TYPE_EXTENDED_INFO, SynapseExtendedInfo), _data_->_tmp69_);
#line 473 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->relevancy = (gint) (((_data_->events_size - _data_->event_index) / ((gfloat) _data_->events_size)) * SYNAPSE_MATCH_SCORE_HIGHEST);
#line 475 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp70_ = _data_->match_obj;
#line 475 "../../../src/plugins/zeitgeist-plugin.vala"
				synapse_result_set_add (_data_->results, _data_->_tmp70_, _data_->relevancy);
#line 408 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_object_unref0 (_data_->match_obj);
#line 408 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_object_unref0 (_data_->f);
#line 408 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_free0 (_data_->icon);
#line 408 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_free0 (_data_->thumbnail_path);
#line 2642 "zeitgeist-plugin.c"
			}
#line 399 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->subject);
#line 2646 "zeitgeist-plugin.c"
		}
#line 399 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (_data_->event);
#line 399 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (_data_->_event_it);
#line 2652 "zeitgeist-plugin.c"
	}
#line 388 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->uris);
#line 388 "../../../src/plugins/zeitgeist-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 388 "../../../src/plugins/zeitgeist-plugin.vala"
	if (_data_->_state_ != 0) {
#line 388 "../../../src/plugins/zeitgeist-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 388 "../../../src/plugins/zeitgeist-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2664 "zeitgeist-plugin.c"
		}
	}
#line 388 "../../../src/plugins/zeitgeist-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 388 "../../../src/plugins/zeitgeist-plugin.vala"
	return FALSE;
#line 2671 "zeitgeist-plugin.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 483 "../../../src/plugins/zeitgeist-plugin.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 2679 "zeitgeist-plugin.c"
}

GPtrArray*
synapse_zeitgeist_plugin_create_templates (SynapseQueryFlags flags)
{
	GPtrArray* templates = NULL;
	GPtrArray* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* manifestation = NULL;
	gchar* _tmp2_;
	ZeitgeistEvent* event = NULL;
	ZeitgeistSubject* subject = NULL;
	SynapseQueryFlags flags_intersect = 0U;
	SynapseQueryFlags _tmp3_ = 0U;
	SynapseQueryFlags almost_all = 0U;
	SynapseQueryFlags _tmp4_;
	SynapseQueryFlags _tmp5_;
	GPtrArray* result = NULL;
#line 483 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
#line 483 "../../../src/plugins/zeitgeist-plugin.vala"
	templates = _tmp0_;
#line 484 "../../../src/plugins/zeitgeist-plugin.vala"
	if ((flags & SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE) == SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE) {
#line 485 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp1_ = "";
#line 2706 "zeitgeist-plugin.c"
	} else {
#line 485 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp1_ = "!" ZEITGEIST_NFO_REMOTE_DATA_OBJECT;
#line 2710 "zeitgeist-plugin.c"
	}
#line 484 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 484 "../../../src/plugins/zeitgeist-plugin.vala"
	manifestation = _tmp2_;
#line 490 "../../../src/plugins/zeitgeist-plugin.vala"
	flags_intersect = flags & SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT;
#line 493 "../../../src/plugins/zeitgeist-plugin.vala"
	if ((flags & SYNAPSE_QUERY_FLAGS_APPLICATIONS) == SYNAPSE_QUERY_FLAGS_APPLICATIONS) {
#line 494 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp3_ = SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT;
#line 2722 "zeitgeist-plugin.c"
	} else {
#line 495 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp3_ = SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT ^ SYNAPSE_QUERY_FLAGS_APPLICATIONS;
#line 2726 "zeitgeist-plugin.c"
	}
#line 493 "../../../src/plugins/zeitgeist-plugin.vala"
	almost_all = _tmp3_;
#line 496 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp4_ = flags_intersect;
#line 496 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp5_ = almost_all;
#line 496 "../../../src/plugins/zeitgeist-plugin.vala"
	if (_tmp4_ == _tmp5_) {
#line 2736 "zeitgeist-plugin.c"
		ZeitgeistSubject* _tmp6_;
		ZeitgeistSubject* _tmp7_;
		const gchar* _tmp8_;
		ZeitgeistEvent* _tmp9_;
		ZeitgeistEvent* _tmp10_;
		ZeitgeistSubject* _tmp11_;
		ZeitgeistSubject* _tmp12_;
		ZeitgeistSubject* _tmp13_;
		ZeitgeistEvent* _tmp14_;
		ZeitgeistSubject* _tmp15_;
		ZeitgeistSubject* _tmp16_;
		ZeitgeistSubject* _tmp17_;
		ZeitgeistEvent* _tmp18_;
		ZeitgeistSubject* _tmp19_;
		GPtrArray* _tmp20_;
		ZeitgeistEvent* _tmp21_;
		ZeitgeistEvent* _tmp22_;
#line 498 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp6_ = zeitgeist_subject_new ();
#line 498 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 498 "../../../src/plugins/zeitgeist-plugin.vala"
		subject = _tmp6_;
#line 499 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp7_ = subject;
#line 499 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp8_ = manifestation;
#line 499 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_subject_set_manifestation (_tmp7_, _tmp8_);
#line 500 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp9_ = zeitgeist_event_new ();
#line 500 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (event);
#line 500 "../../../src/plugins/zeitgeist-plugin.vala"
		event = _tmp9_;
#line 501 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp10_ = event;
#line 501 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp11_ = subject;
#line 501 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp10_, _tmp11_);
#line 505 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp12_ = zeitgeist_subject_new ();
#line 505 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 505 "../../../src/plugins/zeitgeist-plugin.vala"
		subject = _tmp12_;
#line 506 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp13_ = subject;
#line 506 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp13_, "!" ZEITGEIST_NFO_FOLDER);
#line 507 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp14_ = event;
#line 507 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp15_ = subject;
#line 507 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp14_, _tmp15_);
#line 509 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp16_ = zeitgeist_subject_new ();
#line 509 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 509 "../../../src/plugins/zeitgeist-plugin.vala"
		subject = _tmp16_;
#line 510 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp17_ = subject;
#line 510 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp17_, "!" ZEITGEIST_NFO_SOFTWARE);
#line 511 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp18_ = event;
#line 511 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp19_ = subject;
#line 511 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp18_, _tmp19_);
#line 513 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp20_ = templates;
#line 513 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp21_ = event;
#line 513 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp22_ = _g_object_ref0 (_tmp21_);
#line 513 "../../../src/plugins/zeitgeist-plugin.vala"
		g_ptr_array_add (_tmp20_, _tmp22_);
#line 515 "../../../src/plugins/zeitgeist-plugin.vala"
		result = templates;
#line 515 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 515 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (event);
#line 515 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_free0 (manifestation);
#line 515 "../../../src/plugins/zeitgeist-plugin.vala"
		return result;
#line 2828 "zeitgeist-plugin.c"
	}
#line 518 "../../../src/plugins/zeitgeist-plugin.vala"
	if ((flags & SYNAPSE_QUERY_FLAGS_APPLICATIONS) == SYNAPSE_QUERY_FLAGS_APPLICATIONS) {
#line 2832 "zeitgeist-plugin.c"
		ZeitgeistSubject* _tmp23_;
		ZeitgeistSubject* _tmp24_;
		ZeitgeistEvent* _tmp25_;
		ZeitgeistEvent* _tmp26_;
		ZeitgeistSubject* _tmp27_;
		GPtrArray* _tmp28_;
		ZeitgeistEvent* _tmp29_;
		ZeitgeistEvent* _tmp30_;
#line 520 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp23_ = zeitgeist_subject_new ();
#line 520 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 520 "../../../src/plugins/zeitgeist-plugin.vala"
		subject = _tmp23_;
#line 521 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp24_ = subject;
#line 521 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp24_, ZEITGEIST_NFO_SOFTWARE);
#line 522 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp25_ = zeitgeist_event_new ();
#line 522 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (event);
#line 522 "../../../src/plugins/zeitgeist-plugin.vala"
		event = _tmp25_;
#line 523 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp26_ = event;
#line 523 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp27_ = subject;
#line 523 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp26_, _tmp27_);
#line 525 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp28_ = templates;
#line 525 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp29_ = event;
#line 525 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp30_ = _g_object_ref0 (_tmp29_);
#line 525 "../../../src/plugins/zeitgeist-plugin.vala"
		g_ptr_array_add (_tmp28_, _tmp30_);
#line 2871 "zeitgeist-plugin.c"
	}
#line 528 "../../../src/plugins/zeitgeist-plugin.vala"
	if ((flags & SYNAPSE_QUERY_FLAGS_AUDIO) == SYNAPSE_QUERY_FLAGS_AUDIO) {
#line 2875 "zeitgeist-plugin.c"
		ZeitgeistSubject* _tmp31_;
		ZeitgeistSubject* _tmp32_;
		ZeitgeistSubject* _tmp33_;
		const gchar* _tmp34_;
		ZeitgeistEvent* _tmp35_;
		ZeitgeistEvent* _tmp36_;
		ZeitgeistSubject* _tmp37_;
		GPtrArray* _tmp38_;
		ZeitgeistEvent* _tmp39_;
		ZeitgeistEvent* _tmp40_;
#line 530 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp31_ = zeitgeist_subject_new ();
#line 530 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 530 "../../../src/plugins/zeitgeist-plugin.vala"
		subject = _tmp31_;
#line 531 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp32_ = subject;
#line 531 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp32_, ZEITGEIST_NFO_AUDIO);
#line 532 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp33_ = subject;
#line 532 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp34_ = manifestation;
#line 532 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_subject_set_manifestation (_tmp33_, _tmp34_);
#line 533 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp35_ = zeitgeist_event_new ();
#line 533 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (event);
#line 533 "../../../src/plugins/zeitgeist-plugin.vala"
		event = _tmp35_;
#line 534 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp36_ = event;
#line 534 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp37_ = subject;
#line 534 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp36_, _tmp37_);
#line 536 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp38_ = templates;
#line 536 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp39_ = event;
#line 536 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp40_ = _g_object_ref0 (_tmp39_);
#line 536 "../../../src/plugins/zeitgeist-plugin.vala"
		g_ptr_array_add (_tmp38_, _tmp40_);
#line 2922 "zeitgeist-plugin.c"
	}
#line 539 "../../../src/plugins/zeitgeist-plugin.vala"
	if ((flags & SYNAPSE_QUERY_FLAGS_VIDEO) == SYNAPSE_QUERY_FLAGS_VIDEO) {
#line 2926 "zeitgeist-plugin.c"
		ZeitgeistSubject* _tmp41_;
		ZeitgeistSubject* _tmp42_;
		ZeitgeistSubject* _tmp43_;
		const gchar* _tmp44_;
		ZeitgeistEvent* _tmp45_;
		ZeitgeistEvent* _tmp46_;
		ZeitgeistSubject* _tmp47_;
		GPtrArray* _tmp48_;
		ZeitgeistEvent* _tmp49_;
		ZeitgeistEvent* _tmp50_;
#line 541 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp41_ = zeitgeist_subject_new ();
#line 541 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 541 "../../../src/plugins/zeitgeist-plugin.vala"
		subject = _tmp41_;
#line 542 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp42_ = subject;
#line 542 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp42_, ZEITGEIST_NFO_VIDEO);
#line 543 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp43_ = subject;
#line 543 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp44_ = manifestation;
#line 543 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_subject_set_manifestation (_tmp43_, _tmp44_);
#line 544 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp45_ = zeitgeist_event_new ();
#line 544 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (event);
#line 544 "../../../src/plugins/zeitgeist-plugin.vala"
		event = _tmp45_;
#line 545 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp46_ = event;
#line 545 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp47_ = subject;
#line 545 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp46_, _tmp47_);
#line 547 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp48_ = templates;
#line 547 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp49_ = event;
#line 547 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp50_ = _g_object_ref0 (_tmp49_);
#line 547 "../../../src/plugins/zeitgeist-plugin.vala"
		g_ptr_array_add (_tmp48_, _tmp50_);
#line 2973 "zeitgeist-plugin.c"
	}
#line 550 "../../../src/plugins/zeitgeist-plugin.vala"
	if ((flags & SYNAPSE_QUERY_FLAGS_IMAGES) == SYNAPSE_QUERY_FLAGS_IMAGES) {
#line 2977 "zeitgeist-plugin.c"
		ZeitgeistSubject* _tmp51_;
		ZeitgeistSubject* _tmp52_;
		ZeitgeistSubject* _tmp53_;
		const gchar* _tmp54_;
		ZeitgeistEvent* _tmp55_;
		ZeitgeistEvent* _tmp56_;
		ZeitgeistSubject* _tmp57_;
		GPtrArray* _tmp58_;
		ZeitgeistEvent* _tmp59_;
		ZeitgeistEvent* _tmp60_;
#line 552 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp51_ = zeitgeist_subject_new ();
#line 552 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 552 "../../../src/plugins/zeitgeist-plugin.vala"
		subject = _tmp51_;
#line 553 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp52_ = subject;
#line 553 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp52_, ZEITGEIST_NFO_IMAGE);
#line 554 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp53_ = subject;
#line 554 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp54_ = manifestation;
#line 554 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_subject_set_manifestation (_tmp53_, _tmp54_);
#line 555 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp55_ = zeitgeist_event_new ();
#line 555 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (event);
#line 555 "../../../src/plugins/zeitgeist-plugin.vala"
		event = _tmp55_;
#line 556 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp56_ = event;
#line 556 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp57_ = subject;
#line 556 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp56_, _tmp57_);
#line 558 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp58_ = templates;
#line 558 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp59_ = event;
#line 558 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp60_ = _g_object_ref0 (_tmp59_);
#line 558 "../../../src/plugins/zeitgeist-plugin.vala"
		g_ptr_array_add (_tmp58_, _tmp60_);
#line 3024 "zeitgeist-plugin.c"
	}
#line 561 "../../../src/plugins/zeitgeist-plugin.vala"
	if ((flags & SYNAPSE_QUERY_FLAGS_DOCUMENTS) == SYNAPSE_QUERY_FLAGS_DOCUMENTS) {
#line 3028 "zeitgeist-plugin.c"
		ZeitgeistSubject* _tmp61_;
		ZeitgeistSubject* _tmp62_;
		ZeitgeistSubject* _tmp63_;
		const gchar* _tmp64_;
		ZeitgeistEvent* _tmp65_;
		ZeitgeistEvent* _tmp66_;
		ZeitgeistSubject* _tmp67_;
		GPtrArray* _tmp68_;
		ZeitgeistEvent* _tmp69_;
		ZeitgeistEvent* _tmp70_;
#line 563 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp61_ = zeitgeist_subject_new ();
#line 563 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 563 "../../../src/plugins/zeitgeist-plugin.vala"
		subject = _tmp61_;
#line 564 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp62_ = subject;
#line 564 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp62_, ZEITGEIST_NFO_DOCUMENT);
#line 565 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp63_ = subject;
#line 565 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp64_ = manifestation;
#line 565 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_subject_set_manifestation (_tmp63_, _tmp64_);
#line 566 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp65_ = zeitgeist_event_new ();
#line 566 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (event);
#line 566 "../../../src/plugins/zeitgeist-plugin.vala"
		event = _tmp65_;
#line 567 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp66_ = event;
#line 567 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp67_ = subject;
#line 567 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp66_, _tmp67_);
#line 569 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp68_ = templates;
#line 569 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp69_ = event;
#line 569 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp70_ = _g_object_ref0 (_tmp69_);
#line 569 "../../../src/plugins/zeitgeist-plugin.vala"
		g_ptr_array_add (_tmp68_, _tmp70_);
#line 3075 "zeitgeist-plugin.c"
	}
#line 572 "../../../src/plugins/zeitgeist-plugin.vala"
	if ((flags & SYNAPSE_QUERY_FLAGS_INTERNET) == SYNAPSE_QUERY_FLAGS_INTERNET) {
#line 3079 "zeitgeist-plugin.c"
		ZeitgeistSubject* _tmp71_;
		ZeitgeistSubject* _tmp72_;
		ZeitgeistSubject* _tmp73_;
		const gchar* _tmp74_;
		ZeitgeistEvent* _tmp75_;
		ZeitgeistEvent* _tmp76_;
		ZeitgeistSubject* _tmp77_;
		GPtrArray* _tmp78_;
		ZeitgeistEvent* _tmp79_;
		ZeitgeistEvent* _tmp80_;
#line 574 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp71_ = zeitgeist_subject_new ();
#line 574 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 574 "../../../src/plugins/zeitgeist-plugin.vala"
		subject = _tmp71_;
#line 575 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp72_ = subject;
#line 575 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp72_, ZEITGEIST_NFO_WEBSITE);
#line 576 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp73_ = subject;
#line 576 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp74_ = manifestation;
#line 576 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_subject_set_manifestation (_tmp73_, _tmp74_);
#line 577 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp75_ = zeitgeist_event_new ();
#line 577 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (event);
#line 577 "../../../src/plugins/zeitgeist-plugin.vala"
		event = _tmp75_;
#line 578 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp76_ = event;
#line 578 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp77_ = subject;
#line 578 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp76_, _tmp77_);
#line 580 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp78_ = templates;
#line 580 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp79_ = event;
#line 580 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp80_ = _g_object_ref0 (_tmp79_);
#line 580 "../../../src/plugins/zeitgeist-plugin.vala"
		g_ptr_array_add (_tmp78_, _tmp80_);
#line 3126 "zeitgeist-plugin.c"
	}
#line 583 "../../../src/plugins/zeitgeist-plugin.vala"
	if ((flags & SYNAPSE_QUERY_FLAGS_UNCATEGORIZED) == SYNAPSE_QUERY_FLAGS_UNCATEGORIZED) {
#line 3130 "zeitgeist-plugin.c"
		ZeitgeistEvent* _tmp81_;
		ZeitgeistSubject* _tmp82_;
		ZeitgeistSubject* _tmp83_;
		ZeitgeistEvent* _tmp84_;
		ZeitgeistSubject* _tmp85_;
		ZeitgeistSubject* _tmp86_;
		ZeitgeistSubject* _tmp87_;
		ZeitgeistEvent* _tmp88_;
		ZeitgeistSubject* _tmp89_;
		ZeitgeistSubject* _tmp90_;
		ZeitgeistSubject* _tmp91_;
		ZeitgeistEvent* _tmp92_;
		ZeitgeistSubject* _tmp93_;
		ZeitgeistSubject* _tmp94_;
		ZeitgeistSubject* _tmp95_;
		ZeitgeistEvent* _tmp96_;
		ZeitgeistSubject* _tmp97_;
		ZeitgeistSubject* _tmp98_;
		ZeitgeistSubject* _tmp99_;
		ZeitgeistEvent* _tmp100_;
		ZeitgeistSubject* _tmp101_;
		ZeitgeistSubject* _tmp102_;
		ZeitgeistSubject* _tmp103_;
		ZeitgeistEvent* _tmp104_;
		ZeitgeistSubject* _tmp105_;
		GPtrArray* _tmp111_;
		ZeitgeistEvent* _tmp112_;
		ZeitgeistEvent* _tmp113_;
#line 585 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp81_ = zeitgeist_event_new ();
#line 585 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (event);
#line 585 "../../../src/plugins/zeitgeist-plugin.vala"
		event = _tmp81_;
#line 586 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp82_ = zeitgeist_subject_new ();
#line 586 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 586 "../../../src/plugins/zeitgeist-plugin.vala"
		subject = _tmp82_;
#line 587 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp83_ = subject;
#line 587 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp83_, "!" ZEITGEIST_NFO_SOFTWARE);
#line 588 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp84_ = event;
#line 588 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp85_ = subject;
#line 588 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp84_, _tmp85_);
#line 589 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp86_ = zeitgeist_subject_new ();
#line 589 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 589 "../../../src/plugins/zeitgeist-plugin.vala"
		subject = _tmp86_;
#line 590 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp87_ = subject;
#line 590 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp87_, "!" ZEITGEIST_NFO_AUDIO);
#line 591 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp88_ = event;
#line 591 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp89_ = subject;
#line 591 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp88_, _tmp89_);
#line 592 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp90_ = zeitgeist_subject_new ();
#line 592 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 592 "../../../src/plugins/zeitgeist-plugin.vala"
		subject = _tmp90_;
#line 593 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp91_ = subject;
#line 593 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp91_, "!" ZEITGEIST_NFO_VIDEO);
#line 594 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp92_ = event;
#line 594 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp93_ = subject;
#line 594 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp92_, _tmp93_);
#line 595 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp94_ = zeitgeist_subject_new ();
#line 595 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 595 "../../../src/plugins/zeitgeist-plugin.vala"
		subject = _tmp94_;
#line 596 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp95_ = subject;
#line 596 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp95_, "!" ZEITGEIST_NFO_IMAGE);
#line 597 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp96_ = event;
#line 597 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp97_ = subject;
#line 597 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp96_, _tmp97_);
#line 598 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp98_ = zeitgeist_subject_new ();
#line 598 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 598 "../../../src/plugins/zeitgeist-plugin.vala"
		subject = _tmp98_;
#line 599 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp99_ = subject;
#line 599 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp99_, "!" ZEITGEIST_NFO_DOCUMENT);
#line 600 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp100_ = event;
#line 600 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp101_ = subject;
#line 600 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp100_, _tmp101_);
#line 601 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp102_ = zeitgeist_subject_new ();
#line 601 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 601 "../../../src/plugins/zeitgeist-plugin.vala"
		subject = _tmp102_;
#line 602 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp103_ = subject;
#line 602 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp103_, "!" ZEITGEIST_NFO_WEBSITE);
#line 603 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp104_ = event;
#line 603 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp105_ = subject;
#line 603 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp104_, _tmp105_);
#line 606 "../../../src/plugins/zeitgeist-plugin.vala"
		if (!((flags & SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE) == SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE)) {
#line 3263 "zeitgeist-plugin.c"
			ZeitgeistSubject* _tmp106_;
			ZeitgeistSubject* _tmp107_;
			const gchar* _tmp108_;
			ZeitgeistEvent* _tmp109_;
			ZeitgeistSubject* _tmp110_;
#line 608 "../../../src/plugins/zeitgeist-plugin.vala"
			_tmp106_ = zeitgeist_subject_new ();
#line 608 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_object_unref0 (subject);
#line 608 "../../../src/plugins/zeitgeist-plugin.vala"
			subject = _tmp106_;
#line 609 "../../../src/plugins/zeitgeist-plugin.vala"
			_tmp107_ = subject;
#line 609 "../../../src/plugins/zeitgeist-plugin.vala"
			_tmp108_ = manifestation;
#line 609 "../../../src/plugins/zeitgeist-plugin.vala"
			zeitgeist_subject_set_manifestation (_tmp107_, _tmp108_);
#line 610 "../../../src/plugins/zeitgeist-plugin.vala"
			_tmp109_ = event;
#line 610 "../../../src/plugins/zeitgeist-plugin.vala"
			_tmp110_ = subject;
#line 610 "../../../src/plugins/zeitgeist-plugin.vala"
			zeitgeist_event_add_subject (_tmp109_, _tmp110_);
#line 3287 "zeitgeist-plugin.c"
		}
#line 613 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp111_ = templates;
#line 613 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp112_ = event;
#line 613 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp113_ = _g_object_ref0 (_tmp112_);
#line 613 "../../../src/plugins/zeitgeist-plugin.vala"
		g_ptr_array_add (_tmp111_, _tmp113_);
#line 3297 "zeitgeist-plugin.c"
	}
#line 616 "../../../src/plugins/zeitgeist-plugin.vala"
	if ((flags & SYNAPSE_QUERY_FLAGS_PLACES) == SYNAPSE_QUERY_FLAGS_PLACES) {
#line 3301 "zeitgeist-plugin.c"
		ZeitgeistEvent* _tmp114_;
		ZeitgeistSubject* _tmp115_;
		ZeitgeistSubject* _tmp116_;
		ZeitgeistEvent* _tmp117_;
		ZeitgeistSubject* _tmp118_;
		GPtrArray* _tmp119_;
		ZeitgeistEvent* _tmp120_;
		ZeitgeistEvent* _tmp121_;
#line 618 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp114_ = zeitgeist_event_new ();
#line 618 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (event);
#line 618 "../../../src/plugins/zeitgeist-plugin.vala"
		event = _tmp114_;
#line 619 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp115_ = zeitgeist_subject_new ();
#line 619 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (subject);
#line 619 "../../../src/plugins/zeitgeist-plugin.vala"
		subject = _tmp115_;
#line 620 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp116_ = subject;
#line 620 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_subject_set_interpretation (_tmp116_, "!" ZEITGEIST_NFO_WEBSITE);
#line 621 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp117_ = event;
#line 621 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp118_ = subject;
#line 621 "../../../src/plugins/zeitgeist-plugin.vala"
		zeitgeist_event_add_subject (_tmp117_, _tmp118_);
#line 623 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp119_ = templates;
#line 623 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp120_ = event;
#line 623 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp121_ = _g_object_ref0 (_tmp120_);
#line 623 "../../../src/plugins/zeitgeist-plugin.vala"
		g_ptr_array_add (_tmp119_, _tmp121_);
#line 3340 "zeitgeist-plugin.c"
	}
#line 626 "../../../src/plugins/zeitgeist-plugin.vala"
	result = templates;
#line 626 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (subject);
#line 626 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (event);
#line 626 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_free0 (manifestation);
#line 626 "../../../src/plugins/zeitgeist-plugin.vala"
	return result;
#line 3352 "zeitgeist-plugin.c"
}

static gboolean
synapse_zeitgeist_plugin_real_handles_empty_query (SynapseItemProvider* base)
{
	SynapseZeitgeistPlugin * self;
	gboolean result = FALSE;
#line 629 "../../../src/plugins/zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPlugin*) base;
#line 631 "../../../src/plugins/zeitgeist-plugin.vala"
	result = TRUE;
#line 631 "../../../src/plugins/zeitgeist-plugin.vala"
	return result;
#line 3366 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_real_search_data_free (gpointer _data)
{
	SynapseZeitgeistPluginSearchData* _data_;
	_data_ = _data;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	g_slice_free (SynapseZeitgeistPluginSearchData, _data_);
#line 3382 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_real_search (SynapseItemProvider* base,
                                      SynapseQuery* q,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	SynapseZeitgeistPlugin * self;
	SynapseZeitgeistPluginSearchData* _data_;
	SynapseZeitgeistPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPlugin*) base;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_ = g_slice_new0 (SynapseZeitgeistPluginSearchData);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_zeitgeist_plugin_real_search_data_free);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->self = _tmp0_;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp1_ = *q;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp2_ = _tmp1_;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->q = _tmp3_;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_real_search_co (_data_);
#line 3421 "zeitgeist-plugin.c"
}

static SynapseResultSet*
synapse_zeitgeist_plugin_search_finish (SynapseItemProvider* base,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	SynapseResultSet* result;
	SynapseZeitgeistPluginSearchData* _data_;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	if (NULL == _data_) {
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
		return NULL;
#line 3437 "zeitgeist-plugin.c"
	}
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	result = _data_->result;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->result = NULL;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	return result;
#line 3445 "zeitgeist-plugin.c"
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
#line 636 "../../../src/plugins/zeitgeist-plugin.vala"
	g_atomic_int_inc (&_data9_->_ref_count_);
#line 636 "../../../src/plugins/zeitgeist-plugin.vala"
	return _data9_;
#line 3455 "zeitgeist-plugin.c"
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
#line 636 "../../../src/plugins/zeitgeist-plugin.vala"
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
#line 3465 "zeitgeist-plugin.c"
		SynapseZeitgeistPlugin* self;
#line 636 "../../../src/plugins/zeitgeist-plugin.vala"
		self = _data9_->self;
#line 636 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (self);
#line 636 "../../../src/plugins/zeitgeist-plugin.vala"
		g_slice_free (Block9Data, _data9_);
#line 3473 "zeitgeist-plugin.c"
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
#line 1359 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1360 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1360 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1361 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1362 "glib-2.0.vapi"
	result = _result_;
#line 1362 "glib-2.0.vapi"
	return result;
#line 3495 "zeitgeist-plugin.c"
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
#line 5309 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 5310 "glib-2.0.vapi"
	result = (gint) self->len;
#line 5310 "glib-2.0.vapi"
	return result;
#line 3508 "zeitgeist-plugin.c"
}

static void
___lambda31_ (Block9Data* _data9_)
{
	SynapseZeitgeistPlugin* self;
#line 660 "../../../src/plugins/zeitgeist-plugin.vala"
	self = _data9_->self;
#line 661 "../../../src/plugins/zeitgeist-plugin.vala"
	if (self->priv->search_in_progress) {
#line 661 "../../../src/plugins/zeitgeist-plugin.vala"
		return;
#line 3521 "zeitgeist-plugin.c"
	}
#line 662 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_real_search_co (_data9_->_async_data_);
#line 3525 "zeitgeist-plugin.c"
}

static void
____lambda31__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
#line 660 "../../../src/plugins/zeitgeist-plugin.vala"
	___lambda31_ (self);
#line 3535 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_search_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	SynapseZeitgeistPluginSearchData* _data_;
#line 703 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_ = _user_data_;
#line 703 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_source_object_ = source_object;
#line 703 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_res_ = _res_;
#line 703 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_real_search_co (_data_);
#line 3552 "zeitgeist-plugin.c"
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
#line 1200 "glib-2.0.vapi"
	if (separator == NULL) {
#line 1201 "glib-2.0.vapi"
		separator = "";
#line 3566 "zeitgeist-plugin.c"
	}
#line 1203 "glib-2.0.vapi"
	if (str_array != NULL) {
#line 3570 "zeitgeist-plugin.c"
		gboolean _tmp1_ = FALSE;
#line 1203 "glib-2.0.vapi"
		if (str_array_length1 > 0) {
#line 1203 "glib-2.0.vapi"
			_tmp1_ = TRUE;
#line 3576 "zeitgeist-plugin.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 1203 "glib-2.0.vapi"
			if (str_array_length1 == -1) {
#line 3581 "zeitgeist-plugin.c"
				const gchar* _tmp3_;
#line 1203 "glib-2.0.vapi"
				_tmp3_ = str_array[0];
#line 1203 "glib-2.0.vapi"
				_tmp2_ = _tmp3_ != NULL;
#line 3587 "zeitgeist-plugin.c"
			} else {
#line 1203 "glib-2.0.vapi"
				_tmp2_ = FALSE;
#line 3591 "zeitgeist-plugin.c"
			}
#line 1203 "glib-2.0.vapi"
			_tmp1_ = _tmp2_;
#line 3595 "zeitgeist-plugin.c"
		}
#line 1203 "glib-2.0.vapi"
		_tmp0_ = _tmp1_;
#line 3599 "zeitgeist-plugin.c"
	} else {
#line 1203 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 3603 "zeitgeist-plugin.c"
	}
#line 1203 "glib-2.0.vapi"
	if (_tmp0_) {
#line 3607 "zeitgeist-plugin.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
#line 1205 "glib-2.0.vapi"
		len = (gsize) 1;
#line 3621 "zeitgeist-plugin.c"
		{
			gboolean _tmp4_ = FALSE;
#line 1206 "glib-2.0.vapi"
			i = 0;
#line 1206 "glib-2.0.vapi"
			_tmp4_ = TRUE;
#line 1206 "glib-2.0.vapi"
			while (TRUE) {
#line 3630 "zeitgeist-plugin.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
#line 1206 "glib-2.0.vapi"
				if (!_tmp4_) {
#line 3637 "zeitgeist-plugin.c"
					gint _tmp5_;
#line 1206 "glib-2.0.vapi"
					_tmp5_ = i;
#line 1206 "glib-2.0.vapi"
					i = _tmp5_ + 1;
#line 3643 "zeitgeist-plugin.c"
				}
#line 1206 "glib-2.0.vapi"
				_tmp4_ = FALSE;
#line 1206 "glib-2.0.vapi"
				if (str_array_length1 != -1) {
#line 1206 "glib-2.0.vapi"
					_tmp7_ = i < str_array_length1;
#line 3651 "zeitgeist-plugin.c"
				} else {
#line 1206 "glib-2.0.vapi"
					_tmp7_ = FALSE;
#line 3655 "zeitgeist-plugin.c"
				}
#line 1206 "glib-2.0.vapi"
				if (_tmp7_) {
#line 1206 "glib-2.0.vapi"
					_tmp6_ = TRUE;
#line 3661 "zeitgeist-plugin.c"
				} else {
					gboolean _tmp8_ = FALSE;
#line 1206 "glib-2.0.vapi"
					if (str_array_length1 == -1) {
#line 3666 "zeitgeist-plugin.c"
						const gchar* _tmp9_;
#line 1206 "glib-2.0.vapi"
						_tmp9_ = str_array[i];
#line 1206 "glib-2.0.vapi"
						_tmp8_ = _tmp9_ != NULL;
#line 3672 "zeitgeist-plugin.c"
					} else {
#line 1206 "glib-2.0.vapi"
						_tmp8_ = FALSE;
#line 3676 "zeitgeist-plugin.c"
					}
#line 1206 "glib-2.0.vapi"
					_tmp6_ = _tmp8_;
#line 3680 "zeitgeist-plugin.c"
				}
#line 1206 "glib-2.0.vapi"
				if (!_tmp6_) {
#line 1206 "glib-2.0.vapi"
					break;
#line 3686 "zeitgeist-plugin.c"
				}
#line 1207 "glib-2.0.vapi"
				_tmp11_ = str_array[i];
#line 1207 "glib-2.0.vapi"
				if (_tmp11_ != NULL) {
#line 3692 "zeitgeist-plugin.c"
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
#line 1207 "glib-2.0.vapi"
					_tmp12_ = str_array[i];
#line 1207 "glib-2.0.vapi"
					_tmp13_ = strlen ((const gchar*) _tmp12_);
#line 1207 "glib-2.0.vapi"
					_tmp14_ = _tmp13_;
#line 1207 "glib-2.0.vapi"
					_tmp10_ = _tmp14_;
#line 3704 "zeitgeist-plugin.c"
				} else {
#line 1207 "glib-2.0.vapi"
					_tmp10_ = 0;
#line 3708 "zeitgeist-plugin.c"
				}
#line 1207 "glib-2.0.vapi"
				len += (gsize) _tmp10_;
#line 3712 "zeitgeist-plugin.c"
			}
		}
#line 1209 "glib-2.0.vapi"
		if (i == 0) {
#line 3717 "zeitgeist-plugin.c"
			gchar* _tmp15_;
#line 1210 "glib-2.0.vapi"
			_tmp15_ = g_strdup ("");
#line 1210 "glib-2.0.vapi"
			result = _tmp15_;
#line 1210 "glib-2.0.vapi"
			return result;
#line 3725 "zeitgeist-plugin.c"
		}
#line 1212 "glib-2.0.vapi"
		str_array_length1 = i;
#line 1213 "glib-2.0.vapi"
		_tmp16_ = strlen ((const gchar*) separator);
#line 1213 "glib-2.0.vapi"
		_tmp17_ = _tmp16_;
#line 1213 "glib-2.0.vapi"
		len += (gsize) (_tmp17_ * (i - 1));
#line 1215 "glib-2.0.vapi"
		_tmp18_ = g_malloc (len);
#line 1215 "glib-2.0.vapi"
		res = _tmp18_;
#line 1216 "glib-2.0.vapi"
		_tmp19_ = res;
#line 1216 "glib-2.0.vapi"
		_tmp20_ = str_array[0];
#line 1216 "glib-2.0.vapi"
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
#line 1216 "glib-2.0.vapi"
		ptr = _tmp21_;
#line 3747 "zeitgeist-plugin.c"
		{
			gboolean _tmp22_ = FALSE;
#line 1217 "glib-2.0.vapi"
			i = 1;
#line 1217 "glib-2.0.vapi"
			_tmp22_ = TRUE;
#line 1217 "glib-2.0.vapi"
			while (TRUE) {
#line 3756 "zeitgeist-plugin.c"
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
#line 1217 "glib-2.0.vapi"
				if (!_tmp22_) {
#line 3765 "zeitgeist-plugin.c"
					gint _tmp23_;
#line 1217 "glib-2.0.vapi"
					_tmp23_ = i;
#line 1217 "glib-2.0.vapi"
					i = _tmp23_ + 1;
#line 3771 "zeitgeist-plugin.c"
				}
#line 1217 "glib-2.0.vapi"
				_tmp22_ = FALSE;
#line 1217 "glib-2.0.vapi"
				if (!(i < str_array_length1)) {
#line 1217 "glib-2.0.vapi"
					break;
#line 3779 "zeitgeist-plugin.c"
				}
#line 1218 "glib-2.0.vapi"
				_tmp24_ = ptr;
#line 1218 "glib-2.0.vapi"
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
#line 1218 "glib-2.0.vapi"
				ptr = _tmp25_;
#line 1219 "glib-2.0.vapi"
				_tmp27_ = str_array[i];
#line 1219 "glib-2.0.vapi"
				if (_tmp27_ != NULL) {
#line 3791 "zeitgeist-plugin.c"
					const gchar* _tmp28_;
#line 1219 "glib-2.0.vapi"
					_tmp28_ = str_array[i];
#line 1219 "glib-2.0.vapi"
					_tmp26_ = (const gchar*) _tmp28_;
#line 3797 "zeitgeist-plugin.c"
				} else {
#line 1219 "glib-2.0.vapi"
					_tmp26_ = "";
#line 3801 "zeitgeist-plugin.c"
				}
#line 1219 "glib-2.0.vapi"
				_tmp29_ = ptr;
#line 1219 "glib-2.0.vapi"
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
#line 1219 "glib-2.0.vapi"
				ptr = _tmp30_;
#line 3809 "zeitgeist-plugin.c"
			}
		}
#line 1222 "glib-2.0.vapi"
		_tmp31_ = res;
#line 1222 "glib-2.0.vapi"
		res = NULL;
#line 1222 "glib-2.0.vapi"
		result = (gchar*) _tmp31_;
#line 1222 "glib-2.0.vapi"
		return result;
#line 3820 "zeitgeist-plugin.c"
	} else {
		gchar* _tmp32_;
#line 1224 "glib-2.0.vapi"
		_tmp32_ = g_strdup ("");
#line 1224 "glib-2.0.vapi"
		result = _tmp32_;
#line 1224 "glib-2.0.vapi"
		return result;
#line 3829 "zeitgeist-plugin.c"
	}
}

static gboolean
synapse_zeitgeist_plugin_real_search_co (SynapseZeitgeistPluginSearchData* _data_)
{
#line 636 "../../../src/plugins/zeitgeist-plugin.vala"
	switch (_data_->_state_) {
#line 636 "../../../src/plugins/zeitgeist-plugin.vala"
		case 0:
#line 3840 "zeitgeist-plugin.c"
		goto _state_0;
#line 636 "../../../src/plugins/zeitgeist-plugin.vala"
		case 1:
#line 3844 "zeitgeist-plugin.c"
		goto _state_1;
#line 636 "../../../src/plugins/zeitgeist-plugin.vala"
		case 2:
#line 3848 "zeitgeist-plugin.c"
		goto _state_2;
#line 636 "../../../src/plugins/zeitgeist-plugin.vala"
		case 3:
#line 3852 "zeitgeist-plugin.c"
		goto _state_3;
#line 636 "../../../src/plugins/zeitgeist-plugin.vala"
		case 4:
#line 3856 "zeitgeist-plugin.c"
		goto _state_4;
#line 636 "../../../src/plugins/zeitgeist-plugin.vala"
		case 5:
#line 3860 "zeitgeist-plugin.c"
		goto _state_5;
		default:
#line 636 "../../../src/plugins/zeitgeist-plugin.vala"
		g_assert_not_reached ();
#line 3865 "zeitgeist-plugin.c"
	}
	_state_0:
#line 636 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_data9_ = g_slice_new0 (Block9Data);
#line 636 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_data9_->_ref_count_ = 1;
#line 636 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_data9_->self = g_object_ref (_data_->self);
#line 636 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_data9_->_async_data_ = _data_;
#line 638 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_tmp0_ = _data_->q;
#line 638 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_tmp1_ = _data_->_tmp0_.query_string;
#line 638 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_tmp2_ = string_strip (_data_->_tmp1_);
#line 638 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->search_query = _data_->_tmp2_;
#line 639 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_tmp3_ = _data_->search_query;
#line 639 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->empty_query = g_strcmp0 (_data_->_tmp3_, "") == 0;
#line 641 "../../../src/plugins/zeitgeist-plugin.vala"
	if (!_data_->empty_query) {
#line 641 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->_tmp4_ = _data_->q;
#line 641 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->_tmp5_ = _data_->_tmp4_.query_type;
#line 641 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->q.query_type = _data_->_tmp5_ & (~SYNAPSE_QUERY_FLAGS_APPLICATIONS);
#line 3896 "zeitgeist-plugin.c"
	}
#line 643 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_tmp6_ = g_timer_new ();
#line 643 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->timer = _data_->_tmp6_;
#line 645 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_tmp7_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
#line 645 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->templates = _data_->_tmp7_;
#line 646 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_tmp8_ = _data_->q;
#line 646 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_tmp9_ = _data_->_tmp8_.query_type;
#line 646 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_tmp10_ = synapse_zeitgeist_plugin_create_templates (_data_->_tmp9_);
#line 646 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->event_templates = _data_->_tmp10_;
#line 647 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_tmp11_ = _data_->event_templates;
#line 647 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_tmp12_ = vala_g_ptr_array_get_length (_data_->_tmp11_);
#line 647 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_tmp13_ = _data_->_tmp12_;
#line 647 "../../../src/plugins/zeitgeist-plugin.vala"
	if (_data_->_tmp13_ == 0) {
#line 647 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->result = NULL;
#line 647 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_ptr_array_unref0 (_data_->event_templates);
#line 647 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_ptr_array_unref0 (_data_->templates);
#line 647 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_timer_destroy0 (_data_->timer);
#line 647 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_free0 (_data_->search_query);
#line 647 "../../../src/plugins/zeitgeist-plugin.vala"
		block9_data_unref (_data_->_data9_);
#line 647 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->_data9_ = NULL;
#line 647 "../../../src/plugins/zeitgeist-plugin.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 647 "../../../src/plugins/zeitgeist-plugin.vala"
		if (_data_->_state_ != 0) {
#line 647 "../../../src/plugins/zeitgeist-plugin.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 647 "../../../src/plugins/zeitgeist-plugin.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3944 "zeitgeist-plugin.c"
			}
		}
#line 647 "../../../src/plugins/zeitgeist-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 647 "../../../src/plugins/zeitgeist-plugin.vala"
		return FALSE;
#line 3951 "zeitgeist-plugin.c"
	}
	{
#line 648 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->i = 0;
#line 3956 "zeitgeist-plugin.c"
		{
#line 648 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp14_ = TRUE;
#line 648 "../../../src/plugins/zeitgeist-plugin.vala"
			while (TRUE) {
#line 648 "../../../src/plugins/zeitgeist-plugin.vala"
				if (!_data_->_tmp14_) {
#line 648 "../../../src/plugins/zeitgeist-plugin.vala"
					_data_->_tmp15_ = _data_->i;
#line 648 "../../../src/plugins/zeitgeist-plugin.vala"
					_data_->i = _data_->_tmp15_ + 1;
#line 3968 "zeitgeist-plugin.c"
				}
#line 648 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp14_ = FALSE;
#line 648 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp16_ = _data_->event_templates;
#line 648 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp17_ = vala_g_ptr_array_get_length (_data_->_tmp16_);
#line 648 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp18_ = _data_->_tmp17_;
#line 648 "../../../src/plugins/zeitgeist-plugin.vala"
				if (!(_data_->i < _data_->_tmp18_)) {
#line 648 "../../../src/plugins/zeitgeist-plugin.vala"
					break;
#line 3982 "zeitgeist-plugin.c"
				}
#line 650 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp19_ = _data_->templates;
#line 650 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp20_ = _data_->event_templates;
#line 650 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp21_ = g_ptr_array_index (_data_->_tmp20_, (guint) _data_->i);
#line 650 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp22_ = _g_object_ref0 ((ZeitgeistEvent*) _data_->_tmp21_);
#line 650 "../../../src/plugins/zeitgeist-plugin.vala"
				g_ptr_array_add (_data_->_tmp19_, _data_->_tmp22_);
#line 3994 "zeitgeist-plugin.c"
			}
		}
	}
#line 653 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_tmp23_ = synapse_result_set_new ();
#line 653 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_result_ = _data_->_tmp23_;
#line 656 "../../../src/plugins/zeitgeist-plugin.vala"
	while (TRUE) {
#line 656 "../../../src/plugins/zeitgeist-plugin.vala"
		if (!_data_->self->priv->search_in_progress) {
#line 656 "../../../src/plugins/zeitgeist-plugin.vala"
			break;
#line 4008 "zeitgeist-plugin.c"
		}
#line 660 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->_tmp24_ = g_signal_connect_data ((GObject*) _data_->self, "notify::search-in-progress", (GCallback) ____lambda31__g_object_notify, block9_data_ref (_data_->_data9_), (GClosureNotify) block9_data_unref, 0);
#line 660 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->sig_id = _data_->_tmp24_;
#line 664 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->_state_ = 1;
#line 664 "../../../src/plugins/zeitgeist-plugin.vala"
		return FALSE;
#line 4018 "zeitgeist-plugin.c"
		_state_1:
		;
#line 666 "../../../src/plugins/zeitgeist-plugin.vala"
		g_signal_handler_disconnect (_data_->self, _data_->sig_id);
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
		synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
			if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_object_unref0 (_data_->_result_);
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_ptr_array_unref0 (_data_->event_templates);
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_ptr_array_unref0 (_data_->templates);
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_timer_destroy0 (_data_->timer);
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_free0 (_data_->search_query);
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
				block9_data_unref (_data_->_data9_);
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_data9_ = NULL;
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
				return FALSE;
#line 4049 "zeitgeist-plugin.c"
			} else {
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_object_unref0 (_data_->_result_);
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_ptr_array_unref0 (_data_->event_templates);
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_ptr_array_unref0 (_data_->templates);
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_timer_destroy0 (_data_->timer);
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_free0 (_data_->search_query);
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
				block9_data_unref (_data_->_data9_);
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_data9_ = NULL;
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
				g_clear_error (&_data_->_inner_error0_);
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 667 "../../../src/plugins/zeitgeist-plugin.vala"
				return FALSE;
#line 4073 "zeitgeist-plugin.c"
			}
		}
	}
	{
#line 673 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->_tmp25_ = _data_->q;
#line 673 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->_tmp26_ = _data_->_tmp25_.query_type;
#line 673 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->only_local = !((_data_->_tmp26_ & SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE) == SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE);
#line 674 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->_tmp27_ = _data_->q;
#line 674 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->_tmp28_ = _data_->_tmp27_.query_type;
#line 674 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->places_search = (_data_->_tmp28_ & SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT) == SYNAPSE_QUERY_FLAGS_PLACES;
#line 676 "../../../src/plugins/zeitgeist-plugin.vala"
		if (_data_->places_search) {
#line 677 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp29_ = ZEITGEIST_RESULT_TYPE_MOST_RECENT_ORIGIN;
#line 4094 "zeitgeist-plugin.c"
		} else {
#line 678 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp29_ = ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS;
#line 4098 "zeitgeist-plugin.c"
		}
#line 676 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->rt = _data_->_tmp29_;
#line 680 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->self->priv->search_in_progress = TRUE;
#line 700 "../../../src/plugins/zeitgeist-plugin.vala"
		if (_data_->empty_query) {
#line 702 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp30_ = g_date_time_new_now_local ();
#line 702 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp31_ = _data_->_tmp30_;
#line 702 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp32_ = (g_date_time_to_unix (_data_->_tmp31_) * 1000) - (ZEITGEIST_TIMESTAMP_WEEK * 24);
#line 702 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_date_time_unref0 (_data_->_tmp31_);
#line 702 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->start_ts = _data_->_tmp32_;
#line 703 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp34_ = _data_->self->priv->zg_log;
#line 703 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp35_ = zeitgeist_time_range_new (_data_->start_ts, G_MAXINT64);
#line 703 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp36_ = _data_->_tmp35_;
#line 703 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp37_ = _data_->templates;
#line 703 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp38_ = _data_->q;
#line 703 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp39_ = _data_->rt;
#line 703 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_state_ = 2;
#line 703 "../../../src/plugins/zeitgeist-plugin.vala"
			zeitgeist_log_find_events (_data_->_tmp34_, _data_->_tmp36_, _data_->_tmp37_, ZEITGEIST_STORAGE_STATE_ANY, (guint32) _data_->_tmp38_.max_results, _data_->_tmp39_, NULL, synapse_zeitgeist_plugin_search_ready, _data_);
#line 703 "../../../src/plugins/zeitgeist-plugin.vala"
			return FALSE;
#line 4134 "zeitgeist-plugin.c"
			_state_2:
#line 703 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp40_ = zeitgeist_log_find_events_finish (_data_->_tmp34_, _data_->_res_, &_data_->_inner_error0_);
#line 703 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp41_ = _data_->_tmp40_;
#line 703 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->_tmp36_);
#line 703 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp33_ = _data_->_tmp41_;
#line 703 "../../../src/plugins/zeitgeist-plugin.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 703 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_object_unref0 (_data_->rs);
#line 4148 "zeitgeist-plugin.c"
				goto __catch0_g_error;
			}
#line 703 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp42_ = _data_->_tmp33_;
#line 703 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp33_ = NULL;
#line 703 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->rs);
#line 703 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->rs = _data_->_tmp42_;
#line 710 "../../../src/plugins/zeitgeist-plugin.vala"
			if (!synapse_query_is_cancelled (&_data_->q)) {
#line 712 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp43_ = _data_->rs;
#line 712 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp44_ = _data_->q;
#line 712 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp45_ = _data_->_tmp44_.cancellable;
#line 712 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp46_ = _data_->_result_;
#line 712 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_state_ = 3;
#line 712 "../../../src/plugins/zeitgeist-plugin.vala"
				synapse_zeitgeist_plugin_process_recent_results (_data_->self, _data_->_tmp43_, _data_->_tmp45_, _data_->_tmp46_, _data_->only_local, _data_->places_search, synapse_zeitgeist_plugin_search_ready, _data_);
#line 712 "../../../src/plugins/zeitgeist-plugin.vala"
				return FALSE;
#line 4175 "zeitgeist-plugin.c"
				_state_3:
#line 712 "../../../src/plugins/zeitgeist-plugin.vala"
				synapse_zeitgeist_plugin_process_recent_results_finish (_data_->self, _data_->_res_);
#line 4179 "zeitgeist-plugin.c"
			}
#line 700 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->_tmp33_);
#line 4183 "zeitgeist-plugin.c"
		} else {
#line 718 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp47_ = _data_->search_query;
#line 718 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp49_ = _data_->_tmp48_ = g_regex_split_simple ("\\s+|\\.+(?!\\d)", _data_->_tmp47_, 0, 0);
#line 718 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->words = _data_->_tmp49_;
#line 718 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->words_length1 = _vala_array_length (_data_->_tmp48_);
#line 718 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_words_size_ = _data_->words_length1;
#line 719 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp50_ = _data_->words;
#line 719 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp50__length1 = _data_->words_length1;
#line 719 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp51_ = _vala_g_strjoinv ("* ", _data_->_tmp50_, (gint) _data_->_tmp50__length1);
#line 719 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp52_ = _data_->_tmp51_;
#line 719 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp53_ = g_strdup_printf ("(%s*)", _data_->_tmp52_);
#line 719 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_free0 (_data_->search_query);
#line 719 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->search_query = _data_->_tmp53_;
#line 719 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_free0 (_data_->_tmp52_);
#line 720 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp55_ = _data_->self->priv->zg_index;
#line 720 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp56_ = _data_->search_query;
#line 720 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp57_ = zeitgeist_time_range_new (G_MININT64, G_MAXINT64);
#line 720 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp58_ = _data_->_tmp57_;
#line 720 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp59_ = _data_->templates;
#line 720 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp60_ = _data_->q;
#line 720 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp61_ = _data_->rt;
#line 720 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_state_ = 4;
#line 720 "../../../src/plugins/zeitgeist-plugin.vala"
			zeitgeist_index_search (_data_->_tmp55_, _data_->_tmp56_, _data_->_tmp58_, _data_->_tmp59_, (guint32) 0, (guint32) _data_->_tmp60_.max_results, _data_->_tmp61_, NULL, synapse_zeitgeist_plugin_search_ready, _data_);
#line 720 "../../../src/plugins/zeitgeist-plugin.vala"
			return FALSE;
#line 4231 "zeitgeist-plugin.c"
			_state_4:
#line 720 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp62_ = zeitgeist_index_search_finish (_data_->_tmp55_, _data_->_res_, &_data_->_inner_error0_);
#line 720 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp63_ = _data_->_tmp62_;
#line 720 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->_tmp58_);
#line 720 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp54_ = _data_->_tmp63_;
#line 720 "../../../src/plugins/zeitgeist-plugin.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 720 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->words = (_vala_array_free (_data_->words, _data_->words_length1, (GDestroyNotify) g_free), NULL);
#line 720 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_object_unref0 (_data_->rs);
#line 4247 "zeitgeist-plugin.c"
				goto __catch0_g_error;
			}
#line 720 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp64_ = _data_->_tmp54_;
#line 720 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp54_ = NULL;
#line 720 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->rs);
#line 720 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->rs = _data_->_tmp64_;
#line 728 "../../../src/plugins/zeitgeist-plugin.vala"
			if (!synapse_query_is_cancelled (&_data_->q)) {
#line 730 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp65_ = _data_->q;
#line 730 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp66_ = _data_->_tmp65_.query_string;
#line 730 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp67_ = _data_->rs;
#line 730 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp68_ = _data_->q;
#line 730 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp69_ = _data_->_tmp68_.cancellable;
#line 730 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_tmp70_ = _data_->_result_;
#line 730 "../../../src/plugins/zeitgeist-plugin.vala"
				_data_->_state_ = 5;
#line 730 "../../../src/plugins/zeitgeist-plugin.vala"
				synapse_zeitgeist_plugin_process_results (_data_->_tmp66_, _data_->_tmp67_, _data_->_tmp69_, _data_->_tmp70_, _data_->only_local, _data_->places_search, synapse_zeitgeist_plugin_search_ready, _data_);
#line 730 "../../../src/plugins/zeitgeist-plugin.vala"
				return FALSE;
#line 4278 "zeitgeist-plugin.c"
				_state_5:
#line 730 "../../../src/plugins/zeitgeist-plugin.vala"
				synapse_zeitgeist_plugin_process_results_finish (_data_->_res_);
#line 4282 "zeitgeist-plugin.c"
			}
#line 700 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->_tmp54_);
#line 700 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->words = (_vala_array_free (_data_->words, _data_->words_length1, (GDestroyNotify) g_free), NULL);
#line 4288 "zeitgeist-plugin.c"
		}
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_object_unref0 (_data_->rs);
#line 4292 "zeitgeist-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->err = _data_->_inner_error0_;
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
		_data_->_inner_error0_ = NULL;
#line 737 "../../../src/plugins/zeitgeist-plugin.vala"
		if (!synapse_query_is_cancelled (&_data_->q)) {
#line 740 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp71_ = _data_->err;
#line 740 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_tmp72_ = _data_->_tmp71_->message;
#line 740 "../../../src/plugins/zeitgeist-plugin.vala"
			g_warning ("zeitgeist-plugin.vala:740: Zeitgeist search failed: %s", _data_->_tmp72_);
#line 4309 "zeitgeist-plugin.c"
		}
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_error_free0 (_data_->err);
#line 4313 "zeitgeist-plugin.c"
	}
	__finally0:
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_ptr_array_unref0 (_data_->event_templates);
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_ptr_array_unref0 (_data_->templates);
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_timer_destroy0 (_data_->timer);
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_free0 (_data_->search_query);
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
			block9_data_unref (_data_->_data9_);
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_data9_ = NULL;
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
			return FALSE;
#line 4340 "zeitgeist-plugin.c"
		} else {
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_ptr_array_unref0 (_data_->event_templates);
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_ptr_array_unref0 (_data_->templates);
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_timer_destroy0 (_data_->timer);
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_free0 (_data_->search_query);
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
			block9_data_unref (_data_->_data9_);
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_data9_ = NULL;
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 670 "../../../src/plugins/zeitgeist-plugin.vala"
			return FALSE;
#line 4364 "zeitgeist-plugin.c"
		}
	}
#line 744 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->self->priv->search_in_progress = FALSE;
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_ptr_array_unref0 (_data_->event_templates);
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_ptr_array_unref0 (_data_->templates);
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_timer_destroy0 (_data_->timer);
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_free0 (_data_->search_query);
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
			block9_data_unref (_data_->_data9_);
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_data9_ = NULL;
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
			return FALSE;
#line 4395 "zeitgeist-plugin.c"
		} else {
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_ptr_array_unref0 (_data_->event_templates);
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_ptr_array_unref0 (_data_->templates);
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_timer_destroy0 (_data_->timer);
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_free0 (_data_->search_query);
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
			block9_data_unref (_data_->_data9_);
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
			_data_->_data9_ = NULL;
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 746 "../../../src/plugins/zeitgeist-plugin.vala"
			return FALSE;
#line 4419 "zeitgeist-plugin.c"
		}
	}
#line 748 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_tmp73_ = _data_->timer;
#line 748 "../../../src/plugins/zeitgeist-plugin.vala"
	g_debug ("zeitgeist-plugin.vala:748: search took %d ms", (gint) (g_timer_elapsed (_data_->_tmp73_, NULL) * 1000));
#line 750 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->result = _data_->_result_;
#line 750 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_ptr_array_unref0 (_data_->event_templates);
#line 750 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_ptr_array_unref0 (_data_->templates);
#line 750 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_timer_destroy0 (_data_->timer);
#line 750 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_free0 (_data_->search_query);
#line 750 "../../../src/plugins/zeitgeist-plugin.vala"
	block9_data_unref (_data_->_data9_);
#line 750 "../../../src/plugins/zeitgeist-plugin.vala"
	_data_->_data9_ = NULL;
#line 750 "../../../src/plugins/zeitgeist-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 750 "../../../src/plugins/zeitgeist-plugin.vala"
	if (_data_->_state_ != 0) {
#line 750 "../../../src/plugins/zeitgeist-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 750 "../../../src/plugins/zeitgeist-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4448 "zeitgeist-plugin.c"
		}
	}
#line 750 "../../../src/plugins/zeitgeist-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 750 "../../../src/plugins/zeitgeist-plugin.vala"
	return FALSE;
#line 4455 "zeitgeist-plugin.c"
}

SynapseZeitgeistPlugin*
synapse_zeitgeist_plugin_construct (GType object_type)
{
	SynapseZeitgeistPlugin * self = NULL;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPlugin*) g_object_new (object_type, NULL);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	return self;
#line 4466 "zeitgeist-plugin.c"
}

SynapseZeitgeistPlugin*
synapse_zeitgeist_plugin_new (void)
{
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	return synapse_zeitgeist_plugin_construct (SYNAPSE_TYPE_ZEITGEIST_PLUGIN);
#line 4474 "zeitgeist-plugin.c"
}

static gboolean
synapse_zeitgeist_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseZeitgeistPlugin* self;
#line 26 "../../../src/plugins/zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPlugin*) base;
#line 26 "../../../src/plugins/zeitgeist-plugin.vala"
	result = self->priv->_enabled;
#line 26 "../../../src/plugins/zeitgeist-plugin.vala"
	return result;
#line 4488 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_real_set_enabled (SynapseActivatable* base,
                                           gboolean value)
{
	SynapseZeitgeistPlugin* self;
	gboolean old_value;
#line 26 "../../../src/plugins/zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPlugin*) base;
#line 26 "../../../src/plugins/zeitgeist-plugin.vala"
	old_value = synapse_zeitgeist_plugin_real_get_enabled (base);
#line 26 "../../../src/plugins/zeitgeist-plugin.vala"
	if (old_value != value) {
#line 26 "../../../src/plugins/zeitgeist-plugin.vala"
		self->priv->_enabled = value;
#line 26 "../../../src/plugins/zeitgeist-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_zeitgeist_plugin_properties[SYNAPSE_ZEITGEIST_PLUGIN_ENABLED_PROPERTY]);
#line 4507 "zeitgeist-plugin.c"
	}
}

SynapseDataSink*
synapse_zeitgeist_plugin_get_data_sink (SynapseZeitgeistPlugin* self)
{
	SynapseDataSink* result;
	SynapseDataSink* _tmp0_;
#line 39 "../../../src/plugins/zeitgeist-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 39 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp0_ = self->priv->_data_sink;
#line 39 "../../../src/plugins/zeitgeist-plugin.vala"
	result = _tmp0_;
#line 39 "../../../src/plugins/zeitgeist-plugin.vala"
	return result;
#line 4524 "zeitgeist-plugin.c"
}

void
synapse_zeitgeist_plugin_set_data_sink (SynapseZeitgeistPlugin* self,
                                        SynapseDataSink* value)
{
	SynapseDataSink* old_value;
#line 39 "../../../src/plugins/zeitgeist-plugin.vala"
	g_return_if_fail (self != NULL);
#line 39 "../../../src/plugins/zeitgeist-plugin.vala"
	old_value = synapse_zeitgeist_plugin_get_data_sink (self);
#line 39 "../../../src/plugins/zeitgeist-plugin.vala"
	if (old_value != value) {
#line 39 "../../../src/plugins/zeitgeist-plugin.vala"
		self->priv->_data_sink = value;
#line 39 "../../../src/plugins/zeitgeist-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_zeitgeist_plugin_properties[SYNAPSE_ZEITGEIST_PLUGIN_DATA_SINK_PROPERTY]);
#line 4542 "zeitgeist-plugin.c"
	}
}

static inline gpointer
synapse_zeitgeist_plugin_zeitgeist_application_match_get_instance_private (SynapseZeitgeistPluginZeitgeistApplicationMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseZeitgeistPluginZeitgeistApplicationMatch_private_offset);
}

static SynapseZeitgeistPluginZeitgeistApplicationMatch*
synapse_zeitgeist_plugin_zeitgeist_application_match_construct (GType object_type,
                                                                ZeitgeistEvent* event,
                                                                const gchar* thumbnail_path,
                                                                const gchar* icon)
{
	SynapseZeitgeistPluginZeitgeistApplicationMatch * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	ZeitgeistSubject* subject = NULL;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp3_;
	gconstpointer _tmp4_;
	ZeitgeistSubject* _tmp5_;
	gchar* uri = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	SynapseDesktopFileService* dfs = NULL;
	SynapseDesktopFileService* _tmp9_;
	SynapseDesktopFileInfo* dfi = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	SynapseDesktopFileInfo* _tmp12_;
	SynapseDesktopFileInfo* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
#line 48 "../../../src/plugins/zeitgeist-plugin.vala"
	g_return_val_if_fail (event != NULL, NULL);
#line 53 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp0_ = icon;
#line 53 "../../../src/plugins/zeitgeist-plugin.vala"
	if (_tmp0_ == NULL) {
#line 53 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp0_ = "";
#line 4595 "zeitgeist-plugin.c"
	}
#line 54 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp1_ = thumbnail_path;
#line 54 "../../../src/plugins/zeitgeist-plugin.vala"
	if (_tmp1_ == NULL) {
#line 54 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp1_ = "";
#line 4603 "zeitgeist-plugin.c"
	}
#line 52 "../../../src/plugins/zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPluginZeitgeistApplicationMatch*) g_object_new (object_type, "has-thumbnail", thumbnail_path != NULL, "icon-name", _tmp0_, "thumbnail-path", _tmp1_, NULL);
#line 56 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp2_ = zeitgeist_event_get_subjects (event);
#line 56 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp3_ = _tmp2_;
#line 56 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp4_ = g_ptr_array_index (_tmp3_, (guint) 0);
#line 56 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp5_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp4_);
#line 56 "../../../src/plugins/zeitgeist-plugin.vala"
	subject = _tmp5_;
#line 57 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp6_ = zeitgeist_subject_get_uri (subject);
#line 57 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp7_ = _tmp6_;
#line 57 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 57 "../../../src/plugins/zeitgeist-plugin.vala"
	uri = _tmp8_;
#line 59 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp9_ = synapse_desktop_file_service_get_default ();
#line 59 "../../../src/plugins/zeitgeist-plugin.vala"
	dfs = _tmp9_;
#line 60 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp10_ = string_substring (uri, (glong) 14, (glong) -1);
#line 60 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp11_ = _tmp10_;
#line 60 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp12_ = synapse_desktop_file_service_get_desktop_file_for_id (dfs, _tmp11_);
#line 60 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp13_ = _tmp12_;
#line 60 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_free0 (_tmp11_);
#line 60 "../../../src/plugins/zeitgeist-plugin.vala"
	dfi = _tmp13_;
#line 62 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp14_ = synapse_desktop_file_info_get_name (dfi);
#line 62 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp15_ = _tmp14_;
#line 62 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_match_set_title ((SynapseMatch*) self, _tmp15_);
#line 63 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp16_ = synapse_desktop_file_info_get_icon_name (dfi);
#line 63 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp17_ = _tmp16_;
#line 63 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp17_);
#line 64 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp18_ = synapse_desktop_file_info_get_comment (dfi);
#line 64 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp19_ = _tmp18_;
#line 64 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_match_set_description ((SynapseMatch*) self, _tmp19_);
#line 65 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp20_ = synapse_desktop_file_info_get_needs_terminal (dfi);
#line 65 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp21_ = _tmp20_;
#line 65 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_application_match_set_needs_terminal ((SynapseApplicationMatch*) self, _tmp21_);
#line 66 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp22_ = synapse_desktop_file_info_get_filename (dfi);
#line 66 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp23_ = _tmp22_;
#line 66 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_application_match_set_filename ((SynapseApplicationMatch*) self, _tmp23_);
#line 48 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (dfi);
#line 48 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (dfs);
#line 48 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_free0 (uri);
#line 48 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (subject);
#line 48 "../../../src/plugins/zeitgeist-plugin.vala"
	return self;
#line 4681 "zeitgeist-plugin.c"
}

static SynapseZeitgeistPluginZeitgeistApplicationMatch*
synapse_zeitgeist_plugin_zeitgeist_application_match_new (ZeitgeistEvent* event,
                                                          const gchar* thumbnail_path,
                                                          const gchar* icon)
{
#line 48 "../../../src/plugins/zeitgeist-plugin.vala"
	return synapse_zeitgeist_plugin_zeitgeist_application_match_construct (SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_APPLICATION_MATCH, event, thumbnail_path, icon);
#line 4691 "zeitgeist-plugin.c"
}

static const gchar*
synapse_zeitgeist_plugin_zeitgeist_application_match_real_get_extended_info (SynapseExtendedInfo* base)
{
	const gchar* result;
	SynapseZeitgeistPluginZeitgeistApplicationMatch* self;
	const gchar* _tmp0_;
#line 46 "../../../src/plugins/zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPluginZeitgeistApplicationMatch*) base;
#line 46 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp0_ = self->priv->_extended_info;
#line 46 "../../../src/plugins/zeitgeist-plugin.vala"
	result = _tmp0_;
#line 46 "../../../src/plugins/zeitgeist-plugin.vala"
	return result;
#line 4708 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_application_match_real_set_extended_info (SynapseExtendedInfo* base,
                                                                             const gchar* value)
{
	SynapseZeitgeistPluginZeitgeistApplicationMatch* self;
	gchar* _tmp0_;
#line 46 "../../../src/plugins/zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPluginZeitgeistApplicationMatch*) base;
#line 46 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp0_ = g_strdup (value);
#line 46 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_free0 (self->priv->_extended_info);
#line 46 "../../../src/plugins/zeitgeist-plugin.vala"
	self->priv->_extended_info = _tmp0_;
#line 4725 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_application_match_class_init (SynapseZeitgeistPluginZeitgeistApplicationMatchClass * klass,
                                                                 gpointer klass_data)
{
#line 43 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_zeitgeist_application_match_parent_class = g_type_class_peek_parent (klass);
#line 43 "../../../src/plugins/zeitgeist-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseZeitgeistPluginZeitgeistApplicationMatch_private_offset);
#line 43 "../../../src/plugins/zeitgeist-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_zeitgeist_plugin_zeitgeist_application_match_get_property;
#line 43 "../../../src/plugins/zeitgeist-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_zeitgeist_plugin_zeitgeist_application_match_set_property;
#line 43 "../../../src/plugins/zeitgeist-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_zeitgeist_plugin_zeitgeist_application_match_finalize;
#line 4742 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_application_match_synapse_extended_info_interface_init (SynapseExtendedInfoIface * iface,
                                                                                           gpointer iface_data)
{
#line 43 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_zeitgeist_application_match_synapse_extended_info_parent_iface = g_type_interface_peek_parent (iface);
#line 43 "../../../src/plugins/zeitgeist-plugin.vala"
	iface->get_extended_info = synapse_zeitgeist_plugin_zeitgeist_application_match_real_get_extended_info;
#line 43 "../../../src/plugins/zeitgeist-plugin.vala"
	iface->set_extended_info = synapse_zeitgeist_plugin_zeitgeist_application_match_real_set_extended_info;
#line 4755 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_application_match_instance_init (SynapseZeitgeistPluginZeitgeistApplicationMatch * self,
                                                                    gpointer klass)
{
#line 43 "../../../src/plugins/zeitgeist-plugin.vala"
	self->priv = synapse_zeitgeist_plugin_zeitgeist_application_match_get_instance_private (self);
#line 46 "../../../src/plugins/zeitgeist-plugin.vala"
	self->priv->_extended_info = NULL;
#line 4766 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_application_match_finalize (GObject * obj)
{
	SynapseZeitgeistPluginZeitgeistApplicationMatch * self;
#line 43 "../../../src/plugins/zeitgeist-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_APPLICATION_MATCH, SynapseZeitgeistPluginZeitgeistApplicationMatch);
#line 46 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_free0 (self->priv->_extended_info);
#line 43 "../../../src/plugins/zeitgeist-plugin.vala"
	G_OBJECT_CLASS (synapse_zeitgeist_plugin_zeitgeist_application_match_parent_class)->finalize (obj);
#line 4779 "zeitgeist-plugin.c"
}

static GType
synapse_zeitgeist_plugin_zeitgeist_application_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseZeitgeistPluginZeitgeistApplicationMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_zeitgeist_plugin_zeitgeist_application_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseZeitgeistPluginZeitgeistApplicationMatch), 0, (GInstanceInitFunc) synapse_zeitgeist_plugin_zeitgeist_application_match_instance_init, NULL };
	static const GInterfaceInfo synapse_extended_info_info = { (GInterfaceInitFunc) synapse_zeitgeist_plugin_zeitgeist_application_match_synapse_extended_info_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_zeitgeist_plugin_zeitgeist_application_match_type_id;
	synapse_zeitgeist_plugin_zeitgeist_application_match_type_id = g_type_register_static (SYNAPSE_TYPE_APPLICATION_MATCH, "SynapseZeitgeistPluginZeitgeistApplicationMatch", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_zeitgeist_plugin_zeitgeist_application_match_type_id, SYNAPSE_TYPE_EXTENDED_INFO, &synapse_extended_info_info);
	SynapseZeitgeistPluginZeitgeistApplicationMatch_private_offset = g_type_add_instance_private (synapse_zeitgeist_plugin_zeitgeist_application_match_type_id, sizeof (SynapseZeitgeistPluginZeitgeistApplicationMatchPrivate));
	return synapse_zeitgeist_plugin_zeitgeist_application_match_type_id;
}

static GType
synapse_zeitgeist_plugin_zeitgeist_application_match_get_type (void)
{
	static volatile gsize synapse_zeitgeist_plugin_zeitgeist_application_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_zeitgeist_plugin_zeitgeist_application_match_type_id__volatile)) {
		GType synapse_zeitgeist_plugin_zeitgeist_application_match_type_id;
		synapse_zeitgeist_plugin_zeitgeist_application_match_type_id = synapse_zeitgeist_plugin_zeitgeist_application_match_get_type_once ();
		g_once_init_leave (&synapse_zeitgeist_plugin_zeitgeist_application_match_type_id__volatile, synapse_zeitgeist_plugin_zeitgeist_application_match_type_id);
	}
	return synapse_zeitgeist_plugin_zeitgeist_application_match_type_id__volatile;
}

static void
_vala_synapse_zeitgeist_plugin_zeitgeist_application_match_get_property (GObject * object,
                                                                         guint property_id,
                                                                         GValue * value,
                                                                         GParamSpec * pspec)
{
	SynapseZeitgeistPluginZeitgeistApplicationMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_APPLICATION_MATCH, SynapseZeitgeistPluginZeitgeistApplicationMatch);
#line 43 "../../../src/plugins/zeitgeist-plugin.vala"
	switch (property_id) {
#line 4816 "zeitgeist-plugin.c"
		default:
#line 43 "../../../src/plugins/zeitgeist-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 43 "../../../src/plugins/zeitgeist-plugin.vala"
		break;
#line 4822 "zeitgeist-plugin.c"
	}
}

static void
_vala_synapse_zeitgeist_plugin_zeitgeist_application_match_set_property (GObject * object,
                                                                         guint property_id,
                                                                         const GValue * value,
                                                                         GParamSpec * pspec)
{
	SynapseZeitgeistPluginZeitgeistApplicationMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_APPLICATION_MATCH, SynapseZeitgeistPluginZeitgeistApplicationMatch);
#line 43 "../../../src/plugins/zeitgeist-plugin.vala"
	switch (property_id) {
#line 4836 "zeitgeist-plugin.c"
		default:
#line 43 "../../../src/plugins/zeitgeist-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 43 "../../../src/plugins/zeitgeist-plugin.vala"
		break;
#line 4842 "zeitgeist-plugin.c"
	}
}

static inline gpointer
synapse_zeitgeist_plugin_zeitgeist_uri_match_get_instance_private (SynapseZeitgeistPluginZeitgeistUriMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseZeitgeistPluginZeitgeistUriMatch_private_offset);
}

static SynapseZeitgeistPluginZeitgeistUriMatch*
synapse_zeitgeist_plugin_zeitgeist_uri_match_construct (GType object_type,
                                                        ZeitgeistEvent* event,
                                                        const gchar* thumbnail_path,
                                                        const gchar* icon,
                                                        gboolean use_origin)
{
	SynapseZeitgeistPluginZeitgeistUriMatch * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 75 "../../../src/plugins/zeitgeist-plugin.vala"
	g_return_val_if_fail (event != NULL, NULL);
#line 81 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp0_ = icon;
#line 81 "../../../src/plugins/zeitgeist-plugin.vala"
	if (_tmp0_ == NULL) {
#line 81 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp0_ = "";
#line 4870 "zeitgeist-plugin.c"
	}
#line 82 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp1_ = thumbnail_path;
#line 82 "../../../src/plugins/zeitgeist-plugin.vala"
	if (_tmp1_ == NULL) {
#line 82 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp1_ = "";
#line 4878 "zeitgeist-plugin.c"
	}
#line 80 "../../../src/plugins/zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPluginZeitgeistUriMatch*) g_object_new (object_type, "has-thumbnail", thumbnail_path != NULL, "icon-name", _tmp0_, "thumbnail-path", _tmp1_, NULL);
#line 84 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_zeitgeist_uri_match_init_from_event (self, event, use_origin);
#line 75 "../../../src/plugins/zeitgeist-plugin.vala"
	return self;
#line 4886 "zeitgeist-plugin.c"
}

static SynapseZeitgeistPluginZeitgeistUriMatch*
synapse_zeitgeist_plugin_zeitgeist_uri_match_new (ZeitgeistEvent* event,
                                                  const gchar* thumbnail_path,
                                                  const gchar* icon,
                                                  gboolean use_origin)
{
#line 75 "../../../src/plugins/zeitgeist-plugin.vala"
	return synapse_zeitgeist_plugin_zeitgeist_uri_match_construct (SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_URI_MATCH, event, thumbnail_path, icon, use_origin);
#line 4897 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_uri_match_init_from_event (SynapseZeitgeistPluginZeitgeistUriMatch* self,
                                                              ZeitgeistEvent* event,
                                                              gboolean use_origin)
{
	ZeitgeistSubject* subject = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	gconstpointer _tmp2_;
	ZeitgeistSubject* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GFile* f = NULL;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* text = NULL;
	ZeitgeistSubject* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	ZeitgeistSubject* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	const gchar* interpretation = NULL;
	ZeitgeistSubject* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
#line 87 "../../../src/plugins/zeitgeist-plugin.vala"
	g_return_if_fail (self != NULL);
#line 87 "../../../src/plugins/zeitgeist-plugin.vala"
	g_return_if_fail (event != NULL);
#line 90 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp0_ = zeitgeist_event_get_subjects (event);
#line 90 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp1_ = _tmp0_;
#line 90 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp2_ = g_ptr_array_index (_tmp1_, (guint) 0);
#line 90 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp3_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp2_);
#line 90 "../../../src/plugins/zeitgeist-plugin.vala"
	subject = _tmp3_;
#line 91 "../../../src/plugins/zeitgeist-plugin.vala"
	if (use_origin) {
#line 4946 "zeitgeist-plugin.c"
		ZeitgeistSubject* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
#line 91 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp5_ = subject;
#line 91 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp6_ = zeitgeist_subject_get_origin (_tmp5_);
#line 91 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp7_ = _tmp6_;
#line 91 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp4_ = _tmp7_;
#line 4958 "zeitgeist-plugin.c"
	} else {
		ZeitgeistSubject* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
#line 91 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp8_ = subject;
#line 91 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp9_ = zeitgeist_subject_get_current_uri (_tmp8_);
#line 91 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp10_ = _tmp9_;
#line 91 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp4_ = _tmp10_;
#line 4971 "zeitgeist-plugin.c"
	}
#line 91 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_uri_match_set_uri ((SynapseUriMatch*) self, _tmp4_);
#line 92 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp11_ = synapse_uri_match_get_uri ((SynapseUriMatch*) self);
#line 92 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp12_ = _tmp11_;
#line 92 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp13_ = g_file_new_for_uri (_tmp12_);
#line 92 "../../../src/plugins/zeitgeist-plugin.vala"
	f = _tmp13_;
#line 93 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp14_ = f;
#line 93 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp15_ = g_file_get_parse_name (_tmp14_);
#line 93 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp16_ = _tmp15_;
#line 93 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_match_set_description ((SynapseMatch*) self, _tmp16_);
#line 93 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_free0 (_tmp16_);
#line 95 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp17_ = subject;
#line 95 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp18_ = zeitgeist_subject_get_text (_tmp17_);
#line 95 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp19_ = _tmp18_;
#line 95 "../../../src/plugins/zeitgeist-plugin.vala"
	text = _tmp19_;
#line 96 "../../../src/plugins/zeitgeist-plugin.vala"
	if (use_origin) {
#line 5003 "zeitgeist-plugin.c"
		GFile* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
#line 98 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp20_ = f;
#line 98 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp21_ = g_file_get_parse_name (_tmp20_);
#line 98 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp22_ = _tmp21_;
#line 98 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp23_ = g_path_get_basename (_tmp22_);
#line 98 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp24_ = _tmp23_;
#line 98 "../../../src/plugins/zeitgeist-plugin.vala"
		synapse_match_set_title ((SynapseMatch*) self, _tmp24_);
#line 98 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_free0 (_tmp24_);
#line 98 "../../../src/plugins/zeitgeist-plugin.vala"
		_g_free0 (_tmp22_);
#line 5025 "zeitgeist-plugin.c"
	} else {
		gboolean _tmp25_ = FALSE;
		const gchar* _tmp26_;
#line 100 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp26_ = text;
#line 100 "../../../src/plugins/zeitgeist-plugin.vala"
		if (_tmp26_ == NULL) {
#line 100 "../../../src/plugins/zeitgeist-plugin.vala"
			_tmp25_ = TRUE;
#line 5035 "zeitgeist-plugin.c"
		} else {
			const gchar* _tmp27_;
#line 100 "../../../src/plugins/zeitgeist-plugin.vala"
			_tmp27_ = text;
#line 100 "../../../src/plugins/zeitgeist-plugin.vala"
			_tmp25_ = g_strcmp0 (_tmp27_, "") == 0;
#line 5042 "zeitgeist-plugin.c"
		}
#line 100 "../../../src/plugins/zeitgeist-plugin.vala"
		if (_tmp25_) {
#line 5046 "zeitgeist-plugin.c"
			const gchar* _tmp28_;
			const gchar* _tmp29_;
#line 102 "../../../src/plugins/zeitgeist-plugin.vala"
			_tmp28_ = synapse_match_get_description ((SynapseMatch*) self);
#line 102 "../../../src/plugins/zeitgeist-plugin.vala"
			_tmp29_ = _tmp28_;
#line 102 "../../../src/plugins/zeitgeist-plugin.vala"
			synapse_match_set_title ((SynapseMatch*) self, _tmp29_);
#line 5055 "zeitgeist-plugin.c"
		} else {
			const gchar* _tmp30_;
#line 106 "../../../src/plugins/zeitgeist-plugin.vala"
			_tmp30_ = text;
#line 106 "../../../src/plugins/zeitgeist-plugin.vala"
			synapse_match_set_title ((SynapseMatch*) self, _tmp30_);
#line 5062 "zeitgeist-plugin.c"
		}
	}
#line 109 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp31_ = subject;
#line 109 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp32_ = zeitgeist_subject_get_mimetype (_tmp31_);
#line 109 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp33_ = _tmp32_;
#line 109 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_uri_match_set_mime_type ((SynapseUriMatch*) self, _tmp33_);
#line 111 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp34_ = subject;
#line 111 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp35_ = zeitgeist_subject_get_interpretation (_tmp34_);
#line 111 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp36_ = _tmp35_;
#line 111 "../../../src/plugins/zeitgeist-plugin.vala"
	interpretation = _tmp36_;
#line 112 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp37_ = interpretation;
#line 112 "../../../src/plugins/zeitgeist-plugin.vala"
	if (zeitgeist_symbol_is_a (_tmp37_, ZEITGEIST_NFO_AUDIO)) {
#line 114 "../../../src/plugins/zeitgeist-plugin.vala"
		synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_AUDIO);
#line 5087 "zeitgeist-plugin.c"
	} else {
		const gchar* _tmp38_;
#line 116 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp38_ = interpretation;
#line 116 "../../../src/plugins/zeitgeist-plugin.vala"
		if (zeitgeist_symbol_is_a (_tmp38_, ZEITGEIST_NFO_VIDEO)) {
#line 118 "../../../src/plugins/zeitgeist-plugin.vala"
			synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_VIDEO);
#line 5096 "zeitgeist-plugin.c"
		} else {
			const gchar* _tmp39_;
#line 120 "../../../src/plugins/zeitgeist-plugin.vala"
			_tmp39_ = interpretation;
#line 120 "../../../src/plugins/zeitgeist-plugin.vala"
			if (zeitgeist_symbol_is_a (_tmp39_, ZEITGEIST_NFO_IMAGE)) {
#line 122 "../../../src/plugins/zeitgeist-plugin.vala"
				synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_IMAGES);
#line 5105 "zeitgeist-plugin.c"
			} else {
				const gchar* _tmp40_;
#line 124 "../../../src/plugins/zeitgeist-plugin.vala"
				_tmp40_ = interpretation;
#line 124 "../../../src/plugins/zeitgeist-plugin.vala"
				if (zeitgeist_symbol_is_a (_tmp40_, ZEITGEIST_NFO_DOCUMENT)) {
#line 126 "../../../src/plugins/zeitgeist-plugin.vala"
					synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_DOCUMENTS);
#line 5114 "zeitgeist-plugin.c"
				} else {
					const gchar* _tmp41_;
#line 128 "../../../src/plugins/zeitgeist-plugin.vala"
					_tmp41_ = interpretation;
#line 128 "../../../src/plugins/zeitgeist-plugin.vala"
					if (zeitgeist_symbol_is_a (_tmp41_, ZEITGEIST_NFO_WEBSITE)) {
#line 130 "../../../src/plugins/zeitgeist-plugin.vala"
						synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_INTERNET);
#line 5123 "zeitgeist-plugin.c"
					} else {
#line 134 "../../../src/plugins/zeitgeist-plugin.vala"
						synapse_uri_match_set_file_type ((SynapseUriMatch*) self, SYNAPSE_QUERY_FLAGS_UNCATEGORIZED);
#line 5127 "zeitgeist-plugin.c"
					}
				}
			}
		}
	}
#line 87 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (f);
#line 87 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (subject);
#line 5137 "zeitgeist-plugin.c"
}

static const gchar*
synapse_zeitgeist_plugin_zeitgeist_uri_match_real_get_extended_info (SynapseExtendedInfo* base)
{
	const gchar* result;
	SynapseZeitgeistPluginZeitgeistUriMatch* self;
	const gchar* _tmp0_;
#line 73 "../../../src/plugins/zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPluginZeitgeistUriMatch*) base;
#line 73 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp0_ = self->priv->_extended_info;
#line 73 "../../../src/plugins/zeitgeist-plugin.vala"
	result = _tmp0_;
#line 73 "../../../src/plugins/zeitgeist-plugin.vala"
	return result;
#line 5154 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_uri_match_real_set_extended_info (SynapseExtendedInfo* base,
                                                                     const gchar* value)
{
	SynapseZeitgeistPluginZeitgeistUriMatch* self;
	gchar* _tmp0_;
#line 73 "../../../src/plugins/zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPluginZeitgeistUriMatch*) base;
#line 73 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp0_ = g_strdup (value);
#line 73 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_free0 (self->priv->_extended_info);
#line 73 "../../../src/plugins/zeitgeist-plugin.vala"
	self->priv->_extended_info = _tmp0_;
#line 5171 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_uri_match_class_init (SynapseZeitgeistPluginZeitgeistUriMatchClass * klass,
                                                         gpointer klass_data)
{
#line 70 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_zeitgeist_uri_match_parent_class = g_type_class_peek_parent (klass);
#line 70 "../../../src/plugins/zeitgeist-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseZeitgeistPluginZeitgeistUriMatch_private_offset);
#line 70 "../../../src/plugins/zeitgeist-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_zeitgeist_plugin_zeitgeist_uri_match_get_property;
#line 70 "../../../src/plugins/zeitgeist-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_zeitgeist_plugin_zeitgeist_uri_match_set_property;
#line 70 "../../../src/plugins/zeitgeist-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_zeitgeist_plugin_zeitgeist_uri_match_finalize;
#line 5188 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_uri_match_synapse_extended_info_interface_init (SynapseExtendedInfoIface * iface,
                                                                                   gpointer iface_data)
{
#line 70 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_zeitgeist_uri_match_synapse_extended_info_parent_iface = g_type_interface_peek_parent (iface);
#line 70 "../../../src/plugins/zeitgeist-plugin.vala"
	iface->get_extended_info = synapse_zeitgeist_plugin_zeitgeist_uri_match_real_get_extended_info;
#line 70 "../../../src/plugins/zeitgeist-plugin.vala"
	iface->set_extended_info = synapse_zeitgeist_plugin_zeitgeist_uri_match_real_set_extended_info;
#line 5201 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_uri_match_instance_init (SynapseZeitgeistPluginZeitgeistUriMatch * self,
                                                            gpointer klass)
{
#line 70 "../../../src/plugins/zeitgeist-plugin.vala"
	self->priv = synapse_zeitgeist_plugin_zeitgeist_uri_match_get_instance_private (self);
#line 73 "../../../src/plugins/zeitgeist-plugin.vala"
	self->priv->_extended_info = NULL;
#line 5212 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_uri_match_finalize (GObject * obj)
{
	SynapseZeitgeistPluginZeitgeistUriMatch * self;
#line 70 "../../../src/plugins/zeitgeist-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_URI_MATCH, SynapseZeitgeistPluginZeitgeistUriMatch);
#line 73 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_free0 (self->priv->_extended_info);
#line 70 "../../../src/plugins/zeitgeist-plugin.vala"
	G_OBJECT_CLASS (synapse_zeitgeist_plugin_zeitgeist_uri_match_parent_class)->finalize (obj);
#line 5225 "zeitgeist-plugin.c"
}

static GType
synapse_zeitgeist_plugin_zeitgeist_uri_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseZeitgeistPluginZeitgeistUriMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_zeitgeist_plugin_zeitgeist_uri_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseZeitgeistPluginZeitgeistUriMatch), 0, (GInstanceInitFunc) synapse_zeitgeist_plugin_zeitgeist_uri_match_instance_init, NULL };
	static const GInterfaceInfo synapse_extended_info_info = { (GInterfaceInitFunc) synapse_zeitgeist_plugin_zeitgeist_uri_match_synapse_extended_info_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id;
	synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id = g_type_register_static (SYNAPSE_TYPE_URI_MATCH, "SynapseZeitgeistPluginZeitgeistUriMatch", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id, SYNAPSE_TYPE_EXTENDED_INFO, &synapse_extended_info_info);
	SynapseZeitgeistPluginZeitgeistUriMatch_private_offset = g_type_add_instance_private (synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id, sizeof (SynapseZeitgeistPluginZeitgeistUriMatchPrivate));
	return synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id;
}

static GType
synapse_zeitgeist_plugin_zeitgeist_uri_match_get_type (void)
{
	static volatile gsize synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id__volatile)) {
		GType synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id;
		synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id = synapse_zeitgeist_plugin_zeitgeist_uri_match_get_type_once ();
		g_once_init_leave (&synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id__volatile, synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id);
	}
	return synapse_zeitgeist_plugin_zeitgeist_uri_match_type_id__volatile;
}

static void
_vala_synapse_zeitgeist_plugin_zeitgeist_uri_match_get_property (GObject * object,
                                                                 guint property_id,
                                                                 GValue * value,
                                                                 GParamSpec * pspec)
{
	SynapseZeitgeistPluginZeitgeistUriMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_URI_MATCH, SynapseZeitgeistPluginZeitgeistUriMatch);
#line 70 "../../../src/plugins/zeitgeist-plugin.vala"
	switch (property_id) {
#line 5262 "zeitgeist-plugin.c"
		default:
#line 70 "../../../src/plugins/zeitgeist-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 70 "../../../src/plugins/zeitgeist-plugin.vala"
		break;
#line 5268 "zeitgeist-plugin.c"
	}
}

static void
_vala_synapse_zeitgeist_plugin_zeitgeist_uri_match_set_property (GObject * object,
                                                                 guint property_id,
                                                                 const GValue * value,
                                                                 GParamSpec * pspec)
{
	SynapseZeitgeistPluginZeitgeistUriMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_URI_MATCH, SynapseZeitgeistPluginZeitgeistUriMatch);
#line 70 "../../../src/plugins/zeitgeist-plugin.vala"
	switch (property_id) {
#line 5282 "zeitgeist-plugin.c"
		default:
#line 70 "../../../src/plugins/zeitgeist-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 70 "../../../src/plugins/zeitgeist-plugin.vala"
		break;
#line 5288 "zeitgeist-plugin.c"
	}
}

static SynapseMatch*
synapse_zeitgeist_plugin_zeitgeist_match_factory_get_match_for_event (ZeitgeistEvent* event,
                                                                      const gchar* thumbnail_path,
                                                                      const gchar* icon,
                                                                      SynapseQueryFlags obj_type)
{
	SynapseMatch* result = NULL;
#line 141 "../../../src/plugins/zeitgeist-plugin.vala"
	g_return_val_if_fail (event != NULL, NULL);
#line 146 "../../../src/plugins/zeitgeist-plugin.vala"
	if ((obj_type & SYNAPSE_QUERY_FLAGS_FILES) == SYNAPSE_QUERY_FLAGS_FILES) {
#line 5303 "zeitgeist-plugin.c"
		SynapseZeitgeistPluginZeitgeistUriMatch* _tmp0_;
#line 147 "../../../src/plugins/zeitgeist-plugin.vala"
		_tmp0_ = synapse_zeitgeist_plugin_zeitgeist_uri_match_new (event, thumbnail_path, icon, FALSE);
#line 147 "../../../src/plugins/zeitgeist-plugin.vala"
		result = (SynapseMatch*) _tmp0_;
#line 147 "../../../src/plugins/zeitgeist-plugin.vala"
		return result;
#line 5311 "zeitgeist-plugin.c"
	} else {
#line 148 "../../../src/plugins/zeitgeist-plugin.vala"
		if ((obj_type & SYNAPSE_QUERY_FLAGS_APPLICATIONS) == SYNAPSE_QUERY_FLAGS_APPLICATIONS) {
#line 5315 "zeitgeist-plugin.c"
			SynapseZeitgeistPluginZeitgeistApplicationMatch* _tmp1_;
#line 149 "../../../src/plugins/zeitgeist-plugin.vala"
			_tmp1_ = synapse_zeitgeist_plugin_zeitgeist_application_match_new (event, thumbnail_path, icon);
#line 149 "../../../src/plugins/zeitgeist-plugin.vala"
			result = (SynapseMatch*) _tmp1_;
#line 149 "../../../src/plugins/zeitgeist-plugin.vala"
			return result;
#line 5323 "zeitgeist-plugin.c"
		} else {
#line 150 "../../../src/plugins/zeitgeist-plugin.vala"
			if ((obj_type & SYNAPSE_QUERY_FLAGS_PLACES) == SYNAPSE_QUERY_FLAGS_PLACES) {
#line 5327 "zeitgeist-plugin.c"
				SynapseZeitgeistPluginZeitgeistUriMatch* _tmp2_;
#line 151 "../../../src/plugins/zeitgeist-plugin.vala"
				_tmp2_ = synapse_zeitgeist_plugin_zeitgeist_uri_match_new (event, thumbnail_path, icon, TRUE);
#line 151 "../../../src/plugins/zeitgeist-plugin.vala"
				result = (SynapseMatch*) _tmp2_;
#line 151 "../../../src/plugins/zeitgeist-plugin.vala"
				return result;
#line 5335 "zeitgeist-plugin.c"
			}
		}
	}
#line 153 "../../../src/plugins/zeitgeist-plugin.vala"
	g_assert_not_reached ();
#line 5341 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_match_factory_init_extended_info_from_event (SynapseExtendedInfo* match,
                                                                                ZeitgeistEvent* event)
{
	gint64 now = 0LL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gint64 _tmp2_;
	gint64 delta = 0LL;
	gint64 _tmp3_;
	gint64 _tmp4_;
#line 156 "../../../src/plugins/zeitgeist-plugin.vala"
	g_return_if_fail (match != NULL);
#line 156 "../../../src/plugins/zeitgeist-plugin.vala"
	g_return_if_fail (event != NULL);
#line 158 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp0_ = g_date_time_new_now_local ();
#line 158 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp1_ = _tmp0_;
#line 158 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp2_ = g_date_time_to_unix (_tmp1_) * 1000;
#line 158 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_date_time_unref0 (_tmp1_);
#line 158 "../../../src/plugins/zeitgeist-plugin.vala"
	now = _tmp2_;
#line 159 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp3_ = zeitgeist_event_get_timestamp (event);
#line 159 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp4_ = _tmp3_;
#line 159 "../../../src/plugins/zeitgeist-plugin.vala"
	delta = now - _tmp4_;
#line 160 "../../../src/plugins/zeitgeist-plugin.vala"
	if (delta < (ZEITGEIST_TIMESTAMP_MINUTE * 2)) {
#line 162 "../../../src/plugins/zeitgeist-plugin.vala"
		synapse_extended_info_set_extended_info (match, _ ("few moments ago"));
#line 5379 "zeitgeist-plugin.c"
	} else {
#line 164 "../../../src/plugins/zeitgeist-plugin.vala"
		if (delta < ZEITGEIST_TIMESTAMP_HOUR) {
#line 5383 "zeitgeist-plugin.c"
			gint mins = 0;
			gchar* _tmp5_;
			gchar* _tmp6_;
#line 166 "../../../src/plugins/zeitgeist-plugin.vala"
			mins = (gint) (delta / ZEITGEIST_TIMESTAMP_MINUTE);
#line 167 "../../../src/plugins/zeitgeist-plugin.vala"
			_tmp5_ = g_strdup_printf (ngettext ("%d minute ago", "%d minutes ago", (gulong) mins), mins);
#line 167 "../../../src/plugins/zeitgeist-plugin.vala"
			_tmp6_ = _tmp5_;
#line 167 "../../../src/plugins/zeitgeist-plugin.vala"
			synapse_extended_info_set_extended_info (match, _tmp6_);
#line 167 "../../../src/plugins/zeitgeist-plugin.vala"
			_g_free0 (_tmp6_);
#line 5397 "zeitgeist-plugin.c"
		} else {
#line 169 "../../../src/plugins/zeitgeist-plugin.vala"
			if (delta < (ZEITGEIST_TIMESTAMP_DAY * 2)) {
#line 5401 "zeitgeist-plugin.c"
				gint hours = 0;
				gchar* _tmp7_;
				gchar* _tmp8_;
#line 171 "../../../src/plugins/zeitgeist-plugin.vala"
				hours = (gint) (delta / ZEITGEIST_TIMESTAMP_HOUR);
#line 172 "../../../src/plugins/zeitgeist-plugin.vala"
				_tmp7_ = g_strdup_printf (ngettext ("%d hour ago", "%d hours ago", (gulong) hours), hours);
#line 172 "../../../src/plugins/zeitgeist-plugin.vala"
				_tmp8_ = _tmp7_;
#line 172 "../../../src/plugins/zeitgeist-plugin.vala"
				synapse_extended_info_set_extended_info (match, _tmp8_);
#line 172 "../../../src/plugins/zeitgeist-plugin.vala"
				_g_free0 (_tmp8_);
#line 5415 "zeitgeist-plugin.c"
			} else {
#line 174 "../../../src/plugins/zeitgeist-plugin.vala"
				if (delta < (ZEITGEIST_TIMESTAMP_WEEK * 2)) {
#line 5419 "zeitgeist-plugin.c"
					gint days = 0;
					gchar* _tmp9_;
					gchar* _tmp10_;
#line 176 "../../../src/plugins/zeitgeist-plugin.vala"
					days = (gint) (delta / ZEITGEIST_TIMESTAMP_DAY);
#line 177 "../../../src/plugins/zeitgeist-plugin.vala"
					_tmp9_ = g_strdup_printf (ngettext ("%d day ago", "%d days ago", (gulong) days), days);
#line 177 "../../../src/plugins/zeitgeist-plugin.vala"
					_tmp10_ = _tmp9_;
#line 177 "../../../src/plugins/zeitgeist-plugin.vala"
					synapse_extended_info_set_extended_info (match, _tmp10_);
#line 177 "../../../src/plugins/zeitgeist-plugin.vala"
					_g_free0 (_tmp10_);
#line 5433 "zeitgeist-plugin.c"
				} else {
#line 179 "../../../src/plugins/zeitgeist-plugin.vala"
					if (delta < ZEITGEIST_TIMESTAMP_YEAR) {
#line 5437 "zeitgeist-plugin.c"
						gint weeks = 0;
						gchar* _tmp11_;
						gchar* _tmp12_;
#line 181 "../../../src/plugins/zeitgeist-plugin.vala"
						weeks = (gint) (delta / ZEITGEIST_TIMESTAMP_WEEK);
#line 182 "../../../src/plugins/zeitgeist-plugin.vala"
						_tmp11_ = g_strdup_printf (ngettext ("%d week ago", "%d weeks ago", (gulong) weeks), weeks);
#line 182 "../../../src/plugins/zeitgeist-plugin.vala"
						_tmp12_ = _tmp11_;
#line 182 "../../../src/plugins/zeitgeist-plugin.vala"
						synapse_extended_info_set_extended_info (match, _tmp12_);
#line 182 "../../../src/plugins/zeitgeist-plugin.vala"
						_g_free0 (_tmp12_);
#line 5451 "zeitgeist-plugin.c"
					} else {
#line 186 "../../../src/plugins/zeitgeist-plugin.vala"
						synapse_extended_info_set_extended_info (match, _ ("long time ago"));
#line 5455 "zeitgeist-plugin.c"
					}
				}
			}
		}
	}
}

static SynapseZeitgeistPluginZeitgeistMatchFactory*
synapse_zeitgeist_plugin_zeitgeist_match_factory_construct (GType object_type)
{
	SynapseZeitgeistPluginZeitgeistMatchFactory* self = NULL;
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	self = (SynapseZeitgeistPluginZeitgeistMatchFactory*) g_type_create_instance (object_type);
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	return self;
#line 5471 "zeitgeist-plugin.c"
}

static SynapseZeitgeistPluginZeitgeistMatchFactory*
synapse_zeitgeist_plugin_zeitgeist_match_factory_new (void)
{
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	return synapse_zeitgeist_plugin_zeitgeist_match_factory_construct (SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY);
#line 5479 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_value_zeitgeist_match_factory_init (GValue* value)
{
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	value->data[0].v_pointer = NULL;
#line 5487 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_value_zeitgeist_match_factory_free_value (GValue* value)
{
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	if (value->data[0].v_pointer) {
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
		synapse_zeitgeist_plugin_zeitgeist_match_factory_unref (value->data[0].v_pointer);
#line 5497 "zeitgeist-plugin.c"
	}
}

static void
synapse_zeitgeist_plugin_value_zeitgeist_match_factory_copy_value (const GValue* src_value,
                                                                   GValue* dest_value)
{
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	if (src_value->data[0].v_pointer) {
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
		dest_value->data[0].v_pointer = synapse_zeitgeist_plugin_zeitgeist_match_factory_ref (src_value->data[0].v_pointer);
#line 5509 "zeitgeist-plugin.c"
	} else {
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5513 "zeitgeist-plugin.c"
	}
}

static gpointer
synapse_zeitgeist_plugin_value_zeitgeist_match_factory_peek_pointer (const GValue* value)
{
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	return value->data[0].v_pointer;
#line 5522 "zeitgeist-plugin.c"
}

static gchar*
synapse_zeitgeist_plugin_value_zeitgeist_match_factory_collect_value (GValue* value,
                                                                      guint n_collect_values,
                                                                      GTypeCValue* collect_values,
                                                                      guint collect_flags)
{
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	if (collect_values[0].v_pointer) {
#line 5533 "zeitgeist-plugin.c"
		SynapseZeitgeistPluginZeitgeistMatchFactory * object;
		object = collect_values[0].v_pointer;
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
		if (object->parent_instance.g_class == NULL) {
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5540 "zeitgeist-plugin.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5544 "zeitgeist-plugin.c"
		}
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
		value->data[0].v_pointer = synapse_zeitgeist_plugin_zeitgeist_match_factory_ref (object);
#line 5548 "zeitgeist-plugin.c"
	} else {
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
		value->data[0].v_pointer = NULL;
#line 5552 "zeitgeist-plugin.c"
	}
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	return NULL;
#line 5556 "zeitgeist-plugin.c"
}

static gchar*
synapse_zeitgeist_plugin_value_zeitgeist_match_factory_lcopy_value (const GValue* value,
                                                                    guint n_collect_values,
                                                                    GTypeCValue* collect_values,
                                                                    guint collect_flags)
{
	SynapseZeitgeistPluginZeitgeistMatchFactory ** object_p;
	object_p = collect_values[0].v_pointer;
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	if (!object_p) {
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5571 "zeitgeist-plugin.c"
	}
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	if (!value->data[0].v_pointer) {
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
		*object_p = NULL;
#line 5577 "zeitgeist-plugin.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
		*object_p = value->data[0].v_pointer;
#line 5581 "zeitgeist-plugin.c"
	} else {
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
		*object_p = synapse_zeitgeist_plugin_zeitgeist_match_factory_ref (value->data[0].v_pointer);
#line 5585 "zeitgeist-plugin.c"
	}
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	return NULL;
#line 5589 "zeitgeist-plugin.c"
}

static GParamSpec*
synapse_zeitgeist_plugin_param_spec_zeitgeist_match_factory (const gchar* name,
                                                             const gchar* nick,
                                                             const gchar* blurb,
                                                             GType object_type,
                                                             GParamFlags flags)
{
	SynapseZeitgeistPluginParamSpecZeitgeistMatchFactory* spec;
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY), NULL);
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	return G_PARAM_SPEC (spec);
#line 5608 "zeitgeist-plugin.c"
}

static gpointer
synapse_zeitgeist_plugin_value_get_zeitgeist_match_factory (const GValue* value)
{
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY), NULL);
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	return value->data[0].v_pointer;
#line 5618 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_value_set_zeitgeist_match_factory (GValue* value,
                                                            gpointer v_object)
{
	SynapseZeitgeistPluginZeitgeistMatchFactory * old;
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY));
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	old = value->data[0].v_pointer;
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	if (v_object) {
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY));
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
		value->data[0].v_pointer = v_object;
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
		synapse_zeitgeist_plugin_zeitgeist_match_factory_ref (value->data[0].v_pointer);
#line 5640 "zeitgeist-plugin.c"
	} else {
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
		value->data[0].v_pointer = NULL;
#line 5644 "zeitgeist-plugin.c"
	}
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	if (old) {
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
		synapse_zeitgeist_plugin_zeitgeist_match_factory_unref (old);
#line 5650 "zeitgeist-plugin.c"
	}
}

static void
synapse_zeitgeist_plugin_value_take_zeitgeist_match_factory (GValue* value,
                                                             gpointer v_object)
{
	SynapseZeitgeistPluginZeitgeistMatchFactory * old;
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY));
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	old = value->data[0].v_pointer;
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	if (v_object) {
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY));
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
		value->data[0].v_pointer = v_object;
#line 5671 "zeitgeist-plugin.c"
	} else {
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
		value->data[0].v_pointer = NULL;
#line 5675 "zeitgeist-plugin.c"
	}
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	if (old) {
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
		synapse_zeitgeist_plugin_zeitgeist_match_factory_unref (old);
#line 5681 "zeitgeist-plugin.c"
	}
}

static void
synapse_zeitgeist_plugin_zeitgeist_match_factory_class_init (SynapseZeitgeistPluginZeitgeistMatchFactoryClass * klass,
                                                             gpointer klass_data)
{
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_zeitgeist_match_factory_parent_class = g_type_class_peek_parent (klass);
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	((SynapseZeitgeistPluginZeitgeistMatchFactoryClass *) klass)->finalize = synapse_zeitgeist_plugin_zeitgeist_match_factory_finalize;
#line 5693 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_match_factory_instance_init (SynapseZeitgeistPluginZeitgeistMatchFactory * self,
                                                                gpointer klass)
{
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	self->ref_count = 1;
#line 5702 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_match_factory_finalize (SynapseZeitgeistPluginZeitgeistMatchFactory * obj)
{
	SynapseZeitgeistPluginZeitgeistMatchFactory * self;
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_ZEITGEIST_PLUGIN_TYPE_ZEITGEIST_MATCH_FACTORY, SynapseZeitgeistPluginZeitgeistMatchFactory);
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	g_signal_handlers_destroy (self);
#line 5713 "zeitgeist-plugin.c"
}

static GType
synapse_zeitgeist_plugin_zeitgeist_match_factory_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { synapse_zeitgeist_plugin_value_zeitgeist_match_factory_init, synapse_zeitgeist_plugin_value_zeitgeist_match_factory_free_value, synapse_zeitgeist_plugin_value_zeitgeist_match_factory_copy_value, synapse_zeitgeist_plugin_value_zeitgeist_match_factory_peek_pointer, "p", synapse_zeitgeist_plugin_value_zeitgeist_match_factory_collect_value, "p", synapse_zeitgeist_plugin_value_zeitgeist_match_factory_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SynapseZeitgeistPluginZeitgeistMatchFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_zeitgeist_plugin_zeitgeist_match_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseZeitgeistPluginZeitgeistMatchFactory), 0, (GInstanceInitFunc) synapse_zeitgeist_plugin_zeitgeist_match_factory_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType synapse_zeitgeist_plugin_zeitgeist_match_factory_type_id;
	synapse_zeitgeist_plugin_zeitgeist_match_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseZeitgeistPluginZeitgeistMatchFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return synapse_zeitgeist_plugin_zeitgeist_match_factory_type_id;
}

static GType
synapse_zeitgeist_plugin_zeitgeist_match_factory_get_type (void)
{
	static volatile gsize synapse_zeitgeist_plugin_zeitgeist_match_factory_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_zeitgeist_plugin_zeitgeist_match_factory_type_id__volatile)) {
		GType synapse_zeitgeist_plugin_zeitgeist_match_factory_type_id;
		synapse_zeitgeist_plugin_zeitgeist_match_factory_type_id = synapse_zeitgeist_plugin_zeitgeist_match_factory_get_type_once ();
		g_once_init_leave (&synapse_zeitgeist_plugin_zeitgeist_match_factory_type_id__volatile, synapse_zeitgeist_plugin_zeitgeist_match_factory_type_id);
	}
	return synapse_zeitgeist_plugin_zeitgeist_match_factory_type_id__volatile;
}

static gpointer
synapse_zeitgeist_plugin_zeitgeist_match_factory_ref (gpointer instance)
{
	SynapseZeitgeistPluginZeitgeistMatchFactory * self;
	self = instance;
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	g_atomic_int_inc (&self->ref_count);
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	return instance;
#line 5748 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_zeitgeist_match_factory_unref (gpointer instance)
{
	SynapseZeitgeistPluginZeitgeistMatchFactory * self;
	self = instance;
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
		SYNAPSE_ZEITGEIST_PLUGIN_ZEITGEIST_MATCH_FACTORY_GET_CLASS (self)->finalize (self);
#line 139 "../../../src/plugins/zeitgeist-plugin.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5762 "zeitgeist-plugin.c"
	}
}

static GObject *
synapse_zeitgeist_plugin_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseZeitgeistPlugin * self;
#line 212 "../../../src/plugins/zeitgeist-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_zeitgeist_plugin_parent_class);
#line 212 "../../../src/plugins/zeitgeist-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 212 "../../../src/plugins/zeitgeist-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_ZEITGEIST_PLUGIN, SynapseZeitgeistPlugin);
#line 212 "../../../src/plugins/zeitgeist-plugin.vala"
	return obj;
#line 5782 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_class_init (SynapseZeitgeistPluginClass * klass,
                                     gpointer klass_data)
{
	gchar* _tmp0_;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_parent_class = g_type_class_peek_parent (klass);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseZeitgeistPlugin_private_offset);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_zeitgeist_plugin_get_property;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_zeitgeist_plugin_set_property;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_zeitgeist_plugin_constructor;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_zeitgeist_plugin_finalize;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_ENABLED_PROPERTY, synapse_zeitgeist_plugin_properties[SYNAPSE_ZEITGEIST_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_PLUGIN_DATA_SINK_PROPERTY, synapse_zeitgeist_plugin_properties[SYNAPSE_ZEITGEIST_PLUGIN_DATA_SINK_PROPERTY] = g_param_spec_object ("data-sink", "data-sink", "data-sink", SYNAPSE_TYPE_DATA_SINK, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 233 "../../../src/plugins/zeitgeist-plugin.vala"
	_tmp0_ = g_strjoin (",", G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_STANDARD_ICON, G_FILE_ATTRIBUTE_THUMBNAIL_PATH, G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN, NULL, NULL);
#line 233 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_interesting_attributes = _tmp0_;
#line 206 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_register_plugin ();
#line 5812 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                             gpointer iface_data)
{
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_zeitgeist_plugin_real_activate;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_zeitgeist_plugin_real_deactivate;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	iface->get_enabled = synapse_zeitgeist_plugin_real_get_enabled;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	iface->set_enabled = synapse_zeitgeist_plugin_real_set_enabled;
#line 5829 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                               gpointer iface_data)
{
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	synapse_zeitgeist_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	iface->handles_empty_query = (gboolean (*) (SynapseItemProvider*)) synapse_zeitgeist_plugin_real_handles_empty_query;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_zeitgeist_plugin_real_search;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_zeitgeist_plugin_search_finish;
#line 5844 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_instance_init (SynapseZeitgeistPlugin * self,
                                        gpointer klass)
{
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	self->priv = synapse_zeitgeist_plugin_get_instance_private (self);
#line 26 "../../../src/plugins/zeitgeist-plugin.vala"
	self->priv->_enabled = TRUE;
#line 634 "../../../src/plugins/zeitgeist-plugin.vala"
	self->priv->search_in_progress = FALSE;
#line 5857 "zeitgeist-plugin.c"
}

static void
synapse_zeitgeist_plugin_finalize (GObject * obj)
{
	SynapseZeitgeistPlugin * self;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_ZEITGEIST_PLUGIN, SynapseZeitgeistPlugin);
#line 209 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (self->priv->zg_index);
#line 210 "../../../src/plugins/zeitgeist-plugin.vala"
	_g_object_unref0 (self->priv->zg_log);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	G_OBJECT_CLASS (synapse_zeitgeist_plugin_parent_class)->finalize (obj);
#line 5872 "zeitgeist-plugin.c"
}

static GType
synapse_zeitgeist_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseZeitgeistPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_zeitgeist_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseZeitgeistPlugin), 0, (GInstanceInitFunc) synapse_zeitgeist_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_zeitgeist_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_zeitgeist_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_zeitgeist_plugin_type_id;
	synapse_zeitgeist_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseZeitgeistPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_zeitgeist_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_zeitgeist_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseZeitgeistPlugin_private_offset = g_type_add_instance_private (synapse_zeitgeist_plugin_type_id, sizeof (SynapseZeitgeistPluginPrivate));
	return synapse_zeitgeist_plugin_type_id;
}

GType
synapse_zeitgeist_plugin_get_type (void)
{
	static volatile gsize synapse_zeitgeist_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_zeitgeist_plugin_type_id__volatile)) {
		GType synapse_zeitgeist_plugin_type_id;
		synapse_zeitgeist_plugin_type_id = synapse_zeitgeist_plugin_get_type_once ();
		g_once_init_leave (&synapse_zeitgeist_plugin_type_id__volatile, synapse_zeitgeist_plugin_type_id);
	}
	return synapse_zeitgeist_plugin_type_id__volatile;
}

static void
_vala_synapse_zeitgeist_plugin_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	SynapseZeitgeistPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_ZEITGEIST_PLUGIN, SynapseZeitgeistPlugin);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	switch (property_id) {
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
		case SYNAPSE_ZEITGEIST_PLUGIN_ENABLED_PROPERTY:
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
		break;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
		case SYNAPSE_ZEITGEIST_PLUGIN_DATA_SINK_PROPERTY:
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
		g_value_set_object (value, synapse_zeitgeist_plugin_get_data_sink (self));
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
		break;
#line 5923 "zeitgeist-plugin.c"
		default:
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
		break;
#line 5929 "zeitgeist-plugin.c"
	}
}

static void
_vala_synapse_zeitgeist_plugin_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	SynapseZeitgeistPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_ZEITGEIST_PLUGIN, SynapseZeitgeistPlugin);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
	switch (property_id) {
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
		case SYNAPSE_ZEITGEIST_PLUGIN_ENABLED_PROPERTY:
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
		break;
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
		case SYNAPSE_ZEITGEIST_PLUGIN_DATA_SINK_PROPERTY:
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
		synapse_zeitgeist_plugin_set_data_sink (self, g_value_get_object (value));
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
		break;
#line 5955 "zeitgeist-plugin.c"
		default:
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../../../src/plugins/zeitgeist-plugin.vala"
		break;
#line 5961 "zeitgeist-plugin.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 24 "../../../src/plugins/pastebin-plugin.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 5972 "zeitgeist-plugin.c"
		gint i;
#line 24 "../../../src/plugins/pastebin-plugin.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 24 "../../../src/plugins/pastebin-plugin.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 24 "../../../src/plugins/pastebin-plugin.vala"
				destroy_func (((gpointer*) array)[i]);
#line 5980 "zeitgeist-plugin.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 24 "../../../src/plugins/pastebin-plugin.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 24 "../../../src/plugins/pastebin-plugin.vala"
	g_free (array);
#line 5995 "zeitgeist-plugin.c"
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
#line 24 "../../../src/plugins/pastebin-plugin.vala"
	if (array) {
#line 24 "../../../src/plugins/pastebin-plugin.vala"
		while (((gpointer*) array)[length]) {
#line 24 "../../../src/plugins/pastebin-plugin.vala"
			length++;
#line 6009 "zeitgeist-plugin.c"
		}
	}
#line 24 "../../../src/plugins/pastebin-plugin.vala"
	return length;
#line 6014 "zeitgeist-plugin.c"
}

