/* tile-view.c generated by valac 0.48.17, the Vala compiler
 * generated from tile-view.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>

#define UI_WIDGETS_TYPE_TILE_VIEW (ui_widgets_tile_view_get_type ())
#define UI_WIDGETS_TILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UI_WIDGETS_TYPE_TILE_VIEW, UIWidgetsTileView))
#define UI_WIDGETS_TILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UI_WIDGETS_TYPE_TILE_VIEW, UIWidgetsTileViewClass))
#define UI_WIDGETS_IS_TILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UI_WIDGETS_TYPE_TILE_VIEW))
#define UI_WIDGETS_IS_TILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UI_WIDGETS_TYPE_TILE_VIEW))
#define UI_WIDGETS_TILE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UI_WIDGETS_TYPE_TILE_VIEW, UIWidgetsTileViewClass))

typedef struct _UIWidgetsTileView UIWidgetsTileView;
typedef struct _UIWidgetsTileViewClass UIWidgetsTileViewClass;
typedef struct _UIWidgetsTileViewPrivate UIWidgetsTileViewPrivate;

#define UI_WIDGETS_TYPE_ABSTRACT_TILE_OBJECT (ui_widgets_abstract_tile_object_get_type ())
#define UI_WIDGETS_ABSTRACT_TILE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UI_WIDGETS_TYPE_ABSTRACT_TILE_OBJECT, UIWidgetsAbstractTileObject))
#define UI_WIDGETS_ABSTRACT_TILE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UI_WIDGETS_TYPE_ABSTRACT_TILE_OBJECT, UIWidgetsAbstractTileObjectClass))
#define UI_WIDGETS_IS_ABSTRACT_TILE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UI_WIDGETS_TYPE_ABSTRACT_TILE_OBJECT))
#define UI_WIDGETS_IS_ABSTRACT_TILE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UI_WIDGETS_TYPE_ABSTRACT_TILE_OBJECT))
#define UI_WIDGETS_ABSTRACT_TILE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UI_WIDGETS_TYPE_ABSTRACT_TILE_OBJECT, UIWidgetsAbstractTileObjectClass))

typedef struct _UIWidgetsAbstractTileObject UIWidgetsAbstractTileObject;
typedef struct _UIWidgetsAbstractTileObjectClass UIWidgetsAbstractTileObjectClass;

#define UI_WIDGETS_TYPE_TILE (ui_widgets_tile_get_type ())
#define UI_WIDGETS_TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UI_WIDGETS_TYPE_TILE, UIWidgetsTile))
#define UI_WIDGETS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UI_WIDGETS_TYPE_TILE, UIWidgetsTileClass))
#define UI_WIDGETS_IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UI_WIDGETS_TYPE_TILE))
#define UI_WIDGETS_IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UI_WIDGETS_TYPE_TILE))
#define UI_WIDGETS_TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UI_WIDGETS_TYPE_TILE, UIWidgetsTileClass))

typedef struct _UIWidgetsTile UIWidgetsTile;
typedef struct _UIWidgetsTileClass UIWidgetsTileClass;
enum  {
	UI_WIDGETS_TILE_VIEW_0_PROPERTY,
	UI_WIDGETS_TILE_VIEW_ICON_SIZE_PROPERTY,
	UI_WIDGETS_TILE_VIEW_NUM_PROPERTIES
};
static GParamSpec* ui_widgets_tile_view_properties[UI_WIDGETS_TILE_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_region_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_region_destroy (var), NULL)))

struct _UIWidgetsTileView {
	GtkEventBox parent_instance;
	UIWidgetsTileViewPrivate * priv;
	gint selected_index;
};

struct _UIWidgetsTileViewClass {
	GtkEventBoxClass parent_class;
	void (*append_tile) (UIWidgetsTileView* self, UIWidgetsAbstractTileObject* tile_obj);
	void (*remove_tile) (UIWidgetsTileView* self, UIWidgetsAbstractTileObject* tile_obj);
	void (*clear_selection) (UIWidgetsTileView* self);
	UIWidgetsAbstractTileObject* (*get_current_tile) (UIWidgetsTileView* self);
	void (*on_tile_active_changed) (UIWidgetsTileView* self, UIWidgetsTile* tile);
	void (*on_tile_size_allocated) (UIWidgetsTileView* self, GtkWidget* w, GtkAllocation* alloc);
};

struct _UIWidgetsTileViewPrivate {
	GList* tiles;
	GtkBox* box;
	gint _icon_size;
	gboolean changing_style;
};

static gint UIWidgetsTileView_private_offset;
static gpointer ui_widgets_tile_view_parent_class = NULL;

GType ui_widgets_tile_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UIWidgetsTileView, g_object_unref)
GType ui_widgets_abstract_tile_object_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UIWidgetsAbstractTileObject, g_object_unref)
GType ui_widgets_tile_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UIWidgetsTile, g_object_unref)
void ui_widgets_tile_view_append_tile (UIWidgetsTileView* self,
                                       UIWidgetsAbstractTileObject* tile_obj);
void ui_widgets_tile_view_remove_tile (UIWidgetsTileView* self,
                                       UIWidgetsAbstractTileObject* tile_obj);
void ui_widgets_tile_view_clear_selection (UIWidgetsTileView* self);
UIWidgetsAbstractTileObject* ui_widgets_tile_view_get_current_tile (UIWidgetsTileView* self);
void ui_widgets_tile_view_on_tile_active_changed (UIWidgetsTileView* self,
                                                  UIWidgetsTile* tile);
void ui_widgets_tile_view_on_tile_size_allocated (UIWidgetsTileView* self,
                                                  GtkWidget* w,
                                                  GtkAllocation* alloc);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
UIWidgetsTileView* ui_widgets_tile_view_new (void);
UIWidgetsTileView* ui_widgets_tile_view_construct (GType object_type);
gboolean ui_widgets_tile_view_on_button_press (UIWidgetsTileView* self,
                                               GdkEventButton* event);
static gboolean _ui_widgets_tile_view_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                              GdkEventButton* event,
                                                                              gpointer self);
gboolean ui_widgets_tile_view_on_key_press (UIWidgetsTileView* self,
                                            GdkEventKey* event);
static gboolean _ui_widgets_tile_view_on_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                        GdkEventKey* event,
                                                                        gpointer self);
static void ui_widgets_tile_view_real_append_tile (UIWidgetsTileView* self,
                                            UIWidgetsAbstractTileObject* tile_obj);
gint ui_widgets_tile_view_get_icon_size (UIWidgetsTileView* self);
UIWidgetsTile* ui_widgets_tile_new (UIWidgetsAbstractTileObject* obj,
                                    gint icon_size);
UIWidgetsTile* ui_widgets_tile_construct (GType object_type,
                                          UIWidgetsAbstractTileObject* obj,
                                          gint icon_size);
void ui_widgets_tile_set_owner (UIWidgetsTile* self,
                                UIWidgetsTileView* value);
static void _ui_widgets_tile_view_on_tile_active_changed_ui_widgets_tile_active_changed (UIWidgetsTile* _sender,
                                                                                  gpointer self);
static void _ui_widgets_tile_view_on_tile_size_allocated_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                            GtkAllocation* allocation,
                                                                            gpointer self);
static void ui_widgets_tile_view_real_remove_tile (UIWidgetsTileView* self,
                                            UIWidgetsAbstractTileObject* tile_obj);
UIWidgetsAbstractTileObject* ui_widgets_tile_get_owned_object (UIWidgetsTile* self);
GList* ui_widgets_tile_view_get_tiles (UIWidgetsTileView* self);
void ui_widgets_tile_view_clear (UIWidgetsTileView* self);
static void ui_widgets_tile_view_real_clear_selection (UIWidgetsTileView* self);
void ui_widgets_tile_set_selected (UIWidgetsTile* self,
                                   gboolean selected);
static UIWidgetsAbstractTileObject* ui_widgets_tile_view_real_get_current_tile (UIWidgetsTileView* self);
static void ui_widgets_tile_view_real_style_updated (GtkWidget* base);
static void ui_widgets_tile_view_real_on_tile_active_changed (UIWidgetsTileView* self,
                                                       UIWidgetsTile* tile);
void ui_widgets_tile_update_state (UIWidgetsTile* self);
static void ui_widgets_tile_view_real_on_tile_size_allocated (UIWidgetsTileView* self,
                                                       GtkWidget* w,
                                                       GtkAllocation* alloc);
void ui_widgets_tile_view_select (UIWidgetsTileView* self,
                                  gint index);
void ui_widgets_tile_view_set_icon_size (UIWidgetsTileView* self,
                                         gint value);
static void ui_widgets_tile_view_finalize (GObject * obj);
static GType ui_widgets_tile_view_get_type_once (void);
static void _vala_ui_widgets_tile_view_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_ui_widgets_tile_view_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
ui_widgets_tile_view_get_instance_private (UIWidgetsTileView* self)
{
	return G_STRUCT_MEMBER_P (self, UIWidgetsTileView_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
#line 26 "../../../src/ui/tile-view/tile-view.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 187 "tile-view.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 26 "../../../src/ui/tile-view/tile-view.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 195 "tile-view.c"
}

static gboolean
_ui_widgets_tile_view_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                     GdkEventButton* event,
                                                                     gpointer self)
{
	gboolean result;
	result = ui_widgets_tile_view_on_button_press ((UIWidgetsTileView*) self, event);
#line 37 "../../../src/ui/tile-view/tile-view.vala"
	return result;
#line 207 "tile-view.c"
}

static gboolean
_ui_widgets_tile_view_on_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                               GdkEventKey* event,
                                                               gpointer self)
{
	gboolean result;
	result = ui_widgets_tile_view_on_key_press ((UIWidgetsTileView*) self, event);
#line 38 "../../../src/ui/tile-view/tile-view.vala"
	return result;
#line 219 "tile-view.c"
}

UIWidgetsTileView*
ui_widgets_tile_view_construct (GType object_type)
{
	UIWidgetsTileView * self = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
#line 35 "../../../src/ui/tile-view/tile-view.vala"
	self = (UIWidgetsTileView*) g_object_new (object_type, "can-focus", TRUE, "visible-window", FALSE, NULL);
#line 37 "../../../src/ui/tile-view/tile-view.vala"
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) _ui_widgets_tile_view_on_button_press_gtk_widget_button_press_event, self, 0);
#line 38 "../../../src/ui/tile-view/tile-view.vala"
	g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) _ui_widgets_tile_view_on_key_press_gtk_widget_key_press_event, self, 0);
#line 39 "../../../src/ui/tile-view/tile-view.vala"
	_tmp0_ = self->priv->box;
#line 39 "../../../src/ui/tile-view/tile-view.vala"
	gtk_box_set_homogeneous (_tmp0_, FALSE);
#line 40 "../../../src/ui/tile-view/tile-view.vala"
	_tmp1_ = self->priv->box;
#line 40 "../../../src/ui/tile-view/tile-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp1_);
#line 41 "../../../src/ui/tile-view/tile-view.vala"
	_tmp2_ = self->priv->box;
#line 41 "../../../src/ui/tile-view/tile-view.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
#line 43 "../../../src/ui/tile-view/tile-view.vala"
	g_signal_emit_by_name ((GtkWidget*) self, "style-updated");
#line 33 "../../../src/ui/tile-view/tile-view.vala"
	return self;
#line 251 "tile-view.c"
}

UIWidgetsTileView*
ui_widgets_tile_view_new (void)
{
#line 33 "../../../src/ui/tile-view/tile-view.vala"
	return ui_widgets_tile_view_construct (UI_WIDGETS_TYPE_TILE_VIEW);
#line 259 "tile-view.c"
}

static void
_ui_widgets_tile_view_on_tile_active_changed_ui_widgets_tile_active_changed (UIWidgetsTile* _sender,
                                                                             gpointer self)
{
#line 50 "../../../src/ui/tile-view/tile-view.vala"
	ui_widgets_tile_view_on_tile_active_changed ((UIWidgetsTileView*) self, _sender);
#line 268 "tile-view.c"
}

static void
_ui_widgets_tile_view_on_tile_size_allocated_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                       GtkAllocation* allocation,
                                                                       gpointer self)
{
#line 51 "../../../src/ui/tile-view/tile-view.vala"
	ui_widgets_tile_view_on_tile_size_allocated ((UIWidgetsTileView*) self, _sender, allocation);
#line 278 "tile-view.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 54 "../../../src/ui/tile-view/tile-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 286 "tile-view.c"
}

static void
ui_widgets_tile_view_real_append_tile (UIWidgetsTileView* self,
                                       UIWidgetsAbstractTileObject* tile_obj)
{
	UIWidgetsTile* tile = NULL;
	gint _tmp0_;
	UIWidgetsTile* _tmp1_;
	UIWidgetsTile* _tmp2_;
	GtkBox* _tmp3_;
#line 46 "../../../src/ui/tile-view/tile-view.vala"
	g_return_if_fail (tile_obj != NULL);
#line 48 "../../../src/ui/tile-view/tile-view.vala"
	_tmp0_ = self->priv->_icon_size;
#line 48 "../../../src/ui/tile-view/tile-view.vala"
	_tmp1_ = ui_widgets_tile_new (tile_obj, _tmp0_);
#line 48 "../../../src/ui/tile-view/tile-view.vala"
	g_object_ref_sink (_tmp1_);
#line 48 "../../../src/ui/tile-view/tile-view.vala"
	tile = _tmp1_;
#line 49 "../../../src/ui/tile-view/tile-view.vala"
	ui_widgets_tile_set_owner (tile, self);
#line 50 "../../../src/ui/tile-view/tile-view.vala"
	g_signal_connect_object (tile, "active-changed", (GCallback) _ui_widgets_tile_view_on_tile_active_changed_ui_widgets_tile_active_changed, self, 0);
#line 51 "../../../src/ui/tile-view/tile-view.vala"
	g_signal_connect_object ((GtkWidget*) tile, "size-allocate", (GCallback) _ui_widgets_tile_view_on_tile_size_allocated_gtk_widget_size_allocate, self, 0);
#line 52 "../../../src/ui/tile-view/tile-view.vala"
	gtk_widget_show ((GtkWidget*) tile);
#line 54 "../../../src/ui/tile-view/tile-view.vala"
	_tmp2_ = _g_object_ref0 (tile);
#line 54 "../../../src/ui/tile-view/tile-view.vala"
	self->priv->tiles = g_list_append (self->priv->tiles, _tmp2_);
#line 56 "../../../src/ui/tile-view/tile-view.vala"
	_tmp3_ = self->priv->box;
#line 56 "../../../src/ui/tile-view/tile-view.vala"
	gtk_box_pack_start (_tmp3_, (GtkWidget*) tile, FALSE, FALSE, (guint) 0);
#line 46 "../../../src/ui/tile-view/tile-view.vala"
	_g_object_unref0 (tile);
#line 326 "tile-view.c"
}

void
ui_widgets_tile_view_append_tile (UIWidgetsTileView* self,
                                  UIWidgetsAbstractTileObject* tile_obj)
{
#line 46 "../../../src/ui/tile-view/tile-view.vala"
	g_return_if_fail (self != NULL);
#line 46 "../../../src/ui/tile-view/tile-view.vala"
	UI_WIDGETS_TILE_VIEW_GET_CLASS (self)->append_tile (self, tile_obj);
#line 337 "tile-view.c"
}

static void
ui_widgets_tile_view_real_remove_tile (UIWidgetsTileView* self,
                                       UIWidgetsAbstractTileObject* tile_obj)
{
	UIWidgetsTile* tile = NULL;
	GList* _tmp0_;
	UIWidgetsTile* _tmp5_;
	GList* _tmp6_;
	UIWidgetsTile* _tmp7_;
	UIWidgetsTile* _tmp8_;
	UIWidgetsTile* _tmp9_;
	guint _tmp10_;
	UIWidgetsTile* _tmp11_;
	guint _tmp12_;
	UIWidgetsTile* _tmp13_;
	GtkBox* _tmp14_;
	UIWidgetsTile* _tmp15_;
	UIWidgetsTile* _tmp16_;
#line 59 "../../../src/ui/tile-view/tile-view.vala"
	g_return_if_fail (tile_obj != NULL);
#line 61 "../../../src/ui/tile-view/tile-view.vala"
	tile = NULL;
#line 62 "../../../src/ui/tile-view/tile-view.vala"
	_tmp0_ = self->priv->tiles;
#line 364 "tile-view.c"
	{
		GList* t_collection = NULL;
		GList* t_it = NULL;
#line 62 "../../../src/ui/tile-view/tile-view.vala"
		t_collection = _tmp0_;
#line 62 "../../../src/ui/tile-view/tile-view.vala"
		for (t_it = t_collection; t_it != NULL; t_it = t_it->next) {
#line 372 "tile-view.c"
			UIWidgetsTile* t = NULL;
#line 62 "../../../src/ui/tile-view/tile-view.vala"
			t = (UIWidgetsTile*) t_it->data;
#line 376 "tile-view.c"
			{
				UIWidgetsTile* _tmp1_;
				UIWidgetsAbstractTileObject* _tmp2_;
				UIWidgetsAbstractTileObject* _tmp3_;
#line 64 "../../../src/ui/tile-view/tile-view.vala"
				_tmp1_ = t;
#line 64 "../../../src/ui/tile-view/tile-view.vala"
				_tmp2_ = ui_widgets_tile_get_owned_object (_tmp1_);
#line 64 "../../../src/ui/tile-view/tile-view.vala"
				_tmp3_ = _tmp2_;
#line 64 "../../../src/ui/tile-view/tile-view.vala"
				if (_tmp3_ == tile_obj) {
#line 389 "tile-view.c"
					UIWidgetsTile* _tmp4_;
#line 66 "../../../src/ui/tile-view/tile-view.vala"
					_tmp4_ = t;
#line 66 "../../../src/ui/tile-view/tile-view.vala"
					tile = _tmp4_;
#line 67 "../../../src/ui/tile-view/tile-view.vala"
					break;
#line 397 "tile-view.c"
				}
			}
		}
	}
#line 71 "../../../src/ui/tile-view/tile-view.vala"
	_tmp5_ = tile;
#line 71 "../../../src/ui/tile-view/tile-view.vala"
	if (_tmp5_ == NULL) {
#line 73 "../../../src/ui/tile-view/tile-view.vala"
		g_warning ("tile-view.vala:73: Container does not own this AbstractTileObject!");
#line 74 "../../../src/ui/tile-view/tile-view.vala"
		return;
#line 410 "tile-view.c"
	}
#line 77 "../../../src/ui/tile-view/tile-view.vala"
	_tmp6_ = self->priv->tiles;
#line 77 "../../../src/ui/tile-view/tile-view.vala"
	_tmp7_ = tile;
#line 77 "../../../src/ui/tile-view/tile-view.vala"
	if (self->selected_index == g_list_index (_tmp6_, _tmp7_)) {
#line 79 "../../../src/ui/tile-view/tile-view.vala"
		ui_widgets_tile_view_clear_selection (self);
#line 420 "tile-view.c"
	}
#line 82 "../../../src/ui/tile-view/tile-view.vala"
	_tmp8_ = tile;
#line 82 "../../../src/ui/tile-view/tile-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp8_);
#line 83 "../../../src/ui/tile-view/tile-view.vala"
	_tmp9_ = tile;
#line 83 "../../../src/ui/tile-view/tile-view.vala"
	g_signal_parse_name ("active-changed", UI_WIDGETS_TYPE_TILE, &_tmp10_, NULL, FALSE);
#line 83 "../../../src/ui/tile-view/tile-view.vala"
	g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _ui_widgets_tile_view_on_tile_active_changed_ui_widgets_tile_active_changed, self);
#line 84 "../../../src/ui/tile-view/tile-view.vala"
	_tmp11_ = tile;
#line 84 "../../../src/ui/tile-view/tile-view.vala"
	g_signal_parse_name ("size-allocate", gtk_widget_get_type (), &_tmp12_, NULL, FALSE);
#line 84 "../../../src/ui/tile-view/tile-view.vala"
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _ui_widgets_tile_view_on_tile_size_allocated_gtk_widget_size_allocate, self);
#line 85 "../../../src/ui/tile-view/tile-view.vala"
	_tmp13_ = tile;
#line 85 "../../../src/ui/tile-view/tile-view.vala"
	ui_widgets_tile_set_owner (_tmp13_, NULL);
#line 87 "../../../src/ui/tile-view/tile-view.vala"
	_tmp14_ = self->priv->box;
#line 87 "../../../src/ui/tile-view/tile-view.vala"
	_tmp15_ = tile;
#line 87 "../../../src/ui/tile-view/tile-view.vala"
	gtk_container_remove ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
#line 88 "../../../src/ui/tile-view/tile-view.vala"
	_tmp16_ = tile;
#line 88 "../../../src/ui/tile-view/tile-view.vala"
	self->priv->tiles = g_list_remove (self->priv->tiles, _tmp16_);
#line 452 "tile-view.c"
}

void
ui_widgets_tile_view_remove_tile (UIWidgetsTileView* self,
                                  UIWidgetsAbstractTileObject* tile_obj)
{
#line 59 "../../../src/ui/tile-view/tile-view.vala"
	g_return_if_fail (self != NULL);
#line 59 "../../../src/ui/tile-view/tile-view.vala"
	UI_WIDGETS_TILE_VIEW_GET_CLASS (self)->remove_tile (self, tile_obj);
#line 463 "tile-view.c"
}

GList*
ui_widgets_tile_view_get_tiles (UIWidgetsTileView* self)
{
	GList* _result_ = NULL;
	GList* _tmp0_;
	GList* result = NULL;
#line 91 "../../../src/ui/tile-view/tile-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 93 "../../../src/ui/tile-view/tile-view.vala"
	_result_ = NULL;
#line 95 "../../../src/ui/tile-view/tile-view.vala"
	_tmp0_ = self->priv->tiles;
#line 478 "tile-view.c"
	{
		GList* t_collection = NULL;
		GList* t_it = NULL;
#line 95 "../../../src/ui/tile-view/tile-view.vala"
		t_collection = _tmp0_;
#line 95 "../../../src/ui/tile-view/tile-view.vala"
		for (t_it = t_collection; t_it != NULL; t_it = t_it->next) {
#line 486 "tile-view.c"
			UIWidgetsTile* t = NULL;
#line 95 "../../../src/ui/tile-view/tile-view.vala"
			t = (UIWidgetsTile*) t_it->data;
#line 490 "tile-view.c"
			{
				UIWidgetsTile* _tmp1_;
				UIWidgetsAbstractTileObject* _tmp2_;
				UIWidgetsAbstractTileObject* _tmp3_;
#line 97 "../../../src/ui/tile-view/tile-view.vala"
				_tmp1_ = t;
#line 97 "../../../src/ui/tile-view/tile-view.vala"
				_tmp2_ = ui_widgets_tile_get_owned_object (_tmp1_);
#line 97 "../../../src/ui/tile-view/tile-view.vala"
				_tmp3_ = _tmp2_;
#line 97 "../../../src/ui/tile-view/tile-view.vala"
				_result_ = g_list_prepend (_result_, _tmp3_);
#line 503 "tile-view.c"
			}
		}
	}
#line 99 "../../../src/ui/tile-view/tile-view.vala"
	_result_ = g_list_reverse (_result_);
#line 101 "../../../src/ui/tile-view/tile-view.vala"
	result = _result_;
#line 101 "../../../src/ui/tile-view/tile-view.vala"
	return result;
#line 513 "tile-view.c"
}

void
ui_widgets_tile_view_clear (UIWidgetsTileView* self)
{
	GList* tiles_copy = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
#line 104 "../../../src/ui/tile-view/tile-view.vala"
	g_return_if_fail (self != NULL);
#line 106 "../../../src/ui/tile-view/tile-view.vala"
	_tmp0_ = ui_widgets_tile_view_get_tiles (self);
#line 106 "../../../src/ui/tile-view/tile-view.vala"
	tiles_copy = _tmp0_;
#line 107 "../../../src/ui/tile-view/tile-view.vala"
	_tmp1_ = tiles_copy;
#line 530 "tile-view.c"
	{
		GList* to_collection = NULL;
		GList* to_it = NULL;
#line 107 "../../../src/ui/tile-view/tile-view.vala"
		to_collection = _tmp1_;
#line 107 "../../../src/ui/tile-view/tile-view.vala"
		for (to_it = to_collection; to_it != NULL; to_it = to_it->next) {
#line 538 "tile-view.c"
			UIWidgetsAbstractTileObject* to = NULL;
#line 107 "../../../src/ui/tile-view/tile-view.vala"
			to = (UIWidgetsAbstractTileObject*) to_it->data;
#line 542 "tile-view.c"
			{
				UIWidgetsAbstractTileObject* _tmp2_;
#line 109 "../../../src/ui/tile-view/tile-view.vala"
				_tmp2_ = to;
#line 109 "../../../src/ui/tile-view/tile-view.vala"
				ui_widgets_tile_view_remove_tile (self, _tmp2_);
#line 549 "tile-view.c"
			}
		}
	}
#line 104 "../../../src/ui/tile-view/tile-view.vala"
	(tiles_copy == NULL) ? NULL : (tiles_copy = (g_list_free (tiles_copy), NULL));
#line 555 "tile-view.c"
}

static void
ui_widgets_tile_view_real_clear_selection (UIWidgetsTileView* self)
{
	GList* _tmp0_;
	gint _tmp1_;
#line 115 "../../../src/ui/tile-view/tile-view.vala"
	_tmp0_ = self->priv->tiles;
#line 115 "../../../src/ui/tile-view/tile-view.vala"
	_tmp1_ = self->selected_index;
#line 115 "../../../src/ui/tile-view/tile-view.vala"
	if ((0 <= _tmp1_) && (_tmp1_ < g_list_length (_tmp0_))) {
#line 569 "tile-view.c"
		GList* _tmp2_;
		gconstpointer _tmp3_;
#line 117 "../../../src/ui/tile-view/tile-view.vala"
		_tmp2_ = self->priv->tiles;
#line 117 "../../../src/ui/tile-view/tile-view.vala"
		_tmp3_ = g_list_nth_data (_tmp2_, (guint) self->selected_index);
#line 117 "../../../src/ui/tile-view/tile-view.vala"
		ui_widgets_tile_set_selected ((UIWidgetsTile*) _tmp3_, FALSE);
#line 578 "tile-view.c"
	}
#line 120 "../../../src/ui/tile-view/tile-view.vala"
	self->selected_index = -1;
#line 582 "tile-view.c"
}

void
ui_widgets_tile_view_clear_selection (UIWidgetsTileView* self)
{
#line 113 "../../../src/ui/tile-view/tile-view.vala"
	g_return_if_fail (self != NULL);
#line 113 "../../../src/ui/tile-view/tile-view.vala"
	UI_WIDGETS_TILE_VIEW_GET_CLASS (self)->clear_selection (self);
#line 592 "tile-view.c"
}

static UIWidgetsAbstractTileObject*
ui_widgets_tile_view_real_get_current_tile (UIWidgetsTileView* self)
{
	GList* _tmp0_;
	gint _tmp1_;
	UIWidgetsAbstractTileObject* result = NULL;
#line 125 "../../../src/ui/tile-view/tile-view.vala"
	_tmp0_ = self->priv->tiles;
#line 125 "../../../src/ui/tile-view/tile-view.vala"
	_tmp1_ = self->selected_index;
#line 125 "../../../src/ui/tile-view/tile-view.vala"
	if ((0 <= _tmp1_) && (_tmp1_ < g_list_length (_tmp0_))) {
#line 607 "tile-view.c"
		GList* _tmp2_;
		gconstpointer _tmp3_;
		UIWidgetsAbstractTileObject* _tmp4_;
		UIWidgetsAbstractTileObject* _tmp5_;
		UIWidgetsAbstractTileObject* _tmp6_;
#line 127 "../../../src/ui/tile-view/tile-view.vala"
		_tmp2_ = self->priv->tiles;
#line 127 "../../../src/ui/tile-view/tile-view.vala"
		_tmp3_ = g_list_nth_data (_tmp2_, (guint) self->selected_index);
#line 127 "../../../src/ui/tile-view/tile-view.vala"
		_tmp4_ = ui_widgets_tile_get_owned_object ((UIWidgetsTile*) _tmp3_);
#line 127 "../../../src/ui/tile-view/tile-view.vala"
		_tmp5_ = _tmp4_;
#line 127 "../../../src/ui/tile-view/tile-view.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 127 "../../../src/ui/tile-view/tile-view.vala"
		result = _tmp6_;
#line 127 "../../../src/ui/tile-view/tile-view.vala"
		return result;
#line 627 "tile-view.c"
	}
#line 130 "../../../src/ui/tile-view/tile-view.vala"
	result = NULL;
#line 130 "../../../src/ui/tile-view/tile-view.vala"
	return result;
#line 633 "tile-view.c"
}

UIWidgetsAbstractTileObject*
ui_widgets_tile_view_get_current_tile (UIWidgetsTileView* self)
{
#line 123 "../../../src/ui/tile-view/tile-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 123 "../../../src/ui/tile-view/tile-view.vala"
	return UI_WIDGETS_TILE_VIEW_GET_CLASS (self)->get_current_tile (self);
#line 643 "tile-view.c"
}

static void
ui_widgets_tile_view_real_style_updated (GtkWidget* base)
{
	UIWidgetsTileView * self;
#line 135 "../../../src/ui/tile-view/tile-view.vala"
	self = (UIWidgetsTileView*) base;
#line 652 "tile-view.c"
}

static void
ui_widgets_tile_view_real_on_tile_active_changed (UIWidgetsTileView* self,
                                                  UIWidgetsTile* tile)
{
	UIWidgetsAbstractTileObject* _tmp0_;
	UIWidgetsAbstractTileObject* _tmp1_;
	GList* _tmp2_;
#line 146 "../../../src/ui/tile-view/tile-view.vala"
	g_return_if_fail (tile != NULL);
#line 148 "../../../src/ui/tile-view/tile-view.vala"
	_tmp0_ = ui_widgets_tile_get_owned_object (tile);
#line 148 "../../../src/ui/tile-view/tile-view.vala"
	_tmp1_ = _tmp0_;
#line 148 "../../../src/ui/tile-view/tile-view.vala"
	g_signal_emit_by_name (_tmp1_, "active-changed");
#line 150 "../../../src/ui/tile-view/tile-view.vala"
	_tmp2_ = self->priv->tiles;
#line 672 "tile-view.c"
	{
		GList* t_collection = NULL;
		GList* t_it = NULL;
#line 150 "../../../src/ui/tile-view/tile-view.vala"
		t_collection = _tmp2_;
#line 150 "../../../src/ui/tile-view/tile-view.vala"
		for (t_it = t_collection; t_it != NULL; t_it = t_it->next) {
#line 680 "tile-view.c"
			UIWidgetsTile* t = NULL;
#line 150 "../../../src/ui/tile-view/tile-view.vala"
			t = (UIWidgetsTile*) t_it->data;
#line 684 "tile-view.c"
			{
				UIWidgetsTile* _tmp3_;
#line 152 "../../../src/ui/tile-view/tile-view.vala"
				_tmp3_ = t;
#line 152 "../../../src/ui/tile-view/tile-view.vala"
				ui_widgets_tile_update_state (_tmp3_);
#line 691 "tile-view.c"
			}
		}
	}
}

void
ui_widgets_tile_view_on_tile_active_changed (UIWidgetsTileView* self,
                                             UIWidgetsTile* tile)
{
#line 146 "../../../src/ui/tile-view/tile-view.vala"
	g_return_if_fail (self != NULL);
#line 146 "../../../src/ui/tile-view/tile-view.vala"
	UI_WIDGETS_TILE_VIEW_GET_CLASS (self)->on_tile_active_changed (self, tile);
#line 705 "tile-view.c"
}

static void
ui_widgets_tile_view_real_on_tile_size_allocated (UIWidgetsTileView* self,
                                                  GtkWidget* w,
                                                  GtkAllocation* alloc)
{
	UIWidgetsTile* tile = NULL;
	UIWidgetsTile* _tmp0_;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp1_ = NULL;
	GtkContainer* _tmp2_;
	GtkScrolledWindow* _tmp5_;
	GtkScrolledWindow* _tmp6_;
	GList* _tmp7_;
	UIWidgetsTile* _tmp8_;
	GtkAdjustment* scroll_vadj = NULL;
	GtkScrolledWindow* _tmp9_;
	GtkAdjustment* _tmp10_;
	GdkRectangle va = {0};
	GtkAdjustment* _tmp11_;
	GtkAllocation _tmp12_;
	GtkContainer* _tmp13_;
	GdkRectangle _tmp14_ = {0};
	cairo_region_t* va_region = NULL;
	GdkRectangle _tmp15_;
	cairo_region_t* _tmp16_;
	cairo_region_t* _tmp17_;
	GtkAllocation _tmp18_;
	cairo_rectangle_int_t _tmp19_;
#line 156 "../../../src/ui/tile-view/tile-view.vala"
	g_return_if_fail (w != NULL);
#line 156 "../../../src/ui/tile-view/tile-view.vala"
	g_return_if_fail (alloc != NULL);
#line 158 "../../../src/ui/tile-view/tile-view.vala"
	_tmp0_ = _g_object_ref0 (UI_WIDGETS_IS_TILE (w) ? ((UIWidgetsTile*) w) : NULL);
#line 158 "../../../src/ui/tile-view/tile-view.vala"
	tile = _tmp0_;
#line 159 "../../../src/ui/tile-view/tile-view.vala"
	scroll = NULL;
#line 161 "../../../src/ui/tile-view/tile-view.vala"
	_tmp2_ = gtk_widget_get_parent ((GtkWidget*) self);
#line 161 "../../../src/ui/tile-view/tile-view.vala"
	if (_tmp2_ == NULL) {
#line 162 "../../../src/ui/tile-view/tile-view.vala"
		_tmp1_ = NULL;
#line 752 "tile-view.c"
	} else {
		GtkContainer* _tmp3_;
		GtkContainer* _tmp4_;
#line 162 "../../../src/ui/tile-view/tile-view.vala"
		_tmp3_ = gtk_widget_get_parent ((GtkWidget*) self);
#line 162 "../../../src/ui/tile-view/tile-view.vala"
		_tmp4_ = gtk_widget_get_parent ((GtkWidget*) _tmp3_);
#line 162 "../../../src/ui/tile-view/tile-view.vala"
		_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_scrolled_window_get_type ()) ? ((GtkScrolledWindow*) _tmp4_) : NULL;
#line 762 "tile-view.c"
	}
#line 161 "../../../src/ui/tile-view/tile-view.vala"
	_tmp5_ = _g_object_ref0 (_tmp1_);
#line 161 "../../../src/ui/tile-view/tile-view.vala"
	_g_object_unref0 (scroll);
#line 161 "../../../src/ui/tile-view/tile-view.vala"
	scroll = _tmp5_;
#line 163 "../../../src/ui/tile-view/tile-view.vala"
	_tmp6_ = scroll;
#line 163 "../../../src/ui/tile-view/tile-view.vala"
	if (_tmp6_ == NULL) {
#line 165 "../../../src/ui/tile-view/tile-view.vala"
		_g_object_unref0 (scroll);
#line 165 "../../../src/ui/tile-view/tile-view.vala"
		_g_object_unref0 (tile);
#line 165 "../../../src/ui/tile-view/tile-view.vala"
		return;
#line 780 "tile-view.c"
	}
#line 168 "../../../src/ui/tile-view/tile-view.vala"
	_tmp7_ = self->priv->tiles;
#line 168 "../../../src/ui/tile-view/tile-view.vala"
	_tmp8_ = tile;
#line 168 "../../../src/ui/tile-view/tile-view.vala"
	if (g_list_index (_tmp7_, _tmp8_) != self->selected_index) {
#line 170 "../../../src/ui/tile-view/tile-view.vala"
		_g_object_unref0 (scroll);
#line 170 "../../../src/ui/tile-view/tile-view.vala"
		_g_object_unref0 (tile);
#line 170 "../../../src/ui/tile-view/tile-view.vala"
		return;
#line 794 "tile-view.c"
	}
#line 173 "../../../src/ui/tile-view/tile-view.vala"
	_tmp9_ = scroll;
#line 173 "../../../src/ui/tile-view/tile-view.vala"
	_tmp10_ = gtk_scrolled_window_get_vadjustment (_tmp9_);
#line 173 "../../../src/ui/tile-view/tile-view.vala"
	scroll_vadj = _tmp10_;
#line 174 "../../../src/ui/tile-view/tile-view.vala"
	_tmp11_ = scroll_vadj;
#line 174 "../../../src/ui/tile-view/tile-view.vala"
	_tmp12_ = *alloc;
#line 174 "../../../src/ui/tile-view/tile-view.vala"
	_tmp13_ = gtk_widget_get_parent ((GtkWidget*) self);
#line 174 "../../../src/ui/tile-view/tile-view.vala"
	_tmp14_.x = 0;
#line 174 "../../../src/ui/tile-view/tile-view.vala"
	_tmp14_.y = (gint) gtk_adjustment_get_value (_tmp11_);
#line 174 "../../../src/ui/tile-view/tile-view.vala"
	_tmp14_.width = _tmp12_.width;
#line 174 "../../../src/ui/tile-view/tile-view.vala"
	_tmp14_.height = gtk_widget_get_allocated_height ((GtkWidget*) _tmp13_);
#line 174 "../../../src/ui/tile-view/tile-view.vala"
	va = _tmp14_;
#line 177 "../../../src/ui/tile-view/tile-view.vala"
	_tmp15_ = va;
#line 177 "../../../src/ui/tile-view/tile-view.vala"
	_tmp16_ = cairo_region_create_rectangle (&_tmp15_);
#line 177 "../../../src/ui/tile-view/tile-view.vala"
	va_region = _tmp16_;
#line 178 "../../../src/ui/tile-view/tile-view.vala"
	_tmp17_ = va_region;
#line 178 "../../../src/ui/tile-view/tile-view.vala"
	_tmp18_ = *alloc;
#line 178 "../../../src/ui/tile-view/tile-view.vala"
	_tmp19_ = (cairo_rectangle_int_t) _tmp18_;
#line 178 "../../../src/ui/tile-view/tile-view.vala"
	if (cairo_region_contains_rectangle (_tmp17_, &_tmp19_) != CAIRO_REGION_OVERLAP_IN) {
#line 832 "tile-view.c"
		gdouble delta = 0.0;
		GtkAllocation _tmp20_;
		GtkAllocation _tmp21_;
		GdkRectangle _tmp22_;
		GdkRectangle _tmp23_;
		GtkAdjustment* _tmp34_;
		GdkRectangle _tmp35_;
#line 180 "../../../src/ui/tile-view/tile-view.vala"
		delta = 0.0;
#line 181 "../../../src/ui/tile-view/tile-view.vala"
		_tmp20_ = *alloc;
#line 181 "../../../src/ui/tile-view/tile-view.vala"
		_tmp21_ = *alloc;
#line 181 "../../../src/ui/tile-view/tile-view.vala"
		_tmp22_ = va;
#line 181 "../../../src/ui/tile-view/tile-view.vala"
		_tmp23_ = va;
#line 181 "../../../src/ui/tile-view/tile-view.vala"
		if ((_tmp20_.y + _tmp21_.height) > (_tmp22_.y + _tmp23_.height)) {
#line 852 "tile-view.c"
			GtkAllocation _tmp24_;
			GtkAllocation _tmp25_;
			GdkRectangle _tmp26_;
			GdkRectangle _tmp27_;
			GtkStyle* _tmp28_;
			GtkStyle* _tmp29_;
#line 183 "../../../src/ui/tile-view/tile-view.vala"
			_tmp24_ = *alloc;
#line 183 "../../../src/ui/tile-view/tile-view.vala"
			_tmp25_ = *alloc;
#line 183 "../../../src/ui/tile-view/tile-view.vala"
			_tmp26_ = va;
#line 183 "../../../src/ui/tile-view/tile-view.vala"
			_tmp27_ = va;
#line 183 "../../../src/ui/tile-view/tile-view.vala"
			delta = (gdouble) ((_tmp24_.y + _tmp25_.height) - (_tmp26_.y + _tmp27_.height));
#line 184 "../../../src/ui/tile-view/tile-view.vala"
			_tmp28_ = gtk_widget_get_style ((GtkWidget*) self);
#line 184 "../../../src/ui/tile-view/tile-view.vala"
			_tmp29_ = _tmp28_;
#line 184 "../../../src/ui/tile-view/tile-view.vala"
			delta += (gdouble) (_tmp29_->ythickness * 2);
#line 875 "tile-view.c"
		} else {
			GtkAllocation _tmp30_;
			GdkRectangle _tmp31_;
#line 186 "../../../src/ui/tile-view/tile-view.vala"
			_tmp30_ = *alloc;
#line 186 "../../../src/ui/tile-view/tile-view.vala"
			_tmp31_ = va;
#line 186 "../../../src/ui/tile-view/tile-view.vala"
			if (_tmp30_.y < _tmp31_.y) {
#line 885 "tile-view.c"
				GtkAllocation _tmp32_;
				GdkRectangle _tmp33_;
#line 188 "../../../src/ui/tile-view/tile-view.vala"
				_tmp32_ = *alloc;
#line 188 "../../../src/ui/tile-view/tile-view.vala"
				_tmp33_ = va;
#line 188 "../../../src/ui/tile-view/tile-view.vala"
				delta = (gdouble) (_tmp32_.y - _tmp33_.y);
#line 894 "tile-view.c"
			}
		}
#line 191 "../../../src/ui/tile-view/tile-view.vala"
		_tmp34_ = scroll_vadj;
#line 191 "../../../src/ui/tile-view/tile-view.vala"
		_tmp35_ = va;
#line 191 "../../../src/ui/tile-view/tile-view.vala"
		gtk_adjustment_set_value (_tmp34_, _tmp35_.y + delta);
#line 192 "../../../src/ui/tile-view/tile-view.vala"
		gtk_widget_queue_draw ((GtkWidget*) self);
#line 905 "tile-view.c"
	}
#line 156 "../../../src/ui/tile-view/tile-view.vala"
	_cairo_region_destroy0 (va_region);
#line 156 "../../../src/ui/tile-view/tile-view.vala"
	_g_object_unref0 (scroll);
#line 156 "../../../src/ui/tile-view/tile-view.vala"
	_g_object_unref0 (tile);
#line 913 "tile-view.c"
}

void
ui_widgets_tile_view_on_tile_size_allocated (UIWidgetsTileView* self,
                                             GtkWidget* w,
                                             GtkAllocation* alloc)
{
#line 156 "../../../src/ui/tile-view/tile-view.vala"
	g_return_if_fail (self != NULL);
#line 156 "../../../src/ui/tile-view/tile-view.vala"
	UI_WIDGETS_TILE_VIEW_GET_CLASS (self)->on_tile_size_allocated (self, w, alloc);
#line 925 "tile-view.c"
}

gboolean
ui_widgets_tile_view_on_button_press (UIWidgetsTileView* self,
                                      GdkEventButton* event)
{
	gboolean result = FALSE;
#line 196 "../../../src/ui/tile-view/tile-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 196 "../../../src/ui/tile-view/tile-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 198 "../../../src/ui/tile-view/tile-view.vala"
	g_object_set ((GtkWidget*) self, "has-focus", TRUE, NULL);
#line 200 "../../../src/ui/tile-view/tile-view.vala"
	ui_widgets_tile_view_clear_selection (self);
#line 941 "tile-view.c"
	{
		gint i = 0;
#line 202 "../../../src/ui/tile-view/tile-view.vala"
		i = 0;
#line 946 "tile-view.c"
		{
			gboolean _tmp0_ = FALSE;
#line 202 "../../../src/ui/tile-view/tile-view.vala"
			_tmp0_ = TRUE;
#line 202 "../../../src/ui/tile-view/tile-view.vala"
			while (TRUE) {
#line 953 "tile-view.c"
				GList* _tmp2_;
				UIWidgetsTile* t = NULL;
				GList* _tmp3_;
				gconstpointer _tmp4_;
				GtkAllocation alloc = {0};
				UIWidgetsTile* _tmp5_;
				GtkAllocation _tmp6_ = {0};
				cairo_region_t* region = NULL;
				GtkAllocation _tmp7_;
				cairo_rectangle_int_t _tmp8_;
				cairo_region_t* _tmp9_;
				cairo_region_t* _tmp10_;
#line 202 "../../../src/ui/tile-view/tile-view.vala"
				if (!_tmp0_) {
#line 968 "tile-view.c"
					gint _tmp1_;
#line 202 "../../../src/ui/tile-view/tile-view.vala"
					_tmp1_ = i;
#line 202 "../../../src/ui/tile-view/tile-view.vala"
					i = _tmp1_ + 1;
#line 974 "tile-view.c"
				}
#line 202 "../../../src/ui/tile-view/tile-view.vala"
				_tmp0_ = FALSE;
#line 202 "../../../src/ui/tile-view/tile-view.vala"
				_tmp2_ = self->priv->tiles;
#line 202 "../../../src/ui/tile-view/tile-view.vala"
				if (!(((guint) i) < g_list_length (_tmp2_))) {
#line 202 "../../../src/ui/tile-view/tile-view.vala"
					break;
#line 984 "tile-view.c"
				}
#line 204 "../../../src/ui/tile-view/tile-view.vala"
				_tmp3_ = self->priv->tiles;
#line 204 "../../../src/ui/tile-view/tile-view.vala"
				_tmp4_ = g_list_nth_data (_tmp3_, (guint) i);
#line 204 "../../../src/ui/tile-view/tile-view.vala"
				t = (UIWidgetsTile*) _tmp4_;
#line 206 "../../../src/ui/tile-view/tile-view.vala"
				_tmp5_ = t;
#line 206 "../../../src/ui/tile-view/tile-view.vala"
				gtk_widget_get_allocation ((GtkWidget*) _tmp5_, &_tmp6_);
#line 206 "../../../src/ui/tile-view/tile-view.vala"
				alloc = _tmp6_;
#line 207 "../../../src/ui/tile-view/tile-view.vala"
				_tmp7_ = alloc;
#line 207 "../../../src/ui/tile-view/tile-view.vala"
				_tmp8_ = (cairo_rectangle_int_t) _tmp7_;
#line 207 "../../../src/ui/tile-view/tile-view.vala"
				_tmp9_ = cairo_region_create_rectangle (&_tmp8_);
#line 207 "../../../src/ui/tile-view/tile-view.vala"
				region = _tmp9_;
#line 208 "../../../src/ui/tile-view/tile-view.vala"
				_tmp10_ = region;
#line 208 "../../../src/ui/tile-view/tile-view.vala"
				if (cairo_region_contains_point (_tmp10_, (gint) event->x, (gint) event->y)) {
#line 210 "../../../src/ui/tile-view/tile-view.vala"
					ui_widgets_tile_view_select (self, i);
#line 211 "../../../src/ui/tile-view/tile-view.vala"
					_cairo_region_destroy0 (region);
#line 211 "../../../src/ui/tile-view/tile-view.vala"
					break;
#line 1016 "tile-view.c"
				}
#line 202 "../../../src/ui/tile-view/tile-view.vala"
				_cairo_region_destroy0 (region);
#line 1020 "tile-view.c"
			}
		}
	}
#line 215 "../../../src/ui/tile-view/tile-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 217 "../../../src/ui/tile-view/tile-view.vala"
	result = FALSE;
#line 217 "../../../src/ui/tile-view/tile-view.vala"
	return result;
#line 1030 "tile-view.c"
}

gboolean
ui_widgets_tile_view_on_key_press (UIWidgetsTileView* self,
                                   GdkEventKey* event)
{
	gint index = 0;
	GList* _tmp2_;
	gboolean result = FALSE;
#line 220 "../../../src/ui/tile-view/tile-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 220 "../../../src/ui/tile-view/tile-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 222 "../../../src/ui/tile-view/tile-view.vala"
	index = self->selected_index;
#line 224 "../../../src/ui/tile-view/tile-view.vala"
	switch (event->keyval) {
#line 224 "../../../src/ui/tile-view/tile-view.vala"
		case GDK_KEY_Up:
#line 224 "../../../src/ui/tile-view/tile-view.vala"
		case GDK_KEY_KP_Up:
#line 224 "../../../src/ui/tile-view/tile-view.vala"
		case GDK_KEY_uparrow:
#line 1054 "tile-view.c"
		{
			gint _tmp0_;
#line 229 "../../../src/ui/tile-view/tile-view.vala"
			_tmp0_ = index;
#line 229 "../../../src/ui/tile-view/tile-view.vala"
			index = _tmp0_ - 1;
#line 230 "../../../src/ui/tile-view/tile-view.vala"
			break;
#line 1063 "tile-view.c"
		}
#line 224 "../../../src/ui/tile-view/tile-view.vala"
		case GDK_KEY_Down:
#line 224 "../../../src/ui/tile-view/tile-view.vala"
		case GDK_KEY_KP_Down:
#line 224 "../../../src/ui/tile-view/tile-view.vala"
		case GDK_KEY_downarrow:
#line 1071 "tile-view.c"
		{
			gint _tmp1_;
#line 234 "../../../src/ui/tile-view/tile-view.vala"
			_tmp1_ = index;
#line 234 "../../../src/ui/tile-view/tile-view.vala"
			index = _tmp1_ + 1;
#line 235 "../../../src/ui/tile-view/tile-view.vala"
			break;
#line 1080 "tile-view.c"
		}
		default:
#line 224 "../../../src/ui/tile-view/tile-view.vala"
		break;
#line 1085 "tile-view.c"
	}
#line 238 "../../../src/ui/tile-view/tile-view.vala"
	_tmp2_ = self->priv->tiles;
#line 238 "../../../src/ui/tile-view/tile-view.vala"
	index = CLAMP (index, 0, ((gint) g_list_length (_tmp2_)) - 1);
#line 240 "../../../src/ui/tile-view/tile-view.vala"
	if (index != self->selected_index) {
#line 242 "../../../src/ui/tile-view/tile-view.vala"
		ui_widgets_tile_view_clear_selection (self);
#line 243 "../../../src/ui/tile-view/tile-view.vala"
		ui_widgets_tile_view_select (self, index);
#line 244 "../../../src/ui/tile-view/tile-view.vala"
		result = TRUE;
#line 244 "../../../src/ui/tile-view/tile-view.vala"
		return result;
#line 1101 "tile-view.c"
	}
#line 247 "../../../src/ui/tile-view/tile-view.vala"
	result = FALSE;
#line 247 "../../../src/ui/tile-view/tile-view.vala"
	return result;
#line 1107 "tile-view.c"
}

void
ui_widgets_tile_view_select (UIWidgetsTileView* self,
                             gint index)
{
	GList* _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	GtkContainer* _tmp5_;
#line 250 "../../../src/ui/tile-view/tile-view.vala"
	g_return_if_fail (self != NULL);
#line 252 "../../../src/ui/tile-view/tile-view.vala"
	_tmp0_ = self->priv->tiles;
#line 252 "../../../src/ui/tile-view/tile-view.vala"
	_tmp1_ = index;
#line 252 "../../../src/ui/tile-view/tile-view.vala"
	if ((0 <= _tmp1_) && (_tmp1_ < g_list_length (_tmp0_))) {
#line 1126 "tile-view.c"
		GList* _tmp2_;
		gconstpointer _tmp3_;
#line 254 "../../../src/ui/tile-view/tile-view.vala"
		self->selected_index = index;
#line 255 "../../../src/ui/tile-view/tile-view.vala"
		_tmp2_ = self->priv->tiles;
#line 255 "../../../src/ui/tile-view/tile-view.vala"
		_tmp3_ = g_list_nth_data (_tmp2_, (guint) index);
#line 255 "../../../src/ui/tile-view/tile-view.vala"
		ui_widgets_tile_set_selected ((UIWidgetsTile*) _tmp3_, TRUE);
#line 1137 "tile-view.c"
	} else {
#line 259 "../../../src/ui/tile-view/tile-view.vala"
		ui_widgets_tile_view_clear_selection (self);
#line 1141 "tile-view.c"
	}
#line 262 "../../../src/ui/tile-view/tile-view.vala"
	_tmp5_ = gtk_widget_get_parent ((GtkWidget*) self);
#line 262 "../../../src/ui/tile-view/tile-view.vala"
	if (_tmp5_ != NULL) {
#line 1147 "tile-view.c"
		GtkContainer* _tmp6_;
#line 262 "../../../src/ui/tile-view/tile-view.vala"
		_tmp6_ = gtk_widget_get_parent ((GtkWidget*) self);
#line 262 "../../../src/ui/tile-view/tile-view.vala"
		_tmp4_ = gtk_widget_get_realized ((GtkWidget*) _tmp6_);
#line 1153 "tile-view.c"
	} else {
#line 262 "../../../src/ui/tile-view/tile-view.vala"
		_tmp4_ = FALSE;
#line 1157 "tile-view.c"
	}
#line 262 "../../../src/ui/tile-view/tile-view.vala"
	if (_tmp4_) {
#line 1161 "tile-view.c"
		GtkContainer* _tmp7_;
#line 264 "../../../src/ui/tile-view/tile-view.vala"
		_tmp7_ = gtk_widget_get_parent ((GtkWidget*) self);
#line 264 "../../../src/ui/tile-view/tile-view.vala"
		gtk_widget_queue_draw ((GtkWidget*) _tmp7_);
#line 1167 "tile-view.c"
	}
#line 267 "../../../src/ui/tile-view/tile-view.vala"
	gtk_widget_queue_resize ((GtkWidget*) self);
#line 1171 "tile-view.c"
}

gint
ui_widgets_tile_view_get_icon_size (UIWidgetsTileView* self)
{
	gint result;
#line 29 "../../../src/ui/tile-view/tile-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 29 "../../../src/ui/tile-view/tile-view.vala"
	result = self->priv->_icon_size;
#line 29 "../../../src/ui/tile-view/tile-view.vala"
	return result;
#line 1184 "tile-view.c"
}

void
ui_widgets_tile_view_set_icon_size (UIWidgetsTileView* self,
                                    gint value)
{
	gint old_value;
#line 29 "../../../src/ui/tile-view/tile-view.vala"
	g_return_if_fail (self != NULL);
#line 29 "../../../src/ui/tile-view/tile-view.vala"
	old_value = ui_widgets_tile_view_get_icon_size (self);
#line 29 "../../../src/ui/tile-view/tile-view.vala"
	if (old_value != value) {
#line 29 "../../../src/ui/tile-view/tile-view.vala"
		self->priv->_icon_size = value;
#line 29 "../../../src/ui/tile-view/tile-view.vala"
		g_object_notify_by_pspec ((GObject *) self, ui_widgets_tile_view_properties[UI_WIDGETS_TILE_VIEW_ICON_SIZE_PROPERTY]);
#line 1202 "tile-view.c"
	}
}

static void
ui_widgets_tile_view_class_init (UIWidgetsTileViewClass * klass,
                                 gpointer klass_data)
{
#line 24 "../../../src/ui/tile-view/tile-view.vala"
	ui_widgets_tile_view_parent_class = g_type_class_peek_parent (klass);
#line 24 "../../../src/ui/tile-view/tile-view.vala"
	g_type_class_adjust_private_offset (klass, &UIWidgetsTileView_private_offset);
#line 24 "../../../src/ui/tile-view/tile-view.vala"
	((UIWidgetsTileViewClass *) klass)->append_tile = (void (*) (UIWidgetsTileView*, UIWidgetsAbstractTileObject*)) ui_widgets_tile_view_real_append_tile;
#line 24 "../../../src/ui/tile-view/tile-view.vala"
	((UIWidgetsTileViewClass *) klass)->remove_tile = (void (*) (UIWidgetsTileView*, UIWidgetsAbstractTileObject*)) ui_widgets_tile_view_real_remove_tile;
#line 24 "../../../src/ui/tile-view/tile-view.vala"
	((UIWidgetsTileViewClass *) klass)->clear_selection = (void (*) (UIWidgetsTileView*)) ui_widgets_tile_view_real_clear_selection;
#line 24 "../../../src/ui/tile-view/tile-view.vala"
	((UIWidgetsTileViewClass *) klass)->get_current_tile = (UIWidgetsAbstractTileObject* (*) (UIWidgetsTileView*)) ui_widgets_tile_view_real_get_current_tile;
#line 24 "../../../src/ui/tile-view/tile-view.vala"
	((GtkWidgetClass *) klass)->style_updated = (void (*) (GtkWidget*)) ui_widgets_tile_view_real_style_updated;
#line 24 "../../../src/ui/tile-view/tile-view.vala"
	((UIWidgetsTileViewClass *) klass)->on_tile_active_changed = (void (*) (UIWidgetsTileView*, UIWidgetsTile*)) ui_widgets_tile_view_real_on_tile_active_changed;
#line 24 "../../../src/ui/tile-view/tile-view.vala"
	((UIWidgetsTileViewClass *) klass)->on_tile_size_allocated = (void (*) (UIWidgetsTileView*, GtkWidget*, GtkAllocation*)) ui_widgets_tile_view_real_on_tile_size_allocated;
#line 24 "../../../src/ui/tile-view/tile-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_ui_widgets_tile_view_get_property;
#line 24 "../../../src/ui/tile-view/tile-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_ui_widgets_tile_view_set_property;
#line 24 "../../../src/ui/tile-view/tile-view.vala"
	G_OBJECT_CLASS (klass)->finalize = ui_widgets_tile_view_finalize;
#line 24 "../../../src/ui/tile-view/tile-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), UI_WIDGETS_TILE_VIEW_ICON_SIZE_PROPERTY, ui_widgets_tile_view_properties[UI_WIDGETS_TILE_VIEW_ICON_SIZE_PROPERTY] = g_param_spec_int ("icon-size", "icon-size", "icon-size", G_MININT, G_MAXINT, 48, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 1236 "tile-view.c"
}

static void
ui_widgets_tile_view_instance_init (UIWidgetsTileView * self,
                                    gpointer klass)
{
	GtkBox* _tmp0_;
#line 24 "../../../src/ui/tile-view/tile-view.vala"
	self->priv = ui_widgets_tile_view_get_instance_private (self);
#line 26 "../../../src/ui/tile-view/tile-view.vala"
	self->priv->tiles = NULL;
#line 27 "../../../src/ui/tile-view/tile-view.vala"
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
#line 27 "../../../src/ui/tile-view/tile-view.vala"
	g_object_ref_sink (_tmp0_);
#line 27 "../../../src/ui/tile-view/tile-view.vala"
	self->priv->box = _tmp0_;
#line 29 "../../../src/ui/tile-view/tile-view.vala"
	self->priv->_icon_size = 48;
#line 31 "../../../src/ui/tile-view/tile-view.vala"
	self->selected_index = -1;
#line 133 "../../../src/ui/tile-view/tile-view.vala"
	self->priv->changing_style = FALSE;
#line 1260 "tile-view.c"
}

static void
ui_widgets_tile_view_finalize (GObject * obj)
{
	UIWidgetsTileView * self;
#line 24 "../../../src/ui/tile-view/tile-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UI_WIDGETS_TYPE_TILE_VIEW, UIWidgetsTileView);
#line 26 "../../../src/ui/tile-view/tile-view.vala"
	(self->priv->tiles == NULL) ? NULL : (self->priv->tiles = (_g_list_free__g_object_unref0_ (self->priv->tiles), NULL));
#line 27 "../../../src/ui/tile-view/tile-view.vala"
	_g_object_unref0 (self->priv->box);
#line 24 "../../../src/ui/tile-view/tile-view.vala"
	G_OBJECT_CLASS (ui_widgets_tile_view_parent_class)->finalize (obj);
#line 1275 "tile-view.c"
}

static GType
ui_widgets_tile_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UIWidgetsTileViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ui_widgets_tile_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UIWidgetsTileView), 0, (GInstanceInitFunc) ui_widgets_tile_view_instance_init, NULL };
	GType ui_widgets_tile_view_type_id;
	ui_widgets_tile_view_type_id = g_type_register_static (gtk_event_box_get_type (), "UIWidgetsTileView", &g_define_type_info, 0);
	UIWidgetsTileView_private_offset = g_type_add_instance_private (ui_widgets_tile_view_type_id, sizeof (UIWidgetsTileViewPrivate));
	return ui_widgets_tile_view_type_id;
}

GType
ui_widgets_tile_view_get_type (void)
{
	static volatile gsize ui_widgets_tile_view_type_id__volatile = 0;
	if (g_once_init_enter (&ui_widgets_tile_view_type_id__volatile)) {
		GType ui_widgets_tile_view_type_id;
		ui_widgets_tile_view_type_id = ui_widgets_tile_view_get_type_once ();
		g_once_init_leave (&ui_widgets_tile_view_type_id__volatile, ui_widgets_tile_view_type_id);
	}
	return ui_widgets_tile_view_type_id__volatile;
}

static void
_vala_ui_widgets_tile_view_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	UIWidgetsTileView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, UI_WIDGETS_TYPE_TILE_VIEW, UIWidgetsTileView);
#line 24 "../../../src/ui/tile-view/tile-view.vala"
	switch (property_id) {
#line 24 "../../../src/ui/tile-view/tile-view.vala"
		case UI_WIDGETS_TILE_VIEW_ICON_SIZE_PROPERTY:
#line 24 "../../../src/ui/tile-view/tile-view.vala"
		g_value_set_int (value, ui_widgets_tile_view_get_icon_size (self));
#line 24 "../../../src/ui/tile-view/tile-view.vala"
		break;
#line 1316 "tile-view.c"
		default:
#line 24 "../../../src/ui/tile-view/tile-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../../../src/ui/tile-view/tile-view.vala"
		break;
#line 1322 "tile-view.c"
	}
}

static void
_vala_ui_widgets_tile_view_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	UIWidgetsTileView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, UI_WIDGETS_TYPE_TILE_VIEW, UIWidgetsTileView);
#line 24 "../../../src/ui/tile-view/tile-view.vala"
	switch (property_id) {
#line 24 "../../../src/ui/tile-view/tile-view.vala"
		case UI_WIDGETS_TILE_VIEW_ICON_SIZE_PROPERTY:
#line 24 "../../../src/ui/tile-view/tile-view.vala"
		ui_widgets_tile_view_set_icon_size (self, g_value_get_int (value));
#line 24 "../../../src/ui/tile-view/tile-view.vala"
		break;
#line 1342 "tile-view.c"
		default:
#line 24 "../../../src/ui/tile-view/tile-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../../../src/ui/tile-view/tile-view.vala"
		break;
#line 1348 "tile-view.c"
	}
}

