/* common-actions.c generated by valac 0.48.17, the Vala compiler
 * generated from common-actions.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gio/gdesktopappinfo.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>
#include <gtk/gtk.h>

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_MATCH, SynapseMatchClass))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_IS_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchClass))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchClass SynapseMatchClass;
typedef struct _SynapseMatchPrivate SynapseMatchPrivate;
typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;

#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())

#define SYNAPSE_TYPE_ACTION (synapse_action_get_type ())
#define SYNAPSE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTION, SynapseAction))
#define SYNAPSE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_ACTION, SynapseActionClass))
#define SYNAPSE_IS_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTION))
#define SYNAPSE_IS_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_ACTION))
#define SYNAPSE_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_ACTION, SynapseActionClass))

typedef struct _SynapseAction SynapseAction;
typedef struct _SynapseActionClass SynapseActionClass;
typedef struct _SynapseActionPrivate SynapseActionPrivate;
enum  {
	SYNAPSE_ACTION_0_PROPERTY,
	SYNAPSE_ACTION_DEFAULT_RELEVANCY_PROPERTY,
	SYNAPSE_ACTION_NOTIFY_MATCH_PROPERTY,
	SYNAPSE_ACTION_NUM_PROPERTIES
};
static GParamSpec* synapse_action_properties[SYNAPSE_ACTION_NUM_PROPERTIES];

#define SYNAPSE_TYPE_ACTIVATABLE (synapse_activatable_get_type ())
#define SYNAPSE_ACTIVATABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatable))
#define SYNAPSE_IS_ACTIVATABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTIVATABLE))
#define SYNAPSE_ACTIVATABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatableIface))

typedef struct _SynapseActivatable SynapseActivatable;
typedef struct _SynapseActivatableIface SynapseActivatableIface;

#define SYNAPSE_TYPE_ACTION_PROVIDER (synapse_action_provider_get_type ())
#define SYNAPSE_ACTION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTION_PROVIDER, SynapseActionProvider))
#define SYNAPSE_IS_ACTION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTION_PROVIDER))
#define SYNAPSE_ACTION_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_ACTION_PROVIDER, SynapseActionProviderIface))

typedef struct _SynapseActionProvider SynapseActionProvider;
typedef struct _SynapseActionProviderIface SynapseActionProviderIface;

#define SYNAPSE_TYPE_QUERY (synapse_query_get_type ())
typedef struct _SynapseQuery SynapseQuery;

#define SYNAPSE_TYPE_RESULT_SET (synapse_result_set_get_type ())
#define SYNAPSE_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSet))
#define SYNAPSE_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))
#define SYNAPSE_IS_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_IS_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_RESULT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))

typedef struct _SynapseResultSet SynapseResultSet;
typedef struct _SynapseResultSetClass SynapseResultSetClass;

#define SYNAPSE_TYPE_COMMON_ACTIONS (synapse_common_actions_get_type ())
#define SYNAPSE_COMMON_ACTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions))
#define SYNAPSE_COMMON_ACTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActionsClass))
#define SYNAPSE_IS_COMMON_ACTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_COMMON_ACTIONS))
#define SYNAPSE_IS_COMMON_ACTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_COMMON_ACTIONS))
#define SYNAPSE_COMMON_ACTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActionsClass))

typedef struct _SynapseCommonActions SynapseCommonActions;
typedef struct _SynapseCommonActionsClass SynapseCommonActionsClass;
typedef struct _SynapseCommonActionsPrivate SynapseCommonActionsPrivate;
enum  {
	SYNAPSE_COMMON_ACTIONS_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_properties[SYNAPSE_COMMON_ACTIONS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	SYNAPSE_MATCHER_FLAGS_NO_REVERSED = 1 << 0,
	SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING = 1 << 1,
	SYNAPSE_MATCHER_FLAGS_NO_PARTIAL = 1 << 2,
	SYNAPSE_MATCHER_FLAGS_NO_FUZZY = 1 << 3
} SynapseMatcherFlags;

#define SYNAPSE_TYPE_MATCHER_FLAGS (synapse_matcher_flags_get_type ())

#define SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER (synapse_common_actions_runner_get_type ())
#define SYNAPSE_COMMON_ACTIONS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER, SynapseCommonActionsRunner))
#define SYNAPSE_COMMON_ACTIONS_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER, SynapseCommonActionsRunnerClass))
#define SYNAPSE_COMMON_ACTIONS_IS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_IS_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER, SynapseCommonActionsRunnerClass))

typedef struct _SynapseCommonActionsRunner SynapseCommonActionsRunner;
typedef struct _SynapseCommonActionsRunnerClass SynapseCommonActionsRunnerClass;
typedef struct _SynapseCommonActionsRunnerPrivate SynapseCommonActionsRunnerPrivate;
enum  {
	SYNAPSE_COMMON_ACTIONS_RUNNER_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_RUNNER_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_runner_properties[SYNAPSE_COMMON_ACTIONS_RUNNER_NUM_PROPERTIES];
typedef enum  {
	SYNAPSE_MATCH_SCORE_INCREMENT_MINOR = 2000,
	SYNAPSE_MATCH_SCORE_INCREMENT_SMALL = 5000,
	SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM = 10000,
	SYNAPSE_MATCH_SCORE_INCREMENT_LARGE = 20000,
	SYNAPSE_MATCH_SCORE_URI_PENALTY = 15000,
	SYNAPSE_MATCH_SCORE_POOR = 50000,
	SYNAPSE_MATCH_SCORE_BELOW_AVERAGE = 60000,
	SYNAPSE_MATCH_SCORE_AVERAGE = 70000,
	SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE = 75000,
	SYNAPSE_MATCH_SCORE_GOOD = 80000,
	SYNAPSE_MATCH_SCORE_VERY_GOOD = 85000,
	SYNAPSE_MATCH_SCORE_EXCELLENT = 90000,
	SYNAPSE_MATCH_SCORE_HIGHEST = 100000
} SynapseMatchScore;

#define SYNAPSE_TYPE_MATCH_SCORE (synapse_match_score_get_type ())

#define SYNAPSE_TYPE_APPLICATION_MATCH (synapse_application_match_get_type ())
#define SYNAPSE_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch))
#define SYNAPSE_APPLICATION_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatchClass))
#define SYNAPSE_IS_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_APPLICATION_MATCH))
#define SYNAPSE_IS_APPLICATION_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_APPLICATION_MATCH))
#define SYNAPSE_APPLICATION_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatchClass))

typedef struct _SynapseApplicationMatch SynapseApplicationMatch;
typedef struct _SynapseApplicationMatchClass SynapseApplicationMatchClass;

#define SYNAPSE_TYPE_RELEVANCY_SERVICE (synapse_relevancy_service_get_type ())
#define SYNAPSE_RELEVANCY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyService))
#define SYNAPSE_RELEVANCY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyServiceClass))
#define SYNAPSE_IS_RELEVANCY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE))
#define SYNAPSE_IS_RELEVANCY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RELEVANCY_SERVICE))
#define SYNAPSE_RELEVANCY_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyServiceClass))

typedef struct _SynapseRelevancyService SynapseRelevancyService;
typedef struct _SynapseRelevancyServiceClass SynapseRelevancyServiceClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SYNAPSE_TYPE_ACTION_MATCH (synapse_action_match_get_type ())
#define SYNAPSE_ACTION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTION_MATCH, SynapseActionMatch))
#define SYNAPSE_ACTION_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_ACTION_MATCH, SynapseActionMatchClass))
#define SYNAPSE_IS_ACTION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTION_MATCH))
#define SYNAPSE_IS_ACTION_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_ACTION_MATCH))
#define SYNAPSE_ACTION_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_ACTION_MATCH, SynapseActionMatchClass))

typedef struct _SynapseActionMatch SynapseActionMatch;
typedef struct _SynapseActionMatchClass SynapseActionMatchClass;

#define SYNAPSE_TYPE_URI_MATCH (synapse_uri_match_get_type ())
#define SYNAPSE_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch))
#define SYNAPSE_URI_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchClass))
#define SYNAPSE_IS_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_IS_URI_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_URI_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchClass))

typedef struct _SynapseUriMatch SynapseUriMatch;
typedef struct _SynapseUriMatchClass SynapseUriMatchClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER (synapse_common_actions_terminal_runner_get_type ())
#define SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER, SynapseCommonActionsTerminalRunner))
#define SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER, SynapseCommonActionsTerminalRunnerClass))
#define SYNAPSE_COMMON_ACTIONS_IS_TERMINAL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_IS_TERMINAL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER))
#define SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER, SynapseCommonActionsTerminalRunnerClass))

typedef struct _SynapseCommonActionsTerminalRunner SynapseCommonActionsTerminalRunner;
typedef struct _SynapseCommonActionsTerminalRunnerClass SynapseCommonActionsTerminalRunnerClass;
typedef struct _SynapseCommonActionsTerminalRunnerPrivate SynapseCommonActionsTerminalRunnerPrivate;
enum  {
	SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_terminal_runner_properties[SYNAPSE_COMMON_ACTIONS_TERMINAL_RUNNER_NUM_PROPERTIES];

#define SYNAPSE_COMMON_ACTIONS_TYPE_OPENER (synapse_common_actions_opener_get_type ())
#define SYNAPSE_COMMON_ACTIONS_OPENER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpener))
#define SYNAPSE_COMMON_ACTIONS_OPENER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpenerClass))
#define SYNAPSE_COMMON_ACTIONS_IS_OPENER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER))
#define SYNAPSE_COMMON_ACTIONS_IS_OPENER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER))
#define SYNAPSE_COMMON_ACTIONS_OPENER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpenerClass))

typedef struct _SynapseCommonActionsOpener SynapseCommonActionsOpener;
typedef struct _SynapseCommonActionsOpenerClass SynapseCommonActionsOpenerClass;
typedef struct _SynapseCommonActionsOpenerPrivate SynapseCommonActionsOpenerPrivate;
enum  {
	SYNAPSE_COMMON_ACTIONS_OPENER_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_OPENER_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_opener_properties[SYNAPSE_COMMON_ACTIONS_OPENER_NUM_PROPERTIES];
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define SYNAPSE_TYPE_UNKNOWN_MATCH (synapse_unknown_match_get_type ())
#define SYNAPSE_UNKNOWN_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_UNKNOWN_MATCH, SynapseUnknownMatch))
#define SYNAPSE_UNKNOWN_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_UNKNOWN_MATCH, SynapseUnknownMatchClass))
#define SYNAPSE_IS_UNKNOWN_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_UNKNOWN_MATCH))
#define SYNAPSE_IS_UNKNOWN_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_UNKNOWN_MATCH))
#define SYNAPSE_UNKNOWN_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_UNKNOWN_MATCH, SynapseUnknownMatchClass))

typedef struct _SynapseUnknownMatch SynapseUnknownMatch;
typedef struct _SynapseUnknownMatchClass SynapseUnknownMatchClass;

#define SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER (synapse_common_actions_open_folder_get_type ())
#define SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER, SynapseCommonActionsOpenFolder))
#define SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER, SynapseCommonActionsOpenFolderClass))
#define SYNAPSE_COMMON_ACTIONS_IS_OPEN_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER))
#define SYNAPSE_COMMON_ACTIONS_IS_OPEN_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER))
#define SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER, SynapseCommonActionsOpenFolderClass))

typedef struct _SynapseCommonActionsOpenFolder SynapseCommonActionsOpenFolder;
typedef struct _SynapseCommonActionsOpenFolderClass SynapseCommonActionsOpenFolderClass;
typedef struct _SynapseCommonActionsOpenFolderPrivate SynapseCommonActionsOpenFolderPrivate;
enum  {
	SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_open_folder_properties[SYNAPSE_COMMON_ACTIONS_OPEN_FOLDER_NUM_PROPERTIES];

#define SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY (synapse_common_actions_clipboard_copy_get_type ())
#define SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY, SynapseCommonActionsClipboardCopy))
#define SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY, SynapseCommonActionsClipboardCopyClass))
#define SYNAPSE_COMMON_ACTIONS_IS_CLIPBOARD_COPY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY))
#define SYNAPSE_COMMON_ACTIONS_IS_CLIPBOARD_COPY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY))
#define SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY, SynapseCommonActionsClipboardCopyClass))

typedef struct _SynapseCommonActionsClipboardCopy SynapseCommonActionsClipboardCopy;
typedef struct _SynapseCommonActionsClipboardCopyClass SynapseCommonActionsClipboardCopyClass;
typedef struct _SynapseCommonActionsClipboardCopyPrivate SynapseCommonActionsClipboardCopyPrivate;
enum  {
	SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY_0_PROPERTY,
	SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY_NUM_PROPERTIES
};
static GParamSpec* synapse_common_actions_clipboard_copy_properties[SYNAPSE_COMMON_ACTIONS_CLIPBOARD_COPY_NUM_PROPERTIES];

#define SYNAPSE_TYPE_TEXT_MATCH (synapse_text_match_get_type ())
#define SYNAPSE_TEXT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatch))
#define SYNAPSE_TEXT_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatchClass))
#define SYNAPSE_IS_TEXT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_TEXT_MATCH))
#define SYNAPSE_IS_TEXT_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_TEXT_MATCH))
#define SYNAPSE_TEXT_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatchClass))

typedef struct _SynapseTextMatch SynapseTextMatch;
typedef struct _SynapseTextMatchClass SynapseTextMatchClass;
typedef enum  {
	SYNAPSE_TEXT_ORIGIN_UNKNOWN,
	SYNAPSE_TEXT_ORIGIN_CLIPBOARD
} SynapseTextOrigin;

#define SYNAPSE_TYPE_TEXT_ORIGIN (synapse_text_origin_get_type ())

struct _SynapseMatch {
	GObject parent_instance;
	SynapseMatchPrivate * priv;
};

struct _SynapseMatchClass {
	GObjectClass parent_class;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	void (*execute_with_target) (SynapseMatch* self, SynapseMatch* source, SynapseMatch* target);
	gboolean (*needs_target) (SynapseMatch* self);
	SynapseQueryFlags (*target_flags) (SynapseMatch* self);
};

struct _SynapseAction {
	SynapseMatch parent_instance;
	SynapseActionPrivate * priv;
};

struct _SynapseActionClass {
	SynapseMatchClass parent_class;
	gboolean (*valid_for_match) (SynapseAction* self, SynapseMatch* match);
	gint (*get_relevancy_for_match) (SynapseAction* self, SynapseMatch* match);
	void (*do_execute) (SynapseAction* self, SynapseMatch* source, SynapseMatch* target);
};

struct _SynapseActionPrivate {
	gint _default_relevancy;
	gboolean _notify_match;
};

struct _SynapseActivatableIface {
	GTypeInterface parent_iface;
	void (*activate) (SynapseActivatable* self);
	void (*deactivate) (SynapseActivatable* self);
	gboolean (*get_enabled) (SynapseActivatable* self);
	void (*set_enabled) (SynapseActivatable* self, gboolean value);
};

struct _SynapseQuery {
	gchar* query_string;
	gchar* query_string_folded;
	GCancellable* cancellable;
	SynapseQueryFlags query_type;
	guint max_results;
	guint query_id;
};

struct _SynapseActionProviderIface {
	GTypeInterface parent_iface;
	SynapseResultSet* (*find_for_match) (SynapseActionProvider* self, SynapseQuery* query, SynapseMatch* match);
	gboolean (*handles_unknown) (SynapseActionProvider* self);
};

struct _SynapseCommonActions {
	GObject parent_instance;
	SynapseCommonActionsPrivate * priv;
};

struct _SynapseCommonActionsClass {
	GObjectClass parent_class;
};

struct _SynapseCommonActionsPrivate {
	gboolean _enabled;
	GeeList* actions;
};

struct _SynapseCommonActionsRunner {
	SynapseAction parent_instance;
	SynapseCommonActionsRunnerPrivate * priv;
};

struct _SynapseCommonActionsRunnerClass {
	SynapseActionClass parent_class;
};

struct _SynapseCommonActionsTerminalRunner {
	SynapseAction parent_instance;
	SynapseCommonActionsTerminalRunnerPrivate * priv;
};

struct _SynapseCommonActionsTerminalRunnerClass {
	SynapseActionClass parent_class;
};

struct _SynapseCommonActionsOpener {
	SynapseAction parent_instance;
	SynapseCommonActionsOpenerPrivate * priv;
};

struct _SynapseCommonActionsOpenerClass {
	SynapseActionClass parent_class;
};

struct _SynapseCommonActionsOpenerPrivate {
	GRegex* web_uri;
	GRegex* file_path;
};

struct _SynapseCommonActionsOpenFolder {
	SynapseAction parent_instance;
	SynapseCommonActionsOpenFolderPrivate * priv;
};

struct _SynapseCommonActionsOpenFolderClass {
	SynapseActionClass parent_class;
};

struct _SynapseCommonActionsClipboardCopy {
	SynapseAction parent_instance;
	SynapseCommonActionsClipboardCopyPrivate * priv;
};

struct _SynapseCommonActionsClipboardCopyClass {
	SynapseActionClass parent_class;
};

static gint SynapseAction_private_offset;
static gpointer synapse_action_parent_class = NULL;
static gint SynapseCommonActions_private_offset;
static gpointer synapse_common_actions_parent_class = NULL;
static gpointer synapse_common_actions_runner_parent_class = NULL;
static gpointer synapse_common_actions_terminal_runner_parent_class = NULL;
static gint SynapseCommonActionsOpener_private_offset;
static gpointer synapse_common_actions_opener_parent_class = NULL;
static gpointer synapse_common_actions_open_folder_parent_class = NULL;
static gpointer synapse_common_actions_clipboard_copy_parent_class = NULL;
static SynapseActivatableIface * synapse_common_actions_synapse_activatable_parent_iface = NULL;
static SynapseActionProviderIface * synapse_common_actions_synapse_action_provider_parent_iface = NULL;

GType synapse_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseMatch, g_object_unref)
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
GType synapse_action_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseAction, g_object_unref)
gboolean synapse_action_valid_for_match (SynapseAction* self,
                                         SynapseMatch* match);
gint synapse_action_get_relevancy_for_match (SynapseAction* self,
                                             SynapseMatch* match);
void synapse_action_do_execute (SynapseAction* self,
                                SynapseMatch* source,
                                SynapseMatch* target);
void synapse_match_execute_with_target (SynapseMatch* self,
                                        SynapseMatch* source,
                                        SynapseMatch* target);
static gboolean synapse_action_real_valid_for_match (SynapseAction* self,
                                              SynapseMatch* match);
static gint synapse_action_real_get_relevancy_for_match (SynapseAction* self,
                                                  SynapseMatch* match);
gint synapse_action_get_default_relevancy (SynapseAction* self);
static void synapse_action_real_do_execute (SynapseAction* self,
                                     SynapseMatch* source,
                                     SynapseMatch* target);
static void synapse_action_real_execute_with_target (SynapseMatch* base,
                                              SynapseMatch* source,
                                              SynapseMatch* target);
gboolean synapse_action_get_notify_match (SynapseAction* self);
SynapseAction* synapse_action_construct (GType object_type);
SynapseMatch* synapse_match_construct (GType object_type);
void synapse_action_set_default_relevancy (SynapseAction* self,
                                           gint value);
void synapse_action_set_notify_match (SynapseAction* self,
                                      gboolean value);
static void synapse_action_finalize (GObject * obj);
static GType synapse_action_get_type_once (void);
static void _vala_synapse_action_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_synapse_action_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
GType synapse_activatable_get_type (void) G_GNUC_CONST;
GType synapse_query_get_type (void) G_GNUC_CONST;
SynapseQuery* synapse_query_dup (const SynapseQuery* self);
void synapse_query_free (SynapseQuery* self);
void synapse_query_copy (const SynapseQuery* self,
                         SynapseQuery* dest);
void synapse_query_destroy (SynapseQuery* self);
GType synapse_result_set_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseResultSet, g_object_unref)
GType synapse_action_provider_get_type (void) G_GNUC_CONST;
GType synapse_common_actions_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseCommonActions, g_object_unref)
static void synapse_common_actions_real_activate (SynapseActivatable* base);
static void synapse_common_actions_real_deactivate (SynapseActivatable* base);
static SynapseResultSet* synapse_common_actions_real_find_for_match (SynapseActionProvider* base,
                                                              SynapseQuery* query,
                                                              SynapseMatch* match);
SynapseResultSet* synapse_result_set_new (void);
SynapseResultSet* synapse_result_set_construct (GType object_type);
void synapse_result_set_add (SynapseResultSet* self,
                             SynapseMatch* match,
                             gint relevancy);
GType synapse_matcher_flags_get_type (void) G_GNUC_CONST;
GeeList* synapse_query_get_matchers_for_query (const gchar* query,
                                               SynapseMatcherFlags match_flags,
                                               GRegexCompileFlags flags);
const gchar* synapse_match_get_title (SynapseMatch* self);
SynapseCommonActions* synapse_common_actions_new (void);
SynapseCommonActions* synapse_common_actions_construct (GType object_type);
static GType synapse_common_actions_runner_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseCommonActionsRunner, g_object_unref)
static SynapseCommonActionsRunner* synapse_common_actions_runner_new (void);
static SynapseCommonActionsRunner* synapse_common_actions_runner_construct (GType object_type);
GType synapse_match_score_get_type (void) G_GNUC_CONST;
static void synapse_common_actions_runner_real_do_execute (SynapseAction* base,
                                                    SynapseMatch* match,
                                                    SynapseMatch* target);
GType synapse_application_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseApplicationMatch, g_object_unref)
GAppInfo* synapse_application_match_get_app_info (SynapseApplicationMatch* self);
const gchar* synapse_application_match_get_filename (SynapseApplicationMatch* self);
GType synapse_relevancy_service_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseRelevancyService, g_object_unref)
SynapseRelevancyService* synapse_relevancy_service_get_default (void);
void synapse_relevancy_service_application_launched (SynapseRelevancyService* self,
                                                     GAppInfo* app_info);
GType synapse_action_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseActionMatch, g_object_unref)
void synapse_action_match_do_action (SynapseActionMatch* self);
GType synapse_uri_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseUriMatch, g_object_unref)
const gchar* synapse_uri_match_get_uri (SynapseUriMatch* self);
static gboolean synapse_common_actions_runner_real_valid_for_match (SynapseAction* base,
                                                             SynapseMatch* match);
gboolean synapse_application_match_get_needs_terminal (SynapseApplicationMatch* self);
static GType synapse_common_actions_runner_get_type_once (void);
static GType synapse_common_actions_terminal_runner_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseCommonActionsTerminalRunner, g_object_unref)
static SynapseCommonActionsTerminalRunner* synapse_common_actions_terminal_runner_new (void);
static SynapseCommonActionsTerminalRunner* synapse_common_actions_terminal_runner_construct (GType object_type);
static void synapse_common_actions_terminal_runner_real_do_execute (SynapseAction* base,
                                                             SynapseMatch* match,
                                                             SynapseMatch* target);
void synapse_utils_open_command_line (const gchar* command,
                                      const gchar* app_name,
                                      gboolean needs_terminal);
static gboolean synapse_common_actions_terminal_runner_real_valid_for_match (SynapseAction* base,
                                                                      SynapseMatch* match);
static GType synapse_common_actions_terminal_runner_get_type_once (void);
static GType synapse_common_actions_opener_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseCommonActionsOpener, g_object_unref)
static SynapseCommonActionsOpener* synapse_common_actions_opener_new (void);
static SynapseCommonActionsOpener* synapse_common_actions_opener_construct (GType object_type);
static void synapse_common_actions_opener_real_do_execute (SynapseAction* base,
                                                    SynapseMatch* match,
                                                    SynapseMatch* target);
void synapse_utils_open_uri (const gchar* uri);
static gboolean synapse_common_actions_opener_real_valid_for_match (SynapseAction* base,
                                                             SynapseMatch* match);
GType synapse_unknown_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseUnknownMatch, g_object_unref)
static GObject * synapse_common_actions_opener_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static void synapse_common_actions_opener_finalize (GObject * obj);
static GType synapse_common_actions_opener_get_type_once (void);
static GType synapse_common_actions_open_folder_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseCommonActionsOpenFolder, g_object_unref)
static SynapseCommonActionsOpenFolder* synapse_common_actions_open_folder_new (void);
static SynapseCommonActionsOpenFolder* synapse_common_actions_open_folder_construct (GType object_type);
static void synapse_common_actions_open_folder_real_do_execute (SynapseAction* base,
                                                         SynapseMatch* match,
                                                         SynapseMatch* target);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gboolean synapse_common_actions_open_folder_real_valid_for_match (SynapseAction* base,
                                                                  SynapseMatch* match);
static GType synapse_common_actions_open_folder_get_type_once (void);
static GType synapse_common_actions_clipboard_copy_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseCommonActionsClipboardCopy, g_object_unref)
static SynapseCommonActionsClipboardCopy* synapse_common_actions_clipboard_copy_new (void);
static SynapseCommonActionsClipboardCopy* synapse_common_actions_clipboard_copy_construct (GType object_type);
static void synapse_common_actions_clipboard_copy_real_do_execute (SynapseAction* base,
                                                            SynapseMatch* match,
                                                            SynapseMatch* target);
GType synapse_text_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseTextMatch, g_object_unref)
gchar* synapse_text_match_get_text (SynapseTextMatch* self);
static gboolean synapse_common_actions_clipboard_copy_real_valid_for_match (SynapseAction* base,
                                                                     SynapseMatch* match);
static gint synapse_common_actions_clipboard_copy_real_get_relevancy_for_match (SynapseAction* base,
                                                                         SynapseMatch* match);
GType synapse_text_origin_get_type (void) G_GNUC_CONST;
SynapseTextOrigin synapse_text_match_get_text_origin (SynapseTextMatch* self);
static GType synapse_common_actions_clipboard_copy_get_type_once (void);
static GObject * synapse_common_actions_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
void synapse_activatable_activate (SynapseActivatable* self);
void synapse_activatable_deactivate (SynapseActivatable* self);
gboolean synapse_activatable_get_enabled (SynapseActivatable* self);
void synapse_activatable_set_enabled (SynapseActivatable* self,
                                      gboolean value);
SynapseResultSet* synapse_action_provider_find_for_match (SynapseActionProvider* self,
                                                          SynapseQuery* query,
                                                          SynapseMatch* match);
static void synapse_common_actions_finalize (GObject * obj);
static GType synapse_common_actions_get_type_once (void);
static void _vala_synapse_common_actions_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_synapse_common_actions_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
synapse_action_get_instance_private (SynapseAction* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseAction_private_offset);
}

static gboolean
synapse_action_real_valid_for_match (SynapseAction* self,
                                     SynapseMatch* match)
{
	gboolean _tmp0_ = FALSE;
#line 28 "../../../src/core/common-actions.vala"
	g_critical ("Type `%s' does not implement abstract method `synapse_action_valid_for_match'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 28 "../../../src/core/common-actions.vala"
	return _tmp0_;
#line 631 "common-actions.c"
}

gboolean
synapse_action_valid_for_match (SynapseAction* self,
                                SynapseMatch* match)
{
#line 28 "../../../src/core/common-actions.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 28 "../../../src/core/common-actions.vala"
	return SYNAPSE_ACTION_GET_CLASS (self)->valid_for_match (self, match);
#line 642 "common-actions.c"
}

static gint
synapse_action_real_get_relevancy_for_match (SynapseAction* self,
                                             SynapseMatch* match)
{
	gint _tmp0_;
	gint result = 0;
#line 30 "../../../src/core/common-actions.vala"
	g_return_val_if_fail (match != NULL, 0);
#line 32 "../../../src/core/common-actions.vala"
	_tmp0_ = self->priv->_default_relevancy;
#line 32 "../../../src/core/common-actions.vala"
	result = _tmp0_;
#line 32 "../../../src/core/common-actions.vala"
	return result;
#line 659 "common-actions.c"
}

gint
synapse_action_get_relevancy_for_match (SynapseAction* self,
                                        SynapseMatch* match)
{
#line 30 "../../../src/core/common-actions.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 30 "../../../src/core/common-actions.vala"
	return SYNAPSE_ACTION_GET_CLASS (self)->get_relevancy_for_match (self, match);
#line 670 "common-actions.c"
}

static void
synapse_action_real_do_execute (SynapseAction* self,
                                SynapseMatch* source,
                                SynapseMatch* target)
{
#line 35 "../../../src/core/common-actions.vala"
	g_critical ("Type `%s' does not implement abstract method `synapse_action_do_execute'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 35 "../../../src/core/common-actions.vala"
	return;
#line 682 "common-actions.c"
}

void
synapse_action_do_execute (SynapseAction* self,
                           SynapseMatch* source,
                           SynapseMatch* target)
{
#line 35 "../../../src/core/common-actions.vala"
	g_return_if_fail (self != NULL);
#line 35 "../../../src/core/common-actions.vala"
	SYNAPSE_ACTION_GET_CLASS (self)->do_execute (self, source, target);
#line 694 "common-actions.c"
}

static void
synapse_action_real_execute_with_target (SynapseMatch* base,
                                         SynapseMatch* source,
                                         SynapseMatch* target)
{
	SynapseAction * self;
	gboolean _tmp0_;
#line 37 "../../../src/core/common-actions.vala"
	self = (SynapseAction*) base;
#line 37 "../../../src/core/common-actions.vala"
	g_return_if_fail (source != NULL);
#line 39 "../../../src/core/common-actions.vala"
	synapse_action_do_execute (self, source, target);
#line 40 "../../../src/core/common-actions.vala"
	_tmp0_ = self->priv->_notify_match;
#line 40 "../../../src/core/common-actions.vala"
	if (_tmp0_) {
#line 40 "../../../src/core/common-actions.vala"
		g_signal_emit_by_name (source, "executed");
#line 716 "common-actions.c"
	}
}

SynapseAction*
synapse_action_construct (GType object_type)
{
	SynapseAction * self = NULL;
#line 23 "../../../src/core/common-actions.vala"
	self = (SynapseAction*) synapse_match_construct (object_type);
#line 23 "../../../src/core/common-actions.vala"
	return self;
#line 728 "common-actions.c"
}

gint
synapse_action_get_default_relevancy (SynapseAction* self)
{
	gint result;
#line 25 "../../../src/core/common-actions.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 25 "../../../src/core/common-actions.vala"
	result = self->priv->_default_relevancy;
#line 25 "../../../src/core/common-actions.vala"
	return result;
#line 741 "common-actions.c"
}

void
synapse_action_set_default_relevancy (SynapseAction* self,
                                      gint value)
{
	gint old_value;
#line 25 "../../../src/core/common-actions.vala"
	g_return_if_fail (self != NULL);
#line 25 "../../../src/core/common-actions.vala"
	old_value = synapse_action_get_default_relevancy (self);
#line 25 "../../../src/core/common-actions.vala"
	if (old_value != value) {
#line 25 "../../../src/core/common-actions.vala"
		self->priv->_default_relevancy = value;
#line 25 "../../../src/core/common-actions.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_action_properties[SYNAPSE_ACTION_DEFAULT_RELEVANCY_PROPERTY]);
#line 759 "common-actions.c"
	}
}

gboolean
synapse_action_get_notify_match (SynapseAction* self)
{
	gboolean result;
#line 26 "../../../src/core/common-actions.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 26 "../../../src/core/common-actions.vala"
	result = self->priv->_notify_match;
#line 26 "../../../src/core/common-actions.vala"
	return result;
#line 773 "common-actions.c"
}

void
synapse_action_set_notify_match (SynapseAction* self,
                                 gboolean value)
{
	gboolean old_value;
#line 26 "../../../src/core/common-actions.vala"
	g_return_if_fail (self != NULL);
#line 26 "../../../src/core/common-actions.vala"
	old_value = synapse_action_get_notify_match (self);
#line 26 "../../../src/core/common-actions.vala"
	if (old_value != value) {
#line 26 "../../../src/core/common-actions.vala"
		self->priv->_notify_match = value;
#line 26 "../../../src/core/common-actions.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_action_properties[SYNAPSE_ACTION_NOTIFY_MATCH_PROPERTY]);
#line 791 "common-actions.c"
	}
}

static void
synapse_action_class_init (SynapseActionClass * klass,
                           gpointer klass_data)
{
#line 23 "../../../src/core/common-actions.vala"
	synapse_action_parent_class = g_type_class_peek_parent (klass);
#line 23 "../../../src/core/common-actions.vala"
	g_type_class_adjust_private_offset (klass, &SynapseAction_private_offset);
#line 23 "../../../src/core/common-actions.vala"
	((SynapseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseAction*, SynapseMatch*)) synapse_action_real_valid_for_match;
#line 23 "../../../src/core/common-actions.vala"
	((SynapseActionClass *) klass)->get_relevancy_for_match = (gint (*) (SynapseAction*, SynapseMatch*)) synapse_action_real_get_relevancy_for_match;
#line 23 "../../../src/core/common-actions.vala"
	((SynapseActionClass *) klass)->do_execute = (void (*) (SynapseAction*, SynapseMatch*, SynapseMatch*)) synapse_action_real_do_execute;
#line 23 "../../../src/core/common-actions.vala"
	((SynapseMatchClass *) klass)->execute_with_target = (void (*) (SynapseMatch*, SynapseMatch*, SynapseMatch*)) synapse_action_real_execute_with_target;
#line 23 "../../../src/core/common-actions.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_action_get_property;
#line 23 "../../../src/core/common-actions.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_action_set_property;
#line 23 "../../../src/core/common-actions.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_action_finalize;
#line 23 "../../../src/core/common-actions.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_ACTION_DEFAULT_RELEVANCY_PROPERTY, synapse_action_properties[SYNAPSE_ACTION_DEFAULT_RELEVANCY_PROPERTY] = g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "../../../src/core/common-actions.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_ACTION_NOTIFY_MATCH_PROPERTY, synapse_action_properties[SYNAPSE_ACTION_NOTIFY_MATCH_PROPERTY] = g_param_spec_boolean ("notify-match", "notify-match", "notify-match", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 821 "common-actions.c"
}

static void
synapse_action_instance_init (SynapseAction * self,
                              gpointer klass)
{
#line 23 "../../../src/core/common-actions.vala"
	self->priv = synapse_action_get_instance_private (self);
#line 26 "../../../src/core/common-actions.vala"
	self->priv->_notify_match = TRUE;
#line 832 "common-actions.c"
}

static void
synapse_action_finalize (GObject * obj)
{
	SynapseAction * self;
#line 23 "../../../src/core/common-actions.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_ACTION, SynapseAction);
#line 23 "../../../src/core/common-actions.vala"
	G_OBJECT_CLASS (synapse_action_parent_class)->finalize (obj);
#line 843 "common-actions.c"
}

static GType
synapse_action_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseAction), 0, (GInstanceInitFunc) synapse_action_instance_init, NULL };
	GType synapse_action_type_id;
	synapse_action_type_id = g_type_register_static (SYNAPSE_TYPE_MATCH, "SynapseAction", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	SynapseAction_private_offset = g_type_add_instance_private (synapse_action_type_id, sizeof (SynapseActionPrivate));
	return synapse_action_type_id;
}

GType
synapse_action_get_type (void)
{
	static volatile gsize synapse_action_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_action_type_id__volatile)) {
		GType synapse_action_type_id;
		synapse_action_type_id = synapse_action_get_type_once ();
		g_once_init_leave (&synapse_action_type_id__volatile, synapse_action_type_id);
	}
	return synapse_action_type_id__volatile;
}

static void
_vala_synapse_action_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	SynapseAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_ACTION, SynapseAction);
#line 23 "../../../src/core/common-actions.vala"
	switch (property_id) {
#line 23 "../../../src/core/common-actions.vala"
		case SYNAPSE_ACTION_DEFAULT_RELEVANCY_PROPERTY:
#line 23 "../../../src/core/common-actions.vala"
		g_value_set_int (value, synapse_action_get_default_relevancy (self));
#line 23 "../../../src/core/common-actions.vala"
		break;
#line 23 "../../../src/core/common-actions.vala"
		case SYNAPSE_ACTION_NOTIFY_MATCH_PROPERTY:
#line 23 "../../../src/core/common-actions.vala"
		g_value_set_boolean (value, synapse_action_get_notify_match (self));
#line 23 "../../../src/core/common-actions.vala"
		break;
#line 890 "common-actions.c"
		default:
#line 23 "../../../src/core/common-actions.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "../../../src/core/common-actions.vala"
		break;
#line 896 "common-actions.c"
	}
}

static void
_vala_synapse_action_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	SynapseAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_ACTION, SynapseAction);
#line 23 "../../../src/core/common-actions.vala"
	switch (property_id) {
#line 23 "../../../src/core/common-actions.vala"
		case SYNAPSE_ACTION_DEFAULT_RELEVANCY_PROPERTY:
#line 23 "../../../src/core/common-actions.vala"
		synapse_action_set_default_relevancy (self, g_value_get_int (value));
#line 23 "../../../src/core/common-actions.vala"
		break;
#line 23 "../../../src/core/common-actions.vala"
		case SYNAPSE_ACTION_NOTIFY_MATCH_PROPERTY:
#line 23 "../../../src/core/common-actions.vala"
		synapse_action_set_notify_match (self, g_value_get_boolean (value));
#line 23 "../../../src/core/common-actions.vala"
		break;
#line 922 "common-actions.c"
		default:
#line 23 "../../../src/core/common-actions.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "../../../src/core/common-actions.vala"
		break;
#line 928 "common-actions.c"
	}
}

static inline gpointer
synapse_common_actions_get_instance_private (SynapseCommonActions* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCommonActions_private_offset);
}

static void
synapse_common_actions_real_activate (SynapseActivatable* base)
{
	SynapseCommonActions * self;
#line 48 "../../../src/core/common-actions.vala"
	self = (SynapseCommonActions*) base;
#line 944 "common-actions.c"
}

static void
synapse_common_actions_real_deactivate (SynapseActivatable* base)
{
	SynapseCommonActions * self;
#line 52 "../../../src/core/common-actions.vala"
	self = (SynapseCommonActions*) base;
#line 953 "common-actions.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 372 "../../../src/core/common-actions.vala"
	return self ? g_object_ref (self) : NULL;
#line 961 "common-actions.c"
}

static SynapseResultSet*
synapse_common_actions_real_find_for_match (SynapseActionProvider* base,
                                            SynapseQuery* query,
                                            SynapseMatch* match)
{
	SynapseCommonActions * self;
	gboolean query_empty = FALSE;
	SynapseQuery _tmp0_;
	const gchar* _tmp1_;
	SynapseResultSet* results = NULL;
	SynapseResultSet* _tmp2_;
	SynapseResultSet* result = NULL;
#line 365 "../../../src/core/common-actions.vala"
	self = (SynapseCommonActions*) base;
#line 365 "../../../src/core/common-actions.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 365 "../../../src/core/common-actions.vala"
	g_return_val_if_fail (match != NULL, NULL);
#line 367 "../../../src/core/common-actions.vala"
	_tmp0_ = *query;
#line 367 "../../../src/core/common-actions.vala"
	_tmp1_ = _tmp0_.query_string;
#line 367 "../../../src/core/common-actions.vala"
	query_empty = g_strcmp0 (_tmp1_, "") == 0;
#line 368 "../../../src/core/common-actions.vala"
	_tmp2_ = synapse_result_set_new ();
#line 368 "../../../src/core/common-actions.vala"
	results = _tmp2_;
#line 370 "../../../src/core/common-actions.vala"
	if (query_empty) {
#line 994 "common-actions.c"
		{
			GeeList* _action_list = NULL;
			GeeList* _tmp3_;
			GeeList* _tmp4_;
			gint _action_size = 0;
			GeeList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _action_index = 0;
#line 372 "../../../src/core/common-actions.vala"
			_tmp3_ = self->priv->actions;
#line 372 "../../../src/core/common-actions.vala"
			_tmp4_ = _g_object_ref0 (_tmp3_);
#line 372 "../../../src/core/common-actions.vala"
			_action_list = _tmp4_;
#line 372 "../../../src/core/common-actions.vala"
			_tmp5_ = _action_list;
#line 372 "../../../src/core/common-actions.vala"
			_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
#line 372 "../../../src/core/common-actions.vala"
			_tmp7_ = _tmp6_;
#line 372 "../../../src/core/common-actions.vala"
			_action_size = _tmp7_;
#line 372 "../../../src/core/common-actions.vala"
			_action_index = -1;
#line 372 "../../../src/core/common-actions.vala"
			while (TRUE) {
#line 1022 "common-actions.c"
				gint _tmp8_;
				gint _tmp9_;
				SynapseAction* action = NULL;
				GeeList* _tmp10_;
				gpointer _tmp11_;
				SynapseAction* _tmp12_;
#line 372 "../../../src/core/common-actions.vala"
				_action_index = _action_index + 1;
#line 372 "../../../src/core/common-actions.vala"
				_tmp8_ = _action_index;
#line 372 "../../../src/core/common-actions.vala"
				_tmp9_ = _action_size;
#line 372 "../../../src/core/common-actions.vala"
				if (!(_tmp8_ < _tmp9_)) {
#line 372 "../../../src/core/common-actions.vala"
					break;
#line 1039 "common-actions.c"
				}
#line 372 "../../../src/core/common-actions.vala"
				_tmp10_ = _action_list;
#line 372 "../../../src/core/common-actions.vala"
				_tmp11_ = gee_list_get (_tmp10_, _action_index);
#line 372 "../../../src/core/common-actions.vala"
				action = (SynapseAction*) _tmp11_;
#line 374 "../../../src/core/common-actions.vala"
				_tmp12_ = action;
#line 374 "../../../src/core/common-actions.vala"
				if (synapse_action_valid_for_match (_tmp12_, match)) {
#line 1051 "common-actions.c"
					SynapseResultSet* _tmp13_;
					SynapseAction* _tmp14_;
					SynapseAction* _tmp15_;
#line 376 "../../../src/core/common-actions.vala"
					_tmp13_ = results;
#line 376 "../../../src/core/common-actions.vala"
					_tmp14_ = action;
#line 376 "../../../src/core/common-actions.vala"
					_tmp15_ = action;
#line 376 "../../../src/core/common-actions.vala"
					synapse_result_set_add (_tmp13_, (SynapseMatch*) _tmp14_, synapse_action_get_relevancy_for_match (_tmp15_, match));
#line 1063 "common-actions.c"
				}
#line 372 "../../../src/core/common-actions.vala"
				_g_object_unref0 (action);
#line 1067 "common-actions.c"
			}
#line 372 "../../../src/core/common-actions.vala"
			_g_object_unref0 (_action_list);
#line 1071 "common-actions.c"
		}
	} else {
		GeeList* matchers = NULL;
		SynapseQuery _tmp16_;
		const gchar* _tmp17_;
		GeeList* _tmp18_;
#line 382 "../../../src/core/common-actions.vala"
		_tmp16_ = *query;
#line 382 "../../../src/core/common-actions.vala"
		_tmp17_ = _tmp16_.query_string;
#line 382 "../../../src/core/common-actions.vala"
		_tmp18_ = synapse_query_get_matchers_for_query (_tmp17_, 0, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
#line 382 "../../../src/core/common-actions.vala"
		matchers = _tmp18_;
#line 1086 "common-actions.c"
		{
			GeeList* _action_list = NULL;
			GeeList* _tmp19_;
			GeeList* _tmp20_;
			gint _action_size = 0;
			GeeList* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			gint _action_index = 0;
#line 384 "../../../src/core/common-actions.vala"
			_tmp19_ = self->priv->actions;
#line 384 "../../../src/core/common-actions.vala"
			_tmp20_ = _g_object_ref0 (_tmp19_);
#line 384 "../../../src/core/common-actions.vala"
			_action_list = _tmp20_;
#line 384 "../../../src/core/common-actions.vala"
			_tmp21_ = _action_list;
#line 384 "../../../src/core/common-actions.vala"
			_tmp22_ = gee_collection_get_size ((GeeCollection*) _tmp21_);
#line 384 "../../../src/core/common-actions.vala"
			_tmp23_ = _tmp22_;
#line 384 "../../../src/core/common-actions.vala"
			_action_size = _tmp23_;
#line 384 "../../../src/core/common-actions.vala"
			_action_index = -1;
#line 384 "../../../src/core/common-actions.vala"
			while (TRUE) {
#line 1114 "common-actions.c"
				gint _tmp24_;
				gint _tmp25_;
				SynapseAction* action = NULL;
				GeeList* _tmp26_;
				gpointer _tmp27_;
				SynapseAction* _tmp28_;
#line 384 "../../../src/core/common-actions.vala"
				_action_index = _action_index + 1;
#line 384 "../../../src/core/common-actions.vala"
				_tmp24_ = _action_index;
#line 384 "../../../src/core/common-actions.vala"
				_tmp25_ = _action_size;
#line 384 "../../../src/core/common-actions.vala"
				if (!(_tmp24_ < _tmp25_)) {
#line 384 "../../../src/core/common-actions.vala"
					break;
#line 1131 "common-actions.c"
				}
#line 384 "../../../src/core/common-actions.vala"
				_tmp26_ = _action_list;
#line 384 "../../../src/core/common-actions.vala"
				_tmp27_ = gee_list_get (_tmp26_, _action_index);
#line 384 "../../../src/core/common-actions.vala"
				action = (SynapseAction*) _tmp27_;
#line 386 "../../../src/core/common-actions.vala"
				_tmp28_ = action;
#line 386 "../../../src/core/common-actions.vala"
				if (!synapse_action_valid_for_match (_tmp28_, match)) {
#line 386 "../../../src/core/common-actions.vala"
					_g_object_unref0 (action);
#line 386 "../../../src/core/common-actions.vala"
					continue;
#line 1147 "common-actions.c"
				}
				{
					GeeList* _matcher_list = NULL;
					GeeList* _tmp29_;
					GeeList* _tmp30_;
					gint _matcher_size = 0;
					GeeList* _tmp31_;
					gint _tmp32_;
					gint _tmp33_;
					gint _matcher_index = 0;
#line 387 "../../../src/core/common-actions.vala"
					_tmp29_ = matchers;
#line 387 "../../../src/core/common-actions.vala"
					_tmp30_ = _g_object_ref0 (_tmp29_);
#line 387 "../../../src/core/common-actions.vala"
					_matcher_list = _tmp30_;
#line 387 "../../../src/core/common-actions.vala"
					_tmp31_ = _matcher_list;
#line 387 "../../../src/core/common-actions.vala"
					_tmp32_ = gee_collection_get_size ((GeeCollection*) _tmp31_);
#line 387 "../../../src/core/common-actions.vala"
					_tmp33_ = _tmp32_;
#line 387 "../../../src/core/common-actions.vala"
					_matcher_size = _tmp33_;
#line 387 "../../../src/core/common-actions.vala"
					_matcher_index = -1;
#line 387 "../../../src/core/common-actions.vala"
					while (TRUE) {
#line 1176 "common-actions.c"
						gint _tmp34_;
						gint _tmp35_;
						GeeMapEntry* matcher = NULL;
						GeeList* _tmp36_;
						gpointer _tmp37_;
						GeeMapEntry* _tmp38_;
						gconstpointer _tmp39_;
						gconstpointer _tmp40_;
						SynapseAction* _tmp41_;
						const gchar* _tmp42_;
						const gchar* _tmp43_;
#line 387 "../../../src/core/common-actions.vala"
						_matcher_index = _matcher_index + 1;
#line 387 "../../../src/core/common-actions.vala"
						_tmp34_ = _matcher_index;
#line 387 "../../../src/core/common-actions.vala"
						_tmp35_ = _matcher_size;
#line 387 "../../../src/core/common-actions.vala"
						if (!(_tmp34_ < _tmp35_)) {
#line 387 "../../../src/core/common-actions.vala"
							break;
#line 1198 "common-actions.c"
						}
#line 387 "../../../src/core/common-actions.vala"
						_tmp36_ = _matcher_list;
#line 387 "../../../src/core/common-actions.vala"
						_tmp37_ = gee_list_get (_tmp36_, _matcher_index);
#line 387 "../../../src/core/common-actions.vala"
						matcher = (GeeMapEntry*) _tmp37_;
#line 389 "../../../src/core/common-actions.vala"
						_tmp38_ = matcher;
#line 389 "../../../src/core/common-actions.vala"
						_tmp39_ = gee_map_entry_get_key (_tmp38_);
#line 389 "../../../src/core/common-actions.vala"
						_tmp40_ = _tmp39_;
#line 389 "../../../src/core/common-actions.vala"
						_tmp41_ = action;
#line 389 "../../../src/core/common-actions.vala"
						_tmp42_ = synapse_match_get_title ((SynapseMatch*) _tmp41_);
#line 389 "../../../src/core/common-actions.vala"
						_tmp43_ = _tmp42_;
#line 389 "../../../src/core/common-actions.vala"
						if (g_regex_match ((GRegex*) _tmp40_, _tmp43_, 0, NULL)) {
#line 1220 "common-actions.c"
							SynapseResultSet* _tmp44_;
							SynapseAction* _tmp45_;
							GeeMapEntry* _tmp46_;
							gconstpointer _tmp47_;
							gconstpointer _tmp48_;
#line 391 "../../../src/core/common-actions.vala"
							_tmp44_ = results;
#line 391 "../../../src/core/common-actions.vala"
							_tmp45_ = action;
#line 391 "../../../src/core/common-actions.vala"
							_tmp46_ = matcher;
#line 391 "../../../src/core/common-actions.vala"
							_tmp47_ = gee_map_entry_get_value (_tmp46_);
#line 391 "../../../src/core/common-actions.vala"
							_tmp48_ = _tmp47_;
#line 391 "../../../src/core/common-actions.vala"
							synapse_result_set_add (_tmp44_, (SynapseMatch*) _tmp45_, (gint) ((gintptr) _tmp48_));
#line 392 "../../../src/core/common-actions.vala"
							_g_object_unref0 (matcher);
#line 392 "../../../src/core/common-actions.vala"
							break;
#line 1242 "common-actions.c"
						}
#line 387 "../../../src/core/common-actions.vala"
						_g_object_unref0 (matcher);
#line 1246 "common-actions.c"
					}
#line 387 "../../../src/core/common-actions.vala"
					_g_object_unref0 (_matcher_list);
#line 1250 "common-actions.c"
				}
#line 384 "../../../src/core/common-actions.vala"
				_g_object_unref0 (action);
#line 1254 "common-actions.c"
			}
#line 384 "../../../src/core/common-actions.vala"
			_g_object_unref0 (_action_list);
#line 1258 "common-actions.c"
		}
#line 370 "../../../src/core/common-actions.vala"
		_g_object_unref0 (matchers);
#line 1262 "common-actions.c"
	}
#line 398 "../../../src/core/common-actions.vala"
	result = results;
#line 398 "../../../src/core/common-actions.vala"
	return result;
#line 1268 "common-actions.c"
}

SynapseCommonActions*
synapse_common_actions_construct (GType object_type)
{
	SynapseCommonActions * self = NULL;
#line 44 "../../../src/core/common-actions.vala"
	self = (SynapseCommonActions*) g_object_new (object_type, NULL);
#line 44 "../../../src/core/common-actions.vala"
	return self;
#line 1279 "common-actions.c"
}

SynapseCommonActions*
synapse_common_actions_new (void)
{
#line 44 "../../../src/core/common-actions.vala"
	return synapse_common_actions_construct (SYNAPSE_TYPE_COMMON_ACTIONS);
#line 1287 "common-actions.c"
}

static gboolean
synapse_common_actions_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseCommonActions* self;
#line 46 "../../../src/core/common-actions.vala"
	self = (SynapseCommonActions*) base;
#line 46 "../../../src/core/common-actions.vala"
	result = self->priv->_enabled;
#line 46 "../../../src/core/common-actions.vala"
	return result;
#line 1301 "common-actions.c"
}

static void
synapse_common_actions_real_set_enabled (SynapseActivatable* base,
                                         gboolean value)
{
	SynapseCommonActions* self;
	gboolean old_value;
#line 46 "../../../src/core/common-actions.vala"
	self = (SynapseCommonActions*) base;
#line 46 "../../../src/core/common-actions.vala"
	old_value = synapse_common_actions_real_get_enabled (base);
#line 46 "../../../src/core/common-actions.vala"
	if (old_value != value) {
#line 46 "../../../src/core/common-actions.vala"
		self->priv->_enabled = value;
#line 46 "../../../src/core/common-actions.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_common_actions_properties[SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY]);
#line 1320 "common-actions.c"
	}
}

static SynapseCommonActionsRunner*
synapse_common_actions_runner_construct (GType object_type)
{
	SynapseCommonActionsRunner * self = NULL;
#line 60 "../../../src/core/common-actions.vala"
	self = (SynapseCommonActionsRunner*) g_object_new (object_type, "title", _ ("Run"), "description", _ ("Run an application, action or script"), "icon-name", "system-run", "has-thumbnail", FALSE, "default-relevancy", SYNAPSE_MATCH_SCORE_EXCELLENT, NULL);
#line 58 "../../../src/core/common-actions.vala"
	return self;
#line 1332 "common-actions.c"
}

static SynapseCommonActionsRunner*
synapse_common_actions_runner_new (void)
{
#line 58 "../../../src/core/common-actions.vala"
	return synapse_common_actions_runner_construct (SYNAPSE_COMMON_ACTIONS_TYPE_RUNNER);
#line 1340 "common-actions.c"
}

static void
synapse_common_actions_runner_real_do_execute (SynapseAction* base,
                                               SynapseMatch* match,
                                               SynapseMatch* target)
{
	SynapseCommonActionsRunner * self;
	GError* _inner_error0_ = NULL;
#line 66 "../../../src/core/common-actions.vala"
	self = (SynapseCommonActionsRunner*) base;
#line 66 "../../../src/core/common-actions.vala"
	g_return_if_fail (match != NULL);
#line 68 "../../../src/core/common-actions.vala"
	if (SYNAPSE_IS_APPLICATION_MATCH (match)) {
#line 1356 "common-actions.c"
		SynapseApplicationMatch* app_match = NULL;
		GAppInfo* _tmp0_ = NULL;
		SynapseApplicationMatch* _tmp1_;
		GAppInfo* _tmp2_;
		GAppInfo* _tmp3_;
		GAppInfo* _tmp4_;
		GAppInfo* app = NULL;
		GAppInfo* _tmp9_;
#line 70 "../../../src/core/common-actions.vala"
		app_match = G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch);
#line 72 "../../../src/core/common-actions.vala"
		_tmp1_ = app_match;
#line 72 "../../../src/core/common-actions.vala"
		_tmp2_ = synapse_application_match_get_app_info (_tmp1_);
#line 72 "../../../src/core/common-actions.vala"
		_tmp3_ = _tmp2_;
#line 72 "../../../src/core/common-actions.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 72 "../../../src/core/common-actions.vala"
		_tmp0_ = _tmp4_;
#line 72 "../../../src/core/common-actions.vala"
		if (_tmp0_ == NULL) {
#line 1379 "common-actions.c"
			SynapseApplicationMatch* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			GDesktopAppInfo* _tmp8_;
#line 73 "../../../src/core/common-actions.vala"
			_tmp5_ = app_match;
#line 73 "../../../src/core/common-actions.vala"
			_tmp6_ = synapse_application_match_get_filename (_tmp5_);
#line 73 "../../../src/core/common-actions.vala"
			_tmp7_ = _tmp6_;
#line 73 "../../../src/core/common-actions.vala"
			_tmp8_ = g_desktop_app_info_new_from_filename (_tmp7_);
#line 73 "../../../src/core/common-actions.vala"
			_g_object_unref0 (_tmp0_);
#line 73 "../../../src/core/common-actions.vala"
			_tmp0_ = (GAppInfo*) _tmp8_;
#line 1396 "common-actions.c"
		}
#line 72 "../../../src/core/common-actions.vala"
		_tmp9_ = _tmp0_;
#line 72 "../../../src/core/common-actions.vala"
		_tmp0_ = NULL;
#line 72 "../../../src/core/common-actions.vala"
		app = _tmp9_;
#line 1404 "common-actions.c"
		{
			GAppInfo* _tmp10_;
			GdkDisplay* _tmp11_;
			GdkAppLaunchContext* _tmp12_;
			GdkAppLaunchContext* _tmp13_;
			SynapseRelevancyService* _tmp14_;
			SynapseRelevancyService* _tmp15_;
			GAppInfo* _tmp16_;
#line 77 "../../../src/core/common-actions.vala"
			_tmp10_ = app;
#line 77 "../../../src/core/common-actions.vala"
			_tmp11_ = gdk_display_get_default ();
#line 77 "../../../src/core/common-actions.vala"
			_tmp12_ = gdk_display_get_app_launch_context (_tmp11_);
#line 77 "../../../src/core/common-actions.vala"
			_tmp13_ = _tmp12_;
#line 77 "../../../src/core/common-actions.vala"
			g_app_info_launch (_tmp10_, NULL, (GAppLaunchContext*) _tmp13_, &_inner_error0_);
#line 77 "../../../src/core/common-actions.vala"
			_g_object_unref0 (_tmp13_);
#line 77 "../../../src/core/common-actions.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1427 "common-actions.c"
				goto __catch0_g_error;
			}
#line 79 "../../../src/core/common-actions.vala"
			_tmp14_ = synapse_relevancy_service_get_default ();
#line 79 "../../../src/core/common-actions.vala"
			_tmp15_ = _tmp14_;
#line 79 "../../../src/core/common-actions.vala"
			_tmp16_ = app;
#line 79 "../../../src/core/common-actions.vala"
			synapse_relevancy_service_application_launched (_tmp15_, _tmp16_);
#line 79 "../../../src/core/common-actions.vala"
			_g_object_unref0 (_tmp15_);
#line 1440 "common-actions.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GError* _tmp17_;
			const gchar* _tmp18_;
#line 75 "../../../src/core/common-actions.vala"
			err = _inner_error0_;
#line 75 "../../../src/core/common-actions.vala"
			_inner_error0_ = NULL;
#line 83 "../../../src/core/common-actions.vala"
			_tmp17_ = err;
#line 83 "../../../src/core/common-actions.vala"
			_tmp18_ = _tmp17_->message;
#line 83 "../../../src/core/common-actions.vala"
			g_warning ("common-actions.vala:83: %s", _tmp18_);
#line 75 "../../../src/core/common-actions.vala"
			_g_error_free0 (err);
#line 1460 "common-actions.c"
		}
		__finally0:
#line 75 "../../../src/core/common-actions.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 75 "../../../src/core/common-actions.vala"
			_g_object_unref0 (app);
#line 75 "../../../src/core/common-actions.vala"
			_g_object_unref0 (_tmp0_);
#line 75 "../../../src/core/common-actions.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 75 "../../../src/core/common-actions.vala"
			g_clear_error (&_inner_error0_);
#line 75 "../../../src/core/common-actions.vala"
			return;
#line 1475 "common-actions.c"
		}
#line 68 "../../../src/core/common-actions.vala"
		_g_object_unref0 (app);
#line 68 "../../../src/core/common-actions.vala"
		_g_object_unref0 (_tmp0_);
#line 1481 "common-actions.c"
	} else {
#line 86 "../../../src/core/common-actions.vala"
		if (SYNAPSE_IS_ACTION_MATCH (match)) {
#line 88 "../../../src/core/common-actions.vala"
			synapse_action_match_do_action (G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_ACTION_MATCH, SynapseActionMatch));
#line 1487 "common-actions.c"
		} else {
#line 90 "../../../src/core/common-actions.vala"
			if (SYNAPSE_IS_ACTION (match)) {
#line 92 "../../../src/core/common-actions.vala"
				synapse_action_do_execute (G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_ACTION, SynapseAction), match, target);
#line 1493 "common-actions.c"
			} else {
#line 94 "../../../src/core/common-actions.vala"
				if (SYNAPSE_IS_URI_MATCH (match)) {
#line 1497 "common-actions.c"
					{
						const gchar* uri = NULL;
						const gchar* _tmp19_;
						const gchar* _tmp20_;
						const gchar* _tmp21_;
#line 98 "../../../src/core/common-actions.vala"
						_tmp19_ = synapse_uri_match_get_uri (G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch));
#line 98 "../../../src/core/common-actions.vala"
						_tmp20_ = _tmp19_;
#line 98 "../../../src/core/common-actions.vala"
						uri = _tmp20_;
#line 99 "../../../src/core/common-actions.vala"
						_tmp21_ = uri;
#line 99 "../../../src/core/common-actions.vala"
						if (g_str_has_prefix (_tmp21_, "file:")) {
#line 1513 "common-actions.c"
							GFile* file = NULL;
							const gchar* _tmp22_;
							GFile* _tmp23_;
							GAppInfo* app = NULL;
							GFile* _tmp24_;
							gchar* _tmp25_;
							gchar* _tmp26_;
							GFile* _tmp27_;
							gchar* _tmp28_;
							gchar* _tmp29_;
							GAppInfo* _tmp30_;
							GAppInfo* _tmp31_;
							GAppInfo* _tmp32_;
							GdkDisplay* _tmp33_;
							GdkAppLaunchContext* _tmp34_;
							GdkAppLaunchContext* _tmp35_;
#line 101 "../../../src/core/common-actions.vala"
							_tmp22_ = uri;
#line 101 "../../../src/core/common-actions.vala"
							_tmp23_ = g_file_new_for_uri (_tmp22_);
#line 101 "../../../src/core/common-actions.vala"
							file = _tmp23_;
#line 102 "../../../src/core/common-actions.vala"
							_tmp24_ = file;
#line 102 "../../../src/core/common-actions.vala"
							_tmp25_ = g_file_get_path (_tmp24_);
#line 102 "../../../src/core/common-actions.vala"
							_tmp26_ = _tmp25_;
#line 102 "../../../src/core/common-actions.vala"
							_tmp27_ = file;
#line 102 "../../../src/core/common-actions.vala"
							_tmp28_ = g_file_get_basename (_tmp27_);
#line 102 "../../../src/core/common-actions.vala"
							_tmp29_ = _tmp28_;
#line 102 "../../../src/core/common-actions.vala"
							_tmp30_ = g_app_info_create_from_commandline (_tmp26_, _tmp29_, G_APP_INFO_CREATE_NONE, &_inner_error0_);
#line 102 "../../../src/core/common-actions.vala"
							_tmp31_ = _tmp30_;
#line 102 "../../../src/core/common-actions.vala"
							_g_free0 (_tmp29_);
#line 102 "../../../src/core/common-actions.vala"
							_g_free0 (_tmp26_);
#line 102 "../../../src/core/common-actions.vala"
							app = _tmp31_;
#line 102 "../../../src/core/common-actions.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 102 "../../../src/core/common-actions.vala"
								_g_object_unref0 (file);
#line 1562 "common-actions.c"
								goto __catch1_g_error;
							}
#line 105 "../../../src/core/common-actions.vala"
							_tmp32_ = app;
#line 105 "../../../src/core/common-actions.vala"
							_tmp33_ = gdk_display_get_default ();
#line 105 "../../../src/core/common-actions.vala"
							_tmp34_ = gdk_display_get_app_launch_context (_tmp33_);
#line 105 "../../../src/core/common-actions.vala"
							_tmp35_ = _tmp34_;
#line 105 "../../../src/core/common-actions.vala"
							g_app_info_launch (_tmp32_, NULL, (GAppLaunchContext*) _tmp35_, &_inner_error0_);
#line 105 "../../../src/core/common-actions.vala"
							_g_object_unref0 (_tmp35_);
#line 105 "../../../src/core/common-actions.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 105 "../../../src/core/common-actions.vala"
								_g_object_unref0 (app);
#line 105 "../../../src/core/common-actions.vala"
								_g_object_unref0 (file);
#line 1583 "common-actions.c"
								goto __catch1_g_error;
							}
#line 99 "../../../src/core/common-actions.vala"
							_g_object_unref0 (app);
#line 99 "../../../src/core/common-actions.vala"
							_g_object_unref0 (file);
#line 1590 "common-actions.c"
						}
					}
					goto __finally1;
					__catch1_g_error:
					{
						GError* err = NULL;
						GError* _tmp36_;
						const gchar* _tmp37_;
#line 96 "../../../src/core/common-actions.vala"
						err = _inner_error0_;
#line 96 "../../../src/core/common-actions.vala"
						_inner_error0_ = NULL;
#line 110 "../../../src/core/common-actions.vala"
						_tmp36_ = err;
#line 110 "../../../src/core/common-actions.vala"
						_tmp37_ = _tmp36_->message;
#line 110 "../../../src/core/common-actions.vala"
						g_warning ("common-actions.vala:110: %s", _tmp37_);
#line 96 "../../../src/core/common-actions.vala"
						_g_error_free0 (err);
#line 1611 "common-actions.c"
					}
					__finally1:
#line 96 "../../../src/core/common-actions.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 96 "../../../src/core/common-actions.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 96 "../../../src/core/common-actions.vala"
						g_clear_error (&_inner_error0_);
#line 96 "../../../src/core/common-actions.vala"
						return;
#line 1622 "common-actions.c"
					}
				} else {
					const gchar* _tmp38_;
					const gchar* _tmp39_;
#line 115 "../../../src/core/common-actions.vala"
					_tmp38_ = synapse_match_get_title (match);
#line 115 "../../../src/core/common-actions.vala"
					_tmp39_ = _tmp38_;
#line 115 "../../../src/core/common-actions.vala"
					g_warning ("common-actions.vala:115: '%s' is not be handled here", _tmp39_);
#line 1633 "common-actions.c"
				}
			}
		}
	}
}

static gboolean
synapse_common_actions_runner_real_valid_for_match (SynapseAction* base,
                                                    SynapseMatch* match)
{
	SynapseCommonActionsRunner * self;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean result = FALSE;
#line 119 "../../../src/core/common-actions.vala"
	self = (SynapseCommonActionsRunner*) base;
#line 119 "../../../src/core/common-actions.vala"
	g_return_val_if_fail (match != NULL, FALSE);
#line 121 "../../../src/core/common-actions.vala"
	if (SYNAPSE_IS_URI_MATCH (match)) {
#line 1654 "common-actions.c"
		const gchar* uri = NULL;
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
#line 123 "../../../src/core/common-actions.vala"
		_tmp0_ = synapse_uri_match_get_uri (G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch));
#line 123 "../../../src/core/common-actions.vala"
		_tmp1_ = _tmp0_;
#line 123 "../../../src/core/common-actions.vala"
		uri = _tmp1_;
#line 124 "../../../src/core/common-actions.vala"
		_tmp2_ = uri;
#line 124 "../../../src/core/common-actions.vala"
		if (g_str_has_prefix (_tmp2_, "file:")) {
#line 1669 "common-actions.c"
			gchar* path = NULL;
			const gchar* _tmp3_;
			GFile* _tmp4_;
			GFile* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gboolean _tmp8_ = FALSE;
			const gchar* _tmp9_;
#line 126 "../../../src/core/common-actions.vala"
			_tmp3_ = uri;
#line 126 "../../../src/core/common-actions.vala"
			_tmp4_ = g_file_new_for_uri (_tmp3_);
#line 126 "../../../src/core/common-actions.vala"
			_tmp5_ = _tmp4_;
#line 126 "../../../src/core/common-actions.vala"
			_tmp6_ = g_file_get_path (_tmp5_);
#line 126 "../../../src/core/common-actions.vala"
			_tmp7_ = _tmp6_;
#line 126 "../../../src/core/common-actions.vala"
			_g_object_unref0 (_tmp5_);
#line 126 "../../../src/core/common-actions.vala"
			path = _tmp7_;
#line 127 "../../../src/core/common-actions.vala"
			_tmp9_ = path;
#line 127 "../../../src/core/common-actions.vala"
			if (g_file_test (_tmp9_, G_FILE_TEST_IS_EXECUTABLE)) {
#line 1696 "common-actions.c"
				const gchar* _tmp10_;
#line 127 "../../../src/core/common-actions.vala"
				_tmp10_ = path;
#line 127 "../../../src/core/common-actions.vala"
				_tmp8_ = !g_file_test (_tmp10_, G_FILE_TEST_IS_DIR);
#line 1702 "common-actions.c"
			} else {
#line 127 "../../../src/core/common-actions.vala"
				_tmp8_ = FALSE;
#line 1706 "common-actions.c"
			}
#line 127 "../../../src/core/common-actions.vala"
			result = _tmp8_;
#line 127 "../../../src/core/common-actions.vala"
			_g_free0 (path);
#line 127 "../../../src/core/common-actions.vala"
			return result;
#line 1714 "common-actions.c"
		}
	}
#line 131 "../../../src/core/common-actions.vala"
	if (SYNAPSE_IS_ACTION (match)) {
#line 131 "../../../src/core/common-actions.vala"
		_tmp12_ = TRUE;
#line 1721 "common-actions.c"
	} else {
#line 132 "../../../src/core/common-actions.vala"
		_tmp12_ = SYNAPSE_IS_ACTION_MATCH (match);
#line 1725 "common-actions.c"
	}
#line 131 "../../../src/core/common-actions.vala"
	if (_tmp12_) {
#line 131 "../../../src/core/common-actions.vala"
		_tmp11_ = TRUE;
#line 1731 "common-actions.c"
	} else {
		gboolean _tmp13_ = FALSE;
#line 133 "../../../src/core/common-actions.vala"
		if (SYNAPSE_IS_APPLICATION_MATCH (match)) {
#line 1736 "common-actions.c"
			gboolean _tmp14_;
			gboolean _tmp15_;
#line 133 "../../../src/core/common-actions.vala"
			_tmp14_ = synapse_application_match_get_needs_terminal (G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch));
#line 133 "../../../src/core/common-actions.vala"
			_tmp15_ = _tmp14_;
#line 133 "../../../src/core/common-actions.vala"
			_tmp13_ = !_tmp15_;
#line 1745 "common-actions.c"
		} else {
#line 133 "../../../src/core/common-actions.vala"
			_tmp13_ = FALSE;
#line 1749 "common-actions.c"
		}
#line 133 "../../../src/core/common-actions.vala"
		_tmp11_ = _tmp13_;
#line 1753 "common-actions.c"
	}
#line 131 "../../../src/core/common-actions.vala"
	result = _tmp11_;
#line 131 "../../../src/core/common-actions.vala"
	return result;
#line 1759 "common-actions.c"
}

static void
synapse_common_actions_runner_class_init (SynapseCommonActionsRunnerClass * klass,
                                          gpointer klass_data)
{
#line 56 "../../../src/core/common-actions.vala"
	synapse_common_actions_runner_parent_class = g_type_class_peek_parent (klass);
#line 56 "../../../src/core/common-actions.vala"
	((SynapseActionClass *) klass)->do_execute = (void (*) (SynapseAction*, SynapseMatch*, SynapseMatch*)) synapse_common_actions_runner_real_do_execute;
#line 56 "../../../src/core/common-actions.vala"
	((SynapseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseAction*, SynapseMatch*)) synapse_common_actions_runner_real_valid_for_match;
#line 1772 "common-actions.c"
}

static void
synapse_common_actions_runner_instance_init (SynapseCommonActionsRunner * self,
                                             gpointer klass)
{
}

static GType
synapse_common_actions_runner_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsRunner), 0, (GInstanceInitFunc) synapse_common_actions_runner_instance_init, NULL };
	GType synapse_common_actions_runner_type_id;
	synapse_common_actions_runner_type_id = g_type_register_static (SYNAPSE_TYPE_ACTION, "SynapseCommonActionsRunner", &g_define_type_info, 0);
	return synapse_common_actions_runner_type_id;
}

static GType
synapse_common_actions_runner_get_type (void)
{
	static volatile gsize synapse_common_actions_runner_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_runner_type_id__volatile)) {
		GType synapse_common_actions_runner_type_id;
		synapse_common_actions_runner_type_id = synapse_common_actions_runner_get_type_once ();
		g_once_init_leave (&synapse_common_actions_runner_type_id__volatile, synapse_common_actions_runner_type_id);
	}
	return synapse_common_actions_runner_type_id__volatile;
}

static SynapseCommonActionsTerminalRunner*
synapse_common_actions_terminal_runner_construct (GType object_type)
{
	SynapseCommonActionsTerminalRunner * self = NULL;
#line 141 "../../../src/core/common-actions.vala"
	self = (SynapseCommonActionsTerminalRunner*) g_object_new (object_type, "title", _ ("Run in Terminal"), "description", _ ("Run application or command in terminal"), "icon-name", "terminal", "has-thumbnail", FALSE, "default-relevancy", SYNAPSE_MATCH_SCORE_BELOW_AVERAGE, NULL);
#line 139 "../../../src/core/common-actions.vala"
	return self;
#line 1810 "common-actions.c"
}

static SynapseCommonActionsTerminalRunner*
synapse_common_actions_terminal_runner_new (void)
{
#line 139 "../../../src/core/common-actions.vala"
	return synapse_common_actions_terminal_runner_construct (SYNAPSE_COMMON_ACTIONS_TYPE_TERMINAL_RUNNER);
#line 1818 "common-actions.c"
}

static void
synapse_common_actions_terminal_runner_real_do_execute (SynapseAction* base,
                                                        SynapseMatch* match,
                                                        SynapseMatch* target)
{
	SynapseCommonActionsTerminalRunner * self;
	GError* _inner_error0_ = NULL;
#line 147 "../../../src/core/common-actions.vala"
	self = (SynapseCommonActionsTerminalRunner*) base;
#line 147 "../../../src/core/common-actions.vala"
	g_return_if_fail (match != NULL);
#line 149 "../../../src/core/common-actions.vala"
	if (SYNAPSE_IS_APPLICATION_MATCH (match)) {
#line 1834 "common-actions.c"
		SynapseApplicationMatch* app_match = NULL;
		GAppInfo* _tmp0_ = NULL;
		SynapseApplicationMatch* _tmp1_;
		GAppInfo* _tmp2_;
		GAppInfo* _tmp3_;
		GAppInfo* _tmp4_;
		GAppInfo* original = NULL;
		GAppInfo* _tmp9_;
		GAppInfo* _tmp10_;
		const gchar* _tmp11_;
		GAppInfo* _tmp12_;
		const gchar* _tmp13_;
#line 151 "../../../src/core/common-actions.vala"
		app_match = G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch);
#line 153 "../../../src/core/common-actions.vala"
		_tmp1_ = app_match;
#line 153 "../../../src/core/common-actions.vala"
		_tmp2_ = synapse_application_match_get_app_info (_tmp1_);
#line 153 "../../../src/core/common-actions.vala"
		_tmp3_ = _tmp2_;
#line 153 "../../../src/core/common-actions.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 153 "../../../src/core/common-actions.vala"
		_tmp0_ = _tmp4_;
#line 153 "../../../src/core/common-actions.vala"
		if (_tmp0_ == NULL) {
#line 1861 "common-actions.c"
			SynapseApplicationMatch* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			GDesktopAppInfo* _tmp8_;
#line 154 "../../../src/core/common-actions.vala"
			_tmp5_ = app_match;
#line 154 "../../../src/core/common-actions.vala"
			_tmp6_ = synapse_application_match_get_filename (_tmp5_);
#line 154 "../../../src/core/common-actions.vala"
			_tmp7_ = _tmp6_;
#line 154 "../../../src/core/common-actions.vala"
			_tmp8_ = g_desktop_app_info_new_from_filename (_tmp7_);
#line 154 "../../../src/core/common-actions.vala"
			_g_object_unref0 (_tmp0_);
#line 154 "../../../src/core/common-actions.vala"
			_tmp0_ = (GAppInfo*) _tmp8_;
#line 1878 "common-actions.c"
		}
#line 153 "../../../src/core/common-actions.vala"
		_tmp9_ = _tmp0_;
#line 153 "../../../src/core/common-actions.vala"
		_tmp0_ = NULL;
#line 153 "../../../src/core/common-actions.vala"
		original = _tmp9_;
#line 156 "../../../src/core/common-actions.vala"
		_tmp10_ = original;
#line 156 "../../../src/core/common-actions.vala"
		_tmp11_ = g_app_info_get_commandline (_tmp10_);
#line 156 "../../../src/core/common-actions.vala"
		_tmp12_ = original;
#line 156 "../../../src/core/common-actions.vala"
		_tmp13_ = g_app_info_get_name (_tmp12_);
#line 156 "../../../src/core/common-actions.vala"
		synapse_utils_open_command_line (_tmp11_, _tmp13_, TRUE);
#line 149 "../../../src/core/common-actions.vala"
		_g_object_unref0 (original);
#line 149 "../../../src/core/common-actions.vala"
		_g_object_unref0 (_tmp0_);
#line 1900 "common-actions.c"
	} else {
#line 158 "../../../src/core/common-actions.vala"
		if (SYNAPSE_IS_URI_MATCH (match)) {
#line 1904 "common-actions.c"
			{
				const gchar* uri = NULL;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
#line 162 "../../../src/core/common-actions.vala"
				_tmp14_ = synapse_uri_match_get_uri (G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch));
#line 162 "../../../src/core/common-actions.vala"
				_tmp15_ = _tmp14_;
#line 162 "../../../src/core/common-actions.vala"
				uri = _tmp15_;
#line 163 "../../../src/core/common-actions.vala"
				_tmp16_ = uri;
#line 163 "../../../src/core/common-actions.vala"
				if (g_str_has_prefix (_tmp16_, "file:")) {
#line 1920 "common-actions.c"
					GFile* file = NULL;
					const gchar* _tmp17_;
					GFile* _tmp18_;
					GAppInfo* app = NULL;
					GFile* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					GFile* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					GAppInfo* _tmp25_;
					GAppInfo* _tmp26_;
					GAppInfo* _tmp27_;
					GdkDisplay* _tmp28_;
					GdkAppLaunchContext* _tmp29_;
					GdkAppLaunchContext* _tmp30_;
#line 165 "../../../src/core/common-actions.vala"
					_tmp17_ = uri;
#line 165 "../../../src/core/common-actions.vala"
					_tmp18_ = g_file_new_for_uri (_tmp17_);
#line 165 "../../../src/core/common-actions.vala"
					file = _tmp18_;
#line 166 "../../../src/core/common-actions.vala"
					_tmp19_ = file;
#line 166 "../../../src/core/common-actions.vala"
					_tmp20_ = g_file_get_path (_tmp19_);
#line 166 "../../../src/core/common-actions.vala"
					_tmp21_ = _tmp20_;
#line 166 "../../../src/core/common-actions.vala"
					_tmp22_ = file;
#line 166 "../../../src/core/common-actions.vala"
					_tmp23_ = g_file_get_basename (_tmp22_);
#line 166 "../../../src/core/common-actions.vala"
					_tmp24_ = _tmp23_;
#line 166 "../../../src/core/common-actions.vala"
					_tmp25_ = g_app_info_create_from_commandline (_tmp21_, _tmp24_, G_APP_INFO_CREATE_NEEDS_TERMINAL, &_inner_error0_);
#line 166 "../../../src/core/common-actions.vala"
					_tmp26_ = _tmp25_;
#line 166 "../../../src/core/common-actions.vala"
					_g_free0 (_tmp24_);
#line 166 "../../../src/core/common-actions.vala"
					_g_free0 (_tmp21_);
#line 166 "../../../src/core/common-actions.vala"
					app = _tmp26_;
#line 166 "../../../src/core/common-actions.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 166 "../../../src/core/common-actions.vala"
						_g_object_unref0 (file);
#line 1969 "common-actions.c"
						goto __catch0_g_error;
					}
#line 169 "../../../src/core/common-actions.vala"
					_tmp27_ = app;
#line 169 "../../../src/core/common-actions.vala"
					_tmp28_ = gdk_display_get_default ();
#line 169 "../../../src/core/common-actions.vala"
					_tmp29_ = gdk_display_get_app_launch_context (_tmp28_);
#line 169 "../../../src/core/common-actions.vala"
					_tmp30_ = _tmp29_;
#line 169 "../../../src/core/common-actions.vala"
					g_app_info_launch (_tmp27_, NULL, (GAppLaunchContext*) _tmp30_, &_inner_error0_);
#line 169 "../../../src/core/common-actions.vala"
					_g_object_unref0 (_tmp30_);
#line 169 "../../../src/core/common-actions.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 169 "../../../src/core/common-actions.vala"
						_g_object_unref0 (app);
#line 169 "../../../src/core/common-actions.vala"
						_g_object_unref0 (file);
#line 1990 "common-actions.c"
						goto __catch0_g_error;
					}
#line 163 "../../../src/core/common-actions.vala"
					_g_object_unref0 (app);
#line 163 "../../../src/core/common-actions.vala"
					_g_object_unref0 (file);
#line 1997 "common-actions.c"
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* err = NULL;
				GError* _tmp31_;
				const gchar* _tmp32_;
#line 160 "../../../src/core/common-actions.vala"
				err = _inner_error0_;
#line 160 "../../../src/core/common-actions.vala"
				_inner_error0_ = NULL;
#line 174 "../../../src/core/common-actions.vala"
				_tmp31_ = err;
#line 174 "../../../src/core/common-actions.vala"
				_tmp32_ = _tmp31_->message;
#line 174 "../../../src/core/common-actions.vala"
				g_warning ("common-actions.vala:174: %s", _tmp32_);
#line 160 "../../../src/core/common-actions.vala"
				_g_error_free0 (err);
#line 2018 "common-actions.c"
			}
			__finally0:
#line 160 "../../../src/core/common-actions.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 160 "../../../src/core/common-actions.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 160 "../../../src/core/common-actions.vala"
				g_clear_error (&_inner_error0_);
#line 160 "../../../src/core/common-actions.vala"
				return;
#line 2029 "common-actions.c"
			}
		}
	}
}

static gboolean
synapse_common_actions_terminal_runner_real_valid_for_match (SynapseAction* base,
                                                             SynapseMatch* match)
{
	SynapseCommonActionsTerminalRunner * self;
	gboolean result = FALSE;
#line 179 "../../../src/core/common-actions.vala"
	self = (SynapseCommonActionsTerminalRunner*) base;
#line 179 "../../../src/core/common-actions.vala"
	g_return_val_if_fail (match != NULL, FALSE);
#line 181 "../../../src/core/common-actions.vala"
	if (SYNAPSE_IS_URI_MATCH (match)) {
#line 2047 "common-actions.c"
		const gchar* uri = NULL;
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
#line 183 "../../../src/core/common-actions.vala"
		_tmp0_ = synapse_uri_match_get_uri (G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch));
#line 183 "../../../src/core/common-actions.vala"
		_tmp1_ = _tmp0_;
#line 183 "../../../src/core/common-actions.vala"
		uri = _tmp1_;
#line 184 "../../../src/core/common-actions.vala"
		_tmp2_ = uri;
#line 184 "../../../src/core/common-actions.vala"
		if (g_str_has_prefix (_tmp2_, "file:")) {
#line 2062 "common-actions.c"
			gchar* path = NULL;
			const gchar* _tmp3_;
			GFile* _tmp4_;
			GFile* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gboolean _tmp8_ = FALSE;
			const gchar* _tmp9_;
#line 186 "../../../src/core/common-actions.vala"
			_tmp3_ = uri;
#line 186 "../../../src/core/common-actions.vala"
			_tmp4_ = g_file_new_for_uri (_tmp3_);
#line 186 "../../../src/core/common-actions.vala"
			_tmp5_ = _tmp4_;
#line 186 "../../../src/core/common-actions.vala"
			_tmp6_ = g_file_get_path (_tmp5_);
#line 186 "../../../src/core/common-actions.vala"
			_tmp7_ = _tmp6_;
#line 186 "../../../src/core/common-actions.vala"
			_g_object_unref0 (_tmp5_);
#line 186 "../../../src/core/common-actions.vala"
			path = _tmp7_;
#line 187 "../../../src/core/common-actions.vala"
			_tmp9_ = path;
#line 187 "../../../src/core/common-actions.vala"
			if (g_file_test (_tmp9_, G_FILE_TEST_IS_EXECUTABLE)) {
#line 2089 "common-actions.c"
				const gchar* _tmp10_;
#line 187 "../../../src/core/common-actions.vala"
				_tmp10_ = path;
#line 187 "../../../src/core/common-actions.vala"
				_tmp8_ = !g_file_test (_tmp10_, G_FILE_TEST_IS_DIR);
#line 2095 "common-actions.c"
			} else {
#line 187 "../../../src/core/common-actions.vala"
				_tmp8_ = FALSE;
#line 2099 "common-actions.c"
			}
#line 187 "../../../src/core/common-actions.vala"
			result = _tmp8_;
#line 187 "../../../src/core/common-actions.vala"
			_g_free0 (path);
#line 187 "../../../src/core/common-actions.vala"
			return result;
#line 2107 "common-actions.c"
		}
	}
#line 190 "../../../src/core/common-actions.vala"
	result = SYNAPSE_IS_APPLICATION_MATCH (match);
#line 190 "../../../src/core/common-actions.vala"
	return result;
#line 2114 "common-actions.c"
}

static void
synapse_common_actions_terminal_runner_class_init (SynapseCommonActionsTerminalRunnerClass * klass,
                                                   gpointer klass_data)
{
#line 137 "../../../src/core/common-actions.vala"
	synapse_common_actions_terminal_runner_parent_class = g_type_class_peek_parent (klass);
#line 137 "../../../src/core/common-actions.vala"
	((SynapseActionClass *) klass)->do_execute = (void (*) (SynapseAction*, SynapseMatch*, SynapseMatch*)) synapse_common_actions_terminal_runner_real_do_execute;
#line 137 "../../../src/core/common-actions.vala"
	((SynapseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseAction*, SynapseMatch*)) synapse_common_actions_terminal_runner_real_valid_for_match;
#line 2127 "common-actions.c"
}

static void
synapse_common_actions_terminal_runner_instance_init (SynapseCommonActionsTerminalRunner * self,
                                                      gpointer klass)
{
}

static GType
synapse_common_actions_terminal_runner_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsTerminalRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_terminal_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsTerminalRunner), 0, (GInstanceInitFunc) synapse_common_actions_terminal_runner_instance_init, NULL };
	GType synapse_common_actions_terminal_runner_type_id;
	synapse_common_actions_terminal_runner_type_id = g_type_register_static (SYNAPSE_TYPE_ACTION, "SynapseCommonActionsTerminalRunner", &g_define_type_info, 0);
	return synapse_common_actions_terminal_runner_type_id;
}

static GType
synapse_common_actions_terminal_runner_get_type (void)
{
	static volatile gsize synapse_common_actions_terminal_runner_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_terminal_runner_type_id__volatile)) {
		GType synapse_common_actions_terminal_runner_type_id;
		synapse_common_actions_terminal_runner_type_id = synapse_common_actions_terminal_runner_get_type_once ();
		g_once_init_leave (&synapse_common_actions_terminal_runner_type_id__volatile, synapse_common_actions_terminal_runner_type_id);
	}
	return synapse_common_actions_terminal_runner_type_id__volatile;
}

static inline gpointer
synapse_common_actions_opener_get_instance_private (SynapseCommonActionsOpener* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCommonActionsOpener_private_offset);
}

static SynapseCommonActionsOpener*
synapse_common_actions_opener_construct (GType object_type)
{
	SynapseCommonActionsOpener * self = NULL;
#line 198 "../../../src/core/common-actions.vala"
	self = (SynapseCommonActionsOpener*) g_object_new (object_type, "title", _ ("Open"), "description", _ ("Open using default application"), "icon-name", "fileopen", "has-thumbnail", FALSE, "default-relevancy", SYNAPSE_MATCH_SCORE_GOOD, NULL);
#line 196 "../../../src/core/common-actions.vala"
	return self;
#line 2171 "common-actions.c"
}

static SynapseCommonActionsOpener*
synapse_common_actions_opener_new (void)
{
#line 196 "../../../src/core/common-actions.vala"
	return synapse_common_actions_opener_construct (SYNAPSE_COMMON_ACTIONS_TYPE_OPENER);
#line 2179 "common-actions.c"
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
#line 1447 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1447 "glib-2.0.vapi"
	end = _tmp0_;
#line 1448 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1448 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1449 "glib-2.0.vapi"
		result = maxlen;
#line 1449 "glib-2.0.vapi"
		return result;
#line 2202 "common-actions.c"
	} else {
		gchar* _tmp2_;
#line 1451 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1451 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1451 "glib-2.0.vapi"
		return result;
#line 2211 "common-actions.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
#line 1458 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1460 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 2230 "common-actions.c"
	} else {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 2234 "common-actions.c"
	}
#line 1460 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1462 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 2240 "common-actions.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1464 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1464 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1464 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 2250 "common-actions.c"
	}
#line 1467 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1468 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1469 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 2258 "common-actions.c"
	} else {
#line 1471 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 2262 "common-actions.c"
	}
#line 1473 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1474 "glib-2.0.vapi"
		len = string_length - offset;
#line 2268 "common-actions.c"
	}
#line 1476 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1477 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1477 "glib-2.0.vapi"
	result = _tmp3_;
#line 1477 "glib-2.0.vapi"
	return result;
#line 2278 "common-actions.c"
}

static void
synapse_common_actions_opener_real_do_execute (SynapseAction* base,
                                               SynapseMatch* match,
                                               SynapseMatch* target)
{
	SynapseCommonActionsOpener * self;
	SynapseUriMatch* uri_match = NULL;
	SynapseUriMatch* _tmp0_;
#line 204 "../../../src/core/common-actions.vala"
	self = (SynapseCommonActionsOpener*) base;
#line 204 "../../../src/core/common-actions.vala"
	g_return_if_fail (match != NULL);
#line 206 "../../../src/core/common-actions.vala"
	uri_match = SYNAPSE_IS_URI_MATCH (match) ? ((SynapseUriMatch*) match) : NULL;
#line 208 "../../../src/core/common-actions.vala"
	_tmp0_ = uri_match;
#line 208 "../../../src/core/common-actions.vala"
	if (_tmp0_ != NULL) {
#line 2299 "common-actions.c"
		SynapseUriMatch* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
#line 210 "../../../src/core/common-actions.vala"
		_tmp1_ = uri_match;
#line 210 "../../../src/core/common-actions.vala"
		_tmp2_ = synapse_uri_match_get_uri (_tmp1_);
#line 210 "../../../src/core/common-actions.vala"
		_tmp3_ = _tmp2_;
#line 210 "../../../src/core/common-actions.vala"
		synapse_utils_open_uri (_tmp3_);
#line 2311 "common-actions.c"
	} else {
		GRegex* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
#line 212 "../../../src/core/common-actions.vala"
		_tmp4_ = self->priv->file_path;
#line 212 "../../../src/core/common-actions.vala"
		_tmp5_ = synapse_match_get_title (match);
#line 212 "../../../src/core/common-actions.vala"
		_tmp6_ = _tmp5_;
#line 212 "../../../src/core/common-actions.vala"
		if (g_regex_match (_tmp4_, _tmp6_, 0, NULL)) {
#line 2324 "common-actions.c"
			GFile* f = NULL;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			GFile* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
#line 215 "../../../src/core/common-actions.vala"
			_tmp7_ = synapse_match_get_title (match);
#line 215 "../../../src/core/common-actions.vala"
			_tmp8_ = _tmp7_;
#line 215 "../../../src/core/common-actions.vala"
			if (g_str_has_prefix (_tmp8_, "~")) {
#line 2337 "common-actions.c"
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				GFile* _tmp16_;
#line 217 "../../../src/core/common-actions.vala"
				_tmp9_ = g_get_home_dir ();
#line 217 "../../../src/core/common-actions.vala"
				_tmp10_ = synapse_match_get_title (match);
#line 217 "../../../src/core/common-actions.vala"
				_tmp11_ = _tmp10_;
#line 217 "../../../src/core/common-actions.vala"
				_tmp12_ = string_substring (_tmp11_, (glong) 1, (glong) -1);
#line 217 "../../../src/core/common-actions.vala"
				_tmp13_ = _tmp12_;
#line 217 "../../../src/core/common-actions.vala"
				_tmp14_ = g_build_filename (_tmp9_, _tmp13_, NULL, NULL);
#line 217 "../../../src/core/common-actions.vala"
				_tmp15_ = _tmp14_;
#line 217 "../../../src/core/common-actions.vala"
				_tmp16_ = g_file_new_for_path (_tmp15_);
#line 217 "../../../src/core/common-actions.vala"
				_g_object_unref0 (f);
#line 217 "../../../src/core/common-actions.vala"
				f = _tmp16_;
#line 217 "../../../src/core/common-actions.vala"
				_g_free0 (_tmp15_);
#line 217 "../../../src/core/common-actions.vala"
				_g_free0 (_tmp13_);
#line 2370 "common-actions.c"
			} else {
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				GFile* _tmp19_;
#line 223 "../../../src/core/common-actions.vala"
				_tmp17_ = synapse_match_get_title (match);
#line 223 "../../../src/core/common-actions.vala"
				_tmp18_ = _tmp17_;
#line 223 "../../../src/core/common-actions.vala"
				_tmp19_ = g_file_new_for_path (_tmp18_);
#line 223 "../../../src/core/common-actions.vala"
				_g_object_unref0 (f);
#line 223 "../../../src/core/common-actions.vala"
				f = _tmp19_;
#line 2385 "common-actions.c"
			}
#line 225 "../../../src/core/common-actions.vala"
			_tmp20_ = f;
#line 225 "../../../src/core/common-actions.vala"
			_tmp21_ = g_file_get_uri (_tmp20_);
#line 225 "../../../src/core/common-actions.vala"
			_tmp22_ = _tmp21_;
#line 225 "../../../src/core/common-actions.vala"
			synapse_utils_open_uri (_tmp22_);
#line 225 "../../../src/core/common-actions.vala"
			_g_free0 (_tmp22_);
#line 212 "../../../src/core/common-actions.vala"
			_g_object_unref0 (f);
#line 2399 "common-actions.c"
		} else {
			const gchar* _tmp23_;
			const gchar* _tmp24_;
#line 229 "../../../src/core/common-actions.vala"
			_tmp23_ = synapse_match_get_title (match);
#line 229 "../../../src/core/common-actions.vala"
			_tmp24_ = _tmp23_;
#line 229 "../../../src/core/common-actions.vala"
			synapse_utils_open_uri (_tmp24_);
#line 2409 "common-actions.c"
		}
	}
}

static gboolean
synapse_common_actions_opener_real_valid_for_match (SynapseAction* base,
                                                    SynapseMatch* match)
{
	SynapseCommonActionsOpener * self;
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
#line 233 "../../../src/core/common-actions.vala"
	self = (SynapseCommonActionsOpener*) base;
#line 233 "../../../src/core/common-actions.vala"
	g_return_val_if_fail (match != NULL, FALSE);
#line 235 "../../../src/core/common-actions.vala"
	if (SYNAPSE_IS_URI_MATCH (match)) {
#line 235 "../../../src/core/common-actions.vala"
		_tmp0_ = TRUE;
#line 2429 "common-actions.c"
	} else {
		gboolean _tmp1_ = FALSE;
#line 236 "../../../src/core/common-actions.vala"
		if (SYNAPSE_IS_UNKNOWN_MATCH (match)) {
#line 2434 "common-actions.c"
			gboolean _tmp2_ = FALSE;
			GRegex* _tmp3_;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
#line 236 "../../../src/core/common-actions.vala"
			_tmp3_ = self->priv->web_uri;
#line 236 "../../../src/core/common-actions.vala"
			_tmp4_ = synapse_match_get_title (match);
#line 236 "../../../src/core/common-actions.vala"
			_tmp5_ = _tmp4_;
#line 236 "../../../src/core/common-actions.vala"
			if (g_regex_match (_tmp3_, _tmp5_, 0, NULL)) {
#line 236 "../../../src/core/common-actions.vala"
				_tmp2_ = TRUE;
#line 2449 "common-actions.c"
			} else {
				GRegex* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
#line 236 "../../../src/core/common-actions.vala"
				_tmp6_ = self->priv->file_path;
#line 236 "../../../src/core/common-actions.vala"
				_tmp7_ = synapse_match_get_title (match);
#line 236 "../../../src/core/common-actions.vala"
				_tmp8_ = _tmp7_;
#line 236 "../../../src/core/common-actions.vala"
				_tmp2_ = g_regex_match (_tmp6_, _tmp8_, 0, NULL);
#line 2462 "common-actions.c"
			}
#line 236 "../../../src/core/common-actions.vala"
			_tmp1_ = _tmp2_;
#line 2466 "common-actions.c"
		} else {
#line 236 "../../../src/core/common-actions.vala"
			_tmp1_ = FALSE;
#line 2470 "common-actions.c"
		}
#line 236 "../../../src/core/common-actions.vala"
		_tmp0_ = _tmp1_;
#line 2474 "common-actions.c"
	}
#line 235 "../../../src/core/common-actions.vala"
	result = _tmp0_;
#line 235 "../../../src/core/common-actions.vala"
	return result;
#line 2480 "common-actions.c"
}

static GObject *
synapse_common_actions_opener_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseCommonActionsOpener * self;
	GError* _inner_error0_ = NULL;
#line 242 "../../../src/core/common-actions.vala"
	parent_class = G_OBJECT_CLASS (synapse_common_actions_opener_parent_class);
#line 242 "../../../src/core/common-actions.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 242 "../../../src/core/common-actions.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpener);
#line 2498 "common-actions.c"
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_;
		GRegex* _tmp5_;
#line 246 "../../../src/core/common-actions.vala"
		_tmp1_ = g_regex_new ("^(ftp|http(s)?)://[^.]+\\.[^.]+", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
#line 246 "../../../src/core/common-actions.vala"
		_tmp0_ = _tmp1_;
#line 246 "../../../src/core/common-actions.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2512 "common-actions.c"
			goto __catch0_g_error;
		}
#line 246 "../../../src/core/common-actions.vala"
		_tmp2_ = _tmp0_;
#line 246 "../../../src/core/common-actions.vala"
		_tmp0_ = NULL;
#line 246 "../../../src/core/common-actions.vala"
		_g_regex_unref0 (self->priv->web_uri);
#line 246 "../../../src/core/common-actions.vala"
		self->priv->web_uri = _tmp2_;
#line 247 "../../../src/core/common-actions.vala"
		_tmp4_ = g_regex_new ("^(/|~/)[^/]+", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
#line 247 "../../../src/core/common-actions.vala"
		_tmp3_ = _tmp4_;
#line 247 "../../../src/core/common-actions.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 247 "../../../src/core/common-actions.vala"
			_g_regex_unref0 (_tmp0_);
#line 2531 "common-actions.c"
			goto __catch0_g_error;
		}
#line 247 "../../../src/core/common-actions.vala"
		_tmp5_ = _tmp3_;
#line 247 "../../../src/core/common-actions.vala"
		_tmp3_ = NULL;
#line 247 "../../../src/core/common-actions.vala"
		_g_regex_unref0 (self->priv->file_path);
#line 247 "../../../src/core/common-actions.vala"
		self->priv->file_path = _tmp5_;
#line 244 "../../../src/core/common-actions.vala"
		_g_regex_unref0 (_tmp3_);
#line 244 "../../../src/core/common-actions.vala"
		_g_regex_unref0 (_tmp0_);
#line 2546 "common-actions.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 244 "../../../src/core/common-actions.vala"
		err = _inner_error0_;
#line 244 "../../../src/core/common-actions.vala"
		_inner_error0_ = NULL;
#line 251 "../../../src/core/common-actions.vala"
		_tmp6_ = err;
#line 251 "../../../src/core/common-actions.vala"
		_tmp7_ = _tmp6_->message;
#line 251 "../../../src/core/common-actions.vala"
		g_warning ("common-actions.vala:251: %s", _tmp7_);
#line 244 "../../../src/core/common-actions.vala"
		_g_error_free0 (err);
#line 2566 "common-actions.c"
	}
	__finally0:
#line 244 "../../../src/core/common-actions.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 244 "../../../src/core/common-actions.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 244 "../../../src/core/common-actions.vala"
		g_clear_error (&_inner_error0_);
#line 2575 "common-actions.c"
	}
#line 242 "../../../src/core/common-actions.vala"
	return obj;
#line 2579 "common-actions.c"
}

static void
synapse_common_actions_opener_class_init (SynapseCommonActionsOpenerClass * klass,
                                          gpointer klass_data)
{
#line 194 "../../../src/core/common-actions.vala"
	synapse_common_actions_opener_parent_class = g_type_class_peek_parent (klass);
#line 194 "../../../src/core/common-actions.vala"
	g_type_class_adjust_private_offset (klass, &SynapseCommonActionsOpener_private_offset);
#line 194 "../../../src/core/common-actions.vala"
	((SynapseActionClass *) klass)->do_execute = (void (*) (SynapseAction*, SynapseMatch*, SynapseMatch*)) synapse_common_actions_opener_real_do_execute;
#line 194 "../../../src/core/common-actions.vala"
	((SynapseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseAction*, SynapseMatch*)) synapse_common_actions_opener_real_valid_for_match;
#line 194 "../../../src/core/common-actions.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_common_actions_opener_constructor;
#line 194 "../../../src/core/common-actions.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_common_actions_opener_finalize;
#line 2598 "common-actions.c"
}

static void
synapse_common_actions_opener_instance_init (SynapseCommonActionsOpener * self,
                                             gpointer klass)
{
#line 194 "../../../src/core/common-actions.vala"
	self->priv = synapse_common_actions_opener_get_instance_private (self);
#line 2607 "common-actions.c"
}

static void
synapse_common_actions_opener_finalize (GObject * obj)
{
	SynapseCommonActionsOpener * self;
#line 194 "../../../src/core/common-actions.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_COMMON_ACTIONS_TYPE_OPENER, SynapseCommonActionsOpener);
#line 239 "../../../src/core/common-actions.vala"
	_g_regex_unref0 (self->priv->web_uri);
#line 240 "../../../src/core/common-actions.vala"
	_g_regex_unref0 (self->priv->file_path);
#line 194 "../../../src/core/common-actions.vala"
	G_OBJECT_CLASS (synapse_common_actions_opener_parent_class)->finalize (obj);
#line 2622 "common-actions.c"
}

static GType
synapse_common_actions_opener_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsOpenerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_opener_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsOpener), 0, (GInstanceInitFunc) synapse_common_actions_opener_instance_init, NULL };
	GType synapse_common_actions_opener_type_id;
	synapse_common_actions_opener_type_id = g_type_register_static (SYNAPSE_TYPE_ACTION, "SynapseCommonActionsOpener", &g_define_type_info, 0);
	SynapseCommonActionsOpener_private_offset = g_type_add_instance_private (synapse_common_actions_opener_type_id, sizeof (SynapseCommonActionsOpenerPrivate));
	return synapse_common_actions_opener_type_id;
}

static GType
synapse_common_actions_opener_get_type (void)
{
	static volatile gsize synapse_common_actions_opener_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_opener_type_id__volatile)) {
		GType synapse_common_actions_opener_type_id;
		synapse_common_actions_opener_type_id = synapse_common_actions_opener_get_type_once ();
		g_once_init_leave (&synapse_common_actions_opener_type_id__volatile, synapse_common_actions_opener_type_id);
	}
	return synapse_common_actions_opener_type_id__volatile;
}

static SynapseCommonActionsOpenFolder*
synapse_common_actions_open_folder_construct (GType object_type)
{
	SynapseCommonActionsOpenFolder * self = NULL;
#line 260 "../../../src/core/common-actions.vala"
	self = (SynapseCommonActionsOpenFolder*) g_object_new (object_type, "title", _ ("Open folder"), "description", _ ("Open folder containing this file"), "icon-name", "folder-open", "has-thumbnail", FALSE, "default-relevancy", SYNAPSE_MATCH_SCORE_AVERAGE, NULL);
#line 258 "../../../src/core/common-actions.vala"
	return self;
#line 2655 "common-actions.c"
}

static SynapseCommonActionsOpenFolder*
synapse_common_actions_open_folder_new (void)
{
#line 258 "../../../src/core/common-actions.vala"
	return synapse_common_actions_open_folder_construct (SYNAPSE_COMMON_ACTIONS_TYPE_OPEN_FOLDER);
#line 2663 "common-actions.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 278 "../../../src/core/common-actions.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 2671 "common-actions.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 278 "../../../src/core/common-actions.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 2679 "common-actions.c"
}

static void
synapse_common_actions_open_folder_real_do_execute (SynapseAction* base,
                                                    SynapseMatch* match,
                                                    SynapseMatch* target)
{
	SynapseCommonActionsOpenFolder * self;
	SynapseUriMatch* uri_match = NULL;
	SynapseUriMatch* _tmp0_;
	GFile* f = NULL;
	SynapseUriMatch* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GError* _inner_error0_ = NULL;
#line 266 "../../../src/core/common-actions.vala"
	self = (SynapseCommonActionsOpenFolder*) base;
#line 266 "../../../src/core/common-actions.vala"
	g_return_if_fail (match != NULL);
#line 268 "../../../src/core/common-actions.vala"
	uri_match = SYNAPSE_IS_URI_MATCH (match) ? ((SynapseUriMatch*) match) : NULL;
#line 269 "../../../src/core/common-actions.vala"
	_tmp0_ = uri_match;
#line 269 "../../../src/core/common-actions.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 271 "../../../src/core/common-actions.vala"
	_tmp1_ = uri_match;
#line 271 "../../../src/core/common-actions.vala"
	_tmp2_ = synapse_uri_match_get_uri (_tmp1_);
#line 271 "../../../src/core/common-actions.vala"
	_tmp3_ = _tmp2_;
#line 271 "../../../src/core/common-actions.vala"
	_tmp4_ = g_file_new_for_uri (_tmp3_);
#line 271 "../../../src/core/common-actions.vala"
	f = _tmp4_;
#line 272 "../../../src/core/common-actions.vala"
	_tmp5_ = f;
#line 272 "../../../src/core/common-actions.vala"
	_tmp6_ = g_file_get_parent (_tmp5_);
#line 272 "../../../src/core/common-actions.vala"
	_g_object_unref0 (f);
#line 272 "../../../src/core/common-actions.vala"
	f = _tmp6_;
#line 2726 "common-actions.c"
	{
		GAppInfo* app_info = NULL;
		GFile* _tmp7_;
		GAppInfo* _tmp8_;
		GList* files = NULL;
		GFile* _tmp9_;
		GFile* _tmp10_;
		GAppInfo* _tmp11_;
		GList* _tmp12_;
		GdkDisplay* _tmp13_;
		GdkAppLaunchContext* _tmp14_;
		GdkAppLaunchContext* _tmp15_;
#line 275 "../../../src/core/common-actions.vala"
		_tmp7_ = f;
#line 275 "../../../src/core/common-actions.vala"
		_tmp8_ = g_file_query_default_handler (_tmp7_, NULL, &_inner_error0_);
#line 275 "../../../src/core/common-actions.vala"
		app_info = _tmp8_;
#line 275 "../../../src/core/common-actions.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2747 "common-actions.c"
			goto __catch0_g_error;
		}
#line 276 "../../../src/core/common-actions.vala"
		files = NULL;
#line 277 "../../../src/core/common-actions.vala"
		_tmp9_ = f;
#line 277 "../../../src/core/common-actions.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 277 "../../../src/core/common-actions.vala"
		files = g_list_prepend (files, _tmp10_);
#line 278 "../../../src/core/common-actions.vala"
		_tmp11_ = app_info;
#line 278 "../../../src/core/common-actions.vala"
		_tmp12_ = files;
#line 278 "../../../src/core/common-actions.vala"
		_tmp13_ = gdk_display_get_default ();
#line 278 "../../../src/core/common-actions.vala"
		_tmp14_ = gdk_display_get_app_launch_context (_tmp13_);
#line 278 "../../../src/core/common-actions.vala"
		_tmp15_ = _tmp14_;
#line 278 "../../../src/core/common-actions.vala"
		g_app_info_launch (_tmp11_, _tmp12_, (GAppLaunchContext*) _tmp15_, &_inner_error0_);
#line 278 "../../../src/core/common-actions.vala"
		_g_object_unref0 (_tmp15_);
#line 278 "../../../src/core/common-actions.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 278 "../../../src/core/common-actions.vala"
			(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
#line 278 "../../../src/core/common-actions.vala"
			_g_object_unref0 (app_info);
#line 2778 "common-actions.c"
			goto __catch0_g_error;
		}
#line 273 "../../../src/core/common-actions.vala"
		(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
#line 273 "../../../src/core/common-actions.vala"
		_g_object_unref0 (app_info);
#line 2785 "common-actions.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
#line 273 "../../../src/core/common-actions.vala"
		err = _inner_error0_;
#line 273 "../../../src/core/common-actions.vala"
		_inner_error0_ = NULL;
#line 282 "../../../src/core/common-actions.vala"
		_tmp16_ = err;
#line 282 "../../../src/core/common-actions.vala"
		_tmp17_ = _tmp16_->message;
#line 282 "../../../src/core/common-actions.vala"
		g_warning ("common-actions.vala:282: %s", _tmp17_);
#line 273 "../../../src/core/common-actions.vala"
		_g_error_free0 (err);
#line 2805 "common-actions.c"
	}
	__finally0:
#line 273 "../../../src/core/common-actions.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 273 "../../../src/core/common-actions.vala"
		_g_object_unref0 (f);
#line 273 "../../../src/core/common-actions.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 273 "../../../src/core/common-actions.vala"
		g_clear_error (&_inner_error0_);
#line 273 "../../../src/core/common-actions.vala"
		return;
#line 2818 "common-actions.c"
	}
#line 266 "../../../src/core/common-actions.vala"
	_g_object_unref0 (f);
#line 2822 "common-actions.c"
}

static gboolean
synapse_common_actions_open_folder_real_valid_for_match (SynapseAction* base,
                                                         SynapseMatch* match)
{
	SynapseCommonActionsOpenFolder * self;
	SynapseUriMatch* uri_match = NULL;
	SynapseUriMatch* _tmp0_;
	GFile* f = NULL;
	SynapseUriMatch* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* parent = NULL;
	GFile* _tmp5_;
	GFile* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GFile* _tmp8_;
	gboolean result = FALSE;
#line 286 "../../../src/core/common-actions.vala"
	self = (SynapseCommonActionsOpenFolder*) base;
#line 286 "../../../src/core/common-actions.vala"
	g_return_val_if_fail (match != NULL, FALSE);
#line 288 "../../../src/core/common-actions.vala"
	uri_match = SYNAPSE_IS_URI_MATCH (match) ? ((SynapseUriMatch*) match) : NULL;
#line 289 "../../../src/core/common-actions.vala"
	_tmp0_ = uri_match;
#line 289 "../../../src/core/common-actions.vala"
	if (_tmp0_ == NULL) {
#line 289 "../../../src/core/common-actions.vala"
		result = FALSE;
#line 289 "../../../src/core/common-actions.vala"
		return result;
#line 2857 "common-actions.c"
	}
#line 291 "../../../src/core/common-actions.vala"
	_tmp1_ = uri_match;
#line 291 "../../../src/core/common-actions.vala"
	_tmp2_ = synapse_uri_match_get_uri (_tmp1_);
#line 291 "../../../src/core/common-actions.vala"
	_tmp3_ = _tmp2_;
#line 291 "../../../src/core/common-actions.vala"
	_tmp4_ = g_file_new_for_uri (_tmp3_);
#line 291 "../../../src/core/common-actions.vala"
	f = _tmp4_;
#line 292 "../../../src/core/common-actions.vala"
	_tmp5_ = f;
#line 292 "../../../src/core/common-actions.vala"
	_tmp6_ = g_file_get_parent (_tmp5_);
#line 292 "../../../src/core/common-actions.vala"
	parent = _tmp6_;
#line 293 "../../../src/core/common-actions.vala"
	_tmp8_ = parent;
#line 293 "../../../src/core/common-actions.vala"
	if (_tmp8_ != NULL) {
#line 2879 "common-actions.c"
		GFile* _tmp9_;
#line 293 "../../../src/core/common-actions.vala"
		_tmp9_ = f;
#line 293 "../../../src/core/common-actions.vala"
		_tmp7_ = g_file_is_native (_tmp9_);
#line 2885 "common-actions.c"
	} else {
#line 293 "../../../src/core/common-actions.vala"
		_tmp7_ = FALSE;
#line 2889 "common-actions.c"
	}
#line 293 "../../../src/core/common-actions.vala"
	result = _tmp7_;
#line 293 "../../../src/core/common-actions.vala"
	_g_object_unref0 (parent);
#line 293 "../../../src/core/common-actions.vala"
	_g_object_unref0 (f);
#line 293 "../../../src/core/common-actions.vala"
	return result;
#line 2899 "common-actions.c"
}

static void
synapse_common_actions_open_folder_class_init (SynapseCommonActionsOpenFolderClass * klass,
                                               gpointer klass_data)
{
#line 256 "../../../src/core/common-actions.vala"
	synapse_common_actions_open_folder_parent_class = g_type_class_peek_parent (klass);
#line 256 "../../../src/core/common-actions.vala"
	((SynapseActionClass *) klass)->do_execute = (void (*) (SynapseAction*, SynapseMatch*, SynapseMatch*)) synapse_common_actions_open_folder_real_do_execute;
#line 256 "../../../src/core/common-actions.vala"
	((SynapseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseAction*, SynapseMatch*)) synapse_common_actions_open_folder_real_valid_for_match;
#line 2912 "common-actions.c"
}

static void
synapse_common_actions_open_folder_instance_init (SynapseCommonActionsOpenFolder * self,
                                                  gpointer klass)
{
}

static GType
synapse_common_actions_open_folder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsOpenFolderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_open_folder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsOpenFolder), 0, (GInstanceInitFunc) synapse_common_actions_open_folder_instance_init, NULL };
	GType synapse_common_actions_open_folder_type_id;
	synapse_common_actions_open_folder_type_id = g_type_register_static (SYNAPSE_TYPE_ACTION, "SynapseCommonActionsOpenFolder", &g_define_type_info, 0);
	return synapse_common_actions_open_folder_type_id;
}

static GType
synapse_common_actions_open_folder_get_type (void)
{
	static volatile gsize synapse_common_actions_open_folder_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_open_folder_type_id__volatile)) {
		GType synapse_common_actions_open_folder_type_id;
		synapse_common_actions_open_folder_type_id = synapse_common_actions_open_folder_get_type_once ();
		g_once_init_leave (&synapse_common_actions_open_folder_type_id__volatile, synapse_common_actions_open_folder_type_id);
	}
	return synapse_common_actions_open_folder_type_id__volatile;
}

static SynapseCommonActionsClipboardCopy*
synapse_common_actions_clipboard_copy_construct (GType object_type)
{
	SynapseCommonActionsClipboardCopy * self = NULL;
#line 301 "../../../src/core/common-actions.vala"
	self = (SynapseCommonActionsClipboardCopy*) g_object_new (object_type, "title", _ ("Copy to Clipboard"), "description", _ ("Copy selection to clipboard"), "icon-name", "gtk-copy", "has-thumbnail", FALSE, "default-relevancy", SYNAPSE_MATCH_SCORE_AVERAGE, NULL);
#line 299 "../../../src/core/common-actions.vala"
	return self;
#line 2950 "common-actions.c"
}

static SynapseCommonActionsClipboardCopy*
synapse_common_actions_clipboard_copy_new (void)
{
#line 299 "../../../src/core/common-actions.vala"
	return synapse_common_actions_clipboard_copy_construct (SYNAPSE_COMMON_ACTIONS_TYPE_CLIPBOARD_COPY);
#line 2958 "common-actions.c"
}

static void
synapse_common_actions_clipboard_copy_real_do_execute (SynapseAction* base,
                                                       SynapseMatch* match,
                                                       SynapseMatch* target)
{
	SynapseCommonActionsClipboardCopy * self;
	GtkClipboard* cb = NULL;
	GtkClipboard* _tmp0_;
	GtkClipboard* _tmp1_;
#line 307 "../../../src/core/common-actions.vala"
	self = (SynapseCommonActionsClipboardCopy*) base;
#line 307 "../../../src/core/common-actions.vala"
	g_return_if_fail (match != NULL);
#line 309 "../../../src/core/common-actions.vala"
	_tmp0_ = gtk_clipboard_get (GDK_NONE);
#line 309 "../../../src/core/common-actions.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 309 "../../../src/core/common-actions.vala"
	cb = _tmp1_;
#line 310 "../../../src/core/common-actions.vala"
	if (SYNAPSE_IS_URI_MATCH (match)) {
#line 2982 "common-actions.c"
		SynapseUriMatch* uri_match = NULL;
		GtkClipboard* _tmp2_;
		SynapseUriMatch* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
#line 312 "../../../src/core/common-actions.vala"
		uri_match = G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch);
#line 323 "../../../src/core/common-actions.vala"
		_tmp2_ = cb;
#line 323 "../../../src/core/common-actions.vala"
		_tmp3_ = uri_match;
#line 323 "../../../src/core/common-actions.vala"
		_tmp4_ = synapse_uri_match_get_uri (_tmp3_);
#line 323 "../../../src/core/common-actions.vala"
		_tmp5_ = _tmp4_;
#line 323 "../../../src/core/common-actions.vala"
		gtk_clipboard_set_text (_tmp2_, _tmp5_, -1);
#line 3000 "common-actions.c"
	} else {
#line 325 "../../../src/core/common-actions.vala"
		if (SYNAPSE_IS_TEXT_MATCH (match)) {
#line 3004 "common-actions.c"
			SynapseTextMatch* text_match = NULL;
			gchar* _tmp6_ = NULL;
			SynapseTextMatch* _tmp7_;
			gchar* content = NULL;
			gchar* _tmp13_;
			GtkClipboard* _tmp14_;
			const gchar* _tmp15_;
#line 327 "../../../src/core/common-actions.vala"
			text_match = G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatch);
#line 329 "../../../src/core/common-actions.vala"
			_tmp7_ = text_match;
#line 329 "../../../src/core/common-actions.vala"
			if (_tmp7_ != NULL) {
#line 3018 "common-actions.c"
				SynapseTextMatch* _tmp8_;
				gchar* _tmp9_;
#line 329 "../../../src/core/common-actions.vala"
				_tmp8_ = text_match;
#line 329 "../../../src/core/common-actions.vala"
				_tmp9_ = synapse_text_match_get_text (_tmp8_);
#line 329 "../../../src/core/common-actions.vala"
				_g_free0 (_tmp6_);
#line 329 "../../../src/core/common-actions.vala"
				_tmp6_ = _tmp9_;
#line 3029 "common-actions.c"
			} else {
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
#line 329 "../../../src/core/common-actions.vala"
				_tmp10_ = synapse_match_get_title (match);
#line 329 "../../../src/core/common-actions.vala"
				_tmp11_ = _tmp10_;
#line 329 "../../../src/core/common-actions.vala"
				_tmp12_ = g_strdup (_tmp11_);
#line 329 "../../../src/core/common-actions.vala"
				_g_free0 (_tmp6_);
#line 329 "../../../src/core/common-actions.vala"
				_tmp6_ = _tmp12_;
#line 3044 "common-actions.c"
			}
#line 329 "../../../src/core/common-actions.vala"
			_tmp13_ = g_strdup (_tmp6_);
#line 329 "../../../src/core/common-actions.vala"
			content = _tmp13_;
#line 331 "../../../src/core/common-actions.vala"
			_tmp14_ = cb;
#line 331 "../../../src/core/common-actions.vala"
			_tmp15_ = content;
#line 331 "../../../src/core/common-actions.vala"
			gtk_clipboard_set_text (_tmp14_, _tmp15_, -1);
#line 325 "../../../src/core/common-actions.vala"
			_g_free0 (content);
#line 325 "../../../src/core/common-actions.vala"
			_g_free0 (_tmp6_);
#line 3060 "common-actions.c"
		}
	}
#line 307 "../../../src/core/common-actions.vala"
	_g_object_unref0 (cb);
#line 3065 "common-actions.c"
}

static gboolean
synapse_common_actions_clipboard_copy_real_valid_for_match (SynapseAction* base,
                                                            SynapseMatch* match)
{
	SynapseCommonActionsClipboardCopy * self;
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
#line 335 "../../../src/core/common-actions.vala"
	self = (SynapseCommonActionsClipboardCopy*) base;
#line 335 "../../../src/core/common-actions.vala"
	g_return_val_if_fail (match != NULL, FALSE);
#line 337 "../../../src/core/common-actions.vala"
	if (SYNAPSE_IS_URI_MATCH (match)) {
#line 337 "../../../src/core/common-actions.vala"
		_tmp0_ = TRUE;
#line 3083 "common-actions.c"
	} else {
#line 337 "../../../src/core/common-actions.vala"
		_tmp0_ = SYNAPSE_IS_TEXT_MATCH (match);
#line 3087 "common-actions.c"
	}
#line 337 "../../../src/core/common-actions.vala"
	result = _tmp0_;
#line 337 "../../../src/core/common-actions.vala"
	return result;
#line 3093 "common-actions.c"
}

static gint
synapse_common_actions_clipboard_copy_real_get_relevancy_for_match (SynapseAction* base,
                                                                    SynapseMatch* match)
{
	SynapseCommonActionsClipboardCopy * self;
	SynapseTextMatch* text_match = NULL;
	gboolean _tmp0_ = FALSE;
	SynapseTextMatch* _tmp1_;
	gint _tmp5_;
	gint _tmp6_;
	gint result = 0;
#line 340 "../../../src/core/common-actions.vala"
	self = (SynapseCommonActionsClipboardCopy*) base;
#line 340 "../../../src/core/common-actions.vala"
	g_return_val_if_fail (match != NULL, 0);
#line 342 "../../../src/core/common-actions.vala"
	text_match = SYNAPSE_IS_TEXT_MATCH (match) ? ((SynapseTextMatch*) match) : NULL;
#line 343 "../../../src/core/common-actions.vala"
	_tmp1_ = text_match;
#line 343 "../../../src/core/common-actions.vala"
	if (_tmp1_ != NULL) {
#line 3117 "common-actions.c"
		SynapseTextMatch* _tmp2_;
		SynapseTextOrigin _tmp3_;
		SynapseTextOrigin _tmp4_;
#line 343 "../../../src/core/common-actions.vala"
		_tmp2_ = text_match;
#line 343 "../../../src/core/common-actions.vala"
		_tmp3_ = synapse_text_match_get_text_origin (_tmp2_);
#line 343 "../../../src/core/common-actions.vala"
		_tmp4_ = _tmp3_;
#line 343 "../../../src/core/common-actions.vala"
		_tmp0_ = _tmp4_ == SYNAPSE_TEXT_ORIGIN_CLIPBOARD;
#line 3129 "common-actions.c"
	} else {
#line 343 "../../../src/core/common-actions.vala"
		_tmp0_ = FALSE;
#line 3133 "common-actions.c"
	}
#line 343 "../../../src/core/common-actions.vala"
	if (_tmp0_) {
#line 345 "../../../src/core/common-actions.vala"
		result = 0;
#line 345 "../../../src/core/common-actions.vala"
		return result;
#line 3141 "common-actions.c"
	}
#line 348 "../../../src/core/common-actions.vala"
	_tmp5_ = synapse_action_get_default_relevancy ((SynapseAction*) self);
#line 348 "../../../src/core/common-actions.vala"
	_tmp6_ = _tmp5_;
#line 348 "../../../src/core/common-actions.vala"
	result = _tmp6_;
#line 348 "../../../src/core/common-actions.vala"
	return result;
#line 3151 "common-actions.c"
}

static void
synapse_common_actions_clipboard_copy_class_init (SynapseCommonActionsClipboardCopyClass * klass,
                                                  gpointer klass_data)
{
#line 297 "../../../src/core/common-actions.vala"
	synapse_common_actions_clipboard_copy_parent_class = g_type_class_peek_parent (klass);
#line 297 "../../../src/core/common-actions.vala"
	((SynapseActionClass *) klass)->do_execute = (void (*) (SynapseAction*, SynapseMatch*, SynapseMatch*)) synapse_common_actions_clipboard_copy_real_do_execute;
#line 297 "../../../src/core/common-actions.vala"
	((SynapseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseAction*, SynapseMatch*)) synapse_common_actions_clipboard_copy_real_valid_for_match;
#line 297 "../../../src/core/common-actions.vala"
	((SynapseActionClass *) klass)->get_relevancy_for_match = (gint (*) (SynapseAction*, SynapseMatch*)) synapse_common_actions_clipboard_copy_real_get_relevancy_for_match;
#line 3166 "common-actions.c"
}

static void
synapse_common_actions_clipboard_copy_instance_init (SynapseCommonActionsClipboardCopy * self,
                                                     gpointer klass)
{
}

static GType
synapse_common_actions_clipboard_copy_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsClipboardCopyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_clipboard_copy_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActionsClipboardCopy), 0, (GInstanceInitFunc) synapse_common_actions_clipboard_copy_instance_init, NULL };
	GType synapse_common_actions_clipboard_copy_type_id;
	synapse_common_actions_clipboard_copy_type_id = g_type_register_static (SYNAPSE_TYPE_ACTION, "SynapseCommonActionsClipboardCopy", &g_define_type_info, 0);
	return synapse_common_actions_clipboard_copy_type_id;
}

static GType
synapse_common_actions_clipboard_copy_get_type (void)
{
	static volatile gsize synapse_common_actions_clipboard_copy_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_clipboard_copy_type_id__volatile)) {
		GType synapse_common_actions_clipboard_copy_type_id;
		synapse_common_actions_clipboard_copy_type_id = synapse_common_actions_clipboard_copy_get_type_once ();
		g_once_init_leave (&synapse_common_actions_clipboard_copy_type_id__volatile, synapse_common_actions_clipboard_copy_type_id);
	}
	return synapse_common_actions_clipboard_copy_type_id__volatile;
}

static GObject *
synapse_common_actions_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseCommonActions * self;
	GeeArrayList* _tmp0_;
	GeeList* _tmp1_;
	SynapseCommonActionsRunner* _tmp2_;
	SynapseCommonActionsRunner* _tmp3_;
	GeeList* _tmp4_;
	SynapseCommonActionsTerminalRunner* _tmp5_;
	SynapseCommonActionsTerminalRunner* _tmp6_;
	GeeList* _tmp7_;
	SynapseCommonActionsOpener* _tmp8_;
	SynapseCommonActionsOpener* _tmp9_;
	GeeList* _tmp10_;
	SynapseCommonActionsOpenFolder* _tmp11_;
	SynapseCommonActionsOpenFolder* _tmp12_;
	GeeList* _tmp13_;
	SynapseCommonActionsClipboardCopy* _tmp14_;
	SynapseCommonActionsClipboardCopy* _tmp15_;
#line 354 "../../../src/core/common-actions.vala"
	parent_class = G_OBJECT_CLASS (synapse_common_actions_parent_class);
#line 354 "../../../src/core/common-actions.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 354 "../../../src/core/common-actions.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions);
#line 356 "../../../src/core/common-actions.vala"
	_tmp0_ = gee_array_list_new (SYNAPSE_TYPE_ACTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 356 "../../../src/core/common-actions.vala"
	_g_object_unref0 (self->priv->actions);
#line 356 "../../../src/core/common-actions.vala"
	self->priv->actions = (GeeList*) _tmp0_;
#line 358 "../../../src/core/common-actions.vala"
	_tmp1_ = self->priv->actions;
#line 358 "../../../src/core/common-actions.vala"
	_tmp2_ = synapse_common_actions_runner_new ();
#line 358 "../../../src/core/common-actions.vala"
	_tmp3_ = _tmp2_;
#line 358 "../../../src/core/common-actions.vala"
	gee_collection_add ((GeeCollection*) _tmp1_, (SynapseAction*) _tmp3_);
#line 358 "../../../src/core/common-actions.vala"
	_g_object_unref0 (_tmp3_);
#line 359 "../../../src/core/common-actions.vala"
	_tmp4_ = self->priv->actions;
#line 359 "../../../src/core/common-actions.vala"
	_tmp5_ = synapse_common_actions_terminal_runner_new ();
#line 359 "../../../src/core/common-actions.vala"
	_tmp6_ = _tmp5_;
#line 359 "../../../src/core/common-actions.vala"
	gee_collection_add ((GeeCollection*) _tmp4_, (SynapseAction*) _tmp6_);
#line 359 "../../../src/core/common-actions.vala"
	_g_object_unref0 (_tmp6_);
#line 360 "../../../src/core/common-actions.vala"
	_tmp7_ = self->priv->actions;
#line 360 "../../../src/core/common-actions.vala"
	_tmp8_ = synapse_common_actions_opener_new ();
#line 360 "../../../src/core/common-actions.vala"
	_tmp9_ = _tmp8_;
#line 360 "../../../src/core/common-actions.vala"
	gee_collection_add ((GeeCollection*) _tmp7_, (SynapseAction*) _tmp9_);
#line 360 "../../../src/core/common-actions.vala"
	_g_object_unref0 (_tmp9_);
#line 361 "../../../src/core/common-actions.vala"
	_tmp10_ = self->priv->actions;
#line 361 "../../../src/core/common-actions.vala"
	_tmp11_ = synapse_common_actions_open_folder_new ();
#line 361 "../../../src/core/common-actions.vala"
	_tmp12_ = _tmp11_;
#line 361 "../../../src/core/common-actions.vala"
	gee_collection_add ((GeeCollection*) _tmp10_, (SynapseAction*) _tmp12_);
#line 361 "../../../src/core/common-actions.vala"
	_g_object_unref0 (_tmp12_);
#line 362 "../../../src/core/common-actions.vala"
	_tmp13_ = self->priv->actions;
#line 362 "../../../src/core/common-actions.vala"
	_tmp14_ = synapse_common_actions_clipboard_copy_new ();
#line 362 "../../../src/core/common-actions.vala"
	_tmp15_ = _tmp14_;
#line 362 "../../../src/core/common-actions.vala"
	gee_collection_add ((GeeCollection*) _tmp13_, (SynapseAction*) _tmp15_);
#line 362 "../../../src/core/common-actions.vala"
	_g_object_unref0 (_tmp15_);
#line 354 "../../../src/core/common-actions.vala"
	return obj;
#line 3284 "common-actions.c"
}

static void
synapse_common_actions_class_init (SynapseCommonActionsClass * klass,
                                   gpointer klass_data)
{
#line 44 "../../../src/core/common-actions.vala"
	synapse_common_actions_parent_class = g_type_class_peek_parent (klass);
#line 44 "../../../src/core/common-actions.vala"
	g_type_class_adjust_private_offset (klass, &SynapseCommonActions_private_offset);
#line 44 "../../../src/core/common-actions.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_common_actions_get_property;
#line 44 "../../../src/core/common-actions.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_common_actions_set_property;
#line 44 "../../../src/core/common-actions.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_common_actions_constructor;
#line 44 "../../../src/core/common-actions.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_common_actions_finalize;
#line 44 "../../../src/core/common-actions.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY, synapse_common_actions_properties[SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3305 "common-actions.c"
}

static void
synapse_common_actions_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                           gpointer iface_data)
{
#line 44 "../../../src/core/common-actions.vala"
	synapse_common_actions_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 44 "../../../src/core/common-actions.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_common_actions_real_activate;
#line 44 "../../../src/core/common-actions.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_common_actions_real_deactivate;
#line 44 "../../../src/core/common-actions.vala"
	iface->get_enabled = synapse_common_actions_real_get_enabled;
#line 44 "../../../src/core/common-actions.vala"
	iface->set_enabled = synapse_common_actions_real_set_enabled;
#line 3322 "common-actions.c"
}

static void
synapse_common_actions_synapse_action_provider_interface_init (SynapseActionProviderIface * iface,
                                                               gpointer iface_data)
{
#line 44 "../../../src/core/common-actions.vala"
	synapse_common_actions_synapse_action_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 44 "../../../src/core/common-actions.vala"
	iface->find_for_match = (SynapseResultSet* (*) (SynapseActionProvider*, SynapseQuery*, SynapseMatch*)) synapse_common_actions_real_find_for_match;
#line 3333 "common-actions.c"
}

static void
synapse_common_actions_instance_init (SynapseCommonActions * self,
                                      gpointer klass)
{
#line 44 "../../../src/core/common-actions.vala"
	self->priv = synapse_common_actions_get_instance_private (self);
#line 46 "../../../src/core/common-actions.vala"
	self->priv->_enabled = TRUE;
#line 3344 "common-actions.c"
}

static void
synapse_common_actions_finalize (GObject * obj)
{
	SynapseCommonActions * self;
#line 44 "../../../src/core/common-actions.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions);
#line 352 "../../../src/core/common-actions.vala"
	_g_object_unref0 (self->priv->actions);
#line 44 "../../../src/core/common-actions.vala"
	G_OBJECT_CLASS (synapse_common_actions_parent_class)->finalize (obj);
#line 3357 "common-actions.c"
}

static GType
synapse_common_actions_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommonActionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_common_actions_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommonActions), 0, (GInstanceInitFunc) synapse_common_actions_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_common_actions_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_action_provider_info = { (GInterfaceInitFunc) synapse_common_actions_synapse_action_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_common_actions_type_id;
	synapse_common_actions_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseCommonActions", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_common_actions_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_common_actions_type_id, SYNAPSE_TYPE_ACTION_PROVIDER, &synapse_action_provider_info);
	SynapseCommonActions_private_offset = g_type_add_instance_private (synapse_common_actions_type_id, sizeof (SynapseCommonActionsPrivate));
	return synapse_common_actions_type_id;
}

GType
synapse_common_actions_get_type (void)
{
	static volatile gsize synapse_common_actions_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_common_actions_type_id__volatile)) {
		GType synapse_common_actions_type_id;
		synapse_common_actions_type_id = synapse_common_actions_get_type_once ();
		g_once_init_leave (&synapse_common_actions_type_id__volatile, synapse_common_actions_type_id);
	}
	return synapse_common_actions_type_id__volatile;
}

static void
_vala_synapse_common_actions_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SynapseCommonActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions);
#line 44 "../../../src/core/common-actions.vala"
	switch (property_id) {
#line 44 "../../../src/core/common-actions.vala"
		case SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY:
#line 44 "../../../src/core/common-actions.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 44 "../../../src/core/common-actions.vala"
		break;
#line 3402 "common-actions.c"
		default:
#line 44 "../../../src/core/common-actions.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 44 "../../../src/core/common-actions.vala"
		break;
#line 3408 "common-actions.c"
	}
}

static void
_vala_synapse_common_actions_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	SynapseCommonActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_COMMON_ACTIONS, SynapseCommonActions);
#line 44 "../../../src/core/common-actions.vala"
	switch (property_id) {
#line 44 "../../../src/core/common-actions.vala"
		case SYNAPSE_COMMON_ACTIONS_ENABLED_PROPERTY:
#line 44 "../../../src/core/common-actions.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 44 "../../../src/core/common-actions.vala"
		break;
#line 3428 "common-actions.c"
		default:
#line 44 "../../../src/core/common-actions.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 44 "../../../src/core/common-actions.vala"
		break;
#line 3434 "common-actions.c"
	}
}

