/* desktop-file-service.c generated by valac 0.48.17, the Vala compiler
 * generated from desktop-file-service.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *             Alberto Aldegheri <albyrock87+dev@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>
#include <gee.h>
#include <locale.h>

typedef enum  {
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME = 1 << 0,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_KDE = 1 << 1,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_LXDE = 1 << 2,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_MATE = 1 << 3,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_RAZOR = 1 << 4,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_ROX = 1 << 5,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_TDE = 1 << 6,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_UNITY = 1 << 7,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_XFCE = 1 << 8,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_EDE = 1 << 9,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_CINNAMON = 1 << 10,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_PANTHEON = 1 << 11,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_OLD = 1 << 12,
	SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_ALL = 0xFFF
} SynapseDesktopEnvironmentType;

#define SYNAPSE_TYPE_DESKTOP_ENVIRONMENT_TYPE (synapse_desktop_environment_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define SYNAPSE_TYPE_DESKTOP_FILE_INFO (synapse_desktop_file_info_get_type ())
#define SYNAPSE_DESKTOP_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo))
#define SYNAPSE_DESKTOP_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfoClass))
#define SYNAPSE_IS_DESKTOP_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO))
#define SYNAPSE_IS_DESKTOP_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_INFO))
#define SYNAPSE_DESKTOP_FILE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfoClass))

typedef struct _SynapseDesktopFileInfo SynapseDesktopFileInfo;
typedef struct _SynapseDesktopFileInfoClass SynapseDesktopFileInfoClass;
typedef struct _SynapseDesktopFileInfoPrivate SynapseDesktopFileInfoPrivate;
enum  {
	SYNAPSE_DESKTOP_FILE_INFO_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SYNAPSE_TYPE_DESKTOP_FILE_SERVICE (synapse_desktop_file_service_get_type ())
#define SYNAPSE_DESKTOP_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileService))
#define SYNAPSE_DESKTOP_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileServiceClass))
#define SYNAPSE_IS_DESKTOP_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE))
#define SYNAPSE_IS_DESKTOP_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE))
#define SYNAPSE_DESKTOP_FILE_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileServiceClass))

typedef struct _SynapseDesktopFileService SynapseDesktopFileService;
typedef struct _SynapseDesktopFileServiceClass SynapseDesktopFileServiceClass;
typedef struct _SynapseDesktopFileServicePrivate SynapseDesktopFileServicePrivate;

#define SYNAPSE_UTILS_TYPE_ASYNC_ONCE (synapse_utils_async_once_get_type ())
#define SYNAPSE_UTILS_ASYNC_ONCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnce))
#define SYNAPSE_UTILS_ASYNC_ONCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnceClass))
#define SYNAPSE_UTILS_IS_ASYNC_ONCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_UTILS_TYPE_ASYNC_ONCE))
#define SYNAPSE_UTILS_IS_ASYNC_ONCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_UTILS_TYPE_ASYNC_ONCE))
#define SYNAPSE_UTILS_ASYNC_ONCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnceClass))

typedef struct _SynapseUtilsAsyncOnce SynapseUtilsAsyncOnce;
typedef struct _SynapseUtilsAsyncOnceClass SynapseUtilsAsyncOnceClass;
enum  {
	SYNAPSE_DESKTOP_FILE_SERVICE_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_SERVICE_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_service_properties[SYNAPSE_DESKTOP_FILE_SERVICE_NUM_PROPERTIES];
#define _synapse_utils_async_once_unref0(var) ((var == NULL) ? NULL : (var = (synapse_utils_async_once_unref (var), NULL)))
typedef struct _SynapseDesktopFileServiceInitializeData SynapseDesktopFileServiceInitializeData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _SynapseDesktopFileServiceProcessDirectoryData SynapseDesktopFileServiceProcessDirectoryData;
typedef struct _SynapseDesktopFileServiceLoadAllDesktopFilesData SynapseDesktopFileServiceLoadAllDesktopFilesData;
typedef struct _SynapseDesktopFileServiceReloadDesktopFilesData SynapseDesktopFileServiceReloadDesktopFilesData;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
typedef struct _SynapseDesktopFileServiceLoadDesktopFileData SynapseDesktopFileServiceLoadDesktopFileData;
typedef struct _SynapseDesktopFileServiceLoadMimeParentsFromFileData SynapseDesktopFileServiceLoadMimeParentsFromFileData;
enum  {
	SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_STARTED_SIGNAL,
	SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_DONE_SIGNAL,
	SYNAPSE_DESKTOP_FILE_SERVICE_NUM_SIGNALS
};
static guint synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_NUM_SIGNALS] = {0};

typedef enum  {
	SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY
} SynapseDesktopFileError;
#define SYNAPSE_DESKTOP_FILE_ERROR synapse_desktop_file_error_quark ()
struct _SynapseDesktopFileInfo {
	GObject parent_instance;
	SynapseDesktopFileInfoPrivate * priv;
	gchar** actions;
	gint actions_length1;
	gchar** mime_types;
	gint mime_types_length1;
};

struct _SynapseDesktopFileInfoClass {
	GObjectClass parent_class;
};

struct _SynapseDesktopFileInfoPrivate {
	gchar* _desktop_id;
	gchar* _name;
	gchar* _comment;
	gchar* _icon_name;
	gboolean _needs_terminal;
	gchar* _filename;
	gchar* _exec;
	gboolean _is_hidden;
	gboolean _is_valid;
	gchar* name_folded;
	SynapseDesktopEnvironmentType _show_in;
};

struct _SynapseDesktopFileService {
	GObject parent_instance;
	SynapseDesktopFileServicePrivate * priv;
};

struct _SynapseDesktopFileServiceClass {
	GObjectClass parent_class;
};

struct _SynapseDesktopFileServicePrivate {
	SynapseUtilsAsyncOnce* init_once;
	GeeList* directory_monitors;
	GeeList* all_desktop_files;
	GeeList* non_hidden_desktop_files;
	GeeMap* mimetype_map;
	GeeMap* exec_map;
	GeeMap* desktop_id_map;
	GeeMultiMap* mimetype_parent_map;
	SynapseDesktopEnvironmentType session_type;
	const gchar* session_type_str;
	guint timer_id;
};

struct _SynapseDesktopFileServiceInitializeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFileService* self;
	SynapseUtilsAsyncOnce* _tmp0_;
	gboolean is_locked;
	SynapseUtilsAsyncOnce* _tmp1_;
	const gchar* _tmp2_;
	SynapseUtilsAsyncOnce* _tmp3_;
};

struct _SynapseDesktopFileServiceProcessDirectoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFileService* self;
	GFile* directory;
	gchar* id_prefix;
	GeeSet* monitored_dirs;
	gchar* path;
	gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean exists;
	GeeIterator* _scanned_dir_it;
	GeeIterator* _tmp8_;
	GeeIterator* _tmp9_;
	GFile* scanned_dir;
	GeeIterator* _tmp10_;
	gpointer _tmp11_;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gboolean _tmp16_;
	GFileEnumerator* enumerator;
	GFileEnumerator* _tmp17_;
	GList* files;
	GFileEnumerator* _tmp18_;
	GList* _tmp19_;
	GList* _tmp20_;
	GList* f_collection;
	GList* f_it;
	GFileInfo* _tmp21_;
	GFileInfo* f;
	const gchar* name;
	GFileInfo* _tmp22_;
	const gchar* _tmp23_;
	GFileInfo* _tmp24_;
	GFile* subdir;
	const gchar* _tmp25_;
	GFile* _tmp26_;
	gchar* new_prefix;
	GFile* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GFile* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	GFile* _tmp37_;
	GFile* _tmp38_;
	GError* err;
	GError* _tmp39_;
	const gchar* _tmp40_;
	GError* _inner_error0_;
};

struct _SynapseDesktopFileServiceLoadAllDesktopFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFileService* self;
	gchar** data_dirs;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint data_dirs_length1;
	gint _data_dirs_size_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GeeSet* desktop_file_dirs;
	GeeHashSet* _tmp5_;
	GeeMultiMap* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** data_dir_collection;
	gint data_dir_collection_length1;
	gint _data_dir_collection_size_;
	gint data_dir_it;
	const gchar* data_dir;
	gchar* dir_path;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GFile* directory;
	const gchar* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GeeSet* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	GeeArrayList* _tmp17_;
	GeeIterator* _d_it;
	GeeSet* _tmp18_;
	GeeIterator* _tmp19_;
	GeeIterator* _tmp20_;
	GFile* d;
	GeeIterator* _tmp21_;
	gpointer _tmp22_;
	GFileMonitor* monitor;
	GFile* _tmp23_;
	GFileMonitor* _tmp24_;
	GFileMonitor* _tmp25_;
	GeeList* _tmp26_;
	GFileMonitor* _tmp27_;
	GError* err;
	GError* _tmp28_;
	const gchar* _tmp29_;
	GError* _inner_error0_;
};

struct _SynapseDesktopFileServiceReloadDesktopFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFileService* self;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
};

struct _SynapseDesktopFileServiceLoadDesktopFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFileService* self;
	GFile* file;
	gchar* id_prefix;
	guint8* file_contents;
	gint file_contents_length1;
	gint _file_contents_size_;
	gboolean success;
	guint8* _tmp0_;
	gsize _tmp1_;
	gboolean _tmp2_;
	GKeyFile* keyfile;
	GKeyFile* _tmp3_;
	GKeyFile* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* _tmp6_;
	gint _tmp6__length1;
	gchar* desktop_id;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	SynapseDesktopFileInfo* dfi;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GKeyFile* _tmp13_;
	const gchar* _tmp14_;
	SynapseDesktopFileInfo* _tmp15_;
	SynapseDesktopFileInfo* _tmp16_;
	SynapseDesktopFileInfo* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	GeeList* _tmp20_;
	SynapseDesktopFileInfo* _tmp21_;
	gboolean _tmp22_;
	SynapseDesktopFileInfo* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	SynapseDesktopEnvironmentType _tmp26_;
	SynapseDesktopFileInfo* _tmp27_;
	SynapseDesktopEnvironmentType _tmp28_;
	SynapseDesktopEnvironmentType _tmp29_;
	GeeList* _tmp30_;
	SynapseDesktopFileInfo* _tmp31_;
	GError* err;
	GError* _tmp32_;
	const gchar* _tmp33_;
	GError* _inner_error0_;
};

struct _SynapseDesktopFileServiceLoadMimeParentsFromFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFileService* self;
	gchar* fi;
	GFile* file;
	GFile* _tmp0_;
	gboolean exists;
	GFile* _tmp1_;
	GFileInputStream* fis;
	GFile* _tmp2_;
	GFileInputStream* _tmp3_;
	GDataInputStream* dis;
	GFileInputStream* _tmp4_;
	GDataInputStream* _tmp5_;
	gchar* line;
	gchar** mimes;
	gint mimes_length1;
	gint _mimes_size_;
	gint len;
	gchar* _tmp6_;
	GDataInputStream* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	GeeMultiMap* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	const gchar* _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_;
	GError* _inner_error0_;
};

static gint SynapseDesktopFileInfo_private_offset;
static gpointer synapse_desktop_file_info_parent_class = NULL;
static gint SynapseDesktopFileService_private_offset;
static gpointer synapse_desktop_file_service_parent_class = NULL;
static SynapseDesktopFileService* synapse_desktop_file_service_instance;
static SynapseDesktopFileService* synapse_desktop_file_service_instance = NULL;

GQuark synapse_desktop_file_error_quark (void);
GType synapse_desktop_environment_type_get_type (void) G_GNUC_CONST;
SynapseDesktopEnvironmentType synapse_desktop_environment_type_from_strings (gchar** environments,
                                                                             gint environments_length1);
GType synapse_desktop_file_info_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDesktopFileInfo, g_object_unref)
const gchar* synapse_desktop_file_info_get_name_folded (SynapseDesktopFileInfo* self);
const gchar* synapse_desktop_file_info_get_name (SynapseDesktopFileInfo* self);
SynapseDesktopFileInfo* synapse_desktop_file_info_new_for_keyfile (const gchar* path,
                                                                   GKeyFile* keyfile,
                                                                   const gchar* desktop_id);
SynapseDesktopFileInfo* synapse_desktop_file_info_construct_for_keyfile (GType object_type,
                                                                         const gchar* path,
                                                                         GKeyFile* keyfile,
                                                                         const gchar* desktop_id);
static void synapse_desktop_file_info_init_from_keyfile (SynapseDesktopFileInfo* self,
                                                  GKeyFile* keyfile);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gint stack_length,
                                      const gchar* needle);
const gchar* synapse_desktop_file_info_get_filename (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_name (SynapseDesktopFileInfo* self,
                                         const gchar* value);
void synapse_desktop_file_info_set_exec (SynapseDesktopFileInfo* self,
                                         const gchar* value);
const gchar* synapse_desktop_file_info_get_exec (SynapseDesktopFileInfo* self);
static void synapse_desktop_file_info_set_is_hidden (SynapseDesktopFileInfo* self,
                                              gboolean value);
void synapse_desktop_file_info_set_comment (SynapseDesktopFileInfo* self,
                                            const gchar* value);
void synapse_desktop_file_info_set_icon_name (SynapseDesktopFileInfo* self,
                                              const gchar* value);
void synapse_desktop_file_info_set_needs_terminal (SynapseDesktopFileInfo* self,
                                                   gboolean value);
void synapse_desktop_file_info_set_show_in (SynapseDesktopFileInfo* self,
                                            SynapseDesktopEnvironmentType value);
static void synapse_desktop_file_info_set_is_valid (SynapseDesktopFileInfo* self,
                                             gboolean value);
SynapseDesktopFileInfo* synapse_desktop_file_info_new (void);
SynapseDesktopFileInfo* synapse_desktop_file_info_construct (GType object_type);
const gchar* synapse_desktop_file_info_get_desktop_id (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_desktop_id (SynapseDesktopFileInfo* self,
                                               const gchar* value);
const gchar* synapse_desktop_file_info_get_comment (SynapseDesktopFileInfo* self);
const gchar* synapse_desktop_file_info_get_icon_name (SynapseDesktopFileInfo* self);
gboolean synapse_desktop_file_info_get_needs_terminal (SynapseDesktopFileInfo* self);
void synapse_desktop_file_info_set_filename (SynapseDesktopFileInfo* self,
                                             const gchar* value);
gboolean synapse_desktop_file_info_get_is_hidden (SynapseDesktopFileInfo* self);
gboolean synapse_desktop_file_info_get_is_valid (SynapseDesktopFileInfo* self);
SynapseDesktopEnvironmentType synapse_desktop_file_info_get_show_in (SynapseDesktopFileInfo* self);
static void synapse_desktop_file_info_finalize (GObject * obj);
static GType synapse_desktop_file_info_get_type_once (void);
static void _vala_synapse_desktop_file_info_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_synapse_desktop_file_info_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
GType synapse_desktop_file_service_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDesktopFileService, g_object_unref)
gpointer synapse_utils_async_once_ref (gpointer instance);
void synapse_utils_async_once_unref (gpointer instance);
GParamSpec* synapse_utils_param_spec_async_once (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags);
void synapse_utils_value_set_async_once (GValue* value,
                                         gpointer v_object);
void synapse_utils_value_take_async_once (GValue* value,
                                          gpointer v_object);
gpointer synapse_utils_value_get_async_once (const GValue* value);
GType synapse_utils_async_once_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseUtilsAsyncOnce, synapse_utils_async_once_unref)
SynapseDesktopFileService* synapse_desktop_file_service_get_default (void);
static SynapseDesktopFileService* synapse_desktop_file_service_new (void);
static SynapseDesktopFileService* synapse_desktop_file_service_construct (GType object_type);
static void synapse_desktop_file_service_initialize_data_free (gpointer _data);
void synapse_desktop_file_service_initialize (SynapseDesktopFileService* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
void synapse_desktop_file_service_initialize_finish (SynapseDesktopFileService* self,
                                                     GAsyncResult* _res_);
static gboolean synapse_desktop_file_service_initialize_co (SynapseDesktopFileServiceInitializeData* _data_);
gboolean synapse_utils_async_once_is_initialized (SynapseUtilsAsyncOnce* self);
void synapse_utils_async_once_enter (SynapseUtilsAsyncOnce* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
gboolean synapse_utils_async_once_enter_finish (SynapseUtilsAsyncOnce* self,
                                                GAsyncResult* _res_);
static void synapse_desktop_file_service_initialize_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void synapse_desktop_file_service_get_environment_type (SynapseDesktopFileService* self);
static gboolean _synapse_desktop_file_service_initialize_co_gsource_func (gpointer self);
static void synapse_desktop_file_service_load_all_desktop_files (SynapseDesktopFileService* self,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
static void synapse_desktop_file_service_load_all_desktop_files_finish (SynapseDesktopFileService* self,
                                                                 GAsyncResult* _res_);
void synapse_utils_async_once_leave (SynapseUtilsAsyncOnce* self,
                                     gconstpointer _result_);
SynapseDesktopEnvironmentType synapse_desktop_file_service_get_environment (SynapseDesktopFileService* self);
static gchar* synapse_desktop_file_service_get_cache_file_name (SynapseDesktopFileService* self,
                                                         const gchar* dir_name);
static void synapse_desktop_file_service_process_directory_data_free (gpointer _data);
static void synapse_desktop_file_service_process_directory (SynapseDesktopFileService* self,
                                                     GFile* directory,
                                                     const gchar* id_prefix,
                                                     GeeSet* monitored_dirs,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static void synapse_desktop_file_service_process_directory_finish (SynapseDesktopFileService* self,
                                                            GAsyncResult* _res_);
static gboolean synapse_desktop_file_service_process_directory_co (SynapseDesktopFileServiceProcessDirectoryData* _data_);
void synapse_utils_query_exists_async (GFile* f,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
gboolean synapse_utils_query_exists_finish (GAsyncResult* _res_);
static void synapse_desktop_file_service_process_directory_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void synapse_desktop_file_service_load_desktop_file (SynapseDesktopFileService* self,
                                                     GFile* file,
                                                     const gchar* id_prefix,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static void synapse_desktop_file_service_load_desktop_file_finish (SynapseDesktopFileService* self,
                                                            GAsyncResult* _res_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void synapse_desktop_file_service_load_all_desktop_files_data_free (gpointer _data);
static gboolean synapse_desktop_file_service_load_all_desktop_files_co (SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_);
static gchar** _vala_array_dup2 (gchar** self,
                          gint length);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void synapse_desktop_file_service_load_all_desktop_files_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_);
static void synapse_desktop_file_service_load_mime_parents_from_file (SynapseDesktopFileService* self,
                                                               const gchar* fi,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_);
static void synapse_desktop_file_service_load_mime_parents_from_file_finish (SynapseDesktopFileService* self,
                                                                      GAsyncResult* _res_);
static void synapse_desktop_file_service_create_indices (SynapseDesktopFileService* self);
static void synapse_desktop_file_service_desktop_file_directory_changed (SynapseDesktopFileService* self);
static void _synapse_desktop_file_service_desktop_file_directory_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                                          GFile* file,
                                                                                          GFile* other_file,
                                                                                          GFileMonitorEvent event_type,
                                                                                          gpointer self);
static gboolean __lambda8_ (SynapseDesktopFileService* self);
static void synapse_desktop_file_service_reload_desktop_files (SynapseDesktopFileService* self,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
static void synapse_desktop_file_service_reload_desktop_files_finish (SynapseDesktopFileService* self,
                                                               GAsyncResult* _res_);
static gboolean ___lambda8__gsource_func (gpointer self);
static void synapse_desktop_file_service_reload_desktop_files_data_free (gpointer _data);
static gboolean synapse_desktop_file_service_reload_desktop_files_co (SynapseDesktopFileServiceReloadDesktopFilesData* _data_);
static void synapse_desktop_file_service_reload_desktop_files_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
static void synapse_desktop_file_service_load_desktop_file_data_free (gpointer _data);
static gboolean synapse_desktop_file_service_load_desktop_file_co (SynapseDesktopFileServiceLoadDesktopFileData* _data_);
static void synapse_desktop_file_service_load_desktop_file_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void synapse_desktop_file_service_load_mime_parents_from_file_data_free (gpointer _data);
static gboolean synapse_desktop_file_service_load_mime_parents_from_file_co (SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_);
static void synapse_desktop_file_service_load_mime_parents_from_file_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_);
static void synapse_desktop_file_service_add_dfi_for_mime (SynapseDesktopFileService* self,
                                                    const gchar* mime,
                                                    GeeSet* ret);
GeeList* synapse_desktop_file_service_get_desktop_files (SynapseDesktopFileService* self);
GeeList* synapse_desktop_file_service_get_all_desktop_files (SynapseDesktopFileService* self);
GeeList* synapse_desktop_file_service_get_desktop_files_for_type (SynapseDesktopFileService* self,
                                                                  const gchar* mime_type);
GeeList* synapse_desktop_file_service_get_desktop_files_for_exec (SynapseDesktopFileService* self,
                                                                  const gchar* exec);
SynapseDesktopFileInfo* synapse_desktop_file_service_get_desktop_file_for_id (SynapseDesktopFileService* self,
                                                                              const gchar* desktop_id);
static GObject * synapse_desktop_file_service_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
SynapseUtilsAsyncOnce* synapse_utils_async_once_new (GType g_type,
                                                     GBoxedCopyFunc g_dup_func,
                                                     GDestroyNotify g_destroy_func);
SynapseUtilsAsyncOnce* synapse_utils_async_once_construct (GType object_type,
                                                           GType g_type,
                                                           GBoxedCopyFunc g_dup_func,
                                                           GDestroyNotify g_destroy_func);
static void synapse_desktop_file_service_finalize (GObject * obj);
static GType synapse_desktop_file_service_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

GQuark
synapse_desktop_file_error_quark (void)
{
#line 239 "../../../src/core/data-sink.vala"
	return g_quark_from_static_string ("synapse-desktop-file-error-quark");
#line 650 "desktop-file-service.c"
}

SynapseDesktopEnvironmentType
synapse_desktop_environment_type_from_strings (gchar** environments,
                                               gint environments_length1)
{
	SynapseDesktopEnvironmentType _result_ = 0U;
	SynapseDesktopEnvironmentType result = 0U;
#line 51 "../../../src/core/desktop-file-service.vala"
	_result_ = 0;
#line 661 "desktop-file-service.c"
	{
		gchar** env_collection = NULL;
		gint env_collection_length1 = 0;
		gint _env_collection_size_ = 0;
		gint env_it = 0;
#line 52 "../../../src/core/desktop-file-service.vala"
		env_collection = environments;
#line 52 "../../../src/core/desktop-file-service.vala"
		env_collection_length1 = environments_length1;
#line 52 "../../../src/core/desktop-file-service.vala"
		for (env_it = 0; env_it < env_collection_length1; env_it = env_it + 1) {
#line 673 "desktop-file-service.c"
			const gchar* env = NULL;
#line 52 "../../../src/core/desktop-file-service.vala"
			env = env_collection[env_it];
#line 677 "desktop-file-service.c"
			{
				gchar* env_up = NULL;
				const gchar* _tmp0_;
				gchar* _tmp1_;
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				GQuark _tmp5_ = 0U;
#line 55 "../../../src/core/desktop-file-service.vala"
				static GQuark _tmp4_label0 = 0;
#line 55 "../../../src/core/desktop-file-service.vala"
				static GQuark _tmp4_label1 = 0;
#line 55 "../../../src/core/desktop-file-service.vala"
				static GQuark _tmp4_label2 = 0;
#line 55 "../../../src/core/desktop-file-service.vala"
				static GQuark _tmp4_label3 = 0;
#line 55 "../../../src/core/desktop-file-service.vala"
				static GQuark _tmp4_label4 = 0;
#line 55 "../../../src/core/desktop-file-service.vala"
				static GQuark _tmp4_label5 = 0;
#line 55 "../../../src/core/desktop-file-service.vala"
				static GQuark _tmp4_label6 = 0;
#line 55 "../../../src/core/desktop-file-service.vala"
				static GQuark _tmp4_label7 = 0;
#line 55 "../../../src/core/desktop-file-service.vala"
				static GQuark _tmp4_label8 = 0;
#line 55 "../../../src/core/desktop-file-service.vala"
				static GQuark _tmp4_label9 = 0;
#line 55 "../../../src/core/desktop-file-service.vala"
				static GQuark _tmp4_label10 = 0;
#line 55 "../../../src/core/desktop-file-service.vala"
				static GQuark _tmp4_label11 = 0;
#line 55 "../../../src/core/desktop-file-service.vala"
				static GQuark _tmp4_label12 = 0;
#line 55 "../../../src/core/desktop-file-service.vala"
				static GQuark _tmp4_label13 = 0;
#line 55 "../../../src/core/desktop-file-service.vala"
				static GQuark _tmp4_label14 = 0;
#line 55 "../../../src/core/desktop-file-service.vala"
				static GQuark _tmp4_label15 = 0;
#line 55 "../../../src/core/desktop-file-service.vala"
				static GQuark _tmp4_label16 = 0;
#line 54 "../../../src/core/desktop-file-service.vala"
				_tmp0_ = env;
#line 54 "../../../src/core/desktop-file-service.vala"
				_tmp1_ = g_utf8_strup (_tmp0_, (gssize) -1);
#line 54 "../../../src/core/desktop-file-service.vala"
				env_up = _tmp1_;
#line 55 "../../../src/core/desktop-file-service.vala"
				_tmp2_ = env_up;
#line 55 "../../../src/core/desktop-file-service.vala"
				_tmp3_ = _tmp2_;
#line 55 "../../../src/core/desktop-file-service.vala"
				_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
#line 55 "../../../src/core/desktop-file-service.vala"
				if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("GNOME")))) {
#line 55 "../../../src/core/desktop-file-service.vala"
					switch (0) {
#line 735 "desktop-file-service.c"
						default:
						{
							SynapseDesktopEnvironmentType _tmp6_;
#line 57 "../../../src/core/desktop-file-service.vala"
							_tmp6_ = _result_;
#line 57 "../../../src/core/desktop-file-service.vala"
							_result_ = _tmp6_ | SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME;
#line 57 "../../../src/core/desktop-file-service.vala"
							break;
#line 745 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("GNOME-FLASHBACK")))) {
#line 55 "../../../src/core/desktop-file-service.vala"
					switch (0) {
#line 751 "desktop-file-service.c"
						default:
						{
							SynapseDesktopEnvironmentType _tmp7_;
#line 58 "../../../src/core/desktop-file-service.vala"
							_tmp7_ = _result_;
#line 58 "../../../src/core/desktop-file-service.vala"
							_result_ = _tmp7_ | SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME;
#line 58 "../../../src/core/desktop-file-service.vala"
							break;
#line 761 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("GNOME-XORG")))) {
#line 55 "../../../src/core/desktop-file-service.vala"
					switch (0) {
#line 767 "desktop-file-service.c"
						default:
						{
							SynapseDesktopEnvironmentType _tmp8_;
#line 59 "../../../src/core/desktop-file-service.vala"
							_tmp8_ = _result_;
#line 59 "../../../src/core/desktop-file-service.vala"
							_result_ = _tmp8_ | SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME;
#line 59 "../../../src/core/desktop-file-service.vala"
							break;
#line 777 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label3) ? _tmp4_label3 : (_tmp4_label3 = g_quark_from_static_string ("UBUNTU")))) {
#line 55 "../../../src/core/desktop-file-service.vala"
					switch (0) {
#line 783 "desktop-file-service.c"
						default:
						{
							SynapseDesktopEnvironmentType _tmp9_;
#line 60 "../../../src/core/desktop-file-service.vala"
							_tmp9_ = _result_;
#line 60 "../../../src/core/desktop-file-service.vala"
							_result_ = _tmp9_ | SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME;
#line 60 "../../../src/core/desktop-file-service.vala"
							break;
#line 793 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label4) ? _tmp4_label4 : (_tmp4_label4 = g_quark_from_static_string ("UBUNTU-XORG")))) {
#line 55 "../../../src/core/desktop-file-service.vala"
					switch (0) {
#line 799 "desktop-file-service.c"
						default:
						{
							SynapseDesktopEnvironmentType _tmp10_;
#line 61 "../../../src/core/desktop-file-service.vala"
							_tmp10_ = _result_;
#line 61 "../../../src/core/desktop-file-service.vala"
							_result_ = _tmp10_ | SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME;
#line 61 "../../../src/core/desktop-file-service.vala"
							break;
#line 809 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label5) ? _tmp4_label5 : (_tmp4_label5 = g_quark_from_static_string ("KDE")))) {
#line 55 "../../../src/core/desktop-file-service.vala"
					switch (0) {
#line 815 "desktop-file-service.c"
						default:
						{
							SynapseDesktopEnvironmentType _tmp11_;
#line 62 "../../../src/core/desktop-file-service.vala"
							_tmp11_ = _result_;
#line 62 "../../../src/core/desktop-file-service.vala"
							_result_ = _tmp11_ | SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_KDE;
#line 62 "../../../src/core/desktop-file-service.vala"
							break;
#line 825 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label6) ? _tmp4_label6 : (_tmp4_label6 = g_quark_from_static_string ("LXDE")))) {
#line 55 "../../../src/core/desktop-file-service.vala"
					switch (0) {
#line 831 "desktop-file-service.c"
						default:
						{
							SynapseDesktopEnvironmentType _tmp12_;
#line 63 "../../../src/core/desktop-file-service.vala"
							_tmp12_ = _result_;
#line 63 "../../../src/core/desktop-file-service.vala"
							_result_ = _tmp12_ | SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_LXDE;
#line 63 "../../../src/core/desktop-file-service.vala"
							break;
#line 841 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label7) ? _tmp4_label7 : (_tmp4_label7 = g_quark_from_static_string ("MATE")))) {
#line 55 "../../../src/core/desktop-file-service.vala"
					switch (0) {
#line 847 "desktop-file-service.c"
						default:
						{
							SynapseDesktopEnvironmentType _tmp13_;
#line 64 "../../../src/core/desktop-file-service.vala"
							_tmp13_ = _result_;
#line 64 "../../../src/core/desktop-file-service.vala"
							_result_ = _tmp13_ | SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_MATE;
#line 64 "../../../src/core/desktop-file-service.vala"
							break;
#line 857 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label8) ? _tmp4_label8 : (_tmp4_label8 = g_quark_from_static_string ("RAZOR")))) {
#line 55 "../../../src/core/desktop-file-service.vala"
					switch (0) {
#line 863 "desktop-file-service.c"
						default:
						{
							SynapseDesktopEnvironmentType _tmp14_;
#line 65 "../../../src/core/desktop-file-service.vala"
							_tmp14_ = _result_;
#line 65 "../../../src/core/desktop-file-service.vala"
							_result_ = _tmp14_ | SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_RAZOR;
#line 65 "../../../src/core/desktop-file-service.vala"
							break;
#line 873 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label9) ? _tmp4_label9 : (_tmp4_label9 = g_quark_from_static_string ("ROX")))) {
#line 55 "../../../src/core/desktop-file-service.vala"
					switch (0) {
#line 879 "desktop-file-service.c"
						default:
						{
							SynapseDesktopEnvironmentType _tmp15_;
#line 66 "../../../src/core/desktop-file-service.vala"
							_tmp15_ = _result_;
#line 66 "../../../src/core/desktop-file-service.vala"
							_result_ = _tmp15_ | SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_ROX;
#line 66 "../../../src/core/desktop-file-service.vala"
							break;
#line 889 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label10) ? _tmp4_label10 : (_tmp4_label10 = g_quark_from_static_string ("TDE")))) {
#line 55 "../../../src/core/desktop-file-service.vala"
					switch (0) {
#line 895 "desktop-file-service.c"
						default:
						{
							SynapseDesktopEnvironmentType _tmp16_;
#line 67 "../../../src/core/desktop-file-service.vala"
							_tmp16_ = _result_;
#line 67 "../../../src/core/desktop-file-service.vala"
							_result_ = _tmp16_ | SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_TDE;
#line 67 "../../../src/core/desktop-file-service.vala"
							break;
#line 905 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label11) ? _tmp4_label11 : (_tmp4_label11 = g_quark_from_static_string ("UNITY")))) {
#line 55 "../../../src/core/desktop-file-service.vala"
					switch (0) {
#line 911 "desktop-file-service.c"
						default:
						{
							SynapseDesktopEnvironmentType _tmp17_;
#line 68 "../../../src/core/desktop-file-service.vala"
							_tmp17_ = _result_;
#line 68 "../../../src/core/desktop-file-service.vala"
							_result_ = _tmp17_ | SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_UNITY;
#line 68 "../../../src/core/desktop-file-service.vala"
							break;
#line 921 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label12) ? _tmp4_label12 : (_tmp4_label12 = g_quark_from_static_string ("XFCE")))) {
#line 55 "../../../src/core/desktop-file-service.vala"
					switch (0) {
#line 927 "desktop-file-service.c"
						default:
						{
							SynapseDesktopEnvironmentType _tmp18_;
#line 69 "../../../src/core/desktop-file-service.vala"
							_tmp18_ = _result_;
#line 69 "../../../src/core/desktop-file-service.vala"
							_result_ = _tmp18_ | SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_XFCE;
#line 69 "../../../src/core/desktop-file-service.vala"
							break;
#line 937 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label13) ? _tmp4_label13 : (_tmp4_label13 = g_quark_from_static_string ("EDE")))) {
#line 55 "../../../src/core/desktop-file-service.vala"
					switch (0) {
#line 943 "desktop-file-service.c"
						default:
						{
							SynapseDesktopEnvironmentType _tmp19_;
#line 70 "../../../src/core/desktop-file-service.vala"
							_tmp19_ = _result_;
#line 70 "../../../src/core/desktop-file-service.vala"
							_result_ = _tmp19_ | SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_EDE;
#line 70 "../../../src/core/desktop-file-service.vala"
							break;
#line 953 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label14) ? _tmp4_label14 : (_tmp4_label14 = g_quark_from_static_string ("CINNAMON")))) {
#line 55 "../../../src/core/desktop-file-service.vala"
					switch (0) {
#line 959 "desktop-file-service.c"
						default:
						{
							SynapseDesktopEnvironmentType _tmp20_;
#line 71 "../../../src/core/desktop-file-service.vala"
							_tmp20_ = _result_;
#line 71 "../../../src/core/desktop-file-service.vala"
							_result_ = _tmp20_ | SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_CINNAMON;
#line 71 "../../../src/core/desktop-file-service.vala"
							break;
#line 969 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label15) ? _tmp4_label15 : (_tmp4_label15 = g_quark_from_static_string ("OLD")))) {
#line 55 "../../../src/core/desktop-file-service.vala"
					switch (0) {
#line 975 "desktop-file-service.c"
						default:
						{
							SynapseDesktopEnvironmentType _tmp21_;
#line 72 "../../../src/core/desktop-file-service.vala"
							_tmp21_ = _result_;
#line 72 "../../../src/core/desktop-file-service.vala"
							_result_ = _tmp21_ | SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_OLD;
#line 72 "../../../src/core/desktop-file-service.vala"
							break;
#line 985 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label16) ? _tmp4_label16 : (_tmp4_label16 = g_quark_from_static_string ("PANTHEON")))) {
#line 55 "../../../src/core/desktop-file-service.vala"
					switch (0) {
#line 991 "desktop-file-service.c"
						default:
						{
							SynapseDesktopEnvironmentType _tmp22_;
#line 74 "../../../src/core/desktop-file-service.vala"
							_tmp22_ = _result_;
#line 74 "../../../src/core/desktop-file-service.vala"
							_result_ = _tmp22_ | SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_PANTHEON;
#line 74 "../../../src/core/desktop-file-service.vala"
							break;
#line 1001 "desktop-file-service.c"
						}
					}
				} else {
#line 55 "../../../src/core/desktop-file-service.vala"
					switch (0) {
#line 1007 "desktop-file-service.c"
						default:
						{
							const gchar* _tmp23_;
#line 76 "../../../src/core/desktop-file-service.vala"
							_tmp23_ = env;
#line 76 "../../../src/core/desktop-file-service.vala"
							g_warning ("desktop-file-service.vala:76: %s is not understood", _tmp23_);
#line 76 "../../../src/core/desktop-file-service.vala"
							break;
#line 1017 "desktop-file-service.c"
						}
					}
				}
#line 52 "../../../src/core/desktop-file-service.vala"
				_g_free0 (env_up);
#line 1023 "desktop-file-service.c"
			}
		}
	}
#line 79 "../../../src/core/desktop-file-service.vala"
	result = _result_;
#line 79 "../../../src/core/desktop-file-service.vala"
	return result;
#line 1031 "desktop-file-service.c"
}

static GType
synapse_desktop_environment_type_get_type_once (void)
{
	static const GFlagsValue values[] = {{SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME", "gnome"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_KDE, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_KDE", "kde"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_LXDE, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_LXDE", "lxde"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_MATE, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_MATE", "mate"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_RAZOR, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_RAZOR", "razor"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_ROX, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_ROX", "rox"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_TDE, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_TDE", "tde"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_UNITY, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_UNITY", "unity"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_XFCE, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_XFCE", "xfce"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_EDE, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_EDE", "ede"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_CINNAMON, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_CINNAMON", "cinnamon"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_PANTHEON, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_PANTHEON", "pantheon"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_OLD, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_OLD", "old"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_ALL, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_ALL", "all"}, {0, NULL, NULL}};
	GType synapse_desktop_environment_type_type_id;
	synapse_desktop_environment_type_type_id = g_flags_register_static ("SynapseDesktopEnvironmentType", values);
	return synapse_desktop_environment_type_type_id;
}

GType
synapse_desktop_environment_type_get_type (void)
{
	static volatile gsize synapse_desktop_environment_type_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_environment_type_type_id__volatile)) {
		GType synapse_desktop_environment_type_type_id;
		synapse_desktop_environment_type_type_id = synapse_desktop_environment_type_get_type_once ();
		g_once_init_leave (&synapse_desktop_environment_type_type_id__volatile, synapse_desktop_environment_type_type_id);
	}
	return synapse_desktop_environment_type_type_id__volatile;
}

static inline gpointer
synapse_desktop_file_info_get_instance_private (SynapseDesktopFileInfo* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFileInfo_private_offset);
}

const gchar*
synapse_desktop_file_info_get_name_folded (SynapseDesktopFileInfo* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp3_;
	const gchar* result = NULL;
#line 102 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 104 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = self->priv->name_folded;
#line 104 "../../../src/core/desktop-file-service.vala"
	if (_tmp0_ == NULL) {
#line 1073 "desktop-file-service.c"
		const gchar* _tmp1_;
		gchar* _tmp2_;
#line 104 "../../../src/core/desktop-file-service.vala"
		_tmp1_ = self->priv->_name;
#line 104 "../../../src/core/desktop-file-service.vala"
		_tmp2_ = g_utf8_casefold (_tmp1_, (gssize) -1);
#line 104 "../../../src/core/desktop-file-service.vala"
		_g_free0 (self->priv->name_folded);
#line 104 "../../../src/core/desktop-file-service.vala"
		self->priv->name_folded = _tmp2_;
#line 1084 "desktop-file-service.c"
	}
#line 105 "../../../src/core/desktop-file-service.vala"
	_tmp3_ = self->priv->name_folded;
#line 105 "../../../src/core/desktop-file-service.vala"
	result = _tmp3_;
#line 105 "../../../src/core/desktop-file-service.vala"
	return result;
#line 1092 "desktop-file-service.c"
}

SynapseDesktopFileInfo*
synapse_desktop_file_info_construct_for_keyfile (GType object_type,
                                                 const gchar* path,
                                                 GKeyFile* keyfile,
                                                 const gchar* desktop_id)
{
	SynapseDesktopFileInfo * self = NULL;
#line 110 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 110 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (keyfile != NULL, NULL);
#line 110 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (desktop_id != NULL, NULL);
#line 113 "../../../src/core/desktop-file-service.vala"
	self = (SynapseDesktopFileInfo*) g_object_new (object_type, "filename", path, "desktop-id", desktop_id, NULL);
#line 115 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_info_init_from_keyfile (self, keyfile);
#line 110 "../../../src/core/desktop-file-service.vala"
	return self;
#line 1114 "desktop-file-service.c"
}

SynapseDesktopFileInfo*
synapse_desktop_file_info_new_for_keyfile (const gchar* path,
                                           GKeyFile* keyfile,
                                           const gchar* desktop_id)
{
#line 110 "../../../src/core/desktop-file-service.vala"
	return synapse_desktop_file_info_construct_for_keyfile (SYNAPSE_TYPE_DESKTOP_FILE_INFO, path, keyfile, desktop_id);
#line 1124 "desktop-file-service.c"
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gint stack_length,
                             const gchar* needle)
{
	gint i;
#line 130 "../../../src/core/desktop-file-service.vala"
	for (i = 0; i < stack_length; i++) {
#line 130 "../../../src/core/desktop-file-service.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 130 "../../../src/core/desktop-file-service.vala"
			return TRUE;
#line 1139 "desktop-file-service.c"
		}
	}
#line 130 "../../../src/core/desktop-file-service.vala"
	return FALSE;
#line 1144 "desktop-file-service.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 165 "../../../src/core/desktop-file-service.vala"
	return self ? g_object_ref (self) : NULL;
#line 1152 "desktop-file-service.c"
}

static void
synapse_desktop_file_info_init_from_keyfile (SynapseDesktopFileInfo* self,
                                             GKeyFile* keyfile)
{
	GError* _inner_error0_ = NULL;
#line 118 "../../../src/core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 118 "../../../src/core/desktop-file-service.vala"
	g_return_if_fail (keyfile != NULL);
#line 1164 "desktop-file-service.c"
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gboolean _tmp3_ = FALSE;
		GDesktopAppInfo* app_info = NULL;
		GDesktopAppInfo* _tmp8_;
		GDesktopAppInfo* _tmp9_;
		GDesktopAppInfo* _tmp15_;
		const gchar* _tmp16_;
		GDesktopAppInfo* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		const gchar* _tmp31_ = NULL;
		GDesktopAppInfo* _tmp32_;
		const gchar* _tmp33_;
		GIcon* _tmp34_ = NULL;
		GDesktopAppInfo* _tmp35_;
		GIcon* _tmp36_;
		GIcon* _tmp37_;
		GIcon* icon = NULL;
		GIcon* _tmp39_;
		GIcon* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gboolean _tmp43_ = FALSE;
		gboolean _tmp48_ = FALSE;
		gboolean _tmp50_ = FALSE;
		gboolean _tmp59_ = FALSE;
		gboolean _tmp64_ = FALSE;
		const gchar* _tmp65_;
#line 122 "../../../src/core/desktop-file-service.vala"
		_tmp1_ = g_key_file_get_string (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_TYPE, &_inner_error0_);
#line 122 "../../../src/core/desktop-file-service.vala"
		_tmp0_ = _tmp1_;
#line 122 "../../../src/core/desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1205 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 122 "../../../src/core/desktop-file-service.vala"
		if (g_strcmp0 (_tmp0_, G_KEY_FILE_DESKTOP_TYPE_APPLICATION) != 0) {
#line 1210 "desktop-file-service.c"
			GError* _tmp2_;
#line 124 "../../../src/core/desktop-file-service.vala"
			_tmp2_ = g_error_new_literal (SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, "Not Application-type desktop entry");
#line 124 "../../../src/core/desktop-file-service.vala"
			_inner_error0_ = _tmp2_;
#line 124 "../../../src/core/desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1218 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 127 "../../../src/core/desktop-file-service.vala"
		_tmp3_ = g_key_file_has_key (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_CATEGORIES, &_inner_error0_);
#line 127 "../../../src/core/desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 127 "../../../src/core/desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1227 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 127 "../../../src/core/desktop-file-service.vala"
		if (_tmp3_) {
#line 1232 "desktop-file-service.c"
			gchar** categories = NULL;
			gsize _tmp4_ = 0;
			gchar** _tmp5_;
			gint categories_length1;
			gint _categories_size_;
			gchar** _tmp6_;
			gint _tmp6__length1;
#line 129 "../../../src/core/desktop-file-service.vala"
			_tmp5_ = g_key_file_get_string_list (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_CATEGORIES, &_tmp4_, &_inner_error0_);
#line 129 "../../../src/core/desktop-file-service.vala"
			categories = _tmp5_;
#line 129 "../../../src/core/desktop-file-service.vala"
			categories_length1 = _tmp4_;
#line 129 "../../../src/core/desktop-file-service.vala"
			_categories_size_ = categories_length1;
#line 129 "../../../src/core/desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 129 "../../../src/core/desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1252 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 130 "../../../src/core/desktop-file-service.vala"
			_tmp6_ = categories;
#line 130 "../../../src/core/desktop-file-service.vala"
			_tmp6__length1 = categories_length1;
#line 130 "../../../src/core/desktop-file-service.vala"
			if (_vala_string_array_contains (_tmp6_, _tmp6__length1, "Screensaver")) {
#line 1261 "desktop-file-service.c"
				GError* _tmp7_;
#line 132 "../../../src/core/desktop-file-service.vala"
				_tmp7_ = g_error_new_literal (SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, "Screensaver desktop entry");
#line 132 "../../../src/core/desktop-file-service.vala"
				_inner_error0_ = _tmp7_;
#line 132 "../../../src/core/desktop-file-service.vala"
				categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
#line 132 "../../../src/core/desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1271 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 127 "../../../src/core/desktop-file-service.vala"
			categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
#line 1276 "desktop-file-service.c"
		}
#line 137 "../../../src/core/desktop-file-service.vala"
		_tmp8_ = g_desktop_app_info_new_from_keyfile (keyfile);
#line 137 "../../../src/core/desktop-file-service.vala"
		_g_object_unref0 (app_info);
#line 137 "../../../src/core/desktop-file-service.vala"
		app_info = _tmp8_;
#line 139 "../../../src/core/desktop-file-service.vala"
		_tmp9_ = app_info;
#line 139 "../../../src/core/desktop-file-service.vala"
		if (_tmp9_ == NULL) {
#line 1288 "desktop-file-service.c"
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			GError* _tmp13_;
			GError* _tmp14_;
#line 141 "../../../src/core/desktop-file-service.vala"
			_tmp10_ = self->priv->_filename;
#line 141 "../../../src/core/desktop-file-service.vala"
			_tmp11_ = g_strdup_printf ("Unable to create AppInfo for %s", _tmp10_);
#line 141 "../../../src/core/desktop-file-service.vala"
			_tmp12_ = _tmp11_;
#line 141 "../../../src/core/desktop-file-service.vala"
			_tmp13_ = g_error_new_literal (SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, _tmp12_);
#line 141 "../../../src/core/desktop-file-service.vala"
			_tmp14_ = _tmp13_;
#line 141 "../../../src/core/desktop-file-service.vala"
			_g_free0 (_tmp12_);
#line 141 "../../../src/core/desktop-file-service.vala"
			_inner_error0_ = _tmp14_;
#line 141 "../../../src/core/desktop-file-service.vala"
			_g_object_unref0 (app_info);
#line 141 "../../../src/core/desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1312 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 144 "../../../src/core/desktop-file-service.vala"
		_tmp15_ = app_info;
#line 144 "../../../src/core/desktop-file-service.vala"
		_tmp16_ = g_app_info_get_name ((GAppInfo*) _tmp15_);
#line 144 "../../../src/core/desktop-file-service.vala"
		synapse_desktop_file_info_set_name (self, _tmp16_);
#line 145 "../../../src/core/desktop-file-service.vala"
		_tmp17_ = app_info;
#line 145 "../../../src/core/desktop-file-service.vala"
		_tmp18_ = g_app_info_get_commandline ((GAppInfo*) _tmp17_);
#line 145 "../../../src/core/desktop-file-service.vala"
		synapse_desktop_file_info_set_exec (self, _tmp18_);
#line 146 "../../../src/core/desktop-file-service.vala"
		_tmp19_ = self->priv->_exec;
#line 146 "../../../src/core/desktop-file-service.vala"
		if (_tmp19_ == NULL) {
#line 1331 "desktop-file-service.c"
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			GError* _tmp23_;
			GError* _tmp24_;
#line 148 "../../../src/core/desktop-file-service.vala"
			_tmp20_ = self->priv->_name;
#line 148 "../../../src/core/desktop-file-service.vala"
			_tmp21_ = g_strdup_printf ("Unable to get exec for %s", _tmp20_);
#line 148 "../../../src/core/desktop-file-service.vala"
			_tmp22_ = _tmp21_;
#line 148 "../../../src/core/desktop-file-service.vala"
			_tmp23_ = g_error_new_literal (SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, _tmp22_);
#line 148 "../../../src/core/desktop-file-service.vala"
			_tmp24_ = _tmp23_;
#line 148 "../../../src/core/desktop-file-service.vala"
			_g_free0 (_tmp22_);
#line 148 "../../../src/core/desktop-file-service.vala"
			_inner_error0_ = _tmp24_;
#line 148 "../../../src/core/desktop-file-service.vala"
			_g_object_unref0 (app_info);
#line 148 "../../../src/core/desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1355 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 152 "../../../src/core/desktop-file-service.vala"
		_tmp26_ = g_key_file_has_key (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_HIDDEN, &_inner_error0_);
#line 152 "../../../src/core/desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 152 "../../../src/core/desktop-file-service.vala"
			_g_object_unref0 (app_info);
#line 152 "../../../src/core/desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1366 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 152 "../../../src/core/desktop-file-service.vala"
		if (_tmp26_) {
#line 1371 "desktop-file-service.c"
			gboolean _tmp27_ = FALSE;
#line 153 "../../../src/core/desktop-file-service.vala"
			_tmp27_ = g_key_file_get_boolean (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_HIDDEN, &_inner_error0_);
#line 153 "../../../src/core/desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 153 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (app_info);
#line 153 "../../../src/core/desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1381 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 153 "../../../src/core/desktop-file-service.vala"
			_tmp25_ = _tmp27_;
#line 1386 "desktop-file-service.c"
		} else {
#line 152 "../../../src/core/desktop-file-service.vala"
			_tmp25_ = FALSE;
#line 1390 "desktop-file-service.c"
		}
#line 152 "../../../src/core/desktop-file-service.vala"
		if (_tmp25_) {
#line 155 "../../../src/core/desktop-file-service.vala"
			synapse_desktop_file_info_set_is_hidden (self, TRUE);
#line 1396 "desktop-file-service.c"
		}
#line 157 "../../../src/core/desktop-file-service.vala"
		_tmp29_ = g_key_file_has_key (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_NO_DISPLAY, &_inner_error0_);
#line 157 "../../../src/core/desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 157 "../../../src/core/desktop-file-service.vala"
			_g_object_unref0 (app_info);
#line 157 "../../../src/core/desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1406 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 157 "../../../src/core/desktop-file-service.vala"
		if (_tmp29_) {
#line 1411 "desktop-file-service.c"
			gboolean _tmp30_ = FALSE;
#line 158 "../../../src/core/desktop-file-service.vala"
			_tmp30_ = g_key_file_get_boolean (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_NO_DISPLAY, &_inner_error0_);
#line 158 "../../../src/core/desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 158 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (app_info);
#line 158 "../../../src/core/desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1421 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 158 "../../../src/core/desktop-file-service.vala"
			_tmp28_ = _tmp30_;
#line 1426 "desktop-file-service.c"
		} else {
#line 157 "../../../src/core/desktop-file-service.vala"
			_tmp28_ = FALSE;
#line 1430 "desktop-file-service.c"
		}
#line 157 "../../../src/core/desktop-file-service.vala"
		if (_tmp28_) {
#line 160 "../../../src/core/desktop-file-service.vala"
			synapse_desktop_file_info_set_is_hidden (self, TRUE);
#line 1436 "desktop-file-service.c"
		}
#line 163 "../../../src/core/desktop-file-service.vala"
		_tmp32_ = app_info;
#line 163 "../../../src/core/desktop-file-service.vala"
		_tmp33_ = g_app_info_get_description ((GAppInfo*) _tmp32_);
#line 163 "../../../src/core/desktop-file-service.vala"
		_tmp31_ = _tmp33_;
#line 163 "../../../src/core/desktop-file-service.vala"
		if (_tmp31_ == NULL) {
#line 163 "../../../src/core/desktop-file-service.vala"
			_tmp31_ = "";
#line 1448 "desktop-file-service.c"
		}
#line 163 "../../../src/core/desktop-file-service.vala"
		synapse_desktop_file_info_set_comment (self, _tmp31_);
#line 165 "../../../src/core/desktop-file-service.vala"
		_tmp35_ = app_info;
#line 165 "../../../src/core/desktop-file-service.vala"
		_tmp36_ = g_app_info_get_icon ((GAppInfo*) _tmp35_);
#line 165 "../../../src/core/desktop-file-service.vala"
		_tmp37_ = _g_object_ref0 (_tmp36_);
#line 165 "../../../src/core/desktop-file-service.vala"
		_tmp34_ = _tmp37_;
#line 165 "../../../src/core/desktop-file-service.vala"
		if (_tmp34_ == NULL) {
#line 1462 "desktop-file-service.c"
			GThemedIcon* _tmp38_;
#line 165 "../../../src/core/desktop-file-service.vala"
			_tmp38_ = (GThemedIcon*) g_themed_icon_new ("application-default-icon");
#line 165 "../../../src/core/desktop-file-service.vala"
			_g_object_unref0 (_tmp34_);
#line 165 "../../../src/core/desktop-file-service.vala"
			_tmp34_ = (GIcon*) _tmp38_;
#line 1470 "desktop-file-service.c"
		}
#line 165 "../../../src/core/desktop-file-service.vala"
		_tmp39_ = _tmp34_;
#line 165 "../../../src/core/desktop-file-service.vala"
		_tmp34_ = NULL;
#line 165 "../../../src/core/desktop-file-service.vala"
		icon = _tmp39_;
#line 166 "../../../src/core/desktop-file-service.vala"
		_tmp40_ = icon;
#line 166 "../../../src/core/desktop-file-service.vala"
		_tmp41_ = g_icon_to_string (_tmp40_);
#line 166 "../../../src/core/desktop-file-service.vala"
		_tmp42_ = _tmp41_;
#line 166 "../../../src/core/desktop-file-service.vala"
		synapse_desktop_file_info_set_icon_name (self, _tmp42_);
#line 166 "../../../src/core/desktop-file-service.vala"
		_g_free0 (_tmp42_);
#line 168 "../../../src/core/desktop-file-service.vala"
		_tmp43_ = g_key_file_has_key (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_MIME_TYPE, &_inner_error0_);
#line 168 "../../../src/core/desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 168 "../../../src/core/desktop-file-service.vala"
			_g_object_unref0 (icon);
#line 168 "../../../src/core/desktop-file-service.vala"
			_g_object_unref0 (_tmp34_);
#line 168 "../../../src/core/desktop-file-service.vala"
			_g_object_unref0 (app_info);
#line 168 "../../../src/core/desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1500 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 168 "../../../src/core/desktop-file-service.vala"
		if (_tmp43_) {
#line 1505 "desktop-file-service.c"
			gchar** _tmp44_ = NULL;
			gsize _tmp45_ = 0;
			gchar** _tmp46_;
			gint _tmp44__length1;
			gint __tmp44__size_;
			gchar** _tmp47_;
			gint _tmp47__length1;
#line 170 "../../../src/core/desktop-file-service.vala"
			_tmp46_ = g_key_file_get_string_list (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_MIME_TYPE, &_tmp45_, &_inner_error0_);
#line 170 "../../../src/core/desktop-file-service.vala"
			_tmp44_ = _tmp46_;
#line 170 "../../../src/core/desktop-file-service.vala"
			_tmp44__length1 = _tmp45_;
#line 170 "../../../src/core/desktop-file-service.vala"
			__tmp44__size_ = _tmp44__length1;
#line 170 "../../../src/core/desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 170 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (icon);
#line 170 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (_tmp34_);
#line 170 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (app_info);
#line 170 "../../../src/core/desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1531 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 170 "../../../src/core/desktop-file-service.vala"
			_tmp47_ = _tmp44_;
#line 170 "../../../src/core/desktop-file-service.vala"
			_tmp47__length1 = _tmp44__length1;
#line 170 "../../../src/core/desktop-file-service.vala"
			_tmp44_ = NULL;
#line 170 "../../../src/core/desktop-file-service.vala"
			_tmp44__length1 = 0;
#line 170 "../../../src/core/desktop-file-service.vala"
			self->mime_types = (_vala_array_free (self->mime_types, self->mime_types_length1, (GDestroyNotify) g_free), NULL);
#line 170 "../../../src/core/desktop-file-service.vala"
			self->mime_types = _tmp47_;
#line 170 "../../../src/core/desktop-file-service.vala"
			self->mime_types_length1 = _tmp47__length1;
#line 168 "../../../src/core/desktop-file-service.vala"
			_tmp44_ = (_vala_array_free (_tmp44_, _tmp44__length1, (GDestroyNotify) g_free), NULL);
#line 1550 "desktop-file-service.c"
		}
#line 172 "../../../src/core/desktop-file-service.vala"
		_tmp48_ = g_key_file_has_key (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_TERMINAL, &_inner_error0_);
#line 172 "../../../src/core/desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 172 "../../../src/core/desktop-file-service.vala"
			_g_object_unref0 (icon);
#line 172 "../../../src/core/desktop-file-service.vala"
			_g_object_unref0 (_tmp34_);
#line 172 "../../../src/core/desktop-file-service.vala"
			_g_object_unref0 (app_info);
#line 172 "../../../src/core/desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1564 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 172 "../../../src/core/desktop-file-service.vala"
		if (_tmp48_) {
#line 1569 "desktop-file-service.c"
			gboolean _tmp49_ = FALSE;
#line 174 "../../../src/core/desktop-file-service.vala"
			_tmp49_ = g_key_file_get_boolean (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_TERMINAL, &_inner_error0_);
#line 174 "../../../src/core/desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 174 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (icon);
#line 174 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (_tmp34_);
#line 174 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (app_info);
#line 174 "../../../src/core/desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1583 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 174 "../../../src/core/desktop-file-service.vala"
			synapse_desktop_file_info_set_needs_terminal (self, _tmp49_);
#line 1588 "desktop-file-service.c"
		}
#line 176 "../../../src/core/desktop-file-service.vala"
		_tmp50_ = g_key_file_has_key (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_ONLY_SHOW_IN, &_inner_error0_);
#line 176 "../../../src/core/desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 176 "../../../src/core/desktop-file-service.vala"
			_g_object_unref0 (icon);
#line 176 "../../../src/core/desktop-file-service.vala"
			_g_object_unref0 (_tmp34_);
#line 176 "../../../src/core/desktop-file-service.vala"
			_g_object_unref0 (app_info);
#line 176 "../../../src/core/desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1602 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 176 "../../../src/core/desktop-file-service.vala"
		if (_tmp50_) {
#line 1607 "desktop-file-service.c"
			gchar** _tmp51_ = NULL;
			gsize _tmp52_ = 0;
			gchar** _tmp53_;
			gint _tmp51__length1;
			gint __tmp51__size_;
#line 178 "../../../src/core/desktop-file-service.vala"
			_tmp53_ = g_key_file_get_string_list (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_ONLY_SHOW_IN, &_tmp52_, &_inner_error0_);
#line 178 "../../../src/core/desktop-file-service.vala"
			_tmp51_ = _tmp53_;
#line 178 "../../../src/core/desktop-file-service.vala"
			_tmp51__length1 = _tmp52_;
#line 178 "../../../src/core/desktop-file-service.vala"
			__tmp51__size_ = _tmp51__length1;
#line 178 "../../../src/core/desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 178 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (icon);
#line 178 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (_tmp34_);
#line 178 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (app_info);
#line 178 "../../../src/core/desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1631 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 178 "../../../src/core/desktop-file-service.vala"
			synapse_desktop_file_info_set_show_in (self, synapse_desktop_environment_type_from_strings (_tmp51_, (gint) _tmp51__length1));
#line 176 "../../../src/core/desktop-file-service.vala"
			_tmp51_ = (_vala_array_free (_tmp51_, _tmp51__length1, (GDestroyNotify) g_free), NULL);
#line 1638 "desktop-file-service.c"
		} else {
			gboolean _tmp54_ = FALSE;
#line 181 "../../../src/core/desktop-file-service.vala"
			_tmp54_ = g_key_file_has_key (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_NOT_SHOW_IN, &_inner_error0_);
#line 181 "../../../src/core/desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 181 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (icon);
#line 181 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (_tmp34_);
#line 181 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (app_info);
#line 181 "../../../src/core/desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1653 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 181 "../../../src/core/desktop-file-service.vala"
			if (_tmp54_) {
#line 1658 "desktop-file-service.c"
				gchar** _tmp55_ = NULL;
				gsize _tmp56_ = 0;
				gchar** _tmp57_;
				gint _tmp55__length1;
				gint __tmp55__size_;
				SynapseDesktopEnvironmentType not_show = 0U;
				SynapseDesktopEnvironmentType _tmp58_;
#line 183 "../../../src/core/desktop-file-service.vala"
				_tmp57_ = g_key_file_get_string_list (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_NOT_SHOW_IN, &_tmp56_, &_inner_error0_);
#line 183 "../../../src/core/desktop-file-service.vala"
				_tmp55_ = _tmp57_;
#line 183 "../../../src/core/desktop-file-service.vala"
				_tmp55__length1 = _tmp56_;
#line 183 "../../../src/core/desktop-file-service.vala"
				__tmp55__size_ = _tmp55__length1;
#line 183 "../../../src/core/desktop-file-service.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 183 "../../../src/core/desktop-file-service.vala"
					_g_object_unref0 (icon);
#line 183 "../../../src/core/desktop-file-service.vala"
					_g_object_unref0 (_tmp34_);
#line 183 "../../../src/core/desktop-file-service.vala"
					_g_object_unref0 (app_info);
#line 183 "../../../src/core/desktop-file-service.vala"
					_g_free0 (_tmp0_);
#line 1684 "desktop-file-service.c"
					goto __catch0_g_error;
				}
#line 183 "../../../src/core/desktop-file-service.vala"
				not_show = synapse_desktop_environment_type_from_strings (_tmp55_, (gint) _tmp55__length1);
#line 185 "../../../src/core/desktop-file-service.vala"
				_tmp58_ = not_show;
#line 185 "../../../src/core/desktop-file-service.vala"
				synapse_desktop_file_info_set_show_in (self, SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_ALL ^ _tmp58_);
#line 181 "../../../src/core/desktop-file-service.vala"
				_tmp55_ = (_vala_array_free (_tmp55_, _tmp55__length1, (GDestroyNotify) g_free), NULL);
#line 1695 "desktop-file-service.c"
			}
		}
#line 187 "../../../src/core/desktop-file-service.vala"
		_tmp59_ = g_key_file_has_key (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_ACTIONS, &_inner_error0_);
#line 187 "../../../src/core/desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 187 "../../../src/core/desktop-file-service.vala"
			_g_object_unref0 (icon);
#line 187 "../../../src/core/desktop-file-service.vala"
			_g_object_unref0 (_tmp34_);
#line 187 "../../../src/core/desktop-file-service.vala"
			_g_object_unref0 (app_info);
#line 187 "../../../src/core/desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1710 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 187 "../../../src/core/desktop-file-service.vala"
		if (_tmp59_) {
#line 1715 "desktop-file-service.c"
			gchar** _tmp60_ = NULL;
			gsize _tmp61_ = 0;
			gchar** _tmp62_;
			gint _tmp60__length1;
			gint __tmp60__size_;
			gchar** _tmp63_;
			gint _tmp63__length1;
#line 188 "../../../src/core/desktop-file-service.vala"
			_tmp62_ = g_key_file_get_string_list (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_ACTIONS, &_tmp61_, &_inner_error0_);
#line 188 "../../../src/core/desktop-file-service.vala"
			_tmp60_ = _tmp62_;
#line 188 "../../../src/core/desktop-file-service.vala"
			_tmp60__length1 = _tmp61_;
#line 188 "../../../src/core/desktop-file-service.vala"
			__tmp60__size_ = _tmp60__length1;
#line 188 "../../../src/core/desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 188 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (icon);
#line 188 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (_tmp34_);
#line 188 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (app_info);
#line 188 "../../../src/core/desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1741 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 188 "../../../src/core/desktop-file-service.vala"
			_tmp63_ = _tmp60_;
#line 188 "../../../src/core/desktop-file-service.vala"
			_tmp63__length1 = _tmp60__length1;
#line 188 "../../../src/core/desktop-file-service.vala"
			_tmp60_ = NULL;
#line 188 "../../../src/core/desktop-file-service.vala"
			_tmp60__length1 = 0;
#line 188 "../../../src/core/desktop-file-service.vala"
			self->actions = (_vala_array_free (self->actions, self->actions_length1, (GDestroyNotify) g_free), NULL);
#line 188 "../../../src/core/desktop-file-service.vala"
			self->actions = _tmp63_;
#line 188 "../../../src/core/desktop-file-service.vala"
			self->actions_length1 = _tmp63__length1;
#line 187 "../../../src/core/desktop-file-service.vala"
			_tmp60_ = (_vala_array_free (_tmp60_, _tmp60__length1, (GDestroyNotify) g_free), NULL);
#line 1760 "desktop-file-service.c"
		}
#line 192 "../../../src/core/desktop-file-service.vala"
		_tmp65_ = self->priv->_filename;
#line 192 "../../../src/core/desktop-file-service.vala"
		if (g_str_has_suffix (_tmp65_, "gconf-editor.desktop")) {
#line 192 "../../../src/core/desktop-file-service.vala"
			_tmp64_ = TRUE;
#line 1768 "desktop-file-service.c"
		} else {
			const gchar* _tmp66_;
#line 193 "../../../src/core/desktop-file-service.vala"
			_tmp66_ = self->priv->_filename;
#line 193 "../../../src/core/desktop-file-service.vala"
			_tmp64_ = g_str_has_suffix (_tmp66_, "dconf-editor.desktop");
#line 1775 "desktop-file-service.c"
		}
#line 192 "../../../src/core/desktop-file-service.vala"
		if (_tmp64_) {
#line 195 "../../../src/core/desktop-file-service.vala"
			synapse_desktop_file_info_set_is_hidden (self, FALSE);
#line 1781 "desktop-file-service.c"
		}
#line 120 "../../../src/core/desktop-file-service.vala"
		_g_object_unref0 (icon);
#line 120 "../../../src/core/desktop-file-service.vala"
		_g_object_unref0 (_tmp34_);
#line 120 "../../../src/core/desktop-file-service.vala"
		_g_object_unref0 (app_info);
#line 120 "../../../src/core/desktop-file-service.vala"
		_g_free0 (_tmp0_);
#line 1791 "desktop-file-service.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp67_;
		const gchar* _tmp68_;
#line 120 "../../../src/core/desktop-file-service.vala"
		err = _inner_error0_;
#line 120 "../../../src/core/desktop-file-service.vala"
		_inner_error0_ = NULL;
#line 200 "../../../src/core/desktop-file-service.vala"
		_tmp67_ = err;
#line 200 "../../../src/core/desktop-file-service.vala"
		_tmp68_ = _tmp67_->message;
#line 200 "../../../src/core/desktop-file-service.vala"
		g_warning ("desktop-file-service.vala:200: %s", _tmp68_);
#line 201 "../../../src/core/desktop-file-service.vala"
		synapse_desktop_file_info_set_is_valid (self, FALSE);
#line 120 "../../../src/core/desktop-file-service.vala"
		_g_error_free0 (err);
#line 1813 "desktop-file-service.c"
	}
	__finally0:
#line 120 "../../../src/core/desktop-file-service.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 120 "../../../src/core/desktop-file-service.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 120 "../../../src/core/desktop-file-service.vala"
		g_clear_error (&_inner_error0_);
#line 120 "../../../src/core/desktop-file-service.vala"
		return;
#line 1824 "desktop-file-service.c"
	}
}

SynapseDesktopFileInfo*
synapse_desktop_file_info_construct (GType object_type)
{
	SynapseDesktopFileInfo * self = NULL;
#line 83 "../../../src/core/desktop-file-service.vala"
	self = (SynapseDesktopFileInfo*) g_object_new (object_type, NULL);
#line 83 "../../../src/core/desktop-file-service.vala"
	return self;
#line 1836 "desktop-file-service.c"
}

SynapseDesktopFileInfo*
synapse_desktop_file_info_new (void)
{
#line 83 "../../../src/core/desktop-file-service.vala"
	return synapse_desktop_file_info_construct (SYNAPSE_TYPE_DESKTOP_FILE_INFO);
#line 1844 "desktop-file-service.c"
}

const gchar*
synapse_desktop_file_info_get_desktop_id (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 85 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 85 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = self->priv->_desktop_id;
#line 85 "../../../src/core/desktop-file-service.vala"
	result = _tmp0_;
#line 85 "../../../src/core/desktop-file-service.vala"
	return result;
#line 1860 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_desktop_id (SynapseDesktopFileInfo* self,
                                          const gchar* value)
{
	gchar* old_value;
#line 85 "../../../src/core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 85 "../../../src/core/desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_desktop_id (self);
#line 85 "../../../src/core/desktop-file-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1874 "desktop-file-service.c"
		gchar* _tmp0_;
#line 85 "../../../src/core/desktop-file-service.vala"
		_tmp0_ = g_strdup (value);
#line 85 "../../../src/core/desktop-file-service.vala"
		_g_free0 (self->priv->_desktop_id);
#line 85 "../../../src/core/desktop-file-service.vala"
		self->priv->_desktop_id = _tmp0_;
#line 85 "../../../src/core/desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY]);
#line 1884 "desktop-file-service.c"
	}
}

const gchar*
synapse_desktop_file_info_get_name (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 86 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 86 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = self->priv->_name;
#line 86 "../../../src/core/desktop-file-service.vala"
	result = _tmp0_;
#line 86 "../../../src/core/desktop-file-service.vala"
	return result;
#line 1901 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_name (SynapseDesktopFileInfo* self,
                                    const gchar* value)
{
	gchar* old_value;
#line 86 "../../../src/core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 86 "../../../src/core/desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_name (self);
#line 86 "../../../src/core/desktop-file-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1915 "desktop-file-service.c"
		gchar* _tmp0_;
#line 86 "../../../src/core/desktop-file-service.vala"
		_tmp0_ = g_strdup (value);
#line 86 "../../../src/core/desktop-file-service.vala"
		_g_free0 (self->priv->_name);
#line 86 "../../../src/core/desktop-file-service.vala"
		self->priv->_name = _tmp0_;
#line 86 "../../../src/core/desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY]);
#line 1925 "desktop-file-service.c"
	}
}

const gchar*
synapse_desktop_file_info_get_comment (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 87 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 87 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = self->priv->_comment;
#line 87 "../../../src/core/desktop-file-service.vala"
	result = _tmp0_;
#line 87 "../../../src/core/desktop-file-service.vala"
	return result;
#line 1942 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_comment (SynapseDesktopFileInfo* self,
                                       const gchar* value)
{
	gchar* old_value;
#line 87 "../../../src/core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 87 "../../../src/core/desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_comment (self);
#line 87 "../../../src/core/desktop-file-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1956 "desktop-file-service.c"
		gchar* _tmp0_;
#line 87 "../../../src/core/desktop-file-service.vala"
		_tmp0_ = g_strdup (value);
#line 87 "../../../src/core/desktop-file-service.vala"
		_g_free0 (self->priv->_comment);
#line 87 "../../../src/core/desktop-file-service.vala"
		self->priv->_comment = _tmp0_;
#line 87 "../../../src/core/desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY]);
#line 1966 "desktop-file-service.c"
	}
}

const gchar*
synapse_desktop_file_info_get_icon_name (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 88 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 88 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = self->priv->_icon_name;
#line 88 "../../../src/core/desktop-file-service.vala"
	result = _tmp0_;
#line 88 "../../../src/core/desktop-file-service.vala"
	return result;
#line 1983 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_icon_name (SynapseDesktopFileInfo* self,
                                         const gchar* value)
{
	gchar* old_value;
#line 88 "../../../src/core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 88 "../../../src/core/desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_icon_name (self);
#line 88 "../../../src/core/desktop-file-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1997 "desktop-file-service.c"
		gchar* _tmp0_;
#line 88 "../../../src/core/desktop-file-service.vala"
		_tmp0_ = g_strdup (value);
#line 88 "../../../src/core/desktop-file-service.vala"
		_g_free0 (self->priv->_icon_name);
#line 88 "../../../src/core/desktop-file-service.vala"
		self->priv->_icon_name = _tmp0_;
#line 88 "../../../src/core/desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY]);
#line 2007 "desktop-file-service.c"
	}
}

gboolean
synapse_desktop_file_info_get_needs_terminal (SynapseDesktopFileInfo* self)
{
	gboolean result;
#line 90 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 90 "../../../src/core/desktop-file-service.vala"
	result = self->priv->_needs_terminal;
#line 90 "../../../src/core/desktop-file-service.vala"
	return result;
#line 2021 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_needs_terminal (SynapseDesktopFileInfo* self,
                                              gboolean value)
{
	gboolean old_value;
#line 90 "../../../src/core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 90 "../../../src/core/desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_needs_terminal (self);
#line 90 "../../../src/core/desktop-file-service.vala"
	if (old_value != value) {
#line 90 "../../../src/core/desktop-file-service.vala"
		self->priv->_needs_terminal = value;
#line 90 "../../../src/core/desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY]);
#line 2039 "desktop-file-service.c"
	}
}

const gchar*
synapse_desktop_file_info_get_filename (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 91 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 91 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = self->priv->_filename;
#line 91 "../../../src/core/desktop-file-service.vala"
	result = _tmp0_;
#line 91 "../../../src/core/desktop-file-service.vala"
	return result;
#line 2056 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_filename (SynapseDesktopFileInfo* self,
                                        const gchar* value)
{
	gchar* old_value;
#line 91 "../../../src/core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 91 "../../../src/core/desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_filename (self);
#line 91 "../../../src/core/desktop-file-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2070 "desktop-file-service.c"
		gchar* _tmp0_;
#line 91 "../../../src/core/desktop-file-service.vala"
		_tmp0_ = g_strdup (value);
#line 91 "../../../src/core/desktop-file-service.vala"
		_g_free0 (self->priv->_filename);
#line 91 "../../../src/core/desktop-file-service.vala"
		self->priv->_filename = _tmp0_;
#line 91 "../../../src/core/desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY]);
#line 2080 "desktop-file-service.c"
	}
}

const gchar*
synapse_desktop_file_info_get_exec (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 93 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 93 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = self->priv->_exec;
#line 93 "../../../src/core/desktop-file-service.vala"
	result = _tmp0_;
#line 93 "../../../src/core/desktop-file-service.vala"
	return result;
#line 2097 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_exec (SynapseDesktopFileInfo* self,
                                    const gchar* value)
{
	gchar* old_value;
#line 93 "../../../src/core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 93 "../../../src/core/desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_exec (self);
#line 93 "../../../src/core/desktop-file-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2111 "desktop-file-service.c"
		gchar* _tmp0_;
#line 93 "../../../src/core/desktop-file-service.vala"
		_tmp0_ = g_strdup (value);
#line 93 "../../../src/core/desktop-file-service.vala"
		_g_free0 (self->priv->_exec);
#line 93 "../../../src/core/desktop-file-service.vala"
		self->priv->_exec = _tmp0_;
#line 93 "../../../src/core/desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY]);
#line 2121 "desktop-file-service.c"
	}
}

gboolean
synapse_desktop_file_info_get_is_hidden (SynapseDesktopFileInfo* self)
{
	gboolean result;
#line 95 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 95 "../../../src/core/desktop-file-service.vala"
	result = self->priv->_is_hidden;
#line 95 "../../../src/core/desktop-file-service.vala"
	return result;
#line 2135 "desktop-file-service.c"
}

static void
synapse_desktop_file_info_set_is_hidden (SynapseDesktopFileInfo* self,
                                         gboolean value)
{
	gboolean old_value;
#line 95 "../../../src/core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 95 "../../../src/core/desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_is_hidden (self);
#line 95 "../../../src/core/desktop-file-service.vala"
	if (old_value != value) {
#line 95 "../../../src/core/desktop-file-service.vala"
		self->priv->_is_hidden = value;
#line 95 "../../../src/core/desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY]);
#line 2153 "desktop-file-service.c"
	}
}

gboolean
synapse_desktop_file_info_get_is_valid (SynapseDesktopFileInfo* self)
{
	gboolean result;
#line 96 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 96 "../../../src/core/desktop-file-service.vala"
	result = self->priv->_is_valid;
#line 96 "../../../src/core/desktop-file-service.vala"
	return result;
#line 2167 "desktop-file-service.c"
}

static void
synapse_desktop_file_info_set_is_valid (SynapseDesktopFileInfo* self,
                                        gboolean value)
{
	gboolean old_value;
#line 96 "../../../src/core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 96 "../../../src/core/desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_is_valid (self);
#line 96 "../../../src/core/desktop-file-service.vala"
	if (old_value != value) {
#line 96 "../../../src/core/desktop-file-service.vala"
		self->priv->_is_valid = value;
#line 96 "../../../src/core/desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY]);
#line 2185 "desktop-file-service.c"
	}
}

SynapseDesktopEnvironmentType
synapse_desktop_file_info_get_show_in (SynapseDesktopFileInfo* self)
{
	SynapseDesktopEnvironmentType result;
	SynapseDesktopEnvironmentType _tmp0_;
#line 108 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 108 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = self->priv->_show_in;
#line 108 "../../../src/core/desktop-file-service.vala"
	result = _tmp0_;
#line 108 "../../../src/core/desktop-file-service.vala"
	return result;
#line 2202 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_show_in (SynapseDesktopFileInfo* self,
                                       SynapseDesktopEnvironmentType value)
{
	SynapseDesktopEnvironmentType old_value;
#line 108 "../../../src/core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 108 "../../../src/core/desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_show_in (self);
#line 108 "../../../src/core/desktop-file-service.vala"
	if (old_value != value) {
#line 108 "../../../src/core/desktop-file-service.vala"
		self->priv->_show_in = value;
#line 108 "../../../src/core/desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY]);
#line 2220 "desktop-file-service.c"
	}
}

static void
synapse_desktop_file_info_class_init (SynapseDesktopFileInfoClass * klass,
                                      gpointer klass_data)
{
#line 83 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_info_parent_class = g_type_class_peek_parent (klass);
#line 83 "../../../src/core/desktop-file-service.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFileInfo_private_offset);
#line 83 "../../../src/core/desktop-file-service.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_info_get_property;
#line 83 "../../../src/core/desktop-file-service.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_info_set_property;
#line 83 "../../../src/core/desktop-file-service.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_info_finalize;
#line 83 "../../../src/core/desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY] = g_param_spec_string ("desktop-id", "desktop-id", "desktop-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 83 "../../../src/core/desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 83 "../../../src/core/desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY] = g_param_spec_string ("comment", "comment", "comment", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 83 "../../../src/core/desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 83 "../../../src/core/desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY] = g_param_spec_boolean ("needs-terminal", "needs-terminal", "needs-terminal", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 83 "../../../src/core/desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 83 "../../../src/core/desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY] = g_param_spec_string ("exec", "exec", "exec", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 83 "../../../src/core/desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY] = g_param_spec_boolean ("is-hidden", "is-hidden", "is-hidden", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 83 "../../../src/core/desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY] = g_param_spec_boolean ("is-valid", "is-valid", "is-valid", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 83 "../../../src/core/desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY] = g_param_spec_flags ("show-in", "show-in", "show-in", SYNAPSE_TYPE_DESKTOP_ENVIRONMENT_TYPE, SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_ALL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2258 "desktop-file-service.c"
}

static void
synapse_desktop_file_info_instance_init (SynapseDesktopFileInfo * self,
                                         gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 83 "../../../src/core/desktop-file-service.vala"
	self->priv = synapse_desktop_file_info_get_instance_private (self);
#line 87 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = g_strdup ("");
#line 87 "../../../src/core/desktop-file-service.vala"
	self->priv->_comment = _tmp0_;
#line 88 "../../../src/core/desktop-file-service.vala"
	_tmp1_ = g_strdup ("");
#line 88 "../../../src/core/desktop-file-service.vala"
	self->priv->_icon_name = _tmp1_;
#line 90 "../../../src/core/desktop-file-service.vala"
	self->priv->_needs_terminal = FALSE;
#line 95 "../../../src/core/desktop-file-service.vala"
	self->priv->_is_hidden = FALSE;
#line 96 "../../../src/core/desktop-file-service.vala"
	self->priv->_is_valid = TRUE;
#line 98 "../../../src/core/desktop-file-service.vala"
	self->actions = NULL;
#line 98 "../../../src/core/desktop-file-service.vala"
	self->actions_length1 = 0;
#line 99 "../../../src/core/desktop-file-service.vala"
	self->mime_types = NULL;
#line 99 "../../../src/core/desktop-file-service.vala"
	self->mime_types_length1 = 0;
#line 101 "../../../src/core/desktop-file-service.vala"
	self->priv->name_folded = NULL;
#line 108 "../../../src/core/desktop-file-service.vala"
	self->priv->_show_in = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_ALL;
#line 2295 "desktop-file-service.c"
}

static void
synapse_desktop_file_info_finalize (GObject * obj)
{
	SynapseDesktopFileInfo * self;
#line 83 "../../../src/core/desktop-file-service.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo);
#line 85 "../../../src/core/desktop-file-service.vala"
	_g_free0 (self->priv->_desktop_id);
#line 86 "../../../src/core/desktop-file-service.vala"
	_g_free0 (self->priv->_name);
#line 87 "../../../src/core/desktop-file-service.vala"
	_g_free0 (self->priv->_comment);
#line 88 "../../../src/core/desktop-file-service.vala"
	_g_free0 (self->priv->_icon_name);
#line 91 "../../../src/core/desktop-file-service.vala"
	_g_free0 (self->priv->_filename);
#line 93 "../../../src/core/desktop-file-service.vala"
	_g_free0 (self->priv->_exec);
#line 98 "../../../src/core/desktop-file-service.vala"
	self->actions = (_vala_array_free (self->actions, self->actions_length1, (GDestroyNotify) g_free), NULL);
#line 99 "../../../src/core/desktop-file-service.vala"
	self->mime_types = (_vala_array_free (self->mime_types, self->mime_types_length1, (GDestroyNotify) g_free), NULL);
#line 101 "../../../src/core/desktop-file-service.vala"
	_g_free0 (self->priv->name_folded);
#line 83 "../../../src/core/desktop-file-service.vala"
	G_OBJECT_CLASS (synapse_desktop_file_info_parent_class)->finalize (obj);
#line 2324 "desktop-file-service.c"
}

static GType
synapse_desktop_file_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFileInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFileInfo), 0, (GInstanceInitFunc) synapse_desktop_file_info_instance_init, NULL };
	GType synapse_desktop_file_info_type_id;
	synapse_desktop_file_info_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFileInfo", &g_define_type_info, 0);
	SynapseDesktopFileInfo_private_offset = g_type_add_instance_private (synapse_desktop_file_info_type_id, sizeof (SynapseDesktopFileInfoPrivate));
	return synapse_desktop_file_info_type_id;
}

GType
synapse_desktop_file_info_get_type (void)
{
	static volatile gsize synapse_desktop_file_info_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_info_type_id__volatile)) {
		GType synapse_desktop_file_info_type_id;
		synapse_desktop_file_info_type_id = synapse_desktop_file_info_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_info_type_id__volatile, synapse_desktop_file_info_type_id);
	}
	return synapse_desktop_file_info_type_id__volatile;
}

static void
_vala_synapse_desktop_file_info_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	SynapseDesktopFileInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo);
#line 83 "../../../src/core/desktop-file-service.vala"
	switch (property_id) {
#line 83 "../../../src/core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY:
#line 83 "../../../src/core/desktop-file-service.vala"
		g_value_set_string (value, synapse_desktop_file_info_get_desktop_id (self));
#line 83 "../../../src/core/desktop-file-service.vala"
		break;
#line 83 "../../../src/core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY:
#line 83 "../../../src/core/desktop-file-service.vala"
		g_value_set_string (value, synapse_desktop_file_info_get_name (self));
#line 83 "../../../src/core/desktop-file-service.vala"
		break;
#line 83 "../../../src/core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY:
#line 83 "../../../src/core/desktop-file-service.vala"
		g_value_set_string (value, synapse_desktop_file_info_get_comment (self));
#line 83 "../../../src/core/desktop-file-service.vala"
		break;
#line 83 "../../../src/core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY:
#line 83 "../../../src/core/desktop-file-service.vala"
		g_value_set_string (value, synapse_desktop_file_info_get_icon_name (self));
#line 83 "../../../src/core/desktop-file-service.vala"
		break;
#line 83 "../../../src/core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY:
#line 83 "../../../src/core/desktop-file-service.vala"
		g_value_set_boolean (value, synapse_desktop_file_info_get_needs_terminal (self));
#line 83 "../../../src/core/desktop-file-service.vala"
		break;
#line 83 "../../../src/core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY:
#line 83 "../../../src/core/desktop-file-service.vala"
		g_value_set_string (value, synapse_desktop_file_info_get_filename (self));
#line 83 "../../../src/core/desktop-file-service.vala"
		break;
#line 83 "../../../src/core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY:
#line 83 "../../../src/core/desktop-file-service.vala"
		g_value_set_string (value, synapse_desktop_file_info_get_exec (self));
#line 83 "../../../src/core/desktop-file-service.vala"
		break;
#line 83 "../../../src/core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY:
#line 83 "../../../src/core/desktop-file-service.vala"
		g_value_set_boolean (value, synapse_desktop_file_info_get_is_hidden (self));
#line 83 "../../../src/core/desktop-file-service.vala"
		break;
#line 83 "../../../src/core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY:
#line 83 "../../../src/core/desktop-file-service.vala"
		g_value_set_boolean (value, synapse_desktop_file_info_get_is_valid (self));
#line 83 "../../../src/core/desktop-file-service.vala"
		break;
#line 83 "../../../src/core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY:
#line 83 "../../../src/core/desktop-file-service.vala"
		g_value_set_flags (value, synapse_desktop_file_info_get_show_in (self));
#line 83 "../../../src/core/desktop-file-service.vala"
		break;
#line 2419 "desktop-file-service.c"
		default:
#line 83 "../../../src/core/desktop-file-service.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 83 "../../../src/core/desktop-file-service.vala"
		break;
#line 2425 "desktop-file-service.c"
	}
}

static void
_vala_synapse_desktop_file_info_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	SynapseDesktopFileInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo);
#line 83 "../../../src/core/desktop-file-service.vala"
	switch (property_id) {
#line 83 "../../../src/core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY:
#line 83 "../../../src/core/desktop-file-service.vala"
		synapse_desktop_file_info_set_desktop_id (self, g_value_get_string (value));
#line 83 "../../../src/core/desktop-file-service.vala"
		break;
#line 83 "../../../src/core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY:
#line 83 "../../../src/core/desktop-file-service.vala"
		synapse_desktop_file_info_set_name (self, g_value_get_string (value));
#line 83 "../../../src/core/desktop-file-service.vala"
		break;
#line 83 "../../../src/core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY:
#line 83 "../../../src/core/desktop-file-service.vala"
		synapse_desktop_file_info_set_comment (self, g_value_get_string (value));
#line 83 "../../../src/core/desktop-file-service.vala"
		break;
#line 83 "../../../src/core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY:
#line 83 "../../../src/core/desktop-file-service.vala"
		synapse_desktop_file_info_set_icon_name (self, g_value_get_string (value));
#line 83 "../../../src/core/desktop-file-service.vala"
		break;
#line 83 "../../../src/core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY:
#line 83 "../../../src/core/desktop-file-service.vala"
		synapse_desktop_file_info_set_needs_terminal (self, g_value_get_boolean (value));
#line 83 "../../../src/core/desktop-file-service.vala"
		break;
#line 83 "../../../src/core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY:
#line 83 "../../../src/core/desktop-file-service.vala"
		synapse_desktop_file_info_set_filename (self, g_value_get_string (value));
#line 83 "../../../src/core/desktop-file-service.vala"
		break;
#line 83 "../../../src/core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY:
#line 83 "../../../src/core/desktop-file-service.vala"
		synapse_desktop_file_info_set_exec (self, g_value_get_string (value));
#line 83 "../../../src/core/desktop-file-service.vala"
		break;
#line 83 "../../../src/core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY:
#line 83 "../../../src/core/desktop-file-service.vala"
		synapse_desktop_file_info_set_is_hidden (self, g_value_get_boolean (value));
#line 83 "../../../src/core/desktop-file-service.vala"
		break;
#line 83 "../../../src/core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY:
#line 83 "../../../src/core/desktop-file-service.vala"
		synapse_desktop_file_info_set_is_valid (self, g_value_get_boolean (value));
#line 83 "../../../src/core/desktop-file-service.vala"
		break;
#line 83 "../../../src/core/desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY:
#line 83 "../../../src/core/desktop-file-service.vala"
		synapse_desktop_file_info_set_show_in (self, g_value_get_flags (value));
#line 83 "../../../src/core/desktop-file-service.vala"
		break;
#line 2499 "desktop-file-service.c"
		default:
#line 83 "../../../src/core/desktop-file-service.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 83 "../../../src/core/desktop-file-service.vala"
		break;
#line 2505 "desktop-file-service.c"
	}
}

static inline gpointer
synapse_desktop_file_service_get_instance_private (SynapseDesktopFileService* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFileService_private_offset);
}

SynapseDesktopFileService*
synapse_desktop_file_service_get_default (void)
{
	SynapseDesktopFileService* _tmp0_ = NULL;
	SynapseDesktopFileService* _tmp1_;
	SynapseDesktopFileService* _tmp2_;
	SynapseDesktopFileService* _tmp4_;
	SynapseDesktopFileService* result = NULL;
#line 214 "../../../src/core/desktop-file-service.vala"
	_tmp1_ = synapse_desktop_file_service_instance;
#line 214 "../../../src/core/desktop-file-service.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 214 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = _tmp2_;
#line 214 "../../../src/core/desktop-file-service.vala"
	if (_tmp0_ == NULL) {
#line 2531 "desktop-file-service.c"
		SynapseDesktopFileService* _tmp3_;
#line 214 "../../../src/core/desktop-file-service.vala"
		_tmp3_ = synapse_desktop_file_service_new ();
#line 214 "../../../src/core/desktop-file-service.vala"
		_g_object_unref0 (_tmp0_);
#line 214 "../../../src/core/desktop-file-service.vala"
		_tmp0_ = _tmp3_;
#line 2539 "desktop-file-service.c"
	}
#line 214 "../../../src/core/desktop-file-service.vala"
	_tmp4_ = _tmp0_;
#line 214 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = NULL;
#line 214 "../../../src/core/desktop-file-service.vala"
	result = _tmp4_;
#line 214 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (_tmp0_);
#line 214 "../../../src/core/desktop-file-service.vala"
	return result;
#line 2551 "desktop-file-service.c"
}

static SynapseDesktopFileService*
synapse_desktop_file_service_construct (GType object_type)
{
	SynapseDesktopFileService * self = NULL;
#line 217 "../../../src/core/desktop-file-service.vala"
	self = (SynapseDesktopFileService*) g_object_new (object_type, NULL);
#line 217 "../../../src/core/desktop-file-service.vala"
	return self;
#line 2562 "desktop-file-service.c"
}

static SynapseDesktopFileService*
synapse_desktop_file_service_new (void)
{
#line 217 "../../../src/core/desktop-file-service.vala"
	return synapse_desktop_file_service_construct (SYNAPSE_TYPE_DESKTOP_FILE_SERVICE);
#line 2570 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_initialize_data_free (gpointer _data)
{
	SynapseDesktopFileServiceInitializeData* _data_;
	_data_ = _data;
#line 206 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (_data_->self);
#line 206 "../../../src/core/desktop-file-service.vala"
	g_slice_free (SynapseDesktopFileServiceInitializeData, _data_);
#line 2582 "desktop-file-service.c"
}

void
synapse_desktop_file_service_initialize (SynapseDesktopFileService* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	SynapseDesktopFileServiceInitializeData* _data_;
	SynapseDesktopFileService* _tmp0_;
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_ = g_slice_new0 (SynapseDesktopFileServiceInitializeData);
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 206 "../../../src/core/desktop-file-service.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_initialize_data_free);
#line 206 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_->self = _tmp0_;
#line 206 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_initialize_co (_data_);
#line 2604 "desktop-file-service.c"
}

void
synapse_desktop_file_service_initialize_finish (SynapseDesktopFileService* self,
                                                GAsyncResult* _res_)
{
	SynapseDesktopFileServiceInitializeData* _data_;
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 2614 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_initialize_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	SynapseDesktopFileServiceInitializeData* _data_;
#line 250 "../../../src/core/desktop-file-service.vala"
	_data_ = _user_data_;
#line 250 "../../../src/core/desktop-file-service.vala"
	_data_->_source_object_ = source_object;
#line 250 "../../../src/core/desktop-file-service.vala"
	_data_->_res_ = _res_;
#line 250 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_initialize_co (_data_);
#line 2631 "desktop-file-service.c"
}

static gboolean
_synapse_desktop_file_service_initialize_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_desktop_file_service_initialize_co (self);
#line 256 "../../../src/core/desktop-file-service.vala"
	return result;
#line 2641 "desktop-file-service.c"
}

static gboolean
synapse_desktop_file_service_initialize_co (SynapseDesktopFileServiceInitializeData* _data_)
{
#line 247 "../../../src/core/desktop-file-service.vala"
	switch (_data_->_state_) {
#line 247 "../../../src/core/desktop-file-service.vala"
		case 0:
#line 2651 "desktop-file-service.c"
		goto _state_0;
#line 247 "../../../src/core/desktop-file-service.vala"
		case 1:
#line 2655 "desktop-file-service.c"
		goto _state_1;
#line 247 "../../../src/core/desktop-file-service.vala"
		case 2:
#line 2659 "desktop-file-service.c"
		goto _state_2;
#line 247 "../../../src/core/desktop-file-service.vala"
		case 3:
#line 2663 "desktop-file-service.c"
		goto _state_3;
		default:
#line 247 "../../../src/core/desktop-file-service.vala"
		g_assert_not_reached ();
#line 2668 "desktop-file-service.c"
	}
	_state_0:
#line 249 "../../../src/core/desktop-file-service.vala"
	_data_->_tmp0_ = _data_->self->priv->init_once;
#line 249 "../../../src/core/desktop-file-service.vala"
	if (synapse_utils_async_once_is_initialized (_data_->_tmp0_)) {
#line 249 "../../../src/core/desktop-file-service.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 249 "../../../src/core/desktop-file-service.vala"
		if (_data_->_state_ != 0) {
#line 249 "../../../src/core/desktop-file-service.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 249 "../../../src/core/desktop-file-service.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2683 "desktop-file-service.c"
			}
		}
#line 249 "../../../src/core/desktop-file-service.vala"
		g_object_unref (_data_->_async_result);
#line 249 "../../../src/core/desktop-file-service.vala"
		return FALSE;
#line 2690 "desktop-file-service.c"
	}
#line 250 "../../../src/core/desktop-file-service.vala"
	_data_->_tmp1_ = _data_->self->priv->init_once;
#line 250 "../../../src/core/desktop-file-service.vala"
	_data_->_state_ = 1;
#line 250 "../../../src/core/desktop-file-service.vala"
	synapse_utils_async_once_enter (_data_->_tmp1_, synapse_desktop_file_service_initialize_ready, _data_);
#line 250 "../../../src/core/desktop-file-service.vala"
	return FALSE;
#line 2700 "desktop-file-service.c"
	_state_1:
#line 250 "../../../src/core/desktop-file-service.vala"
	_data_->is_locked = synapse_utils_async_once_enter_finish (_data_->_tmp1_, _data_->_res_);
#line 251 "../../../src/core/desktop-file-service.vala"
	if (!_data_->is_locked) {
#line 251 "../../../src/core/desktop-file-service.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 251 "../../../src/core/desktop-file-service.vala"
		if (_data_->_state_ != 0) {
#line 251 "../../../src/core/desktop-file-service.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 251 "../../../src/core/desktop-file-service.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2714 "desktop-file-service.c"
			}
		}
#line 251 "../../../src/core/desktop-file-service.vala"
		g_object_unref (_data_->_async_result);
#line 251 "../../../src/core/desktop-file-service.vala"
		return FALSE;
#line 2721 "desktop-file-service.c"
	}
#line 253 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_get_environment_type (_data_->self);
#line 254 "../../../src/core/desktop-file-service.vala"
	_data_->_tmp2_ = _data_->self->priv->session_type_str;
#line 254 "../../../src/core/desktop-file-service.vala"
	g_desktop_app_info_set_desktop_env (_data_->_tmp2_);
#line 256 "../../../src/core/desktop-file-service.vala"
	g_idle_add_full (G_PRIORITY_LOW, _synapse_desktop_file_service_initialize_co_gsource_func, _data_, NULL);
#line 257 "../../../src/core/desktop-file-service.vala"
	_data_->_state_ = 2;
#line 257 "../../../src/core/desktop-file-service.vala"
	return FALSE;
#line 2735 "desktop-file-service.c"
	_state_2:
	;
#line 259 "../../../src/core/desktop-file-service.vala"
	_data_->_state_ = 3;
#line 259 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_load_all_desktop_files (_data_->self, synapse_desktop_file_service_initialize_ready, _data_);
#line 259 "../../../src/core/desktop-file-service.vala"
	return FALSE;
#line 2744 "desktop-file-service.c"
	_state_3:
#line 259 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_load_all_desktop_files_finish (_data_->self, _data_->_res_);
#line 261 "../../../src/core/desktop-file-service.vala"
	_data_->_tmp3_ = _data_->self->priv->init_once;
#line 261 "../../../src/core/desktop-file-service.vala"
	synapse_utils_async_once_leave (_data_->_tmp3_, (gpointer) ((gintptr) TRUE));
#line 247 "../../../src/core/desktop-file-service.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 247 "../../../src/core/desktop-file-service.vala"
	if (_data_->_state_ != 0) {
#line 247 "../../../src/core/desktop-file-service.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 247 "../../../src/core/desktop-file-service.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2760 "desktop-file-service.c"
		}
	}
#line 247 "../../../src/core/desktop-file-service.vala"
	g_object_unref (_data_->_async_result);
#line 247 "../../../src/core/desktop-file-service.vala"
	return FALSE;
#line 2767 "desktop-file-service.c"
}

SynapseDesktopEnvironmentType
synapse_desktop_file_service_get_environment (SynapseDesktopFileService* self)
{
	SynapseDesktopEnvironmentType _tmp0_;
	SynapseDesktopEnvironmentType result = 0U;
#line 267 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 269 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = self->priv->session_type;
#line 269 "../../../src/core/desktop-file-service.vala"
	result = _tmp0_;
#line 269 "../../../src/core/desktop-file-service.vala"
	return result;
#line 2783 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_get_environment_type (SynapseDesktopFileService* self)
{
	const gchar* session_var = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* session = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
#line 272 "../../../src/core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 275 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = g_getenv ("XDG_CURRENT_DESKTOP");
#line 275 "../../../src/core/desktop-file-service.vala"
	session_var = _tmp0_;
#line 276 "../../../src/core/desktop-file-service.vala"
	_tmp1_ = session_var;
#line 276 "../../../src/core/desktop-file-service.vala"
	if (_tmp1_ == NULL) {
#line 2807 "desktop-file-service.c"
		const gchar* _tmp2_;
#line 278 "../../../src/core/desktop-file-service.vala"
		_tmp2_ = g_getenv ("DESKTOP_SESSION");
#line 278 "../../../src/core/desktop-file-service.vala"
		session_var = _tmp2_;
#line 2813 "desktop-file-service.c"
	}
#line 281 "../../../src/core/desktop-file-service.vala"
	_tmp3_ = session_var;
#line 281 "../../../src/core/desktop-file-service.vala"
	if (_tmp3_ == NULL) {
#line 281 "../../../src/core/desktop-file-service.vala"
		return;
#line 2821 "desktop-file-service.c"
	}
#line 283 "../../../src/core/desktop-file-service.vala"
	_tmp4_ = session_var;
#line 283 "../../../src/core/desktop-file-service.vala"
	_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
#line 283 "../../../src/core/desktop-file-service.vala"
	session = _tmp5_;
#line 285 "../../../src/core/desktop-file-service.vala"
	_tmp6_ = session;
#line 285 "../../../src/core/desktop-file-service.vala"
	if (g_str_has_prefix (_tmp6_, "ubuntu")) {
#line 287 "../../../src/core/desktop-file-service.vala"
		self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME;
#line 288 "../../../src/core/desktop-file-service.vala"
		self->priv->session_type_str = "Ubuntu";
#line 2837 "desktop-file-service.c"
	} else {
		const gchar* _tmp7_;
#line 290 "../../../src/core/desktop-file-service.vala"
		_tmp7_ = session;
#line 290 "../../../src/core/desktop-file-service.vala"
		if (g_str_has_prefix (_tmp7_, "unity")) {
#line 292 "../../../src/core/desktop-file-service.vala"
			self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_UNITY;
#line 293 "../../../src/core/desktop-file-service.vala"
			self->priv->session_type_str = "Unity";
#line 2848 "desktop-file-service.c"
		} else {
			const gchar* _tmp8_;
#line 295 "../../../src/core/desktop-file-service.vala"
			_tmp8_ = session;
#line 295 "../../../src/core/desktop-file-service.vala"
			if (g_str_has_prefix (_tmp8_, "kde")) {
#line 297 "../../../src/core/desktop-file-service.vala"
				self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_KDE;
#line 298 "../../../src/core/desktop-file-service.vala"
				self->priv->session_type_str = "KDE";
#line 2859 "desktop-file-service.c"
			} else {
				const gchar* _tmp9_;
#line 300 "../../../src/core/desktop-file-service.vala"
				_tmp9_ = session;
#line 300 "../../../src/core/desktop-file-service.vala"
				if (g_str_has_prefix (_tmp9_, "gnome")) {
#line 302 "../../../src/core/desktop-file-service.vala"
					self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME;
#line 303 "../../../src/core/desktop-file-service.vala"
					self->priv->session_type_str = "GNOME";
#line 2870 "desktop-file-service.c"
				} else {
					const gchar* _tmp10_;
#line 305 "../../../src/core/desktop-file-service.vala"
					_tmp10_ = session;
#line 305 "../../../src/core/desktop-file-service.vala"
					if (g_str_has_prefix (_tmp10_, "lx")) {
#line 307 "../../../src/core/desktop-file-service.vala"
						self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_LXDE;
#line 308 "../../../src/core/desktop-file-service.vala"
						self->priv->session_type_str = "LXDE";
#line 2881 "desktop-file-service.c"
					} else {
						const gchar* _tmp11_;
#line 310 "../../../src/core/desktop-file-service.vala"
						_tmp11_ = session;
#line 310 "../../../src/core/desktop-file-service.vala"
						if (g_str_has_prefix (_tmp11_, "xfce")) {
#line 312 "../../../src/core/desktop-file-service.vala"
							self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_XFCE;
#line 313 "../../../src/core/desktop-file-service.vala"
							self->priv->session_type_str = "XFCE";
#line 2892 "desktop-file-service.c"
						} else {
							const gchar* _tmp12_;
#line 315 "../../../src/core/desktop-file-service.vala"
							_tmp12_ = session;
#line 315 "../../../src/core/desktop-file-service.vala"
							if (g_str_has_prefix (_tmp12_, "mate")) {
#line 317 "../../../src/core/desktop-file-service.vala"
								self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_MATE;
#line 318 "../../../src/core/desktop-file-service.vala"
								self->priv->session_type_str = "MATE";
#line 2903 "desktop-file-service.c"
							} else {
								const gchar* _tmp13_;
#line 320 "../../../src/core/desktop-file-service.vala"
								_tmp13_ = session;
#line 320 "../../../src/core/desktop-file-service.vala"
								if (g_str_has_prefix (_tmp13_, "razor")) {
#line 322 "../../../src/core/desktop-file-service.vala"
									self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_RAZOR;
#line 323 "../../../src/core/desktop-file-service.vala"
									self->priv->session_type_str = "Razor";
#line 2914 "desktop-file-service.c"
								} else {
									const gchar* _tmp14_;
#line 325 "../../../src/core/desktop-file-service.vala"
									_tmp14_ = session;
#line 325 "../../../src/core/desktop-file-service.vala"
									if (g_str_has_prefix (_tmp14_, "tde")) {
#line 327 "../../../src/core/desktop-file-service.vala"
										self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_TDE;
#line 328 "../../../src/core/desktop-file-service.vala"
										self->priv->session_type_str = "TDE";
#line 2925 "desktop-file-service.c"
									} else {
										const gchar* _tmp15_;
#line 330 "../../../src/core/desktop-file-service.vala"
										_tmp15_ = session;
#line 330 "../../../src/core/desktop-file-service.vala"
										if (g_str_has_prefix (_tmp15_, "rox")) {
#line 332 "../../../src/core/desktop-file-service.vala"
											self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_ROX;
#line 333 "../../../src/core/desktop-file-service.vala"
											self->priv->session_type_str = "ROX";
#line 2936 "desktop-file-service.c"
										} else {
											const gchar* _tmp16_;
#line 335 "../../../src/core/desktop-file-service.vala"
											_tmp16_ = session;
#line 335 "../../../src/core/desktop-file-service.vala"
											if (g_str_has_prefix (_tmp16_, "ede")) {
#line 337 "../../../src/core/desktop-file-service.vala"
												self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_EDE;
#line 338 "../../../src/core/desktop-file-service.vala"
												self->priv->session_type_str = "EDE";
#line 2947 "desktop-file-service.c"
											} else {
												const gchar* _tmp17_;
#line 340 "../../../src/core/desktop-file-service.vala"
												_tmp17_ = session;
#line 340 "../../../src/core/desktop-file-service.vala"
												if (g_str_has_prefix (_tmp17_, "cinnamon")) {
#line 342 "../../../src/core/desktop-file-service.vala"
													self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_CINNAMON;
#line 343 "../../../src/core/desktop-file-service.vala"
													self->priv->session_type_str = "Cinnamon";
#line 2958 "desktop-file-service.c"
												} else {
													const gchar* _tmp18_;
#line 345 "../../../src/core/desktop-file-service.vala"
													_tmp18_ = session;
#line 345 "../../../src/core/desktop-file-service.vala"
													if (g_str_has_prefix (_tmp18_, "pantheon")) {
#line 347 "../../../src/core/desktop-file-service.vala"
														self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_PANTHEON;
#line 348 "../../../src/core/desktop-file-service.vala"
														self->priv->session_type_str = "Pantheon";
#line 2969 "desktop-file-service.c"
													} else {
#line 352 "../../../src/core/desktop-file-service.vala"
														g_warning ("desktop-file-service.vala:352: Desktop session type is not recognized," \
" assuming GNOME.");
#line 2973 "desktop-file-service.c"
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
#line 272 "../../../src/core/desktop-file-service.vala"
	_g_free0 (session);
#line 2989 "desktop-file-service.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1535 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 3011 "desktop-file-service.c"
	} else {
#line 1535 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 3015 "desktop-file-service.c"
	}
#line 1535 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1535 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 3021 "desktop-file-service.c"
	} else {
#line 1535 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 3025 "desktop-file-service.c"
	}
#line 1535 "glib-2.0.vapi"
	if (_tmp0_) {
#line 3029 "desktop-file-service.c"
		gchar* _tmp2_;
#line 1536 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1536 "glib-2.0.vapi"
		result = _tmp2_;
#line 1536 "glib-2.0.vapi"
		return result;
#line 3037 "desktop-file-service.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1539 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1539 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1539 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1539 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1539 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1539 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1539 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1539 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 3065 "desktop-file-service.c"
				goto __catch0_g_regex_error;
			}
#line 1539 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1539 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1539 "glib-2.0.vapi"
			return NULL;
#line 3074 "desktop-file-service.c"
		}
#line 1540 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1540 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1540 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1540 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1540 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1540 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 3088 "desktop-file-service.c"
				goto __catch0_g_regex_error;
			}
#line 1540 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1540 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1540 "glib-2.0.vapi"
			return NULL;
#line 3097 "desktop-file-service.c"
		}
#line 1540 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1540 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1540 "glib-2.0.vapi"
		result = _tmp10_;
#line 1540 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1540 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1540 "glib-2.0.vapi"
		return result;
#line 3111 "desktop-file-service.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1538 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1542 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 3120 "desktop-file-service.c"
	}
	__finally0:
#line 1538 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1538 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1538 "glib-2.0.vapi"
	return NULL;
#line 3129 "desktop-file-service.c"
}

static gchar*
synapse_desktop_file_service_get_cache_file_name (SynapseDesktopFileService* self,
                                                  const gchar* dir_name)
{
	const gchar* locale = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* filename = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result = NULL;
#line 356 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 356 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (dir_name != NULL, NULL);
#line 359 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = setlocale (LC_MESSAGES, NULL);
#line 359 "../../../src/core/desktop-file-service.vala"
	locale = _tmp0_;
#line 360 "../../../src/core/desktop-file-service.vala"
	_tmp1_ = locale;
#line 360 "../../../src/core/desktop-file-service.vala"
	if (_tmp1_ == NULL) {
#line 360 "../../../src/core/desktop-file-service.vala"
		result = NULL;
#line 360 "../../../src/core/desktop-file-service.vala"
		return result;
#line 3164 "desktop-file-service.c"
	}
#line 364 "../../../src/core/desktop-file-service.vala"
	_tmp2_ = locale;
#line 364 "../../../src/core/desktop-file-service.vala"
	_tmp3_ = string_replace (_tmp2_, ".UTF-8", ".utf8");
#line 364 "../../../src/core/desktop-file-service.vala"
	_tmp4_ = _tmp3_;
#line 364 "../../../src/core/desktop-file-service.vala"
	_tmp5_ = g_strdup_printf ("desktop.%s.cache", _tmp4_);
#line 364 "../../../src/core/desktop-file-service.vala"
	_tmp6_ = _tmp5_;
#line 364 "../../../src/core/desktop-file-service.vala"
	_g_free0 (_tmp4_);
#line 364 "../../../src/core/desktop-file-service.vala"
	filename = _tmp6_;
#line 367 "../../../src/core/desktop-file-service.vala"
	_tmp7_ = filename;
#line 367 "../../../src/core/desktop-file-service.vala"
	_tmp8_ = g_build_filename (dir_name, _tmp7_, NULL, NULL);
#line 367 "../../../src/core/desktop-file-service.vala"
	result = _tmp8_;
#line 367 "../../../src/core/desktop-file-service.vala"
	_g_free0 (filename);
#line 367 "../../../src/core/desktop-file-service.vala"
	return result;
#line 3190 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_process_directory_data_free (gpointer _data)
{
	SynapseDesktopFileServiceProcessDirectoryData* _data_;
	_data_ = _data;
#line 206 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (_data_->directory);
#line 206 "../../../src/core/desktop-file-service.vala"
	_g_free0 (_data_->id_prefix);
#line 206 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (_data_->monitored_dirs);
#line 206 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (_data_->self);
#line 206 "../../../src/core/desktop-file-service.vala"
	g_slice_free (SynapseDesktopFileServiceProcessDirectoryData, _data_);
#line 3208 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_process_directory (SynapseDesktopFileService* self,
                                                GFile* directory,
                                                const gchar* id_prefix,
                                                GeeSet* monitored_dirs,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	SynapseDesktopFileServiceProcessDirectoryData* _data_;
	SynapseDesktopFileService* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	GeeSet* _tmp3_;
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_ = g_slice_new0 (SynapseDesktopFileServiceProcessDirectoryData);
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 206 "../../../src/core/desktop-file-service.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_process_directory_data_free);
#line 206 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_->self = _tmp0_;
#line 206 "../../../src/core/desktop-file-service.vala"
	_tmp1_ = _g_object_ref0 (directory);
#line 206 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (_data_->directory);
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_->directory = _tmp1_;
#line 206 "../../../src/core/desktop-file-service.vala"
	_tmp2_ = g_strdup (id_prefix);
#line 206 "../../../src/core/desktop-file-service.vala"
	_g_free0 (_data_->id_prefix);
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_->id_prefix = _tmp2_;
#line 206 "../../../src/core/desktop-file-service.vala"
	_tmp3_ = _g_object_ref0 (monitored_dirs);
#line 206 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (_data_->monitored_dirs);
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_->monitored_dirs = _tmp3_;
#line 206 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_process_directory_co (_data_);
#line 3254 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_process_directory_finish (SynapseDesktopFileService* self,
                                                       GAsyncResult* _res_)
{
	SynapseDesktopFileServiceProcessDirectoryData* _data_;
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3264 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_process_directory_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	SynapseDesktopFileServiceProcessDirectoryData* _data_;
#line 383 "../../../src/core/desktop-file-service.vala"
	_data_ = _user_data_;
#line 383 "../../../src/core/desktop-file-service.vala"
	_data_->_source_object_ = source_object;
#line 383 "../../../src/core/desktop-file-service.vala"
	_data_->_res_ = _res_;
#line 383 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_process_directory_co (_data_);
#line 3281 "desktop-file-service.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 374 "../../../src/core/desktop-file-service.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 3289 "desktop-file-service.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 374 "../../../src/core/desktop-file-service.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 3297 "desktop-file-service.c"
}

static gboolean
synapse_desktop_file_service_process_directory_co (SynapseDesktopFileServiceProcessDirectoryData* _data_)
{
#line 370 "../../../src/core/desktop-file-service.vala"
	switch (_data_->_state_) {
#line 370 "../../../src/core/desktop-file-service.vala"
		case 0:
#line 3307 "desktop-file-service.c"
		goto _state_0;
#line 370 "../../../src/core/desktop-file-service.vala"
		case 1:
#line 3311 "desktop-file-service.c"
		goto _state_1;
#line 370 "../../../src/core/desktop-file-service.vala"
		case 2:
#line 3315 "desktop-file-service.c"
		goto _state_2;
#line 370 "../../../src/core/desktop-file-service.vala"
		case 3:
#line 3319 "desktop-file-service.c"
		goto _state_3;
#line 370 "../../../src/core/desktop-file-service.vala"
		case 4:
#line 3323 "desktop-file-service.c"
		goto _state_4;
#line 370 "../../../src/core/desktop-file-service.vala"
		case 5:
#line 3327 "desktop-file-service.c"
		goto _state_5;
		default:
#line 370 "../../../src/core/desktop-file-service.vala"
		g_assert_not_reached ();
#line 3332 "desktop-file-service.c"
	}
	_state_0:
	{
#line 376 "../../../src/core/desktop-file-service.vala"
		_data_->_tmp0_ = g_file_get_path (_data_->directory);
#line 376 "../../../src/core/desktop-file-service.vala"
		_data_->path = _data_->_tmp0_;
#line 378 "../../../src/core/desktop-file-service.vala"
		_data_->_tmp2_ = _data_->path;
#line 378 "../../../src/core/desktop-file-service.vala"
		if (_data_->_tmp2_ != NULL) {
#line 378 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp3_ = _data_->path;
#line 378 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp1_ = g_str_has_suffix (_data_->_tmp3_, "menu-xdg");
#line 3348 "desktop-file-service.c"
		} else {
#line 378 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp1_ = FALSE;
#line 3352 "desktop-file-service.c"
		}
#line 378 "../../../src/core/desktop-file-service.vala"
		if (_data_->_tmp1_) {
#line 378 "../../../src/core/desktop-file-service.vala"
			_g_free0 (_data_->path);
#line 378 "../../../src/core/desktop-file-service.vala"
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 378 "../../../src/core/desktop-file-service.vala"
			if (_data_->_state_ != 0) {
#line 378 "../../../src/core/desktop-file-service.vala"
				while (!g_task_get_completed (_data_->_async_result)) {
#line 378 "../../../src/core/desktop-file-service.vala"
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3366 "desktop-file-service.c"
				}
			}
#line 378 "../../../src/core/desktop-file-service.vala"
			g_object_unref (_data_->_async_result);
#line 378 "../../../src/core/desktop-file-service.vala"
			return FALSE;
#line 3373 "desktop-file-service.c"
		}
#line 380 "../../../src/core/desktop-file-service.vala"
		_data_->_tmp5_ = _data_->path;
#line 380 "../../../src/core/desktop-file-service.vala"
		if (_data_->_tmp5_ != NULL) {
#line 380 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp6_ = _data_->path;
#line 380 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp4_ = g_str_has_suffix (_data_->_tmp6_, "/screensavers");
#line 3383 "desktop-file-service.c"
		} else {
#line 380 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp4_ = FALSE;
#line 3387 "desktop-file-service.c"
		}
#line 380 "../../../src/core/desktop-file-service.vala"
		if (_data_->_tmp4_) {
#line 380 "../../../src/core/desktop-file-service.vala"
			_g_free0 (_data_->path);
#line 380 "../../../src/core/desktop-file-service.vala"
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 380 "../../../src/core/desktop-file-service.vala"
			if (_data_->_state_ != 0) {
#line 380 "../../../src/core/desktop-file-service.vala"
				while (!g_task_get_completed (_data_->_async_result)) {
#line 380 "../../../src/core/desktop-file-service.vala"
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3401 "desktop-file-service.c"
				}
			}
#line 380 "../../../src/core/desktop-file-service.vala"
			g_object_unref (_data_->_async_result);
#line 380 "../../../src/core/desktop-file-service.vala"
			return FALSE;
#line 3408 "desktop-file-service.c"
		}
#line 382 "../../../src/core/desktop-file-service.vala"
		_data_->_tmp7_ = _data_->path;
#line 382 "../../../src/core/desktop-file-service.vala"
		g_debug ("desktop-file-service.vala:382: Searching for desktop files in: %s", _data_->_tmp7_);
#line 383 "../../../src/core/desktop-file-service.vala"
		_data_->_state_ = 1;
#line 383 "../../../src/core/desktop-file-service.vala"
		synapse_utils_query_exists_async (_data_->directory, synapse_desktop_file_service_process_directory_ready, _data_);
#line 383 "../../../src/core/desktop-file-service.vala"
		return FALSE;
#line 3420 "desktop-file-service.c"
		_state_1:
#line 383 "../../../src/core/desktop-file-service.vala"
		_data_->exists = synapse_utils_query_exists_finish (_data_->_res_);
#line 384 "../../../src/core/desktop-file-service.vala"
		if (!_data_->exists) {
#line 384 "../../../src/core/desktop-file-service.vala"
			_g_free0 (_data_->path);
#line 384 "../../../src/core/desktop-file-service.vala"
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 384 "../../../src/core/desktop-file-service.vala"
			if (_data_->_state_ != 0) {
#line 384 "../../../src/core/desktop-file-service.vala"
				while (!g_task_get_completed (_data_->_async_result)) {
#line 384 "../../../src/core/desktop-file-service.vala"
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3436 "desktop-file-service.c"
				}
			}
#line 384 "../../../src/core/desktop-file-service.vala"
			g_object_unref (_data_->_async_result);
#line 384 "../../../src/core/desktop-file-service.vala"
			return FALSE;
#line 3443 "desktop-file-service.c"
		}
		{
#line 386 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp8_ = gee_iterable_iterator ((GeeIterable*) _data_->monitored_dirs);
#line 386 "../../../src/core/desktop-file-service.vala"
			_data_->_scanned_dir_it = _data_->_tmp8_;
#line 386 "../../../src/core/desktop-file-service.vala"
			while (TRUE) {
#line 386 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp9_ = _data_->_scanned_dir_it;
#line 386 "../../../src/core/desktop-file-service.vala"
				if (!gee_iterator_next (_data_->_tmp9_)) {
#line 386 "../../../src/core/desktop-file-service.vala"
					break;
#line 3458 "desktop-file-service.c"
				}
#line 386 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp10_ = _data_->_scanned_dir_it;
#line 386 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp11_ = gee_iterator_get (_data_->_tmp10_);
#line 386 "../../../src/core/desktop-file-service.vala"
				_data_->scanned_dir = (GFile*) _data_->_tmp11_;
#line 388 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp12_ = _data_->path;
#line 388 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp13_ = _data_->scanned_dir;
#line 388 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp14_ = g_file_get_path (_data_->_tmp13_);
#line 388 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp15_ = _data_->_tmp14_;
#line 388 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp16_ = g_strcmp0 (_data_->_tmp12_, _data_->_tmp15_) == 0;
#line 388 "../../../src/core/desktop-file-service.vala"
				_g_free0 (_data_->_tmp15_);
#line 388 "../../../src/core/desktop-file-service.vala"
				if (_data_->_tmp16_) {
#line 388 "../../../src/core/desktop-file-service.vala"
					_g_object_unref0 (_data_->scanned_dir);
#line 388 "../../../src/core/desktop-file-service.vala"
					_g_object_unref0 (_data_->_scanned_dir_it);
#line 388 "../../../src/core/desktop-file-service.vala"
					_g_free0 (_data_->path);
#line 388 "../../../src/core/desktop-file-service.vala"
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 388 "../../../src/core/desktop-file-service.vala"
					if (_data_->_state_ != 0) {
#line 388 "../../../src/core/desktop-file-service.vala"
						while (!g_task_get_completed (_data_->_async_result)) {
#line 388 "../../../src/core/desktop-file-service.vala"
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3494 "desktop-file-service.c"
						}
					}
#line 388 "../../../src/core/desktop-file-service.vala"
					g_object_unref (_data_->_async_result);
#line 388 "../../../src/core/desktop-file-service.vala"
					return FALSE;
#line 3501 "desktop-file-service.c"
				}
#line 386 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (_data_->scanned_dir);
#line 3505 "desktop-file-service.c"
			}
#line 386 "../../../src/core/desktop-file-service.vala"
			_g_object_unref0 (_data_->_scanned_dir_it);
#line 3509 "desktop-file-service.c"
		}
#line 390 "../../../src/core/desktop-file-service.vala"
		gee_collection_add ((GeeCollection*) _data_->monitored_dirs, _data_->directory);
#line 391 "../../../src/core/desktop-file-service.vala"
		_data_->_state_ = 2;
#line 391 "../../../src/core/desktop-file-service.vala"
		g_file_enumerate_children_async (_data_->directory, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE, 0, 0, NULL, synapse_desktop_file_service_process_directory_ready, _data_);
#line 391 "../../../src/core/desktop-file-service.vala"
		return FALSE;
#line 3519 "desktop-file-service.c"
		_state_2:
#line 391 "../../../src/core/desktop-file-service.vala"
		_data_->_tmp17_ = g_file_enumerate_children_finish (_data_->directory, _data_->_res_, &_data_->_inner_error0_);
#line 391 "../../../src/core/desktop-file-service.vala"
		_data_->enumerator = _data_->_tmp17_;
#line 391 "../../../src/core/desktop-file-service.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 391 "../../../src/core/desktop-file-service.vala"
			_g_free0 (_data_->path);
#line 3529 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 394 "../../../src/core/desktop-file-service.vala"
		_data_->_tmp18_ = _data_->enumerator;
#line 394 "../../../src/core/desktop-file-service.vala"
		_data_->_state_ = 3;
#line 394 "../../../src/core/desktop-file-service.vala"
		g_file_enumerator_next_files_async (_data_->_tmp18_, 1024, 0, NULL, synapse_desktop_file_service_process_directory_ready, _data_);
#line 394 "../../../src/core/desktop-file-service.vala"
		return FALSE;
#line 3540 "desktop-file-service.c"
		_state_3:
#line 394 "../../../src/core/desktop-file-service.vala"
		_data_->_tmp19_ = g_file_enumerator_next_files_finish (_data_->_tmp18_, _data_->_res_, &_data_->_inner_error0_);
#line 394 "../../../src/core/desktop-file-service.vala"
		_data_->files = _data_->_tmp19_;
#line 394 "../../../src/core/desktop-file-service.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 394 "../../../src/core/desktop-file-service.vala"
			_g_object_unref0 (_data_->enumerator);
#line 394 "../../../src/core/desktop-file-service.vala"
			_g_free0 (_data_->path);
#line 3552 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 395 "../../../src/core/desktop-file-service.vala"
		_data_->_tmp20_ = _data_->files;
#line 3557 "desktop-file-service.c"
		{
#line 395 "../../../src/core/desktop-file-service.vala"
			_data_->f_collection = _data_->_tmp20_;
#line 395 "../../../src/core/desktop-file-service.vala"
			for (_data_->f_it = _data_->f_collection; _data_->f_it != NULL; _data_->f_it = _data_->f_it->next) {
#line 395 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp21_ = _g_object_ref0 ((GFileInfo*) _data_->f_it->data);
#line 395 "../../../src/core/desktop-file-service.vala"
				_data_->f = _data_->_tmp21_;
#line 3567 "desktop-file-service.c"
				{
#line 397 "../../../src/core/desktop-file-service.vala"
					_data_->_tmp22_ = _data_->f;
#line 397 "../../../src/core/desktop-file-service.vala"
					_data_->_tmp23_ = g_file_info_get_name (_data_->_tmp22_);
#line 397 "../../../src/core/desktop-file-service.vala"
					_data_->name = _data_->_tmp23_;
#line 398 "../../../src/core/desktop-file-service.vala"
					_data_->_tmp24_ = _data_->f;
#line 398 "../../../src/core/desktop-file-service.vala"
					if (g_file_info_get_file_type (_data_->_tmp24_) == G_FILE_TYPE_DIRECTORY) {
#line 401 "../../../src/core/desktop-file-service.vala"
						_data_->_tmp25_ = _data_->name;
#line 401 "../../../src/core/desktop-file-service.vala"
						_data_->_tmp26_ = g_file_get_child (_data_->directory, _data_->_tmp25_);
#line 401 "../../../src/core/desktop-file-service.vala"
						_data_->subdir = _data_->_tmp26_;
#line 402 "../../../src/core/desktop-file-service.vala"
						_data_->_tmp27_ = _data_->subdir;
#line 402 "../../../src/core/desktop-file-service.vala"
						_data_->_tmp28_ = g_file_get_basename (_data_->_tmp27_);
#line 402 "../../../src/core/desktop-file-service.vala"
						_data_->_tmp29_ = _data_->_tmp28_;
#line 402 "../../../src/core/desktop-file-service.vala"
						_data_->_tmp30_ = g_strdup_printf ("%s%s-", _data_->id_prefix, _data_->_tmp29_);
#line 402 "../../../src/core/desktop-file-service.vala"
						_data_->_tmp31_ = _data_->_tmp30_;
#line 402 "../../../src/core/desktop-file-service.vala"
						_g_free0 (_data_->_tmp29_);
#line 402 "../../../src/core/desktop-file-service.vala"
						_data_->new_prefix = _data_->_tmp31_;
#line 403 "../../../src/core/desktop-file-service.vala"
						_data_->_tmp32_ = _data_->subdir;
#line 403 "../../../src/core/desktop-file-service.vala"
						_data_->_tmp33_ = _data_->new_prefix;
#line 403 "../../../src/core/desktop-file-service.vala"
						_data_->_state_ = 4;
#line 403 "../../../src/core/desktop-file-service.vala"
						synapse_desktop_file_service_process_directory (_data_->self, _data_->_tmp32_, _data_->_tmp33_, _data_->monitored_dirs, synapse_desktop_file_service_process_directory_ready, _data_);
#line 403 "../../../src/core/desktop-file-service.vala"
						return FALSE;
#line 3609 "desktop-file-service.c"
						_state_4:
#line 403 "../../../src/core/desktop-file-service.vala"
						synapse_desktop_file_service_process_directory_finish (_data_->self, _data_->_res_);
#line 398 "../../../src/core/desktop-file-service.vala"
						_g_free0 (_data_->new_prefix);
#line 398 "../../../src/core/desktop-file-service.vala"
						_g_object_unref0 (_data_->subdir);
#line 3617 "desktop-file-service.c"
					} else {
#line 408 "../../../src/core/desktop-file-service.vala"
						_data_->_tmp34_ = _data_->name;
#line 408 "../../../src/core/desktop-file-service.vala"
						if (g_str_has_suffix (_data_->_tmp34_, "synapse.desktop")) {
#line 408 "../../../src/core/desktop-file-service.vala"
							_g_object_unref0 (_data_->f);
#line 408 "../../../src/core/desktop-file-service.vala"
							continue;
#line 3627 "desktop-file-service.c"
						}
#line 409 "../../../src/core/desktop-file-service.vala"
						_data_->_tmp35_ = _data_->name;
#line 409 "../../../src/core/desktop-file-service.vala"
						if (g_str_has_suffix (_data_->_tmp35_, ".desktop")) {
#line 411 "../../../src/core/desktop-file-service.vala"
							_data_->_tmp36_ = _data_->name;
#line 411 "../../../src/core/desktop-file-service.vala"
							_data_->_tmp37_ = g_file_get_child (_data_->directory, _data_->_tmp36_);
#line 411 "../../../src/core/desktop-file-service.vala"
							_data_->_tmp38_ = _data_->_tmp37_;
#line 411 "../../../src/core/desktop-file-service.vala"
							_data_->_state_ = 5;
#line 411 "../../../src/core/desktop-file-service.vala"
							synapse_desktop_file_service_load_desktop_file (_data_->self, _data_->_tmp38_, _data_->id_prefix, synapse_desktop_file_service_process_directory_ready, _data_);
#line 411 "../../../src/core/desktop-file-service.vala"
							return FALSE;
#line 3645 "desktop-file-service.c"
							_state_5:
#line 411 "../../../src/core/desktop-file-service.vala"
							synapse_desktop_file_service_load_desktop_file_finish (_data_->self, _data_->_res_);
#line 411 "../../../src/core/desktop-file-service.vala"
							_g_object_unref0 (_data_->_tmp38_);
#line 3651 "desktop-file-service.c"
						}
					}
#line 395 "../../../src/core/desktop-file-service.vala"
					_g_object_unref0 (_data_->f);
#line 3656 "desktop-file-service.c"
				}
			}
		}
#line 374 "../../../src/core/desktop-file-service.vala"
		(_data_->files == NULL) ? NULL : (_data_->files = (_g_list_free__g_object_unref0_ (_data_->files), NULL));
#line 374 "../../../src/core/desktop-file-service.vala"
		_g_object_unref0 (_data_->enumerator);
#line 374 "../../../src/core/desktop-file-service.vala"
		_g_free0 (_data_->path);
#line 3666 "desktop-file-service.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 374 "../../../src/core/desktop-file-service.vala"
		_data_->err = _data_->_inner_error0_;
#line 374 "../../../src/core/desktop-file-service.vala"
		_data_->_inner_error0_ = NULL;
#line 418 "../../../src/core/desktop-file-service.vala"
		_data_->_tmp39_ = _data_->err;
#line 418 "../../../src/core/desktop-file-service.vala"
		_data_->_tmp40_ = _data_->_tmp39_->message;
#line 418 "../../../src/core/desktop-file-service.vala"
		g_warning ("desktop-file-service.vala:418: %s", _data_->_tmp40_);
#line 374 "../../../src/core/desktop-file-service.vala"
		_g_error_free0 (_data_->err);
#line 3683 "desktop-file-service.c"
	}
	__finally0:
#line 374 "../../../src/core/desktop-file-service.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 374 "../../../src/core/desktop-file-service.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 374 "../../../src/core/desktop-file-service.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 374 "../../../src/core/desktop-file-service.vala"
		g_object_unref (_data_->_async_result);
#line 374 "../../../src/core/desktop-file-service.vala"
		return FALSE;
#line 3696 "desktop-file-service.c"
	}
#line 370 "../../../src/core/desktop-file-service.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 370 "../../../src/core/desktop-file-service.vala"
	if (_data_->_state_ != 0) {
#line 370 "../../../src/core/desktop-file-service.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 370 "../../../src/core/desktop-file-service.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3706 "desktop-file-service.c"
		}
	}
#line 370 "../../../src/core/desktop-file-service.vala"
	g_object_unref (_data_->_async_result);
#line 370 "../../../src/core/desktop-file-service.vala"
	return FALSE;
#line 3713 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_all_desktop_files_data_free (gpointer _data)
{
	SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_;
	_data_ = _data;
#line 206 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (_data_->self);
#line 206 "../../../src/core/desktop-file-service.vala"
	g_slice_free (SynapseDesktopFileServiceLoadAllDesktopFilesData, _data_);
#line 3725 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_all_desktop_files (SynapseDesktopFileService* self,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_;
	SynapseDesktopFileService* _tmp0_;
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_ = g_slice_new0 (SynapseDesktopFileServiceLoadAllDesktopFilesData);
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 206 "../../../src/core/desktop-file-service.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_load_all_desktop_files_data_free);
#line 206 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_->self = _tmp0_;
#line 206 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_load_all_desktop_files_co (_data_);
#line 3747 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_all_desktop_files_finish (SynapseDesktopFileService* self,
                                                            GAsyncResult* _res_)
{
	SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_;
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3757 "desktop-file-service.c"
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gint length)
{
#line 424 "../../../src/core/desktop-file-service.vala"
	if (length >= 0) {
#line 3766 "desktop-file-service.c"
		gchar** result;
		gint i;
#line 424 "../../../src/core/desktop-file-service.vala"
		result = g_new0 (gchar*, length + 1);
#line 424 "../../../src/core/desktop-file-service.vala"
		for (i = 0; i < length; i++) {
#line 3773 "desktop-file-service.c"
			gchar* _tmp0_;
#line 424 "../../../src/core/desktop-file-service.vala"
			_tmp0_ = g_strdup (self[i]);
#line 424 "../../../src/core/desktop-file-service.vala"
			result[i] = _tmp0_;
#line 3779 "desktop-file-service.c"
		}
#line 424 "../../../src/core/desktop-file-service.vala"
		return result;
#line 3783 "desktop-file-service.c"
	}
#line 424 "../../../src/core/desktop-file-service.vala"
	return NULL;
#line 3787 "desktop-file-service.c"
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 425 "../../../src/core/desktop-file-service.vala"
	if ((*length) == (*size)) {
#line 425 "../../../src/core/desktop-file-service.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 425 "../../../src/core/desktop-file-service.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 3802 "desktop-file-service.c"
	}
#line 425 "../../../src/core/desktop-file-service.vala"
	(*array)[(*length)++] = value;
#line 425 "../../../src/core/desktop-file-service.vala"
	(*array)[*length] = NULL;
#line 3808 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_all_desktop_files_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_;
#line 435 "../../../src/core/desktop-file-service.vala"
	_data_ = _user_data_;
#line 435 "../../../src/core/desktop-file-service.vala"
	_data_->_source_object_ = source_object;
#line 435 "../../../src/core/desktop-file-service.vala"
	_data_->_res_ = _res_;
#line 435 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_load_all_desktop_files_co (_data_);
#line 3825 "desktop-file-service.c"
}

static void
_synapse_desktop_file_service_desktop_file_directory_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                                     GFile* file,
                                                                                     GFile* other_file,
                                                                                     GFileMonitorEvent event_type,
                                                                                     gpointer self)
{
#line 448 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_desktop_file_directory_changed ((SynapseDesktopFileService*) self);
#line 3837 "desktop-file-service.c"
}

static gboolean
synapse_desktop_file_service_load_all_desktop_files_co (SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_)
{
#line 422 "../../../src/core/desktop-file-service.vala"
	switch (_data_->_state_) {
#line 422 "../../../src/core/desktop-file-service.vala"
		case 0:
#line 3847 "desktop-file-service.c"
		goto _state_0;
#line 422 "../../../src/core/desktop-file-service.vala"
		case 1:
#line 3851 "desktop-file-service.c"
		goto _state_1;
#line 422 "../../../src/core/desktop-file-service.vala"
		case 2:
#line 3855 "desktop-file-service.c"
		goto _state_2;
		default:
#line 422 "../../../src/core/desktop-file-service.vala"
		g_assert_not_reached ();
#line 3860 "desktop-file-service.c"
	}
	_state_0:
#line 424 "../../../src/core/desktop-file-service.vala"
	_data_->_tmp1_ = _data_->_tmp0_ = g_get_system_data_dirs ();
#line 424 "../../../src/core/desktop-file-service.vala"
	_data_->_tmp2_ = (_data_->_tmp1_ != NULL) ? _vala_array_dup2 (_data_->_tmp1_, _vala_array_length (_data_->_tmp0_)) : ((gpointer) _data_->_tmp1_);
#line 424 "../../../src/core/desktop-file-service.vala"
	_data_->_tmp2__length1 = _vala_array_length (_data_->_tmp0_);
#line 424 "../../../src/core/desktop-file-service.vala"
	_data_->data_dirs = _data_->_tmp2_;
#line 424 "../../../src/core/desktop-file-service.vala"
	_data_->data_dirs_length1 = _data_->_tmp2__length1;
#line 424 "../../../src/core/desktop-file-service.vala"
	_data_->_data_dirs_size_ = _data_->data_dirs_length1;
#line 425 "../../../src/core/desktop-file-service.vala"
	_data_->_tmp3_ = g_get_user_data_dir ();
#line 425 "../../../src/core/desktop-file-service.vala"
	_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
#line 425 "../../../src/core/desktop-file-service.vala"
	_vala_array_add5 (&_data_->data_dirs, &_data_->data_dirs_length1, &_data_->_data_dirs_size_, _data_->_tmp4_);
#line 427 "../../../src/core/desktop-file-service.vala"
	_data_->_tmp5_ = gee_hash_set_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 427 "../../../src/core/desktop-file-service.vala"
	_data_->desktop_file_dirs = (GeeSet*) _data_->_tmp5_;
#line 429 "../../../src/core/desktop-file-service.vala"
	_data_->_tmp6_ = _data_->self->priv->mimetype_parent_map;
#line 429 "../../../src/core/desktop-file-service.vala"
	gee_multi_map_clear (_data_->_tmp6_);
#line 431 "../../../src/core/desktop-file-service.vala"
	_data_->_tmp7_ = _data_->data_dirs;
#line 431 "../../../src/core/desktop-file-service.vala"
	_data_->_tmp7__length1 = _data_->data_dirs_length1;
#line 3893 "desktop-file-service.c"
	{
#line 431 "../../../src/core/desktop-file-service.vala"
		_data_->data_dir_collection_length1 = 0;
#line 431 "../../../src/core/desktop-file-service.vala"
		_data_->_data_dir_collection_size_ = 0;
#line 431 "../../../src/core/desktop-file-service.vala"
		_data_->data_dir_collection = _data_->_tmp7_;
#line 431 "../../../src/core/desktop-file-service.vala"
		_data_->data_dir_collection_length1 = _data_->_tmp7__length1;
#line 431 "../../../src/core/desktop-file-service.vala"
		for (_data_->data_dir_it = 0; _data_->data_dir_it < _data_->data_dir_collection_length1; _data_->data_dir_it = _data_->data_dir_it + 1) {
#line 431 "../../../src/core/desktop-file-service.vala"
			_data_->data_dir = _data_->data_dir_collection[_data_->data_dir_it];
#line 3907 "desktop-file-service.c"
			{
#line 433 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp8_ = _data_->data_dir;
#line 433 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp9_ = g_build_filename (_data_->_tmp8_, "applications", NULL, NULL);
#line 433 "../../../src/core/desktop-file-service.vala"
				_data_->dir_path = _data_->_tmp9_;
#line 434 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp10_ = _data_->dir_path;
#line 434 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp11_ = g_file_new_for_path (_data_->_tmp10_);
#line 434 "../../../src/core/desktop-file-service.vala"
				_data_->directory = _data_->_tmp11_;
#line 435 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp12_ = _data_->directory;
#line 435 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp13_ = _data_->desktop_file_dirs;
#line 435 "../../../src/core/desktop-file-service.vala"
				_data_->_state_ = 1;
#line 435 "../../../src/core/desktop-file-service.vala"
				synapse_desktop_file_service_process_directory (_data_->self, _data_->_tmp12_, "", _data_->_tmp13_, synapse_desktop_file_service_load_all_desktop_files_ready, _data_);
#line 435 "../../../src/core/desktop-file-service.vala"
				return FALSE;
#line 3931 "desktop-file-service.c"
				_state_1:
#line 435 "../../../src/core/desktop-file-service.vala"
				synapse_desktop_file_service_process_directory_finish (_data_->self, _data_->_res_);
#line 436 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp14_ = _data_->data_dir;
#line 436 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp15_ = g_build_filename (_data_->_tmp14_, "mime", "subclasses", NULL);
#line 436 "../../../src/core/desktop-file-service.vala"
				_g_free0 (_data_->dir_path);
#line 436 "../../../src/core/desktop-file-service.vala"
				_data_->dir_path = _data_->_tmp15_;
#line 437 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp16_ = _data_->dir_path;
#line 437 "../../../src/core/desktop-file-service.vala"
				_data_->_state_ = 2;
#line 437 "../../../src/core/desktop-file-service.vala"
				synapse_desktop_file_service_load_mime_parents_from_file (_data_->self, _data_->_tmp16_, synapse_desktop_file_service_load_all_desktop_files_ready, _data_);
#line 437 "../../../src/core/desktop-file-service.vala"
				return FALSE;
#line 3951 "desktop-file-service.c"
				_state_2:
#line 437 "../../../src/core/desktop-file-service.vala"
				synapse_desktop_file_service_load_mime_parents_from_file_finish (_data_->self, _data_->_res_);
#line 431 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (_data_->directory);
#line 431 "../../../src/core/desktop-file-service.vala"
				_g_free0 (_data_->dir_path);
#line 3959 "desktop-file-service.c"
			}
		}
	}
#line 440 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_create_indices (_data_->self);
#line 442 "../../../src/core/desktop-file-service.vala"
	_data_->_tmp17_ = gee_array_list_new (g_file_monitor_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 442 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (_data_->self->priv->directory_monitors);
#line 442 "../../../src/core/desktop-file-service.vala"
	_data_->self->priv->directory_monitors = (GeeList*) _data_->_tmp17_;
#line 3971 "desktop-file-service.c"
	{
#line 443 "../../../src/core/desktop-file-service.vala"
		_data_->_tmp18_ = _data_->desktop_file_dirs;
#line 443 "../../../src/core/desktop-file-service.vala"
		_data_->_tmp19_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp18_);
#line 443 "../../../src/core/desktop-file-service.vala"
		_data_->_d_it = _data_->_tmp19_;
#line 443 "../../../src/core/desktop-file-service.vala"
		while (TRUE) {
#line 443 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp20_ = _data_->_d_it;
#line 443 "../../../src/core/desktop-file-service.vala"
			if (!gee_iterator_next (_data_->_tmp20_)) {
#line 443 "../../../src/core/desktop-file-service.vala"
				break;
#line 3987 "desktop-file-service.c"
			}
#line 443 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp21_ = _data_->_d_it;
#line 443 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp22_ = gee_iterator_get (_data_->_tmp21_);
#line 443 "../../../src/core/desktop-file-service.vala"
			_data_->d = (GFile*) _data_->_tmp22_;
#line 3995 "desktop-file-service.c"
			{
#line 447 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp23_ = _data_->d;
#line 447 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp24_ = g_file_monitor_directory (_data_->_tmp23_, 0, NULL, &_data_->_inner_error0_);
#line 447 "../../../src/core/desktop-file-service.vala"
				_data_->monitor = _data_->_tmp24_;
#line 447 "../../../src/core/desktop-file-service.vala"
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 4005 "desktop-file-service.c"
					goto __catch0_g_error;
				}
#line 448 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp25_ = _data_->monitor;
#line 448 "../../../src/core/desktop-file-service.vala"
				g_signal_connect_object (_data_->_tmp25_, "changed", (GCallback) _synapse_desktop_file_service_desktop_file_directory_changed_g_file_monitor_changed, _data_->self, 0);
#line 449 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp26_ = _data_->self->priv->directory_monitors;
#line 449 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp27_ = _data_->monitor;
#line 449 "../../../src/core/desktop-file-service.vala"
				gee_collection_add ((GeeCollection*) _data_->_tmp26_, _data_->_tmp27_);
#line 445 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (_data_->monitor);
#line 4020 "desktop-file-service.c"
			}
			goto __finally0;
			__catch0_g_error:
			{
#line 445 "../../../src/core/desktop-file-service.vala"
				_data_->err = _data_->_inner_error0_;
#line 445 "../../../src/core/desktop-file-service.vala"
				_data_->_inner_error0_ = NULL;
#line 453 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp28_ = _data_->err;
#line 453 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp29_ = _data_->_tmp28_->message;
#line 453 "../../../src/core/desktop-file-service.vala"
				g_warning ("desktop-file-service.vala:453: Unable to monitor directory: %s", _data_->_tmp29_);
#line 445 "../../../src/core/desktop-file-service.vala"
				_g_error_free0 (_data_->err);
#line 4037 "desktop-file-service.c"
			}
			__finally0:
#line 445 "../../../src/core/desktop-file-service.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 445 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (_data_->d);
#line 445 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (_data_->_d_it);
#line 445 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (_data_->desktop_file_dirs);
#line 445 "../../../src/core/desktop-file-service.vala"
				_data_->data_dirs = (_vala_array_free (_data_->data_dirs, _data_->data_dirs_length1, (GDestroyNotify) g_free), NULL);
#line 445 "../../../src/core/desktop-file-service.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 445 "../../../src/core/desktop-file-service.vala"
				g_clear_error (&_data_->_inner_error0_);
#line 445 "../../../src/core/desktop-file-service.vala"
				g_object_unref (_data_->_async_result);
#line 445 "../../../src/core/desktop-file-service.vala"
				return FALSE;
#line 4058 "desktop-file-service.c"
			}
#line 443 "../../../src/core/desktop-file-service.vala"
			_g_object_unref0 (_data_->d);
#line 4062 "desktop-file-service.c"
		}
#line 443 "../../../src/core/desktop-file-service.vala"
		_g_object_unref0 (_data_->_d_it);
#line 4066 "desktop-file-service.c"
	}
#line 422 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (_data_->desktop_file_dirs);
#line 422 "../../../src/core/desktop-file-service.vala"
	_data_->data_dirs = (_vala_array_free (_data_->data_dirs, _data_->data_dirs_length1, (GDestroyNotify) g_free), NULL);
#line 422 "../../../src/core/desktop-file-service.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 422 "../../../src/core/desktop-file-service.vala"
	if (_data_->_state_ != 0) {
#line 422 "../../../src/core/desktop-file-service.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 422 "../../../src/core/desktop-file-service.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4080 "desktop-file-service.c"
		}
	}
#line 422 "../../../src/core/desktop-file-service.vala"
	g_object_unref (_data_->_async_result);
#line 422 "../../../src/core/desktop-file-service.vala"
	return FALSE;
#line 4087 "desktop-file-service.c"
}

static gboolean
__lambda8_ (SynapseDesktopFileService* self)
{
	gboolean result = FALSE;
#line 472 "../../../src/core/desktop-file-service.vala"
	self->priv->timer_id = (guint) 0;
#line 473 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_reload_desktop_files (self, NULL, NULL);
#line 474 "../../../src/core/desktop-file-service.vala"
	result = FALSE;
#line 474 "../../../src/core/desktop-file-service.vala"
	return result;
#line 4102 "desktop-file-service.c"
}

static gboolean
___lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda8_ ((SynapseDesktopFileService*) self);
#line 471 "../../../src/core/desktop-file-service.vala"
	return result;
#line 4112 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_desktop_file_directory_changed (SynapseDesktopFileService* self)
{
#line 463 "../../../src/core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 465 "../../../src/core/desktop-file-service.vala"
	g_signal_emit (self, synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_STARTED_SIGNAL], 0);
#line 466 "../../../src/core/desktop-file-service.vala"
	if (self->priv->timer_id != ((guint) 0)) {
#line 468 "../../../src/core/desktop-file-service.vala"
		g_source_remove (self->priv->timer_id);
#line 4126 "desktop-file-service.c"
	}
#line 471 "../../../src/core/desktop-file-service.vala"
	self->priv->timer_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 5000, ___lambda8__gsource_func, g_object_ref (self), g_object_unref);
#line 4130 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_reload_desktop_files_data_free (gpointer _data)
{
	SynapseDesktopFileServiceReloadDesktopFilesData* _data_;
	_data_ = _data;
#line 206 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (_data_->self);
#line 206 "../../../src/core/desktop-file-service.vala"
	g_slice_free (SynapseDesktopFileServiceReloadDesktopFilesData, _data_);
#line 4142 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_reload_desktop_files (SynapseDesktopFileService* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	SynapseDesktopFileServiceReloadDesktopFilesData* _data_;
	SynapseDesktopFileService* _tmp0_;
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_ = g_slice_new0 (SynapseDesktopFileServiceReloadDesktopFilesData);
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 206 "../../../src/core/desktop-file-service.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_reload_desktop_files_data_free);
#line 206 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_->self = _tmp0_;
#line 206 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_reload_desktop_files_co (_data_);
#line 4164 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_reload_desktop_files_finish (SynapseDesktopFileService* self,
                                                          GAsyncResult* _res_)
{
	SynapseDesktopFileServiceReloadDesktopFilesData* _data_;
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 4174 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_reload_desktop_files_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	SynapseDesktopFileServiceReloadDesktopFilesData* _data_;
#line 483 "../../../src/core/desktop-file-service.vala"
	_data_ = _user_data_;
#line 483 "../../../src/core/desktop-file-service.vala"
	_data_->_source_object_ = source_object;
#line 483 "../../../src/core/desktop-file-service.vala"
	_data_->_res_ = _res_;
#line 483 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_reload_desktop_files_co (_data_);
#line 4191 "desktop-file-service.c"
}

static gboolean
synapse_desktop_file_service_reload_desktop_files_co (SynapseDesktopFileServiceReloadDesktopFilesData* _data_)
{
#line 478 "../../../src/core/desktop-file-service.vala"
	switch (_data_->_state_) {
#line 478 "../../../src/core/desktop-file-service.vala"
		case 0:
#line 4201 "desktop-file-service.c"
		goto _state_0;
#line 478 "../../../src/core/desktop-file-service.vala"
		case 1:
#line 4205 "desktop-file-service.c"
		goto _state_1;
		default:
#line 478 "../../../src/core/desktop-file-service.vala"
		g_assert_not_reached ();
#line 4210 "desktop-file-service.c"
	}
	_state_0:
#line 480 "../../../src/core/desktop-file-service.vala"
	g_debug ("desktop-file-service.vala:480: Reloading desktop files...");
#line 481 "../../../src/core/desktop-file-service.vala"
	_data_->_tmp0_ = _data_->self->priv->all_desktop_files;
#line 481 "../../../src/core/desktop-file-service.vala"
	gee_collection_clear ((GeeCollection*) _data_->_tmp0_);
#line 482 "../../../src/core/desktop-file-service.vala"
	_data_->_tmp1_ = _data_->self->priv->non_hidden_desktop_files;
#line 482 "../../../src/core/desktop-file-service.vala"
	gee_collection_clear ((GeeCollection*) _data_->_tmp1_);
#line 483 "../../../src/core/desktop-file-service.vala"
	_data_->_state_ = 1;
#line 483 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_load_all_desktop_files (_data_->self, synapse_desktop_file_service_reload_desktop_files_ready, _data_);
#line 483 "../../../src/core/desktop-file-service.vala"
	return FALSE;
#line 4229 "desktop-file-service.c"
	_state_1:
#line 483 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_load_all_desktop_files_finish (_data_->self, _data_->_res_);
#line 485 "../../../src/core/desktop-file-service.vala"
	g_signal_emit (_data_->self, synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_DONE_SIGNAL], 0);
#line 478 "../../../src/core/desktop-file-service.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 478 "../../../src/core/desktop-file-service.vala"
	if (_data_->_state_ != 0) {
#line 478 "../../../src/core/desktop-file-service.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 478 "../../../src/core/desktop-file-service.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4243 "desktop-file-service.c"
		}
	}
#line 478 "../../../src/core/desktop-file-service.vala"
	g_object_unref (_data_->_async_result);
#line 478 "../../../src/core/desktop-file-service.vala"
	return FALSE;
#line 4250 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_desktop_file_data_free (gpointer _data)
{
	SynapseDesktopFileServiceLoadDesktopFileData* _data_;
	_data_ = _data;
#line 206 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (_data_->file);
#line 206 "../../../src/core/desktop-file-service.vala"
	_g_free0 (_data_->id_prefix);
#line 206 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (_data_->self);
#line 206 "../../../src/core/desktop-file-service.vala"
	g_slice_free (SynapseDesktopFileServiceLoadDesktopFileData, _data_);
#line 4266 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_desktop_file (SynapseDesktopFileService* self,
                                                GFile* file,
                                                const gchar* id_prefix,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadDesktopFileData* _data_;
	SynapseDesktopFileService* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_ = g_slice_new0 (SynapseDesktopFileServiceLoadDesktopFileData);
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 206 "../../../src/core/desktop-file-service.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_load_desktop_file_data_free);
#line 206 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_->self = _tmp0_;
#line 206 "../../../src/core/desktop-file-service.vala"
	_tmp1_ = _g_object_ref0 (file);
#line 206 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (_data_->file);
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_->file = _tmp1_;
#line 206 "../../../src/core/desktop-file-service.vala"
	_tmp2_ = g_strdup (id_prefix);
#line 206 "../../../src/core/desktop-file-service.vala"
	_g_free0 (_data_->id_prefix);
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_->id_prefix = _tmp2_;
#line 206 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_load_desktop_file_co (_data_);
#line 4304 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_desktop_file_finish (SynapseDesktopFileService* self,
                                                       GAsyncResult* _res_)
{
	SynapseDesktopFileServiceLoadDesktopFileData* _data_;
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 4314 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_desktop_file_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadDesktopFileData* _data_;
#line 493 "../../../src/core/desktop-file-service.vala"
	_data_ = _user_data_;
#line 493 "../../../src/core/desktop-file-service.vala"
	_data_->_source_object_ = source_object;
#line 493 "../../../src/core/desktop-file-service.vala"
	_data_->_res_ = _res_;
#line 493 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_load_desktop_file_co (_data_);
#line 4331 "desktop-file-service.c"
}

static gboolean
synapse_desktop_file_service_load_desktop_file_co (SynapseDesktopFileServiceLoadDesktopFileData* _data_)
{
#line 488 "../../../src/core/desktop-file-service.vala"
	switch (_data_->_state_) {
#line 488 "../../../src/core/desktop-file-service.vala"
		case 0:
#line 4341 "desktop-file-service.c"
		goto _state_0;
#line 488 "../../../src/core/desktop-file-service.vala"
		case 1:
#line 4345 "desktop-file-service.c"
		goto _state_1;
		default:
#line 488 "../../../src/core/desktop-file-service.vala"
		g_assert_not_reached ();
#line 4350 "desktop-file-service.c"
	}
	_state_0:
	{
#line 492 "../../../src/core/desktop-file-service.vala"
		_data_->file_contents_length1 = 0;
#line 492 "../../../src/core/desktop-file-service.vala"
		_data_->_file_contents_size_ = 0;
#line 493 "../../../src/core/desktop-file-service.vala"
		_data_->_tmp0_ = NULL;
#line 493 "../../../src/core/desktop-file-service.vala"
		_data_->_tmp1_ = 0;
#line 493 "../../../src/core/desktop-file-service.vala"
		_data_->_state_ = 1;
#line 493 "../../../src/core/desktop-file-service.vala"
		g_file_load_contents_async (_data_->file, NULL, synapse_desktop_file_service_load_desktop_file_ready, _data_);
#line 493 "../../../src/core/desktop-file-service.vala"
		return FALSE;
#line 4368 "desktop-file-service.c"
		_state_1:
#line 493 "../../../src/core/desktop-file-service.vala"
		_data_->_tmp2_ = g_file_load_contents_finish (_data_->file, _data_->_res_, &_data_->_tmp0_, &_data_->_tmp1_, NULL, &_data_->_inner_error0_);
#line 493 "../../../src/core/desktop-file-service.vala"
		_data_->file_contents = (g_free (_data_->file_contents), NULL);
#line 493 "../../../src/core/desktop-file-service.vala"
		_data_->file_contents = _data_->_tmp0_;
#line 493 "../../../src/core/desktop-file-service.vala"
		_data_->file_contents_length1 = _data_->_tmp1_;
#line 493 "../../../src/core/desktop-file-service.vala"
		_data_->_file_contents_size_ = _data_->file_contents_length1;
#line 493 "../../../src/core/desktop-file-service.vala"
		_data_->success = _data_->_tmp2_;
#line 493 "../../../src/core/desktop-file-service.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 493 "../../../src/core/desktop-file-service.vala"
			_data_->file_contents = (g_free (_data_->file_contents), NULL);
#line 4386 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 495 "../../../src/core/desktop-file-service.vala"
		if (_data_->success) {
#line 497 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp3_ = g_key_file_new ();
#line 497 "../../../src/core/desktop-file-service.vala"
			_data_->keyfile = _data_->_tmp3_;
#line 498 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp4_ = _data_->keyfile;
#line 498 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp5_ = _data_->file_contents;
#line 498 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp5__length1 = _data_->file_contents_length1;
#line 498 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp6_ = _data_->file_contents;
#line 498 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp6__length1 = _data_->file_contents_length1;
#line 498 "../../../src/core/desktop-file-service.vala"
			g_key_file_load_from_data (_data_->_tmp4_, (const gchar*) _data_->_tmp5_, (gsize) _data_->_tmp6__length1, 0, &_data_->_inner_error0_);
#line 498 "../../../src/core/desktop-file-service.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 498 "../../../src/core/desktop-file-service.vala"
				_g_key_file_unref0 (_data_->keyfile);
#line 498 "../../../src/core/desktop-file-service.vala"
				_data_->file_contents = (g_free (_data_->file_contents), NULL);
#line 4413 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 501 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp7_ = g_file_get_basename (_data_->file);
#line 501 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp8_ = _data_->_tmp7_;
#line 501 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp9_ = g_strdup_printf ("%s%s", _data_->id_prefix, _data_->_tmp8_);
#line 501 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp10_ = _data_->_tmp9_;
#line 501 "../../../src/core/desktop-file-service.vala"
			_g_free0 (_data_->_tmp8_);
#line 501 "../../../src/core/desktop-file-service.vala"
			_data_->desktop_id = _data_->_tmp10_;
#line 502 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp11_ = g_file_get_path (_data_->file);
#line 502 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp12_ = _data_->_tmp11_;
#line 502 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp13_ = _data_->keyfile;
#line 502 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp14_ = _data_->desktop_id;
#line 502 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp15_ = synapse_desktop_file_info_new_for_keyfile (_data_->_tmp12_, _data_->_tmp13_, _data_->_tmp14_);
#line 502 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp16_ = _data_->_tmp15_;
#line 502 "../../../src/core/desktop-file-service.vala"
			_g_free0 (_data_->_tmp12_);
#line 502 "../../../src/core/desktop-file-service.vala"
			_data_->dfi = _data_->_tmp16_;
#line 505 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp17_ = _data_->dfi;
#line 505 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp18_ = synapse_desktop_file_info_get_is_valid (_data_->_tmp17_);
#line 505 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp19_ = _data_->_tmp18_;
#line 505 "../../../src/core/desktop-file-service.vala"
			if (_data_->_tmp19_) {
#line 507 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp20_ = _data_->self->priv->all_desktop_files;
#line 507 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp21_ = _data_->dfi;
#line 507 "../../../src/core/desktop-file-service.vala"
				gee_collection_add ((GeeCollection*) _data_->_tmp20_, _data_->_tmp21_);
#line 508 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp23_ = _data_->dfi;
#line 508 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp24_ = synapse_desktop_file_info_get_is_hidden (_data_->_tmp23_);
#line 508 "../../../src/core/desktop-file-service.vala"
				_data_->_tmp25_ = _data_->_tmp24_;
#line 508 "../../../src/core/desktop-file-service.vala"
				if (!_data_->_tmp25_) {
#line 508 "../../../src/core/desktop-file-service.vala"
					_data_->_tmp26_ = _data_->self->priv->session_type;
#line 508 "../../../src/core/desktop-file-service.vala"
					_data_->_tmp27_ = _data_->dfi;
#line 508 "../../../src/core/desktop-file-service.vala"
					_data_->_tmp28_ = synapse_desktop_file_info_get_show_in (_data_->_tmp27_);
#line 508 "../../../src/core/desktop-file-service.vala"
					_data_->_tmp29_ = _data_->_tmp28_;
#line 508 "../../../src/core/desktop-file-service.vala"
					_data_->_tmp22_ = (_data_->_tmp29_ & _data_->_tmp26_) == _data_->_tmp26_;
#line 4476 "desktop-file-service.c"
				} else {
#line 508 "../../../src/core/desktop-file-service.vala"
					_data_->_tmp22_ = FALSE;
#line 4480 "desktop-file-service.c"
				}
#line 508 "../../../src/core/desktop-file-service.vala"
				if (_data_->_tmp22_) {
#line 510 "../../../src/core/desktop-file-service.vala"
					_data_->_tmp30_ = _data_->self->priv->non_hidden_desktop_files;
#line 510 "../../../src/core/desktop-file-service.vala"
					_data_->_tmp31_ = _data_->dfi;
#line 510 "../../../src/core/desktop-file-service.vala"
					gee_collection_add ((GeeCollection*) _data_->_tmp30_, _data_->_tmp31_);
#line 4490 "desktop-file-service.c"
				}
			}
#line 495 "../../../src/core/desktop-file-service.vala"
			_g_object_unref0 (_data_->dfi);
#line 495 "../../../src/core/desktop-file-service.vala"
			_g_free0 (_data_->desktop_id);
#line 495 "../../../src/core/desktop-file-service.vala"
			_g_key_file_unref0 (_data_->keyfile);
#line 4499 "desktop-file-service.c"
		}
#line 490 "../../../src/core/desktop-file-service.vala"
		_data_->file_contents = (g_free (_data_->file_contents), NULL);
#line 4503 "desktop-file-service.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 490 "../../../src/core/desktop-file-service.vala"
		_data_->err = _data_->_inner_error0_;
#line 490 "../../../src/core/desktop-file-service.vala"
		_data_->_inner_error0_ = NULL;
#line 517 "../../../src/core/desktop-file-service.vala"
		_data_->_tmp32_ = _data_->err;
#line 517 "../../../src/core/desktop-file-service.vala"
		_data_->_tmp33_ = _data_->_tmp32_->message;
#line 517 "../../../src/core/desktop-file-service.vala"
		g_warning ("desktop-file-service.vala:517: %s", _data_->_tmp33_);
#line 490 "../../../src/core/desktop-file-service.vala"
		_g_error_free0 (_data_->err);
#line 4520 "desktop-file-service.c"
	}
	__finally0:
#line 490 "../../../src/core/desktop-file-service.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 490 "../../../src/core/desktop-file-service.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 490 "../../../src/core/desktop-file-service.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 490 "../../../src/core/desktop-file-service.vala"
		g_object_unref (_data_->_async_result);
#line 490 "../../../src/core/desktop-file-service.vala"
		return FALSE;
#line 4533 "desktop-file-service.c"
	}
#line 488 "../../../src/core/desktop-file-service.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 488 "../../../src/core/desktop-file-service.vala"
	if (_data_->_state_ != 0) {
#line 488 "../../../src/core/desktop-file-service.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 488 "../../../src/core/desktop-file-service.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4543 "desktop-file-service.c"
		}
	}
#line 488 "../../../src/core/desktop-file-service.vala"
	g_object_unref (_data_->_async_result);
#line 488 "../../../src/core/desktop-file-service.vala"
	return FALSE;
#line 4550 "desktop-file-service.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
#line 1359 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1360 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1360 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1361 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1362 "glib-2.0.vapi"
	result = _result_;
#line 1362 "glib-2.0.vapi"
	return result;
#line 4571 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_create_indices (SynapseDesktopFileService* self)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	GRegex* exec_re = NULL;
	GError* _inner_error0_ = NULL;
#line 521 "../../../src/core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 524 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, NULL, NULL, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 524 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->mimetype_map);
#line 524 "../../../src/core/desktop-file-service.vala"
	self->priv->mimetype_map = (GeeMap*) _tmp0_;
#line 527 "../../../src/core/desktop-file-service.vala"
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 527 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->exec_map);
#line 527 "../../../src/core/desktop-file-service.vala"
	self->priv->exec_map = (GeeMap*) _tmp1_;
#line 530 "../../../src/core/desktop-file-service.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 530 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->desktop_id_map);
#line 530 "../../../src/core/desktop-file-service.vala"
	self->priv->desktop_id_map = (GeeMap*) _tmp2_;
#line 4602 "desktop-file-service.c"
	{
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_;
		GRegex* _tmp5_;
#line 536 "../../../src/core/desktop-file-service.vala"
		_tmp4_ = g_regex_new ("%[fFuU]", 0, 0, &_inner_error0_);
#line 536 "../../../src/core/desktop-file-service.vala"
		_tmp3_ = _tmp4_;
#line 536 "../../../src/core/desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4613 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 536 "../../../src/core/desktop-file-service.vala"
		_tmp5_ = _tmp3_;
#line 536 "../../../src/core/desktop-file-service.vala"
		_tmp3_ = NULL;
#line 536 "../../../src/core/desktop-file-service.vala"
		_g_regex_unref0 (exec_re);
#line 536 "../../../src/core/desktop-file-service.vala"
		exec_re = _tmp5_;
#line 534 "../../../src/core/desktop-file-service.vala"
		_g_regex_unref0 (_tmp3_);
#line 4626 "desktop-file-service.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 534 "../../../src/core/desktop-file-service.vala"
		err = _inner_error0_;
#line 534 "../../../src/core/desktop-file-service.vala"
		_inner_error0_ = NULL;
#line 540 "../../../src/core/desktop-file-service.vala"
		_tmp6_ = err;
#line 540 "../../../src/core/desktop-file-service.vala"
		_tmp7_ = _tmp6_->message;
#line 540 "../../../src/core/desktop-file-service.vala"
		g_critical ("desktop-file-service.vala:540: %s", _tmp7_);
#line 541 "../../../src/core/desktop-file-service.vala"
		_g_error_free0 (err);
#line 541 "../../../src/core/desktop-file-service.vala"
		_g_regex_unref0 (exec_re);
#line 541 "../../../src/core/desktop-file-service.vala"
		return;
#line 4650 "desktop-file-service.c"
	}
	__finally0:
#line 534 "../../../src/core/desktop-file-service.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 534 "../../../src/core/desktop-file-service.vala"
		_g_regex_unref0 (exec_re);
#line 534 "../../../src/core/desktop-file-service.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 534 "../../../src/core/desktop-file-service.vala"
		g_clear_error (&_inner_error0_);
#line 534 "../../../src/core/desktop-file-service.vala"
		return;
#line 4663 "desktop-file-service.c"
	}
	{
		GeeList* _dfi_list = NULL;
		GeeList* _tmp8_;
		GeeList* _tmp9_;
		gint _dfi_size = 0;
		GeeList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _dfi_index = 0;
#line 544 "../../../src/core/desktop-file-service.vala"
		_tmp8_ = self->priv->all_desktop_files;
#line 544 "../../../src/core/desktop-file-service.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 544 "../../../src/core/desktop-file-service.vala"
		_dfi_list = _tmp9_;
#line 544 "../../../src/core/desktop-file-service.vala"
		_tmp10_ = _dfi_list;
#line 544 "../../../src/core/desktop-file-service.vala"
		_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
#line 544 "../../../src/core/desktop-file-service.vala"
		_tmp12_ = _tmp11_;
#line 544 "../../../src/core/desktop-file-service.vala"
		_dfi_size = _tmp12_;
#line 544 "../../../src/core/desktop-file-service.vala"
		_dfi_index = -1;
#line 544 "../../../src/core/desktop-file-service.vala"
		while (TRUE) {
#line 4692 "desktop-file-service.c"
			gint _tmp13_;
			gint _tmp14_;
			SynapseDesktopFileInfo* dfi = NULL;
			GeeList* _tmp15_;
			gpointer _tmp16_;
			gchar* exec = NULL;
			gchar* _tmp17_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			GeeList* exec_list = NULL;
			GeeMap* _tmp29_;
			const gchar* _tmp30_;
			gpointer _tmp31_;
			GeeList* _tmp32_;
			GeeList* _tmp37_;
			SynapseDesktopFileInfo* _tmp38_;
			gchar* _tmp39_ = NULL;
			SynapseDesktopFileInfo* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* desktop_id = NULL;
			gchar* _tmp48_;
			GeeMap* _tmp49_;
			const gchar* _tmp50_;
			SynapseDesktopFileInfo* _tmp51_;
			gboolean _tmp52_ = FALSE;
			SynapseDesktopFileInfo* _tmp53_;
			gboolean _tmp54_;
			gboolean _tmp55_;
			SynapseDesktopFileInfo* _tmp58_;
			gchar** _tmp59_;
			gint _tmp59__length1;
#line 544 "../../../src/core/desktop-file-service.vala"
			_dfi_index = _dfi_index + 1;
#line 544 "../../../src/core/desktop-file-service.vala"
			_tmp13_ = _dfi_index;
#line 544 "../../../src/core/desktop-file-service.vala"
			_tmp14_ = _dfi_size;
#line 544 "../../../src/core/desktop-file-service.vala"
			if (!(_tmp13_ < _tmp14_)) {
#line 544 "../../../src/core/desktop-file-service.vala"
				break;
#line 4736 "desktop-file-service.c"
			}
#line 544 "../../../src/core/desktop-file-service.vala"
			_tmp15_ = _dfi_list;
#line 544 "../../../src/core/desktop-file-service.vala"
			_tmp16_ = gee_list_get (_tmp15_, _dfi_index);
#line 544 "../../../src/core/desktop-file-service.vala"
			dfi = (SynapseDesktopFileInfo*) _tmp16_;
#line 546 "../../../src/core/desktop-file-service.vala"
			_tmp17_ = g_strdup ("");
#line 546 "../../../src/core/desktop-file-service.vala"
			exec = _tmp17_;
#line 4748 "desktop-file-service.c"
			{
				gchar* _tmp18_ = NULL;
				GRegex* _tmp19_;
				SynapseDesktopFileInfo* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
#line 549 "../../../src/core/desktop-file-service.vala"
				_tmp19_ = exec_re;
#line 549 "../../../src/core/desktop-file-service.vala"
				_tmp20_ = dfi;
#line 549 "../../../src/core/desktop-file-service.vala"
				_tmp21_ = synapse_desktop_file_info_get_exec (_tmp20_);
#line 549 "../../../src/core/desktop-file-service.vala"
				_tmp22_ = _tmp21_;
#line 549 "../../../src/core/desktop-file-service.vala"
				_tmp23_ = g_regex_replace_literal (_tmp19_, _tmp22_, (gssize) -1, 0, "", 0, &_inner_error0_);
#line 549 "../../../src/core/desktop-file-service.vala"
				_tmp18_ = _tmp23_;
#line 549 "../../../src/core/desktop-file-service.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 549 "../../../src/core/desktop-file-service.vala"
					if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 4773 "desktop-file-service.c"
						goto __catch1_g_regex_error;
					}
#line 549 "../../../src/core/desktop-file-service.vala"
					_g_free0 (exec);
#line 549 "../../../src/core/desktop-file-service.vala"
					_g_object_unref0 (dfi);
#line 549 "../../../src/core/desktop-file-service.vala"
					_g_object_unref0 (_dfi_list);
#line 549 "../../../src/core/desktop-file-service.vala"
					_g_regex_unref0 (exec_re);
#line 549 "../../../src/core/desktop-file-service.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 549 "../../../src/core/desktop-file-service.vala"
					g_clear_error (&_inner_error0_);
#line 549 "../../../src/core/desktop-file-service.vala"
					return;
#line 4790 "desktop-file-service.c"
				}
#line 549 "../../../src/core/desktop-file-service.vala"
				_tmp24_ = _tmp18_;
#line 549 "../../../src/core/desktop-file-service.vala"
				_tmp18_ = NULL;
#line 549 "../../../src/core/desktop-file-service.vala"
				_g_free0 (exec);
#line 549 "../../../src/core/desktop-file-service.vala"
				exec = _tmp24_;
#line 547 "../../../src/core/desktop-file-service.vala"
				_g_free0 (_tmp18_);
#line 4802 "desktop-file-service.c"
			}
			goto __finally1;
			__catch1_g_regex_error:
			{
				GError* err = NULL;
				GError* _tmp25_;
				const gchar* _tmp26_;
#line 547 "../../../src/core/desktop-file-service.vala"
				err = _inner_error0_;
#line 547 "../../../src/core/desktop-file-service.vala"
				_inner_error0_ = NULL;
#line 553 "../../../src/core/desktop-file-service.vala"
				_tmp25_ = err;
#line 553 "../../../src/core/desktop-file-service.vala"
				_tmp26_ = _tmp25_->message;
#line 553 "../../../src/core/desktop-file-service.vala"
				g_critical ("desktop-file-service.vala:553: %s", _tmp26_);
#line 547 "../../../src/core/desktop-file-service.vala"
				_g_error_free0 (err);
#line 4822 "desktop-file-service.c"
			}
			__finally1:
#line 547 "../../../src/core/desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 547 "../../../src/core/desktop-file-service.vala"
				_g_free0 (exec);
#line 547 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (dfi);
#line 547 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (_dfi_list);
#line 547 "../../../src/core/desktop-file-service.vala"
				_g_regex_unref0 (exec_re);
#line 547 "../../../src/core/desktop-file-service.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 547 "../../../src/core/desktop-file-service.vala"
				g_clear_error (&_inner_error0_);
#line 547 "../../../src/core/desktop-file-service.vala"
				return;
#line 4841 "desktop-file-service.c"
			}
#line 555 "../../../src/core/desktop-file-service.vala"
			_tmp27_ = exec;
#line 555 "../../../src/core/desktop-file-service.vala"
			_tmp28_ = string_strip (_tmp27_);
#line 555 "../../../src/core/desktop-file-service.vala"
			_g_free0 (exec);
#line 555 "../../../src/core/desktop-file-service.vala"
			exec = _tmp28_;
#line 557 "../../../src/core/desktop-file-service.vala"
			_tmp29_ = self->priv->exec_map;
#line 557 "../../../src/core/desktop-file-service.vala"
			_tmp30_ = exec;
#line 557 "../../../src/core/desktop-file-service.vala"
			_tmp31_ = gee_map_get (_tmp29_, _tmp30_);
#line 557 "../../../src/core/desktop-file-service.vala"
			exec_list = (GeeList*) _tmp31_;
#line 558 "../../../src/core/desktop-file-service.vala"
			_tmp32_ = exec_list;
#line 558 "../../../src/core/desktop-file-service.vala"
			if (_tmp32_ == NULL) {
#line 4863 "desktop-file-service.c"
				GeeArrayList* _tmp33_;
				GeeMap* _tmp34_;
				const gchar* _tmp35_;
				GeeList* _tmp36_;
#line 560 "../../../src/core/desktop-file-service.vala"
				_tmp33_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 560 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (exec_list);
#line 560 "../../../src/core/desktop-file-service.vala"
				exec_list = (GeeList*) _tmp33_;
#line 561 "../../../src/core/desktop-file-service.vala"
				_tmp34_ = self->priv->exec_map;
#line 561 "../../../src/core/desktop-file-service.vala"
				_tmp35_ = exec;
#line 561 "../../../src/core/desktop-file-service.vala"
				_tmp36_ = exec_list;
#line 561 "../../../src/core/desktop-file-service.vala"
				gee_map_set (_tmp34_, _tmp35_, _tmp36_);
#line 4882 "desktop-file-service.c"
			}
#line 563 "../../../src/core/desktop-file-service.vala"
			_tmp37_ = exec_list;
#line 563 "../../../src/core/desktop-file-service.vala"
			_tmp38_ = dfi;
#line 563 "../../../src/core/desktop-file-service.vala"
			gee_collection_add ((GeeCollection*) _tmp37_, _tmp38_);
#line 566 "../../../src/core/desktop-file-service.vala"
			_tmp40_ = dfi;
#line 566 "../../../src/core/desktop-file-service.vala"
			_tmp41_ = synapse_desktop_file_info_get_desktop_id (_tmp40_);
#line 566 "../../../src/core/desktop-file-service.vala"
			_tmp42_ = _tmp41_;
#line 566 "../../../src/core/desktop-file-service.vala"
			_tmp43_ = g_strdup (_tmp42_);
#line 566 "../../../src/core/desktop-file-service.vala"
			_tmp39_ = _tmp43_;
#line 566 "../../../src/core/desktop-file-service.vala"
			if (_tmp39_ == NULL) {
#line 4902 "desktop-file-service.c"
				SynapseDesktopFileInfo* _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				gchar* _tmp47_;
#line 566 "../../../src/core/desktop-file-service.vala"
				_tmp44_ = dfi;
#line 566 "../../../src/core/desktop-file-service.vala"
				_tmp45_ = synapse_desktop_file_info_get_filename (_tmp44_);
#line 566 "../../../src/core/desktop-file-service.vala"
				_tmp46_ = _tmp45_;
#line 566 "../../../src/core/desktop-file-service.vala"
				_tmp47_ = g_path_get_basename (_tmp46_);
#line 566 "../../../src/core/desktop-file-service.vala"
				_g_free0 (_tmp39_);
#line 566 "../../../src/core/desktop-file-service.vala"
				_tmp39_ = _tmp47_;
#line 4919 "desktop-file-service.c"
			}
#line 566 "../../../src/core/desktop-file-service.vala"
			_tmp48_ = _tmp39_;
#line 566 "../../../src/core/desktop-file-service.vala"
			_tmp39_ = NULL;
#line 566 "../../../src/core/desktop-file-service.vala"
			desktop_id = _tmp48_;
#line 567 "../../../src/core/desktop-file-service.vala"
			_tmp49_ = self->priv->desktop_id_map;
#line 567 "../../../src/core/desktop-file-service.vala"
			_tmp50_ = desktop_id;
#line 567 "../../../src/core/desktop-file-service.vala"
			_tmp51_ = dfi;
#line 567 "../../../src/core/desktop-file-service.vala"
			gee_map_set (_tmp49_, _tmp50_, _tmp51_);
#line 570 "../../../src/core/desktop-file-service.vala"
			_tmp53_ = dfi;
#line 570 "../../../src/core/desktop-file-service.vala"
			_tmp54_ = synapse_desktop_file_info_get_is_hidden (_tmp53_);
#line 570 "../../../src/core/desktop-file-service.vala"
			_tmp55_ = _tmp54_;
#line 570 "../../../src/core/desktop-file-service.vala"
			if (_tmp55_) {
#line 570 "../../../src/core/desktop-file-service.vala"
				_tmp52_ = TRUE;
#line 4945 "desktop-file-service.c"
			} else {
				SynapseDesktopFileInfo* _tmp56_;
				gchar** _tmp57_;
				gint _tmp57__length1;
#line 570 "../../../src/core/desktop-file-service.vala"
				_tmp56_ = dfi;
#line 570 "../../../src/core/desktop-file-service.vala"
				_tmp57_ = _tmp56_->mime_types;
#line 570 "../../../src/core/desktop-file-service.vala"
				_tmp57__length1 = _tmp56_->mime_types_length1;
#line 570 "../../../src/core/desktop-file-service.vala"
				_tmp52_ = _tmp57_ == NULL;
#line 4958 "desktop-file-service.c"
			}
#line 570 "../../../src/core/desktop-file-service.vala"
			if (_tmp52_) {
#line 570 "../../../src/core/desktop-file-service.vala"
				_g_free0 (desktop_id);
#line 570 "../../../src/core/desktop-file-service.vala"
				_g_free0 (_tmp39_);
#line 570 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (exec_list);
#line 570 "../../../src/core/desktop-file-service.vala"
				_g_free0 (exec);
#line 570 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (dfi);
#line 570 "../../../src/core/desktop-file-service.vala"
				continue;
#line 4974 "desktop-file-service.c"
			}
#line 572 "../../../src/core/desktop-file-service.vala"
			_tmp58_ = dfi;
#line 572 "../../../src/core/desktop-file-service.vala"
			_tmp59_ = _tmp58_->mime_types;
#line 572 "../../../src/core/desktop-file-service.vala"
			_tmp59__length1 = _tmp58_->mime_types_length1;
#line 4982 "desktop-file-service.c"
			{
				gchar** mime_type_collection = NULL;
				gint mime_type_collection_length1 = 0;
				gint _mime_type_collection_size_ = 0;
				gint mime_type_it = 0;
#line 572 "../../../src/core/desktop-file-service.vala"
				mime_type_collection = _tmp59_;
#line 572 "../../../src/core/desktop-file-service.vala"
				mime_type_collection_length1 = _tmp59__length1;
#line 572 "../../../src/core/desktop-file-service.vala"
				for (mime_type_it = 0; mime_type_it < mime_type_collection_length1; mime_type_it = mime_type_it + 1) {
#line 4994 "desktop-file-service.c"
					const gchar* mime_type = NULL;
#line 572 "../../../src/core/desktop-file-service.vala"
					mime_type = mime_type_collection[mime_type_it];
#line 4998 "desktop-file-service.c"
					{
						GeeList* list = NULL;
						GeeMap* _tmp60_;
						const gchar* _tmp61_;
						gpointer _tmp62_;
						GeeList* _tmp63_;
						GeeList* _tmp68_;
						SynapseDesktopFileInfo* _tmp69_;
#line 574 "../../../src/core/desktop-file-service.vala"
						_tmp60_ = self->priv->mimetype_map;
#line 574 "../../../src/core/desktop-file-service.vala"
						_tmp61_ = mime_type;
#line 574 "../../../src/core/desktop-file-service.vala"
						_tmp62_ = gee_map_get (_tmp60_, _tmp61_);
#line 574 "../../../src/core/desktop-file-service.vala"
						list = (GeeList*) _tmp62_;
#line 575 "../../../src/core/desktop-file-service.vala"
						_tmp63_ = list;
#line 575 "../../../src/core/desktop-file-service.vala"
						if (_tmp63_ == NULL) {
#line 5019 "desktop-file-service.c"
							GeeArrayList* _tmp64_;
							GeeMap* _tmp65_;
							const gchar* _tmp66_;
							GeeList* _tmp67_;
#line 577 "../../../src/core/desktop-file-service.vala"
							_tmp64_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 577 "../../../src/core/desktop-file-service.vala"
							_g_object_unref0 (list);
#line 577 "../../../src/core/desktop-file-service.vala"
							list = (GeeList*) _tmp64_;
#line 578 "../../../src/core/desktop-file-service.vala"
							_tmp65_ = self->priv->mimetype_map;
#line 578 "../../../src/core/desktop-file-service.vala"
							_tmp66_ = mime_type;
#line 578 "../../../src/core/desktop-file-service.vala"
							_tmp67_ = list;
#line 578 "../../../src/core/desktop-file-service.vala"
							gee_map_set (_tmp65_, _tmp66_, _tmp67_);
#line 5038 "desktop-file-service.c"
						}
#line 580 "../../../src/core/desktop-file-service.vala"
						_tmp68_ = list;
#line 580 "../../../src/core/desktop-file-service.vala"
						_tmp69_ = dfi;
#line 580 "../../../src/core/desktop-file-service.vala"
						gee_collection_add ((GeeCollection*) _tmp68_, _tmp69_);
#line 572 "../../../src/core/desktop-file-service.vala"
						_g_object_unref0 (list);
#line 5048 "desktop-file-service.c"
					}
				}
			}
#line 544 "../../../src/core/desktop-file-service.vala"
			_g_free0 (desktop_id);
#line 544 "../../../src/core/desktop-file-service.vala"
			_g_free0 (_tmp39_);
#line 544 "../../../src/core/desktop-file-service.vala"
			_g_object_unref0 (exec_list);
#line 544 "../../../src/core/desktop-file-service.vala"
			_g_free0 (exec);
#line 544 "../../../src/core/desktop-file-service.vala"
			_g_object_unref0 (dfi);
#line 5062 "desktop-file-service.c"
		}
#line 544 "../../../src/core/desktop-file-service.vala"
		_g_object_unref0 (_dfi_list);
#line 5066 "desktop-file-service.c"
	}
#line 521 "../../../src/core/desktop-file-service.vala"
	_g_regex_unref0 (exec_re);
#line 5070 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_mime_parents_from_file_data_free (gpointer _data)
{
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_;
	_data_ = _data;
#line 206 "../../../src/core/desktop-file-service.vala"
	_g_free0 (_data_->fi);
#line 206 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (_data_->self);
#line 206 "../../../src/core/desktop-file-service.vala"
	g_slice_free (SynapseDesktopFileServiceLoadMimeParentsFromFileData, _data_);
#line 5084 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_mime_parents_from_file (SynapseDesktopFileService* self,
                                                          const gchar* fi,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_;
	SynapseDesktopFileService* _tmp0_;
	gchar* _tmp1_;
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_ = g_slice_new0 (SynapseDesktopFileServiceLoadMimeParentsFromFileData);
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 206 "../../../src/core/desktop-file-service.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_load_mime_parents_from_file_data_free);
#line 206 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_->self = _tmp0_;
#line 206 "../../../src/core/desktop-file-service.vala"
	_tmp1_ = g_strdup (fi);
#line 206 "../../../src/core/desktop-file-service.vala"
	_g_free0 (_data_->fi);
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_->fi = _tmp1_;
#line 206 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_load_mime_parents_from_file_co (_data_);
#line 5114 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_mime_parents_from_file_finish (SynapseDesktopFileService* self,
                                                                 GAsyncResult* _res_)
{
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_;
#line 206 "../../../src/core/desktop-file-service.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 5124 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_mime_parents_from_file_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_;
#line 588 "../../../src/core/desktop-file-service.vala"
	_data_ = _user_data_;
#line 588 "../../../src/core/desktop-file-service.vala"
	_data_->_source_object_ = source_object;
#line 588 "../../../src/core/desktop-file-service.vala"
	_data_->_res_ = _res_;
#line 588 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_load_mime_parents_from_file_co (_data_);
#line 5141 "desktop-file-service.c"
}

static gboolean
synapse_desktop_file_service_load_mime_parents_from_file_co (SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_)
{
#line 585 "../../../src/core/desktop-file-service.vala"
	switch (_data_->_state_) {
#line 585 "../../../src/core/desktop-file-service.vala"
		case 0:
#line 5151 "desktop-file-service.c"
		goto _state_0;
#line 585 "../../../src/core/desktop-file-service.vala"
		case 1:
#line 5155 "desktop-file-service.c"
		goto _state_1;
#line 585 "../../../src/core/desktop-file-service.vala"
		case 2:
#line 5159 "desktop-file-service.c"
		goto _state_2;
#line 585 "../../../src/core/desktop-file-service.vala"
		case 3:
#line 5163 "desktop-file-service.c"
		goto _state_3;
		default:
#line 585 "../../../src/core/desktop-file-service.vala"
		g_assert_not_reached ();
#line 5168 "desktop-file-service.c"
	}
	_state_0:
#line 587 "../../../src/core/desktop-file-service.vala"
	_data_->_tmp0_ = g_file_new_for_path (_data_->fi);
#line 587 "../../../src/core/desktop-file-service.vala"
	_data_->file = _data_->_tmp0_;
#line 588 "../../../src/core/desktop-file-service.vala"
	_data_->_tmp1_ = _data_->file;
#line 588 "../../../src/core/desktop-file-service.vala"
	_data_->_state_ = 1;
#line 588 "../../../src/core/desktop-file-service.vala"
	synapse_utils_query_exists_async (_data_->_tmp1_, synapse_desktop_file_service_load_mime_parents_from_file_ready, _data_);
#line 588 "../../../src/core/desktop-file-service.vala"
	return FALSE;
#line 5183 "desktop-file-service.c"
	_state_1:
#line 588 "../../../src/core/desktop-file-service.vala"
	_data_->exists = synapse_utils_query_exists_finish (_data_->_res_);
#line 589 "../../../src/core/desktop-file-service.vala"
	if (!_data_->exists) {
#line 589 "../../../src/core/desktop-file-service.vala"
		_g_object_unref0 (_data_->file);
#line 589 "../../../src/core/desktop-file-service.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 589 "../../../src/core/desktop-file-service.vala"
		if (_data_->_state_ != 0) {
#line 589 "../../../src/core/desktop-file-service.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 589 "../../../src/core/desktop-file-service.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 5199 "desktop-file-service.c"
			}
		}
#line 589 "../../../src/core/desktop-file-service.vala"
		g_object_unref (_data_->_async_result);
#line 589 "../../../src/core/desktop-file-service.vala"
		return FALSE;
#line 5206 "desktop-file-service.c"
	}
	{
#line 592 "../../../src/core/desktop-file-service.vala"
		_data_->_tmp2_ = _data_->file;
#line 592 "../../../src/core/desktop-file-service.vala"
		_data_->_state_ = 2;
#line 592 "../../../src/core/desktop-file-service.vala"
		g_file_read_async (_data_->_tmp2_, G_PRIORITY_DEFAULT, NULL, synapse_desktop_file_service_load_mime_parents_from_file_ready, _data_);
#line 592 "../../../src/core/desktop-file-service.vala"
		return FALSE;
#line 5217 "desktop-file-service.c"
		_state_2:
#line 592 "../../../src/core/desktop-file-service.vala"
		_data_->_tmp3_ = g_file_read_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
#line 592 "../../../src/core/desktop-file-service.vala"
		_data_->fis = _data_->_tmp3_;
#line 592 "../../../src/core/desktop-file-service.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 5225 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 593 "../../../src/core/desktop-file-service.vala"
		_data_->_tmp4_ = _data_->fis;
#line 593 "../../../src/core/desktop-file-service.vala"
		_data_->_tmp5_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp4_);
#line 593 "../../../src/core/desktop-file-service.vala"
		_data_->dis = _data_->_tmp5_;
#line 594 "../../../src/core/desktop-file-service.vala"
		_data_->line = NULL;
#line 595 "../../../src/core/desktop-file-service.vala"
		_data_->mimes = NULL;
#line 595 "../../../src/core/desktop-file-service.vala"
		_data_->mimes_length1 = 0;
#line 595 "../../../src/core/desktop-file-service.vala"
		_data_->_mimes_size_ = _data_->mimes_length1;
#line 596 "../../../src/core/desktop-file-service.vala"
		_data_->len = 0;
#line 598 "../../../src/core/desktop-file-service.vala"
		while (TRUE) {
#line 599 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp7_ = _data_->dis;
#line 599 "../../../src/core/desktop-file-service.vala"
			_data_->_state_ = 3;
#line 599 "../../../src/core/desktop-file-service.vala"
			g_data_input_stream_read_line_async (_data_->_tmp7_, G_PRIORITY_DEFAULT, NULL, synapse_desktop_file_service_load_mime_parents_from_file_ready, _data_);
#line 599 "../../../src/core/desktop-file-service.vala"
			return FALSE;
#line 5254 "desktop-file-service.c"
			_state_3:
#line 599 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp8_ = g_data_input_stream_read_line_finish (_data_->_tmp7_, _data_->_res_, NULL, &_data_->_inner_error0_);
#line 599 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp6_ = _data_->_tmp8_;
#line 599 "../../../src/core/desktop-file-service.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 599 "../../../src/core/desktop-file-service.vala"
				_data_->mimes = (_vala_array_free (_data_->mimes, _data_->mimes_length1, (GDestroyNotify) g_free), NULL);
#line 599 "../../../src/core/desktop-file-service.vala"
				_g_free0 (_data_->line);
#line 599 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (_data_->dis);
#line 599 "../../../src/core/desktop-file-service.vala"
				_g_object_unref0 (_data_->fis);
#line 5270 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 599 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp9_ = _data_->_tmp6_;
#line 599 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp6_ = NULL;
#line 599 "../../../src/core/desktop-file-service.vala"
			_g_free0 (_data_->line);
#line 599 "../../../src/core/desktop-file-service.vala"
			_data_->line = _data_->_tmp9_;
#line 600 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp10_ = _data_->line;
#line 600 "../../../src/core/desktop-file-service.vala"
			if (_data_->_tmp10_ == NULL) {
#line 600 "../../../src/core/desktop-file-service.vala"
				_g_free0 (_data_->_tmp6_);
#line 600 "../../../src/core/desktop-file-service.vala"
				break;
#line 5289 "desktop-file-service.c"
			}
#line 601 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp11_ = _data_->line;
#line 601 "../../../src/core/desktop-file-service.vala"
			if (g_str_has_prefix (_data_->_tmp11_, "#")) {
#line 601 "../../../src/core/desktop-file-service.vala"
				_g_free0 (_data_->_tmp6_);
#line 601 "../../../src/core/desktop-file-service.vala"
				continue;
#line 5299 "desktop-file-service.c"
			}
#line 602 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp12_ = _data_->line;
#line 602 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp14_ = _data_->_tmp13_ = g_strsplit (_data_->_tmp12_, " ", 0);
#line 602 "../../../src/core/desktop-file-service.vala"
			_data_->mimes = (_vala_array_free (_data_->mimes, _data_->mimes_length1, (GDestroyNotify) g_free), NULL);
#line 602 "../../../src/core/desktop-file-service.vala"
			_data_->mimes = _data_->_tmp14_;
#line 602 "../../../src/core/desktop-file-service.vala"
			_data_->mimes_length1 = _vala_array_length (_data_->_tmp13_);
#line 602 "../../../src/core/desktop-file-service.vala"
			_data_->_mimes_size_ = _data_->mimes_length1;
#line 603 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp15_ = _data_->mimes;
#line 603 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp15__length1 = _data_->mimes_length1;
#line 603 "../../../src/core/desktop-file-service.vala"
			_data_->len = (gint) g_strv_length (_data_->_tmp15_);
#line 604 "../../../src/core/desktop-file-service.vala"
			if (_data_->len != 2) {
#line 604 "../../../src/core/desktop-file-service.vala"
				_g_free0 (_data_->_tmp6_);
#line 604 "../../../src/core/desktop-file-service.vala"
				continue;
#line 5325 "desktop-file-service.c"
			}
#line 606 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp16_ = _data_->mimes;
#line 606 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp16__length1 = _data_->mimes_length1;
#line 606 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp17_ = _data_->_tmp16_[0];
#line 606 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp18_ = _data_->mimes;
#line 606 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp18__length1 = _data_->mimes_length1;
#line 606 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp19_ = _data_->_tmp18_[1];
#line 606 "../../../src/core/desktop-file-service.vala"
			if (g_strcmp0 (_data_->_tmp17_, _data_->_tmp19_) == 0) {
#line 606 "../../../src/core/desktop-file-service.vala"
				_g_free0 (_data_->_tmp6_);
#line 606 "../../../src/core/desktop-file-service.vala"
				continue;
#line 5345 "desktop-file-service.c"
			}
#line 608 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp20_ = _data_->self->priv->mimetype_parent_map;
#line 608 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp21_ = _data_->mimes;
#line 608 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp21__length1 = _data_->mimes_length1;
#line 608 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp22_ = _data_->_tmp21_[0];
#line 608 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp23_ = _data_->mimes;
#line 608 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp23__length1 = _data_->mimes_length1;
#line 608 "../../../src/core/desktop-file-service.vala"
			_data_->_tmp24_ = _data_->_tmp23_[1];
#line 608 "../../../src/core/desktop-file-service.vala"
			gee_multi_map_set (_data_->_tmp20_, _data_->_tmp22_, _data_->_tmp24_);
#line 598 "../../../src/core/desktop-file-service.vala"
			_g_free0 (_data_->_tmp6_);
#line 5365 "desktop-file-service.c"
		}
#line 590 "../../../src/core/desktop-file-service.vala"
		_data_->mimes = (_vala_array_free (_data_->mimes, _data_->mimes_length1, (GDestroyNotify) g_free), NULL);
#line 590 "../../../src/core/desktop-file-service.vala"
		_g_free0 (_data_->line);
#line 590 "../../../src/core/desktop-file-service.vala"
		_g_object_unref0 (_data_->dis);
#line 590 "../../../src/core/desktop-file-service.vala"
		_g_object_unref0 (_data_->fis);
#line 5375 "desktop-file-service.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 590 "../../../src/core/desktop-file-service.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 5382 "desktop-file-service.c"
	}
	__finally0:
#line 590 "../../../src/core/desktop-file-service.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 590 "../../../src/core/desktop-file-service.vala"
		_g_object_unref0 (_data_->file);
#line 590 "../../../src/core/desktop-file-service.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 590 "../../../src/core/desktop-file-service.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 590 "../../../src/core/desktop-file-service.vala"
		g_object_unref (_data_->_async_result);
#line 590 "../../../src/core/desktop-file-service.vala"
		return FALSE;
#line 5397 "desktop-file-service.c"
	}
#line 585 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (_data_->file);
#line 585 "../../../src/core/desktop-file-service.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 585 "../../../src/core/desktop-file-service.vala"
	if (_data_->_state_ != 0) {
#line 585 "../../../src/core/desktop-file-service.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 585 "../../../src/core/desktop-file-service.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 5409 "desktop-file-service.c"
		}
	}
#line 585 "../../../src/core/desktop-file-service.vala"
	g_object_unref (_data_->_async_result);
#line 585 "../../../src/core/desktop-file-service.vala"
	return FALSE;
#line 5416 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_add_dfi_for_mime (SynapseDesktopFileService* self,
                                               const gchar* mime,
                                               GeeSet* ret)
{
	GeeList* dfis = NULL;
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	GeeList* _tmp2_;
	GeeCollection* parents = NULL;
	GeeMultiMap* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
#line 613 "../../../src/core/desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 613 "../../../src/core/desktop-file-service.vala"
	g_return_if_fail (mime != NULL);
#line 613 "../../../src/core/desktop-file-service.vala"
	g_return_if_fail (ret != NULL);
#line 615 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = self->priv->mimetype_map;
#line 615 "../../../src/core/desktop-file-service.vala"
	_tmp1_ = gee_map_get (_tmp0_, mime);
#line 615 "../../../src/core/desktop-file-service.vala"
	dfis = (GeeList*) _tmp1_;
#line 616 "../../../src/core/desktop-file-service.vala"
	_tmp2_ = dfis;
#line 616 "../../../src/core/desktop-file-service.vala"
	if (_tmp2_ != NULL) {
#line 5448 "desktop-file-service.c"
		GeeList* _tmp3_;
#line 616 "../../../src/core/desktop-file-service.vala"
		_tmp3_ = dfis;
#line 616 "../../../src/core/desktop-file-service.vala"
		gee_collection_add_all ((GeeCollection*) ret, (GeeCollection*) _tmp3_);
#line 5454 "desktop-file-service.c"
	}
#line 618 "../../../src/core/desktop-file-service.vala"
	_tmp4_ = self->priv->mimetype_parent_map;
#line 618 "../../../src/core/desktop-file-service.vala"
	_tmp5_ = gee_multi_map_get (_tmp4_, mime);
#line 618 "../../../src/core/desktop-file-service.vala"
	parents = _tmp5_;
#line 619 "../../../src/core/desktop-file-service.vala"
	_tmp6_ = parents;
#line 619 "../../../src/core/desktop-file-service.vala"
	if (_tmp6_ == NULL) {
#line 619 "../../../src/core/desktop-file-service.vala"
		_g_object_unref0 (parents);
#line 619 "../../../src/core/desktop-file-service.vala"
		_g_object_unref0 (dfis);
#line 619 "../../../src/core/desktop-file-service.vala"
		return;
#line 5472 "desktop-file-service.c"
	}
	{
		GeeIterator* _parent_it = NULL;
		GeeCollection* _tmp7_;
		GeeIterator* _tmp8_;
#line 620 "../../../src/core/desktop-file-service.vala"
		_tmp7_ = parents;
#line 620 "../../../src/core/desktop-file-service.vala"
		_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
#line 620 "../../../src/core/desktop-file-service.vala"
		_parent_it = _tmp8_;
#line 620 "../../../src/core/desktop-file-service.vala"
		while (TRUE) {
#line 5486 "desktop-file-service.c"
			GeeIterator* _tmp9_;
			gchar* parent = NULL;
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			const gchar* _tmp12_;
#line 620 "../../../src/core/desktop-file-service.vala"
			_tmp9_ = _parent_it;
#line 620 "../../../src/core/desktop-file-service.vala"
			if (!gee_iterator_next (_tmp9_)) {
#line 620 "../../../src/core/desktop-file-service.vala"
				break;
#line 5498 "desktop-file-service.c"
			}
#line 620 "../../../src/core/desktop-file-service.vala"
			_tmp10_ = _parent_it;
#line 620 "../../../src/core/desktop-file-service.vala"
			_tmp11_ = gee_iterator_get (_tmp10_);
#line 620 "../../../src/core/desktop-file-service.vala"
			parent = (gchar*) _tmp11_;
#line 621 "../../../src/core/desktop-file-service.vala"
			_tmp12_ = parent;
#line 621 "../../../src/core/desktop-file-service.vala"
			synapse_desktop_file_service_add_dfi_for_mime (self, _tmp12_, ret);
#line 620 "../../../src/core/desktop-file-service.vala"
			_g_free0 (parent);
#line 5512 "desktop-file-service.c"
		}
#line 620 "../../../src/core/desktop-file-service.vala"
		_g_object_unref0 (_parent_it);
#line 5516 "desktop-file-service.c"
	}
#line 613 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (parents);
#line 613 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (dfis);
#line 5522 "desktop-file-service.c"
}

GeeList*
synapse_desktop_file_service_get_desktop_files (SynapseDesktopFileService* self)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* result = NULL;
#line 625 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 627 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = self->priv->non_hidden_desktop_files;
#line 627 "../../../src/core/desktop-file-service.vala"
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
#line 627 "../../../src/core/desktop-file-service.vala"
	_tmp2_ = _tmp1_;
#line 627 "../../../src/core/desktop-file-service.vala"
	result = _tmp2_;
#line 627 "../../../src/core/desktop-file-service.vala"
	return result;
#line 5544 "desktop-file-service.c"
}

GeeList*
synapse_desktop_file_service_get_all_desktop_files (SynapseDesktopFileService* self)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* result = NULL;
#line 632 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 634 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = self->priv->all_desktop_files;
#line 634 "../../../src/core/desktop-file-service.vala"
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
#line 634 "../../../src/core/desktop-file-service.vala"
	_tmp2_ = _tmp1_;
#line 634 "../../../src/core/desktop-file-service.vala"
	result = _tmp2_;
#line 634 "../../../src/core/desktop-file-service.vala"
	return result;
#line 5566 "desktop-file-service.c"
}

GeeList*
synapse_desktop_file_service_get_desktop_files_for_type (SynapseDesktopFileService* self,
                                                         const gchar* mime_type)
{
	GeeHashSet* dfi_set = NULL;
	GeeHashSet* _tmp0_;
	GeeArrayList* ret = NULL;
	GeeArrayList* _tmp1_;
	GeeList* result = NULL;
#line 637 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 637 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (mime_type != NULL, NULL);
#line 639 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = gee_hash_set_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 639 "../../../src/core/desktop-file-service.vala"
	dfi_set = _tmp0_;
#line 640 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_add_dfi_for_mime (self, mime_type, (GeeSet*) dfi_set);
#line 641 "../../../src/core/desktop-file-service.vala"
	_tmp1_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 641 "../../../src/core/desktop-file-service.vala"
	ret = _tmp1_;
#line 642 "../../../src/core/desktop-file-service.vala"
	gee_array_list_add_all (ret, (GeeCollection*) dfi_set);
#line 643 "../../../src/core/desktop-file-service.vala"
	result = (GeeList*) ret;
#line 643 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (dfi_set);
#line 643 "../../../src/core/desktop-file-service.vala"
	return result;
#line 5600 "desktop-file-service.c"
}

GeeList*
synapse_desktop_file_service_get_desktop_files_for_exec (SynapseDesktopFileService* self,
                                                         const gchar* exec)
{
	GeeList* _tmp0_ = NULL;
	GeeMap* _tmp1_;
	gpointer _tmp2_;
	GeeList* _tmp4_;
	GeeList* result = NULL;
#line 646 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 646 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (exec != NULL, NULL);
#line 648 "../../../src/core/desktop-file-service.vala"
	_tmp1_ = self->priv->exec_map;
#line 648 "../../../src/core/desktop-file-service.vala"
	_tmp2_ = gee_map_get (_tmp1_, exec);
#line 648 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = (GeeList*) _tmp2_;
#line 648 "../../../src/core/desktop-file-service.vala"
	if (_tmp0_ == NULL) {
#line 5624 "desktop-file-service.c"
		GeeArrayList* _tmp3_;
#line 648 "../../../src/core/desktop-file-service.vala"
		_tmp3_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 648 "../../../src/core/desktop-file-service.vala"
		_g_object_unref0 (_tmp0_);
#line 648 "../../../src/core/desktop-file-service.vala"
		_tmp0_ = (GeeList*) _tmp3_;
#line 5632 "desktop-file-service.c"
	}
#line 648 "../../../src/core/desktop-file-service.vala"
	_tmp4_ = _tmp0_;
#line 648 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = NULL;
#line 648 "../../../src/core/desktop-file-service.vala"
	result = _tmp4_;
#line 648 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (_tmp0_);
#line 648 "../../../src/core/desktop-file-service.vala"
	return result;
#line 5644 "desktop-file-service.c"
}

SynapseDesktopFileInfo*
synapse_desktop_file_service_get_desktop_file_for_id (SynapseDesktopFileService* self,
                                                      const gchar* desktop_id)
{
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	SynapseDesktopFileInfo* result = NULL;
#line 651 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 651 "../../../src/core/desktop-file-service.vala"
	g_return_val_if_fail (desktop_id != NULL, NULL);
#line 653 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = self->priv->desktop_id_map;
#line 653 "../../../src/core/desktop-file-service.vala"
	_tmp1_ = gee_map_get (_tmp0_, desktop_id);
#line 653 "../../../src/core/desktop-file-service.vala"
	result = (SynapseDesktopFileInfo*) _tmp1_;
#line 653 "../../../src/core/desktop-file-service.vala"
	return result;
#line 5666 "desktop-file-service.c"
}

static GObject *
synapse_desktop_file_service_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDesktopFileService * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeHashMultiMap* _tmp3_;
	SynapseUtilsAsyncOnce* _tmp4_;
#line 229 "../../../src/core/desktop-file-service.vala"
	parent_class = G_OBJECT_CLASS (synapse_desktop_file_service_parent_class);
#line 229 "../../../src/core/desktop-file-service.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 229 "../../../src/core/desktop-file-service.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileService);
#line 231 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_instance = self;
#line 233 "../../../src/core/desktop-file-service.vala"
	_tmp0_ = gee_array_list_new (g_file_monitor_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 233 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->directory_monitors);
#line 233 "../../../src/core/desktop-file-service.vala"
	self->priv->directory_monitors = (GeeList*) _tmp0_;
#line 234 "../../../src/core/desktop-file-service.vala"
	_tmp1_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 234 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->all_desktop_files);
#line 234 "../../../src/core/desktop-file-service.vala"
	self->priv->all_desktop_files = (GeeList*) _tmp1_;
#line 235 "../../../src/core/desktop-file-service.vala"
	_tmp2_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 235 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->non_hidden_desktop_files);
#line 235 "../../../src/core/desktop-file-service.vala"
	self->priv->non_hidden_desktop_files = (GeeList*) _tmp2_;
#line 236 "../../../src/core/desktop-file-service.vala"
	_tmp3_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 236 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->mimetype_parent_map);
#line 236 "../../../src/core/desktop-file-service.vala"
	self->priv->mimetype_parent_map = (GeeMultiMap*) _tmp3_;
#line 237 "../../../src/core/desktop-file-service.vala"
	_tmp4_ = synapse_utils_async_once_new (G_TYPE_BOOLEAN, NULL, NULL);
#line 237 "../../../src/core/desktop-file-service.vala"
	_synapse_utils_async_once_unref0 (self->priv->init_once);
#line 237 "../../../src/core/desktop-file-service.vala"
	self->priv->init_once = _tmp4_;
#line 239 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_initialize (self, NULL, NULL);
#line 229 "../../../src/core/desktop-file-service.vala"
	return obj;
#line 5724 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_class_init (SynapseDesktopFileServiceClass * klass,
                                         gpointer klass_data)
{
#line 206 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_parent_class = g_type_class_peek_parent (klass);
#line 206 "../../../src/core/desktop-file-service.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFileService_private_offset);
#line 206 "../../../src/core/desktop-file-service.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_desktop_file_service_constructor;
#line 206 "../../../src/core/desktop-file-service.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_service_finalize;
#line 206 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_STARTED_SIGNAL] = g_signal_new ("reload-started", SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 206 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_DONE_SIGNAL] = g_signal_new ("reload-done", SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 5743 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_instance_init (SynapseDesktopFileService * self,
                                            gpointer klass)
{
#line 206 "../../../src/core/desktop-file-service.vala"
	self->priv = synapse_desktop_file_service_get_instance_private (self);
#line 264 "../../../src/core/desktop-file-service.vala"
	self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME;
#line 265 "../../../src/core/desktop-file-service.vala"
	self->priv->session_type_str = "GNOME";
#line 458 "../../../src/core/desktop-file-service.vala"
	self->priv->timer_id = (guint) 0;
#line 5758 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_finalize (GObject * obj)
{
	SynapseDesktopFileService * self;
#line 206 "../../../src/core/desktop-file-service.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileService);
#line 244 "../../../src/core/desktop-file-service.vala"
	synapse_desktop_file_service_instance = NULL;
#line 209 "../../../src/core/desktop-file-service.vala"
	_synapse_utils_async_once_unref0 (self->priv->init_once);
#line 221 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->directory_monitors);
#line 222 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->all_desktop_files);
#line 223 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->non_hidden_desktop_files);
#line 224 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->mimetype_map);
#line 225 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->exec_map);
#line 226 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->desktop_id_map);
#line 227 "../../../src/core/desktop-file-service.vala"
	_g_object_unref0 (self->priv->mimetype_parent_map);
#line 206 "../../../src/core/desktop-file-service.vala"
	G_OBJECT_CLASS (synapse_desktop_file_service_parent_class)->finalize (obj);
#line 5787 "desktop-file-service.c"
}

static GType
synapse_desktop_file_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFileServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFileService), 0, (GInstanceInitFunc) synapse_desktop_file_service_instance_init, NULL };
	GType synapse_desktop_file_service_type_id;
	synapse_desktop_file_service_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFileService", &g_define_type_info, 0);
	SynapseDesktopFileService_private_offset = g_type_add_instance_private (synapse_desktop_file_service_type_id, sizeof (SynapseDesktopFileServicePrivate));
	return synapse_desktop_file_service_type_id;
}

GType
synapse_desktop_file_service_get_type (void)
{
	static volatile gsize synapse_desktop_file_service_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_desktop_file_service_type_id__volatile)) {
		GType synapse_desktop_file_service_type_id;
		synapse_desktop_file_service_type_id = synapse_desktop_file_service_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_service_type_id__volatile, synapse_desktop_file_service_type_id);
	}
	return synapse_desktop_file_service_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 239 "../../../src/core/data-sink.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 5819 "desktop-file-service.c"
		gint i;
#line 239 "../../../src/core/data-sink.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 239 "../../../src/core/data-sink.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 239 "../../../src/core/data-sink.vala"
				destroy_func (((gpointer*) array)[i]);
#line 5827 "desktop-file-service.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 239 "../../../src/core/data-sink.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 239 "../../../src/core/data-sink.vala"
	g_free (array);
#line 5842 "desktop-file-service.c"
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
#line 239 "../../../src/core/data-sink.vala"
	if (array) {
#line 239 "../../../src/core/data-sink.vala"
		while (((gpointer*) array)[length]) {
#line 239 "../../../src/core/data-sink.vala"
			length++;
#line 5856 "desktop-file-service.c"
		}
	}
#line 239 "../../../src/core/data-sink.vala"
	return length;
#line 5861 "desktop-file-service.c"
}

