/* match.c generated by valac 0.48.17, the Vala compiler
 * generated from match.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *             Alberto Aldegheri <albyrock87+dev@gmail.com>
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>

typedef enum  {
	SYNAPSE_MATCH_SCORE_INCREMENT_MINOR = 2000,
	SYNAPSE_MATCH_SCORE_INCREMENT_SMALL = 5000,
	SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM = 10000,
	SYNAPSE_MATCH_SCORE_INCREMENT_LARGE = 20000,
	SYNAPSE_MATCH_SCORE_URI_PENALTY = 15000,
	SYNAPSE_MATCH_SCORE_POOR = 50000,
	SYNAPSE_MATCH_SCORE_BELOW_AVERAGE = 60000,
	SYNAPSE_MATCH_SCORE_AVERAGE = 70000,
	SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE = 75000,
	SYNAPSE_MATCH_SCORE_GOOD = 80000,
	SYNAPSE_MATCH_SCORE_VERY_GOOD = 85000,
	SYNAPSE_MATCH_SCORE_EXCELLENT = 90000,
	SYNAPSE_MATCH_SCORE_HIGHEST = 100000
} SynapseMatchScore;

#define SYNAPSE_TYPE_MATCH_SCORE (synapse_match_score_get_type ())

#define SYNAPSE_TYPE_MATCH (synapse_match_get_type ())
#define SYNAPSE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_MATCH, SynapseMatch))
#define SYNAPSE_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_MATCH, SynapseMatchClass))
#define SYNAPSE_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_IS_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_MATCH))
#define SYNAPSE_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_MATCH, SynapseMatchClass))

typedef struct _SynapseMatch SynapseMatch;
typedef struct _SynapseMatchClass SynapseMatchClass;
typedef struct _SynapseMatchPrivate SynapseMatchPrivate;
typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;

#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())
enum  {
	SYNAPSE_MATCH_0_PROPERTY,
	SYNAPSE_MATCH_TITLE_PROPERTY,
	SYNAPSE_MATCH_DESCRIPTION_PROPERTY,
	SYNAPSE_MATCH_ICON_NAME_PROPERTY,
	SYNAPSE_MATCH_HAS_THUMBNAIL_PROPERTY,
	SYNAPSE_MATCH_THUMBNAIL_PATH_PROPERTY,
	SYNAPSE_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_match_properties[SYNAPSE_MATCH_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	SYNAPSE_MATCH_EXECUTED_SIGNAL,
	SYNAPSE_MATCH_NUM_SIGNALS
};
static guint synapse_match_signals[SYNAPSE_MATCH_NUM_SIGNALS] = {0};

#define SYNAPSE_TYPE_ACTION_MATCH (synapse_action_match_get_type ())
#define SYNAPSE_ACTION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ACTION_MATCH, SynapseActionMatch))
#define SYNAPSE_ACTION_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_ACTION_MATCH, SynapseActionMatchClass))
#define SYNAPSE_IS_ACTION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ACTION_MATCH))
#define SYNAPSE_IS_ACTION_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_ACTION_MATCH))
#define SYNAPSE_ACTION_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_ACTION_MATCH, SynapseActionMatchClass))

typedef struct _SynapseActionMatch SynapseActionMatch;
typedef struct _SynapseActionMatchClass SynapseActionMatchClass;
typedef struct _SynapseActionMatchPrivate SynapseActionMatchPrivate;
enum  {
	SYNAPSE_ACTION_MATCH_0_PROPERTY,
	SYNAPSE_ACTION_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_action_match_properties[SYNAPSE_ACTION_MATCH_NUM_PROPERTIES];

#define SYNAPSE_TYPE_APPLICATION_MATCH (synapse_application_match_get_type ())
#define SYNAPSE_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch))
#define SYNAPSE_APPLICATION_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatchClass))
#define SYNAPSE_IS_APPLICATION_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_APPLICATION_MATCH))
#define SYNAPSE_IS_APPLICATION_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_APPLICATION_MATCH))
#define SYNAPSE_APPLICATION_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatchClass))

typedef struct _SynapseApplicationMatch SynapseApplicationMatch;
typedef struct _SynapseApplicationMatchClass SynapseApplicationMatchClass;
typedef struct _SynapseApplicationMatchPrivate SynapseApplicationMatchPrivate;
enum  {
	SYNAPSE_APPLICATION_MATCH_0_PROPERTY,
	SYNAPSE_APPLICATION_MATCH_APP_INFO_PROPERTY,
	SYNAPSE_APPLICATION_MATCH_NEEDS_TERMINAL_PROPERTY,
	SYNAPSE_APPLICATION_MATCH_FILENAME_PROPERTY,
	SYNAPSE_APPLICATION_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_application_match_properties[SYNAPSE_APPLICATION_MATCH_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SYNAPSE_TYPE_URI_MATCH (synapse_uri_match_get_type ())
#define SYNAPSE_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch))
#define SYNAPSE_URI_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchClass))
#define SYNAPSE_IS_URI_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_IS_URI_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_URI_MATCH))
#define SYNAPSE_URI_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_URI_MATCH, SynapseUriMatchClass))

typedef struct _SynapseUriMatch SynapseUriMatch;
typedef struct _SynapseUriMatchClass SynapseUriMatchClass;
typedef struct _SynapseUriMatchPrivate SynapseUriMatchPrivate;
enum  {
	SYNAPSE_URI_MATCH_0_PROPERTY,
	SYNAPSE_URI_MATCH_URI_PROPERTY,
	SYNAPSE_URI_MATCH_FILE_TYPE_PROPERTY,
	SYNAPSE_URI_MATCH_MIME_TYPE_PROPERTY,
	SYNAPSE_URI_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_uri_match_properties[SYNAPSE_URI_MATCH_NUM_PROPERTIES];

#define SYNAPSE_TYPE_CONTACT_MATCH (synapse_contact_match_get_type ())
#define SYNAPSE_CONTACT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_CONTACT_MATCH, SynapseContactMatch))
#define SYNAPSE_CONTACT_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_CONTACT_MATCH, SynapseContactMatchClass))
#define SYNAPSE_IS_CONTACT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_CONTACT_MATCH))
#define SYNAPSE_IS_CONTACT_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_CONTACT_MATCH))
#define SYNAPSE_CONTACT_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_CONTACT_MATCH, SynapseContactMatchClass))

typedef struct _SynapseContactMatch SynapseContactMatch;
typedef struct _SynapseContactMatchClass SynapseContactMatchClass;
typedef struct _SynapseContactMatchPrivate SynapseContactMatchPrivate;
enum  {
	SYNAPSE_CONTACT_MATCH_0_PROPERTY,
	SYNAPSE_CONTACT_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_contact_match_properties[SYNAPSE_CONTACT_MATCH_NUM_PROPERTIES];

#define SYNAPSE_TYPE_EXTENDED_INFO (synapse_extended_info_get_type ())
#define SYNAPSE_EXTENDED_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_EXTENDED_INFO, SynapseExtendedInfo))
#define SYNAPSE_IS_EXTENDED_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_EXTENDED_INFO))
#define SYNAPSE_EXTENDED_INFO_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_EXTENDED_INFO, SynapseExtendedInfoIface))

typedef struct _SynapseExtendedInfo SynapseExtendedInfo;
typedef struct _SynapseExtendedInfoIface SynapseExtendedInfoIface;
typedef enum  {
	SYNAPSE_TEXT_ORIGIN_UNKNOWN,
	SYNAPSE_TEXT_ORIGIN_CLIPBOARD
} SynapseTextOrigin;

#define SYNAPSE_TYPE_TEXT_ORIGIN (synapse_text_origin_get_type ())

#define SYNAPSE_TYPE_TEXT_MATCH (synapse_text_match_get_type ())
#define SYNAPSE_TEXT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatch))
#define SYNAPSE_TEXT_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatchClass))
#define SYNAPSE_IS_TEXT_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_TEXT_MATCH))
#define SYNAPSE_IS_TEXT_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_TEXT_MATCH))
#define SYNAPSE_TEXT_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatchClass))

typedef struct _SynapseTextMatch SynapseTextMatch;
typedef struct _SynapseTextMatchClass SynapseTextMatchClass;
typedef struct _SynapseTextMatchPrivate SynapseTextMatchPrivate;
enum  {
	SYNAPSE_TEXT_MATCH_0_PROPERTY,
	SYNAPSE_TEXT_MATCH_TEXT_ORIGIN_PROPERTY,
	SYNAPSE_TEXT_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_text_match_properties[SYNAPSE_TEXT_MATCH_NUM_PROPERTIES];

#define SYNAPSE_TYPE_SEARCH_PROVIDER (synapse_search_provider_get_type ())
#define SYNAPSE_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER, SynapseSearchProvider))
#define SYNAPSE_IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER))
#define SYNAPSE_SEARCH_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_SEARCH_PROVIDER, SynapseSearchProviderIface))

typedef struct _SynapseSearchProvider SynapseSearchProvider;
typedef struct _SynapseSearchProviderIface SynapseSearchProviderIface;

#define SYNAPSE_TYPE_RESULT_SET (synapse_result_set_get_type ())
#define SYNAPSE_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSet))
#define SYNAPSE_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))
#define SYNAPSE_IS_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_IS_RESULT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RESULT_SET))
#define SYNAPSE_RESULT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RESULT_SET, SynapseResultSetClass))

typedef struct _SynapseResultSet SynapseResultSet;
typedef struct _SynapseResultSetClass SynapseResultSetClass;

#define SYNAPSE_TYPE_SEARCH_MATCH (synapse_search_match_get_type ())
#define SYNAPSE_SEARCH_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatch))
#define SYNAPSE_SEARCH_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatchClass))
#define SYNAPSE_IS_SEARCH_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_SEARCH_MATCH))
#define SYNAPSE_IS_SEARCH_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_SEARCH_MATCH))
#define SYNAPSE_SEARCH_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatchClass))

typedef struct _SynapseSearchMatch SynapseSearchMatch;
typedef struct _SynapseSearchMatchClass SynapseSearchMatchClass;
typedef struct _SynapseSearchMatchPrivate SynapseSearchMatchPrivate;
enum  {
	SYNAPSE_SEARCH_MATCH_0_PROPERTY,
	SYNAPSE_SEARCH_MATCH_SEARCH_SOURCE_PROPERTY,
	SYNAPSE_SEARCH_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_search_match_properties[SYNAPSE_SEARCH_MATCH_NUM_PROPERTIES];

#define SYNAPSE_TYPE_UNKNOWN_MATCH (synapse_unknown_match_get_type ())
#define SYNAPSE_UNKNOWN_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_UNKNOWN_MATCH, SynapseUnknownMatch))
#define SYNAPSE_UNKNOWN_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_UNKNOWN_MATCH, SynapseUnknownMatchClass))
#define SYNAPSE_IS_UNKNOWN_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_UNKNOWN_MATCH))
#define SYNAPSE_IS_UNKNOWN_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_UNKNOWN_MATCH))
#define SYNAPSE_UNKNOWN_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_UNKNOWN_MATCH, SynapseUnknownMatchClass))

typedef struct _SynapseUnknownMatch SynapseUnknownMatch;
typedef struct _SynapseUnknownMatchClass SynapseUnknownMatchClass;
typedef struct _SynapseUnknownMatchPrivate SynapseUnknownMatchPrivate;
enum  {
	SYNAPSE_UNKNOWN_MATCH_0_PROPERTY,
	SYNAPSE_UNKNOWN_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_unknown_match_properties[SYNAPSE_UNKNOWN_MATCH_NUM_PROPERTIES];

struct _SynapseMatch {
	GObject parent_instance;
	SynapseMatchPrivate * priv;
};

struct _SynapseMatchClass {
	GObjectClass parent_class;
	void (*execute) (SynapseMatch* self, SynapseMatch* match);
	void (*execute_with_target) (SynapseMatch* self, SynapseMatch* source, SynapseMatch* target);
	gboolean (*needs_target) (SynapseMatch* self);
	SynapseQueryFlags (*target_flags) (SynapseMatch* self);
};

struct _SynapseMatchPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
};

struct _SynapseActionMatch {
	SynapseMatch parent_instance;
	SynapseActionMatchPrivate * priv;
};

struct _SynapseActionMatchClass {
	SynapseMatchClass parent_class;
	void (*do_action) (SynapseActionMatch* self);
};

struct _SynapseApplicationMatch {
	SynapseMatch parent_instance;
	SynapseApplicationMatchPrivate * priv;
};

struct _SynapseApplicationMatchClass {
	SynapseMatchClass parent_class;
};

struct _SynapseApplicationMatchPrivate {
	GAppInfo* _app_info;
	gboolean _needs_terminal;
	gchar* _filename;
};

struct _SynapseUriMatch {
	SynapseMatch parent_instance;
	SynapseUriMatchPrivate * priv;
};

struct _SynapseUriMatchClass {
	SynapseMatchClass parent_class;
};

struct _SynapseUriMatchPrivate {
	gchar* _uri;
	SynapseQueryFlags _file_type;
	gchar* _mime_type;
};

struct _SynapseContactMatch {
	SynapseMatch parent_instance;
	SynapseContactMatchPrivate * priv;
};

struct _SynapseContactMatchClass {
	SynapseMatchClass parent_class;
	void (*send_message) (SynapseContactMatch* self, const gchar* message, gboolean present);
	void (*open_chat) (SynapseContactMatch* self);
};

struct _SynapseExtendedInfoIface {
	GTypeInterface parent_iface;
	const gchar* (*get_extended_info) (SynapseExtendedInfo* self);
	void (*set_extended_info) (SynapseExtendedInfo* self, const gchar* value);
};

struct _SynapseTextMatch {
	SynapseMatch parent_instance;
	SynapseTextMatchPrivate * priv;
};

struct _SynapseTextMatchClass {
	SynapseMatchClass parent_class;
	gchar* (*get_text) (SynapseTextMatch* self);
};

struct _SynapseTextMatchPrivate {
	SynapseTextOrigin _text_origin;
};

typedef enum  {
	SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED,
	SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR
} SynapseSearchError;
#define SYNAPSE_SEARCH_ERROR synapse_search_error_quark ()
struct _SynapseSearchProviderIface {
	GTypeInterface parent_iface;
	void (*search) (SynapseSearchProvider* self, const gchar* query, SynapseQueryFlags flags, SynapseResultSet* dest_result_set, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeList* (*search_finish) (SynapseSearchProvider* self, GAsyncResult* _res_, GError** error);
};

struct _SynapseSearchMatch {
	SynapseMatch parent_instance;
	SynapseSearchMatchPrivate * priv;
};

struct _SynapseSearchMatchClass {
	SynapseMatchClass parent_class;
	void (*search) (SynapseSearchMatch* self, const gchar* query, SynapseQueryFlags flags, SynapseResultSet* dest_result_set, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeList* (*search_finish) (SynapseSearchMatch* self, GAsyncResult* _res_, GError** error);
};

struct _SynapseSearchMatchPrivate {
	SynapseMatch* _search_source;
};

struct _SynapseUnknownMatch {
	SynapseMatch parent_instance;
	SynapseUnknownMatchPrivate * priv;
};

struct _SynapseUnknownMatchClass {
	SynapseMatchClass parent_class;
};

static gint SynapseMatch_private_offset;
static gpointer synapse_match_parent_class = NULL;
static gpointer synapse_action_match_parent_class = NULL;
static gint SynapseApplicationMatch_private_offset;
static gpointer synapse_application_match_parent_class = NULL;
static gint SynapseUriMatch_private_offset;
static gpointer synapse_uri_match_parent_class = NULL;
static gpointer synapse_contact_match_parent_class = NULL;
static gint SynapseTextMatch_private_offset;
static gpointer synapse_text_match_parent_class = NULL;
static gint SynapseSearchMatch_private_offset;
static gpointer synapse_search_match_parent_class = NULL;
static SynapseSearchProviderIface * synapse_search_match_synapse_search_provider_parent_iface = NULL;
static gpointer synapse_unknown_match_parent_class = NULL;

GType synapse_match_score_get_type (void) G_GNUC_CONST;
GType synapse_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseMatch, g_object_unref)
GType synapse_query_flags_get_type (void) G_GNUC_CONST;
void synapse_match_execute (SynapseMatch* self,
                            SynapseMatch* match);
void synapse_match_execute_with_target (SynapseMatch* self,
                                        SynapseMatch* source,
                                        SynapseMatch* target);
gboolean synapse_match_needs_target (SynapseMatch* self);
SynapseQueryFlags synapse_match_target_flags (SynapseMatch* self);
static void synapse_match_real_execute (SynapseMatch* self,
                                 SynapseMatch* match);
static void synapse_match_real_execute_with_target (SynapseMatch* self,
                                             SynapseMatch* source,
                                             SynapseMatch* target);
static gboolean synapse_match_real_needs_target (SynapseMatch* self);
static SynapseQueryFlags synapse_match_real_target_flags (SynapseMatch* self);
SynapseMatch* synapse_match_construct (GType object_type);
const gchar* synapse_match_get_title (SynapseMatch* self);
void synapse_match_set_title (SynapseMatch* self,
                              const gchar* value);
const gchar* synapse_match_get_description (SynapseMatch* self);
void synapse_match_set_description (SynapseMatch* self,
                                    const gchar* value);
const gchar* synapse_match_get_icon_name (SynapseMatch* self);
void synapse_match_set_icon_name (SynapseMatch* self,
                                  const gchar* value);
gboolean synapse_match_get_has_thumbnail (SynapseMatch* self);
void synapse_match_set_has_thumbnail (SynapseMatch* self,
                                      gboolean value);
const gchar* synapse_match_get_thumbnail_path (SynapseMatch* self);
void synapse_match_set_thumbnail_path (SynapseMatch* self,
                                       const gchar* value);
static void synapse_match_finalize (GObject * obj);
static GType synapse_match_get_type_once (void);
static void _vala_synapse_match_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_synapse_match_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
GType synapse_action_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseActionMatch, g_object_unref)
void synapse_action_match_do_action (SynapseActionMatch* self);
static void synapse_action_match_real_do_action (SynapseActionMatch* self);
SynapseActionMatch* synapse_action_match_construct (GType object_type);
static GType synapse_action_match_get_type_once (void);
GType synapse_application_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseApplicationMatch, g_object_unref)
SynapseApplicationMatch* synapse_application_match_new (void);
SynapseApplicationMatch* synapse_application_match_construct (GType object_type);
GAppInfo* synapse_application_match_get_app_info (SynapseApplicationMatch* self);
void synapse_application_match_set_app_info (SynapseApplicationMatch* self,
                                             GAppInfo* value);
gboolean synapse_application_match_get_needs_terminal (SynapseApplicationMatch* self);
void synapse_application_match_set_needs_terminal (SynapseApplicationMatch* self,
                                                   gboolean value);
const gchar* synapse_application_match_get_filename (SynapseApplicationMatch* self);
void synapse_application_match_set_filename (SynapseApplicationMatch* self,
                                             const gchar* value);
static void synapse_application_match_finalize (GObject * obj);
static GType synapse_application_match_get_type_once (void);
static void _vala_synapse_application_match_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_synapse_application_match_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
GType synapse_uri_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseUriMatch, g_object_unref)
SynapseUriMatch* synapse_uri_match_new (void);
SynapseUriMatch* synapse_uri_match_construct (GType object_type);
const gchar* synapse_uri_match_get_uri (SynapseUriMatch* self);
void synapse_uri_match_set_uri (SynapseUriMatch* self,
                                const gchar* value);
SynapseQueryFlags synapse_uri_match_get_file_type (SynapseUriMatch* self);
void synapse_uri_match_set_file_type (SynapseUriMatch* self,
                                      SynapseQueryFlags value);
const gchar* synapse_uri_match_get_mime_type (SynapseUriMatch* self);
void synapse_uri_match_set_mime_type (SynapseUriMatch* self,
                                      const gchar* value);
static void synapse_uri_match_finalize (GObject * obj);
static GType synapse_uri_match_get_type_once (void);
static void _vala_synapse_uri_match_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_synapse_uri_match_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
GType synapse_contact_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseContactMatch, g_object_unref)
void synapse_contact_match_send_message (SynapseContactMatch* self,
                                         const gchar* message,
                                         gboolean present);
void synapse_contact_match_open_chat (SynapseContactMatch* self);
static void synapse_contact_match_real_send_message (SynapseContactMatch* self,
                                              const gchar* message,
                                              gboolean present);
static void synapse_contact_match_real_open_chat (SynapseContactMatch* self);
SynapseContactMatch* synapse_contact_match_construct (GType object_type);
static GType synapse_contact_match_get_type_once (void);
GType synapse_extended_info_get_type (void) G_GNUC_CONST;
const gchar* synapse_extended_info_get_extended_info (SynapseExtendedInfo* self);
void synapse_extended_info_set_extended_info (SynapseExtendedInfo* self,
                                              const gchar* value);
static GType synapse_extended_info_get_type_once (void);
GType synapse_text_origin_get_type (void) G_GNUC_CONST;
GType synapse_text_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseTextMatch, g_object_unref)
gchar* synapse_text_match_get_text (SynapseTextMatch* self);
static gchar* synapse_text_match_real_get_text (SynapseTextMatch* self);
SynapseTextMatch* synapse_text_match_construct (GType object_type);
SynapseTextOrigin synapse_text_match_get_text_origin (SynapseTextMatch* self);
static void synapse_text_match_set_text_origin (SynapseTextMatch* self,
                                         SynapseTextOrigin value);
static void synapse_text_match_finalize (GObject * obj);
static GType synapse_text_match_get_type_once (void);
static void _vala_synapse_text_match_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_synapse_text_match_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
GType synapse_result_set_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseResultSet, g_object_unref)
GQuark synapse_search_error_quark (void);
GType synapse_search_provider_get_type (void) G_GNUC_CONST;
GType synapse_search_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseSearchMatch, g_object_unref)
void synapse_search_match_search (SynapseSearchMatch* self,
                                  const gchar* query,
                                  SynapseQueryFlags flags,
                                  SynapseResultSet* dest_result_set,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
GeeList* synapse_search_match_search_finish (SynapseSearchMatch* self,
                                             GAsyncResult* _res_,
                                             GError** error);
SynapseSearchMatch* synapse_search_match_construct (GType object_type);
SynapseMatch* synapse_search_match_get_search_source (SynapseSearchMatch* self);
void synapse_search_match_set_search_source (SynapseSearchMatch* self,
                                             SynapseMatch* value);
void synapse_search_provider_search (SynapseSearchProvider* self,
                                     const gchar* query,
                                     SynapseQueryFlags flags,
                                     SynapseResultSet* dest_result_set,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
GeeList* synapse_search_provider_search_finish (SynapseSearchProvider* self,
                                                GAsyncResult* _res_,
                                                GError** error);
static void synapse_search_match_finalize (GObject * obj);
static GType synapse_search_match_get_type_once (void);
static void _vala_synapse_search_match_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_synapse_search_match_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
GType synapse_unknown_match_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseUnknownMatch, g_object_unref)
SynapseUnknownMatch* synapse_unknown_match_new (const gchar* query_string);
SynapseUnknownMatch* synapse_unknown_match_construct (GType object_type,
                                                      const gchar* query_string);
static GType synapse_unknown_match_get_type_once (void);

static GType
synapse_match_score_get_type_once (void)
{
	static const GEnumValue values[] = {{SYNAPSE_MATCH_SCORE_INCREMENT_MINOR, "SYNAPSE_MATCH_SCORE_INCREMENT_MINOR", "increment-minor"}, {SYNAPSE_MATCH_SCORE_INCREMENT_SMALL, "SYNAPSE_MATCH_SCORE_INCREMENT_SMALL", "increment-small"}, {SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM, "SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM", "increment-medium"}, {SYNAPSE_MATCH_SCORE_INCREMENT_LARGE, "SYNAPSE_MATCH_SCORE_INCREMENT_LARGE", "increment-large"}, {SYNAPSE_MATCH_SCORE_URI_PENALTY, "SYNAPSE_MATCH_SCORE_URI_PENALTY", "uri-penalty"}, {SYNAPSE_MATCH_SCORE_POOR, "SYNAPSE_MATCH_SCORE_POOR", "poor"}, {SYNAPSE_MATCH_SCORE_BELOW_AVERAGE, "SYNAPSE_MATCH_SCORE_BELOW_AVERAGE", "below-average"}, {SYNAPSE_MATCH_SCORE_AVERAGE, "SYNAPSE_MATCH_SCORE_AVERAGE", "average"}, {SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE, "SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE", "above-average"}, {SYNAPSE_MATCH_SCORE_GOOD, "SYNAPSE_MATCH_SCORE_GOOD", "good"}, {SYNAPSE_MATCH_SCORE_VERY_GOOD, "SYNAPSE_MATCH_SCORE_VERY_GOOD", "very-good"}, {SYNAPSE_MATCH_SCORE_EXCELLENT, "SYNAPSE_MATCH_SCORE_EXCELLENT", "excellent"}, {SYNAPSE_MATCH_SCORE_HIGHEST, "SYNAPSE_MATCH_SCORE_HIGHEST", "highest"}, {0, NULL, NULL}};
	GType synapse_match_score_type_id;
	synapse_match_score_type_id = g_enum_register_static ("SynapseMatchScore", values);
	return synapse_match_score_type_id;
}

GType
synapse_match_score_get_type (void)
{
	static volatile gsize synapse_match_score_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_match_score_type_id__volatile)) {
		GType synapse_match_score_type_id;
		synapse_match_score_type_id = synapse_match_score_get_type_once ();
		g_once_init_leave (&synapse_match_score_type_id__volatile, synapse_match_score_type_id);
	}
	return synapse_match_score_type_id__volatile;
}

static inline gpointer
synapse_match_get_instance_private (SynapseMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseMatch_private_offset);
}

static void
synapse_match_real_execute (SynapseMatch* self,
                            SynapseMatch* match)
{
#line 53 "../../../src/core/match.vala"
	g_return_if_fail (match != NULL);
#line 55 "../../../src/core/match.vala"
	g_critical ("match.vala:55: execute () is not implemented");
#line 605 "match.c"
}

void
synapse_match_execute (SynapseMatch* self,
                       SynapseMatch* match)
{
#line 53 "../../../src/core/match.vala"
	g_return_if_fail (self != NULL);
#line 53 "../../../src/core/match.vala"
	SYNAPSE_MATCH_GET_CLASS (self)->execute (self, match);
#line 616 "match.c"
}

static void
synapse_match_real_execute_with_target (SynapseMatch* self,
                                        SynapseMatch* source,
                                        SynapseMatch* target)
{
#line 58 "../../../src/core/match.vala"
	g_return_if_fail (source != NULL);
#line 60 "../../../src/core/match.vala"
	if (target == NULL) {
#line 61 "../../../src/core/match.vala"
		synapse_match_execute (self, source);
#line 630 "match.c"
	} else {
#line 63 "../../../src/core/match.vala"
		g_critical ("match.vala:63: execute_with_target () is not implemented");
#line 634 "match.c"
	}
}

void
synapse_match_execute_with_target (SynapseMatch* self,
                                   SynapseMatch* source,
                                   SynapseMatch* target)
{
#line 58 "../../../src/core/match.vala"
	g_return_if_fail (self != NULL);
#line 58 "../../../src/core/match.vala"
	SYNAPSE_MATCH_GET_CLASS (self)->execute_with_target (self, source, target);
#line 647 "match.c"
}

static gboolean
synapse_match_real_needs_target (SynapseMatch* self)
{
	gboolean result = FALSE;
#line 68 "../../../src/core/match.vala"
	result = FALSE;
#line 68 "../../../src/core/match.vala"
	return result;
#line 658 "match.c"
}

gboolean
synapse_match_needs_target (SynapseMatch* self)
{
#line 66 "../../../src/core/match.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 66 "../../../src/core/match.vala"
	return SYNAPSE_MATCH_GET_CLASS (self)->needs_target (self);
#line 668 "match.c"
}

static SynapseQueryFlags
synapse_match_real_target_flags (SynapseMatch* self)
{
	SynapseQueryFlags result = 0U;
#line 73 "../../../src/core/match.vala"
	result = SYNAPSE_QUERY_FLAGS_ALL;
#line 73 "../../../src/core/match.vala"
	return result;
#line 679 "match.c"
}

SynapseQueryFlags
synapse_match_target_flags (SynapseMatch* self)
{
#line 71 "../../../src/core/match.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 71 "../../../src/core/match.vala"
	return SYNAPSE_MATCH_GET_CLASS (self)->target_flags (self);
#line 689 "match.c"
}

SynapseMatch*
synapse_match_construct (GType object_type)
{
	SynapseMatch * self = NULL;
#line 42 "../../../src/core/match.vala"
	self = (SynapseMatch*) g_object_new (object_type, NULL);
#line 42 "../../../src/core/match.vala"
	return self;
#line 700 "match.c"
}

const gchar*
synapse_match_get_title (SynapseMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 47 "../../../src/core/match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 47 "../../../src/core/match.vala"
	_tmp0_ = self->priv->_title;
#line 47 "../../../src/core/match.vala"
	result = _tmp0_;
#line 47 "../../../src/core/match.vala"
	return result;
#line 716 "match.c"
}

void
synapse_match_set_title (SynapseMatch* self,
                         const gchar* value)
{
	gchar* old_value;
#line 47 "../../../src/core/match.vala"
	g_return_if_fail (self != NULL);
#line 47 "../../../src/core/match.vala"
	old_value = synapse_match_get_title (self);
#line 47 "../../../src/core/match.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 730 "match.c"
		gchar* _tmp0_;
#line 47 "../../../src/core/match.vala"
		_tmp0_ = g_strdup (value);
#line 47 "../../../src/core/match.vala"
		_g_free0 (self->priv->_title);
#line 47 "../../../src/core/match.vala"
		self->priv->_title = _tmp0_;
#line 47 "../../../src/core/match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_match_properties[SYNAPSE_MATCH_TITLE_PROPERTY]);
#line 740 "match.c"
	}
}

const gchar*
synapse_match_get_description (SynapseMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 48 "../../../src/core/match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 48 "../../../src/core/match.vala"
	_tmp0_ = self->priv->_description;
#line 48 "../../../src/core/match.vala"
	result = _tmp0_;
#line 48 "../../../src/core/match.vala"
	return result;
#line 757 "match.c"
}

void
synapse_match_set_description (SynapseMatch* self,
                               const gchar* value)
{
	gchar* old_value;
#line 48 "../../../src/core/match.vala"
	g_return_if_fail (self != NULL);
#line 48 "../../../src/core/match.vala"
	old_value = synapse_match_get_description (self);
#line 48 "../../../src/core/match.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 771 "match.c"
		gchar* _tmp0_;
#line 48 "../../../src/core/match.vala"
		_tmp0_ = g_strdup (value);
#line 48 "../../../src/core/match.vala"
		_g_free0 (self->priv->_description);
#line 48 "../../../src/core/match.vala"
		self->priv->_description = _tmp0_;
#line 48 "../../../src/core/match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_match_properties[SYNAPSE_MATCH_DESCRIPTION_PROPERTY]);
#line 781 "match.c"
	}
}

const gchar*
synapse_match_get_icon_name (SynapseMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 49 "../../../src/core/match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 49 "../../../src/core/match.vala"
	_tmp0_ = self->priv->_icon_name;
#line 49 "../../../src/core/match.vala"
	result = _tmp0_;
#line 49 "../../../src/core/match.vala"
	return result;
#line 798 "match.c"
}

void
synapse_match_set_icon_name (SynapseMatch* self,
                             const gchar* value)
{
	gchar* old_value;
#line 49 "../../../src/core/match.vala"
	g_return_if_fail (self != NULL);
#line 49 "../../../src/core/match.vala"
	old_value = synapse_match_get_icon_name (self);
#line 49 "../../../src/core/match.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 812 "match.c"
		gchar* _tmp0_;
#line 49 "../../../src/core/match.vala"
		_tmp0_ = g_strdup (value);
#line 49 "../../../src/core/match.vala"
		_g_free0 (self->priv->_icon_name);
#line 49 "../../../src/core/match.vala"
		self->priv->_icon_name = _tmp0_;
#line 49 "../../../src/core/match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_match_properties[SYNAPSE_MATCH_ICON_NAME_PROPERTY]);
#line 822 "match.c"
	}
}

gboolean
synapse_match_get_has_thumbnail (SynapseMatch* self)
{
	gboolean result;
#line 50 "../../../src/core/match.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 50 "../../../src/core/match.vala"
	result = self->priv->_has_thumbnail;
#line 50 "../../../src/core/match.vala"
	return result;
#line 836 "match.c"
}

void
synapse_match_set_has_thumbnail (SynapseMatch* self,
                                 gboolean value)
{
	gboolean old_value;
#line 50 "../../../src/core/match.vala"
	g_return_if_fail (self != NULL);
#line 50 "../../../src/core/match.vala"
	old_value = synapse_match_get_has_thumbnail (self);
#line 50 "../../../src/core/match.vala"
	if (old_value != value) {
#line 50 "../../../src/core/match.vala"
		self->priv->_has_thumbnail = value;
#line 50 "../../../src/core/match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_match_properties[SYNAPSE_MATCH_HAS_THUMBNAIL_PROPERTY]);
#line 854 "match.c"
	}
}

const gchar*
synapse_match_get_thumbnail_path (SynapseMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 51 "../../../src/core/match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 51 "../../../src/core/match.vala"
	_tmp0_ = self->priv->_thumbnail_path;
#line 51 "../../../src/core/match.vala"
	result = _tmp0_;
#line 51 "../../../src/core/match.vala"
	return result;
#line 871 "match.c"
}

void
synapse_match_set_thumbnail_path (SynapseMatch* self,
                                  const gchar* value)
{
	gchar* old_value;
#line 51 "../../../src/core/match.vala"
	g_return_if_fail (self != NULL);
#line 51 "../../../src/core/match.vala"
	old_value = synapse_match_get_thumbnail_path (self);
#line 51 "../../../src/core/match.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 885 "match.c"
		gchar* _tmp0_;
#line 51 "../../../src/core/match.vala"
		_tmp0_ = g_strdup (value);
#line 51 "../../../src/core/match.vala"
		_g_free0 (self->priv->_thumbnail_path);
#line 51 "../../../src/core/match.vala"
		self->priv->_thumbnail_path = _tmp0_;
#line 51 "../../../src/core/match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_match_properties[SYNAPSE_MATCH_THUMBNAIL_PATH_PROPERTY]);
#line 895 "match.c"
	}
}

static void
synapse_match_class_init (SynapseMatchClass * klass,
                          gpointer klass_data)
{
#line 42 "../../../src/core/match.vala"
	synapse_match_parent_class = g_type_class_peek_parent (klass);
#line 42 "../../../src/core/match.vala"
	g_type_class_adjust_private_offset (klass, &SynapseMatch_private_offset);
#line 42 "../../../src/core/match.vala"
	((SynapseMatchClass *) klass)->execute = (void (*) (SynapseMatch*, SynapseMatch*)) synapse_match_real_execute;
#line 42 "../../../src/core/match.vala"
	((SynapseMatchClass *) klass)->execute_with_target = (void (*) (SynapseMatch*, SynapseMatch*, SynapseMatch*)) synapse_match_real_execute_with_target;
#line 42 "../../../src/core/match.vala"
	((SynapseMatchClass *) klass)->needs_target = (gboolean (*) (SynapseMatch*)) synapse_match_real_needs_target;
#line 42 "../../../src/core/match.vala"
	((SynapseMatchClass *) klass)->target_flags = (SynapseQueryFlags (*) (SynapseMatch*)) synapse_match_real_target_flags;
#line 42 "../../../src/core/match.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_match_get_property;
#line 42 "../../../src/core/match.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_match_set_property;
#line 42 "../../../src/core/match.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_match_finalize;
#line 42 "../../../src/core/match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_MATCH_TITLE_PROPERTY, synapse_match_properties[SYNAPSE_MATCH_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 42 "../../../src/core/match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_MATCH_DESCRIPTION_PROPERTY, synapse_match_properties[SYNAPSE_MATCH_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 42 "../../../src/core/match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_MATCH_ICON_NAME_PROPERTY, synapse_match_properties[SYNAPSE_MATCH_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 42 "../../../src/core/match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_MATCH_HAS_THUMBNAIL_PROPERTY, synapse_match_properties[SYNAPSE_MATCH_HAS_THUMBNAIL_PROPERTY] = g_param_spec_boolean ("has-thumbnail", "has-thumbnail", "has-thumbnail", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 42 "../../../src/core/match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_MATCH_THUMBNAIL_PATH_PROPERTY, synapse_match_properties[SYNAPSE_MATCH_THUMBNAIL_PATH_PROPERTY] = g_param_spec_string ("thumbnail-path", "thumbnail-path", "thumbnail-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 42 "../../../src/core/match.vala"
	synapse_match_signals[SYNAPSE_MATCH_EXECUTED_SIGNAL] = g_signal_new ("executed", SYNAPSE_TYPE_MATCH, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 933 "match.c"
}

static void
synapse_match_instance_init (SynapseMatch * self,
                             gpointer klass)
{
#line 42 "../../../src/core/match.vala"
	self->priv = synapse_match_get_instance_private (self);
#line 942 "match.c"
}

static void
synapse_match_finalize (GObject * obj)
{
	SynapseMatch * self;
#line 42 "../../../src/core/match.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_MATCH, SynapseMatch);
#line 47 "../../../src/core/match.vala"
	_g_free0 (self->priv->_title);
#line 48 "../../../src/core/match.vala"
	_g_free0 (self->priv->_description);
#line 49 "../../../src/core/match.vala"
	_g_free0 (self->priv->_icon_name);
#line 51 "../../../src/core/match.vala"
	_g_free0 (self->priv->_thumbnail_path);
#line 42 "../../../src/core/match.vala"
	G_OBJECT_CLASS (synapse_match_parent_class)->finalize (obj);
#line 961 "match.c"
}

static GType
synapse_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseMatch), 0, (GInstanceInitFunc) synapse_match_instance_init, NULL };
	GType synapse_match_type_id;
	synapse_match_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseMatch", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	SynapseMatch_private_offset = g_type_add_instance_private (synapse_match_type_id, sizeof (SynapseMatchPrivate));
	return synapse_match_type_id;
}

GType
synapse_match_get_type (void)
{
	static volatile gsize synapse_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_match_type_id__volatile)) {
		GType synapse_match_type_id;
		synapse_match_type_id = synapse_match_get_type_once ();
		g_once_init_leave (&synapse_match_type_id__volatile, synapse_match_type_id);
	}
	return synapse_match_type_id__volatile;
}

static void
_vala_synapse_match_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	SynapseMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_MATCH, SynapseMatch);
#line 42 "../../../src/core/match.vala"
	switch (property_id) {
#line 42 "../../../src/core/match.vala"
		case SYNAPSE_MATCH_TITLE_PROPERTY:
#line 42 "../../../src/core/match.vala"
		g_value_set_string (value, synapse_match_get_title (self));
#line 42 "../../../src/core/match.vala"
		break;
#line 42 "../../../src/core/match.vala"
		case SYNAPSE_MATCH_DESCRIPTION_PROPERTY:
#line 42 "../../../src/core/match.vala"
		g_value_set_string (value, synapse_match_get_description (self));
#line 42 "../../../src/core/match.vala"
		break;
#line 42 "../../../src/core/match.vala"
		case SYNAPSE_MATCH_ICON_NAME_PROPERTY:
#line 42 "../../../src/core/match.vala"
		g_value_set_string (value, synapse_match_get_icon_name (self));
#line 42 "../../../src/core/match.vala"
		break;
#line 42 "../../../src/core/match.vala"
		case SYNAPSE_MATCH_HAS_THUMBNAIL_PROPERTY:
#line 42 "../../../src/core/match.vala"
		g_value_set_boolean (value, synapse_match_get_has_thumbnail (self));
#line 42 "../../../src/core/match.vala"
		break;
#line 42 "../../../src/core/match.vala"
		case SYNAPSE_MATCH_THUMBNAIL_PATH_PROPERTY:
#line 42 "../../../src/core/match.vala"
		g_value_set_string (value, synapse_match_get_thumbnail_path (self));
#line 42 "../../../src/core/match.vala"
		break;
#line 1026 "match.c"
		default:
#line 42 "../../../src/core/match.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 42 "../../../src/core/match.vala"
		break;
#line 1032 "match.c"
	}
}

static void
_vala_synapse_match_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	SynapseMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_MATCH, SynapseMatch);
#line 42 "../../../src/core/match.vala"
	switch (property_id) {
#line 42 "../../../src/core/match.vala"
		case SYNAPSE_MATCH_TITLE_PROPERTY:
#line 42 "../../../src/core/match.vala"
		synapse_match_set_title (self, g_value_get_string (value));
#line 42 "../../../src/core/match.vala"
		break;
#line 42 "../../../src/core/match.vala"
		case SYNAPSE_MATCH_DESCRIPTION_PROPERTY:
#line 42 "../../../src/core/match.vala"
		synapse_match_set_description (self, g_value_get_string (value));
#line 42 "../../../src/core/match.vala"
		break;
#line 42 "../../../src/core/match.vala"
		case SYNAPSE_MATCH_ICON_NAME_PROPERTY:
#line 42 "../../../src/core/match.vala"
		synapse_match_set_icon_name (self, g_value_get_string (value));
#line 42 "../../../src/core/match.vala"
		break;
#line 42 "../../../src/core/match.vala"
		case SYNAPSE_MATCH_HAS_THUMBNAIL_PROPERTY:
#line 42 "../../../src/core/match.vala"
		synapse_match_set_has_thumbnail (self, g_value_get_boolean (value));
#line 42 "../../../src/core/match.vala"
		break;
#line 42 "../../../src/core/match.vala"
		case SYNAPSE_MATCH_THUMBNAIL_PATH_PROPERTY:
#line 42 "../../../src/core/match.vala"
		synapse_match_set_thumbnail_path (self, g_value_get_string (value));
#line 42 "../../../src/core/match.vala"
		break;
#line 1076 "match.c"
		default:
#line 42 "../../../src/core/match.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 42 "../../../src/core/match.vala"
		break;
#line 1082 "match.c"
	}
}

static void
synapse_action_match_real_do_action (SynapseActionMatch* self)
{
#line 79 "../../../src/core/match.vala"
	g_critical ("Type `%s' does not implement abstract method `synapse_action_match_do_action'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 79 "../../../src/core/match.vala"
	return;
#line 1093 "match.c"
}

void
synapse_action_match_do_action (SynapseActionMatch* self)
{
#line 79 "../../../src/core/match.vala"
	g_return_if_fail (self != NULL);
#line 79 "../../../src/core/match.vala"
	SYNAPSE_ACTION_MATCH_GET_CLASS (self)->do_action (self);
#line 1103 "match.c"
}

SynapseActionMatch*
synapse_action_match_construct (GType object_type)
{
	SynapseActionMatch * self = NULL;
#line 77 "../../../src/core/match.vala"
	self = (SynapseActionMatch*) synapse_match_construct (object_type);
#line 77 "../../../src/core/match.vala"
	return self;
#line 1114 "match.c"
}

static void
synapse_action_match_class_init (SynapseActionMatchClass * klass,
                                 gpointer klass_data)
{
#line 77 "../../../src/core/match.vala"
	synapse_action_match_parent_class = g_type_class_peek_parent (klass);
#line 77 "../../../src/core/match.vala"
	((SynapseActionMatchClass *) klass)->do_action = (void (*) (SynapseActionMatch*)) synapse_action_match_real_do_action;
#line 1125 "match.c"
}

static void
synapse_action_match_instance_init (SynapseActionMatch * self,
                                    gpointer klass)
{
}

static GType
synapse_action_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseActionMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_action_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseActionMatch), 0, (GInstanceInitFunc) synapse_action_match_instance_init, NULL };
	GType synapse_action_match_type_id;
	synapse_action_match_type_id = g_type_register_static (SYNAPSE_TYPE_MATCH, "SynapseActionMatch", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return synapse_action_match_type_id;
}

GType
synapse_action_match_get_type (void)
{
	static volatile gsize synapse_action_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_action_match_type_id__volatile)) {
		GType synapse_action_match_type_id;
		synapse_action_match_type_id = synapse_action_match_get_type_once ();
		g_once_init_leave (&synapse_action_match_type_id__volatile, synapse_action_match_type_id);
	}
	return synapse_action_match_type_id__volatile;
}

static inline gpointer
synapse_application_match_get_instance_private (SynapseApplicationMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseApplicationMatch_private_offset);
}

SynapseApplicationMatch*
synapse_application_match_construct (GType object_type)
{
	SynapseApplicationMatch * self = NULL;
#line 90 "../../../src/core/match.vala"
	self = (SynapseApplicationMatch*) g_object_new (object_type, "has-thumbnail", FALSE, "icon-name", "", "thumbnail-path", "", NULL);
#line 88 "../../../src/core/match.vala"
	return self;
#line 1169 "match.c"
}

SynapseApplicationMatch*
synapse_application_match_new (void)
{
#line 88 "../../../src/core/match.vala"
	return synapse_application_match_construct (SYNAPSE_TYPE_APPLICATION_MATCH);
#line 1177 "match.c"
}

GAppInfo*
synapse_application_match_get_app_info (SynapseApplicationMatch* self)
{
	GAppInfo* result;
	GAppInfo* _tmp0_;
#line 84 "../../../src/core/match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 84 "../../../src/core/match.vala"
	_tmp0_ = self->priv->_app_info;
#line 84 "../../../src/core/match.vala"
	result = _tmp0_;
#line 84 "../../../src/core/match.vala"
	return result;
#line 1193 "match.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 84 "../../../src/core/match.vala"
	return self ? g_object_ref (self) : NULL;
#line 1201 "match.c"
}

void
synapse_application_match_set_app_info (SynapseApplicationMatch* self,
                                        GAppInfo* value)
{
	GAppInfo* old_value;
#line 84 "../../../src/core/match.vala"
	g_return_if_fail (self != NULL);
#line 84 "../../../src/core/match.vala"
	old_value = synapse_application_match_get_app_info (self);
#line 84 "../../../src/core/match.vala"
	if (old_value != value) {
#line 1215 "match.c"
		GAppInfo* _tmp0_;
#line 84 "../../../src/core/match.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 84 "../../../src/core/match.vala"
		_g_object_unref0 (self->priv->_app_info);
#line 84 "../../../src/core/match.vala"
		self->priv->_app_info = _tmp0_;
#line 84 "../../../src/core/match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_application_match_properties[SYNAPSE_APPLICATION_MATCH_APP_INFO_PROPERTY]);
#line 1225 "match.c"
	}
}

gboolean
synapse_application_match_get_needs_terminal (SynapseApplicationMatch* self)
{
	gboolean result;
#line 85 "../../../src/core/match.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 85 "../../../src/core/match.vala"
	result = self->priv->_needs_terminal;
#line 85 "../../../src/core/match.vala"
	return result;
#line 1239 "match.c"
}

void
synapse_application_match_set_needs_terminal (SynapseApplicationMatch* self,
                                              gboolean value)
{
	gboolean old_value;
#line 85 "../../../src/core/match.vala"
	g_return_if_fail (self != NULL);
#line 85 "../../../src/core/match.vala"
	old_value = synapse_application_match_get_needs_terminal (self);
#line 85 "../../../src/core/match.vala"
	if (old_value != value) {
#line 85 "../../../src/core/match.vala"
		self->priv->_needs_terminal = value;
#line 85 "../../../src/core/match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_application_match_properties[SYNAPSE_APPLICATION_MATCH_NEEDS_TERMINAL_PROPERTY]);
#line 1257 "match.c"
	}
}

const gchar*
synapse_application_match_get_filename (SynapseApplicationMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 86 "../../../src/core/match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 86 "../../../src/core/match.vala"
	_tmp0_ = self->priv->_filename;
#line 86 "../../../src/core/match.vala"
	result = _tmp0_;
#line 86 "../../../src/core/match.vala"
	return result;
#line 1274 "match.c"
}

void
synapse_application_match_set_filename (SynapseApplicationMatch* self,
                                        const gchar* value)
{
	gchar* old_value;
#line 86 "../../../src/core/match.vala"
	g_return_if_fail (self != NULL);
#line 86 "../../../src/core/match.vala"
	old_value = synapse_application_match_get_filename (self);
#line 86 "../../../src/core/match.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1288 "match.c"
		gchar* _tmp0_;
#line 86 "../../../src/core/match.vala"
		_tmp0_ = g_strdup (value);
#line 86 "../../../src/core/match.vala"
		_g_free0 (self->priv->_filename);
#line 86 "../../../src/core/match.vala"
		self->priv->_filename = _tmp0_;
#line 86 "../../../src/core/match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_application_match_properties[SYNAPSE_APPLICATION_MATCH_FILENAME_PROPERTY]);
#line 1298 "match.c"
	}
}

static void
synapse_application_match_class_init (SynapseApplicationMatchClass * klass,
                                      gpointer klass_data)
{
#line 82 "../../../src/core/match.vala"
	synapse_application_match_parent_class = g_type_class_peek_parent (klass);
#line 82 "../../../src/core/match.vala"
	g_type_class_adjust_private_offset (klass, &SynapseApplicationMatch_private_offset);
#line 82 "../../../src/core/match.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_application_match_get_property;
#line 82 "../../../src/core/match.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_application_match_set_property;
#line 82 "../../../src/core/match.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_application_match_finalize;
#line 82 "../../../src/core/match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_APPLICATION_MATCH_APP_INFO_PROPERTY, synapse_application_match_properties[SYNAPSE_APPLICATION_MATCH_APP_INFO_PROPERTY] = g_param_spec_object ("app-info", "app-info", "app-info", g_app_info_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 82 "../../../src/core/match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_APPLICATION_MATCH_NEEDS_TERMINAL_PROPERTY, synapse_application_match_properties[SYNAPSE_APPLICATION_MATCH_NEEDS_TERMINAL_PROPERTY] = g_param_spec_boolean ("needs-terminal", "needs-terminal", "needs-terminal", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 82 "../../../src/core/match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_APPLICATION_MATCH_FILENAME_PROPERTY, synapse_application_match_properties[SYNAPSE_APPLICATION_MATCH_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 1322 "match.c"
}

static void
synapse_application_match_instance_init (SynapseApplicationMatch * self,
                                         gpointer klass)
{
#line 82 "../../../src/core/match.vala"
	self->priv = synapse_application_match_get_instance_private (self);
#line 1331 "match.c"
}

static void
synapse_application_match_finalize (GObject * obj)
{
	SynapseApplicationMatch * self;
#line 82 "../../../src/core/match.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch);
#line 84 "../../../src/core/match.vala"
	_g_object_unref0 (self->priv->_app_info);
#line 86 "../../../src/core/match.vala"
	_g_free0 (self->priv->_filename);
#line 82 "../../../src/core/match.vala"
	G_OBJECT_CLASS (synapse_application_match_parent_class)->finalize (obj);
#line 1346 "match.c"
}

static GType
synapse_application_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseApplicationMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_application_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseApplicationMatch), 0, (GInstanceInitFunc) synapse_application_match_instance_init, NULL };
	GType synapse_application_match_type_id;
	synapse_application_match_type_id = g_type_register_static (SYNAPSE_TYPE_MATCH, "SynapseApplicationMatch", &g_define_type_info, 0);
	SynapseApplicationMatch_private_offset = g_type_add_instance_private (synapse_application_match_type_id, sizeof (SynapseApplicationMatchPrivate));
	return synapse_application_match_type_id;
}

GType
synapse_application_match_get_type (void)
{
	static volatile gsize synapse_application_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_application_match_type_id__volatile)) {
		GType synapse_application_match_type_id;
		synapse_application_match_type_id = synapse_application_match_get_type_once ();
		g_once_init_leave (&synapse_application_match_type_id__volatile, synapse_application_match_type_id);
	}
	return synapse_application_match_type_id__volatile;
}

static void
_vala_synapse_application_match_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	SynapseApplicationMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch);
#line 82 "../../../src/core/match.vala"
	switch (property_id) {
#line 82 "../../../src/core/match.vala"
		case SYNAPSE_APPLICATION_MATCH_APP_INFO_PROPERTY:
#line 82 "../../../src/core/match.vala"
		g_value_set_object (value, synapse_application_match_get_app_info (self));
#line 82 "../../../src/core/match.vala"
		break;
#line 82 "../../../src/core/match.vala"
		case SYNAPSE_APPLICATION_MATCH_NEEDS_TERMINAL_PROPERTY:
#line 82 "../../../src/core/match.vala"
		g_value_set_boolean (value, synapse_application_match_get_needs_terminal (self));
#line 82 "../../../src/core/match.vala"
		break;
#line 82 "../../../src/core/match.vala"
		case SYNAPSE_APPLICATION_MATCH_FILENAME_PROPERTY:
#line 82 "../../../src/core/match.vala"
		g_value_set_string (value, synapse_application_match_get_filename (self));
#line 82 "../../../src/core/match.vala"
		break;
#line 1399 "match.c"
		default:
#line 82 "../../../src/core/match.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 82 "../../../src/core/match.vala"
		break;
#line 1405 "match.c"
	}
}

static void
_vala_synapse_application_match_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	SynapseApplicationMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch);
#line 82 "../../../src/core/match.vala"
	switch (property_id) {
#line 82 "../../../src/core/match.vala"
		case SYNAPSE_APPLICATION_MATCH_APP_INFO_PROPERTY:
#line 82 "../../../src/core/match.vala"
		synapse_application_match_set_app_info (self, g_value_get_object (value));
#line 82 "../../../src/core/match.vala"
		break;
#line 82 "../../../src/core/match.vala"
		case SYNAPSE_APPLICATION_MATCH_NEEDS_TERMINAL_PROPERTY:
#line 82 "../../../src/core/match.vala"
		synapse_application_match_set_needs_terminal (self, g_value_get_boolean (value));
#line 82 "../../../src/core/match.vala"
		break;
#line 82 "../../../src/core/match.vala"
		case SYNAPSE_APPLICATION_MATCH_FILENAME_PROPERTY:
#line 82 "../../../src/core/match.vala"
		synapse_application_match_set_filename (self, g_value_get_string (value));
#line 82 "../../../src/core/match.vala"
		break;
#line 1437 "match.c"
		default:
#line 82 "../../../src/core/match.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 82 "../../../src/core/match.vala"
		break;
#line 1443 "match.c"
	}
}

static inline gpointer
synapse_uri_match_get_instance_private (SynapseUriMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseUriMatch_private_offset);
}

SynapseUriMatch*
synapse_uri_match_construct (GType object_type)
{
	SynapseUriMatch * self = NULL;
#line 104 "../../../src/core/match.vala"
	self = (SynapseUriMatch*) g_object_new (object_type, "has-thumbnail", FALSE, "icon-name", "", "thumbnail-path", "", NULL);
#line 102 "../../../src/core/match.vala"
	return self;
#line 1461 "match.c"
}

SynapseUriMatch*
synapse_uri_match_new (void)
{
#line 102 "../../../src/core/match.vala"
	return synapse_uri_match_construct (SYNAPSE_TYPE_URI_MATCH);
#line 1469 "match.c"
}

const gchar*
synapse_uri_match_get_uri (SynapseUriMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 98 "../../../src/core/match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 98 "../../../src/core/match.vala"
	_tmp0_ = self->priv->_uri;
#line 98 "../../../src/core/match.vala"
	result = _tmp0_;
#line 98 "../../../src/core/match.vala"
	return result;
#line 1485 "match.c"
}

void
synapse_uri_match_set_uri (SynapseUriMatch* self,
                           const gchar* value)
{
	gchar* old_value;
#line 98 "../../../src/core/match.vala"
	g_return_if_fail (self != NULL);
#line 98 "../../../src/core/match.vala"
	old_value = synapse_uri_match_get_uri (self);
#line 98 "../../../src/core/match.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1499 "match.c"
		gchar* _tmp0_;
#line 98 "../../../src/core/match.vala"
		_tmp0_ = g_strdup (value);
#line 98 "../../../src/core/match.vala"
		_g_free0 (self->priv->_uri);
#line 98 "../../../src/core/match.vala"
		self->priv->_uri = _tmp0_;
#line 98 "../../../src/core/match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_uri_match_properties[SYNAPSE_URI_MATCH_URI_PROPERTY]);
#line 1509 "match.c"
	}
}

SynapseQueryFlags
synapse_uri_match_get_file_type (SynapseUriMatch* self)
{
	SynapseQueryFlags result;
	SynapseQueryFlags _tmp0_;
#line 99 "../../../src/core/match.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 99 "../../../src/core/match.vala"
	_tmp0_ = self->priv->_file_type;
#line 99 "../../../src/core/match.vala"
	result = _tmp0_;
#line 99 "../../../src/core/match.vala"
	return result;
#line 1526 "match.c"
}

void
synapse_uri_match_set_file_type (SynapseUriMatch* self,
                                 SynapseQueryFlags value)
{
	SynapseQueryFlags old_value;
#line 99 "../../../src/core/match.vala"
	g_return_if_fail (self != NULL);
#line 99 "../../../src/core/match.vala"
	old_value = synapse_uri_match_get_file_type (self);
#line 99 "../../../src/core/match.vala"
	if (old_value != value) {
#line 99 "../../../src/core/match.vala"
		self->priv->_file_type = value;
#line 99 "../../../src/core/match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_uri_match_properties[SYNAPSE_URI_MATCH_FILE_TYPE_PROPERTY]);
#line 1544 "match.c"
	}
}

const gchar*
synapse_uri_match_get_mime_type (SynapseUriMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 100 "../../../src/core/match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 100 "../../../src/core/match.vala"
	_tmp0_ = self->priv->_mime_type;
#line 100 "../../../src/core/match.vala"
	result = _tmp0_;
#line 100 "../../../src/core/match.vala"
	return result;
#line 1561 "match.c"
}

void
synapse_uri_match_set_mime_type (SynapseUriMatch* self,
                                 const gchar* value)
{
	gchar* old_value;
#line 100 "../../../src/core/match.vala"
	g_return_if_fail (self != NULL);
#line 100 "../../../src/core/match.vala"
	old_value = synapse_uri_match_get_mime_type (self);
#line 100 "../../../src/core/match.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1575 "match.c"
		gchar* _tmp0_;
#line 100 "../../../src/core/match.vala"
		_tmp0_ = g_strdup (value);
#line 100 "../../../src/core/match.vala"
		_g_free0 (self->priv->_mime_type);
#line 100 "../../../src/core/match.vala"
		self->priv->_mime_type = _tmp0_;
#line 100 "../../../src/core/match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_uri_match_properties[SYNAPSE_URI_MATCH_MIME_TYPE_PROPERTY]);
#line 1585 "match.c"
	}
}

static void
synapse_uri_match_class_init (SynapseUriMatchClass * klass,
                              gpointer klass_data)
{
#line 96 "../../../src/core/match.vala"
	synapse_uri_match_parent_class = g_type_class_peek_parent (klass);
#line 96 "../../../src/core/match.vala"
	g_type_class_adjust_private_offset (klass, &SynapseUriMatch_private_offset);
#line 96 "../../../src/core/match.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_uri_match_get_property;
#line 96 "../../../src/core/match.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_uri_match_set_property;
#line 96 "../../../src/core/match.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_uri_match_finalize;
#line 96 "../../../src/core/match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_URI_MATCH_URI_PROPERTY, synapse_uri_match_properties[SYNAPSE_URI_MATCH_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 96 "../../../src/core/match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_URI_MATCH_FILE_TYPE_PROPERTY, synapse_uri_match_properties[SYNAPSE_URI_MATCH_FILE_TYPE_PROPERTY] = g_param_spec_flags ("file-type", "file-type", "file-type", SYNAPSE_TYPE_QUERY_FLAGS, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 96 "../../../src/core/match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_URI_MATCH_MIME_TYPE_PROPERTY, synapse_uri_match_properties[SYNAPSE_URI_MATCH_MIME_TYPE_PROPERTY] = g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1609 "match.c"
}

static void
synapse_uri_match_instance_init (SynapseUriMatch * self,
                                 gpointer klass)
{
#line 96 "../../../src/core/match.vala"
	self->priv = synapse_uri_match_get_instance_private (self);
#line 1618 "match.c"
}

static void
synapse_uri_match_finalize (GObject * obj)
{
	SynapseUriMatch * self;
#line 96 "../../../src/core/match.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch);
#line 98 "../../../src/core/match.vala"
	_g_free0 (self->priv->_uri);
#line 100 "../../../src/core/match.vala"
	_g_free0 (self->priv->_mime_type);
#line 96 "../../../src/core/match.vala"
	G_OBJECT_CLASS (synapse_uri_match_parent_class)->finalize (obj);
#line 1633 "match.c"
}

static GType
synapse_uri_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseUriMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_uri_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseUriMatch), 0, (GInstanceInitFunc) synapse_uri_match_instance_init, NULL };
	GType synapse_uri_match_type_id;
	synapse_uri_match_type_id = g_type_register_static (SYNAPSE_TYPE_MATCH, "SynapseUriMatch", &g_define_type_info, 0);
	SynapseUriMatch_private_offset = g_type_add_instance_private (synapse_uri_match_type_id, sizeof (SynapseUriMatchPrivate));
	return synapse_uri_match_type_id;
}

GType
synapse_uri_match_get_type (void)
{
	static volatile gsize synapse_uri_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_uri_match_type_id__volatile)) {
		GType synapse_uri_match_type_id;
		synapse_uri_match_type_id = synapse_uri_match_get_type_once ();
		g_once_init_leave (&synapse_uri_match_type_id__volatile, synapse_uri_match_type_id);
	}
	return synapse_uri_match_type_id__volatile;
}

static void
_vala_synapse_uri_match_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	SynapseUriMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch);
#line 96 "../../../src/core/match.vala"
	switch (property_id) {
#line 96 "../../../src/core/match.vala"
		case SYNAPSE_URI_MATCH_URI_PROPERTY:
#line 96 "../../../src/core/match.vala"
		g_value_set_string (value, synapse_uri_match_get_uri (self));
#line 96 "../../../src/core/match.vala"
		break;
#line 96 "../../../src/core/match.vala"
		case SYNAPSE_URI_MATCH_FILE_TYPE_PROPERTY:
#line 96 "../../../src/core/match.vala"
		g_value_set_flags (value, synapse_uri_match_get_file_type (self));
#line 96 "../../../src/core/match.vala"
		break;
#line 96 "../../../src/core/match.vala"
		case SYNAPSE_URI_MATCH_MIME_TYPE_PROPERTY:
#line 96 "../../../src/core/match.vala"
		g_value_set_string (value, synapse_uri_match_get_mime_type (self));
#line 96 "../../../src/core/match.vala"
		break;
#line 1686 "match.c"
		default:
#line 96 "../../../src/core/match.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 96 "../../../src/core/match.vala"
		break;
#line 1692 "match.c"
	}
}

static void
_vala_synapse_uri_match_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	SynapseUriMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch);
#line 96 "../../../src/core/match.vala"
	switch (property_id) {
#line 96 "../../../src/core/match.vala"
		case SYNAPSE_URI_MATCH_URI_PROPERTY:
#line 96 "../../../src/core/match.vala"
		synapse_uri_match_set_uri (self, g_value_get_string (value));
#line 96 "../../../src/core/match.vala"
		break;
#line 96 "../../../src/core/match.vala"
		case SYNAPSE_URI_MATCH_FILE_TYPE_PROPERTY:
#line 96 "../../../src/core/match.vala"
		synapse_uri_match_set_file_type (self, g_value_get_flags (value));
#line 96 "../../../src/core/match.vala"
		break;
#line 96 "../../../src/core/match.vala"
		case SYNAPSE_URI_MATCH_MIME_TYPE_PROPERTY:
#line 96 "../../../src/core/match.vala"
		synapse_uri_match_set_mime_type (self, g_value_get_string (value));
#line 96 "../../../src/core/match.vala"
		break;
#line 1724 "match.c"
		default:
#line 96 "../../../src/core/match.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 96 "../../../src/core/match.vala"
		break;
#line 1730 "match.c"
	}
}

static void
synapse_contact_match_real_send_message (SynapseContactMatch* self,
                                         const gchar* message,
                                         gboolean present)
{
#line 112 "../../../src/core/match.vala"
	g_critical ("Type `%s' does not implement abstract method `synapse_contact_match_send_message'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 112 "../../../src/core/match.vala"
	return;
#line 1743 "match.c"
}

void
synapse_contact_match_send_message (SynapseContactMatch* self,
                                    const gchar* message,
                                    gboolean present)
{
#line 112 "../../../src/core/match.vala"
	g_return_if_fail (self != NULL);
#line 112 "../../../src/core/match.vala"
	SYNAPSE_CONTACT_MATCH_GET_CLASS (self)->send_message (self, message, present);
#line 1755 "match.c"
}

static void
synapse_contact_match_real_open_chat (SynapseContactMatch* self)
{
#line 113 "../../../src/core/match.vala"
	g_critical ("Type `%s' does not implement abstract method `synapse_contact_match_open_chat'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 113 "../../../src/core/match.vala"
	return;
#line 1765 "match.c"
}

void
synapse_contact_match_open_chat (SynapseContactMatch* self)
{
#line 113 "../../../src/core/match.vala"
	g_return_if_fail (self != NULL);
#line 113 "../../../src/core/match.vala"
	SYNAPSE_CONTACT_MATCH_GET_CLASS (self)->open_chat (self);
#line 1775 "match.c"
}

SynapseContactMatch*
synapse_contact_match_construct (GType object_type)
{
	SynapseContactMatch * self = NULL;
#line 110 "../../../src/core/match.vala"
	self = (SynapseContactMatch*) synapse_match_construct (object_type);
#line 110 "../../../src/core/match.vala"
	return self;
#line 1786 "match.c"
}

static void
synapse_contact_match_class_init (SynapseContactMatchClass * klass,
                                  gpointer klass_data)
{
#line 110 "../../../src/core/match.vala"
	synapse_contact_match_parent_class = g_type_class_peek_parent (klass);
#line 110 "../../../src/core/match.vala"
	((SynapseContactMatchClass *) klass)->send_message = (void (*) (SynapseContactMatch*, const gchar*, gboolean)) synapse_contact_match_real_send_message;
#line 110 "../../../src/core/match.vala"
	((SynapseContactMatchClass *) klass)->open_chat = (void (*) (SynapseContactMatch*)) synapse_contact_match_real_open_chat;
#line 1799 "match.c"
}

static void
synapse_contact_match_instance_init (SynapseContactMatch * self,
                                     gpointer klass)
{
}

static GType
synapse_contact_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseContactMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_contact_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseContactMatch), 0, (GInstanceInitFunc) synapse_contact_match_instance_init, NULL };
	GType synapse_contact_match_type_id;
	synapse_contact_match_type_id = g_type_register_static (SYNAPSE_TYPE_MATCH, "SynapseContactMatch", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return synapse_contact_match_type_id;
}

GType
synapse_contact_match_get_type (void)
{
	static volatile gsize synapse_contact_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_contact_match_type_id__volatile)) {
		GType synapse_contact_match_type_id;
		synapse_contact_match_type_id = synapse_contact_match_get_type_once ();
		g_once_init_leave (&synapse_contact_match_type_id__volatile, synapse_contact_match_type_id);
	}
	return synapse_contact_match_type_id__volatile;
}

const gchar*
synapse_extended_info_get_extended_info (SynapseExtendedInfo* self)
{
#line 118 "../../../src/core/match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 118 "../../../src/core/match.vala"
	return SYNAPSE_EXTENDED_INFO_GET_INTERFACE (self)->get_extended_info (self);
#line 1836 "match.c"
}

void
synapse_extended_info_set_extended_info (SynapseExtendedInfo* self,
                                         const gchar* value)
{
#line 118 "../../../src/core/match.vala"
	g_return_if_fail (self != NULL);
#line 118 "../../../src/core/match.vala"
	SYNAPSE_EXTENDED_INFO_GET_INTERFACE (self)->set_extended_info (self, value);
#line 1847 "match.c"
}

static void
synapse_extended_info_default_init (SynapseExtendedInfoIface * iface,
                                    gpointer iface_data)
{
}

static GType
synapse_extended_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseExtendedInfoIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_extended_info_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType synapse_extended_info_type_id;
	synapse_extended_info_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseExtendedInfo", &g_define_type_info, 0);
	return synapse_extended_info_type_id;
}

GType
synapse_extended_info_get_type (void)
{
	static volatile gsize synapse_extended_info_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_extended_info_type_id__volatile)) {
		GType synapse_extended_info_type_id;
		synapse_extended_info_type_id = synapse_extended_info_get_type_once ();
		g_once_init_leave (&synapse_extended_info_type_id__volatile, synapse_extended_info_type_id);
	}
	return synapse_extended_info_type_id__volatile;
}

static GType
synapse_text_origin_get_type_once (void)
{
	static const GEnumValue values[] = {{SYNAPSE_TEXT_ORIGIN_UNKNOWN, "SYNAPSE_TEXT_ORIGIN_UNKNOWN", "unknown"}, {SYNAPSE_TEXT_ORIGIN_CLIPBOARD, "SYNAPSE_TEXT_ORIGIN_CLIPBOARD", "clipboard"}, {0, NULL, NULL}};
	GType synapse_text_origin_type_id;
	synapse_text_origin_type_id = g_enum_register_static ("SynapseTextOrigin", values);
	return synapse_text_origin_type_id;
}

GType
synapse_text_origin_get_type (void)
{
	static volatile gsize synapse_text_origin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_text_origin_type_id__volatile)) {
		GType synapse_text_origin_type_id;
		synapse_text_origin_type_id = synapse_text_origin_get_type_once ();
		g_once_init_leave (&synapse_text_origin_type_id__volatile, synapse_text_origin_type_id);
	}
	return synapse_text_origin_type_id__volatile;
}

static inline gpointer
synapse_text_match_get_instance_private (SynapseTextMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseTextMatch_private_offset);
}

static gchar*
synapse_text_match_real_get_text (SynapseTextMatch* self)
{
#line 131 "../../../src/core/match.vala"
	g_critical ("Type `%s' does not implement abstract method `synapse_text_match_get_text'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 131 "../../../src/core/match.vala"
	return NULL;
#line 1911 "match.c"
}

gchar*
synapse_text_match_get_text (SynapseTextMatch* self)
{
#line 131 "../../../src/core/match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 131 "../../../src/core/match.vala"
	return SYNAPSE_TEXT_MATCH_GET_CLASS (self)->get_text (self);
#line 1921 "match.c"
}

SynapseTextMatch*
synapse_text_match_construct (GType object_type)
{
	SynapseTextMatch * self = NULL;
#line 127 "../../../src/core/match.vala"
	self = (SynapseTextMatch*) synapse_match_construct (object_type);
#line 127 "../../../src/core/match.vala"
	return self;
#line 1932 "match.c"
}

SynapseTextOrigin
synapse_text_match_get_text_origin (SynapseTextMatch* self)
{
	SynapseTextOrigin result;
	SynapseTextOrigin _tmp0_;
#line 129 "../../../src/core/match.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 129 "../../../src/core/match.vala"
	_tmp0_ = self->priv->_text_origin;
#line 129 "../../../src/core/match.vala"
	result = _tmp0_;
#line 129 "../../../src/core/match.vala"
	return result;
#line 1948 "match.c"
}

static void
synapse_text_match_set_text_origin (SynapseTextMatch* self,
                                    SynapseTextOrigin value)
{
	SynapseTextOrigin old_value;
#line 129 "../../../src/core/match.vala"
	g_return_if_fail (self != NULL);
#line 129 "../../../src/core/match.vala"
	old_value = synapse_text_match_get_text_origin (self);
#line 129 "../../../src/core/match.vala"
	if (old_value != value) {
#line 129 "../../../src/core/match.vala"
		self->priv->_text_origin = value;
#line 129 "../../../src/core/match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_text_match_properties[SYNAPSE_TEXT_MATCH_TEXT_ORIGIN_PROPERTY]);
#line 1966 "match.c"
	}
}

static void
synapse_text_match_class_init (SynapseTextMatchClass * klass,
                               gpointer klass_data)
{
#line 127 "../../../src/core/match.vala"
	synapse_text_match_parent_class = g_type_class_peek_parent (klass);
#line 127 "../../../src/core/match.vala"
	g_type_class_adjust_private_offset (klass, &SynapseTextMatch_private_offset);
#line 127 "../../../src/core/match.vala"
	((SynapseTextMatchClass *) klass)->get_text = (gchar* (*) (SynapseTextMatch*)) synapse_text_match_real_get_text;
#line 127 "../../../src/core/match.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_text_match_get_property;
#line 127 "../../../src/core/match.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_text_match_set_property;
#line 127 "../../../src/core/match.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_text_match_finalize;
#line 127 "../../../src/core/match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_TEXT_MATCH_TEXT_ORIGIN_PROPERTY, synapse_text_match_properties[SYNAPSE_TEXT_MATCH_TEXT_ORIGIN_PROPERTY] = g_param_spec_enum ("text-origin", "text-origin", "text-origin", SYNAPSE_TYPE_TEXT_ORIGIN, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 1988 "match.c"
}

static void
synapse_text_match_instance_init (SynapseTextMatch * self,
                                  gpointer klass)
{
#line 127 "../../../src/core/match.vala"
	self->priv = synapse_text_match_get_instance_private (self);
#line 1997 "match.c"
}

static void
synapse_text_match_finalize (GObject * obj)
{
	SynapseTextMatch * self;
#line 127 "../../../src/core/match.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatch);
#line 127 "../../../src/core/match.vala"
	G_OBJECT_CLASS (synapse_text_match_parent_class)->finalize (obj);
#line 2008 "match.c"
}

static GType
synapse_text_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseTextMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_text_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseTextMatch), 0, (GInstanceInitFunc) synapse_text_match_instance_init, NULL };
	GType synapse_text_match_type_id;
	synapse_text_match_type_id = g_type_register_static (SYNAPSE_TYPE_MATCH, "SynapseTextMatch", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	SynapseTextMatch_private_offset = g_type_add_instance_private (synapse_text_match_type_id, sizeof (SynapseTextMatchPrivate));
	return synapse_text_match_type_id;
}

GType
synapse_text_match_get_type (void)
{
	static volatile gsize synapse_text_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_text_match_type_id__volatile)) {
		GType synapse_text_match_type_id;
		synapse_text_match_type_id = synapse_text_match_get_type_once ();
		g_once_init_leave (&synapse_text_match_type_id__volatile, synapse_text_match_type_id);
	}
	return synapse_text_match_type_id__volatile;
}

static void
_vala_synapse_text_match_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	SynapseTextMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatch);
#line 127 "../../../src/core/match.vala"
	switch (property_id) {
#line 127 "../../../src/core/match.vala"
		case SYNAPSE_TEXT_MATCH_TEXT_ORIGIN_PROPERTY:
#line 127 "../../../src/core/match.vala"
		g_value_set_enum (value, synapse_text_match_get_text_origin (self));
#line 127 "../../../src/core/match.vala"
		break;
#line 2049 "match.c"
		default:
#line 127 "../../../src/core/match.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 127 "../../../src/core/match.vala"
		break;
#line 2055 "match.c"
	}
}

static void
_vala_synapse_text_match_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	SynapseTextMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatch);
#line 127 "../../../src/core/match.vala"
	switch (property_id) {
#line 127 "../../../src/core/match.vala"
		case SYNAPSE_TEXT_MATCH_TEXT_ORIGIN_PROPERTY:
#line 127 "../../../src/core/match.vala"
		synapse_text_match_set_text_origin (self, g_value_get_enum (value));
#line 127 "../../../src/core/match.vala"
		break;
#line 2075 "match.c"
		default:
#line 127 "../../../src/core/match.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 127 "../../../src/core/match.vala"
		break;
#line 2081 "match.c"
	}
}

static inline gpointer
synapse_search_match_get_instance_private (SynapseSearchMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseSearchMatch_private_offset);
}

void
synapse_search_match_search (SynapseSearchMatch* self,
                             const gchar* query,
                             SynapseQueryFlags flags,
                             SynapseResultSet* dest_result_set,
                             GCancellable* cancellable,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
#line 134 "../../../src/core/match.vala"
	SYNAPSE_SEARCH_MATCH_GET_CLASS (self)->search (self, query, flags, dest_result_set, cancellable, _callback_, _user_data_);
#line 2102 "match.c"
}

GeeList*
synapse_search_match_search_finish (SynapseSearchMatch* self,
                                    GAsyncResult* _res_,
                                    GError** error)
{
#line 134 "../../../src/core/match.vala"
	return SYNAPSE_SEARCH_MATCH_GET_CLASS (self)->search_finish (self, _res_, error);
#line 2112 "match.c"
}

SynapseSearchMatch*
synapse_search_match_construct (GType object_type)
{
	SynapseSearchMatch * self = NULL;
#line 134 "../../../src/core/match.vala"
	self = (SynapseSearchMatch*) synapse_match_construct (object_type);
#line 134 "../../../src/core/match.vala"
	return self;
#line 2123 "match.c"
}

SynapseMatch*
synapse_search_match_get_search_source (SynapseSearchMatch* self)
{
	SynapseMatch* result;
	SynapseMatch* _tmp0_;
#line 136 "../../../src/core/match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 136 "../../../src/core/match.vala"
	_tmp0_ = self->priv->_search_source;
#line 136 "../../../src/core/match.vala"
	result = _tmp0_;
#line 136 "../../../src/core/match.vala"
	return result;
#line 2139 "match.c"
}

void
synapse_search_match_set_search_source (SynapseSearchMatch* self,
                                        SynapseMatch* value)
{
	SynapseMatch* old_value;
#line 136 "../../../src/core/match.vala"
	g_return_if_fail (self != NULL);
#line 136 "../../../src/core/match.vala"
	old_value = synapse_search_match_get_search_source (self);
#line 136 "../../../src/core/match.vala"
	if (old_value != value) {
#line 2153 "match.c"
		SynapseMatch* _tmp0_;
#line 136 "../../../src/core/match.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 136 "../../../src/core/match.vala"
		_g_object_unref0 (self->priv->_search_source);
#line 136 "../../../src/core/match.vala"
		self->priv->_search_source = _tmp0_;
#line 136 "../../../src/core/match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_search_match_properties[SYNAPSE_SEARCH_MATCH_SEARCH_SOURCE_PROPERTY]);
#line 2163 "match.c"
	}
}

static void
synapse_search_match_class_init (SynapseSearchMatchClass * klass,
                                 gpointer klass_data)
{
#line 134 "../../../src/core/match.vala"
	synapse_search_match_parent_class = g_type_class_peek_parent (klass);
#line 134 "../../../src/core/match.vala"
	g_type_class_adjust_private_offset (klass, &SynapseSearchMatch_private_offset);
#line 134 "../../../src/core/match.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_search_match_get_property;
#line 134 "../../../src/core/match.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_search_match_set_property;
#line 134 "../../../src/core/match.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_search_match_finalize;
#line 134 "../../../src/core/match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_SEARCH_MATCH_SEARCH_SOURCE_PROPERTY, synapse_search_match_properties[SYNAPSE_SEARCH_MATCH_SEARCH_SOURCE_PROPERTY] = g_param_spec_object ("search-source", "search-source", "search-source", SYNAPSE_TYPE_MATCH, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2183 "match.c"
}

static void
synapse_search_match_synapse_search_provider_interface_init (SynapseSearchProviderIface * iface,
                                                             gpointer iface_data)
{
#line 134 "../../../src/core/match.vala"
	synapse_search_match_synapse_search_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 134 "../../../src/core/match.vala"
	iface->search = (void (*) (SynapseSearchProvider*, const gchar*, SynapseQueryFlags, SynapseResultSet*, GCancellable*, GAsyncReadyCallback, gpointer)) synapse_search_match_search;
#line 134 "../../../src/core/match.vala"
	iface->search_finish = (GeeList* (*) (SynapseSearchProvider*, GAsyncResult*, GError**)) synapse_search_match_search_finish;
#line 2196 "match.c"
}

static void
synapse_search_match_instance_init (SynapseSearchMatch * self,
                                    gpointer klass)
{
#line 134 "../../../src/core/match.vala"
	self->priv = synapse_search_match_get_instance_private (self);
#line 2205 "match.c"
}

static void
synapse_search_match_finalize (GObject * obj)
{
	SynapseSearchMatch * self;
#line 134 "../../../src/core/match.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatch);
#line 136 "../../../src/core/match.vala"
	_g_object_unref0 (self->priv->_search_source);
#line 134 "../../../src/core/match.vala"
	G_OBJECT_CLASS (synapse_search_match_parent_class)->finalize (obj);
#line 2218 "match.c"
}

static GType
synapse_search_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseSearchMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_search_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseSearchMatch), 0, (GInstanceInitFunc) synapse_search_match_instance_init, NULL };
	static const GInterfaceInfo synapse_search_provider_info = { (GInterfaceInitFunc) synapse_search_match_synapse_search_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_search_match_type_id;
	synapse_search_match_type_id = g_type_register_static (SYNAPSE_TYPE_MATCH, "SynapseSearchMatch", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (synapse_search_match_type_id, SYNAPSE_TYPE_SEARCH_PROVIDER, &synapse_search_provider_info);
	SynapseSearchMatch_private_offset = g_type_add_instance_private (synapse_search_match_type_id, sizeof (SynapseSearchMatchPrivate));
	return synapse_search_match_type_id;
}

GType
synapse_search_match_get_type (void)
{
	static volatile gsize synapse_search_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_search_match_type_id__volatile)) {
		GType synapse_search_match_type_id;
		synapse_search_match_type_id = synapse_search_match_get_type_once ();
		g_once_init_leave (&synapse_search_match_type_id__volatile, synapse_search_match_type_id);
	}
	return synapse_search_match_type_id__volatile;
}

static void
_vala_synapse_search_match_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	SynapseSearchMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatch);
#line 134 "../../../src/core/match.vala"
	switch (property_id) {
#line 134 "../../../src/core/match.vala"
		case SYNAPSE_SEARCH_MATCH_SEARCH_SOURCE_PROPERTY:
#line 134 "../../../src/core/match.vala"
		g_value_set_object (value, synapse_search_match_get_search_source (self));
#line 134 "../../../src/core/match.vala"
		break;
#line 2261 "match.c"
		default:
#line 134 "../../../src/core/match.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 134 "../../../src/core/match.vala"
		break;
#line 2267 "match.c"
	}
}

static void
_vala_synapse_search_match_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	SynapseSearchMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatch);
#line 134 "../../../src/core/match.vala"
	switch (property_id) {
#line 134 "../../../src/core/match.vala"
		case SYNAPSE_SEARCH_MATCH_SEARCH_SOURCE_PROPERTY:
#line 134 "../../../src/core/match.vala"
		synapse_search_match_set_search_source (self, g_value_get_object (value));
#line 134 "../../../src/core/match.vala"
		break;
#line 2287 "match.c"
		default:
#line 134 "../../../src/core/match.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 134 "../../../src/core/match.vala"
		break;
#line 2293 "match.c"
	}
}

SynapseUnknownMatch*
synapse_unknown_match_construct (GType object_type,
                                 const gchar* query_string)
{
	SynapseUnknownMatch * self = NULL;
#line 143 "../../../src/core/match.vala"
	g_return_val_if_fail (query_string != NULL, NULL);
#line 145 "../../../src/core/match.vala"
	self = (SynapseUnknownMatch*) g_object_new (object_type, "title", query_string, "description", "", "has-thumbnail", FALSE, "icon-name", "unknown", NULL);
#line 143 "../../../src/core/match.vala"
	return self;
#line 2308 "match.c"
}

SynapseUnknownMatch*
synapse_unknown_match_new (const gchar* query_string)
{
#line 143 "../../../src/core/match.vala"
	return synapse_unknown_match_construct (SYNAPSE_TYPE_UNKNOWN_MATCH, query_string);
#line 2316 "match.c"
}

static void
synapse_unknown_match_class_init (SynapseUnknownMatchClass * klass,
                                  gpointer klass_data)
{
#line 141 "../../../src/core/match.vala"
	synapse_unknown_match_parent_class = g_type_class_peek_parent (klass);
#line 2325 "match.c"
}

static void
synapse_unknown_match_instance_init (SynapseUnknownMatch * self,
                                     gpointer klass)
{
}

static GType
synapse_unknown_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseUnknownMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_unknown_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseUnknownMatch), 0, (GInstanceInitFunc) synapse_unknown_match_instance_init, NULL };
	GType synapse_unknown_match_type_id;
	synapse_unknown_match_type_id = g_type_register_static (SYNAPSE_TYPE_MATCH, "SynapseUnknownMatch", &g_define_type_info, 0);
	return synapse_unknown_match_type_id;
}

GType
synapse_unknown_match_get_type (void)
{
	static volatile gsize synapse_unknown_match_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_unknown_match_type_id__volatile)) {
		GType synapse_unknown_match_type_id;
		synapse_unknown_match_type_id = synapse_unknown_match_get_type_once ();
		g_once_init_leave (&synapse_unknown_match_type_id__volatile, synapse_unknown_match_type_id);
	}
	return synapse_unknown_match_type_id__volatile;
}

