/* query.c generated by valac 0.48.17, the Vala compiler
 * generated from query.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>

typedef enum  {
	SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE = 1 << 0,
	SYNAPSE_QUERY_FLAGS_UNCATEGORIZED = 1 << 1,
	SYNAPSE_QUERY_FLAGS_APPLICATIONS = 1 << 2,
	SYNAPSE_QUERY_FLAGS_ACTIONS = 1 << 3,
	SYNAPSE_QUERY_FLAGS_AUDIO = 1 << 4,
	SYNAPSE_QUERY_FLAGS_VIDEO = 1 << 5,
	SYNAPSE_QUERY_FLAGS_DOCUMENTS = 1 << 6,
	SYNAPSE_QUERY_FLAGS_IMAGES = 1 << 7,
	SYNAPSE_QUERY_FLAGS_FILES = ((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_VIDEO) | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES,
	SYNAPSE_QUERY_FLAGS_PLACES = 1 << 8,
	SYNAPSE_QUERY_FLAGS_INTERNET = 1 << 9,
	SYNAPSE_QUERY_FLAGS_TEXT = 1 << 10,
	SYNAPSE_QUERY_FLAGS_CONTACTS = 1 << 11,
	SYNAPSE_QUERY_FLAGS_ALL = 0xFFFFFFFFLL,
	SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT = SYNAPSE_QUERY_FLAGS_ALL ^ SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE
} SynapseQueryFlags;

#define SYNAPSE_TYPE_QUERY_FLAGS (synapse_query_flags_get_type ())
typedef enum  {
	SYNAPSE_MATCHER_FLAGS_NO_REVERSED = 1 << 0,
	SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING = 1 << 1,
	SYNAPSE_MATCHER_FLAGS_NO_PARTIAL = 1 << 2,
	SYNAPSE_MATCHER_FLAGS_NO_FUZZY = 1 << 3
} SynapseMatcherFlags;

#define SYNAPSE_TYPE_MATCHER_FLAGS (synapse_matcher_flags_get_type ())

#define SYNAPSE_TYPE_QUERY (synapse_query_get_type ())
typedef struct _SynapseQuery SynapseQuery;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef enum  {
	SYNAPSE_MATCH_SCORE_INCREMENT_MINOR = 2000,
	SYNAPSE_MATCH_SCORE_INCREMENT_SMALL = 5000,
	SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM = 10000,
	SYNAPSE_MATCH_SCORE_INCREMENT_LARGE = 20000,
	SYNAPSE_MATCH_SCORE_URI_PENALTY = 15000,
	SYNAPSE_MATCH_SCORE_POOR = 50000,
	SYNAPSE_MATCH_SCORE_BELOW_AVERAGE = 60000,
	SYNAPSE_MATCH_SCORE_AVERAGE = 70000,
	SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE = 75000,
	SYNAPSE_MATCH_SCORE_GOOD = 80000,
	SYNAPSE_MATCH_SCORE_VERY_GOOD = 85000,
	SYNAPSE_MATCH_SCORE_EXCELLENT = 90000,
	SYNAPSE_MATCH_SCORE_HIGHEST = 100000
} SynapseMatchScore;

#define SYNAPSE_TYPE_MATCH_SCORE (synapse_match_score_get_type ())

struct _SynapseQuery {
	gchar* query_string;
	gchar* query_string_folded;
	GCancellable* cancellable;
	SynapseQueryFlags query_type;
	guint max_results;
	guint query_id;
};

typedef enum  {
	SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED,
	SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR
} SynapseSearchError;
#define SYNAPSE_SEARCH_ERROR synapse_search_error_quark ()

GType synapse_query_flags_get_type (void) G_GNUC_CONST;
GType synapse_matcher_flags_get_type (void) G_GNUC_CONST;
GType synapse_query_get_type (void) G_GNUC_CONST;
SynapseQuery* synapse_query_dup (const SynapseQuery* self);
void synapse_query_free (SynapseQuery* self);
void synapse_query_copy (const SynapseQuery* self,
                         SynapseQuery* dest);
void synapse_query_destroy (SynapseQuery* self);
void synapse_query_init (SynapseQuery *self,
                         guint query_id,
                         const gchar* query,
                         SynapseQueryFlags flags,
                         guint num_results);
gboolean synapse_query_is_cancelled (SynapseQuery *self);
GQuark synapse_search_error_quark (void);
void synapse_query_check_cancellable (SynapseQuery *self,
                                      GError** error);
GeeList* synapse_query_get_matchers_for_query (const gchar* query,
                                               SynapseMatcherFlags match_flags,
                                               GRegexCompileFlags flags);
GType synapse_match_score_get_type (void) G_GNUC_CONST;
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gint __lambda5_ (GeeMapEntry* a,
                 GeeMapEntry* b);
static gint ___lambda5__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static GType
synapse_query_flags_get_type_once (void)
{
	static const GFlagsValue values[] = {{SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE, "SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE", "include-remote"}, {SYNAPSE_QUERY_FLAGS_UNCATEGORIZED, "SYNAPSE_QUERY_FLAGS_UNCATEGORIZED", "uncategorized"}, {SYNAPSE_QUERY_FLAGS_APPLICATIONS, "SYNAPSE_QUERY_FLAGS_APPLICATIONS", "applications"}, {SYNAPSE_QUERY_FLAGS_ACTIONS, "SYNAPSE_QUERY_FLAGS_ACTIONS", "actions"}, {SYNAPSE_QUERY_FLAGS_AUDIO, "SYNAPSE_QUERY_FLAGS_AUDIO", "audio"}, {SYNAPSE_QUERY_FLAGS_VIDEO, "SYNAPSE_QUERY_FLAGS_VIDEO", "video"}, {SYNAPSE_QUERY_FLAGS_DOCUMENTS, "SYNAPSE_QUERY_FLAGS_DOCUMENTS", "documents"}, {SYNAPSE_QUERY_FLAGS_IMAGES, "SYNAPSE_QUERY_FLAGS_IMAGES", "images"}, {SYNAPSE_QUERY_FLAGS_FILES, "SYNAPSE_QUERY_FLAGS_FILES", "files"}, {SYNAPSE_QUERY_FLAGS_PLACES, "SYNAPSE_QUERY_FLAGS_PLACES", "places"}, {SYNAPSE_QUERY_FLAGS_INTERNET, "SYNAPSE_QUERY_FLAGS_INTERNET", "internet"}, {SYNAPSE_QUERY_FLAGS_TEXT, "SYNAPSE_QUERY_FLAGS_TEXT", "text"}, {SYNAPSE_QUERY_FLAGS_CONTACTS, "SYNAPSE_QUERY_FLAGS_CONTACTS", "contacts"}, {SYNAPSE_QUERY_FLAGS_ALL, "SYNAPSE_QUERY_FLAGS_ALL", "all"}, {SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT, "SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT", "local-content"}, {0, NULL, NULL}};
	GType synapse_query_flags_type_id;
	synapse_query_flags_type_id = g_flags_register_static ("SynapseQueryFlags", values);
	return synapse_query_flags_type_id;
}

GType
synapse_query_flags_get_type (void)
{
	static volatile gsize synapse_query_flags_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_query_flags_type_id__volatile)) {
		GType synapse_query_flags_type_id;
		synapse_query_flags_type_id = synapse_query_flags_get_type_once ();
		g_once_init_leave (&synapse_query_flags_type_id__volatile, synapse_query_flags_type_id);
	}
	return synapse_query_flags_type_id__volatile;
}

static GType
synapse_matcher_flags_get_type_once (void)
{
	static const GFlagsValue values[] = {{SYNAPSE_MATCHER_FLAGS_NO_REVERSED, "SYNAPSE_MATCHER_FLAGS_NO_REVERSED", "no-reversed"}, {SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING, "SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING", "no-substring"}, {SYNAPSE_MATCHER_FLAGS_NO_PARTIAL, "SYNAPSE_MATCHER_FLAGS_NO_PARTIAL", "no-partial"}, {SYNAPSE_MATCHER_FLAGS_NO_FUZZY, "SYNAPSE_MATCHER_FLAGS_NO_FUZZY", "no-fuzzy"}, {0, NULL, NULL}};
	GType synapse_matcher_flags_type_id;
	synapse_matcher_flags_type_id = g_flags_register_static ("SynapseMatcherFlags", values);
	return synapse_matcher_flags_type_id;
}

GType
synapse_matcher_flags_get_type (void)
{
	static volatile gsize synapse_matcher_flags_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_matcher_flags_type_id__volatile)) {
		GType synapse_matcher_flags_type_id;
		synapse_matcher_flags_type_id = synapse_matcher_flags_get_type_once ();
		g_once_init_leave (&synapse_matcher_flags_type_id__volatile, synapse_matcher_flags_type_id);
	}
	return synapse_matcher_flags_type_id__volatile;
}

void
synapse_query_init (SynapseQuery *self,
                    guint query_id,
                    const gchar* query,
                    SynapseQueryFlags flags,
                    guint num_results)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 95 "../../../src/core/query.vala"
	g_return_if_fail (query != NULL);
#line 95 "../../../src/core/query.vala"
	memset (self, 0, sizeof (SynapseQuery));
#line 100 "../../../src/core/query.vala"
	(*self).query_id = query_id;
#line 101 "../../../src/core/query.vala"
	_tmp0_ = g_strdup (query);
#line 101 "../../../src/core/query.vala"
	_g_free0 ((*self).query_string);
#line 101 "../../../src/core/query.vala"
	(*self).query_string = _tmp0_;
#line 102 "../../../src/core/query.vala"
	_tmp1_ = g_utf8_casefold (query, (gssize) -1);
#line 102 "../../../src/core/query.vala"
	_g_free0 ((*self).query_string_folded);
#line 102 "../../../src/core/query.vala"
	(*self).query_string_folded = _tmp1_;
#line 103 "../../../src/core/query.vala"
	(*self).query_type = flags;
#line 104 "../../../src/core/query.vala"
	(*self).max_results = num_results;
#line 213 "query.c"
}

gboolean
synapse_query_is_cancelled (SynapseQuery *self)
{
	GCancellable* _tmp0_;
	gboolean result = FALSE;
#line 109 "../../../src/core/query.vala"
	_tmp0_ = (*self).cancellable;
#line 109 "../../../src/core/query.vala"
	result = g_cancellable_is_cancelled (_tmp0_);
#line 109 "../../../src/core/query.vala"
	return result;
#line 227 "query.c"
}

void
synapse_query_check_cancellable (SynapseQuery *self,
                                 GError** error)
{
	GCancellable* _tmp0_;
	GError* _inner_error0_ = NULL;
#line 114 "../../../src/core/query.vala"
	_tmp0_ = (*self).cancellable;
#line 114 "../../../src/core/query.vala"
	if (g_cancellable_is_cancelled (_tmp0_)) {
#line 240 "query.c"
		GError* _tmp1_;
#line 116 "../../../src/core/query.vala"
		_tmp1_ = g_error_new_literal (SYNAPSE_SEARCH_ERROR, SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED, "Cancelled");
#line 116 "../../../src/core/query.vala"
		_inner_error0_ = _tmp1_;
#line 116 "../../../src/core/query.vala"
		if (_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 116 "../../../src/core/query.vala"
			g_propagate_error (error, _inner_error0_);
#line 116 "../../../src/core/query.vala"
			return;
#line 252 "query.c"
		} else {
#line 116 "../../../src/core/query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 116 "../../../src/core/query.vala"
			g_clear_error (&_inner_error0_);
#line 116 "../../../src/core/query.vala"
			return;
#line 260 "query.c"
		}
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
#line 1359 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1360 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1360 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1361 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1362 "glib-2.0.vapi"
	result = _result_;
#line 1362 "glib-2.0.vapi"
	return result;
#line 283 "query.c"
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 177 "../../../src/core/query.vala"
	if ((*length) == (*size)) {
#line 177 "../../../src/core/query.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 177 "../../../src/core/query.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 298 "query.c"
	}
#line 177 "../../../src/core/query.vala"
	(*array)[(*length)++] = value;
#line 177 "../../../src/core/query.vala"
	(*array)[*length] = NULL;
#line 304 "query.c"
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
#line 1200 "glib-2.0.vapi"
	if (separator == NULL) {
#line 1201 "glib-2.0.vapi"
		separator = "";
#line 318 "query.c"
	}
#line 1203 "glib-2.0.vapi"
	if (str_array != NULL) {
#line 322 "query.c"
		gboolean _tmp1_ = FALSE;
#line 1203 "glib-2.0.vapi"
		if (str_array_length1 > 0) {
#line 1203 "glib-2.0.vapi"
			_tmp1_ = TRUE;
#line 328 "query.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 1203 "glib-2.0.vapi"
			if (str_array_length1 == -1) {
#line 333 "query.c"
				const gchar* _tmp3_;
#line 1203 "glib-2.0.vapi"
				_tmp3_ = str_array[0];
#line 1203 "glib-2.0.vapi"
				_tmp2_ = _tmp3_ != NULL;
#line 339 "query.c"
			} else {
#line 1203 "glib-2.0.vapi"
				_tmp2_ = FALSE;
#line 343 "query.c"
			}
#line 1203 "glib-2.0.vapi"
			_tmp1_ = _tmp2_;
#line 347 "query.c"
		}
#line 1203 "glib-2.0.vapi"
		_tmp0_ = _tmp1_;
#line 351 "query.c"
	} else {
#line 1203 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 355 "query.c"
	}
#line 1203 "glib-2.0.vapi"
	if (_tmp0_) {
#line 359 "query.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
#line 1205 "glib-2.0.vapi"
		len = (gsize) 1;
#line 373 "query.c"
		{
			gboolean _tmp4_ = FALSE;
#line 1206 "glib-2.0.vapi"
			i = 0;
#line 1206 "glib-2.0.vapi"
			_tmp4_ = TRUE;
#line 1206 "glib-2.0.vapi"
			while (TRUE) {
#line 382 "query.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
#line 1206 "glib-2.0.vapi"
				if (!_tmp4_) {
#line 389 "query.c"
					gint _tmp5_;
#line 1206 "glib-2.0.vapi"
					_tmp5_ = i;
#line 1206 "glib-2.0.vapi"
					i = _tmp5_ + 1;
#line 395 "query.c"
				}
#line 1206 "glib-2.0.vapi"
				_tmp4_ = FALSE;
#line 1206 "glib-2.0.vapi"
				if (str_array_length1 != -1) {
#line 1206 "glib-2.0.vapi"
					_tmp7_ = i < str_array_length1;
#line 403 "query.c"
				} else {
#line 1206 "glib-2.0.vapi"
					_tmp7_ = FALSE;
#line 407 "query.c"
				}
#line 1206 "glib-2.0.vapi"
				if (_tmp7_) {
#line 1206 "glib-2.0.vapi"
					_tmp6_ = TRUE;
#line 413 "query.c"
				} else {
					gboolean _tmp8_ = FALSE;
#line 1206 "glib-2.0.vapi"
					if (str_array_length1 == -1) {
#line 418 "query.c"
						const gchar* _tmp9_;
#line 1206 "glib-2.0.vapi"
						_tmp9_ = str_array[i];
#line 1206 "glib-2.0.vapi"
						_tmp8_ = _tmp9_ != NULL;
#line 424 "query.c"
					} else {
#line 1206 "glib-2.0.vapi"
						_tmp8_ = FALSE;
#line 428 "query.c"
					}
#line 1206 "glib-2.0.vapi"
					_tmp6_ = _tmp8_;
#line 432 "query.c"
				}
#line 1206 "glib-2.0.vapi"
				if (!_tmp6_) {
#line 1206 "glib-2.0.vapi"
					break;
#line 438 "query.c"
				}
#line 1207 "glib-2.0.vapi"
				_tmp11_ = str_array[i];
#line 1207 "glib-2.0.vapi"
				if (_tmp11_ != NULL) {
#line 444 "query.c"
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
#line 1207 "glib-2.0.vapi"
					_tmp12_ = str_array[i];
#line 1207 "glib-2.0.vapi"
					_tmp13_ = strlen ((const gchar*) _tmp12_);
#line 1207 "glib-2.0.vapi"
					_tmp14_ = _tmp13_;
#line 1207 "glib-2.0.vapi"
					_tmp10_ = _tmp14_;
#line 456 "query.c"
				} else {
#line 1207 "glib-2.0.vapi"
					_tmp10_ = 0;
#line 460 "query.c"
				}
#line 1207 "glib-2.0.vapi"
				len += (gsize) _tmp10_;
#line 464 "query.c"
			}
		}
#line 1209 "glib-2.0.vapi"
		if (i == 0) {
#line 469 "query.c"
			gchar* _tmp15_;
#line 1210 "glib-2.0.vapi"
			_tmp15_ = g_strdup ("");
#line 1210 "glib-2.0.vapi"
			result = _tmp15_;
#line 1210 "glib-2.0.vapi"
			return result;
#line 477 "query.c"
		}
#line 1212 "glib-2.0.vapi"
		str_array_length1 = i;
#line 1213 "glib-2.0.vapi"
		_tmp16_ = strlen ((const gchar*) separator);
#line 1213 "glib-2.0.vapi"
		_tmp17_ = _tmp16_;
#line 1213 "glib-2.0.vapi"
		len += (gsize) (_tmp17_ * (i - 1));
#line 1215 "glib-2.0.vapi"
		_tmp18_ = g_malloc (len);
#line 1215 "glib-2.0.vapi"
		res = _tmp18_;
#line 1216 "glib-2.0.vapi"
		_tmp19_ = res;
#line 1216 "glib-2.0.vapi"
		_tmp20_ = str_array[0];
#line 1216 "glib-2.0.vapi"
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
#line 1216 "glib-2.0.vapi"
		ptr = _tmp21_;
#line 499 "query.c"
		{
			gboolean _tmp22_ = FALSE;
#line 1217 "glib-2.0.vapi"
			i = 1;
#line 1217 "glib-2.0.vapi"
			_tmp22_ = TRUE;
#line 1217 "glib-2.0.vapi"
			while (TRUE) {
#line 508 "query.c"
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
#line 1217 "glib-2.0.vapi"
				if (!_tmp22_) {
#line 517 "query.c"
					gint _tmp23_;
#line 1217 "glib-2.0.vapi"
					_tmp23_ = i;
#line 1217 "glib-2.0.vapi"
					i = _tmp23_ + 1;
#line 523 "query.c"
				}
#line 1217 "glib-2.0.vapi"
				_tmp22_ = FALSE;
#line 1217 "glib-2.0.vapi"
				if (!(i < str_array_length1)) {
#line 1217 "glib-2.0.vapi"
					break;
#line 531 "query.c"
				}
#line 1218 "glib-2.0.vapi"
				_tmp24_ = ptr;
#line 1218 "glib-2.0.vapi"
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
#line 1218 "glib-2.0.vapi"
				ptr = _tmp25_;
#line 1219 "glib-2.0.vapi"
				_tmp27_ = str_array[i];
#line 1219 "glib-2.0.vapi"
				if (_tmp27_ != NULL) {
#line 543 "query.c"
					const gchar* _tmp28_;
#line 1219 "glib-2.0.vapi"
					_tmp28_ = str_array[i];
#line 1219 "glib-2.0.vapi"
					_tmp26_ = (const gchar*) _tmp28_;
#line 549 "query.c"
				} else {
#line 1219 "glib-2.0.vapi"
					_tmp26_ = "";
#line 553 "query.c"
				}
#line 1219 "glib-2.0.vapi"
				_tmp29_ = ptr;
#line 1219 "glib-2.0.vapi"
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
#line 1219 "glib-2.0.vapi"
				ptr = _tmp30_;
#line 561 "query.c"
			}
		}
#line 1222 "glib-2.0.vapi"
		_tmp31_ = res;
#line 1222 "glib-2.0.vapi"
		res = NULL;
#line 1222 "glib-2.0.vapi"
		result = (gchar*) _tmp31_;
#line 1222 "glib-2.0.vapi"
		return result;
#line 572 "query.c"
	} else {
		gchar* _tmp32_;
#line 1224 "glib-2.0.vapi"
		_tmp32_ = g_strdup ("");
#line 1224 "glib-2.0.vapi"
		result = _tmp32_;
#line 1224 "glib-2.0.vapi"
		return result;
#line 581 "query.c"
	}
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 249 "../../../src/core/query.vala"
	if ((*length) == (*size)) {
#line 249 "../../../src/core/query.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 249 "../../../src/core/query.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 597 "query.c"
	}
#line 249 "../../../src/core/query.vala"
	(*array)[(*length)++] = value;
#line 249 "../../../src/core/query.vala"
	(*array)[*length] = NULL;
#line 603 "query.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 285 "../../../src/core/query.vala"
	return self ? g_object_ref (self) : NULL;
#line 611 "query.c"
}

static gint
__lambda5_ (GeeMapEntry* a,
            GeeMapEntry* b)
{
	GeeMapEntry* e1 = NULL;
	GeeMapEntry* e2 = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	gconstpointer _tmp2_;
	gconstpointer _tmp3_;
	gint result = 0;
#line 287 "../../../src/core/query.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 287 "../../../src/core/query.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 288 "../../../src/core/query.vala"
	e1 = G_TYPE_CHECK_INSTANCE_CAST (a, GEE_MAP_TYPE_ENTRY, GeeMapEntry);
#line 289 "../../../src/core/query.vala"
	e2 = G_TYPE_CHECK_INSTANCE_CAST (b, GEE_MAP_TYPE_ENTRY, GeeMapEntry);
#line 290 "../../../src/core/query.vala"
	_tmp0_ = gee_map_entry_get_value (e2);
#line 290 "../../../src/core/query.vala"
	_tmp1_ = _tmp0_;
#line 290 "../../../src/core/query.vala"
	_tmp2_ = gee_map_entry_get_value (e1);
#line 290 "../../../src/core/query.vala"
	_tmp3_ = _tmp2_;
#line 290 "../../../src/core/query.vala"
	result = ((gint) ((gintptr) _tmp1_)) - ((gint) ((gintptr) _tmp3_));
#line 290 "../../../src/core/query.vala"
	return result;
#line 645 "query.c"
}

static gint
___lambda5__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda5_ ((GeeMapEntry*) a, (GeeMapEntry*) b);
#line 287 "../../../src/core/query.vala"
	return result;
#line 657 "query.c"
}

GeeList*
synapse_query_get_matchers_for_query (const gchar* query,
                                      SynapseMatcherFlags match_flags,
                                      GRegexCompileFlags flags)
{
	GeeHashMap* results = NULL;
	GeeHashMap* _tmp0_;
	gchar* stripped_query = NULL;
	gchar* _tmp1_;
	gchar* escaped_query = NULL;
	gchar* _tmp2_;
	GRegex* re = NULL;
	gchar** individual_words = NULL;
	gchar** _tmp24_;
	gchar** _tmp25_;
	gint individual_words_length1;
	gint _individual_words_size_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	gchar** individual_chars = NULL;
	gchar** _tmp82_;
	gchar** _tmp83_;
	gint individual_chars_length1;
	gint _individual_chars_size_;
	gchar** escaped_chars = NULL;
	gchar** _tmp84_;
	gint escaped_chars_length1;
	gint _escaped_chars_size_;
	gchar** _tmp85_;
	gint _tmp85__length1;
	gboolean _tmp88_ = FALSE;
	gboolean _tmp89_ = FALSE;
	gboolean _tmp102_ = FALSE;
	GeeArrayList* sorted_results = NULL;
	GeeArrayList* _tmp114_;
	GeeSet* entries = NULL;
	GeeSet* _tmp115_;
	GeeSet* _tmp116_;
	GeeSet* _tmp117_;
	GError* _inner_error0_ = NULL;
	GeeList* result = NULL;
#line 120 "../../../src/core/query.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 138 "../../../src/core/query.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_REGEX, (GBoxedCopyFunc) g_regex_ref, (GDestroyNotify) g_regex_unref, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 138 "../../../src/core/query.vala"
	results = _tmp0_;
#line 139 "../../../src/core/query.vala"
	_tmp1_ = string_strip (query);
#line 139 "../../../src/core/query.vala"
	stripped_query = _tmp1_;
#line 140 "../../../src/core/query.vala"
	_tmp2_ = g_regex_escape_string (stripped_query, -1);
#line 140 "../../../src/core/query.vala"
	escaped_query = _tmp2_;
#line 715 "query.c"
	{
		GRegex* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GRegex* _tmp6_;
		GRegex* _tmp7_;
		GRegex* _tmp8_;
		GRegex* _tmp9_;
#line 145 "../../../src/core/query.vala"
		_tmp4_ = g_strdup_printf ("^(%s)$", escaped_query);
#line 145 "../../../src/core/query.vala"
		_tmp5_ = _tmp4_;
#line 145 "../../../src/core/query.vala"
		_tmp6_ = g_regex_new (_tmp5_, flags, 0, &_inner_error0_);
#line 145 "../../../src/core/query.vala"
		_tmp7_ = _tmp6_;
#line 145 "../../../src/core/query.vala"
		_g_free0 (_tmp5_);
#line 145 "../../../src/core/query.vala"
		_tmp3_ = _tmp7_;
#line 145 "../../../src/core/query.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 145 "../../../src/core/query.vala"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 740 "query.c"
				goto __catch0_g_regex_error;
			}
#line 145 "../../../src/core/query.vala"
			_g_regex_unref0 (re);
#line 145 "../../../src/core/query.vala"
			_g_free0 (escaped_query);
#line 145 "../../../src/core/query.vala"
			_g_free0 (stripped_query);
#line 145 "../../../src/core/query.vala"
			_g_object_unref0 (results);
#line 145 "../../../src/core/query.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 145 "../../../src/core/query.vala"
			g_clear_error (&_inner_error0_);
#line 145 "../../../src/core/query.vala"
			return NULL;
#line 757 "query.c"
		}
#line 145 "../../../src/core/query.vala"
		_tmp8_ = _tmp3_;
#line 145 "../../../src/core/query.vala"
		_tmp3_ = NULL;
#line 145 "../../../src/core/query.vala"
		_g_regex_unref0 (re);
#line 145 "../../../src/core/query.vala"
		re = _tmp8_;
#line 146 "../../../src/core/query.vala"
		_tmp9_ = re;
#line 146 "../../../src/core/query.vala"
		gee_abstract_map_set ((GeeAbstractMap*) results, _tmp9_, (gpointer) ((gintptr) SYNAPSE_MATCH_SCORE_HIGHEST));
#line 143 "../../../src/core/query.vala"
		_g_regex_unref0 (_tmp3_);
#line 773 "query.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 143 "../../../src/core/query.vala"
		g_clear_error (&_inner_error0_);
#line 780 "query.c"
	}
	__finally0:
#line 143 "../../../src/core/query.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 143 "../../../src/core/query.vala"
		_g_regex_unref0 (re);
#line 143 "../../../src/core/query.vala"
		_g_free0 (escaped_query);
#line 143 "../../../src/core/query.vala"
		_g_free0 (stripped_query);
#line 143 "../../../src/core/query.vala"
		_g_object_unref0 (results);
#line 143 "../../../src/core/query.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 143 "../../../src/core/query.vala"
		g_clear_error (&_inner_error0_);
#line 143 "../../../src/core/query.vala"
		return NULL;
#line 799 "query.c"
	}
	{
		GRegex* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GRegex* _tmp13_;
		GRegex* _tmp14_;
		GRegex* _tmp15_;
		GRegex* _tmp16_;
#line 154 "../../../src/core/query.vala"
		_tmp11_ = g_strdup_printf ("^(%s)", escaped_query);
#line 154 "../../../src/core/query.vala"
		_tmp12_ = _tmp11_;
#line 154 "../../../src/core/query.vala"
		_tmp13_ = g_regex_new (_tmp12_, flags, 0, &_inner_error0_);
#line 154 "../../../src/core/query.vala"
		_tmp14_ = _tmp13_;
#line 154 "../../../src/core/query.vala"
		_g_free0 (_tmp12_);
#line 154 "../../../src/core/query.vala"
		_tmp10_ = _tmp14_;
#line 154 "../../../src/core/query.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 154 "../../../src/core/query.vala"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 825 "query.c"
				goto __catch1_g_regex_error;
			}
#line 154 "../../../src/core/query.vala"
			_g_regex_unref0 (re);
#line 154 "../../../src/core/query.vala"
			_g_free0 (escaped_query);
#line 154 "../../../src/core/query.vala"
			_g_free0 (stripped_query);
#line 154 "../../../src/core/query.vala"
			_g_object_unref0 (results);
#line 154 "../../../src/core/query.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 154 "../../../src/core/query.vala"
			g_clear_error (&_inner_error0_);
#line 154 "../../../src/core/query.vala"
			return NULL;
#line 842 "query.c"
		}
#line 154 "../../../src/core/query.vala"
		_tmp15_ = _tmp10_;
#line 154 "../../../src/core/query.vala"
		_tmp10_ = NULL;
#line 154 "../../../src/core/query.vala"
		_g_regex_unref0 (re);
#line 154 "../../../src/core/query.vala"
		re = _tmp15_;
#line 155 "../../../src/core/query.vala"
		_tmp16_ = re;
#line 155 "../../../src/core/query.vala"
		gee_abstract_map_set ((GeeAbstractMap*) results, _tmp16_, (gpointer) ((gintptr) SYNAPSE_MATCH_SCORE_EXCELLENT));
#line 152 "../../../src/core/query.vala"
		_g_regex_unref0 (_tmp10_);
#line 858 "query.c"
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
#line 152 "../../../src/core/query.vala"
		g_clear_error (&_inner_error0_);
#line 865 "query.c"
	}
	__finally1:
#line 152 "../../../src/core/query.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 152 "../../../src/core/query.vala"
		_g_regex_unref0 (re);
#line 152 "../../../src/core/query.vala"
		_g_free0 (escaped_query);
#line 152 "../../../src/core/query.vala"
		_g_free0 (stripped_query);
#line 152 "../../../src/core/query.vala"
		_g_object_unref0 (results);
#line 152 "../../../src/core/query.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 152 "../../../src/core/query.vala"
		g_clear_error (&_inner_error0_);
#line 152 "../../../src/core/query.vala"
		return NULL;
#line 884 "query.c"
	}
	{
		GRegex* _tmp17_ = NULL;
		gchar* _tmp18_;
		gchar* _tmp19_;
		GRegex* _tmp20_;
		GRegex* _tmp21_;
		GRegex* _tmp22_;
		GRegex* _tmp23_;
#line 163 "../../../src/core/query.vala"
		_tmp18_ = g_strdup_printf ("\\b(%s)", escaped_query);
#line 163 "../../../src/core/query.vala"
		_tmp19_ = _tmp18_;
#line 163 "../../../src/core/query.vala"
		_tmp20_ = g_regex_new (_tmp19_, flags, 0, &_inner_error0_);
#line 163 "../../../src/core/query.vala"
		_tmp21_ = _tmp20_;
#line 163 "../../../src/core/query.vala"
		_g_free0 (_tmp19_);
#line 163 "../../../src/core/query.vala"
		_tmp17_ = _tmp21_;
#line 163 "../../../src/core/query.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 163 "../../../src/core/query.vala"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 910 "query.c"
				goto __catch2_g_regex_error;
			}
#line 163 "../../../src/core/query.vala"
			_g_regex_unref0 (re);
#line 163 "../../../src/core/query.vala"
			_g_free0 (escaped_query);
#line 163 "../../../src/core/query.vala"
			_g_free0 (stripped_query);
#line 163 "../../../src/core/query.vala"
			_g_object_unref0 (results);
#line 163 "../../../src/core/query.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 163 "../../../src/core/query.vala"
			g_clear_error (&_inner_error0_);
#line 163 "../../../src/core/query.vala"
			return NULL;
#line 927 "query.c"
		}
#line 163 "../../../src/core/query.vala"
		_tmp22_ = _tmp17_;
#line 163 "../../../src/core/query.vala"
		_tmp17_ = NULL;
#line 163 "../../../src/core/query.vala"
		_g_regex_unref0 (re);
#line 163 "../../../src/core/query.vala"
		re = _tmp22_;
#line 164 "../../../src/core/query.vala"
		_tmp23_ = re;
#line 164 "../../../src/core/query.vala"
		gee_abstract_map_set ((GeeAbstractMap*) results, _tmp23_, (gpointer) ((gintptr) SYNAPSE_MATCH_SCORE_VERY_GOOD));
#line 161 "../../../src/core/query.vala"
		_g_regex_unref0 (_tmp17_);
#line 943 "query.c"
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
#line 161 "../../../src/core/query.vala"
		g_clear_error (&_inner_error0_);
#line 950 "query.c"
	}
	__finally2:
#line 161 "../../../src/core/query.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 161 "../../../src/core/query.vala"
		_g_regex_unref0 (re);
#line 161 "../../../src/core/query.vala"
		_g_free0 (escaped_query);
#line 161 "../../../src/core/query.vala"
		_g_free0 (stripped_query);
#line 161 "../../../src/core/query.vala"
		_g_object_unref0 (results);
#line 161 "../../../src/core/query.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 161 "../../../src/core/query.vala"
		g_clear_error (&_inner_error0_);
#line 161 "../../../src/core/query.vala"
		return NULL;
#line 969 "query.c"
	}
#line 171 "../../../src/core/query.vala"
	_tmp25_ = _tmp24_ = g_regex_split_simple ("\\s+", stripped_query, 0, 0);
#line 171 "../../../src/core/query.vala"
	individual_words = _tmp25_;
#line 171 "../../../src/core/query.vala"
	individual_words_length1 = _vala_array_length (_tmp24_);
#line 171 "../../../src/core/query.vala"
	_individual_words_size_ = individual_words_length1;
#line 172 "../../../src/core/query.vala"
	_tmp26_ = individual_words;
#line 172 "../../../src/core/query.vala"
	_tmp26__length1 = individual_words_length1;
#line 172 "../../../src/core/query.vala"
	if (_tmp26__length1 >= 2) {
#line 985 "query.c"
		gchar** escaped_words = NULL;
		gchar** _tmp27_;
		gint escaped_words_length1;
		gint _escaped_words_size_;
		gchar** _tmp28_;
		gint _tmp28__length1;
		gchar* pattern = NULL;
		gchar** _tmp31_;
		gint _tmp31__length1;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
#line 174 "../../../src/core/query.vala"
		_tmp27_ = g_new0 (gchar*, 0 + 1);
#line 174 "../../../src/core/query.vala"
		escaped_words = _tmp27_;
#line 174 "../../../src/core/query.vala"
		escaped_words_length1 = 0;
#line 174 "../../../src/core/query.vala"
		_escaped_words_size_ = escaped_words_length1;
#line 175 "../../../src/core/query.vala"
		_tmp28_ = individual_words;
#line 175 "../../../src/core/query.vala"
		_tmp28__length1 = individual_words_length1;
#line 1011 "query.c"
		{
			gchar** word_collection = NULL;
			gint word_collection_length1 = 0;
			gint _word_collection_size_ = 0;
			gint word_it = 0;
#line 175 "../../../src/core/query.vala"
			word_collection = _tmp28_;
#line 175 "../../../src/core/query.vala"
			word_collection_length1 = _tmp28__length1;
#line 175 "../../../src/core/query.vala"
			for (word_it = 0; word_it < word_collection_length1; word_it = word_it + 1) {
#line 1023 "query.c"
				const gchar* word = NULL;
#line 175 "../../../src/core/query.vala"
				word = word_collection[word_it];
#line 1027 "query.c"
				{
					const gchar* _tmp29_;
					gchar* _tmp30_;
#line 177 "../../../src/core/query.vala"
					_tmp29_ = word;
#line 177 "../../../src/core/query.vala"
					_tmp30_ = g_regex_escape_string (_tmp29_, -1);
#line 177 "../../../src/core/query.vala"
					_vala_array_add6 (&escaped_words, &escaped_words_length1, &_escaped_words_size_, _tmp30_);
#line 1037 "query.c"
				}
			}
		}
#line 179 "../../../src/core/query.vala"
		_tmp31_ = escaped_words;
#line 179 "../../../src/core/query.vala"
		_tmp31__length1 = escaped_words_length1;
#line 179 "../../../src/core/query.vala"
		_tmp32_ = _vala_g_strjoinv (").+\\b(", _tmp31_, (gint) _tmp31__length1);
#line 179 "../../../src/core/query.vala"
		_tmp33_ = _tmp32_;
#line 179 "../../../src/core/query.vala"
		_tmp34_ = g_strdup_printf ("\\b(%s)", _tmp33_);
#line 179 "../../../src/core/query.vala"
		_tmp35_ = _tmp34_;
#line 179 "../../../src/core/query.vala"
		_g_free0 (_tmp33_);
#line 179 "../../../src/core/query.vala"
		pattern = _tmp35_;
#line 1057 "query.c"
		{
			GRegex* _tmp36_ = NULL;
			const gchar* _tmp37_;
			GRegex* _tmp38_;
			GRegex* _tmp39_;
			GRegex* _tmp40_;
#line 184 "../../../src/core/query.vala"
			_tmp37_ = pattern;
#line 184 "../../../src/core/query.vala"
			_tmp38_ = g_regex_new (_tmp37_, flags, 0, &_inner_error0_);
#line 184 "../../../src/core/query.vala"
			_tmp36_ = _tmp38_;
#line 184 "../../../src/core/query.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 184 "../../../src/core/query.vala"
				if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1074 "query.c"
					goto __catch3_g_regex_error;
				}
#line 184 "../../../src/core/query.vala"
				_g_free0 (pattern);
#line 184 "../../../src/core/query.vala"
				escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
#line 184 "../../../src/core/query.vala"
				individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 184 "../../../src/core/query.vala"
				_g_regex_unref0 (re);
#line 184 "../../../src/core/query.vala"
				_g_free0 (escaped_query);
#line 184 "../../../src/core/query.vala"
				_g_free0 (stripped_query);
#line 184 "../../../src/core/query.vala"
				_g_object_unref0 (results);
#line 184 "../../../src/core/query.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 184 "../../../src/core/query.vala"
				g_clear_error (&_inner_error0_);
#line 184 "../../../src/core/query.vala"
				return NULL;
#line 1097 "query.c"
			}
#line 184 "../../../src/core/query.vala"
			_tmp39_ = _tmp36_;
#line 184 "../../../src/core/query.vala"
			_tmp36_ = NULL;
#line 184 "../../../src/core/query.vala"
			_g_regex_unref0 (re);
#line 184 "../../../src/core/query.vala"
			re = _tmp39_;
#line 185 "../../../src/core/query.vala"
			_tmp40_ = re;
#line 185 "../../../src/core/query.vala"
			gee_abstract_map_set ((GeeAbstractMap*) results, _tmp40_, (gpointer) ((gintptr) SYNAPSE_MATCH_SCORE_GOOD));
#line 182 "../../../src/core/query.vala"
			_g_regex_unref0 (_tmp36_);
#line 1113 "query.c"
		}
		goto __finally3;
		__catch3_g_regex_error:
		{
#line 182 "../../../src/core/query.vala"
			g_clear_error (&_inner_error0_);
#line 1120 "query.c"
		}
		__finally3:
#line 182 "../../../src/core/query.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 182 "../../../src/core/query.vala"
			_g_free0 (pattern);
#line 182 "../../../src/core/query.vala"
			escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
#line 182 "../../../src/core/query.vala"
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 182 "../../../src/core/query.vala"
			_g_regex_unref0 (re);
#line 182 "../../../src/core/query.vala"
			_g_free0 (escaped_query);
#line 182 "../../../src/core/query.vala"
			_g_free0 (stripped_query);
#line 182 "../../../src/core/query.vala"
			_g_object_unref0 (results);
#line 182 "../../../src/core/query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 182 "../../../src/core/query.vala"
			g_clear_error (&_inner_error0_);
#line 182 "../../../src/core/query.vala"
			return NULL;
#line 1145 "query.c"
		}
#line 192 "../../../src/core/query.vala"
		if (!((match_flags & SYNAPSE_MATCHER_FLAGS_NO_REVERSED) == SYNAPSE_MATCHER_FLAGS_NO_REVERSED)) {
#line 1149 "query.c"
			gchar** _tmp41_;
			gint _tmp41__length1;
#line 194 "../../../src/core/query.vala"
			_tmp41_ = escaped_words;
#line 194 "../../../src/core/query.vala"
			_tmp41__length1 = escaped_words_length1;
#line 194 "../../../src/core/query.vala"
			if (_tmp41__length1 == 2) {
#line 1158 "query.c"
				gchar* reversed = NULL;
				gchar** _tmp42_;
				gint _tmp42__length1;
				const gchar* _tmp43_;
				gchar** _tmp44_;
				gint _tmp44__length1;
				const gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
#line 196 "../../../src/core/query.vala"
				_tmp42_ = escaped_words;
#line 196 "../../../src/core/query.vala"
				_tmp42__length1 = escaped_words_length1;
#line 196 "../../../src/core/query.vala"
				_tmp43_ = _tmp42_[1];
#line 196 "../../../src/core/query.vala"
				_tmp44_ = escaped_words;
#line 196 "../../../src/core/query.vala"
				_tmp44__length1 = escaped_words_length1;
#line 196 "../../../src/core/query.vala"
				_tmp45_ = _tmp44_[0];
#line 196 "../../../src/core/query.vala"
				_tmp46_ = g_strjoin (").+\\b(", _tmp43_, _tmp45_, NULL, NULL);
#line 196 "../../../src/core/query.vala"
				_tmp47_ = _tmp46_;
#line 196 "../../../src/core/query.vala"
				_tmp48_ = g_strdup_printf ("\\b(%s)", _tmp47_);
#line 196 "../../../src/core/query.vala"
				_tmp49_ = _tmp48_;
#line 196 "../../../src/core/query.vala"
				_g_free0 (_tmp47_);
#line 196 "../../../src/core/query.vala"
				reversed = _tmp49_;
#line 1194 "query.c"
				{
					GRegex* _tmp50_ = NULL;
					const gchar* _tmp51_;
					GRegex* _tmp52_;
					GRegex* _tmp53_;
					GRegex* _tmp54_;
#line 202 "../../../src/core/query.vala"
					_tmp51_ = reversed;
#line 202 "../../../src/core/query.vala"
					_tmp52_ = g_regex_new (_tmp51_, flags, 0, &_inner_error0_);
#line 202 "../../../src/core/query.vala"
					_tmp50_ = _tmp52_;
#line 202 "../../../src/core/query.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 202 "../../../src/core/query.vala"
						if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1211 "query.c"
							goto __catch4_g_regex_error;
						}
#line 202 "../../../src/core/query.vala"
						_g_free0 (reversed);
#line 202 "../../../src/core/query.vala"
						_g_free0 (pattern);
#line 202 "../../../src/core/query.vala"
						escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
#line 202 "../../../src/core/query.vala"
						individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 202 "../../../src/core/query.vala"
						_g_regex_unref0 (re);
#line 202 "../../../src/core/query.vala"
						_g_free0 (escaped_query);
#line 202 "../../../src/core/query.vala"
						_g_free0 (stripped_query);
#line 202 "../../../src/core/query.vala"
						_g_object_unref0 (results);
#line 202 "../../../src/core/query.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 202 "../../../src/core/query.vala"
						g_clear_error (&_inner_error0_);
#line 202 "../../../src/core/query.vala"
						return NULL;
#line 1236 "query.c"
					}
#line 202 "../../../src/core/query.vala"
					_tmp53_ = _tmp50_;
#line 202 "../../../src/core/query.vala"
					_tmp50_ = NULL;
#line 202 "../../../src/core/query.vala"
					_g_regex_unref0 (re);
#line 202 "../../../src/core/query.vala"
					re = _tmp53_;
#line 203 "../../../src/core/query.vala"
					_tmp54_ = re;
#line 203 "../../../src/core/query.vala"
					gee_abstract_map_set ((GeeAbstractMap*) results, _tmp54_, (gpointer) ((gintptr) (SYNAPSE_MATCH_SCORE_GOOD - SYNAPSE_MATCH_SCORE_INCREMENT_MINOR)));
#line 200 "../../../src/core/query.vala"
					_g_regex_unref0 (_tmp50_);
#line 1252 "query.c"
				}
				goto __finally4;
				__catch4_g_regex_error:
				{
#line 200 "../../../src/core/query.vala"
					g_clear_error (&_inner_error0_);
#line 1259 "query.c"
				}
				__finally4:
#line 200 "../../../src/core/query.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 200 "../../../src/core/query.vala"
					_g_free0 (reversed);
#line 200 "../../../src/core/query.vala"
					_g_free0 (pattern);
#line 200 "../../../src/core/query.vala"
					escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
#line 200 "../../../src/core/query.vala"
					individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 200 "../../../src/core/query.vala"
					_g_regex_unref0 (re);
#line 200 "../../../src/core/query.vala"
					_g_free0 (escaped_query);
#line 200 "../../../src/core/query.vala"
					_g_free0 (stripped_query);
#line 200 "../../../src/core/query.vala"
					_g_object_unref0 (results);
#line 200 "../../../src/core/query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 200 "../../../src/core/query.vala"
					g_clear_error (&_inner_error0_);
#line 200 "../../../src/core/query.vala"
					return NULL;
#line 1286 "query.c"
				}
#line 194 "../../../src/core/query.vala"
				_g_free0 (reversed);
#line 1290 "query.c"
			} else {
				gchar* orred = NULL;
				gchar** _tmp55_;
				gint _tmp55__length1;
				gchar* _tmp56_;
				gchar* _tmp57_;
				gchar* _tmp58_;
				gchar* _tmp59_;
				gchar* any_order = NULL;
				gchar* _tmp60_;
#line 212 "../../../src/core/query.vala"
				_tmp55_ = escaped_words;
#line 212 "../../../src/core/query.vala"
				_tmp55__length1 = escaped_words_length1;
#line 212 "../../../src/core/query.vala"
				_tmp56_ = _vala_g_strjoinv (")|(?:", _tmp55_, (gint) _tmp55__length1);
#line 212 "../../../src/core/query.vala"
				_tmp57_ = _tmp56_;
#line 212 "../../../src/core/query.vala"
				_tmp58_ = g_strdup_printf ("\\b((?:%s))", _tmp57_);
#line 212 "../../../src/core/query.vala"
				_tmp59_ = _tmp58_;
#line 212 "../../../src/core/query.vala"
				_g_free0 (_tmp57_);
#line 212 "../../../src/core/query.vala"
				orred = _tmp59_;
#line 213 "../../../src/core/query.vala"
				_tmp60_ = g_strdup ("");
#line 213 "../../../src/core/query.vala"
				any_order = _tmp60_;
#line 1321 "query.c"
				{
					gint i = 0;
#line 214 "../../../src/core/query.vala"
					i = 0;
#line 1326 "query.c"
					{
						gboolean _tmp61_ = FALSE;
#line 214 "../../../src/core/query.vala"
						_tmp61_ = TRUE;
#line 214 "../../../src/core/query.vala"
						while (TRUE) {
#line 1333 "query.c"
							gchar** _tmp63_;
							gint _tmp63__length1;
							gboolean is_last = FALSE;
							gchar** _tmp64_;
							gint _tmp64__length1;
							const gchar* _tmp65_;
							const gchar* _tmp66_;
							gchar* _tmp67_;
#line 214 "../../../src/core/query.vala"
							if (!_tmp61_) {
#line 1344 "query.c"
								gint _tmp62_;
#line 214 "../../../src/core/query.vala"
								_tmp62_ = i;
#line 214 "../../../src/core/query.vala"
								i = _tmp62_ + 1;
#line 1350 "query.c"
							}
#line 214 "../../../src/core/query.vala"
							_tmp61_ = FALSE;
#line 214 "../../../src/core/query.vala"
							_tmp63_ = escaped_words;
#line 214 "../../../src/core/query.vala"
							_tmp63__length1 = escaped_words_length1;
#line 214 "../../../src/core/query.vala"
							if (!(i < _tmp63__length1)) {
#line 214 "../../../src/core/query.vala"
								break;
#line 1362 "query.c"
							}
#line 216 "../../../src/core/query.vala"
							_tmp64_ = escaped_words;
#line 216 "../../../src/core/query.vala"
							_tmp64__length1 = escaped_words_length1;
#line 216 "../../../src/core/query.vala"
							is_last = i == (_tmp64__length1 - 1);
#line 217 "../../../src/core/query.vala"
							_tmp65_ = any_order;
#line 217 "../../../src/core/query.vala"
							_tmp66_ = orred;
#line 217 "../../../src/core/query.vala"
							_tmp67_ = g_strconcat (_tmp65_, _tmp66_, NULL);
#line 217 "../../../src/core/query.vala"
							_g_free0 (any_order);
#line 217 "../../../src/core/query.vala"
							any_order = _tmp67_;
#line 218 "../../../src/core/query.vala"
							if (!is_last) {
#line 1382 "query.c"
								const gchar* _tmp68_;
								gchar* _tmp69_;
#line 218 "../../../src/core/query.vala"
								_tmp68_ = any_order;
#line 218 "../../../src/core/query.vala"
								_tmp69_ = g_strconcat (_tmp68_, ".+", NULL);
#line 218 "../../../src/core/query.vala"
								_g_free0 (any_order);
#line 218 "../../../src/core/query.vala"
								any_order = _tmp69_;
#line 1393 "query.c"
							}
						}
					}
				}
				{
					GRegex* _tmp70_ = NULL;
					const gchar* _tmp71_;
					GRegex* _tmp72_;
					GRegex* _tmp73_;
					GRegex* _tmp74_;
#line 222 "../../../src/core/query.vala"
					_tmp71_ = any_order;
#line 222 "../../../src/core/query.vala"
					_tmp72_ = g_regex_new (_tmp71_, flags, 0, &_inner_error0_);
#line 222 "../../../src/core/query.vala"
					_tmp70_ = _tmp72_;
#line 222 "../../../src/core/query.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 222 "../../../src/core/query.vala"
						if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1414 "query.c"
							goto __catch5_g_regex_error;
						}
#line 222 "../../../src/core/query.vala"
						_g_free0 (any_order);
#line 222 "../../../src/core/query.vala"
						_g_free0 (orred);
#line 222 "../../../src/core/query.vala"
						_g_free0 (pattern);
#line 222 "../../../src/core/query.vala"
						escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
#line 222 "../../../src/core/query.vala"
						individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 222 "../../../src/core/query.vala"
						_g_regex_unref0 (re);
#line 222 "../../../src/core/query.vala"
						_g_free0 (escaped_query);
#line 222 "../../../src/core/query.vala"
						_g_free0 (stripped_query);
#line 222 "../../../src/core/query.vala"
						_g_object_unref0 (results);
#line 222 "../../../src/core/query.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 222 "../../../src/core/query.vala"
						g_clear_error (&_inner_error0_);
#line 222 "../../../src/core/query.vala"
						return NULL;
#line 1441 "query.c"
					}
#line 222 "../../../src/core/query.vala"
					_tmp73_ = _tmp70_;
#line 222 "../../../src/core/query.vala"
					_tmp70_ = NULL;
#line 222 "../../../src/core/query.vala"
					_g_regex_unref0 (re);
#line 222 "../../../src/core/query.vala"
					re = _tmp73_;
#line 223 "../../../src/core/query.vala"
					_tmp74_ = re;
#line 223 "../../../src/core/query.vala"
					gee_abstract_map_set ((GeeAbstractMap*) results, _tmp74_, (gpointer) ((gintptr) (SYNAPSE_MATCH_SCORE_AVERAGE + SYNAPSE_MATCH_SCORE_INCREMENT_MINOR)));
#line 220 "../../../src/core/query.vala"
					_g_regex_unref0 (_tmp70_);
#line 1457 "query.c"
				}
				goto __finally5;
				__catch5_g_regex_error:
				{
#line 220 "../../../src/core/query.vala"
					g_clear_error (&_inner_error0_);
#line 1464 "query.c"
				}
				__finally5:
#line 220 "../../../src/core/query.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 220 "../../../src/core/query.vala"
					_g_free0 (any_order);
#line 220 "../../../src/core/query.vala"
					_g_free0 (orred);
#line 220 "../../../src/core/query.vala"
					_g_free0 (pattern);
#line 220 "../../../src/core/query.vala"
					escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
#line 220 "../../../src/core/query.vala"
					individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 220 "../../../src/core/query.vala"
					_g_regex_unref0 (re);
#line 220 "../../../src/core/query.vala"
					_g_free0 (escaped_query);
#line 220 "../../../src/core/query.vala"
					_g_free0 (stripped_query);
#line 220 "../../../src/core/query.vala"
					_g_object_unref0 (results);
#line 220 "../../../src/core/query.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 220 "../../../src/core/query.vala"
					g_clear_error (&_inner_error0_);
#line 220 "../../../src/core/query.vala"
					return NULL;
#line 1493 "query.c"
				}
#line 194 "../../../src/core/query.vala"
				_g_free0 (any_order);
#line 194 "../../../src/core/query.vala"
				_g_free0 (orred);
#line 1499 "query.c"
			}
		}
#line 172 "../../../src/core/query.vala"
		_g_free0 (pattern);
#line 172 "../../../src/core/query.vala"
		escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
#line 1506 "query.c"
	}
#line 232 "../../../src/core/query.vala"
	if (!((match_flags & SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING) == SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING)) {
#line 1510 "query.c"
		{
			GRegex* _tmp75_ = NULL;
			gchar* _tmp76_;
			gchar* _tmp77_;
			GRegex* _tmp78_;
			GRegex* _tmp79_;
			GRegex* _tmp80_;
			GRegex* _tmp81_;
#line 236 "../../../src/core/query.vala"
			_tmp76_ = g_strdup_printf ("(%s)", escaped_query);
#line 236 "../../../src/core/query.vala"
			_tmp77_ = _tmp76_;
#line 236 "../../../src/core/query.vala"
			_tmp78_ = g_regex_new (_tmp77_, flags, 0, &_inner_error0_);
#line 236 "../../../src/core/query.vala"
			_tmp79_ = _tmp78_;
#line 236 "../../../src/core/query.vala"
			_g_free0 (_tmp77_);
#line 236 "../../../src/core/query.vala"
			_tmp75_ = _tmp79_;
#line 236 "../../../src/core/query.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 236 "../../../src/core/query.vala"
				if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1535 "query.c"
					goto __catch6_g_regex_error;
				}
#line 236 "../../../src/core/query.vala"
				individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 236 "../../../src/core/query.vala"
				_g_regex_unref0 (re);
#line 236 "../../../src/core/query.vala"
				_g_free0 (escaped_query);
#line 236 "../../../src/core/query.vala"
				_g_free0 (stripped_query);
#line 236 "../../../src/core/query.vala"
				_g_object_unref0 (results);
#line 236 "../../../src/core/query.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 236 "../../../src/core/query.vala"
				g_clear_error (&_inner_error0_);
#line 236 "../../../src/core/query.vala"
				return NULL;
#line 1554 "query.c"
			}
#line 236 "../../../src/core/query.vala"
			_tmp80_ = _tmp75_;
#line 236 "../../../src/core/query.vala"
			_tmp75_ = NULL;
#line 236 "../../../src/core/query.vala"
			_g_regex_unref0 (re);
#line 236 "../../../src/core/query.vala"
			re = _tmp80_;
#line 237 "../../../src/core/query.vala"
			_tmp81_ = re;
#line 237 "../../../src/core/query.vala"
			gee_abstract_map_set ((GeeAbstractMap*) results, _tmp81_, (gpointer) ((gintptr) SYNAPSE_MATCH_SCORE_BELOW_AVERAGE));
#line 234 "../../../src/core/query.vala"
			_g_regex_unref0 (_tmp75_);
#line 1570 "query.c"
		}
		goto __finally6;
		__catch6_g_regex_error:
		{
#line 234 "../../../src/core/query.vala"
			g_clear_error (&_inner_error0_);
#line 1577 "query.c"
		}
		__finally6:
#line 234 "../../../src/core/query.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 234 "../../../src/core/query.vala"
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 234 "../../../src/core/query.vala"
			_g_regex_unref0 (re);
#line 234 "../../../src/core/query.vala"
			_g_free0 (escaped_query);
#line 234 "../../../src/core/query.vala"
			_g_free0 (stripped_query);
#line 234 "../../../src/core/query.vala"
			_g_object_unref0 (results);
#line 234 "../../../src/core/query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 234 "../../../src/core/query.vala"
			g_clear_error (&_inner_error0_);
#line 234 "../../../src/core/query.vala"
			return NULL;
#line 1598 "query.c"
		}
	}
#line 245 "../../../src/core/query.vala"
	_tmp83_ = _tmp82_ = g_regex_split_simple ("\\s*", query, 0, 0);
#line 245 "../../../src/core/query.vala"
	individual_chars = _tmp83_;
#line 245 "../../../src/core/query.vala"
	individual_chars_length1 = _vala_array_length (_tmp82_);
#line 245 "../../../src/core/query.vala"
	_individual_chars_size_ = individual_chars_length1;
#line 246 "../../../src/core/query.vala"
	_tmp84_ = g_new0 (gchar*, 0 + 1);
#line 246 "../../../src/core/query.vala"
	escaped_chars = _tmp84_;
#line 246 "../../../src/core/query.vala"
	escaped_chars_length1 = 0;
#line 246 "../../../src/core/query.vala"
	_escaped_chars_size_ = escaped_chars_length1;
#line 247 "../../../src/core/query.vala"
	_tmp85_ = individual_chars;
#line 247 "../../../src/core/query.vala"
	_tmp85__length1 = individual_chars_length1;
#line 1621 "query.c"
	{
		gchar** word_collection = NULL;
		gint word_collection_length1 = 0;
		gint _word_collection_size_ = 0;
		gint word_it = 0;
#line 247 "../../../src/core/query.vala"
		word_collection = _tmp85_;
#line 247 "../../../src/core/query.vala"
		word_collection_length1 = _tmp85__length1;
#line 247 "../../../src/core/query.vala"
		for (word_it = 0; word_it < word_collection_length1; word_it = word_it + 1) {
#line 1633 "query.c"
			const gchar* word = NULL;
#line 247 "../../../src/core/query.vala"
			word = word_collection[word_it];
#line 1637 "query.c"
			{
				const gchar* _tmp86_;
				gchar* _tmp87_;
#line 249 "../../../src/core/query.vala"
				_tmp86_ = word;
#line 249 "../../../src/core/query.vala"
				_tmp87_ = g_regex_escape_string (_tmp86_, -1);
#line 249 "../../../src/core/query.vala"
				_vala_array_add7 (&escaped_chars, &escaped_chars_length1, &_escaped_chars_size_, _tmp87_);
#line 1647 "query.c"
			}
		}
	}
#line 253 "../../../src/core/query.vala"
	if (!((match_flags & SYNAPSE_MATCHER_FLAGS_NO_PARTIAL) == SYNAPSE_MATCHER_FLAGS_NO_PARTIAL)) {
#line 1653 "query.c"
		gchar** _tmp90_;
		gint _tmp90__length1;
#line 254 "../../../src/core/query.vala"
		_tmp90_ = individual_words;
#line 254 "../../../src/core/query.vala"
		_tmp90__length1 = individual_words_length1;
#line 254 "../../../src/core/query.vala"
		_tmp89_ = _tmp90__length1 == 1;
#line 1662 "query.c"
	} else {
#line 253 "../../../src/core/query.vala"
		_tmp89_ = FALSE;
#line 1666 "query.c"
	}
#line 253 "../../../src/core/query.vala"
	if (_tmp89_) {
#line 1670 "query.c"
		gchar** _tmp91_;
		gint _tmp91__length1;
#line 254 "../../../src/core/query.vala"
		_tmp91_ = individual_chars;
#line 254 "../../../src/core/query.vala"
		_tmp91__length1 = individual_chars_length1;
#line 254 "../../../src/core/query.vala"
		_tmp88_ = _tmp91__length1 <= 5;
#line 1679 "query.c"
	} else {
#line 253 "../../../src/core/query.vala"
		_tmp88_ = FALSE;
#line 1683 "query.c"
	}
#line 253 "../../../src/core/query.vala"
	if (_tmp88_) {
#line 1687 "query.c"
		gchar* pattern = NULL;
		gchar** _tmp92_;
		gint _tmp92__length1;
		gchar* _tmp93_;
		gchar* _tmp94_;
		gchar* _tmp95_;
		gchar* _tmp96_;
#line 256 "../../../src/core/query.vala"
		_tmp92_ = escaped_chars;
#line 256 "../../../src/core/query.vala"
		_tmp92__length1 = escaped_chars_length1;
#line 256 "../../../src/core/query.vala"
		_tmp93_ = _vala_g_strjoinv (").+\\b(", _tmp92_, (gint) _tmp92__length1);
#line 256 "../../../src/core/query.vala"
		_tmp94_ = _tmp93_;
#line 256 "../../../src/core/query.vala"
		_tmp95_ = g_strdup_printf ("\\b(%s)", _tmp94_);
#line 256 "../../../src/core/query.vala"
		_tmp96_ = _tmp95_;
#line 256 "../../../src/core/query.vala"
		_g_free0 (_tmp94_);
#line 256 "../../../src/core/query.vala"
		pattern = _tmp96_;
#line 1711 "query.c"
		{
			GRegex* _tmp97_ = NULL;
			const gchar* _tmp98_;
			GRegex* _tmp99_;
			GRegex* _tmp100_;
			GRegex* _tmp101_;
#line 260 "../../../src/core/query.vala"
			_tmp98_ = pattern;
#line 260 "../../../src/core/query.vala"
			_tmp99_ = g_regex_new (_tmp98_, flags, 0, &_inner_error0_);
#line 260 "../../../src/core/query.vala"
			_tmp97_ = _tmp99_;
#line 260 "../../../src/core/query.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 260 "../../../src/core/query.vala"
				if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1728 "query.c"
					goto __catch7_g_regex_error;
				}
#line 260 "../../../src/core/query.vala"
				_g_free0 (pattern);
#line 260 "../../../src/core/query.vala"
				escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
#line 260 "../../../src/core/query.vala"
				individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
#line 260 "../../../src/core/query.vala"
				individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 260 "../../../src/core/query.vala"
				_g_regex_unref0 (re);
#line 260 "../../../src/core/query.vala"
				_g_free0 (escaped_query);
#line 260 "../../../src/core/query.vala"
				_g_free0 (stripped_query);
#line 260 "../../../src/core/query.vala"
				_g_object_unref0 (results);
#line 260 "../../../src/core/query.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 260 "../../../src/core/query.vala"
				g_clear_error (&_inner_error0_);
#line 260 "../../../src/core/query.vala"
				return NULL;
#line 1753 "query.c"
			}
#line 260 "../../../src/core/query.vala"
			_tmp100_ = _tmp97_;
#line 260 "../../../src/core/query.vala"
			_tmp97_ = NULL;
#line 260 "../../../src/core/query.vala"
			_g_regex_unref0 (re);
#line 260 "../../../src/core/query.vala"
			re = _tmp100_;
#line 261 "../../../src/core/query.vala"
			_tmp101_ = re;
#line 261 "../../../src/core/query.vala"
			gee_abstract_map_set ((GeeAbstractMap*) results, _tmp101_, (gpointer) ((gintptr) SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE));
#line 258 "../../../src/core/query.vala"
			_g_regex_unref0 (_tmp97_);
#line 1769 "query.c"
		}
		goto __finally7;
		__catch7_g_regex_error:
		{
#line 258 "../../../src/core/query.vala"
			g_clear_error (&_inner_error0_);
#line 1776 "query.c"
		}
		__finally7:
#line 258 "../../../src/core/query.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 258 "../../../src/core/query.vala"
			_g_free0 (pattern);
#line 258 "../../../src/core/query.vala"
			escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
#line 258 "../../../src/core/query.vala"
			individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
#line 258 "../../../src/core/query.vala"
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 258 "../../../src/core/query.vala"
			_g_regex_unref0 (re);
#line 258 "../../../src/core/query.vala"
			_g_free0 (escaped_query);
#line 258 "../../../src/core/query.vala"
			_g_free0 (stripped_query);
#line 258 "../../../src/core/query.vala"
			_g_object_unref0 (results);
#line 258 "../../../src/core/query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 258 "../../../src/core/query.vala"
			g_clear_error (&_inner_error0_);
#line 258 "../../../src/core/query.vala"
			return NULL;
#line 1803 "query.c"
		}
#line 253 "../../../src/core/query.vala"
		_g_free0 (pattern);
#line 1807 "query.c"
	}
#line 268 "../../../src/core/query.vala"
	if (!((match_flags & SYNAPSE_MATCHER_FLAGS_NO_FUZZY) == SYNAPSE_MATCHER_FLAGS_NO_FUZZY)) {
#line 1811 "query.c"
		gchar** _tmp103_;
		gint _tmp103__length1;
#line 268 "../../../src/core/query.vala"
		_tmp103_ = escaped_chars;
#line 268 "../../../src/core/query.vala"
		_tmp103__length1 = escaped_chars_length1;
#line 268 "../../../src/core/query.vala"
		_tmp102_ = _tmp103__length1 > 0;
#line 1820 "query.c"
	} else {
#line 268 "../../../src/core/query.vala"
		_tmp102_ = FALSE;
#line 1824 "query.c"
	}
#line 268 "../../../src/core/query.vala"
	if (_tmp102_) {
#line 1828 "query.c"
		gchar* pattern = NULL;
		gchar** _tmp104_;
		gint _tmp104__length1;
		gchar* _tmp105_;
		gchar* _tmp106_;
		gchar* _tmp107_;
		gchar* _tmp108_;
#line 270 "../../../src/core/query.vala"
		_tmp104_ = escaped_chars;
#line 270 "../../../src/core/query.vala"
		_tmp104__length1 = escaped_chars_length1;
#line 270 "../../../src/core/query.vala"
		_tmp105_ = _vala_g_strjoinv (").*(", _tmp104_, (gint) _tmp104__length1);
#line 270 "../../../src/core/query.vala"
		_tmp106_ = _tmp105_;
#line 270 "../../../src/core/query.vala"
		_tmp107_ = g_strdup_printf ("\\b(%s)", _tmp106_);
#line 270 "../../../src/core/query.vala"
		_tmp108_ = _tmp107_;
#line 270 "../../../src/core/query.vala"
		_g_free0 (_tmp106_);
#line 270 "../../../src/core/query.vala"
		pattern = _tmp108_;
#line 1852 "query.c"
		{
			GRegex* _tmp109_ = NULL;
			const gchar* _tmp110_;
			GRegex* _tmp111_;
			GRegex* _tmp112_;
			GRegex* _tmp113_;
#line 274 "../../../src/core/query.vala"
			_tmp110_ = pattern;
#line 274 "../../../src/core/query.vala"
			_tmp111_ = g_regex_new (_tmp110_, flags, 0, &_inner_error0_);
#line 274 "../../../src/core/query.vala"
			_tmp109_ = _tmp111_;
#line 274 "../../../src/core/query.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 274 "../../../src/core/query.vala"
				if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1869 "query.c"
					goto __catch8_g_regex_error;
				}
#line 274 "../../../src/core/query.vala"
				_g_free0 (pattern);
#line 274 "../../../src/core/query.vala"
				escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
#line 274 "../../../src/core/query.vala"
				individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
#line 274 "../../../src/core/query.vala"
				individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 274 "../../../src/core/query.vala"
				_g_regex_unref0 (re);
#line 274 "../../../src/core/query.vala"
				_g_free0 (escaped_query);
#line 274 "../../../src/core/query.vala"
				_g_free0 (stripped_query);
#line 274 "../../../src/core/query.vala"
				_g_object_unref0 (results);
#line 274 "../../../src/core/query.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 274 "../../../src/core/query.vala"
				g_clear_error (&_inner_error0_);
#line 274 "../../../src/core/query.vala"
				return NULL;
#line 1894 "query.c"
			}
#line 274 "../../../src/core/query.vala"
			_tmp112_ = _tmp109_;
#line 274 "../../../src/core/query.vala"
			_tmp109_ = NULL;
#line 274 "../../../src/core/query.vala"
			_g_regex_unref0 (re);
#line 274 "../../../src/core/query.vala"
			re = _tmp112_;
#line 275 "../../../src/core/query.vala"
			_tmp113_ = re;
#line 275 "../../../src/core/query.vala"
			gee_abstract_map_set ((GeeAbstractMap*) results, _tmp113_, (gpointer) ((gintptr) SYNAPSE_MATCH_SCORE_POOR));
#line 272 "../../../src/core/query.vala"
			_g_regex_unref0 (_tmp109_);
#line 1910 "query.c"
		}
		goto __finally8;
		__catch8_g_regex_error:
		{
#line 272 "../../../src/core/query.vala"
			g_clear_error (&_inner_error0_);
#line 1917 "query.c"
		}
		__finally8:
#line 272 "../../../src/core/query.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 272 "../../../src/core/query.vala"
			_g_free0 (pattern);
#line 272 "../../../src/core/query.vala"
			escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
#line 272 "../../../src/core/query.vala"
			individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
#line 272 "../../../src/core/query.vala"
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 272 "../../../src/core/query.vala"
			_g_regex_unref0 (re);
#line 272 "../../../src/core/query.vala"
			_g_free0 (escaped_query);
#line 272 "../../../src/core/query.vala"
			_g_free0 (stripped_query);
#line 272 "../../../src/core/query.vala"
			_g_object_unref0 (results);
#line 272 "../../../src/core/query.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 272 "../../../src/core/query.vala"
			g_clear_error (&_inner_error0_);
#line 272 "../../../src/core/query.vala"
			return NULL;
#line 1944 "query.c"
		}
#line 268 "../../../src/core/query.vala"
		_g_free0 (pattern);
#line 1948 "query.c"
	}
#line 282 "../../../src/core/query.vala"
	_tmp114_ = gee_array_list_new (GEE_MAP_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 282 "../../../src/core/query.vala"
	sorted_results = _tmp114_;
#line 283 "../../../src/core/query.vala"
	_tmp115_ = gee_abstract_map_get_entries ((GeeAbstractMap*) results);
#line 283 "../../../src/core/query.vala"
	_tmp116_ = _tmp115_;
#line 283 "../../../src/core/query.vala"
	entries = _tmp116_;
#line 285 "../../../src/core/query.vala"
	_tmp117_ = _g_object_ref0 (entries);
#line 285 "../../../src/core/query.vala"
	g_object_set_data_full ((GObject*) sorted_results, "entries-ref", _tmp117_, g_object_unref);
#line 286 "../../../src/core/query.vala"
	gee_array_list_add_all (sorted_results, (GeeCollection*) entries);
#line 287 "../../../src/core/query.vala"
	gee_list_sort ((GeeList*) sorted_results, ___lambda5__gcompare_data_func, NULL, NULL);
#line 293 "../../../src/core/query.vala"
	result = (GeeList*) sorted_results;
#line 293 "../../../src/core/query.vala"
	_g_object_unref0 (entries);
#line 293 "../../../src/core/query.vala"
	escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
#line 293 "../../../src/core/query.vala"
	individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
#line 293 "../../../src/core/query.vala"
	individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
#line 293 "../../../src/core/query.vala"
	_g_regex_unref0 (re);
#line 293 "../../../src/core/query.vala"
	_g_free0 (escaped_query);
#line 293 "../../../src/core/query.vala"
	_g_free0 (stripped_query);
#line 293 "../../../src/core/query.vala"
	_g_object_unref0 (results);
#line 293 "../../../src/core/query.vala"
	return result;
#line 1988 "query.c"
}

void
synapse_query_copy (const SynapseQuery* self,
                    SynapseQuery* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GCancellable* _tmp4_;
	GCancellable* _tmp5_;
	SynapseQueryFlags _tmp6_;
#line 86 "../../../src/core/query.vala"
	_tmp0_ = (*self).query_string;
#line 86 "../../../src/core/query.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 86 "../../../src/core/query.vala"
	_g_free0 ((*dest).query_string);
#line 86 "../../../src/core/query.vala"
	(*dest).query_string = _tmp1_;
#line 86 "../../../src/core/query.vala"
	_tmp2_ = (*self).query_string_folded;
#line 86 "../../../src/core/query.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 86 "../../../src/core/query.vala"
	_g_free0 ((*dest).query_string_folded);
#line 86 "../../../src/core/query.vala"
	(*dest).query_string_folded = _tmp3_;
#line 86 "../../../src/core/query.vala"
	_tmp4_ = (*self).cancellable;
#line 86 "../../../src/core/query.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 86 "../../../src/core/query.vala"
	_g_object_unref0 ((*dest).cancellable);
#line 86 "../../../src/core/query.vala"
	(*dest).cancellable = _tmp5_;
#line 86 "../../../src/core/query.vala"
	_tmp6_ = (*self).query_type;
#line 86 "../../../src/core/query.vala"
	(*dest).query_type = _tmp6_;
#line 86 "../../../src/core/query.vala"
	(*dest).max_results = (*self).max_results;
#line 86 "../../../src/core/query.vala"
	(*dest).query_id = (*self).query_id;
#line 2034 "query.c"
}

void
synapse_query_destroy (SynapseQuery* self)
{
#line 88 "../../../src/core/query.vala"
	_g_free0 ((*self).query_string);
#line 89 "../../../src/core/query.vala"
	_g_free0 ((*self).query_string_folded);
#line 90 "../../../src/core/query.vala"
	_g_object_unref0 ((*self).cancellable);
#line 2046 "query.c"
}

SynapseQuery*
synapse_query_dup (const SynapseQuery* self)
{
	SynapseQuery* dup;
#line 86 "../../../src/core/query.vala"
	dup = g_new0 (SynapseQuery, 1);
#line 86 "../../../src/core/query.vala"
	synapse_query_copy (self, dup);
#line 86 "../../../src/core/query.vala"
	return dup;
#line 2059 "query.c"
}

void
synapse_query_free (SynapseQuery* self)
{
#line 86 "../../../src/core/query.vala"
	synapse_query_destroy (self);
#line 86 "../../../src/core/query.vala"
	g_free (self);
#line 2069 "query.c"
}

static GType
synapse_query_get_type_once (void)
{
	GType synapse_query_type_id;
	synapse_query_type_id = g_boxed_type_register_static ("SynapseQuery", (GBoxedCopyFunc) synapse_query_dup, (GBoxedFreeFunc) synapse_query_free);
	return synapse_query_type_id;
}

GType
synapse_query_get_type (void)
{
	static volatile gsize synapse_query_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_query_type_id__volatile)) {
		GType synapse_query_type_id;
		synapse_query_type_id = synapse_query_get_type_once ();
		g_once_init_leave (&synapse_query_type_id__volatile, synapse_query_type_id);
	}
	return synapse_query_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 239 "../../../src/core/data-sink.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 2099 "query.c"
		gint i;
#line 239 "../../../src/core/data-sink.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 239 "../../../src/core/data-sink.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 239 "../../../src/core/data-sink.vala"
				destroy_func (((gpointer*) array)[i]);
#line 2107 "query.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 239 "../../../src/core/data-sink.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 239 "../../../src/core/data-sink.vala"
	g_free (array);
#line 2122 "query.c"
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
#line 239 "../../../src/core/data-sink.vala"
	if (array) {
#line 239 "../../../src/core/data-sink.vala"
		while (((gpointer*) array)[length]) {
#line 239 "../../../src/core/data-sink.vala"
			length++;
#line 2136 "query.c"
		}
	}
#line 239 "../../../src/core/data-sink.vala"
	return length;
#line 2141 "query.c"
}

