/* relevancy-backend-zg.c generated by valac 0.48.17, the Vala compiler
 * generated from relevancy-backend-zg.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <zeitgeist.h>
#include <gee.h>
#include <zeitgeist-datamodel.h>
#include <gio/gdesktopappinfo.h>

#define SYNAPSE_TYPE_RELEVANCY_BACKEND (synapse_relevancy_backend_get_type ())
#define SYNAPSE_RELEVANCY_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RELEVANCY_BACKEND, SynapseRelevancyBackend))
#define SYNAPSE_IS_RELEVANCY_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RELEVANCY_BACKEND))
#define SYNAPSE_RELEVANCY_BACKEND_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_RELEVANCY_BACKEND, SynapseRelevancyBackendIface))

typedef struct _SynapseRelevancyBackend SynapseRelevancyBackend;
typedef struct _SynapseRelevancyBackendIface SynapseRelevancyBackendIface;

#define SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND (synapse_zeitgeist_relevancy_backend_get_type ())
#define SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND, SynapseZeitgeistRelevancyBackend))
#define SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND, SynapseZeitgeistRelevancyBackendClass))
#define SYNAPSE_IS_ZEITGEIST_RELEVANCY_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND))
#define SYNAPSE_IS_ZEITGEIST_RELEVANCY_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND))
#define SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND, SynapseZeitgeistRelevancyBackendClass))

typedef struct _SynapseZeitgeistRelevancyBackend SynapseZeitgeistRelevancyBackend;
typedef struct _SynapseZeitgeistRelevancyBackendClass SynapseZeitgeistRelevancyBackendClass;
typedef struct _SynapseZeitgeistRelevancyBackendPrivate SynapseZeitgeistRelevancyBackendPrivate;
enum  {
	SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_0_PROPERTY,
	SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_NUM_PROPERTIES
};
static GParamSpec* synapse_zeitgeist_relevancy_backend_properties[SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseZeitgeistRelevancyBackendCheckDataSourcesData SynapseZeitgeistRelevancyBackendCheckDataSourcesData;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData;
typedef struct _SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SynapseRelevancyBackendIface {
	GTypeInterface parent_iface;
	gfloat (*get_application_popularity) (SynapseRelevancyBackend* self, const gchar* desktop_id);
	gfloat (*get_uri_popularity) (SynapseRelevancyBackend* self, const gchar* uri);
	void (*application_launched) (SynapseRelevancyBackend* self, GAppInfo* app_info);
};

struct _SynapseZeitgeistRelevancyBackend {
	GObject parent_instance;
	SynapseZeitgeistRelevancyBackendPrivate * priv;
};

struct _SynapseZeitgeistRelevancyBackendClass {
	GObjectClass parent_class;
};

struct _SynapseZeitgeistRelevancyBackendPrivate {
	ZeitgeistLog* zg_log;
	ZeitgeistDataSourceRegistry* zg_dsr;
	GeeMap* application_popularity;
	GeeMap* uri_popularity;
	gboolean has_datahub_gio_module;
};

struct _SynapseZeitgeistRelevancyBackendCheckDataSourcesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseZeitgeistRelevancyBackend* self;
	ZeitgeistDataSourceRegistry* _tmp0_;
	GPtrArray* array;
	ZeitgeistDataSourceRegistry* _tmp1_;
	GPtrArray* _tmp2_;
	GError* err;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GError* _inner_error0_;
};

struct _SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseZeitgeistRelevancyBackend* self;
	gint64 end;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gint64 _tmp2_;
	gint64 start;
	ZeitgeistTimeRange* tr;
	ZeitgeistTimeRange* _tmp3_;
	ZeitgeistEvent* event;
	ZeitgeistEvent* _tmp4_;
	ZeitgeistEvent* _tmp5_;
	ZeitgeistSubject* subject;
	ZeitgeistSubject* _tmp6_;
	ZeitgeistSubject* _tmp7_;
	ZeitgeistSubject* _tmp8_;
	ZeitgeistEvent* _tmp9_;
	ZeitgeistSubject* _tmp10_;
	GPtrArray* array;
	GPtrArray* _tmp11_;
	GPtrArray* _tmp12_;
	ZeitgeistEvent* _tmp13_;
	ZeitgeistEvent* _tmp14_;
	ZeitgeistResultSet* rs;
	ZeitgeistResultSet* _tmp15_;
	ZeitgeistLog* _tmp16_;
	ZeitgeistTimeRange* _tmp17_;
	GPtrArray* _tmp18_;
	ZeitgeistResultSet* _tmp19_;
	ZeitgeistResultSet* _tmp20_;
	GeeMap* _tmp21_;
	guint size;
	ZeitgeistResultSet* _tmp22_;
	guint index;
	ZeitgeistResultSet* _e_it;
	ZeitgeistResultSet* _tmp23_;
	ZeitgeistResultSet* _tmp24_;
	ZeitgeistEvent* e;
	ZeitgeistResultSet* _tmp25_;
	ZeitgeistEvent* _tmp26_;
	ZeitgeistEvent* _tmp27_;
	ZeitgeistEvent* _tmp28_;
	ZeitgeistSubject* s;
	ZeitgeistEvent* _tmp29_;
	GPtrArray* _tmp30_;
	GPtrArray* _tmp31_;
	gconstpointer _tmp32_;
	ZeitgeistSubject* _tmp33_;
	gfloat power;
	gfloat relevancy;
	GeeMap* _tmp34_;
	ZeitgeistSubject* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	guint _tmp38_;
	GError* err;
	GError* _tmp39_;
	const gchar* _tmp40_;
	GError* _inner_error0_;
};

struct _SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseZeitgeistRelevancyBackend* self;
	gint64 end;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gint64 _tmp2_;
	gint64 start;
	ZeitgeistTimeRange* tr;
	ZeitgeistTimeRange* _tmp3_;
	ZeitgeistEvent* event;
	ZeitgeistEvent* _tmp4_;
	ZeitgeistEvent* _tmp5_;
	ZeitgeistSubject* subject;
	ZeitgeistSubject* _tmp6_;
	ZeitgeistSubject* _tmp7_;
	ZeitgeistSubject* _tmp8_;
	ZeitgeistEvent* _tmp9_;
	ZeitgeistSubject* _tmp10_;
	GPtrArray* array;
	GPtrArray* _tmp11_;
	GPtrArray* _tmp12_;
	ZeitgeistEvent* _tmp13_;
	ZeitgeistEvent* _tmp14_;
	ZeitgeistResultSet* rs;
	GeeMap* popularity_map;
	GeeHashMap* _tmp15_;
	guint size;
	guint index;
	gfloat power;
	gfloat relevancy;
	ZeitgeistResultSet* _tmp16_;
	ZeitgeistLog* _tmp17_;
	ZeitgeistTimeRange* _tmp18_;
	GPtrArray* _tmp19_;
	ZeitgeistResultSet* _tmp20_;
	ZeitgeistResultSet* _tmp21_;
	ZeitgeistResultSet* _tmp22_;
	ZeitgeistResultSet* _e1_it;
	ZeitgeistResultSet* _tmp23_;
	ZeitgeistResultSet* _tmp24_;
	ZeitgeistEvent* e1;
	ZeitgeistResultSet* _tmp25_;
	ZeitgeistEvent* _tmp26_;
	ZeitgeistEvent* _tmp27_;
	ZeitgeistEvent* _tmp28_;
	ZeitgeistSubject* s1;
	ZeitgeistEvent* _tmp29_;
	GPtrArray* _tmp30_;
	GPtrArray* _tmp31_;
	gconstpointer _tmp32_;
	ZeitgeistSubject* _tmp33_;
	GeeMap* _tmp34_;
	ZeitgeistSubject* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	guint _tmp38_;
	ZeitgeistSubject* _tmp39_;
	ZeitgeistSubject* _tmp40_;
	GPtrArray* _tmp41_;
	GPtrArray* _tmp42_;
	ZeitgeistEvent* _tmp43_;
	ZeitgeistEvent* _tmp44_;
	ZeitgeistResultSet* _tmp45_;
	ZeitgeistLog* _tmp46_;
	ZeitgeistTimeRange* _tmp47_;
	GPtrArray* _tmp48_;
	ZeitgeistResultSet* _tmp49_;
	ZeitgeistResultSet* _tmp50_;
	ZeitgeistResultSet* _tmp51_;
	ZeitgeistResultSet* _e2_it;
	ZeitgeistResultSet* _tmp52_;
	ZeitgeistResultSet* _tmp53_;
	ZeitgeistEvent* e2;
	ZeitgeistResultSet* _tmp54_;
	ZeitgeistEvent* _tmp55_;
	ZeitgeistEvent* _tmp56_;
	ZeitgeistEvent* _tmp57_;
	ZeitgeistSubject* s2;
	ZeitgeistEvent* _tmp58_;
	GPtrArray* _tmp59_;
	GPtrArray* _tmp60_;
	gconstpointer _tmp61_;
	ZeitgeistSubject* _tmp62_;
	GeeMap* _tmp63_;
	ZeitgeistSubject* _tmp64_;
	const gchar* _tmp65_;
	const gchar* _tmp66_;
	guint _tmp67_;
	GError* err;
	GError* _tmp68_;
	const gchar* _tmp69_;
	GeeMap* _tmp70_;
	GeeMap* _tmp71_;
	GError* _inner_error0_;
};

static gint SynapseZeitgeistRelevancyBackend_private_offset;
static gpointer synapse_zeitgeist_relevancy_backend_parent_class = NULL;
static SynapseRelevancyBackendIface * synapse_zeitgeist_relevancy_backend_synapse_relevancy_backend_parent_iface = NULL;

GType synapse_relevancy_backend_get_type (void) G_GNUC_CONST;
GType synapse_zeitgeist_relevancy_backend_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseZeitgeistRelevancyBackend, g_object_unref)
#define SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER 65535.0f
static void synapse_zeitgeist_relevancy_backend_check_data_sources_data_free (gpointer _data);
static void synapse_zeitgeist_relevancy_backend_check_data_sources (SynapseZeitgeistRelevancyBackend* self,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static void synapse_zeitgeist_relevancy_backend_check_data_sources_finish (SynapseZeitgeistRelevancyBackend* self,
                                                                    GAsyncResult* _res_);
static gboolean synapse_zeitgeist_relevancy_backend_check_data_sources_co (SynapseZeitgeistRelevancyBackendCheckDataSourcesData* _data_);
static void synapse_zeitgeist_relevancy_backend_check_data_sources_ready (GObject* source_object,
                                                                   GAsyncResult* _res_,
                                                                   gpointer _user_data_);
static void ___lambda6_ (SynapseZeitgeistRelevancyBackend* self,
                  ZeitgeistDataSource* ds);
static void ____lambda6__gfunc (gconstpointer data,
                         gpointer self);
static gboolean synapse_zeitgeist_relevancy_backend_refresh_popularity (SynapseZeitgeistRelevancyBackend* self);
static void synapse_zeitgeist_relevancy_backend_load_application_relevancies (SynapseZeitgeistRelevancyBackend* self,
                                                                       GAsyncReadyCallback _callback_,
                                                                       gpointer _user_data_);
static void synapse_zeitgeist_relevancy_backend_load_application_relevancies_finish (SynapseZeitgeistRelevancyBackend* self,
                                                                              GAsyncResult* _res_);
static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies (SynapseZeitgeistRelevancyBackend* self,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_);
static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies_finish (SynapseZeitgeistRelevancyBackend* self,
                                                                      GAsyncResult* _res_);
static void synapse_zeitgeist_relevancy_backend_load_application_relevancies_data_free (gpointer _data);
static gboolean synapse_zeitgeist_relevancy_backend_load_application_relevancies_co (SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* _data_);
static gboolean _synapse_zeitgeist_relevancy_backend_load_application_relevancies_co_gsource_func (gpointer self);
static void _g_object_unref0_ (gpointer var);
static void synapse_zeitgeist_relevancy_backend_load_application_relevancies_ready (GObject* source_object,
                                                                             GAsyncResult* _res_,
                                                                             gpointer _user_data_);
static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies_data_free (gpointer _data);
static gboolean synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co (SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* _data_);
static gboolean _synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co_gsource_func (gpointer self);
static void synapse_zeitgeist_relevancy_backend_load_uri_relevancies_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_);
static gfloat synapse_zeitgeist_relevancy_backend_real_get_application_popularity (SynapseRelevancyBackend* base,
                                                                            const gchar* desktop_id);
static gfloat synapse_zeitgeist_relevancy_backend_real_get_uri_popularity (SynapseRelevancyBackend* base,
                                                                    const gchar* uri);
static void synapse_zeitgeist_relevancy_backend_reload_relevancies (SynapseZeitgeistRelevancyBackend* self);
static gboolean __lambda7_ (SynapseZeitgeistRelevancyBackend* self);
static gboolean ___lambda7__gsource_func (gpointer self);
static void synapse_zeitgeist_relevancy_backend_real_application_launched (SynapseRelevancyBackend* base,
                                                                    GAppInfo* app_info);
static void synapse_zeitgeist_relevancy_backend_push_app_launch (SynapseZeitgeistRelevancyBackend* self,
                                                          const gchar* app_uri,
                                                          const gchar* display_name);
SynapseZeitgeistRelevancyBackend* synapse_zeitgeist_relevancy_backend_new (void);
SynapseZeitgeistRelevancyBackend* synapse_zeitgeist_relevancy_backend_construct (GType object_type);
static GObject * synapse_zeitgeist_relevancy_backend_constructor (GType type,
                                                           guint n_construct_properties,
                                                           GObjectConstructParam * construct_properties);
static gboolean _synapse_zeitgeist_relevancy_backend_refresh_popularity_gsource_func (gpointer self);
gfloat synapse_relevancy_backend_get_application_popularity (SynapseRelevancyBackend* self,
                                                             const gchar* desktop_id);
gfloat synapse_relevancy_backend_get_uri_popularity (SynapseRelevancyBackend* self,
                                                     const gchar* uri);
void synapse_relevancy_backend_application_launched (SynapseRelevancyBackend* self,
                                                     GAppInfo* app_info);
static void synapse_zeitgeist_relevancy_backend_finalize (GObject * obj);
static GType synapse_zeitgeist_relevancy_backend_get_type_once (void);

static inline gpointer
synapse_zeitgeist_relevancy_backend_get_instance_private (SynapseZeitgeistRelevancyBackend* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseZeitgeistRelevancyBackend_private_offset);
}

static void
synapse_zeitgeist_relevancy_backend_check_data_sources_data_free (gpointer _data)
{
	SynapseZeitgeistRelevancyBackendCheckDataSourcesData* _data_;
	_data_ = _data;
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	_g_object_unref0 (_data_->self);
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	g_slice_free (SynapseZeitgeistRelevancyBackendCheckDataSourcesData, _data_);
#line 362 "relevancy-backend-zg.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	return self ? g_object_ref (self) : NULL;
#line 370 "relevancy-backend-zg.c"
}

static void
synapse_zeitgeist_relevancy_backend_check_data_sources (SynapseZeitgeistRelevancyBackend* self,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	SynapseZeitgeistRelevancyBackendCheckDataSourcesData* _data_;
	SynapseZeitgeistRelevancyBackend* _tmp0_;
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	_data_ = g_slice_new0 (SynapseZeitgeistRelevancyBackendCheckDataSourcesData);
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_zeitgeist_relevancy_backend_check_data_sources_data_free);
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	_data_->self = _tmp0_;
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	synapse_zeitgeist_relevancy_backend_check_data_sources_co (_data_);
#line 392 "relevancy-backend-zg.c"
}

static void
synapse_zeitgeist_relevancy_backend_check_data_sources_finish (SynapseZeitgeistRelevancyBackend* self,
                                                               GAsyncResult* _res_)
{
	SynapseZeitgeistRelevancyBackendCheckDataSourcesData* _data_;
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 402 "relevancy-backend-zg.c"
}

static void
synapse_zeitgeist_relevancy_backend_check_data_sources_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_)
{
	SynapseZeitgeistRelevancyBackendCheckDataSourcesData* _data_;
#line 50 "../../../src/core/relevancy-backend-zg.vala"
	_data_ = _user_data_;
#line 50 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_source_object_ = source_object;
#line 50 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_res_ = _res_;
#line 50 "../../../src/core/relevancy-backend-zg.vala"
	synapse_zeitgeist_relevancy_backend_check_data_sources_co (_data_);
#line 419 "relevancy-backend-zg.c"
}

static void
___lambda6_ (SynapseZeitgeistRelevancyBackend* self,
             ZeitgeistDataSource* ds)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
#line 52 "../../../src/core/relevancy-backend-zg.vala"
	g_return_if_fail (ds != NULL);
#line 53 "../../../src/core/relevancy-backend-zg.vala"
	_tmp1_ = zeitgeist_data_source_get_unique_id (ds);
#line 53 "../../../src/core/relevancy-backend-zg.vala"
	_tmp2_ = _tmp1_;
#line 53 "../../../src/core/relevancy-backend-zg.vala"
	if (g_strcmp0 (_tmp2_, "com.zeitgeist-project,datahub,gio-launch-listener") == 0) {
#line 437 "relevancy-backend-zg.c"
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 54 "../../../src/core/relevancy-backend-zg.vala"
		_tmp3_ = zeitgeist_data_source_get_enabled (ds);
#line 54 "../../../src/core/relevancy-backend-zg.vala"
		_tmp4_ = _tmp3_;
#line 54 "../../../src/core/relevancy-backend-zg.vala"
		_tmp0_ = _tmp4_;
#line 446 "relevancy-backend-zg.c"
	} else {
#line 53 "../../../src/core/relevancy-backend-zg.vala"
		_tmp0_ = FALSE;
#line 450 "relevancy-backend-zg.c"
	}
#line 53 "../../../src/core/relevancy-backend-zg.vala"
	if (_tmp0_) {
#line 56 "../../../src/core/relevancy-backend-zg.vala"
		self->priv->has_datahub_gio_module = TRUE;
#line 57 "../../../src/core/relevancy-backend-zg.vala"
		return;
#line 458 "relevancy-backend-zg.c"
	}
}

static void
____lambda6__gfunc (gconstpointer data,
                    gpointer self)
{
#line 52 "../../../src/core/relevancy-backend-zg.vala"
	___lambda6_ ((SynapseZeitgeistRelevancyBackend*) self, (ZeitgeistDataSource*) data);
#line 468 "relevancy-backend-zg.c"
}

static gboolean
synapse_zeitgeist_relevancy_backend_check_data_sources_co (SynapseZeitgeistRelevancyBackendCheckDataSourcesData* _data_)
{
#line 45 "../../../src/core/relevancy-backend-zg.vala"
	switch (_data_->_state_) {
#line 45 "../../../src/core/relevancy-backend-zg.vala"
		case 0:
#line 478 "relevancy-backend-zg.c"
		goto _state_0;
#line 45 "../../../src/core/relevancy-backend-zg.vala"
		case 1:
#line 482 "relevancy-backend-zg.c"
		goto _state_1;
		default:
#line 45 "../../../src/core/relevancy-backend-zg.vala"
		g_assert_not_reached ();
#line 487 "relevancy-backend-zg.c"
	}
	_state_0:
#line 47 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp0_ = zeitgeist_data_source_registry_new ();
#line 47 "../../../src/core/relevancy-backend-zg.vala"
	_g_object_unref0 (_data_->self->priv->zg_dsr);
#line 47 "../../../src/core/relevancy-backend-zg.vala"
	_data_->self->priv->zg_dsr = _data_->_tmp0_;
#line 496 "relevancy-backend-zg.c"
	{
#line 50 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp1_ = _data_->self->priv->zg_dsr;
#line 50 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_state_ = 1;
#line 50 "../../../src/core/relevancy-backend-zg.vala"
		zeitgeist_data_source_registry_get_data_sources (_data_->_tmp1_, NULL, synapse_zeitgeist_relevancy_backend_check_data_sources_ready, _data_);
#line 50 "../../../src/core/relevancy-backend-zg.vala"
		return FALSE;
#line 506 "relevancy-backend-zg.c"
		_state_1:
#line 50 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp2_ = zeitgeist_data_source_registry_get_data_sources_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
#line 50 "../../../src/core/relevancy-backend-zg.vala"
		_data_->array = _data_->_tmp2_;
#line 50 "../../../src/core/relevancy-backend-zg.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 514 "relevancy-backend-zg.c"
			goto __catch0_g_error;
		}
#line 52 "../../../src/core/relevancy-backend-zg.vala"
		g_ptr_array_foreach (_data_->array, ____lambda6__gfunc, _data_->self);
#line 48 "../../../src/core/relevancy-backend-zg.vala"
		_g_ptr_array_unref0 (_data_->array);
#line 521 "relevancy-backend-zg.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 48 "../../../src/core/relevancy-backend-zg.vala"
		_data_->err = _data_->_inner_error0_;
#line 48 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_inner_error0_ = NULL;
#line 63 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp3_ = _data_->err;
#line 63 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp4_ = _data_->_tmp3_->message;
#line 63 "../../../src/core/relevancy-backend-zg.vala"
		g_warning ("relevancy-backend-zg.vala:63: Unable to check Zeitgeist data sources: " \
"%s", _data_->_tmp4_);
#line 48 "../../../src/core/relevancy-backend-zg.vala"
		_g_error_free0 (_data_->err);
#line 538 "relevancy-backend-zg.c"
	}
	__finally0:
#line 48 "../../../src/core/relevancy-backend-zg.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 48 "../../../src/core/relevancy-backend-zg.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 48 "../../../src/core/relevancy-backend-zg.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 48 "../../../src/core/relevancy-backend-zg.vala"
		g_object_unref (_data_->_async_result);
#line 48 "../../../src/core/relevancy-backend-zg.vala"
		return FALSE;
#line 551 "relevancy-backend-zg.c"
	}
#line 45 "../../../src/core/relevancy-backend-zg.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 45 "../../../src/core/relevancy-backend-zg.vala"
	if (_data_->_state_ != 0) {
#line 45 "../../../src/core/relevancy-backend-zg.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 45 "../../../src/core/relevancy-backend-zg.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 561 "relevancy-backend-zg.c"
		}
	}
#line 45 "../../../src/core/relevancy-backend-zg.vala"
	g_object_unref (_data_->_async_result);
#line 45 "../../../src/core/relevancy-backend-zg.vala"
	return FALSE;
#line 568 "relevancy-backend-zg.c"
}

static gboolean
synapse_zeitgeist_relevancy_backend_refresh_popularity (SynapseZeitgeistRelevancyBackend* self)
{
	gboolean result = FALSE;
#line 67 "../../../src/core/relevancy-backend-zg.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 69 "../../../src/core/relevancy-backend-zg.vala"
	synapse_zeitgeist_relevancy_backend_load_application_relevancies (self, NULL, NULL);
#line 70 "../../../src/core/relevancy-backend-zg.vala"
	synapse_zeitgeist_relevancy_backend_load_uri_relevancies (self, NULL, NULL);
#line 71 "../../../src/core/relevancy-backend-zg.vala"
	result = TRUE;
#line 71 "../../../src/core/relevancy-backend-zg.vala"
	return result;
#line 585 "relevancy-backend-zg.c"
}

static void
synapse_zeitgeist_relevancy_backend_load_application_relevancies_data_free (gpointer _data)
{
	SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* _data_;
	_data_ = _data;
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	_g_object_unref0 (_data_->self);
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	g_slice_free (SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData, _data_);
#line 597 "relevancy-backend-zg.c"
}

static void
synapse_zeitgeist_relevancy_backend_load_application_relevancies (SynapseZeitgeistRelevancyBackend* self,
                                                                  GAsyncReadyCallback _callback_,
                                                                  gpointer _user_data_)
{
	SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* _data_;
	SynapseZeitgeistRelevancyBackend* _tmp0_;
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	_data_ = g_slice_new0 (SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData);
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_zeitgeist_relevancy_backend_load_application_relevancies_data_free);
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	_data_->self = _tmp0_;
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	synapse_zeitgeist_relevancy_backend_load_application_relevancies_co (_data_);
#line 619 "relevancy-backend-zg.c"
}

static void
synapse_zeitgeist_relevancy_backend_load_application_relevancies_finish (SynapseZeitgeistRelevancyBackend* self,
                                                                         GAsyncResult* _res_)
{
	SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* _data_;
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 629 "relevancy-backend-zg.c"
}

static gboolean
_synapse_zeitgeist_relevancy_backend_load_application_relevancies_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_zeitgeist_relevancy_backend_load_application_relevancies_co (self);
#line 76 "../../../src/core/relevancy-backend-zg.vala"
	return result;
#line 639 "relevancy-backend-zg.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 90 "../../../src/core/relevancy-backend-zg.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 647 "relevancy-backend-zg.c"
}

static void
synapse_zeitgeist_relevancy_backend_load_application_relevancies_ready (GObject* source_object,
                                                                        GAsyncResult* _res_,
                                                                        gpointer _user_data_)
{
	SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* _data_;
#line 97 "../../../src/core/relevancy-backend-zg.vala"
	_data_ = _user_data_;
#line 97 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_source_object_ = source_object;
#line 97 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_res_ = _res_;
#line 97 "../../../src/core/relevancy-backend-zg.vala"
	synapse_zeitgeist_relevancy_backend_load_application_relevancies_co (_data_);
#line 664 "relevancy-backend-zg.c"
}

static gboolean
synapse_zeitgeist_relevancy_backend_load_application_relevancies_co (SynapseZeitgeistRelevancyBackendLoadApplicationRelevanciesData* _data_)
{
#line 74 "../../../src/core/relevancy-backend-zg.vala"
	switch (_data_->_state_) {
#line 74 "../../../src/core/relevancy-backend-zg.vala"
		case 0:
#line 674 "relevancy-backend-zg.c"
		goto _state_0;
#line 74 "../../../src/core/relevancy-backend-zg.vala"
		case 1:
#line 678 "relevancy-backend-zg.c"
		goto _state_1;
#line 74 "../../../src/core/relevancy-backend-zg.vala"
		case 2:
#line 682 "relevancy-backend-zg.c"
		goto _state_2;
		default:
#line 74 "../../../src/core/relevancy-backend-zg.vala"
		g_assert_not_reached ();
#line 687 "relevancy-backend-zg.c"
	}
	_state_0:
#line 76 "../../../src/core/relevancy-backend-zg.vala"
	g_idle_add_full (G_PRIORITY_LOW, _synapse_zeitgeist_relevancy_backend_load_application_relevancies_co_gsource_func, _data_, NULL);
#line 77 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_state_ = 1;
#line 77 "../../../src/core/relevancy-backend-zg.vala"
	return FALSE;
#line 696 "relevancy-backend-zg.c"
	_state_1:
	;
#line 79 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp0_ = g_date_time_new_now_local ();
#line 79 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp1_ = _data_->_tmp0_;
#line 79 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp2_ = g_date_time_to_unix (_data_->_tmp1_) * 1000;
#line 79 "../../../src/core/relevancy-backend-zg.vala"
	_g_date_time_unref0 (_data_->_tmp1_);
#line 79 "../../../src/core/relevancy-backend-zg.vala"
	_data_->end = _data_->_tmp2_;
#line 80 "../../../src/core/relevancy-backend-zg.vala"
	_data_->start = _data_->end - (ZEITGEIST_TIMESTAMP_WEEK * 4);
#line 81 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp3_ = zeitgeist_time_range_new (_data_->start, _data_->end);
#line 81 "../../../src/core/relevancy-backend-zg.vala"
	_data_->tr = _data_->_tmp3_;
#line 83 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp4_ = zeitgeist_event_new ();
#line 83 "../../../src/core/relevancy-backend-zg.vala"
	_data_->event = _data_->_tmp4_;
#line 84 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp5_ = _data_->event;
#line 84 "../../../src/core/relevancy-backend-zg.vala"
	zeitgeist_event_set_interpretation (_data_->_tmp5_, "!" ZEITGEIST_ZG_LEAVE_EVENT);
#line 85 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp6_ = zeitgeist_subject_new ();
#line 85 "../../../src/core/relevancy-backend-zg.vala"
	_data_->subject = _data_->_tmp6_;
#line 86 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp7_ = _data_->subject;
#line 86 "../../../src/core/relevancy-backend-zg.vala"
	zeitgeist_subject_set_interpretation (_data_->_tmp7_, ZEITGEIST_NFO_SOFTWARE);
#line 87 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp8_ = _data_->subject;
#line 87 "../../../src/core/relevancy-backend-zg.vala"
	zeitgeist_subject_set_uri (_data_->_tmp8_, "application://*");
#line 88 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp9_ = _data_->event;
#line 88 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp10_ = _data_->subject;
#line 88 "../../../src/core/relevancy-backend-zg.vala"
	zeitgeist_event_add_subject (_data_->_tmp9_, _data_->_tmp10_);
#line 90 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp11_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
#line 90 "../../../src/core/relevancy-backend-zg.vala"
	_data_->array = _data_->_tmp11_;
#line 91 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp12_ = _data_->array;
#line 91 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp13_ = _data_->event;
#line 91 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp14_ = _g_object_ref0 (_data_->_tmp13_);
#line 91 "../../../src/core/relevancy-backend-zg.vala"
	g_ptr_array_add (_data_->_tmp12_, _data_->_tmp14_);
#line 753 "relevancy-backend-zg.c"
	{
#line 97 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp16_ = _data_->self->priv->zg_log;
#line 97 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp17_ = _data_->tr;
#line 97 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp18_ = _data_->array;
#line 97 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_state_ = 2;
#line 97 "../../../src/core/relevancy-backend-zg.vala"
		zeitgeist_log_find_events (_data_->_tmp16_, _data_->_tmp17_, _data_->_tmp18_, ZEITGEIST_STORAGE_STATE_ANY, (guint32) 256, ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS, NULL, synapse_zeitgeist_relevancy_backend_load_application_relevancies_ready, _data_);
#line 97 "../../../src/core/relevancy-backend-zg.vala"
		return FALSE;
#line 767 "relevancy-backend-zg.c"
		_state_2:
#line 97 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp19_ = zeitgeist_log_find_events_finish (_data_->_tmp16_, _data_->_res_, &_data_->_inner_error0_);
#line 97 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp15_ = _data_->_tmp19_;
#line 97 "../../../src/core/relevancy-backend-zg.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 775 "relevancy-backend-zg.c"
			goto __catch0_g_error;
		}
#line 97 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp20_ = _data_->_tmp15_;
#line 97 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp15_ = NULL;
#line 97 "../../../src/core/relevancy-backend-zg.vala"
		_g_object_unref0 (_data_->rs);
#line 97 "../../../src/core/relevancy-backend-zg.vala"
		_data_->rs = _data_->_tmp20_;
#line 103 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp21_ = _data_->self->priv->application_popularity;
#line 103 "../../../src/core/relevancy-backend-zg.vala"
		gee_map_clear (_data_->_tmp21_);
#line 104 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp22_ = _data_->rs;
#line 104 "../../../src/core/relevancy-backend-zg.vala"
		_data_->size = zeitgeist_result_set_size (_data_->_tmp22_);
#line 105 "../../../src/core/relevancy-backend-zg.vala"
		_data_->index = (guint) 0;
#line 796 "relevancy-backend-zg.c"
		{
#line 109 "../../../src/core/relevancy-backend-zg.vala"
			_data_->_tmp23_ = _data_->rs;
#line 109 "../../../src/core/relevancy-backend-zg.vala"
			_data_->_tmp24_ = zeitgeist_result_set_iterator (_data_->_tmp23_);
#line 109 "../../../src/core/relevancy-backend-zg.vala"
			_data_->_e_it = _data_->_tmp24_;
#line 109 "../../../src/core/relevancy-backend-zg.vala"
			while (TRUE) {
#line 109 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp25_ = _data_->_e_it;
#line 109 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp26_ = zeitgeist_result_set_next_value (_data_->_tmp25_);
#line 109 "../../../src/core/relevancy-backend-zg.vala"
				_g_object_unref0 (_data_->e);
#line 109 "../../../src/core/relevancy-backend-zg.vala"
				_data_->e = _data_->_tmp26_;
#line 109 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp27_ = _data_->e;
#line 109 "../../../src/core/relevancy-backend-zg.vala"
				if (!(_data_->_tmp27_ != NULL)) {
#line 109 "../../../src/core/relevancy-backend-zg.vala"
					break;
#line 820 "relevancy-backend-zg.c"
				}
#line 111 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp28_ = _data_->e;
#line 111 "../../../src/core/relevancy-backend-zg.vala"
				if (zeitgeist_event_num_subjects (_data_->_tmp28_) <= 0) {
#line 111 "../../../src/core/relevancy-backend-zg.vala"
					continue;
#line 828 "relevancy-backend-zg.c"
				}
#line 112 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp29_ = _data_->e;
#line 112 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp30_ = zeitgeist_event_get_subjects (_data_->_tmp29_);
#line 112 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp31_ = _data_->_tmp30_;
#line 112 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp32_ = g_ptr_array_index (_data_->_tmp31_, (guint) 0);
#line 112 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp33_ = _g_object_ref0 ((ZeitgeistSubject*) _data_->_tmp32_);
#line 112 "../../../src/core/relevancy-backend-zg.vala"
				_data_->s = _data_->_tmp33_;
#line 114 "../../../src/core/relevancy-backend-zg.vala"
				_data_->power = (_data_->index / (_data_->size * 2)) + 0.5f;
#line 115 "../../../src/core/relevancy-backend-zg.vala"
				_data_->relevancy = 1.0f / powf ((gfloat) (_data_->index + 1), _data_->power);
#line 116 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp34_ = _data_->self->priv->application_popularity;
#line 116 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp35_ = _data_->s;
#line 116 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp36_ = zeitgeist_subject_get_uri (_data_->_tmp35_);
#line 116 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp37_ = _data_->_tmp36_;
#line 116 "../../../src/core/relevancy-backend-zg.vala"
				gee_map_set (_data_->_tmp34_, _data_->_tmp37_, (gpointer) ((gintptr) (_data_->relevancy * SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER)));
#line 118 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp38_ = _data_->index;
#line 118 "../../../src/core/relevancy-backend-zg.vala"
				_data_->index = _data_->_tmp38_ + 1;
#line 109 "../../../src/core/relevancy-backend-zg.vala"
				_g_object_unref0 (_data_->s);
#line 862 "relevancy-backend-zg.c"
			}
#line 109 "../../../src/core/relevancy-backend-zg.vala"
			_g_object_unref0 (_data_->e);
#line 109 "../../../src/core/relevancy-backend-zg.vala"
			_g_object_unref0 (_data_->_e_it);
#line 868 "relevancy-backend-zg.c"
		}
#line 95 "../../../src/core/relevancy-backend-zg.vala"
		_g_object_unref0 (_data_->_tmp15_);
#line 872 "relevancy-backend-zg.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 95 "../../../src/core/relevancy-backend-zg.vala"
		_data_->err = _data_->_inner_error0_;
#line 95 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_inner_error0_ = NULL;
#line 123 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp39_ = _data_->err;
#line 123 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp40_ = _data_->_tmp39_->message;
#line 123 "../../../src/core/relevancy-backend-zg.vala"
		g_warning ("relevancy-backend-zg.vala:123: %s", _data_->_tmp40_);
#line 124 "../../../src/core/relevancy-backend-zg.vala"
		_g_error_free0 (_data_->err);
#line 124 "../../../src/core/relevancy-backend-zg.vala"
		_g_object_unref0 (_data_->rs);
#line 124 "../../../src/core/relevancy-backend-zg.vala"
		_g_ptr_array_unref0 (_data_->array);
#line 124 "../../../src/core/relevancy-backend-zg.vala"
		_g_object_unref0 (_data_->subject);
#line 124 "../../../src/core/relevancy-backend-zg.vala"
		_g_object_unref0 (_data_->event);
#line 124 "../../../src/core/relevancy-backend-zg.vala"
		_g_object_unref0 (_data_->tr);
#line 124 "../../../src/core/relevancy-backend-zg.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 124 "../../../src/core/relevancy-backend-zg.vala"
		if (_data_->_state_ != 0) {
#line 124 "../../../src/core/relevancy-backend-zg.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 124 "../../../src/core/relevancy-backend-zg.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 907 "relevancy-backend-zg.c"
			}
		}
#line 124 "../../../src/core/relevancy-backend-zg.vala"
		g_object_unref (_data_->_async_result);
#line 124 "../../../src/core/relevancy-backend-zg.vala"
		return FALSE;
#line 914 "relevancy-backend-zg.c"
	}
	__finally0:
#line 95 "../../../src/core/relevancy-backend-zg.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 95 "../../../src/core/relevancy-backend-zg.vala"
		_g_object_unref0 (_data_->rs);
#line 95 "../../../src/core/relevancy-backend-zg.vala"
		_g_ptr_array_unref0 (_data_->array);
#line 95 "../../../src/core/relevancy-backend-zg.vala"
		_g_object_unref0 (_data_->subject);
#line 95 "../../../src/core/relevancy-backend-zg.vala"
		_g_object_unref0 (_data_->event);
#line 95 "../../../src/core/relevancy-backend-zg.vala"
		_g_object_unref0 (_data_->tr);
#line 95 "../../../src/core/relevancy-backend-zg.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 95 "../../../src/core/relevancy-backend-zg.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 95 "../../../src/core/relevancy-backend-zg.vala"
		g_object_unref (_data_->_async_result);
#line 95 "../../../src/core/relevancy-backend-zg.vala"
		return FALSE;
#line 937 "relevancy-backend-zg.c"
	}
#line 74 "../../../src/core/relevancy-backend-zg.vala"
	_g_object_unref0 (_data_->rs);
#line 74 "../../../src/core/relevancy-backend-zg.vala"
	_g_ptr_array_unref0 (_data_->array);
#line 74 "../../../src/core/relevancy-backend-zg.vala"
	_g_object_unref0 (_data_->subject);
#line 74 "../../../src/core/relevancy-backend-zg.vala"
	_g_object_unref0 (_data_->event);
#line 74 "../../../src/core/relevancy-backend-zg.vala"
	_g_object_unref0 (_data_->tr);
#line 74 "../../../src/core/relevancy-backend-zg.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 74 "../../../src/core/relevancy-backend-zg.vala"
	if (_data_->_state_ != 0) {
#line 74 "../../../src/core/relevancy-backend-zg.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 74 "../../../src/core/relevancy-backend-zg.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 957 "relevancy-backend-zg.c"
		}
	}
#line 74 "../../../src/core/relevancy-backend-zg.vala"
	g_object_unref (_data_->_async_result);
#line 74 "../../../src/core/relevancy-backend-zg.vala"
	return FALSE;
#line 964 "relevancy-backend-zg.c"
}

static void
synapse_zeitgeist_relevancy_backend_load_uri_relevancies_data_free (gpointer _data)
{
	SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* _data_;
	_data_ = _data;
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	_g_object_unref0 (_data_->self);
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	g_slice_free (SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData, _data_);
#line 976 "relevancy-backend-zg.c"
}

static void
synapse_zeitgeist_relevancy_backend_load_uri_relevancies (SynapseZeitgeistRelevancyBackend* self,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_)
{
	SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* _data_;
	SynapseZeitgeistRelevancyBackend* _tmp0_;
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	_data_ = g_slice_new0 (SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData);
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_zeitgeist_relevancy_backend_load_uri_relevancies_data_free);
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	_data_->self = _tmp0_;
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co (_data_);
#line 998 "relevancy-backend-zg.c"
}

static void
synapse_zeitgeist_relevancy_backend_load_uri_relevancies_finish (SynapseZeitgeistRelevancyBackend* self,
                                                                 GAsyncResult* _res_)
{
	SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* _data_;
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 1008 "relevancy-backend-zg.c"
}

static gboolean
_synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co (self);
#line 130 "../../../src/core/relevancy-backend-zg.vala"
	return result;
#line 1018 "relevancy-backend-zg.c"
}

static void
synapse_zeitgeist_relevancy_backend_load_uri_relevancies_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_)
{
	SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* _data_;
#line 155 "../../../src/core/relevancy-backend-zg.vala"
	_data_ = _user_data_;
#line 155 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_source_object_ = source_object;
#line 155 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_res_ = _res_;
#line 155 "../../../src/core/relevancy-backend-zg.vala"
	synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co (_data_);
#line 1035 "relevancy-backend-zg.c"
}

static gboolean
synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co (SynapseZeitgeistRelevancyBackendLoadUriRelevanciesData* _data_)
{
#line 128 "../../../src/core/relevancy-backend-zg.vala"
	switch (_data_->_state_) {
#line 128 "../../../src/core/relevancy-backend-zg.vala"
		case 0:
#line 1045 "relevancy-backend-zg.c"
		goto _state_0;
#line 128 "../../../src/core/relevancy-backend-zg.vala"
		case 1:
#line 1049 "relevancy-backend-zg.c"
		goto _state_1;
#line 128 "../../../src/core/relevancy-backend-zg.vala"
		case 2:
#line 1053 "relevancy-backend-zg.c"
		goto _state_2;
#line 128 "../../../src/core/relevancy-backend-zg.vala"
		case 3:
#line 1057 "relevancy-backend-zg.c"
		goto _state_3;
		default:
#line 128 "../../../src/core/relevancy-backend-zg.vala"
		g_assert_not_reached ();
#line 1062 "relevancy-backend-zg.c"
	}
	_state_0:
#line 130 "../../../src/core/relevancy-backend-zg.vala"
	g_idle_add_full (G_PRIORITY_LOW, _synapse_zeitgeist_relevancy_backend_load_uri_relevancies_co_gsource_func, _data_, NULL);
#line 131 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_state_ = 1;
#line 131 "../../../src/core/relevancy-backend-zg.vala"
	return FALSE;
#line 1071 "relevancy-backend-zg.c"
	_state_1:
	;
#line 133 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp0_ = g_date_time_new_now_local ();
#line 133 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp1_ = _data_->_tmp0_;
#line 133 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp2_ = g_date_time_to_unix (_data_->_tmp1_) * 1000;
#line 133 "../../../src/core/relevancy-backend-zg.vala"
	_g_date_time_unref0 (_data_->_tmp1_);
#line 133 "../../../src/core/relevancy-backend-zg.vala"
	_data_->end = _data_->_tmp2_;
#line 134 "../../../src/core/relevancy-backend-zg.vala"
	_data_->start = _data_->end - (ZEITGEIST_TIMESTAMP_WEEK * 4);
#line 135 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp3_ = zeitgeist_time_range_new (_data_->start, _data_->end);
#line 135 "../../../src/core/relevancy-backend-zg.vala"
	_data_->tr = _data_->_tmp3_;
#line 137 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp4_ = zeitgeist_event_new ();
#line 137 "../../../src/core/relevancy-backend-zg.vala"
	_data_->event = _data_->_tmp4_;
#line 138 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp5_ = _data_->event;
#line 138 "../../../src/core/relevancy-backend-zg.vala"
	zeitgeist_event_set_interpretation (_data_->_tmp5_, "!" ZEITGEIST_ZG_LEAVE_EVENT);
#line 139 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp6_ = zeitgeist_subject_new ();
#line 139 "../../../src/core/relevancy-backend-zg.vala"
	_data_->subject = _data_->_tmp6_;
#line 140 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp7_ = _data_->subject;
#line 140 "../../../src/core/relevancy-backend-zg.vala"
	zeitgeist_subject_set_interpretation (_data_->_tmp7_, "!" ZEITGEIST_NFO_SOFTWARE);
#line 141 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp8_ = _data_->subject;
#line 141 "../../../src/core/relevancy-backend-zg.vala"
	zeitgeist_subject_set_uri (_data_->_tmp8_, "file://*");
#line 142 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp9_ = _data_->event;
#line 142 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp10_ = _data_->subject;
#line 142 "../../../src/core/relevancy-backend-zg.vala"
	zeitgeist_event_add_subject (_data_->_tmp9_, _data_->_tmp10_);
#line 144 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp11_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
#line 144 "../../../src/core/relevancy-backend-zg.vala"
	_data_->array = _data_->_tmp11_;
#line 145 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp12_ = _data_->array;
#line 145 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp13_ = _data_->event;
#line 145 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp14_ = _g_object_ref0 (_data_->_tmp13_);
#line 145 "../../../src/core/relevancy-backend-zg.vala"
	g_ptr_array_add (_data_->_tmp12_, _data_->_tmp14_);
#line 148 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp15_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 148 "../../../src/core/relevancy-backend-zg.vala"
	_data_->popularity_map = (GeeMap*) _data_->_tmp15_;
#line 1132 "relevancy-backend-zg.c"
	{
#line 155 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp17_ = _data_->self->priv->zg_log;
#line 155 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp18_ = _data_->tr;
#line 155 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp19_ = _data_->array;
#line 155 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_state_ = 2;
#line 155 "../../../src/core/relevancy-backend-zg.vala"
		zeitgeist_log_find_events (_data_->_tmp17_, _data_->_tmp18_, _data_->_tmp19_, ZEITGEIST_STORAGE_STATE_ANY, (guint32) 256, ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS, NULL, synapse_zeitgeist_relevancy_backend_load_uri_relevancies_ready, _data_);
#line 155 "../../../src/core/relevancy-backend-zg.vala"
		return FALSE;
#line 1146 "relevancy-backend-zg.c"
		_state_2:
#line 155 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp20_ = zeitgeist_log_find_events_finish (_data_->_tmp17_, _data_->_res_, &_data_->_inner_error0_);
#line 155 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp16_ = _data_->_tmp20_;
#line 155 "../../../src/core/relevancy-backend-zg.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 1154 "relevancy-backend-zg.c"
			goto __catch0_g_error;
		}
#line 155 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp21_ = _data_->_tmp16_;
#line 155 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp16_ = NULL;
#line 155 "../../../src/core/relevancy-backend-zg.vala"
		_g_object_unref0 (_data_->rs);
#line 155 "../../../src/core/relevancy-backend-zg.vala"
		_data_->rs = _data_->_tmp21_;
#line 161 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp22_ = _data_->rs;
#line 161 "../../../src/core/relevancy-backend-zg.vala"
		_data_->size = zeitgeist_result_set_size (_data_->_tmp22_);
#line 162 "../../../src/core/relevancy-backend-zg.vala"
		_data_->index = (guint) 0;
#line 1171 "relevancy-backend-zg.c"
		{
#line 166 "../../../src/core/relevancy-backend-zg.vala"
			_data_->_tmp23_ = _data_->rs;
#line 166 "../../../src/core/relevancy-backend-zg.vala"
			_data_->_tmp24_ = zeitgeist_result_set_iterator (_data_->_tmp23_);
#line 166 "../../../src/core/relevancy-backend-zg.vala"
			_data_->_e1_it = _data_->_tmp24_;
#line 166 "../../../src/core/relevancy-backend-zg.vala"
			while (TRUE) {
#line 166 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp25_ = _data_->_e1_it;
#line 166 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp26_ = zeitgeist_result_set_next_value (_data_->_tmp25_);
#line 166 "../../../src/core/relevancy-backend-zg.vala"
				_g_object_unref0 (_data_->e1);
#line 166 "../../../src/core/relevancy-backend-zg.vala"
				_data_->e1 = _data_->_tmp26_;
#line 166 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp27_ = _data_->e1;
#line 166 "../../../src/core/relevancy-backend-zg.vala"
				if (!(_data_->_tmp27_ != NULL)) {
#line 166 "../../../src/core/relevancy-backend-zg.vala"
					break;
#line 1195 "relevancy-backend-zg.c"
				}
#line 168 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp28_ = _data_->e1;
#line 168 "../../../src/core/relevancy-backend-zg.vala"
				if (zeitgeist_event_num_subjects (_data_->_tmp28_) <= 0) {
#line 168 "../../../src/core/relevancy-backend-zg.vala"
					continue;
#line 1203 "relevancy-backend-zg.c"
				}
#line 169 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp29_ = _data_->e1;
#line 169 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp30_ = zeitgeist_event_get_subjects (_data_->_tmp29_);
#line 169 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp31_ = _data_->_tmp30_;
#line 169 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp32_ = g_ptr_array_index (_data_->_tmp31_, (guint) 0);
#line 169 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp33_ = _g_object_ref0 ((ZeitgeistSubject*) _data_->_tmp32_);
#line 169 "../../../src/core/relevancy-backend-zg.vala"
				_data_->s1 = _data_->_tmp33_;
#line 171 "../../../src/core/relevancy-backend-zg.vala"
				_data_->power = (_data_->index / (_data_->size * 2)) + 0.5f;
#line 172 "../../../src/core/relevancy-backend-zg.vala"
				_data_->relevancy = 1.0f / powf ((gfloat) (_data_->index + 1), _data_->power);
#line 173 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp34_ = _data_->popularity_map;
#line 173 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp35_ = _data_->s1;
#line 173 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp36_ = zeitgeist_subject_get_uri (_data_->_tmp35_);
#line 173 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp37_ = _data_->_tmp36_;
#line 173 "../../../src/core/relevancy-backend-zg.vala"
				gee_map_set (_data_->_tmp34_, _data_->_tmp37_, (gpointer) ((gintptr) (_data_->relevancy * SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER)));
#line 175 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp38_ = _data_->index;
#line 175 "../../../src/core/relevancy-backend-zg.vala"
				_data_->index = _data_->_tmp38_ + 1;
#line 166 "../../../src/core/relevancy-backend-zg.vala"
				_g_object_unref0 (_data_->s1);
#line 1237 "relevancy-backend-zg.c"
			}
#line 166 "../../../src/core/relevancy-backend-zg.vala"
			_g_object_unref0 (_data_->e1);
#line 166 "../../../src/core/relevancy-backend-zg.vala"
			_g_object_unref0 (_data_->_e1_it);
#line 1243 "relevancy-backend-zg.c"
		}
#line 179 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp39_ = _data_->subject;
#line 179 "../../../src/core/relevancy-backend-zg.vala"
		zeitgeist_subject_set_interpretation (_data_->_tmp39_, ZEITGEIST_NFO_WEBSITE);
#line 180 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp40_ = _data_->subject;
#line 180 "../../../src/core/relevancy-backend-zg.vala"
		zeitgeist_subject_set_uri (_data_->_tmp40_, "");
#line 181 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp41_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
#line 181 "../../../src/core/relevancy-backend-zg.vala"
		_g_ptr_array_unref0 (_data_->array);
#line 181 "../../../src/core/relevancy-backend-zg.vala"
		_data_->array = _data_->_tmp41_;
#line 182 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp42_ = _data_->array;
#line 182 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp43_ = _data_->event;
#line 182 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp44_ = _g_object_ref0 (_data_->_tmp43_);
#line 182 "../../../src/core/relevancy-backend-zg.vala"
		g_ptr_array_add (_data_->_tmp42_, _data_->_tmp44_);
#line 184 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp46_ = _data_->self->priv->zg_log;
#line 184 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp47_ = _data_->tr;
#line 184 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp48_ = _data_->array;
#line 184 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_state_ = 3;
#line 184 "../../../src/core/relevancy-backend-zg.vala"
		zeitgeist_log_find_events (_data_->_tmp46_, _data_->_tmp47_, _data_->_tmp48_, ZEITGEIST_STORAGE_STATE_ANY, (guint32) 128, ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS, NULL, synapse_zeitgeist_relevancy_backend_load_uri_relevancies_ready, _data_);
#line 184 "../../../src/core/relevancy-backend-zg.vala"
		return FALSE;
#line 1279 "relevancy-backend-zg.c"
		_state_3:
#line 184 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp49_ = zeitgeist_log_find_events_finish (_data_->_tmp46_, _data_->_res_, &_data_->_inner_error0_);
#line 184 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp45_ = _data_->_tmp49_;
#line 184 "../../../src/core/relevancy-backend-zg.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 184 "../../../src/core/relevancy-backend-zg.vala"
			_g_object_unref0 (_data_->_tmp16_);
#line 1289 "relevancy-backend-zg.c"
			goto __catch0_g_error;
		}
#line 184 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp50_ = _data_->_tmp45_;
#line 184 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp45_ = NULL;
#line 184 "../../../src/core/relevancy-backend-zg.vala"
		_g_object_unref0 (_data_->rs);
#line 184 "../../../src/core/relevancy-backend-zg.vala"
		_data_->rs = _data_->_tmp50_;
#line 190 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp51_ = _data_->rs;
#line 190 "../../../src/core/relevancy-backend-zg.vala"
		_data_->size = zeitgeist_result_set_size (_data_->_tmp51_);
#line 191 "../../../src/core/relevancy-backend-zg.vala"
		_data_->index = (guint) 0;
#line 1306 "relevancy-backend-zg.c"
		{
#line 195 "../../../src/core/relevancy-backend-zg.vala"
			_data_->_tmp52_ = _data_->rs;
#line 195 "../../../src/core/relevancy-backend-zg.vala"
			_data_->_tmp53_ = zeitgeist_result_set_iterator (_data_->_tmp52_);
#line 195 "../../../src/core/relevancy-backend-zg.vala"
			_data_->_e2_it = _data_->_tmp53_;
#line 195 "../../../src/core/relevancy-backend-zg.vala"
			while (TRUE) {
#line 195 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp54_ = _data_->_e2_it;
#line 195 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp55_ = zeitgeist_result_set_next_value (_data_->_tmp54_);
#line 195 "../../../src/core/relevancy-backend-zg.vala"
				_g_object_unref0 (_data_->e2);
#line 195 "../../../src/core/relevancy-backend-zg.vala"
				_data_->e2 = _data_->_tmp55_;
#line 195 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp56_ = _data_->e2;
#line 195 "../../../src/core/relevancy-backend-zg.vala"
				if (!(_data_->_tmp56_ != NULL)) {
#line 195 "../../../src/core/relevancy-backend-zg.vala"
					break;
#line 1330 "relevancy-backend-zg.c"
				}
#line 197 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp57_ = _data_->e2;
#line 197 "../../../src/core/relevancy-backend-zg.vala"
				if (zeitgeist_event_num_subjects (_data_->_tmp57_) <= 0) {
#line 197 "../../../src/core/relevancy-backend-zg.vala"
					continue;
#line 1338 "relevancy-backend-zg.c"
				}
#line 198 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp58_ = _data_->e2;
#line 198 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp59_ = zeitgeist_event_get_subjects (_data_->_tmp58_);
#line 198 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp60_ = _data_->_tmp59_;
#line 198 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp61_ = g_ptr_array_index (_data_->_tmp60_, (guint) 0);
#line 198 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp62_ = _g_object_ref0 ((ZeitgeistSubject*) _data_->_tmp61_);
#line 198 "../../../src/core/relevancy-backend-zg.vala"
				_data_->s2 = _data_->_tmp62_;
#line 200 "../../../src/core/relevancy-backend-zg.vala"
				_data_->power = (_data_->index / (_data_->size * 2)) + 0.5f;
#line 201 "../../../src/core/relevancy-backend-zg.vala"
				_data_->relevancy = 1.0f / powf ((gfloat) (_data_->index + 1), _data_->power);
#line 202 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp63_ = _data_->popularity_map;
#line 202 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp64_ = _data_->s2;
#line 202 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp65_ = zeitgeist_subject_get_uri (_data_->_tmp64_);
#line 202 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp66_ = _data_->_tmp65_;
#line 202 "../../../src/core/relevancy-backend-zg.vala"
				gee_map_set (_data_->_tmp63_, _data_->_tmp66_, (gpointer) ((gintptr) (_data_->relevancy * SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER)));
#line 204 "../../../src/core/relevancy-backend-zg.vala"
				_data_->_tmp67_ = _data_->index;
#line 204 "../../../src/core/relevancy-backend-zg.vala"
				_data_->index = _data_->_tmp67_ + 1;
#line 195 "../../../src/core/relevancy-backend-zg.vala"
				_g_object_unref0 (_data_->s2);
#line 1372 "relevancy-backend-zg.c"
			}
#line 195 "../../../src/core/relevancy-backend-zg.vala"
			_g_object_unref0 (_data_->e2);
#line 195 "../../../src/core/relevancy-backend-zg.vala"
			_g_object_unref0 (_data_->_e2_it);
#line 1378 "relevancy-backend-zg.c"
		}
#line 150 "../../../src/core/relevancy-backend-zg.vala"
		_g_object_unref0 (_data_->_tmp45_);
#line 150 "../../../src/core/relevancy-backend-zg.vala"
		_g_object_unref0 (_data_->_tmp16_);
#line 1384 "relevancy-backend-zg.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 150 "../../../src/core/relevancy-backend-zg.vala"
		_data_->err = _data_->_inner_error0_;
#line 150 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_inner_error0_ = NULL;
#line 209 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp68_ = _data_->err;
#line 209 "../../../src/core/relevancy-backend-zg.vala"
		_data_->_tmp69_ = _data_->_tmp68_->message;
#line 209 "../../../src/core/relevancy-backend-zg.vala"
		g_warning ("relevancy-backend-zg.vala:209: %s", _data_->_tmp69_);
#line 150 "../../../src/core/relevancy-backend-zg.vala"
		_g_error_free0 (_data_->err);
#line 1401 "relevancy-backend-zg.c"
	}
	__finally0:
#line 150 "../../../src/core/relevancy-backend-zg.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 150 "../../../src/core/relevancy-backend-zg.vala"
		_g_object_unref0 (_data_->popularity_map);
#line 150 "../../../src/core/relevancy-backend-zg.vala"
		_g_object_unref0 (_data_->rs);
#line 150 "../../../src/core/relevancy-backend-zg.vala"
		_g_ptr_array_unref0 (_data_->array);
#line 150 "../../../src/core/relevancy-backend-zg.vala"
		_g_object_unref0 (_data_->subject);
#line 150 "../../../src/core/relevancy-backend-zg.vala"
		_g_object_unref0 (_data_->event);
#line 150 "../../../src/core/relevancy-backend-zg.vala"
		_g_object_unref0 (_data_->tr);
#line 150 "../../../src/core/relevancy-backend-zg.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 150 "../../../src/core/relevancy-backend-zg.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 150 "../../../src/core/relevancy-backend-zg.vala"
		g_object_unref (_data_->_async_result);
#line 150 "../../../src/core/relevancy-backend-zg.vala"
		return FALSE;
#line 1426 "relevancy-backend-zg.c"
	}
#line 212 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp70_ = _data_->popularity_map;
#line 212 "../../../src/core/relevancy-backend-zg.vala"
	_data_->_tmp71_ = _g_object_ref0 (_data_->_tmp70_);
#line 212 "../../../src/core/relevancy-backend-zg.vala"
	_g_object_unref0 (_data_->self->priv->uri_popularity);
#line 212 "../../../src/core/relevancy-backend-zg.vala"
	_data_->self->priv->uri_popularity = _data_->_tmp71_;
#line 128 "../../../src/core/relevancy-backend-zg.vala"
	_g_object_unref0 (_data_->popularity_map);
#line 128 "../../../src/core/relevancy-backend-zg.vala"
	_g_object_unref0 (_data_->rs);
#line 128 "../../../src/core/relevancy-backend-zg.vala"
	_g_ptr_array_unref0 (_data_->array);
#line 128 "../../../src/core/relevancy-backend-zg.vala"
	_g_object_unref0 (_data_->subject);
#line 128 "../../../src/core/relevancy-backend-zg.vala"
	_g_object_unref0 (_data_->event);
#line 128 "../../../src/core/relevancy-backend-zg.vala"
	_g_object_unref0 (_data_->tr);
#line 128 "../../../src/core/relevancy-backend-zg.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 128 "../../../src/core/relevancy-backend-zg.vala"
	if (_data_->_state_ != 0) {
#line 128 "../../../src/core/relevancy-backend-zg.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 128 "../../../src/core/relevancy-backend-zg.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1456 "relevancy-backend-zg.c"
		}
	}
#line 128 "../../../src/core/relevancy-backend-zg.vala"
	g_object_unref (_data_->_async_result);
#line 128 "../../../src/core/relevancy-backend-zg.vala"
	return FALSE;
#line 1463 "relevancy-backend-zg.c"
}

static gfloat
synapse_zeitgeist_relevancy_backend_real_get_application_popularity (SynapseRelevancyBackend* base,
                                                                     const gchar* desktop_id)
{
	SynapseZeitgeistRelevancyBackend * self;
	GeeMap* _tmp0_;
	gfloat result = 0.0F;
#line 215 "../../../src/core/relevancy-backend-zg.vala"
	self = (SynapseZeitgeistRelevancyBackend*) base;
#line 215 "../../../src/core/relevancy-backend-zg.vala"
	g_return_val_if_fail (desktop_id != NULL, 0.0F);
#line 217 "../../../src/core/relevancy-backend-zg.vala"
	_tmp0_ = self->priv->application_popularity;
#line 217 "../../../src/core/relevancy-backend-zg.vala"
	if (gee_map_has_key (_tmp0_, desktop_id)) {
#line 1481 "relevancy-backend-zg.c"
		GeeMap* _tmp1_;
		gpointer _tmp2_;
#line 219 "../../../src/core/relevancy-backend-zg.vala"
		_tmp1_ = self->priv->application_popularity;
#line 219 "../../../src/core/relevancy-backend-zg.vala"
		_tmp2_ = gee_map_get (_tmp1_, desktop_id);
#line 219 "../../../src/core/relevancy-backend-zg.vala"
		result = ((gint) ((gintptr) _tmp2_)) / SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER;
#line 219 "../../../src/core/relevancy-backend-zg.vala"
		return result;
#line 1492 "relevancy-backend-zg.c"
	}
#line 222 "../../../src/core/relevancy-backend-zg.vala"
	result = 0.0f;
#line 222 "../../../src/core/relevancy-backend-zg.vala"
	return result;
#line 1498 "relevancy-backend-zg.c"
}

static gfloat
synapse_zeitgeist_relevancy_backend_real_get_uri_popularity (SynapseRelevancyBackend* base,
                                                             const gchar* uri)
{
	SynapseZeitgeistRelevancyBackend * self;
	GeeMap* _tmp0_;
	gfloat result = 0.0F;
#line 225 "../../../src/core/relevancy-backend-zg.vala"
	self = (SynapseZeitgeistRelevancyBackend*) base;
#line 225 "../../../src/core/relevancy-backend-zg.vala"
	g_return_val_if_fail (uri != NULL, 0.0F);
#line 227 "../../../src/core/relevancy-backend-zg.vala"
	_tmp0_ = self->priv->uri_popularity;
#line 227 "../../../src/core/relevancy-backend-zg.vala"
	if (gee_map_has_key (_tmp0_, uri)) {
#line 1516 "relevancy-backend-zg.c"
		GeeMap* _tmp1_;
		gpointer _tmp2_;
#line 229 "../../../src/core/relevancy-backend-zg.vala"
		_tmp1_ = self->priv->uri_popularity;
#line 229 "../../../src/core/relevancy-backend-zg.vala"
		_tmp2_ = gee_map_get (_tmp1_, uri);
#line 229 "../../../src/core/relevancy-backend-zg.vala"
		result = ((gint) ((gintptr) _tmp2_)) / SYNAPSE_ZEITGEIST_RELEVANCY_BACKEND_MULTIPLIER;
#line 229 "../../../src/core/relevancy-backend-zg.vala"
		return result;
#line 1527 "relevancy-backend-zg.c"
	}
#line 232 "../../../src/core/relevancy-backend-zg.vala"
	result = 0.0f;
#line 232 "../../../src/core/relevancy-backend-zg.vala"
	return result;
#line 1533 "relevancy-backend-zg.c"
}

static gboolean
__lambda7_ (SynapseZeitgeistRelevancyBackend* self)
{
	gboolean result = FALSE;
#line 238 "../../../src/core/relevancy-backend-zg.vala"
	synapse_zeitgeist_relevancy_backend_load_application_relevancies (self, NULL, NULL);
#line 239 "../../../src/core/relevancy-backend-zg.vala"
	result = FALSE;
#line 239 "../../../src/core/relevancy-backend-zg.vala"
	return result;
#line 1546 "relevancy-backend-zg.c"
}

static gboolean
___lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda7_ ((SynapseZeitgeistRelevancyBackend*) self);
#line 237 "../../../src/core/relevancy-backend-zg.vala"
	return result;
#line 1556 "relevancy-backend-zg.c"
}

static void
synapse_zeitgeist_relevancy_backend_reload_relevancies (SynapseZeitgeistRelevancyBackend* self)
{
#line 235 "../../../src/core/relevancy-backend-zg.vala"
	g_return_if_fail (self != NULL);
#line 237 "../../../src/core/relevancy-backend-zg.vala"
	g_idle_add_full (G_PRIORITY_LOW, ___lambda7__gsource_func, g_object_ref (self), g_object_unref);
#line 1566 "relevancy-backend-zg.c"
}

static void
synapse_zeitgeist_relevancy_backend_real_application_launched (SynapseRelevancyBackend* base,
                                                               GAppInfo* app_info)
{
	SynapseZeitgeistRelevancyBackend * self;
	GType zg_gio_module = 0UL;
	gchar* app_uri = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
#line 243 "../../../src/core/relevancy-backend-zg.vala"
	self = (SynapseZeitgeistRelevancyBackend*) base;
#line 243 "../../../src/core/relevancy-backend-zg.vala"
	g_return_if_fail (app_info != NULL);
#line 247 "../../../src/core/relevancy-backend-zg.vala"
	zg_gio_module = g_type_from_name ("GAppLaunchHandlerZeitgeist");
#line 251 "../../../src/core/relevancy-backend-zg.vala"
	if (zg_gio_module != ((GType) 0)) {
#line 253 "../../../src/core/relevancy-backend-zg.vala"
		g_debug ("relevancy-backend-zg.vala:253: libzg-gio-module detected, not pushing");
#line 254 "../../../src/core/relevancy-backend-zg.vala"
		synapse_zeitgeist_relevancy_backend_reload_relevancies (self);
#line 255 "../../../src/core/relevancy-backend-zg.vala"
		return;
#line 1594 "relevancy-backend-zg.c"
	}
#line 258 "../../../src/core/relevancy-backend-zg.vala"
	if (self->priv->has_datahub_gio_module) {
#line 260 "../../../src/core/relevancy-backend-zg.vala"
		synapse_zeitgeist_relevancy_backend_reload_relevancies (self);
#line 261 "../../../src/core/relevancy-backend-zg.vala"
		return;
#line 1602 "relevancy-backend-zg.c"
	}
#line 264 "../../../src/core/relevancy-backend-zg.vala"
	app_uri = NULL;
#line 265 "../../../src/core/relevancy-backend-zg.vala"
	_tmp0_ = g_app_info_get_id (app_info);
#line 265 "../../../src/core/relevancy-backend-zg.vala"
	if (_tmp0_ != NULL) {
#line 1610 "relevancy-backend-zg.c"
		const gchar* _tmp1_;
		gchar* _tmp2_;
#line 267 "../../../src/core/relevancy-backend-zg.vala"
		_tmp1_ = g_app_info_get_id (app_info);
#line 267 "../../../src/core/relevancy-backend-zg.vala"
		_tmp2_ = g_strconcat ("application://", _tmp1_, NULL);
#line 267 "../../../src/core/relevancy-backend-zg.vala"
		_g_free0 (app_uri);
#line 267 "../../../src/core/relevancy-backend-zg.vala"
		app_uri = _tmp2_;
#line 1621 "relevancy-backend-zg.c"
	} else {
#line 269 "../../../src/core/relevancy-backend-zg.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (app_info, G_TYPE_DESKTOP_APP_INFO)) {
#line 1625 "relevancy-backend-zg.c"
			gchar* filename = NULL;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
#line 271 "../../../src/core/relevancy-backend-zg.vala"
			_tmp3_ = g_desktop_app_info_get_filename (G_TYPE_CHECK_INSTANCE_CAST (app_info, G_TYPE_DESKTOP_APP_INFO, GDesktopAppInfo));
#line 271 "../../../src/core/relevancy-backend-zg.vala"
			_tmp4_ = g_strdup (_tmp3_);
#line 271 "../../../src/core/relevancy-backend-zg.vala"
			filename = _tmp4_;
#line 272 "../../../src/core/relevancy-backend-zg.vala"
			_tmp5_ = filename;
#line 272 "../../../src/core/relevancy-backend-zg.vala"
			if (_tmp5_ == NULL) {
#line 272 "../../../src/core/relevancy-backend-zg.vala"
				_g_free0 (filename);
#line 272 "../../../src/core/relevancy-backend-zg.vala"
				_g_free0 (app_uri);
#line 272 "../../../src/core/relevancy-backend-zg.vala"
				return;
#line 1650 "relevancy-backend-zg.c"
			}
#line 273 "../../../src/core/relevancy-backend-zg.vala"
			_tmp6_ = filename;
#line 273 "../../../src/core/relevancy-backend-zg.vala"
			_tmp7_ = g_path_get_basename (_tmp6_);
#line 273 "../../../src/core/relevancy-backend-zg.vala"
			_tmp8_ = _tmp7_;
#line 273 "../../../src/core/relevancy-backend-zg.vala"
			_tmp9_ = g_strconcat ("application://", _tmp8_, NULL);
#line 273 "../../../src/core/relevancy-backend-zg.vala"
			_g_free0 (app_uri);
#line 273 "../../../src/core/relevancy-backend-zg.vala"
			app_uri = _tmp9_;
#line 273 "../../../src/core/relevancy-backend-zg.vala"
			_g_free0 (_tmp8_);
#line 269 "../../../src/core/relevancy-backend-zg.vala"
			_g_free0 (filename);
#line 1668 "relevancy-backend-zg.c"
		}
	}
#line 276 "../../../src/core/relevancy-backend-zg.vala"
	_tmp10_ = app_uri;
#line 276 "../../../src/core/relevancy-backend-zg.vala"
	g_debug ("relevancy-backend-zg.vala:276: launched \"%s\", pushing to ZG", _tmp10_);
#line 277 "../../../src/core/relevancy-backend-zg.vala"
	_tmp11_ = app_uri;
#line 277 "../../../src/core/relevancy-backend-zg.vala"
	_tmp12_ = g_app_info_get_display_name (app_info);
#line 277 "../../../src/core/relevancy-backend-zg.vala"
	synapse_zeitgeist_relevancy_backend_push_app_launch (self, _tmp11_, _tmp12_);
#line 280 "../../../src/core/relevancy-backend-zg.vala"
	synapse_zeitgeist_relevancy_backend_reload_relevancies (self);
#line 243 "../../../src/core/relevancy-backend-zg.vala"
	_g_free0 (app_uri);
#line 1685 "relevancy-backend-zg.c"
}

static void
synapse_zeitgeist_relevancy_backend_push_app_launch (SynapseZeitgeistRelevancyBackend* self,
                                                     const gchar* app_uri,
                                                     const gchar* display_name)
{
	ZeitgeistEvent* event = NULL;
	ZeitgeistEvent* _tmp0_;
	ZeitgeistSubject* subject = NULL;
	ZeitgeistSubject* _tmp1_;
	ZeitgeistEvent* _tmp2_;
	ZeitgeistEvent* _tmp3_;
	ZeitgeistEvent* _tmp4_;
	ZeitgeistEvent* _tmp5_;
	ZeitgeistSubject* _tmp6_;
	ZeitgeistSubject* _tmp7_;
	ZeitgeistSubject* _tmp8_;
	ZeitgeistSubject* _tmp9_;
	ZeitgeistSubject* _tmp10_;
	ZeitgeistSubject* _tmp11_;
	GError* _inner_error0_ = NULL;
#line 283 "../../../src/core/relevancy-backend-zg.vala"
	g_return_if_fail (self != NULL);
#line 283 "../../../src/core/relevancy-backend-zg.vala"
	g_return_if_fail (app_uri != NULL);
#line 286 "../../../src/core/relevancy-backend-zg.vala"
	_tmp0_ = zeitgeist_event_new ();
#line 286 "../../../src/core/relevancy-backend-zg.vala"
	event = _tmp0_;
#line 287 "../../../src/core/relevancy-backend-zg.vala"
	_tmp1_ = zeitgeist_subject_new ();
#line 287 "../../../src/core/relevancy-backend-zg.vala"
	subject = _tmp1_;
#line 289 "../../../src/core/relevancy-backend-zg.vala"
	_tmp2_ = event;
#line 289 "../../../src/core/relevancy-backend-zg.vala"
	zeitgeist_event_set_actor (_tmp2_, "application://synapse.desktop");
#line 290 "../../../src/core/relevancy-backend-zg.vala"
	_tmp3_ = event;
#line 290 "../../../src/core/relevancy-backend-zg.vala"
	zeitgeist_event_set_interpretation (_tmp3_, ZEITGEIST_ZG_ACCESS_EVENT);
#line 291 "../../../src/core/relevancy-backend-zg.vala"
	_tmp4_ = event;
#line 291 "../../../src/core/relevancy-backend-zg.vala"
	zeitgeist_event_set_manifestation (_tmp4_, ZEITGEIST_ZG_USER_ACTIVITY);
#line 292 "../../../src/core/relevancy-backend-zg.vala"
	_tmp5_ = event;
#line 292 "../../../src/core/relevancy-backend-zg.vala"
	_tmp6_ = subject;
#line 292 "../../../src/core/relevancy-backend-zg.vala"
	zeitgeist_event_add_subject (_tmp5_, _tmp6_);
#line 294 "../../../src/core/relevancy-backend-zg.vala"
	_tmp7_ = subject;
#line 294 "../../../src/core/relevancy-backend-zg.vala"
	zeitgeist_subject_set_uri (_tmp7_, app_uri);
#line 295 "../../../src/core/relevancy-backend-zg.vala"
	_tmp8_ = subject;
#line 295 "../../../src/core/relevancy-backend-zg.vala"
	zeitgeist_subject_set_interpretation (_tmp8_, ZEITGEIST_NFO_SOFTWARE);
#line 296 "../../../src/core/relevancy-backend-zg.vala"
	_tmp9_ = subject;
#line 296 "../../../src/core/relevancy-backend-zg.vala"
	zeitgeist_subject_set_manifestation (_tmp9_, ZEITGEIST_NFO_SOFTWARE_ITEM);
#line 297 "../../../src/core/relevancy-backend-zg.vala"
	_tmp10_ = subject;
#line 297 "../../../src/core/relevancy-backend-zg.vala"
	zeitgeist_subject_set_mimetype (_tmp10_, "application/x-desktop");
#line 298 "../../../src/core/relevancy-backend-zg.vala"
	_tmp11_ = subject;
#line 298 "../../../src/core/relevancy-backend-zg.vala"
	zeitgeist_subject_set_text (_tmp11_, display_name);
#line 1758 "relevancy-backend-zg.c"
	{
		ZeitgeistLog* _tmp12_;
		ZeitgeistEvent* _tmp13_;
#line 302 "../../../src/core/relevancy-backend-zg.vala"
		_tmp12_ = self->priv->zg_log;
#line 302 "../../../src/core/relevancy-backend-zg.vala"
		_tmp13_ = event;
#line 302 "../../../src/core/relevancy-backend-zg.vala"
		zeitgeist_log_insert_event_no_reply (_tmp12_, _tmp13_, &_inner_error0_);
#line 302 "../../../src/core/relevancy-backend-zg.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1770 "relevancy-backend-zg.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
#line 300 "../../../src/core/relevancy-backend-zg.vala"
		err = _inner_error0_;
#line 300 "../../../src/core/relevancy-backend-zg.vala"
		_inner_error0_ = NULL;
#line 306 "../../../src/core/relevancy-backend-zg.vala"
		_tmp14_ = err;
#line 306 "../../../src/core/relevancy-backend-zg.vala"
		_tmp15_ = _tmp14_->message;
#line 306 "../../../src/core/relevancy-backend-zg.vala"
		g_warning ("relevancy-backend-zg.vala:306: %s", _tmp15_);
#line 307 "../../../src/core/relevancy-backend-zg.vala"
		_g_error_free0 (err);
#line 307 "../../../src/core/relevancy-backend-zg.vala"
		_g_object_unref0 (subject);
#line 307 "../../../src/core/relevancy-backend-zg.vala"
		_g_object_unref0 (event);
#line 307 "../../../src/core/relevancy-backend-zg.vala"
		return;
#line 1798 "relevancy-backend-zg.c"
	}
	__finally0:
#line 300 "../../../src/core/relevancy-backend-zg.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 300 "../../../src/core/relevancy-backend-zg.vala"
		_g_object_unref0 (subject);
#line 300 "../../../src/core/relevancy-backend-zg.vala"
		_g_object_unref0 (event);
#line 300 "../../../src/core/relevancy-backend-zg.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 300 "../../../src/core/relevancy-backend-zg.vala"
		g_clear_error (&_inner_error0_);
#line 300 "../../../src/core/relevancy-backend-zg.vala"
		return;
#line 1813 "relevancy-backend-zg.c"
	}
#line 283 "../../../src/core/relevancy-backend-zg.vala"
	_g_object_unref0 (subject);
#line 283 "../../../src/core/relevancy-backend-zg.vala"
	_g_object_unref0 (event);
#line 1819 "relevancy-backend-zg.c"
}

SynapseZeitgeistRelevancyBackend*
synapse_zeitgeist_relevancy_backend_construct (GType object_type)
{
	SynapseZeitgeistRelevancyBackend * self = NULL;
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	self = (SynapseZeitgeistRelevancyBackend*) g_object_new (object_type, NULL);
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	return self;
#line 1830 "relevancy-backend-zg.c"
}

SynapseZeitgeistRelevancyBackend*
synapse_zeitgeist_relevancy_backend_new (void)
{
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	return synapse_zeitgeist_relevancy_backend_construct (SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND);
#line 1838 "relevancy-backend-zg.c"
}

static gboolean
_synapse_zeitgeist_relevancy_backend_refresh_popularity_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_zeitgeist_relevancy_backend_refresh_popularity ((SynapseZeitgeistRelevancyBackend*) self);
#line 42 "../../../src/core/relevancy-backend-zg.vala"
	return result;
#line 1848 "relevancy-backend-zg.c"
}

static GObject *
synapse_zeitgeist_relevancy_backend_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseZeitgeistRelevancyBackend * self;
	ZeitgeistLog* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
#line 33 "../../../src/core/relevancy-backend-zg.vala"
	parent_class = G_OBJECT_CLASS (synapse_zeitgeist_relevancy_backend_parent_class);
#line 33 "../../../src/core/relevancy-backend-zg.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 33 "../../../src/core/relevancy-backend-zg.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND, SynapseZeitgeistRelevancyBackend);
#line 35 "../../../src/core/relevancy-backend-zg.vala"
	_tmp0_ = zeitgeist_log_new ();
#line 35 "../../../src/core/relevancy-backend-zg.vala"
	_g_object_unref0 (self->priv->zg_log);
#line 35 "../../../src/core/relevancy-backend-zg.vala"
	self->priv->zg_log = _tmp0_;
#line 36 "../../../src/core/relevancy-backend-zg.vala"
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 36 "../../../src/core/relevancy-backend-zg.vala"
	_g_object_unref0 (self->priv->application_popularity);
#line 36 "../../../src/core/relevancy-backend-zg.vala"
	self->priv->application_popularity = (GeeMap*) _tmp1_;
#line 37 "../../../src/core/relevancy-backend-zg.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 37 "../../../src/core/relevancy-backend-zg.vala"
	_g_object_unref0 (self->priv->uri_popularity);
#line 37 "../../../src/core/relevancy-backend-zg.vala"
	self->priv->uri_popularity = (GeeMap*) _tmp2_;
#line 39 "../../../src/core/relevancy-backend-zg.vala"
	synapse_zeitgeist_relevancy_backend_refresh_popularity (self);
#line 40 "../../../src/core/relevancy-backend-zg.vala"
	synapse_zeitgeist_relevancy_backend_check_data_sources (self, NULL, NULL);
#line 42 "../../../src/core/relevancy-backend-zg.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) (60 * 30), _synapse_zeitgeist_relevancy_backend_refresh_popularity_gsource_func, g_object_ref (self), g_object_unref);
#line 33 "../../../src/core/relevancy-backend-zg.vala"
	return obj;
#line 1894 "relevancy-backend-zg.c"
}

static void
synapse_zeitgeist_relevancy_backend_class_init (SynapseZeitgeistRelevancyBackendClass * klass,
                                                gpointer klass_data)
{
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	synapse_zeitgeist_relevancy_backend_parent_class = g_type_class_peek_parent (klass);
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	g_type_class_adjust_private_offset (klass, &SynapseZeitgeistRelevancyBackend_private_offset);
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_zeitgeist_relevancy_backend_constructor;
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_zeitgeist_relevancy_backend_finalize;
#line 1909 "relevancy-backend-zg.c"
}

static void
synapse_zeitgeist_relevancy_backend_synapse_relevancy_backend_interface_init (SynapseRelevancyBackendIface * iface,
                                                                              gpointer iface_data)
{
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	synapse_zeitgeist_relevancy_backend_synapse_relevancy_backend_parent_iface = g_type_interface_peek_parent (iface);
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	iface->get_application_popularity = (gfloat (*) (SynapseRelevancyBackend*, const gchar*)) synapse_zeitgeist_relevancy_backend_real_get_application_popularity;
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	iface->get_uri_popularity = (gfloat (*) (SynapseRelevancyBackend*, const gchar*)) synapse_zeitgeist_relevancy_backend_real_get_uri_popularity;
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	iface->application_launched = (void (*) (SynapseRelevancyBackend*, GAppInfo*)) synapse_zeitgeist_relevancy_backend_real_application_launched;
#line 1924 "relevancy-backend-zg.c"
}

static void
synapse_zeitgeist_relevancy_backend_instance_init (SynapseZeitgeistRelevancyBackend * self,
                                                   gpointer klass)
{
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	self->priv = synapse_zeitgeist_relevancy_backend_get_instance_private (self);
#line 29 "../../../src/core/relevancy-backend-zg.vala"
	self->priv->has_datahub_gio_module = FALSE;
#line 1935 "relevancy-backend-zg.c"
}

static void
synapse_zeitgeist_relevancy_backend_finalize (GObject * obj)
{
	SynapseZeitgeistRelevancyBackend * self;
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_ZEITGEIST_RELEVANCY_BACKEND, SynapseZeitgeistRelevancyBackend);
#line 25 "../../../src/core/relevancy-backend-zg.vala"
	_g_object_unref0 (self->priv->zg_log);
#line 26 "../../../src/core/relevancy-backend-zg.vala"
	_g_object_unref0 (self->priv->zg_dsr);
#line 27 "../../../src/core/relevancy-backend-zg.vala"
	_g_object_unref0 (self->priv->application_popularity);
#line 28 "../../../src/core/relevancy-backend-zg.vala"
	_g_object_unref0 (self->priv->uri_popularity);
#line 23 "../../../src/core/relevancy-backend-zg.vala"
	G_OBJECT_CLASS (synapse_zeitgeist_relevancy_backend_parent_class)->finalize (obj);
#line 1954 "relevancy-backend-zg.c"
}

static GType
synapse_zeitgeist_relevancy_backend_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseZeitgeistRelevancyBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_zeitgeist_relevancy_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseZeitgeistRelevancyBackend), 0, (GInstanceInitFunc) synapse_zeitgeist_relevancy_backend_instance_init, NULL };
	static const GInterfaceInfo synapse_relevancy_backend_info = { (GInterfaceInitFunc) synapse_zeitgeist_relevancy_backend_synapse_relevancy_backend_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_zeitgeist_relevancy_backend_type_id;
	synapse_zeitgeist_relevancy_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseZeitgeistRelevancyBackend", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_zeitgeist_relevancy_backend_type_id, SYNAPSE_TYPE_RELEVANCY_BACKEND, &synapse_relevancy_backend_info);
	SynapseZeitgeistRelevancyBackend_private_offset = g_type_add_instance_private (synapse_zeitgeist_relevancy_backend_type_id, sizeof (SynapseZeitgeistRelevancyBackendPrivate));
	return synapse_zeitgeist_relevancy_backend_type_id;
}

GType
synapse_zeitgeist_relevancy_backend_get_type (void)
{
	static volatile gsize synapse_zeitgeist_relevancy_backend_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_zeitgeist_relevancy_backend_type_id__volatile)) {
		GType synapse_zeitgeist_relevancy_backend_type_id;
		synapse_zeitgeist_relevancy_backend_type_id = synapse_zeitgeist_relevancy_backend_get_type_once ();
		g_once_init_leave (&synapse_zeitgeist_relevancy_backend_type_id__volatile, synapse_zeitgeist_relevancy_backend_type_id);
	}
	return synapse_zeitgeist_relevancy_backend_type_id__volatile;
}

