/* devhelp-search.c generated by valac 0.48.17, the Vala compiler
 * generated from devhelp-search.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib-object.h>
#include <synapse-core.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#define SYNAPSE_TYPE_DEVHELP_PLUGIN (synapse_devhelp_plugin_get_type ())
#define SYNAPSE_DEVHELP_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_DEVHELP_PLUGIN, SynapseDevhelpPlugin))
#define SYNAPSE_DEVHELP_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_DEVHELP_PLUGIN, SynapseDevhelpPluginClass))
#define SYNAPSE_IS_DEVHELP_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_DEVHELP_PLUGIN))
#define SYNAPSE_IS_DEVHELP_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_DEVHELP_PLUGIN))
#define SYNAPSE_DEVHELP_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_DEVHELP_PLUGIN, SynapseDevhelpPluginClass))

typedef struct _SynapseDevhelpPlugin SynapseDevhelpPlugin;
typedef struct _SynapseDevhelpPluginClass SynapseDevhelpPluginClass;
typedef struct _SynapseDevhelpPluginPrivate SynapseDevhelpPluginPrivate;

#define SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH (synapse_devhelp_plugin_search_get_type ())
#define SYNAPSE_DEVHELP_PLUGIN_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH, SynapseDevhelpPluginSearch))
#define SYNAPSE_DEVHELP_PLUGIN_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH, SynapseDevhelpPluginSearchClass))
#define SYNAPSE_DEVHELP_PLUGIN_IS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH))
#define SYNAPSE_DEVHELP_PLUGIN_IS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH))
#define SYNAPSE_DEVHELP_PLUGIN_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH, SynapseDevhelpPluginSearchClass))

typedef struct _SynapseDevhelpPluginSearch SynapseDevhelpPluginSearch;
typedef struct _SynapseDevhelpPluginSearchClass SynapseDevhelpPluginSearchClass;
enum  {
	SYNAPSE_DEVHELP_PLUGIN_0_PROPERTY,
	SYNAPSE_DEVHELP_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_DEVHELP_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_devhelp_plugin_properties[SYNAPSE_DEVHELP_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SynapseDevhelpPluginSearchPrivate SynapseDevhelpPluginSearchPrivate;
enum  {
	SYNAPSE_DEVHELP_PLUGIN_SEARCH_0_PROPERTY,
	SYNAPSE_DEVHELP_PLUGIN_SEARCH_DEFAULT_RELEVANCY_PROPERTY,
	SYNAPSE_DEVHELP_PLUGIN_SEARCH_NUM_PROPERTIES
};
static GParamSpec* synapse_devhelp_plugin_search_properties[SYNAPSE_DEVHELP_PLUGIN_SEARCH_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SynapseDevhelpPlugin {
	GObject parent_instance;
	SynapseDevhelpPluginPrivate * priv;
};

struct _SynapseDevhelpPluginClass {
	GObjectClass parent_class;
};

struct _SynapseDevhelpPluginPrivate {
	gboolean _enabled;
	SynapseDevhelpPluginSearch* action;
	gboolean has_devhelp;
	GRegex* symbol_re;
};

struct _SynapseDevhelpPluginSearch {
	SynapseMatch parent_instance;
	SynapseDevhelpPluginSearchPrivate * priv;
};

struct _SynapseDevhelpPluginSearchClass {
	SynapseMatchClass parent_class;
};

struct _SynapseDevhelpPluginSearchPrivate {
	gint _default_relevancy;
};

static gint SynapseDevhelpPlugin_private_offset;
static gpointer synapse_devhelp_plugin_parent_class = NULL;
static gint SynapseDevhelpPluginSearch_private_offset;
static gpointer synapse_devhelp_plugin_search_parent_class = NULL;
static SynapseActivatableIface * synapse_devhelp_plugin_synapse_activatable_parent_iface = NULL;
static SynapseActionProviderIface * synapse_devhelp_plugin_synapse_action_provider_parent_iface = NULL;

GType synapse_devhelp_plugin_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDevhelpPlugin, g_object_unref)
static GType synapse_devhelp_plugin_search_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseDevhelpPluginSearch, g_object_unref)
static void synapse_devhelp_plugin_real_activate (SynapseActivatable* base);
static void synapse_devhelp_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_devhelp_plugin_register_plugin (void);
static void _synapse_devhelp_plugin_register_plugin_synapse_plugin_register_func (void);
static gboolean synapse_devhelp_plugin_real_handles_unknown (SynapseActionProvider* base);
static SynapseResultSet* synapse_devhelp_plugin_real_find_for_match (SynapseActionProvider* base,
                                                              SynapseQuery* query,
                                                              SynapseMatch* match);
static gint synapse_devhelp_plugin_search_get_default_relevancy (SynapseDevhelpPluginSearch* self);
SynapseDevhelpPlugin* synapse_devhelp_plugin_new (void);
SynapseDevhelpPlugin* synapse_devhelp_plugin_construct (GType object_type);
static void synapse_devhelp_plugin_search_real_execute (SynapseMatch* base,
                                                 SynapseMatch* match);
static SynapseDevhelpPluginSearch* synapse_devhelp_plugin_search_new (void);
static SynapseDevhelpPluginSearch* synapse_devhelp_plugin_search_construct (GType object_type);
static void synapse_devhelp_plugin_search_set_default_relevancy (SynapseDevhelpPluginSearch* self,
                                                          gint value);
static void synapse_devhelp_plugin_search_finalize (GObject * obj);
static GType synapse_devhelp_plugin_search_get_type_once (void);
static void _vala_synapse_devhelp_plugin_search_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_synapse_devhelp_plugin_search_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);
static GObject * synapse_devhelp_plugin_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void synapse_devhelp_plugin_finalize (GObject * obj);
static GType synapse_devhelp_plugin_get_type_once (void);
static void _vala_synapse_devhelp_plugin_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_synapse_devhelp_plugin_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
synapse_devhelp_plugin_get_instance_private (SynapseDevhelpPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDevhelpPlugin_private_offset);
}

static void
synapse_devhelp_plugin_real_activate (SynapseActivatable* base)
{
	SynapseDevhelpPlugin * self;
#line 28 "../../../src/plugins/devhelp-search.vala"
	self = (SynapseDevhelpPlugin*) base;
#line 166 "devhelp-search.c"
}

static void
synapse_devhelp_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseDevhelpPlugin * self;
#line 33 "../../../src/plugins/devhelp-search.vala"
	self = (SynapseDevhelpPlugin*) base;
#line 175 "devhelp-search.c"
}

static void
_synapse_devhelp_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 67 "../../../src/plugins/devhelp-search.vala"
	synapse_devhelp_plugin_register_plugin ();
#line 183 "devhelp-search.c"
}

static void
synapse_devhelp_plugin_register_plugin (void)
{
	SynapsePluginRegistry* _tmp0_;
	SynapsePluginRegistry* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 67 "../../../src/plugins/devhelp-search.vala"
	_tmp0_ = synapse_plugin_registry_get_default ();
#line 67 "../../../src/plugins/devhelp-search.vala"
	_tmp1_ = _tmp0_;
#line 67 "../../../src/plugins/devhelp-search.vala"
	_tmp2_ = g_find_program_in_path ("devhelp");
#line 67 "../../../src/plugins/devhelp-search.vala"
	_tmp3_ = _tmp2_;
#line 67 "../../../src/plugins/devhelp-search.vala"
	synapse_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_DEVHELP_PLUGIN, "Devhelp", _ ("Search documentation using Devhelp."), "devhelp", _synapse_devhelp_plugin_register_plugin_synapse_plugin_register_func, _tmp3_ != NULL, _ ("Devhelp is not installed"));
#line 67 "../../../src/plugins/devhelp-search.vala"
	_g_free0 (_tmp3_);
#line 67 "../../../src/plugins/devhelp-search.vala"
	_g_object_unref0 (_tmp1_);
#line 207 "devhelp-search.c"
}

static gboolean
synapse_devhelp_plugin_real_handles_unknown (SynapseActionProvider* base)
{
	SynapseDevhelpPlugin * self;
	gboolean result = FALSE;
#line 103 "../../../src/plugins/devhelp-search.vala"
	self = (SynapseDevhelpPlugin*) base;
#line 105 "../../../src/plugins/devhelp-search.vala"
	result = self->priv->has_devhelp;
#line 105 "../../../src/plugins/devhelp-search.vala"
	return result;
#line 221 "devhelp-search.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 131 "../../../src/plugins/devhelp-search.vala"
	return self ? g_object_ref (self) : NULL;
#line 229 "devhelp-search.c"
}

static SynapseResultSet*
synapse_devhelp_plugin_real_find_for_match (SynapseActionProvider* base,
                                            SynapseQuery* query,
                                            SynapseMatch* match)
{
	SynapseDevhelpPlugin * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean query_empty = FALSE;
	SynapseQuery _tmp4_;
	const gchar* _tmp5_;
	SynapseResultSet* results = NULL;
	SynapseResultSet* _tmp6_;
	SynapseResultSet* result = NULL;
#line 110 "../../../src/plugins/devhelp-search.vala"
	self = (SynapseDevhelpPlugin*) base;
#line 110 "../../../src/plugins/devhelp-search.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 110 "../../../src/plugins/devhelp-search.vala"
	g_return_val_if_fail (match != NULL, NULL);
#line 112 "../../../src/plugins/devhelp-search.vala"
	if (!self->priv->has_devhelp) {
#line 112 "../../../src/plugins/devhelp-search.vala"
		_tmp1_ = TRUE;
#line 256 "devhelp-search.c"
	} else {
#line 112 "../../../src/plugins/devhelp-search.vala"
		_tmp1_ = !G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_UNKNOWN_MATCH);
#line 260 "devhelp-search.c"
	}
#line 112 "../../../src/plugins/devhelp-search.vala"
	if (_tmp1_) {
#line 112 "../../../src/plugins/devhelp-search.vala"
		_tmp0_ = TRUE;
#line 266 "devhelp-search.c"
	} else {
		SynapseQuery _tmp2_;
		SynapseQueryFlags _tmp3_;
#line 113 "../../../src/plugins/devhelp-search.vala"
		_tmp2_ = *query;
#line 113 "../../../src/plugins/devhelp-search.vala"
		_tmp3_ = _tmp2_.query_type;
#line 113 "../../../src/plugins/devhelp-search.vala"
		_tmp0_ = !((_tmp3_ & SYNAPSE_QUERY_FLAGS_ACTIONS) == SYNAPSE_QUERY_FLAGS_ACTIONS);
#line 276 "devhelp-search.c"
	}
#line 112 "../../../src/plugins/devhelp-search.vala"
	if (_tmp0_) {
#line 115 "../../../src/plugins/devhelp-search.vala"
		result = NULL;
#line 115 "../../../src/plugins/devhelp-search.vala"
		return result;
#line 284 "devhelp-search.c"
	}
#line 118 "../../../src/plugins/devhelp-search.vala"
	_tmp4_ = *query;
#line 118 "../../../src/plugins/devhelp-search.vala"
	_tmp5_ = _tmp4_.query_string;
#line 118 "../../../src/plugins/devhelp-search.vala"
	query_empty = g_strcmp0 (_tmp5_, "") == 0;
#line 119 "../../../src/plugins/devhelp-search.vala"
	_tmp6_ = synapse_result_set_new ();
#line 119 "../../../src/plugins/devhelp-search.vala"
	results = _tmp6_;
#line 121 "../../../src/plugins/devhelp-search.vala"
	if (query_empty) {
#line 298 "devhelp-search.c"
		gint relevancy = 0;
		SynapseDevhelpPluginSearch* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		GRegex* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		SynapseResultSet* _tmp13_;
		SynapseDevhelpPluginSearch* _tmp14_;
#line 123 "../../../src/plugins/devhelp-search.vala"
		_tmp7_ = self->priv->action;
#line 123 "../../../src/plugins/devhelp-search.vala"
		_tmp8_ = synapse_devhelp_plugin_search_get_default_relevancy (_tmp7_);
#line 123 "../../../src/plugins/devhelp-search.vala"
		_tmp9_ = _tmp8_;
#line 123 "../../../src/plugins/devhelp-search.vala"
		relevancy = _tmp9_;
#line 124 "../../../src/plugins/devhelp-search.vala"
		_tmp10_ = self->priv->symbol_re;
#line 124 "../../../src/plugins/devhelp-search.vala"
		_tmp11_ = synapse_match_get_title (match);
#line 124 "../../../src/plugins/devhelp-search.vala"
		_tmp12_ = _tmp11_;
#line 124 "../../../src/plugins/devhelp-search.vala"
		if (g_regex_match (_tmp10_, _tmp12_, 0, NULL)) {
#line 124 "../../../src/plugins/devhelp-search.vala"
			relevancy += (gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL;
#line 326 "devhelp-search.c"
		}
#line 125 "../../../src/plugins/devhelp-search.vala"
		_tmp13_ = results;
#line 125 "../../../src/plugins/devhelp-search.vala"
		_tmp14_ = self->priv->action;
#line 125 "../../../src/plugins/devhelp-search.vala"
		synapse_result_set_add (_tmp13_, (SynapseMatch*) _tmp14_, relevancy);
#line 334 "devhelp-search.c"
	} else {
		GeeList* matchers = NULL;
		SynapseQuery _tmp15_;
		const gchar* _tmp16_;
		GeeList* _tmp17_;
#line 129 "../../../src/plugins/devhelp-search.vala"
		_tmp15_ = *query;
#line 129 "../../../src/plugins/devhelp-search.vala"
		_tmp16_ = _tmp15_.query_string;
#line 129 "../../../src/plugins/devhelp-search.vala"
		_tmp17_ = synapse_query_get_matchers_for_query (_tmp16_, 0, G_REGEX_CASELESS);
#line 129 "../../../src/plugins/devhelp-search.vala"
		matchers = _tmp17_;
#line 348 "devhelp-search.c"
		{
			GeeList* _matcher_list = NULL;
			GeeList* _tmp18_;
			GeeList* _tmp19_;
			gint _matcher_size = 0;
			GeeList* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			gint _matcher_index = 0;
#line 131 "../../../src/plugins/devhelp-search.vala"
			_tmp18_ = matchers;
#line 131 "../../../src/plugins/devhelp-search.vala"
			_tmp19_ = _g_object_ref0 (_tmp18_);
#line 131 "../../../src/plugins/devhelp-search.vala"
			_matcher_list = _tmp19_;
#line 131 "../../../src/plugins/devhelp-search.vala"
			_tmp20_ = _matcher_list;
#line 131 "../../../src/plugins/devhelp-search.vala"
			_tmp21_ = gee_collection_get_size ((GeeCollection*) _tmp20_);
#line 131 "../../../src/plugins/devhelp-search.vala"
			_tmp22_ = _tmp21_;
#line 131 "../../../src/plugins/devhelp-search.vala"
			_matcher_size = _tmp22_;
#line 131 "../../../src/plugins/devhelp-search.vala"
			_matcher_index = -1;
#line 131 "../../../src/plugins/devhelp-search.vala"
			while (TRUE) {
#line 376 "devhelp-search.c"
				gint _tmp23_;
				gint _tmp24_;
				GeeMapEntry* matcher = NULL;
				GeeList* _tmp25_;
				gpointer _tmp26_;
				GeeMapEntry* _tmp27_;
				gconstpointer _tmp28_;
				gconstpointer _tmp29_;
				SynapseDevhelpPluginSearch* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
#line 131 "../../../src/plugins/devhelp-search.vala"
				_matcher_index = _matcher_index + 1;
#line 131 "../../../src/plugins/devhelp-search.vala"
				_tmp23_ = _matcher_index;
#line 131 "../../../src/plugins/devhelp-search.vala"
				_tmp24_ = _matcher_size;
#line 131 "../../../src/plugins/devhelp-search.vala"
				if (!(_tmp23_ < _tmp24_)) {
#line 131 "../../../src/plugins/devhelp-search.vala"
					break;
#line 398 "devhelp-search.c"
				}
#line 131 "../../../src/plugins/devhelp-search.vala"
				_tmp25_ = _matcher_list;
#line 131 "../../../src/plugins/devhelp-search.vala"
				_tmp26_ = gee_list_get (_tmp25_, _matcher_index);
#line 131 "../../../src/plugins/devhelp-search.vala"
				matcher = (GeeMapEntry*) _tmp26_;
#line 133 "../../../src/plugins/devhelp-search.vala"
				_tmp27_ = matcher;
#line 133 "../../../src/plugins/devhelp-search.vala"
				_tmp28_ = gee_map_entry_get_key (_tmp27_);
#line 133 "../../../src/plugins/devhelp-search.vala"
				_tmp29_ = _tmp28_;
#line 133 "../../../src/plugins/devhelp-search.vala"
				_tmp30_ = self->priv->action;
#line 133 "../../../src/plugins/devhelp-search.vala"
				_tmp31_ = synapse_match_get_title ((SynapseMatch*) _tmp30_);
#line 133 "../../../src/plugins/devhelp-search.vala"
				_tmp32_ = _tmp31_;
#line 133 "../../../src/plugins/devhelp-search.vala"
				if (g_regex_match ((GRegex*) _tmp29_, _tmp32_, 0, NULL)) {
#line 420 "devhelp-search.c"
					SynapseResultSet* _tmp33_;
					SynapseDevhelpPluginSearch* _tmp34_;
					GeeMapEntry* _tmp35_;
					gconstpointer _tmp36_;
					gconstpointer _tmp37_;
#line 135 "../../../src/plugins/devhelp-search.vala"
					_tmp33_ = results;
#line 135 "../../../src/plugins/devhelp-search.vala"
					_tmp34_ = self->priv->action;
#line 135 "../../../src/plugins/devhelp-search.vala"
					_tmp35_ = matcher;
#line 135 "../../../src/plugins/devhelp-search.vala"
					_tmp36_ = gee_map_entry_get_value (_tmp35_);
#line 135 "../../../src/plugins/devhelp-search.vala"
					_tmp37_ = _tmp36_;
#line 135 "../../../src/plugins/devhelp-search.vala"
					synapse_result_set_add (_tmp33_, (SynapseMatch*) _tmp34_, (gint) ((gintptr) _tmp37_));
#line 136 "../../../src/plugins/devhelp-search.vala"
					_g_object_unref0 (matcher);
#line 136 "../../../src/plugins/devhelp-search.vala"
					break;
#line 442 "devhelp-search.c"
				}
#line 131 "../../../src/plugins/devhelp-search.vala"
				_g_object_unref0 (matcher);
#line 446 "devhelp-search.c"
			}
#line 131 "../../../src/plugins/devhelp-search.vala"
			_g_object_unref0 (_matcher_list);
#line 450 "devhelp-search.c"
		}
#line 121 "../../../src/plugins/devhelp-search.vala"
		_g_object_unref0 (matchers);
#line 454 "devhelp-search.c"
	}
#line 141 "../../../src/plugins/devhelp-search.vala"
	result = results;
#line 141 "../../../src/plugins/devhelp-search.vala"
	return result;
#line 460 "devhelp-search.c"
}

SynapseDevhelpPlugin*
synapse_devhelp_plugin_construct (GType object_type)
{
	SynapseDevhelpPlugin * self = NULL;
#line 24 "../../../src/plugins/devhelp-search.vala"
	self = (SynapseDevhelpPlugin*) g_object_new (object_type, NULL);
#line 24 "../../../src/plugins/devhelp-search.vala"
	return self;
#line 471 "devhelp-search.c"
}

SynapseDevhelpPlugin*
synapse_devhelp_plugin_new (void)
{
#line 24 "../../../src/plugins/devhelp-search.vala"
	return synapse_devhelp_plugin_construct (SYNAPSE_TYPE_DEVHELP_PLUGIN);
#line 479 "devhelp-search.c"
}

static gboolean
synapse_devhelp_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseDevhelpPlugin* self;
#line 26 "../../../src/plugins/devhelp-search.vala"
	self = (SynapseDevhelpPlugin*) base;
#line 26 "../../../src/plugins/devhelp-search.vala"
	result = self->priv->_enabled;
#line 26 "../../../src/plugins/devhelp-search.vala"
	return result;
#line 493 "devhelp-search.c"
}

static void
synapse_devhelp_plugin_real_set_enabled (SynapseActivatable* base,
                                         gboolean value)
{
	SynapseDevhelpPlugin* self;
	gboolean old_value;
#line 26 "../../../src/plugins/devhelp-search.vala"
	self = (SynapseDevhelpPlugin*) base;
#line 26 "../../../src/plugins/devhelp-search.vala"
	old_value = synapse_devhelp_plugin_real_get_enabled (base);
#line 26 "../../../src/plugins/devhelp-search.vala"
	if (old_value != value) {
#line 26 "../../../src/plugins/devhelp-search.vala"
		self->priv->_enabled = value;
#line 26 "../../../src/plugins/devhelp-search.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_devhelp_plugin_properties[SYNAPSE_DEVHELP_PLUGIN_ENABLED_PROPERTY]);
#line 512 "devhelp-search.c"
	}
}

static inline gpointer
synapse_devhelp_plugin_search_get_instance_private (SynapseDevhelpPluginSearch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDevhelpPluginSearch_private_offset);
}

static void
synapse_devhelp_plugin_search_real_execute (SynapseMatch* base,
                                            SynapseMatch* match)
{
	SynapseDevhelpPluginSearch * self;
	GError* _inner_error0_ = NULL;
#line 42 "../../../src/plugins/devhelp-search.vala"
	self = (SynapseDevhelpPluginSearch*) base;
#line 42 "../../../src/plugins/devhelp-search.vala"
	g_return_if_fail (match != NULL);
#line 532 "devhelp-search.c"
	{
		GAppInfo* ai = NULL;
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GAppInfo* _tmp4_;
		GAppInfo* _tmp5_;
		GAppInfo* _tmp6_;
#line 46 "../../../src/plugins/devhelp-search.vala"
		_tmp0_ = synapse_match_get_title (match);
#line 46 "../../../src/plugins/devhelp-search.vala"
		_tmp1_ = _tmp0_;
#line 46 "../../../src/plugins/devhelp-search.vala"
		_tmp2_ = g_strdup_printf ("devhelp -s \"%s\"", _tmp1_);
#line 46 "../../../src/plugins/devhelp-search.vala"
		_tmp3_ = _tmp2_;
#line 46 "../../../src/plugins/devhelp-search.vala"
		_tmp4_ = g_app_info_create_from_commandline (_tmp3_, "devhelp", 0, &_inner_error0_);
#line 46 "../../../src/plugins/devhelp-search.vala"
		_tmp5_ = _tmp4_;
#line 46 "../../../src/plugins/devhelp-search.vala"
		_g_free0 (_tmp3_);
#line 46 "../../../src/plugins/devhelp-search.vala"
		ai = _tmp5_;
#line 46 "../../../src/plugins/devhelp-search.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 560 "devhelp-search.c"
			goto __catch0_g_error;
		}
#line 49 "../../../src/plugins/devhelp-search.vala"
		_tmp6_ = ai;
#line 49 "../../../src/plugins/devhelp-search.vala"
		g_app_info_launch (_tmp6_, NULL, NULL, &_inner_error0_);
#line 49 "../../../src/plugins/devhelp-search.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 49 "../../../src/plugins/devhelp-search.vala"
			_g_object_unref0 (ai);
#line 571 "devhelp-search.c"
			goto __catch0_g_error;
		}
#line 44 "../../../src/plugins/devhelp-search.vala"
		_g_object_unref0 (ai);
#line 576 "devhelp-search.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 44 "../../../src/plugins/devhelp-search.vala"
		err = _inner_error0_;
#line 44 "../../../src/plugins/devhelp-search.vala"
		_inner_error0_ = NULL;
#line 53 "../../../src/plugins/devhelp-search.vala"
		_tmp7_ = err;
#line 53 "../../../src/plugins/devhelp-search.vala"
		_tmp8_ = _tmp7_->message;
#line 53 "../../../src/plugins/devhelp-search.vala"
		g_warning ("devhelp-search.vala:53: %s", _tmp8_);
#line 44 "../../../src/plugins/devhelp-search.vala"
		_g_error_free0 (err);
#line 596 "devhelp-search.c"
	}
	__finally0:
#line 44 "../../../src/plugins/devhelp-search.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 44 "../../../src/plugins/devhelp-search.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 44 "../../../src/plugins/devhelp-search.vala"
		g_clear_error (&_inner_error0_);
#line 44 "../../../src/plugins/devhelp-search.vala"
		return;
#line 607 "devhelp-search.c"
	}
}

static SynapseDevhelpPluginSearch*
synapse_devhelp_plugin_search_construct (GType object_type)
{
	SynapseDevhelpPluginSearch * self = NULL;
#line 59 "../../../src/plugins/devhelp-search.vala"
	self = (SynapseDevhelpPluginSearch*) g_object_new (object_type, "title", _ ("Search in Devhelp"), "description", _ ("Search documentation for this symbol"), "has-thumbnail", FALSE, "icon-name", "devhelp", NULL);
#line 57 "../../../src/plugins/devhelp-search.vala"
	return self;
#line 619 "devhelp-search.c"
}

static SynapseDevhelpPluginSearch*
synapse_devhelp_plugin_search_new (void)
{
#line 57 "../../../src/plugins/devhelp-search.vala"
	return synapse_devhelp_plugin_search_construct (SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH);
#line 627 "devhelp-search.c"
}

static gint
synapse_devhelp_plugin_search_get_default_relevancy (SynapseDevhelpPluginSearch* self)
{
	gint result;
#line 40 "../../../src/plugins/devhelp-search.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 40 "../../../src/plugins/devhelp-search.vala"
	result = self->priv->_default_relevancy;
#line 40 "../../../src/plugins/devhelp-search.vala"
	return result;
#line 640 "devhelp-search.c"
}

static void
synapse_devhelp_plugin_search_set_default_relevancy (SynapseDevhelpPluginSearch* self,
                                                     gint value)
{
	gint old_value;
#line 40 "../../../src/plugins/devhelp-search.vala"
	g_return_if_fail (self != NULL);
#line 40 "../../../src/plugins/devhelp-search.vala"
	old_value = synapse_devhelp_plugin_search_get_default_relevancy (self);
#line 40 "../../../src/plugins/devhelp-search.vala"
	if (old_value != value) {
#line 40 "../../../src/plugins/devhelp-search.vala"
		self->priv->_default_relevancy = value;
#line 40 "../../../src/plugins/devhelp-search.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_devhelp_plugin_search_properties[SYNAPSE_DEVHELP_PLUGIN_SEARCH_DEFAULT_RELEVANCY_PROPERTY]);
#line 658 "devhelp-search.c"
	}
}

static void
synapse_devhelp_plugin_search_class_init (SynapseDevhelpPluginSearchClass * klass,
                                          gpointer klass_data)
{
#line 38 "../../../src/plugins/devhelp-search.vala"
	synapse_devhelp_plugin_search_parent_class = g_type_class_peek_parent (klass);
#line 38 "../../../src/plugins/devhelp-search.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDevhelpPluginSearch_private_offset);
#line 38 "../../../src/plugins/devhelp-search.vala"
	((SynapseMatchClass *) klass)->execute = (void (*) (SynapseMatch*, SynapseMatch*)) synapse_devhelp_plugin_search_real_execute;
#line 38 "../../../src/plugins/devhelp-search.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_devhelp_plugin_search_get_property;
#line 38 "../../../src/plugins/devhelp-search.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_devhelp_plugin_search_set_property;
#line 38 "../../../src/plugins/devhelp-search.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_devhelp_plugin_search_finalize;
#line 38 "../../../src/plugins/devhelp-search.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DEVHELP_PLUGIN_SEARCH_DEFAULT_RELEVANCY_PROPERTY, synapse_devhelp_plugin_search_properties[SYNAPSE_DEVHELP_PLUGIN_SEARCH_DEFAULT_RELEVANCY_PROPERTY] = g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 680 "devhelp-search.c"
}

static void
synapse_devhelp_plugin_search_instance_init (SynapseDevhelpPluginSearch * self,
                                             gpointer klass)
{
#line 38 "../../../src/plugins/devhelp-search.vala"
	self->priv = synapse_devhelp_plugin_search_get_instance_private (self);
#line 40 "../../../src/plugins/devhelp-search.vala"
	self->priv->_default_relevancy = 0;
#line 691 "devhelp-search.c"
}

static void
synapse_devhelp_plugin_search_finalize (GObject * obj)
{
	SynapseDevhelpPluginSearch * self;
#line 38 "../../../src/plugins/devhelp-search.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH, SynapseDevhelpPluginSearch);
#line 38 "../../../src/plugins/devhelp-search.vala"
	G_OBJECT_CLASS (synapse_devhelp_plugin_search_parent_class)->finalize (obj);
#line 702 "devhelp-search.c"
}

static GType
synapse_devhelp_plugin_search_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDevhelpPluginSearchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_devhelp_plugin_search_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDevhelpPluginSearch), 0, (GInstanceInitFunc) synapse_devhelp_plugin_search_instance_init, NULL };
	GType synapse_devhelp_plugin_search_type_id;
	synapse_devhelp_plugin_search_type_id = g_type_register_static (SYNAPSE_TYPE_MATCH, "SynapseDevhelpPluginSearch", &g_define_type_info, 0);
	SynapseDevhelpPluginSearch_private_offset = g_type_add_instance_private (synapse_devhelp_plugin_search_type_id, sizeof (SynapseDevhelpPluginSearchPrivate));
	return synapse_devhelp_plugin_search_type_id;
}

static GType
synapse_devhelp_plugin_search_get_type (void)
{
	static volatile gsize synapse_devhelp_plugin_search_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_devhelp_plugin_search_type_id__volatile)) {
		GType synapse_devhelp_plugin_search_type_id;
		synapse_devhelp_plugin_search_type_id = synapse_devhelp_plugin_search_get_type_once ();
		g_once_init_leave (&synapse_devhelp_plugin_search_type_id__volatile, synapse_devhelp_plugin_search_type_id);
	}
	return synapse_devhelp_plugin_search_type_id__volatile;
}

static void
_vala_synapse_devhelp_plugin_search_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	SynapseDevhelpPluginSearch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH, SynapseDevhelpPluginSearch);
#line 38 "../../../src/plugins/devhelp-search.vala"
	switch (property_id) {
#line 38 "../../../src/plugins/devhelp-search.vala"
		case SYNAPSE_DEVHELP_PLUGIN_SEARCH_DEFAULT_RELEVANCY_PROPERTY:
#line 38 "../../../src/plugins/devhelp-search.vala"
		g_value_set_int (value, synapse_devhelp_plugin_search_get_default_relevancy (self));
#line 38 "../../../src/plugins/devhelp-search.vala"
		break;
#line 743 "devhelp-search.c"
		default:
#line 38 "../../../src/plugins/devhelp-search.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "../../../src/plugins/devhelp-search.vala"
		break;
#line 749 "devhelp-search.c"
	}
}

static void
_vala_synapse_devhelp_plugin_search_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	SynapseDevhelpPluginSearch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DEVHELP_PLUGIN_TYPE_SEARCH, SynapseDevhelpPluginSearch);
#line 38 "../../../src/plugins/devhelp-search.vala"
	switch (property_id) {
#line 38 "../../../src/plugins/devhelp-search.vala"
		case SYNAPSE_DEVHELP_PLUGIN_SEARCH_DEFAULT_RELEVANCY_PROPERTY:
#line 38 "../../../src/plugins/devhelp-search.vala"
		synapse_devhelp_plugin_search_set_default_relevancy (self, g_value_get_int (value));
#line 38 "../../../src/plugins/devhelp-search.vala"
		break;
#line 769 "devhelp-search.c"
		default:
#line 38 "../../../src/plugins/devhelp-search.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "../../../src/plugins/devhelp-search.vala"
		break;
#line 775 "devhelp-search.c"
	}
}

static GObject *
synapse_devhelp_plugin_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDevhelpPlugin * self;
	SynapseDevhelpPluginSearch* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
#line 86 "../../../src/plugins/devhelp-search.vala"
	parent_class = G_OBJECT_CLASS (synapse_devhelp_plugin_parent_class);
#line 86 "../../../src/plugins/devhelp-search.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 86 "../../../src/plugins/devhelp-search.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DEVHELP_PLUGIN, SynapseDevhelpPlugin);
#line 88 "../../../src/plugins/devhelp-search.vala"
	_tmp0_ = synapse_devhelp_plugin_search_new ();
#line 88 "../../../src/plugins/devhelp-search.vala"
	_g_object_unref0 (self->priv->action);
#line 88 "../../../src/plugins/devhelp-search.vala"
	self->priv->action = _tmp0_;
#line 89 "../../../src/plugins/devhelp-search.vala"
	_tmp1_ = g_find_program_in_path ("devhelp");
#line 89 "../../../src/plugins/devhelp-search.vala"
	_tmp2_ = _tmp1_;
#line 89 "../../../src/plugins/devhelp-search.vala"
	self->priv->has_devhelp = _tmp2_ != NULL;
#line 89 "../../../src/plugins/devhelp-search.vala"
	_g_free0 (_tmp2_);
#line 811 "devhelp-search.c"
	{
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_;
		GRegex* _tmp5_;
#line 94 "../../../src/plugins/devhelp-search.vala"
		_tmp4_ = g_regex_new ("^([a-z]+_)|([A-Z]+[a-z]+[A-Z])", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
#line 94 "../../../src/plugins/devhelp-search.vala"
		_tmp3_ = _tmp4_;
#line 94 "../../../src/plugins/devhelp-search.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 822 "devhelp-search.c"
			goto __catch0_g_error;
		}
#line 94 "../../../src/plugins/devhelp-search.vala"
		_tmp5_ = _tmp3_;
#line 94 "../../../src/plugins/devhelp-search.vala"
		_tmp3_ = NULL;
#line 94 "../../../src/plugins/devhelp-search.vala"
		_g_regex_unref0 (self->priv->symbol_re);
#line 94 "../../../src/plugins/devhelp-search.vala"
		self->priv->symbol_re = _tmp5_;
#line 92 "../../../src/plugins/devhelp-search.vala"
		_g_regex_unref0 (_tmp3_);
#line 835 "devhelp-search.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 92 "../../../src/plugins/devhelp-search.vala"
		err = _inner_error0_;
#line 92 "../../../src/plugins/devhelp-search.vala"
		_inner_error0_ = NULL;
#line 99 "../../../src/plugins/devhelp-search.vala"
		_tmp6_ = err;
#line 99 "../../../src/plugins/devhelp-search.vala"
		_tmp7_ = _tmp6_->message;
#line 99 "../../../src/plugins/devhelp-search.vala"
		g_warning ("devhelp-search.vala:99: %s", _tmp7_);
#line 92 "../../../src/plugins/devhelp-search.vala"
		_g_error_free0 (err);
#line 855 "devhelp-search.c"
	}
	__finally0:
#line 92 "../../../src/plugins/devhelp-search.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 92 "../../../src/plugins/devhelp-search.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 92 "../../../src/plugins/devhelp-search.vala"
		g_clear_error (&_inner_error0_);
#line 864 "devhelp-search.c"
	}
#line 86 "../../../src/plugins/devhelp-search.vala"
	return obj;
#line 868 "devhelp-search.c"
}

static void
synapse_devhelp_plugin_class_init (SynapseDevhelpPluginClass * klass,
                                   gpointer klass_data)
{
#line 24 "../../../src/plugins/devhelp-search.vala"
	synapse_devhelp_plugin_parent_class = g_type_class_peek_parent (klass);
#line 24 "../../../src/plugins/devhelp-search.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDevhelpPlugin_private_offset);
#line 24 "../../../src/plugins/devhelp-search.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_devhelp_plugin_get_property;
#line 24 "../../../src/plugins/devhelp-search.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_devhelp_plugin_set_property;
#line 24 "../../../src/plugins/devhelp-search.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_devhelp_plugin_constructor;
#line 24 "../../../src/plugins/devhelp-search.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_devhelp_plugin_finalize;
#line 24 "../../../src/plugins/devhelp-search.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DEVHELP_PLUGIN_ENABLED_PROPERTY, synapse_devhelp_plugin_properties[SYNAPSE_DEVHELP_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 80 "../../../src/plugins/devhelp-search.vala"
	synapse_devhelp_plugin_register_plugin ();
#line 891 "devhelp-search.c"
}

static void
synapse_devhelp_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                           gpointer iface_data)
{
#line 24 "../../../src/plugins/devhelp-search.vala"
	synapse_devhelp_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../../../src/plugins/devhelp-search.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_devhelp_plugin_real_activate;
#line 24 "../../../src/plugins/devhelp-search.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_devhelp_plugin_real_deactivate;
#line 24 "../../../src/plugins/devhelp-search.vala"
	iface->get_enabled = synapse_devhelp_plugin_real_get_enabled;
#line 24 "../../../src/plugins/devhelp-search.vala"
	iface->set_enabled = synapse_devhelp_plugin_real_set_enabled;
#line 908 "devhelp-search.c"
}

static void
synapse_devhelp_plugin_synapse_action_provider_interface_init (SynapseActionProviderIface * iface,
                                                               gpointer iface_data)
{
#line 24 "../../../src/plugins/devhelp-search.vala"
	synapse_devhelp_plugin_synapse_action_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../../../src/plugins/devhelp-search.vala"
	iface->handles_unknown = (gboolean (*) (SynapseActionProvider*)) synapse_devhelp_plugin_real_handles_unknown;
#line 24 "../../../src/plugins/devhelp-search.vala"
	iface->find_for_match = (SynapseResultSet* (*) (SynapseActionProvider*, SynapseQuery*, SynapseMatch*)) synapse_devhelp_plugin_real_find_for_match;
#line 921 "devhelp-search.c"
}

static void
synapse_devhelp_plugin_instance_init (SynapseDevhelpPlugin * self,
                                      gpointer klass)
{
#line 24 "../../../src/plugins/devhelp-search.vala"
	self->priv = synapse_devhelp_plugin_get_instance_private (self);
#line 26 "../../../src/plugins/devhelp-search.vala"
	self->priv->_enabled = TRUE;
#line 932 "devhelp-search.c"
}

static void
synapse_devhelp_plugin_finalize (GObject * obj)
{
	SynapseDevhelpPlugin * self;
#line 24 "../../../src/plugins/devhelp-search.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DEVHELP_PLUGIN, SynapseDevhelpPlugin);
#line 83 "../../../src/plugins/devhelp-search.vala"
	_g_object_unref0 (self->priv->action);
#line 108 "../../../src/plugins/devhelp-search.vala"
	_g_regex_unref0 (self->priv->symbol_re);
#line 24 "../../../src/plugins/devhelp-search.vala"
	G_OBJECT_CLASS (synapse_devhelp_plugin_parent_class)->finalize (obj);
#line 947 "devhelp-search.c"
}

static GType
synapse_devhelp_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDevhelpPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_devhelp_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDevhelpPlugin), 0, (GInstanceInitFunc) synapse_devhelp_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_devhelp_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_action_provider_info = { (GInterfaceInitFunc) synapse_devhelp_plugin_synapse_action_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_devhelp_plugin_type_id;
	synapse_devhelp_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDevhelpPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_devhelp_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_devhelp_plugin_type_id, SYNAPSE_TYPE_ACTION_PROVIDER, &synapse_action_provider_info);
	SynapseDevhelpPlugin_private_offset = g_type_add_instance_private (synapse_devhelp_plugin_type_id, sizeof (SynapseDevhelpPluginPrivate));
	return synapse_devhelp_plugin_type_id;
}

GType
synapse_devhelp_plugin_get_type (void)
{
	static volatile gsize synapse_devhelp_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_devhelp_plugin_type_id__volatile)) {
		GType synapse_devhelp_plugin_type_id;
		synapse_devhelp_plugin_type_id = synapse_devhelp_plugin_get_type_once ();
		g_once_init_leave (&synapse_devhelp_plugin_type_id__volatile, synapse_devhelp_plugin_type_id);
	}
	return synapse_devhelp_plugin_type_id__volatile;
}

static void
_vala_synapse_devhelp_plugin_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SynapseDevhelpPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DEVHELP_PLUGIN, SynapseDevhelpPlugin);
#line 24 "../../../src/plugins/devhelp-search.vala"
	switch (property_id) {
#line 24 "../../../src/plugins/devhelp-search.vala"
		case SYNAPSE_DEVHELP_PLUGIN_ENABLED_PROPERTY:
#line 24 "../../../src/plugins/devhelp-search.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 24 "../../../src/plugins/devhelp-search.vala"
		break;
#line 992 "devhelp-search.c"
		default:
#line 24 "../../../src/plugins/devhelp-search.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../../../src/plugins/devhelp-search.vala"
		break;
#line 998 "devhelp-search.c"
	}
}

static void
_vala_synapse_devhelp_plugin_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	SynapseDevhelpPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DEVHELP_PLUGIN, SynapseDevhelpPlugin);
#line 24 "../../../src/plugins/devhelp-search.vala"
	switch (property_id) {
#line 24 "../../../src/plugins/devhelp-search.vala"
		case SYNAPSE_DEVHELP_PLUGIN_ENABLED_PROPERTY:
#line 24 "../../../src/plugins/devhelp-search.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 24 "../../../src/plugins/devhelp-search.vala"
		break;
#line 1018 "devhelp-search.c"
		default:
#line 24 "../../../src/plugins/devhelp-search.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../../../src/plugins/devhelp-search.vala"
		break;
#line 1024 "devhelp-search.c"
	}
}

