/* gnome-session-plugin.c generated by valac 0.48.17, the Vala compiler
 * generated from gnome-session-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <synapse-core.h>
#include <gee.h>
#include <glib/gi18n-lib.h>

#define SYNAPSE_TYPE_GNOME_SESSION_MANAGER (synapse_gnome_session_manager_get_type ())
#define SYNAPSE_GNOME_SESSION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_GNOME_SESSION_MANAGER, SynapseGnomeSessionManager))
#define SYNAPSE_IS_GNOME_SESSION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_GNOME_SESSION_MANAGER))
#define SYNAPSE_GNOME_SESSION_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SYNAPSE_TYPE_GNOME_SESSION_MANAGER, SynapseGnomeSessionManagerIface))

typedef struct _SynapseGnomeSessionManager SynapseGnomeSessionManager;
typedef struct _SynapseGnomeSessionManagerIface SynapseGnomeSessionManagerIface;

#define SYNAPSE_TYPE_GNOME_SESSION_MANAGER_PROXY (synapse_gnome_session_manager_proxy_get_type ())
typedef GDBusProxy SynapseGnomeSessionManagerProxy;
typedef GDBusProxyClass SynapseGnomeSessionManagerProxyClass;

#define SYNAPSE_TYPE_GNOME_SESSION_PLUGIN (synapse_gnome_session_plugin_get_type ())
#define SYNAPSE_GNOME_SESSION_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_GNOME_SESSION_PLUGIN, SynapseGnomeSessionPlugin))
#define SYNAPSE_GNOME_SESSION_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_GNOME_SESSION_PLUGIN, SynapseGnomeSessionPluginClass))
#define SYNAPSE_IS_GNOME_SESSION_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_GNOME_SESSION_PLUGIN))
#define SYNAPSE_IS_GNOME_SESSION_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_GNOME_SESSION_PLUGIN))
#define SYNAPSE_GNOME_SESSION_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_GNOME_SESSION_PLUGIN, SynapseGnomeSessionPluginClass))

typedef struct _SynapseGnomeSessionPlugin SynapseGnomeSessionPlugin;
typedef struct _SynapseGnomeSessionPluginClass SynapseGnomeSessionPluginClass;
typedef struct _SynapseGnomeSessionPluginPrivate SynapseGnomeSessionPluginPrivate;
enum  {
	SYNAPSE_GNOME_SESSION_PLUGIN_0_PROPERTY,
	SYNAPSE_GNOME_SESSION_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_GNOME_SESSION_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_gnome_session_plugin_properties[SYNAPSE_GNOME_SESSION_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SynapseGnomeSessionPluginSearchData SynapseGnomeSessionPluginSearchData;

#define SYNAPSE_GNOME_SESSION_PLUGIN_TYPE_SHUT_DOWN_ACTION (synapse_gnome_session_plugin_shut_down_action_get_type ())
#define SYNAPSE_GNOME_SESSION_PLUGIN_SHUT_DOWN_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_GNOME_SESSION_PLUGIN_TYPE_SHUT_DOWN_ACTION, SynapseGnomeSessionPluginShutDownAction))
#define SYNAPSE_GNOME_SESSION_PLUGIN_SHUT_DOWN_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_GNOME_SESSION_PLUGIN_TYPE_SHUT_DOWN_ACTION, SynapseGnomeSessionPluginShutDownActionClass))
#define SYNAPSE_GNOME_SESSION_PLUGIN_IS_SHUT_DOWN_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_GNOME_SESSION_PLUGIN_TYPE_SHUT_DOWN_ACTION))
#define SYNAPSE_GNOME_SESSION_PLUGIN_IS_SHUT_DOWN_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_GNOME_SESSION_PLUGIN_TYPE_SHUT_DOWN_ACTION))
#define SYNAPSE_GNOME_SESSION_PLUGIN_SHUT_DOWN_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_GNOME_SESSION_PLUGIN_TYPE_SHUT_DOWN_ACTION, SynapseGnomeSessionPluginShutDownActionClass))

typedef struct _SynapseGnomeSessionPluginShutDownAction SynapseGnomeSessionPluginShutDownAction;
typedef struct _SynapseGnomeSessionPluginShutDownActionClass SynapseGnomeSessionPluginShutDownActionClass;
typedef struct _SynapseGnomeSessionPluginShutDownActionPrivate SynapseGnomeSessionPluginShutDownActionPrivate;
enum  {
	SYNAPSE_GNOME_SESSION_PLUGIN_SHUT_DOWN_ACTION_0_PROPERTY,
	SYNAPSE_GNOME_SESSION_PLUGIN_SHUT_DOWN_ACTION_NUM_PROPERTIES
};
static GParamSpec* synapse_gnome_session_plugin_shut_down_action_properties[SYNAPSE_GNOME_SESSION_PLUGIN_SHUT_DOWN_ACTION_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SYNAPSE_GNOME_SESSION_PLUGIN_TYPE_REBOOT_ACTION (synapse_gnome_session_plugin_reboot_action_get_type ())
#define SYNAPSE_GNOME_SESSION_PLUGIN_REBOOT_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_GNOME_SESSION_PLUGIN_TYPE_REBOOT_ACTION, SynapseGnomeSessionPluginRebootAction))
#define SYNAPSE_GNOME_SESSION_PLUGIN_REBOOT_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_GNOME_SESSION_PLUGIN_TYPE_REBOOT_ACTION, SynapseGnomeSessionPluginRebootActionClass))
#define SYNAPSE_GNOME_SESSION_PLUGIN_IS_REBOOT_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_GNOME_SESSION_PLUGIN_TYPE_REBOOT_ACTION))
#define SYNAPSE_GNOME_SESSION_PLUGIN_IS_REBOOT_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_GNOME_SESSION_PLUGIN_TYPE_REBOOT_ACTION))
#define SYNAPSE_GNOME_SESSION_PLUGIN_REBOOT_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_GNOME_SESSION_PLUGIN_TYPE_REBOOT_ACTION, SynapseGnomeSessionPluginRebootActionClass))

typedef struct _SynapseGnomeSessionPluginRebootAction SynapseGnomeSessionPluginRebootAction;
typedef struct _SynapseGnomeSessionPluginRebootActionClass SynapseGnomeSessionPluginRebootActionClass;
typedef struct _SynapseGnomeSessionPluginRebootActionPrivate SynapseGnomeSessionPluginRebootActionPrivate;
enum  {
	SYNAPSE_GNOME_SESSION_PLUGIN_REBOOT_ACTION_0_PROPERTY,
	SYNAPSE_GNOME_SESSION_PLUGIN_REBOOT_ACTION_NUM_PROPERTIES
};
static GParamSpec* synapse_gnome_session_plugin_reboot_action_properties[SYNAPSE_GNOME_SESSION_PLUGIN_REBOOT_ACTION_NUM_PROPERTIES];

#define SYNAPSE_GNOME_SESSION_PLUGIN_TYPE_LOG_OUT_ACTION (synapse_gnome_session_plugin_log_out_action_get_type ())
#define SYNAPSE_GNOME_SESSION_PLUGIN_LOG_OUT_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_GNOME_SESSION_PLUGIN_TYPE_LOG_OUT_ACTION, SynapseGnomeSessionPluginLogOutAction))
#define SYNAPSE_GNOME_SESSION_PLUGIN_LOG_OUT_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_GNOME_SESSION_PLUGIN_TYPE_LOG_OUT_ACTION, SynapseGnomeSessionPluginLogOutActionClass))
#define SYNAPSE_GNOME_SESSION_PLUGIN_IS_LOG_OUT_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_GNOME_SESSION_PLUGIN_TYPE_LOG_OUT_ACTION))
#define SYNAPSE_GNOME_SESSION_PLUGIN_IS_LOG_OUT_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_GNOME_SESSION_PLUGIN_TYPE_LOG_OUT_ACTION))
#define SYNAPSE_GNOME_SESSION_PLUGIN_LOG_OUT_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_GNOME_SESSION_PLUGIN_TYPE_LOG_OUT_ACTION, SynapseGnomeSessionPluginLogOutActionClass))

typedef struct _SynapseGnomeSessionPluginLogOutAction SynapseGnomeSessionPluginLogOutAction;
typedef struct _SynapseGnomeSessionPluginLogOutActionClass SynapseGnomeSessionPluginLogOutActionClass;
typedef struct _SynapseGnomeSessionPluginLogOutActionPrivate SynapseGnomeSessionPluginLogOutActionPrivate;
enum  {
	SYNAPSE_GNOME_SESSION_PLUGIN_LOG_OUT_ACTION_0_PROPERTY,
	SYNAPSE_GNOME_SESSION_PLUGIN_LOG_OUT_ACTION_NUM_PROPERTIES
};
static GParamSpec* synapse_gnome_session_plugin_log_out_action_properties[SYNAPSE_GNOME_SESSION_PLUGIN_LOG_OUT_ACTION_NUM_PROPERTIES];

struct _SynapseGnomeSessionManagerIface {
	GTypeInterface parent_iface;
	gboolean (*can_shutdown) (SynapseGnomeSessionManager* self, GError** error);
	void (*shutdown) (SynapseGnomeSessionManager* self, GError** error);
	void (*request_reboot) (SynapseGnomeSessionManager* self, GError** error);
	void (*logout) (SynapseGnomeSessionManager* self, guint32 mode, GError** error);
};

struct _SynapseGnomeSessionPlugin {
	GObject parent_instance;
	SynapseGnomeSessionPluginPrivate * priv;
};

struct _SynapseGnomeSessionPluginClass {
	GObjectClass parent_class;
};

struct _SynapseGnomeSessionPluginPrivate {
	gboolean _enabled;
	gboolean session_manager_available;
	GeeList* actions;
};

struct _SynapseGnomeSessionPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseGnomeSessionPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	SynapseQuery _tmp0_;
	SynapseQueryFlags _tmp1_;
	SynapseResultSet* _result_;
	SynapseResultSet* _tmp2_;
	GeeList* matchers;
	SynapseQuery _tmp3_;
	const gchar* _tmp4_;
	GeeList* _tmp5_;
	GeeList* _action_list;
	GeeList* _tmp6_;
	GeeList* _tmp7_;
	gint _action_size;
	GeeList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _action_index;
	gint _tmp11_;
	gint _tmp12_;
	SynapseMatch* action;
	GeeList* _tmp13_;
	gpointer _tmp14_;
	GeeList* _matcher_list;
	GeeList* _tmp15_;
	GeeList* _tmp16_;
	gint _matcher_size;
	GeeList* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _matcher_index;
	gint _tmp20_;
	gint _tmp21_;
	GeeMapEntry* matcher;
	GeeList* _tmp22_;
	gpointer _tmp23_;
	GeeMapEntry* _tmp24_;
	gconstpointer _tmp25_;
	gconstpointer _tmp26_;
	SynapseMatch* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	SynapseResultSet* _tmp30_;
	SynapseMatch* _tmp31_;
	GeeMapEntry* _tmp32_;
	gconstpointer _tmp33_;
	gconstpointer _tmp34_;
	GError* _inner_error0_;
};

struct _SynapseGnomeSessionPluginShutDownAction {
	SynapseActionMatch parent_instance;
	SynapseGnomeSessionPluginShutDownActionPrivate * priv;
};

struct _SynapseGnomeSessionPluginShutDownActionClass {
	SynapseActionMatchClass parent_class;
};

struct _SynapseGnomeSessionPluginRebootAction {
	SynapseActionMatch parent_instance;
	SynapseGnomeSessionPluginRebootActionPrivate * priv;
};

struct _SynapseGnomeSessionPluginRebootActionClass {
	SynapseActionMatchClass parent_class;
};

struct _SynapseGnomeSessionPluginLogOutAction {
	SynapseActionMatch parent_instance;
	SynapseGnomeSessionPluginLogOutActionPrivate * priv;
};

struct _SynapseGnomeSessionPluginLogOutActionClass {
	SynapseActionMatchClass parent_class;
};

static gint SynapseGnomeSessionPlugin_private_offset;
static gpointer synapse_gnome_session_plugin_parent_class = NULL;
static gpointer synapse_gnome_session_plugin_shut_down_action_parent_class = NULL;
static gpointer synapse_gnome_session_plugin_reboot_action_parent_class = NULL;
static gpointer synapse_gnome_session_plugin_log_out_action_parent_class = NULL;
static SynapseActivatableIface * synapse_gnome_session_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_gnome_session_plugin_synapse_item_provider_parent_iface = NULL;

GType synapse_gnome_session_manager_proxy_get_type (void) G_GNUC_CONST;
guint synapse_gnome_session_manager_register_object (void* object,
                                                     GDBusConnection* connection,
                                                     const gchar* path,
                                                     GError** error);
GType synapse_gnome_session_manager_get_type (void) G_GNUC_CONST;
#define SYNAPSE_GNOME_SESSION_MANAGER_UNIQUE_NAME "org.gnome.SessionManager"
#define SYNAPSE_GNOME_SESSION_MANAGER_OBJECT_PATH "/org/gnome/SessionManager"
gboolean synapse_gnome_session_manager_can_shutdown (SynapseGnomeSessionManager* self,
                                                     GError** error);
void synapse_gnome_session_manager_shutdown (SynapseGnomeSessionManager* self,
                                             GError** error);
void synapse_gnome_session_manager_request_reboot (SynapseGnomeSessionManager* self,
                                                   GError** error);
void synapse_gnome_session_manager_logout (SynapseGnomeSessionManager* self,
                                           guint32 mode,
                                           GError** error);
static GType synapse_gnome_session_manager_get_type_once (void);
static void synapse_gnome_session_manager_proxy_g_signal (GDBusProxy* proxy,
                                                   const gchar* sender_name,
                                                   const gchar* signal_name,
                                                   GVariant* parameters);
static gboolean synapse_gnome_session_manager_proxy_can_shutdown (SynapseGnomeSessionManager* self,
                                                           GError** error);
static void synapse_gnome_session_manager_proxy_shutdown (SynapseGnomeSessionManager* self,
                                                   GError** error);
static void synapse_gnome_session_manager_proxy_request_reboot (SynapseGnomeSessionManager* self,
                                                         GError** error);
static void synapse_gnome_session_manager_proxy_logout (SynapseGnomeSessionManager* self,
                                                 guint32 mode,
                                                 GError** error);
static void synapse_gnome_session_manager_proxy_synapse_gnome_session_manager_interface_init (SynapseGnomeSessionManagerIface* iface);
static void _dbus_synapse_gnome_session_manager_can_shutdown (SynapseGnomeSessionManager* self,
                                                       GVariant* _parameters_,
                                                       GDBusMethodInvocation* invocation);
static void _dbus_synapse_gnome_session_manager_shutdown (SynapseGnomeSessionManager* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation);
static void _dbus_synapse_gnome_session_manager_request_reboot (SynapseGnomeSessionManager* self,
                                                         GVariant* _parameters_,
                                                         GDBusMethodInvocation* invocation);
static void _dbus_synapse_gnome_session_manager_logout (SynapseGnomeSessionManager* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void synapse_gnome_session_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                               const gchar* sender,
                                                               const gchar* object_path,
                                                               const gchar* interface_name,
                                                               const gchar* method_name,
                                                               GVariant* parameters,
                                                               GDBusMethodInvocation* invocation,
                                                               gpointer user_data);
static GVariant* synapse_gnome_session_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                                     const gchar* sender,
                                                                     const gchar* object_path,
                                                                     const gchar* interface_name,
                                                                     const gchar* property_name,
                                                                     GError** error,
                                                                     gpointer user_data);
static gboolean synapse_gnome_session_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                                    const gchar* sender,
                                                                    const gchar* object_path,
                                                                    const gchar* interface_name,
                                                                    const gchar* property_name,
                                                                    GVariant* value,
                                                                    GError** error,
                                                                    gpointer user_data);
static void _synapse_gnome_session_manager_unregister_object (gpointer user_data);
GType synapse_gnome_session_plugin_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseGnomeSessionPlugin, g_object_unref)
static void synapse_gnome_session_plugin_real_activate (SynapseActivatable* base);
static void synapse_gnome_session_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_gnome_session_plugin_register_plugin (void);
static void _synapse_gnome_session_plugin_register_plugin_synapse_plugin_register_func (void);
static void synapse_gnome_session_plugin_real_search_data_free (gpointer _data);
static void synapse_gnome_session_plugin_real_search (SynapseItemProvider* base,
                                               SynapseQuery* q,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean synapse_gnome_session_plugin_real_search_co (SynapseGnomeSessionPluginSearchData* _data_);
SynapseGnomeSessionPlugin* synapse_gnome_session_plugin_new (void);
SynapseGnomeSessionPlugin* synapse_gnome_session_plugin_construct (GType object_type);
static GType synapse_gnome_session_plugin_shut_down_action_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseGnomeSessionPluginShutDownAction, g_object_unref)
static SynapseGnomeSessionPluginShutDownAction* synapse_gnome_session_plugin_shut_down_action_new (void);
static SynapseGnomeSessionPluginShutDownAction* synapse_gnome_session_plugin_shut_down_action_construct (GType object_type);
static void synapse_gnome_session_plugin_shut_down_action_real_do_action (SynapseActionMatch* base);
static GType synapse_gnome_session_plugin_shut_down_action_get_type_once (void);
static GType synapse_gnome_session_plugin_reboot_action_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseGnomeSessionPluginRebootAction, g_object_unref)
static SynapseGnomeSessionPluginRebootAction* synapse_gnome_session_plugin_reboot_action_new (void);
static SynapseGnomeSessionPluginRebootAction* synapse_gnome_session_plugin_reboot_action_construct (GType object_type);
static void synapse_gnome_session_plugin_reboot_action_real_do_action (SynapseActionMatch* base);
static GType synapse_gnome_session_plugin_reboot_action_get_type_once (void);
static GType synapse_gnome_session_plugin_log_out_action_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseGnomeSessionPluginLogOutAction, g_object_unref)
static SynapseGnomeSessionPluginLogOutAction* synapse_gnome_session_plugin_log_out_action_new (void);
static SynapseGnomeSessionPluginLogOutAction* synapse_gnome_session_plugin_log_out_action_construct (GType object_type);
static void synapse_gnome_session_plugin_log_out_action_real_do_action (SynapseActionMatch* base);
static GType synapse_gnome_session_plugin_log_out_action_get_type_once (void);
static GObject * synapse_gnome_session_plugin_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void synapse_gnome_session_plugin_finalize (GObject * obj);
static GType synapse_gnome_session_plugin_get_type_once (void);
static void _vala_synapse_gnome_session_plugin_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_synapse_gnome_session_plugin_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);

static const GDBusArgInfo _synapse_gnome_session_manager_dbus_arg_info_can_shutdown_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _synapse_gnome_session_manager_dbus_arg_info_can_shutdown_in[] = {NULL};
static const GDBusArgInfo * const _synapse_gnome_session_manager_dbus_arg_info_can_shutdown_out[] = {&_synapse_gnome_session_manager_dbus_arg_info_can_shutdown_result, NULL};
static const GDBusMethodInfo _synapse_gnome_session_manager_dbus_method_info_can_shutdown = {-1, "CanShutdown", (GDBusArgInfo **) (&_synapse_gnome_session_manager_dbus_arg_info_can_shutdown_in), (GDBusArgInfo **) (&_synapse_gnome_session_manager_dbus_arg_info_can_shutdown_out), NULL};
static const GDBusArgInfo * const _synapse_gnome_session_manager_dbus_arg_info_shutdown_in[] = {NULL};
static const GDBusArgInfo * const _synapse_gnome_session_manager_dbus_arg_info_shutdown_out[] = {NULL};
static const GDBusMethodInfo _synapse_gnome_session_manager_dbus_method_info_shutdown = {-1, "Shutdown", (GDBusArgInfo **) (&_synapse_gnome_session_manager_dbus_arg_info_shutdown_in), (GDBusArgInfo **) (&_synapse_gnome_session_manager_dbus_arg_info_shutdown_out), NULL};
static const GDBusArgInfo * const _synapse_gnome_session_manager_dbus_arg_info_request_reboot_in[] = {NULL};
static const GDBusArgInfo * const _synapse_gnome_session_manager_dbus_arg_info_request_reboot_out[] = {NULL};
static const GDBusMethodInfo _synapse_gnome_session_manager_dbus_method_info_request_reboot = {-1, "RequestReboot", (GDBusArgInfo **) (&_synapse_gnome_session_manager_dbus_arg_info_request_reboot_in), (GDBusArgInfo **) (&_synapse_gnome_session_manager_dbus_arg_info_request_reboot_out), NULL};
static const GDBusArgInfo _synapse_gnome_session_manager_dbus_arg_info_logout_mode = {-1, "mode", "u", NULL};
static const GDBusArgInfo * const _synapse_gnome_session_manager_dbus_arg_info_logout_in[] = {&_synapse_gnome_session_manager_dbus_arg_info_logout_mode, NULL};
static const GDBusArgInfo * const _synapse_gnome_session_manager_dbus_arg_info_logout_out[] = {NULL};
static const GDBusMethodInfo _synapse_gnome_session_manager_dbus_method_info_logout = {-1, "Logout", (GDBusArgInfo **) (&_synapse_gnome_session_manager_dbus_arg_info_logout_in), (GDBusArgInfo **) (&_synapse_gnome_session_manager_dbus_arg_info_logout_out), NULL};
static const GDBusMethodInfo * const _synapse_gnome_session_manager_dbus_method_info[] = {&_synapse_gnome_session_manager_dbus_method_info_can_shutdown, &_synapse_gnome_session_manager_dbus_method_info_shutdown, &_synapse_gnome_session_manager_dbus_method_info_request_reboot, &_synapse_gnome_session_manager_dbus_method_info_logout, NULL};
static const GDBusSignalInfo * const _synapse_gnome_session_manager_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _synapse_gnome_session_manager_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _synapse_gnome_session_manager_dbus_interface_info = {-1, "org.gnome.SessionManager", (GDBusMethodInfo **) (&_synapse_gnome_session_manager_dbus_method_info), (GDBusSignalInfo **) (&_synapse_gnome_session_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_synapse_gnome_session_manager_dbus_property_info), NULL};
static const GDBusInterfaceVTable _synapse_gnome_session_manager_dbus_interface_vtable = {synapse_gnome_session_manager_dbus_interface_method_call, synapse_gnome_session_manager_dbus_interface_get_property, synapse_gnome_session_manager_dbus_interface_set_property};

gboolean
synapse_gnome_session_manager_can_shutdown (SynapseGnomeSessionManager* self,
                                            GError** error)
{
#line 30 "../../../src/plugins/gnome-session-plugin.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 30 "../../../src/plugins/gnome-session-plugin.vala"
	return SYNAPSE_GNOME_SESSION_MANAGER_GET_INTERFACE (self)->can_shutdown (self, error);
#line 371 "gnome-session-plugin.c"
}

void
synapse_gnome_session_manager_shutdown (SynapseGnomeSessionManager* self,
                                        GError** error)
{
#line 31 "../../../src/plugins/gnome-session-plugin.vala"
	g_return_if_fail (self != NULL);
#line 31 "../../../src/plugins/gnome-session-plugin.vala"
	SYNAPSE_GNOME_SESSION_MANAGER_GET_INTERFACE (self)->shutdown (self, error);
#line 382 "gnome-session-plugin.c"
}

void
synapse_gnome_session_manager_request_reboot (SynapseGnomeSessionManager* self,
                                              GError** error)
{
#line 32 "../../../src/plugins/gnome-session-plugin.vala"
	g_return_if_fail (self != NULL);
#line 32 "../../../src/plugins/gnome-session-plugin.vala"
	SYNAPSE_GNOME_SESSION_MANAGER_GET_INTERFACE (self)->request_reboot (self, error);
#line 393 "gnome-session-plugin.c"
}

void
synapse_gnome_session_manager_logout (SynapseGnomeSessionManager* self,
                                      guint32 mode,
                                      GError** error)
{
#line 33 "../../../src/plugins/gnome-session-plugin.vala"
	g_return_if_fail (self != NULL);
#line 33 "../../../src/plugins/gnome-session-plugin.vala"
	SYNAPSE_GNOME_SESSION_MANAGER_GET_INTERFACE (self)->logout (self, mode, error);
#line 405 "gnome-session-plugin.c"
}

static void
synapse_gnome_session_manager_default_init (SynapseGnomeSessionManagerIface * iface,
                                            gpointer iface_data)
{
}

static GType
synapse_gnome_session_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseGnomeSessionManagerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_gnome_session_manager_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType synapse_gnome_session_manager_type_id;
	synapse_gnome_session_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseGnomeSessionManager", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (synapse_gnome_session_manager_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (synapse_gnome_session_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) synapse_gnome_session_manager_proxy_get_type);
	g_type_set_qdata (synapse_gnome_session_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.SessionManager");
	g_type_set_qdata (synapse_gnome_session_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_synapse_gnome_session_manager_dbus_interface_info));
	g_type_set_qdata (synapse_gnome_session_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) synapse_gnome_session_manager_register_object);
	return synapse_gnome_session_manager_type_id;
}

GType
synapse_gnome_session_manager_get_type (void)
{
	static volatile gsize synapse_gnome_session_manager_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_gnome_session_manager_type_id__volatile)) {
		GType synapse_gnome_session_manager_type_id;
		synapse_gnome_session_manager_type_id = synapse_gnome_session_manager_get_type_once ();
		g_once_init_leave (&synapse_gnome_session_manager_type_id__volatile, synapse_gnome_session_manager_type_id);
	}
	return synapse_gnome_session_manager_type_id__volatile;
}

G_DEFINE_TYPE_EXTENDED (SynapseGnomeSessionManagerProxy, synapse_gnome_session_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (SYNAPSE_TYPE_GNOME_SESSION_MANAGER, synapse_gnome_session_manager_proxy_synapse_gnome_session_manager_interface_init) )
static void
synapse_gnome_session_manager_proxy_class_init (SynapseGnomeSessionManagerProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = synapse_gnome_session_manager_proxy_g_signal;
}

static void
synapse_gnome_session_manager_proxy_g_signal (GDBusProxy* proxy,
                                              const gchar* sender_name,
                                              const gchar* signal_name,
                                              GVariant* parameters)
{
}

static void
synapse_gnome_session_manager_proxy_init (SynapseGnomeSessionManagerProxy* self)
{
}

static gboolean
synapse_gnome_session_manager_proxy_can_shutdown (SynapseGnomeSessionManager* self,
                                                  GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result = FALSE;
	GVariant* _tmp7_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.SessionManager", "CanShutdown");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		gboolean _tmp5_ = FALSE;
		return _tmp5_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		gboolean _tmp6_ = FALSE;
		g_object_unref (_reply_message);
		return _tmp6_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp7_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp7_);
	g_variant_unref (_tmp7_);
	g_object_unref (_reply_message);
	return _result;
}

static void
synapse_gnome_session_manager_proxy_shutdown (SynapseGnomeSessionManager* self,
                                              GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.SessionManager", "Shutdown");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
synapse_gnome_session_manager_proxy_request_reboot (SynapseGnomeSessionManager* self,
                                                    GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.SessionManager", "RequestReboot");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
synapse_gnome_session_manager_proxy_logout (SynapseGnomeSessionManager* self,
                                            guint32 mode,
                                            GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.SessionManager", "Logout");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (mode));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
synapse_gnome_session_manager_proxy_synapse_gnome_session_manager_interface_init (SynapseGnomeSessionManagerIface* iface)
{
	iface->can_shutdown = synapse_gnome_session_manager_proxy_can_shutdown;
	iface->shutdown = synapse_gnome_session_manager_proxy_shutdown;
	iface->request_reboot = synapse_gnome_session_manager_proxy_request_reboot;
	iface->logout = synapse_gnome_session_manager_proxy_logout;
}

static void
_dbus_synapse_gnome_session_manager_can_shutdown (SynapseGnomeSessionManager* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = synapse_gnome_session_manager_can_shutdown (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		g_error_free (error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_synapse_gnome_session_manager_shutdown (SynapseGnomeSessionManager* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	synapse_gnome_session_manager_shutdown (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		g_error_free (error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_synapse_gnome_session_manager_request_reboot (SynapseGnomeSessionManager* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	synapse_gnome_session_manager_request_reboot (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		g_error_free (error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_synapse_gnome_session_manager_logout (SynapseGnomeSessionManager* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 mode = 0U;
	GVariant* _tmp8_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	mode = g_variant_get_uint32 (_tmp8_);
	g_variant_unref (_tmp8_);
	synapse_gnome_session_manager_logout (self, mode, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		g_error_free (error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
synapse_gnome_session_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* method_name,
                                                          GVariant* parameters,
                                                          GDBusMethodInvocation* invocation,
                                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "CanShutdown") == 0) {
		_dbus_synapse_gnome_session_manager_can_shutdown (object, parameters, invocation);
	} else if (strcmp (method_name, "Shutdown") == 0) {
		_dbus_synapse_gnome_session_manager_shutdown (object, parameters, invocation);
	} else if (strcmp (method_name, "RequestReboot") == 0) {
		_dbus_synapse_gnome_session_manager_request_reboot (object, parameters, invocation);
	} else if (strcmp (method_name, "Logout") == 0) {
		_dbus_synapse_gnome_session_manager_logout (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
synapse_gnome_session_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GError** error,
                                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
synapse_gnome_session_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GVariant* value,
                                                           GError** error,
                                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
synapse_gnome_session_manager_register_object (gpointer object,
                                               GDBusConnection* connection,
                                               const gchar* path,
                                               GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_synapse_gnome_session_manager_dbus_interface_info), &_synapse_gnome_session_manager_dbus_interface_vtable, data, _synapse_gnome_session_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_synapse_gnome_session_manager_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
synapse_gnome_session_plugin_get_instance_private (SynapseGnomeSessionPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseGnomeSessionPlugin_private_offset);
}

static void
synapse_gnome_session_plugin_real_activate (SynapseActivatable* base)
{
	SynapseGnomeSessionPlugin * self;
#line 40 "../../../src/plugins/gnome-session-plugin.vala"
	self = (SynapseGnomeSessionPlugin*) base;
#line 792 "gnome-session-plugin.c"
}

static void
synapse_gnome_session_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseGnomeSessionPlugin * self;
#line 45 "../../../src/plugins/gnome-session-plugin.vala"
	self = (SynapseGnomeSessionPlugin*) base;
#line 801 "gnome-session-plugin.c"
}

static void
_synapse_gnome_session_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 135 "../../../src/plugins/gnome-session-plugin.vala"
	synapse_gnome_session_plugin_register_plugin ();
#line 809 "gnome-session-plugin.c"
}

static void
synapse_gnome_session_plugin_register_plugin (void)
{
	SynapsePluginRegistry* _tmp0_;
	SynapsePluginRegistry* _tmp1_;
	SynapseDBusService* _tmp2_;
	SynapseDBusService* _tmp3_;
#line 135 "../../../src/plugins/gnome-session-plugin.vala"
	_tmp0_ = synapse_plugin_registry_get_default ();
#line 135 "../../../src/plugins/gnome-session-plugin.vala"
	_tmp1_ = _tmp0_;
#line 135 "../../../src/plugins/gnome-session-plugin.vala"
	_tmp2_ = synapse_dbus_service_get_default ();
#line 135 "../../../src/plugins/gnome-session-plugin.vala"
	_tmp3_ = _tmp2_;
#line 135 "../../../src/plugins/gnome-session-plugin.vala"
	synapse_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_GNOME_SESSION_PLUGIN, "GNOME Session", _ ("Log out from your session."), "gnome-session-logout", _synapse_gnome_session_plugin_register_plugin_synapse_plugin_register_func, synapse_dbus_service_name_has_owner (_tmp3_, SYNAPSE_GNOME_SESSION_MANAGER_UNIQUE_NAME), _ ("Gnome Session Manager wasn't found"));
#line 135 "../../../src/plugins/gnome-session-plugin.vala"
	_g_object_unref0 (_tmp3_);
#line 135 "../../../src/plugins/gnome-session-plugin.vala"
	_g_object_unref0 (_tmp1_);
#line 833 "gnome-session-plugin.c"
}

static void
synapse_gnome_session_plugin_real_search_data_free (gpointer _data)
{
	SynapseGnomeSessionPluginSearchData* _data_;
	_data_ = _data;
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	g_slice_free (SynapseGnomeSessionPluginSearchData, _data_);
#line 849 "gnome-session-plugin.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 857 "gnome-session-plugin.c"
}

static void
synapse_gnome_session_plugin_real_search (SynapseItemProvider* base,
                                          SynapseQuery* q,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	SynapseGnomeSessionPlugin * self;
	SynapseGnomeSessionPluginSearchData* _data_;
	SynapseGnomeSessionPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	self = (SynapseGnomeSessionPlugin*) base;
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	_data_ = g_slice_new0 (SynapseGnomeSessionPluginSearchData);
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_gnome_session_plugin_real_search_data_free);
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	_data_->self = _tmp0_;
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	_tmp1_ = *q;
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	_tmp2_ = _tmp1_;
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	_data_->q = _tmp3_;
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	synapse_gnome_session_plugin_real_search_co (_data_);
#line 896 "gnome-session-plugin.c"
}

static SynapseResultSet*
synapse_gnome_session_plugin_search_finish (SynapseItemProvider* base,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	SynapseResultSet* result;
	SynapseGnomeSessionPluginSearchData* _data_;
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	if (NULL == _data_) {
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
		return NULL;
#line 912 "gnome-session-plugin.c"
	}
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	result = _data_->result;
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	_data_->result = NULL;
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	return result;
#line 920 "gnome-session-plugin.c"
}

static gboolean
synapse_gnome_session_plugin_real_search_co (SynapseGnomeSessionPluginSearchData* _data_)
{
#line 168 "../../../src/plugins/gnome-session-plugin.vala"
	switch (_data_->_state_) {
#line 168 "../../../src/plugins/gnome-session-plugin.vala"
		case 0:
#line 930 "gnome-session-plugin.c"
		goto _state_0;
		default:
#line 168 "../../../src/plugins/gnome-session-plugin.vala"
		g_assert_not_reached ();
#line 935 "gnome-session-plugin.c"
	}
	_state_0:
#line 170 "../../../src/plugins/gnome-session-plugin.vala"
	if (!_data_->self->priv->session_manager_available) {
#line 170 "../../../src/plugins/gnome-session-plugin.vala"
		_data_->result = NULL;
#line 170 "../../../src/plugins/gnome-session-plugin.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 170 "../../../src/plugins/gnome-session-plugin.vala"
		if (_data_->_state_ != 0) {
#line 170 "../../../src/plugins/gnome-session-plugin.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 170 "../../../src/plugins/gnome-session-plugin.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 950 "gnome-session-plugin.c"
			}
		}
#line 170 "../../../src/plugins/gnome-session-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 170 "../../../src/plugins/gnome-session-plugin.vala"
		return FALSE;
#line 957 "gnome-session-plugin.c"
	}
#line 172 "../../../src/plugins/gnome-session-plugin.vala"
	_data_->_tmp0_ = _data_->q;
#line 172 "../../../src/plugins/gnome-session-plugin.vala"
	_data_->_tmp1_ = _data_->_tmp0_.query_type;
#line 172 "../../../src/plugins/gnome-session-plugin.vala"
	if (!((_data_->_tmp1_ & SYNAPSE_QUERY_FLAGS_ACTIONS) == SYNAPSE_QUERY_FLAGS_ACTIONS)) {
#line 172 "../../../src/plugins/gnome-session-plugin.vala"
		_data_->result = NULL;
#line 172 "../../../src/plugins/gnome-session-plugin.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 172 "../../../src/plugins/gnome-session-plugin.vala"
		if (_data_->_state_ != 0) {
#line 172 "../../../src/plugins/gnome-session-plugin.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 172 "../../../src/plugins/gnome-session-plugin.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 975 "gnome-session-plugin.c"
			}
		}
#line 172 "../../../src/plugins/gnome-session-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 172 "../../../src/plugins/gnome-session-plugin.vala"
		return FALSE;
#line 982 "gnome-session-plugin.c"
	}
#line 174 "../../../src/plugins/gnome-session-plugin.vala"
	_data_->_tmp2_ = synapse_result_set_new ();
#line 174 "../../../src/plugins/gnome-session-plugin.vala"
	_data_->_result_ = _data_->_tmp2_;
#line 176 "../../../src/plugins/gnome-session-plugin.vala"
	_data_->_tmp3_ = _data_->q;
#line 176 "../../../src/plugins/gnome-session-plugin.vala"
	_data_->_tmp4_ = _data_->_tmp3_.query_string;
#line 176 "../../../src/plugins/gnome-session-plugin.vala"
	_data_->_tmp5_ = synapse_query_get_matchers_for_query (_data_->_tmp4_, 0, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
#line 176 "../../../src/plugins/gnome-session-plugin.vala"
	_data_->matchers = _data_->_tmp5_;
#line 996 "gnome-session-plugin.c"
	{
#line 179 "../../../src/plugins/gnome-session-plugin.vala"
		_data_->_tmp6_ = _data_->self->priv->actions;
#line 179 "../../../src/plugins/gnome-session-plugin.vala"
		_data_->_tmp7_ = _g_object_ref0 (_data_->_tmp6_);
#line 179 "../../../src/plugins/gnome-session-plugin.vala"
		_data_->_action_list = _data_->_tmp7_;
#line 179 "../../../src/plugins/gnome-session-plugin.vala"
		_data_->_tmp8_ = _data_->_action_list;
#line 179 "../../../src/plugins/gnome-session-plugin.vala"
		_data_->_tmp9_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp8_);
#line 179 "../../../src/plugins/gnome-session-plugin.vala"
		_data_->_tmp10_ = _data_->_tmp9_;
#line 179 "../../../src/plugins/gnome-session-plugin.vala"
		_data_->_action_size = _data_->_tmp10_;
#line 179 "../../../src/plugins/gnome-session-plugin.vala"
		_data_->_action_index = -1;
#line 179 "../../../src/plugins/gnome-session-plugin.vala"
		while (TRUE) {
#line 179 "../../../src/plugins/gnome-session-plugin.vala"
			_data_->_action_index = _data_->_action_index + 1;
#line 179 "../../../src/plugins/gnome-session-plugin.vala"
			_data_->_tmp11_ = _data_->_action_index;
#line 179 "../../../src/plugins/gnome-session-plugin.vala"
			_data_->_tmp12_ = _data_->_action_size;
#line 179 "../../../src/plugins/gnome-session-plugin.vala"
			if (!(_data_->_tmp11_ < _data_->_tmp12_)) {
#line 179 "../../../src/plugins/gnome-session-plugin.vala"
				break;
#line 1026 "gnome-session-plugin.c"
			}
#line 179 "../../../src/plugins/gnome-session-plugin.vala"
			_data_->_tmp13_ = _data_->_action_list;
#line 179 "../../../src/plugins/gnome-session-plugin.vala"
			_data_->_tmp14_ = gee_list_get (_data_->_tmp13_, _data_->_action_index);
#line 179 "../../../src/plugins/gnome-session-plugin.vala"
			_data_->action = (SynapseMatch*) _data_->_tmp14_;
#line 1034 "gnome-session-plugin.c"
			{
#line 181 "../../../src/plugins/gnome-session-plugin.vala"
				_data_->_tmp15_ = _data_->matchers;
#line 181 "../../../src/plugins/gnome-session-plugin.vala"
				_data_->_tmp16_ = _g_object_ref0 (_data_->_tmp15_);
#line 181 "../../../src/plugins/gnome-session-plugin.vala"
				_data_->_matcher_list = _data_->_tmp16_;
#line 181 "../../../src/plugins/gnome-session-plugin.vala"
				_data_->_tmp17_ = _data_->_matcher_list;
#line 181 "../../../src/plugins/gnome-session-plugin.vala"
				_data_->_tmp18_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp17_);
#line 181 "../../../src/plugins/gnome-session-plugin.vala"
				_data_->_tmp19_ = _data_->_tmp18_;
#line 181 "../../../src/plugins/gnome-session-plugin.vala"
				_data_->_matcher_size = _data_->_tmp19_;
#line 181 "../../../src/plugins/gnome-session-plugin.vala"
				_data_->_matcher_index = -1;
#line 181 "../../../src/plugins/gnome-session-plugin.vala"
				while (TRUE) {
#line 181 "../../../src/plugins/gnome-session-plugin.vala"
					_data_->_matcher_index = _data_->_matcher_index + 1;
#line 181 "../../../src/plugins/gnome-session-plugin.vala"
					_data_->_tmp20_ = _data_->_matcher_index;
#line 181 "../../../src/plugins/gnome-session-plugin.vala"
					_data_->_tmp21_ = _data_->_matcher_size;
#line 181 "../../../src/plugins/gnome-session-plugin.vala"
					if (!(_data_->_tmp20_ < _data_->_tmp21_)) {
#line 181 "../../../src/plugins/gnome-session-plugin.vala"
						break;
#line 1064 "gnome-session-plugin.c"
					}
#line 181 "../../../src/plugins/gnome-session-plugin.vala"
					_data_->_tmp22_ = _data_->_matcher_list;
#line 181 "../../../src/plugins/gnome-session-plugin.vala"
					_data_->_tmp23_ = gee_list_get (_data_->_tmp22_, _data_->_matcher_index);
#line 181 "../../../src/plugins/gnome-session-plugin.vala"
					_data_->matcher = (GeeMapEntry*) _data_->_tmp23_;
#line 183 "../../../src/plugins/gnome-session-plugin.vala"
					_data_->_tmp24_ = _data_->matcher;
#line 183 "../../../src/plugins/gnome-session-plugin.vala"
					_data_->_tmp25_ = gee_map_entry_get_key (_data_->_tmp24_);
#line 183 "../../../src/plugins/gnome-session-plugin.vala"
					_data_->_tmp26_ = _data_->_tmp25_;
#line 183 "../../../src/plugins/gnome-session-plugin.vala"
					_data_->_tmp27_ = _data_->action;
#line 183 "../../../src/plugins/gnome-session-plugin.vala"
					_data_->_tmp28_ = synapse_match_get_title (_data_->_tmp27_);
#line 183 "../../../src/plugins/gnome-session-plugin.vala"
					_data_->_tmp29_ = _data_->_tmp28_;
#line 183 "../../../src/plugins/gnome-session-plugin.vala"
					if (g_regex_match ((GRegex*) _data_->_tmp26_, _data_->_tmp29_, 0, NULL)) {
#line 185 "../../../src/plugins/gnome-session-plugin.vala"
						_data_->_tmp30_ = _data_->_result_;
#line 185 "../../../src/plugins/gnome-session-plugin.vala"
						_data_->_tmp31_ = _data_->action;
#line 185 "../../../src/plugins/gnome-session-plugin.vala"
						_data_->_tmp32_ = _data_->matcher;
#line 185 "../../../src/plugins/gnome-session-plugin.vala"
						_data_->_tmp33_ = gee_map_entry_get_value (_data_->_tmp32_);
#line 185 "../../../src/plugins/gnome-session-plugin.vala"
						_data_->_tmp34_ = _data_->_tmp33_;
#line 185 "../../../src/plugins/gnome-session-plugin.vala"
						synapse_result_set_add (_data_->_tmp30_, _data_->_tmp31_, ((gint) ((gintptr) _data_->_tmp34_)) - SYNAPSE_MATCH_SCORE_INCREMENT_SMALL);
#line 186 "../../../src/plugins/gnome-session-plugin.vala"
						_g_object_unref0 (_data_->matcher);
#line 186 "../../../src/plugins/gnome-session-plugin.vala"
						break;
#line 1102 "gnome-session-plugin.c"
					}
#line 181 "../../../src/plugins/gnome-session-plugin.vala"
					_g_object_unref0 (_data_->matcher);
#line 1106 "gnome-session-plugin.c"
				}
#line 181 "../../../src/plugins/gnome-session-plugin.vala"
				_g_object_unref0 (_data_->_matcher_list);
#line 1110 "gnome-session-plugin.c"
			}
#line 179 "../../../src/plugins/gnome-session-plugin.vala"
			_g_object_unref0 (_data_->action);
#line 1114 "gnome-session-plugin.c"
		}
#line 179 "../../../src/plugins/gnome-session-plugin.vala"
		_g_object_unref0 (_data_->_action_list);
#line 1118 "gnome-session-plugin.c"
	}
#line 191 "../../../src/plugins/gnome-session-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 191 "../../../src/plugins/gnome-session-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 191 "../../../src/plugins/gnome-session-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 191 "../../../src/plugins/gnome-session-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 191 "../../../src/plugins/gnome-session-plugin.vala"
			_g_object_unref0 (_data_->matchers);
#line 191 "../../../src/plugins/gnome-session-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 191 "../../../src/plugins/gnome-session-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 191 "../../../src/plugins/gnome-session-plugin.vala"
			return FALSE;
#line 1136 "gnome-session-plugin.c"
		} else {
#line 191 "../../../src/plugins/gnome-session-plugin.vala"
			_g_object_unref0 (_data_->matchers);
#line 191 "../../../src/plugins/gnome-session-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 191 "../../../src/plugins/gnome-session-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 191 "../../../src/plugins/gnome-session-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 191 "../../../src/plugins/gnome-session-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 191 "../../../src/plugins/gnome-session-plugin.vala"
			return FALSE;
#line 1150 "gnome-session-plugin.c"
		}
	}
#line 193 "../../../src/plugins/gnome-session-plugin.vala"
	_data_->result = _data_->_result_;
#line 193 "../../../src/plugins/gnome-session-plugin.vala"
	_g_object_unref0 (_data_->matchers);
#line 193 "../../../src/plugins/gnome-session-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 193 "../../../src/plugins/gnome-session-plugin.vala"
	if (_data_->_state_ != 0) {
#line 193 "../../../src/plugins/gnome-session-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 193 "../../../src/plugins/gnome-session-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1165 "gnome-session-plugin.c"
		}
	}
#line 193 "../../../src/plugins/gnome-session-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 193 "../../../src/plugins/gnome-session-plugin.vala"
	return FALSE;
#line 1172 "gnome-session-plugin.c"
}

SynapseGnomeSessionPlugin*
synapse_gnome_session_plugin_construct (GType object_type)
{
	SynapseGnomeSessionPlugin * self = NULL;
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	self = (SynapseGnomeSessionPlugin*) g_object_new (object_type, NULL);
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	return self;
#line 1183 "gnome-session-plugin.c"
}

SynapseGnomeSessionPlugin*
synapse_gnome_session_plugin_new (void)
{
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	return synapse_gnome_session_plugin_construct (SYNAPSE_TYPE_GNOME_SESSION_PLUGIN);
#line 1191 "gnome-session-plugin.c"
}

static gboolean
synapse_gnome_session_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseGnomeSessionPlugin* self;
#line 38 "../../../src/plugins/gnome-session-plugin.vala"
	self = (SynapseGnomeSessionPlugin*) base;
#line 38 "../../../src/plugins/gnome-session-plugin.vala"
	result = self->priv->_enabled;
#line 38 "../../../src/plugins/gnome-session-plugin.vala"
	return result;
#line 1205 "gnome-session-plugin.c"
}

static void
synapse_gnome_session_plugin_real_set_enabled (SynapseActivatable* base,
                                               gboolean value)
{
	SynapseGnomeSessionPlugin* self;
	gboolean old_value;
#line 38 "../../../src/plugins/gnome-session-plugin.vala"
	self = (SynapseGnomeSessionPlugin*) base;
#line 38 "../../../src/plugins/gnome-session-plugin.vala"
	old_value = synapse_gnome_session_plugin_real_get_enabled (base);
#line 38 "../../../src/plugins/gnome-session-plugin.vala"
	if (old_value != value) {
#line 38 "../../../src/plugins/gnome-session-plugin.vala"
		self->priv->_enabled = value;
#line 38 "../../../src/plugins/gnome-session-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_gnome_session_plugin_properties[SYNAPSE_GNOME_SESSION_PLUGIN_ENABLED_PROPERTY]);
#line 1224 "gnome-session-plugin.c"
	}
}

static SynapseGnomeSessionPluginShutDownAction*
synapse_gnome_session_plugin_shut_down_action_construct (GType object_type)
{
	SynapseGnomeSessionPluginShutDownAction * self = NULL;
#line 54 "../../../src/plugins/gnome-session-plugin.vala"
	self = (SynapseGnomeSessionPluginShutDownAction*) g_object_new (object_type, "title", _ ("Shut Down"), "description", _ ("Turn your computer off"), "icon-name", "system-shutdown", "has-thumbnail", FALSE, NULL);
#line 52 "../../../src/plugins/gnome-session-plugin.vala"
	return self;
#line 1236 "gnome-session-plugin.c"
}

static SynapseGnomeSessionPluginShutDownAction*
synapse_gnome_session_plugin_shut_down_action_new (void)
{
#line 52 "../../../src/plugins/gnome-session-plugin.vala"
	return synapse_gnome_session_plugin_shut_down_action_construct (SYNAPSE_GNOME_SESSION_PLUGIN_TYPE_SHUT_DOWN_ACTION);
#line 1244 "gnome-session-plugin.c"
}

static void
synapse_gnome_session_plugin_shut_down_action_real_do_action (SynapseActionMatch* base)
{
	SynapseGnomeSessionPluginShutDownAction * self;
	GError* _inner_error0_ = NULL;
#line 59 "../../../src/plugins/gnome-session-plugin.vala"
	self = (SynapseGnomeSessionPluginShutDownAction*) base;
#line 1254 "gnome-session-plugin.c"
	{
		SynapseGnomeSessionManager* dbus_interface = NULL;
		SynapseGnomeSessionManager* _tmp0_;
		SynapseGnomeSessionManager* _tmp1_;
#line 63 "../../../src/plugins/gnome-session-plugin.vala"
		_tmp0_ = (SynapseGnomeSessionManager*) g_initable_new (SYNAPSE_TYPE_GNOME_SESSION_MANAGER_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", SYNAPSE_GNOME_SESSION_MANAGER_UNIQUE_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", SYNAPSE_GNOME_SESSION_MANAGER_OBJECT_PATH, "g-interface-name", "org.gnome.SessionManager", "g-interface-info", g_type_get_qdata (SYNAPSE_TYPE_GNOME_SESSION_MANAGER, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
#line 63 "../../../src/plugins/gnome-session-plugin.vala"
		dbus_interface = (SynapseGnomeSessionManager*) _tmp0_;
#line 63 "../../../src/plugins/gnome-session-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1265 "gnome-session-plugin.c"
			goto __catch0_g_error;
		}
#line 67 "../../../src/plugins/gnome-session-plugin.vala"
		_tmp1_ = dbus_interface;
#line 67 "../../../src/plugins/gnome-session-plugin.vala"
		synapse_gnome_session_manager_shutdown (_tmp1_, &_inner_error0_);
#line 67 "../../../src/plugins/gnome-session-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 67 "../../../src/plugins/gnome-session-plugin.vala"
			_g_object_unref0 (dbus_interface);
#line 1276 "gnome-session-plugin.c"
			goto __catch0_g_error;
		}
#line 61 "../../../src/plugins/gnome-session-plugin.vala"
		_g_object_unref0 (dbus_interface);
#line 1281 "gnome-session-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 61 "../../../src/plugins/gnome-session-plugin.vala"
		err = _inner_error0_;
#line 61 "../../../src/plugins/gnome-session-plugin.vala"
		_inner_error0_ = NULL;
#line 71 "../../../src/plugins/gnome-session-plugin.vala"
		_tmp2_ = err;
#line 71 "../../../src/plugins/gnome-session-plugin.vala"
		_tmp3_ = _tmp2_->message;
#line 71 "../../../src/plugins/gnome-session-plugin.vala"
		g_warning ("gnome-session-plugin.vala:71: %s", _tmp3_);
#line 61 "../../../src/plugins/gnome-session-plugin.vala"
		_g_error_free0 (err);
#line 1301 "gnome-session-plugin.c"
	}
	__finally0:
#line 61 "../../../src/plugins/gnome-session-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 61 "../../../src/plugins/gnome-session-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 61 "../../../src/plugins/gnome-session-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 61 "../../../src/plugins/gnome-session-plugin.vala"
		return;
#line 1312 "gnome-session-plugin.c"
	}
}

static void
synapse_gnome_session_plugin_shut_down_action_class_init (SynapseGnomeSessionPluginShutDownActionClass * klass,
                                                          gpointer klass_data)
{
#line 50 "../../../src/plugins/gnome-session-plugin.vala"
	synapse_gnome_session_plugin_shut_down_action_parent_class = g_type_class_peek_parent (klass);
#line 50 "../../../src/plugins/gnome-session-plugin.vala"
	((SynapseActionMatchClass *) klass)->do_action = (void (*) (SynapseActionMatch*)) synapse_gnome_session_plugin_shut_down_action_real_do_action;
#line 1324 "gnome-session-plugin.c"
}

static void
synapse_gnome_session_plugin_shut_down_action_instance_init (SynapseGnomeSessionPluginShutDownAction * self,
                                                             gpointer klass)
{
}

static GType
synapse_gnome_session_plugin_shut_down_action_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseGnomeSessionPluginShutDownActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_gnome_session_plugin_shut_down_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseGnomeSessionPluginShutDownAction), 0, (GInstanceInitFunc) synapse_gnome_session_plugin_shut_down_action_instance_init, NULL };
	GType synapse_gnome_session_plugin_shut_down_action_type_id;
	synapse_gnome_session_plugin_shut_down_action_type_id = g_type_register_static (SYNAPSE_TYPE_ACTION_MATCH, "SynapseGnomeSessionPluginShutDownAction", &g_define_type_info, 0);
	return synapse_gnome_session_plugin_shut_down_action_type_id;
}

static GType
synapse_gnome_session_plugin_shut_down_action_get_type (void)
{
	static volatile gsize synapse_gnome_session_plugin_shut_down_action_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_gnome_session_plugin_shut_down_action_type_id__volatile)) {
		GType synapse_gnome_session_plugin_shut_down_action_type_id;
		synapse_gnome_session_plugin_shut_down_action_type_id = synapse_gnome_session_plugin_shut_down_action_get_type_once ();
		g_once_init_leave (&synapse_gnome_session_plugin_shut_down_action_type_id__volatile, synapse_gnome_session_plugin_shut_down_action_type_id);
	}
	return synapse_gnome_session_plugin_shut_down_action_type_id__volatile;
}

static SynapseGnomeSessionPluginRebootAction*
synapse_gnome_session_plugin_reboot_action_construct (GType object_type)
{
	SynapseGnomeSessionPluginRebootAction * self = NULL;
#line 80 "../../../src/plugins/gnome-session-plugin.vala"
	self = (SynapseGnomeSessionPluginRebootAction*) g_object_new (object_type, "title", _ ("Restart"), "description", _ ("Restart your computer"), "icon-name", "gnome-session-reboot", "has-thumbnail", FALSE, NULL);
#line 78 "../../../src/plugins/gnome-session-plugin.vala"
	return self;
#line 1362 "gnome-session-plugin.c"
}

static SynapseGnomeSessionPluginRebootAction*
synapse_gnome_session_plugin_reboot_action_new (void)
{
#line 78 "../../../src/plugins/gnome-session-plugin.vala"
	return synapse_gnome_session_plugin_reboot_action_construct (SYNAPSE_GNOME_SESSION_PLUGIN_TYPE_REBOOT_ACTION);
#line 1370 "gnome-session-plugin.c"
}

static void
synapse_gnome_session_plugin_reboot_action_real_do_action (SynapseActionMatch* base)
{
	SynapseGnomeSessionPluginRebootAction * self;
	GError* _inner_error0_ = NULL;
#line 85 "../../../src/plugins/gnome-session-plugin.vala"
	self = (SynapseGnomeSessionPluginRebootAction*) base;
#line 1380 "gnome-session-plugin.c"
	{
		SynapseGnomeSessionManager* dbus_interface = NULL;
		SynapseGnomeSessionManager* _tmp0_;
		SynapseGnomeSessionManager* _tmp1_;
#line 89 "../../../src/plugins/gnome-session-plugin.vala"
		_tmp0_ = (SynapseGnomeSessionManager*) g_initable_new (SYNAPSE_TYPE_GNOME_SESSION_MANAGER_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", SYNAPSE_GNOME_SESSION_MANAGER_UNIQUE_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", SYNAPSE_GNOME_SESSION_MANAGER_OBJECT_PATH, "g-interface-name", "org.gnome.SessionManager", "g-interface-info", g_type_get_qdata (SYNAPSE_TYPE_GNOME_SESSION_MANAGER, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
#line 89 "../../../src/plugins/gnome-session-plugin.vala"
		dbus_interface = (SynapseGnomeSessionManager*) _tmp0_;
#line 89 "../../../src/plugins/gnome-session-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1391 "gnome-session-plugin.c"
			goto __catch0_g_error;
		}
#line 93 "../../../src/plugins/gnome-session-plugin.vala"
		_tmp1_ = dbus_interface;
#line 93 "../../../src/plugins/gnome-session-plugin.vala"
		synapse_gnome_session_manager_request_reboot (_tmp1_, &_inner_error0_);
#line 93 "../../../src/plugins/gnome-session-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 93 "../../../src/plugins/gnome-session-plugin.vala"
			_g_object_unref0 (dbus_interface);
#line 1402 "gnome-session-plugin.c"
			goto __catch0_g_error;
		}
#line 87 "../../../src/plugins/gnome-session-plugin.vala"
		_g_object_unref0 (dbus_interface);
#line 1407 "gnome-session-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 87 "../../../src/plugins/gnome-session-plugin.vala"
		err = _inner_error0_;
#line 87 "../../../src/plugins/gnome-session-plugin.vala"
		_inner_error0_ = NULL;
#line 97 "../../../src/plugins/gnome-session-plugin.vala"
		_tmp2_ = err;
#line 97 "../../../src/plugins/gnome-session-plugin.vala"
		_tmp3_ = _tmp2_->message;
#line 97 "../../../src/plugins/gnome-session-plugin.vala"
		g_warning ("gnome-session-plugin.vala:97: %s", _tmp3_);
#line 87 "../../../src/plugins/gnome-session-plugin.vala"
		_g_error_free0 (err);
#line 1427 "gnome-session-plugin.c"
	}
	__finally0:
#line 87 "../../../src/plugins/gnome-session-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 87 "../../../src/plugins/gnome-session-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 87 "../../../src/plugins/gnome-session-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 87 "../../../src/plugins/gnome-session-plugin.vala"
		return;
#line 1438 "gnome-session-plugin.c"
	}
}

static void
synapse_gnome_session_plugin_reboot_action_class_init (SynapseGnomeSessionPluginRebootActionClass * klass,
                                                       gpointer klass_data)
{
#line 76 "../../../src/plugins/gnome-session-plugin.vala"
	synapse_gnome_session_plugin_reboot_action_parent_class = g_type_class_peek_parent (klass);
#line 76 "../../../src/plugins/gnome-session-plugin.vala"
	((SynapseActionMatchClass *) klass)->do_action = (void (*) (SynapseActionMatch*)) synapse_gnome_session_plugin_reboot_action_real_do_action;
#line 1450 "gnome-session-plugin.c"
}

static void
synapse_gnome_session_plugin_reboot_action_instance_init (SynapseGnomeSessionPluginRebootAction * self,
                                                          gpointer klass)
{
}

static GType
synapse_gnome_session_plugin_reboot_action_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseGnomeSessionPluginRebootActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_gnome_session_plugin_reboot_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseGnomeSessionPluginRebootAction), 0, (GInstanceInitFunc) synapse_gnome_session_plugin_reboot_action_instance_init, NULL };
	GType synapse_gnome_session_plugin_reboot_action_type_id;
	synapse_gnome_session_plugin_reboot_action_type_id = g_type_register_static (SYNAPSE_TYPE_ACTION_MATCH, "SynapseGnomeSessionPluginRebootAction", &g_define_type_info, 0);
	return synapse_gnome_session_plugin_reboot_action_type_id;
}

static GType
synapse_gnome_session_plugin_reboot_action_get_type (void)
{
	static volatile gsize synapse_gnome_session_plugin_reboot_action_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_gnome_session_plugin_reboot_action_type_id__volatile)) {
		GType synapse_gnome_session_plugin_reboot_action_type_id;
		synapse_gnome_session_plugin_reboot_action_type_id = synapse_gnome_session_plugin_reboot_action_get_type_once ();
		g_once_init_leave (&synapse_gnome_session_plugin_reboot_action_type_id__volatile, synapse_gnome_session_plugin_reboot_action_type_id);
	}
	return synapse_gnome_session_plugin_reboot_action_type_id__volatile;
}

static SynapseGnomeSessionPluginLogOutAction*
synapse_gnome_session_plugin_log_out_action_construct (GType object_type)
{
	SynapseGnomeSessionPluginLogOutAction * self = NULL;
#line 106 "../../../src/plugins/gnome-session-plugin.vala"
	self = (SynapseGnomeSessionPluginLogOutAction*) g_object_new (object_type, "title", _ ("Log Out"), "description", _ ("Close your session and return to the login screen"), "icon-name", "gnome-session-logout", "has-thumbnail", FALSE, NULL);
#line 104 "../../../src/plugins/gnome-session-plugin.vala"
	return self;
#line 1488 "gnome-session-plugin.c"
}

static SynapseGnomeSessionPluginLogOutAction*
synapse_gnome_session_plugin_log_out_action_new (void)
{
#line 104 "../../../src/plugins/gnome-session-plugin.vala"
	return synapse_gnome_session_plugin_log_out_action_construct (SYNAPSE_GNOME_SESSION_PLUGIN_TYPE_LOG_OUT_ACTION);
#line 1496 "gnome-session-plugin.c"
}

static void
synapse_gnome_session_plugin_log_out_action_real_do_action (SynapseActionMatch* base)
{
	SynapseGnomeSessionPluginLogOutAction * self;
	GError* _inner_error0_ = NULL;
#line 111 "../../../src/plugins/gnome-session-plugin.vala"
	self = (SynapseGnomeSessionPluginLogOutAction*) base;
#line 1506 "gnome-session-plugin.c"
	{
		SynapseGnomeSessionManager* dbus_interface = NULL;
		SynapseGnomeSessionManager* _tmp0_;
		SynapseGnomeSessionManager* _tmp1_;
#line 115 "../../../src/plugins/gnome-session-plugin.vala"
		_tmp0_ = (SynapseGnomeSessionManager*) g_initable_new (SYNAPSE_TYPE_GNOME_SESSION_MANAGER_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", SYNAPSE_GNOME_SESSION_MANAGER_UNIQUE_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", SYNAPSE_GNOME_SESSION_MANAGER_OBJECT_PATH, "g-interface-name", "org.gnome.SessionManager", "g-interface-info", g_type_get_qdata (SYNAPSE_TYPE_GNOME_SESSION_MANAGER, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
#line 115 "../../../src/plugins/gnome-session-plugin.vala"
		dbus_interface = (SynapseGnomeSessionManager*) _tmp0_;
#line 115 "../../../src/plugins/gnome-session-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1517 "gnome-session-plugin.c"
			goto __catch0_g_error;
		}
#line 124 "../../../src/plugins/gnome-session-plugin.vala"
		_tmp1_ = dbus_interface;
#line 124 "../../../src/plugins/gnome-session-plugin.vala"
		synapse_gnome_session_manager_logout (_tmp1_, (guint32) 1, &_inner_error0_);
#line 124 "../../../src/plugins/gnome-session-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 124 "../../../src/plugins/gnome-session-plugin.vala"
			_g_object_unref0 (dbus_interface);
#line 1528 "gnome-session-plugin.c"
			goto __catch0_g_error;
		}
#line 113 "../../../src/plugins/gnome-session-plugin.vala"
		_g_object_unref0 (dbus_interface);
#line 1533 "gnome-session-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 113 "../../../src/plugins/gnome-session-plugin.vala"
		err = _inner_error0_;
#line 113 "../../../src/plugins/gnome-session-plugin.vala"
		_inner_error0_ = NULL;
#line 128 "../../../src/plugins/gnome-session-plugin.vala"
		_tmp2_ = err;
#line 128 "../../../src/plugins/gnome-session-plugin.vala"
		_tmp3_ = _tmp2_->message;
#line 128 "../../../src/plugins/gnome-session-plugin.vala"
		g_warning ("gnome-session-plugin.vala:128: %s", _tmp3_);
#line 113 "../../../src/plugins/gnome-session-plugin.vala"
		_g_error_free0 (err);
#line 1553 "gnome-session-plugin.c"
	}
	__finally0:
#line 113 "../../../src/plugins/gnome-session-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 113 "../../../src/plugins/gnome-session-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 113 "../../../src/plugins/gnome-session-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 113 "../../../src/plugins/gnome-session-plugin.vala"
		return;
#line 1564 "gnome-session-plugin.c"
	}
}

static void
synapse_gnome_session_plugin_log_out_action_class_init (SynapseGnomeSessionPluginLogOutActionClass * klass,
                                                        gpointer klass_data)
{
#line 102 "../../../src/plugins/gnome-session-plugin.vala"
	synapse_gnome_session_plugin_log_out_action_parent_class = g_type_class_peek_parent (klass);
#line 102 "../../../src/plugins/gnome-session-plugin.vala"
	((SynapseActionMatchClass *) klass)->do_action = (void (*) (SynapseActionMatch*)) synapse_gnome_session_plugin_log_out_action_real_do_action;
#line 1576 "gnome-session-plugin.c"
}

static void
synapse_gnome_session_plugin_log_out_action_instance_init (SynapseGnomeSessionPluginLogOutAction * self,
                                                           gpointer klass)
{
}

static GType
synapse_gnome_session_plugin_log_out_action_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseGnomeSessionPluginLogOutActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_gnome_session_plugin_log_out_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseGnomeSessionPluginLogOutAction), 0, (GInstanceInitFunc) synapse_gnome_session_plugin_log_out_action_instance_init, NULL };
	GType synapse_gnome_session_plugin_log_out_action_type_id;
	synapse_gnome_session_plugin_log_out_action_type_id = g_type_register_static (SYNAPSE_TYPE_ACTION_MATCH, "SynapseGnomeSessionPluginLogOutAction", &g_define_type_info, 0);
	return synapse_gnome_session_plugin_log_out_action_type_id;
}

static GType
synapse_gnome_session_plugin_log_out_action_get_type (void)
{
	static volatile gsize synapse_gnome_session_plugin_log_out_action_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_gnome_session_plugin_log_out_action_type_id__volatile)) {
		GType synapse_gnome_session_plugin_log_out_action_type_id;
		synapse_gnome_session_plugin_log_out_action_type_id = synapse_gnome_session_plugin_log_out_action_get_type_once ();
		g_once_init_leave (&synapse_gnome_session_plugin_log_out_action_type_id__volatile, synapse_gnome_session_plugin_log_out_action_type_id);
	}
	return synapse_gnome_session_plugin_log_out_action_type_id__volatile;
}

static GObject *
synapse_gnome_session_plugin_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseGnomeSessionPlugin * self;
	SynapseDBusService* cache = NULL;
	SynapseDBusService* _tmp0_;
	SynapseDBusService* _tmp1_;
	const gchar* _tmp2_ = NULL;
	GeeLinkedList* _tmp3_;
	GeeList* _tmp4_;
	SynapseGnomeSessionPluginLogOutAction* _tmp5_;
	SynapseGnomeSessionPluginLogOutAction* _tmp6_;
#line 154 "../../../src/plugins/gnome-session-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_gnome_session_plugin_parent_class);
#line 154 "../../../src/plugins/gnome-session-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 154 "../../../src/plugins/gnome-session-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_GNOME_SESSION_PLUGIN, SynapseGnomeSessionPlugin);
#line 156 "../../../src/plugins/gnome-session-plugin.vala"
	_tmp0_ = synapse_dbus_service_get_default ();
#line 156 "../../../src/plugins/gnome-session-plugin.vala"
	cache = _tmp0_;
#line 157 "../../../src/plugins/gnome-session-plugin.vala"
	_tmp1_ = cache;
#line 157 "../../../src/plugins/gnome-session-plugin.vala"
	self->priv->session_manager_available = synapse_dbus_service_name_has_owner (_tmp1_, SYNAPSE_GNOME_SESSION_MANAGER_UNIQUE_NAME);
#line 159 "../../../src/plugins/gnome-session-plugin.vala"
	if (self->priv->session_manager_available) {
#line 159 "../../../src/plugins/gnome-session-plugin.vala"
		_tmp2_ = "is";
#line 1640 "gnome-session-plugin.c"
	} else {
#line 159 "../../../src/plugins/gnome-session-plugin.vala"
		_tmp2_ = "isn't";
#line 1644 "gnome-session-plugin.c"
	}
#line 158 "../../../src/plugins/gnome-session-plugin.vala"
	g_message ("gnome-session-plugin.vala:158: %s %s available", SYNAPSE_GNOME_SESSION_MANAGER_UNIQUE_NAME, _tmp2_);
#line 161 "../../../src/plugins/gnome-session-plugin.vala"
	_tmp3_ = gee_linked_list_new (SYNAPSE_TYPE_MATCH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 161 "../../../src/plugins/gnome-session-plugin.vala"
	_g_object_unref0 (self->priv->actions);
#line 161 "../../../src/plugins/gnome-session-plugin.vala"
	self->priv->actions = (GeeList*) _tmp3_;
#line 162 "../../../src/plugins/gnome-session-plugin.vala"
	_tmp4_ = self->priv->actions;
#line 162 "../../../src/plugins/gnome-session-plugin.vala"
	_tmp5_ = synapse_gnome_session_plugin_log_out_action_new ();
#line 162 "../../../src/plugins/gnome-session-plugin.vala"
	_tmp6_ = _tmp5_;
#line 162 "../../../src/plugins/gnome-session-plugin.vala"
	gee_collection_add ((GeeCollection*) _tmp4_, (SynapseMatch*) _tmp6_);
#line 162 "../../../src/plugins/gnome-session-plugin.vala"
	_g_object_unref0 (_tmp6_);
#line 154 "../../../src/plugins/gnome-session-plugin.vala"
	_g_object_unref0 (cache);
#line 154 "../../../src/plugins/gnome-session-plugin.vala"
	return obj;
#line 1668 "gnome-session-plugin.c"
}

static void
synapse_gnome_session_plugin_class_init (SynapseGnomeSessionPluginClass * klass,
                                         gpointer klass_data)
{
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	synapse_gnome_session_plugin_parent_class = g_type_class_peek_parent (klass);
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseGnomeSessionPlugin_private_offset);
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_gnome_session_plugin_get_property;
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_gnome_session_plugin_set_property;
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_gnome_session_plugin_constructor;
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_gnome_session_plugin_finalize;
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_GNOME_SESSION_PLUGIN_ENABLED_PROPERTY, synapse_gnome_session_plugin_properties[SYNAPSE_GNOME_SESSION_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 148 "../../../src/plugins/gnome-session-plugin.vala"
	synapse_gnome_session_plugin_register_plugin ();
#line 1691 "gnome-session-plugin.c"
}

static void
synapse_gnome_session_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                                 gpointer iface_data)
{
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	synapse_gnome_session_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_gnome_session_plugin_real_activate;
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_gnome_session_plugin_real_deactivate;
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	iface->get_enabled = synapse_gnome_session_plugin_real_get_enabled;
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	iface->set_enabled = synapse_gnome_session_plugin_real_set_enabled;
#line 1708 "gnome-session-plugin.c"
}

static void
synapse_gnome_session_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                                   gpointer iface_data)
{
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	synapse_gnome_session_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_gnome_session_plugin_real_search;
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_gnome_session_plugin_search_finish;
#line 1721 "gnome-session-plugin.c"
}

static void
synapse_gnome_session_plugin_instance_init (SynapseGnomeSessionPlugin * self,
                                            gpointer klass)
{
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	self->priv = synapse_gnome_session_plugin_get_instance_private (self);
#line 38 "../../../src/plugins/gnome-session-plugin.vala"
	self->priv->_enabled = TRUE;
#line 151 "../../../src/plugins/gnome-session-plugin.vala"
	self->priv->session_manager_available = FALSE;
#line 1734 "gnome-session-plugin.c"
}

static void
synapse_gnome_session_plugin_finalize (GObject * obj)
{
	SynapseGnomeSessionPlugin * self;
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_GNOME_SESSION_PLUGIN, SynapseGnomeSessionPlugin);
#line 152 "../../../src/plugins/gnome-session-plugin.vala"
	_g_object_unref0 (self->priv->actions);
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	G_OBJECT_CLASS (synapse_gnome_session_plugin_parent_class)->finalize (obj);
#line 1747 "gnome-session-plugin.c"
}

static GType
synapse_gnome_session_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseGnomeSessionPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_gnome_session_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseGnomeSessionPlugin), 0, (GInstanceInitFunc) synapse_gnome_session_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_gnome_session_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_gnome_session_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_gnome_session_plugin_type_id;
	synapse_gnome_session_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseGnomeSessionPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_gnome_session_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_gnome_session_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseGnomeSessionPlugin_private_offset = g_type_add_instance_private (synapse_gnome_session_plugin_type_id, sizeof (SynapseGnomeSessionPluginPrivate));
	return synapse_gnome_session_plugin_type_id;
}

GType
synapse_gnome_session_plugin_get_type (void)
{
	static volatile gsize synapse_gnome_session_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_gnome_session_plugin_type_id__volatile)) {
		GType synapse_gnome_session_plugin_type_id;
		synapse_gnome_session_plugin_type_id = synapse_gnome_session_plugin_get_type_once ();
		g_once_init_leave (&synapse_gnome_session_plugin_type_id__volatile, synapse_gnome_session_plugin_type_id);
	}
	return synapse_gnome_session_plugin_type_id__volatile;
}

static void
_vala_synapse_gnome_session_plugin_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	SynapseGnomeSessionPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_GNOME_SESSION_PLUGIN, SynapseGnomeSessionPlugin);
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	switch (property_id) {
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
		case SYNAPSE_GNOME_SESSION_PLUGIN_ENABLED_PROPERTY:
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
		break;
#line 1792 "gnome-session-plugin.c"
		default:
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
		break;
#line 1798 "gnome-session-plugin.c"
	}
}

static void
_vala_synapse_gnome_session_plugin_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	SynapseGnomeSessionPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_GNOME_SESSION_PLUGIN, SynapseGnomeSessionPlugin);
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
	switch (property_id) {
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
		case SYNAPSE_GNOME_SESSION_PLUGIN_ENABLED_PROPERTY:
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
		break;
#line 1818 "gnome-session-plugin.c"
		default:
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "../../../src/plugins/gnome-session-plugin.vala"
		break;
#line 1824 "gnome-session-plugin.c"
	}
}

