/* locate-plugin.c generated by valac 0.48.17, the Vala compiler
 * generated from locate-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib-object.h>
#include <synapse-core.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gunixinputstream.h>

#define SYNAPSE_TYPE_LOCATE_PLUGIN (synapse_locate_plugin_get_type ())
#define SYNAPSE_LOCATE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_LOCATE_PLUGIN, SynapseLocatePlugin))
#define SYNAPSE_LOCATE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_LOCATE_PLUGIN, SynapseLocatePluginClass))
#define SYNAPSE_IS_LOCATE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_LOCATE_PLUGIN))
#define SYNAPSE_IS_LOCATE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_LOCATE_PLUGIN))
#define SYNAPSE_LOCATE_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_LOCATE_PLUGIN, SynapseLocatePluginClass))

typedef struct _SynapseLocatePlugin SynapseLocatePlugin;
typedef struct _SynapseLocatePluginClass SynapseLocatePluginClass;
typedef struct _SynapseLocatePluginPrivate SynapseLocatePluginPrivate;

#define SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM (synapse_locate_plugin_locate_item_get_type ())
#define SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM, SynapseLocatePluginLocateItem))
#define SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM, SynapseLocatePluginLocateItemClass))
#define SYNAPSE_LOCATE_PLUGIN_IS_LOCATE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM))
#define SYNAPSE_LOCATE_PLUGIN_IS_LOCATE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM))
#define SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM, SynapseLocatePluginLocateItemClass))

typedef struct _SynapseLocatePluginLocateItem SynapseLocatePluginLocateItem;
typedef struct _SynapseLocatePluginLocateItemClass SynapseLocatePluginLocateItemClass;
enum  {
	SYNAPSE_LOCATE_PLUGIN_0_PROPERTY,
	SYNAPSE_LOCATE_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_LOCATE_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_locate_plugin_properties[SYNAPSE_LOCATE_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _synapse_utils_file_info_unref0(var) ((var == NULL) ? NULL : (var = (synapse_utils_file_info_unref (var), NULL)))
typedef struct _SynapseLocatePluginLocateData SynapseLocatePluginLocateData;
typedef struct _SynapseLocatePluginLocateItemPrivate SynapseLocatePluginLocateItemPrivate;
enum  {
	SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_0_PROPERTY,
	SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_DEFAULT_RELEVANCY_PROPERTY,
	SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_NUM_PROPERTIES
};
static GParamSpec* synapse_locate_plugin_locate_item_properties[SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_NUM_PROPERTIES];
typedef struct _SynapseLocatePluginLocateItemSearchData SynapseLocatePluginLocateItemSearchData;

struct _SynapseLocatePlugin {
	GObject parent_instance;
	SynapseLocatePluginPrivate * priv;
};

struct _SynapseLocatePluginClass {
	GObjectClass parent_class;
};

struct _SynapseLocatePluginPrivate {
	gboolean _enabled;
	SynapseLocatePluginLocateItem* action;
};

struct _SynapseLocatePluginLocateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseLocatePlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	SynapseQueryFlags our_results;
	SynapseQueryFlags common_flags;
	SynapseQuery _tmp0_;
	SynapseQueryFlags _tmp1_;
	SynapseQueryFlags _tmp2_;
	SynapseQuery _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	SynapseQueryFlags _tmp7_;
	SynapseQuery _tmp8_;
	const gchar* _tmp9_;
	gchar* regex;
	SynapseQuery _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar** argv;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	SynapseQuery _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gint argv_length1;
	gint _argv_size_;
	GeeSet* uris;
	GeeHashSet* _tmp24_;
	GPid pid;
	gint read_fd;
	gchar** _tmp25_;
	gint _tmp25__length1;
	GPid _tmp26_;
	gint _tmp27_;
	GUnixInputStream* read_stream;
	GUnixInputStream* _tmp28_;
	GDataInputStream* locate_output;
	GUnixInputStream* _tmp29_;
	GDataInputStream* _tmp30_;
	gchar* line;
	GRegex* filter_re;
	GRegex* _tmp31_;
	gboolean _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	GDataInputStream* _tmp35_;
	SynapseQuery _tmp36_;
	GCancellable* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	const gchar* _tmp40_;
	GRegex* _tmp41_;
	const gchar* _tmp42_;
	GFile* file;
	const gchar* _tmp43_;
	GFile* _tmp44_;
	GeeSet* _tmp45_;
	GFile* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	GError* err;
	GError* _tmp49_;
	const gchar* _tmp50_;
	SynapseResultSet* _result_;
	SynapseResultSet* _tmp51_;
	GeeIterator* _s_it;
	GeeSet* _tmp52_;
	GeeIterator* _tmp53_;
	GeeIterator* _tmp54_;
	gchar* s;
	GeeIterator* _tmp55_;
	gpointer _tmp56_;
	SynapseUtilsFileInfo* fi;
	const gchar* _tmp57_;
	SynapseUtilsFileInfo* _tmp58_;
	SynapseUtilsFileInfo* _tmp59_;
	gboolean _tmp60_;
	SynapseUtilsFileInfo* _tmp61_;
	SynapseUriMatch* _tmp62_;
	SynapseUtilsFileInfo* _tmp63_;
	SynapseQueryFlags _tmp64_;
	SynapseQuery _tmp65_;
	SynapseQueryFlags _tmp66_;
	gint relevancy;
	SynapseUtilsFileInfo* _tmp67_;
	const gchar* _tmp68_;
	SynapseResultSet* _tmp69_;
	SynapseUtilsFileInfo* _tmp70_;
	SynapseUriMatch* _tmp71_;
	GError* _inner_error0_;
};

struct _SynapseLocatePluginLocateItem {
	SynapseSearchMatch parent_instance;
	SynapseLocatePluginLocateItemPrivate * priv;
};

struct _SynapseLocatePluginLocateItemClass {
	SynapseSearchMatchClass parent_class;
};

struct _SynapseLocatePluginLocateItemPrivate {
	gint _default_relevancy;
	SynapseLocatePlugin* plugin;
};

struct _SynapseLocatePluginLocateItemSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseLocatePluginLocateItem* self;
	gchar* query;
	SynapseQueryFlags flags;
	SynapseResultSet* dest_result_set;
	GCancellable* cancellable;
	GeeList* result;
	SynapseQuery q;
	GCancellable* _tmp0_;
	SynapseResultSet* results;
	SynapseLocatePlugin* _tmp1_;
	SynapseQuery _tmp2_;
	SynapseResultSet* _tmp3_;
	GeeList* _tmp4_;
	GError* _inner_error0_;
};

static gint SynapseLocatePlugin_private_offset;
static gpointer synapse_locate_plugin_parent_class = NULL;
static gint SynapseLocatePluginLocateItem_private_offset;
static gpointer synapse_locate_plugin_locate_item_parent_class = NULL;
static SynapseActivatableIface * synapse_locate_plugin_synapse_activatable_parent_iface = NULL;
static SynapseActionProviderIface * synapse_locate_plugin_synapse_action_provider_parent_iface = NULL;

GType synapse_locate_plugin_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseLocatePlugin, g_object_unref)
static GType synapse_locate_plugin_locate_item_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseLocatePluginLocateItem, g_object_unref)
static void synapse_locate_plugin_real_activate (SynapseActivatable* base);
static void synapse_locate_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_locate_plugin_register_plugin (void);
static void _synapse_locate_plugin_register_plugin_synapse_plugin_register_func (void);
static gboolean synapse_locate_plugin_real_handles_unknown (SynapseActionProvider* base);
static void synapse_locate_plugin_locate_data_free (gpointer _data);
void synapse_locate_plugin_locate (SynapseLocatePlugin* self,
                                   SynapseQuery* q,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
SynapseResultSet* synapse_locate_plugin_locate_finish (SynapseLocatePlugin* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static gboolean synapse_locate_plugin_locate_co (SynapseLocatePluginLocateData* _data_);
static void synapse_locate_plugin_locate_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static SynapseResultSet* synapse_locate_plugin_real_find_for_match (SynapseActionProvider* base,
                                                             SynapseQuery* q,
                                                             SynapseMatch* match);
static gint synapse_locate_plugin_locate_item_get_default_relevancy (SynapseLocatePluginLocateItem* self);
SynapseLocatePlugin* synapse_locate_plugin_new (void);
SynapseLocatePlugin* synapse_locate_plugin_construct (GType object_type);
static void synapse_locate_plugin_locate_item_real_search_data_free (gpointer _data);
static void synapse_locate_plugin_locate_item_real_search (SynapseSearchMatch* base,
                                                    const gchar* query,
                                                    SynapseQueryFlags flags,
                                                    SynapseResultSet* dest_result_set,
                                                    GCancellable* cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static gboolean synapse_locate_plugin_locate_item_real_search_co (SynapseLocatePluginLocateItemSearchData* _data_);
static void synapse_locate_plugin_locate_item_search_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static SynapseLocatePluginLocateItem* synapse_locate_plugin_locate_item_new (SynapseLocatePlugin* plugin);
static SynapseLocatePluginLocateItem* synapse_locate_plugin_locate_item_construct (GType object_type,
                                                                            SynapseLocatePlugin* plugin);
static void synapse_locate_plugin_locate_item_set_default_relevancy (SynapseLocatePluginLocateItem* self,
                                                              gint value);
static void synapse_locate_plugin_locate_item_finalize (GObject * obj);
static GType synapse_locate_plugin_locate_item_get_type_once (void);
static void _vala_synapse_locate_plugin_locate_item_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec);
static void _vala_synapse_locate_plugin_locate_item_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec);
static GObject * synapse_locate_plugin_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void synapse_locate_plugin_finalize (GObject * obj);
static GType synapse_locate_plugin_get_type_once (void);
static void _vala_synapse_locate_plugin_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_synapse_locate_plugin_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
synapse_locate_plugin_get_instance_private (SynapseLocatePlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseLocatePlugin_private_offset);
}

static void
synapse_locate_plugin_real_activate (SynapseActivatable* base)
{
	SynapseLocatePlugin * self;
#line 28 "../../../src/plugins/locate-plugin.vala"
	self = (SynapseLocatePlugin*) base;
#line 324 "locate-plugin.c"
}

static void
synapse_locate_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseLocatePlugin * self;
#line 33 "../../../src/plugins/locate-plugin.vala"
	self = (SynapseLocatePlugin*) base;
#line 333 "locate-plugin.c"
}

static void
_synapse_locate_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 70 "../../../src/plugins/locate-plugin.vala"
	synapse_locate_plugin_register_plugin ();
#line 341 "locate-plugin.c"
}

static void
synapse_locate_plugin_register_plugin (void)
{
	SynapsePluginRegistry* _tmp0_;
	SynapsePluginRegistry* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 70 "../../../src/plugins/locate-plugin.vala"
	_tmp0_ = synapse_plugin_registry_get_default ();
#line 70 "../../../src/plugins/locate-plugin.vala"
	_tmp1_ = _tmp0_;
#line 70 "../../../src/plugins/locate-plugin.vala"
	_tmp2_ = g_find_program_in_path ("locate");
#line 70 "../../../src/plugins/locate-plugin.vala"
	_tmp3_ = _tmp2_;
#line 70 "../../../src/plugins/locate-plugin.vala"
	synapse_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_LOCATE_PLUGIN, _ ("Locate"), _ ("Runs locate command to find files on the filesystem."), "search", _synapse_locate_plugin_register_plugin_synapse_plugin_register_func, _tmp3_ != NULL, _ ("Unable to find \"locate\" binary"));
#line 70 "../../../src/plugins/locate-plugin.vala"
	_g_free0 (_tmp3_);
#line 70 "../../../src/plugins/locate-plugin.vala"
	_g_object_unref0 (_tmp1_);
#line 365 "locate-plugin.c"
}

static gboolean
synapse_locate_plugin_real_handles_unknown (SynapseActionProvider* base)
{
	SynapseLocatePlugin * self;
	gboolean result = FALSE;
#line 93 "../../../src/plugins/locate-plugin.vala"
	self = (SynapseLocatePlugin*) base;
#line 95 "../../../src/plugins/locate-plugin.vala"
	result = TRUE;
#line 95 "../../../src/plugins/locate-plugin.vala"
	return result;
#line 379 "locate-plugin.c"
}

static void
synapse_locate_plugin_locate_data_free (gpointer _data)
{
	SynapseLocatePluginLocateData* _data_;
	_data_ = _data;
#line 24 "../../../src/plugins/locate-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "../../../src/plugins/locate-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 24 "../../../src/plugins/locate-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 24 "../../../src/plugins/locate-plugin.vala"
	g_slice_free (SynapseLocatePluginLocateData, _data_);
#line 395 "locate-plugin.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 24 "../../../src/plugins/locate-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 403 "locate-plugin.c"
}

void
synapse_locate_plugin_locate (SynapseLocatePlugin* self,
                              SynapseQuery* q,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	SynapseLocatePluginLocateData* _data_;
	SynapseLocatePlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
#line 24 "../../../src/plugins/locate-plugin.vala"
	_data_ = g_slice_new0 (SynapseLocatePluginLocateData);
#line 24 "../../../src/plugins/locate-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "../../../src/plugins/locate-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_locate_plugin_locate_data_free);
#line 24 "../../../src/plugins/locate-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "../../../src/plugins/locate-plugin.vala"
	_data_->self = _tmp0_;
#line 24 "../../../src/plugins/locate-plugin.vala"
	_tmp1_ = *q;
#line 24 "../../../src/plugins/locate-plugin.vala"
	_tmp2_ = _tmp1_;
#line 24 "../../../src/plugins/locate-plugin.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 24 "../../../src/plugins/locate-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "../../../src/plugins/locate-plugin.vala"
	_data_->q = _tmp3_;
#line 24 "../../../src/plugins/locate-plugin.vala"
	synapse_locate_plugin_locate_co (_data_);
#line 439 "locate-plugin.c"
}

SynapseResultSet*
synapse_locate_plugin_locate_finish (SynapseLocatePlugin* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	SynapseResultSet* result;
	SynapseLocatePluginLocateData* _data_;
#line 24 "../../../src/plugins/locate-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 24 "../../../src/plugins/locate-plugin.vala"
	if (NULL == _data_) {
#line 24 "../../../src/plugins/locate-plugin.vala"
		return NULL;
#line 455 "locate-plugin.c"
	}
#line 24 "../../../src/plugins/locate-plugin.vala"
	result = _data_->result;
#line 24 "../../../src/plugins/locate-plugin.vala"
	_data_->result = NULL;
#line 24 "../../../src/plugins/locate-plugin.vala"
	return result;
#line 463 "locate-plugin.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
#line 1359 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1360 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1360 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1361 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1362 "glib-2.0.vapi"
	result = _result_;
#line 1362 "glib-2.0.vapi"
	return result;
#line 484 "locate-plugin.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1535 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 506 "locate-plugin.c"
	} else {
#line 1535 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 510 "locate-plugin.c"
	}
#line 1535 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1535 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 516 "locate-plugin.c"
	} else {
#line 1535 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 520 "locate-plugin.c"
	}
#line 1535 "glib-2.0.vapi"
	if (_tmp0_) {
#line 524 "locate-plugin.c"
		gchar* _tmp2_;
#line 1536 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1536 "glib-2.0.vapi"
		result = _tmp2_;
#line 1536 "glib-2.0.vapi"
		return result;
#line 532 "locate-plugin.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1539 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1539 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1539 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1539 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1539 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1539 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1539 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1539 "glib-2.0.vapi"
			_g_free0 (_tmp7_);
#line 1539 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1539 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 564 "locate-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 1539 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1539 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1539 "glib-2.0.vapi"
			return NULL;
#line 573 "locate-plugin.c"
		}
#line 1540 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1540 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1540 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1540 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1540 "glib-2.0.vapi"
			_g_free0 (_tmp7_);
#line 1540 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1540 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 589 "locate-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 1540 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1540 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1540 "glib-2.0.vapi"
			return NULL;
#line 598 "locate-plugin.c"
		}
#line 1540 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1540 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1540 "glib-2.0.vapi"
		result = _tmp10_;
#line 1540 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1540 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1540 "glib-2.0.vapi"
		return result;
#line 612 "locate-plugin.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1538 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1542 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 621 "locate-plugin.c"
	}
	__finally0:
#line 1538 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1538 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1538 "glib-2.0.vapi"
	return NULL;
#line 630 "locate-plugin.c"
}

static void
synapse_locate_plugin_locate_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	SynapseLocatePluginLocateData* _data_;
#line 136 "../../../src/plugins/locate-plugin.vala"
	_data_ = _user_data_;
#line 136 "../../../src/plugins/locate-plugin.vala"
	_data_->_source_object_ = source_object;
#line 136 "../../../src/plugins/locate-plugin.vala"
	_data_->_res_ = _res_;
#line 136 "../../../src/plugins/locate-plugin.vala"
	synapse_locate_plugin_locate_co (_data_);
#line 647 "locate-plugin.c"
}

static gboolean
synapse_locate_plugin_locate_co (SynapseLocatePluginLocateData* _data_)
{
#line 98 "../../../src/plugins/locate-plugin.vala"
	switch (_data_->_state_) {
#line 98 "../../../src/plugins/locate-plugin.vala"
		case 0:
#line 657 "locate-plugin.c"
		goto _state_0;
#line 98 "../../../src/plugins/locate-plugin.vala"
		case 1:
#line 661 "locate-plugin.c"
		goto _state_1;
#line 98 "../../../src/plugins/locate-plugin.vala"
		case 2:
#line 665 "locate-plugin.c"
		goto _state_2;
		default:
#line 98 "../../../src/plugins/locate-plugin.vala"
		g_assert_not_reached ();
#line 670 "locate-plugin.c"
	}
	_state_0:
#line 100 "../../../src/plugins/locate-plugin.vala"
	_data_->our_results = (((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES) | SYNAPSE_QUERY_FLAGS_UNCATEGORIZED) | SYNAPSE_QUERY_FLAGS_VIDEO;
#line 103 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp0_ = _data_->q;
#line 103 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp1_ = _data_->_tmp0_.query_type;
#line 103 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp2_ = _data_->our_results;
#line 103 "../../../src/plugins/locate-plugin.vala"
	_data_->common_flags = _data_->_tmp1_ & _data_->_tmp2_;
#line 105 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp3_ = _data_->q;
#line 105 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp4_ = _data_->_tmp3_.query_string;
#line 105 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp5_ = string_strip (_data_->_tmp4_);
#line 105 "../../../src/plugins/locate-plugin.vala"
	_g_free0 (_data_->q.query_string);
#line 105 "../../../src/plugins/locate-plugin.vala"
	_data_->q.query_string = _data_->_tmp5_;
#line 107 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp7_ = _data_->common_flags;
#line 107 "../../../src/plugins/locate-plugin.vala"
	if (_data_->_tmp7_ == 0) {
#line 107 "../../../src/plugins/locate-plugin.vala"
		_data_->_tmp6_ = TRUE;
#line 699 "locate-plugin.c"
	} else {
#line 107 "../../../src/plugins/locate-plugin.vala"
		_data_->_tmp8_ = _data_->q;
#line 107 "../../../src/plugins/locate-plugin.vala"
		_data_->_tmp9_ = _data_->_tmp8_.query_string;
#line 107 "../../../src/plugins/locate-plugin.vala"
		_data_->_tmp6_ = g_utf8_strlen (_data_->_tmp9_, (gssize) -1) <= 1;
#line 707 "locate-plugin.c"
	}
#line 107 "../../../src/plugins/locate-plugin.vala"
	if (_data_->_tmp6_) {
#line 107 "../../../src/plugins/locate-plugin.vala"
		_data_->result = NULL;
#line 107 "../../../src/plugins/locate-plugin.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 107 "../../../src/plugins/locate-plugin.vala"
		if (_data_->_state_ != 0) {
#line 107 "../../../src/plugins/locate-plugin.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 107 "../../../src/plugins/locate-plugin.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 721 "locate-plugin.c"
			}
		}
#line 107 "../../../src/plugins/locate-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 107 "../../../src/plugins/locate-plugin.vala"
		return FALSE;
#line 728 "locate-plugin.c"
	}
#line 109 "../../../src/plugins/locate-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 109 "../../../src/plugins/locate-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 109 "../../../src/plugins/locate-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 109 "../../../src/plugins/locate-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 109 "../../../src/plugins/locate-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 109 "../../../src/plugins/locate-plugin.vala"
			return FALSE;
#line 742 "locate-plugin.c"
		} else {
#line 109 "../../../src/plugins/locate-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 109 "../../../src/plugins/locate-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 109 "../../../src/plugins/locate-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 109 "../../../src/plugins/locate-plugin.vala"
			return FALSE;
#line 752 "locate-plugin.c"
		}
	}
#line 111 "../../../src/plugins/locate-plugin.vala"
	_data_->q.max_results = (guint) 256;
#line 112 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp10_ = _data_->q;
#line 112 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp11_ = _data_->_tmp10_.query_string;
#line 112 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp12_ = g_regex_escape_string (_data_->_tmp11_, -1);
#line 112 "../../../src/plugins/locate-plugin.vala"
	_data_->regex = _data_->_tmp12_;
#line 114 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp13_ = g_strdup ("locate");
#line 114 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp14_ = g_strdup ("-i");
#line 114 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp15_ = g_strdup ("-l");
#line 114 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp16_ = _data_->q;
#line 114 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp17_ = g_strdup_printf ("%u", _data_->_tmp16_.max_results);
#line 114 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp18_ = _data_->regex;
#line 114 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp19_ = string_replace (_data_->_tmp18_, " ", "*");
#line 114 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp20_ = _data_->_tmp19_;
#line 114 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp21_ = g_strdup_printf ("*%s*", _data_->_tmp20_);
#line 114 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp22_ = g_new0 (gchar*, 5 + 1);
#line 114 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp22_[0] = _data_->_tmp13_;
#line 114 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp22_[1] = _data_->_tmp14_;
#line 114 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp22_[2] = _data_->_tmp15_;
#line 114 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp22_[3] = _data_->_tmp17_;
#line 114 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp22_[4] = _data_->_tmp21_;
#line 114 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp23_ = _data_->_tmp22_;
#line 114 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp23__length1 = 5;
#line 114 "../../../src/plugins/locate-plugin.vala"
	_g_free0 (_data_->_tmp20_);
#line 114 "../../../src/plugins/locate-plugin.vala"
	_data_->argv = _data_->_tmp23_;
#line 114 "../../../src/plugins/locate-plugin.vala"
	_data_->argv_length1 = _data_->_tmp23__length1;
#line 114 "../../../src/plugins/locate-plugin.vala"
	_data_->_argv_size_ = _data_->argv_length1;
#line 117 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp24_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 117 "../../../src/plugins/locate-plugin.vala"
	_data_->uris = (GeeSet*) _data_->_tmp24_;
#line 811 "locate-plugin.c"
	{
#line 125 "../../../src/plugins/locate-plugin.vala"
		_data_->_tmp25_ = _data_->argv;
#line 125 "../../../src/plugins/locate-plugin.vala"
		_data_->_tmp25__length1 = _data_->argv_length1;
#line 125 "../../../src/plugins/locate-plugin.vala"
		_data_->_tmp26_ = 0;
#line 125 "../../../src/plugins/locate-plugin.vala"
		_data_->_tmp27_ = 0;
#line 125 "../../../src/plugins/locate-plugin.vala"
		g_spawn_async_with_pipes (NULL, _data_->_tmp25_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_data_->_tmp26_, NULL, &_data_->_tmp27_, NULL, &_data_->_inner_error0_);
#line 125 "../../../src/plugins/locate-plugin.vala"
		_data_->pid = _data_->_tmp26_;
#line 125 "../../../src/plugins/locate-plugin.vala"
		_data_->read_fd = _data_->_tmp27_;
#line 125 "../../../src/plugins/locate-plugin.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 829 "locate-plugin.c"
			goto __catch0_g_error;
		}
#line 129 "../../../src/plugins/locate-plugin.vala"
		_data_->_tmp28_ = (GUnixInputStream*) g_unix_input_stream_new (_data_->read_fd, TRUE);
#line 129 "../../../src/plugins/locate-plugin.vala"
		_data_->read_stream = _data_->_tmp28_;
#line 130 "../../../src/plugins/locate-plugin.vala"
		_data_->_tmp29_ = _data_->read_stream;
#line 130 "../../../src/plugins/locate-plugin.vala"
		_data_->_tmp30_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp29_);
#line 130 "../../../src/plugins/locate-plugin.vala"
		_data_->locate_output = _data_->_tmp30_;
#line 131 "../../../src/plugins/locate-plugin.vala"
		_data_->line = NULL;
#line 133 "../../../src/plugins/locate-plugin.vala"
		_data_->_tmp31_ = g_regex_new ("/\\.", 0, 0, &_data_->_inner_error0_);
#line 133 "../../../src/plugins/locate-plugin.vala"
		_data_->filter_re = _data_->_tmp31_;
#line 133 "../../../src/plugins/locate-plugin.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 133 "../../../src/plugins/locate-plugin.vala"
			_g_free0 (_data_->line);
#line 133 "../../../src/plugins/locate-plugin.vala"
			_g_object_unref0 (_data_->locate_output);
#line 133 "../../../src/plugins/locate-plugin.vala"
			_g_object_unref0 (_data_->read_stream);
#line 856 "locate-plugin.c"
			goto __catch0_g_error;
		}
		{
#line 134 "../../../src/plugins/locate-plugin.vala"
			_data_->_tmp32_ = TRUE;
#line 134 "../../../src/plugins/locate-plugin.vala"
			while (TRUE) {
#line 134 "../../../src/plugins/locate-plugin.vala"
				if (!_data_->_tmp32_) {
#line 143 "../../../src/plugins/locate-plugin.vala"
					_data_->_tmp33_ = _data_->line;
#line 143 "../../../src/plugins/locate-plugin.vala"
					if (!(_data_->_tmp33_ != NULL)) {
#line 143 "../../../src/plugins/locate-plugin.vala"
						break;
#line 872 "locate-plugin.c"
					}
				}
#line 134 "../../../src/plugins/locate-plugin.vala"
				_data_->_tmp32_ = FALSE;
#line 136 "../../../src/plugins/locate-plugin.vala"
				_data_->_tmp35_ = _data_->locate_output;
#line 136 "../../../src/plugins/locate-plugin.vala"
				_data_->_tmp36_ = _data_->q;
#line 136 "../../../src/plugins/locate-plugin.vala"
				_data_->_tmp37_ = _data_->_tmp36_.cancellable;
#line 136 "../../../src/plugins/locate-plugin.vala"
				_data_->_state_ = 1;
#line 136 "../../../src/plugins/locate-plugin.vala"
				g_data_input_stream_read_line_async (_data_->_tmp35_, G_PRIORITY_DEFAULT_IDLE, _data_->_tmp37_, synapse_locate_plugin_locate_ready, _data_);
#line 136 "../../../src/plugins/locate-plugin.vala"
				return FALSE;
#line 889 "locate-plugin.c"
				_state_1:
#line 136 "../../../src/plugins/locate-plugin.vala"
				_data_->_tmp38_ = g_data_input_stream_read_line_finish (_data_->_tmp35_, _data_->_res_, NULL, &_data_->_inner_error0_);
#line 136 "../../../src/plugins/locate-plugin.vala"
				_data_->_tmp34_ = _data_->_tmp38_;
#line 136 "../../../src/plugins/locate-plugin.vala"
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 136 "../../../src/plugins/locate-plugin.vala"
					_g_regex_unref0 (_data_->filter_re);
#line 136 "../../../src/plugins/locate-plugin.vala"
					_g_free0 (_data_->line);
#line 136 "../../../src/plugins/locate-plugin.vala"
					_g_object_unref0 (_data_->locate_output);
#line 136 "../../../src/plugins/locate-plugin.vala"
					_g_object_unref0 (_data_->read_stream);
#line 905 "locate-plugin.c"
					goto __catch0_g_error;
				}
#line 136 "../../../src/plugins/locate-plugin.vala"
				_data_->_tmp39_ = _data_->_tmp34_;
#line 136 "../../../src/plugins/locate-plugin.vala"
				_data_->_tmp34_ = NULL;
#line 136 "../../../src/plugins/locate-plugin.vala"
				_g_free0 (_data_->line);
#line 136 "../../../src/plugins/locate-plugin.vala"
				_data_->line = _data_->_tmp39_;
#line 137 "../../../src/plugins/locate-plugin.vala"
				_data_->_tmp40_ = _data_->line;
#line 137 "../../../src/plugins/locate-plugin.vala"
				if (_data_->_tmp40_ != NULL) {
#line 139 "../../../src/plugins/locate-plugin.vala"
					_data_->_tmp41_ = _data_->filter_re;
#line 139 "../../../src/plugins/locate-plugin.vala"
					_data_->_tmp42_ = _data_->line;
#line 139 "../../../src/plugins/locate-plugin.vala"
					if (g_regex_match (_data_->_tmp41_, _data_->_tmp42_, 0, NULL)) {
#line 139 "../../../src/plugins/locate-plugin.vala"
						_g_free0 (_data_->_tmp34_);
#line 139 "../../../src/plugins/locate-plugin.vala"
						continue;
#line 930 "locate-plugin.c"
					}
#line 140 "../../../src/plugins/locate-plugin.vala"
					_data_->_tmp43_ = _data_->line;
#line 140 "../../../src/plugins/locate-plugin.vala"
					_data_->_tmp44_ = g_file_new_for_path (_data_->_tmp43_);
#line 140 "../../../src/plugins/locate-plugin.vala"
					_data_->file = _data_->_tmp44_;
#line 141 "../../../src/plugins/locate-plugin.vala"
					_data_->_tmp45_ = _data_->uris;
#line 141 "../../../src/plugins/locate-plugin.vala"
					_data_->_tmp46_ = _data_->file;
#line 141 "../../../src/plugins/locate-plugin.vala"
					_data_->_tmp47_ = g_file_get_uri (_data_->_tmp46_);
#line 141 "../../../src/plugins/locate-plugin.vala"
					_data_->_tmp48_ = _data_->_tmp47_;
#line 141 "../../../src/plugins/locate-plugin.vala"
					gee_collection_add ((GeeCollection*) _data_->_tmp45_, _data_->_tmp48_);
#line 141 "../../../src/plugins/locate-plugin.vala"
					_g_free0 (_data_->_tmp48_);
#line 137 "../../../src/plugins/locate-plugin.vala"
					_g_object_unref0 (_data_->file);
#line 952 "locate-plugin.c"
				}
#line 134 "../../../src/plugins/locate-plugin.vala"
				_g_free0 (_data_->_tmp34_);
#line 956 "locate-plugin.c"
			}
		}
#line 119 "../../../src/plugins/locate-plugin.vala"
		_g_regex_unref0 (_data_->filter_re);
#line 119 "../../../src/plugins/locate-plugin.vala"
		_g_free0 (_data_->line);
#line 119 "../../../src/plugins/locate-plugin.vala"
		_g_object_unref0 (_data_->locate_output);
#line 119 "../../../src/plugins/locate-plugin.vala"
		_g_object_unref0 (_data_->read_stream);
#line 967 "locate-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 119 "../../../src/plugins/locate-plugin.vala"
		_data_->err = _data_->_inner_error0_;
#line 119 "../../../src/plugins/locate-plugin.vala"
		_data_->_inner_error0_ = NULL;
#line 147 "../../../src/plugins/locate-plugin.vala"
		if (!synapse_query_is_cancelled (&_data_->q)) {
#line 147 "../../../src/plugins/locate-plugin.vala"
			_data_->_tmp49_ = _data_->err;
#line 147 "../../../src/plugins/locate-plugin.vala"
			_data_->_tmp50_ = _data_->_tmp49_->message;
#line 147 "../../../src/plugins/locate-plugin.vala"
			g_warning ("locate-plugin.vala:147: %s", _data_->_tmp50_);
#line 984 "locate-plugin.c"
		}
#line 119 "../../../src/plugins/locate-plugin.vala"
		_g_error_free0 (_data_->err);
#line 988 "locate-plugin.c"
	}
	__finally0:
#line 119 "../../../src/plugins/locate-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 119 "../../../src/plugins/locate-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 119 "../../../src/plugins/locate-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 119 "../../../src/plugins/locate-plugin.vala"
			_g_object_unref0 (_data_->uris);
#line 119 "../../../src/plugins/locate-plugin.vala"
			_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 119 "../../../src/plugins/locate-plugin.vala"
			_g_free0 (_data_->regex);
#line 119 "../../../src/plugins/locate-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 119 "../../../src/plugins/locate-plugin.vala"
			return FALSE;
#line 1007 "locate-plugin.c"
		} else {
#line 119 "../../../src/plugins/locate-plugin.vala"
			_g_object_unref0 (_data_->uris);
#line 119 "../../../src/plugins/locate-plugin.vala"
			_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 119 "../../../src/plugins/locate-plugin.vala"
			_g_free0 (_data_->regex);
#line 119 "../../../src/plugins/locate-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 119 "../../../src/plugins/locate-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 119 "../../../src/plugins/locate-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 119 "../../../src/plugins/locate-plugin.vala"
			return FALSE;
#line 1023 "locate-plugin.c"
		}
	}
#line 150 "../../../src/plugins/locate-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 150 "../../../src/plugins/locate-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 150 "../../../src/plugins/locate-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 150 "../../../src/plugins/locate-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 150 "../../../src/plugins/locate-plugin.vala"
			_g_object_unref0 (_data_->uris);
#line 150 "../../../src/plugins/locate-plugin.vala"
			_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 150 "../../../src/plugins/locate-plugin.vala"
			_g_free0 (_data_->regex);
#line 150 "../../../src/plugins/locate-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 150 "../../../src/plugins/locate-plugin.vala"
			return FALSE;
#line 1044 "locate-plugin.c"
		} else {
#line 150 "../../../src/plugins/locate-plugin.vala"
			_g_object_unref0 (_data_->uris);
#line 150 "../../../src/plugins/locate-plugin.vala"
			_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 150 "../../../src/plugins/locate-plugin.vala"
			_g_free0 (_data_->regex);
#line 150 "../../../src/plugins/locate-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 150 "../../../src/plugins/locate-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 150 "../../../src/plugins/locate-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 150 "../../../src/plugins/locate-plugin.vala"
			return FALSE;
#line 1060 "locate-plugin.c"
		}
	}
#line 152 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp51_ = synapse_result_set_new ();
#line 152 "../../../src/plugins/locate-plugin.vala"
	_data_->_result_ = _data_->_tmp51_;
#line 1067 "locate-plugin.c"
	{
#line 154 "../../../src/plugins/locate-plugin.vala"
		_data_->_tmp52_ = _data_->uris;
#line 154 "../../../src/plugins/locate-plugin.vala"
		_data_->_tmp53_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp52_);
#line 154 "../../../src/plugins/locate-plugin.vala"
		_data_->_s_it = _data_->_tmp53_;
#line 154 "../../../src/plugins/locate-plugin.vala"
		while (TRUE) {
#line 154 "../../../src/plugins/locate-plugin.vala"
			_data_->_tmp54_ = _data_->_s_it;
#line 154 "../../../src/plugins/locate-plugin.vala"
			if (!gee_iterator_next (_data_->_tmp54_)) {
#line 154 "../../../src/plugins/locate-plugin.vala"
				break;
#line 1083 "locate-plugin.c"
			}
#line 154 "../../../src/plugins/locate-plugin.vala"
			_data_->_tmp55_ = _data_->_s_it;
#line 154 "../../../src/plugins/locate-plugin.vala"
			_data_->_tmp56_ = gee_iterator_get (_data_->_tmp55_);
#line 154 "../../../src/plugins/locate-plugin.vala"
			_data_->s = (gchar*) _data_->_tmp56_;
#line 156 "../../../src/plugins/locate-plugin.vala"
			_data_->_tmp57_ = _data_->s;
#line 156 "../../../src/plugins/locate-plugin.vala"
			_data_->_tmp58_ = synapse_utils_file_info_new (_data_->_tmp57_, SYNAPSE_TYPE_URI_MATCH);
#line 156 "../../../src/plugins/locate-plugin.vala"
			_data_->fi = _data_->_tmp58_;
#line 157 "../../../src/plugins/locate-plugin.vala"
			_data_->_tmp59_ = _data_->fi;
#line 157 "../../../src/plugins/locate-plugin.vala"
			_data_->_state_ = 2;
#line 157 "../../../src/plugins/locate-plugin.vala"
			synapse_utils_file_info_initialize (_data_->_tmp59_, synapse_locate_plugin_locate_ready, _data_);
#line 157 "../../../src/plugins/locate-plugin.vala"
			return FALSE;
#line 1105 "locate-plugin.c"
			_state_2:
#line 157 "../../../src/plugins/locate-plugin.vala"
			synapse_utils_file_info_initialize_finish (_data_->_tmp59_, _data_->_res_);
#line 158 "../../../src/plugins/locate-plugin.vala"
			_data_->_tmp61_ = _data_->fi;
#line 158 "../../../src/plugins/locate-plugin.vala"
			_data_->_tmp62_ = _data_->_tmp61_->match_obj;
#line 158 "../../../src/plugins/locate-plugin.vala"
			if (_data_->_tmp62_ != NULL) {
#line 158 "../../../src/plugins/locate-plugin.vala"
				_data_->_tmp63_ = _data_->fi;
#line 158 "../../../src/plugins/locate-plugin.vala"
				_data_->_tmp64_ = _data_->_tmp63_->file_type;
#line 158 "../../../src/plugins/locate-plugin.vala"
				_data_->_tmp65_ = _data_->q;
#line 158 "../../../src/plugins/locate-plugin.vala"
				_data_->_tmp66_ = _data_->_tmp65_.query_type;
#line 158 "../../../src/plugins/locate-plugin.vala"
				_data_->_tmp60_ = (_data_->_tmp66_ & _data_->_tmp64_) == _data_->_tmp64_;
#line 1125 "locate-plugin.c"
			} else {
#line 158 "../../../src/plugins/locate-plugin.vala"
				_data_->_tmp60_ = FALSE;
#line 1129 "locate-plugin.c"
			}
#line 158 "../../../src/plugins/locate-plugin.vala"
			if (_data_->_tmp60_) {
#line 160 "../../../src/plugins/locate-plugin.vala"
				_data_->relevancy = (gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL;
#line 161 "../../../src/plugins/locate-plugin.vala"
				_data_->_tmp67_ = _data_->fi;
#line 161 "../../../src/plugins/locate-plugin.vala"
				_data_->_tmp68_ = _data_->_tmp67_->uri;
#line 161 "../../../src/plugins/locate-plugin.vala"
				if (g_str_has_prefix (_data_->_tmp68_, "file:///home/")) {
#line 161 "../../../src/plugins/locate-plugin.vala"
					_data_->relevancy += (gint) SYNAPSE_MATCH_SCORE_INCREMENT_MINOR;
#line 1143 "locate-plugin.c"
				}
#line 162 "../../../src/plugins/locate-plugin.vala"
				_data_->_tmp69_ = _data_->_result_;
#line 162 "../../../src/plugins/locate-plugin.vala"
				_data_->_tmp70_ = _data_->fi;
#line 162 "../../../src/plugins/locate-plugin.vala"
				_data_->_tmp71_ = _data_->_tmp70_->match_obj;
#line 162 "../../../src/plugins/locate-plugin.vala"
				synapse_result_set_add (_data_->_tmp69_, (SynapseMatch*) _data_->_tmp71_, _data_->relevancy);
#line 1153 "locate-plugin.c"
			}
#line 164 "../../../src/plugins/locate-plugin.vala"
			synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 164 "../../../src/plugins/locate-plugin.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 164 "../../../src/plugins/locate-plugin.vala"
				if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 164 "../../../src/plugins/locate-plugin.vala"
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 164 "../../../src/plugins/locate-plugin.vala"
					_synapse_utils_file_info_unref0 (_data_->fi);
#line 164 "../../../src/plugins/locate-plugin.vala"
					_g_free0 (_data_->s);
#line 164 "../../../src/plugins/locate-plugin.vala"
					_g_object_unref0 (_data_->_s_it);
#line 164 "../../../src/plugins/locate-plugin.vala"
					_g_object_unref0 (_data_->_result_);
#line 164 "../../../src/plugins/locate-plugin.vala"
					_g_object_unref0 (_data_->uris);
#line 164 "../../../src/plugins/locate-plugin.vala"
					_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 164 "../../../src/plugins/locate-plugin.vala"
					_g_free0 (_data_->regex);
#line 164 "../../../src/plugins/locate-plugin.vala"
					g_object_unref (_data_->_async_result);
#line 164 "../../../src/plugins/locate-plugin.vala"
					return FALSE;
#line 1181 "locate-plugin.c"
				} else {
#line 164 "../../../src/plugins/locate-plugin.vala"
					_synapse_utils_file_info_unref0 (_data_->fi);
#line 164 "../../../src/plugins/locate-plugin.vala"
					_g_free0 (_data_->s);
#line 164 "../../../src/plugins/locate-plugin.vala"
					_g_object_unref0 (_data_->_s_it);
#line 164 "../../../src/plugins/locate-plugin.vala"
					_g_object_unref0 (_data_->_result_);
#line 164 "../../../src/plugins/locate-plugin.vala"
					_g_object_unref0 (_data_->uris);
#line 164 "../../../src/plugins/locate-plugin.vala"
					_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 164 "../../../src/plugins/locate-plugin.vala"
					_g_free0 (_data_->regex);
#line 164 "../../../src/plugins/locate-plugin.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 164 "../../../src/plugins/locate-plugin.vala"
					g_clear_error (&_data_->_inner_error0_);
#line 164 "../../../src/plugins/locate-plugin.vala"
					g_object_unref (_data_->_async_result);
#line 164 "../../../src/plugins/locate-plugin.vala"
					return FALSE;
#line 1205 "locate-plugin.c"
				}
			}
#line 154 "../../../src/plugins/locate-plugin.vala"
			_synapse_utils_file_info_unref0 (_data_->fi);
#line 154 "../../../src/plugins/locate-plugin.vala"
			_g_free0 (_data_->s);
#line 1212 "locate-plugin.c"
		}
#line 154 "../../../src/plugins/locate-plugin.vala"
		_g_object_unref0 (_data_->_s_it);
#line 1216 "locate-plugin.c"
	}
#line 167 "../../../src/plugins/locate-plugin.vala"
	_data_->result = _data_->_result_;
#line 167 "../../../src/plugins/locate-plugin.vala"
	_g_object_unref0 (_data_->uris);
#line 167 "../../../src/plugins/locate-plugin.vala"
	_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 167 "../../../src/plugins/locate-plugin.vala"
	_g_free0 (_data_->regex);
#line 167 "../../../src/plugins/locate-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 167 "../../../src/plugins/locate-plugin.vala"
	if (_data_->_state_ != 0) {
#line 167 "../../../src/plugins/locate-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 167 "../../../src/plugins/locate-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1234 "locate-plugin.c"
		}
	}
#line 167 "../../../src/plugins/locate-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 167 "../../../src/plugins/locate-plugin.vala"
	return FALSE;
#line 1241 "locate-plugin.c"
}

static SynapseResultSet*
synapse_locate_plugin_real_find_for_match (SynapseActionProvider* base,
                                           SynapseQuery* q,
                                           SynapseMatch* match)
{
	SynapseLocatePlugin * self;
	SynapseQueryFlags our_results = 0U;
	SynapseQueryFlags common_flags = 0U;
	SynapseQuery _tmp0_;
	SynapseQueryFlags _tmp1_;
	SynapseQueryFlags _tmp2_;
	gboolean _tmp3_ = FALSE;
	SynapseQueryFlags _tmp4_;
	SynapseQuery _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean query_empty = FALSE;
	SynapseQuery _tmp8_;
	const gchar* _tmp9_;
	SynapseResultSet* results = NULL;
	SynapseResultSet* _tmp10_;
	SynapseResultSet* result = NULL;
#line 170 "../../../src/plugins/locate-plugin.vala"
	self = (SynapseLocatePlugin*) base;
#line 170 "../../../src/plugins/locate-plugin.vala"
	g_return_val_if_fail (q != NULL, NULL);
#line 170 "../../../src/plugins/locate-plugin.vala"
	g_return_val_if_fail (match != NULL, NULL);
#line 172 "../../../src/plugins/locate-plugin.vala"
	our_results = (((SYNAPSE_QUERY_FLAGS_AUDIO | SYNAPSE_QUERY_FLAGS_DOCUMENTS) | SYNAPSE_QUERY_FLAGS_IMAGES) | SYNAPSE_QUERY_FLAGS_UNCATEGORIZED) | SYNAPSE_QUERY_FLAGS_VIDEO;
#line 175 "../../../src/plugins/locate-plugin.vala"
	_tmp0_ = *q;
#line 175 "../../../src/plugins/locate-plugin.vala"
	_tmp1_ = _tmp0_.query_type;
#line 175 "../../../src/plugins/locate-plugin.vala"
	_tmp2_ = our_results;
#line 175 "../../../src/plugins/locate-plugin.vala"
	common_flags = _tmp1_ & _tmp2_;
#line 177 "../../../src/plugins/locate-plugin.vala"
	_tmp4_ = common_flags;
#line 177 "../../../src/plugins/locate-plugin.vala"
	if (_tmp4_ == 0) {
#line 177 "../../../src/plugins/locate-plugin.vala"
		_tmp3_ = TRUE;
#line 1288 "locate-plugin.c"
	} else {
#line 177 "../../../src/plugins/locate-plugin.vala"
		_tmp3_ = !G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_UNKNOWN_MATCH);
#line 1292 "locate-plugin.c"
	}
#line 177 "../../../src/plugins/locate-plugin.vala"
	if (_tmp3_) {
#line 177 "../../../src/plugins/locate-plugin.vala"
		result = NULL;
#line 177 "../../../src/plugins/locate-plugin.vala"
		return result;
#line 1300 "locate-plugin.c"
	}
#line 180 "../../../src/plugins/locate-plugin.vala"
	_tmp5_ = *q;
#line 180 "../../../src/plugins/locate-plugin.vala"
	_tmp6_ = _tmp5_.query_string;
#line 180 "../../../src/plugins/locate-plugin.vala"
	_tmp7_ = string_strip (_tmp6_);
#line 180 "../../../src/plugins/locate-plugin.vala"
	_g_free0 ((*q).query_string);
#line 180 "../../../src/plugins/locate-plugin.vala"
	(*q).query_string = _tmp7_;
#line 181 "../../../src/plugins/locate-plugin.vala"
	_tmp8_ = *q;
#line 181 "../../../src/plugins/locate-plugin.vala"
	_tmp9_ = _tmp8_.query_string;
#line 181 "../../../src/plugins/locate-plugin.vala"
	query_empty = g_strcmp0 (_tmp9_, "") == 0;
#line 182 "../../../src/plugins/locate-plugin.vala"
	_tmp10_ = synapse_result_set_new ();
#line 182 "../../../src/plugins/locate-plugin.vala"
	results = _tmp10_;
#line 184 "../../../src/plugins/locate-plugin.vala"
	if (query_empty) {
#line 1324 "locate-plugin.c"
		SynapseResultSet* _tmp11_;
		SynapseLocatePluginLocateItem* _tmp12_;
		SynapseLocatePluginLocateItem* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
#line 186 "../../../src/plugins/locate-plugin.vala"
		_tmp11_ = results;
#line 186 "../../../src/plugins/locate-plugin.vala"
		_tmp12_ = self->priv->action;
#line 186 "../../../src/plugins/locate-plugin.vala"
		_tmp13_ = self->priv->action;
#line 186 "../../../src/plugins/locate-plugin.vala"
		_tmp14_ = synapse_locate_plugin_locate_item_get_default_relevancy (_tmp13_);
#line 186 "../../../src/plugins/locate-plugin.vala"
		_tmp15_ = _tmp14_;
#line 186 "../../../src/plugins/locate-plugin.vala"
		synapse_result_set_add (_tmp11_, (SynapseMatch*) _tmp12_, _tmp15_);
#line 1342 "locate-plugin.c"
	} else {
		GeeList* matchers = NULL;
		SynapseQuery _tmp16_;
		const gchar* _tmp17_;
		GeeList* _tmp18_;
#line 190 "../../../src/plugins/locate-plugin.vala"
		_tmp16_ = *q;
#line 190 "../../../src/plugins/locate-plugin.vala"
		_tmp17_ = _tmp16_.query_string;
#line 190 "../../../src/plugins/locate-plugin.vala"
		_tmp18_ = synapse_query_get_matchers_for_query (_tmp17_, 0, G_REGEX_CASELESS);
#line 190 "../../../src/plugins/locate-plugin.vala"
		matchers = _tmp18_;
#line 1356 "locate-plugin.c"
		{
			GeeList* _matcher_list = NULL;
			GeeList* _tmp19_;
			GeeList* _tmp20_;
			gint _matcher_size = 0;
			GeeList* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			gint _matcher_index = 0;
#line 192 "../../../src/plugins/locate-plugin.vala"
			_tmp19_ = matchers;
#line 192 "../../../src/plugins/locate-plugin.vala"
			_tmp20_ = _g_object_ref0 (_tmp19_);
#line 192 "../../../src/plugins/locate-plugin.vala"
			_matcher_list = _tmp20_;
#line 192 "../../../src/plugins/locate-plugin.vala"
			_tmp21_ = _matcher_list;
#line 192 "../../../src/plugins/locate-plugin.vala"
			_tmp22_ = gee_collection_get_size ((GeeCollection*) _tmp21_);
#line 192 "../../../src/plugins/locate-plugin.vala"
			_tmp23_ = _tmp22_;
#line 192 "../../../src/plugins/locate-plugin.vala"
			_matcher_size = _tmp23_;
#line 192 "../../../src/plugins/locate-plugin.vala"
			_matcher_index = -1;
#line 192 "../../../src/plugins/locate-plugin.vala"
			while (TRUE) {
#line 1384 "locate-plugin.c"
				gint _tmp24_;
				gint _tmp25_;
				GeeMapEntry* matcher = NULL;
				GeeList* _tmp26_;
				gpointer _tmp27_;
				GeeMapEntry* _tmp28_;
				gconstpointer _tmp29_;
				gconstpointer _tmp30_;
				SynapseLocatePluginLocateItem* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
#line 192 "../../../src/plugins/locate-plugin.vala"
				_matcher_index = _matcher_index + 1;
#line 192 "../../../src/plugins/locate-plugin.vala"
				_tmp24_ = _matcher_index;
#line 192 "../../../src/plugins/locate-plugin.vala"
				_tmp25_ = _matcher_size;
#line 192 "../../../src/plugins/locate-plugin.vala"
				if (!(_tmp24_ < _tmp25_)) {
#line 192 "../../../src/plugins/locate-plugin.vala"
					break;
#line 1406 "locate-plugin.c"
				}
#line 192 "../../../src/plugins/locate-plugin.vala"
				_tmp26_ = _matcher_list;
#line 192 "../../../src/plugins/locate-plugin.vala"
				_tmp27_ = gee_list_get (_tmp26_, _matcher_index);
#line 192 "../../../src/plugins/locate-plugin.vala"
				matcher = (GeeMapEntry*) _tmp27_;
#line 194 "../../../src/plugins/locate-plugin.vala"
				_tmp28_ = matcher;
#line 194 "../../../src/plugins/locate-plugin.vala"
				_tmp29_ = gee_map_entry_get_key (_tmp28_);
#line 194 "../../../src/plugins/locate-plugin.vala"
				_tmp30_ = _tmp29_;
#line 194 "../../../src/plugins/locate-plugin.vala"
				_tmp31_ = self->priv->action;
#line 194 "../../../src/plugins/locate-plugin.vala"
				_tmp32_ = synapse_match_get_title ((SynapseMatch*) _tmp31_);
#line 194 "../../../src/plugins/locate-plugin.vala"
				_tmp33_ = _tmp32_;
#line 194 "../../../src/plugins/locate-plugin.vala"
				if (g_regex_match ((GRegex*) _tmp30_, _tmp33_, 0, NULL)) {
#line 1428 "locate-plugin.c"
					SynapseResultSet* _tmp34_;
					SynapseLocatePluginLocateItem* _tmp35_;
					GeeMapEntry* _tmp36_;
					gconstpointer _tmp37_;
					gconstpointer _tmp38_;
#line 196 "../../../src/plugins/locate-plugin.vala"
					_tmp34_ = results;
#line 196 "../../../src/plugins/locate-plugin.vala"
					_tmp35_ = self->priv->action;
#line 196 "../../../src/plugins/locate-plugin.vala"
					_tmp36_ = matcher;
#line 196 "../../../src/plugins/locate-plugin.vala"
					_tmp37_ = gee_map_entry_get_value (_tmp36_);
#line 196 "../../../src/plugins/locate-plugin.vala"
					_tmp38_ = _tmp37_;
#line 196 "../../../src/plugins/locate-plugin.vala"
					synapse_result_set_add (_tmp34_, (SynapseMatch*) _tmp35_, (gint) ((gintptr) _tmp38_));
#line 197 "../../../src/plugins/locate-plugin.vala"
					_g_object_unref0 (matcher);
#line 197 "../../../src/plugins/locate-plugin.vala"
					break;
#line 1450 "locate-plugin.c"
				}
#line 192 "../../../src/plugins/locate-plugin.vala"
				_g_object_unref0 (matcher);
#line 1454 "locate-plugin.c"
			}
#line 192 "../../../src/plugins/locate-plugin.vala"
			_g_object_unref0 (_matcher_list);
#line 1458 "locate-plugin.c"
		}
#line 184 "../../../src/plugins/locate-plugin.vala"
		_g_object_unref0 (matchers);
#line 1462 "locate-plugin.c"
	}
#line 202 "../../../src/plugins/locate-plugin.vala"
	result = results;
#line 202 "../../../src/plugins/locate-plugin.vala"
	return result;
#line 1468 "locate-plugin.c"
}

SynapseLocatePlugin*
synapse_locate_plugin_construct (GType object_type)
{
	SynapseLocatePlugin * self = NULL;
#line 24 "../../../src/plugins/locate-plugin.vala"
	self = (SynapseLocatePlugin*) g_object_new (object_type, NULL);
#line 24 "../../../src/plugins/locate-plugin.vala"
	return self;
#line 1479 "locate-plugin.c"
}

SynapseLocatePlugin*
synapse_locate_plugin_new (void)
{
#line 24 "../../../src/plugins/locate-plugin.vala"
	return synapse_locate_plugin_construct (SYNAPSE_TYPE_LOCATE_PLUGIN);
#line 1487 "locate-plugin.c"
}

static gboolean
synapse_locate_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseLocatePlugin* self;
#line 26 "../../../src/plugins/locate-plugin.vala"
	self = (SynapseLocatePlugin*) base;
#line 26 "../../../src/plugins/locate-plugin.vala"
	result = self->priv->_enabled;
#line 26 "../../../src/plugins/locate-plugin.vala"
	return result;
#line 1501 "locate-plugin.c"
}

static void
synapse_locate_plugin_real_set_enabled (SynapseActivatable* base,
                                        gboolean value)
{
	SynapseLocatePlugin* self;
	gboolean old_value;
#line 26 "../../../src/plugins/locate-plugin.vala"
	self = (SynapseLocatePlugin*) base;
#line 26 "../../../src/plugins/locate-plugin.vala"
	old_value = synapse_locate_plugin_real_get_enabled (base);
#line 26 "../../../src/plugins/locate-plugin.vala"
	if (old_value != value) {
#line 26 "../../../src/plugins/locate-plugin.vala"
		self->priv->_enabled = value;
#line 26 "../../../src/plugins/locate-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_locate_plugin_properties[SYNAPSE_LOCATE_PLUGIN_ENABLED_PROPERTY]);
#line 1520 "locate-plugin.c"
	}
}

static inline gpointer
synapse_locate_plugin_locate_item_get_instance_private (SynapseLocatePluginLocateItem* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseLocatePluginLocateItem_private_offset);
}

static void
synapse_locate_plugin_locate_item_real_search_data_free (gpointer _data)
{
	SynapseLocatePluginLocateItemSearchData* _data_;
	_data_ = _data;
#line 38 "../../../src/plugins/locate-plugin.vala"
	_g_free0 (_data_->query);
#line 38 "../../../src/plugins/locate-plugin.vala"
	_g_object_unref0 (_data_->dest_result_set);
#line 38 "../../../src/plugins/locate-plugin.vala"
	_g_object_unref0 (_data_->cancellable);
#line 38 "../../../src/plugins/locate-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 38 "../../../src/plugins/locate-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 38 "../../../src/plugins/locate-plugin.vala"
	g_slice_free (SynapseLocatePluginLocateItemSearchData, _data_);
#line 1547 "locate-plugin.c"
}

static void
synapse_locate_plugin_locate_item_real_search (SynapseSearchMatch* base,
                                               const gchar* query,
                                               SynapseQueryFlags flags,
                                               SynapseResultSet* dest_result_set,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	SynapseLocatePluginLocateItem * self;
	SynapseLocatePluginLocateItemSearchData* _data_;
	SynapseLocatePluginLocateItem* _tmp0_;
	gchar* _tmp1_;
	SynapseResultSet* _tmp2_;
	GCancellable* _tmp3_;
#line 38 "../../../src/plugins/locate-plugin.vala"
	self = (SynapseLocatePluginLocateItem*) base;
#line 38 "../../../src/plugins/locate-plugin.vala"
	_data_ = g_slice_new0 (SynapseLocatePluginLocateItemSearchData);
#line 38 "../../../src/plugins/locate-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 38 "../../../src/plugins/locate-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_locate_plugin_locate_item_real_search_data_free);
#line 38 "../../../src/plugins/locate-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 38 "../../../src/plugins/locate-plugin.vala"
	_data_->self = _tmp0_;
#line 38 "../../../src/plugins/locate-plugin.vala"
	_tmp1_ = g_strdup (query);
#line 38 "../../../src/plugins/locate-plugin.vala"
	_g_free0 (_data_->query);
#line 38 "../../../src/plugins/locate-plugin.vala"
	_data_->query = _tmp1_;
#line 38 "../../../src/plugins/locate-plugin.vala"
	_data_->flags = flags;
#line 38 "../../../src/plugins/locate-plugin.vala"
	_tmp2_ = _g_object_ref0 (dest_result_set);
#line 38 "../../../src/plugins/locate-plugin.vala"
	_g_object_unref0 (_data_->dest_result_set);
#line 38 "../../../src/plugins/locate-plugin.vala"
	_data_->dest_result_set = _tmp2_;
#line 38 "../../../src/plugins/locate-plugin.vala"
	_tmp3_ = _g_object_ref0 (cancellable);
#line 38 "../../../src/plugins/locate-plugin.vala"
	_g_object_unref0 (_data_->cancellable);
#line 38 "../../../src/plugins/locate-plugin.vala"
	_data_->cancellable = _tmp3_;
#line 38 "../../../src/plugins/locate-plugin.vala"
	synapse_locate_plugin_locate_item_real_search_co (_data_);
#line 1599 "locate-plugin.c"
}

static GeeList*
synapse_locate_plugin_locate_item_search_finish (SynapseSearchMatch* base,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	GeeList* result;
	SynapseLocatePluginLocateItemSearchData* _data_;
#line 38 "../../../src/plugins/locate-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 38 "../../../src/plugins/locate-plugin.vala"
	if (NULL == _data_) {
#line 38 "../../../src/plugins/locate-plugin.vala"
		return NULL;
#line 1615 "locate-plugin.c"
	}
#line 38 "../../../src/plugins/locate-plugin.vala"
	result = _data_->result;
#line 38 "../../../src/plugins/locate-plugin.vala"
	_data_->result = NULL;
#line 38 "../../../src/plugins/locate-plugin.vala"
	return result;
#line 1623 "locate-plugin.c"
}

static void
synapse_locate_plugin_locate_item_search_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	SynapseLocatePluginLocateItemSearchData* _data_;
#line 50 "../../../src/plugins/locate-plugin.vala"
	_data_ = _user_data_;
#line 50 "../../../src/plugins/locate-plugin.vala"
	_data_->_source_object_ = source_object;
#line 50 "../../../src/plugins/locate-plugin.vala"
	_data_->_res_ = _res_;
#line 50 "../../../src/plugins/locate-plugin.vala"
	synapse_locate_plugin_locate_item_real_search_co (_data_);
#line 1640 "locate-plugin.c"
}

static gboolean
synapse_locate_plugin_locate_item_real_search_co (SynapseLocatePluginLocateItemSearchData* _data_)
{
#line 43 "../../../src/plugins/locate-plugin.vala"
	switch (_data_->_state_) {
#line 43 "../../../src/plugins/locate-plugin.vala"
		case 0:
#line 1650 "locate-plugin.c"
		goto _state_0;
#line 43 "../../../src/plugins/locate-plugin.vala"
		case 1:
#line 1654 "locate-plugin.c"
		goto _state_1;
		default:
#line 43 "../../../src/plugins/locate-plugin.vala"
		g_assert_not_reached ();
#line 1659 "locate-plugin.c"
	}
	_state_0:
#line 48 "../../../src/plugins/locate-plugin.vala"
	synapse_query_init (&_data_->q, (guint) 0, _data_->query, _data_->flags, (guint) 96);
#line 49 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp0_ = _g_object_ref0 (_data_->cancellable);
#line 49 "../../../src/plugins/locate-plugin.vala"
	_g_object_unref0 (_data_->q.cancellable);
#line 49 "../../../src/plugins/locate-plugin.vala"
	_data_->q.cancellable = _data_->_tmp0_;
#line 50 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp1_ = _data_->self->priv->plugin;
#line 50 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp2_ = _data_->q;
#line 50 "../../../src/plugins/locate-plugin.vala"
	_data_->_state_ = 1;
#line 50 "../../../src/plugins/locate-plugin.vala"
	synapse_locate_plugin_locate (_data_->_tmp1_, &_data_->_tmp2_, synapse_locate_plugin_locate_item_search_ready, _data_);
#line 50 "../../../src/plugins/locate-plugin.vala"
	return FALSE;
#line 1680 "locate-plugin.c"
	_state_1:
#line 50 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp3_ = synapse_locate_plugin_locate_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
#line 50 "../../../src/plugins/locate-plugin.vala"
	_data_->results = _data_->_tmp3_;
#line 50 "../../../src/plugins/locate-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 50 "../../../src/plugins/locate-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 50 "../../../src/plugins/locate-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 50 "../../../src/plugins/locate-plugin.vala"
			synapse_query_destroy (&_data_->q);
#line 50 "../../../src/plugins/locate-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 50 "../../../src/plugins/locate-plugin.vala"
			return FALSE;
#line 1698 "locate-plugin.c"
		} else {
#line 50 "../../../src/plugins/locate-plugin.vala"
			synapse_query_destroy (&_data_->q);
#line 50 "../../../src/plugins/locate-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 50 "../../../src/plugins/locate-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 50 "../../../src/plugins/locate-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 50 "../../../src/plugins/locate-plugin.vala"
			return FALSE;
#line 1710 "locate-plugin.c"
		}
	}
#line 51 "../../../src/plugins/locate-plugin.vala"
	synapse_result_set_add_all (_data_->dest_result_set, _data_->results);
#line 53 "../../../src/plugins/locate-plugin.vala"
	_data_->_tmp4_ = synapse_result_set_get_sorted_list (_data_->dest_result_set);
#line 53 "../../../src/plugins/locate-plugin.vala"
	_data_->result = _data_->_tmp4_;
#line 53 "../../../src/plugins/locate-plugin.vala"
	_g_object_unref0 (_data_->results);
#line 53 "../../../src/plugins/locate-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 53 "../../../src/plugins/locate-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 53 "../../../src/plugins/locate-plugin.vala"
	if (_data_->_state_ != 0) {
#line 53 "../../../src/plugins/locate-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 53 "../../../src/plugins/locate-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1731 "locate-plugin.c"
		}
	}
#line 53 "../../../src/plugins/locate-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 53 "../../../src/plugins/locate-plugin.vala"
	return FALSE;
#line 1738 "locate-plugin.c"
}

static SynapseLocatePluginLocateItem*
synapse_locate_plugin_locate_item_construct (GType object_type,
                                             SynapseLocatePlugin* plugin)
{
	SynapseLocatePluginLocateItem * self = NULL;
#line 58 "../../../src/plugins/locate-plugin.vala"
	g_return_val_if_fail (plugin != NULL, NULL);
#line 60 "../../../src/plugins/locate-plugin.vala"
	self = (SynapseLocatePluginLocateItem*) g_object_new (object_type, "has-thumbnail", FALSE, "icon-name", "search", "title", _ ("Locate"), "description", _ ("Locate files with this name on the filesystem"), NULL);
#line 64 "../../../src/plugins/locate-plugin.vala"
	self->priv->plugin = plugin;
#line 58 "../../../src/plugins/locate-plugin.vala"
	return self;
#line 1754 "locate-plugin.c"
}

static SynapseLocatePluginLocateItem*
synapse_locate_plugin_locate_item_new (SynapseLocatePlugin* plugin)
{
#line 58 "../../../src/plugins/locate-plugin.vala"
	return synapse_locate_plugin_locate_item_construct (SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM, plugin);
#line 1762 "locate-plugin.c"
}

static gint
synapse_locate_plugin_locate_item_get_default_relevancy (SynapseLocatePluginLocateItem* self)
{
	gint result;
#line 40 "../../../src/plugins/locate-plugin.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 40 "../../../src/plugins/locate-plugin.vala"
	result = self->priv->_default_relevancy;
#line 40 "../../../src/plugins/locate-plugin.vala"
	return result;
#line 1775 "locate-plugin.c"
}

static void
synapse_locate_plugin_locate_item_set_default_relevancy (SynapseLocatePluginLocateItem* self,
                                                         gint value)
{
	gint old_value;
#line 40 "../../../src/plugins/locate-plugin.vala"
	g_return_if_fail (self != NULL);
#line 40 "../../../src/plugins/locate-plugin.vala"
	old_value = synapse_locate_plugin_locate_item_get_default_relevancy (self);
#line 40 "../../../src/plugins/locate-plugin.vala"
	if (old_value != value) {
#line 40 "../../../src/plugins/locate-plugin.vala"
		self->priv->_default_relevancy = value;
#line 40 "../../../src/plugins/locate-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_locate_plugin_locate_item_properties[SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_DEFAULT_RELEVANCY_PROPERTY]);
#line 1793 "locate-plugin.c"
	}
}

static void
synapse_locate_plugin_locate_item_class_init (SynapseLocatePluginLocateItemClass * klass,
                                              gpointer klass_data)
{
#line 38 "../../../src/plugins/locate-plugin.vala"
	synapse_locate_plugin_locate_item_parent_class = g_type_class_peek_parent (klass);
#line 38 "../../../src/plugins/locate-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseLocatePluginLocateItem_private_offset);
#line 38 "../../../src/plugins/locate-plugin.vala"
	((SynapseSearchMatchClass *) klass)->search = (void (*) (SynapseSearchMatch*, const gchar*, SynapseQueryFlags, SynapseResultSet*, GCancellable*, GAsyncReadyCallback, gpointer)) synapse_locate_plugin_locate_item_real_search;
#line 38 "../../../src/plugins/locate-plugin.vala"
	((SynapseSearchMatchClass *) klass)->search_finish = (GeeList* (*) (SynapseSearchMatch*, GAsyncResult*, GError**)) synapse_locate_plugin_locate_item_search_finish;
#line 38 "../../../src/plugins/locate-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_locate_plugin_locate_item_get_property;
#line 38 "../../../src/plugins/locate-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_locate_plugin_locate_item_set_property;
#line 38 "../../../src/plugins/locate-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_locate_plugin_locate_item_finalize;
#line 38 "../../../src/plugins/locate-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_DEFAULT_RELEVANCY_PROPERTY, synapse_locate_plugin_locate_item_properties[SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_DEFAULT_RELEVANCY_PROPERTY] = g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, (gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1817 "locate-plugin.c"
}

static void
synapse_locate_plugin_locate_item_instance_init (SynapseLocatePluginLocateItem * self,
                                                 gpointer klass)
{
#line 38 "../../../src/plugins/locate-plugin.vala"
	self->priv = synapse_locate_plugin_locate_item_get_instance_private (self);
#line 40 "../../../src/plugins/locate-plugin.vala"
	self->priv->_default_relevancy = (gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL;
#line 1828 "locate-plugin.c"
}

static void
synapse_locate_plugin_locate_item_finalize (GObject * obj)
{
	SynapseLocatePluginLocateItem * self;
#line 38 "../../../src/plugins/locate-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM, SynapseLocatePluginLocateItem);
#line 38 "../../../src/plugins/locate-plugin.vala"
	G_OBJECT_CLASS (synapse_locate_plugin_locate_item_parent_class)->finalize (obj);
#line 1839 "locate-plugin.c"
}

static GType
synapse_locate_plugin_locate_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseLocatePluginLocateItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_locate_plugin_locate_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseLocatePluginLocateItem), 0, (GInstanceInitFunc) synapse_locate_plugin_locate_item_instance_init, NULL };
	GType synapse_locate_plugin_locate_item_type_id;
	synapse_locate_plugin_locate_item_type_id = g_type_register_static (SYNAPSE_TYPE_SEARCH_MATCH, "SynapseLocatePluginLocateItem", &g_define_type_info, 0);
	SynapseLocatePluginLocateItem_private_offset = g_type_add_instance_private (synapse_locate_plugin_locate_item_type_id, sizeof (SynapseLocatePluginLocateItemPrivate));
	return synapse_locate_plugin_locate_item_type_id;
}

static GType
synapse_locate_plugin_locate_item_get_type (void)
{
	static volatile gsize synapse_locate_plugin_locate_item_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_locate_plugin_locate_item_type_id__volatile)) {
		GType synapse_locate_plugin_locate_item_type_id;
		synapse_locate_plugin_locate_item_type_id = synapse_locate_plugin_locate_item_get_type_once ();
		g_once_init_leave (&synapse_locate_plugin_locate_item_type_id__volatile, synapse_locate_plugin_locate_item_type_id);
	}
	return synapse_locate_plugin_locate_item_type_id__volatile;
}

static void
_vala_synapse_locate_plugin_locate_item_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec)
{
	SynapseLocatePluginLocateItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM, SynapseLocatePluginLocateItem);
#line 38 "../../../src/plugins/locate-plugin.vala"
	switch (property_id) {
#line 38 "../../../src/plugins/locate-plugin.vala"
		case SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_DEFAULT_RELEVANCY_PROPERTY:
#line 38 "../../../src/plugins/locate-plugin.vala"
		g_value_set_int (value, synapse_locate_plugin_locate_item_get_default_relevancy (self));
#line 38 "../../../src/plugins/locate-plugin.vala"
		break;
#line 1880 "locate-plugin.c"
		default:
#line 38 "../../../src/plugins/locate-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "../../../src/plugins/locate-plugin.vala"
		break;
#line 1886 "locate-plugin.c"
	}
}

static void
_vala_synapse_locate_plugin_locate_item_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec)
{
	SynapseLocatePluginLocateItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_LOCATE_PLUGIN_TYPE_LOCATE_ITEM, SynapseLocatePluginLocateItem);
#line 38 "../../../src/plugins/locate-plugin.vala"
	switch (property_id) {
#line 38 "../../../src/plugins/locate-plugin.vala"
		case SYNAPSE_LOCATE_PLUGIN_LOCATE_ITEM_DEFAULT_RELEVANCY_PROPERTY:
#line 38 "../../../src/plugins/locate-plugin.vala"
		synapse_locate_plugin_locate_item_set_default_relevancy (self, g_value_get_int (value));
#line 38 "../../../src/plugins/locate-plugin.vala"
		break;
#line 1906 "locate-plugin.c"
		default:
#line 38 "../../../src/plugins/locate-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "../../../src/plugins/locate-plugin.vala"
		break;
#line 1912 "locate-plugin.c"
	}
}

static GObject *
synapse_locate_plugin_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseLocatePlugin * self;
	SynapseLocatePluginLocateItem* _tmp0_;
#line 88 "../../../src/plugins/locate-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_locate_plugin_parent_class);
#line 88 "../../../src/plugins/locate-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 88 "../../../src/plugins/locate-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_LOCATE_PLUGIN, SynapseLocatePlugin);
#line 90 "../../../src/plugins/locate-plugin.vala"
	_tmp0_ = synapse_locate_plugin_locate_item_new (self);
#line 90 "../../../src/plugins/locate-plugin.vala"
	_g_object_unref0 (self->priv->action);
#line 90 "../../../src/plugins/locate-plugin.vala"
	self->priv->action = _tmp0_;
#line 88 "../../../src/plugins/locate-plugin.vala"
	return obj;
#line 1939 "locate-plugin.c"
}

static void
synapse_locate_plugin_class_init (SynapseLocatePluginClass * klass,
                                  gpointer klass_data)
{
#line 24 "../../../src/plugins/locate-plugin.vala"
	synapse_locate_plugin_parent_class = g_type_class_peek_parent (klass);
#line 24 "../../../src/plugins/locate-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseLocatePlugin_private_offset);
#line 24 "../../../src/plugins/locate-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_locate_plugin_get_property;
#line 24 "../../../src/plugins/locate-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_locate_plugin_set_property;
#line 24 "../../../src/plugins/locate-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_locate_plugin_constructor;
#line 24 "../../../src/plugins/locate-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_locate_plugin_finalize;
#line 24 "../../../src/plugins/locate-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_LOCATE_PLUGIN_ENABLED_PROPERTY, synapse_locate_plugin_properties[SYNAPSE_LOCATE_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 83 "../../../src/plugins/locate-plugin.vala"
	synapse_locate_plugin_register_plugin ();
#line 1962 "locate-plugin.c"
}

static void
synapse_locate_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                          gpointer iface_data)
{
#line 24 "../../../src/plugins/locate-plugin.vala"
	synapse_locate_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../../../src/plugins/locate-plugin.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_locate_plugin_real_activate;
#line 24 "../../../src/plugins/locate-plugin.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_locate_plugin_real_deactivate;
#line 24 "../../../src/plugins/locate-plugin.vala"
	iface->get_enabled = synapse_locate_plugin_real_get_enabled;
#line 24 "../../../src/plugins/locate-plugin.vala"
	iface->set_enabled = synapse_locate_plugin_real_set_enabled;
#line 1979 "locate-plugin.c"
}

static void
synapse_locate_plugin_synapse_action_provider_interface_init (SynapseActionProviderIface * iface,
                                                              gpointer iface_data)
{
#line 24 "../../../src/plugins/locate-plugin.vala"
	synapse_locate_plugin_synapse_action_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../../../src/plugins/locate-plugin.vala"
	iface->handles_unknown = (gboolean (*) (SynapseActionProvider*)) synapse_locate_plugin_real_handles_unknown;
#line 24 "../../../src/plugins/locate-plugin.vala"
	iface->find_for_match = (SynapseResultSet* (*) (SynapseActionProvider*, SynapseQuery*, SynapseMatch*)) synapse_locate_plugin_real_find_for_match;
#line 1992 "locate-plugin.c"
}

static void
synapse_locate_plugin_instance_init (SynapseLocatePlugin * self,
                                     gpointer klass)
{
#line 24 "../../../src/plugins/locate-plugin.vala"
	self->priv = synapse_locate_plugin_get_instance_private (self);
#line 26 "../../../src/plugins/locate-plugin.vala"
	self->priv->_enabled = TRUE;
#line 2003 "locate-plugin.c"
}

static void
synapse_locate_plugin_finalize (GObject * obj)
{
	SynapseLocatePlugin * self;
#line 24 "../../../src/plugins/locate-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_LOCATE_PLUGIN, SynapseLocatePlugin);
#line 86 "../../../src/plugins/locate-plugin.vala"
	_g_object_unref0 (self->priv->action);
#line 24 "../../../src/plugins/locate-plugin.vala"
	G_OBJECT_CLASS (synapse_locate_plugin_parent_class)->finalize (obj);
#line 2016 "locate-plugin.c"
}

static GType
synapse_locate_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseLocatePluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_locate_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseLocatePlugin), 0, (GInstanceInitFunc) synapse_locate_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_locate_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_action_provider_info = { (GInterfaceInitFunc) synapse_locate_plugin_synapse_action_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_locate_plugin_type_id;
	synapse_locate_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseLocatePlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_locate_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_locate_plugin_type_id, SYNAPSE_TYPE_ACTION_PROVIDER, &synapse_action_provider_info);
	SynapseLocatePlugin_private_offset = g_type_add_instance_private (synapse_locate_plugin_type_id, sizeof (SynapseLocatePluginPrivate));
	return synapse_locate_plugin_type_id;
}

GType
synapse_locate_plugin_get_type (void)
{
	static volatile gsize synapse_locate_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_locate_plugin_type_id__volatile)) {
		GType synapse_locate_plugin_type_id;
		synapse_locate_plugin_type_id = synapse_locate_plugin_get_type_once ();
		g_once_init_leave (&synapse_locate_plugin_type_id__volatile, synapse_locate_plugin_type_id);
	}
	return synapse_locate_plugin_type_id__volatile;
}

static void
_vala_synapse_locate_plugin_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	SynapseLocatePlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_LOCATE_PLUGIN, SynapseLocatePlugin);
#line 24 "../../../src/plugins/locate-plugin.vala"
	switch (property_id) {
#line 24 "../../../src/plugins/locate-plugin.vala"
		case SYNAPSE_LOCATE_PLUGIN_ENABLED_PROPERTY:
#line 24 "../../../src/plugins/locate-plugin.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 24 "../../../src/plugins/locate-plugin.vala"
		break;
#line 2061 "locate-plugin.c"
		default:
#line 24 "../../../src/plugins/locate-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../../../src/plugins/locate-plugin.vala"
		break;
#line 2067 "locate-plugin.c"
	}
}

static void
_vala_synapse_locate_plugin_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	SynapseLocatePlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_LOCATE_PLUGIN, SynapseLocatePlugin);
#line 24 "../../../src/plugins/locate-plugin.vala"
	switch (property_id) {
#line 24 "../../../src/plugins/locate-plugin.vala"
		case SYNAPSE_LOCATE_PLUGIN_ENABLED_PROPERTY:
#line 24 "../../../src/plugins/locate-plugin.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 24 "../../../src/plugins/locate-plugin.vala"
		break;
#line 2087 "locate-plugin.c"
		default:
#line 24 "../../../src/plugins/locate-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../../../src/plugins/locate-plugin.vala"
		break;
#line 2093 "locate-plugin.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

