/* selection-plugin.c generated by valac 0.48.17, the Vala compiler
 * generated from selection-plugin.vala, do not modify */

/*
 * Copyright (C) 2011 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib-object.h>
#include <synapse-core.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#define SYNAPSE_TYPE_SELECTION_PLUGIN (synapse_selection_plugin_get_type ())
#define SYNAPSE_SELECTION_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_SELECTION_PLUGIN, SynapseSelectionPlugin))
#define SYNAPSE_SELECTION_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_SELECTION_PLUGIN, SynapseSelectionPluginClass))
#define SYNAPSE_IS_SELECTION_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_SELECTION_PLUGIN))
#define SYNAPSE_IS_SELECTION_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_SELECTION_PLUGIN))
#define SYNAPSE_SELECTION_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_SELECTION_PLUGIN, SynapseSelectionPluginClass))

typedef struct _SynapseSelectionPlugin SynapseSelectionPlugin;
typedef struct _SynapseSelectionPluginClass SynapseSelectionPluginClass;
typedef struct _SynapseSelectionPluginPrivate SynapseSelectionPluginPrivate;

#define SYNAPSE_SELECTION_PLUGIN_TYPE_SELECTED_TEXT_ITEM (synapse_selection_plugin_selected_text_item_get_type ())
#define SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_SELECTION_PLUGIN_TYPE_SELECTED_TEXT_ITEM, SynapseSelectionPluginSelectedTextItem))
#define SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_SELECTION_PLUGIN_TYPE_SELECTED_TEXT_ITEM, SynapseSelectionPluginSelectedTextItemClass))
#define SYNAPSE_SELECTION_PLUGIN_IS_SELECTED_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_SELECTION_PLUGIN_TYPE_SELECTED_TEXT_ITEM))
#define SYNAPSE_SELECTION_PLUGIN_IS_SELECTED_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_SELECTION_PLUGIN_TYPE_SELECTED_TEXT_ITEM))
#define SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_SELECTION_PLUGIN_TYPE_SELECTED_TEXT_ITEM, SynapseSelectionPluginSelectedTextItemClass))

typedef struct _SynapseSelectionPluginSelectedTextItem SynapseSelectionPluginSelectedTextItem;
typedef struct _SynapseSelectionPluginSelectedTextItemClass SynapseSelectionPluginSelectedTextItemClass;
enum  {
	SYNAPSE_SELECTION_PLUGIN_0_PROPERTY,
	SYNAPSE_SELECTION_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_SELECTION_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_selection_plugin_properties[SYNAPSE_SELECTION_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block8Data Block8Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SynapseSelectionPluginSearchData SynapseSelectionPluginSearchData;
typedef struct _SynapseSelectionPluginSelectedTextItemPrivate SynapseSelectionPluginSelectedTextItemPrivate;
enum  {
	SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_0_PROPERTY,
	SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_NUM_PROPERTIES
};
static GParamSpec* synapse_selection_plugin_selected_text_item_properties[SYNAPSE_SELECTION_PLUGIN_SELECTED_TEXT_ITEM_NUM_PROPERTIES];
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _SynapseSelectionPlugin {
	GObject parent_instance;
	SynapseSelectionPluginPrivate * priv;
};

struct _SynapseSelectionPluginClass {
	GObjectClass parent_class;
};

struct _SynapseSelectionPluginPrivate {
	gboolean _enabled;
	GtkClipboard* clipboard;
	SynapseSelectionPluginSelectedTextItem* item;
	gboolean cb_changed;
};

struct _Block8Data {
	int _ref_count_;
	SynapseSelectionPlugin* self;
	gchar* cb_text;
	gpointer _async_data_;
};

struct _SynapseSelectionPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseSelectionPlugin* self;
	SynapseQuery query;
	SynapseResultSet* result;
	Block8Data* _data8_;
	GeeList* matchers;
	SynapseQuery _tmp0_;
	const gchar* _tmp1_;
	GeeList* _tmp2_;
	gint relevancy;
	GeeList* _matcher_list;
	GeeList* _tmp3_;
	GeeList* _tmp4_;
	gint _matcher_size;
	GeeList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _matcher_index;
	gint _tmp8_;
	gint _tmp9_;
	GeeMapEntry* matcher;
	GeeList* _tmp10_;
	gpointer _tmp11_;
	GeeMapEntry* _tmp12_;
	gconstpointer _tmp13_;
	gconstpointer _tmp14_;
	SynapseSelectionPluginSelectedTextItem* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	GeeMapEntry* _tmp18_;
	gconstpointer _tmp19_;
	gconstpointer _tmp20_;
	GtkClipboard* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	SynapseSelectionPluginSelectedTextItem* _tmp24_;
	gchar* _tmp25_;
	SynapseResultSet* results;
	SynapseResultSet* _tmp26_;
	SynapseResultSet* _tmp27_;
	SynapseSelectionPluginSelectedTextItem* _tmp28_;
	GError* _inner_error0_;
};

struct _SynapseSelectionPluginSelectedTextItem {
	SynapseTextMatch parent_instance;
	SynapseSelectionPluginSelectedTextItemPrivate * priv;
};

struct _SynapseSelectionPluginSelectedTextItemClass {
	SynapseTextMatchClass parent_class;
};

struct _SynapseSelectionPluginSelectedTextItemPrivate {
	gchar* content;
};

static gint SynapseSelectionPlugin_private_offset;
static gpointer synapse_selection_plugin_parent_class = NULL;
static gint SynapseSelectionPluginSelectedTextItem_private_offset;
static gpointer synapse_selection_plugin_selected_text_item_parent_class = NULL;
static SynapseActivatableIface * synapse_selection_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_selection_plugin_synapse_item_provider_parent_iface = NULL;

GType synapse_selection_plugin_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseSelectionPlugin, g_object_unref)
static GType synapse_selection_plugin_selected_text_item_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseSelectionPluginSelectedTextItem, g_object_unref)
static void synapse_selection_plugin_real_activate (SynapseActivatable* base);
static SynapseSelectionPluginSelectedTextItem* synapse_selection_plugin_selected_text_item_new (void);
static SynapseSelectionPluginSelectedTextItem* synapse_selection_plugin_selected_text_item_construct (GType object_type);
static void synapse_selection_plugin_cb_owner_change (SynapseSelectionPlugin* self);
static void _synapse_selection_plugin_cb_owner_change_gtk_clipboard_owner_change (GtkClipboard* _sender,
                                                                           GdkEventOwnerChange* event,
                                                                           gpointer self);
static void synapse_selection_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_selection_plugin_register_plugin (void);
static void _synapse_selection_plugin_register_plugin_synapse_plugin_register_func (void);
static gboolean synapse_selection_plugin_real_handles_query (SynapseItemProvider* base,
                                                      SynapseQuery* query);
static void synapse_selection_plugin_real_search_data_free (gpointer _data);
static void synapse_selection_plugin_real_search (SynapseItemProvider* base,
                                           SynapseQuery* query,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean synapse_selection_plugin_real_search_co (SynapseSelectionPluginSearchData* _data_);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void ___lambda30_ (Block8Data* _data8_,
                   GtkClipboard* cb,
                   const gchar* text);
static void ____lambda30__gtk_clipboard_text_received_func (GtkClipboard* clipboard,
                                                     const gchar* text,
                                                     gpointer self);
static gboolean _synapse_selection_plugin_real_search_co_gsource_func (gpointer self);
static void synapse_selection_plugin_selected_text_item_update_content (SynapseSelectionPluginSelectedTextItem* self,
                                                                 gchar* content);
SynapseSelectionPlugin* synapse_selection_plugin_new (void);
SynapseSelectionPlugin* synapse_selection_plugin_construct (GType object_type);
static gchar* synapse_selection_plugin_selected_text_item_real_get_text (SynapseTextMatch* base);
static void synapse_selection_plugin_selected_text_item_finalize (GObject * obj);
static GType synapse_selection_plugin_selected_text_item_get_type_once (void);
static void synapse_selection_plugin_finalize (GObject * obj);
static GType synapse_selection_plugin_get_type_once (void);
static void _vala_synapse_selection_plugin_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_synapse_selection_plugin_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);

static inline gpointer
synapse_selection_plugin_get_instance_private (SynapseSelectionPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseSelectionPlugin_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 34 "../../../src/plugins/selection-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 226 "selection-plugin.c"
}

static void
_synapse_selection_plugin_cb_owner_change_gtk_clipboard_owner_change (GtkClipboard* _sender,
                                                                      GdkEventOwnerChange* event,
                                                                      gpointer self)
{
#line 35 "../../../src/plugins/selection-plugin.vala"
	synapse_selection_plugin_cb_owner_change ((SynapseSelectionPlugin*) self);
#line 236 "selection-plugin.c"
}

static void
synapse_selection_plugin_real_activate (SynapseActivatable* base)
{
	SynapseSelectionPlugin * self;
	SynapseSelectionPluginSelectedTextItem* _tmp0_;
	GtkClipboard* _tmp1_;
	GtkClipboard* _tmp2_;
	GtkClipboard* _tmp3_;
#line 31 "../../../src/plugins/selection-plugin.vala"
	self = (SynapseSelectionPlugin*) base;
#line 33 "../../../src/plugins/selection-plugin.vala"
	_tmp0_ = synapse_selection_plugin_selected_text_item_new ();
#line 33 "../../../src/plugins/selection-plugin.vala"
	_g_object_unref0 (self->priv->item);
#line 33 "../../../src/plugins/selection-plugin.vala"
	self->priv->item = _tmp0_;
#line 34 "../../../src/plugins/selection-plugin.vala"
	_tmp1_ = gtk_clipboard_get (GDK_SELECTION_PRIMARY);
#line 34 "../../../src/plugins/selection-plugin.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 34 "../../../src/plugins/selection-plugin.vala"
	_g_object_unref0 (self->priv->clipboard);
#line 34 "../../../src/plugins/selection-plugin.vala"
	self->priv->clipboard = _tmp2_;
#line 35 "../../../src/plugins/selection-plugin.vala"
	_tmp3_ = self->priv->clipboard;
#line 35 "../../../src/plugins/selection-plugin.vala"
	g_signal_connect_object (_tmp3_, "owner-change", (GCallback) _synapse_selection_plugin_cb_owner_change_gtk_clipboard_owner_change, self, 0);
#line 267 "selection-plugin.c"
}

static void
synapse_selection_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseSelectionPlugin * self;
	GtkClipboard* _tmp0_;
	guint _tmp1_;
#line 38 "../../../src/plugins/selection-plugin.vala"
	self = (SynapseSelectionPlugin*) base;
#line 40 "../../../src/plugins/selection-plugin.vala"
	_tmp0_ = self->priv->clipboard;
#line 40 "../../../src/plugins/selection-plugin.vala"
	g_signal_parse_name ("owner-change", gtk_clipboard_get_type (), &_tmp1_, NULL, FALSE);
#line 40 "../../../src/plugins/selection-plugin.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _synapse_selection_plugin_cb_owner_change_gtk_clipboard_owner_change, self);
#line 284 "selection-plugin.c"
}

static void
synapse_selection_plugin_cb_owner_change (SynapseSelectionPlugin* self)
{
#line 45 "../../../src/plugins/selection-plugin.vala"
	g_return_if_fail (self != NULL);
#line 47 "../../../src/plugins/selection-plugin.vala"
	self->priv->cb_changed = TRUE;
#line 294 "selection-plugin.c"
}

static void
_synapse_selection_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 53 "../../../src/plugins/selection-plugin.vala"
	synapse_selection_plugin_register_plugin ();
#line 302 "selection-plugin.c"
}

static void
synapse_selection_plugin_register_plugin (void)
{
	SynapsePluginRegistry* _tmp0_;
	SynapsePluginRegistry* _tmp1_;
#line 53 "../../../src/plugins/selection-plugin.vala"
	_tmp0_ = synapse_plugin_registry_get_default ();
#line 53 "../../../src/plugins/selection-plugin.vala"
	_tmp1_ = _tmp0_;
#line 53 "../../../src/plugins/selection-plugin.vala"
	synapse_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_SELECTION_PLUGIN, _ ("Selection"), _ ("Provides actions for currently selected text."), "edit-select-all", _synapse_selection_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
#line 53 "../../../src/plugins/selection-plugin.vala"
	_g_object_unref0 (_tmp1_);
#line 318 "selection-plugin.c"
}

static gboolean
synapse_selection_plugin_real_handles_query (SynapseItemProvider* base,
                                             SynapseQuery* query)
{
	SynapseSelectionPlugin * self;
	SynapseQuery _tmp0_;
	SynapseQueryFlags _tmp1_;
	gboolean result = FALSE;
#line 99 "../../../src/plugins/selection-plugin.vala"
	self = (SynapseSelectionPlugin*) base;
#line 99 "../../../src/plugins/selection-plugin.vala"
	g_return_val_if_fail (query != NULL, FALSE);
#line 102 "../../../src/plugins/selection-plugin.vala"
	_tmp0_ = *query;
#line 102 "../../../src/plugins/selection-plugin.vala"
	_tmp1_ = _tmp0_.query_type;
#line 102 "../../../src/plugins/selection-plugin.vala"
	result = (_tmp1_ & SYNAPSE_QUERY_FLAGS_ACTIONS) == SYNAPSE_QUERY_FLAGS_ACTIONS;
#line 102 "../../../src/plugins/selection-plugin.vala"
	return result;
#line 341 "selection-plugin.c"
}

static void
synapse_selection_plugin_real_search_data_free (gpointer _data)
{
	SynapseSelectionPluginSearchData* _data_;
	_data_ = _data;
#line 24 "../../../src/plugins/selection-plugin.vala"
	synapse_query_destroy (&_data_->query);
#line 24 "../../../src/plugins/selection-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 24 "../../../src/plugins/selection-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 24 "../../../src/plugins/selection-plugin.vala"
	g_slice_free (SynapseSelectionPluginSearchData, _data_);
#line 357 "selection-plugin.c"
}

static void
synapse_selection_plugin_real_search (SynapseItemProvider* base,
                                      SynapseQuery* query,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	SynapseSelectionPlugin * self;
	SynapseSelectionPluginSearchData* _data_;
	SynapseSelectionPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
#line 24 "../../../src/plugins/selection-plugin.vala"
	self = (SynapseSelectionPlugin*) base;
#line 24 "../../../src/plugins/selection-plugin.vala"
	_data_ = g_slice_new0 (SynapseSelectionPluginSearchData);
#line 24 "../../../src/plugins/selection-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "../../../src/plugins/selection-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_selection_plugin_real_search_data_free);
#line 24 "../../../src/plugins/selection-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "../../../src/plugins/selection-plugin.vala"
	_data_->self = _tmp0_;
#line 24 "../../../src/plugins/selection-plugin.vala"
	_tmp1_ = *query;
#line 24 "../../../src/plugins/selection-plugin.vala"
	_tmp2_ = _tmp1_;
#line 24 "../../../src/plugins/selection-plugin.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 24 "../../../src/plugins/selection-plugin.vala"
	synapse_query_destroy (&_data_->query);
#line 24 "../../../src/plugins/selection-plugin.vala"
	_data_->query = _tmp3_;
#line 24 "../../../src/plugins/selection-plugin.vala"
	synapse_selection_plugin_real_search_co (_data_);
#line 396 "selection-plugin.c"
}

static SynapseResultSet*
synapse_selection_plugin_search_finish (SynapseItemProvider* base,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	SynapseResultSet* result;
	SynapseSelectionPluginSearchData* _data_;
#line 24 "../../../src/plugins/selection-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 24 "../../../src/plugins/selection-plugin.vala"
	if (NULL == _data_) {
#line 24 "../../../src/plugins/selection-plugin.vala"
		return NULL;
#line 412 "selection-plugin.c"
	}
#line 24 "../../../src/plugins/selection-plugin.vala"
	result = _data_->result;
#line 24 "../../../src/plugins/selection-plugin.vala"
	_data_->result = NULL;
#line 24 "../../../src/plugins/selection-plugin.vala"
	return result;
#line 420 "selection-plugin.c"
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
#line 105 "../../../src/plugins/selection-plugin.vala"
	g_atomic_int_inc (&_data8_->_ref_count_);
#line 105 "../../../src/plugins/selection-plugin.vala"
	return _data8_;
#line 430 "selection-plugin.c"
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
#line 105 "../../../src/plugins/selection-plugin.vala"
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
#line 440 "selection-plugin.c"
		SynapseSelectionPlugin* self;
#line 105 "../../../src/plugins/selection-plugin.vala"
		self = _data8_->self;
#line 105 "../../../src/plugins/selection-plugin.vala"
		_g_free0 (_data8_->cb_text);
#line 105 "../../../src/plugins/selection-plugin.vala"
		_g_object_unref0 (self);
#line 105 "../../../src/plugins/selection-plugin.vala"
		g_slice_free (Block8Data, _data8_);
#line 450 "selection-plugin.c"
	}
}

static void
___lambda30_ (Block8Data* _data8_,
              GtkClipboard* cb,
              const gchar* text)
{
	SynapseSelectionPlugin* self;
	gchar* _tmp0_;
#line 125 "../../../src/plugins/selection-plugin.vala"
	self = _data8_->self;
#line 125 "../../../src/plugins/selection-plugin.vala"
	g_return_if_fail (cb != NULL);
#line 126 "../../../src/plugins/selection-plugin.vala"
	_tmp0_ = g_strdup (text);
#line 126 "../../../src/plugins/selection-plugin.vala"
	_g_free0 (_data8_->cb_text);
#line 126 "../../../src/plugins/selection-plugin.vala"
	_data8_->cb_text = _tmp0_;
#line 127 "../../../src/plugins/selection-plugin.vala"
	synapse_selection_plugin_real_search_co (_data8_->_async_data_);
#line 473 "selection-plugin.c"
}

static void
____lambda30__gtk_clipboard_text_received_func (GtkClipboard* clipboard,
                                                const gchar* text,
                                                gpointer self)
{
#line 125 "../../../src/plugins/selection-plugin.vala"
	___lambda30_ (self, clipboard, text);
#line 125 "../../../src/plugins/selection-plugin.vala"
	block8_data_unref (self);
#line 485 "selection-plugin.c"
}

static gboolean
_synapse_selection_plugin_real_search_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_selection_plugin_real_search_co (self);
#line 133 "../../../src/plugins/selection-plugin.vala"
	return result;
#line 495 "selection-plugin.c"
}

static gboolean
synapse_selection_plugin_real_search_co (SynapseSelectionPluginSearchData* _data_)
{
#line 105 "../../../src/plugins/selection-plugin.vala"
	switch (_data_->_state_) {
#line 105 "../../../src/plugins/selection-plugin.vala"
		case 0:
#line 505 "selection-plugin.c"
		goto _state_0;
#line 105 "../../../src/plugins/selection-plugin.vala"
		case 1:
#line 509 "selection-plugin.c"
		goto _state_1;
		default:
#line 105 "../../../src/plugins/selection-plugin.vala"
		g_assert_not_reached ();
#line 514 "selection-plugin.c"
	}
	_state_0:
#line 105 "../../../src/plugins/selection-plugin.vala"
	_data_->_data8_ = g_slice_new0 (Block8Data);
#line 105 "../../../src/plugins/selection-plugin.vala"
	_data_->_data8_->_ref_count_ = 1;
#line 105 "../../../src/plugins/selection-plugin.vala"
	_data_->_data8_->self = g_object_ref (_data_->self);
#line 105 "../../../src/plugins/selection-plugin.vala"
	_data_->_data8_->_async_data_ = _data_;
#line 107 "../../../src/plugins/selection-plugin.vala"
	_data_->_tmp0_ = _data_->query;
#line 107 "../../../src/plugins/selection-plugin.vala"
	_data_->_tmp1_ = _data_->_tmp0_.query_string;
#line 107 "../../../src/plugins/selection-plugin.vala"
	_data_->_tmp2_ = synapse_query_get_matchers_for_query (_data_->_tmp1_, SYNAPSE_MATCHER_FLAGS_NO_FUZZY | SYNAPSE_MATCHER_FLAGS_NO_PARTIAL, G_REGEX_CASELESS);
#line 107 "../../../src/plugins/selection-plugin.vala"
	_data_->matchers = _data_->_tmp2_;
#line 110 "../../../src/plugins/selection-plugin.vala"
	_data_->relevancy = 0;
#line 535 "selection-plugin.c"
	{
#line 111 "../../../src/plugins/selection-plugin.vala"
		_data_->_tmp3_ = _data_->matchers;
#line 111 "../../../src/plugins/selection-plugin.vala"
		_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
#line 111 "../../../src/plugins/selection-plugin.vala"
		_data_->_matcher_list = _data_->_tmp4_;
#line 111 "../../../src/plugins/selection-plugin.vala"
		_data_->_tmp5_ = _data_->_matcher_list;
#line 111 "../../../src/plugins/selection-plugin.vala"
		_data_->_tmp6_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp5_);
#line 111 "../../../src/plugins/selection-plugin.vala"
		_data_->_tmp7_ = _data_->_tmp6_;
#line 111 "../../../src/plugins/selection-plugin.vala"
		_data_->_matcher_size = _data_->_tmp7_;
#line 111 "../../../src/plugins/selection-plugin.vala"
		_data_->_matcher_index = -1;
#line 111 "../../../src/plugins/selection-plugin.vala"
		while (TRUE) {
#line 111 "../../../src/plugins/selection-plugin.vala"
			_data_->_matcher_index = _data_->_matcher_index + 1;
#line 111 "../../../src/plugins/selection-plugin.vala"
			_data_->_tmp8_ = _data_->_matcher_index;
#line 111 "../../../src/plugins/selection-plugin.vala"
			_data_->_tmp9_ = _data_->_matcher_size;
#line 111 "../../../src/plugins/selection-plugin.vala"
			if (!(_data_->_tmp8_ < _data_->_tmp9_)) {
#line 111 "../../../src/plugins/selection-plugin.vala"
				break;
#line 565 "selection-plugin.c"
			}
#line 111 "../../../src/plugins/selection-plugin.vala"
			_data_->_tmp10_ = _data_->_matcher_list;
#line 111 "../../../src/plugins/selection-plugin.vala"
			_data_->_tmp11_ = gee_list_get (_data_->_tmp10_, _data_->_matcher_index);
#line 111 "../../../src/plugins/selection-plugin.vala"
			_data_->matcher = (GeeMapEntry*) _data_->_tmp11_;
#line 113 "../../../src/plugins/selection-plugin.vala"
			_data_->_tmp12_ = _data_->matcher;
#line 113 "../../../src/plugins/selection-plugin.vala"
			_data_->_tmp13_ = gee_map_entry_get_key (_data_->_tmp12_);
#line 113 "../../../src/plugins/selection-plugin.vala"
			_data_->_tmp14_ = _data_->_tmp13_;
#line 113 "../../../src/plugins/selection-plugin.vala"
			_data_->_tmp15_ = _data_->self->priv->item;
#line 113 "../../../src/plugins/selection-plugin.vala"
			_data_->_tmp16_ = synapse_match_get_title ((SynapseMatch*) _data_->_tmp15_);
#line 113 "../../../src/plugins/selection-plugin.vala"
			_data_->_tmp17_ = _data_->_tmp16_;
#line 113 "../../../src/plugins/selection-plugin.vala"
			if (g_regex_match ((GRegex*) _data_->_tmp14_, _data_->_tmp17_, 0, NULL)) {
#line 115 "../../../src/plugins/selection-plugin.vala"
				_data_->_tmp18_ = _data_->matcher;
#line 115 "../../../src/plugins/selection-plugin.vala"
				_data_->_tmp19_ = gee_map_entry_get_value (_data_->_tmp18_);
#line 115 "../../../src/plugins/selection-plugin.vala"
				_data_->_tmp20_ = _data_->_tmp19_;
#line 115 "../../../src/plugins/selection-plugin.vala"
				_data_->relevancy = (gint) ((gintptr) _data_->_tmp20_);
#line 116 "../../../src/plugins/selection-plugin.vala"
				_g_object_unref0 (_data_->matcher);
#line 116 "../../../src/plugins/selection-plugin.vala"
				break;
#line 599 "selection-plugin.c"
			}
#line 111 "../../../src/plugins/selection-plugin.vala"
			_g_object_unref0 (_data_->matcher);
#line 603 "selection-plugin.c"
		}
#line 111 "../../../src/plugins/selection-plugin.vala"
		_g_object_unref0 (_data_->_matcher_list);
#line 607 "selection-plugin.c"
	}
#line 120 "../../../src/plugins/selection-plugin.vala"
	if (_data_->relevancy == 0) {
#line 120 "../../../src/plugins/selection-plugin.vala"
		_data_->result = NULL;
#line 120 "../../../src/plugins/selection-plugin.vala"
		_g_object_unref0 (_data_->matchers);
#line 120 "../../../src/plugins/selection-plugin.vala"
		block8_data_unref (_data_->_data8_);
#line 120 "../../../src/plugins/selection-plugin.vala"
		_data_->_data8_ = NULL;
#line 120 "../../../src/plugins/selection-plugin.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 120 "../../../src/plugins/selection-plugin.vala"
		if (_data_->_state_ != 0) {
#line 120 "../../../src/plugins/selection-plugin.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 120 "../../../src/plugins/selection-plugin.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 627 "selection-plugin.c"
			}
		}
#line 120 "../../../src/plugins/selection-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 120 "../../../src/plugins/selection-plugin.vala"
		return FALSE;
#line 634 "selection-plugin.c"
	}
#line 121 "../../../src/plugins/selection-plugin.vala"
	_data_->_data8_->cb_text = NULL;
#line 123 "../../../src/plugins/selection-plugin.vala"
	if (_data_->self->priv->cb_changed) {
#line 125 "../../../src/plugins/selection-plugin.vala"
		_data_->_tmp21_ = _data_->self->priv->clipboard;
#line 125 "../../../src/plugins/selection-plugin.vala"
		gtk_clipboard_request_text (_data_->_tmp21_, ____lambda30__gtk_clipboard_text_received_func, block8_data_ref (_data_->_data8_));
#line 644 "selection-plugin.c"
	} else {
#line 132 "../../../src/plugins/selection-plugin.vala"
		_data_->_tmp22_ = g_strdup ("");
#line 132 "../../../src/plugins/selection-plugin.vala"
		_g_free0 (_data_->_data8_->cb_text);
#line 132 "../../../src/plugins/selection-plugin.vala"
		_data_->_data8_->cb_text = _data_->_tmp22_;
#line 133 "../../../src/plugins/selection-plugin.vala"
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _synapse_selection_plugin_real_search_co_gsource_func, _data_, NULL);
#line 654 "selection-plugin.c"
	}
#line 135 "../../../src/plugins/selection-plugin.vala"
	_data_->_state_ = 1;
#line 135 "../../../src/plugins/selection-plugin.vala"
	return FALSE;
#line 660 "selection-plugin.c"
	_state_1:
	;
#line 137 "../../../src/plugins/selection-plugin.vala"
	synapse_query_check_cancellable (&_data_->query, &_data_->_inner_error0_);
#line 137 "../../../src/plugins/selection-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 137 "../../../src/plugins/selection-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 137 "../../../src/plugins/selection-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 137 "../../../src/plugins/selection-plugin.vala"
			_g_object_unref0 (_data_->matchers);
#line 137 "../../../src/plugins/selection-plugin.vala"
			block8_data_unref (_data_->_data8_);
#line 137 "../../../src/plugins/selection-plugin.vala"
			_data_->_data8_ = NULL;
#line 137 "../../../src/plugins/selection-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 137 "../../../src/plugins/selection-plugin.vala"
			return FALSE;
#line 681 "selection-plugin.c"
		} else {
#line 137 "../../../src/plugins/selection-plugin.vala"
			_g_object_unref0 (_data_->matchers);
#line 137 "../../../src/plugins/selection-plugin.vala"
			block8_data_unref (_data_->_data8_);
#line 137 "../../../src/plugins/selection-plugin.vala"
			_data_->_data8_ = NULL;
#line 137 "../../../src/plugins/selection-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 137 "../../../src/plugins/selection-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 137 "../../../src/plugins/selection-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 137 "../../../src/plugins/selection-plugin.vala"
			return FALSE;
#line 697 "selection-plugin.c"
		}
	}
#line 139 "../../../src/plugins/selection-plugin.vala"
	_data_->_tmp23_ = _data_->_data8_->cb_text;
#line 139 "../../../src/plugins/selection-plugin.vala"
	if (_data_->_tmp23_ != NULL) {
#line 141 "../../../src/plugins/selection-plugin.vala"
		if (_data_->self->priv->cb_changed) {
#line 143 "../../../src/plugins/selection-plugin.vala"
			_data_->_tmp24_ = _data_->self->priv->item;
#line 143 "../../../src/plugins/selection-plugin.vala"
			_data_->_tmp25_ = _data_->_data8_->cb_text;
#line 143 "../../../src/plugins/selection-plugin.vala"
			_data_->_data8_->cb_text = NULL;
#line 143 "../../../src/plugins/selection-plugin.vala"
			synapse_selection_plugin_selected_text_item_update_content (_data_->_tmp24_, _data_->_tmp25_);
#line 144 "../../../src/plugins/selection-plugin.vala"
			_data_->self->priv->cb_changed = FALSE;
#line 716 "selection-plugin.c"
		}
#line 146 "../../../src/plugins/selection-plugin.vala"
		_data_->_tmp26_ = synapse_result_set_new ();
#line 146 "../../../src/plugins/selection-plugin.vala"
		_data_->results = _data_->_tmp26_;
#line 147 "../../../src/plugins/selection-plugin.vala"
		_data_->_tmp27_ = _data_->results;
#line 147 "../../../src/plugins/selection-plugin.vala"
		_data_->_tmp28_ = _data_->self->priv->item;
#line 147 "../../../src/plugins/selection-plugin.vala"
		synapse_result_set_add (_data_->_tmp27_, (SynapseMatch*) _data_->_tmp28_, _data_->relevancy);
#line 149 "../../../src/plugins/selection-plugin.vala"
		synapse_query_check_cancellable (&_data_->query, &_data_->_inner_error0_);
#line 149 "../../../src/plugins/selection-plugin.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 149 "../../../src/plugins/selection-plugin.vala"
			if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 149 "../../../src/plugins/selection-plugin.vala"
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 149 "../../../src/plugins/selection-plugin.vala"
				_g_object_unref0 (_data_->results);
#line 149 "../../../src/plugins/selection-plugin.vala"
				_g_object_unref0 (_data_->matchers);
#line 149 "../../../src/plugins/selection-plugin.vala"
				block8_data_unref (_data_->_data8_);
#line 149 "../../../src/plugins/selection-plugin.vala"
				_data_->_data8_ = NULL;
#line 149 "../../../src/plugins/selection-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 149 "../../../src/plugins/selection-plugin.vala"
				return FALSE;
#line 748 "selection-plugin.c"
			} else {
#line 149 "../../../src/plugins/selection-plugin.vala"
				_g_object_unref0 (_data_->results);
#line 149 "../../../src/plugins/selection-plugin.vala"
				_g_object_unref0 (_data_->matchers);
#line 149 "../../../src/plugins/selection-plugin.vala"
				block8_data_unref (_data_->_data8_);
#line 149 "../../../src/plugins/selection-plugin.vala"
				_data_->_data8_ = NULL;
#line 149 "../../../src/plugins/selection-plugin.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 149 "../../../src/plugins/selection-plugin.vala"
				g_clear_error (&_data_->_inner_error0_);
#line 149 "../../../src/plugins/selection-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 149 "../../../src/plugins/selection-plugin.vala"
				return FALSE;
#line 766 "selection-plugin.c"
			}
		}
#line 150 "../../../src/plugins/selection-plugin.vala"
		_data_->result = _data_->results;
#line 150 "../../../src/plugins/selection-plugin.vala"
		_g_object_unref0 (_data_->matchers);
#line 150 "../../../src/plugins/selection-plugin.vala"
		block8_data_unref (_data_->_data8_);
#line 150 "../../../src/plugins/selection-plugin.vala"
		_data_->_data8_ = NULL;
#line 150 "../../../src/plugins/selection-plugin.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 150 "../../../src/plugins/selection-plugin.vala"
		if (_data_->_state_ != 0) {
#line 150 "../../../src/plugins/selection-plugin.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 150 "../../../src/plugins/selection-plugin.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 785 "selection-plugin.c"
			}
		}
#line 150 "../../../src/plugins/selection-plugin.vala"
		g_object_unref (_data_->_async_result);
#line 150 "../../../src/plugins/selection-plugin.vala"
		return FALSE;
#line 792 "selection-plugin.c"
	}
#line 154 "../../../src/plugins/selection-plugin.vala"
	synapse_query_check_cancellable (&_data_->query, &_data_->_inner_error0_);
#line 154 "../../../src/plugins/selection-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 154 "../../../src/plugins/selection-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 154 "../../../src/plugins/selection-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 154 "../../../src/plugins/selection-plugin.vala"
			_g_object_unref0 (_data_->matchers);
#line 154 "../../../src/plugins/selection-plugin.vala"
			block8_data_unref (_data_->_data8_);
#line 154 "../../../src/plugins/selection-plugin.vala"
			_data_->_data8_ = NULL;
#line 154 "../../../src/plugins/selection-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 154 "../../../src/plugins/selection-plugin.vala"
			return FALSE;
#line 812 "selection-plugin.c"
		} else {
#line 154 "../../../src/plugins/selection-plugin.vala"
			_g_object_unref0 (_data_->matchers);
#line 154 "../../../src/plugins/selection-plugin.vala"
			block8_data_unref (_data_->_data8_);
#line 154 "../../../src/plugins/selection-plugin.vala"
			_data_->_data8_ = NULL;
#line 154 "../../../src/plugins/selection-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 154 "../../../src/plugins/selection-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 154 "../../../src/plugins/selection-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 154 "../../../src/plugins/selection-plugin.vala"
			return FALSE;
#line 828 "selection-plugin.c"
		}
	}
#line 155 "../../../src/plugins/selection-plugin.vala"
	_data_->result = NULL;
#line 155 "../../../src/plugins/selection-plugin.vala"
	_g_object_unref0 (_data_->matchers);
#line 155 "../../../src/plugins/selection-plugin.vala"
	block8_data_unref (_data_->_data8_);
#line 155 "../../../src/plugins/selection-plugin.vala"
	_data_->_data8_ = NULL;
#line 155 "../../../src/plugins/selection-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 155 "../../../src/plugins/selection-plugin.vala"
	if (_data_->_state_ != 0) {
#line 155 "../../../src/plugins/selection-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 155 "../../../src/plugins/selection-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 847 "selection-plugin.c"
		}
	}
#line 155 "../../../src/plugins/selection-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 155 "../../../src/plugins/selection-plugin.vala"
	return FALSE;
#line 854 "selection-plugin.c"
}

SynapseSelectionPlugin*
synapse_selection_plugin_construct (GType object_type)
{
	SynapseSelectionPlugin * self = NULL;
#line 24 "../../../src/plugins/selection-plugin.vala"
	self = (SynapseSelectionPlugin*) g_object_new (object_type, NULL);
#line 24 "../../../src/plugins/selection-plugin.vala"
	return self;
#line 865 "selection-plugin.c"
}

SynapseSelectionPlugin*
synapse_selection_plugin_new (void)
{
#line 24 "../../../src/plugins/selection-plugin.vala"
	return synapse_selection_plugin_construct (SYNAPSE_TYPE_SELECTION_PLUGIN);
#line 873 "selection-plugin.c"
}

static gboolean
synapse_selection_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseSelectionPlugin* self;
#line 26 "../../../src/plugins/selection-plugin.vala"
	self = (SynapseSelectionPlugin*) base;
#line 26 "../../../src/plugins/selection-plugin.vala"
	result = self->priv->_enabled;
#line 26 "../../../src/plugins/selection-plugin.vala"
	return result;
#line 887 "selection-plugin.c"
}

static void
synapse_selection_plugin_real_set_enabled (SynapseActivatable* base,
                                           gboolean value)
{
	SynapseSelectionPlugin* self;
	gboolean old_value;
#line 26 "../../../src/plugins/selection-plugin.vala"
	self = (SynapseSelectionPlugin*) base;
#line 26 "../../../src/plugins/selection-plugin.vala"
	old_value = synapse_selection_plugin_real_get_enabled (base);
#line 26 "../../../src/plugins/selection-plugin.vala"
	if (old_value != value) {
#line 26 "../../../src/plugins/selection-plugin.vala"
		self->priv->_enabled = value;
#line 26 "../../../src/plugins/selection-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_selection_plugin_properties[SYNAPSE_SELECTION_PLUGIN_ENABLED_PROPERTY]);
#line 906 "selection-plugin.c"
	}
}

static inline gpointer
synapse_selection_plugin_selected_text_item_get_instance_private (SynapseSelectionPluginSelectedTextItem* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseSelectionPluginSelectedTextItem_private_offset);
}

static SynapseSelectionPluginSelectedTextItem*
synapse_selection_plugin_selected_text_item_construct (GType object_type)
{
	SynapseSelectionPluginSelectedTextItem * self = NULL;
#line 72 "../../../src/plugins/selection-plugin.vala"
	self = (SynapseSelectionPluginSelectedTextItem*) g_object_new (object_type, "title", _ ("Selected text"), "description", "", "icon-name", "edit-select-all", "has-thumbnail", FALSE, "text-origin", SYNAPSE_TEXT_ORIGIN_CLIPBOARD, NULL);
#line 70 "../../../src/plugins/selection-plugin.vala"
	return self;
#line 924 "selection-plugin.c"
}

static SynapseSelectionPluginSelectedTextItem*
synapse_selection_plugin_selected_text_item_new (void)
{
#line 70 "../../../src/plugins/selection-plugin.vala"
	return synapse_selection_plugin_selected_text_item_construct (SYNAPSE_SELECTION_PLUGIN_TYPE_SELECTED_TEXT_ITEM);
#line 932 "selection-plugin.c"
}

static gchar*
synapse_selection_plugin_selected_text_item_real_get_text (SynapseTextMatch* base)
{
	SynapseSelectionPluginSelectedTextItem * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result = NULL;
#line 79 "../../../src/plugins/selection-plugin.vala"
	self = (SynapseSelectionPluginSelectedTextItem*) base;
#line 81 "../../../src/plugins/selection-plugin.vala"
	_tmp0_ = self->priv->content;
#line 81 "../../../src/plugins/selection-plugin.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 81 "../../../src/plugins/selection-plugin.vala"
	result = _tmp1_;
#line 81 "../../../src/plugins/selection-plugin.vala"
	return result;
#line 952 "selection-plugin.c"
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
#line 1351 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1352 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1352 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1353 "glib-2.0.vapi"
	g_strchug (_result_);
#line 1354 "glib-2.0.vapi"
	result = _result_;
#line 1354 "glib-2.0.vapi"
	return result;
#line 973 "selection-plugin.c"
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
#line 1447 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1447 "glib-2.0.vapi"
	end = _tmp0_;
#line 1448 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1448 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1449 "glib-2.0.vapi"
		result = maxlen;
#line 1449 "glib-2.0.vapi"
		return result;
#line 996 "selection-plugin.c"
	} else {
		gchar* _tmp2_;
#line 1451 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1451 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1451 "glib-2.0.vapi"
		return result;
#line 1005 "selection-plugin.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
#line 1458 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1460 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 1024 "selection-plugin.c"
	} else {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1028 "selection-plugin.c"
	}
#line 1460 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1462 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 1034 "selection-plugin.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1464 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1464 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1464 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 1044 "selection-plugin.c"
	}
#line 1467 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1468 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1469 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 1052 "selection-plugin.c"
	} else {
#line 1471 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 1056 "selection-plugin.c"
	}
#line 1473 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1474 "glib-2.0.vapi"
		len = string_length - offset;
#line 1062 "selection-plugin.c"
	}
#line 1476 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1477 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1477 "glib-2.0.vapi"
	result = _tmp3_;
#line 1477 "glib-2.0.vapi"
	return result;
#line 1072 "selection-plugin.c"
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result = 0;
#line 1282 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1283 "glib-2.0.vapi"
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
#line 1283 "glib-2.0.vapi"
	result = (gint) (_tmp0_ - ((gchar*) self));
#line 1283 "glib-2.0.vapi"
	return result;
#line 1089 "selection-plugin.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1535 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 1111 "selection-plugin.c"
	} else {
#line 1535 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 1115 "selection-plugin.c"
	}
#line 1535 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1535 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 1121 "selection-plugin.c"
	} else {
#line 1535 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 1125 "selection-plugin.c"
	}
#line 1535 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1129 "selection-plugin.c"
		gchar* _tmp2_;
#line 1536 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1536 "glib-2.0.vapi"
		result = _tmp2_;
#line 1536 "glib-2.0.vapi"
		return result;
#line 1137 "selection-plugin.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1539 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1539 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1539 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1539 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1539 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1539 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1539 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1539 "glib-2.0.vapi"
			_g_free0 (_tmp7_);
#line 1539 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1539 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1169 "selection-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 1539 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1539 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1539 "glib-2.0.vapi"
			return NULL;
#line 1178 "selection-plugin.c"
		}
#line 1540 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1540 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1540 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1540 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1540 "glib-2.0.vapi"
			_g_free0 (_tmp7_);
#line 1540 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1540 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1194 "selection-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 1540 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1540 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1540 "glib-2.0.vapi"
			return NULL;
#line 1203 "selection-plugin.c"
		}
#line 1540 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1540 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1540 "glib-2.0.vapi"
		result = _tmp10_;
#line 1540 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1540 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1540 "glib-2.0.vapi"
		return result;
#line 1217 "selection-plugin.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1538 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1542 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 1226 "selection-plugin.c"
	}
	__finally0:
#line 1538 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1538 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1538 "glib-2.0.vapi"
	return NULL;
#line 1235 "selection-plugin.c"
}

static void
synapse_selection_plugin_selected_text_item_update_content (SynapseSelectionPluginSelectedTextItem* self,
                                                            gchar* content)
{
	gchar* _tmp0_;
	gchar* chugged = NULL;
	gchar* _tmp1_;
	gchar* shortened = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
#line 86 "../../../src/plugins/selection-plugin.vala"
	g_return_if_fail (self != NULL);
#line 86 "../../../src/plugins/selection-plugin.vala"
	g_return_if_fail (content != NULL);
#line 88 "../../../src/plugins/selection-plugin.vala"
	_tmp0_ = g_strdup (content);
#line 88 "../../../src/plugins/selection-plugin.vala"
	_g_free0 (self->priv->content);
#line 88 "../../../src/plugins/selection-plugin.vala"
	self->priv->content = _tmp0_;
#line 89 "../../../src/plugins/selection-plugin.vala"
	_tmp1_ = string_chug (content);
#line 89 "../../../src/plugins/selection-plugin.vala"
	chugged = _tmp1_;
#line 91 "../../../src/plugins/selection-plugin.vala"
	_tmp2_ = chugged;
#line 91 "../../../src/plugins/selection-plugin.vala"
	if (g_utf8_strlen (_tmp2_, (gssize) -1) > 100) {
#line 1268 "selection-plugin.c"
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 92 "../../../src/plugins/selection-plugin.vala"
		_tmp3_ = chugged;
#line 92 "../../../src/plugins/selection-plugin.vala"
		_tmp4_ = chugged;
#line 92 "../../../src/plugins/selection-plugin.vala"
		_tmp5_ = string_substring (_tmp3_, (glong) 0, (glong) string_index_of_nth_char (_tmp4_, (glong) 100));
#line 92 "../../../src/plugins/selection-plugin.vala"
		_g_free0 (shortened);
#line 92 "../../../src/plugins/selection-plugin.vala"
		shortened = _tmp5_;
#line 1282 "selection-plugin.c"
	} else {
		const gchar* _tmp6_;
		gchar* _tmp7_;
#line 94 "../../../src/plugins/selection-plugin.vala"
		_tmp6_ = chugged;
#line 94 "../../../src/plugins/selection-plugin.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 94 "../../../src/plugins/selection-plugin.vala"
		_g_free0 (shortened);
#line 94 "../../../src/plugins/selection-plugin.vala"
		shortened = _tmp7_;
#line 1294 "selection-plugin.c"
	}
#line 95 "../../../src/plugins/selection-plugin.vala"
	_tmp8_ = shortened;
#line 95 "../../../src/plugins/selection-plugin.vala"
	_tmp9_ = string_replace (_tmp8_, "\n", " ");
#line 95 "../../../src/plugins/selection-plugin.vala"
	_tmp10_ = _tmp9_;
#line 95 "../../../src/plugins/selection-plugin.vala"
	synapse_match_set_description ((SynapseMatch*) self, _tmp10_);
#line 95 "../../../src/plugins/selection-plugin.vala"
	_g_free0 (_tmp10_);
#line 86 "../../../src/plugins/selection-plugin.vala"
	_g_free0 (shortened);
#line 86 "../../../src/plugins/selection-plugin.vala"
	_g_free0 (chugged);
#line 86 "../../../src/plugins/selection-plugin.vala"
	_g_free0 (content);
#line 1312 "selection-plugin.c"
}

static void
synapse_selection_plugin_selected_text_item_class_init (SynapseSelectionPluginSelectedTextItemClass * klass,
                                                        gpointer klass_data)
{
#line 68 "../../../src/plugins/selection-plugin.vala"
	synapse_selection_plugin_selected_text_item_parent_class = g_type_class_peek_parent (klass);
#line 68 "../../../src/plugins/selection-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseSelectionPluginSelectedTextItem_private_offset);
#line 68 "../../../src/plugins/selection-plugin.vala"
	((SynapseTextMatchClass *) klass)->get_text = (gchar* (*) (SynapseTextMatch*)) synapse_selection_plugin_selected_text_item_real_get_text;
#line 68 "../../../src/plugins/selection-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_selection_plugin_selected_text_item_finalize;
#line 1327 "selection-plugin.c"
}

static void
synapse_selection_plugin_selected_text_item_instance_init (SynapseSelectionPluginSelectedTextItem * self,
                                                           gpointer klass)
{
#line 68 "../../../src/plugins/selection-plugin.vala"
	self->priv = synapse_selection_plugin_selected_text_item_get_instance_private (self);
#line 84 "../../../src/plugins/selection-plugin.vala"
	self->priv->content = NULL;
#line 1338 "selection-plugin.c"
}

static void
synapse_selection_plugin_selected_text_item_finalize (GObject * obj)
{
	SynapseSelectionPluginSelectedTextItem * self;
#line 68 "../../../src/plugins/selection-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_SELECTION_PLUGIN_TYPE_SELECTED_TEXT_ITEM, SynapseSelectionPluginSelectedTextItem);
#line 84 "../../../src/plugins/selection-plugin.vala"
	_g_free0 (self->priv->content);
#line 68 "../../../src/plugins/selection-plugin.vala"
	G_OBJECT_CLASS (synapse_selection_plugin_selected_text_item_parent_class)->finalize (obj);
#line 1351 "selection-plugin.c"
}

static GType
synapse_selection_plugin_selected_text_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseSelectionPluginSelectedTextItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_selection_plugin_selected_text_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseSelectionPluginSelectedTextItem), 0, (GInstanceInitFunc) synapse_selection_plugin_selected_text_item_instance_init, NULL };
	GType synapse_selection_plugin_selected_text_item_type_id;
	synapse_selection_plugin_selected_text_item_type_id = g_type_register_static (SYNAPSE_TYPE_TEXT_MATCH, "SynapseSelectionPluginSelectedTextItem", &g_define_type_info, 0);
	SynapseSelectionPluginSelectedTextItem_private_offset = g_type_add_instance_private (synapse_selection_plugin_selected_text_item_type_id, sizeof (SynapseSelectionPluginSelectedTextItemPrivate));
	return synapse_selection_plugin_selected_text_item_type_id;
}

static GType
synapse_selection_plugin_selected_text_item_get_type (void)
{
	static volatile gsize synapse_selection_plugin_selected_text_item_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_selection_plugin_selected_text_item_type_id__volatile)) {
		GType synapse_selection_plugin_selected_text_item_type_id;
		synapse_selection_plugin_selected_text_item_type_id = synapse_selection_plugin_selected_text_item_get_type_once ();
		g_once_init_leave (&synapse_selection_plugin_selected_text_item_type_id__volatile, synapse_selection_plugin_selected_text_item_type_id);
	}
	return synapse_selection_plugin_selected_text_item_type_id__volatile;
}

static void
synapse_selection_plugin_class_init (SynapseSelectionPluginClass * klass,
                                     gpointer klass_data)
{
#line 24 "../../../src/plugins/selection-plugin.vala"
	synapse_selection_plugin_parent_class = g_type_class_peek_parent (klass);
#line 24 "../../../src/plugins/selection-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseSelectionPlugin_private_offset);
#line 24 "../../../src/plugins/selection-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_selection_plugin_get_property;
#line 24 "../../../src/plugins/selection-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_selection_plugin_set_property;
#line 24 "../../../src/plugins/selection-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_selection_plugin_finalize;
#line 24 "../../../src/plugins/selection-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_SELECTION_PLUGIN_ENABLED_PROPERTY, synapse_selection_plugin_properties[SYNAPSE_SELECTION_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 65 "../../../src/plugins/selection-plugin.vala"
	synapse_selection_plugin_register_plugin ();
#line 1394 "selection-plugin.c"
}

static void
synapse_selection_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                             gpointer iface_data)
{
#line 24 "../../../src/plugins/selection-plugin.vala"
	synapse_selection_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../../../src/plugins/selection-plugin.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_selection_plugin_real_activate;
#line 24 "../../../src/plugins/selection-plugin.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_selection_plugin_real_deactivate;
#line 24 "../../../src/plugins/selection-plugin.vala"
	iface->get_enabled = synapse_selection_plugin_real_get_enabled;
#line 24 "../../../src/plugins/selection-plugin.vala"
	iface->set_enabled = synapse_selection_plugin_real_set_enabled;
#line 1411 "selection-plugin.c"
}

static void
synapse_selection_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                               gpointer iface_data)
{
#line 24 "../../../src/plugins/selection-plugin.vala"
	synapse_selection_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "../../../src/plugins/selection-plugin.vala"
	iface->handles_query = (gboolean (*) (SynapseItemProvider*, SynapseQuery*)) synapse_selection_plugin_real_handles_query;
#line 24 "../../../src/plugins/selection-plugin.vala"
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_selection_plugin_real_search;
#line 24 "../../../src/plugins/selection-plugin.vala"
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_selection_plugin_search_finish;
#line 1426 "selection-plugin.c"
}

static void
synapse_selection_plugin_instance_init (SynapseSelectionPlugin * self,
                                        gpointer klass)
{
#line 24 "../../../src/plugins/selection-plugin.vala"
	self->priv = synapse_selection_plugin_get_instance_private (self);
#line 26 "../../../src/plugins/selection-plugin.vala"
	self->priv->_enabled = TRUE;
#line 43 "../../../src/plugins/selection-plugin.vala"
	self->priv->cb_changed = TRUE;
#line 1439 "selection-plugin.c"
}

static void
synapse_selection_plugin_finalize (GObject * obj)
{
	SynapseSelectionPlugin * self;
#line 24 "../../../src/plugins/selection-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_SELECTION_PLUGIN, SynapseSelectionPlugin);
#line 28 "../../../src/plugins/selection-plugin.vala"
	_g_object_unref0 (self->priv->clipboard);
#line 29 "../../../src/plugins/selection-plugin.vala"
	_g_object_unref0 (self->priv->item);
#line 24 "../../../src/plugins/selection-plugin.vala"
	G_OBJECT_CLASS (synapse_selection_plugin_parent_class)->finalize (obj);
#line 1454 "selection-plugin.c"
}

static GType
synapse_selection_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseSelectionPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_selection_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseSelectionPlugin), 0, (GInstanceInitFunc) synapse_selection_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_selection_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_selection_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_selection_plugin_type_id;
	synapse_selection_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseSelectionPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_selection_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_selection_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseSelectionPlugin_private_offset = g_type_add_instance_private (synapse_selection_plugin_type_id, sizeof (SynapseSelectionPluginPrivate));
	return synapse_selection_plugin_type_id;
}

GType
synapse_selection_plugin_get_type (void)
{
	static volatile gsize synapse_selection_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_selection_plugin_type_id__volatile)) {
		GType synapse_selection_plugin_type_id;
		synapse_selection_plugin_type_id = synapse_selection_plugin_get_type_once ();
		g_once_init_leave (&synapse_selection_plugin_type_id__volatile, synapse_selection_plugin_type_id);
	}
	return synapse_selection_plugin_type_id__volatile;
}

static void
_vala_synapse_selection_plugin_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	SynapseSelectionPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_SELECTION_PLUGIN, SynapseSelectionPlugin);
#line 24 "../../../src/plugins/selection-plugin.vala"
	switch (property_id) {
#line 24 "../../../src/plugins/selection-plugin.vala"
		case SYNAPSE_SELECTION_PLUGIN_ENABLED_PROPERTY:
#line 24 "../../../src/plugins/selection-plugin.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 24 "../../../src/plugins/selection-plugin.vala"
		break;
#line 1499 "selection-plugin.c"
		default:
#line 24 "../../../src/plugins/selection-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../../../src/plugins/selection-plugin.vala"
		break;
#line 1505 "selection-plugin.c"
	}
}

static void
_vala_synapse_selection_plugin_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	SynapseSelectionPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_SELECTION_PLUGIN, SynapseSelectionPlugin);
#line 24 "../../../src/plugins/selection-plugin.vala"
	switch (property_id) {
#line 24 "../../../src/plugins/selection-plugin.vala"
		case SYNAPSE_SELECTION_PLUGIN_ENABLED_PROPERTY:
#line 24 "../../../src/plugins/selection-plugin.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 24 "../../../src/plugins/selection-plugin.vala"
		break;
#line 1525 "selection-plugin.c"
		default:
#line 24 "../../../src/plugins/selection-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../../../src/plugins/selection-plugin.vala"
		break;
#line 1531 "selection-plugin.c"
	}
}

