/* zeal-plugin.c generated by valac 0.48.17, the Vala compiler
 * generated from zeal-plugin.vala, do not modify */

/*
 * Copyright (C) 2015 Jérémy Munsch <jeremy.munsch@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Jérémy Munsch <jeremy.munsch@gmail.com>
 *
 */

#include <glib-object.h>
#include <synapse-core.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <json-glib/json-glib.h>

#define SYNAPSE_TYPE_ZEAL_PLUGIN (synapse_zeal_plugin_get_type ())
#define SYNAPSE_ZEAL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ZEAL_PLUGIN, SynapseZealPlugin))
#define SYNAPSE_ZEAL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_ZEAL_PLUGIN, SynapseZealPluginClass))
#define SYNAPSE_IS_ZEAL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ZEAL_PLUGIN))
#define SYNAPSE_IS_ZEAL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_ZEAL_PLUGIN))
#define SYNAPSE_ZEAL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_ZEAL_PLUGIN, SynapseZealPluginClass))

typedef struct _SynapseZealPlugin SynapseZealPlugin;
typedef struct _SynapseZealPluginClass SynapseZealPluginClass;
typedef struct _SynapseZealPluginPrivate SynapseZealPluginPrivate;

#define SYNAPSE_TYPE_ZEAL_DOC (synapse_zeal_doc_get_type ())
#define SYNAPSE_ZEAL_DOC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_ZEAL_DOC, SynapseZealDoc))
#define SYNAPSE_ZEAL_DOC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_ZEAL_DOC, SynapseZealDocClass))
#define SYNAPSE_IS_ZEAL_DOC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_ZEAL_DOC))
#define SYNAPSE_IS_ZEAL_DOC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_ZEAL_DOC))
#define SYNAPSE_ZEAL_DOC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_ZEAL_DOC, SynapseZealDocClass))

typedef struct _SynapseZealDoc SynapseZealDoc;
typedef struct _SynapseZealDocClass SynapseZealDocClass;
enum  {
	SYNAPSE_ZEAL_PLUGIN_0_PROPERTY,
	SYNAPSE_ZEAL_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_ZEAL_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_zeal_plugin_properties[SYNAPSE_ZEAL_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _SynapseZealDocPrivate SynapseZealDocPrivate;
typedef struct _SynapseZealPluginSearchData SynapseZealPluginSearchData;
enum  {
	SYNAPSE_ZEAL_DOC_0_PROPERTY,
	SYNAPSE_ZEAL_DOC_DOC_PATH_PROPERTY,
	SYNAPSE_ZEAL_DOC_NUM_PROPERTIES
};
static GParamSpec* synapse_zeal_doc_properties[SYNAPSE_ZEAL_DOC_NUM_PROPERTIES];
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))

struct _SynapseZealPlugin {
	GObject parent_instance;
	SynapseZealPluginPrivate * priv;
};

struct _SynapseZealPluginClass {
	GObjectClass parent_class;
};

struct _SynapseZealPluginPrivate {
	gboolean _enabled;
	GeeList* doclist;
};

struct _SynapseZealDoc {
	SynapseActionMatch parent_instance;
	SynapseZealDocPrivate * priv;
	gchar* scf_bundle_identifier;
	gchar* scf_bundle_name;
	GRegex* regex;
};

struct _SynapseZealDocClass {
	SynapseActionMatchClass parent_class;
};

struct _SynapseZealPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseZealPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	SynapseQuery _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	SynapseResultSet* results;
	SynapseResultSet* _tmp7_;
	GeeList* matchers;
	SynapseQuery _tmp8_;
	const gchar* _tmp9_;
	GeeList* _tmp10_;
	GeeList* _doc_list;
	GeeList* _tmp11_;
	GeeList* _tmp12_;
	gint _doc_size;
	GeeList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _doc_index;
	gint _tmp16_;
	gint _tmp17_;
	SynapseZealDoc* doc;
	GeeList* _tmp18_;
	gpointer _tmp19_;
	GeeList* _matcher_list;
	GeeList* _tmp20_;
	GeeList* _tmp21_;
	gint _matcher_size;
	GeeList* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gint _matcher_index;
	gint _tmp25_;
	gint _tmp26_;
	GeeMapEntry* matcher;
	GeeList* _tmp27_;
	gpointer _tmp28_;
	GeeMapEntry* _tmp29_;
	gconstpointer _tmp30_;
	gconstpointer _tmp31_;
	SynapseZealDoc* _tmp32_;
	const gchar* _tmp33_;
	SynapseZealDoc* _tmp34_;
	SynapseQuery _tmp35_;
	const gchar* _tmp36_;
	SynapseResultSet* _tmp37_;
	SynapseZealDoc* _tmp38_;
	GeeMapEntry* _tmp39_;
	gconstpointer _tmp40_;
	gconstpointer _tmp41_;
	SynapseZealDoc* _tmp42_;
	GRegex* _tmp43_;
	SynapseQuery _tmp44_;
	const gchar* _tmp45_;
	SynapseZealDoc* _tmp46_;
	const gchar* _tmp47_;
	gchar** _tmp48_;
	gchar** _tmp49_;
	gchar** part_collection;
	gint part_collection_length1;
	gint _part_collection_size_;
	gint part_it;
	gchar* _tmp50_;
	gchar* part;
	SynapseQuery _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	SynapseZealDoc* _tmp55_;
	SynapseQuery _tmp56_;
	const gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	SynapseResultSet* _tmp62_;
	SynapseZealDoc* _tmp63_;
	GError* _inner_error0_;
};

struct _SynapseZealDocPrivate {
	gchar* _doc_path;
	gchar* query;
	gchar* doc_name;
	gchar* version;
};

static gint SynapseZealPlugin_private_offset;
static gpointer synapse_zeal_plugin_parent_class = NULL;
static SynapseActivatableIface * synapse_zeal_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_zeal_plugin_synapse_item_provider_parent_iface = NULL;
static gint SynapseZealDoc_private_offset;
static gpointer synapse_zeal_doc_parent_class = NULL;

GType synapse_zeal_plugin_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseZealPlugin, g_object_unref)
GType synapse_zeal_doc_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseZealDoc, g_object_unref)
static void synapse_zeal_plugin_real_activate (SynapseActivatable* base);
SynapseZealDoc* synapse_zeal_doc_new (const gchar* doc_path);
SynapseZealDoc* synapse_zeal_doc_construct (GType object_type,
                                            const gchar* doc_path);
static void synapse_zeal_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_zeal_plugin_register_plugin (void);
static void _synapse_zeal_plugin_register_plugin_synapse_plugin_register_func (void);
static gboolean synapse_zeal_plugin_real_handles_query (SynapseItemProvider* base,
                                                 SynapseQuery* query);
static void synapse_zeal_plugin_real_search_data_free (gpointer _data);
static void synapse_zeal_plugin_real_search (SynapseItemProvider* base,
                                      SynapseQuery* q,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static gboolean synapse_zeal_plugin_real_search_co (SynapseZealPluginSearchData* _data_);
static gboolean _synapse_zeal_plugin_real_search_co_gsource_func (gpointer self);
void synapse_zeal_doc_update_title (SynapseZealDoc* self,
                                    const gchar* query);
gchar* synapse_zeal_doc_replace_first_occurence (const gchar* str,
                                                 const gchar* search,
                                                 const gchar* replace);
SynapseZealPlugin* synapse_zeal_plugin_new (void);
SynapseZealPlugin* synapse_zeal_plugin_construct (GType object_type);
static void synapse_zeal_plugin_finalize (GObject * obj);
static GType synapse_zeal_plugin_get_type_once (void);
static void _vala_synapse_zeal_plugin_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_synapse_zeal_plugin_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void synapse_zeal_doc_real_do_action (SynapseActionMatch* base);
static void synapse_zeal_doc_parse_doc_name (SynapseZealDoc* self);
const gchar* synapse_zeal_doc_get_doc_path (SynapseZealDoc* self);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void _vala_JsonNode_free (JsonNode* self);
static void synapse_zeal_doc_parse_doc_bundle (SynapseZealDoc* self);
static void synapse_zeal_doc_set_doc_path (SynapseZealDoc* self,
                                    const gchar* value);
static GObject * synapse_zeal_doc_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void synapse_zeal_doc_finalize (GObject * obj);
static GType synapse_zeal_doc_get_type_once (void);
static void _vala_synapse_zeal_doc_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_synapse_zeal_doc_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static GRegex* _tmp_regex_0 = NULL;

static inline gpointer
synapse_zeal_plugin_get_instance_private (SynapseZealPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseZealPlugin_private_offset);
}

static void
synapse_zeal_plugin_real_activate (SynapseActivatable* base)
{
	SynapseZealPlugin * self;
	gchar* docsets_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GeeArrayList* _tmp2_;
	GError* _inner_error0_ = NULL;
#line 51 "../../../src/plugins/zeal-plugin.vala"
	self = (SynapseZealPlugin*) base;
#line 53 "../../../src/plugins/zeal-plugin.vala"
	_tmp0_ = g_get_user_data_dir ();
#line 53 "../../../src/plugins/zeal-plugin.vala"
	_tmp1_ = g_strdup_printf ("%s/Zeal/Zeal/docsets/", _tmp0_);
#line 53 "../../../src/plugins/zeal-plugin.vala"
	docsets_path = _tmp1_;
#line 54 "../../../src/plugins/zeal-plugin.vala"
	_tmp2_ = gee_array_list_new (SYNAPSE_TYPE_ZEAL_DOC, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 54 "../../../src/plugins/zeal-plugin.vala"
	_g_object_unref0 (self->priv->doclist);
#line 54 "../../../src/plugins/zeal-plugin.vala"
	self->priv->doclist = (GeeList*) _tmp2_;
#line 306 "zeal-plugin.c"
	{
		GDir* dir = NULL;
		const gchar* _tmp3_;
		GDir* _tmp4_;
		gchar* name = NULL;
#line 58 "../../../src/plugins/zeal-plugin.vala"
		_tmp3_ = docsets_path;
#line 58 "../../../src/plugins/zeal-plugin.vala"
		_tmp4_ = g_dir_open (_tmp3_, (guint) 0, &_inner_error0_);
#line 58 "../../../src/plugins/zeal-plugin.vala"
		dir = _tmp4_;
#line 58 "../../../src/plugins/zeal-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 58 "../../../src/plugins/zeal-plugin.vala"
			if (_inner_error0_->domain == G_FILE_ERROR) {
#line 322 "zeal-plugin.c"
				goto __catch0_g_file_error;
			}
#line 58 "../../../src/plugins/zeal-plugin.vala"
			_g_free0 (docsets_path);
#line 58 "../../../src/plugins/zeal-plugin.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 58 "../../../src/plugins/zeal-plugin.vala"
			g_clear_error (&_inner_error0_);
#line 58 "../../../src/plugins/zeal-plugin.vala"
			return;
#line 333 "zeal-plugin.c"
		}
#line 59 "../../../src/plugins/zeal-plugin.vala"
		name = NULL;
#line 61 "../../../src/plugins/zeal-plugin.vala"
		while (TRUE) {
#line 339 "zeal-plugin.c"
			GDir* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* path = NULL;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* type = NULL;
			gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp16_;
			const gchar* _tmp19_;
			const gchar* _tmp22_;
			const gchar* _tmp25_;
			SynapseZealDoc* zdoc = NULL;
			const gchar* _tmp26_;
			SynapseZealDoc* _tmp27_;
			GeeList* _tmp28_;
			SynapseZealDoc* _tmp29_;
#line 61 "../../../src/plugins/zeal-plugin.vala"
			_tmp5_ = dir;
#line 61 "../../../src/plugins/zeal-plugin.vala"
			_tmp6_ = g_dir_read_name (_tmp5_);
#line 61 "../../../src/plugins/zeal-plugin.vala"
			_tmp7_ = g_strdup (_tmp6_);
#line 61 "../../../src/plugins/zeal-plugin.vala"
			_g_free0 (name);
#line 61 "../../../src/plugins/zeal-plugin.vala"
			name = _tmp7_;
#line 61 "../../../src/plugins/zeal-plugin.vala"
			_tmp8_ = name;
#line 61 "../../../src/plugins/zeal-plugin.vala"
			if (!(_tmp8_ != NULL)) {
#line 61 "../../../src/plugins/zeal-plugin.vala"
				break;
#line 376 "zeal-plugin.c"
			}
#line 63 "../../../src/plugins/zeal-plugin.vala"
			_tmp9_ = docsets_path;
#line 63 "../../../src/plugins/zeal-plugin.vala"
			_tmp10_ = name;
#line 63 "../../../src/plugins/zeal-plugin.vala"
			_tmp11_ = g_build_filename (_tmp9_, _tmp10_, NULL);
#line 63 "../../../src/plugins/zeal-plugin.vala"
			path = _tmp11_;
#line 64 "../../../src/plugins/zeal-plugin.vala"
			_tmp12_ = g_strdup ("");
#line 64 "../../../src/plugins/zeal-plugin.vala"
			type = _tmp12_;
#line 66 "../../../src/plugins/zeal-plugin.vala"
			_tmp13_ = path;
#line 66 "../../../src/plugins/zeal-plugin.vala"
			if (g_file_test (_tmp13_, G_FILE_TEST_IS_REGULAR)) {
#line 394 "zeal-plugin.c"
				const gchar* _tmp14_;
				gchar* _tmp15_;
#line 67 "../../../src/plugins/zeal-plugin.vala"
				_tmp14_ = type;
#line 67 "../../../src/plugins/zeal-plugin.vala"
				_tmp15_ = g_strconcat (_tmp14_, "| REGULAR ", NULL);
#line 67 "../../../src/plugins/zeal-plugin.vala"
				_g_free0 (type);
#line 67 "../../../src/plugins/zeal-plugin.vala"
				type = _tmp15_;
#line 405 "zeal-plugin.c"
			}
#line 68 "../../../src/plugins/zeal-plugin.vala"
			_tmp16_ = path;
#line 68 "../../../src/plugins/zeal-plugin.vala"
			if (g_file_test (_tmp16_, G_FILE_TEST_IS_SYMLINK)) {
#line 411 "zeal-plugin.c"
				const gchar* _tmp17_;
				gchar* _tmp18_;
#line 69 "../../../src/plugins/zeal-plugin.vala"
				_tmp17_ = type;
#line 69 "../../../src/plugins/zeal-plugin.vala"
				_tmp18_ = g_strconcat (_tmp17_, "| SYMLINK ", NULL);
#line 69 "../../../src/plugins/zeal-plugin.vala"
				_g_free0 (type);
#line 69 "../../../src/plugins/zeal-plugin.vala"
				type = _tmp18_;
#line 422 "zeal-plugin.c"
			}
#line 70 "../../../src/plugins/zeal-plugin.vala"
			_tmp19_ = path;
#line 70 "../../../src/plugins/zeal-plugin.vala"
			if (g_file_test (_tmp19_, G_FILE_TEST_IS_DIR)) {
#line 428 "zeal-plugin.c"
				const gchar* _tmp20_;
				gchar* _tmp21_;
#line 71 "../../../src/plugins/zeal-plugin.vala"
				_tmp20_ = type;
#line 71 "../../../src/plugins/zeal-plugin.vala"
				_tmp21_ = g_strconcat (_tmp20_, "| DIR ", NULL);
#line 71 "../../../src/plugins/zeal-plugin.vala"
				_g_free0 (type);
#line 71 "../../../src/plugins/zeal-plugin.vala"
				type = _tmp21_;
#line 439 "zeal-plugin.c"
			}
#line 72 "../../../src/plugins/zeal-plugin.vala"
			_tmp22_ = path;
#line 72 "../../../src/plugins/zeal-plugin.vala"
			if (g_file_test (_tmp22_, G_FILE_TEST_IS_EXECUTABLE)) {
#line 445 "zeal-plugin.c"
				const gchar* _tmp23_;
				gchar* _tmp24_;
#line 73 "../../../src/plugins/zeal-plugin.vala"
				_tmp23_ = type;
#line 73 "../../../src/plugins/zeal-plugin.vala"
				_tmp24_ = g_strconcat (_tmp23_, "| EXECUTABLE ", NULL);
#line 73 "../../../src/plugins/zeal-plugin.vala"
				_g_free0 (type);
#line 73 "../../../src/plugins/zeal-plugin.vala"
				type = _tmp24_;
#line 456 "zeal-plugin.c"
			}
#line 75 "../../../src/plugins/zeal-plugin.vala"
			_tmp25_ = path;
#line 75 "../../../src/plugins/zeal-plugin.vala"
			if (g_strcmp0 (_tmp25_, "") == 0) {
#line 76 "../../../src/plugins/zeal-plugin.vala"
				_g_free0 (type);
#line 76 "../../../src/plugins/zeal-plugin.vala"
				_g_free0 (path);
#line 76 "../../../src/plugins/zeal-plugin.vala"
				continue;
#line 468 "zeal-plugin.c"
			}
#line 78 "../../../src/plugins/zeal-plugin.vala"
			_tmp26_ = path;
#line 78 "../../../src/plugins/zeal-plugin.vala"
			_tmp27_ = synapse_zeal_doc_new (_tmp26_);
#line 78 "../../../src/plugins/zeal-plugin.vala"
			zdoc = _tmp27_;
#line 79 "../../../src/plugins/zeal-plugin.vala"
			_tmp28_ = self->priv->doclist;
#line 79 "../../../src/plugins/zeal-plugin.vala"
			_tmp29_ = zdoc;
#line 79 "../../../src/plugins/zeal-plugin.vala"
			gee_collection_add ((GeeCollection*) _tmp28_, _tmp29_);
#line 61 "../../../src/plugins/zeal-plugin.vala"
			_g_object_unref0 (zdoc);
#line 61 "../../../src/plugins/zeal-plugin.vala"
			_g_free0 (type);
#line 61 "../../../src/plugins/zeal-plugin.vala"
			_g_free0 (path);
#line 488 "zeal-plugin.c"
		}
#line 56 "../../../src/plugins/zeal-plugin.vala"
		_g_free0 (name);
#line 56 "../../../src/plugins/zeal-plugin.vala"
		_g_dir_close0 (dir);
#line 494 "zeal-plugin.c"
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
#line 56 "../../../src/plugins/zeal-plugin.vala"
		e = _inner_error0_;
#line 56 "../../../src/plugins/zeal-plugin.vala"
		_inner_error0_ = NULL;
#line 84 "../../../src/plugins/zeal-plugin.vala"
		_tmp30_ = e;
#line 84 "../../../src/plugins/zeal-plugin.vala"
		_tmp31_ = _tmp30_->message;
#line 84 "../../../src/plugins/zeal-plugin.vala"
		g_warning ("zeal-plugin.vala:84: %s", _tmp31_);
#line 56 "../../../src/plugins/zeal-plugin.vala"
		_g_error_free0 (e);
#line 514 "zeal-plugin.c"
	}
	__finally0:
#line 56 "../../../src/plugins/zeal-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 56 "../../../src/plugins/zeal-plugin.vala"
		_g_free0 (docsets_path);
#line 56 "../../../src/plugins/zeal-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 56 "../../../src/plugins/zeal-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 56 "../../../src/plugins/zeal-plugin.vala"
		return;
#line 527 "zeal-plugin.c"
	}
#line 51 "../../../src/plugins/zeal-plugin.vala"
	_g_free0 (docsets_path);
#line 531 "zeal-plugin.c"
}

static void
synapse_zeal_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseZealPlugin * self;
#line 88 "../../../src/plugins/zeal-plugin.vala"
	self = (SynapseZealPlugin*) base;
#line 90 "../../../src/plugins/zeal-plugin.vala"
	_g_object_unref0 (self->priv->doclist);
#line 90 "../../../src/plugins/zeal-plugin.vala"
	self->priv->doclist = NULL;
#line 544 "zeal-plugin.c"
}

static void
_synapse_zeal_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 100 "../../../src/plugins/zeal-plugin.vala"
	synapse_zeal_plugin_register_plugin ();
#line 552 "zeal-plugin.c"
}

static void
synapse_zeal_plugin_register_plugin (void)
{
	SynapsePluginRegistry* _tmp0_;
	SynapsePluginRegistry* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 100 "../../../src/plugins/zeal-plugin.vala"
	_tmp0_ = synapse_plugin_registry_get_default ();
#line 100 "../../../src/plugins/zeal-plugin.vala"
	_tmp1_ = _tmp0_;
#line 100 "../../../src/plugins/zeal-plugin.vala"
	_tmp2_ = g_find_program_in_path ("zeal");
#line 100 "../../../src/plugins/zeal-plugin.vala"
	_tmp3_ = _tmp2_;
#line 100 "../../../src/plugins/zeal-plugin.vala"
	synapse_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_ZEAL_PLUGIN, _ ("Zeal"), _ ("Zeal offline documentation (zealdocs.org)"), "zeal", _synapse_zeal_plugin_register_plugin_synapse_plugin_register_func, _tmp3_ != NULL, _ ("zeal is not installed, please see zealdocs.org"));
#line 100 "../../../src/plugins/zeal-plugin.vala"
	_g_free0 (_tmp3_);
#line 100 "../../../src/plugins/zeal-plugin.vala"
	_g_object_unref0 (_tmp1_);
#line 576 "zeal-plugin.c"
}

static gboolean
synapse_zeal_plugin_real_handles_query (SynapseItemProvider* base,
                                        SynapseQuery* query)
{
	SynapseZealPlugin * self;
	gboolean _tmp0_ = FALSE;
	SynapseQuery _tmp1_;
	SynapseQueryFlags _tmp2_;
	gboolean result = FALSE;
#line 111 "../../../src/plugins/zeal-plugin.vala"
	self = (SynapseZealPlugin*) base;
#line 111 "../../../src/plugins/zeal-plugin.vala"
	g_return_val_if_fail (query != NULL, FALSE);
#line 113 "../../../src/plugins/zeal-plugin.vala"
	_tmp1_ = *query;
#line 113 "../../../src/plugins/zeal-plugin.vala"
	_tmp2_ = _tmp1_.query_type;
#line 113 "../../../src/plugins/zeal-plugin.vala"
	if ((_tmp2_ & SYNAPSE_QUERY_FLAGS_ACTIONS) == SYNAPSE_QUERY_FLAGS_ACTIONS) {
#line 598 "zeal-plugin.c"
		GeeList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
#line 113 "../../../src/plugins/zeal-plugin.vala"
		_tmp3_ = self->priv->doclist;
#line 113 "../../../src/plugins/zeal-plugin.vala"
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
#line 113 "../../../src/plugins/zeal-plugin.vala"
		_tmp5_ = _tmp4_;
#line 113 "../../../src/plugins/zeal-plugin.vala"
		_tmp0_ = _tmp5_ > 0;
#line 610 "zeal-plugin.c"
	} else {
#line 113 "../../../src/plugins/zeal-plugin.vala"
		_tmp0_ = FALSE;
#line 614 "zeal-plugin.c"
	}
#line 113 "../../../src/plugins/zeal-plugin.vala"
	result = _tmp0_;
#line 113 "../../../src/plugins/zeal-plugin.vala"
	return result;
#line 620 "zeal-plugin.c"
}

static void
synapse_zeal_plugin_real_search_data_free (gpointer _data)
{
	SynapseZealPluginSearchData* _data_;
	_data_ = _data;
#line 45 "../../../src/plugins/zeal-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 45 "../../../src/plugins/zeal-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 45 "../../../src/plugins/zeal-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 45 "../../../src/plugins/zeal-plugin.vala"
	g_slice_free (SynapseZealPluginSearchData, _data_);
#line 636 "zeal-plugin.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 45 "../../../src/plugins/zeal-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 644 "zeal-plugin.c"
}

static void
synapse_zeal_plugin_real_search (SynapseItemProvider* base,
                                 SynapseQuery* q,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	SynapseZealPlugin * self;
	SynapseZealPluginSearchData* _data_;
	SynapseZealPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
#line 45 "../../../src/plugins/zeal-plugin.vala"
	self = (SynapseZealPlugin*) base;
#line 45 "../../../src/plugins/zeal-plugin.vala"
	_data_ = g_slice_new0 (SynapseZealPluginSearchData);
#line 45 "../../../src/plugins/zeal-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 45 "../../../src/plugins/zeal-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_zeal_plugin_real_search_data_free);
#line 45 "../../../src/plugins/zeal-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 45 "../../../src/plugins/zeal-plugin.vala"
	_data_->self = _tmp0_;
#line 45 "../../../src/plugins/zeal-plugin.vala"
	_tmp1_ = *q;
#line 45 "../../../src/plugins/zeal-plugin.vala"
	_tmp2_ = _tmp1_;
#line 45 "../../../src/plugins/zeal-plugin.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 45 "../../../src/plugins/zeal-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 45 "../../../src/plugins/zeal-plugin.vala"
	_data_->q = _tmp3_;
#line 45 "../../../src/plugins/zeal-plugin.vala"
	synapse_zeal_plugin_real_search_co (_data_);
#line 683 "zeal-plugin.c"
}

static SynapseResultSet*
synapse_zeal_plugin_search_finish (SynapseItemProvider* base,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	SynapseResultSet* result;
	SynapseZealPluginSearchData* _data_;
#line 45 "../../../src/plugins/zeal-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 45 "../../../src/plugins/zeal-plugin.vala"
	if (NULL == _data_) {
#line 45 "../../../src/plugins/zeal-plugin.vala"
		return NULL;
#line 699 "zeal-plugin.c"
	}
#line 45 "../../../src/plugins/zeal-plugin.vala"
	result = _data_->result;
#line 45 "../../../src/plugins/zeal-plugin.vala"
	_data_->result = NULL;
#line 45 "../../../src/plugins/zeal-plugin.vala"
	return result;
#line 707 "zeal-plugin.c"
}

static gboolean
_synapse_zeal_plugin_real_search_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_zeal_plugin_real_search_co (self);
#line 118 "../../../src/plugins/zeal-plugin.vala"
	return result;
#line 717 "zeal-plugin.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1535 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 739 "zeal-plugin.c"
	} else {
#line 1535 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 743 "zeal-plugin.c"
	}
#line 1535 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1535 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 749 "zeal-plugin.c"
	} else {
#line 1535 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 753 "zeal-plugin.c"
	}
#line 1535 "glib-2.0.vapi"
	if (_tmp0_) {
#line 757 "zeal-plugin.c"
		gchar* _tmp2_;
#line 1536 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1536 "glib-2.0.vapi"
		result = _tmp2_;
#line 1536 "glib-2.0.vapi"
		return result;
#line 765 "zeal-plugin.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1539 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1539 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1539 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1539 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1539 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1539 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1539 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1539 "glib-2.0.vapi"
			_g_free0 (_tmp7_);
#line 1539 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1539 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 797 "zeal-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 1539 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1539 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1539 "glib-2.0.vapi"
			return NULL;
#line 806 "zeal-plugin.c"
		}
#line 1540 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1540 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1540 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1540 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1540 "glib-2.0.vapi"
			_g_free0 (_tmp7_);
#line 1540 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1540 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 822 "zeal-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 1540 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1540 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1540 "glib-2.0.vapi"
			return NULL;
#line 831 "zeal-plugin.c"
		}
#line 1540 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1540 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1540 "glib-2.0.vapi"
		result = _tmp10_;
#line 1540 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1540 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1540 "glib-2.0.vapi"
		return result;
#line 845 "zeal-plugin.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1538 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1542 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 854 "zeal-plugin.c"
	}
	__finally0:
#line 1538 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1538 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1538 "glib-2.0.vapi"
	return NULL;
#line 863 "zeal-plugin.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
#line 1359 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1360 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1360 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1361 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1362 "glib-2.0.vapi"
	result = _result_;
#line 1362 "glib-2.0.vapi"
	return result;
#line 884 "zeal-plugin.c"
}

static gboolean
synapse_zeal_plugin_real_search_co (SynapseZealPluginSearchData* _data_)
{
#line 116 "../../../src/plugins/zeal-plugin.vala"
	switch (_data_->_state_) {
#line 116 "../../../src/plugins/zeal-plugin.vala"
		case 0:
#line 894 "zeal-plugin.c"
		goto _state_0;
#line 116 "../../../src/plugins/zeal-plugin.vala"
		case 1:
#line 898 "zeal-plugin.c"
		goto _state_1;
		default:
#line 116 "../../../src/plugins/zeal-plugin.vala"
		g_assert_not_reached ();
#line 903 "zeal-plugin.c"
	}
	_state_0:
#line 118 "../../../src/plugins/zeal-plugin.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _synapse_zeal_plugin_real_search_co_gsource_func, _data_, NULL);
#line 119 "../../../src/plugins/zeal-plugin.vala"
	_data_->_state_ = 1;
#line 119 "../../../src/plugins/zeal-plugin.vala"
	return FALSE;
#line 912 "zeal-plugin.c"
	_state_1:
	;
#line 120 "../../../src/plugins/zeal-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 120 "../../../src/plugins/zeal-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 120 "../../../src/plugins/zeal-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 120 "../../../src/plugins/zeal-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 120 "../../../src/plugins/zeal-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 120 "../../../src/plugins/zeal-plugin.vala"
			return FALSE;
#line 927 "zeal-plugin.c"
		} else {
#line 120 "../../../src/plugins/zeal-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 120 "../../../src/plugins/zeal-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 120 "../../../src/plugins/zeal-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 120 "../../../src/plugins/zeal-plugin.vala"
			return FALSE;
#line 937 "zeal-plugin.c"
		}
	}
#line 122 "../../../src/plugins/zeal-plugin.vala"
	_data_->_tmp0_ = _data_->q;
#line 122 "../../../src/plugins/zeal-plugin.vala"
	_data_->_tmp1_ = _data_->_tmp0_.query_string;
#line 122 "../../../src/plugins/zeal-plugin.vala"
	_data_->_tmp2_ = g_utf8_strdown (_data_->_tmp1_, (gssize) -1);
#line 122 "../../../src/plugins/zeal-plugin.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 122 "../../../src/plugins/zeal-plugin.vala"
	_data_->_tmp4_ = string_replace (_data_->_tmp3_, "zeal", "");
#line 122 "../../../src/plugins/zeal-plugin.vala"
	_data_->_tmp5_ = _data_->_tmp4_;
#line 122 "../../../src/plugins/zeal-plugin.vala"
	_data_->_tmp6_ = string_strip (_data_->_tmp5_);
#line 122 "../../../src/plugins/zeal-plugin.vala"
	_g_free0 (_data_->q.query_string);
#line 122 "../../../src/plugins/zeal-plugin.vala"
	_data_->q.query_string = _data_->_tmp6_;
#line 122 "../../../src/plugins/zeal-plugin.vala"
	_g_free0 (_data_->_tmp5_);
#line 122 "../../../src/plugins/zeal-plugin.vala"
	_g_free0 (_data_->_tmp3_);
#line 123 "../../../src/plugins/zeal-plugin.vala"
	_data_->_tmp7_ = synapse_result_set_new ();
#line 123 "../../../src/plugins/zeal-plugin.vala"
	_data_->results = _data_->_tmp7_;
#line 124 "../../../src/plugins/zeal-plugin.vala"
	_data_->_tmp8_ = _data_->q;
#line 124 "../../../src/plugins/zeal-plugin.vala"
	_data_->_tmp9_ = _data_->_tmp8_.query_string;
#line 124 "../../../src/plugins/zeal-plugin.vala"
	_data_->_tmp10_ = synapse_query_get_matchers_for_query (_data_->_tmp9_, 0, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
#line 124 "../../../src/plugins/zeal-plugin.vala"
	_data_->matchers = _data_->_tmp10_;
#line 974 "zeal-plugin.c"
	{
#line 126 "../../../src/plugins/zeal-plugin.vala"
		_data_->_tmp11_ = _data_->self->priv->doclist;
#line 126 "../../../src/plugins/zeal-plugin.vala"
		_data_->_tmp12_ = _g_object_ref0 (_data_->_tmp11_);
#line 126 "../../../src/plugins/zeal-plugin.vala"
		_data_->_doc_list = _data_->_tmp12_;
#line 126 "../../../src/plugins/zeal-plugin.vala"
		_data_->_tmp13_ = _data_->_doc_list;
#line 126 "../../../src/plugins/zeal-plugin.vala"
		_data_->_tmp14_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp13_);
#line 126 "../../../src/plugins/zeal-plugin.vala"
		_data_->_tmp15_ = _data_->_tmp14_;
#line 126 "../../../src/plugins/zeal-plugin.vala"
		_data_->_doc_size = _data_->_tmp15_;
#line 126 "../../../src/plugins/zeal-plugin.vala"
		_data_->_doc_index = -1;
#line 126 "../../../src/plugins/zeal-plugin.vala"
		while (TRUE) {
#line 126 "../../../src/plugins/zeal-plugin.vala"
			_data_->_doc_index = _data_->_doc_index + 1;
#line 126 "../../../src/plugins/zeal-plugin.vala"
			_data_->_tmp16_ = _data_->_doc_index;
#line 126 "../../../src/plugins/zeal-plugin.vala"
			_data_->_tmp17_ = _data_->_doc_size;
#line 126 "../../../src/plugins/zeal-plugin.vala"
			if (!(_data_->_tmp16_ < _data_->_tmp17_)) {
#line 126 "../../../src/plugins/zeal-plugin.vala"
				break;
#line 1004 "zeal-plugin.c"
			}
#line 126 "../../../src/plugins/zeal-plugin.vala"
			_data_->_tmp18_ = _data_->_doc_list;
#line 126 "../../../src/plugins/zeal-plugin.vala"
			_data_->_tmp19_ = gee_list_get (_data_->_tmp18_, _data_->_doc_index);
#line 126 "../../../src/plugins/zeal-plugin.vala"
			_data_->doc = (SynapseZealDoc*) _data_->_tmp19_;
#line 1012 "zeal-plugin.c"
			{
#line 128 "../../../src/plugins/zeal-plugin.vala"
				_data_->_tmp20_ = _data_->matchers;
#line 128 "../../../src/plugins/zeal-plugin.vala"
				_data_->_tmp21_ = _g_object_ref0 (_data_->_tmp20_);
#line 128 "../../../src/plugins/zeal-plugin.vala"
				_data_->_matcher_list = _data_->_tmp21_;
#line 128 "../../../src/plugins/zeal-plugin.vala"
				_data_->_tmp22_ = _data_->_matcher_list;
#line 128 "../../../src/plugins/zeal-plugin.vala"
				_data_->_tmp23_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp22_);
#line 128 "../../../src/plugins/zeal-plugin.vala"
				_data_->_tmp24_ = _data_->_tmp23_;
#line 128 "../../../src/plugins/zeal-plugin.vala"
				_data_->_matcher_size = _data_->_tmp24_;
#line 128 "../../../src/plugins/zeal-plugin.vala"
				_data_->_matcher_index = -1;
#line 128 "../../../src/plugins/zeal-plugin.vala"
				while (TRUE) {
#line 128 "../../../src/plugins/zeal-plugin.vala"
					_data_->_matcher_index = _data_->_matcher_index + 1;
#line 128 "../../../src/plugins/zeal-plugin.vala"
					_data_->_tmp25_ = _data_->_matcher_index;
#line 128 "../../../src/plugins/zeal-plugin.vala"
					_data_->_tmp26_ = _data_->_matcher_size;
#line 128 "../../../src/plugins/zeal-plugin.vala"
					if (!(_data_->_tmp25_ < _data_->_tmp26_)) {
#line 128 "../../../src/plugins/zeal-plugin.vala"
						break;
#line 1042 "zeal-plugin.c"
					}
#line 128 "../../../src/plugins/zeal-plugin.vala"
					_data_->_tmp27_ = _data_->_matcher_list;
#line 128 "../../../src/plugins/zeal-plugin.vala"
					_data_->_tmp28_ = gee_list_get (_data_->_tmp27_, _data_->_matcher_index);
#line 128 "../../../src/plugins/zeal-plugin.vala"
					_data_->matcher = (GeeMapEntry*) _data_->_tmp28_;
#line 130 "../../../src/plugins/zeal-plugin.vala"
					_data_->_tmp29_ = _data_->matcher;
#line 130 "../../../src/plugins/zeal-plugin.vala"
					_data_->_tmp30_ = gee_map_entry_get_key (_data_->_tmp29_);
#line 130 "../../../src/plugins/zeal-plugin.vala"
					_data_->_tmp31_ = _data_->_tmp30_;
#line 130 "../../../src/plugins/zeal-plugin.vala"
					_data_->_tmp32_ = _data_->doc;
#line 130 "../../../src/plugins/zeal-plugin.vala"
					_data_->_tmp33_ = _data_->_tmp32_->scf_bundle_name;
#line 130 "../../../src/plugins/zeal-plugin.vala"
					if (g_regex_match ((GRegex*) _data_->_tmp31_, _data_->_tmp33_, 0, NULL)) {
#line 132 "../../../src/plugins/zeal-plugin.vala"
						_data_->_tmp34_ = _data_->doc;
#line 132 "../../../src/plugins/zeal-plugin.vala"
						_data_->_tmp35_ = _data_->q;
#line 132 "../../../src/plugins/zeal-plugin.vala"
						_data_->_tmp36_ = _data_->_tmp35_.query_string;
#line 132 "../../../src/plugins/zeal-plugin.vala"
						synapse_zeal_doc_update_title (_data_->_tmp34_, _data_->_tmp36_);
#line 133 "../../../src/plugins/zeal-plugin.vala"
						_data_->_tmp37_ = _data_->results;
#line 133 "../../../src/plugins/zeal-plugin.vala"
						_data_->_tmp38_ = _data_->doc;
#line 133 "../../../src/plugins/zeal-plugin.vala"
						_data_->_tmp39_ = _data_->matcher;
#line 133 "../../../src/plugins/zeal-plugin.vala"
						_data_->_tmp40_ = gee_map_entry_get_value (_data_->_tmp39_);
#line 133 "../../../src/plugins/zeal-plugin.vala"
						_data_->_tmp41_ = _data_->_tmp40_;
#line 133 "../../../src/plugins/zeal-plugin.vala"
						synapse_result_set_add (_data_->_tmp37_, (SynapseMatch*) _data_->_tmp38_, (gint) ((gintptr) _data_->_tmp41_));
#line 1082 "zeal-plugin.c"
					}
#line 128 "../../../src/plugins/zeal-plugin.vala"
					_g_object_unref0 (_data_->matcher);
#line 1086 "zeal-plugin.c"
				}
#line 128 "../../../src/plugins/zeal-plugin.vala"
				_g_object_unref0 (_data_->_matcher_list);
#line 1090 "zeal-plugin.c"
			}
#line 137 "../../../src/plugins/zeal-plugin.vala"
			_data_->_tmp42_ = _data_->doc;
#line 137 "../../../src/plugins/zeal-plugin.vala"
			_data_->_tmp43_ = _data_->_tmp42_->regex;
#line 137 "../../../src/plugins/zeal-plugin.vala"
			_data_->_tmp44_ = _data_->q;
#line 137 "../../../src/plugins/zeal-plugin.vala"
			_data_->_tmp45_ = _data_->_tmp44_.query_string;
#line 137 "../../../src/plugins/zeal-plugin.vala"
			if (g_regex_match (_data_->_tmp43_, _data_->_tmp45_, 0, NULL)) {
#line 139 "../../../src/plugins/zeal-plugin.vala"
				_data_->_tmp46_ = _data_->doc;
#line 139 "../../../src/plugins/zeal-plugin.vala"
				_data_->_tmp47_ = _data_->_tmp46_->scf_bundle_name;
#line 139 "../../../src/plugins/zeal-plugin.vala"
				_data_->_tmp49_ = _data_->_tmp48_ = g_strsplit_set (_data_->_tmp47_, "_ ", 0);
#line 1108 "zeal-plugin.c"
				{
#line 139 "../../../src/plugins/zeal-plugin.vala"
					_data_->part_collection_length1 = 0;
#line 139 "../../../src/plugins/zeal-plugin.vala"
					_data_->_part_collection_size_ = 0;
#line 139 "../../../src/plugins/zeal-plugin.vala"
					_data_->part_collection = _data_->_tmp49_;
#line 139 "../../../src/plugins/zeal-plugin.vala"
					_data_->part_collection_length1 = _vala_array_length (_data_->_tmp48_);
#line 139 "../../../src/plugins/zeal-plugin.vala"
					for (_data_->part_it = 0; _data_->part_it < _data_->part_collection_length1; _data_->part_it = _data_->part_it + 1) {
#line 139 "../../../src/plugins/zeal-plugin.vala"
						_data_->_tmp50_ = g_strdup (_data_->part_collection[_data_->part_it]);
#line 139 "../../../src/plugins/zeal-plugin.vala"
						_data_->part = _data_->_tmp50_;
#line 1124 "zeal-plugin.c"
						{
#line 140 "../../../src/plugins/zeal-plugin.vala"
							_data_->_tmp51_ = _data_->q;
#line 140 "../../../src/plugins/zeal-plugin.vala"
							_data_->_tmp52_ = _data_->_tmp51_.query_string;
#line 140 "../../../src/plugins/zeal-plugin.vala"
							_data_->_tmp53_ = _data_->part;
#line 140 "../../../src/plugins/zeal-plugin.vala"
							_data_->_tmp54_ = synapse_zeal_doc_replace_first_occurence (_data_->_tmp52_, _data_->_tmp53_, "");
#line 140 "../../../src/plugins/zeal-plugin.vala"
							_g_free0 (_data_->q.query_string);
#line 140 "../../../src/plugins/zeal-plugin.vala"
							_data_->q.query_string = _data_->_tmp54_;
#line 139 "../../../src/plugins/zeal-plugin.vala"
							_g_free0 (_data_->part);
#line 1140 "zeal-plugin.c"
						}
					}
#line 139 "../../../src/plugins/zeal-plugin.vala"
					_data_->part_collection = (_vala_array_free (_data_->part_collection, _data_->part_collection_length1, (GDestroyNotify) g_free), NULL);
#line 1145 "zeal-plugin.c"
				}
#line 141 "../../../src/plugins/zeal-plugin.vala"
				_data_->_tmp55_ = _data_->doc;
#line 141 "../../../src/plugins/zeal-plugin.vala"
				_data_->_tmp56_ = _data_->q;
#line 141 "../../../src/plugins/zeal-plugin.vala"
				_data_->_tmp57_ = _data_->_tmp56_.query_string;
#line 141 "../../../src/plugins/zeal-plugin.vala"
				_data_->_tmp58_ = string_replace (_data_->_tmp57_, ":", "");
#line 141 "../../../src/plugins/zeal-plugin.vala"
				_data_->_tmp59_ = _data_->_tmp58_;
#line 141 "../../../src/plugins/zeal-plugin.vala"
				_data_->_tmp60_ = string_strip (_data_->_tmp59_);
#line 141 "../../../src/plugins/zeal-plugin.vala"
				_data_->_tmp61_ = _data_->_tmp60_;
#line 141 "../../../src/plugins/zeal-plugin.vala"
				synapse_zeal_doc_update_title (_data_->_tmp55_, _data_->_tmp61_);
#line 141 "../../../src/plugins/zeal-plugin.vala"
				_g_free0 (_data_->_tmp61_);
#line 141 "../../../src/plugins/zeal-plugin.vala"
				_g_free0 (_data_->_tmp59_);
#line 142 "../../../src/plugins/zeal-plugin.vala"
				_data_->_tmp62_ = _data_->results;
#line 142 "../../../src/plugins/zeal-plugin.vala"
				_data_->_tmp63_ = _data_->doc;
#line 142 "../../../src/plugins/zeal-plugin.vala"
				synapse_result_set_add (_data_->_tmp62_, (SynapseMatch*) _data_->_tmp63_, (gint) SYNAPSE_MATCH_SCORE_AVERAGE);
#line 143 "../../../src/plugins/zeal-plugin.vala"
				_g_object_unref0 (_data_->doc);
#line 143 "../../../src/plugins/zeal-plugin.vala"
				break;
#line 1177 "zeal-plugin.c"
			}
#line 126 "../../../src/plugins/zeal-plugin.vala"
			_g_object_unref0 (_data_->doc);
#line 1181 "zeal-plugin.c"
		}
#line 126 "../../../src/plugins/zeal-plugin.vala"
		_g_object_unref0 (_data_->_doc_list);
#line 1185 "zeal-plugin.c"
	}
#line 147 "../../../src/plugins/zeal-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 147 "../../../src/plugins/zeal-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 147 "../../../src/plugins/zeal-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 147 "../../../src/plugins/zeal-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 147 "../../../src/plugins/zeal-plugin.vala"
			_g_object_unref0 (_data_->matchers);
#line 147 "../../../src/plugins/zeal-plugin.vala"
			_g_object_unref0 (_data_->results);
#line 147 "../../../src/plugins/zeal-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 147 "../../../src/plugins/zeal-plugin.vala"
			return FALSE;
#line 1203 "zeal-plugin.c"
		} else {
#line 147 "../../../src/plugins/zeal-plugin.vala"
			_g_object_unref0 (_data_->matchers);
#line 147 "../../../src/plugins/zeal-plugin.vala"
			_g_object_unref0 (_data_->results);
#line 147 "../../../src/plugins/zeal-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 147 "../../../src/plugins/zeal-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 147 "../../../src/plugins/zeal-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 147 "../../../src/plugins/zeal-plugin.vala"
			return FALSE;
#line 1217 "zeal-plugin.c"
		}
	}
#line 148 "../../../src/plugins/zeal-plugin.vala"
	_data_->result = _data_->results;
#line 148 "../../../src/plugins/zeal-plugin.vala"
	_g_object_unref0 (_data_->matchers);
#line 148 "../../../src/plugins/zeal-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 148 "../../../src/plugins/zeal-plugin.vala"
	if (_data_->_state_ != 0) {
#line 148 "../../../src/plugins/zeal-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 148 "../../../src/plugins/zeal-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1232 "zeal-plugin.c"
		}
	}
#line 148 "../../../src/plugins/zeal-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 148 "../../../src/plugins/zeal-plugin.vala"
	return FALSE;
#line 1239 "zeal-plugin.c"
}

SynapseZealPlugin*
synapse_zeal_plugin_construct (GType object_type)
{
	SynapseZealPlugin * self = NULL;
#line 45 "../../../src/plugins/zeal-plugin.vala"
	self = (SynapseZealPlugin*) g_object_new (object_type, NULL);
#line 45 "../../../src/plugins/zeal-plugin.vala"
	return self;
#line 1250 "zeal-plugin.c"
}

SynapseZealPlugin*
synapse_zeal_plugin_new (void)
{
#line 45 "../../../src/plugins/zeal-plugin.vala"
	return synapse_zeal_plugin_construct (SYNAPSE_TYPE_ZEAL_PLUGIN);
#line 1258 "zeal-plugin.c"
}

static gboolean
synapse_zeal_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseZealPlugin* self;
#line 47 "../../../src/plugins/zeal-plugin.vala"
	self = (SynapseZealPlugin*) base;
#line 47 "../../../src/plugins/zeal-plugin.vala"
	result = self->priv->_enabled;
#line 47 "../../../src/plugins/zeal-plugin.vala"
	return result;
#line 1272 "zeal-plugin.c"
}

static void
synapse_zeal_plugin_real_set_enabled (SynapseActivatable* base,
                                      gboolean value)
{
	SynapseZealPlugin* self;
	gboolean old_value;
#line 47 "../../../src/plugins/zeal-plugin.vala"
	self = (SynapseZealPlugin*) base;
#line 47 "../../../src/plugins/zeal-plugin.vala"
	old_value = synapse_zeal_plugin_real_get_enabled (base);
#line 47 "../../../src/plugins/zeal-plugin.vala"
	if (old_value != value) {
#line 47 "../../../src/plugins/zeal-plugin.vala"
		self->priv->_enabled = value;
#line 47 "../../../src/plugins/zeal-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_zeal_plugin_properties[SYNAPSE_ZEAL_PLUGIN_ENABLED_PROPERTY]);
#line 1291 "zeal-plugin.c"
	}
}

static void
synapse_zeal_plugin_class_init (SynapseZealPluginClass * klass,
                                gpointer klass_data)
{
#line 45 "../../../src/plugins/zeal-plugin.vala"
	synapse_zeal_plugin_parent_class = g_type_class_peek_parent (klass);
#line 45 "../../../src/plugins/zeal-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseZealPlugin_private_offset);
#line 45 "../../../src/plugins/zeal-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_zeal_plugin_get_property;
#line 45 "../../../src/plugins/zeal-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_zeal_plugin_set_property;
#line 45 "../../../src/plugins/zeal-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_zeal_plugin_finalize;
#line 45 "../../../src/plugins/zeal-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEAL_PLUGIN_ENABLED_PROPERTY, synapse_zeal_plugin_properties[SYNAPSE_ZEAL_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 95 "../../../src/plugins/zeal-plugin.vala"
	synapse_zeal_plugin_register_plugin ();
#line 1313 "zeal-plugin.c"
}

static void
synapse_zeal_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                        gpointer iface_data)
{
#line 45 "../../../src/plugins/zeal-plugin.vala"
	synapse_zeal_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 45 "../../../src/plugins/zeal-plugin.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_zeal_plugin_real_activate;
#line 45 "../../../src/plugins/zeal-plugin.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_zeal_plugin_real_deactivate;
#line 45 "../../../src/plugins/zeal-plugin.vala"
	iface->get_enabled = synapse_zeal_plugin_real_get_enabled;
#line 45 "../../../src/plugins/zeal-plugin.vala"
	iface->set_enabled = synapse_zeal_plugin_real_set_enabled;
#line 1330 "zeal-plugin.c"
}

static void
synapse_zeal_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                          gpointer iface_data)
{
#line 45 "../../../src/plugins/zeal-plugin.vala"
	synapse_zeal_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 45 "../../../src/plugins/zeal-plugin.vala"
	iface->handles_query = (gboolean (*) (SynapseItemProvider*, SynapseQuery*)) synapse_zeal_plugin_real_handles_query;
#line 45 "../../../src/plugins/zeal-plugin.vala"
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_zeal_plugin_real_search;
#line 45 "../../../src/plugins/zeal-plugin.vala"
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_zeal_plugin_search_finish;
#line 1345 "zeal-plugin.c"
}

static void
synapse_zeal_plugin_instance_init (SynapseZealPlugin * self,
                                   gpointer klass)
{
#line 45 "../../../src/plugins/zeal-plugin.vala"
	self->priv = synapse_zeal_plugin_get_instance_private (self);
#line 47 "../../../src/plugins/zeal-plugin.vala"
	self->priv->_enabled = TRUE;
#line 1356 "zeal-plugin.c"
}

static void
synapse_zeal_plugin_finalize (GObject * obj)
{
	SynapseZealPlugin * self;
#line 45 "../../../src/plugins/zeal-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_ZEAL_PLUGIN, SynapseZealPlugin);
#line 49 "../../../src/plugins/zeal-plugin.vala"
	_g_object_unref0 (self->priv->doclist);
#line 45 "../../../src/plugins/zeal-plugin.vala"
	G_OBJECT_CLASS (synapse_zeal_plugin_parent_class)->finalize (obj);
#line 1369 "zeal-plugin.c"
}

/**
   * This plugin looks for zeal installed documentations
   * then it allows you to make a query on a specified doc
   * It supports queries like :
   * zeal php:php
   * or
   * zeal php constant
   * zeal php:constant
   * php constant
   * php magic constant
   * php magic constant zeal
   * php :  magic constant zeal
   *
   * and so it searches "php:magic constants" in zeal by opening it.
   * It handles complicated doc names like Apache_HTTP_Server "apache license"
   * "server license" "http license" these 3 result in "apache http server:license"
   *
   * An update would consist to aggregate the sqlite databases
   * and show results directly or develop a CLI update to zeal
   * directly.
   */
static GType
synapse_zeal_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseZealPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_zeal_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseZealPlugin), 0, (GInstanceInitFunc) synapse_zeal_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_zeal_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_zeal_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_zeal_plugin_type_id;
	synapse_zeal_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseZealPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_zeal_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_zeal_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseZealPlugin_private_offset = g_type_add_instance_private (synapse_zeal_plugin_type_id, sizeof (SynapseZealPluginPrivate));
	return synapse_zeal_plugin_type_id;
}

GType
synapse_zeal_plugin_get_type (void)
{
	static volatile gsize synapse_zeal_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_zeal_plugin_type_id__volatile)) {
		GType synapse_zeal_plugin_type_id;
		synapse_zeal_plugin_type_id = synapse_zeal_plugin_get_type_once ();
		g_once_init_leave (&synapse_zeal_plugin_type_id__volatile, synapse_zeal_plugin_type_id);
	}
	return synapse_zeal_plugin_type_id__volatile;
}

static void
_vala_synapse_zeal_plugin_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	SynapseZealPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_ZEAL_PLUGIN, SynapseZealPlugin);
#line 45 "../../../src/plugins/zeal-plugin.vala"
	switch (property_id) {
#line 45 "../../../src/plugins/zeal-plugin.vala"
		case SYNAPSE_ZEAL_PLUGIN_ENABLED_PROPERTY:
#line 45 "../../../src/plugins/zeal-plugin.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 45 "../../../src/plugins/zeal-plugin.vala"
		break;
#line 1435 "zeal-plugin.c"
		default:
#line 45 "../../../src/plugins/zeal-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 45 "../../../src/plugins/zeal-plugin.vala"
		break;
#line 1441 "zeal-plugin.c"
	}
}

static void
_vala_synapse_zeal_plugin_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	SynapseZealPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_ZEAL_PLUGIN, SynapseZealPlugin);
#line 45 "../../../src/plugins/zeal-plugin.vala"
	switch (property_id) {
#line 45 "../../../src/plugins/zeal-plugin.vala"
		case SYNAPSE_ZEAL_PLUGIN_ENABLED_PROPERTY:
#line 45 "../../../src/plugins/zeal-plugin.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 45 "../../../src/plugins/zeal-plugin.vala"
		break;
#line 1461 "zeal-plugin.c"
		default:
#line 45 "../../../src/plugins/zeal-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 45 "../../../src/plugins/zeal-plugin.vala"
		break;
#line 1467 "zeal-plugin.c"
	}
}

static inline gpointer
synapse_zeal_doc_get_instance_private (SynapseZealDoc* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseZealDoc_private_offset);
}

SynapseZealDoc*
synapse_zeal_doc_construct (GType object_type,
                            const gchar* doc_path)
{
	SynapseZealDoc * self = NULL;
#line 163 "../../../src/plugins/zeal-plugin.vala"
	g_return_val_if_fail (doc_path != NULL, NULL);
#line 165 "../../../src/plugins/zeal-plugin.vala"
	self = (SynapseZealDoc*) g_object_new (object_type, "title", "Zeal Doc", "description", _ ("Zeal documentation research"), "icon-name", "zeal", "has-thumbnail", FALSE, "doc-path", doc_path, NULL);
#line 163 "../../../src/plugins/zeal-plugin.vala"
	return self;
#line 1488 "zeal-plugin.c"
}

SynapseZealDoc*
synapse_zeal_doc_new (const gchar* doc_path)
{
#line 163 "../../../src/plugins/zeal-plugin.vala"
	return synapse_zeal_doc_construct (SYNAPSE_TYPE_ZEAL_DOC, doc_path);
#line 1496 "zeal-plugin.c"
}

static void
synapse_zeal_doc_real_do_action (SynapseActionMatch* base)
{
	SynapseZealDoc * self;
	GError* _inner_error0_ = NULL;
#line 190 "../../../src/plugins/zeal-plugin.vala"
	self = (SynapseZealDoc*) base;
#line 1506 "zeal-plugin.c"
	{
		GAppInfo* ai = NULL;
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GAppInfo* _tmp4_;
		GAppInfo* _tmp5_;
		GAppInfo* _tmp6_;
#line 194 "../../../src/plugins/zeal-plugin.vala"
		_tmp0_ = self->scf_bundle_name;
#line 194 "../../../src/plugins/zeal-plugin.vala"
		_tmp1_ = self->priv->query;
#line 194 "../../../src/plugins/zeal-plugin.vala"
		_tmp2_ = g_strdup_printf ("zeal \"%s:%s\"", _tmp0_, _tmp1_);
#line 194 "../../../src/plugins/zeal-plugin.vala"
		_tmp3_ = _tmp2_;
#line 194 "../../../src/plugins/zeal-plugin.vala"
		_tmp4_ = g_app_info_create_from_commandline (_tmp3_, "zeal", 0, &_inner_error0_);
#line 194 "../../../src/plugins/zeal-plugin.vala"
		_tmp5_ = _tmp4_;
#line 194 "../../../src/plugins/zeal-plugin.vala"
		_g_free0 (_tmp3_);
#line 194 "../../../src/plugins/zeal-plugin.vala"
		ai = _tmp5_;
#line 194 "../../../src/plugins/zeal-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1534 "zeal-plugin.c"
			goto __catch0_g_error;
		}
#line 195 "../../../src/plugins/zeal-plugin.vala"
		_tmp6_ = ai;
#line 195 "../../../src/plugins/zeal-plugin.vala"
		g_app_info_launch (_tmp6_, NULL, NULL, &_inner_error0_);
#line 195 "../../../src/plugins/zeal-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 195 "../../../src/plugins/zeal-plugin.vala"
			_g_object_unref0 (ai);
#line 1545 "zeal-plugin.c"
			goto __catch0_g_error;
		}
#line 192 "../../../src/plugins/zeal-plugin.vala"
		_g_object_unref0 (ai);
#line 1550 "zeal-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 192 "../../../src/plugins/zeal-plugin.vala"
		err = _inner_error0_;
#line 192 "../../../src/plugins/zeal-plugin.vala"
		_inner_error0_ = NULL;
#line 199 "../../../src/plugins/zeal-plugin.vala"
		_tmp7_ = err;
#line 199 "../../../src/plugins/zeal-plugin.vala"
		_tmp8_ = _tmp7_->message;
#line 199 "../../../src/plugins/zeal-plugin.vala"
		g_warning ("zeal-plugin.vala:199: Could not launch zeal %s", _tmp8_);
#line 192 "../../../src/plugins/zeal-plugin.vala"
		_g_error_free0 (err);
#line 1570 "zeal-plugin.c"
	}
	__finally0:
#line 192 "../../../src/plugins/zeal-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 192 "../../../src/plugins/zeal-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 192 "../../../src/plugins/zeal-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 192 "../../../src/plugins/zeal-plugin.vala"
		return;
#line 1581 "zeal-plugin.c"
	}
}

void
synapse_zeal_doc_update_title (SynapseZealDoc* self,
                               const gchar* query)
{
	gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gchar* version = NULL;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
#line 203 "../../../src/plugins/zeal-plugin.vala"
	g_return_if_fail (self != NULL);
#line 203 "../../../src/plugins/zeal-plugin.vala"
	g_return_if_fail (query != NULL);
#line 205 "../../../src/plugins/zeal-plugin.vala"
	_tmp0_ = g_strdup (query);
#line 205 "../../../src/plugins/zeal-plugin.vala"
	_g_free0 (self->priv->query);
#line 205 "../../../src/plugins/zeal-plugin.vala"
	self->priv->query = _tmp0_;
#line 206 "../../../src/plugins/zeal-plugin.vala"
	_tmp2_ = self->priv->version;
#line 206 "../../../src/plugins/zeal-plugin.vala"
	if (_tmp2_ != NULL) {
#line 1611 "zeal-plugin.c"
		const gchar* _tmp3_;
		gchar* _tmp4_;
#line 206 "../../../src/plugins/zeal-plugin.vala"
		_tmp3_ = self->priv->version;
#line 206 "../../../src/plugins/zeal-plugin.vala"
		_tmp4_ = g_strdup_printf (" (v%s)", _tmp3_);
#line 206 "../../../src/plugins/zeal-plugin.vala"
		_g_free0 (_tmp1_);
#line 206 "../../../src/plugins/zeal-plugin.vala"
		_tmp1_ = _tmp4_;
#line 1622 "zeal-plugin.c"
	} else {
		gchar* _tmp5_;
#line 206 "../../../src/plugins/zeal-plugin.vala"
		_tmp5_ = g_strdup ("");
#line 206 "../../../src/plugins/zeal-plugin.vala"
		_g_free0 (_tmp1_);
#line 206 "../../../src/plugins/zeal-plugin.vala"
		_tmp1_ = _tmp5_;
#line 1631 "zeal-plugin.c"
	}
#line 206 "../../../src/plugins/zeal-plugin.vala"
	_tmp6_ = g_strdup (_tmp1_);
#line 206 "../../../src/plugins/zeal-plugin.vala"
	version = _tmp6_;
#line 207 "../../../src/plugins/zeal-plugin.vala"
	_tmp7_ = self->priv->doc_name;
#line 207 "../../../src/plugins/zeal-plugin.vala"
	_tmp8_ = g_strdup_printf ("Search for %s in %s%s", query, _tmp7_, version);
#line 207 "../../../src/plugins/zeal-plugin.vala"
	_tmp9_ = _tmp8_;
#line 207 "../../../src/plugins/zeal-plugin.vala"
	synapse_match_set_title ((SynapseMatch*) self, _tmp9_);
#line 207 "../../../src/plugins/zeal-plugin.vala"
	_g_free0 (_tmp9_);
#line 203 "../../../src/plugins/zeal-plugin.vala"
	_g_free0 (version);
#line 203 "../../../src/plugins/zeal-plugin.vala"
	_g_free0 (_tmp1_);
#line 1651 "zeal-plugin.c"
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
#line 1133 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1133 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1134 "glib-2.0.vapi"
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1134 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1136 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1136 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 1675 "zeal-plugin.c"
		gchar* _tmp2_;
#line 1137 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1137 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1137 "glib-2.0.vapi"
		return result;
#line 1683 "zeal-plugin.c"
	} else {
#line 1139 "glib-2.0.vapi"
		result = -1;
#line 1139 "glib-2.0.vapi"
		return result;
#line 1689 "zeal-plugin.c"
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
#line 1447 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1447 "glib-2.0.vapi"
	end = _tmp0_;
#line 1448 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1448 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1449 "glib-2.0.vapi"
		result = maxlen;
#line 1449 "glib-2.0.vapi"
		return result;
#line 1713 "zeal-plugin.c"
	} else {
		gchar* _tmp2_;
#line 1451 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1451 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1451 "glib-2.0.vapi"
		return result;
#line 1722 "zeal-plugin.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
#line 1458 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1460 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 1741 "zeal-plugin.c"
	} else {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1745 "zeal-plugin.c"
	}
#line 1460 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1462 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 1751 "zeal-plugin.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1464 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1464 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1464 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 1761 "zeal-plugin.c"
	}
#line 1467 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1468 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1469 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 1769 "zeal-plugin.c"
	} else {
#line 1471 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 1773 "zeal-plugin.c"
	}
#line 1473 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1474 "glib-2.0.vapi"
		len = string_length - offset;
#line 1779 "zeal-plugin.c"
	}
#line 1476 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1477 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1477 "glib-2.0.vapi"
	result = _tmp3_;
#line 1477 "glib-2.0.vapi"
	return result;
#line 1789 "zeal-plugin.c"
}

gchar*
synapse_zeal_doc_replace_first_occurence (const gchar* str,
                                          const gchar* search,
                                          const gchar* replace)
{
	gint pos = 0;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* result = NULL;
#line 210 "../../../src/plugins/zeal-plugin.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 210 "../../../src/plugins/zeal-plugin.vala"
	g_return_val_if_fail (search != NULL, NULL);
#line 210 "../../../src/plugins/zeal-plugin.vala"
	g_return_val_if_fail (replace != NULL, NULL);
#line 212 "../../../src/plugins/zeal-plugin.vala"
	pos = string_index_of (str, search, 0);
#line 213 "../../../src/plugins/zeal-plugin.vala"
	if (pos < 0) {
#line 1819 "zeal-plugin.c"
		gchar* _tmp0_;
#line 214 "../../../src/plugins/zeal-plugin.vala"
		_tmp0_ = g_strdup (str);
#line 214 "../../../src/plugins/zeal-plugin.vala"
		result = _tmp0_;
#line 214 "../../../src/plugins/zeal-plugin.vala"
		return result;
#line 1827 "zeal-plugin.c"
	}
#line 215 "../../../src/plugins/zeal-plugin.vala"
	_tmp1_ = string_substring (str, (glong) 0, (glong) pos);
#line 215 "../../../src/plugins/zeal-plugin.vala"
	_tmp2_ = _tmp1_;
#line 215 "../../../src/plugins/zeal-plugin.vala"
	_tmp3_ = g_strconcat (_tmp2_, replace, NULL);
#line 215 "../../../src/plugins/zeal-plugin.vala"
	_tmp4_ = _tmp3_;
#line 215 "../../../src/plugins/zeal-plugin.vala"
	_tmp5_ = strlen (search);
#line 215 "../../../src/plugins/zeal-plugin.vala"
	_tmp6_ = _tmp5_;
#line 215 "../../../src/plugins/zeal-plugin.vala"
	_tmp7_ = string_substring (str, (glong) (pos + _tmp6_), (glong) -1);
#line 215 "../../../src/plugins/zeal-plugin.vala"
	_tmp8_ = _tmp7_;
#line 215 "../../../src/plugins/zeal-plugin.vala"
	_tmp9_ = g_strconcat (_tmp4_, _tmp8_, NULL);
#line 215 "../../../src/plugins/zeal-plugin.vala"
	_tmp10_ = _tmp9_;
#line 215 "../../../src/plugins/zeal-plugin.vala"
	_g_free0 (_tmp8_);
#line 215 "../../../src/plugins/zeal-plugin.vala"
	_g_free0 (_tmp4_);
#line 215 "../../../src/plugins/zeal-plugin.vala"
	_g_free0 (_tmp2_);
#line 215 "../../../src/plugins/zeal-plugin.vala"
	result = _tmp10_;
#line 215 "../../../src/plugins/zeal-plugin.vala"
	return result;
#line 1859 "zeal-plugin.c"
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
#line 229 "../../../src/plugins/zeal-plugin.vala"
	return g_boxed_copy (json_node_get_type (), self);
#line 1867 "zeal-plugin.c"
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
#line 229 "../../../src/plugins/zeal-plugin.vala"
	return self ? _vala_JsonNode_copy (self) : NULL;
#line 1875 "zeal-plugin.c"
}

static void
_vala_JsonNode_free (JsonNode* self)
{
#line 232 "../../../src/plugins/zeal-plugin.vala"
	g_boxed_free (json_node_get_type (), self);
#line 1883 "zeal-plugin.c"
}

static void
synapse_zeal_doc_parse_doc_name (SynapseZealDoc* self)
{
	gchar* data = NULL;
	GError* _inner_error0_ = NULL;
#line 218 "../../../src/plugins/zeal-plugin.vala"
	g_return_if_fail (self != NULL);
#line 1893 "zeal-plugin.c"
	{
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		JsonParser* parser = NULL;
		JsonParser* _tmp4_;
		gboolean _tmp5_ = FALSE;
		JsonParser* _tmp6_;
		const gchar* _tmp7_;
#line 224 "../../../src/plugins/zeal-plugin.vala"
		_tmp0_ = self->priv->_doc_path;
#line 224 "../../../src/plugins/zeal-plugin.vala"
		_tmp1_ = g_strconcat (_tmp0_, "/meta.json", NULL);
#line 224 "../../../src/plugins/zeal-plugin.vala"
		_tmp2_ = _tmp1_;
#line 224 "../../../src/plugins/zeal-plugin.vala"
		g_file_get_contents (_tmp2_, &_tmp3_, NULL, &_inner_error0_);
#line 224 "../../../src/plugins/zeal-plugin.vala"
		_g_free0 (data);
#line 224 "../../../src/plugins/zeal-plugin.vala"
		data = _tmp3_;
#line 224 "../../../src/plugins/zeal-plugin.vala"
		_g_free0 (_tmp2_);
#line 224 "../../../src/plugins/zeal-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1920 "zeal-plugin.c"
			goto __catch0_g_error;
		}
#line 225 "../../../src/plugins/zeal-plugin.vala"
		_tmp4_ = json_parser_new ();
#line 225 "../../../src/plugins/zeal-plugin.vala"
		parser = _tmp4_;
#line 227 "../../../src/plugins/zeal-plugin.vala"
		_tmp6_ = parser;
#line 227 "../../../src/plugins/zeal-plugin.vala"
		_tmp7_ = data;
#line 227 "../../../src/plugins/zeal-plugin.vala"
		_tmp5_ = json_parser_load_from_data (_tmp6_, _tmp7_, (gssize) -1, &_inner_error0_);
#line 227 "../../../src/plugins/zeal-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 227 "../../../src/plugins/zeal-plugin.vala"
			_g_object_unref0 (parser);
#line 1937 "zeal-plugin.c"
			goto __catch0_g_error;
		}
#line 227 "../../../src/plugins/zeal-plugin.vala"
		if (_tmp5_) {
#line 1942 "zeal-plugin.c"
			JsonNode* node = NULL;
			JsonParser* _tmp8_;
			JsonNode* _tmp9_;
			JsonNode* _tmp10_;
			JsonNode* _tmp11_;
			JsonObject* obj = NULL;
			JsonNode* _tmp15_;
			JsonObject* _tmp16_;
			JsonObject* _tmp17_;
			GList* _tmp18_;
#line 229 "../../../src/plugins/zeal-plugin.vala"
			_tmp8_ = parser;
#line 229 "../../../src/plugins/zeal-plugin.vala"
			_tmp9_ = json_parser_get_root (_tmp8_);
#line 229 "../../../src/plugins/zeal-plugin.vala"
			_tmp10_ = __vala_JsonNode_copy0 (_tmp9_);
#line 229 "../../../src/plugins/zeal-plugin.vala"
			node = _tmp10_;
#line 231 "../../../src/plugins/zeal-plugin.vala"
			_tmp11_ = node;
#line 231 "../../../src/plugins/zeal-plugin.vala"
			if (json_node_get_node_type (_tmp11_) != JSON_NODE_OBJECT) {
#line 1965 "zeal-plugin.c"
				JsonNode* _tmp12_;
				const gchar* _tmp13_;
				GError* _tmp14_;
#line 232 "../../../src/plugins/zeal-plugin.vala"
				_tmp12_ = node;
#line 232 "../../../src/plugins/zeal-plugin.vala"
				_tmp13_ = json_node_type_name (_tmp12_);
#line 232 "../../../src/plugins/zeal-plugin.vala"
				_tmp14_ = g_error_new (JSON_PARSER_ERROR, JSON_PARSER_ERROR_PARSE, "Unexpected element type %s", _tmp13_);
#line 232 "../../../src/plugins/zeal-plugin.vala"
				_inner_error0_ = _tmp14_;
#line 232 "../../../src/plugins/zeal-plugin.vala"
				__vala_JsonNode_free0 (node);
#line 232 "../../../src/plugins/zeal-plugin.vala"
				_g_object_unref0 (parser);
#line 1981 "zeal-plugin.c"
				goto __catch0_g_error;
			}
#line 234 "../../../src/plugins/zeal-plugin.vala"
			_tmp15_ = node;
#line 234 "../../../src/plugins/zeal-plugin.vala"
			_tmp16_ = json_node_get_object (_tmp15_);
#line 234 "../../../src/plugins/zeal-plugin.vala"
			obj = _tmp16_;
#line 235 "../../../src/plugins/zeal-plugin.vala"
			_tmp17_ = obj;
#line 235 "../../../src/plugins/zeal-plugin.vala"
			_tmp18_ = json_object_get_members (_tmp17_);
#line 1994 "zeal-plugin.c"
			{
				GList* name_collection = NULL;
				GList* name_it = NULL;
#line 235 "../../../src/plugins/zeal-plugin.vala"
				name_collection = _tmp18_;
#line 235 "../../../src/plugins/zeal-plugin.vala"
				for (name_it = name_collection; name_it != NULL; name_it = name_it->next) {
#line 2002 "zeal-plugin.c"
					const gchar* name = NULL;
#line 235 "../../../src/plugins/zeal-plugin.vala"
					name = (const gchar*) name_it->data;
#line 2006 "zeal-plugin.c"
					{
						const gchar* _tmp19_;
						const gchar* _tmp20_;
						GQuark _tmp22_ = 0U;
#line 237 "../../../src/plugins/zeal-plugin.vala"
						static GQuark _tmp21_label0 = 0;
#line 237 "../../../src/plugins/zeal-plugin.vala"
						static GQuark _tmp21_label1 = 0;
#line 237 "../../../src/plugins/zeal-plugin.vala"
						_tmp19_ = name;
#line 237 "../../../src/plugins/zeal-plugin.vala"
						_tmp20_ = _tmp19_;
#line 237 "../../../src/plugins/zeal-plugin.vala"
						_tmp22_ = (NULL == _tmp20_) ? 0 : g_quark_from_string (_tmp20_);
#line 237 "../../../src/plugins/zeal-plugin.vala"
						if (_tmp22_ == ((0 != _tmp21_label0) ? _tmp21_label0 : (_tmp21_label0 = g_quark_from_static_string ("version")))) {
#line 237 "../../../src/plugins/zeal-plugin.vala"
							switch (0) {
#line 2025 "zeal-plugin.c"
								default:
								{
									JsonNode* item = NULL;
									JsonObject* _tmp23_;
									const gchar* _tmp24_;
									JsonNode* _tmp25_;
									JsonNode* _tmp26_;
									JsonObject* _tmp30_;
									const gchar* _tmp31_;
									gchar* _tmp32_;
#line 240 "../../../src/plugins/zeal-plugin.vala"
									_tmp23_ = obj;
#line 240 "../../../src/plugins/zeal-plugin.vala"
									_tmp24_ = name;
#line 240 "../../../src/plugins/zeal-plugin.vala"
									_tmp25_ = json_object_get_member (_tmp23_, _tmp24_);
#line 240 "../../../src/plugins/zeal-plugin.vala"
									item = _tmp25_;
#line 241 "../../../src/plugins/zeal-plugin.vala"
									_tmp26_ = item;
#line 241 "../../../src/plugins/zeal-plugin.vala"
									if (json_node_get_node_type (_tmp26_) != JSON_NODE_VALUE) {
#line 2048 "zeal-plugin.c"
										JsonNode* _tmp27_;
										const gchar* _tmp28_;
										GError* _tmp29_;
#line 242 "../../../src/plugins/zeal-plugin.vala"
										_tmp27_ = item;
#line 242 "../../../src/plugins/zeal-plugin.vala"
										_tmp28_ = json_node_type_name (_tmp27_);
#line 242 "../../../src/plugins/zeal-plugin.vala"
										_tmp29_ = g_error_new (JSON_PARSER_ERROR, JSON_PARSER_ERROR_PARSE, "Unexpected element type %s", _tmp28_);
#line 242 "../../../src/plugins/zeal-plugin.vala"
										_inner_error0_ = _tmp29_;
#line 242 "../../../src/plugins/zeal-plugin.vala"
										(name_collection == NULL) ? NULL : (name_collection = (g_list_free (name_collection), NULL));
#line 242 "../../../src/plugins/zeal-plugin.vala"
										__vala_JsonNode_free0 (node);
#line 242 "../../../src/plugins/zeal-plugin.vala"
										_g_object_unref0 (parser);
#line 2066 "zeal-plugin.c"
										goto __catch0_g_error;
									}
#line 243 "../../../src/plugins/zeal-plugin.vala"
									_tmp30_ = obj;
#line 243 "../../../src/plugins/zeal-plugin.vala"
									_tmp31_ = json_object_get_string_member (_tmp30_, "version");
#line 243 "../../../src/plugins/zeal-plugin.vala"
									_tmp32_ = g_strdup (_tmp31_);
#line 243 "../../../src/plugins/zeal-plugin.vala"
									_g_free0 (self->priv->version);
#line 243 "../../../src/plugins/zeal-plugin.vala"
									self->priv->version = _tmp32_;
#line 244 "../../../src/plugins/zeal-plugin.vala"
									break;
#line 2081 "zeal-plugin.c"
								}
							}
						} else if (_tmp22_ == ((0 != _tmp21_label1) ? _tmp21_label1 : (_tmp21_label1 = g_quark_from_static_string ("name")))) {
#line 237 "../../../src/plugins/zeal-plugin.vala"
							switch (0) {
#line 2087 "zeal-plugin.c"
								default:
								{
									JsonNode* item = NULL;
									JsonObject* _tmp33_;
									const gchar* _tmp34_;
									JsonNode* _tmp35_;
									JsonNode* _tmp36_;
									JsonObject* _tmp40_;
									const gchar* _tmp41_;
									gchar* _tmp42_;
#line 247 "../../../src/plugins/zeal-plugin.vala"
									_tmp33_ = obj;
#line 247 "../../../src/plugins/zeal-plugin.vala"
									_tmp34_ = name;
#line 247 "../../../src/plugins/zeal-plugin.vala"
									_tmp35_ = json_object_get_member (_tmp33_, _tmp34_);
#line 247 "../../../src/plugins/zeal-plugin.vala"
									item = _tmp35_;
#line 248 "../../../src/plugins/zeal-plugin.vala"
									_tmp36_ = item;
#line 248 "../../../src/plugins/zeal-plugin.vala"
									if (json_node_get_node_type (_tmp36_) != JSON_NODE_VALUE) {
#line 2110 "zeal-plugin.c"
										JsonNode* _tmp37_;
										const gchar* _tmp38_;
										GError* _tmp39_;
#line 249 "../../../src/plugins/zeal-plugin.vala"
										_tmp37_ = item;
#line 249 "../../../src/plugins/zeal-plugin.vala"
										_tmp38_ = json_node_type_name (_tmp37_);
#line 249 "../../../src/plugins/zeal-plugin.vala"
										_tmp39_ = g_error_new (JSON_PARSER_ERROR, JSON_PARSER_ERROR_PARSE, "Unexpected element type %s", _tmp38_);
#line 249 "../../../src/plugins/zeal-plugin.vala"
										_inner_error0_ = _tmp39_;
#line 249 "../../../src/plugins/zeal-plugin.vala"
										(name_collection == NULL) ? NULL : (name_collection = (g_list_free (name_collection), NULL));
#line 249 "../../../src/plugins/zeal-plugin.vala"
										__vala_JsonNode_free0 (node);
#line 249 "../../../src/plugins/zeal-plugin.vala"
										_g_object_unref0 (parser);
#line 2128 "zeal-plugin.c"
										goto __catch0_g_error;
									}
#line 250 "../../../src/plugins/zeal-plugin.vala"
									_tmp40_ = obj;
#line 250 "../../../src/plugins/zeal-plugin.vala"
									_tmp41_ = json_object_get_string_member (_tmp40_, "name");
#line 250 "../../../src/plugins/zeal-plugin.vala"
									_tmp42_ = g_strdup (_tmp41_);
#line 250 "../../../src/plugins/zeal-plugin.vala"
									_g_free0 (self->priv->doc_name);
#line 250 "../../../src/plugins/zeal-plugin.vala"
									self->priv->doc_name = _tmp42_;
#line 251 "../../../src/plugins/zeal-plugin.vala"
									break;
#line 2143 "zeal-plugin.c"
								}
							}
						}
					}
				}
#line 235 "../../../src/plugins/zeal-plugin.vala"
				(name_collection == NULL) ? NULL : (name_collection = (g_list_free (name_collection), NULL));
#line 2151 "zeal-plugin.c"
			}
#line 227 "../../../src/plugins/zeal-plugin.vala"
			__vala_JsonNode_free0 (node);
#line 2155 "zeal-plugin.c"
		} else {
			const gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			GError* _tmp46_;
			GError* _tmp47_;
#line 257 "../../../src/plugins/zeal-plugin.vala"
			_tmp43_ = self->priv->_doc_path;
#line 257 "../../../src/plugins/zeal-plugin.vala"
			_tmp44_ = g_strconcat (_tmp43_, "/meta.json", NULL);
#line 257 "../../../src/plugins/zeal-plugin.vala"
			_tmp45_ = _tmp44_;
#line 257 "../../../src/plugins/zeal-plugin.vala"
			_tmp46_ = g_error_new (JSON_PARSER_ERROR, JSON_PARSER_ERROR_PARSE, "Unable to parse data form %s", _tmp45_);
#line 257 "../../../src/plugins/zeal-plugin.vala"
			_tmp47_ = _tmp46_;
#line 257 "../../../src/plugins/zeal-plugin.vala"
			_g_free0 (_tmp45_);
#line 257 "../../../src/plugins/zeal-plugin.vala"
			_inner_error0_ = _tmp47_;
#line 257 "../../../src/plugins/zeal-plugin.vala"
			_g_object_unref0 (parser);
#line 2178 "zeal-plugin.c"
			goto __catch0_g_error;
		}
#line 222 "../../../src/plugins/zeal-plugin.vala"
		_g_object_unref0 (parser);
#line 2183 "zeal-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp48_;
		const gchar* _tmp49_;
#line 222 "../../../src/plugins/zeal-plugin.vala"
		e = _inner_error0_;
#line 222 "../../../src/plugins/zeal-plugin.vala"
		_inner_error0_ = NULL;
#line 262 "../../../src/plugins/zeal-plugin.vala"
		_tmp48_ = e;
#line 262 "../../../src/plugins/zeal-plugin.vala"
		_tmp49_ = _tmp48_->message;
#line 262 "../../../src/plugins/zeal-plugin.vala"
		g_warning ("zeal-plugin.vala:262: %s", _tmp49_);
#line 222 "../../../src/plugins/zeal-plugin.vala"
		_g_error_free0 (e);
#line 2203 "zeal-plugin.c"
	}
	__finally0:
#line 222 "../../../src/plugins/zeal-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 222 "../../../src/plugins/zeal-plugin.vala"
		_g_free0 (data);
#line 222 "../../../src/plugins/zeal-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 222 "../../../src/plugins/zeal-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 222 "../../../src/plugins/zeal-plugin.vala"
		return;
#line 2216 "zeal-plugin.c"
	}
#line 218 "../../../src/plugins/zeal-plugin.vala"
	_g_free0 (data);
#line 2220 "zeal-plugin.c"
}

static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexCompileFlags compile_flags)
{
#line 269 "../../../src/plugins/zeal-plugin.vala"
	if (g_once_init_enter ((volatile gsize*) re)) {
#line 269 "../../../src/plugins/zeal-plugin.vala"
		GRegex* val = g_regex_new (pattern, compile_flags, 0, NULL);
#line 269 "../../../src/plugins/zeal-plugin.vala"
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
#line 2234 "zeal-plugin.c"
	}
#line 269 "../../../src/plugins/zeal-plugin.vala"
	return *re;
#line 2238 "zeal-plugin.c"
}

static gpointer
_g_regex_ref0 (gpointer self)
{
#line 269 "../../../src/plugins/zeal-plugin.vala"
	return self ? g_regex_ref (self) : NULL;
#line 2246 "zeal-plugin.c"
}

static void
synapse_zeal_doc_parse_doc_bundle (SynapseZealDoc* self)
{
	gchar* contents = NULL;
	GRegex* exp = NULL;
	GRegex* _tmp0_;
	GError* _inner_error0_ = NULL;
#line 266 "../../../src/plugins/zeal-plugin.vala"
	g_return_if_fail (self != NULL);
#line 269 "../../../src/plugins/zeal-plugin.vala"
	_tmp0_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_0, "\\<key\\>([a-zA-Z0-9 _-]+)\\<\\/key\\>[\\n\\t ]*\\<string\\>([a-zA-Z0-9\\. _-]+)\\<\\/string\\>", 0));
#line 269 "../../../src/plugins/zeal-plugin.vala"
	exp = _tmp0_;
#line 2262 "zeal-plugin.c"
	{
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
#line 273 "../../../src/plugins/zeal-plugin.vala"
		_tmp1_ = self->priv->_doc_path;
#line 273 "../../../src/plugins/zeal-plugin.vala"
		_tmp2_ = g_strconcat (_tmp1_, "/Contents/Info.plist", NULL);
#line 273 "../../../src/plugins/zeal-plugin.vala"
		_tmp3_ = _tmp2_;
#line 273 "../../../src/plugins/zeal-plugin.vala"
		g_file_get_contents (_tmp3_, &_tmp4_, NULL, &_inner_error0_);
#line 273 "../../../src/plugins/zeal-plugin.vala"
		_g_free0 (contents);
#line 273 "../../../src/plugins/zeal-plugin.vala"
		contents = _tmp4_;
#line 273 "../../../src/plugins/zeal-plugin.vala"
		_g_free0 (_tmp3_);
#line 273 "../../../src/plugins/zeal-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2284 "zeal-plugin.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 271 "../../../src/plugins/zeal-plugin.vala"
		e = _inner_error0_;
#line 271 "../../../src/plugins/zeal-plugin.vala"
		_inner_error0_ = NULL;
#line 277 "../../../src/plugins/zeal-plugin.vala"
		_tmp5_ = e;
#line 277 "../../../src/plugins/zeal-plugin.vala"
		_tmp6_ = _tmp5_->message;
#line 277 "../../../src/plugins/zeal-plugin.vala"
		g_warning ("zeal-plugin.vala:277: Unable to read file: %s", _tmp6_);
#line 271 "../../../src/plugins/zeal-plugin.vala"
		_g_error_free0 (e);
#line 2306 "zeal-plugin.c"
	}
	__finally0:
#line 271 "../../../src/plugins/zeal-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 271 "../../../src/plugins/zeal-plugin.vala"
		_g_regex_unref0 (exp);
#line 271 "../../../src/plugins/zeal-plugin.vala"
		_g_free0 (contents);
#line 271 "../../../src/plugins/zeal-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 271 "../../../src/plugins/zeal-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 271 "../../../src/plugins/zeal-plugin.vala"
		return;
#line 2321 "zeal-plugin.c"
	}
	{
		GMatchInfo* mi = NULL;
		{
			GRegex* _tmp7_;
			const gchar* _tmp8_;
			GMatchInfo* _tmp9_ = NULL;
			gboolean _tmp10_ = FALSE;
#line 283 "../../../src/plugins/zeal-plugin.vala"
			_tmp7_ = exp;
#line 283 "../../../src/plugins/zeal-plugin.vala"
			_tmp8_ = contents;
#line 283 "../../../src/plugins/zeal-plugin.vala"
			g_regex_match (_tmp7_, _tmp8_, 0, &_tmp9_);
#line 283 "../../../src/plugins/zeal-plugin.vala"
			_g_match_info_unref0 (mi);
#line 283 "../../../src/plugins/zeal-plugin.vala"
			mi = _tmp9_;
#line 283 "../../../src/plugins/zeal-plugin.vala"
			_tmp10_ = TRUE;
#line 283 "../../../src/plugins/zeal-plugin.vala"
			while (TRUE) {
#line 2344 "zeal-plugin.c"
				GMatchInfo* _tmp12_;
				GMatchInfo* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				GQuark _tmp17_ = 0U;
#line 285 "../../../src/plugins/zeal-plugin.vala"
				static GQuark _tmp16_label0 = 0;
#line 285 "../../../src/plugins/zeal-plugin.vala"
				static GQuark _tmp16_label1 = 0;
#line 283 "../../../src/plugins/zeal-plugin.vala"
				if (!_tmp10_) {
#line 2356 "zeal-plugin.c"
					GMatchInfo* _tmp11_;
#line 283 "../../../src/plugins/zeal-plugin.vala"
					_tmp11_ = mi;
#line 283 "../../../src/plugins/zeal-plugin.vala"
					g_match_info_next (_tmp11_, &_inner_error0_);
#line 283 "../../../src/plugins/zeal-plugin.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 283 "../../../src/plugins/zeal-plugin.vala"
						_g_match_info_unref0 (mi);
#line 2366 "zeal-plugin.c"
						goto __catch1_g_error;
					}
				}
#line 283 "../../../src/plugins/zeal-plugin.vala"
				_tmp10_ = FALSE;
#line 283 "../../../src/plugins/zeal-plugin.vala"
				_tmp12_ = mi;
#line 283 "../../../src/plugins/zeal-plugin.vala"
				if (!g_match_info_matches (_tmp12_)) {
#line 283 "../../../src/plugins/zeal-plugin.vala"
					break;
#line 2378 "zeal-plugin.c"
				}
#line 285 "../../../src/plugins/zeal-plugin.vala"
				_tmp13_ = mi;
#line 285 "../../../src/plugins/zeal-plugin.vala"
				_tmp14_ = g_match_info_fetch (_tmp13_, 1);
#line 285 "../../../src/plugins/zeal-plugin.vala"
				_tmp15_ = _tmp14_;
#line 285 "../../../src/plugins/zeal-plugin.vala"
				_tmp17_ = (NULL == _tmp15_) ? 0 : g_quark_from_string (_tmp15_);
#line 285 "../../../src/plugins/zeal-plugin.vala"
				g_free (_tmp15_);
#line 285 "../../../src/plugins/zeal-plugin.vala"
				if (_tmp17_ == ((0 != _tmp16_label0) ? _tmp16_label0 : (_tmp16_label0 = g_quark_from_static_string ("CFBundleIdentifier")))) {
#line 285 "../../../src/plugins/zeal-plugin.vala"
					switch (0) {
#line 2394 "zeal-plugin.c"
						default:
						{
							GMatchInfo* _tmp18_;
							gchar* _tmp19_;
							gchar* _tmp20_;
							gchar* _tmp21_;
#line 288 "../../../src/plugins/zeal-plugin.vala"
							_tmp18_ = mi;
#line 288 "../../../src/plugins/zeal-plugin.vala"
							_tmp19_ = g_match_info_fetch (_tmp18_, 2);
#line 288 "../../../src/plugins/zeal-plugin.vala"
							_tmp20_ = _tmp19_;
#line 288 "../../../src/plugins/zeal-plugin.vala"
							_tmp21_ = g_utf8_strdown (_tmp20_, (gssize) -1);
#line 288 "../../../src/plugins/zeal-plugin.vala"
							_g_free0 (self->scf_bundle_identifier);
#line 288 "../../../src/plugins/zeal-plugin.vala"
							self->scf_bundle_identifier = _tmp21_;
#line 288 "../../../src/plugins/zeal-plugin.vala"
							_g_free0 (_tmp20_);
#line 289 "../../../src/plugins/zeal-plugin.vala"
							break;
#line 2417 "zeal-plugin.c"
						}
					}
				} else if (_tmp17_ == ((0 != _tmp16_label1) ? _tmp16_label1 : (_tmp16_label1 = g_quark_from_static_string ("CFBundleName")))) {
#line 285 "../../../src/plugins/zeal-plugin.vala"
					switch (0) {
#line 2423 "zeal-plugin.c"
						default:
						{
							GMatchInfo* _tmp22_;
							gchar* _tmp23_;
							gchar* _tmp24_;
							gchar* _tmp25_;
#line 291 "../../../src/plugins/zeal-plugin.vala"
							_tmp22_ = mi;
#line 291 "../../../src/plugins/zeal-plugin.vala"
							_tmp23_ = g_match_info_fetch (_tmp22_, 2);
#line 291 "../../../src/plugins/zeal-plugin.vala"
							_tmp24_ = _tmp23_;
#line 291 "../../../src/plugins/zeal-plugin.vala"
							_tmp25_ = g_utf8_strdown (_tmp24_, (gssize) -1);
#line 291 "../../../src/plugins/zeal-plugin.vala"
							_g_free0 (self->scf_bundle_name);
#line 291 "../../../src/plugins/zeal-plugin.vala"
							self->scf_bundle_name = _tmp25_;
#line 291 "../../../src/plugins/zeal-plugin.vala"
							_g_free0 (_tmp24_);
#line 292 "../../../src/plugins/zeal-plugin.vala"
							break;
#line 2446 "zeal-plugin.c"
						}
					}
				}
			}
		}
#line 280 "../../../src/plugins/zeal-plugin.vala"
		_g_match_info_unref0 (mi);
#line 2454 "zeal-plugin.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp26_;
		const gchar* _tmp27_;
#line 280 "../../../src/plugins/zeal-plugin.vala"
		e = _inner_error0_;
#line 280 "../../../src/plugins/zeal-plugin.vala"
		_inner_error0_ = NULL;
#line 298 "../../../src/plugins/zeal-plugin.vala"
		_tmp26_ = e;
#line 298 "../../../src/plugins/zeal-plugin.vala"
		_tmp27_ = _tmp26_->message;
#line 298 "../../../src/plugins/zeal-plugin.vala"
		g_warning ("zeal-plugin.vala:298: Regex failed: %s", _tmp27_);
#line 280 "../../../src/plugins/zeal-plugin.vala"
		_g_error_free0 (e);
#line 2474 "zeal-plugin.c"
	}
	__finally1:
#line 280 "../../../src/plugins/zeal-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 280 "../../../src/plugins/zeal-plugin.vala"
		_g_regex_unref0 (exp);
#line 280 "../../../src/plugins/zeal-plugin.vala"
		_g_free0 (contents);
#line 280 "../../../src/plugins/zeal-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 280 "../../../src/plugins/zeal-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 280 "../../../src/plugins/zeal-plugin.vala"
		return;
#line 2489 "zeal-plugin.c"
	}
#line 266 "../../../src/plugins/zeal-plugin.vala"
	_g_regex_unref0 (exp);
#line 266 "../../../src/plugins/zeal-plugin.vala"
	_g_free0 (contents);
#line 2495 "zeal-plugin.c"
}

const gchar*
synapse_zeal_doc_get_doc_path (SynapseZealDoc* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 154 "../../../src/plugins/zeal-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 154 "../../../src/plugins/zeal-plugin.vala"
	_tmp0_ = self->priv->_doc_path;
#line 154 "../../../src/plugins/zeal-plugin.vala"
	result = _tmp0_;
#line 154 "../../../src/plugins/zeal-plugin.vala"
	return result;
#line 2511 "zeal-plugin.c"
}

static void
synapse_zeal_doc_set_doc_path (SynapseZealDoc* self,
                               const gchar* value)
{
	gchar* old_value;
#line 154 "../../../src/plugins/zeal-plugin.vala"
	g_return_if_fail (self != NULL);
#line 154 "../../../src/plugins/zeal-plugin.vala"
	old_value = synapse_zeal_doc_get_doc_path (self);
#line 154 "../../../src/plugins/zeal-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2525 "zeal-plugin.c"
		gchar* _tmp0_;
#line 154 "../../../src/plugins/zeal-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 154 "../../../src/plugins/zeal-plugin.vala"
		_g_free0 (self->priv->_doc_path);
#line 154 "../../../src/plugins/zeal-plugin.vala"
		self->priv->_doc_path = _tmp0_;
#line 154 "../../../src/plugins/zeal-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_zeal_doc_properties[SYNAPSE_ZEAL_DOC_DOC_PATH_PROPERTY]);
#line 2535 "zeal-plugin.c"
	}
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
#line 1200 "glib-2.0.vapi"
	if (separator == NULL) {
#line 1201 "glib-2.0.vapi"
		separator = "";
#line 2550 "zeal-plugin.c"
	}
#line 1203 "glib-2.0.vapi"
	if (str_array != NULL) {
#line 2554 "zeal-plugin.c"
		gboolean _tmp1_ = FALSE;
#line 1203 "glib-2.0.vapi"
		if (str_array_length1 > 0) {
#line 1203 "glib-2.0.vapi"
			_tmp1_ = TRUE;
#line 2560 "zeal-plugin.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 1203 "glib-2.0.vapi"
			if (str_array_length1 == -1) {
#line 2565 "zeal-plugin.c"
				const gchar* _tmp3_;
#line 1203 "glib-2.0.vapi"
				_tmp3_ = str_array[0];
#line 1203 "glib-2.0.vapi"
				_tmp2_ = _tmp3_ != NULL;
#line 2571 "zeal-plugin.c"
			} else {
#line 1203 "glib-2.0.vapi"
				_tmp2_ = FALSE;
#line 2575 "zeal-plugin.c"
			}
#line 1203 "glib-2.0.vapi"
			_tmp1_ = _tmp2_;
#line 2579 "zeal-plugin.c"
		}
#line 1203 "glib-2.0.vapi"
		_tmp0_ = _tmp1_;
#line 2583 "zeal-plugin.c"
	} else {
#line 1203 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 2587 "zeal-plugin.c"
	}
#line 1203 "glib-2.0.vapi"
	if (_tmp0_) {
#line 2591 "zeal-plugin.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
#line 1205 "glib-2.0.vapi"
		len = (gsize) 1;
#line 2605 "zeal-plugin.c"
		{
			gboolean _tmp4_ = FALSE;
#line 1206 "glib-2.0.vapi"
			i = 0;
#line 1206 "glib-2.0.vapi"
			_tmp4_ = TRUE;
#line 1206 "glib-2.0.vapi"
			while (TRUE) {
#line 2614 "zeal-plugin.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
#line 1206 "glib-2.0.vapi"
				if (!_tmp4_) {
#line 2621 "zeal-plugin.c"
					gint _tmp5_;
#line 1206 "glib-2.0.vapi"
					_tmp5_ = i;
#line 1206 "glib-2.0.vapi"
					i = _tmp5_ + 1;
#line 2627 "zeal-plugin.c"
				}
#line 1206 "glib-2.0.vapi"
				_tmp4_ = FALSE;
#line 1206 "glib-2.0.vapi"
				if (str_array_length1 != -1) {
#line 1206 "glib-2.0.vapi"
					_tmp7_ = i < str_array_length1;
#line 2635 "zeal-plugin.c"
				} else {
#line 1206 "glib-2.0.vapi"
					_tmp7_ = FALSE;
#line 2639 "zeal-plugin.c"
				}
#line 1206 "glib-2.0.vapi"
				if (_tmp7_) {
#line 1206 "glib-2.0.vapi"
					_tmp6_ = TRUE;
#line 2645 "zeal-plugin.c"
				} else {
					gboolean _tmp8_ = FALSE;
#line 1206 "glib-2.0.vapi"
					if (str_array_length1 == -1) {
#line 2650 "zeal-plugin.c"
						const gchar* _tmp9_;
#line 1206 "glib-2.0.vapi"
						_tmp9_ = str_array[i];
#line 1206 "glib-2.0.vapi"
						_tmp8_ = _tmp9_ != NULL;
#line 2656 "zeal-plugin.c"
					} else {
#line 1206 "glib-2.0.vapi"
						_tmp8_ = FALSE;
#line 2660 "zeal-plugin.c"
					}
#line 1206 "glib-2.0.vapi"
					_tmp6_ = _tmp8_;
#line 2664 "zeal-plugin.c"
				}
#line 1206 "glib-2.0.vapi"
				if (!_tmp6_) {
#line 1206 "glib-2.0.vapi"
					break;
#line 2670 "zeal-plugin.c"
				}
#line 1207 "glib-2.0.vapi"
				_tmp11_ = str_array[i];
#line 1207 "glib-2.0.vapi"
				if (_tmp11_ != NULL) {
#line 2676 "zeal-plugin.c"
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
#line 1207 "glib-2.0.vapi"
					_tmp12_ = str_array[i];
#line 1207 "glib-2.0.vapi"
					_tmp13_ = strlen ((const gchar*) _tmp12_);
#line 1207 "glib-2.0.vapi"
					_tmp14_ = _tmp13_;
#line 1207 "glib-2.0.vapi"
					_tmp10_ = _tmp14_;
#line 2688 "zeal-plugin.c"
				} else {
#line 1207 "glib-2.0.vapi"
					_tmp10_ = 0;
#line 2692 "zeal-plugin.c"
				}
#line 1207 "glib-2.0.vapi"
				len += (gsize) _tmp10_;
#line 2696 "zeal-plugin.c"
			}
		}
#line 1209 "glib-2.0.vapi"
		if (i == 0) {
#line 2701 "zeal-plugin.c"
			gchar* _tmp15_;
#line 1210 "glib-2.0.vapi"
			_tmp15_ = g_strdup ("");
#line 1210 "glib-2.0.vapi"
			result = _tmp15_;
#line 1210 "glib-2.0.vapi"
			return result;
#line 2709 "zeal-plugin.c"
		}
#line 1212 "glib-2.0.vapi"
		str_array_length1 = i;
#line 1213 "glib-2.0.vapi"
		_tmp16_ = strlen ((const gchar*) separator);
#line 1213 "glib-2.0.vapi"
		_tmp17_ = _tmp16_;
#line 1213 "glib-2.0.vapi"
		len += (gsize) (_tmp17_ * (i - 1));
#line 1215 "glib-2.0.vapi"
		_tmp18_ = g_malloc (len);
#line 1215 "glib-2.0.vapi"
		res = _tmp18_;
#line 1216 "glib-2.0.vapi"
		_tmp19_ = res;
#line 1216 "glib-2.0.vapi"
		_tmp20_ = str_array[0];
#line 1216 "glib-2.0.vapi"
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
#line 1216 "glib-2.0.vapi"
		ptr = _tmp21_;
#line 2731 "zeal-plugin.c"
		{
			gboolean _tmp22_ = FALSE;
#line 1217 "glib-2.0.vapi"
			i = 1;
#line 1217 "glib-2.0.vapi"
			_tmp22_ = TRUE;
#line 1217 "glib-2.0.vapi"
			while (TRUE) {
#line 2740 "zeal-plugin.c"
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
#line 1217 "glib-2.0.vapi"
				if (!_tmp22_) {
#line 2749 "zeal-plugin.c"
					gint _tmp23_;
#line 1217 "glib-2.0.vapi"
					_tmp23_ = i;
#line 1217 "glib-2.0.vapi"
					i = _tmp23_ + 1;
#line 2755 "zeal-plugin.c"
				}
#line 1217 "glib-2.0.vapi"
				_tmp22_ = FALSE;
#line 1217 "glib-2.0.vapi"
				if (!(i < str_array_length1)) {
#line 1217 "glib-2.0.vapi"
					break;
#line 2763 "zeal-plugin.c"
				}
#line 1218 "glib-2.0.vapi"
				_tmp24_ = ptr;
#line 1218 "glib-2.0.vapi"
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
#line 1218 "glib-2.0.vapi"
				ptr = _tmp25_;
#line 1219 "glib-2.0.vapi"
				_tmp27_ = str_array[i];
#line 1219 "glib-2.0.vapi"
				if (_tmp27_ != NULL) {
#line 2775 "zeal-plugin.c"
					const gchar* _tmp28_;
#line 1219 "glib-2.0.vapi"
					_tmp28_ = str_array[i];
#line 1219 "glib-2.0.vapi"
					_tmp26_ = (const gchar*) _tmp28_;
#line 2781 "zeal-plugin.c"
				} else {
#line 1219 "glib-2.0.vapi"
					_tmp26_ = "";
#line 2785 "zeal-plugin.c"
				}
#line 1219 "glib-2.0.vapi"
				_tmp29_ = ptr;
#line 1219 "glib-2.0.vapi"
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
#line 1219 "glib-2.0.vapi"
				ptr = _tmp30_;
#line 2793 "zeal-plugin.c"
			}
		}
#line 1222 "glib-2.0.vapi"
		_tmp31_ = res;
#line 1222 "glib-2.0.vapi"
		res = NULL;
#line 1222 "glib-2.0.vapi"
		result = (gchar*) _tmp31_;
#line 1222 "glib-2.0.vapi"
		return result;
#line 2804 "zeal-plugin.c"
	} else {
		gchar* _tmp32_;
#line 1224 "glib-2.0.vapi"
		_tmp32_ = g_strdup ("");
#line 1224 "glib-2.0.vapi"
		result = _tmp32_;
#line 1224 "glib-2.0.vapi"
		return result;
#line 2813 "zeal-plugin.c"
	}
}

static GObject *
synapse_zeal_doc_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseZealDoc * self;
	GError* _inner_error0_ = NULL;
#line 174 "../../../src/plugins/zeal-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_zeal_doc_parent_class);
#line 174 "../../../src/plugins/zeal-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 174 "../../../src/plugins/zeal-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_ZEAL_DOC, SynapseZealDoc);
#line 176 "../../../src/plugins/zeal-plugin.vala"
	synapse_zeal_doc_parse_doc_name (self);
#line 177 "../../../src/plugins/zeal-plugin.vala"
	synapse_zeal_doc_parse_doc_bundle (self);
#line 2836 "zeal-plugin.c"
	{
		GRegex* _tmp0_ = NULL;
		const gchar* _tmp1_;
		gchar** _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		GRegex* _tmp11_;
#line 181 "../../../src/plugins/zeal-plugin.vala"
		_tmp1_ = self->scf_bundle_name;
#line 181 "../../../src/plugins/zeal-plugin.vala"
		_tmp3_ = _tmp2_ = g_strsplit_set (_tmp1_, "_ ", 0);
#line 181 "../../../src/plugins/zeal-plugin.vala"
		_tmp4_ = _tmp3_;
#line 181 "../../../src/plugins/zeal-plugin.vala"
		_tmp4__length1 = _vala_array_length (_tmp2_);
#line 181 "../../../src/plugins/zeal-plugin.vala"
		_tmp5_ = _vala_g_strjoinv ("|", _tmp4_, (gint) _vala_array_length (_tmp2_));
#line 181 "../../../src/plugins/zeal-plugin.vala"
		_tmp6_ = _tmp5_;
#line 181 "../../../src/plugins/zeal-plugin.vala"
		_tmp7_ = g_strdup_printf ("^(%s)[ :]+([a-z0-9 -_.:;,]*)", _tmp6_);
#line 181 "../../../src/plugins/zeal-plugin.vala"
		_tmp8_ = _tmp7_;
#line 181 "../../../src/plugins/zeal-plugin.vala"
		_tmp9_ = g_regex_new (_tmp8_, G_REGEX_OPTIMIZE, 0, &_inner_error0_);
#line 181 "../../../src/plugins/zeal-plugin.vala"
		_tmp10_ = _tmp9_;
#line 181 "../../../src/plugins/zeal-plugin.vala"
		_g_free0 (_tmp8_);
#line 181 "../../../src/plugins/zeal-plugin.vala"
		_g_free0 (_tmp6_);
#line 181 "../../../src/plugins/zeal-plugin.vala"
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
#line 181 "../../../src/plugins/zeal-plugin.vala"
		_tmp0_ = _tmp10_;
#line 181 "../../../src/plugins/zeal-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 181 "../../../src/plugins/zeal-plugin.vala"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 2883 "zeal-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 181 "../../../src/plugins/zeal-plugin.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 181 "../../../src/plugins/zeal-plugin.vala"
			g_clear_error (&_inner_error0_);
#line 2890 "zeal-plugin.c"
		}
#line 181 "../../../src/plugins/zeal-plugin.vala"
		_tmp11_ = _tmp0_;
#line 181 "../../../src/plugins/zeal-plugin.vala"
		_tmp0_ = NULL;
#line 181 "../../../src/plugins/zeal-plugin.vala"
		_g_regex_unref0 (self->regex);
#line 181 "../../../src/plugins/zeal-plugin.vala"
		self->regex = _tmp11_;
#line 179 "../../../src/plugins/zeal-plugin.vala"
		_g_regex_unref0 (_tmp0_);
#line 2902 "zeal-plugin.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
#line 179 "../../../src/plugins/zeal-plugin.vala"
		e = _inner_error0_;
#line 179 "../../../src/plugins/zeal-plugin.vala"
		_inner_error0_ = NULL;
#line 185 "../../../src/plugins/zeal-plugin.vala"
		_g_regex_unref0 (self->regex);
#line 185 "../../../src/plugins/zeal-plugin.vala"
		self->regex = NULL;
#line 186 "../../../src/plugins/zeal-plugin.vala"
		_tmp12_ = e;
#line 186 "../../../src/plugins/zeal-plugin.vala"
		_tmp13_ = _tmp12_->message;
#line 186 "../../../src/plugins/zeal-plugin.vala"
		g_warning ("zeal-plugin.vala:186: regex error %s", _tmp13_);
#line 179 "../../../src/plugins/zeal-plugin.vala"
		_g_error_free0 (e);
#line 2926 "zeal-plugin.c"
	}
	__finally0:
#line 179 "../../../src/plugins/zeal-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 179 "../../../src/plugins/zeal-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 179 "../../../src/plugins/zeal-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 2935 "zeal-plugin.c"
	}
#line 174 "../../../src/plugins/zeal-plugin.vala"
	return obj;
#line 2939 "zeal-plugin.c"
}

static void
synapse_zeal_doc_class_init (SynapseZealDocClass * klass,
                             gpointer klass_data)
{
#line 152 "../../../src/plugins/zeal-plugin.vala"
	synapse_zeal_doc_parent_class = g_type_class_peek_parent (klass);
#line 152 "../../../src/plugins/zeal-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseZealDoc_private_offset);
#line 152 "../../../src/plugins/zeal-plugin.vala"
	((SynapseActionMatchClass *) klass)->do_action = (void (*) (SynapseActionMatch*)) synapse_zeal_doc_real_do_action;
#line 152 "../../../src/plugins/zeal-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_zeal_doc_get_property;
#line 152 "../../../src/plugins/zeal-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_zeal_doc_set_property;
#line 152 "../../../src/plugins/zeal-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_zeal_doc_constructor;
#line 152 "../../../src/plugins/zeal-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_zeal_doc_finalize;
#line 152 "../../../src/plugins/zeal-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEAL_DOC_DOC_PATH_PROPERTY, synapse_zeal_doc_properties[SYNAPSE_ZEAL_DOC_DOC_PATH_PROPERTY] = g_param_spec_string ("doc-path", "doc-path", "doc-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 2962 "zeal-plugin.c"
}

static void
synapse_zeal_doc_instance_init (SynapseZealDoc * self,
                                gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 152 "../../../src/plugins/zeal-plugin.vala"
	self->priv = synapse_zeal_doc_get_instance_private (self);
#line 156 "../../../src/plugins/zeal-plugin.vala"
	_tmp0_ = g_strdup ("");
#line 156 "../../../src/plugins/zeal-plugin.vala"
	self->priv->query = _tmp0_;
#line 157 "../../../src/plugins/zeal-plugin.vala"
	_tmp1_ = g_strdup ("");
#line 157 "../../../src/plugins/zeal-plugin.vala"
	self->priv->doc_name = _tmp1_;
#line 158 "../../../src/plugins/zeal-plugin.vala"
	_tmp2_ = g_strdup ("");
#line 158 "../../../src/plugins/zeal-plugin.vala"
	self->scf_bundle_identifier = _tmp2_;
#line 159 "../../../src/plugins/zeal-plugin.vala"
	_tmp3_ = g_strdup ("");
#line 159 "../../../src/plugins/zeal-plugin.vala"
	self->scf_bundle_name = _tmp3_;
#line 2991 "zeal-plugin.c"
}

static void
synapse_zeal_doc_finalize (GObject * obj)
{
	SynapseZealDoc * self;
#line 152 "../../../src/plugins/zeal-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_ZEAL_DOC, SynapseZealDoc);
#line 154 "../../../src/plugins/zeal-plugin.vala"
	_g_free0 (self->priv->_doc_path);
#line 156 "../../../src/plugins/zeal-plugin.vala"
	_g_free0 (self->priv->query);
#line 157 "../../../src/plugins/zeal-plugin.vala"
	_g_free0 (self->priv->doc_name);
#line 158 "../../../src/plugins/zeal-plugin.vala"
	_g_free0 (self->scf_bundle_identifier);
#line 159 "../../../src/plugins/zeal-plugin.vala"
	_g_free0 (self->scf_bundle_name);
#line 160 "../../../src/plugins/zeal-plugin.vala"
	_g_regex_unref0 (self->regex);
#line 161 "../../../src/plugins/zeal-plugin.vala"
	_g_free0 (self->priv->version);
#line 152 "../../../src/plugins/zeal-plugin.vala"
	G_OBJECT_CLASS (synapse_zeal_doc_parent_class)->finalize (obj);
#line 3016 "zeal-plugin.c"
}

static GType
synapse_zeal_doc_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseZealDocClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_zeal_doc_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseZealDoc), 0, (GInstanceInitFunc) synapse_zeal_doc_instance_init, NULL };
	GType synapse_zeal_doc_type_id;
	synapse_zeal_doc_type_id = g_type_register_static (SYNAPSE_TYPE_ACTION_MATCH, "SynapseZealDoc", &g_define_type_info, 0);
	SynapseZealDoc_private_offset = g_type_add_instance_private (synapse_zeal_doc_type_id, sizeof (SynapseZealDocPrivate));
	return synapse_zeal_doc_type_id;
}

GType
synapse_zeal_doc_get_type (void)
{
	static volatile gsize synapse_zeal_doc_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_zeal_doc_type_id__volatile)) {
		GType synapse_zeal_doc_type_id;
		synapse_zeal_doc_type_id = synapse_zeal_doc_get_type_once ();
		g_once_init_leave (&synapse_zeal_doc_type_id__volatile, synapse_zeal_doc_type_id);
	}
	return synapse_zeal_doc_type_id__volatile;
}

static void
_vala_synapse_zeal_doc_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	SynapseZealDoc * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_ZEAL_DOC, SynapseZealDoc);
#line 152 "../../../src/plugins/zeal-plugin.vala"
	switch (property_id) {
#line 152 "../../../src/plugins/zeal-plugin.vala"
		case SYNAPSE_ZEAL_DOC_DOC_PATH_PROPERTY:
#line 152 "../../../src/plugins/zeal-plugin.vala"
		g_value_set_string (value, synapse_zeal_doc_get_doc_path (self));
#line 152 "../../../src/plugins/zeal-plugin.vala"
		break;
#line 3057 "zeal-plugin.c"
		default:
#line 152 "../../../src/plugins/zeal-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 152 "../../../src/plugins/zeal-plugin.vala"
		break;
#line 3063 "zeal-plugin.c"
	}
}

static void
_vala_synapse_zeal_doc_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	SynapseZealDoc * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_ZEAL_DOC, SynapseZealDoc);
#line 152 "../../../src/plugins/zeal-plugin.vala"
	switch (property_id) {
#line 152 "../../../src/plugins/zeal-plugin.vala"
		case SYNAPSE_ZEAL_DOC_DOC_PATH_PROPERTY:
#line 152 "../../../src/plugins/zeal-plugin.vala"
		synapse_zeal_doc_set_doc_path (self, g_value_get_string (value));
#line 152 "../../../src/plugins/zeal-plugin.vala"
		break;
#line 3083 "zeal-plugin.c"
		default:
#line 152 "../../../src/plugins/zeal-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 152 "../../../src/plugins/zeal-plugin.vala"
		break;
#line 3089 "zeal-plugin.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 24 "../../../src/plugins/pastebin-plugin.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 3100 "zeal-plugin.c"
		gint i;
#line 24 "../../../src/plugins/pastebin-plugin.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 24 "../../../src/plugins/pastebin-plugin.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 24 "../../../src/plugins/pastebin-plugin.vala"
				destroy_func (((gpointer*) array)[i]);
#line 3108 "zeal-plugin.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 24 "../../../src/plugins/pastebin-plugin.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 24 "../../../src/plugins/pastebin-plugin.vala"
	g_free (array);
#line 3123 "zeal-plugin.c"
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
#line 24 "../../../src/plugins/pastebin-plugin.vala"
	if (array) {
#line 24 "../../../src/plugins/pastebin-plugin.vala"
		while (((gpointer*) array)[length]) {
#line 24 "../../../src/plugins/pastebin-plugin.vala"
			length++;
#line 3137 "zeal-plugin.c"
		}
	}
#line 24 "../../../src/plugins/pastebin-plugin.vala"
	return length;
#line 3142 "zeal-plugin.c"
}

