/* icon-cache-service.c generated by valac 0.48.17, the Vala compiler
 * generated from icon-cache-service.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 * Copyright (C) 2010 Alberto Aldegheri <albyrock87+dev@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *						 Alberto Aldegheri <albyrock87+dev@gmail.com>
 *
 */

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <time.h>

#define SYNAPSE_GUI_TYPE_ICON_CACHE_SERVICE (synapse_gui_icon_cache_service_get_type ())
#define SYNAPSE_GUI_ICON_CACHE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_GUI_TYPE_ICON_CACHE_SERVICE, SynapseGuiIconCacheService))
#define SYNAPSE_GUI_ICON_CACHE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_GUI_TYPE_ICON_CACHE_SERVICE, SynapseGuiIconCacheServiceClass))
#define SYNAPSE_GUI_IS_ICON_CACHE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_GUI_TYPE_ICON_CACHE_SERVICE))
#define SYNAPSE_GUI_IS_ICON_CACHE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_GUI_TYPE_ICON_CACHE_SERVICE))
#define SYNAPSE_GUI_ICON_CACHE_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_GUI_TYPE_ICON_CACHE_SERVICE, SynapseGuiIconCacheServiceClass))

typedef struct _SynapseGuiIconCacheService SynapseGuiIconCacheService;
typedef struct _SynapseGuiIconCacheServiceClass SynapseGuiIconCacheServiceClass;
typedef struct _SynapseGuiIconCacheServicePrivate SynapseGuiIconCacheServicePrivate;

#define SYNAPSE_GUI_ICON_CACHE_SERVICE_TYPE_PIXBUF_INFO (synapse_gui_icon_cache_service_pixbuf_info_get_type ())
#define SYNAPSE_GUI_ICON_CACHE_SERVICE_PIXBUF_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_GUI_ICON_CACHE_SERVICE_TYPE_PIXBUF_INFO, SynapseGuiIconCacheServicePixbufInfo))
#define SYNAPSE_GUI_ICON_CACHE_SERVICE_PIXBUF_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_GUI_ICON_CACHE_SERVICE_TYPE_PIXBUF_INFO, SynapseGuiIconCacheServicePixbufInfoClass))
#define SYNAPSE_GUI_ICON_CACHE_SERVICE_IS_PIXBUF_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_GUI_ICON_CACHE_SERVICE_TYPE_PIXBUF_INFO))
#define SYNAPSE_GUI_ICON_CACHE_SERVICE_IS_PIXBUF_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_GUI_ICON_CACHE_SERVICE_TYPE_PIXBUF_INFO))
#define SYNAPSE_GUI_ICON_CACHE_SERVICE_PIXBUF_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_GUI_ICON_CACHE_SERVICE_TYPE_PIXBUF_INFO, SynapseGuiIconCacheServicePixbufInfoClass))

typedef struct _SynapseGuiIconCacheServicePixbufInfo SynapseGuiIconCacheServicePixbufInfo;
typedef struct _SynapseGuiIconCacheServicePixbufInfoClass SynapseGuiIconCacheServicePixbufInfoClass;
enum  {
	SYNAPSE_GUI_ICON_CACHE_SERVICE_0_PROPERTY,
	SYNAPSE_GUI_ICON_CACHE_SERVICE_NUM_PROPERTIES
};
static GParamSpec* synapse_gui_icon_cache_service_properties[SYNAPSE_GUI_ICON_CACHE_SERVICE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SynapseGuiIconCacheServicePixbufInfoPrivate SynapseGuiIconCacheServicePixbufInfoPrivate;
enum  {
	SYNAPSE_GUI_ICON_CACHE_SERVICE_PIXBUF_INFO_0_PROPERTY,
	SYNAPSE_GUI_ICON_CACHE_SERVICE_PIXBUF_INFO_PIXBUF_PROPERTY,
	SYNAPSE_GUI_ICON_CACHE_SERVICE_PIXBUF_INFO_NUM_PROPERTIES
};
static GParamSpec* synapse_gui_icon_cache_service_pixbuf_info_properties[SYNAPSE_GUI_ICON_CACHE_SERVICE_PIXBUF_INFO_NUM_PROPERTIES];

struct _SynapseGuiIconCacheService {
	GObject parent_instance;
	SynapseGuiIconCacheServicePrivate * priv;
};

struct _SynapseGuiIconCacheServiceClass {
	GObjectClass parent_class;
};

struct _SynapseGuiIconCacheServicePrivate {
	GeeMap* map;
	GtkIconTheme* theme;
};

struct _SynapseGuiIconCacheServicePixbufInfo {
	GObject parent_instance;
	SynapseGuiIconCacheServicePixbufInfoPrivate * priv;
	time_t last_time_used;
};

struct _SynapseGuiIconCacheServicePixbufInfoClass {
	GObjectClass parent_class;
};

struct _SynapseGuiIconCacheServicePixbufInfoPrivate {
	GdkPixbuf* _pixbuf;
};

static gint SynapseGuiIconCacheService_private_offset;
static gpointer synapse_gui_icon_cache_service_parent_class = NULL;
static SynapseGuiIconCacheService* synapse_gui_icon_cache_service_instance;
static SynapseGuiIconCacheService* synapse_gui_icon_cache_service_instance = NULL;
static gint SynapseGuiIconCacheServicePixbufInfo_private_offset;
static gpointer synapse_gui_icon_cache_service_pixbuf_info_parent_class = NULL;

GType synapse_gui_icon_cache_service_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseGuiIconCacheService, g_object_unref)
static GType synapse_gui_icon_cache_service_pixbuf_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynapseGuiIconCacheServicePixbufInfo, g_object_unref)
SynapseGuiIconCacheService* synapse_gui_icon_cache_service_get_default (void);
static SynapseGuiIconCacheService* synapse_gui_icon_cache_service_new (void);
static SynapseGuiIconCacheService* synapse_gui_icon_cache_service_construct (GType object_type);
void synapse_gui_icon_cache_service_clear_cache (SynapseGuiIconCacheService* self);
void synapse_gui_icon_cache_service_reduce_cache (SynapseGuiIconCacheService* self);
GdkPixbuf* synapse_gui_icon_cache_service_get_icon (SynapseGuiIconCacheService* self,
                                                    const gchar* name,
                                                    gint pixel_size);
static GdkPixbuf* synapse_gui_icon_cache_service_get_pixbuf (SynapseGuiIconCacheService* self,
                                                      const gchar* name,
                                                      gint pixel_size);
static SynapseGuiIconCacheServicePixbufInfo* synapse_gui_icon_cache_service_pixbuf_info_new (GdkPixbuf* pixbuf);
static SynapseGuiIconCacheServicePixbufInfo* synapse_gui_icon_cache_service_pixbuf_info_construct (GType object_type,
                                                                                            GdkPixbuf* pixbuf);
static GdkPixbuf* synapse_gui_icon_cache_service_pixbuf_info_get_pixbuf (SynapseGuiIconCacheServicePixbufInfo* self);
static void synapse_gui_icon_cache_service_pixbuf_info_finalize (GObject * obj);
static GType synapse_gui_icon_cache_service_pixbuf_info_get_type_once (void);
static void _vala_synapse_gui_icon_cache_service_pixbuf_info_get_property (GObject * object,
                                                                    guint property_id,
                                                                    GValue * value,
                                                                    GParamSpec * pspec);
static GObject * synapse_gui_icon_cache_service_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties);
static void _synapse_gui_icon_cache_service_clear_cache_gtk_icon_theme_changed (GtkIconTheme* _sender,
                                                                         gpointer self);
static void synapse_gui_icon_cache_service_finalize (GObject * obj);
static GType synapse_gui_icon_cache_service_get_type_once (void);

static inline gpointer
synapse_gui_icon_cache_service_get_instance_private (SynapseGuiIconCacheService* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseGuiIconCacheService_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 31 "../../../src/ui/icon-cache-service.vala"
	return self ? g_object_ref (self) : NULL;
#line 151 "icon-cache-service.c"
}

SynapseGuiIconCacheService*
synapse_gui_icon_cache_service_get_default (void)
{
	SynapseGuiIconCacheService* _tmp0_ = NULL;
	SynapseGuiIconCacheService* _tmp1_;
	SynapseGuiIconCacheService* _tmp2_;
	SynapseGuiIconCacheService* _tmp4_;
	SynapseGuiIconCacheService* result = NULL;
#line 31 "../../../src/ui/icon-cache-service.vala"
	_tmp1_ = synapse_gui_icon_cache_service_instance;
#line 31 "../../../src/ui/icon-cache-service.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 31 "../../../src/ui/icon-cache-service.vala"
	_tmp0_ = _tmp2_;
#line 31 "../../../src/ui/icon-cache-service.vala"
	if (_tmp0_ == NULL) {
#line 170 "icon-cache-service.c"
		SynapseGuiIconCacheService* _tmp3_;
#line 31 "../../../src/ui/icon-cache-service.vala"
		_tmp3_ = synapse_gui_icon_cache_service_new ();
#line 31 "../../../src/ui/icon-cache-service.vala"
		_g_object_unref0 (_tmp0_);
#line 31 "../../../src/ui/icon-cache-service.vala"
		_tmp0_ = _tmp3_;
#line 178 "icon-cache-service.c"
	}
#line 31 "../../../src/ui/icon-cache-service.vala"
	_tmp4_ = _tmp0_;
#line 31 "../../../src/ui/icon-cache-service.vala"
	_tmp0_ = NULL;
#line 31 "../../../src/ui/icon-cache-service.vala"
	result = _tmp4_;
#line 31 "../../../src/ui/icon-cache-service.vala"
	_g_object_unref0 (_tmp0_);
#line 31 "../../../src/ui/icon-cache-service.vala"
	return result;
#line 190 "icon-cache-service.c"
}

static SynapseGuiIconCacheService*
synapse_gui_icon_cache_service_construct (GType object_type)
{
	SynapseGuiIconCacheService * self = NULL;
#line 34 "../../../src/ui/icon-cache-service.vala"
	self = (SynapseGuiIconCacheService*) g_object_new (object_type, NULL);
#line 34 "../../../src/ui/icon-cache-service.vala"
	return self;
#line 201 "icon-cache-service.c"
}

static SynapseGuiIconCacheService*
synapse_gui_icon_cache_service_new (void)
{
#line 34 "../../../src/ui/icon-cache-service.vala"
	return synapse_gui_icon_cache_service_construct (SYNAPSE_GUI_TYPE_ICON_CACHE_SERVICE);
#line 209 "icon-cache-service.c"
}

void
synapse_gui_icon_cache_service_clear_cache (SynapseGuiIconCacheService* self)
{
	GeeMap* _tmp0_;
#line 67 "../../../src/ui/icon-cache-service.vala"
	g_return_if_fail (self != NULL);
#line 69 "../../../src/ui/icon-cache-service.vala"
	_tmp0_ = self->priv->map;
#line 69 "../../../src/ui/icon-cache-service.vala"
	gee_map_clear (_tmp0_);
#line 70 "../../../src/ui/icon-cache-service.vala"
	g_debug ("icon-cache-service.vala:70: Icon Cache cleared.");
#line 224 "icon-cache-service.c"
}

void
synapse_gui_icon_cache_service_reduce_cache (SynapseGuiIconCacheService* self)
{
	GeeList* keys = NULL;
	GeeArrayList* _tmp0_;
	GeeList* _tmp1_;
	GeeMap* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	gint i = 0;
	GeeList* _tmp21_;
	GeeMap* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
#line 73 "../../../src/ui/icon-cache-service.vala"
	g_return_if_fail (self != NULL);
#line 75 "../../../src/ui/icon-cache-service.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 75 "../../../src/ui/icon-cache-service.vala"
	keys = (GeeList*) _tmp0_;
#line 76 "../../../src/ui/icon-cache-service.vala"
	_tmp1_ = keys;
#line 76 "../../../src/ui/icon-cache-service.vala"
	_tmp2_ = self->priv->map;
#line 76 "../../../src/ui/icon-cache-service.vala"
	_tmp3_ = gee_map_get_keys (_tmp2_);
#line 76 "../../../src/ui/icon-cache-service.vala"
	_tmp4_ = _tmp3_;
#line 76 "../../../src/ui/icon-cache-service.vala"
	_tmp5_ = _tmp4_;
#line 76 "../../../src/ui/icon-cache-service.vala"
	gee_collection_add_all ((GeeCollection*) _tmp1_, (GeeCollection*) _tmp5_);
#line 76 "../../../src/ui/icon-cache-service.vala"
	_g_object_unref0 (_tmp5_);
#line 77 "../../../src/ui/icon-cache-service.vala"
	i = 0;
#line 264 "icon-cache-service.c"
	{
		GeeList* _key_list = NULL;
		GeeList* _tmp6_;
		GeeList* _tmp7_;
		gint _key_size = 0;
		GeeList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _key_index = 0;
#line 79 "../../../src/ui/icon-cache-service.vala"
		_tmp6_ = keys;
#line 79 "../../../src/ui/icon-cache-service.vala"
		_tmp7_ = _g_object_ref0 (_tmp6_);
#line 79 "../../../src/ui/icon-cache-service.vala"
		_key_list = _tmp7_;
#line 79 "../../../src/ui/icon-cache-service.vala"
		_tmp8_ = _key_list;
#line 79 "../../../src/ui/icon-cache-service.vala"
		_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
#line 79 "../../../src/ui/icon-cache-service.vala"
		_tmp10_ = _tmp9_;
#line 79 "../../../src/ui/icon-cache-service.vala"
		_key_size = _tmp10_;
#line 79 "../../../src/ui/icon-cache-service.vala"
		_key_index = -1;
#line 79 "../../../src/ui/icon-cache-service.vala"
		while (TRUE) {
#line 292 "icon-cache-service.c"
			gint _tmp11_;
			gint _tmp12_;
			gchar* key = NULL;
			GeeList* _tmp13_;
			gpointer _tmp14_;
			gboolean _tmp15_ = FALSE;
			const gchar* _tmp16_;
#line 79 "../../../src/ui/icon-cache-service.vala"
			_key_index = _key_index + 1;
#line 79 "../../../src/ui/icon-cache-service.vala"
			_tmp11_ = _key_index;
#line 79 "../../../src/ui/icon-cache-service.vala"
			_tmp12_ = _key_size;
#line 79 "../../../src/ui/icon-cache-service.vala"
			if (!(_tmp11_ < _tmp12_)) {
#line 79 "../../../src/ui/icon-cache-service.vala"
				break;
#line 310 "icon-cache-service.c"
			}
#line 79 "../../../src/ui/icon-cache-service.vala"
			_tmp13_ = _key_list;
#line 79 "../../../src/ui/icon-cache-service.vala"
			_tmp14_ = gee_list_get (_tmp13_, _key_index);
#line 79 "../../../src/ui/icon-cache-service.vala"
			key = (gchar*) _tmp14_;
#line 81 "../../../src/ui/icon-cache-service.vala"
			_tmp16_ = key;
#line 81 "../../../src/ui/icon-cache-service.vala"
			if (g_str_has_prefix (_tmp16_, "/")) {
#line 81 "../../../src/ui/icon-cache-service.vala"
				_tmp15_ = TRUE;
#line 324 "icon-cache-service.c"
			} else {
				const gchar* _tmp17_;
#line 81 "../../../src/ui/icon-cache-service.vala"
				_tmp17_ = key;
#line 81 "../../../src/ui/icon-cache-service.vala"
				_tmp15_ = g_str_has_prefix (_tmp17_, "~");
#line 331 "icon-cache-service.c"
			}
#line 81 "../../../src/ui/icon-cache-service.vala"
			if (_tmp15_) {
#line 335 "icon-cache-service.c"
				GeeMap* _tmp18_;
				const gchar* _tmp19_;
				gint _tmp20_;
#line 83 "../../../src/ui/icon-cache-service.vala"
				_tmp18_ = self->priv->map;
#line 83 "../../../src/ui/icon-cache-service.vala"
				_tmp19_ = key;
#line 83 "../../../src/ui/icon-cache-service.vala"
				gee_map_unset (_tmp18_, _tmp19_, NULL);
#line 84 "../../../src/ui/icon-cache-service.vala"
				_tmp20_ = i;
#line 84 "../../../src/ui/icon-cache-service.vala"
				i = _tmp20_ + 1;
#line 349 "icon-cache-service.c"
			}
#line 79 "../../../src/ui/icon-cache-service.vala"
			_g_free0 (key);
#line 353 "icon-cache-service.c"
		}
#line 79 "../../../src/ui/icon-cache-service.vala"
		_g_object_unref0 (_key_list);
#line 357 "icon-cache-service.c"
	}
#line 87 "../../../src/ui/icon-cache-service.vala"
	_tmp21_ = keys;
#line 87 "../../../src/ui/icon-cache-service.vala"
	gee_collection_clear ((GeeCollection*) _tmp21_);
#line 88 "../../../src/ui/icon-cache-service.vala"
	_tmp22_ = self->priv->map;
#line 88 "../../../src/ui/icon-cache-service.vala"
	_tmp23_ = gee_map_get_size (_tmp22_);
#line 88 "../../../src/ui/icon-cache-service.vala"
	_tmp24_ = _tmp23_;
#line 88 "../../../src/ui/icon-cache-service.vala"
	g_debug ("icon-cache-service.vala:88: Cache freed/size: %d/%d", i, _tmp24_);
#line 73 "../../../src/ui/icon-cache-service.vala"
	_g_object_unref0 (keys);
#line 373 "icon-cache-service.c"
}

GdkPixbuf*
synapse_gui_icon_cache_service_get_icon (SynapseGuiIconCacheService* self,
                                         const gchar* name,
                                         gint pixel_size)
{
	gchar* key = NULL;
	gchar* _tmp0_;
	SynapseGuiIconCacheServicePixbufInfo* info = NULL;
	GeeMap* _tmp1_;
	const gchar* _tmp2_;
	gpointer _tmp3_;
	SynapseGuiIconCacheServicePixbufInfo* _tmp4_;
	SynapseGuiIconCacheServicePixbufInfo* _tmp14_;
	GdkPixbuf* _tmp15_;
	GdkPixbuf* _tmp16_;
	GdkPixbuf* _tmp17_;
	GdkPixbuf* result = NULL;
#line 91 "../../../src/ui/icon-cache-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 91 "../../../src/ui/icon-cache-service.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 93 "../../../src/ui/icon-cache-service.vala"
	if (g_strcmp0 (name, "") == 0) {
#line 93 "../../../src/ui/icon-cache-service.vala"
		result = NULL;
#line 93 "../../../src/ui/icon-cache-service.vala"
		return result;
#line 403 "icon-cache-service.c"
	}
#line 94 "../../../src/ui/icon-cache-service.vala"
	_tmp0_ = g_strdup_printf ("%s|%d", name, pixel_size);
#line 94 "../../../src/ui/icon-cache-service.vala"
	key = _tmp0_;
#line 95 "../../../src/ui/icon-cache-service.vala"
	_tmp1_ = self->priv->map;
#line 95 "../../../src/ui/icon-cache-service.vala"
	_tmp2_ = key;
#line 95 "../../../src/ui/icon-cache-service.vala"
	_tmp3_ = gee_map_get (_tmp1_, _tmp2_);
#line 95 "../../../src/ui/icon-cache-service.vala"
	info = (SynapseGuiIconCacheServicePixbufInfo*) _tmp3_;
#line 96 "../../../src/ui/icon-cache-service.vala"
	_tmp4_ = info;
#line 96 "../../../src/ui/icon-cache-service.vala"
	if (_tmp4_ == NULL) {
#line 421 "icon-cache-service.c"
		GdkPixbuf* pixbuf = NULL;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_;
		GdkPixbuf* _tmp8_;
		GdkPixbuf* _tmp9_;
		SynapseGuiIconCacheServicePixbufInfo* _tmp10_;
		GeeMap* _tmp11_;
		const gchar* _tmp12_;
		SynapseGuiIconCacheServicePixbufInfo* _tmp13_;
#line 98 "../../../src/ui/icon-cache-service.vala"
		_tmp5_ = synapse_gui_icon_cache_service_get_pixbuf (self, name, pixel_size);
#line 98 "../../../src/ui/icon-cache-service.vala"
		pixbuf = _tmp5_;
#line 99 "../../../src/ui/icon-cache-service.vala"
		_tmp6_ = pixbuf;
#line 99 "../../../src/ui/icon-cache-service.vala"
		if (_tmp6_ == NULL) {
#line 439 "icon-cache-service.c"
			GdkPixbuf* _tmp7_;
#line 99 "../../../src/ui/icon-cache-service.vala"
			_tmp7_ = synapse_gui_icon_cache_service_get_pixbuf (self, "unknown", pixel_size);
#line 99 "../../../src/ui/icon-cache-service.vala"
			_g_object_unref0 (pixbuf);
#line 99 "../../../src/ui/icon-cache-service.vala"
			pixbuf = _tmp7_;
#line 447 "icon-cache-service.c"
		}
#line 100 "../../../src/ui/icon-cache-service.vala"
		_tmp8_ = pixbuf;
#line 100 "../../../src/ui/icon-cache-service.vala"
		if (_tmp8_ == NULL) {
#line 100 "../../../src/ui/icon-cache-service.vala"
			result = NULL;
#line 100 "../../../src/ui/icon-cache-service.vala"
			_g_object_unref0 (pixbuf);
#line 100 "../../../src/ui/icon-cache-service.vala"
			_g_object_unref0 (info);
#line 100 "../../../src/ui/icon-cache-service.vala"
			_g_free0 (key);
#line 100 "../../../src/ui/icon-cache-service.vala"
			return result;
#line 463 "icon-cache-service.c"
		}
#line 101 "../../../src/ui/icon-cache-service.vala"
		_tmp9_ = pixbuf;
#line 101 "../../../src/ui/icon-cache-service.vala"
		_tmp10_ = synapse_gui_icon_cache_service_pixbuf_info_new (_tmp9_);
#line 101 "../../../src/ui/icon-cache-service.vala"
		_g_object_unref0 (info);
#line 101 "../../../src/ui/icon-cache-service.vala"
		info = _tmp10_;
#line 102 "../../../src/ui/icon-cache-service.vala"
		_tmp11_ = self->priv->map;
#line 102 "../../../src/ui/icon-cache-service.vala"
		_tmp12_ = key;
#line 102 "../../../src/ui/icon-cache-service.vala"
		_tmp13_ = info;
#line 102 "../../../src/ui/icon-cache-service.vala"
		gee_map_set (_tmp11_, _tmp12_, _tmp13_);
#line 96 "../../../src/ui/icon-cache-service.vala"
		_g_object_unref0 (pixbuf);
#line 483 "icon-cache-service.c"
	}
#line 104 "../../../src/ui/icon-cache-service.vala"
	_tmp14_ = info;
#line 104 "../../../src/ui/icon-cache-service.vala"
	_tmp15_ = synapse_gui_icon_cache_service_pixbuf_info_get_pixbuf (_tmp14_);
#line 104 "../../../src/ui/icon-cache-service.vala"
	_tmp16_ = _tmp15_;
#line 104 "../../../src/ui/icon-cache-service.vala"
	_tmp17_ = _g_object_ref0 (_tmp16_);
#line 104 "../../../src/ui/icon-cache-service.vala"
	result = _tmp17_;
#line 104 "../../../src/ui/icon-cache-service.vala"
	_g_object_unref0 (info);
#line 104 "../../../src/ui/icon-cache-service.vala"
	_g_free0 (key);
#line 104 "../../../src/ui/icon-cache-service.vala"
	return result;
#line 501 "icon-cache-service.c"
}

static GdkPixbuf*
synapse_gui_icon_cache_service_get_pixbuf (SynapseGuiIconCacheService* self,
                                           const gchar* name,
                                           gint pixel_size)
{
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result = NULL;
#line 107 "../../../src/ui/icon-cache-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 107 "../../../src/ui/icon-cache-service.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 515 "icon-cache-service.c"
	{
		GIcon* icon = NULL;
		GIcon* _tmp0_;
		GIcon* _tmp1_;
		GtkIconInfo* iconinfo = NULL;
		GtkIconTheme* _tmp2_;
		GIcon* _tmp3_;
		GtkIconInfo* _tmp4_;
		GtkIconInfo* _tmp5_;
		GdkPixbuf* icon_pixbuf = NULL;
		GtkIconInfo* _tmp6_;
		GdkPixbuf* _tmp7_;
		GdkPixbuf* _tmp8_;
#line 110 "../../../src/ui/icon-cache-service.vala"
		_tmp0_ = g_icon_new_for_string (name, &_inner_error0_);
#line 110 "../../../src/ui/icon-cache-service.vala"
		icon = _tmp0_;
#line 110 "../../../src/ui/icon-cache-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 535 "icon-cache-service.c"
			goto __catch0_g_error;
		}
#line 111 "../../../src/ui/icon-cache-service.vala"
		_tmp1_ = icon;
#line 111 "../../../src/ui/icon-cache-service.vala"
		if (_tmp1_ == NULL) {
#line 111 "../../../src/ui/icon-cache-service.vala"
			result = NULL;
#line 111 "../../../src/ui/icon-cache-service.vala"
			_g_object_unref0 (icon);
#line 111 "../../../src/ui/icon-cache-service.vala"
			return result;
#line 548 "icon-cache-service.c"
		}
#line 113 "../../../src/ui/icon-cache-service.vala"
		_tmp2_ = self->priv->theme;
#line 113 "../../../src/ui/icon-cache-service.vala"
		_tmp3_ = icon;
#line 113 "../../../src/ui/icon-cache-service.vala"
		_tmp4_ = gtk_icon_theme_lookup_by_gicon (_tmp2_, _tmp3_, pixel_size, GTK_ICON_LOOKUP_FORCE_SIZE);
#line 113 "../../../src/ui/icon-cache-service.vala"
		iconinfo = _tmp4_;
#line 114 "../../../src/ui/icon-cache-service.vala"
		_tmp5_ = iconinfo;
#line 114 "../../../src/ui/icon-cache-service.vala"
		if (_tmp5_ == NULL) {
#line 114 "../../../src/ui/icon-cache-service.vala"
			result = NULL;
#line 114 "../../../src/ui/icon-cache-service.vala"
			_g_object_unref0 (iconinfo);
#line 114 "../../../src/ui/icon-cache-service.vala"
			_g_object_unref0 (icon);
#line 114 "../../../src/ui/icon-cache-service.vala"
			return result;
#line 570 "icon-cache-service.c"
		}
#line 116 "../../../src/ui/icon-cache-service.vala"
		_tmp6_ = iconinfo;
#line 116 "../../../src/ui/icon-cache-service.vala"
		_tmp7_ = gtk_icon_info_load_icon (_tmp6_, &_inner_error0_);
#line 116 "../../../src/ui/icon-cache-service.vala"
		icon_pixbuf = _tmp7_;
#line 116 "../../../src/ui/icon-cache-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 116 "../../../src/ui/icon-cache-service.vala"
			_g_object_unref0 (iconinfo);
#line 116 "../../../src/ui/icon-cache-service.vala"
			_g_object_unref0 (icon);
#line 584 "icon-cache-service.c"
			goto __catch0_g_error;
		}
#line 117 "../../../src/ui/icon-cache-service.vala"
		_tmp8_ = icon_pixbuf;
#line 117 "../../../src/ui/icon-cache-service.vala"
		if (_tmp8_ != NULL) {
#line 117 "../../../src/ui/icon-cache-service.vala"
			result = icon_pixbuf;
#line 117 "../../../src/ui/icon-cache-service.vala"
			_g_object_unref0 (iconinfo);
#line 117 "../../../src/ui/icon-cache-service.vala"
			_g_object_unref0 (icon);
#line 117 "../../../src/ui/icon-cache-service.vala"
			return result;
#line 599 "icon-cache-service.c"
		}
#line 109 "../../../src/ui/icon-cache-service.vala"
		_g_object_unref0 (icon_pixbuf);
#line 109 "../../../src/ui/icon-cache-service.vala"
		_g_object_unref0 (iconinfo);
#line 109 "../../../src/ui/icon-cache-service.vala"
		_g_object_unref0 (icon);
#line 607 "icon-cache-service.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 109 "../../../src/ui/icon-cache-service.vala"
		g_clear_error (&_inner_error0_);
#line 614 "icon-cache-service.c"
	}
	__finally0:
#line 109 "../../../src/ui/icon-cache-service.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 109 "../../../src/ui/icon-cache-service.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 109 "../../../src/ui/icon-cache-service.vala"
		g_clear_error (&_inner_error0_);
#line 109 "../../../src/ui/icon-cache-service.vala"
		return NULL;
#line 625 "icon-cache-service.c"
	}
#line 119 "../../../src/ui/icon-cache-service.vala"
	result = NULL;
#line 119 "../../../src/ui/icon-cache-service.vala"
	return result;
#line 631 "icon-cache-service.c"
}

static inline gpointer
synapse_gui_icon_cache_service_pixbuf_info_get_instance_private (SynapseGuiIconCacheServicePixbufInfo* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseGuiIconCacheServicePixbufInfo_private_offset);
}

static SynapseGuiIconCacheServicePixbufInfo*
synapse_gui_icon_cache_service_pixbuf_info_construct (GType object_type,
                                                      GdkPixbuf* pixbuf)
{
	SynapseGuiIconCacheServicePixbufInfo * self = NULL;
	GdkPixbuf* _tmp0_;
#line 50 "../../../src/ui/icon-cache-service.vala"
	g_return_val_if_fail (pixbuf != NULL, NULL);
#line 50 "../../../src/ui/icon-cache-service.vala"
	self = (SynapseGuiIconCacheServicePixbufInfo*) g_object_new (object_type, NULL);
#line 52 "../../../src/ui/icon-cache-service.vala"
	_tmp0_ = _g_object_ref0 (pixbuf);
#line 52 "../../../src/ui/icon-cache-service.vala"
	_g_object_unref0 (self->priv->_pixbuf);
#line 52 "../../../src/ui/icon-cache-service.vala"
	self->priv->_pixbuf = _tmp0_;
#line 50 "../../../src/ui/icon-cache-service.vala"
	return self;
#line 658 "icon-cache-service.c"
}

static SynapseGuiIconCacheServicePixbufInfo*
synapse_gui_icon_cache_service_pixbuf_info_new (GdkPixbuf* pixbuf)
{
#line 50 "../../../src/ui/icon-cache-service.vala"
	return synapse_gui_icon_cache_service_pixbuf_info_construct (SYNAPSE_GUI_ICON_CACHE_SERVICE_TYPE_PIXBUF_INFO, pixbuf);
#line 666 "icon-cache-service.c"
}

static GdkPixbuf*
synapse_gui_icon_cache_service_pixbuf_info_get_pixbuf (SynapseGuiIconCacheServicePixbufInfo* self)
{
	GdkPixbuf* result;
	time_t _tmp0_;
	GdkPixbuf* _tmp1_;
#line 43 "../../../src/ui/icon-cache-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 44 "../../../src/ui/icon-cache-service.vala"
	_tmp0_ = time (NULL);
#line 44 "../../../src/ui/icon-cache-service.vala"
	self->last_time_used = _tmp0_;
#line 45 "../../../src/ui/icon-cache-service.vala"
	_tmp1_ = self->priv->_pixbuf;
#line 45 "../../../src/ui/icon-cache-service.vala"
	result = _tmp1_;
#line 45 "../../../src/ui/icon-cache-service.vala"
	return result;
#line 687 "icon-cache-service.c"
}

static void
synapse_gui_icon_cache_service_pixbuf_info_class_init (SynapseGuiIconCacheServicePixbufInfoClass * klass,
                                                       gpointer klass_data)
{
#line 39 "../../../src/ui/icon-cache-service.vala"
	synapse_gui_icon_cache_service_pixbuf_info_parent_class = g_type_class_peek_parent (klass);
#line 39 "../../../src/ui/icon-cache-service.vala"
	g_type_class_adjust_private_offset (klass, &SynapseGuiIconCacheServicePixbufInfo_private_offset);
#line 39 "../../../src/ui/icon-cache-service.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_gui_icon_cache_service_pixbuf_info_get_property;
#line 39 "../../../src/ui/icon-cache-service.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_gui_icon_cache_service_pixbuf_info_finalize;
#line 39 "../../../src/ui/icon-cache-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_GUI_ICON_CACHE_SERVICE_PIXBUF_INFO_PIXBUF_PROPERTY, synapse_gui_icon_cache_service_pixbuf_info_properties[SYNAPSE_GUI_ICON_CACHE_SERVICE_PIXBUF_INFO_PIXBUF_PROPERTY] = g_param_spec_object ("pixbuf", "pixbuf", "pixbuf", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 704 "icon-cache-service.c"
}

static void
synapse_gui_icon_cache_service_pixbuf_info_instance_init (SynapseGuiIconCacheServicePixbufInfo * self,
                                                          gpointer klass)
{
#line 39 "../../../src/ui/icon-cache-service.vala"
	self->priv = synapse_gui_icon_cache_service_pixbuf_info_get_instance_private (self);
#line 713 "icon-cache-service.c"
}

static void
synapse_gui_icon_cache_service_pixbuf_info_finalize (GObject * obj)
{
	SynapseGuiIconCacheServicePixbufInfo * self;
#line 39 "../../../src/ui/icon-cache-service.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_GUI_ICON_CACHE_SERVICE_TYPE_PIXBUF_INFO, SynapseGuiIconCacheServicePixbufInfo);
#line 41 "../../../src/ui/icon-cache-service.vala"
	_g_object_unref0 (self->priv->_pixbuf);
#line 39 "../../../src/ui/icon-cache-service.vala"
	G_OBJECT_CLASS (synapse_gui_icon_cache_service_pixbuf_info_parent_class)->finalize (obj);
#line 726 "icon-cache-service.c"
}

static GType
synapse_gui_icon_cache_service_pixbuf_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseGuiIconCacheServicePixbufInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_gui_icon_cache_service_pixbuf_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseGuiIconCacheServicePixbufInfo), 0, (GInstanceInitFunc) synapse_gui_icon_cache_service_pixbuf_info_instance_init, NULL };
	GType synapse_gui_icon_cache_service_pixbuf_info_type_id;
	synapse_gui_icon_cache_service_pixbuf_info_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseGuiIconCacheServicePixbufInfo", &g_define_type_info, 0);
	SynapseGuiIconCacheServicePixbufInfo_private_offset = g_type_add_instance_private (synapse_gui_icon_cache_service_pixbuf_info_type_id, sizeof (SynapseGuiIconCacheServicePixbufInfoPrivate));
	return synapse_gui_icon_cache_service_pixbuf_info_type_id;
}

static GType
synapse_gui_icon_cache_service_pixbuf_info_get_type (void)
{
	static volatile gsize synapse_gui_icon_cache_service_pixbuf_info_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_gui_icon_cache_service_pixbuf_info_type_id__volatile)) {
		GType synapse_gui_icon_cache_service_pixbuf_info_type_id;
		synapse_gui_icon_cache_service_pixbuf_info_type_id = synapse_gui_icon_cache_service_pixbuf_info_get_type_once ();
		g_once_init_leave (&synapse_gui_icon_cache_service_pixbuf_info_type_id__volatile, synapse_gui_icon_cache_service_pixbuf_info_type_id);
	}
	return synapse_gui_icon_cache_service_pixbuf_info_type_id__volatile;
}

static void
_vala_synapse_gui_icon_cache_service_pixbuf_info_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec)
{
	SynapseGuiIconCacheServicePixbufInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_GUI_ICON_CACHE_SERVICE_TYPE_PIXBUF_INFO, SynapseGuiIconCacheServicePixbufInfo);
#line 39 "../../../src/ui/icon-cache-service.vala"
	switch (property_id) {
#line 39 "../../../src/ui/icon-cache-service.vala"
		case SYNAPSE_GUI_ICON_CACHE_SERVICE_PIXBUF_INFO_PIXBUF_PROPERTY:
#line 39 "../../../src/ui/icon-cache-service.vala"
		g_value_set_object (value, synapse_gui_icon_cache_service_pixbuf_info_get_pixbuf (self));
#line 39 "../../../src/ui/icon-cache-service.vala"
		break;
#line 767 "icon-cache-service.c"
		default:
#line 39 "../../../src/ui/icon-cache-service.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 39 "../../../src/ui/icon-cache-service.vala"
		break;
#line 773 "icon-cache-service.c"
	}
}

static void
_synapse_gui_icon_cache_service_clear_cache_gtk_icon_theme_changed (GtkIconTheme* _sender,
                                                                    gpointer self)
{
#line 63 "../../../src/ui/icon-cache-service.vala"
	synapse_gui_icon_cache_service_clear_cache ((SynapseGuiIconCacheService*) self);
#line 783 "icon-cache-service.c"
}

static GObject *
synapse_gui_icon_cache_service_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseGuiIconCacheService * self;
	SynapseGuiIconCacheService* _tmp0_;
	GtkIconTheme* _tmp1_;
	GtkIconTheme* _tmp2_;
	GtkIconTheme* _tmp3_;
	GeeHashMap* _tmp4_;
#line 59 "../../../src/ui/icon-cache-service.vala"
	parent_class = G_OBJECT_CLASS (synapse_gui_icon_cache_service_parent_class);
#line 59 "../../../src/ui/icon-cache-service.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 59 "../../../src/ui/icon-cache-service.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_GUI_TYPE_ICON_CACHE_SERVICE, SynapseGuiIconCacheService);
#line 61 "../../../src/ui/icon-cache-service.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 61 "../../../src/ui/icon-cache-service.vala"
	_g_object_unref0 (synapse_gui_icon_cache_service_instance);
#line 61 "../../../src/ui/icon-cache-service.vala"
	synapse_gui_icon_cache_service_instance = _tmp0_;
#line 62 "../../../src/ui/icon-cache-service.vala"
	_tmp1_ = gtk_icon_theme_get_default ();
#line 62 "../../../src/ui/icon-cache-service.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 62 "../../../src/ui/icon-cache-service.vala"
	_g_object_unref0 (self->priv->theme);
#line 62 "../../../src/ui/icon-cache-service.vala"
	self->priv->theme = _tmp2_;
#line 63 "../../../src/ui/icon-cache-service.vala"
	_tmp3_ = self->priv->theme;
#line 63 "../../../src/ui/icon-cache-service.vala"
	g_signal_connect_object (_tmp3_, "changed", (GCallback) _synapse_gui_icon_cache_service_clear_cache_gtk_icon_theme_changed, self, 0);
#line 64 "../../../src/ui/icon-cache-service.vala"
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SYNAPSE_GUI_ICON_CACHE_SERVICE_TYPE_PIXBUF_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 64 "../../../src/ui/icon-cache-service.vala"
	_g_object_unref0 (self->priv->map);
#line 64 "../../../src/ui/icon-cache-service.vala"
	self->priv->map = (GeeMap*) _tmp4_;
#line 59 "../../../src/ui/icon-cache-service.vala"
	return obj;
#line 831 "icon-cache-service.c"
}

static void
synapse_gui_icon_cache_service_class_init (SynapseGuiIconCacheServiceClass * klass,
                                           gpointer klass_data)
{
#line 25 "../../../src/ui/icon-cache-service.vala"
	synapse_gui_icon_cache_service_parent_class = g_type_class_peek_parent (klass);
#line 25 "../../../src/ui/icon-cache-service.vala"
	g_type_class_adjust_private_offset (klass, &SynapseGuiIconCacheService_private_offset);
#line 25 "../../../src/ui/icon-cache-service.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_gui_icon_cache_service_constructor;
#line 25 "../../../src/ui/icon-cache-service.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_gui_icon_cache_service_finalize;
#line 846 "icon-cache-service.c"
}

static void
synapse_gui_icon_cache_service_instance_init (SynapseGuiIconCacheService * self,
                                              gpointer klass)
{
#line 25 "../../../src/ui/icon-cache-service.vala"
	self->priv = synapse_gui_icon_cache_service_get_instance_private (self);
#line 855 "icon-cache-service.c"
}

static void
synapse_gui_icon_cache_service_finalize (GObject * obj)
{
	SynapseGuiIconCacheService * self;
#line 25 "../../../src/ui/icon-cache-service.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_GUI_TYPE_ICON_CACHE_SERVICE, SynapseGuiIconCacheService);
#line 57 "../../../src/ui/icon-cache-service.vala"
	_g_object_unref0 (self->priv->map);
#line 58 "../../../src/ui/icon-cache-service.vala"
	_g_object_unref0 (self->priv->theme);
#line 25 "../../../src/ui/icon-cache-service.vala"
	G_OBJECT_CLASS (synapse_gui_icon_cache_service_parent_class)->finalize (obj);
#line 870 "icon-cache-service.c"
}

static GType
synapse_gui_icon_cache_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseGuiIconCacheServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_gui_icon_cache_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseGuiIconCacheService), 0, (GInstanceInitFunc) synapse_gui_icon_cache_service_instance_init, NULL };
	GType synapse_gui_icon_cache_service_type_id;
	synapse_gui_icon_cache_service_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseGuiIconCacheService", &g_define_type_info, 0);
	SynapseGuiIconCacheService_private_offset = g_type_add_instance_private (synapse_gui_icon_cache_service_type_id, sizeof (SynapseGuiIconCacheServicePrivate));
	return synapse_gui_icon_cache_service_type_id;
}

GType
synapse_gui_icon_cache_service_get_type (void)
{
	static volatile gsize synapse_gui_icon_cache_service_type_id__volatile = 0;
	if (g_once_init_enter (&synapse_gui_icon_cache_service_type_id__volatile)) {
		GType synapse_gui_icon_cache_service_type_id;
		synapse_gui_icon_cache_service_type_id = synapse_gui_icon_cache_service_get_type_once ();
		g_once_init_leave (&synapse_gui_icon_cache_service_type_id__volatile, synapse_gui_icon_cache_service_type_id);
	}
	return synapse_gui_icon_cache_service_type_id__volatile;
}

