# Locate libebur128 library  
# This module defines
# EBUR128_LIBRARY, the name of the library to link against
# EBUR128_FOUND, if false, do not try to link
# EBUR128_INCLUDE_DIR, where to find header
#
set(Ebur128_FOUND FALSE)

# First we try to use pkg-config to get the library information
find_package(PkgConfig)

if(PKG_CONFIG_FOUND)
  pkg_check_modules(Ebur128 libebur128)
endif(PKG_CONFIG_FOUND)

if(NOT Ebur128_FOUND)
    find_path(inc ebur128.h
      HINTS
      PATH_SUFFIXES include
      PATHS
      ~/Library/Frameworks
      /Library/Frameworks
      /usr/local
      /usr
      /sw
      /opt/local
      /opt/csw
      /opt
      /mingw
    )

    find_library(lib
      NAMES ebur128
      HINTS
      PATH_SUFFIXES lib64 lib
      PATHS
      /usr/local
      /usr
      /sw
      /opt/local
      /opt/csw
      /opt
      /mingw
    )

    if(lib AND inc)
      set(Ebur128_FOUND TRUE)
      set(Ebur128_LIBRARIES ${lib})
      set(Ebur128_INCLUDEDIR ${inc})
    endif()
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(Ebur128 DEFAULT_MSG Ebur128_FOUND Ebur128_INCLUDEDIR Ebur128_LIBRARIES)
